       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02348.                                         
       DATE-WRITTEN.  01/20/97.                                         
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S348                                           *        
      *  PROGRAM:       S348                                           *        
      *  CALLING SP:    PA_S348                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROCEDURE IS USED TO UPDATE FIELDS ON CSS_ACCOUNT.       *        
      *  WHEN CALLED FROM PANEL 199, CODES_DATA_PRESENT IS UPDATED.    *        
      *  WHEN CALLED FROM PANEL 090, CODE_TEMP_BILL IS UPDATED.        *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  01/20/97    SAG      PROCEDURE ORIGINALLY CODED.              *        
C27363*  04/14/03    FMB      SET CODE_ACCT_BILLED FROM PANEL090.      *        
C27363*                       DELETE FROM OFF CYCLE FROM PANEL090.     *        
C29811*  09/14/04    MSR      DO NOT SET THE ACCOUNT IN THE TEMPORARY  *        
C29811*                       BILL PULL GROUP WHEN HI/LO IS OVERRODE.  *        
REARCH*  02/02/06    CVNS     RPC TO COBOL DB2 SP CONVERSION.          *        
REARCH*              CHENNAI                                           *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02348'.
MSQ017     COPY MFASQLM.
                                                                        
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    ACCOUNT - AT                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    OFF CYCLE OC                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBOFFCYL                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COMMON COPYLIBS                                             *        
      ******************************************************************        
                                                                        
      * -- COBOL EQUATES FOR SYBASE OPEN SERVER FOR CICS FACILITIES             
REARCH*    COPY SYGWCOB.                                                        
                                                                        
      * -- SUPPORT FOR CICS RPCS                                                
REARCH*    COPY SYDBCOB.                                                        
                                                                        
      * -- ERROR HANDLING                                                       
REARCH*    COPY CWS00010.                                                       
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CWSX0010                                                  
REARCH     END-EXEC.                                                            
                                                                        
           COPY CWS00056.                                                       
                                                                        
      * -- SUPPORTS DB2 AND SQL ERROR CHECKING                                  
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
REARCH*01  GW-LIB-MISC-FIELDS.                                                  
REARCH*    05  GWL-PROC                     POINTER.                            
REARCH*    05  GWL-INIT-HANDLE              POINTER.                            
REARCH*    05  GWL-RC                       PIC S9(9) COMP.                     
REARCH*    05  GWL-STATUS-NR                PIC S9(9) COMP.                     
REARCH*    05  GWL-STATUS-DONE              PIC S9(9) COMP.                     
REARCH*    05  GWL-STATUS-COUNT             PIC S9(9) COMP.                     
REARCH*    05  GWL-STATUS-COMM              PIC S9(9) COMP.                     
REARCH*    05  GWL-STATUS-RETURN-CODE       PIC S9(9) COMP.                     
REARCH*    05  GWL-STATUS-SUBCODE           PIC S9(9) COMP.                     
REARCH                                                                  
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH      05  GTT-NAME                PIC X(26)                       
REARCH                                  VALUE 'SESSION.CSR02348_R1'.    
REARCH      05  GTT-ROW.                                                
REARCH          49 GTT-ROW-LEN          PIC S9(04) COMP.                
REARCH          49 GTT-ROW-CHAR         PIC X(1024).                    
REARCH      05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  MESSAGE-FIELDS.                                              
           05  MSG-TYPE                     PIC S9(9) COMP.             
           05  MSG-SEVERITY                 PIC S9(9) COMP VALUE 11.    
           05  MSG-NR                       PIC S9(9) COMP VALUE  2.    
           05  MSG-RPC                      PIC X(4) VALUE 'S348'.      
           05  MSG-RPC-L                    PIC S9(9) COMP.             
           05  MSG-TEXT                     PIC X(100).                 
           05  MSG-TEXT-L                   PIC S9(9) COMP.             
           05  MSG-SQL-ERROR.                                           
               10  FILLER                   PIC X(10)                   
                                            VALUE 'SQLCODE = '.         
               10  MSG-SQL-ERROR-C          PIC -9(3) DISPLAY.          
               10  FILLER                   PIC X(16)                   
                   VALUE ', ERROR TOKENS: '.                            
               10  MSG-SQL-ERROR-K          PIC X(70).                  
               10  MSG-SQL-ERROR-K-CHARS                                
                                            REDEFINES MSG-SQL-ERROR-K   
                                            OCCURS 70 TIMES             
                                            PIC X.                      
           05  MSG-SQL-ERROR-SS             PIC S9(4) COMP.             
                                                                        
      ******************************************************************        
      *    INPUT PARAMETERS                                            *        
      ******************************************************************        
                                                                        
       01  PARM-FIELDS.                                                 
REARCH*    05  PARM-L                       PIC S9(9) COMP.                     
REARCH*    05  PARM-ID1                     PIC S9(9) COMP VALUE 1.             
REARCH*    05  PARM-ACCT-NO                 PIC X(13).                          
REARCH     05  PARM-ACCT-NO-TEMP            PIC X(13).                  
REARCH     05  PARM-ACCT-NO-NUM             REDEFINES PARM-ACCT-NO-TEMP 
                                            PIC 9(13).                  
REARCH*    05  PARM-RED-FLAG                PIC X(1).                           
REARCH*    05  PARM-PANEL-NO                PIC X(08).                          
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                     PIC S9(9) COMP.             
           05  SNA-CONNECTION-NAME          PIC X(8)  VALUE SPACE.      
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                   PIC S9(9) COMP VALUE 1.     
           05  CTR-ROWS                     PIC S9(9) COMP VALUE 0.     
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM              PIC S9(9) COMP.             
           05  WRKLEN1                      PIC S9(9) COMP.             
           05  WRKLEN2                      PIC S9(9) COMP.             
           05  WRK-DONE-STATUS              PIC S9(9) COMP.             
                                                                        
      ******************************************************************        
      *    RESULT SET FIELDS                                           *        
      ******************************************************************        
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE               PIC S9(9) COMP.             
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE                PIC S9(9) COMP.             
REARCH                                                                  
      ******************************************************************        
      *    RESULT SET COLUMN NAMES                                     *        
      ******************************************************************        
                                                                        
REARCH*01  CN-COLUMN-NAMES.                                                     
REARCH*    05  CN-RETURN-CODE               PIC X(11)                           
REARCH*                                     VALUE 'RETURN_CODE'.                
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW                  PIC X VALUE 'N'.            
               88  NOT-ALL-DONE             VALUE 'N'.                  
               88  ALL-DONE                 VALUE 'Y'.                  
           05  SEND-DONE-SW                 PIC X VALUE 'Y'.            
               88  SEND-DONE-ERROR          VALUE 'N'.                  
               88  SEND-DONE-OK             VALUE 'Y'.                  
                                                                        
       01  WS-MISC-FIELDS.                                              
REARCH     05  PROGRAM-NAME                 PIC X(8) VALUE 'CSR02348'.  
                                                                        
REARCH 01  CSRERLOG-P.                                                  
REARCH      10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
REARCH      10  S-SQLCODE               PIC S9(9)      COMP VALUE 0.    
REARCH      10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
REARCH      10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
REARCH      10  S-HOST-VARIABLES.                                       
REARCH          49  S-HOST-VARIABLES-L  PIC S9(4)      USAGE COMP.      
REARCH          49  S-HOST-VARIABLES-V  PIC X(255).                     
REARCH      10  S-SQL-STATEMENT.                                        
REARCH          49  S-SQL-STATEMENT-L   PIC S9(4)      USAGE COMP.      
REARCH          49  S-SQL-STATEMENT-V   PIC X(255).                     
REARCH      10  S-SQL-DESCRIPTION.                                      
REARCH          49  S-SQL-DESCRIPTION-L PIC S9(4)      USAGE COMP.      
REARCH          49  S-SQL-DESCRIPTION-V PIC X(255).                     
REARCH                                                                  
HPCCDM*EJECT                                                            01870000
REARCH LINKAGE SECTION.                                                 
REARCH 01  PARM-ACCT-NO                  PIC X(13).                     
REARCH 01  PARM-RED-FLAG                 PIC X(1).                      
REARCH 01  PARM-PANEL-NO                 PIC X(08).                     
REARCH PROCEDURE DIVISION USING PARM-ACCT-NO                            
REARCH                         ,PARM-RED-FLAG                           
REARCH                         ,PARM-PANEL-NO.                          
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
           PERFORM 1000-PROCESS-INPUT         THRU 1000-EXIT.           
           PERFORM 2000-PROCESS-OUTPUT        THRU 2000-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
REARCH*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.             
REARCH*                                                                         
REARCH*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,             
REARCH*                          SNA-CONNECTION-NAME, SNA-SUBC.                 
REARCH*                                                                         
REARCH*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                              
REARCH*                                                                         
REARCH*    IF GWL-RC NOT = TDS-PARM-PRESENT                                     
REARCH*       MOVE PROGRAM-NAME                  TO ABEND-PROGRAM               
REARCH*       MOVE '0100'                        TO ACTIVE-PARAGRAPH            
REARCH*       MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION              
REARCH*       MOVE 'CICS TRANSACTION'   TO TABLE-1                              
REARCH*       MOVE GWL-RC                     TO WS-ACTIVE-RETURN-CODE          
REARCH*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
REARCH*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9999-EXIT                    
REARCH*    END-IF.                                                              
                                                                        
REARCH*    INITIALIZE TDS-RETURN-FIELDS.                                        
                                                                        
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARCH             :S-RETURN-CODE          AS  RETURN_CODE              
REARCH         FROM                                                     
REARCH             CIS.SYSDUMMY1                                     
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*            :S-RETURN-CODE          AS  RETURN_CODE                      
MFA-TR*        FROM                                                             
MFA-TR*            SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC.                                                            
REARCH                                                                  
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE EACH PARAMETER FROM THE REMOTE PROCEDURE        *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCT-NO               TO PARM-ACCT-NO-TEMP.        
                                                                        
REARCH*    MOVE 1                          TO PARM-ID1.                         
REARCH*    MOVE LENGTH OF PARM-ACCT-NO     TO MAX-LENGTH-PARM.                  
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-ACCT-NO,                                  
REARCH*                          TDSCHAR,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                         
           MOVE PARM-ACCT-NO-NUM           TO AT-ACCOUNT-NO             
                                              OC-ACCOUNT-NO.            
                                                                        
REARCH*                                                                         
REARCH*    ADD  1                          TO PARM-ID1.                         
REARCH*    MOVE LENGTH OF PARM-RED-FLAG    TO MAX-LENGTH-PARM.                  
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-RED-FLAG,                                 
REARCH*                          TDSCHAR,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                         
REARCH*    ADD  1                          TO PARM-ID1.                         
REARCH*    MOVE LENGTH OF PARM-PANEL-NO    TO MAX-LENGTH-PARM.                  
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-PANEL-NO,                                 
REARCH*                          TDSCHAR,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT                                            *        
      *                                                                *        
      *     DESCRIBE EACH COLUMN IN THE RESULT SET.                    *        
      *     BUILD THE RESULT SET.                                      *        
      *                                                                *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
REARCH*    PERFORM 2100-DESCRIBE-RESULT       THRU 2100-EXIT.                   
           PERFORM 2200-BUILD-RESULT          THRU 2200-EXIT.           
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************        
REARCH*2000A-MOVE-RESULT.                                                       
REARCH******************************************************************        
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE RS-RETURN-CODE         TO S-RETURN-CODE.                
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH******************************************************************05310000
      ******************************************************************        
      * 2100-DESCRIBE-RESULT                                           *        
      *                                                                *        
      *     DESCRIBE EACH COLUMN IN THE RESULT SET.                    *        
      *                                                                *        
      ******************************************************************        
REARCH*2100-DESCRIBE-RESULT.                                                    
REARCH*                                                                         
REARCH*    MOVE 1                             TO CTR-COLUMN.                    
REARCH*    MOVE TDSINT4                       TO DB-HOST-TYPE.                  
REARCH*    MOVE TDSINT4                       TO DB-CLIENT-TYPE.                
REARCH*    MOVE LENGTH OF RS-RETURN-CODE      TO WRKLEN1.                       
REARCH*    MOVE LENGTH OF CN-RETURN-CODE      TO WRKLEN2.                       
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-RETURN-CODE,                                
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-RETURN-CODE,                                
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR           THRU 9100-EXIT.                   
REARCH*                                                                         
REARCH*2100-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *                                                                *        
      *     BUILD THE RESULT SET.                                      *        
      *                                                                *        
      ******************************************************************        
       2200-BUILD-RESULT.                                               
                                                                        
           IF PARM-PANEL-NO = 'PANEL199'                                
              PERFORM 7000-SELECT-ACCOUNT      THRU 7000-EXIT           
              MOVE AT-CODES-DATA-PRESENT       TO WS-CODES-DATA-PRESENT 
              MOVE PARM-RED-FLAG               TO WS-CODE-RED-FLAG      
              MOVE WS-CODES-DATA-PRESENT       TO AT-CODES-DATA-PRESENT 
              PERFORM 8000-UPDATE-ACCOUNT      THRU 8000-EXIT           
           ELSE IF PARM-PANEL-NO = 'PANEL090'                           
              PERFORM 8010-UPDATE-ACCOUNT      THRU 8010-EXIT           
C27363        PERFORM 8020-DELETE-OFF-CYCLE    THRU 8020-EXIT           
           END-IF
           END-IF.                                                      
                                                                        
           MOVE 0                              TO RS-RETURN-CODE        
REARCH     PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT.         
REARCH     ADD +1                              TO CTR-ROWS.             
REARCH*    PERFORM 8100-SEND-RESULT            THRU 8100-EXIT.                  
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-SELECT-ACCOUNT                                            *        
      *                                                                *        
      *     SELECT CODES_DATA_PRESENT ON CSS_ACCOUNT                   *        
      *                                                                *        
      ******************************************************************        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
               SELECT CODES_DATA_PRESENT                                
                 INTO :AT-CODES-DATA-PRESENT                            
                 FROM CSS_ACCOUNT                                       
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '7000'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_ACCOUNT'             TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8000-UPDATE-ACCOUNT                                            *        
      *                                                                *        
      *     UPDATE CODES_DATA_PRESENT ON CSS_ACCOUNT                   *        
      *                                                                *        
      ******************************************************************        
       8000-UPDATE-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT       
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '8000'                    TO ACTIVE-PARAGRAPH       
               MOVE 'UPDATE'                  TO ABEND-FUNCTION         
               MOVE 'CSS_ACCOUNT'             TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8010-UPDATE-ACCOUNT                                            *        
      *                                                                *        
      *     UPDATE CODE_TEMP_BILL ON CSS_ACCOUNT.                      *        
      *                                                                *        
      ******************************************************************        
       8010-UPDATE-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
C29811*           SET CODE_TEMP_BILL   = 'T',                                   
C27363            SET CODE_ACCT_BILLED = 'H'                            
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '8010'                    TO ACTIVE-PARAGRAPH       
               MOVE 'UPDATE'                  TO ABEND-FUNCTION         
               MOVE 'CSS_ACCOUNT'             TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
                                                                        
C27363******************************************************************        
C27363* 8020-DELETE-OFF-CYCLE                                          *        
C27363*                                                                *        
C27363*     DELETE ACCOUNT ROW FROM CSS_OFF_CYCL_ACCT                  *        
C27363*                                                                *        
C27363******************************************************************        
C27363 8020-DELETE-OFF-CYCLE.                                           
C27363                                                                  
C27363     EXEC SQL                                                     
C27363         DELETE                                                   
C27363           FROM CSS_OFF_CYCL_ACCT                                 
C27363          WHERE ACCOUNT_NO = :OC-ACCOUNT-NO                       
C27363     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C27363                                                                  
C27363     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
C27363                                                                  
C27363     EVALUATE WS-ACTIVE-RETURN-CODE                               
C27363         WHEN SUCCESSFUL-CALL                                     
C27363         WHEN NOT-FOUND                                           
C27363             CONTINUE                                             
C27363         WHEN OTHER                                               
C27363             MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
C27363             MOVE '8020'                TO ACTIVE-PARAGRAPH       
C27363             MOVE 'DELETE'              TO ABEND-FUNCTION         
C27363             MOVE 'CSS_OFF_CYCL_ACCT'   TO TABLE-1                
C27363             MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
C27363             MOVE OC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
C27363             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
C27363             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
C27363     END-EVALUATE.                                                
C27363                                                                  
C27363 8020-EXIT.                                                       
C27363     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
REARCH*    EXEC SQL                                                             
REARCH*       INCLUDE CPD00300                                                  
REARCH*    END-EXEC.                                                            
                                                                        
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
REARCH*    COPY CPD00302.                                                       
REARCH                                                                  
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPD00321                                                  
REARCH     END-EXEC.                                                            
