       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02341.                                         
COB303 DATE-WRITTEN.  FEBRUARY 2013.                                    
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------*00000600
      *                                                                *00000700
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00000800
      *                                                                *00000900
      *----------------------------------------------------------------*00001000
      *                 P R O G R A M  S U M M A R Y                   *00001100
      *                                                                *00001200
      *  THIS PROGRAM POSTS PAYMENT, WRITES JOURNAL AND TRANSACTION    *00001300
      *  HISTORY.                                                      *00001400
      *                                                                *00001500
      *  BUSOP NAME: REQUPDPAYMENTPOSTING BUSINESSOP                   *00001600
      *----------------------------------------------------------------*00001700
      *                                                                *00001800
      *                     PROGRAM MODIFICATION LOG                   *00001900
      *                                                                *00002000
      *    DATE    INITIALS   COMMENTS                                 *00002100
      *  --------  --------   ---------------------------------------  *00002200
      *                                                                *00002300
P00586*  02/20/13  BASKAR V   CLONED PAYMENT POSTING PROGRAM CSR02347  *00002400
      *                       AND MADE CHANGES FOR CSR MODERNIZATION   *00002500
P00586*  01/28/14  BASKAR V   TO DETERMINE STA IS IN COMPLIANCE FOR SEB*00002600
      *                       BALANCE CREDIT GROUP USE TOTAL UTILITY   *00002700
      *                       BALANCE INSTEAD OF PAST DUE UTL BALANCE  *00002800
P00586*  07/08/14  ESM        ADDED COMMENTS TO CSS_CSH_DRWR_JRNL      *00002900
P00586*  03/23/15  CB18344    MADE CHANGE TO FIX ISSUE WITH ADVANCE    *00003000
P00586*                       COLLECTIONS.                             *00003100
PDSUPP*  06/11/15  CB18344    MADE CHANGE TO REMOVE CALL TO            *        
PDSUPP*                       2600-ADVCOLL-WORK-QUEUE. THESE WQ'S      *        
PDSUPP*                       AREN'T NEEDED IN MOD.                    *        
PDSUPP*  06/25/15  CB18344    MADE CHANGE TO REMOVE FIX ISSUE WITH MOD *        
PDSUPP*                       ADVANCE COLLECTION CONTRACT ITEM IDS.    *        
A05203*  03/24/15  GOKUL      CHANGE STA COMPLETION LOGIC TO HANDLE    *00003200
A05203*                       NEW TABLE STRUCTURE.                     *00003300
A5203A*  04/06/15  GOKUL      INCLUDE LOGIC TO COMPLETE CDD/CDDA.      *00003310
PDSUPP*  09/24/15  CB18344    MADE CHANGE TO REMOVE FIX ISSUE WITH ADJ *        
PDSUPP*                       ROW BEING CREATED WHEN PROCESSING        *        
PDSUPP*                       DIRECTED PAYMENTS WHEN ANY PORTION IS    *        
PDSUPP*                       DIRECTED TO CIA.                         *        
PDSUPP*                       DEFECT 8933                              *        
A5203B*  09/29/15  RICK       CHECK FOR BBP OFFER PAYMENT AND BBP      *        
A5203B*  ALSO DEFECT 9155     SETUP - IF SO GET CURRENT TIMESTAMP.     *        
ACT096*  03/22/16  TP7R341    WORK QUEUE CHANGE TO REPLACE THE         *        
ACT096*            A04860     CSS_WQ_ITEMS_MF WITH CSS_WQ_ITEMS.       *        
ACT216*  07/12/16  VIJAY      FOR STA COMPLETION MNT USE PAYMENT MNT + *        
ACT216*  A05460               1 MICRO SECOND TO FIX DISPLAY ISSUES     *        
ACT216*                       IN TRASACTION HISTORY VIEW.              *        
P00948*  07/15/16  AA97148    LEAST AMOUNT TO PAY CHANGES.             *        
ACT285*  10/21/16  AA97148    REPLACE CPD03413 WITH NEW COPYBOOK       *        
ACT285*                       CPD03414. Ref:APPL00005460               *        
P00948*  01/01/17  VENKAT.P   SEND DNP CANCEL NOTIFICATION E-MAIL FOR  *        
P00948*                       CUSTOMERS WITH E-MAIL ADDRESS.           *        
      *----------------------------------------------------------------*00003400
      *----------------------------------------------------------------*00003500
      *                                                                *00003600
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00003700
      *                                                                *00003800
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00003900
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00004000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00004100
      *  3000 - 4999  NOT USED                                         *00004200
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00004300
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00004400
      *  7000 - 7999  INPUT MODULES                                    *00004500
      *  8000 - 8999  OUTPUT MODULES                                   *00004600
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00004700
      *                                                                *00004800
      *----------------------------------------------------------------*00004900
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02341'.
MSQ017     COPY MFASQLM.
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR02341 STARTS HERE'.                  
                                                                        
           COPY CWS00004.                                               00005800
           COPY CWS00007.                                               00005900
           COPY CWS00056.                                               00006000
           COPY CWS00303.                                               00006100
           COPY CWS00100.                                               00006200
           COPY CWS0068L.                                               00006300
           COPY CWS0061L.                                               00006400
           COPY CJF00101.                                               00006500
           COPY CJF00102.                                               00006600
           COPY CJF00105.                                               00006700
           COPY CWSCA225.                                               00006800
ACT096     COPY CWS00077.                                                       
                                                                        
           EXEC SQL                                                     00007000
               INCLUDE CWSX0010                                         00007100
           END-EXEC.                                                    00007200
                                                                        
ACT285*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
ACT285*    WS VARIABLE FOR COPY BOOK CPD03414                         *         
ACT285*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
ACT285                                                                  
ACT285     EXEC SQL                                                             
ACT285      INCLUDE CWS03414                                                    
ACT285     END-EXEC.                                                            
ACT285                                                                  
      *----------------------------------------------------------------*00007400
      *    WORK AREAS                                                  *00007500
      *----------------------------------------------------------------*00007600
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR02341'.     
           05  EIBTRNID                 PIC X(04) VALUE 'S341'.         
P00586     05  MISTRNID                 PIC X(04) VALUE 'M341'.         
ACT285     05  MCS03414                 PIC X(08) VALUE 'MCS03414'.     
           05  WS-CNT-ITEM-ID           PIC S9(9) COMP  VALUE +0.       
           05  WS-CANCELDNP-FLAG        PIC X(01) VALUE SPACES.         
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  WS-DATE-ORIG-PYMT-IND    PIC S9(4) COMP VALUE +0.        
           05  WS-DNP-RET-CODE          PIC S9(4) VALUE 0 COMP.         
           05  WS-BANKRUPT-CAT-ID       PIC S9(4) COMP VALUE +398.      
           05  WS-ADVCOLL-CAT-ID        PIC S9(4) COMP VALUE +66.       
           05  WS-BANKRUPT-WQ-AMT       PIC 9(09)V99 VALUE ZERO.        
           05  WS-STA-AMOUNT            PIC ZZZZZZZZ9.99.               
           05  WS-HOLD-STA-AMOUNT       PIC ZZZZZZZZ9.99.               
           05  WS-AMT-TO-COMPLY         PIC S9(09)V99 COMP-3 VALUE 0.   
           05  WS-HOLD-CMPLD-IND        PIC X(01) VALUE SPACES.         
ACT285     05 WS-PYMT-AMOUNT            PIC S9(09)V99 COMP-3 VALUE +0.  
ACT285     05 WS-PROGRAM-NAME           PIC X(08) VALUE SPACES.         
ACT285     05 WS-UPDATE-ACTION-FL       PIC X(01) VALUE SPACES.         
A5203A     05 WS-TOTAL-ARREARS          PIC S9(9)V99 COMP-3 VALUE 0.    
           05  WS-HOLD-AGREEMENT.                                       
               10 WS-HOLD-AGREE-TEXT    PIC X(12) VALUE 'AGREEMNT NO '. 
               10 WS-HOLD-AGREE-NO      PIC 9(3)  VALUE ZERO.           
           05  WS-SUB                   PIC S9(4) COMP VALUE +0.        
           05  WS-FIRST-PAYMENT         PIC X(01) VALUE 'Y'.            
               88  FIRST-PAYMENT                  VALUE 'Y'.            
           05  WS-CNT-NAME-CD           PIC 9(04) VALUE 0.              
PDSUPP     05  WS-MIN-CIS-CNT-ID        PIC S9(9)  COMP   VALUE 5000000.
PDSUPP     05  WS-ADV-COLL-ITEM-ID      PIC S9(9) COMP  VALUE +0.       
P00948     05  WS-LEAST-AMT-DUE-CD       PIC X(13)  VALUE               
P00948                                       'LEAST-AMT-DUE'.           
P00948     05  WS-LEAST-AMOUNT-DUE      PIC S9(4)V9(5) USAGE COMP-3     
P00948                                            VALUE 0.              
                                                                        
           05  WS-DIR-PAY-TABLE.                                        
               10  WS-DIR-PAY-TAB OCCURS 20 TIMES.                      
                   15  WS-DIR-PAY-REC-TYPE   PIC S9(04) COMP.           
                   15  WS-DIR-PAY-ITEM-ID    PIC S9(09) COMP.           
COB305             15 WS-DIR-PAY-AMT        PIC S9(09)V99 COMP-3 
COB305               VALUE 0.      
                   15  WS-DIR-PAY-AHEAD-TYPE PIC  X(01).                
                   15  WS-DIR-PAY-CHRG-OFF   PIC  X(01).                
                   15  WS-DIR-PAY-ADV-COLL   PIC  X(01).                
                                                                        
           05  WS-ENTRY-NO-CHAR         PIC X(07).                      
           05  WS-ENTRY-NO REDEFINES WS-ENTRY-NO-CHAR                   
                                        PIC 9(07).                      
           05  WS-ACCOUNT-NO            PIC X(13).                      
           05  WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO                
                                        PIC 9(13).                      
COB305     05 WS-ACCOUNT-NO-COMP3        PIC S9(13) COMP-3 VALUE 0.             
                                                                        
           05  WS-AMOUNT-CHECK          PIC  X(11).                     
           05  WS-AMOUNT-CHECK-NUM REDEFINES WS-AMOUNT-CHECK            
                                        PIC  9(09)V99.                  
           05  WS-AMOUNT-CHECK-COMP3    PIC S9(09)V99 COMP-3 VALUE +0.  
                                                                        
           05  WS-AMOUNT-MORDER         PIC  X(11).                     
           05  WS-AMOUNT-MORDER-NUM REDEFINES WS-AMOUNT-MORDER          
                                        PIC  9(09)V99.                  
           05  WS-AMOUNT-MORDER-COMP3   PIC S9(09)V99 COMP-3 VALUE +0.  
                                                                        
           05  WS-AMOUNT-LIHEAP         PIC  X(11).                     
           05  WS-AMOUNT-LIHEAP-NUM REDEFINES WS-AMOUNT-LIHEAP          
                                        PIC  9(09)V99.                  
           05  WS-AMOUNT-LIHEAP-COMP3   PIC S9(09)V99 COMP-3 VALUE +0.  
                                                                        
           05  WS-AMOUNT-CASH           PIC  X(11).                     
           05  WS-AMOUNT-CASH-NUM REDEFINES WS-AMOUNT-CASH              
                                        PIC  9(09)V99.                  
           05  WS-AMOUNT-CASH-COMP3     PIC S9(09)V99 COMP-3 VALUE +0.  
                                                                        
           05  WS-AMT-CHRG-CARD         PIC  X(11).                     
           05  WS-AMT-CHRG-CARD-NUM REDEFINES WS-AMT-CHRG-CARD          
                                        PIC  9(09)V99.                  
           05  WS-AMT-CHRG-CARD-COMP3   PIC S9(09)V99 COMP-3 VALUE +0.  
                                                                        
           05  WS-TOTAL-CHRG-OFF        PIC S9(11)V99 COMP-3 VALUE +0.  
                                                                        
           05  WS-DIR-PAYMENT-BREAKDOWN.                                
               10  WS-REV-TYPE          PIC  X(04).                     
               10  WS-REV-TYPE-NUM REDEFINES WS-REV-TYPE                
                                        PIC S9(04).                     
               10  WS-ITEM-ID           PIC  X(09).                     
               10  WS-AMT-DIR-PYMT      PIC  X(11).                     
               10  WS-AMT-DIR-PYMT-NUM REDEFINES WS-AMT-DIR-PYMT        
                                        PIC S9(09)V99.                  
               10  WS-PAY-AHEAD-TYPE    PIC  X(01).                     
               10  WS-PAY-CHRG-OFF      PIC  X(01).                     
               10  WS-PAY-ADV-COLL      PIC  X(01).                     
                                                                        
           05  WS-ITEM-ID-PARM          PIC  X(09).                     
           05  WS-ITEM-ID-NUM REDEFINES WS-ITEM-ID-PARM                 
                                        PIC S9(09).                     
           05  WS-CURRENT-DATE          PIC  X(10) VALUE SPACES.        
           05  WS-CURRENT-TIMESTAMP     PIC  X(26) VALUE SPACES.        
           05  WS-LAST-UPDATE-TS        PIC  X(26).                     
           05  WS-ADV-COLL-FLAG         PIC  X(01) VALUE 'N'.           
           05  WS-ADD                   PIC  S9(4) COMP VALUE +0.       
A5203B     05 WS-BBP-SETUP              PIC  X(01) VALUE SPACES.        
A5203B        88 BBP-SETUP-NO                      VALUE 'N'.           
A5203B        88 BBP-SETUP-YES                     VALUE 'Y'.           
ACT096     05  WS-WQ-CALL-PGM           PIC  X(08) VALUE 'MCSCB077'.    
ACT096     05  MCSCB077                 PIC  X(08) VALUE 'MCSCB077'.    
ACT096     05  SCSCB077                 PIC  X(08) VALUE 'SCSCB077'.    
ACT096     05  WS-CPD0010S-CALL-TYPE    PIC  X(01) VALUE 'O'.           
ACT096         88 WS-CPD0010S-ONLINE-CALL          VALUE 'O'.           
ACT096         88 WS-CPD0010S-BATCH-CALL           VALUE 'B'.           
                                                                        
       01  WS-LITERAL.                                                  
           05  WS-A                     PIC X(01) VALUE 'A'.            
           05  WS-C                     PIC X(01) VALUE 'C'.            
           05  WS-D                     PIC X(01) VALUE 'D'.            
           05  WS-N                     PIC X(01) VALUE 'N'.            
           05  WS-U                     PIC X(01) VALUE 'U'.            
           05  WS-Y                     PIC X(01) VALUE 'Y'.            
           05  WS-01                    PIC X(02)  VALUE '01'.          
           05  WS-3                     PIC X(01)  VALUE '3'.           
           05  WS-4                     PIC X(01)  VALUE '4'.           
           05  WS-NO                    PIC  X(01) VALUE 'N'.           
           05  WS-YES                   PIC  X(01) VALUE 'Y'.           
           05  MCSCA182                 PIC  X(08) VALUE 'MCSCA182'.    
           05  MCSCO061                 PIC  X(08) VALUE 'MCSCO061'.    
           05  MCSCB225                 PIC X(8) VALUE  'MCSCB225'.     
           05  WS-COG-TRAN-TYPE-CD-73   PIC X(1) VALUE  'P'.            
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WS-BANKRUPT-WQ-MSG.                                          
           05  WS-BANKRUPT-WQ-TXT1     PIC X(28) VALUE                  
               'A PAYMENT IN THE AMOUNT OF $'.                          
           05  WS-BANKRUPT-WQ-AMT-DISP PIC ZZZZZZZZ9.99.                
           05  WS-BANKRUPT-WQ-TXT2     PIC X(45) VALUE                  
               ' POSTED FOR AN ACCOUNT FLAGGED AS BANKRUPTCY.'.         
           05  FILLER                  PIC X(04) VALUE SPACES.          
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(09) COMP   VALUE +0.     
           05  RS-ACCOUNT-NO            PIC X(13)    VALUE SPACE.       
           05  RS-AMT-THIS-MONTH        PIC S9(11)V99 COMP-3 VALUE +0.  
           05  RS-ADV-COLL-TIMESTAMP    PIC X(26)    VALUE SPACES.      
           05  RS-ERROR-MESSAGE1        PIC X(05)    VALUE SPACES.      
           05  RS-ERROR-MESSAGE2        PIC X(05)    VALUE SPACES.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(09) COMP   VALUE +0.      
           05  S-ACCOUNT-NO            PIC X(13)    VALUE SPACE.        
           05  S-AMT-THIS-MONTH        PIC S9(11)V99 COMP-3 VALUE +0.   
           05  S-ADV-COLL-TIMESTAMP    PIC X(26)    VALUE SPACES.       
           05  S-ERROR-MESSAGE1        PIC X(05)    VALUE SPACES.       
           05  S-ERROR-MESSAGE2        PIC X(05)    VALUE SPACES.       
                                                                        
       01  WS-PAYMENT-TYPE             PIC X(01)   VALUE SPACES.        
                                                                        
       01  WS-NULL-DATE.                                                
           05  WS-NULL-INDICATOR-1      PIC S9(04) COMP VALUE +0.       
           05  WS-NULL-INDICATOR-2      PIC S9(04) COMP VALUE +0.       
           05  WS-NULL-INDICATOR-3      PIC S9(04) COMP VALUE +0.       
           05  WS-NULL-INDICATOR-4      PIC S9(04) COMP VALUE +0.       
           05  WS-NULL-INDICATOR-5      PIC S9(04) COMP VALUE +0.       
PDSUPP     05  WS-NULL-INDICATOR-6      PIC S9(04) COMP VALUE +0.       
           05  WS-NULL-IND              PIC S9(04) COMP VALUE -1.       
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
           10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
           10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
           10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
      *                                                                 00028300
       COPY CWS00182.                                                   00028400
                                                                        
           EXEC SQL                                                     00028600
              INCLUDE SQLCA                                             00028700
           END-EXEC.                                                    00028800
                                                                        
      *    CSS_CNT_DETAIL                                               00029000
           EXEC SQL                                                     00029100
              INCLUDE TBCNTDET                                          00029200
           END-EXEC.                                                    00029300
                                                                        
      *    CSS_BUDGET_PLAN                                              00029500
           EXEC SQL                                                     00029600
              INCLUDE TBBGTPLN                                          00029700
           END-EXEC.                                                    00029800
                                                                        
      *    CSS_LOCAL_OFFICE                                             00031000
           EXEC SQL                                                     00031100
              INCLUDE TBLOCOFC                                          00031200
           END-EXEC.                                                    00031300
                                                                        
      *    CSS_BUDGET_HIST                                              00031500
           EXEC SQL                                                     00031600
              INCLUDE TBBGTHST                                          00031700
           END-EXEC.                                                    00031800
                                                                        
      *    CSS_LIEAP                                                    00032500
           EXEC SQL                                                     00032600
              INCLUDE TBLIEAP                                           00032700
           END-EXEC.                                                    00032800
                                                                        
      *    CSS_DEP_ON_HAND                                              00033500
           EXEC SQL                                                     00033600
              INCLUDE TBDEPHND                                          00033700
           END-EXEC.                                                    00033800
                                                                        
      *    CSS_ACCOUNT                                                  00034000
           EXEC SQL                                                     00034100
              INCLUDE TBACCT                                            00034200
           END-EXEC.                                                    00034300
                                                                        
      *    CSS_CUSTOMER                                                 00034500
           EXEC SQL                                                     00034600
              INCLUDE TBCUST                                            00034700
           END-EXEC.                                                    00034800
                                                                        
      *    CSS_PREMISE                                                  00035000
           EXEC SQL                                                     00035100
              INCLUDE TBPREM                                            00035200
           END-EXEC.                                                    00035300
                                                                        
      *    CSS_AR_CNTL                                                  00035500
           EXEC SQL                                                     00035600
              INCLUDE TBARCNTL                                          00035700
           END-EXEC.                                                    00035800
                                                                        
      *    CSS_CONTRACT                                                 00036000
           EXEC SQL                                                     00036100
              INCLUDE TBCNTRCT                                          00036200
           END-EXEC.                                                    00036300
                                                                        
      *    CSS_DFA_ACCT                                                 00036500
           EXEC SQL                                                     00036600
              INCLUDE TBDFAACT                                          00036700
           END-EXEC.                                                    00036800
                                                                        
      *    CSS_AR_TRANS_HIST                                            00037000
           EXEC SQL                                                     00037100
              INCLUDE TBARHIST                                          00037200
           END-EXEC.                                                    00037300
                                                                        
      *    CSS_AR_TRN_HST_DET                                           00037500
           EXEC SQL                                                     00037600
              INCLUDE TBARHDT                                           00037700
           END-EXEC.                                                    00037800
                                                                        
      *    CSS_CSH_DRWR_CNTL                                            00038000
           EXEC SQL                                                     00038100
              INCLUDE TBCDCNTL                                          00038200
           END-EXEC.                                                    00038300
                                                                        
      *    CSS_CSH_DRWR_JRNL                                            00038500
           EXEC SQL                                                     00038600
              INCLUDE TBCDJRNL                                          00038700
           END-EXEC.                                                    00038800
                                                                        
      *    CSS_BCH_JRNL_CNTL                                            00039000
           EXEC SQL                                                     00039100
              INCLUDE TBBJCNTL                                          00039200
           END-EXEC.                                                    00039300
                                                                        
      *    CSS_BATCH_JRNL                                               00039500
           EXEC SQL                                                     00039600
              INCLUDE TBBTJRNL                                          00039700
           END-EXEC.                                                    00039800
                                                                        
      *    CSS_MISC_JRNL                                                00040000
           EXEC SQL                                                     00040100
              INCLUDE TBMSJRNL                                          00040200
           END-EXEC.                                                    00040300
                                                                        
      *    CSS_USER_PROFILE                                             00040500
           EXEC SQL                                                     00040600
              INCLUDE TBUSRPRF                                          00040700
           END-EXEC.                                                    00040800
                                                                        
      *    CSS_PROJ_SHARE                                               00041000
           EXEC SQL                                                     00041100
              INCLUDE TBPRJSHR                                          00041200
           END-EXEC.                                                    00041300
                                                                        
      *    CSS_DFA_RECVBLE                                              00041500
           EXEC SQL                                                     00041600
              INCLUDE TBDFARCV                                          00041700
           END-EXEC.                                                    00041800
                                                                        
      *    CSS_AR_PMT_PRTY                                              00042000
           EXEC SQL                                                     00042100
              INCLUDE TBARPMT                                           00042200
           END-EXEC.                                                    00042300
                                                                        
      *    CSS_GL_ACCT_NO                                               00042500
           EXEC SQL                                                     00042600
              INCLUDE TBGLATNO                                          00042700
           END-EXEC.                                                    00042800
                                                                        
      *    CSS_CREDIT_PROFILE                                           00043500
           EXEC SQL                                                     00043600
              INCLUDE TBCRPROF                                          00043700
           END-EXEC.                                                    00043800
                                                                        
      *    CSS_DEP_PAY_HST                                              00044000
           EXEC SQL                                                     00044100
              INCLUDE TBDEPHST                                          00044200
           END-EXEC.                                                    00044300
                                                                        
      *    CSS_RECONNECT                                                00044500
           EXEC SQL                                                     00044600
              INCLUDE TBRECNCT                                          00044700
           END-EXEC.                                                    00044800
                                                                        
      *    CSS_CHRG_OFF                                                 00045000
           EXEC SQL                                                     00045100
              INCLUDE TBCHGOFF                                          00045200
           END-EXEC.                                                    00045300
                                                                        
      *    CSS_AR_LOCKOUT                                               00045500
           EXEC SQL                                                     00045600
              INCLUDE TBARLOCK                                          00045700
           END-EXEC.                                                    00045800
                                                                        
      *    CSS_DELINQUENCY                                              00046000
           EXEC SQL                                                     00046100
              INCLUDE TBDELQ                                            00046200
           END-EXEC.                                                    00046300
                                                                        
      *    CSS_SO_DNP_CANCEL                                            00046500
           EXEC SQL                                                     00046600
              INCLUDE TBSODNPC                                          00046700
           END-EXEC.                                                    00046800
                                                                        
      *    CSS_HOLIDAY                                                  00047500
           EXEC SQL                                                     00047600
               INCLUDE TBHLDAY                                          00047700
           END-EXEC.                                                    00047800
                                                                        
      *    CSS_WO_ARRANGEMENT                                           00048900
                                                                        
           EXEC SQL                                                     00049100
               INCLUDE TBWOARGM                                         00049200
           END-EXEC.                                                    00049300
                                                                        
      *    CSS_CONNECT_CHRG                                             00049500
                                                                        
           EXEC SQL                                                     00049700
               INCLUDE TBCCCHRG                                         00049800
           END-EXEC.                                                    00049900
                                                                        
      *    CSS_RECONNECT_CHRG                                           00050100
           EXEC SQL                                                     00050200
               INCLUDE TBRCNCHR                                         00050300
           END-EXEC.                                                    00050400
                                                                        
      * CSS_MNT_TRANS_HIST                                              00050600
           EXEC SQL                                                     00050700
              INCLUDE TBMNHIST                                          00050800
           END-EXEC.                                                    00050900
                                                                        
      * CSS_MT_TRN_HST_DET                                              00051100
           EXEC SQL                                                     00051200
              INCLUDE TBMNHDT                                           00051300
           END-EXEC.                                                    00051400
                                                                        
      * CSS_PAYMENT_TRANS                                               00051600
           EXEC SQL                                                     00051700
              INCLUDE TBPMTRAN                                          00051800
           END-EXEC.                                                    00051900
                                                                        
      *    CSS_BUSINESS_DAYS                                          * 00052100
           EXEC SQL                                                     00052200
            INCLUDE TBBUSDAY                                            00052300
           END-EXEC.                                                    00052400
                                                                        
      *    COMPUTE REBATE-AMOUNT                                        00052600
           EXEC SQL                                                     00052700
              INCLUDE CWS00008                                          00052800
           END-EXEC.                                                    00052900
                                                                        
      *    COMMON JRNL-ROUTINE                                          00053100
           EXEC SQL                                                     00053200
              INCLUDE CWS0013B                                          00053300
           END-EXEC.                                                    00053400
                                                                        
      *    'PAR' FOR PAYMENT ROUTINE                                    00053600
           EXEC SQL                                                     00053700
              INCLUDE CWS00017                                          00053800
           END-EXEC.                                                    00053900
                                                                        
      *    WS FOR GENERAL LEDGER                                        00054100
           EXEC SQL                                                     00054200
              INCLUDE CWS00061                                          00054300
           END-EXEC.                                                    00054400
                                                                        
      *    WS FOR PAR - CHARGE-OFF RECEIVABLES                          00055100
           EXEC SQL                                                     00055200
              INCLUDE CWS00073                                          00055300
           END-EXEC.                                                    00055400
                                                                        
      *    CSS_JOB_PARM                                                 00055600
           EXEC SQL                                                     00055700
             INCLUDE TBJBPARM                                           00055800
           END-EXEC.                                                    00055900
                                                                        
      *    HOLIDAY CHECK                                                00056100
           EXEC SQL                                                     00056200
               INCLUDE CWS10016                                         00056300
           END-EXEC.                                                    00056400
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-BYPASS-WARNING      PIC  X(01).                         
       01  PARM-UPDATE-TYPE         PIC  X(01).                         
       01  PARM-ACCOUNT-NO          PIC  X(13).                         
       01  PARM-FACILITY-CODE       PIC  X(01).                         
       01  PARM-PAYMENT-TYPE        PIC  X(01).                         
       01  PARM-AMT-CHECK           PIC  X(11).                         
       01  PARM-AMT-MONEY-ORDER     PIC  X(11).                         
       01  PARM-AMT-LIHEAP          PIC  X(11).                         
       01  PARM-CHRG-CARD-TYPE      PIC  X(01).                         
       01  PARM-AMT-CHRG-CARD       PIC  X(11).                         
       01  PARM-AMT-CASH            PIC  X(11).                         
       01  PARM-NO-ROWS             PIC S9(04) COMP.                    
       01  PARM-DIR-PAY-1           PIC  X(27).                         
       01  PARM-DIR-PAY-2           PIC  X(27).                         
       01  PARM-DIR-PAY-3           PIC  X(27).                         
       01  PARM-DIR-PAY-4           PIC  X(27).                         
       01  PARM-DIR-PAY-5           PIC  X(27).                         
       01  PARM-DIR-PAY-6           PIC  X(27).                         
       01  PARM-DIR-PAY-7           PIC  X(27).                         
       01  PARM-DIR-PAY-8           PIC  X(27).                         
       01  PARM-DIR-PAY-9           PIC  X(27).                         
       01  PARM-DIR-PAY-10          PIC  X(27).                         
       01  PARM-DIR-PAY-11          PIC  X(27).                         
       01  PARM-DIR-PAY-12          PIC  X(27).                         
       01  PARM-DIR-PAY-13          PIC  X(27).                         
       01  PARM-DIR-PAY-14          PIC  X(27).                         
       01  PARM-DIR-PAY-15          PIC  X(27).                         
       01  PARM-DIR-PAY-16          PIC  X(27).                         
       01  PARM-DIR-PAY-17          PIC  X(27).                         
       01  PARM-DIR-PAY-18          PIC  X(27).                         
       01  PARM-DIR-PAY-19          PIC  X(27).                         
       01  PARM-DIR-PAY-20          PIC  X(27).                         
       01  PARM-USER-ID             PIC  X(07).                         
       01  PARM-PANEL-NO            PIC  X(09).                         
       01  PARM-DATE-CASH-REPORT    PIC  X(10).                         
       01  PARM-CASH-COMPANY-NO     PIC  X(02).                         
       01  PARM-CASH-LOCAL-OFFICE   PIC  X(03).                         
       01  PARM-CASH-DRAWER-ID      PIC S9(04) COMP.                    
       01  PARM-CASH-REPORT-NO      PIC  X(03).                         
       01  PARM-CONTRACT-TYPE       PIC  X(01).                         
       01  PARM-CONTRACT-NAME       PIC  X(04).                         
       01  PARM-CNT-CMMNT-LEN       PIC S9(4) COMP SYNC.                
       01  PARM-CNT-CMMNT-TXT       PIC  X(210).                        
       01  PARM-PYMT-RCPT-PRNTD-CD  PIC  X(01).                         
       01  PARM-LAST-UPDATE-TS      PIC  X(26).                         
                                                                        
       PROCEDURE DIVISION USING  PARM-BYPASS-WARNING                    
                                 PARM-UPDATE-TYPE                       
                                 PARM-ACCOUNT-NO                        
                                 PARM-FACILITY-CODE                     
                                 PARM-PAYMENT-TYPE                      
                                 PARM-AMT-CHECK                         
                                 PARM-AMT-MONEY-ORDER                   
                                 PARM-AMT-LIHEAP                        
                                 PARM-CHRG-CARD-TYPE                    
                                 PARM-AMT-CHRG-CARD                     
                                 PARM-AMT-CASH                          
                                 PARM-NO-ROWS                           
                                 PARM-DIR-PAY-1                         
                                 PARM-DIR-PAY-2                         
                                 PARM-DIR-PAY-3                         
                                 PARM-DIR-PAY-4                         
                                 PARM-DIR-PAY-5                         
                                 PARM-DIR-PAY-6                         
                                 PARM-DIR-PAY-7                         
                                 PARM-DIR-PAY-8                         
                                 PARM-DIR-PAY-9                         
                                 PARM-DIR-PAY-10                        
                                 PARM-DIR-PAY-11                        
                                 PARM-DIR-PAY-12                        
                                 PARM-DIR-PAY-13                        
                                 PARM-DIR-PAY-14                        
                                 PARM-DIR-PAY-15                        
                                 PARM-DIR-PAY-16                        
                                 PARM-DIR-PAY-17                        
                                 PARM-DIR-PAY-18                        
                                 PARM-DIR-PAY-19                        
                                 PARM-DIR-PAY-20                        
                                 PARM-USER-ID                           
                                 PARM-PANEL-NO                          
                                 PARM-DATE-CASH-REPORT                  
                                 PARM-CASH-COMPANY-NO                   
                                 PARM-CASH-LOCAL-OFFICE                 
                                 PARM-CASH-DRAWER-ID                    
                                 PARM-CASH-REPORT-NO                    
                                 PARM-CONTRACT-TYPE                     
                                 PARM-CONTRACT-NAME                     
                                 PARM-CNT-CMMNT-LEN                     
                                 PARM-CNT-CMMNT-TXT                     
                                 PARM-PYMT-RCPT-PRNTD-CD                
                                 PARM-LAST-UPDATE-TS.                   
                                                                        
      *----------------------------------------------------------------*00073100
      *                                                                *00073200
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *00073300
      *----------------------------------------------------------------*00073400
                                                                        
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT                   
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT                   
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT                   
           .                                                            
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*00074400
      * INITIALIZE AND DECLARE OUTPUT CURSOR                           *00074500
      *----------------------------------------------------------------*00074600
                                                                        
       0100-INITIALIZE.                                                 
           MOVE '0100' TO ACTIVE-PARAGRAPH                              
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC               
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC               
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC               
           PERFORM 0100A-DECLARE-CUR     THRU 0100A-EXIT                
           INITIALIZE SCSCA182-LINK-RECORD                              
           .                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00075800
       0100A-DECLARE-CUR.                                               
      *                                                                 00076000
            EXEC SQL                                                    
             DECLARE C1 CURSOR  FOR                          
              SELECT  :S-RETURN-CODE               AS RETURN_CODE       
                     ,:S-ACCOUNT-NO                AS ACCOUNT_NO        
                     ,:S-AMT-THIS-MONTH            AS AMT_THIS_MTH      
                     ,LTRIM(RTRIM(:S-ADV-COLL-TIMESTAMP)) AS 
           ADV_COLL_TIMESTMP 
                     ,LTRIM(RTRIM(:S-ERROR-MESSAGE1))     AS 
           ERROR_MESSAGE1    
                     ,LTRIM(RTRIM(:S-ERROR-MESSAGE2))     AS 
           ERROR_MESSAGE2    
                FROM CIS.SYSDUMMY1                                   
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*     EXEC SQL                                                    00076100
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                          00076200
MFA-TR*       SELECT  :S-RETURN-CODE               AS RETURN_CODE       00076300
MFA-TR*              ,:S-ACCOUNT-NO                AS ACCOUNT_NO        00076400
MFA-TR*              ,:S-AMT-THIS-MONTH            AS AMT_THIS_MTH      00076500
MFA-TR*              ,STRIP(:S-ADV-COLL-TIMESTAMP) AS ADV_COLL_TIMESTMP 00076600
MFA-TR*              ,STRIP(:S-ERROR-MESSAGE1)     AS ERROR_MESSAGE1    00076700
MFA-TR*              ,STRIP(:S-ERROR-MESSAGE2)     AS ERROR_MESSAGE2    00076800
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                   00076900
MFA-TR*     END-EXEC                                                    00077000
            .                                                           
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *----------------------------------------------------------------*00077500
      *  MAIN PROCESS PARAGRAPH FOR POSTING THE PAYMENT,STA COMPLETION *00077600
      *  AND CREDIT ACTION UPDATE                                      *00077700
      *                                                                *00077800
      *----------------------------------------------------------------*00077900
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000' TO ACTIVE-PARAGRAPH                              
                                                                        
           IF PARM-BYPASS-WARNING = 'C'                                 
              MOVE WS-C  TO WS-JRNL-OPER-ACTIVE                         
              MOVE 'S351' TO EIBTRNID                                   
           END-IF.                                                      
           MOVE PARM-ACCOUNT-NO         TO WS-ACCOUNT-NO                
                                           RS-ACCOUNT-NO                
                                           SCSCA182-ACCOUNT-NO          
                                                                        
      * DO NOT PROCEED IF SYSTEM IS LOCKED                              00078900
           PERFORM 7999-SELECT-AL THRU 7999-SELECT-AL-EXIT              
           IF AL-AR-LOCKOUT-IND = 'Y'                                   
              MOVE 5000 TO RS-ERROR-MESSAGE1                            
              PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
              ADD +1  TO CTR-ROWS                                       
              PERFORM 9999-END-PROGRAM  THRU 9999-EXIT                  
           END-IF                                                       
                                                                        
           PERFORM 9200-LINK-SCSCA182       THRU 9200-EXIT              
           IF SCSCA182-RETURN-CODE NOT EQUAL TO ZERO                    
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE SCSCA182-RETURN-CODE     TO WS-ACTIVE-RETURN-CODE    
                                               SQLCODE                  
               PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT             
               ADD +1  TO CTR-ROWS                                      
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           ELSE                                                         
              MOVE SCSCA182-LAST-UPDATE-TS     TO WS-LAST-UPDATE-TS     
              IF PARM-LAST-UPDATE-TS = WS-LAST-UPDATE-TS                
              OR PARM-LAST-UPDATE-TS = 'STRESS'                         
                 CONTINUE                                               
              ELSE                                                      
                 MOVE 5272                   TO RS-ERROR-MESSAGE1       
                 PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT            
                 ADD +1  TO CTR-ROWS                                    
                 GO TO 2000-EXIT                                        
              END-IF                                                    
           END-IF                                                       
                                                                        
           PERFORM 2200-PROCESS THRU 2200-EXIT                          
                                                                        
           PERFORM 2500-WQ-PROCESS                                      
              THRU 2500-EXIT                                            
                                                                        
A5203B* IF BBP SETUP THEN GET NEW TIMESTAMP FOR TRANS HIST KEY          13361000
A5203B     IF BBP-SETUP-YES AND WS-CODE-BUDGET = 'A'                    
A5203B       AND AT-EPP-OFFER-AMOUNT = 0                                
A5203B        PERFORM 6791A-GET-TIMESTAMP THRU 6791A-EXIT               
A5203B     END-IF.                                                      
A5203B*                                                                         
                                                                        
           PERFORM 2400-MOVE-PYMT-TRANS-VALUE                           
              THRU 2400-EXIT                                            
           PERFORM 8700-INSERT-PAYMENT-TRANS                            
              THRU 8700-EXIT                                            
                                                                        
           PERFORM 8999-ISSUE-COMMIT THRU 8999-EXIT                     
ACT285     PERFORM 2950-PROCESS-DNP-RECONNECT THRU 2950-EXIT            
ACT285     MOVE WS-CNCL-DNP-ACTN-FL TO WS-CANCELDNP-FLAG                
                                                                        
ACT285     IF WS-CANCELDNP-FLAG = 'Y'                                   
ACT285        PERFORM 8100-UPDATE-DNP-CODE   THRU 8100-EXIT             
ACT285     END-IF                                                       
           MOVE ZERO                  TO RS-RETURN-CODE                 
                                                                        
           PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                    
           ADD +1  TO CTR-ROWS                                          
           .                                                            
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 00085300
      * MOVE THE RETURN VALUE                                         * 00085400
      *---------------------------------------------------------------* 00085500
       2000A-MOVE-RESULT.                                               
      *                                                                 00085700
            MOVE  RS-RETURN-CODE           TO S-RETURN-CODE             
            MOVE  RS-ACCOUNT-NO            TO S-ACCOUNT-NO              
            MOVE  RS-AMT-THIS-MONTH        TO S-AMT-THIS-MONTH          
            MOVE  RS-ADV-COLL-TIMESTAMP    TO S-ADV-COLL-TIMESTAMP      
            MOVE  RS-ERROR-MESSAGE1        TO S-ERROR-MESSAGE1          
            MOVE  RS-ERROR-MESSAGE2        TO S-ERROR-MESSAGE2          
            .                                                           
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
       2200-PROCESS.                                                    
           MOVE WS-ACCOUNT-NO-NUM   TO WS-ACCOUNT-NO-COMP3              
           MOVE WS-ACCOUNT-NO-COMP3 TO AT-ACCOUNT-NO                    
           PERFORM 7000-SELECT-AT-PR-CU THRU 7000-EXIT                  
                                                                        
           MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT          
A5203B*                                                                         
A5203B     IF WS-CODE-BUDGET NOT = 'A' AND AT-EPP-OFFER-AMOUNT > 0      
A5203B        MOVE 'Y' TO WS-BBP-SETUP                                  
A5203B     ELSE                                                         
A5203B        MOVE 'N' TO WS-BBP-SETUP                                  
A5203B     END-IF.                                                      
                                                                        
      * MOVE NUMERIC FIELD AMONG WORKING STORAGE FIELDS BECAUSE THEY    00087500
      * WERE PASSED AS CHARACTER, NOT NUMERIC.                          00087600
           MOVE PARM-AMT-CHECK        TO WS-AMOUNT-CHECK                
           MOVE WS-AMOUNT-CHECK-NUM   TO WS-AMOUNT-CHECK-COMP3          
           MOVE WS-AMOUNT-CHECK-COMP3 TO WS-AMT-CHECK                   
                                                                        
           IF PARM-LAST-UPDATE-TS = 'STRESS'                            
              IF AT-TOTAL-AR-BALANCE > 0                                
                 MOVE AT-TOTAL-AR-BALANCE TO WS-AMT-CHECK               
                                             WS-AMOUNT-CHECK-COMP3      
              ELSE                                                      
                 MOVE 10                  TO WS-AMT-CHECK               
                                             WS-AMOUNT-CHECK-COMP3      
              END-IF                                                    
           END-IF                                                       
                                                                        
           MOVE PARM-AMT-MONEY-ORDER   TO WS-AMOUNT-MORDER              
           MOVE WS-AMOUNT-MORDER-NUM   TO WS-AMOUNT-MORDER-COMP3        
           MOVE WS-AMOUNT-MORDER-COMP3 TO WS-AMT-MONEY-ORDER            
                                                                        
           MOVE PARM-AMT-LIHEAP        TO WS-AMOUNT-LIHEAP              
           MOVE WS-AMOUNT-LIHEAP-NUM   TO WS-AMOUNT-LIHEAP-COMP3        
           MOVE WS-AMOUNT-LIHEAP-COMP3 TO WS-AMT-LIHEAP                 
                                                                        
           MOVE PARM-AMT-CASH        TO WS-AMOUNT-CASH                  
           MOVE WS-AMOUNT-CASH-NUM   TO WS-AMOUNT-CASH-COMP3            
           MOVE WS-AMOUNT-CASH-COMP3 TO WS-AMT-CASH                     
                                                                        
           MOVE PARM-AMT-CHRG-CARD     TO WS-AMT-CHRG-CARD              
           MOVE WS-AMT-CHRG-CARD-NUM   TO WS-AMT-CHRG-CARD-COMP3        
           MOVE WS-AMT-CHRG-CARD-COMP3 TO WS-AMT-CREDIT-CARD            
                                                                        
           ADD WS-AMOUNT-CHECK-COMP3                                    
               WS-AMOUNT-MORDER-COMP3                                   
               WS-AMOUNT-LIHEAP-COMP3                                   
               WS-AMOUNT-CASH-COMP3                                     
               WS-AMT-CHRG-CARD-COMP3 GIVING WS-PAYMENT-AMOUNT          
                                             WS-PAYMENT-AMOUNT-TOTAL    
                                                                        
           MOVE WS-N TO WS-PYMT-THRU-PANEL115                           
                        WS-EPP-CORR-ELIG                                
                                                                        
           MOVE PARM-CASH-COMPANY-NO    TO CS-CASH-COMPANY-NO           
           MOVE PARM-CASH-LOCAL-OFFICE  TO CS-CASH-LOCAL-OFFICE         
           MOVE PARM-CASH-REPORT-NO     TO CS-CASH-REPORT-NO            
           MOVE PARM-DATE-CASH-REPORT   TO CS-DATE-CASH-REPORT          
           MOVE PARM-CASH-DRAWER-ID     TO CS-CASH-DRAWER-ID            
           PERFORM 7500-SELECT-CASH-CNTRL THRU 7500-EXIT                
                                                                        
           IF PARM-NO-ROWS GREATER THAN ZEROES                          
              PERFORM 2220-LOAD-DIR-PYMT-TABLE THRU 2220-EXIT           
           END-IF                                                       
                                                                        
      * GET G/L ACCOUNT NUMBER                                          00092800
           PERFORM 2205-LOAD-GL-NUMBERS THRU 2205-EXIT                  
                                                                        
      * DEBIT CASH                                                      00093100
           MOVE PARM-PAYMENT-TYPE    TO WS-PAYMENT-TYPE                 
           IF WS-PAYMENT-TYPE = 'L'                                     
              MOVE WS-CLR-LIHEAP-GL-NO(WS-GL-SUB) TO WS-PAR-GEN-LEDG-DB 
           ELSE                                                         
              MOVE WS-CLR-CASH-GL-NO (WS-GL-SUB) TO WS-PAR-GEN-LEDG-DB  
           END-IF                                                       
                                                                        
      * LOAD DIRECTED PAYMENT OR PAYMENT PRIORITY TABLE                 00093900
      * HOWEVER, IF RECONNECT ROW EXISTS, PAYMENT PRIORITY TABLE        00094000
      * WILL BE USED TO APPLY PAYMENT EVEN WHEN DIRECTED IS SPECIFIED   00094100
                                                                        
           MOVE AT-ACCOUNT-NO TO DL-ACCOUNT-NO                          
           PERFORM 7170-SELECT-RECONNECT THRU 7170-EXIT                 
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE WS-Y        TO WS-PAR-RECONNECT-EXIST                
           ELSE                                                         
              MOVE WS-N        TO WS-PAR-RECONNECT-EXIST                
           END-IF                                                       
                                                                        
           MOVE PARM-UPDATE-TYPE TO WS-PAR-UPDATE-TYPE                  
           IF PARM-UPDATE-TYPE EQUAL WS-D                               
              IF WS-PAR-RECONNECT-EXIST EQUAL WS-Y                      
                 MOVE WS-NO  TO WS-IS-THIS-DIRECTED-PYMT                
                 PERFORM 2210-LOAD-PYMT-PRIORITY THRU 2210-EXIT         
              ELSE                                                      
                 MOVE WS-YES TO WS-IS-THIS-DIRECTED-PYMT                
              END-IF                                                    
           ELSE                                                         
              MOVE WS-NO  TO WS-IS-THIS-DIRECTED-PYMT                   
              PERFORM 2210-LOAD-PYMT-PRIORITY THRU 2210-EXIT            
           END-IF                                                       
                                                                        
           MOVE SPACES         TO RS-ERROR-MESSAGE1                     
                                  WS-PAR-MESSAGE-NO                     
           MOVE PARM-CNT-CMMNT-LEN TO WS-PAR-AR-TRAN-COMMENT-LEN        
           MOVE PARM-CNT-CMMNT-TXT TO WS-PAR-AR-TRAN-COMMENT-TEXT       
           PERFORM 5000-UPDATE THRU 5000-EXIT                           
                                                                        
           MOVE WS-PAR-MESSAGE-NO TO RS-ERROR-MESSAGE1                  
                                                                        
           PERFORM 7400-DETERMINE-TOTAL-CO-AMT THRU 7400-EXIT           
           IF WS-NULL-INDICATOR-5 < 0                                   
              MOVE ZERO TO WS-TOTAL-CHRG-OFF                            
           END-IF                                                       
           COMPUTE RS-AMT-THIS-MONTH = AT-TOTAL-AR-BALANCE +            
                                       WS-TOTAL-CHRG-OFF                
                                                                        
           MOVE WS-CURRENT-TIMESTAMP    TO RS-ADV-COLL-TIMESTAMP        
           IF WS-ADV-COLL-FLAG NOT EQUAL WS-YES                         
              MOVE ZEROES              TO WS-CNT-ITEM-ID                
           END-IF                                                       
           .                                                            
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *------------------------------------------------*                00101900
      * LOAD ALL G/L NUMBER, INCLUDEING CHARGED OFF.   *                00102000
      *------------------------------------------------*                00102100
       2205-LOAD-GL-NUMBERS.                                            
           PERFORM 9400-CALL-CPD00061 THRU 9400-EXIT                    
                                                                        
           PERFORM VARYING WS-GL-SUB FROM 1 BY 1 UNTIL WS-GL-SUB > 5    
             OR WS-VALID-CO-NO (WS-VALID-CO-SUB) = '01'                 
             OR WS-VALID-CO-NO (WS-VALID-CO-SUB) = WS-GL-99             
             IF WS-VALID-CO-NO (WS-VALID-CO-SUB) = '01'                 
                MOVE WS-Y TO WS-COMPANY-IN-TABLE                        
             END-IF                                                     
           END-PERFORM                                                  
           .                                                            
       2205-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *------------------------------------------------------*          00103600
      * LOAD THE PAYMENT PRIORITY TABLE                      *          00103700
      * USE PARM-UPDATE-TYPE TO DECIDE WHICH SET TO LOAD:    *          00103800
      * B FOR BILLED, A FOR ARREARS, AND U FOR UNDIRECTED.   *          00103900
      * SCHEDULE 1 IS FOR BILLED AND UNDIRECTED DUE TO THE   *          00104000
      * ORDER PAYMENT IS POSTED.  SCHEDULE 2 IS FOR ARREARS  *          00104100
      * WHICH PAYS OFF ALL 90 DAY FIRST, THEN 60 DAYS, ETC.  *          00104200
      *------------------------------------------------------*          00104300
       2210-LOAD-PYMT-PRIORITY.                                         
           IF PARM-UPDATE-TYPE EQUAL WS-A                               
              MOVE 2 TO C9-PMT-PRTY-SCHEDULE                            
           ELSE                                                         
              MOVE 1 TO C9-PMT-PRTY-SCHEDULE                            
           END-IF                                                       
           PERFORM 6722B-OPEN-AR-PMT-PRTY  THRU 6722B-EXIT              
           PERFORM 6722C-FETCH-AR-PMT-PRTY THRU 6722C-EXIT              
           PERFORM 6722D-LOAD-AR-PMT-PRTY  THRU 6722D-EXIT              
              VARYING WS-PAR-SUB FROM 1 BY 1                            
                 UNTIL WS-PAR-SUB GREATER THAN 52                       
                    OR WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND            
           PERFORM 6722E-CLOSE-AR-PMT-PRTY THRU 6722E-EXIT              
           .                                                            
       2210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 00106100
      * RECEIVE THE DIRECTED PAYMENT VALUES FROM INPUT PARM FOR       * 00106200
      * PROCESSING                                                    * 00106300
      *---------------------------------------------------------------* 00106400
       2220-LOAD-DIR-PYMT-TABLE.                                        
      * ADDED WS-PAY-ADV-COLL TO WS-DIR-PAYMENT-BREAKDOWN               00106600
           IF PARM-DIR-PAY-1 EQUAL SPACES                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-DIR-PAY-1      TO WS-DIR-PAYMENT-BREAKDOWN      
              MOVE WS-REV-TYPE-NUM     TO WS-DIR-PAY-REC-TYPE (1)       
PDSUPP        IF WS-PAY-ADV-COLL = 'Y'                                  
PDSUPP           PERFORM 7100-SELECT-NEW-ITEM-ID THRU 7100-EXIT         
PDSUPP           MOVE WS-ADV-COLL-ITEM-ID TO WS-ITEM-ID-NUM             
PDSUPP        ELSE                                                      
PDSUPP           MOVE WS-ITEM-ID          TO WS-ITEM-ID-PARM            
PDSUPP        END-IF                                                    
              MOVE WS-ITEM-ID-NUM      TO WS-DIR-PAY-ITEM-ID(1)         
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-DIR-PAY-AMT (1)            
              MOVE WS-PAY-AHEAD-TYPE   TO WS-DIR-PAY-AHEAD-TYPE (1)     
              MOVE WS-PAY-CHRG-OFF     TO WS-DIR-PAY-CHRG-OFF (1)       
              IF WS-PAY-CHRG-OFF = 'Y'                                  
                 ADD WS-AMT-DIR-PYMT-NUM TO WS-PAR-AMT-TOT-CO           
              END-IF                                                    
              MOVE WS-PAY-ADV-COLL     TO WS-DIR-PAY-ADV-COLL (1)       
           END-IF                                                       
                                                                        
           IF PARM-DIR-PAY-2 EQUAL SPACES                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-DIR-PAY-2      TO WS-DIR-PAYMENT-BREAKDOWN      
              MOVE WS-REV-TYPE-NUM     TO WS-DIR-PAY-REC-TYPE (2)       
PDSUPP        IF WS-PAY-ADV-COLL = 'Y'                                  
PDSUPP           PERFORM 7100-SELECT-NEW-ITEM-ID THRU 7100-EXIT         
PDSUPP           MOVE WS-ADV-COLL-ITEM-ID TO WS-ITEM-ID-NUM             
PDSUPP        ELSE                                                      
PDSUPP           MOVE WS-ITEM-ID          TO WS-ITEM-ID-PARM            
PDSUPP        END-IF                                                    
              MOVE WS-ITEM-ID-NUM      TO WS-DIR-PAY-ITEM-ID (2)        
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-DIR-PAY-AMT (2)            
              MOVE WS-PAY-AHEAD-TYPE   TO WS-DIR-PAY-AHEAD-TYPE (2)     
              MOVE WS-PAY-CHRG-OFF     TO WS-DIR-PAY-CHRG-OFF (2)       
              IF WS-PAY-CHRG-OFF = 'Y'                                  
                 ADD WS-AMT-DIR-PYMT-NUM TO WS-PAR-AMT-TOT-CO           
              END-IF                                                    
              MOVE WS-PAY-ADV-COLL     TO WS-DIR-PAY-ADV-COLL (2)       
           END-IF                                                       
                                                                        
           IF PARM-DIR-PAY-3 EQUAL SPACES                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-DIR-PAY-3      TO WS-DIR-PAYMENT-BREAKDOWN      
              MOVE WS-REV-TYPE-NUM     TO WS-DIR-PAY-REC-TYPE (3)       
PDSUPP        IF WS-PAY-ADV-COLL = 'Y'                                  
PDSUPP           PERFORM 7100-SELECT-NEW-ITEM-ID THRU 7100-EXIT         
PDSUPP           MOVE WS-ADV-COLL-ITEM-ID TO WS-ITEM-ID-NUM             
PDSUPP        ELSE                                                      
PDSUPP           MOVE WS-ITEM-ID          TO WS-ITEM-ID-PARM            
PDSUPP        END-IF                                                    
              MOVE WS-ITEM-ID-NUM      TO WS-DIR-PAY-ITEM-ID (3)        
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-DIR-PAY-AMT (3)            
              MOVE WS-PAY-AHEAD-TYPE   TO WS-DIR-PAY-AHEAD-TYPE (3)     
              MOVE WS-PAY-CHRG-OFF     TO WS-DIR-PAY-CHRG-OFF (3)       
              IF WS-PAY-CHRG-OFF = 'Y'                                  
                 ADD WS-AMT-DIR-PYMT-NUM TO WS-PAR-AMT-TOT-CO           
              END-IF                                                    
              MOVE WS-PAY-ADV-COLL     TO WS-DIR-PAY-ADV-COLL (3)       
           END-IF                                                       
                                                                        
           IF PARM-DIR-PAY-4 EQUAL SPACES                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-DIR-PAY-4      TO WS-DIR-PAYMENT-BREAKDOWN      
              MOVE WS-REV-TYPE-NUM     TO WS-DIR-PAY-REC-TYPE (4)       
PDSUPP        IF WS-PAY-ADV-COLL = 'Y'                                  
PDSUPP           PERFORM 7100-SELECT-NEW-ITEM-ID THRU 7100-EXIT         
PDSUPP           MOVE WS-ADV-COLL-ITEM-ID TO WS-ITEM-ID-NUM             
PDSUPP        ELSE                                                      
PDSUPP           MOVE WS-ITEM-ID          TO WS-ITEM-ID-PARM            
PDSUPP        END-IF                                                    
              MOVE WS-ITEM-ID-NUM      TO WS-DIR-PAY-ITEM-ID (4)        
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-DIR-PAY-AMT (4)            
              MOVE WS-PAY-AHEAD-TYPE   TO WS-DIR-PAY-AHEAD-TYPE (4)     
              MOVE WS-PAY-CHRG-OFF     TO WS-DIR-PAY-CHRG-OFF (4)       
              IF WS-PAY-CHRG-OFF = 'Y'                                  
                 ADD WS-AMT-DIR-PYMT-NUM TO WS-PAR-AMT-TOT-CO           
              END-IF                                                    
              MOVE WS-PAY-ADV-COLL     TO WS-DIR-PAY-ADV-COLL (4)       
           END-IF                                                       
                                                                        
           IF PARM-DIR-PAY-5 EQUAL SPACES                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-DIR-PAY-5      TO WS-DIR-PAYMENT-BREAKDOWN      
              MOVE WS-REV-TYPE-NUM     TO WS-DIR-PAY-REC-TYPE (5)       
PDSUPP        IF WS-PAY-ADV-COLL = 'Y'                                  
PDSUPP           PERFORM 7100-SELECT-NEW-ITEM-ID THRU 7100-EXIT         
PDSUPP           MOVE WS-ADV-COLL-ITEM-ID TO WS-ITEM-ID-NUM             
PDSUPP        ELSE                                                      
PDSUPP           MOVE WS-ITEM-ID          TO WS-ITEM-ID-PARM            
PDSUPP        END-IF                                                    
              MOVE WS-ITEM-ID-NUM      TO WS-DIR-PAY-ITEM-ID (5)        
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-DIR-PAY-AMT (5)            
              MOVE WS-PAY-AHEAD-TYPE   TO WS-DIR-PAY-AHEAD-TYPE (5)     
              MOVE WS-PAY-CHRG-OFF     TO WS-DIR-PAY-CHRG-OFF (5)       
              IF WS-PAY-CHRG-OFF = 'Y'                                  
                 ADD WS-AMT-DIR-PYMT-NUM TO WS-PAR-AMT-TOT-CO           
              END-IF                                                    
              MOVE WS-PAY-ADV-COLL     TO WS-DIR-PAY-ADV-COLL (5)       
           END-IF                                                       
                                                                        
           IF PARM-DIR-PAY-6 EQUAL SPACES                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-DIR-PAY-6      TO WS-DIR-PAYMENT-BREAKDOWN      
              MOVE WS-REV-TYPE-NUM     TO WS-DIR-PAY-REC-TYPE (6)       
PDSUPP        IF WS-PAY-ADV-COLL = 'Y'                                  
PDSUPP           PERFORM 7100-SELECT-NEW-ITEM-ID THRU 7100-EXIT         
PDSUPP           MOVE WS-ADV-COLL-ITEM-ID TO WS-ITEM-ID-NUM             
PDSUPP        ELSE                                                      
PDSUPP           MOVE WS-ITEM-ID          TO WS-ITEM-ID-PARM            
PDSUPP        END-IF                                                    
              MOVE WS-ITEM-ID-NUM      TO WS-DIR-PAY-ITEM-ID (6)        
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-DIR-PAY-AMT (6)            
              MOVE WS-PAY-AHEAD-TYPE   TO WS-DIR-PAY-AHEAD-TYPE (6)     
              MOVE WS-PAY-CHRG-OFF     TO WS-DIR-PAY-CHRG-OFF (6)       
              IF WS-PAY-CHRG-OFF = 'Y'                                  
                 ADD WS-AMT-DIR-PYMT-NUM TO WS-PAR-AMT-TOT-CO           
              END-IF                                                    
              MOVE WS-PAY-ADV-COLL     TO WS-DIR-PAY-ADV-COLL (6)       
           END-IF                                                       
                                                                        
           IF PARM-DIR-PAY-7 EQUAL SPACES                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-DIR-PAY-7      TO WS-DIR-PAYMENT-BREAKDOWN      
              MOVE WS-REV-TYPE-NUM     TO WS-DIR-PAY-REC-TYPE (7)       
PDSUPP        IF WS-PAY-ADV-COLL = 'Y'                                  
PDSUPP           PERFORM 7100-SELECT-NEW-ITEM-ID THRU 7100-EXIT         
PDSUPP           MOVE WS-ADV-COLL-ITEM-ID TO WS-ITEM-ID-NUM             
PDSUPP        ELSE                                                      
PDSUPP           MOVE WS-ITEM-ID          TO WS-ITEM-ID-PARM            
PDSUPP        END-IF                                                    
              MOVE WS-ITEM-ID-NUM      TO WS-DIR-PAY-ITEM-ID (7)        
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-DIR-PAY-AMT (7)            
              MOVE WS-PAY-AHEAD-TYPE   TO WS-DIR-PAY-AHEAD-TYPE (7)     
              MOVE WS-PAY-CHRG-OFF     TO WS-DIR-PAY-CHRG-OFF (7)       
              IF WS-PAY-CHRG-OFF = 'Y'                                  
                 ADD WS-AMT-DIR-PYMT-NUM TO WS-PAR-AMT-TOT-CO           
              END-IF                                                    
              MOVE WS-PAY-ADV-COLL     TO WS-DIR-PAY-ADV-COLL (7)       
           END-IF                                                       
                                                                        
           IF PARM-DIR-PAY-8 EQUAL SPACES                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-DIR-PAY-8      TO WS-DIR-PAYMENT-BREAKDOWN      
              MOVE WS-REV-TYPE-NUM     TO WS-DIR-PAY-REC-TYPE (8)       
PDSUPP        IF WS-PAY-ADV-COLL = 'Y'                                  
PDSUPP           PERFORM 7100-SELECT-NEW-ITEM-ID THRU 7100-EXIT         
PDSUPP           MOVE WS-ADV-COLL-ITEM-ID TO WS-ITEM-ID-NUM             
PDSUPP        ELSE                                                      
PDSUPP           MOVE WS-ITEM-ID          TO WS-ITEM-ID-PARM            
PDSUPP        END-IF                                                    
              MOVE WS-ITEM-ID-NUM      TO WS-DIR-PAY-ITEM-ID (8)        
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-DIR-PAY-AMT (8)            
              MOVE WS-PAY-AHEAD-TYPE   TO WS-DIR-PAY-AHEAD-TYPE (8)     
              MOVE WS-PAY-CHRG-OFF     TO WS-DIR-PAY-CHRG-OFF (8)       
              IF WS-PAY-CHRG-OFF = 'Y'                                  
                 ADD WS-AMT-DIR-PYMT-NUM TO WS-PAR-AMT-TOT-CO           
              END-IF                                                    
              MOVE WS-PAY-ADV-COLL     TO WS-DIR-PAY-ADV-COLL (8)       
           END-IF                                                       
                                                                        
           IF PARM-DIR-PAY-9 EQUAL SPACES                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-DIR-PAY-9      TO WS-DIR-PAYMENT-BREAKDOWN      
              MOVE WS-REV-TYPE-NUM     TO WS-DIR-PAY-REC-TYPE (9)       
PDSUPP        IF WS-PAY-ADV-COLL = 'Y'                                  
PDSUPP           PERFORM 7100-SELECT-NEW-ITEM-ID THRU 7100-EXIT         
PDSUPP           MOVE WS-ADV-COLL-ITEM-ID TO WS-ITEM-ID-NUM             
PDSUPP        ELSE                                                      
PDSUPP           MOVE WS-ITEM-ID          TO WS-ITEM-ID-PARM            
PDSUPP        END-IF                                                    
              MOVE WS-ITEM-ID-NUM      TO WS-DIR-PAY-ITEM-ID (9)        
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-DIR-PAY-AMT (9)            
              MOVE WS-PAY-AHEAD-TYPE   TO WS-DIR-PAY-AHEAD-TYPE (9)     
              MOVE WS-PAY-CHRG-OFF     TO WS-DIR-PAY-CHRG-OFF (9)       
              IF WS-PAY-CHRG-OFF = 'Y'                                  
                 ADD WS-AMT-DIR-PYMT-NUM TO WS-PAR-AMT-TOT-CO           
              END-IF                                                    
              MOVE WS-PAY-ADV-COLL     TO WS-DIR-PAY-ADV-COLL (9)       
           END-IF                                                       
                                                                        
           IF PARM-DIR-PAY-10 EQUAL SPACES                              
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-DIR-PAY-10     TO WS-DIR-PAYMENT-BREAKDOWN      
              MOVE WS-REV-TYPE-NUM     TO WS-DIR-PAY-REC-TYPE (10)      
PDSUPP        IF WS-PAY-ADV-COLL = 'Y'                                  
PDSUPP           PERFORM 7100-SELECT-NEW-ITEM-ID THRU 7100-EXIT         
PDSUPP           MOVE WS-ADV-COLL-ITEM-ID TO WS-ITEM-ID-NUM             
PDSUPP        ELSE                                                      
PDSUPP           MOVE WS-ITEM-ID          TO WS-ITEM-ID-PARM            
PDSUPP        END-IF                                                    
              MOVE WS-ITEM-ID-NUM      TO WS-DIR-PAY-ITEM-ID (10)       
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-DIR-PAY-AMT (10)           
              MOVE WS-PAY-AHEAD-TYPE   TO WS-DIR-PAY-AHEAD-TYPE (10)    
              MOVE WS-PAY-CHRG-OFF     TO WS-DIR-PAY-CHRG-OFF (10)      
              IF WS-PAY-CHRG-OFF = 'Y'                                  
                 ADD WS-AMT-DIR-PYMT-NUM TO WS-PAR-AMT-TOT-CO           
              END-IF                                                    
              MOVE WS-PAY-ADV-COLL     TO WS-DIR-PAY-ADV-COLL (10)      
           END-IF                                                       
                                                                        
           IF PARM-DIR-PAY-11 EQUAL SPACES                              
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-DIR-PAY-11     TO WS-DIR-PAYMENT-BREAKDOWN      
              MOVE WS-REV-TYPE-NUM     TO WS-DIR-PAY-REC-TYPE (11)      
PDSUPP        IF WS-PAY-ADV-COLL = 'Y'                                  
PDSUPP           PERFORM 7100-SELECT-NEW-ITEM-ID THRU 7100-EXIT         
PDSUPP           MOVE WS-ADV-COLL-ITEM-ID TO WS-ITEM-ID-NUM             
PDSUPP        ELSE                                                      
PDSUPP           MOVE WS-ITEM-ID          TO WS-ITEM-ID-PARM            
PDSUPP        END-IF                                                    
              MOVE WS-ITEM-ID-NUM      TO WS-DIR-PAY-ITEM-ID (10)       
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-DIR-PAY-AMT (11)           
              MOVE WS-PAY-AHEAD-TYPE   TO WS-DIR-PAY-AHEAD-TYPE (11)    
              MOVE WS-PAY-CHRG-OFF     TO WS-DIR-PAY-CHRG-OFF (11)      
              IF WS-PAY-CHRG-OFF = 'Y'                                  
                 ADD WS-AMT-DIR-PYMT-NUM TO WS-PAR-AMT-TOT-CO           
              END-IF                                                    
              MOVE WS-PAY-ADV-COLL     TO WS-DIR-PAY-ADV-COLL (11)      
           END-IF                                                       
                                                                        
           IF PARM-DIR-PAY-12 EQUAL SPACES                              
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-DIR-PAY-12     TO WS-DIR-PAYMENT-BREAKDOWN      
              MOVE WS-REV-TYPE-NUM     TO WS-DIR-PAY-REC-TYPE (12)      
PDSUPP        IF WS-PAY-ADV-COLL = 'Y'                                  
PDSUPP           PERFORM 7100-SELECT-NEW-ITEM-ID THRU 7100-EXIT         
PDSUPP           MOVE WS-ADV-COLL-ITEM-ID TO WS-ITEM-ID-NUM             
PDSUPP        ELSE                                                      
PDSUPP           MOVE WS-ITEM-ID          TO WS-ITEM-ID-PARM            
PDSUPP        END-IF                                                    
              MOVE WS-ITEM-ID-NUM      TO WS-DIR-PAY-ITEM-ID (12)       
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-DIR-PAY-AMT (12)           
              MOVE WS-PAY-AHEAD-TYPE   TO WS-DIR-PAY-AHEAD-TYPE (12)    
              MOVE WS-PAY-CHRG-OFF     TO WS-DIR-PAY-CHRG-OFF (12)      
              IF WS-PAY-CHRG-OFF = 'Y'                                  
                 ADD WS-AMT-DIR-PYMT-NUM TO WS-PAR-AMT-TOT-CO           
              END-IF                                                    
              MOVE WS-PAY-ADV-COLL     TO WS-DIR-PAY-ADV-COLL (12)      
           END-IF                                                       
                                                                        
           IF PARM-DIR-PAY-13 EQUAL SPACES                              
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-DIR-PAY-13     TO WS-DIR-PAYMENT-BREAKDOWN      
              MOVE WS-REV-TYPE-NUM     TO WS-DIR-PAY-REC-TYPE (13)      
PDSUPP        IF WS-PAY-ADV-COLL = 'Y'                                  
PDSUPP           PERFORM 7100-SELECT-NEW-ITEM-ID THRU 7100-EXIT         
PDSUPP           MOVE WS-ADV-COLL-ITEM-ID TO WS-ITEM-ID-NUM             
PDSUPP        ELSE                                                      
PDSUPP           MOVE WS-ITEM-ID          TO WS-ITEM-ID-PARM            
PDSUPP        END-IF                                                    
              MOVE WS-ITEM-ID-NUM      TO WS-DIR-PAY-ITEM-ID (13)       
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-DIR-PAY-AMT (13)           
              MOVE WS-PAY-AHEAD-TYPE   TO WS-DIR-PAY-AHEAD-TYPE (13)    
              MOVE WS-PAY-CHRG-OFF     TO WS-DIR-PAY-CHRG-OFF (13)      
              IF WS-PAY-CHRG-OFF = 'Y'                                  
                 ADD WS-AMT-DIR-PYMT-NUM TO WS-PAR-AMT-TOT-CO           
              END-IF                                                    
              MOVE WS-PAY-ADV-COLL     TO WS-DIR-PAY-ADV-COLL (13)      
           END-IF                                                       
                                                                        
           IF PARM-DIR-PAY-14 EQUAL SPACES                              
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-DIR-PAY-14     TO WS-DIR-PAYMENT-BREAKDOWN      
              MOVE WS-REV-TYPE-NUM     TO WS-DIR-PAY-REC-TYPE (14)      
PDSUPP        IF WS-PAY-ADV-COLL = 'Y'                                  
PDSUPP           PERFORM 7100-SELECT-NEW-ITEM-ID THRU 7100-EXIT         
PDSUPP           MOVE WS-ADV-COLL-ITEM-ID TO WS-ITEM-ID-NUM             
PDSUPP        ELSE                                                      
PDSUPP           MOVE WS-ITEM-ID          TO WS-ITEM-ID-PARM            
PDSUPP        END-IF                                                    
              MOVE WS-ITEM-ID-NUM      TO WS-DIR-PAY-ITEM-ID (14)       
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-DIR-PAY-AMT (14)           
              MOVE WS-PAY-AHEAD-TYPE   TO WS-DIR-PAY-AHEAD-TYPE (14)    
              MOVE WS-PAY-CHRG-OFF     TO WS-DIR-PAY-CHRG-OFF (14)      
              IF WS-PAY-CHRG-OFF = 'Y'                                  
                 ADD WS-AMT-DIR-PYMT-NUM TO WS-PAR-AMT-TOT-CO           
              END-IF                                                    
              MOVE WS-PAY-ADV-COLL     TO WS-DIR-PAY-ADV-COLL (14)      
           END-IF                                                       
                                                                        
           IF PARM-DIR-PAY-15 EQUAL SPACES                              
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-DIR-PAY-15     TO WS-DIR-PAYMENT-BREAKDOWN      
              MOVE WS-REV-TYPE-NUM     TO WS-DIR-PAY-REC-TYPE (15)      
PDSUPP        IF WS-PAY-ADV-COLL = 'Y'                                  
PDSUPP           PERFORM 7100-SELECT-NEW-ITEM-ID THRU 7100-EXIT         
PDSUPP           MOVE WS-ADV-COLL-ITEM-ID TO WS-ITEM-ID-NUM             
PDSUPP        ELSE                                                      
PDSUPP           MOVE WS-ITEM-ID          TO WS-ITEM-ID-PARM            
PDSUPP        END-IF                                                    
              MOVE WS-ITEM-ID-NUM      TO WS-DIR-PAY-ITEM-ID (15)       
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-DIR-PAY-AMT (15)           
              MOVE WS-PAY-AHEAD-TYPE   TO WS-DIR-PAY-AHEAD-TYPE (15)    
              MOVE WS-PAY-CHRG-OFF     TO WS-DIR-PAY-CHRG-OFF (15)      
              IF WS-PAY-CHRG-OFF = 'Y'                                  
                 ADD WS-AMT-DIR-PYMT-NUM TO WS-PAR-AMT-TOT-CO           
              END-IF                                                    
              MOVE WS-PAY-ADV-COLL     TO WS-DIR-PAY-ADV-COLL (15)      
           END-IF                                                       
                                                                        
           IF PARM-DIR-PAY-16 EQUAL SPACES                              
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-DIR-PAY-16     TO WS-DIR-PAYMENT-BREAKDOWN      
              MOVE WS-REV-TYPE-NUM     TO WS-DIR-PAY-REC-TYPE (16)      
PDSUPP        IF WS-PAY-ADV-COLL = 'Y'                                  
PDSUPP           PERFORM 7100-SELECT-NEW-ITEM-ID THRU 7100-EXIT         
PDSUPP           MOVE WS-ADV-COLL-ITEM-ID TO WS-ITEM-ID-NUM             
PDSUPP        ELSE                                                      
PDSUPP           MOVE WS-ITEM-ID          TO WS-ITEM-ID-PARM            
PDSUPP        END-IF                                                    
              MOVE WS-ITEM-ID-NUM      TO WS-DIR-PAY-ITEM-ID (16)       
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-DIR-PAY-AMT (16)           
              MOVE WS-PAY-AHEAD-TYPE   TO WS-DIR-PAY-AHEAD-TYPE (16)    
              MOVE WS-PAY-CHRG-OFF     TO WS-DIR-PAY-CHRG-OFF (16)      
              IF WS-PAY-CHRG-OFF = 'Y'                                  
                 ADD WS-AMT-DIR-PYMT-NUM TO WS-PAR-AMT-TOT-CO           
              END-IF                                                    
              MOVE WS-PAY-ADV-COLL     TO WS-DIR-PAY-ADV-COLL (16)      
           END-IF                                                       
                                                                        
           IF PARM-DIR-PAY-17 EQUAL SPACES                              
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-DIR-PAY-17     TO WS-DIR-PAYMENT-BREAKDOWN      
              MOVE WS-REV-TYPE-NUM     TO WS-DIR-PAY-REC-TYPE (17)      
PDSUPP        IF WS-PAY-ADV-COLL = 'Y'                                  
PDSUPP           PERFORM 7100-SELECT-NEW-ITEM-ID THRU 7100-EXIT         
PDSUPP           MOVE WS-ADV-COLL-ITEM-ID TO WS-ITEM-ID-NUM             
PDSUPP        ELSE                                                      
PDSUPP           MOVE WS-ITEM-ID          TO WS-ITEM-ID-PARM            
PDSUPP        END-IF                                                    
              MOVE WS-ITEM-ID-NUM      TO WS-DIR-PAY-ITEM-ID (17)       
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-DIR-PAY-AMT (17)           
              MOVE WS-PAY-AHEAD-TYPE   TO WS-DIR-PAY-AHEAD-TYPE (17)    
              MOVE WS-PAY-CHRG-OFF     TO WS-DIR-PAY-CHRG-OFF (17)      
              IF WS-PAY-CHRG-OFF = 'Y'                                  
                 ADD WS-AMT-DIR-PYMT-NUM TO WS-PAR-AMT-TOT-CO           
              END-IF                                                    
              MOVE WS-PAY-ADV-COLL     TO WS-DIR-PAY-ADV-COLL (17)      
           END-IF                                                       
                                                                        
           IF PARM-DIR-PAY-18 EQUAL SPACES                              
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-DIR-PAY-18     TO WS-DIR-PAYMENT-BREAKDOWN      
              MOVE WS-REV-TYPE-NUM     TO WS-DIR-PAY-REC-TYPE (18)      
PDSUPP        IF WS-PAY-ADV-COLL = 'Y'                                  
PDSUPP           PERFORM 7100-SELECT-NEW-ITEM-ID THRU 7100-EXIT         
PDSUPP           MOVE WS-ADV-COLL-ITEM-ID TO WS-ITEM-ID-NUM             
PDSUPP        ELSE                                                      
PDSUPP           MOVE WS-ITEM-ID          TO WS-ITEM-ID-PARM            
PDSUPP        END-IF                                                    
              MOVE WS-ITEM-ID-NUM      TO WS-DIR-PAY-ITEM-ID (18)       
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-DIR-PAY-AMT (18)           
              MOVE WS-PAY-AHEAD-TYPE   TO WS-DIR-PAY-AHEAD-TYPE (18)    
              MOVE WS-PAY-CHRG-OFF     TO WS-DIR-PAY-CHRG-OFF (18)      
              IF WS-PAY-CHRG-OFF = 'Y'                                  
                 ADD WS-AMT-DIR-PYMT-NUM TO WS-PAR-AMT-TOT-CO           
              END-IF                                                    
              MOVE WS-PAY-ADV-COLL     TO WS-DIR-PAY-ADV-COLL (18)      
           END-IF                                                       
                                                                        
           IF PARM-DIR-PAY-19 EQUAL SPACES                              
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-DIR-PAY-19     TO WS-DIR-PAYMENT-BREAKDOWN      
              MOVE WS-REV-TYPE-NUM     TO WS-DIR-PAY-REC-TYPE (19)      
PDSUPP        IF WS-PAY-ADV-COLL = 'Y'                                  
PDSUPP           PERFORM 7100-SELECT-NEW-ITEM-ID THRU 7100-EXIT         
PDSUPP           MOVE WS-ADV-COLL-ITEM-ID TO WS-ITEM-ID-NUM             
PDSUPP        ELSE                                                      
PDSUPP           MOVE WS-ITEM-ID          TO WS-ITEM-ID-PARM            
PDSUPP        END-IF                                                    
              MOVE WS-ITEM-ID-NUM      TO WS-DIR-PAY-ITEM-ID (19)       
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-DIR-PAY-AMT (19)           
              MOVE WS-PAY-AHEAD-TYPE   TO WS-DIR-PAY-AHEAD-TYPE (19)    
              MOVE WS-PAY-CHRG-OFF     TO WS-DIR-PAY-CHRG-OFF (19)      
              IF WS-PAY-CHRG-OFF = 'Y'                                  
                 ADD WS-AMT-DIR-PYMT-NUM TO WS-PAR-AMT-TOT-CO           
              END-IF                                                    
              MOVE WS-PAY-ADV-COLL     TO WS-DIR-PAY-ADV-COLL (19)      
           END-IF                                                       
                                                                        
           IF PARM-DIR-PAY-20 EQUAL SPACES                              
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-DIR-PAY-20     TO WS-DIR-PAYMENT-BREAKDOWN      
              MOVE WS-REV-TYPE-NUM     TO WS-DIR-PAY-REC-TYPE (20)      
PDSUPP        IF WS-PAY-ADV-COLL = 'Y'                                  
PDSUPP           PERFORM 7100-SELECT-NEW-ITEM-ID THRU 7100-EXIT         
PDSUPP           MOVE WS-ADV-COLL-ITEM-ID TO WS-ITEM-ID-NUM             
PDSUPP        ELSE                                                      
PDSUPP           MOVE WS-ITEM-ID          TO WS-ITEM-ID-PARM            
PDSUPP        END-IF                                                    
              MOVE WS-ITEM-ID-NUM      TO WS-DIR-PAY-ITEM-ID (20)       
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-DIR-PAY-AMT (20)           
              MOVE WS-PAY-AHEAD-TYPE   TO WS-DIR-PAY-AHEAD-TYPE (20)    
              MOVE WS-PAY-CHRG-OFF     TO WS-DIR-PAY-CHRG-OFF (20)      
              IF WS-PAY-CHRG-OFF = 'Y'                                  
                 ADD WS-AMT-DIR-PYMT-NUM TO WS-PAR-AMT-TOT-CO           
              END-IF                                                    
              MOVE WS-PAY-ADV-COLL     TO WS-DIR-PAY-ADV-COLL (20)      
           END-IF                                                       
           .                                                            
       2220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *--------------------------------------------------------------*  00139000
      *  MOVING VALUES TO PAYMENT TRANS TABLE FOR LOGGING THE PAYMENT.  00139100
      *--------------------------------------------------------------*  00139200
       2400-MOVE-PYMT-TRANS-VALUE.                                      
                                                                        
           INITIALIZE DCLCSS-PAYMENT-TRANS                              
                                                                        
           IF WS-CURRENT-TIMESTAMP > SPACES                             
              CONTINUE                                                  
           ELSE                                                         
              PERFORM 6791A-GET-TIMESTAMP                               
                 THRU 6791A-EXIT                                        
           END-IF                                                       
                                                                        
           MOVE SPACES                  TO JT-CUST-PHONE-NO             
                                           JT-ERROR-CD                  
                                           JT-CREDIT-CARD-TYPE          
                                                                        
           MOVE PARM-DATE-CASH-REPORT   TO JT-DATE-CASH-REPORT          
           MOVE PARM-CASH-LOCAL-OFFICE  TO JT-CASH-LOCAL-OFFICE         
           MOVE PARM-PANEL-NO           TO JT-APPL-PROGRAM-ID           
           MOVE 'Y'                     TO JT-APPLIED-FL                
           MOVE PARM-PAYMENT-TYPE       TO JT-CURRENCY-TYPE             
           MOVE PARM-FACILITY-CODE      TO JT-PYMT-FACILITY-CD          
           MOVE WS-PAYMENT-AMOUNT-TOTAL TO JT-PAYMENT-AMT               
           MOVE AT-ACCOUNT-NO           TO JT-ACCOUNT-NO                
           MOVE AT-COMPANY-NO           TO JT-COMPANY-NO                
           MOVE PARM-USER-ID            TO JT-LAST-UPDATE-USERID        
           MOVE WS-CURRENT-TIMESTAMP    TO JT-TRANS-HIST-SEQ-NO         
                                           JT-PYMT-RCVD-TS              
                                           JT-APPLIED-TS                
                                                                        
           MOVE PARM-CASH-DRAWER-ID     TO JT-PYMT-CONFIRM-NO(1:4)      
           MOVE WS-JRNL-ENTRY-NO-HOLD   TO WS-ENTRY-NO                  
           MOVE WS-ENTRY-NO-CHAR        TO JT-PYMT-CONFIRM-NO(9:7)      
                                                                        
           IF PARM-UPDATE-TYPE = WS-D                                   
              MOVE 'DIR'                TO JT-DIRECTED-PYMT-CD          
           ELSE                                                         
              MOVE 'UND'                TO JT-DIRECTED-PYMT-CD          
           END-IF                                                       
                                                                        
           .                                                            
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *--------------------------------------------------------------*  00143900
      *  DECIDES WHETHER A WQ SHOULD BE WRITTEN FOR THIS PAYMENT     .  00144000
      *--------------------------------------------------------------*  00144100
       2500-WQ-PROCESS.                                                 
           IF AT-BANKRUPTCY-IND = 'B'                                   
              PERFORM 2550-BANKRUPT-WORK-QUEUE THRU 2550-EXIT           
           END-IF                                                       
           .                                                            
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *--------------------------------------------------------------*  00145400
      * SEND A WORK QUEUE TO ALERT THAT A PAYMENT WAS MADE ON A      *  00145500
      *      BANKRUPT ACCOUNT.                                       *  00145600
      *--------------------------------------------------------------*  00145700
       2550-BANKRUPT-WORK-QUEUE.                                        
                                                                        
ACT096     INITIALIZE CWS00077-FIELDS.                                  
ACT096     MOVE AT-ACCOUNT-NO         TO WS-77-ACCOUNT-NO               
ACT096     MOVE AT-CUSTOMER-NO        TO WS-77-CUSTOMER-NO              
ACT096     MOVE AT-PREMISE-NO         TO WS-77-PREMISE-NO               
ACT096     MOVE ZERO                  TO WS-77-SERV-ORDER-NO            
ACT096     MOVE AT-LOCAL-OFFICE       TO WS-77-LOCAL-OFFICE             
ACT096     MOVE WS-BANKRUPT-CAT-ID    TO WS-77-CATEGORY-ID              
ACT096     MOVE SPACES                TO WS-77-RESP-AREA-ID             
ACT096     MOVE WS-N                  TO WS-77-PRIORITY                 
ACT096     MOVE WS-4                  TO WS-77-ROUTE-CATEGORY           
ACT096     MOVE PARM-USER-ID          TO WS-77-USER-ID-ORIG             
ACT096     MOVE ZERO                  TO WS-77-FREE-FORM-LEN            
ACT096     MOVE SPACES                TO WS-77-FREE-FORM-TXT            
           MOVE WS-PAYMENT-AMOUNT-TOTAL                                 
                                      TO WS-BANKRUPT-WQ-AMT             
           MOVE WS-BANKRUPT-WQ-AMT    TO WS-BANKRUPT-WQ-AMT-DISP        
ACT096     MOVE +89                   TO WS-77-COMMENTS-LEN             
ACT096     MOVE WS-BANKRUPT-WQ-MSG    TO WS-77-COMMENTS-TEXT            
ACT096     MOVE PROGRAM-NAME          TO WS-77-CREATED-BY               
                                                                        
           MOVE WS-CURRENT-DATE       TO 1G-BUSINESS-DAY-DT             
           MOVE +1                    TO WS-ADD                         
           PERFORM 7750-SELECT-NEXT-DATE                                
              THRU 7750-EXIT                                            
                                                                        
ACT096     MOVE 1G-BUSINESS-DAY-DT    TO WS-77-DATE-REQUIRED            
ACT096     MOVE WS-CURRENT-DATE       TO WS-77-DATE-CREATED             
           PERFORM 6797E-INSERT-WORK-QUEUE THRU 6797E-EXIT              
           .                                                            
       2550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *--------------------------------------------------------------*  00182300
ACT285* CALLS SUB PROGRAMS MCS03414 TO HANDLE DNP/RECONNECT REAL TIME*  00182400
      *--------------------------------------------------------------*  00182500
       2950-PROCESS-DNP-RECONNECT.                                      
                                                                        
ACT285* Populate WS variable to call CPD03414                                   
           MOVE 0                           TO WS-DNP-RET-CODE          
           MOVE AT-ACCOUNT-NO               TO WS-ACCOUNT-NO-NUM        
           MOVE 'P'                         TO WS-UPDATE-ACTION-FL      
ACT285     MOVE 'O'                         TO WS-CALL-TYPE             
ACT285     MOVE 'Y'                         TO WS-CPD68-REQUIRED        
ACT285     MOVE PROGRAM-NAME                TO WS-PROGRAM-NAME          
ACT285     MOVE SPACES                      TO ws-APPL-PROGRAM-ID       
P00948     IF PARM-BYPASS-WARNING = 'C'                                 
P00948        MOVE 'N'                      TO WS-CNCL-DNP-EMAIL-REQ-FL 
P00948     ELSE                                                         
P00948        MOVE 'Y'                      TO WS-CNCL-DNP-EMAIL-REQ-FL 
P00948     END-IF                                                       
                                                                        
ACT285     PERFORM 9800-CALL-MCS03414                                   
              THRU 9800-EXIT                                            
                                                                        
           IF WS-DNP-RET-CODE > 0                                       
              MOVE WS-DNP-RET-CODE          TO RS-ERROR-MESSAGE2        
           END-IF                                                       
           .                                                            
       2950-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5000-UPDATE.                                                     
           MOVE '5000'        TO ACTIVE-PARAGRAPH                       
                                                                        
P00586**** MOVE EIBTRNID      TO WS-PAR-EIBTRNID                        00184500
P00586     IF PARM-PANEL-NO = 'PYMTMLT'                                 
P00586        MOVE MISTRNID   TO WS-PAR-EIBTRNID                        
P00586     ELSE                                                         
P00586        MOVE EIBTRNID   TO WS-PAR-EIBTRNID                        
P00586     END-IF                                                       
                                                                        
           MOVE PARM-FACILITY-CODE TO WS-PAR-PYMT-FACILITY-CD           
           MOVE AT-COMPANY-NO TO WS-100-COMPANY-NO                      
           MOVE 9             TO WS-TRAN-OPER-LEVEL                     
           MOVE 1             TO WS-TRAN-OCAP-FIELD                     
           MOVE 1             TO WS-TRAN-OCAP-VALUE                     
           MOVE WS-C          TO WS-TRAN-JRNL-TYPE                      
           MOVE WS-N          TO WS-TRAN-HOLD-EXEMPT-FLAG               
                                                                        
           MOVE PARM-USER-ID       TO WS-JRNL-OL-TEMP-ID                
           MOVE WS-JRNL-CK-OPER-ID TO WS-JRNL-OPERATION-RQST            
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT              
           MOVE WS-JRNL-OL-OPR-LOC TO WS-TERM-LOC                       
                                                                        
           MOVE PARM-CASH-COMPANY-NO   TO   WS-JRNL-OL-COMPANY          
           MOVE PARM-CASH-LOCAL-OFFICE TO   WS-JRNL-OL-LOC-OFF          
           MOVE PARM-CASH-REPORT-NO    TO   WS-JRNL-OL-REPORT-NO        
           MOVE PARM-DATE-CASH-REPORT  TO   WS-JRNL-OL-REPORT-DT        
           MOVE PARM-CASH-DRAWER-ID    TO   WS-JRNL-OL-CASH-DRWR        
           MOVE SPACES                 TO   WS-JRNL-OL-CSR-PC-ID        
                                                                        
           MOVE WS-TERM-LOC                TO WS-JRNL-OL-TERM-LOC       
                                              WS-JRNL-OL-CASH-LOC       
                                              WS-JRNL-OL-OPR-LOC        
                                                                        
           MOVE WS-JRNL-VALIDATE-OPER TO WS-JRNL-OPERATION-RQST         
           MOVE WS-C                  TO WS-JRNL-SOURCE-CODE            
                                                                        
           IF CASH-TRANSACTION                                          
              MOVE WS-JRNL-CASH-UPDATE     TO WS-JRNL-OL-AUTH-TYPE      
           ELSE                                                         
              MOVE WS-JRNL-NON-CASH-UPDATE TO WS-JRNL-OL-AUTH-TYPE      
           END-IF                                                       
                                                                        
           PERFORM 6400-ONLINE-JRNL-ROUTINE  THRU 6400-EXIT             
                                                                        
           MOVE WS-A            TO WS-100-JRNL-SORT-ID                  
           MOVE AT-ACCOUNT-NO   TO WS-100-ACCT-NO                       
           MOVE AT-CUSTOMER-NO  TO WS-100-CUSTOMER-NO                   
           MOVE AT-PREMISE-NO   TO WS-100-PREMISE-NO                    
P00586**** MOVE EIBTRNID        TO WS-100-CODE-TERMINAL-TRAN            00189100
P00586     IF PARM-PANEL-NO = 'PYMTMLT'                                 
P00586        MOVE MISTRNID     TO WS-100-CODE-TERMINAL-TRAN            
P00586     ELSE                                                         
P00586        MOVE EIBTRNID     TO WS-100-CODE-TERMINAL-TRAN            
P00586     END-IF                                                       
                                                                        
           ADD 1                TO WS-100-JRNL-TRAN-APPL-NO             
           MOVE WS-CURRENT-DATE TO WS-100-DATE-LAST-ACTION              
                                   AT-DATE-LAST-ACTION                  
           MOVE WS-C            TO WS-100-CODE-ENTRY-SOURCE             
           MOVE AT-LOCAL-OFFICE TO WS-100-LOCAL-OFFICE-CD               
                                                                        
           MOVE WS-JRNL-OL-COMPANY      TO WS-PAR-COMPANY-NO            
           MOVE WS-JRNL-OL-LOC-OFF      TO WS-PAR-LOCAL-OFFICE          
           MOVE WS-JRNL-OL-REPORT-NO    TO WS-PAR-REPORT-NO             
           MOVE WS-JRNL-OL-REPORT-DT    TO WS-PAR-REPORT-DATE           
           MOVE WS-JRNL-OL-CASH-DRWR    TO WS-PAR-CASH-DRAWER           
                                                                        
           MOVE WS-TERM-LOC             TO WS-PAR-ACCESS-LOC            
           MOVE PARM-USER-ID            TO WS-PAR-OPERATOR-ID           
           MOVE PF-RESP-AREA-ID         TO WS-PAR-RESP-AREA             
                                                                        
           EVALUATE PARM-PANEL-NO                                       
              WHEN 'PYMTSGLD'                                           
              WHEN 'PYMTMLTD'                                           
                   MOVE 'PANEL113D'   TO WS-PAR-APPL-PROG-ID            
              WHEN 'PYMTSGL'                                            
              WHEN 'PYMTSGLO'                                           
                   MOVE 'PANEL113'    TO WS-PAR-APPL-PROG-ID            
              WHEN 'PYMTMLT'                                            
                   MOVE 'PANEL115'    TO WS-PAR-APPL-PROG-ID            
              WHEN OTHER                                                
                   MOVE PARM-PANEL-NO TO WS-PAR-APPL-PROG-ID            
           END-EVALUATE                                                 
                                                                        
           MOVE PARM-FACILITY-CODE      TO WS-PAR-PYMT-FACILITY-CD      
           MOVE PARM-PYMT-RCPT-PRNTD-CD TO WS-PAR-PYMT-RCPT-PRNTD-CD    
                                                                        
           MOVE WS-PAR-P                TO WS-PAR-CODE-TRAN-TYPE        
                                                                        
           IF DIRECTED-PYMT                                             
              PERFORM 5010-PAYMENT-LOOP THRU 5010-EXIT                  
                 VARYING WS-SUB FROM 1 BY 1                             
                     UNTIL WS-SUB GREATER THAN PARM-NO-ROWS             
           ELSE                                                         
              PERFORM 6700-APPLY-PAYMENT THRU 6700-EXIT                 
              PERFORM 5001-CHECK-PAYMENT-RETURN THRU 5001-EXIT          
           END-IF                                                       
                                                                        
           MOVE WS-JRNL-CNTRL-ONLY TO WS-JRNL-OPERATION-RQST            
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT              
                                                                        
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE WS-PAR-MESSAGE-NO    TO RS-ERROR-MESSAGE1            
              MOVE '5000'               TO ACTIVE-PARAGRAPH             
              MOVE 'USERABEN'           TO ABEND-FUNCTION               
              MOVE WS-YES               TO WS-USER-FORCE-ABEND          
              MOVE SPACES               TO DSNTIAR-MESSAGE-1            
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF                                                       
           .                                                            
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5001-CHECK-PAYMENT-RETURN.                                       
           IF PYMT-WAS-SUCCESSFUL                                       
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE            
                 MOVE WS-PAR-MESSAGE-NO    TO RS-ERROR-MESSAGE1         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '5001'                  TO ACTIVE-PARAGRAPH          
              MOVE AT-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1         
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT            
              ADD +1                         TO   CTR-ROWS              
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       5001-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5010-PAYMENT-LOOP.                                               
                                                                        
           MOVE '5010' TO ACTIVE-PARAGRAPH                              
                                                                        
           IF WS-DIR-PAY-REC-TYPE(WS-SUB) = 70                          
              MOVE PARM-ACCOUNT-NO  TO AC-ACCOUNT-NO                    
                                       AT-ACCOUNT-NO                    
              MOVE 1                TO AC-ITEM-ID                       
              PERFORM 7600-SELECT-CIA-IN-AR-CNTL                        
                  THRU 7600-EXIT                                        
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 PERFORM 8000-INSERT-CIA-IN-AR-CNTL                     
                    THRU 8000-EXIT                                      
                 MOVE ZEROES        TO AC-ITEM-ID                       
                 PERFORM 7600-SELECT-CIA-IN-AR-CNTL                     
                    THRU 7600-EXIT                                      
                 IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND               
                    PERFORM 8000-INSERT-CIA-IN-AR-CNTL                  
                       THRU 8000-EXIT                                   
                 END-IF                                                 
              END-IF                                                    
           END-IF                                                       
                                                                        
           MOVE WS-DIR-PAY-AMT (WS-SUB)        TO WS-PAYMENT-AMOUNT     
           MOVE WS-DIR-PAY-REC-TYPE (WS-SUB)   TO WS-PAR-TYPE           
           MOVE WS-DIR-PAY-ITEM-ID (WS-SUB)    TO WS-PAR-TYPE-NO        
           MOVE WS-DIR-PAY-AHEAD-TYPE (WS-SUB) TO WS-PAR-PAY-AHEAD      
           MOVE WS-DIR-PAY-CHRG-OFF (WS-SUB)   TO WS-PAR-PAY-CHRG-OFF   
           MOVE WS-DIR-PAY-ADV-COLL (WS-SUB)   TO WS-PAR-ADV-COLL-IND   
                                                                        
           IF WS-PAR-ADV-COLL-IND = WS-YES                              
              MOVE WS-YES     TO WS-ADV-COLL-FLAG                       
           END-IF                                                       
                                                                        
           PERFORM 6700-APPLY-PAYMENT THRU 6700-EXIT                    
                                                                        
           IF FIRST-PAYMENT                                             
              MOVE WS-NO                   TO WS-FIRST-PAYMENT          
              PERFORM 5001-CHECK-PAYMENT-RETURN THRU 5001-EXIT          
           ELSE                                                         
              IF PYMT-WAS-SUCCESSFUL                                    
                 CONTINUE                                               
              ELSE                                                      
                 MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE           
                 MOVE PROGRAM-NAME            TO ABEND-PROGRAM          
                 MOVE '5010'                  TO ACTIVE-PARAGRAPH       
                 MOVE 'USERABEN'              TO ABEND-FUNCTION         
                 MOVE WS-YES                  TO WS-USER-FORCE-ABEND    
                 MOVE 'PAYMENT ABEND'         TO DSNTIAR-MESSAGE-1      
                 PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT            
              END-IF                                                    
P00586     END-IF                                                       
                                                                        
              IF WS-PAR-ADV-COLL-IND = WS-YES                           
                 MOVE WS-CURRENT-TIMESTAMP TO RS-ADV-COLL-TIMESTAMP     
                 MOVE WS-PAR-ADV-COLL-ITEM-ID TO WS-CNT-ITEM-ID         
                 IF WS-PAR-TYPE = 100                                   
                    PERFORM 5020-CREATE-CONTRACT-ROW THRU 5020-EXIT     
                 END-IF                                                 
              END-IF                                                    
                                                                        
           MOVE 'N'           TO WS-PAR-VALIDATE-JRNL                   
           .                                                            
       5010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5020-CREATE-CONTRACT-ROW.                                        
           INITIALIZE DCLCSS-CONTRACT                                   
           MOVE WS-ACCOUNT-NO-COMP3        TO CT-ACCOUNT-NO             
           MOVE WS-PAR-TYPE                TO CT-PYMT-PRIORITY-LVL      
           MOVE WS-PAR-ADV-COLL-ITEM-ID TO CT-CNT-ITEM-ID               
           MOVE PARM-CONTRACT-TYPE         TO CT-CODE-CONTRACT-TYPE     
           MOVE 'A'                        TO CT-CNT-STATUS-CD          
           MOVE 'N'                        TO CT-LIEN-CD                
                                                                        
           UNSTRING PARM-CONTRACT-NAME                                  
                  DELIMITED BY SPACES     INTO WS-CNT-NAME-CD           
                                                                        
           MOVE WS-CNT-NAME-CD             TO   CT-CNT-NAME-CD          
           MOVE PARM-USER-ID               TO CT-USER-ID                
           PERFORM 8500-INSERT-CONTRACT THRU 8500-EXIT                  
           .                                                            
       5020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*00206300
      *  JOURNALING COPYBOOK. PARAGRAPHS 6530 6540 & 6550              *00206400
      *----------------------------------------------------------------*00206500
                                                                        
           EXEC SQL                                                     00206700
              INCLUDE CPD00067                                          00206800
           END-EXEC.                                                    00206900
                                                                        
      *----------------------------------------------------------------*00207100
      *   CHECK IF A NON-UTIL ACCOUNT CAN FINAL.                       *00207200
      *----------------------------------------------------------------*00207300
           EXEC SQL                                                     00207400
              INCLUDE CPD00312                                          00207500
           END-EXEC.                                                    00207600
                                                                        
      *--------------------------------------------------------------*  00208500
      *   CALCULATE REBATE-AMT                                          00208600
      *--------------------------------------------------------------*  00208700
           EXEC SQL                                                     00208800
             INCLUDE CPD00003                                           00208900
           END-EXEC.                                                    00209000
                                                                        
      *--------------------------------------------------------------*  00209200
      *   6400-ONLINE-JRNL-ROUTINE                                      00209300
      *--------------------------------------------------------------*  00209400
           EXEC SQL                                                     00209500
P00586       INCLUDE CPD0006B                                           00209600
           END-EXEC.                                                    00209700
                                                                        
      *--------------------------------------------------------------*  00209900
      *   6500-ONLINE-LOAD-AR-TRAN-HIST                                 00210000
      *--------------------------------------------------------------*  00210100
           EXEC SQL                                                     00210200
              INCLUDE CPD00008                                          00210300
           END-EXEC.                                                    00210400
                                                                        
      *--------------------------------------------------------------*  00210600
      *   PAYMENT ROUTINE                                               00210700
      *--------------------------------------------------------------*  00210800
       COPY CPD00010.                                                   00210900
                                                                        
      *--------------------------------------------------------------*  00211100
      *   SQLS FOR CPD00010                                             00211200
      *--------------------------------------------------------------*  00211300
           EXEC SQL                                                     00211400
              INCLUDE CPD0010S                                          00211500
           END-EXEC.                                                    00211600
                                                                        
      *--------------------------------------------------------------*  00211800
      *   PAYMENTS TO CHARGE-OFFS                                       00211900
      *--------------------------------------------------------------*  00212000
           EXEC SQL                                                     00212100
              INCLUDE CPD00073                                          00212200
           END-EXEC.                                                    00212300
                                                                        
      *--------------------------------------------------------------*  00212500
      *   SELECTS ACCOUNT,CUSTOMER AND PREMISE DETAIL                *  00212600
      *--------------------------------------------------------------*  00212700
       7000-SELECT-AT-PR-CU.                                            
           EXEC SQL                                                     
             SELECT AT.CUSTOMER_NO,                                     
                    AT.CODE_ACCT_STAT,                                  
                    AT.TOTAL_AR_BALANCE,                                
                    AT.DATE_LAST_ACTION,                                
                    AT.LOCAL_OFFICE,                                    
                    AT.PREMISE_NO,                                      
                    AT.CODES_DATA_PRESENT,                              
                    AT.COMPANY_NO,                                      
                    AT.AR_XFER_IND,                                     
                    AT.ACCT_XFER_TO,                                    
                    AT.BANKRUPTCY_IND,                                  
                    AT.CREDIT_GROUP,                                    
                    AT.NOTICE_EXEMPT_CD,                                
                    AT.CODE_DISC_OK,                                    
                    AT.MST_SUB_ACCT_IND,                                
                    AT.EPP_OFFER_AMOUNT,                                
                    AT.REV_MTH_LST_NRML,                                
                    PR.CODE_PREMISE_STAT,                               
                    PR.REV_DISTRICT_CD,                                 
                    CU.CODE_EMPL_ACCT,                                  
                    CU.CODE_CUST_STATUS,                                
                    CAST(SYSDATETIMEOFFSET() AS DATE),                          
                    AT.DATE_BILL_DAY_00,                                
                    AT.DATE_BILL_DAY_30,                                
                    AT.DATE_BILL_DAY_60,                                
                    AT.DATE_BILL_DAY_90,                                
                    AT.IVR_EXEMPT_CD                                    
               INTO :AT-CUSTOMER-NO,                                    
                    :AT-CODE-ACCT-STAT,                                 
                    :AT-TOTAL-AR-BALANCE,                               
                    :AT-DATE-LAST-ACTION,                               
                    :AT-LOCAL-OFFICE,                                   
                    :AT-PREMISE-NO,                                     
                    :AT-CODES-DATA-PRESENT,                             
                    :AT-COMPANY-NO,                                     
                    :AT-AR-XFER-IND,                                    
                    :AT-ACCT-XFER-TO,                                   
                    :AT-BANKRUPTCY-IND,                                 
                    :AT-CREDIT-GROUP,                                   
                    :AT-NOTICE-EXEMPT-CD,                               
                    :AT-CODE-DISC-OK,                                   
                    :AT-MST-SUB-ACCT-IND,                               
                    :AT-EPP-OFFER-AMOUNT,                               
                    :AT-REV-MTH-LST-NRML,                               
                    :PR-CODE-PREMISE-STAT,                              
                    :PR-REV-DISTRICT-CD,                                
                    :CU-CODE-EMPL-ACCT,                                 
                    :CU-CODE-CUST-STATUS,                               
                    :WS-CURRENT-DATE,                                   
                    :AT-DATE-BILL-DAY-00 :WS-NULL-INDICATOR-4,           
                    :AT-DATE-BILL-DAY-30 :WS-NULL-INDICATOR-1,           
                    :AT-DATE-BILL-DAY-60 :WS-NULL-INDICATOR-2,           
                    :AT-DATE-BILL-DAY-90 :WS-NULL-INDICATOR-3,           
                    :AT-IVR-EXEMPT-CD                                   
               FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED), CSS_PREMISE PR
                           WITH(READUNCOMMITTED), CSS_CUSTOMER CU
                           WITH(READUNCOMMITTED)     
              WHERE AT.ACCOUNT_NO  = :AT-ACCOUNT-NO AND                 
                    AT.PREMISE_NO  = PR.PREMISE_NO  AND                 
                    AT.CUSTOMER_NO = CU.CUSTOMER_NO                     
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     00212900
MFA-TR*      SELECT AT.CUSTOMER_NO,                                     00213000
MFA-TR*             AT.CODE_ACCT_STAT,                                  00213100
MFA-TR*             AT.TOTAL_AR_BALANCE,                                00213200
MFA-TR*             AT.DATE_LAST_ACTION,                                00213300
MFA-TR*             AT.LOCAL_OFFICE,                                    00213400
MFA-TR*             AT.PREMISE_NO,                                      00213500
MFA-TR*             AT.CODES_DATA_PRESENT,                              00213600
MFA-TR*             AT.COMPANY_NO,                                      00213700
MFA-TR*             AT.AR_XFER_IND,                                     00213800
MFA-TR*             AT.ACCT_XFER_TO,                                    00213900
MFA-TR*             AT.BANKRUPTCY_IND,                                  00214000
MFA-TR*             AT.CREDIT_GROUP,                                    00214100
MFA-TR*             AT.NOTICE_EXEMPT_CD,                                00214200
MFA-TR*             AT.CODE_DISC_OK,                                    00214300
MFA-TR*             AT.MST_SUB_ACCT_IND,                                00214400
MFA-TR*             AT.EPP_OFFER_AMOUNT,                                00214500
MFA-TR*             AT.REV_MTH_LST_NRML,                                00214600
MFA-TR*             PR.CODE_PREMISE_STAT,                               00214700
MFA-TR*             PR.REV_DISTRICT_CD,                                 00214800
MFA-TR*             CU.CODE_EMPL_ACCT,                                  00214900
MFA-TR*             CU.CODE_CUST_STATUS,                                00215000
MFA-TR*             CURRENT DATE,                                       00215100
MFA-TR*             AT.DATE_BILL_DAY_00,                                00215200
MFA-TR*             AT.DATE_BILL_DAY_30,                                00215300
MFA-TR*             AT.DATE_BILL_DAY_60,                                00215400
MFA-TR*             AT.DATE_BILL_DAY_90,                                00215500
MFA-TR*             AT.IVR_EXEMPT_CD                                    00215600
MFA-TR*        INTO :AT-CUSTOMER-NO,                                    00215700
MFA-TR*             :AT-CODE-ACCT-STAT,                                 00215800
MFA-TR*             :AT-TOTAL-AR-BALANCE,                               00215900
MFA-TR*             :AT-DATE-LAST-ACTION,                               00216000
MFA-TR*             :AT-LOCAL-OFFICE,                                   00216100
MFA-TR*             :AT-PREMISE-NO,                                     00216200
MFA-TR*             :AT-CODES-DATA-PRESENT,                             00216300
MFA-TR*             :AT-COMPANY-NO,                                     00216400
MFA-TR*             :AT-AR-XFER-IND,                                    00216500
MFA-TR*             :AT-ACCT-XFER-TO,                                   00216600
MFA-TR*             :AT-BANKRUPTCY-IND,                                 00216700
MFA-TR*             :AT-CREDIT-GROUP,                                   00216800
MFA-TR*             :AT-NOTICE-EXEMPT-CD,                               00216900
MFA-TR*             :AT-CODE-DISC-OK,                                   00217000
MFA-TR*             :AT-MST-SUB-ACCT-IND,                               00217100
MFA-TR*             :AT-EPP-OFFER-AMOUNT,                               00217200
MFA-TR*             :AT-REV-MTH-LST-NRML,                               00217300
MFA-TR*             :PR-CODE-PREMISE-STAT,                              00217400
MFA-TR*             :PR-REV-DISTRICT-CD,                                00217500
MFA-TR*             :CU-CODE-EMPL-ACCT,                                 00217600
MFA-TR*             :CU-CODE-CUST-STATUS,                               00217700
MFA-TR*             :WS-CURRENT-DATE,                                   00217800
MFA-TR*             :AT-DATE-BILL-DAY-00:WS-NULL-INDICATOR-4,           00217900
MFA-TR*             :AT-DATE-BILL-DAY-30:WS-NULL-INDICATOR-1,           00218000
MFA-TR*             :AT-DATE-BILL-DAY-60:WS-NULL-INDICATOR-2,           00218100
MFA-TR*             :AT-DATE-BILL-DAY-90:WS-NULL-INDICATOR-3,           00218200
MFA-TR*             :AT-IVR-EXEMPT-CD                                   00218300
MFA-TR*        FROM CSS_ACCOUNT AT, CSS_PREMISE PR, CSS_CUSTOMER CU     00218400
MFA-TR*       WHERE AT.ACCOUNT_NO  = :AT-ACCOUNT-NO AND                 00218500
MFA-TR*             AT.PREMISE_NO  = PR.PREMISE_NO  AND                 00218600
MFA-TR*             AT.CUSTOMER_NO = CU.CUSTOMER_NO                     00218700
MFA-TR*        WITH UR                                                  00218800
MFA-TR*     QUERYNO 7000                                                00218900
MFA-TR*    END-EXEC                                                     00219000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF WS-NULL-INDICATOR-1 EQUAL -1                              
              MOVE SPACES TO AT-DATE-BILL-DAY-30                        
           END-IF                                                       
           IF WS-NULL-INDICATOR-2 EQUAL -1                              
              MOVE SPACES TO AT-DATE-BILL-DAY-60                        
           END-IF                                                       
           IF WS-NULL-INDICATOR-3 EQUAL -1                              
              MOVE SPACES TO AT-DATE-BILL-DAY-90                        
           END-IF                                                       
           IF WS-NULL-INDICATOR-4 EQUAL -1                              
              MOVE SPACES TO AT-DATE-BILL-DAY-00                        
           END-IF                                                       
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'CSS_PREMISE'         TO TABLE-2                     
              MOVE 'CSS_CUSTOMER'        TO TABLE-3                     
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF                                                       
           .                                                            
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
PDSUPP*--------------------------------------------------------------*          
PDSUPP*  SELECT ITEM ID FOR ADVANCE COLLECTION CONTRACTS.            *          
PDSUPP*--------------------------------------------------------------*          
PDSUPP 7100-SELECT-NEW-ITEM-ID.                                         
PDSUPP                                                                  
PDSUPP     EXEC SQL                                                     
PDSUPP           SELECT MAX(CNT_ITEM_ID)                                
PDSUPP             INTO :WS-ADV-COLL-ITEM-ID :WS-NULL-INDICATOR-6        
PDSUPP             FROM CSS_CONTRACT WITH(READUNCOMMITTED)                      
PDSUPP            WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO              
PDSUPP              AND PYMT_PRIORITY_LVL = 100                         
PDSUPP              AND CNT_ITEM_ID  NOT BETWEEN 9000000 AND 9500999    
PDSUPP              AND CNT_ITEM_ID      >= 5000000                     
PDSUPP                                                           
PDSUPP                                                      
PDSUPP     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SELECT MAX(CNT_ITEM_ID)                                        
MFA-TR*            INTO :WS-ADV-COLL-ITEM-ID:WS-NULL-INDICATOR-6                
MFA-TR*            FROM CSS_CONTRACT                                            
MFA-TR*           WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                      
MFA-TR*             AND PYMT_PRIORITY_LVL = 100                                 
MFA-TR*             AND CNT_ITEM_ID  NOT BETWEEN 9000000 AND 9500999            
MFA-TR*             AND CNT_ITEM_ID      >= 5000000                             
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7100                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PDSUPP                                                                  
PDSUPP     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
PDSUPP                                                                  
PDSUPP     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
PDSUPP        IF WS-NULL-INDICATOR-6 EQUAL -1                           
PDSUPP           MOVE WS-MIN-CIS-CNT-ID TO WS-ADV-COLL-ITEM-ID          
PDSUPP        ELSE                                                      
PDSUPP           ADD +1 TO WS-ADV-COLL-ITEM-ID                          
PDSUPP        END-IF                                                    
PDSUPP     ELSE                                                         
PDSUPP        MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
PDSUPP        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
PDSUPP        MOVE '7100'                   TO ACTIVE-PARAGRAPH         
PDSUPP        MOVE 'SELECT'                 TO ABEND-FUNCTION           
PDSUPP        MOVE SPACES                   TO ABEND-SQL-PREDICATES     
PDSUPP                                         ABEND-TABLES             
PDSUPP        MOVE 'CSS_CONTRACT'           TO TABLE-1                  
PDSUPP        MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
PDSUPP        MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
PDSUPP        PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
PDSUPP     END-IF.                                                      
PDSUPP                                                                  
PDSUPP 7100-EXIT.                                                       
PDSUPP     EXIT.                                                        
PDSUPP                                                                  
ACT216*---------------------------------------------------------------* 00226500
ACT216* GET MNT TS                                                    * 00226600
ACT216*---------------------------------------------------------------* 00226700
ACT216 7050-GET-MNT-TRANS-TS.                                           
ACT216                                                                  
ACT216     EXEC SQL                                                     
ACT216        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( MICROSECOND, 
              1, CIS.CHAR2TIMESTAMP(:WS-CURRENT-TIMESTAMP) ), 121), 
           ' ', '-'), ':', '.')
            INTO
              :MH-TRANS-HIST-SEQ-NO  
ACT216     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     28660000
MFA-TR*       SET :MH-TRANS-HIST-SEQ-NO =                               28670000
MFA-TR*               TIMESTAMP(:WS-CURRENT-TIMESTAMP) + 1 MICROSECOND          
MFA-TR*    END-EXEC                                                     28680000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT216                                                                  
ACT216     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
ACT216                     S-RETURN-CODE                                
ACT216                                                                  
ACT216     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
ACT216        CONTINUE                                                  
ACT216     ELSE                                                         
ACT216        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
ACT216        MOVE '7050'                TO ACTIVE-PARAGRAPH            
ACT216        MOVE 'SET'                 TO ABEND-FUNCTION              
ACT216        MOVE SPACES                TO ABEND-SQL-PREDICATES        
ACT216                                      ABEND-TABLES                
ACT216        MOVE WS-CURRENT-TIMESTAMP  TO HOSTVAR-ELEMENT-1           
ACT216        MOVE 'CURRENT TIMESTAMP'   TO TABLE-ELEMENT-1             
ACT216        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
ACT216     END-IF                                                       
ACT216     .                                                            
ACT216 7050-EXIT.                                                       
ACT216     EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 00229800
      * SELECTS RECONNECT AMOUNT FOR AN ACCOUNT                       * 00229900
      *---------------------------------------------------------------* 00230000
       7170-SELECT-RECONNECT.                                           
           EXEC SQL                                                     
             SELECT AMT_TOT_RECONNECT                                   
               INTO :DL-AMT-TOT-RECONNECT                               
               FROM CSS_RECONNECT WITH(READUNCOMMITTED)                         
              WHERE ACCOUNT_NO = :DL-ACCOUNT-NO                         
                AND AMT_TOT_RECONNECT > 0                               
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00230200
MFA-TR*      SELECT AMT_TOT_RECONNECT                                   00230300
MFA-TR*        INTO :DL-AMT-TOT-RECONNECT                               00230400
MFA-TR*        FROM CSS_RECONNECT                                       00230500
MFA-TR*       WHERE ACCOUNT_NO = :DL-ACCOUNT-NO                         00230600
MFA-TR*         AND AMT_TOT_RECONNECT > 0                               00230700
MFA-TR*        WITH UR                                                  00230800
MFA-TR*     QUERYNO 7170                                                00230900
MFA-TR*    END-EXEC                                                     00231000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7170'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_RECONNECT'       TO TABLE-1                     
              MOVE DL-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
           END-IF                                                       
           .                                                            
       7170-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 00233200
      * GET TOTAL CHARGED OFF AMOUNT                                  * 00233300
      *---------------------------------------------------------------* 00233400
       7400-DETERMINE-TOTAL-CO-AMT.                                     
                                                                        
           EXEC SQL                                                     
             SELECT SUM(AMT_TRANS)                                      
               INTO :WS-TOTAL-CHRG-OFF :WS-NULL-INDICATOR-5              
               FROM CSS_CHRG_OFF WITH(READUNCOMMITTED)                          
              WHERE ACCOUNT_NO  = :WS-ACCOUNT-NO-COMP3                  
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00233700
MFA-TR*      SELECT SUM(AMT_TRANS)                                      00233800
MFA-TR*        INTO :WS-TOTAL-CHRG-OFF:WS-NULL-INDICATOR-5              00233900
MFA-TR*        FROM CSS_CHRG_OFF                                        00234000
MFA-TR*       WHERE ACCOUNT_NO  = :WS-ACCOUNT-NO-COMP3                  00234100
MFA-TR*        WITH UR                                                  00234200
MFA-TR*     QUERYNO 7400                                                00234300
MFA-TR*    END-EXEC                                                     00234400

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7400'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CHRG_OFF'            TO TABLE-1                 
              MOVE WS-ACCOUNT-NO-COMP3       TO HOSTVAR-ELEMENT-1       
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*00236600
      *  SELECT CASH DRAWER DETAILS                                    *00236700
      *----------------------------------------------------------------*00236800
       7500-SELECT-CASH-CNTRL.                                          
                                                                        
           EXEC SQL                                                     
             SELECT AMT_CASH_DEBIT                                      
                   ,AMT_CASH_CREDIT                                     
                   ,AMT_AR_DEBIT                                        
                   ,AMT_AR_CREDIT                                       
                   ,AMT_CK_ISS_DEBIT                                    
                   ,AMT_CK_ISS_CREDIT                                   
                   ,AMT_GL_DEBIT                                        
                   ,AMT_GL_CREDIT                                       
                   ,CODE_CSH_DRWR_STAT                                  
                   ,NO_ITEMS_ENTERED                                    
               INTO :CS-AMT-CASH-DEBIT                                  
                   ,:CS-AMT-CASH-CREDIT                                 
                   ,:CS-AMT-AR-DEBIT                                    
                   ,:CS-AMT-AR-CREDIT                                   
                   ,:CS-AMT-CK-ISS-DEBIT                                
                   ,:CS-AMT-CK-ISS-CREDIT                               
                   ,:CS-AMT-GL-DEBIT                                    
                   ,:CS-AMT-GL-CREDIT                                   
                   ,:CS-CODE-CSH-DRWR-STAT                              
                   ,:CS-NO-ITEMS-ENTERED                                
               FROM CSS_CSH_DRWR_CNTL WITH(READUNCOMMITTED)                     
              WHERE CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO            
                AND CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE          
                AND CASH_REPORT_NO     = :CS-CASH-REPORT-NO             
                AND DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )           
                AND CASH_DRAWER_ID     = :CS-CASH-DRAWER-ID             
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00237100
MFA-TR*      SELECT AMT_CASH_DEBIT                                      00237200
MFA-TR*            ,AMT_CASH_CREDIT                                     00237300
MFA-TR*            ,AMT_AR_DEBIT                                        00237400
MFA-TR*            ,AMT_AR_CREDIT                                       00237500
MFA-TR*            ,AMT_CK_ISS_DEBIT                                    00237600
MFA-TR*            ,AMT_CK_ISS_CREDIT                                   00237700
MFA-TR*            ,AMT_GL_DEBIT                                        00237800
MFA-TR*            ,AMT_GL_CREDIT                                       00237900
MFA-TR*            ,CODE_CSH_DRWR_STAT                                  00238000
MFA-TR*            ,NO_ITEMS_ENTERED                                    00238100
MFA-TR*        INTO :CS-AMT-CASH-DEBIT                                  00238200
MFA-TR*            ,:CS-AMT-CASH-CREDIT                                 00238300
MFA-TR*            ,:CS-AMT-AR-DEBIT                                    00238400
MFA-TR*            ,:CS-AMT-AR-CREDIT                                   00238500
MFA-TR*            ,:CS-AMT-CK-ISS-DEBIT                                00238600
MFA-TR*            ,:CS-AMT-CK-ISS-CREDIT                               00238700
MFA-TR*            ,:CS-AMT-GL-DEBIT                                    00238800
MFA-TR*            ,:CS-AMT-GL-CREDIT                                   00238900
MFA-TR*            ,:CS-CODE-CSH-DRWR-STAT                              00239000
MFA-TR*            ,:CS-NO-ITEMS-ENTERED                                00239100
MFA-TR*        FROM CSS_CSH_DRWR_CNTL                                   00239200
MFA-TR*       WHERE CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO            00239300
MFA-TR*         AND CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE          00239400
MFA-TR*         AND CASH_REPORT_NO     = :CS-CASH-REPORT-NO             00239500
MFA-TR*         AND DATE_CASH_REPORT   = :CS-DATE-CASH-REPORT           00239600
MFA-TR*         AND CASH_DRAWER_ID     = :CS-CASH-DRAWER-ID             00239700
MFA-TR*        WITH UR                                                  00239800
MFA-TR*     QUERYNO 7500                                                00239900
MFA-TR*    END-EXEC                                                     00240000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7500'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_CSH_DRWR_CNTL'   TO TABLE-1                     
              MOVE CS-CASH-COMPANY-NO    TO HOSTVAR-ELEMENT-1           
              MOVE CS-CASH-LOCAL-OFFICE  TO HOSTVAR-ELEMENT-2           
              MOVE CS-DATE-CASH-REPORT   TO HOSTVAR-ELEMENT-3           
              MOVE CS-CASH-DRAWER-ID     TO HOSTVAR-ELEMENT-4           
              MOVE 'CASH_COMPANY_NO'     TO TABLE-ELEMENT-1             
              MOVE 'CASH_LOCAL_OFFICE'   TO TABLE-ELEMENT-2             
              MOVE 'DATE_CASH_REPORT'    TO TABLE-ELEMENT-3             
              MOVE 'CASH_DRAWER_ID'      TO TABLE-ELEMENT-4             
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *--------------------------------------------------------------*  00242900
      * CHECK FOR CIA                                                   00243000
      *--------------------------------------------------------------*  00243100
       7600-SELECT-CIA-IN-AR-CNTL.                                      
                                                                        
           EXEC SQL                                                     
             SELECT ACCOUNT_NO                                          
               INTO :AC-ACCOUNT-NO                                      
               FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                           
              WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                  
                AND PYMT_PRIORITY_LVL = 070                             
                AND ITEM_ID           = :AC-ITEM-ID                     
                                                                 
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     00243400
MFA-TR*      SELECT ACCOUNT_NO                                          00243500
MFA-TR*        INTO :AC-ACCOUNT-NO                                      00243600
MFA-TR*        FROM CSS_AR_CNTL                                         00243700
MFA-TR*       WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                  00243800
MFA-TR*         AND PYMT_PRIORITY_LVL = 070                             00243900
MFA-TR*         AND ITEM_ID           = :AC-ITEM-ID                     00244000
MFA-TR*        WITH UR                                                  00244100
MFA-TR*     QUERYNO 7600                                                00244200
MFA-TR*    END-EXEC                                                     00244300

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE             
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7600'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_AR-CNTL'          TO TABLE-1                    
              MOVE AC-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              MOVE '070'                  TO HOSTVAR-ELEMENT-2          
              MOVE AC-ITEM-ID             TO HOSTVAR-ELEMENT-3          
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE 'PYMT_PRIORITY_LVL'    TO TABLE-ELEMENT-2            
              MOVE 'ITEM_ID'              TO TABLE-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *--------------------------------------------------------------*  00262500
      *   SELECT NEXT BUSINESS DATE                                     00262600
      *--------------------------------------------------------------*  00262700
       7750-SELECT-NEXT-DATE.                                           
                                                                        
           EXEC SQL                                                     
             SELECT BUSINESS_DAY_DT                                     
               INTO :1G-BUSINESS-DAY-DT                                 
               FROM CSS_BUSINESS_DAYS WITH(READUNCOMMITTED)                     
              WHERE BUS_DAY_DT_SEQ =                                    
                      ((SELECT MIN(BUS_DAY_DT_SEQ)                      
                          FROM CSS_BUSINESS_DAYS WITH(READUNCOMMITTED)          
                         WHERE BUSINESS_DAY_DT >= IIF(TRY_CONVERT(DATE, 
                                                    :1G-BUSINESS-DAY-DT
              ) IS NULL OR (PATINDEX('%.%', :1G-BUSINESS-DAY-DT
              ) <> 0) OR (LEN(:1G-BUSINESS-DAY-DT
              ) <> 10), CIS.CHAR2DATE(:1G-BUSINESS-DAY-DT
              ), CONVERT(DATE, :1G-BUSINESS-DAY-DT) )   
                           AND COMPANY_NO = '01') + :WS-ADD)            
                AND COMPANY_NO = '01'                                   
                                                            
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00263000
MFA-TR*      SELECT BUSINESS_DAY_DT                                     00263100
MFA-TR*        INTO :1G-BUSINESS-DAY-DT                                 00263200
MFA-TR*        FROM CSS_BUSINESS_DAYS                                   00263300
MFA-TR*       WHERE BUS_DAY_DT_SEQ =                                    00263400
MFA-TR*               ((SELECT MIN(BUS_DAY_DT_SEQ)                      00263500
MFA-TR*                   FROM CSS_BUSINESS_DAYS                        00263600
MFA-TR*                  WHERE BUSINESS_DAY_DT >= :1G-BUSINESS-DAY-DT   00263700
MFA-TR*                    AND COMPANY_NO = '01') + :WS-ADD)            00263800
MFA-TR*         AND COMPANY_NO = '01'                                   00263900
MFA-TR*     QUERYNO 7750                                                00264000
MFA-TR*        WITH UR                                                  00264100
MFA-TR*    END-EXEC                                                     00264200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7750'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_BUSINESS_DAYS'       TO TABLE-1                 
              MOVE 'BUSINESS_DAY_DT'         TO TABLE-ELEMENT-1         
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-2         
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-3         
              MOVE 1G-BUSINESS-DAY-DT        TO HOSTVAR-ELEMENT-1       
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-2       
              MOVE '01'                      TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7750-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *--------------------------------------------------------------*  00266600
      *   A/R LOCKOUT                                                   00266700
      *--------------------------------------------------------------*  00266800
           EXEC SQL                                                     00266900
              INCLUDE CPD00075                                          00267000
           END-EXEC.                                                    00267100
                                                                        
      *--------------------------------------------------------------*  00267300
      *   A/R TRANSFER INDICATOR                                        00267400
      *--------------------------------------------------------------*  00267500
           EXEC SQL                                                     00267600
              INCLUDE CPD00307                                          00267700
           END-EXEC.                                                    00267800
                                                                        
      *--------------------------------------------------------------*  00268000
      *   INSERT A ROW IN AR CONTROL TABLE                           *  00268100
      *--------------------------------------------------------------*  00268200
       8000-INSERT-CIA-IN-AR-CNTL.                                      
           EXEC SQL                                                     
               INSERT INTO CSS_AR_CNTL                                  
                   (ACCOUNT_NO,                                         
                    PYMT_PRIORITY_LVL,                                  
                    ITEM_ID,                                            
                    AMT_AR_DAY_00,                                      
                    AMT_AR_DAY_30,                                      
                    AMT_AR_DAY_60,                                      
                    AMT_AR_DAY_90,                                      
                    AMT_UNUSED_CR,                                      
                    TOT_SUMM_UNBILLED,                                  
                    AMT_TRAN_BALANCE,                                   
                    LAST_UPDATE_TS)                                     
                VALUES                                                  
                   (:AC-ACCOUNT-NO,                                     
                    70,                                                 
                    :AC-ITEM-ID,                                        
                    0,                                                  
                    0,                                                  
                    0,                                                  
                    0,                                                  
                    0,                                                  
                    0,                                                  
                    0,                                                  
                    CIS.CURRENT$TIMESTAMP())                                  
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     00268400
MFA-TR*        INSERT INTO CSS_AR_CNTL                                  00268500
MFA-TR*            (ACCOUNT_NO,                                         00268600
MFA-TR*             PYMT_PRIORITY_LVL,                                  00268700
MFA-TR*             ITEM_ID,                                            00268800
MFA-TR*             AMT_AR_DAY_00,                                      00268900
MFA-TR*             AMT_AR_DAY_30,                                      00269000
MFA-TR*             AMT_AR_DAY_60,                                      00269100
MFA-TR*             AMT_AR_DAY_90,                                      00269200
MFA-TR*             AMT_UNUSED_CR,                                      00269300
MFA-TR*             TOT_SUMM_UNBILLED,                                  00269400
MFA-TR*             AMT_TRAN_BALANCE,                                   00269500
MFA-TR*             LAST_UPDATE_TS)                                     00269600
MFA-TR*         VALUES                                                  00269700
MFA-TR*            (:AC-ACCOUNT-NO,                                     00269800
MFA-TR*             70,                                                 00269900
MFA-TR*             :AC-ITEM-ID,                                        00270000
MFA-TR*             0,                                                  00270100
MFA-TR*             0,                                                  00270200
MFA-TR*             0,                                                  00270300
MFA-TR*             0,                                                  00270400
MFA-TR*             0,                                                  00270500
MFA-TR*             0,                                                  00270600
MFA-TR*             0,                                                  00270700
MFA-TR*             CURRENT TIMESTAMP)                                  00270800
MFA-TR*    END-EXEC                                                     00270900

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_AR_CNTL'             TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'PYMT_PRIORITY_LVL'       TO TABLE-ELEMENT-2         
              MOVE 'ITEM_ID'                 TO TABLE-ELEMENT-3         
              MOVE AC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE '70'                      TO HOSTVAR-ELEMENT-2       
              MOVE AC-ITEM-ID                TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT285*---------------------------------------------------------------* 42411000
ACT285* UPDATES ERROR CODE WITH CANCEL DNP FLAG INDICATOR VALUE       * 42412000
ACT285*---------------------------------------------------------------* 42413000
ACT285                                                                  
ACT285 8100-UPDATE-DNP-CODE.                                            
ACT285                                                                  
ACT285     MOVE 'Y' TO JT-ERROR-CD(2:1)                                 
ACT285                                                                  
ACT285     EXEC SQL                                                     
ACT285       UPDATE CSS_PAYMENT_TRANS                                   
ACT285          SET ERROR_CD = :JT-ERROR-CD                             
ACT285        WHERE DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :JT-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :JT-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:JT-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:JT-DATE-CASH-REPORT
              ), CONVERT(DATE, :JT-DATE-CASH-REPORT) )            
ACT285          AND CASH_LOCAL_OFFICE = :JT-CASH-LOCAL-OFFICE           
ACT285          AND PYMT_RCVD_TS      = CIS.CHAR2TIMESTAMP(
                                                       :JT-PYMT-RCVD-TS
              )                
ACT285          AND ACCOUNT_NO        = :JT-ACCOUNT-NO                  
ACT285     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     42416000
MFA-TR*      UPDATE CSS_PAYMENT_TRANS                                   42417000
MFA-TR*         SET ERROR_CD = :JT-ERROR-CD                             42418000
MFA-TR*       WHERE DATE_CASH_REPORT  = :JT-DATE-CASH-REPORT            42419500
MFA-TR*         AND CASH_LOCAL_OFFICE = :JT-CASH-LOCAL-OFFICE           42419600
MFA-TR*         AND PYMT_RCVD_TS      = :JT-PYMT-RCVD-TS                42419700
MFA-TR*         AND ACCOUNT_NO        = :JT-ACCOUNT-NO                  42419800
MFA-TR*    END-EXEC                                                     42420100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT285                                                                  
ACT285     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
ACT285                     S-RETURN-CODE                                
ACT285                                                                  
ACT285     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
ACT285        CONTINUE                                                  
ACT285     ELSE                                                         
ACT285        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
ACT285        MOVE '8100'                TO ACTIVE-PARAGRAPH            
ACT285        MOVE 'UPDATE'              TO ABEND-FUNCTION              
ACT285        MOVE SPACES                TO ABEND-SQL-PREDICATES        
ACT285                                      ABEND-TABLES                
ACT285        MOVE 'CSS_PAYMENT_TRANS'   TO TABLE-1                     
ACT285        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
ACT285        MOVE JT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
ACT285        MOVE 'PYMT_RCVD_TS'             TO TABLE-ELEMENT-2        
ACT285        MOVE JT-PYMT-RCVD-TS            TO HOSTVAR-ELEMENT-2      
ACT285        MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-3        
ACT285        MOVE JT-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-3      
ACT285        MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4        
ACT285        MOVE JT-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4      
ACT285        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
ACT285        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
ACT285     END-IF                                                       
ACT285     .                                                            
ACT285 8100-EXIT.                                                       
ACT285     EXIT.                                                        
ACT285*                                                                 42423100
      *--------------------------------------------------------------*  00277300
      *   CREATE A CONTRACT                                          *  00277400
      *--------------------------------------------------------------*  00277500
       8500-INSERT-CONTRACT.                                            
           EXEC SQL                                                     
              INSERT INTO CSS_CONTRACT                                  
                ( ACCOUNT_NO,         PYMT_PRIORITY_LVL,                
                  CNT_ITEM_ID,        DATE_CONTRACT,                    
                  AMT_MO_PYMT,        DATE_PYMT_START,                  
                  CODE_INTRST_METH,   INTRST_RATE,                      
                  INTRST_PRIOR_YR,    INTRST_YTD,                       
                  NO_SCHED_PYMTS,     AMT_ORIG_ENTERED,                 
                  AMT_DOWN_PYMT,      AMT_TAX_STATE,                    
                  AMT_TAX_CITY,       AMT_TAX_OTHER,                    
                  CODE_CONTRACT_TYPE, SIMPLE_INT_FIN_CHG,               
                  CNT_STATUS_CD,      CNT_NAME_CD,                      
                  USER_ID,            LIEN_CD,                          
                  REL_CNT_ITEM_ID,    CODE_COMPLY_HIST,                 
                  LAST_UPDATE_TS,     AMT_DEF_INTEREST,                 
                  REBATE_AMOUNT,      REBATE_CD,                        
                  CREDIT_CARD_NUMBER, CODE_BILL_TYPE,                   
                  CREDIT_EXEMPT_CODE, STATUS_CHANGE_DT,                 
                  CONTRACT_COMMENTS )                                   
              VALUES ( :CT-ACCOUNT-NO,         :CT-PYMT-PRIORITY-LVL,   
                       :CT-CNT-ITEM-ID,        CAST(SYSDATETIMEOFFSET() 
           AS DATE),            
                       :CT-AMT-MO-PYMT,        CAST(SYSDATETIMEOFFSET() 
           AS DATE),            
                       :CT-CODE-INTRST-METH,   :CT-INTRST-RATE,         
                       :CT-INTRST-PRIOR-YR,    :CT-INTRST-YTD,          
                       :CT-NO-SCHED-PYMTS,     :CT-AMT-ORIG-ENTERED,    
                       :CT-AMT-DOWN-PYMT,      :CT-AMT-TAX-STATE,       
                       :CT-AMT-TAX-CITY,       :CT-AMT-TAX-OTHER,       
                       :CT-CODE-CONTRACT-TYPE, :CT-SIMPLE-INT-FIN-CHG,  
                       :CT-CNT-STATUS-CD,      :CT-CNT-NAME-CD,         
                       :CT-USER-ID,            :CT-LIEN-CD,             
                       :CT-REL-CNT-ITEM-ID,    :CT-CODE-COMPLY-HIST,    
                       CIS.CURRENT$TIMESTAMP(),      
                                                  :CT-AMT-DEF-INTEREST,    
                       :CT-REBATE-AMOUNT,      :CT-REBATE-CD,           
                       :CT-CREDIT-CARD-NUMBER, :CT-CODE-BILL-TYPE,      
                       :CT-CREDIT-EXEMPT-CODE,                          
                       IIF(TRY_CONVERT(DATE, :CT-STATUS-CHANGE-DT 
                                             :WS-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :CT-STATUS-CHANGE-DT 
                                                           :WS-NULL-IND
              ) <> 0) OR (LEN(:CT-STATUS-CHANGE-DT :WS-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:CT-STATUS-CHANGE-DT :WS-NULL-IND
              ), CONVERT(DATE, :CT-STATUS-CHANGE-DT :WS-NULL-IND) ),           
                       :CT-CONTRACT-COMMENTS )                          
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00277700
MFA-TR*       INSERT INTO CSS_CONTRACT                                  00277800
MFA-TR*         ( ACCOUNT_NO,         PYMT_PRIORITY_LVL,                00277900
MFA-TR*           CNT_ITEM_ID,        DATE_CONTRACT,                    00278000
MFA-TR*           AMT_MO_PYMT,        DATE_PYMT_START,                  00278100
MFA-TR*           CODE_INTRST_METH,   INTRST_RATE,                      00278200
MFA-TR*           INTRST_PRIOR_YR,    INTRST_YTD,                       00278300
MFA-TR*           NO_SCHED_PYMTS,     AMT_ORIG_ENTERED,                 00278400
MFA-TR*           AMT_DOWN_PYMT,      AMT_TAX_STATE,                    00278500
MFA-TR*           AMT_TAX_CITY,       AMT_TAX_OTHER,                    00278600
MFA-TR*           CODE_CONTRACT_TYPE, SIMPLE_INT_FIN_CHG,               00278700
MFA-TR*           CNT_STATUS_CD,      CNT_NAME_CD,                      00278800
MFA-TR*           USER_ID,            LIEN_CD,                          00278900
MFA-TR*           REL_CNT_ITEM_ID,    CODE_COMPLY_HIST,                 00279000
MFA-TR*           LAST_UPDATE_TS,     AMT_DEF_INTEREST,                 00279100
MFA-TR*           REBATE_AMOUNT,      REBATE_CD,                        00279200
MFA-TR*           CREDIT_CARD_NUMBER, CODE_BILL_TYPE,                   00279300
MFA-TR*           CREDIT_EXEMPT_CODE, STATUS_CHANGE_DT,                 00279400
MFA-TR*           CONTRACT_COMMENTS )                                   00279500
MFA-TR*       VALUES ( :CT-ACCOUNT-NO,         :CT-PYMT-PRIORITY-LVL,   00279600
MFA-TR*                :CT-CNT-ITEM-ID,        CURRENT DATE,            00279700
MFA-TR*                :CT-AMT-MO-PYMT,        CURRENT DATE,            00279800
MFA-TR*                :CT-CODE-INTRST-METH,   :CT-INTRST-RATE,         00279900
MFA-TR*                :CT-INTRST-PRIOR-YR,    :CT-INTRST-YTD,          00280000
MFA-TR*                :CT-NO-SCHED-PYMTS,     :CT-AMT-ORIG-ENTERED,    00280100
MFA-TR*                :CT-AMT-DOWN-PYMT,      :CT-AMT-TAX-STATE,       00280200
MFA-TR*                :CT-AMT-TAX-CITY,       :CT-AMT-TAX-OTHER,       00280300
MFA-TR*                :CT-CODE-CONTRACT-TYPE, :CT-SIMPLE-INT-FIN-CHG,  00280400
MFA-TR*                :CT-CNT-STATUS-CD,      :CT-CNT-NAME-CD,         00280500
MFA-TR*                :CT-USER-ID,            :CT-LIEN-CD,             00280600
MFA-TR*                :CT-REL-CNT-ITEM-ID,    :CT-CODE-COMPLY-HIST,    00280700
MFA-TR*                CURRENT TIMESTAMP,      :CT-AMT-DEF-INTEREST,    00280800
MFA-TR*                :CT-REBATE-AMOUNT,      :CT-REBATE-CD,           00280900
MFA-TR*                :CT-CREDIT-CARD-NUMBER, :CT-CODE-BILL-TYPE,      00281000
MFA-TR*                :CT-CREDIT-EXEMPT-CODE,                          00281100
MFA-TR*                :CT-STATUS-CHANGE-DT:WS-NULL-IND,                00281200
MFA-TR*                :CT-CONTRACT-COMMENTS )                          00281300
MFA-TR*    END-EXEC                                                     00281400

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8500'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_CONTRACT'            TO TABLE-1                 
              MOVE CT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE CT-CNT-ITEM-ID            TO HOSTVAR-ELEMENT-2       
              MOVE CT-USER-ID                TO HOSTVAR-ELEMENT-3       
              MOVE CT-STATUS-CHANGE-DT       TO HOSTVAR-ELEMENT-4       
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'CNT_ITEM_ID'             TO TABLE-ELEMENT-2         
              MOVE 'USER_ID'                 TO TABLE-ELEMENT-3         
              MOVE 'STATUS_CHANGE_DT'        TO TABLE-ELEMENT-4         
              PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
           END-IF                                                       
           .                                                            
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 00294000
      * INSERT A ROW IN DNP CANCEL TABLE                              * 00294100
      *                                                               * 00294200
      *---------------------------------------------------------------* 00294300
       8610-INSERT-SO-DNP-CANCEL.                                       
                                                                        
           MOVE WS-U                         TO XK-SO-UPDT-ACTION-FL    
           MOVE WS-ACCOUNT-NO                TO XK-ACCOUNT-NO           
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_SO_DNP_CANCEL                              
                    (ACCOUNT_NO,                                        
                     SO_UPDT_ACTION_FL)                                 
             VALUES (:XK-ACCOUNT-NO,                                    
                     :XK-SO-UPDT-ACTION-FL)                             
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
              WS-ACTIVE-RETURN-CODE EQUAL -803                          
              MOVE ZERO TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE                               
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8610'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_SO_DNP_CANCEL'       TO TABLE-1                 
              MOVE XK-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE XK-SO-UPDT-ACTION-FL      TO HOSTVAR-ELEMENT-2       
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'SO_UPDT_ACTION_FL'       TO TABLE-ELEMENT-2         
              PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
           END-IF                                                       
           .                                                            
       8610-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 00298100
      * INSERTS PAYMENT TRANSACTION IN CSS_PAYMENT_TRANS TABLE        * 00298200
      *---------------------------------------------------------------* 00298300
                                                                        
       8700-INSERT-PAYMENT-TRANS.                                       
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_PAYMENT_TRANS                              
                  (                                                     
                   DATE_CASH_REPORT                                     
                  ,CASH_LOCAL_OFFICE                                    
                  ,PYMT_RCVD_TS                                         
                  ,ACCOUNT_NO                                           
                  ,APPL_PROGRAM_ID                                      
                  ,APPLIED_FL                                           
                  ,APPLIED_TS                                           
                  ,COMPANY_NO                                           
                  ,CREDIT_CARD_TYPE                                     
                  ,CURRENCY_TYPE                                        
                  ,CUST_PHONE_NO                                        
                  ,DIRECTED_PYMT_CD                                     
                  ,ERROR_CD                                             
                  ,PAYMENT_AMT                                          
                  ,PYMT_CONFIRM_NO                                      
                  ,PYMT_FACILITY_CD                                     
                  ,LAST_UPDATE_USERID                                   
                  ,ORIG_PYMT_TS                                         
                  ,RECONCILED_FL                                        
                  ,TRANS_HIST_SEQ_NO                                    
                  ,TRANS_TYPE_CD                                        
                  ,RECONCILED_DT                                        
                  ,TERMINAL_ID                                          
                  )                                                     
             VALUES                                                     
                  (                                                     
                   IIF(TRY_CONVERT(DATE, :JT-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :JT-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:JT-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:JT-DATE-CASH-REPORT
              ), CONVERT(DATE, :JT-DATE-CASH-REPORT) )                         
                  ,:JT-CASH-LOCAL-OFFICE                                
                  ,CIS.CHAR2TIMESTAMP(:JT-PYMT-RCVD-TS)                         
                  ,:JT-ACCOUNT-NO                                       
                  ,:JT-APPL-PROGRAM-ID                                  
                  ,:JT-APPLIED-FL                                       
                  ,CIS.CHAR2TIMESTAMP(:JT-APPLIED-TS)                           
                  ,:JT-COMPANY-NO                                       
                  ,:JT-CREDIT-CARD-TYPE                                 
                  ,:JT-CURRENCY-TYPE                                    
                  ,:JT-CUST-PHONE-NO                                    
                  ,:JT-DIRECTED-PYMT-CD                                 
                  ,:JT-ERROR-CD                                         
                  ,:JT-PAYMENT-AMT                                      
                  ,:JT-PYMT-CONFIRM-NO                                  
                  ,:JT-PYMT-FACILITY-CD                                 
                  ,:JT-LAST-UPDATE-USERID                               
                  ,NULL                                                 
                  ,'N'                                                  
                  ,CIS.CHAR2TIMESTAMP(:JT-TRANS-HIST-SEQ-NO)                    
                  ,'P'                                                  
                  ,NULL                                                 
                  ,NULL                                                 
                  )                                                     
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     00298700
MFA-TR*      INSERT INTO CSS_PAYMENT_TRANS                              00298800
MFA-TR*           (                                                     00298900
MFA-TR*            DATE_CASH_REPORT                                     00299000
MFA-TR*           ,CASH_LOCAL_OFFICE                                    00299100
MFA-TR*           ,PYMT_RCVD_TS                                         00299200
MFA-TR*           ,ACCOUNT_NO                                           00299300
MFA-TR*           ,APPL_PROGRAM_ID                                      00299400
MFA-TR*           ,APPLIED_FL                                           00299500
MFA-TR*           ,APPLIED_TS                                           00299600
MFA-TR*           ,COMPANY_NO                                           00299700
MFA-TR*           ,CREDIT_CARD_TYPE                                     00299800
MFA-TR*           ,CURRENCY_TYPE                                        00299900
MFA-TR*           ,CUST_PHONE_NO                                        00300000
MFA-TR*           ,DIRECTED_PYMT_CD                                     00300100
MFA-TR*           ,ERROR_CD                                             00300200
MFA-TR*           ,PAYMENT_AMT                                          00300300
MFA-TR*           ,PYMT_CONFIRM_NO                                      00300400
MFA-TR*           ,PYMT_FACILITY_CD                                     00300500
MFA-TR*           ,LAST_UPDATE_USERID                                   00300600
MFA-TR*           ,ORIG_PYMT_TS                                         00300700
MFA-TR*           ,RECONCILED_FL                                        00300800
MFA-TR*           ,TRANS_HIST_SEQ_NO                                    00300900
MFA-TR*           ,TRANS_TYPE_CD                                        00301000
MFA-TR*           ,RECONCILED_DT                                        00301100
MFA-TR*           ,TERMINAL_ID                                          00301200
MFA-TR*           )                                                     00301300
MFA-TR*      VALUES                                                     00301400
MFA-TR*           (                                                     00301500
MFA-TR*            :JT-DATE-CASH-REPORT                                 00301600
MFA-TR*           ,:JT-CASH-LOCAL-OFFICE                                00301700
MFA-TR*           ,:JT-PYMT-RCVD-TS                                     00301800
MFA-TR*           ,:JT-ACCOUNT-NO                                       00301900
MFA-TR*           ,:JT-APPL-PROGRAM-ID                                  00302000
MFA-TR*           ,:JT-APPLIED-FL                                       00302100
MFA-TR*           ,:JT-APPLIED-TS                                       00302200
MFA-TR*           ,:JT-COMPANY-NO                                       00302300
MFA-TR*           ,:JT-CREDIT-CARD-TYPE                                 00302400
MFA-TR*           ,:JT-CURRENCY-TYPE                                    00302500
MFA-TR*           ,:JT-CUST-PHONE-NO                                    00302600
MFA-TR*           ,:JT-DIRECTED-PYMT-CD                                 00302700
MFA-TR*           ,:JT-ERROR-CD                                         00302800
MFA-TR*           ,:JT-PAYMENT-AMT                                      00302900
MFA-TR*           ,:JT-PYMT-CONFIRM-NO                                  00303000
MFA-TR*           ,:JT-PYMT-FACILITY-CD                                 00303100
MFA-TR*           ,:JT-LAST-UPDATE-USERID                               00303200
MFA-TR*           ,NULL                                                 00303300
MFA-TR*           ,'N'                                                  00303400
MFA-TR*           ,:JT-TRANS-HIST-SEQ-NO                                00303500
MFA-TR*           ,'P'                                                  00303600
MFA-TR*           ,NULL                                                 00303700
MFA-TR*           ,NULL                                                 00303800
MFA-TR*           )                                                     00303900
MFA-TR*    END-EXEC                                                     00304000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE                               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8700'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_PAYMENT_TRANS'       TO TABLE-1                 
              MOVE 'CASH_LOCAL_OFFICE'       TO TABLE-ELEMENT-1         
              MOVE JT-CASH-LOCAL-OFFICE      TO HOSTVAR-ELEMENT-1       
              MOVE 'DATE_CASH_REPORT'        TO TABLE-ELEMENT-2         
              MOVE JT-DATE-CASH-REPORT       TO HOSTVAR-ELEMENT-2       
              MOVE 'PYMT_RCVD_TS'            TO TABLE-ELEMENT-3         
              MOVE JT-PYMT-RCVD-TS           TO HOSTVAR-ELEMENT-3       
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-4         
              MOVE JT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-4       
              MOVE 'N'                       TO SEND-DONE-SW            
              MOVE WS-ACTIVE-RETURN-CODE     TO ABEND-SQLCODE           
              MOVE SQLERRMC                  TO ABEND-SQLERRMC          
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       8700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 00321200
      * PERFORM A COMMIT.                                             * 00321300
      *                                                               * 00321400
      *---------------------------------------------------------------* 00321500
       8999-ISSUE-COMMIT.                                               
                                                                        
           EXEC SQL                                                     00321800
              INCLUDE CPD00047                                          00321900
           END-EXEC                                                     00322000
           .                                                            00322100
                                                    
       8999-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------- 00322500
      *  RETRIEVES LAST UPDATE TIMESTAMP FOR AN ACCOUNT                 00322600
      *---------------------------------------------------------------- 00322700
      *                                                                 00322800
       9200-LINK-SCSCA182.                                              
                                                                        
           MOVE '9200'                        TO ACTIVE-PARAGRAPH       
                                                                        
           CALL MCSCA182  USING  SCSCA182-ACCOUNT-NO                    
                                ,SCSCA182-RETURN-CODE                   
                                ,SCSCA182-LAST-UPDATE-TS                
                                ,ABEND-FILE                             
           .                                                            
       9200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*00324100
      * SELECTS ALL GLS                                                *00324200
      *----------------------------------------------------------------*00324300
      *                                                                 00324400
       9400-CALL-CPD00061.                                              
                                                                        
           MOVE SPACES                    TO ABEND-FUNCTION             
           CALL MCSCO061  USING  WS-GL-ACCT-NAME                        
                                 WS-GL-ACCT-MAJOR-FIELDS                
                                 WS-VALID-COMPANY-NOS                   
                                 WS-GL-NAME-INFO                        
                                 WS-GL-ACCT-NO-TABLE                    
                                 ABEND-FILE                             
                                 RS-RETURN-CODE                         
                                                                        
           MOVE RS-RETURN-CODE            TO WS-ACTIVE-RETURN-CODE      
                                             S-RETURN-CODE              
                                                                        
           IF ABEND-FUNCTION  > SPACES                                  
              IF ABEND-FUNCTION EQUAL 'BADDATA'                         
                 MOVE -1                  TO RS-RETURN-CODE,            
                                             WS-ACTIVE-RETURN-CODE      
              END-IF                                                    
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
              PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT             
           END-IF                                                       
           .                                                            
       9400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------* 00329700
      * CANCEL DNP OR DNPFB                                           * 00329800
      *---------------------------------------------------------------* 00329900
ACT285 9800-CALL-MCS03414.                                              
                                                                        
ACT285     CALL MCS03414 USING   WS-ACCOUNT-NO-NUM                      
                                ,WS-UPDATE-ACTION-FL                    
                                ,PARM-FACILITY-CODE                     
                                ,WS-DNP-RET-CODE                        
ACT285                          ,WS-PYMT-AMOUNT                         
ACT285                          ,WS-PAYMENT-AMOUNT-TOTAL                
ACT285                          ,WS-CALL-TYPE                           
ACT285                          ,WS-CPD68-REQUIRED                      
ACT285                          ,WS-PROGRAM-NAME                        
ACT285                          ,WS-CPD68-ACTN-FL                       
ACT285                          ,WS-CNCL-DNP-ACTN-FL                    
P00948                          ,WS-CNCL-DNP-EMAIL-REQ-FL               
ACT285                          ,WS-SO-UPDT-ACTN-FL                     
ACT285                          ,WS-CRED-ARNG-ACTN-FL                   
ACT285                          ,ws-APPL-PROGRAM-ID                     
                                ,ABEND-FILE                             
           .                                                            
       9800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *--------------------------------------------------------------*  00331100
      *   9700-PROCESS-ABEND                                            00331200
      *--------------------------------------------------------------*  00331300
           EXEC SQL                                                     00331400
              INCLUDE CPD0023C                                          00331500
           END-EXEC.                                                    00331600
                                                                        
      *----------------------------------------------------------------*00331800
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *00331900
      *----------------------------------------------------------------*00332000
           EXEC SQL                                                     00332100
              INCLUDE CPDSP300                                          00332200
           END-EXEC.                                                    00332300
                                                                        
      *----------------------------------------------------------------*00332500
      *       END PROGRAM COPYLIB                                      *00332600
      *----------------------------------------------------------------*00332700
           EXEC SQL                                                     00332800
              INCLUDE CPD00321                                          00332900
           END-EXEC.                                                    00333000
                                                                        
