000100 IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02337.                                         
000300 DATE-WRITTEN.  04/10/96.                                         
000400 DATE-COMPILED.                                                   
000500                                                                  
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S337 CONVERTED TO DB2 SP CSR02337 ON 02/14/2006        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
000600******************************************************************        
000700*                                                                *        
000800*                SOUTH CAROLINA ELECTRIC & GAS                   *        
000900*                                                                *        
001000*  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
001100*                                                                *        
001200*  TRANID:        S337                                           *        
001300*  PROGRAM:       S337                                           *        
001400*  CALLING SP:    PA_S337                                        *        
001500*                                                                *        
001600******************************************************************        
001700*                 P R O G R A M  S U M M A R Y                   *        
001800*                                                                *        
001900*  THIS PROCEDURE IS USED TO RETRIEVE BILLING NAME AND           *        
002000*  ADDRESS VIA A CALL TO CPD00074.                               *        
002100******************************************************************        
002200*                                                                *        
002300*                     PROGRAM MODIFICATION LOG                   *        
002400*                                                                *        
002500*    DATE    INITIALS   COMMENTS                                 *        
002600*  --------  --------   ---------------------------------------  *        
002700*  04/16/96    CDS      PROCEDURE ORIGINALLY CODED.              *        
TP4657*  06/26/96    LMB      ADD TBATMISC FOR CPD00074                *        
TP5109*  08/08/96    CSG      ADD CPD0023C TO USE WITH CPD00074        *        
T12100*  07/14/97    TCB      ADDED CODE TO RETURN PREMISE ADDRESS IF  *        
T12100*                       SERVICE ADDRESS IS REQUESTED FROM THE    *        
T12100*                       RPC.                                     *        
CBSI  *  12/29/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *              MADRAS   ABEND PARAMETERS                         *        
T19381*  03/10/99    CBSI     IF THE FIRST FETCH RETURNS A NOT FOUND   *        
T19381*              MADRAS   SEND THE RESULT AND THEN EXIT. CORRECTED *        
T19381*                       PERFORM 9900-SQL-ERROR-ROUTINE THRU 9999-*        
T19381*                       EXIT TO 9900-EXIT IN 0100-INITIALIZE PARA*        
T27237* 04/24/03     SK88120  ADDED CODE TO GET CIG-ACCOUNT AND PASS   *        
T27237*                       THE INDICATOR.                          *         
C29188* 04/18/04     FMB      RETURN FULL NAME                         *        
C33097* 08/09/05     FMB      CORRECT PROBLEM WITH NAME ON BILL.       *        
REARCH* 02/14/06     CVNS     RPC TO COBOL DB2 SP CONVERSION.          *        
REARCH*              CHENNAI                                           *        
A37666* 10/28/10     SJ97149  RETRIEVE FROM HST_ACCOUNT FOR THE        *        
A37666*              ACT092   ARCHIVED ACCOUNTS IN UE_MAIL BUTTON FOR  *        
A37666*                       COMMUNICATION PANEL081                   *        
A04527* 06/06/13     MC95456  REMOVED UNUSED COPY BOOK CWS00056        *        
002800******************************************************************        
002900******************************************************************        
003000*                                                                *        
003100*                ---- BASIC SEQUENCE STRUCTURE ----              *        
003200*                                                                *        
003300*  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
003400*  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
003500*  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
003600*  3000 - 4999  NOT USED                                         *        
003700*  5000 - 5999  COMMON PROGRAM MODULES                           *        
003800*  6000 - 6999  COMMON SYSTEM MODULES                            *        
003900*  7000 - 7999  INPUT MODULES                                    *        
004000*  8000 - 8999  OUTPUT MODULES                                   *        
004100*  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
004200*                                                                *        
004300******************************************************************        
004400                                                                  
004500 ENVIRONMENT DIVISION.                                            
004600 DATA DIVISION.                                                   
004700 WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02337'.
MSQ017     COPY MFASQLM.
004800                                                                  
004900     EXEC SQL                                                             
005000         INCLUDE SQLCA                                                    
005100     END-EXEC.                                                            
005200                                                                  
005300******************************************************************        
005400*    AT - CSS_ACCOUNT                                            *        
005500******************************************************************        
005600     EXEC SQL                                                             
005700         INCLUDE TBACCT                                                   
005800     END-EXEC.                                                            
005900                                                                  
006000******************************************************************        
006100*    PR - CSS_PREMISE                                            *        
006200******************************************************************        
006300     EXEC SQL                                                             
006400         INCLUDE TBPREM                                                   
006500     END-EXEC.                                                            
006600                                                                  
006700******************************************************************        
006800*    PF - CSS_USER_PROFILE                                       *        
006900******************************************************************        
007000     EXEC SQL                                                             
007100         INCLUDE TBUSRPRF                                                 
007200     END-EXEC.                                                            
007300                                                                  
007400******************************************************************        
007500*    CU - CSS_CUSTOMER                                           *        
007600******************************************************************        
007700     EXEC SQL                                                             
007800         INCLUDE TBCUST                                                   
007900     END-EXEC.                                                            
008000                                                                  
008100******************************************************************        
008200*    DQ - CSS_NAME                                               *        
008300******************************************************************        
008400     EXEC SQL                                                             
008500         INCLUDE TBNAME                                                   
008600     END-EXEC.                                                            
008700                                                                  
008800******************************************************************        
008900*    HT - CSS_NAME_ACCT_XREF                                     *        
009000******************************************************************        
009100     EXEC SQL                                                             
009200         INCLUDE TBNMACTX                                                 
009300     END-EXEC.                                                            
009400                                                                  
009500******************************************************************        
009600*    DM - CSS_CUST_ADDR_XREF                                     *        
009700******************************************************************        
009800     EXEC SQL                                                             
009900         INCLUDE TBCSADRX                                                 
010000     END-EXEC.                                                            
010100                                                                  
010200******************************************************************        
010300*    DZ - CSS_ADDR_FREEFORM                                      *        
010400******************************************************************        
010500     EXEC SQL                                                             
010600         INCLUDE TBADRFRE                                                 
010700     END-EXEC.                                                            
010800                                                                  
010900******************************************************************        
011000*    DY - CSS_ADDR_FORMATTED                                     *        
011100******************************************************************        
011200     EXEC SQL                                                             
011300         INCLUDE TBADRFMT                                                 
011400     END-EXEC.                                                            
011500                                                                  
011600******************************************************************        
011700*    A4 - CSS_ZIP_CODE                                           *        
011800******************************************************************        
011900     EXEC SQL                                                             
012000         INCLUDE TBZIPCD                                                  
012100     END-EXEC.                                                            
012200******************************************************************        
012300*    CV - CSS_CONTACT                                            *        
012400******************************************************************        
012500     EXEC SQL                                                             
012600         INCLUDE TBCNTACT                                                 
012700     END-EXEC.                                                            
012800                                                                  
012900******************************************************************        
013000*    DT - CSS_CONTACT_CUST                                       *        
013100******************************************************************        
013200     EXEC SQL                                                             
013300         INCLUDE TBCNTCCS                                                 
013400     END-EXEC.                                                            
013500******************************************************************        
013600*    DW - CSS_CONTACT_ACCT                                       *        
013700******************************************************************        
013800     EXEC SQL                                                             
013900         INCLUDE TBCNTCAT                                                 
014000     END-EXEC.                                                            
014100                                                                  
TP4657******************************************************************        
TP4657*    TA - CSS_ACCT_MISC_INFO                                     *        
TP4657******************************************************************        
TP4657     EXEC SQL                                                             
TP4657         INCLUDE TBATMISC                                                 
TP4657     END-EXEC.                                                            
014100                                                                  
A37666******************************************************************        
A37666*    HA - HST_ACCOUNT                                            *        
A37666******************************************************************        
A37666     EXEC SQL                                                             
A37666         INCLUDE TBHACCT                                                  
A37666     END-EXEC.                                                            
A37666                                                                  
014200******************************************************************        
014300*    COMMON COPYLIBS                                             *        
014400******************************************************************        
014500                                                                  
014600* -- COBOL EQUATES FOR SYBASE OPEN SERVER FOR CICS FACILITIES             
CVT999*    COPY SYGWCOB.                                                        
014800                                                                  
014900* -- SUPPORT FOR CICS RPCS                                                
CVT999*    COPY SYDBCOB.                                                        
015100                                                                  
015200* -- ERROR HANDLING                                                       
CVT999*    COPY CWS00010.                                                       
015400                                                                  
015700* -- SUPPORTS DB2 AND SQL ERROR CHECKING                                  
015800     COPY CWS00303.                                                       
015900                                                                  
016000* -- USED BY CPD00074                                                     
016100     COPY CWS00074.                                                       
016200* -- USED BY CPD00004                                                     
016300     COPY CWS00011.                                                       
016400                                                                  
016500******************************************************************        
016600*    WORK AREAS                                                  *        
016700******************************************************************        
016800                                                                  
REARCH*01  GW-LIB-MISC-FIELDS.                                                  
CVT999*    05  GWL-PROC                     POINTER.                            
CVT999*    05  GWL-INIT-HANDLE              POINTER.                            
CVT999*    05  GWL-RC                       PIC S9(9) COMP.                     
CVT999*    05  GWL-STATUS-NR                PIC S9(9) COMP.                     
CVT999*    05  GWL-STATUS-DONE              PIC S9(9) COMP.                     
CVT999*    05  GWL-STATUS-COUNT             PIC S9(9) COMP.                     
CVT999*    05  GWL-STATUS-COMM              PIC S9(9) COMP.                     
CVT999*    05  GWL-STATUS-RETURN-CODE       PIC S9(9) COMP.                     
REARCH*    05  GWL-STATUS-SUBCODE           PIC S9(9) COMP.                     
017900                                                                  
018000 01  MESSAGE-FIELDS.                                              
018100     05  MSG-TYPE                     PIC S9(9) COMP.             
018200     05  MSG-SEVERITY                 PIC S9(9) COMP VALUE 11.    
018300     05  MSG-NR                       PIC S9(9) COMP VALUE  2.    
REARCH*    05  MSG-RPC                      PIC X(4) VALUE 'S337'.              
018500     05  MSG-RPC-L                    PIC S9(9) COMP.             
018600     05  MSG-TEXT                     PIC X(100).                 
018700     05  MSG-TEXT-L                   PIC S9(9) COMP.             
018800     05  MSG-SQL-ERROR.                                           
018900         10  FILLER                   PIC X(10)                   
019000                                      VALUE 'SQLCODE = '.         
019100         10  MSG-SQL-ERROR-C          PIC -9(3) DISPLAY.          
019200         10  FILLER                   PIC X(16)                   
019300             VALUE ', ERROR TOKENS: '.                            
019400         10  MSG-SQL-ERROR-K          PIC X(70).                  
019500         10  MSG-SQL-ERROR-K-CHARS                                
019600                                      REDEFINES MSG-SQL-ERROR-K   
019700                                      OCCURS 70 TIMES             
019800                                      PIC X.                      
019900     05  MSG-SQL-ERROR-SS             PIC S9(4) COMP.             
020000                                                                  
020100******************************************************************        
020200*    INPUT PARAMETERS                                            *        
020300******************************************************************        
020400                                                                  
020500 01  PARM-FIELDS.                                                 
020600     05  PARM-L                       PIC S9(9) COMP.             
CVT999*    05  PARM-ID1                     PIC S9(9) COMP VALUE 1.             
020800     05  PARM-CUST-NO                 PIC X(10).                  
020900     05  PARM-CUST-NO-NUM             REDEFINES PARM-CUST-NO      
021000                                      PIC 9(10).                  
021000     05  PARM-USER-ID                 PIC X(7).                   
021000     05  PARM-ADDRESS-TYPE            PIC X(01).                  
T27237     05  PARM-ACCOUNT-NO            PIC X(13).                    
T27237     05  PARM-ACCOUNT-NO-RED        REDEFINES PARM-ACCOUNT-NO     
T27237                                    PIC 9(13).                    
021000     05  PARM-ACCOUNT-NO-NUM        PIC S9(13)V COMP-3 VALUE 0.   
021300                                                                  
021400 01  SNA-FIELDS.                                                  
021500     05  SNA-SUBC                     PIC S9(9) COMP.             
CVT999*    05  SNA-CONNECTION-NAME          PIC X(8)  VALUE SPACE.              
021700                                                                  
021800 01  COUNTER-FIELDS.                                              
CVT999*    05  CTR-COLUMN                   PIC S9(9) COMP VALUE 1.             
022000     05  CTR-ROWS                     PIC S9(9) COMP VALUE 0.     
022100                                                                  
022200 01  WORK-FIELDS.                                                 
CVT999*    05  MAX-LENGTH-PARM              PIC S9(9) COMP.                     
CVT999*    05  WRKLEN1                      PIC S9(9) COMP.                     
CVT999*    05  WRKLEN2                      PIC S9(9) COMP.                     
022600     05  WRK-DONE-STATUS              PIC S9(9) COMP.             
022700                                                                  
022800******************************************************************        
022900*    RESULT SET FIELDS                                           *        
023000******************************************************************        
023100                                                                  
023200 01  GTT-RETURN-FIELDS.                                           
023300     05  RS-RETURN-CODE               PIC S9(9) COMP.             
023400     05  RS-CODE-ACCT-STAT            PIC X(01).                  
023500     05  RS-ACCOUNT-NO                PIC X(13).                  
023600     05  RS-ADDR-LINE-1               PIC X(50).                  
023700     05  RS-ADDR-LINE-2               PIC X(50).                  
023800     05  RS-ADDR-LINE-3               PIC X(50).                  
023900     05  RS-ADDR-LINE-4               PIC X(50).                  
024000     05  RS-ADDR-LINE-5               PIC X(50).                  
024100     05  RS-ADDR-LINE-6               PIC X(50).                  
024200     05  RS-NAME                      PIC X(50).                  
024300     05  RS-SERV-ADDR                 PIC X(50).                  
024400     05  RS-USER-NAME                 PIC X(50).                  
024500     05  RS-CONTACT-POSITION          PIC X(30).                  
024600     05  RS-CONTACT-TYPE              PIC X(02).                  
024610     05  RS-FREE-FORM                 PIC X(50).                  
T27237     05  RS-CIG-ACCOUNT               PIC X(01) VALUE SPACES.     
024700                                                                  
REARCH 01  TDS-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE                PIC S9(9) COMP.             
REARCH     05  S-CODE-ACCT-STAT             PIC X(01).                  
REARCH     05  S-ACCOUNT-NO                 PIC X(13).                  
REARCH     05  S-ADDR-LINE-1                PIC X(50).                  
REARCH     05  S-ADDR-LINE-2                PIC X(50).                  
REARCH     05  S-ADDR-LINE-3                PIC X(50).                  
REARCH     05  S-ADDR-LINE-4                PIC X(50).                  
REARCH     05  S-ADDR-LINE-5                PIC X(50).                  
REARCH     05  S-ADDR-LINE-6                PIC X(50).                  
REARCH     05  S-NAME                       PIC X(50).                  
REARCH     05  S-SERV-ADDR                  PIC X(50).                  
REARCH     05  S-USER-NAME                  PIC X(50).                  
REARCH     05  S-CONTACT-POSITION           PIC X(30).                  
REARCH     05  S-CONTACT-TYPE               PIC X(02).                  
REARCH     05  S-FREE-FORM                  PIC X(50).                  
REARCH     05  S-CIG-ACCOUNT                PIC X(01) VALUE SPACES.     
REARCH                                                                  
024800******************************************************************        
024900*    RESULT SET COLUMN NAMES                                     *        
025000******************************************************************        
025100                                                                  
CVT999*01  CN-COLUMN-NAMES.                                                     
CVT999*    05  CN-RETURN-CODE               PIC X(11)                           
CVT999*                                     VALUE 'RETURN_CODE'.                
CVT999*    05  CN-CODE-ACCT-STAT            PIC X(14)                           
CVT999*                                     VALUE 'CODE_ACCT_STAT'.             
CVT999*    05  CN-ACCOUNT-NO                PIC X(10)                           
CVT999*                                     VALUE 'ACCOUNT_NO'.                 
CVT999*    05  CN-ADDR-LINE-1               PIC X(11)                           
CVT999*                                     VALUE 'ADDR_LINE_1'.                
CVT999*    05  CN-ADDR-LINE-2               PIC X(11)                           
CVT999*                                     VALUE 'ADDR_LINE_2'.                
CVT999*    05  CN-ADDR-LINE-3               PIC X(11)                           
CVT999*                                     VALUE 'ADDR_LINE_3'.                
CVT999*    05  CN-ADDR-LINE-4               PIC X(11)                           
CVT999*                                     VALUE 'ADDR_LINE_4'.                
CVT999*    05  CN-ADDR-LINE-5               PIC X(11)                           
CVT999*                                     VALUE 'ADDR_LINE_5'.                
CVT999*    05  CN-ADDR-LINE-6               PIC X(11)                           
CVT999*                                     VALUE 'ADDR_LINE_6'.                
CVT999*    05  CN-NAME                      PIC X(4)                            
CVT999*                                     VALUE 'NAME'.                       
CVT999*    05  CN-SERV-ADDR                 PIC X(9)                            
CVT999*                                     VALUE 'SERV_ADDR'.                  
CVT999*    05  CN-USER-NAME                 PIC X(9)                            
CVT999*                                     VALUE 'USER_NAME'.                  
CVT999*    05  CN-CONTACT-POSITION          PIC X(16)                           
CVT999*                                     VALUE 'CONTACT_POSITION'.           
CVT999*    05  CN-CONTACT-TYPE              PIC X(12)                           
CVT999*                                     VALUE 'CONTACT_TYPE'.               
CVT999*    05  CN-FREE-FORM                 PIC X(09)                           
CVT999*                                     VALUE 'FREE_FORM'.                  
CVT999*    05  CN-CIG-ACCOUNT               PIC X(11)                           
CVT999*                                     VALUE 'CIG_ACCOUNT'.                
CVT999*                                                                         
028200 01  SWITCHES.                                                    
028300     05  ALL-DONE-SW                  PIC X VALUE 'N'.            
028400         88  NOT-ALL-DONE             VALUE 'N'.                  
028500         88  ALL-DONE                 VALUE 'Y'.                  
028600     05  SEND-DONE-SW                 PIC X VALUE 'Y'.            
028700         88  SEND-DONE-ERROR          VALUE 'N'.                  
028800         88  SEND-DONE-OK             VALUE 'Y'.                  
028900                                                                  
029000 01  WS-MISC-FIELDS.                                              
REARCH     05  PROGRAM-NAME                 PIC X(8) VALUE 'CSR02337'.  
029200     05  WS-USER-NAME                 PIC X(50).                  
029300     05  WS-BILLING-ADDRESS           PIC X(01) VALUE 'B'.        
029400     05  WS-SERVICE-ADDRESS           PIC X(01) VALUE 'S'.        
029500     05  WS-CUSTOMER-CONTACT          PIC X(01) VALUE 'C'.        
029600     05  WS-ACCOUNT-CONTACT           PIC X(01) VALUE 'A'.        
T27237     05  WS-CIG-ACCOUNT               PIC X(01) VALUE SPACES.     
T27237     05  MULTIPLE-ROWS                PIC S9(9) VALUE -811 COMP.  
029700     05  WS-ACCOUNT-NO-NUM            PIC 9(13).                  
029800     05  WS-ACCOUNT-NO-TXT REDEFINES WS-ACCOUNT-NO-NUM            
029900                                      PIC X(13).                  
C29188     05  WS-SUB1                      PIC S9(4) COMP VALUE 0.     
A37666     05  WS-CHK-NOR-ACCT              PIC X(1) VALUE 'N'.         
A37666     05  WS-CHK-HST-ACCT              PIC X(1) VALUE 'N'.         
030000*                                                                         
030100*****ACCOUNT SELECTION CURSOR***********************************          
030200*                                                                         
030300     EXEC SQL                                                     
030400         DECLARE ACCOUNT-SELECT-CSR CURSOR FOR                    
030500         SELECT  AT.ACCOUNT_NO,                                   
030600                 AT.ADDRESS_ID,                                   
030700                 AT.ADDRESS_FORMAT,                               
030800                 AT.CODE_ACCT_STAT                                
030900         FROM    CSS_ACCOUNT AT WITH(READUNCOMMITTED),                    
C29188                 CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)              
031000         WHERE   AT.CUSTOMER_NO = :AT-CUSTOMER-NO                 
C29188           AND   AT.ACCOUNT_NO = HT.ACCOUNT_NO                    
A37666           FOR READ ONLY                                  
A37666                                                      
031100     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE ACCOUNT-SELECT-CSR CURSOR FOR                            
MFA-TR*        SELECT  AT.ACCOUNT_NO,                                           
MFA-TR*                AT.ADDRESS_ID,                                           
MFA-TR*                AT.ADDRESS_FORMAT,                                       
MFA-TR*                AT.CODE_ACCT_STAT                                        
MFA-TR*        FROM    CSS_ACCOUNT AT,                                          
MFA-TR*                CSS_NAME_ACCT_XREF HT                                    
MFA-TR*        WHERE   AT.CUSTOMER_NO = :AT-CUSTOMER-NO                         
MFA-TR*          AND   AT.ACCOUNT_NO = HT.ACCOUNT_NO                            
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7000                                                   
MFA-TR*    END-EXEC.                                                            
031200*                                                                         
A37666*****HST ACCOUNT SELECTION CURSOR******************************           
A37666*                                                                         
A37666     EXEC SQL                                                     
A37666         DECLARE HST-ACCT-SELECT-CSR CURSOR FOR                   
A37666         SELECT  AT.ACCOUNT_NO,                                   
A37666                 AT.ADDRESS_ID,                                   
A37666                 AT.ADDRESS_FORMAT,                               
A37666                 AT.CODE_ACCT_STAT                                
A37666         FROM    HST_ACCOUNT AT WITH(READUNCOMMITTED),                    
A37666                 CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)              
A37666         WHERE   AT.CUSTOMER_NO = :AT-CUSTOMER-NO                 
A37666           AND   AT.ACCOUNT_NO = HT.ACCOUNT_NO                    
A37666           FOR READ ONLY                                  
A37666                                                      
A37666     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE HST-ACCT-SELECT-CSR CURSOR FOR                           
MFA-TR*        SELECT  AT.ACCOUNT_NO,                                           
MFA-TR*                AT.ADDRESS_ID,                                           
MFA-TR*                AT.ADDRESS_FORMAT,                                       
MFA-TR*                AT.CODE_ACCT_STAT                                        
MFA-TR*        FROM    HST_ACCOUNT AT,                                          
MFA-TR*                CSS_NAME_ACCT_XREF HT                                    
MFA-TR*        WHERE   AT.CUSTOMER_NO = :AT-CUSTOMER-NO                         
MFA-TR*          AND   AT.ACCOUNT_NO = HT.ACCOUNT_NO                            
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*          QUERYNO 7030                                                   
MFA-TR*    END-EXEC.                                                            
A37666*                                                                         
031300****CUSTOMER CONTACT CURSOR***********************************            
031400*                                                                         
031500     EXEC SQL                                                     
031600         DECLARE CUST-CONTACT-CSR CURSOR FOR                      
031700         SELECT  CONTACT_ID                                       
031800         FROM    CSS_CONTACT_CUST WITH(READUNCOMMITTED)                   
031900         WHERE   CUSTOMER_NO = :DT-CUSTOMER-NO                    
A37666         FOR READ ONLY                                    
A37666                                                      
032000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE CUST-CONTACT-CSR CURSOR FOR                              
MFA-TR*        SELECT  CONTACT_ID                                               
MFA-TR*        FROM    CSS_CONTACT_CUST                                         
MFA-TR*        WHERE   CUSTOMER_NO = :DT-CUSTOMER-NO                            
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            
032100*                                                                         
032200****ACCOUNT CONTACT CURSOR************************************            
032300*                                                                         
032400     EXEC SQL                                                     
032500         DECLARE ACCT-CONTACT-CSR CURSOR FOR                      
032600         SELECT  CONTACT_ID                                       
032700         FROM    CSS_CONTACT_ACCT WITH(READUNCOMMITTED)                   
032800         WHERE   ACCOUNT_NO = :DW-ACCOUNT-NO                      
A37666         FOR READ ONLY                                    
A37666                                                      
032900     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE ACCT-CONTACT-CSR CURSOR FOR                              
MFA-TR*        SELECT  CONTACT_ID                                               
MFA-TR*        FROM    CSS_CONTACT_ACCT                                         
MFA-TR*        WHERE   ACCOUNT_NO = :DW-ACCOUNT-NO                              
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*        QUERYNO 7400                                                     
MFA-TR*    END-EXEC.                                                            
033000                                                                  
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
REARCH*    10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        00001701
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         DECLARE C1 CURSOR  FOR                        
CVT000         SELECT                                                   
REARCH             RETURN_CODE                AS RETURN_CODE            
REARCH            ,LTRIM(RTRIM(CODE_ACCT_STAT))      AS CODE_ACCT_STAT         
REARCH            ,LTRIM(RTRIM(ACCOUNT_NO))          AS ACCOUNT_NO             
REARCH            ,LTRIM(RTRIM(ADDR_LINE_1))         AS ADDR_LINE_1            
REARCH            ,LTRIM(RTRIM(ADDR_LINE_2))         AS ADDR_LINE_2            
REARCH            ,LTRIM(RTRIM(ADDR_LINE_3))         AS ADDR_LINE_3            
REARCH            ,LTRIM(RTRIM(ADDR_LINE_4))         AS ADDR_LINE_4            
REARCH            ,LTRIM(RTRIM(ADDR_LINE_5))         AS ADDR_LINE_5            
REARCH            ,LTRIM(RTRIM(ADDR_LINE_6))         AS ADDR_LINE_6            
REARCH            ,LTRIM(RTRIM(NAME))                AS NAME                   
REARCH            ,LTRIM(RTRIM(SERV_ADDR))           AS SERV_ADDR              
REARCH            ,LTRIM(RTRIM(USER_NAME))           AS USER_NAME              
REARCH            ,LTRIM(RTRIM(CONTACT_POSITION))    AS CONTACT_POSITION       
REARCH            ,LTRIM(RTRIM(CONTACT_TYPE))        AS CONTACT_TYPE           
REARCH            ,LTRIM(RTRIM(FREE_FORM))           AS FREE_FORM              
REARCH            ,LTRIM(RTRIM(CIG_ACCOUNT))         AS CIG_ACCOUNT            
CVT000         FROM #CSR02337_R1                                 
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00000100
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        00000300
MFA-TR*        SELECT                                                   00000400
MFA-TR*            RETURN_CODE                AS RETURN_CODE            00000400
MFA-TR*           ,STRIP(CODE_ACCT_STAT)      AS CODE_ACCT_STAT         00000400
MFA-TR*           ,STRIP(ACCOUNT_NO)          AS ACCOUNT_NO             00000400
MFA-TR*           ,STRIP(ADDR_LINE_1)         AS ADDR_LINE_1            00000400
MFA-TR*           ,STRIP(ADDR_LINE_2)         AS ADDR_LINE_2            00000400
MFA-TR*           ,STRIP(ADDR_LINE_3)         AS ADDR_LINE_3            00000400
MFA-TR*           ,STRIP(ADDR_LINE_4)         AS ADDR_LINE_4            00000400
MFA-TR*           ,STRIP(ADDR_LINE_5)         AS ADDR_LINE_5            00000400
MFA-TR*           ,STRIP(ADDR_LINE_6)         AS ADDR_LINE_6            00000400
MFA-TR*           ,STRIP(NAME)                AS NAME                   00000400
MFA-TR*           ,STRIP(SERV_ADDR)           AS SERV_ADDR              00000400
MFA-TR*           ,STRIP(USER_NAME)           AS USER_NAME              00000400
MFA-TR*           ,STRIP(CONTACT_POSITION)    AS CONTACT_POSITION       00000400
MFA-TR*           ,STRIP(CONTACT_TYPE)        AS CONTACT_TYPE           00000400
MFA-TR*           ,STRIP(FREE_FORM)           AS FREE_FORM              00000400
MFA-TR*           ,STRIP(CIG_ACCOUNT)         AS CIG_ACCOUNT            00000400
MFA-TR*        FROM SESSION.CSR02337_R1                                 00000500
MFA-TR*    END-EXEC.                                                    00000700
CVT000                                                                  
                                                                        
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-CUST-NO             PIC X(10)                .          
CVT000 01  LINK-USER-ID             PIC X(7)                 .          
CVT000 01  LINK-ADDRESS-TYPE        PIC X(01)                .          
CVT000 01  LINK-ACCOUNT-NO          PIC X(13)                .          
COB305 01 LINK-ACCOUNT-NO-NUM        PIC S9(13)V COMP-3 VALUE 0.          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-CUST-NO                                            
CVT000         ,LINK-USER-ID                                            
CVT000         ,LINK-ADDRESS-TYPE                                       
CVT000         ,LINK-ACCOUNT-NO                                         
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                                      
033200                                                                  
033300******************************************************************        
033400* 0000-MAINLINE                                                  *        
033500*     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
033600******************************************************************        
033700                                                                  
033800 0000-MAINLINE.                                                   
033900                                                                  
034000     PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
034100     PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
034200     PERFORM 2000-MAIN-PROCESS   THRU 2000-EXIT.                  
T19381     IF  CTR-ROWS < 1                                             
T19381         MOVE 100                TO RS-RETURN-CODE                
REARCH         PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT               
T19381         PERFORM 8100-SEND-RESULT   THRU 8100-EXIT                
T19381     END-IF.                                                      
034300     PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
034400                                                                  
034500 0000-EXIT.                                                       
034600     EXIT.                                                        
HPCCDM*    EJECT                                                                
034800******************************************************************        
034900* 0100-INITIALIZE                                                *        
035000*                                                                *        
035100*     1. RESET DB2 ERROR HANDLERS                                *        
035200*     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
035300*     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
035400*     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
035500*                                                                *        
035600******************************************************************        
035700                                                                  
035800 0100-INITIALIZE.                                                 
035900                                                                  
CVT999*    EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.                      
036300                                                                  
CVT999*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.             
036500                                                                  
CVT999*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,             
CVT999*                          SNA-CONNECTION-NAME, SNA-SUBC.                 
036800                                                                  
CVT999*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                              
037000                                                                  
CVT999*    IF GWL-RC NOT = TDS-PARM-PRESENT                                     
CVT999*       MOVE PROGRAM-NAME                TO ABEND-PROGRAM                 
CVT999*       MOVE '0100'                      TO ACTIVE-PARAGRAPH              
CVT999*       MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION              
CVT999*       MOVE 'CICS TRANSACTION'          TO TABLE-1                       
CVT999*       MOVE GWL-RC                      TO WS-ACTIVE-RETURN-CODE         
CVT999*       PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT                   
CVT999*       PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT                   
CVT999*    END-IF.                                                              
038000                                                                  
038100     INITIALIZE GTT-RETURN-FIELDS.                                
038110*****************************************************************         
038120* FIELD FREE FORM IS USED ON THE MAIN DATAWINDOW FOR PANEL083   *         
038130* TO HOLD THE DISPLAYED VALUE IN THE FREE FORM DATA WINDOW.     *         
038140* THIS STATEMENT INITIALIZES THE FREE FORM FIELD BECAUSE NO     *         
038150* VALUES SHOULD BE PASSED BACK FROM THE MAINFRAME FOR THIS FIELD*         
038160*****************************************************************         
038200     MOVE SPACES                         TO RS-FREE-FORM.         
CVT000     MOVE LINK-CUST-NO              TO PARM-CUST-NO             . 
CVT000     MOVE LINK-USER-ID              TO PARM-USER-ID             . 
CVT000     MOVE LINK-ADDRESS-TYPE         TO PARM-ADDRESS-TYPE        . 
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
CVT000     PERFORM 0100A-DECLARE-GTT                                    
CVT000       THRU 0100A-EXIT.                                           
038300 0100-EXIT.                                                       
038400     EXIT.                                                        
                                                                        
CVT000 0100A-DECLARE-GTT.                                               
CVT000     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02337_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02337_R1
              (                                                          
CVT000         RETURN_CODE              INT                         
CVT000        ,CODE_ACCT_STAT CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
CVT000        ,ACCOUNT_NO CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2             
CVT000        ,ADDR_LINE_1 CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2            
CVT000        ,ADDR_LINE_2 CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2            
CVT000        ,ADDR_LINE_3 CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2            
CVT000        ,ADDR_LINE_4 CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2            
CVT000        ,ADDR_LINE_5 CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2            
CVT000        ,ADDR_LINE_6 CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2            
CVT000        ,NAME CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2                   
CVT000        ,SERV_ADDR CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2              
CVT000        ,USER_NAME CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2              
CVT000        ,CONTACT_POSITION CHAR(30)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,CONTACT_TYPE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2           
CVT000        ,FREE_FORM CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2              
CVT000        ,CIG_ACCOUNT CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2            
CVT000       )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR03337_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
CVT000 0100A-EXIT.                                                      
CVT000         EXIT.                                                    
                                                                        
HPCCDM*    EJECT                                                                
038600******************************************************************        
038700* 1000-PROCESS-INPUT                                             *        
038800*                                                                *        
038900*     1. RECEIVE EACH PARAMETER FROM THE REMOTE PROCEDURE        *        
039000*                                                                *        
039100******************************************************************        
039200                                                                  
039300 1000-PROCESS-INPUT.                                              
039400                                                                  
CVT999*    MOVE 1                          TO PARM-ID1.                         
CVT999*    MOVE LENGTH OF PARM-CUST-NO     TO MAX-LENGTH-PARM.                  
039700                                                                  
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-CUST-NO,                                  
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
040500                                                                  
040600     MOVE PARM-CUST-NO-NUM TO AT-CUSTOMER-NO.                     
040700                                                                  
CVT999*    ADD  1                          TO PARM-ID1.                         
CVT999*    MOVE LENGTH OF PARM-USER-ID     TO MAX-LENGTH-PARM.                  
041000                                                                  
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-USER-ID,                                  
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
041800*                                                                         
CVT999*    ADD  1                           TO PARM-ID1.                        
CVT999*    MOVE LENGTH OF PARM-ADDRESS-TYPE TO MAX-LENGTH-PARM.                 
042100                                                                  
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-ADDRESS-TYPE,                             
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
041800*                                                                         
CVT999*    ADD  1                           TO PARM-ID1.                        
CVT999*    MOVE LENGTH OF PARM-ACCOUNT-NO   TO MAX-LENGTH-PARM.                 
T27237                                                                  
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-ACCOUNT-NO,                               
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
042900 1000-EXIT.                                                       
043000     EXIT.                                                        
HPCCDM*    EJECT                                                                
043200******************************************************************        
043300* 2000-MAIN-PROCESS                                              *        
043400*                                                                *        
043500*     MAIN PROCESSING LOOP DESCRIBES RESULTS AND CALLS THE       *        
043600*     PARAGRAPH TO SELECT NAMES AND ADDRESSES                             
043700*                                                                *        
043800******************************************************************        
043900 2000-MAIN-PROCESS.                                               
044000*                                                                         
044100     PERFORM 2100-DESCRIBE-RESULT         THRU 2100-EXIT.         
044200*                                                                         
T27237     MOVE PARM-ACCOUNT-NO-RED             TO PARM-ACCOUNT-NO-NUM. 
044200*                                                                         
044300     PERFORM 3000-PROCESS-NAME-ADDRESS    THRU 3000-EXIT.         
044400*                                                                         
044500 2000-EXIT.                                                       
044600     EXIT.                                                        
HPCCDM*    EJECT                                                                
REARCH******************************************************************        
REARCH*2000A-MOVE-RESULT.                                              *        
REARCH******************************************************************        
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE RS-RETURN-CODE         TO S-RETURN-CODE.                
REARCH     MOVE RS-CODE-ACCT-STAT      TO S-CODE-ACCT-STAT.             
REARCH     MOVE RS-ACCOUNT-NO          TO S-ACCOUNT-NO.                 
REARCH     MOVE RS-ADDR-LINE-1         TO S-ADDR-LINE-1.                
REARCH     MOVE RS-ADDR-LINE-2         TO S-ADDR-LINE-2.                
REARCH     MOVE RS-ADDR-LINE-3         TO S-ADDR-LINE-3.                
REARCH     MOVE RS-ADDR-LINE-4         TO S-ADDR-LINE-4.                
REARCH     MOVE RS-ADDR-LINE-5         TO S-ADDR-LINE-5.                
REARCH     MOVE RS-ADDR-LINE-6         TO S-ADDR-LINE-6.                
REARCH     MOVE RS-NAME                TO S-NAME.                       
REARCH     MOVE RS-SERV-ADDR           TO S-SERV-ADDR.                  
REARCH     MOVE RS-USER-NAME           TO S-USER-NAME.                  
REARCH     MOVE RS-CONTACT-POSITION    TO S-CONTACT-POSITION.           
REARCH     MOVE RS-CONTACT-TYPE        TO S-CONTACT-TYPE.               
REARCH     MOVE RS-FREE-FORM           TO S-FREE-FORM.                  
REARCH     MOVE RS-CIG-ACCOUNT         TO S-CIG-ACCOUNT.                
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH******************************************************************        
044800******************************************************************        
044900* 2100-DESCRIBE-RESULT                                           *        
045000*                                                                *        
045100*     DESCRIBE EACH COLUMN IN THE RESULT SET.                    *        
045200*     BUILD THE RESULT SET.                                      *        
045300*                                                                *        
045400******************************************************************        
045500 2100-DESCRIBE-RESULT.                                            
CVT999*    MOVE 1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSINT4 TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSINT4 TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-RETURN-CODE TO WRKLEN1.                            
CVT999*    MOVE LENGTH OF CN-RETURN-CODE TO WRKLEN2.                            
046100                                                                  
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RETURN-CODE,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-RETURN-CODE,                                
CVT999*                          WRKLEN2.                                       
047400                                                                  
CVT999*    PERFORM 9100-CHECK-ERROR                     THRU 9100-EXIT.         
047600                                                                  
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-CODE-ACCT-STAT TO WRKLEN1.                         
CVT999*    MOVE LENGTH OF CN-CODE-ACCT-STAT TO WRKLEN2.                         
048200                                                                  
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-CODE-ACCT-STAT,                             
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-CODE-ACCT-STAT,                             
CVT999*                          WRKLEN2.                                       
049500                                                                  
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-ACCOUNT-NO TO WRKLEN1.                             
CVT999*    MOVE LENGTH OF CN-ACCOUNT-NO TO WRKLEN2.                             
050100                                                                  
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-ACCOUNT-NO,                                 
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-ACCOUNT-NO,                                 
CVT999*                          WRKLEN2.                                       
051400                                                                  
CVT999*    PERFORM 9100-CHECK-ERROR                     THRU 9100-EXIT.         
051600                                                                  
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-ADDR-LINE-1 TO WRKLEN1.                            
CVT999*    MOVE LENGTH OF CN-ADDR-LINE-1 TO WRKLEN2.                            
052200                                                                  
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-ADDR-LINE-1,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-ADDR-LINE-1,                                
CVT999*                          WRKLEN2.                                       
053500                                                                  
CVT999*    PERFORM 9100-CHECK-ERROR                     THRU 9100-EXIT.         
053700                                                                  
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-ADDR-LINE-2 TO WRKLEN1.                            
CVT999*    MOVE LENGTH OF CN-ADDR-LINE-2 TO WRKLEN2.                            
054300                                                                  
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-ADDR-LINE-2,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-ADDR-LINE-2,                                
CVT999*                          WRKLEN2.                                       
055600                                                                  
CVT999*    PERFORM 9100-CHECK-ERROR                     THRU 9100-EXIT.         
055800                                                                  
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-ADDR-LINE-3 TO WRKLEN1.                            
CVT999*    MOVE LENGTH OF CN-ADDR-LINE-3 TO WRKLEN2.                            
056400                                                                  
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-ADDR-LINE-3,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-ADDR-LINE-3,                                
CVT999*                          WRKLEN2.                                       
057700                                                                  
CVT999*    PERFORM 9100-CHECK-ERROR                     THRU 9100-EXIT.         
057900                                                                  
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-ADDR-LINE-4 TO WRKLEN1.                            
CVT999*    MOVE LENGTH OF CN-ADDR-LINE-4 TO WRKLEN2.                            
058500                                                                  
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-ADDR-LINE-4,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-ADDR-LINE-4,                                
CVT999*                          WRKLEN2.                                       
059800                                                                  
CVT999*    PERFORM 9100-CHECK-ERROR                     THRU 9100-EXIT.         
060000                                                                  
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-ADDR-LINE-5 TO WRKLEN1.                            
CVT999*    MOVE LENGTH OF CN-ADDR-LINE-5 TO WRKLEN2.                            
060600                                                                  
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-ADDR-LINE-5,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-ADDR-LINE-5,                                
CVT999*                          WRKLEN2.                                       
061900                                                                  
CVT999*    PERFORM 9100-CHECK-ERROR                     THRU 9100-EXIT.         
062100                                                                  
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-ADDR-LINE-6 TO WRKLEN1.                            
CVT999*    MOVE LENGTH OF CN-ADDR-LINE-6 TO WRKLEN2.                            
062700                                                                  
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-ADDR-LINE-6,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-ADDR-LINE-6,                                
CVT999*                          WRKLEN2.                                       
064000                                                                  
CVT999*    PERFORM 9100-CHECK-ERROR                     THRU 9100-EXIT.         
064200                                                                  
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-NAME TO WRKLEN1.                                   
CVT999*    MOVE LENGTH OF CN-NAME TO WRKLEN2.                                   
064800                                                                  
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-NAME,                                       
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-NAME,                                       
CVT999*                          WRKLEN2.                                       
066100                                                                  
CVT999*    PERFORM 9100-CHECK-ERROR                     THRU 9100-EXIT.         
066300                                                                  
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-SERV-ADDR TO WRKLEN1.                              
CVT999*    MOVE LENGTH OF CN-SERV-ADDR TO WRKLEN2.                              
066900                                                                  
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-SERV-ADDR,                                  
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-SERV-ADDR,                                  
CVT999*                          WRKLEN2.                                       
068200                                                                  
CVT999*    PERFORM 9100-CHECK-ERROR                     THRU 9100-EXIT.         
068400                                                                  
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-USER-NAME TO WRKLEN1.                              
CVT999*    MOVE LENGTH OF CN-USER-NAME TO WRKLEN2.                              
069000                                                                  
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-USER-NAME,                                  
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-USER-NAME,                                  
CVT999*                          WRKLEN2.                                       
070300*                                                                         
CVT999*    PERFORM 9100-CHECK-ERROR                     THRU 9100-EXIT.         
070500*                                                                         
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-CONTACT-POSITION TO WRKLEN1.                       
CVT999*    MOVE LENGTH OF CN-CONTACT-POSITION TO WRKLEN2.                       
071100                                                                  
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-CONTACT-POSITION,                           
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-CONTACT-POSITION,                           
CVT999*                          WRKLEN2.                                       
072400                                                                  
CVT999*    PERFORM 9100-CHECK-ERROR                     THRU 9100-EXIT.         
072600                                                                  
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-CONTACT-TYPE TO WRKLEN1.                           
CVT999*    MOVE LENGTH OF CN-CONTACT-TYPE TO WRKLEN2.                           
073200                                                                  
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-CONTACT-TYPE,                               
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-CONTACT-TYPE,                               
CVT999*                          WRKLEN2.                                       
074500                                                                  
CVT999*    PERFORM 9100-CHECK-ERROR                     THRU 9100-EXIT.         
074700*                                                                         
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-FREE-FORM TO WRKLEN1.                              
CVT999*    MOVE LENGTH OF CN-FREE-FORM TO WRKLEN2.                              
074760                                                                  
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-FREE-FORM,                                  
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-FREE-FORM,                                  
CVT999*                          WRKLEN2.                                       
074800                                                                  
CVT999*    PERFORM 9100-CHECK-ERROR                     THRU 9100-EXIT.         
T27237*                                                                         
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-CIG-ACCOUNT TO WRKLEN1.                            
CVT999*    MOVE LENGTH OF CN-CIG-ACCOUNT TO WRKLEN2.                            
T27237                                                                  
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-CIG-ACCOUNT,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-CIG-ACCOUNT,                                
CVT999*                          WRKLEN2.                                       
T27237                                                                  
CVT999*    PERFORM 9100-CHECK-ERROR                     THRU 9100-EXIT.         
C29188*                                                                         
074810 2100-EXIT.                                                       
074900     EXIT.                                                        
HPCCDM*    EJECT                                                                
075100******************************************************************        
075200* 3000-MAIN-PROCESS                                              *        
075300*                                                                *        
075400*     MAIN PROCESSING LOOP TO SELECT THE NAME AND ADDRESS FOR A  *        
075500*     CUSTOMER BASED ON THE CUSTOMER AND ADDRESS TYPE.  THE FOUR *        
075600*     ADDRESS TYPES ARE BILLING, SERVICE, ACCOUNT CONTACT, AND   *        
075700*     CUSTOMER CONTACT.                                                   
075800******************************************************************        
075900 3000-PROCESS-NAME-ADDRESS.                                       
076000*                                                                         
076100     MOVE PARM-USER-ID               TO PF-USER-ID.               
076200*                                                                         
076300     PERFORM 7200-SELECT-USER                    THRU 7200-EXIT.  
T27237     PERFORM 7600-SELECT-CIG-ACCOUNT             THRU 7600-EXIT.  
A37666     PERFORM 7700-CHK-ACCT-NO-PARA               THRU 7700-EXIT.  
076400*                                                                         
076500     EVALUATE PARM-ADDRESS-TYPE                                   
076600        WHEN WS-BILLING-ADDRESS                                   
A37666           IF WS-CHK-NOR-ACCT = 'Y' THEN                          
076700           PERFORM 7000-OPEN-ACCNT-SELECT-CSR   THRU 7000-EXIT    
076800           PERFORM 7010-FETCH-ACCNT-SELECT-CSR  THRU 7010-EXIT    
076900           PERFORM 3100-PROCESS-BILLING-ADDRESS THRU 3100-EXIT    
077000             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
077100           PERFORM 7020-CLOSE-ACCNT-SELECT-CSR  THRU 7020-EXIT    
A37666           END-IF                                                 
A37666           IF WS-CHK-HST-ACCT = 'Y'                               
A37666           PERFORM 7030-OPEN-HST-SELECT-CSR   THRU 7030-EXIT      
A37666           PERFORM 7040-FETCH-HST-SELECT-CSR  THRU 7040-EXIT      
A37666           PERFORM 3100-PROCESS-BILLING-ADDRESS THRU 3100-EXIT    
A37666             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
A37666           PERFORM 7050-CLOSE-HST-SELECT-CSR  THRU 7050-EXIT      
A37666           END-IF                                                 
077200        WHEN WS-SERVICE-ADDRESS                                   
A37666           IF WS-CHK-NOR-ACCT = 'Y'                               
077300           PERFORM 7000-OPEN-ACCNT-SELECT-CSR   THRU 7000-EXIT    
077400           PERFORM 7010-FETCH-ACCNT-SELECT-CSR  THRU 7010-EXIT    
077500           PERFORM 3200-PROCESS-SERVICE-ADDRESS THRU 3200-EXIT    
077600             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
077700           PERFORM 7020-CLOSE-ACCNT-SELECT-CSR  THRU 7020-EXIT    
A37666           END-IF                                                 
A37666           IF WS-CHK-HST-ACCT = 'Y'                               
A37666           PERFORM 7030-OPEN-HST-SELECT-CSR   THRU 7030-EXIT      
A37666           PERFORM 7040-FETCH-HST-SELECT-CSR  THRU 7040-EXIT      
A37666           PERFORM 3200-PROCESS-SERVICE-ADDRESS THRU 3200-EXIT    
A37666             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
A37666           PERFORM 7050-CLOSE-HST-SELECT-CSR  THRU 7050-EXIT      
A37666           END-IF                                                 
077800        WHEN WS-CUSTOMER-CONTACT                                  
077900           MOVE AT-CUSTOMER-NO       TO DT-CUSTOMER-NO            
078000           MOVE SPACES               TO AT-CODE-ACCT-STAT         
078100           PERFORM 7100-OPEN-CUST-CONTACT-CSR   THRU 7100-EXIT    
078200           PERFORM 7110-FETCH-CUST-CONTACT-CSR  THRU 7110-EXIT    
078300           PERFORM 3500-SELECT-CUST-CONTACT     THRU 3500-EXIT    
078400             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
078500           PERFORM 7120-CLOSE-CUST-CONTACT-CSR  THRU 7120-EXIT    
078600        WHEN WS-ACCOUNT-CONTACT                                   
A37666           IF WS-CHK-NOR-ACCT = 'Y'                               
078700           PERFORM 7000-OPEN-ACCNT-SELECT-CSR   THRU 7000-EXIT    
078800           PERFORM 7010-FETCH-ACCNT-SELECT-CSR  THRU 7010-EXIT    
078900           PERFORM 3300-PROCESS-ACCOUNT-CONTACT THRU 3300-EXIT    
079000             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
079100           PERFORM 7020-CLOSE-ACCNT-SELECT-CSR  THRU 7020-EXIT    
A37666           END-IF                                                 
A37666           IF WS-CHK-HST-ACCT = 'Y'                               
A37666           PERFORM 7030-OPEN-HST-SELECT-CSR   THRU 7030-EXIT      
A37666           PERFORM 7040-FETCH-HST-SELECT-CSR  THRU 7040-EXIT      
A37666           PERFORM 3300-PROCESS-ACCOUNT-CONTACT THRU 3300-EXIT    
A37666             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
A37666           PERFORM 7050-CLOSE-HST-SELECT-CSR  THRU 7050-EXIT      
A37666           END-IF                                                 
079200     END-EVALUATE.                                                
079300*                                                                         
079400 3000-EXIT.                                                       
079500     EXIT.                                                        
HPCCDM*    EJECT                                                                
079700******************************************************************        
079800* 3100-PROCESS-BILLING-ADDRESS                                   *        
079900*                                                                *        
080000*     SELECT THE BILLING ADDRESS FOR AN ACCOUNT, CALL A PARAGRAPH*        
080100*     TO LOAD THE NAME/ADDRESS INFORMATION AND FETCH THE NEXT    *        
080200*     ACCOUNT.                                                   *        
080300******************************************************************        
080400 3100-PROCESS-BILLING-ADDRESS.                                    
080500     PERFORM 4000-MAIL-NAME-ADDRESS              THRU 4000-EXIT.  
080600*                                                                         
080700     MOVE SPACES                TO CV-CONTACT-TYPE.               
080800     MOVE SPACES                TO CV-CONTACT-POSITION-TEXT.      
080900*                                                                         
081000     PERFORM 3900-LOAD-NAME-AND-ADDRESS          THRU 3900-EXIT.  
A37666     IF WS-CHK-NOR-ACCT = 'Y'                                     
A37666        PERFORM 7010-FETCH-ACCNT-SELECT-CSR     THRU 7010-EXIT    
A37666     END-IF.                                                      
A37666     IF WS-CHK-HST-ACCT = 'Y'                                     
A37666        PERFORM 7040-FETCH-HST-SELECT-CSR      THRU 7040-EXIT     
A37666     END-IF.                                                      
081400 3100-EXIT.                                                       
081500     EXIT.                                                        
HPCCDM*    EJECT                                                                
081700*                                                                         
081800******************************************************************        
081900* 3200-PROCESS-SERVICE-ADDRESS                                   *        
082000*                                                                *        
082100*     CALL 4000-MAIL-NAME-ADDRESS TO SELECT THE ADDRESS NAME AND *        
082200*     SALUTATION NAME FOR AN ACCOUNT.  CALL 7500- TO SELECT THE  *        
082300*     PREMISE ADDRESS-ID FOR AN ACCOUNT. CALL PARAGRAPHS IN      *        
082400*     CPD000074 TO FORMAT THE ADDRESS CORRECTLY. 3500 LOADS AND  *        
082500*     RETURNS THE ADDRESS TO PANEL083.  FETCH THE NEXT ACCOUNT   *        
082600******************************************************************        
082700 3200-PROCESS-SERVICE-ADDRESS.                                    
082800     PERFORM 4000-MAIL-NAME-ADDRESS            THRU 4000-EXIT.    
082900*                                                                         
083000     PERFORM 7500-SELECT-PREMISE-ADDR          THRU 7500-EXIT.    
083100*                                                                         
083200     PERFORM 4050-GET-FORMATTED-ADDRESS        THRU 4050-EXIT.    
083300*                                                                         
083400     PERFORM 4030-LOAD-NAME-ADDR               THRU 4030-EXIT.    
083500*                                                                         
083600     MOVE SPACES                TO CV-CONTACT-TYPE.               
083700     MOVE SPACES                TO CV-CONTACT-POSITION-TEXT.      
083800*                                                                         
083900     PERFORM 3900-LOAD-NAME-AND-ADDRESS          THRU 3900-EXIT.  
084000*                                                                         
A37666     IF WS-CHK-NOR-ACCT = 'Y'                                     
A37666        PERFORM 7010-FETCH-ACCNT-SELECT-CSR     THRU 7010-EXIT    
A37666     END-IF.                                                      
A37666     IF WS-CHK-HST-ACCT = 'Y'                                     
A37666        PERFORM 7040-FETCH-HST-SELECT-CSR      THRU 7040-EXIT     
A37666     END-IF.                                                      
084200 3200-EXIT.                                                       
084300     EXIT.                                                        
HPCCDM*    EJECT                                                                
084500*                                                                         
084600******************************************************************        
084700* 3300-PROCESS-ACCOUNT-CONTACT                                   *        
084800*                                                                *        
084900*     PROCESS ALL OF THE ACCOUNT CONTACTS FOR A CUSTOMER.        *        
085000******************************************************************        
085100 3300-PROCESS-ACCOUNT-CONTACT.                                    
085200     MOVE AT-ACCOUNT-NO               TO DW-ACCOUNT-NO.           
085300     PERFORM 7400-OPEN-ACCT-CONTACT-CSR          THRU 7400-EXIT.  
085400     PERFORM 7410-FETCH-ACCT-CONTACT-CSR         THRU 7410-EXIT.  
085500     PERFORM 3400-SELECT-ACCT-CONTACT            THRU 3400-EXIT   
085600             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.         
085700     PERFORM 7420-CLOSE-ACCT-CONTACT-CSR         THRU 7420-EXIT.  
A37666     IF WS-CHK-NOR-ACCT = 'Y'                                     
A37666        PERFORM 7010-FETCH-ACCNT-SELECT-CSR    THRU 7010-EXIT     
A37666     END-IF.                                                      
A37666     IF WS-CHK-HST-ACCT = 'Y'                                     
A37666        PERFORM 7040-FETCH-HST-SELECT-CSR      THRU 7040-EXIT     
A37666     END-IF.                                                      
085900 3300-EXIT.                                                       
086000     EXIT.                                                        
HPCCDM*    EJECT                                                                
086200*                                                                         
086300******************************************************************        
086400* 3400-SELECT-ACCT-CONTACT                                      *         
086500*                                                                *        
086600*     PROCESS ALL OF THE ACCOUNT CONTACTS FOR A CUSTOMER.        *        
086700******************************************************************        
086800 3400-SELECT-ACCT-CONTACT.                                        
086900     MOVE DW-CONTACT-ID                        TO CV-CONTACT-ID.  
087000*                                                                         
087100     PERFORM 3800-GET-CONTACT-INFO               THRU 3800-EXIT.  
087200*                                                                         
087300     PERFORM 7410-FETCH-ACCT-CONTACT-CSR         THRU 7410-EXIT.  
087400*                                                                         
087500 3400-EXIT.                                                       
087600     EXIT.                                                        
HPCCDM*    EJECT                                                                
087800*                                                                         
087900******************************************************************        
088000* 3500-SELECT-CUST-CONTACT                                      *         
088100*                                                                *        
088200*     PROCESS ALL OF THE ACCOUNT CONTACTS FOR A CUSTOMER.        *        
088300******************************************************************        
088400 3500-SELECT-CUST-CONTACT.                                        
088500     MOVE DT-CONTACT-ID                        TO CV-CONTACT-ID.  
088600*                                                                         
088700     PERFORM 3800-GET-CONTACT-INFO               THRU 3800-EXIT.  
088800*                                                                         
088900     PERFORM 7110-FETCH-CUST-CONTACT-CSR         THRU 7110-EXIT.  
089000*                                                                         
089100 3500-EXIT.                                                       
089200     EXIT.                                                        
HPCCDM*    EJECT                                                                
089400*                                                                         
089500******************************************************************        
089600* 3800-GET-CONTACT-INFO                                          *        
089700*                                                                *        
089800*     SELECT THE CONTACT INFORMATION BASED ON THE ACCOUNT CONTACT*        
089900*     ID OF THE CUSTOMER CONTACT ID.  PERFORM 4060 TO SELECT THE *        
090000*     ADDRESS NAME FOR A LETTER.  PERFORM OTHER PARAGRAPHS IN    *        
090100*     CPD00074 TO SELECT AND FORMAT THE MAILING NAMES AND ADDRESS*        
090200*     FOR A CONTACT.  3900- LOADS THE CONTACT INFO AND RETURNS IT*        
090300*     TO PANEL083. FETCH THE NEXT CUSTOMER CONTACT CURSOR.                
090400******************************************************************        
090500 3800-GET-CONTACT-INFO.                                           
090600     MOVE SPACES                TO CV-CONTACT-POSITION-TEXT.      
090700*                                                                         
090800     PERFORM 7300-SELECT-CONTACT-INFO            THRU 7300-EXIT.  
090900*                                                                         
091000     MOVE CV-ADDRESS-ID         TO DZ-ADDRESS-ID.                 
091100     MOVE CV-NAME-ID            TO DQ-NAME-ID.                    
091200*                                                                         
091300     PERFORM 4060-GET-NAME                       THRU 4060-EXIT.  
091400*                                                                         
091500     MOVE DQ-NAME-FORMAT        TO WS-NAME-FORMAT (2).            
091600     MOVE DQ-FIRST-NAME         TO WS-FIRST-NAME (2).             
091700     MOVE DQ-MIDDLE-NAME        TO WS-MIDDLE-NAME (2).            
091800     MOVE DQ-LAST-NAME          TO WS-LAST-NAME (2).              
091900     MOVE DQ-TITLE-PREFIX       TO WS-TITLE-PREFIX (2).           
092000*                                                                         
092100     PERFORM 4022-SALUTATION-NAME                THRU 4022-EXIT.  
092200*                                                                         
092300     PERFORM 4090-SELECT-ADDR-FREEFORM           THRU 4090-EXIT.  
092400*                                                                         
092500     PERFORM 4030-LOAD-NAME-ADDR                 THRU 4030-EXIT.  
092600*                                                                         
092700     PERFORM 3900-LOAD-NAME-AND-ADDRESS          THRU 3900-EXIT.  
092800*                                                                         
092900 3800-EXIT.                                                       
093000     EXIT.                                                        
HPCCDM*    EJECT                                                                
093200*                                                                         
093300******************************************************************        
093400* 3900-LOAD-NAME-AND-ADDRESS                                     *        
093500*                                                                *        
093600*     SELECT THE BILLING ADDRESS AND FORMAT IT TO BE RETURNED TO *        
093700*     PANEL083                                                   *        
093800******************************************************************        
093900 3900-LOAD-NAME-AND-ADDRESS.                                      
094000*                                                                         
094100*                                                                         
094200     INITIALIZE                    GTT-RETURN-FIELDS.             
094300     MOVE AT-CODE-ACCT-STAT        TO RS-CODE-ACCT-STAT.          
094400     IF PARM-ADDRESS-TYPE = WS-CUSTOMER-CONTACT THEN              
094500        MOVE SPACES                TO WS-ACCOUNT-NO-TXT           
094600     ELSE                                                         
094700        MOVE AT-ACCOUNT-NO         TO WS-ACCOUNT-NO-NUM           
094800     END-IF.                                                      
094900     MOVE WS-ACCOUNT-NO-TXT        TO RS-ACCOUNT-NO.              
095200     MOVE WS-NAME-ADDR-LINE (1)    TO RS-ADDR-LINE-1.             
T12100     IF PARM-ADDRESS-TYPE = WS-SERVICE-ADDRESS THEN               
T12100        MOVE WS-PR-STREET              TO RS-ADDR-LINE-2          
T12100        MOVE WS-PR-ADDR-CITY-STATE-ZIP TO RS-ADDR-LINE-3          
T12100     ELSE                                                         
T12100        MOVE WS-NAME-ADDR-LINE (2)     TO RS-ADDR-LINE-2          
T12100        MOVE WS-NAME-ADDR-LINE (3)     TO RS-ADDR-LINE-3          
T12100     END-IF.                                                      
095300     MOVE WS-NAME-ADDR-LINE (4)    TO RS-ADDR-LINE-4.             
095400     MOVE WS-NAME-ADDR-LINE (5)    TO RS-ADDR-LINE-5.             
095500     MOVE WS-NAME-ADDR-LINE (6)    TO RS-ADDR-LINE-6.             
C29188     IF WS-SALUTATION-NAME(1:3) = 'MR ' OR                        
C29188        WS-SALUTATION-NAME(1:4) = 'MRS ' OR                       
C29188        WS-SALUTATION-NAME(1:5) = 'MISS '                         
C29188            PERFORM VARYING WS-SUB1 FROM 1 BY 1 UNTIL             
C29188                        WS-SUB1 > +6                              
                      IF WS-NAME-ADDR-TYPE(WS-SUB1) = 'CN'              
                         MOVE WS-NAME-ADDR-LINE(WS-SUB1) TO RS-NAME     
                         MOVE +7 TO WS-SUB1                             
                      END-IF                                            
C29188            END-PERFORM                                           
C33097            IF RS-NAME <= SPACES                                  
C33097                MOVE WS-SALUTATION-NAME TO RS-NAME                
C33097            END-IF                                                
C29188     ELSE                                                         
095600         MOVE WS-SALUTATION-NAME       TO RS-NAME
           END-IF.                
095700     MOVE WS-PREMISE-ADDR          TO RS-SERV-ADDR.               
095800     MOVE CV-CONTACT-TYPE          TO RS-CONTACT-TYPE.            
095900     MOVE CV-CONTACT-POSITION-TEXT TO RS-CONTACT-POSITION.        
096000     MOVE WS-USER-NAME             TO RS-USER-NAME.               
T27237     MOVE WS-CIG-ACCOUNT           TO RS-CIG-ACCOUNT.             
096100*                                                                         
REARCH     PERFORM 2000A-MOVE-RESULT                   THRU 2000A-EXIT. 
096200     PERFORM 8100-SEND-RESULT                    THRU 8100-EXIT.  
096300*                                                                         
096400 3900-EXIT.                                                       
096500     EXIT.                                                        
096700*                                                                         
096700*                                                                         
096800******************************************************************        
096900* 4000-MAIL-NAME-ADDRESS                                         *        
097000******************************************************************        
097100     EXEC SQL                                                             
097200        INCLUDE CPD00074                                                  
097300     END-EXEC.                                                            
HPCCDM*    EJECT                                                                
097500******************************************************************        
097600* 6010-REDUCE-EMBEDDED-SPACES (NEEDED BY CPD00074)               *        
097700******************************************************************        
097800     EXEC SQL                                                             
097900        INCLUDE CPD00004                                                  
098000     END-EXEC.                                                            
HPCCDM*    EJECT                                                                
098200*                                                                         
098300******************************************************************        
098400* 7000-OPEN-ACCNT-SELECT-CSR                                     *        
098500*                                                                *        
098600*     OPEN ACCOUNT_SELECT_CSR                                    *        
098700*                                                                *        
098800******************************************************************        
098900 7000-OPEN-ACCNT-SELECT-CSR.                                      
099000*                                                                         
099100     EXEC SQL                                                     
099200        OPEN ACCOUNT-SELECT-CSR                                   
099300     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

099400*                                                                         
099500     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
099600     MOVE SQLCODE TO RS-RETURN-CODE.                              
099700                                                                  
099800     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
099900         NEXT SENTENCE                                            
100000     ELSE                                                         
100100         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
100200         MOVE '7000'                 TO ACTIVE-PARAGRAPH          
CBSI           MOVE 'OPEN'                 TO ABEND-FUNCTION            
100400         MOVE 'CSS_ACCOUNT'          TO TABLE-1                   
100500         MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-1           
100600         MOVE AT-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1         
100700         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
100800         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
100900     END-IF.                                                      
101000*                                                                         
101100 7000-EXIT.                                                       
101200     EXIT.                                                        
HPCCDM*    EJECT                                                                
101400******************************************************************        
101500* 7010-FETCH-ACCNT-SELECT-CSR                                    *        
101600*                                                                *        
101700*     FETCH ACCOUNT NUMBER, ADDRESS-ID AND ADDRESS FORMAT FROM   *        
101800*     ACCOUNT-SELECT-CSR                                         *        
101900******************************************************************        
102000 7010-FETCH-ACCNT-SELECT-CSR.                                     
102100*                                                                         
102200     EXEC SQL                                                     
102300        FETCH ACCOUNT-SELECT-CSR                                  
102400        INTO  :AT-ACCOUNT-NO,                                     
102500              :AT-ADDRESS-ID,                                     
102600              :AT-ADDRESS-FORMAT,                                 
102700              :AT-CODE-ACCT-STAT                                  
102800     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

102900*                                                                         
103000     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
103100     MOVE SQLCODE TO RS-RETURN-CODE.                              
103200                                                                  
103300     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
103400         NEXT SENTENCE                                            
103500     ELSE                                                         
103600         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
103700         MOVE '7010'                 TO ACTIVE-PARAGRAPH          
103800         MOVE 'FETCH'                TO ABEND-FUNCTION            
103900         MOVE 'CSS_ACCOUNT'          TO TABLE-1                   
CBSI           MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-1           
CBSI           MOVE AT-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1         
104200         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
104300         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
104400     END-IF.                                                      
104500*                                                                         
104600 7010-EXIT.                                                       
104700     EXIT.                                                        
HPCCDM*    EJECT                                                                
104900*                                                                         
105000******************************************************************        
105100* 7020-CLOSE-ACCNT-SELECT-CSR                                    *        
105200*                                                                *        
105300*     CLOSE ACCOUNT_SELECT_CSR                                   *        
105400*                                                                *        
105500******************************************************************        
105600 7020-CLOSE-ACCNT-SELECT-CSR.                                     
105700*                                                                         
105800     EXEC SQL                                                     
105900        CLOSE ACCOUNT-SELECT-CSR                                  
106000     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

106100*                                                                         
106200     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
106300     MOVE SQLCODE TO RS-RETURN-CODE.                              
106400                                                                  
106500     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
106600         NEXT SENTENCE                                            
106700     ELSE                                                         
106800         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
106900         MOVE '7020'                 TO ACTIVE-PARAGRAPH          
107000         MOVE 'CLOSE'                TO ABEND-FUNCTION            
107100         MOVE 'CSS_ACCOUNT'          TO TABLE-1                   
107200         MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-1           
107300         MOVE AT-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1         
107400         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
107500         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
107600     END-IF.                                                      
107700*                                                                         
107800 7020-EXIT.                                                       
107900     EXIT.                                                        
HPCCDM*    EJECT                                                                
A37666******************************************************************        
A37666* 7030-OPEN-HST-SELECT-CSR                                       *        
A37666*     OPEN HST-ACCT-SELECT-CSR                                   *        
A37666******************************************************************        
A37666 7030-OPEN-HST-SELECT-CSR.                                        
A37666*                                                                         
A37666     EXEC SQL                                                     
A37666        OPEN HST-ACCT-SELECT-CSR                                  
A37666     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A37666*                                                                         
A37666     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A37666     MOVE SQLCODE TO RS-RETURN-CODE.                              
A37666                                                                  
A37666     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A37666         NEXT SENTENCE                                            
A37666     ELSE                                                         
A37666         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
A37666         MOVE '7030'                 TO ACTIVE-PARAGRAPH          
A37666         MOVE 'OPEN'                 TO ABEND-FUNCTION            
A37666         MOVE 'HAT_ACCOUNT'          TO TABLE-1                   
A37666         MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-1           
A37666         MOVE AT-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1         
A37666         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
A37666         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
A37666     END-IF.                                                      
A37666*                                                                         
A37666 7030-EXIT.                                                       
A37666     EXIT.                                                        
HPCCDM*    EJECT                                                                
A37666******************************************************************        
A37666* 7040-FETCH-HST-SELECT-CSR                                     *         
A37666*                                                                *        
A37666*     FETCH ACCOUNT NUMBER, ADDRESS-ID AND ADDRESS FORMAT FROM   *        
A37666*     HST-ACCT-SELECT-CSR                                        *        
A37666******************************************************************        
A37666 7040-FETCH-HST-SELECT-CSR.                                       
A37666*                                                                         
A37666     EXEC SQL                                                     
A37666        FETCH HST-ACCT-SELECT-CSR                                 
A37666        INTO  :AT-ACCOUNT-NO,                                     
A37666              :AT-ADDRESS-ID,                                     
A37666              :AT-ADDRESS-FORMAT,                                 
A37666              :AT-CODE-ACCT-STAT                                  
A37666     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A37666*                                                                         
A37666     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A37666     MOVE SQLCODE TO RS-RETURN-CODE.                              
A37666                                                                  
A37666     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A37666         NEXT SENTENCE                                            
A37666     ELSE                                                         
A37666         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
A37666         MOVE '7040'                 TO ACTIVE-PARAGRAPH          
A37666         MOVE 'FETCH'                TO ABEND-FUNCTION            
A37666         MOVE 'HST_ACCOUNT'          TO TABLE-1                   
A37666         MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-1           
A37666         MOVE AT-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1         
A37666         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
A37666         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
A37666     END-IF.                                                      
A37666*                                                                         
A37666 7040-EXIT.                                                       
A37666     EXIT.                                                        
HPCCDM*    EJECT                                                                
A37666*                                                                         
A37666******************************************************************        
A37666* 7050-CLOSE-HST-SELECT-CSR                                      *        
A37666*                                                                *        
A37666*     CLOSE ACCOUNT_SELECT_CSR                                   *        
A37666*                                                                *        
A37666******************************************************************        
A37666 7050-CLOSE-HST-SELECT-CSR.                                       
A37666*                                                                         
A37666     EXEC SQL                                                     
A37666        CLOSE HST-ACCT-SELECT-CSR                                 
A37666     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A37666*                                                                         
A37666     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A37666     MOVE SQLCODE TO RS-RETURN-CODE.                              
A37666                                                                  
A37666     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A37666         NEXT SENTENCE                                            
A37666     ELSE                                                         
A37666         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
A37666         MOVE '7050'                 TO ACTIVE-PARAGRAPH          
A37666         MOVE 'CLOSE'                TO ABEND-FUNCTION            
A37666         MOVE 'HST_ACCOUNT'          TO TABLE-1                   
A37666         MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-1           
A37666         MOVE AT-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1         
A37666         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
A37666         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
A37666     END-IF.                                                      
A37666*                                                                         
A37666 7050-EXIT.                                                       
A37666     EXIT.                                                        
HPCCDM*    EJECT                                                                
108100******************************************************************        
108200* 7100-OPEN-CUST-CONTACT-CSR                                     *        
108300*                                                                *        
108400*     OPEN CUST_CONTACT_CSR                                      *        
108500*                                                                *        
108600******************************************************************        
108700 7100-OPEN-CUST-CONTACT-CSR.                                      
108800*                                                                         
108900     EXEC SQL                                                     
109000        OPEN CUST-CONTACT-CSR                                     
109100     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

109200*                                                                         
109300     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
109400     MOVE SQLCODE TO RS-RETURN-CODE.                              
109500                                                                  
109600     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
109700         NEXT SENTENCE                                            
109800     ELSE                                                         
109900         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
110000         MOVE '7100'                 TO ACTIVE-PARAGRAPH          
CBSI           MOVE 'OPEN'                 TO ABEND-FUNCTION            
110200         MOVE 'CSS_CONTACT_CUST'     TO TABLE-1                   
110300         MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-1           
110400         MOVE DT-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1         
110500         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
110600         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
110700     END-IF.                                                      
110800*                                                                         
110900 7100-EXIT.                                                       
111000     EXIT.                                                        
HPCCDM*    EJECT                                                                
111200******************************************************************        
111300* 7110-FETCH-CUST-CONTACT-CSR                                    *        
111400*                                                                *        
111500*     FETCH CONTACT ID FROM CUSTOMER_CONTACT_CSR                 *        
111600*                                                                *        
111700******************************************************************        
111800 7110-FETCH-CUST-CONTACT-CSR.                                     
111900*                                                                         
112000     EXEC SQL                                                     
112100        FETCH CUST-CONTACT-CSR                                    
112200        INTO  :DT-CONTACT-ID                                      
112300     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

112400*                                                                         
112500     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
112600     MOVE SQLCODE TO RS-RETURN-CODE.                              
112700                                                                  
112800     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
112900         NEXT SENTENCE                                            
113000     ELSE                                                         
113100         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
113200         MOVE '7110'                 TO ACTIVE-PARAGRAPH          
113300         MOVE 'FETCH'                TO ABEND-FUNCTION            
113400         MOVE 'CSS_CONTACT_CUST'     TO TABLE-1                   
113500         MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-1           
113600         MOVE DT-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1         
113700         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
113800         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
113900     END-IF.                                                      
114000*                                                                         
114100 7110-EXIT.                                                       
114200     EXIT.                                                        
HPCCDM*    EJECT                                                                
114400*                                                                         
114500******************************************************************        
114600* 7120-CLOSE-CUST-CONTACT-CSR                                    *        
114700*                                                                *        
114800*     CLOSE CUST_CONTACT_CSR                                     *        
114900*                                                                *        
115000******************************************************************        
115100 7120-CLOSE-CUST-CONTACT-CSR.                                     
115200*                                                                         
115300     EXEC SQL                                                     
115400        CLOSE CUST-CONTACT-CSR                                    
115500     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

115600*                                                                         
115700     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
115800     MOVE SQLCODE TO RS-RETURN-CODE.                              
115900                                                                  
116000     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
116100         NEXT SENTENCE                                            
116200     ELSE                                                         
116300         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
116400         MOVE '7120'                 TO ACTIVE-PARAGRAPH          
116500         MOVE 'CLOSE'                TO ABEND-FUNCTION            
116600         MOVE 'CSS_CONTACT_CUST'     TO TABLE-1                   
116700         MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-1           
116800         MOVE DT-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1         
116900         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
117000         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
117100     END-IF.                                                      
117200*                                                                         
117300 7120-EXIT.                                                       
117400     EXIT.                                                        
HPCCDM*    EJECT                                                                
117600******************************************************************        
117700* 7200-SELECT-USER                                               *        
117800*                                                                *        
117900*     RETRIEVE NEEDED DATA FROM ACCOUNT BEFORE CALL TO CPD00074. *        
118000*                                                                *        
118100******************************************************************        
118200 7200-SELECT-USER.                                                
118300                                                                  
118400     EXEC SQL                                                     
118500         SELECT FIRST_NAME,                                       
118600                LAST_NAME,                                        
118700                MIDDLE_NAME                                       
118800           INTO :PF-FIRST-NAME,                                   
118900                :PF-LAST-NAME,                                    
119000                :PF-MIDDLE-NAME                                   
119100           FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                    
119200          WHERE USER_ID = :PF-USER-ID                             
A37666                                                           
A37666                                                      
119300     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT FIRST_NAME,                                               
MFA-TR*               LAST_NAME,                                                
MFA-TR*               MIDDLE_NAME                                               
MFA-TR*          INTO :PF-FIRST-NAME,                                           
MFA-TR*               :PF-LAST-NAME,                                            
MFA-TR*               :PF-MIDDLE-NAME                                           
MFA-TR*          FROM CSS_USER_PROFILE                                          
MFA-TR*         WHERE USER_ID = :PF-USER-ID                                     
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7200                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

119400                                                                  
119500     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
119600     MOVE SQLCODE TO RS-RETURN-CODE.                              
119700                                                                  
119800     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
119900         MOVE SPACES            TO WS-EMB-INPUT                   
120000         MOVE 50                     TO WS-EMB-LENG               
120100         STRING PF-FIRST-NAME DELIMITED SIZE                      
120200                ' ' DELIMITED SIZE                                
120300                PF-MIDDLE-NAME DELIMITED SIZE                     
120400                ' ' DELIMITED SIZE                                
120500                PF-LAST-NAME DELIMITED SIZE                       
120600         INTO WS-EMB-INPUT                                        
120700         PERFORM 6010-REDUCE-EMBEDDED-SPACES      THRU 6010-EXIT  
120800         MOVE WS-CMP-TABLE           TO WS-USER-NAME              
120900     ELSE                                                         
121000         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
121100         MOVE '7200'                 TO ACTIVE-PARAGRAPH          
121200         MOVE 'SELECT'               TO ABEND-FUNCTION            
121300         MOVE 'CSS_USER_PROFILE'     TO TABLE-1                   
121400         MOVE 'USER_ID'              TO TABLE-ELEMENT-1           
121500         MOVE PF-USER-ID             TO HOSTVAR-ELEMENT-1         
CBSI           MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-2           
CBSI           MOVE PARM-CUST-NO           TO HOSTVAR-ELEMENT-2         
121600         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
121700         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
121800     END-IF.                                                      
121900                                                                  
122000 7200-EXIT.                                                       
122100     EXIT.                                                        
HPCCDM*    EJECT                                                                
122300******************************************************************        
122400* 7300-SELECT-CONTACT-INFO                                       *        
122500*                                                                *        
122600*     FETCH CONTACT ID FROM CUSTOMER_CONTACT_CSR                 *        
122700*                                                                *        
122800******************************************************************        
122900 7300-SELECT-CONTACT-INFO.                                        
123000*                                                                         
123100     EXEC SQL                                                     
123200        SELECT ADDRESS_ID,                                        
123300               CONTACT_POSITION,                                  
123400               CONTACT_TYPE,                                      
123500               NAME_ID                                            
123600        INTO   :CV-ADDRESS-ID,                                    
123700               :CV-CONTACT-POSITION,                              
123800               :CV-CONTACT-TYPE,                                  
123900               :CV-NAME-ID                                        
124000        FROM   CSS_CONTACT WITH(READUNCOMMITTED)                          
124100        WHERE  CONTACT_ID = :CV-CONTACT-ID                        
A37666                                                           
A37666                                                      
124200     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ADDRESS_ID,                                                
MFA-TR*              CONTACT_POSITION,                                          
MFA-TR*              CONTACT_TYPE,                                              
MFA-TR*              NAME_ID                                                    
MFA-TR*       INTO   :CV-ADDRESS-ID,                                            
MFA-TR*              :CV-CONTACT-POSITION,                                      
MFA-TR*              :CV-CONTACT-TYPE,                                          
MFA-TR*              :CV-NAME-ID                                                
MFA-TR*       FROM   CSS_CONTACT                                                
MFA-TR*       WHERE  CONTACT_ID = :CV-CONTACT-ID                                
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7300                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

124300*                                                                         
124400     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
124500     MOVE SQLCODE TO RS-RETURN-CODE.                              
124600                                                                  
124700     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
124800         NEXT SENTENCE                                            
124900     ELSE                                                         
125000         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
125100         MOVE '7300'                 TO ACTIVE-PARAGRAPH          
125200         MOVE 'SELECT'               TO ABEND-FUNCTION            
125300         MOVE 'CSS_CONTACT'          TO TABLE-1                   
125400         MOVE 'CONTACT_ID'           TO TABLE-ELEMENT-1           
125500         MOVE CV-CONTACT-ID          TO HOSTVAR-ELEMENT-1         
CBSI           MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-2           
CBSI           MOVE PARM-CUST-NO           TO HOSTVAR-ELEMENT-2         
125600         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
125700         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
125800     END-IF.                                                      
125900*                                                                         
126000 7300-EXIT.                                                       
126100     EXIT.                                                        
HPCCDM*    EJECT                                                                
126300******************************************************************        
126400* 7400-OPEN-ACCT-CONTACT-CSR                                     *        
126500*                                                                *        
126600*     OPEN ACCT_CONTACT_CSR                                      *        
126700*                                                                *        
126800******************************************************************        
126900 7400-OPEN-ACCT-CONTACT-CSR.                                      
127000*                                                                         
127100     EXEC SQL                                                     
127200        OPEN ACCT-CONTACT-CSR                                     
127300     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

127400*                                                                         
127500     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
127600     MOVE SQLCODE TO RS-RETURN-CODE.                              
127700                                                                  
127800     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
127900         NEXT SENTENCE                                            
128000     ELSE                                                         
128100         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
128200         MOVE '7400'                 TO ACTIVE-PARAGRAPH          
128300         MOVE 'OPEN'                 TO ABEND-FUNCTION            
CBSI           MOVE 'CSS_CONTACT_ACCT'     TO TABLE-1                   
128500         MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
128600         MOVE DW-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
128700         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
128800         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
128900     END-IF.                                                      
129000*                                                                         
129100 7400-EXIT.                                                       
129200     EXIT.                                                        
HPCCDM*    EJECT                                                                
129400******************************************************************        
129500* 7410-FETCH-ACCT-CONTACT-CSR                                    *        
129600*                                                                *        
129700*     FETCH CONTACT ID FROM CUSTOMER_CONTACT_CSR                 *        
129800*                                                                *        
129900******************************************************************        
130000 7410-FETCH-ACCT-CONTACT-CSR.                                     
130100*                                                                         
130200     EXEC SQL                                                     
130300        FETCH ACCT-CONTACT-CSR                                    
130400        INTO  :DW-CONTACT-ID                                      
130500     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

130600*                                                                         
130700     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
130800     MOVE SQLCODE TO RS-RETURN-CODE.                              
130900                                                                  
131000     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
131100         NEXT SENTENCE                                            
131200     ELSE                                                         
131300         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
CBSI           MOVE '7410'                 TO ACTIVE-PARAGRAPH          
131500         MOVE 'FETCH'                TO ABEND-FUNCTION            
CBSI           MOVE 'CSS_CONTACT_ACCT'     TO TABLE-1                   
CBSI           MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
CBSI           MOVE DW-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
131900         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
132000         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
132100     END-IF.                                                      
132200*                                                                         
132300 7410-EXIT.                                                       
132400     EXIT.                                                        
HPCCDM*    EJECT                                                                
132600******************************************************************        
132700* 7420-CLOSE-ACCT-CONTACT-CSR                                    *        
132800*                                                                *        
132900*     OPEN ACCT_CONTACT_CSR                                      *        
133000*                                                                *        
133100******************************************************************        
133200 7420-CLOSE-ACCT-CONTACT-CSR.                                     
133300*                                                                         
133400     EXEC SQL                                                     
133500        CLOSE ACCT-CONTACT-CSR                                    
133600     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

133700*                                                                         
133800     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
133900     MOVE SQLCODE TO RS-RETURN-CODE.                              
134000                                                                  
134100     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
134200         NEXT SENTENCE                                            
134300     ELSE                                                         
134400         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
134500         MOVE '7420'                 TO ACTIVE-PARAGRAPH          
134600         MOVE 'CLOSE'                TO ABEND-FUNCTION            
134700         MOVE 'CSS_CONTACT_ACCT'     TO TABLE-1                   
134800         MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
134900         MOVE DW-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
135000         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
135100         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
135200     END-IF.                                                      
135300*                                                                         
135400 7420-EXIT.                                                       
135500     EXIT.                                                        
HPCCDM*    EJECT                                                                
135700******************************************************************        
135800* 7500-SELECT-PREMISE-ADDR                                       *        
135900*                                                                *        
136000*     FETCH CONTACT ID FROM CUSTOMER_CONTACT_CSR                 *        
136100*                                                                *        
136200******************************************************************        
136300 7500-SELECT-PREMISE-ADDR.                                        
136400*                                                                         
136500     EXEC SQL                                                     
136600        SELECT PR.ADDRESS_ID                                      
136700        INTO   :PR-ADDRESS-ID                                     
136800        FROM   CSS_ACCOUNT AT WITH(READUNCOMMITTED),                      
136900               CSS_PREMISE PR WITH(READUNCOMMITTED)                       
137000        WHERE  AT.PREMISE_NO = PR.PREMISE_NO                      
137100        AND    AT.ACCOUNT_NO = :AT-ACCOUNT-NO                     
A37666                                                           
A37666                                                      
137200     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT PR.ADDRESS_ID                                              
MFA-TR*       INTO   :PR-ADDRESS-ID                                             
MFA-TR*       FROM   CSS_ACCOUNT AT,                                            
MFA-TR*              CSS_PREMISE PR                                             
MFA-TR*       WHERE  AT.PREMISE_NO = PR.PREMISE_NO                              
MFA-TR*       AND    AT.ACCOUNT_NO = :AT-ACCOUNT-NO                             
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7500                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

137300*                                                                         
137400     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
137500     MOVE SQLCODE TO RS-RETURN-CODE.                              
137600                                                                  
137700     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
137800         NEXT SENTENCE                                            
137900     ELSE                                                         
138000         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
138100         MOVE '7500'                 TO ACTIVE-PARAGRAPH          
138200         MOVE 'SELECT'               TO ABEND-FUNCTION            
138300         MOVE 'CSS_PREMISE'          TO TABLE-1                   
CBSI           MOVE 'CSS_ACCOUNT'          TO TABLE-2                   
CBSI           MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
138500         MOVE AT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
138600         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
138700         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
138800     END-IF.                                                      
138900*                                                                         
139000 7500-EXIT.                                                       
139100     EXIT.                                                        
T27237******************************************************************        
T27237* 7600-SELECT-CIG-ACCOUNT                                        *        
T27237*                                                                *        
T27237*     CHECKS WHETHER THE GIVEN ACCOUNT IS A CIG ACCOUNT OR NOT   *        
T27237*                                                                *        
T27237******************************************************************        
T27237 7600-SELECT-CIG-ACCOUNT.                                         
T27237*                                                                         
T27237     EXEC SQL                                                     
T27237        SELECT 'Y'                                                
T27237        INTO   :RS-CIG-ACCOUNT                                    
T27237        FROM   CSS_ACCOUNT AT WITH(READUNCOMMITTED),                      
T27237               CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
T27237        WHERE  AT.ACCOUNT_NO     = :PARM-ACCOUNT-NO-NUM           
T27237        AND    AT.ACCOUNT_NO     =  UT.ACCOUNT_NO                 
T27237        AND    UT.CODE_UTIL_TYPE = 'G'                            
T27237        AND    UT.RATE_PLAN_NO IN (                               
T27237        SELECT RC.RATE_PLAN_NO                                    
T27237        FROM   CSS_RATE_COMP_DEF RC WITH(READUNCOMMITTED)                 
T27237        WHERE  RC.CODE_UTIL_TYPE = 'G'                            
T27237          AND  RC.REG_TYPE_CD = 'D')                              
A37666                                                           
A37666                                                      
T27237     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*       INTO   :RS-CIG-ACCOUNT                                            
MFA-TR*       FROM   CSS_ACCOUNT AT,                                            
MFA-TR*              CSS_UTIL_ENVRNMT UT                                        
MFA-TR*       WHERE  AT.ACCOUNT_NO     = :PARM-ACCOUNT-NO-NUM                   
MFA-TR*       AND    AT.ACCOUNT_NO     =  UT.ACCOUNT_NO                         
MFA-TR*       AND    UT.CODE_UTIL_TYPE = 'G'                                    
MFA-TR*       AND    UT.RATE_PLAN_NO IN (                                       
MFA-TR*       SELECT RC.RATE_PLAN_NO                                            
MFA-TR*       FROM   CSS_RATE_COMP_DEF RC                                       
MFA-TR*       WHERE  RC.CODE_UTIL_TYPE = 'G'                                    
MFA-TR*         AND  RC.REG_TYPE_CD = 'D')                                      
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7600                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T27237*                                                                         
T27237     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T27237     MOVE SQLCODE TO RS-RETURN-CODE.                              
T27237                                                                  
T27237     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
T27237                              OR MULTIPLE-ROWS                    
T27237         IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
T27237            MOVE 'N'            TO WS-CIG-ACCOUNT                 
T27237         ELSE                                                     
T27237            MOVE 'Y'            TO WS-CIG-ACCOUNT                 
T27237         END-IF                                                   
T27237     ELSE                                                         
T27237         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
T27237         MOVE '7600'                 TO ACTIVE-PARAGRAPH          
T27237         MOVE 'SELECT'               TO ABEND-FUNCTION            
T27237         MOVE 'CSS_ACCOUNT'          TO TABLE-1                   
T27237         MOVE 'CSS_UTIL_ENVRNMT'     TO TABLE-2                   
T27237         MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
T27237         MOVE PARM-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1         
T27237         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
T27237         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
T27237     END-IF.                                                      
T27237*                                                                         
T27237 7600-EXIT.                                                       
T27237     EXIT.                                                        
HPCCDM*    EJECT                                                                
A37666******************************************************************        
A37666* 7700-CHK-ACCT-NO-PARA                                          *        
A37666*     CHECKS WHETHER THE ACCOUNT NORMAL OR ARCHIVE ACCOUNT       *        
A37666******************************************************************        
A37666 7700-CHK-ACCT-NO-PARA.                                           
A37666*                                                                         
A37666     EXEC SQL                                                     
A37666        SELECT 'Y'                                                
A37666        INTO   :WS-CHK-NOR-ACCT                                   
A37666        FROM   CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
A37666        WHERE  AT.ACCOUNT_NO     = :PARM-ACCOUNT-NO-NUM           
A37666                                                           
A37666                                                      
A37666     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*       INTO   :WS-CHK-NOR-ACCT                                           
MFA-TR*       FROM   CSS_ACCOUNT AT                                             
MFA-TR*       WHERE  AT.ACCOUNT_NO     = :PARM-ACCOUNT-NO-NUM                   
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7700                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A37666*                                                                         
A37666     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A37666                                                                  
A37666     EVALUATE WS-ACTIVE-RETURN-CODE                               
A37666     WHEN SUCCESSFUL-CALL                                         
A37666          CONTINUE                                                
A37666     WHEN NOT-FOUND                                               
A37666          PERFORM 7800-CHK-HST-ACCT  THRU 7800-EXIT               
A37666     WHEN OTHER                                                   
A37666         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
A37666         MOVE '7700'                 TO ACTIVE-PARAGRAPH          
A37666         MOVE 'SELECT'               TO ABEND-FUNCTION            
A37666         MOVE 'CSS_ACCOUNT'          TO TABLE-1                   
A37666         MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
A37666         MOVE PARM-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1         
A37666         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
A37666         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
A37666     END-EVALUATE.                                                
A37666*                                                                         
A37666 7700-EXIT.                                                       
A37666     EXIT.                                                        
A37666                                                                  
A37666******************************************************************        
A37666* 7800-CHK-HST-ACCT                                              *        
A37666*     CHECKS WHETHER THE ACCOUNT NORMAL OR ARCHIVE ACCOUNT       *        
A37666******************************************************************        
A37666 7800-CHK-HST-ACCT.                                               
A37666*                                                                         
A37666     EXEC SQL                                                     
A37666        SELECT 'Y'                                                
A37666        INTO   :WS-CHK-HST-ACCT                                   
A37666        FROM   HST_ACCOUNT HA WITH(READUNCOMMITTED)                       
A37666        WHERE  HA.ACCOUNT_NO     = :PARM-ACCOUNT-NO-NUM           
A37666                                                           
A37666                                                      
A37666     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*       INTO   :WS-CHK-HST-ACCT                                           
MFA-TR*       FROM   HST_ACCOUNT HA                                             
MFA-TR*       WHERE  HA.ACCOUNT_NO     = :PARM-ACCOUNT-NO-NUM                   
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7800                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A37666*                                                                         
A37666     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A37666                                                                  
A37666     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A37666        CONTINUE                                                  
A37666     ELSE                                                         
A37666         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
A37666         MOVE '7800'                 TO ACTIVE-PARAGRAPH          
A37666         MOVE 'SELECT'               TO ABEND-FUNCTION            
A37666         MOVE 'HST_ACCOUNT'          TO TABLE-1                   
A37666         MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
A37666         MOVE PARM-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1         
A37666         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
A37666         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
A37666     END-IF.                                                      
A37666*                                                                         
A37666 7800-EXIT.                                                       
A37666     EXIT.                                                        
A37666                                                                  
CVT000******************************************************************00000100
CVT000* 8000A-DELETE-GTT-ROWS.                                         *00000200
CVT000******************************************************************00000300
CVT000 8000A-DELETE-GTT-ROWS.                                           
CVT000*                                                                 00000500
CVT000     MOVE                                                         
CVT000     'DELETE ROWS'                                                
CVT000         TO S-SQL-STATEMENT-V.                                    
CVT000*                                                                 00000900
CVT000      EXEC SQL                                                    
CVT000          DELETE FROM #CSR02337_R1                         
CVT000      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    00001000
MFA-TR*         DELETE FROM SESSION.CSR02337_R1                         00001100
MFA-TR*     END-EXEC.                                                   00001200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000*                                                                 00001300
CVT000      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
CVT000*                                                                 00001500
CVT000      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
CVT000          NEXT SENTENCE                                           
CVT000      ELSE                                                        
CVT000         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
CVT000         MOVE '8000A'              TO ACTIVE-PARAGRAPH            
CVT000         MOVE 'DELETE'             TO ABEND-FUNCTION              
CVT000         MOVE SPACES               TO ABEND-SQL-PREDICATES        
CVT000                                      ABEND-TABLES                
REARCH         MOVE 'CSR02337_R1'        TO TABLE-1                     
CVT000         MOVE SPACES               TO TABLE-ELEMENT-1             
CVT000         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
CVT000         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
CVT000     END-IF.                                                      
CVT000*                                                                 00003100
CVT000 8000A-EXIT.                                                      
CVT000     EXIT.                                                        
CVT000******************************************************************00000100
CVT000* 8100-SEND-RESULT.                                              *00000200
140300******************************************************************        
CVT000 8100-SEND-RESULT.                                                
CVT000     EXEC SQL                                                     
CVT000       INSERT INTO #CSR02337_R1                            
CVT000       (                                                          
CVT000        RETURN_CODE                                               
CVT000       ,CODE_ACCT_STAT                                            
CVT000       ,ACCOUNT_NO                                                
CVT000       ,ADDR_LINE_1                                               
CVT000       ,ADDR_LINE_2                                               
CVT000       ,ADDR_LINE_3                                               
CVT000       ,ADDR_LINE_4                                               
CVT000       ,ADDR_LINE_5                                               
CVT000       ,ADDR_LINE_6                                               
CVT000       ,NAME                                                      
CVT000       ,SERV_ADDR                                                 
CVT000       ,USER_NAME                                                 
CVT000       ,CONTACT_POSITION                                          
CVT000       ,CONTACT_TYPE                                              
CVT000       ,FREE_FORM                                                 
CVT000       ,CIG_ACCOUNT                                               
CVT000       )                                                          
CVT000       VALUES                                                     
CVT000       (                                                          
REARCH        :S-RETURN-CODE                                            
REARCH       ,:S-CODE-ACCT-STAT                                         
REARCH       ,:S-ACCOUNT-NO                                             
REARCH       ,:S-ADDR-LINE-1                                            
REARCH       ,:S-ADDR-LINE-2                                            
REARCH       ,:S-ADDR-LINE-3                                            
REARCH       ,:S-ADDR-LINE-4                                            
REARCH       ,:S-ADDR-LINE-5                                            
REARCH       ,:S-ADDR-LINE-6                                            
REARCH       ,:S-NAME                                                   
REARCH       ,:S-SERV-ADDR                                              
REARCH       ,:S-USER-NAME                                              
REARCH       ,:S-CONTACT-POSITION                                       
REARCH       ,:S-CONTACT-TYPE                                           
REARCH       ,:S-FREE-FORM                                              
REARCH       ,:S-CIG-ACCOUNT                                            
CVT000       )                                                          
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR02337_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,CODE_ACCT_STAT                                                    
MFA-TR*      ,ACCOUNT_NO                                                        
MFA-TR*      ,ADDR_LINE_1                                                       
MFA-TR*      ,ADDR_LINE_2                                                       
MFA-TR*      ,ADDR_LINE_3                                                       
MFA-TR*      ,ADDR_LINE_4                                                       
MFA-TR*      ,ADDR_LINE_5                                                       
MFA-TR*      ,ADDR_LINE_6                                                       
MFA-TR*      ,NAME                                                              
MFA-TR*      ,SERV_ADDR                                                         
MFA-TR*      ,USER_NAME                                                         
MFA-TR*      ,CONTACT_POSITION                                                  
MFA-TR*      ,CONTACT_TYPE                                                      
MFA-TR*      ,FREE_FORM                                                         
MFA-TR*      ,CIG_ACCOUNT                                                       
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE                                                    
MFA-TR*      ,:S-CODE-ACCT-STAT                                                 
MFA-TR*      ,:S-ACCOUNT-NO                                                     
MFA-TR*      ,:S-ADDR-LINE-1                                                    
MFA-TR*      ,:S-ADDR-LINE-2                                                    
MFA-TR*      ,:S-ADDR-LINE-3                                                    
MFA-TR*      ,:S-ADDR-LINE-4                                                    
MFA-TR*      ,:S-ADDR-LINE-5                                                    
MFA-TR*      ,:S-ADDR-LINE-6                                                    
MFA-TR*      ,:S-NAME                                                           
MFA-TR*      ,:S-SERV-ADDR                                                      
MFA-TR*      ,:S-USER-NAME                                                      
MFA-TR*      ,:S-CONTACT-POSITION                                               
MFA-TR*      ,:S-CONTACT-TYPE                                                   
MFA-TR*      ,:S-FREE-FORM                                                      
MFA-TR*      ,:S-CIG-ACCOUNT                                                    
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
CVT000                                                                  
CVT000     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
CVT000        NEXT SENTENCE                                             
CVT000     ELSE                                                         
CVT000        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
REARCH        MOVE '8100'               TO ACTIVE-PARAGRAPH             
CVT000        MOVE 'INSERT'             TO ABEND-FUNCTION               
REARCH        MOVE 'CSR02337_R1'        TO TABLE-1                      
CVT000        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
CVT000     END-IF.                                                      
CVT000                                                                  
CVT000     ADD 1 TO CTR-ROWS.                                           
CVT000*    INITIALIZE GTT-RETURN-FIELDS.                                00001900
CVT000*                                                                 00002000
CVT000 8100-EXIT.                                                       
CVT000      EXIT.                                                       
CVT000*                                                                 00003400
140300******************************************************************        
TP5109* 9700-PROCESS-ABEND.                                            *        
140500******************************************************************        
TP5109 COPY CPD0023C.                                                           
139600******************************************************************        
139700* 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
139800******************************************************************        
139900     EXEC SQL                                                             
140000        INCLUDE CPDSP300                                                  
140100     END-EXEC.                                                            
HPCCDM*    EJECT                                                                
139300 9900-ABEND.                                                      
139400 99XX-EXIT.                                                       
139500     EXIT.                                                        
140300******************************************************************        
140400*       END PROGRAM COPYLIB                                      *        
140500******************************************************************        
CVT999*    COPY CPD00302.                                                       
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00320                                         00000200
CVT000     END-EXEC.                                                    00000300
