       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02336.                                         
COB303 DATE-WRITTEN.  APRIL 1996                                        
       DATE-COMPILED.                                                   
                                                                        
      *****************************************************************         
      *                                                               *         
      *                SOUTH CAROLINA ELECTRIC & GAS                  *         
      *                                                               *         
      *  THIS PROGRAM IS EXECUTED VIA JCL TO CANCEL DISCONNECTS AND   *         
      *  THUS CALLS TWO STORED PROCEDURES.                            *         
      *  TRANID:        S336                                          *         
      *  PROGRAM:       S336                                          *         
      *  CALLING SP:    PA_S336                                       *         
      *                                                               *         
      *****************************************************************         
      *                 PROGRAM SUMMARY                               *         
      *                                                               *         
      * THIS PROGRAM READS CSS_SO_DNP_CANCEL TO GET ACCOUNTS AND      *         
      * CANCEL THE DNP SERVICE ORDERS AND SEND A WORK QUEUE TO THE    *         
      * DISPATCHER IF REQUIRED.                                        *        
      ******************************************************************        
      *                     PROGRAM MODIFICATION LOG                  *         
      *                                                               *         
      *    DATE    INITIALS   COMMENTS                                *         
      *  --------  --------   -------------------------------------   *         
      *  04/10/96    ADA      PROCEDURE ORIGINALLY CODED.             *         
      *                                                               *         
TP5228*  08/30/96    MAD      ADDED LOGIC FOR ABEND STANDARDIZATION   *         
TP5228*                       AMONG BATCH AND ONLINE (CICS) MODULES.  *         
TP5228*                       TPR 5228.                               *         
PCR360*  10/21/96    JTH      UPDATE CREDIT PROFILE WITH 'R' DUE TO   *         
PCR360*                       ORDER REASON. UPDATE SERV_ORDER_PENDING.*         
PD    *                       INIT CLIENT BEFORE SENDING EACH ACCT    *         
*T3437*  10/23/96    AG       TPR 3437  ADD RECONNECT LOGIC           *         
T10748*  05/01/97    MKN      CANCELLATION OF DNPFB SHOULD NOT UPDATE *         
      *                       CREDIT PROFILE TABLE. WORK QUEUE SHOULD *         
      *                       NOT BE GENERATED IF DNP/DNPFB IS IN FUT *         
      *  05/07/97    CHANDRA  ADDED A NEW PARAMETER TO D0000125,      *         
      *                       "cancel_reason" FLAG, WHICH WILL BE     *         
      *                       ALWAYS "R"                              *         
      *  06/25/97    WMG      TPR 11826 - ADD RETURN PARM FROM D125   *         
      *                       (AMOUNT DISC BAL).                      *         
      *  08/13/97    MKN      TPR 12718 - THE PROGRAM NOW CALLS SP    *         
      *                       D0000043 TO DETERMINE WHETHER IT IS A   *         
      *                       DNP OF DNPFB                            *         
      *  10/17/97    mkn      tpr 13392 to correct the so-remarks-txt *         
      *                                                               *         
T13557*  11/11/97    mkn      changed the column no for amt-disc-bal  *         
      *                                                               *         
      *  01/27/98    SYBASE   CHANGES MADE FOR CTBBIND FOR CHAR AND   *         
      *                       VARCHAR FIELDS. FOR ASE PROBLEM -> SYB  *         
T14849*  02/17/98    PRA      CHANGED '336' TO 'SYSTEM' FOR USER_ID_  *         
      *                       ORIG - 'SYSTEM' IS IN CSS_USER_PROFILE  *         
T15570*  03/26/98    RK       CHANGED NOT TO WRITE WORK QUEUE FOR     *         
      *                       AN ACCOUNT THAT CAME FROM BILLING       *         
t16039*  04/21/98    cbsi     added code to open client programs for  * 00280000
      *                       the new release of sybase               *         
T16928*  06/24/98    VB       MOVE SPACES TO WS-WQ-USER-ID-ASGN-C     * 00280000
      *                       INSTEAD OF BATCH.                       *         
T16871*  08/25/98    AMG      ONLY CALL 5000A TO GET AND UPDATE       *         
T16871*                       RECONNECT ORDER WHEN THE DNP BEING      *         
T16871*                       CANCELLED IS A DNPFB.                   *         
PCR307*  09/01/98    AMG      ONLY PROCESS EACH ACCOUNT IN            *         
PCR307*                       CSS_SO_DNP_CANCEL WHEN CODE IS NOT 'U'  *         
T18596*  12/01/98    PRA      CHANGED WQ CATEGORIES 52 AND 111 TO     *         
      *                       31 (DISPATCH) TO CORRECT ROUTING        *         
T18559*  12/03/98    VB       RESET THE SWITCH SW-DNP-TYPE            * 00280000
CBSI  *  12/23/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE   *         
CBSI  *              MADRAS   ABEND PARAMETERS                        *         
T19293*  03/12/99    PR       FOR TPR 19293 DNP SHOULD NOT BE         *         
T19293*                       CANCELLED ON CERTAIN SO.                *         
T19449*  03/17/99    PR       FOR TPR 19449 DO NOT CANCEL DNPFB FOR   *         
T19449*                       BILLING (CHG WAS MADE PER PALASH.)      *         
T19592*  04/01/99    PR       FIX FOR TPR 19592                       *         
T23235*  07/12/01 sk88120sai  PSNC changes for CANCEL "NOT"  orders   *         
T25205*  09/28/01 sk88120sai  Changes to display the correct desc on  *         
      *                       Panel 383                               *         
      *    (A)  If the NOT or DNP is cancelled due to a batch payment,*         
      *         the audit display should read 'batch payment'.        *         
      *    (B)  If the DNP is cancelled due to system billing,        *         
      *         the audit display should read 'Disconnect Cancelled'  *         
      *    (C)  If the NOT is cancelled due to system billing,        *         
      *         the audit display should read 'Second Notice Cancelled*         
      *                                                               *         
BASKAR*  03/20/03  BASKAR     DO NOT DELETE ROW IF RETURN CODE IS ZERO* 00280000
BASKAR*                       FROM D0000125, DELETE IF 100 TO FIX PROD* 00280000
BASKAR*                       PROBLEM                                 * 00280000
C28467*  03/25/03  BASKAR     RESET WS-ORDER-TYPE-CD-BD               * 00280000
C28467*  04/29/03  dps        REVISE COMMIT LOGIC AND ADD CURSOR WITH *         
      *                       HOLD                                    *         
c28693*  07/14/03  dps        reset delete of rows from 03/20/03      *         
c28616*  10/28/03  dps        For BMX change reconnects to turn-down  *         
      *                       Pull only accounts with update flag 't' *         
C30698*  04/21/04  DPS        RESET PANEL NAME WS-SO-PANEL-NO-C FOR   *         
      *                        EVERY FETCH                            *         
T31477*  12/12/04  CB18344    CHANGES MADE TO HOLD SEB BILLING ('B')  *         
T31477*                       ENTRIES THE NUMBER OF DAYS SPECIFIED IN *         
T31477*                       THE CSS_DELINQUENCY TABLE.              *         
T31477*  01/14/05  CB18344    FOR SEB B ACCOUNTS, THE FIELD           *         
T31477*                       WS-NO-OF-SO-PROCESSED NEEDS TO BE ADDED *         
T31477*                       TO ONLY WHEN ACCTS ARE PROCESSED.  THIS *         
T31477*                       IS DIFFERENT FROM CSR.                  *         
T31477*  01/24/05  CB18344    CHANGED THE WAY THE RELEASE DATE WAS    *         
T31477*                       BEING CALCULATED FOR SEB B ACCOUNTS.    *         
C30174*  05/20/05  BASKAR V   DON'T CREATE WQS FOR SEB REGION         * 00280000
C30831*  06/30/05  Diane Perdue-Shupe have all reconnects changed     *         
      *    to turn-down customer                                                
C34176*  04/25/06  SS82048    CHANGES FOR CANCELING DNP ORDER AT THE  *         
      *                       TIME OF NEW 2ND NOTICE GENERATION       *         
REARCH*  01/18/07   PA        ADDED CODE TO REMOVE SYBASE SP CALLS    *         
REARCH*                       CONVERT SYBASE GATEWAY TO DB2  CALLS    *         
perfor*  04/05/07  vijay      performance changes.                    *         
C35179*  04/30/07  LG41184    SO REARCH FIX                           *         
C35179*  05/17/07  LG41184    COMMIT LOGIC ADDED                      *         
C35980*  12/13/07  LG41184    FIX SQLCODE IN DELETE PARA 8000-.       *         
C35980*  03/14/08  LG41184    FIX WORK QUEUE ISSUE.                   *         
A01016*  07/14/09  VP94820    DNP CANCEL PROCESS MOVED HERE FROM      *         
A01016*                       SCSCA113, PCSCA170 ETC...               *         
A01757*  10/09/09  BASKAR V   FIX DNPS NOT CANCELLING PROBLEM         *         
PRJ481*  03/03/11  AP40911    REPLACE CSR00644 WITH CSR04422          *         
P00471*  07/26/11  CB18344    ADDED 4 NEW NORMAL ORDER REASONS FOR    *         
P00471*                       DPP DROP PROJECT.                       *         
A04687*  06/06/13R BASKAR V   REMOVED UNUSED PARMS                    *         
A05136*  11/12/15  RS7M249    REMOVED THE CANCEL PENDING NOTICE ORDER *         
      *            ACT227                                             *         
ACT067* 02/22/16    MC95456   REPLACE CSS_WQ_ITEMS_MF WITH            *         
ACT067* APPL5460              CSS_WQ_ITEMS BY CALLING MCSCB077        *         
ACT067*                       REMOVE UNUSED COPYBOOKS.                *         
ACT381* 12/09/16    VIJAY     REMOVE UNUSED DCLGEN TBSOSYNC           *         
ACT381* A05460                                                        *         
P00948* 03/06/17    VENKAT.P  PROCESS BOTH P&T ROWS WHEN PARM IS P/T  *         
ACT057* 03/08/17    RS7V450   DELETE TABLES CSS_DNP_NOT_WORKED.       *         
      *****************************************************************         
      *                                                               *         
      *                ---- BASIC SEQUENCE STRUCTURE ----             *         
      *                                                               *         
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION            *         
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                   *         
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                  *         
      *  3000 - 4999  NOT USED                                        *         
      *  5000 - 5999  COMMON PROGRAM MODULES                          *         
      *  6000 - 6999  COMMON SYSTEM MODULES                           *         
      *  7000 - 7999  INPUT MODULES                                   *         
      *  8000 - 8999  OUTPUT MODULES                                  *         
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES            *         
      *                                                               *         
      *****************************************************************         
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02336'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                    PIC X(40)                        
REARCH     VALUE 'WORKING STORAGE FOR CSR02336 STARTS HERE'.            
      *****************************************************************         
      * DB2 INCLUDES                                                  *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ** DCLGEN FOR CSS_MODEL_SQL                                               
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
      ** DCLGEN FOR CSS_ACCOUNT                                                 
           EXEC SQL                                                             
                INCLUDE TBACCT                                                  
           END-EXEC.                                                            
                                                                        
T31477** DCLGEN FOR CSS_DELINQUENCY                                             
T31477     EXEC SQL                                                             
T31477          INCLUDE TBDELQ                                                  
T31477     END-EXEC.                                                            
T31477                                                                  
T31477** DCLGEN FOR CSS_HOLIDAY                                                 
T31477     EXEC SQL                                                             
T31477          INCLUDE TBHLDAY                                                 
T31477     END-EXEC.                                                            
                                                                        
      ** DCLGEN FOR CSS_SO_DNP_CANCEL                                           
           EXEC SQL                                                             
                INCLUDE TBSODNPC                                                
           END-EXEC.                                                            
                                                                        
PCR360** DCLGEN FOR CSS_CREDIT_PROFILE                                          
PCR360     EXEC SQL                                                             
PCR360          INCLUDE TBCRPROF                                                
PCR360     END-EXEC.                                                            
                                                                        
PCR360** DCLGEN FOR CSS_PREMISE                                                 
PCR360     EXEC SQL                                                             
PCR360          INCLUDE TBPREM                                                  
PCR360     END-EXEC.                                                            
                                                                        
C35179** DCLGEN FOR CSS_JOB_PARM (G6)                                           
C35179     EXEC SQL                                                             
C35179          INCLUDE TBJBPARM                                                
C35179     END-EXEC.                                                            
C35179                                                                  
      *****************************************************************         
      * COBOL WORKING STORAGE COPY BOOKS                              *         
      *****************************************************************         
                                                                        
      * COMMON SYSTEM AREA                                                      
           COPY CCA00001.                                                       
      * ERROR HANDLING                                                          
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CWSX0010                                                  
REARCH     END-EXEC.                                                            
      * ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS                          
           COPY CWS00027.                                                       
      * SUPPORTS DB2 AND SQL ERROR CHECKING                                     
           COPY CWS00303.                                                       
      * CODES-DATA-PRESENT FROM CSS_ACCOUNT                                     
           COPY CWS00056.                                                       
                                                                        
ACT067*                                                                         
ACT067/***** FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR MCSCB077              
ACT067     EXEC SQL                                                             
ACT067          INCLUDE CWS00077                                                
ACT067     END-EXEC.                                                            
ACT067                                                                  
      *****************************************************************         
      * WORK AREAS                                                    *         
      *****************************************************************         
                                                                        
REARCH 01  PROGRAM-NAME                 PIC X(08) VALUE 'CSR02336'.     
                                                                        
ACT067 01  MCSCB077                     PIC X(08) VALUE 'MCSCB077'.     
ACT067 01  WS-MCSCB077-OUTPUT.                                          
ACT067     05  WS-MCSCB077-RET-CODE     PIC S9(09) COMP VALUE 0.        
                                                                        
       01  CS-LIB-MISC-FIELDS.                                          
           05  WS-ITEM-NUM             PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-COPIED               PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-COPIED-NULL          PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-INDICATOR            PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-INDICATOR-NULL       PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-RPC-RC               PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-RPC-SUCCESS          PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-RETURN-CODE          PIC S9(9) COMP SYNC VALUE +0.    
                                                                        
       01  CS-PROPERTY-FIELDS.                                          
c28616*  RCNCT-FIND-RPC ACTUALLY CHANGES RECONNECT TO ACTIVE                    
           05  PARM-UPDATE-PARM        PIC X(01) VALUE SPACE.           
                                                                        
      *************************************************************             
      *==>WORKING STORAGE CHG FOR CTBBIND ISSUE SYB 01/27/98   <==*             
      *************************************************************             
       01  WS-BIND-AREA.                                                
           05  WS-SO-RETURN-CD-BD          PIC S9(04) COMP.             
 T3437     05  WS-RCNCT-RETURN-CD-BD       PIC S9(04) COMP.             
 T3437     05  WS-DNPFB-RETURN-CD-BD       PIC S9(04) COMP.             
           05  WS-WQ-RETURN-BD             PIC S9(04) COMP.             
COB305     05 WS-WQ-ITEM-ID-BD        PIC S9(11) COMP-3 VALUE 0.           
      *                                                                         
T19293 01 WS-SERVICE-ORDER-NO              PIC 9(13).                   
      *                                                                         
       01  WS-SERV-ORDER-CHAR-BD-01.                                    
           05  FILLER                      PIC S9(4) COMP.              
           05  WS-SERV-ORDER-CHAR-BD       PIC X(13).                   
           05  WS-SERV-ORDER-NUM-I REDEFINES WS-SERV-ORDER-CHAR-BD      
                                           PIC 9(13).                   
      *                                                                         
       01  WS-RESP-AREA-ID-BD-01.                                       
           05  FILLER                      PIC S9(4) COMP.              
           05  WS-RESP-AREA-ID-BD          PIC X(03).                   
      *                                                                         
       01  WS-ORDER-REASON-BD-01.                                       
           05  FILLER                      PIC S9(4) COMP.              
           05  WS-ORDER-REASON-BD          PIC X(01).                   
      *                                                                         
       01  WS-PENDING-DNP-FLAG-BD-01.                                   
           05  FILLER                      PIC S9(4) COMP.              
           05  WS-PENDING-DNP-FLAG-BD      PIC X(01).                   
      *                                                                         
       01  WS-INSERT-WORK-QUEUE-BD-01.                                  
           05  FILLER                      PIC S9(4) COMP.              
           05  WS-INSERT-WORK-QUEUE-BD     PIC X(01).                   
      *                                                                         
       01  WS-AMOUNT-DISC-BAL-01.                                       
           05  FILLER                      PIC S9(4) COMP.              
           05  WS-AMOUNT-DISC-BAL          PIC X(12).                   
      *                                                                         
       01  WS-ORDER-TYPE-CD-BD-01.                                      
           05  FILLER                      PIC S9(4) COMP.              
T12718     05  WS-ORDER-TYPE-CD-BD         PIC X(05).                   
      *                                                                         
       01  WS-SERV-ORDER-STATUS-BD-01.                                  
           05  FILLER                      PIC S9(4) COMP.              
T12718     05  WS-SERV-ORDER-STATUS-BD     PIC X(02).                   
      *                                                                         
       01  WS-ORDER-REASON-BD-TEMP-01.                                  
           05  FILLER                      PIC S9(4) COMP.              
T12718     05  WS-ORDER-REASON-BD-TEMP     PIC X(15).                   
      *                                                                         
       01  WS-SERV-ORDER-NO-BD-TEMP-01.                                 
           05  FILLER                      PIC S9(4) COMP.              
COB305     05 WS-SERV-ORDER-NO-BD-TEMP        PIC 9(13)V USAGE COMP-3 
COB305       VALUE 0.     
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  TDS-RETURN-FIELDS.                                           
PRJ481     05  S-RETURN-CODE            PIC S9(9) COMP VALUE 0.         
PRJ481     05  S-MSGNO                  PIC S9(9) COMP VALUE 0.         
PRJ481     05  S-MSGTEXT                PIC X(255) VALUE  SPACES.       
                                                                        
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  WS-RETURN-CODE          PIC S9(9) COMP VALUE +0.         
       01  CN-COLUMN-NAMES.                                             
           05  CN-RETURN-CODE           PIC X(11) VALUE                 
                                               'RETURN_CODE'.           
           05  CN-ACTIVE-PARAGRAPH      PIC X(16) VALUE                 
                                               'ACTIVE_PARAGRAPH'.      
           05  CN-CLIENT-MSGNO          PIC X(12) VALUE                 
                                               'CLIENT_MSGNO'.          
           05  CN-CLIENT-MSGTEXT        PIC X(14) VALUE                 
                                               'CLIENT_MSGTEXT'.        
                                                                        
       01  WS-NO-OF-SO-PROCESSED        PIC S9(9) COMP VALUE 0.         
       01  WS-NO-OF-SO-PROCESSED-DISP   PIC ZZZ9.                       
                                                                        
       COPY CWS00004.                                                           
       COPY CWS00026.                                                           
       COPY CWS00059.                                                           
       COPY CCA00001.                                                           
                                                                        
       01  WS-SO-WORK-AREA.                                             
           05  WS-SO-ACCOUNT-NO-C          PIC X(13).                   
           05  WS-SO-ACCOUNT-NO-I REDEFINES WS-SO-ACCOUNT-NO-C          
                                           PIC 9(13).                   
COB305     05 WS-SO-ACCOUNT-NO-D        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.    
           05  WS-SO-PREMISE-NO-C          PIC X(10).                   
           05  WS-SO-PREMISE-NO-I REDEFINES WS-SO-PREMISE-NO-C          
                                           PIC 9(10).                   
COB305     05 WS-SO-PREMISE-NO-D        PIC S9(10)V USAGE COMP-3 
COB305       VALUE 0.    
T23235     05  WS-SO-USER-ID-C             PIC X(06) VALUE 'SYSTEM'.    
           05  WS-SO-REMARK-TX-C.                                       
               49  WS-SO-REMARK-TX-LEN    PIC S9(4) COMP SYNC VALUE +0. 
               49  WS-SO-REMARK-TX-TEXT    PIC X(19) VALUE SPACES.      
           05  WS-SO-REMARK-MSG            PIC X(19) VALUE              
                                               'DISCONNECT CANCELED'.   
           05  WS-SO-PANEL-NO-C            PIC X(04) VALUE 'S336'.      
PCR360     05  WS-SO-ORDER-TYPE-FLAG-C     PIC X(01) VALUE SPACE.       
           05  WS-SO-UPDATE-REMARKS-C      PIC X(01) VALUE 'Y'.         
           05  WS-SO-SELECT-UPDATE-C       PIC X(01) VALUE 'U'.         
 T3437     05  WS-SO-ORDER-TYPE-CD-C       PIC X(05) VALUE 'FM006'.     
           05  WS-SO-DNP-CANCEL-REASON     PIC X(01).                   
           05  WS-TEMP-HIST                PIC X(01).                   
           05  WS-TEMP-HIST-NUM            PIC 9(01).                   
                                                                        
       01  WS-WQ-WORK-AREA.                                             
REARCH     05  WS-WQ-ITEM-ID               PIC S9(10)V COMP-3 VALUE +0. 
           05  WS-WQ-ROUTING-CATGRY-C      PIC X(01).                   
           05  WS-WQ-LOCAL-OFFICE-C        PIC X(03).                   
           05  WS-WQ-USER-ID-ORIG-C        PIC X(07).                   
           05  WS-WQ-USER-ID-ASGN-C        PIC X(07).                   
           05  WS-WQ-RESP-AREA-ID-C        PIC X(03).                   
           05  WS-WQ-CATEGORY-ID-C         PIC X(02).                   
REARCH     05  WS-WQ-CATEGORY-ID-D         PIC S9(04) USAGE COMP.       
           05  WS-WQ-ACCOUNT-NO-C          PIC X(13).                   
           05  WS-WQ-ACCOUNT-NO-I REDEFINES WS-WQ-ACCOUNT-NO-C          
                                           PIC 9(13).                   
COB305     05 WS-WQ-ACCOUNT-NO-D        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.    
           05  WS-WQ-PREMISE-NO-C          PIC X(10).                   
           05  WS-WQ-PREMISE-NO-I REDEFINES WS-WQ-PREMISE-NO-C          
                                           PIC 9(10).                   
COB305     05 WS-WQ-PREMISE-NO-D        PIC S9(10)V USAGE COMP-3 
COB305       VALUE 0.    
           05  WS-WQ-CUSTOMER-NO-C         PIC X(10).                   
           05  WS-WQ-CUSTOMER-NO-I REDEFINES WS-WQ-CUSTOMER-NO-C        
                                           PIC 9(10).                   
COB305     05 WS-WQ-CUSTOMER-NO-D        PIC S9(10)V USAGE COMP-3 
COB305       VALUE 0.    
           05  WS-WQ-SERV-ORDER-NO-C       PIC X(13).                   
           05  WS-WQ-SERV-ORDER-NO-I REDEFINES WS-WQ-SERV-ORDER-NO-C    
                                           PIC 9(13).                   
A01757     05  WS-WQ-SERV-ORDER-NO-D       PIC S9(13)V USAGE COMP-3     
A01757                                                       VALUE +0.  
           05  WS-WQ-COMMENTS-C.                                        
               49  WS-WQ-COMMENTS-LEN     PIC S9(4) COMP SYNC VALUE +0. 
C34176         49  WS-WQ-COMMENTS-TEXT     PIC X(80) VALUE SPACES.      
           05  WS-WQ-COMMENTS-MSG          PIC X(41) VALUE              
               'DNP CANCELLED, DO NOT WORK SERVICE ORDER '.             
T23235     05  WS-WQ-COMMENTS-MSG1         PIC X(41) VALUE              
T23235         'SECOND NOTICE CANCELLED,DO NOT WORK ORDER'.             
C34176     05  WS-WQ-N-COMMENTS-MSG.                                    
C34176         10 WS-WQ-N-COMMENTS-MSG1      PIC X(54) VALUE            
C34176         'NEW DISCONNECT NOTICE HAS GENERATED WITH NEW DNP DATE,'.
C34176         10 WS-WQ-N-COMMENTS-MSG2      PIC X(26) VALUE            
C34176         ' DO NOT WORK SERVICE ORDER'.                            
           05  WS-WQ-DNPFB-MSG               PIC X(41) VALUE            
               'PAYMT RECVD ON DNPFB; NO RECONNECT EXISTS'.             
T19293     05  WS-WQ-DNP-COMPLETE.                                      
T19293         10  WS-WQ-DNP-MSG1            PIC X(17) VALUE            
T19293         'PAYMENT RECEIVED.'.                                     
T19293         10  WS-WQ-DNP-MSG2            PIC X(22) VALUE            
T19293         'DNP STATE IS COMPLETE.'.                                
T19293         10  WS-WQ-DNP-MSG3            PIC X(44) VALUE            
T19293         'POST ORDER AND REVIEW FOR POSSIBLE RECONNECT'.          
C34176     05  WS-N-WQ-DNP-COMPLETE.                                    
C34176         10 WS-N-WQ-DNP-MSG1           PIC X(54) VALUE            
C34176         'NEW DISCONNECT NOTICE HAS GENERATED WITH NEW DNP DATE;'.
C34176         10 WS-N-WQ-DNP-MSG2           PIC X(55) VALUE            
C34176        ' CANCELLATION OF OLD DNP FAILED BECAUSE OF ORDER STATE/'.
C34176         10 WS-N-WQ-DNP-MSG3           PIC X(39) VALUE            
C34176         ' STATUS; MANUALLY CANCEL THE DNP ORDER.'.               
           05  WS-WQ-DATE-REQ.                                          
               10  WS-WQ-DATE-REQ-CN       PIC X(02).                   
               10  WS-WQ-DATE-REQ-YR       PIC X(02).                   
               10  WS-WQ-DATE-REQ-F1       PIC X(01) VALUE '/'.         
               10  WS-WQ-DATE-REQ-MN       PIC X(02).                   
               10  WS-WQ-DATE-REQ-F2       PIC X(01) VALUE '/'.         
               10  WS-WQ-DATE-REQ-DY       PIC X(02).                   
               10  WS-WQ-DATE-REQ-F3       PIC X(01) VALUE ' '.         
               10  WS-WQ-DATE-REQ-HR       PIC X(02).                   
               10  WS-WQ-DATE-REQ-F4       PIC X(01) VALUE ':'.         
               10  WS-WQ-DATE-REQ-MIN      PIC X(02).                   
               10  WS-WQ-DATE-REQ-F5       PIC X(01) VALUE ':'.         
               10  WS-WQ-DATE-REQ-SEC      PIC X(02).                   
           05  WS-WQ-DATE-REQUIRED         PIC X(19).                   
           05  WS-WQ-DATE-CREATED          PIC X(19).                   
           05  WS-WQ-PRIORITY-C            PIC X(01).                   
           05  WS-WQ-FREE-FORM-AREA-C.                                  
               49  WS-WQ-FREE-FORM-LEN    PIC S9(4) COMP SYNC VALUE +0. 
               49  WS-WQ-FREE-FORM-TEXT    PIC X(20) VALUE SPACES.      
REARCH     05 P-RETURN-PARM                PIC S9(09) COMP VALUE +0.    
                                                                        
REARCH 01 WS-MISC.                                                      
REARCH    05 IND-01      PIC S9(04) COMP VALUE 0.                       
REARCH    05 IND-02      PIC S9(04) COMP VALUE 0.                       
REARCH    05 IND-03      PIC S9(04) COMP VALUE 0.                       
REARCH    05 IND-04      PIC S9(04) COMP VALUE 0.                       
REARCH    05 IND-05      PIC S9(04) COMP VALUE 0.                       
REARCH    05 IND-06      PIC S9(04) COMP VALUE 0.                       
REARCH    05 IND-07      PIC S9(04) COMP VALUE 0.                       
REARCH    05 IND-08      PIC S9(04) COMP VALUE 0.                       
REARCH    05 IND-09      PIC S9(04) COMP VALUE 0.                       
REARCH    05 IND-10      PIC S9(04) COMP VALUE 0.                       
REARCH    05 IND-11      PIC S9(04) COMP VALUE 0.                       
REARCH    05 IND-12      PIC S9(04) COMP VALUE 0.                       
REARCH    05 IND-13      PIC S9(04) COMP VALUE 0.                       
REARCH    05 IND-14      PIC S9(04) COMP VALUE 0.                       
REARCH    05 IND-15      PIC S9(04) COMP VALUE 0.                       
REARCH    05 IND-16      PIC S9(04) COMP VALUE 0.                       
REARCH    05 IND-17      PIC S9(04) COMP VALUE 0.                       
A01016    05 IND-18      PIC S9(04) COMP VALUE 0.                       
A01016    05 IND-19      PIC S9(04) COMP VALUE 0.                       
                                                                        
REARCH*01  LOC1            USAGE IS SQL TYPE IS                         
REARCH*                    RESULT-SET-LOCATOR VARYING.                  
REARCH*01  LOC2            USAGE IS SQL TYPE IS                         
REARCH*                    RESULT-SET-LOCATOR VARYING.                  
REARCH*01  LOC3            USAGE IS SQL TYPE IS                         
REARCH*                    RESULT-SET-LOCATOR VARYING.                  
REARCH*01  LOC4            USAGE IS SQL TYPE IS                         
REARCH*                    RESULT-SET-LOCATOR VARYING.                  
REARCH*01  LOC5            USAGE IS SQL TYPE IS                         
REARCH*                    RESULT-SET-LOCATOR VARYING.                  
                                                                        
       01  WS-WORK-AREA.                                                
REARCH     05  WS-SERV-ORDER-NO-C         PIC X(13).                    
REARCH     05  WS-SERV-ORDER-NO-I REDEFINES WS-SERV-ORDER-NO-C          
REARCH                                    PIC 9(13).                    
COB305     05 WS-SERV-ORDER-NO-D        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.     
COB305     05 WS-SERV-ORDER-NO-TEMP        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.     
COB305     05 WS-SERV-ORDER-NO-TMP        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.     
           05  WS-CURR-TIMESTAMP           PIC X(26).                   
           05  WS-CURR-TIME-REDEF REDEFINES WS-CURR-TIMESTAMP.          
               10  WS-CURR-CENTURY         PIC X(02).                   
               10  WS-CURR-YEAR            PIC X(02).                   
               10  FILLER                  PIC X(01).                   
               10  WS-CURR-MONTH           PIC X(02).                   
               10  FILLER                  PIC X(01).                   
               10  WS-CURR-DAY             PIC X(02).                   
               10  FILLER                  PIC X(01).                   
               10  WS-CURR-HOUR            PIC X(02).                   
               10  FILLER                  PIC X(01).                   
               10  WS-CURR-MINUTE          PIC X(02).                   
               10  FILLER                  PIC X(01).                   
               10  WS-CURR-SECOND          PIC X(02).                   
               10  FILLER                  PIC X(07).                   
           05  WS-USER-ID                  PIC X(07) VALUE SPACES.      
           05  WS-PASSWORD.                                             
               49  WS-PASSWORD-LEN     PIC S9(4) COMP SYNC VALUE +0.    
               49  WS-PASSWORD-TEXT    PIC X(15) VALUE SPACES.          
           05  WS-SERVER.                                               
               49  WS-SERVER-LEN       PIC S9(4) COMP SYNC VALUE +0.    
               49  WS-SERVER-TEXT      PIC X(17) VALUE SPACES.          
c28616     05  WS-UPDATE-PARM              pic x(01) VALUE SPACE.       
               88 T-PARM         value 'T'.                             
               88 P-PARM         value 'P'.                             
T31477         88 B-PARM         value 'B'.                             
           05  WS-SO-EXISTS                PIC X(01) VALUE 'Y'.         
           05  WS-NO-MORE-DNPS-SW          PIC X(01) VALUE 'N'.         
               88 WS-NO-MORE-DNPS                    VALUE 'Y'.         
           05  WS-SO-UPDATE-WORKED-SW      PIC X(01) VALUE 'N'.         
               88 WS-SO-UPDATE-WORKED                VALUE 'Y'.         
T23235     05  WS-NOT-UPDATE-WORKED-SW     PIC X(01) VALUE 'N'.         
T23235         88 WS-NOT-UPDATE-WORKED               VALUE 'Y'.         
 T3437     05  WS-RCNCT-FOUND-SW           PIC X(01) VALUE 'N'.         
 T3437         88 WS-RCNCT-FOUND                     VALUE 'Y'.         
           05  ALL-DONE-SW                 PIC X(01) VALUE 'N'.         
               88 NOT-ALL-DONE                       VALUE 'N'.         
               88 ALL-DONE                           VALUE 'Y'.         
           05  SEND-DONE-SW                PIC X(01) VALUE 'Y'.         
               88 SEND-DONE-ERROR                    VALUE 'N'.         
               88 SEND-DONE-OK                       VALUE 'Y'.         
           05  SW-PROCESSING               PIC X(01) VALUE SPACES.      
           05  SW-RESULTS                  PIC X(01) VALUE 'Y'.         
               88 NO-MORE-RESULTS                    VALUE 'N'.         
               88 MORE-RESULTS                       VALUE 'Y'.         
T16871     05  SW-DNP-TYPE                 PIC X(05) VALUE 'DNP01'.     
T16871         88 DNP-IS-DNPFB                       VALUE 'DNPFB'.     
T23235     05 WS-NOT-SWITCH              PIC X(01) VALUE 'N'.           
T23235        88 WS-NOT-EXIST                      VALUE 'Y'.           
T23235     05 WS-DNP-SWITCH              PIC X(01) VALUE 'N'.           
T23235        88 WS-DNP-EXIST                      VALUE 'Y'.           
BASKAR     05 WS-DELETE-ROW-SW           PIC X(01) VALUE 'Y'.           
BASKAR        88 DELETE-ROW                        VALUE 'Y'.           
BASKAR        88 DO-NOT-DELETE-ROW                 VALUE 'N'.           
T31477     05  WS-DATABASE               PIC 9(01) VALUE ZERO.          
T31477         88  CSR-DATABASE                    VALUE 1.             
T31477         88  SEB-DATABASE                    VALUE 2.             
T31477     05  WS-DELINQ-CD              PIC X(20) VALUE SPACES.        
COB305     05 WS-DELINQ-VALUE        PIC S9(09) COMP-3 VALUE 0.             
T31477     05  WS-COMPANY-NO             PIC X(02) VALUE SPACES.        
T31477     05  WS-RELEASE-DATE           PIC X(10) VALUE SPACES.        
T31477     05  WS-CURRENT-DATE           PIC X(10) VALUE SPACES.        
T31477     05  WS-WORK-DAY-TABLE.                                       
T31477         10  WS-WORK-DAY-LIST                                     
T31477                OCCURS 30 TIMES                                   
T31477                ASCENDING KEY WS-WORK-DAY                         
T31477                INDEXED BY WD-INDX.                               
T31477             15  WS-WORK-DAY       PIC X(10).                     
T31477     05  WS-ADJ-DAY                PIC S9(9) COMP.                
C35179*                                                                         
C35179     05  WS-COMMIT-DATA.                                          
C35179         10  WS-COMMIT-TEXT        PIC X(09).                     
C35179         10  WS-COMMIT-CNT         PIC 9(04).                     
C35179         10  FILLER                PIC X(67).                     
C35179     05  WS-DEFAULT-CHKP-LUW-LIMIT PIC 9(04) VALUE 50.            
C35179     05  WS-CHKP-LUW-LIMIT         PIC 9(04) VALUE 0.             
C35179     05  WS-NO-ACCTS-PROCESSED     PIC 9(04) VALUE 0.             
C35179     05  WS-COMMIT-NO-TAKEN        PIC 9(04) VALUE 0.             
A01016     05  WS-ORDER-TYPE-CD          PIC X(05) VALUE SPACES.        
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-NAC7                     PIC X(04)   VALUE 'NAC7'.    
           05  WS-NA-SO                    PIC X(03)   VALUE 'NA '.     
           05  WS-A                        PIC X(01)   VALUE 'A'.       
           05  WS-B                        PIC X(01)   VALUE 'B'.       
           05  WS-D                        PIC X(01)   VALUE 'D'.       
           05  WS-E                        PIC X(01)   VALUE 'E'.       
           05  WS-F                        PIC X(01)   VALUE 'F'.       
           05  WS-G                        PIC X(01)   VALUE 'G'.       
           05  WS-H                        PIC X(01)   VALUE 'H'.       
           05  WS-I                        PIC X(01)   VALUE 'I'.       
           05  WS-J                        PIC X(01)   VALUE 'J'.       
           05  WS-K                        PIC X(01)   VALUE 'K'.       
           05  WS-O                        PIC X(01)   VALUE 'O'.       
           05  WS-P                        PIC X(01)   VALUE 'P'.       
           05  WS-S                        PIC X(01)   VALUE 'S'.       
           05  WS-T                        PIC X(01)   VALUE 'T'.       
PCR307     05  WS-U                        PIC X(01)   VALUE 'U'.       
           05  WS-W                        PIC X(01)   VALUE 'W'.       
           05  WS-1                        PIC X(01)   VALUE '1'.       
           05  WS-2                        PIC X(01)   VALUE '2'.       
           05  WS-0006                     PIC X(04)   VALUE '0006'.    
           05  WS-0034                     PIC X(04)   VALUE '0034'.    
           05  WS-0043                     PIC X(04)   VALUE '0043'.    
           05  WS-0046                     PIC X(04)   VALUE '0046'.    
           05  WS-SO                       PIC X(02)   VALUE 'SO'.      
           05  WS-BF                       PIC X(02)   VALUE 'BF'.      
           05  WS-AM                       PIC X(02)   VALUE 'AM'.      
           05  WS-PM                       PIC X(02)   VALUE 'PM'.      
           05  WS-NO                       PIC X(03)   VALUE 'NO '.     
           05  WS-YES                      PIC X(03)   VALUE 'YES'.     
           05  WS-CCO                      PIC X(03)   VALUE 'CCO'.     
           05  WS-A-R                      PIC X(03)   VALUE 'A/R'.     
           05  WS-DEP                      PIC X(03)   VALUE 'DEP'.     
           05  WS-OFF                      PIC X(05)   VALUE 'OFF01'.   
           05  WS-DNPFB                    PIC X(05)   VALUE 'DNPFB'.   
T23235     05  WS-NOT01                    PIC X(05)   VALUE 'NOT01'.   
T23235     05  WS-PSNC                     PIC X(02)   VALUE '26'.      
T25205     05  WS-SDNP                     PIC X(04)   VALUE 'SDNP'.    
T25205     05  WS-SNOT                     PIC X(04)   VALUE 'SNOT'.    
T30698     05  WS-S336                     PIC X(04)   VALUE 'S336'.    
C28616     05  WS-BMX                      PIC X(04)   VALUE 'BMX '.    
C34176     05  WS-NOTICE                   PIC X(04)   VALUE 'NOTC'.    
           05  WS-MC                       PIC X(03)   VALUE 'MC '.     
           05  WS-FM                       PIC X(03)   VALUE 'FM '.     
           05  WS-ON                       PIC X(03)   VALUE 'ON '.     
           05  WS-CC                       PIC X(05)   VALUE 'CC001'.   
           05  WS-NC                       PIC X(05)   VALUE 'NC001'.   
           05  WS-CCC                      PIC X(03)   VALUE 'CCC'.     
           05  WS-OFF2                     PIC X(05)   VALUE 'OFF02'.   
           05  WS-OFF3                     PIC X(05)   VALUE 'OFF03'.   
T10748     05  WS-DNPFB-CD                 PIC X(01)   VALUE 'B'.       
           05  WS-RESOLVED                 PIC X(01)   VALUE 'R'.       
T12718     05  WS-INCOMPLETE               PIC X(01)   VALUE 'I'.       
                                                                        
      ******************************************************************        
      *    DB2 CURSOR DECLARATIONS                                     *        
      ******************************************************************        
                                                                        
      * DECLARE SO DNP CANCEL CURSOR FOR NORMAL PROCESSING                      
           EXEC SQL                                                     
             DECLARE DNP_CANCEL_CUR CURSOR WITH HOLD FOR                
              SELECT ACCOUNT_NO,                                        
 T3437               SO_UPDT_ACTION_FL                                  
                FROM CSS_SO_DNP_CANCEL WITH(READUNCOMMITTED)                    
P00948         WHERE SO_UPDT_ACTION_FL IN ('B','N','P','T')             
PERFOR       FOR READ ONLY                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE DNP_CANCEL_CUR CURSOR WITH HOLD FOR                        
MFA-TR*       SELECT ACCOUNT_NO,                                                
MFA-TR*              SO_UPDT_ACTION_FL                                          
MFA-TR*         FROM CSS_SO_DNP_CANCEL                                          
MFA-TR*        WHERE SO_UPDT_ACTION_FL IN ('B','N','P','T')                     
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*    END-EXEC.                                                            
c28616*                                                                         
T31477* DECLARE SO DNP CANCEL CURSOR FOR SEB B PROCESSING                       
T31477     EXEC SQL                                                     
T31477       DECLARE DNP_CANCEL_SEBB CURSOR WITH HOLD FOR               
T31477        SELECT ACCOUNT_NO,                                        
T31477               SO_UPDT_ACTION_FL                                  
T31477          FROM CSS_SO_DNP_CANCEL WITH(READUNCOMMITTED)                    
PERFOR         WHERE SO_UPDT_ACTION_FL = 'B'                            
PERFOR       FOR READ ONLY                                      
T31477     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE DNP_CANCEL_SEBB CURSOR WITH HOLD FOR                       
MFA-TR*       SELECT ACCOUNT_NO,                                                
MFA-TR*              SO_UPDT_ACTION_FL                                          
MFA-TR*         FROM CSS_SO_DNP_CANCEL                                          
MFA-TR*        WHERE SO_UPDT_ACTION_FL = 'B'                                    
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*    END-EXEC.                                                            
T31477*                                                                         
T31477* DECLARE SO DNP CANCEL CURSOR FOR SEB P PROCESSING                       
T31477     EXEC SQL                                                     
T31477       DECLARE DNP_CANCEL_SEBP CURSOR WITH HOLD FOR               
T31477        SELECT ACCOUNT_NO,                                        
T31477               SO_UPDT_ACTION_FL                                  
T31477          FROM CSS_SO_DNP_CANCEL WITH(READUNCOMMITTED)                    
P00948         WHERE SO_UPDT_ACTION_FL IN ('P','T')                     
PERFOR       FOR READ ONLY                                      
T31477     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE DNP_CANCEL_SEBP CURSOR WITH HOLD FOR                       
MFA-TR*       SELECT ACCOUNT_NO,                                                
MFA-TR*              SO_UPDT_ACTION_FL                                          
MFA-TR*         FROM CSS_SO_DNP_CANCEL                                          
MFA-TR*        WHERE SO_UPDT_ACTION_FL IN ('P','T')                             
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*    END-EXEC.                                                            
c28616*                                                                         
C28616* DECLARE SO DNP CANCEL CURSOR FOR BILLMATRIX PROCESSING                  
C28616     EXEC SQL                                                     
C28616       DECLARE DNP_BMX_CUR CURSOR WITH HOLD FOR                   
C28616        SELECT ACCOUNT_NO,                                        
C28616               SO_UPDT_ACTION_FL                                  
C28616          FROM CSS_SO_DNP_CANCEL WITH(READUNCOMMITTED)                    
P00948         WHERE SO_UPDT_ACTION_FL IN ('P','T')                     
PERFOR       FOR READ ONLY                                      
C28616     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE DNP_BMX_CUR CURSOR WITH HOLD FOR                           
MFA-TR*       SELECT ACCOUNT_NO,                                                
MFA-TR*              SO_UPDT_ACTION_FL                                          
MFA-TR*         FROM CSS_SO_DNP_CANCEL                                          
MFA-TR*        WHERE SO_UPDT_ACTION_FL IN ('P','T')                             
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*    END-EXEC.                                                            
                                                                        
REARCH* DECLARE DNP_TYP_CUR   CURSOR                                            
REARCH     EXEC SQL                                                     
REARCH       DECLARE DNP_TYP_CUR CURSOR FOR                             
REARCH       SELECT SERV_ORDER_NO,                                      
REARCH              SERV_ORDER_STATUS,                                  
REARCH              ORDER_REASON,                                       
REARCH              ORDER_TYPE_CD                                       
REARCH       FROM CSS_SO_DATA WITH(READUNCOMMITTED)                             
REARCH       WHERE ACCOUNT_NO_PRIOR = :WS-SO-ACCOUNT-NO-D               
REARCH         AND ORDER_STATE_CD NOT IN ('C','Z')                      
REARCH         AND ORDER_TYPE_CD  LIKE 'DNP%'                           
REARCH         AND DATE_RECVED = (SELECT MAX(DATE_RECVED)               
REARCH                            FROM CSS_SO_DATA WITH(READUNCOMMITTED)        
REARCH              WHERE ACCOUNT_NO_PRIOR = :WS-SO-ACCOUNT-NO-D        
REARCH              AND ORDER_TYPE_CD LIKE 'DNP%')                      
PERFOR       FOR READ ONLY                                      
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE DNP_TYP_CUR CURSOR FOR                                     
MFA-TR*      SELECT SERV_ORDER_NO,                                              
MFA-TR*             SERV_ORDER_STATUS,                                          
MFA-TR*             ORDER_REASON,                                               
MFA-TR*             ORDER_TYPE_CD                                               
MFA-TR*      FROM CSS_SO_DATA                                                   
MFA-TR*      WHERE ACCOUNT_NO_PRIOR = :WS-SO-ACCOUNT-NO-D                       
MFA-TR*        AND ORDER_STATE_CD NOT IN ('C','Z')                              
MFA-TR*        AND ORDER_TYPE_CD  LIKE 'DNP%'                                   
MFA-TR*        AND DATE_RECVED = (SELECT MAX(DATE_RECVED)                       
MFA-TR*                           FROM CSS_SO_DATA                              
MFA-TR*             WHERE ACCOUNT_NO_PRIOR = :WS-SO-ACCOUNT-NO-D                
MFA-TR*             AND ORDER_TYPE_CD LIKE 'DNP%')                              
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*    END-EXEC.                                                            
                                                                        
       01  WS-END                       PIC X(40)                       
REARCH     VALUE 'WORKING STORAGE FOR CSR02336 ENDS HERE  '.
MSQ001        EXEC SQL
MSQ001          DECLARE C11 CURSOR
MSQ001          FOR CALL CSR00125                                       
REARCH                 ( :WS-SO-ACCOUNT-NO-C
                  , :WS-SO-PREMISE-NO-C
                  , :WS-SO-USER-ID-C
                  , :WS-SO-REMARK-TX-C
                  , :WS-SO-UPDATE-REMARKS-C
                  , :WS-SO-SELECT-UPDATE-C
                  , :WS-SO-PANEL-NO-C
                  , :WS-SO-ORDER-TYPE-FLAG-C
                  , :WS-SO-DNP-CANCEL-REASON
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE C4 CURSOR
MSQ001          FOR CALL CSR04422                                       
REARCH                 ( :WS-SO-ACCOUNT-NO-C
                  , :WS-SO-ORDER-TYPE-CD-C
                  )
MSQ001        END-EXEC.
            
                                                                        
       LINKAGE SECTION.                                                 
REARCH 01  LINK-UPDATE-PARM                PIC X(01).                   
                                                                        
                                                                        
REARCH PROCEDURE DIVISION USING  LINK-UPDATE-PARM.                      
                                                                        
      ******************************************************************        
      **                                                              **        
      **    0000-MAINLINE                                             **        
      **                                                              **        
      **    CONTROLS THE MAIN PATH OF THE PROGRAM                     **        
      **                                                              **        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZATION        THRU 0100-EXIT.           
T31477     PERFORM 0700-GET-CURRENT-DATE      THRU 0700-EXIT.           
C35179     PERFORM 7600-GET-JOB-PARM          THRU 7600-EXIT.           
           PERFORM 1000-STOP-DISCONNECTS      THRU 1000-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZATION                                            *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZATION.                                             
           MOVE '0100'   TO ACTIVE-PARAGRAPH.                           
                                                                        
           PERFORM 0200-INIT-SERVER         THRU 0200-EXIT.             
REARCH     MOVE PARM-UPDATE-PARM            TO WS-UPDATE-PARM.          
                                                                        
           MOVE WS-N                        TO WS-NO-MORE-DNPS-SW.      
PRJ481     ADD 1                            TO CTR-ROWS.                
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0200-INIT-SERVER                                               *        
      *     CALLS 9998-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 0100-INITIALIZATION                            *        
      *                                                                *        
      *****************************************************************D        
       0200-INIT-SERVER.                                                
                                                                        
           MOVE '0200'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
REARCH     MOVE LINK-UPDATE-PARM        TO PARM-UPDATE-PARM.            
                                                                        
REARCH     EXEC SQL                                                     
REARCH       DECLARE C1 CURSOR  FOR                          
REARCH       SELECT                                                     
PRJ481        :S-RETURN-CODE              AS    RETURN_CODE             
PRJ481       ,:ACTIVE-PARAGRAPH           AS    ACTVE_PARAGRAPH         
PRJ481       ,:S-MSGTEXT                  AS    S_MSGTEXT               
REARCH          FROM CIS.SYSDUMMY1                                   
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :S-RETURN-CODE              AS    RETURN_CODE                     
MFA-TR*      ,:ACTIVE-PARAGRAPH           AS    ACTVE_PARAGRAPH                 
MFA-TR*      ,:S-MSGTEXT                  AS    S_MSGTEXT                       
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       0200-EXIT.                                                       
           EXIT.                                                        
T31477*                                                                         
T31477******************************************************************        
T31477*                                                                *        
T31477* GET THE CURRENT DATE FROM CSS_MODEL_SQL AND CALCULATE RELEASE  *        
T31477* DATE FOR SEB B ACCOUNTS.                                       *        
T31477*                                                                *        
T31477******************************************************************        
T31477 0700-GET-CURRENT-DATE.                                           
T31477*                                                                         
T31477     MOVE '0700' TO ACTIVE-PARAGRAPH.                             
T31477                                                                  
T31477     EXEC SQL                                                     
PERFOR       SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                        
T31477     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-CURRENT-DATE = CURRENT DATE                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T31477                                                                  
T31477     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T31477     IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
T31477        NEXT SENTENCE                                             
T31477     ELSE                                                         
T31477        MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
T31477        MOVE 'SELECT'               TO ABEND-FUNCTION             
T31477        MOVE 'SET '                 TO TABLE-1                    
T31477        MOVE '             '        TO TABLE-ELEMENT-1            
T31477        MOVE '             '        TO HOSTVAR-ELEMENT-1          
T31477                                                                  
PRJ481        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
T31477     END-IF.                                                      
T31477                                                                  
T31477     INITIALIZE WS-WORK-DAY-TABLE.                                
T31477     MOVE 'DATABASE' TO WS-DELINQ-CD.                             
T31477     MOVE '01' TO WS-COMPANY-NO.                                  
T31477     PERFORM 1500-CHECK-DELINQ-VALUE THRU 1500-EXIT.              
T31477     MOVE WS-DELINQ-VALUE TO WS-DATABASE.                         
T31477     IF SEB-DATABASE                                              
T31477        IF B-PARM                                                 
T31477           MOVE 'DAY-SEB-B-CANCEL' TO WS-DELINQ-CD                
T31477           PERFORM 1500-CHECK-DELINQ-VALUE THRU 1500-EXIT         
T31477           MOVE 1 TO WS-ADJ-DAY                                   
T31477           SET WD-INDX TO WS-DELINQ-VALUE                         
T31477           PERFORM UNTIL WD-INDX < 1                              
T31477                      OR WS-ADJ-DAY > 30                          
T31477              PERFORM 7450-GET-PREV-BUSINESS-DATE THRU 7450-EXIT  
T31477              EVALUATE SQLCODE                                    
T31477                 WHEN SUCCESSFUL-CALL                             
T31477                    MOVE WS-RELEASE-DATE TO WS-WORK-DAY (WD-INDX) 
T31477                    ADD 1 TO WS-ADJ-DAY                           
T31477                    SET WD-INDX DOWN BY 1                         
T31477                 WHEN NOT-FOUND                                   
T31477                    ADD 1 TO WS-ADJ-DAY                           
T31477                 WHEN OTHER                                       
T31477                    DISPLAY 'WORK-DATE ERROR'                     
T31477                    SET WD-INDX TO 1                              
T31477                    SET WD-INDX DOWN BY 1                         
T31477              END-EVALUATE                                        
T31477           END-PERFORM                                            
T31477        END-IF                                                    
T31477     END-IF.                                                      
T31477*                                                                         
T31477 0700-EXIT.                                                       
T31477     EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * THIS PARAGRAPH IS THE MAIN LOOP IN THE PROCESS TO STOP A       *        
      * DISCONNECT SERVICE ORDER AND SEND A WORK QUEUE TO THE          *        
      * DISPATCHER TO NOT WORK THE DISCONNECT SERVICE ORDER.           *        
      ******************************************************************        
       1000-STOP-DISCONNECTS.                                           
           MOVE '1000' TO ACTIVE-PARAGRAPH.                             
c28616*                                                                         
T31477     IF SEB-DATABASE                                              
T31477        IF B-PARM                                                 
T31477           PERFORM 7400-OPEN-SEBB-DNP-CANCEL THRU 7400-EXIT       
T31477           PERFORM 7410-LOOP-SEBB-DNPS THRU 7410-EXIT             
T31477             UNTIL WS-NO-MORE-DNPS                                
T31477           PERFORM 7430-CLOSE-SEBB-DNP-CANCEL THRU 7430-EXIT      
T31477        ELSE                                                      
T31477           IF P-PARM                                              
T31477              PERFORM 7500-OPEN-SEBP-DNP-CANCEL thru 7500-EXIT    
T31477              PERFORM 7510-LOOP-SEBP-DNPS THRU 7510-EXIT          
T31477                UNTIL WS-NO-MORE-DNPS                             
C28616              PERFORM 7530-CLOSE-SEBP-DNP-CANCEL THRU 7530-EXIT   
T31477           ELSE                                                   
T31477              IF T-PARM                                           
T31477                 PERFORM 7350-OPEN-DNP-BMX-CURSOR THRU 7350-EXIT  
T31477                 PERFORM 1150-LOOP-DNPS THRU 1150-EXIT            
T31477                   UNTIL WS-NO-MORE-DNPS                          
T31477                 PERFORM 7370-CLOSE-DNP-BMX-CUR THRU 7370-EXIT    
T31477              END-IF                                              
T31477           END-IF                                                 
T31477        END-IF                                                    
T31477     ELSE                                                         
C28616        IF P-PARM                                                 
C28616           PERFORM 7300-OPEN-SO-DNP-CANCEL    THRU 7300-EXIT      
C28616           PERFORM 1100-LOOP-DNPS             THRU 1100-EXIT      
C28616             UNTIL WS-NO-MORE-DNPS                                
C28616           PERFORM 7340-CLOSE-SO-DNP-CANCEL   THRU 7340-EXIT      
C28616        ELSE                                                      
C28616           IF T-PARM                                              
C28616              PERFORM 7350-OPEN-DNP-BMX-CURSOR THRU 7350-EXIT     
C28616              PERFORM 1150-LOOP-DNPS             THRU 1150-EXIT   
C28616                UNTIL WS-NO-MORE-DNPS                             
C28616              PERFORM 7370-CLOSE-DNP-BMX-CUR    THRU 7370-EXIT    
C28616           END-IF                                                 
C28616        END-IF                                                    
T31477     END-IF.                                                      
C28616*                                                                         
                                                                        
PRJ481     MOVE 0                             TO S-RETURN-CODE.         
           MOVE 'DONE'                        TO ACTIVE-PARAGRAPH.      
           MOVE WS-NO-OF-SO-PROCESSED TO WS-NO-OF-SO-PROCESSED-DISP.    
PRJ481     MOVE WS-NO-OF-SO-PROCESSED-DISP    TO S-MSGTEXT.             
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * THIS PARAGRAPH CONTROLS THE FETCH OF THE SO DNP CANCEL DB2     *        
      * TABLE AND THEN CALLS ROUTINES TO STOP THE DISCONNECT AND WQ.   *        
      *                                                                *        
      ******************************************************************        
       1100-LOOP-DNPS.                                                  
           MOVE '1100' TO ACTIVE-PARAGRAPH.                             
           PERFORM 7320-FETCH-SO-DNP-CANCEL       THRU 7320-EXIT.       
           IF WS-ACTIVE-RETURN-CODE EQUAL     TO SUCCESSFUL-CALL        
             ADD 1 TO WS-NO-OF-SO-PROCESSED                             
C35179       ADD 1 TO WS-NO-ACCTS-PROCESSED                             
             PERFORM 1200-PROCESS-EACH-ACCOUNT    THRU 1200-EXIT        
C35179       PERFORM 9600-COMMIT-WORK             THRU 9600-EXIT        
           ELSE                                                         
             MOVE WS-Y                    TO WS-NO-MORE-DNPS-SW         
           END-IF.                                                      
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
c28616*                                                                         
C28616 1150-LOOP-DNPS.                                                  
C28616     MOVE '1150' TO ACTIVE-PARAGRAPH.                             
           PERFORM 7360-FETCH-DNP-BMX-CUR        THRU 7360-EXIT.        
           IF WS-ACTIVE-RETURN-CODE EQUAL     TO SUCCESSFUL-CALL        
             ADD 1 TO WS-NO-OF-SO-PROCESSED                             
C35179       ADD 1 TO WS-NO-ACCTS-PROCESSED                             
             PERFORM 1200-PROCESS-EACH-ACCOUNT    THRU 1200-EXIT        
C35179       PERFORM 9600-COMMIT-WORK             THRU 9600-EXIT        
           ELSE                                                         
             MOVE WS-Y                    TO WS-NO-MORE-DNPS-SW         
           END-IF.                                                      
                                                                        
       1150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * THIS PROCESS WILL UPDATE THE DISCONNECT SERVICE ORDER TO 'C'   *        
      * CANCELLED. THE SERVICE ORDER DATA IS ON SYBASE SO THIS IS A    *        
      * LITTLE BIT DIFFICULT.                                          *        
      ******************************************************************        
       1200-PROCESS-EACH-ACCOUNT.                                       
           MOVE '1200' TO ACTIVE-PARAGRAPH.                             
BASKAR     SET DELETE-ROW  TO TRUE.                                     
 T3437     PERFORM 7000-GET-CURRENT-TIMESTAMP THRU 7000-EXIT.           
     *                                                                  
T31477     IF SEB-DATABASE                                              
T31477        IF B-PARM                                                 
T31477           NEXT SENTENCE                                          
T31477        ELSE                                                      
                 MOVE XK-ACCOUNT-NO TO AT-ACCOUNT-NO                    
PCR360                                 CZ-ACCOUNT-NO                    
T23235           PERFORM 7200-SELECT-ACCOUNT THRU 7200-EXIT             
T31477        END-IF                                                    
T31477     ELSE                                                         
              MOVE XK-ACCOUNT-NO TO AT-ACCOUNT-NO                       
PCR360                              CZ-ACCOUNT-NO                       
T23235        PERFORM 7200-SELECT-ACCOUNT THRU 7200-EXIT                
T31477     END-IF.                                                      
T23235                                                                  
T23235     MOVE WS-N                     TO WS-NOT-SWITCH               
T23235     MOVE WS-N                     TO WS-DNP-SWITCH               
C28467     MOVE SPACES                   TO WS-ORDER-TYPE-CD-BD         
C30698     MOVE WS-S336                  TO WS-SO-PANEL-NO-C            
T23235                                                                  
T23235                                                                  
T19592     PERFORM 5700-GET-DNP-TYPE  THRU 5700-EXIT                    
T23235                                                                  
T23235     IF NOT WS-NOT-EXIST                                          
C34176       IF   XK-SO-UPDT-ACTION-FL   = WS-B OR = WS-N               
T19449          IF WS-ORDER-TYPE-CD-BD = WS-DNPFB                       
T19449             PERFORM 8000-DELETE-SO-DNP           THRU 8000-EXIT  
T19449             GO TO 1200-EXIT                                      
T19449          ELSE                                                    
T12718             MOVE WS-A                 TO WS-SO-ORDER-TYPE-FLAG-C 
T18559             MOVE 'DNP01'              TO SW-DNP-TYPE             
T23235             SET WS-DNP-EXIST          TO TRUE                    
T19449          END-IF                                                  
T12718       ELSE                                                       
T12718          IF WS-ORDER-TYPE-CD-BD  = 'DNPFB'                       
T12718             MOVE WS-B                TO WS-SO-ORDER-TYPE-FLAG-C  
T16871             MOVE WS-DNPFB            TO SW-DNP-TYPE              
T23235             SET  WS-DNP-EXIST        TO TRUE                     
T12718          ELSE                                                    
T12718             MOVE WS-A                TO WS-SO-ORDER-TYPE-FLAG-C  
T18559             MOVE 'DNP01'             TO SW-DNP-TYPE              
T23235             SET  WS-DNP-EXIST        TO TRUE                     
T12718          END-IF                                                  
T12718       END-IF                                                     
T23235     END-IF.                                                      
                                                                        
T23235     IF (AT-COMPANY-NO = WS-PSNC AND                              
T23235         WS-ORDER-TYPE-CD-BD NOT = WS-NOT01)                      
T23235        IF WS-ORDER-TYPE-CD-BD = WS-DNPFB                         
T23235           MOVE WS-B                TO WS-SO-ORDER-TYPE-FLAG-C    
T23235           MOVE WS-DNPFB            TO SW-DNP-TYPE                
T23235           SET  WS-DNP-EXIST        TO TRUE                       
T23235        ELSE                                                      
T23235           MOVE WS-A                TO WS-SO-ORDER-TYPE-FLAG-C    
T23235           MOVE 'DNP01'             TO SW-DNP-TYPE                
T23235           SET  WS-DNP-EXIST        TO TRUE                       
T23235        END-IF                                                    
T23235     END-IF.                                                      
T23235                                                                  
PCR360     MOVE AT-PREMISE-NO                 TO PR-PREMISE-NO.         
T25205                                                                  
T25205     IF (WS-DNP-EXIST AND                                         
T25205          XK-SO-UPDT-ACTION-FL   = WS-B)                          
T25205         MOVE WS-SDNP                   TO WS-SO-PANEL-NO-C       
T25205     END-IF                                                       
T25205                                                                  
T25205     IF (WS-NOT-EXIST AND                                         
T25205          XK-SO-UPDT-ACTION-FL   = WS-B)                          
T25205         MOVE WS-SNOT                   TO WS-SO-PANEL-NO-C       
T25205     END-IF                                                       
C28616                                                                  
c28616     IF (WS-DNP-EXIST AND                                         
C28616          T-PARM)                                                 
C28616        MOVE WS-BMX                     TO WS-SO-PANEL-NO-C       
C28616     END-IF                                                       
C28616                                                                  
C34176     IF (WS-DNP-EXIST AND                                         
C34176          XK-SO-UPDT-ACTION-FL   = WS-N)                          
C34176        MOVE WS-NOTICE                  TO WS-SO-PANEL-NO-C       
C34176     END-IF                                                       
C28616                                                                  
T23235     IF WS-DNP-EXIST                                              
              PERFORM 5000-UPDATE-SO-STATUS      THRU 5000-EXIT         
T19293       IF WS-SO-RETURN-CD-BD = 5000                               
C30174          IF CSR-DATABASE                                         
T19293             PERFORM 5500C-SEND-WQ-DNP-COMPLETE THRU 5500C-EXIT   
C30174          END-IF                                                  
T19293          PERFORM 8000-DELETE-SO-DNP           THRU 8000-EXIT     
T19293          GO TO 1200-EXIT                                         
T19293       END-IF                                                     
c28693** comment out do-not-delete                                              
BASKAR*      IF WS-SO-RETURN-CD-BD = SUCCESSFUL-CALL                            
BASKAR*         SET DO-NOT-DELETE-ROW    TO TRUE                                
BASKAR*      END-IF                                                             
C28693**                                                                        
C34176*                                                                         
A01016       IF  XK-SO-UPDT-ACTION-FL = 'N' OR 'B'                      
C34176       AND CSR-DATABASE                                           
C34176         IF  WS-SO-RETURN-CD-BD = NOT-FOUND                       
C34176         AND WS-ORDER-TYPE-CD-BD = 'DNP01'                        
C34176             PERFORM 5500N-SEND-WQ-TO-DISPATCHER THRU 5500N-EXIT  
C34176         ELSE                                                     
ACT057             CONTINUE                                             
C34176         END-IF                                                   
C34176       END-IF                                                     
C34176*                                                                         
 T3437       IF WS-SO-RETURN-CD-BD = NOT-FOUND                          
 T3437          AND WS-SO-ORDER-TYPE-FLAG-C = 'A'                       
 T3437          MOVE 'B'                  TO WS-SO-ORDER-TYPE-FLAG-C    
 T3437          PERFORM 5000B-FIND-DNPFB        THRU 5000B-EXIT         
 T3437          IF WS-DNPFB-RETURN-CD-BD = SUCCESSFUL-CALL              
c28616             IF XK-SO-UPDT-ACTION-FL = 'P' OR 'T'                 
C30174                IF CSR-DATABASE                                   
T15570                   PERFORM 5500B-SEND-WQ-DNPFB  THRU 5500B-EXIT   
C30174                END-IF                                            
T15570             END-IF                                               
 T3437          END-IF                                                  
 T3437       END-IF                                                     
             IF WS-SO-RETURN-CD-BD = SUCCESSFUL-CALL                    
                MOVE WS-Y                TO WS-SO-UPDATE-WORKED-SW      
             ELSE                                                       
                MOVE WS-N                TO WS-SO-UPDATE-WORKED-SW      
             END-IF                                                     
T23235     END-IF.                                                      
                                                                        
T23235     IF WS-INSERT-WORK-QUEUE-BD = 'Y'                             
T23235        IF (WS-DNP-EXIST AND WS-SO-UPDATE-WORKED)                 
C30174           AND CSR-DATABASE                                       
                PERFORM 5500-SEND-WQ-TO-DISPATCHER THRU 5500-EXIT       
T23235        END-IF                                                    
T23235     END-IF                                                       
                                                                        
                                                                        
T23235     IF WS-INSERT-WORK-QUEUE-BD = 'Y'                             
T23235        IF (WS-NOT-EXIST AND WS-NOT-UPDATE-WORKED)                
C30174           AND CSR-DATABASE                                       
T23235          PERFORM 5500D-SEND-WQ-TO-DISPATCHER THRU 5500D-EXIT     
T23235        END-IF                                                    
           END-IF.                                                      
      ** DELETE ENTRY IN CSS_SO_DNP_CANCEL IF BOTH OF THE CALLS                 
      ** TO THE STORED PROCEDURES WORKED.                                       
T23235      IF (WS-SO-UPDATE-WORKED OR WS-NOT-UPDATE-WORKED)            
             MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT        
             MOVE SPACES                TO WS-CODE-PENDING-DNP          
             MOVE WS-CODES-DATA-PRESENT TO AT-CODES-DATA-PRESENT        
             PERFORM 8050-UPDATE-ACCOUNT        THRU 8050-EXIT          
PCR360       PERFORM 7210-SELECT-CREDIT-PROFILE THRU 7210-EXIT          
      *                                                                         
                                                                        
T12718       IF XK-SO-UPDT-ACTION-FL = 'B'                              
T12718           MOVE WS-INCOMPLETE TO WS-TEMP-HIST                     
T12718           MOVE 2 TO WS-TEMP-HIST-NUM                             
T12718       ELSE                                                       
C34176          IF XK-SO-UPDT-ACTION-FL = 'N'                           
C34176             MOVE WS-INCOMPLETE TO WS-TEMP-HIST                   
C34176             MOVE 1 TO WS-TEMP-HIST-NUM                           
C34176          ELSE                                                    
PCR360             MOVE WS-RESOLVED   TO WS-TEMP-HIST                   
T12718             MOVE 1 TO WS-TEMP-HIST-NUM                           
C34176          END-IF                                                  
T12718       END-IF                                                     
PCR360       IF (WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
A01016           AND WS-ORDER-TYPE-CD     NOT = 'DNPFB'                 
T23235           AND WS-ORDER-TYPE-CD-BD  NOT = 'NOT01' )               
P00471           EVALUATE WS-ORDER-REASON-BD                            
P00471              WHEN 'N'                                            
P00471              WHEN 'O'                                            
P00471              WHEN 'J'                                            
P00471              WHEN 'K'                                            
P00471              WHEN 'U'                                            
P00471              WHEN 'V'                                            
P00471                   MOVE WS-TEMP-HIST TO                           
P00471                        CZ-DISCONNECT-HIST(WS-TEMP-HIST-NUM:1)    
P00471              WHEN OTHER                                          
P00471                   MOVE WS-TEMP-HIST TO                           
P00471                        CZ-DISC-EXCEPTN-HIST(WS-TEMP-HIST-NUM:1)  
P00471           END-EVALUATE                                           
PCR360           PERFORM 8060-UPDATE-CREDIT-PROFILE  THRU 8060-EXIT     
PCR360       END-IF                                                     
      *                                                                         
PCR360       MOVE WS-PENDING-DNP-FLAG-BD TO PR-SERV-ORDER-PEND          
PCR360       PERFORM 8070-UPDATE-PREMISE        THRU 8070-EXIT          
           END-IF.                                                      
BASKAR     IF DELETE-ROW                                                
BASKAR        PERFORM 8000-DELETE-SO-DNP        THRU 8000-EXIT          
BASKAR     END-IF                                                       
                                                                        
c28616     IF DNP-IS-DNPFB AND XK-SO-UPDT-ACTION-FL not = WS-B          
 T3437        PERFORM 5000A-GET-RECONNECT       THRU 5000A-EXIT         
T16871     END-IF.                                                      
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
T31477*                                                                         
T31477******************************************************************        
T31477* THIS PARAGRAPH CHECKS TO SEE WHICH REGION (CSR, SEB, PSNC).    *        
T31477******************************************************************        
T31477*                                                                         
T31477 1500-CHECK-DELINQ-VALUE.                                         
T31477     MOVE '1500' TO ACTIVE-PARAGRAPH.                             
T31477                                                                  
T31477     EXEC SQL                                                     
T31477       SELECT DELINQ_VALUE                                        
T31477            INTO :WS-DELINQ-VALUE                                 
T31477            FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                    
T31477        WHERE DELINQ_CD =  :WS-DELINQ-CD                          
T31477          AND COMPANY_NO = :WS-COMPANY-NO                         
PERFOR                                                           
T31477     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT DELINQ_VALUE                                                
MFA-TR*           INTO :WS-DELINQ-VALUE                                         
MFA-TR*           FROM CSS_DELINQUENCY                                          
MFA-TR*       WHERE DELINQ_CD =  :WS-DELINQ-CD                                  
MFA-TR*         AND COMPANY_NO = :WS-COMPANY-NO                                 
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T31477                                                                  
T31477     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T31477                                                                  
T31477     IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
T31477        NEXT SENTENCE                                             
T31477     ELSE                                                         
T31477        MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
T31477        MOVE 'SELECT'               TO ABEND-FUNCTION             
T31477        MOVE 'CSS_DELINQUENCY'      TO TABLE-1                    
T31477        MOVE 'DELINQ_CD'            TO TABLE-ELEMENT-1            
T31477        MOVE WS-DELINQ-CD           TO HOSTVAR-ELEMENT-1          
T31477        MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-2            
T31477        MOVE WS-COMPANY-NO          TO HOSTVAR-ELEMENT-2          
PRJ481        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
T31477     END-IF.                                                      
T31477*                                                                         
T31477 1500-EXIT.                                                       
T31477     EXIT.                                                        
                                                                        
      ******************************************************************        
      * THIS PROCESS WILL UPDATE THE DISCONNECT SERVICE ORDER TO 'C'   *        
      * CANCELLED. THE SERVICE ORDER DATA IS ON SYBASE SO THIS IS A    *        
      * LITTLE BIT DIFFICULT.                                          *        
      ******************************************************************        
       5000-UPDATE-SO-STATUS.                                           
           MOVE '5000' TO ACTIVE-PARAGRAPH.                             
                                                                        
           MOVE AT-ACCOUNT-NO                 TO WS-SO-ACCOUNT-NO-D.    
           MOVE WS-SO-ACCOUNT-NO-D            TO WS-SO-ACCOUNT-NO-I.    
           MOVE AT-PREMISE-NO                 TO WS-SO-PREMISE-NO-D.    
           MOVE WS-SO-PREMISE-NO-D            TO WS-SO-PREMISE-NO-I.    
T13392     MOVE LENGTH OF WS-SO-REMARK-TX-TEXT TO WS-SO-REMARK-TX-LEN.  
           MOVE WS-SO-REMARK-MSG              TO WS-SO-REMARK-TX-TEXT.  
                                                                        
           MOVE '9999999999999'               TO WS-SERV-ORDER-CHAR-BD. 
           MOVE '999'                         TO WS-RESP-AREA-ID-BD.    
                                                                        
           PERFORM 5200-GET-SO-DATA THRU 5200-EXIT.                     
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
 T3437******************************************************************        
 T3437* THIS PROCESS WILL GET THE RECONNECT SERVICE ORDER FROM THE     *        
 T3437* TABLE CSS_SO_DATA FROM THE SERVER.                             *        
 T3437******************************************************************        
 T3437 5000A-GET-RECONNECT.                                             
 T3437     MOVE '5000A' TO ACTIVE-PARAGRAPH.                            
 T3437                                                                  
 T3437     MOVE AT-ACCOUNT-NO                 TO WS-SO-ACCOUNT-NO-D.    
 T3437     MOVE WS-SO-ACCOUNT-NO-D            TO WS-SO-ACCOUNT-NO-I.    
T13392     MOVE LENGTH OF WS-SO-REMARK-TX-TEXT TO WS-SO-REMARK-TX-LEN.  
 T3437     MOVE WS-SO-REMARK-MSG              TO WS-SO-REMARK-TX-TEXT.  
 T3437                                                                  
 T3437                                                                  
 T3437     PERFORM 5200A-GET-RCNCT-DATA THRU 5200A-EXIT.                
 T3437                                                                  
 T3437 5000A-EXIT.                                                      
 T3437     EXIT.                                                        
                                                                        
 T3437******************************************************************        
 T3437* THIS PROCESS WILL FIND A DNPFB FROM THE TABLE CSS_SO_DATA TABLE*        
 T3437******************************************************************        
 T3437 5000B-FIND-DNPFB.                                                
 T3437     MOVE '5000B' TO ACTIVE-PARAGRAPH.                            
 T3437                                                                  
 T3437     MOVE AT-ACCOUNT-NO                 TO WS-SO-ACCOUNT-NO-D.    
 T3437     MOVE WS-SO-ACCOUNT-NO-D            TO WS-SO-ACCOUNT-NO-I.    
T13392     MOVE LENGTH OF WS-SO-REMARK-TX-TEXT TO WS-SO-REMARK-TX-LEN.  
 T3437     MOVE WS-SO-REMARK-MSG              TO WS-SO-REMARK-TX-TEXT.  
 T3437     PERFORM 5200B-GET-DNPFB-DATA THRU 5200B-EXIT.                
 T3437                                                                  
 T3437 5000B-EXIT.                                                      
 T3437     EXIT.                                                        
                                                                        
      ******************************************************************        
      * CALL CSR00125 TO CANCEL PENDING DNPS.                          *        
      ******************************************************************        
       5200-GET-SO-DATA.                                                
           MOVE '5200'        TO ACTIVE-PARAGRAPH.                      
T12718     IF XK-SO-UPDT-ACTION-FL = 'B'                                
A01016           MOVE 'F'           TO WS-SO-DNP-CANCEL-REASON          
T12718     ELSE                                                         
C34176         IF  XK-SO-UPDT-ACTION-FL = 'N'                           
C34176             MOVE 'K'         TO WS-SO-DNP-CANCEL-REASON          
C34176         ELSE                                                     
T12718           MOVE WS-RESOLVED   TO WS-SO-DNP-CANCEL-REASON          
C34176         END-IF                                                   
T12718     END-IF.                                                      
                                                                        
           MOVE 'Y'  TO SW-RESULTS.                                     
                                                                        
REARCH*    EXEC SQL CALL CSR00125                                       
REARCH*                ( :WS-SO-ACCOUNT-NO-C                            
REARCH*                 ,:WS-SO-PREMISE-NO-C                            
REARCH*                 ,:WS-SO-USER-ID-C                               
REARCH*                 ,:WS-SO-REMARK-TX-C                             
REARCH*                 ,:WS-SO-UPDATE-REMARKS-C                        
REARCH*                 ,:WS-SO-SELECT-UPDATE-C                         
REARCH*                 ,:WS-SO-PANEL-NO-C                              
REARCH*                 ,:WS-SO-ORDER-TYPE-FLAG-C                       
REARCH*                 ,:WS-SO-DNP-CANCEL-REASON                       
REARCH*                )                                                
REARCH*    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE C11
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN C11
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR C11 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
REARCH     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
REARCH     IF  WS-ACTIVE-RETURN-CODE = +466                             
REARCH*       EXEC SQL ASSOCIATE LOCATORS(:LOC1) WITH PROCEDURE         
REARCH*         CSR00125                                                
REARCH*       END-EXEC                                                  
REARCH*       EXEC SQL ALLOCATE C11 CURSOR FOR RESULT SET :LOC1         
REARCH*       END-EXEC                                                  
REARCH        EXEC SQL                                                  
REARCH        FETCH C11 INTO                                            
REARCH                 :WS-SO-RETURN-CD-BD :IND-01                       
REARCH                ,:WS-SERV-ORDER-CHAR-BD :IND-02                    
REARCH                ,:WS-ORDER-REASON-BD :IND-03                       
REARCH                ,:WS-RESP-AREA-ID-BD :IND-04                       
REARCH                ,:WS-PENDING-DNP-FLAG-BD :IND-05                   
A01016                ,:WS-INSERT-WORK-QUEUE-BD :IND-18                  
REARCH                ,:WS-AMOUNT-DISC-BAL :IND-06                       
A01016                ,:WS-ORDER-TYPE-CD :IND-19                         
REARCH        END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH        MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE    
REARCH        MOVE WS-SO-RETURN-CD-BD       TO WS-RPC-RC                
REARCH        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
REARCH           EVALUATE WS-SO-RETURN-CD-BD                            
REARCH              WHEN 0                                              
REARCH                   MOVE WS-Y TO WS-SO-UPDATE-WORKED-SW            
C35179              WHEN 5000                                           
C35179                   CONTINUE                                       
C35179              WHEN 100                                            
C35179                   CONTINUE                                       
REARCH              WHEN OTHER                                          
REARCH                   MOVE 'CSR00125 FAILED'     TO ABEND-FUNCTION   
REARCH                   MOVE WS-SO-RETURN-CD-BD    TO                  
REARCH                                             WS-ACTIVE-RETURN-CODE
REARCH                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM    
C35179                   MOVE 'CSR00125'            TO TABLE-1          
C35179                   MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1  
C35179                   MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1
PRJ481                   PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT 
REARCH           END-EVALUATE                                           
REARCH        ELSE                                                      
REARCH              MOVE '5200'               TO ACTIVE-PARAGRAPH       
REARCH              MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
REARCH              MOVE 'FETCH'              TO ABEND-FUNCTION         
REARCH              MOVE 'CSR00125'           TO TABLE-1                
REARCH              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1        
REARCH              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1      
REARCH              MOVE 'SQLCODE '           TO TABLE-ELEMENT-2        
REARCH              MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-2     
PRJ481              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT      
REARCH          END-IF                                                  
REARCH          EXEC SQL                                                
REARCH            CLOSE C11                                             
REARCH          END-EXEC                                                

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH          MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE  
REARCH          IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
REARCH              CONTINUE                                            
REARCH          ELSE                                                    
REARCH              MOVE '5200'               TO ACTIVE-PARAGRAPH       
REARCH              MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
REARCH              MOVE 'CLOSE'              TO ABEND-FUNCTION         
REARCH              MOVE 'CSR00125'           TO TABLE-1                
REARCH              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1        
REARCH              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1      
REARCH              MOVE 'SQLCODE '           TO TABLE-ELEMENT-1        
REARCH              MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-1     
PRJ481              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT      
REARCH          END-IF                                                  
REARCH      ELSE                                                        
PRJ481          MOVE -1                       TO S-RETURN-CODE          
C35179          MOVE '5200'                   TO ACTIVE-PARAGRAPH       
REARCH          MOVE PROGRAM-NAME             TO ABEND-PROGRAM          
REARCH          MOVE 'DB2SP CALL'             TO ABEND-FUNCTION         
REARCH          MOVE 'CSR00125'               TO TABLE-1                
REARCH          MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1        
REARCH          MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1      
REARCH          MOVE 'SQLCODE'                TO TABLE-ELEMENT-2        
REARCH          MOVE SQLCODE                  TO HOSTVAR-ELEMENT-2      
PRJ481          PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT          
REARCH      END-IF.                                                     
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
PRJ481* CALL CSR04422.                                                 *        
      ******************************************************************        
 T3437 5200A-GET-RCNCT-DATA.                                            
 T3437     MOVE '5200A'       TO ACTIVE-PARAGRAPH.                      
 T3437     MOVE 'Y'  TO SW-RESULTS.                                     
                                                                        
PRJ481*    EXEC SQL CALL CSR04422                                       
REARCH*                ( :WS-SO-ACCOUNT-NO-C                            
REARCH*                 ,:WS-SO-ORDER-TYPE-CD-C                         
REARCH*                )                                                
REARCH*    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE C4
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN C4
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR C4 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
REARCH     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
REARCH     IF  WS-ACTIVE-RETURN-CODE = +466                             
REARCH*       EXEC SQL ASSOCIATE LOCATORS(:LOC4) WITH PROCEDURE         
PRJ481*         CSR04422                                                
REARCH*       END-EXEC                                                  
REARCH*       EXEC SQL ALLOCATE C4 CURSOR FOR RESULT SET :LOC4          
REARCH*       END-EXEC                                                  
REARCH        EXEC SQL                                                  
REARCH        FETCH C4 INTO                                             
REARCH                 :WS-RCNCT-RETURN-CD-BD :IND-07                    
REARCH        END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH        MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE    
REARCH        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
REARCH           EVALUATE WS-RCNCT-RETURN-CD-BD                         
REARCH              WHEN 0                                              
REARCH                   MOVE WS-Y TO WS-SO-UPDATE-WORKED-SW            
C35179              WHEN 100                                            
C35179                   CONTINUE                                       
REARCH              WHEN OTHER                                          
PRJ481                   MOVE 'CSR04422 FAILED' TO ABEND-FUNCTION       
REARCH                   MOVE WS-RCNCT-RETURN-CD-BD                     
REARCH                                      TO WS-ACTIVE-RETURN-CODE    
REARCH                   MOVE PROGRAM-NAME  TO ABEND-PROGRAM            
PRJ481                   PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT 
REARCH           END-EVALUATE                                           
REARCH        ELSE                                                      
REARCH              MOVE '5200A'              TO ACTIVE-PARAGRAPH       
REARCH              MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
REARCH              MOVE 'FETCH'              TO ABEND-FUNCTION         
PRJ481              MOVE 'CSR04422'           TO TABLE-1                
REARCH              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1        
REARCH              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1      
REARCH              MOVE 'SQLCODE '           TO TABLE-ELEMENT-1        
REARCH              MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-1     
PRJ481              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT      
REARCH        END-IF                                                    
REARCH        EXEC SQL                                                  
REARCH           CLOSE C4                                               
REARCH        END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH        MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE    
REARCH        IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
REARCH            CONTINUE                                              
REARCH        ELSE                                                      
REARCH            MOVE '5200A'              TO ACTIVE-PARAGRAPH         
REARCH            MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
REARCH            MOVE 'CLOSE'              TO ABEND-FUNCTION           
PRJ481            MOVE 'CSR04422'           TO TABLE-1                  
REARCH            MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1          
REARCH            MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1        
REARCH            MOVE 'SQLCODE '           TO TABLE-ELEMENT-1          
REARCH            MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-1       
PRJ481            PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT        
REARCH        END-IF                                                    
REARCH      ELSE                                                        
REARCH          MOVE -1                       TO WS-ACTIVE-RETURN-CODE  
REARCH          MOVE '5200A'                  TO ACTIVE-PARAGRAPH       
REARCH          MOVE PROGRAM-NAME             TO ABEND-PROGRAM          
REARCH          MOVE 'DB2SP CALL'             TO ABEND-FUNCTION         
PRJ481          MOVE 'CSR04422'               TO TABLE-1                
REARCH          MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1        
REARCH          MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1      
REARCH          MOVE 'SQLCODE'                TO TABLE-ELEMENT-1        
REARCH          MOVE SQLCODE                  TO HOSTVAR-ELEMENT-1      
PRJ481          PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT          
REARCH      END-IF.                                                     
                                                                        
 T3437 5200A-EXIT.                                                      
 T3437     EXIT.                                                        
                                                                        
 T3437******************************************************************        
 T3437* INTIALIZE THE PARAMETERS THAT ARE BEING SENT TO THE SERVER.    *        
 T3437******************************************************************        
 T3437 5200B-GET-DNPFB-DATA.                                            
 T3437     MOVE '5200B'       TO ACTIVE-PARAGRAPH.                      
 T3437                                                                  
REARCH     MOVE ZEROS TO WS-SERV-ORDER-NO-D                             
REARCH                                                                  
REARCH     EXEC SQL                                                     
REARCH          SELECT TOP(1) ROUND(SERV_ORDER_NO, 0)                          
REARCH                 INTO    :WS-SERV-ORDER-NO-D :IND-08               
REARCH                 FROM CSS_SO_DATA                                 
REARCH                 WHERE ACCOUNT_NO = :WS-SO-ACCOUNT-NO-D           
REARCH                 AND ORDER_TYPE_CD = 'DNPFB'                      
REARCH                 AND ORDER_STATE_CD = 'A'                         
REARCH                                           
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT ROUND(SERV_ORDER_NO, 0)                                  
MFA-TR*                INTO    :WS-SERV-ORDER-NO-D:IND-08                       
MFA-TR*                FROM CSS_SO_DATA                                         
MFA-TR*                WHERE ACCOUNT_NO = :WS-SO-ACCOUNT-NO-D                   
MFA-TR*                AND ORDER_TYPE_CD = 'DNPFB'                              
MFA-TR*                AND ORDER_STATE_CD = 'A'                                 
MFA-TR*                FETCH FIRST 1 ROWS ONLY                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH                                                                  
REARCH     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
REARCH                                                                  
REARCH     IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
C35179                                       OR NOT-FOUND               
REARCH         MOVE 'Y'  TO SW-RESULTS                                  
REARCH         MOVE WS-ACTIVE-RETURN-CODE TO WS-RPC-RC                  
C35980                                      ,WS-DNPFB-RETURN-CD-BD      
REARCH         MOVE WS-SERV-ORDER-NO-D  TO WS-SERV-ORDER-CHAR-BD        
REARCH     ELSE                                                         
REARCH        MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
REARCH        MOVE 'SELECT'               TO ABEND-FUNCTION             
REARCH        MOVE 'CSS_SO_DATA'          TO TABLE-1                    
REARCH        MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
REARCH        MOVE AT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
PRJ481        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
REARCH     END-IF.                                                      
                                                                        
 T3437 5200B-EXIT.                                                      
 T3437     EXIT.                                                        
                                                                        
      ******************************************************************        
      * THIS PROCESS WILL SEND A WORK QUEUE TO THE DISPATCHER TO LET   *        
      * THEM KNOW TO NOT CONTINUE WITH THE DISCONNECT SERVICE ORDER FOR*        
      * THE ACCOUNT SINCE A PAYMENT HAS BEEN MADE TO STOP THE SO.      *        
      ******************************************************************        
       5500-SEND-WQ-TO-DISPATCHER.                                      
           MOVE '5500'                TO ACTIVE-PARAGRAPH.              
                                                                        
ACT067     INITIALIZE CWS00077-FIELDS.                                  
ACT067     MOVE '1'                   TO WS-77-ROUTE-CATEGORY.          
ACT067     MOVE AT-LOCAL-OFFICE       TO WS-77-LOCAL-OFFICE.            
ACT067     MOVE 'BATCH'               TO WS-77-USER-ID-ORIG.            
ACT067     MOVE SPACES                TO WS-77-USER-ID-ASGN.            
ACT067     MOVE WS-RESP-AREA-ID-BD    TO WS-77-RESP-AREA-ID.            
ACT067     MOVE 31                    TO WS-77-CATEGORY-ID.             
ACT067     MOVE AT-ACCOUNT-NO         TO WS-77-ACCOUNT-NO.              
ACT067     MOVE AT-PREMISE-NO         TO WS-77-PREMISE-NO.              
ACT067     MOVE AT-CUSTOMER-NO        TO WS-77-CUSTOMER-NO.             
ACT067     MOVE WS-SERV-ORDER-CHAR-BD TO WS-77-SERV-ORDER-NO.           
ACT067     MOVE +41                   TO WS-77-COMMENTS-LEN.            
ACT067     MOVE WS-WQ-COMMENTS-MSG TO WS-77-COMMENTS-TEXT.              
C34176*                                                                         
C34176     IF  XK-SO-UPDT-ACTION-FL = 'N'                               
C34176         MOVE WS-WQ-N-COMMENTS-MSG                                
ACT067                                TO WS-77-COMMENTS-TEXT            
ACT067         MOVE +80               TO WS-77-COMMENTS-LEN             
C34176     END-IF                                                       
C34176*                                                                         
ACT067     MOVE WS-H                  TO WS-77-PRIORITY.                
ACT067     MOVE +20                   TO WS-77-FREE-FORM-LEN.           
ACT067     MOVE 'DISCONNECT CANCELLED' TO WS-77-FREE-FORM-TXT.          
ACT067     MOVE PROGRAM-NAME           TO WS-77-CREATED-BY.             
ACT067     PERFORM 8200-INSERT-WQ THRU 8200-EXIT.                       
                                                                        
       5500-EXIT.                                                       
           EXIT.                                                        
                                                                        
 T3437******************************************************************        
 T3437* THIS PROCESS WILL SEND A WORK QUEUE TO THE DISPATCHER TO LET   *        
 T3437* THEM KNOW TO NOT CONTINUE WITH THE DISCONNECT SERVICE ORDER FOR*        
 T3437* THE ACCOUNT SINCE A PAYMENT HAS BEEN MADE TO STOP THE SO.      *        
 T3437******************************************************************        
 T3437 5500B-SEND-WQ-DNPFB.                                             
 T3437     MOVE '5500B'                 TO ACTIVE-PARAGRAPH.            
 T3437                                                                  
ACT067     INITIALIZE CWS00077-FIELDS.                                  
ACT067     MOVE '1'                   TO WS-77-ROUTE-CATEGORY.          
ACT067     MOVE AT-LOCAL-OFFICE       TO WS-77-LOCAL-OFFICE.            
ACT067     MOVE 'SYSTEM'              TO WS-77-USER-ID-ORIG.            
ACT067     MOVE SPACES                TO WS-77-RESP-AREA-ID.            
ACT067     MOVE '31'                  TO WS-77-CATEGORY-ID.             
ACT067     MOVE AT-ACCOUNT-NO         TO WS-77-ACCOUNT-NO.              
ACT067     MOVE AT-PREMISE-NO         TO WS-77-PREMISE-NO.              
ACT067     MOVE AT-CUSTOMER-NO        TO WS-77-CUSTOMER-NO.             
ACT067     MOVE ZEROES                TO WS-77-SERV-ORDER-NO.           
ACT067     MOVE +41                   TO WS-77-COMMENTS-LEN.            
ACT067     MOVE WS-WQ-DNPFB-MSG       TO WS-77-COMMENTS-TEXT.           
ACT067     MOVE WS-CURR-TIMESTAMP     TO WS-77-DATE-REQUIRED.           
ACT067     MOVE WS-CURR-TIMESTAMP     TO WS-77-DATE-CREATED.            
ACT067     MOVE 'H'                   TO WS-77-PRIORITY.                
ACT067     MOVE ZEROES                TO WS-77-FREE-FORM-LEN.           
ACT067     MOVE LOW-VALUES            TO WS-77-FREE-FORM-TXT.           
ACT067     MOVE PROGRAM-NAME          TO WS-77-CREATED-BY.              
 T3437                                                                  
ACT067     PERFORM 8200-INSERT-WQ        THRU 8200-EXIT.                
                                                                        
 T3437 5500B-EXIT.                                                      
 T3437     EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
T19293* THIS PROCESS WILL SEND A WORK QUEUE TO THE DISPATCHER TO LET   *        
T19293* THEM KNOW TO NOT CONTINUE WITH THE DISCONNECT SERVICE ORDER FOR*        
T19293* THE ACCOUNT SINCE A PAYMENT HAS BEEN MADE TO STOP THE SO.      *        
T19293******************************************************************        
T19293 5500C-SEND-WQ-DNP-COMPLETE.                                      
T19293     MOVE '5500C'                 TO ACTIVE-PARAGRAPH.            
T19293                                                                  
ACT067     INITIALIZE CWS00077-FIELDS.                                  
ACT067     MOVE '1'                   TO WS-77-ROUTE-CATEGORY.          
ACT067     MOVE AT-LOCAL-OFFICE       TO WS-77-LOCAL-OFFICE.            
ACT067     MOVE 'SYSTEM'              TO WS-77-USER-ID-ORIG.            
ACT067     MOVE SPACES                TO WS-77-RESP-AREA-ID.            
ACT067     MOVE '160'                 TO WS-77-CATEGORY-ID.             
ACT067     MOVE AT-ACCOUNT-NO         TO WS-77-ACCOUNT-NO.              
ACT067     MOVE AT-PREMISE-NO         TO WS-77-PREMISE-NO.              
ACT067     MOVE AT-CUSTOMER-NO        TO WS-77-CUSTOMER-NO.             
T19293     UNSTRING WS-SERV-ORDER-CHAR-BD                               
T19293          DELIMITED BY ALL SPACES                                 
T19293          INTO WS-SERVICE-ORDER-NO                                
T19293     END-UNSTRING                                                 
ACT067     MOVE WS-SERVICE-ORDER-NO   TO WS-77-SERV-ORDER-NO.           
ACT067     MOVE +81                   TO WS-77-COMMENTS-LEN.            
ACT067     MOVE WS-WQ-DNP-COMPLETE    TO WS-77-COMMENTS-TEXT.           
C34176     IF  XK-SO-UPDT-ACTION-FL = 'N'                               
C34176         MOVE WS-N-WQ-DNP-COMPLETE                                
ACT067                                TO WS-77-COMMENTS-TEXT            
ACT067         MOVE +148              TO WS-77-COMMENTS-LEN             
ACT067         MOVE '31'              TO WS-77-CATEGORY-ID              
C34176     END-IF                                                       
ACT067     MOVE WS-CURR-TIMESTAMP     TO WS-77-DATE-REQUIRED.           
ACT067     MOVE WS-CURR-TIMESTAMP     TO WS-77-DATE-CREATED.            
ACT067     MOVE 'H'                   TO WS-77-PRIORITY.                
ACT067     MOVE ZEROES                TO WS-77-FREE-FORM-LEN.           
ACT067     MOVE LOW-VALUES            TO WS-77-FREE-FORM-TXT.           
ACT067     MOVE PROGRAM-NAME          TO WS-77-CREATED-BY.              
T19293                                                                  
ACT067     PERFORM 8200-INSERT-WQ        THRU 8200-EXIT.                
T19293                                                                  
T19293 5500C-EXIT.                                                      
T19293     EXIT.                                                        
T23235******************************************************************        
T23235* THIS PROCESS WILL SEND A WORK QUEUE TO THE DISPATCHER TO LET   *        
T23235* THEM KNOW TO NOT CONTINUE WITH THE DISCONNECT SERVICE ORDER FOR*        
T23235* THE ACCOUNT SINCE A PAYMENT HAS BEEN MADE TO STOP THE SO.      *        
T23235******************************************************************        
T23235 5500D-SEND-WQ-TO-DISPATCHER.                                     
T23235     MOVE '5500D'                TO ACTIVE-PARAGRAPH.             
T23235                                                                  
ACT067     INITIALIZE CWS00077-FIELDS.                                  
ACT067     MOVE '1'                   TO WS-77-ROUTE-CATEGORY.          
ACT067     MOVE AT-LOCAL-OFFICE       TO WS-77-LOCAL-OFFICE.            
ACT067     MOVE 'BATCH'               TO WS-77-USER-ID-ORIG.            
ACT067     MOVE SPACES                TO WS-77-USER-ID-ASGN.            
ACT067     MOVE WS-RESP-AREA-ID-BD    TO WS-77-RESP-AREA-ID.            
ACT067     MOVE 96                    TO WS-77-CATEGORY-ID.             
ACT067     MOVE AT-ACCOUNT-NO         TO WS-77-ACCOUNT-NO.              
ACT067     MOVE AT-PREMISE-NO         TO WS-77-PREMISE-NO.              
ACT067     MOVE AT-CUSTOMER-NO        TO WS-77-CUSTOMER-NO.             
T23235     MOVE WS-SERV-ORDER-CHAR-BD TO WS-77-SERV-ORDER-NO.           
ACT067     MOVE +41                   TO WS-77-COMMENTS-LEN.            
ACT067     MOVE WS-WQ-COMMENTS-MSG1   TO WS-77-COMMENTS-TEXT            
ACT067     MOVE WS-H                  TO WS-77-PRIORITY.                
ACT067     MOVE +20                   TO WS-77-FREE-FORM-LEN.           
ACT067     MOVE 'NOTICE CANCELLED'    TO WS-77-FREE-FORM-TXT.           
ACT067     MOVE PROGRAM-NAME          TO WS-77-CREATED-BY.              
T23235                                                                  
ACT067     PERFORM 8200-INSERT-WQ THRU 8200-EXIT.                       
                                                                        
T23235 5500D-EXIT.                                                      
T23235     EXIT.                                                        
C34176*                                                                         
C34176******************************************************************        
C34176* THIS PROCESS WILL SEND A WORK QUEUE TO THE DISPATCHER TO LET   *        
C34176* THEM KNOW TO MANUALLY CANCEL THE DNP SERVICE ORDER FOR THE ACCT*        
C34176* SINCE A NEW NOTICE IS GENERATED AND THE ORDER IS NOT IN ACTIVE *        
C34176* STATE FOR THIS PROCESS TO CANCEL IT.                           *        
C34176******************************************************************        
C34176 5500N-SEND-WQ-TO-DISPATCHER.                                     
C34176*                                                                         
C34176     MOVE '5500N'                 TO ACTIVE-PARAGRAPH.            
C34176                                                                  
ACT067     MOVE '1'                   TO WS-77-ROUTE-CATEGORY.          
ACT067     MOVE AT-LOCAL-OFFICE       TO WS-77-LOCAL-OFFICE.            
ACT067     MOVE 'SYSTEM'              TO WS-77-USER-ID-ORIG.            
ACT067     MOVE SPACES                TO WS-77-RESP-AREA-ID.            
ACT067     MOVE  31                   TO WS-77-CATEGORY-ID.             
ACT067     MOVE AT-ACCOUNT-NO         TO WS-77-ACCOUNT-NO.              
ACT067     MOVE AT-PREMISE-NO         TO WS-77-PREMISE-NO.              
ACT067     MOVE AT-CUSTOMER-NO        TO WS-77-CUSTOMER-NO.             
C34176     UNSTRING WS-SERV-ORDER-CHAR-BD                               
C34176          DELIMITED BY ALL SPACES                                 
C34176          INTO WS-SERVICE-ORDER-NO                                
C34176     END-UNSTRING                                                 
ACT067     MOVE WS-SERVICE-ORDER-NO   TO WS-77-SERV-ORDER-NO.           
ACT067     MOVE +148                  TO WS-77-COMMENTS-LEN.            
ACT067     MOVE WS-N-WQ-DNP-COMPLETE  TO WS-77-COMMENTS-TEXT.           
ACT067     MOVE WS-CURR-TIMESTAMP     TO WS-77-DATE-REQUIRED.           
ACT067     MOVE WS-CURR-TIMESTAMP     TO WS-77-DATE-CREATED.            
ACT067     MOVE 'H'                   TO WS-77-PRIORITY.                
ACT067     MOVE ZEROES                TO WS-77-FREE-FORM-LEN.           
ACT067     MOVE LOW-VALUES            TO WS-77-FREE-FORM-TXT.           
ACT067     MOVE PROGRAM-NAME          TO WS-77-CREATED-BY.              
C34176                                                                  
ACT067     PERFORM 8200-INSERT-WQ        THRU 8200-EXIT.                
C34176                                                                  
C34176 5500N-EXIT.                                                      
C34176     EXIT.                                                        
                                                                        
      ******************************************************************        
      * DETERMINE THE DNP TYPE.                                        *        
      ******************************************************************        
T12718 5700-GET-DNP-TYPE.                                               
           MOVE '5700' TO ACTIVE-PARAGRAPH.                             
           MOVE AT-ACCOUNT-NO                 TO WS-SO-ACCOUNT-NO-D.    
           MOVE WS-SO-ACCOUNT-NO-D            TO WS-SO-ACCOUNT-NO-I.    
REARCH*                                                                         
REARCH     PERFORM 5700B-OPEN-DNP-TYP-CUR THRU 5700B-EXIT.              
REARCH     PERFORM 5700C-FETCH-DNP-TYP-CUR THRU 5700C-EXIT.             
REARCH     PERFORM 5700D-CLOSE-DNP-TYP-CUR THRU 5700D-EXIT.             
                                                                        
       5700-EXIT.                                                       
           EXIT.                                                        
                                                                        
T23235******************************************************************        
T23235* DETERMINES NOTICE ORDERS.                                      *        
T23235******************************************************************        
REARCH 5700B-OPEN-DNP-TYP-CUR.                                          
REARCH     MOVE '5700B'                    TO ACTIVE-PARAGRAPH.         
REARCH                                                                  
REARCH     EXEC SQL                                                     
REARCH       OPEN DNP_TYP_CUR                                           
REARCH     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH                                                                  
REARCH     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
REARCH     IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
REARCH         CONTINUE                                                 
REARCH     ELSE                                                         
REARCH        MOVE PROGRAM-NAME   TO ABEND-PROGRAM                      
REARCH        MOVE 'OPEN  '       TO ABEND-FUNCTION                     
REARCH        MOVE 'CSS_SO_DATA'   TO TABLE-1                           
PRJ481        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
REARCH     END-IF.                                                      
REARCH                                                                  
REARCH 5700B-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH                                                                  
REARCH******************************************************************        
REARCH*** FETCH THE SO DNP CANCEL CURSOR FOR CSS_SO_DNP_CANCEL.        *        
REARCH******************************************************************        
REARCH 5700C-FETCH-DNP-TYP-CUR.                                         
REARCH     MOVE '5700C'                    TO ACTIVE-PARAGRAPH.         
REARCH                                                                  
REARCH     EXEC SQL                                                     
REARCH       FETCH DNP_TYP_CUR                                          
REARCH        INTO :WS-SERV-ORDER-NO-TEMP :IND-01,                       
REARCH             :WS-SERV-ORDER-STATUS-BD :IND-02,                     
REARCH             :WS-ORDER-REASON-BD-TEMP :IND-03,                     
REARCH             :WS-ORDER-TYPE-CD-BD :IND-04                          
REARCH     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH                                                                  
REARCH     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
REARCH     IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
REARCH                                    OR NOT-FOUND                  
REARCH        MOVE WS-SERV-ORDER-NO-TEMP                                
REARCH                    TO WS-SERV-ORDER-NO-BD-TEMP                   
REARCH     ELSE                                                         
REARCH        MOVE PROGRAM-NAME   TO ABEND-PROGRAM                      
REARCH        MOVE 'FETCH '       TO ABEND-FUNCTION                     
REARCH        MOVE 'CSS_SO_DATA'  TO TABLE-1                            
PRJ481        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
REARCH     END-IF.                                                      
REARCH                                                                  
REARCH 5700C-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH                                                                  
REARCH******************************************************************        
REARCH*** CLOSE THE SO DNP CANCEL CURSOR FOR CSS_SO_DNP_CANCEL.        *        
REARCH******************************************************************        
REARCH 5700D-CLOSE-DNP-TYP-CUR.                                         
REARCH     MOVE '5700D'                    TO ACTIVE-PARAGRAPH.         
REARCH                                                                  
REARCH     EXEC SQL                                                     
REARCH       CLOSE DNP_TYP_CUR                                          
REARCH     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH                                                                  
REARCH     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
REARCH     IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
REARCH        CONTINUE                                                  
REARCH     ELSE                                                         
REARCH        MOVE PROGRAM-NAME   TO ABEND-PROGRAM                      
REARCH        MOVE 'CLOSE '       TO ABEND-FUNCTION                     
REARCH        MOVE 'CSS_SO_DATA'   TO TABLE-1                           
PRJ481        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
REARCH     END-IF.                                                      
REARCH                                                                  
REARCH 5700D-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH                                                                  
      ******************************************************************        
      *                                                                *        
      * GET THE CURRENT TIMESTAMP BY USING THE DB2 TABLE CSS_MODEL_SQL.*        
      *                                                                *        
      ******************************************************************        
       7000-GET-CURRENT-TIMESTAMP.                                      
           MOVE '7000'        TO ACTIVE-PARAGRAPH.                      
                                                                        
           EXEC SQL                                                     
PCR360         SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURR-TIMESTAMP               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURR-TIMESTAMP = CURRENT TIMESTAMP                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME   TO ABEND-PROGRAM                      
CBSI          MOVE 'SET'          TO ABEND-FUNCTION                     
PRJ481        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * GET ACCOUNT DETAILS THAT WILL BE REQUIRED TO CANCEL THE SERVICE*        
      * ORDER  AND SEND A WORK QUEUE.                                  *        
      *                                                                *        
      ******************************************************************        
       7200-SELECT-ACCOUNT.                                             
           MOVE '7200'                    TO ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
                SELECT CUSTOMER_NO           ,                          
                       PREMISE_NO            ,                          
                       LOCAL_OFFICE          ,                          
                       CODES_DATA_PRESENT    ,                          
                       CODE_ACCT_STAT        ,                          
                       COMPANY_NO            ,                          
T31477                 DATE_BILL_DAY_00                                 
                  INTO :AT-CUSTOMER-NO       ,                          
                       :AT-PREMISE-NO        ,                          
                       :AT-LOCAL-OFFICE      ,                          
                       :AT-CODES-DATA-PRESENT,                          
                       :AT-CODE-ACCT-STAT    ,                          
                       :AT-COMPANY-NO        ,                          
T31477                 :AT-DATE-BILL-DAY-00                             
                  FROM CSS_ACCOUNT                                      
                 WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE 'CSS_ACCOUNT'          TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE AT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
PRJ481        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * GET CREDIT PROFILE DETAILS THAT WILL BE REQUIRED TO UPDATE     *        
      * HISTORY FIELDS                                                 *        
      *                                                                *        
      ******************************************************************        
       7210-SELECT-CREDIT-PROFILE.                                      
           MOVE '7210'                    TO ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
                SELECT DISCONNECT_HIST       ,                          
                       DISC_EXCEPTN_HIST                                
                  INTO :CZ-DISCONNECT-HIST   ,                          
                       :CZ-DISC-EXCEPTN-HIST                            
                  FROM CSS_CREDIT_PROFILE                               
                 WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE 'CSS_CREDIT_PROFILE'   TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE CZ-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
PRJ481        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      ***  OPEN THE SO DNP CANCEL CURSOR FOR CSS_SO_DNP_CANCEL.        *        
      ******************************************************************        
       7300-OPEN-SO-DNP-CANCEL.                                         
           MOVE '7300'                    TO ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
             OPEN DNP_CANCEL_CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME   TO ABEND-PROGRAM                      
              MOVE 'OPEN  '       TO ABEND-FUNCTION                     
              MOVE 'CSS_SO_DNP_CANCEL'   TO TABLE-1                     
PRJ481        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *** FETCH THE SO DNP CANCEL CURSOR FOR CSS_SO_DNP_CANCEL.        *        
      ******************************************************************        
       7320-FETCH-SO-DNP-CANCEL.                                        
           MOVE '7320'                    TO ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
             FETCH DNP_CANCEL_CUR                                       
              INTO :XK-ACCOUNT-NO,                                      
 T3437             :XK-SO-UPDT-ACTION-FL                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
                                          OR NOT-FOUND                  
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME   TO ABEND-PROGRAM                      
              MOVE 'FETCH '       TO ABEND-FUNCTION                     
              MOVE 'CSS_SO_DNP_CANCEL'   TO TABLE-1                     
PRJ481        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *** CLOSE THE SO DNP CANCEL CURSOR FOR CSS_SO_DNP_CANCEL.        *        
      ******************************************************************        
       7340-CLOSE-SO-DNP-CANCEL.                                        
           MOVE '7340'                    TO ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
             CLOSE DNP_CANCEL_CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME   TO ABEND-PROGRAM                      
              MOVE 'CLOSE '       TO ABEND-FUNCTION                     
              MOVE 'CSS_SO_DNP_CANCEL'   TO TABLE-1                     
              MOVE 'ACCOUNT_NO   '       TO TABLE-ELEMENT-1             
              MOVE XK-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
PRJ481        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7340-EXIT.                                                       
           EXIT.                                                        
C28616* new cursor routines for 'T' parm entries.                               
C28616* 7350 - 7370 paragraphs                                                  
      ******************************************************************        
      ***  OPEN THE DNP-BMX-CUR FOR CSS_SO_DNP_CANCEL TABLE                     
      ******************************************************************        
       7350-OPEN-DNP-BMX-CURSOR.                                        
           MOVE '7350'                    TO ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
             OPEN DNP_BMX_CUR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME   TO ABEND-PROGRAM                      
              MOVE 'OPEN  '       TO ABEND-FUNCTION                     
              MOVE 'CSS_SO_DNP_CANCEL'   TO TABLE-1                     
PRJ481        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *** FETCH THE DNP-BMX-CUR CURSOR FOR CSS_SO_DNP_CANCEL.        *          
      ******************************************************************        
       7360-FETCH-DNP-BMX-CUR.                                          
           MOVE '7360'                    TO ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
             FETCH DNP_BMX_CUR                                          
              INTO :XK-ACCOUNT-NO,                                      
                   :XK-SO-UPDT-ACTION-FL                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
                                          OR NOT-FOUND                  
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME   TO ABEND-PROGRAM                      
              MOVE 'FETCH '       TO ABEND-FUNCTION                     
              MOVE 'CSS_SO_DNP_CANCEL'   TO TABLE-1                     
PRJ481        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7360-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *** CLOSE THE SO DNP CANCEL CURSOR FOR CSS_SO_DNP_CANCEL.        *        
      ******************************************************************        
       7370-CLOSE-DNP-BMX-CUR.                                          
           MOVE '7370'                    TO ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
             CLOSE DNP_BMX_CUR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME   TO ABEND-PROGRAM                      
              MOVE 'CLOSE '       TO ABEND-FUNCTION                     
              MOVE 'CSS_SO_DNP_CANCEL'   TO TABLE-1                     
              MOVE 'ACCOUNT_NO   '       TO TABLE-ELEMENT-1             
              MOVE XK-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
PRJ481        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
C28616 7370-EXIT.                                                       
C28616     EXIT.                                                        
C28616* end of new cursor routines.                                             
C28616*                                                                         
T31477******************************************************************        
T31477***  OPEN THE SEB B DNP CANCEL CURSOR FOR CSS_SO_DNP_CANCEL.     *        
T31477******************************************************************        
T31477 7400-OPEN-SEBB-DNP-CANCEL.                                       
T31477*                                                                         
T31477     MOVE '7400' TO ACTIVE-PARAGRAPH.                             
T31477                                                                  
T31477     EXEC SQL                                                     
T31477       OPEN DNP_CANCEL_SEBB                                       
T31477     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T31477                                                                  
T31477     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T31477                                                                  
T31477     IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
T31477        NEXT SENTENCE                                             
T31477     ELSE                                                         
T31477        MOVE PROGRAM-NAME   TO ABEND-PROGRAM                      
T31477        MOVE 'OPEN  '       TO ABEND-FUNCTION                     
T31477        MOVE 'CSS_SO_DNP_CANCEL'   TO TABLE-1                     
PRJ481        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
T31477     END-IF.                                                      
T31477                                                                  
T31477 7400-EXIT.                                                       
T31477     EXIT.                                                        
T31477*                                                                         
T31477******************************************************************        
T31477*                                                                *        
T31477* THIS PARAGRAPH CONTROLS THE FETCH OF THE SEB B DNP CANCEL DB2  *        
T31477* TABLE AND THEN CALLS ROUTINES TO CHECK THE CSS_DELINQUENCY     *        
T31477* TABLE AND STOP THE DISCONNECT.                                 *        
T31477*                                                                *        
T31477******************************************************************        
T31477 7410-LOOP-SEBB-DNPS.                                             
T31477*                                                                         
T31477     MOVE '7410' TO ACTIVE-PARAGRAPH.                             
T31477*                                                                         
T31477     PERFORM 7420-FETCH-SEBB-DNP-CANCEL THRU 7420-EXIT.           
T31477     IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
T31477        MOVE XK-ACCOUNT-NO TO AT-ACCOUNT-NO                       
T31477                              CZ-ACCOUNT-NO                       
T31477        PERFORM 7200-SELECT-ACCOUNT THRU 7200-EXIT                
T31477                                                                  
T31477        IF WS-RELEASE-DATE >= AT-DATE-BILL-DAY-00                 
T31477           ADD 1 TO WS-NO-OF-SO-PROCESSED                         
C35179           ADD 1 TO WS-NO-ACCTS-PROCESSED                         
T31477           PERFORM 1200-PROCESS-EACH-ACCOUNT THRU 1200-EXIT       
C35179           PERFORM 9600-COMMIT-WORK          THRU 9600-EXIT       
T31477        END-IF                                                    
T31477     ELSE                                                         
T31477        MOVE WS-Y TO WS-NO-MORE-DNPS-SW                           
T31477     END-IF.                                                      
T31477                                                                  
T31477 7410-EXIT.                                                       
T31477     EXIT.                                                        
T31477*                                                                         
t31477******************************************************************        
t31477*** FETCH THE SEB B DNP CANCEL CURSOR FOR CSS_SO_DNP_CANCEL.     *        
T31477******************************************************************        
T31477 7420-FETCH-SEBB-DNP-CANCEL.                                      
T31477*                                                                         
T31477     MOVE '7420' TO ACTIVE-PARAGRAPH.                             
T31477                                                                  
T31477     EXEC SQL                                                     
T31477       FETCH DNP_CANCEL_SEBB                                      
T31477        INTO :XK-ACCOUNT-NO,                                      
T31477             :XK-SO-UPDT-ACTION-FL                                
T31477     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T31477                                                                  
T31477     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T31477                                                                  
T31477     IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
T31477     OR WS-ACTIVE-RETURN-CODE EQUAL TO NOT-FOUND                  
T31477        NEXT SENTENCE                                             
T31477     ELSE                                                         
T31477        MOVE PROGRAM-NAME   TO ABEND-PROGRAM                      
T31477        MOVE 'FETCH '       TO ABEND-FUNCTION                     
T31477        MOVE 'CSS_SO_DNP_CANCEL'   TO TABLE-1                     
PRJ481        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
T31477     END-IF.                                                      
T31477                                                                  
T31477 7420-EXIT.                                                       
T31477     EXIT.                                                        
T31477*                                                                         
T31477******************************************************************        
T31477*** CLOSE THE SEB B DNP CANCEL CURSOR FOR CSS_SO_DNP_CANCEL.     *        
T31477******************************************************************        
T31477 7430-CLOSE-SEBB-DNP-CANCEL.                                      
T31477*                                                                         
T31477     MOVE '7430' TO ACTIVE-PARAGRAPH.                             
T31477                                                                  
T31477     EXEC SQL                                                     
T31477       CLOSE DNP_CANCEL_SEBB                                      
T31477     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T31477                                                                  
T31477     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T31477                                                                  
T31477     IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
T31477         NEXT SENTENCE                                            
T31477     ELSE                                                         
T31477        MOVE PROGRAM-NAME   TO ABEND-PROGRAM                      
T31477        MOVE 'CLOSE '       TO ABEND-FUNCTION                     
T31477        MOVE 'CSS_SO_DNP_CANCEL'   TO TABLE-1                     
T31477        MOVE 'ACCOUNT_NO   '       TO TABLE-ELEMENT-1             
T31477        MOVE XK-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
PRJ481        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
T31477     END-IF.                                                      
T31477                                                                  
T31477 7430-EXIT.                                                       
T31477     EXIT.                                                        
T31477*                                                                         
T31477******************************************************************        
T31477*                                                                *        
T31477* GET THE PREVIOUS BUSINESS DATE.                                *        
T31477*                                                                *        
T31477******************************************************************        
T31477*                                                                         
T31477 7450-GET-PREV-BUSINESS-DATE.                                     
T31477*                                                                         
T31477     MOVE '7450' TO ACTIVE-PARAGRAPH.                             
T31477                                                                  
T31477     EXEC SQL                                                     
T31477        SELECT DATEADD( DAY, -:WS-ADJ-DAY, IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )          
T31477          INTO :WS-RELEASE-DATE                                   
T31477          FROM CSS_MODEL_SQL                                      
T31477         WHERE CIS.DAYS(DATEADD( DAY, -:WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )) -                      
T31477      (CIS.DAYS(DATEADD( DAY, -:WS-ADJ-DAY, IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )
               )) / 7 * 7) BETWEEN 1 AND 5    
T31477           AND NOT EXISTS                                         
T31477                  (SELECT HOLIDAY_DT                              
T31477                     FROM CSS_HOLIDAY                             
T31477                    WHERE HOLIDAY_DT =                            
T31477                          DATEADD( DAY, -:WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) ))                  
T31477     END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DATE(:WS-CURRENT-DATE) - :WS-ADJ-DAY DAYS                  
MFA-TR*         INTO :WS-RELEASE-DATE                                           
MFA-TR*         FROM CSS_MODEL_SQL                                              
MFA-TR*        WHERE DAYS(DATE(:WS-CURRENT-DATE)                                
MFA-TR*                      - :WS-ADJ-DAY DAYS) -                              
MFA-TR*     (INTEGER(DAYS(DATE(:WS-CURRENT-DATE)                                
MFA-TR*                - :WS-ADJ-DAY DAYS) / 7) * 7) BETWEEN 1 AND 5            
MFA-TR*          AND NOT EXISTS                                                 
MFA-TR*                 (SELECT HOLIDAY_DT                                      
MFA-TR*                    FROM CSS_HOLIDAY                                     
MFA-TR*                   WHERE HOLIDAY_DT =                                    
MFA-TR*                         DATE(:WS-CURRENT-DATE) -                        
MFA-TR*                              :WS-ADJ-DAY DAYS)                          
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
T31477*                                                                         
T31477 7450-EXIT.                                                       
T31477     EXIT.                                                        
T31477*                                                                         
T31477******************************************************************        
T31477***  OPEN THE SEB P DNP CANCEL CURSOR FOR CSS_SO_DNP_CANCEL.     *        
T31477******************************************************************        
T31477 7500-OPEN-SEBP-DNP-CANCEL.                                       
T31477*                                                                         
T31477     MOVE '7500' TO ACTIVE-PARAGRAPH.                             
T31477                                                                  
T31477     EXEC SQL                                                     
T31477       OPEN DNP_CANCEL_SEBP                                       
T31477     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T31477                                                                  
T31477     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T31477                                                                  
T31477     IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
T31477        NEXT SENTENCE                                             
T31477     ELSE                                                         
T31477        MOVE PROGRAM-NAME   TO ABEND-PROGRAM                      
T31477        MOVE 'OPEN  '       TO ABEND-FUNCTION                     
T31477        MOVE 'CSS_SO_DNP_CANCEL'   TO TABLE-1                     
PRJ481        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
T31477     END-IF.                                                      
T31477                                                                  
T31477 7500-EXIT.                                                       
T31477     EXIT.                                                        
T31477*                                                                         
T31477******************************************************************        
T31477*                                                                *        
T31477* THIS PARAGRAPH CONTROLS THE FETCH OF THE SEB P DNP CANCEL DB2  *        
T31477* TABLE AND THEN CALLS ROUTINES TO CHECK THE CSS_DELINQUENCY     *        
T31477* TABLE AND STOP THE DISCONNECT.                                 *        
T31477*                                                                *        
T31477******************************************************************        
T31477 7510-LOOP-SEBP-DNPS.                                             
T31477*                                                                         
T31477     MOVE '7510' TO ACTIVE-PARAGRAPH.                             
T31477*                                                                         
T31477     PERFORM 7520-FETCH-SEBP-DNP-CANCEL THRU 7520-EXIT.           
T31477     IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
T31477        ADD 1 TO WS-NO-OF-SO-PROCESSED                            
C35179        ADD 1 TO WS-NO-ACCTS-PROCESSED                            
T31477        PERFORM 1200-PROCESS-EACH-ACCOUNT THRU 1200-EXIT          
C35179        PERFORM 9600-COMMIT-WORK          THRU 9600-EXIT          
T31477     ELSE                                                         
T31477        MOVE WS-Y TO WS-NO-MORE-DNPS-SW                           
T31477     END-IF.                                                      
T31477                                                                  
T31477 7510-EXIT.                                                       
T31477     EXIT.                                                        
T31477*                                                                         
t31477******************************************************************        
t31477*** FETCH THE SEB P DNP CANCEL CURSOR FOR CSS_SO_DNP_CANCEL.     *        
T31477******************************************************************        
T31477 7520-FETCH-SEBP-DNP-CANCEL.                                      
T31477*                                                                         
T31477     MOVE '7520' TO ACTIVE-PARAGRAPH.                             
T31477                                                                  
T31477     EXEC SQL                                                     
T31477       FETCH DNP_CANCEL_SEBP                                      
T31477        INTO :XK-ACCOUNT-NO,                                      
T31477             :XK-SO-UPDT-ACTION-FL                                
T31477     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T31477                                                                  
T31477     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T31477                                                                  
T31477     IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
T31477     OR WS-ACTIVE-RETURN-CODE EQUAL TO NOT-FOUND                  
T31477        NEXT SENTENCE                                             
T31477     ELSE                                                         
T31477        MOVE PROGRAM-NAME   TO ABEND-PROGRAM                      
T31477        MOVE 'FETCH '       TO ABEND-FUNCTION                     
T31477        MOVE 'CSS_SO_DNP_CANCEL'   TO TABLE-1                     
PRJ481        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
T31477     END-IF.                                                      
T31477                                                                  
T31477 7520-EXIT.                                                       
T31477     EXIT.                                                        
T31477*                                                                         
T31477******************************************************************        
T31477*** CLOSE THE SEB P DNP CANCEL CURSOR FOR CSS_SO_DNP_CANCEL.     *        
T31477******************************************************************        
T31477 7530-CLOSE-SEBP-DNP-CANCEL.                                      
T31477*                                                                         
T31477     MOVE '7530' TO ACTIVE-PARAGRAPH.                             
T31477                                                                  
T31477     EXEC SQL                                                     
T31477       CLOSE DNP_CANCEL_SEBP                                      
T31477     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T31477                                                                  
T31477     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T31477                                                                  
T31477     IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
T31477         NEXT SENTENCE                                            
T31477     ELSE                                                         
T31477        MOVE PROGRAM-NAME   TO ABEND-PROGRAM                      
T31477        MOVE 'CLOSE '       TO ABEND-FUNCTION                     
T31477        MOVE 'CSS_SO_DNP_CANCEL'   TO TABLE-1                     
T31477        MOVE 'ACCOUNT_NO   '       TO TABLE-ELEMENT-1             
T31477        MOVE XK-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
PRJ481        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
T31477     END-IF.                                                      
T31477                                                                  
T31477 7530-EXIT.                                                       
T31477     EXIT.                                                        
C35179*                                                                         
C35179*************************************************************             
C35179* 7600-GET-JOB-PARM                                       ***             
C35179*************************************************************             
C35179 7600-GET-JOB-PARM.                                               
C35179                                                                  
C35179     MOVE '7600'                   TO ACTIVE-PARAGRAPH.           
C35179     EXEC SQL                                                     
C35179         SELECT PARM_DATA                                         
C35179           INTO :G6-PARM-DATA                                     
C35179           FROM CSS_JOB_PARM                                      
C35179          WHERE PROGRAM_NAME = :PROGRAM-NAME                      
C35179            AND COMPANY_NO   = '01'                               
C35179            AND CMND_CODE    = 'PARM'                             
C35179            AND STATUS = 'A'                                      
C35179     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C35179                                                                  
C35179     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
C35179     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C35179        MOVE G6-PARM-DATA          TO WS-COMMIT-DATA              
C35179        IF WS-COMMIT-CNT  NUMERIC                                 
C35179           MOVE WS-COMMIT-CNT      TO  WS-CHKP-LUW-LIMIT          
C35179        ELSE                                                      
PRJ481           MOVE -1                 TO S-RETURN-CODE               
C35179           MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
C35179           MOVE 'SELECT'           TO ABEND-FUNCTION              
C35179           MOVE 'CSS_JOB_PARM'     TO TABLE-1                     
C35179           MOVE 'COMMIT CNT '      TO TABLE-ELEMENT-1             
C35179           MOVE 'NOT NUMERIC'      TO HOSTVAR-ELEMENT-1           
PRJ481           PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT         
C35179        END-IF                                                    
C35179     ELSE                                                         
C35179         IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
C35179            DISPLAY '*** COMMIT PARM NOT PRESENT'                 
C35179            DISPLAY '*** DEFAULT COUNT IS USED'                   
C35179            MOVE WS-DEFAULT-CHKP-LUW-LIMIT TO WS-CHKP-LUW-LIMIT   
C35179         ELSE                                                     
C35179            MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
C35179            MOVE 'SELECT'              TO ABEND-FUNCTION          
C35179            MOVE 'CSS_JOB_PARM'        TO TABLE-1                 
PRJ481            PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT        
C35179         END-IF                                                   
C35179     END-IF.                                                      
C35179*                                                                         
C35179 7600-EXIT.                                                       
C35179     EXIT.                                                        
C35179*                                                                         
      ******************************************************************        
      *                                                                *        
      * IF SYBASE WAS UPDATED SUCCESSFULLY, REMOVE THE SO DNP CANCEL   *        
      * RECORD FROM CSS_SO_DNP_CANCEL.                                 *        
      *                                                                *        
      ******************************************************************        
       8000-DELETE-SO-DNP.                                              
           MOVE '8000'        TO ACTIVE-PARAGRAPH.                      
                                                                        
           EXEC SQL                                                     
                DELETE FROM CSS_SO_DNP_CANCEL                           
                WHERE ACCOUNT_NO = :XK-ACCOUNT-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
C35980     IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL OR         
C35980                                       NOT-FOUND                  
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME   TO ABEND-PROGRAM                      
              MOVE 'DELETE'       TO ABEND-FUNCTION                     
              MOVE 'CSS_SO_DNP_CANCEL'   TO TABLE-1                     
              MOVE 'ACCOUNT_NO   '       TO TABLE-ELEMENT-1             
              MOVE XK-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
PRJ481        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * IF THE SERVICE ORDER WAS CANCELED THEN UPDATE CSS_ACCOUNT'S    *        
      * CODES-DATA-PRESENT FIELD WS-CODE-PENDING-DNP TO SPACE.         *        
      *                                                                *        
      ******************************************************************        
       8050-UPDATE-ACCOUNT.                                             
           MOVE '8050'                    TO ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
                UPDATE CSS_ACCOUNT                                      
                   SET CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT,     
PCR360                 LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()           
                 WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_ACCOUNT                                              
MFA-TR*            SET CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT,             
MFA-TR*                LAST_UPDATE_TS     = CURRENT TIMESTAMP                   
MFA-TR*          WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE 'UPDATE'               TO ABEND-FUNCTION             
              MOVE 'CSS_ACCOUNT'          TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE AT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
CBSI          MOVE 'CODES_DATA_PRESENT'   TO TABLE-ELEMENT-2            
CBSI          MOVE AT-CODES-DATA-PRESENT  TO HOSTVAR-ELEMENT-2          
PRJ481        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * IF THE SERVICE ORDER WAS CANCELED THEN UPDATE CSS_CREDIT_PROFILE        
      * DISCONNECT HISTORY CODE WITH RESOLVED.                         *        
      *                                                                *        
      ******************************************************************        
       8060-UPDATE-CREDIT-PROFILE.                                      
           MOVE '8060'                    TO ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
                UPDATE CSS_CREDIT_PROFILE                               
                   SET DISCONNECT_HIST    = :CZ-DISCONNECT-HIST,        
PCR360                 DISC_EXCEPTN_HIST  = :CZ-DISC-EXCEPTN-HIST,      
PCR360                 LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()           
                 WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_CREDIT_PROFILE                                       
MFA-TR*            SET DISCONNECT_HIST    = :CZ-DISCONNECT-HIST,                
MFA-TR*                DISC_EXCEPTN_HIST  = :CZ-DISC-EXCEPTN-HIST,              
MFA-TR*                LAST_UPDATE_TS     = CURRENT TIMESTAMP                   
MFA-TR*          WHERE ACCOUNT_NO         = :AT-ACCOUNT-NO                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE 'UPDATE'               TO ABEND-FUNCTION             
              MOVE 'CSS_CREDIT_PROFILE'   TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE CZ-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
CBSI          MOVE 'DISCONNECT_HIST'      TO TABLE-ELEMENT-2            
CBSI          MOVE CZ-DISCONNECT-HIST     TO HOSTVAR-ELEMENT-2          
CBSI          MOVE 'DISC_EXCEPTN_HIST'    TO TABLE-ELEMENT-3            
CBSI          MOVE CZ-DISC-EXCEPTN-HIST   TO HOSTVAR-ELEMENT-3          
PRJ481        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8060-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * IF THE SERVICE ORDER WAS CANCELED THEN UPDATE CSS_PREMISE'S    *        
      * SERVICE ORDER PENDING INDICATOR                                *        
      *                                                                *        
      ******************************************************************        
       8070-UPDATE-PREMISE.                                             
           MOVE '8070'                    TO ACTIVE-PARAGRAPH.          
                                                                        
           EXEC SQL                                                     
                UPDATE CSS_PREMISE                                      
                   SET SERV_ORDER_PEND    = :PR-SERV-ORDER-PEND         
                 WHERE PREMISE_NO         = :PR-PREMISE-NO              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE 'UPDATE'               TO ABEND-FUNCTION             
              MOVE 'CSS_PREMISE'          TO TABLE-1                    
              MOVE 'PREMISE_NO'           TO TABLE-ELEMENT-1            
              MOVE PR-PREMISE-NO          TO HOSTVAR-ELEMENT-1          
CBSI          MOVE 'SERV_ORDER_PEND'      TO TABLE-ELEMENT-2            
CBSI          MOVE PR-SERV-ORDER-PEND     TO HOSTVAR-ELEMENT-2          
PRJ481        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8070-EXIT.                                                       
           EXIT.                                                        
                                                                        
 T3437******************************************************************        
 T3437**  THIS PARAGRAPH IS USED TO INSERT A ROW IN THE               **        
ACT067**  CSS_WQ_ITEMS      TABLE.                                    **        
 T3437******************************************************************        
ACT067 8200-INSERT-WQ.                                                  
                                                                        
 T3437     MOVE '8200'               TO ACTIVE-PARAGRAPH.               
                                                                        
ACT067     MOVE ZERO                        TO WS-77-ITEM-ID.           
                                                                        
A01757     IF WS-SERV-ORDER-NO-TEMP NUMERIC                             
ACT077        MOVE WS-SERV-ORDER-NO-TEMP    TO WS-77-SERV-ORDER-NO      
A01757     END-IF.                                                      
                                                                        
ACT067     INITIALIZE   WS-MCSCB077-OUTPUT.                             
ACT067     INITIALIZE   ABEND-FUNCTION.                                 
                                                                        
ACT067     CALL MCSCB077 USING CWS00077-FIELDS,                         
ACT067                         ABEND-FILE,                              
ACT067                         WS-MCSCB077-RET-CODE.                    
                                                                        
ACT067     MOVE WS-MCSCB077-RET-CODE     TO WS-ACTIVE-RETURN-CODE       
ACT067                                                                  
ACT067     IF ABEND-FUNCTION > SPACES OR WS-MCSCB077-RET-CODE NOT = 0   
ACT067        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
ACT067        MOVE '8200'                TO ACTIVE-PARAGRAPH            
ACT067        MOVE 'CALL'                TO ABEND-FUNCTION              
ACT067        MOVE 'MCSCB077'            TO TABLE-1                     
ACT067        MOVE 'CUSTOMER NO'         TO TABLE-ELEMENT-1             
ACT067        MOVE WS-77-CUSTOMER-NO     TO HOSTVAR-ELEMENT-1           
ACT067        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
ACT067     END-IF.                                                      
 T3437                                                                  
 T3437 8200-EXIT.                                                       
 T3437     EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 9600-COMMIT-WORK                                               *        
      *                                                                *        
      ******************************************************************        
       9600-COMMIT-WORK.                                                
           MOVE '9600'                    TO ACTIVE-PARAGRAPH.          
C35179     IF WS-NO-ACCTS-PROCESSED >= WS-CHKP-LUW-LIMIT                
C35179        ADD 1                       TO WS-COMMIT-NO-TAKEN         
C35179        EXEC SQL                                                  
C35179            COMMIT                                                
C35179        END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C35179        DISPLAY 'COMMIT POINT TAKEN : ' WS-COMMIT-NO-TAKEN        
C35179        MOVE 0                      TO WS-NO-ACCTS-PROCESSED      
C35179     END-IF.                                                      
                                                                        
       9600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALLING/ ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
REARCH     EXEC SQL                                                     26750000
REARCH        INCLUDE CPDSP300                                          26760000
REARCH     END-EXEC.                                                    26770000
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
REARCH     EXEC SQL                                                     00000100
REARCH         INCLUDE CPD00321                                         00000200
REARCH     END-EXEC.                                                    00000300
C35179     EXEC SQL                                                             
C35179         INCLUDE CPD0023C                                                 
C35179     END-EXEC.                                                            
C35179                                                                  
