       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02331.                                         
COB303 DATE-WRITTEN.  MARCH    05, 1996                                 
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S331 CONVERTED TO DB2 SP CSR02331 ON 12/14/2006        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
      *                                                                *00110000
      *  TRANID:        S331                                           *00120000
      *  PROGRAM:       S331                                           *00130000
      *  BUSOP:         REQUGETCASHIEROPENDRAWERBUSINESSOP             *00140000
      *                                                                *00150000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *  THIS PROGRAM RETRIEVES CASH REPORT DATES AND PAYMENT FACILITY *00190000
      *  CODES FOR A USER ID AND CASHIER CODE AND CASH DRAWER STATUS.  *00200000
      *                                                                *00212000
      ******************************************************************00220000
      *                                                                *00230000
      *                     PROGRAM MODIFICATION LOG                   *00240000
      *                                                                *00250000
      *    DATE    INITIALS   COMMENTS                                 *00260000
      *  --------  --------   ---------------------------------------  *00270000
      *   03/05/96    RTO     PROCEDURE ORIGINALLY CODED.              *00280000
T16086*   04/24/98    VB      TABLE ELEMENT NAMES ARE LOADED WHEN      *00340000
      *                       WRITING INTO MCO5 ERROR LOG.             *00350000
      *   10/05/99    RTO     CHANGED TO BRING BACK ALL FIELDS         *00280000
      *                       FROM CSS_CSH_DRWR_CNTL.                  *00280000
T21423*   01/31/99    ZB17046 MADE CHANGE TO PASS CASHIER CODE.  SINCE *        
T21423*                       THIS WAS NOT BEING DONE PAYMENTS WERE    *        
T21423*                       BEING POSTED EVEN THOUGH ANOTHER USER'S  *        
T21423*                       CASHIER CODE WAS ENTERED.                *        
T21423*                       AFTER THIS CHANGE THE 'INVALID CASHIER   *        
T21423*                       CODE' MESSAGE SHOULD START DISPLAYING.   *        
T21423*   02/21/00    PD      GET  COMPANY NO FROM CSS_USER_PROFILE    *        
T21423*                       FOR NON CASHIERING USERS.                *        
      *   03/04/00    PD      REMOVE ALL THE REFERENCES TO IDMS.       *        
T23748*   05/21/00    WR      MCR310-CML 23748 PSNC CHANGES.                    
T35842*   04/25/08    LAT     ADDED NEW FIELDS -CHECK21 AND CREDIT_CARD*        
T35842*                       FLAGS TO THE RESULT SET.                 *        
T35842*                       PERFORMANCE CHANGES.                     *        
P00586*   10/08/12    LAT     CHANGES TO ADD DECIMAL VALUES AND RETURN *        
P00586*                       COLUMN NAME FOR DATE_CASH_REPORT.        *        
P00586*                       ADD CASHIER-NAME AND BUS-RULES TO THE    *        
P00586*                       RESULT-SET.                              *        
P00586*   06/17/2013  AP40911 PC-ID FIELD LENGTH INCREASED.            *        
P00586*   06/26/2013  AP40911 ADD NEW FIELD- PYMT_FACLTY_RBN_CD TO USE *        
P00586*                       IN MOD TO REPOPULATE THE PATYMENTS RIBBON*        
P00586*                       DEPENDING ON THE CASH LOCAL OFFICE.      *        
      ******************************************************************00300000
      ******************************************************************00310000
      *                                                                *00320000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00330000
      *                                                                *00340000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00350000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00360000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00370000
      *  3000 - 4999  NOT USED                                         *00380000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00390000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00400000
      *  7000 - 7999  INPUT MODULES                                    *00410000
      *  8000 - 8999  OUTPUT MODULES                                   *00420000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00430000
      *                                                                *00440000
      ******************************************************************00450000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02331'.
MSQ017     COPY MFASQLM.
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR RPC S331 STARTS HERE'.                  
                                                                        
      ******************************************************************00540000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00550000
      ******************************************************************00560000
                                                                        
           COPY CWS00027.                                               00620000
           COPY CWS00303.                                               00632000
                                                                        
      ******************************************************************00650000
      *    WORK AREAS                                                  *00660000
      ******************************************************************00670000
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR02331'.     
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
                                                                        
           05  WS-DATE-CASH-REPORT      PIC X(10).                      
           05  WS-DATE-LAST-ACTIVITY    PIC X(10).                      
           05  WS-ACCOUNT-NO            PIC X(13).                      
           05  WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO                
                                        PIC 9(13).                      
COB305     05 WS-ACCOUNT-NO-COMP3        PIC S9(13) COMP-3 VALUE 0.             
                                                                        
           05  WS-NULL-IND1             PIC S9(04) COMP VALUE +0.       
           05  WS-NULL-IND2             PIC S9(04) COMP VALUE +0.       
           05  WS-NULL-IND3             PIC S9(04) COMP VALUE +0.       
       01  WS-LITERAL.                                                  
           05  WS-B                     PIC X(01) VALUE 'B'.            
           05  WS-C                     PIC X(01) VALUE 'C'.            
           05  WS-G                     PIC X(01) VALUE 'G'.            
           05  WS-I                     PIC X(01) VALUE 'I'.            
           05  WS-M                     PIC X(01) VALUE 'M'.            
           05  WS-R                     PIC X(01) VALUE 'R'.            
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE       PIC S9(9) COMP.                 
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                   PIC S9(09) COMP.                
CVT999*    05  PARM-ID1                 PIC S9(09) COMP VALUE 1.        01090000
           05  PARM-IDMS-LOOKUP         PIC  X(01).                     
           05  PARM-USER-ID             PIC  X(07).                     
P00586     05  PARM-CSR-PC-ID           PIC  X(15).                     
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(09) COMP VALUE +0.       
           05  RS-CASH-COMPANY-NO      PIC X(2) VALUE SPACES.           
           05  RS-CASH-LOCAL-OFFICE    PIC X(3) VALUE SPACES.           
           05  RS-CASH-REPORT-NO       PIC X(3) VALUE SPACES.           
           05  RS-DATE-CASH-REPORT     PIC X(10) VALUE SPACES.          
           05  RS-CASH-DRAWER-ID       PIC S9(4) USAGE COMP.            
           05  RS-AMT-CASH-DEBIT       PIC S9(13)V9(2) USAGE COMP-3     
                                                       VALUE +0.        
           05  RS-AMT-CASH-CREDIT      PIC S9(13)V9(2) USAGE COMP-3     
                                                       VALUE +0.        
           05  RS-AMT-AR-DEBIT         PIC S9(13)V9(2) USAGE COMP-3     
                                                       VALUE +0.        
           05  RS-AMT-AR-CREDIT        PIC S9(13)V9(2) USAGE COMP-3     
                                                       VALUE +0.        
           05  RS-AMT-CK-ISS-DEBIT     PIC S9(13)V9(2) USAGE COMP-3     
                                                       VALUE +0.        
           05  RS-AMT-CK-ISS-CREDIT    PIC S9(13)V9(2) USAGE COMP-3     
                                                       VALUE +0.        
           05  RS-AMT-GL-DEBIT         PIC S9(13)V9(2) USAGE COMP-3     
                                                       VALUE +0.        
           05  RS-AMT-GL-CREDIT        PIC S9(13)V9(2) USAGE COMP-3     
                                                       VALUE +0.        
           05  RS-AMT-CASH-BEGIN-BAL   PIC S9(13)V9(2) USAGE COMP-3     
                                                       VALUE +0.        
           05  RS-AMT-BASIC-WORK       PIC S9(13)V9(2) USAGE COMP-3     
                                                       VALUE +0.        
           05  RS-CASHIER-CODE         PIC X(2) VALUE SPACES.           
           05  RS-CODE-PYMT-FACILITY   PIC X(1) VALUE SPACES.           
           05  RS-CODE-FCS-EXTRACTED   PIC X(1) VALUE SPACES.           
           05  RS-DATE-LAST-ACTIVITY   PIC X(10) VALUE SPACES.          
           05  RS-NO-ITEMS-ENTERED     PIC S9(9)   COMP VALUE +0.       
           05  RS-CASHIER-CD-CHG-TS    PIC X(26) VALUE SPACES.          
P353       05  RS-PC-ID-RETURN-CD      PIC S9(09) COMP VALUE +0.        
T35842     05  RS-CREDIT-CARD-FL       PIC X(01) VALUE 'N'.             
T35842     05  RS-CHECK21-FL           PIC X(01) VALUE 'N'.             
P00586     05  RS-CASHIER-FULL-NAME    PIC X(40) VALUE SPACES.          
P00586     05  RS-PYMT-FACLTY-RBN-CD   PIC X(15) VALUE SPACES.          
                                                                        
           EXEC SQL                                                     01550000
              INCLUDE SQLCA                                             01560000
           END-EXEC.                                                    01570000
                                                                        
           EXEC SQL                                                     01590000
              INCLUDE TBCSHIER                                          01600000
           END-EXEC.                                                    01610000
                                                                        
           EXEC SQL                                                     01590000
              INCLUDE TBCSPCID                                          01600000
           END-EXEC.                                                    01610000
                                                                        
           EXEC SQL                                                     01630000
             INCLUDE TBCDCNTL                                           01640000
           END-EXEC.                                                    01650000
                                                                        
           EXEC SQL                                                     01630000
             INCLUDE TBUSRPRF                                           01640000
           END-EXEC.                                                    01650000
                                                                        
T35842*** DCLGEN FOR CSS_CASHIER_OFFICE - Y2                                    
T35842     EXEC SQL                                                             
T35842       INCLUDE TBCSHOFF                                                   
T35842     END-EXEC.                                                            
                                                                        
      ***********************************************************       01670000
      *** CSHDWRCNTL-CURSOR :FETCH ALL ROWS IN CSS_CSH_DRWR_CNTL*       01680000
      *** TABLE WITH THE PASSED USER_ID AND DRAWER STATUS       *       01690000
      ***********************************************************       01700000
           EXEC SQL                                                     
             DECLARE CSHDWRCNTL-CURSOR  CURSOR FOR                      
             SELECT CASH_COMPANY_NO,                                    
                    CASH_LOCAL_OFFICE,                                  
                    CASH_REPORT_NO,                                     
                    DATE_CASH_REPORT,                                   
                    CASH_DRAWER_ID,                                     
                    AMT_CASH_DEBIT,                                     
                    AMT_CASH_CREDIT,                                    
                    AMT_AR_DEBIT,                                       
                    AMT_AR_CREDIT,                                      
                    AMT_CK_ISS_DEBIT,                                   
                    AMT_CK_ISS_CREDIT,                                  
                    AMT_GL_DEBIT,                                       
                    AMT_GL_CREDIT,                                      
                    AMT_CASH_BEGIN_BAL,                                 
                    AMT_BASIC_WORK,                                     
                    CASHIER_CODE,                                       
                    CODE_PYMT_FACILITY,                                 
                    CODE_FCS_EXTRACTED,                                 
                    DATE_LAST_ACTIVITY,                                 
                    NO_ITEMS_ENTERED,                                   
                    CIS.CHAR2$DATE(DATE_CASH_REPORT,'USA'),                     
                    CIS.CHAR2$DATE(DATE_LAST_ACTIVITY,'USA')                    
             FROM CSS_CSH_DRWR_CNTL WITH(READUNCOMMITTED)                       
             WHERE USER_ID       = :CS-USER-ID                          
C35842       AND CODE_CSH_DRWR_STAT = 'A'                               
             ORDER BY DATE_CASH_REPORT DESC                             
C35842       FOR READ ONLY                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     01710000
MFA-TR*      DECLARE CSHDWRCNTL-CURSOR  CURSOR FOR                      01720000
MFA-TR*      SELECT CASH_COMPANY_NO,                                    01740000
MFA-TR*             CASH_LOCAL_OFFICE,                                  01770000
MFA-TR*             CASH_REPORT_NO,                                     01740000
MFA-TR*             DATE_CASH_REPORT,                                   01740000
MFA-TR*             CASH_DRAWER_ID,                                     01780000
MFA-TR*             AMT_CASH_DEBIT,                                     01740000
MFA-TR*             AMT_CASH_CREDIT,                                    01740000
MFA-TR*             AMT_AR_DEBIT,                                       01740000
MFA-TR*             AMT_AR_CREDIT,                                      01740000
MFA-TR*             AMT_CK_ISS_DEBIT,                                   01740000
MFA-TR*             AMT_CK_ISS_CREDIT,                                  01740000
MFA-TR*             AMT_GL_DEBIT,                                       01760000
MFA-TR*             AMT_GL_CREDIT,                                      01770000
MFA-TR*             AMT_CASH_BEGIN_BAL,                                 01780000
MFA-TR*             AMT_BASIC_WORK,                                     01780000
MFA-TR*             CASHIER_CODE,                                       01780000
MFA-TR*             CODE_PYMT_FACILITY,                                 01780000
MFA-TR*             CODE_FCS_EXTRACTED,                                 01780000
MFA-TR*             DATE_LAST_ACTIVITY,                                 01780000
MFA-TR*             NO_ITEMS_ENTERED,                                   01780000
MFA-TR*             CHAR(DATE_CASH_REPORT,USA),                         01740000
MFA-TR*             CHAR(DATE_LAST_ACTIVITY,USA)                        01780000
MFA-TR*      FROM CSS_CSH_DRWR_CNTL                                     01800000
MFA-TR*      WHERE USER_ID       = :CS-USER-ID                          01810000
MFA-TR*      AND CODE_CSH_DRWR_STAT = 'A'                               01820000
MFA-TR*      ORDER BY DATE_CASH_REPORT DESC                             01830000
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*    END-EXEC.                                                    01840000
                                                                        
P353       COPY CWS00133.                                               01850200
                                                                        
HPCCDM*EJECT                                                            01860000
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
CVT000     10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         DECLARE C1 CURSOR  FOR                        
CVT000         SELECT                                                   
CVT000         RETURN_CODE                                              
CVT000        ,CASH_COMPANY_NO                                          
CVT000        ,CASH_LOCAL_OFFICE                                        
CVT000        ,CASH_REPORT_NO                                           
P00586        ,LTRIM(RTRIM(DATE_CASH_REPORT)) AS DATE_CASH_REPORT              
CVT000        ,CASH_DRAWER_ID                                           
CVT000        ,AMT_CASH_DEBIT                                           
CVT000        ,AMT_CASH_CREDIT                                          
CVT000        ,AMT_AR_DEBIT                                             
CVT000        ,AMT_AR_CREDIT                                            
CVT000        ,AMT_CK_ISS_DEBIT                                         
CVT000        ,AMT_CK_ISS_CREDIT                                        
CVT000        ,AMT_GL_DEBIT                                             
CVT000        ,AMT_GL_CREDIT                                            
CVT000        ,AMT_CASH_BEGIN_BAL                                       
CVT000        ,AMT_BASIC_WORK                                           
CVT000        ,CASHIER_CODE                                             
CVT000        ,CODE_PYMT_FACILITY                                       
CVT000        ,CODE_FCS_EXTRACTED                                       
CVT000        ,DATE_LAST_ACTIVITY                                       
CVT000        ,NO_ITEMS_ENTERED                                         
CVT000        ,CASHIER_CD_CHG_TS                                        
CVT000        ,PC_ID_RETURN_CD                                          
T35842        ,CREDIT_CARD_FL                                           
T35842        ,CHECK21_FL                                               
P00586        ,CASHIER_FULL_NAME                                        
P00586        ,PYMT_FACLTY_RBN_CD                                       
CVT000         FROM #CSR02331_R1                                 
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00000100
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        00000300
MFA-TR*        SELECT                                                   00000400
MFA-TR*        RETURN_CODE                                                      
MFA-TR*       ,CASH_COMPANY_NO                                                  
MFA-TR*       ,CASH_LOCAL_OFFICE                                                
MFA-TR*       ,CASH_REPORT_NO                                                   
MFA-TR*       ,STRIP(DATE_CASH_REPORT) AS DATE_CASH_REPORT                      
MFA-TR*       ,CASH_DRAWER_ID                                                   
MFA-TR*       ,AMT_CASH_DEBIT                                                   
MFA-TR*       ,AMT_CASH_CREDIT                                                  
MFA-TR*       ,AMT_AR_DEBIT                                                     
MFA-TR*       ,AMT_AR_CREDIT                                                    
MFA-TR*       ,AMT_CK_ISS_DEBIT                                                 
MFA-TR*       ,AMT_CK_ISS_CREDIT                                                
MFA-TR*       ,AMT_GL_DEBIT                                                     
MFA-TR*       ,AMT_GL_CREDIT                                                    
MFA-TR*       ,AMT_CASH_BEGIN_BAL                                               
MFA-TR*       ,AMT_BASIC_WORK                                                   
MFA-TR*       ,CASHIER_CODE                                                     
MFA-TR*       ,CODE_PYMT_FACILITY                                               
MFA-TR*       ,CODE_FCS_EXTRACTED                                               
MFA-TR*       ,DATE_LAST_ACTIVITY                                               
MFA-TR*       ,NO_ITEMS_ENTERED                                                 
MFA-TR*       ,CASHIER_CD_CHG_TS                                                
MFA-TR*       ,PC_ID_RETURN_CD                                                  
MFA-TR*       ,CREDIT_CARD_FL                                                   
MFA-TR*       ,CHECK21_FL                                                       
MFA-TR*       ,CASHIER_FULL_NAME                                                
MFA-TR*       ,PYMT_FACLTY_RBN_CD                                               
MFA-TR*        FROM SESSION.CSR02331_R1                                 00000500
MFA-TR*    END-EXEC.                                                    00000700
                                                                        
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-IDMS-LOOKUP         PIC  X(01)               .          
CVT000 01  LINK-USER-ID             PIC  X(07)               .          
P00586 01  LINK-CSR-PC-ID           PIC  X(15)               .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-IDMS-LOOKUP                                        
CVT000         ,LINK-USER-ID                                            
CVT000         ,LINK-CSR-PC-ID                                          
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
                                                                        
      ******************************************************************01890000
      * 0000-MAINLINE                                                  *01900000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *01910000
      ******************************************************************01920000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02030000
      * 0100-INITIALIZE                                                *02040000
      *                                                                *02050000
      *     1. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *02060000
      *     2. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *02070000
      *     3. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*02080000
      *                                                                *02090000
      ******************************************************************02100000
                                                                        
       0100-INITIALIZE.                                                 
           MOVE '0100' TO ACTIVE-PARAGRAPH.                             
                                                                        
CVT000     MOVE LINK-IDMS-LOOKUP          TO PARM-IDMS-LOOKUP         . 
CVT000     MOVE LINK-USER-ID              TO PARM-USER-ID             . 
CVT000     MOVE LINK-CSR-PC-ID            TO PARM-CSR-PC-ID           . 
CVT000     PERFORM 0100A-DECLARE-GTT      THRU 0100A-EXIT.              
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
CVT000 0100A-DECLARE-GTT.                                               
CVT000     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02331_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02331_R1
              (                                                          
CVT000         RETURN_CODE              INT                         
CVT000        ,CASH_COMPANY_NO CHAR(2)  COLLATE LATIN1_GENERAL_100_BIN2         
CVT000        ,CASH_LOCAL_OFFICE CHAR(3)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                         
CVT000        ,CASH_REPORT_NO CHAR(3)  COLLATE LATIN1_GENERAL_100_BIN2          
CVT000        ,DATE_CASH_REPORT CHAR(10)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,CASH_DRAWER_ID           SMALLINT                        
P00586        ,AMT_CASH_DEBIT           DECIMAL(13,2)                   
P00586        ,AMT_CASH_CREDIT          DECIMAL(13,2)                   
P00586        ,AMT_AR_DEBIT             DECIMAL(13,2)                   
P00586        ,AMT_AR_CREDIT            DECIMAL(13,2)                   
P00586        ,AMT_CK_ISS_DEBIT         DECIMAL(13,2)                   
P00586        ,AMT_CK_ISS_CREDIT        DECIMAL(13,2)                   
P00586        ,AMT_GL_DEBIT             DECIMAL(13,2)                   
P00586        ,AMT_GL_CREDIT            DECIMAL(13,2)                   
P00586        ,AMT_CASH_BEGIN_BAL       DECIMAL(13,2)                   
P00586        ,AMT_BASIC_WORK           DECIMAL(13,2)                   
CVT000        ,CASHIER_CODE CHAR(2)  COLLATE LATIN1_GENERAL_100_BIN2            
CVT000        ,CODE_PYMT_FACILITY CHAR(1)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                         
CVT000        ,CODE_FCS_EXTRACTED CHAR(1)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                         
CVT000        ,DATE_LAST_ACTIVITY CHAR(10)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,NO_ITEMS_ENTERED         INT                         
CVT000        ,CASHIER_CD_CHG_TS CHAR(26)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,PC_ID_RETURN_CD          INT                         
T35842        ,CREDIT_CARD_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
T35842        ,CHECK21_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2             
P00586        ,CASHIER_FULL_NAME CHAR(40)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
P00586        ,PYMT_FACLTY_RBN_CD CHAR(15)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000       )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR03501_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
CVT000 0100A-EXIT.                                                      
CVT000         EXIT.                                                    
                                                                        
      ******************************************************************02710000
      * 2000-PROCESS-OUTPUT.                                           *02720000
      *                                                                *02730000
      *     1. DESCRIBE RESULT SET                                     *02740000
      *     2. UPDATE DB2 DATA                                         *02750000
      *     3. BUILD RESULT SET                                        *02760000
      *     4. SEND RESULT SET                                         *02770000
      *                                                                *02780000
      ******************************************************************02790000
                                                                        
       2000-PROCESS-OUTPUT.                                             
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 2200-PROCESS          THRU 2200-EXIT.                
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 04600000
      *  2200-PROCESS-CSH_DRWR_CNTL                                     04610000
      *                                                               * 04620000
      *    RETRIEVE THE CSH_DRWR_CNTL ROW USING PARMS PASSED          * 04630000
      *                                                               * 04640000
      ***************************************************************** 04650000
       2200-PROCESS.                                                    
           MOVE 'N'                      TO PARM-IDMS-LOOKUP.           
                                                                        
           MOVE PARM-USER-ID             TO CS-USER-ID                  
                                            Y1-USER-ID                  
                                            PF-USER-ID.                 
                                                                        
           PERFORM 7000-SELECT-CASHIER THRU 7000-EXIT.                  
T35842     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T35842        MOVE Y1-CASH-COMPANY-NO     TO Y2-CASH-COMPANY-NO         
T35842        MOVE Y1-CASH-LOCAL-OFFICE   TO Y2-CASH-LOCAL-OFFICE       
T35842        PERFORM 7500-SELECT-FLAGS   THRU 7500-EXIT                
T35842        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
T35842           MOVE Y2-CREDIT-CARD-FL     TO RS-CREDIT-CARD-FL        
T35842           MOVE Y2-CHECK21-FL         TO RS-CHECK21-FL            
P00586           MOVE Y2-PYMT-FACLTY-RBN-CD TO RS-PYMT-FACLTY-RBN-CD    
T35842        END-IF                                                    
T35842     END-IF.                                                      
T35842*                                                                         
           MOVE PARM-CSR-PC-ID TO Y3-CASH-PC-ID.                        
           IF PARM-IDMS-LOOKUP = 'N'                                    
              PERFORM 7100-SELECT-CASH-PC-ID THRU 7100-EXIT             
           END-IF.                                                      
           PERFORM 7200-OPEN-CSHDWRCNTL-CURSOR  THRU 7200-EXIT.         
           PERFORM 2300-FETCH                   THRU 2300-EXIT          
              UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.              
                                                                        
           IF CTR-ROWS = 0                                              
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF.                  
                                                                        
           PERFORM 7220-CLOSE-CSHDWRCNTL-CURSOR THRU 7220-EXIT.         
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2300-FETCH.                                                      
      * FETCH CASHDRAWER IF AVAILABLE                                   04820000
           PERFORM 7210-FETCH-CSHDWRCNTL-CURSOR THRU 7210-EXIT.         
           MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE.               
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE CS-CASH-COMPANY-NO     TO RS-CASH-COMPANY-NO         
              MOVE CS-CASH-LOCAL-OFFICE   TO RS-CASH-LOCAL-OFFICE       
              MOVE CS-CASH-REPORT-NO      TO RS-CASH-REPORT-NO          
              MOVE WS-DATE-CASH-REPORT    TO RS-DATE-CASH-REPORT        
              MOVE CS-CASH-DRAWER-ID      TO RS-CASH-DRAWER-ID          
              MOVE CS-AMT-CASH-DEBIT      TO RS-AMT-CASH-DEBIT          
              MOVE CS-AMT-CASH-CREDIT     TO RS-AMT-CASH-CREDIT         
              MOVE CS-AMT-AR-DEBIT        TO RS-AMT-AR-DEBIT            
              MOVE CS-AMT-AR-CREDIT       TO RS-AMT-AR-CREDIT           
              MOVE CS-AMT-CK-ISS-DEBIT    TO RS-AMT-CK-ISS-DEBIT        
              MOVE CS-AMT-CK-ISS-CREDIT   TO RS-AMT-CK-ISS-CREDIT       
              MOVE CS-AMT-GL-DEBIT        TO RS-AMT-GL-DEBIT            
              MOVE CS-AMT-GL-CREDIT       TO RS-AMT-GL-CREDIT           
              MOVE CS-AMT-CASH-BEGIN-BAL  TO RS-AMT-CASH-BEGIN-BAL      
              MOVE CS-AMT-BASIC-WORK      TO RS-AMT-BASIC-WORK          
              IF PARM-IDMS-LOOKUP = 'Y'                                 
C35842           MOVE SPACE               TO RS-CODE-PYMT-FACILITY      
T21423           MOVE CS-CASHIER-CODE     TO RS-CASHIER-CODE            
              ELSE                                                      
                 MOVE CS-CODE-PYMT-FACILITY TO RS-CODE-PYMT-FACILITY    
              END-IF                                                    
              MOVE CS-CODE-FCS-EXTRACTED  TO RS-CODE-FCS-EXTRACTED      
              MOVE WS-DATE-LAST-ACTIVITY  TO RS-DATE-LAST-ACTIVITY      
              MOVE CS-NO-ITEMS-ENTERED    TO RS-NO-ITEMS-ENTERED        
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
           END-IF.                                                      
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-SELECT-CASHIER.                                             
           EXEC SQL                                                     
              SELECT Y1.CASH_COMPANY_NO,                                
                     Y1.CASH_LOCAL_OFFICE,                              
                     Y1.CASHIER_CODE,                                   
                     REPLACE(REPLACE(CONVERT(CHAR(26), 
           Y1.CASHIER_CD_CHG_TS, 121), ' ', '-'), ':', '.') 
           CASHIER_CD_CHG_TS,                              
P00586               RTRIM(PF.LAST_NAME) + ', ' + RTRIM(PF.FIRST_NAME
           ) + ' ' + RTRIM(PF.MIDDLE_NAME)                              
              INTO   :Y1-CASH-COMPANY-NO,                               
                     :Y1-CASH-LOCAL-OFFICE,                             
                     :Y1-CASHIER-CODE,                                  
                     :Y1-CASHIER-CD-CHG-TS,                             
P00586               :RS-CASHIER-FULL-NAME                              
P00586        FROM CSS_CASHIER Y1 WITH(READUNCOMMITTED),                        
P00586             CSS_USER_PROFILE PF WITH(READUNCOMMITTED)                    
P00586        WHERE Y1.USER_ID = :Y1-USER-ID                            
P00586          AND Y1.USER_ID = PF.USER_ID                             
C35842                                                           
P00586                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     04950000
MFA-TR*       SELECT Y1.CASH_COMPANY_NO,                                04950000
MFA-TR*              Y1.CASH_LOCAL_OFFICE,                              04950000
MFA-TR*              Y1.CASHIER_CODE,                                   04950000
MFA-TR*              Y1.CASHIER_CD_CHG_TS,                              04950000
MFA-TR*              RTRIM(PF.LAST_NAME) || ', ' ||                             
MFA-TR*              RTRIM(PF.FIRST_NAME) || ' ' ||                             
MFA-TR*              RTRIM(PF.MIDDLE_NAME)                                      
MFA-TR*       INTO   :Y1-CASH-COMPANY-NO,                               04950000
MFA-TR*              :Y1-CASH-LOCAL-OFFICE,                             04950000
MFA-TR*              :Y1-CASHIER-CODE,                                  04950000
MFA-TR*              :Y1-CASHIER-CD-CHG-TS,                             04950000
MFA-TR*              :RS-CASHIER-FULL-NAME                                      
MFA-TR*       FROM CSS_CASHIER Y1,                                      04950000
MFA-TR*            CSS_USER_PROFILE PF                                          
MFA-TR*       WHERE Y1.USER_ID = :Y1-USER-ID                            04950000
MFA-TR*         AND Y1.USER_ID = PF.USER_ID                                     
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                    04950000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE Y1-CASH-COMPANY-NO TO RS-CASH-COMPANY-NO             
              MOVE Y1-CASH-LOCAL-OFFICE TO RS-CASH-LOCAL-OFFICE         
              MOVE Y1-CASHIER-CODE TO RS-CASHIER-CODE                   
              MOVE Y1-CASHIER-CD-CHG-TS TO RS-CASHIER-CD-CHG-TS         
           ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
T23748*       PERFORM 7150-SELECT-USER-PROFILE THRU 7150-EXIT           04950000
T23748*       MOVE PF-COMPANY-NO      TO RS-CASH-COMPANY-NO             04950000
T23748        MOVE '01'               TO RS-CASH-COMPANY-NO             
              MOVE SPACES             TO RS-CASH-LOCAL-OFFICE           
              MOVE SPACES             TO RS-CASHIER-CODE                
              MOVE SPACES             TO RS-CASHIER-CD-CHG-TS           
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7200'              TO ACTIVE-PARAGRAPH              
              MOVE 'FETCH'             TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_CASHIER'       TO TABLE-1                       
              MOVE 'USER_ID'               TO TABLE-ELEMENT-1           
              MOVE Y1-USER-ID              TO HOSTVAR-ELEMENT-1         
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT
                END-IF
           END-IF.          
       7000-EXIT.                                                       
           EXIT.                                                        
       7100-SELECT-CASH-PC-ID.                                          
           EXEC SQL                                                     
              SELECT A.CASH_PC_ID,                                      
                     A.CODE_PYMT_FACILITY                               
              INTO   :Y3-CASH-PC-ID,                                    
                     :Y3-CODE-PYMT-FACILITY                             
              FROM CSS_CASH_PC_ID A WITH(READUNCOMMITTED),                      
                   CSS_CASHIER B WITH(READUNCOMMITTED)                          
              WHERE A.CASH_PC_ID = :Y3-CASH-PC-ID                       
                AND A.CASH_COMPANY_NO = B.CASH_COMPANY_NO               
                AND A.CASH_LOCAL_OFFICE = B.CASH_LOCAL_OFFICE           
                AND B.USER_ID = :Y1-USER-ID                             
C35842                                                           
P00586                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     04950000
MFA-TR*       SELECT A.CASH_PC_ID,                                      04950000
MFA-TR*              A.CODE_PYMT_FACILITY                               04950000
MFA-TR*       INTO   :Y3-CASH-PC-ID,                                    04950000
MFA-TR*              :Y3-CODE-PYMT-FACILITY                             04950000
MFA-TR*       FROM CSS_CASH_PC_ID A,                                    04950000
MFA-TR*            CSS_CASHIER B                                        04950000
MFA-TR*       WHERE A.CASH_PC_ID = :Y3-CASH-PC-ID                       04950000
MFA-TR*         AND A.CASH_COMPANY_NO = B.CASH_COMPANY_NO               04950000
MFA-TR*         AND A.CASH_LOCAL_OFFICE = B.CASH_LOCAL_OFFICE           04950000
MFA-TR*         AND B.USER_ID = :Y1-USER-ID                             04950000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                    04950000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE WS-ACTIVE-RETURN-CODE TO RS-PC-ID-RETURN-CD          
              MOVE Y3-CODE-PYMT-FACILITY TO RS-CODE-PYMT-FACILITY       
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7100'              TO ACTIVE-PARAGRAPH              
              MOVE 'FETCH'             TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_CASH_PC_ID'     TO TABLE-1                      
              MOVE 'USER_ID'               TO TABLE-ELEMENT-1           
              MOVE Y3-CASH-PC-ID           TO HOSTVAR-ELEMENT-1         
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT
           END-IF.          
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7150-SELECT-USER-PROFILE.                                        
                                                                        
           EXEC SQL                                                     
              SELECT COMPANY_NO                                         
              INTO   :PF-COMPANY-NO                                     
              FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                       
              WHERE USER_ID = :PF-USER-ID                               
C35842                                                           
P00586                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     04950000
MFA-TR*       SELECT COMPANY_NO                                         04950000
MFA-TR*       INTO   :PF-COMPANY-NO                                     04950000
MFA-TR*       FROM CSS_USER_PROFILE                                     04950000
MFA-TR*       WHERE USER_ID = :PF-USER-ID                               04950000
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7150                                                      
MFA-TR*    END-EXEC.                                                    04950000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7150'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_USER_PROFILE'   TO TABLE-1                      
              MOVE 'USER_ID'               TO TABLE-ELEMENT-1           
              MOVE PF-USER-ID              TO HOSTVAR-ELEMENT-1         
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT
           END-IF.          
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-OPEN-CSHDWRCNTL-CURSOR.                                     
           EXEC SQL                                                     
                OPEN CSHDWRCNTL-CURSOR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '7200'                  TO ACTIVE-PARAGRAPH          
              MOVE 'OPEN'                  TO ABEND-FUNCTION            
              MOVE SPACES                  TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_CSH_DRWR_CNTL'     TO TABLE-1                   
T16086        MOVE 'USER_ID'               TO TABLE-ELEMENT-1           
              MOVE CS-USER-ID              TO HOSTVAR-ELEMENT-1         
NEWNEW        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT
           END-IF.          
       7200-EXIT.                                                       
           EXIT.                                                        
       7210-FETCH-CSHDWRCNTL-CURSOR.                                    
           EXEC SQL                                                     
                FETCH CSHDWRCNTL-CURSOR                                 
           INTO :CS-CASH-COMPANY-NO,                                    
                :CS-CASH-LOCAL-OFFICE,                                  
                :CS-CASH-REPORT-NO,                                     
                :CS-DATE-CASH-REPORT,                                   
                :CS-CASH-DRAWER-ID,                                     
                :CS-AMT-CASH-DEBIT,                                     
                :CS-AMT-CASH-CREDIT,                                    
                :CS-AMT-AR-DEBIT,                                       
                :CS-AMT-AR-CREDIT,                                      
                :CS-AMT-CK-ISS-DEBIT,                                   
                :CS-AMT-CK-ISS-CREDIT,                                  
                :CS-AMT-GL-DEBIT,                                       
                :CS-AMT-GL-CREDIT,                                      
                :CS-AMT-CASH-BEGIN-BAL,                                 
                :CS-AMT-BASIC-WORK,                                     
                :CS-CASHIER-CODE,                                       
                :CS-CODE-PYMT-FACILITY,                                 
                :CS-CODE-FCS-EXTRACTED,                                 
                :CS-DATE-LAST-ACTIVITY,                                 
                :CS-NO-ITEMS-ENTERED,                                   
                :WS-DATE-CASH-REPORT,                                   
                :WS-DATE-LAST-ACTIVITY                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7210'              TO ACTIVE-PARAGRAPH              
              MOVE 'FETCH'             TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_CSH_DRWR_CNTL'     TO TABLE-1                   
T16086        MOVE 'USER_ID'               TO TABLE-ELEMENT-1           
              MOVE CS-USER-ID              TO HOSTVAR-ELEMENT-1         
NEWNEW        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT
           END-IF.          
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7220-CLOSE-CSHDWRCNTL-CURSOR.                                    
           EXEC SQL                                                     
                CLOSE CSHDWRCNTL-CURSOR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7220'              TO ACTIVE-PARAGRAPH              
              MOVE 'CLOSE'             TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_CSH_DRWR_CNTL'     TO TABLE-1                   
T16086        MOVE 'USER_ID'               TO TABLE-ELEMENT-1           
              MOVE CS-USER-ID              TO HOSTVAR-ELEMENT-1         
NEWNEW        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT
           END-IF.          
       7220-EXIT.                                                       
           EXIT.                                                        
T35842*                                                                         
T35842*****************************************************************         
T35842* 7500-SELECT-FLAGS                                             *         
T35842* SELECTS CREDIT-CARD AND CHECK21 FLAG FROM CSS_CASHIER_OFFICE  *         
P00586* AND ALSO SELECTS  PYMT-FACLTY-RBN-CD                          *         
T35842*****************************************************************         
T35842 7500-SELECT-FLAGS.                                               
T35842     EXEC SQL                                                     
T35842         SELECT CREDIT_CARD_FL,                                   
T35842                CHECK21_FL,                                       
P00586                PYMT_FACLTY_RBN_CD                                
T35842           INTO :Y2-CREDIT-CARD-FL,                               
T35842                :Y2-CHECK21-FL,                                   
P00586                :Y2-PYMT-FACLTY-RBN-CD                            
T35842           FROM CSS_CASHIER_OFFICE WITH(READUNCOMMITTED)                  
T35842          WHERE CASH_COMPANY_NO   = :Y2-CASH-COMPANY-NO           
T35842            AND CASH_LOCAL_OFFICE = :Y2-CASH-LOCAL-OFFICE         
T35842                                                           
P00586                                                      
T35842     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     05430000
MFA-TR*        SELECT CREDIT_CARD_FL,                                   05440000
MFA-TR*               CHECK21_FL,                                               
MFA-TR*               PYMT_FACLTY_RBN_CD                                        
MFA-TR*          INTO :Y2-CREDIT-CARD-FL,                                       
MFA-TR*               :Y2-CHECK21-FL,                                           
MFA-TR*               :Y2-PYMT-FACLTY-RBN-CD                                    
MFA-TR*          FROM CSS_CASHIER_OFFICE                                        
MFA-TR*         WHERE CASH_COMPANY_NO   = :Y2-CASH-COMPANY-NO                   
MFA-TR*           AND CASH_LOCAL_OFFICE = :Y2-CASH-LOCAL-OFFICE                 
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7500                                                    
MFA-TR*    END-EXEC.                                                    05450000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T35842*                                                                 05450000
T35842     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T35842     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T35842        NEXT SENTENCE                                             
T35842     ELSE                                                         
T35842        MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
T35842        MOVE '7500'                  TO ACTIVE-PARAGRAPH          
T35842        MOVE 'SELECT'                TO ABEND-FUNCTION            
T35842        MOVE SPACES                  TO ABEND-SQL-PREDICATES      
T35842                                        ABEND-TABLES              
T35842        MOVE 'CSS_CASHIER_OFFICE'    TO TABLE-1                   
T35842        MOVE 'CASH_COMPANY_NO'       TO TABLE-ELEMENT-1           
T35842        MOVE 'CASH_LOCAL_OFFICE'     TO TABLE-ELEMENT-2           
T35842        MOVE Y2-CASH-COMPANY-NO      TO HOSTVAR-ELEMENT-1         
T35842        MOVE Y2-CASH-LOCAL-OFFICE    TO HOSTVAR-ELEMENT-2         
T35842        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T35842        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T35842     END-IF.                                                      
T35842                                                                  
T35842 7500-EXIT.                                                       
T35842     EXIT.                                                        
                                                                        
      ******************************************************************05627000
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *05630000
      ******************************************************************05640000
           EXEC SQL                                                     05650000
              INCLUDE CPDSP300                                          05660000
           END-EXEC.                                                    05670000
                                                                        
      ******************************************************************05690000
      *       END PROGRAM COPYLIB                                      *05700000
      ******************************************************************05710000
CVT999*    COPY CPD00302.                                               05720000
                                                                        
CVT000 8100-SEND-RESULT.                                                
                                                                        
CVT000     EXEC SQL                                                     
CVT000       INSERT INTO #CSR02331_R1                            
CVT000       (                                                          
CVT000        RETURN_CODE                                               
CVT000       ,CASH_COMPANY_NO                                           
CVT000       ,CASH_LOCAL_OFFICE                                         
CVT000       ,CASH_REPORT_NO                                            
CVT000       ,DATE_CASH_REPORT                                          
CVT000       ,CASH_DRAWER_ID                                            
CVT000       ,AMT_CASH_DEBIT                                            
CVT000       ,AMT_CASH_CREDIT                                           
CVT000       ,AMT_AR_DEBIT                                              
CVT000       ,AMT_AR_CREDIT                                             
CVT000       ,AMT_CK_ISS_DEBIT                                          
CVT000       ,AMT_CK_ISS_CREDIT                                         
CVT000       ,AMT_GL_DEBIT                                              
CVT000       ,AMT_GL_CREDIT                                             
CVT000       ,AMT_CASH_BEGIN_BAL                                        
CVT000       ,AMT_BASIC_WORK                                            
CVT000       ,CASHIER_CODE                                              
CVT000       ,CODE_PYMT_FACILITY                                        
CVT000       ,CODE_FCS_EXTRACTED                                        
CVT000       ,DATE_LAST_ACTIVITY                                        
CVT000       ,NO_ITEMS_ENTERED                                          
CVT000       ,CASHIER_CD_CHG_TS                                         
CVT000       ,PC_ID_RETURN_CD                                           
T35842       ,CREDIT_CARD_FL                                            
T35842       ,CHECK21_FL                                                
P00586       ,CASHIER_FULL_NAME                                         
P00586       ,PYMT_FACLTY_RBN_CD                                        
CVT000       )                                                          
CVT000       VALUES                                                     
CVT000       (                                                          
CVT000        :RS-RETURN-CODE                                           
CVT000       ,:RS-CASH-COMPANY-NO                                       
CVT000       ,:RS-CASH-LOCAL-OFFICE                                     
CVT000       ,:RS-CASH-REPORT-NO                                        
CVT000       ,LTRIM(RTRIM(:RS-DATE-CASH-REPORT))                               
CVT000       ,:RS-CASH-DRAWER-ID                                        
CVT000       ,:RS-AMT-CASH-DEBIT                                        
CVT000       ,:RS-AMT-CASH-CREDIT                                       
CVT000       ,:RS-AMT-AR-DEBIT                                          
CVT000       ,:RS-AMT-AR-CREDIT                                         
CVT000       ,:RS-AMT-CK-ISS-DEBIT                                      
CVT000       ,:RS-AMT-CK-ISS-CREDIT                                     
CVT000       ,:RS-AMT-GL-DEBIT                                          
CVT000       ,:RS-AMT-GL-CREDIT                                         
CVT000       ,:RS-AMT-CASH-BEGIN-BAL                                    
CVT000       ,:RS-AMT-BASIC-WORK                                        
CVT000       ,:RS-CASHIER-CODE                                          
CVT000       ,:RS-CODE-PYMT-FACILITY                                    
CVT000       ,:RS-CODE-FCS-EXTRACTED                                    
CVT000       ,:RS-DATE-LAST-ACTIVITY                                    
CVT000       ,:RS-NO-ITEMS-ENTERED                                      
CVT000       ,:RS-CASHIER-CD-CHG-TS                                     
CVT000       ,:RS-PC-ID-RETURN-CD                                       
T35842       ,:RS-CREDIT-CARD-FL                                        
T35842       ,:RS-CHECK21-FL                                            
P00586       ,:RS-CASHIER-FULL-NAME                                     
P00586       ,:RS-PYMT-FACLTY-RBN-CD                                    
CVT000       )                                                          
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR02331_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,CASH_COMPANY_NO                                                   
MFA-TR*      ,CASH_LOCAL_OFFICE                                                 
MFA-TR*      ,CASH_REPORT_NO                                                    
MFA-TR*      ,DATE_CASH_REPORT                                                  
MFA-TR*      ,CASH_DRAWER_ID                                                    
MFA-TR*      ,AMT_CASH_DEBIT                                                    
MFA-TR*      ,AMT_CASH_CREDIT                                                   
MFA-TR*      ,AMT_AR_DEBIT                                                      
MFA-TR*      ,AMT_AR_CREDIT                                                     
MFA-TR*      ,AMT_CK_ISS_DEBIT                                                  
MFA-TR*      ,AMT_CK_ISS_CREDIT                                                 
MFA-TR*      ,AMT_GL_DEBIT                                                      
MFA-TR*      ,AMT_GL_CREDIT                                                     
MFA-TR*      ,AMT_CASH_BEGIN_BAL                                                
MFA-TR*      ,AMT_BASIC_WORK                                                    
MFA-TR*      ,CASHIER_CODE                                                      
MFA-TR*      ,CODE_PYMT_FACILITY                                                
MFA-TR*      ,CODE_FCS_EXTRACTED                                                
MFA-TR*      ,DATE_LAST_ACTIVITY                                                
MFA-TR*      ,NO_ITEMS_ENTERED                                                  
MFA-TR*      ,CASHIER_CD_CHG_TS                                                 
MFA-TR*      ,PC_ID_RETURN_CD                                                   
MFA-TR*      ,CREDIT_CARD_FL                                                    
MFA-TR*      ,CHECK21_FL                                                        
MFA-TR*      ,CASHIER_FULL_NAME                                                 
MFA-TR*      ,PYMT_FACLTY_RBN_CD                                                
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :RS-RETURN-CODE                                                   
MFA-TR*      ,:RS-CASH-COMPANY-NO                                               
MFA-TR*      ,:RS-CASH-LOCAL-OFFICE                                             
MFA-TR*      ,:RS-CASH-REPORT-NO                                                
MFA-TR*      ,STRIP(:RS-DATE-CASH-REPORT)                                       
MFA-TR*      ,:RS-CASH-DRAWER-ID                                                
MFA-TR*      ,:RS-AMT-CASH-DEBIT                                                
MFA-TR*      ,:RS-AMT-CASH-CREDIT                                               
MFA-TR*      ,:RS-AMT-AR-DEBIT                                                  
MFA-TR*      ,:RS-AMT-AR-CREDIT                                                 
MFA-TR*      ,:RS-AMT-CK-ISS-DEBIT                                              
MFA-TR*      ,:RS-AMT-CK-ISS-CREDIT                                             
MFA-TR*      ,:RS-AMT-GL-DEBIT                                                  
MFA-TR*      ,:RS-AMT-GL-CREDIT                                                 
MFA-TR*      ,:RS-AMT-CASH-BEGIN-BAL                                            
MFA-TR*      ,:RS-AMT-BASIC-WORK                                                
MFA-TR*      ,:RS-CASHIER-CODE                                                  
MFA-TR*      ,:RS-CODE-PYMT-FACILITY                                            
MFA-TR*      ,:RS-CODE-FCS-EXTRACTED                                            
MFA-TR*      ,:RS-DATE-LAST-ACTIVITY                                            
MFA-TR*      ,:RS-NO-ITEMS-ENTERED                                              
MFA-TR*      ,:RS-CASHIER-CD-CHG-TS                                             
MFA-TR*      ,:RS-PC-ID-RETURN-CD                                               
MFA-TR*      ,:RS-CREDIT-CARD-FL                                                
MFA-TR*      ,:RS-CHECK21-FL                                                    
MFA-TR*      ,:RS-CASHIER-FULL-NAME                                             
MFA-TR*      ,:RS-PYMT-FACLTY-RBN-CD                                            
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
CVT000                                                                  
CVT000     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
CVT000        NEXT SENTENCE                                             
CVT000     ELSE                                                         
CVT000        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
CVT000        MOVE '8900'               TO ACTIVE-PARAGRAPH             
CVT000        MOVE 'INSERT'             TO ABEND-FUNCTION               
CVT000        MOVE 'CSR0TEST_R1'        TO TABLE-1                      
CVT000        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
CVT000     END-IF.                                                      
CVT000                                                                  
CVT000     ADD 1 TO CTR-ROWS.                                           
CVT000*    INITIALIZE GTT-RETURN-FIELDS.                                00001900
CVT000*                                                                 00002000
CVT000 8100-EXIT.                                                       
CVT000      EXIT.                                                       
CVT000******************************************************************00000100
CVT000* 8000A-DELETE-GTT-ROWS.                                         *00000200
CVT000******************************************************************00000300
CVT000 8000A-DELETE-GTT-ROWS.                                           
CVT000*                                                                 00000500
CVT000     MOVE                                                         
CVT000     'DELETE ROWS'                                                
CVT000         TO S-SQL-STATEMENT-V.                                    
CVT000*                                                                 00000900
CVT000      EXEC SQL                                                    
CVT000          DELETE FROM #CSR02331_R1                         
CVT000      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    00001000
MFA-TR*         DELETE FROM SESSION.CSR02331_R1                         00001100
MFA-TR*     END-EXEC.                                                   00001200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000*                                                                 00001300
CVT000      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
CVT000*                                                                 00001500
CVT000      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
CVT000          NEXT SENTENCE                                           
CVT000      ELSE                                                        
CVT000         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
CVT000         MOVE '8000A'              TO ACTIVE-PARAGRAPH            
CVT000         MOVE 'DELETE'             TO ABEND-FUNCTION              
CVT000         MOVE SPACES               TO ABEND-SQL-PREDICATES        
CVT000                                      ABEND-TABLES                
CVT000         MOVE 'CSR02331_R1'        TO TABLE-1                     
CVT000         MOVE SPACES               TO TABLE-ELEMENT-1             
CVT000         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
CVT000         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
CVT000     END-IF.                                                      
CVT000*                                                                 00003100
CVT000 8000A-EXIT.                                                      
CVT000     EXIT.                                                        
CVT000*                                                                 00003400
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00320                                         00000200
CVT000     END-EXEC.                                                    00000300
