       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02330.                                         
COB303 DATE-WRITTEN.     MAR 03, 1996.                                  
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S330 CONVERTED TO DB2 SP CSR02330 ON 09/29/2006        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S330                                           *        
      *  PROGRAM:       S330                                           *        
      *  CALLING SP: PD_D0000265 FROM CSR_CSO105.SQR                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      * THIS PROGRAM SENDS DATA TO THE SERVER FOR USE BY CSR_CSO105 TO *        
      * PRINT THE SERVICE ORDER PRINT QUEUE REPORT.  THE REPORT IS     *        
      * GENERATED BY SQR3 AND REQUIRES CERTAIN FORMATING OF DATA.      *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  03/03/96    JGK      CREATED.                                 *        
      *  05/16/96    JHR      TPR #4214 - MODIFIED PARAGRAPHS 7150 AND *        
      *                       7200 IN ORDER TO RETURN CODE_MAKE FROM   *        
      *                       CSS_EQUIPMENT.                           *        
      *  05/16/96    JHR      TPR #4229 - FIXED NULL MOVE IN 7690.     *        
      *  05/17/96    JHR      TPR #4230 - ADDED REGISTER_RD_SEQ TO     *        
      *                       PARAGRAPH 7000.                          *        
      *  05/20/96    JHR      TPR #4243 - ADDED REGISTER_RD_SEQ TO     *        
      *                       PREMISE DATA TYPE RETRIEVAL (PARAGRAPH   *        
      *                       2300).                                   *        
      *  05/21/96    JHR      TPR #4250 - ADDED ACCT_CREATE_DT TO DNP  *        
      *                       DATA TYPE RETRIEVAL (PARAGRAPH 7700).    *        
      *                       TPR #4273 - ADDED READ_CYCLE AND         *        
      *                       READ_ROUTE TO PREMISE DATA TYPE          *        
      *                       RETRIEVAL (PARAGRAPH 2300).              *        
      *  07/11/96    JHR      TPR #4320 - REMOVED CSS_DNP CURSOR       *        
      *                       BECAUSE THE FIELDS SELECTED THERE SHOULD *        
      *                       HAVE BEEN OBTAINED FROM CSS_ACCOUNT AND  *        
      *                       CSS_CUST_MISC_INFO.                      *        
      * *                                                                       
      *  07/31/96    SR       THE LENGTH OF RETURN PARAMETER REMARKS   *        
      *                       IS CHANGED FROM 64 TO 114 DUE TO PCR#152.*        
      *  08/26/96    JTH      TPR #5024 - MOD KEY CUST FIELD. DELETED  *        
      *                       CUSTOMER PARM AND GETTING DATA FROM      *        
      *                       ACCOUNT TABLE.                           *        
      *  08/26/96    RAO JADA TPR #5489 - MODIFIED TO RETURN BACK      *        
      *                       MAX_NO_UNITS, MIN_NO_UNITS FROM          *        
      *                       CSS_MTRD_ENVRNMT TO CALLING UCSSO105 PGM *        
      *  08/26/96    RAO JADA TPR #5648 - MODIFIED TO RETURN BACK      *        
      *                       MAX_NO_UNITS, MIN_NO_UNITS FROM          *        
      *                       CSS_MTRD_ENVRNMT TO CALLING UCSSO105 PGM *        
      *                       IF RECORD NOT FOUND SEND BACK ZEROES     *        
PCR361*  10/02/96    MAD      PCR #361 - MADE MODIFICATIONS FOR SUPPORT*        
      *                       OF CPD00068/CPD00069 COMBINATION - FIX   *        
      *                       FOR TPR 5648 (WS-MAX-NO-UNITS)           *        
T4755 *  11/06/96  CSG        CHANGE DEFINITION OF POINT-ID WORKING    *        
      *                       STORAGE FIELDS FOR DCRS 1343 AND 1591.   *        
T7826 *  01/06/97  RAO JADA   SQL SHOULD SELECT SURETY BONDS FOR THE   *        
      *                       ACCOUNT WHOSE CODE_STATUS = 'A' OR THEIR *        
      *                       CODE_BOND_TYPE = 'B'.  TPR 7826.         *        
PCR040*  01/02/97  CBSI       REMOVED ALL REFERENCES TO                *        
PCR040*            MADRAS     CODE_CO_SIZE FIELD OF CSS_ELEC_METER     *        
PCR040*                       AS THIS FIELD IS REMOVED FROM THE TABLE  *        
TP8041*  01/25/97  RAO JADA   TPR CHANGES MADE TO GET SECOND NOTICE    *        
TP8041*                       DATE.                                    *        
      *  04/01/97  MJG        ADDED TWO DCLGENS TO THIS RPC BECAUSE    *        
      *                       THEY ARE USED BY CPD00068.               *        
T16853*  06/23/98  EMS        ADDED TBARHDT DCLGEN FOR CPD68.          *        
ADAM  *  10/27/98  AMG        CHANGED ALL SQL ABEND PROCESSING SO THAT *        
ADAM  *                       IT OCCURS BEFORE ANY OTHER PROCESSING    *        
ADAM  *                       AFTER SQL STATEMENTS ARE EXECUTED.       *        
ADAM  *                       ALSO SET RS-KEY-CUSTOMER TO 'Y' OR 'N'   *        
ADAM  *                       INSTEAD OF SIMPLY MOVING IN              *        
ADAM  *                       KEY_CUSTOMER FROM CSS_MISC_CUST_INFO     *        
ADAM  *  10/28/98  AMG        MODIFIED 'NEXT SENTENCE' LOGIC IN VARIOUS*        
ADAM  *                       LOCATIONS TO STOP RPC FROM SKIPPING OVER *        
ADAM  *                       NECESSARY LINES OF LOGIC BY CHANGING TO  *        
ADAM  *                       'CONTINUE' INSTEAD.                      *        
T17071*  11/19/98  MDJ        ADDED TBCSTALT INCLUDE FOR CUST_ALERT FOR*        
      *                       CPD00068 CHANGES.                        *        
CBSI  *  01/07/99  CBSI       ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *           MADRAS      ABEND PARAMETERS                         *        
T18194*  02/18/99  AHF        ADDED CODE TO RETURN BLOCK AND LOT INFO  *        
T19924*  05/13/99  AHF        CHANGED ALL RS-REMARKS VARIABLE NAMES TO *        
T19924*                       TO RS-SPCL-READ-INST TO COINCIDE WITH THE*        
T19924*                       ACTUAL FIELD THAT IT REPRESENTS          *        
T19430*  08/13/99  AHF        ADDED CODE TO CALCULATE 'NON-UTILITY'    *        
      *                       CHARGES AND PASS THEM BACK TO THE SO     *        
      *                       PRINTING PROGRAM CSR_CSO105.             *        
T21211*  01/11/00  AHF        CHANGED THE DEFINITION OF THE VARIABLES  *        
      *                       ADDED IN TPR 19430 FROM PIC S9(11)V99 TO *        
      *                       S9(9)S9(2).                              *        
T19557*  01/27/00  CBSI       COPYBOOK CDP00068 CHANGED TO SUB PROGRAM *        
T19557*            MADRAS     SCSCO068.                                *        
T22359*  06/23/00  AHF        CHANGED PROGRAM TO PASS IN S33O AS THE   *        
      *                       PROGRAM NAME WHEN CALLING SCSCO068.      *        
T22243*  07/31/00  CBSI       CHANGES MADE TO IMPLEMENT MULTI-COMPANY  *        
T22243*            MADRAS     IN METER INVENTORY TABLES                *        
C23342*  01/08/01  AHF        CHANGED DEFINITION OF WS-LAST-PAY-DATE   *        
C23342*                       AND RS-LAST-PAY-DATE FROM PIC X(10) TO   *        
C23342*                       PIC X(16) SO THAT THE PAYMENT TIME WOULD *        
C23342*                       BE PASSED BACK ALSO.                     *        
C23345*  01/09/01  AHF        REMOVED CODE THAT CALCULATED NON-UTILITY *        
C23345*                       CHARGES (TPR 19430). NOW PROGRAM USES THE*        
C23345*                       NON-UTILITY CHARGES VALUE CALCULATED IN  *        
C23345*                       PROGRAM SCSCO068. THE VARIABLES USED TO  *        
C23345*                       PASS THE VALUES BACK HAVE NOT CHANGED    *        
C23345*                       AND ARE STILL USED.                      *        
C19877*  01/10/01  AHF        CHANGED PROGRAM TO RETURN CLASS_AMPS (MAX*        
C19877*                       AMPS CAPACITY) FROM CSS_ELEC_CL_SPEC     *        
C19877*                       INSTEAD OF AMPS (TEST AMPS) FROM         *        
C19877*                       CSS_ELEC_METER. PART OF PCR 741.         *        
C23235*  04/25/01  AHF        ADDITIONAL RETURN FIELDS ADDED FOR PSNC. *        
C25553*  10/30/01  AHF        ADDED DATE_NOTICE_DUE_F FOR EXCEPTIONAL  *        
C25553*                       CREDIT TYPES.                            *        
C26305*  09/26/02  FMB        STORM, SAFETY, AND MAINT FLAGS FROM MF   *        
C26305*                       COMMUNICATION DATA INSTEAD OF SYBASE.    *        
C24056*  02/05/03  FMB        PASS OMS DATA FROM MAINFRAME TABLE.      *        
C29562*  08/27/03  RR         DEFAULT SNE_POINT FIELDS IF NULL         *        
C28788*  08/29/03  MDJ        GET IVR-EXEMPT-CD FOR CPD00068.          *        
C32622*  06/27/05  FMB        POPULATE RETURN CODE CORRECLTY IN 7910.  *        
C30989*  09/01/05  SC41135    CHANGED PROGRAM TO USE METER_PRESSURE    *        
C30989*                       FROM CSS_MTRD_ENVRNMT                    *        
C34361*  06/21/06  SC41135    GET XS_FLOW_VALVE_FL AND SPLIT_SERVICE_FL*        
C34361*                       FROM CSS_PREM_DLVRY_PT TABLE.            *        
C35927*  07/05/07  FMB        REPLACE LOW-VALUES WITH SPACES IN READ   *        
C35927*                       CYCLE                                    *        
C32257*  08/22/07  FMB        RETURN CODE_ACCT_STAT FOR CAD UPGRADE.   *        
C37405*  06/25/07  AHF        CHANGE STATIC CALL TO DYNAMIC CALL FOR   *        
C37405*                       PROGRAM MCSCB068                         *        
C35979*  09/10/08  MSR        DO NOT CALL MTR AND UTL CURSORS IF ACCT  *        
C35979*                       IS 0.                                    *        
C35979*                       REPLACE CSS_PREM_DLVRY_PT TABLE          *        
C33743*  09/22/08  SC41135    POINT ID PROJ - REPLACE SNE_POINT WITH   *        
C33743*                       CSS_PIM_POINT TABLE                      *        
P35979*  09/26/08  SC41135    ADDING COMPANY_NO TO CSS_SUBDIVISION     *        
P00471*  09/01/11  PK98692    ADDING 4 NEW DPP DROP DNP ORDER REASONS  *        
P00471*                       J-NORMAL DPP; K-NORMAL DPP W/RET CHK;    *        
P00471*                       U-DROPPED DPP; V-DROPPED DPP W/RET CHK   *        
P00480*  01/11/13  SC41135    ADDING 3 NEW MA FIELDS INSERTED IN FRONT *        
P00480*                       OF SPCL INSTRS ON PRINT AND CAD ORDERS   *        
A05317*  11/15/16  FMB        REMOVE REFERENCES TO MN LAT/LONG.        *        
ACT057*  03/08/17  RS7V450    DELETE TABLE CSS_DNP                     *        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
      *  PARAMETERS                                                    *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02330'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR RPC S330 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_MTRD_ENVRNMT  >                                     
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_UTIL_ENVRNMT  >                                     
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_AR_TRANS_HIST >                                     
           EXEC SQL                                                             
              INCLUDE TBARHIST                                                  
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_ACCOUNT       >                                     
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_PREMISE       >                                     
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
C34361*-------< INCLUDE CSS_PREM_DLVRY_PT >                                     
C35979*    EXEC SQL                                                             
C35979*       INCLUDE TBGSPREM                                                  
C35979*    END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_AR_CNTL        >                                    
           EXEC SQL                                                             
              INCLUDE TBARCNTL                                                  
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_CRED_COLL      >                                    
           EXEC SQL                                                             
              INCLUDE TBCRCOLL                                                  
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_CRIT_OUTAGE    >                                    
           EXEC SQL                                                             
              INCLUDE TBCRITOG                                                  
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_CUST_MISC_INFO >                                    
           EXEC SQL                                                             
              INCLUDE TBCSTMSC                                                  
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_NSF_HIST       >                                    
           EXEC SQL                                                             
              INCLUDE TBNSFHST                                                  
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_CREDIT_PROFILE >                                    
           EXEC SQL                                                             
              INCLUDE TBCRPROF                                                  
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_SUBDIVISION    >                                    
           EXEC SQL                                                             
              INCLUDE TBSUBDVN                                                  
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_LOCK_TYPE      >                                    
           EXEC SQL                                                             
              INCLUDE TBLCKTYP                                                  
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_METER_LOC      >                                    
           EXEC SQL                                                             
              INCLUDE TBMTRLOC                                                  
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_ELEC_METER     >                                    
           EXEC SQL                                                             
              INCLUDE TBELMTR                                                   
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_DEP_ON_HAND    >                                    
           EXEC SQL                                                             
              INCLUDE TBDEPHND                                                  
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_GAS_METER      >                                    
           EXEC SQL                                                             
              INCLUDE TBGASMTR                                                  
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_GUARATOR       >                                    
           EXEC SQL                                                             
              INCLUDE TBGTNTR                                                   
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_SURETY_BOND    >                                    
           EXEC SQL                                                             
              INCLUDE TBSTYBND                                                  
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_EQUIPMENT      >                                    
           EXEC SQL                                                             
              INCLUDE TBEQUIP                                                   
           END-EXEC.                                                            
                                                                        
C19877*-------<  INCLUDE CSS_ELEC_CL_SPEC  >                                    
C19877     EXEC SQL                                                             
C19877        INCLUDE TBELCLSP                                                  
C19877     END-EXEC.                                                            
                                                                        
C26305     EXEC SQL                                                             
C26305        INCLUDE TBCOMDAT                                                  
C26305     END-EXEC.                                                            
                                                                        
C33743     EXEC SQL                                                             
C33743        INCLUDE TBPIMPNT                                                  
C33743     END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
C35979*-------<  INCLUDE CSS_GAS_SERV_LINE >                                    
C35979     EXEC SQL                                                             
C35979        INCLUDE TBGASSRV                                                  
C35979     END-EXEC.                                                            
                                                                        
C35979*-------<  INCLUDE CSS_PREM_GAS_LINE >                                    
C35979     EXEC SQL                                                             
C35979        INCLUDE TBPREMLN                                                  
C35979     END-EXEC.                                                            
                                                                        
C35979*-------<  INCLUDE CSS_GASLINE_SO_XRF>                                    
C35979     EXEC SQL                                                             
C35979        INCLUDE TBGASSO                                                   
C35979     END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_SO_DATA - VO   >                                    
           EXEC SQL                                                             
              INCLUDE TBSODAT                                                   
           END-EXEC.                                                            
                                                                        
                                                                        
      *-------< INCLUDE CSS_SO_CODE_DESC - SW >                                 
           EXEC SQL                                                             
              INCLUDE TBSOCODE                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
      *-------< INCLUDE CWS00056 - CODES DATA PRESENT ON CSS_ACCOUNT >          
           EXEC SQL                                                             
              INCLUDE CWS00056                                                  
           END-EXEC.                                                            
                                                                        
PCR361*-------< INCLUDE CWS00068 - ON-LINE/BATCH VERSION OF CPD00068 >          
PCR361     EXEC SQL                                                             
PCR361        INCLUDE CWS00068                                                  
PCR361     END-EXEC.                                                            
PCR361*                                                                         
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *--------<COMMON SYSTEM AREA >                                            
           COPY CCA00001.                                                       
      *--------< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >               
           COPY CWS00027.                                                       
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                          
           COPY CWS00303.                                                       
T19557*--------< LINKAGE SECTION VARIABLES FOR SCSCO068 >                       
T19557     COPY CWS0068L.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  PROGRAM-NAME            PIC X(08) VALUE 'S330    '.      
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9) COMP.                  
           05  PARM-ACCOUNT-NO         PIC X(13).                       
           05  PARM-DATA-TYPE          PIC X(05).                       
           05  PARM-METER-NO           PIC X(09).                       
           05  PARM-PREMISE-NO         PIC X(10).                       
           05  PARM-SERV-ORDER-NO      PIC X(13).                       
           05  PARM-CODE-UTIL-TYPE     PIC X(01).                       
           05  PARM-IC-NO              PIC X(04).                       
           05  PARM-METER-REF-NO       PIC X(04).                       
TP8041     05  PARM-ORDER-REASON       PIC X(15).                       
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-MISC.                                                     
           05  WS-DATE-CCYY-MM-DD.                                      
               10  WS-DATE-CCYY       PIC X(04) VALUE SPACES.           
               10  FILLER             PIC X(01) VALUE SPACES.           
               10  WS-DATE-MM         PIC X(02) VALUE SPACES.           
               10  FILLER             PIC X(01) VALUE SPACES.           
               10  WS-DATE-DD         PIC X(02) VALUE SPACES.           
           05  WS-DATE-MM-DD-YYYY.                                      
               10  WS-DATE2-MM        PIC X(02) VALUE SPACES.           
               10  FILLER             PIC X(01) VALUE '/'.              
               10  WS-DATE2-DD        PIC X(02) VALUE SPACES.           
               10  FILLER             PIC X(01) VALUE '/'.              
               10  WS-DATE2-CCYY      PIC X(04) VALUE SPACES.           
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-ACTIVE-CODE          PIC X(01) VALUE 'A'.             
                                                                        
C37405 01  DYNAMIC-CALLS.                                               
C37405     05  WS-MCSCB068             PIC X(08) VALUE 'MCSCB068'.      
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-METER-SIZE-ID        PIC X(08) VALUE SPACES.          
           05  RS-METER-LOCK-TYPE      PIC X(09) VALUE SPACES.          
T4755 *    05  RS-METER-POINT-ID       PIC S9(9) COMP VALUE +0.                 
T4755      05  RS-METER-POINT-ID       PIC X(10) VALUE SPACES.          
           05  RS-METER-WIRES          PIC X(01) VALUE SPACES.          
           05  RS-METER-VOLTAGE        PIC S9(4) COMP VALUE +0.         
           05  RS-METER-MAKE           PIC X(02) VALUE SPACES.          
           05  RS-METER-PRESSURE       PIC S9(9) COMP VALUE +0.         
           05  RS-METER-GATE-ID        PIC X(07) VALUE SPACES.          
           05  RS-METER-LOC-DESC       PIC X(14) VALUE SPACES.          
C19877*    05  RS-METER-AMPS           PIC S9(2)V9(1) COMP-3 VALUE +0.          
C19877     05  RS-METER-AMPS           PIC S9(4) COMP VALUE +0.         
           05  RS-METER-PHASES         PIC X(01) VALUE SPACES.          
           05  RS-METER-TYPE           PIC X(02) VALUE SPACES.          
           05  RS-METER-ELE-CO-SIZE    PIC X(04) VALUE SPACES.          
           05  RS-METER-GAS-CO-SIZE    PIC S9(4) COMP VALUE +0.         
           05  RS-METER-CONN-TYPE      PIC X(02) VALUE SPACES.          
           05  RS-METER-PHASE-CD       PIC X(01) VALUE SPACES.          
           05  RS-DIRECTIONS-TEXT      PIC X(255) VALUE SPACES.         
PCR152     05  RS-SPCL-READ-INST-TEXT  PIC X(114) VALUE SPACES.         
           05  RS-SPCL-INST-TEXT       PIC X(255) VALUE SPACES.         
           05  RS-SUBDIVISION-DESC     PIC X(26) VALUE SPACES.          
           05  RS-NO-DNP               PIC S9(4) COMP VALUE +0.         
           05  RS-CREDIT-GROUP         PIC X(01) VALUE SPACES.          
           05  RS-TOTAL-DEPOSIT-AMT    PIC S9(10)V9(2) COMP-3 VALUE +0. 
           05  RS-LAST-PAY-AMOUNT      PIC S9(9)V9(2) COMP-3 VALUE +0.  
           05  RS-ARREARS-HISTORY      PIC X(24) VALUE SPACES.          
           05  RS-EX-CREDIT-HIST       PIC X(24) VALUE SPACES.          
           05  RS-DAYS-ARREARS2        PIC S9(9)V9(2) COMP-3 VALUE +0.  
           05  RS-ARREARS-BALANCE      PIC S9(9)V9(2) COMP-3 VALUE +0.  
           05  RS-BANKR-IND            PIC X(01) VALUE SPACES.          
           05  RS-CRITICAL-CUST        PIC X(30) VALUE SPACES.          
           05  RS-NO-RTN-CHECKS        PIC S9(4) COMP VALUE +0.         
           05  RS-CASH-ONLY-FLAG       PIC X(01) VALUE SPACES.          
           05  RS-LAST-PAY-DATE        PIC X(16) VALUE SPACES.          
           05  RS-SECOND-N-DATE        PIC X(10) VALUE SPACES.          
           05  RS-CREDIT-HISTORY       PIC X(24) VALUE SPACES.          
           05  RS-DAYS-ARREARS1        PIC S9(9)V9(2) COMP-3 VALUE +0.  
           05  RS-DAYS-ARREARS3        PIC S9(9)V9(2) COMP-3 VALUE +0.  
           05  RS-PAST-DUE-AMT         PIC S9(9)V9(2) COMP-3 VALUE +0.  
           05  RS-BALANCE-TOTAL        PIC S9(9)V9(2) COMP-3 VALUE +0.  
TP5489     05  RS-MAX-NO-UNITS         PIC S9(9)V     COMP-3 VALUE +0.  
TP5489     05  RS-MIN-NO-UNITS         PIC S9(9)V     COMP-3 VALUE +0.  
TP5024*    05  RS-KEY-CUSTOMER         PIC X(02) VALUE SPACES.                  
ADAM       05  RS-KEY-CUSTOMER         PIC X(01) VALUE SPACES.          
           05  RS-DPP                  PIC X(01) VALUE SPACES.          
           05  RS-REGISTER-RD-SEQ      PIC S9(9) COMP VALUE +0.         
           05  RS-ACCT-CREATE-DT       PIC X(10) VALUE SPACES.          
           05  RS-READ-CYCLE           PIC X(02) VALUE SPACES.          
           05  RS-READ-ROUTE           PIC S9(4) COMP VALUE +0.         
T18194     05  RS-BLOCK                PIC X(05) VALUE SPACES.          
T18194     05  RS-LOT                  PIC X(05) VALUE SPACES.          
T19430     05  RS-AMT-PAST-DUE-NONUTL  PIC S9(9)V9(2) COMP-3 VALUE +0.  
C23235     05  RS-CURR-CHGS-UTL        PIC S9(9)V9(2) COMP-3 VALUE +0.  
C23235     05  RS-AMT-PAST-DUE-UTL     PIC S9(9)V9(2) COMP-3 VALUE +0.  
C23235     05  RS-CURR-CHGS-NONUTL     PIC S9(9)V9(2) COMP-3 VALUE +0.  
C23235     05  RS-GUAR-PAST-DUE-AMT    PIC S9(9)V9(2) COMP-3 VALUE +0.  
C23235     05  RS-DATE-NOTICE-DUE-C    PIC X(10).                       
C25553     05  RS-DATE-NOTICE-DUE-F    PIC X(10).                       
           05  RS-METER-MFG-SN         PIC X(11).                       
C26305     05  RS-RED-FLAG-SAFETY      PIC X(01).                       
C26305     05  RS-RED-FLAG-MAINT       PIC X(01).                       
C26305     05  RS-RED-FLAG-STORM       PIC X(01).                       
C24056     05  RS-GRID-CELL-TX         PIC X(10).                       
C24056     05  RS-SUBSTATION-ID        PIC X(05).                       
C24056     05  RS-CIRCUIT-ID           PIC X(05).                       
C34361     05  RS-XS-FLOW-VALVE-FL     PIC X(01).                       
C34361     05  RS-SPLIT-SERVICE-FL     PIC X(01).                       
COB305     05 RS-MTR-REF-LATITUDE        PIC S9(3)V9(6) USAGE COMP-3 
COB305       VALUE 0.     
COB305     05 RS-MTR-REF-LONGITUDE        PIC S9(3)V9(6) USAGE COMP-3 
COB305       VALUE 0.     
C32257     05  RS-CODE-ACCT-STAT       PIC X(01).                       
                                                                        
       01  GENERAL-WORKING-STORAGE.                                     
           05  WS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  WS-METER-SIZE-ID        PIC X(08) VALUE SPACES.          
           05  WS-METER-LOCK-TYPE      PIC X(09) VALUE SPACES.          
T4755 *    05  WS-METER-POINT-ID       PIC S9(9) COMP VALUE +0.                 
T4755      05  WS-METER-POINT-ID       PIC X(10) VALUE SPACES.          
           05  WS-METER-WIRES          PIC X(01) VALUE SPACES.          
           05  WS-METER-VOLTAGE        PIC S9(4) COMP VALUE +0.         
           05  WS-METER-MAKE           PIC X(02) VALUE SPACES.          
           05  WS-METER-PRESSURE       PIC S9(9) COMP VALUE +0.         
COB305     05 WS-MTR-REF-LATITUDE        PIC S9(3)V9(6) USAGE COMP-3 
COB305       VALUE 0.     
COB305     05 WS-MTR-REF-LONGITUDE        PIC S9(3)V9(6) USAGE COMP-3 
COB305       VALUE 0.     
           05  WS-METER-GATE-ID        PIC X(07) VALUE SPACES.          
           05  WS-METER-LOC-DESC       PIC X(14) VALUE SPACES.          
C19877*    05  WS-METER-AMPS           PIC S9(2)V9(1) COMP-3 VALUE +0.          
C19877     05  WS-METER-AMPS           PIC S9(4) COMP VALUE +0.         
           05  WS-METER-PHASES         PIC X(01) VALUE SPACES.          
           05  WS-METER-TYPE           PIC X(02) VALUE SPACES.          
           05  WS-METER-ELE-CO-SIZE    PIC X(04) VALUE SPACES.          
           05  WS-METER-GAS-CO-SIZE    PIC S9(4) COMP VALUE +0.         
           05  WS-METER-CONN-TYPE      PIC X(02) VALUE SPACES.          
           05  WS-METER-PHASE-CD       PIC X(01) VALUE SPACES.          
           05  WS-DIRECTIONS           PIC X(255) VALUE SPACES.         
           05  WS-REMARKS              PIC X(64) VALUE SPACES.          
           05  WS-SPCL-INST            PIC X(255) VALUE SPACES.         
           05  WS-SUBDIVISION-DESC     PIC X(26) VALUE SPACES.          
           05  WS-NO-DNP-CNT           PIC S9(4) COMP VALUE 0.          
           05  WS-NO-DNP               PIC X(04) VALUE SPACES.          
           05  WS-CREDIT-GROUP         PIC X(01) VALUE SPACES.          
           05  WS-TOTAL-DEPOSIT-AMT    PIC S9(10)V9(2) COMP-3 VALUE +0. 
           05  WS-LAST-PAY-AMOUNT      PIC S9(9)V9(2) COMP-3 VALUE +0.  
           05  WS-ARREARS-HISTORY      PIC X(24) VALUE SPACES.          
           05  WS-EX-CREDIT-HIST       PIC X(24) VALUE SPACES.          
           05  WS-DAYS-ARREARS2        PIC S9(9)V9(2) COMP-3 VALUE +0.  
           05  WS-ARREARS-BALANCE      PIC S9(9)V9(2) COMP-3 VALUE +0.  
           05  WS-BANKR-IND            PIC X(01) VALUE SPACES.          
           05  WS-CRITICAL-CUST        PIC X(01) VALUE SPACES.          
           05  WS-NO-RTN-CHECKS        PIC X(04) VALUE SPACES.          
           05  WS-CASH-ONLY-FLAG       PIC X(01) VALUE SPACES.          
           05  WS-LAST-PAY-DATE        PIC X(16) VALUE SPACES.          
           05  WS-SECOND-N-DATE        PIC X(10) VALUE SPACES.          
           05  WS-CREDIT-HISTORY       PIC X(24) VALUE SPACES.          
           05  WS-DAYS-ARREARS1        PIC S9(9)V9(2) COMP-3 VALUE +0.  
           05  WS-DAYS-ARREARS3        PIC S9(9)V9(2) COMP-3 VALUE +0.  
           05  WS-PAST-DUE-AMT         PIC S9(9)V9(2) COMP-3 VALUE +0.  
           05  WS-BALANCE-TOTAL        PIC S9(9)V9(2) COMP-3 VALUE +0.  
TP5489     05  WS-MAX-NO-UNITS         PIC S9(9)V COMP-3 VALUE +0.      
TP5489     05  WS-MIN-NO-UNITS         PIC S9(9)V COMP-3 VALUE +0.      
TP5024*    05  WS-KEY-CUSTOMER         PIC X(02) VALUE SPACES.                  
ADAM       05  WS-KEY-CUSTOMER         PIC X(01) VALUE SPACES.          
           05  WS-DPP                  PIC X(01) VALUE SPACES.          
           05  WS-SP-STATUS            PIC S9(9) COMP VALUE 0.          
           05  WS-REGISTER-RD-SEQ      PIC S9(9) COMP VALUE +0.         
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.        
COB305     05 WS-PREMISE-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.        
COB305     05 WS-CUSTOMER-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.        
           05  WS-DATA-TYPE            PIC X(05).                       
           05  WS-METER-NO             PIC X(09).                       
P00480*    05  WS-SERV-ORDER-NO        PIC X(10).                               
           05  WS-CODE-UTIL-TYPE       PIC X(01).                       
           05  WS-IC-NO                PIC S9(04) USAGE COMP.           
           05  WS-METER-REF-NO         PIC S9(04) USAGE COMP.           
           05  WS-PYMT-PRIORITY-LVL    PIC S9(4) COMP VALUE 0.          
           05  WS-SUBDIVISION-ID       PIC X(03) VALUE SPACES.          
           05  WS-CODE-METER-LOC       PIC X(02) VALUE SPACES.          
           05  WS-LOCK-TYPE-ID         PIC X(01) VALUE SPACES.          
           05  WS-PREV-MNTH            PIC S9(4) COMP VALUE 0.          
           05  WS-EXCEPTIONAL-HIST     PIC X(24).                       
           05  WS-EXCEPTIONAL-HIST-BRKDWN  REDEFINES                    
                  WS-EXCEPTIONAL-HIST  PIC X(1) OCCURS 24.              
           05  WS-DISC-HIST            PIC X(24).                       
           05  WS-DISC-HIST-BRKDWN REDEFINES WS-DISC-HIST               
                                       PIC X(1) OCCURS 24.              
           05  WS-AMOUNT-GUARANTEED    PIC S9(7)V9(2) COMP-3 VALUE 0.   
           05  WS-AMT-BOND             PIC S9(9)V9(2) COMP-3 VALUE 0.   
           05  WS-AMT-DEPOSIT          PIC S9(7)V9(2) COMP-3 VALUE 0.   
           05  WS-AMT-ORIG-ENTERED     PIC S9(9)V9(2) COMP-3 VALUE 0.   
           05  WS-ONE-YEAR-AGO         PIC X(10) VALUE SPACES.          
           05  WS-C                    PIC X(1)  VALUE 'C'.             
           05  WS-FOUR                 PIC X(1)  VALUE '4'.             
           05  WS-RET-CHK-CNT-NO       PIC S9(4) COMP VALUE 0.          
           05  WS-RET-CHK-CNT          PIC X(04) VALUE SPACES.          
           05  WS-ORDER-REASON         PIC X(01) VALUE SPACES.          
T19557     05  WS-EIBRESP              PIC S9(8)  COMP SYNC  VALUE  0.  
T22243     05  WS-COMPANY-NO           PIC X(02).                       
           05  WS-METER-MFG-SN         PIC X(11) VALUE SPACES.          
C34361     05  WS-XS-FLOW-VALVE-FL     PIC X(01).                       
C34361     05  WS-SPLIT-SERVICE-FL     PIC X(01).                       
P00480     05  WS-SERV-ORDER-NO         PIC X(13) VALUE SPACES.         
P00480     05  WS-SERV-ORDER-NO-NUM     REDEFINES WS-SERV-ORDER-NO      
                                        PIC 9(13).                      
P00480     05  WS-ORDER-SPCL-INST      PIC X(75) VALUE SPACES.          
P00480     05  WS-CODE-SHORT-DESC      PIC X(20) VALUE SPACES.          
P00480     05  WS-PHONE-1              PIC X(03) VALUE SPACES.          
P00480     05  WS-PHONE-2              PIC X(03) VALUE SPACES.          
P00480     05  WS-PHONE-3              PIC X(04) VALUE SPACES.          
P00480     05  WS-PHONE-NO             PIC X(25) VALUE SPACES.          
P00480     05  WS-PHONE-NO-EXT         PIC X(10) VALUE SPACES.          
P00480     05  WS-SUB                  PIC S9(8) COMP VALUE 0.          
P00480     05  WS-SUB1                 PIC S9(8) COMP VALUE 0.          
P00480     05  WS-SUB2                 PIC S9(8) COMP VALUE 0.          
P00480     05  WS-NULL-ACCESSIBLE-DT   PIC S9(04)    COMP   VALUE +0.   
                                                                        
       01  WS-NULL-INDICATORS.                                          
PCR361     05  WS-NULL-BILL-DAY-00     PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-BILL-DAY-30     PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-BILL-DAY-60     PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-BILL-DAY-90     PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-DATE-FORECAST   PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-AMT-DEPOSIT     PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-AMT-BOND        PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-AMT-GUARANTD    PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-DATE-NOTICE-MAIL PIC S9(04) COMP VALUE +0.       
           05  WS-NULL-TRANS-SEQ-NO    PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-ACCT-CREATE-DT  PIC S9(04) COMP VALUE +0.        
                                                                        
      * HOLD FIELDS ARE NEEDED FOR THE CONVERTS WITH THE COMP OR                
      * COMP-3 NUMERIC DATA TYPES                                               
                                                                        
       01  WS-HOLD-FIELDS.                                              
           05  WS-HOLD-ACCOUNT-NO      PIC S9(13).                      
           05  WS-HOLD-PREMISE-NO      PIC S9(10).                      
      *    05  WS-HOLD-CUSTOMER-NO     PIC S9(10).                              
           05  WS-HOLD-IC-NO           PIC S9(04).                      
           05  WS-HOLD-METER-REF-NO    PIC S9(04).                      
           05  WS-HOLD-AMT-30-DAY      PIC S9(09) VALUE +0.             
           05  WS-HOLD-AMT-60-DAY      PIC S9(09) VALUE +0.             
           05  WS-HOLD-AMT-90-DAY      PIC S9(09) VALUE +0.             
           05  WS-HOLD-AMT-ENTERED     PIC S9(9)V9(2)  VALUE +0.        
           05  WS-HOLD-AMT-ARREARS     PIC S9(09) VALUE +0.             
           05  WS-HOLD-AMT-PAST-DUE    PIC S9(09) VALUE +0.             
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
                                                                        
      *--- < CURSOR FOR CSS_AR_TRANS_HIST>                                      
                                                                        
           EXEC SQL DECLARE AR-CURSOR CURSOR FOR                        
               SELECT    REPLACE(REPLACE(CONVERT(CHAR(26), 
           TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO,                             
                         AMT_ORIG_ENTERED                               
               FROM      CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                
               WHERE     ACCOUNT_NO         = :WS-ACCOUNT-NO            
               AND       CODE_TRAN_TYPE     = 'P'                       
               AND       RECORD_ONLY_FL    <> 'Y'                       
               ORDER BY  TRANS_HIST_SEQ_NO DESC
            OPTION(FAST 1)
            FOR READ ONLY
                                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ021
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE AR-CURSOR CURSOR FOR                                
MFA-TR*        SELECT    TRANS_HIST_SEQ_NO,                                     
MFA-TR*                  AMT_ORIG_ENTERED                                       
MFA-TR*        FROM      CSS_AR_TRANS_HIST                                      
MFA-TR*        WHERE     ACCOUNT_NO         = :WS-ACCOUNT-NO                    
MFA-TR*        AND       CODE_TRAN_TYPE     = 'P'                               
MFA-TR*        AND       RECORD_ONLY_FL    <> 'Y'                               
MFA-TR*        ORDER BY  TRANS_HIST_SEQ_NO DESC                                 
MFA-TR*                  OPTIMIZE FOR 1 ROW                                     
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR CSS_MTRD_ENVRNMT >                                      
                                                                        
           EXEC SQL DECLARE MTR-CURSOR CURSOR FOR                       
               SELECT REGISTER_RD_SEQ                                   
                 FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO  = :WS-ACCOUNT-NO                      
               FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE MTR-CURSOR CURSOR FOR                               
MFA-TR*        SELECT REGISTER_RD_SEQ                                           
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO  = :WS-ACCOUNT-NO                              
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR CSS_UTIL_ENVRNMT >                                      
                                                                        
           EXEC SQL DECLARE UTL-CURSOR CURSOR FOR                       
               SELECT READ_CYCLE,                                       
                      READ_ROUTE                                        
                 FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO  = :WS-ACCOUNT-NO                      
               FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE UTL-CURSOR CURSOR FOR                               
MFA-TR*        SELECT READ_CYCLE,                                               
MFA-TR*               READ_ROUTE                                                
MFA-TR*          FROM CSS_UTIL_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO  = :WS-ACCOUNT-NO                              
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
C26305*--- < CURSOR FOR CSS_COMM_DATA >                                         
C26305                                                                  
C26305     EXEC SQL DECLARE COMM-CURSOR CURSOR FOR                      
C26305         SELECT COMM_TYPE_CD,                                     
C26305                COMM_SUBTYPE_CODE                                 
C26305           FROM CSS_COMM_DATA WITH(READUNCOMMITTED)                       
C26305          WHERE ACCOUNT_NO  = :WS-ACCOUNT-NO                      
C26305            AND RED_FLAG_IND = 'Y'                                
C26305            AND (RED_FLAG_EXPIRE_DT > CIS.CHAR2TIMESTAMP(
                                                 :KO-RED-FLAG-EXPIRE-DT
              )      
C26305             OR  RED_FLAG_EXPIRE_DT IS NULL)                      
               FOR READ ONLY                                    
C26305     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL DECLARE COMM-CURSOR CURSOR FOR                              
MFA-TR*        SELECT COMM_TYPE_CD,                                             
MFA-TR*               COMM_SUBTYPE_CODE                                         
MFA-TR*          FROM CSS_COMM_DATA                                             
MFA-TR*         WHERE ACCOUNT_NO  = :WS-ACCOUNT-NO                              
MFA-TR*           AND RED_FLAG_IND = 'Y'                                        
MFA-TR*           AND (RED_FLAG_EXPIRE_DT > :KO-RED-FLAG-EXPIRE-DT              
MFA-TR*            OR  RED_FLAG_EXPIRE_DT IS NULL)                              
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
CVT000     10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-ACCOUNT-NO          PIC X(13)                .          
CVT000 01  LINK-DATA-TYPE           PIC X(05)                .          
CVT000 01  LINK-METER-NO            PIC X(09)                .          
CVT000 01  LINK-PREMISE-NO          PIC X(10)                .          
CVT000 01  LINK-SERV-ORDER-NO       PIC X(13)                .          
CVT000 01  LINK-CODE-UTIL-TYPE      PIC X(01)                .          
CVT000 01  LINK-IC-NO               PIC X(04)                .          
CVT000 01  LINK-METER-REF-NO        PIC X(04)                .          
CVT000 01  LINK-ORDER-REASON        PIC X(15)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-ACCOUNT-NO                                         
CVT000         ,LINK-DATA-TYPE                                          
CVT000         ,LINK-METER-NO                                           
CVT000         ,LINK-PREMISE-NO                                         
CVT000         ,LINK-SERV-ORDER-NO                                      
CVT000         ,LINK-CODE-UTIL-TYPE                                     
CVT000         ,LINK-IC-NO                                              
CVT000         ,LINK-METER-REF-NO                                       
CVT000         ,LINK-ORDER-REASON                                       
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
PCR361*     CALLS 9700-PROCESS-ABEND                                   *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'             TO ACTIVE-PARAGRAPH.                 
                                                                        
CVT000     EXEC SQL                                                     
CVT000       DECLARE C1 CURSOR  FOR                          
CVT000       SELECT                                                     
CVT000*       :RS-RETURN-CODE              AS    RETURN_CODE                    
CVT000        :S-RETURN-CODE               AS    RETURN_CODE            
CVT000       ,:RS-METER-SIZE-ID            AS    METER_SIZE_ID          
CVT000       ,:RS-METER-LOCK-TYPE          AS    METER_LOCK_TYPE        
CVT000       ,:RS-METER-POINT-ID           AS    METER_POINT_ID         
CVT000       ,:RS-METER-WIRES              AS    METER_WIRES            
CVT000       ,:RS-METER-VOLTAGE            AS    METER_VOLTAGE          
CVT000       ,:RS-METER-MAKE               AS    METER_MAKE             
CVT000       ,:RS-METER-PRESSURE           AS    METER_PRESSURE         
CVT000       ,:RS-METER-GATE-ID            AS    METER_GATE_ID          
CVT000       ,:RS-METER-LOC-DESC           AS    METER_LOC_DESC         
CVT000       ,:RS-METER-AMPS               AS    METER_AMPS             
CVT000       ,:RS-METER-PHASES             AS    METER_PHASES           
CVT000       ,:RS-METER-TYPE               AS    METER_TYPE             
CVT000       ,:RS-METER-ELE-CO-SIZE        AS    METER_ELE_CO_SIZE      
CVT000       ,:RS-METER-GAS-CO-SIZE        AS    METER_GAS_CO_SIZE      
CVT000       ,:RS-METER-CONN-TYPE          AS    METER_CONN_TYPE        
CVT000       ,:RS-METER-PHASE-CD           AS    METER_PHASE_CD         
CVT000       ,:RS-DIRECTIONS-TEXT          AS    DIRECTIONS_TEXT        
CVT000       ,:RS-SPCL-READ-INST-TEXT      AS    SPCL_READ_INST_TEXT    
CVT000       ,:RS-SPCL-INST-TEXT           AS    SPCL_INST_TEXT         
CVT000       ,:RS-SUBDIVISION-DESC         AS    SUBDIVISION_DESC       
CVT000       ,:RS-NO-DNP                   AS    NO_DNP                 
CVT000       ,:RS-CREDIT-GROUP             AS    CREDIT_GROUP           
CVT000       ,:RS-TOTAL-DEPOSIT-AMT        AS    TOTAL_DEPOSIT_AMT      
CVT000       ,:RS-LAST-PAY-AMOUNT          AS    LAST_PAY_AMOUNT        
CVT000       ,:RS-ARREARS-HISTORY          AS    ARREARS_HISTORY        
CVT000       ,:RS-EX-CREDIT-HIST           AS    EX_CREDIT_HIST         
CVT000       ,:RS-DAYS-ARREARS2            AS    DAYS_ARREARS2          
CVT000       ,:RS-ARREARS-BALANCE          AS    ARREARS_BALANCE        
CVT000       ,:RS-BANKR-IND                AS    BANKR_IND              
CVT000       ,:RS-CRITICAL-CUST            AS    CRITICAL_CUST          
CVT000       ,:RS-NO-RTN-CHECKS            AS    NO_RTN_CHECKS          
CVT000       ,:RS-CASH-ONLY-FLAG           AS    CASH_ONLY_FLAG         
CVT000       ,:RS-LAST-PAY-DATE            AS    LAST_PAY_DATE          
CVT000       ,:RS-SECOND-N-DATE            AS    SECOND_N_DATE          
CVT000       ,:RS-CREDIT-HISTORY           AS    CREDIT_HISTORY         
CVT000       ,:RS-DAYS-ARREARS1            AS    DAYS_ARREARS1          
CVT000       ,:RS-DAYS-ARREARS3            AS    DAYS_ARREARS3          
CVT000       ,:RS-PAST-DUE-AMT             AS    PAST_DUE_AMT           
CVT000       ,:RS-BALANCE-TOTAL            AS    BALANCE_TOTAL          
CVT000       ,:RS-MAX-NO-UNITS             AS    MAX_NO_UNITS           
CVT000       ,:RS-MIN-NO-UNITS             AS    MIN_NO_UNITS           
CVT000       ,:RS-KEY-CUSTOMER             AS    KEY_CUSTOMER           
CVT000       ,:RS-DPP                      AS    DPP                    
CVT000       ,:RS-REGISTER-RD-SEQ          AS    REGISTER_RD_SEQ        
CVT000       ,:RS-ACCT-CREATE-DT           AS    ACCT_CREATE_DT         
CVT000       ,:RS-READ-CYCLE               AS    READ_CYCLE             
CVT000       ,:RS-READ-ROUTE               AS    READ_ROUTE             
CVT000       ,:RS-BLOCK                    AS    BLOCK                  
CVT000       ,:RS-LOT                      AS    LOT                    
CVT000       ,:RS-AMT-PAST-DUE-NONUTL      AS    AMT_PAST_DUE_NONUTL    
CVT000       ,:RS-CURR-CHGS-UTL            AS    CURR_CHGS_UTL          
CVT000       ,:RS-AMT-PAST-DUE-UTL         AS    AMT_PAST_DUE_UTL       
CVT000       ,:RS-CURR-CHGS-NONUTL         AS    CURR_CHGS_NONUTL       
CVT000       ,:RS-GUAR-PAST-DUE-AMT        AS    GUAR_PAST_DUE_AMT      
CVT000       ,:RS-DATE-NOTICE-DUE-C        AS    DATE_NOTICE_DUE_C      
CVT000       ,:RS-DATE-NOTICE-DUE-F        AS    DATE_NOTICE_DUE_F      
CVT000       ,:RS-METER-MFG-SN             AS    METER_MFG_SN           
CVT000       ,:RS-RED-FLAG-SAFETY          AS    RED_FLAG_SAFETY        
CVT000       ,:RS-RED-FLAG-MAINT           AS    RED_FLAG_MAINT         
CVT000       ,:RS-RED-FLAG-STORM           AS    RED_FLAG_STORM         
CVT000       ,:RS-GRID-CELL-TX             AS    GRID_CELL_TX           
CVT000       ,:RS-SUBSTATION-ID            AS    SUBSTATION_ID          
CVT000       ,:RS-CIRCUIT-ID               AS    CIRCUIT_ID             
CVT000       ,:RS-XS-FLOW-VALVE-FL         AS    XS_FLOW_VALVE_FL       
CVT000       ,:RS-SPLIT-SERVICE-FL         AS    SPLIT_SERVICE_FL       
             ,:RS-MTR-REF-LATITUDE         AS    LATITUDE               
             ,:RS-MTR-REF-LONGITUDE        AS    LONGITUDE              
C32257       ,:RS-CODE-ACCT-STAT           AS    ACCT_STAT              
CVT000          FROM CIS.SYSDUMMY1                                   
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :RS-RETURN-CODE              AS    RETURN_CODE                    
MFA-TR*       :S-RETURN-CODE               AS    RETURN_CODE                    
MFA-TR*      ,:RS-METER-SIZE-ID            AS    METER_SIZE_ID                  
MFA-TR*      ,:RS-METER-LOCK-TYPE          AS    METER_LOCK_TYPE                
MFA-TR*      ,:RS-METER-POINT-ID           AS    METER_POINT_ID                 
MFA-TR*      ,:RS-METER-WIRES              AS    METER_WIRES                    
MFA-TR*      ,:RS-METER-VOLTAGE            AS    METER_VOLTAGE                  
MFA-TR*      ,:RS-METER-MAKE               AS    METER_MAKE                     
MFA-TR*      ,:RS-METER-PRESSURE           AS    METER_PRESSURE                 
MFA-TR*      ,:RS-METER-GATE-ID            AS    METER_GATE_ID                  
MFA-TR*      ,:RS-METER-LOC-DESC           AS    METER_LOC_DESC                 
MFA-TR*      ,:RS-METER-AMPS               AS    METER_AMPS                     
MFA-TR*      ,:RS-METER-PHASES             AS    METER_PHASES                   
MFA-TR*      ,:RS-METER-TYPE               AS    METER_TYPE                     
MFA-TR*      ,:RS-METER-ELE-CO-SIZE        AS    METER_ELE_CO_SIZE              
MFA-TR*      ,:RS-METER-GAS-CO-SIZE        AS    METER_GAS_CO_SIZE              
MFA-TR*      ,:RS-METER-CONN-TYPE          AS    METER_CONN_TYPE                
MFA-TR*      ,:RS-METER-PHASE-CD           AS    METER_PHASE_CD                 
MFA-TR*      ,:RS-DIRECTIONS-TEXT          AS    DIRECTIONS_TEXT                
MFA-TR*      ,:RS-SPCL-READ-INST-TEXT      AS    SPCL_READ_INST_TEXT            
MFA-TR*      ,:RS-SPCL-INST-TEXT           AS    SPCL_INST_TEXT                 
MFA-TR*      ,:RS-SUBDIVISION-DESC         AS    SUBDIVISION_DESC               
MFA-TR*      ,:RS-NO-DNP                   AS    NO_DNP                         
MFA-TR*      ,:RS-CREDIT-GROUP             AS    CREDIT_GROUP                   
MFA-TR*      ,:RS-TOTAL-DEPOSIT-AMT        AS    TOTAL_DEPOSIT_AMT              
MFA-TR*      ,:RS-LAST-PAY-AMOUNT          AS    LAST_PAY_AMOUNT                
MFA-TR*      ,:RS-ARREARS-HISTORY          AS    ARREARS_HISTORY                
MFA-TR*      ,:RS-EX-CREDIT-HIST           AS    EX_CREDIT_HIST                 
MFA-TR*      ,:RS-DAYS-ARREARS2            AS    DAYS_ARREARS2                  
MFA-TR*      ,:RS-ARREARS-BALANCE          AS    ARREARS_BALANCE                
MFA-TR*      ,:RS-BANKR-IND                AS    BANKR_IND                      
MFA-TR*      ,:RS-CRITICAL-CUST            AS    CRITICAL_CUST                  
MFA-TR*      ,:RS-NO-RTN-CHECKS            AS    NO_RTN_CHECKS                  
MFA-TR*      ,:RS-CASH-ONLY-FLAG           AS    CASH_ONLY_FLAG                 
MFA-TR*      ,:RS-LAST-PAY-DATE            AS    LAST_PAY_DATE                  
MFA-TR*      ,:RS-SECOND-N-DATE            AS    SECOND_N_DATE                  
MFA-TR*      ,:RS-CREDIT-HISTORY           AS    CREDIT_HISTORY                 
MFA-TR*      ,:RS-DAYS-ARREARS1            AS    DAYS_ARREARS1                  
MFA-TR*      ,:RS-DAYS-ARREARS3            AS    DAYS_ARREARS3                  
MFA-TR*      ,:RS-PAST-DUE-AMT             AS    PAST_DUE_AMT                   
MFA-TR*      ,:RS-BALANCE-TOTAL            AS    BALANCE_TOTAL                  
MFA-TR*      ,:RS-MAX-NO-UNITS             AS    MAX_NO_UNITS                   
MFA-TR*      ,:RS-MIN-NO-UNITS             AS    MIN_NO_UNITS                   
MFA-TR*      ,:RS-KEY-CUSTOMER             AS    KEY_CUSTOMER                   
MFA-TR*      ,:RS-DPP                      AS    DPP                            
MFA-TR*      ,:RS-REGISTER-RD-SEQ          AS    REGISTER_RD_SEQ                
MFA-TR*      ,:RS-ACCT-CREATE-DT           AS    ACCT_CREATE_DT                 
MFA-TR*      ,:RS-READ-CYCLE               AS    READ_CYCLE                     
MFA-TR*      ,:RS-READ-ROUTE               AS    READ_ROUTE                     
MFA-TR*      ,:RS-BLOCK                    AS    BLOCK                          
MFA-TR*      ,:RS-LOT                      AS    LOT                            
MFA-TR*      ,:RS-AMT-PAST-DUE-NONUTL      AS    AMT_PAST_DUE_NONUTL            
MFA-TR*      ,:RS-CURR-CHGS-UTL            AS    CURR_CHGS_UTL                  
MFA-TR*      ,:RS-AMT-PAST-DUE-UTL         AS    AMT_PAST_DUE_UTL               
MFA-TR*      ,:RS-CURR-CHGS-NONUTL         AS    CURR_CHGS_NONUTL               
MFA-TR*      ,:RS-GUAR-PAST-DUE-AMT        AS    GUAR_PAST_DUE_AMT              
MFA-TR*      ,:RS-DATE-NOTICE-DUE-C        AS    DATE_NOTICE_DUE_C              
MFA-TR*      ,:RS-DATE-NOTICE-DUE-F        AS    DATE_NOTICE_DUE_F              
MFA-TR*      ,:RS-METER-MFG-SN             AS    METER_MFG_SN                   
MFA-TR*      ,:RS-RED-FLAG-SAFETY          AS    RED_FLAG_SAFETY                
MFA-TR*      ,:RS-RED-FLAG-MAINT           AS    RED_FLAG_MAINT                 
MFA-TR*      ,:RS-RED-FLAG-STORM           AS    RED_FLAG_STORM                 
MFA-TR*      ,:RS-GRID-CELL-TX             AS    GRID_CELL_TX                   
MFA-TR*      ,:RS-SUBSTATION-ID            AS    SUBSTATION_ID                  
MFA-TR*      ,:RS-CIRCUIT-ID               AS    CIRCUIT_ID                     
MFA-TR*      ,:RS-XS-FLOW-VALVE-FL         AS    XS_FLOW_VALVE_FL               
MFA-TR*      ,:RS-SPLIT-SERVICE-FL         AS    SPLIT_SERVICE_FL               
MFA-TR*      ,:RS-MTR-REF-LATITUDE         AS    LATITUDE                       
MFA-TR*      ,:RS-MTR-REF-LONGITUDE        AS    LONGITUDE                      
MFA-TR*      ,:RS-CODE-ACCT-STAT           AS    ACCT_STAT                      
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
CVT000     MOVE LINK-DATA-TYPE            TO PARM-DATA-TYPE           . 
CVT000     MOVE LINK-METER-NO             TO PARM-METER-NO            . 
CVT000     MOVE LINK-PREMISE-NO           TO PARM-PREMISE-NO          . 
CVT000     MOVE LINK-SERV-ORDER-NO        TO PARM-SERV-ORDER-NO       . 
CVT000     MOVE LINK-CODE-UTIL-TYPE       TO PARM-CODE-UTIL-TYPE      . 
CVT000     MOVE LINK-IC-NO                TO PARM-IC-NO               . 
CVT000     MOVE LINK-METER-REF-NO         TO PARM-METER-REF-NO        . 
CVT000     MOVE LINK-ORDER-REASON         TO PARM-ORDER-REASON        . 
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     CALLS 1100-RECEIVE-PARMS                                   *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           UNSTRING PARM-ACCOUNT-NO DELIMITED BY SPACES                 
                                      INTO WS-HOLD-ACCOUNT-NO.          
           MOVE WS-HOLD-ACCOUNT-NO    TO WS-ACCOUNT-NO.                 
           UNSTRING PARM-PREMISE-NO DELIMITED BY SPACES                 
                                      INTO WS-HOLD-PREMISE-NO.          
           MOVE WS-HOLD-PREMISE-NO    TO WS-PREMISE-NO.                 
           MOVE PARM-METER-NO         TO WS-METER-NO.                   
           MOVE PARM-DATA-TYPE        TO WS-DATA-TYPE.                  
           MOVE PARM-SERV-ORDER-NO    TO WS-SERV-ORDER-NO.              
           MOVE WS-SERV-ORDER-NO-NUM  TO VO-SERV-ORDER-NO.              
           MOVE PARM-CODE-UTIL-TYPE   TO WS-CODE-UTIL-TYPE.             
           UNSTRING PARM-IC-NO      DELIMITED BY SPACES                 
                                      INTO WS-HOLD-IC-NO.               
           MOVE WS-HOLD-IC-NO         TO WS-IC-NO.                      
           UNSTRING PARM-METER-REF-NO DELIMITED BY SPACES               
                                      INTO WS-HOLD-METER-REF-NO.        
           MOVE WS-HOLD-METER-REF-NO  TO WS-METER-REF-NO.               
           MOVE PARM-ORDER-REASON(1:1) TO WS-ORDER-REASON.              
      *    UNSTRING PARM-CUSTOMER-NO  DELIMITED BY SPACES                       
      *                               INTO WS-HOLD-CUSTOMER-NO.                 
      *    MOVE WS-HOLD-CUSTOMER-NO   TO WS-CUSTOMER-NO.                        
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     CALLS 2100-DESCRIBE-RESULT                                 *        
      *           2300-BUILD-RESULT                                    *        
      *                                                                *        
      *      CALLED FROM 0000-MAINLINE                                 *        
      *                                                                *        
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *        
      *      AND SENDS THEN BACK                                       *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2300-BUILD-RESULT             THRU 2300-EXIT.        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2300-BUILD-RESULT                                              *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *                                                                *        
      *     MAJOR PROCESSING LOOP.                                     *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
       2300-BUILD-RESULT.                                               
           MOVE '2300'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           PERFORM 2350-INITIALIZE-RETURN-FIELDS THRU 2350-EXIT.        
                                                                        
      *    GET SPECIFIC INFO FOR THE CALL                                       
           EVALUATE WS-DATA-TYPE                                        
               WHEN 'METER'                                             
                                                                        
A05317            PERFORM 7300-SELECT-PREMISE    THRU 7300-EXIT         
A05317            MOVE PR-PREM-REF-LATITUDE TO WS-MTR-REF-LATITUDE      
A05317            MOVE PR-PREM-REF-LONGITUDE TO WS-MTR-REF-LONGITUDE    
                  PERFORM 7000-SELECT-MTRD-ENVRNMT     THRU 7000-EXIT   
                  IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                  
                     CONTINUE                                           
                  ELSE                                                  
T22243               PERFORM 7700-SELECT-ACCOUNT-TABLE THRU 7700-EXIT   
T22243               MOVE AT-COMPANY-NO                TO WS-COMPANY-NO 
                     PERFORM 2370-METER-DATA-SELECTION THRU 2370-EXIT   
                  END-IF                                                
                                                                        
               WHEN 'PREM'                                              
                                                                        
                  PERFORM 2380-PREM-DATA-SELECTION     THRU 2380-EXIT   
      *           TPR # 4243 - ATTEMPT TO SELECT METER ENVIRONMENT              
      *           DETAILS FOR THE FIRST HEADER ROW OF THE SO PRINT.             
                  PERFORM 7550-OPEN-MTR-CURSOR         THRU 7550-EXIT   
C35979            IF WS-ACCOUNT-NO > 0                                  
                     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL         
                        PERFORM 7570-FETCH-MTR-CURSOR  THRU 7570-EXIT   
                     END-IF                                             
                     PERFORM 7590-CLOSE-MTR-CURSOR     THRU 7590-EXIT   
                                                                        
      *           TPR # 4273 - ATTEMPT TO SELECT UTILITY ENVIRONMENT            
      *           DETAILS FOR THE FIRST HEADER ROW OF THE SO PRINT.             
                     PERFORM 7510-OPEN-UTL-CURSOR      THRU 7510-EXIT   
                     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL         
                        PERFORM 7520-FETCH-UTL-CURSOR  THRU 7520-EXIT   
                        INSPECT RS-READ-CYCLE                           
                            REPLACING ALL LOW-VALUES BY SPACES          
                     END-IF                                             
                     PERFORM 7530-CLOSE-UTL-CURSOR     THRU 7530-EXIT   
C35979            END-IF                                                
C26305            IF WS-ACCOUNT-NO > 0                                  
C26305                PERFORM 7900-RED-FLAGS           THRU 7900-EXIT   
C26305            ELSE                                                  
C26305                MOVE 'N'             TO RS-RED-FLAG-SAFETY        
C26305                                        RS-RED-FLAG-MAINT         
C26305                                        RS-RED-FLAG-STORM         
C26305            END-IF                                                
C35979            IF WS-ACCOUNT-NO > 0                                  
C32257               PERFORM 7700-SELECT-ACCOUNT-TABLE THRU 7700-EXIT   
C35979            END-IF                                                
                                                                        
               WHEN 'DNP'                                               
                                                                        
                  PERFORM 2390-DNP-DATA-SELECTION      THRU 2390-EXIT   
                                                                        
               WHEN OTHER                                               
                                                                        
                   MOVE 1                          TO RS-RETURN-CODE    
                   MOVE PROGRAM-NAME               TO ABEND-PROGRAM     
                   MOVE 'NO DATA TYPE'             TO ABEND-FUNCTION    
                   MOVE 'NO DATA TYPE'             TO TABLE-1           
                   MOVE 'N'                        TO SEND-DONE-SW      
                   PERFORM 8100-SEND-RESULT        THRU 8100-EXIT       
                   PERFORM 8900-SEND-DONE          THRU 8900-EXIT       
PCR361             PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT       
                                                                        
           END-EVALUATE.                                                
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE              TO RS-RETURN-CODE.   
           PERFORM 8100-SEND-RESULT                THRU 8100-EXIT.      
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2350-INITIALIZE-RETURN-FIELDS                                  *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *                                                                *        
      ******************************************************************        
       2350-INITIALIZE-RETURN-FIELDS.                                   
                                                                        
           MOVE '2350'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           INITIALIZE    RS-RETURN-CODE,                                
                         RS-METER-SIZE-ID,                              
                         RS-METER-LOCK-TYPE,                            
                         RS-METER-POINT-ID,                             
                         RS-METER-WIRES,                                
                         RS-METER-VOLTAGE,                              
                         RS-METER-MAKE,                                 
                         RS-METER-PRESSURE,                             
                         RS-METER-GATE-ID,                              
                         RS-METER-LOC-DESC,                             
                         RS-METER-AMPS,                                 
                         RS-METER-PHASES,                               
                         RS-METER-TYPE,                                 
                         RS-METER-ELE-CO-SIZE,                          
                         RS-METER-GAS-CO-SIZE,                          
                         RS-METER-CONN-TYPE,                            
                         RS-METER-PHASE-CD,                             
                         RS-SUBDIVISION-DESC,                           
                         RS-NO-DNP,                                     
                         RS-CREDIT-GROUP,                               
                         RS-TOTAL-DEPOSIT-AMT,                          
                         RS-LAST-PAY-AMOUNT,                            
                         RS-ARREARS-HISTORY,                            
                         RS-EX-CREDIT-HIST,                             
                         RS-DAYS-ARREARS2,                              
                         RS-ARREARS-BALANCE,                            
                         RS-BANKR-IND,                                  
                         RS-CRITICAL-CUST,                              
                         RS-NO-RTN-CHECKS,                              
                         RS-CASH-ONLY-FLAG,                             
                         RS-LAST-PAY-DATE,                              
                         RS-SECOND-N-DATE,                              
                         RS-CREDIT-HISTORY,                             
                         RS-DAYS-ARREARS1,                              
                         RS-DAYS-ARREARS3,                              
                         RS-PAST-DUE-AMT,                               
                         RS-BALANCE-TOTAL,                              
                         RS-KEY-CUSTOMER,                               
T18194                   RS-BLOCK,                                      
T18194                   RS-LOT,                                        
                         RS-DPP,                                        
T19430                   RS-AMT-PAST-DUE-NONUTL,                        
C23235                   RS-CURR-CHGS-UTL,                              
C23235                   RS-AMT-PAST-DUE-UTL,                           
C23235                   RS-CURR-CHGS-NONUTL,                           
C23235                   RS-GUAR-PAST-DUE-AMT,                          
C23235                   RS-DATE-NOTICE-DUE-C,                          
C25553                   RS-DATE-NOTICE-DUE-F,                          
                         RS-METER-MFG-SN                                
C26305                   RS-RED-FLAG-SAFETY                             
C26305                   RS-RED-FLAG-MAINT                              
C26305                   RS-RED-FLAG-STORM                              
C24056                   RS-GRID-CELL-TX                                
C24056                   RS-SUBSTATION-ID                               
C24056                   RS-CIRCUIT-ID,                                 
C34361                   RS-XS-FLOW-VALVE-FL,                           
C34361                   RS-SPLIT-SERVICE-FL,                           
                         RS-MTR-REF-LATITUDE,                           
                         RS-MTR-REF-LONGITUDE                           
C32257                   RS-CODE-ACCT-STAT.                             
                                                                        
           MOVE SPACES           TO RS-DIRECTIONS-TEXT.                 
CVT000*    MOVE ZEROS            TO RS-DIRECTIONS-LEN.                          
                                                                        
           MOVE SPACES           TO RS-SPCL-READ-INST-TEXT.             
CVT000*    MOVE ZEROS            TO RS-SPCL-READ-INST-LEN.                      
                                                                        
           MOVE SPACES           TO RS-SPCL-INST-TEXT.                  
CVT000*    MOVE ZEROS            TO RS-SPCL-INST-LEN.                           
                                                                        
       2350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2350-METER-DATA-SELECTION                                      *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *                                                                *        
      ******************************************************************        
       2370-METER-DATA-SELECTION.                                       
                                                                        
           MOVE '2370'                          TO ACTIVE-PARAGRAPH.    
C24056     IF MN-GIS-POINT-ID > 0                                       
C24056         PERFORM 7025-SELECT-SNE-POINT      THRU 7025-EXIT
           END-IF.       
           PERFORM 7050-SELECT-METER-LOC          THRU 7050-EXIT.       
           PERFORM 7100-SELECT-LOCK-TYPE          THRU 7100-EXIT.       
           IF WS-CODE-UTIL-TYPE  = 'E'                                  
               PERFORM 7150-SELECT-ELEC-METER     THRU 7150-EXIT        
C19877         PERFORM 7160-SELECT-MTR-CL-AMPS    THRU 7160-EXIT        
               MOVE MN-ELEC-PHASE-CD       TO WS-METER-PHASE-CD         
           ELSE                                                         
               IF WS-CODE-UTIL-TYPE = 'G'                               
                   PERFORM 7200-SELECT-GAS-METER  THRU 7200-EXIT        
                   PERFORM 7300-SELECT-PREMISE    THRU 7300-EXIT        
P00480             PERFORM 7325-GET-MA-ACCESS-CD  THRU 7325-EXIT        
                   MOVE PR-CITY-GATE-ID    TO WS-METER-GATE-ID          
               END-IF                                                   
           END-IF.                                                      
                                                                        
           MOVE 0                          TO WS-ACTIVE-RETURN-CODE.    
           MOVE WS-METER-SIZE-ID           TO RS-METER-SIZE-ID.         
           MOVE WS-METER-LOCK-TYPE         TO RS-METER-LOCK-TYPE.       
C24056*    MOVE WS-METER-POINT-ID          TO RS-METER-POINT-ID.                
           MOVE WS-REGISTER-RD-SEQ         TO RS-REGISTER-RD-SEQ.       
TP5489     MOVE WS-MAX-NO-UNITS            TO RS-MAX-NO-UNITS.          
TP5489     MOVE WS-MIN-NO-UNITS            TO RS-MIN-NO-UNITS.          
           MOVE WS-METER-WIRES             TO RS-METER-WIRES.           
           MOVE WS-METER-VOLTAGE           TO RS-METER-VOLTAGE.         
           MOVE WS-METER-MAKE              TO RS-METER-MAKE.            
           MOVE WS-METER-PRESSURE          TO RS-METER-PRESSURE.        
           MOVE WS-MTR-REF-LATITUDE        TO RS-MTR-REF-LATITUDE.      
           MOVE WS-MTR-REF-LONGITUDE       TO RS-MTR-REF-LONGITUDE.     
           MOVE WS-METER-GATE-ID           TO RS-METER-GATE-ID.         
           MOVE WS-METER-LOC-DESC          TO RS-METER-LOC-DESC.        
           MOVE WS-METER-AMPS              TO RS-METER-AMPS.            
           MOVE WS-METER-PHASES            TO RS-METER-PHASES.          
           MOVE WS-METER-ELE-CO-SIZE       TO RS-METER-ELE-CO-SIZE.     
           MOVE WS-METER-GAS-CO-SIZE       TO RS-METER-GAS-CO-SIZE.     
           MOVE WS-METER-CONN-TYPE         TO RS-METER-CONN-TYPE.       
           MOVE WS-METER-PHASE-CD          TO RS-METER-PHASE-CD.        
           MOVE WS-METER-MFG-SN            TO RS-METER-MFG-SN.          
                                                                        
       2370-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2380-PREM-DATA-SELECTION                                       *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *                                                                *        
      ******************************************************************        
       2380-PREM-DATA-SELECTION.                                        
                                                                        
           MOVE '2380'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           PERFORM 7300-SELECT-PREMISE        THRU 7300-EXIT.           
P00480     PERFORM 7325-GET-MA-ACCESS-CD      THRU 7325-EXIT.           
P35979     MOVE  PR-COMPANY-NO        TO    B0-COMPANY-NO               
           PERFORM 7350-SELECT-SUBDIVISION    THRU 7350-EXIT.           
C35979*    PERFORM 7360-SELECT-PREM-DLVRY     THRU 7360-EXIT                    
C35979     MOVE PARM-SERV-ORDER-NO            TO XX-SERV-ORDER-NO.      
C35979     PERFORM 7360-SELECT-XSFLW-SPLSVC   THRU 7360-EXIT.           
C35979     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR                      
C35979        WS-ACTIVE-RETURN-CODE = -811                              
C35979        PERFORM 7365-GET-XSFLW-SPLSVC   THRU 7365-EXIT            
C35979     END-IF.                                                      
                                                                        
      *    TPR #4320 - COMMENTED OUT CURSOR ROUTINE.                            
      *    NOTE: THIS ROUTINE WAS ONLY CALLED IN ORDER TO OBTAIN THE            
      *    CRITICAL CUSTOMER INDICATOR, WHICH WAS BEING PERFORMED               
      *    INCORRECTLY.  THE CRITICAL CUSTOMER INDICATOR IS THE                 
      *    CODE_CRIT_OUTAGE ON CSS_ACCOUNT, NOT THE CRITICAL_CUST_IND           
      *    ON CSS_DNP.                                                          
      *                                                                         
      *    IF WS-CRITICAL-CUST = 'Y'                                            
      *        CONTINUE                                                         
      *    ELSE                                                                 
      *        MOVE 'N'                       TO WS-CRITICAL-CUST               
      *    END-IF.                                                              
           PERFORM 7680-SELECT-CRIT-CUSTOMER  THRU 7680-EXIT.           
                                                                        
           MOVE 0                             TO WS-ACTIVE-RETURN-CODE. 
           MOVE PR-PREMISE-DIRECTIONS-TEXT    TO RS-DIRECTIONS-TEXT.    
           INSPECT RS-DIRECTIONS-TEXT                                   
               REPLACING ALL LOW-VALUES BY SPACES.                      
CVT000*    MOVE PR-PREMISE-DIRECTIONS-LEN     TO RS-DIRECTIONS-LEN.             
           MOVE PR-SPCL-READ-INSTR-TEXT       TO RS-SPCL-READ-INST-TEXT.
           INSPECT RS-SPCL-READ-INST-TEXT                               
               REPLACING ALL LOW-VALUES BY SPACES.                      
CVT000*    MOVE PR-SPCL-READ-INSTR-LEN        TO RS-SPCL-READ-INST-LEN.         
P00480     IF WS-ORDER-SPCL-INST > SPACES                               
P00480     STRING WS-ORDER-SPCL-INST  DELIMITED BY '    '               
P00480            ' ' DELIMITED BY SIZE                                 
P00480            PR-SPCL-INSTRUCTIONS-TEXT DELIMITED BY '   '          
P00480      INTO RS-SPCL-INST-TEXT                                      
P00480     END-STRING                                                   
P00480     ELSE                                                         
           MOVE PR-SPCL-INSTRUCTIONS-TEXT     TO RS-SPCL-INST-TEXT
           END-IF.     
           INSPECT RS-SPCL-INST-TEXT                                    
               REPLACING ALL LOW-VALUES BY SPACES.                      
CVT000*    MOVE PR-SPCL-INSTRUCTIONS-LEN      TO RS-SPCL-INST-LEN.              
           MOVE WS-SUBDIVISION-DESC           TO RS-SUBDIVISION-DESC.   
T18194     MOVE PR-BLOCK                      TO RS-BLOCK.              
T18194     MOVE PR-LOT                        TO RS-LOT.                
C34361     IF WS-XS-FLOW-VALVE-FL        EQUAL 'Y'                      
C34361        MOVE WS-XS-FLOW-VALVE-FL           TO RS-XS-FLOW-VALVE-FL 
C34361     ELSE                                                         
C34361        MOVE 'N'                           TO RS-XS-FLOW-VALVE-FL 
C34361     END-IF.                                                      
C34361     IF WS-SPLIT-SERVICE-FL        EQUAL 'Y'                      
C34361        MOVE WS-SPLIT-SERVICE-FL           TO RS-SPLIT-SERVICE-FL 
C34361     ELSE                                                         
C34361        MOVE 'N'                           TO RS-SPLIT-SERVICE-FL 
C34361     END-IF.                                                      
                                                                        
       2380-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2390-DNP-DATA-SELECTION                                        *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *                                                                *        
      ******************************************************************        
       2390-DNP-DATA-SELECTION.                                         
                                                                        
           MOVE '2390'                     TO ACTIVE-PARAGRAPH.         
                                                                        
      *    TPR #4320 - COMMENTED OUT CURSOR ROUTINE.                            
      *    NOTE: THIS ROUTINE WAS ONLY CALLED IN ORDER TO OBTAIN THE            
      *    CREDIT GROUP AND KEY CUSTOMER INFORMATION, WHICH WAS BEING           
      *    PERFORMED INCORRECTLY.  THE CREDIT GROUP SHOULD HAVE BEEN            
      *    OBTAINED FOR CSS_ACCOUNT AND THE KEY CUSTOMER SHOULD HAVE            
      *    BEEN OBTAINED FROM CSS_CUST_MISC_INFO.                               
                                                                        
           PERFORM 7450-SELECT-CREDIT-PROFILE     THRU 7450-EXIT.       
           PERFORM 2400-CALC-NO-OF-DNPS           THRU 2400-EXIT.       
           PERFORM 7500-SELECT-CRED-COLL          THRU 7500-EXIT.       
                                                                        
           PERFORM 7600-OPEN-AR-CURSOR            THRU 7600-EXIT.       
           PERFORM 7620-FETCH-AR-CURSOR           THRU 7620-EXIT.       
           PERFORM 7640-CLOSE-AR-CURSOR           THRU 7640-EXIT.       
                                                                        
           PERFORM 7650-SELECT-DEP-ON-HAND        THRU 7650-EXIT.       
           PERFORM 7670-SELECT-GUARANTOR          THRU 7670-EXIT.       
           PERFORM 7690-SELECT-SURETY-BONDS       THRU 7690-EXIT.       
           ADD WS-AMT-DEPOSIT WS-AMOUNT-GUARANTEED WS-AMT-BOND          
                                           TO WS-TOTAL-DEPOSIT-AMT.     
                                                                        
           PERFORM 7700-SELECT-ACCOUNT-TABLE      THRU 7700-EXIT.       
                                                                        
C23235     MOVE AT-COMPANY-NO    TO WS-COMPANY-NO.                      
                                                                        
C23235     IF WS-COMPANY-NO = '26'                                      
C23235        MOVE 'Y'           TO WS-LOAD-GUARANTOR-XFER-AMT-SW       
C23235     END-IF.                                                      
                                                                        
PCR361     MOVE 'Y'              TO CALC-ARREARS-SW                     
PCR361                              CALC-BALANCE-SW                     
PCR361                              CALC-PAST-DUE-SW.                   
                                                                        
T22359     MOVE PROGRAM-NAME               TO WS-CPD00068-CALLING-PGM.  
T19557     PERFORM 9500-CALL-CPD00068      THRU 9500-EXIT.              
T19557     IF ABEND-FUNCTION  > SPACES                                  
T19557        PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
T19557     END-IF.                                                      
           PERFORM 2450-CALC-NO-OF-RET-CHKS       THRU 2450-EXIT.       
TP5024     PERFORM 7660-SELECT-CUST-MISC          THRU 7660-EXIT.       
                                                                        
           MOVE 0                          TO WS-ACTIVE-RETURN-CODE.    
           MOVE WS-NO-DNP-CNT              TO RS-NO-DNP.                
           MOVE WS-CREDIT-GROUP            TO RS-CREDIT-GROUP.          
           MOVE WS-TOTAL-DEPOSIT-AMT       TO RS-TOTAL-DEPOSIT-AMT.     
           MOVE WS-AMT-ORIG-ENTERED        TO RS-LAST-PAY-AMOUNT.       
           MOVE WS-ARREARS-HISTORY         TO RS-ARREARS-HISTORY.       
           MOVE WS-EX-CREDIT-HIST          TO RS-EX-CREDIT-HIST.        
           MOVE WS-AMT-60-DAY              TO RS-DAYS-ARREARS2.         
           MOVE WS-AMT-ARREARS             TO RS-ARREARS-BALANCE.       
           MOVE WS-BANKR-IND               TO RS-BANKR-IND.             
           MOVE WS-RET-CHK-CNT-NO          TO RS-NO-RTN-CHECKS.         
           MOVE WS-CASH-ONLY-FLAG          TO RS-CASH-ONLY-FLAG.        
           MOVE WS-LAST-PAY-DATE           TO RS-LAST-PAY-DATE.         
           MOVE WS-SECOND-N-DATE           TO RS-SECOND-N-DATE.         
           MOVE WS-CREDIT-HISTORY          TO RS-CREDIT-HISTORY.        
           MOVE WS-AMT-30-DAY              TO RS-DAYS-ARREARS1.         
           MOVE WS-AMT-90-DAY              TO RS-DAYS-ARREARS3.         
           MOVE WS-AMT-PAST-DUE            TO RS-PAST-DUE-AMT.          
           MOVE WS-TOTAL-BALANCE           TO RS-BALANCE-TOTAL.         
           MOVE WS-KEY-CUSTOMER            TO RS-KEY-CUSTOMER.          
           MOVE WS-DPP                     TO RS-DPP.                   
T23345     MOVE WS-AMT-PAST-DUE-NONUTL     TO RS-AMT-PAST-DUE-NONUTL.   
C23235     MOVE WS-CURR-CHARGES-UTL        TO RS-CURR-CHGS-UTL.         
C23235     MOVE WS-AMT-PAST-DUE-UTL        TO RS-AMT-PAST-DUE-UTL.      
C23235     MOVE WS-CURR-CHARGES-NONUTL     TO RS-CURR-CHGS-NONUTL.      
C23235     MOVE WS-GUAR-PAST-DUE-AMT       TO RS-GUAR-PAST-DUE-AMT.     
C23235     MOVE WS-DATE-NOTICE-DUE-C       TO RS-DATE-NOTICE-DUE-C.     
C25553     MOVE WS-DATE-NOTICE-DUE-F       TO RS-DATE-NOTICE-DUE-F.     
           INSPECT RS-DATE-NOTICE-DUE-C                                 
               REPLACING ALL LOW-VALUES BY SPACES.                      
           INSPECT RS-DATE-NOTICE-DUE-F                                 
               REPLACING ALL LOW-VALUES BY SPACES.                      
           INSPECT RS-LAST-PAY-DATE                                     
               REPLACING ALL LOW-VALUES BY SPACES.                      
           INSPECT RS-SECOND-N-DATE                                     
               REPLACING ALL LOW-VALUES BY SPACES.                      
           INSPECT RS-EX-CREDIT-HIST                                    
               REPLACING ALL LOW-VALUES BY SPACES.                      
                                                                        
       2390-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2400-CALC-NO-OF-DNPS                                           *        
      *                                                                *        
      *   CALLS NOTHING                                                *        
      *                                                                *        
      *   CALLED FROM 2300-BUILD-RESULT                                *        
      *                                                                *        
      *   BREAKDOWN THE DISCONNECT HISTORY AND THE DISCONNECT          *        
      *   EXCEPTIONAL HISTORY. EACH IS A SERIES OF 24 CODES            *        
      *   REPRESENTING THE LAST 24 MONTHS. A 4 INDICATES A DNP.        *        
      *   WE ARE ONLY CHECKING THE PREVIOUS YEAR.                      *        
      ******************************************************************        
       2400-CALC-NO-OF-DNPS.                                            
                                                                        
           MOVE WS-CREDIT-HISTORY   TO WS-DISC-HIST.                    
           MOVE WS-EX-CREDIT-HIST   TO WS-EXCEPTIONAL-HIST.             
           MOVE 0                   TO WS-NO-DNP-CNT.                   
           MOVE 1                   TO WS-PREV-MNTH.                    
                                                                        
           PERFORM UNTIL WS-PREV-MNTH > 12                              
                                                                        
              IF WS-DISC-HIST-BRKDWN(WS-PREV-MNTH) = WS-FOUR            
                 ADD 1 TO WS-NO-DNP-CNT                                 
              END-IF                                                    
                                                                        
              IF WS-EXCEPTIONAL-HIST-BRKDWN(WS-PREV-MNTH) = WS-FOUR     
                 ADD 1 TO WS-NO-DNP-CNT                                 
              END-IF                                                    
                                                                        
              ADD 1 TO WS-PREV-MNTH                                     
                                                                        
           END-PERFORM.                                                 
                                                                        
      *    MOVE WS-NO-DNP-CNT                   TO WS-NO-DNP.                   
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2450-CALC-NO-OF-RET-CHKS                                       *        
      *                                                                *        
PCR361*   CALLS 9700-PROCESS-ABEND                                     *        
      *                                                                *        
      *   CALLED FROM 2300-BUILD-RESULT                                *        
      *                                                                *        
      *   COUNTS THE NUMBER OF RETURNED CHECKS/DRAFTS IN THE LAST      *        
      *   YEAR.                                                        *        
      ******************************************************************        
       2450-CALC-NO-OF-RET-CHKS.                                        
                                                                        
           MOVE '2450'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           PERFORM 7800-CALCULATE-ONE-YEAR-AGO    THRU 7800-EXIT.       
                                                                        
           EXEC SQL                                                     
              SELECT COUNT(*)                                           
              INTO  :WS-RET-CHK-CNT-NO                                  
              FROM   CSS_NSF_HIST WITH(READUNCOMMITTED)                         
              WHERE  ACCOUNT_NO      = :WS-ACCOUNT-NO                   
              AND    NSF_STATUS_CD   = 'C'                              
              AND    DATE_TRAN       > IIF(TRY_CONVERT(DATE, 
                                                       :WS-ONE-YEAR-AGO
              ) IS NULL OR (PATINDEX('%.%', :WS-ONE-YEAR-AGO
              ) <> 0) OR (LEN(:WS-ONE-YEAR-AGO) <> 10), CIS.CHAR2DATE(
                                                       :WS-ONE-YEAR-AGO
              ), CONVERT(DATE, :WS-ONE-YEAR-AGO) )                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(*)                                                   
MFA-TR*       INTO  :WS-RET-CHK-CNT-NO                                          
MFA-TR*       FROM   CSS_NSF_HIST                                               
MFA-TR*       WHERE  ACCOUNT_NO      = :WS-ACCOUNT-NO                           
MFA-TR*       AND    NSF_STATUS_CD   = 'C'                                      
MFA-TR*       AND    DATE_TRAN       > :WS-ONE-YEAR-AGO                         
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
           OR                         NOT-FOUND                         
ADAM          MOVE WS-RET-CHK-CNT-NO             TO WS-RET-CHK-CNT      
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_NSF_HIST'             TO TABLE-1                
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE 'DATE_TRAN'                TO TABLE-ELEMENT-2        
CBSI          MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE WS-ONE-YEAR-AGO            TO HOSTVAR-ELEMENT-2      
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       2450-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *                                                                         
      ******************************************************************        
      * 7000-SELECT-MTRD-ENVRNMT                                       *        
PCR361*     CALLS       9700-PROCESS-ABEND                             *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      ******************************************************************        
       7000-SELECT-MTRD-ENVRNMT.                                        
                                                                        
           MOVE '7000'                           TO ACTIVE-PARAGRAPH.   
                                                                        
           EXEC SQL                                                     
               SELECT CODE_METER_LOC,                                   
                      LOCK_TYPE_ID,                                     
                      ELEC_PHASE_CD,                                    
                      POINT_ID,                                         
                      REGISTER_RD_SEQ,                                  
                      MAX_NO_UNITS,                                     
                      MIN_NO_UNITS,                                     
                      GIS_POINT_ID,                                     
C30989                METER_PRESSURE,                                   
                      MTR_REF_LATITUDE,                                 
                      MTR_REF_LONGITUDE                                 
                 INTO :MN-CODE-METER-LOC,                               
                      :MN-LOCK-TYPE-ID,                                 
                      :MN-ELEC-PHASE-CD,                                
                      :MN-POINT-ID,                                     
                      :MN-REGISTER-RD-SEQ,                              
TP5489                :MN-MAX-NO-UNITS,                                 
TP5489                :MN-MIN-NO-UNITS,                                 
C24056                :MN-GIS-POINT-ID,                                 
C30989                :MN-METER-PRESSURE,                               
                      :MN-MTR-REF-LATITUDE,                             
                      :MN-MTR-REF-LONGITUDE                             
                                                                        
                FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO    = :WS-ACCOUNT-NO                    
                  AND CODE_UTIL_TYPE= :WS-CODE-UTIL-TYPE                
                  AND MTR_REF_NO    = :WS-METER-REF-NO                  
                  AND IC_NO         = :WS-IC-NO                         
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODE_METER_LOC,                                           
MFA-TR*               LOCK_TYPE_ID,                                             
MFA-TR*               ELEC_PHASE_CD,                                            
MFA-TR*               POINT_ID,                                                 
MFA-TR*               REGISTER_RD_SEQ,                                          
MFA-TR*               MAX_NO_UNITS,                                             
MFA-TR*               MIN_NO_UNITS,                                             
MFA-TR*               GIS_POINT_ID,                                             
MFA-TR*               METER_PRESSURE,                                           
MFA-TR*               MTR_REF_LATITUDE,                                         
MFA-TR*               MTR_REF_LONGITUDE                                         
MFA-TR*          INTO :MN-CODE-METER-LOC,                                       
MFA-TR*               :MN-LOCK-TYPE-ID,                                         
MFA-TR*               :MN-ELEC-PHASE-CD,                                        
MFA-TR*               :MN-POINT-ID,                                             
MFA-TR*               :MN-REGISTER-RD-SEQ,                                      
MFA-TR*               :MN-MAX-NO-UNITS,                                         
MFA-TR*               :MN-MIN-NO-UNITS,                                         
MFA-TR*               :MN-GIS-POINT-ID,                                         
MFA-TR*               :MN-METER-PRESSURE,                                       
MFA-TR*               :MN-MTR-REF-LATITUDE,                                     
MFA-TR*               :MN-MTR-REF-LONGITUDE                                     
MFA-TR*                                                                         
MFA-TR*         FROM CSS_MTRD_ENVRNMT                                           
MFA-TR*         WHERE ACCOUNT_NO    = :WS-ACCOUNT-NO                            
MFA-TR*           AND CODE_UTIL_TYPE= :WS-CODE-UTIL-TYPE                        
MFA-TR*           AND MTR_REF_NO    = :WS-METER-REF-NO                          
MFA-TR*           AND IC_NO         = :WS-IC-NO                                 
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
ADAM          MOVE MN-CODE-METER-LOC          TO WS-CODE-METER-LOC      
ADAM          MOVE MN-LOCK-TYPE-ID            TO WS-LOCK-TYPE-ID        
ADAM          MOVE MN-POINT-ID                TO WS-METER-POINT-ID      
ADAM          MOVE MN-REGISTER-RD-SEQ         TO WS-REGISTER-RD-SEQ     
C30989        MOVE MN-METER-PRESSURE          TO WS-METER-PRESSURE      
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_MTRD_ENVRNMT'         TO TABLE-1                
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
CBSI          MOVE 'MTR_REF_NO'               TO TABLE-ELEMENT-3        
CBSI          MOVE 'IC_NO'                    TO TABLE-ELEMENT-4        
CBSI          MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE WS-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
CBSI          MOVE WS-METER-REF-NO            TO HOSTVAR-ELEMENT-3      
CBSI          MOVE WS-IC-NO                   TO HOSTVAR-ELEMENT-4      
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
TP5648     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
TP5648       IF MN-MAX-NO-UNITS > ZEROES                                
TP5489          MOVE MN-MAX-NO-UNITS               TO WS-MAX-NO-UNITS   
TP5648       ELSE                                                       
TP5489          MOVE ZEROES                        TO WS-MAX-NO-UNITS   
TP5648       END-IF                                                     
TP5648       IF MN-MIN-NO-UNITS > ZEROES                                
TP5489          MOVE MN-MIN-NO-UNITS               TO WS-MIN-NO-UNITS   
TP5648       ELSE                                                       
TP5489          MOVE ZEROES                        TO WS-MIN-NO-UNITS   
TP5648       END-IF                                                     
TP5648     ELSE                                                         
TP5648       IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                       
                MOVE ZEROES                  TO WS-MTR-REF-LATITUDE     
                MOVE ZEROES                  TO WS-MTR-REF-LONGITUDE    
TP5648          MOVE ZEROES                  TO WS-MAX-NO-UNITS         
TP5489          MOVE ZEROES                  TO WS-MIN-NO-UNITS         
TP5648       END-IF                                                     
TP5648     END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
C24056 7025-SELECT-SNE-POINT.                                           
C24056                                                                  
C24056     MOVE '7025'                        TO ACTIVE-PARAGRAPH.      
C24056                                                                  
C24056     EXEC SQL                                                     
C33743         SELECT AREA_ID,                                          
C24056                TAG_NM,                                           
C29562                COALESCE(GRID_CELL_TX,'000000-000'),                
C29562                COALESCE(SUBSTATION_ID,'     '),                    
C29562                COALESCE(CIRCUIT_ID, '     ')                       
C33743           INTO :PP-AREA-ID,                                      
C33743                :PP-TAG-NM,                                       
C33743                :PP-GRID-CELL-TX,                                 
C33743                :PP-SUBSTATION-ID,                                
C33743                :PP-CIRCUIT-ID                                    
C33743           FROM CSS_PIM_POINT WITH(READUNCOMMITTED)                       
C24056          WHERE POINT_ID = :MN-GIS-POINT-ID                       
                                                                 
C24056     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AREA_ID,                                                  
MFA-TR*               TAG_NM,                                                   
MFA-TR*               IFNULL(GRID_CELL_TX,'000000-000'),                        
MFA-TR*               IFNULL(SUBSTATION_ID,'     '),                            
MFA-TR*               IFNULL(CIRCUIT_ID, '     ')                               
MFA-TR*          INTO :PP-AREA-ID,                                              
MFA-TR*               :PP-TAG-NM,                                               
MFA-TR*               :PP-GRID-CELL-TX,                                         
MFA-TR*               :PP-SUBSTATION-ID,                                        
MFA-TR*               :PP-CIRCUIT-ID                                            
MFA-TR*          FROM CSS_PIM_POINT                                             
MFA-TR*         WHERE POINT_ID = :MN-GIS-POINT-ID                               
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C24056                                                                  
C24056     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
C24056                                                                  
C24056     EVALUATE WS-ACTIVE-RETURN-CODE                               
C24056         WHEN SUCCESSFUL-CALL                                     
C33743             MOVE PP-AREA-ID        TO RS-METER-POINT-ID(1:3)     
C33743             MOVE PP-TAG-NM         TO RS-METER-POINT-ID(4:7)     
C33743             MOVE PP-GRID-CELL-TX   TO RS-GRID-CELL-TX            
C33743             MOVE PP-SUBSTATION-ID  TO RS-SUBSTATION-ID           
C33743             MOVE PP-CIRCUIT-ID     TO RS-CIRCUIT-ID              
C24056         WHEN NOT-FOUND                                           
C24056             MOVE SPACES         TO RS-METER-POINT-ID(1:3)        
C24056                                    RS-METER-POINT-ID(4:7)        
C24056                                    RS-GRID-CELL-TX               
C24056                                    RS-SUBSTATION-ID              
C24056                                    RS-CIRCUIT-ID                 
C24056         WHEN OTHER                                               
C24056             MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
C24056             MOVE 'SELECT'              TO ABEND-FUNCTION         
C33743             MOVE 'CSS_PIM_POINT'       TO TABLE-1                
C24056             MOVE 'POINT_ID'            TO TABLE-ELEMENT-1        
C24056             MOVE MN-GIS-POINT-ID       TO HOSTVAR-ELEMENT-1      
C24056             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
C24056     END-EVALUATE.                                                
C24056                                                                  
C24056 7025-EXIT.                                                       
C24056     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7050-SELECT-METER-LOC                                          *        
PCR361*     CALLS       9700-PROCESS-ABEND                             *        
      *                                                                *        
      ******************************************************************        
       7050-SELECT-METER-LOC.                                           
                                                                        
           MOVE '7050'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               SELECT METER_LOC_DESC                                    
                 INTO :Q4-METER-LOC-DESC                                
                 FROM CSS_METER_LOC WITH(READUNCOMMITTED)                       
                WHERE CODE_METER_LOC  = :WS-CODE-METER-LOC              
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT METER_LOC_DESC                                            
MFA-TR*          INTO :Q4-METER-LOC-DESC                                        
MFA-TR*          FROM CSS_METER_LOC                                             
MFA-TR*         WHERE CODE_METER_LOC  = :WS-CODE-METER-LOC                      
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
ADAM               MOVE Q4-METER-LOC-DESC        TO WS-METER-LOC-DESC   
               WHEN NOT-FOUND                                           
                   MOVE SPACES                   TO WS-METER-LOC-DESC   
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
CBSI               MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_METER_LOC'       TO TABLE-1                
CBSI               MOVE 'CODE_METER_LOC'      TO TABLE-ELEMENT-1        
CBSI               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2        
CBSI               MOVE WS-CODE-METER-LOC     TO HOSTVAR-ELEMENT-1      
CBSI               MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2      
PCR361             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-SELECT-LOCK-TYPE                                          *        
PCR361*     CALLS       9700-PROCESS-ABEND                             *        
      *                                                                *        
      ******************************************************************        
       7100-SELECT-LOCK-TYPE.                                           
                                                                        
           MOVE '7100'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               SELECT    LOCK_TYPE_DESC                                 
               INTO      :B3-LOCK-TYPE-DESC                             
               FROM      CSS_LOCK_TYPE WITH(READUNCOMMITTED)                    
               WHERE     LOCK_TYPE_ID       = :WS-LOCK-TYPE-ID          
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT    LOCK_TYPE_DESC                                         
MFA-TR*        INTO      :B3-LOCK-TYPE-DESC                                     
MFA-TR*        FROM      CSS_LOCK_TYPE                                          
MFA-TR*        WHERE     LOCK_TYPE_ID       = :WS-LOCK-TYPE-ID                  
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
ADAM               MOVE B3-LOCK-TYPE-DESC        TO WS-METER-LOCK-TYPE  
               WHEN NOT-FOUND                                           
                   MOVE SPACES                   TO WS-METER-LOCK-TYPE  
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
CBSI               MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_LOCK_TYPE'       TO TABLE-1                
CBSI               MOVE 'LOCK_TYPE_ID'        TO TABLE-ELEMENT-1        
CBSI               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2        
CBSI               MOVE WS-LOCK-TYPE-ID       TO HOSTVAR-ELEMENT-1      
CBSI               MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2      
PCR361             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7150-SELECT-ELEC-METER                                         *        
PCR361*     CALLS       9700-PROCESS-ABEND                             *        
      *                                                                *        
      ******************************************************************        
       7150-SELECT-ELEC-METER.                                          
                                                                        
           MOVE '7150'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           EXEC SQL                                                     
              SELECT A.METER_SIZE_ID,                                   
                     A.NO_WIRES,                                        
                     A.NO_PHASES,                                       
                     A.VOLTAGE,                                         
                     A.ELEC_MTR_CLASS_CD,                               
                     A.ELEC_MTR_SPEC_CD,                                
                     B.CODE_MAKE,                                       
                     B.SERIAL_NO                                        
                INTO :EM-METER-SIZE-ID,                                 
                     :EM-NO-WIRES,                                      
                     :EM-NO-PHASES,                                     
                     :EM-VOLTAGE,                                       
                     :EM-ELEC-MTR-CLASS-CD,                             
                     :EM-ELEC-MTR-SPEC-CD,                              
                     :EQ-CODE-MAKE,                                     
                     :EQ-SERIAL-NO                                      
                FROM CSS_ELEC_METER A WITH(READUNCOMMITTED),                    
                     CSS_EQUIPMENT  B WITH(READUNCOMMITTED)                     
               WHERE A.CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE          
T22243           AND A.COMPANY_NO         = :WS-COMPANY-NO              
T22243           AND A.COMPANY_NO         = B.COMPANY_NO                
                 AND A.CODE_UTIL_TYPE     = B.CODE_UTIL_TYPE            
                 AND A.METER_NO           = :WS-METER-NO                
                 AND A.METER_NO           = B.DEVICE_NO                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT A.METER_SIZE_ID,                                           
MFA-TR*              A.NO_WIRES,                                                
MFA-TR*              A.NO_PHASES,                                               
MFA-TR*              A.VOLTAGE,                                                 
MFA-TR*              A.ELEC_MTR_CLASS_CD,                                       
MFA-TR*              A.ELEC_MTR_SPEC_CD,                                        
MFA-TR*              B.CODE_MAKE,                                               
MFA-TR*              B.SERIAL_NO                                                
MFA-TR*         INTO :EM-METER-SIZE-ID,                                         
MFA-TR*              :EM-NO-WIRES,                                              
MFA-TR*              :EM-NO-PHASES,                                             
MFA-TR*              :EM-VOLTAGE,                                               
MFA-TR*              :EM-ELEC-MTR-CLASS-CD,                                     
MFA-TR*              :EM-ELEC-MTR-SPEC-CD,                                      
MFA-TR*              :EQ-CODE-MAKE,                                             
MFA-TR*              :EQ-SERIAL-NO                                              
MFA-TR*         FROM CSS_ELEC_METER A,                                          
MFA-TR*              CSS_EQUIPMENT  B                                           
MFA-TR*        WHERE A.CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE                  
MFA-TR*          AND A.COMPANY_NO         = :WS-COMPANY-NO                      
MFA-TR*          AND A.COMPANY_NO         = B.COMPANY_NO                        
MFA-TR*          AND A.CODE_UTIL_TYPE     = B.CODE_UTIL_TYPE                    
MFA-TR*          AND A.METER_NO           = :WS-METER-NO                        
MFA-TR*          AND A.METER_NO           = B.DEVICE_NO                         
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
ADAM               MOVE EM-METER-SIZE-ID      TO WS-METER-SIZE-ID       
ADAM               MOVE EM-NO-WIRES           TO WS-METER-WIRES         
PCR040             MOVE SPACES                TO WS-METER-ELE-CO-SIZE   
ADAM               MOVE EM-NO-PHASES          TO WS-METER-PHASES        
ADAM               MOVE EM-VOLTAGE            TO WS-METER-VOLTAGE       
ADAM               MOVE EQ-CODE-MAKE          TO WS-METER-MAKE          
                   MOVE EQ-SERIAL-NO          TO WS-METER-MFG-SN        
               WHEN NOT-FOUND                                           
                   MOVE SPACES                TO WS-METER-SIZE-ID       
                                                 WS-METER-WIRES         
PCR040                                           WS-METER-ELE-CO-SIZE   
                                                 WS-METER-PHASES        
                                                 WS-METER-MAKE          
                                                 WS-METER-MFG-SN        
                   MOVE ZEROES                TO WS-METER-VOLTAGE       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
CBSI               MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_ELEC_METER'      TO TABLE-1                
CBSI               MOVE 'CSS_EQUIPMENT'       TO TABLE-2                
CBSI               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-1        
CBSI               MOVE 'METER_NO'            TO TABLE-ELEMENT-2        
CBSI               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-3        
T22243             MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-4        
CBSI               MOVE WS-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-1      
CBSI               MOVE WS-METER-NO           TO HOSTVAR-ELEMENT-2      
CBSI               MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-3      
T22243             MOVE WS-COMPANY-NO         TO HOSTVAR-ELEMENT-4      
PCR361             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7160-SELECT-MTR-CL-AMPS                                        *        
      *     CALLS       9700-PROCESS-ABEND                             *        
      * CML 19877                                                      *        
      ******************************************************************        
       7160-SELECT-MTR-CL-AMPS.                                         
                                                                        
           MOVE '7160'                   TO ACTIVE-PARAGRAPH.           
                                                                        
           EXEC SQL                                                     
              SELECT CLASS_AMPS                                         
                INTO :U0-CLASS-AMPS                                     
                FROM CSS_ELEC_CL_SPEC WITH(READUNCOMMITTED)                     
               WHERE ELEC_MTR_CLASS_CD  = :EM-ELEC-MTR-CLASS-CD         
                 AND ELEC_MTR_SPEC_CD   = :EM-ELEC-MTR-SPEC-CD          
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CLASS_AMPS                                                 
MFA-TR*         INTO :U0-CLASS-AMPS                                             
MFA-TR*         FROM CSS_ELEC_CL_SPEC                                           
MFA-TR*        WHERE ELEC_MTR_CLASS_CD  = :EM-ELEC-MTR-CLASS-CD                 
MFA-TR*          AND ELEC_MTR_SPEC_CD   = :EM-ELEC-MTR-SPEC-CD                  
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE U0-CLASS-AMPS         TO WS-METER-AMPS          
               WHEN NOT-FOUND                                           
                   MOVE 0                     TO WS-METER-AMPS          
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_ELEC_CL_SPEC'    TO TABLE-1                
                   MOVE 'ELEC_MTR_CLASS_CD'   TO TABLE-ELEMENT-1        
                   MOVE 'ELEC_MTR_SPEC_CD'    TO TABLE-ELEMENT-2        
                   MOVE U0-ELEC-MTR-CLASS-CD  TO HOSTVAR-ELEMENT-1      
                   MOVE U0-ELEC-MTR-SPEC-CD   TO HOSTVAR-ELEMENT-2      
                   PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7160-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-SELECT-GAS-METER                                          *        
PCR361*     CALLS       9700-PROCESS-ABEND                             *        
      *                                                                *        
      ******************************************************************        
       7200-SELECT-GAS-METER.                                           
                                                                        
           MOVE '7200'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           EXEC SQL                                                     
               SELECT A.CODE_CO_SIZE,                                   
                      A.METER_SIZE_ID,                                  
                      A.CASE_PRESSURE,                                  
                      A.CONNECTION_TYPE_CD,                             
                      B.CODE_MAKE,                                      
                      B.SERIAL_NO                                       
                 INTO :GM-CODE-CO-SIZE,                                 
                      :GM-METER-SIZE-ID,                                
                      :GM-CASE-PRESSURE,                                
                      :GM-CONNECTION-TYPE-CD,                           
                      :EQ-CODE-MAKE,                                    
                      :EQ-SERIAL-NO                                     
                 FROM CSS_GAS_METER A WITH(READUNCOMMITTED),                    
                      CSS_EQUIPMENT B WITH(READUNCOMMITTED)                     
                WHERE A.CODE_UTIL_TYPE  = :WS-CODE-UTIL-TYPE            
                  AND A.CODE_UTIL_TYPE  = B.CODE_UTIL_TYPE              
T22243            AND A.COMPANY_NO      = :WS-COMPANY-NO                
T22243            AND A.COMPANY_NO      = B.COMPANY_NO                  
                  AND METER_NO          = :WS-METER-NO                  
                  AND A.METER_NO        = B.DEVICE_NO                   
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT A.CODE_CO_SIZE,                                           
MFA-TR*               A.METER_SIZE_ID,                                          
MFA-TR*               A.CASE_PRESSURE,                                          
MFA-TR*               A.CONNECTION_TYPE_CD,                                     
MFA-TR*               B.CODE_MAKE,                                              
MFA-TR*               B.SERIAL_NO                                               
MFA-TR*          INTO :GM-CODE-CO-SIZE,                                         
MFA-TR*               :GM-METER-SIZE-ID,                                        
MFA-TR*               :GM-CASE-PRESSURE,                                        
MFA-TR*               :GM-CONNECTION-TYPE-CD,                                   
MFA-TR*               :EQ-CODE-MAKE,                                            
MFA-TR*               :EQ-SERIAL-NO                                             
MFA-TR*          FROM CSS_GAS_METER A,                                          
MFA-TR*               CSS_EQUIPMENT B                                           
MFA-TR*         WHERE A.CODE_UTIL_TYPE  = :WS-CODE-UTIL-TYPE                    
MFA-TR*           AND A.CODE_UTIL_TYPE  = B.CODE_UTIL_TYPE                      
MFA-TR*           AND A.COMPANY_NO      = :WS-COMPANY-NO                        
MFA-TR*           AND A.COMPANY_NO      = B.COMPANY_NO                          
MFA-TR*           AND METER_NO          = :WS-METER-NO                          
MFA-TR*           AND A.METER_NO        = B.DEVICE_NO                           
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
ADAM               MOVE GM-CODE-CO-SIZE         TO WS-METER-GAS-CO-SIZE 
ADAM               MOVE GM-METER-SIZE-ID        TO WS-METER-SIZE-ID     
C30989*            MOVE GM-CASE-PRESSURE        TO WS-METER-PRESSURE            
ADAM               MOVE GM-CONNECTION-TYPE-CD   TO WS-METER-CONN-TYPE   
ADAM               MOVE EQ-CODE-MAKE            TO WS-METER-MAKE        
                   MOVE EQ-SERIAL-NO            TO WS-METER-MFG-SN      
               WHEN NOT-FOUND                                           
                   MOVE ZEROES                  TO WS-METER-GAS-CO-SIZE 
                   MOVE SPACES                  TO WS-METER-SIZE-ID     
                                                   WS-METER-CONN-TYPE   
                                                   WS-METER-MAKE        
                                                   WS-METER-MFG-SN      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
CBSI               MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_GAS_METER'       TO TABLE-1                
CBSI               MOVE 'CSS_EQUIPMENT'       TO TABLE-2                
CBSI               MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-1        
CBSI               MOVE 'METER_NO'            TO TABLE-ELEMENT-2        
CBSI               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-3        
T22243             MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-4        
CBSI               MOVE WS-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-1      
CBSI               MOVE WS-METER-NO           TO HOSTVAR-ELEMENT-2      
CBSI               MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-3      
T22243             MOVE WS-COMPANY-NO         TO HOSTVAR-ELEMENT-4      
PCR361             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7300-SELECT-PREMISE                                            *        
PCR361*     CALLS       9700-PROCESS-ABEND                             *        
      *                                                                *        
      ******************************************************************        
       7300-SELECT-PREMISE.                                             
           MOVE '7300'                     TO ACTIVE-PARAGRAPH.         
                                                                        
           EXEC SQL                                                     
               SELECT    PREMISE_DIRECTIONS,                            
                         SPCL_READ_INSTR,                               
                         SPCL_INSTRUCTIONS,                             
                         CITY_GATE_ID,                                  
                         SUBDIVISION_ID,                                
T18194                   BLOCK,                                         
T18194                   LOT,                                           
P35979                   COMPANY_NO,                                    
A05317                   PREM_REF_LATITUDE,                             
A05317                   PREM_REF_LONGITUDE                             
               INTO      :PR-PREMISE-DIRECTIONS,                        
                         :PR-SPCL-READ-INSTR,                           
                         :PR-SPCL-INSTRUCTIONS,                         
                         :PR-CITY-GATE-ID,                              
                         :PR-SUBDIVISION-ID,                            
T18194                   :PR-BLOCK,                                     
T18194                   :PR-LOT,                                       
P35979                   :PR-COMPANY-NO,                                
A05317                   :PR-PREM-REF-LATITUDE,                         
A05317                   :PR-PREM-REF-LONGITUDE                         
               FROM      CSS_PREMISE WITH(READUNCOMMITTED)                      
               WHERE     PREMISE_NO         = :WS-PREMISE-NO            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT    PREMISE_DIRECTIONS,                                    
MFA-TR*                  SPCL_READ_INSTR,                                       
MFA-TR*                  SPCL_INSTRUCTIONS,                                     
MFA-TR*                  CITY_GATE_ID,                                          
MFA-TR*                  SUBDIVISION_ID,                                        
MFA-TR*                  BLOCK,                                                 
MFA-TR*                  LOT,                                                   
MFA-TR*                  COMPANY_NO,                                            
MFA-TR*                  PREM_REF_LATITUDE,                                     
MFA-TR*                  PREM_REF_LONGITUDE                                     
MFA-TR*        INTO      :PR-PREMISE-DIRECTIONS,                                
MFA-TR*                  :PR-SPCL-READ-INSTR,                                   
MFA-TR*                  :PR-SPCL-INSTRUCTIONS,                                 
MFA-TR*                  :PR-CITY-GATE-ID,                                      
MFA-TR*                  :PR-SUBDIVISION-ID,                                    
MFA-TR*                  :PR-BLOCK,                                             
MFA-TR*                  :PR-LOT,                                               
MFA-TR*                  :PR-COMPANY-NO,                                        
MFA-TR*                  :PR-PREM-REF-LATITUDE,                                 
MFA-TR*                  :PR-PREM-REF-LONGITUDE                                 
MFA-TR*        FROM      CSS_PREMISE                                            
MFA-TR*        WHERE     PREMISE_NO         = :WS-PREMISE-NO                    
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ADAM          MOVE PR-SUBDIVISION-ID          TO WS-SUBDIVISION-ID      
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_PREMISE'              TO TABLE-1                
CBSI          MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
CBSI          MOVE WS-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2      
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00480******************************************************************        
P00480* 7325-GET-MA-ACCESS-CD                                                   
P00480*     CALLS       9700-PROCESS-ABEND                             *        
P00480*                                                                *        
P00480******************************************************************        
       7325-GET-MA-ACCESS-CD.                                           
                                                                        
             MOVE '7725'                     TO ACTIVE-PARAGRAPH.       
                                                                        
                                                                        
             EXEC SQL                                                   
               SELECT    MTR_ACCESSIBLE_CD,                             
                         MTR_ACCESSIBLE_DT,                             
                         MTR_ACCESSIBLE_RSN,                            
                         ALT_PHONE_NO,                                  
                         ALT_PHONE_NO_EXT                               
               INTO      :VO-MTR-ACCESSIBLE-CD,                         
                         :VO-MTR-ACCESSIBLE-DT :WS-NULL-ACCESSIBLE-DT,   
                         :VO-MTR-ACCESSIBLE-RSN,                        
                         :VO-ALT-PHONE-NO,                              
                         :VO-ALT-PHONE-NO-EXT                           
               FROM      CSS_SO_DATA WITH(READUNCOMMITTED)                      
               WHERE     SERV_ORDER_NO       = :VO-SERV-ORDER-NO        
                                                            
                                                                 
             END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*      EXEC SQL                                                           
MFA-TR*        SELECT    MTR_ACCESSIBLE_CD,                                     
MFA-TR*                  MTR_ACCESSIBLE_DT,                                     
MFA-TR*                  MTR_ACCESSIBLE_RSN,                                    
MFA-TR*                  ALT_PHONE_NO,                                          
MFA-TR*                  ALT_PHONE_NO_EXT                                       
MFA-TR*        INTO      :VO-MTR-ACCESSIBLE-CD,                                 
MFA-TR*                  :VO-MTR-ACCESSIBLE-DT:WS-NULL-ACCESSIBLE-DT,           
MFA-TR*                  :VO-MTR-ACCESSIBLE-RSN,                                
MFA-TR*                  :VO-ALT-PHONE-NO,                                      
MFA-TR*                  :VO-ALT-PHONE-NO-EXT                                   
MFA-TR*        FROM      CSS_SO_DATA                                            
MFA-TR*        WHERE     SERV_ORDER_NO       = :VO-SERV-ORDER-NO                
MFA-TR*        QUERYNO 7325                                                     
MFA-TR*        WITH UR                                                          
MFA-TR*      END-EXEC.                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.      
                                                                        
             IF WS-NULL-ACCESSIBLE-DT < 0                               
               MOVE SPACES TO VO-MTR-ACCESSIBLE-DT                      
             END-IF                                                     
                                                                        
             IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN        
P00480*        AND VO-MTR-ACCESSIBLE-CD = 'Y' THEN                              
              IF VO-ALT-PHONE-NO > SPACES THEN                          
                PERFORM VARYING WS-SUB FROM 1 BY 1 UNTIL WS-SUB > 10    
                IF WS-SUB < 4                                           
                 MOVE VO-ALT-PHONE-NO(WS-SUB:1) TO WS-PHONE-1(WS-SUB:1) 
                 ELSE IF WS-SUB > 3 AND WS-SUB < 7                      
                 ADD 1 TO WS-SUB1                                       
                 MOVE VO-ALT-PHONE-NO(WS-SUB:1) TO WS-PHONE-2(WS-SUB1:1)
                 ELSE                                                   
                 ADD 1 TO WS-SUB2                                       
                 MOVE VO-ALT-PHONE-NO(WS-SUB:1) TO WS-PHONE-3(WS-SUB2:1)
                      END-IF                                            
                END-IF                                                  
                END-PERFORM                                             
                                                                        
                STRING  ' ADDL#(' DELIMITED BY SIZE                     
                     WS-PHONE-1  DELIMITED BY SIZE                      
                     ')'  DELIMITED BY SIZE                             
                     WS-PHONE-2 DELIMITED BY SIZE                       
                     '-' DELIMITED BY SIZE                              
                     WS-PHONE-3 DELIMITED BY SIZE                       
                 INTO WS-PHONE-NO                                       
             END-STRING                                                 
             ELSE                                                       
             MOVE SPACES TO WS-PHONE-NO                                 
             END-IF                                                     
                                                                        
             IF VO-ALT-PHONE-NO-EXT > SPACES                            
              STRING ' ,EXT ' DELIMITED BY SIZE                         
              VO-ALT-PHONE-NO-EXT DELIMITED BY SPACE                    
              INTO                                                      
              WS-PHONE-NO-EXT                                           
              END-STRING                                                
             ELSE                                                       
              MOVE SPACES TO WS-PHONE-NO-EXT                            
             END-IF                                                     
                                                                        
P00480     IF VO-MTR-ACCESSIBLE-CD = 'Y' THEN                           
               MOVE 'CSS_SO_DATA'        TO SW-TABLE-NA                 
               MOVE 'MTR_ACCESSIBLE_RSN' TO SW-COLUMN-NA                
               MOVE VO-MTR-ACCESSIBLE-RSN TO SW-CODE-VALUE              
             PERFORM 7330-GET-MTR-ACCESS-RSN  THRU 7330-EXIT            
                                                                        
             IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL             
             MOVE SW-CODE-SHORT-DESC TO WS-CODE-SHORT-DESC              
             STRING 'MA (' DELIMITED BY SIZE                            
                 WS-CODE-SHORT-DESC DELIMITED BY '  '                   
                 ',' DELIMITED BY SIZE                                  
                 VO-MTR-ACCESSIBLE-DT  DELIMITED BY ' '                 
                 ')' DELIMITED BY SIZE                                  
                 ',' DELIMITED BY SIZE                                  
               INTO                                                     
                  WS-ORDER-SPCL-INST                                    
              END-STRING                                                
              END-IF                                                    
              ELSE IF VO-MTR-ACCESSIBLE-CD = 'U'                        
               STRING 'MA (' DELIMITED BY SIZE                          
                 'UNKNOWN' DELIMITED BY SIZE                            
                 ',' DELIMITED BY SIZE                                  
                 VO-MTR-ACCESSIBLE-DT  DELIMITED BY ' '                 
                 ')' DELIMITED BY SIZE                                  
                 ',' DELIMITED BY SIZE                                  
              INTO                                                      
                 WS-ORDER-SPCL-INST                                     
              ELSE                                                      
                MOVE SPACES TO WS-ORDER-SPCL-INST                       
              END-IF                                                    
              END-IF                                                    
               STRING WS-ORDER-SPCL-INST DELIMITED BY '  '              
                 WS-PHONE-NO DELIMITED BY '  '                          
                 WS-PHONE-NO-EXT   DELIMITED BY '  '                    
                 '///' DELIMITED BY SIZE                                
             INTO                                                       
                 WS-ORDER-SPCL-INST                                     
            END-STRING                                                  
            END-IF                                                      
                                                                        
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                 CONTINUE                                               
             ELSE                                                       
                 MOVE PROGRAM-NAME               TO ABEND-PROGRAM       
                 MOVE 'SELECT'                   TO ABEND-FUNCTION      
                 MOVE 'CSS_SO_DATA'              TO TABLE-1             
                 MOVE 'SERV_ORDER_NO'            TO TABLE-ELEMENT-1     
                 MOVE VO-SERV-ORDER-NO           TO HOSTVAR-ELEMENT-1   
                PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT          
             END-IF.                                                    
                                                                        
       7325-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00480******************************************************************        
P00480* 7330-GET-MTR-ACCESS-RSN                                                 
P00480*     CALLS       9700-PROCESS-ABEND                             *        
P00480*                                                                *        
P00480******************************************************************        
       7330-GET-MTR-ACCESS-RSN.                                         
                                                                        
           MOVE '7725'                     TO ACTIVE-PARAGRAPH.         
                                                                        
           EXEC SQL                                                     
               SELECT    CODE_SHORT_DESC                                
               INTO      :SW-CODE-SHORT-DESC                            
               FROM      CSS_SO_CODE_DESC WITH(READUNCOMMITTED)                 
               WHERE     TABLE_NA = :SW-TABLE-NA                        
                 AND     COLUMN_NA = :SW-COLUMN-NA                      
                 AND     CODE_VALUE = :SW-CODE-VALUE                    
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT    CODE_SHORT_DESC                                        
MFA-TR*        INTO      :SW-CODE-SHORT-DESC                                    
MFA-TR*        FROM      CSS_SO_CODE_DESC                                       
MFA-TR*        WHERE     TABLE_NA = :SW-TABLE-NA                                
MFA-TR*          AND     COLUMN_NA = :SW-COLUMN-NA                              
MFA-TR*          AND     CODE_VALUE = :SW-CODE-VALUE                            
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 4330                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_SO_CODE_DESC'         TO TABLE-1                
              MOVE 'TABLE_NA'                 TO TABLE-ELEMENT-1        
              MOVE 'COLUMN_NA'                TO TABLE-ELEMENT-2        
              MOVE SW-TABLE-NA                TO HOSTVAR-ELEMENT-1      
              MOVE SW-COLUMN-NA               TO HOSTVAR-ELEMENT-1      
             PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7330-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7350-SELECT-SUBDIVISION                                        *        
PCR361*     CALLS       9700-PROCESS-ABEND                             *        
      *                                                                *        
      ******************************************************************        
       7350-SELECT-SUBDIVISION.                                         
           MOVE '7350'                     TO ACTIVE-PARAGRAPH.         
                                                                        
           EXEC SQL                                                     
               SELECT    SUBDIVISION_DESC                               
               INTO      :B0-SUBDIVISION-DESC                           
               FROM      CSS_SUBDIVISION WITH(READUNCOMMITTED)                  
               WHERE     SUBDIVISION_ID     = :WS-SUBDIVISION-ID        
P35979           AND     COMPANY_NO         = :B0-COMPANY-NO            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT    SUBDIVISION_DESC                                       
MFA-TR*        INTO      :B0-SUBDIVISION-DESC                                   
MFA-TR*        FROM      CSS_SUBDIVISION                                        
MFA-TR*        WHERE     SUBDIVISION_ID     = :WS-SUBDIVISION-ID                
MFA-TR*          AND     COMPANY_NO         = :B0-COMPANY-NO                    
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
ADAM               MOVE B0-SUBDIVISION-DESC   TO WS-SUBDIVISION-DESC    
               WHEN NOT-FOUND                                           
                   MOVE SPACES                TO WS-SUBDIVISION-DESC    
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
CBSI               MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_SUBDIVISION'     TO TABLE-1                
CBSI               MOVE 'SUBDIVISION_ID'      TO TABLE-ELEMENT-1        
CBSI               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2        
CBSI               MOVE WS-SUBDIVISION-ID     TO HOSTVAR-ELEMENT-1      
CBSI               MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2      
PCR361             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7350-EXIT.                                                       
           EXIT.                                                        
                                                                        
C35979******************************************************************        
C35979* 7360-SELECT-XSFLW-SPLSVC                                      *         
C35979*     CALLS       9700-PROCESS-ABEND                             *        
C35979*                                                                *        
C35979******************************************************************        
C35979 7360-SELECT-XSFLW-SPLSVC.                                        
C35979     MOVE '7360'                     TO ACTIVE-PARAGRAPH.         
C35979                                                                  
C35979     EXEC SQL                                                     
C35979         SELECT XS_FLOW_VALVE_FL                                  
C35979               ,SPLIT_SERV_FL                                     
C35979           INTO :XO-XS-FLOW-VALVE-FL,                             
C35979                :XO-SPLIT-SERV-FL                                 
C35979           FROM CSS_GAS_SERV_LINE XO WITH(READUNCOMMITTED)                
C35979               ,CSS_GASLINE_SO_XRF XX WITH(READUNCOMMITTED)               
C35979          WHERE XO.SERVICE_NO    = XX.SERVICE_NO                  
C35979            AND XX.SERV_ORDER_NO = :XX-SERV-ORDER-NO              
C35979                                                           
C35979     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT XS_FLOW_VALVE_FL                                          
MFA-TR*              ,SPLIT_SERV_FL                                             
MFA-TR*          INTO :XO-XS-FLOW-VALVE-FL,                                     
MFA-TR*               :XO-SPLIT-SERV-FL                                         
MFA-TR*          FROM CSS_GAS_SERV_LINE XO                                      
MFA-TR*              ,CSS_GASLINE_SO_XRF XX                                     
MFA-TR*         WHERE XO.SERVICE_NO    = XX.SERVICE_NO                          
MFA-TR*           AND XX.SERV_ORDER_NO = :XX-SERV-ORDER-NO                      
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C35979                                                                  
C35979     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
C35979                                                                  
C35979     EVALUATE WS-ACTIVE-RETURN-CODE                               
C35979         WHEN SUCCESSFUL-CALL                                     
C35979             MOVE XO-XS-FLOW-VALVE-FL TO WS-XS-FLOW-VALVE-FL      
C35979             MOVE XO-SPLIT-SERV-FL    TO WS-SPLIT-SERVICE-FL      
C35979         WHEN NOT-FOUND                                           
C35979             MOVE SPACES              TO WS-XS-FLOW-VALVE-FL      
C35979                                         WS-SPLIT-SERVICE-FL      
C35979         WHEN -811                                                
C35979             MOVE SPACES              TO WS-XS-FLOW-VALVE-FL      
C35979                                         WS-SPLIT-SERVICE-FL      
C35979         WHEN OTHER                                               
C35979             MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
C35979             MOVE 'SELECT'              TO ABEND-FUNCTION         
C35979             MOVE 'CSS_GAS_SERV_LINE'   TO TABLE-1                
C35979             MOVE 'CSS_GASLINE_SO_XRF'  TO TABLE-2                
C35979             MOVE 'SERV_ORDER_NO'       TO TABLE-ELEMENT-1        
C35979             MOVE PARM-SERV-ORDER-NO    TO HOSTVAR-ELEMENT-1      
C35979             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
C35979     END-EVALUATE.                                                
C35979                                                                  
C35979 7360-EXIT.                                                       
C35979     EXIT.                                                        
C35979                                                                  
C35979******************************************************************        
C35979* 7365-GET-XSFLW-SPLSVC                                          *        
C35979*     CALLS       9700-PROCESS-ABEND                             *        
C35979*                                                                *        
C35979******************************************************************        
C35979 7365-GET-XSFLW-SPLSVC.                                           
C35979     MOVE '7365'                     TO ACTIVE-PARAGRAPH.         
C35979                                                                  
C35979     EXEC SQL                                                     
C35979         SELECT TOP(1) XS_FLOW_VALVE_FL,
              SPLIT_SERV_FL                                     
C35979           INTO :XO-XS-FLOW-VALVE-FL,                             
C35979                :XO-SPLIT-SERV-FL                                 
C35979           FROM CSS_GAS_SERV_LINE XO WITH(READUNCOMMITTED)                
C35979               ,CSS_PREM_GAS_LINE  Y0 WITH(READUNCOMMITTED)               
C35979          WHERE Y0.PREMISE_NO    = :WS-PREMISE-NO                 
C35979            AND Y0.SERVICE_NO    = XO.SERVICE_NO                  
C35979            AND SERV_LINE_STAT_FL IN ('A', 'P', 'T')              
C35979          ORDER BY SERV_LINE_STAT_FL ASC                          
C35979                                              
C35979                                                           
C35979     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT XS_FLOW_VALVE_FL                                          
MFA-TR*              ,SPLIT_SERV_FL                                             
MFA-TR*          INTO :XO-XS-FLOW-VALVE-FL,                                     
MFA-TR*               :XO-SPLIT-SERV-FL                                         
MFA-TR*          FROM CSS_GAS_SERV_LINE XO                                      
MFA-TR*              ,CSS_PREM_GAS_LINE  Y0                                     
MFA-TR*         WHERE Y0.PREMISE_NO    = :WS-PREMISE-NO                         
MFA-TR*           AND Y0.SERVICE_NO    = XO.SERVICE_NO                          
MFA-TR*           AND SERV_LINE_STAT_FL IN ('A', 'P', 'T')                      
MFA-TR*         ORDER BY SERV_LINE_STAT_FL ASC                                  
MFA-TR*         FETCH FIRST ROW ONLY                                            
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C35979                                                                  
C35979     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
C35979                                                                  
C35979     EVALUATE WS-ACTIVE-RETURN-CODE                               
C35979         WHEN SUCCESSFUL-CALL                                     
C35979             MOVE XO-XS-FLOW-VALVE-FL TO WS-XS-FLOW-VALVE-FL      
C35979             MOVE XO-SPLIT-SERV-FL    TO WS-SPLIT-SERVICE-FL      
C35979         WHEN NOT-FOUND                                           
C35979             MOVE SPACES              TO WS-XS-FLOW-VALVE-FL      
C35979                                         WS-SPLIT-SERVICE-FL      
C35979         WHEN OTHER                                               
C35979             MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
C35979             MOVE 'SELECT'              TO ABEND-FUNCTION         
C35979             MOVE 'CSS_PREM_GAS_LINE'   TO TABLE-1                
C35979             MOVE 'CSS_GAS_PREM_LINE'   TO TABLE-1                
C35979             MOVE 'PREMISE_NO    '      TO TABLE-ELEMENT-1        
C35979             MOVE WS-PREMISE-NO         TO HOSTVAR-ELEMENT-1      
C35979             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
C35979     END-EVALUATE.                                                
C35979                                                                  
C35979 7365-EXIT.                                                       
C35979     EXIT.                                                        
C35979                                                                  
C35979******************************************************************        
C35979* 7360-SELECT-PREM-DLVRY                                        *         
C35979*     CALLS       9700-PROCESS-ABEND                             *        
C35979*                                                                *        
C35979******************************************************************        
C35979*7360-SELECT-PREM-DLVRY.                                                  
C35979*    MOVE '7360'                     TO ACTIVE-PARAGRAPH.                 
C35979*                                                                         
C35979*    EXEC SQL                                                             
C35979*        SELECT    XS_FLOW_VALVE_FL,                                      
C35979*                  SPLIT_SERVICE_FL                                       
C35979*        INTO      :NG-XS-FLOW-VALVE-FL,                                  
C35979*                  :NG-SPLIT-SERVICE-FL                                   
C35979*       FROM      CSS_PREM_DLVRY_PT                                       
C35979*        WHERE     PREMISE_NO    =    :WS-PREMISE-NO                      
C35979*        WITH UR                                                          
C35979*    END-EXEC.                                                            
C35979*                                                                         
C35979*    MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.                
C35979*                                                                         
C35979*    EVALUATE WS-ACTIVE-RETURN-CODE                                       
C35979*        WHEN SUCCESSFUL-CALL                                             
C35979*            MOVE NG-XS-FLOW-VALVE-FL TO WS-XS-FLOW-VALVE-FL              
C35979*            MOVE NG-SPLIT-SERVICE-FL TO WS-SPLIT-SERVICE-FL              
C35979*        WHEN NOT-FOUND                                                   
C35979*            MOVE SPACES              TO WS-XS-FLOW-VALVE-FL              
C35979*                                        WS-SPLIT-SERVICE-FL              
C35979*        WHEN OTHER                                                       
C35979*            MOVE PROGRAM-NAME          TO ABEND-PROGRAM                  
C35979*            MOVE 'SELECT'              TO ABEND-FUNCTION                 
C35979*            MOVE 'CSS_PREM_DLVRY_PT'   TO TABLE-1                        
C35979*            MOVE 'PREMISE_NO    '      TO TABLE-ELEMENT-1                
C35979*            MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2                
C35979*            MOVE WS-PREMISE-NO         TO HOSTVAR-ELEMENT-1              
C35979*            MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2              
C35979*            PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                    
C35979*    END-EVALUATE.                                                        
C35979*                                                                         
C35979*7360-EXIT.                                                               
C35979*    EXIT.                                                                
C35979*                                                                         
      ******************************************************************        
      * 7450-SELECT-CREDIT-PROFILE                                     *        
PCR361*     CALLS       9700-PROCESS-ABEND                             *        
      *                                                                *        
      ******************************************************************        
       7450-SELECT-CREDIT-PROFILE.                                      
                                                                        
           MOVE '7450'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               SELECT    CASH_ONLY_FL,                                  
                         DISCONNECT_HIST,                               
                         ARREARS_HIST,                                  
                         DISC_EXCEPTN_HIST                              
               INTO      :WS-CASH-ONLY-FLAG,                            
                         :CZ-DISCONNECT-HIST,                           
                         :CZ-ARREARS-HIST,                              
                         :CZ-DISC-EXCEPTN-HIST                          
               FROM      CSS_CREDIT_PROFILE WITH(READUNCOMMITTED)               
               WHERE     ACCOUNT_NO         = :WS-ACCOUNT-NO            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT    CASH_ONLY_FL,                                          
MFA-TR*                  DISCONNECT_HIST,                                       
MFA-TR*                  ARREARS_HIST,                                          
MFA-TR*                  DISC_EXCEPTN_HIST                                      
MFA-TR*        INTO      :WS-CASH-ONLY-FLAG,                                    
MFA-TR*                  :CZ-DISCONNECT-HIST,                                   
MFA-TR*                  :CZ-ARREARS-HIST,                                      
MFA-TR*                  :CZ-DISC-EXCEPTN-HIST                                  
MFA-TR*        FROM      CSS_CREDIT_PROFILE                                     
MFA-TR*        WHERE     ACCOUNT_NO         = :WS-ACCOUNT-NO                    
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
ADAM               IF WS-CASH-ONLY-FLAG = 'Y'                           
ADAM                   CONTINUE                                         
ADAM               ELSE                                                 
ADAM                   MOVE 'N'                TO WS-CASH-ONLY-FLAG     
ADAM               END-IF                                               
ADAM               MOVE CZ-DISCONNECT-HIST     TO WS-CREDIT-HISTORY     
ADAM               MOVE CZ-ARREARS-HIST        TO WS-ARREARS-HISTORY    
ADAM               MOVE CZ-DISC-EXCEPTN-HIST   TO WS-EX-CREDIT-HIST     
               WHEN NOT-FOUND                                           
                   MOVE 'N'                    TO WS-CASH-ONLY-FLAG     
                   MOVE SPACES                 TO WS-CREDIT-HISTORY     
                                                  WS-ARREARS-HISTORY    
                                                  WS-EX-CREDIT-HIST     
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
CBSI               MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_CREDIT_PROFILE'  TO TABLE-1                
CBSI               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
CBSI               MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
PCR361             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7450-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7500-SELECT-CRED-COLL                                          *        
PCR361*     CALLS       9700-PROCESS-ABEND                             *        
      *                                                                *        
      ******************************************************************        
       7500-SELECT-CRED-COLL.                                           
                                                                        
           MOVE '7500'                     TO ACTIVE-PARAGRAPH.         
                                                                        
TP8041     EVALUATE WS-ORDER-REASON                                     
TP8041        WHEN 'N'                                                  
TP8041        WHEN 'O'                                                  
P00471        WHEN 'J'                                                  
P00471        WHEN 'K'                                                  
P00471        WHEN 'U'                                                  
P00471        WHEN 'V'                                                  
TP8041           MOVE 'C' TO CL-CODE-NOTICE-TYPE                        
TP8041        WHEN 'H'                                                  
TP8041           MOVE 'N' TO CL-CODE-NOTICE-TYPE                        
TP8041        WHEN 'I'                                                  
TP8041           MOVE 'O' TO CL-CODE-NOTICE-TYPE                        
TP8041        WHEN 'X'                                                  
TP8041           MOVE  SPACES TO WS-SECOND-N-DATE                       
TP8041           GO TO  7500-EXIT                                       
TP8041        WHEN OTHER                                                
TP8041           MOVE 'F' TO CL-CODE-NOTICE-TYPE                        
TP8041      END-EVALUATE.                                               
                                                                        
           EXEC SQL                                                     
               SELECT  DATE_NOTICE_MAIL                                 
               INTO    :CL-DATE-NOTICE-MAIL :WS-NULL-DATE-NOTICE-MAIL   
               FROM    CSS_CRED_COLL WITH(READUNCOMMITTED)                      
               WHERE   ACCOUNT_NO         = :WS-ACCOUNT-NO              
                 AND   CODE_NOTICE_TYPE   = :CL-CODE-NOTICE-TYPE        
                 AND   ITEM_ID            = 0                           
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  DATE_NOTICE_MAIL                                         
MFA-TR*        INTO    :CL-DATE-NOTICE-MAIL :WS-NULL-DATE-NOTICE-MAIL           
MFA-TR*        FROM    CSS_CRED_COLL                                            
MFA-TR*        WHERE   ACCOUNT_NO         = :WS-ACCOUNT-NO                      
MFA-TR*          AND   CODE_NOTICE_TYPE   = :CL-CODE-NOTICE-TYPE                
MFA-TR*          AND   ITEM_ID            = 0                                   
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
ADAM               IF WS-NULL-DATE-NOTICE-MAIL = -1                     
ADAM                  MOVE SPACES      TO CL-DATE-NOTICE-MAIL           
ADAM               END-IF                                               
ADAM                                                                    
ADAM               MOVE CL-DATE-NOTICE-MAIL   TO WS-SECOND-N-DATE       
               WHEN NOT-FOUND                                           
                   MOVE SPACES      TO WS-SECOND-N-DATE                 
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
CBSI               MOVE 'SELECT'              TO ABEND-FUNCTION         
CBSI               MOVE 'CSS_CRED_COLL'       TO TABLE-1                
CBSI               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
CBSI               MOVE 'CODE_NOTICE_TYPE'    TO TABLE-ELEMENT-2        
CBSI               MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
CBSI               MOVE CL-CODE-NOTICE-TYPE   TO HOSTVAR-ELEMENT-2      
PCR361             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7510-OPEN-UTL-CURSOR                                           *        
PCR361*     CALLS       9700-PROCESS-ABEND                             *        
      *                                                                *        
      ******************************************************************        
       7510-OPEN-UTL-CURSOR.                                            
                                                                        
           MOVE '7510'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN UTL-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'CSS_UTIL_ENVRNMT'         TO TABLE-1                
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7520-FETCH-UTL-CURSOR                                          *        
PCR361*     CALLS       9700-PROCESS-ABEND                             *        
      *                                                                *        
      ******************************************************************        
       7520-FETCH-UTL-CURSOR.                                           
                                                                        
           MOVE '7520'                         TO ACTIVE-PARAGRAPH.     
                                                                        
           EXEC SQL                                                     
              FETCH UTL-CURSOR                                          
               INTO :UT-READ-CYCLE,                                     
                    :UT-READ-ROUTE                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE UT-READ-CYCLE            TO RS-READ-CYCLE       
                   MOVE UT-READ-ROUTE            TO RS-READ-ROUTE       
               WHEN NOT-FOUND                                           
                   MOVE SPACES                   TO RS-READ-CYCLE       
                   MOVE ZEROES                   TO RS-READ-ROUTE       
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
CBSI               MOVE 'FETCH'               TO ABEND-FUNCTION         
                   MOVE 'CSS_UTIL_ENVRNMT'    TO TABLE-1                
CBSI               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
CBSI               MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
PCR361             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7530-CLOSE-UTL-CURSOR                                          *        
PCR361*     CALLS       9700-PROCESS-ABEND                             *        
      *                                                                *        
      *     CLOSES THE CURSOR                                          *        
      ******************************************************************        
       7530-CLOSE-UTL-CURSOR.                                           
                                                                        
           MOVE '7530'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE UTL-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE 'CSS_UTIL_ENVRNMT'         TO TABLE-1                
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7530-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7550-OPEN-MTR-CURSOR                                           *        
PCR361*     CALLS       9700-PROCESS-ABEND                             *        
      *                                                                *        
      ******************************************************************        
       7550-OPEN-MTR-CURSOR.                                            
                                                                        
           MOVE '7550'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN MTR-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'CSS_MTRD_ENVRNMT'         TO TABLE-1                
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7570-FETCH-MTR-CURSOR                                          *        
PCR361*     CALLS       9700-PROCESS-ABEND                             *        
      *                                                                *        
      ******************************************************************        
       7570-FETCH-MTR-CURSOR.                                           
                                                                        
           MOVE '7570'                         TO ACTIVE-PARAGRAPH.     
                                                                        
           EXEC SQL                                                     
              FETCH MTR-CURSOR                                          
               INTO :MN-REGISTER-RD-SEQ                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
ADAM          MOVE MN-REGISTER-RD-SEQ            TO RS-REGISTER-RD-SEQ  
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE 'CSS_MTRD_ENVRNMT'         TO TABLE-1                
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7570-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7590-CLOSE-MTR-CURSOR                                          *        
PCR361*     CALLS       9700-PROCESS-ABEND                             *        
      *                                                                *        
      *     CLOSES THE CURSOR                                          *        
      ******************************************************************        
       7590-CLOSE-MTR-CURSOR.                                           
                                                                        
           MOVE '7590'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE MTR-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE 'CSS_MTRD_ENVRNMT'         TO TABLE-1                
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7590-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7600-OPEN-AR-CURSOR                                            *        
PCR361*     CALLS       9700-PROCESS-ABEND                             *        
      *                                                                *        
      ******************************************************************        
       7600-OPEN-AR-CURSOR.                                             
           MOVE '7600'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN AR-CURSOR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'CSS_AR_TRANS_HIST'        TO TABLE-1                
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7620-FETCH-AR-CURSOR                                           *        
PCR361*     CALLS       9700-PROCESS-ABEND                             *        
      *                                                                *        
      ******************************************************************        
       7620-FETCH-AR-CURSOR.                                            
           MOVE '7620'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
              FETCH  AR-CURSOR                                          
              INTO  :AR-TRANS-HIST-SEQ-NO :WS-NULL-TRANS-SEQ-NO,         
                    :AR-AMT-ORIG-ENTERED                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
ADAM          IF WS-NULL-TRANS-SEQ-NO = -1                              
ADAM             MOVE SPACES             TO AR-TRANS-HIST-SEQ-NO        
ADAM          END-IF                                                    
ADAM          MOVE AR-TRANS-HIST-SEQ-NO  TO WS-LAST-PAY-DATE            
ADAM                                                                    
ADAM          IF AR-AMT-ORIG-ENTERED NUMERIC                            
ADAM              CONTINUE                                              
ADAM          ELSE                                                      
ADAM              MOVE 0                 TO AR-AMT-ORIG-ENTERED         
ADAM          END-IF                                                    
ADAM          MOVE AR-AMT-ORIG-ENTERED   TO WS-AMT-ORIG-ENTERED         
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE 'CSS_AR_TRANS_HIST'        TO TABLE-1                
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7620-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7640-CLOSE-AR-CURSOR                                           *        
PCR361*     CALLS       9700-PROCESS-ABEND                             *        
      *                                                                *        
      *     CLOSES THE CURSOR                                          *        
      ******************************************************************        
       7640-CLOSE-AR-CURSOR.                                            
                                                                        
           MOVE '7640'                     TO ACTIVE-PARAGRAPH.         
                                                                        
           EXEC SQL                                                     
              CLOSE  AR-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE 'CSS_AR_TRANS_HIST'        TO TABLE-1                
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7640-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7650-SELECT-DEP-ON-HAND                                        *        
PCR361*     CALLS       9700-PROCESS-ABEND                             *        
      *                                                                *        
      ******************************************************************        
       7650-SELECT-DEP-ON-HAND.                                         
                                                                        
           MOVE '7650'                     TO ACTIVE-PARAGRAPH.         
                                                                        
           EXEC SQL                                                     
               SELECT    SUM(AMT_DEPOSIT)                               
               INTO      :DO-AMT-DEPOSIT :WS-NULL-AMT-DEPOSIT            
               FROM      CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                  
               WHERE     ACCOUNT_NO         = :WS-ACCOUNT-NO            
               AND       CODE_REFUND_TYPE   = ' '                       
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT    SUM(AMT_DEPOSIT)                                       
MFA-TR*        INTO      :DO-AMT-DEPOSIT:WS-NULL-AMT-DEPOSIT                    
MFA-TR*        FROM      CSS_DEP_ON_HAND                                        
MFA-TR*        WHERE     ACCOUNT_NO         = :WS-ACCOUNT-NO                    
MFA-TR*        AND       CODE_REFUND_TYPE   = ' '                               
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
ADAM               IF WS-NULL-AMT-DEPOSIT = -1                          
ADAM                  MOVE 0                     TO DO-AMT-DEPOSIT      
ADAM               END-IF                                               
ADAM               MOVE DO-AMT-DEPOSIT           TO WS-AMT-DEPOSIT      
               WHEN NOT-FOUND                                           
                   MOVE ZEROES                   TO WS-AMT-DEPOSIT      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
CBSI               MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_DEP_ON_HAND'     TO TABLE-1                
CBSI               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
CBSI               MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
PCR361             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7650-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7660-SELECT-CUST-MISC.                                         *        
PCR361*     CALLS       9700-PROCESS-ABEND                             *        
      *                                                                *        
      ******************************************************************        
       7660-SELECT-CUST-MISC.                                           
                                                                        
           MOVE '7660'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
              SELECT KEY_CUSTOMER                                       
                INTO :LQ-KEY-CUSTOMER                                   
                FROM CSS_CUST_MISC_INFO WITH(READUNCOMMITTED)                   
               WHERE CUSTOMER_NO = :WS-CUSTOMER-NO                      
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT KEY_CUSTOMER                                               
MFA-TR*         INTO :LQ-KEY-CUSTOMER                                           
MFA-TR*         FROM CSS_CUST_MISC_INFO                                         
MFA-TR*        WHERE CUSTOMER_NO = :WS-CUSTOMER-NO                              
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
                                                   RS-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ADAM          IF LQ-KEY-CUSTOMER EQUAL SPACES                           
ADAM             MOVE WS-NO                     TO WS-KEY-CUSTOMER      
ADAM          ELSE                                                      
ADAM             MOVE WS-YES                    TO WS-KEY-CUSTOMER      
ADAM          END-IF                                                    
           ELSE                                                         
ADAM          IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
ADAM             MOVE WS-NO                     TO WS-KEY-CUSTOMER      
ADAM          ELSE                                                      
                 MOVE PROGRAM-NAME                 TO ABEND-PROGRAM     
CBSI             MOVE 'SELECT'                     TO ABEND-FUNCTION    
                 MOVE 'CSS_CUST_MISC_INFO'         TO TABLE-1           
CBSI             MOVE 'CUSTOMER_NO'                TO TABLE-ELEMENT-1   
CBSI             MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-2   
CBSI             MOVE WS-CUSTOMER-NO               TO HOSTVAR-ELEMENT-1 
CBSI             MOVE PARM-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2 
PCR361           PERFORM 9700-PROCESS-ABEND        THRU 9700-EXIT       
ADAM          END-IF                                                    
           END-IF.                                                      
                                                                        
       7660-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7670-SELECT-GUARANTOR                                          *        
PCR361*     CALLS       9700-PROCESS-ABEND                             *        
      *                                                                *        
      ******************************************************************        
       7670-SELECT-GUARANTOR.                                           
           MOVE '7670'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               SELECT    SUM(AMOUNT_GUARANTEED)                         
               INTO      :GU-AMOUNT-GUARANTEED :WS-NULL-AMT-GUARANTD     
               FROM      CSS_GUARANTOR WITH(READUNCOMMITTED)                    
               WHERE     ACCOUNT_NO         = :WS-ACCOUNT-NO            
               AND       GUAR_STATUS_CD     = 'A'                       
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT    SUM(AMOUNT_GUARANTEED)                                 
MFA-TR*        INTO      :GU-AMOUNT-GUARANTEED:WS-NULL-AMT-GUARANTD             
MFA-TR*        FROM      CSS_GUARANTOR                                          
MFA-TR*        WHERE     ACCOUNT_NO         = :WS-ACCOUNT-NO                    
MFA-TR*        AND       GUAR_STATUS_CD     = 'A'                               
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
ADAM               IF WS-NULL-AMT-GUARANTD = -1                         
ADAM                  MOVE 0                     TO GU-AMOUNT-GUARANTEED
ADAM               END-IF                                               
ADAM               MOVE GU-AMOUNT-GUARANTEED     TO WS-AMOUNT-GUARANTEED
               WHEN NOT-FOUND                                           
                   MOVE ZEROES                   TO WS-AMOUNT-GUARANTEED
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
CBSI               MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_GUARANTOR'       TO TABLE-1                
CBSI               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
CBSI               MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
PCR361             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7670-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7680-SELECT-CRIT-CUSTOMER                                      *        
PCR361*     CALLS       9700-PROCESS-ABEND                             *        
      *                                                                *        
      ******************************************************************        
       7680-SELECT-CRIT-CUSTOMER.                                       
                                                                        
           MOVE '7680'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
              SELECT CRIT_OUTAGE_DESC                                   
                INTO :Q2-CRIT-OUTAGE-DESC                               
                FROM CSS_ACCOUNT     A WITH(READUNCOMMITTED),                   
                     CSS_CRIT_OUTAGE B WITH(READUNCOMMITTED)                    
               WHERE A.ACCOUNT_NO       = :WS-ACCOUNT-NO                
                 AND A.CODE_CRIT_OUTAGE = B.CODE_CRIT_OUTAGE            
P33272           AND A.COMPANY_NO       = B.COMPANY_NO                  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CRIT_OUTAGE_DESC                                           
MFA-TR*         INTO :Q2-CRIT-OUTAGE-DESC                                       
MFA-TR*         FROM CSS_ACCOUNT     A,                                         
MFA-TR*              CSS_CRIT_OUTAGE B                                          
MFA-TR*        WHERE A.ACCOUNT_NO       = :WS-ACCOUNT-NO                        
MFA-TR*          AND A.CODE_CRIT_OUTAGE = B.CODE_CRIT_OUTAGE                    
MFA-TR*          AND A.COMPANY_NO       = B.COMPANY_NO                          
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
                                                   RS-RETURN-CODE.      
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE Q2-CRIT-OUTAGE-DESC     TO RS-CRITICAL-CUST     
               WHEN NOT-FOUND                                           
                   MOVE SPACES                  TO RS-CRITICAL-CUST     
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME            TO ABEND-PROGRAM        
CBSI               MOVE 'SELECT'                TO ABEND-FUNCTION       
                   MOVE 'CSS_ACCOUNT'           TO TABLE-1              
CBSI               MOVE 'CSS_CRIT_OUTAGE'       TO TABLE-2              
CBSI               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1      
CBSI               MOVE WS-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1    
PCR361             PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT          
           END-EVALUATE.                                                
                                                                        
                                                                        
       7680-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7690-SELECT-SURETY-BONDS                                       *        
PCR361*     CALLS       9700-PROCESS-ABEND                             *        
      *                                                                *        
      ******************************************************************        
       7690-SELECT-SURETY-BONDS.                                        
                                                                        
           MOVE '7690'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
               SELECT SUM(AMT_BOND)                                     
                 INTO :SB-AMT-BOND :WS-NULL-AMT-BOND                     
                 FROM CSS_SURETY_BOND WITH(READUNCOMMITTED)                     
                WHERE ACCOUNT_NO         = :WS-ACCOUNT-NO               
TP7826            AND (    CODE_STATUS        = 'A'                     
TP7826                  OR CODE_BOND_TYPE     = 'B'  )                  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(AMT_BOND)                                             
MFA-TR*          INTO :SB-AMT-BOND:WS-NULL-AMT-BOND                             
MFA-TR*          FROM CSS_SURETY_BOND                                           
MFA-TR*         WHERE ACCOUNT_NO         = :WS-ACCOUNT-NO                       
MFA-TR*           AND (    CODE_STATUS        = 'A'                             
MFA-TR*                 OR CODE_BOND_TYPE     = 'B'  )                          
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
ADAM               IF WS-NULL-AMT-BOND = -1                             
ADAM                  MOVE 0                     TO SB-AMT-BOND         
ADAM               END-IF                                               
ADAM               MOVE SB-AMT-BOND              TO WS-AMT-BOND         
               WHEN NOT-FOUND                                           
                   MOVE ZEROES                   TO WS-AMT-BOND         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
CBSI               MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_SURETY_BOND'     TO TABLE-1                
CBSI               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
CBSI               MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
PCR361             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
           END-EVALUATE.                                                
                                                                        
       7690-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7700-SELECT-ACCOUNT-TABLE                                      *        
PCR361*     CALLS       9700-PROCESS-ABEND                             *        
      *                                                                *        
      ******************************************************************        
       7700-SELECT-ACCOUNT-TABLE.                                       
                                                                        
           MOVE '7700'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
               SELECT    BANKRUPTCY_IND,                                
PCR361                   COMPANY_NO,                                    
PCR361                   LOCAL_OFFICE,                                  
PCR361                   DATE_BILL_DAY_00,                              
                         DATE_BILL_DAY_30,                              
                         DATE_BILL_DAY_60,                              
                         DATE_BILL_DAY_90,                              
                         NOTICE_EXEMPT_CD,                              
                         CODE_DISC_OK,                                  
                         CODES_DATA_PRESENT,                            
                         CAST(ACCT_CREATE_DT AS DATE),                          
                         CREDIT_GROUP,                                  
TP5024                   CUSTOMER_NO,                                   
TP5024                   CODE_ACCT_STAT,                                
C28788                   IVR_EXEMPT_CD,                                 
C32257                   CODE_ACCT_STAT                                 
               INTO      :AT-BANKRUPTCY-IND,                            
PCR361                   :AT-COMPANY-NO,                                
PCR361                   :AT-LOCAL-OFFICE,                              
PCR361                   :AT-DATE-BILL-DAY-00 :WS-NULL-BILL-DAY-00,      
                         :AT-DATE-BILL-DAY-30 :WS-NULL-BILL-DAY-30,      
                         :AT-DATE-BILL-DAY-60 :WS-NULL-BILL-DAY-60,      
                         :AT-DATE-BILL-DAY-90 :WS-NULL-BILL-DAY-90,      
                         :AT-NOTICE-EXEMPT-CD,                          
                         :AT-CODE-DISC-OK,                              
                         :AT-CODES-DATA-PRESENT,                        
                         :AT-ACCT-CREATE-DT :WS-NULL-ACCT-CREATE-DT,     
                         :AT-CREDIT-GROUP,                              
TP5024                   :AT-CUSTOMER-NO,                               
                         :AT-CODE-ACCT-STAT,                            
C28788                   :AT-IVR-EXEMPT-CD,                             
C32257                   :AT-CODE-ACCT-STAT                             
               FROM      CSS_ACCOUNT WITH(READUNCOMMITTED)                      
               WHERE     ACCOUNT_NO         = :WS-ACCOUNT-NO            
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT    BANKRUPTCY_IND,                                        
MFA-TR*                  COMPANY_NO,                                            
MFA-TR*                  LOCAL_OFFICE,                                          
MFA-TR*                  DATE_BILL_DAY_00,                                      
MFA-TR*                  DATE_BILL_DAY_30,                                      
MFA-TR*                  DATE_BILL_DAY_60,                                      
MFA-TR*                  DATE_BILL_DAY_90,                                      
MFA-TR*                  NOTICE_EXEMPT_CD,                                      
MFA-TR*                  CODE_DISC_OK,                                          
MFA-TR*                  CODES_DATA_PRESENT,                                    
MFA-TR*                  DATE(ACCT_CREATE_DT),                                  
MFA-TR*                  CREDIT_GROUP,                                          
MFA-TR*                  CUSTOMER_NO,                                           
MFA-TR*                  CODE_ACCT_STAT,                                        
MFA-TR*                  IVR_EXEMPT_CD,                                         
MFA-TR*                  CODE_ACCT_STAT                                         
MFA-TR*        INTO      :AT-BANKRUPTCY-IND,                                    
MFA-TR*                  :AT-COMPANY-NO,                                        
MFA-TR*                  :AT-LOCAL-OFFICE,                                      
MFA-TR*                  :AT-DATE-BILL-DAY-00:WS-NULL-BILL-DAY-00,              
MFA-TR*                  :AT-DATE-BILL-DAY-30:WS-NULL-BILL-DAY-30,              
MFA-TR*                  :AT-DATE-BILL-DAY-60:WS-NULL-BILL-DAY-60,              
MFA-TR*                  :AT-DATE-BILL-DAY-90:WS-NULL-BILL-DAY-90,              
MFA-TR*                  :AT-NOTICE-EXEMPT-CD,                                  
MFA-TR*                  :AT-CODE-DISC-OK,                                      
MFA-TR*                  :AT-CODES-DATA-PRESENT,                                
MFA-TR*                  :AT-ACCT-CREATE-DT:WS-NULL-ACCT-CREATE-DT,             
MFA-TR*                  :AT-CREDIT-GROUP,                                      
MFA-TR*                  :AT-CUSTOMER-NO,                                       
MFA-TR*                  :AT-CODE-ACCT-STAT,                                    
MFA-TR*                  :AT-IVR-EXEMPT-CD,                                     
MFA-TR*                  :AT-CODE-ACCT-STAT                                     
MFA-TR*        FROM      CSS_ACCOUNT                                            
MFA-TR*        WHERE     ACCOUNT_NO         = :WS-ACCOUNT-NO                    
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE      
                                             RS-RETURN-CODE.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ADAM          MOVE AT-BANKRUPTCY-IND         TO WS-BANKR-IND            
ADAM          IF WS-BANKR-IND = ' '                                     
ADAM              MOVE 'N'                   TO WS-BANKR-IND            
ADAM          END-IF                                                    
                                                                        
TP5024        MOVE AT-CUSTOMER-NO            TO WS-CUSTOMER-NO          
ADAM          MOVE WS-ACCOUNT-NO             TO AT-ACCOUNT-NO           
ADAM          MOVE AT-CODES-DATA-PRESENT     TO WS-CODES-DATA-PRESENT   
                                                                        
ADAM          IF WS-CODE-DPP-ACCT = 'A'                                 
ADAM              MOVE 'Y'                   TO WS-DPP                  
ADAM          ELSE                                                      
ADAM              MOVE 'N'                   TO WS-DPP                  
ADAM          END-IF                                                    
                                                                        
ADAM          MOVE AT-CREDIT-GROUP           TO WS-CREDIT-GROUP         
                                                                        
PCR361        IF WS-NULL-BILL-DAY-00 < 0 THEN                           
PCR361           MOVE SPACES              TO AT-DATE-BILL-DAY-00        
PCR361        END-IF                                                    
              IF WS-NULL-BILL-DAY-30 < 0 THEN                           
                 MOVE SPACES              TO AT-DATE-BILL-DAY-30        
              END-IF                                                    
              IF WS-NULL-BILL-DAY-60 < 0 THEN                           
                 MOVE SPACES              TO AT-DATE-BILL-DAY-60        
              END-IF                                                    
              IF WS-NULL-BILL-DAY-90 < 0 THEN                           
                 MOVE SPACES              TO AT-DATE-BILL-DAY-90        
              END-IF                                                    
              IF WS-NULL-ACCT-CREATE-DT < 0 THEN                        
                 MOVE SPACES              TO AT-ACCT-CREATE-DT          
              END-IF                                                    
              MOVE AT-ACCT-CREATE-DT      TO RS-ACCT-CREATE-DT          
C32257        MOVE AT-CODE-ACCT-STAT      TO RS-CODE-ACCT-STAT          
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
CBSI          MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE 'CSS_ACCOUNT'          TO TABLE-1                    
CBSI          MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
CBSI          MOVE WS-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7800-CALCULATE-ONE-YEAR-AGO                                    *        
      *                                                                *        
PCR361*   CALLS 9700-PROCESS-ABEND                                     *        
      *                                                                *        
      *   WORKS OUT THE DATE ONE YEAR AGO                              *        
      ******************************************************************        
       7800-CALCULATE-ONE-YEAR-AGO.                                     
                                                                        
           MOVE '7800'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL                                                     
              SELECT
              DATEADD( MONTH, -12, CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-ONE-YEAR-AGO                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET    :WS-ONE-YEAR-AGO =                                         
MFA-TR*              CURRENT DATE - 12 MONTH                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_MODEL_SQL'            TO TABLE-1                
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1      
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
C26305******************************************************************        
C26305* 7900-RED-FLAGS                                                 *        
C26305*                                                                *        
C26305*   CALLS 9700-PROCESS-ABEND                                     *        
C26305*                                                                *        
C26305*   WORKS OUT THE DATE ONE YEAR AGO                              *        
C26305******************************************************************        
C26305 7900-RED-FLAGS.                                                  
C26305                                                                  
C26305     MOVE '7900'          TO ACTIVE-PARAGRAPH.                    
C26305     MOVE 'N'             TO RS-RED-FLAG-SAFETY                   
C26305                             RS-RED-FLAG-MAINT                    
C26305                             RS-RED-FLAG-STORM.                   
C26305                                                                  
C26305     EXEC SQL                                                     
C26305        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :KO-RED-FLAG-EXPIRE-DT                                  
C26305     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET    :KO-RED-FLAG-EXPIRE-DT =                                   
MFA-TR*              CURRENT TIMESTAMP                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26305                                                                  
C26305     EXEC SQL                                                     
C26305        OPEN COMM-CURSOR                                          
C26305     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26305                                                                  
C26305     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
C26305                                                                  
C26305     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C26305        NEXT SENTENCE                                             
C26305     ELSE                                                         
C26305        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
C26305        MOVE 'OPEN'                     TO ABEND-FUNCTION         
C26305        MOVE 'CSS_COMM_DATA'            TO TABLE-1                
C26305        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
C26305        MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1      
C26305        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
C26305     END-IF.                                                      
C26305                                                                  
C26305     PERFORM 7910-FETCH-COMMUNICATIONS  THRU 7910-EXIT.           
C26305                                                                  
C26305     EXEC SQL                                                     
C26305        CLOSE COMM-CURSOR                                         
C26305     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26305                                                                  
C26305     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
C26305                                                                  
C26305     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C26305        NEXT SENTENCE                                             
C26305     ELSE                                                         
C26305        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
C26305        MOVE 'CLOSE'                    TO ABEND-FUNCTION         
C26305        MOVE 'CSS_COMM_DATA'            TO TABLE-1                
C26305        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
C26305        MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1      
C26305        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
C26305     END-IF.                                                      
C26305                                                                  
C26305 7900-EXIT.                                                       
C26305     EXIT.                                                        
C26305                                                                  
C26305 7910-FETCH-COMMUNICATIONS.                                       
C26305                                                                  
C26305     EXEC SQL                                                     
C26305         FETCH COMM-CURSOR                                        
C26305          INTO :KO-COMM-TYPE-CD,                                  
C26305               :KO-COMM-SUBTYPE-CODE                              
C26305     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C32622     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
C26305     EVALUATE WS-ACTIVE-RETURN-CODE                               
C26305         WHEN SUCCESSFUL-CALL                                     
C26305             IF (KO-COMM-TYPE-CD      = '31' AND                  
C26305                 KO-COMM-SUBTYPE-CODE = '02') OR                  
C26305                (KO-COMM-TYPE-CD      = '48')                     
C26305                    MOVE 'Y' TO RS-RED-FLAG-SAFETY                
C26305             END-IF                                               
C26305             IF (KO-COMM-TYPE-CD      = '04' AND                  
C26305                 KO-COMM-SUBTYPE-CODE = '06') OR                  
C26305                (KO-COMM-TYPE-CD      = '41' AND                  
C26305                 KO-COMM-SUBTYPE-CODE = '09')                     
C26305                    MOVE 'Y' TO RS-RED-FLAG-MAINT                 
C26305             END-IF                                               
C26305             IF (KO-COMM-TYPE-CD      = '04' AND                  
C26305                 KO-COMM-SUBTYPE-CODE = '17') OR                  
C26305                (KO-COMM-TYPE-CD      = '41' AND                  
C26305                 KO-COMM-SUBTYPE-CODE = '05')                     
C26305                    MOVE 'Y' TO RS-RED-FLAG-STORM                 
C26305             END-IF                                               
C26305         WHEN NOT-FOUND                                           
C26305             GO TO 7910-EXIT                                      
C26305         WHEN OTHER                                               
C26305             MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
C26305             MOVE 'FETCH'               TO ABEND-FUNCTION         
C26305             MOVE 'CSS_COMM_DATA'       TO TABLE-1                
C26305             MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
C26305             MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1      
C26305             PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT            
C26305     END-EVALUATE.                                                
C26305                                                                  
C26305     GO TO 7910-FETCH-COMMUNICATIONS.                             
C26305                                                                  
C26305 7910-EXIT.                                                       
C26305     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9500-CALL-CPD00068                                             *        
      *                                                                *        
      *   CALLS 9700-PROCESS-ABEND                                     *        
      *                                                                *        
      *   CALLS PROGRAM SCSCO068                                       *        
      *****************************************************************         
T19557 9500-CALL-CPD00068.                                              
                                                                        
CVT000*         CALL 'MCSCB068' USING CWS00068-FIELDS,                          
CVT000*                               WS-CODES-DATA-PRESENT,                    
CVT000*                               DCLCSS-ACCOUNT,                           
CVT000*                               ABEND-FILE,                               
CVT000*                               RS-RETURN-CODE.                           
                                                                        
C37405          CALL WS-MCSCB068                                        
C37405                          USING CWS00068-FIELDS,                  
C37405                                WS-CODES-DATA-PRESENT,            
C37405                                DCLCSS-ACCOUNT,                   
C37405                                ABEND-FILE,                       
C37405                                RS-RETURN-CODE.                   
                                                                        
T19557                                                                  
T19557 9500-EXIT.                                                       
T19557     EXIT.                                                        
                                                                        
PCR361******************************************************************        
PCR361* 9700-PROCESS-ABEND   FOR CPD0023C                              *        
PCR361******************************************************************        
PCR361     EXEC SQL                                                             
PCR361        INCLUDE CPD0023C                                                  
PCR361     END-EXEC.                                                            
PCR361                                                                  
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000       ADD 1 TO CTR-ROWS.                                         
CVT000 8100-EXIT.                                                       
CVT000        EXIT.                                                     
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00321                                         00000200
CVT000     END-EXEC.                                                    00000300
