       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR02326.                                     
COB303 DATE-WRITTEN.      FEB 08, 1996.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM UPDATES GUARANTOR INFORMATION FOR A GUARANTEE    *        
      *  ACCOUNT. THIS WILL ALSO ADD/DELETE THE SPECIAL NOTICE ADDRESS *        
      *  BASED ON THE UPDATE TYPE.                                              
      *  PARAMETERS:                                                   *        
      *    UPDATE-TYPE (IUD)                                         *        
      *    GUARANTEE ACCT NO                                           *        
      *    GUARANTOR ACCT NO                                           *        
      *    ADDRESS ID                                                  *        
      *    AMOUNT GUARANTEED                                           *        
      *    CONTRACT ITEM ID (0 FOR NOW)                                *        
      *    SEND NOTICE FLAG                                            *        
      *    GUARANTOR STATUS CODE                                       *        
      *    GUARANTOR STATUS REASON                                     *        
      *    TRIGGER DATE                                                *        
      *    ITEM ID (WORK QUEUE ITEM)                                   *        
      *    SERVICE TYPE CODE                                           *        
      *    ADDR-STREET                                                 *        
      *    CITY-STATE                                                  *        
      *    ZIP-CODE                                                    *        
      *    COUNTRY                                                     *        
      *    ADDRESS-OVERFLOW                                            *        
      *  RETURNS:                                                      *        
      *    RETURN-CODE                                                 *        
      *    LAST UPDATE TS                                              *        
      *    ADDRESS-ID                                                  *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  02/08/96    RNK      RPC ORIGINALLY ADDED.                    *        
*T4158*  09/04/96    AG       TPR 4158    GET NEW ADDRESS-ID FROM A    *        
*T4158*                       COPYBOOK.                                *        
CBSI  *  12/23/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *              MADRAS   ABEND PARAMETERS                         *        
C25552*  03/13/02    MDJ      NEW FIELD GUAR-LTR-STATUS-CD WILL BE     *        
      *                       UPDATED W/ 'P' (PENDING) WHEN A NEW      *        
      *                       GTOR ROW IS INSERTED AND GTOR STATUS = 'A'        
      *                       IF GTOR STATUS IS CHANGED TO 'A', LTR-   *        
      *                       STATUS-CD WILL BE CHANGED TO 'P'.  IF THE*        
      *                       GTOR STATUS IS CHANGED TO 'C' (CANCEL) *          
      *                       OR 'P' (PENDING) AND                     *        
      *                       LTR-STATUS-CD = 'P' THEN THE LTR-STATUS-CD        
      *                       WILL BE CHANGED TO BLANK SO THAT LETTER  *        
      *                       WILL NOT BE SENT.  TRANS HIST WILL BE    *        
      *                       CREATED.                                          
REARCH*  07/11/03    MN90523  RPC CONVERTED TO COBOL SP                *        
REARC2*  10/02/03    BASKAR 1.REMOVE ROWICMS CALL AND USE STATIC INSERT*        
REARC2*                     2.DELETE COMMENTED CODES FOR CLEAN UP      *        
REARC2*                       PROCESSING AS PER BRUCE BIERNASKI        *        
A37666*  04/28/10    FMB      COMMENT OUT ADDRESS DELETE.              *        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02326'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02326 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *---< CSS_GUARANTOR >                                                     
           EXEC SQL                                                             
              INCLUDE TBGTNTR                                                   
           END-EXEC.                                                            
                                                                        
      *---< CSS_SURETY    >                                                     
           EXEC SQL                                                             
              INCLUDE TBSTYBND                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_ADDR_ID_CNTL >                                                  
           EXEC SQL                                                             
              INCLUDE TBADDRID                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_ADDR_FREEFORM >                                                 
           EXEC SQL                                                             
              INCLUDE TBADRFRE                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
      *---< CSS_ACCOUNT >                                                       
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
REARCH*    COPY SYGWCOB.                                                        
REARCH*    COPY SYDBCOB.                                                        
           COPY CWS00303.                                                       
                                                                        
      * ADDED FOR JOURNALING                                                    
           COPY CCA00001.                                                       
           COPY CWS00027.                                                       
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CWSX0010                                                 
REARCH     END-EXEC.                                                            
REARCH*    COPY CWS00010.                                                       
           COPY CWS00056.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00013                                                  
           END-EXEC.                                                            
                                                                        
*T4158     EXEC SQL                                                             
*T4158        INCLUDE CWS00071                                                  
*T4158     END-EXEC.                                                            
                                                                        
*T4158     EXEC SQL                                                             
*T4158        INCLUDE CWS0090A                                                  
*T4158     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9) COMP.                  
           05  PARM-ID1                PIC S9(9) COMP VALUE 1.          
COB305     05 PARM-GRNT-ACCT-NUM        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.        
REARCH     05  PARM-GRNT-AMT-TEMP      PIC X(11).                       
REARCH     05  PARM-GRNT-AMT-RED       REDEFINES PARM-GRNT-AMT-TEMP     
                                       PIC 9(9)V9(2).                   
COB305     05 PARM-GRNT-AMT-NUM        PIC S9(9)V9(2) USAGE COMP-3 
COB305       VALUE 0.     
           05  PARM-GRNT-AMT-DEC       PIC $$$$$$9.9(2).                
COB305     05 PARM-CNT-ITEM-ID-NUM        PIC S9(9)V USAGE COMP-3 
COB305       VALUE 0.         
COB305     05 PARM-GUAR-ACCT-NUM        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.        
COB305     05 PARM-ITEM-ID-NUM        PIC S9(10)V USAGE COMP-3 VALUE 0.        
           05  PARM-TRAN-COMMENT.                                       
               49  PARM-TRAN-COMMENT-LEN                                
                                   PIC S9(04) COMP SYNC VALUE +0.       
               49  PARM-TRAN-COMMENT-TEXT PIC X(210) VALUE SPACES.      
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
REARCH*                                                                         
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
REARCH     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
REARCH     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
REARCH     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
REARCH         49  S-HOST-VARIABLES-V    PIC X(255).                    
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
REARCH         49  S-SQL-STATEMENT-V     PIC X(255).                    
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
REARCH         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
REARCH*                                                                         
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  ROWICMS                 PIC X(07) VALUE 'ROWICMS'.       
REARCH     05  GTT-NAME                PIC X(26)                        
REARCH                                  VALUE 'SESSION.CSR02326_R1'.    
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN          PIC S9(04) COMP.                 
REARCH         49 GTT-ROW-CHAR         PIC X(1024).                     
REARCH     05  GTT-SQLCODE             PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-UPDATE-TS            PIC X(26) VALUE SPACES.          
           05  RS-GUAR-ESTBLSH-DT      PIC X(08) VALUE SPACES.          
REARCH*                                                                         
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
REARCH     05  S-UPDATE-TS             PIC X(26) VALUE SPACES.          
REARCH     05  S-GUAR-ESTBLSH-DT       PIC X(08) VALUE SPACES.          
REARCH*                                                                         
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  SECURITY-EXISTS-SW      PIC X(01) VALUE 'Y'.             
               88 SECURITY-EXISTS                VALUE 'Y'.             
               88 NOT-SECURITY-EXISTS            VALUE 'N'.             
           05  GUARANTOR-EXISTS-SW     PIC X(01) VALUE 'Y'.             
               88 GUARANTOR-EXISTS               VALUE 'Y'.             
               88 NOT-GUARANTOR-EXISTS           VALUE 'N'.             
                                                                        
      * CODE-RENTAL-PROP VALUES                                                 
       01  WS-CODES.                                                    
           05  WS-NON-RENTAL-PROP       PIC X(01) VALUE 'A'.            
           05  WS-NO-REVERT             PIC X(01) VALUE 'C'.            
           05  WS-AUTO-REVERT           PIC X(01) VALUE 'D'.            
                                                                        
       01  WS-MISC.                                                     
REARCH     05  WS-SQLSTATE             PIC X(05) VALUE '     '.         
           05  WS-MONTH                PIC X(02) VALUE SPACES.          
           05  WS-DAY                  PIC X(02) VALUE SPACES.          
           05  WS-YEAR                 PIC X(04) VALUE SPACES.          
                                                                        
           05  WS-RESP-AREA-ID          PIC X(03) VALUE SPACES.         
           05  WS-CODE-RENTAL-PROP      PIC X(01) VALUE SPACE.          
COB305     05 WS-CUSTOMER-NO-NUM        PIC S9(10)V USAGE COMP-3 
COB305       VALUE 0.       
                                                                        
           05  WS-CUSTOMER-NO           PIC X(10)   VALUE SPACES.       
           05  WS-CUSTOMER-NO-RED       REDEFINES WS-CUSTOMER-NO        
                                        PIC 9(10).                      
                                                                        
           05  WS-GUARANTEE-AMT         PIC $$$$$$9.9(2).               
           05  WS-PREMISE-NO            PIC X(10)   VALUE SPACES.       
           05  WS-PREMISE-NO-RED        REDEFINES WS-PREMISE-NO         
                                        PIC 9(10).                      
                                                                        
COB305     05 WS-MASTER-ACCT-NO-NUM        PIC S9(13) USAGE COMP-3 
COB305       VALUE 0.        
           05  WS-MASTER-ACCT-NO        PIC X(13) VALUE SPACES.         
           05  WS-MASTER-ACCT-NO-RED    REDEFINES WS-MASTER-ACCT-NO     
                                        PIC 9(13).                      
                                                                        
COB305     05 WS-ACCOUNT-NO-NUM        PIC S9(13) USAGE COMP-3 VALUE 0.        
           05  WS-ACCOUNT-NO            PIC X(13) VALUE SPACES.         
           05  WS-ACCOUNT-NO-RED        REDEFINES WS-ACCOUNT-NO         
                                        PIC 9(13).                      
                                                                        
COB305     05 WS-ADDRESS-ID-NUM        PIC S9(13) USAGE COMP-3 VALUE 0.        
           05  WS-ADDRESS-ID            PIC X(13) VALUE SPACES.         
           05  WS-ADDRESS-ID-RED        REDEFINES WS-ADDRESS-ID         
                                        PIC 9(13).                      
           05  WS-ADDRESS-FORMAT        PIC X(01) VALUE SPACES.         
                                                                        
           05  NEW-ADDRESS-ID-NUM       PIC S9(13) USAGE COMP-3         
                                                   VALUE ZERO.          
           05  NEW-ADDRESS-ID           PIC X(13) VALUE SPACES.         
           05  NEW-ADDRESS-ID-RED       REDEFINES NEW-ADDRESS-ID        
                                        PIC 9(13).                      
           05  NEW-ADDRESS-FORMAT       PIC X(01) VALUE SPACES.         
           05  WS-ADDR-DEL-FLAG         PIC X(01) VALUE 'N'.            
                                                                        
           05  WS-TRIGGER-DATE-NI       PIC S9(04) COMP VALUE ZERO.     
           05  WS-ESTBLSH-DATE-NI       PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-IND-2            PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-IND-3            PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-IND-4            PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-IND-5            PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-IND-6            PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-IND-7            PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-IND-8            PIC S9(04) COMP VALUE ZERO.     
           05  WS-TRAN-APPL-NO          PIC S9(04) COMP VALUE ZERO.     
REARCH     05  PROGRAM-NAME             PIC X(08) VALUE 'CSR02326'.     
           05  WS-NULL-IND-9            PIC S9(04) COMP VALUE ZERO.     
C25552     05  WS-P                     PIC X(01) VALUE 'P'.            
                                                                        
       01  WS-NEW-ADDR-ID-COMP.                                         
           05  WS-NEW-ADDR-IDENT           PIC 9(13).                   
           05  FILLER REDEFINES WS-NEW-ADDR-IDENT.                      
               10  WS-NEW-ADDR-CHECK-DIGIT PIC 9.                       
               10  WS-NEW-ADDR-ID          PIC 9(12).                   
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
           EXEC SQL DECLARE SECURITY-CURSOR CURSOR FOR                  
              SELECT 'Y'                                                
                FROM CSS_SURETY_BOND                                    
               WHERE ACCOUNT_NO = :SB-ACCOUNT-NO  AND                   
                     CODE_STATUS IN ('A', 'P')                          
           END-EXEC.                                                    
                                                                        
           EXEC SQL DECLARE GUARNTEE-CURSOR CURSOR FOR                  
              SELECT 'Y'                                                
                FROM CSS_GUARANTOR                                      
               WHERE ACCOUNT_NO = :GU-ACCOUNT-NO AND                    
                     GUAR_STATUS_CD IN ('A', 'P')                       
           END-EXEC.                                                    
                                                                        
           EXEC SQL DECLARE GUARNTR-CURSOR CURSOR FOR                   
              SELECT 'Y'                                                
                FROM CSS_GUARANTOR                                      
               WHERE GUARNTR_ACCT_NO = :GU-GUARNTR-ACCT-NO AND          
                     GUAR_STATUS_CD IN ('A', 'P')                       
           END-EXEC.                                                    
                                                                        
HPCCDM*EJECT                                                                    
REARCH*                                                                         
REARCH LINKAGE SECTION.                                                 
REARCH 01  PARM-UPDATE-TYPE              PIC X(01).                     
REARCH 01  PARM-GRNT-ACCT                PIC X(13).                     
REARCH 01  PARM-GRNT-AMT                 PIC X(11).                     
REARCH 01  PARM-CNT-ITEM-ID              PIC X(9).                      
REARCH 01  PARM-GUAR-NOTICE-FLAG         PIC X(01).                     
REARCH 01  PARM-TRIGGER-DATE             PIC X(10).                     
REARCH 01  PARM-STATUS-REASON            PIC X(20).                     
REARCH 01  PARM-STATUS-CD                PIC X(01).                     
REARCH 01  PARM-GUAR-ACCT                PIC X(13).                     
REARCH 01  PARM-ITEM-ID                  PIC X(10).                     
REARCH 01  PARM-UPDATE-TS                PIC X(26).                     
REARCH 01  PARM-SERVICE-TYPE             PIC X(01).                     
REARCH 01  PARM-SN-ADDR-FLAG             PIC X(01).                     
T36933*01  PARM-ADDR-STREET              PIC X(35).                             
T36933*01  PARM-CITY-STATE               PIC X(20).                             
T36933 01  PARM-ADDR-STREET              PIC X(55).                     
T36933 01  PARM-CITY-STATE               PIC X(30).                     
REARCH 01  PARM-ZIP-CODE                 PIC X(09).                     
REARCH 01  PARM-COUNTRY                  PIC X(35).                     
REARCH 01  PARM-ADDRESS-OVERFLOW         PIC X(35).                     
REARCH 01  PARM-USER-ID                  PIC X(09).                     
REARCH 01  PARM-RESP-AREA-ID             PIC X(03).                     
REARCH 01  PARM-TRAN-CMNT-LEN            PIC 9(04) COMP.                
REARCH 01  PARM-TRAN-CMNT-TEXT           PIC X(210).                    
REARCH*                                                                         
REARCH PROCEDURE DIVISION USING   PARM-UPDATE-TYPE                      
REARCH                           ,PARM-GRNT-ACCT                        
REARCH                           ,PARM-GRNT-AMT                         
REARCH                           ,PARM-CNT-ITEM-ID                      
REARCH                           ,PARM-GUAR-NOTICE-FLAG                 
REARCH                           ,PARM-TRIGGER-DATE                     
REARCH                           ,PARM-STATUS-REASON                    
REARCH                           ,PARM-STATUS-CD                        
REARCH                           ,PARM-GUAR-ACCT                        
REARCH                           ,PARM-ITEM-ID                          
REARCH                           ,PARM-UPDATE-TS                        
REARCH                           ,PARM-SERVICE-TYPE                     
REARCH                           ,PARM-SN-ADDR-FLAG                     
REARCH                           ,PARM-ADDR-STREET                      
REARCH                           ,PARM-CITY-STATE                       
REARCH                           ,PARM-ZIP-CODE                         
REARCH                           ,PARM-COUNTRY                          
REARCH                           ,PARM-ADDRESS-OVERFLOW                 
REARCH                           ,PARM-USER-ID                          
REARCH                           ,PARM-RESP-AREA-ID                     
REARCH                           ,PARM-TRAN-CMNT-LEN                    
REARCH                           ,PARM-TRAN-CMNT-TEXT.                  
REARCH*                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
REARCH     EXEC SQL                                                     
REARCH                                                                  
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARC2              :S-RETURN-CODE             AS RETURN_CODE           
REARC2             ,:S-UPDATE-TS               AS UPDATE_TS             
REARC2             ,:S-GUAR-ESTBLSH-DT         AS GUAR_ESTBLSH_DT       
REARCH         FROM                                                     
REARCH             CIS.SYSDUMMY1                                     
REARCH                                                                  
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*             :S-RETURN-CODE             AS RETURN_CODE                   
MFA-TR*            ,:S-UPDATE-TS               AS UPDATE_TS                     
MFA-TR*            ,:S-GUAR-ESTBLSH-DT         AS GUAR_ESTBLSH_DT               
MFA-TR*        FROM                                                             
MFA-TR*            SYSIBM.SYSDUMMY1                                             
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      *                                                                *        
      *     1.  RECEIVE PARMS FROM THE CLIENT.                         *        
      *     2.  FORMAT PACKED NUMERICS.                                *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
REARCH     MOVE PARM-GRNT-AMT              TO PARM-GRNT-AMT-TEMP.       
REARCH     MOVE PARM-TRAN-CMNT-LEN         TO PARM-TRAN-COMMENT-LEN.    
REARCH     MOVE PARM-TRAN-CMNT-TEXT        TO PARM-TRAN-COMMENT-TEXT.   
           MOVE PARM-GRNT-ACCT             TO PARM-GRNT-ACCT-NUM.       
           MOVE PARM-GRNT-AMT-RED          TO PARM-GRNT-AMT-NUM.        
           MOVE PARM-CNT-ITEM-ID           TO PARM-CNT-ITEM-ID-NUM.     
           MOVE PARM-GUAR-ACCT             TO PARM-GUAR-ACCT-NUM.       
           MOVE PARM-ITEM-ID               TO PARM-ITEM-ID-NUM.         
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   2000-PROCESS-OUTPUT                                          *        
      *                                                                *        
      *       1. DESCRIBE RESULT SET                                   *        
      *       2. UPDATE DB2 DATA                                       *        
      *       3. BUILD RESULT SET                                      *        
      *       4. SEND RESULT SET                                       *        
      *                                                                *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 5000-UPDATE                 THRU 5000-EXIT.          
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE.           
           MOVE MH-TRANS-HIST-SEQ-NO       TO RS-UPDATE-TS.             
           IF GU-GUAR-ESTBLSH-DT EQUAL SPACES                           
                 MOVE GU-GUAR-ESTBLSH-DT   TO RS-GUAR-ESTBLSH-DT        
           ELSE                                                         
                 UNSTRING GU-GUAR-ESTBLSH-DT DELIMITED BY '-'           
                     INTO WS-YEAR                                       
                          WS-MONTH                                      
                          WS-DAY                                        
                 STRING WS-MONTH DELIMITED BY SIZE                      
                        WS-DAY DELIMITED BY SIZE                        
                        WS-YEAR DELIMITED BY SIZE                       
                   INTO RS-GUAR-ESTBLSH-DT                              
           END-IF.                                                      
           MOVE '2000'                     TO ACTIVE-PARAGRAPH.         
REARCH     PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT.         
REARC2     ADD +1  TO CTR-ROWS.                                         
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
REARCH*                                                                         
REARCH***************************************************************           
REARCH*  2000A-MOVE-RESULT.                                         *           
REARCH***************************************************************           
REARCH*                                                                         
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE RS-RETURN-CODE            TO S-RETURN-CODE.             
REARCH     MOVE RS-UPDATE-TS              TO S-UPDATE-TS.               
REARCH     MOVE RS-GUAR-ESTBLSH-DT        TO S-GUAR-ESTBLSH-DT.         
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
                                                                        
      ******************************************************************        
      *   5000-UPDATE.                                                 *        
      *                                                                *        
      *       1.   BASED ON THE ACTION CODE (INSERT/UPDATE/DELETE),    *        
      *            PERFORM FUNCTIONALITY.                              *        
      *       2.   IN UPDATE MODE WHEN NEW ADDRESS IS SELECTED,        *        
      *            DELETE THE OLD ADDRESS IF IT WAS CREATED THROUGH    *        
      *            THE LANDLORD PANEL (CHECK WITH NAME_ADDR_XREF AND   *        
      *            BILL_ADDR_XREF TABLE).                              *        
      *       3.   IN DELETE MODE DELETE THE ADDRESS ROCORD IF IT      *        
      *            WAS CREATED BY THE LANDLORD PANEL                   *        
C25552*       4.   IN INSERT MODE, IF GUAR-STATUS = 'A', SET GUAR-LTR  *        
      *            STATUS-CD TO 'P' (PENDING).  IF GUAR-STATUS NOT 'A' *        
      *            MOVE SPACE TO GUAR-LTR-STATUS-CD.                   *        
C25552*       5.   IN UPDATE MODE, IF GUAR-STATUS CHANGED TO 'C' (CANCEL        
      *            OR 'P' (PENDING)                                    *        
      *            AND GUAR-LTR-STATUS-CD = 'P', MAKE GUAR-LTR-STATUS-CD        
      *            = BLANK. (DO NOT SEND CONFIRMATION LETTER)          *        
      *            IF GUAR-STATUS CHANGED TO 'A' (ACTIVE) CHANGE       *        
      *            GUAR-LTR-STATUS-CD TO 'P' (PENDING).                *        
      *            IF GUAR-STATUS CHANGED TO 'R' (MANUAL RELEASE) AND  *        
      *            LTR-STATUS = 'P' (PENDING) CHANGE LTR-STATUS TO     *        
      *            BLANK (LTR NOT SENT).                               *        
      ******************************************************************        
       5000-UPDATE.                                                     
                                                                        
           MOVE PARM-GRNT-ACCT-NUM    TO GU-ACCOUNT-NO                  
                                         SB-ACCOUNT-NO.                 
           MOVE PARM-GUAR-ACCT-NUM    TO GU-GUARNTR-ACCT-NO.            
           MOVE PARM-CNT-ITEM-ID-NUM  TO GU-CNT-ITEM-ID.                
                                                                        
           PERFORM 5100-JRNL-TRAN-HEAD         THRU 5100-EXIT           
      *-------------------------------*                                         
      * PROCESS GUARANTOR INSERT.     *                                         
      *-------------------------------*                                         
           IF PARM-UPDATE-TYPE = 'I'                                    
                                                                        
              MOVE PARM-TRIGGER-DATE     TO GU-GUAR-TRIGGER-DATE        
              IF PARM-TRIGGER-DATE = SPACES                             
                 MOVE -1           TO WS-TRIGGER-DATE-NI                
              ELSE                                                      
                 MOVE +0           TO WS-TRIGGER-DATE-NI                
              END-IF                                                    
                                                                        
              PERFORM 5400-PROCESS-INSERT-ADDR    THRU 5400-EXIT        
              IF PARM-STATUS-CD = 'A' THEN                              
                 MOVE MH-DATE-TRANS      TO GU-GUAR-ESTBLSH-DT          
                 MOVE +0                 TO WS-ESTBLSH-DATE-NI          
C25552           MOVE WS-P               TO GU-GUAR-LTR-STATUS-CD       
              ELSE                                                      
                 MOVE SPACES             TO GU-GUAR-ESTBLSH-DT          
C25552                                      GU-GUAR-LTR-STATUS-CD       
                 MOVE -1                 TO WS-ESTBLSH-DATE-NI          
              END-IF                                                    
C25552        PERFORM 5200-JRNL-INSERT            THRU 5200-EXIT        
                                                                        
              PERFORM 8125-INSERT-GUARANTOR       THRU 8125-EXIT        
      *---------------------------*                                             
      * PROCESS GUARANTOR DELETED *                                             
      *---------------------------*                                             
           ELSE IF PARM-UPDATE-TYPE = 'D'                               
              PERFORM 7000-SELECT-GUARANTOR       THRU 7000-EXIT        
              IF GU-ADDRESS-ID > 0                                      
                 PERFORM 5360-JRNL-ADDR-DEL   THRU 5360-EXIT            
A37666*          PERFORM 8250-DELETE-ADDRESS  THRU 8250-EXIT                    
              END-IF                                                    
              PERFORM 5250-JRNL-DELETE            THRU 5250-EXIT        
              PERFORM 8200-DELETE-GUARANTOR       THRU 8200-EXIT        
                                                                        
      *--------------------------*                                              
      * PROCESS GUARANTOR UPDATE.*                                              
      *--------------------------*                                              
           ELSE IF PARM-UPDATE-TYPE = 'U'                               
                                                                        
              PERFORM 7000-SELECT-GUARANTOR       THRU 7000-EXIT        
                                                                        
              IF GU-ADDRESS-ID > 0                                      
                 IF PARM-SN-ADDR-FLAG = 'Y'                             
                    PERFORM 5350-JRNL-ADDR-UPDT  THRU 5350-EXIT         
                    PERFORM 8260-UPDATE-ADDRESS  THRU 8260-EXIT         
                 ELSE                                                   
                    IF PARM-SN-ADDR-FLAG = 'N'                          
                       PERFORM 5360-JRNL-ADDR-DEL   THRU 5360-EXIT      
A37666*                PERFORM 8250-DELETE-ADDRESS  THRU 8250-EXIT              
                       MOVE 0  TO  GU-ADDRESS-ID                        
                    END-IF                                              
                 END-IF                                                 
              ELSE                                                      
                IF GU-ADDRESS-ID = 0                                    
                   IF PARM-SN-ADDR-FLAG = 'Y'                           
                      PERFORM 5400-PROCESS-INSERT-ADDR  THRU 5400-EXIT  
                      MOVE NEW-ADDRESS-ID-NUM  TO GU-ADDRESS-ID         
                   END-IF                                               
                END-IF                                                  
              END-IF                                                    
              PERFORM 5300-JRNL-UPDATE            THRU 5300-EXIT        
                                                                        
              MOVE PARM-TRIGGER-DATE     TO GU-GUAR-TRIGGER-DATE        
              IF PARM-TRIGGER-DATE = SPACES                             
                 MOVE -1           TO WS-TRIGGER-DATE-NI                
              ELSE                                                      
                 MOVE +0           TO WS-TRIGGER-DATE-NI                
              END-IF                                                    
                                                                        
              MOVE PARM-GRNT-ACCT-NUM          TO GU-ACCOUNT-NO         
              MOVE PARM-GUAR-ACCT-NUM          TO GU-GUARNTR-ACCT-NO    
              MOVE PARM-CNT-ITEM-ID-NUM        TO GU-CNT-ITEM-ID        
              MOVE PARM-UPDATE-TS              TO GU-LAST-UPDATE-TS     
              IF PARM-STATUS-CD NOT EQUAL GU-GUAR-STATUS-CD THEN        
                 IF PARM-STATUS-CD = 'A' THEN                           
                     MOVE MH-DATE-TRANS        TO GU-GUAR-ESTBLSH-DT    
C25552               MOVE +0                   TO WS-ESTBLSH-DATE-NI    
C25552               MOVE WS-P TO GU-GUAR-LTR-STATUS-CD                 
C25552           ELSE                                                   
C25552              IF ((PARM-STATUS-CD = 'C' OR PARM-STATUS-CD = 'R'   
C25552                   OR PARM-STATUS-CD = 'P')                       
C25552                   AND GU-GUAR-LTR-STATUS-CD = WS-P)              
C25552                 MOVE SPACE TO GU-GUAR-LTR-STATUS-CD              
C25552              END-IF                                              
                 END-IF                                                 
              END-IF                                                    
                                                                        
              PERFORM 8150-UPDATE-GUARANTOR       THRU 8150-EXIT        
                                                                        
      *--------------------------------*                                        
      * PROCESS PROGRAMMER LOGIC ERROR.*                                        
      *--------------------------------*                                        
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE '5000'                       TO ACTIVE-PARAGRAPH     
              MOVE 'UPDATE'                     TO ABEND-FUNCTION       
              MOVE 'PROGRAMMER LOGIC'           TO TABLE-1              
              MOVE 'PARM-UPDATE-TYPE'           TO TABLE-ELEMENT-1      
              MOVE PARM-UPDATE-TYPE             TO HOSTVAR-ELEMENT-1    
              PERFORM 9000-SEND-ERROR-RESULT      THRU 9000-EXIT        
              PERFORM 9900-SQL-ERROR-ROUTINE      THRU 9900-EXIT        
                                                                        
           END-IF
                END-IF
           END-IF.                                                      
                                                                        
           MOVE PARM-GRNT-ACCT-NUM             TO AT-ACCOUNT-NO         
                                                  SB-ACCOUNT-NO         
                                                  GU-ACCOUNT-NO.        
           PERFORM 7500-SELECT-ACCOUNT         THRU 7500-EXIT.          
           MOVE AT-CODES-DATA-PRESENT          TO WS-CODES-DATA-PRESENT.
           PERFORM 5500-CHECK-SEC-DEP          THRU 5500-EXIT.          
           PERFORM 8610-UPDATE-CODES           THRU 8610-EXIT.          
                                                                        
                                                                        
           MOVE PARM-GUAR-ACCT-NUM             TO AT-ACCOUNT-NO         
                                                  GU-GUARNTR-ACCT-NO.   
           PERFORM 7500-SELECT-ACCOUNT         THRU 7500-EXIT.          
           MOVE AT-CODES-DATA-PRESENT          TO WS-CODES-DATA-PRESENT.
           PERFORM 5600-CHECK-GUARANTOR        THRU 5600-EXIT.          
           PERFORM 8610-UPDATE-CODES           THRU 8610-EXIT.          
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   5100-JRNL-TRAN-HEAD.                                         *        
      *                                                                *        
      *   1.   MOVE FIELDS TO THE MAINTENANCE TRANSACTION HEADER.      *        
      *        THE FIRST TIME THE TRANSACTION DETAILS ROW IS WRITTEN,  *        
      *        THIS ROW WILL ALSO BE WRITTEN (SEE CPD00067).           *        
      *                                                                *        
      ******************************************************************        
       5100-JRNL-TRAN-HEAD.                                             
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :MH-TRANS-HIST-SEQ-NO             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              EXEC SQL                                                  
                 SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-DATE-TRANS                      
              END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*       EXEC SQL                                                          
MFA-TR*          SET :MH-DATE-TRANS = CURRENT DATE                              
MFA-TR*       END-EXEC                                                          
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                  
CBSI       ELSE                                                         
CBSI          MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CBSI          MOVE '5100'               TO ACTIVE-PARAGRAPH             
CBSI          MOVE 'SET'                TO ABEND-FUNCTION               
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE PARM-GRNT-ACCT       TO HOSTVAR-ELEMENT-1            
CBSI          PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
CBSI          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5100'                TO ACTIVE-PARAGRAPH            
CBSI          MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE SPACES                TO TABLE-1                     
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
CBSI          MOVE PARM-GRNT-ACCT        TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
                                                                        
           MOVE 'F'                       TO MH-CODE-TRAN-TYPE.         
           MOVE PARM-RESP-AREA-ID         TO MH-RESP-AREA-ID.           
           IF PARM-TRAN-COMMENT-TEXT = SPACES                           
              MOVE ZERO                   TO MH-TRAN-COMMENT-LEN        
           ELSE                                                         
              MOVE PARM-TRAN-COMMENT-LEN  TO MH-TRAN-COMMENT-LEN        
           END-IF.                                                      
           MOVE PARM-TRAN-COMMENT-TEXT    TO MH-TRAN-COMMENT-TEXT.      
           MOVE PARM-GRNT-ACCT-NUM        TO MH-ACCOUNT-NO.             
           MOVE ZEROES                    TO MH-CUSTOMER-NO.            
           MOVE ZEROES                    TO MH-PREMISE-NO.             
           MOVE PARM-USER-ID              TO MH-USER-ID.                
           MOVE 'PANEL245'                TO MH-APPL-PROGRAM-ID.        
           MOVE MH-TRANS-HIST-SEQ-NO      TO MI-TRANS-HIST-SEQ-NO.      
           MOVE +1                        TO WS-TRAN-APPL-NO.           
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5200-JRNL-INSERT.                                              *        
      * 1.   MOVE ANY POPULATED INSERT FIELDS TO THE MAINENENCE        *        
      *      TRANSACTION DETAIL RECORD AND CALL COMMON PARAGRAPH FOR   *        
      *      WRITING THE ROW.                                          *        
      *                                                                *        
      ******************************************************************        
       5200-JRNL-INSERT.                                                
                                                                        
           MOVE PARM-GRNT-AMT-NUM        TO PARM-GRNT-AMT-DEC.          
                                                                        
           MOVE '5200'                   TO ACTIVE-PARAGRAPH.           
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < GUARANTEE-ACCT-NO >                       
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE SPACES                TO MI-TABLE-ID.                   
           MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE LENGTH OF PARM-GRNT-ACCT                                
                                      TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE PARM-GRNT-ACCT        TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE 'GUARANTEE ACCT'      TO MI-COLUMN-DESC.                
           PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT.            
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < GUARANTEE-AMOUNT >                        
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE SPACES                TO MI-TABLE-ID.                   
           MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE LENGTH OF PARM-GRNT-AMT-DEC                             
                                      TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE PARM-GRNT-AMT-DEC     TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE 'GUARANTEE AMT'       TO MI-COLUMN-DESC.                
           PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT.            
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < GUARANTOR-STATUS >                        
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE '68'                  TO MI-TABLE-ID.                   
           MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE LENGTH OF PARM-STATUS-CD TO                             
                                         MI-CHG-COLUMN-VALUE-LEN.       
           MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE PARM-STATUS-CD        TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE 'STATUS CODE'         TO MI-COLUMN-DESC.                
           PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT.            
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < TRIGGER_DATE >                            
           IF PARM-TRIGGER-DATE NOT EQUAL SPACES                        
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE SPACES                 TO MI-TABLE-ID                
              MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE LENGTH OF PARM-TRIGGER-DATE                          
                                          TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE PARM-TRIGGER-DATE      TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'TRIGGER DATE'         TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < ESTABLISH DATE  >                         
           IF PARM-STATUS-CD = 'A' THEN                                 
              MOVE WS-TRAN-APPL-NO    TO MI-TRAN-APPL-NO                
              MOVE SPACES             TO MI-TABLE-ID                    
              MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN        
              MOVE LENGTH OF MH-DATE-TRANS                              
                                         TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE MH-DATE-TRANS      TO MI-CHG-COLUMN-VALUE-TEXT       
              MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT       
              MOVE 'ESTABLISHED DATE' TO MI-COLUMN-DESC                 
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < CONTRACT ID >                             
           IF PARM-CNT-ITEM-ID-NUM > 0                                  
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE SPACES                TO MI-TABLE-ID                 
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE LENGTH OF PARM-CNT-ITEM-ID                           
                                         TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-CNT-ITEM-ID      TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'CNT ITEM ID'         TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < GUAR-NOTICE-FLAG >                        
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE '69'                  TO MI-TABLE-ID                    
           MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE LENGTH OF PARM-GUAR-NOTICE-FLAG                         
                                      TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE PARM-GUAR-NOTICE-FLAG TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE 'GUAR NOTICE'         TO MI-COLUMN-DESC.                
           PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT.            
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < GUAR-STATUS-REASON>                       
           IF PARM-STATUS-REASON NOT EQUAL SPACES                       
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE SPACES                TO MI-TABLE-ID                 
              MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE LENGTH OF PARM-STATUS-REASON                         
                                         TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-STATUS-REASON    TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'STATUS REASON'       TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < GUARANTOR-ACCT-NO>                        
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE SPACES                TO MI-TABLE-ID                    
           MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE LENGTH OF PARM-GUAR-ACCT                                
                                      TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE PARM-GUAR-ACCT        TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE 'GUAR ACCOUNT'        TO MI-COLUMN-DESC.                
           PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT.            
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < SERVICE TYPE >                            
           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
           MOVE SPACES                TO MI-TABLE-ID                    
           MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE LENGTH OF PARM-SERVICE-TYPE                             
                                      TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE PARM-SERVICE-TYPE     TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE 'SERVICE TYPE'        TO MI-COLUMN-DESC.                
           PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT.            
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
C25552*--- CREATE JOURNAL ENTRY FOR < GUAR LTR STATUS CD                        
C25552     MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
C25552     MOVE SPACES                TO MI-TABLE-ID                    
C25552     MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN.       
C25552     MOVE LENGTH OF GU-GUAR-LTR-STATUS-CD                         
C25552                                TO MI-CHG-COLUMN-VALUE-LEN.       
C25552     MOVE GU-GUAR-LTR-STATUS-CD TO MI-CHG-COLUMN-VALUE-TEXT.      
C25552     MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT.      
C25552     MOVE 'GUAR LTR STATUS'     TO MI-COLUMN-DESC.                
C25552     PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT.            
C25552     ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5250-JRNL-DELETE.                                              *        
      * 1.   CREATE JOURNAL ENTRIES FOR DELETION OF GUARANTOR DETAILS  *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       5250-JRNL-DELETE.                                                
                                                                        
           MOVE '5250'                   TO ACTIVE-PARAGRAPH.           
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < ACCOUNT-NO >                              
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           MOVE +9                          TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE LENGTH OF PARM-GRNT-ACCT    TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE PARM-GRNT-ACCT              TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE '*DELETED*'                 TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE 'ACCOUNT NO     '           TO MI-COLUMN-DESC.          
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < CNT-ITEM-ID>                              
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           MOVE +9                          TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE LENGTH OF PARM-CNT-ITEM-ID  TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE PARM-CNT-ITEM-ID            TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE '*DELETED*'                 TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE 'CNT ITEM ID    '           TO MI-COLUMN-DESC.          
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < GUAR ACCT NO >                            
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           MOVE +9                          TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE LENGTH OF PARM-GUAR-ACCT    TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE PARM-GUAR-ACCT              TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE '*DELETED*'                 TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE 'GUAR ACCT      '           TO MI-COLUMN-DESC.          
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
                                                                        
       5250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5300-JRNL-UPDATE.                                              *        
      *                                                                *        
      * 1.   JOURNAL ANY FIELDS THAT THE USER HAS CHANGED BY FORMATING *        
      *      TRANSACTION DETAIL RECORD AND CALL COMMON PARAGRAPH FOR   *        
      *      WRITING THE ROW.                                          *        
      *                                                                *        
      ******************************************************************        
       5300-JRNL-UPDATE.                                                
                                                                        
           MOVE '5300' TO ACTIVE-PARAGRAPH.                             
                                                                        
           MOVE GU-AMOUNT-GUARANTEED         TO WS-GUARANTEE-AMT.       
           MOVE PARM-GRNT-AMT-NUM            TO PARM-GRNT-AMT-DEC.      
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < GUARANTEED AMT >                          
           IF GU-AMOUNT-GUARANTEED NOT = PARM-GRNT-AMT-NUM              
              MOVE WS-TRAN-APPL-NO           TO MI-TRAN-APPL-NO         
              MOVE SPACES                    TO MI-TABLE-ID             
              MOVE LENGTH OF PARM-GRNT-AMT-DEC                          
                                             TO MI-CHG-COLUMN-VALUE-LEN 
                                                MI-PRV-COLUMN-VALUE-LEN 
              MOVE PARM-GRNT-AMT-DEC     TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE WS-GUARANTEE-AMT      TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'GUARANTEED AMT '         TO MI-COLUMN-DESC          
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < GUAR-NOTICE-FLAG >                        
           IF PARM-GUAR-NOTICE-FLAG NOT = GU-GUAR-NOTICE-FLAG           
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE '69'                  TO MI-TABLE-ID                 
              MOVE LENGTH OF PARM-GUAR-NOTICE-FLAG TO                   
                                            MI-PRV-COLUMN-VALUE-LEN     
                                            MI-CHG-COLUMN-VALUE-LEN     
              MOVE PARM-GUAR-NOTICE-FLAG TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE GU-GUAR-NOTICE-FLAG   TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'GUAR NOTICE '        TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < GUAR_STATUS_CD  >                         
           IF PARM-STATUS-CD NOT = GU-GUAR-STATUS-CD                    
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE '68'                   TO MI-TABLE-ID                
              MOVE LENGTH OF PARM-STATUS-CD                             
                                          TO MI-CHG-COLUMN-VALUE-LEN    
                                             MI-PRV-COLUMN-VALUE-LEN    
              MOVE PARM-STATUS-CD         TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE GU-GUAR-STATUS-CD      TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'GUAR STATUS CD '      TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
      *--- CREATE JOURNAL ENTRY FOR < ESTABLISH DATE >                          
              IF PARM-STATUS-CD = 'A' THEN                              
                   MOVE WS-TRAN-APPL-NO    TO MI-TRAN-APPL-NO           
                   MOVE SPACES             TO MI-TABLE-ID               
                   MOVE LENGTH OF GU-GUAR-ESTBLSH-DT                    
                                           TO MI-PRV-COLUMN-VALUE-LEN   
                   MOVE LENGTH OF MH-DATE-TRANS                         
                                           TO MI-CHG-COLUMN-VALUE-LEN   
                   MOVE MH-DATE-TRANS      TO                           
                                           MI-CHG-COLUMN-VALUE-TEXT     
                   MOVE GU-GUAR-ESTBLSH-DT TO                           
                                           MI-PRV-COLUMN-VALUE-TEXT     
                   MOVE 'ESTABLISHED DATE' TO MI-COLUMN-DESC            
                   PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT      
                   ADD 1 TO WS-TRAN-APPL-NO                             
C25552*--- CREATE JOURNAL ENTRY FOR LTR STATUS CD >                             
C25552             MOVE WS-TRAN-APPL-NO    TO MI-TRAN-APPL-NO           
C25552             MOVE SPACES             TO MI-TABLE-ID               
C25552             MOVE LENGTH OF GU-GUAR-LTR-STATUS-CD                 
C25552                                     TO MI-PRV-COLUMN-VALUE-LEN   
C25552             MOVE LENGTH OF MH-DATE-TRANS                         
C25552                                     TO MI-CHG-COLUMN-VALUE-LEN   
C25552             MOVE WS-P               TO                           
C25552                                     MI-CHG-COLUMN-VALUE-TEXT     
C25552             MOVE GU-GUAR-LTR-STATUS-CD TO                        
C25552                                     MI-PRV-COLUMN-VALUE-TEXT     
C25552             MOVE 'GUAR LTR STATUS' TO MI-COLUMN-DESC             
C25552             PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT      
C25552             ADD 1 TO WS-TRAN-APPL-NO                             
C25552        ELSE                                                      
C25552           IF ((PARM-STATUS-CD = 'C' OR PARM-STATUS-CD = 'R'      
C25552                OR PARM-STATUS-CD = 'P') AND                      
C25552                GU-GUAR-LTR-STATUS-CD = 'P')                      
C25552             MOVE WS-TRAN-APPL-NO    TO MI-TRAN-APPL-NO           
C25552             MOVE SPACES             TO MI-TABLE-ID               
C25552             MOVE LENGTH OF GU-GUAR-LTR-STATUS-CD                 
C25552                                     TO MI-PRV-COLUMN-VALUE-LEN   
C25552             MOVE LENGTH OF MH-DATE-TRANS                         
C25552                                     TO MI-CHG-COLUMN-VALUE-LEN   
C25552             MOVE SPACE              TO                           
C25552                                     MI-CHG-COLUMN-VALUE-TEXT     
C25552             MOVE GU-GUAR-LTR-STATUS-CD TO                        
C25552                                     MI-PRV-COLUMN-VALUE-TEXT     
C25552             MOVE 'GUAR LTR STATUS' TO MI-COLUMN-DESC             
C25552             PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT      
C25552             ADD 1 TO WS-TRAN-APPL-NO                             
C25552           END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < GUAR_TRIGGER_DATE >                       
           IF PARM-TRIGGER-DATE NOT = GU-GUAR-TRIGGER-DATE              
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE SPACES                TO MI-TABLE-ID                 
              MOVE LENGTH OF PARM-TRIGGER-DATE                          
                                         TO MI-CHG-COLUMN-VALUE-LEN     
                                            MI-PRV-COLUMN-VALUE-LEN     
              MOVE PARM-TRIGGER-DATE     TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE GU-GUAR-TRIGGER-DATE  TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'TRIGGER DATE  '      TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < SERVICE_TYPE_CD   >                       
           IF PARM-SERVICE-TYPE NOT = GU-SERVICE-TYPE-CD                
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE SPACES                TO MI-TABLE-ID                 
              MOVE LENGTH OF PARM-SERVICE-TYPE                          
                                         TO MI-CHG-COLUMN-VALUE-LEN     
                                            MI-PRV-COLUMN-VALUE-LEN     
              MOVE PARM-SERVICE-TYPE     TO MI-CHG-COLUMN-VALUE-TEXT    
              MOVE GU-SERVICE-TYPE-CD    TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE 'SERVICE TYPE  '      TO MI-COLUMN-DESC              
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5320-JRNL-ADDRESS                                             *         
      *                                                               *         
      *      CREATE JOURNAL RECORD FOR ALL ADDRESS FIELDS IN          *         
      *      CSS_ADDR_FREEFORM FOR NEWLY ADDED  ADDRESS               *         
      *****************************************************************         
                                                                        
       5320-JRNL-ADDRESS.                                               
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < ADDR_STREET >                             
           IF PARM-ADDR-STREET > SPACES                                 
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE LENGTH OF PARM-ADDR-STREET                           
                                          TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE PARM-ADDR-STREET       TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'ADDRESS STREET '      TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < CITY_STATE >                              
           IF PARM-CITY-STATE > SPACES                                  
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE LENGTH OF PARM-CITY-STATE                            
                                          TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE PARM-CITY-STATE        TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'CITY, STATE    '      TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < ZIP_CODE >                                
           IF PARM-ZIP-CODE > SPACES                                    
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE LENGTH OF PARM-ZIP-CODE                              
                                          TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE PARM-ZIP-CODE          TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'ZIP CODE '            TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < COUNTRY >                                 
           IF PARM-COUNTRY > SPACES                                     
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE LENGTH OF PARM-COUNTRY                               
                                          TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE PARM-COUNTRY           TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'COUNTRY NAME   '      TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < ADDRESS_OVERFLOW >                        
           IF PARM-ADDRESS-OVERFLOW > SPACES                            
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN    
              MOVE LENGTH OF PARM-ADDRESS-OVERFLOW                      
                                          TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE PARM-ADDRESS-OVERFLOW  TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'ADDR OVERFLOW '       TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
       5320-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 5350-JRNL-ADDR-UPDT                                           *         
      *                                                               *         
      *      CREATE JOURNAL RECORD FOR ALL ADDRESS FIELDS IN          *         
      *      CSS_ADDR_FREEFORM FOR UPDATED ADDRESS INFO               *         
      *****************************************************************         
                                                                        
       5350-JRNL-ADDR-UPDT.                                             
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < ADDR_STREET >                             
           IF PARM-ADDR-STREET NOT = DZ-ADDR-STREET                     
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE LENGTH OF PARM-ADDR-STREET                           
                                          TO MI-PRV-COLUMN-VALUE-LEN    
                                             MI-CHG-COLUMN-VALUE-LEN    
              MOVE PARM-ADDR-STREET       TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE DZ-ADDR-STREET         TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'ADDRESS STREET '      TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < CITY_STATE >                              
           IF PARM-CITY-STATE NOT = DZ-ADDR-CITY-STATE                  
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE LENGTH OF PARM-CITY-STATE                            
                                          TO MI-PRV-COLUMN-VALUE-LEN    
                                             MI-CHG-COLUMN-VALUE-LEN    
              MOVE PARM-CITY-STATE        TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE DZ-ADDR-CITY-STATE     TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'CITY, STATE    '      TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < ZIP_CODE >                                
           IF PARM-ZIP-CODE NOT = DZ-ADDR-ZIP-CODE                      
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE LENGTH OF PARM-ZIP-CODE                              
                                          TO MI-PRV-COLUMN-VALUE-LEN    
                                             MI-CHG-COLUMN-VALUE-LEN    
              MOVE PARM-ZIP-CODE          TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE DZ-ADDR-ZIP-CODE       TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'ZIP CODE '            TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < COUNTRY >                                 
           IF PARM-COUNTRY NOT = DZ-ADDR-COUNTRY                        
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE LENGTH OF PARM-COUNTRY                               
                                          TO MI-PRV-COLUMN-VALUE-LEN    
                                             MI-CHG-COLUMN-VALUE-LEN    
              MOVE PARM-COUNTRY           TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE DZ-ADDR-COUNTRY        TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'COUNTRY NAME   '      TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < ADDRESS_OVERFLOW >                        
           IF PARM-ADDRESS-OVERFLOW NOT = DZ-ADDRESS-OVERFLOW           
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE LENGTH OF PARM-ADDRESS-OVERFLOW                      
                                          TO MI-PRV-COLUMN-VALUE-LEN    
                                             MI-CHG-COLUMN-VALUE-LEN    
              MOVE PARM-ADDRESS-OVERFLOW  TO MI-CHG-COLUMN-VALUE-TEXT   
              MOVE DZ-ADDRESS-OVERFLOW    TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE 'ADDR OVERFLOW '       TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT          
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
       5350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5360-JRNL-ADDR-DEL.                                            *        
      * 1.   CREATE JOURNAL ENTRIES FOR DELETION OF ADDRESS RECORD     *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       5360-JRNL-ADDR-DEL.                                              
                                                                        
           MOVE '5360'                   TO ACTIVE-PARAGRAPH.           
                                                                        
      *--- CREATE JOURNAL ENTRY FOR < ADDRESS-ID >                              
           MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
           MOVE +9                          TO MI-CHG-COLUMN-VALUE-LEN. 
           MOVE LENGTH OF GU-ADDRESS-ID     TO MI-PRV-COLUMN-VALUE-LEN. 
           MOVE GU-ADDRESS-ID               TO MI-PRV-COLUMN-VALUE-TEXT.
           MOVE '*DELETED*'                 TO MI-CHG-COLUMN-VALUE-TEXT.
           MOVE 'ADDRESS ID     '           TO MI-COLUMN-DESC.          
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
       5360-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 5400-PROCESS-INSERT-ADDR                                      *         
      *                                                               *         
      *      WHEN PARM-ADDRESS-ID IS 0 (NEW ADDRESS) GET NEXT         *         
      *      ADDRESS-ID FROM CSS_ADDR_ID_CNTL AND INSERT RECORD       *         
      *      IN CSS_ADDR_FREEFORM TABLE                               *         
      *****************************************************************         
                                                                        
       5400-PROCESS-INSERT-ADDR.                                        
                                                                        
           IF PARM-SN-ADDR-FLAG = 'Y'                                   
              PERFORM 5320-JRNL-ADDRESS           THRU 5320-EXIT        
*T4158*       PERFORM 7200-LOCK-ADDR-ID-CNTL      THRU 7200-EXIT                
*T4158*       PERFORM 7300-SELECT-ADDR-ID-CNTL    THRU 7300-EXIT                
*T4158*       ADD 1 TO I8-ADDRESS-ID                                            
*T4158*       MOVE I8-ADDRESS-ID          TO NEW-ADDRESS-ID-NUM                 
*T4158*       MOVE NEW-ADDRESS-ID-NUM     TO WS-NEW-ADDR-IDENT                  
*T4158*       MOVE WS-NEW-ADDR-ID         TO WS-NBR-TO-BE-CHECKED2              
*T4158*       PERFORM 6210-CALCULATE-CHECK-DIGIT THRU 6210-EXIT                 
*T4158*       MOVE WS-CHECK-DIGIT2        TO WS-NEW-ADDR-CHECK-DIGIT            
*T4158*       MOVE WS-NEW-ADDR-IDENT      TO NEW-ADDRESS-ID-NUM                 
*T4158*       MOVE NEW-ADDRESS-ID-NUM     TO NEW-ADDRESS-ID-RED                 
*T4158*       MOVE 'B'                    TO NEW-ADDRESS-FORMAT                 
*T4158*       PERFORM 8400-UPDATE-ADDR-ID-CNTL THRU 8400-EXIT                   
                                                                        
*T4158        MOVE 'PANEL245'                    TO WS-90-PANEL-NO      
*T4158        MOVE PARM-USER-ID                  TO WS-90-USERID        
*T4158        MOVE PARM-GRNT-ACCT-NUM            TO WS-90-ACCOUNT-NO    
*T4158        MOVE ZEROES                        TO WS-90-CUSTOMER-NO   
*T4158        MOVE ZEROES                        TO WS-90-PREMISE-NO    
                                                                        
*T4158        PERFORM 6202-GET-NEW-ADDRESS-ID    THRU 6202-EXIT         
*T4158        MOVE WS-90-NEW-ADDRESS-ID          TO NEW-ADDRESS-ID-NUM  
*T4158        MOVE NEW-ADDRESS-ID-NUM            TO NEW-ADDRESS-ID-RED  
*T4158        MOVE 'B'                           TO NEW-ADDRESS-FORMAT  
                                                                        
              MOVE NEW-ADDRESS-ID-NUM     TO DZ-ADDRESS-ID              
              MOVE PARM-ADDR-STREET       TO DZ-ADDR-STREET             
              MOVE PARM-CITY-STATE        TO DZ-ADDR-CITY-STATE         
              MOVE PARM-ZIP-CODE          TO DZ-ADDR-ZIP-CODE           
              MOVE PARM-COUNTRY           TO DZ-ADDR-COUNTRY            
              MOVE PARM-ADDRESS-OVERFLOW  TO DZ-ADDRESS-OVERFLOW        
              PERFORM 8500-INSERT-ADDRESS      THRU 8500-EXIT           
           END-IF.                                                      
                                                                        
       5400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5500-CHECK-SEC-DEP                                            *         
      *                                                               *         
      *      CHECK FOR EXISTENCE OF ANY SECURITIES IN CSS_SURETY_BOND *         
      *      OR ANY GUARANTOR DETAIL IN CSS_GUARANTOR TABLE. IF ANY   *         
      *      OF THESE EXISTS THEN THE SECURED-ACCOUNT-INDICATOR       *         
      *      IN CODES-DATA-PRESENT COLUMN OF CSS_ACCOUNT SHOULD NOT   *         
      *      BE MODIFIED                                              *         
      *****************************************************************         
                                                                        
       5500-CHECK-SEC-DEP.                                              
                                                                        
           MOVE 'N'         TO SECURITY-EXISTS-SW.                      
           PERFORM 7400-OPEN-SURETY-CURSOR     THRU 7400-EXIT.          
           PERFORM 7410-FETCH-SURETY-CURSOR    THRU 7410-EXIT.          
           PERFORM 7420-CLOSE-SURETY-CURSOR    THRU 7420-EXIT.          
           IF NOT-SECURITY-EXISTS                                       
              PERFORM 7430-OPEN-GRNTEE-CURSOR     THRU 7430-EXIT        
              PERFORM 7440-FETCH-GRNTEE-CURSOR    THRU 7440-EXIT        
              PERFORM 7450-CLOSE-GRNTEE-CURSOR    THRU 7450-EXIT        
           END-IF.                                                      
                                                                        
           IF SECURITY-EXISTS                                           
              MOVE 'A'    TO WS-CODE-SEC-ACCT                           
           ELSE                                                         
              MOVE SPACES TO WS-CODE-SEC-ACCT                           
           END-IF.                                                      
                                                                        
       5500-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 5600-CHECK-GUARANTOR                                          *         
      *                                                               *         
      *      CHECK FOR EXISTENCE OF ANY SECURITIES IN CSS_SURETY_BOND *         
      *      OR ANY GUARANTOR DETAIL IN CSS_GUARANTOR TABLE. IF ANY   *         
      *      OF THESE EXISTS THEN THE SECURED-ACCOUNT-INDICATOR       *         
      *      IN CODES-DATA-PRESENT COLUMN OF CSS_ACCOUNT SHOULD NOT   *         
      *      BE MODIFIED                                              *         
      *****************************************************************         
                                                                        
       5600-CHECK-GUARANTOR.                                            
                                                                        
           MOVE 'N'         TO GUARANTOR-EXISTS-SW.                     
           PERFORM 7460-OPEN-GUARNT-CURSOR     THRU 7460-EXIT.          
           PERFORM 7470-FETCH-GUARNT-CURSOR    THRU 7470-EXIT.          
           PERFORM 7480-CLOSE-GUARNT-CURSOR    THRU 7480-EXIT.          
                                                                        
           IF GUARANTOR-EXISTS                                          
              MOVE 'A'    TO WS-CODE-GUARANTOR                          
           ELSE                                                         
              MOVE SPACES TO WS-CODE-GUARANTOR                          
           END-IF.                                                      
                                                                        
       5600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7000-SELECT-GUARANTOR                                         *         
      *                                                               *         
      *      SELECT THE DETAILS FROM CSS_GUARANTOR TABLE              *         
      *****************************************************************         
                                                                        
       7000-SELECT-GUARANTOR.                                           
                                                                        
           EXEC SQL                                                     
              SELECT ADDRESS_ID,                                        
                     AMOUNT_GUARANTEED,                                 
                     GUAR_NOTICE_FLAG,                                  
                     GUAR_STATUS_CD,                                    
                     GUAR_STATUS_REASON,                                
                     GUAR_TRIGGER_DATE,                                 
                     ITEM_ID,                                           
                     REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,                        
                     SERVICE_TYPE_CD,                                   
                     GUAR_ESTBLSH_DT,                                   
C25552               GUAR_LTR_STATUS_CD                                 
              INTO :GU-ADDRESS-ID,                                      
                   :GU-AMOUNT-GUARANTEED,                               
                   :GU-GUAR-NOTICE-FLAG,                                
                   :GU-GUAR-STATUS-CD,                                  
                   :GU-GUAR-STATUS-REASON,                              
                   :GU-GUAR-TRIGGER-DATE :WS-TRIGGER-DATE-NI,            
                   :GU-ITEM-ID,                                         
                   :GU-LAST-UPDATE-TS,                                  
                   :GU-SERVICE-TYPE-CD,                                 
                   :GU-GUAR-ESTBLSH-DT :WS-ESTBLSH-DATE-NI,              
C25552             :GU-GUAR-LTR-STATUS-CD                               
              FROM CSS_GUARANTOR                                        
              WHERE ACCOUNT_NO      = :GU-ACCOUNT-NO AND                
                    GUARNTR_ACCT_NO = :GU-GUARNTR-ACCT-NO AND           
                    CNT_ITEM_ID     = :GU-CNT-ITEM-ID                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ADDRESS_ID,                                                
MFA-TR*              AMOUNT_GUARANTEED,                                         
MFA-TR*              GUAR_NOTICE_FLAG,                                          
MFA-TR*              GUAR_STATUS_CD,                                            
MFA-TR*              GUAR_STATUS_REASON,                                        
MFA-TR*              GUAR_TRIGGER_DATE,                                         
MFA-TR*              ITEM_ID,                                                   
MFA-TR*              LAST_UPDATE_TS,                                            
MFA-TR*              SERVICE_TYPE_CD,                                           
MFA-TR*              GUAR_ESTBLSH_DT,                                           
MFA-TR*              GUAR_LTR_STATUS_CD                                         
MFA-TR*       INTO :GU-ADDRESS-ID,                                              
MFA-TR*            :GU-AMOUNT-GUARANTEED,                                       
MFA-TR*            :GU-GUAR-NOTICE-FLAG,                                        
MFA-TR*            :GU-GUAR-STATUS-CD,                                          
MFA-TR*            :GU-GUAR-STATUS-REASON,                                      
MFA-TR*            :GU-GUAR-TRIGGER-DATE:WS-TRIGGER-DATE-NI,                    
MFA-TR*            :GU-ITEM-ID,                                                 
MFA-TR*            :GU-LAST-UPDATE-TS,                                          
MFA-TR*            :GU-SERVICE-TYPE-CD,                                         
MFA-TR*            :GU-GUAR-ESTBLSH-DT:WS-ESTBLSH-DATE-NI,                      
MFA-TR*            :GU-GUAR-LTR-STATUS-CD                                       
MFA-TR*       FROM CSS_GUARANTOR                                                
MFA-TR*       WHERE ACCOUNT_NO      = :GU-ACCOUNT-NO AND                        
MFA-TR*             GUARNTR_ACCT_NO = :GU-GUARNTR-ACCT-NO AND                   
MFA-TR*             CNT_ITEM_ID     = :GU-CNT-ITEM-ID                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-TRIGGER-DATE-NI < 0                                 
                 MOVE SPACES            TO GU-GUAR-TRIGGER-DATE         
              END-IF                                                    
              IF WS-ESTBLSH-DATE-NI < 0                                 
                 MOVE SPACES            TO GU-GUAR-ESTBLSH-DT           
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7000'          TO ACTIVE-PARAGRAPH                  
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_GUARANTOR'      TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CNT_ITEM_ID'        TO TABLE-ELEMENT-2              
CBSI          MOVE 'GUARNTR_ACCT_NO'    TO TABLE-ELEMENT-3              
              MOVE GU-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE GU-CNT-ITEM-ID       TO HOSTVAR-ELEMENT-2            
              MOVE GU-GUARNTR-ACCT-NO   TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7200-LOCK-ADDR-ID-CNTL                                         *        
      *                                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 5400-PROCESS-INSERT-ADDR                       *        
      *                                                                *        
      *     LOCKS THE CSS_ADDR_ID_CNTL TABLE IN EXCLUSIVE MODE TO      *        
      *     CREATE A NEW ADDRESS ID.                                   *        
      ******************************************************************        
                                                                        
*T4158*7200-LOCK-ADDR-ID-CNTL.                                                  
*T4158*                                                                         
*T4158*    MOVE '7200' TO ACTIVE-PARAGRAPH.                                     
*T4158*                                                                         
*T4158*    EXEC SQL                                                             
*T4158*       LOCK TABLE CSS_ADDR_ID_CNTL                                       
*T4158*            IN EXCLUSIVE MODE                                            
*T4158*    END-EXEC.                                                            
*T4158*                                                                         
*T4158*    MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                               
*T4158*                                                                         
*T4158*    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                           
*T4158*       NEXT SENTENCE                                                     
*T4158*    ELSE                                                                 
*T4158*       MOVE PROGRAM-NAME                 TO ABEND-PROGRAM                
*T4158*       MOVE 'LOCK EXCLUSIVE'             TO ABEND-FUNCTION               
*T4158*       MOVE 'CSS_ADDR_ID_CNTL'           TO TABLE-1                      
*T4158*       PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT                  
*T4158*       PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT                  
*T4158*    END-IF.                                                              
*T4158*                                                                         
*T4158*7200-EXIT.                                                               
*T4158*    EXIT.                                                                
*T4158*                                                                         
      ****************************************************************          
      * 7300-SELECT-ADDR-ID-CNTL                                     *          
      ****************************************************************          
                                                                        
*T4158*7300-SELECT-ADDR-ID-CNTL.                                                
*T4158*                                                                         
*T4158*    EXEC SQL                                                             
*T4158*       SELECT ADDRESS_ID                                                 
*T4158*       INTO  :I8-ADDRESS-ID                                              
*T4158*       FROM   CSS_ADDR_ID_CNTL                                           
*T4158*    END-EXEC.                                                            
*T4158*                                                                         
*T4158*    MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                               
*T4158*                                                                         
*T4158*    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                           
*T4158*       CONTINUE                                                          
*T4158*    ELSE                                                                 
*T4158*       MOVE PROGRAM-NAME    TO ABEND-PROGRAM                             
*T4158*       MOVE '7300'          TO ACTIVE-PARAGRAPH                          
*T4158*       MOVE 'SELECT'             TO ABEND-FUNCTION                       
*T4158*       MOVE 'CSS_ADDR_ID_CNTL'   TO TABLE-1                              
*T4158*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
*T4158*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
*T4158*    END-IF.                                                              
*T4158*                                                                         
*T4158*7300-EXIT.                                                               
*T4158*    EXIT.                                                                
                                                                        
      **************************************************************            
      * 7400-OPEN-SURETY-CURSOR                                    *            
      **************************************************************            
       7400-OPEN-SURETY-CURSOR.                                         
           MOVE '7400'                   TO ACTIVE-PARAGRAPH.           
           EXEC SQL                                                     
              OPEN SECURITY-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
CBSI          MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE 'CSS_SURETY_BOND'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE SB-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7410-FETCH-SURETY-CURSOR                                   *            
      **************************************************************            
       7410-FETCH-SURETY-CURSOR.                                        
           MOVE '7410'                   TO ACTIVE-PARAGRAPH.           
           EXEC SQL                                                     
              FETCH SECURITY-CURSOR                                     
               INTO :SECURITY-EXISTS-SW                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'N'           TO SECURITY-EXISTS-SW               
              END-IF                                                    
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
CBSI          MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'CSS_SURETY_BOND'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE SB-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7420-CLOSE-SURETY-CURSOR                                   *            
      **************************************************************            
       7420-CLOSE-SURETY-CURSOR.                                        
           MOVE '7420'                   TO ACTIVE-PARAGRAPH.           
           EXEC SQL                                                     
              CLOSE SECURITY-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
CBSI          MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE 'CSS_SURETY_BOND'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE SB-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7430-OPEN-GRNTEE-CURSOR                                    *            
      **************************************************************            
       7430-OPEN-GRNTEE-CURSOR.                                         
           MOVE '7430'                   TO ACTIVE-PARAGRAPH.           
           EXEC SQL                                                     
              OPEN GUARNTEE-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
CBSI          MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE 'CSS_GUARANTOR'      TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE GU-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7430-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7440-FETCH-GRNTEE-CURSOR                                   *            
      **************************************************************            
       7440-FETCH-GRNTEE-CURSOR.                                        
           MOVE '7440'                   TO ACTIVE-PARAGRAPH.           
           EXEC SQL                                                     
              FETCH GUARNTEE-CURSOR                                     
               INTO :SECURITY-EXISTS-SW                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'N'     TO SECURITY-EXISTS-SW                     
              END-IF                                                    
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
CBSI          MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'CSS_GUARANTOR'      TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE GU-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7440-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7450-CLOSE-GRNTEE-CURSOR                                   *            
      **************************************************************            
       7450-CLOSE-GRNTEE-CURSOR.                                        
           MOVE '7450'                   TO ACTIVE-PARAGRAPH.           
           EXEC SQL                                                     
              CLOSE GUARNTEE-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
CBSI          MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE 'CSS_GUARANTOR'      TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE GU-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7450-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      **************************************************************            
      * 7460-OPEN-GUARNT-CURSOR                                    *            
      **************************************************************            
       7460-OPEN-GUARNT-CURSOR.                                         
CBSI       MOVE '7460'                   TO ACTIVE-PARAGRAPH.           
           EXEC SQL                                                     
              OPEN GUARNTR-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
CBSI          MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE 'CSS_GUARANTOR'      TO TABLE-1                      
              MOVE 'GUARNTR_ACCT_NO'    TO TABLE-ELEMENT-1              
              MOVE GU-GUARNTR-ACCT-NO   TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7460-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7470-FETCH-GUARNT-CURSOR                                   *            
      **************************************************************            
       7470-FETCH-GUARNT-CURSOR.                                        
CBSI       MOVE '7470'                   TO ACTIVE-PARAGRAPH.           
           EXEC SQL                                                     
              FETCH GUARNTR-CURSOR                                      
               INTO :GUARANTOR-EXISTS-SW                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'N'     TO GUARANTOR-EXISTS-SW                    
              END-IF                                                    
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
CBSI          MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'CSS_GUARANTOR'      TO TABLE-1                      
CBSI          MOVE 'GUARNTR_ACCT_NO'    TO TABLE-ELEMENT-1              
              MOVE GU-GUARNTR-ACCT-NO   TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7470-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * 7480-CLOSE-GUARNT-CURSOR                                   *            
      **************************************************************            
       7480-CLOSE-GUARNT-CURSOR.                                        
           MOVE '7480'                   TO ACTIVE-PARAGRAPH.           
           EXEC SQL                                                     
              CLOSE GUARNTR-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
CBSI          MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE 'CSS_GUARANTOR'      TO TABLE-1                      
              MOVE 'GUARNTR_ACCT_NO'    TO TABLE-ELEMENT-1              
              MOVE GU-GUARNTR-ACCT-NO   TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7480-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7500-SELECT-ACCOUNT                                          *          
      ****************************************************************          
                                                                        
       7500-SELECT-ACCOUNT.                                             
                                                                        
            EXEC SQL                                                    
                 SELECT CODES_DATA_PRESENT                              
                 INTO   :AT-CODES-DATA-PRESENT                          
                 FROM   CSS_ACCOUNT AT                                  
                 WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                     
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
                MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT     
            ELSE                                                        
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7500'                  TO ACTIVE-PARAGRAPH         
CBSI           MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE 'CSS_ACCOUNT'           TO TABLE-1                  
               MOVE 'ACCOUNT_NO '           TO TABLE-ELEMENT-1          
               MOVE AT-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  CHECK DIGITS COPYBOOKS.                                       *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00071                                                  
           END-EXEC.                                                            
                                                                        
*T4158     EXEC SQL                                                             
*T4158        INCLUDE CPD00090                                                  
*T4158     END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                                    
                                                                        
                                                                        
      ******************************************************************        
      *  JOURNALING COPYBOOK.                                          *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                                    
      ******************************************************************        
      * 8125-INSERT-GUARANTOR                                          *        
      *                                                                *        
      *    1.  INSERT CSS_GUARANTOR VALUES.                            *        
      *                                                                *        
      ******************************************************************        
       8125-INSERT-GUARANTOR.                                           
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_GUARANTOR                                 
                   ( ACCOUNT_NO,                                        
                     ADDRESS_ID,                                        
                     AMOUNT_GUARANTEED,                                 
                     CNT_ITEM_ID,                                       
                     GUAR_NOTICE_FLAG,                                  
                     GUAR_STATUS_CD,                                    
                     GUAR_STATUS_REASON,                                
                     GUAR_TRIGGER_DATE,                                 
                     GUARNTR_ACCT_NO,                                   
                     ITEM_ID,                                           
                     LAST_UPDATE_TS,                                    
                     SERVICE_TYPE_CD,                                   
C25552               GUAR_LTR_STATUS_CD,                                
                     GUAR_ESTBLSH_DT)                                   
              VALUES                                                    
                   (:PARM-GRNT-ACCT-NUM,                                
                    :NEW-ADDRESS-ID-NUM,                                
                    :PARM-GRNT-AMT-NUM,                                 
                    :PARM-CNT-ITEM-ID-NUM,                              
                    :PARM-GUAR-NOTICE-FLAG,                             
                    :PARM-STATUS-CD,                                    
                    :PARM-STATUS-REASON,                                
                    IIF(TRY_CONVERT(DATE, :GU-GUAR-TRIGGER-DATE 
                                          :WS-TRIGGER-DATE-NI
              ) IS NULL OR (PATINDEX('%.%', :GU-GUAR-TRIGGER-DATE 
                                                    :WS-TRIGGER-DATE-NI
              ) <> 0) OR (LEN(:GU-GUAR-TRIGGER-DATE :WS-TRIGGER-DATE-NI
              ) <> 10), CIS.CHAR2DATE(:GU-GUAR-TRIGGER-DATE 
                                                    :WS-TRIGGER-DATE-NI
              ), CONVERT(DATE, :GU-GUAR-TRIGGER-DATE 
                                                    :WS-TRIGGER-DATE-NI
              ) ),           
                    :PARM-GUAR-ACCT-NUM,                                
                    :PARM-ITEM-ID-NUM,                                  
                    CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO),                  
                    :PARM-SERVICE-TYPE,                                 
C25552              :GU-GUAR-LTR-STATUS-CD,                             
                    IIF(TRY_CONVERT(DATE, :GU-GUAR-ESTBLSH-DT 
                                          :WS-ESTBLSH-DATE-NI
              ) IS NULL OR (PATINDEX('%.%', :GU-GUAR-ESTBLSH-DT 
                                                    :WS-ESTBLSH-DATE-NI
              ) <> 0) OR (LEN(:GU-GUAR-ESTBLSH-DT :WS-ESTBLSH-DATE-NI
              ) <> 10), CIS.CHAR2DATE(:GU-GUAR-ESTBLSH-DT 
                                                    :WS-ESTBLSH-DATE-NI
              ), CONVERT(DATE, :GU-GUAR-ESTBLSH-DT :WS-ESTBLSH-DATE-NI
              ) ))             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_GUARANTOR                                         
MFA-TR*            ( ACCOUNT_NO,                                                
MFA-TR*              ADDRESS_ID,                                                
MFA-TR*              AMOUNT_GUARANTEED,                                         
MFA-TR*              CNT_ITEM_ID,                                               
MFA-TR*              GUAR_NOTICE_FLAG,                                          
MFA-TR*              GUAR_STATUS_CD,                                            
MFA-TR*              GUAR_STATUS_REASON,                                        
MFA-TR*              GUAR_TRIGGER_DATE,                                         
MFA-TR*              GUARNTR_ACCT_NO,                                           
MFA-TR*              ITEM_ID,                                                   
MFA-TR*              LAST_UPDATE_TS,                                            
MFA-TR*              SERVICE_TYPE_CD,                                           
MFA-TR*              GUAR_LTR_STATUS_CD,                                        
MFA-TR*              GUAR_ESTBLSH_DT)                                           
MFA-TR*       VALUES                                                            
MFA-TR*            (:PARM-GRNT-ACCT-NUM,                                        
MFA-TR*             :NEW-ADDRESS-ID-NUM,                                        
MFA-TR*             :PARM-GRNT-AMT-NUM,                                         
MFA-TR*             :PARM-CNT-ITEM-ID-NUM,                                      
MFA-TR*             :PARM-GUAR-NOTICE-FLAG,                                     
MFA-TR*             :PARM-STATUS-CD,                                            
MFA-TR*             :PARM-STATUS-REASON,                                        
MFA-TR*             :GU-GUAR-TRIGGER-DATE:WS-TRIGGER-DATE-NI,                   
MFA-TR*             :PARM-GUAR-ACCT-NUM,                                        
MFA-TR*             :PARM-ITEM-ID-NUM,                                          
MFA-TR*             :MH-TRANS-HIST-SEQ-NO,                                      
MFA-TR*             :PARM-SERVICE-TYPE,                                         
MFA-TR*             :GU-GUAR-LTR-STATUS-CD,                                     
MFA-TR*             :GU-GUAR-ESTBLSH-DT:WS-ESTBLSH-DATE-NI)                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8125'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_GUARANTOR'      TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-2              
CBSI          MOVE 'CNT_ITEM_ID'        TO TABLE-ELEMENT-3              
CBSI          MOVE 'LAST_UPDATE_TS'     TO TABLE-ELEMENT-4              
              MOVE PARM-GRNT-ACCT-NUM   TO HOSTVAR-ELEMENT-1            
CBSI          MOVE NEW-ADDRESS-ID-NUM   TO HOSTVAR-ELEMENT-2            
CBSI          MOVE PARM-CNT-ITEM-ID-NUM TO HOSTVAR-ELEMENT-3            
CBSI          MOVE MH-TRANS-HIST-SEQ-NO TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8125-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8150-UPDATE-GUARANTOR                                          *        
      *                                                                *        
      *    1. UPDATES GUARANTOR INFORMATION. *                                  
      *                                                                *        
      ******************************************************************        
       8150-UPDATE-GUARANTOR.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_GUARANTOR                                      
              SET    AMOUNT_GUARANTEED  = :PARM-GRNT-AMT-NUM,           
                     GUAR_NOTICE_FLAG   = :PARM-GUAR-NOTICE-FLAG,       
                     GUAR_STATUS_CD     = :PARM-STATUS-CD,              
                     GUAR_STATUS_REASON = :PARM-STATUS-REASON,          
                     GUAR_TRIGGER_DATE  =                               
                       IIF(TRY_CONVERT(DATE, :GU-GUAR-TRIGGER-DATE 
                                             :WS-TRIGGER-DATE-NI
              ) IS NULL OR (PATINDEX('%.%', :GU-GUAR-TRIGGER-DATE 
                                                    :WS-TRIGGER-DATE-NI
              ) <> 0) OR (LEN(:GU-GUAR-TRIGGER-DATE :WS-TRIGGER-DATE-NI
              ) <> 10), CIS.CHAR2DATE(:GU-GUAR-TRIGGER-DATE 
                                                    :WS-TRIGGER-DATE-NI
              ), CONVERT(DATE, :GU-GUAR-TRIGGER-DATE 
                                                    :WS-TRIGGER-DATE-NI
              ) ),        
                     ADDRESS_ID         = :GU-ADDRESS-ID,               
                     ITEM_ID            = :PARM-ITEM-ID-NUM,            
                     LAST_UPDATE_TS     = CIS.CHAR2TIMESTAMP(
                                                  :MH-TRANS-HIST-SEQ-NO
              ),        
                     SERVICE_TYPE_CD    = :PARM-SERVICE-TYPE,           
                     GUAR_ESTBLSH_DT    =                               
                       IIF(TRY_CONVERT(DATE, :GU-GUAR-ESTBLSH-DT 
                                             :WS-ESTBLSH-DATE-NI
              ) IS NULL OR (PATINDEX('%.%', :GU-GUAR-ESTBLSH-DT 
                                                    :WS-ESTBLSH-DATE-NI
              ) <> 0) OR (LEN(:GU-GUAR-ESTBLSH-DT :WS-ESTBLSH-DATE-NI
              ) <> 10), CIS.CHAR2DATE(:GU-GUAR-ESTBLSH-DT 
                                                    :WS-ESTBLSH-DATE-NI
              ), CONVERT(DATE, :GU-GUAR-ESTBLSH-DT :WS-ESTBLSH-DATE-NI
              ) ),          
C25552               GUAR_LTR_STATUS_CD = :GU-GUAR-LTR-STATUS-CD        
              WHERE  ACCOUNT_NO      = :GU-ACCOUNT-NO AND               
                     GUARNTR_ACCT_NO = :GU-GUARNTR-ACCT-NO AND          
                     CNT_ITEM_ID     = :GU-CNT-ITEM-ID AND              
                     LAST_UPDATE_TS  = CIS.CHAR2TIMESTAMP(
                                                     :GU-LAST-UPDATE-TS
              )               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_GUARANTOR                                              
MFA-TR*       SET    AMOUNT_GUARANTEED  = :PARM-GRNT-AMT-NUM,                   
MFA-TR*              GUAR_NOTICE_FLAG   = :PARM-GUAR-NOTICE-FLAG,               
MFA-TR*              GUAR_STATUS_CD     = :PARM-STATUS-CD,                      
MFA-TR*              GUAR_STATUS_REASON = :PARM-STATUS-REASON,                  
MFA-TR*              GUAR_TRIGGER_DATE  =                                       
MFA-TR*                :GU-GUAR-TRIGGER-DATE:WS-TRIGGER-DATE-NI,                
MFA-TR*              ADDRESS_ID         = :GU-ADDRESS-ID,                       
MFA-TR*              ITEM_ID            = :PARM-ITEM-ID-NUM,                    
MFA-TR*              LAST_UPDATE_TS     = :MH-TRANS-HIST-SEQ-NO,                
MFA-TR*              SERVICE_TYPE_CD    = :PARM-SERVICE-TYPE,                   
MFA-TR*              GUAR_ESTBLSH_DT    =                                       
MFA-TR*                :GU-GUAR-ESTBLSH-DT:WS-ESTBLSH-DATE-NI,                  
MFA-TR*              GUAR_LTR_STATUS_CD = :GU-GUAR-LTR-STATUS-CD                
MFA-TR*       WHERE  ACCOUNT_NO      = :GU-ACCOUNT-NO AND                       
MFA-TR*              GUARNTR_ACCT_NO = :GU-GUARNTR-ACCT-NO AND                  
MFA-TR*              CNT_ITEM_ID     = :GU-CNT-ITEM-ID AND                      
MFA-TR*              LAST_UPDATE_TS  = :GU-LAST-UPDATE-TS                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8150'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_GUARANTOR'      TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'GUARNTR_ACCT_NO'    TO TABLE-ELEMENT-2              
              MOVE 'CNT_ITEM_ID'        TO TABLE-ELEMENT-3              
CBSI          MOVE 'LAST_UPDATE_TS'     TO TABLE-ELEMENT-4              
              MOVE GU-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE GU-GUARNTR-ACCT-NO   TO HOSTVAR-ELEMENT-2            
              MOVE GU-CNT-ITEM-ID       TO HOSTVAR-ELEMENT-3            
CBSI          MOVE GU-LAST-UPDATE-TS    TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8200-DELETE-GUARANTOR                                          *        
      *                                                                *        
      *    1.  DELETE RECORDS FROM CSS_GUARANTOR BASED ON ACCOUNT NO,  *        
      *        CONTRACT ITEM ID, AND GUARANTOR ACCCOUNT NUMBER.        *        
      *                                                                *        
      ******************************************************************        
       8200-DELETE-GUARANTOR.                                           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_GUARANTOR                                 
              WHERE ACCOUNT_NO = :GU-ACCOUNT-NO AND                     
                    CNT_ITEM_ID = :GU-CNT-ITEM-ID AND                   
                    GUARNTR_ACCT_NO = :GU-GUARNTR-ACCT-NO               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8200'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE 'CSS_GUARANTOR'       TO TABLE-1                     
              MOVE 'ACCOUNT_NO  '        TO TABLE-ELEMENT-1             
              MOVE 'GUARNTR_ACCT_NO'     TO TABLE-ELEMENT-2             
CBSI          MOVE 'CNT_ITEM_ID '        TO TABLE-ELEMENT-3             
              MOVE GU-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
CBSI          MOVE GU-GUARNTR-ACCT-NO    TO HOSTVAR-ELEMENT-2           
CBSI          MOVE GU-CNT-ITEM-ID        TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8250-DELETE-ADDRESS                                            *        
      *                                                                *        
      *    1.  DELETE RECORDS FROM CSS_ADDR_FREEFORM                   *        
      *                                                                *        
      ******************************************************************        
       8250-DELETE-ADDRESS.                                             
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_ADDR_FREEFORM                             
              WHERE ADDRESS_ID = :GU-ADDRESS-ID                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8250'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE 'CSS_ADDR_FREEFORM'   TO TABLE-1                     
              MOVE 'ADDRESS_ID'          TO TABLE-ELEMENT-1             
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
              MOVE GU-ADDRESS-ID         TO HOSTVAR-ELEMENT-1           
CBSI          MOVE PARM-GRNT-ACCT        TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8260-UPDATE-ADDRESS                                            *        
      *                                                                *        
      *    1.  UPDATE RECORD IN CSS_ADDR_FREEFORM BASED ON USER CHANGES*        
      *                                                                *        
      ******************************************************************        
       8260-UPDATE-ADDRESS.                                             
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ADDR_FREEFORM                                  
              SET ADDR_STREET      = :PARM-ADDR-STREET,                 
                  ADDR_CITY_STATE  = :PARM-CITY-STATE,                  
                  ADDR_ZIP_CODE    = :PARM-ZIP-CODE,                    
                  ADDR_COUNTRY     = :PARM-COUNTRY,                     
                  ADDRESS_OVERFLOW = :PARM-ADDRESS-OVERFLOW             
              WHERE ADDRESS_ID = :GU-ADDRESS-ID                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8260'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_ADDR_FREEFORM'   TO TABLE-1                     
              MOVE 'ADDRESS_ID'          TO TABLE-ELEMENT-1             
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
CBSI          MOVE 'ADDR_CITY_STATE'     TO TABLE-ELEMENT-3             
CBSI          MOVE 'ADDR_ZIP_CODE'       TO TABLE-ELEMENT-4             
              MOVE GU-ADDRESS-ID         TO HOSTVAR-ELEMENT-1           
CBSI          MOVE PARM-GRNT-ACCT        TO HOSTVAR-ELEMENT-2           
CBSI          MOVE PARM-CITY-STATE       TO HOSTVAR-ELEMENT-3           
CBSI          MOVE PARM-ZIP-CODE         TO HOSTVAR-ELEMENT-4           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8260-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8300-UPDATE-PREMISE                                           *         
      *                                                               *         
      *      UPDATE CSS_PREMISE TABLE WITH PARAMETERS PASSED          *         
      *****************************************************************         
                                                                        
      *8300-UPDATE-PREMISE.                                                     
      *                                                                         
      *    EXEC SQL                                                             
      *       UPDATE CSS_PREMISE                                                
      *       SET CODE_RENTAL_PROP = :PARM-CODE-RENTAL-PROP                     
      *       WHERE PREMISE_NO = :PARM-PREMISE-NO-NUM                           
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                               
      *                                                                         
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                           
      *       NEXT SENTENCE                                                     
      *    ELSE                                                                 
      *       MOVE PROGRAM-NAME         TO ABEND-PROGRAM                        
      *       MOVE '8300'               TO ACTIVE-PARAGRAPH                     
      *       MOVE 'UPDATE'             TO ABEND-FUNCTION                       
      *       MOVE 'CSS_PREMISE'        TO TABLE-1                              
      *       MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1                      
      *       MOVE PARM-PREMISE-NO      TO HOSTVAR-ELEMENT-1                    
      *       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
      *       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
      *    END-IF.                                                              
      *                                                                         
      *8300-EXIT.                                                               
      *    EXIT.                                                                
                                                                        
      ****************************************************************          
      * 8400-UPDATE-ADDR-ID-CNTL                                     *          
      ****************************************************************          
                                                                        
*T4158*8400-UPDATE-ADDR-ID-CNTL.                                                
*T4158*                                                                         
*T4158*    EXEC SQL                                                             
*T4158*       UPDATE CSS_ADDR_ID_CNTL                                           
*T4158*       SET    ADDRESS_ID = :I8-ADDRESS-ID                                
*T4158*    END-EXEC.                                                            
*T4158*                                                                         
*T4158*    MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                               
*T4158*                                                                         
*T4158*    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                           
*T4158*       CONTINUE                                                          
*T4158*    ELSE                                                                 
*T4158*       MOVE PROGRAM-NAME    TO ABEND-PROGRAM                             
*T4158*       MOVE '8400'          TO ACTIVE-PARAGRAPH                          
*T4158*       MOVE 'UPDATE'             TO ABEND-FUNCTION                       
*T4158*       MOVE 'CSS_ADDR_ID_CNTL'   TO TABLE-1                              
*T4158*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
*T4158*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
*T4158*    END-IF.                                                              
*T4158*                                                                         
*T4158*8400-EXIT.                                                               
*T4158*    EXIT.                                                                
                                                                        
      *****************************************************************         
      * 8500-INSERT-ADDRESS                                           *         
      *****************************************************************         
                                                                        
       8500-INSERT-ADDRESS.                                             
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ADDR_FREEFORM                             
                    (ADDRESS_ID,                                        
                     ADDR_STREET,                                       
                     ADDR_CITY_STATE,                                   
                     ADDR_ZIP_CODE,                                     
                     ADDR_COUNTRY,                                      
                     ADDRESS_OVERFLOW)                                  
              VALUES                                                    
                   (:DZ-ADDRESS-ID,                                     
                    :DZ-ADDR-STREET,                                    
                    :DZ-ADDR-CITY-STATE,                                
                    :DZ-ADDR-ZIP-CODE,                                  
                    :DZ-ADDR-COUNTRY,                                   
                    :DZ-ADDRESS-OVERFLOW)                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '8500'          TO ACTIVE-PARAGRAPH                  
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
CBSI          MOVE 'ADDR_CITY_STATE'    TO TABLE-ELEMENT-3              
CBSI          MOVE 'ADDR_ZIP_CODE'      TO TABLE-ELEMENT-4              
              MOVE NEW-ADDRESS-ID       TO HOSTVAR-ELEMENT-1            
CBSI          MOVE PARM-GRNT-ACCT       TO HOSTVAR-ELEMENT-2            
CBSI          MOVE DZ-ADDR-CITY-STATE   TO HOSTVAR-ELEMENT-3            
CBSI          MOVE DZ-ADDR-ZIP-CODE     TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8610-UPDATE-CODES                                              *        
      *          CALLED EVERYTIME THE LANDLORD TABLE IS UPDATED        *        
      *          IF THE PREMISE HAS AN ACCOUNT THEN THE ACCOUNT        *        
      *          TABLE.CODES_DATA_PRESENT IS UPDATED WITH              *        
      *          THE INFO. IF THE LANDLORD IS DELETED THEN             *        
      *          THE ELEMENT IN CODES DATA PRESENT IS DELETED.         *        
      ******************************************************************        
       8610-UPDATE-CODES.                                               
                                                                        
                                                                        
                                                                        
            MOVE WS-CODES-DATA-PRESENT TO AT-CODES-DATA-PRESENT.        
                                                                        
            EXEC SQL                                                    
                 UPDATE  CSS_ACCOUNT                                    
                 SET     CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT    
                 WHERE   ACCOUNT_NO = :AT-ACCOUNT-NO                    
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '8610'               TO ACTIVE-PARAGRAPH            
               MOVE 'UPDATE'             TO ABEND-FUNCTION              
               MOVE 'CSS_ACCOUNT'        TO TABLE-1                     
               MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
               MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       8610-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNAL INCLUDE                                          *        
      ******************************************************************        
           EXEC SQL                                                             
REARCH         INCLUDE CPDSP300                                                 
           END-EXEC.                                                            
      ******************************************************************        
      *    END PROGRAM COPYLIB                                                  
      ******************************************************************        
REARCH     EXEC SQL                                                             
REARC2         INCLUDE CPD00321                                                 
REARCH     END-EXEC.                                                            
