       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR02323.                                     
COB303 DATE-WRITTEN.                                                    
COB303            FEBRUARY 6, 1996.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETREIVES NAME, ADDRESS AND IDENTIFICATION       *        
      *  RECORDS FOR A GUARANTOR RECORD FROM CSS_ADDR_FORM/FREEFORM,   *        
      *  CSS_NAME, CSS_CUST_STATS, CSS_CUST_PHONE                      *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  02/06/96    RNK      CREATED.                                 *        
CBSI  *  12/22/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *              MADRAS   ABEND PARAMETERS                         *        
C26446*  06/13/02    LEF      INITIALIZE WORK PHONE                    *        
REARCH*  07/11/03    MN90523  RPC CONVERTED TO COBOL SP                *        
REARC2*  10/02/03    BASKAR 1.REMOVE ROWICMS CALL AND USE STATIC INSERT*        
REARC2*                     2.DELETE COMMENTED CODES FOR CLEAN UP      *        
REARC2*                       PROCESSING AS PER BRUCE BIERNASKI        *        
A04527*  06/06/13    MC95456  REMOVE UNUSED COPY BOOK CWS00056         *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02323'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02323 STARTS HERE'.                  
                                                                        
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *---< CSS_ACCOUNT >                                                       
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      *---< CSS_NAME >                                                          
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
                                                                        
      *---< CSS_ADDR_FORMATTED >                                                
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_ADDR_FREEFORM >                                                 
           EXEC SQL                                                             
              INCLUDE TBADRFRE                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_ZIP_CODE >                                                      
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
                                                                        
      *---< CSS_CUST_PHONE  >                                                   
           EXEC SQL                                                             
              INCLUDE TBCSTPHN                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_CUST_STATS  >                                                   
           EXEC SQL                                                             
              INCLUDE TBCSTSTS                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
REARCH*    COPY SYGWCOB.                                                        
REARCH*    COPY SYDBCOB.                                                        
           COPY CCA00001.                                                       
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CWSX0010                                                 
REARCH     END-EXEC.                                                            
REARCH*    COPY CWS00010.                                                       
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
COB305     05 PARM-ACCOUNT-NO-NUM        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.        
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-SUB                      PIC S9(8) COMP VALUE ZERO.       
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME            PIC X(08) VALUE 'CSR02323'.      
REARCH     05  WS-SQLSTATE             PIC X(05) VALUE '     '.         
           05  WS-LENGTH                    PIC S9(4).                  
           05  WS-MAX-SZ                    PIC S9(4).                  
           05  WS-ADD-SUB-CNT          PIC 99 VALUE 1.                  
           05  WS-MONTH                PIC X(02) VALUE SPACES.          
           05  WS-DAY                  PIC X(02) VALUE SPACES.          
           05  WS-YEAR                 PIC X(04) VALUE SPACES.          
                                                                        
       01  NULL-INDICATOR-FIELDS.                                       
           05  WS-TRIGGER-DATE-NI        PIC S9(4) COMP VALUE 0.        
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-ACTIVE-CODE          PIC X(01) VALUE 'A'.             
REARCH*                                                                         
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
REARCH     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
REARCH     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
REARCH     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
REARCH         49  S-HOST-VARIABLES-V    PIC X(255).                    
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
REARCH         49  S-SQL-STATEMENT-V     PIC X(255).                    
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
REARCH         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
REARCH*                                                                         
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  ROWICMS                 PIC X(07) VALUE 'ROWICMS'.       
REARCH     05  GTT-NAME                PIC X(26)                        
REARCH                                  VALUE 'SESSION.CSR02323_R1'.    
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN          PIC S9(04) COMP.                 
REARCH         49 GTT-ROW-CHAR         PIC X(1024).                     
REARCH     05  GTT-SQLCODE             PIC S9(9) COMP.                  
REARCH*                                                                         
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-NAME-USAGE           PIC X(01) VALUE SPACE.           
           05  RS-FULL-NAME            PIC X(70) VALUE SPACE.           
           05  RS-TITLE                PIC X(09) VALUE SPACE.           
           05  RS-FIRST-NAME           PIC X(15) VALUE SPACE.           
           05  RS-MIDDLE-NAME          PIC X(15) VALUE SPACE.           
           05  RS-LAST-NAME            PIC X(40) VALUE SPACE.           
           05  RS-TITLE-SUFFIX1        PIC X(03) VALUE SPACE.           
           05  RS-TITLE-SUFFIX2        PIC X(03) VALUE SPACE.           
           05  RS-ADDR-USAGE           PIC X(01) VALUE SPACE.           
T36933*    05  RS-ADDR-STREET          PIC X(35) VALUE SPACE.                   
T36933*    05  RS-HOUSE-NO             PIC X(05) VALUE SPACE.                   
T36933     05  RS-ADDR-STREET          PIC X(55) VALUE SPACE.           
T36933     05  RS-HOUSE-NO             PIC X(15) VALUE SPACE.           
           05  RS-ADDR-PREFIX1         PIC X(03) VALUE SPACE.           
T36933*    05  RS-ADDR-CITY-STATE      PIC X(20) VALUE SPACE.                   
T36933     05  RS-ADDR-CITY-STATE      PIC X(30) VALUE SPACE.           
           05  RS-ADDR-PREFIX2         PIC X(02) VALUE SPACE.           
T36933*    05  RS-STREET-NAME          PIC X(16) VALUE SPACE.                   
T36933     05  RS-STREET-NAME          PIC X(30) VALUE SPACE.           
           05  RS-STREET-SUFFIX        PIC X(02) VALUE SPACE.           
           05  RS-ADDR-SUFFIX          PIC X(02) VALUE SPACE.           
           05  RS-ADDR-ZIP-CODE        PIC X(09) VALUE SPACE.           
           05  RS-STREET-LOCATION1     PIC X(04) VALUE SPACE.           
T36933*    05  RS-STREET-LOCATION2     PIC X(04) VALUE SPACE.                   
T36933     05  RS-STREET-LOCATION2     PIC X(11) VALUE SPACE.           
           05  RS-ADDR-COUNTRY         PIC X(35) VALUE SPACE.           
           05  RS-TOWN                 PIC X(26) VALUE SPACE.           
           05  RS-STATE                PIC X(02) VALUE SPACE.           
           05  RS-ZIP-CODE             PIC X(05) VALUE SPACE.           
           05  RS-ZIP-CODE-PLUS        PIC X(04) VALUE SPACE.           
           05  RS-ADDR-OVERFLOW        PIC X(35) VALUE SPACE.           
           05  RS-ADDR-OVERFLOW-FORM   PIC X(35) VALUE SPACE.           
           05  RS-CARRIER-ROUTE        PIC X(05) VALUE SPACE.           
           05  RS-HOME-PHONE           PIC X(10) VALUE SPACE.           
           05  RS-WORK-PHONE           PIC X(10) VALUE SPACE.           
           05  RS-PHONE-EXT            PIC X(06) VALUE SPACE.           
           05  RS-DRIVER-LICENSE       PIC X(19) VALUE SPACE.           
           05  RS-CODE-STATE-ID        PIC X(02) VALUE SPACE.           
           05  RS-SSN                  PIC X(09) VALUE SPACE.           
REARCH*                                                                         
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
REARCH     05  S-NAME-USAGE            PIC X(01) VALUE SPACE.           
REARCH     05  S-FULL-NAME             PIC X(70) VALUE SPACE.           
REARCH     05  S-TITLE                 PIC X(09) VALUE SPACE.           
REARCH     05  S-FIRST-NAME            PIC X(15) VALUE SPACE.           
REARCH     05  S-MIDDLE-NAME           PIC X(15) VALUE SPACE.           
REARCH     05  S-LAST-NAME             PIC X(40) VALUE SPACE.           
REARCH     05  S-TITLE-SUFFIX1         PIC X(03) VALUE SPACE.           
REARCH     05  S-TITLE-SUFFIX2         PIC X(03) VALUE SPACE.           
REARCH     05  S-ADDR-USAGE            PIC X(01) VALUE SPACE.           
T36933*    05  S-ADDR-STREET           PIC X(35) VALUE SPACE.                   
T36933*    05  S-HOUSE-NO              PIC X(05) VALUE SPACE.                   
T36933     05  S-ADDR-STREET           PIC X(55) VALUE SPACE.           
T36933     05  S-HOUSE-NO              PIC X(15) VALUE SPACE.           
REARCH     05  S-ADDR-PREFIX1          PIC X(03) VALUE SPACE.           
T36933*    05  S-ADDR-CITY-STATE       PIC X(20) VALUE SPACE.                   
T36933     05  S-ADDR-CITY-STATE       PIC X(30) VALUE SPACE.           
REARCH     05  S-ADDR-PREFIX2          PIC X(02) VALUE SPACE.           
T36933*    05  S-STREET-NAME           PIC X(16) VALUE SPACE.                   
T36933     05  S-STREET-NAME           PIC X(30) VALUE SPACE.           
REARCH     05  S-STREET-SUFFIX         PIC X(02) VALUE SPACE.           
REARCH     05  S-ADDR-SUFFIX           PIC X(02) VALUE SPACE.           
REARCH     05  S-ADDR-ZIP-CODE         PIC X(09) VALUE SPACE.           
REARCH     05  S-STREET-LOCATION1      PIC X(04) VALUE SPACE.           
T36933*    05  S-STREET-LOCATION2      PIC X(04) VALUE SPACE.                   
T36933     05  S-STREET-LOCATION2      PIC X(11) VALUE SPACE.           
REARCH     05  S-ADDR-COUNTRY          PIC X(35) VALUE SPACE.           
REARCH     05  S-TOWN                  PIC X(26) VALUE SPACE.           
REARCH     05  S-STATE                 PIC X(02) VALUE SPACE.           
REARCH     05  S-ZIP-CODE              PIC X(05) VALUE SPACE.           
REARCH     05  S-ZIP-CODE-PLUS         PIC X(04) VALUE SPACE.           
REARCH     05  S-ADDR-OVERFLOW         PIC X(35) VALUE SPACE.           
REARCH     05  S-ADDR-OVERFLOW-FORM    PIC X(35) VALUE SPACE.           
REARCH     05  S-CARRIER-ROUTE         PIC X(05) VALUE SPACE.           
REARCH     05  S-HOME-PHONE            PIC X(10) VALUE SPACE.           
REARCH     05  S-WORK-PHONE            PIC X(10) VALUE SPACE.           
REARCH     05  S-PHONE-EXT             PIC X(06) VALUE SPACE.           
REARCH     05  S-DRIVER-LICENSE        PIC X(19) VALUE SPACE.           
REARCH     05  S-CODE-STATE-ID         PIC X(02) VALUE SPACE.           
REARCH     05  S-SSN                   PIC X(09) VALUE SPACE.           
REARCH     05  S-GUAR-CUST-NO          PIC X(10) VALUE SPACE.           
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  CN-CONSTANTS.                                                
           05  CN-DELIMITER                 PIC X VALUE ';'.            
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
                                                                        
HPCCDM*EJECT                                                                    
REARCH*                                                                         
REARCH LINKAGE SECTION.                                                 
REARCH 01  PARM-ACCOUNT-NO               PIC X(13).                     
REARCH*                                                                         
REARCH PROCEDURE DIVISION USING PARM-ACCOUNT-NO.                        
REARCH*                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH                                                                  
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARC2           :S-RETURN-CODE              AS    RETURN_CODE          
REARC2          ,:S-NAME-USAGE               AS    NAME_USAGE           
REARC2          ,:S-FULL-NAME                AS    FULL_NAME            
REARC2          ,:S-TITLE                    AS    TITLE                
REARC2          ,:S-FIRST-NAME               AS    FIRST_NAME           
REARC2          ,:S-MIDDLE-NAME              AS    MIDDLE_NAME          
REARC2          ,:S-LAST-NAME                AS    LAST_NAME            
REARC2          ,:S-TITLE-SUFFIX1            AS    TITLE_SUFFIX1        
REARC2          ,:S-TITLE-SUFFIX2            AS    TITLE_SUFFIX2        
REARC2          ,:S-ADDR-USAGE               AS    ADDR_USAGE           
REARC2          ,:S-ADDR-STREET              AS    FR_ADDR_STREET       
REARC2          ,:S-HOUSE-NO                 AS    FO_HOUSE_NO          
REARC2          ,:S-ADDR-PREFIX1             AS    FO_ADDR_PREFIX1      
REARC2          ,:S-ADDR-CITY-STATE          AS    FR_CITY_STATE        
REARC2          ,:S-ADDR-PREFIX2             AS    FO_ADDR_PREFIX2      
REARC2          ,:S-STREET-NAME              AS    FO_STREET_NAME       
REARC2          ,:S-STREET-SUFFIX            AS    FO_STREET_SUFFIX     
REARC2          ,:S-ADDR-SUFFIX              AS    FO_ADDR_SUFFIX       
REARC2          ,:S-ADDR-ZIP-CODE            AS    FR_ADDR_ZIP          
REARC2          ,:S-STREET-LOCATION1         AS    FO_STREET1           
REARC2          ,:S-STREET-LOCATION2         AS    FO_STREET2           
REARC2          ,:S-ADDR-COUNTRY             AS    FR_COUNTRY           
REARC2          ,:S-TOWN                     AS    FO_TOWN              
REARC2          ,:S-STATE                    AS    FO_STATE             
REARC2          ,:S-ZIP-CODE                 AS    FO_ZIP_CODE          
REARC2          ,:S-ZIP-CODE-PLUS            AS    FO_ZIP_PLUS          
REARC2          ,:S-ADDR-OVERFLOW            AS    FR_OVERFLOW          
REARC2          ,:S-ADDR-OVERFLOW-FORM       AS    FO_OVERFLOW          
REARC2          ,:S-CARRIER-ROUTE            AS    FO_CARRIER_ROUTE     
REARC2          ,:S-HOME-PHONE               AS    HOME_PHONE           
REARC2          ,:S-WORK-PHONE               AS    WORK_PHONE           
REARC2          ,:S-PHONE-EXT                AS    PHONE_EXT            
REARC2          ,:S-DRIVER-LICENSE           AS    LICENSE              
REARC2          ,:S-CODE-STATE-ID            AS    STATE_ID             
REARC2          ,:S-SSN                      AS    SSN                  
REARC2          ,:S-GUAR-CUST-NO             AS    GUAR_CUST_NO         
REARCH         FROM                                                     
REARC2             CIS.SYSDUMMY1                                     
REARCH                                                                  
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*          :S-RETURN-CODE              AS    RETURN_CODE                  
MFA-TR*         ,:S-NAME-USAGE               AS    NAME_USAGE                   
MFA-TR*         ,:S-FULL-NAME                AS    FULL_NAME                    
MFA-TR*         ,:S-TITLE                    AS    TITLE                        
MFA-TR*         ,:S-FIRST-NAME               AS    FIRST_NAME                   
MFA-TR*         ,:S-MIDDLE-NAME              AS    MIDDLE_NAME                  
MFA-TR*         ,:S-LAST-NAME                AS    LAST_NAME                    
MFA-TR*         ,:S-TITLE-SUFFIX1            AS    TITLE_SUFFIX1                
MFA-TR*         ,:S-TITLE-SUFFIX2            AS    TITLE_SUFFIX2                
MFA-TR*         ,:S-ADDR-USAGE               AS    ADDR_USAGE                   
MFA-TR*         ,:S-ADDR-STREET              AS    FR_ADDR_STREET               
MFA-TR*         ,:S-HOUSE-NO                 AS    FO_HOUSE_NO                  
MFA-TR*         ,:S-ADDR-PREFIX1             AS    FO_ADDR_PREFIX1              
MFA-TR*         ,:S-ADDR-CITY-STATE          AS    FR_CITY_STATE                
MFA-TR*         ,:S-ADDR-PREFIX2             AS    FO_ADDR_PREFIX2              
MFA-TR*         ,:S-STREET-NAME              AS    FO_STREET_NAME               
MFA-TR*         ,:S-STREET-SUFFIX            AS    FO_STREET_SUFFIX             
MFA-TR*         ,:S-ADDR-SUFFIX              AS    FO_ADDR_SUFFIX               
MFA-TR*         ,:S-ADDR-ZIP-CODE            AS    FR_ADDR_ZIP                  
MFA-TR*         ,:S-STREET-LOCATION1         AS    FO_STREET1                   
MFA-TR*         ,:S-STREET-LOCATION2         AS    FO_STREET2                   
MFA-TR*         ,:S-ADDR-COUNTRY             AS    FR_COUNTRY                   
MFA-TR*         ,:S-TOWN                     AS    FO_TOWN                      
MFA-TR*         ,:S-STATE                    AS    FO_STATE                     
MFA-TR*         ,:S-ZIP-CODE                 AS    FO_ZIP_CODE                  
MFA-TR*         ,:S-ZIP-CODE-PLUS            AS    FO_ZIP_PLUS                  
MFA-TR*         ,:S-ADDR-OVERFLOW            AS    FR_OVERFLOW                  
MFA-TR*         ,:S-ADDR-OVERFLOW-FORM       AS    FO_OVERFLOW                  
MFA-TR*         ,:S-CARRIER-ROUTE            AS    FO_CARRIER_ROUTE             
MFA-TR*         ,:S-HOME-PHONE               AS    HOME_PHONE                   
MFA-TR*         ,:S-WORK-PHONE               AS    WORK_PHONE                   
MFA-TR*         ,:S-PHONE-EXT                AS    PHONE_EXT                    
MFA-TR*         ,:S-DRIVER-LICENSE           AS    LICENSE                      
MFA-TR*         ,:S-CODE-STATE-ID            AS    STATE_ID                     
MFA-TR*         ,:S-SSN                      AS    SSN                          
MFA-TR*         ,:S-GUAR-CUST-NO             AS    GUAR_CUST_NO                 
MFA-TR*        FROM                                                             
MFA-TR*            SYSIBM.SYSDUMMY1                                             
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO           TO PARM-ACCOUNT-NO-NUM.       
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                   TO ACTIVE-PARAGRAPH.           
           PERFORM 2200-BUILD-RESULT     THRU 2200-EXIT.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
REARCH*                                                                         
REARCH***************************************************************           
REARCH*  2000A-MOVE-RESULT.                                         *           
REARCH***************************************************************           
REARCH*                                                                         
REARCH 2000A-MOVE-RESULT.                                               
REARCH                                                                  
REARCH     MOVE RS-RETURN-CODE            TO S-RETURN-CODE.             
REARCH     MOVE RS-NAME-USAGE             TO S-NAME-USAGE.              
REARCH     MOVE RS-FULL-NAME              TO S-FULL-NAME.               
REARCH     MOVE RS-TITLE                  TO S-TITLE.                   
REARCH     MOVE RS-FIRST-NAME             TO S-FIRST-NAME.              
REARCH     MOVE RS-MIDDLE-NAME            TO S-MIDDLE-NAME.             
REARCH     MOVE RS-LAST-NAME              TO S-LAST-NAME.               
REARCH     MOVE RS-TITLE-SUFFIX1          TO S-TITLE-SUFFIX1.           
REARCH     MOVE RS-TITLE-SUFFIX2          TO S-TITLE-SUFFIX2.           
REARCH     MOVE RS-ADDR-USAGE             TO S-ADDR-USAGE.              
REARCH     MOVE RS-ADDR-STREET            TO S-ADDR-STREET.             
REARCH     MOVE RS-HOUSE-NO               TO S-HOUSE-NO.                
REARCH     MOVE RS-ADDR-PREFIX1           TO S-ADDR-PREFIX1.            
REARCH     MOVE RS-ADDR-CITY-STATE        TO S-ADDR-CITY-STATE.         
REARCH     MOVE RS-ADDR-PREFIX2           TO S-ADDR-PREFIX2.            
REARCH     MOVE RS-STREET-NAME            TO S-STREET-NAME.             
REARCH     MOVE RS-STREET-SUFFIX          TO S-STREET-SUFFIX.           
REARCH     MOVE RS-ADDR-SUFFIX            TO S-ADDR-SUFFIX.             
REARCH     MOVE RS-ADDR-ZIP-CODE          TO S-ADDR-ZIP-CODE.           
REARCH     MOVE RS-STREET-LOCATION1       TO S-STREET-LOCATION1.        
REARCH     MOVE RS-STREET-LOCATION2       TO S-STREET-LOCATION2.        
REARCH     MOVE RS-ADDR-COUNTRY           TO S-ADDR-COUNTRY.            
REARCH     MOVE RS-TOWN                   TO S-TOWN.                    
REARCH     MOVE RS-STATE                  TO S-STATE.                   
REARCH     MOVE RS-ZIP-CODE               TO S-ZIP-CODE.                
REARCH     MOVE RS-ZIP-CODE-PLUS          TO S-ZIP-CODE-PLUS.           
REARCH     MOVE RS-ADDR-OVERFLOW          TO S-ADDR-OVERFLOW.           
REARCH     MOVE RS-ADDR-OVERFLOW-FORM     TO S-ADDR-OVERFLOW-FORM.      
REARCH     MOVE RS-CARRIER-ROUTE          TO S-CARRIER-ROUTE.           
REARCH     MOVE RS-HOME-PHONE             TO S-HOME-PHONE.              
REARCH     MOVE RS-WORK-PHONE             TO S-WORK-PHONE.              
REARCH     MOVE RS-PHONE-EXT              TO S-PHONE-EXT.               
REARCH     MOVE RS-DRIVER-LICENSE         TO S-DRIVER-LICENSE.          
REARCH     MOVE RS-CODE-STATE-ID          TO S-CODE-STATE-ID.           
REARCH     MOVE RS-SSN                    TO S-SSN.                     
REARCH     MOVE SPACES                    TO S-GUAR-CUST-NO.            
REARCH                                                                  
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      ******************************************************************        
       2200-BUILD-RESULT.                                               
                                                                        
           PERFORM 2400-GUARANTOR-DETAIL        THRU 2400-EXIT.         
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE 100                          TO RS-RETURN-CODE       
REARCH        PERFORM 2000A-MOVE-RESULT         THRU 2000A-EXIT         
REARC2        ADD  +1 TO CTR-ROWS                                       
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
                                                                        
      ****************************************************************          
      * 2400-GUARANTOR-DETAIL                                        *          
      *                                                              *          
      *   1. SELECT ADDRESS, NAME, AND ID DETAILS FOR THE GUARANTOR  *          
      *   2. SEND THE RESULTS.                                       *          
      ****************************************************************          
                                                                        
       2400-GUARANTOR-DETAIL.                                           
                                                                        
           MOVE PARM-ACCOUNT-NO-NUM           TO AT-ACCOUNT-NO.         
           PERFORM 7200-SELECT-ACCT           THRU 7200-EXIT.           
           PERFORM 2410-SELECT-ID             THRU 2410-EXIT.           
                                                                        
           IF AT-ADDRESS-ID = 0                                         
              MOVE HT-ADDRESS-ID         TO DY-ADDRESS-ID               
              MOVE 'A'                   TO RS-ADDR-USAGE               
              PERFORM 7400-SELECT-ADDR-FORM   THRU 7400-EXIT            
              PERFORM 7410-SELECT-CITY        THRU 7410-EXIT            
           ELSE                                                         
              IF AT-ADDRESS-FORMAT = 'A'                                
                 MOVE AT-ADDRESS-ID          TO DY-ADDRESS-ID           
                 MOVE AT-ADDRESS-FORMAT      TO RS-ADDR-USAGE           
                 PERFORM 7400-SELECT-ADDR-FORM   THRU 7400-EXIT         
                 PERFORM 7410-SELECT-CITY        THRU 7410-EXIT         
              ELSE                                                      
                 IF AT-ADDRESS-FORMAT = 'B'                             
                    MOVE AT-ADDRESS-ID          TO DZ-ADDRESS-ID        
                    MOVE AT-ADDRESS-FORMAT      TO RS-ADDR-USAGE        
                    PERFORM 7450-SELECT-ADDR-FREE   THRU 7450-EXIT      
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
                                                                        
           PERFORM 2700-SEND-RESULT           THRU 2700-EXIT.           
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 2410-SELECT-ID                                               *          
      *                                                              *          
      *  SELECT IDENTIFICATION DETAILS FOR THE GUARANTOR             *          
      ****************************************************************          
                                                                        
       2410-SELECT-ID.                                                  
                                                                        
           PERFORM 7510-SELECT-HOME-PHONE      THRU 7510-EXIT.          
           MOVE CB-PHONE-NO                    TO RS-HOME-PHONE.        
C26446     INITIALIZE CB-PHONE-NO.                                      
           PERFORM 7520-SELECT-WORK-PHONE      THRU 7520-EXIT.          
           MOVE CB-PHONE-NO                    TO RS-WORK-PHONE.        
           MOVE CB-EXTENSION-NO                TO RS-PHONE-EXT.         
           PERFORM 7530-SELECT-STATS           THRU 7530-EXIT.          
           MOVE CE-CODE-STATE-ID               TO RS-CODE-STATE-ID.     
           MOVE CE-DRIVERS-LICENSE-NO          TO RS-DRIVER-LICENSE.    
           MOVE CE-SSN                         TO RS-SSN.               
                                                                        
       2410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2700-SEND-RESULT                                              *         
      *                                                               *         
      *     GATHER VALUES INTO RS-... VARIABLES AND SEND THE RESULT   *         
      *****************************************************************         
                                                                        
       2700-SEND-RESULT.                                                
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE.             
           MOVE DQ-NAME-FORMAT           TO RS-NAME-USAGE.              
           MOVE DQ-FULL-NAME             TO RS-FULL-NAME.               
           MOVE DQ-TITLE-PREFIX          TO RS-TITLE.                   
           MOVE DQ-FIRST-NAME            TO RS-FIRST-NAME.              
           MOVE DQ-MIDDLE-NAME           TO RS-MIDDLE-NAME.             
           MOVE DQ-LAST-NAME             TO RS-LAST-NAME.               
           MOVE DQ-TITLE-SUFFIX-1        TO RS-TITLE-SUFFIX1.           
           MOVE DQ-TITLE-SUFFIX-2        TO RS-TITLE-SUFFIX2.           
           MOVE DZ-ADDR-STREET           TO RS-ADDR-STREET.             
           MOVE DZ-ADDR-CITY-STATE       TO RS-ADDR-CITY-STATE.         
           MOVE DZ-ADDR-COUNTRY          TO RS-ADDR-COUNTRY.            
           MOVE DZ-ADDR-ZIP-CODE         TO RS-ADDR-ZIP-CODE.           
           MOVE DZ-ADDRESS-OVERFLOW      TO RS-ADDR-OVERFLOW.           
           MOVE DY-ADDR-PREFIX-1         TO RS-ADDR-PREFIX1.            
           MOVE DY-ADDR-PREFIX-2         TO RS-ADDR-PREFIX2.            
           MOVE DY-STREET-NAME           TO RS-STREET-NAME.             
           MOVE DY-STREET-SUFFIX         TO RS-STREET-SUFFIX.           
           MOVE DY-ADDR-SUFFIX           TO RS-ADDR-SUFFIX.             
           MOVE DY-STREET-LOCATION-1     TO RS-STREET-LOCATION1.        
           MOVE DY-STREET-LOCATION-2     TO RS-STREET-LOCATION2.        
           MOVE DY-HOUSE-NO              TO RS-HOUSE-NO.                
           MOVE DY-CARRIER-ROUTE         TO RS-CARRIER-ROUTE.           
           MOVE DY-ZIP-CODE              TO RS-ZIP-CODE.                
           MOVE DY-ZIP-CODE-PLUS-FOUR    TO RS-ZIP-CODE-PLUS.           
           MOVE DY-ADDRESS-OVERFLOW      TO RS-ADDR-OVERFLOW-FORM.      
           MOVE A4-TOWN                  TO RS-TOWN.                    
           MOVE A4-STATE                 TO RS-STATE.                   
                                                                        
                                                                        
REARCH     PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT.                   
REARC2     ADD  +1 TO CTR-ROWS.                                         
                                                                        
       2700-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ****************************************************************          
      * 7200-SELECT-ACCT                                             *          
      *                                                              *          
      *      SELECT ADDRESS-ID, FORMAT AND CUSTOMMER NO FROM         *          
      *      CSS_ACCOUNT TABLE                                       *          
      ****************************************************************          
                                                                        
       7200-SELECT-ACCT.                                                
                                                                        
           EXEC SQL                                                     
              SELECT AT.ADDRESS_ID,                                     
                     AT.ADDRESS_FORMAT,                                 
                     AT.CUSTOMER_NO,                                    
                     AT.CREDIT_STATUS_CODE,                             
                     HT.ADDRESS_ID,                                     
                     DQ.NAME_FORMAT,                                    
                     DQ.LAST_NAME,                                      
                     DQ.FIRST_NAME,                                     
                     DQ.MIDDLE_NAME,                                    
                     DQ.TITLE_PREFIX,                                   
                     DQ.TITLE_SUFFIX_1,                                 
                     DQ.TITLE_SUFFIX_2,                                 
                     DQ.FULL_NAME                                       
                INTO :AT-ADDRESS-ID,                                    
                     :AT-ADDRESS-FORMAT,                                
                     :AT-CUSTOMER-NO,                                   
                     :AT-CREDIT-STATUS-CODE,                            
                     :HT-ADDRESS-ID,                                    
                     :DQ-NAME-FORMAT,                                   
                     :DQ-LAST-NAME,                                     
                     :DQ-FIRST-NAME,                                    
                     :DQ-MIDDLE-NAME,                                   
                     :DQ-TITLE-PREFIX,                                  
                     :DQ-TITLE-SUFFIX-1,                                
                     :DQ-TITLE-SUFFIX-2,                                
                     :DQ-FULL-NAME                                      
                FROM CSS_ACCOUNT AT,                                    
                     CSS_NAME_ACCT_XREF HT,                             
                     CSS_NAME DQ                                        
               WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO AND                 
                     HT.ACCOUNT_NO = AT.ACCOUNT_NO AND                  
                     HT.NAME_ID = DQ.NAME_ID AND                        
                     HT.CUSTOMER_ROLE_CD = ' ' AND                      
                     DQ.NAME_TYPE = 'CN'                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7200'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCOUNT'        TO TABLE-1                      
              MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-2                      
CBSI          MOVE 'CSS_NAME'           TO TABLE-3                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ****************************************************************          
      * 7400-SELECT-ADDR-FORM                                        *          
      *                                                              *          
      *      SELECT FROMATTED ADDRESS FOR THE ACCOUNT                *          
      ****************************************************************          
                                                                        
       7400-SELECT-ADDR-FORM.                                           
                                                                        
           EXEC SQL                                                     
               SELECT HOUSE_NO,                                         
                      ADDR_PREFIX_1,                                    
                      ADDR_PREFIX_2,                                    
                      STREET_NAME,                                      
                      ADDRESS_OVERFLOW,                                 
                      ADDR_USAGE_CD,                                    
                      CARRIER_ROUTE,                                    
                      STREET_SUFFIX,                                    
                      STREET_LOCATION_1,                                
                      STREET_LOCATION_2,                                
                      ZIP_CODE,                                         
                      ZIP_CODE_PLUS_FOUR,                               
                      ZIP_CODE_TOKEN                                    
               INTO   :DY-HOUSE-NO,                                     
                      :DY-ADDR-PREFIX-1,                                
                      :DY-ADDR-PREFIX-2,                                
                      :DY-STREET-NAME,                                  
                      :DY-ADDRESS-OVERFLOW,                             
                      :DY-ADDR-USAGE-CD,                                
                      :DY-CARRIER-ROUTE,                                
                      :DY-STREET-SUFFIX,                                
                      :DY-STREET-LOCATION-1,                            
                      :DY-STREET-LOCATION-2,                            
                      :DY-ZIP-CODE,                                     
                      :DY-ZIP-CODE-PLUS-FOUR,                           
                      :DY-ZIP-CODE-TOKEN                                
                 FROM CSS_ADDR_FORMATTED                                
                WHERE ADDRESS_ID = :DY-ADDRESS-ID                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7400'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE DY-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7410-SELECT-CITY                                               *        
      *                                                                *        
      *     GET CITY BASED ON ZIP CODE & TOKEN.                        *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7410-SELECT-CITY.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOWN, STATE                                       
                 INTO :A4-TOWN, :A4-STATE                               
                 FROM CSS_ZIP_CODE                                      
                WHERE ZIP_CODE       = :DY-ZIP-CODE                     
                  AND ZIP_CODE_TOKEN = :DY-ZIP-CODE-TOKEN               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               MOVE 0 TO WS-ACTIVE-RETURN-CODE                          
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                   MOVE SPACE TO A4-TOWN                                
                   MOVE SPACE TO A4-STATE                               
               ELSE                                                     
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE '7410'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'SELECT'               TO ABEND-FUNCTION        
                   MOVE 'CSS_ZIP_CODE'         TO TABLE-1               
                   MOVE 'ZIP_CODE'             TO TABLE-ELEMENT-1       
                   MOVE 'ZIP_CODE_TOKEN'       TO TABLE-ELEMENT-2       
CBSI               MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-3       
                   MOVE DY-ZIP-CODE            TO HOSTVAR-ELEMENT-1     
                   MOVE DY-ZIP-CODE-TOKEN      TO HOSTVAR-ELEMENT-2     
CBSI               MOVE PARM-ACCOUNT-NO        TO HOSTVAR-ELEMENT-3     
                   PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
                   PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
               END-IF                                                   
           END-IF.                                                      
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7450-SELECT-ADDR-FREE                                        *          
      *                                                              *          
      *      SELECT FREE FORM ADDRESS FOR THE ACCOUNT                *          
      ****************************************************************          
                                                                        
       7450-SELECT-ADDR-FREE.                                           
                                                                        
           EXEC SQL                                                     
               SELECT ADDR_STREET, ADDR_CITY_STATE, ADDR_ZIP_CODE,      
                      ADDR_COUNTRY, ADDRESS_OVERFLOW                    
               INTO   :DZ-ADDR-STREET, :DZ-ADDR-CITY-STATE,             
                      :DZ-ADDR-ZIP-CODE, :DZ-ADDR-COUNTRY,              
                      :DZ-ADDRESS-OVERFLOW                              
                 FROM CSS_ADDR_FREEFORM                                 
                WHERE ADDRESS_ID = :DZ-ADDRESS-ID                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7450'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE DZ-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7450-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
                                                                        
      ****************************************************************          
      * 7510-SELECT-HOME-PHONE                                       *          
      *                                                              *          
      *  SELECT HOME PHONE DETAILS  FOR THE GUARANTOR                *          
      ****************************************************************          
                                                                        
       7510-SELECT-HOME-PHONE.                                          
                                                                        
           EXEC SQL                                                     
               SELECT PHONE_NO                                          
               INTO   :CB-PHONE-NO                                      
                 FROM CSS_CUST_PHONE                                    
                WHERE CUSTOMER_NO = :AT-CUSTOMER-NO AND                 
                      CUSTOMER_TYPE = 'C'           AND                 
                      PHONE_TYPE = 'H1'                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE 0 TO WS-ACTIVE-RETURN-CODE                           
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7510'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_PHONE'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-2              
              MOVE 'PHONE_TYPE'         TO TABLE-ELEMENT-3              
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-4              
              MOVE AT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'C'                  TO HOSTVAR-ELEMENT-2            
              MOVE 'H1'                 TO HOSTVAR-ELEMENT-3            
CBSI          MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ****************************************************************          
      * 7520-SELECT-WORK-PHONE                                       *          
      *                                                              *          
      *  SELECT WORK PHONE DETAILS  FOR THE GUARANTOR                *          
      ****************************************************************          
                                                                        
       7520-SELECT-WORK-PHONE.                                          
                                                                        
           EXEC SQL                                                     
               SELECT PHONE_NO, EXTENSION_NO                            
               INTO   :CB-PHONE-NO, :CB-EXTENSION-NO                    
                 FROM CSS_CUST_PHONE                                    
                WHERE CUSTOMER_NO = :AT-CUSTOMER-NO AND                 
                      CUSTOMER_TYPE = 'C'           AND                 
                      PHONE_TYPE = 'W1'                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE 0 TO WS-ACTIVE-RETURN-CODE                           
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7520'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_PHONE'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-2              
              MOVE 'PHONE_TYPE'         TO TABLE-ELEMENT-3              
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-4              
              MOVE AT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'C'                  TO HOSTVAR-ELEMENT-2            
              MOVE 'W1'                 TO HOSTVAR-ELEMENT-3            
CBSI          MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ****************************************************************          
      * 7530-SELECT-STATS                                            *          
      *                                                              *          
      *  SELECT DEMOGRAPHIC STATISTICS FOR THE GUARANTOR*                       
      ****************************************************************          
                                                                        
       7530-SELECT-STATS.                                               
                                                                        
           EXEC SQL                                                     
               SELECT CODE_STATE_ID, DRIVERS_LICENSE_NO,                
                      SSN                                               
               INTO   :CE-CODE-STATE-ID, :CE-DRIVERS-LICENSE-NO,        
                      :CE-SSN                                           
                 FROM CSS_CUST_STATS                                    
                WHERE CUSTOMER_NO = :AT-CUSTOMER-NO AND                 
                      CUSTOMER_TYPE = 'C'                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE 0 TO WS-ACTIVE-RETURN-CODE                           
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7530'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_STATS'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-2              
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-3              
              MOVE AT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'C'                  TO HOSTVAR-ELEMENT-2            
CBSI          MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7530-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
REARCH         INCLUDE CPDSP300                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
REARCH     EXEC SQL                                                             
REARC2         INCLUDE CPD00321                                                 
REARCH     END-EXEC.                                                            
