       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR02322.                                          
COB303 DATE-WRITTEN. AUGUST 12, 2005.                                   
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S322                                           *        
      *  PROGRAM:       S322                                           *        
      *  CALLING SP:    PN_S322                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *        
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *        
      *  THIS PROGRAM RETRIEVES RETRIEVES DATA TO BE USED TO APPLY     *        
      *  A NEW RATE CODE TO THE EXISTING BILL DATA AND DETERMINE THE   *        
      *  NEW BILLING AMOUNT BASED ON THE NEW RATE CODE.                *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  02/05/96    PP       CREATED FOR PANEL153.                    *        
      *  08/22/96    WMG      TPR 5113 - ADDED WS-REFUND TO THE CALL   *        
      *                       TO SCSCA107, INITIALIZED THE             *        
      *                       WS-REFUND-RN VARIABLE, AND INCREASED     *        
      *                       THE STORAGE CAPACITY OF THE FOLLOWING    *        
      *                       WORKING STORAGE VARIABLES:               *        
      *                                  WS-HOLD-CX-DATA               *        
      *                                  WS-HOLD-BC-DATA               *        
      *                                  WS-HOLD-BA-DATA               *        
TP8213*  01/27/97    KOG      ADDED LOGIC TO GET THE LAST 12 BILLED    *        
TP8213*                       MONTHS CONSUMPTION DATA WHEN AN ACCOUNT  *        
TP8213*                       HAS NO CURRENT BILLING.                  *        
TP9961*  03/28/97    PP       ADDED NULL INDICATOR TO DATE_BILLED      *        
TP9961*                       TO AVOID -305 ABENDING.                  *        
TP9609*  04/01/97    PP       TPR9609 - MADE WNA-FACTOR ZERO.          *        
T10202*  04/09/97    PP       TPR10202- MODIFIED CX-CURSOR.            *        
T11128*  05/13/97    PP       TPR11128- RATE-PLAN-NO WILL BE READ FROM *        
T11128*                       CSS_UTIL_ENVRNMT, NOT FROM BILLING HDR.  *        
TPTIM *  05/19/97    RAH      ADD WS-BC-MTHLY-AMOUNT-FIXED-UC TO UC    *        
TPTIM *                       LOGIC.  PER TIM FULLER.                  *        
      *  06/02/97    RAH      DROP IDR WORKSHEET FROM LINKAGE AREA.    *        
      *                       ALSO, DELETE IDR WORKSHEET WS.           *        
T11798*  06/25/97    PP       TPR11798- SUBDIVISION LIGHTING TO BE     *        
T11798*                       CALCULATED ONLY WHEN CODE_PLAN_STATUS='A'*        
T11798*                       IN CSS_CUST_PLAN.                        *        
T11888*  07/01/97    PP       TPR11888- THIS IS AN EXTENSION OF TPR#   *        
T11888*                       10610 WRITTEN BY ERIC FOR PANEL146. THE  *        
T10610*                       SAME LOGIC IS BEING IMPLEMENTED FOR      *        
T10610*                       CALCULATING PRIVATE AND SUBDIVISION LIGHT*        
T11888*  07/09/97    PP       TPR11888- CHANGES TO DISPLAY ONLY 12 ROWS*        
T12936*  08/27/97    PP       TPR12936- MODIFIED TO SHOW CANCEL/REBILLS*        
T13055*  10/28/97    MKN      ADDED PARA 2590- TO DISPLAY ITEM UNDER   *        
      *                       DIFFERENT CATEGORIES BASED ON THEIR RATE *        
      *                       PLAN NO                                  *        
T13225*  10/28/97    MKN      ADDED LOGIC TO COMPUTE TAXES             *        
      *                       ALSO ADDED LOGIC FOR DATE CALCULATION    *        
T13883*  12/01/97    MKN      USED DATE PASSED FROM POWERBUILDER FOR   *        
      *                       BILL CALC                                *        
T13714*  12/01/97    MKN      RS-UNITS CONVERTED FROM CCF TO THERMS    *        
T9127 *  12/23/97    MKN      SCSCA107 REPLACED WITH SCSCO107          *        
T14555*  01/29/98    RAH      INCREASE CX OCCURANCES TO 200            *        
CICS  *  04/21/98    AMG      CHANGED THE CALL TO SCSCO107 FROM BATCH  *        
CICS  *                       TO ONLINE (CICS)                         *        
T16108*  05/11/98    SV       TO REMOVE HARDCODED RATES WHICH DECIDES  *        
      *                       THE EPP CATEGORY                         *        
CBSI  *  12/29/98    KP       MC05 ABEND LOG CORRECTIONS               *        
T20141*   6/07/99    BB       UPDATE TAX PROCESSING TO ACCOMODATE FOR  *        
      *                       MULTIPLE 'OTHER' TAXES.                  *        
T20983*  10/28/99    RDF      WHEN COMPUTING COST OF PRIVATE LIGHT     *        
      *                       MUST LOOK FOR TYPE = 'U' OR 'E'.         *        
      *                       FOR PARAGRAPH 2600- GET PRIVATE LIGHT    *        
      *                       AMOUNT FROM BILL-CALC-DET RECORD.        *        
      *                       ALLOW FOR DISPLAYING SUBD AND PVT AMOUNT *        
      *                       IN PANEL 153.                            *        
T22788*  09/15/00    DCS      READ DELINQUENCY TABLE TO DETERMINE IF   *        
T22788*                       SEB OR SCEG. IF SEB, CALCULATE ALL OF EPP*        
T22788*                       SCHEDULE WITH CURRENT REVENUE MONTH'S    *        
T22788*                       RATE. IF SCEG, PASS EACH INDIVIDUAL      *        
T22788*                       REVENUE MONTH TO SCSCO107. IT WILL CALC  *        
T22788*                       USING THAT MONTH'S RATE.                 *        
T22796*  10/12/00    RAH      MAKE EPP CALCULATIONS USE CURRENT DAYS   *        
T22796*                       RATE AND FACTORS FOR ALL 12 MONTHS.  ALSO*        
T22796*                       MAKE BILL CALC USE THE CORRECT SUMMER OR *        
T22796*                       WINTER VERSION OF THE RATE.              *        
T23332*  02/01/01    RAH      MAKE EPP CALCULATIONS USE FUTURE DDDC    *        
T23332*                       FACTORS.  ADD SCEG/SEB LOGIC.            *        
T23513*  02/07/01    AS       CHANGES MADE TO DISTINGUISH DATABASES SEB*        
T23513*                       AND NON SEB TO INCORPORATE PSNC IN NON   *        
T23513*                       SEB                                      *        
C23415**  03/14/01 VIJAY    CHANGES FOR PSNC TAXES(MCR - 010).       **         
      **                                                             **         
C23501**  04/06/01 VIJAY    MULTI COMPANY CHANGES FOR DELINQUENCY    **         
      **                    VALUES.                                  **         
VVKS  **  08/15/01  VIJAY 'WS-TAX-TABLE-ENTRIES-MAX' INCREASED FROM             
      **                  1000 TO 3000 .                                        
VVKS  **  08/20/01 VIJAY      WS-HOLD-BC-DATA LENGTH CHANGED FROM               
      **                      7420 TO 9220 DUE TO ADDITION OF WNA               
      **                      FIELDS IN PRICE BLOCK.                            
T24928**  09/04/01 VIJAY    FIX EXCISE TAX CALCULATION.                         
C25786**  01/04/02 LAT      COMPANY NO USED TO FETCH DELINQ VALUE IS **         
C25786**                    TAKEN FROM ACCOUNT TABLE.                **         
C25327**  05/03/02 LEF      DISPLAY GAS USAGE IN THERMS              **         
T28228**  02/21/03 COVANSYS CORRECT GAS USAGE CALCULATION TO PREVENT **         
T28228**                    OVERSTATEMENT OF THERMS.                 **         
T27705**  08/05/03 COVANSYS DISPLAY THE CORRECT SUBDIVISION LIGHTING **         
T27705**                    CHARGES ON C/R FUTURE BILL.              **         
T29768**  09/02/04 VIJAY    CANCEL/REBILL NONE CALCS SHOULD NOT BE   **         
T29768**                    USED IN EPP CALCULATION.                 **         
      **                                                             **         
31178 **  09/21/04 RDF      UPDATE BA-INDX FROM 100 TO 200           **         
T32676**  10/06/05 GANESH   CODE CHANGED TO PASS ORIGINAL REVENUE    **         
T32676**                    MONTH TO SCSCA107 FOR EPP ANNIVERSARY    **         
REARCH**  08/09/05 CVNS     RPC TO COBOL CONVERSION                  **         
REARCH**           CHENNAI                                           **         
C32891**  05/22/06 RH15956  INCREASE WS-HOLD-BA-DATA TO 11800        **         
C33924**  09/12/06 RH15956  ADD WS-BC-BILL-ADJUSTMNT TO CB107 CALL   **         
      **                                                             **         
PERTUN*-- 10/19/06 SK88120  CHANGES FOR PERFORMANCE TUNINING.        --         
PERTUN*--                A  CHANGED TAX-DATA CURSOR.                 --         
PERTUN*--                B  CHANGED PROCESS TO GET PRVT LIGHT AMT    --         
P34990*--  11/06/2006    WR19680     ADDED CHANGE TO GET THE LATEST  --         
P34990*--                            FIXED FACTOR.                   --         
T35231*--  01/08/2006    WR19680     ADDED CHANGE TO GET THE LATEST  --         
T35231*--                            FOR EVERY ACCOUNT.  COMPARE TO  --         
T35231*--                            REVENUE MONTH, IF GREATER THAN  --         
T35231*--                            REVENUE MONTH, PASS FACTOR DATE --         
T35231*--                            TO BILL CALC AS REVENUE MONTH   --         
T35040*--  01/12/2007    JS83520     INCLUDE PVTLT IN EPP ESTIMATE   --         
T35040*--                            ONLY WHEN IT IS ACTIVE          --         
C34569*--  08/06/2007   SK42147     MAKE CHANGES TO CALL NEW VERSION            
C34569*--                            MCSCB107 BECAUSE OF THE SEB RATE           
C34569*--                            RE-ENGINEERING PROJECT.                    
C00173*--                                                                       
C00173*--   12/01/2008   WR19680     MADE CHANGE TO FIX PROBLEM WITH            
C00173*--                            BILL CALC ADDING EXIT FEE EVERY            
C00173*--                            MONTH WHEN RECALCULATING A                 
C00173*--                            CUSTOMERS BBP AMOUNT WHEN THEY             
C00173*--                            BREAK THEIR RATE CONTRACT.                 
T40764*--   03/05/2009   VV94890     INCREASED WS-TAX-TABLE-ENTRIES-MAX         
      *--                            AND WS-TAX-RATE-ENTRY ENTRIES              
      *--                            FROM 3000 TO 4000.                         
I00177*--                                                                       
I00177*--   01/21/2009   ROD         ADD CODE-MTR-READ-FREQ TO PASSED           
I00177*--                            DATA. USED TO IDENTIFY CALENDAR            
I00177*--                            MONTH BILLED ACCOUNTS.                     
P00120*--   09/16/2009   SS97726     INCREASE BA HOLD AREA.                     
P00165*--   09/23/2009   SS97726     INCREASE BA HOLD AREA.                     
P00211*--   10/23/2009   RC41079     ADDED CODE TO CALL MCSCB063 TO GET         
P00211*--                            PENDING PRICE. IF PENDING PRICE >0         
P00211*--                            LOAD INTO FIX FACTOR IN PARA 2150-.        
P00211*--                            ADDED DURATION_REMAIN_NO > 0 TO            
P00211*--                            WHERE CLAUSE IN PARA 7940-. ALSO           
P00211*--                            ADDED CODE TO GET OPTION CODE.             
A01848*--   11/05/2009   SS97726     FIX PANEL153 ERROR.             --         
P00251*--   04/12/2010   SS97726     CHANGES FOR NET METERING PROJECT--         
P00257*--   04/23/2010   RH15956     REVENUE REPORTING CHANGES.      --         
A02036*--   07/30/2010   DB41297     PERFORMANCE IMPROVEMENTS.       --         
ACT111*--   10/13/2010   WR19680     FIXED ISSUED WITH SHARED LIGHTING          
ACT111*--                            NEEDS TO BE TREATED AS UNMETERED           
ACT111*--                            APPLICATION A02036                         
ACT115*--   12/07/2010   WR19680     ADDED BG.REVENUE > 0 CHECK IN              
ACT115*--                            IN PARAGRAPH 6100 PER RICK BLACK           
ACT115*--                            APPLICATION A02036                         
P00264*--   01/28/2011   VP94820     ADDED NEW PARMS FOR BBP MAINTENANCE        
P00264*--                            THRU BPA'S                                 
ACT009*--   06/20/2011   GD97441     APPL3118-ACT9:IF CUSTOMER ALREADY *        
ACT009*--                            RENEWED, USE PENDING/FUTURE DATED *        
ACT009*--                            PRICE IF EXISTS(SEB).             *        
P00496*--   04/08/11     SS97726     INDUSTRIAL BILLING ENHANCEMENTS.  *        
VKSACT*     09/08/11  VIJAY   HISTORY ROWS CREATION FOR EVENT PROCESS.          
      *     P00496            THIS INCLUDES CURTAILMENT, MAINTENANCE            
      *                       AND STANDBY EVENTS.                               
A03959*     06/14/12     RH15956     INITIALIZE CNSMPTN-HOURLY BEFORE  *        
A03959*                              CALLING BILL CALC.                *        
P00694*     08/03/12     SV95326     TO GET BILLED AMOUNT FROM         *        
P00694*                              CSS_BILLING_DET FOR SCEG ONLY.    *        
A03967*     12/06/12     SV95326     DON'T WRITE IT IN RESULTSET IF A  *        
A03967*                  ACT140      PARTICULAR ROW IS HAVING ZERO     *        
A03967*                              VALUE FOR UNITS,DAYS AND CHARGE.  *        
A04527*     03/06/13     AS7C117     MOVE THE VALUE 'P' TO EPP-CATEGORY*        
A04527*                  ACT025      FOR PRIVATE LIGHTING.             *        
BBPFIX*     04/02/13     VIJAY       APPLY FIXED PRICE CUSTOMERS BUFFER         
BBPFIX*      P00694                  .                                          
A04462*     04/25/13     RH15956     EXCLUDE MV90 BACKUP METERS.       *        
A04527*     07/25/13     MR7E794     CLEAN THE SEB CODE.               *        
ACT212*--   06/20/14     VIJAY       IDENTIFY LIGHTING (E/G/U). WHEN   *        
ACT212*--   A04880                   LIGHTING IS REMOVED NOT DISPLAYING*        
ACT212*--                            PROPERLY IN BBP 'SHOW USAGE PANEL'*        
ACT241*  08/19/14 VIJAY    POPULATE BG.RT_PKG_OPT_SEQ_NO FROM          *        
ACT241*  A04880            UTIL_ENVRNMT WHEN IT IS 0 TO AVOID ABEND IN *        
ACT241*                    BILL CALC PROGRAM WHEN PROCESSING 'EXIT FEE'*        
ACT241*                    FACTOR.                                     *        
ACT178*  09/16/15 VIJAY    ADDED NECESSARY FIELDS FOR UNMETER ONLY     *        
ACT178*  A05136            ACCOUNT PROCESS WHICH IS CAUSING S0C7 ERROR.         
ACT302*  10/11/16 VIJAY    FIX TAX CALCULATION PROCESS SIMILAR TO BILL *        
ACT302*  A05460            CALC PROCESS.                               *        
      *****************************************************************         
      ** THIS IS A SHARED COMPONENT PLEASE CHECK THE SPREADSHEET     **         
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02322'.
MSQ017     COPY MFASQLM.
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBLLHDR                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBLLDET                                                  
           END-EXEC.                                                            
      *                                                                         
T20983     EXEC SQL                                                             
T20983        INCLUDE TBBLCLDT                                                  
T20983     END-EXEC.                                                            
      *                                                                         
T22788     EXEC SQL                                                             
T22788        INCLUDE TBDELQ                                                    
T22788     END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBCNSMP                                                   
           END-EXEC.                                                            
                                                                        
T11798     EXEC SQL                                                             
T11798        INCLUDE TBCSTPLN                                                  
T11798     END-EXEC.                                                            
                                                                        
T11128     EXEC SQL                                                             
T11128        INCLUDE TBUTLENV                                                  
T11128     END-EXEC.                                                            
                                                                        
T11888*---< CSS_RATE_CREATOR >                                                  
T11888     EXEC SQL                                                             
T11888        INCLUDE TBRTCRTR                                                  
T11888     END-EXEC.                                                            
T11888                                                                  
T11888*---< CSS_UNMTR_PLAN   >                                                  
T11888     EXEC SQL                                                             
T11888        INCLUDE TBUMPLAN                                                  
T11888     END-EXEC.                                                            
T11888                                                                  
T13225     EXEC SQL                                                             
              INCLUDE TBFTXXMP                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBREVCLS                                                  
           END-EXEC.                                                            
           EXEC SQL                                                             
              INCLUDE TBTXCNTL                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBTXRATE                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBTXUSE                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
C23415     EXEC SQL                                                     04130000
C23415         INCLUDE TBEXCISE                                         04140000
C23415     END-EXEC.                                                    04150000
                                                                        
C25786     EXEC SQL                                                     04130000
C25786         INCLUDE TBACCT                                           04140000
C25786     END-EXEC.                                                    04150000
C25786*                                                                 04150000
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CWSX0010                                                 
REARCH     END-EXEC.                                                            
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                          
           COPY CWS00303.                                                       
                                                                        
           EXEC SQL                                                             
                INCLUDE CWS00013                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
REARCH     05  PROGRAM-NAME            PIC X(08) VALUE 'CSR02322'.      
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
REARCH     05  PARM-PREMISE-NO-TEMP    PIC X(10).                       
REARCH     05  PARM-PREMISE-NO-NUM     REDEFINES PARM-PREMISE-NO-TEMP   
                                       PIC 9(10).                       
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
REARCH     05  MCSCB107                PIC X(8) VALUE 'MCSCB107' .      
T23513     05  WS-DATABASE             PIC 9(1) VALUE ZERO.             
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-ACTIVE-CODE          PIC X(01) VALUE 'A'.             
           05  WS-CURRENT-BILL-NO      PIC S9(09) COMP VALUE ZEROES.    
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-REVENUE-MONTH        PIC X(10) VALUE SPACES.          
           05  RS-DAYS                 PIC S9(4) COMP VALUE 0.          
           05  RS-UNITS                PIC S9(9) COMP-3 VALUE 0.        
           05  RS-CODE-UTIL-TYPE       PIC X(1) VALUE SPACES.           
           05  RS-CUSTOMER-NO          PIC S9(10) COMP-3 VALUE 0.       
           05  RS-NEW-CHARGE           PIC S9(9)V9(2)                   
                                                  COMP-3 VALUE 0.       
           05  RS-RATE-PLAN-NO         PIC X(3) VALUE SPACES.           
           05  RS-CALC-ERROR           PIC X(08) VALUE SPACES.          
           05  RS-HTG-CLG-SW           PIC S9(03) COMP-3 VALUE ZEROES.  
           05  RS-EPP-CATEGORY         PIC X(1)  VALUE SPACES.          
P00694     05  RS-ELEC-BUFFER          PIC S9(4)V9(5)                   
P00694                                           COMP-3 VALUE 0.        
P00694     05  RS-GAS-BUFFER           PIC S9(4)V9(5)                   
P00694                                           COMP-3 VALUE 0.        
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
REARCH     05  S-REVENUE-MONTH         PIC X(10) VALUE SPACES.          
REARCH     05  S-DAYS                  PIC S9(4) COMP VALUE 0.          
REARCH     05  S-UNITS                 PIC S9(9) COMP-3 VALUE 0.        
REARCH     05  S-CODE-UTIL-TYPE        PIC X(1) VALUE SPACES.           
REARCH     05  S-CUSTOMER-NO           PIC S9(10) COMP-3 VALUE 0.       
REARCH     05  S-NEW-CHARGE            PIC S9(9)V9(2)                   
REARCH                                            COMP-3 VALUE 0.       
REARCH     05  S-RATE-PLAN-NO          PIC X(3) VALUE SPACES.           
REARCH     05  S-CALC-ERROR            PIC X(08) VALUE SPACES.          
REARCH     05  S-HTG-CLG-SW            PIC S9(03) COMP-3 VALUE ZEROES.  
REARCH     05  S-EPP-CATEGORY          PIC X(1)  VALUE SPACES.          
P00694     05  S-ELEC-BUFFER           PIC S9(4)V9(5)                   
P00694                                            COMP-3 VALUE 0.       
P00694     05  S-GAS-BUFFER            PIC S9(4)V9(5)                   
P00694                                           COMP-3 VALUE 0.        
                                                                        
P00211     05  WS-MSG-RT-110-105       PIC S9(5) COMP-3 VALUE 95155.    
P00211     05  WS-MSG-RT-105-110       PIC S9(5) COMP-3 VALUE 95157.    
                                                                        
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
REARCH     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
REARCH     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
REARCH     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
REARCH         49  S-HOST-VARIABLES-V    PIC X(255).                    
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
REARCH         49  S-SQL-STATEMENT-V     PIC X(255).                    
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
REARCH         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
REARCH     10  WS-ABEND-SQLERRMC.                                       
REARCH         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
REARCH         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
REARCH     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
REARCH                                                                  
       01  GENERAL-WORKING-STORAGE.                                     
COB305     05 WS-ACCOUNT-NO        PIC S9(13) COMP-3 VALUE 0.               
COB305     05 WS-CUSTOMER-NO        PIC S9(10) COMP-3 VALUE 0.               
COB305     05 WS-PREMISE-NO        PIC S9(10) COMP-3 VALUE 0.               
           05  WS-REVENUE-MONTH        PIC S9(6) COMP-3 VALUE 0.        
           05  WS-BILL-NO              PIC 9(9).                        
           05  WS-HOLD-BILL-DATE       PIC X(12) VALUE SPACES.          
           05  WS-DATE-BILLED          PIC X(12).                       
           05  WS-REVENUE-MONTH-CHAR   PIC X(10).                       
           05  WS-RCVPRM               PIC X(20).                       
           05  WS-CODE-UTIL-TYPE       PIC X(1).                        
           05  WS-BILL-EXISTS          PIC X(1)  VALUE SPACES.          
P00464     05  WS-BPAMAINT-EXISTS      PIC X(1)  VALUE SPACES.          
P34990     05  WS-FROM-DATE.                                            
P34990         10 WS-YEAR-F              PIC X(04) VALUE SPACES.        
P34990         10 FILLER                 PIC X(01) VALUE '-'.           
P34990         10 WS-MONTH-F             PIC X(02) VALUE SPACES.        
P34990         10 FILLER                 PIC X(01) VALUE '-'.           
P34990         10 WS-DAY-F               PIC X(02) VALUE SPACES.        
P34990     05  WS-HOLD-FROM-DATE.                                       
P34990         10  WS-HOLD-FROM-YYYY     PIC X(04) VALUE SPACES.        
P34990         10  WS-HOLD-FROM-MM       PIC X(02) VALUE SPACES.        
P34990     05  WS-HOLD-FROM-DATE-R       PIC 9(06) VALUE ZEROS.         
           05  WS-GAS-RATE             PIC X(03) VALUE SPACES.          
           05  WS-ELEC-RATE            PIC X(03) VALUE SPACES.          
           05  WS-UNMET-RATE           PIC X(03) VALUE SPACES.          
           05  WS-IC-NO                PIC S9(4) USAGE COMP.            
COB305     05 WS-PRIV-SUM-AMT        PIC S999999999V99 USAGE COMP-3 
COB305       VALUE 0.  
COB305     05 WS-SUBDIV-SUM-AMT        PIC S999999999V99 USAGE COMP-3 
COB305       VALUE 0.  
ACT111     05  WS-SHARED-LIGHTING-FL   PIC X(01) VALUE SPACES.          
           05  WS-REVENUE-DATE.                                         
               10 WS-YEAR              PIC X(04) VALUE SPACES.          
               10 FILLER               PIC X(01) VALUE '-'.             
               10 WS-MONTH             PIC X(02) VALUE SPACES.          
               10 FILLER               PIC X(01) VALUE '-'.             
               10 WS-DAY               PIC X(02) VALUE '01'.            
TP8213     05  WS-TO-DATE              PIC X(10) VALUE SPACES.          
TP8213     05  WS-NUM-OF-BILLS         PIC S9(4) COMP.                  
TP9961     05  WS-NULL-IND             PIC S9(4) COMP.                  
P00694     05  WS-NULL-IND1            PIC S9(4) COMP.                  
P00694     05  WS-NULL-IND2            PIC S9(4) COMP.                  
T20983     05  WS-NULL-IND-HONK        PIC S9(4) COMP.                  
T16108     05  WS-CUST-PLAN-EXISTS     PIC X(01) VALUE SPACES.          
      *                                                                         
T22202     05  WS-CURR-REVENUE-MONTH   PIC S9(6) COMP-3 VALUE ZEROS.    
T22202     05  WS-REVENUE-MONTH-NULL   PIC S9(4) COMP   VALUE ZEROS.    
T27705     05  WS-811                  PIC S9(9) COMP   VALUE -811.     
T34569     05  WS-AGL-METER-CHARGE     PIC S9(4)V9(5) USAGE COMP-3      
T34569                                                VALUE 0.          
P00694     05  WS-PREV-ACCOUNT-NO        PIC S9(13) COMP-3 VALUE 0.     
P00694     05  WS-PCT-RESRATEINCR-ELEC   PIC S9(4)V9(5) COMP-3          
P00694                                                 VALUE 0.         
P00694     05  WS-PCT-RESRATEINCR-GAS    PIC S9(4)V9(5) COMP-3          
P00694                                                 VALUE 0.         
P00694     05  WS-PCT-COMRATEINCR-ELEC   PIC S9(4)V9(5) COMP-3          
P00694                                                 VALUE 0.         
P00694     05  WS-PCT-COMRATEINCR-GAS    PIC S9(4)V9(5) COMP-3          
P00694                                                 VALUE 0.         
P00694     05  WS-ESTRATE-INCR-GAS       PIC S9(4)V9(5) COMP-3          
P00694                                                 VALUE 0.         
P00694     05  WS-ESTRATE-GAS            PIC S9(4)V9(5) COMP-3          
P00694                                                 VALUE 0.         
P00694     05  WS-ESTRATE-INCR-ELEC      PIC S9(4)V9(5) COMP-3          
P00694                                                 VALUE 0.         
ACT302     05  WS-TAX-CNTRL-NO          PIC S9(4) COMP.                 
ACT302     05  WS-HLD-STATE-TAX-RATE    PIC S9V9(4) COMP-3 VALUE 0.     
ACT302     05  WS-TEMP-WORK-DATE        PIC X(10) VALUE SPACES.         
ACT302     05  WS-DATE-BILLED-TEST      PIC X(10) VALUE SPACES.         
ACT302     05  WS-EXCISE-TAX-CALC       PIC X(01) VALUE SPACES.         
COB305     05 WS-TAX-RATE-CALC        PIC S9V9(4) COMP-3 VALUE 0.             
ACT302     05  WS-VERSION-FOUND         PIC X(01) VALUE 'N'.            
ACT302        88  VERSION-FOUND                   VALUE 'Y'.            
ACT302     05  WS-EXEMPT-RATE-FLAG      PIC X(01) VALUE 'N'.            
ACT302        88  EXEMPT-RATE-FOUND               VALUE 'Y'.            
ACT302     05  WS-OLD-STATE-TAX-PCT     PIC S9V9(4) COMP-3 VALUE 0.     
ACT302     05  WS-STATE-TAX-RATE        PIC S9V9(4) COMP-3 VALUE 0.     
ACT302     05  WS-GA-MFG-SALES-TAX-XMT  PIC X(01) VALUE 'X'.            
ACT302     05  WS-OLD-LOCAL-TAX-TOT     PIC S9V9(4) COMP-3 VALUE 0.     
ACT302     05  WS-NEW-LOCAL-TAX-TOT     PIC S9V9(4) COMP-3 VALUE 0.     
ACT302     05  WS-OLD-LOCAL-TAX-PCT     PIC S9V9(4) COMP-3 VALUE 0.     
ACT302     05  WS-NEW-LOCAL-TAX-PCT     PIC S9V9(4) COMP-3 VALUE 0.     
ACT302     05  WS-NEW-STATE-TAX-PCT     PIC S9V9(4) COMP-3 VALUE 0.     
ACT302     05  WS-STATE-XMT-PCT         PIC S9(5)V9(6) COMP-3           
ACT302                                                     VALUE 0.     
ACT302     05  WS-COUNTY-XMT-PCT        PIC S9(5)V9(6) COMP-3           
ACT302                                                     VALUE 0.     
ACT302     05  WS-TEMP-V1-END-REV-MTH   PIC 9(6)           VALUE 0.     
ACT302     05  WS-TEMP-V2-END-REV-MTH   PIC 9(6)           VALUE 0.     
ACT302     05  WS-TEMP-V1-REV-MTH       PIC 9(6)           VALUE 0.     
ACT302     05  WS-TEMP-V2-REV-MTH       PIC 9(6)           VALUE 0.     
COB305     05 WS-TEMP-INDX        PIC S9(4) COMP-3 VALUE 0.             
ACT302 01  WS-TAX-XMT-FOUND             PIC X(01).                      
ACT302     88 TAX-XMT-FOUND                      VALUE 'Y'.             
                                                                        
T13225* WORKING STORAGE FOR TAX COMPUTATION                                     
       01  WORK-VARIABLES-TAX.                                          
COB305     05 WS-BILL-AMT-PLUS-TAXES        PIC S9(09)V99 COMP-3 
COB305       VALUE 0.   
COB305     05 WS-STATE-TAXABLE-AMT        PIC S9(7)V99 COMP-3 VALUE 0.    
COB305     05 WS-CITY-TAXABLE-AMT        PIC S9(7)V99 COMP-3 VALUE 0.    
COB305     05 WS-OTHER-TAXABLE-AMT        PIC S9(7)V99 COMP-3 VALUE 0.    
COB305     05 WS-CITY-TAX-RATE-CALC        PIC S99V9(3) COMP-3 VALUE 0.   
COB305     05 WS-STATE-TAX-RATE-CALC        PIC S99V9(3) COMP-3 VALUE 0.   
           05  WS-DAYS-AT-CURRENT               PIC S9(9) COMP.         
           05  WS-DATE-1                        PIC X(10).              
           05  WS-DATE-2                        PIC X(10).              
A02036     05  WS-DATE-3                        PIC X(10).              
           05  WS-TAX-COMPARE-KEY.                                      
               10  WS-TAX-COMPARE-TYPE          PIC X(1).               
               10  WS-TAX-JURISDICTION-CD       PIC X(3).               
           05  WS-FT-XMPT                       PIC X(1).               
           05  WS-ST-XMPT                       PIC X(1).               
           05  WS-UM-SERVICE-TYPE               PIC X(1).               
T20141     05  WS-TAX-FACTOR-ID                 PIC X(9) VALUE SPACES.  
COB305     05 WS-AMT-OTHER-TAX        PIC S9(7)V9(2) COMP-3 VALUE 0.  
T20141     05  WS-START-DATE                    PIC X(10) VALUE SPACES. 
T20141     05  WS-V1-REV-MTH                    PIC 9(6) VALUE ZERO.    
T20141     05  WS-V2-REV-MTH                    PIC 9(6) VALUE ZERO.    
T20141     05  WS-REV-MONTH-TEST                PIC 9(6) VALUE ZERO.    
COB305     05 WS-BILL-MESSAGE        PIC S9(5) COMP-3 VALUE 0.       
COB305     05 WS-MSG-INDX        PIC S9(5) COMP-3 VALUE 0.       
C23415     05  WS-WORK-DATE                     PIC X(10) VALUE SPACES. 
C23415     05  WS-WORK-FROM-DATE                PIC 9(6) VALUE ZERO.    
C23415     05  WS-REV-MONTH-FLAG                PIC X(1) VALUE SPACES.  
C23415         88 WS-REV-MONTH-FOUND                     VALUE 'Y'.     
C23415     05  WS-ENTRIES-FLAG                  PIC X(1) VALUE SPACES.  
C23415         88 WS-ENTRIES-NOT-FOUND                   VALUE 'Y' .    
COB305     05 WS-TOT-EXCISE-TAX-AMT        PIC S9(9)V99 COMP-3 VALUE 0.    
COB305     05 WS-EXCISE-TAX-AMT        PIC S9(9)V99 COMP-3 VALUE 0.    
COB305     05 WS-WORK-UNITS        PIC S9(9) COMP-3 VALUE 0.       
                                                                        
C23415 01  WS-COMPANY-TYPE.                                             
C23415     05  WS-SCEG                          PIC XX VALUE '01' .     
C23415     05  WS-PSNC                          PIC XX VALUE '26' .     
                                                                        
C23415 01  WS-TAX-EX-ENTRIES-MAX              PIC S9(5) COMP VALUE 100. 
C23415                                                                  
C23415 01  WS-TAX-EXCISE-TABLE.                                         
C23415     05  WS-TAX-EX-ENTRIES PIC S9(5) COMP VALUE ZERO.             
C23415     05  WS-TAX-EX-ENTRY                                          
C23415            OCCURS 100 TIMES                                      
C23415            DESCENDING KEY WS-X6-TAX-KEY                          
C23415            INDEXED BY X6-INDX.                                   
C23415            07 WS-X6-TAX-KEY.                                     
C23415               08 WS-X6-TAX-CNTRL-NO   PIC S9(4) COMP.            
C23415               08 WS-X6-TAX-DATE-FROM   PIC X(10) .               
C23415               08 WS-X6-BLOCK-NO        PIC 9(01) .               
C23415            07 WS-X6-BLOCK-UNITS        PIC S9(9) COMP.           
COB305            07 WS-X6-EXCISE-TAX-UNIT-AM        PIC S9(5)V9(6) 
COB305           COMP-3 VALUE 0.    
C23415     05  WS-TAX-EX-ENTRY-CORRECT                                  
C23415            OCCURS 9 TIMES                                        
C23415            INDEXED BY X6-INDX-CORRECT.                           
C23415            07 WS-X6-BLOCK-NO-C           PIC 9(01) .             
C23415            07 WS-X6-BLOCK-UNITS-C        PIC S9(9) COMP.         
COB305            07 WS-X6-EXCISE-TAX-UNIT-AM-C        PIC S9(5)V9(6) 
COB305           COMP-3 VALUE 0.  
                                                                        
ACT302 01  WS-TAX-TABLE-ENTRIES-MAX           PIC S9(5) COMP VALUE 9999.
                                                                        
       01  WS-TAX-RATE-TABLE.                                           
T20141     05  WS-TAX-TABLE-ENTRIES           PIC S9(5) COMP VALUE ZERO.
           05  WS-TAX-RATE-ENTRY                                        
ACT302            OCCURS 9999 TIMES                                     
T20141            ASCENDING KEY WS-TC-TAX-KEY                           
                  INDEXED BY TC-INDX.                                   
T20141         10  WS-TC-TAX-KEY.                                       
T20141             15  WS-TC-TAX-ID.                                    
T20141                 20  WS-TC-TAX-TYPE          PIC X(1).            
T20141                 20  WS-TR-TAX-JURISDICTION  PIC 9(3).            
T20141             15  WS-TC-TAX-CNTRL-NO          PIC 9(4).            
               10  WS-TAX-USE-DATA.                                     
                   15  WS-TU-ELECT            PIC X(1).                 
                   15  WS-TU-GAS              PIC X(1).                 
                   15  WS-TU-MDSE             PIC X(1).                 
                   15  WS-TU-WATER            PIC X(1).                 
                   15  WS-TU-SEWER            PIC X(1).                 
                   15  WS-TU-TRASH            PIC X(1).                 
T20141             15  WS-TU-FACTOR-ID        PIC X(9).                 
ACT302             15  WS-TU-CODE-APPL-COND   PIC X(1).                 
               10  WS-TU-CALC-INST            PIC X(1).                 
ACT302         10  WS-TAX-RATE-VERSION                                  
                      OCCURS 10 TIMES                                   
                      INDEXED BY TR-INDX.                               
                   15  WS-TR-DATE-FROM        PIC X(10).                
                   15  WS-TR-DATE-TO          PIC X(10).                
COB305             15 WS-TAX-RATE        PIC S9V9(4) COMP-3 VALUE 0.       
      *                                                                 06700000
      /****************************************************************         
                                                                        
           COPY CWS0022B.                                                       
                                                                        
           COPY CWS0024B.                                                       
                                                                        
T9127      COPY CWS1001A.                                                       
      *                                                                         
           EXEC SQL                                                             
T9127          INCLUDE CWS1000A                                                 
           END-EXEC.                                                            
C23415     EXEC SQL                                                             
C23415         INCLUDE CWS1000B                                                 
C23415     END-EXEC.                                                            
P00496     COPY CWS1001B.                                                       
                                                                        
       01  WORK-VARIABLES.                                              
           03  WS-DATE-ORIG-BILL-NULL   PIC S9(4) COMP.                 
           03  WS-DATE-LFTM-HI-DMD-NULL PIC S9(4) COMP.                 
           03  WS-DATE-BILLED-NULL      PIC S9(4) COMP.                 
           03  WS-DATE-READ-NULL        PIC S9(4) COMP.                 
           03  WS-DATE-USAGE-ENDS-NULL  PIC S9(4) COMP.                 
           03  WS-EFF-DATE-FROM-NULL    PIC S9(4) COMP.                 
           03  WS-EFF-DATE-TO-NULL      PIC S9(4) COMP.                 
           03  WS-CURRENT-DATE          PIC X(10).                      
COB305     03 WS-MAX-REV-MONTH        PIC S9(6)V USAGE COMP-3 VALUE 0.        
COB305     03 WS-TO-REV-MONTH        PIC S9(6)V USAGE COMP-3 VALUE 0.        
           03  WS-TO-REV-MONTH-NI       PIC S9(04) COMP  VALUE +0.      
           03  WS-TO-REV-MONTH-C        PIC 9(06).                      
           03  WS-MAX-REV-DATE          PIC X(10).                      
COB305     03 WS-FROM-REV-MONTH        PIC S9(6)V USAGE COMP-3 VALUE 0.        
           03  WS-FROM-REV-MONTH-C      PIC 9(06).                      
T9127      03  WS-REV-DISTRICT-CD       PIC X(3).                       
T35040     03  WS-PVTLT-ACTIVE          PIC X(01).                      
I00177 01  WS-HOLD-CX-DATA              PIC X(31000).                   
I00177 01  WS-HOLD-BC-DATA              PIC X(100000).                  
P00496 01  WS-HOLD-BA-DATA              PIC X(20400).                   
                                                                        
T28228 01  WS-PSNC-CALC-SW             PIC X(01) VALUE 'N'.             
T28228     88  WS-NOT-PSNC-CALC                  VALUE 'N'.             
T28228     88  WS-PSNC-CALC                      VALUE 'Y'.             
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
T20141 01  WS-CONSTANTS.                                                
T20141     05  WS-OTHER-TAX            PIC X(01) VALUE 'C'.             
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
                                                                        
           EXEC SQL DECLARE BI-CURSOR CURSOR FOR                        
               SELECT BG.REVENUE_MONTH     ,                            
                      BI.DATE_BILLED       ,                            
                      BI.CUSTOMER_NO       ,                            
                      BG.ACCOUNT_NO        ,                            
                      BG.CODE_UTIL_TYPE    ,                            
                      BG.AMT_BILL_ITEM     ,                            
                      BG.BILL_NO           ,                            
                      BG.IC_NO             ,                            
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           BG.BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP,                            
                      BG.PREMISE_NO        ,                            
                      BG.DATE_ORIG_BILL    ,                            
                      BG.CODE_BILL_CALC    ,                            
                      BG.CODE_BILL_ITM_TYPE,                            
                      BG.CODE_BILL_ITM_IND ,                            
                      BG.CODE_DR_CR_CNSMPTN,                            
                      BG.AMT_STATE_TAX     ,                            
                      BG.AMT_CITY_TAX      ,                            
                      BG.AMT_OTHER_TAX     ,                            
                      BG.CODE_REVENUE_CLASS,                            
                      BG.CODE_SIC_NO       ,                            
                      BG.RATE_PLAN_NO      ,                            
                      BG.CODE_CURTAIL_PRTY ,                            
                      BG.CODE_STAT_TAX_XMT ,                            
                      BG.CODE_CITY_TAX_XMT ,                            
                      BG.CODE_OTHR_TAX_XMT ,                            
                      BG.REV_RPT_CD        ,                            
                      BG.STANDBY_COMPLIED  ,                            
                      BG.PRORATE_CD        ,                            
                      BG.NEW_RATE_PCT      ,                            
                      BG.CODE_SUB_TOTAL    ,                            
                      BG.TAX_REFUND_CD     ,                            
                      BG.COMPANY_NO        ,                            
                      BG.DATE_LFTM_HI_DMD  ,                            
                      BG.LFTM_HI_PEAK_DMD  ,                            
                      BG.REBILL_IND        ,                            
                      BG.REV_MTH_ORIG_BILL ,                            
                      BG.GAS_BASE_USE      ,                            
                      BG.ADJ_REASON_CD     ,                            
                      BG.WNA_FACTOR        ,                            
                      BG.BTU_FACTOR        ,                            
T13225                BG.REV_DISTRICT_CD   ,                            
A01848                BG.RT_PKG_OPT_SEQ_NO                              
                 FROM CSS_BILLING_HDR   BI WITH(READUNCOMMITTED),               
                      CSS_BILLING_DET   BG WITH(READUNCOMMITTED)                
                WHERE BI.PREMISE_NO         = :BI-PREMISE-NO            
                  AND BI.ACCOUNT_NO         = BG.ACCOUNT_NO             
                  AND BG.CODE_BILL_ITM_TYPE = 'C'                       
                  AND BG.CODE_BILL_ITM_IND  = 'A'                       
T29768            AND BG.CODE_BILL_CALC     = 'A'                       
                  AND BI.BILL_NO            = BG.BILL_NO                
               AND ((BG.REV_MTH_ORIG_BILL = 0                           
                  AND BG.REVENUE_MONTH BETWEEN :WS-FROM-REV-MONTH       
                  AND :WS-TO-REV-MONTH)                                 
                  OR (BG.REV_MTH_ORIG_BILL BETWEEN :WS-FROM-REV-MONTH   
                  AND :WS-TO-REV-MONTH))                                
             ORDER BY BG.IC_NO,                                         
                      BI.DATE_BILLED DESC                               
A04527       FOR READ ONLY                                      
A02036                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE BI-CURSOR CURSOR FOR                                
MFA-TR*        SELECT BG.REVENUE_MONTH     ,                                    
MFA-TR*               BI.DATE_BILLED       ,                                    
MFA-TR*               BI.CUSTOMER_NO       ,                                    
MFA-TR*               BG.ACCOUNT_NO        ,                                    
MFA-TR*               BG.CODE_UTIL_TYPE    ,                                    
MFA-TR*               BG.AMT_BILL_ITEM     ,                                    
MFA-TR*               BG.BILL_NO           ,                                    
MFA-TR*               BG.IC_NO             ,                                    
MFA-TR*               BG.BILL_ITEM_TIMESTMP,                                    
MFA-TR*               BG.PREMISE_NO        ,                                    
MFA-TR*               BG.DATE_ORIG_BILL    ,                                    
MFA-TR*               BG.CODE_BILL_CALC    ,                                    
MFA-TR*               BG.CODE_BILL_ITM_TYPE,                                    
MFA-TR*               BG.CODE_BILL_ITM_IND ,                                    
MFA-TR*               BG.CODE_DR_CR_CNSMPTN,                                    
MFA-TR*               BG.AMT_STATE_TAX     ,                                    
MFA-TR*               BG.AMT_CITY_TAX      ,                                    
MFA-TR*               BG.AMT_OTHER_TAX     ,                                    
MFA-TR*               BG.CODE_REVENUE_CLASS,                                    
MFA-TR*               BG.CODE_SIC_NO       ,                                    
MFA-TR*               BG.RATE_PLAN_NO      ,                                    
MFA-TR*               BG.CODE_CURTAIL_PRTY ,                                    
MFA-TR*               BG.CODE_STAT_TAX_XMT ,                                    
MFA-TR*               BG.CODE_CITY_TAX_XMT ,                                    
MFA-TR*               BG.CODE_OTHR_TAX_XMT ,                                    
MFA-TR*               BG.REV_RPT_CD        ,                                    
MFA-TR*               BG.STANDBY_COMPLIED  ,                                    
MFA-TR*               BG.PRORATE_CD        ,                                    
MFA-TR*               BG.NEW_RATE_PCT      ,                                    
MFA-TR*               BG.CODE_SUB_TOTAL    ,                                    
MFA-TR*               BG.TAX_REFUND_CD     ,                                    
MFA-TR*               BG.COMPANY_NO        ,                                    
MFA-TR*               BG.DATE_LFTM_HI_DMD  ,                                    
MFA-TR*               BG.LFTM_HI_PEAK_DMD  ,                                    
MFA-TR*               BG.REBILL_IND        ,                                    
MFA-TR*               BG.REV_MTH_ORIG_BILL ,                                    
MFA-TR*               BG.GAS_BASE_USE      ,                                    
MFA-TR*               BG.ADJ_REASON_CD     ,                                    
MFA-TR*               BG.WNA_FACTOR        ,                                    
MFA-TR*               BG.BTU_FACTOR        ,                                    
MFA-TR*               BG.REV_DISTRICT_CD   ,                                    
MFA-TR*               BG.RT_PKG_OPT_SEQ_NO                                      
MFA-TR*          FROM CSS_BILLING_HDR   BI,                                     
MFA-TR*               CSS_BILLING_DET   BG                                      
MFA-TR*         WHERE BI.PREMISE_NO         = :BI-PREMISE-NO                    
MFA-TR*           AND BI.ACCOUNT_NO         = BG.ACCOUNT_NO                     
MFA-TR*           AND BG.CODE_BILL_ITM_TYPE = 'C'                               
MFA-TR*           AND BG.CODE_BILL_ITM_IND  = 'A'                               
MFA-TR*           AND BG.CODE_BILL_CALC     = 'A'                               
MFA-TR*           AND BI.BILL_NO            = BG.BILL_NO                        
MFA-TR*        AND ((BG.REV_MTH_ORIG_BILL = 0                                   
MFA-TR*           AND BG.REVENUE_MONTH BETWEEN :WS-FROM-REV-MONTH               
MFA-TR*           AND :WS-TO-REV-MONTH)                                         
MFA-TR*           OR (BG.REV_MTH_ORIG_BILL BETWEEN :WS-FROM-REV-MONTH           
MFA-TR*           AND :WS-TO-REV-MONTH))                                        
MFA-TR*      ORDER BY BG.IC_NO,                                                 
MFA-TR*               BI.DATE_BILLED DESC                                       
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*      QUERYNO 7110                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL DECLARE CX-CURSOR CURSOR FOR                        
               SELECT CX.NO_UNITS          ,                            
                      CX.NO_DAYS           ,                            
                      CX.MTR_REF_NO        ,                            
                      CX.CODE_USAGE_TYPE   ,                            
                      CX.CODE_USAGE_ID     ,                            
                      CX.CODE_USAGE_SOURCE ,                            
                      CX.CODE_TIME_PERIOD  ,                            
                      CX.ITEM_SEQ_NO       ,                            
                      CX.METER_NO          ,                            
                      CX.REG_ID_NO         ,                            
                      CX.DATE_READ         ,                            
                      CX.CODE_METER_READ   ,                            
                      CX.CODE_METER_NO_READ,                            
                      CX.METER_READING     ,                            
                      CX.DEMAND_READING    ,                            
                      CX.EMPLOYEE_NO       ,                            
                      CX.NO_DEMAND_UNITS   ,                            
                      CX.CODE_SOURCE_ID    ,                            
                      CX.CODE_DEBIT_CREDIT ,                            
                      CX.CODE_ITEM_STATUS  ,                            
                      CX.CODE_DISCOUNT     ,                            
                      CX.CONSTANT          ,                            
                      CX.NO_DIALS          ,                            
                      CX.COMPANY_NO        ,                            
                      CX.EXCEPT_OVERRIDE_CD,                            
                      CX.REQUESTED_USAGE   ,                            
                      CX.DIGTL_INTRL_MTR_NO,                            
                      CX.DIGTL_MTR_TYPE    ,                            
                      CX.CODE_TOU_SEASN    ,                            
                      CX.EXCL_DMD_RCHT_IND                              
                 FROM CSS_CNSMPTN_HIST  CX WITH(READUNCOMMITTED)                
                WHERE CX.ACCOUNT_NO         = :CX-ACCOUNT-NO            
                  AND CX.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              )    
                  AND CX.BILL_NO            = :CX-BILL-NO               
                  AND CX.IC_NO              = :CX-IC-NO                 
T10202            AND CX.CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE        
A04462            AND CODE_USAGE_ID        <> 'X'                       
                FOR READ ONLY                                   
A02036                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL DECLARE CX-CURSOR CURSOR FOR                                
MFA-TR*        SELECT CX.NO_UNITS          ,                                    
MFA-TR*               CX.NO_DAYS           ,                                    
MFA-TR*               CX.MTR_REF_NO        ,                                    
MFA-TR*               CX.CODE_USAGE_TYPE   ,                                    
MFA-TR*               CX.CODE_USAGE_ID     ,                                    
MFA-TR*               CX.CODE_USAGE_SOURCE ,                                    
MFA-TR*               CX.CODE_TIME_PERIOD  ,                                    
MFA-TR*               CX.ITEM_SEQ_NO       ,                                    
MFA-TR*               CX.METER_NO          ,                                    
MFA-TR*               CX.REG_ID_NO         ,                                    
MFA-TR*               CX.DATE_READ         ,                                    
MFA-TR*               CX.CODE_METER_READ   ,                                    
MFA-TR*               CX.CODE_METER_NO_READ,                                    
MFA-TR*               CX.METER_READING     ,                                    
MFA-TR*               CX.DEMAND_READING    ,                                    
MFA-TR*               CX.EMPLOYEE_NO       ,                                    
MFA-TR*               CX.NO_DEMAND_UNITS   ,                                    
MFA-TR*               CX.CODE_SOURCE_ID    ,                                    
MFA-TR*               CX.CODE_DEBIT_CREDIT ,                                    
MFA-TR*               CX.CODE_ITEM_STATUS  ,                                    
MFA-TR*               CX.CODE_DISCOUNT     ,                                    
MFA-TR*               CX.CONSTANT          ,                                    
MFA-TR*               CX.NO_DIALS          ,                                    
MFA-TR*               CX.COMPANY_NO        ,                                    
MFA-TR*               CX.EXCEPT_OVERRIDE_CD,                                    
MFA-TR*               CX.REQUESTED_USAGE   ,                                    
MFA-TR*               CX.DIGTL_INTRL_MTR_NO,                                    
MFA-TR*               CX.DIGTL_MTR_TYPE    ,                                    
MFA-TR*               CX.CODE_TOU_SEASN    ,                                    
MFA-TR*               CX.EXCL_DMD_RCHT_IND                                      
MFA-TR*          FROM CSS_CNSMPTN_HIST  CX                                      
MFA-TR*         WHERE CX.ACCOUNT_NO         = :CX-ACCOUNT-NO                    
MFA-TR*           AND CX.BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP            
MFA-TR*           AND CX.BILL_NO            = :CX-BILL-NO                       
MFA-TR*           AND CX.IC_NO              = :CX-IC-NO                         
MFA-TR*           AND CX.CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE                
MFA-TR*           AND CODE_USAGE_ID        <> 'X'                               
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*       QUERYNO 7210                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
T20983     EXEC SQL DECLARE HONK-A-PRVLT-CSR CURSOR FOR                 
T20983         SELECT DISTINCT BZ.BILL_NO,                              
T20983                BZ.CODE_UTIL_TYPE,                                
T20983                C.RATE_PLAN_NO,                                   
T20983                BZ.IC_NO,                                         
T20983                BZ.BILLED_COMP_AM,                                
T20983                CP.CODE_SERVICE_TYPE                              
T20983           FROM CSS_BILL_CALC_DET BZ WITH(READUNCOMMITTED),               
T20983                CSS_CUST_PLAN CP WITH(READUNCOMMITTED),                   
T20983                (SELECT A.CODE_UTIL_TYPE,                         
T20983                        B.RATE_PLAN_NO,                           
T20983                        A.IC_NO,                                  
T20983                        MAX(A.BILL_NO) AS BILL_NO                 
T20983                   FROM CSS_BILL_CALC_DET A WITH(READUNCOMMITTED),        
T20983                        CSS_UTIL_ENVRNMT B WITH(READUNCOMMITTED)          
T20983                  WHERE A.ACCOUNT_NO      = :BZ-ACCOUNT-NO        
T20983                    AND A.IC_NO           = B.IC_NO               
T20983                    AND A.ACCOUNT_NO      = B.ACCOUNT_NO          
T20983                    AND A.CODE_UTIL_TYPE  = B.CODE_UTIL_TYPE      
T20983                    AND B.RATE_PLAN_NO    <> '064'                
T20983                    AND (A.CODE_UTIL_TYPE = 'U'                   
T20983                    OR  (A.CODE_UTIL_TYPE = 'E'                   
T20983                    AND CIS.SUBSTR3(B.RATE_PLAN_NO,1,2)                
T20983                            IN ('68','69')))                      
T20983                  GROUP BY A.CODE_UTIL_TYPE,                      
T20983                           B.RATE_PLAN_NO,                        
T20983                           A.IC_NO) C                             
T20983          WHERE BZ.ACCOUNT_NO       = :BZ-ACCOUNT-NO              
T20983            AND CP.ACCOUNT_NO       = :BZ-ACCOUNT-NO              
T20983            AND BZ.CODE_UTIL_TYPE   = C.CODE_UTIL_TYPE            
T20983            AND CP.CODE_UTIL_TYPE   = C.CODE_UTIL_TYPE            
T20983            AND BZ.BILL_NO          = C.BILL_NO                   
T20983            AND BZ.IC_NO            = C.IC_NO                     
T20983            AND CP.IC_NO            = C.IC_NO                     
T20983            AND CP.CODE_PLAN_STATUS = 'A'                         
T20983          ORDER BY BZ.BILL_NO                                     
A02036          FOR READ ONLY                                   
A02036                                                      
T11888     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL DECLARE HONK-A-PRVLT-CSR CURSOR FOR                         
MFA-TR*        SELECT DISTINCT BZ.BILL_NO,                                      
MFA-TR*               BZ.CODE_UTIL_TYPE,                                        
MFA-TR*               C.RATE_PLAN_NO,                                           
MFA-TR*               BZ.IC_NO,                                                 
MFA-TR*               BZ.BILLED_COMP_AM,                                        
MFA-TR*               CP.CODE_SERVICE_TYPE                                      
MFA-TR*          FROM CSS_BILL_CALC_DET BZ,                                     
MFA-TR*               CSS_CUST_PLAN CP,                                         
MFA-TR*               (SELECT A.CODE_UTIL_TYPE,                                 
MFA-TR*                       B.RATE_PLAN_NO,                                   
MFA-TR*                       A.IC_NO,                                          
MFA-TR*                       MAX(A.BILL_NO) AS BILL_NO                         
MFA-TR*                  FROM CSS_BILL_CALC_DET A,                              
MFA-TR*                       CSS_UTIL_ENVRNMT B                                
MFA-TR*                 WHERE A.ACCOUNT_NO      = :BZ-ACCOUNT-NO                
MFA-TR*                   AND A.IC_NO           = B.IC_NO                       
MFA-TR*                   AND A.ACCOUNT_NO      = B.ACCOUNT_NO                  
MFA-TR*                   AND A.CODE_UTIL_TYPE  = B.CODE_UTIL_TYPE              
MFA-TR*                   AND B.RATE_PLAN_NO    <> '064'                        
MFA-TR*                   AND (A.CODE_UTIL_TYPE = 'U'                           
MFA-TR*                   OR  (A.CODE_UTIL_TYPE = 'E'                           
MFA-TR*                   AND SUBSTR(B.RATE_PLAN_NO,1,2)                        
MFA-TR*                           IN ('68','69')))                              
MFA-TR*                 GROUP BY A.CODE_UTIL_TYPE,                              
MFA-TR*                          B.RATE_PLAN_NO,                                
MFA-TR*                          A.IC_NO) C                                     
MFA-TR*         WHERE BZ.ACCOUNT_NO       = :BZ-ACCOUNT-NO                      
MFA-TR*           AND CP.ACCOUNT_NO       = :BZ-ACCOUNT-NO                      
MFA-TR*           AND BZ.CODE_UTIL_TYPE   = C.CODE_UTIL_TYPE                    
MFA-TR*           AND CP.CODE_UTIL_TYPE   = C.CODE_UTIL_TYPE                    
MFA-TR*           AND BZ.BILL_NO          = C.BILL_NO                           
MFA-TR*           AND BZ.IC_NO            = C.IC_NO                             
MFA-TR*           AND CP.IC_NO            = C.IC_NO                             
MFA-TR*           AND CP.CODE_PLAN_STATUS = 'A'                                 
MFA-TR*         ORDER BY BZ.BILL_NO                                             
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*       QUERYNO 7410                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
T11888     EXEC SQL DECLARE CP-UT-SUBD-CSR CURSOR FOR                   
T11888      SELECT     CP.ACCOUNT_NO                                    
T11888               , CP.CODE_UTIL_TYPE                                
T11888               , CP.IC_NO                                         
T11888               , CP.RATE_ITEM_CODE                                
T11888               , CP.ITEM_SEQ_NO                                   
T11888               , CP.CODE_SERVICE_TYPE                             
T11888               , CP.USAGE_FIXED                                   
T11888               , CP.MTHLY_AMOUNT_FIXED                            
T11888               , CP.NO_UNITS                                      
T11888               , UT.RATE_PLAN_NO                                  
T11888               , UT.PRV_RATE_PLAN_NO                              
T11888      FROM     CSS_CUST_PLAN     CP WITH(READUNCOMMITTED)                 
T11888           ,   CSS_UTIL_ENVRNMT  UT WITH(READUNCOMMITTED)                 
T11888      WHERE CP.ACCOUNT_NO       =  :CP-ACCOUNT-NO                 
T11888        AND CP.CODE_UTIL_TYPE   =  :CP-CODE-UTIL-TYPE             
T11888        AND CP.CODE_PLAN_STATUS =  :CP-CODE-PLAN-STATUS           
T11888        AND UT.CODE_UTIL_TYPE   =  CP.CODE_UTIL_TYPE              
T11888        AND UT.IC_NO            =  CP.IC_NO                       
T11888        AND UT.ACCOUNT_NO       =  CP.ACCOUNT_NO                  
T11888        AND UT.RATE_PLAN_NO     =  '064'                          
A02036        FOR READ ONLY                                     
A02036                                                      
T11888     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE CP-UT-SUBD-CSR CURSOR FOR                           
MFA-TR*     SELECT     CP.ACCOUNT_NO                                            
MFA-TR*              , CP.CODE_UTIL_TYPE                                        
MFA-TR*              , CP.IC_NO                                                 
MFA-TR*              , CP.RATE_ITEM_CODE                                        
MFA-TR*              , CP.ITEM_SEQ_NO                                           
MFA-TR*              , CP.CODE_SERVICE_TYPE                                     
MFA-TR*              , CP.USAGE_FIXED                                           
MFA-TR*              , CP.MTHLY_AMOUNT_FIXED                                    
MFA-TR*              , CP.NO_UNITS                                              
MFA-TR*              , UT.RATE_PLAN_NO                                          
MFA-TR*              , UT.PRV_RATE_PLAN_NO                                      
MFA-TR*     FROM     CSS_CUST_PLAN     CP                                       
MFA-TR*          ,   CSS_UTIL_ENVRNMT  UT                                       
MFA-TR*     WHERE CP.ACCOUNT_NO       =  :CP-ACCOUNT-NO                         
MFA-TR*       AND CP.CODE_UTIL_TYPE   =  :CP-CODE-UTIL-TYPE                     
MFA-TR*       AND CP.CODE_PLAN_STATUS =  :CP-CODE-PLAN-STATUS                   
MFA-TR*       AND UT.CODE_UTIL_TYPE   =  CP.CODE_UTIL_TYPE                      
MFA-TR*       AND UT.IC_NO            =  CP.IC_NO                               
MFA-TR*       AND UT.ACCOUNT_NO       =  CP.ACCOUNT_NO                          
MFA-TR*       AND UT.RATE_PLAN_NO     =  '064'                                  
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7510                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
T13225     EXEC SQL                                                     
              DECLARE TAX-DATA CURSOR FOR                               
                 SELECT TC.TAX_TYPE,                                    
                        TR.DETAIL_ID,                                   
                        TR.DATE_FROM,                                   
                        TR.DATE_TO,                                     
                        TR.TAX_RATE,                                    
                        TU.CODE_TAX_CALC_INST,                          
                        TU.TAX_ELEC,                                    
                        TU.TAX_GAS,                                     
                        TU.TAX_MDSE,                                    
                        TU.TAX_WATER,                                   
                        TU.TAX_SEWER,                                   
                        TU.TAX_TRASH,                                   
T20141                  TC.TAX_CNTRL_NO,                                
T20141                  TC.FACTOR_ID                                    
ACT302                 ,TC.CODE_APPL_COND                               
                   FROM CSS_TAX_CNTL TC WITH(READUNCOMMITTED),                  
                        CSS_TAX_RATE TR WITH(READUNCOMMITTED),                  
                        CSS_TAX_USE_CNTL TU WITH(READUNCOMMITTED)               
A02036             WHERE TC.OPER_MODE IN ('A')                          
                     AND TR.OPER_MODE        = TC.OPER_MODE             
                     AND TR.TAX_CNTRL_NO     = TC.TAX_CNTRL_NO          
                     AND TR.DATE_FROM IS NOT NULL                       
                     AND TU.OPER_MODE        = TC.OPER_MODE             
                     AND TU.TAX_CNTRL_NO     = TC.TAX_CNTRL_NO          
                     AND TU.DETAIL_ID        = TR.DETAIL_ID             
PERTUN               AND TU.TAX_ENTRY_SEQ_NO = TR.TAX_ENTRY_SEQ_NO      
                   ORDER BY TC.TAX_TYPE,                                
                            TR.DETAIL_ID,                               
ACT302                      TC.TAX_CNTRL_NO,                            
                            TR.DATE_FROM DESC                           
A02036             FOR READ ONLY                                
A02036                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE TAX-DATA CURSOR FOR                                       
MFA-TR*          SELECT TC.TAX_TYPE,                                            
MFA-TR*                 TR.DETAIL_ID,                                           
MFA-TR*                 TR.DATE_FROM,                                           
MFA-TR*                 TR.DATE_TO,                                             
MFA-TR*                 TR.TAX_RATE,                                            
MFA-TR*                 TU.CODE_TAX_CALC_INST,                                  
MFA-TR*                 TU.TAX_ELEC,                                            
MFA-TR*                 TU.TAX_GAS,                                             
MFA-TR*                 TU.TAX_MDSE,                                            
MFA-TR*                 TU.TAX_WATER,                                           
MFA-TR*                 TU.TAX_SEWER,                                           
MFA-TR*                 TU.TAX_TRASH,                                           
MFA-TR*                 TC.TAX_CNTRL_NO,                                        
MFA-TR*                 TC.FACTOR_ID                                            
MFA-TR*                ,TC.CODE_APPL_COND                                       
MFA-TR*            FROM CSS_TAX_CNTL TC,                                        
MFA-TR*                 CSS_TAX_RATE TR,                                        
MFA-TR*                 CSS_TAX_USE_CNTL TU                                     
MFA-TR*            WHERE TC.OPER_MODE IN ('A')                                  
MFA-TR*              AND TR.OPER_MODE        = TC.OPER_MODE                     
MFA-TR*              AND TR.TAX_CNTRL_NO     = TC.TAX_CNTRL_NO                  
MFA-TR*              AND TR.DATE_FROM IS NOT NULL                               
MFA-TR*              AND TU.OPER_MODE        = TC.OPER_MODE                     
MFA-TR*              AND TU.TAX_CNTRL_NO     = TC.TAX_CNTRL_NO                  
MFA-TR*              AND TU.DETAIL_ID        = TR.DETAIL_ID                     
MFA-TR*              AND TU.TAX_ENTRY_SEQ_NO = TR.TAX_ENTRY_SEQ_NO              
MFA-TR*            ORDER BY TC.TAX_TYPE,                                        
MFA-TR*                     TR.DETAIL_ID,                                       
MFA-TR*                     TC.TAX_CNTRL_NO,                                    
MFA-TR*                     TR.DATE_FROM DESC                                   
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*       QUERYNO 7612                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           EXEC SQL DECLARE UNMTRD-TAX-CSR CURSOR FOR                   
               SELECT BG.CODE_REVENUE_CLASS ,                           
                      BG.CODE_STAT_TAX_XMT ,                            
                      BG.CODE_CITY_TAX_XMT ,                            
                      BG.CODE_OTHR_TAX_XMT ,                            
                      BG.CODE_UTIL_TYPE                                 
                 FROM CSS_BILLING_HDR   BI WITH(READUNCOMMITTED),               
                      CSS_BILLING_DET   BG WITH(READUNCOMMITTED)                
                WHERE BI.PREMISE_NO         = :BI-PREMISE-NO            
                  AND BI.ACCOUNT_NO         = BG.ACCOUNT_NO             
                  AND BG.CODE_BILL_ITM_TYPE = 'C'                       
                  AND BG.CODE_BILL_ITM_IND  = 'A'                       
T29768            AND BG.CODE_BILL_CALC     = 'A'                       
                  AND BI.BILL_NO            = BG.BILL_NO                
                  AND BG.CODE_UTIL_TYPE     IN ('E','G')                
                  AND BG.ACCOUNT_NO         = :BG-ACCOUNT-NO            
                  AND BG.REVENUE_MONTH      = :WS-MAX-REV-MONTH         
               ORDER BY BG.CODE_UTIL_TYPE                               
A04527       FOR READ ONLY                                      
A04527                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE UNMTRD-TAX-CSR CURSOR FOR                           
MFA-TR*        SELECT BG.CODE_REVENUE_CLASS ,                                   
MFA-TR*               BG.CODE_STAT_TAX_XMT ,                                    
MFA-TR*               BG.CODE_CITY_TAX_XMT ,                                    
MFA-TR*               BG.CODE_OTHR_TAX_XMT ,                                    
MFA-TR*               BG.CODE_UTIL_TYPE                                         
MFA-TR*          FROM CSS_BILLING_HDR   BI,                                     
MFA-TR*               CSS_BILLING_DET   BG                                      
MFA-TR*         WHERE BI.PREMISE_NO         = :BI-PREMISE-NO                    
MFA-TR*           AND BI.ACCOUNT_NO         = BG.ACCOUNT_NO                     
MFA-TR*           AND BG.CODE_BILL_ITM_TYPE = 'C'                               
MFA-TR*           AND BG.CODE_BILL_ITM_IND  = 'A'                               
MFA-TR*           AND BG.CODE_BILL_CALC     = 'A'                               
MFA-TR*           AND BI.BILL_NO            = BG.BILL_NO                        
MFA-TR*           AND BG.CODE_UTIL_TYPE     IN ('E','G')                        
MFA-TR*           AND BG.ACCOUNT_NO         = :BG-ACCOUNT-NO                    
MFA-TR*           AND BG.REVENUE_MONTH      = :WS-MAX-REV-MONTH                 
MFA-TR*        ORDER BY BG.CODE_UTIL_TYPE                                       
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*      QUERYNO 2820                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
C23415     EXEC SQL                                                     
C23415        DECLARE TAX-EXCISE-DATA CURSOR FOR                        
C23415           SELECT BLOCK_NO,                                       
C23415                  BLOCK_UNITS,                                    
C23415                  DATE_FROM,                                      
C23415                  TAX_CNTRL_NO,                                   
C23415                  EXCISE_TAX_UNIT_AM                              
C23415              FROM CSS_TAX_EXCISE_AMT WITH(READUNCOMMITTED)               
C23415                 ORDER BY TAX_CNTRL_NO ,                          
C23415                          DATE_FROM DESC,                         
C23415                          BLOCK_NO                                
A02036        FOR READ ONLY                                     
A02036                                                      
C23415     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE TAX-EXCISE-DATA CURSOR FOR                                
MFA-TR*          SELECT BLOCK_NO,                                               
MFA-TR*                 BLOCK_UNITS,                                            
MFA-TR*                 DATE_FROM,                                              
MFA-TR*                 TAX_CNTRL_NO,                                           
MFA-TR*                 EXCISE_TAX_UNIT_AM                                      
MFA-TR*             FROM CSS_TAX_EXCISE_AMT                                     
MFA-TR*                ORDER BY TAX_CNTRL_NO ,                                  
MFA-TR*                         DATE_FROM DESC,                                 
MFA-TR*                         BLOCK_NO                                        
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7116                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
HPCCDM*EJECT                                                                    
                                                                        
REARCH LINKAGE SECTION.                                                 
P00464 01  PARM-APPL-ID             PIC X(08).                          
REARCH 01  PARM-PREMISE-NO          PIC X(10).                          
REARCH 01  PARM-TO-DATE             PIC X(10).                          
P00464 01  PARM-FROM-REV-MTH        PIC X(06).                          
REARCH                                                                  
P00464 PROCEDURE DIVISION USING PARM-APPL-ID                            
P00464                         ,PARM-PREMISE-NO                         
P00464                         ,PARM-TO-DATE                            
P00464                         ,PARM-FROM-REV-MTH.                      
REARCH*                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
      *                                                                         
T22202     PERFORM 7730-READ-BILL-WINDOW THRU 7730-EXIT.                
      *                                                                         
           PERFORM 1000-PROCESS-INPUT         THRU 1000-EXIT.           
           PERFORM 2000-PROCESS-OUTPUT        THRU 2000-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                        TO ACTIVE-PARAGRAPH.      
                                                                        
REARCH     PERFORM 0100A-DECLARE-GTT           THRU  0100A-EXIT.        
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARCH             RETURN_CODE                                          
REARCH            ,LTRIM(RTRIM(REVENUE_MONTH))    AS REVENUE_MONTH             
REARCH            ,DAYS                                                 
REARCH            ,UNITS                                                
REARCH            ,CODE_UTIL_TYPE                                       
REARCH            ,CUSTOMER_NO                                          
REARCH            ,NEW_CHARGE                                           
REARCH            ,LTRIM(RTRIM(RATE_PLAN_NO))     AS RATE_PLAN_NO              
REARCH            ,LTRIM(RTRIM(CALC_ERROR))       AS [ERROR]                    
REARCH            ,HTG_CLG_SW                                           
REARCH            ,EPP_CATEGORY                                         
P00694            ,ELEC_BUFFER                                          
P00694            ,GAS_BUFFER                                           
REARCH         FROM #CSR02322_R1                                 
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ026
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,STRIP(REVENUE_MONTH)    AS REVENUE_MONTH                     
MFA-TR*           ,DAYS                                                         
MFA-TR*           ,UNITS                                                        
MFA-TR*           ,CODE_UTIL_TYPE                                               
MFA-TR*           ,CUSTOMER_NO                                                  
MFA-TR*           ,NEW_CHARGE                                                   
MFA-TR*           ,STRIP(RATE_PLAN_NO)     AS RATE_PLAN_NO                      
MFA-TR*           ,STRIP(CALC_ERROR)       AS ERROR                             
MFA-TR*           ,HTG_CLG_SW                                                   
MFA-TR*           ,EPP_CATEGORY                                                 
MFA-TR*           ,ELEC_BUFFER                                                  
MFA-TR*           ,GAS_BUFFER                                                   
MFA-TR*        FROM SESSION.CSR02322_R1                                         
MFA-TR*    END-EXEC.                                                            
REARCH*                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
REARCH******************************************************************        
REARCH*0100A-DECLARE-GTT.                                                       
REARCH******************************************************************        
REARCH 0100A-DECLARE-GTT.                                               
REARCH     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02322_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02322_R1
              (                                                        
REARCH             RETURN_CODE              INT                     
REARCH            ,REVENUE_MONTH CHAR(10)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
REARCH            ,DAYS                     SMALLINT                    
REARCH            ,UNITS                    DECIMAL(9,0)                
REARCH            ,CODE_UTIL_TYPE CHAR(01)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
REARCH            ,CUSTOMER_NO              DECIMAL(10,0)               
REARCH            ,NEW_CHARGE               DECIMAL(11,2)               
REARCH            ,RATE_PLAN_NO CHAR(03)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
REARCH            ,CALC_ERROR CHAR(08)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH            ,HTG_CLG_SW               DECIMAL(3,0)                
REARCH            ,EPP_CATEGORY CHAR(01)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
P00694            ,ELEC_BUFFER              DECIMAL(9,5)                
P00694            ,GAS_BUFFER               DECIMAL(9,5)                
REARCH         )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH     MOVE SQLSTATE TO WS-SQLSTATE.                                
REARCH     MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
REARCH                                                                  
REARCH     IF WS-SQLSTATE = '42710'                                     
REARCH        PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
REARCH     ELSE                                                         
REARCH         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
REARCH             NEXT SENTENCE                                        
REARCH         ELSE                                                     
REARCH            MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
REARCH            MOVE SQLCODE              TO ABEND-SQLCODE            
REARCH            MOVE SQLSTATE             TO ABEND-SQLSTATE           
REARCH            MOVE '0100A'              TO ACTIVE-PARAGRAPH         
REARCH            MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
REARCH            MOVE SPACES               TO ABEND-SQL-PREDICATES     
REARCH                                         ABEND-TABLES             
REARCH            MOVE 'CSR02322_R1'        TO TABLE-1                  
REARCH            MOVE SPACES               TO TABLE-ELEMENT-1          
REARCH            MOVE SPACES               TO HOSTVAR-ELEMENT-1        
REARCH            PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
REARCH         END-IF                                                   
REARCH     END-IF.                                                      
       0100A-EXIT.                                                      
           EXIT.                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     CALLS 1100-RECEIVE-PARMS                                   *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
REARCH     MOVE PARM-PREMISE-NO               TO PARM-PREMISE-NO-TEMP.  
           MOVE PARM-PREMISE-NO               TO BI-PREMISE-NO.         
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     CALLS 2100-DESCRIBE-RESULT                                 *        
      *           2200-BUILD-RESULT                                    *        
      *           8100-SEND-RESULT                                     *        
      *                                                                *        
      *      CALLED FROM 0000-MAINLINE                                 *        
      *                                                                *        
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *        
      *      AND SENDS THEN BACK                                       *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2100'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           PERFORM 2200-BUILD-RESULT          THRU 2200-EXIT.           
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
REARCH******************************************************************        
REARCH*2000A-MOVE-RESULT.                                                       
REARCH******************************************************************        
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE RS-RETURN-CODE           TO S-RETURN-CODE.              
REARCH     MOVE RS-REVENUE-MONTH         TO S-REVENUE-MONTH.            
REARCH     MOVE RS-DAYS                  TO S-DAYS.                     
REARCH     MOVE RS-UNITS                 TO S-UNITS.                    
REARCH     MOVE RS-CODE-UTIL-TYPE        TO S-CODE-UTIL-TYPE.           
REARCH     MOVE RS-CUSTOMER-NO           TO S-CUSTOMER-NO.              
P00694     IF RS-CODE-UTIL-TYPE = 'E'                                   
P00694        COMPUTE RS-NEW-CHARGE ROUNDED = RS-NEW-CHARGE *           
P00694                                WS-ESTRATE-INCR-ELEC              
P00694     ELSE                                                         
P00694        IF RS-CODE-UTIL-TYPE = 'G'                                
P00694           COMPUTE RS-NEW-CHARGE ROUNDED = RS-NEW-CHARGE *        
P00694                                   WS-ESTRATE-INCR-GAS            
P00694        END-IF                                                    
P00694     END-IF.                                                      
REARCH     MOVE RS-NEW-CHARGE            TO S-NEW-CHARGE.               
REARCH     MOVE RS-RATE-PLAN-NO          TO S-RATE-PLAN-NO.             
REARCH     MOVE RS-CALC-ERROR            TO S-CALC-ERROR.               
REARCH     MOVE RS-HTG-CLG-SW            TO S-HTG-CLG-SW.               
REARCH     MOVE RS-EPP-CATEGORY          TO S-EPP-CATEGORY.             
P00694     MOVE RS-ELEC-BUFFER           TO S-ELEC-BUFFER.              
P00694     MOVE RS-GAS-BUFFER            TO S-GAS-BUFFER.               
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *     CALLS 7100-FETCH-RATE-ANAL                                 *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
       2200-BUILD-RESULT.                                               
      *                                                                         
           PERFORM 6100-CALCULATE-DATE        THRU 6100-EXIT.           
                                                                        
T13225     PERFORM 6500-LOAD-REV-DISTRICT-CD  THRU 6500-EXIT.           
                                                                        
T34569     INITIALIZE C8-DELINQ-VALUE.                                  
T34569     MOVE 'DATABASE'                TO C8-DELINQ-CD.              
P00694     MOVE '01'                      TO C8-COMPANY-NO.             
T34569     PERFORM 7740-READ-DELINQUENCY  THRU 7740-EXIT.               
T34569     MOVE C8-DELINQ-VALUE           TO WS-DATABASE.               
P00694     MOVE WS-DATABASE               TO LS-DATABASE.               
                                                                        
           PERFORM 7100-OPEN-BI-CURSOR        THRU 7100-EXIT.           
           PERFORM 7110-FETCH-BI-CURSOR       THRU 7110-EXIT.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE 'Y'                        TO WS-BILL-EXISTS         
              MOVE BG-BILL-NO                 TO WS-CURRENT-BILL-NO     
                                                                        
P00694       MOVE BG-COMPANY-NO              TO C8-COMPANY-NO           
A04527       IF BG-COMPANY-NO = '01'                                    
                                                                        
P00694          MOVE 'PCT-RESRATEINCR-ELEC'    TO C8-DELINQ-CD          
P00694          PERFORM 7740-READ-DELINQUENCY  THRU 7740-EXIT           
P00694          MOVE C8-DELINQ-VALUE          TO WS-PCT-RESRATEINCR-ELEC
P00694          COMPUTE WS-PCT-RESRATEINCR-ELEC =                       
P00694                     (WS-PCT-RESRATEINCR-ELEC * .01)              
                                                                        
P00694          MOVE 'PCT-COMRATEINCR-ELEC'    TO C8-DELINQ-CD          
P00694          PERFORM 7740-READ-DELINQUENCY  THRU 7740-EXIT           
P00694          MOVE C8-DELINQ-VALUE          TO WS-PCT-COMRATEINCR-ELEC
P00694          COMPUTE WS-PCT-COMRATEINCR-ELEC =                       
P00694                     (WS-PCT-COMRATEINCR-ELEC * .01)              
                                                                        
P00694          MOVE 'PCT-RESRATEINCR-GAS'     TO C8-DELINQ-CD          
P00694          PERFORM 7740-READ-DELINQUENCY  THRU 7740-EXIT           
P00694          MOVE C8-DELINQ-VALUE           TO WS-PCT-RESRATEINCR-GAS
P00694          COMPUTE WS-PCT-RESRATEINCR-GAS  =                       
P00694                     (WS-PCT-RESRATEINCR-GAS * .01)               
                                                                        
P00694          MOVE 'PCT-COMRATEINCR-GAS'     TO C8-DELINQ-CD          
P00694          PERFORM 7740-READ-DELINQUENCY  THRU 7740-EXIT           
P00694          MOVE C8-DELINQ-VALUE           TO WS-PCT-COMRATEINCR-GAS
P00694          COMPUTE WS-PCT-COMRATEINCR-GAS  =                       
P00694                     (WS-PCT-COMRATEINCR-GAS * .01)               
P00694       ELSE                                                       
P00694             MOVE 'PCT-ESTRATEINCR-GAS'     TO C8-DELINQ-CD       
P00694             PERFORM 7740-READ-DELINQUENCY  THRU 7740-EXIT        
P00694          MOVE C8-DELINQ-VALUE           TO WS-ESTRATE-GAS        
P00694          COMPUTE WS-ESTRATE-GAS     =                            
P00694                     (WS-ESTRATE-GAS * .01)                       
P00694       END-IF                                                     
             PERFORM 2205-PROCESS-BI-CURSOR THRU 2205-EXIT              
               UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                  
                                                                        
           ELSE                                                         
              MOVE 100                        TO RS-RETURN-CODE         
REARCH        PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT           
              PERFORM 8100-SEND-RESULT        THRU 8100-EXIT            
           END-IF.                                                      
                                                                        
           PERFORM 7120-CLOSE-BI-CURSOR       THRU 7120-EXIT.           
                                                                        
                                                                        
                                                                        
T11888     IF WS-BILL-EXISTS = 'Y' THEN                                 
T11888        PERFORM 2700-COMPUTE-SUBD-UMTR-AMT THRU 2700-EXIT         
T11888        PERFORM 2600-COMPUTE-PRIV-UMTR-AMT THRU 2600-EXIT         
T11888     END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2205-PROCESS-BI-CURSOR                                         *        
      *                                                                *        
      *     CALLS  2205-PROCESS-BI-CURSOR                              *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     FETCHES ROWS FROM BI-TABLE                                 *        
      *     PROCESSES BILL DETAILS FROM BG TABLE                       *        
      *     FOR EACH CUSTOMER NO. OBTAINED FROM BI TABLE               *        
      ******************************************************************        
       2205-PROCESS-BI-CURSOR.                                          
                                                                        
           MOVE '2205'                        TO ACTIVE-PARAGRAPH.      
P00694     MOVE SQLCODE                       TO RS-RETURN-CODE         
P00694     IF BG-ACCOUNT-NO NOT EQUAL WS-PREV-ACCOUNT-NO                
P00694        INITIALIZE     RS-ELEC-BUFFER                             
P00694                       RS-GAS-BUFFER                              
P00694        MOVE BG-ACCOUNT-NO                 TO AT-ACCOUNT-NO       
P00694                                              WS-PREV-ACCOUNT-NO  
P00694        PERFORM 7000-GET-ACCOUNT-DETAILS   THRU 7000-EXIT         
A04527        IF BG-COMPANY-NO = '01'                                   
P00694           EVALUATE AT-ACCOUNT-TYPE-CODE                          
P00694              WHEN 'R'                                            
P00694                 MOVE WS-PCT-RESRATEINCR-ELEC TO RS-ELEC-BUFFER   
P00694                 COMPUTE WS-ESTRATE-INCR-ELEC =                   
P00694                         WS-PCT-RESRATEINCR-ELEC + 1              
P00694                 MOVE WS-PCT-RESRATEINCR-GAS  TO RS-GAS-BUFFER    
P00694                 COMPUTE WS-ESTRATE-INCR-GAS  =                   
P00694                         WS-PCT-RESRATEINCR-GAS  + 1              
P00694              WHEN 'C'                                            
P00694                 MOVE WS-PCT-COMRATEINCR-ELEC TO RS-ELEC-BUFFER   
P00694                 COMPUTE WS-ESTRATE-INCR-ELEC =                   
P00694                         WS-PCT-COMRATEINCR-ELEC + 1              
P00694                 MOVE WS-PCT-COMRATEINCR-GAS  TO RS-GAS-BUFFER    
P00694                 COMPUTE WS-ESTRATE-INCR-GAS  =                   
P00694                         WS-PCT-COMRATEINCR-GAS  + 1              
P00694           END-EVALUATE                                           
P00694        ELSE                                                      
P00694           MOVE WS-ESTRATE-GAS          TO RS-GAS-BUFFER          
P00694           COMPUTE WS-ESTRATE-INCR-GAS = WS-ESTRATE-GAS + 1       
P00694        END-IF                                                    
P00694     END-IF.                                                      
                                                                        
T12936     IF BG-REV-MTH-ORIG-BILL > 0                                  
T12936        MOVE BG-REV-MTH-ORIG-BILL  TO WS-REVENUE-MONTH-CHAR       
T12936     ELSE                                                         
T12936        MOVE BG-REVENUE-MONTH      TO WS-REVENUE-MONTH-CHAR       
T12936     END-IF                                                       
           MOVE WS-REVENUE-MONTH-CHAR (1:4)   TO WS-YEAR                
           MOVE WS-REVENUE-MONTH-CHAR (5:2)   TO WS-MONTH               
           MOVE WS-REVENUE-DATE               TO RS-REVENUE-MONTH       
           MOVE BI-CUSTOMER-NO                TO RS-CUSTOMER-NO         
           MOVE BG-CODE-UTIL-TYPE             TO RS-CODE-UTIL-TYPE      
                                                                        
           IF WS-MONTH = '12' OR '01' OR '02' OR '06' OR '07' OR '08'   
              MOVE 1                          TO RS-HTG-CLG-SW          
           ELSE                                                         
              MOVE 0                          TO RS-HTG-CLG-SW          
           END-IF.                                                      
                                                                        
T11128     MOVE BG-ACCOUNT-NO                 TO UT-ACCOUNT-NO          
                                                                        
T11128     MOVE BG-CODE-UTIL-TYPE             TO UT-CODE-UTIL-TYPE      
T11128     MOVE BG-IC-NO                      TO UT-IC-NO               
                                                                        
T11128     IF BG-CODE-UTIL-TYPE = 'E'                                   
T11128        AND  (WS-ELEC-RATE = SPACES OR                            
T11128             (WS-IC-NO NOT = BG-IC-NO ))                          
T11128        PERFORM 7400-SELECT-UTIL        THRU 7400-EXIT            
T11128        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
T11128           MOVE UT-RATE-PLAN-NO            TO WS-ELEC-RATE        
T11128        ELSE                                                      
T11128           MOVE BG-RATE-PLAN-NO            TO WS-ELEC-RATE        
T11128        END-IF                                                    
T11128     ELSE IF BG-CODE-UTIL-TYPE = 'G'                              
T11128             AND  (WS-GAS-RATE = SPACES OR                        
T11128                  (WS-IC-NO NOT = BG-IC-NO ))                     
T11128             PERFORM 7400-SELECT-UTIL        THRU 7400-EXIT       
T11128             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL           
T11128                MOVE UT-RATE-PLAN-NO            TO WS-GAS-RATE    
T11128             ELSE                                                 
T11128                MOVE BG-RATE-PLAN-NO            TO WS-GAS-RATE    
T11128             END-IF                                               
T11128     END-IF
           END-IF.                                                      
T11128                                                                  
                                                                        
           MOVE BG-IC-NO                      TO WS-IC-NO.              
                                                                        
ACT111     PERFORM 7715-CHECK-SHARED-LIGHT THRU 7715-EXIT.              
                                                                        
           IF BG-CODE-UTIL-TYPE NOT = 'U'  AND                          
ACT111        (WS-SHARED-LIGHTING-FL NOT = 'Y')                         
               MOVE BG-ACCOUNT-NO              TO CX-ACCOUNT-NO         
               MOVE BG-BILL-ITEM-TIMESTMP      TO CX-BILL-ITEM-TIMESTMP 
               MOVE BG-BILL-NO                 TO CX-BILL-NO            
               MOVE BG-CODE-UTIL-TYPE          TO CX-CODE-UTIL-TYPE     
               MOVE BG-IC-NO                   TO CX-IC-NO              
A04527         IF BG-COMPANY-NO = '01'                                  
P00694            PERFORM 2206-SCEG-BBP        THRU 2206-EXIT           
P00694         ELSE                                                     
P00694            PERFORM 2210-PROCESS-CX-CURSOR  THRU 2210-EXIT        
P00694         END-IF                                                   
           END-IF.                                                      
                                                                        
           PERFORM 7110-FETCH-BI-CURSOR  THRU 7110-EXIT.                
                                                                        
       2205-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00694******************************************************************        
P00694** BBP PROCESS FOR SCEG COMPANY                                           
P00694******************************************************************        
P00694 2206-SCEG-BBP.                                                   
P00694*    BUILD ALL DETAILS AND SEND                                           
P00694     MOVE '2206'                        TO ACTIVE-PARAGRAPH.      
P00694     PERFORM 5110-LOAD-BILLING-DETAILS  THRU 5110-EXIT.           
P00694                                                                  
P00694     MOVE SPACES                   TO RS-CALC-ERROR.              
P00694                                                                  
P00694     PERFORM 7025-GET-HIST-UNITS   THRU 7025-EXIT.                
P00694     IF RS-CODE-UTIL-TYPE = 'G'                                   
P00694        COMPUTE RS-UNITS ROUNDED =                                
P00694                CX-NO-UNITS * WS-BC-BTU-FACTOR-BG                 
P00694     ELSE                                                         
P00694        MOVE CX-NO-UNITS           TO RS-UNITS                    
P00694     END-IF.                                                      
P00694     MOVE CX-NO-DAYS               TO RS-DAYS.                    
P00694     MOVE BG-AMT-BILL-ITEM         TO RS-NEW-CHARGE.              
P00694     PERFORM 2590-SET-EPP-CATEGORY THRU 2590-EXIT.                
ACT140     IF RS-DAYS = 0 AND RS-UNITS = 0 AND RS-NEW-CHARGE = 0        
ACT140        CONTINUE                                                  
ACT140     ELSE                                                         
P00694        PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT             
P00694        PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
ACT140     END-IF.                                                      
P00694                                                                  
P00694 2206-EXIT.                                                       
P00694      EXIT.                                                       
P00694                                                                  
      ******************************************************************        
      * 2210-PROCESS-CX-CURSOR                                         *        
      *                                                                *        
      *     CALLS  2210-PROCESS-CX-CURSOR                              *        
      *     CALLED FROM 2205-PROCESS-BI-CURSOR                         *        
      *                                                                *        
      *     FETCHES ROWS FROM CX-TABLE                                 *        
      *     PROCESSES METERED CONSUMPTION DETAILS FROM CX TABLE        *        
      *     FOR EACH ACCOUNT NO. OBTAINED FROM CX TABLE                *        
      ******************************************************************        
       2210-PROCESS-CX-CURSOR.                                          
                                                                        
           MOVE '2210'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           INITIALIZE LS-PCSCA100-COMM-AREA                             
                  WS-BILLING-CALC-WORK                                  
                  WS-BILLING-COMPONENT                                  
                  WS-BILLING-ADJUSTMENT                                 
                  WS-BILL-CALC-BG                                       
                  WS-BILL-CALC-CX                                       
                  WS-BILL-CALC-UC                                       
                  WS-BILL-CALC-FH                                       
                  WS-BILL-CONTRACT-BK                                   
                  WS-FIXED-FCTR-TABLE-FF                                
                  WS-BILL-CNTR-HIST-BX                                  
                  WS-PEAK-HIST-PH                                       
                  WS-INTERRUPT-ACCT-IP                                  
                  WS-STANDBY-GEN-SE                                     
                  WS-INTERRUPT-IR                                       
                  WS-MTRD-ENVRNMT-TABLE-MN                              
                  WS-HOLD-CX-DATA                                       
                  WS-HOLD-BC-DATA                                       
                  WS-HOLD-BA-DATA                                       
                  WS-BILLING-WQ-ITEMS-WF                                
T5113             WS-REFUND-RN                                          
                                                                        
      *                                                                         
T23513     MOVE WS-DATABASE                   TO LS-DATABASE.           
                                                                        
           PERFORM 5110-LOAD-BILLING-DETAILS  THRU 5110-EXIT.           
                                                                        
           MOVE SPACES                        TO WS-BC-CALC-DATE        
P00464*                                                                         
P00464     IF PARM-APPL-ID = 'BPAMAINT'                                 
P00464        MOVE WS-CURRENT-DATE            TO WS-BC-CALC-DATE        
P00464     ELSE                                                         
P00464        MOVE PARM-TO-DATE               TO WS-BC-CALC-DATE        
P00464     END-IF.                                                      
P00464*                                                                         
           MOVE ZEROES                        TO RS-UNITS.              
                                                                        
           PERFORM 7200-OPEN-CX-CURSOR        THRU 7200-EXIT            
           PERFORM 7210-FETCH-CX-CURSOR       THRU 7210-EXIT            
                                                                        
           SET CX-INDX                        TO 1                      
           PERFORM 5120-LOAD-MTRD-CNSMPTN     THRU 5120-EXIT            
           UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                     
                                                                        
           PERFORM 7220-CLOSE-CX-CURSOR       THRU 7220-EXIT.           
                                                                        
                                                                        
           MOVE SPACES                        TO WS-CALC-ERROR          
           PERFORM 6000-CALL-BILL-CALC        THRU 6000-EXIT.           
                                                                        
           IF WS-CALC-ERROR NOT = SPACE                                 
                MOVE WS-CALC-ERROR            TO RS-CALC-ERROR          
                MOVE ZEROES                   TO RS-NEW-CHARGE          
           ELSE                                                         
T34569          COMPUTE WS-BC-AMT-BILL-ITEM-BG =                        
T34569                  WS-BC-AMT-BILL-ITEM-BG + WS-AGL-METER-CHARGE    
                MOVE SPACES                   TO RS-CALC-ERROR          
                PERFORM 2500-COMPUTE-TAXES THRU 2500-EXIT               
                MOVE WS-BILL-AMT-PLUS-TAXES   TO RS-NEW-CHARGE          
           END-IF.                                                      
                                                                        
C23415***********************************************************               
C23415** THIS CODE MOVED TO  2535-PSNC-TAX-CALC  ****************               
C23415***********************************************************               
C25327**DISPLAY GAS USAGE IN THERMS.                                            
T13714     IF RS-CODE-UTIL-TYPE = 'G'                                   
T28228        IF WS-PSNC-CALC                                           
T28228           NEXT SENTENCE                                          
T28228        ELSE                                                      
T13714           COMPUTE RS-UNITS ROUNDED =                             
T13714                   RS-UNITS * WS-BC-BTU-FACTOR-BG                 
T28228        END-IF                                                    
T28228     END-IF.                                                      
T28228     SET WS-NOT-PSNC-CALC               TO TRUE.                  
C23415***********************************************************               
                                                                        
           MOVE WS-BC-NO-CNSMPTN-DAYS         TO RS-DAYS                
           PERFORM 2590-SET-EPP-CATEGORY THRU 2590-EXIT.                
                                                                        
ACT140     IF RS-DAYS = 0 AND RS-UNITS = 0 AND RS-NEW-CHARGE = 0        
ACT140        CONTINUE                                                  
ACT140     ELSE                                                         
REARCH        PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT             
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
ACT140     END-IF.                                                      
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
T13225****************************************************************          
      /***************************************************************          
      **    2500-COMPUTE-TAXES.                                     **          
      **                                                            **          
      ****************************************************************          
       2500-COMPUTE-TAXES.                                              
           IF WS-TAX-TABLE-ENTRIES = ZERO                               
              PERFORM 2510-LOAD-TAX-RATES THRU 2510-EXIT                
C23415        PERFORM 2511-LOAD-EXCISE-RATES THRU 2511-EXIT             
           END-IF.                                                      
                                                                        
      ** DETERMINE CLASS-BASED EXEMPTIONS                                       
                                                                        
           PERFORM 2520-GET-SPECIAL-EXEMPTIONS THRU 2520-EXIT           
                                                                        
      ** DETERMINE TAXABLE BASE                                                 
           MOVE ZERO TO WS-STATE-TAXABLE-AMT                            
                        WS-CITY-TAXABLE-AMT                             
                        WS-OTHER-TAXABLE-AMT                            
                        WS-CITY-TAX-RATE-CALC                           
                        WS-STATE-TAX-RATE-CALC.                         
                                                                        
           IF WS-BC-CODE-STAT-TAX-XMT-BG = 'N' OR SPACE                 
              MOVE WS-BC-AMT-BILL-ITEM-BG TO WS-STATE-TAXABLE-AMT       
T20141        IF WS-BC-CODE-OTHR-TAX-XMT-BG = 'N' OR SPACE              
T20141           MOVE WS-BC-AMT-BILL-ITEM-BG TO WS-OTHER-TAXABLE-AMT    
T20141        END-IF                                                    
           END-IF                                                       
                                                                        
           IF WS-BC-CODE-CITY-TAX-XMT-BG = 'N' OR SPACE                 
              MOVE WS-BC-AMT-BILL-ITEM-BG TO WS-CITY-TAXABLE-AMT        
           END-IF                                                       
                                                                        
           IF WS-BC-CODE-OTHR-TAX-XMT-BG = 'N' OR SPACE                 
              MOVE WS-BC-AMT-BILL-ITEM-BG TO WS-OTHER-TAXABLE-AMT       
           END-IF                                                       
                                                                        
      ** BACK OUT ANY NON-TAXABLE ADJUSTMENTS FROM THE TOTAL BILL AMT           
      ** (SPECIAL/FIXED FACTORS CAN BE SEPARATELY IDENTIFIED AS NON             
      **  TAXABLE)                                                              
           IF WS-BC-CODE-UTIL-TYPE-BG NOT = 'U'                         
             IF WS-STATE-TAXABLE-AMT > ZERO                             
                 OR WS-CITY-TAXABLE-AMT > ZERO                          
                 OR WS-OTHER-TAXABLE-AMT > ZERO                         
              PERFORM VARYING BA-INDX FROM 1 BY 1                       
31178                 UNTIL BA-INDX > 200                               
                         OR WS-BC-FACTOR-ID (BA-INDX) = SPACE           
                 IF ADD-TO-COMPONENT-AMT (BA-INDX)                      
                       OR SUB-FROM-COMPONENT-AMT (BA-INDX)              
                       OR REPL-COMPONENT-AMT (BA-INDX)                  
                    IF WS-BC-STATE-TAX-XMPT-ADJ (BA-INDX) = 'Y'         
                       SUBTRACT WS-BC-AMT-ADJUSTMENT (BA-INDX)          
                          FROM WS-STATE-TAXABLE-AMT                     
                    END-IF                                              
                    IF WS-BC-CITY-TAX-XMPT-ADJ (BA-INDX) = 'Y'          
                       SUBTRACT WS-BC-AMT-ADJUSTMENT (BA-INDX)          
                          FROM WS-CITY-TAXABLE-AMT                      
                    END-IF                                              
                    IF WS-BC-OTHER-TAX-XMPT-ADJ (BA-INDX) = 'Y'         
                       SUBTRACT WS-BC-AMT-ADJUSTMENT (BA-INDX)          
                          FROM WS-OTHER-TAXABLE-AMT                     
                    END-IF                                              
                 END-IF                                                 
              END-PERFORM                                               
             END-IF                                                     
           END-IF.                                                      
                                                                        
      ** FRANCHISE TAXES (CITY) ARE THEMSELVES SUBJECT TO STATE                 
      ** TAXES IN SC. CALCULATE THIS FIRST THEN ADD RESULT TO                   
      ** STATE TAX BASIS                                                        
           IF WS-CITY-TAXABLE-AMT > ZERO                                
              PERFORM 2540-CALCULATE-CITY-TAX THRU 2540-EXIT            
              IF WS-BC-CODE-STAT-TAX-XMT-BG                             
                     = 'N' OR SPACE                                     
                 ADD WS-BC-AMT-CITY-TAX-BG                              
                   TO WS-STATE-TAXABLE-AMT                              
T20141           ADD WS-BC-AMT-CITY-TAX-BG                              
T20141             TO WS-OTHER-TAXABLE-AMT                              
              END-IF                                                    
           END-IF.                                                      
                                                                        
T20141     IF WS-OTHER-TAXABLE-AMT > ZERO                               
T20141        PERFORM 2550-CALCULATE-OTHER-TAX THRU 2550-EXIT           
T20141     END-IF.                                                      
                                                                        
           IF WS-STATE-TAXABLE-AMT > ZERO                               
              PERFORM 2530-CALCULATE-STATE-TAX THRU 2530-EXIT           
           END-IF.                                                      
                                                                        
C23415     IF WS-BC-COMPANY-NO-BG = WS-SCEG                             
             COMPUTE WS-BILL-AMT-PLUS-TAXES =                           
                   WS-BC-AMT-BILL-ITEM-BG                               
                  + (WS-BC-AMT-BILL-ITEM-BG * WS-STATE-TAX-RATE-CALC)   
C23415     ELSE                                                         
C23415       IF WS-BC-COMPANY-NO-BG = WS-PSNC                           
C23415         COMPUTE WS-BILL-AMT-PLUS-TAXES =                         
C23415            WS-BC-AMT-BILL-ITEM-BG  +  WS-BC-AMT-STATE-TAX-BG     
C23415       END-IF                                                     
C23415     END-IF .                                                     
                                                                        
           COMPUTE WS-BILL-AMT-PLUS-TAXES ROUNDED =                     
                   WS-BILL-AMT-PLUS-TAXES                               
                + (WS-BILL-AMT-PLUS-TAXES * WS-CITY-TAX-RATE-CALC).     
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2510-LOAD-TAX-RATES.                                             
           MOVE HIGH-VALUES TO WS-TAX-RATE-TABLE.                       
           SET TC-INDX TO 1                                             
           MOVE ZERO TO WS-TAX-TABLE-ENTRIES.                           
           PERFORM 7610-OPEN-TAX-DATA THRU 7610-EXIT                    
           PERFORM UNTIL SQLCODE = NOT-FOUND                            
              PERFORM 7612-FETCH-TAX-DATA THRU 7612-EXIT                
              IF SQLCODE = SUCCESSFUL-CALL                              
T20141           IF WS-TAX-TABLE-ENTRIES = WS-TAX-TABLE-ENTRIES-MAX     
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE '2510'              TO ACTIVE-PARAGRAPH        
                    MOVE 'TAX ENTRIES '      TO ABEND-FUNCTION          
                    MOVE 'GREATER THAN 1000' TO TABLE-1                 
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
                 ELSE                                                   
                    PERFORM 2512-LOAD-TAX-ENTRY THRU 2512-EXIT          
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM                                                  
           PERFORM 7614-CLOSE-TAX-DATA THRU 7614-EXIT.                  
                                                                        
       2510-EXIT.                                                       
           EXIT.                                                        
C23415                                                                  
C23415 2511-LOAD-EXCISE-RATES.                                          
C23415     INITIALIZE WS-TAX-EXCISE-TABLE.                              
C23415     SET X6-INDX TO 1 .                                           
C23415     MOVE ZERO TO WS-TAX-EX-ENTRIES.                              
C23415     PERFORM 7115-OPEN-EX-DATA THRU 7115-EXIT.                    
C23415     PERFORM UNTIL SQLCODE = NOT-FOUND                            
C23415        PERFORM 7116-FETCH-EX-DATA THRU 7116-EXIT                 
C23415        IF SQLCODE = SUCCESSFUL-CALL                              
C23415           IF WS-TAX-EX-ENTRIES = WS-TAX-EX-ENTRIES-MAX           
C23415              MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
C23415              MOVE '2511'              TO ACTIVE-PARAGRAPH        
C23415              MOVE 'EX ENTRIES '       TO ABEND-FUNCTION          
C23415              MOVE 'GREATER THAN 100 ' TO TABLE-1                 
C23415              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
C23415              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
C23415           ELSE                                                   
C23415              PERFORM 2513-LOAD-EX-ENTRY THRU 2513-EXIT           
C23415           END-IF                                                 
C23415        END-IF                                                    
C23415     END-PERFORM                                                  
C23415     PERFORM 7117-CLOSE-EX-DATA THRU 7117-EXIT.                   
C23415 2511-EXIT.                                                       
C23415      EXIT.                                                       
                                                                        
      *                                                                         
       2512-LOAD-TAX-ENTRY.                                             
           IF WS-TC-TAX-TYPE (TC-INDX) = TC-TAX-TYPE                    
            AND WS-TR-TAX-JURISDICTION (TC-INDX) = TR-DETAIL-ID         
T20141      AND WS-TC-TAX-CNTRL-NO (TC-INDX) = TC-TAX-CNTRL-NO          
              IF WS-TR-DATE-FROM (TC-INDX 2) = HIGH-VALUES              
                 MOVE TR-DATE-FROM TO WS-TR-DATE-FROM (TC-INDX 2)       
                 IF TR-DATE-TO > LOW-VALUES                             
                    MOVE TR-DATE-TO   TO WS-TR-DATE-TO (TC-INDX 2)      
                 ELSE                                                   
                    MOVE '9999-99-99' TO WS-TR-DATE-TO (TC-INDX 2)      
                 END-IF                                                 
                 IF WS-TR-DATE-FROM (TC-INDX 2)                         
                       > WS-TR-DATE-TO (TC-INDX 1)                      
                    MOVE WS-TR-DATE-FROM (TC-INDX 2)                    
                      TO WS-TR-DATE-TO (TC-INDX 1)                      
                 END-IF                                                 
                 MOVE TR-TAX-RATE  TO WS-TAX-RATE (TC-INDX 2)           
              END-IF                                                    
           ELSE                                                         
              ADD 1 TO WS-TAX-TABLE-ENTRIES                             
              SET TC-INDX TO WS-TAX-TABLE-ENTRIES                       
              MOVE TC-TAX-TYPE TO WS-TC-TAX-TYPE (TC-INDX)              
              MOVE TR-DETAIL-ID                                         
                TO WS-TR-TAX-JURISDICTION (TC-INDX)                     
              MOVE TR-DATE-FROM TO WS-TR-DATE-FROM (TC-INDX 1)          
              IF TR-DATE-TO > LOW-VALUES                                
                 MOVE TR-DATE-TO   TO WS-TR-DATE-TO (TC-INDX 1)         
              ELSE                                                      
                 MOVE '9999-99-99' TO WS-TR-DATE-TO (TC-INDX 1)         
              END-IF                                                    
              MOVE TR-TAX-RATE           TO WS-TAX-RATE (TC-INDX 1)     
              MOVE TU-CODE-TAX-CALC-INST TO WS-TU-CALC-INST (TC-INDX)   
              MOVE TU-TAX-ELEC           TO WS-TU-ELECT (TC-INDX)       
              MOVE TU-TAX-GAS            TO WS-TU-GAS   (TC-INDX)       
              MOVE TU-TAX-MDSE           TO WS-TU-MDSE  (TC-INDX)       
              MOVE TU-TAX-WATER          TO WS-TU-WATER (TC-INDX)       
              MOVE TU-TAX-SEWER          TO WS-TU-SEWER (TC-INDX)       
              MOVE TU-TAX-TRASH          TO WS-TU-TRASH (TC-INDX)       
T20141        MOVE TC-TAX-CNTRL-NO       TO WS-TC-TAX-CNTRL-NO (TC-INDX)
T20141        MOVE TC-FACTOR-ID          TO WS-TU-FACTOR-ID (TC-INDX)   
           END-IF.                                                      
       2512-EXIT.                                                       
           EXIT.                                                        
                                                                        
C23415 2513-LOAD-EX-ENTRY.                                              
C23415        ADD  1                TO WS-TAX-EX-ENTRIES.               
C23415        SET  X6-INDX          TO WS-TAX-EX-ENTRIES.               
C23415        MOVE X6-TAX-CNTRL-NO  TO WS-X6-TAX-CNTRL-NO (X6-INDX).    
C23415        MOVE X6-DATE-FROM     TO WS-X6-TAX-DATE-FROM (X6-INDX).   
C23415        MOVE X6-BLOCK-NO      TO WS-X6-BLOCK-NO (X6-INDX)    .    
C23415        MOVE X6-BLOCK-UNITS   TO WS-X6-BLOCK-UNITS (X6-INDX) .    
C23415        MOVE X6-EXCISE-TAX-UNIT-AM                                
C23415                            TO WS-X6-EXCISE-TAX-UNIT-AM(X6-INDX). 
C23415 2513-EXIT .                                                      
C23415      EXIT.                                                       
      *                                                                         
       2520-GET-SPECIAL-EXEMPTIONS.                                     
           MOVE BG-COMPANY-NO    TO F2-COMPANY-NO                       
                                    F3-COMPANY-NO                       
           MOVE WS-REV-DISTRICT-CD                                      
              TO F2-REV-DISTRICT-CD                                     
           MOVE WS-BC-CODE-REVENUE-CLASS-BG                             
              TO F2-CODE-REVENUE-CLASS                                  
                 F3-CODE-REVENUE-CLASS                                  
           MOVE WS-BC-CODE-UTIL-TYPE-BG                                 
              TO F2-CODE-UTIL-TYPE                                      
                 F3-CODE-UTIL-TYPE                                      
                                                                        
           IF WS-BC-CODE-CITY-TAX-XMT-BG = SPACE                        
              PERFORM 7640-GET-FRAN-TX-XMPTN THRU 7640-EXIT             
              IF WS-FT-XMPT = 'Y'                                       
                 MOVE 'Y' TO WS-BC-CODE-CITY-TAX-XMT-BG                 
              END-IF                                                    
           END-IF.                                                      
           IF WS-BC-CODE-STAT-TAX-XMT-BG = SPACE                        
              PERFORM 7642-GET-STATE-TX-XMPTN THRU 7642-EXIT            
              IF WS-ST-XMPT = 'Y'                                       
      ** THIS IS THE CASE WHERE THE REVENUE CLASS IS EXEMPT BUT THERE           
      ** IS NO EXEMPTION SET IN THE UTIL-ENVRNMT ROW. 'A' INDICATES             
      ** 'NO PARAGRAPH'                                                         
                 MOVE 'A' TO WS-BC-CODE-STAT-TAX-XMT-BG                 
T20141           MOVE 'A' TO WS-BC-CODE-OTHR-TAX-XMT-BG                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2530-CALCULATE-STATE-TAX.                                        
           MOVE WS-REV-DISTRICT-CD     TO WS-TAX-JURISDICTION-CD        
           MOVE 'A' TO WS-TAX-COMPARE-TYPE                              
           MOVE  ZERO TO WS-STATE-TAX-RATE-CALC                         
T20141     PERFORM VARYING TC-INDX FROM 1 BY 1                          
T20141       UNTIL TC-INDX > WS-TAX-TABLE-ENTRIES                       
T20141          OR WS-TC-TAX-ID (TC-INDX) = HIGH-VALUES                 
T20141        IF WS-TC-TAX-ID (TC-INDX) = WS-TAX-COMPARE-KEY            
                 IF (WS-BC-CODE-UTIL-TYPE-BG = 'E'                      
                        AND WS-TU-ELECT (TC-INDX) = 'Y')                
                      OR (WS-BC-CODE-UTIL-TYPE-BG = 'U'                 
                            AND WS-UM-SERVICE-TYPE = 'E'                
                            AND WS-TU-ELECT (TC-INDX) = 'Y')            
                      OR (WS-BC-CODE-UTIL-TYPE-BG = 'U'                 
                            AND WS-UM-SERVICE-TYPE = 'G'                
                            AND WS-TU-GAS (TC-INDX) = 'Y')              
                      OR (WS-BC-CODE-UTIL-TYPE-BG = 'G'                 
                        AND WS-TU-GAS (TC-INDX) = 'Y')                  
                      OR (WS-BC-CODE-UTIL-TYPE-BG = 'W'                 
                        AND WS-TU-WATER (TC-INDX) = 'Y')                
                      OR (WS-BC-CODE-UTIL-TYPE-BG = 'S'                 
                        AND WS-TU-SEWER (TC-INDX) = 'Y')                
                      OR (WS-BC-CODE-UTIL-TYPE-BG = 'T'                 
                        AND WS-TU-TRASH (TC-INDX) = 'Y')                
                    PERFORM 2534-APPLY-TAX THRU 2534-EXIT               
                 END-IF                                                 
T20141        END-IF                                                    
T20141     END-PERFORM.                                                 
       2530-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2534-APPLY-TAX.                                                  
                                                                        
C23415** FOR PSNC THE TAX CALC INSTRUCTION WILL BE = R                          
ACT302** FOR SEB ACCTS THE TAX CALC INSTRUCTION WILL BE = R                     
                                                                        
T20141     IF WS-TU-CALC-INST (TC-INDX) = 'R'                           
T20141        IF BG-REV-MTH-ORIG-BILL > 0                               
T20141           MOVE BG-REV-MTH-ORIG-BILL                              
T20141             TO WS-REV-MONTH-TEST                                 
T20141        ELSE                                                      
T20141           MOVE WS-BC-REVENUE-MONTH-BG                            
T20141             TO WS-REV-MONTH-TEST                                 
T20141        END-IF                                                    
                                                                        
ACT302****--  CALCULATE NC STATE TAX  BILLED DATE >= 2014-07-01 --****          
ACT302****--  CALCULATE NC EXCISE TAX BILLED DATE <  2014-07-01 --****          
ACT302****--  WS-PSNC-SALES-TAX-START IS FROM DELIQUENCY        --****          
                                                                        
ACT302        IF BG-DATE-ORIG-BILL > SPACES                             
ACT302           MOVE BG-DATE-ORIG-BILL                                 
ACT302             TO WS-DATE-BILLED-TEST                               
ACT302        ELSE                                                      
ACT302           MOVE BI-DATE-BILLED    TO WS-DATE-BILLED-TEST          
ACT302        END-IF                                                    
                                                                        
ACT302        IF WS-DATE-BILLED-TEST >= '2014-07-01' AND                
ACT302           BG-COMPANY-NO = WS-PSNC                                
ACT302            MOVE WS-DATE-BILLED-TEST    TO WS-TEMP-WORK-DATE      
ACT302            MOVE 'N'                    TO WS-EXCISE-TAX-CALC     
ACT302        ELSE                                                      
ACT302            MOVE WS-REV-MONTH-TEST(1:4) TO WS-TEMP-WORK-DATE (1:4)
ACT302            MOVE '-'                    TO WS-TEMP-WORK-DATE (5:1)
ACT302            MOVE WS-REV-MONTH-TEST(5:2) TO WS-TEMP-WORK-DATE (6:2)
ACT302            MOVE '-'                    TO WS-TEMP-WORK-DATE (8:1)
ACT302            MOVE '01'                   TO WS-TEMP-WORK-DATE (9:2)
ACT302            MOVE 'Y'                    TO WS-EXCISE-TAX-CALC     
ACT302        END-IF                                                    
                                                                        
ACT302        PERFORM 2534A-GET-TAX-RATE-VERSION THRU 2534A-EXIT        
                                                                        
ACT302        IF WS-EXCISE-TAX-CALC = 'Y'   AND                         
ACT302           BG-COMPANY-NO  = WS-PSNC                               
ACT302               PERFORM 2535-PSNC-TAX-CALC   THRU 2535-EXIT        
ACT302        ELSE                                                      
ACT302           IF SEB-DATABASE                                        
ACT302              AND  BG-CODE-STAT-TAX-XMT = WS-GA-MFG-SALES-TAX-XMT 
ACT302                MOVE ZERO              TO WS-OLD-STATE-TAX-PCT    
ACT302                                          WS-STATE-TAX-RATE       
ACT302                MOVE WS-TAX-RATE-CALC                             
ACT302                                       TO WS-OLD-STATE-TAX-PCT    
ACT302                PERFORM 2535A-SEB-SALE-TAX-XMPT THRU 2535A-EXIT   
ACT302                                                                  
ACT302                COMPUTE WS-BC-AMT-STATE-TAX-BG ROUNDED            
ACT302                        = WS-STATE-TAXABLE-AMT                    
ACT302                        * WS-STATE-TAX-RATE                       
ACT302                MOVE WS-STATE-TAX-RATE TO                         
ACT302                     WS-STATE-TAX-RATE-CALC                       
ACT302                MOVE WS-STATE-TAX-RATE TO WS-HLD-STATE-TAX-RATE   
ACT302           ELSE                                                   
ACT302             COMPUTE  WS-BC-AMT-STATE-TAX-BG ROUNDED              
ACT302                        = WS-STATE-TAXABLE-AMT                    
ACT302                        * WS-TAX-RATE-CALC                        
ACT302                MOVE WS-TAX-RATE-CALC                             
ACT302                  TO WS-STATE-TAX-RATE-CALC                       
ACT302                MOVE WS-TAX-RATE-CALC                             
ACT302                  TO WS-HLD-STATE-TAX-RATE                        
ACT302           END-IF                                                 
ACT302        END-IF                                                    
ACT302     END-IF.                                                      
                                                                        
       2534-EXIT.                                                       
           EXIT.                                                        
                                                                        
ACT302***---------------------------------------------------------------        
ACT302*** GET TAX RATE VERSION FOR THE PERIOD                                   
ACT302***---------------------------------------------------------------        
ACT302 2534A-GET-TAX-RATE-VERSION.                                      
ACT302     INITIALIZE WS-VERSION-FOUND                                  
ACT302                WS-TAX-RATE-CALC .                                
ACT302     PERFORM VARYING TR-INDX FROM 1 BY 1                          
SCA006       UNTIL VERSION-FOUND OR 
                   TR-INDX > 10 OR 
                   WS-TR-DATE-FROM (TC-INDX TR-INDX) = HIGH-VALUES              
ACT302        IF WS-TR-DATE-FROM (TC-INDX TR-INDX) <= WS-TEMP-WORK-DATE 
ACT302                         AND                                      
ACT302           WS-TR-DATE-TO (TC-INDX TR-INDX)   >= WS-TEMP-WORK-DATE 
ACT302             MOVE WS-TAX-RATE (TC-INDX TR-INDX)                   
ACT302               TO WS-TAX-RATE-CALC                                
ACT302             MOVE 'Y'                                             
ACT302               TO WS-VERSION-FOUND                                
ACT302        END-IF                                                    
ACT302     END-PERFORM.                                                 
ACT302                                                                  
ACT302     IF WS-VERSION-FOUND NOT = 'Y'                                
ACT302        DISPLAY 'TAX RATE VERSION NOT FOUND ' WS-TAX-COMPARE-KEY  
ACT302        DISPLAY 'TAX WORK DATE              ' WS-TEMP-WORK-DATE   
ACT302     END-IF.                                                      
ACT302                                                                  
ACT302 2534A-EXIT.                                                      
ACT302       EXIT.                                                      
                                                                        
C23415 2535-PSNC-TAX-CALC .                                             
C23415                                                                  
C23415     SET X6-INDX         TO 1.                                    
C23415     PERFORM 2537-TEST-REV-MONTH THRU 2537-EXIT                   
C23415             UNTIL WS-REV-MONTH-FOUND OR                          
C23415                   X6-INDX > WS-TAX-EX-ENTRIES-MAX.               
C23415                                                                  
C23415     SET X6-INDX-CORRECT TO 1.                                    
C23415     SET X6-INDX         TO 1.                                    
C23415     PERFORM 2538-EXDATA-FOR-REV-MONTH THRU 2538-EXIT             
C23415              UNTIL  X6-INDX > WS-TAX-EX-ENTRIES-MAX OR           
C23415                     WS-ENTRIES-NOT-FOUND.                        
C23415                                                                  
C23415     SET X6-INDX-CORRECT TO 1.                                    
C23415     MOVE ZERO TO WS-TOT-EXCISE-TAX-AMT.                          
C23415     IF RS-CODE-UTIL-TYPE = 'G'                                   
T28228        SET WS-PSNC-CALC TO TRUE                                  
C23415        COMPUTE RS-UNITS ROUNDED =                                
C23415                RS-UNITS * WS-BC-BTU-FACTOR-BG
           END-IF.                   
T28228                                                                  
C23415     MOVE RS-UNITS  TO WS-WORK-UNITS.                             
C23415     PERFORM  UNTIL  X6-INDX-CORRECT > 9 OR                       
C23415                                WS-WORK-UNITS <= ZERO             
C23415        IF WS-WORK-UNITS > WS-X6-BLOCK-UNITS-C(X6-INDX-CORRECT)   
C23415           COMPUTE WS-EXCISE-TAX-AMT ROUNDED =                    
C23415                      WS-X6-BLOCK-UNITS-C(X6-INDX-CORRECT) *      
C23415                      WS-X6-EXCISE-TAX-UNIT-AM-C(X6-INDX-CORRECT) 
C23415           COMPUTE WS-WORK-UNITS = WS-WORK-UNITS -                
C23415                      WS-X6-BLOCK-UNITS-C(X6-INDX-CORRECT)        
C23415           ADD WS-EXCISE-TAX-AMT TO WS-TOT-EXCISE-TAX-AMT         
C23415           SET X6-INDX-CORRECT UP BY 1                            
C23415        ELSE                                                      
C23415           COMPUTE WS-EXCISE-TAX-AMT ROUNDED =                    
C23415                      WS-WORK-UNITS *                             
C23415                      WS-X6-EXCISE-TAX-UNIT-AM-C(X6-INDX-CORRECT) 
C23415           COMPUTE WS-WORK-UNITS = WS-WORK-UNITS -                
C23415                      WS-X6-BLOCK-UNITS-C(X6-INDX-CORRECT)        
C23415           ADD WS-EXCISE-TAX-AMT TO WS-TOT-EXCISE-TAX-AMT         
C23415        END-IF                                                    
C23415     END-PERFORM .                                                
C23415                                                                  
C23415     MOVE WS-TOT-EXCISE-TAX-AMT  TO                               
C23415                   WS-BC-AMT-STATE-TAX-BG.                        
C23415                                                                  
C23415 2535-EXIT.                                                       
C23415     EXIT.                                                        
                                                                        
ACT302 2535A-SEB-SALE-TAX-XMPT.                                         
ACT302                                                                  
ACT302     MOVE ZERO                         TO WS-OLD-LOCAL-TAX-TOT    
ACT302                                          WS-NEW-LOCAL-TAX-TOT    
ACT302                                          WS-OLD-LOCAL-TAX-PCT    
ACT302                                          WS-NEW-LOCAL-TAX-PCT    
ACT302                                          WS-NEW-STATE-TAX-PCT    
ACT302                                          WS-TEMP-V1-REV-MTH      
ACT302                                          WS-TEMP-V2-REV-MTH      
ACT302                                          WS-TEMP-V1-END-REV-MTH  
ACT302                                          WS-TEMP-V2-END-REV-MTH  
ACT302                                          WS-TEMP-INDX.           
ACT302                                                                  
ACT302**MOVE TAX-RATE TABLE INDX VALUE TO TEMP-INDX.                            
ACT302     SET  WS-TEMP-INDX                 TO TC-INDX.                
ACT302                                                                  
ACT302**GET TEMP-WORK-DATE TO COMPARE WITH TAX-EXCISE TABLE FROM DATE           
ACT302     MOVE WS-REV-MONTH-TEST(1:4)       TO WS-TEMP-WORK-DATE (1:4).
ACT302     MOVE '-'                          TO WS-TEMP-WORK-DATE (5:1).
ACT302     MOVE WS-REV-MONTH-TEST(5:2)       TO WS-TEMP-WORK-DATE (6:2).
ACT302     MOVE '-'                          TO WS-TEMP-WORK-DATE (8:1).
ACT302     MOVE '01'                         TO WS-TEMP-WORK-DATE (9:2).
ACT302                                                                  
ACT302     MOVE WS-OTHER-TAX                 TO WS-TAX-COMPARE-TYPE.    
ACT302                                                                  
ACT302     PERFORM VARYING TC-INDX FROM 1 BY 1 UNTIL TC-INDX >          
ACT302                     WS-TAX-TABLE-ENTRIES                         
ACT302                  OR WS-TC-TAX-ID (TC-INDX) = HIGH-VALUES         
ACT302        IF WS-TC-TAX-ID (TC-INDX)  = WS-TAX-COMPARE-KEY           
ACT302           MOVE ZERO                   TO WS-OLD-LOCAL-TAX-PCT    
ACT302           PERFORM 2534A-GET-TAX-RATE-VERSION THRU 2534A-EXIT     
ACT302           MOVE WS-TAX-RATE-CALC    TO WS-OLD-LOCAL-TAX-PCT       
ACT302                                                                  
ACT302**GET THE EXEMPTED PERCENTAGE FOR ALL COUNTIES                            
ACT302           MOVE 1                      TO WS-COUNTY-XMT-PCT       
ACT302           MOVE WS-TC-TAX-CNTRL-NO (TC-INDX)                      
ACT302                                       TO WS-TAX-CNTRL-NO         
ACT302                                                                  
ACT302           PERFORM 2535C-GET-TAX-EXCISE-AMT THRU 2535C-EXIT       
ACT302                                                                  
ACT302**CALCULATE TOTAL EXEMPT TAX PERCENTAGE AT COUNTY LEVEL                   
ACT302           COMPUTE WS-NEW-LOCAL-TAX-PCT ROUNDED                   
ACT302                 = WS-OLD-LOCAL-TAX-PCT * WS-COUNTY-XMT-PCT       
ACT302           COMPUTE WS-NEW-LOCAL-TAX-TOT                           
ACT302                 = WS-NEW-LOCAL-TAX-TOT + WS-NEW-LOCAL-TAX-PCT    
ACT302           IF WS-TU-CODE-APPL-COND (TC-INDX) NOT                  
ACT302                                   = WS-GA-MFG-SALES-TAX-XMT      
ACT302              COMPUTE WS-OLD-LOCAL-TAX-TOT                        
ACT302                    = WS-OLD-LOCAL-TAX-TOT + WS-OLD-LOCAL-TAX-PCT 
ACT302           END-IF                                                 
ACT302        END-IF                                                    
ACT302     END-PERFORM.                                                 
ACT302                                                                  
ACT302**GET THE EXEMPT TAX PERCENTAGE FOR STATE                                 
ACT302     MOVE 1                            TO WS-STATE-XMT-PCT.       
ACT302     MOVE 10                           TO WS-TAX-CNTRL-NO.        
ACT302                                                                  
ACT302     PERFORM 2535C-GET-TAX-EXCISE-AMT THRU 2535C-EXIT.            
ACT302                                                                  
ACT302**CALCULATE NEW STATE TAX RATE AFTER EXEMPTION                            
ACT302     COMPUTE WS-OLD-STATE-TAX-PCT                                 
ACT302           = WS-OLD-STATE-TAX-PCT - WS-OLD-LOCAL-TAX-TOT.         
ACT302     COMPUTE WS-NEW-STATE-TAX-PCT ROUNDED                         
ACT302           = WS-OLD-STATE-TAX-PCT * WS-STATE-XMT-PCT.             
ACT302     COMPUTE WS-STATE-TAX-RATE                                    
ACT302           = WS-NEW-STATE-TAX-PCT + WS-NEW-LOCAL-TAX-TOT.         
ACT302                                                                  
ACT302**SET BACK ORIGINAL VALUES TO THE INDEX & COMPARE-TYPE                    
ACT302     SET TC-INDX                       TO WS-TEMP-INDX.           
ACT302     MOVE 'A'                          TO WS-TAX-COMPARE-TYPE.    
ACT302                                                                  
ACT302 2535A-EXIT.                                                      
ACT302     EXIT.                                                        
                                                                        
ACT302 2535C-GET-TAX-EXCISE-AMT.                                        
ACT302** GET THE EXEMT RATE FOR THE COUNTY & STATE                              
ACT302                                                                  
ACT302     MOVE 'N'                          TO WS-TAX-XMT-FOUND        
ACT302                                                                  
ACT302     PERFORM VARYING X6-INDX FROM 1 BY 1                          
ACT302              UNTIL  X6-INDX > WS-TAX-EX-ENTRIES OR               
ACT302                     WS-TAX-XMT-FOUND      = 'Y'                  
ACT302        IF WS-TEMP-WORK-DATE              >=                      
ACT302           WS-X6-TAX-DATE-FROM (X6-INDX)     AND                  
ACT302           WS-X6-TAX-CNTRL-NO  (X6-INDX)   = WS-TAX-CNTRL-NO      
ACT302           SET TAX-XMT-FOUND           TO TRUE                    
ACT302           IF WS-TAX-CNTRL-NO              = 10                   
ACT302              MOVE WS-X6-EXCISE-TAX-UNIT-AM (X6-INDX)             
ACT302                                       TO WS-STATE-XMT-PCT        
ACT302           ELSE                                                   
ACT302              MOVE WS-X6-EXCISE-TAX-UNIT-AM (X6-INDX)             
ACT302                                       TO WS-COUNTY-XMT-PCT       
ACT302           END-IF                                                 
ACT302        END-IF                                                    
ACT302     END-PERFORM.                                                 
ACT302                                                                  
ACT302 2535C-EXIT.                                                      
ACT302     EXIT.                                                        
                                                                        
       2536-PRORATE-TAXES.                                              
           PERFORM 7620-GET-DAYS-AT-CURRENT THRU 7620-EXIT              
           COMPUTE WS-BC-AMT-STATE-TAX-BG                               
                 ROUNDED                                                
              = (WS-STATE-TAXABLE-AMT                                   
                  * WS-TAX-RATE (TC-INDX 1)                             
                  * (WS-DAYS-AT-CURRENT / WS-BC-NO-CNSMPTN-DAYS))       
                + (WS-STATE-TAXABLE-AMT                                 
                   * WS-TAX-RATE (TC-INDX 2)                            
                   * (1 - (WS-DAYS-AT-CURRENT / WS-BC-NO-CNSMPTN-DAYS)))
           .                                                            
       2536-EXIT.                                                       
           EXIT.                                                        
                                                                        
C23415 2537-TEST-REV-MONTH .                                            
C23415                                                                  
C23415     MOVE WS-X6-TAX-DATE-FROM(X6-INDX) TO WS-WORK-DATE.           
C23415     MOVE WS-WORK-DATE (6:2) TO WS-WORK-FROM-DATE (5:2).          
C23415     MOVE WS-WORK-DATE (1:4) TO WS-WORK-FROM-DATE (1:4).          
C23415     IF WS-REV-MONTH-TEST  >= WS-WORK-FROM-DATE                   
C23415        SET WS-REV-MONTH-FOUND TO TRUE                            
C23415     ELSE                                                         
C23415        CONTINUE                                                  
C23415     END-IF.                                                      
C23415                                                                  
C23415     SET X6-INDX  UP BY 1.                                        
C23415                                                                  
C23415 2537-EXIT.                                                       
C23415      EXIT.                                                       
                                                                        
C23415 2538-EXDATA-FOR-REV-MONTH.                                       
C23415     SEARCH WS-TAX-EX-ENTRY                                       
C23415         AT END                                                   
C23415            MOVE PROGRAM-NAME        TO ABEND-PROGRAM             
C23415            MOVE '2538'              TO ACTIVE-PARAGRAPH          
C23415            MOVE 'EX ENTRIES '       TO ABEND-FUNCTION            
C23415            MOVE 'NOT FOUND '        TO TABLE-1                   
C23415            PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
C23415            PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
C23415         WHEN WS-X6-TAX-DATE-FROM (X6-INDX) = SPACES              
C23415              SET WS-ENTRIES-NOT-FOUND TO TRUE                    
C23415         WHEN WS-X6-TAX-DATE-FROM (X6-INDX) = WS-WORK-DATE        
C23415              MOVE WS-X6-BLOCK-NO (X6-INDX) TO                    
C23415                             WS-X6-BLOCK-NO-C(X6-INDX-CORRECT)    
C23415              MOVE WS-X6-BLOCK-UNITS (X6-INDX) TO                 
C23415                           WS-X6-BLOCK-UNITS-C(X6-INDX-CORRECT)   
C23415              MOVE WS-X6-EXCISE-TAX-UNIT-AM (X6-INDX) TO          
C23415                      WS-X6-EXCISE-TAX-UNIT-AM-C(X6-INDX-CORRECT) 
C23415                 SET X6-INDX-CORRECT UP BY 1                      
C23415         WHEN WS-X6-TAX-DATE-FROM (X6-INDX) < WS-WORK-DATE        
C23415              SET WS-ENTRIES-NOT-FOUND TO TRUE                    
C23415     END-SEARCH.                                                  
C23415     SET X6-INDX UP BY 1.                                         
C23415                                                                  
C23415 2538-EXIT.                                                       
C23415      EXIT.                                                       
                                                                        
      *                                                                         
       2540-CALCULATE-CITY-TAX.                                         
           MOVE WS-REV-DISTRICT-CD     TO WS-TAX-JURISDICTION-CD        
           MOVE 'B' TO WS-TAX-COMPARE-TYPE                              
           MOVE  ZERO TO WS-CITY-TAX-RATE-CALC                          
T20141     PERFORM VARYING TC-INDX FROM 1 BY 1                          
T20141       UNTIL TC-INDX > WS-TAX-TABLE-ENTRIES                       
T20141          OR WS-TC-TAX-ID (TC-INDX) = HIGH-VALUES                 
T20141        IF WS-TC-TAX-ID (TC-INDX) = WS-TAX-COMPARE-KEY            
                 IF (WS-BC-CODE-UTIL-TYPE-BG = 'E'                      
                        AND WS-TU-ELECT (TC-INDX) = 'Y')                
                      OR (WS-BC-CODE-UTIL-TYPE-BG = 'U'                 
                            AND WS-UM-SERVICE-TYPE = 'E'                
                            AND WS-TU-ELECT (TC-INDX) = 'Y')            
                      OR (WS-BC-CODE-UTIL-TYPE-BG = 'U'                 
                            AND WS-UM-SERVICE-TYPE = 'G'                
                            AND WS-TU-GAS (TC-INDX) = 'Y')              
                      OR (WS-BC-CODE-UTIL-TYPE-BG = 'G'                 
                        AND WS-TU-GAS (TC-INDX) = 'Y')                  
                      OR (WS-BC-CODE-UTIL-TYPE-BG = 'W'                 
                        AND WS-TU-WATER (TC-INDX) = 'Y')                
                      OR (WS-BC-CODE-UTIL-TYPE-BG = 'S'                 
                        AND WS-TU-SEWER (TC-INDX) = 'Y')                
                      OR (WS-BC-CODE-UTIL-TYPE-BG = 'T'                 
                        AND WS-TU-TRASH (TC-INDX) = 'Y')                
                    PERFORM 2544-APPLY-TAX THRU 2544-EXIT               
                 ELSE                                                   
                    MOVE ZERO TO WS-BC-AMT-CITY-TAX-BG                  
                 END-IF                                                 
T20141        END-IF                                                    
T20141     END-PERFORM.                                                 
                                                                        
       2540-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2544-APPLY-TAX.                                                  
T20141     IF WS-TU-CALC-INST (TC-INDX) = 'R'                           
T20141        IF BG-REV-MTH-ORIG-BILL > 0                               
T20141           MOVE BG-REV-MTH-ORIG-BILL                              
T20141             TO WS-REV-MONTH-TEST                                 
T20141        ELSE                                                      
T20141           MOVE WS-BC-REVENUE-MONTH-BG                            
T20141             TO WS-REV-MONTH-TEST                                 
T20141        END-IF                                                    
T20141        MOVE ZERO TO WS-V1-REV-MTH                                
T20141                     WS-V2-REV-MTH                                
T20141* SET VERSION 2 TO LATEST VERSION                                         
T20141        MOVE WS-TR-DATE-FROM (TC-INDX 1) TO WS-START-DATE         
T20141        MOVE WS-START-DATE (6:2) TO WS-V2-REV-MTH (5:2)           
T20141        MOVE WS-START-DATE (1:4) TO WS-V2-REV-MTH (1:4)           
T20141* IF A PRIOR VERSION EXISTS, SET TO VERSION 1                             
T20141        IF WS-TR-DATE-FROM (TC-INDX 2) NOT = HIGH-VALUES          
T20141           MOVE WS-TR-DATE-FROM (TC-INDX 2) TO WS-START-DATE      
T20141           MOVE WS-START-DATE (6:2) TO WS-V1-REV-MTH (5:2)        
T20141           MOVE WS-START-DATE (1:4) TO WS-V1-REV-MTH (1:4)        
T20141        END-IF                                                    
T20141* CHECK LASTEST VERSION                                                   
T20141        IF WS-REV-MONTH-TEST >= WS-V2-REV-MTH                     
T20141           COMPUTE WS-BC-AMT-CITY-TAX-BG ROUNDED                  
T20141             = WS-CITY-TAXABLE-AMT * WS-TAX-RATE (TC-INDX 1)      
                 MOVE WS-TAX-RATE (TC-INDX 1)                           
                   TO WS-CITY-TAX-RATE-CALC                             
T20141        ELSE                                                      
T20141* CHECK PRIOR VERSION                                                     
T20141           IF WS-V1-REV-MTH > 0                                   
T20141            AND WS-REV-MONTH-TEST >= WS-V1-REV-MTH                
T20141              COMPUTE WS-BC-AMT-STATE-TAX-BG ROUNDED              
T20141                = WS-STATE-TAXABLE-AMT * WS-TAX-RATE (TC-INDX 2)  
T20141              MOVE WS-TAX-RATE (TC-INDX 2)                        
T20141                TO WS-CITY-TAX-RATE-CALC                          
T20141           END-IF                                                 
T20141        END-IF                                                    
T20141     ELSE                                                         
              EVALUATE TRUE                                             
                 WHEN WS-BC-CNSMPTN-START-DATE                          
                     >= WS-TR-DATE-FROM (TC-INDX 1)                     
                    COMPUTE WS-BC-AMT-CITY-TAX-BG                       
                             ROUNDED                                    
                        = WS-CITY-TAXABLE-AMT                           
                            * WS-TAX-RATE (TC-INDX 1)                   
                    MOVE WS-TAX-RATE (TC-INDX 1)                        
                      TO WS-CITY-TAX-RATE-CALC                          
                 WHEN WS-BC-CNSMPTN-END-DATE                            
                     <= WS-TR-DATE-TO (TC-INDX 2)                       
                    COMPUTE WS-BC-AMT-CITY-TAX-BG                       
                             ROUNDED                                    
                          = WS-CITY-TAXABLE-AMT                         
                             * WS-TAX-RATE (TC-INDX 2)                  
                    MOVE WS-TAX-RATE (TC-INDX 2)                        
                      TO WS-CITY-TAX-RATE-CALC                          
                 WHEN WS-TU-CALC-INST (TC-INDX) = 'B'                   
                    IF WS-BC-CNSMPTN-END-DATE                           
                         >= WS-TR-DATE-FROM (TC-INDX 1)                 
                       COMPUTE WS-BC-AMT-CITY-TAX-BG                    
                             ROUNDED                                    
                           = WS-CITY-TAXABLE-AMT                        
                             * WS-TAX-RATE (TC-INDX 1)                  
                       MOVE WS-TAX-RATE (TC-INDX 1)                     
                         TO WS-CITY-TAX-RATE-CALC                       
                    ELSE                                                
                       COMPUTE WS-BC-AMT-CITY-TAX-BG                    
                             ROUNDED                                    
                            = WS-CITY-TAXABLE-AMT                       
                             * WS-TAX-RATE (TC-INDX 2)                  
                       MOVE WS-TAX-RATE (TC-INDX 2)                     
                         TO WS-CITY-TAX-RATE-CALC                       
                    END-IF                                              
                 WHEN OTHER                                             
                    PERFORM 2546-PRORATE-TAXES THRU 2546-EXIT           
                    MOVE WS-TAX-RATE (TC-INDX 2)                        
                      TO WS-CITY-TAX-RATE-CALC                          
              END-EVALUATE                                              
           END-IF.                                                      
       2544-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2546-PRORATE-TAXES.                                              
           PERFORM 7620-GET-DAYS-AT-CURRENT THRU 7620-EXIT              
           COMPUTE WS-BC-AMT-CITY-TAX-BG                                
                 ROUNDED                                                
              = (WS-CITY-TAXABLE-AMT                                    
                  * WS-TAX-RATE (TC-INDX 1)                             
                  * (WS-DAYS-AT-CURRENT / WS-BC-NO-CNSMPTN-DAYS))       
                + (WS-CITY-TAXABLE-AMT                                  
                   * WS-TAX-RATE (TC-INDX 2)                            
                   * (1 - (WS-DAYS-AT-CURRENT / WS-BC-NO-CNSMPTN-DAYS)))
           .                                                            
       2546-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2550-CALCULATE-OTHER-TAX.                                        
T20141     MOVE WS-REV-DISTRICT-CD TO WS-TAX-JURISDICTION-CD            
T20141     MOVE WS-OTHER-TAX TO WS-TAX-COMPARE-TYPE                     
T20141     PERFORM VARYING TC-INDX FROM 1 BY 1                          
T20141       UNTIL TC-INDX > WS-TAX-TABLE-ENTRIES                       
T20141          OR WS-TC-TAX-ID (TC-INDX) = HIGH-VALUES                 
T20141        IF WS-TC-TAX-ID (TC-INDX) = WS-TAX-COMPARE-KEY            
T20141           IF (WS-BC-CODE-UTIL-TYPE-BG = 'E'                      
T20141                  AND WS-TU-ELECT (TC-INDX) = 'Y')                
T20141                OR (WS-BC-CODE-UTIL-TYPE-BG = 'U'                 
T20141                      AND WS-UM-SERVICE-TYPE = 'E'                
T20141                      AND WS-TU-ELECT (TC-INDX) = 'Y')            
T20141                OR (WS-BC-CODE-UTIL-TYPE-BG = 'U'                 
T20141                      AND WS-UM-SERVICE-TYPE = 'G'                
T20141                      AND WS-TU-GAS (TC-INDX) = 'Y')              
T20141                OR (WS-BC-CODE-UTIL-TYPE-BG = 'G'                 
T20141                  AND WS-TU-GAS (TC-INDX) = 'Y')                  
T20141                OR (WS-BC-CODE-UTIL-TYPE-BG = 'W'                 
T20141                  AND WS-TU-WATER (TC-INDX) = 'Y')                
T20141                OR (WS-BC-CODE-UTIL-TYPE-BG = 'S'                 
T20141                  AND WS-TU-SEWER (TC-INDX) = 'Y')                
T20141                OR (WS-BC-CODE-UTIL-TYPE-BG = 'T'                 
T20141                  AND WS-TU-TRASH (TC-INDX) = 'Y')                
T20141              PERFORM 2555-APPLY-OTHER-TAX THRU 2555-EXIT         
T20141           END-IF                                                 
T20141        END-IF                                                    
T20141     END-PERFORM.                                                 
       2550-EXIT.                                                       
           EXIT.                                                        
                                                                        
T20141 2555-APPLY-OTHER-TAX.                                            
T20141     IF WS-TU-CALC-INST (TC-INDX) = 'R'                           
T20141        IF BG-REV-MTH-ORIG-BILL     > 0                           
T20141           MOVE BG-REV-MTH-ORIG-BILL                              
T20141             TO WS-REV-MONTH-TEST                                 
T20141        ELSE                                                      
T20141           MOVE WS-BC-REVENUE-MONTH-BG                            
T20141             TO WS-REV-MONTH-TEST                                 
T20141        END-IF                                                    
ACT302        MOVE WS-REV-MONTH-TEST(1:4) TO WS-TEMP-WORK-DATE (1:4)    
ACT302        MOVE '-'                    TO WS-TEMP-WORK-DATE (5:1)    
ACT302        MOVE WS-REV-MONTH-TEST(5:2) TO WS-TEMP-WORK-DATE (6:2)    
ACT302        MOVE '-'                    TO WS-TEMP-WORK-DATE (8:1)    
ACT302        MOVE '01'                   TO WS-TEMP-WORK-DATE (9:2)    
ACT302                                                                  
ACT302        PERFORM 2534A-GET-TAX-RATE-VERSION THRU 2534A-EXIT        
ACT302                                                                  
ACT302        COMPUTE WS-AMT-OTHER-TAX ROUNDED                          
ACT302                = WS-OTHER-TAXABLE-AMT                            
ACT302                      * WS-TAX-RATE-CALC                          
ACT302        END-COMPUTE                                               
                                                                        
T20141     END-IF.                                                      
T20141 2555-EXIT.                                                       
T20141     EXIT.                                                        
      *                                                                         
T20141 2556-PRORATE-OTH-TAXES.                                          
T20141     PERFORM 7620-GET-DAYS-AT-CURRENT THRU 7620-EXIT              
T20141     COMPUTE WS-AMT-OTHER-TAX                                     
T20141           ROUNDED                                                
T20141        = (WS-OTHER-TAXABLE-AMT                                   
T20141            * WS-TAX-RATE (TC-INDX 1)                             
T20141            * (WS-DAYS-AT-CURRENT / WS-BC-NO-CNSMPTN-DAYS))       
T20141          + (WS-OTHER-TAXABLE-AMT                                 
T20141            * WS-TAX-RATE (TC-INDX 2)                             
T20141            * (1 - (WS-DAYS-AT-CURRENT / WS-BC-NO-CNSMPTN-DAYS))).
T20141 2556-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
T13055****************************************************************          
      * THIS ROUTINE DECIDES THE CATEGORY ON THE EPP ESTIMATE DATAWIN*          
      * UNDER WHICH THE ITEM WILL BE DISPLAYED ON PANEL 153          *          
      * E - ELECTRIC; G - GAS; S - SUBDIVISIONAL P - PRIVATE LIGHTING*          
      ****************************************************************          
       2590-SET-EPP-CATEGORY.                                           
           MOVE SPACES TO RS-EPP-CATEGORY.                              
T16108     EXEC SQL                                                     
                SELECT DISTINCT 'Y'                                     
                  INTO :WS-CUST-PLAN-EXISTS                             
                FROM CSS_CUST_PLAN WITH(READUNCOMMITTED)                        
                  WHERE CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE             
                  AND   ACCOUNT_NO  = :BG-ACCOUNT-NO                    
                  AND   IC_NO       = :BG-IC-NO                         
A02036                                                           
A02036                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT DISTINCT 'Y'                                             
MFA-TR*           INTO :WS-CUST-PLAN-EXISTS                                     
MFA-TR*         FROM CSS_CUST_PLAN                                              
MFA-TR*           WHERE CODE_UTIL_TYPE = :BG-CODE-UTIL-TYPE                     
MFA-TR*           AND   ACCOUNT_NO  = :BG-ACCOUNT-NO                            
MFA-TR*           AND   IC_NO       = :BG-IC-NO                                 
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 2590                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '2590'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_CUST_PLAN  '   TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE BG-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
CBSI          MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
CBSI          MOVE BG-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2             
CBSI          MOVE 'IC_NO'             TO TABLE-ELEMENT-3               
CBSI          MOVE BG-IC-NO            TO HOSTVAR-ELEMENT-3             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
           IF RS-CODE-UTIL-TYPE = 'E'                                   
              IF WS-CUST-PLAN-EXISTS = 'Y'                              
                 MOVE 'P'  TO  RS-EPP-CATEGORY                          
              ELSE                                                      
                 MOVE 'E'  TO  RS-EPP-CATEGORY                          
              END-IF                                                    
           ELSE                                                         
              IF RS-CODE-UTIL-TYPE = 'G'                                
                 IF WS-CUST-PLAN-EXISTS = 'Y'                           
                    MOVE 'P'  TO  RS-EPP-CATEGORY                       
                 ELSE                                                   
                    MOVE 'G'  TO  RS-EPP-CATEGORY                       
T16108           END-IF                                                 
               ELSE                                                     
                  IF RS-CODE-UTIL-TYPE = 'U'                            
                     IF (RS-RATE-PLAN-NO NOT = '064')                   
                         MOVE 'P' TO RS-EPP-CATEGORY                    
                     ELSE                                               
                         MOVE 'S' TO RS-EPP-CATEGORY                    
                     END-IF                                             
                  END-IF                                                
               END-IF                                                   
           END-IF                                                       
           .                                                            
T16108     MOVE SPACES TO WS-CUST-PLAN-EXISTS.                          
       2590-EXIT.                                                       
           EXIT.                                                        
T13225****************************************************************          
      *                                                                         
T11888****************************************************************          
T11888* 2600-COMPUTE-PRIV-UMTR-AMT                                   *          
T11888****************************************************************          
T11888 2600-COMPUTE-PRIV-UMTR-AMT.                                      
T11888                                                                  
T11888     MOVE ZERO          TO WS-PRIV-SUM-AMT.                       
T20983     INITIALIZE WS-ACTIVE-RETURN-CODE.                            
T11888*                                                                         
C35040     MOVE 'N'                            TO WS-PVTLT-ACTIVE       
C35040     MOVE BG-ACCOUNT-NO                  TO CP-ACCOUNT-NO         
C35040     PERFORM 7710-CHECK-PRIV-ACTIVE      THRU 7710-EXIT.          
C35040     IF WS-PVTLT-ACTIVE = 'Y'                                     
PERTUN        PERFORM 7720-GET-PRIV-LIT-AMT    THRU 7720-EXIT           
C35040     ELSE                                                         
C35040          MOVE +000                      TO WS-PRIV-SUM-AMT       
C35040     END-IF                                                       
PERTUN                                                                  
T11888     IF WS-PRIV-SUM-AMT > 0 THEN                                  
T11888        MOVE ZEROES                       TO RS-RETURN-CODE       
T11888        MOVE SPACES                       TO RS-REVENUE-MONTH     
T11888        MOVE ZEROES                       TO RS-DAYS              
T11888        MOVE ZEROES                       TO RS-UNITS             
T11888        MOVE 'U'                          TO RS-CODE-UTIL-TYPE    
T11888        MOVE SPACES                       TO RS-CALC-ERROR        
T11888        MOVE ZEROES                       TO RS-HTG-CLG-SW        
A04527        MOVE 'P'                          TO RS-EPP-CATEGORY      
REARCH        PERFORM 2000A-MOVE-RESULT         THRU 2000A-EXIT         
T11888        PERFORM 8100-SEND-RESULT          THRU 8100-EXIT          
T11888     END-IF.                                                      
T11888                                                                  
T11888 2600-EXIT.                                                       
T11888     EXIT.                                                        
T11888                                                                  
T11888****************************************************************          
T11888* 2700-COMPUTE-SUBD-UMTR-AMT                                   *          
T11888****************************************************************          
T11888 2700-COMPUTE-SUBD-UMTR-AMT.                                      
T11888                                                                  
T11888     MOVE BG-ACCOUNT-NO               TO CP-ACCOUNT-NO            
T11888     MOVE 'U'                         TO CP-CODE-UTIL-TYPE        
T11888     MOVE 'A'                         TO CP-CODE-PLAN-STATUS      
T11888     MOVE ZERO                        TO WS-SUBDIV-SUM-AMT        
T11888*                                                                         
T11888     PERFORM 7501-OPEN-CP-UT-SUBD-CSR THRU 7501-EXIT.             
T11888*                                                                         
T11888     PERFORM 7510-FETCH-CP-UT-SUBD-CSR THRU 7510-EXIT             
T11888*                                                                         
T11888     PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
T11888*                                                                         
T11888        MOVE 'U'                      TO RT-CODE-UTIL-TYPE        
T11888        MOVE UT-RATE-PLAN-NO          TO RT-RATE-PLAN-NO          
T11888*                                                                         
T11888        MOVE 'U'                      TO UP-CODE-UTIL-TYPE        
T11888        MOVE UT-RATE-PLAN-NO          TO UP-RATE-PLAN-NO          
T11888        MOVE CP-RATE-ITEM-CODE        TO UP-RATE-ITEM-CODE        
T11888*                                                                         
T11888        PERFORM 7430-SELECT-PRICE     THRU 7430-EXIT              
T11888*                                                                         
T11888        COMPUTE WS-SUBDIV-SUM-AMT = WS-SUBDIV-SUM-AMT +           
T11888               ( UP-PRICE-PER-SERV *  CP-NO-UNITS )               
T11888*                                                                         
T11888        PERFORM 7510-FETCH-CP-UT-SUBD-CSR THRU 7510-EXIT          
T11888*                                                                         
T11888     END-PERFORM.                                                 
T11888     PERFORM 7520-CLOSE-CP-UT-SUBD-CSR THRU 7520-EXIT.            
T11888*                                                                         
T11888     IF WS-SUBDIV-SUM-AMT > 0 THEN                                
              MOVE WS-SUBDIV-SUM-AMT TO WS-BC-AMT-BILL-ITEM-BG          
              PERFORM 2800-COMPUTE-UNMTRD-TAXES THRU 2800-EXIT          
              MOVE WS-BILL-AMT-PLUS-TAXES       TO RS-NEW-CHARGE        
T11888        MOVE ZEROES                       TO RS-RETURN-CODE       
T11888        MOVE SPACES                       TO RS-REVENUE-MONTH     
T11888        MOVE ZEROES                       TO RS-DAYS              
T11888        MOVE ZEROES                       TO RS-UNITS             
T11888        MOVE 'U'                          TO RS-CODE-UTIL-TYPE    
T11888        MOVE BI-CUSTOMER-NO               TO RS-CUSTOMER-NO       
T11888        MOVE UT-RATE-PLAN-NO              TO RS-RATE-PLAN-NO      
T11888        MOVE SPACES                       TO RS-CALC-ERROR        
T11888        MOVE ZEROES                       TO RS-HTG-CLG-SW        
              PERFORM 2590-SET-EPP-CATEGORY THRU 2590-EXIT              
REARCH        PERFORM 2000A-MOVE-RESULT         THRU 2000A-EXIT         
T11888        PERFORM 8100-SEND-RESULT          THRU 8100-EXIT          
T11888     END-IF.                                                      
T11888                                                                  
T11888 2700-EXIT.                                                       
T11888     EXIT.                                                        
      *****************************************************************         
T13225*  2800-COMPUTE-UNMTRD-TAXES                                    *         
      *  COMPUTE THE TAXES FOR UTILITY CODE = U                       *         
      *****************************************************************         
       2800-COMPUTE-UNMTRD-TAXES.                                       
           MOVE CP-CODE-SERVICE-TYPE TO WS-UM-SERVICE-TYPE              
           PERFORM 2810-GET-BILLING-DET THRU 2810-EXIT.                 
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              PERFORM 2820-GET-UNMTRD-TAX           THRU 2820-EXIT      
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 PERFORM 2830-CLOSE-UNMTRD-TAX-CSR THRU 2830-EXIT       
                 MOVE WS-BC-AMT-BILL-ITEM-BG TO WS-BILL-AMT-PLUS-TAXES  
                 GO TO 2800-EXIT                                        
              ELSE                                                      
                 PERFORM 2830-CLOSE-UNMTRD-TAX-CSR THRU 2830-EXIT       
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
           MOVE PARM-TO-DATE         TO WS-BC-CNSMPTN-START-DATE        
           MOVE BG-CODE-CITY-TAX-XMT TO WS-BC-CODE-CITY-TAX-XMT-BG      
           MOVE BG-CODE-STAT-TAX-XMT TO WS-BC-CODE-STAT-TAX-XMT-BG      
           MOVE BG-CODE-OTHR-TAX-XMT TO WS-BC-CODE-OTHR-TAX-XMT-BG      
           MOVE CP-CODE-UTIL-TYPE    TO WS-BC-CODE-UTIL-TYPE-BG         
ACT178     MOVE BG-AMT-BILL-ITEM     TO WS-BC-AMT-BILL-ITEM-BG          
ACT178     MOVE BG-COMPANY-NO        TO WS-BC-COMPANY-NO-BG             
ACT178     MOVE BG-AMT-STATE-TAX     TO WS-BC-AMT-STATE-TAX-BG          
ACT178     MOVE BG-AMT-CITY-TAX      TO WS-BC-AMT-CITY-TAX-BG           
ACT178     MOVE BG-AMT-OTHER-TAX     TO WS-BC-AMT-OTHER-TAX-BG          
           PERFORM 2500-COMPUTE-TAXES THRU 2500-EXIT.                   
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2810-GET-BILLING-DET.                                            
           MOVE CP-CODE-UTIL-TYPE     TO BG-CODE-UTIL-TYPE.             
           MOVE CP-IC-NO              TO BG-IC-NO.                      
      *                                                                         
           EXEC SQL                                                     
               SELECT BG.CODE_REVENUE_CLASS,                            
                      BG.CODE_STAT_TAX_XMT ,                            
                      BG.CODE_CITY_TAX_XMT ,                            
                      BG.CODE_OTHR_TAX_XMT                              
ACT178              , BG.AMT_BILL_ITEM                                  
ACT178              , BG.COMPANY_NO                                     
ACT178              , BG.AMT_STATE_TAX                                  
ACT178              , BG.AMT_CITY_TAX                                   
ACT178              , BG.AMT_OTHER_TAX                                  
                 INTO :BG-CODE-REVENUE-CLASS,                           
                      :BG-CODE-STAT-TAX-XMT ,                           
                      :BG-CODE-CITY-TAX-XMT ,                           
                      :BG-CODE-OTHR-TAX-XMT                             
ACT178              , :BG-AMT-BILL-ITEM                                 
ACT178              , :BG-COMPANY-NO                                    
ACT178              , :BG-AMT-STATE-TAX                                 
ACT178              , :BG-AMT-CITY-TAX                                  
ACT178              , :BG-AMT-OTHER-TAX                                 
                 FROM CSS_BILLING_HDR   BI WITH(READUNCOMMITTED),               
                      CSS_BILLING_DET   BG WITH(READUNCOMMITTED)                
                WHERE BI.PREMISE_NO         = :BI-PREMISE-NO            
                  AND BI.ACCOUNT_NO         = BG.ACCOUNT_NO             
                  AND BG.CODE_BILL_ITM_TYPE = 'C'                       
                  AND BG.CODE_BILL_ITM_IND  = 'A'                       
T29768            AND BG.CODE_BILL_CALC     = 'A'                       
                  AND BI.BILL_NO            = BG.BILL_NO                
                  AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE        
                  AND BG.IC_NO              = :BG-IC-NO                 
                  AND BG.ACCOUNT_NO         = :BG-ACCOUNT-NO            
                  AND BG.REVENUE_MONTH      = :WS-MAX-REV-MONTH         
A04527                                                           
A02036                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT BG.CODE_REVENUE_CLASS,                                    
MFA-TR*               BG.CODE_STAT_TAX_XMT ,                                    
MFA-TR*               BG.CODE_CITY_TAX_XMT ,                                    
MFA-TR*               BG.CODE_OTHR_TAX_XMT                                      
MFA-TR*             , BG.AMT_BILL_ITEM                                          
MFA-TR*             , BG.COMPANY_NO                                             
MFA-TR*             , BG.AMT_STATE_TAX                                          
MFA-TR*             , BG.AMT_CITY_TAX                                           
MFA-TR*             , BG.AMT_OTHER_TAX                                          
MFA-TR*          INTO :BG-CODE-REVENUE-CLASS,                                   
MFA-TR*               :BG-CODE-STAT-TAX-XMT ,                                   
MFA-TR*               :BG-CODE-CITY-TAX-XMT ,                                   
MFA-TR*               :BG-CODE-OTHR-TAX-XMT                                     
MFA-TR*             , :BG-AMT-BILL-ITEM                                         
MFA-TR*             , :BG-COMPANY-NO                                            
MFA-TR*             , :BG-AMT-STATE-TAX                                         
MFA-TR*             , :BG-AMT-CITY-TAX                                          
MFA-TR*             , :BG-AMT-OTHER-TAX                                         
MFA-TR*          FROM CSS_BILLING_HDR   BI,                                     
MFA-TR*               CSS_BILLING_DET   BG                                      
MFA-TR*         WHERE BI.PREMISE_NO         = :BI-PREMISE-NO                    
MFA-TR*           AND BI.ACCOUNT_NO         = BG.ACCOUNT_NO                     
MFA-TR*           AND BG.CODE_BILL_ITM_TYPE = 'C'                               
MFA-TR*           AND BG.CODE_BILL_ITM_IND  = 'A'                               
MFA-TR*           AND BG.CODE_BILL_CALC     = 'A'                               
MFA-TR*           AND BI.BILL_NO            = BG.BILL_NO                        
MFA-TR*           AND BG.CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE                
MFA-TR*           AND BG.IC_NO              = :BG-IC-NO                         
MFA-TR*           AND BG.ACCOUNT_NO         = :BG-ACCOUNT-NO                    
MFA-TR*           AND BG.REVENUE_MONTH      = :WS-MAX-REV-MONTH                 
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 2810                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
T27705     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR WS-811         
              NEXT SENTENCE                                             
           ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
              GO TO 2810-EXIT                                           
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE '2810'                     TO ACTIVE-PARAGRAPH       
CBSI          MOVE 'CSS_BILLING_HDR'          TO TABLE-1                
CBSI          MOVE 'CSS_BILLING_DET'          TO TABLE-2                
CBSI          MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
CBSI          MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-4        
              MOVE BI-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE BG-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
CBSI          MOVE BG-IC-NO                   TO HOSTVAR-ELEMENT-3      
CBSI          MOVE BG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF
           END-IF.                                                      
       2810-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2820-GET-UNMTRD-TAX.                                             
           MOVE '2820'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN UNMTRD-TAX-CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'OPEN'                     TO ABEND-FUNCTION         
CBSI          MOVE 'CSS_BILLING_HDR'          TO TABLE-1                
CBSI          MOVE 'CSS_BILLING_DET'          TO TABLE-2                
CBSI          MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
CBSI          MOVE 'REVENUE_MONTH'            TO TABLE-ELEMENT-3        
              MOVE BI-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE BG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
CBSI          MOVE WS-MAX-REV-MONTH           TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
              FETCH UNMTRD-TAX-CSR                                      
               INTO :BG-CODE-REVENUE-CLASS ,                            
                    :BG-CODE-STAT-TAX-XMT  ,                            
                    :BG-CODE-CITY-TAX-XMT  ,                            
                    :BG-CODE-OTHR-TAX-XMT ,                             
                    :BG-CODE-UTIL-TYPE                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
              GO TO 2820-EXIT                                           
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'FETCH'                    TO ABEND-FUNCTION         
CBSI          MOVE 'CSS_BILLING_HDR'          TO TABLE-1                
CBSI          MOVE 'CSS_BILLING_DET'          TO TABLE-2                
CBSI          MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
CBSI          MOVE 'REVENUE_MONTH'            TO TABLE-ELEMENT-3        
              MOVE BI-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE BG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
CBSI          MOVE WS-MAX-REV-MONTH           TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF
           END-IF.                                                      
       2820-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *                                                                         
       2830-CLOSE-UNMTRD-TAX-CSR.                                       
           EXEC SQL                                                     
              CLOSE UNMTRD-TAX-CSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'CLOSE'                    TO ABEND-FUNCTION         
CBSI          MOVE '2830'                     TO ACTIVE-PARAGRAPH       
CBSI          MOVE 'CSS_BILLING_HDR'          TO TABLE-1                
CBSI          MOVE 'CSS_BILLING_DET'          TO TABLE-2                
CBSI          MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
CBSI          MOVE 'REVENUE_MONTH'            TO TABLE-ELEMENT-3        
              MOVE BI-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE BG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
CBSI          MOVE WS-MAX-REV-MONTH           TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       2830-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      * 5110-LOAD-BILLING-DETAILS.                                    *         
      *                                                               *         
      * MOVE BILLING DETAIL FIELDS TO PASSAREA                        *         
      *                                                               *         
      *****************************************************************         
       5110-LOAD-BILLING-DETAILS.                                       
                                                                        
           MOVE BG-ACCOUNT-NO            TO WS-BC-ACCOUNT-NO-BG.        
           MOVE BG-BILL-NO               TO WS-BC-BILL-NO-BG.           
           MOVE BG-CODE-UTIL-TYPE        TO WS-BC-CODE-UTIL-TYPE-BG.    
           MOVE BG-IC-NO                 TO WS-BC-IC-NO-BG.             
           MOVE BG-BILL-ITEM-TIMESTMP    TO WS-BC-BILL-ITEM-TIMESTMP-BG.
           MOVE BG-PREMISE-NO            TO WS-BC-PREMISE-NO-BG.        
TP9609     MOVE LOW-VALUES               TO WS-BC-DATE-ORIG-BILL-BG.    
TP9609     MOVE 'I'                      TO WS-BC-PRORATE-OVERRIDE-IND. 
T22796     MOVE 'A'                      TO WS-BC-CODE-BILL-STATUS-BI.  
           MOVE BG-AMT-BILL-ITEM         TO WS-BC-AMT-BILL-ITEM-BG.     
           MOVE BG-CODE-BILL-CALC        TO WS-BC-CODE-BILL-CALC-BG.    
           MOVE BG-CODE-BILL-ITM-TYPE    TO WS-BC-CODE-BILL-ITM-TYPE-BG.
           MOVE BG-CODE-BILL-ITM-IND     TO WS-BC-CODE-BILL-ITM-IND-BG. 
           MOVE BG-CODE-DR-CR-CNSMPTN    TO WS-BC-CODE-DR-CR-CNSMPTN-BG.
           MOVE BG-AMT-STATE-TAX         TO WS-BC-AMT-STATE-TAX-BG.     
           MOVE BG-AMT-CITY-TAX          TO WS-BC-AMT-CITY-TAX-BG.      
           MOVE BG-AMT-OTHER-TAX         TO WS-BC-AMT-OTHER-TAX-BG.     
           MOVE BG-CODE-REVENUE-CLASS    TO WS-BC-CODE-REVENUE-CLASS-BG.
           MOVE BG-CODE-SIC-NO           TO WS-BC-CODE-SIC-NO-BG.       
                                                                        
           MOVE SPACES                   TO WS-BC-RATE-PLAN-NO-BG       
                                                                        
           IF BG-CODE-UTIL-TYPE = 'E'                                   
              MOVE WS-ELEC-RATE          TO WS-BC-RATE-PLAN-NO-BG       
           ELSE IF BG-CODE-UTIL-TYPE = 'G'                              
              MOVE WS-GAS-RATE           TO WS-BC-RATE-PLAN-NO-BG       
           ELSE IF BG-CODE-UTIL-TYPE = 'U'                              
              MOVE WS-UNMET-RATE         TO WS-BC-RATE-PLAN-NO-BG       
           END-IF
                END-IF
           END-IF.                                                      
                                                                        
           MOVE WS-BC-RATE-PLAN-NO-BG    TO RS-RATE-PLAN-NO.            
T22796     MOVE UT-CODE-CURTAIL-PRTY     TO WS-BC-CODE-CURTAIL-PRTY-BG. 
I00177     MOVE UT-CODE-MTR-READ-FREQ    TO WS-BC-CODE-MTR-READ-FREQ-BG.
           MOVE BG-CODE-STAT-TAX-XMT     TO WS-BC-CODE-STAT-TAX-XMT-BG. 
           MOVE BG-CODE-CITY-TAX-XMT     TO WS-BC-CODE-CITY-TAX-XMT-BG. 
           MOVE BG-CODE-OTHR-TAX-XMT     TO WS-BC-CODE-OTHR-TAX-XMT-BG. 
           MOVE BG-REV-RPT-CD            TO WS-BC-REV-RPT-CD-BG.        
           MOVE BG-STANDBY-COMPLIED      TO WS-BC-STANDBY-COMPLIED-BG.  
           MOVE BG-PRORATE-CD            TO WS-BC-PRORATE-CD-BG.        
           MOVE BG-NEW-RATE-PCT          TO WS-BC-NEW-RATE-PCT-BG.      
           MOVE BG-CODE-SUB-TOTAL        TO WS-BC-CODE-SUB-TOTAL-BG.    
           MOVE BG-TAX-REFUND-CD         TO WS-BC-TAX-REFUND-CD-BG.     
           MOVE BG-COMPANY-NO            TO WS-BC-COMPANY-NO-BG.        
           MOVE BG-DATE-LFTM-HI-DMD      TO WS-BC-DATE-LFTM-HI-DMD-BG.  
           MOVE BG-LFTM-HI-PEAK-DMD      TO WS-BC-LFTM-HI-PEAK-DMD-BG.  
           MOVE BG-REBILL-IND            TO WS-BC-REBILL-IND-BG.        
T23332     MOVE BG-REVENUE-MONTH         TO WS-BC-REV-MTH-ORIG-BILL-BG. 
ACT009*                                                                         
ACT009*CSR:USE CURRENT REVENUE MONTH                                            
ACT009        MOVE WS-CURR-REVENUE-MONTH TO WS-BC-REVENUE-MONTH-BG.     
ACT009*                                                                 19620000
           MOVE BG-GAS-BASE-USE          TO WS-BC-GAS-BASE-USE-BG.      
           MOVE BG-ADJ-REASON-CD         TO WS-BC-ADJ-REASON-CD-BG.     
TP9609     MOVE 0                        TO WS-BC-WNA-FACTOR-BG.        
           MOVE BG-BTU-FACTOR            TO WS-BC-BTU-FACTOR-BG.        
ACT241     IF   BG-RT-PKG-OPT-SEQ-NO = 0                                
ACT241       MOVE UT-RT-PKG-OPT-SEQ-NO                                  
A01848         TO WS-BC-RT-PKG-OPT-SEQ-NO-BG                            
ACT241     ELSE                                                         
A01848       MOVE BG-RT-PKG-OPT-SEQ-NO                                  
ACT241         TO WS-BC-RT-PKG-OPT-SEQ-NO-BG                            
ACT241     END-IF.                                                      
                                                                        
       5110-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 5120-LOAD-MTRD-CNSMPTN.                                       *         
      *                                                               *         
      * MOVE CONSUMPTION HISTORY FIELDS TO PASSAREA                   *         
      *                                                               *         
      *****************************************************************         
       5120-LOAD-MTRD-CNSMPTN.                                          
T28531     IF BG-CODE-UTIL-TYPE = 'E' AND BG-RATE-PLAN-NO  = '005'      
T28531        IF CX-CODE-USAGE-TYPE = 'B' AND                           
T28531           CX-CODE-USAGE-ID = 'A' AND                             
T28531           CX-CODE-USAGE-SOURCE = 'C'                             
T28531           ADD CX-NO-UNITS    TO RS-UNITS                         
T28531        ELSE                                                      
T28531           CONTINUE                                               
T28531        END-IF                                                    
T28531     ELSE                                                         
              ADD CX-NO-UNITS    TO RS-UNITS                            
T28531     END-IF.                                                      
                                                                        
           MOVE BG-ACCOUNT-NO                                           
             TO WS-BC-ACCOUNT-NO-CX (CX-INDX).                          
           MOVE BG-BILL-NO                                              
             TO WS-BC-BILL-NO-CX (CX-INDX).                             
           MOVE BG-CODE-UTIL-TYPE                                       
             TO WS-BC-CODE-UTIL-TYPE-CX (CX-INDX).                      
           MOVE BG-IC-NO                                                
             TO WS-BC-IC-NO-CX (CX-INDX).                               
           MOVE BG-BILL-ITEM-TIMESTMP                                   
             TO WS-BC-BILL-ITEM-TIMESTMP-CX (CX-INDX).                  
           MOVE CX-MTR-REF-NO                                           
             TO WS-BC-MTR-REF-NO-CX (CX-INDX).                          
           MOVE CX-CODE-USAGE-TYPE                                      
             TO WS-BC-CODE-USAGE-TYPE-CX (CX-INDX).                     
           MOVE CX-CODE-USAGE-ID                                        
             TO WS-BC-CODE-USAGE-ID-CX (CX-INDX).                       
           MOVE CX-CODE-USAGE-SOURCE                                    
             TO WS-BC-CODE-USAGE-SOURCE-CX (CX-INDX).                   
           MOVE CX-CODE-TIME-PERIOD                                     
             TO WS-BC-CODE-TIME-PERIOD-CX (CX-INDX).                    
           MOVE CX-ITEM-SEQ-NO                                          
             TO WS-BC-ITEM-SEQ-NO-CX (CX-INDX).                         
           MOVE CX-METER-NO                                             
             TO WS-BC-METER-NO-CX (CX-INDX).                            
           MOVE CX-REG-ID-NO                                            
             TO WS-BC-REG-ID-NO-CX (CX-INDX).                           
           MOVE CX-DATE-READ                                            
             TO WS-BC-DATE-READ-CX (CX-INDX).                           
           MOVE CX-CODE-METER-READ                                      
             TO WS-BC-CODE-METER-READ-CX (CX-INDX).                     
           MOVE CX-CODE-METER-NO-READ                                   
             TO WS-BC-CODE-METER-NO-READ-CX (CX-INDX).                  
           MOVE CX-METER-READING                                        
             TO WS-BC-METER-READING-CX (CX-INDX).                       
           MOVE CX-DEMAND-READING                                       
             TO WS-BC-DEMAND-READING-CX (CX-INDX).                      
           MOVE CX-EMPLOYEE-NO                                          
             TO WS-BC-EMPLOYEE-NO-CX (CX-INDX).                         
           MOVE CX-NO-UNITS                                             
             TO WS-BC-NO-UNITS-CX (CX-INDX).                            
           MOVE CX-NO-DEMAND-UNITS                                      
             TO WS-BC-NO-DEMAND-UNITS-CX (CX-INDX).                     
           MOVE CX-NO-DAYS                                              
             TO WS-BC-NO-DAYS-CX (CX-INDX).                             
           MOVE CX-CODE-SOURCE-ID                                       
             TO WS-BC-CODE-SOURCE-ID-CX (CX-INDX).                      
           MOVE CX-CODE-DEBIT-CREDIT                                    
             TO WS-BC-CODE-DEBIT-CREDIT-CX (CX-INDX).                   
           MOVE CX-CODE-ITEM-STATUS                                     
             TO WS-BC-CODE-ITEM-STATUS-CX (CX-INDX).                    
           MOVE CX-CODE-DISCOUNT                                        
             TO WS-BC-CODE-DISCOUNT-CX (CX-INDX).                       
           MOVE CX-CONSTANT                                             
             TO WS-BC-CONSTANT-CX (CX-INDX).                            
           MOVE CX-NO-DIALS                                             
             TO WS-BC-NO-DIALS-CX (CX-INDX).                            
           MOVE CX-COMPANY-NO                                           
             TO WS-BC-COMPANY-NO-CX (CX-INDX).                          
           MOVE CX-EXCEPT-OVERRIDE-CD                                   
             TO WS-BC-EXCEPT-OVERRIDE-CD-CX (CX-INDX).                  
           MOVE CX-REQUESTED-USAGE                                      
             TO WS-BC-REQUESTED-USAGE-CX (CX-INDX).                     
           MOVE CX-DIGTL-INTRL-MTR-NO                                   
             TO WS-BC-DIGTL-INTRL-MTR-NO-CX (CX-INDX).                  
           MOVE CX-DIGTL-MTR-TYPE                                       
             TO WS-BC-DIGTL-MTR-TYPE-CX (CX-INDX).                      
           MOVE CX-CODE-TOU-SEASN                                       
             TO WS-BC-CODE-TOU-SEASN-CX (CX-INDX).                      
           MOVE CX-EXCL-DMD-RCHT-IND                                    
             TO WS-BC-EXCL-DMD-RCHT-IND-CX (CX-INDX).                   
           MOVE SPACE                                                   
             TO WS-BC-UPDATE-ACTION-IND-CX (CX-INDX).                   
           SET CX-INDX UP BY 1.                                         
           PERFORM 7210-FETCH-CX-CURSOR THRU 7210-EXIT.                 
                                                                        
       5120-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 6000-CALL-BILL-CALC.                                          *         
      *                                                               *         
      * CALL BILL CALCULATION ROUTINE                                 *         
      *                                                               *         
      *****************************************************************         
       6000-CALL-BILL-CALC.                                             
                                                                        
T9127 *    SCSCO107 IS TO BE DONE IN SINGLE RATE MODE                           
T9127      MOVE 'S' TO WS-BC-CALC-MODE.                                 
C33924     INITIALIZE WS-BC-BILL-ADJUSTMNT                              
C34569                WS-BC-ACCT-RTPK-AGR-DF                            
C34569                WS-BC-BILL-DET-BT                                 
P00251                WS-BC-VOL-DAILY-ND                                
P00496                WS-BILL-CALC-DETAIL-X                             
P00496                WS-BILL-BSLN-CNTR-LN                              
P00496                WS-BILL-BSLN-HIST-LO                              
A03959                WS-CNSMPTN-HOURLY                                 
P00496                WS-UTL-BILL-REL-TABLE-UR                          
A04527                WS-BC-FIXED-FCTR-FF.                              
                                                                        
REARCH     CALL MCSCB107 USING   LS-PCSCA100-COMM-AREA                  
REARCH                          , WS-BILLING-CALC-WORK                  
REARCH                          , WS-BILLING-COMPONENT                  
REARCH                          , WS-BILLING-ADJUSTMENT                 
REARCH                          , WS-BILL-CALC-BG                       
REARCH                          , WS-BILL-CALC-CX                       
REARCH                          , WS-BILL-CALC-UC                       
REARCH                          , WS-BILL-CALC-FH                       
REARCH                          , WS-BILL-CONTRACT-BK                   
REARCH                          , WS-FIXED-FCTR-TABLE-FF                
REARCH                          , WS-BILL-CNTR-HIST-BX                  
REARCH                          , WS-PEAK-HIST-PH                       
REARCH                          , WS-INTERRUPT-ACCT-IP                  
REARCH                          , WS-MTRD-ENVRNMT-TABLE-MN              
REARCH                          , WS-STANDBY-GEN-SE                     
REARCH                          , WS-INTERRUPT-IR                       
REARCH                          , WS-HOLD-CX-DATA                       
REARCH                          , WS-HOLD-BC-DATA                       
REARCH                          , WS-HOLD-BA-DATA                       
REARCH                          , WS-BILLING-WQ-ITEMS-WF                
REARCH                          , WS-REFUND-RN                          
REARCH                          , WS-ACCOUNT-AT                         
C33924                          , WS-BC-BILL-ADJUSTMNT                  
C34569                          , WS-BC-ACCT-RTPK-AGR-DF                
C34569                          , WS-BC-FIXED-FCTR-FF                   
I00177                          , WS-BC-BILL-DET-BT                     
I00177                          , WS-CWS22B-MAX-TBL-LIMITS              
P00257                          , WS-BILL-CALC-DETAIL-X                 
P00496                          , WS-BC-VOL-DAILY-ND                    
P00496                          , WS-BILL-BSLN-CNTR-LN                  
P00496                          , WS-BILL-BSLN-HIST-LO                  
P00496                          , WS-UTL-BILL-REL-TABLE-UR              
VKSACT                          , WS-INTERRUPT-NZ                       
P00496                          , WS-CNSMPTN-HOURLY.                    
                                                                        
       6000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 6100-CALCULATE-DATE.                                          *         
      *                                                               *         
      * CALCULATE WS-FROM-DATE AND WS-CURRENT-DATE                    *         
      *                                                               *         
      *****************************************************************         
       6100-CALCULATE-DATE.                                             
           EXEC SQL                                                     
PERTUN        SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE = CURRENT DATE                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
CBSI       MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
CBSI                                                                    
CBSI       IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
CBSI           NEXT SENTENCE                                            
CBSI       ELSE                                                         
CBSI          MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
PERTUN        MOVE 'SET'                       TO ABEND-FUNCTION        
CBSI          MOVE '6100'                      TO ACTIVE-PARAGRAPH      
PERTUN        MOVE SPACES                      TO TABLE-1               
CBSI          MOVE 'PREMISE_NO'                TO TABLE-ELEMENT-1       
CBSI          MOVE PARM-PREMISE-NO             TO HOSTVAR-ELEMENT-1     
CBSI          PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
CBSI          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
CBSI       END-IF.                                                      
P00464     IF PARM-APPL-ID = 'BPAMAINT'                                 
P00464* TO REV MONTH                                                            
P00464        STRING PARM-TO-DATE(1:4) PARM-TO-DATE(6:2)                
P00464               DELIMITED BY SIZE INTO WS-TO-REV-MONTH-C           
P00464        MOVE WS-TO-REV-MONTH-C          TO WS-TO-REV-MONTH        
P00464                                           WS-MAX-REV-MONTH       
P00464* FROM REV MONTH                                                          
P00464        MOVE PARM-FROM-REV-MTH          TO WS-FROM-REV-MONTH-C    
P00464        MOVE WS-FROM-REV-MONTH-C        TO WS-FROM-REV-MONTH      
P00464*                                                                         
P00464        GO TO 6100-EXIT                                           
P00464     END-IF.                                                      
                                                                        
           EXEC SQL                                                     
              SELECT
              DATEADD( MONTH, -2, IIF(TRY_CONVERT(DATE, :PARM-TO-DATE
              ) IS NULL OR (PATINDEX('%.%', :PARM-TO-DATE
              ) <> 0) OR (LEN(:PARM-TO-DATE) <> 10), CIS.CHAR2DATE(
                                                          :PARM-TO-DATE
              ), CONVERT(DATE, :PARM-TO-DATE) ) )
            INTO
              :WS-DATE-3         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-DATE-3 = (DATE(:PARM-TO-DATE) - 2 MONTHS)                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EXEC SQL                                                     
               SELECT MAX(BG.REVENUE_MONTH)                             
                 INTO :WS-TO-REV-MONTH :WS-TO-REV-MONTH-NI              
               FROM CSS_BILLING_HDR   BI WITH(READUNCOMMITTED),                 
                    CSS_BILLING_DET   BG WITH(READUNCOMMITTED)                  
              WHERE BI.PREMISE_NO         = :BI-PREMISE-NO              
                AND BI.PREMISE_NO         = BG.PREMISE_NO               
                AND BI.ACCOUNT_NO         = BG.ACCOUNT_NO               
                AND BG.CODE_BILL_ITM_TYPE = 'C'                         
                AND BG.CODE_BILL_ITM_IND  = 'A'                         
T29768          AND BG.CODE_BILL_CALC     = 'A'                         
                AND BG.CODE_UTIL_TYPE     IN ('E','G','U')              
                AND BI.BILL_NO            = BG.BILL_NO                  
                AND BI.DATE_BILLED  BETWEEN                             
                    IIF(TRY_CONVERT(DATE, :WS-DATE-3
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-3) <> 0) OR (LEN(
                                                             :WS-DATE-3
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-3), CONVERT(DATE, 
                                                             :WS-DATE-3
              ) ) AND IIF(TRY_CONVERT(DATE, :PARM-TO-DATE
              ) IS NULL OR (PATINDEX('%.%', :PARM-TO-DATE
              ) <> 0) OR (LEN(:PARM-TO-DATE) <> 10), CIS.CHAR2DATE(
                                                          :PARM-TO-DATE
              ), CONVERT(DATE, :PARM-TO-DATE) )                        
ACT115          AND BG.REVENUE_MONTH > 0                                
A04527                                                           
A02036                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(BG.REVENUE_MONTH)                                     
MFA-TR*          INTO :WS-TO-REV-MONTH :WS-TO-REV-MONTH-NI                      
MFA-TR*        FROM CSS_BILLING_HDR   BI,                                       
MFA-TR*             CSS_BILLING_DET   BG                                        
MFA-TR*       WHERE BI.PREMISE_NO         = :BI-PREMISE-NO                      
MFA-TR*         AND BI.PREMISE_NO         = BG.PREMISE_NO                       
MFA-TR*         AND BI.ACCOUNT_NO         = BG.ACCOUNT_NO                       
MFA-TR*         AND BG.CODE_BILL_ITM_TYPE = 'C'                                 
MFA-TR*         AND BG.CODE_BILL_ITM_IND  = 'A'                                 
MFA-TR*         AND BG.CODE_BILL_CALC     = 'A'                                 
MFA-TR*         AND BG.CODE_UTIL_TYPE     IN ('E','G','U')                      
MFA-TR*         AND BI.BILL_NO            = BG.BILL_NO                          
MFA-TR*         AND BI.DATE_BILLED  BETWEEN                                     
MFA-TR*             :WS-DATE-3 AND :PARM-TO-DATE                                
MFA-TR*         AND BG.REVENUE_MONTH > 0                                        
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 6100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
CBSI          MOVE 'SELECT'                    TO ABEND-FUNCTION        
CBSI          MOVE '6100'                      TO ACTIVE-PARAGRAPH      
              MOVE 'CSS_BILLING_HDR'           TO TABLE-1               
CBSI          MOVE 'CSS_BILLING_DET'           TO TABLE-2               
CBSI          MOVE 'PREMISE_NO'                TO TABLE-ELEMENT-1       
CBSI          MOVE 'DATE_BILLED'               TO TABLE-ELEMENT-2       
              MOVE BI-PREMISE-NO               TO HOSTVAR-ELEMENT-1     
              MOVE PARM-TO-DATE                TO HOSTVAR-ELEMENT-2     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           IF WS-TO-REV-MONTH-NI < 0                                    
              STRING PARM-TO-DATE(1:4) PARM-TO-DATE(6:2)                
                     DELIMITED BY SIZE INTO WS-TO-REV-MONTH-C           
              MOVE WS-TO-REV-MONTH-C TO WS-TO-REV-MONTH                 
P00464*       IF PARM-APPL-ID = 'BPAMAINT'                                      
P00464*          MOVE 'N'                     TO WS-BPAMAINT-EXISTS             
P00464*          GO TO 6100-EXIT                                                
P00464*       ELSE                                                              
P00464*          STRING PARM-TO-DATE(1:4) PARM-TO-DATE(6:2)                     
P00464*                 DELIMITED BY SIZE INTO WS-TO-REV-MONTH-C                
P00464*          MOVE WS-TO-REV-MONTH-C TO WS-TO-REV-MONTH                      
P00464*       END-IF                                                            
           ELSE                                                         
P00464        MOVE  WS-TO-REV-MONTH TO WS-TO-REV-MONTH-C                
P00464     END-IF.                                                      
           MOVE WS-TO-REV-MONTH-C TO  WS-MAX-REV-MONTH                  
P00464*                                                                         
P00464*    IF PARM-APPL-ID = 'BPAMAINT' AND PARM-FROM-REV-MTH > SPACES          
P00464*       MOVE PARM-FROM-REV-MTH          TO WS-FROM-REV-MONTH-C            
P00464*       MOVE WS-FROM-REV-MONTH-C        TO WS-FROM-REV-MONTH              
P00464*       GO TO 6100-EXIT                                                   
P00464*    END-IF.                                                              
P00464*                                                                         
           STRING WS-TO-REV-MONTH-C(1:4) '-'                            
                  WS-TO-REV-MONTH-C(5:2) '-01'                          
                  DELIMITED BY SIZE INTO WS-MAX-REV-DATE.               
           EXEC SQL                                                     
PERTUN        SELECT
              CAST(DATEADD( MONTH, -11, IIF(TRY_CONVERT(DATE, 
                                                       :WS-MAX-REV-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-MAX-REV-DATE
              ) <> 0) OR (LEN(:WS-MAX-REV-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-MAX-REV-DATE
              ), CONVERT(DATE, :WS-MAX-REV-DATE) ) ) AS CHAR(10))
            INTO
              :WS-MAX-REV-DATE          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-MAX-REV-DATE =                                            
MFA-TR*              CHAR(DATE(:WS-MAX-REV-DATE) -  11 MONTHS)                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
PERTUN        MOVE 'SET'                       TO ABEND-FUNCTION        
CBSI          MOVE '6100'                      TO ACTIVE-PARAGRAPH      
PERTUN        MOVE SPACES                      TO TABLE-1               
CBSI          MOVE 'PREMISE_NO'                TO TABLE-ELEMENT-1       
CBSI          MOVE PARM-PREMISE-NO             TO HOSTVAR-ELEMENT-1     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           STRING WS-MAX-REV-DATE(1:4)                                  
                  WS-MAX-REV-DATE(6:2)                                  
                  DELIMITED BY SIZE INTO WS-FROM-REV-MONTH-C.           
           MOVE WS-FROM-REV-MONTH-C TO WS-FROM-REV-MONTH.               
                                                                        
TP8213 6100-EXIT.                                                       
TP8213     EXIT.                                                        
TP8213                                                                  
      *                                                                         
T13225 6500-LOAD-REV-DISTRICT-CD.                                       
           MOVE BI-PREMISE-NO TO PR-PREMISE-NO.                         
           EXEC SQL                                                     
                 SELECT REV_DISTRICT_CD                                 
                     INTO :WS-REV-DISTRICT-CD                           
                     FROM CSS_PREMISE WITH(READUNCOMMITTED)                     
                  WHERE PREMISE_NO = :PR-PREMISE-NO                     
A02036                                                           
A02036                                                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SELECT REV_DISTRICT_CD                                         
MFA-TR*              INTO :WS-REV-DISTRICT-CD                                   
MFA-TR*              FROM CSS_PREMISE                                           
MFA-TR*           WHERE PREMISE_NO = :PR-PREMISE-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 6500                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
CBSI          MOVE 'SELECT'                    TO ABEND-FUNCTION        
CBSI          MOVE '6500'                      TO ACTIVE-PARAGRAPH      
              MOVE 'CSS_PREMISE'               TO TABLE-1               
CBSI          MOVE 'PREMISE_NO'                TO TABLE-ELEMENT-1       
              MOVE PR-PREMISE-NO               TO HOSTVAR-ELEMENT-1     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       6500-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00694******************************************************************        
P00694*                                                                *        
P00694*  7000-GET-ACCOUNT-DETAILS                                      *        
P00694******************************************************************        
P00694 7000-GET-ACCOUNT-DETAILS.                                        
P00694                                                                  
P00694     EXEC SQL                                                     
P00694        SELECT AT.ACCOUNT_TYPE_CODE                               
P00694          INTO :AT-ACCOUNT-TYPE-CODE                              
P00694          FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
P00694        WHERE  AT.ACCOUNT_NO = :AT-ACCOUNT-NO                     
P00694                                                           
P00694                                                      
P00694     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.ACCOUNT_TYPE_CODE                                       
MFA-TR*         INTO :AT-ACCOUNT-TYPE-CODE                                      
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*       WHERE  AT.ACCOUNT_NO = :AT-ACCOUNT-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00694                                                                  
P00694     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
P00694                                                                  
P00694     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00694        NEXT SENTENCE                                             
P00694     ELSE                                                         
P00694        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00694        MOVE '7000'                    TO ACTIVE-PARAGRAPH        
P00694        MOVE 'SELECT'                  TO ABEND-FUNCTION          
P00694        MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
P00694        MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
P00694        MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
P00694        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
P00694        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
P00694     END-IF.                                                      
P00694                                                                  
P00694 7000-EXIT.                                                       
P00694     EXIT.                                                        
P00694                                                                  
P00694*--------------------------------------------------               33880000
P00694*  GET CX UNITS FOR HISTORY                                       33880000
P00694*--------------------------------------------------               33880000
P00694 7025-GET-HIST-UNITS.                                             
P00694     EXEC SQL                                                     
P00694          SELECT  SUM(CX.NO_UNITS)                                
P00694                 ,SUM(CX.NO_DAYS)                                 
P00694            INTO  :CX-NO-UNITS :WS-NULL-IND1                      
P00694                 ,:CX-NO-DAYS :WS-NULL-IND2                      
P00694            FROM  CSS_CNSMPTN_HIST CX WITH(READUNCOMMITTED)               
P00694          WHERE CX.ACCOUNT_NO     = :BG-ACCOUNT-NO                
P00694            AND CX.BILL_NO        = :BG-BILL-NO                   
P00694            AND ((CX.CODE_UTIL_TYPE      = 'E'                    
P00694                  AND CX.CODE_USAGE_TYPE = 'B') OR                
P00694                 (CX.CODE_UTIL_TYPE      = 'G'                    
P00694                  AND CX.CODE_USAGE_TYPE = 'C'))                  
P00694            AND CX.IC_NO          = :BG-IC-NO                     
P00694            AND CX.BILL_ITEM_TIMESTMP                             
P00694                               = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )           
A04462            AND CODE_USAGE_ID <> 'X'                              
P00694                                                      
P00694                                                           
P00694     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     35540000
MFA-TR*         SELECT  SUM(CX.NO_UNITS)                                08050000
MFA-TR*                ,SUM(CX.NO_DAYS)                                         
MFA-TR*           INTO  :CX-NO-UNITS :WS-NULL-IND1                      08050000
MFA-TR*                ,:CX-NO-DAYS  :WS-NULL-IND2                              
MFA-TR*           FROM  CSS_CNSMPTN_HIST CX                             08050000
MFA-TR*         WHERE CX.ACCOUNT_NO     = :BG-ACCOUNT-NO                08420000
MFA-TR*           AND CX.BILL_NO        = :BG-BILL-NO                   08430000
MFA-TR*           AND ((CX.CODE_UTIL_TYPE      = 'E'                    08440000
MFA-TR*                 AND CX.CODE_USAGE_TYPE = 'B') OR                08440000
MFA-TR*                (CX.CODE_UTIL_TYPE      = 'G'                    08440000
MFA-TR*                 AND CX.CODE_USAGE_TYPE = 'C'))                  08440000
MFA-TR*           AND CX.IC_NO          = :BG-IC-NO                     08450000
MFA-TR*           AND CX.BILL_ITEM_TIMESTMP                             08460000
MFA-TR*                              = :BG-BILL-ITEM-TIMESTMP           08470000
MFA-TR*           AND CODE_USAGE_ID <> 'X'                                      
MFA-TR*          QUERYNO 7025                                                   
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                    33840000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00694                                                                  
P00694                                                                  
P00694     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
P00694                                                                  
P00694     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00694        IF WS-NULL-IND1    = -1                                   
P00694           MOVE ZEROS TO CX-NO-UNITS                              
P00694        END-IF                                                    
P00694        IF WS-NULL-IND2    = -1                                   
P00694           MOVE ZEROS TO CX-NO-DAYS                               
P00694        END-IF                                                    
P00694     ELSE                                                         
P00694        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
P00694        MOVE 'SELECT'                  TO ABEND-FUNCTION          
P00694        MOVE '7025'                    TO ACTIVE-PARAGRAPH        
P00694        MOVE 'CSS_CNSMPTN_HIST'        TO TABLE-1                 
P00694        MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
P00694        MOVE 'BILL_NO'                 TO TABLE-ELEMENT-2         
P00694        MOVE 'IC_NO'                   TO TABLE-ELEMENT-3         
P00694        MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-4         
P00694        MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
P00694        MOVE BG-BILL-NO                TO HOSTVAR-ELEMENT-2       
P00694        MOVE BG-IC-NO                  TO HOSTVAR-ELEMENT-3       
P00694        MOVE BG-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-4       
P00694        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
P00694        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
P00694     END-IF.                                                      
P00694                                                                  
P00694 7025-EXIT.                                                       
P00694     EXIT.                                                        
P00694                                                                  
      ******************************************************************        
      * 7100-OPEN-BI-CURSOR                                            *        
      *                                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     OPEN CURSOR USED TO RETRIVE  CSS_BILLING_HDR               *        
      ******************************************************************        
       7100-OPEN-BI-CURSOR.                                             
                                                                        
           MOVE '7100'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN BI-CURSOR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'CSS_BILLING_HDR '         TO TABLE-1                
CBSI          MOVE 'CSS_BILLING_DET '         TO TABLE-2                
CBSI          MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE 'REVENUE_MONTH'            TO TABLE-ELEMENT-2        
CBSI          MOVE 'REVENUE_MONTH'            TO TABLE-ELEMENT-3        
              MOVE BI-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE WS-FROM-REV-MONTH          TO HOSTVAR-ELEMENT-2      
CBSI          MOVE WS-TO-REV-MONTH            TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7110-FETCH-BI-CURSOR                                           *        
      *                                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     FETCH CURSOR TO RETRIEVE ROW                               *        
      ******************************************************************        
       7110-FETCH-BI-CURSOR.                                            
                                                                        
           MOVE '7110'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH BI-CURSOR                                           
               INTO :BG-REVENUE-MONTH                            ,      
                    :BI-DATE-BILLED :WS-DATE-BILLED-NULL          ,      
                    :BI-CUSTOMER-NO                              ,      
                    :BG-ACCOUNT-NO                               ,      
                    :BG-CODE-UTIL-TYPE                           ,      
                    :BG-AMT-BILL-ITEM                            ,      
                    :BG-BILL-NO                                  ,      
                    :BG-IC-NO                                    ,      
                    :BG-BILL-ITEM-TIMESTMP                       ,      
                    :BG-PREMISE-NO                               ,      
                    :BG-DATE-ORIG-BILL :WS-DATE-ORIG-BILL-NULL    ,      
                    :BG-CODE-BILL-CALC                           ,      
                    :BG-CODE-BILL-ITM-TYPE                       ,      
                    :BG-CODE-BILL-ITM-IND                        ,      
                    :BG-CODE-DR-CR-CNSMPTN                       ,      
                    :BG-AMT-STATE-TAX                            ,      
                    :BG-AMT-CITY-TAX                             ,      
                    :BG-AMT-OTHER-TAX                            ,      
                    :BG-CODE-REVENUE-CLASS                       ,      
                    :BG-CODE-SIC-NO                              ,      
                    :BG-RATE-PLAN-NO                             ,      
                    :BG-CODE-CURTAIL-PRTY                        ,      
                    :BG-CODE-STAT-TAX-XMT                        ,      
                    :BG-CODE-CITY-TAX-XMT                        ,      
                    :BG-CODE-OTHR-TAX-XMT                        ,      
                    :BG-REV-RPT-CD                               ,      
                    :BG-STANDBY-COMPLIED                         ,      
                    :BG-PRORATE-CD                               ,      
                    :BG-NEW-RATE-PCT                             ,      
                    :BG-CODE-SUB-TOTAL                           ,      
                    :BG-TAX-REFUND-CD                            ,      
                    :BG-COMPANY-NO                               ,      
                    :BG-DATE-LFTM-HI-DMD :WS-DATE-LFTM-HI-DMD-NULL,      
                    :BG-LFTM-HI-PEAK-DMD                         ,      
                    :BG-REBILL-IND                               ,      
                    :BG-REV-MTH-ORIG-BILL                        ,      
                    :BG-GAS-BASE-USE                             ,      
                    :BG-ADJ-REASON-CD                            ,      
                    :BG-WNA-FACTOR                               ,      
                    :BG-BTU-FACTOR                               ,      
T13225              :BG-REV-DISTRICT-CD                          ,      
A01848              :BG-RT-PKG-OPT-SEQ-NO                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-DATE-ORIG-BILL-NULL = -1                               
              MOVE SPACES                     TO BG-DATE-ORIG-BILL
           END-IF.     
                                                                        
           IF WS-DATE-BILLED-NULL = -1                                  
              MOVE SPACES                     TO BI-DATE-BILLED
           END-IF.        
                                                                        
           IF WS-DATE-LFTM-HI-DMD-NULL = -1                             
              MOVE SPACES                     TO BG-DATE-LFTM-HI-DMD
           END-IF.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'FETCH'                    TO ABEND-FUNCTION         
CBSI          MOVE 'CSS_BILLING_HDR '         TO TABLE-1                
CBSI          MOVE 'CSS_BILLING_DET '         TO TABLE-2                
CBSI          MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE 'REVENUE_MONTH'            TO TABLE-ELEMENT-2        
CBSI          MOVE 'REVENUE_MONTH'            TO TABLE-ELEMENT-3        
CBSI          MOVE BI-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE WS-FROM-REV-MONTH          TO HOSTVAR-ELEMENT-2      
CBSI          MOVE WS-TO-REV-MONTH            TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
C23415                                                                  
C23415 7115-OPEN-EX-DATA.                                               
C23415     EXEC SQL                                                     
C23415        OPEN TAX-EXCISE-DATA                                      
C23415     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C23415                                                                  
C23415     IF SQLCODE NOT = SUCCESSFUL-CALL                             
C23415        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
C23415        MOVE 'OPEN'                     TO ABEND-FUNCTION         
C23415        MOVE 'CSS_TAX_EXCISE_AMT'       TO TABLE-1                
C23415        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C23415        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C23415     END-IF.                                                      
C23415                                                                  
C23415 7115-EXIT.                                                       
C23415                                                                  
C23415 7116-FETCH-EX-DATA.                                              
C23415     EXEC SQL                                                     
C23415        FETCH TAX-EXCISE-DATA                                     
C23415          INTO :X6-BLOCK-NO,                                      
C23415               :X6-BLOCK-UNITS,                                   
C23415               :X6-DATE-FROM,                                     
C23415               :X6-TAX-CNTRL-NO,                                  
C23415               :X6-EXCISE-TAX-UNIT-AM                             
C23415     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C23415                                                                  
C23415     IF SQLCODE NOT = SUCCESSFUL-CALL AND NOT-FOUND               
C23415        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
C23415        MOVE 'FETCH'                    TO ABEND-FUNCTION         
C23415        MOVE 'CSS_TAX_EXCISE_AMT'       TO TABLE-1                
C23415        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C23415        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C23415     END-IF.                                                      
C23415                                                                  
C23415 7116-EXIT.                                                       
C23415     EXIT.                                                        
C23415                                                                  
C23415 7117-CLOSE-EX-DATA.                                              
C23415     EXEC SQL                                                     
C23415        CLOSE TAX-EXCISE-DATA                                     
C23415     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C23415                                                                  
C23415     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
C23415                                                                  
C23415     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C23415        NEXT SENTENCE                                             
C23415     ELSE                                                         
C23415        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
C23415        MOVE 'CLOSE'                    TO ABEND-FUNCTION         
C23415        MOVE 'CSS_TAX_EXCISE_AMT'       TO TABLE-1                
C23415        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C23415        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C23415     END-IF.                                                      
C23415                                                                  
C23415 7117-EXIT.                                                       
C23415     EXIT.                                                        
                                                                        
HPCCDM*    EJECT                                                                
                                                                        
      ******************************************************************        
      * 7120-CLOSE-BI-CURSOR                                           *        
      *                                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     CLOSE BI-CURSOR                                            *        
      ******************************************************************        
       7120-CLOSE-BI-CURSOR.                                            
                                                                        
           MOVE '7120'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE BI-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'CLOSE'                    TO ABEND-FUNCTION         
CBSI          MOVE 'CSS_BILLING_HDR'          TO TABLE-1                
CBSI          MOVE 'CSS_BILLING_DET '         TO TABLE-2                
CBSI          MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE 'REVENUE_MONTH'            TO TABLE-ELEMENT-2        
CBSI          MOVE 'REVENUE_MONTH'            TO TABLE-ELEMENT-3        
              MOVE BI-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE WS-FROM-REV-MONTH          TO HOSTVAR-ELEMENT-2      
CBSI          MOVE WS-TO-REV-MONTH            TO HOSTVAR-ELEMENT-3      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
HPCCDM*    EJECT                                                                
                                                                        
      ******************************************************************        
      * 7200-OPEN-CX-CURSOR                                            *        
      *                                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     OPEN CURSOR USED TO RETRIVE  CSS_CNSMPTN_HIST              *        
      ******************************************************************        
       7200-OPEN-CX-CURSOR.                                             
                                                                        
           MOVE '7200'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN CX-CURSOR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'CSS_CNSMPTN_HIST'         TO TABLE-1                
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
CBSI          MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
CBSI          MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-4        
              MOVE CX-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE CX-BILL-NO                 TO HOSTVAR-ELEMENT-2      
CBSI          MOVE CX-IC-NO                   TO HOSTVAR-ELEMENT-3      
CBSI          MOVE CX-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7210-FETCH-CX-CURSOR                                           *        
      *                                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     FETCH CURSOR TO RETRIEVE ROW FROM CSS_CNSMPTN_HIST         *        
      ******************************************************************        
       7210-FETCH-CX-CURSOR.                                            
                                                                        
           MOVE '7210'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH CX-CURSOR                                           
               INTO :CX-NO-UNITS                   ,                    
                    :CX-NO-DAYS                    ,                    
                    :CX-MTR-REF-NO                 ,                    
                    :CX-CODE-USAGE-TYPE            ,                    
                    :CX-CODE-USAGE-ID              ,                    
                    :CX-CODE-USAGE-SOURCE          ,                    
                    :CX-CODE-TIME-PERIOD           ,                    
                    :CX-ITEM-SEQ-NO                ,                    
                    :CX-METER-NO                   ,                    
                    :CX-REG-ID-NO                  ,                    
                    :CX-DATE-READ :WS-DATE-READ-NULL,                    
                    :CX-CODE-METER-READ            ,                    
                    :CX-CODE-METER-NO-READ         ,                    
                    :CX-METER-READING              ,                    
                    :CX-DEMAND-READING             ,                    
                    :CX-EMPLOYEE-NO                ,                    
                    :CX-NO-DEMAND-UNITS            ,                    
                    :CX-CODE-SOURCE-ID             ,                    
                    :CX-CODE-DEBIT-CREDIT          ,                    
                    :CX-CODE-ITEM-STATUS           ,                    
                    :CX-CODE-DISCOUNT              ,                    
                    :CX-CONSTANT                   ,                    
                    :CX-NO-DIALS                   ,                    
                    :CX-COMPANY-NO                 ,                    
                    :CX-EXCEPT-OVERRIDE-CD         ,                    
                    :CX-REQUESTED-USAGE            ,                    
                    :CX-DIGTL-INTRL-MTR-NO         ,                    
                    :CX-DIGTL-MTR-TYPE             ,                    
                    :CX-CODE-TOU-SEASN             ,                    
                    :CX-EXCL-DMD-RCHT-IND                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-DATE-READ-NULL = -1                                    
              MOVE SPACES                     TO CX-DATE-READ
           END-IF.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'FETCH'                    TO ABEND-FUNCTION         
CBSI          MOVE 'CSS_CNSMPTN_HIST'         TO TABLE-1                
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
CBSI          MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
CBSI          MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-4        
CBSI          MOVE CX-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE CX-BILL-NO                 TO HOSTVAR-ELEMENT-2      
CBSI          MOVE CX-IC-NO                   TO HOSTVAR-ELEMENT-3      
CBSI          MOVE CX-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
HPCCDM*    EJECT                                                                
                                                                        
      ******************************************************************        
      * 7220-CLOSE-BI-CURSOR                                           *        
      *                                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     CLOSE CX-CURSOR                                            *        
      ******************************************************************        
       7220-CLOSE-CX-CURSOR.                                            
                                                                        
           MOVE '7220'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE CX-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'CLOSE'                    TO ABEND-FUNCTION         
CBSI          MOVE 'CSS_CNSMPTN_HIST'         TO TABLE-1                
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE 'BILL_NO'                  TO TABLE-ELEMENT-2        
CBSI          MOVE 'IC_NO'                    TO TABLE-ELEMENT-3        
CBSI          MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-4        
              MOVE CX-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE CX-BILL-NO                 TO HOSTVAR-ELEMENT-2      
CBSI          MOVE CX-IC-NO                   TO HOSTVAR-ELEMENT-3      
CBSI          MOVE CX-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
HPCCDM*    EJECT                                                                
                                                                        
      *                                                                         
C35040****************************************************************          
C35040* 7710-CHECK-PRIV-ACTIVE                                       *          
C35040****************************************************************          
C35040 7710-CHECK-PRIV-ACTIVE.                                          
C35040                                                                  
C35040     EXEC SQL                                                     
C35040         SELECT TOP(1) 'Y'                                               
C35040           INTO :WS-PVTLT-ACTIVE                                  
C35040           FROM CSS_CUST_PLAN CP WITH(READUNCOMMITTED)                    
C35040               ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
C35040           WHERE CP.ACCOUNT_NO       =  :CP-ACCOUNT-NO            
ACT111             AND CP.CODE_UTIL_TYPE   IN  ('U','E')                
C35040             AND UT.CODE_UTIL_TYPE   =  CP.CODE_UTIL_TYPE         
C35040             AND UT.IC_NO            =  CP.IC_NO                  
C35040             AND UT.ACCOUNT_NO       =  CP.ACCOUNT_NO             
C35040             AND UT.RATE_PLAN_NO     <> '064'                     
C35040             AND CP.CODE_PLAN_STATUS  = 'A'                       
C35040                                       
A02036                                                      
C35040     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-PVTLT-ACTIVE                                          
MFA-TR*          FROM CSS_CUST_PLAN CP                                          
MFA-TR*              ,CSS_UTIL_ENVRNMT UT                                       
MFA-TR*          WHERE CP.ACCOUNT_NO       =  :CP-ACCOUNT-NO                    
MFA-TR*            AND CP.CODE_UTIL_TYPE   IN  ('U','E')                        
MFA-TR*            AND UT.CODE_UTIL_TYPE   =  CP.CODE_UTIL_TYPE                 
MFA-TR*            AND UT.IC_NO            =  CP.IC_NO                          
MFA-TR*            AND UT.ACCOUNT_NO       =  CP.ACCOUNT_NO                     
MFA-TR*            AND UT.RATE_PLAN_NO     <> '064'                             
MFA-TR*            AND CP.CODE_PLAN_STATUS  = 'A'                               
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*      QUERYNO 7710                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C35040                                                                  
C35040     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
C35040                                                                  
C35040     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C35040        CONTINUE                                                  
C35040     ELSE                                                         
C35040        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
C35040        MOVE 'SELECT'                  TO ABEND-FUNCTION          
C35040        MOVE '7710'                    TO ACTIVE-PARAGRAPH        
C35040        MOVE 'CSS_CUST_PLAN'           TO TABLE-1                 
C35040        MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
C35040        MOVE CP-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
C35040        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
C35040        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
C35040     END-IF.                                                      
C35040                                                                  
C35040 7710-EXIT.                                                       
C35040     EXIT.                                                        
ACT111****************************************************************          
ACT111* 7715-CHECK-SHARED-LIGHT                                      *          
ACT111****************************************************************          
ACT111 7715-CHECK-SHARED-LIGHT.                                         
ACT111                                                                  
ACT111     EXEC SQL                                                     
ACT111         SELECT TOP(1) 'Y'                                               
ACT111           INTO :WS-SHARED-LIGHTING-FL                            
ACT111           FROM CSS_CUST_PLAN CP WITH(READUNCOMMITTED)                    
ACT111               ,CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
ACT111           WHERE UT.ACCOUNT_NO       =  :UT-ACCOUNT-NO            
ACT111             AND UT.CODE_UTIL_TYPE   =  :UT-CODE-UTIL-TYPE        
ACT111             AND UT.IC_NO            =  :UT-IC-NO                 
ACT111             AND UT.CODE_UTIL_TYPE   IN  ('E','G')                
ACT111             AND UT.CODE_UTIL_TYPE   =  CP.CODE_UTIL_TYPE         
ACT111             AND UT.IC_NO            =  CP.IC_NO                  
ACT111             AND UT.ACCOUNT_NO       =  CP.ACCOUNT_NO             
ACT212             AND CP.CODE_PLAN_STATUS IN ('A','R')                 
ACT111                                       
ACT111                                                      
ACT111     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-SHARED-LIGHTING-FL                                    
MFA-TR*          FROM CSS_CUST_PLAN CP                                          
MFA-TR*              ,CSS_UTIL_ENVRNMT UT                                       
MFA-TR*          WHERE UT.ACCOUNT_NO       =  :UT-ACCOUNT-NO                    
MFA-TR*            AND UT.CODE_UTIL_TYPE   =  :UT-CODE-UTIL-TYPE                
MFA-TR*            AND UT.IC_NO            =  :UT-IC-NO                         
MFA-TR*            AND UT.CODE_UTIL_TYPE   IN  ('E','G')                        
MFA-TR*            AND UT.CODE_UTIL_TYPE   =  CP.CODE_UTIL_TYPE                 
MFA-TR*            AND UT.IC_NO            =  CP.IC_NO                          
MFA-TR*            AND UT.ACCOUNT_NO       =  CP.ACCOUNT_NO                     
MFA-TR*            AND CP.CODE_PLAN_STATUS IN ('A','R')                         
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*      QUERYNO 7715                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT111                                                                  
ACT111     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
ACT111                                                                  
ACT111     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
ACT111        CONTINUE                                                  
ACT111     ELSE                                                         
ACT111        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
ACT111        MOVE 'SELECT'                  TO ABEND-FUNCTION          
ACT111        MOVE '7715'                    TO ACTIVE-PARAGRAPH        
ACT111        MOVE 'CSS_CUST_PLAN'           TO TABLE-1                 
ACT111        MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
ACT111        MOVE CP-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
ACT111        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
ACT111        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
ACT111     END-IF.                                                      
ACT111                                                                  
ACT111 7715-EXIT.                                                       
ACT111     EXIT.                                                        
PERTUN****************************************************************          
PERTUN* 7720-GET-PRIV-LIT-AMT                                        *          
PERTUN****************************************************************          
PERTUN 7720-GET-PRIV-LIT-AMT.                                           
PERTUN                                                                  
PERTUN     EXEC SQL                                                     
PERTUN         SELECT TOP(1) CASE WHEN REV_MTH_ORIG_BILL > 0                   
PERTUN                     THEN REV_MTH_ORIG_BILL                       
PERTUN                     ELSE REVENUE_MONTH                           
PERTUN                     END AS REVENUE_MONTH,
              SUM(AMT_BILL_ITEM)                                
PERTUN           INTO                                                   
PERTUN                :BG-REVENUE-MONTH                                 
PERTUN              , :BG-AMT-BILL-ITEM                                 
PERTUN           FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)                  
PERTUN           WHERE ACCOUNT_NO     = :BG-ACCOUNT-NO                  
PERTUN             AND RATE_PLAN_NO   <> '064'                          
PERTUN             AND (CODE_UTIL_TYPE = 'U'                            
PERTUN             OR  (CODE_UTIL_TYPE = 'E'                            
PERTUN             AND CIS.SUBSTR3(RATE_PLAN_NO,1,2)                         
PERTUN                            IN ('68','69')))                      
PERTUN             AND CODE_BILL_ITM_TYPE =  'C'                        
PERTUN             AND CODE_BILL_ITM_IND  =  'A'                        
PERTUN             AND REVENUE_MONTH > 0                                
PERTUN            GROUP BY                                              
PERTUN                CASE WHEN REV_MTH_ORIG_BILL > 0                   
PERTUN                     THEN REV_MTH_ORIG_BILL                       
PERTUN                     ELSE REVENUE_MONTH                           
PERTUN                     END                                          
PERTUN            ORDER BY REVENUE_MONTH DESC                           
PERTUN                                       
A02036                                                      
PERTUN     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT                                                           
MFA-TR*               CASE WHEN REV_MTH_ORIG_BILL > 0                           
MFA-TR*                    THEN REV_MTH_ORIG_BILL                               
MFA-TR*                    ELSE REVENUE_MONTH                                   
MFA-TR*                    END AS REVENUE_MONTH                                 
MFA-TR*              ,SUM(AMT_BILL_ITEM)                                        
MFA-TR*          INTO                                                           
MFA-TR*               :BG-REVENUE-MONTH                                         
MFA-TR*             , :BG-AMT-BILL-ITEM                                         
MFA-TR*          FROM CSS_BILLING_DET BG                                        
MFA-TR*          WHERE ACCOUNT_NO     = :BG-ACCOUNT-NO                          
MFA-TR*            AND RATE_PLAN_NO   <> '064'                                  
MFA-TR*            AND (CODE_UTIL_TYPE = 'U'                                    
MFA-TR*            OR  (CODE_UTIL_TYPE = 'E'                                    
MFA-TR*            AND SUBSTR(RATE_PLAN_NO,1,2)                                 
MFA-TR*                           IN ('68','69')))                              
MFA-TR*            AND CODE_BILL_ITM_TYPE =  'C'                                
MFA-TR*            AND CODE_BILL_ITM_IND  =  'A'                                
MFA-TR*            AND REVENUE_MONTH > 0                                        
MFA-TR*           GROUP BY                                                      
MFA-TR*               CASE WHEN REV_MTH_ORIG_BILL > 0                           
MFA-TR*                    THEN REV_MTH_ORIG_BILL                               
MFA-TR*                    ELSE REVENUE_MONTH                                   
MFA-TR*                    END                                                  
MFA-TR*           ORDER BY REVENUE_MONTH DESC                                   
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*      QUERYNO 7720                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PERTUN                                                                  
PERTUN     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
PERTUN                                                                  
PERTUN     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
PERTUN        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
PERTUN          MOVE +000                    TO WS-PRIV-SUM-AMT         
PERTUN        ELSE                                                      
PERTUN          MOVE BG-AMT-BILL-ITEM        TO WS-PRIV-SUM-AMT         
PERTUN                                          RS-NEW-CHARGE           
PERTUN        END-IF                                                    
PERTUN     ELSE                                                         
PERTUN        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
PERTUN        MOVE 'SELECT'                  TO ABEND-FUNCTION          
PERTUN        MOVE '7720'                    TO ACTIVE-PARAGRAPH        
PERTUN        MOVE 'CSS_BILLING_DET'         TO TABLE-1                 
PERTUN        MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
PERTUN        MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
PERTUN        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
PERTUN        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
PERTUN     END-IF.                                                      
PERTUN                                                                  
PERTUN 7720-EXIT.                                                       
PERTUN     EXIT.                                                        
T22202 7730-READ-BILL-WINDOW.                                           
      *                                                                         
T22202     EXEC SQL                                                     
T22202      SELECT MAX(REVENUE_MONTH)                                   
T22202       INTO  :WS-CURR-REVENUE-MONTH :WS-REVENUE-MONTH-NULL         
T22202       FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                         
T22202       WHERE DATE_EXTRACT <= CAST(SYSDATETIMEOFFSET() AS DATE)            
A02036                                                           
A02036                                                      
T22202     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     30631301
MFA-TR*     SELECT MAX(REVENUE_MONTH)                                   30631401
MFA-TR*      INTO  :WS-CURR-REVENUE-MONTH:WS-REVENUE-MONTH-NULL         30631501
MFA-TR*      FROM CSS_BILL_WINDOW                                       30631601
MFA-TR*      WHERE DATE_EXTRACT <= CURRENT DATE                         30631701
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7730                                                       
MFA-TR*    END-EXEC.                                                    30631901

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
T22202     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
T22202     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T22202         NEXT SENTENCE                                            
T22202     ELSE                                                         
T22202        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
T22202        MOVE '7730'              TO ACTIVE-PARAGRAPH              
T22202        MOVE 'SELECT'            TO ABEND-FUNCTION                
T22202        MOVE SPACES              TO ABEND-SQL-PREDICATES          
T22202                                    ABEND-TABLES                  
T22202        MOVE 'CSS_BILL_WINDOW'   TO TABLE-1                       
T22202        MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
T22202        MOVE 'BILL_CYCLE'        TO TABLE-ELEMENT-2               
T22202        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T22202        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
      *                                                                         
T22202 7730-EXIT.                                                       
T22202     EXIT.                                                        
C25786*                                                                         
T22788*************************************************************             
T22788*  READ DELIQUENCY TABLE FOR SCEG / SEB VALUE               *             
T23513*  1 => SCEG OR PSNC                                                      
T22788*  2 => SEB                                                 *             
T22788*************************************************************             
T22788 7740-READ-DELINQUENCY.                                           
T22788*                                                                         
T22788     EXEC SQL                                                     
T22788        SELECT  DELINQ_VALUE                                      
T22788        INTO    :C8-DELINQ-VALUE                                  
T22788        FROM    CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
T22788        WHERE   DELINQ_CD  = :C8-DELINQ-CD                        
P00694          AND   COMPANY_NO = :C8-COMPANY-NO                       
A02036                                                           
A02036                                                      
T22788     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  DELINQ_VALUE                                              
MFA-TR*       INTO    :C8-DELINQ-VALUE                                          
MFA-TR*       FROM    CSS_DELINQUENCY                                           
MFA-TR*       WHERE   DELINQ_CD  = :C8-DELINQ-CD                                
MFA-TR*         AND   COMPANY_NO = :C8-COMPANY-NO                               
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7740                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T22788                                                                  
T22788     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T22788                                                                  
T22788     IF SQLCODE = SUCCESSFUL-CALL                                 
T34569        NEXT SENTENCE                                             
T22788     ELSE                                                         
T22788        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
T23513        MOVE '7740'              TO ACTIVE-PARAGRAPH              
T22788        MOVE 'SELECT'            TO ABEND-FUNCTION                
T22788        MOVE SPACES              TO ABEND-SQL-PREDICATES          
T22788                                    ABEND-TABLES                  
T22788        MOVE 'CSS_DELINQUENCY'   TO TABLE-1                       
T22788        MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
T22788        MOVE 'BILL_CYCLE'        TO TABLE-ELEMENT-2               
T22788        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T22788        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
T22788*                                                                         
T22788 7740-EXIT.                                                       
T22788     EXIT.                                                        
      *                                                                         
T11128****************************************************************          
T11128* 7400-SELECT-UTIL                                             *          
T11128****************************************************************          
T11128                                                                  
T11128 7400-SELECT-UTIL.                                                
T11128                                                                  
T11128     EXEC SQL                                                     
T22796         SELECT  UT.RATE_PLAN_NO, UT.CODE_CURTAIL_PRTY            
P34990                 ,UT.ONERATE_ANNIV_MO                             
P34990                 ,UT.ONERATE_ORIG_MO                              
I00177                 ,UT.CODE_MTR_READ_FREQ                           
ACT241                 ,UT.RT_PKG_OPT_SEQ_NO                            
T22796         INTO    :UT-RATE-PLAN-NO,                                
T22796                 :UT-CODE-CURTAIL-PRTY                            
P34990                 ,:UT-ONERATE-ANNIV-MO                            
P34990                 ,:UT-ONERATE-ORIG-MO                             
I00177                 ,:UT-CODE-MTR-READ-FREQ                          
ACT241                 ,:UT-RT-PKG-OPT-SEQ-NO                           
T11128         FROM    CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                
T11128         WHERE   UT.ACCOUNT_NO     = :UT-ACCOUNT-NO               
T11128         AND     UT.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE           
T11128         AND     UT.IC_NO          = :UT-IC-NO                    
A02036                                                           
A02036                                                      
T11128     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  UT.RATE_PLAN_NO, UT.CODE_CURTAIL_PRTY                    
MFA-TR*                ,UT.ONERATE_ANNIV_MO                                     
MFA-TR*                ,UT.ONERATE_ORIG_MO                                      
MFA-TR*                ,UT.CODE_MTR_READ_FREQ                                   
MFA-TR*                ,UT.RT_PKG_OPT_SEQ_NO                                    
MFA-TR*        INTO    :UT-RATE-PLAN-NO,                                        
MFA-TR*                :UT-CODE-CURTAIL-PRTY                                    
MFA-TR*                ,:UT-ONERATE-ANNIV-MO                                    
MFA-TR*                ,:UT-ONERATE-ORIG-MO                                     
MFA-TR*                ,:UT-CODE-MTR-READ-FREQ                                  
MFA-TR*                ,:UT-RT-PKG-OPT-SEQ-NO                                   
MFA-TR*        FROM    CSS_UTIL_ENVRNMT UT                                      
MFA-TR*        WHERE   UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                       
MFA-TR*        AND     UT.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE                   
MFA-TR*        AND     UT.IC_NO          = :UT-IC-NO                            
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7400                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T11128                                                                  
T11128     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T11128                                                                  
T11128     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T11128                      OR NOT-FOUND                                
T11128         NEXT SENTENCE                                            
T11128     ELSE                                                         
T11128         MOVE SPACES                    TO ABEND-TABLES           
T11128         MOVE SPACES                    TO ABEND-SQL-PREDICATES   
CBSI           MOVE '7400'                    TO ACTIVE-PARAGRAPH       
T11128         MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
CBSI           MOVE 'SELECT'                  TO ABEND-FUNCTION         
CBSI           MOVE 'CSS_UTIL_ENVRNMT'        TO TABLE-1                
CBSI           MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
CBSI           MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2        
CBSI           MOVE 'IC_NO'                   TO TABLE-ELEMENT-3        
CBSI           MOVE UT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
CBSI           MOVE UT-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2      
CBSI           MOVE UT-IC-NO                  TO HOSTVAR-ELEMENT-3      
T11128         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
CBSI           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
T11128     END-IF.                                                      
T11128                                                                  
T11128 7400-EXIT.                                                       
T11128     EXIT.                                                        
                                                                        
                                                                        
T11888****************************************************************          
T11888* 7401-OPEN-BZ-UT-PRIV-CSR                                     *          
T11888****************************************************************          
T11888                                                                  
T11888 7401-OPEN-BZ-UT-PRIV-CSR.                                        
T11888                                                                  
T11888     EXEC SQL                                                     
T11888        OPEN HONK-A-PRVLT-CSR                                     
T11888     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T11888                                                                  
T11888     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T11888                                                                  
T11888     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T11888        NEXT SENTENCE                                             
T11888     ELSE                                                         
T11888        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
CBSI          MOVE '7401'              TO ACTIVE-PARAGRAPH              
CBSI          MOVE 'OPEN'              TO ABEND-FUNCTION                
T11888        MOVE 'CSS_BILL_CALC_DET' TO TABLE-1                       
T11888        MOVE 'CSS_UTIL_ENVRNMT'  TO TABLE-2                       
T11888        MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
T11888        MOVE BG-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
CBSI          MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
CBSI          MOVE BG-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2             
T11888        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T11888        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T11888     END-IF.                                                      
T11888                                                                  
T11888 7401-EXIT.                                                       
T11888     EXIT.                                                        
T11888                                                                  
T11888****************************************************************          
T11888* 7410-FETCH-BZ-UT-PRIV-CSR                                    *          
T11888****************************************************************          
T11888                                                                  
T11888 7410-FETCH-BZ-UT-PRIV-CSR.                                       
T11888     EXEC SQL                                                     
T20983        FETCH HONK-A-PRVLT-CSR                                    
T20983            INTO :BZ-BILL-NO :WS-NULL-IND-HONK,                   
T20983                 :BZ-CODE-UTIL-TYPE,                              
T20983                 :UT-RATE-PLAN-NO,                                
T20983                 :BZ-IC-NO,                                       
T20983                 :BZ-BILLED-COMP-AM,                              
T20983                 :CP-CODE-SERVICE-TYPE                            
T11888     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
T11888     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
T20983     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T20983        IF WS-NULL-IND-HONK < 0                                   
T20983           MOVE NOT-FOUND TO WS-ACTIVE-RETURN-CODE                
T20983        END-IF                                                    
T11888        ADD BZ-BILLED-COMP-AM TO WS-PRIV-SUM-AMT                  
T11888     ELSE                                                         
T20983        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
T20983           CONTINUE                                               
T20983        ELSE                                                      
T20983           MOVE PROGRAM-NAME              TO ABEND-PROGRAM        
T20983           MOVE 'SELECT'                  TO ABEND-FUNCTION       
T20983           MOVE '2600'                    TO ACTIVE-PARAGRAPH     
T20983           MOVE 'CSS_BILL_CALC_DET'       TO TABLE-1              
T20983           MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1      
T20983           MOVE BG-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1    
T20983           PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
T20983           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
T20983        END-IF                                                    
T11888     END-IF.                                                      
      *                                                                         
T11888 7410-EXIT.                                                       
T11888     EXIT.                                                        
      *                                                                         
T11888****************************************************************          
T11888* 7420-CLOSE-BZ-UT-PRIV-CSR                                    *          
T11888****************************************************************          
T11888                                                                  
T11888 7420-CLOSE-BZ-UT-PRIV-CSR.                                       
T11888                                                                  
T11888     EXEC SQL                                                     
T20983        CLOSE HONK-A-PRVLT-CSR                                    
T11888     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T11888                                                                  
T11888     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T11888                                                                  
T11888     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T11888        NEXT SENTENCE                                             
T11888     ELSE                                                         
T11888        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
T11888        MOVE '7420'              TO ACTIVE-PARAGRAPH              
CBSI          MOVE 'CLOSE'             TO ABEND-FUNCTION                
T11888        MOVE 'CSS_BILL_CALC_DET' TO TABLE-1                       
T11888        MOVE 'CSS_UTIL_ENVRNMT'  TO TABLE-2                       
CBSI          MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
CBSI          MOVE BG-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
CBSI          MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
CBSI          MOVE BG-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2             
T11888        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T11888        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T11888     END-IF.                                                      
T11888                                                                  
T11888 7420-EXIT.                                                       
T11888     EXIT.                                                        
T11888****************************************************************          
T11888* 7430-SELECT-PRICE                                            *          
T11888****************************************************************          
T11888                                                                  
T11888 7430-SELECT-PRICE.                                               
T11888                                                                  
T11888     EXEC SQL                                                     
T11888          SELECT     UP.CODE_UTIL_TYPE                            
T11888                   , UP.RATE_PLAN_NO                              
T11888                   , UP.VERSION_NO_CNTRL                          
T11888                   , UP.RATE_ITEM_CODE                            
T11888                   , UP.UM_EQUIP_ID                               
T11888                   , UP.CUST_PER_SERVICE                          
T11888                   , UP.PRICE_PER_SERV                            
T11888            INTO     :UP-CODE-UTIL-TYPE                           
T11888                   , :UP-RATE-PLAN-NO                             
T11888                   , :UP-VERSION-NO-CNTRL                         
T11888                   , :UP-RATE-ITEM-CODE                           
T11888                   , :UP-UM-EQUIP-ID                              
T11888                   , :UP-CUST-PER-SERVICE                         
T11888                   , :UP-PRICE-PER-SERV                           
T11888          FROM       CSS_UNMTR_PLAN  UP WITH(READUNCOMMITTED)             
T11888         WHERE  UP.CODE_UTIL_TYPE    = :UP-CODE-UTIL-TYPE         
T11888           AND  UP.RATE_PLAN_NO      = :UP-RATE-PLAN-NO           
T11888           AND  UP.RATE_ITEM_CODE    = :UP-RATE-ITEM-CODE         
T11888           AND  UP.VERSION_NO_CNTRL  =                            
T11888               ( SELECT MAX(VERSION_NO_CNTRL)                     
T11888                   FROM CSS_RATE_CREATOR RT WITH(READUNCOMMITTED)         
T11888                  WHERE CODE_UTIL_TYPE    = :RT-CODE-UTIL-TYPE    
T11888                    AND RATE_PLAN_NO      = :RT-RATE-PLAN-NO      
T11888                    AND CODE_STATUS       = 'A'                   
T11888                    AND FROM_EFFECTIVE_DT <= 
           CAST(SYSDATETIMEOFFSET() AS DATE)         
T11888              )                                                   
A02036                                                           
A02036                                                      
T11888     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT     UP.CODE_UTIL_TYPE                                    
MFA-TR*                  , UP.RATE_PLAN_NO                                      
MFA-TR*                  , UP.VERSION_NO_CNTRL                                  
MFA-TR*                  , UP.RATE_ITEM_CODE                                    
MFA-TR*                  , UP.UM_EQUIP_ID                                       
MFA-TR*                  , UP.CUST_PER_SERVICE                                  
MFA-TR*                  , UP.PRICE_PER_SERV                                    
MFA-TR*           INTO     :UP-CODE-UTIL-TYPE                                   
MFA-TR*                  , :UP-RATE-PLAN-NO                                     
MFA-TR*                  , :UP-VERSION-NO-CNTRL                                 
MFA-TR*                  , :UP-RATE-ITEM-CODE                                   
MFA-TR*                  , :UP-UM-EQUIP-ID                                      
MFA-TR*                  , :UP-CUST-PER-SERVICE                                 
MFA-TR*                  , :UP-PRICE-PER-SERV                                   
MFA-TR*         FROM       CSS_UNMTR_PLAN  UP                                   
MFA-TR*        WHERE  UP.CODE_UTIL_TYPE    = :UP-CODE-UTIL-TYPE                 
MFA-TR*          AND  UP.RATE_PLAN_NO      = :UP-RATE-PLAN-NO                   
MFA-TR*          AND  UP.RATE_ITEM_CODE    = :UP-RATE-ITEM-CODE                 
MFA-TR*          AND  UP.VERSION_NO_CNTRL  =                                    
MFA-TR*              ( SELECT MAX(VERSION_NO_CNTRL)                             
MFA-TR*                  FROM CSS_RATE_CREATOR RT                               
MFA-TR*                 WHERE CODE_UTIL_TYPE    = :RT-CODE-UTIL-TYPE            
MFA-TR*                   AND RATE_PLAN_NO      = :RT-RATE-PLAN-NO              
MFA-TR*                   AND CODE_STATUS       = 'A'                           
MFA-TR*                   AND FROM_EFFECTIVE_DT <= CURRENT DATE                 
MFA-TR*             )                                                           
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7430                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T11888                                                                  
T11888     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T11888                                                                  
T11888     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T11888        NEXT SENTENCE                                             
T11888     ELSE                                                         
T11888        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
T11888        MOVE '7430'              TO ACTIVE-PARAGRAPH              
CBSI          MOVE 'SELECT'            TO ABEND-FUNCTION                
T11888        MOVE 'CSS_UNMTR_PLAN '   TO TABLE-1                       
CBSI          MOVE 'CSS_RATE_CREATOR'  TO TABLE-2                       
CBSI          MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1               
CBSI          MOVE PARM-PREMISE-NO     TO HOSTVAR-ELEMENT-1             
CBSI          MOVE 'CODE_UTIL-TYPE'    TO TABLE-ELEMENT-2               
CBSI          MOVE RT-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2             
CBSI          MOVE 'RATE_PLAN_NO '     TO TABLE-ELEMENT-3               
CBSI          MOVE RT-RATE-PLAN-NO     TO HOSTVAR-ELEMENT-3             
CBSI          MOVE 'RATE_ITEM_CODE'    TO TABLE-ELEMENT-4               
CBSI          MOVE UP-RATE-ITEM-CODE   TO HOSTVAR-ELEMENT-4             
T11888        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T11888        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T11888     END-IF.                                                      
T11888                                                                  
T11888 7430-EXIT.                                                       
T11888     EXIT.                                                        
T11888                                                                  
T11888                                                                  
T11888****************************************************************          
T11888* 7501-OPEN-CP-UT-SUBD-CSR                                     *          
T10610****************************************************************          
T10610                                                                  
T10610 7501-OPEN-CP-UT-SUBD-CSR.                                        
T10610                                                                  
T10610     EXEC SQL                                                     
T10610        OPEN CP-UT-SUBD-CSR                                       
T10610     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T10610                                                                  
T10610     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T10610                                                                  
T10610     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T10610        NEXT SENTENCE                                             
T10610     ELSE                                                         
T10610        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
CBSI          MOVE '7501'              TO ACTIVE-PARAGRAPH              
CBSI          MOVE 'OPEN'              TO ABEND-FUNCTION                
T10610        MOVE 'CSS_CUST_PLAN  '   TO TABLE-1                       
T10610        MOVE 'CSS_UTIL_ENVRNMT'  TO TABLE-2                       
T10610        MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
T10610        MOVE CP-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
CBSI          MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
CBSI          MOVE CP-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2             
CBSI          MOVE 'CODE_PLAN_STATUS'  TO TABLE-ELEMENT-3               
CBSI          MOVE CP-CODE-PLAN-STATUS TO HOSTVAR-ELEMENT-3             
T10610        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T10610        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T10610     END-IF.                                                      
T10610                                                                  
T10610 7501-EXIT.                                                       
T10610     EXIT.                                                        
T10610                                                                  
T10610****************************************************************          
T10610* 7510-FETCH-CP-UT-SUBD-CSR.                                   *          
T10610****************************************************************          
T10610                                                                  
T10610 7510-FETCH-CP-UT-SUBD-CSR.                                       
T10610                                                                  
T10610     EXEC SQL                                                     
T10610        FETCH CP-UT-SUBD-CSR                                      
T10610         INTO :CP-ACCOUNT-NO                                      
T10610            , :CP-CODE-UTIL-TYPE                                  
T10610            , :CP-IC-NO                                           
T10610            , :CP-RATE-ITEM-CODE                                  
T10610            , :CP-ITEM-SEQ-NO                                     
T10610            , :CP-CODE-SERVICE-TYPE                               
T10610            , :CP-USAGE-FIXED                                     
T10610            , :CP-MTHLY-AMOUNT-FIXED                              
T10610            , :CP-NO-UNITS                                        
T10610            , :UT-RATE-PLAN-NO                                    
T10610            , :UT-PRV-RATE-PLAN-NO                                
T10610     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T10610                                                                  
T10610     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T10610                                                                  
T10610     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
T10610        NEXT SENTENCE                                             
T10610     ELSE                                                         
T10610        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
T10610        MOVE '7510'              TO ACTIVE-PARAGRAPH              
CBSI          MOVE 'FETCH'             TO ABEND-FUNCTION                
T10610        MOVE 'CSS_CUST_PLAN  '   TO TABLE-1                       
T10610        MOVE 'CSS_UTIL_ENVRNMT'  TO TABLE-2                       
T10610        MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
T10610        MOVE CP-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
T10610        MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
T10610        MOVE CP-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2             
T10610        MOVE 'CODE_PLAN_STATUS'  TO TABLE-ELEMENT-3               
T10610        MOVE CP-CODE-PLAN-STATUS TO HOSTVAR-ELEMENT-3             
T10610        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T10610        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T10610     END-IF.                                                      
T10610                                                                  
T10610 7510-EXIT.                                                       
T10610     EXIT.                                                        
T10610                                                                  
T10610****************************************************************          
T10610* 7520-CLOSE-CP-UT-SUBD-CSR                                    *          
T10610****************************************************************          
T10610                                                                  
T10610 7520-CLOSE-CP-UT-SUBD-CSR.                                       
T10610                                                                  
T10610     EXEC SQL                                                     
T10610        CLOSE CP-UT-SUBD-CSR                                      
T10610     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T10610                                                                  
T10610     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T10610                                                                  
T10610     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T10610        NEXT SENTENCE                                             
T10610     ELSE                                                         
T10610        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
T10610        MOVE '7520'              TO ACTIVE-PARAGRAPH              
CBSI          MOVE 'CLOSE'             TO ABEND-FUNCTION                
T10610        MOVE 'CSS_CUST_PLAN  '   TO TABLE-1                       
T10610        MOVE 'CSS_UTIL_ENVRNMT'  TO TABLE-2                       
CBSI          MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
CBSI          MOVE CP-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
CBSI          MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2               
CBSI          MOVE CP-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2             
CBSI          MOVE 'CODE_PLAN_STATUS'  TO TABLE-ELEMENT-3               
CBSI          MOVE CP-CODE-PLAN-STATUS TO HOSTVAR-ELEMENT-3             
T10610        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T10610        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T10610     END-IF.                                                      
T10610                                                                  
T10610 7520-EXIT.                                                       
T10610     EXIT.                                                        
                                                                        
T11798****************************************************************          
T11798* 7500-SELECT-NON-UTIL                                         *          
T11798****************************************************************          
T11798                                                                  
T11798 7500-SELECT-NON-UTIL.                                            
T11798                                                                  
T11798     EXEC SQL                                                     
T11798         SELECT  UT.RATE_PLAN_NO                                  
T11798         INTO    :UT-RATE-PLAN-NO                                 
T11798         FROM    CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED),               
T11798                 CSS_CUST_PLAN    CP WITH(READUNCOMMITTED)                
T11798         WHERE   UT.ACCOUNT_NO       = :UT-ACCOUNT-NO             
T11798         AND     UT.CODE_UTIL_TYPE   = :UT-CODE-UTIL-TYPE         
T11798         AND     UT.IC_NO            = :UT-IC-NO                  
T11798         AND     UT.ACCOUNT_NO       = CP.ACCOUNT_NO              
T11798         AND     UT.CODE_UTIL_TYPE   = CP.CODE_UTIL_TYPE          
T11798         AND     UT.IC_NO            = CP.IC_NO                   
T11798         AND     CP.CODE_PLAN_STATUS = 'A'                        
A02036                                                           
A02036                                                      
T11798     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  UT.RATE_PLAN_NO                                          
MFA-TR*        INTO    :UT-RATE-PLAN-NO                                         
MFA-TR*        FROM    CSS_UTIL_ENVRNMT UT,                                     
MFA-TR*                CSS_CUST_PLAN    CP                                      
MFA-TR*        WHERE   UT.ACCOUNT_NO       = :UT-ACCOUNT-NO                     
MFA-TR*        AND     UT.CODE_UTIL_TYPE   = :UT-CODE-UTIL-TYPE                 
MFA-TR*        AND     UT.IC_NO            = :UT-IC-NO                          
MFA-TR*        AND     UT.ACCOUNT_NO       = CP.ACCOUNT_NO                      
MFA-TR*        AND     UT.CODE_UTIL_TYPE   = CP.CODE_UTIL_TYPE                  
MFA-TR*        AND     UT.IC_NO            = CP.IC_NO                           
MFA-TR*        AND     CP.CODE_PLAN_STATUS = 'A'                                
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7500                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T11798                                                                  
T11798     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T11798                                                                  
T11798     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T11798                      OR NOT-FOUND                                
T11798         NEXT SENTENCE                                            
T11798     ELSE                                                         
T11798         MOVE SPACES                    TO ABEND-TABLES           
T11798         MOVE SPACES                    TO ABEND-SQL-PREDICATES   
T11798         MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
CBSI           MOVE '7500'                    TO ACTIVE-PARAGRAPH       
CBSI           MOVE 'SELECT'                  TO ABEND-FUNCTION         
CBSI           MOVE 'CSS_UTIL_ENVRNMT'        TO TABLE-1                
CBSI           MOVE 'CSS_CUST_PLAN  '         TO TABLE-2                
CBSI           MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1              
CBSI           MOVE UT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1            
CBSI           MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2              
CBSI           MOVE UT-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2            
CBSI           MOVE 'IC_NO'             TO TABLE-ELEMENT-3              
CBSI           MOVE UT-IC-NO            TO HOSTVAR-ELEMENT-3            
T11798         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
CBSI           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
T11798     END-IF.                                                      
T11798                                                                  
T11798 7500-EXIT.                                                       
T11798     EXIT.                                                        
                                                                        
T13225****************************************************************          
       7610-OPEN-TAX-DATA.                                              
           EXEC SQL                                                     
              OPEN TAX-DATA                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
CBSI       MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL                             
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7610'              TO ACTIVE-PARAGRAPH              
CBSI          MOVE 'OPEN'              TO ABEND-FUNCTION                
CBSI          MOVE 'CSS_TAX_CNTL'      TO TABLE-1                       
CBSI          MOVE 'CSS_TAX_RATE'      TO TABLE-2                       
CBSI          MOVE 'CSS_TAX_USE_CNTL'  TO TABLE-3                       
CBSI          MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1               
CBSI          MOVE PARM-PREMISE-NO     TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7610-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7612-FETCH-TAX-DATA.                                             
           EXEC SQL                                                     
              FETCH TAX-DATA                                            
                INTO :TC-TAX-TYPE,                                      
                     :TR-DETAIL-ID,                                     
                     :TR-DATE-FROM,                                     
                     :TR-DATE-TO :WS-NULL-IND,                          
                     :TR-TAX-RATE,                                      
                     :TU-CODE-TAX-CALC-INST,                            
                     :TU-TAX-ELEC,                                      
                     :TU-TAX-GAS,                                       
                     :TU-TAX-MDSE,                                      
                     :TU-TAX-WATER,                                     
                     :TU-TAX-SEWER,                                     
                     :TU-TAX-TRASH,                                     
T20141               :TC-TAX-CNTRL-NO,                                  
T20141               :TC-FACTOR-ID                                      
ACT302              ,:TC-CODE-APPL-COND                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
CBSI       MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL AND NOT-FOUND               
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7612'              TO ACTIVE-PARAGRAPH              
CBSI          MOVE 'FETCH'             TO ABEND-FUNCTION                
CBSI          MOVE 'CSS_TAX_CNTL'      TO TABLE-1                       
CBSI          MOVE 'CSS_TAX_RATE'      TO TABLE-2                       
CBSI          MOVE 'CSS_TAX_USE_CNTL'  TO TABLE-3                       
CBSI          MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1               
CBSI          MOVE PARM-PREMISE-NO     TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7612-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7614-CLOSE-TAX-DATA.                                             
           EXEC SQL                                                     
              CLOSE TAX-DATA                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
CBSI       MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
CBSI       IF SQLCODE NOT = SUCCESSFUL-CALL AND NOT-FOUND               
CBSI          MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
CBSI          MOVE '7614'              TO ACTIVE-PARAGRAPH              
CBSI          MOVE 'CLOSE'             TO ABEND-FUNCTION                
CBSI          MOVE 'CSS_TAX_CNTL'      TO TABLE-1                       
CBSI          MOVE 'CSS_TAX_RATE'      TO TABLE-2                       
CBSI          MOVE 'CSS_TAX_USE_CNTL'  TO TABLE-3                       
CBSI          MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1               
CBSI          MOVE PARM-PREMISE-NO     TO HOSTVAR-ELEMENT-1             
CBSI          PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
CBSI          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
CBSI       END-IF.                                                      
       7614-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7620-GET-DAYS-AT-CURRENT.                                        
           MOVE WS-TR-DATE-FROM (TC-INDX 1) TO WS-DATE-1                
           MOVE WS-BC-CNSMPTN-END-DATE TO WS-DATE-2                     
           EXEC SQL                                                     
PERTUN        SELECT
              CIS.DAYS(IIF(TRY_CONVERT(DATE, :WS-DATE-2
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-2) <> 0) OR (LEN(
                                                             :WS-DATE-2
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-2), CONVERT(DATE, 
                                                             :WS-DATE-2
              ) ))                             
                        - CIS.DAYS(IIF(TRY_CONVERT(DATE, :WS-DATE-1
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-1) <> 0) OR (LEN(
                                                             :WS-DATE-1
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-1), CONVERT(DATE, 
                                                             :WS-DATE-1
              ) ))
            INTO
              :WS-DAYS-AT-CURRENT                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-DAYS-AT-CURRENT =                                         
MFA-TR*              DAYS(DATE(:WS-DATE-2))                                     
MFA-TR*                 - DAYS(DATE(:WS-DATE-1))                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
CBSI       MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF SQLCODE NOT = SUCCESSFUL-CALL                             
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7620'              TO ACTIVE-PARAGRAPH              
PERTUN        MOVE 'SET'               TO ABEND-FUNCTION                
PERTUN        MOVE SPACES              TO TABLE-1                       
CBSI          MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1               
CBSI          MOVE PARM-PREMISE-NO     TO HOSTVAR-ELEMENT-1             
CBSI          MOVE 'WS-DATE-1'         TO TABLE-ELEMENT-2               
CBSI          MOVE WS-DATE-1           TO HOSTVAR-ELEMENT-2             
CBSI          MOVE 'WS-DATE-2'         TO TABLE-ELEMENT-3               
CBSI          MOVE WS-DATE-2           TO HOSTVAR-ELEMENT-3             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7620-EXIT.                                                       
           EXIT.                                                        
       7640-GET-FRAN-TX-XMPTN.                                          
           EXEC SQL                                                     
              SELECT 'Y' INTO :WS-FT-XMPT                               
                FROM CSS_FRNCHS_TX_XMPT WITH(READUNCOMMITTED)                   
                WHERE REV_DISTRICT_CD    = :F2-REV-DISTRICT-CD          
                  AND CODE_REVENUE_CLASS = :F2-CODE-REVENUE-CLASS       
                  AND CODE_UTIL_TYPE     = :F2-CODE-UTIL-TYPE           
                  AND COMPANY_NO         = :F2-COMPANY-NO               
A02036                                                           
A02036                                                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y' INTO :WS-FT-XMPT                                       
MFA-TR*         FROM CSS_FRNCHS_TX_XMPT                                         
MFA-TR*         WHERE REV_DISTRICT_CD    = :F2-REV-DISTRICT-CD                  
MFA-TR*           AND CODE_REVENUE_CLASS = :F2-CODE-REVENUE-CLASS               
MFA-TR*           AND CODE_UTIL_TYPE     = :F2-CODE-UTIL-TYPE                   
MFA-TR*           AND COMPANY_NO         = :F2-COMPANY-NO                       
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7640                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
CBSI       MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE SQLCODE                                             
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                 MOVE 'N' TO WS-FT-XMPT                                 
              WHEN OTHER                                                
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '7640'                TO ACTIVE-PARAGRAPH         
                 MOVE 'SELECT      '        TO ABEND-FUNCTION           
                 MOVE 'CSS_FRNCHS_TX_XMPT'  TO TABLE-1                  
CBSI             MOVE 'REV_DISTRICT_CD'     TO TABLE-ELEMENT-1          
CBSI             MOVE 'CODE_REVENUE_CLASS'  TO TABLE-ELEMENT-2          
CBSI             MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-3          
CBSI             MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-4          
CBSI             MOVE F2-REV-DISTRICT-CD    TO HOSTVAR-ELEMENT-1        
CBSI             MOVE F2-CODE-REVENUE-CLASS TO HOSTVAR-ELEMENT-2        
CBSI             MOVE F2-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-3        
CBSI             MOVE F2-COMPANY-NO         TO HOSTVAR-ELEMENT-4        
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
           END-EVALUATE.                                                
       7640-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7642-GET-STATE-TX-XMPTN.                                         
           EXEC SQL                                                     
              SELECT 'Y' INTO :WS-ST-XMPT                               
                FROM CSS_REVENUE_CLASS WITH(READUNCOMMITTED)                    
                WHERE CODE_REVENUE_CLASS = :F3-CODE-REVENUE-CLASS       
                  AND CODE_UTIL_TYPE     = :F3-CODE-UTIL-TYPE           
                  AND COMPANY_NO         = :F3-COMPANY-NO               
                  AND ST_TAX_XMPT_IND    = 'Y'                          
A02036                                                           
A02036                                                      
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y' INTO :WS-ST-XMPT                                       
MFA-TR*         FROM CSS_REVENUE_CLASS                                          
MFA-TR*         WHERE CODE_REVENUE_CLASS = :F3-CODE-REVENUE-CLASS               
MFA-TR*           AND CODE_UTIL_TYPE     = :F3-CODE-UTIL-TYPE                   
MFA-TR*           AND COMPANY_NO         = :F3-COMPANY-NO                       
MFA-TR*           AND ST_TAX_XMPT_IND    = 'Y'                                  
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7642                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
CBSI       MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE SQLCODE                                             
              WHEN SUCCESSFUL-CALL                                      
                 CONTINUE                                               
              WHEN NOT-FOUND                                            
                 MOVE 'N' TO WS-ST-XMPT                                 
              WHEN OTHER                                                
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE '7642'               TO ACTIVE-PARAGRAPH          
                 MOVE 'SELECT      '       TO ABEND-FUNCTION            
                 MOVE 'CSS_REVENUE_CLASS'  TO TABLE-1                   
CBSI             MOVE 'CODE_REVENUE_CLASS' TO TABLE-ELEMENT-1           
CBSI             MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2           
CBSI             MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-3           
CBSI             MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-4           
CBSI             MOVE F3-CODE-REVENUE-CLASS TO HOSTVAR-ELEMENT-1        
CBSI             MOVE F3-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2         
CBSI             MOVE F3-COMPANY-NO        TO HOSTVAR-ELEMENT-3         
CBSI             MOVE PARM-PREMISE-NO      TO HOSTVAR-ELEMENT-4         
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
           END-EVALUATE.                                                
       7642-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************        
REARCH*8100-SEND-RESULT                                                         
REARCH******************************************************************        
REARCH 8100-SEND-RESULT.                                                
REARCH     EXEC SQL                                                     
REARCH          INSERT INTO #CSR02322_R1                         
REARCH          (                                                       
REARCH               RETURN_CODE                                        
REARCH              ,REVENUE_MONTH                                      
REARCH              ,DAYS                                               
REARCH              ,UNITS                                              
REARCH              ,CODE_UTIL_TYPE                                     
REARCH              ,CUSTOMER_NO                                        
REARCH              ,NEW_CHARGE                                         
REARCH              ,RATE_PLAN_NO                                       
REARCH              ,CALC_ERROR                                         
REARCH              ,HTG_CLG_SW                                         
REARCH              ,EPP_CATEGORY                                       
P00694              ,ELEC_BUFFER                                        
P00694              ,GAS_BUFFER                                         
REARCH          )                                                       
REARCH          VALUES                                                  
REARCH          (                                                       
REARCH               :S-RETURN-CODE                                     
REARCH              ,:S-REVENUE-MONTH                                   
REARCH              ,:S-DAYS                                            
REARCH              ,:S-UNITS                                           
REARCH              ,:S-CODE-UTIL-TYPE                                  
REARCH              ,:S-CUSTOMER-NO                                     
REARCH              ,:S-NEW-CHARGE                                      
REARCH              ,:S-RATE-PLAN-NO                                    
REARCH              ,:S-CALC-ERROR                                      
REARCH              ,:S-HTG-CLG-SW                                      
REARCH              ,:S-EPP-CATEGORY                                    
P00694              ,:S-ELEC-BUFFER                                     
P00694              ,:S-GAS-BUFFER                                      
REARCH          )                                                       
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR02322_R1                                 
MFA-TR*         (                                                               
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,REVENUE_MONTH                                              
MFA-TR*             ,DAYS                                                       
MFA-TR*             ,UNITS                                                      
MFA-TR*             ,CODE_UTIL_TYPE                                             
MFA-TR*             ,CUSTOMER_NO                                                
MFA-TR*             ,NEW_CHARGE                                                 
MFA-TR*             ,RATE_PLAN_NO                                               
MFA-TR*             ,CALC_ERROR                                                 
MFA-TR*             ,HTG_CLG_SW                                                 
MFA-TR*             ,EPP_CATEGORY                                               
MFA-TR*             ,ELEC_BUFFER                                                
MFA-TR*             ,GAS_BUFFER                                                 
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*              :S-RETURN-CODE                                             
MFA-TR*             ,:S-REVENUE-MONTH                                           
MFA-TR*             ,:S-DAYS                                                    
MFA-TR*             ,:S-UNITS                                                   
MFA-TR*             ,:S-CODE-UTIL-TYPE                                          
MFA-TR*             ,:S-CUSTOMER-NO                                             
MFA-TR*             ,:S-NEW-CHARGE                                              
MFA-TR*             ,:S-RATE-PLAN-NO                                            
MFA-TR*             ,:S-CALC-ERROR                                              
MFA-TR*             ,:S-HTG-CLG-SW                                              
MFA-TR*             ,:S-EPP-CATEGORY                                            
MFA-TR*             ,:S-ELEC-BUFFER                                             
MFA-TR*             ,:S-GAS-BUFFER                                              
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
REARCH                                                                  
REARCH     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
REARCH        NEXT SENTENCE                                             
REARCH     ELSE                                                         
REARCH        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
REARCH        MOVE SQLCODE              TO ABEND-SQLCODE                
REARCH        MOVE SQLSTATE             TO ABEND-SQLSTATE               
REARCH        MOVE '8100'               TO ACTIVE-PARAGRAPH             
REARCH        MOVE 'INSERT'             TO ABEND-FUNCTION               
REARCH        MOVE 'CSR02322_R1'        TO TABLE-1                      
REARCH        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
REARCH     END-IF.                                                      
REARCH                                                                  
REARCH     ADD 1 TO CTR-ROWS.                                           
REARCH*                                                                 00002000
REARCH 8100-EXIT.                                                       
REARCH      EXIT.                                                       
REARCH******************************************************************00000100
REARCH* 8000A-DELETE-GTT-ROWS.                                         *00000200
REARCH******************************************************************00000300
REARCH 8000A-DELETE-GTT-ROWS.                                           
REARCH*                                                                 00000500
REARCH     MOVE                                                         
REARCH     'DELETE ROWS'                                                
REARCH         TO S-SQL-STATEMENT-V.                                    
REARCH*                                                                 00000900
REARCH      EXEC SQL                                                    
REARCH          DELETE FROM #CSR02322_R1                         
REARCH      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    00001000
MFA-TR*         DELETE FROM SESSION.CSR02322_R1                         00001100
MFA-TR*     END-EXEC.                                                   00001200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                 00001300
REARCH      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
REARCH*                                                                 00001500
REARCH      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
REARCH          NEXT SENTENCE                                           
REARCH      ELSE                                                        
REARCH         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
REARCH         MOVE SQLCODE              TO ABEND-SQLCODE               
REARCH         MOVE SQLSTATE             TO ABEND-SQLSTATE              
REARCH         MOVE '8000A'              TO ACTIVE-PARAGRAPH            
REARCH         MOVE 'DELETE'             TO ABEND-FUNCTION              
REARCH         MOVE SPACES               TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH         MOVE 'CSR02322_R1'        TO TABLE-1                     
REARCH         MOVE SPACES               TO TABLE-ELEMENT-1             
REARCH         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
REARCH         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
REARCH     END-IF.                                                      
REARCH*                                                                 00003100
REARCH 8000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                 00003400
T13225****************************************************************          
      /                                                                         
HPCCDM*    EJECT                                                                
                                                                        
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
                                                                        
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPD00321                                                  
REARCH     END-EXEC.                                                            
