       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR02320.                                     
COB303 DATE-WRITTEN.      JULY 19, 2005.                                
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
      *                                                                *00110000
      *  TRANID:     S320                                              *00120000
      *  PROGRAM:    S320                                              *00130000
      *  CALLING SP: PA_S320                                           *00140000
      *                                                                *00150000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *  THIS PROCEDURE RETRIEVES LIEAP DATA FOR A SPECIFIC AGENCY.    *00190000
      *  IT RETRIEVES ALL ACCOUNTS WITH EITHER NON-REIMBURSED VOUCHERS *00200000
      *  OR THOSE REIMBURSED WITHIN THE LAST MONTH ASSIGNED TO THE     *00210000
      *  AGENCY PASSED IN AS AN INPUT PARAMETER.                       *00220000
      ******************************************************************00230000
      *                                                                *00240000
      *                     PROGRAM MODIFICATION LOG                   *00250000
      *                                                                *00260000
      *    DATE    INITIALS   COMMENTS                                 *00270000
      *  --------  --------   ---------------------------------------  *00280000
      *  01/30/96    JBW      PROCEDURE ORIGINALLY CODED.              *00290000
      *                                                                *00300000
      *  04/11/96    JBW      PCR189.  CHANGED CHECK_NO FROM CHAR(5)   *00301000
      *                       TO CHAR(9).                              *00302000
      *                                                                *00303000
      *  08/07/96    CSG      TPR5109. ADD CPD0023C TO USE WITH COPYLIB*00304000
      *                       CPD00074.                                *00305000
      *                                                                *00306000
T11573*  06/09/97    TCB      ADDED COMPLETED_BY FIELD TO THE RESULT   *00307000
T11573*                       SET.                                     *00308000
CBSI  *  12/23/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE    *00308100
CBSI  *              MADRAS   ABEND PARAMETERS                         *00308200
      *                                                                *00309000
T19436*  03/16/99    PR       MADE CHG TO RETRIEVE ALL ACCOUNT FOR     *00308100
T19436*                       WHICH THE REIMBURSE OR NON-REIMBURSE     *00308200
      *                       WAS MADE WITH IN THREE MONTH (90 DAYS).  *00309000
T23475*  02/19/01    SFH/LEF  ADDED COMMENT (CONTACT) FROM CSS_LIEAP TO*        
      *                       DATAWINDOW ON PANEL 379.                 *        
      *                       ALSO ADDED COLOR_FLAG TO RPC             *        
REARCH*  07/19/05    CVNS     RPC TO COBOL SP CONVERSION               *        
REARCH*              CHENNAI                                           *        
T30955*  10/05/05    LAT      FETCH 12 NONTHS DATA INSTEAD OF 90 DAYS  *        
      ******************************************************************00310000
      ******************************************************************00320000
      *                                                                *00330000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00340000
      *                                                                *00350000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00360000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00370000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00380000
      *  3000 - 4999  NOT USED                                         *00390000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00400000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00410000
      *  7000 - 7999  INPUT MODULES                                    *00420000
      *  8000 - 8999  OUTPUT MODULES                                   *00430000
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES            *00440000
      *                                                                *00450000
      ******************************************************************00460000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02320'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02320 STARTS HERE'.                  
                                                                        
      ******************************************************************00550000
      *    DB2 INCLUDES                                                *00560000
      ******************************************************************00570000
      *                                                                 00580000
           EXEC SQL                                                     00590000
              INCLUDE SQLCA                                             00600000
           END-EXEC.                                                    00610000
      *                                                                 00620000
           EXEC SQL                                                     00981000
              INCLUDE TBLIEAP                                           00982000
           END-EXEC.                                                    00983000
      *                                                                 00983100
           EXEC SQL                                                     00983200
              INCLUDE TBMODEL                                           00983300
           END-EXEC.                                                    00983400
      *                                                                 00983500
           EXEC SQL                                                     00983600
              INCLUDE TBNAME                                            00983700
           END-EXEC.                                                    00983800
      *                                                                 00983900
           EXEC SQL                                                     00984000
              INCLUDE TBNMACTX                                          00984100
           END-EXEC.                                                    00984200
      *                                                                 00984300
           EXEC SQL                                                     00984400
              INCLUDE TBCSADRX                                          00984500
           END-EXEC.                                                    00984600
      *                                                                 00984700
           EXEC SQL                                                     00984800
              INCLUDE TBADRFRE                                          00984900
           END-EXEC.                                                    00985000
      *                                                                 00985100
           EXEC SQL                                                     00985200
              INCLUDE TBADRFMT                                          00985300
           END-EXEC.                                                    00985400
      *                                                                 00985500
           EXEC SQL                                                     00985600
              INCLUDE TBZIPCD                                           00985700
           END-EXEC.                                                    00985800
      *                                                                 00985900
           EXEC SQL                                                     00986000
              INCLUDE TBCUST                                            00986100
           END-EXEC.                                                    00986200
      *                                                                 00986300
           EXEC SQL                                                     00986400
              INCLUDE TBACCT                                            00986500
           END-EXEC.                                                    00986600
      *                                                                 00987000
TP5109     EXEC SQL                                                     00988000
TP5109        INCLUDE TBATMISC                                          00989000
TP5109     END-EXEC.                                                    00989100
      *                                                                 00989200
      *                                                                 00990000
      ******************************************************************01000000
      *    COBOL WORKING STORAGE COPY BOOKS                            *01010000
      ******************************************************************01020000
                                                                        
REARCH*    COPY SYGWCOB.                                                01040000
REARCH*    COPY SYDBCOB.                                                01050000
           COPY CCA00001.                                               01060000
REARCH*    COPY CWS00010.                                               01070000
           COPY CWS00027.                                               01080000
           COPY CWS00303.                                               01090000
           COPY CWS00074.                                               01110000
           COPY CWS00011.                                               01120000
      *                                                                 01180000
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CWSX0010                                                 
REARCH     END-EXEC.                                                            
                                                                        
      ******************************************************************01200000
      *    WORK AREAS                                                  *01210000
      ******************************************************************01220000
                                                                        
REARCH*01  GW-LIB-MISC-FIELDS.                                          01240000
REARCH*    05  GWL-PROC                   POINTER.                      01250000
REARCH*    05  GWL-INIT-HANDLE            POINTER.                      01260000
REARCH*    05  GWL-RC                     PIC S9(9) COMP.               01270000
REARCH*    05  GWL-STATUS-NR              PIC S9(9) COMP.               01280000
REARCH*    05  GWL-STATUS-DONE            PIC S9(9) COMP.               01290000
REARCH*    05  GWL-STATUS-COUNT           PIC S9(9) COMP.               01300000
REARCH*    05  GWL-STATUS-COMM            PIC S9(9) COMP.               01310000
REARCH*    05  GWL-STATUS-RETURN-CODE     PIC S9(9) COMP.               01320000
REARCH*    05  GWL-STATUS-SUBCODE         PIC S9(9) COMP.               01330000
REARCH*                                                                         
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  GTT-NAME                PIC X(26)                        
REARCH                                     VALUE 'SESSION.CSR02320_R1'. 
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN          PIC S9(04) COMP.                 
REARCH         49 GTT-ROW-CHAR         PIC X(1024).                     
REARCH     05  GTT-SQLCODE             PIC S9(9) COMP.                  
                                                                        
       01  FILLER                         PIC X(11) VALUE 'PARM FIELDS'.
                                                                        
REARCH*01  PARM-FIELDS.                                                 01370000
REARCH*    05  PARM-L                     PIC S9(9) COMP.               01380000
REARCH*    05  PARM-ID1                   PIC S9(9) COMP VALUE 0.       01390000
REARCH*    05  PARM-CODE-AGENCY-ID        PIC X(5)  VALUE SPACES.       01400000
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                   PIC S9(9) COMP.               
           05  SNA-CONNECTION-NAME        PIC X(8)  VALUE SPACES.       
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                 PIC S9(9) COMP VALUE 0.       
           05  CTR-ROWS                   PIC S9(9) COMP VALUE 0.       
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM            PIC S9(9) COMP.               
           05  WRKLEN1                    PIC S9(9) COMP.               
           05  WRKLEN2                    PIC S9(9) COMP.               
           05  WRK-DONE-STATUS            PIC S9(9) COMP.               
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
      *                                                                 01570000
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE             PIC S9(09)    COMP VALUE 0.   
           05  RS-ACCOUNT-DATA.                                         
               10 RS-REIMBURSE-DT.                                      
                  15 RS-REI-MM            PIC X(02)     VALUE SPACES.   
                  15 RS-REI-FILLER-1      PIC X(01)     VALUE SPACES.   
                  15 RS-REI-DD            PIC X(02)     VALUE SPACES.   
                  15 RS-REI-FILLER-2      PIC X(01)     VALUE SPACES.   
                  15 RS-REI-YYYY          PIC X(04)     VALUE SPACES.   
               10 RS-CHECK-NO             PIC X(9)      VALUE SPACES.   
               10 RS-ACCOUNT-NO           PIC X(13)     VALUE SPACES.   
               10 RS-NAME                 PIC X(50)     VALUE SPACES.   
               10 RS-VOUCHER-AMT          PIC S9(7)V99                  
                                                 COMP-3 VALUE +0.       
               10 RS-VOUCHER-PAY-DT.                                    
                  15 RS-ENT-MM            PIC X(02)     VALUE SPACES.   
                  15 FILLER               PIC X         VALUE '/'.      
                  15 RS-ENT-DD            PIC X(02)     VALUE SPACES.   
                  15 FILLER               PIC X         VALUE '/'.      
                  15 RS-ENT-YYYY          PIC X(04)     VALUE SPACES.   
               10 RS-INITIATED-BY         PIC X(7)      VALUE SPACES.   
               10 RS-VOUCHER-PAY-TS       PIC X(26)     VALUE SPACES.   
T11573         10 RS-COMPLETED-BY         PIC X(7)      VALUE SPACES.   
               10 RS-COLOR-FLAG           PIC X(01)     VALUE 'N'.      
T23475         10 RS-COMMENT              PIC X(25)     VALUE SPACES.   
      *                                                                 01900000
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE             PIC S9(09)    COMP VALUE 0.    
REARCH     05  S-REIMBURSE-DT            PIC X(10)     VALUE SPACES.    
REARCH     05  S-CHECK-NO                PIC X(9)      VALUE SPACES.    
REARCH     05  S-ACCOUNT-NO              PIC X(13)     VALUE SPACES.    
REARCH     05  S-NAME                    PIC X(50)     VALUE SPACES.    
REARCH     05  S-VOUCHER-AMT             PIC S9(7)V99                   
REARCH                                            COMP-3 VALUE +0.      
REARCH     05  S-VOUCHER-PAY-DT          PIC X(10)     VALUE SPACES.    
REARCH     05  S-INITIATED-BY            PIC X(7)      VALUE SPACES.    
REARCH     05  S-VOUCHER-PAY-TS          PIC X(26)     VALUE SPACES.    
REARCH     05  S-COMPLETED-BY            PIC X(7)      VALUE SPACES.    
REARCH     05  S-COLOR-FLAG              PIC X(01)     VALUE 'N'.       
REARCH     05  S-COMMENT                 PIC X(25)     VALUE SPACES.    
REARCH*                                                                         
REARCH*01  CN-COLUMN-NAMES.                                             01910000
REARCH*    05 CN-RETURN-CODE              PIC X(11) VALUE               01911000
REARCH*                                   'RETURN_CODE'.                01912000
REARCH*    05 CN-REIMBURSE-DT             PIC X(12) VALUE               01913000
REARCH*                                   'REIMBURSE_DT'.               01914000
REARCH*    05 CN-CHECK-NO                 PIC X(11) VALUE               01915000
REARCH*                                   'CHECK_NO'.                   01916000
REARCH*    05 CN-ACCOUNT-NO               PIC X(11) VALUE               01920000
REARCH*                                   'ACCOUNT_NO'.                 01930000
REARCH*    05 CN-NAME                     PIC X(11) VALUE               01931000
REARCH*                                   'NAME'.                       01932000
REARCH*    05 CN-VOUCHER-AMT              PIC X(11) VALUE               01940000
REARCH*                                   'VOUCHER_AMT'.                01950000
REARCH*    05 CN-VOUCHER-PAY-DT           PIC X(14) VALUE               01960000
REARCH*                                   'VOUCHER_PAY_DT'.             01970000
REARCH*    05 CN-INITIATED-BY             PIC X(12) VALUE               01980000
REARCH*                                   'INITIATED_BY'.               01990000
REARCH*    05 CN-VOUCHER-PAY-TS           PIC X(14) VALUE               02040000
REARCH*                                   'VOUCHER_PAY_TS'.             02050000
T11573*    05 CN-COMPLETED-BY             PIC X(12) VALUE               02301001
T11573*                                   'COMPLETED_BY'.               02302000
T23475*    05 CN-COLOR-FLAG               PIC X(10) VALUE               02301001
T23475*                                   'COLOR_FLAG'.                 02302000
T23475*    05 CN-COMMENT                  PIC X(07) VALUE               02301001
T23475*                                   'COMMENT'.                    02302000
      *                                                                 02303000
      *                                                                 02310000
       01  WS-PROGRAM-NAME.                                             
REARCH     05  PROGRAM-NAME               PIC X(08) VALUE 'CSR02320'.   
REARCH*                                                                         
REARCH 01  WS-MISC.                                                     
REARCH     05  WS-SQLSTATE                PIC X(05).                    
REARCH*                                                                         
       01  WS-COMMENT-LEN                 PIC 9(04) COMP.               
      *                                                                 02340000
       01  SWITCHES.                                                    
           05  ALL-DONE-SW                PIC X(01) VALUE 'N'.          
               88 NOT-ALL-DONE                      VALUE 'N'.          
               88 ALL-DONE                          VALUE 'Y'.          
           05  SEND-DONE-SW               PIC X(01) VALUE 'Y'.          
               88 SEND-DONE-ERROR                   VALUE 'N'.          
               88 SEND-DONE-OK                      VALUE 'Y'.          
      *                                                                 02420000
                                                                        
       01  STORAGE-FIELDS.                                              
      *    05  WS-PARM-FIELDS.                                          02450000
      * USED FOR CONVERTING PARM FIELD DATA TYPES.                      02460000
           05  WS-ACCOUNT-EDITS.                                        
               10 WS-ACCOUNT-NO.                                        
                  15 WS-ACCOUNT-NO-N      PIC 9(13).                    
           05  WS-DATE-EDITS.                                           
               10 WS-DB2-DATE.                                          
                  15 WS-DB2-YYYY          PIC X(04).                    
                  15 FILLER               PIC X.                        
                  15 WS-DB2-MM            PIC X(02).                    
                  15 FILLER               PIC X.                        
                  15 WS-DB2-DD            PIC X(02).                    
               10 WS-HOLD-DATE            PIC X(10).                    
               10 WS-DATE-30-DAYS-AGO     PIC X(10).                    
T30955         10 WS-DATE-12-MONS-AGO     PIC X(10).                    
           05  CONSTANTS.                                               
               10 WS-YES                  PIC X(10) VALUE 'Y'.          
               10 WS-SLASH                PIC X(10) VALUE '/'.          
               10 WS-NEG1                 PIC S9(04) COMP VALUE -1.     
           05  NULL-INDICATORS.                                         
               10 IND-REIMBURSE-DT        PIC S9(04) COMP VALUE +0.     
      *                                                                 02680000
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
REARCH     10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
REARCH     10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
REARCH     10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
REARCH         49  S-HOST-VARIABLES-V  PIC X(255).                      
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-STATEMENT-V   PIC X(255).                      
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-DESCRIPTION-V PIC X(255).                      
REARCH*                                                                         
      ******************************************************************02690000
      *                   LIEAP CURSOR                                 *02700000
      ******************************************************************02710000
      *                                                                 02720000
           EXEC SQL                                                     
               DECLARE LIEAP-CURSOR CURSOR FOR                          
                  SELECT LI.ACCOUNT_NO,                                 
                         LI.VOUCHER_AMT,                                
                         REPLACE(REPLACE(CONVERT(CHAR(26), 
           LI.VOUCHER_PAY_DT, 121), ' ', '-'), ':', '.') 
           VOUCHER_PAY_DT,                             
                         LI.INITIATED_BY,                               
                         LI.REIMBURSE_DT,                               
T11573                   LI.CHECK_NO,                                   
T11573                   LI.COMPLETED_BY,                               
T23475                   LI.COMMENT                                     
                    FROM CSS_LIEAP LI                                   
                   WHERE LI.CODE_AGENCY_ID = :LI-CODE-AGENCY-ID         
                     AND (LI.REIMBURSE_DT IS NULL                       
T30955                OR LI.REIMBURSE_DT > IIF(TRY_CONVERT(DATE, 
                                                   :WS-DATE-12-MONS-AGO
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-12-MONS-AGO
              ) <> 0) OR (LEN(:WS-DATE-12-MONS-AGO
              ) <> 10), CIS.CHAR2DATE(:WS-DATE-12-MONS-AGO
              ), CONVERT(DATE, :WS-DATE-12-MONS-AGO) ))        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     02730000
MFA-TR*        DECLARE LIEAP-CURSOR CURSOR FOR                          02740000
MFA-TR*           SELECT LI.ACCOUNT_NO,                                 02750000
MFA-TR*                  LI.VOUCHER_AMT,                                02752000
MFA-TR*                  LI.VOUCHER_PAY_DT,                             02753000
MFA-TR*                  LI.INITIATED_BY,                               02754000
MFA-TR*                  LI.REIMBURSE_DT,                               02755000
MFA-TR*                  LI.CHECK_NO,                                   02756000
MFA-TR*                  LI.COMPLETED_BY,                               02757000
MFA-TR*                  LI.COMMENT                                             
MFA-TR*             FROM CSS_LIEAP LI                                   02760000
MFA-TR*            WHERE LI.CODE_AGENCY_ID = :LI-CODE-AGENCY-ID         02770000
MFA-TR*              AND (LI.REIMBURSE_DT IS NULL                       02780000
MFA-TR*               OR LI.REIMBURSE_DT > :WS-DATE-12-MONS-AGO)        02781000
MFA-TR*    END-EXEC.                                                    02810000
      *                                                                 02820000
      *                                                                 02830000
HPCCDM*EJECT                                                            02840000
      *                                                                 02850000
      *                                                                 02860000
REARCH LINKAGE SECTION.                                                 
REARCH*                                                                         
REARCH 01  PARM-CODE-AGENCY-ID     PIC X(05).                           
REARCH*                                                                         
REARCH PROCEDURE DIVISION USING PARM-CODE-AGENCY-ID.                    
      *                                                                 02880000
      *                                                                 02890000
      ******************************************************************02900000
      * 0000-MAINLINE                                                  *02910000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *02920000
      ******************************************************************02930000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT.             
REARCH*    PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT.             02980000
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT.             
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT.             
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03050000
      * 0100-INITIALIZE                                                *03060000
      *                                                                *03070000
      *     1. RESET DB2 ERROR HANDLERS                                *03080000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *03090000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *03100000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*03110000
      *                                                                *03120000
      ******************************************************************03130000
                                                                        
       0100-INITIALIZE.                                                 
      *                                                                 03160000
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
REARCH*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.     03210000
REARCH*                                                                 03220000
REARCH*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,     03230000
REARCH*                          SNA-CONNECTION-NAME, SNA-SUBC.         03240000
REARCH*                                                                 03250000
REARCH*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                      03260000
REARCH*                                                                 03270000
REARCH*    IF GWL-RC NOT = TDS-PARM-PRESENT                             03280000
REARCH*        MOVE PROGRAM-NAME         TO ABEND-PROGRAM               03290000
REARCH*        MOVE '0100'               TO ACTIVE-PARAGRAPH            03300000
REARCH*        MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION     03310000
REARCH*        MOVE 'CICS TRANSACTION'   TO TABLE-1                     03320000
REARCH*        MOVE GWL-RC               TO WS-ACTIVE-RETURN-CODE       03330000
REARCH*        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT         03340000
REARCH*        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT         03350000
REARCH*    END-IF.                                                      03360000
REARCH*                                                                         
REARCH     PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT  RETURN_CODE                                      
REARCH                ,LTRIM(RTRIM(REIMBURSE_DT)) AS REIMBURSE_DT              
REARCH                ,LTRIM(RTRIM(CHECK_NO))     AS CHECK_NO                  
REARCH                ,ACCOUNT_NO                                       
REARCH                ,LTRIM(RTRIM(NAME))         AS NAME                      
REARCH                ,VOUCHER_AMT                                      
REARCH                ,VOUCHER_PAY_DT                                   
REARCH                ,INITIATED_BY                                     
REARCH                ,VOUCHER_PAY_TS                                   
REARCH                ,LTRIM(RTRIM(COMPLETED_BY)) AS COMPLETED_BY              
REARCH                ,COLOR_FLAG                                       
REARCH                ,LTRIM(RTRIM(COMMENT))      AS COMMENT                   
REARCH         FROM                                                     
REARCH             #CSR02320_R1                                  
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT  RETURN_CODE                                              
MFA-TR*               ,STRIP(REIMBURSE_DT) AS REIMBURSE_DT                      
MFA-TR*               ,STRIP(CHECK_NO)     AS CHECK_NO                          
MFA-TR*               ,ACCOUNT_NO                                               
MFA-TR*               ,STRIP(NAME)         AS NAME                              
MFA-TR*               ,VOUCHER_AMT                                              
MFA-TR*               ,VOUCHER_PAY_DT                                           
MFA-TR*               ,INITIATED_BY                                             
MFA-TR*               ,VOUCHER_PAY_TS                                           
MFA-TR*               ,STRIP(COMPLETED_BY) AS COMPLETED_BY                      
MFA-TR*               ,COLOR_FLAG                                               
MFA-TR*               ,STRIP(COMMENT)      AS COMMENT                           
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR02320_R1                                          
MFA-TR*    END-EXEC.                                                            
      *                                                                 03370000
      *                                                                 03380000
       0100-EXIT.                                                       
           EXIT.                                                        
REARCH*                                                                         
REARCH******************************************************************03410000
REARCH* 0100A-DECLARE-GTT                                              *        
REARCH******************************************************************        
REARCH*                                                                         
REARCH 0100A-DECLARE-GTT.                                               
REARCH                                                                  
REARCH     MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR02320_R1'            
REARCH                                   TO S-SQL-STATEMENT-V.          
REARCH     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02320_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02320_R1
              (                                                       
REARCH              RETURN_CODE          INT                        
REARCH             ,REIMBURSE_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH             ,CHECK_NO CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH             ,ACCOUNT_NO CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH             ,NAME CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2              
REARCH             ,VOUCHER_AMT          DECIMAL(9,2)                   
REARCH             ,VOUCHER_PAY_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH             ,INITIATED_BY CHAR(07)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH             ,VOUCHER_PAY_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH             ,COMPLETED_BY CHAR(07)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                       
REARCH             ,COLOR_FLAG CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH             ,COMMENT CHAR(25)  COLLATE LATIN1_GENERAL_100_BIN2           
REARCH          )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH     MOVE SQLSTATE                 TO WS-SQLSTATE.                
REARCH     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
REARCH     IF WS-SQLSTATE = '42710'                                     
REARCH        PERFORM 8000A-DELETE-GTT-ROWS                             
REARCH                                        THRU 8000A-EXIT           
REARCH     ELSE                                                         
REARCH       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
REARCH          NEXT SENTENCE                                           
REARCH       ELSE                                                       
REARCH          MOVE PROGRAM-NAME       TO ABEND-PROGRAM                
REARCH          MOVE SQLCODE            TO ABEND-SQLCODE                
REARCH          MOVE SQLSTATE           TO ABEND-SQLSTATE               
REARCH          MOVE '0100A'            TO ACTIVE-PARAGRAPH             
REARCH          MOVE 'DECLARE GTT'      TO ABEND-FUNCTION               
REARCH          MOVE SPACES             TO ABEND-SQL-PREDICATES         
REARCH                                     ABEND-TABLES                 
REARCH          MOVE 'CSR02320_R1'      TO TABLE-1                      
REARCH          MOVE SPACES             TO TABLE-ELEMENT-1              
REARCH          MOVE SPACES             TO HOSTVAR-ELEMENT-1            
REARCH          PERFORM 9900-SQL-ERROR-ROUTINE                          
REARCH                                  THRU  9900-EXIT                 
REARCH       END-IF                                                     
REARCH     END-IF.                                                      
REARCH 0100A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
      ******************************************************************03420000
      * 1000-PROCESS-INPUT                                             *03430000
      *                                                                *03440000
      *     1. RECEIVE PARMS.                                          *03450000
      *     2. ASSIGNS PARMS TO WORKING STORAGE.                       *03460000
      *                                                                *03470000
      ******************************************************************03480000
REARCH*                                                                 03490000
REARCH*1000-PROCESS-INPUT.                                              03500000
REARCH*    MOVE '1000'                        TO ACTIVE-PARAGRAPH.      03510000
      *                                                                 03520000
REARCH*    PERFORM 1100-RECEIVE-PARMS            THRU 1100-EXIT.        03540000
CBSI  *    PERFORM 1150-ASSIGN-WS-VARS           THRU 1150-EXIT.        03550001
REARCH*                                                                 03560000
REARCH*1000-EXIT.                                                       03570000
REARCH*    EXIT.                                                        03580000
      *                                                                 03591000
      *                                                                 03592000
      ******************************************************************03600000
      * 1100-RECEIVE-PARMS                                             *03610000
      *                                                                *03620000
      *     RECEIVE EACH PARAMETER FROM THE REMOTE PROCEDURE           *03630000
      *                                                                *03640000
      ******************************************************************03650000
REARCH*1100-RECEIVE-PARMS.                                              03660000
REARCH*                                                                 03670000
REARCH*    ADD  1                             TO PARM-ID1.              03680000
REARCH*    MOVE LENGTH OF PARM-CODE-AGENCY-ID TO MAX-LENGTH-PARM,       03690000
REARCH*                                                                 03700000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              03710000
REARCH*                          GWL-RC,                                03720000
REARCH*                          PARM-ID1,                              03730000
REARCH*                          PARM-CODE-AGENCY-ID,                   03740000
REARCH*                          TDSCHAR,                               03750000
REARCH*                          MAX-LENGTH-PARM,                       03760000
REARCH*                          PARM-L.                                03770000
REARCH*                                                                 03790000
REARCH*1100-EXIT.                                                       03800000
REARCH*    EXIT.                                                        03810000
      *                                                                 03820000
      *                                                                 03830000
      ******************************************************************03840000
      * 1150 ASSIGN-WS-VARS                                            *03850000
      *     -- THIS MODULE MOVES THE PASSED IN PARAMETER VALUES AND    *03860000
      *        MOVES THEM INTO WORKING STORAGE VARIABLES.  THEN,       *03870000
      *        THESE WORKING STORAGE VARIABLES ARE MOVED INTO THEIR    *03880000
      *        RESPECTIVE REDEFINED FIELDS FOR COMPLETING THE SQL      *03890000
      *        SELECT STATEMENTS.                                      *03900000
      ******************************************************************03910000
       1150-ASSIGN-WS-VARS.                                             
           MOVE '1150'                        TO ACTIVE-PARAGRAPH.      
      *                                                                 03940000
           MOVE PARM-CODE-AGENCY-ID           TO LI-CODE-AGENCY-ID.     
           PERFORM 7300-DATES                           THRU 7300-EXIT. 
      *                                                                 03981000
       1150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04010000
      *                                                                 04020000
      ******************************************************************04030000
      * 2000-PROCESS-OUTPUT.                                           *04040000
      *                                                                *04050000
      *     1. DESCRIBE RESULT SET                                     *04060000
      *     2. RETRIEVE DB2 DATA                                       *04070000
      *     3. BUILD RESULT SET                                        *04080000
      *     4. SEND RESULT SET                                         *04090000
      *                                                                *04100000
      ******************************************************************04110000
       2000-PROCESS-OUTPUT.                                             
           MOVE '2000'                           TO ACTIVE-PARAGRAPH.   
      *                                                                 04140000
REARCH*    PERFORM 2100-DESCRIBE-RESULT          THRU 2100-EXIT.        04150000
CBSI       PERFORM 1150-ASSIGN-WS-VARS           THRU 1150-EXIT.        
           PERFORM 7000-OPEN-LIEAP-CURSOR        THRU 7000-EXIT.        
           PERFORM 7100-FETCH-LIEAP-CURSOR       THRU 7100-EXIT.        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               PERFORM 2200-BUILD-RESULT         THRU 2200-EXIT         
                 UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                
           ELSE                                                         
REARCH         PERFORM 2000A-MOVE-RESULT         THRU 2000A-EXIT        
               PERFORM 8100-SEND-RESULT          THRU 8100-EXIT         
           END-IF.                                                      
           PERFORM 7200-CLOSE-LIEAP-CURSOR       THRU 7200-EXIT.        
      *                                                                 04191000
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04220000
REARCH*****************************************************************         
REARCH* 2000A-MOVE-RESULT.                                            *         
REARCH*****************************************************************         
REARCH*                                                                         
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE RS-RETURN-CODE           TO S-RETURN-CODE.              
REARCH     MOVE RS-REIMBURSE-DT          TO S-REIMBURSE-DT.             
REARCH     MOVE RS-CHECK-NO              TO S-CHECK-NO.                 
REARCH     MOVE RS-ACCOUNT-NO            TO S-ACCOUNT-NO.               
REARCH     MOVE RS-NAME                  TO S-NAME.                     
REARCH     MOVE RS-VOUCHER-AMT           TO S-VOUCHER-AMT.              
REARCH     MOVE RS-VOUCHER-PAY-DT        TO S-VOUCHER-PAY-DT.           
REARCH     MOVE RS-INITIATED-BY          TO S-INITIATED-BY.             
REARCH     MOVE RS-VOUCHER-PAY-TS        TO S-VOUCHER-PAY-TS.           
REARCH     MOVE RS-COMPLETED-BY          TO S-COMPLETED-BY.             
REARCH     MOVE RS-COLOR-FLAG            TO S-COLOR-FLAG.               
REARCH     MOVE RS-COMMENT               TO S-COMMENT.                  
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
      *                                                                 04230000
      ******************************************************************04240000
      * 2100-DESCRIBE-RESULT                                           *04250000
      *                                                                *04260000
      *     DESCRIBE EACH COLUMN IN THE RESULT SET.                    *04270000
      *                                                                *04280000
      ******************************************************************04290000
REARCH*2100-DESCRIBE-RESULT.                                            04300000
REARCH*    MOVE '2100'                           TO ACTIVE-PARAGRAPH.   04310000
REARCH*                                                                 04311000
REARCH*    ADD 1                                 TO CTR-COLUMN.         04311100
REARCH*    MOVE TDSINT4                          TO DB-HOST-TYPE.       04311200
REARCH*    MOVE TDSINT4                          TO DB-CLIENT-TYPE.     04311300
REARCH*    MOVE LENGTH OF RS-RETURN-CODE         TO WRKLEN1.            04311400
REARCH*    MOVE LENGTH OF CN-RETURN-CODE         TO WRKLEN2.            04311500
REARCH*                                                                 04311600
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              04311700
REARCH*                          GWL-RC,                                04311800
REARCH*                          CTR-COLUMN,                            04311900
REARCH*                          DB-HOST-TYPE,                          04312000
REARCH*                          WRKLEN1,                               04312100
REARCH*                          RS-RETURN-CODE,                        04312200
REARCH*                          DB-NULL-INDICATOR,                     04312300
REARCH*                          TDS-FALSE,                             04312400
REARCH*                          DB-CLIENT-TYPE,                        04312500
REARCH*                          WRKLEN1,                               04312600
REARCH*                          CN-RETURN-CODE,                        04312700
REARCH*                          WRKLEN2.                               04312800
REARCH*                                                                 04312900
REARCH*    PERFORM 9100-CHECK-ERROR              THRU 9100-EXIT.        04313000
REARCH*                                                                 04313100
REARCH*    ADD  1                                TO CTR-COLUMN.         04313200
REARCH*    MOVE TDSCHAR                          TO DB-HOST-TYPE.       04313300
REARCH*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.     04313400
REARCH*    MOVE LENGTH OF RS-REIMBURSE-DT        TO WRKLEN1.            04313500
REARCH*    MOVE LENGTH OF CN-REIMBURSE-DT        TO WRKLEN2.            04313600
REARCH*                                                                 04313700
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              04313800
REARCH*                          GWL-RC,                                04313900
REARCH*                          CTR-COLUMN,                            04314000
REARCH*                          DB-HOST-TYPE,                          04314100
REARCH*                          WRKLEN1,                               04314200
REARCH*                          RS-REIMBURSE-DT,                       04314300
REARCH*                          DB-NULL-INDICATOR,                     04314400
REARCH*                          TDS-FALSE,                             04314500
REARCH*                          DB-CLIENT-TYPE,                        04314600
REARCH*                          WRKLEN1,                               04314700
REARCH*                          CN-REIMBURSE-DT,                       04314800
REARCH*                          WRKLEN2.                               04314900
REARCH*                                                                 04315000
REARCH*    PERFORM 9100-CHECK-ERROR              THRU 9100-EXIT.        04315100
REARCH*                                                                 04315200
REARCH*    ADD  1                                TO CTR-COLUMN.         04315300
REARCH*    MOVE TDSCHAR                          TO DB-HOST-TYPE.       04315400
REARCH*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.     04315500
REARCH*    MOVE LENGTH OF RS-CHECK-NO            TO WRKLEN1.            04315600
REARCH*    MOVE LENGTH OF CN-CHECK-NO            TO WRKLEN2.            04315700
REARCH*                                                                 04315800
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              04315900
REARCH*                          GWL-RC,                                04316000
REARCH*                          CTR-COLUMN,                            04316100
REARCH*                          DB-HOST-TYPE,                          04316200
REARCH*                          WRKLEN1,                               04316300
REARCH*                          RS-CHECK-NO,                           04316400
REARCH*                          DB-NULL-INDICATOR,                     04316500
REARCH*                          TDS-FALSE,                             04316600
REARCH*                          DB-CLIENT-TYPE,                        04316700
REARCH*                          WRKLEN1,                               04316800
REARCH*                          CN-CHECK-NO,                           04316900
REARCH*                          WRKLEN2.                               04317000
REARCH*                                                                 04317100
REARCH*    PERFORM 9100-CHECK-ERROR              THRU 9100-EXIT.        04317200
REARCH*                                                                 04317300
REARCH*    ADD  1                                TO CTR-COLUMN.         04317400
REARCH*    MOVE TDSCHAR                          TO DB-HOST-TYPE.       04317500
REARCH*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.     04317600
REARCH*    MOVE LENGTH OF RS-ACCOUNT-NO          TO WRKLEN1.            04317700
REARCH*    MOVE LENGTH OF CN-ACCOUNT-NO          TO WRKLEN2.            04317800
REARCH*                                                                 04317900
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              04318000
REARCH*                          GWL-RC,                                04318100
REARCH*                          CTR-COLUMN,                            04318200
REARCH*                          DB-HOST-TYPE,                          04318300
REARCH*                          WRKLEN1,                               04318400
REARCH*                          RS-ACCOUNT-NO,                         04319000
REARCH*                          DB-NULL-INDICATOR,                     04320000
REARCH*                          TDS-FALSE,                             04320100
REARCH*                          DB-CLIENT-TYPE,                        04320200
REARCH*                          WRKLEN1,                               04320300
REARCH*                          CN-ACCOUNT-NO,                         04320400
REARCH*                          WRKLEN2.                               04320500
REARCH*                                                                 04320600
REARCH*    PERFORM 9100-CHECK-ERROR              THRU 9100-EXIT.        04320700
REARCH*                                                                 04321000
REARCH*    ADD  1                                TO CTR-COLUMN.         04323000
REARCH*    MOVE TDSCHAR                          TO DB-HOST-TYPE.       04324000
REARCH*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.     04325000
REARCH*    MOVE LENGTH OF RS-NAME                TO WRKLEN1.            04326000
REARCH*    MOVE LENGTH OF CN-NAME                TO WRKLEN2.            04327000
REARCH*                                                                 04328000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              04329000
REARCH*                          GWL-RC,                                04329100
REARCH*                          CTR-COLUMN,                            04329200
REARCH*                          DB-HOST-TYPE,                          04329300
REARCH*                          WRKLEN1,                               04329400
REARCH*                          RS-NAME,                               04329500
REARCH*                          DB-NULL-INDICATOR,                     04329600
REARCH*                          TDS-FALSE,                             04329700
REARCH*                          DB-CLIENT-TYPE,                        04329800
REARCH*                          WRKLEN1,                               04329900
REARCH*                          CN-NAME,                               04330000
REARCH*                          WRKLEN2.                               04330100
REARCH*                                                                 04330200
REARCH*    PERFORM 9100-CHECK-ERROR              THRU 9100-EXIT.        04330300
REARCH*                                                                 04330400
REARCH*    ADD  1                                TO CTR-COLUMN.         04330600
REARCH*    MOVE TDSDECIMAL                       TO DB-HOST-TYPE.       04330700
REARCH*    MOVE TDSFLT8                          TO DB-CLIENT-TYPE.     04330800
REARCH*    MOVE LENGTH OF RS-VOUCHER-AMT         TO WRKLEN1.            04330900
REARCH*    MOVE LENGTH OF CN-VOUCHER-AMT         TO WRKLEN2.            04331000
REARCH*                                                                 04331100
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              04331200
REARCH*                          GWL-RC,                                04331300
REARCH*                          CTR-COLUMN,                            04331400
REARCH*                          DB-HOST-TYPE,                          04331500
REARCH*                          WRKLEN1,                               04331600
REARCH*                          RS-VOUCHER-AMT,                        04331700
REARCH*                          DB-NULL-INDICATOR,                     04331800
REARCH*                          TDS-FALSE,                             04331900
REARCH*                          DB-CLIENT-TYPE,                        04332000
REARCH*                          WRKLEN1,                               04332100
REARCH*                          CN-VOUCHER-AMT,                        04332200
REARCH*                          WRKLEN2.                               04332300
REARCH*                                                                 04332400
REARCH*    PERFORM 9100-CHECK-ERROR              THRU 9100-EXIT.        04332500
REARCH*                                                                 04332600
REARCH*    MOVE +2                               TO WRKLEN2.            04332700
REARCH*    CALL 'TDSETBCD' USING GWL-PROC,                              04332800
REARCH*                          GWL-RC,                                04332900
REARCH*                          TDS-OBJECT-COL,                        04333000
REARCH*                          CTR-COLUMN,                            04333100
REARCH*                          WRKLEN1,                               04333200
REARCH*                          WRKLEN2.                               04333300
REARCH*                                                                 04333400
REARCH*    PERFORM 9100-CHECK-ERROR              THRU 9100-EXIT.        04333600
REARCH*                                                                 04333700
REARCH*    ADD  1                                TO CTR-COLUMN.         04334000
REARCH*    MOVE TDSCHAR                          TO DB-HOST-TYPE.       04340000
REARCH*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.     04350000
REARCH*    MOVE LENGTH OF RS-VOUCHER-PAY-DT      TO WRKLEN1.            04360000
REARCH*    MOVE LENGTH OF CN-VOUCHER-PAY-DT      TO WRKLEN2.            04370000
REARCH*                                                                 04380000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              04390000
REARCH*                          GWL-RC,                                04400000
REARCH*                          CTR-COLUMN,                            04410000
REARCH*                          DB-HOST-TYPE,                          04420000
REARCH*                          WRKLEN1,                               04430000
REARCH*                          RS-VOUCHER-PAY-DT,                     04440000
REARCH*                          DB-NULL-INDICATOR,                     04450000
REARCH*                          TDS-FALSE,                             04460000
REARCH*                          DB-CLIENT-TYPE,                        04470000
REARCH*                          WRKLEN1,                               04480000
REARCH*                          CN-VOUCHER-PAY-DT,                     04490000
REARCH*                          WRKLEN2.                               04500000
REARCH*                                                                 04510000
REARCH*    PERFORM 9100-CHECK-ERROR              THRU 9100-EXIT.        04520000
REARCH*                                                                 04520100
REARCH*    ADD  1                                TO CTR-COLUMN.         04520300
REARCH*    MOVE TDSCHAR                          TO DB-HOST-TYPE.       04520400
REARCH*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.     04520500
REARCH*    MOVE LENGTH OF RS-INITIATED-BY        TO WRKLEN1.            04520600
REARCH*    MOVE LENGTH OF CN-INITIATED-BY        TO WRKLEN2.            04520700
REARCH*                                                                 04520800
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              04520900
REARCH*                          GWL-RC,                                04521000
REARCH*                          CTR-COLUMN,                            04521100
REARCH*                          DB-HOST-TYPE,                          04521200
REARCH*                          WRKLEN1,                               04521300
REARCH*                          RS-INITIATED-BY,                       04521400
REARCH*                          DB-NULL-INDICATOR,                     04521500
REARCH*                          TDS-FALSE,                             04521600
REARCH*                          DB-CLIENT-TYPE,                        04521700
REARCH*                          WRKLEN1,                               04521800
REARCH*                          CN-INITIATED-BY,                       04521900
REARCH*                          WRKLEN2.                               04522000
REARCH*                                                                 04522100
REARCH*    PERFORM 9100-CHECK-ERROR              THRU 9100-EXIT.        04522200
REARCH*                                                                 04526500
REARCH*    ADD  1                                TO CTR-COLUMN.         04526600
REARCH*    MOVE TDSCHAR                          TO DB-HOST-TYPE.       04526700
REARCH*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.     04526800
REARCH*    MOVE LENGTH OF RS-VOUCHER-PAY-TS      TO WRKLEN1.            04526900
REARCH*    MOVE LENGTH OF CN-VOUCHER-PAY-TS      TO WRKLEN2.            04527000
REARCH*                                                                 04528000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              04529000
REARCH*                          GWL-RC,                                04530000
REARCH*                          CTR-COLUMN,                            04540000
REARCH*                          DB-HOST-TYPE,                          04550000
REARCH*                          WRKLEN1,                               04560000
REARCH*                          RS-VOUCHER-PAY-TS,                     04570000
REARCH*                          DB-NULL-INDICATOR,                     04580000
REARCH*                          TDS-FALSE,                             04590000
REARCH*                          DB-CLIENT-TYPE,                        04600000
REARCH*                          WRKLEN1,                               04610000
REARCH*                          CN-VOUCHER-PAY-TS,                     04620000
REARCH*                          WRKLEN2.                               04630000
REARCH*                                                                 04640000
REARCH*    PERFORM 9100-CHECK-ERROR              THRU 9100-EXIT.        04650000
REARCH*                                                                 08430000
T11573*    ADD  1                                TO CTR-COLUMN.         08432000
T11573*    MOVE TDSCHAR                          TO DB-HOST-TYPE.       08433000
T11573*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.     08434000
T11573*    MOVE LENGTH OF RS-COMPLETED-BY        TO WRKLEN1.            08435000
T11573*    MOVE LENGTH OF CN-COMPLETED-BY        TO WRKLEN2.            08436000
REARCH*                                                                 08437000
T11573*    CALL 'TDESCRIB' USING GWL-PROC,                              08438000
T11573*                          GWL-RC,                                08439000
T11573*                          CTR-COLUMN,                            08439100
T11573*                          DB-HOST-TYPE,                          08439200
T11573*                          WRKLEN1,                               08439300
T11573*                          RS-COMPLETED-BY,                       08439400
T11573*                          DB-NULL-INDICATOR,                     08439500
T11573*                          TDS-FALSE,                             08439600
T11573*                          DB-CLIENT-TYPE,                        08439700
T11573*                          WRKLEN1,                               08439800
T11573*                          CN-COMPLETED-BY,                       08439900
T11573*                          WRKLEN2.                               08440000
REARCH*                                                                 08440100
T11573*    PERFORM 9100-CHECK-ERROR              THRU 9100-EXIT.        08440200
      *                                                                 08430000
T23475*    ADD  1                                TO CTR-COLUMN.         08432000
T23475*    MOVE TDSCHAR                          TO DB-HOST-TYPE.       08433000
T23475*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.     08434000
T23475*    MOVE LENGTH OF RS-COLOR-FLAG          TO WRKLEN1.            08435000
T23475*    MOVE LENGTH OF CN-COLOR-FLAG          TO WRKLEN2.            08436000
T23475*                                                                 08437000
T23475*    CALL 'TDESCRIB' USING GWL-PROC,                              08438000
T23475*                          GWL-RC,                                08439000
T23475*                          CTR-COLUMN,                            08439100
T23475*                          DB-HOST-TYPE,                          08439200
T23475*                          WRKLEN1,                               08439300
T23475*                          RS-COLOR-FLAG,                         08439400
T23475*                          DB-NULL-INDICATOR,                     08439500
T23475*                          TDS-FALSE,                             08439600
T23475*                          DB-CLIENT-TYPE,                        08439700
T23475*                          WRKLEN1,                               08439800
T23475*                          CN-COLOR-FLAG,                         08439900
T23475*                          WRKLEN2.                               08440000
T23475*                                                                 08440100
T23475*    PERFORM 9100-CHECK-ERROR              THRU 9100-EXIT.        08440200
      *                                                                 08440300
T23475*    ADD  1                                TO CTR-COLUMN.         08432000
T23475*    MOVE TDSCHAR                          TO DB-HOST-TYPE.       08433000
T23475*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.     08434000
T23475*    MOVE LENGTH OF RS-COMMENT             TO WRKLEN1.            08435000
T23475*    MOVE LENGTH OF CN-COMMENT             TO WRKLEN2.            08436000
T23475*                                                                 08437000
T23475*   CALL 'TDESCRIB' USING GWL-PROC,                               08438000
T23475*                          GWL-RC,                                08439000
T23475*                          CTR-COLUMN,                            08439100
T23475*                          DB-HOST-TYPE,                          08439200
T23475*                          WRKLEN1,                               08439300
T23475*                          RS-COMMENT,                            08439400
T23475*                          DB-NULL-INDICATOR,                     08439500
T23475*                          TDS-FALSE,                             08439600
T23475*                          DB-CLIENT-TYPE,                        08439700
T23475*                          WRKLEN1,                               08439800
T23475*                          CN-COMMENT,                            08439900
T23475*                          WRKLEN2.                               08440000
T23475*                                                                 08440100
T23475*    PERFORM 9100-CHECK-ERROR              THRU 9100-EXIT.        08440200
REARCH*2100-EXIT.                                                       08441000
REARCH*    EXIT.                                                        08450000
      *                                                                 08460000
      *                                                                 08470000
      ******************************************************************08480000
      * 2200-BUILD RESULT.                                             *08490000
      *       -- THIS MODULE BUILDS THE RESULT SET DEPENDING ON DATA   *08500000
      *          PREVIOUSLY RETRIEVED.                                 *08510000
      ******************************************************************08520000
       2200-BUILD-RESULT.                                               
           MOVE '2200'                      TO ACTIVE-PARAGRAPH.        
      *                                                                 08550000
           MOVE LI-ACCOUNT-NO               TO WS-ACCOUNT-NO-N.         
           MOVE WS-ACCOUNT-NO               TO RS-ACCOUNT-NO.           
      *                                                                 08550300
           MOVE LI-ACCOUNT-NO               TO AT-ACCOUNT-NO.           
           MOVE WS-YES                      TO WS-NAME-ONLY-SW.         
           PERFORM 4000-MAIL-NAME-ADDRESS        THRU 4000-EXIT.        
           MOVE WS-ACCOUNT-NAME             TO RS-NAME.                 
      *                                                                 08552100
           MOVE LI-VOUCHER-AMT              TO RS-VOUCHER-AMT.          
           MOVE LI-VOUCHER-PAY-DT           TO WS-DB2-DATE.             
           MOVE WS-DB2-YYYY                 TO RS-ENT-YYYY.             
           MOVE WS-DB2-MM                   TO RS-ENT-MM.               
           MOVE WS-DB2-DD                   TO RS-ENT-DD.               
           MOVE LI-INITIATED-BY             TO RS-INITIATED-BY.         
           IF LI-REIMBURSE-DT > SPACES                                  
               MOVE LI-REIMBURSE-DT         TO WS-DB2-DATE              
               MOVE WS-DB2-YYYY             TO RS-REI-YYYY              
               MOVE WS-DB2-MM               TO RS-REI-MM                
               MOVE WS-DB2-DD               TO RS-REI-DD                
               MOVE WS-SLASH                TO RS-REI-FILLER-1          
               MOVE WS-SLASH                TO RS-REI-FILLER-2          
           ELSE                                                         
               MOVE SPACES                  TO RS-REIMBURSE-DT          
           END-IF.                                                      
           MOVE LI-CHECK-NO                 TO RS-CHECK-NO.             
           MOVE LI-VOUCHER-PAY-DT           TO RS-VOUCHER-PAY-TS.       
T11573     MOVE LI-COMPLETED-BY             TO RS-COMPLETED-BY.         
T23475     MOVE 'N'                         TO RS-COLOR-FLAG.           
T23475     MOVE LI-COMMENT-LEN              TO WS-COMMENT-LEN.          
T23475     MOVE LI-COMMENT-TEXT(1:WS-COMMENT-LEN) TO RS-COMMENT.        
      *                                                                 08781000
REARCH     PERFORM 2000A-MOVE-RESULT             THRU 2000A-EXIT.       
           PERFORM 8100-SEND-RESULT              THRU 8100-EXIT.        
           PERFORM 7100-FETCH-LIEAP-CURSOR THRU 7100-EXIT.              
      *                                                                 08900000
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08930000
      *                                                                 08940000
      ******************************************************************09780000
      * 7000-OPEN-LIEAP-CURSOR                                         *09790000
      *       -- THIS MODULE OPENS THE LIEAP CURSOR.                   *09800000
      ******************************************************************09810000
       7000-OPEN-LIEAP-CURSOR.                                          
           MOVE '7000'                       TO ACTIVE-PARAGRAPH.       
      *                                                                 09840000
           EXEC SQL                                                     
               OPEN LIEAP-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 09880000
           MOVE SQLCODE                   TO RS-RETURN-CODE             
                                             WS-ACTIVE-RETURN-CODE.     
      *                                                                 09910000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
CBSI          MOVE 'OPEN'                   TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_LIEAP'              TO TABLE-1                  
CBSI          MOVE 'CODE_AGENCY_ID'         TO TABLE-ELEMENT-1          
CBSI          MOVE 'REIMBURSE_DT'           TO TABLE-ELEMENT-2          
CBSI          MOVE PARM-CODE-AGENCY-ID      TO HOSTVAR-ELEMENT-1        
T30955*       MOVE WS-DATE-30-DAYS-AGO      TO HOSTVAR-ELEMENT-2        09994000
T30955        MOVE WS-DATE-12-MONS-AGO      TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
      *                                                                 10040000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10070000
      *                                                                 10080000
      ******************************************************************10090000
      * 7100-FETCH-LIEAP-CURSOR                                        *10100000
      *     -- THIS MODULE FETCHES THE RESULT ROWS                     *10110000
      *                                                                *10120000
      ******************************************************************10130000
       7100-FETCH-LIEAP-CURSOR.                                         
           MOVE '7100'                      TO ACTIVE-PARAGRAPH.        
      *                                                                 10160000
           EXEC SQL                                                     
               FETCH LIEAP-CURSOR                                       
                  INTO :LI-ACCOUNT-NO,                                  
                       :LI-VOUCHER-AMT,                                 
                       :LI-VOUCHER-PAY-DT,                              
                       :LI-INITIATED-BY,                                
                       :LI-REIMBURSE-DT :IND-REIMBURSE-DT,              
T11573                 :LI-CHECK-NO,                                    
T11573                 :LI-COMPLETED-BY,                                
T23475                 :LI-COMMENT                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 10210000
           MOVE SQLCODE                     TO RS-RETURN-CODE           
                                            WS-ACTIVE-RETURN-CODE.      
      *                                                                 10240000
           IF NOT (SQLCODE = SUCCESSFUL-CALL OR NOT-FOUND)              
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
              MOVE 'CSS_LIEAP'              TO TABLE-1                  
              MOVE 'CODE_AGENCY_ID'         TO TABLE-ELEMENT-1          
CBSI          MOVE 'REIMBURSE_DT'           TO TABLE-ELEMENT-2          
              MOVE PARM-CODE-AGENCY-ID      TO HOSTVAR-ELEMENT-1        
T30955*       MOVE WS-DATE-30-DAYS-AGO      TO HOSTVAR-ELEMENT-2        10341000
T30955        MOVE WS-DATE-12-MONS-AGO      TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                 10390000
           IF SQLCODE = SUCCESSFUL-CALL AND IND-REIMBURSE-DT = WS-NEG1  
              MOVE SPACES                   TO LI-REIMBURSE-DT          
           END-IF.                                                      
      *                                                                 10392000
           MOVE ZERO                        TO IND-REIMBURSE-DT.        
      *                                                                 10393000
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10420000
      *                                                                 10430000
      ******************************************************************10440000
      * 7200-CLOSE-LIEAP-CURSOR                                        *10450000
      *       -- THIS MODULE CLOSES THE LIEAP CURSOR                   *10460000
      ******************************************************************10470000
       7200-CLOSE-LIEAP-CURSOR.                                         
           MOVE '7200'                       TO ACTIVE-PARAGRAPH.       
      *                                                                 10500000
           EXEC SQL                                                     
               CLOSE LIEAP-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 10540000
           MOVE SQLCODE                   TO RS-RETURN-CODE             
                                             WS-ACTIVE-RETURN-CODE.     
      *                                                                 10570000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
CBSI          MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
CBSI          MOVE 'CSS_LIEAP'              TO TABLE-1                  
CBSI          MOVE 'CODE_AGENCY_ID'         TO TABLE-ELEMENT-1          
CBSI          MOVE 'REIMBURSE_DT'           TO TABLE-ELEMENT-2          
CBSI          MOVE PARM-CODE-AGENCY-ID      TO HOSTVAR-ELEMENT-1        
T30955*       MOVE WS-DATE-30-DAYS-AGO      TO HOSTVAR-ELEMENT-2        10645000
T30955        MOVE WS-DATE-12-MONS-AGO      TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                 10710000
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10740000
      *                                                                 10750000
      ******************************************************************10760000
      * 7300-DATES                                                     *10770000
      *       -- THIS MODULE GETS THE REQUIRED DATES                   *10780000
      ******************************************************************10790000
       7300-DATES.                                                      
      **********                                                        10800100
      * GET DATE 30 DAYS AGO                                            10800200
      **********                                                        10800300
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-HOLD-DATE                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     10800500
MFA-TR*       SET :WS-HOLD-DATE    =  CURRENT DATE                      10800600
MFA-TR*    END-EXEC.                                                    10800700

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
CBSI       MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
CBSI       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
CBSI          NEXT SENTENCE                                             
CBSI       ELSE                                                         
CBSI          MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
CBSI          MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
CBSI          MOVE '7300'                    TO ACTIVE-PARAGRAPH        
CBSI          MOVE 'SET'                     TO ABEND-FUNCTION          
CBSI          MOVE 'CODE_AGENCY_ID'          TO TABLE-ELEMENT-1         
CBSI          MOVE PARM-CODE-AGENCY-ID       TO HOSTVAR-ELEMENT-1       
CBSI          PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
CBSI          PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
CBSI       END-IF.                                                      
CBSI                                                                    
           EXEC SQL                                                     
T19436*       SELECT DATE(:WS-HOLD-DATE) - 30 DAYS                      10801000
T30955*       SELECT DATE(:WS-HOLD-DATE) - 90 DAYS                      10801000
T30955        SELECT DATEADD( MONTH, -12, IIF(TRY_CONVERT(DATE, 
                                                          :WS-HOLD-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-DATE
              ) <> 0) OR (LEN(:WS-HOLD-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-HOLD-DATE
              ), CONVERT(DATE, :WS-HOLD-DATE) ) )                    
T30955         INTO :WS-DATE-12-MONS-AGO                                
               FROM CSS_MODEL_SQL                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     10800900
MFA-TR*       SELECT DATE(:WS-HOLD-DATE) - 30 DAYS                      10801000
MFA-TR*       SELECT DATE(:WS-HOLD-DATE) - 90 DAYS                      10801000
MFA-TR*       SELECT DATE(:WS-HOLD-DATE) - 12 MONTHS                    10801000
MFA-TR*        INTO :WS-DATE-12-MONS-AGO                                10801100
MFA-TR*        FROM CSS_MODEL_SQL                                       10801200
MFA-TR*    END-EXEC.                                                    10801300

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7300'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_MODEL_SQL'           TO TABLE-1                 
CBSI          MOVE 'CODE_AGENCY_ID'          TO TABLE-ELEMENT-1         
CBSI          MOVE 'WS-HOLD-DATE'            TO TABLE-ELEMENT-2         
CBSI          MOVE PARM-CODE-AGENCY-ID       TO HOSTVAR-ELEMENT-1       
CBSI          MOVE WS-HOLD-DATE              TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                 10810000
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 10840000
REARCH******************************************************************        
REARCH*8000A-DELETE-GTT-ROWS                                           *        
REARCH******************************************************************        
REARCH*                                                                         
REARCH 8000A-DELETE-GTT-ROWS.                                           
REARCH*                                                                         
REARCH     MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.          
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH         DELETE FROM #CSR02320_R1                          
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR02320_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
REARCH*                                                                         
REARCH     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
REARCH        NEXT SENTENCE                                             
REARCH     ELSE                                                         
REARCH        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
REARCH        MOVE '8000A'               TO ACTIVE-PARAGRAPH            
REARCH        MOVE SQLCODE               TO ABEND-SQLCODE               
REARCH        MOVE 'DELETE'              TO ABEND-FUNCTION              
REARCH        MOVE SPACES                TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH        MOVE 'CSR02320_R1'         TO TABLE-1                     
REARCH        MOVE SPACES                TO TABLE-ELEMENT-1             
REARCH        MOVE SPACES                TO HOSTVAR-ELEMENT-1           
REARCH        PERFORM 9000-SEND-ERROR-RESULT                            
RAERCH                                   THRU 9000-EXIT                 
REARCH        PERFORM 9900-SQL-ERROR-ROUTINE                            
REARCH                                   THRU 9900-EXIT                 
REARCH     END-IF.                                                      
REARCH 8000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
REARCH******************************************************************        
REARCH* 8100-SEND-RESULT                                               *        
REARCH******************************************************************        
REARCH 8100-SEND-RESULT.                                                
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH          INSERT INTO #CSR02320_R1                         
REARCH          (                                                       
REARCH              RETURN_CODE                                         
REARCH             ,REIMBURSE_DT                                        
REARCH             ,CHECK_NO                                            
REARCH             ,ACCOUNT_NO                                          
REARCH             ,NAME                                                
REARCH             ,VOUCHER_AMT                                         
REARCH             ,VOUCHER_PAY_DT                                      
REARCH             ,INITIATED_BY                                        
REARCH             ,VOUCHER_PAY_TS                                      
REARCH             ,COMPLETED_BY                                        
REARCH             ,COLOR_FLAG                                          
REARCH             ,COMMENT                                             
REARCH          )                                                       
REARCH          VALUES                                                  
REARCH          (                                                       
REARCH              :S-RETURN-CODE                                      
REARCH             ,:S-REIMBURSE-DT                                     
REARCH             ,:S-CHECK-NO                                         
REARCH             ,:S-ACCOUNT-NO                                       
REARCH             ,:S-NAME                                             
REARCH             ,:S-VOUCHER-AMT                                      
REARCH             ,:S-VOUCHER-PAY-DT                                   
REARCH             ,:S-INITIATED-BY                                     
REARCH             ,:S-VOUCHER-PAY-TS                                   
REARCH             ,:S-COMPLETED-BY                                     
REARCH             ,:S-COLOR-FLAG                                       
REARCH             ,:S-COMMENT                                          
REARCH          )                                                       
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR02320_R1                                 
MFA-TR*         (                                                               
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,REIMBURSE_DT                                                
MFA-TR*            ,CHECK_NO                                                    
MFA-TR*            ,ACCOUNT_NO                                                  
MFA-TR*            ,NAME                                                        
MFA-TR*            ,VOUCHER_AMT                                                 
MFA-TR*            ,VOUCHER_PAY_DT                                              
MFA-TR*            ,INITIATED_BY                                                
MFA-TR*            ,VOUCHER_PAY_TS                                              
MFA-TR*            ,COMPLETED_BY                                                
MFA-TR*            ,COLOR_FLAG                                                  
MFA-TR*            ,COMMENT                                                     
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*             :S-RETURN-CODE                                              
MFA-TR*            ,:S-REIMBURSE-DT                                             
MFA-TR*            ,:S-CHECK-NO                                                 
MFA-TR*            ,:S-ACCOUNT-NO                                               
MFA-TR*            ,:S-NAME                                                     
MFA-TR*            ,:S-VOUCHER-AMT                                              
MFA-TR*            ,:S-VOUCHER-PAY-DT                                           
MFA-TR*            ,:S-INITIATED-BY                                             
MFA-TR*            ,:S-VOUCHER-PAY-TS                                           
MFA-TR*            ,:S-COMPLETED-BY                                             
MFA-TR*            ,:S-COLOR-FLAG                                               
MFA-TR*            ,:S-COMMENT                                                  
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
REARCH*                                                                         
REARCH     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
REARCH        ADD +1                    TO CTR-ROWS                     
REARCH     ELSE                                                         
REARCH        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
REARCH        MOVE '8100'               TO ACTIVE-PARAGRAPH             
REARCH        MOVE SQLCODE              TO ABEND-SQLCODE                
REARCH        MOVE 'INSERT'             TO ABEND-FUNCTION               
REARCH        MOVE SPACES               TO ABEND-SQL-PREDICATES         
REARCH                                     ABEND-TABLES                 
REARCH        MOVE 'CSR02320_R1'        TO TABLE-1                      
REARCH        MOVE SPACES               TO TABLE-ELEMENT-1              
REARCH        MOVE SPACES               TO HOSTVAR-ELEMENT-1            
REARCH        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH 8100-EXIT.                                                       
REARCH     EXIT.                                                        
      *                                                                 10850000
      ******************************************************************10850100
      * 4000- NAME EXTRACTING                                          *10850200
      ******************************************************************10850300
           EXEC SQL                                                     10851000
               INCLUDE CPD00074                                         10851100
           END-EXEC.                                                    10853000
      *                                                                 10853200
           EXEC SQL                                                     10854000
               INCLUDE CPD00004                                         10855000
           END-EXEC.                                                    10856000
      ******************************************************************12090000
TP5109* 9700-PROCESS-ABEND.                                            *12100000
      ******************************************************************12110000
TP5109 COPY CPD0023C.                                                   12110100
      ******************************************************************12110200
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *12110300
      ******************************************************************12110400
       9900-ABEND.                                                      
REARCH*    EXEC SQL                                                     12120000
REARCH*       INCLUDE CPD00300                                          12130000
REARCH*    END-EXEC.                                                    12140000
REARCH*                                                                         
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
      *                                                                 12150000
      ******************************************************************12160000
      * 9999- END PROGRAM COPYLIB                                      *12170000
      ******************************************************************12180000
REARCH*    COPY CPD00302.                                               12190000
REARCH     EXEC SQL                                                     12200000
REARCH         INCLUDE CPD00320                                                 
REARCH     END-EXEC.                                                            
                                                                        
