       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02319.                                         
COB303 DATE-WRITTEN.     JAN 1996.                                      
       DATE-COMPILED.                                                   
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S319                                           *        
      *  PROGRAM:       S319                                           *        
      *  CALLING SP:    PA_S319                                        *        
      *  PANEL:         380                                            *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *        
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *        
      *                                                                *        
      *  THIS PROGRAM IS USED TO POST VOUCHER REIMBURSEMENTS  USING    *        
      *  PANEL 380. AS THE PAYMENTS ARE POSTED USING THE GL ACCT NO    *        
      *  OF THE AGENCY MAKING THE PAYMENT AND NO CUSTOMER ACCOUNT IS   *        
      *  INVOLVED CASH JOURNAL FORMAT 201 IS USED.                     *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  01/29/96  BB         PROGRAM ORIGINALLY WRITTEN               *        
      *  03/13/96  BB         PROGRAM MODIFICATION FOR N               *        
      *  07/12/96  ALI        TPR # 3856                               *        
      *                       MODIFIED TO STORE CURRENCY TYPE IN THE   *        
      *                       CSS_DRWR_JRNL TABLE (CASH JOURNALING).   *        
      *  09/10/96  JEP        TPR #5103 - REMOVED REFERENCE TO         *        
      *                       CWS00068.  PROGRAM DOES NOT USE THIS     *        
      *                       COPYBOOK.                                *        
TP4306*  09/26/96  TCB        ADDED PARAMETER TO PASS CODE-PYMT-       *        
TP4306*                       FACILITY TO THE RPC AND CHANGED CODE TO  *        
TP4306*                       CREATE A '998' CASH DRAWER JOURNAL.      *        
PCR072*  09/30/96    PD       COMMENTED CODE FOR CIAC FOR PCR072.      *        
T10350*  04/15/97    PD       USE 101 INSTEAD OF 201 JOURNAL.          *        
T11903*  07/01/97    CHANDRA  USE THE INPUT PARAMETER VALUES FOR       *        
T11903*                       JOURNALLING.                             *        
T13111*  09/17/97    PD       POPULATE CNTL VARIABLES FOR JOURNAL.     *        
PCR640*  07/01/98    KLP      ADDED CHECK LOGIC TO CHECK AR-LOCKOUT.   *        
T20263*  06/24/99    PR       MOVED PARM-CODE-PYMT-FACILITY TO         *        
T20263*                       MOVED WS-JRNL-CODE-PYMT-FACILITY.        *        
      *  04/09/01    CHANELLE MCR310 PSNC. 0700 GL        CHANGES AND  *        
      *                       RECOMPILE FOR CPD00006.                  *        
T24436*  11/20/01    NVM      ADDED LOGIC TO IMPLEMENT CPYC CPD00061   *        
T24436*                       CONVERSION TO SUBPROGRAM SCSCO061        *        
C25603*  11/06/01    LEF      ADDED LOGIC TO LOAD 298 TO LOCAL OFFICE  *        
C25603*                       FOR PSNC ACCOUNTS.                       *        
REARCH*  08/30/05    CVNS     RPC TO COBOL SP CONVERSION               *        
REARCH*              CHENNAI                                           *        
T37302*  06/16/08    MR97640  DELETE DCLGEN TBCIAC,TBRVCACT            *        
A00956*  03/26/09    CVNS     REPLACE CPD00006 WITH CPD0006A.          *        
A00956*              CHENNAI                                           *        
A02007*  01/08/2010  LAT      CHECK IF THE CASH-DRAWER-ID IS OPEN.     *        
A04880*  07/21/2014  AS7C117  REMOVED UNUSED COPY BOOK CPD00008.       *        
A04880*              #ACT225                                           *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02319'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02319 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBARHIST                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBARHDT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCDCNTL                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCDJRNL                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBJCNTL                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBTJRNL                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMSJRNL                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBGLATNO                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBARLOCK                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
A00956        INCLUDE CWS0013B                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00017                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00061                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00073                                                  
           END-EXEC.                                                            
T24436*    INCLUDED THE COPYBOOK FOR LINK RECORD CPD00061                       
T24436     EXEC SQL                                                             
T24436        INCLUDE CWS0061L                                                  
T24436     END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBLIEAP                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *--------< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >               
           COPY CWS00027.                                                       
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                          
           COPY CWS00303.                                                       
           COPY CWS00100.                                                       
           COPY CJF00101.                                                       
                                                                        
      ******************************************************************        
      * WORKING STORAGE FOR JOURNALING                                 *        
      ******************************************************************        
       01  AR-TRANSACTION-STORAGE.                                      
           05  CURRENT-TIMESTAMP       PIC X(26).                       
           05  CURRENT-DATE            PIC X(10).                       
      *                                                                         
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME             PIC X(08) VALUE 'CSR02319'.     
REARCH     05  MCSCO061                 PIC X(08) VALUE 'MCSCO061'.     
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  WS-SAVE-ROW-COUNT PIC S9(04) COMP VALUE +0.              
           05  WS-DATE-ORIG-PYMT-IND    PIC S9(04) COMP VALUE +0.       
           05  WS-CHRG-OFF-ACCT         PIC  X(01) VALUE 'N'.           
           05  WS-SUB                   PIC S9(04) COMP VALUE +0.       
           05  WS-CASH-DRAWER.                                          
               10  FILLER               PIC  X(05) VALUE 'CASH '.       
               10  WS-CASH-DRAWER-ID    PIC  X(01).                     
                                                                        
           05  WS-AMOUNT-LIHEAP         PIC  X(11).                     
           05  WS-AMOUNT-LIHEAP-NUM REDEFINES WS-AMOUNT-LIHEAP          
                                        PIC  9(09)V99.                  
           05  WS-AMOUNT-LIHEAP-COMP3   PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-COMPANY-NO            PIC  X(02) .                    
                                                                        
           05  WS-CURRENT1-DATE         PIC  X(26) VALUE SPACES.        
           05  WS-CURRENT-DATE          PIC  X(10) VALUE SPACES.        
           05  WS-CURRENT-TIMESTAMP     PIC  X(26) VALUE SPACES.        
           05  WS-COMMENT-LEN           PIC  9(04) VALUE 0.             
           05  WS-COMMENT-LEN-NUM       PIC  S9(04) COMP VALUE 0.       
           05  WS-COMMENT-TEXT          PIC  X(25) VALUE SPACES.        
           05  WS-GL-ACCT-NO            PIC X(07) VALUE SPACES.         
           05  WS-GL-ACCT-NO-NUM  REDEFINES WS-GL-ACCT-NO               
                                  PIC 9(07).                            
           05  WS-GL-ACCT-DEBIT        PIC S9(03)V9(04) COMP-3 VALUE 0. 
           05  WS-LOCAL-OFFICE          PIC X(03) VALUE SPACES .        
           05  WS-EIBRESP               PIC S9(8)                       
                                        COMP SYNC  VALUE ZERO.          
                                                                        
       01  WS-LITERAL.                                                  
           05  WS-A                     PIC X(01) VALUE 'A'.            
           05  WS-C                     PIC X(01) VALUE 'C'.            
           05  WS-RCV-TYPE              PIC S9(04) COMP.                
           05  WS-NO                    PIC  X(01) VALUE 'N'.           
           05  WS-YES                   PIC  X(01) VALUE 'Y'.           
           05  WS-NO-ERROR              PIC  X(05) VALUE 'NOERR'.       
           05  WS-UPDATE-TYPE           PIC X(01) VALUE SPACES.         
           05  WS-DEBIT                 PIC X(01) VALUE 'D'.            
           05  WS-CREDIT                PIC X(01) VALUE 'C'.            
           05  WS-VALID-CO              PIC X(01) VALUE 'N'.            
      *                                                                         
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                   PIC S9(9) COMP.                 
           05  PARM-UPDATE-TYPE         PIC  X(01).                     
           05  PARM-CASHIER-CODE        PIC  X(02).                     
           05  PARM-COMPANY-NO          PIC  X(02).                     
           05  PARM-AMT-LIHEAP          PIC  X(11).                     
           05  PARM-USER-ID             PIC  X(07).                     
           05  PARM-LOCAL-OFFICE        PIC  X(03).                     
           05  PARM-CODE-AGENCY-ID      PIC  X(05) VALUE SPACES .       
           05  PARM-GL-ACCT-NO          PIC  X(07).                     
           05  PARM-PANEL-NO            PIC  X(08).                     
           05  PARM-DATE-CASH-REPORT    PIC  X(10).                     
           05  PARM-CASH-COMPANY-NO     PIC  X(02).                     
           05  PARM-CASH-LOCAL-OFFICE   PIC  X(03).                     
           05  PARM-CASH-DRAWER-ID      PIC  S9(04) COMP.               
           05  PARM-CASH-REPORT-NO      PIC  X(03).                     
           05  PARM-CURRENCY-TYPE       PIC  X(01) VALUE SPACES.        
TP4306     05  PARM-CODE-PYMT-FACILITY  PIC  X(01) VALUE SPACES.        
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
           05  RS-ERROR-MESSAGE         PIC  X(05) VALUE 'NOERR'.       
           05  RS-ADV-COLL-TIMESTAMP    PIC  X(26) VALUE SPACES.        
           05  RS-ENTRY-NO              PIC S9(9) COMP VALUE 0.         
REARCH*                                                                         
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE            PIC S9(9) COMP VALUE 0.         
REARCH     05  S-ERROR-MESSAGE          PIC  X(05) VALUE 'NOERR'.       
REARCH     05  S-ADV-COLL-TIMESTAMP     PIC  X(26) VALUE SPACES.        
REARCH     05  S-ENTRY-NO               PIC S9(9) COMP VALUE 0.         
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-SCEG                     PIC X(02) VALUE '01'.            
       01  WS-PSNC                     PIC X(02) VALUE '26'.            
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
HPCCDM* EJECT .                                                                 
CVT000     EXEC SQL                                                             
CVT000         INCLUDE CWSX0010                                                 
CVT000     END-EXEC.                                                            
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
REARCH*    10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.                
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-UPDATE-TYPE         PIC  X(01)               .          
CVT000 01  LINK-CASHIER-CODE        PIC  X(02)               .          
CVT000 01  LINK-COMPANY-NO          PIC  X(02)               .          
CVT000 01  LINK-AMT-LIHEAP          PIC  X(11)               .          
CVT000 01  LINK-USER-ID             PIC  X(07)               .          
CVT000 01  LINK-LOCAL-OFFICE        PIC  X(03)               .          
CVT000 01  LINK-CODE-AGENCY-ID      PIC  X(05)               .          
CVT000 01  LINK-GL-ACCT-NO          PIC  X(07)               .          
CVT000 01  LINK-PANEL-NO            PIC  X(08)               .          
CVT000 01  LINK-DATE-CASH-REPORT    PIC  X(10)               .          
CVT000 01  LINK-CASH-COMPANY-NO     PIC  X(02)               .          
CVT000 01  LINK-CASH-LOCAL-OFFICE   PIC  X(03)               .          
CVT000 01  LINK-CASH-DRAWER-ID      PIC  S9(04) COMP         .          
CVT000 01  LINK-CASH-REPORT-NO      PIC  X(03)               .          
CVT000 01  LINK-CURRENCY-TYPE       PIC  X(01)               .          
CVT000 01  LINK-CODE-PYMT-FACILITY  PIC  X(01)               .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-UPDATE-TYPE                                        
CVT000         ,LINK-CASHIER-CODE                                       
CVT000         ,LINK-COMPANY-NO                                         
CVT000         ,LINK-AMT-LIHEAP                                         
CVT000         ,LINK-USER-ID                                            
CVT000         ,LINK-LOCAL-OFFICE                                       
CVT000         ,LINK-GL-ACCT-NO                                         
CVT000         ,LINK-PANEL-NO                                           
CVT000         ,LINK-DATE-CASH-REPORT                                   
CVT000         ,LINK-CASH-COMPANY-NO                                    
CVT000         ,LINK-CASH-LOCAL-OFFICE                                  
CVT000         ,LINK-CASH-DRAWER-ID                                     
CVT000         ,LINK-CASH-REPORT-NO                                     
CVT000         ,LINK-CURRENCY-TYPE                                      
CVT000         ,LINK-CODE-PYMT-FACILITY                                 
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                                      
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
CVT000     EXEC SQL                                                     
CVT000       DECLARE C1 CURSOR  FOR                          
CVT000       SELECT                                                     
CVT000        :S-RETURN-CODE              AS    RETURN_CODE             
CVT000       ,:S-ERROR-MESSAGE            AS    ERROR_MESSAGE           
CVT000       ,:S-ADV-COLL-TIMESTAMP       AS    ADV_COLL_TIMESTAMP      
CVT000       ,:S-ENTRY-NO                 AS    ENTRY_NO                
CVT000          FROM CIS.SYSDUMMY1                                   
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :S-RETURN-CODE              AS    RETURN_CODE                     
MFA-TR*      ,:S-ERROR-MESSAGE            AS    ERROR_MESSAGE                   
MFA-TR*      ,:S-ADV-COLL-TIMESTAMP       AS    ADV_COLL_TIMESTAMP              
MFA-TR*      ,:S-ENTRY-NO                 AS    ENTRY_NO                        
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
CVT000     MOVE LINK-UPDATE-TYPE          TO PARM-UPDATE-TYPE         . 
CVT000     MOVE LINK-CASHIER-CODE         TO PARM-CASHIER-CODE        . 
CVT000     MOVE LINK-COMPANY-NO           TO PARM-COMPANY-NO          . 
CVT000     MOVE LINK-AMT-LIHEAP           TO PARM-AMT-LIHEAP          . 
CVT000     MOVE LINK-USER-ID              TO PARM-USER-ID             . 
CVT000     MOVE LINK-LOCAL-OFFICE         TO PARM-LOCAL-OFFICE        . 
CVT000     MOVE LINK-GL-ACCT-NO           TO PARM-GL-ACCT-NO          . 
CVT000     MOVE LINK-PANEL-NO             TO PARM-PANEL-NO            . 
CVT000     MOVE LINK-DATE-CASH-REPORT     TO PARM-DATE-CASH-REPORT    . 
CVT000     MOVE LINK-CASH-COMPANY-NO      TO PARM-CASH-COMPANY-NO     . 
CVT000     MOVE LINK-CASH-LOCAL-OFFICE    TO PARM-CASH-LOCAL-OFFICE   . 
CVT000     MOVE LINK-CASH-DRAWER-ID       TO PARM-CASH-DRAWER-ID      . 
CVT000     MOVE LINK-CASH-REPORT-NO       TO PARM-CASH-REPORT-NO      . 
CVT000     MOVE LINK-CURRENCY-TYPE        TO PARM-CURRENCY-TYPE       . 
CVT000     MOVE LINK-CODE-PYMT-FACILITY   TO PARM-CODE-PYMT-FACILITY  . 
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
      *                                                                         
           MOVE WS-AMOUNT-LIHEAP-COMP3  TO LI-VOUCHER-AMT .             
           MOVE PARM-CODE-AGENCY-ID     TO LI-CODE-AGENCY-ID .          
           MOVE PARM-COMPANY-NO         TO WS-COMPANY-NO .              
           MOVE PARM-LOCAL-OFFICE       TO WS-LOCAL-OFFICE .            
           MOVE PARM-UPDATE-TYPE        TO WS-UPDATE-TYPE .             
           MOVE PARM-GL-ACCT-NO         TO WS-GL-ACCT-NO .              
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     CALLS 2200-BUILD-RESULT                                    *        
      *     CALLED FROM 0000-MAINLINE                                 *         
      *                                                                *        
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *        
      *      AND SENDS THEM BACK                                       *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
PCR640***********                                                               
      * DO NOT PROCEED IF SYSTEM IS LOCKED                                      
      ***********                                                               
           PERFORM 7999-SELECT-AL THRU 7999-SELECT-AL-EXIT.             
           IF AL-AR-LOCKOUT-IND = 'Y'                                   
              MOVE 5000 TO RS-RETURN-CODE                               
REARCH        PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
              PERFORM 9999-END-PROGRAM      THRU 9999-EXIT              
           END-IF.                                                      
                                                                        
           PERFORM 2200-PROCESS THRU 2200-EXIT.                         
       2000-EXIT.                                                       
           EXIT.                                                        
REARCH*                                                                         
REARCH*****************************************************************         
REARCH* 2000A-MOVE-RESULT.                                            *         
REARCH*****************************************************************         
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE  RS-RETURN-CODE           TO S-RETURN-CODE.             
REARCH     MOVE  RS-ERROR-MESSAGE         TO S-ERROR-MESSAGE.           
REARCH     MOVE  RS-ADV-COLL-TIMESTAMP    TO S-ADV-COLL-TIMESTAMP.      
REARCH     MOVE  RS-ENTRY-NO              TO S-ENTRY-NO.                
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
      ******************************************************************        
      * 2200-PROCESS-BEGIN                                             *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
                                                                        
       2200-PROCESS.                                                    
           MOVE '2200'              TO ACTIVE-PARAGRAPH.                
                                                                        
      *******                                                                   
      * MOVE NUMERIC FIELD AMONG WORKING STORAGE FIELDS BECAUSE THEY            
      * WERE PASSED AS CHARACTER, NOT NUMERIC.                                  
      *******                                                                   
                                                                        
           MOVE PARM-AMT-LIHEAP        TO WS-AMOUNT-LIHEAP.             
           MOVE WS-AMOUNT-LIHEAP-NUM   TO WS-AMOUNT-LIHEAP-COMP3.       
           MOVE WS-AMOUNT-LIHEAP-COMP3 TO WS-AMT-LIHEAP.                
                                                                        
      *******                                                                   
      * GET G/L ACCOUNT NUMBER                                                  
      *******                                                                   
           MOVE WS-YES TO WS-VALID-CO.                                  
           IF WS-VALID-CO = WS-NO                                       
              MOVE 'D0036' TO RS-ERROR-MESSAGE                          
REARCH        PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
              GO TO 2200-EXIT                                           
           END-IF.                                                      
A02007*                                                                         
A02007     MOVE PARM-CASH-COMPANY-NO   TO   CS-CASH-COMPANY-NO.         
A02007     MOVE PARM-CASH-LOCAL-OFFICE TO   CS-CASH-LOCAL-OFFICE.       
A02007     MOVE PARM-DATE-CASH-REPORT  TO   CS-DATE-CASH-REPORT.        
A02007     MOVE PARM-CASH-DRAWER-ID    TO   CS-CASH-DRAWER-ID.          
A02007     PERFORM 7300-SELECT-CASH-CNTL    THRU 7300-EXIT.             
A02007     IF CS-CODE-CSH-DRWR-STAT NOT = 'A'                           
A02007        MOVE 'D5160'             TO RS-ERROR-MESSAGE              
A02007        PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT             
A02007        PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
A02007        GO TO 2200-EXIT                                           
A02007     END-IF.                                                      
                                                                        
           PERFORM 2205-LOAD-GL-NUMBERS THRU 2205-EXIT.                 
      ******************                                                        
      * CREDIT CORRECT G/L ACCT NUMBER                                          
      ******************                                                        
                COMPUTE                                                 
                     WS-GL-ACCT-DEBIT = WS-GL-ACCT-NO-NUM / 10000       
                END-COMPUTE .                                           
                MOVE WS-GL-ACCT-DEBIT      TO GO-GL-ACCT-NO .           
           MOVE GO-GL-ACCT-NO TO WS-PAR-GEN-LEDG-DB.                    
                                                                        
           PERFORM 7000-GET-DATE THRU 7000-EXIT.                        
           PERFORM 5000-UPDATE THRU 5000-EXIT.                          
                                                                        
           MOVE  WS-NO-ERROR TO RS-ERROR-MESSAGE.                       
                                                                        
           PERFORM 5750-JOURNAL-FORMAT-201-CREDIT THRU 5750-EXIT .      
           MOVE WS-JRNL-NO-ITEMS-CNTRL    TO RS-ENTRY-NO.               
REARCH     PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT.          
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************                        
      * LOAD ALL G/L NUMBER, INCLUDING CHARGED OFF.    *                        
      **************************************************                        
       2205-LOAD-GL-NUMBERS.                                            
T24436     PERFORM 9350-LINK-SCSCO061     THRU 9350-EXIT.               
      *                                                                         
MCR310     SET WS-GL-SUB TO 1.                                          
       2205-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       5000-UPDATE.                                                     
           MOVE '5000'        TO ACTIVE-PARAGRAPH.                      
                                                                        
           MOVE WS-COMPANY-NO TO WS-100-COMPANY-NO.                     
      *******************************************************                   
      * THESE FILEDS WERE POPULATED BY CALLING CPD00020     *                   
      * (PARAGRAPH 5970) TO ACCESS APPLICATION TABLE 50.    *                   
      *******************************************************                   
           MOVE 9             TO WS-TRAN-OPER-LEVEL.                    
           MOVE 1             TO WS-TRAN-OCAP-FIELD.                    
           MOVE 1             TO WS-TRAN-OCAP-VALUE.                    
           MOVE WS-C          TO WS-TRAN-JRNL-TYPE.                     
           MOVE WS-N          TO WS-TRAN-HOLD-EXEMPT-FLAG.              
                                                                        
      *******************************************************                   
      * THESE FILEDS WERE POPULATED BY CALLING CPD00021     *                   
      * (PARAGRAPH 5980) TO VERIFY USER-ID.                 *                   
      *******************************************************                   
           MOVE PARM-USER-ID       TO WS-JRNL-OL-TEMP-ID.               
           MOVE WS-JRNL-CK-OPER-ID TO WS-JRNL-OPERATION-RQST.           
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT.             
           MOVE WS-JRNL-OL-OPR-LOC TO WS-TERM-LOC.                      
                                                                        
      ********************************************************                  
      ****THESE ARE THE CHANGES REQUIRED FOR FIELD CASH SYSTEM *                
      *******************************************************                   
           MOVE PARM-CASH-COMPANY-NO   TO   WS-JRNL-OL-COMPANY.         
T11903     MOVE PARM-CASH-LOCAL-OFFICE TO   WS-JRNL-OL-LOC-OFF.         
T11903     MOVE PARM-CASH-REPORT-NO    TO   WS-JRNL-OL-REPORT-NO.       
T11903     MOVE PARM-DATE-CASH-REPORT  TO   WS-JRNL-OL-REPORT-DT.       
T11903     MOVE PARM-CASH-DRAWER-ID    TO   WS-JRNL-OL-CASH-DRWR.       
      ****************                                                          
      *******    END CHANGES                                                    
      ****************                                                          
           MOVE WS-TERM-LOC                TO WS-JRNL-OL-TERM-LOC       
                                              WS-JRNL-OL-CASH-LOC       
                                              WS-JRNL-OL-OPR-LOC.       
           MOVE WS-JRNL-VALIDATE-OPER TO WS-JRNL-OPERATION-RQST.        
           MOVE WS-C                  TO WS-JRNL-SOURCE-CODE.           
TP4306     MOVE PARM-CODE-PYMT-FACILITY                                 
TP4306                                TO WS-JRNL-CODE-PYMT-FACILITY.    
           IF CASH-TRANSACTION                                          
              MOVE WS-JRNL-CASH-UPDATE     TO WS-JRNL-OL-AUTH-TYPE      
           ELSE                                                         
              MOVE WS-JRNL-NON-CASH-UPDATE TO WS-JRNL-OL-AUTH-TYPE
           END-IF.     
           PERFORM 6400-ONLINE-JRNL-ROUTINE  THRU 6400-EXIT.            
                                                                        
           MOVE WS-A                   TO WS-100-JRNL-SORT-ID.          
           MOVE WS-COMPANY-NO          TO WS-100-COMPANY-NO.            
           MOVE 9999999999999          TO WS-100-ACCT-NO.               
           MOVE 9999999999             TO WS-100-CUSTOMER-NO.           
           MOVE 9999999999             TO WS-100-PREMISE-NO.            
           MOVE 'S319'                 TO WS-100-CODE-TERMINAL-TRAN.    
           ADD 1                       TO WS-100-JRNL-TRAN-APPL-NO.     
           MOVE WS-CURRENT-DATE        TO WS-100-DATE-LAST-ACTION.      
           MOVE 'C'                    TO WS-100-CODE-ENTRY-SOURCE.     
      ******   CHANGED FOR FIELD CASH                                           
      *    MOVE WS-CASH-DRAWER         TO WS-JRNL-OL-CASH-DRWR.                 
      *    MOVE WS-JRNL-OL-CASH-DRWR-ID TO WS-PAR-CASH-DRAWER-ID.               
           MOVE WS-LOCAL-OFFICE        TO WS-100-LOCAL-OFFICE-CD        
                                          WS-JRNL-OL-CASH-LOC.          
           MOVE SPACES                 TO WS-100-TRANS-ERRORS.          
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
A00956       INCLUDE CPD0006A                                                   
           END-EXEC.                                                            
                                                                        
      ***************************************************************           
      * 5750-JOURNAL-FORMAT-201.                                    *           
      *    -- THIS MODULE WRITES A FORMAT 201 JOURNAL               *           
      ***************************************************************           
       5750-JOURNAL-FORMAT-201-CREDIT.                                  
                                                                        
T10350     IF WS-UPDATE-TYPE = 'U'                                      
T10350        MOVE GO-GL-ACCT-NO             TO WS-101-ACCT-GEN-LED-CR  
T10350        MOVE WS-CLR-CASH-GL-NO (WS-GL-SUB)                        
T10350                                       TO WS-101-ACCT-GEN-LED-DR  
T10350     ELSE                                                         
T10350        MOVE GO-GL-ACCT-NO             TO WS-101-ACCT-GEN-LED-DR  
T10350        MOVE WS-CLR-CASH-GL-NO (WS-GL-SUB)                        
T10350                                       TO WS-101-ACCT-GEN-LED-CR  
T10350     END-IF.                                                      
                                                                        
T13111     MOVE WS-101-ACCT-GEN-LED-DR TO WS-GEN-LED-NO-AR-TEST         
T13111     IF WS-101-ACCT-GEN-LED-DR EQUAL                              
T13111                 WS-CLR-CASH-GL-NO (WS-GL-SUB)                    
T13111        MOVE WS-AMOUNT-LIHEAP-COMP3     TO WS-JRNL-CASH-DEBIT-AMT 
T13111     ELSE                                                         
T13111       IF WS-GEN-LED-ACCT-TEST EQUAL 142                          
T13111          AND WS-GEN-LED-SUB-TEST < 4200                          
T13111          MOVE WS-AMOUNT-LIHEAP-COMP3  TO WS-JRNL-RCV-DEBIT-AMT   
T13111       ELSE                                                       
T13111        MOVE WS-AMOUNT-LIHEAP-COMP3  TO WS-JRNL-GEN-LEG-DEBIT-AMT 
T13111       END-IF                                                     
T13111     END-IF                                                       
                                                                        
T13111     MOVE WS-101-ACCT-GEN-LED-CR TO WS-GEN-LED-NO-AR-TEST         
T13111     IF WS-101-ACCT-GEN-LED-CR EQUAL                              
T13111                 WS-CLR-CASH-GL-NO (WS-GL-SUB)                    
T13111        MOVE WS-AMOUNT-LIHEAP-COMP3    TO WS-JRNL-CASH-CREDIT-AMT 
T13111     ELSE                                                         
T13111       IF WS-GEN-LED-ACCT-TEST EQUAL 142                          
T13111          AND WS-GEN-LED-SUB-TEST < 4200                          
T13111         MOVE WS-AMOUNT-LIHEAP-COMP3  TO WS-JRNL-RCV-CREDIT-AMT   
T13111       ELSE                                                       
T13111         MOVE WS-AMOUNT-LIHEAP-COMP3  TO                          
T13111                 WS-JRNL-GEN-LEG-CREDIT-AMT                       
T13111       END-IF                                                     
T13111     END-IF.                                                      
                                                                        
T10350     MOVE 101                     TO WS-101-JRNL-FORMAT-NO.       
T10350                                                                  
T10350     MOVE SPACES                  TO WS-101-CASH-DRAWER-USED      
T10350*                                                                         
T10350     MOVE WS-AMOUNT-LIHEAP-COMP3  TO WS-101-AMT-POSTED            
T10350                                     WS-101-AMOUNT-ENTERED.       
T10350     MOVE SPACES                  TO WS-101-AR-AGE.               
T10350     MOVE WS-CURRENT-DATE         TO WS-101-DATE-AR-BILLED.       
T10350     MOVE 0                       TO WS-101-ITEM-ID-NO.           
T10350     MOVE 0                       TO WS-101-DETAIL-END-BAL.       
T10350     MOVE 0                       TO WS-101-DETAIL-END-AR-BAL.    
T10350     MOVE 0                       TO WS-101-ACCT-END-AR-BAL.      
T10350     MOVE SPACES                  TO WS-101-FUNCTION-CODE.        
T10350     MOVE SPACES                  TO WS-101-CODE-REVENUE-DISTRICT.
T10350     MOVE SPACES                  TO WS-101-CODE-EMPL-ACCT.       
T10350     MOVE SPACES                  TO WS-101-CODE-COMPANY-ACCT.    
T10350     MOVE SPACES                  TO WS-101-CODE-ACCOUNT-STATUS.  
T10350     MOVE SPACES                  TO WS-101-CODE-PREMISE-STATUS.  
T10350*******************************************************                   
A00956* POPULATE CWS0013B VARIABLES.                        *                   
T10350*******************************************************                   
T10350*    MOVE SPACES                  TO WS-JRNL-CODE-PYMT-FACILITY.          
T20263     MOVE PARM-CODE-PYMT-FACILITY TO WS-JRNL-CODE-PYMT-FACILITY.  
T10350     MOVE CJF00101                TO WS-100-USER-DEFINED-AREA.    
                                                                        
C25603     IF WS-COMPANY-NO = WS-PSNC                                   
C25603        MOVE '298' TO WS-100-LOCAL-OFFICE-CD                      
C25603     ELSE                                                         
TP4306        MOVE '998' TO WS-100-LOCAL-OFFICE-CD                      
C25603     END-IF.                                                      
                                                                        
           MOVE WS-A                   TO WS-100-JRNL-SORT-ID.          
                                                                        
           MOVE WS-JRNL-ONLY           TO WS-JRNL-OPERATION-RQST.       
           MOVE PARM-CURRENCY-TYPE     TO WS-JRNL-CURRENCY-TYPE.        
                                                                        
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT.             
                                                                        
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
              NEXT SENTENCE                                             
           ELSE                                                         
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
           MOVE WS-JRNL-CNTRL-ONLY     TO WS-JRNL-OPERATION-RQST.       
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT.             
                                                                        
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
              NEXT SENTENCE                                             
           ELSE                                                         
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       5750-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7000-GET-DATE.                                                   
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE = CURRENT DATE                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE WS-CURRENT-TIMESTAMP  TO RS-ADV-COLL-TIMESTAMP .        
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
A02007****************************************************************          
A02007* 7300-SELECT-CSH-CNTL.                                                   
A02007* CHECK IF PARM-CASH-DRAWER-ID IS OPEN.                                   
A02007****************************************************************          
A02007 7300-SELECT-CASH-CNTL.                                           
A02007     EXEC SQL                                                     
A02007         SELECT CODE_CSH_DRWR_STAT                                
A02007           INTO :CS-CODE-CSH-DRWR-STAT                            
A02007           FROM CSS_CSH_DRWR_CNTL WITH(READUNCOMMITTED)                   
A02007          WHERE CASH_COMPANY_NO   = :CS-CASH-COMPANY-NO           
A02007            AND CASH_LOCAL_OFFICE = :CS-CASH-LOCAL-OFFICE         
A02007            AND DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )          
A02007            AND CASH_DRAWER_ID    = :CS-CASH-DRAWER-ID            
A02007                                                           
A02007     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODE_CSH_DRWR_STAT                                        
MFA-TR*          INTO :CS-CODE-CSH-DRWR-STAT                                    
MFA-TR*          FROM CSS_CSH_DRWR_CNTL                                         
MFA-TR*         WHERE CASH_COMPANY_NO   = :CS-CASH-COMPANY-NO                   
MFA-TR*           AND CASH_LOCAL_OFFICE = :CS-CASH-LOCAL-OFFICE                 
MFA-TR*           AND DATE_CASH_REPORT  = :CS-DATE-CASH-REPORT                  
MFA-TR*           AND CASH_DRAWER_ID    = :CS-CASH-DRAWER-ID                    
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02007                                                                  
A02007     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A02007     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A02007        NEXT SENTENCE                                             
A02007     ELSE                                                         
A02007        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
A02007        MOVE SPACES                TO ABEND-SQL-PREDICATES,       
A02007                                      ABEND-TABLES                
A02007        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
A02007        MOVE '7300'                TO ACTIVE-PARAGRAPH            
A02007        MOVE 'SELECT'              TO ABEND-FUNCTION              
A02007        MOVE 'CSS_CSH_DRWR_CNTL'   TO TABLE-1                     
A02007        MOVE 'CASH_COMPANY_NO'     TO TABLE-ELEMENT-1             
A02007        MOVE 'CASH_LOCAL_OFFICE'   TO TABLE-ELEMENT-2             
A02007        MOVE 'DATE_CASH_REPORT'    TO TABLE-ELEMENT-3             
A02007        MOVE 'CASH_DRAWER_ID'      TO TABLE-ELEMENT-4             
A02007        MOVE CS-CASH-COMPANY-NO    TO HOSTVAR-ELEMENT-1           
A02007        MOVE CS-CASH-LOCAL-OFFICE  TO HOSTVAR-ELEMENT-2           
A02007        MOVE CS-DATE-CASH-REPORT   TO HOSTVAR-ELEMENT-3           
A02007        MOVE CS-CASH-DRAWER-ID     TO HOSTVAR-ELEMENT-4           
A02007     END-IF.                                                      
A02007                                                                  
A02007 7300-EXIT.                                                       
A02007     EXIT.                                                        
      *                                                                         
      * 7999-CHECK AR-LOCKOUT                                                   
PCR640     EXEC SQL                                                             
PCR640         INCLUDE CPD00075                                                 
PCR640     END-EXEC.                                                            
      *                                                                         
T24436******************************************************************        
T24436* 9350-LINK-SCSCO061.                                            *        
T24436* LOADING GL NUMBERS - CALLS THE SUBPROGRAM SCSCO061             *        
T24436******************************************************************        
T24436*                                                                         
T24436 9350-LINK-SCSCO061.                                              
T24436*                                                                         
T24436     MOVE SPACES                        TO ABEND-FUNCTION.        
T24436     PERFORM 9400-CALL-CPD00061         THRU 9400-EXIT.           
T24436     MOVE RS-RETURN-CODE                TO WS-ACTIVE-RETURN-CODE, 
T24436                                           SQLCODE.               
T24436     IF ABEND-FUNCTION  > SPACES                                  
T24436        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
T24436     END-IF.                                                      
T24436                                                                  
T24436 9350-EXIT.                                                       
T24436     EXIT.                                                        
T24436*                                                                         
T24436******************************************************************        
T24436* 9400-CALL-CPD00061 - CALLS THE COPYBOOK CPD00061               *        
T24436******************************************************************        
T24436*                                                                         
T24436 9400-CALL-CPD00061.                                              
T24436                                                                  
REARCH     CALL MCSCO061  USING  WS-GL-ACCT-NAME                        
REARCH                           WS-GL-ACCT-MAJOR-FIELDS                
REARCH                           WS-VALID-COMPANY-NOS                   
REARCH                           WS-GL-NAME-INFO                        
REARCH                           WS-GL-ACCT-NO-TABLE                    
REARCH                           ABEND-FILE                             
REARCH                           RS-RETURN-CODE.                        
REARCH     MOVE RS-RETURN-CODE            TO WS-ACTIVE-RETURN-CODE,     
REARCH                                       S-RETURN-CODE.             
REARCH     IF ABEND-FUNCTION  > SPACES                                  
REARCH        IF ABEND-FUNCTION EQUAL 'BADDATA'                         
REARCH           MOVE -1                  TO RS-RETURN-CODE,            
REARCH                                       WS-ACTIVE-RETURN-CODE      
REARCH        END-IF                                                    
REARCH        PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
REARCH        PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT             
REARCH     END-IF.                                                      
T24436                                                                  
T24436 9400-EXIT.                                                       
T24436     EXIT.                                                        
T24436*                                                                         
T24436     EXEC SQL                                                             
T24436        INCLUDE CPD0023C                                                  
T24436     END-EXEC.                                                            
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000       ADD 1 TO CTR-ROWS.                                         
CVT000 8100-EXIT.                                                       
CVT000        EXIT.                                                     
CVT000     EXEC SQL                                                             
CVT000         INCLUDE CPD00321                                                 
CVT000     END-EXEC.                                                            
