       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02317.                                         
COB303 DATE-WRITTEN.    JUNE 28, 2005.                                  
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S317 CONVERTED TO DB2 SP CSR02317 ON 05/27/2005        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************        
      ****             SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S317                                           *        
      *  PROGRAM:       S317                                           *        
      *  CALLING SP:    PA_S317                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *        
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *        
      *  THIS PROGRAM RETRIEVES THE DATA DISPLAYED IN TOP WINDOW OF    *        
      *  PANEL275 WHICH INVOLVES TABLES  AC.                           *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  01/30/96  SD                                                  *        
      *  09/25/96  PD         PCR072. COMMENT CIAC CODE.               *        
      *  10/21/97  MJG        IF THE PYMT_PRIORITY_LVL IS 90 BUT THE   *        
      *                       ITEM ID IS NOT IN THE 40000000 RANGE THENA        
      *                       IT IS A DPP.                             *        
CBSI  *  12/21/98  CBSI       ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *            MADRAS     ABEND PARAMETERS                         *        
REARCH*  06/28/05  CVNS       RPC TO DB2 COBOL CONVERSION              *        
REARCH*            CHENNAI                                             *        
T35434*  10/30/07  MK92804    REPLACED CSS_MODEL_SQL WITH SET STMTS    *        
T35434*                       AND ADDED FOR FETCH ONLY WITH UR FOR     *        
T35434*                       CURSOR SELECTS AND WITH UR FOR SINGLETON *        
T35434*                       SELECTS.                                 *        
P00453*  06/15/11  SP95538    MOVE PRP TO REC-TYPE FOR PRE-PAY-PLAN    *        
P00453*                       ACCOUNTS.                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02317'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02317 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBARCNTL                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBARTYPE                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBDFAACT                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *--------< CONTAINS THE COBOL EQUATES NEEDED FOR USING THE >              
      *--------< SYBASE OPEN SERVER FOR CICS FACILITIES.         >              
CVT999*    COPY SYGWCOB.                                                        
                                                                        
      *--------< ADDED TO SUPPORT CICS RPCS >                                   
CVT999*    COPY SYDBCOB.                                                        
                                                                        
      *--------<COMMON SYSTEM AREA >                                            
           COPY CCA00001.                                                       
                                                                        
      *--------< ERROR HANDLING >                                               
CVT999*    COPY CWS00010.                                                       
                                                                        
      *--------< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >               
           COPY CWS00027.                                                       
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                          
           COPY CWS00303.                                                       
                                                                        
           COPY CWS00056.                                                       
                                                                        
       01  WS-MISC.                                                     
           05 WS-ACCOUNT-NO            PIC X(13).                       
           05 WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO                 
                                       PIC 9(13).                       
           05 WS-DATE-25-DAYS-AGO      PIC X(10) VALUE SPACES.          
           05 PROGRAM-NAME             PIC X(08) VALUE 'S317    '.      
      *                                                                         
       01  WS-NULL-INDICATORS.                                          
           05 WS-DA-NULL-IND-1         PIC S9(4) COMP.                  
           05 WS-DA-NULL-IND-2         PIC S9(4) COMP.                  
           05 WS-AT-NULL-IND-1         PIC S9(4) COMP.                  
           05 WS-AT-NULL-IND-2         PIC S9(4) COMP.                  
           05 WS-AT-NULL-IND-3         PIC S9(4) COMP.                  
           05 WS-AT-NULL-IND-4         PIC S9(4) COMP.                  
      *                                                                         
       01  WS-GL-PPL-TABLE.                                             
           05  WS-NSC                  PIC S9(04) VALUE +19.            
           05  WS-NSA                  PIC S9(04) VALUE +20.            
           05  WS-NSN                  PIC S9(04) VALUE +29.            
           05  WS-LPC                  PIC S9(04) VALUE +30.            
           05  WS-LPN                  PIC S9(04) VALUE +39.            
           05  WS-UTE                  PIC S9(04) VALUE +40.            
           05  WS-UTG                  PIC S9(04) VALUE +45.            
           05  WS-UTW                  PIC S9(04) VALUE +47.            
           05  WS-EPP                  PIC S9(04) VALUE +50.            
           05  WS-RCC                  PIC S9(04) VALUE +60.            
           05  WS-CIA                  PIC S9(04) VALUE +70.            
           05  WS-DEP                  PIC S9(04) VALUE +80.            
           05  WS-DFA                  PIC S9(04) VALUE +90.            
           05  WS-CNT                  PIC S9(04) VALUE +100.           
           05  WS-PJS                  PIC S9(04) VALUE +129.           
           05  WS-DPP                  PIC X(03)  VALUE 'DPP'.          
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
      *                                                                 00052000
HPCCDM*    EJECT                                                        00096000
REARCH*01  GW-LIB-MISC-FIELDS.                                                  
CVT999*    05  GWL-PROC                POINTER.                                 
CVT999*    05  GWL-INIT-HANDLE         POINTER.                                 
CVT999*    05  GWL-RC                  PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-NR           PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-DONE         PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-COUNT        PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-COMM         PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-RETURN-CODE  PIC S9(9) COMP.                          
REARCH*    05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                          
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH      05  GTT-NAME                PIC X(26)                       
REARCH                                  VALUE 'SESSION.CSR02317_R1'.    
REARCH      05  GTT-ROW.                                                
REARCH          49 GTT-ROW-LEN          PIC S9(04) COMP.                
REARCH          49 GTT-ROW-CHAR         PIC X(1024).                    
REARCH      05  GTT-SQLCODE             PIC S9(9) COMP.                 
      *                                                                         
REARCH*01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.           
                                                                        
CVT999*01  PARM-FIELDS.                                                         
CVT999*    05  PARM-L                  PIC S9(9) COMP.                          
CVT999*    05  PARM-ID1                PIC S9(9) COMP VALUE 1.                  
CVT999*    05  PARM-ACCOUNT-NO         PIC X(13).                               
CVT999*                                                                         
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
CVT999*    05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.                  
                                                                        
       01  COUNTER-FIELDS.                                              
CVT999*    05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.                  
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
CVT999*    05  MAX-LENGTH-PARM         PIC S9(9) COMP.                          
CVT999*    05  WRKLEN1                 PIC S9(9) COMP.                          
CVT999*    05  WRKLEN2                 PIC S9(9) COMP.                          
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
            05 RS-RETURN-CODE         PIC S9(9) COMP VALUE 0.           
            05 RS-REC-TYPE            PIC X(03)      VALUE SPACES.      
            05 RS-ITEM-ID             PIC S9(9) COMP VALUE ZEROES.      
            05 RS-FULL-BALANCE        PIC S999999999V99 COMP-3          
                                                     VALUE ZEROES.      
            05 RS-BILLED-BALANCE      PIC S999999999V99 COMP-3          
                                                     VALUE ZEROES.      
            05 RS-ARREARS-BALANCE     PIC S999999999V99 COMP-3          
                                                     VALUE ZEROES.      
            05 RS-LAST-UPDATE-TS      PIC X(26)      VALUE SPACES.      
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH      05 S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
REARCH      05 S-REC-TYPE             PIC X(03)      VALUE SPACES.      
REARCH      05 S-ITEM-ID              PIC S9(9) COMP VALUE ZEROES.      
REARCH      05 S-FULL-BALANCE         PIC S999999999V99 COMP-3          
REARCH                                               VALUE ZEROES.      
REARCH      05 S-BILLED-BALANCE       PIC S999999999V99 COMP-3          
REARCH                                               VALUE ZEROES.      
REARCH      05 S-ARREARS-BALANCE      PIC S999999999V99 COMP-3          
REARCH                                               VALUE ZEROES.      
REARCH      05 S-LAST-UPDATE-TS       PIC X(26)      VALUE SPACES.      
REARCH                                                                  
CVT999*01  CNS-COLUMN-NAMES.                                                    
CVT999*     05 CNS-RETURN-CODE        PIC X(11) VALUE 'RETURN_CODE'.            
CVT999*     05 CNS-REC-TYPE           PIC X(10) VALUE 'RECVL_NAME'.             
CVT999*     05 CNS-ITEM-ID            PIC X(07) VALUE 'ITEM_ID'.                
CVT999*     05 CNS-FULL-BALANCE       PIC X(08) VALUE 'FULL_BAL'.               
CVT999*     05 CNS-BILLED-BALANCE     PIC X(10) VALUE 'BILLED_BAL'.             
CVT999*     05 CNS-ARREARS-BALANCE    PIC X(11) VALUE 'ARREARS_BAL'.            
CVT999*     05 CNS-LAST-UPDATE-TS     PIC X(11) VALUE 'LAST_UPD_TS'.            
CVT999*                                                                         
CVT999***************************************************************           
CVT999*     DECLARE CURSOR FOR FETCHING DATA FROM CSS_AR_TRANS_HIST *           
CVT999****@**********************************************************           
CVT999*                                                                         
           EXEC SQL                                                     
             DECLARE AR-CNTL-CUR CURSOR FOR                             
                 SELECT AMT_AR_DAY_00,                                  
                        AMT_AR_DAY_30,                                  
                        AMT_AR_DAY_60,                                  
                        AMT_AR_DAY_90,                                  
                        AMT_TRAN_BALANCE,                               
                        AMT_UNUSED_CR,                                  
                        ITEM_ID,                                        
                        REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,                        
                        PYMT_PRIORITY_LVL,                              
                        TOT_SUMM_UNBILLED                               
                 FROM   CSS_AR_CNTL WITH(READUNCOMMITTED)                       
                 WHERE  ACCOUNT_NO    = :AC-ACCOUNT-NO                  
                 ORDER  BY PYMT_PRIORITY_LVL ASC, ITEM_ID ASC           
T35434           FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE AR-CNTL-CUR CURSOR FOR                                     
MFA-TR*          SELECT AMT_AR_DAY_00,                                          
MFA-TR*                 AMT_AR_DAY_30,                                          
MFA-TR*                 AMT_AR_DAY_60,                                          
MFA-TR*                 AMT_AR_DAY_90,                                          
MFA-TR*                 AMT_TRAN_BALANCE,                                       
MFA-TR*                 AMT_UNUSED_CR,                                          
MFA-TR*                 ITEM_ID,                                                
MFA-TR*                 LAST_UPDATE_TS,                                         
MFA-TR*                 PYMT_PRIORITY_LVL,                                      
MFA-TR*                 TOT_SUMM_UNBILLED                                       
MFA-TR*          FROM   CSS_AR_CNTL                                             
MFA-TR*          WHERE  ACCOUNT_NO    = :AC-ACCOUNT-NO                          
MFA-TR*          ORDER  BY PYMT_PRIORITY_LVL ASC, ITEM_ID ASC                   
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
HPCCDM*EJECT                                                                    
      *                                                                         
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
REARCH*    10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        00001701
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         DECLARE C1 CURSOR  FOR                        
CVT000         SELECT *                                                 
CVT000         FROM #CSR02317_R1                                 
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00000100
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        00000300
MFA-TR*        SELECT *                                                 00000400
MFA-TR*        FROM SESSION.CSR02317_R1                                 00000500
MFA-TR*    END-EXEC.                                                    00000700
CVT000                                                                  
                                                                        
CVT000 LINKAGE SECTION.                                                 
CVT000 01  PARM-ACCOUNT-NO          PIC X(13)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          PARM-ACCOUNT-NO                                         
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                                      
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
CVT999*    EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.                      
                                                                        
CVT999*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.             
                                                                        
CVT999*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,             
CVT999*                          SNA-CONNECTION-NAME, SNA-SUBC.                 
                                                                        
CVT999*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                              
                                                                        
CVT999*    IF GWL-RC NOT = TDS-PARM-PRESENT                                     
CVT999*       MOVE PROGRAM-NAME         TO ABEND-PROGRAM                        
CVT999*       MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION              
CVT999*       MOVE 'CICS TRANSACTION'   TO TABLE-1                              
CVT999*       MOVE GWL-RC               TO WS-ACTIVE-RETURN-CODE                
CVT999*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
CVT999*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
CVT999*    END-IF.                                                              
                                                                        
CVT000     PERFORM 0100A-DECLARE-GTT                                    
CVT000       THRU 0100A-EXIT.                                           
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
CVT000 0100A-DECLARE-GTT.                                               
CVT000     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02317_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02317_R1
              (                                                          
CVT000         RETURN_CODE              INT                         
REARCH        ,RECVL_NAME CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2             
CVT000        ,ITEM_ID                  INT                         
REARCH        ,FULL_BAL                 DECIMAL(11,2)                   
REARCH        ,BILLED_BAL               DECIMAL(11,2)                   
REARCH        ,ARREARS_BAL              DECIMAL(11,2)                   
REARCH        ,LAST_UPD_TS CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2            
CVT000       )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH     MOVE SQLSTATE TO WS-SQLSTATE.                                
REARCH     MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
REARCH                                                                  
REARCH     IF WS-SQLSTATE = '42710'                                     
REARCH        PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
REARCH     ELSE                                                         
REARCH         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
REARCH             NEXT SENTENCE                                        
REARCH         ELSE                                                     
REARCH            MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
REARCH            MOVE SQLCODE              TO ABEND-SQLCODE            
REARCH            MOVE SQLSTATE             TO ABEND-SQLSTATE           
REARCH            MOVE '0100A'               TO ACTIVE-PARAGRAPH        
REARCH            MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
REARCH            MOVE SPACES               TO ABEND-SQL-PREDICATES     
REARCH                                         ABEND-TABLES             
REARCH            MOVE 'CSR02317_R1'        TO TABLE-1                  
REARCH            MOVE SPACES               TO TABLE-ELEMENT-1          
REARCH            MOVE SPACES               TO HOSTVAR-ELEMENT-1        
REARCH            PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
REARCH         END-IF                                                   
REARCH     END-IF.                                                      
CVT000 0100A-EXIT.                                                      
CVT000         EXIT.                                                    
                                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     CALLS 1100-RECEIVE-PARMS                                   *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
      *                                                                         
REARCH*    PERFORM 1100-RECEIVE-PARMS THRU 1100-EXIT.                           
           MOVE PARM-ACCOUNT-NO       TO WS-ACCOUNT-NO.                 
           MOVE WS-ACCOUNT-NO-NUM     TO AC-ACCOUNT-NO                  
                                         AT-ACCOUNT-NO.                 
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1100-RECEIVE-PARMS                                             *        
      *     CALLS TDRCVPRM                                             *        
      *                                                                *        
      *     CALLED FROM 1000-PROCESS-INPUT                             *        
      *                                                                *        
      *     GET THE PASSED PARMS FROM THE CLIENT                       *        
      ******************************************************************        
                                                                        
REARCH*1100-RECEIVE-PARMS.                                                      
                                                                        
CVT999*    MOVE 1                               TO PARM-ID1.                    
CVT999*    MOVE LENGTH OF PARM-ACCOUNT-NO       TO MAX-LENGTH-PARM.             
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-ACCOUNT-NO,                               
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
REARCH*1100-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     CALLS 2100-DESCRIBE-RESULT                                 *        
      *           2200-BUILD-RESULT-AR                                 *        
      *     CALLED FROM 0000-MAINLINE                                 *         
      *                                                                *        
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *        
      *      AND SENDS THEM BACK                                       *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                           TO ACTIVE-PARAGRAPH.   
REARCH*    PERFORM 2100-DESCRIBE-RESULT          THRU 2100-EXIT.                
           PERFORM 2200-BUILD-RESULT-AR          THRU 2200-EXIT.        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-DESCRIBE-RESULT                                          *         
      *                                                               *         
      *     CALLS 2110-DESC-RET-CODE                                  *         
      *           2140-DESC-AR-DATA                                   *         
      *     CALLED FROM 2000-PROCESS-OUTPUT                           *         
      *                                                               *         
      *      DESCRIBE EACH RESULT FIELD TO THE CLIENT                 *         
      ******************************************************************        
                                                                        
REARCH*2100-DESCRIBE-RESULT.                                                    
REARCH*                                                                         
REARCH*    MOVE '2110'                             TO ACTIVE-PARAGRAPH.         
REARCH*    PERFORM 2110-DESC-RET-CODE              THRU 2110-EXIT.              
REARCH*    PERFORM 2140-DESC-AR-DATA               THRU 2140-EXIT.              
REARCH*2100-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 2110-DESC-RET-CODE                                             *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE RET-CODE    FIELD TO THE CLIENT                   *        
      ******************************************************************        
                                                                        
REARCH*2110-DESC-RET-CODE.                                                      
                                                                        
REARCH*    MOVE '2110'                       TO ACTIVE-PARAGRAPH.               
CVT999*    MOVE 1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSINT4                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSINT4                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-RETURN-CODE     TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-RETURN-CODE    TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RETURN-CODE,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-RETURN-CODE,                               
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
REARCH*2110-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 2140-DESC-AR-DATA                                              *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE BILLING HEADER RESULT FIELDS TO THE CLIENT        *        
      *                                                                *        
      ******************************************************************        
                                                                        
REARCH*2140-DESC-AR-DATA.                                                       
REARCH*    MOVE '2140'                          TO ACTIVE-PARAGRAPH.            
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-REC-TYPE           TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-REC-TYPE          TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-REC-TYPE,                                   
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-REC-TYPE,                                  
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSINT4                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSINT4                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-ITEM-ID            TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-ITEM-ID           TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-ITEM-ID,                                    
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-ITEM-ID,                                   
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDS-PACKED-DECIMAL              TO DB-HOST-TYPE.                
CVT999*    MOVE TDSFLT8                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-FULL-BALANCE       TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-FULL-BALANCE      TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-FULL-BALANCE,                               
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-FULL-BALANCE,                              
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    MOVE +2 TO WRKLEN2.                                                  
CVT999*    CALL 'TDSETBCD' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          TDS-OBJECT-COL,                                
CVT999*                          CTR-COLUMN,                                    
CVT999*                          WRKLEN1,                                       
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDS-PACKED-DECIMAL              TO DB-HOST-TYPE.                
CVT999*    MOVE TDSFLT8                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-BILLED-BALANCE     TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-BILLED-BALANCE    TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-BILLED-BALANCE,                             
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-BILLED-BALANCE,                            
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    MOVE +2 TO WRKLEN2.                                                  
CVT999*    CALL 'TDSETBCD' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          TDS-OBJECT-COL,                                
CVT999*                          CTR-COLUMN,                                    
CVT999*                          WRKLEN1,                                       
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDS-PACKED-DECIMAL              TO DB-HOST-TYPE.                
CVT999*    MOVE TDSFLT8                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-ARREARS-BALANCE       TO WRKLEN1.                  
CVT999*    MOVE LENGTH OF CNS-ARREARS-BALANCE      TO WRKLEN2.                  
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-ARREARS-BALANCE,                            
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-ARREARS-BALANCE,                           
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    MOVE +2 TO WRKLEN2.                                                  
CVT999*    CALL 'TDSETBCD' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          TDS-OBJECT-COL,                                
CVT999*                          CTR-COLUMN,                                    
CVT999*                          WRKLEN1,                                       
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-LAST-UPDATE-TS     TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-LAST-UPDATE-TS    TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-LAST-UPDATE-TS,                             
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-LAST-UPDATE-TS,                            
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
REARCH*2140-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      *    2200-BUILD-RESULT-AR                                        *        
      *                                                                *        
      *    CALLED FROM 2000-PROCESS-OUTPUT                             *        
      *                                                                *        
      *    OPENS AND CLOSES THE AR CURSOR                              *        
      ******************************************************************        
REARCH*2000A-MOVE-RESULT.                                                       
REARCH******************************************************************        
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE RS-RETURN-CODE         TO S-RETURN-CODE.                
REARCH     MOVE RS-REC-TYPE            TO S-REC-TYPE.                   
REARCH     MOVE RS-ITEM-ID             TO S-ITEM-ID.                    
REARCH     MOVE RS-FULL-BALANCE        TO S-FULL-BALANCE.               
REARCH     MOVE RS-BILLED-BALANCE      TO S-BILLED-BALANCE.             
REARCH     MOVE RS-ARREARS-BALANCE     TO S-ARREARS-BALANCE.            
REARCH     MOVE RS-LAST-UPDATE-TS      TO S-LAST-UPDATE-TS.             
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH******************************************************************        
       2200-BUILD-RESULT-AR.                                            
                                                                        
           PERFORM 7000-SELECT-ACCOUNT   THRU 7000-EXIT.                
           PERFORM 7010-GET-25-DAYS-AGO  THRU 7010-EXIT.                
                                                                        
           PERFORM 7300-OPEN-AR-CNTL-CUR THRU 7300-EXIT.                
                                                                        
           PERFORM 7310-FETCH-AR-CNTL-CUR  THRU 7310-EXIT.              
                                                                        
           PERFORM 2210-PROCESS-AR-CNTL-CUR THRU 2210-EXIT              
           UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                     
                                                                        
           IF ( CTR-ROWS = 0 )                                          
REARCH        PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
           END-IF.                                                      
                                                                        
           PERFORM 7320-CLOSE-AR-CNTL-CUR THRU 7320-EXIT.               
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08721000
      *   2210-PROCESS-AR-CNTL-CUR.                                    *        
      *                                                                *        
      *   CALLED FROM 2200-BUILD-AR                                    *        
      *                                                                *        
      *   THIS PARAGRAPH FETCHES THE CSS_AR_TRAN_HIST CURSOR.          *        
      ******************************************************************        
                                                                        
       2210-PROCESS-AR-CNTL-CUR.                                        
           MOVE '2210' TO ACTIVE-PARAGRAPH.                             
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              GO TO 2210-EXIT                                           
           END-IF.                                                      
                                                                        
           MOVE AC-LAST-UPDATE-TS        TO RS-LAST-UPDATE-TS.          
                                                                        
      *******************                                                       
      * GET A/R TYPE AND DESCRIPTION                                            
      *******************                                                       
           MOVE AC-PYMT-PRIORITY-LVL TO L5-PYMT-PRIORITY-LVL.           
                                                                        
           PERFORM 2315-GET-REC-DESC THRU 2315-EXIT.                    
                                                                        
      *******************                                                       
      * LOADING DETAIL LINES                                                    
      *******************                                                       
      * BILL AMOUNT:  00 + 30 + 60 + 90 + UNUSED                                
      * FULL BALANCE:                                                           
      *      W/O TRD: 00 + 30 + 60 + 90 + UNUSED                                
      *      W/TRD:   TRAN-BALANCE                                              
      *******************                                                       
           IF (AC-ITEM-ID = 0 AND                                       
PCR072*       (AC-PYMT-PRIORITY-LVL = 0      OR                                 
              (AC-PYMT-PRIORITY-LVL = WS-NSC OR                         
               AC-PYMT-PRIORITY-LVL = WS-NSA OR                         
               AC-PYMT-PRIORITY-LVL = WS-NSN OR                         
               AC-PYMT-PRIORITY-LVL = WS-LPC OR                         
               AC-PYMT-PRIORITY-LVL = WS-LPN OR                         
               AC-PYMT-PRIORITY-LVL = WS-UTE OR                         
               AC-PYMT-PRIORITY-LVL = WS-UTG OR                         
               AC-PYMT-PRIORITY-LVL = WS-UTW))                          
                                                                        
              MOVE ZEROES TO RS-ITEM-ID                                 
              ADD AC-AMT-AR-DAY-00                                      
                  AC-AMT-AR-DAY-30                                      
                  AC-AMT-AR-DAY-60                                      
                  AC-AMT-AR-DAY-90                                      
                  AC-AMT-UNUSED-CR GIVING RS-BILLED-BALANCE             
                                          RS-FULL-BALANCE               
              IF AC-TOT-SUMM-UNBILLED GREATER THAN ZEROES               
                 ADD AC-TOT-SUMM-UNBILLED TO RS-FULL-BALANCE            
              END-IF                                                    
                                                                        
              PERFORM 2350-CALC-ARREARS    THRU 2350-EXIT               
REARCH        PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT              
              PERFORM 8100-SEND-RESULT     THRU 8100-EXIT               
                                                                        
           ELSE                                                         
              IF AC-ITEM-ID GREATER THAN ZEROES                         
                 PERFORM 2330-LOAD-MAP-FROM-DETAIL THRU 2330-EXIT       
              END-IF                                                    
           END-IF                                                       
                                                                        
           PERFORM 7310-FETCH-AR-CNTL-CUR  THRU 7310-EXIT.              
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
                                                                        
HPCCDM*EJECT                                                                    
      *                                                                         
       2330-LOAD-MAP-FROM-DETAIL.                                       
           MOVE '2330' TO ACTIVE-PARAGRAPH.                             
                                                                        
           IF AC-PYMT-PRIORITY-LVL = WS-EPP OR                          
              AC-PYMT-PRIORITY-LVL = WS-RCC OR                          
              AC-PYMT-PRIORITY-LVL = WS-CIA OR                          
              AC-PYMT-PRIORITY-LVL = WS-CNT OR                          
              AC-PYMT-PRIORITY-LVL = WS-DEP OR                          
              AC-PYMT-PRIORITY-LVL = WS-DFA OR                          
              AC-PYMT-PRIORITY-LVL = WS-PJS                             
                                                                        
              MOVE AC-ITEM-ID      TO RS-ITEM-ID                        
                                                                        
              IF AC-PYMT-PRIORITY-LVL = WS-DFA                          
                 PERFORM 2332-SELECT-DFA-ACCT   THRU 2332-EXIT          
              END-IF                                                    
                                                                        
              ADD AC-AMT-AR-DAY-00                                      
                  AC-AMT-AR-DAY-30                                      
                  AC-AMT-AR-DAY-60                                      
                  AC-AMT-AR-DAY-90                                      
                  AC-AMT-UNUSED-CR GIVING RS-BILLED-BALANCE             
                                                                        
              MOVE AC-AMT-TRAN-BALANCE TO RS-FULL-BALANCE               
                                                                        
              PERFORM 2350-CALC-ARREARS    THRU 2350-EXIT               
REARCH        PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT              
              PERFORM 8100-SEND-RESULT     THRU 8100-EXIT               
           END-IF.                                                      
                                                                        
       2330-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2332-SELECT-DFA-ACCT.                                            
           MOVE '2350' TO ACTIVE-PARAGRAPH.                             
                                                                        
           MOVE AC-ACCOUNT-NO        TO DA-ACCOUNT-NO.                  
           MOVE AC-PYMT-PRIORITY-LVL TO DA-PYMT-PRIORITY-LVL.           
           MOVE AC-ITEM-ID           TO DA-DFA-ITEM-ID.                 
           PERFORM 7260-SELECT-DFA   THRU 7260-EXIT.                    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
             IF DA-CODE-DFA-TYPE = 'B'                                  
                MOVE WS-DPP      TO RS-REC-TYPE                         
             END-IF                                                     
           END-IF.                                                      
       2332-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2350-CALC-ARREARS.                                               
           MOVE '2350' TO ACTIVE-PARAGRAPH.                             
                                                                        
           MOVE ZEROES                 TO RS-ARREARS-BALANCE.           
                                                                        
           IF AT-DATE-BILL-DAY-30 LESS THAN WS-DATE-25-DAYS-AGO         
              COMPUTE RS-ARREARS-BALANCE = AC-AMT-AR-DAY-30 +           
                                           AC-AMT-AR-DAY-60 +           
                                           AC-AMT-AR-DAY-90             
           ELSE                                                         
              IF AT-DATE-BILL-DAY-60 LESS THAN WS-DATE-25-DAYS-AGO      
                 COMPUTE RS-ARREARS-BALANCE = AC-AMT-AR-DAY-60 +        
                                              AC-AMT-AR-DAY-90          
              ELSE                                                      
                IF AT-DATE-BILL-DAY-90 LESS THAN WS-DATE-25-DAYS-AGO    
                   MOVE AC-AMT-AR-DAY-90    TO RS-ARREARS-BALANCE       
                END-IF                                                  
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*EJECT                                                                    
      *                                                                         
       2315-GET-REC-DESC.                                               
           MOVE '2315' TO ACTIVE-PARAGRAPH.                             
                                                                        
           PERFORM 7150-SELECT-AR-TYPE THRU 7150-EXIT.                  
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00453        IF AT-CODES-DATA-PRESENT(15:1) = 'A'                      
P00453           AND L5-AR-TYPE-SHORT-DESC = 'BBP'                      
P00453           MOVE 'PRP'              TO RS-REC-TYPE                 
P00453        ELSE                                                      
                 MOVE L5-AR-TYPE-SHORT-DESC TO RS-REC-TYPE              
P00453        END-IF                                                    
           ELSE                                                         
              MOVE SPACES                TO RS-REC-TYPE                 
           END-IF.                                                      
       2315-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7000-SELECT-ACCOUNT                                          *        
      *                                                                *        
      *   THIS PARAGRAPH IS USED TO SELCET BILL DATES FOR ARREAR       *        
      *   CALCULATION FROM CSS_ACCOUNT                                 *        
      ******************************************************************        
       7000-SELECT-ACCOUNT.                                             
           EXEC SQL                                                     
              SELECT DATE_BILL_DAY_00,                                  
                     DATE_BILL_DAY_30,                                  
                     DATE_BILL_DAY_60,                                  
                     DATE_BILL_DAY_90,                                  
P00453               CODES_DATA_PRESENT                                 
                INTO :AT-DATE-BILL-DAY-00 :WS-AT-NULL-IND-1,             
                     :AT-DATE-BILL-DAY-30 :WS-AT-NULL-IND-2,             
                     :AT-DATE-BILL-DAY-60 :WS-AT-NULL-IND-3,             
P00453               :AT-DATE-BILL-DAY-90 :WS-AT-NULL-IND-4,             
P00453               :AT-CODES-DATA-PRESENT                             
              FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                            
              WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                         
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DATE_BILL_DAY_00,                                          
MFA-TR*              DATE_BILL_DAY_30,                                          
MFA-TR*              DATE_BILL_DAY_60,                                          
MFA-TR*              DATE_BILL_DAY_90,                                          
MFA-TR*              CODES_DATA_PRESENT                                         
MFA-TR*         INTO :AT-DATE-BILL-DAY-00:WS-AT-NULL-IND-1,                     
MFA-TR*              :AT-DATE-BILL-DAY-30:WS-AT-NULL-IND-2,                     
MFA-TR*              :AT-DATE-BILL-DAY-60:WS-AT-NULL-IND-3,                     
MFA-TR*              :AT-DATE-BILL-DAY-90:WS-AT-NULL-IND-4,                     
MFA-TR*              :AT-CODES-DATA-PRESENT                                     
MFA-TR*       FROM CSS_ACCOUNT                                                  
MFA-TR*       WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                 
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE.                              
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      * 7010-GET-25-DAYS-AGO                                                    
      *  GET DATE 25 DAYS AGO FROM NOW.                                         
      ***************************************************************           
       7010-GET-25-DAYS-AGO.                                            
           MOVE '7010' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
T35434        SELECT
              DATEADD( DAY, -25, CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-DATE-25-DAYS-AGO         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-DATE-25-DAYS-AGO = CURRENT DATE - 25 DAYS                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7010'                    TO ACTIVE-PARAGRAPH        
T35434        MOVE 'SET'                     TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
CBSI          MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
CBSI          MOVE PARM-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   7300-OPEN-AR-CNTL-CURSOR                                     *        
      *                                                                *        
      *   THIS PARAGRAPH IS USED TO OPEN THE CURSOR USED TO FETCH      *        
      *   ROWS FROM THE CSS_AR_CNTL.                                   *        
      ******************************************************************        
                                                                        
       7300-OPEN-AR-CNTL-CUR.                                           
           EXEC SQL                                                     
               OPEN AR-CNTL-CUR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          RS-RETURN-CODE.               
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
CBSI          MOVE '7300'              TO ACTIVE-PARAGRAPH              
CBSI          MOVE 'OPEN'              TO ABEND-FUNCTION                
              MOVE 'CSS_AR_CNTL      ' TO TABLE-1                       
              MOVE 'ACCOUNT_NO    '    TO TABLE-ELEMENT-1               
              MOVE AC-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7300-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
                                                                        
      ******************************************************************        
      *   7310-FETCH-AR-CNTL-CUR                                       *        
      *                                                                *        
      *   THIS PARAGRAPH IS USED TO OBTAIN THE NEXT ROW FROM THE       *        
      *   CSS_AR_CNTL      TABLE                                       *        
      ******************************************************************        
                                                                        
       7310-FETCH-AR-CNTL-CUR.                                          
      *                                                                         
           EXEC SQL                                                     
               FETCH AR-CNTL-CUR                                        
               INTO :AC-AMT-AR-DAY-00,                                  
                    :AC-AMT-AR-DAY-30,                                  
                    :AC-AMT-AR-DAY-60,                                  
                    :AC-AMT-AR-DAY-90,                                  
                    :AC-AMT-TRAN-BALANCE,                               
                    :AC-AMT-UNUSED-CR,                                  
                    :AC-ITEM-ID,                                        
                    :AC-LAST-UPDATE-TS,                                 
                    :AC-PYMT-PRIORITY-LVL,                              
                    :AC-TOT-SUMM-UNBILLED                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          RS-RETURN-CODE.               
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                                         OR NOT-FOUND                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
CBSI          MOVE '7310'              TO ACTIVE-PARAGRAPH              
CBSI          MOVE 'FETCH'             TO ABEND-FUNCTION                
              MOVE 'CSS_AR_CNTL      ' TO TABLE-1                       
              MOVE 'ACCOUNT_NO    '    TO TABLE-ELEMENT-1               
              MOVE AC-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7310-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
                                                                        
      ******************************************************************        
      *   7320-CLOSE-AR-CNTL-CUR                                       *        
      *                                                                *        
      *   THIS PARAGRAPH IS USED TO CLOSE THE CURSOR USED TO CLOSE     *        
      *   CURSOR OF THE CSS_AR_CNTL       TABLE                        *        
      ******************************************************************        
       7320-CLOSE-AR-CNTL-CUR.                                          
      *                                                                         
           EXEC SQL                                                     
               CLOSE AR-CNTL-CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          RS-RETURN-CODE.               
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE '7320'                     TO ACTIVE-PARAGRAPH       
CBSI          MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE 'CSS_AR_CNTL      '        TO TABLE-1                
              MOVE 'ACCOUNT_NO    '           TO TABLE-ELEMENT-1        
              MOVE AC-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
       7150-SELECT-AR-TYPE.                                             
           EXEC SQL                                                     
              SELECT AR_TYPE_SHORT_DESC,                                
                     AR_TYPE_LONG_DESC                                  
              INTO   :L5-AR-TYPE-SHORT-DESC,                            
                     :L5-AR-TYPE-LONG-DESC                              
              FROM CSS_AR_TYPE WITH(READUNCOMMITTED)                            
              WHERE PYMT_PRIORITY_LVL = :L5-PYMT-PRIORITY-LVL           
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AR_TYPE_SHORT_DESC,                                        
MFA-TR*              AR_TYPE_LONG_DESC                                          
MFA-TR*       INTO   :L5-AR-TYPE-SHORT-DESC,                                    
MFA-TR*              :L5-AR-TYPE-LONG-DESC                                      
MFA-TR*       FROM CSS_AR_TYPE                                                  
MFA-TR*       WHERE PYMT_PRIORITY_LVL = :L5-PYMT-PRIORITY-LVL                   
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE.                              
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 IF L5-PYMT-PRIORITY-LVL = 90 AND                       
                    AC-ITEM-ID < 40000000                               
                    MOVE WS-DPP      TO L5-AR-TYPE-SHORT-DESC           
                  END-IF                                                
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7150'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_AR_TYPE'         TO TABLE-1                     
CBSI          MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-1             
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
              MOVE L5-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-1           
CBSI          MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7260-SELECT-DFA.                                                 
           EXEC SQL                                                     
                SELECT AMT_MO_PYMT,                                     
                       DATE_PYMT_START,                                 
                       NO_SCHED_PYMTS,                                  
                       AMT_ORIG_ENTERED,                                
                       CODE_DFA_TYPE,                                   
                       FRST_ERNST_PAY_DT                                
                  INTO :DA-AMT-MO-PYMT,                                 
                       :DA-DATE-PYMT-START :WS-DA-NULL-IND-1,            
                       :DA-NO-SCHED-PYMTS,                              
                       :DA-AMT-ORIG-ENTERED,                            
                       :DA-CODE-DFA-TYPE,                               
                       :DA-FRST-ERNST-PAY-DT :WS-DA-NULL-IND-2           
                FROM   CSS_DFA_ACCT WITH(READUNCOMMITTED)                       
                WHERE  ACCOUNT_NO        = :DA-ACCOUNT-NO               
                AND    PYMT_PRIORITY_LVL = :DA-PYMT-PRIORITY-LVL        
                AND    DFA_ITEM_ID       = :DA-DFA-ITEM-ID              
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT AMT_MO_PYMT,                                             
MFA-TR*                DATE_PYMT_START,                                         
MFA-TR*                NO_SCHED_PYMTS,                                          
MFA-TR*                AMT_ORIG_ENTERED,                                        
MFA-TR*                CODE_DFA_TYPE,                                           
MFA-TR*                FRST_ERNST_PAY_DT                                        
MFA-TR*           INTO :DA-AMT-MO-PYMT,                                         
MFA-TR*                :DA-DATE-PYMT-START:WS-DA-NULL-IND-1,                    
MFA-TR*                :DA-NO-SCHED-PYMTS,                                      
MFA-TR*                :DA-AMT-ORIG-ENTERED,                                    
MFA-TR*                :DA-CODE-DFA-TYPE,                                       
MFA-TR*                :DA-FRST-ERNST-PAY-DT:WS-DA-NULL-IND-2                   
MFA-TR*         FROM   CSS_DFA_ACCT                                             
MFA-TR*         WHERE  ACCOUNT_NO        = :DA-ACCOUNT-NO                       
MFA-TR*         AND    PYMT_PRIORITY_LVL = :DA-PYMT-PRIORITY-LVL                
MFA-TR*         AND    DFA_ITEM_ID       = :DA-DFA-ITEM-ID                      
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE.                              
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7260'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_DFA_ACCT'        TO TABLE-1                     
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
CBSI          MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
CBSI          MOVE 'DFA_ITEM_ID'         TO TABLE-ELEMENT-3             
              MOVE DA-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE DA-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-2           
              MOVE DA-DFA-ITEM-ID        TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
       7260-EXIT.                                                       
           EXIT.                                                        
CVT000******************************************************************00000100
CVT000* 8000A-DELETE-GTT-ROWS.                                         *00000200
CVT000******************************************************************00000300
CVT000 8000A-DELETE-GTT-ROWS.                                           
CVT000*                                                                 00000500
CVT000     MOVE                                                         
CVT000     'DELETE ROWS'                                                
CVT000         TO S-SQL-STATEMENT-V.                                    
CVT000*                                                                 00000900
CVT000      EXEC SQL                                                    
CVT000          DELETE FROM #CSR02317_R1                         
CVT000      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    00001000
MFA-TR*         DELETE FROM SESSION.CSR02317_R1                         00001100
MFA-TR*     END-EXEC.                                                   00001200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000*                                                                 00001300
CVT000      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
CVT000*                                                                 00001500
CVT000      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
CVT000          NEXT SENTENCE                                           
CVT000      ELSE                                                        
CVT000         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
CVT000         MOVE '8000A'              TO ACTIVE-PARAGRAPH            
CVT000         MOVE 'DELETE'             TO ABEND-FUNCTION              
CVT000         MOVE SPACES               TO ABEND-SQL-PREDICATES        
CVT000                                      ABEND-TABLES                
CVT000         MOVE 'CSR02317_R1'        TO TABLE-1                     
CVT000         MOVE SPACES               TO TABLE-ELEMENT-1             
CVT000         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
CVT000         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
CVT000     END-IF.                                                      
CVT000*                                                                 00003100
CVT000 8000A-EXIT.                                                      
CVT000     EXIT.                                                        
CVT000*                                                                 00003400
REARCH******************************************************************        
REARCH*8100-SEND-RESULT.                                                        
REARCH******************************************************************        
CVT000 8100-SEND-RESULT.                                                
CVT000     EXEC SQL                                                     
CVT000       INSERT INTO #CSR02317_R1                            
CVT000       (                                                          
CVT000        RETURN_CODE                                               
REARCH       ,RECVL_NAME                                                
CVT000       ,ITEM_ID                                                   
REARCH       ,FULL_BAL                                                  
REARCH       ,BILLED_BAL                                                
REARCH       ,ARREARS_BAL                                               
REARCH       ,LAST_UPD_TS                                               
CVT000       )                                                          
CVT000       VALUES                                                     
CVT000       (                                                          
CVT000        :S-RETURN-CODE                                            
CVT000       ,:S-REC-TYPE                                               
CVT000       ,:S-ITEM-ID                                                
CVT000       ,:S-FULL-BALANCE                                           
CVT000       ,:S-BILLED-BALANCE                                         
CVT000       ,:S-ARREARS-BALANCE                                        
CVT000       ,:S-LAST-UPDATE-TS                                         
CVT000       )                                                          
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR02317_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,RECVL_NAME                                                        
MFA-TR*      ,ITEM_ID                                                           
MFA-TR*      ,FULL_BAL                                                          
MFA-TR*      ,BILLED_BAL                                                        
MFA-TR*      ,ARREARS_BAL                                                       
MFA-TR*      ,LAST_UPD_TS                                                       
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE                                                    
MFA-TR*      ,:S-REC-TYPE                                                       
MFA-TR*      ,:S-ITEM-ID                                                        
MFA-TR*      ,:S-FULL-BALANCE                                                   
MFA-TR*      ,:S-BILLED-BALANCE                                                 
MFA-TR*      ,:S-ARREARS-BALANCE                                                
MFA-TR*      ,:S-LAST-UPDATE-TS                                                 
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
CVT000                                                                  
CVT000     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
CVT000        NEXT SENTENCE                                             
CVT000     ELSE                                                         
CVT000        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CVT000         MOVE SQLCODE             TO ABEND-SQLCODE                
CVT000         MOVE SQLSTATE            TO ABEND-SQLSTATE               
CVT000        MOVE '8900'               TO ACTIVE-PARAGRAPH             
CVT000        MOVE 'INSERT'             TO ABEND-FUNCTION               
REARCH        MOVE 'CSR02317_R1'        TO TABLE-1                      
CVT000        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
CVT000     END-IF.                                                      
CVT000                                                                  
CVT000     ADD 1 TO CTR-ROWS.                                           
CVT000*    INITIALIZE GTT-RETURN-FIELDS.                                00001900
CVT000*                                                                 00002000
CVT000 8100-EXIT.                                                       
CVT000      EXIT.                                                       
HPCCDM*EJECT                                                                    
      *                                                                         
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
REARCH*    EXEC SQL                                                             
REARCH*       INCLUDE CPD00300                                                  
REARCH*    END-EXEC.                                                            
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
CVT999*    COPY CPD00302.                                                       
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00320                                         00000200
CVT000     END-EXEC.                                                    00000300
