       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02316.                                         
COB303 DATE-WRITTEN.     JAN 28, 1996.                                  
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S316 CONVERTED TO DB2 SP CSR02316 ON 05/27/2005        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALRESRPC).   *        
      *                                                                *        
      *  TRANID:        S316                                           *        
      *  PROGRAM:       S316                                           *        
      *  CALLING SP:    PA_S316                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *        
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *        
      *  THIS PROGRAM RETRIEVES ALL THE ACCOUNT CREDIT SUMMARY DETAILS,*        
      *  THAT CAN BE RETURNED AS A SINGLE ROW, TO PANEL121             *        
      *                                                                *        
      *  INPUT PARAMETERS                                              *        
      *  -------------------------                                     *        
      *  ACCOUNT-NUM         X(13)                                     *        
      *                                                                *        
      *  THE FOLLOWING TABLES ARE USED :                               *        
      *      TABLE NAME          DCLGEN NAME    2 CHAR ID              *        
      *      ------------------  -----------    ---------              *        
      *      CSS_ACCOUNT         TBACCT         AT                     *        
      *      CSS_CREDIT_PROFILE  TBCRPROF       CZ                     *        
      *      CSS_NSF_HIST        TBNSFHST       NH                     *        
      *      CSS_BILLING_HDR     TBBLLHDR       BI                     *        
      *      CSS_BILLING_DET     TBBLLDET       BG                     *        
      *      CSS_GUARANTOR       TBGTNTR        GU                     *        
      *      CSS_SURETY_BOND     TBSTYBND       SB                     *        
      *      CSS_DEP_ON_HAND     TBDEPHND       DO                     *        
      *      CSS_RECONNECT       TBRECNCT       DL                     *        
PCR361*      CSS_LOCAL_OFFICE    TBLOCOFC       B1                     *        
PERF  *      CSS_USER_PROFILE    TBUSRPRF       PF                     *        
T23179*      CSS_UTIL_ENVRNMT    TBUTLENV       UT                     *        
T23179*      CSS_RATE_CREATOR    TBRTCRTR       RT                     *        
C26296*      CSS_DEP_REQ         TBDEPREQ       DR                     *        
C26296*      CSS_AR_CNTL         TBARCNTL       AC                     *        
C33201*      CSS_REG_PROFILE     TBREGPRF       LR                     *        
C33201*      CSS_LOCAL_OFFICE    TBLOCOFC       B1                     *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  01/28/96    SD       CREATED.                                 *        
      *  09/24/96    MRB      PCR #361 - ADDED LOGIC TO CALL THE NEW   *        
      *                       COPYBOOK CPD00068.                       *        
TP8452*  03/04/97    JEP      TPR 8452 - CWS00308 AND CPD00308 WERE    *        
TP8452*                       ADDED TO HANDLE MAXIMUM DEPOSIT ESTIMATES*        
TP8452*                       IN ADDITION TO VARIABLES AND SUPPORTING  *        
TP8452*                       CODE. REMOVED CPD00122 AND CWS00122.     *        
      *  03/31/97    MJG      ADDED TWO ADDITIONAL DCLGENS THAT ARE    *        
      *                       NEEDED FOR CPD00068                      *        
T10290*  04/10/97    MAD      ADDED CSS_CUST_PREM_HIST DCLGEN TO       *        
T10290*                       SUPPORT CPD00308 CHANGES.                *        
T12460*  08/01/97    EMS      ADDED CSS_DNP DCLGEN FOR CPD68 CHANGES.  *        
T16853*  06/23/98    EMS      ADDED TBARHDT DCLGEN FOR CPD68 CHANGES.  *        
T17856*  09/24/98    SHF      MOVED CWS00308 INCLUDE TO END OF WS.     *        
T17071*  11/19/98    MDJ      ADDED TBCSTALT FOR CUST_ALERT FOR CPD00068        
CBSI  *  01/08/99    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *              MADRAS   ABEND PARAMETERS                         *        
T19557*  02/24/00    CBSI     COPYBOOK CDP00068 CHANGED TO SUB PROGRAM *        
T19557*              MADRAS   SCSCO068.                                *        
T22359*  06/23/00    ZB17046  MADE CHANGES TO KEEP IDENTITY OF PROGRAM *        
T22359*                       CALLING SCSCO068 OR SCSCB068.  THERE IS  *        
T22359*                       SPECIFIC LOGIC IN CPD00068 FOR CERTAIN   *        
T22359*                       PROGRAMS WHICH WAS NOT BEING EXECUTED    *        
T22359*                       PROPERLY BECAUSE THE PROGRAM NAME WAS    *        
T22359*                       ALWAYS SCSCO068 OR SCSCB068.             *        
T21958*  07/10/00    SFH      ADDED UTIL PAST DUE AND NON UTIL PAST DUE*        
      *                       TO PANEL 125.                            *        
T22668*  08/23/00    SFH      CPD00308 NEEDS TO KNOW IF ACCOUNT        *        
      *                       IS SCEG OR SEB.                          *        
T23513*  01/17/01    CBSI     CHANGES MADE TO DISTINGUISH DATABASES SEB*00419120
T23513*              MDS      AND NON SEB TO INCORPORATE PSNC IN NON   *00419130
T23513*                       SEB                                      *00419140
T23501*  02/15/01    SFH      ADDED COMPANY_NO TO THE WHERE CLAUSE IN  *        
      *                       PARA 6500 TO SUPPORT MULTI-COMPANY.      *        
T23934*  03/05/01    SS82048  TO ELIMINATE -811 DURING SELECT ON       *        
      *                       CSS_SURETY_BOND.                         *        
T23179*  05/08/01    SS82048  CHANGES FOR PSNC TO COMPUTE MAXIMUM      *        
T23179*                       DEPOSIT AMOUNT FOR SEASONAL /            *        
T23179*                       NON-SEASONAL RATES.                      *        
T23235*  05/25/01    BK88121  INCLUDED ACCT TYPE TO THE RESULT SET AND *        
T23235*                       CHANGED THE SELECT TO RETRIVE THE ROWS   *        
T23235*                       BASED ON COMPANY NO AND ACCT TYPE AS PER *        
T23235*                       MCR 57                                            
C28788*  07/07/03    MDJ      GET IVR-EXEMPT-CD FOR CPD00068.          *        
C26296*  02/07/05    SS82048  CHANGES FOR AUTOMATE DEPOSITS            *        
REARCH*  06/25/05    CVNS     RPC TO COBOL CONVERSION                  *        
REARCH*              CHENNAI                                           *        
C33201*  09/14/05    SS82048  INCLUDE DCLGEN FOR CSS_REG_PROFILE       *        
      *                       AND CSS_LOCAL_OFFICE                     *        
      *                       FOR MAX DEPOSIT CALCULATION CHANGES.     *        
A00755*  05/28/09    RB19957  CHANGE ALL EPP TO BBP.                   *        
A37061*  05/30/09    SJ97149  1.REPLACE CODE_REV_CLASS MID DIGIT CHECK *        
A37061*                         WITH CSS_ACCOUNT.ACCOUNT_TYPE_CODE FOR *        
A37061*                         GETTING TYPE OF THE ACCOUNT.           *        
A37061*                       2.ADDED "ROWSET POSITIONING" FOR GLOBAL  *        
A37061*                         TEMPERARY TABLES.                      *        
A37061*                       3.ADDED "WITH UR" TO SQL STATEMENTS.     *        
A01113*  06/18/09    SK42147  DO NOT INCLUD GURANTOR ACCOUNTS RELEASED *        
A01113*                       FOR GOOD CREDIT.                         *        
P00453*  05/20/11    SP95538  MOVE PRP TO THE CREDIT GROUP ID FOR      *        
P00453*                       PRE-PAY-PLAN ACCOUNTS.                   *        
P00726*  04/10/14    AA97148  CREDIT ARRANGEMENTS RELEASE 3 CHANGES -  *        
P00726*                       ADDED NEW FIELDS TO THE RECONNECT TABLE. *        
ACT239*  08/14/14    RB19957  ADDED NEW PARM FIELD FOR CSR03515 CHANGE.*        
P0726A*  07/09/15    AA97148  CREDIT ARRANGEMENTS RELEASE 6 CHANGES -  *        
P0726A*                       DEFECT ID 7252  - ADDED LAST UPDATE      *        
P0726A*                       TIMESTAMP VALIDATION.                    *        
A05091*  01/22/16    RB19957  ADDED TBATMISC WHICH IS NOW NEEDED       *        
A05091*                       IN CPD00308 FOR SEB SEASONAL FLAG.       *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02316'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02316 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *--------< CONTAINS THE COBOL EQUATES NEEDED FOR USING THE >              
      *--------<COMMON SYSTEM AREA >                                            
           COPY CCA00001.                                                       
      *--------< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >               
           COPY CWS00027.                                                       
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                          
           COPY CWS00303.                                                       
T19557*--------< LINKAGE SECTION VARIABLES FOR SCSCO068 >                       
T19557     COPY CWS0068L.                                               01680000
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
      *-------------< CSS_ACCOUNT    >                                          
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      *-------------< CSS_CREDIT_PROFILE >                                      
           EXEC SQL                                                             
              INCLUDE TBCRPROF                                                  
           END-EXEC.                                                            
                                                                        
      *-------------< CSS_NSF_HIST       >                                      
           EXEC SQL                                                             
              INCLUDE TBNSFHST                                                  
           END-EXEC.                                                            
                                                                        
      *-------------< CSS_BILLING_HDR >                                         
           EXEC SQL                                                             
              INCLUDE TBBLLHDR                                                  
           END-EXEC.                                                            
                                                                        
      *-------------< CSS_BILLING_DET >                                         
           EXEC SQL                                                             
              INCLUDE TBBLLDET                                                  
           END-EXEC.                                                            
                                                                        
      *-------------< CSS_GUARANTOR >                                           
           EXEC SQL                                                             
              INCLUDE TBGTNTR                                                   
           END-EXEC.                                                            
                                                                        
      *-------------< CSS_SURETY_BOND >                                         
           EXEC SQL                                                             
              INCLUDE TBSTYBND                                                  
           END-EXEC.                                                            
                                                                        
      *-------------< CSS_DEP_ON_HAND >                                         
           EXEC SQL                                                             
              INCLUDE TBDEPHND                                                  
           END-EXEC.                                                            
                                                                        
C26296*-------------< CSS_DEP_REQ>                                              
C26296     EXEC SQL                                                             
C26296        INCLUDE TBDEPREQ                                                  
C26296     END-EXEC.                                                            
                                                                        
C26296*-------------< CSS_AR_CNTL>                                              
C26296     EXEC SQL                                                             
C26296        INCLUDE TBARCNTL                                                  
C26296     END-EXEC.                                                            
                                                                        
      *-------------< CSS_RECONNECT >                                           
           EXEC SQL                                                             
              INCLUDE TBRECNCT                                                  
           END-EXEC.                                                            
                                                                        
TP7835*-------------< CSS_RECONNECT_CHRG >                                      
TP7835     EXEC SQL                                                             
TP7835        INCLUDE TBRCNCHR                                                  
TP7835     END-EXEC.                                                            
TP7835                                                                  
PERF  *-------------< CSS_USER_PROFILE >                                        
PERF       EXEC SQL                                                             
PERF          INCLUDE TBUSRPRF                                                  
PERF       END-EXEC.                                                            
PERF                                                                    
TP8452*-------------< CSS_BILL_WINDOW >                                         
TP8452     EXEC SQL                                                             
TP8452        INCLUDE TBBILWDW                                                  
TP8452     END-EXEC.                                                            
T10290*-------------< CSS_CUST_PREM_HIST >                                      
T10290     EXEC SQL                                                             
T10290        INCLUDE TBCSTPRM                                                  
T10290     END-EXEC.                                                            
T22668*-------------< CSS_DELINQUENCY >                                         
T22668     EXEC SQL                                                             
T22668        INCLUDE TBDELQ                                                    
T22668     END-EXEC.                                                            
                                                                        
T23179*-------------< CSS_UTIL_ENVRNMT>                                         
T23179     EXEC SQL                                                     00930000
T23179        INCLUDE TBUTLENV                                          00931000
T23179     END-EXEC.                                                    00932000
T23179*--------------< CSS_RATE_CREATOR>                                        
T23179     EXEC SQL                                                     00930000
T23179        INCLUDE TBRTCRTR                                          00931000
T23179     END-EXEC.                                                    00932000
C33201*                                                                         
C33201************************************************************              
C33201**   CSS_REG_PROFILE (LR)                                                 
C33201************************************************************              
C33201     EXEC SQL                                                             
C33201        INCLUDE TBREGPRF                                                  
C33201     END-EXEC.                                                            
C33201*                                                                         
C33201************************************************************              
C33201**   CSS_LOCAL_OFFICE (B1)                                                
C33201************************************************************              
C33201     EXEC SQL                                                             
C33201        INCLUDE TBLOCOFC                                                  
C33201     END-EXEC.                                                            
C33201*                                                                         
A05091************************************************************              
A05091**   CSS_ACCT_MISC_INFO TA                                                
A05091************************************************************              
A05091     EXEC SQL                                                             
A05091        INCLUDE TBATMISC                                                  
A05091     END-EXEC.                                                            
      *                                                                 01218000
      *--------< WORKING STORAGE WS-CODES-DATA-PRESENT >                        
           EXEC SQL                                                             
              INCLUDE CWS00056                                                  
           END-EXEC.                                                            
                                                                        
      *--------< WORKING STORAGE FOR CPD00068 >                                 
           EXEC SQL                                                             
              INCLUDE CWS00068                                                  
           END-EXEC.                                                            
      *                                                                         
C26296*--------< WORKING STORAGE FOR CPD00309 >                                 
C26296     EXEC SQL                                                             
C26296         INCLUDE CWS00309                                                 
C26296     END-EXEC.                                                            
C26296*                                                                         
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ****@*************************************************************        
                                                                        
REARCH 01  GW-LIB-MISC-FIELDS.                                          
REARCH     05  PROGRAM-NAME            PIC X(08) VALUE 'CSR02316'.      
REARCH     05  MCSCB068                PIC X(08) VALUE 'MCSCB068'.      
                                                                        
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH      05  GTT-NAME                PIC X(26)                       
REARCH                                     VALUE 'SESSION.CSR02316_R1'. 
REARCH      05  GTT-ROW.                                                
REARCH          49 GTT-ROW-LEN          PIC S9(04) COMP.                
REARCH          49 GTT-ROW-CHAR         PIC X(1024).                    
REARCH      05  GTT-SQLCODE             PIC S9(9) COMP.                 
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-ACTIVE-CODE          PIC X(01) VALUE 'A'.             
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-DNP-TYPE             PIC X(15) VALUE SPACES.          
           05  RS-CREDIT-GROUP         PIC X(01) VALUE SPACES.          
           05  RS-CREDIT-GROUP-ID      PIC X(10) VALUE SPACES.          
           05  RS-DNP-AMT              PIC S9(11)V99 COMP-3 VALUE +0.   
           05  RS-DNP-DATE             PIC X(10) VALUE SPACES.          
           05  RS-DNP-TIME             PIC X(08) VALUE SPACES.          
PERF       05  RS-FIRST-NAME           PIC X(12) VALUE SPACES.          
PERF       05  RS-LAST-NAME            PIC X(15) VALUE SPACES.          
PERF       05  RS-MIDDLE-NAME          PIC X(10) VALUE SPACES.          
           05  RS-PAST-DUE-AMT         PIC S9(11)V99 COMP-3 VALUE +0.   
           05  RS-LAST-BILL-DATE       PIC X(10) VALUE SPACES.          
           05  RS-CASH-ONLY-IND        PIC X(1)  VALUE 'N'.             
           05  RS-RECONNECT-DATE       PIC X(10) VALUE SPACES.          
           05  RS-AGREEMENT-COMMENTS   PIC X(26) VALUE SPACES.          
           05  RS-RET-CHK-CNT          PIC S9(4) COMP VALUE 0.          
           05  RS-DNP-CNT              PIC S9(4) COMP VALUE 0.          
           05  RS-SECURITIES-TOTAL     PIC X(14) VALUE SPACE.           
           05  RS-MAX-DEPOSIT-AMT      PIC S9(09)V99 USAGE COMP-3       
                                                      VALUE 0.          
           05  RS-RCNCT-CHRG-COLLECT   PIC S9(07)V99 USAGE COMP-3       
                                                      VALUE 0.          
           05  RS-DNP-COLLECT-AMT      PIC S9(07)V99 USAGE COMP-3       
                                                      VALUE 0.          
TP7835     05  RS-NORMAL               PIC X VALUE SPACE.               
TP7835     05  RS-ELECTRIC             PIC X VALUE SPACE.               
TP7835     05  RS-GAS                  PIC X VALUE SPACE.               
T21958     05  RS-UTIL-PAST-DUE        PIC S9(11)V99 COMP-3 VALUE +0.   
T21958     05  RS-NON-UTIL-PAST-DUE    PIC S9(11)V99 COMP-3 VALUE +0.   
T23235     05  RS-ACCT-TYPE            PIC X(01) VALUE SPACES.          
TP8452     05  RS-MIN-DEPOSIT-AMT      PIC S9(09)V99 USAGE COMP-3       
                                                      VALUE 0.          
C26296     05  RS-AUTO-DEP-ID          PIC S9(09)    USAGE COMP         
C26296                                                VALUE 0.          
C26296     05  RS-NOTC-AUTO-DEP-AM     PIC S9(09)V99 USAGE COMP-3       
C26296                                                VALUE 0.          
C26296     05  RS-AUTO-DEP-AMT         PIC S9(09)V99 USAGE COMP-3       
C26296                                                VALUE 0.          
C26296     05  RS-DEP-BILL-OPT-CD      PIC X(01)      VALUE SPACES.     
C26296     05  RS-NO-SCHED-PYMTS       PIC S9(09)    USAGE COMP         
C26296                                                VALUE 0.          
C26296     05  RS-AUTO-DEP-LTR-IND     PIC X(01)      VALUE SPACES.     
C26296     05  RS-SEND-LTTR-DELINQ     PIC S9(04)    USAGE COMP VALUE 0.
C26296     05  RS-MIN-AUTO-DEP-AMT     PIC S9(09)    USAGE COMP VALUE 0.
C26296     05  RS-DEP-TO-COLLECT       PIC S9(09)V99 USAGE COMP-3       
C26296                                                VALUE 0.          
C26296     05  RS-NEXT-BILL-DATE       PIC X(10)     VALUE SPACES.      
P00726     05  RS-RCNCT-TERM-ID        PIC S9(4)    USAGE COMP VALUE +0.
P00726     05  RS-LAST-UPDATE-TS       PIC X(26)    VALUE SPACE.        
P00726     05  RS-LAST-UPDATE-USERID   PIC X(07)    VALUE SPACE.        
P00726     05  RS-RCC-BILL-OPTION-CD   PIC X(01)    VALUE SPACE.        
P0726A     05  RS-LAST-UPDATE-TS-AT    PIC X(26)    VALUE SPACE.        
      *                                                                         
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
REARCH     05  S-DNP-TYPE              PIC X(15) VALUE SPACES.          
REARCH     05  S-CREDIT-GROUP          PIC X(01) VALUE SPACES.          
REARCH     05  S-CREDIT-GROUP-ID       PIC X(10) VALUE SPACES.          
REARCH     05  S-DNP-AMT               PIC S9(11)V99 COMP-3 VALUE +0.   
REARCH     05  S-DNP-DATE              PIC X(10) VALUE SPACES.          
REARCH     05  S-DNP-TIME              PIC X(08) VALUE SPACES.          
REARCH     05  S-FIRST-NAME            PIC X(12) VALUE SPACES.          
REARCH     05  S-LAST-NAME             PIC X(15) VALUE SPACES.          
REARCH     05  S-MIDDLE-NAME           PIC X(10) VALUE SPACES.          
REARCH     05  S-PAST-DUE-AMT          PIC S9(11)V99 COMP-3 VALUE +0.   
REARCH     05  S-LAST-BILL-DATE        PIC X(10) VALUE SPACES.          
REARCH     05  S-CASH-ONLY-IND         PIC X(1)  VALUE 'N'.             
REARCH     05  S-RECONNECT-DATE        PIC X(10) VALUE SPACES.          
REARCH     05  S-AGREEMENT-COMMENTS    PIC X(26) VALUE SPACES.          
REARCH     05  S-RET-CHK-CNT           PIC S9(4) COMP VALUE 0.          
REARCH     05  S-DNP-CNT               PIC S9(4) COMP VALUE 0.          
REARCH     05  S-SECURITIES-TOTAL      PIC X(14) VALUE SPACE.           
REARCH     05  S-MAX-DEPOSIT-AMT       PIC S9(09)V99 USAGE COMP-3       
REARCH                                                VALUE 0.          
REARCH     05  S-RCNCT-CHRG-COLLECT    PIC S9(07)V99 USAGE COMP-3       
REARCH                                                VALUE 0.          
REARCH     05  S-DNP-COLLECT-AMT       PIC S9(07)V99 USAGE COMP-3       
REARCH                                                VALUE 0.          
REARCH     05  S-NORMAL                PIC X VALUE SPACE.               
REARCH     05  S-ELECTRIC              PIC X VALUE SPACE.               
REARCH     05  S-GAS                   PIC X VALUE SPACE.               
REARCH     05  S-UTIL-PAST-DUE         PIC S9(11)V99 COMP-3 VALUE +0.   
REARCH     05  S-NON-UTIL-PAST-DUE     PIC S9(11)V99 COMP-3 VALUE +0.   
REARCH     05  S-ACCT-TYPE             PIC X(01) VALUE SPACES.          
REARCH     05  S-MIN-DEPOSIT-AMT       PIC S9(09)V99 USAGE COMP-3       
REARCH                                                VALUE 0.          
REARCH     05  S-AUTO-DEP-ID           PIC S9(09)    USAGE COMP         
REARCH                                                VALUE 0.          
REARCH     05  S-NOTC-AUTO-DEP-AM      PIC S9(09)V99 USAGE COMP-3       
REARCH                                                VALUE 0.          
REARCH     05  S-AUTO-DEP-AMT          PIC S9(09)V99 USAGE COMP-3       
REARCH                                                VALUE 0.          
REARCH     05  S-DEP-BILL-OPT-CD       PIC X(01)      VALUE SPACES.     
REARCH     05  S-NO-SCHED-PYMTS        PIC S9(09)    USAGE COMP         
REARCH                                                VALUE 0.          
REARCH     05  S-AUTO-DEP-LTR-IND      PIC X(01)      VALUE SPACES.     
REARCH     05  S-SEND-LTTR-DELINQ      PIC S9(04)    USAGE COMP VALUE 0.
REARCH     05  S-MIN-AUTO-DEP-AMT      PIC S9(09)    USAGE COMP VALUE 0.
REARCH     05  S-DEP-TO-COLLECT        PIC S9(09)V99 USAGE COMP-3       
REARCH                                                VALUE 0.          
REARCH     05  S-NEXT-BILL-DATE        PIC X(10)     VALUE SPACES.      
P00726     05  S-RCNCT-TERM-ID         PIC S9(4)    USAGE COMP VALUE +0.
P00726     05  S-LAST-UPDATE-TS        PIC X(26)    VALUE SPACE.        
P00726     05  S-LAST-UPDATE-USERID    PIC X(07)    VALUE SPACE.        
P00726     05  S-RCC-BILL-OPTION-CD    PIC X(01)    VALUE SPACE.        
P0726A     05  S-LAST-UPDATE-TS-AT     PIC X(26)    VALUE SPACE.        
      *                                                                         
TP8452 01  RS-REDEFINITIONS.                                            
TP8452     05  WS-ACCOUNT-PARM          PIC X(13).                      
TP8452     05  WS-ACCOUNT-DEC REDEFINES WS-ACCOUNT-PARM                 
TP8452                                  PIC 9(13).                      
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.       
      *                                                                         
                                                                        
       01  GENERAL-WORKING-STORAGE.                                     
COB305     05 WS-ACCOUNT-NO-COMP3        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.        
COB305     05 WS-CUSTOMER-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.        
           05  WS-DISC-HIST            PIC X(24).                       
           05  WS-DISC-HIST-BRKDWN REDEFINES WS-DISC-HIST               
                                       PIC X(1) OCCURS 24.              
           05  WS-EXCEPTIONAL-HIST     PIC X(24).                       
           05  WS-EXCEPTIONAL-HIST-BRKDWN  REDEFINES                    
               WS-EXCEPTIONAL-HIST     PIC X(1) OCCURS 24.              
           05  WS-ONE-YEAR-AGO         PIC X(10) VALUE SPACES.          
           05  WS-CURRENT-DATE         PIC X(10) VALUE SPACES.          
           05  WS-PREV-MNTH            PIC S9(4) COMP VALUE 0.          
           05  WS-DATE-BILLED-NULL-IND PIC S9(4) COMP VALUE 0.          
           05  WS-DL-NULL-IND          PIC S9(4) COMP VALUE 0.          
           05  WS-GUARANTEED-NULL-IND  PIC S9(4) COMP VALUE 0.          
           05  WS-BOND-NULL-IND        PIC S9(4) COMP VALUE 0.          
           05  WS-DEPOSIT-NULL-IND     PIC S9(4) COMP VALUE 0.          
           05  WS-EFF-DATE-NULL-IND    PIC S9(4) COMP VALUE 0.          
           05  WS-SECURITIES-TOTAL-CMP PIC S9(11)V99 COMP-3 VALUE +0.   
           05  WS-SECURITIES-TOTAL     PIC  9(11)V99 VALUE ZERO.        
           05  WS-SECURITIES-TOTAL-TXT REDEFINES WS-SECURITIES-TOTAL.   
               10  WS-SEC-TOT-1        PIC X(11).                       
               10  WS-SEC-TOT-2        PIC X(2).                        
           05  WS-SEC-TOT-RETURN-TXT.                                   
               10  WS-SEC-TOT-RET-1    PIC X(11).                       
               10  WS-SEC-TOT-POINT    PIC X(1) VALUE '.'.              
               10  WS-SEC-TOT-RET-2    PIC X(2).                        
           05  WS-WAIVER-EXISTS        PIC X(1)  VALUE 'N'.             
           05  WS-NULL-IND1            PIC S9(4) COMP.                  
           05  WS-NULL-IND2            PIC S9(4) COMP.                  
C26296     05  WS-NULL-IND3            PIC S9(4) COMP  VALUE 0.         
C26296     05  WS-ADEP-BALANCE         PIC S9(09)V99 COMP-3 VALUE 0.    
           05  WS-BILL-DAY-00-NI       PIC S9(4) COMP.                  
           05  WS-BILL-DAY-30-NI       PIC S9(4) COMP.                  
           05  WS-BILL-DAY-60-NI       PIC S9(4) COMP.                  
           05  WS-BILL-DAY-90-NI       PIC S9(4) COMP.                  
           05  WS-DNP-TYPE             PIC X(01).                       
T19557     05  WS-EIBRESP              PIC S9(8)                        
T19557                                 COMP SYNC  VALUE ZERO.           
T23235     05  WS-CLASS                PIC 9(01)  VALUE ZERO.           
T23235     05  WS-ACCT-TYPE-CD         PIC X(01)  VALUE SPACE.          
P00726     05  WS-RCNCT-TERM-ID-NULL   PIC S9(04) COMP VALUE 0.         
C26296*                                                                         
C26296     05  WS-REFORMAT-DATE.                                        
C26296         10  WS-FORMAT-YEAR      PIC X(04)  VALUE SPACES.         
C26296         10  FILLER              PIC X(01)  VALUE SPACES.         
C26296         10  WS-FORMAT-MONTH     PIC X(02)  VALUE SPACES.         
C26296         10  FILLER              PIC X(01)  VALUE SPACES.         
C26296         10  WS-FORMAT-DAY       PIC X(02)  VALUE SPACES.         
C26296*                                                                         
C26296     05  WS-USA-DATE-FORMAT.                                      
C26296         10  WS-USA-MONTH        PIC X(02)  VALUE SPACES.         
C26296         10  FILLER              PIC X(01)  VALUE '/'.            
C26296         10  WS-USA-DAY          PIC X(02)  VALUE SPACES.         
C26296         10  FILLER              PIC X(01)  VALUE '/'.            
C26296         10  WS-USA-YEAR         PIC X(04)  VALUE SPACES.         
C26296*                                                                         
C26296     05  WS-CSR03515-INPUT-PARM.                                  
C26296         10  WS-CSR03515-ACCOUNT-NO      PIC X(13) VALUE SPACES.  
C26296         10  WS-CSR03515-CALLING-PGM     PIC X(09) VALUE SPACES.  
C26296         10  WS-CSR03515-AUTO-DEP-TYPE   PIC X(01) VALUE SPACES.  
C26296         10  WS-CSR03515-DL-AUTO-DEP-AMT PIC S9(09)V99            
C26296                                         USAGE COMP-3 VALUE 0.    
C26296         10  WS-CSR03515-USER-ID         PIC X(07) VALUE SPACES.  
C26296         10  WS-CSR03515-ERROR-SW        PIC X(01) VALUE SPACES.  
ACT239         10  WS-CSR03515-BATCH-DATE      PIC X(10) VALUE SPACES.  
C26296     05  WS-CSR03515-OUTPUT-FIELDS.                               
C26296         10  WS-CSR03515-RETURN-CODE      PIC S9(09) COMP VALUE 0.
C26296         10  WS-CSR03515-AUTO-DEP-AMT     PIC S9(09)V99 COMP-3    
C26296                                                         VALUE 0. 
C26296         10  WS-CSR03515-DEP-SUCCESS       PIC X(01) VALUE SPACES.
C26296         10  WS-CSR03515-DEP-CERT-NO      PIC S9(09) COMP VALUE 0.
C26296         10  WS-CSR03515-MAX-DEP-ZERO-WQ   PIC X(01) VALUE SPACES.
C26296         10  WS-CSR03515-AMT-SECURED       PIC S9(09)V99 COMP-3   
C26296                                                         VALUE 0. 
C26296         10  WS-CSR03515-ABEND-PROGRAM     PIC X(20) VALUE SPACES.
C26296         10  WS-CSR03515-ACTIVE-PARAGRAPH  PIC X(20) VALUE SPACES.
C26296         10  WS-CSR03515-ABEND-FUNCTION    PIC X(20) VALUE SPACES.
C26296         10  WS-CSR03515-TABLE-1           PIC X(20) VALUE SPACES.
C26296         10  WS-CSR03515-TABLE-ELEMENT-1   PIC X(20) VALUE SPACES.
C26296         10  WS-CSR03515-HOSTVAR-ELEMENT-1 PIC X(20) VALUE SPACES.
C26296         10  WS-CSR03515-TABLE-ELEMENT-2   PIC X(20) VALUE SPACES.
C26296         10  WS-CSR03515-HOSTVAR-ELEMENT-2 PIC X(20) VALUE SPACES.
C26296         10  WS-CSR03515-TABLE-ELEMENT-3   PIC X(20) VALUE SPACES.
C26296         10  WS-CSR03515-HOSTVAR-ELEMENT-3 PIC X(20) VALUE SPACES.
C26296         10  WS-CSR03515-TABLE-ELEMENT-4   PIC X(20) VALUE SPACES.
C26296         10  WS-CSR03515-HOSTVAR-ELEMENT-4 PIC X(20) VALUE SPACES.
C26296     05  WS-AUTODEP-CALL-SUCCESS           PIC X(01) VALUE SPACES.
C26296     05  WS-AUTO-AMT-DEPOSIT               PIC S9(07)V99 COMP-3   
C26296                                                     VALUE ZEROS. 
C26296*                                                                         
C26296***************************************************************   ****    
C26296*    DB2 COMMUNICATION REQUIREMENT *                                      
C26296***************************************************************   ****    
C26296*01  LOC1                  USAGE IS SQL TYPE IS                   
C26296*                          RESULT-SET-LOCATOR VARYING.            
C26296 01  ERROR-MESSAGE.                                               
C26296     02  ERROR-LEN           PIC S9(4)  COMP VALUE +1320.         
C26296     02  ERROR-TEXT          PIC X(132) OCCURS 10 TIMES           
C26296                           INDEXED BY ERROR-INDEX.                
C26296 77   ERROR-TEXT-LEN       PIC S9(9)  COMP VALUE +132.            
C26296 77  TRACE-MESSAGE-AREA    PIC X(256).                            
C26296 77  OPENFN                PIC X(12).                             
C26296 77  SSID                  PIC X(4).                              
C26296 77  PLANNAME              PIC X(8).                              
C26296 77  RETCODE               PIC S9(5).                             
C26296 77  REASCODE              PIC S9(5).                             
C26296 77  CLOSFN                PIC X(12).                             
C26296 77  TERMOP                PIC X(4).                              
                                                                        
       01  LITERALS.                                                    
           05  WS-A                    PIC X(1)  VALUE 'A'.             
           05  WS-B                    PIC X(1)  VALUE 'B'.             
           05  WS-C                    PIC X(1)  VALUE 'C'.             
           05  WS-D                    PIC X(1)  VALUE 'D'.             
           05  WS-F                    PIC X(1)  VALUE 'F'.             
           05  WS-G                    PIC X(1)  VALUE 'G'.             
           05  WS-P                    PIC X(1)  VALUE 'P'.             
           05  WS-1-ZERO               PIC X(11) VALUE '          0'.   
           05  WS-2-ZERO               PIC X(2)  VALUE '00'.            
           05  WS-FOUR                 PIC X(1)  VALUE '4'.             
           05  WS-WAIVER-TEXT          PIC X(14) VALUE 'WAIVER        '.
           05  WS-SUB-ACCT             PIC X(10) VALUE 'SUB ACCT  '.    
           05  WS-MASTER               PIC X(10) VALUE 'MASTER    '.    
           05  WS-MAJOR                PIC X(10) VALUE 'MAJOR     '.    
           05  WS-CT-RATED             PIC X(10) VALUE 'CT METER  '.    
A00755     05  WS-BBP                  PIC X(10) VALUE 'BBP       '.    
P00453     05  WS-PRP                  PIC X(10) VALUE 'PRP       '.    
           05  WS-DPP                  PIC X(10) VALUE 'DPP       '.    
           05  WS-NON-PAY              PIC X(1)  VALUE 'C'.             
           05  WS-FINAL-BILL           PIC X(1)  VALUE 'B'.             
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
T23513     05  WS-DATABASE             PIC 9(01) VALUE 0.               
T23513         88 CSR-DATABASE                   VALUE 1.               
T23513         88 SEB-DATABASE                   VALUE 2.               
                                                                        
TP8452     EXEC SQL                                                             
TP8452         INCLUDE CWS00308                                                 
TP8452     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
                                                                        
                                                                        
HPCCDM*EJECT                                                                    
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.
MSQ001        EXEC SQL
MSQ001          DECLARE AUTO_DEP CURSOR
MSQ001          FOR CALL CSR03515                                       
C26296         ( :WS-CSR03515-ACCOUNT-NO
                  , :WS-CSR03515-CALLING-PGM
                  , :WS-CSR03515-AUTO-DEP-TYPE
                  , :WS-CSR03515-DL-AUTO-DEP-AMT
                  , :WS-CSR03515-USER-ID
                  , :WS-CSR03515-ERROR-SW
                  , :WS-CSR03515-BATCH-DATE
                  )
MSQ001        END-EXEC.
        
CVT000                                                                  
CVT000 LINKAGE SECTION.                                                 
CVT000 01  PARM-ACCOUNT-NUM         PIC X(13)                .          
CVT000 01  PARM-ORDER-REASON        PIC X(01)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          PARM-ACCOUNT-NUM                                        
CVT000         ,PARM-ORDER-REASON                                       
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
PCR361*     CALLS 9700-PROCESS-ABEND                                   *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'               TO ACTIVE-PARAGRAPH.               
                                                                        
REARCH     EXEC SQL                                                     
A37061       DECLARE C1 CURSOR                               
A37061                         WITH ROWSET POSITIONING FOR              
REARCH       SELECT                                                     
REARCH           :S-RETURN-CODE               AS RETURN_CODE            
REARCH          ,:S-DNP-TYPE                  AS DNP_TYPE               
REARCH          ,:S-CREDIT-GROUP              AS CREDIT_GROUP           
REARCH          ,:S-CREDIT-GROUP-ID           AS CREDIT_GROUP_ID        
REARCH          ,:S-DNP-AMT                   AS DNP_AMT                
REARCH          ,:S-DNP-DATE                  AS DNP_DATE               
REARCH          ,:S-DNP-TIME                  AS DNP_TIME               
REARCH          ,:S-FIRST-NAME                AS FIRST_NAME             
REARCH          ,LTRIM(RTRIM(:S-LAST-NAME))          AS LAST_NAME              
REARCH          ,:S-MIDDLE-NAME               AS MIDDLE_NAME            
REARCH          ,:S-PAST-DUE-AMT              AS PAST_DUE_AMT           
REARCH          ,:S-LAST-BILL-DATE            AS LAST_BILL_DATE         
REARCH          ,:S-CASH-ONLY-IND             AS CASH_ONLY              
REARCH          ,:S-RECONNECT-DATE            AS RECONNECT_DATE         
REARCH          ,LTRIM(RTRIM(:S-AGREEMENT-COMMENTS)) AS AGRMT_COMMENTS         
REARCH          ,:S-RET-CHK-CNT               AS RET_CHECKS             
REARCH          ,:S-DNP-CNT                   AS DNP_COUNT              
REARCH          ,:S-SECURITIES-TOTAL          AS SECURITIES_TOT         
REARCH          ,:S-MAX-DEPOSIT-AMT           AS MAX_DEPOSIT_AMT        
REARCH          ,:S-RCNCT-CHRG-COLLECT        AS RCNCT_CHRG_COLLECT     
REARCH          ,:S-DNP-COLLECT-AMT           AS DNP_COLLECT_AMT        
REARCH          ,:S-NORMAL                    AS NORMAL                 
REARCH          ,:S-ELECTRIC                  AS ELECTRIC               
REARCH          ,:S-GAS                       AS GAS                    
REARCH          ,:S-UTIL-PAST-DUE             AS UTIL_PAST_DUE          
REARCH          ,:S-NON-UTIL-PAST-DUE         AS NON_UTIL_PAST_DUE      
REARCH          ,:S-ACCT-TYPE                 AS ACCT_TYPE              
REARCH          ,:S-AUTO-DEP-ID               AS AUTO_DEP_ID            
REARCH          ,:S-NOTC-AUTO-DEP-AM          AS NOTC_AUTO_DEP_AM       
REARCH          ,:S-AUTO-DEP-AMT              AS AUTO_DEP_AMT           
REARCH          ,:S-DEP-BILL-OPT-CD           AS DEP_BILL_OPT_CD        
REARCH          ,:S-NO-SCHED-PYMTS            AS NO_SCHED_PYMTS         
REARCH          ,:S-AUTO-DEP-LTR-IND          AS AUTO_DEP_LTR_IND       
REARCH          ,:S-SEND-LTTR-DELINQ          AS SEND_LTTR_DELINQ       
REARCH          ,:S-MIN-AUTO-DEP-AMT          AS MIN_AUTO_DEP_AMT       
REARCH          ,:S-DEP-TO-COLLECT            AS DEP_TO_COLLECT         
REARCH          ,:S-NEXT-BILL-DATE            AS NEXT_BILL_DATE         
P00726          ,:S-RCNCT-TERM-ID             AS RCNCT_TERM_ID          
P00726          ,:S-LAST-UPDATE-TS            AS LAST_UPDATE_TS         
P00726          ,:S-LAST-UPDATE-USERID        AS LAST_UPDATE_USERID     
P00726          ,:S-RCC-BILL-OPTION-CD        AS RCC_BILL_OPTION_CD     
P0726A          ,:S-LAST-UPDATE-TS-AT         AS LAST_UPDATE_TS_AT      
REARCH     FROM                                                         
REARCH         CIS.SYSDUMMY1                                         
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN                                      
MFA-TR*                        WITH ROWSET POSITIONING FOR                      
MFA-TR*      SELECT                                                             
MFA-TR*          :S-RETURN-CODE               AS RETURN_CODE                    
MFA-TR*         ,:S-DNP-TYPE                  AS DNP_TYPE                       
MFA-TR*         ,:S-CREDIT-GROUP              AS CREDIT_GROUP                   
MFA-TR*         ,:S-CREDIT-GROUP-ID           AS CREDIT_GROUP_ID                
MFA-TR*         ,:S-DNP-AMT                   AS DNP_AMT                        
MFA-TR*         ,:S-DNP-DATE                  AS DNP_DATE                       
MFA-TR*         ,:S-DNP-TIME                  AS DNP_TIME                       
MFA-TR*         ,:S-FIRST-NAME                AS FIRST_NAME                     
MFA-TR*         ,STRIP(:S-LAST-NAME)          AS LAST_NAME                      
MFA-TR*         ,:S-MIDDLE-NAME               AS MIDDLE_NAME                    
MFA-TR*         ,:S-PAST-DUE-AMT              AS PAST_DUE_AMT                   
MFA-TR*         ,:S-LAST-BILL-DATE            AS LAST_BILL_DATE                 
MFA-TR*         ,:S-CASH-ONLY-IND             AS CASH_ONLY                      
MFA-TR*         ,:S-RECONNECT-DATE            AS RECONNECT_DATE                 
MFA-TR*         ,STRIP(:S-AGREEMENT-COMMENTS) AS AGRMT_COMMENTS                 
MFA-TR*         ,:S-RET-CHK-CNT               AS RET_CHECKS                     
MFA-TR*         ,:S-DNP-CNT                   AS DNP_COUNT                      
MFA-TR*         ,:S-SECURITIES-TOTAL          AS SECURITIES_TOT                 
MFA-TR*         ,:S-MAX-DEPOSIT-AMT           AS MAX_DEPOSIT_AMT                
MFA-TR*         ,:S-RCNCT-CHRG-COLLECT        AS RCNCT_CHRG_COLLECT             
MFA-TR*         ,:S-DNP-COLLECT-AMT           AS DNP_COLLECT_AMT                
MFA-TR*         ,:S-NORMAL                    AS NORMAL                         
MFA-TR*         ,:S-ELECTRIC                  AS ELECTRIC                       
MFA-TR*         ,:S-GAS                       AS GAS                            
MFA-TR*         ,:S-UTIL-PAST-DUE             AS UTIL_PAST_DUE                  
MFA-TR*         ,:S-NON-UTIL-PAST-DUE         AS NON_UTIL_PAST_DUE              
MFA-TR*         ,:S-ACCT-TYPE                 AS ACCT_TYPE                      
MFA-TR*         ,:S-AUTO-DEP-ID               AS AUTO_DEP_ID                    
MFA-TR*         ,:S-NOTC-AUTO-DEP-AM          AS NOTC_AUTO_DEP_AM               
MFA-TR*         ,:S-AUTO-DEP-AMT              AS AUTO_DEP_AMT                   
MFA-TR*         ,:S-DEP-BILL-OPT-CD           AS DEP_BILL_OPT_CD                
MFA-TR*         ,:S-NO-SCHED-PYMTS            AS NO_SCHED_PYMTS                 
MFA-TR*         ,:S-AUTO-DEP-LTR-IND          AS AUTO_DEP_LTR_IND               
MFA-TR*         ,:S-SEND-LTTR-DELINQ          AS SEND_LTTR_DELINQ               
MFA-TR*         ,:S-MIN-AUTO-DEP-AMT          AS MIN_AUTO_DEP_AMT               
MFA-TR*         ,:S-DEP-TO-COLLECT            AS DEP_TO_COLLECT                 
MFA-TR*         ,:S-NEXT-BILL-DATE            AS NEXT_BILL_DATE                 
MFA-TR*         ,:S-RCNCT-TERM-ID             AS RCNCT_TERM_ID                  
MFA-TR*         ,:S-LAST-UPDATE-TS            AS LAST_UPDATE_TS                 
MFA-TR*         ,:S-LAST-UPDATE-USERID        AS LAST_UPDATE_USERID             
MFA-TR*         ,:S-RCC-BILL-OPTION-CD        AS RCC_BILL_OPTION_CD             
MFA-TR*         ,:S-LAST-UPDATE-TS-AT         AS LAST_UPDATE_TS_AT              
MFA-TR*    FROM                                                                 
MFA-TR*        SYSIBM.SYSDUMMY1                                                 
MFA-TR*    END-EXEC.                                                            
       0100-EXIT.                                                       
               EXIT.                                                    
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     CALLS 1100-RECEIVE-PARMS                                   *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
                                                                        
           MOVE PARM-ACCOUNT-NUM  TO WS-ACCOUNT-PARM.                   
           MOVE WS-ACCOUNT-DEC    TO AT-ACCOUNT-NO                      
                                     WS-ACCOUNT-NO                      
                                     WS-ACCOUNT-NO-COMP3.               
           MOVE PARM-ORDER-REASON TO WS-DNP-TYPE.                       
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     CALLS 2100-DESCRIBE-RESULT                                 *        
      *           2200-BUILD-RESULT                                    *        
      *           8100-SEND-RESULT                                     *        
      *                                                                *        
      *      CALLED FROM 0000-MAINLINE                                 *        
      *                                                                *        
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *        
      *      AND SENDS THEN BACK                                       *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2200-BUILD-RESULT          THRU 2200-EXIT.           
REARCH     PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT.          
REARCH     ADD +1                             TO CTR-ROWS.              
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
REARCH******************************************************************        
REARCH*2000A-MOVE-RESULT.                                                       
REARCH******************************************************************        
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE RS-RETURN-CODE         TO S-RETURN-CODE.                
REARCH     MOVE RS-DNP-TYPE            TO S-DNP-TYPE.                   
REARCH     MOVE RS-CREDIT-GROUP        TO S-CREDIT-GROUP.               
REARCH     MOVE RS-CREDIT-GROUP-ID     TO S-CREDIT-GROUP-ID.            
REARCH     MOVE RS-DNP-AMT             TO S-DNP-AMT.                    
REARCH     MOVE RS-DNP-DATE            TO S-DNP-DATE.                   
REARCH     MOVE RS-DNP-TIME            TO S-DNP-TIME.                   
REARCH     MOVE RS-FIRST-NAME          TO S-FIRST-NAME.                 
REARCH     MOVE RS-LAST-NAME           TO S-LAST-NAME.                  
REARCH     MOVE RS-MIDDLE-NAME         TO S-MIDDLE-NAME.                
REARCH     MOVE RS-PAST-DUE-AMT        TO S-PAST-DUE-AMT.               
REARCH     MOVE RS-LAST-BILL-DATE      TO S-LAST-BILL-DATE.             
REARCH     MOVE RS-CASH-ONLY-IND       TO S-CASH-ONLY-IND.              
REARCH     MOVE RS-RECONNECT-DATE      TO S-RECONNECT-DATE.             
REARCH     MOVE RS-AGREEMENT-COMMENTS  TO S-AGREEMENT-COMMENTS.         
REARCH     MOVE RS-RET-CHK-CNT         TO S-RET-CHK-CNT.                
REARCH     MOVE RS-DNP-CNT             TO S-DNP-CNT.                    
REARCH     MOVE RS-SECURITIES-TOTAL    TO S-SECURITIES-TOTAL.           
REARCH     MOVE RS-MAX-DEPOSIT-AMT     TO S-MAX-DEPOSIT-AMT.            
REARCH     MOVE RS-RCNCT-CHRG-COLLECT  TO S-RCNCT-CHRG-COLLECT.         
REARCH     MOVE RS-DNP-COLLECT-AMT     TO S-DNP-COLLECT-AMT.            
REARCH     MOVE RS-NORMAL              TO S-NORMAL.                     
REARCH     MOVE RS-ELECTRIC            TO S-ELECTRIC.                   
REARCH     MOVE RS-GAS                 TO S-GAS.                        
REARCH     MOVE RS-UTIL-PAST-DUE       TO S-UTIL-PAST-DUE.              
REARCH     MOVE RS-NON-UTIL-PAST-DUE   TO S-NON-UTIL-PAST-DUE.          
REARCH     MOVE RS-ACCT-TYPE           TO S-ACCT-TYPE.                  
REARCH     MOVE RS-AUTO-DEP-ID         TO S-AUTO-DEP-ID.                
REARCH     MOVE RS-NOTC-AUTO-DEP-AM    TO S-NOTC-AUTO-DEP-AM.           
REARCH     MOVE RS-AUTO-DEP-AMT        TO S-AUTO-DEP-AMT.               
REARCH     MOVE RS-DEP-BILL-OPT-CD     TO S-DEP-BILL-OPT-CD.            
REARCH     MOVE RS-NO-SCHED-PYMTS      TO S-NO-SCHED-PYMTS.             
REARCH     MOVE RS-AUTO-DEP-LTR-IND    TO S-AUTO-DEP-LTR-IND.           
REARCH     MOVE RS-SEND-LTTR-DELINQ    TO S-SEND-LTTR-DELINQ.           
REARCH     MOVE RS-MIN-AUTO-DEP-AMT    TO S-MIN-AUTO-DEP-AMT.           
REARCH     MOVE RS-DEP-TO-COLLECT      TO S-DEP-TO-COLLECT.             
REARCH     MOVE RS-NEXT-BILL-DATE      TO S-NEXT-BILL-DATE.             
P00726     MOVE RS-RCNCT-TERM-ID       TO S-RCNCT-TERM-ID.              
P00726     MOVE RS-LAST-UPDATE-TS      TO S-LAST-UPDATE-TS.             
P00726     MOVE RS-LAST-UPDATE-USERID  TO S-LAST-UPDATE-USERID.         
P00726     MOVE RS-RCC-BILL-OPTION-CD  TO S-RCC-BILL-OPTION-CD.         
P0726A     MOVE RS-LAST-UPDATE-TS-AT   TO S-LAST-UPDATE-TS-AT.          
P00726                                                                  
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
                                                                        
                                                                        
                                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *                                                                *        
      *     CALLS 3300-CALCULATION                                     *        
      *     CALLS 7000-SELECT-ACCOUNT                                  *        
      *     CALLS 7100-SELECT-CREDIT-PROFILE                           *        
      *     CALLS 7200-SELECT-BILL-DATE                                *        
      *     CALLS 2210-CALC-NO-OF-DNP                                  *        
      *     CALLS 7250-SELECT-CODE-REVENUE-CLASS                                
      *     CALLS 7300-SELECT-RECONNECT                                *        
      *     CALLS 7500-CALC-NO-OF-RET-CHKS                             *        
      *     CALLS 7501-CALCULATE-ONE-YEAR-AGO                          *        
      *     CALLS 7503-CALCULATE-TODAY                                 *        
      *     CALLS 7600-GET-DEPOSIT-ON-HAND                             *        
      *     CALLS 7700-GET-GUARANTEED-AMT                              *        
      *     CALLS 7800-GET-SURETY-BOND-AMT                             *        
      *     CALLS 7900-CHECK-FOR-WAIVERS                               *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      *********@********************************************************        
                                                                        
       2200-BUILD-RESULT.                                               
                                                                        
      *-----< START OFF BY READING THE ACCOUNT TABLE AND GETTING >              
      *-----< DISCONNECT EXEMPTION >                                            
                                                                        
           PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT.                  
                                                                        
           MOVE AT-CUSTOMER-NO         TO WS-CUSTOMER-NO.               
           MOVE AT-CODES-DATA-PRESENT  TO WS-CODES-DATA-PRESENT.        
                                                                        
           MOVE AT-CREDIT-GROUP        TO RS-CREDIT-GROUP               
P0726A     MOVE AT-LAST-UPDATE-TS      TO RS-LAST-UPDATE-TS-AT          
                                                                        
      *****************************************************************         
      *    SET CREDIT GROUP ID CODE.                                  *         
      *********@*******************************************************         
           EVALUATE TRUE                                                
           WHEN AT-MST-SUB-ACCT-IND = 'M'                               
              MOVE WS-MASTER           TO RS-CREDIT-GROUP-ID            
           WHEN AT-MST-SUB-ACCT-IND = 'S'                               
              MOVE WS-SUB-ACCT         TO RS-CREDIT-GROUP-ID            
           WHEN AT-CODE-MAJOR-ACCT  = 'Y'                               
              MOVE WS-MAJOR            TO RS-CREDIT-GROUP-ID            
           WHEN WS-CODE-BUDGET      = 'A'                               
A00755        MOVE WS-BBP              TO RS-CREDIT-GROUP-ID            
P00453     WHEN WS-CODE-PRE-PAY-PLAN = 'A'                              
P00453        MOVE WS-PRP              TO RS-CREDIT-GROUP-ID            
           WHEN AT-CT-METER-RATED-IND = 'Y'                             
              MOVE WS-CT-RATED         TO RS-CREDIT-GROUP-ID            
           WHEN WS-CODE-DPP-ACCT    = 'A'                               
              MOVE WS-DPP              TO RS-CREDIT-GROUP-ID            
           END-EVALUATE.                                                
                                                                        
      *    MOVE AT-LAST-UPDATE-TS      TO RS-LAST-AT-UPDATE-TS.                 
                                                                        
      *---< GET CREDIT PROFILE INFORMATION >                                    
                                                                        
           PERFORM 7100-SELECT-CREDIT-PROFILE  THRU 7100-EXIT.          
                                                                        
           MOVE CZ-CASH-ONLY-FL        TO RS-CASH-ONLY-IND.             
      *    MOVE CZ-LAST-UPDATE-TS      TO RS-LAST-CZ-UPDATE-TS.                 
                                                                        
      *---< GET BILL DATE >                                                     
                                                                        
           PERFORM 7200-SELECT-BILL-DATE       THRU 7200-EXIT.          
                                                                        
           IF WS-DATE-BILLED-NULL-IND < 0                               
              MOVE SPACES              TO RS-LAST-BILL-DATE             
           ELSE                                                         
              MOVE BI-DATE-BILLED      TO RS-LAST-BILL-DATE             
           END-IF.                                                      
                                                                        
      *---< GET NUMBER OF DNPS IN THE LAST YEAR >                               
                                                                        
           PERFORM 2210-CALC-NO-OF-DNPS        THRU 2210-EXIT.          
                                                                        
      *---< GET NUMBER OF RETURNED CHECKS/DRAFTS IN THE LAST YEAR >             
                                                                        
           PERFORM 7501-CALCULATE-ONE-YEAR-AGO THRU 7501-EXIT.          
           PERFORM 7500-CALC-NO-OF-RET-CHKS    THRU 7500-EXIT.          
                                                                        
      *---< GET ACTIVE SECURITIES TOTAL >                                       
                                                                        
           MOVE ZERO TO WS-SECURITIES-TOTAL.                            
                                                                        
           IF WS-CODE-DEP-ON-HAND = WS-A                                
              PERFORM 7600-GET-DEPOSIT-ON-HAND    THRU 7600-EXIT        
              IF WS-DEPOSIT-NULL-IND = 0                                
                 ADD DO-AMT-DEPOSIT TO WS-SECURITIES-TOTAL-CMP          
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 7700-GET-GUARANTEED-AMT     THRU 7700-EXIT.          
           IF WS-GUARANTEED-NULL-IND = 0                                
              ADD GU-AMOUNT-GUARANTEED TO WS-SECURITIES-TOTAL-CMP       
           END-IF.                                                      
                                                                        
           PERFORM 7800-GET-SURETY-BOND-AMT    THRU 7800-EXIT.          
           IF WS-BOND-NULL-IND = 0                                      
              ADD SB-AMT-BOND       TO WS-SECURITIES-TOTAL-CMP          
           END-IF.                                                      
                                                                        
           IF WS-SECURITIES-TOTAL-CMP = 0                               
              PERFORM 7900-CHECK-FOR-WAIVERS      THRU 7900-EXIT        
           END-IF.                                                      
                                                                        
           IF WS-WAIVER-EXISTS = WS-Y                                   
              MOVE WS-WAIVER-TEXT           TO RS-SECURITIES-TOTAL      
           ELSE                                                         
              MOVE WS-SECURITIES-TOTAL-CMP  TO WS-SECURITIES-TOTAL      
              IF WS-SECURITIES-TOTAL EQUAL ZERO                         
                 MOVE WS-1-ZERO             TO WS-SEC-TOT-RET-1         
                 MOVE WS-2-ZERO             TO WS-SEC-TOT-RET-2         
                 MOVE WS-SEC-TOT-RETURN-TXT TO RS-SECURITIES-TOTAL      
              ELSE                                                      
                 MOVE WS-SEC-TOT-1          TO WS-SEC-TOT-RET-1         
                 MOVE WS-SEC-TOT-2          TO WS-SEC-TOT-RET-2         
                 MOVE WS-SEC-TOT-RETURN-TXT TO RS-SECURITIES-TOTAL      
                 INSPECT RS-SECURITIES-TOTAL                            
                         REPLACING LEADING '0' BY SPACES                
              END-IF                                                    
           END-IF.                                                      
                                                                        
      ***********************************************************               
      * CALLING CPD00068 TO GET  PAST DUE AMOUNT                                
      ***********************************************************               
           MOVE WS-CURRENT-DATE            TO WS-CL-DATE-NOTICE-MAIL    
                                              WS-CL-DATE-NOTICE-DUE     
                                              WS-HOLD-DATE.             
                                                                        
           MOVE WS-DNP-TYPE                TO WS-HOLD-DNP-TYPE.         
                                                                        
PCR361* SET CPD00068 SWITCHES THAT ARE NEEDED.                                  
PCR361     MOVE 'Y'                        TO CALC-PAST-DUE-SW          
PCR361                                        CALC-ARREARS-SW           
TP9561                                        CALC-DNP-BAL-SW           
PCR361                                        CALC-BALANCE-SW.          
T22359     MOVE PROGRAM-NAME               TO WS-CPD00068-CALLING-PGM.  
T19557     MOVE SPACES                     TO ABEND-FUNCTION .          
T19557     PERFORM 9500-CALL-CPD00068      THRU 9500-EXIT.              
T19557     MOVE RS-RETURN-CODE             TO WS-ACTIVE-RETURN-CODE,    
T19557                                        SQLCODE.                  
T19557     IF ABEND-FUNCTION  > SPACES                                  
T19557        PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
T19557     END-IF.                                                      
           MOVE WS-AMT-PAST-DUE            TO RS-PAST-DUE-AMT.          
T21958     MOVE WS-AMT-PAST-DUE-UTL        TO RS-UTIL-PAST-DUE.         
T21958     MOVE WS-AMT-PAST-DUE-NONUTL     TO RS-NON-UTIL-PAST-DUE.     
           MOVE WS-AMT-DNP-BAL             TO RS-DNP-AMT.               
T23513     MOVE ZEROS                      TO WS-DATABASE.              
T23513     MOVE 'DATABASE'                 TO C8-DELINQ-CD.             
T23513     PERFORM 6500-GET-DATABASE    THRU 6500-EXIT.                 
TP8452     PERFORM 5650-GET-MAX-DEPOSIT THRU 5650-GET-MAX-DEPOSIT-EXIT. 
TP8452     MOVE WS-MAX-DEPOSIT-AMT         TO RS-MAX-DEPOSIT-AMT.       
                                                                        
A37061     IF AT-ACCOUNT-TYPE-CODE = 'R' OR 'C' OR 'I'                  
A37061        MOVE AT-ACCOUNT-TYPE-CODE       TO WS-ACCT-TYPE-CD        
A37061     ELSE                                                         
A37061        MOVE 'I'                        TO WS-ACCT-TYPE-CD        
A37061     END-IF.                                                      
                                                                        
      *****************************************************************         
      *    RETRIEVE DATA FROM CSS_RECONNECT IF PRESENT                *         
      ********@********************************************************         
                                                                        
           PERFORM 7300-SELECT-RECONNECT   THRU 7300-EXIT.              
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
TP7835        MOVE U7-RCNCT-NRML-HRS-FL    TO RS-NORMAL                 
TP7835        MOVE U7-RCNCT-ELEC-SVC-FL    TO RS-ELECTRIC               
TP7835        MOVE U7-RCNCT-GAS-SVC-FL     TO RS-GAS                    
PERF          MOVE PF-FIRST-NAME           TO RS-FIRST-NAME             
PERF          MOVE PF-LAST-NAME            TO RS-LAST-NAME              
PERF          MOVE PF-MIDDLE-NAME          TO RS-MIDDLE-NAME            
T23235        MOVE U7-RCNCT-ACCT-TYPE-CD   TO RS-ACCT-TYPE              
P00726        MOVE DL-LAST-UPDATE-TS       TO RS-LAST-UPDATE-TS         
P00726        MOVE DL-LAST-UPDATE-USERID   TO RS-LAST-UPDATE-USERID     
P00726        MOVE DL-RCC-BILL-OPTION-CD   TO RS-RCC-BILL-OPTION-CD     
P00726        IF WS-RCNCT-TERM-ID-NULL < 0                              
P00726           MOVE ZEROES               TO RS-RCNCT-TERM-ID          
P00726                                        WS-RCNCT-TERM-ID-NULL     
P00726        ELSE                                                      
P00726           MOVE DL-RCNCT-TERM-ID     TO RS-RCNCT-TERM-ID          
P00726        END-IF                                                    
                                                                        
              IF WS-DL-NULL-IND < 0                                     
                 MOVE SPACES               TO RS-RECONNECT-DATE         
              ELSE                                                      
                 MOVE DL-DATETIME-SETUP    TO RS-RECONNECT-DATE         
              END-IF                                                    
                                                                        
              MOVE DL-RECNCT-COLLECT-AMT   TO RS-RCNCT-CHRG-COLLECT     
              COMPUTE RS-DNP-COLLECT-AMT =                              
                      DL-AMT-TOT-RECONNECT -  DL-RECNCT-COLLECT-AMT     
              MOVE DL-AGREEMENT-COMMENTS   TO RS-AGREEMENT-COMMENTS     
C26296        MOVE DL-AUTO-DEP-AM          TO RS-NOTC-AUTO-DEP-AM       
C26296        MOVE DL-AUTO-DEP-CERT-NO     TO RS-AUTO-DEP-ID            
C26296        IF  DL-AUTO-DEP-CERT-NO > ZEROES                          
C26296            MOVE DL-AUTO-DEP-CERT-NO TO DO-DEPOSIT-CERT-NO        
C26296                                        DR-DEP-ITEM-ID            
C26296*           MOVE DL-AUTO-DEP-AM      TO RS-AUTO-DEP-AMT                   
C26296            MOVE AT-ACCOUNT-NO       TO DO-ACCOUNT-NO             
C26296                                        DR-ACCOUNT-NO             
C26296            MOVE 'B'                 TO DO-CODE-DEP-TYPE          
C26296            PERFORM 7960-GET-AUTO-DEP-ON-HAND THRU 7960-EXIT      
C26296            IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL           
C26296                MOVE WS-AUTO-AMT-DEPOSIT    TO RS-AUTO-DEP-AMT    
C26296                MOVE DO-AUTO-DEP-LTR-IND    TO RS-AUTO-DEP-LTR-IND
C26296* CODE COMMENTED OUT 04/14/05. DECISION MADE TO USE AMT_TRAN_BALAN        
C26296* AMT_TRAN_BALANCE FOR THE DEP ITEM ID TO DISPLAY CURRENT                 
C26296* DEP_TO_COLLECT.                                                         
C26296* CPD00068 RETURNS THE DEP AMT REMAINING TO BE COLLECTED IN               
C26296* WS-AMT-00-DAY-DEP. CODE SPECIAL TYPE 'R' IS USED FOR AUTO DEP           
C26296*               IF  WS-CODE-SPECIAL-TYPE-O = 'R'                          
C26296*                   MOVE WS-AMT-00-DAY-DEP  TO RS-DEP-TO-COLLECT          
C26296* SUBTRACT WS-AMT-00-DAY-DEP FROM RS-DNP-COLLECT-AMT                      
C26296* AS IT WILL BE PART OF DL-AMT-TOT-RECONNECT                              
C26296*                   SUBTRACT WS-AMT-00-DAY-DEP FROM                       
C26296*                            RS-DNP-COLLECT-AMT                           
C26296*               END-IF                                                    
C26296                PERFORM 7970-GET-AUTO-DEP-REQ THRU 7970-EXIT      
C26296                IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL       
C26296                    MOVE DR-DEP-BILL-OPTION-CD                    
C26296                                            TO RS-DEP-BILL-OPT-CD 
C26296                    MOVE DR-NO-SCHED-PYMTS  TO RS-NO-SCHED-PYMTS  
C26296* CODE ADDED ON 04/14/05 TO GET DEP-TO-COLLECT FROM AR_CNTL               
C26296* FOR BILL IMMEDIATE DEPOSITS                                             
C26296                    IF  DR-DEP-BILL-OPTION-CD = 'I'               
C26296                        MOVE AT-ACCOUNT-NO TO AC-ACCOUNT-NO       
C26296                        MOVE DL-AUTO-DEP-CERT-NO                  
C26296                                           TO AC-ITEM-ID          
C26296                        MOVE 80            TO AC-PYMT-PRIORITY-LVL
C26296                        PERFORM 7980-GET-AMT-ADEP-BAL             
C26296                           THRU 7980-EXIT                         
C26296                        MOVE WS-ADEP-BALANCE TO RS-DEP-TO-COLLECT 
C26296* SUBTRACT WS-ADEP-BALANCE FROM RS-DNP-COLLECT-AMT                        
C26296* AS IT WILL BE PART OF DL-AMT-TOT-RECONNECT                              
C26296                        SUBTRACT WS-ADEP-BALANCE FROM             
C26296                                 RS-DNP-COLLECT-AMT               
C26296                    END-IF                                        
C26296                END-IF                                            
C26296            ELSE                                                  
C26296* THIS IS WHEN THE AUTO DEPOSIT DOES NO EXIST ON CSS_DEP_ON_HAND          
C26296                MOVE ZEROES                 TO RS-AUTO-DEP-AMT    
C26296                                               RS-DEP-TO-COLLECT  
C26296                MOVE SPACES                 TO RS-AUTO-DEP-LTR-IND
C26296                                               RS-DEP-BILL-OPT-CD 
C26296                MOVE ZEROES                 TO RS-NO-SCHED-PYMTS  
C26296            END-IF                                                
C26296        ELSE                                                      
C26296            IF  DL-AUTO-DEP-AM > ZEROES                           
C26296                MOVE AT-COMPANY-NO     TO C8-COMPANY-NO           
C26296                MOVE 'DEP-NOTIFY-LETTER' TO C8-DELINQ-CD          
C26296                PERFORM 7910-GET-DELINQUENCY                      
C26296                   THRU 7910-EXIT                                 
C26296                MOVE C8-DELINQ-VALUE   TO RS-SEND-LTTR-DELINQ     
C26296                MOVE 'AM-DEP-MIN'      TO C8-DELINQ-CD            
C26296                PERFORM 7910-GET-DELINQUENCY                      
C26296                   THRU 7910-EXIT                                 
C26296                MOVE C8-DELINQ-VALUE   TO RS-MIN-AUTO-DEP-AMT     
C26296* THIS GETS THE NEXT BILL DATE TO BE USED IN THE MESSAGE BOX              
C26296* WHEN A INSTALLMENT AUTO DEPOSIT IS CHARGED                              
C26296                PERFORM 2230-GET-NEXT-BILL-DATE                   
C26296                   THRU 2230-EXIT                                 
C26296*                                                                         
C26296                PERFORM 2220-PROCESS-AUTO-DEPOSIT                 
C26296                   THRU 2220-EXIT                                 
C26296                IF WS-AUTODEP-CALL-SUCCESS = 'Y'                  
C26296                    MOVE WS-CSR03515-AUTO-DEP-AMT                 
C26296                                       TO RS-AUTO-DEP-AMT         
C26296                ELSE                                              
C26296                    MOVE ZEROES        TO RS-AUTO-DEP-AMT         
C26296                END-IF                                            
C26296                MOVE SPACES            TO RS-AUTO-DEP-LTR-IND     
C26296                                          RS-DEP-BILL-OPT-CD      
C26296                MOVE +1                TO RS-NO-SCHED-PYMTS       
C26296*     FOR PSNC DEFAULT IS BILL IMMEDIATE AND AGREEMENT TO COLLECT         
C26296*     WILL INCLUDE THE AUTO DEP AMT                                       
C26296                IF AT-COMPANY-NO = '26'                           
C26296                    MOVE DL-AUTO-DEP-AM TO RS-DEP-TO-COLLECT      
C26296                    MOVE 'I'           TO RS-DEP-BILL-OPT-CD      
C26296                ELSE                                              
C26296                    MOVE ZEROES        TO RS-DEP-TO-COLLECT       
C26296                    MOVE 'N'           TO RS-DEP-BILL-OPT-CD      
C26296                END-IF                                            
C26296                SUBTRACT RS-DEP-TO-COLLECT FROM RS-DNP-COLLECT-AMT
C26296            ELSE                                                  
C26296* THIS IS WHEN THE DL-AUTO-DEP-AM IS ZEROES                               
C26296                MOVE ZEROES                 TO RS-AUTO-DEP-AMT    
C26296                                               RS-DEP-TO-COLLECT  
C26296                MOVE SPACES                 TO RS-AUTO-DEP-LTR-IND
C26296                                               RS-DEP-BILL-OPT-CD 
C26296                MOVE ZEROES                 TO RS-NO-SCHED-PYMTS  
C26296            END-IF                                                
C26296        END-IF                                                    
T23235     ELSE                                                         
T23235        MOVE WS-ACCT-TYPE-CD         TO RS-ACCT-TYPE              
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 2210-CALC-NO-OF-DNPS                                           *        
      *                                                                *        
      *     CALLS NOTHING                                              *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-OUTPUT                              *        
      *                                                                *        
      *     BREAKDOWN THE DISCONNECT HISTORY AND THE DISCONNECT        *        
      *     EXCEPTIONAL HISTORY. EACH IS A SERIES OF 24 CODES          *        
      *     REPRESENTING THE LAST 24 MONTHS. A 4 INDICATES A DNP.      *        
      *     WE ARE ONLY CHECKING THE PREVIOUS YEAR.                    *        
      ******************************************************************        
                                                                        
       2210-CALC-NO-OF-DNPS.                                            
                                                                        
      *-----< START OFF BY READING THE ACCOUNT TABLE AND GETTING >              
      *-----< DISCONNECT EXEMPTION >                                            
                                                                        
           MOVE CZ-DISCONNECT-HIST   TO WS-DISC-HIST.                   
           MOVE CZ-DISC-EXCEPTN-HIST TO WS-EXCEPTIONAL-HIST.            
           MOVE 0                    TO RS-DNP-CNT.                     
           MOVE 1                    TO WS-PREV-MNTH.                   
                                                                        
           PERFORM UNTIL WS-PREV-MNTH > 12                              
                                                                        
              IF WS-DISC-HIST-BRKDWN(WS-PREV-MNTH) = WS-FOUR            
                 ADD 1 TO RS-DNP-CNT                                    
              END-IF                                                    
                                                                        
              IF WS-EXCEPTIONAL-HIST-BRKDWN(WS-PREV-MNTH) = WS-FOUR     
                 ADD 1 TO RS-DNP-CNT                                    
              END-IF                                                    
                                                                        
              ADD 1 TO WS-PREV-MNTH                                     
                                                                        
           END-PERFORM.                                                 
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C26296****************************************************************          
C26296* SETS INPUT PARAMETERS FOR CSR03515 TO RECALCULATE AUTO DNP   *          
C26296* DEPOSIT AMOUNT.                                              *          
C26296****************************************************************          
C26296*                                                                         
C26296 2220-PROCESS-AUTO-DEPOSIT.                                       
C26296*                                                                         
C26296     INITIALIZE WS-CSR03515-INPUT-PARM.                           
C26296     MOVE AT-ACCOUNT-NO         TO WS-CSR03515-ACCOUNT-NO         
C26296     MOVE 'PANEL125R'           TO WS-CSR03515-CALLING-PGM        
C26296     MOVE 'B'                   TO WS-CSR03515-AUTO-DEP-TYPE      
C26296*    MOVE CZ-AUTO-DEP-AM        TO WS-CSR03515-DL-AUTO-DEP-AMT            
C26296     MOVE ZEROES                TO WS-CSR03515-DL-AUTO-DEP-AMT    
C26296     MOVE SPACES                TO WS-CSR03515-USER-ID            
C26296     MOVE 'N'                   TO WS-CSR03515-ERROR-SW           
ACT239     MOVE SPACES                TO WS-CSR03515-BATCH-DATE         
C26296     PERFORM 7950-CALL-CSR03515 THRU 7950-EXIT.                   
C26296                                                                  
C26296 2220-EXIT.                                                       
C26296     EXIT.                                                        
C26296*                                                                         
C26296****************************************************************          
C26296*  THIS GETS THE NEXT BILL DATE USING COPYBOOK CPD00309        *          
C26296****************************************************************          
C26296*                                                                         
C26296 2230-GET-NEXT-BILL-DATE.                                         
C26296*                                                                         
C26296     PERFORM 7503-CALCULATE-TODAY   THRU 7503-EXIT                
C26296*                                                                         
C26296     PERFORM 5900-NEXT-BILL-DATE    THRU 5900-NEXT-BILL-DATE-EXIT 
C26296     IF  WS-NULL-DATE-EXTRACT EQUAL ZEROES                        
C26296         MOVE BN-DATE-EXTRACT         TO WS-REFORMAT-DATE         
C26296         MOVE WS-FORMAT-YEAR          TO WS-USA-YEAR              
C26296         MOVE WS-FORMAT-MONTH         TO WS-USA-MONTH             
C26296         MOVE WS-FORMAT-DAY           TO WS-USA-DAY               
C26296         MOVE WS-USA-DATE-FORMAT      TO RS-NEXT-BILL-DATE        
C26296     ELSE                                                         
C26296         MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
C26296         MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
C26296         MOVE '5900'                   TO ACTIVE-PARAGRAPH        
C26296         MOVE 'SELECT'                 TO ABEND-FUNCTION          
C26296         MOVE SPACES                   TO ABEND-SQL-PREDICATES    
C26296                                          ABEND-TABLES            
C26296         MOVE 'CSS_BILL_WINDOW'        TO TABLE-1                 
C26296         MOVE 'BILL_CYCLE'             TO TABLE-ELEMENT-1         
C26296         MOVE 'DATE_EXTRACT'           TO TABLE-ELEMENT-2         
C26296         MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-3         
C26296         MOVE BN-BILL-CYCLE            TO HOSTVAR-ELEMENT-1       
C26296         MOVE WS-CURRENT-DATE          TO HOSTVAR-ELEMENT-2       
C26296         MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-3       
C26296         PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT             
C26296     END-IF.                                                      
C26296*                                                                         
C26296 2230-EXIT.                                                       
C26296     EXIT.                                                        
C26296*                                                                         
T22668*****************************************************************         
T23513* 6500-GET-DATABASE.                                            *         
T22668*     SELECTS BILLING ENTITY (SEB OR SCEG) FROM CSS_DELINQUENCY *         
T22668*****************************************************************         
T23513 6500-GET-DATABASE.                                               
T22668                                                                  
T22668     EXEC SQL                                                     
T22668        SELECT DELINQ_VALUE                                       
T22668          INTO :C8-DELINQ-VALUE                                   
T22668          FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
T23513         WHERE DELINQ_CD = :C8-DELINQ-CD                          
T23501           AND COMPANY_NO = :AT-COMPANY-NO                        
A37061                                                           
T22668     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = :C8-DELINQ-CD                                  
MFA-TR*          AND COMPANY_NO = :AT-COMPANY-NO                                
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T22668                                                                  
T22668     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
T22668                                                                  
T22668     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T23513        MOVE C8-DELINQ-VALUE          TO WS-DATABASE              
T22668     ELSE                                                         
T22668        MOVE '6500'                     TO ACTIVE-PARAGRAPH       
T22668        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
T22668        MOVE 'SELECT'                   TO ABEND-FUNCTION         
T22668        MOVE 'CSS_DELINQUENCY'          TO TABLE-1                
T22668        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
T22668        MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
T22668        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
T22668     END-IF.                                                      
T22668                                                                  
T22668 6500-EXIT.                                                       
T22668     EXIT.                                                        
      *                                                                         
      *                                                                         
TP8452******************************************************************        
TP8452* INCLUDE COPYBOOK FOR DETERMINING MAX-DEPOSIT ESTIMATES         *        
TP8452******************************************************************        
TP8452*                                                                         
TP8452*                                                                         
TP8452     EXEC SQL                                                             
TP8452        INCLUDE CPD00308                                                  
TP8452     END-EXEC.                                                            
TP8452*                                                                         
C26296*                                                                         
C26296******************************************************************23772200
C26296* INCLUDE CPD00309 FOR NEXT BILL DATE CALCULATION                *23772300
C26296******************************************************************23772400
C26296     EXEC SQL                                                     23772500
C26296        INCLUDE CPD00309                                          23772600
C26296     END-EXEC.                                                    23773000
C26296*                                                                 23780000
      ******************************************************************        
      * 7000-SELECT-ACCOUNT                                            *        
      *                                                                *        
PCR361*     CALLS 9700-PROCESS-ABEND                                   *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     SELECTS A ROW FROM THE TABLE CSS_ACCOUNT                   *        
      ******************************************************************        
                                                                        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           MOVE '7000'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL                                                     
              SELECT AT.PREMISE_NO,                                     
                     AT.CODE_DISC_OK,                                   
                     AT.CUSTOMER_NO,                                    
                     AT.CODES_DATA_PRESENT,                             
                     AT.DATE_BILL_DAY_00,                               
                     AT.DATE_BILL_DAY_30,                               
                     AT.DATE_BILL_DAY_60,                               
                     AT.DATE_BILL_DAY_90,                               
                     AT.CREDIT_GROUP,                                   
                     AT.TOTAL_AR_BALANCE,                               
                     AT.LAST_PYMT_DATE,                                 
                     AT.LAST_PYMT_AMOUNT,                               
                     AT.CODE_STATUS_REASON,                             
                     AT.CODE_ACCT_STAT,                                 
                     REPLACE(REPLACE(CONVERT(CHAR(26), 
           AT.ACCT_FINALED_DT, 121), ' ', '-'), ':', '.') 
           ACCT_FINALED_DT,                                
                     AT.CREDIT_STATUS_CODE,                             
                     AT.BILL_CYCLE,                                     
                     REPLACE(REPLACE(CONVERT(CHAR(26), AT.LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,                        
                     AT.MST_SUB_ACCT_IND,                               
                     AT.CODE_MAJOR_ACCT,                                
                     AT.CT_METER_RATED_IND,                             
PCR361               AT.COMPANY_NO,                                     
PCR361               AT.LOCAL_OFFICE,                                   
PCR361               AT.BANKRUPTCY_IND,                                 
                     AT.NOTICE_EXEMPT_CD,                               
C28788               AT.IVR_EXEMPT_CD                                   
C26296              ,AT.REV_MTH_LST_NRML                                
C26296              ,AT.CODE_BILL_FREQ                                  
A37061              ,ACCOUNT_TYPE_CODE                                  
              INTO  :AT-PREMISE-NO,                                     
                    :AT-CODE-DISC-OK,                                   
                    :AT-CUSTOMER-NO,                                    
                    :AT-CODES-DATA-PRESENT,                             
                    :AT-DATE-BILL-DAY-00 :WS-BILL-DAY-00-NI,             
                    :AT-DATE-BILL-DAY-30 :WS-BILL-DAY-30-NI,             
                    :AT-DATE-BILL-DAY-60 :WS-BILL-DAY-60-NI,             
                    :AT-DATE-BILL-DAY-90 :WS-BILL-DAY-90-NI,             
                    :AT-CREDIT-GROUP,                                   
                    :AT-TOTAL-AR-BALANCE,                               
                    :AT-LAST-PYMT-DATE :WS-NULL-IND1,                    
                    :AT-LAST-PYMT-AMOUNT,                               
                    :AT-CODE-STATUS-REASON,                             
                    :AT-CODE-ACCT-STAT,                                 
                    :AT-ACCT-FINALED-DT :WS-NULL-IND2,                   
                    :AT-CREDIT-STATUS-CODE,                             
                    :AT-BILL-CYCLE,                                     
                    :AT-LAST-UPDATE-TS,                                 
                    :AT-MST-SUB-ACCT-IND,                               
                    :AT-CODE-MAJOR-ACCT,                                
                    :AT-CT-METER-RATED-IND,                             
PCR361              :AT-COMPANY-NO,                                     
PCR361              :AT-LOCAL-OFFICE,                                   
PCR361              :AT-BANKRUPTCY-IND,                                 
                    :AT-NOTICE-EXEMPT-CD,                               
C28788              :AT-IVR-EXEMPT-CD                                   
C26296             ,:AT-REV-MTH-LST-NRML                                
C26296             ,:AT-CODE-BILL-FREQ                                  
A37061             ,:AT-ACCOUNT-TYPE-CODE                               
              FROM  CSS_ACCOUNT AT WITH(READUNCOMMITTED)                        
              WHERE  AT.ACCOUNT_NO      = :AT-ACCOUNT-NO                
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.PREMISE_NO,                                             
MFA-TR*              AT.CODE_DISC_OK,                                           
MFA-TR*              AT.CUSTOMER_NO,                                            
MFA-TR*              AT.CODES_DATA_PRESENT,                                     
MFA-TR*              AT.DATE_BILL_DAY_00,                                       
MFA-TR*              AT.DATE_BILL_DAY_30,                                       
MFA-TR*              AT.DATE_BILL_DAY_60,                                       
MFA-TR*              AT.DATE_BILL_DAY_90,                                       
MFA-TR*              AT.CREDIT_GROUP,                                           
MFA-TR*              AT.TOTAL_AR_BALANCE,                                       
MFA-TR*              AT.LAST_PYMT_DATE,                                         
MFA-TR*              AT.LAST_PYMT_AMOUNT,                                       
MFA-TR*              AT.CODE_STATUS_REASON,                                     
MFA-TR*              AT.CODE_ACCT_STAT,                                         
MFA-TR*              AT.ACCT_FINALED_DT,                                        
MFA-TR*              AT.CREDIT_STATUS_CODE,                                     
MFA-TR*              AT.BILL_CYCLE,                                             
MFA-TR*              AT.LAST_UPDATE_TS,                                         
MFA-TR*              AT.MST_SUB_ACCT_IND,                                       
MFA-TR*              AT.CODE_MAJOR_ACCT,                                        
MFA-TR*              AT.CT_METER_RATED_IND,                                     
MFA-TR*              AT.COMPANY_NO,                                             
MFA-TR*              AT.LOCAL_OFFICE,                                           
MFA-TR*              AT.BANKRUPTCY_IND,                                         
MFA-TR*              AT.NOTICE_EXEMPT_CD,                                       
MFA-TR*              AT.IVR_EXEMPT_CD                                           
MFA-TR*             ,AT.REV_MTH_LST_NRML                                        
MFA-TR*             ,AT.CODE_BILL_FREQ                                          
MFA-TR*             ,ACCOUNT_TYPE_CODE                                          
MFA-TR*       INTO  :AT-PREMISE-NO,                                             
MFA-TR*             :AT-CODE-DISC-OK,                                           
MFA-TR*             :AT-CUSTOMER-NO,                                            
MFA-TR*             :AT-CODES-DATA-PRESENT,                                     
MFA-TR*             :AT-DATE-BILL-DAY-00:WS-BILL-DAY-00-NI,                     
MFA-TR*             :AT-DATE-BILL-DAY-30:WS-BILL-DAY-30-NI,                     
MFA-TR*             :AT-DATE-BILL-DAY-60:WS-BILL-DAY-60-NI,                     
MFA-TR*             :AT-DATE-BILL-DAY-90:WS-BILL-DAY-90-NI,                     
MFA-TR*             :AT-CREDIT-GROUP,                                           
MFA-TR*             :AT-TOTAL-AR-BALANCE,                                       
MFA-TR*             :AT-LAST-PYMT-DATE:WS-NULL-IND1,                            
MFA-TR*             :AT-LAST-PYMT-AMOUNT,                                       
MFA-TR*             :AT-CODE-STATUS-REASON,                                     
MFA-TR*             :AT-CODE-ACCT-STAT,                                         
MFA-TR*             :AT-ACCT-FINALED-DT:WS-NULL-IND2,                           
MFA-TR*             :AT-CREDIT-STATUS-CODE,                                     
MFA-TR*             :AT-BILL-CYCLE,                                             
MFA-TR*             :AT-LAST-UPDATE-TS,                                         
MFA-TR*             :AT-MST-SUB-ACCT-IND,                                       
MFA-TR*             :AT-CODE-MAJOR-ACCT,                                        
MFA-TR*             :AT-CT-METER-RATED-IND,                                     
MFA-TR*             :AT-COMPANY-NO,                                             
MFA-TR*             :AT-LOCAL-OFFICE,                                           
MFA-TR*             :AT-BANKRUPTCY-IND,                                         
MFA-TR*             :AT-NOTICE-EXEMPT-CD,                                       
MFA-TR*             :AT-IVR-EXEMPT-CD                                           
MFA-TR*            ,:AT-REV-MTH-LST-NRML                                        
MFA-TR*            ,:AT-CODE-BILL-FREQ                                          
MFA-TR*            ,:AT-ACCOUNT-TYPE-CODE                                       
MFA-TR*       FROM  CSS_ACCOUNT AT                                              
MFA-TR*       WHERE  AT.ACCOUNT_NO      = :AT-ACCOUNT-NO                        
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
                                                                        
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-SELECT-CREDIT-PROFILE                                     *        
      *                                                                *        
PCR361*     CALLS 9700-PROCESS-ABEND                                   *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     SELECTS A ROW FROM THE TABLE CSS_CREDIT_PROFILE            *        
      ******************************************************************        
                                                                        
       7100-SELECT-CREDIT-PROFILE.                                      
                                                                        
           MOVE '7100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL                                                     
              SELECT  CZ.CASH_ONLY_FL,                                  
                      CZ.DISCONNECT_HIST,                               
                      CZ.ARREARS_HIST,                                  
                      CZ.DISC_EXCEPTN_HIST,                             
                      CZ.NON_UTL_ARRER_HIST,                            
                      CZ.CR_GRP_EFFECT_DT,                              
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           CZ.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
              INTO   :CZ-CASH-ONLY-FL,                                  
                     :CZ-DISCONNECT-HIST,                               
                     :CZ-ARREARS-HIST,                                  
                     :CZ-DISC-EXCEPTN-HIST,                             
                     :CZ-NON-UTL-ARRER-HIST,                            
                     :CZ-CR-GRP-EFFECT-DT :WS-EFF-DATE-NULL-IND,         
                     :CZ-LAST-UPDATE-TS                                 
              FROM    CSS_CREDIT_PROFILE CZ WITH(READUNCOMMITTED)               
              WHERE   CZ.ACCOUNT_NO  =  :AT-ACCOUNT-NO                  
A37061                                                           
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  CZ.CASH_ONLY_FL,                                          
MFA-TR*               CZ.DISCONNECT_HIST,                                       
MFA-TR*               CZ.ARREARS_HIST,                                          
MFA-TR*               CZ.DISC_EXCEPTN_HIST,                                     
MFA-TR*               CZ.NON_UTL_ARRER_HIST,                                    
MFA-TR*               CZ.CR_GRP_EFFECT_DT,                                      
MFA-TR*               CZ.LAST_UPDATE_TS                                         
MFA-TR*       INTO   :CZ-CASH-ONLY-FL,                                          
MFA-TR*              :CZ-DISCONNECT-HIST,                                       
MFA-TR*              :CZ-ARREARS-HIST,                                          
MFA-TR*              :CZ-DISC-EXCEPTN-HIST,                                     
MFA-TR*              :CZ-NON-UTL-ARRER-HIST,                                    
MFA-TR*              :CZ-CR-GRP-EFFECT-DT:WS-EFF-DATE-NULL-IND,                 
MFA-TR*              :CZ-LAST-UPDATE-TS                                         
MFA-TR*       FROM    CSS_CREDIT_PROFILE CZ                                     
MFA-TR*       WHERE   CZ.ACCOUNT_NO  =  :AT-ACCOUNT-NO                          
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
           OR                         NOT-FOUND                         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_CREDIT_PROFILE'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
                                                                        
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-SELECT-BILL-DATE                                          *        
      *                                                                *        
PCR361*     CALLS 9700-PROCESS-ABEND                                   *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     SELECTS A ROW FROM THE TABLES CSS_BILLING_HDR AND          *        
      *     CSS_BILLING_DET. DATE_ORIG_BILL MUST BE NULL SO THAT IT IS *        
      *     NOT A CANCEL REBILL.                                       *        
      ******************************************************************        
                                                                        
       7200-SELECT-BILL-DATE.                                           
                                                                        
           MOVE '7200'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL                                                     
              SELECT CIS.CHAR2$DATE(MAX(BI.DATE_BILLED),'USA')                  
              INTO  :BI-DATE-BILLED :WS-DATE-BILLED-NULL-IND             
              FROM  CSS_BILLING_HDR BI WITH(READUNCOMMITTED),                   
                    CSS_BILLING_DET BG WITH(READUNCOMMITTED)                    
              WHERE  BI.ACCOUNT_NO      = :AT-ACCOUNT-NO                
              AND    BG.ACCOUNT_NO      =  BI.ACCOUNT_NO                
              AND    BG.BILL_NO         =  BI.BILL_NO                   
              AND    BG.DATE_ORIG_BILL  IS NULL                         
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CHAR(MAX(BI.DATE_BILLED),USA)                              
MFA-TR*       INTO  :BI-DATE-BILLED:WS-DATE-BILLED-NULL-IND                     
MFA-TR*       FROM  CSS_BILLING_HDR BI,                                         
MFA-TR*             CSS_BILLING_DET BG                                          
MFA-TR*       WHERE  BI.ACCOUNT_NO      = :AT-ACCOUNT-NO                        
MFA-TR*       AND    BG.ACCOUNT_NO      =  BI.ACCOUNT_NO                        
MFA-TR*       AND    BG.BILL_NO         =  BI.BILL_NO                           
MFA-TR*       AND    BG.DATE_ORIG_BILL  IS NULL                                 
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
           OR                         NOT-FOUND                         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE 'CSS_BILLING_HDR'          TO TABLE-1                
CBSI          MOVE 'CSS_BILLING_DET'          TO TABLE-2                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
                                                                        
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 7300-SELECT-RECONNECT                                          *        
      *                                                                *        
PCR361*     CALLS 9700-PROCESS-ABEND                                   *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     SELECTS A ROW FROM THE TABLE CSS_RECONNECT                 *        
      ******************************************************************        
                                                                        
       7300-SELECT-RECONNECT.                                           
                                                                        
           MOVE '7300'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL                                                     
              SELECT  PF.FIRST_NAME,                                    
                      PF.LAST_NAME,                                     
                      PF.MIDDLE_NAME,                                   
                      CIS.CHAR2$DATE(DL.DATETIME_SETUP,'USA'),                  
                      DL.AMT_TOT_RECONNECT,                             
                      DL.RECNCT_COLLECT_AMT,                            
                      DL.AGREEMENT_COMMENTS,                            
TP7835                U7.RCNCT_NRML_HRS_FL,                             
TP7835                U7.RCNCT_ELEC_SVC_FL,                             
TP7835                U7.RCNCT_GAS_SVC_FL,                              
T23235                U7.RCNCT_ACCT_TYPE_CD                             
C26296               ,DL.AUTO_DEP_AM                                    
C26296               ,DL.AUTO_DEP_CERT_NO                               
P00726               ,DL.RCNCT_TERM_ID                                  
P00726               ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           DL.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
P00726               ,DL.LAST_UPDATE_USERID                             
P00726               ,DL.RCC_BILL_OPTION_CD                             
              INTO   :PF-FIRST-NAME,                                    
                     :PF-LAST-NAME,                                     
                     :PF-MIDDLE-NAME,                                   
                     :DL-DATETIME-SETUP :WS-DL-NULL-IND,                 
                     :DL-AMT-TOT-RECONNECT,                             
                     :DL-RECNCT-COLLECT-AMT,                            
                     :DL-AGREEMENT-COMMENTS,                            
TP7835               :U7-RCNCT-NRML-HRS-FL,                             
TP7835               :U7-RCNCT-ELEC-SVC-FL,                             
TP7835               :U7-RCNCT-GAS-SVC-FL,                              
T23235               :U7-RCNCT-ACCT-TYPE-CD                             
C26296              ,:DL-AUTO-DEP-AM                                    
C26296              ,:DL-AUTO-DEP-CERT-NO                               
P00726              ,:DL-RCNCT-TERM-ID :WS-RCNCT-TERM-ID-NULL           
P00726              ,:DL-LAST-UPDATE-TS                                 
P00726              ,:DL-LAST-UPDATE-USERID                             
P00726              ,:DL-RCC-BILL-OPTION-CD                             
              FROM    CSS_RECONNECT      DL WITH(READUNCOMMITTED),              
PERF                  CSS_USER_PROFILE   PF WITH(READUNCOMMITTED),              
TP7835                CSS_RECONNECT_CHRG U7 WITH(READUNCOMMITTED)               
              WHERE   DL.ACCOUNT_NO     = :AT-ACCOUNT-NO                
PERF            AND   DL.USER_ID        = PF.USER_ID                    
TP7835          AND   DL.RECNCT_TYPE_CD = U7.RCNCT_TYPE_NO              
T23235          AND   U7.COMPANY_NO     = :AT-COMPANY-NO                
T23235          AND   U7.RCNCT_ACCT_TYPE_CD = :WS-ACCT-TYPE-CD          
A37061                                                           
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  PF.FIRST_NAME,                                            
MFA-TR*               PF.LAST_NAME,                                             
MFA-TR*               PF.MIDDLE_NAME,                                           
MFA-TR*               CHAR(DL.DATETIME_SETUP,USA),                              
MFA-TR*               DL.AMT_TOT_RECONNECT,                                     
MFA-TR*               DL.RECNCT_COLLECT_AMT,                                    
MFA-TR*               DL.AGREEMENT_COMMENTS,                                    
MFA-TR*               U7.RCNCT_NRML_HRS_FL,                                     
MFA-TR*               U7.RCNCT_ELEC_SVC_FL,                                     
MFA-TR*               U7.RCNCT_GAS_SVC_FL,                                      
MFA-TR*               U7.RCNCT_ACCT_TYPE_CD                                     
MFA-TR*              ,DL.AUTO_DEP_AM                                            
MFA-TR*              ,DL.AUTO_DEP_CERT_NO                                       
MFA-TR*              ,DL.RCNCT_TERM_ID                                          
MFA-TR*              ,DL.LAST_UPDATE_TS                                         
MFA-TR*              ,DL.LAST_UPDATE_USERID                                     
MFA-TR*              ,DL.RCC_BILL_OPTION_CD                                     
MFA-TR*       INTO   :PF-FIRST-NAME,                                            
MFA-TR*              :PF-LAST-NAME,                                             
MFA-TR*              :PF-MIDDLE-NAME,                                           
MFA-TR*              :DL-DATETIME-SETUP:WS-DL-NULL-IND,                         
MFA-TR*              :DL-AMT-TOT-RECONNECT,                                     
MFA-TR*              :DL-RECNCT-COLLECT-AMT,                                    
MFA-TR*              :DL-AGREEMENT-COMMENTS,                                    
MFA-TR*              :U7-RCNCT-NRML-HRS-FL,                                     
MFA-TR*              :U7-RCNCT-ELEC-SVC-FL,                                     
MFA-TR*              :U7-RCNCT-GAS-SVC-FL,                                      
MFA-TR*              :U7-RCNCT-ACCT-TYPE-CD                                     
MFA-TR*             ,:DL-AUTO-DEP-AM                                            
MFA-TR*             ,:DL-AUTO-DEP-CERT-NO                                       
MFA-TR*             ,:DL-RCNCT-TERM-ID :WS-RCNCT-TERM-ID-NULL                   
MFA-TR*             ,:DL-LAST-UPDATE-TS                                         
MFA-TR*             ,:DL-LAST-UPDATE-USERID                                     
MFA-TR*             ,:DL-RCC-BILL-OPTION-CD                                     
MFA-TR*       FROM    CSS_RECONNECT      DL,                                    
MFA-TR*               CSS_USER_PROFILE   PF,                                    
MFA-TR*               CSS_RECONNECT_CHRG U7                                     
MFA-TR*       WHERE   DL.ACCOUNT_NO     = :AT-ACCOUNT-NO                        
MFA-TR*         AND   DL.USER_ID        = PF.USER_ID                            
MFA-TR*         AND   DL.RECNCT_TYPE_CD = U7.RCNCT_TYPE_NO                      
MFA-TR*         AND   U7.COMPANY_NO     = :AT-COMPANY-NO                        
MFA-TR*         AND   U7.RCNCT_ACCT_TYPE_CD = :WS-ACCT-TYPE-CD                  
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
           OR                         NOT-FOUND                         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_RECONNECT     '       TO TABLE-1                
CBSI          MOVE 'CSS_USER_PROFILE'         TO TABLE-2                
CBSI          MOVE 'CSS_RECONNECT_CHRG'       TO TABLE-3                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
                                                                        
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7500-CALC-NO-OF-RET-CHKS                                       *        
      *                                                                *        
PCR361*     CALLS 9700-PROCESS-ABEND                                   *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     COUNTS THE NUMBER OF RETURNED CHECKS/DRAFTS IN THE LAST    *        
      *     YEAR.                                                      *        
      ******************************************************************        
                                                                        
       7500-CALC-NO-OF-RET-CHKS.                                        
                                                                        
           MOVE '7500'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL                                                     
              SELECT COUNT(*)                                           
              INTO  :RS-RET-CHK-CNT                                     
              FROM   CSS_NSF_HIST NH WITH(READUNCOMMITTED)                      
              WHERE  NH.ACCOUNT_NO      = :AT-ACCOUNT-NO                
              AND    NH.NSF_STATUS_CD   = :WS-C                         
              AND    NH.DATE_TRAN       > IIF(TRY_CONVERT(DATE, 
                                                       :WS-ONE-YEAR-AGO
              ) IS NULL OR (PATINDEX('%.%', :WS-ONE-YEAR-AGO
              ) <> 0) OR (LEN(:WS-ONE-YEAR-AGO) <> 10), CIS.CHAR2DATE(
                                                       :WS-ONE-YEAR-AGO
              ), CONVERT(DATE, :WS-ONE-YEAR-AGO) )              
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(*)                                                   
MFA-TR*       INTO  :RS-RET-CHK-CNT                                             
MFA-TR*       FROM   CSS_NSF_HIST NH                                            
MFA-TR*       WHERE  NH.ACCOUNT_NO      = :AT-ACCOUNT-NO                        
MFA-TR*       AND    NH.NSF_STATUS_CD   = :WS-C                                 
MFA-TR*       AND    NH.DATE_TRAN       > :WS-ONE-YEAR-AGO                      
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
           OR                         NOT-FOUND                         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_NSF_HIST'             TO TABLE-1                
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE 'DATE_TRAN'                TO TABLE-ELEMENT-2        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE WS-ONE-YEAR-AGO            TO HOSTVAR-ELEMENT-2      
                                                                        
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7501-CALCULATE-ONE-YEAR-AGO                                    *        
      *                                                                *        
PCR361*     CALLS 9700-PROCESS-ABEND                                   *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     WORKS OUT THE DATE ONE YEAR AGO                            *        
      ******************************************************************        
                                                                        
       7501-CALCULATE-ONE-YEAR-AGO.                                     
                                                                        
           MOVE '7501'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL                                                     
A37061        SELECT
              DATEADD( MONTH, -12, CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-ONE-YEAR-AGO           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-ONE-YEAR-AGO = CURRENT DATE - 12 MONTHS                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
           OR                         NOT-FOUND                         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'SELECT'                   TO ABEND-FUNCTION         
A37061        MOVE 'SYSIBM.SYSDUMMY1'         TO TABLE-1                
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE PARM-ACCOUNT-NUM           TO HOSTVAR-ELEMENT-1      
                                                                        
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7501-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7503-CALCULATE-TODAY                                           *        
      *                                                                *        
PCR361*     CALLS 9700-PROCESS-ABEND                                   *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     WORKS OUT TODAYS DATE                                      *        
      ******************************************************************        
                                                                        
       7503-CALCULATE-TODAY.                                            
                                                                        
           MOVE '7503'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE = CURRENT DATE                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
           OR                         NOT-FOUND                         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'SET'                      TO ABEND-FUNCTION         
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE PARM-ACCOUNT-NUM           TO HOSTVAR-ELEMENT-1      
                                                                        
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7503-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7600-GET-DEPOSIT-ON-HAND                                       *        
      *                                                                *        
PCR361*     CALLS 9700-PROCESS-ABEND                                   *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     GETS THE DEPOSIT ON HAND                                   *        
      ******************************************************************        
                                                                        
       7600-GET-DEPOSIT-ON-HAND.                                        
                                                                        
           MOVE '7600'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
               SELECT SUM(AMT_DEPOSIT)                                  
               INTO  :DO-AMT-DEPOSIT :WS-DEPOSIT-NULL-IND                
               FROM   CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                     
               WHERE  ACCOUNT_NO          = :AT-ACCOUNT-NO              
               AND    ( DEPOSIT_STATUS_CD = :WS-P                       
               OR       DEPOSIT_STATUS_CD = :WS-A )                     
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(AMT_DEPOSIT)                                          
MFA-TR*        INTO  :DO-AMT-DEPOSIT:WS-DEPOSIT-NULL-IND                        
MFA-TR*        FROM   CSS_DEP_ON_HAND                                           
MFA-TR*        WHERE  ACCOUNT_NO          = :AT-ACCOUNT-NO                      
MFA-TR*        AND    ( DEPOSIT_STATUS_CD = :WS-P                               
MFA-TR*        OR       DEPOSIT_STATUS_CD = :WS-A )                             
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
           OR                         NOT-FOUND                         
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
CBSI          MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_DEP_ON_HAND'   TO TABLE-1                       
CBSI          MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
PCR361        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7700-GET-GUARANTEED-AMT                                        *        
      *                                                                *        
PCR361*     CALLS 9700-PROCESS-ABEND                                   *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     GET THE GUARANTEED AMOUNT                                  *        
      ******************************************************************        
                                                                        
       7700-GET-GUARANTEED-AMT.                                         
                                                                        
           MOVE '7700'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
               SELECT SUM(AMOUNT_GUARANTEED)                            
               INTO  :GU-AMOUNT-GUARANTEED :WS-GUARANTEED-NULL-IND       
               FROM   CSS_GUARANTOR WITH(READUNCOMMITTED)                       
               WHERE  ACCOUNT_NO     = :AT-ACCOUNT-NO                   
               AND    GUAR_STATUS_CD = :WS-A                            
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(AMOUNT_GUARANTEED)                                    
MFA-TR*        INTO  :GU-AMOUNT-GUARANTEED:WS-GUARANTEED-NULL-IND               
MFA-TR*        FROM   CSS_GUARANTOR                                             
MFA-TR*        WHERE  ACCOUNT_NO     = :AT-ACCOUNT-NO                           
MFA-TR*        AND    GUAR_STATUS_CD = :WS-A                                    
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
           OR                         NOT-FOUND                         
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
CBSI          MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_GUARANTOR'     TO TABLE-1                       
CBSI          MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
PCR361        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7800-GET-SURETY-BOND-AMT                                       *        
      *                                                                *        
PCR361*     CALLS 9700-PROCESS-ABEND                                   *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     GETS AMT FROM SURETY BOND TABLE - COULD BE SURETY BOND (A) *        
      *     OR IRREVOCABLE LETTER OF CREDIT (B)                        *        
      ******************************************************************        
                                                                        
       7800-GET-SURETY-BOND-AMT.                                        
                                                                        
           MOVE '7800'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
               SELECT SUM(AMT_BOND)                                     
               INTO  :SB-AMT-BOND :WS-BOND-NULL-IND                      
               FROM   CSS_SURETY_BOND WITH(READUNCOMMITTED)                     
               WHERE  ACCOUNT_NO      = :AT-ACCOUNT-NO                  
               AND    CODE_BOND_TYPE  IN ('A', 'B')                     
               AND    CODE_STATUS     = :WS-A                           
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(AMT_BOND)                                             
MFA-TR*        INTO  :SB-AMT-BOND:WS-BOND-NULL-IND                              
MFA-TR*        FROM   CSS_SURETY_BOND                                           
MFA-TR*        WHERE  ACCOUNT_NO      = :AT-ACCOUNT-NO                          
MFA-TR*        AND    CODE_BOND_TYPE  IN ('A', 'B')                             
MFA-TR*        AND    CODE_STATUS     = :WS-A                                   
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
           OR                         NOT-FOUND                         
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
CBSI          MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_SURETY_BOND'   TO TABLE-1                       
CBSI          MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
PCR361        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7900-CHECK-FOR-WAIVERS                                         *        
      *                                                                *        
PCR361*     CALLS 9700-PROCESS-ABEND                                   *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     CHECKS TO SEE IF A WAIVER EXISTS                           *        
      ******************************************************************        
                                                                        
       7900-CHECK-FOR-WAIVERS.                                          
                                                                        
           MOVE '7900'              TO ACTIVE-PARAGRAPH.                
                                                                        
           MOVE WS-NO               TO WS-WAIVER-EXISTS.                
                                                                        
           EXEC SQL                                                     
T23934*                                                                         
T23934         SELECT DISTINCT 'Y'                                      
               INTO  :WS-WAIVER-EXISTS                                  
               FROM   CSS_SURETY_BOND WITH(READUNCOMMITTED)                     
               WHERE  ACCOUNT_NO      = :AT-ACCOUNT-NO                  
               AND    CODE_BOND_TYPE  = :WS-C                           
               AND    CODE_STATUS     = :WS-A                           
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        SELECT DISTINCT 'Y'                                              
MFA-TR*        INTO  :WS-WAIVER-EXISTS                                          
MFA-TR*        FROM   CSS_SURETY_BOND                                           
MFA-TR*        WHERE  ACCOUNT_NO      = :AT-ACCOUNT-NO                          
MFA-TR*        AND    CODE_BOND_TYPE  = :WS-C                                   
MFA-TR*        AND    CODE_STATUS     = :WS-A                                   
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
           OR                       = NOT-FOUND                         
              MOVE SUCCESSFUL-CALL TO  WS-ACTIVE-RETURN-CODE            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
CBSI          MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_SURETY_BOND'   TO TABLE-1                       
CBSI          MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
PCR361        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
C26296                                                                  
C26296*****************************************************************         
C26296* 7910-GET-DELINQUENCY.                                         *         
C26296*     SELECTS DELINQUENCY VALUE FROM CSS_DELINQUENCY            *         
C26296*****************************************************************         
C26296 7910-GET-DELINQUENCY.                                            
C26296                                                                  
C26296     EXEC SQL                                                     
C26296        SELECT DELINQ_VALUE                                       
C26296          INTO :C8-DELINQ-VALUE                                   
C26296          FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
C26296         WHERE DELINQ_CD = :C8-DELINQ-CD                          
C26296           AND COMPANY_NO = :C8-COMPANY-NO                        
A37061                                                           
C26296     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = :C8-DELINQ-CD                                  
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                                
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26296                                                                  
C26296     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
C26296                                                                  
C26296     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C26296        CONTINUE                                                  
C26296     ELSE                                                         
C26296        MOVE '7910'                     TO ACTIVE-PARAGRAPH       
C26296        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
C26296        MOVE 'SELECT'                   TO ABEND-FUNCTION         
C26296        MOVE 'CSS_DELINQUENCY'          TO TABLE-1                
C26296        MOVE 'DELINQ_CD'                TO TABLE-ELEMENT-1        
C26296        MOVE C8-DELINQ-CD               TO HOSTVAR-ELEMENT-1      
C26296        MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-2        
C26296        MOVE C8-COMPANY-NO              TO HOSTVAR-ELEMENT-2      
C26296        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-3        
C26296        MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-3      
C26296        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
C26296     END-IF.                                                      
C26296                                                                  
C26296 7910-EXIT.                                                       
C26296     EXIT.                                                        
C26296*                                                                         
C26296***************************************************************           
C26296* THIS PARAGRAPH CALLS CSR03515 TO GET THE AUTO DEPOSIT AMT   *           
C26296***************************************************************           
C26296 7950-CALL-CSR03515.                                              
C26296                                                                  
C26296     INITIALIZE WS-CSR03515-OUTPUT-FIELDS                         
C26296*               WS-AUTO-DEP-CERT-NO.                                      
C26296*    EXEC SQL CALL CSR03515                                       
C26296*        (:WS-CSR03515-ACCOUNT-NO                                 
C26296*        ,:WS-CSR03515-CALLING-PGM                                
C26296*        ,:WS-CSR03515-AUTO-DEP-TYPE                              
C26296*        ,:WS-CSR03515-DL-AUTO-DEP-AMT                            
C26296*        ,:WS-CSR03515-USER-ID                                    
C26296*        ,:WS-CSR03515-ERROR-SW                                   
ACT239*        ,:WS-CSR03515-BATCH-DATE)                                
C26296*    END-EXEC                                                     

MSQ001        EXEC SQL
MSQ001          CLOSE AUTO_DEP
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN AUTO_DEP
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR AUTO_DEP INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
C26296      MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE      
C26296      IF  WS-ACTIVE-RETURN-CODE = +466                            
C26296*         EXEC SQL ASSOCIATE LOCATORS(:LOC1) WITH PROCEDURE       
C26296*            CSR03515                                             
C26296*         END-EXEC                                                
C26296*         EXEC SQL                                                
C26296*           ALLOCATE AUTO_DEP CURSOR FOR RESULT SET :LOC1         
C26296*         END-EXEC                                                
C26296                                                                  
C26296          EXEC SQL                                                
C26296            FETCH AUTO_DEP                                        
C26296             INTO         :WS-CSR03515-RETURN-CODE                
C26296                         ,:WS-CSR03515-AUTO-DEP-AMT               
C26296                         ,:WS-CSR03515-DEP-SUCCESS                
C26296                         ,:WS-CSR03515-DEP-CERT-NO                
C26296                         ,:WS-CSR03515-MAX-DEP-ZERO-WQ            
C26296                         ,:WS-CSR03515-AMT-SECURED                
C26296                         ,:WS-CSR03515-ABEND-PROGRAM              
C26296                         ,:WS-CSR03515-ACTIVE-PARAGRAPH           
C26296                         ,:WS-CSR03515-ABEND-FUNCTION             
C26296                         ,:WS-CSR03515-TABLE-1                    
C26296                         ,:WS-CSR03515-TABLE-ELEMENT-1            
C26296                         ,:WS-CSR03515-HOSTVAR-ELEMENT-1          
C26296                         ,:WS-CSR03515-TABLE-ELEMENT-2            
C26296                         ,:WS-CSR03515-HOSTVAR-ELEMENT-2          
C26296                         ,:WS-CSR03515-TABLE-ELEMENT-3            
C26296                         ,:WS-CSR03515-HOSTVAR-ELEMENT-3          
C26296                         ,:WS-CSR03515-TABLE-ELEMENT-4            
C26296                         ,:WS-CSR03515-HOSTVAR-ELEMENT-4          
C26296          END-EXEC                                                

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26296          MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE  
C26296          IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
C26296              EVALUATE WS-CSR03515-RETURN-CODE                    
C26296                  WHEN 0                                          
C26296                      MOVE 'Y' TO WS-AUTODEP-CALL-SUCCESS         
C26296*                     MOVE WS-CSR03515-DEP-CERT-NO                        
C26296*                       TO WS-AUTO-DEP-CERT-NO                            
C26296                  WHEN OTHER                                      
C26296                      MOVE 'N' TO WS-AUTODEP-CALL-SUCCESS         
C26296                      MOVE WS-CSR03515-RETURN-CODE                
C26296                      TO WS-ACTIVE-RETURN-CODE                    
C26296                      MOVE PROGRAM-NAME                           
C26296                      TO ABEND-PROGRAM                            
C26296                      MOVE WS-CSR03515-ACTIVE-PARAGRAPH           
C26296                      TO ACTIVE-PARAGRAPH                         
C26296                      MOVE WS-CSR03515-ABEND-PROGRAM              
C26296                      TO ABEND-FUNCTION                           
C26296                      MOVE WS-CSR03515-TABLE-1                    
C26296                      TO TABLE-1                                  
C26296                      MOVE WS-CSR03515-TABLE-ELEMENT-1            
C26296                      TO TABLE-ELEMENT-1                          
C26296                      MOVE WS-CSR03515-HOSTVAR-ELEMENT-1          
C26296                      TO HOSTVAR-ELEMENT-1                        
C26296                      MOVE WS-CSR03515-TABLE-ELEMENT-2            
C26296                      TO TABLE-ELEMENT-2                          
C26296                      MOVE WS-CSR03515-HOSTVAR-ELEMENT-2          
C26296                      TO HOSTVAR-ELEMENT-2                        
C26296                      MOVE WS-CSR03515-TABLE-ELEMENT-3            
C26296                      TO TABLE-ELEMENT-3                          
C26296                      MOVE WS-CSR03515-HOSTVAR-ELEMENT-3          
C26296                      TO HOSTVAR-ELEMENT-3                        
C26296                      MOVE WS-CSR03515-TABLE-ELEMENT-4            
C26296                      TO TABLE-ELEMENT-4                          
C26296                      MOVE WS-CSR03515-HOSTVAR-ELEMENT-4          
C26296                      TO HOSTVAR-ELEMENT-4                        
C26296                      PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT   
C26296              END-EVALUATE                                        
C26296          ELSE                                                    
C26296              MOVE 'N' TO WS-AUTODEP-CALL-SUCCESS                 
C26296              MOVE '7950'               TO ACTIVE-PARAGRAPH       
C26296              MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
C26296              MOVE 'FETCH'              TO ABEND-FUNCTION         
C26296              MOVE 'CSR03515'           TO TABLE-1                
C26296              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1        
C26296              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1      
C26296              MOVE 'SQLCODE '           TO TABLE-ELEMENT-1        
C26296              MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-1     
C26296              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
C26296          END-IF                                                  
C26296          EXEC SQL                                                
C26296            CLOSE AUTO_DEP                                        
C26296          END-EXEC                                                

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26296          MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE  
C26296          IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
C26296              CONTINUE                                            
C26296          ELSE                                                    
C26296              MOVE 'N' TO WS-AUTODEP-CALL-SUCCESS                 
C26296              MOVE '7950'               TO ACTIVE-PARAGRAPH       
C26296              MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
C26296              MOVE 'CLOSE'              TO ABEND-FUNCTION         
C26296              MOVE 'CSR03515'           TO TABLE-1                
C26296              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1        
C26296              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1      
C26296              MOVE 'SQLCODE '           TO TABLE-ELEMENT-1        
C26296              MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-1     
C26296              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
C26296          END-IF                                                  
C26296      ELSE                                                        
C26296          MOVE -1                       TO WS-ACTIVE-RETURN-CODE  
C26296          MOVE '7950'                   TO ACTIVE-PARAGRAPH       
C26296          MOVE PROGRAM-NAME             TO ABEND-PROGRAM          
C26296          MOVE 'DB2SP CALL'             TO ABEND-FUNCTION         
C26296          MOVE 'CSR03515'               TO TABLE-1                
C26296          MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1        
C26296          MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1      
C26296          MOVE 'SQLCODE'                TO TABLE-ELEMENT-1        
C26296          MOVE SQLCODE                  TO HOSTVAR-ELEMENT-1      
C26296          PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT            
C26296      END-IF.                                                     
C26296*                                                                         
C26296 7950-EXIT.                                                       
C26296     EXIT.                                                        
C26296*                                                                         
C26296******************************************************************        
C26296* 7960-GET-AUTO-DEP-ON-HAND                                      *        
C26296*                                                                *        
C26296*     CALLS 9700-PROCESS-ABEND                                   *        
C26296*                                                                *        
C26296*     CALLED FROM 2200-BUILD-RESULT                              *        
C26296*                                                                *        
C26296*     GETS THE DETAILS OF AUTO DEPOSIT ON HAND                   *        
C26296******************************************************************        
C26296 7960-GET-AUTO-DEP-ON-HAND.                                       
C26296                                                                  
C26296     MOVE '7960'              TO ACTIVE-PARAGRAPH.                
C26296                                                                  
C26296     EXEC SQL                                                     
C26296         SELECT AMT_DEPOSIT                                       
C26296               ,AUTO_DEP_LTR_IND                                  
C26296         INTO  :WS-AUTO-AMT-DEPOSIT                               
C26296              ,:DO-AUTO-DEP-LTR-IND                               
C26296         FROM   CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                     
C26296         WHERE  ACCOUNT_NO          = :DO-ACCOUNT-NO              
C26296         AND    DEPOSIT_CERT_NO     = :DO-DEPOSIT-CERT-NO         
C26296         AND    CODE_DEP_TYPE       = :DO-CODE-DEP-TYPE           
A37061                                                           
C26296******   AND    ( DEPOSIT_STATUS_CD = :WS-P                               
C26296******   OR       DEPOSIT_STATUS_CD = :WS-A )                             
C26296     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AMT_DEPOSIT                                               
MFA-TR*              ,AUTO_DEP_LTR_IND                                          
MFA-TR*        INTO  :WS-AUTO-AMT-DEPOSIT                                       
MFA-TR*             ,:DO-AUTO-DEP-LTR-IND                                       
MFA-TR*        FROM   CSS_DEP_ON_HAND                                           
MFA-TR*        WHERE  ACCOUNT_NO          = :DO-ACCOUNT-NO                      
MFA-TR*        AND    DEPOSIT_CERT_NO     = :DO-DEPOSIT-CERT-NO                 
MFA-TR*        AND    CODE_DEP_TYPE       = :DO-CODE-DEP-TYPE                   
MFA-TR*        WITH UR                                                          
MFA-TR******   AND    ( DEPOSIT_STATUS_CD = :WS-P                               
MFA-TR******   OR       DEPOSIT_STATUS_CD = :WS-A )                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26296                                                                  
C26296     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C26296                                                                  
C26296     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C26296     OR                         NOT-FOUND                         
C26296         NEXT SENTENCE                                            
C26296     ELSE                                                         
C26296        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
C26296        MOVE 'SELECT'            TO ABEND-FUNCTION                
C26296        MOVE 'CSS_DEP_ON_HAND'   TO TABLE-1                       
C26296        MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
C26296        MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
C26296        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
C26296     END-IF.                                                      
C26296                                                                  
C26296 7960-EXIT.                                                       
C26296     EXIT.                                                        
C26296*                                                                         
C26296******************************************************************        
C26296* 7970-GET-AUTO-DEP-REQ                                          *        
C26296*                                                                *        
C26296*     CALLS 9700-PROCESS-ABEND                                   *        
C26296*                                                                *        
C26296*     CALLED FROM 2200-BUILD-RESULT                              *        
C26296*                                                                *        
C26296*     GETS THE DETAILS OF AUTO DEPOSIT  FROM CSS_DEP_REQ         *        
C26296******************************************************************        
C26296 7970-GET-AUTO-DEP-REQ.                                           
C26296                                                                  
C26296     MOVE '7970'              TO ACTIVE-PARAGRAPH.                
C26296                                                                  
C26296     EXEC SQL                                                     
C26296         SELECT DEP_BILL_OPTION_CD                                
C26296               ,NO_SCHED_PYMTS                                    
C26296         INTO  :DR-DEP-BILL-OPTION-CD                             
C26296              ,:DR-NO-SCHED-PYMTS                                 
C26296         FROM   CSS_DEP_REQ WITH(READUNCOMMITTED)                         
C26296         WHERE  ACCOUNT_NO  = :DR-ACCOUNT-NO                      
C26296         AND    DEP_ITEM_ID = :DR-DEP-ITEM-ID                     
A37061                                                           
C26296     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DEP_BILL_OPTION_CD                                        
MFA-TR*              ,NO_SCHED_PYMTS                                            
MFA-TR*        INTO  :DR-DEP-BILL-OPTION-CD                                     
MFA-TR*             ,:DR-NO-SCHED-PYMTS                                         
MFA-TR*        FROM   CSS_DEP_REQ                                               
MFA-TR*        WHERE  ACCOUNT_NO  = :DR-ACCOUNT-NO                              
MFA-TR*        AND    DEP_ITEM_ID = :DR-DEP-ITEM-ID                             
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26296                                                                  
C26296     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C26296                                                                  
C26296     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C26296     OR                         NOT-FOUND                         
C26296         NEXT SENTENCE                                            
C26296     ELSE                                                         
C26296        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
C26296        MOVE 'SELECT'            TO ABEND-FUNCTION                
C26296        MOVE 'CSS_DEP_ON_HAND'   TO TABLE-1                       
C26296        MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
C26296        MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
C26296        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
C26296     END-IF.                                                      
C26296                                                                  
C26296 7970-EXIT.                                                       
C26296     EXIT.                                                        
C26296*                                                                         
C26296******************************************************************        
C26296* 7980-GET-AMT-ADEP-BAL                                          *        
C26296*                                                                *        
C26296*     CALLS 9700-PROCESS-ABEND                                   *        
C26296*                                                                *        
C26296*     CALLED FROM 2200-BUILD-RESULT                              *        
C26296*                                                                *        
C26296*     GETS THE AUTO DNP DEPOSIT BALANCE FROM CSS_AR_CNTL         *        
C26296******************************************************************        
C26296 7980-GET-AMT-ADEP-BAL.                                           
C26296                                                                  
C26296     MOVE '7980'              TO ACTIVE-PARAGRAPH.                
C26296                                                                  
C26296     EXEC SQL                                                     
C26296         SELECT SUM(AMT_AR_DAY_00 +                               
C26296                    AMT_AR_DAY_30 +                               
C26296                    AMT_AR_DAY_60 +                               
C26296                    AMT_AR_DAY_90)                                
C26296         INTO  :WS-ADEP-BALANCE :WS-NULL-IND3                      
C26296         FROM   CSS_AR_CNTL AC WITH(READUNCOMMITTED)                      
C26296         WHERE  ACCOUNT_NO        = :AC-ACCOUNT-NO                
C26296         AND    PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL         
C26296         AND    ITEM_ID           = :AC-ITEM-ID                   
A37061                                                           
C26296     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM(AMT_AR_DAY_00 +                                       
MFA-TR*                   AMT_AR_DAY_30 +                                       
MFA-TR*                   AMT_AR_DAY_60 +                                       
MFA-TR*                   AMT_AR_DAY_90)                                        
MFA-TR*        INTO  :WS-ADEP-BALANCE:WS-NULL-IND3                              
MFA-TR*        FROM   CSS_AR_CNTL AC                                            
MFA-TR*        WHERE  ACCOUNT_NO        = :AC-ACCOUNT-NO                        
MFA-TR*        AND    PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL                 
MFA-TR*        AND    ITEM_ID           = :AC-ITEM-ID                           
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26296                                                                  
C26296     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C26296                                                                  
C26296     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
C26296     OR                          NOT-FOUND                        
C26296         IF  WS-NULL-IND3 < ZERO                                  
C26296             MOVE ZEROES          TO WS-ADEP-BALANCE              
C26296                                     WS-NULL-IND3                 
C26296         END-IF                                                   
C26296     ELSE                                                         
C26296        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
C26296        MOVE 'SELECT'             TO ABEND-FUNCTION               
C26296        MOVE 'CSS_AR_CNTL'        TO TABLE-1                      
C26296        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
C26296        MOVE AC-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
C26296        MOVE 'PYMT_PRIORITY_LVL'  TO TABLE-ELEMENT-1              
C26296        MOVE AC-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-1            
C26296        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
C26296     END-IF.                                                      
C26296                                                                  
C26296 7980-EXIT.                                                       
C26296     EXIT.                                                        
                                                                        
T19557 9500-CALL-CPD00068.                                              
T19557                                                                  
CVT000***      CALL 'MCSCB068' USING CWS00068-FIELDS,                   00000100
TPRTPR         CALL MCSCB068 USING CWS00068-FIELDS,                     
CVT000                               WS-CODES-DATA-PRESENT,             
CVT000                               DCLCSS-ACCOUNT,                    
CVT000                               ABEND-FILE,                        
CVT000                               RS-RETURN-CODE.                    
REARCH                                                                  
REARCH     MOVE RS-RETURN-CODE             TO WS-ACTIVE-RETURN-CODE,    
REARCH                                         S-RETURN-CODE.           
REARCH     IF ABEND-FUNCTION  > SPACES                                  
REARCH         IF ABEND-FUNCTION EQUAL 'BADDATA'                        
REARCH            MOVE -1                  TO S-RETURN-CODE,            
REARCH                                        WS-ACTIVE-RETURN-CODE     
REARCH         END-IF                                                   
REARCH         PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT            
REARCH         PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT             
REARCH     END-IF.                                                      
T19557                                                                  
T19557 9500-EXIT.                                                       
T19557     EXIT.                                                        
T19557                                                                  
PCR361*****************************************************************         
PCR361* 9700-PROCESS-ABEND - COMBINED ON-LINE/BATCH ERROR HANDLER.    *         
PCR361*****************************************************************         
PCR361     EXEC SQL                                                             
PCR361        INCLUDE CPD0023C                                                  
PCR361     END-EXEC.                                                            
PCR361                                                                  
      *****************************************************************         
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                     *         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
                                                                        
CVT000*                                                                 00003400
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00321                                         00000200
CVT000     END-EXEC.                                                    00000300
