       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02312.                                         
COB303 DATE-WRITTEN.     JAN  22, 1996.                                 
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S312 CONVERTED TO DB2 SP CSR02312 ON 05/23/2005        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S312                                           *        
      *  PROGRAM:       S312                                           *        
      *  CALLING SP:    PA_S312                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *        
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *        
      *  THIS PROGRAM RETRIEVES THE DATA DISPLAYED IN  WINDOW OF       *        
      *  PANEL289 WHICH INVOLVES TABLE CSS_PROJ_SHARE                  *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  01/22/96    AG       RETRIEVE PROJECT SHARE INFORMATION       *        
      *                       GIVEN AN ACCOUNT NUMBER                  *        
TP8767*  02/06/97   JEP       TPR 8767 MODIFICATIONS FOR NEXT BILLING  *        
TP8767*                       DATE POPULATION.  ADDED REFERENCES TO    *        
TP8767*                       CPD00309 AND CWS00309.                   *        
T11973*  07/09/97    PP       TPR#11973 - FINAL BILLED ACCOUNTS WILL   *        
T11973*                       RETRIEVE PROJ. SHARE DETAILS IF EXISTS.  *        
T14109*  12/18/97   AMG       CHANGED LOGIC IN 2205-BUILD TO ACCOUNT   *        
T14109*                       FOR THE SITUATION WHEN NEXT 3 BILL DATES *        
T14109*                       ARE NOT AVAILABLE                        *        
CBSI  *   12/19/98 CBSI       ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *            MADRAS     ABEND PARAMETERS                         *        
T20213*   07/14/99 CBSI       CHANGED TO SET ONE TIME PJS ON A PENDING *        
T20213*            MADRAS     STATUS ACCOUNTS.                         *        
T21206*  01/27/2000 CBSI      SELECT LAST-UPDATE-TS FROM CSS_ACCOUNT   *        
T21206*             MADRAS    AND ADD IT TO THE RESULT SET             *        
A04527*  06/06/2013 MC95456   REMOVED UNUSED COPYBOOK CWS00056         *        
P00758*  07/31/2013 RAJ       PROJECT SHARE MODERNIZATION.             *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02312'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR02312 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBPRJSHR                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBBILWDW                                                 
           END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *--------< CONTAINS THE COBOL EQUATES NEEDED FOR USING THE >              
      *--------< SYBASE OPEN SERVER FOR CICS FACILITIES.         >              
CVT999*    COPY SYGWCOB.                                                        
                                                                        
      *--------< ADDED TO SUPPORT CICS RPCS >                                   
CVT999*    COPY SYDBCOB.                                                        
                                                                        
      *--------<COMMON SYSTEM AREA >                                            
           COPY CCA00001.                                                       
                                                                        
      *--------< ERROR HANDLING >                                               
CVT999*    COPY CWS00010.                                                       
                                                                        
      *--------< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >               
           COPY CWS00027.                                                       
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                          
           COPY CWS00303.                                                       
                                                                        
TP8767     EXEC SQL                                                             
TP8767        INCLUDE CWS00309                                                  
TP8767     END-EXEC.                                                            
                                                                        
       01  WS-MISC.                                                     
           05 WS-CURRENT-DATE          PIC X(10) VALUE SPACES.          
           05 WS-DATE-EXTRACT          PIC X(10) VALUE SPACES.          
           05 WS-SHARE-ENROLL-DT       PIC X(10) VALUE SPACES.          
           05 WS-ACCT-TERM-DT          PIC X(10) VALUE SPACES.          
           05 WS-NULL-IND1             PIC S9(04) COMP.                 
           05 WS-NULL-IND2             PIC S9(04) COMP.                 
           05 WS-NULL-IND3             PIC S9(04) COMP.                 
           05 PROGRAM-NAME             PIC X(8)  VALUE 'CSR02312'.      
TP8767     05  REFORMAT-DATE.                                           
TP8767         10  WS-FORMAT-YEAR      PIC X(04).                       
TP8767         10  FILLER              PIC X(01).                       
TP8767         10  WS-FORMAT-MONTH     PIC X(02).                       
TP8767         10  FILLER              PIC X(01).                       
TP8767         10  WS-FORMAT-DAY       PIC X(02).                       
TP8767     05  USA-DATE-FORMAT.                                         
TP8767         10  USA-MONTH           PIC X(02).                       
TP8767         10  FILLER              PIC X(01) VALUE '/'.             
TP8767         10  USA-DAY             PIC X(02).                       
TP8767         10  FILLER              PIC X(01) VALUE '/'.             
TP8767         10  USA-YEAR            PIC X(04).                       
                                                                        
       01  SWITCHES.                                                    
           05  WS-MST-SUB-ACCT-IND     PIC X(01) VALUE SPACES.          
               88 MASTER-ACCOUNT                 VALUE 'M'.             
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
HPCCDM*    EJECT                                                        00096000
       01  GW-LIB-MISC-FIELDS.                                          
CVT999*    05  GWL-PROC                POINTER.                                 
CVT999*    05  GWL-INIT-HANDLE         POINTER.                                 
CVT999*    05  GWL-RC                  PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-NR           PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-DONE         PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-COUNT        PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-COMM         PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-RETURN-CODE  PIC S9(9) COMP.                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
      *                                                                         
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
CVT999*01  PARM-FIELDS.                                                         
CVT999*    05  PARM-L                  PIC S9(9) COMP.                          
CVT999*    05  PARM-ID1                PIC S9(9) COMP VALUE 1.                  
CVT999*    05  PARM-ACCOUNT-NO         PIC X(13).                               
CVT999*                                                                         
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
CVT999*    05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.                  
                                                                        
       01  COUNTER-FIELDS.                                              
CVT999*    05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.                  
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
CVT999*    05  MAX-LENGTH-PARM         PIC S9(9) COMP.                          
CVT999*    05  WRKLEN1                 PIC S9(9) COMP.                          
CVT999*    05  WRKLEN2                 PIC S9(9) COMP.                          
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
            05 RS-RETURN-CODE         PIC S9(9) COMP VALUE 0.           
            05 RS-SHARE-ENROLL-DT     PIC X(10) VALUE SPACES.           
            05 RS-ACCT-TERM-DT        PIC X(10) VALUE SPACES.           
            05 RS-MONTHLY-BILL-AM     PIC S9(11)V9(2) COMP-3 VALUE 0.   
            05 RS-SHARE-STATUS-CD     PIC X(01) VALUE SPACES.           
            05 RS-TOT-YTD-AM          PIC S9(11)V9(2) COMP-3 VALUE 0.   
            05 RS-TOT-PREV-AM         PIC S9(11)V9(2) COMP-3 VALUE 0.   
            05 RS-ACTIVE-ACCOUNT-FLAG PIC X(01) VALUE SPACES.           
            05 RS-AR-XFER-IND         PIC X(01) VALUE SPACES.           
            05 RS-ACCT-XFER-TO        PIC S9(13)V COMP-3 VALUE 0.       
            05 RS-FIRST-BILL-DATE     PIC X(10) VALUE SPACES.           
            05 RS-SECOND-BILL-DATE    PIC X(10) VALUE SPACES.           
            05 RS-THIRD-BILL-DATE     PIC X(10) VALUE SPACES.           
T21206      05 RS-AT-LAST-UPDATE-TS   PIC X(26) VALUE SPACES.           
                                                                        
CVT999*01  CNS-COLUMN-NAMES.                                                    
CVT999*     05 CNS-RETURN-CODE        PIC X(11) VALUE 'RETURN_CODE'.            
CVT999*     05 CNS-SHARE-ENROLL-DT    PIC X(15) VALUE                           
CVT999*                                         'SHARE_ENROLL_DT'.              
CVT999*     05 CNS-ACCT-TERM-DT       PIC X(12) VALUE                           
CVT999*                                         'ACCT_TERM_DT'.                 
CVT999*     05 CNS-MONTHLY-BILL-AM    PIC X(15) VALUE                           
CVT999*                                         'MONTHLY_BILL_AM'.              
CVT999*     05 CNS-SHARE-STATUS-CD    PIC X(15) VALUE                           
CVT999*                                         'SHARE_STATUS_CD'.              
CVT999*     05 CNS-TOT-YTD-AM         PIC X(10) VALUE                           
CVT999*                                         'TOT_YTD_AM'.                   
CVT999*     05 CNS-TOT-PREV-AM        PIC X(11) VALUE                           
CVT999*                                         'TOT_PREV_AM'.                  
CVT999*     05 CNS-ACTIVE-ACCOUNT-FLAG PIC X(19) VALUE                          
CVT999*                                         'ACTIVE_ACCOUNT_FLAG'.          
CVT999*     05 CNS-AR-XFER-IND        PIC X(11) VALUE                           
CVT999*                                         'AR_XFER_IND'.                  
CVT999*     05 CNS-ACCT-XFER-TO       PIC X(12) VALUE                           
CVT999*                                         'ACCT_XFER_TO'.                 
CVT999*     05 CNS-FIRST-BILL-DATE    PIC X(15) VALUE                           
CVT999*                                         'FIRST_BILL_DATE'.              
CVT999*     05 CNS-SECOND-BILL-DATE   PIC X(16) VALUE                           
CVT999*                                         'SECOND_BILL_DATE'.             
CVT999*     05 CNS-THIRD-BILL-DATE    PIC X(15) VALUE                           
CVT999*                                         'THIRD_BILL_DATE'.              
CVT999*     05 CNS-AT-LAST-UPDATE-TS  PIC X(17) VALUE                           
CVT999*                                        'AT_LAST_UPDATE_TS'.             
CVT999******************************************************************        
CVT999*    CURSOR DECLARATIONS                                         *        
CVT999******************************************************************        
CVT999*                                                                         
CVT999******************************************************************        
CVT999**  THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING A SET OF   **        
CVT999**  ROWS FROM THE CSS_PROJ_SHARE TABLE.                         **        
CVT999******************************************************************        
           EXEC SQL                                                     
             DECLARE PJ-CURSOR CURSOR FOR                               
             SELECT SHARE_ENROLL_DT,                                    
                    CIS.CHAR2$DATE(SHARE_ENROLL_DT,'USA'),                      
                    CIS.CHAR2$DATE(ACCT_TERM_DT,'USA'),                         
                    MONTHLY_BILL_AM,                                    
                    SHARE_STATUS_CD,                                    
                    TOT_YTD_AM,                                         
                    TOT_PREV_AM                                         
                   FROM CSS_PROJ_SHARE WITH(READUNCOMMITTED)                    
                   WHERE  ACCOUNT_NO       = :PJ-ACCOUNT-NO             
REARCH             FOR READ ONLY                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE PJ-CURSOR CURSOR FOR                                       
MFA-TR*      SELECT SHARE_ENROLL_DT,                                            
MFA-TR*             CHAR(SHARE_ENROLL_DT,USA),                                  
MFA-TR*             CHAR(ACCT_TERM_DT,USA),                                     
MFA-TR*             MONTHLY_BILL_AM,                                            
MFA-TR*             SHARE_STATUS_CD,                                            
MFA-TR*             TOT_YTD_AM,                                                 
MFA-TR*             TOT_PREV_AM                                                 
MFA-TR*            FROM CSS_PROJ_SHARE                                          
MFA-TR*            WHERE  ACCOUNT_NO       = :PJ-ACCOUNT-NO                     
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                                    
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
CVT000     10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         DECLARE C1 CURSOR  FOR                        
CVT000         SELECT *                                                 
CVT000         FROM #CSR02312_R1                                 
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00000100
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        00000300
MFA-TR*        SELECT *                                                 00000400
MFA-TR*        FROM SESSION.CSR02312_R1                                 00000500
MFA-TR*    END-EXEC.                                                    00000700
CVT000                                                                  
                                                                        
CVT000 LINKAGE SECTION.                                                 
CVT000 01  PARM-ACCOUNT-NO          PIC X(13)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          PARM-ACCOUNT-NO                                         
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                                      
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
CVT999*    EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.                      
                                                                        
CVT999*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.             
                                                                        
CVT999*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,             
CVT999*                          SNA-CONNECTION-NAME, SNA-SUBC.                 
                                                                        
CVT999*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                              
                                                                        
CVT999*    IF GWL-RC NOT = TDS-PARM-PRESENT                                     
CVT999*       MOVE PROGRAM-NAME         TO ABEND-PROGRAM                        
CVT999*       MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION              
CVT999*       MOVE 'CICS TRANSACTION'   TO TABLE-1                              
CVT999*       MOVE GWL-RC               TO WS-ACTIVE-RETURN-CODE                
CVT999*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
CVT999*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
CVT999*    END-IF.                                                              
CVT000     PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT.                   
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
CVT000 0100A-DECLARE-GTT.                                               
CVT000     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02312_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02312_R1
              (                                                          
CVT000         RETURN_CODE              INT                         
CVT000        ,SHARE_ENROLL_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
CVT000        ,ACCT_TERM_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2           
CVT000        ,MONTHLY_BILL_AM          DECIMAL(13,2)                   
CVT000        ,SHARE_STATUS_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
CVT000        ,TOT_YTD_AM               DECIMAL(13,2)                   
CVT000        ,TOT_PREV_AM              DECIMAL(13,2)                   
CVT004        ,ACTIVE_ACCOUNT_FLA CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,AR_XFER_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2            
CVT000        ,ACCT_XFER_TO             DECIMAL(13,0)                   
CVT000        ,FIRST_BILL_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
CVT000        ,SECOND_BILL_DATE CHAR(10)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,THIRD_BILL_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
CVT000        ,AT_LAST_UPDATE_TS CHAR(26)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000       )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR03501_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
CVT000 0100A-EXIT.                                                      
CVT000         EXIT.                                                    
                                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     CALLS 1100-RECEIVE-PARMS                                   *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
      *                                                                         
           PERFORM 1100-RECEIVE-PARMS THRU 1100-EXIT.                   
           MOVE PARM-ACCOUNT-NO         TO PJ-ACCOUNT-NO.               
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1100-RECEIVE-PARMS                                             *        
      *     CALLS TDRCVPRM                                             *        
      *                                                                *        
      *     CALLED FROM 1000-PROCESS-INPUT                             *        
      *                                                                *        
      *     GET THE PASSED PARMS FROM THE CLIENT                       *        
      ******************************************************************        
                                                                        
       1100-RECEIVE-PARMS.                                              
                                                                        
CVT999*    MOVE 1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-ACCOUNT-NO        TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-ACCOUNT-NO,                               
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     CALLS 2100-DESCRIBE-RESULT                                 *        
      *           2200-BUILD-RESULT                                    *        
      *     CALLED FROM 0000-MAINLINE                                 *         
      *                                                                *        
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *        
      *      AND SENDS THEM BACK                                       *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                           TO ACTIVE-PARAGRAPH.   
           PERFORM 2100-DESCRIBE-RESULT          THRU 2100-EXIT.        
           PERFORM 2200-BUILD-RESULT             THRU 2200-EXIT.        
       2000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 2100-DESCRIBE-RESULT                                          *         
      *                                                               *         
      *     CALLS 2110-DESC-RET-CODE                                  *         
      *           2140-DESC-DATA                                      *         
      *     CALLED FROM 2000-PROCESS-OUTPUT                           *         
      *                                                               *         
      *      DESCRIBE EACH RESULT FIELD TO THE CLIENT                 *         
      ******************************************************************        
                                                                        
       2100-DESCRIBE-RESULT.                                            
                                                                        
           MOVE '2110'                             TO ACTIVE-PARAGRAPH. 
           PERFORM 2110-DESC-RET-CODE              THRU 2110-EXIT.      
           PERFORM 2140-DESC-DATA                  THRU 2140-EXIT.      
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2110-DESC-RET-CODE                                             *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE RET-CODE    FIELD TO THE CLIENT                   *        
      ******************************************************************        
                                                                        
       2110-DESC-RET-CODE.                                              
                                                                        
           MOVE '2110'                       TO ACTIVE-PARAGRAPH.       
CVT999*    MOVE 1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSINT4                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSINT4                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-RETURN-CODE     TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-RETURN-CODE    TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RETURN-CODE,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-RETURN-CODE,                               
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
       2110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2140-DESC-DATA                                                 *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE BILLING HEADER RESULT FIELDS TO THE CLIENT        *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2140-DESC-DATA.                                                  
                                                                        
           MOVE '2140'                          TO ACTIVE-PARAGRAPH.    
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-SHARE-ENROLL-DT    TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-SHARE-ENROLL-DT   TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-SHARE-ENROLL-DT,                            
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-SHARE-ENROLL-DT,                           
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-ACCT-TERM-DT       TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-ACCT-TERM-DT      TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-ACCT-TERM-DT,                               
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-ACCT-TERM-DT,                              
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSDECIMAL                      TO DB-HOST-TYPE.                
CVT999*    MOVE TDSFLT8                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-MONTHLY-BILL-AM    TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-MONTHLY-BILL-AM   TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-MONTHLY-BILL-AM,                            
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-MONTHLY-BILL-AM,                           
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    MOVE +2 TO WRKLEN2.                                                  
CVT999*    CALL 'TDSETBCD' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          TDS-OBJECT-COL,                                
CVT999*                          CTR-COLUMN,                                    
CVT999*                          WRKLEN1,                                       
CVT999*                          WRKLEN2.                                       
                                                                        
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-SHARE-STATUS-CD    TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-SHARE-STATUS-CD   TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-SHARE-STATUS-CD,                            
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-SHARE-STATUS-CD,                           
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSDECIMAL                      TO DB-HOST-TYPE.                
CVT999*    MOVE TDSFLT8                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-TOT-YTD-AM         TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-TOT-YTD-AM        TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-TOT-YTD-AM,                                 
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-TOT-YTD-AM,                                
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    MOVE +2 TO WRKLEN2.                                                  
CVT999*    CALL 'TDSETBCD' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          TDS-OBJECT-COL,                                
CVT999*                          CTR-COLUMN,                                    
CVT999*                          WRKLEN1,                                       
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSDECIMAL                      TO DB-HOST-TYPE.                
CVT999*    MOVE TDSFLT8                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-TOT-PREV-AM        TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-TOT-PREV-AM       TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-TOT-PREV-AM,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-TOT-PREV-AM,                               
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    MOVE +2 TO WRKLEN2.                                                  
CVT999*    CALL 'TDSETBCD' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          TDS-OBJECT-COL,                                
CVT999*                          CTR-COLUMN,                                    
CVT999*                          WRKLEN1,                                       
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    ADD 1                                  TO CTR-COLUMN.                
CVT999*    MOVE TDSCHAR                           TO DB-HOST-TYPE.              
CVT999*    MOVE TDSCHAR                           TO DB-CLIENT-TYPE.            
CVT999*    MOVE LENGTH OF RS-ACTIVE-ACCOUNT-FLAG  TO WRKLEN1.                   
CVT999*    MOVE LENGTH OF CNS-ACTIVE-ACCOUNT-FLAG TO WRKLEN2.                   
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-ACTIVE-ACCOUNT-FLAG,                        
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-ACTIVE-ACCOUNT-FLAG,                       
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                  TO CTR-COLUMN.                
CVT999*    MOVE TDSCHAR                           TO DB-HOST-TYPE.              
CVT999*    MOVE TDSCHAR                           TO DB-CLIENT-TYPE.            
CVT999*    MOVE LENGTH OF RS-AR-XFER-IND          TO WRKLEN1.                   
CVT999*    MOVE LENGTH OF CNS-AR-XFER-IND         TO WRKLEN2.                   
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-AR-XFER-IND,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-AR-XFER-IND,                               
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSDECIMAL                      TO DB-HOST-TYPE.                
CVT999*    MOVE TDSFLT8                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-ACCT-XFER-TO       TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-ACCT-XFER-TO      TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-ACCT-XFER-TO,                               
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-ACCT-XFER-TO,                              
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    MOVE +0 TO WRKLEN2.                                                  
CVT999*    CALL 'TDSETBCD' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          TDS-OBJECT-COL,                                
CVT999*                          CTR-COLUMN,                                    
CVT999*                          WRKLEN1,                                       
CVT999*                          WRKLEN2.                                       
                                                                        
                                                                        
CVT999*    ADD 1                                  TO CTR-COLUMN.                
CVT999*    MOVE TDSCHAR                           TO DB-HOST-TYPE.              
CVT999*    MOVE TDSCHAR                           TO DB-CLIENT-TYPE.            
CVT999*    MOVE LENGTH OF RS-FIRST-BILL-DATE      TO WRKLEN1.                   
CVT999*    MOVE LENGTH OF CNS-FIRST-BILL-DATE     TO WRKLEN2.                   
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-FIRST-BILL-DATE,                            
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-FIRST-BILL-DATE,                           
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                  TO CTR-COLUMN.                
CVT999*    MOVE TDSCHAR                           TO DB-HOST-TYPE.              
CVT999*    MOVE TDSCHAR                           TO DB-CLIENT-TYPE.            
CVT999*    MOVE LENGTH OF RS-SECOND-BILL-DATE     TO WRKLEN1.                   
CVT999*    MOVE LENGTH OF CNS-SECOND-BILL-DATE    TO WRKLEN2.                   
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-SECOND-BILL-DATE,                           
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-SECOND-BILL-DATE,                          
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                  TO CTR-COLUMN.                
CVT999*    MOVE TDSCHAR                           TO DB-HOST-TYPE.              
CVT999*    MOVE TDSCHAR                           TO DB-CLIENT-TYPE.            
CVT999*    MOVE LENGTH OF RS-THIRD-BILL-DATE      TO WRKLEN1.                   
CVT999*    MOVE LENGTH OF CNS-THIRD-BILL-DATE     TO WRKLEN2.                   
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-THIRD-BILL-DATE,                            
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-THIRD-BILL-DATE,                           
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-AT-LAST-UPDATE-TS   TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-AT-LAST-UPDATE-TS  TO WRKLEN2.                    
T21206                                                                  
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-AT-LAST-UPDATE-TS,                          
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-AT-LAST-UPDATE-TS,                         
CVT999*                          WRKLEN2.                                       
T21206                                                                  
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
T21206*                                                                         
       2140-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
                                                                        
       2200-BUILD-RESULT.                                               
                                                                        
              MOVE '2200'                TO ACTIVE-PARAGRAPH.           
              MOVE PARM-ACCOUNT-NO       TO PJ-ACCOUNT-NO               
                                            AT-ACCOUNT-NO               
              PERFORM 2205-BUILD         THRU 2205-EXIT.                
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
                                                                        
      ******************************************************************        
      * 2205-BUILD                                                     *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
                                                                        
       2205-BUILD.                                                      
                                                                        
           MOVE '2205'               TO ACTIVE-PARAGRAPH.               
                                                                        
           MOVE 'Y'                  TO RS-ACTIVE-ACCOUNT-FLAG.         
                                                                        
           PERFORM 7000-SELECT-ACTIVE-ACCOUNT THRU 7000-EXIT.           
T21206*                                                                         
T21206     MOVE AT-LAST-UPDATE-TS        TO RS-AT-LAST-UPDATE-TS.       
                                                                        
P00758     IF AT-CODE-ACCT-STAT = 'P' AND ( AT-BILL-CYCLE = SPACES      
P00758                                       OR '99' OR '00' )          
P00758        PERFORM 7502-GET-BILL-CYCLE   THRU 7502-EXIT              
P00758     END-IF.                                                      
                                                                        
           IF AT-CODE-ACCT-STAT NOT EQUAL 'A'                           
T11973            AND AT-CODE-ACCT-STAT NOT EQUAL 'B'                   
T20213            AND AT-CODE-ACCT-STAT NOT EQUAL 'P'                   
P00758            AND AT-CODE-ACCT-STAT NOT EQUAL 'S'                   
              MOVE 'N'     TO RS-ACTIVE-ACCOUNT-FLAG                    
              PERFORM 8100-SEND-RESULT   THRU 8100-EXIT                 
              PERFORM 9999-END-PROGRAM   THRU 9999-EXIT                 
           END-IF                                                       
                                                                        
           IF AT-AR-XFER-IND  EQUAL 'Y'                                 
              MOVE 'Y'                   TO RS-AR-XFER-IND              
              MOVE AT-ACCT-XFER-TO       TO RS-ACCT-XFER-TO             
              PERFORM 8100-SEND-RESULT   THRU 8100-EXIT                 
              PERFORM 9999-END-PROGRAM   THRU 9999-EXIT                 
           END-IF                                                       
                                                                        
           PERFORM 7100-OPEN-PJ-CURSOR  THRU  7100-EXIT                 
           PERFORM 7110-FETCH-PJ-ROW    THRU  7110-EXIT                 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE SPACES          TO RS-SHARE-ENROLL-DT                
              MOVE SPACES          TO RS-ACCT-TERM-DT                   
              MOVE ZEROES          TO RS-MONTHLY-BILL-AM                
              MOVE SPACES          TO RS-SHARE-STATUS-CD                
              MOVE ZEROES          TO RS-TOT-YTD-AM                     
              MOVE ZEROES          TO RS-TOT-PREV-AM                    
              MOVE SPACES          TO RS-ACTIVE-ACCOUNT-FLAG            
              MOVE SPACES          TO RS-AR-XFER-IND                    
              MOVE ZEROES          TO RS-ACCT-XFER-TO                   
                                                                        
              EXEC SQL                                                  
                 SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                    
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*       EXEC SQL                                                          
MFA-TR*          SET :WS-CURRENT-DATE = CURRENT DATE                            
MFA-TR*       END-EXEC                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE AT-BILL-CYCLE           TO BN-BILL-CYCLE             
                                                                        
T14109        MOVE -1                      TO WS-NULL-DATE-EXTRACT      
TP8767        PERFORM 5900-NEXT-BILL-DATE THRU                          
TP8767                                     5900-NEXT-BILL-DATE-EXIT     
TP8767        IF WS-NULL-DATE-EXTRACT      EQUAL ZEROES                 
TP8767           MOVE BN-DATE-EXTRACT      TO REFORMAT-DATE             
TP8767           MOVE WS-FORMAT-YEAR       TO USA-YEAR                  
TP8767           MOVE WS-FORMAT-MONTH      TO USA-MONTH                 
TP8767           MOVE WS-FORMAT-DAY        TO USA-DAY                   
TP8767           MOVE USA-DATE-FORMAT      TO RS-FIRST-BILL-DATE        
TP8767           MOVE BN-DATE-EXTRACT      TO WS-CURRENT-DATE           
TP8767           MOVE BN-REVENUE-MONTH     TO AT-REV-MTH-LST-NRML       
                                                                        
T14109           MOVE -1                   TO WS-NULL-DATE-EXTRACT      
TP8767           PERFORM 5900-NEXT-BILL-DATE THRU                       
TP8767                                     5900-NEXT-BILL-DATE-EXIT     
TP8767           IF WS-NULL-DATE-EXTRACT EQUAL ZEROES                   
TP8767              MOVE BN-DATE-EXTRACT      TO REFORMAT-DATE          
TP8767              MOVE WS-FORMAT-YEAR       TO USA-YEAR               
TP8767              MOVE WS-FORMAT-MONTH      TO USA-MONTH              
TP8767              MOVE WS-FORMAT-DAY        TO USA-DAY                
TP8767              MOVE USA-DATE-FORMAT      TO RS-SECOND-BILL-DATE    
TP8767              MOVE BN-DATE-EXTRACT      TO WS-CURRENT-DATE        
TP8767              MOVE BN-REVENUE-MONTH     TO AT-REV-MTH-LST-NRML    
                                                                        
T14109              MOVE -1                   TO WS-NULL-DATE-EXTRACT   
TP8767              PERFORM 5900-NEXT-BILL-DATE THRU                    
TP8767                                        5900-NEXT-BILL-DATE-EXIT  
TP8767              IF WS-NULL-DATE-EXTRACT EQUAL ZEROES                
TP8767                 MOVE BN-DATE-EXTRACT   TO REFORMAT-DATE          
TP8767                 MOVE WS-FORMAT-YEAR    TO USA-YEAR               
TP8767                 MOVE WS-FORMAT-MONTH   TO USA-MONTH              
TP8767                 MOVE WS-FORMAT-DAY     TO USA-DAY                
TP8767                 MOVE USA-DATE-FORMAT   TO RS-THIRD-BILL-DATE     
TP8767                 MOVE BN-DATE-EXTRACT   TO WS-CURRENT-DATE        
TP8767                 MOVE BN-REVENUE-MONTH  TO AT-REV-MTH-LST-NRML    
TP8767              ELSE                                                
TP8767                 MOVE SPACES            TO RS-THIRD-BILL-DATE     
TP8767              END-IF                                              
TP8767           ELSE                                                   
TP8767              MOVE SPACES               TO RS-SECOND-BILL-DATE    
TP8767              MOVE SPACES               TO RS-THIRD-BILL-DATE     
TP8767           END-IF                                                 
TP8767        ELSE                                                      
TP8767           MOVE SPACES                  TO RS-FIRST-BILL-DATE     
TP8767           MOVE SPACES                  TO RS-SECOND-BILL-DATE    
TP8767           MOVE SPACES                  TO RS-THIRD-BILL-DATE     
TP8767        END-IF                                                    
                                                                        
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
           ELSE                                                         
              MOVE AT-BILL-CYCLE              TO BN-BILL-CYCLE          
                                                                        
              EXEC SQL                                                  
                 SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                    
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*       EXEC SQL                                                          
MFA-TR*          SET :WS-CURRENT-DATE = CURRENT DATE                            
MFA-TR*       END-EXEC                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

------                                                                  
T14109        MOVE -1                         TO WS-NULL-DATE-EXTRACT   
TP8767        PERFORM 5900-NEXT-BILL-DATE THRU                          
TP8767                                        5900-NEXT-BILL-DATE-EXIT  
TP8767        IF WS-NULL-DATE-EXTRACT EQUAL ZEROES                      
TP8767           MOVE BN-DATE-EXTRACT         TO REFORMAT-DATE          
TP8767           MOVE WS-FORMAT-YEAR          TO USA-YEAR               
TP8767           MOVE WS-FORMAT-MONTH         TO USA-MONTH              
TP8767           MOVE WS-FORMAT-DAY           TO USA-DAY                
TP8767           MOVE USA-DATE-FORMAT         TO RS-FIRST-BILL-DATE     
TP8767           MOVE BN-DATE-EXTRACT         TO WS-CURRENT-DATE        
TP8767           MOVE BN-REVENUE-MONTH        TO AT-REV-MTH-LST-NRML    
                                                                        
T14109           MOVE -1                      TO WS-NULL-DATE-EXTRACT   
TP8767           PERFORM 5900-NEXT-BILL-DATE THRU                       
TP8767                                        5900-NEXT-BILL-DATE-EXIT  
TP8767           IF WS-NULL-DATE-EXTRACT EQUAL ZEROES                   
TP8767              MOVE BN-DATE-EXTRACT      TO REFORMAT-DATE          
TP8767              MOVE WS-FORMAT-YEAR       TO USA-YEAR               
TP8767              MOVE WS-FORMAT-MONTH      TO USA-MONTH              
TP8767              MOVE WS-FORMAT-DAY        TO USA-DAY                
TP8767              MOVE USA-DATE-FORMAT      TO RS-SECOND-BILL-DATE    
TP8767              MOVE BN-DATE-EXTRACT      TO WS-CURRENT-DATE        
TP8767              MOVE BN-REVENUE-MONTH     TO AT-REV-MTH-LST-NRML    
                                                                        
T14109              MOVE -1                   TO WS-NULL-DATE-EXTRACT   
TP8767              PERFORM 5900-NEXT-BILL-DATE THRU                    
TP8767                                        5900-NEXT-BILL-DATE-EXIT  
TP8767              IF WS-NULL-DATE-EXTRACT EQUAL ZEROES                
TP8767                 MOVE BN-DATE-EXTRACT   TO REFORMAT-DATE          
TP8767                 MOVE WS-FORMAT-YEAR    TO USA-YEAR               
TP8767                 MOVE WS-FORMAT-MONTH   TO USA-MONTH              
TP8767                 MOVE WS-FORMAT-DAY     TO USA-DAY                
TP8767                 MOVE USA-DATE-FORMAT   TO RS-THIRD-BILL-DATE     
TP8767                 MOVE BN-DATE-EXTRACT   TO WS-CURRENT-DATE        
TP8767                 MOVE BN-REVENUE-MONTH  TO AT-REV-MTH-LST-NRML    
TP8767              ELSE                                                
TP8767                 MOVE SPACES            TO RS-THIRD-BILL-DATE     
TP8767              END-IF                                              
TP8767           ELSE                                                   
TP8767              MOVE SPACES               TO RS-SECOND-BILL-DATE    
TP8767              MOVE SPACES               TO RS-THIRD-BILL-DATE     
TP8767           END-IF                                                 
TP8767        ELSE                                                      
TP8767           MOVE SPACES                  TO RS-FIRST-BILL-DATE     
TP8767           MOVE SPACES                  TO RS-SECOND-BILL-DATE    
TP8767           MOVE SPACES                  TO RS-THIRD-BILL-DATE     
TP8767        END-IF                                                    
                                                                        
              PERFORM 2210-PROCESS-PJ         THRU 2210-EXIT            
           END-IF.                                                      
                                                                        
           PERFORM 7120-CLOSE-PJ-CURSOR THRU 7120-EXIT.                 
                                                                        
       2205-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2210-PROCESS-PJ                                                *        
      *                                                                *        
      *     CALLED FROM 2205-BUILD                                     *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
                                                                        
       2210-PROCESS-PJ.                                                 
                                                                        
           MOVE '2210'               TO ACTIVE-PARAGRAPH.               
                                                                        
           MOVE WS-SHARE-ENROLL-DT    TO RS-SHARE-ENROLL-DT             
           MOVE WS-ACCT-TERM-DT       TO RS-ACCT-TERM-DT                
           MOVE PJ-MONTHLY-BILL-AM    TO RS-MONTHLY-BILL-AM             
           MOVE PJ-SHARE-STATUS-CD    TO RS-SHARE-STATUS-CD             
           MOVE PJ-TOT-YTD-AM         TO RS-TOT-YTD-AM                  
           MOVE PJ-TOT-PREV-AM        TO RS-TOT-PREV-AM                 
           MOVE 'Y'                   TO RS-ACTIVE-ACCOUNT-FLAG         
                                                                        
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * INCLUDE CPD00309 FOR NEXT BILL DATE CALCULATION                *        
      ******************************************************************        
      *                                                                         
TP8767     EXEC SQL                                                             
TP8767        INCLUDE CPD00309                                                  
TP8767     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 7000-SELECT-ACTIVE-ACCOUNT                                     *        
      *                                                                *        
      *     CALLED FROM 2205-BUILD                                     *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
                                                                        
       7000-SELECT-ACTIVE-ACCOUNT.                                      
                                                                        
           MOVE '7000'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) CODE_ACCT_STAT,
              BILL_CYCLE,
              AR_XFER_IND,
              ACCT_XFER_TO,
              CODE_BILL_FREQ,
              REV_MTH_LST_NRML,
              REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS, 121), 
           ' ', '-'), ':', '.') LAST_UPDATE_TS                                 
                INTO :AT-CODE-ACCT-STAT,                                
                     :AT-BILL-CYCLE,                                    
                     :AT-AR-XFER-IND,                                   
                     :AT-ACCT-XFER-TO,                                  
TP8767               :AT-CODE-BILL-FREQ,                                
TP8767               :AT-REV-MTH-LST-NRML,                              
T21206               :AT-LAST-UPDATE-TS                                 
                FROM CSS_ACCOUNT                                        
                WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                     
REARCH                                           
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT CODE_ACCT_STAT,                                          
MFA-TR*                BILL_CYCLE,                                              
MFA-TR*                AR_XFER_IND,                                             
MFA-TR*                ACCT_XFER_TO,                                            
MFA-TR*                CODE_BILL_FREQ,                                          
MFA-TR*                REV_MTH_LST_NRML,                                        
MFA-TR*                LAST_UPDATE_TS                                           
MFA-TR*         INTO :AT-CODE-ACCT-STAT,                                        
MFA-TR*              :AT-BILL-CYCLE,                                            
MFA-TR*              :AT-AR-XFER-IND,                                           
MFA-TR*              :AT-ACCT-XFER-TO,                                          
MFA-TR*              :AT-CODE-BILL-FREQ,                                        
MFA-TR*              :AT-REV-MTH-LST-NRML,                                      
MFA-TR*              :AT-LAST-UPDATE-TS                                         
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*         WHERE ACCOUNT_NO   = :AT-ACCOUNT-NO                             
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                                         OR NOT-FOUND                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
HPCCDM*EJECT                                                                    
      *                                                                         
       7100-OPEN-PJ-CURSOR.                                             
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OPEN THE CURSOR USED TO FETCH     **        
      **  ROWS FROM THE CSS_PROJ_SHARE TABLE.                         **        
      ******************************************************************        
      *                                                                         
           MOVE '7100'               TO ACTIVE-PARAGRAPH.               
           EXEC SQL                                                     
               OPEN PJ-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'CSS_PROJ_SHARE'           TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE PJ-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
HPCCDM*EJECT                                                                    
       7110-FETCH-PJ-ROW.                                               
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OBTAIN THE NEXT ROW FROM THE      **        
      **  CSS_PROJ_SHARE  TABLE.                                      **        
      ******************************************************************        
      *                                                                         
           MOVE '7110'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
               FETCH PJ-CURSOR                                          
               INTO :PJ-SHARE-ENROLL-DT :WS-NULL-IND1,                   
                    :WS-SHARE-ENROLL-DT :WS-NULL-IND2,                   
                    :WS-ACCT-TERM-DT :WS-NULL-IND3,                      
                    :PJ-MONTHLY-BILL-AM,                                
                    :PJ-SHARE-STATUS-CD,                                
                    :PJ-TOT-YTD-AM,                                     
                    :PJ-TOT-PREV-AM                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF WS-NULL-IND1 < 0                                          
                MOVE SPACES TO PJ-SHARE-ENROLL-DT                       
           END-IF                                                       
                                                                        
           IF WS-NULL-IND2 < 0                                          
                MOVE SPACES TO WS-SHARE-ENROLL-DT                       
           END-IF                                                       
                                                                        
           IF WS-NULL-IND3 < 0                                          
              MOVE SPACES TO WS-ACCT-TERM-DT                            
           END-IF                                                       
                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                                         OR NOT-FOUND                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE 'CSS_PROJ_SHARE'           TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE PJ-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
       7120-CLOSE-PJ-CURSOR.                                            
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO CLOSE THE CURSOR USED TO FETCH    **        
      **  ROWS FROM THE CSS_PROJ_SHARE TABLE.                         **        
      ******************************************************************        
      *                                                                         
           MOVE '7120'               TO ACTIVE-PARAGRAPH.               
           EXEC SQL                                                     
               CLOSE PJ-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE 'CSS_PROJ_SHARE'           TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE PJ-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
      *                                                                         
      *                                                                         
P00758 7502-GET-BILL-CYCLE.                                             
      *                                                                         
           EXEC SQL                                                     
            SELECT TOP(1) BILL_CYCLE                                           
             INTO  :AT-BILL-CYCLE                                       
             FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                         
             WHERE DATE_EXTRACT  >= CAST(SYSDATETIMEOFFSET() AS DATE)           
             AND CODE_BILL_COND   = 'R'                                 
             ORDER BY DATE_EXTRACT, REVENUE_MONTH DESC, BILL_CYCLE DESC 
                                             
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     30631301
MFA-TR*     SELECT BILL_CYCLE                                           30631401
MFA-TR*      INTO  :AT-BILL-CYCLE                                       30631501
MFA-TR*      FROM CSS_BILL_WINDOW                                       30631601
MFA-TR*      WHERE DATE_EXTRACT  >= CURRENT DATE                        30631701
MFA-TR*      AND CODE_BILL_COND   = 'R'                                 30631801
MFA-TR*      ORDER BY DATE_EXTRACT, REVENUE_MONTH DESC, BILL_CYCLE DESC         
MFA-TR*      FETCH FIRST ROW ONLY WITH UR                                       
MFA-TR*      QUERYNO 7502                                                       
MFA-TR*    END-EXEC.                                                    30631901

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7502'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_BILL_WINDOW'   TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
      *                                                                         
P00758 7502-EXIT.                                                       
P00758*    EXIT.                                                        30633301
      *                                                                         
      *                                                                 08730500
      ******************************************************************        
      * INCLUDE CPD0023C FOR ERROR HANDLING                            *        
      ******************************************************************        
PCR361     EXEC SQL                                                             
PCR361        INCLUDE CPD0023C                                                  
PCR361     END-EXEC.                                                            
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
CVT999*    COPY CPD00302.                                                       
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000     EXEC SQL                                                     
CVT000       INSERT INTO #CSR02312_R1                            
CVT000       (                                                          
CVT000        RETURN_CODE                                               
CVT000       ,SHARE_ENROLL_DT                                           
CVT000       ,ACCT_TERM_DT                                              
CVT000       ,MONTHLY_BILL_AM                                           
CVT000       ,SHARE_STATUS_CD                                           
CVT000       ,TOT_YTD_AM                                                
CVT000       ,TOT_PREV_AM                                               
CVT004       ,ACTIVE_ACCOUNT_FLA                                        
CVT000       ,AR_XFER_IND                                               
CVT000       ,ACCT_XFER_TO                                              
CVT000       ,FIRST_BILL_DATE                                           
CVT000       ,SECOND_BILL_DATE                                          
CVT000       ,THIRD_BILL_DATE                                           
CVT000       ,AT_LAST_UPDATE_TS                                         
CVT000       )                                                          
CVT000       VALUES                                                     
CVT000       (                                                          
CVT000        :RS-RETURN-CODE                                           
CVT000       ,:RS-SHARE-ENROLL-DT                                       
CVT000       ,:RS-ACCT-TERM-DT                                          
CVT000       ,:RS-MONTHLY-BILL-AM                                       
CVT000       ,:RS-SHARE-STATUS-CD                                       
CVT000       ,:RS-TOT-YTD-AM                                            
CVT000       ,:RS-TOT-PREV-AM                                           
CVT000       ,:RS-ACTIVE-ACCOUNT-FLAG                                   
CVT000       ,:RS-AR-XFER-IND                                           
CVT000       ,:RS-ACCT-XFER-TO                                          
CVT000       ,:RS-FIRST-BILL-DATE                                       
CVT000       ,:RS-SECOND-BILL-DATE                                      
CVT000       ,:RS-THIRD-BILL-DATE                                       
CVT000       ,:RS-AT-LAST-UPDATE-TS                                     
CVT000       )                                                          
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR02312_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,SHARE_ENROLL_DT                                                   
MFA-TR*      ,ACCT_TERM_DT                                                      
MFA-TR*      ,MONTHLY_BILL_AM                                                   
MFA-TR*      ,SHARE_STATUS_CD                                                   
MFA-TR*      ,TOT_YTD_AM                                                        
MFA-TR*      ,TOT_PREV_AM                                                       
MFA-TR*      ,ACTIVE_ACCOUNT_FLA                                                
MFA-TR*      ,AR_XFER_IND                                                       
MFA-TR*      ,ACCT_XFER_TO                                                      
MFA-TR*      ,FIRST_BILL_DATE                                                   
MFA-TR*      ,SECOND_BILL_DATE                                                  
MFA-TR*      ,THIRD_BILL_DATE                                                   
MFA-TR*      ,AT_LAST_UPDATE_TS                                                 
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :RS-RETURN-CODE                                                   
MFA-TR*      ,:RS-SHARE-ENROLL-DT                                               
MFA-TR*      ,:RS-ACCT-TERM-DT                                                  
MFA-TR*      ,:RS-MONTHLY-BILL-AM                                               
MFA-TR*      ,:RS-SHARE-STATUS-CD                                               
MFA-TR*      ,:RS-TOT-YTD-AM                                                    
MFA-TR*      ,:RS-TOT-PREV-AM                                                   
MFA-TR*      ,:RS-ACTIVE-ACCOUNT-FLAG                                           
MFA-TR*      ,:RS-AR-XFER-IND                                                   
MFA-TR*      ,:RS-ACCT-XFER-TO                                                  
MFA-TR*      ,:RS-FIRST-BILL-DATE                                               
MFA-TR*      ,:RS-SECOND-BILL-DATE                                              
MFA-TR*      ,:RS-THIRD-BILL-DATE                                               
MFA-TR*      ,:RS-AT-LAST-UPDATE-TS                                             
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
CVT000                                                                  
CVT000     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
CVT000        NEXT SENTENCE                                             
CVT000     ELSE                                                         
CVT000        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
CVT000        MOVE '8900'               TO ACTIVE-PARAGRAPH             
CVT000        MOVE 'INSERT'             TO ABEND-FUNCTION               
CVT000        MOVE 'CSR0TEST_R1'        TO TABLE-1                      
CVT000        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
CVT000     END-IF.                                                      
CVT000                                                                  
CVT000     ADD 1 TO CTR-ROWS.                                           
CVT000*    INITIALIZE GTT-RETURN-FIELDS.                                00001900
CVT000*                                                                 00002000
CVT000 8100-EXIT.                                                       
CVT000      EXIT.                                                       
CVT000******************************************************************00000100
CVT000* 8000A-DELETE-GTT-ROWS.                                         *00000200
CVT000******************************************************************00000300
CVT000 8000A-DELETE-GTT-ROWS.                                           
CVT000*                                                                 00000500
CVT000     MOVE                                                         
CVT000     'DELETE ROWS'                                                
CVT000         TO S-SQL-STATEMENT-V.                                    
CVT000*                                                                 00000900
CVT000      EXEC SQL                                                    
CVT000          DELETE FROM #CSR02312_R1                         
CVT000      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    00001000
MFA-TR*         DELETE FROM SESSION.CSR02312_R1                         00001100
MFA-TR*     END-EXEC.                                                   00001200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000*                                                                 00001300
CVT000      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
CVT000*                                                                 00001500
CVT000      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
CVT000          NEXT SENTENCE                                           
CVT000      ELSE                                                        
CVT000         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
CVT000         MOVE '8000A'              TO ACTIVE-PARAGRAPH            
CVT000         MOVE 'DELETE'             TO ABEND-FUNCTION              
CVT000         MOVE SPACES               TO ABEND-SQL-PREDICATES        
CVT000                                      ABEND-TABLES                
CVT000         MOVE 'CSR02312_R1'        TO TABLE-1                     
CVT000         MOVE SPACES               TO TABLE-ELEMENT-1             
CVT000         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
CVT000         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
CVT000     END-IF.                                                      
CVT000*                                                                 00003100
CVT000 8000A-EXIT.                                                      
CVT000     EXIT.                                                        
CVT000*                                                                 00003400
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00320                                         00000200
CVT000     END-EXEC.                                                    00000300
