       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02311.                                         
COB303 DATE-WRITTEN.  JUNE 29, 2005.                                    
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00080000
      *                                                                *00090000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00100000
      *                                                                *00110000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00120000
      *                                                                *00130000
      *  TRANID:        S311.                                          *00140000
      *  PROGRAM:       S311.                                          *00150000
      *  CALLING SP:    PA_S311.                                       *00160000
      *                                                                *00170000
      ******************************************************************00180000
      *                                                                *00170000
      *                 P R O G R A M  S U M M A R Y                   *00190000
      *                                                                *00200000
      *  THIS PROGRAM UPDATES  THE CASH DRAWER CONTROL TABLE FOR       *00210000
      *  CLOSING THE BATCH.                                            *00220000
      *                                                                *00200000
      ******************************************************************00230000
      *                                                                *00240000
      *                     PROGRAM MODIFICATION LOG                   *00250000
      *                                                                *00260000
      *    DATE    INITIALS   COMMENTS                                 *00270000
      *  --------  --------   ---------------------------------------  *00280000
      *  10/05/99   CBSI       ORIGINALLY CODED                        *00240000
T19919*  11/29/99   CBSI       MODIFIED TO CHECK FOR AR LOCKOUT.       *00240000
T19941*  12/01/99   JM         CHECK FOR NEGATIVE CURRENCY BALANCES.   *        
T22767*  09/13/01   BASKAR     ALLOW TREASURY TO CLOSE THEIR BATCH     *00260000
T22767*                        WITHOUT BALANCING.                      *00260000
REARCH*  06/29/05   CVNS       RPC TO COBOL SP CONVERSION              *        
REARCH*             CHENNAI                                            *        
      ******************************************************************01320000
      *                                                                *01330000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *01340000
      *                                                                *01350000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *01360000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *01370000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *01380000
      *  3000 - 4999  NOT USED                                         *01390000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *01400000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *01410000
      *  7000 - 7999  INPUT MODULES                                    *01420000
      *  8000 - 8999  OUTPUT MODULES                                   *01430000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *01440000
      *                                                                *01450000
      ******************************************************************01460000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02311'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                    PIC X(40)       VALUE            
REARCH     'WORKING STORAGE FOR CSR02311 STARTS HERE'.                  
                                                                        
      ******************************************************************01550000
      *    COBOL WORKING STORAGE COPY BOOKS                            *01560000
      ******************************************************************01570000
                                                                        
REARCH*    COPY SYGWCOB.                                                01590000
REARCH*    COPY SYDBCOB.                                                01600000
REARCH*    COPY CWS00010.                                               01650000
           COPY CWS00303.                                               01700000
           COPY CJF00101.                                                       
REARCH*                                                                         
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CWSX0010                                                 
REARCH     END-EXEC.                                                            
                                                                        
      ******************************************************************01760000
      *    WORK AREAS                                                  *01770000
      ******************************************************************01780000
                                                                        
REARCH*01  GW-LIB-MISC-FIELDS.                                          03480000
REARCH*    05  GWL-PROC                POINTER.                         03490000
REARCH*    05  GWL-INIT-HANDLE         POINTER.                         03500000
REARCH*    05  GWL-RC                  PIC S9(9)        COMP.           03510000
REARCH*    05  GWL-STATUS-NR           PIC S9(9)        COMP.           03520000
REARCH*    05  GWL-STATUS-DONE         PIC S9(9)        COMP.           03530000
REARCH*    05  GWL-STATUS-COUNT        PIC S9(9)        COMP.           03540000
REARCH*    05  GWL-STATUS-COMM         PIC S9(9)        COMP.           03550000
REARCH*    05  GWL-STATUS-RETURN-CODE  PIC S9(9)        COMP.           03560000
REARCH*    05  GWL-STATUS-SUBCODE      PIC S9(9)        COMP.           03570000
REARCH*                                                                         
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  GTT-NAME                 PIC X(26)                       
REARCH                                      VALUE 'SESSION.CSR02311_R1'.
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN           PIC S9(04) COMP.                
REARCH         49 GTT-ROW-CHAR          PIC X(1024).                    
REARCH     05  GTT-SQLCODE              PIC S9(9) COMP.                 
REARCH*                                                                         
       01  FILLER                      PIC X(11)        VALUE           
                                                        'PARM FIELDS'.  
REARCH*01  PARM-FIELDS.                                                 03600000
REARCH*                                                                 03590000
REARCH*    05  PARM-L                  PIC S9(09)       COMP.           03610000
REARCH*    05  PARM-ID1                PIC S9(09)       COMP            03620000
REARCH*                                                 VALUE 1.                
REARCH*    05  PARM-COMPANY-NO         PIC X(02).                       03630000
REARCH*    05  PARM-CASH-LOCAL-OFFICE  PIC X(03).                       03630000
REARCH*    05  PARM-DATE-CASH-REPORT   PIC X(10).                       03630000
REARCH*    05  PARM-CASH-DRAWER-ID     PIC S9(04)       COMP.           03630000
REARCH*    05  PARM-USER-ID            PIC X(07).                       03630000
REARCH*    05  PARM-BALANCED-USER-ID   PIC X(07).                       03630000
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9)        COMP.           
           05  SNA-CONNECTION-NAME     PIC X(8)         VALUE SPACES.   
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9)        COMP            
                                                        VALUE 1.        
           05  CTR-ROWS                PIC S9(9)        COMP            
                                                        VALUE 0.        
           05  CURSOR-CTR-ROWS         PIC S9(09) COMP VALUE 0.         
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9)        COMP.           
           05  WRKLEN1                 PIC S9(9)        COMP.           
           05  WRKLEN2                 PIC S9(9)        COMP.           
           05  WRK-DONE-STATUS         PIC S9(9)        COMP.           
T19941     05  WS-GL-ACCT-NO OCCURS 500 TIMES INDEXED BY WS-GLX         
                                       PIC S9(03)V9(04) COMP-3          
                                       VALUE +0.                        
T19941     05  WS-CASH-AVL             PIC S9(11)V99 COMP-3 VALUE +0.   
T19941     05  WS-CHECK-MO-AVL         PIC S9(11)V99 COMP-3 VALUE +0.   
T19941     05  WS-PROCESS-FLAG         PIC X(01) VALUE 'N'.             
T19941         88 WS-DEBIT                       VALUE 'D'.             
T19941         88 WS-CREDIT                      VALUE 'C'.             
T19941         88 WS-NOTHING                     VALUE 'N'.             
           05  WS-NULL-IND             PIC S9(04) COMP.                 
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME            PIC X(08)        VALUE           
REARCH                                                  'CSR02311'.     
           05  ALL-DONE-SW             PIC X(01)        VALUE 'N'.      
               88 NOT-ALL-DONE                          VALUE 'N'.      
               88 ALL-DONE                              VALUE 'Y'.      
           05  SEND-DONE-SW            PIC X(01)        VALUE 'Y'.      
               88 SEND-DONE-ERROR                       VALUE 'N'.      
               88 SEND-DONE-OK                          VALUE 'Y'.      
                                                                        
T19941 01  WS-CURRENCY-TYPE.                                            
T19941     05  WS-CASH                 PIC X(01) VALUE 'A'.             
T19941     05  WS-CHECK                PIC X(01) VALUE 'C'.             
T19941     05  WS-MONEY-ORDER          PIC X(01) VALUE 'M'.             
T19941     05  WS-LIHEAP               PIC X(01) VALUE 'L'.             
                                                                        
       01  WS-WORK-FIELDS.                                              
           05 WS-BATCH-STATUS-FLAG     PIC X            VALUE 'N'.      
           05 WS-YES                   PIC X            VALUE 'C'.      
T19919     05 WS-Y                     PIC X            VALUE 'Y'.      
T22767     05 WS-99                    PIC X(03)        VALUE '099'.    
           05 WS-ACTIVE                PIC X            VALUE 'A'.      
           05 WS-CLOSED                PIC X            VALUE 'C'.      
                                                                        
       01  FILLER                      PIC X(32)        VALUE           
                'THIS IS THE ROW RETURN AREA.'.                         
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9)        COMP            
                                                        VALUE 0.        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE           PIC S9(9)        COMP            
                                                        VALUE 0.        
REARCH*01  CN-COLUMN-NAMES.                                             04530000
REARCH*    05  CN-RETURN-CODE          PIC X(11)        VALUE                   
REARCH*                                      'RETURN_CODE'.                     
REARCH*                                                                         
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
REARCH     10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
REARCH     10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
REARCH     10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
REARCH         49  S-HOST-VARIABLES-V  PIC X(255).                      
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-STATEMENT-V   PIC X(255).                      
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-DESCRIPTION-V PIC X(255).                      
                                                                        
           EXEC SQL                                                             
                INCLUDE SQLCA                                           05750000
           END-EXEC.                                                    05760000
                                                                        
           EXEC SQL                                                             
                INCLUDE TBMODEL                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CSH_DRWR_CNTL                                           *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     05860000
                INCLUDE  TBCDCNTL                                       05870000
           END-EXEC.                                                    05880000
                                                                        
T19919******************************************************************        
T19919*    CSS_AR_LOCKOUT                                              *        
T19919******************************************************************        
T19919                                                                  
T19919     EXEC SQL                                                     05860000
T19919          INCLUDE  TBARLOCK                                       05870000
T19919     END-EXEC.                                                    05880000
T19919                                                                  
                                                                        
T19941* CSS_CSH_DRWR_JRNL                                                       
T19941                                                                  
T19941     EXEC SQL                                                     05860000
T19941          INCLUDE TBCDJRNL                                        05870000
T19941     END-EXEC.                                                    05880000
                                                                        
T19941* CSS_CURRENCY                                                            
           EXEC SQL                                                             
                INCLUDE TBCURRCY                                                
           END-EXEC.                                                            
                                                                        
T19941* CSS_GL_ACCT_NO                                                          
           EXEC SQL                                                             
                INCLUDE TBGLATNO                                                
           END-EXEC.                                                            
                                                                        
T19941* CSS_LIEAP_AGENCY                                                        
           EXEC SQL                                                             
                INCLUDE TBLIAGCY                                                
           END-EXEC.                                                            
T19941* CSS_BANK_TRANSFER                                                       
           EXEC SQL                                                             
                INCLUDE TBBNKXFR                                                
           END-EXEC.                                                            
                                                                        
T19941* CSS_LIEAP_AGENCY-CURSOR                                                 
           EXEC SQL                                                     
              DECLARE I5-CURSOR CURSOR FOR                              
              SELECT DISTINCT                                           
                     GL_ACCT_NO                                         
              FROM   CSS_LIEAP_AGENCY                                   
              WHERE  COMPANY_NO = :I5-COMPANY-NO                        
              ORDER BY GL_ACCT_NO                                       
           END-EXEC.                                                    
                                                                        
T19941* CSS_CSH_DRWR_JRNL CURSOR                                                
           EXEC SQL                                                     
              DECLARE CJ-CURSOR CURSOR FOR                              
              SELECT TRAN_DATA,                                         
                     CJ.CURRENCY_TYPE                                   
              FROM   CSS_CSH_DRWR_JRNL CJ,                              
                     CSS_CURRENCY Y7                                    
              WHERE CASH_COMPANY_NO = :CJ-CASH-COMPANY-NO               
              AND   CASH_LOCAL_OFFICE = :CJ-CASH-LOCAL-OFFICE           
              AND   CASH_DRAWER_ID = :CJ-CASH-DRAWER-ID                 
              AND   DATE_CASH_REPORT = IIF(TRY_CONVERT(DATE, 
                                                   :CJ-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CJ-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CJ-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CJ-DATE-CASH-REPORT
              ), CONVERT(DATE, :CJ-DATE-CASH-REPORT) )             
              AND   CJ.CURRENCY_TYPE = Y7.CURRENCY_TYPE                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CJ-CURSOR CURSOR FOR                                      
MFA-TR*       SELECT TRAN_DATA,                                                 
MFA-TR*              CJ.CURRENCY_TYPE                                           
MFA-TR*       FROM   CSS_CSH_DRWR_JRNL CJ,                                      
MFA-TR*              CSS_CURRENCY Y7                                            
MFA-TR*       WHERE CASH_COMPANY_NO = :CJ-CASH-COMPANY-NO                       
MFA-TR*       AND   CASH_LOCAL_OFFICE = :CJ-CASH-LOCAL-OFFICE                   
MFA-TR*       AND   CASH_DRAWER_ID = :CJ-CASH-DRAWER-ID                         
MFA-TR*       AND   DATE_CASH_REPORT = :CJ-DATE-CASH-REPORT                     
MFA-TR*       AND   CJ.CURRENCY_TYPE = Y7.CURRENCY_TYPE                         
MFA-TR*    END-EXEC.                                                            
                                                                        
REARCH LINKAGE SECTION.                                                 
REARCH 01  PARM-COMPANY-NO         PIC X(02).                           
REARCH 01  PARM-CASH-LOCAL-OFFICE  PIC X(03).                           
REARCH 01  PARM-DATE-CASH-REPORT   PIC X(10).                           
REARCH 01  PARM-CASH-DRAWER-ID     PIC S9(04)       COMP.               
REARCH 01  PARM-USER-ID            PIC X(07).                           
REARCH 01  PARM-BALANCED-USER-ID   PIC X(07).                           
REARCH*                                                                         
REARCH PROCEDURE DIVISION USING PARM-COMPANY-NO                         
REARCH                          PARM-CASH-LOCAL-OFFICE                  
REARCH                          PARM-DATE-CASH-REPORT                   
REARCH                          PARM-CASH-DRAWER-ID                     
REARCH                          PARM-USER-ID                            
REARCH                          PARM-BALANCED-USER-ID.                  
                                                                        
      ******************************************************************07600000
      * 0000-MAINLINE                                                  *07610000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *07620000
      ******************************************************************07630000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE             THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07730000
      * 0100-INITIALIZE                                                *07740000
      *                                                                *07750000
      *     1. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *07760000
      *     2. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *07770000
      *     3. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*07780000
      *                                                                *07790000
      ******************************************************************07800000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                         TO ACTIVE-PARAGRAPH.     
           EXEC SQL                                                     
                WHENEVER SQLWARNING CONTINUE                            
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
                WHENEVER SQLERROR CONTINUE                              
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
                WHENEVER NOT FOUND CONTINUE                             
           END-EXEC.                                                    
                                                                        
REARCH*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.     07870000
REARCH*                                                                 07880000
REARCH*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,     07890000
REARCH*                          SNA-CONNECTION-NAME, SNA-SUBC.         07900000
REARCH*                                                                 07910000
REARCH*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                      07920000
REARCH*                                                                 07930000
REARCH*    IF  GWL-RC NOT = TDS-PARM-PRESENT                            07940000
REARCH*        MOVE PROGRAM-NAME               TO ABEND-PROGRAM         07950000
REARCH*        MOVE '0100'                     TO ACTIVE-PARAGRAPH      07960000
REARCH*        MOVE 'TDRESULT - NO RPC PARM SENT'                       07970000
REARCH*                                        TO ABEND-FUNCTION                
REARCH*        MOVE 'CICS TRANSACTION'         TO TABLE-1               07980000
REARCH*        MOVE GWL-RC                     TO                       07990000
REARCH*             WS-ACTIVE-RETURN-CODE                                       
REARCH*        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           08000000
REARCH*        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           08000000
REARCH*    END-IF.                                                      08010000
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARCH           :S-RETURN-CODE          AS RETURN_CODE                 
REARCH         FROM                                                     
REARCH             CIS.SYSDUMMY1                                     
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*          :S-RETURN-CODE          AS RETURN_CODE                         
MFA-TR*        FROM                                                             
MFA-TR*            SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08040000
      * 1000-PROCESS-INPUT.                                            *08050000
      *                                                                *08060000
      *     1. RECEIVE PARMS.                                          *08070000
      *                                                                *08080000
      ******************************************************************08090000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000'                         TO ACTIVE-PARAGRAPH.     
REARCH*    PERFORM 1100-RECEIVE-PARMS          THRU 1100-EXIT.          08130000
           MOVE PARM-COMPANY-NO                TO CS-CASH-COMPANY-NO    
                                                  I5-COMPANY-NO         
                                                  CJ-CASH-COMPANY-NO    
                                                  YB-CASH-COMPANY-NO    
                                                  GO-COMPANY-NO.        
           MOVE PARM-CASH-LOCAL-OFFICE         TO CS-CASH-LOCAL-OFFICE  
                                                  CJ-CASH-LOCAL-OFFICE  
                                                  YB-CASH-LOCAL-OFFICE. 
           MOVE PARM-DATE-CASH-REPORT          TO CS-DATE-CASH-REPORT   
                                                  CJ-DATE-CASH-REPORT   
                                                  YB-DATE-CASH-REPORT.  
           MOVE PARM-CASH-DRAWER-ID            TO CS-CASH-DRAWER-ID     
                                                  CJ-CASH-DRAWER-ID     
                                                  YB-CASH-DRAWER-ID.    
           MOVE PARM-USER-ID                   TO CS-USER-ID.           
           MOVE PARM-BALANCED-USER-ID          TO CS-BALANCED-BY.       
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 08170000
      * 1100-RECEIVE-PARMS                                            * 08180000
      *                                                               * 08190000
      *     RECEIVE EACH PARAMETER FROM THE REMOTE PROCEDURE          * 08200000
      *                                                               * 08210000
      ***************************************************************** 08220000
REARCH*                                                                 08230000
REARCH*1100-RECEIVE-PARMS.                                              08240000
REARCH*                                                                 08230000
REARCH*    MOVE '1100'                         TO ACTIVE-PARAGRAPH.     08250000
REARCH*    MOVE 1                              TO PARM-ID1.             08260000
REARCH*    MOVE LENGTH OF PARM-COMPANY-NO      TO MAX-LENGTH-PARM.      08230000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              08230000
REARCH*                          GWL-RC,                                08230000
REARCH*                          PARM-ID1,                              08230000
REARCH*                          PARM-COMPANY-NO,                       08230000
REARCH*                          TDSCHAR,                               08230000
REARCH*                          MAX-LENGTH-PARM,                       08230000
REARCH*                          PARM-L.                                08230000
REARCH*    ADD 1                               TO PARM-ID1.             08230000
REARCH*    MOVE LENGTH OF PARM-CASH-LOCAL-OFFICE                        08360000
REARCH*                                        TO MAX-LENGTH-PARM,      08230000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              08370000
REARCH*                          GWL-RC,                                08380000
REARCH*                          PARM-ID1,                              08390000
REARCH*                          PARM-CASH-LOCAL-OFFICE,                08400000
REARCH*                          TDSCHAR,                               08410000
REARCH*                          MAX-LENGTH-PARM,                       08420000
REARCH*                          PARM-L.                                08430000
REARCH*                                                                 08230000
REARCH*    ADD 1                               TO PARM-ID1.             08350000
REARCH*    MOVE LENGTH OF PARM-DATE-CASH-REPORT                         08360000
REARCH*                                        TO MAX-LENGTH-PARM,      08230000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              08370000
REARCH*                          GWL-RC,                                08380000
REARCH*                          PARM-ID1,                              08390000
REARCH*                          PARM-DATE-CASH-REPORT,                 08400000
REARCH*                          TDSCHAR,                               08410000
REARCH*                          MAX-LENGTH-PARM,                       08420000
REARCH*                          PARM-L.                                08430000
REARCH*                                                                 08230000
REARCH*    ADD 1                               TO PARM-ID1.             08350000
REARCH*    MOVE LENGTH OF PARM-CASH-DRAWER-ID                           08360000
REARCH*                                        TO MAX-LENGTH-PARM,      08230000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              08370000
REARCH*                          GWL-RC,                                08380000
REARCH*                          PARM-ID1,                              08390000
REARCH*                          PARM-CASH-DRAWER-ID,                   08400000
REARCH*                          TDSINT2,                               08410000
REARCH*                          MAX-LENGTH-PARM,                       08420000
REARCH*                          PARM-L.                                08430000
REARCH*    ADD 1                               TO PARM-ID1.             08350000
REARCH*    MOVE LENGTH OF PARM-USER-ID         TO MAX-LENGTH-PARM,      08360000
REARCH*                                                                 08230000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              08370000
REARCH*                          GWL-RC,                                08380000
REARCH*                          PARM-ID1,                              08390000
REARCH*                          PARM-USER-ID,                          08400000
REARCH*                          TDSCHAR,                               08410000
REARCH*                          MAX-LENGTH-PARM,                       08420000
REARCH*                          PARM-L.                                08430000
REARCH*                                                                 08230000
REARCH*    ADD 1                               TO PARM-ID1.             08350000
REARCH*    MOVE LENGTH OF PARM-BALANCED-USER-ID                         08230000
REARCH*                                        TO MAX-LENGTH-PARM.      08230000
REARCH*                                                                 08230000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              08370000
REARCH*                          GWL-RC,                                08380000
REARCH*                          PARM-ID1,                              08390000
REARCH*                          PARM-BALANCED-USER-ID,                 08400000
REARCH*                          TDSCHAR,                               08410000
REARCH*                          MAX-LENGTH-PARM,                       08420000
REARCH*                          PARM-L.                                08430000
REARCH*                                                                 08230000
REARCH*1100-EXIT.                                                       08440000
REARCH*    EXIT.                                                        08450000
                                                                        
      ******************************************************************08470000
      * 2000-PROCESS-OUTPUT.                                           *08480000
      *                                                                *08490000
      *     1. DESCRIBE RESULT SET                                     *08500000
      *     2. UPDATE DB2 DATA                                         *08510000
      *     3. BUILD RESULT SET                                        *08520000
      *     4. SEND RESULT SET                                         *08530000
      *                                                                *08540000
      ******************************************************************08550000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                         TO ACTIVE-PARAGRAPH.     
REARCH*    PERFORM 2100-DESCRIBE-RESULT        THRU 2100-EXIT.          08590000
T19919     PERFORM 7999-SELECT-AL              THRU 7999-SELECT-AL-EXIT.
T19919                                                                  
T19919     IF  AL-AR-LOCKOUT-IND = WS-Y                                 
T19919         MOVE 5000                       TO RS-RETURN-CODE        
REARCH         PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT          
REARCH         ADD +1                          TO   CTR-ROWS            
T19919*        PERFORM 8100-SEND-RESULT        THRU 8100-EXIT                   
T19919         PERFORM 9999-END-PROGRAM        THRU 9999-EXIT           
T19919     END-IF.                                                      
T19919                                                                  
           PERFORM 2200-PROCESS-DETAIL         THRU 2200-EXIT.          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH*****************************************************************         
REARCH* 2000A-MOVE-RESULT.                                            *         
REARCH*****************************************************************         
REARCH*                                                                         
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE RS-RETURN-CODE          TO S-RETURN-CODE.               
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
      ******************************************************************08640000
      * 2100-DESCRIBE-RESULT                                           *08650000
      *                                                                *08660000
      *     DESCRIBE EACH COLUMN IN THE RESULT SET.                    *08670000
      *                                                                *08680000
      ******************************************************************08690000
REARCH*                                                                 08700000
REARCH*2100-DESCRIBE-RESULT.                                            08710000
REARCH*                                                                 08700000
REARCH*    MOVE '2100'                         TO ACTIVE-PARAGRAPH.     02850011
REARCH*    MOVE 1                              TO CTR-COLUMN.           02870000
REARCH*    MOVE TDSINT4                        TO DB-HOST-TYPE.         02880000
REARCH*    MOVE TDSINT4                        TO DB-CLIENT-TYPE.       02890000
REARCH*    MOVE LENGTH OF RS-RETURN-CODE       TO WRKLEN1.              02900000
REARCH*    MOVE LENGTH OF CN-RETURN-CODE       TO WRKLEN2.              02910000
REARCH*                                                                 02920000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02930000
REARCH*                          GWL-RC,                                02940000
REARCH*                          CTR-COLUMN,                            02950000
REARCH*                          DB-HOST-TYPE,                          02960000
REARCH*                          WRKLEN1,                               02970000
REARCH*                          RS-RETURN-CODE,                        02980000
REARCH*                          DB-NULL-INDICATOR,                     02990000
REARCH*                          TDS-FALSE,                             03000000
REARCH*                          DB-CLIENT-TYPE,                        03010000
REARCH*                          WRKLEN1,                               03020000
REARCH*                          CN-RETURN-CODE,                        03030000
REARCH*                          WRKLEN2.                               03040000
REARCH*                                                                 03050000
REARCH*    PERFORM 9100-CHECK-ERROR            THRU 9100-EXIT.          03060000
REARCH*                                                                 08700000
REARCH*2100-EXIT.                                                       21953000
REARCH*    EXIT.                                                        21960000
                                                                        
      ******************************************************************        
      *    2200-PROCESS-DETAIL                                         *        
      *                                                                *        
      *    1. CHECK IF THE BATCH IS OPEN IF YES GET THE TIME STAMP     *        
      *       AND CLOSE THE BATCH OR RETURN A RETURN CODE OF 1000.*             
      *                                                                *        
      ******************************************************************        
                                                                        
       2200-PROCESS-DETAIL.                                             
                                                                        
           MOVE '2200'                         TO ACTIVE-PARAGRAPH.     
T19941     MOVE 'CLR-CASH'                     TO GO-GL-ACCT-NAME.      
T19941     PERFORM 7300-SELECT-CLR-CASH        THRU 7300-EXIT.          
                                                                        
T19941     PERFORM 7400-OPEN-I5CURSOR          THRU 7400-EXIT.          
T19941     PERFORM 7450-FETCH-I5CURSOR         THRU 7450-EXIT.          
                                                                        
T19941     PERFORM                                                      
T19941         VARYING WS-GLX FROM 1 BY 1                               
T19941         UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND              
T19941         MOVE I5-GL-ACCT-NO              TO WS-GL-ACCT-NO(WS-GLX) 
T19941         PERFORM 7450-FETCH-I5CURSOR     THRU 7450-EXIT           
T19941     END-PERFORM.                                                 
                                                                        
T19941     PERFORM 7475-CLOSE-I5CURSOR         THRU 7475-EXIT.          
T19941     PERFORM 5000-PROCESS-JRNL           THRU 5000-EXIT.          
                                                                        
T19941     IF CURSOR-CTR-ROWS GREATER THAN ZERO THEN                    
T19941         PERFORM 5100-PROCESS-TRNSFRS    THRU 5100-EXIT           
T19941     END-IF.                                                      
                                                                        
T19941     IF WS-CASH-AVL LESS THAN ZERO OR                             
T19941     WS-CHECK-MO-AVL LESS THAN ZERO THEN                          
T22767        IF PARM-CASH-LOCAL-OFFICE = WS-99                         
T22767           CONTINUE                                               
T22767        ELSE                                                      
T19941           MOVE 200                      TO RS-RETURN-CODE        
REARCH           PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT          
REARCH           ADD +1                        TO   CTR-ROWS            
T19941*          PERFORM 8100-SEND-RESULT      THRU 8100-EXIT                   
T19941           PERFORM 9999-END-PROGRAM      THRU 9999-EXIT           
T22767        END-IF                                                    
T19941     END-IF.                                                      
                                                                        
           MOVE WS-ACTIVE                      TO CS-CODE-CSH-DRWR-STAT.
           PERFORM 7000-CHK-BATCH-STATUS       THRU 7000-EXIT.          
                                                                        
           IF  WS-BATCH-STATUS-FLAG EQUAL WS-YES                        
               PERFORM 7100-GET-TIMESTAMP      THRU 7100-EXIT           
               MOVE WS-CLOSED                  TO CS-CODE-CSH-DRWR-STAT 
               PERFORM 7200-CLOSE-BATCH        THRU 7200-EXIT           
           ELSE                                                         
               MOVE 1000                       TO RS-RETURN-CODE        
           END-IF.                                                      
                                                                        
REARCH     PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT.         
REARCH     ADD +1                              TO   CTR-ROWS.           
REARCH*    PERFORM 8100-SEND-RESULT            THRU 8100-EXIT.                  
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
T19941******************************************************************        
T19941*   5000-PROCESS-JRNL                                            *        
T19941******************************************************************        
       5000-PROCESS-JRNL.                                               
                                                                        
           PERFORM 7500-OPEN-CJCURSOR          THRU 7500-EXIT.          
           PERFORM 7550-FETCH-CJCURSOR         THRU 7550-EXIT.          
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
              MOVE CJ-TRAN-DATA               TO CJF00101               
                                                                        
              MOVE 'N'                        TO WS-PROCESS-FLAG        
                                                                        
              IF WS-101-ACCT-GEN-LED-DR EQUAL WS-101-ACCT-GEN-LED-CR    
                  MOVE 'N'                    TO WS-PROCESS-FLAG        
              ELSE                                                      
                  IF WS-101-ACCT-GEN-LED-DR EQUAL GO-GL-ACCT-NO         
                     MOVE 'D'                 TO WS-PROCESS-FLAG        
                  ELSE                                                  
                     IF WS-101-ACCT-GEN-LED-CR EQUAL GO-GL-ACCT-NO      
                        MOVE 'C'              TO WS-PROCESS-FLAG        
                     END-IF                                             
                  END-IF                                                
                                                                        
                  IF WS-NOTHING THEN                                    
                      SET WS-GLX        TO 1                            
                                                                        
                      SEARCH WS-GL-ACCT-NO                              
                          WHEN WS-101-ACCT-GEN-LED-DR EQUAL             
                          WS-GL-ACCT-NO(WS-GLX)                         
                              MOVE 'D'  TO WS-PROCESS-FLAG              
                      END-SEARCH                                        
                                                                        
                      SET WS-GLX        TO 1                            
                                                                        
                      SEARCH WS-GL-ACCT-NO                              
                          WHEN WS-101-ACCT-GEN-LED-CR EQUAL             
                          WS-GL-ACCT-NO(WS-GLX)                         
                          IF WS-DEBIT THEN                              
                              MOVE 'N'    TO WS-PROCESS-FLAG            
                          ELSE                                          
                              MOVE 'C'    TO WS-PROCESS-FLAG            
                          END-IF                                        
                      END-SEARCH                                        
                  END-IF                                                
              END-IF                                                    
                                                                        
              IF WS-DEBIT THEN                                          
                  IF CJ-CURRENCY-TYPE EQUAL WS-CASH THEN                
                      ADD WS-101-AMT-POSTED     TO WS-CASH-AVL          
                  ELSE                                                  
                      IF CJ-CURRENCY-TYPE EQUAL WS-CHECK OR             
                      WS-MONEY-ORDER THEN                               
                          ADD WS-101-AMT-POSTED TO WS-CHECK-MO-AVL      
                      END-IF                                            
                  END-IF                                                
                                                                        
              ELSE                                                      
                  IF WS-CREDIT THEN                                     
                      IF CJ-CURRENCY-TYPE EQUAL WS-CASH THEN            
                          SUBTRACT WS-101-AMT-POSTED                    
                                            FROM WS-CASH-AVL            
                      ELSE                                              
                          IF CJ-CURRENCY-TYPE EQUAL WS-CHECK OR         
                          WS-MONEY-ORDER THEN                           
                              SUBTRACT WS-101-AMT-POSTED                
                                            FROM WS-CHECK-MO-AVL        
                          END-IF                                        
                      END-IF                                            
                  END-IF                                                
               END-IF                                                   
                                                                        
               PERFORM 7550-FETCH-CJCURSOR    THRU 7550-EXIT            
T19941     END-PERFORM.                                                 
                                                                        
T19941 5000-EXIT.                                                       
T19941     EXIT.                                                        
                                                                        
T19941******************************************************************        
T19941*   5100-PROCESS-TRNSFRS                                         *        
T19941******************************************************************        
       5100-PROCESS-TRNSFRS.                                            
                                                                        
           MOVE WS-CASH                 TO YB-CURRENCY-TYPE.            
           PERFORM 5150-SUM-TRNSFRS     THRU 5150-EXIT.                 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL AND           
           WS-NULL-IND EQUAL ZERO THEN                                  
              SUBTRACT YB-TRANSFER-AMT  FROM WS-CASH-AVL                
           END-IF.                                                      
                                                                        
           MOVE WS-CHECK                TO YB-CURRENCY-TYPE.            
           PERFORM 5150-SUM-TRNSFRS     THRU 5150-EXIT.                 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL AND           
           WS-NULL-IND EQUAL ZERO THEN                                  
              SUBTRACT YB-TRANSFER-AMT  FROM WS-CHECK-MO-AVL            
           END-IF.                                                      
                                                                        
           MOVE WS-MONEY-ORDER          TO YB-CURRENCY-TYPE.            
           PERFORM 5150-SUM-TRNSFRS     THRU 5150-EXIT.                 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL AND           
           WS-NULL-IND EQUAL ZERO THEN                                  
              SUBTRACT YB-TRANSFER-AMT  FROM WS-CHECK-MO-AVL            
           END-IF.                                                      
                                                                        
T19941 5100-EXIT.                                                       
T19941     EXIT.                                                        
                                                                        
T19941******************************************************************        
T19941*    5150-SUM-TRNSFRS                                            *        
T19941******************************************************************        
                                                                        
       5150-SUM-TRNSFRS.                                                
                                                                        
           EXEC SQL                                                     
                SELECT  SUM(TRANSFER_AMT)                               
                  INTO  :YB-TRANSFER-AMT :WS-NULL-IND                    
                  FROM  CSS_BANK_TRANSFER                               
                 WHERE  CURRENCY_TYPE = :YB-CURRENCY-TYPE               
                   AND  CASH_DRAWER_ID = :YB-CASH-DRAWER-ID             
                   AND  DATE_CASH_REPORT = IIF(TRY_CONVERT(DATE, 
                                                   :YB-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YB-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YB-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YB-DATE-CASH-REPORT
              ), CONVERT(DATE, :YB-DATE-CASH-REPORT) )         
                   AND  CASH_LOCAL_OFFICE = :YB-CASH-LOCAL-OFFICE       
                   AND  CASH_COMPANY_NO = :YB-CASH-COMPANY-NO           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  SUM(TRANSFER_AMT)                                       
MFA-TR*           INTO  :YB-TRANSFER-AMT:WS-NULL-IND                            
MFA-TR*           FROM  CSS_BANK_TRANSFER                                       
MFA-TR*          WHERE  CURRENCY_TYPE = :YB-CURRENCY-TYPE                       
MFA-TR*            AND  CASH_DRAWER_ID = :YB-CASH-DRAWER-ID                     
MFA-TR*            AND  DATE_CASH_REPORT = :YB-DATE-CASH-REPORT                 
MFA-TR*            AND  CASH_LOCAL_OFFICE = :YB-CASH-LOCAL-OFFICE               
MFA-TR*            AND  CASH_COMPANY_NO = :YB-CASH-COMPANY-NO                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE '5150'                     TO ACTIVE-PARAGRAPH      
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE 'SUM-TRNSFRS'              TO ABEND-FUNCTION        
               MOVE 'CSS_BANK_TRANSFER'        TO TABLE-1               
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-1       
               MOVE YB-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-1     
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-2       
               MOVE YB-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-2     
               MOVE 'CASH_DRAWER_ID'           TO TABLE-ELEMENT-3       
               MOVE YB-CASH-DRAWER-ID          TO HOSTVAR-ELEMENT-3     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
T19941 5150-EXIT.                                                       
T19941     EXIT.                                                        
T19941                                                                  
      ******************************************************************        
      *   7000-CHK-BATCH-STATUS                                        *        
      *                                                                *        
      *   TO CHECH IF THE BATCH IS OPEN.                               *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7000-CHK-BATCH-STATUS.                                           
                                                                        
           EXEC SQL                                                     
                SELECT  :WS-YES                                         
                  INTO  :WS-BATCH-STATUS-FLAG                           
                  FROM  CSS_CSH_DRWR_CNTL                               
                 WHERE  CASH_COMPANY_NO     = :CS-CASH-COMPANY-NO       
                   AND  CASH_LOCAL_OFFICE   = :CS-CASH-LOCAL-OFFICE     
                   AND  DATE_CASH_REPORT    = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )      
                   AND  CASH_DRAWER_ID      = :CS-CASH-DRAWER-ID        
                   AND  USER_ID             = :CS-USER-ID               
                   AND  CODE_CSH_DRWR_STAT  = :CS-CODE-CSH-DRWR-STAT    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  :WS-YES                                                 
MFA-TR*           INTO  :WS-BATCH-STATUS-FLAG                                   
MFA-TR*           FROM  CSS_CSH_DRWR_CNTL                                       
MFA-TR*          WHERE  CASH_COMPANY_NO     = :CS-CASH-COMPANY-NO               
MFA-TR*            AND  CASH_LOCAL_OFFICE   = :CS-CASH-LOCAL-OFFICE             
MFA-TR*            AND  DATE_CASH_REPORT    = :CS-DATE-CASH-REPORT              
MFA-TR*            AND  CASH_DRAWER_ID      = :CS-CASH-DRAWER-ID                
MFA-TR*            AND  USER_ID             = :CS-USER-ID                       
MFA-TR*            AND  CODE_CSH_DRWR_STAT  = :CS-CODE-CSH-DRWR-STAT            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE,
                                                  RS-RETURN-CODE.       
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR               
               WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7000'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CSH_DRWR_CNTL'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'USER_ID'                  TO TABLE-ELEMENT-3       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4       
               MOVE CS-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CS-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CS-USER-ID                 TO HOSTVAR-ELEMENT-3     
               MOVE CS-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7100-GET-TIMESTAMP                                          *        
      *                                                                *        
      *    TO GET THE CURRENT TIMESTAMP.                               *        
      ******************************************************************        
                                                                        
       7100-GET-TIMESTAMP.                                              
                                                                        
           EXEC SQL                                                     
                SELECT  REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CURRENT$TIMESTAMP(), 121), ' ', '-'), ':', '.')                 
                       ,CAST(SYSDATETIMEOFFSET() AS DATE)                       
                  INTO  :CS-BALANCED-TS                                 
                       ,:CS-DATE-LAST-ACTIVITY                          
                  FROM  CSS_MODEL_SQL                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  CURRENT TIMESTAMP                                       
MFA-TR*                ,CURRENT DATE                                            
MFA-TR*           INTO  :CS-BALANCED-TS                                         
MFA-TR*                ,:CS-DATE-LAST-ACTIVITY                                  
MFA-TR*           FROM  CSS_MODEL_SQL                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE,
                                                  RS-RETURN-CODE.       
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
               MOVE SPACES                     TO ABEND-TABLES          
                                                  ABEND-SQL-PREDICATES  
               MOVE '7100'                     TO ACTIVE-PARAGRAPH      
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE 'CSS_MODEL_SQL'            TO TABLE-1               
                                                                        
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
                                                                        
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7200-CLOSE-BATCH                                             *        
      *                                                                *        
      *   TO CLOSE THE BATCH                                           *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7200-CLOSE-BATCH.                                                
                                                                        
           EXEC SQL                                                     
                UPDATE  CSS_CSH_DRWR_CNTL                               
                   SET  CODE_CSH_DRWR_STAT  = :CS-CODE-CSH-DRWR-STAT    
                       ,DATE_LAST_ACTIVITY  = IIF(TRY_CONVERT(DATE, 
                                                 :CS-DATE-LAST-ACTIVITY
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-LAST-ACTIVITY
              ) <> 0) OR (LEN(:CS-DATE-LAST-ACTIVITY
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-LAST-ACTIVITY
              ), CONVERT(DATE, :CS-DATE-LAST-ACTIVITY) )    
                       ,BALANCED_TS         = CIS.CHAR2TIMESTAMP(
                                                        :CS-BALANCED-TS
              )           
                       ,BALANCED_BY         = :CS-BALANCED-BY           
                 WHERE  CASH_COMPANY_NO     = :CS-CASH-COMPANY-NO       
                   AND  CASH_LOCAL_OFFICE   = :CS-CASH-LOCAL-OFFICE     
                   AND  DATE_CASH_REPORT    = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )      
                   AND  CASH_DRAWER_ID      = :CS-CASH-DRAWER-ID        
                   AND  USER_ID             = :CS-USER-ID               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE  CSS_CSH_DRWR_CNTL                                       
MFA-TR*            SET  CODE_CSH_DRWR_STAT  = :CS-CODE-CSH-DRWR-STAT            
MFA-TR*                ,DATE_LAST_ACTIVITY  = :CS-DATE-LAST-ACTIVITY            
MFA-TR*                ,BALANCED_TS         = :CS-BALANCED-TS                   
MFA-TR*                ,BALANCED_BY         = :CS-BALANCED-BY                   
MFA-TR*          WHERE  CASH_COMPANY_NO     = :CS-CASH-COMPANY-NO               
MFA-TR*            AND  CASH_LOCAL_OFFICE   = :CS-CASH-LOCAL-OFFICE             
MFA-TR*            AND  DATE_CASH_REPORT    = :CS-DATE-CASH-REPORT              
MFA-TR*            AND  CASH_DRAWER_ID      = :CS-CASH-DRAWER-ID                
MFA-TR*            AND  USER_ID             = :CS-USER-ID                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE,
                                                  RS-RETURN-CODE.       
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
                                                                        
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7200'                     TO ACTIVE-PARAGRAPH      
               MOVE 'UPDATE'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CSH_DRWR_CNTL'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'USER_ID'                  TO TABLE-ELEMENT-3       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4       
               MOVE CS-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CS-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CS-USER-ID                 TO HOSTVAR-ELEMENT-3     
               MOVE CS-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
T19941******************************************************************        
      *    7300-SELECT-CLR-CASH                                        *        
      ******************************************************************        
                                                                        
       7300-SELECT-CLR-CASH.                                            
                                                                        
           EXEC SQL                                                     
                SELECT  GL_ACCT_NO                                      
                  INTO  :GO-GL-ACCT-NO                                  
                  FROM  CSS_GL_ACCT_NO                                  
                 WHERE  GL_ACCT_NAME = :GO-GL-ACCT-NAME                 
                   AND  COMPANY_NO = :GO-COMPANY-NO                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE '7300'                     TO ACTIVE-PARAGRAPH      
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE 'CSS_GL_ACCT_NO'           TO TABLE-1               
               MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1       
               MOVE GO-COMPANY-NO              TO HOSTVAR-ELEMENT-1     
               MOVE 'GL-ACCT-NAME'             TO TABLE-ELEMENT-2       
               MOVE GO-GL-ACCT-NAME            TO HOSTVAR-ELEMENT-2     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
T19941                                                                  
T19941******************************************************************        
      *    7400-OPEN-I5CURSOR                                          *        
      ******************************************************************        
                                                                        
       7400-OPEN-I5CURSOR.                                              
                                                                        
           EXEC SQL                                                     
                OPEN I5-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE '7400'                     TO ACTIVE-PARAGRAPH      
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE 'OPEN-I5CURSOR'            TO ABEND-FUNCTION        
               MOVE 'CSS_LIEAP_AGENCY'         TO TABLE-1               
               MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1       
               MOVE I5-COMPANY-NO              TO HOSTVAR-ELEMENT-1     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
T19941                                                                  
T19941******************************************************************        
      *    7450-FETCH-I5CURSOR                                         *        
      ******************************************************************        
                                                                        
       7450-FETCH-I5CURSOR.                                             
                                                                        
           EXEC SQL                                                     
              FETCH I5-CURSOR                                           
               INTO :I5-GL-ACCT-NO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
           OR NOT-FOUND THEN                                            
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE '7450'                     TO ACTIVE-PARAGRAPH      
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE 'FETCH-I5CURSOR'           TO ABEND-FUNCTION        
               MOVE 'CSS_LIEAP_AGENCY'         TO TABLE-1               
               MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1       
               MOVE I5-COMPANY-NO              TO HOSTVAR-ELEMENT-1     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7450-EXIT.                                                       
           EXIT.                                                        
T19941                                                                  
T19941******************************************************************        
      *    7475-CLOSE-I5CURSOR                                         *        
      ******************************************************************        
                                                                        
       7475-CLOSE-I5CURSOR.                                             
                                                                        
           EXEC SQL                                                     
              CLOSE I5-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE '7475'                     TO ACTIVE-PARAGRAPH      
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE 'CLOSE-I5CURSOR'           TO ABEND-FUNCTION        
               MOVE 'CSS_LIEAP_AGENCY'         TO TABLE-1               
               MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1       
               MOVE I5-COMPANY-NO              TO HOSTVAR-ELEMENT-1     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7475-EXIT.                                                       
           EXIT.                                                        
T19941                                                                  
T19941******************************************************************        
      *    7500-OPEN-CJCURSOR                                          *        
      ******************************************************************        
                                                                        
       7500-OPEN-CJCURSOR.                                              
                                                                        
           EXEC SQL                                                     
                OPEN CJ-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE '7500'                     TO ACTIVE-PARAGRAPH      
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE 'OPEN-CJCURSOR'            TO ABEND-FUNCTION        
               MOVE 'CSS_CSH_DRWR_JRNL'        TO TABLE-1               
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-1       
               MOVE CJ-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-1     
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-2       
               MOVE CJ-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-2     
               MOVE 'CASH-DRAWER-ID'           TO TABLE-ELEMENT-3       
               MOVE CJ-CASH-DRAWER-ID          TO HOSTVAR-ELEMENT-3     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
T19941                                                                  
T19941******************************************************************        
      *    7550-FETCH-CJCURSOR                                         *        
      ******************************************************************        
                                                                        
       7550-FETCH-CJCURSOR.                                             
                                                                        
           EXEC SQL                                                     
              FETCH CJ-CURSOR                                           
               INTO :CJ-TRAN-DATA,                                      
                    :CJ-CURRENCY-TYPE                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
           OR NOT-FOUND THEN                                            
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN      
                   ADD 1                       TO CURSOR-CTR-ROWS       
               END-IF                                                   
           ELSE                                                         
               MOVE '7550'                     TO ACTIVE-PARAGRAPH      
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE 'FETCH-CJCURSOR'           TO ABEND-FUNCTION        
               MOVE 'CSS_CSH_DRWR_JRNL'        TO TABLE-1               
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-1       
               MOVE CJ-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-1     
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-2       
               MOVE CJ-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-2     
               MOVE 'CASH-DRAWER-ID'           TO TABLE-ELEMENT-3       
               MOVE CJ-CASH-DRAWER-ID          TO HOSTVAR-ELEMENT-3     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7550-EXIT.                                                       
           EXIT.                                                        
T19941                                                                  
T19941                                                                  
T19941******************************************************************        
      *    7575-CLOSE-I5CURSOR                                         *        
      ******************************************************************        
                                                                        
       7575-CLOSE-I5CURSOR.                                             
                                                                        
           EXEC SQL                                                     
              CLOSE CJ-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE '7575'                     TO ACTIVE-PARAGRAPH      
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE 'CLOSE-CJCURSOR'           TO ABEND-FUNCTION        
               MOVE 'CSS_CSH_DRWR_JRNL'        TO TABLE-1               
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-1       
               MOVE CJ-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-1     
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-2       
               MOVE CJ-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-2     
               MOVE 'CASH-DRAWER-ID'           TO TABLE-ELEMENT-3       
               MOVE CJ-CASH-DRAWER-ID          TO HOSTVAR-ELEMENT-3     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7575-EXIT.                                                       
           EXIT.                                                        
T19941                                                                  
T19919******************************************************************        
T19919* 7999-SELECT-AL                                                 *        
T19919******************************************************************        
T19919     EXEC SQL                                                             
T19919          INCLUDE CPD00075                                                
T19919     END-EXEC.                                                            
                                                                        
      ******************************************************************42800000
      * 9700 -  ABEND HANDLING ROUTINE                                 *42810000
      ******************************************************************42820000
           EXEC SQL                                                     01720000
                INCLUDE CPD0023C                                        01730000
           END-EXEC.                                                    01740000
      ******************************************************************42800000
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *42810000
      ******************************************************************42820000
REARCH*    EXEC SQL                                                     42830000
REARCH*         INCLUDE CPD00300                                        42840000
REARCH*    END-EXEC.                                                    42850000
REARCH*                                                                         
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CPDSP300                                                 
REARCH     END-EXEC.                                                            
                                                                        
      ******************************************************************42870000
      *       END PROGRAM COPYLIB                                      *42880000
      ******************************************************************42890000
REARCH*    COPY CPD00302.                                               42900000
REARCH*                                                                         
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CPD00321                                                 
REARCH     END-EXEC.                                                            
