       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR02310.                                     
COB303 DATE-WRITTEN.      MAY 19, 1995.                                 
       DATE-COMPILED.                                                   
      *                                                                         
      ***************************************************************           
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S310                                           *        
      *  PROGRAM:       S310                                           *        
      *  CALLING SP:    PA_S310                                        *        
      *  PANEL:         475                                            *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *     THIS PROGRAM UPDATES, INSERTS AND DELETES RECORDS.         *        
      *  WHEN A CUSTOMER SETS UP A PAYMENT ARRANGEMENT ON A WRITTEN    *        
      *  OFF ACCOUNT A RECORD IS INSERTED INTO TABLE CSS_WO_AGGREEMENT.*        
      *  AN EXISTING PAYMENT ARRANGEMENT CAN ALSO BE MODIFIED OR       *        
      *  DELETED.  TABLE CSS_FINAL_WO MAY ALSO BE UPDATED.             *        
      *  MAINTENANCE TRANSACTION HISTORY JOURNALS ARE ALS0 WRITTEN     *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  01/19/96    CDS      PROCEDURE ORIGINALLY CODED.              *        
T12269*  07/22/97    MJG      UPDATED CREDIT BUREAU DATES WHENEVER     *        
T12372*                       THE PAYMENT START DATE CHANGES.          *        
T12605*                       ONLY WRITE OUT MAINTENACNE JRNLS IF      *        
      *                       THE FIELDS ARE VISIBLE ON THE DESKTOP.   *        
T12700*  08/13/97    GAC      TRANSACTION HISTORY LABEL FOR WO PAYMENTS*        
      *                       IS CHANGED FROM "TOTAL WO AMOUNT" TO     *        
      *                       "ARRANGEMENT AMT".                       *        
CBSI  *  12/23/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *              MADRAS   ABEND PARAMETERS                         *        
T21624*  03/08/00    MDJ      CREDIT BUREAU DATE WILL BE CALCULATED    *        
      *                       BASED ON VALUE ON CSS_DELINQUENCY -      *        
      *                       DAY-ADD-COLL-CB - # DAYS AFER COLLECTION *        
      *                       DATE.                                    *        
      *                       CHANGED DELETED LOGIC TO USE WORKING DAYS*        
      *                       WHEN RECALCULATING COLLECTION AND CREDIT *        
      *                       BUREAU DATES.                            *        
T21883*  10/18/00    VIJAY    MODIFIED TO UPDATE FIRST_CR_LTR_DT WITH  *        
      *                       COLLECTION AGENCY DATE WHEN THERE IS A   *        
      *                       CHANGE IN COLLECTION AGENCY DATE.        *        
      *                       MOVE ZEROTS TO FIRST_CR_LTR_AM.          *        
T23501*  02/15/01    SFH      ADDED COMPANY_NO TO THE WHERE CLAUSE IN  *        
      *                       PARA 7200 TO SUPPORT MULTI-COMPANY.      *        
REARCH*  06/20/05    CVNS     RPC TO COBOL SP CONVERSION                        
REARCH*              CHENNAI                                                    
T35434*  10/23/07    MK92804  REPLACED CSS_MODEL_SQL WITH SET STMTS    *        
T35434*                       AND ADDED FOR FETCH ONLY WITH UR FOR     *        
T35434*                       CURSOR SELECTS AND WITH UR FOR SINGLETON *        
T35434*                       SELECTS.                                 *        
C30169*  03/03/08    CVNS     CALL CSR04074 TO GET FORECAST DATES      *        
C30169*              CHENNAI                                           *        
C30169*  10/17/08    CVNS     DELETE THE CODES REFERENCES TO           *        
C30169*              CHENNAI  CSS_FINAL_WO TABLE FIELDS.               *        
P00799*  07/28/15    RC41079  CHANGE TO CORRECT -430 ADDING ARRANGEMENT*        
P00799*                       INITIALIZED KD-FW-ACTION-AM TO ZERO IN   *        
P00799*                       PARAGRAPH 7810- WHEN ROW IS NOT FOUND.   *        
ACT163*  05/17/16    TP7R341  REMOVE UNUSED COPYBOOKS CWS00076 AND     *        
ACT163*              APPL5460 CCA00001                                 *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02310'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02310 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBWOARGM                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
      *                                                                         
T21624     EXEC SQL                                                             
T21624        INCLUDE TBHLDAY                                                   
T21624     END-EXEC.                                                            
      *                                                                         
T23501     EXEC SQL                                                             
T23501        INCLUDE TBACCT                                                    
T23501     END-EXEC.                                                            
      *                                                                         
C30169******************************************************************        
C30169* CSS_FIN_WO_COLLECT.                                            *        
C30169******************************************************************        
C30169     EXEC SQL                                                             
C30169        INCLUDE TBFWCLAG                                                  
C30169     END-EXEC.                                                            
      *                                                                         
C30169******************************************************************        
C30169* CSS_FIN_WO_ACTION.                                             *        
C30169******************************************************************        
C30169     EXEC SQL                                                             
C30169        INCLUDE TBFWACTN                                                  
C30169     END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
                                                                        
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CWSX0010                                                 
REARCH     END-EXEC.                                                            
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
      *                                                                         
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  MISCELLANEOUS-WS-FIELDS.                                     
REARCH     05  PROGRAM-NAME            PIC X(08) VALUE 'CSR02310'.      
           05  WS-INSERT               PIC X(01) VALUE 'I'.             
           05  WS-DELETE               PIC X(01) VALUE 'D'.             
           05  WS-DAY-COLLECTION       PIC X(14) VALUE 'DAY-COLLECTION'.
           05  WS-DAY-CREDIT           PIC X(10) VALUE 'DAY-CREDIT'.    
T21624     05  WS-DAY-ADD-COLL-CB      PIC X(15)                        
T21624                                 VALUE 'DAY-ADD-COLL-CB'.         
           05  WS-1                    PIC S9(04) USAGE COMP VALUE 1.   
           05  WS-5                    PIC S9(04) USAGE COMP VALUE 5.   
           05  WS-9                    PIC S9(04) USAGE COMP VALUE 9.   
           05  WS-10                   PIC S9(04) USAGE COMP VALUE 10.  
           05  WS-15                   PIC S9(04) USAGE COMP VALUE 15.  
T21624     05  WS-EXISTS-FL            PIC X(01) VALUE ' '.             
T21624     05  WS-DAY                  PIC S9(04) COMP VALUE 0.         
T21624     05  WS-DAY-COLLEC-NO-DAYS   PIC S9(4)V9(5) COMP-3 VALUE 0.   
T21624     05  WS-GOOD-COUNT           PIC S9(3) VALUE 0.               
T21624     05  WS-GOOD-WORKING-DAY     PIC X(01) VALUE 'N'.             
T21624     05  WS-YES                  PIC X(01) VALUE 'Y'.             
T21624     05  WS-01                   PIC X(02) VALUE '01'.            
           05  WS-WORK-DATE            PIC X(10) VALUE SPACES.          
           05  WS-MN-TRANS-HIST-TS     PIC X(26).                       
           05  WS-MN-TRANS-HIST-DT     PIC X(10).                       
           05  WS-PYMNT-START-DATE     PIC X(15)                        
                                       VALUE 'PYMT START DATE'.         
           05  WS-DELETED-WORD         PIC X(09) VALUE '*DELETED*'.     
           05  WS-NEW-WORD             PIC X(05) VALUE '*NEW*'.         
           05  WS-UPDATE-WORD          PIC X(09) VALUE '*UPDATED*'.     
           05  WS-FINL-INSTLLMNT-AMT   PIC X(15)                        
                                       VALUE 'FINAL INST AMNT'.         
           05  WS-MTH-INSTLLMNT-AMT    PIC X(15)                        
                                       VALUE 'MONTH INST AMNT'.         
           05  WS-FRCST-COLL-AGY-DT    PIC X(15)                        
                                       VALUE 'FCST COL AGY DT'.         
           05  WS-ACCOUNT-NO-TEXT      PIC X(10) VALUE 'ACCOUNT NO'.    
           05  WS-WO-TOT-ARRGMT-AMT-T  PIC X(15)                        
                                       VALUE 'ARRANGEMENT AMT'.         
           05  WS-COLLECTION-DT-TEXT   PIC X(15)                        
                                       VALUE 'COLLECTION DATE'.         
           05  WS-CR-BUR-RPT-DT-TEXT   PIC X(15)                        
                                       VALUE 'CRD BUR RPT DT '.         
           05  WS-SECOND-CR-LTR-DT-TXT PIC X(15)                        
                                       VALUE 'SCND CRD LTR DT'.         
           05  WS-WO-MAX-BALANCE       PIC X(15)                        
                                       VALUE 'WO MAX BALANCE '.         
           05  WS-MNT-TRANS-TYPE       PIC X(03) VALUE 'F'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-NULL-TEXT            PIC X(04) VALUE 'NULL'.          
           05  WS-NULL-INDICATOR       PIC S9(04) COMP VALUE -1.        
           05  WS-FRCST-COLAGY-DT-NULL PIC S9(04) COMP VALUE -1.        
           05  WS-NO-RECORDS-FOUND     PIC S9(04) COMP VALUE 100.       
T30169     05  WS-KD-FW-ACTION-DT-NULL PIC S9(04) COMP VALUE 0.         
T30169     05  WS-IZ-WITHDRAW-DT-NULL  PIC S9(04) COMP VALUE 0.         
T30169     05  WS-FW-ATTR-VALUE-DESC   PIC X(75) VALUE SPACE.           
T30169     05  WS-FW-ATTRIB-TYPE-CD    PIC X(02) VALUE SPACE.           
T30169     05  WS-FW-ATTR-VALUE-CD     PIC X(05) VALUE SPACE.           
T30169     05  WS-WRITEOFF-DT          PIC X(10) VALUE SPACE.           
T30169     05  WS-COLLECTION-DT        PIC X(10) VALUE SPACE.           
           05  NULL-DATE               PIC X(10).                       
           05  WS-OLD-DATE-FORMAT.                                      
               10 WS-OLD-CCYY          PIC X(04).                       
               10 FILLER               PIC X(01).                       
               10 WS-OLD-MM            PIC X(02).                       
               10 FILLER               PIC X(01).                       
               10 WS-OLD-DD            PIC X(02).                       
           05  WS-NEW-DATE-FORMAT.                                      
               10 WS-NEW-MM            PIC X(02).                       
               10 FILLER               PIC X(01) VALUE '/'.             
               10 WS-NEW-DD            PIC X(02).                       
               10 FILLER               PIC X(01) VALUE '/'.             
               10 WS-NEW-CCYY          PIC X(04).                       
                                                                        
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
REARCH 01 GTT-RETURN-FIELDS.                                            
REARCH    05  S-RETURN-CODE            PIC S9(09) USAGE COMP            
REARCH                                                  VALUE 0.        
                                                                        
      ***************************************************************           
      *    WORKING STORAGE AREA FOR REDEFINING PARAMETERS PASSED    *           
      *    IN FROM THE DESKTOP ENVIRONMENT.                         *           
      ***************************************************************           
       01  WS-ACCOUNT-NO-REDEFINITION.                                  
           05  WS-ACCOUNT              PIC X(13).                       
           05  WS-ACCOUNT-DEC REDEFINES WS-ACCOUNT                      
                                       PIC 9(13).                       
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.        
                                                                        
       01  WS-MN-INSTLT-AMT-REDEFINITION.                               
           05  WS-MN-INSTLT-AMT        PIC X(11).                       
           05  WS-MN-INSTLT-AMT-N REDEFINES WS-MN-INSTLT-AMT            
                                       PIC 9(09)V99.                    
COB305     05 WS-MN-INSTLT-AMT-D        PIC S9(09)V99 USAGE COMP-3 
COB305       VALUE 0.      
                                                                        
       01  WS-FN-INSTLT-AMT-REDEFINITION.                               
           05  WS-FN-INSTLT-AMT        PIC X(11).                       
           05  WS-FN-INSTLT-AMT-N REDEFINES WS-FN-INSTLT-AMT            
                                       PIC 9(09)V99.                    
COB305     05 WS-FN-INSTLT-AMT-D        PIC S9(09)V99 USAGE COMP-3 
COB305       VALUE 0.      
                                                                        
COB305 01 WS-WO-MAX-BALANCE-D        PIC S9(09)V99 USAGE COMP-3 VALUE 0.      
                                                                        
       01  WS-WO-TOT-ARRGMT-REDEFINITION.                               
           05  WS-WO-TOT-ARRGMT-AMT    PIC X(11).                       
           05  WS-WO-TOT-ARRGMT-AMT-N  REDEFINES WS-WO-TOT-ARRGMT-AMT   
                                       PIC 9(09)V99.                    
COB305     05 WS-WO-TOT-ARRGMT-AMT-D        PIC S9(09)V99 USAGE COMP-3 
COB305       VALUE 0.      
                                                                        
       01  WS-FINL-INSTLMNT-AMT-REDEFINES.                              
           05 WS-DOLLAR-AMT-N         PIC S9(09)V99.                    
           05 WS-DOLLAR-AMT-T         PIC $$$$,$$$,$$9.99.              
                                                                        
       01  WS-TRANS-COMMENT-LEN-REDEFINES.                              
           05 WS-TRANS-COMMENT-LEN    PIC 9(04).                        
                                                                        
       01  WS-FRCS-CL-AG-DT-REDEFINITION.                               
           05  WS-FRCST-COLL-AGY-DT-2  PIC X(10).                       
           05  WS-FRCST-CREDB-DT       PIC X(10).                       
           05  WS-FRCST-COLL-AG-DT.                                     
               10 WS-FRCST-COLL-AG-YY  PIC X(04).                       
               10 FILLER               PIC X(01) VALUE '-'.             
               10 WS-FRCST-COLL-AG-MM  PIC X(02).                       
               10 FILLER               PIC X(01) VALUE '-'.             
               10 WS-FRCST-COLL-AG-DD  PIC X(02).                       
                                                                        
       01  WS-PYMT-START-DT-REDEFINITION.                               
           05  WS-PYMNT-START-DATE-2   PIC X(10).                       
           05  WS-PYMT-START-DT.                                        
               10 WS-PYMT-START-DT-YY  PIC X(04).                       
               10 FILLER               PIC X(01) VALUE '-'.             
               10 WS-PYMT-START-DT-MM  PIC X(02).                       
               10 FILLER               PIC X(01) VALUE '-'.             
               10 WS-PYMT-START-DT-DD  PIC X(02).                       
                                                                        
       01  WS-DELINQUENCY-VALUES.                                       
COB305     05 WS-DELIN-COLL        PIC S9(4)V9(5) USAGE COMP-3 VALUE 0.     
COB305     05 WS-DELIN-CREDIT        PIC S9(4)V9(5) USAGE COMP-3 
COB305       VALUE 0.     
COB305     05 WS-DELIN-ADD-COLL-CB        PIC S9(4)V9(5) USAGE COMP-3 
COB305       VALUE 0.     
                                                                        
       01  WS-NEW-WRITE-OFF-DATES.                                      
           05 WS-NEW-COLLECTION-DATE   PIC X(10).                       
           05 WS-NEW-CREDIT-DATE       PIC X(10).                       
           05 WS-OLD-COLLECTION-DT     PIC X(10).                       
           05 WS-OLD-CREDIT-B-DT         PIC X(10).                     
                                                                        
REARCH  01 CSRERLOG-P.                                                  
REARCH      10 S-SP-NAME           PIC X(18) VALUE SPACES.              
REARCH      10 S-SQLCODE           PIC S9(9) COMP VALUE 0.              
REARCH      10 S-SQLSTATE          PIC X(5)  VALUE ' '.                 
REARCH      10 S-TABLE-NAME        PIC X(18) VALUE SPACES.              
REARCH      10 S-HOST-VAIABLES.                                         
REARCH         49 S-HOST-VARIABLES-L PIC S9(4) USAGE COMP.              
REARCH         49 S-HOST-VARIABLES-V PIC X(255).                        
REARCH      10 S-SQL-STATEMENT.                                         
REARCH         49 S-SQL-STATEMENT-L  PIC S9(4) USAGE COMP.              
REARCH         49 S-SQL-STATEMENT-V  PIC X(255).                        
REARCH      10 S-SQL-DESCRIPTION.                                       
REARCH         49 S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.             
REARCH         49 S-SQL-DESCRIPTION-V PIC X(255).                       
                                                                        
C30169 01  WS-MISC.                                                     
C30169     05  WS-RETURN-CODE-4074        PIC S9(9) COMP VALUE 0.       
C30169     05  WS-ACTION-TYPE-UPDT        PIC X(05) VALUE SPACES.       
C30169     05  WS-ACTION-DT-UPDT          PIC X(10) VALUE SPACES.       
C30169     05  WS-SEQ-NO-UPDT             PIC S9(4) COMP VALUE 0.       
C30169     05  WS-ACTION-TYPE             PIC X(05) VALUE SPACES.       
C30169     05  WS-NEW-ACTION-DT           PIC X(10) VALUE SPACES.       
C30169     05  WS-ORIG-ACTION-DT           PIC X(10) VALUE SPACES.      
C30169     05  WS-OLD-ACTION-DT           PIC X(10) VALUE SPACES.       
C30169     05  WS-SEQ-NO                  PIC S9(4) COMP VALUE 0.       
C30169     05  WS-CSR04074-ACTION-TYPE-CD PIC X(05) VALUE SPACES.       
C30169     05  WS-CSR04074-SEQ-NO         PIC S9(4) COMP VALUE 0.       
C30169     05  WS-CSR04074-ACTION-DT      PIC X(10) VALUE SPACES.       
C30169     05  WS-TRAN-APPL-NO            PIC S9(02) VALUE 0.           
C30169     05  WS-COLUMN-DESC             PIC X(14)  VALUE '****'.      
C30169     05  WS-CHG-COLUMN-VALUE-TEXT   PIC X(10)  VALUE '**********'.
C30169     05  WS-CHG-COLUMN-VALUE-LEN    PIC S9(02) VALUE +10.         
C30169     05  WS-PRV-COLUMN-VALUE-TEXT   PIC X(10)  VALUE '**********'.
C30169     05  WS-PRV-COLUMN-VALUE-LEN    PIC S9(02) VALUE +10.         
C30169     05  WS-USER-ID                 PIC X(07)  VALUE SPACES.      
                                                                        
C30169*01  LOC-RESLTSET          USAGE IS SQL TYPE IS                   
C30169*                          RESULT-SET-LOCATOR VARYING.            
MSQ001        EXEC SQL
MSQ001          DECLARE FORECAST_DT_CUR CURSOR
MSQ001          FOR CALL CSR04074( :WS-ACCOUNT
                  , :WS-ACTION-TYPE
                  , :WS-SEQ-NO
                  , :WS-ORIG-ACTION-DT
                  , :WS-NEW-ACTION-DT
                  , :AT-COMPANY-NO
                  )
MSQ001        END-EXEC.
            
                                                                        
                                                                        
REARCH LINKAGE SECTION.                                                 
REARCH 01 PARM-ACTION-CODE         PIC X(01).                           
REARCH 01 PARM-ACCOUNT-NO          PIC X(13).                           
REARCH 01 PARM-FORCST-COLL-AG-DT   PIC X(10).                           
REARCH 01 PARM-PAYMENT-START-DT    PIC X(10).                           
REARCH 01 PARM-MN-INSTALL-AMT      PIC X(11).                           
REARCH 01 PARM-FN-INSTALL-AMT      PIC X(11).                           
REARCH 01 PARM-WO-TOT-ARGMT-AMT    PIC X(11).                           
REARCH 01 PARM-COLLECTION-DATE     PIC X(01).                           
REARCH 01 PARM-USER-ID             PIC X(07).                           
REARCH 01 PARM-PROGRAM-ID          PIC X(09).                           
REARCH 01 PARM-RESP-AREA-ID        PIC X(03).                           
REARCH 01 PARM-TRANS-COMMENT-TEXT  PIC X(210).                          
REARCH 01 PARM-TRANS-COMMENT-LEN   PIC X(04).                           
C30169 01 PARM-ACTION-TYPE-CD      PIC X(05).                           
C30169 01 PARM-SEQ-NO              PIC S9(4) USAGE COMP.                
C30169 01 PARM-FRCST-CREDB-DT      PIC X(10).                           
REARCH PROCEDURE DIVISION USING PARM-ACTION-CODE                        
REARCH                          PARM-ACCOUNT-NO                         
REARCH                          PARM-FORCST-COLL-AG-DT                  
REARCH                          PARM-PAYMENT-START-DT                   
REARCH                          PARM-MN-INSTALL-AMT                     
REARCH                          PARM-FN-INSTALL-AMT                     
REARCH                          PARM-WO-TOT-ARGMT-AMT                   
REARCH                          PARM-COLLECTION-DATE                    
REARCH                          PARM-USER-ID                            
REARCH                          PARM-PROGRAM-ID                         
REARCH                          PARM-RESP-AREA-ID                       
REARCH                          PARM-TRANS-COMMENT-TEXT                 
REARCH                          PARM-TRANS-COMMENT-LEN                  
C30169                          PARM-ACTION-TYPE-CD                     
C30169                          PARM-SEQ-NO                             
C30169                          PARM-FRCST-CREDB-DT.                    
                                                                        
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARCH             :S-RETURN-CODE     AS RETURN_CODE                    
REARCH         FROM                                                     
REARCH             CIS.SYSDUMMY1                                     
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*            :S-RETURN-CODE     AS RETURN_CODE                            
MFA-TR*        FROM                                                             
MFA-TR*            SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC.                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1150-ASSIGN-WS-VARS    THRU 1150-EXIT.               
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 1150 ASSIGN-WS-VARS                                            *        
      *     -- THIS MODULE MOVES THE PASSED IN PARAMETER VALUES AND    *        
      *        MOVES THEM INTO WORKING STORAGE VARIABLES.  THEN,       *        
      *        THESE WORKING STORAGE VARIABLES ARE MOVED INTO THEIR    *        
      *        RESPECTIVE REDEFINED FIELDS FOR COMPLETING THE          *        
      *        PROCESSING WITHIN THIS PROGRAM.                         *        
      ******************************************************************        
       1150-ASSIGN-WS-VARS.                                             
                                                                        
           MOVE PARM-ACCOUNT-NO       TO WS-ACCOUNT.                    
           MOVE WS-ACCOUNT-DEC        TO WS-ACCOUNT-NO.                 
           MOVE WS-ACCOUNT-DEC        TO WG-ACCOUNT-NO.                 
                                                                        
           MOVE PARM-MN-INSTALL-AMT   TO WS-MN-INSTLT-AMT.              
           MOVE WS-MN-INSTLT-AMT-N    TO WS-MN-INSTLT-AMT-D.            
                                                                        
           MOVE PARM-FN-INSTALL-AMT   TO WS-FN-INSTLT-AMT.              
           MOVE WS-FN-INSTLT-AMT-N    TO WS-FN-INSTLT-AMT-D.            
                                                                        
           MOVE PARM-WO-TOT-ARGMT-AMT TO WS-WO-TOT-ARRGMT-AMT.          
           MOVE WS-WO-TOT-ARRGMT-AMT-N TO WS-WO-TOT-ARRGMT-AMT-D.       
           MOVE PARM-TRANS-COMMENT-LEN TO WS-TRANS-COMMENT-LEN          
                                                                        
           IF PARM-FORCST-COLL-AG-DT = SPACES                           
              MOVE SPACES             TO WS-FRCST-COLL-AG-DT            
              MOVE -1                 TO WS-FRCST-COLAGY-DT-NULL        
           ELSE                                                         
              MOVE PARM-FORCST-COLL-AG-DT(7:4)                          
                                      TO WS-FRCST-COLL-AG-YY            
              MOVE PARM-FORCST-COLL-AG-DT(1:2)                          
                                      TO WS-FRCST-COLL-AG-MM            
              MOVE PARM-FORCST-COLL-AG-DT(4:2)                          
                                      TO WS-FRCST-COLL-AG-DD            
              MOVE ZERO               TO WS-FRCST-COLAGY-DT-NULL        
           END-IF                                                       
           MOVE WS-FRCST-COLL-AG-DT   TO WS-FRCST-COLL-AGY-DT-2         
C30169                                   WS-NEW-ACTION-DT.              
C30169     IF PARM-FRCST-CREDB-DT = SPACES                              
C30169        MOVE SPACES             TO WS-FRCST-CREDB-DT              
C30169     ELSE                                                         
C30169        MOVE PARM-FRCST-CREDB-DT TO WS-FRCST-CREDB-DT             
C30169     END-IF                                                       
                                                                        
           MOVE PARM-PAYMENT-START-DT(7:4)                              
                                      TO WS-PYMT-START-DT-YY.           
           MOVE PARM-PAYMENT-START-DT(1:2)                              
                                      TO WS-PYMT-START-DT-MM.           
           MOVE PARM-PAYMENT-START-DT(4:2)                              
                                      TO WS-PYMT-START-DT-DD.           
           MOVE WS-PYMT-START-DT      TO WS-PYMNT-START-DATE-2.         
                                                                        
T12269     SUBTRACT WS-MN-INSTLT-AMT-D FROM WS-WO-TOT-ARRGMT-AMT-D      
T12269        GIVING WS-WO-MAX-BALANCE-D.                               
C30169*                                                                         
C30169     MOVE PARM-SEQ-NO             TO WS-SEQ-NO.                   
C30169     MOVE PARM-ACTION-TYPE-CD     TO WS-ACTION-TYPE.              
C30169     MOVE PARM-USER-ID            TO WS-USER-ID.                  
                                                                        
       1150-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      *     1. DESCRIBE RESULT SET                                     *        
      *     2. CHECK ACTION CODE FOR THE TYPE OF PROCESS TO BE HANDLED:*        
      *     3. WRITE APPROPRIATE RECORDS                               *        
      *     4. SEND RESULT SET (ERROR MESSAGE, RETURN CODE)            *        
      *                                                                *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
                                                                        
T23501     PERFORM 7700-SELECT-COMPANY-NO THRU 7700-EXIT.               
                                                                        
           PERFORM 5600-FORMAT-MNT-TRAN-HIST THRU 5600-EXIT.            
           PERFORM 5000-UPDATE-TABLES                   THRU 5000-EXIT. 
                                                                        
REARCH     ADD+1                                        TO CTR-ROWS.    
                                                                        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
REARCH*                                                                         
      ******************************************************************        
      * 5000-UPDATE-TABLES.                                            *        
      *                                                                *        
      *     1. CHECK ACTION CODE FOR THE TYPE OF PROCESS TO BE HANDLED:*        
      *     2. WRITE APPROPRIATE RECORDS                               *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       5000-UPDATE-TABLES.                                              
                                                                        
           PERFORM 7000-SELECT-WO-ARRANGEMENT THRU 7000-EXIT.           
           IF PARM-ACTION-CODE = WS-INSERT THEN                         
              PERFORM 8000-INSERT-WO-ARRANGEMENT                        
                                            THRU 8000-EXIT              
              PERFORM 5100-INSERT-MNT-TRANS-HIST                        
                                            THRU 5100-EXIT              
C30169                                                                  
C30169        IF WS-ACTION-TYPE > SPACES                                
C30169           MOVE WS-SEQ-NO                TO KD-FW-SEQ-NO          
C30169           MOVE WS-ACTION-TYPE           TO KD-FW-ACTION-TYPE-CD  
C30169           PERFORM 7800-SELECT-ACTION-DT THRU 7800-EXIT           
C30169           MOVE KD-FW-ACTION-DT          TO WS-OLD-ACTION-DT      
C30169                                                                  
C30169           IF WS-OLD-ACTION-DT NOT = WS-NEW-ACTION-DT             
C30169              MOVE WS-OLD-ACTION-DT      TO WS-ORIG-ACTION-DT     
C30169              PERFORM 5025-UPDATE-PLMT-90503-DATE                 
C30169                                         THRU 5025-EXIT           
C30169              PERFORM 7010-CALL-CSR04074 THRU 7010-EXIT           
C30169           END-IF                                                 
C30169        END-IF                                                    
C30169        IF WS-FRCST-CREDB-DT > SPACES                             
C30169           PERFORM 5035-UPDATE-AXFR4-CREDB-DATE                   
C30169                                         THRU 5035-EXIT           
C30169        END-IF                                                    
           ELSE IF PARM-ACTION-CODE = WS-DELETE THEN                    
              PERFORM 8300-DELETE-WO-ARRANGEMENT    THRU 8300-EXIT      
              PERFORM 5200-DELETE-MNT-TRANS-HIST    THRU 5200-EXIT      
C30169*       PERFORM 5500-CALC-CRED-BUREAU-DT      THRU 5500-EXIT              
           ELSE                                                         
              PERFORM 8200-UPDATE-WO-ARRANGEMENT                        
                                            THRU 8200-EXIT              
              PERFORM 5300-UPDATE-MNT-TRANS-HIST                        
                                            THRU 5300-EXIT              
C30169        IF WS-ACTION-TYPE > SPACES                                
C30169           MOVE WS-SEQ-NO                TO KD-FW-SEQ-NO          
C30169           MOVE WS-ACTION-TYPE           TO KD-FW-ACTION-TYPE-CD  
C30169           PERFORM 7800-SELECT-ACTION-DT THRU 7800-EXIT           
C30169           MOVE KD-FW-ACTION-DT          TO WS-OLD-ACTION-DT      
                                                                        
C30169           IF WS-OLD-ACTION-DT NOT = WS-NEW-ACTION-DT             
C30169              MOVE WS-OLD-ACTION-DT      TO WS-ORIG-ACTION-DT     
                                                                        
C30169              PERFORM 5025-UPDATE-PLMT-90503-DATE                 
                                               THRU 5025-EXIT           
C30169              PERFORM 7010-CALL-CSR04074 THRU 7010-EXIT           
C30169           END-IF                                                 
C30169        END-IF                                                    
C30169        IF WS-FRCST-CREDB-DT > SPACES                             
C30169           PERFORM 5035-UPDATE-AXFR4-CREDB-DATE                   
C30169                                         THRU 5035-EXIT           
C30169        END-IF                                                    
           END-IF
           END-IF.                                                      
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
C30169******************************************************************        
C30169* 5025-UPDATE-PLMT-90503-DATE.                                   *        
C30169******************************************************************        
C30169*                                                                         
C30169 5025-UPDATE-PLMT-90503-DATE.                                     
C30169                                                                  
C30169     IF WS-ACTION-TYPE = '1PLMT'                                  
C30169********UPDATE FIRST CREDIT LETTER ACTION DATE***********                 
             MOVE '90503'                     TO KD-FW-ACTION-TYPE-CD   
             PERFORM 7810-SELECT-FIN-WO-ACTION-DT                       
                                            THRU 7810-EXIT              
             IF KD-FW-ACTION-AM = 0                                     
                MOVE KD-FW-ACTION-DT             TO WS-OLD-ACTION-DT    
                IF WS-OLD-ACTION-DT NOT = WS-NEW-ACTION-DT AND          
                   WS-OLD-ACTION-DT > SPACES                            
                   MOVE '90503'                  TO WS-ACTION-TYPE-UPDT 
                   MOVE WS-NEW-ACTION-DT         TO WS-ACTION-DT-UPDT   
                   MOVE KD-FW-SEQ-NO             TO WS-SEQ-NO-UPDT      
                   PERFORM 5050-UPDATE-ACTION-DATE                      
                                              THRU 5050-EXIT            
                END-IF                                                  
             END-IF                                                     
C30169********UPDATE 3RD AUTO TRANSFER  ACTION DATE***********                  
             MOVE 'AXFR3'                     TO KD-FW-ACTION-TYPE-CD   
             PERFORM 7810-SELECT-FIN-WO-ACTION-DT                       
                                              THRU 7810-EXIT            
             IF KD-FW-ACTION-AM = 0                                     
                MOVE KD-FW-ACTION-DT          TO WS-OLD-ACTION-DT       
                IF WS-OLD-ACTION-DT NOT = WS-NEW-ACTION-DT AND          
                   WS-OLD-ACTION-DT > SPACES                            
                   MOVE 'AXFR3'                  TO WS-ACTION-TYPE-UPDT 
                   MOVE WS-NEW-ACTION-DT         TO WS-ACTION-DT-UPDT   
                   MOVE KD-FW-SEQ-NO             TO WS-SEQ-NO-UPDT      
                   PERFORM 5050-UPDATE-ACTION-DATE                      
                                              THRU 5050-EXIT            
                END-IF                                                  
             END-IF                                                     
           END-IF.                                                      
C30169********UPDATE COLLECTION AGENCY ACTION DATE***********                   
           MOVE WS-ACTION-TYPE              TO WS-ACTION-TYPE-UPDT.     
           MOVE WS-NEW-ACTION-DT            TO WS-ACTION-DT-UPDT.       
           MOVE WS-SEQ-NO                   TO WS-SEQ-NO-UPDT.          
           PERFORM 5050-UPDATE-ACTION-DATE  THRU 5050-EXIT.             
C30169                                                                  
C30169 5025-EXIT.                                                       
C30169      EXIT.                                                       
C30169*                                                                         
C30169******************************************************************        
C30169* 5035-UPDATE-AXFR4-CREDB-DATE.                                  *        
C30169******************************************************************        
C30169*                                                                         
C30169 5035-UPDATE-AXFR4-CREDB-DATE.                                    
C30169********UPDATE 4TH AUTO TRANSFER ACTION DATE***********                   
           MOVE 'AXFR4'                     TO KD-FW-ACTION-TYPE-CD.    
           PERFORM 7810-SELECT-FIN-WO-ACTION-DT                         
                                            THRU 7810-EXIT.             
           IF KD-FW-ACTION-AM = 0                                       
              MOVE KD-FW-ACTION-DT             TO WS-OLD-ACTION-DT      
              IF WS-OLD-ACTION-DT NOT = WS-FRCST-CREDB-DT AND           
                 WS-OLD-ACTION-DT > SPACES                              
                 MOVE 'AXFR4'                  TO WS-ACTION-TYPE-UPDT   
                 MOVE WS-FRCST-CREDB-DT        TO WS-ACTION-DT-UPDT     
                 MOVE KD-FW-SEQ-NO             TO WS-SEQ-NO-UPDT        
                 PERFORM 5050-UPDATE-ACTION-DATE                        
                                            THRU 5050-EXIT              
              END-IF                                                    
           END-IF.                                                      
C30169********UPDATE CREDIT BUREAU ACTION DATE***********                       
           MOVE 'CREDB'                     TO KD-FW-ACTION-TYPE-CD.    
           PERFORM 7810-SELECT-FIN-WO-ACTION-DT                         
                                            THRU 7810-EXIT.             
           IF KD-FW-ACTION-AM = 0                                       
              MOVE KD-FW-ACTION-DT          TO WS-OLD-ACTION-DT         
              IF WS-OLD-ACTION-DT NOT = WS-FRCST-CREDB-DT AND           
                 WS-OLD-ACTION-DT > SPACES                              
                 MOVE 'CREDB'                  TO WS-ACTION-TYPE-UPDT   
                 MOVE WS-FRCST-CREDB-DT        TO WS-ACTION-DT-UPDT     
                 MOVE KD-FW-SEQ-NO             TO WS-SEQ-NO-UPDT        
                 PERFORM 5050-UPDATE-ACTION-DATE                        
                                            THRU 5050-EXIT              
              END-IF                                                    
           END-IF.                                                      
                                                                        
C30169 5035-EXIT.                                                       
C30169      EXIT.                                                       
C30169*                                                                         
C30169******************************************************************        
C30169* 5050-UPDATE-ACTION-DATE.                                       *        
C30169******************************************************************        
C30169*                                                                         
C30169 5050-UPDATE-ACTION-DATE.                                         
                                                                        
            EVALUATE WS-ACTION-TYPE-UPDT                                
            WHEN '1PLWD'                                                
               MOVE '1PLMT'            TO KD-FW-ACTION-TYPE-CD          
            WHEN '2PLWD'                                                
               MOVE '2PLMT'            TO KD-FW-ACTION-TYPE-CD          
            WHEN '3PLWD'                                                
               MOVE '3PLMT'            TO KD-FW-ACTION-TYPE-CD          
            WHEN OTHER                                                  
               MOVE WS-ACTION-TYPE-UPDT TO KD-FW-ACTION-TYPE-CD         
            END-EVALUATE.                                               
            MOVE WS-SEQ-NO-UPDT        TO KD-FW-SEQ-NO                  
                                                                        
            PERFORM 7800-SELECT-ACTION-DT      THRU 7800-EXIT.          
                                                                        
            IF WS-ACTION-TYPE-UPDT = '1PLWD' OR '2PLWD' OR '3PLWD'      
               MOVE IZ-WITHDRAW-DT           TO KD-FW-ACTION-DT         
            END-IF.                                                     
                                                                        
            IF KD-FW-ACTION-DT NOT = WS-ACTION-DT-UPDT                  
               ADD  +1                       TO MI-TRAN-APPL-NO         
               MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO    
               MOVE 'AT'                     TO WS-FW-ATTRIB-TYPE-CD    
               MOVE WS-ACTION-TYPE-UPDT      TO WS-FW-ATTR-VALUE-CD     
               PERFORM 7820-SELECT-ACTION-DESC                          
                                             THRU 7820-EXIT             
                                                                        
               MOVE 'ACTION TYPE'            TO MI-COLUMN-DESC          
               MOVE WS-FW-ATTR-VALUE-DESC    TO MI-PRV-COLUMN-VALUE-TEXT
               MOVE LENGTH OF WS-FW-ATTR-VALUE-DESC                     
                                             TO MI-PRV-COLUMN-VALUE-LEN 
               MOVE WS-UPDATE-WORD           TO MI-CHG-COLUMN-VALUE-TEXT
               MOVE +9                       TO MI-CHG-COLUMN-VALUE-LEN 
                                                                        
               PERFORM 6530-LOAD-MNT-TRANS-HIST                         
                                             THRU 6530-EXIT             
                                                                        
               ADD  +1                       TO MI-TRAN-APPL-NO         
               IF WS-ACTION-TYPE-UPDT = '1PLWD' OR '2PLWD' OR '3PLWD'   
                  MOVE 'WITHDRAW DATE'       TO MI-COLUMN-DESC          
               ELSE                                                     
                  MOVE 'ACTION DATE'         TO MI-COLUMN-DESC          
               END-IF                                                   
               MOVE KD-FW-ACTION-DT          TO WS-OLD-DATE-FORMAT      
               PERFORM 5700-FORMAT-DATE      THRU 5700-EXIT             
               MOVE WS-NEW-DATE-FORMAT       TO MI-PRV-COLUMN-VALUE-TEXT
                                                                        
               MOVE WS-ACTION-DT-UPDT        TO WS-OLD-DATE-FORMAT      
               PERFORM 5700-FORMAT-DATE      THRU 5700-EXIT             
               MOVE WS-NEW-DATE-FORMAT       TO MI-CHG-COLUMN-VALUE-TEXT
                                                                        
               MOVE +10                      TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
                                                                        
               PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT          
                                                                        
               IF WS-ACTION-TYPE-UPDT = '1PLWD' OR '2PLWD' OR '3PLWD'   
                  MOVE KD-FW-ACTION-TYPE-CD  TO IZ-FW-ACTION-TYPE-CD    
                  MOVE WS-SEQ-NO-UPDT        TO IZ-FW-COLL-SEQ-NO       
                  MOVE WS-ACTION-DT-UPDT     TO IZ-WITHDRAW-DT          
                  PERFORM 8500-UPD-FINAL-COLLECTION THRU 8500-EXIT      
               ELSE                                                     
                  MOVE WS-SEQ-NO-UPDT        TO KD-FW-SEQ-NO            
                  MOVE WS-ACTION-DT-UPDT     TO KD-FW-ACTION-DT         
                  PERFORM 8410-UPD-FINAL-ACTION     THRU 8410-EXIT      
               END-IF
            END-IF.                                                  
                                                                        
C30169 5050-EXIT.                                                       
C30169      EXIT.                                                       
C30169*                                                                         
      *                                                                         
T21624*************************************************************             
      *                                                                         
      *  5080-GET-WORKING-DAYS                                                  
      *                                                                         
      *  THIS PARAGRAPH GETS THE NEXT CURRENT DAY FROM THE NUMBER               
      *  OF DAYS SENT DOWN.                                                     
      *                                                                         
      * RETURNS WS-WORK-DATE                                                    
      *                                                                         
      *************************************************************             
      *                                                                         
       5080-GET-WORKING-DAYS.                                           
      *                                                                         
           MOVE 0                       TO WS-GOOD-COUNT.               
           MOVE WS-NO                   TO WS-GOOD-WORKING-DAY.         
           PERFORM UNTIL (WS-GOOD-WORKING-DAY = WS-YES)                 
                   AND (WS-GOOD-COUNT = WS-DAY-COLLEC-NO-DAYS)          
              PERFORM 7640-GET-NEXT-BUS-DAY       THRU 7640-EXIT        
              IF WS-DAY > 0                                             
                    AND WS-DAY < 6                                      
                 PERFORM 7620-SELECT-HOLIDAY      THRU 7620-EXIT        
                 IF WS-EXISTS-FL NOT EQUAL 'Y'                          
                    MOVE WS-YES          TO WS-GOOD-WORKING-DAY         
                    ADD 1                TO WS-GOOD-COUNT               
                 END-IF                                                 
              END-IF                                                    
           END-PERFORM.                                                 
      *                                                                         
       5080-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
                                                                        
      ******************************************************************        
      * 5100-INSERT-MNT-TRANS-HIST                                     *        
      *                                                                *        
      *     INSERT A RECORD INTO TABLE CSS_MNT_TRANS_HIST FOR EACH     *        
      *     FIELD INSERTED INTO TABLE CSS_WO_ARRANGEMENT.              *        
      *                                                                *        
      ******************************************************************        
       5100-INSERT-MNT-TRANS-HIST.                                      
                                                                        
           MOVE WS-NEW-WORD            TO MI-PRV-COLUMN-VALUE-TEXT.     
           MOVE WS-5                   TO MI-PRV-COLUMN-VALUE-LEN.      
                                                                        
           MOVE WS-PYMNT-START-DATE    TO MI-COLUMN-DESC.               
           MOVE 1                      TO MI-TRAN-APPL-NO.              
           MOVE WS-PYMNT-START-DATE-2  TO WS-OLD-DATE-FORMAT.           
           PERFORM 5700-FORMAT-DATE    THRU 5700-EXIT.                  
           MOVE WS-NEW-DATE-FORMAT     TO MI-CHG-COLUMN-VALUE-TEXT.     
           MOVE WS-10                  TO MI-CHG-COLUMN-VALUE-LEN.      
           PERFORM 6530-LOAD-MNT-TRANS-HIST   THRU 6530-EXIT.           
                                                                        
           MOVE WS-FINL-INSTLLMNT-AMT  TO MI-COLUMN-DESC.               
           ADD 1                       TO MI-TRAN-APPL-NO.              
           MOVE WS-FN-INSTLT-AMT-D     TO WS-DOLLAR-AMT-N.              
           MOVE WS-DOLLAR-AMT-N        TO WS-DOLLAR-AMT-T.              
           MOVE WS-DOLLAR-AMT-T        TO MI-CHG-COLUMN-VALUE-TEXT.     
           MOVE WS-15                  TO MI-CHG-COLUMN-VALUE-LEN.      
           PERFORM 6530-LOAD-MNT-TRANS-HIST   THRU 6530-EXIT.           
                                                                        
           MOVE WS-MTH-INSTLLMNT-AMT   TO MI-COLUMN-DESC.               
           ADD 1                       TO MI-TRAN-APPL-NO.              
           MOVE WS-MN-INSTLT-AMT-D     TO WS-DOLLAR-AMT-N.              
           MOVE WS-DOLLAR-AMT-N        TO WS-DOLLAR-AMT-T.              
           MOVE WS-DOLLAR-AMT-T        TO MI-CHG-COLUMN-VALUE-TEXT.     
           MOVE WS-15                  TO MI-CHG-COLUMN-VALUE-LEN.      
           PERFORM 6530-LOAD-MNT-TRANS-HIST   THRU 6530-EXIT.           
                                                                        
           MOVE WS-WO-TOT-ARRGMT-AMT-T TO MI-COLUMN-DESC.               
           ADD 1                       TO MI-TRAN-APPL-NO.              
           MOVE WS-WO-TOT-ARRGMT-AMT-D TO WS-DOLLAR-AMT-N.              
           MOVE WS-DOLLAR-AMT-N        TO WS-DOLLAR-AMT-T.              
           MOVE WS-DOLLAR-AMT-T        TO MI-CHG-COLUMN-VALUE-TEXT.     
           MOVE WS-15                  TO MI-CHG-COLUMN-VALUE-LEN.      
           PERFORM 6530-LOAD-MNT-TRANS-HIST   THRU 6530-EXIT.           
                                                                        
T30169     IF WS-FRCST-COLL-AGY-DT-2 > SPACES                           
            MOVE WS-FRCST-COLL-AGY-DT   TO MI-COLUMN-DESC               
            ADD 1                       TO MI-TRAN-APPL-NO              
            MOVE WS-FRCST-COLL-AGY-DT-2 TO WS-OLD-DATE-FORMAT           
            PERFORM 5700-FORMAT-DATE    THRU 5700-EXIT                  
            MOVE WS-NEW-DATE-FORMAT     TO MI-CHG-COLUMN-VALUE-TEXT     
            MOVE WS-10                  TO MI-CHG-COLUMN-VALUE-LEN      
            PERFORM 6530-LOAD-MNT-TRANS-HIST   THRU 6530-EXIT           
T30169     END-IF.                                                      
      *    MOVE WS-WO-MAX-BALANCE      TO MI-COLUMN-DESC.                       
      *    ADD 1                       TO MI-TRAN-APPL-NO.                      
      *    MOVE WS-WO-MAX-BALANCE-D    TO WS-DOLLAR-AMT-N.                      
      *    MOVE WS-DOLLAR-AMT-N        TO WS-DOLLAR-AMT-T.                      
      *    MOVE WS-DOLLAR-AMT-T        TO MI-CHG-COLUMN-VALUE-TEXT.             
      *    MOVE WS-15                  TO MI-CHG-COLUMN-VALUE-LEN.              
      *    PERFORM 6530-LOAD-MNT-TRANS-HIST   THRU 6530-EXIT.                   
                                                                        
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 5200-DELETE-MNT-TRANS-HIST                                     *        
      *                                                                *        
      *     INSERT A RECORD INTO TABLE CSS_MNT_TRANS_HIST FOR EACH     *        
      *     FIELD INSERTED INTO TABLE CSS_WO_ARRANGEMENT.              *        
      *                                                                *        
      ******************************************************************        
       5200-DELETE-MNT-TRANS-HIST.                                      
                                                                        
           MOVE WS-DELETED-WORD        TO MI-CHG-COLUMN-VALUE-TEXT.     
           MOVE WS-9                   TO MI-CHG-COLUMN-VALUE-LEN.      
                                                                        
           MOVE WS-PYMNT-START-DATE    TO MI-COLUMN-DESC.               
           MOVE 1                      TO MI-TRAN-APPL-NO.              
           MOVE WG-PYMNT-START-DATE    TO WS-OLD-DATE-FORMAT.           
           PERFORM 5700-FORMAT-DATE    THRU 5700-EXIT.                  
           MOVE WS-NEW-DATE-FORMAT     TO MI-PRV-COLUMN-VALUE-TEXT.     
           MOVE WS-10                  TO MI-PRV-COLUMN-VALUE-LEN.      
           PERFORM 6530-LOAD-MNT-TRANS-HIST   THRU 6530-EXIT.           
                                                                        
           MOVE WS-FINL-INSTLLMNT-AMT  TO MI-COLUMN-DESC.               
           ADD 1                       TO MI-TRAN-APPL-NO.              
           MOVE WG-FINL-INSTLLMNT-AMT  TO WS-DOLLAR-AMT-N.              
           MOVE WS-DOLLAR-AMT-N        TO WS-DOLLAR-AMT-T.              
           MOVE WS-DOLLAR-AMT-T        TO MI-PRV-COLUMN-VALUE-TEXT.     
           MOVE WS-15                  TO MI-PRV-COLUMN-VALUE-LEN.      
           PERFORM 6530-LOAD-MNT-TRANS-HIST   THRU 6530-EXIT.           
                                                                        
           MOVE WS-MTH-INSTLLMNT-AMT   TO MI-COLUMN-DESC.               
           ADD 1                       TO MI-TRAN-APPL-NO.              
           MOVE WG-MTH-INSTLLMNT-AMT   TO WS-DOLLAR-AMT-N.              
           MOVE WS-DOLLAR-AMT-N        TO WS-DOLLAR-AMT-T.              
           MOVE WS-DOLLAR-AMT-T        TO MI-PRV-COLUMN-VALUE-TEXT.     
           MOVE WS-15                  TO MI-PRV-COLUMN-VALUE-LEN.      
           PERFORM 6530-LOAD-MNT-TRANS-HIST   THRU 6530-EXIT.           
                                                                        
           MOVE WS-WO-TOT-ARRGMT-AMT-T TO MI-COLUMN-DESC.               
           ADD 1                       TO MI-TRAN-APPL-NO.              
           MOVE WG-WO-TOT-ARRGMT-AMT   TO WS-DOLLAR-AMT-N.              
           MOVE WS-DOLLAR-AMT-N        TO WS-DOLLAR-AMT-T.              
           MOVE WS-DOLLAR-AMT-T        TO MI-PRV-COLUMN-VALUE-TEXT.     
           MOVE WS-15                  TO MI-PRV-COLUMN-VALUE-LEN.      
           PERFORM 6530-LOAD-MNT-TRANS-HIST   THRU 6530-EXIT.           
                                                                        
T30169     IF WG-FRCST-COLL-AGY-DT > SPACES                             
             MOVE WS-FRCST-COLL-AGY-DT   TO MI-COLUMN-DESC              
             ADD 1                       TO MI-TRAN-APPL-NO             
             MOVE WG-FRCST-COLL-AGY-DT   TO WS-OLD-DATE-FORMAT          
             PERFORM 5700-FORMAT-DATE    THRU 5700-EXIT                 
             MOVE WS-NEW-DATE-FORMAT     TO MI-PRV-COLUMN-VALUE-TEXT    
             MOVE WS-10                  TO MI-PRV-COLUMN-VALUE-LEN     
             PERFORM 6530-LOAD-MNT-TRANS-HIST   THRU 6530-EXIT          
T30169     END-IF.                                                      
                                                                        
      *    MOVE WS-WO-MAX-BALANCE      TO MI-COLUMN-DESC.                       
      *    ADD 1                       TO MI-TRAN-APPL-NO.                      
      *    MOVE WG-WO-MAX-BALANCE      TO WS-DOLLAR-AMT-N.                      
      *    MOVE WS-DOLLAR-AMT-N        TO WS-DOLLAR-AMT-T.                      
      *    MOVE WS-DOLLAR-AMT-T        TO MI-PRV-COLUMN-VALUE-TEXT.             
      *    MOVE WS-15                  TO MI-PRV-COLUMN-VALUE-LEN.              
      *    PERFORM 6530-LOAD-MNT-TRANS-HIST   THRU 6530-EXIT.                   
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 5300-UPDATE-MNT-TRANS-HIST                                     *        
      *                                                                *        
      *     INSERT A RECORD INTO TABLE CSS_MNT_TRANS_HIST FOR EACH     *        
      *     FIELD UPDATED IN TABLE CSS_WO_ARRANGEMENT.                 *        
      *                                                                *        
      ******************************************************************        
       5300-UPDATE-MNT-TRANS-HIST.                                      
                                                                        
           MOVE 0                          TO MI-TRAN-APPL-NO.          
           IF WS-PYMNT-START-DATE-2 NOT EQUAL WG-PYMNT-START-DATE THEN  
               MOVE WS-PYMNT-START-DATE    TO MI-COLUMN-DESC            
               ADD 1                       TO MI-TRAN-APPL-NO           
               MOVE WG-PYMNT-START-DATE    TO WS-OLD-DATE-FORMAT        
               PERFORM 5700-FORMAT-DATE    THRU 5700-EXIT               
               MOVE WS-NEW-DATE-FORMAT     TO MI-PRV-COLUMN-VALUE-TEXT  
               MOVE WS-10                  TO MI-PRV-COLUMN-VALUE-LEN   
               MOVE WS-PYMNT-START-DATE-2  TO WS-OLD-DATE-FORMAT        
               PERFORM 5700-FORMAT-DATE    THRU 5700-EXIT               
               MOVE WS-NEW-DATE-FORMAT     TO MI-CHG-COLUMN-VALUE-TEXT  
               MOVE WS-10                  TO MI-CHG-COLUMN-VALUE-LEN   
               PERFORM 6530-LOAD-MNT-TRANS-HIST   THRU 6530-EXIT        
           END-IF.                                                      
                                                                        
           IF WG-FINL-INSTLLMNT-AMT NOT EQUAL WS-FN-INSTLT-AMT-D THEN   
                MOVE WS-FINL-INSTLLMNT-AMT  TO MI-COLUMN-DESC           
                ADD 1                       TO MI-TRAN-APPL-NO          
                MOVE WG-FINL-INSTLLMNT-AMT  TO WS-DOLLAR-AMT-N          
                MOVE WS-DOLLAR-AMT-N        TO WS-DOLLAR-AMT-T          
                MOVE WS-DOLLAR-AMT-T        TO MI-PRV-COLUMN-VALUE-TEXT 
                MOVE WS-15                  TO MI-PRV-COLUMN-VALUE-LEN  
                MOVE WS-FN-INSTLT-AMT-D     TO WS-DOLLAR-AMT-N          
                MOVE WS-DOLLAR-AMT-N        TO WS-DOLLAR-AMT-T          
                MOVE WS-DOLLAR-AMT-T        TO MI-CHG-COLUMN-VALUE-TEXT 
                MOVE WS-15                  TO MI-CHG-COLUMN-VALUE-LEN  
                PERFORM 6530-LOAD-MNT-TRANS-HIST   THRU 6530-EXIT       
           END-IF.                                                      
                                                                        
           IF WG-MTH-INSTLLMNT-AMT NOT EQUAL WS-MN-INSTLT-AMT-D THEN    
                MOVE WS-MTH-INSTLLMNT-AMT   TO MI-COLUMN-DESC           
                ADD 1                       TO MI-TRAN-APPL-NO          
                MOVE WG-MTH-INSTLLMNT-AMT   TO WS-DOLLAR-AMT-N          
                MOVE WS-DOLLAR-AMT-N        TO WS-DOLLAR-AMT-T          
                MOVE WS-DOLLAR-AMT-T        TO MI-PRV-COLUMN-VALUE-TEXT 
                MOVE WS-15                  TO MI-PRV-COLUMN-VALUE-LEN  
                MOVE WS-MN-INSTLT-AMT-D     TO WS-DOLLAR-AMT-N          
                MOVE WS-DOLLAR-AMT-N        TO WS-DOLLAR-AMT-T          
                MOVE WS-DOLLAR-AMT-T        TO MI-CHG-COLUMN-VALUE-TEXT 
                MOVE WS-15                  TO MI-CHG-COLUMN-VALUE-LEN  
                PERFORM 6530-LOAD-MNT-TRANS-HIST   THRU 6530-EXIT       
                                                                        
           IF WG-WO-TOT-ARRGMT-AMT NOT EQUAL WS-WO-TOT-ARRGMT-AMT-D THEN
                MOVE WS-WO-TOT-ARRGMT-AMT-T TO MI-COLUMN-DESC           
                ADD 1                       TO MI-TRAN-APPL-NO          
                MOVE WG-WO-TOT-ARRGMT-AMT   TO WS-DOLLAR-AMT-N          
                MOVE WS-DOLLAR-AMT-N        TO WS-DOLLAR-AMT-T          
                MOVE WS-DOLLAR-AMT-T        TO MI-PRV-COLUMN-VALUE-TEXT 
                MOVE WS-15                  TO MI-PRV-COLUMN-VALUE-LEN  
                MOVE WS-WO-TOT-ARRGMT-AMT-D TO WS-DOLLAR-AMT-N          
                MOVE WS-DOLLAR-AMT-N        TO WS-DOLLAR-AMT-T          
                MOVE WS-DOLLAR-AMT-T        TO MI-CHG-COLUMN-VALUE-TEXT 
                MOVE WS-15                  TO MI-CHG-COLUMN-VALUE-LEN  
                PERFORM 6530-LOAD-MNT-TRANS-HIST   THRU 6530-EXIT       
           END-IF
           END-IF.                                                      
                                                                        
           IF WG-FRCST-COLL-AGY-DT NOT EQUAL WS-FRCST-COLL-AGY-DT-2 THEN
                MOVE WS-FRCST-COLL-AGY-DT   TO MI-COLUMN-DESC           
                ADD 1                       TO MI-TRAN-APPL-NO          
                MOVE WG-FRCST-COLL-AGY-DT   TO WS-OLD-DATE-FORMAT       
                PERFORM 5700-FORMAT-DATE    THRU 5700-EXIT              
                MOVE WS-NEW-DATE-FORMAT     TO MI-PRV-COLUMN-VALUE-TEXT 
                MOVE WS-10                  TO MI-PRV-COLUMN-VALUE-LEN  
                MOVE WS-FRCST-COLL-AGY-DT-2 TO WS-OLD-DATE-FORMAT       
                PERFORM 5700-FORMAT-DATE    THRU 5700-EXIT              
                MOVE WS-NEW-DATE-FORMAT     TO MI-CHG-COLUMN-VALUE-TEXT 
                MOVE WS-10                  TO MI-CHG-COLUMN-VALUE-LEN  
                PERFORM 6530-LOAD-MNT-TRANS-HIST   THRU 6530-EXIT       
           END-IF.                                                      
                                                                        
      *    IF WG-WO-MAX-BALANCE NOT EQUAL WS-WO-MAX-BALANCE-D THEN              
      *         MOVE WS-WO-MAX-BALANCE      TO MI-COLUMN-DESC                   
      *         ADD 1                       TO MI-TRAN-APPL-NO                  
      *         MOVE WG-WO-MAX-BALANCE      TO WS-DOLLAR-AMT-N                  
      *         MOVE WS-DOLLAR-AMT-N        TO WS-DOLLAR-AMT-T                  
      *         MOVE WS-DOLLAR-AMT-T        TO MI-PRV-COLUMN-VALUE-TEXT         
      *         MOVE WS-15                  TO MI-PRV-COLUMN-VALUE-LEN          
      *         MOVE WS-WO-MAX-BALANCE-D    TO WS-DOLLAR-AMT-N                  
      *         MOVE WS-DOLLAR-AMT-N        TO WS-DOLLAR-AMT-T                  
      *         MOVE WS-DOLLAR-AMT-T        TO MI-CHG-COLUMN-VALUE-TEXT         
      *         MOVE WS-15                  TO MI-CHG-COLUMN-VALUE-LEN          
      *         PERFORM 6530-LOAD-MNT-TRANS-HIST   THRU 6530-EXIT               
      *    END-IF.                                                              
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5500-CALC-CRED-BUREAU-DT                                       *        
      *                                                                *        
      *     CALCULATED COLLECTION AND CREDIT BUREAU DATE BASED ON      *        
      *     WRITE OFF DATE.                                            *        
      *                                                                *        
T21883*     WHEN WO ARRANGEMENT DELETED, IF COLLECTION AGENCY AND CREDIT        
T21883*     BUREAU DATES CALCULATED ARE IN THE PAST, THEN CHANGE COLLE-*        
T21883*     CTION AGENCY BASED ON DAY-COLLECTION(CSS_DELINQUENCY) FROM *        
T21883*     CURRENT DATE AND CHANGE CREDIT BUREAU DATE BASED ON        *        
T21883*     DAY-CREDIT(CSS_DELINQUENCY) FROM CURRENT DATE.             *        
      ******************************************************************        
       5500-CALC-CRED-BUREAU-DT.                                        
                                                                        
C30169********* SELECT WRITE OFF DATE *******************************           
C30169     MOVE 'WO'                        TO KD-FW-ACTION-TYPE-CD.    
C30169     PERFORM 7810-SELECT-FIN-WO-ACTION-DT                         
C30169                                      THRU 7810-EXIT.             
C30169     MOVE KD-FW-ACTION-DT             TO WS-WRITEOFF-DT.          
                                                                        
C30169********* SELECT COLLECTION ACTION DATE *********************             
C30169     MOVE WS-ACTION-TYPE              TO KD-FW-ACTION-TYPE-CD.    
C30169     MOVE WS-SEQ-NO                   TO KD-FW-SEQ-NO.            
C30169     PERFORM 7800-SELECT-ACTION-DT    THRU 7800-EXIT.             
C30169                                                                  
C30169     MOVE KD-FW-ACTION-DT             TO WS-COLLECTION-DT.        
           IF WS-COLLECTION-DT > SPACES                                 
                                                                        
             MOVE WS-DAY-COLLECTION      TO C8-DELINQ-CD                
             PERFORM 7200-SELECT-ADDITIONAL-DAYS        THRU 7200-EXIT  
T21624       MOVE C8-DELINQ-VALUE        TO WS-DAY-COLLEC-NO-DAYS       
                                                                        
T21883***  CHECKING FOR THE PAST DATE **************************                
T21883***  WS-MN-TRANS-HIST-DT= CURRENT DATE ******************                 
T21883       IF WS-COLLECTION-DT < WS-MN-TRANS-HIST-DT                  
T21883          MOVE WS-MN-TRANS-HIST-DT    TO WS-WORK-DATE             
T21883       ELSE                                                       
T30169          MOVE WS-WRITEOFF-DT         TO WS-WORK-DATE             
T21883       END-IF                                                     
                                                                        
T21624       PERFORM 5080-GET-WORKING-DAYS              THRU 5080-EXIT  
             MOVE ZERO                   TO WS-NULL-INDICATOR           
T21624       IF WS-WORK-DATE             >= WS-MN-TRANS-HIST-DT THEN    
T21624          MOVE WS-WORK-DATE        TO WS-NEW-ACTION-DT            
             ELSE                                                       
                MOVE WS-MN-TRANS-HIST-DT TO WS-NEW-ACTION-DT            
             END-IF                                                     
           ELSE                                                         
              MOVE SPACES              TO WS-NEW-ACTION-DT              
           END-IF.                                                      
                                                                        
      *                                                                         
       5500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5600-FORMAT-MNT-TRAN-HIST.                                     *        
      *                                                                *        
      *     1. CHECK ACTION CODE FOR THE TYPE OF PROCESS TO BE HANDLED:*        
      *     2. WRITE APPROPRIATE RECORDS                               *        
      *                                                                *        
      ******************************************************************        
       5600-FORMAT-MNT-TRAN-HIST.                                       
                                                                        
           PERFORM 7400-GET-TRANS-TS          THRU 7400-EXIT.           
           MOVE WS-MN-TRANS-HIST-TS   TO MH-TRANS-HIST-SEQ-NO.          
           PERFORM 7500-GET-TRANS-DT          THRU 7500-EXIT.           
           MOVE WS-MN-TRANS-HIST-DT   TO MH-DATE-TRANS.                 
           MOVE WS-MNT-TRANS-TYPE     TO MH-CODE-TRAN-TYPE.             
           MOVE PARM-RESP-AREA-ID     TO MH-RESP-AREA-ID.               
           MOVE WS-ACCOUNT-NO         TO MH-ACCOUNT-NO.                 
           MOVE ZERO                  TO MH-CUSTOMER-NO.                
           MOVE ZERO                  TO MH-PREMISE-NO.                 
           MOVE PARM-USER-ID          TO MH-USER-ID.                    
           MOVE PARM-PROGRAM-ID       TO MH-APPL-PROGRAM-ID.            
           MOVE WS-1                  TO MH-ENTITY-KEY-DESC-LEN.        
           MOVE SPACES                TO MH-ENTITY-KEY-DESC-TEXT.       
           MOVE WS-TRANS-COMMENT-LEN  TO MH-TRAN-COMMENT-LEN.           
           MOVE PARM-TRANS-COMMENT-TEXT                                 
                                      TO MH-TRAN-COMMENT-TEXT.          
           MOVE WS-MN-TRANS-HIST-TS   TO MI-TRANS-HIST-SEQ-NO.          
           MOVE SPACE                 TO MI-TABLE-ID.                   
                                                                        
       5600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5700-FORMAT-DATES.                                             *        
      *                                                                *        
      *     1. CALLED WHILE WRITING TRANS HISTORY TO CHANGE THE        *        
      *        FORMAT OF THE DATES TO MM/DD/YYYY                       *        
      *                                                                *        
      ******************************************************************        
       5700-FORMAT-DATE.                                                
                                                                        
           MOVE WS-OLD-CCYY          TO WS-NEW-CCYY.                    
           MOVE WS-OLD-MM            TO WS-NEW-MM.                      
           MOVE WS-OLD-DD            TO WS-NEW-DD.                      
                                                                        
       5700-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      * MAINTENANCE TRANSACTION HISTORY                                         
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
C30169******************************************************************        
C30169* 5950-SET-MNT-TRANS-VARS                                        *        
C30169*      -- THIS MODULE SETS UP THE REMAINING HOST VARIABLES WITH  *        
C30169*         SYSTEM WORKING STORAGE OR HARD-CODED VALUES FOR        *        
C30169*         INSERTING INTO THE CSS_MNT_TRANS_HIST AND              *        
C30169*         CSS_MT_TRN_HST_DET TABLES IN ORDER TO COMPLETE THE     *        
C30169*         REQUIRED MAINTENANCE TRANSACTION RECORD.               *        
C30169******************************************************************        
C30169*                                                                         
C30169 5950-SET-MNT-TRANS-VARS.                                         
C30169                                                                  
C30169     MOVE '5950'                      TO ACTIVE-PARAGRAPH.        
C30169*                                                                         
C30169     MOVE WS-COLUMN-DESC              TO MI-COLUMN-DESC.          
C30169     MOVE MH-TRANS-HIST-SEQ-NO        TO MI-TRANS-HIST-SEQ-NO.    
C30169     MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.         
C30169     MOVE WS-PRV-COLUMN-VALUE-TEXT    TO MI-PRV-COLUMN-VALUE-TEXT.
C30169     IF WS-PRV-COLUMN-VALUE-LEN > 75                              
C30169        MOVE +75 TO WS-PRV-COLUMN-VALUE-LEN                       
C30169     END-IF.                                                      
C30169     MOVE WS-PRV-COLUMN-VALUE-LEN     TO MI-PRV-COLUMN-VALUE-LEN. 
C30169     MOVE WS-CHG-COLUMN-VALUE-TEXT    TO MI-CHG-COLUMN-VALUE-TEXT.
C30169     IF WS-CHG-COLUMN-VALUE-LEN > 75                              
C30169        MOVE +75 TO WS-CHG-COLUMN-VALUE-LEN                       
C30169     END-IF.                                                      
C30169     MOVE WS-CHG-COLUMN-VALUE-LEN     TO MI-CHG-COLUMN-VALUE-LEN. 
C30169                                                                  
C30169 5950-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                         
      ******************************************************************        
      * 7000-SELECT-WO-ARRANGEMENT                                     *        
      *       -- THIS SELECTS THE WRITE OFF ARRANGEMENT FOR A WRITTEN  *        
      *          OFF ACCOUNT                                           *        
      ******************************************************************        
       7000-SELECT-WO-ARRANGEMENT.                                      
                                                                        
           EXEC SQL                                                     
               SELECT PYMNT_START_DATE,                                 
                      FINL_INSTLLMNT_AMT,                               
                      MTH_INSTLLMNT_AMT,                                
                      WO_TOT_ARRGMT_AMT,                                
                      FRCST_COLL_AGY_DT,                                
                      WO_MAX_BALANCE                                    
               INTO   :WG-PYMNT-START-DATE,                             
                      :WG-FINL-INSTLLMNT-AMT,                           
                      :WG-MTH-INSTLLMNT-AMT,                            
                      :WG-WO-TOT-ARRGMT-AMT,                            
                      :WG-FRCST-COLL-AGY-DT :WS-FRCST-COLAGY-DT-NULL,    
                      :WG-WO-MAX-BALANCE                                
               FROM   CSS_WO_ARRANGEMENT WITH(READUNCOMMITTED)                  
               WHERE  ACCOUNT_NO     = :WG-ACCOUNT-NO                   
T35434                                                           
P00799                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PYMNT_START_DATE,                                         
MFA-TR*               FINL_INSTLLMNT_AMT,                                       
MFA-TR*               MTH_INSTLLMNT_AMT,                                        
MFA-TR*               WO_TOT_ARRGMT_AMT,                                        
MFA-TR*               FRCST_COLL_AGY_DT,                                        
MFA-TR*               WO_MAX_BALANCE                                            
MFA-TR*        INTO   :WG-PYMNT-START-DATE,                                     
MFA-TR*               :WG-FINL-INSTLLMNT-AMT,                                   
MFA-TR*               :WG-MTH-INSTLLMNT-AMT,                                    
MFA-TR*               :WG-WO-TOT-ARRGMT-AMT,                                    
MFA-TR*               :WG-FRCST-COLL-AGY-DT:WS-FRCST-COLAGY-DT-NULL,            
MFA-TR*               :WG-WO-MAX-BALANCE                                        
MFA-TR*        FROM   CSS_WO_ARRANGEMENT                                        
MFA-TR*        WHERE  ACCOUNT_NO     = :WG-ACCOUNT-NO                           
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO S-RETURN-CODE.                               
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-FRCST-COLAGY-DT-NULL < 0                            
                 MOVE SPACES              TO WG-FRCST-COLL-AGY-DT       
              END-IF                                                    
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE              
               MOVE '7000'                TO ACTIVE-PARAGRAPH           
CBSI           MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_WO_ARRANGEMENT'  TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE WG-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
C30169******************************************************************        
C30169* 7010-CALL-CSR04074.                                            *        
C30169* CALL CSR04074 AND UPDATE THE FORECASTED ACTION DATES           *        
C30169******************************************************************        
C30169*                                                                         
C30169 7010-CALL-CSR04074.                                              
C30169*                                                                         
C30169*    EXEC SQL                                                     
C30169*         CALL CSR04074(:WS-ACCOUNT                               
C30169*                      ,:WS-ACTION-TYPE                           
C30169*                      ,:WS-SEQ-NO                                
C30169*                      ,:WS-ORIG-ACTION-DT                        
C30169*                      ,:WS-NEW-ACTION-DT                         
C30169*                      ,:AT-COMPANY-NO                            
C30169*                      )                                          
C30169*    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE FORECAST_DT_CUR
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN FORECAST_DT_CUR
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR FORECAST_DT_CUR INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
C30169*                                                                         
C30169     IF SQLCODE = +466 THEN                                       
C30169*        EXEC SQL                                                 
C30169*            ASSOCIATE LOCATORS                                   
C30169*            (:LOC-RESLTSET)                                      
C30169*            WITH PROCEDURE CSR04074                              
C30169*        END-EXEC                                                 
C30169                                                                  
C30169*        EXEC SQL                                                 
C30169*            ALLOCATE FORECAST_DT_CUR CURSOR FOR RESULT SET       
C30169*            :LOC-RESLTSET                                        
C30169*        END-EXEC                                                 
C30169         MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                    
C30169         PERFORM 7020-FETCH-4074-CUR  THRU 7020-EXIT              
C30169             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
C30169         EXEC SQL                                                 
C30169            CLOSE FORECAST_DT_CUR                                 
C30169         END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                 
C30169     END-IF.                                                      
C30169*                                                                         
C30169 7010-EXIT.                                                       
C30169      EXIT.                                                       
C30169*                                                                         
C30169******************************************************************        
C30169* 7020-FETCH-4074-CUR.                                           *        
C30169******************************************************************        
C30169*                                                                         
C30169 7020-FETCH-4074-CUR.                                             
C30169*                                                                         
C30169     EXEC SQL                                                     
C30169          FETCH FORECAST_DT_CUR INTO                              
C30169                :WS-RETURN-CODE-4074                              
C30169               ,:WS-ACTION-TYPE-UPDT                              
C30169               ,:WS-SEQ-NO-UPDT                                   
C30169               ,:WS-ACTION-DT-UPDT                                
C30169     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30169*                                                                         
C30169     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
C30169*                                                                         
C30169     EVALUATE WS-ACTIVE-RETURN-CODE                               
C30169     WHEN SUCCESSFUL-CALL                                         
C30169        IF WS-RETURN-CODE-4074 = 0 AND                            
C30169           WS-ACTION-TYPE-UPDT NOT = 'CREDB' AND                  
C30169           WS-ACTION-TYPE-UPDT NOT = 'AXFR4'                      
C30169           PERFORM 5050-UPDATE-ACTION-DATE THRU 5050-EXIT         
C30169        END-IF                                                    
C30169     WHEN NOT-FOUND                                               
C30169        CONTINUE                                                  
C30169     WHEN OTHER                                                   
C30169        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
C30169        MOVE SQLCODE                   TO ABEND-SQLCODE           
C30169        MOVE SQLSTATE                  TO ABEND-SQLSTATE          
C30169        MOVE '7020'                    TO ACTIVE-PARAGRAPH        
C30169        MOVE 'FETCH'                   TO ABEND-FUNCTION          
C30169        MOVE 'C2_CURSOR'               TO TABLE-1                 
C30169        MOVE 'WS-ACTIVE-RETURN-CODE'   TO TABLE-ELEMENT-1         
C30169        MOVE WS-ACTIVE-RETURN-CODE     TO HOSTVAR-ELEMENT-1       
C30169        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C30169*                                                                         
C30169     END-EVALUATE.                                                
C30169*                                                                         
C30169 7020-EXIT.                                                       
C30169      EXIT.                                                       
      ******************************************************************        
      *7200-SELECT-ADDITIONAL-DAYS                                     *        
      *    -- THIS MODULE SELECTS THE WRITE OFF DATE FOR AN ACCOUNT    *        
      ******************************************************************        
       7200-SELECT-ADDITIONAL-DAYS.                                     
                                                                        
               EXEC SQL                                                 
                  SELECT DELINQ_VALUE                                   
                  INTO   :C8-DELINQ-VALUE                               
                  FROM   CSS_DELINQUENCY WITH(READUNCOMMITTED)                  
                  WHERE  DELINQ_CD = :C8-DELINQ-CD                      
T23501              AND  COMPANY_NO = :AT-COMPANY-NO                    
T35434                                                           
P00799                                                      
               END-EXEC.                                                

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*        EXEC SQL                                                         
MFA-TR*           SELECT DELINQ_VALUE                                           
MFA-TR*           INTO   :C8-DELINQ-VALUE                                       
MFA-TR*           FROM   CSS_DELINQUENCY                                        
MFA-TR*           WHERE  DELINQ_CD = :C8-DELINQ-CD                              
MFA-TR*             AND  COMPANY_NO = :AT-COMPANY-NO                            
MFA-TR*             WITH UR                                                     
MFA-TR*           QUERYNO 7200                                                  
MFA-TR*        END-EXEC.                                                        

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO S-RETURN-CODE.              
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF ((SQLCODE EQUAL TO SUCCESSFUL-CALL) OR                    
               (SQLCODE EQUAL TO NOT-FOUND))                            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7200'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_DELINQUENCY'     TO TABLE-1                     
              MOVE 'DELINQ_CD'           TO TABLE-ELEMENT-1             
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
              MOVE C8-DELINQ-CD          TO HOSTVAR-ELEMENT-1           
CBSI          MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *7400-GET-TRANS-TS                                               *        
      *    -- THIS MODULE GETS THE MNT TRANS HIST TIMESTAMP            *        
      ******************************************************************        
       7400-GET-TRANS-TS.                                               
                                                                        
               EXEC SQL                                                 
                  SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-MN-TRANS-HIST-TS          
               END-EXEC.                                                

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*        EXEC SQL                                                         
MFA-TR*           SET :WS-MN-TRANS-HIST-TS = CURRENT TIMESTAMP                  
MFA-TR*        END-EXEC.                                                        

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO S-RETURN-CODE.              
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF ((SQLCODE EQUAL TO SUCCESSFUL-CALL) OR                    
               (SQLCODE EQUAL TO NOT-FOUND))                            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7400'                TO ACTIVE-PARAGRAPH            
CBSI          MOVE 'SET '                TO ABEND-FUNCTION              
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
CBSI          MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      *7500-GET-TRANS-DT                                               *        
      *    -- THIS MODULE GETS THE MNT TRANS HIST TIMESTAMP            *        
      ******************************************************************        
       7500-GET-TRANS-DT.                                               
                                                                        
               EXEC SQL                                                 
                  SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-MN-TRANS-HIST-DT               
               END-EXEC.                                                

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*        EXEC SQL                                                         
MFA-TR*           SET :WS-MN-TRANS-HIST-DT = CURRENT DATE                       
MFA-TR*        END-EXEC.                                                        

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO S-RETURN-CODE.              
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF ((SQLCODE EQUAL TO SUCCESSFUL-CALL) OR                    
               (SQLCODE EQUAL TO NOT-FOUND))                            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7500'                TO ACTIVE-PARAGRAPH            
CBSI          MOVE 'SET'                 TO ABEND-FUNCTION              
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
CBSI          MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
T21624 7620-SELECT-HOLIDAY.                                             
                                                                        
           MOVE SPACES         TO WS-EXISTS-FL.                         
           MOVE WS-WORK-DATE   TO J8-HOLIDAY-DT.                        
           MOVE WS-01          TO J8-COMPANY-NO                         
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
              INTO   :WS-EXISTS-FL                                      
              FROM   CSS_HOLIDAY WITH(READUNCOMMITTED)                          
              WHERE  HOLIDAY_DT = IIF(TRY_CONVERT(DATE, :J8-HOLIDAY-DT
              ) IS NULL OR (PATINDEX('%.%', :J8-HOLIDAY-DT
              ) <> 0) OR (LEN(:J8-HOLIDAY-DT) <> 10), CIS.CHAR2DATE(
                                                         :J8-HOLIDAY-DT
              ), CONVERT(DATE, :J8-HOLIDAY-DT) )                        
                AND  COMPANY_NO = :J8-COMPANY-NO                        
T35434                                                           
P00799                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*       INTO   :WS-EXISTS-FL                                              
MFA-TR*       FROM   CSS_HOLIDAY                                                
MFA-TR*       WHERE  HOLIDAY_DT = :J8-HOLIDAY-DT                                
MFA-TR*         AND  COMPANY_NO = :J8-COMPANY-NO                                
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7620                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO S-RETURN-CODE               
                                            WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                                        OR  NOT-FOUND                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7620'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_HOLIDAY'         TO TABLE-1                     
              MOVE 'HOLIDAY_DT'          TO TABLE-ELEMENT-1             
              MOVE J8-HOLIDAY-DT         TO HOSTVAR-ELEMENT-1           
              MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2             
              MOVE J8-COMPANY-NO         TO HOSTVAR-ELEMENT-2           
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-3             
              MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
T21624 7620-EXIT.                                                       
           EXIT.                                                        
                                                                        
T21624 7640-GET-NEXT-BUS-DAY.                                           
                                                                        
           EXEC SQL                                                     
T35434        SELECT
              DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) ) ),
              CIS.DAYS(DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, 
                                                          :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) ) )) -        
T35434              (CIS.DAYS(DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, 
                                                          :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) ) ))/7 * 7)
            INTO
              :WS-WORK-DATE,
              :WS-DAY 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-WORK-DATE= DATE(:WS-WORK-DATE) + 1 DAYS                   
MFA-TR*          ,:WS-DAY = DAYS(DATE(:WS-WORK-DATE) + 1 DAYS) -                
MFA-TR*             (INTEGER(DAYS(DATE(:WS-WORK-DATE) + 1 DAYS)/7) * 7)         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO S-RETURN-CODE               
                                            WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7640'                TO ACTIVE-PARAGRAPH            
T35434        MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
T21624 7640-EXIT.                                                       
           EXIT.                                                        
                                                                        
T23501****************************************                                  
T23501*  SELECTS COMPANY_NO FROM CSS_ACCOUNT *                                  
T23501****************************************                                  
T23501 7700-SELECT-COMPANY-NO.                                          
T23501                                                                  
T23501     MOVE WS-ACCOUNT-NO TO AT-ACCOUNT-NO.                         
T23501                                                                  
T23501     EXEC SQL                                                     
T23501        SELECT COMPANY_NO                                         
T23501          INTO :AT-COMPANY-NO                                     
T23501          FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
T23501         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
T35434                                                           
P00799                                                      
T23501     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COMPANY_NO                                                 
MFA-TR*         INTO :AT-COMPANY-NO                                             
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7700                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T23501                                                                  
T23501     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T23501     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T23501        NEXT SENTENCE                                             
T23501     ELSE                                                         
T23501        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
T23501        MOVE '7700'                TO ACTIVE-PARAGRAPH            
T23501        MOVE 'SELECT'              TO ABEND-FUNCTION              
T23501        MOVE SPACES                TO ABEND-SQL-PREDICATES        
T23501                                      ABEND-TABLES                
T23501        MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
T23501        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
T23501        MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T23501        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
T23501        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
T23501     END-IF.                                                      
T23501                                                                  
T23501 7700-EXIT.                                                       
T23501     EXIT.                                                        
                                                                        
C30169******************************************************************        
C30169* 7800-SELECT-ACTION-DT.                                         *        
C30169******************************************************************        
C30169*                                                                         
C30169 7800-SELECT-ACTION-DT.                                           
                                                                        
           EXEC SQL                                                     
               SELECT                                                   
                    KD.FW_ACTION_DT                                     
                   ,IZ.WITHDRAW_DT                                      
               INTO                                                     
                    :KD-FW-ACTION-DT :WS-KD-FW-ACTION-DT-NULL            
                   ,:IZ-WITHDRAW-DT :WS-IZ-WITHDRAW-DT-NULL              
               FROM                                                     
                   CSS_FIN_WO_ACTION  KD                                
               LEFT OUTER JOIN                                          
                   CSS_FIN_WO_COLLECT IZ                                
               ON                                                       
                   KD.ACCOUNT_NO        = IZ.ACCOUNT_NO                 
               AND KD.FW_ACTION_TYPE_CD = IZ.FW_ACTION_TYPE_CD          
               AND KD.FW_SEQ_NO         = IZ.FW_COLL_SEQ_NO             
               WHERE                                                    
                   KD.ACCOUNT_NO        = :WS-ACCOUNT-NO                
               AND KD.FW_ACTION_TYPE_CD = :KD-FW-ACTION-TYPE-CD         
               AND KD.FW_SEQ_NO         = :KD-FW-SEQ-NO                 
P00799                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT                                                           
MFA-TR*             KD.FW_ACTION_DT                                             
MFA-TR*            ,IZ.WITHDRAW_DT                                              
MFA-TR*        INTO                                                             
MFA-TR*             :KD-FW-ACTION-DT:WS-KD-FW-ACTION-DT-NULL                    
MFA-TR*            ,:IZ-WITHDRAW-DT:WS-IZ-WITHDRAW-DT-NULL                      
MFA-TR*        FROM                                                             
MFA-TR*            CSS_FIN_WO_ACTION  KD                                        
MFA-TR*        LEFT OUTER JOIN                                                  
MFA-TR*            CSS_FIN_WO_COLLECT IZ                                        
MFA-TR*        ON                                                               
MFA-TR*            KD.ACCOUNT_NO        = IZ.ACCOUNT_NO                         
MFA-TR*        AND KD.FW_ACTION_TYPE_CD = IZ.FW_ACTION_TYPE_CD                  
MFA-TR*        AND KD.FW_SEQ_NO         = IZ.FW_COLL_SEQ_NO                     
MFA-TR*        WHERE                                                            
MFA-TR*            KD.ACCOUNT_NO        = :WS-ACCOUNT-NO                        
MFA-TR*        AND KD.FW_ACTION_TYPE_CD = :KD-FW-ACTION-TYPE-CD                 
MFA-TR*        AND KD.FW_SEQ_NO         = :KD-FW-SEQ-NO                         
MFA-TR*        QUERYNO 7800                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO S-RETURN-CODE            
                                               WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-IZ-WITHDRAW-DT-NULL < 0 OR                          
                 WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE SPACES                TO IZ-WITHDRAW-DT           
                 MOVE ZERO                  TO WS-IZ-WITHDRAW-DT-NULL   
              END-IF                                                    
              IF WS-KD-FW-ACTION-DT-NULL < 0 OR                         
                 WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE SPACES                TO KD-FW-ACTION-DT          
                 MOVE ZERO                  TO WS-KD-FW-ACTION-DT-NULL  
              END-IF                                                    
              MOVE ZERO                     TO S-RETURN-CODE            
                                               WS-ACTIVE-RETURN-CODE    
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE         
               MOVE '7800'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE 'CSS_FIN_WO_ACTION'        TO TABLE-1               
               MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
               MOVE 'ACTION TYPE CD'           TO TABLE-ELEMENT-2       
               MOVE 'FW SEQ NO'                TO TABLE-ELEMENT-3       
               MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
               MOVE KD-FW-ACTION-TYPE-CD       TO HOSTVAR-ELEMENT-2     
               MOVE KD-FW-SEQ-NO               TO HOSTVAR-ELEMENT-3     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
C30169     END-IF.                                                      
C30169                                                                  
C30169 7800-EXIT.                                                       
C30169      EXIT.                                                       
C30169*                                                                         
C30169******************************************************************        
C30169* 7810-SELECT-FIN-WO-ACTION-DT                                   *        
C30169******************************************************************        
C30169*                                                                         
C30169 7810-SELECT-FIN-WO-ACTION-DT.                                    
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) KD.FW_ACTION_DT,
              KD.FW_SEQ_NO,
              KD.FW_ACTION_AM                                     
               INTO                                                     
                    :KD-FW-ACTION-DT :WS-KD-FW-ACTION-DT-NULL            
                   ,:KD-FW-SEQ-NO                                       
                   ,:KD-FW-ACTION-AM                                    
               FROM                                                     
                   CSS_FIN_WO_ACTION  KD WITH(READUNCOMMITTED)                  
               WHERE                                                    
                   KD.ACCOUNT_NO        = :WS-ACCOUNT-NO                
               AND KD.FW_ACTION_TYPE_CD = :KD-FW-ACTION-TYPE-CD         
               ORDER BY FW_SEQ_NO DESC                                  
                                           
P00799                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT                                                           
MFA-TR*             KD.FW_ACTION_DT                                             
MFA-TR*            ,KD.FW_SEQ_NO                                                
MFA-TR*            ,KD.FW_ACTION_AM                                             
MFA-TR*        INTO                                                             
MFA-TR*             :KD-FW-ACTION-DT:WS-KD-FW-ACTION-DT-NULL                    
MFA-TR*            ,:KD-FW-SEQ-NO                                               
MFA-TR*            ,:KD-FW-ACTION-AM                                            
MFA-TR*        FROM                                                             
MFA-TR*            CSS_FIN_WO_ACTION  KD                                        
MFA-TR*        WHERE                                                            
MFA-TR*            KD.ACCOUNT_NO        = :WS-ACCOUNT-NO                        
MFA-TR*        AND KD.FW_ACTION_TYPE_CD = :KD-FW-ACTION-TYPE-CD                 
MFA-TR*        ORDER BY FW_SEQ_NO DESC                                          
MFA-TR*        FETCH FIRST 1 ROW ONLY WITH UR                                   
MFA-TR*        QUERYNO 7810                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO S-RETURN-CODE            
                                               WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-KD-FW-ACTION-DT-NULL < 0 OR                         
                 WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE SPACES                TO KD-FW-ACTION-DT          
                 MOVE ZERO                  TO WS-KD-FW-ACTION-DT-NULL  
P00799                                         KD-FW-ACTION-AM          
              END-IF                                                    
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE WS-ACTIVE-RETURN-CODE      TO S-RETURN-CODE         
               MOVE '7810'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE 'CSS_FIN_WO_ACTION'        TO TABLE-1               
               MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
               MOVE 'ACTION TYPE CD'           TO TABLE-ELEMENT-2       
               MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1     
               MOVE KD-FW-ACTION-TYPE-CD       TO HOSTVAR-ELEMENT-2     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
C30169     END-IF.                                                      
C30169                                                                  
C30169 7810-EXIT.                                                       
C30169      EXIT.                                                       
C30169****************************************************************          
C30169*  7820-SELECT-ACTION-DESC.                                    *          
C30169****************************************************************          
C30169*                                                                         
C30169 7820-SELECT-ACTION-DESC.                                         
C30169*                                                                         
           MOVE '7820'                 TO ACTIVE-PARAGRAPH              
                                                                        
           EXEC SQL                                                     
               SELECT                                                   
                   FW_ATTR_VALUE_DESC                                   
               INTO                                                     
                   :WS-FW-ATTR-VALUE-DESC                               
               FROM                                                     
                   CSS_FW_ATTRIB_DESC                                   
               WHERE                                                    
                   FW_ATTRIB_TYPE_CD   = :WS-FW-ATTRIB-TYPE-CD          
               AND FW_ATTR_VALUE_CD    = :WS-FW-ATTR-VALUE-CD           
P00799                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT                                                           
MFA-TR*            FW_ATTR_VALUE_DESC                                           
MFA-TR*        INTO                                                             
MFA-TR*            :WS-FW-ATTR-VALUE-DESC                                       
MFA-TR*        FROM                                                             
MFA-TR*            CSS_FW_ATTRIB_DESC                                           
MFA-TR*        WHERE                                                            
MFA-TR*            FW_ATTRIB_TYPE_CD   = :WS-FW-ATTRIB-TYPE-CD                  
MFA-TR*        AND FW_ATTR_VALUE_CD    = :WS-FW-ATTR-VALUE-CD                   
MFA-TR*        QUERYNO 7820                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE               
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7820'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_FW_ATTRIB_DESC'  TO TABLE-1                     
              MOVE 'FW_ATTRIB_TYPE_CD'   TO TABLE-ELEMENT-1             
              MOVE 'FW_ATTR_VALUE_CD'    TO TABLE-ELEMENT-2             
              MOVE WS-FW-ATTRIB-TYPE-CD  TO HOSTVAR-ELEMENT-1           
              MOVE WS-FW-ATTR-VALUE-CD   TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7820-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8000-INSERT-WO-ARRANGEMENTS                                    *        
      *    -- THIS MODULE INSERTS NEW WRITE OFF PAYMENT ARRANGEMENTS   *        
      *       FOR ACCOUNTS INTO TABLE CSS_WO_ARRANGEMENT               *        
      ******************************************************************        
       8000-INSERT-WO-ARRANGEMENT.                                      
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_WO_ARRANGEMENT                           
                   (ACCOUNT_NO,                                         
                    PYMNT_START_DATE,                                   
                    FINL_INSTLLMNT_AMT,                                 
                    MTH_INSTLLMNT_AMT,                                  
                    WO_TOT_ARRGMT_AMT,                                  
                    FRCST_COLL_AGY_DT,                                  
                    WO_MAX_BALANCE,                                     
C30169              SETUP_BY_USERID,                                    
C30169              SETUP_DT)                                           
               VALUES                                                   
                   (:WS-ACCOUNT-NO,                                     
                    IIF(TRY_CONVERT(DATE, :WS-PYMNT-START-DATE-2
              ) IS NULL OR (PATINDEX('%.%', :WS-PYMNT-START-DATE-2
              ) <> 0) OR (LEN(:WS-PYMNT-START-DATE-2
              ) <> 10), CIS.CHAR2DATE(:WS-PYMNT-START-DATE-2
              ), CONVERT(DATE, :WS-PYMNT-START-DATE-2) ),                      
                    :WS-FN-INSTLT-AMT-D,                                
                    :WS-MN-INSTLT-AMT-D,                                
                    :WS-WO-TOT-ARRGMT-AMT-D,                            
                    IIF(TRY_CONVERT(DATE, :WS-FRCST-COLL-AGY-DT-2 
                                          :WS-FRCST-COLAGY-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :WS-FRCST-COLL-AGY-DT-2 
                                               :WS-FRCST-COLAGY-DT-NULL
              ) <> 0) OR (LEN(:WS-FRCST-COLL-AGY-DT-2 
                                               :WS-FRCST-COLAGY-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:WS-FRCST-COLL-AGY-DT-2 
                                               :WS-FRCST-COLAGY-DT-NULL
              ), CONVERT(DATE, :WS-FRCST-COLL-AGY-DT-2 
                                               :WS-FRCST-COLAGY-DT-NULL
              ) ),    
                    :WS-WO-MAX-BALANCE-D,                               
C30169              :WS-USER-ID,                                        
C30169              IIF(TRY_CONVERT(DATE, :WS-MN-TRANS-HIST-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-MN-TRANS-HIST-DT
              ) <> 0) OR (LEN(:WS-MN-TRANS-HIST-DT
              ) <> 10), CIS.CHAR2DATE(:WS-MN-TRANS-HIST-DT
              ), CONVERT(DATE, :WS-MN-TRANS-HIST-DT) ))                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_WO_ARRANGEMENT                                   
MFA-TR*            (ACCOUNT_NO,                                                 
MFA-TR*             PYMNT_START_DATE,                                           
MFA-TR*             FINL_INSTLLMNT_AMT,                                         
MFA-TR*             MTH_INSTLLMNT_AMT,                                          
MFA-TR*             WO_TOT_ARRGMT_AMT,                                          
MFA-TR*             FRCST_COLL_AGY_DT,                                          
MFA-TR*             WO_MAX_BALANCE,                                             
MFA-TR*             SETUP_BY_USERID,                                            
MFA-TR*             SETUP_DT)                                                   
MFA-TR*        VALUES                                                           
MFA-TR*            (:WS-ACCOUNT-NO,                                             
MFA-TR*             :WS-PYMNT-START-DATE-2,                                     
MFA-TR*             :WS-FN-INSTLT-AMT-D,                                        
MFA-TR*             :WS-MN-INSTLT-AMT-D,                                        
MFA-TR*             :WS-WO-TOT-ARRGMT-AMT-D,                                    
MFA-TR*             :WS-FRCST-COLL-AGY-DT-2:WS-FRCST-COLAGY-DT-NULL,            
MFA-TR*             :WS-WO-MAX-BALANCE-D,                                       
MFA-TR*             :WS-USER-ID,                                                
MFA-TR*             :WS-MN-TRANS-HIST-DT)                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO S-RETURN-CODE.              
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF (SQLCODE NOT EQUAL TO SUCCESSFUL-CALL)                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8000'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT'              TO ABEND-FUNCTION              
CBSI          MOVE 'CSS_WO_ARRANGEMENT'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
CBSI          MOVE 'PYMNT_START_DATE'    TO TABLE-ELEMENT-2             
CBSI          MOVE 'FINL_INSTLLMNT_AMT'  TO TABLE-ELEMENT-3             
CBSI          MOVE 'FRCST_COLL_AGY_DT'   TO TABLE-ELEMENT-4             
              MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
CBSI          MOVE WS-PYMNT-START-DATE-2 TO HOSTVAR-ELEMENT-2           
CBSI          MOVE WS-FN-INSTLT-AMT      TO HOSTVAR-ELEMENT-3           
CBSI          MOVE WS-FRCST-COLL-AGY-DT-2 TO HOSTVAR-ELEMENT-4          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
        8000-EXIT.                                                      
            EXIT.                                                       
                                                                        
                                                                        
      ******************************************************************        
      *8200-UPDATE-WO-ARRANGEMENTS                                     *        
      *    -- THIS MODULE UPDATES TABLE CSS_WO_ARRANGEMENT WITH THE NEW*        
      *       TERMS IF A CUSTOMER MODIFIED THEIR WRITE OFF PAYMENT     *        
      *       ARRANGEMENT.                                             *        
      ******************************************************************        
       8200-UPDATE-WO-ARRANGEMENT.                                      
                                                                        
               EXEC SQL                                                 
                   UPDATE CSS_WO_ARRANGEMENT                            
                      SET ACCOUNT_NO         = :WS-ACCOUNT-NO,          
                          PYMNT_START_DATE   = IIF(TRY_CONVERT(DATE, 
                                                 :WS-PYMNT-START-DATE-2
              ) IS NULL OR (PATINDEX('%.%', :WS-PYMNT-START-DATE-2
              ) <> 0) OR (LEN(:WS-PYMNT-START-DATE-2
              ) <> 10), CIS.CHAR2DATE(:WS-PYMNT-START-DATE-2
              ), CONVERT(DATE, :WS-PYMNT-START-DATE-2) ),  
                          FINL_INSTLLMNT_AMT = :WS-FN-INSTLT-AMT-D,     
                          MTH_INSTLLMNT_AMT  = :WS-MN-INSTLT-AMT-D,     
                          WO_TOT_ARRGMT_AMT  = :WS-WO-TOT-ARRGMT-AMT-D, 
                          FRCST_COLL_AGY_DT                             
                      = IIF(TRY_CONVERT(DATE, :WS-FRCST-COLL-AGY-DT-2 
                                              :WS-FRCST-COLAGY-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :WS-FRCST-COLL-AGY-DT-2 
                                               :WS-FRCST-COLAGY-DT-NULL
              ) <> 0) OR (LEN(:WS-FRCST-COLL-AGY-DT-2 
                                               :WS-FRCST-COLAGY-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:WS-FRCST-COLL-AGY-DT-2 
                                               :WS-FRCST-COLAGY-DT-NULL
              ), CONVERT(DATE, :WS-FRCST-COLL-AGY-DT-2 
                                               :WS-FRCST-COLAGY-DT-NULL
              ) ),
                          WO_MAX_BALANCE     = :WS-WO-MAX-BALANCE-D,    
C30169                    SETUP_BY_USERID    = :WS-USER-ID,             
C30169                    SETUP_DT           = IIF(TRY_CONVERT(DATE, 
                                                   :WS-MN-TRANS-HIST-DT
              ) IS NULL OR (PATINDEX('%.%', :WS-MN-TRANS-HIST-DT
              ) <> 0) OR (LEN(:WS-MN-TRANS-HIST-DT
              ) <> 10), CIS.CHAR2DATE(:WS-MN-TRANS-HIST-DT
              ), CONVERT(DATE, :WS-MN-TRANS-HIST-DT) )     
                    WHERE ACCOUNT_NO         = :WG-ACCOUNT-NO           
               END-EXEC.                                                

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*        EXEC SQL                                                         
MFA-TR*            UPDATE CSS_WO_ARRANGEMENT                                    
MFA-TR*               SET ACCOUNT_NO         = :WS-ACCOUNT-NO,                  
MFA-TR*                   PYMNT_START_DATE   = :WS-PYMNT-START-DATE-2,          
MFA-TR*                   FINL_INSTLLMNT_AMT = :WS-FN-INSTLT-AMT-D,             
MFA-TR*                   MTH_INSTLLMNT_AMT  = :WS-MN-INSTLT-AMT-D,             
MFA-TR*                   WO_TOT_ARRGMT_AMT  = :WS-WO-TOT-ARRGMT-AMT-D,         
MFA-TR*                   FRCST_COLL_AGY_DT                                     
MFA-TR*               = :WS-FRCST-COLL-AGY-DT-2:WS-FRCST-COLAGY-DT-NULL,        
MFA-TR*                   WO_MAX_BALANCE     = :WS-WO-MAX-BALANCE-D,            
MFA-TR*                   SETUP_BY_USERID    = :WS-USER-ID,                     
MFA-TR*                   SETUP_DT           = :WS-MN-TRANS-HIST-DT             
MFA-TR*             WHERE ACCOUNT_NO         = :WG-ACCOUNT-NO                   
MFA-TR*        END-EXEC.                                                        

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO S-RETURN-CODE.              
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF ((SQLCODE EQUAL TO SUCCESSFUL-CALL) OR                    
               (SQLCODE EQUAL TO NOT-FOUND))                            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8200'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_WO_ARRANGEMENT'  TO TABLE-1                     
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
CBSI          MOVE 'PYMNT_START_DATE'    TO TABLE-ELEMENT-2             
CBSI          MOVE 'FINL_INSTLLMNT_AMT'  TO TABLE-ELEMENT-3             
CBSI          MOVE 'FRCST_COLL_AGY_DT'   TO TABLE-ELEMENT-4             
              MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
CBSI          MOVE WS-PYMNT-START-DATE-2 TO HOSTVAR-ELEMENT-2           
CBSI          MOVE WS-FN-INSTLT-AMT      TO HOSTVAR-ELEMENT-3           
CBSI          MOVE WS-FRCST-COLL-AGY-DT-2 TO HOSTVAR-ELEMENT-4          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 8300-DELETE-WO-ARRANGEMENT.                                    *        
      *    -- THIS MODULE DELETES WRITE OFF PAYMENT ARRANGEMENTS FROM  *        
      *       TABLE CSS_WO_ARRANGEMENTS FOR AN ACCOUNT.                *        
      ******************************************************************        
       8300-DELETE-WO-ARRANGEMENT.                                      
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_WO_ARRANGEMENT                           
               WHERE ACCOUNT_NO = :WG-ACCOUNT-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO S-RETURN-CODE.              
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF (SQLCODE NOT EQUAL TO SUCCESSFUL-CALL)                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8300'                TO ACTIVE-PARAGRAPH            
              MOVE 'DELETE'              TO ABEND-FUNCTION              
              MOVE 'CSS_WO_ARRANGEMENT'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C30169******************************************************************        
C30169* 8410-UPD-FINAL-ACTION.                                         *        
C30169******************************************************************        
C30169*                                                                         
C30169 8410-UPD-FINAL-ACTION.                                           
C30169                                                                  
C30169      EXEC SQL                                                    
C30169          UPDATE CSS_FIN_WO_ACTION                                
C30169             SET FW_ACTION_DT      = IIF(TRY_CONVERT(DATE, 
                                                       :KD-FW-ACTION-DT
              ) IS NULL OR (PATINDEX('%.%', :KD-FW-ACTION-DT
              ) <> 0) OR (LEN(:KD-FW-ACTION-DT) <> 10), CIS.CHAR2DATE(
                                                       :KD-FW-ACTION-DT
              ), CONVERT(DATE, :KD-FW-ACTION-DT) )             
C30169           WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO               
C30169             AND FW_ACTION_TYPE_CD = :KD-FW-ACTION-TYPE-CD        
C30169             AND FW_SEQ_NO         = :KD-FW-SEQ-NO                
C30169      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*         UPDATE CSS_FIN_WO_ACTION                                        
MFA-TR*            SET FW_ACTION_DT      = :KD-FW-ACTION-DT                     
MFA-TR*          WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO                       
MFA-TR*            AND FW_ACTION_TYPE_CD = :KD-FW-ACTION-TYPE-CD                
MFA-TR*            AND FW_SEQ_NO         = :KD-FW-SEQ-NO                        
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30169                                                                  
C30169     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
C30169                                                                  
C30169     IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL OR NOT-FOUND     
C30169        CONTINUE                                                  
C30169     ELSE                                                         
C30169        MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
C30169        MOVE '8410'                      TO ACTIVE-PARAGRAPH      
C30169        MOVE 'UPDATE'                    TO ABEND-FUNCTION        
C30169        MOVE SPACES                      TO ABEND-SQL-PREDICATES  
C30169                                            ABEND-TABLES          
C30169        MOVE 'CSS_FIN_WO_ACTION'         TO TABLE-1               
C30169        MOVE 'ACCOUNT_NO'                TO TABLE-ELEMENT-1       
C30169        MOVE 'ACTION TYPE CD'            TO TABLE-ELEMENT-2       
C30169        MOVE 'SEQ NO '                   TO TABLE-ELEMENT-3       
C30169        MOVE WS-ACCOUNT-NO               TO HOSTVAR-ELEMENT-1     
C30169        MOVE KD-FW-ACTION-TYPE-CD        TO HOSTVAR-ELEMENT-2     
C30169        MOVE KD-FW-SEQ-NO                TO HOSTVAR-ELEMENT-3     
C30169        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
C30169        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
C30169     END-IF.                                                      
C30169                                                                  
C30169 8410-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                         
C30169******************************************************************        
C30169* 8500-UPD-FINAL-COLLECTION.                                     *        
C30169******************************************************************        
C30169*                                                                         
C30169 8500-UPD-FINAL-COLLECTION.                                       
C30169                                                                  
C30169      EXEC SQL                                                    
C30169          UPDATE CSS_FIN_WO_COLLECT                               
C30169             SET WITHDRAW_DT       = IIF(TRY_CONVERT(DATE, 
                                                        :IZ-WITHDRAW-DT
              ) IS NULL OR (PATINDEX('%.%', :IZ-WITHDRAW-DT
              ) <> 0) OR (LEN(:IZ-WITHDRAW-DT) <> 10), CIS.CHAR2DATE(
                                                        :IZ-WITHDRAW-DT
              ), CONVERT(DATE, :IZ-WITHDRAW-DT) )              
C30169           WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO               
C30169             AND FW_ACTION_TYPE_CD = :IZ-FW-ACTION-TYPE-CD        
C30169             AND FW_COLL_SEQ_NO    = :IZ-FW-COLL-SEQ-NO           
C30169      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*         UPDATE CSS_FIN_WO_COLLECT                                       
MFA-TR*            SET WITHDRAW_DT       = :IZ-WITHDRAW-DT                      
MFA-TR*          WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO                       
MFA-TR*            AND FW_ACTION_TYPE_CD = :IZ-FW-ACTION-TYPE-CD                
MFA-TR*            AND FW_COLL_SEQ_NO    = :IZ-FW-COLL-SEQ-NO                   
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30169                                                                  
C30169     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
C30169                                                                  
C30169     IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL OR NOT-FOUND     
C30169        CONTINUE                                                  
C30169     ELSE                                                         
C30169        MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
C30169        MOVE '8500'                      TO ACTIVE-PARAGRAPH      
C30169        MOVE 'UPDATE'                    TO ABEND-FUNCTION        
C30169        MOVE SPACES                      TO ABEND-SQL-PREDICATES  
C30169                                            ABEND-TABLES          
C30169        MOVE 'CSS_FIN_WO_COLLECT'        TO TABLE-1               
C30169        MOVE 'ACCOUNT_NO'                TO TABLE-ELEMENT-1       
C30169        MOVE 'ACTION TYPE CD'            TO TABLE-ELEMENT-2       
C30169        MOVE 'SEQ NO'                    TO TABLE-ELEMENT-3       
C30169        MOVE WS-ACCOUNT-NO               TO HOSTVAR-ELEMENT-1     
C30169        MOVE IZ-FW-ACTION-TYPE-CD        TO HOSTVAR-ELEMENT-2     
C30169        MOVE IZ-FW-COLL-SEQ-NO           TO HOSTVAR-ELEMENT-3     
C30169        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
C30169        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
C30169     END-IF.                                                      
C30169                                                                  
C30169 8500-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                         
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
                                                                        
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
      ******************************************************************        
      * 9999- END PROGRAM COPYLIB                                      *        
      ******************************************************************        
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPD00321                                                  
REARCH     END-EXEC.                                                            
