       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02309.                                         
COB303 DATE-WRITTEN.      JANUARY 15, 1995.                             
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
      *                                                                *000000  
      *  TRANID:        S309                                           *00120000
      *  PROGRAM:       S309                                           *00130000
      *  CALLING SP:    PA_S309                                        *00140000
      *  PANEL:         475 -- WRITE-OFF ARRANGEMENTS.                 *00141000
      *                                                                *00142000
      ******************************************************************00143000
      *                 P R O G R A M  S U M M A R Y                   *00144000
      *                                                                *00145000
      *  THIS PROCEDURE RETRIEVES PAYMENT AGREEMENTS FOR WRITTEN OFF   *00146000
      *  ACCOUNTS                                                      *00147000
      *                                                                *00148000
      ******************************************************************00149000
      *                                                                *00150000
      *                     PROGRAM MODIFICATION LOG                   *00160000
      *                                                                *00170000
      *    DATE    INITIALS   COMMENTS                                 *00180000
      *  --------  --------   ---------------------------------------  *00190000
      *  01/15/95    CDS      PROCEDURE ORIGINALLY CODED.              *00200000
T13784*  11/24/97    BAB      PROGRAM NEEDS TO RETURN THE COLLECTION   *00201000
      *                       AGENCY AMOUNT.                           *00202000
T16956*  06/26/98   ZB17046   MADE CHANGE TO AVOID -305 ERROR IN       *        
      *                       SELECT FOR CSS_FINAL_WO AND              *        
      *                       CSS_WO_ARRANGEMENT.                      *        
CBSI  *  12/22/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *              MADRAS   ABEND PARAMETERS                         *        
      *                                                                *00210000
REARCH*  06/20/05    CVNS     RPC TO COBOL SP CONVERSION               *        
REARCH*              CHENNAI                                           *        
C30169*  03/03/08    CVNS     SET THE ARRANGEMENT DATE,FORECASTED CRED *        
C30169*              CHENNAI  BUREAU DATE AND USER ID WHO IS CREATING  *        
C30169*                       FOR THAT ARRANGEMENT                     *        
      ******************************************************************00220000
      ******************************************************************00230000
      *                                                                *00240000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00250000
      *                                                                *00260000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00270000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00280000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00290000
      *  3000 - 4999  NOT USED                                         *00300000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00310000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00320000
      *  7000 - 7999  INPUT MODULES                                    *00330000
      *  8000 - 8999  OUTPUT MODULES                                   *00340000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00350000
      *                                                                *00360000
      ******************************************************************00370000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02309'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                    PIC X(40) VALUE                  
REARCH     'WORKING STORAGE FOR CSR02309 STARTS HERE'.                  
                                                                        
      ******************************************************************00460000
      *    DB2 INCLUDES                                                *00470000
      ******************************************************************00480000
                                                                        
           EXEC SQL                                                     00500000
              INCLUDE SQLCA                                             00510000
           END-EXEC.                                                    00520000
                                                                        
           EXEC SQL                                                     00540000
              INCLUDE TBMODEL                                           00550000
           END-EXEC.                                                    00560000
                                                                        
           EXEC SQL                                                     00580000
              INCLUDE TBWOARGM                                          00590000
           END-EXEC.                                                    00600000
                                                                        
           EXEC SQL                                                     00620000
              INCLUDE TBFINLWO                                          00630000
           END-EXEC.                                                    00640000
                                                                        
C30169******************************************************************        
C30169* CSS_USER_PROFILE.                                              *        
C30169******************************************************************        
C30169     EXEC SQL                                                     00620000
C30169        INCLUDE TBUSRPRF                                          00630000
C30169     END-EXEC.                                                    00640000
      *                                                                 00650000
C30169******************************************************************        
C30169* CSS_FIN_WO_ACTION.                                             *        
C30169******************************************************************        
C30169     EXEC SQL                                                     00620000
C30169        INCLUDE TBFWACTN                                          00630000
C30169     END-EXEC.                                                    00640000
      *                                                                         
C30169******************************************************************        
C30169* CSS_FW_FCST_ACTION.                                            *        
C30169******************************************************************        
C30169     EXEC SQL                                                     00620000
C30169        INCLUDE TBFWPDTL                                          00630000
C30169     END-EXEC.                                                    00640000
      *                                                                 00650000
C30169******************************************************************        
C30169* CSS_REG_PROFILE.                                               *        
C30169******************************************************************        
C30169     EXEC SQL                                                     00620000
C30169        INCLUDE TBREGPRF                                          00630000
C30169     END-EXEC.                                                    00640000
      *                                                                 00650000
C30169******************************************************************        
C30169* CSS_ACCOUNT.                                                   *        
C30169******************************************************************        
C30169     EXEC SQL                                                     00620000
C30169        INCLUDE TBACCT                                            00630000
C30169     END-EXEC.                                                    00640000
      *                                                                         
      ******************************************************************00670000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00680000
      ******************************************************************00690000
                                                                        
REARCH*    COPY SYGWCOB.                                                00710000
REARCH*    COPY SYDBCOB.                                                00720000
           COPY CCA00001.                                               00730000
REARCH*    COPY CWS00010.                                               00740000
           COPY CWS00027.                                               00750000
           COPY CWS00303.                                               00760000
                                                                        
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CWSX0010                                                  
REARCH     END-EXEC.                                                            
      ******************************************************************00780000
      *    WORK AREAS                                                  *00790000
      ******************************************************************00800000
                                                                        
           05  WS-FW-COLLECTION-DT-NI  PIC S9(4) COMP VALUE 0.          
           05  WS-WG-PYMNT-START-DATE-NI                                
                                       PIC S9(4) COMP VALUE 0.          
           05  WS-WG-FRCST-COLL-AGY-DT PIC S9(4) COMP VALUE 0.          
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  RS-REDEFINITIONS.                                            
           05  WS-ACCOUNT-PARM         PIC X(13).                       
           05  WS-ACCOUNT-DEC REDEFINES WS-ACCOUNT-PARM                 
                                       PIC 9(13).                       
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.        
                                                                        
       01  RS-REDEFINITIONS.                                            
           05  WS-ITEM-ID              PIC S9(9) USAGE COMP VALUE 0.    
                                                                        
       01  WS-PROGRAM-NAME.                                             
           05  PROGRAM-NAME            PIC X(04) VALUE 'S309'.          
                                                                        
                                                                        
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05  IND-COLLECTION-AM-NULL  PIC S9(04) COMP.                 
           05  IND-COLLECTION-DT-NULL  PIC S9(04) COMP.                 
           05  WS-CB-ACTION-DATE-NULL  PIC S9(04) COMP.                 
           05  WS-ARRANGEMENT-DATE-NULL PIC S9(04) COMP VALUE 0.        
                                                                        
       01  TDS-RETURN-FIELDS.                                           
COB305     05 RS-MONTHLY-INSTALLMNT-AMT        PIC S9(09)V99 
COB305       USAGE COMP-3 VALUE 0.     
COB305     05 RS-FINL-INSTLLMNT-AMT        PIC S9(09)V99 USAGE COMP-3 
COB305       VALUE 0.     
           05  RS-PYMNT-START-DATE     PIC X(10)      VALUE SPACES.     
           05  RS-FRCT-COLL-AGY-DT     PIC X(10)      VALUE SPACES.     
COB305     05 RS-WO-TOT-ARRGMT-AMT        PIC S9(09)V99 USAGE COMP-3 
COB305       VALUE 0.     
                                                                        
COB305     05 RS-COLLECTION-AMT        PIC S9(09)V99 USAGE COMP-3 
COB305       VALUE 0.     
T13784     05  RS-RETURN-CODE          PIC S9(9)      COMP VALUE 0.     
C30169     05  RS-ARRANGEMENT-DATE     PIC X(10)      VALUE SPACES.     
C30169     05  RS-USER-NAME            PIC X(39)      VALUE SPACES.     
C30169     05  RS-CB-ACTION-DATE       PIC X(10)      VALUE SPACES.     
C30169     05  RS-FW-ACTION-TYPE-CD    PIC X(05)      VALUE SPACES.     
C30169     05  RS-FW-SEQ-NO            PIC S9(4)  USAGE COMP VALUE +0.  
C30169     05  RS-FW-ACTION-DAYS-NM    PIC S9(5)V USAGE COMP-3 VALUE +0.
C30169*                                                                         
REARCH 01  GTT-RETURN-FIELDS.                                           
COB305     05 S-MONTHLY-INSTALLMNT-AMT        PIC S9(09)V99 
COB305       USAGE COMP-3 VALUE 0.     
COB305     05 S-FINL-INSTLLMNT-AMT        PIC S9(09)V99 USAGE COMP-3 
COB305       VALUE 0.     
REARCH     05  S-PYMNT-START-DATE      PIC X(10)      VALUE SPACES.     
REARCH     05  S-FRCT-COLL-AGY-DT      PIC X(10)      VALUE SPACES.     
COB305     05 S-WO-TOT-ARRGMT-AMT        PIC S9(09)V99 USAGE COMP-3 
COB305       VALUE 0.     
COB305     05 S-COLLECTION-AMT        PIC S9(09)V99 USAGE COMP-3 
COB305       VALUE 0.     
REARCH     05  S-RETURN-CODE           PIC S9(9)      COMP VALUE 0.     
C30169     05  S-ARRANGEMENT-DATE      PIC X(10)      VALUE SPACES.     
C30169     05  S-USER-NAME             PIC X(39)      VALUE SPACES.     
C30169     05  S-CB-ACTION-DATE        PIC X(10)      VALUE SPACES.     
C30169     05  S-FW-ACTION-TYPE-CD     PIC X(05)      VALUE SPACES.     
C30169     05  S-FW-SEQ-NO             PIC S9(4)  USAGE COMP VALUE +0.  
C30169     05  S-FW-ACTION-DAYS-NM     PIC S9(5)V USAGE COMP-3 VALUE +0.
C30169*                                                                         
                                                                        
REARCH  01 CSRERLOG-P.                                                  
REARCH      10 S-SP-NAME           PIC X(18) VALUE SPACES.              
REARCH      10 S-SQLCODE           PIC S9(9) COMP VALUE 0.              
REARCH      10 S-SQLSTATE          PIC X(5)  VALUE ' '.                 
REARCH      10 S-TABLE-NAME        PIC X(18) VALUE SPACES.              
REARCH      10 S-HOST-VAIABLES.                                         
REARCH         49 S-HOST-VARIABLES-L PIC S9(4) USAGE COMP.              
REARCH         49 S-HOST-VARIABLES-V PIC X(255).                        
REARCH      10 S-SQL-STATEMENT.                                         
REARCH         49 S-SQL-STATEMENT-L  PIC S9(4) USAGE COMP.              
REARCH         49 S-SQL-STATEMENT-V  PIC X(255).                        
REARCH      10 S-SQL-DESCRIPTION.                                       
REARCH         49 S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.             
REARCH         49 S-SQL-DESCRIPTION-V PIC X(255).                       
                                                                        
C30169  01 WS-MISC.                                                     
C30169      10 WS-USER-ID             PIC X(07) VALUE SPACES.           
C30169      10 WS-ARRANGEMENT-DATE    PIC X(10) VALUE '1900-01-01'.     
C30169      10 WS-CB-ACTION-DATE      PIC X(10) VALUE '1900-01-01'.     
C30169      10 WS-CURRENT-DATE        PIC X(10) VALUE SPACES.           
C30169      10 WS-PREV-CHAR           PIC X(01) VALUE SPACES.           
C30169      10 WS-FORMAT              PIC X(01) VALUE 'N'.              
C30169         88 FORMAT-DONE                   VALUE 'Y'.              
C30169      10 WS-CA206-LAST-RUN-DATE    PIC X(10) VALUE SPACES.        
C30169      10 WS-PARM-DATA              PIC X(80).                     
C30169      10 WS-LAST-RUN-DATE-PARM.                                   
C30169         15 FILLER               PIC X(14) VALUE 'LAST RUN DATE='.
C30169         15 WS-LAST-RUN-DATE     PIC X(10) VALUE SPACES.          
C30169         15 FILLER               PIC X(56) VALUE SPACES.          
C30169      10 WS-SEQ-NO               PIC S9(09) COMP VALUE 0.         
                                                                        
C30169 01 WS-NAME-TABLES.                                               
C30169    05 WS-F-NAME.                                                 
C30169       10 WS-FIRST-CHAR          PIC X(01)                        
C30169                      OCCURS 12 TIMES INDEXED BY WS-IDX-F.        
C30169    05 WS-M-NAME.                                                 
C30169       10 WS-MIDDLE-CHAR         PIC X(01)                        
C30169                      OCCURS 10 TIMES INDEXED BY WS-IDX-M.        
C30169    05 WS-L-NAME.                                                 
C30169       10 WS-LAST-CHAR           PIC X(01)                        
C30169                      OCCURS 15 TIMES INDEXED BY WS-IDX-L.        
C30169    05 WS-FULL-NAME-1.                                            
C30169       10 WS-FULL-CHAR           PIC X(01)                        
C30169                      OCCURS 39 TIMES INDEXED BY WS-IDX-N.        
C30169                                                                  
HPCCDM*EJECT                                                            01660000
                                                                        
REARCH LINKAGE SECTION.                                                 
REARCH 01 PARM-ACCOUNT-NO           PIC X(13).                          
REARCH*                                                                         
REARCH PROCEDURE DIVISION USING PARM-ACCOUNT-NO.                        
                                                                        
      ******************************************************************01710000
      * 0000-MAINLINE                                                  *01730000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *01740000
      ******************************************************************01750000
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************01870000
      * 0100-INITIALIZE                                                *01880000
      *                                                                *01890000
      *     1. RESET DB2 ERROR HANDLERS                                *01900000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *01910000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *01920000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*01930000
      *                                                                *01940000
      ******************************************************************01950000
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 7050-SELECT-CURRENT-DATE   THRU 7050-EXIT.           
REARCH*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.     02020000
REARCH*                                                                 02030000
REARCH*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,     02040000
REARCH*                          SNA-CONNECTION-NAME, SNA-SUBC.         02050000
REARCH*                                                                 02060000
REARCH*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                      02070000
REARCH*                                                                 02080000
REARCH*    IF GWL-RC NOT = TDS-PARM-PRESENT                             02090000
REARCH*        MOVE PROGRAM-NAME    TO ABEND-PROGRAM                    02100000
REARCH*        MOVE '0100'          TO ACTIVE-PARAGRAPH                 02110000
REARCH*        MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION     02120000
REARCH*        MOVE 'CICS TRANSACTION'   TO TABLE-1                     02130000
REARCH*        MOVE GWL-RC               TO WS-ACTIVE-RETURN-CODE       02140000
REARCH*        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           02150000
REARCH*        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           02160000
REARCH*    END-IF.                                                      02170000
REARCH*                                                                 02180000
REARCH       EXEC SQL                                                   
REARCH       DECLARE C1 CURSOR  FOR                          
REARCH       SELECT                                                     
REARCH            :S-MONTHLY-INSTALLMNT-AMT  AS MNTHLY_INSTMNT_AMT      
REARCH            ,:S-FINL-INSTLLMNT-AMT     AS FINL_INSTLLMNT_AMT      
REARCH            ,:S-PYMNT-START-DATE       AS PYMNT_START_DATE        
REARCH            ,:S-FRCT-COLL-AGY-DT       AS FRCT_COLL_AGY_DT        
REARCH            ,:S-RETURN-CODE            AS RETURN_CODE             
REARCH            ,:S-WO-TOT-ARRGMT-AMT      AS WO_TOT_ARRGMT_AMT       
REARCH            ,:S-COLLECTION-AMT         AS COLLECTION_AM           
C30169            ,:S-ARRANGEMENT-DATE       AS ARRANGEMENT_DATE        
C30169            ,:S-USER-NAME              AS USER_NAME               
C30169            ,:S-CB-ACTION-DATE         AS CB_ACTION_DATE          
C30169            ,:S-FW-ACTION-TYPE-CD      AS FW_ACTION_TYPE_CD       
C30169            ,:S-FW-SEQ-NO              AS FW_SEQ_NO               
C30169            ,:S-FW-ACTION-DAYS-NM      AS FW_ACTION_DAYS_NM       
REARCH       FROM                                                       
REARCH            CIS.SYSDUMMY1                                      
REARCH       END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*      EXEC SQL                                                           
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*           :S-MONTHLY-INSTALLMNT-AMT  AS MNTHLY_INSTMNT_AMT              
MFA-TR*           ,:S-FINL-INSTLLMNT-AMT     AS FINL_INSTLLMNT_AMT              
MFA-TR*           ,:S-PYMNT-START-DATE       AS PYMNT_START_DATE                
MFA-TR*           ,:S-FRCT-COLL-AGY-DT       AS FRCT_COLL_AGY_DT                
MFA-TR*           ,:S-RETURN-CODE            AS RETURN_CODE                     
MFA-TR*           ,:S-WO-TOT-ARRGMT-AMT      AS WO_TOT_ARRGMT_AMT               
MFA-TR*           ,:S-COLLECTION-AMT         AS COLLECTION_AM                   
MFA-TR*           ,:S-ARRANGEMENT-DATE       AS ARRANGEMENT_DATE                
MFA-TR*           ,:S-USER-NAME              AS USER_NAME                       
MFA-TR*           ,:S-CB-ACTION-DATE         AS CB_ACTION_DATE                  
MFA-TR*           ,:S-FW-ACTION-TYPE-CD      AS FW_ACTION_TYPE_CD               
MFA-TR*           ,:S-FW-SEQ-NO              AS FW_SEQ_NO                       
MFA-TR*           ,:S-FW-ACTION-DAYS-NM      AS FW_ACTION_DAYS_NM               
MFA-TR*      FROM                                                               
MFA-TR*           SYSIBM.SYSDUMMY1                                              
MFA-TR*      END-EXEC.                                                          
       0100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************02230000
      * 1000-PROCESS-INPUT                                             *02240000
      *                                                                *02250000
      *     1. RECEIVE PARMS.                                          *02260000
      *                                                                *02270000
      ******************************************************************02280000
       1000-PROCESS-INPUT.                                              
                                                                        
REARCH*    PERFORM 1100-RECEIVE-PARMS     THRU 1100-EXIT.               02310000
           PERFORM 1150-ASSIGN-WS-VARS    THRU 1150-EXIT.               
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************02380000
      * 1100-RECEIVE-PARMS                                             *02390000
      *                                                                *02400000
      *     RECEIVE EACH PARAMETER FROM THE REMOTE PROCEDURE           *02410000
      *                                                                *02420000
      ******************************************************************02430000
REARCH*1100-RECEIVE-PARMS.                                              02440000
REARCH*                                                                 02450000
REARCH*    MOVE 1                          TO PARM-ID1.                 02460000
REARCH*    MOVE LENGTH OF PARM-ACCOUNT-NO  TO MAX-LENGTH-PARM,          02470000
REARCH*                                                                 02480000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              02490000
REARCH*                          GWL-RC,                                02500000
REARCH*                          PARM-ID1,                              02510000
REARCH*                          PARM-ACCOUNT-NO,                       02520000
REARCH*                          TDSCHAR,                               02530000
REARCH*                          MAX-LENGTH-PARM,                       02540000
REARCH*                          PARM-L.                                02550000
REARCH*                                                                 02560000
REARCH*1100-EXIT.                                                       02570000
REARCH*    EXIT.                                                        02580000
                                                                        
                                                                        
      ******************************************************************02610000
      * 1150 ASSIGN-WS-VARS                                            *02620000
      *     -- THIS MODULE MOVES THE PASSED IN PARAMETER VALUES AND    *02630000
      *        MOVES THEM INTO WORKING STORAGE VARIABLES.  THEN,       *02640000
      *        THESE WORKING STORAGE VARIABLES ARE MOVED INTO THEIR    *02650000
      *        RESPECTIVE REDEFINED FIELDS FOR COMPLETING THE SQL      *02660000
      *        SELECT STATEMENTS.                                      *02670000
      ******************************************************************02680000
       1150-ASSIGN-WS-VARS.                                             
                                                                        
           MOVE PARM-ACCOUNT-NO       TO WS-ACCOUNT-PARM.               
           MOVE WS-ACCOUNT-DEC        TO WS-ACCOUNT-NO.                 
           MOVE WS-ACCOUNT-NO         TO WG-ACCOUNT-NO.                 
           MOVE WS-ACCOUNT-NO         TO FW-ACCOUNT-NO.                 
           MOVE WS-ITEM-ID            TO FW-ITEM-ID.                    
                                                                        
       1150-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************02810000
      * 2000-PROCESS-OUTPUT.                                           *02820000
      *                                                                *02830000
      *     1. DESCRIBE RESULT SET                                     *02840000
      *     2. FETCH CASH IRR-LETTER DETAIL INFORMATION                *02850000
      *                                                                *02860000
      ******************************************************************02870000
       2000-PROCESS-OUTPUT.                                             
                                                                        
REARCH*    PERFORM 2100-DESCRIBE-RESULT            THRU 2100-EXIT.      02900000
           PERFORM 2200-WO-AGGREEMENT-DETAILS      THRU 2200-EXIT.      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
REARCH******************************************************************02950000
REARCH*2000A-MOVE-RESULT                                                        
REARCH******************************************************************        
REARCH*****************************************************************         
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE RS-MONTHLY-INSTALLMNT-AMT TO S-MONTHLY-INSTALLMNT-AMT   
REARCH     MOVE RS-FINL-INSTLLMNT-AMT     TO S-FINL-INSTLLMNT-AMT       
REARCH     MOVE RS-PYMNT-START-DATE       TO S-PYMNT-START-DATE         
REARCH     MOVE RS-FRCT-COLL-AGY-DT       TO S-FRCT-COLL-AGY-DT         
REARCH     MOVE RS-WO-TOT-ARRGMT-AMT      TO S-WO-TOT-ARRGMT-AMT        
REARCH     MOVE RS-COLLECTION-AMT         TO S-COLLECTION-AMT           
REARCH     MOVE RS-RETURN-CODE            TO S-RETURN-CODE.             
C30169     MOVE RS-ARRANGEMENT-DATE       TO S-ARRANGEMENT-DATE.        
C30169     MOVE RS-USER-NAME              TO S-USER-NAME.               
C30169     MOVE RS-CB-ACTION-DATE         TO S-CB-ACTION-DATE.          
C30169     MOVE RS-FW-ACTION-TYPE-CD      TO S-FW-ACTION-TYPE-CD.       
C30169     MOVE RS-FW-SEQ-NO              TO S-FW-SEQ-NO.               
C30169     MOVE RS-FW-ACTION-DAYS-NM      TO S-FW-ACTION-DAYS-NM.       
C30169*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
      ******************************************************************        
                                                                        
      ******************************************************************02970000
      * 2100-DESCRIBE-RESULT                                           *02980000
      *                                                                *02990000
      *     DESCRIBE EACH COLUMN IN THE RESULT SET.                    *03000000
      *                                                                *03010000
      ******************************************************************03020000
REARCH*2100-DESCRIBE-RESULT.                                            03030000
REARCH*                                                                 03040000
REARCH*    MOVE 1                               TO CTR-COLUMN.          03050000
REARCH*    MOVE TDSDECIMAL                      TO DB-HOST-TYPE.        03060000
REARCH*    MOVE TDSFLT8                         TO DB-CLIENT-TYPE.      03070000
REARCH*    MOVE LENGTH OF RS-MONTHLY-INSTALLMNT-AMT TO WRKLEN1.         03080000
REARCH*    MOVE LENGTH OF CN-MONTHLY-INSTALLMNT-AMT TO WRKLEN2.         03090000
REARCH*                                                                 03100000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              03110000
REARCH*                          GWL-RC,                                03120000
REARCH*                          CTR-COLUMN,                            03130000
REARCH*                          DB-HOST-TYPE,                          03140000
REARCH*                          WRKLEN1,                               03150000
REARCH*                          RS-MONTHLY-INSTALLMNT-AMT,             03160000
REARCH*                          DB-NULL-INDICATOR,                     03170000
REARCH*                          TDS-FALSE,                             03180000
REARCH*                          DB-CLIENT-TYPE,                        03190000
REARCH*                          WRKLEN1,                               03200000
REARCH*                          CN-MONTHLY-INSTALLMNT-AMT,             03210000
REARCH*                          WRKLEN2.                               03220000
REARCH*                                                                 03230000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     03240000
REARCH*                                                                 03250000
REARCH*    MOVE +2 TO WRKLEN2.                                          03260000
REARCH*    CALL 'TDSETBCD' USING GWL-PROC,                              03270000
REARCH*                          GWL-RC,                                03280000
REARCH*                          TDS-OBJECT-COL,                        03290000
REARCH*                          CTR-COLUMN,                            03300000
REARCH*                          WRKLEN1,                               03310000
REARCH*                          WRKLEN2.                               03320000
REARCH*                                                                 03330000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     03340000
REARCH*                                                                 03350000
REARCH*    ADD 1                                TO CTR-COLUMN.          03360000
REARCH*    MOVE TDSDECIMAL                      TO DB-HOST-TYPE.        03370000
REARCH*    MOVE TDSFLT8                         TO DB-CLIENT-TYPE.      03380000
REARCH*    MOVE LENGTH OF RS-FINL-INSTLLMNT-AMT TO WRKLEN1.             03390000
REARCH*    MOVE LENGTH OF CN-FINL-INSTLLMNT-AMT TO WRKLEN2.             03400000
REARCH*                                                                 03410000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              03420000
REARCH*                          GWL-RC,                                03430000
REARCH*                          CTR-COLUMN,                            03440000
REARCH*                          DB-HOST-TYPE,                          03450000
REARCH*                          WRKLEN1,                               03460000
REARCH*                          RS-FINL-INSTLLMNT-AMT,                 03470000
REARCH*                          DB-NULL-INDICATOR,                     03480000
REARCH*                          TDS-FALSE,                             03490000
REARCH*                          DB-CLIENT-TYPE,                        03500000
REARCH*                          WRKLEN1,                               03510000
REARCH*                          CN-FINL-INSTLLMNT-AMT,                 03520000
REARCH*                          WRKLEN2.                               03530000
REARCH*                                                                 03540000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     03550000
REARCH*                                                                 03560000
REARCH*    MOVE +2 TO WRKLEN2.                                          03570000
REARCH*    CALL 'TDSETBCD' USING GWL-PROC,                              03580000
REARCH*                          GWL-RC,                                03590000
REARCH*                          TDS-OBJECT-COL,                        03600000
REARCH*                          CTR-COLUMN,                            03610000
REARCH*                          WRKLEN1,                               03620000
REARCH*                          WRKLEN2.                               03630000
REARCH*                                                                 03640000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     03650000
REARCH*                                                                 03660000
REARCH*    ADD 1                                TO CTR-COLUMN.          03670000
REARCH*    MOVE TDSCHAR                         TO DB-HOST-TYPE.        03680000
REARCH*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.      03690000
REARCH*    MOVE LENGTH OF RS-PYMNT-START-DATE   TO WRKLEN1.             03700000
REARCH*    MOVE LENGTH OF CN-PYMNT-START-DATE   TO WRKLEN2.             03710000
REARCH*                                                                 03720000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              03730000
REARCH*                          GWL-RC,                                03740000
REARCH*                          CTR-COLUMN,                            03750000
REARCH*                          DB-HOST-TYPE,                          03760000
REARCH*                          WRKLEN1,                               03770000
REARCH*                          RS-PYMNT-START-DATE,                   03780000
REARCH*                          DB-NULL-INDICATOR,                     03790000
REARCH*                          TDS-FALSE,                             03800000
REARCH*                          DB-CLIENT-TYPE,                        03810000
REARCH*                          WRKLEN1,                               03820000
REARCH*                          CN-PYMNT-START-DATE,                   03830000
REARCH*                          WRKLEN2.                               03840000
REARCH*                                                                 03850000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     03860000
REARCH*                                                                 03870000
REARCH*    ADD 1                                TO CTR-COLUMN.          03880000
REARCH*    MOVE TDSCHAR                         TO DB-HOST-TYPE.        03890000
REARCH*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.      03900000
REARCH*    MOVE LENGTH OF RS-FRCT-COLL-AGY-DT   TO WRKLEN1.             03910000
REARCH*    MOVE LENGTH OF CN-FRCT-COLL-AGY-DT   TO WRKLEN2.             03920000
REARCH*                                                                 03930000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              03940000
REARCH*                          GWL-RC,                                03950000
REARCH*                          CTR-COLUMN,                            03960000
REARCH*                          DB-HOST-TYPE,                          03970000
REARCH*                          WRKLEN1,                               03980000
REARCH*                          RS-FRCT-COLL-AGY-DT,                   03990000
REARCH*                          DB-NULL-INDICATOR,                     04000000
REARCH*                          TDS-FALSE,                             04010000
REARCH*                          DB-CLIENT-TYPE,                        04020000
REARCH*                          WRKLEN1,                               04030000
REARCH*                          CN-FRCT-COLL-AGY-DT,                   04040000
REARCH*                          WRKLEN2.                               04050000
REARCH*                                                                 04060000
REARCH*   PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                      04070000
REARCH*                                                                 04080000
REARCH*    ADD 1                                TO CTR-COLUMN.          04090000
REARCH*    MOVE TDSINT4                         TO DB-HOST-TYPE.        04100000
REARCH*    MOVE TDSINT4                         TO DB-CLIENT-TYPE.      04110000
REARCH*    MOVE LENGTH OF RS-RETURN-CODE        TO WRKLEN1.             04120000
REARCH*    MOVE LENGTH OF CN-RETURN-CODE        TO WRKLEN2.             04130000
REARCH*                                                                 04140000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              04150000
REARCH*                          GWL-RC,                                04160000
REARCH*                          CTR-COLUMN,                            04170000
REARCH*                          DB-HOST-TYPE,                          04180000
REARCH*                          WRKLEN1,                               04190000
REARCH*                          RS-RETURN-CODE,                        04200000
REARCH*                          DB-NULL-INDICATOR,                     04210000
REARCH*                          TDS-FALSE,                             04220000
REARCH*                          DB-CLIENT-TYPE,                        04230000
REARCH*                          WRKLEN1,                               04240000
REARCH*                          CN-RETURN-CODE,                        04250000
REARCH*                          WRKLEN2.                               04260000
REARCH*                                                                 04270000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     04280000
REARCH*                                                                 04290000
REARCH*    ADD 1                                TO CTR-COLUMN.          04300000
REARCH*    MOVE TDSDECIMAL                      TO DB-HOST-TYPE.        04310000
REARCH*    MOVE TDSFLT8                         TO DB-CLIENT-TYPE.      04320000
REARCH*    MOVE LENGTH OF RS-WO-TOT-ARRGMT-AMT  TO WRKLEN1.             04330000
REARCH*    MOVE LENGTH OF CN-WO-TOT-ARRGMT-AMT  TO WRKLEN2.             04340000
REARCH*                                                                 04350000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              04360000
REARCH*                          GWL-RC,                                04370000
REARCH*                          CTR-COLUMN,                            04380000
REARCH*                          DB-HOST-TYPE,                          04390000
REARCH*                          WRKLEN1,                               04400000
REARCH*                          RS-WO-TOT-ARRGMT-AMT,                  04410000
REARCH*                          DB-NULL-INDICATOR,                     04420000
REARCH*                          TDS-FALSE,                             04430000
REARCH*                          DB-CLIENT-TYPE,                        04440000
REARCH*                          WRKLEN1,                               04450000
REARCH*                          CN-WO-TOT-ARRGMT-AMT,                  04460000
REARCH*                          WRKLEN2.                               04470000
REARCH*                                                                 04480000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     04490000
REARCH*                                                                 04500000
T13784*    ADD 1                                TO CTR-COLUMN.          04501001
T13784*    MOVE TDSDECIMAL                      TO DB-HOST-TYPE.        04502001
T13784*    MOVE TDSFLT8                         TO DB-CLIENT-TYPE.      04503001
T13784*    MOVE LENGTH OF RS-COLLECTION-AMT     TO WRKLEN1.             04504001
T13784*    MOVE LENGTH OF CN-COLLECTION-AMT     TO WRKLEN2.             04505001
REARCH*                                                                 04506001
T13784*    CALL 'TDESCRIB' USING GWL-PROC,                              04507001
REARCH*                          GWL-RC,                                04508001
REARCH*                          CTR-COLUMN,                            04509001
REARCH*                          DB-HOST-TYPE,                          04509101
REARCH*                          WRKLEN1,                               04509201
REARCH*                          RS-COLLECTION-AMT,                     04509301
REARCH*                          DB-NULL-INDICATOR,                     04509401
REARCH*                          TDS-FALSE,                             04509501
REARCH*                          DB-CLIENT-TYPE,                        04509601
REARCH*                          WRKLEN1,                               04509701
REARCH*                          CN-COLLECTION-AMT,                     04509801
REARCH*                          WRKLEN2.                               04509901
REARCH*                                                                 04510001
T13784*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     04510101
REARCH*                                                                 04510201
REARCH*    MOVE +2 TO WRKLEN2.                                          04511000
REARCH*    CALL 'TDSETBCD' USING GWL-PROC,                              04520000
REARCH*                          GWL-RC,                                04530000
REARCH*                          TDS-OBJECT-COL,                        04540000
REARCH*                          CTR-COLUMN,                            04550000
REARCH*                          WRKLEN1,                               04560000
REARCH*                          WRKLEN2.                               04570000
REARCH*                                                                 04580000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     04590000
REARCH*                                                                 04600000
REARCH*2100-EXIT.                                                       04610000
REARCH*    EXIT.                                                        04620000
                                                                        
                                                                        
      ******************************************************************04650000
      * 2200-WO-AGGREEMENT-DETAILS                                     *04660000
      *    -- THIS MODULE OPENS THE IRR-LETTER CURSOR, FETCHES THE     *04670000
      *       DETAIL INFORMATION FOR EACH GUARANTOR, SENDS THE RESULT, *04680000
      *       AND THEN CLOSES THE CURSOR.                              *04690000
      ******************************************************************04700000
       2200-WO-AGGREEMENT-DETAILS.                                      
                                                                        
C30169     PERFORM 7700-SEL-CB-DATE           THRU 7700-EXIT.           
C30169     PERFORM 7500-SELECT-COMPANY-NO     THRU 7500-EXIT.           
C30169     PERFORM 7600-SELECT-REG-GROUP-CD   THRU 7600-EXIT.           
C30169     IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
C30169         MOVE SPACES                    TO LR-REG-GROUP-CD        
C30169     END-IF                                                       
C30169     PERFORM  2400-GET-LAST-RUN-DT      THRU 2400-EXIT.           
C30169     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND               
C30169        WS-CB-ACTION-DATE > WS-CA206-LAST-RUN-DATE                
C30169        MOVE WS-CB-ACTION-DATE         TO RS-CB-ACTION-DATE       
C30169     ELSE                                                         
C30169        MOVE '1900-01-01'              TO RS-CB-ACTION-DATE       
C30169     END-IF.                                                      
C30169*    PERFORM 7100-SELECT-FINAL-WO       THRU 7100-EXIT.           04730000
C30169     PERFORM 7100-SELECT-FIN-WO-ACTION  THRU 7100-EXIT.           
C30169     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C30169        MOVE KD-FW-ACTION-TYPE-CD       TO RS-FW-ACTION-TYPE-CD   
C30169        MOVE KD-FW-SEQ-NO               TO RS-FW-SEQ-NO           
C30169        MOVE KD-FW-ACTION-AM            TO RS-COLLECTION-AMT      
C30169     ELSE                                                         
C30169        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
C30169           MOVE SPACES                  TO KD-FW-ACTION-DT        
C30169           MOVE ZEROES                  TO RS-COLLECTION-AMT      
C30169           MOVE ZEROES                  TO RS-FW-SEQ-NO           
C30169        END-IF                                                    
C30169     END-IF.                                                      
C30169                                                                  
C30169     PERFORM 7400-SELECT-COLL-AGY-DT                              
C30169        THRU 7400-EXIT                                            
                                                                        
           PERFORM 7000-SELECT-WO-ARRANGEMENT THRU 7000-EXIT.           
                                                                        
           IF RS-RETURN-CODE = NOT-FOUND THEN                           
               MOVE SPACES                TO RS-PYMNT-START-DATE        
               MOVE ZEROES                TO RS-FINL-INSTLLMNT-AMT      
               MOVE ZEROES                TO RS-MONTHLY-INSTALLMNT-AMT  
               MOVE ZEROES                TO RS-WO-TOT-ARRGMT-AMT       
C30169         MOVE KD-FW-ACTION-DT       TO RS-FRCT-COLL-AGY-DT        
           ELSE                                                         
               MOVE WG-PYMNT-START-DATE   TO RS-PYMNT-START-DATE        
               MOVE WG-FINL-INSTLLMNT-AMT TO RS-FINL-INSTLLMNT-AMT      
               MOVE WG-MTH-INSTLLMNT-AMT  TO RS-MONTHLY-INSTALLMNT-AMT  
               MOVE WG-WO-TOT-ARRGMT-AMT  TO RS-WO-TOT-ARRGMT-AMT       
C30169         MOVE WG-FRCST-COLL-AGY-DT  TO RS-FRCT-COLL-AGY-DT        
C30169         IF WS-USER-ID > SPACES                                   
C30169           PERFORM 7300-SELECT-EMPLOYEE-NAME  THRU 7300-EXIT      
C30169           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
C30169              PERFORM 2600-FORMATING-NAME    THRU 2600-EXIT       
C30169              MOVE WS-FULL-NAME-1            TO RS-USER-NAME      
C30169           END-IF                                                 
C30169         END-IF                                                   
           END-IF.                                                      
                                                                        
C30169     MOVE WS-ARRANGEMENT-DATE       TO RS-ARRANGEMENT-DATE.       
                                                                        
                                                                        
REARCH     PERFORM 2000A-MOVE-RESULT         THRU 2000A-EXIT.           
REARCH     ADD +1                            TO CTR-ROWS.               
REARCH*    PERFORM 8100-SEND-RESULT          THRU 8100-EXIT.            04980000
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ******************************************************************        
      * 2400-GET-LAST-RUN-DT.                                          *        
      ******************************************************************        
      *                                                                         
       2400-GET-LAST-RUN-DT.                                            
                                                                        
           IF LR-REG-GROUP-CD = '100' THEN                              
               MOVE +100                    TO WS-SEQ-NO                
           ELSE                                                         
              IF LR-REG-GROUP-CD = '200' THEN                           
                 MOVE +200                  TO WS-SEQ-NO                
              ELSE                                                      
                 MOVE +10                   TO WS-SEQ-NO                
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 7040-SELECT-LAST-RUN-DT  THRU 7040-EXIT.             
                                                                        
           MOVE WS-PARM-DATA                TO WS-LAST-RUN-DATE-PARM.   
                                                                        
           MOVE WS-LAST-RUN-DATE            TO WS-CA206-LAST-RUN-DATE.  
                                                                        
       2400-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
                                                                        
C30169******************************************************************03490000
C30169* 2600-FORMATING-NAME.                                           *        
C30169* FORMATS THE NAME AS FOLLOWS (LAST, FIRST MIDDLE)               *03500000
C30169******************************************************************03560000
C30169*                                                                         
C30169 2600-FORMATING-NAME.                                             
C30169*                                                                         
C30169     MOVE PF-FIRST-NAME                   TO WS-F-NAME.           
C30169     MOVE PF-MIDDLE-NAME                  TO WS-M-NAME.           
C30169     MOVE PF-LAST-NAME                    TO WS-L-NAME.           
C30169                                                                  
C30169     MOVE SPACES                                TO WS-PREV-CHAR   
C30169                                                   WS-FORMAT.     
C30169     SET WS-IDX-N, WS-IDX-F, WS-IDX-M, WS-IDX-L TO 1.             
C30169*                                                                         
C30169     PERFORM UNTIL (WS-IDX-L > 15 OR FORMAT-DONE)                 
C30169        IF (WS-LAST-CHAR(WS-IDX-L) = SPACE OR LOW-VALUES          
C30169                                        OR HIGH-VALUES)           
C30169          AND (WS-PREV-CHAR = SPACE OR LOW-VALUES OR HIGH-VALUES) 
C30169          IF WS-IDX-N > 1                                         
C30169             SET WS-IDX-N DOWN BY 1                               
C30169             MOVE ','                   TO WS-FULL-CHAR(WS-IDX-N) 
C30169             SET WS-IDX-N UP BY 1                                 
C30169          END-IF                                                  
C30169          MOVE 'Y'                      TO WS-FORMAT              
C30169        ELSE                                                      
C30169          MOVE WS-LAST-CHAR(WS-IDX-L)   TO WS-FULL-CHAR(WS-IDX-N) 
C30169                                           WS-PREV-CHAR           
C30169          SET WS-IDX-L, WS-IDX-N UP BY 1                          
C30169        END-IF                                                    
C30169     END-PERFORM.                                                 
C30169*                                                                         
C30169     MOVE SPACES                        TO WS-PREV-CHAR.          
C30169*                                                                         
C30169     PERFORM UNTIL WS-IDX-F > 12                                  
C30169        IF (WS-FIRST-CHAR(WS-IDX-F) = SPACE OR LOW-VALUES OR      
C30169                                               HIGH-VALUES)       
C30169           AND (WS-PREV-CHAR = SPACE OR LOW-VALUES OR HIGH-VALUES)
C30169           NEXT SENTENCE                                          
C30169        ELSE                                                      
C30169           MOVE WS-FIRST-CHAR(WS-IDX-F) TO WS-FULL-CHAR(WS-IDX-N) 
C30169                                           WS-PREV-CHAR           
C30169           SET WS-IDX-F, WS-IDX-N UP BY 1                         
C30169        END-IF                                                    
C30169     END-PERFORM.                                                 
C30169*                                                                         
C30169     MOVE SPACES                        TO WS-PREV-CHAR.          
C30169*                                                                         
C30169     PERFORM UNTIL WS-IDX-M > 10                                  
C30169        IF (WS-MIDDLE-CHAR(WS-IDX-M) = SPACE OR LOW-VALUES OR     
C30169                                             HIGH-VALUES)         
C30169          AND (WS-PREV-CHAR = SPACE OR LOW-VALUES OR HIGH-VALUES) 
C30169          NEXT SENTENCE                                           
C30169        ELSE                                                      
C30169          MOVE WS-MIDDLE-CHAR(WS-IDX-M) TO WS-FULL-CHAR(WS-IDX-N) 
C30169                                           WS-PREV-CHAR           
C30169          SET WS-IDX-M, WS-IDX-N UP BY 1                          
C30169        END-IF                                                    
C30169     END-PERFORM.                                                 
C30169*                                                                         
C30169 2600-EXIT.                                                       
C30169      EXIT.                                                       
C30169*                                                                         
      ******************************************************************05040000
      * 7000-SELECT-WO-ARRANGEMENT                                     *05050000
      *       -- THIS SELECTS THE WRITE OFF ARRANGEMENT FOR A WRITTEN  *05060000
      *          OFF ACCOUNT                                           *05070000
      ******************************************************************05080000
       7000-SELECT-WO-ARRANGEMENT.                                      
                                                                        
           EXEC SQL                                                     
                 SELECT PYMNT_START_DATE,                               
                      FINL_INSTLLMNT_AMT,                               
                      MTH_INSTLLMNT_AMT,                                
                      FRCST_COLL_AGY_DT,                                
                      WO_TOT_ARRGMT_AMT,                                
                      SETUP_DT,                                         
                      SETUP_BY_USERID                                   
T16956           INTO :WG-PYMNT-START-DATE :WS-WG-PYMNT-START-DATE-NI,   
                      :WG-FINL-INSTLLMNT-AMT,                           
                      :WG-MTH-INSTLLMNT-AMT,                            
T16956                :WG-FRCST-COLL-AGY-DT :WS-WG-FRCST-COLL-AGY-DT,    
                      :WG-WO-TOT-ARRGMT-AMT,                            
                      :WS-ARRANGEMENT-DATE :WS-ARRANGEMENT-DATE-NULL,    
                      :WS-USER-ID                                       
                 FROM  CSS_WO_ARRANGEMENT                               
                 WHERE ACCOUNT_NO     = :WG-ACCOUNT-NO                  
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO RS-RETURN-CODE                              
                           WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
T16956         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
T16956             IF WS-WG-PYMNT-START-DATE-NI < 0                     
T16956                 MOVE SPACES TO WG-PYMNT-START-DATE               
T16956             END-IF                                               
T16956             IF WS-WG-FRCST-COLL-AGY-DT < 0                       
T16956                 MOVE SPACES TO WG-FRCST-COLL-AGY-DT              
T16956             END-IF                                               
T16956         END-IF                                                   
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                  OR WS-ARRANGEMENT-DATE-NULL < 0                       
                  MOVE '1900-01-01'       TO WS-ARRANGEMENT-DATE        
               END-IF                                                   
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE '7000'                TO ACTIVE-PARAGRAPH           
CBSI           MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_WO_ARRANGEMENT'  TO TABLE-1                    
               MOVE 'ACCOUNT NO'          TO TABLE-ELEMENT-1            
               MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7040-SELECT-LAST-RUN-DT.                                       *        
      ******************************************************************        
      *                                                                         
       7040-SELECT-LAST-RUN-DT.                                         
      *                                                                         
            EXEC SQL                                                    
                SELECT TOP(1) PARM_DATA                                         
                INTO                                                    
                     :WS-PARM-DATA                                      
                FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                         
                WHERE                                                   
                    PROGRAM_NAME = 'PCSCA206'                           
                AND COMPANY_NO   = :AT-COMPANY-NO                       
                AND CMND_CODE    = 'PARM'                               
                AND STATUS       = 'A'                                  
                AND SEQ_NO       = :WS-SEQ-NO                           
                                           
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT                                                          
MFA-TR*              PARM_DATA                                                  
MFA-TR*         INTO                                                            
MFA-TR*              :WS-PARM-DATA                                              
MFA-TR*         FROM CSS_JOB_PARM                                               
MFA-TR*         WHERE                                                           
MFA-TR*             PROGRAM_NAME = 'PCSCA206'                                   
MFA-TR*         AND COMPANY_NO   = :AT-COMPANY-NO                               
MFA-TR*         AND CMND_CODE    = 'PARM'                                       
MFA-TR*         AND STATUS       = 'A'                                          
MFA-TR*         AND SEQ_NO       = :WS-SEQ-NO                                   
MFA-TR*         FETCH FIRST 1 ROW ONLY WITH UR                                  
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.   
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
                MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE             
                MOVE PROGRAM-NAME          TO ABEND-PROGRAM             
                MOVE '7040'                TO ACTIVE-PARAGRAPH          
                MOVE 'SELECT'              TO ABEND-FUNCTION            
                MOVE 'CSS_JOB_PARM'        TO TABLE-1                   
                MOVE 'PROGRAM_NAME'        TO TABLE-ELEMENT-1           
                MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2           
                MOVE 'SEQ-NO'              TO TABLE-ELEMENT-3           
                MOVE 'PCSCA206'            TO HOSTVAR-ELEMENT-1         
                MOVE AT-COMPANY-NO         TO HOSTVAR-ELEMENT-2         
                MOVE WS-SEQ-NO             TO HOSTVAR-ELEMENT-3         
                PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT         
                PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT         
            END-IF.                                                     
                                                                        
       7040-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
                                                                        
C30169******************************************************************        
C30169* 7050-SELECT-CURRENT-DATE .                                     *05330000
C30169******************************************************************05330000
C30169                                                                  
C30169 7050-SELECT-CURRENT-DATE .                                       
C30169                                                                  
C30169     EXEC SQL                                                     
C30169         SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                      
C30169     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-DATE = CURRENT DATE                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30169                                                                  
C30169      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
C30169         NEXT SENTENCE                                            
C30169      ELSE                                                        
C30169         MOVE PROGRAM-NAME    TO ABEND-PROGRAM                    
C30169         MOVE '7050'          TO ACTIVE-PARAGRAPH                 
C30169         MOVE 'SET'           TO ABEND-FUNCTION                   
C30169         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
C30169         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
C30169      END-IF.                                                     
C30169                                                                  
C30169 7050-EXIT.                                                       
C30169     EXIT.                                                        
C30169                                                                  
C30169******************************************************************05470000
C30169* 7100-SELECT-FIN-WO-ACTION                                      *05480000
C30169*       -- THIS SELECTS FINAL WRITE OFF DATA FOR A WRITTEN OFF   *05490000
C30169*          ACCOUNT                                               *05500000
C30169******************************************************************05510000
C30169*                                                                         
C30169 7100-SELECT-FIN-WO-ACTION.                                       
C30169                                                                  
C30169     EXEC SQL                                                     
C30169         SELECT TOP(1) FW_ACTION_TYPE_CD,
              FW_ACTION_DT,
              FW_ACTION_AM,
              FW_SEQ_NO                                         
C30169           INTO :KD-FW-ACTION-TYPE-CD,                            
C30169                :KD-FW-ACTION-DT,                                 
C30169                :KD-FW-ACTION-AM,                                 
C30169                :KD-FW-SEQ-NO                                     
C30169          FROM  CSS_FIN_WO_ACTION                                 
C30169          WHERE ACCOUNT_NO     = :WG-ACCOUNT-NO                   
C30169            AND FW_ACTION_TYPE_CD IN ('1PLMT','2PLMT','3PLMT')    
C30169            AND FW_ACTION_DT   >= IIF(TRY_CONVERT(DATE, 
                                                :WS-CA206-LAST-RUN-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CA206-LAST-RUN-DATE
              ) <> 0) OR (LEN(:WS-CA206-LAST-RUN-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-CA206-LAST-RUN-DATE
              ), CONVERT(DATE, :WS-CA206-LAST-RUN-DATE) )         
C30169            AND FW_ACTION_AM   = 0                                
C30169            ORDER BY FW_ACTION_DT                                 
C30169                                            
C30169     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     05540000
MFA-TR*        SELECT FW_ACTION_TYPE_CD,                                05550000
MFA-TR*               FW_ACTION_DT,                                     05560000
MFA-TR*               FW_ACTION_AM,                                             
MFA-TR*               FW_SEQ_NO                                                 
MFA-TR*          INTO :KD-FW-ACTION-TYPE-CD,                            05570000
MFA-TR*               :KD-FW-ACTION-DT,                                         
MFA-TR*               :KD-FW-ACTION-AM,                                         
MFA-TR*               :KD-FW-SEQ-NO                                             
MFA-TR*         FROM  CSS_FIN_WO_ACTION                                 05590000
MFA-TR*         WHERE ACCOUNT_NO     = :WG-ACCOUNT-NO                   05600000
MFA-TR*           AND FW_ACTION_TYPE_CD IN ('1PLMT','2PLMT','3PLMT')            
MFA-TR*           AND FW_ACTION_DT   >= :WS-CA206-LAST-RUN-DATE                 
MFA-TR*           AND FW_ACTION_AM   = 0                                        
MFA-TR*           ORDER BY FW_ACTION_DT                                         
MFA-TR*           FETCH FIRST 1 ROW ONLY                                        
MFA-TR*    END-EXEC.                                                    05620000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30169                                                                  
C30169     MOVE SQLCODE TO RS-RETURN-CODE                               
C30169                     WS-ACTIVE-RETURN-CODE.                       
C30169                                                                  
C30169     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C30169         NEXT SENTENCE                                            
C30169     ELSE                                                         
C30169         MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
C30169         MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
C30169         MOVE '7100'                     TO ACTIVE-PARAGRAPH      
C30169         MOVE 'SELECT'                   TO ABEND-FUNCTION        
C30169         MOVE 'CSS_FIN_WO_ACTION'        TO TABLE-1               
C30169         MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
C30169         MOVE WG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
C30169         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
C30169         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
C30169     END-IF.                                                      
C30169                                                                  
C30169 7100-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                 05860000
C30169******************************************************************05470000
C30169* 7300-SELECT-EMPLOYEE-NAME.                                     *05480000
C30169******************************************************************05510000
C30169 7300-SELECT-EMPLOYEE-NAME.                                       
C30169                                                                  
C30169     EXEC SQL                                                     
C30169         SELECT FIRST_NAME,                                       
C30169                LAST_NAME,                                        
C30169                MIDDLE_NAME                                       
C30169          INTO  :PF-FIRST-NAME,                                   
C30169                :PF-LAST-NAME,                                    
C30169                :PF-MIDDLE-NAME                                   
C30169          FROM  CSS_USER_PROFILE                                  
C30169          WHERE USER_ID    = :WS-USER-ID                          
C30169     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30169                                                                  
C30169     MOVE SQLCODE TO RS-RETURN-CODE                               
C30169                     WS-ACTIVE-RETURN-CODE.                       
C30169                                                                  
C30169     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C30169         NEXT SENTENCE                                            
C30169     ELSE                                                         
C30169         MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
C30169         MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
C30169         MOVE '7300'                     TO ACTIVE-PARAGRAPH      
C30169         MOVE 'SELECT'                   TO ABEND-FUNCTION        
C30169         MOVE 'CSS_USER_PROFILE'         TO TABLE-1               
C30169         MOVE 'USER_ID'                  TO TABLE-ELEMENT-1       
C30169         MOVE WS-USER-ID                 TO HOSTVAR-ELEMENT-1     
C30169         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
C30169         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
C30169     END-IF.                                                      
C30169                                                                  
C30169 7300-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                 05860000
C30169******************************************************************05470000
C30169* 7400-SELECT-COLL-AGY-DT.                                       *05480000
C30169******************************************************************05510000
C30169*                                                                         
C30169 7400-SELECT-COLL-AGY-DT.                                         
C30169                                                                  
C30169     EXEC SQL                                                     
C30169         SELECT  F8.FW_FCST_DAYS_NM                               
C30169           INTO  :RS-FW-ACTION-DAYS-NM                            
C30169           FROM  CSS_FW_FCST_ACTION F8                            
C30169          WHERE  F8.EFFECTIVE_DT      <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )         
C30169            AND  F8.EXPIRATION_DT     >= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )         
C30169            AND  F8.FW_PATH_TYPE_CD   = 'DE'                      
C30169            AND  F8.FW_ACTION_TYPE_CD = 'APLMT'                   
C30169            AND  F8.COMPANY_NO        = :AT-COMPANY-NO            
C30169            AND  F8.REG_GROUP_CD      = :LR-REG-GROUP-CD          
C30169     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     05540000
MFA-TR*        SELECT  F8.FW_FCST_DAYS_NM                                       
MFA-TR*          INTO  :RS-FW-ACTION-DAYS-NM                                    
MFA-TR*          FROM  CSS_FW_FCST_ACTION F8                                    
MFA-TR*         WHERE  F8.EFFECTIVE_DT      <= :WS-CURRENT-DATE                 
MFA-TR*           AND  F8.EXPIRATION_DT     >= :WS-CURRENT-DATE                 
MFA-TR*           AND  F8.FW_PATH_TYPE_CD   = 'DE'                              
MFA-TR*           AND  F8.FW_ACTION_TYPE_CD = 'APLMT'                           
MFA-TR*           AND  F8.COMPANY_NO        = :AT-COMPANY-NO                    
MFA-TR*           AND  F8.REG_GROUP_CD      = :LR-REG-GROUP-CD                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30169                                                                  
C30169     MOVE SQLCODE TO RS-RETURN-CODE                               
C30169                     WS-ACTIVE-RETURN-CODE.                       
C30169                                                                  
C30169     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C30169         NEXT SENTENCE                                            
C30169     ELSE                                                         
C30169         MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
C30169         MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
C30169         MOVE '7400'                     TO ACTIVE-PARAGRAPH      
C30169         MOVE 'SELECT'                   TO ABEND-FUNCTION        
C30169         MOVE 'CSS_FW_FCST_ACTION'       TO TABLE-1               
C30169         MOVE 'REG-GROUP-CD'             TO TABLE-ELEMENT-1       
C30169         MOVE LR-REG-GROUP-CD            TO HOSTVAR-ELEMENT-1     
C30169         MOVE 'COMPANY-NO'               TO TABLE-ELEMENT-2       
C30169         MOVE AT-COMPANY-NO              TO HOSTVAR-ELEMENT-2     
C30169         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
C30169         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
C30169     END-IF.                                                      
C30169                                                                  
C30169 7400-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                 05860000
C30169******************************************************************05470000
C30169* 7500-SELECT-COMPANY-NO.                                        *05480000
C30169******************************************************************05510000
C30169*                                                                         
C30169 7500-SELECT-COMPANY-NO.                                          
C30169                                                                  
C30169     EXEC SQL                                                     
C30169         SELECT COMPANY_NO                                        
C30169           INTO :AT-COMPANY-NO                                    
C30169           FROM CSS_ACCOUNT                                       
C30169          WHERE ACCOUNT_NO       = :WG-ACCOUNT-NO                 
C30169     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30169                                                                  
C30169     MOVE SQLCODE TO RS-RETURN-CODE                               
C30169                     WS-ACTIVE-RETURN-CODE.                       
C30169                                                                  
C30169     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C30169         NEXT SENTENCE                                            
C30169     ELSE                                                         
C30169         MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
C30169         MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
C30169         MOVE '7500'                     TO ACTIVE-PARAGRAPH      
C30169         MOVE 'SELECT'                   TO ABEND-FUNCTION        
C30169         MOVE 'CSS_ACCOUNT'              TO TABLE-1               
C30169         MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
C30169         MOVE WG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
C30169         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
C30169         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
C30169     END-IF.                                                      
C30169                                                                  
C30169 7500-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                 05860000
C30169******************************************************************05470000
C30169* 7600-SELECT-REG-GROUP-CD.                                      *05480000
C30169******************************************************************05510000
C30169*                                                                         
C30169 7600-SELECT-REG-GROUP-CD.                                        
C30169                                                                  
C30169     EXEC SQL                                                     
C30169         SELECT REG_GROUP_CD                                      
C30169           INTO :LR-REG-GROUP-CD                                  
C30169           FROM CSS_REG_PROFILE                                   
C30169          WHERE ACCOUNT_NO       = :WG-ACCOUNT-NO                 
C30169     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30169                                                                  
C30169     MOVE SQLCODE TO RS-RETURN-CODE                               
C30169                     WS-ACTIVE-RETURN-CODE.                       
C30169                                                                  
C30169     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C30169         NEXT SENTENCE                                            
C30169     ELSE                                                         
C30169         MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
C30169         MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
C30169         MOVE '7600'                     TO ACTIVE-PARAGRAPH      
C30169         MOVE 'SELECT'                   TO ABEND-FUNCTION        
C30169         MOVE 'CSS_ACCOUNT'              TO TABLE-1               
C30169         MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
C30169         MOVE WG-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
C30169         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
C30169         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
C30169     END-IF.                                                      
C30169                                                                  
C30169 7600-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                 05860000
C30169******************************************************************        
C30169* 7700-SEL-CB-DATE.                                              *        
C30169******************************************************************        
C30169*                                                                         
C30169 7700-SEL-CB-DATE.                                                
C30169                                                                  
C30169     EXEC SQL                                                     
C30169        SELECT MAX(FW_ACTION_DT)                                  
C30169          INTO :WS-CB-ACTION-DATE :WS-CB-ACTION-DATE-NULL          
C30169          FROM CSS_FIN_WO_ACTION                                  
C30169         WHERE ACCOUNT_NO        =:WG-ACCOUNT-NO                  
C30169           AND FW_ACTION_TYPE_CD = 'CREDB'                        
C30169     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30169                                                                  
C30169     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
C30169                                                                  
C30169     IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL OR NOT-FOUND     
C30169        IF WS-CB-ACTION-DATE-NULL < 0                             
C30169           MOVE '1900-01-01'             TO WS-CB-ACTION-DATE     
C30169        END-IF                                                    
C30169     ELSE                                                         
C30169        MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
C30169        MOVE '7700'                      TO ACTIVE-PARAGRAPH      
C30169        MOVE 'SELECT'                    TO ABEND-FUNCTION        
C30169        MOVE SPACES                      TO ABEND-SQL-PREDICATES  
C30169                                            ABEND-TABLES          
C30169        MOVE 'CSS_FIN_WO_ACTION'         TO TABLE-1               
C30169        MOVE 'ACCOUNT_NO'                TO TABLE-ELEMENT-1       
C30169        MOVE WG-ACCOUNT-NO               TO HOSTVAR-ELEMENT-1     
C30169        PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           
C30169        PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           
C30169     END-IF.                                                      
C30169*                                                                         
C30169 7700-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                         
                                                                        
      ******************************************************************05880000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *05890000
      ******************************************************************05900000
REARCH*    EXEC SQL                                                     05910000
REARCH*       INCLUDE CPD00300                                          05920000
REARCH*    END-EXEC.                                                    05930000
                                                                        
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
                                                                        
      ******************************************************************05960000
      * 9999- END PROGRAM COPYLIB                                      *05970000
      ******************************************************************05980000
REARCH*    COPY CPD00302.                                               05990000
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPD00321                                                  
REARCH     END-EXEC.                                                            
                                                                        
                                                                        
