       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02308.                                         
COB303 DATE-WRITTEN.  JUNE 30, 2005.                                    
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00080000
      *                                                                *00090000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00100000
      *                                                                *00110000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00120000
      *                                                                *00130000
      *  TRANID:        S308.                                          *00140000
      *  PROGRAM:       S308.                                          *00150000
      *  CALLING SP:    PA_S308.                                       *00160000
      *                                                                *00170000
      ******************************************************************00180000
      *                 P R O G R A M  S U M M A R Y                   *00190000
      *                                                                *00200000
      *  THIS RPC WILL BE CALLED BY THE 'CLOSE BATCH' PANEL AND 'CLOSE *00190000
      *  REPORT' PANEL FOR GETTING GL ACCT NBR, DESC AND CORRESPONDING *00190000
      *  AMOUNT FOR A LOCAL OFFICE AND DATE FROM CSS_CSH_DRWR_JRNL.    *00190000
      *                                                                *00200000
      *  THE RPC DISTINGUISHES BETWEEN 'CLOSE BATCH' PANEL AND THE     *00200000
      *  'CLOSE REPORT' PANEL BY CHECKING THE USER-ID.                 *00200000
      *                                                                *00200000
      ******************************************************************00230000
      *                                                                *00240000
      *                     PROGRAM MODIFICATION LOG                   *00250000
      *                                                                *00260000
      *    DATE    INITIALS   COMMENTS                                 *00270000
      *  --------  --------   ---------------------------------------  *00280000
      *  10-05-1999 CBSI      ORIGINALLY CODED                         *        
      *  03-29-2000 S.E.K.    INCREASED THE LENGTH OF THE ARRAY AND    *        
      *                       THE TABLE LIMIT.                         *        
C25923*  02/27/02   BASKAR    1.ADD DRAFT IN THE CURRENCY TYPE         *        
C25923*                       2.CORRECT BANK TRANSFER AMOUNT           *        
C32216*  02/10/05   LAT       WS-TABLE-LENGTH IS INITIALIZED TO FIX THE*        
C32216*                       CLOSE BATCH PROBLEM.                     *        
REARCH*  06/30/05   CVNS      RPC TO COBOL SP CONVERSION               *        
REARCH*             CHENNAI                                            *        
A37342*  03/14/09   SV95326   IMPROVE PERFORMANCE - ADDING ROWSET      *        
A37342*                       POSITIONING FOR GLOBAL TEMP TABLES  &    *        
A37342*                       WITH UR CHANGES TO CURSORS.              *        
P00641*  05/01/12   DB41297  GET GL-ACCT-NAME-DESC FROM CSS_GL_ACCT_NO *        
A04527*  09/20/13   MR7E794   REMOVED THE UNUSED CODE.                 *        
      ******************************************************************01310000
      ******************************************************************01320000
      *                                                                *01330000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *01340000
      *                                                                *01350000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *01360000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *01370000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *01380000
      *  3000 - 4999  NOT USED                                         *01390000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *01400000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *01410000
      *  7000 - 7999  INPUT MODULES                                    *01420000
      *  8000 - 8999  OUTPUT MODULES                                   *01430000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *01440000
      *                                                                *01450000
      ******************************************************************01460000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02308'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                    PIC X(40)        VALUE           
REARCH     'WORKING STORAGE FOR CSR02308 STARTS HERE'.                  
                                                                        
      ******************************************************************01550000
      *    COBOL WORKING STORAGE COPY BOOKS                            *01560000
      ******************************************************************01570000
                                                                        
           COPY CWS00303.                                               01700000
           COPY CJF00101.                                               01700000
REARCH*                                                                         
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CWSX0010                                                 
REARCH     END-EXEC.                                                            
                                                                        
      ******************************************************************01760000
      *    WORK AREAS                                                  *01770000
      ******************************************************************01780000
                                                                        
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  GTT-NAME                PIC X(26)                        
REARCH                                     VALUE 'SESSION.CSR02308_R1'. 
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN          PIC S9(04) COMP.                 
REARCH         49 GTT-ROW-CHAR         PIC X(1024).                     
REARCH     05  GTT-SQLCODE             PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11)        VALUE           
                                                        'PARM FIELDS'.  
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9)        COMP.           
           05  SNA-CONNECTION-NAME     PIC X(8)         VALUE           
                                                        SPACES.         
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9)        COMP            
                                                        VALUE 1.        
           05  CTR-ROWS                PIC S9(9)        COMP            
                                                        VALUE 0.        
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9)        COMP.           
           05  WRKLEN1                 PIC S9(9)        COMP.           
           05  WRKLEN2                 PIC S9(9)        COMP.           
           05  WRK-DONE-STATUS         PIC S9(9)        COMP.           
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME            PIC X(8)         VALUE           
REARCH                                                  'CSR02308'.     
REARCH     05  WS-SQLSTATE             PIC X(05).                       
           05  WS-ONE                  PIC S9(1)        VALUE +1.       
           05  ALL-DONE-SW             PIC X(1)         VALUE 'N'.      
               88 NOT-ALL-DONE                          VALUE 'N'.      
               88 ALL-DONE                              VALUE 'Y'.      
           05  SEND-DONE-SW            PIC X(1)         VALUE 'Y'.      
               88 SEND-DONE-ERROR                       VALUE 'N'.      
               88 SEND-DONE-OK                          VALUE 'Y'.      
                                                                        
                                                                        
       01  WS-GEN-LED-RETURN-DATA.                                      
           05 WS-GEN-LED-ACCT-DETAILS  OCCURS 41 TIMES                  
                                       INDEXED BY WS-GL-INDEX.          
COB305        10 WS-GEN-LED-ACCT-NO        PIC S9(3)V9(4) COMP-3 
COB305           VALUE 0.         
COB305        10 WS-AMOUNT-POSTED        PIC S9(9)V9(2) COMP-3 VALUE 0.         
                                                                        
       01  WS-NULL-INDICATOR.                                           
           05 WS-NULL-INDICATOR1       PIC S9(4)        COMP            
                                                        VALUE +0.       
           05 WS-NULL-INDICATOR2       PIC S9(4)        COMP            
                                                        VALUE +0.       
           05 WS-NULL-INDICATOR3       PIC S9(4)        COMP            
                                                        VALUE +0.       
                                                                        
       01  WS-WORK-FIELDS.                                              
COB305     05 WS-SUB        PIC S9(04) COMP-3 VALUE 0.         
           05 WS-TABLE-LENGTH          PIC S9(04)       COMP-3          
                                                        VALUE 0.        
           05 WS-USER-LOW              PIC X(07).                       
           05 WS-USER-HIGH             PIC X(07).                       
           05 WS-JRNL-RETURN-CODE      PIC S9(09)       COMP-4.         
           05 WS-CNTL-RETURN-CODE      PIC S9(09)       COMP-4.         
COB305     05 WS-TEMP-ACCT-NO        PIC S9(03)V9(04) COMP-3 VALUE 0.         
           05 WS-GL-ACCT-NO-ED         PIC 9(03).9(04).                 
           05 WS-CLEAR-CASH            PIC X(08)        VALUE           
                                                        'CLR-CASH'.     
COB305     05 WS-CLR-CASH-ACCT-NO        PIC S9(03)V9(04) COMP-3 
COB305       VALUE 0.         
           05 WS-DEPOSITABLE-AMT       PIC S9(11)V9(02) COMP-3          
                                                        VALUE 0.        
           05 WS-PREV-BANK-TRANS       PIC S9(11)V9(02) COMP-3          
                                                        VALUE 0.        
           05 WS-PREV-BANK-TRANS1      PIC S9(11)V9(02) COMP-3          
                                                        VALUE 0.        
           05 WS-PREV-BANK-TRANS2      PIC S9(11)V9(02) COMP-3          
                                                        VALUE 0.        
           05 WS-TOTAL-BANKTRANS       PIC S9(11)V9(02) COMP-3          
                                                        VALUE 0.        
C25923     05 WS-BANK-TRANS            PIC S9(11)V9(02)                 
C25923                                     COMP-3 VALUE +0.             
           05 WS-PROCESS               PIC X(02).                       
              88 CLOSE-BATCH                            VALUE 'CB'.     
              88 CLOSE-REPORT                           VALUE 'CR'.     
           05 WS-CURRENCY-TYPE         PIC X(01).                       
              88 CASH                                   VALUE 'A'.      
              88 CHECK                                  VALUE 'C'.      
              88 MONEY-ORDER                            VALUE 'M'.      
C25923        88 DRAFT                                  VALUE 'D'.      
           05 WS-MULTI-BATCH-COUNT     PIC S9(04)       COMP            
                                                        VALUE 0.        
       01  WS-FLAG-VALUES.                                              
           05 WS-YES                   PIC X(1)         VALUE 'Y'.      
           05 WS-NO                    PIC X(1)         VALUE 'N'.      
           05 WS-C                     PIC X(1)         VALUE 'C'.      
           05 WS-D                     PIC X(1)         VALUE 'D'.      
           05 WS-99                    PIC X(3)         VALUE '099'.    
           05 WS-GL-ACCT-FLAG          PIC X(1)         VALUE 'N'.      
           05 WS-LIHEAP-PMT            PIC X(1)         VALUE 'N'.      
           05 WS-LIHEAP-RVSL           PIC X(1)         VALUE 'N'.      
           05 WS-FOUND                 PIC X(1)         VALUE 'N'.      
           05 WS-TABLE-LIMIT           PIC S9(2)        VALUE  40.      
                                                                        
       01  FILLER                      PIC X(32)        VALUE           
                'THIS IS THE ROW RETURN AREA.'.                         
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(09)       COMP VALUE 0.   
COB305     05 RS-GL-ACCT-NO        PIC S9(03)V9(04) COMP-3 VALUE 0.         
           05  RS-GL-ACCT-NAME         PIC X(25).                       
COB305     05 RS-TOTAL-GL-AMT        PIC S9(11)V9(02) COMP-3 VALUE 0.         
COB305     05 RS-WORK-FUND-TOTAL        PIC S9(13)V9(02) COMP-3 VALUE 0.        
COB305     05 RS-AMT-TO-TRANSFER        PIC S9(09)V9(02) COMP-3 VALUE 0.        
COB305     05 RS-DEPOSITABLE-AMT        PIC S9(09)V9(02) COMP-3 VALUE 0.        
COB305     05 RS-PREV-BANK-TRANS        PIC S9(09)V9(02) COMP-3 VALUE 0.        
COB305     05 RS-TOTAL-BANKTRANS        PIC S9(11)V9(02) COMP-3 VALUE 0.        
           05  RS-CASH-DRAWER-ID       PIC S9(04)       COMP.           
           05  RS-STATUS               PIC X(01).                       
           05  RS-CLOSED-ON            PIC X(26).                       
           05  RS-MULTI-BATCH-IND      PIC X(01).                       
REARCH*                                                                         
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE          PIC S9(09)       COMP VALUE 0.    
COB305     05 S-GL-ACCT-NO        PIC S9(03)V9(04) COMP-3 VALUE 0.          
REARCH     05  S-GL-ACCT-NAME         PIC X(25).                        
COB305     05 S-TOTAL-GL-AMT        PIC S9(11)V9(02) COMP-3 VALUE 0.          
COB305     05 S-WORK-FUND-TOTAL        PIC S9(13)V9(02) COMP-3 VALUE 0.         
COB305     05 S-AMT-TO-TRANSFER        PIC S9(09)V9(02) COMP-3 VALUE 0.         
COB305     05 S-DEPOSITABLE-AMT        PIC S9(09)V9(02) COMP-3 VALUE 0.         
COB305     05 S-PREV-BANK-TRANS        PIC S9(09)V9(02) COMP-3 VALUE 0.         
COB305     05 S-TOTAL-BANKTRANS        PIC S9(11)V9(02) COMP-3 VALUE 0.         
REARCH     05  S-CASH-DRAWER-ID       PIC S9(04)       COMP.            
REARCH     05  S-STATUS               PIC X(01).                        
REARCH     05  S-CLOSED-ON            PIC X(26).                        
REARCH     05  S-MULTI-BATCH-IND      PIC X(01).                        
                                                                        
REARCH*                                                                         
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
REARCH     10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
REARCH     10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
REARCH     10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
REARCH         49  S-HOST-VARIABLES-V  PIC X(255).                      
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-STATEMENT-V   PIC X(255).                      
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-DESCRIPTION-V PIC X(255).                      
                                                                        
           EXEC SQL                                                             
                INCLUDE SQLCA                                           05750000
           END-EXEC.                                                    05760000
                                                                        
      ******************************************************************        
      *    CSS_CSH_DRWR_JRNL                                           *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     05860000
                INCLUDE TBCDJRNL                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CSS_CSH_DRWR_CNTL                                           *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     05860000
                INCLUDE  TBCDCNTL                                       05870000
           END-EXEC.                                                    05880000
                                                                        
      ******************************************************************        
      *    CSS_LIEAP_AGENCY                                            *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     05860000
                INCLUDE  TBLIAGCY                                       05870000
           END-EXEC.                                                    05880000
                                                                        
      ******************************************************************        
      *    CSS_BANK_TRANSFER                                           *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     05860000
                INCLUDE  TBBNKXFR                                       05870000
           END-EXEC.                                                    05880000
                                                                        
      ******************************************************************        
      *    CSS_GL_ACCT_NO                                              *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     05860000
                INCLUDE TBGLATNO                                        05870000
           END-EXEC.                                                    05880000
                                                                        
      ******************************************************************        
      *    CSS_CSH_REPORT_HDR                                          *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
                INCLUDE TBCSRPHD                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************06900000
      *          CURSOR FOR CSS_CSH_DRWR_CNTL                          *06910000
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
                DECLARE  DRWR_CNTL_CURSOR CURSOR FOR                    
                 SELECT  CASH_DRAWER_ID,                                
                         AMT_BASIC_WORK,                                
                         CODE_CSH_DRWR_STAT,                            
                         REPLACE(REPLACE(CONVERT(CHAR(26), BALANCED_TS
           , 121), ' ', '-'), ':', '.') BALANCED_TS                            
                   FROM  CSS_CSH_DRWR_CNTL WITH(READUNCOMMITTED)                
                  WHERE  CASH_COMPANY_NO   = :CS-CASH-COMPANY-NO        
                    AND  CASH_LOCAL_OFFICE = :CS-CASH-LOCAL-OFFICE      
                    AND  DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )       
                    AND  USER_ID BETWEEN :WS-USER-LOW AND :WS-USER-HIGH 
               ORDER BY  CASH_DRAWER_ID DESC                            
A37342              FOR READ ONLY                              
P00641                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE  DRWR_CNTL_CURSOR CURSOR FOR                            
MFA-TR*          SELECT  CASH_DRAWER_ID,                                        
MFA-TR*                  AMT_BASIC_WORK,                                        
MFA-TR*                  CODE_CSH_DRWR_STAT,                                    
MFA-TR*                  BALANCED_TS                                            
MFA-TR*            FROM  CSS_CSH_DRWR_CNTL                                      
MFA-TR*           WHERE  CASH_COMPANY_NO   = :CS-CASH-COMPANY-NO                
MFA-TR*             AND  CASH_LOCAL_OFFICE = :CS-CASH-LOCAL-OFFICE              
MFA-TR*             AND  DATE_CASH_REPORT  = :CS-DATE-CASH-REPORT               
MFA-TR*             AND  USER_ID BETWEEN :WS-USER-LOW AND :WS-USER-HIGH         
MFA-TR*        ORDER BY  CASH_DRAWER_ID DESC                                    
MFA-TR*             FOR  FETCH ONLY WITH UR                                     
MFA-TR*        QUERYNO 7400                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************06900000
      *          CURSOR FOR CSS_CSH_DRWR_JRNL                          *06910000
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
                DECLARE  DRWR_TRANS_CURSOR CURSOR FOR                   
                 SELECT  CASH_LOCAL_OFFICE,                             
                         CASH_REPORT_NO,                                
                         DATE_CASH_REPORT,                              
                         CASH_DRAWER_ID,                                
                         DATE_TRAN,                                     
                         REPLACE(CONVERT(CHAR(8), TRAN_TIME, 108), ':', 
           '.') TRAN_TIME,                                     
                         CURRENCY_TYPE,                                 
                         TRAN_DATA,                                     
                         ENTRY_NO,                                      
                         TRAN_APPL_NO                                   
                   FROM  CSS_CSH_DRWR_JRNL WITH(READUNCOMMITTED)                
                  WHERE  CASH_COMPANY_NO      = :CJ-CASH-COMPANY-NO     
                    AND  CASH_LOCAL_OFFICE    = :CJ-CASH-LOCAL-OFFICE   
                    AND  DATE_CASH_REPORT     = IIF(TRY_CONVERT(DATE, 
                                                   :CJ-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CJ-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CJ-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CJ-DATE-CASH-REPORT
              ), CONVERT(DATE, :CJ-DATE-CASH-REPORT) )    
                    AND  CASH_DRAWER_ID       = :CS-CASH-DRAWER-ID      
A37342              FOR READ ONLY                              
P00641                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     06920000
MFA-TR*         DECLARE  DRWR_TRANS_CURSOR CURSOR FOR                   06930000
MFA-TR*          SELECT  CASH_LOCAL_OFFICE,                             06940000
MFA-TR*                  CASH_REPORT_NO,                                        
MFA-TR*                  DATE_CASH_REPORT,                                      
MFA-TR*                  CASH_DRAWER_ID,                                        
MFA-TR*                  DATE_TRAN,                                             
MFA-TR*                  TRAN_TIME,                                             
MFA-TR*                  CURRENCY_TYPE,                                         
MFA-TR*                  TRAN_DATA,                                             
MFA-TR*                  ENTRY_NO,                                              
MFA-TR*                  TRAN_APPL_NO                                           
MFA-TR*            FROM  CSS_CSH_DRWR_JRNL                                      
MFA-TR*           WHERE  CASH_COMPANY_NO      = :CJ-CASH-COMPANY-NO             
MFA-TR*             AND  CASH_LOCAL_OFFICE    = :CJ-CASH-LOCAL-OFFICE           
MFA-TR*             AND  DATE_CASH_REPORT     = :CJ-DATE-CASH-REPORT            
MFA-TR*             AND  CASH_DRAWER_ID       = :CS-CASH-DRAWER-ID              
MFA-TR*             FOR  FETCH ONLY WITH UR                                     
MFA-TR*        QUERYNO 7300                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *        CURSOR FOR CSS_LIEAP_AGENCY                             *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
                DECLARE  LIEAP_CURSOR CURSOR FOR                        
                 SELECT  :WS-YES                                        
                   FROM  CSS_LIEAP_AGENCY WITH(READUNCOMMITTED)                 
                  WHERE  GL_ACCT_NO  = :I5-GL-ACCT-NO
            OPTION(FAST 1)
            FOR READ ONLY
            
                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ021
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE  LIEAP_CURSOR CURSOR FOR                                
MFA-TR*          SELECT  :WS-YES                                                
MFA-TR*            FROM  CSS_LIEAP_AGENCY                                       
MFA-TR*           WHERE  GL_ACCT_NO  = :I5-GL-ACCT-NO                           
MFA-TR*        OPTIMIZE  FOR 1 ROW                                              
MFA-TR*             FOR  FETCH ONLY WITH UR                                     
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
C25923******************************************************************        
C25923*        CURSOR FOR CSS_BANK_TRANSFER                            *        
C25923******************************************************************        
C25923                                                                  
C25923     EXEC SQL                                                     
C25923      DECLARE BXFER_CURSOR CURSOR FOR                             
C25923       SELECT SUM(TRANSFER_AMT)                                   
C25923              ,CODE_DR_CR                                         
C25923         FROM CSS_BANK_TRANSFER WITH(READUNCOMMITTED)                     
C25923        WHERE CASH_COMPANY_NO   = :CS-CASH-COMPANY-NO             
C25923          AND CASH_LOCAL_OFFICE = :CS-CASH-LOCAL-OFFICE           
C25923          AND DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )            
C25923        GROUP BY CODE_DR_CR                                       
A37342          FOR READ ONLY                                   
P00641                                                      
C25923     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE BXFER_CURSOR CURSOR FOR                                     
MFA-TR*      SELECT SUM(TRANSFER_AMT)                                           
MFA-TR*             ,CODE_DR_CR                                                 
MFA-TR*        FROM CSS_BANK_TRANSFER                                           
MFA-TR*       WHERE CASH_COMPANY_NO   = :CS-CASH-COMPANY-NO                     
MFA-TR*         AND CASH_LOCAL_OFFICE = :CS-CASH-LOCAL-OFFICE                   
MFA-TR*         AND DATE_CASH_REPORT  = :CS-DATE-CASH-REPORT                    
MFA-TR*       GROUP BY CODE_DR_CR                                               
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*        QUERYNO 7560                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
REARCH LINKAGE SECTION.                                                 
REARCH*                                                                         
REARCH 01  PARM-COMPANY-NO         PIC X(02).                           
REARCH 01  PARM-CASH-LOCAL-OFFICE  PIC X(03).                           
REARCH 01  PARM-DATE-CASH-REPORT   PIC X(10).                           
REARCH 01  PARM-USER-ID            PIC X(07).                           
REARCH*                                                                         
REARCH PROCEDURE DIVISION USING PARM-COMPANY-NO                         
REARCH                          PARM-CASH-LOCAL-OFFICE                  
REARCH                          PARM-DATE-CASH-REPORT                   
REARCH                          PARM-USER-ID.                           
                                                                        
      ******************************************************************07600000
      * 0000-MAINLINE                                                  *07610000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *07620000
      ******************************************************************07630000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE             THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07730000
      * 0100-INITIALIZE                                                *07740000
      *                                                                *07750000
      *     1. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *07760000
      *     2. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *07770000
      *     3. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*07780000
      *                                                                *07790000
      ******************************************************************07800000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                         TO ACTIVE-PARAGRAPH.     
           EXEC SQL                                                     
                WHENEVER SQLWARNING CONTINUE                            
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
                WHENEVER SQLERROR CONTINUE                              
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
                WHENEVER NOT FOUND CONTINUE                             
           END-EXEC.                                                    
                                                                        
           INITIALIZE TDS-RETURN-FIELDS,                                
                      WS-GEN-LED-RETURN-DATA.                           
REARCH*                                                                         
REARCH     PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
REARCH*                                                                         
REARCH     EXEC SQL                                                     
A37342         DECLARE C1 CURSOR                             
A37342                           WITH ROWSET POSITIONING FOR            
REARCH         SELECT  RETURN_CODE                                      
REARCH                ,GL_ACCT_NO                                       
REARCH                ,LTRIM(RTRIM(GL_ACCT_NAME)) AS GL_ACCT_NAME              
REARCH                ,TOTAL_GL_AMOUNT                                  
REARCH                ,WORK_FUND_TOTAL                                  
REARCH                ,AMT_TO_TRANSFER                                  
REARCH                ,DEPOSITABLE_AMT                                  
REARCH                ,PREV_BANK_TRANS                                  
REARCH                ,TOTAL_BANKTRANS                                  
REARCH                ,CASH_DRAWER_ID                                   
REARCH                ,STATUS                                           
REARCH                ,LTRIM(RTRIM(CLOSED_ON))    AS CLOSED_ON                 
REARCH                ,MULTI_BATCH_IND                                  
REARCH         FROM                                                     
REARCH             #CSR02308_R1                                  
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT  RETURN_CODE                                              
MFA-TR*               ,GL_ACCT_NO                                               
MFA-TR*               ,STRIP(GL_ACCT_NAME) AS GL_ACCT_NAME                      
MFA-TR*               ,TOTAL_GL_AMOUNT                                          
MFA-TR*               ,WORK_FUND_TOTAL                                          
MFA-TR*               ,AMT_TO_TRANSFER                                          
MFA-TR*               ,DEPOSITABLE_AMT                                          
MFA-TR*               ,PREV_BANK_TRANS                                          
MFA-TR*               ,TOTAL_BANKTRANS                                          
MFA-TR*               ,CASH_DRAWER_ID                                           
MFA-TR*               ,STATUS                                                   
MFA-TR*               ,STRIP(CLOSED_ON)    AS CLOSED_ON                         
MFA-TR*               ,MULTI_BATCH_IND                                          
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR02308_R1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
REARCH*                                                                         
REARCH******************************************************************        
REARCH* 0100A-DECLARE-GTT                                              *        
REARCH******************************************************************        
REARCH*                                                                         
REARCH 0100A-DECLARE-GTT.                                               
REARCH                                                                  
REARCH     MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR02308_R1'            
REARCH                                   TO S-SQL-STATEMENT-V.          
REARCH     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02308_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02308_R1
              (                                                       
REARCH               RETURN_CODE            INT                     
REARCH              ,GL_ACCT_NO             DECIMAL(7,4)                
REARCH              ,GL_ACCT_NAME CHAR(25)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,TOTAL_GL_AMOUNT        DECIMAL(13,2)               
REARCH              ,WORK_FUND_TOTAL        DECIMAL(15,2)               
REARCH              ,AMT_TO_TRANSFER        DECIMAL(11,2)               
REARCH              ,DEPOSITABLE_AMT        DECIMAL(11,2)               
REARCH              ,PREV_BANK_TRANS        DECIMAL(11,2)               
REARCH              ,TOTAL_BANKTRANS        DECIMAL(13,2)               
REARCH              ,CASH_DRAWER_ID         SMALLINT                    
REARCH              ,STATUS CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2           
REARCH              ,CLOSED_ON CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH              ,MULTI_BATCH_IND CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH          )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH     MOVE SQLSTATE                 TO WS-SQLSTATE.                
REARCH     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
REARCH     IF WS-SQLSTATE = '42710'                                     
REARCH        PERFORM 8000A-DELETE-GTT-ROWS                             
REARCH                                        THRU 8000A-EXIT           
REARCH     ELSE                                                         
REARCH       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
REARCH          NEXT SENTENCE                                           
REARCH       ELSE                                                       
REARCH          MOVE PROGRAM-NAME       TO ABEND-PROGRAM                
REARCH          MOVE SQLCODE            TO ABEND-SQLCODE                
REARCH          MOVE SQLSTATE           TO ABEND-SQLSTATE               
REARCH          MOVE '0100A'            TO ACTIVE-PARAGRAPH             
REARCH          MOVE 'DECLARE GTT'      TO ABEND-FUNCTION               
REARCH          MOVE SPACES             TO ABEND-SQL-PREDICATES         
REARCH                                     ABEND-TABLES                 
REARCH          MOVE 'CSR02308_R1'      TO TABLE-1                      
REARCH          MOVE SPACES             TO TABLE-ELEMENT-1              
REARCH          MOVE SPACES             TO HOSTVAR-ELEMENT-1            
REARCH          PERFORM 9900-SQL-ERROR-ROUTINE                          
REARCH                                  THRU  9900-EXIT                 
REARCH       END-IF                                                     
REARCH     END-IF.                                                      
REARCH 0100A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
      ******************************************************************08040000
      * 1000-PROCESS-INPUT.                                            *08050000
      *                                                                *08060000
      *     1. RECEIVE PARMS.                                          *08070000
      *                                                                *08080000
      ******************************************************************08090000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000'                         TO ACTIVE-PARAGRAPH.     
           MOVE PARM-COMPANY-NO                TO CS-CASH-COMPANY-NO,   
                                                  CJ-CASH-COMPANY-NO,   
                                                  YR-CASH-COMPANY-NO,   
                                                  GO-COMPANY-NO.        
           MOVE PARM-CASH-LOCAL-OFFICE         TO CS-CASH-LOCAL-OFFICE, 
                                                  CJ-CASH-LOCAL-OFFICE, 
                                                  YR-CASH-LOCAL-OFFICE. 
           MOVE PARM-DATE-CASH-REPORT          TO CS-DATE-CASH-REPORT,  
                                                  CJ-DATE-CASH-REPORT,  
                                                  YR-DATE-CASH-REPORT.  
           IF  PARM-USER-ID > SPACES                                    
               MOVE 'CB'                       TO WS-PROCESS            
               MOVE PARM-USER-ID               TO WS-USER-LOW           
                                                  WS-USER-HIGH          
                                                  CS-USER-ID            
           ELSE                                                         
               MOVE 'CR'                       TO WS-PROCESS            
               MOVE LOW-VALUES                 TO WS-USER-LOW           
               MOVE HIGH-VALUES                TO WS-USER-HIGH          
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08470000
      * 2000-PROCESS-OUTPUT.                                           *08480000
      *                                                                *08490000
      *     1. DESCRIBE RESULT SET                                     *08500000
      *     2. BUILD RESULT SET                                        *08520000
      *     3. SEND RESULT SET                                         *08530000
      *                                                                *08540000
      ******************************************************************08550000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                         TO ACTIVE-PARAGRAPH.     
           PERFORM 2200-PROCESS-OUTPUT         THRU 2200-EXIT.          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
REARCH*                                                                         
REARCH*****************************************************************         
REARCH* 2000A-MOVE-RESULT.                                            *         
REARCH*****************************************************************         
REARCH*                                                                         
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH      MOVE RS-RETURN-CODE           TO S-RETURN-CODE.             
REARCH      MOVE RS-GL-ACCT-NO            TO S-GL-ACCT-NO.              
REARCH      MOVE RS-GL-ACCT-NAME          TO S-GL-ACCT-NAME.            
REARCH      MOVE RS-TOTAL-GL-AMT          TO S-TOTAL-GL-AMT.            
REARCH      MOVE RS-WORK-FUND-TOTAL       TO S-WORK-FUND-TOTAL.         
REARCH      MOVE RS-AMT-TO-TRANSFER       TO S-AMT-TO-TRANSFER.         
REARCH      MOVE RS-DEPOSITABLE-AMT       TO S-DEPOSITABLE-AMT.         
REARCH      MOVE RS-PREV-BANK-TRANS       TO S-PREV-BANK-TRANS.         
REARCH      MOVE RS-TOTAL-BANKTRANS       TO S-TOTAL-BANKTRANS.         
REARCH      MOVE RS-CASH-DRAWER-ID        TO S-CASH-DRAWER-ID.          
REARCH      MOVE RS-STATUS                TO S-STATUS.                  
REARCH      MOVE RS-CLOSED-ON             TO S-CLOSED-ON.               
REARCH      MOVE RS-MULTI-BATCH-IND       TO S-MULTI-BATCH-IND.         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2200-PROCESS-OUTPUT                                         *        
      *                                                                *        
      *    1. TO GET THE CLEAR CASH ACCOUNT NO.                        *        
      *    2. CHECK IF IT IS PROCESSING FOR CLOSE BATCH OR FOR THE     *        
      *    CLOSE REPORT.                                               *        
      ******************************************************************        
       2200-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2200'                         TO ACTIVE-PARAGRAPH.     
           MOVE WS-CLEAR-CASH                  TO GO-GL-ACCT-NAME.      
           PERFORM 7100-GET-ACCT-NUMBER        THRU 7100-EXIT.          
           MOVE GO-GL-ACCT-NO                  TO WS-CLR-CASH-ACCT-NO.  
                                                                        
           IF  CLOSE-BATCH                                              
               PERFORM 2300-PROCESS-CLOSE-BAT  THRU 2300-EXIT           
           ELSE                                                         
               PERFORM 2400-PROCESS-CLOSE-RPT  THRU 2400-EXIT           
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2300-PROCESS-CLOSE-BAT                                      *        
      *                                                                *        
      *    THIS PARA IS FOR THE CLOSE BATCH                            *        
      *    1. TO CHECK FOR ANY BATCH FOR THAT DAY AND USER.            *        
      *                                                                *        
      ******************************************************************        
       2300-PROCESS-CLOSE-BAT.                                          
                                                                        
           MOVE '2300'                         TO ACTIVE-PARAGRAPH.     
           PERFORM 7400-OPEN-CNTL-CURSOR       THRU 7400-EXIT.          
           PERFORM 7410-FETCH-CNTL-CURSOR      THRU 7410-EXIT.          
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               PERFORM 2310-GET-TRANS-FOR-CLS-BAT                       
                                               THRU 2310-EXIT           
                       UNTIL WS-CNTL-RETURN-CODE = NOT-FOUND            
           ELSE                                                         
               MOVE 1000                       TO RS-RETURN-CODE        
REARCH         PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT          
               PERFORM 8100-SEND-RESULT        THRU 8100-EXIT           
           END-IF.                                                      
                                                                        
           PERFORM 7420-CLOSE-CNTL-CURSOR      THRU 7420-EXIT.          
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2310-GET-BATCH-FOR-CLS-BAT                                  *        
      *                                                                *        
      *    1. TO CHECK FOR THE MULTIPLE BATCHES FOR THE DAY AND USER.  *        
      *    2. TO GET THE TRANSACTIONS FOR THE BATCH                    *        
      *    3. TO GET THE PREVIOUS BANK TRANSFER AMOUNT                 *        
      *    4. TO INITIALIZE THE RESULT SET FIELDS AND                  *        
      *       THE GL_ACCT ARRAY.                                       *        
      ******************************************************************        
                                                                        
       2310-GET-TRANS-FOR-CLS-BAT.                                      
                                                                        
           MOVE '2310'                         TO ACTIVE-PARAGRAPH.     
           MOVE CS-AMT-BASIC-WORK              TO RS-WORK-FUND-TOTAL.   
           MOVE CS-CASH-DRAWER-ID              TO RS-CASH-DRAWER-ID.    
           MOVE CS-CODE-CSH-DRWR-STAT          TO RS-STATUS.            
           PERFORM 7000-CK-MULTI-BATCH         THRU 7000-EXIT           
                                                                        
           IF  WS-MULTI-BATCH-COUNT  GREATER THAN WS-ONE                
               MOVE WS-YES                     TO RS-MULTI-BATCH-IND    
           ELSE                                                         
               MOVE WS-NO                      TO RS-MULTI-BATCH-IND    
           END-IF                                                       
                                                                        
           PERFORM 7300-OPEN-JRNL-CURSOR       THRU 7300-EXIT.          
           PERFORM 7310-FETCH-JRNL-CURSOR      THRU 7310-EXIT.          
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               PERFORM 2500-PROCESS-JRNL       THRU 2500-EXIT           
                       UNTIL WS-JRNL-RETURN-CODE = NOT-FOUND            
               MOVE WS-DEPOSITABLE-AMT         TO RS-DEPOSITABLE-AMT    
               PERFORM 2700-CK-BANK-TRANS-AMT  THRU 2700-EXIT           
               PERFORM 2800-SEND-ALL-GL-ACCTS  THRU 2800-EXIT           
               INITIALIZE TDS-RETURN-FIELDS                             
                         ,WS-GEN-LED-RETURN-DATA                        
                         ,WS-DEPOSITABLE-AMT                            
C32216                   ,WS-TABLE-LENGTH                               
           ELSE                                                         
               MOVE 2000                       TO RS-RETURN-CODE        
REARCH         PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT          
               PERFORM 8100-SEND-RESULT        THRU 8100-EXIT           
           END-IF.                                                      
                                                                        
           PERFORM 7320-CLOSE-JRNL-CURSOR      THRU 7320-EXIT.          
           PERFORM 7410-FETCH-CNTL-CURSOR      THRU 7410-EXIT.          
                                                                        
       2310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   2400-PROCESS-CLOSE-RPT                                       *        
      *                                                                *        
      *   THIS IS PERFORMED ONLY IN THE CASE OF CLOSE REPORT           *        
      *   TO GET THE REPORT CLOSED TIMESTAMP AND THE STATUS            *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2400-PROCESS-CLOSE-RPT.                                          
                                                                        
           MOVE '2400'                         TO ACTIVE-PARAGRAPH.     
           PERFORM 7700-GET-RPT-STATUS         THRU 7700-EXIT           
                                                                        
           IF  WS-ACTIVE-RETURN-CODE           EQUAL SUCCESSFUL-CALL    
               PERFORM 2410-GET-CLOSE-RPT-DET  THRU 2410-EXIT           
           ELSE                                                         
               MOVE 3000                       TO RS-RETURN-CODE        
REARCH         PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT          
               PERFORM 8100-SEND-RESULT        THRU 8100-EXIT           
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2410-GET-CLOSE-RPT-DET                                      *        
      *                                                                *        
      *    TO GET THE BATCHES FOR THE DAY AND LOCAL OFFICE             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2410-GET-CLOSE-RPT-DET.                                          
                                                                        
           MOVE '2410'                         TO ACTIVE-PARAGRAPH.     
           PERFORM 7400-OPEN-CNTL-CURSOR       THRU 7400-EXIT           
           PERFORM 7410-FETCH-CNTL-CURSOR      THRU 7410-EXIT           
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               PERFORM 2420-GET-TRANS-FOR-CLS-RPT                       
                                               THRU 2420-EXIT           
                           UNTIL WS-CNTL-RETURN-CODE = NOT-FOUND        
C25923         MOVE ZERO                       TO WS-BANK-TRANS         
C25923                                            WS-TOTAL-BANKTRANS    
C25923         PERFORM 7560-OPEN-BXFER-CURSOR  THRU 7560-EXIT           
C25923         PERFORM 7570-FETCH-BXFER-CURSOR THRU 7570-EXIT           
C25923             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
C25923         PERFORM 7580-CLOSE-BXFER-CURSOR THRU 7580-EXIT           
C25923         MOVE WS-TOTAL-BANKTRANS         TO RS-TOTAL-BANKTRANS    
                                                                        
               MOVE YR-STATUS                  TO RS-STATUS             
               MOVE YR-CLOSED-TS               TO RS-CLOSED-ON          
               PERFORM 2800-SEND-ALL-GL-ACCTS  THRU 2800-EXIT           
           ELSE                                                         
               MOVE 1000                       TO RS-RETURN-CODE        
REARCH         PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT          
               PERFORM 8100-SEND-RESULT        THRU 8100-EXIT           
           END-IF.                                                      
                                                                        
           PERFORM 7420-CLOSE-CNTL-CURSOR      THRU 7420-EXIT.          
                                                                        
       2410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2420-GET-TRANS-FOR-CLS-RPT                                  *        
      *                                                                *        
      *    TO GET THE TRANSACTIONS FOR A BATCH                         *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2420-GET-TRANS-FOR-CLS-RPT.                                      
                                                                        
           MOVE '2420'                         TO ACTIVE-PARAGRAPH.     
           PERFORM 7300-OPEN-JRNL-CURSOR       THRU 7300-EXIT.          
           PERFORM 7310-FETCH-JRNL-CURSOR      THRU 7310-EXIT.          
           PERFORM 2500-PROCESS-JRNL           THRU 2500-EXIT           
                   UNTIL WS-JRNL-RETURN-CODE = NOT-FOUND                
           PERFORM 7320-CLOSE-JRNL-CURSOR      THRU 7320-EXIT.          
           PERFORM 7410-FETCH-CNTL-CURSOR      THRU 7410-EXIT.          
                                                                        
       2420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2500-PROCESS-JRNL                                           *        
      *                                                                *        
      *    TO DETERMINE WHETHER THE GL_ACCT NO IS DEBIT OR CREDIT      *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2500-PROCESS-JRNL.                                               
                                                                        
           MOVE '2350'                         TO ACTIVE-PARAGRAPH.     
           MOVE CJ-TRAN-DATA                   TO CJF00101.             
           MOVE WS-NO                          TO WS-LIHEAP-RVSL,       
                                                  WS-LIHEAP-PMT,        
                                                  WS-GL-ACCT-FLAG.      
           IF  WS-101-ACCT-GEN-LED-DR = WS-CLR-CASH-ACCT-NO OR          
               WS-101-ACCT-GEN-LED-CR = WS-CLR-CASH-ACCT-NO             
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-101-ACCT-GEN-LED-DR     TO I5-GL-ACCT-NO         
               PERFORM 2550-CHECK-GL-NUM       THRU 2550-EXIT           
                                                                        
               IF  WS-GL-ACCT-FLAG = WS-YES                             
                   MOVE WS-YES                 TO WS-LIHEAP-PMT         
               ELSE                                                     
                   MOVE WS-101-ACCT-GEN-LED-CR TO I5-GL-ACCT-NO         
                   PERFORM 2550-CHECK-GL-NUM   THRU 2550-EXIT           
                                                                        
                   IF  WS-GL-ACCT-FLAG = WS-YES                         
                       MOVE WS-YES             TO WS-LIHEAP-RVSL        
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
                                                                        
           PERFORM 2600-ACCUMULATE-TOTAL-AMOUNT                         
                                               THRU 2600-EXIT.          
           PERFORM 7310-FETCH-JRNL-CURSOR      THRU 7310-EXIT.          
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2550-CHECK-GL-NUM                                           *        
      *                                                                *        
      *    TO CHECK WHETHER GL_ACCT_NO IS IN THE CSS_LIEAP_AGENCY      *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2550-CHECK-GL-NUM.                                               
                                                                        
           MOVE '2550'                         TO ACTIVE-PARAGRAPH.     
           PERFORM 7200-OPEN-LIEAP-CURSOR      THRU 7200-EXIT.          
           PERFORM 7210-FETCH-LIEAP-CURSOR     THRU 7210-EXIT.          
           PERFORM 7220-CLOSE-LIEAP-CURSOR     THRU 7220-EXIT.          
                                                                        
       2550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2600-ACCUMULATE-TOTAL-AMOUNT                                *        
      *                                                                *        
      *    1. TO CHECK IF BOTH THE GL_ACCT_NO ARE SAME                 *        
      *    2. TO GET ALL THE GL_ACCT_NO'S AND THEIR TOTAL AMOUNT       *        
      *    3. TO CHECK FOR THE GL_ACCT ARRAY LIMIT                     *        
      *    4. TO ACCUMULATE THE CASH, CHECK, MONEY ORDER AMOUNT AS THE *        
      *       DEPOSITABLE AMOUNT                                       *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2600-ACCUMULATE-TOTAL-AMOUNT.                                    
                                                                        
           MOVE '2600'                         TO ACTIVE-PARAGRAPH.     
           IF  WS-101-ACCT-GEN-LED-DR = WS-101-ACCT-GEN-LED-CR          
               NEXT SENTENCE                                            
           ELSE                                                         
               IF  WS-101-ACCT-GEN-LED-CR = WS-CLR-CASH-ACCT-NO  OR     
                   WS-LIHEAP-RVSL = WS-YES                              
                   MULTIPLY -1 BY WS-101-AMT-POSTED                     
               END-IF                                                   
                                                                        
               IF  WS-101-ACCT-GEN-LED-CR = WS-CLR-CASH-ACCT-NO         
                   MOVE WS-101-ACCT-GEN-LED-DR TO WS-TEMP-ACCT-NO       
               ELSE                                                     
                   IF  WS-101-ACCT-GEN-LED-DR = WS-CLR-CASH-ACCT-NO     
                       MOVE WS-101-ACCT-GEN-LED-CR                      
                                               TO WS-TEMP-ACCT-NO       
                   ELSE                                                 
                       IF  WS-LIHEAP-PMT EQUAL WS-YES                   
                           MOVE WS-101-ACCT-GEN-LED-CR                  
                                               TO WS-TEMP-ACCT-NO       
                       ELSE                                             
                           IF  WS-LIHEAP-RVSL  EQUAL WS-YES             
                               MOVE WS-101-ACCT-GEN-LED-DR              
                                               TO WS-TEMP-ACCT-NO       
                           ELSE                                         
                               NEXT SENTENCE                            
                           END-IF                                       
                       END-IF                                           
                   END-IF                                               
               END-IF                                                   
                                                                        
               MOVE WS-NO                      TO WS-FOUND              
               PERFORM VARYING WS-SUB  FROM 1 BY 1 UNTIL                
                               WS-FOUND = WS-YES                        
                                                                        
                   IF  WS-GEN-LED-ACCT-NO(WS-SUB) EQUAL ZEROES          
                       MOVE WS-YES             TO WS-FOUND              
                       MOVE WS-SUB             TO WS-TABLE-LENGTH       
                       MOVE WS-TEMP-ACCT-NO    TO                       
                                   WS-GEN-LED-ACCT-NO(WS-SUB)           
                       MOVE WS-101-AMT-POSTED  TO                       
                                   WS-AMOUNT-POSTED(WS-SUB)             
                   ELSE                                                 
                      IF  WS-GEN-LED-ACCT-NO(WS-SUB) = WS-TEMP-ACCT-NO  
                          MOVE WS-YES          TO WS-FOUND              
                          ADD WS-101-AMT-POSTED                         
                                               TO                       
                              WS-AMOUNT-POSTED(WS-SUB)                  
                      END-IF                                            
                   END-IF                                               
               END-PERFORM                                              
                                                                        
               IF  WS-TABLE-LENGTH     GREATER THAN WS-TABLE-LIMIT      
                   MOVE -1                     TO WS-ACTIVE-RETURN-CODE 
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE '2600'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'GL-ACCT-NO ARRAY '    TO TABLE-1               
                   MOVE 'EXCEEDED LIMIT'       TO TABLE-2               
                   MOVE CS-CASH-COMPANY-NO     TO HOSTVAR-ELEMENT-1     
                   MOVE CS-CASH-LOCAL-OFFICE   TO HOSTVAR-ELEMENT-2     
                   MOVE CS-USER-ID             TO HOSTVAR-ELEMENT-3     
                   MOVE CS-DATE-CASH-REPORT    TO HOSTVAR-ELEMENT-4     
                   PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT           
               END-IF                                                   
                                                                        
               MOVE CJ-CURRENCY-TYPE           TO WS-CURRENCY-TYPE      
                                                                        
C25923*        IF  CASH OR CHECK OR MONEY-ORDER                                 
C25923         IF  CASH OR CHECK OR MONEY-ORDER OR DRAFT                
                   ADD WS-101-AMT-POSTED       TO WS-DEPOSITABLE-AMT    
               END-IF                                                   
           END-IF.                                                      
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2700-CK-BANK-TRANS-AMT                                      *        
      *                                                                *        
      *    1. TO CHECK FOR THE PREVIOUS BANK TRANSFER AMOUNT.          *        
      *    2. COMPUTE THE ACTUAL DEPOSITABLE AMOUNT.                   *        
      ******************************************************************        
                                                                        
       2700-CK-BANK-TRANS-AMT.                                          
                                                                        
           MOVE '2500'                         TO ACTIVE-PARAGRAPH.     
                                                                        
C25923*    IF PARM-CASH-LOCAL-OFFICE = WS-99                                    
T22767        MOVE WS-D                        TO YB-CODE-DR-CR         
T22767        PERFORM 7500-GET-PREV-BANK-TRANSFER THRU 7500-EXIT        
T22767        MOVE ZERO                        TO WS-PREV-BANK-TRANS1   
T22767        IF  WS-PREV-BANK-TRANS > 0                                
T22767            MOVE WS-PREV-BANK-TRANS      TO WS-PREV-BANK-TRANS1   
T22767        END-IF                                                    
T22767        MOVE WS-C                        TO YB-CODE-DR-CR         
T22767        PERFORM 7500-GET-PREV-BANK-TRANSFER THRU 7500-EXIT        
T22767        MOVE ZERO                        TO WS-PREV-BANK-TRANS2   
T22767        IF  WS-PREV-BANK-TRANS > 0                                
T22767            MOVE WS-PREV-BANK-TRANS      TO WS-PREV-BANK-TRANS2   
T22767        END-IF                                                    
T22767        MOVE ZERO                        TO WS-PREV-BANK-TRANS    
T22767        COMPUTE WS-PREV-BANK-TRANS =                              
T22767                WS-PREV-BANK-TRANS1 - WS-PREV-BANK-TRANS2         
T22767        MOVE WS-PREV-BANK-TRANS          TO RS-PREV-BANK-TRANS    
T22767        IF  WS-PREV-BANK-TRANS NOT EQUAL ZERO                     
T22767           SUBTRACT WS-PREV-BANK-TRANS   FROM WS-DEPOSITABLE-AMT  
T22767           MOVE WS-DEPOSITABLE-AMT       TO RS-AMT-TO-TRANSFER    
T22767        ELSE                                                      
T22767           MOVE WS-DEPOSITABLE-AMT       TO RS-AMT-TO-TRANSFER    
T22767        END-IF                                                    
C25923*    ELSE                                                                 
C25923*        MOVE WS-D                       TO YB-CODE-DR-CR                 
C25923*        PERFORM 7500-GET-PREV-BANK-TRANSFER THRU 7500-EXIT               
C25923*        IF  WS-PREV-BANK-TRANS > 0                                       
C25923*            SUBTRACT WS-PREV-BANK-TRANS FROM WS-DEPOSITABLE-AMT          
C25923*            MOVE WS-DEPOSITABLE-AMT     TO RS-AMT-TO-TRANSFER            
C25923*        ELSE                                                             
C25923*            MOVE WS-DEPOSITABLE-AMT     TO RS-AMT-TO-TRANSFER            
C25923*        END-IF                                                           
C25923*    END-IF                                                               
           .                                                            
       2700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2800-SEND-ALL-GL-ACCTS                                      *        
      *                                                                *        
      *    TO SEND ALL THE GL_ACCT_NO 'S WITH ACCT_NAME AND AMOUNT     *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2800-SEND-ALL-GL-ACCTS.                                          
                                                                        
           MOVE '2700'                         TO ACTIVE-PARAGRAPH.     
           PERFORM VARYING WS-SUB FROM 1 BY 1                           
                           UNTIL WS-SUB > WS-TABLE-LENGTH               
               MOVE WS-GEN-LED-ACCT-NO(WS-SUB) TO GO-GL-ACCT-NO         
               PERFORM 7600-GET-ACCT-NAME      THRU 7600-EXIT           
               MOVE WS-GEN-LED-ACCT-NO(WS-SUB) TO RS-GL-ACCT-NO         
               MOVE GO-GL-ACCT-NAME-DESC       TO RS-GL-ACCT-NAME       
               MOVE WS-AMOUNT-POSTED(WS-SUB)   TO RS-TOTAL-GL-AMT       
REARCH         PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT          
               PERFORM 8100-SEND-RESULT        THRU 8100-EXIT           
           END-PERFORM.                                                 
                                                                        
           IF  WS-TABLE-LENGTH EQUAL ZERO                               
               MOVE 2000                       TO RS-RETURN-CODE        
REARCH         PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT          
               PERFORM 8100-SEND-RESULT        THRU 8100-EXIT           
           END-IF.                                                      
                                                                        
       2800-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *    7000-CK-MULTI-BATCH                                         *        
      *                                                                *        
      *    TO CHECK FOR THE MULTIPLE BATCHES                           *        
      *                                                                *        
      ******************************************************************        
       7000-CK-MULTI-BATCH.                                             
                                                                        
           EXEC SQL                                                     
                SELECT  COUNT(*)                                        
                  INTO  :WS-MULTI-BATCH-COUNT                           
                  FROM  CSS_CSH_DRWR_CNTL WITH(READUNCOMMITTED)                 
                 WHERE  CASH_COMPANY_NO   = :CS-CASH-COMPANY-NO         
                   AND  CASH_LOCAL_OFFICE = :CS-CASH-LOCAL-OFFICE       
                   AND  DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )        
                   AND  USER_ID           = :CS-USER-ID                 
A37342                                                          
P00641                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  COUNT(*)                                                
MFA-TR*           INTO  :WS-MULTI-BATCH-COUNT                                   
MFA-TR*           FROM  CSS_CSH_DRWR_CNTL                                       
MFA-TR*          WHERE  CASH_COMPANY_NO   = :CS-CASH-COMPANY-NO                 
MFA-TR*            AND  CASH_LOCAL_OFFICE = :CS-CASH-LOCAL-OFFICE               
MFA-TR*            AND  DATE_CASH_REPORT  = :CS-DATE-CASH-REPORT                
MFA-TR*            AND  USER_ID           = :CS-USER-ID                         
MFA-TR*           WITH  UR                                                      
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE,
                                                  RS-RETURN-CODE.       
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7000'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CSH_DRWR_CNTL'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'USER_ID'                  TO TABLE-ELEMENT-3       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4       
               MOVE CS-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CS-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CS-USER-ID                 TO HOSTVAR-ELEMENT-3     
               MOVE CS-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *    7100-GET-ACCT-NUMBER                                        *        
      *                                                                *        
      *    GET THE CLEAR CASH ACCOUNT NUMBER                           *        
      *                                                                *        
      ******************************************************************        
       7100-GET-ACCT-NUMBER.                                            
                                                                        
           EXEC SQL                                                     
                SELECT  GL_ACCT_NO                                      
                  INTO  :GO-GL-ACCT-NO                                  
                  FROM  CSS_GL_ACCT_NO WITH(READUNCOMMITTED)                    
                 WHERE  COMPANY_NO   = :GO-COMPANY-NO                   
                   AND  GL_ACCT_NAME = :GO-GL-ACCT-NAME                 
A37342                                                          
P00641                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  GL_ACCT_NO                                              
MFA-TR*           INTO  :GO-GL-ACCT-NO                                          
MFA-TR*           FROM  CSS_GL_ACCT_NO                                          
MFA-TR*          WHERE  COMPANY_NO   = :GO-COMPANY-NO                           
MFA-TR*            AND  GL_ACCT_NAME = :GO-GL-ACCT-NAME                         
MFA-TR*           WITH  UR                                                      
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE,
                                                  RS-RETURN-CODE.       
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7100'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_GL_ACCT_NO'           TO TABLE-1               
               MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1       
               MOVE 'GL_ACCT_NAME'             TO TABLE-ELEMENT-2       
               MOVE GO-COMPANY-NO              TO HOSTVAR-ELEMENT-1     
               MOVE GO-GL-ACCT-NAME            TO HOSTVAR-ELEMENT-2     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *    7200-OPEN-LIEAP-CURSOR                                      *        
      *                                                                *        
      *    TO OPEN THE LIEAP_CURSOR                                    *        
      *                                                                *        
      ******************************************************************        
       7200-OPEN-LIEAP-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
                OPEN  LIEAP_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE,
                                                  RS-RETURN-CODE.       
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7200'                     TO ACTIVE-PARAGRAPH      
               MOVE 'OPEN'                     TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_LIEAP_AGENCY'         TO TABLE-1               
               MOVE 'GL_ACCT_NO'               TO TABLE-ELEMENT-1       
               MOVE I5-GL-ACCT-NO              TO WS-GL-ACCT-NO-ED      
               MOVE WS-GL-ACCT-NO-ED           TO HOSTVAR-ELEMENT-1     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *    7200-FETCH-LIEAP-CURSOR                                     *        
      *                                                                *        
      *    TO FETCH THE LIEAP_CURSOR                                   *        
      *                                                                *        
      ******************************************************************        
       7210-FETCH-LIEAP-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
                FETCH  LIEAP_CURSOR                                     
                 INTO  :WS-GL-ACCT-FLAG                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE,
                                                  RS-RETURN-CODE.       
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR               
               WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7210'                     TO ACTIVE-PARAGRAPH      
               MOVE 'FETCH'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_LIEAP_AGENCY'         TO TABLE-1               
               MOVE 'GL_ACCT_NO'               TO TABLE-ELEMENT-1       
               MOVE I5-GL-ACCT-NO              TO WS-GL-ACCT-NO-ED      
               MOVE WS-GL-ACCT-NO-ED           TO HOSTVAR-ELEMENT-1     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *    7220-CLOSE-LIEAP-CURSOR                                     *        
      *                                                                *        
      *    TO CLOSE THE LIEAP_CURSOR                                   *        
      *                                                                *        
      ******************************************************************        
       7220-CLOSE-LIEAP-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
                CLOSE  LIEAP_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE,
                                                  RS-RETURN-CODE.       
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7220'                     TO ACTIVE-PARAGRAPH      
               MOVE 'CLOSE'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_LIEAP_AGENCY'         TO TABLE-1               
               MOVE 'GL_ACCT_NO'               TO TABLE-ELEMENT-1       
               MOVE I5-GL-ACCT-NO              TO WS-GL-ACCT-NO-ED      
               MOVE WS-GL-ACCT-NO-ED           TO HOSTVAR-ELEMENT-1     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *    7300-OPEN-JRNL-CURSOR                                       *        
      *                                                                *        
      *    TO OPEN DRWR_TRANS_CURSOR CURSOR FOR CSS_CSH_DRWR_JRNL      *        
      *                                                                *        
      ******************************************************************        
       7300-OPEN-JRNL-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
                OPEN  DRWR_TRANS_CURSOR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE,
                                                  RS-RETURN-CODE.       
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7300'                     TO ACTIVE-PARAGRAPH      
               MOVE 'OPEN'                     TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CSH_DRWR_JRNL'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'USER_ID'                  TO TABLE-ELEMENT-3       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4       
               MOVE CJ-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CJ-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CJ-USER-ID                 TO HOSTVAR-ELEMENT-3     
               MOVE CJ-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *    7310-FETCH-JRNL-CURSOR                                      *        
      *                                                                *        
      *    TO FETCH DRWR_TRANS_CURSOR                                  *        
      *                                                                *        
      ******************************************************************        
       7310-FETCH-JRNL-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
                FETCH  DRWR_TRANS_CURSOR                                
                 INTO  :CJ-CASH-LOCAL-OFFICE,                           
                       :CJ-CASH-REPORT-NO,                              
                       :CJ-DATE-CASH-REPORT,                            
                       :CJ-CASH-DRAWER-ID,                              
                       :CJ-DATE-TRAN,                                   
                       :CJ-TRAN-TIME,                                   
                       :CJ-CURRENCY-TYPE,                               
                       :CJ-TRAN-DATA,                                   
                       :CJ-ENTRY-NO,                                    
                       :CJ-TRAN-APPL-NO                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE,
                                                  WS-JRNL-RETURN-CODE,  
                                                  RS-RETURN-CODE.       
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR               
               WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7310'                     TO ACTIVE-PARAGRAPH      
               MOVE 'FETCH'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CSH_DRWR_JRNL'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'USER_ID'                  TO TABLE-ELEMENT-3       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4       
               MOVE CJ-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CJ-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CJ-USER-ID                 TO HOSTVAR-ELEMENT-3     
               MOVE CJ-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7320-CLOSE-JRNL-CURSOR                                      *        
      *                                                                *        
      *    TO CLOSE THE DRWR_ALL-CURSOR                                *        
      *                                                                *        
      ******************************************************************        
       7320-CLOSE-JRNL-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
                CLOSE  DRWR_TRANS_CURSOR                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE,
                                                  RS-RETURN-CODE.       
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7320'                     TO ACTIVE-PARAGRAPH      
               MOVE 'CLOSE'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CSH_DRWR_JRNL'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'USER_ID'                  TO TABLE-ELEMENT-3       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4       
               MOVE CS-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CS-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CS-USER-ID                 TO HOSTVAR-ELEMENT-3     
               MOVE CS-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7400-OPEN-CNTL-CURSOR                                       *        
      *                                                                *        
      *    TO OPEN DRWR_CNTL_CURSOR CURSOR FOR CSS_CSH_DRWR_CNTL       *        
      *                                                                *        
      ******************************************************************        
       7400-OPEN-CNTL-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
                OPEN  DRWR_CNTL_CURSOR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE,
                                                  RS-RETURN-CODE.       
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7400'                     TO ACTIVE-PARAGRAPH      
               MOVE 'OPEN'                     TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CSH_DRWR_CNTL'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'USER_ID'                  TO TABLE-ELEMENT-3       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4       
               MOVE CS-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CS-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CS-USER-ID                 TO HOSTVAR-ELEMENT-3     
               MOVE CS-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7410-FETCH-CNTL-CURSOR                                      *        
      *                                                                *        
      *    TO FETCH DRWR_CNTL_CURSOR                                   *        
      *                                                                *        
      ******************************************************************        
       7410-FETCH-CNTL-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
                FETCH  DRWR_CNTL_CURSOR                                 
                 INTO  :CS-CASH-DRAWER-ID,                              
                       :CS-AMT-BASIC-WORK,                              
                       :CS-CODE-CSH-DRWR-STAT,                          
                       :CS-BALANCED-TS :WS-NULL-INDICATOR3               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE,
                                                  WS-CNTL-RETURN-CODE,  
                                                  RS-RETURN-CODE.       
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               IF  WS-NULL-INDICATOR3 < ZERO                            
                   MOVE SPACES                 TO RS-CLOSED-ON          
               ELSE                                                     
                   MOVE CS-BALANCED-TS         TO RS-CLOSED-ON          
               END-IF                                                   
           ELSE                                                         
               IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
                   NEXT SENTENCE                                        
               ELSE                                                     
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE '7410'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'FETCH'                TO ABEND-FUNCTION        
                   MOVE SPACES                 TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
                   MOVE 'CSS_CSH_DRWR_CNTL'    TO TABLE-1               
                   MOVE 'CASH_COMPANY_NO'      TO TABLE-ELEMENT-1       
                   MOVE 'CASH_LOCAL_OFFICE'    TO TABLE-ELEMENT-2       
                   MOVE 'USER_ID'              TO TABLE-ELEMENT-3       
                   MOVE 'DATE_CASH_REPORT'     TO TABLE-ELEMENT-4       
                   MOVE CS-CASH-COMPANY-NO     TO HOSTVAR-ELEMENT-1     
                   MOVE CS-CASH-LOCAL-OFFICE   TO HOSTVAR-ELEMENT-2     
                   MOVE CS-USER-ID             TO HOSTVAR-ELEMENT-3     
                   MOVE CS-DATE-CASH-REPORT    TO HOSTVAR-ELEMENT-4     
                   PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT           
               END-IF                                                   
           END-IF.                                                      
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7420-CLOSE-CNTL-CURSOR                                      *        
      *                                                                *        
      *    TO CLOSE DRWR_CNTL_CURSOR                                   *        
      *                                                                *        
      ******************************************************************        
       7420-CLOSE-CNTL-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
                CLOSE  DRWR_CNTL_CURSOR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE,
                                                  RS-RETURN-CODE.       
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7420'                     TO ACTIVE-PARAGRAPH      
               MOVE 'CLOSE'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CSH_DRWR_CNTL'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'USER_ID'                  TO TABLE-ELEMENT-3       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4       
               MOVE CS-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CS-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CS-USER-ID                 TO HOSTVAR-ELEMENT-3     
               MOVE CS-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7500-GET-PREV-BANK-TRANSFER                                 *        
      *                                                                *        
      *    TO GET THE BANK TRANSFER AMOUNT                             *        
      *                                                                *        
      ******************************************************************        
       7500-GET-PREV-BANK-TRANSFER.                                     
                                                                        
           EXEC SQL                                                     
                SELECT  SUM(TRANSFER_AMT)                               
                  INTO  :WS-PREV-BANK-TRANS :WS-NULL-INDICATOR1          
                  FROM  CSS_BANK_TRANSFER WITH(READUNCOMMITTED)                 
                 WHERE  CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO        
                   AND  CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE      
                   AND  DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )       
                   AND  CASH_DRAWER_ID     = :CS-CASH-DRAWER-ID         
T22767             AND  CODE_DR_CR         = :YB-CODE-DR-CR             
A37342                                                          
P00641                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  SUM(TRANSFER_AMT)                                       
MFA-TR*           INTO  :WS-PREV-BANK-TRANS:WS-NULL-INDICATOR1                  
MFA-TR*           FROM  CSS_BANK_TRANSFER                                       
MFA-TR*          WHERE  CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO                
MFA-TR*            AND  CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE              
MFA-TR*            AND  DATE_CASH_REPORT   = :CS-DATE-CASH-REPORT               
MFA-TR*            AND  CASH_DRAWER_ID     = :CS-CASH-DRAWER-ID                 
MFA-TR*            AND  CODE_DR_CR         = :YB-CODE-DR-CR                     
MFA-TR*           WITH  UR                                                      
MFA-TR*        QUERYNO 7500                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE,
                                                  RS-RETURN-CODE.       
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               IF  WS-NULL-INDICATOR1 < ZERO                            
                   MOVE 0                      TO RS-PREV-BANK-TRANS    
                                                  WS-PREV-BANK-TRANS    
               ELSE                                                     
                   MOVE WS-PREV-BANK-TRANS     TO RS-PREV-BANK-TRANS    
               END-IF                                                   
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7500'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_BANK_TRANSFER'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'USER_ID'                  TO TABLE-ELEMENT-3       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4       
               MOVE CS-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CS-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CS-USER-ID                 TO HOSTVAR-ELEMENT-3     
               MOVE CS-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
C25923******************************************************************        
C25923*    7560-OPEN-BXFER-CURSOR                                      *        
      *    TO OPEN THE BXFER_CURSOR                                    *        
      ******************************************************************        
       7560-OPEN-BXFER-CURSOR.                                          
           EXEC SQL                                                     
                OPEN  BXFER_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7010'                     TO ACTIVE-PARAGRAPH      
               MOVE 'OPEN'                     TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_BANK_TRANSFER'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-3       
               MOVE 'CASH_DRAWER_ID'           TO TABLE-ELEMENT-4       
               MOVE CS-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CS-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CS-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-3     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7560-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7570-FETCH-BXFER-CURSOR                                     *        
      *    TO FETCH THE BXFER_CURSOR                                   *        
      ******************************************************************        
       7570-FETCH-BXFER-CURSOR.                                         
           EXEC SQL                                                     
              FETCH BXFER_CURSOR                                        
               INTO :WS-BANK-TRANS :WS-NULL-INDICATOR2                  
                    ,:YB-CODE-DR-CR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR               
               WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  IF WS-NULL-INDICATOR2 < ZERO                          
                     MOVE 0                    TO WS-BANK-TRANS         
                  ELSE                                                  
                     IF YB-CODE-DR-CR = WS-C                            
                        MULTIPLY -1 BY WS-BANK-TRANS                    
                     END-IF                                             
                  END-IF                                                
                  ADD WS-BANK-TRANS            TO WS-TOTAL-BANKTRANS    
               END-IF                                                   
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7020'                     TO ACTIVE-PARAGRAPH      
               MOVE 'FETCH'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                   ABEND-TABLES         
               MOVE 'CSS_BANK_TRANSFER'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-3       
               MOVE 'CASH_DRAWER_ID'           TO TABLE-ELEMENT-4       
               MOVE CS-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CS-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CS-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-3     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7570-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    7580-CLOSE-BXFER-CURSOR                                     *        
      *    TO CLOSE THE BXFER_CURSOR                                   *        
      ******************************************************************        
       7580-CLOSE-BXFER-CURSOR.                                         
           EXEC SQL                                                     
                CLOSE  BXFER_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7030'                     TO ACTIVE-PARAGRAPH      
               MOVE 'CLOSE'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_BANK_TRANSFER'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-3       
               MOVE 'CASH_DRAWER_ID'           TO TABLE-ELEMENT-4       
               MOVE CS-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CS-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CS-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-3     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
C25923 7580-EXIT.                                                       
C25923     EXIT.                                                        
      ******************************************************************        
      *    7600-GET-ACCT-NAME                                          *        
      *                                                                *        
      *    TO GET THE GL_ACCT_NAME FOR CORRESPONDING GL_ACCT_NO        *        
      *                                                                *        
      ******************************************************************        
       7600-GET-ACCT-NAME.                                              
                                                                        
           EXEC SQL                                                     
                SELECT  GL.GL_ACCT_NAME_DESC                            
                  INTO  :GO-GL-ACCT-NAME-DESC                           
                  FROM  CSS_GL_ACCT_NO   GL WITH(READUNCOMMITTED)               
                 WHERE  GL.COMPANY_NO    = :GO-COMPANY-NO               
                   AND  GL.GL_ACCT_NO    = :GO-GL-ACCT-NO               
A37342                                                          
P00641                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  GL.GL_ACCT_NAME_DESC                                    
MFA-TR*           INTO  :GO-GL-ACCT-NAME-DESC                                   
MFA-TR*           FROM  CSS_GL_ACCT_NO   GL                                     
MFA-TR*          WHERE  GL.COMPANY_NO    = :GO-COMPANY-NO                       
MFA-TR*            AND  GL.GL_ACCT_NO    = :GO-GL-ACCT-NO                       
MFA-TR*           WITH  UR                                                      
MFA-TR*        QUERYNO 7600                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE,
                                                  RS-RETURN-CODE.       
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7600'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_GL_ACCT_NO'           TO TABLE-1               
               MOVE 'CSS_GL_ACCT_NAME'         TO TABLE-2               
               MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1       
               MOVE 'GL_ACCT_NO'               TO TABLE-ELEMENT-2       
               MOVE GO-COMPANY-NO              TO HOSTVAR-ELEMENT-1     
               MOVE GO-GL-ACCT-NO              TO WS-GL-ACCT-NO-ED      
               MOVE WS-GL-ACCT-NO-ED           TO HOSTVAR-ELEMENT-2     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7700-GET-RPT-STATUS                                         *        
      *                                                                *        
      *    TO GET THE REPORT STATUS AND CLOSED DAY AND TIME FOR A      *        
      *    LOCAL OFFICE                                                *        
      *                                                                *        
      ******************************************************************        
       7700-GET-RPT-STATUS.                                             
                                                                        
           EXEC SQL                                                     
                SELECT  STATUS,                                         
                        REPLACE(REPLACE(CONVERT(CHAR(26), CLOSED_TS
           , 121), ' ', '-'), ':', '.') CLOSED_TS                              
                  INTO  :YR-STATUS,                                     
                        :YR-CLOSED-TS                                   
                  FROM  CSS_CSH_REPORT_HDR WITH(READUNCOMMITTED)                
                 WHERE  CASH_COMPANY_NO   = :YR-CASH-COMPANY-NO         
                   AND  CASH_LOCAL_OFFICE = :YR-CASH-LOCAL-OFFICE       
                   AND  DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :YR-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YR-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YR-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YR-DATE-CASH-REPORT
              ), CONVERT(DATE, :YR-DATE-CASH-REPORT) )        
A37342                                                          
P00641                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  STATUS,                                                 
MFA-TR*                 CLOSED_TS                                               
MFA-TR*           INTO  :YR-STATUS,                                             
MFA-TR*                 :YR-CLOSED-TS                                           
MFA-TR*           FROM  CSS_CSH_REPORT_HDR                                      
MFA-TR*          WHERE  CASH_COMPANY_NO   = :YR-CASH-COMPANY-NO                 
MFA-TR*            AND  CASH_LOCAL_OFFICE = :YR-CASH-LOCAL-OFFICE               
MFA-TR*            AND  DATE_CASH_REPORT  = :YR-DATE-CASH-REPORT                
MFA-TR*           WITH  UR                                                      
MFA-TR*        QUERYNO 7700                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE,
                                                  RS-RETURN-CODE.       
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR              
               WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7700'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CSH_REPORT_HDR'       TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-3       
               MOVE YR-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE YR-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE YR-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-3     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
REARCH*                                                                         
REARCH******************************************************************        
REARCH* 8000A-DELETE-GTT-ROWS*                                                  
REARCH******************************************************************        
REARCH*                                                                         
REARCH  8000A-DELETE-GTT-ROWS.                                          
REARCH*                                                                         
REARCH     MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.          
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH         DELETE FROM #CSR02308_R1                          
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR02308_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
REARCH*                                                                         
REARCH     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
REARCH        NEXT SENTENCE                                             
REARCH     ELSE                                                         
REARCH        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
REARCH        MOVE '8000A'               TO ACTIVE-PARAGRAPH            
REARCH        MOVE SQLCODE               TO ABEND-SQLCODE               
REARCH        MOVE 'DELETE'              TO ABEND-FUNCTION              
REARCH        MOVE SPACES                TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH        MOVE 'CSR02308_R1'         TO TABLE-1                     
REARCH        MOVE SPACES                TO TABLE-ELEMENT-1             
REARCH        MOVE SPACES                TO HOSTVAR-ELEMENT-1           
REARCH        PERFORM 9000-SEND-ERROR-RESULT                            
RAERCH                                   THRU 9000-EXIT                 
REARCH        PERFORM 9900-SQL-ERROR-ROUTINE                            
REARCH                                   THRU 9900-EXIT                 
REARCH     END-IF.                                                      
REARCH  8000A-EXIT.                                                     
REARCH     EXIT.                                                        
REARCH*                                                                         
REARCH******************************************************************        
REARCH* 8100-SEND-RESULT                                               *        
REARCH******************************************************************        
REARCH 8100-SEND-RESULT.                                                
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH          INSERT INTO #CSR02308_R1                         
REARCH          (                                                       
REARCH              RETURN_CODE                                         
REARCH             ,GL_ACCT_NO                                          
REARCH             ,GL_ACCT_NAME                                        
REARCH             ,TOTAL_GL_AMOUNT                                     
REARCH             ,WORK_FUND_TOTAL                                     
REARCH             ,AMT_TO_TRANSFER                                     
REARCH             ,DEPOSITABLE_AMT                                     
REARCH             ,PREV_BANK_TRANS                                     
REARCH             ,TOTAL_BANKTRANS                                     
REARCH             ,CASH_DRAWER_ID                                      
REARCH             ,STATUS                                              
REARCH             ,CLOSED_ON                                           
REARCH             ,MULTI_BATCH_IND                                     
REARCH          )                                                       
REARCH          VALUES                                                  
REARCH          (                                                       
REARCH              :S-RETURN-CODE                                      
REARCH             ,:S-GL-ACCT-NO                                       
REARCH             ,:S-GL-ACCT-NAME                                     
REARCH             ,:S-TOTAL-GL-AMT                                     
REARCH             ,:S-WORK-FUND-TOTAL                                  
REARCH             ,:S-AMT-TO-TRANSFER                                  
REARCH             ,:S-DEPOSITABLE-AMT                                  
REARCH             ,:S-PREV-BANK-TRANS                                  
REARCH             ,:S-TOTAL-BANKTRANS                                  
REARCH             ,:S-CASH-DRAWER-ID                                   
REARCH             ,:S-STATUS                                           
REARCH             ,:S-CLOSED-ON                                        
REARCH             ,:S-MULTI-BATCH-IND                                  
REARCH          )                                                       
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR02308_R1                                 
MFA-TR*         (                                                               
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,GL_ACCT_NO                                                  
MFA-TR*            ,GL_ACCT_NAME                                                
MFA-TR*            ,TOTAL_GL_AMOUNT                                             
MFA-TR*            ,WORK_FUND_TOTAL                                             
MFA-TR*            ,AMT_TO_TRANSFER                                             
MFA-TR*            ,DEPOSITABLE_AMT                                             
MFA-TR*            ,PREV_BANK_TRANS                                             
MFA-TR*            ,TOTAL_BANKTRANS                                             
MFA-TR*            ,CASH_DRAWER_ID                                              
MFA-TR*            ,STATUS                                                      
MFA-TR*            ,CLOSED_ON                                                   
MFA-TR*            ,MULTI_BATCH_IND                                             
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*             :S-RETURN-CODE                                              
MFA-TR*            ,:S-GL-ACCT-NO                                               
MFA-TR*            ,:S-GL-ACCT-NAME                                             
MFA-TR*            ,:S-TOTAL-GL-AMT                                             
MFA-TR*            ,:S-WORK-FUND-TOTAL                                          
MFA-TR*            ,:S-AMT-TO-TRANSFER                                          
MFA-TR*            ,:S-DEPOSITABLE-AMT                                          
MFA-TR*            ,:S-PREV-BANK-TRANS                                          
MFA-TR*            ,:S-TOTAL-BANKTRANS                                          
MFA-TR*            ,:S-CASH-DRAWER-ID                                           
MFA-TR*            ,:S-STATUS                                                   
MFA-TR*            ,:S-CLOSED-ON                                                
MFA-TR*            ,:S-MULTI-BATCH-IND                                          
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
REARCH*                                                                         
REARCH     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
REARCH        ADD +1                    TO CTR-ROWS                     
REARCH     ELSE                                                         
REARCH        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
REARCH        MOVE '8100'               TO ACTIVE-PARAGRAPH             
REARCH        MOVE SQLCODE              TO ABEND-SQLCODE                
REARCH        MOVE 'INSERT'             TO ABEND-FUNCTION               
REARCH        MOVE SPACES               TO ABEND-SQL-PREDICATES         
REARCH                                     ABEND-TABLES                 
REARCH        MOVE 'CSR02308_R1'        TO TABLE-1                      
REARCH        MOVE SPACES               TO TABLE-ELEMENT-1              
REARCH        MOVE SPACES               TO HOSTVAR-ELEMENT-1            
REARCH        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH 8100-EXIT.                                                       
REARCH     EXIT.                                                        
REARCH*                                                                         
      ******************************************************************        
      * 9700 -  ABEND HANDLING ROUTINE                                 *42810000
      ******************************************************************42820000
                                                                        
           EXEC SQL                                                     01720000
              INCLUDE CPD0023C                                          01730000
           END-EXEC.                                                    01740000
                                                                        
      ******************************************************************42800000
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *42810000
      ******************************************************************42820000
                                                                        
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
                                                                        
      ******************************************************************42870000
      *       END PROGRAM COPYLIB                                      *42880000
      ******************************************************************42890000
                                                                        
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CPD00320                                                 
REARCH     END-EXEC.                                                            
