       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02305.                                         
COB303 DATE-WRITTEN.  JUNE 14, 2005                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S305                                           *        
      *  PROGRAM:       S305                                           *        
      *  CALLING SP:    PA_S305                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM UPDATES A ROW FROM CSS_CHRG_OFF TABLE BASED ON   *        
      *  DATA ENTERED BY USER                                          *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  01/19/95    RTO      PROCEDURE ORIGINALLY CODED.              *        
T10127*  04/04/97    EMM      REMOVED WO_STATUS OF 'G' __ CODE IS      *        
      *                       INVALID.                                 *        
T10120*  07/01/97    MKN      COMMENTED ALL LOGIC FOR UPDATE OF        *        
      *                       WO-STATUS                                *        
T12154*  07/21/97    MAD      CHANGED PARM-ITEM-ID TO PIC X(9) FOR     *        
      *                         CONTRACT WRITE-OFF PROCESSING.         *        
T16495*  05/21/98    SHF      MODIFIED PARA 5010 AND ADDED PARA 5020 TO*        
      *                       TRANSLATE THE WITHDRAW REASON CODE TO A  *        
      *                       DESCRIPTION.                             *        
CBSI  *  12/19/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *              MADRAS   ABEND PARAMETERS                         *        
T23230*  05/25/01    SS82048  CHANGES MADE TO DISPLAY JUDGEMENT AS     *        
      *                       WITHDRAW REASON IN TRANS-HST-DET WHEN AN *        
      *                       ACCOUNT IS WITHDRAWN FROM A COLLECTION   *        
      *                       AGENCY DUE TO A JUDGEMENT AWARDED ON THE *        
      *                       ACCOUNT                                           
REARCH*  06/14/05    CVNS     RPC TO COBOL SP CONVERSION               *        
REARCH*              CHENNAI                                           *        
      *                                                                *        
C30169*  05/16/08    MN90523  WO RECOVERY CHANGES                      *        
C30169*                                                                *        
F30169*  11/19/08    SS42021  PRODUCTION ISSUE. HANDLE 100 AS GOOD     *        
F30169*                       RETURN CODE FROM CSR04074.               *        
A04527*  06/06/13    MC95456  REMOVED UNUSED COPYBOOK CWS00056         *        
      *                                                                *        
A05154* 23 FEB 2015  RF10596  REMOVE UNUSED CODE                       *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02305'.
MSQ017     COPY MFASQLM.
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02305 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
REARCH*    COPY SYGWCOB.                                                        
REARCH*    COPY SYDBCOB.                                                        
           COPY CCA00001.                                                       
REARCH*    COPY CWS00010.                                                       
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CWSX0010                                                 
REARCH     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME             PIC X(08) VALUE 'CSR02305'.     
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
                                                                        
           05  WS-ACCOUNT-NO            PIC X(13).                      
           05  WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO                
                                        PIC 9(13).                      
COB305     05 WS-ACCOUNT-NO-COMP3        PIC S9(13) COMP-3 VALUE 0.             
                                                                        
T12154     05  WS-ITEM-ID               PIC X(9).                       
T12154     05  WS-ITEM-ID-NUM REDEFINES WS-ITEM-ID                      
T12154                                  PIC 9(9).                       
COB305     05 WS-ITEM-ID-COMP3        PIC S9(9) COMP-3 VALUE 0.               
                                                                        
           05  WS-CURRENT-TIMESTAMP     PIC X(26).                      
           05  WS-CURRENT-DATE          PIC X(10).                      
                                                                        
           05  WS-NULL-IND1             PIC S9(04) COMP VALUE +0.       
           05  WS-NULL-IND2             PIC S9(04) COMP VALUE +0.       
           05  WS-NULL-IND3             PIC S9(04) COMP VALUE +0.       
           05  WS-WITHDRAW-AM           PIC S9(9)V99 COMP-3 VALUE 0.    
           05  WS-AMT-DISPLAY           PIC -ZZZ,ZZZ,ZZ9.99.            
           05  WS-DATE-DISPLAY.                                         
               49 WS-DISP-MM            PIC X(02).                      
               49 FILLER                PIC X(01) VALUE '/'.            
               49 WS-DISP-DD            PIC X(02).                      
               49 FILLER                PIC X(01) VALUE '/'.            
               49 WS-DISP-YYYY          PIC X(04).                      
           05  WS-WITHDRAW-DT           PIC X(10) VALUE SPACES.         
           05  WS-RETURN-CD-4074        PIC S9(09) COMP.                
           05  WS-ACTION-TYPE-4074      PIC X(05).                      
           05  WS-SEQ-NO-4074           PIC S9(04) COMP.                
           05  WS-ACTION-DT-4074        PIC X(10).                      
           05  WS-OLD-ACTION-DT         PIC X(10).                      
           05  WS-ACTION-TYPE-CD        PIC X(05).                      
           05  WS-ORIG-ACTION-DT        PIC X(10) VALUE SPACES.         
           05  WS-WITHDRAW-RSN-CD       PIC X(01) VALUE SPACE.          
           05  WS-FW-ATTR-VALUE-DESC    PIC X(75) VALUE SPACE.          
           05  WS-FW-ATTRIB-TYPE-CD     PIC X(02) VALUE SPACE.          
           05  WS-FW-ATTR-VALUE-CD      PIC X(05) VALUE SPACE.          
           05  WS-TRAN-APPL-NO          PIC S9(04) COMP VALUE +0.       
           05  WS-ROW-COUNT             PIC S9(04) COMP VALUE +0.       
           05  WS-ACTIVE-RETURN-4074    PIC S9(04) COMP VALUE +0.       
T10120*    05  WS-WO-STATUS             PIC X(01).                              
F30169     05  WS-DISP-SQLCODE          PIC -Z(09) VALUE ZEROS.         
                                                                        
T16495     05  WS-CHG-WITHDRAW-REASN    PIC X(75).                      
      *01  LOC-RESULTSET                USAGE IS SQL TYPE IS            
      *                                 RESULT-SET-LOCATOR VARYING.     
       01  WS-LITERAL.                                                  
           05  WS-A                     PIC X(01) VALUE 'A'.            
           05  WS-B                     PIC X(01) VALUE 'B'.            
           05  WS-C                     PIC X(01) VALUE 'C'.            
           05  WS-F                     PIC X(01) VALUE 'F'.            
           05  WS-I                     PIC X(01) VALUE 'I'.            
           05  WS-M                     PIC X(01) VALUE 'M'.            
           05  WS-R                     PIC X(01) VALUE 'R'.            
           05  WS-Z                     PIC X(01) VALUE 'Z'.            
                                                                        
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-TRAN-COMMENT.                                       
               49  PARM-TRAN-COMMENT-LEN      PIC  S9(4) COMP.          
               49  PARM-TRAN-COMMENT-TEXT     PIC  X(254).              
           05  PARM-PERM-COMMENT.                                       
               49  PARM-PERM-COMMENT-LEN      PIC  S9(4) COMP.          
               49  PARM-PERM-COMMENT-TEXT     PIC  X(254).              
           05  PARM-RECV-COMMENT.                                       
               49  PARM-RECV-COMMENT-LEN      PIC  S9(4) COMP.          
               49  PARM-RECV-COMMENT-TEXT     PIC  X(254).              
           05  PARM-LAST-UPDATE-ID.                                     
               49  PARM-LAST-UPDATE-ID-LEN    PIC  S9(4) COMP VALUE +7. 
               49  PARM-LAST-UPDATE-ID-TEXT   PIC  X(07).               
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH      05  GTT-NAME                PIC X(26)                       
REARCH                                     VALUE 'SESSION.CSR02305_R1'. 
REARCH      05  GTT-ROW.                                                
REARCH          49 GTT-ROW-LEN          PIC S9(04) COMP.                
REARCH          49 GTT-ROW-CHAR         PIC X(1024).                    
REARCH      05  GTT-SQLCODE             PIC S9(9) COMP.                 
REARCH                                                                  
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
REARCH 01 CSRERLOG-P.                                                   
REARCH      10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
REARCH      10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
REARCH      10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
REARCH      10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
REARCH      10  S-HOST-VARIABLES.                                       
REARCH          49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
REARCH          49  S-HOST-VARIABLES-V  PIC X(255).                     
REARCH      10  S-SQL-STATEMENT.                                        
REARCH          49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
REARCH          49  S-SQL-STATEMENT-V   PIC X(255).                     
REARCH      10  S-SQL-DESCRIPTION.                                      
REARCH          49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
REARCH          49  S-SQL-DESCRIPTION-V PIC X(255).                     
REARCH                                                                  
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(09) COMP VALUE +0.       
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE            PIC S9(09) COMP VALUE +0.       
REARCH                                                                  
REARCH*01  CNS-COLUMN-NAMES.                                                    
REARCH*    05  CNS-RETURN-CODE          PIC X(11) VALUE 'RETURN_CODE'.          
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
             INCLUDE TBFWACTN                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
             INCLUDE TBACCT                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
             INCLUDE TBACCINF                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
             INCLUDE TBFWCLAG                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
             INCLUDE TBCOLHST                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
             INCLUDE TBCOLDET                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
MSQ001        EXEC SQL
MSQ001          DECLARE FORECAST_DT_CUR CURSOR
MSQ001          FOR CALL CSR04074                                           
                ( :PARM-ACCOUNT-NO
                  , :PARM-ACTION-TYPE-CD
                  , :PARM-COLL-SEQ-NO
                  , :WS-ORIG-ACTION-DT
                  , :PARM-WITHDRAW-DT
                  , :PARM-COMPANY-NO
                  )
MSQ001        END-EXEC.
                        
                                                                        
       LINKAGE SECTION.                                                 
REARCH 01  PARM-ACCOUNT-NO          PIC  X(13).                         
       01  PARM-ACTION-TYPE-CD      PIC  X(05).                         
       01  PARM-COLL-SEQ-NO         PIC  S9(4) COMP.                    
       01  PARM-WITHDRAW-DT         PIC  X(10).                         
COB305 01 PARM-WITHDRAW-AMT        PIC  S9(09)V99 COMP-3 VALUE 0.              
       01  PARM-WITHDRAW-RSN-CD     PIC  X(01).                         
       01  PARM-RECV-CMT-LEN        PIC  S9(4) COMP.                    
       01  PARM-RECV-CMT-TEXT       PIC  X(254).                        
       01  PARM-PERM-CMT-LEN        PIC  S9(4) COMP.                    
       01  PARM-PERM-CMT-TEXT       PIC  X(254).                        
       01  PARM-TRAN-CMT-LEN        PIC  S9(4) COMP.                    
       01  PARM-TRAN-CMT-TEXT       PIC  X(254).                        
REARCH 01  PARM-USER-ID             PIC  X(07).                         
       01  PARM-COMPANY-NO          PIC  X(02).                         
      *                                                                         
REARCH PROCEDURE DIVISION USING PARM-ACCOUNT-NO                         
                                PARM-ACTION-TYPE-CD                     
                                PARM-COLL-SEQ-NO                        
                                PARM-WITHDRAW-DT                        
                                PARM-WITHDRAW-AMT                       
                                PARM-WITHDRAW-RSN-CD                    
                                PARM-RECV-CMT-LEN                       
                                PARM-RECV-CMT-TEXT                      
                                PARM-PERM-CMT-LEN                       
                                PARM-PERM-CMT-TEXT                      
                                PARM-TRAN-CMT-LEN                       
                                PARM-TRAN-CMT-TEXT                      
REARCH                          PARM-USER-ID                            
                                PARM-COMPANY-NO.                        
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     2. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     3. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR CONTINUE END-EXEC.                
           EXEC SQL WHENEVER NOT FOUND CONTINUE END-EXEC.               
                                                                        
           EXEC SQL                                                     
REARCH          DECLARE C1 CURSOR  FOR                       
REARCH          SELECT                                                  
REARCH             :S-RETURN-CODE      AS RETURN_CODE                   
REARCH          FROM                                                    
REARCH             CIS.SYSDUMMY1                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*            :S-RETURN-CODE      AS RETURN_CODE                           
MFA-TR*         FROM                                                            
MFA-TR*            SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC.                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000' TO ACTIVE-PARAGRAPH.                             
                                                                        
           MOVE PARM-TRAN-CMT-TEXT      TO PARM-TRAN-COMMENT-TEXT.      
           MOVE PARM-TRAN-CMT-LEN       TO PARM-TRAN-COMMENT-LEN.       
           MOVE PARM-PERM-CMT-TEXT      TO PARM-PERM-COMMENT-TEXT.      
           MOVE PARM-PERM-CMT-LEN       TO PARM-PERM-COMMENT-LEN.       
           MOVE PARM-RECV-CMT-TEXT      TO PARM-RECV-COMMENT-TEXT.      
           MOVE PARM-RECV-CMT-LEN       TO PARM-RECV-COMMENT-LEN.       
           MOVE PARM-USER-ID            TO PARM-LAST-UPDATE-ID-TEXT.    
           MOVE LENGTH OF PARM-USER-ID  TO PARM-LAST-UPDATE-ID-LEN.     
                                                                        
           MOVE PARM-ACCOUNT-NO            TO WS-ACCOUNT-NO.            
           MOVE WS-ACCOUNT-NO-NUM          TO WS-ACCOUNT-NO-COMP3.      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      *     1. DESCRIBE RESULT SET                                     *        
      *     2. UPDATE DB2 DATA                                         *        
      *     3. BUILD RESULT SET                                        *        
      *     4. SEND RESULT SET                                         *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
                                                                        
           PERFORM 2200-PROCESS-UPDATE   THRU 2200-EXIT.                
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
REARCH* 2000A-MOVE-RESULT                                              *        
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
REARCH      MOVE RS-RETURN-CODE           TO S-RETURN-CODE.             
       2000A-EXIT.                                                      
REARCH      EXIT.                                                       
REARCH                                                                  
      ******************************************************************        
      *  2200-PROCESS-UPDATE                                           *        
      *                                                                *        
      ******************************************************************        
       2200-PROCESS-UPDATE.                                             
      *                                                                         
           PERFORM 5000-UPDATE                         THRU 5000-EXIT.  
      *                                                                         
           PERFORM 2000A-MOVE-RESULT                   THRU 2000A-EXIT. 
           ADD +1                                      TO CTR-ROWS.     
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   5000-UPDATE                                                  *        
      *                                                                *        
      ******************************************************************        
       5000-UPDATE.                                                     
      *                                                                         
           PERFORM 7000-GET-CURRENT-TIMESTAMP  THRU 7000-EXIT.          
                                                                        
           IF PARM-ACTION-TYPE-CD > SPACES                              
              MOVE WS-ACCOUNT-NO-COMP3          TO IZ-ACCOUNT-NO        
              MOVE PARM-ACTION-TYPE-CD          TO IZ-FW-ACTION-TYPE-CD 
              MOVE PARM-COLL-SEQ-NO             TO IZ-FW-COLL-SEQ-NO    
              PERFORM 7300-SELECT-FINWO-COLLECT THRU 7300-EXIT          
              MOVE IZ-WITHDRAW-AM               TO WS-WITHDRAW-AM       
              MOVE IZ-WITHDRAW-DT               TO WS-WITHDRAW-DT       
                                                   WS-ORIG-ACTION-DT    
              MOVE IZ-WITHDRAW-REASON-CD        TO WS-WITHDRAW-RSN-CD   
                                                                        
              IF PARM-WITHDRAW-AMT    NOT = WS-WITHDRAW-AM OR           
                 PARM-WITHDRAW-DT     NOT = WS-WITHDRAW-DT OR           
                 PARM-WITHDRAW-RSN-CD NOT = WS-WITHDRAW-RSN-CD          
                                                                        
                 PERFORM 5100-UPDATE-JOURNAL   THRU 5100-EXIT           
                                                                        
                 MOVE WS-ACCOUNT-NO-COMP3      TO IZ-ACCOUNT-NO         
                 MOVE PARM-ACTION-TYPE-CD      TO IZ-FW-ACTION-TYPE-CD  
                 MOVE PARM-COLL-SEQ-NO         TO IZ-FW-COLL-SEQ-NO     
                 MOVE PARM-WITHDRAW-DT         TO IZ-WITHDRAW-DT        
                 MOVE PARM-WITHDRAW-AMT        TO IZ-WITHDRAW-AM        
                 MOVE PARM-WITHDRAW-RSN-CD     TO IZ-WITHDRAW-REASON-CD 
                                                                        
                 PERFORM 8200-UPDATE-FINWO-COLLECT THRU 8200-EXIT       
                 IF WS-ORIG-ACTION-DT > SPACE                           
                    PERFORM 5300-FORECAST-ACTION-DATE THRU 5300-EXIT    
                 END-IF                                                 
              END-IF                                                    
           END-IF                                                       
                                                                        
                                                                        
           IF PARM-RECV-COMMENT-LEN > 0 THEN                            
              MOVE WS-ACCOUNT-NO-COMP3            TO HC-ACCOUNT-NO      
                                                                        
              PERFORM 7100-SELECT-COLLHIST-SEQ-TS THRU 7100-EXIT        
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE HC-ACCOUNT-NO                 TO AT-ACCOUNT-NO    
                                                       IF-ACCOUNT-NO    
                 PERFORM 7600-SELECT-CUSTOMER-NO    THRU 7600-EXIT      
                 MOVE AT-CUSTOMER-NO                TO IF-CUSTOMER-NO   
                 PERFORM 8410-INSERT-COLL-ACCT-INFO THRU 8410-EXIT      
                 MOVE WS-CURRENT-TIMESTAMP        TO HC-COLL-HIST-SEQ-TS
                 PERFORM 8420-INSERT-COLLECT-HIST   THRU 8420-EXIT      
              END-IF                                                    
              MOVE HC-COLL-HIST-SEQ-TS        TO LH-COLL-HIST-SEQ-TS    
                                                                        
              MOVE WS-ACCOUNT-NO-COMP3            TO LH-ACCOUNT-NO      
              PERFORM 7200-SELECT-MAX-TRAN-ID     THRU 7200-EXIT        
              ADD +1                              TO LH-TRANS-ID        
                                                                        
              MOVE WS-CURRENT-DATE       TO LH-PTP-DT                   
              MOVE 0                     TO LH-PTP-AMT                  
              MOVE 'RE'                  TO LH-COLL-RESULT-CD           
              MOVE 'RV'                  TO LH-COLL-ACTION-CD           
              MOVE WS-CURRENT-DATE       TO LH-RECORD-CREATION-DT       
              MOVE WS-CURRENT-DATE       TO LH-LAST-UPDATE-DT           
              MOVE PARM-LAST-UPDATE-ID   TO LH-LAST-UPDATE-USERID       
              MOVE PARM-LAST-UPDATE-ID   TO LH-COLL-AGENT-ID            
              MOVE PARM-RECV-COMMENT     TO LH-COMMENTS-TX              
              MOVE 0                     TO LH-PTP-ARREARS-AM           
                                                                        
              PERFORM 8400-INSERT-COLL-HIST-DET   THRU 8400-EXIT        
           END-IF.                                                      
                                                                        
           IF PARM-PERM-COMMENT-LEN > 0 THEN                            
              MOVE WS-ACCOUNT-NO-COMP3        TO IF-ACCOUNT-NO          
              MOVE PARM-PERM-COMMENT          TO IF-COLL-COMMENT-TX     
              MOVE PARM-LAST-UPDATE-ID        TO IF-LAST-UPDATE-USERID  
                                                                        
              PERFORM 8300-UPDATE-COLL-ACCT-INFO  THRU 8300-EXIT        
           END-IF.                                                      
      *                                                                         
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5100-UPDATE-JOURNAL                                            *        
      *                                                                *        
      ******************************************************************        
       5100-UPDATE-JOURNAL.                                             
      *                                                                         
           MOVE WS-CURRENT-TIMESTAMP        TO MH-TRANS-HIST-SEQ-NO.    
           MOVE WS-CURRENT-DATE             TO MH-DATE-TRANS.           
           MOVE 'F'                         TO MH-CODE-TRAN-TYPE.       
           MOVE SPACES                      TO MH-RESP-AREA-ID.         
           MOVE WS-ACCOUNT-NO-COMP3         TO MH-ACCOUNT-NO.           
           MOVE ZEROS                       TO MH-PREMISE-NO.           
           MOVE ZEROS                       TO MH-CUSTOMER-NO.          
           MOVE PARM-USER-ID                TO MH-USER-ID.              
           MOVE PARM-TRAN-COMMENT           TO MH-TRAN-COMMENT.         
           MOVE 'PANEL134'                  TO MH-APPL-PROGRAM-ID.      
           MOVE +1                          TO WS-TRAN-APPL-NO.         
      *                                                                         
           PERFORM 5200-UPDATE-JRNL-FINWO-COLLECT THRU 5200-EXIT.       
      *                                                                         
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5200-UPDATE-JRNL-FINWO-COLLECT                                 *        
      *                                                                *        
      ******************************************************************        
       5200-UPDATE-JRNL-FINWO-COLLECT.                                  
      *                                                                         
           MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO.     
           MOVE WS-TRAN-APPL-NO            TO MI-TRAN-APPL-NO.          
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO.     
           MOVE 'AT'                       TO WS-FW-ATTRIB-TYPE-CD.     
           MOVE PARM-ACTION-TYPE-CD        TO WS-FW-ATTR-VALUE-CD.      
           PERFORM 7400-SELECT-ACTION-DESC THRU 7400-EXIT.              
           MOVE 'ACTION TYPE'              TO MI-COLUMN-DESC.           
           MOVE WS-FW-ATTR-VALUE-DESC      TO MI-PRV-COLUMN-VALUE-TEXT. 
           MOVE LENGTH OF WS-FW-ATTR-VALUE-DESC                         
                                           TO MI-PRV-COLUMN-VALUE-LEN.  
           MOVE '*UPDATED*'                TO MI-CHG-COLUMN-VALUE-TEXT. 
           MOVE +9                         TO MI-CHG-COLUMN-VALUE-LEN.  
                                                                        
           MOVE WS-TRAN-APPL-NO            TO MI-TRAN-APPL-NO.          
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1                           TO WS-TRAN-APPL-NO.          
      *                                                                         
           IF PARM-WITHDRAW-AMT NOT = WS-WITHDRAW-AM                    
              MOVE MH-TRANS-HIST-SEQ-NO    TO MI-TRANS-HIST-SEQ-NO      
              MOVE 'WITHDRAW AMT'          TO MI-COLUMN-DESC            
              MOVE +16                     TO MI-PRV-COLUMN-VALUE-LEN   
                                              MI-CHG-COLUMN-VALUE-LEN   
              IF WS-WITHDRAW-AM EQUAL 0                                 
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE WS-WITHDRAW-AM       TO WS-AMT-DISPLAY            
                 MOVE WS-AMT-DISPLAY       TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
                                                                        
              MOVE PARM-WITHDRAW-AMT       TO WS-AMT-DISPLAY            
              MOVE WS-AMT-DISPLAY          TO MI-CHG-COLUMN-VALUE-TEXT  
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE '62'                    TO MI-TABLE-ID               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF PARM-WITHDRAW-DT NOT = WS-WITHDRAW-DT                     
              MOVE MH-TRANS-HIST-SEQ-NO    TO MI-TRANS-HIST-SEQ-NO      
              MOVE 'WITHDRAW DATE'         TO MI-COLUMN-DESC            
              MOVE +10                     TO MI-PRV-COLUMN-VALUE-LEN   
                                              MI-CHG-COLUMN-VALUE-LEN   
              IF WS-WITHDRAW-DT = SPACES THEN                           
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE WS-WITHDRAW-DT(1:4)  TO WS-DISP-YYYY              
                 MOVE WS-WITHDRAW-DT(6:2)  TO WS-DISP-MM                
                 MOVE WS-WITHDRAW-DT(9:2)  TO WS-DISP-DD                
                 MOVE WS-DATE-DISPLAY      TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE PARM-WITHDRAW-DT(1:4)   TO WS-DISP-YYYY              
              MOVE PARM-WITHDRAW-DT(6:2)   TO WS-DISP-MM                
              MOVE PARM-WITHDRAW-DT(9:2)   TO WS-DISP-DD                
              MOVE WS-DATE-DISPLAY         TO MI-CHG-COLUMN-VALUE-TEXT  
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE '62'                    TO MI-TABLE-ID               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF PARM-WITHDRAW-RSN-CD NOT = WS-WITHDRAW-RSN-CD             
              MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO     
              MOVE 'WITHDRAW REASON'        TO MI-COLUMN-DESC           
              MOVE +30                      TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
              IF WS-WITHDRAW-RSN-CD = SPACES THEN                       
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
              ELSE                                                      
                 MOVE 'WD'                  TO WS-FW-ATTRIB-TYPE-CD     
                 MOVE WS-WITHDRAW-RSN-CD    TO WS-FW-ATTR-VALUE-CD      
                 PERFORM 7400-SELECT-ACTION-DESC THRU 7400-EXIT         
                 MOVE WS-FW-ATTR-VALUE-DESC TO MI-PRV-COLUMN-VALUE-TEXT 
              END-IF                                                    
              MOVE 'WD'                     TO WS-FW-ATTRIB-TYPE-CD     
              MOVE PARM-WITHDRAW-RSN-CD     TO WS-FW-ATTR-VALUE-CD      
              PERFORM 7400-SELECT-ACTION-DESC THRU 7400-EXIT            
              MOVE WS-FW-ATTR-VALUE-DESC    TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE '62'                     TO MI-TABLE-ID              
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                         TO WS-TRAN-APPL-NO          
           END-IF.                                                      
      *                                                                         
       5200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5300-FORECAST-ACTION-DATE                                      *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       5300-FORECAST-ACTION-DATE.                                       
      *                                                                         
           PERFORM 7500-CALL-CSR04074       THRU 7500-EXIT.             
      *                                                                         
       5300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ******************************************************************        
      * 5400-PROCESS-FORECAST-DATES                                    *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       5400-PROCESS-FORECAST-DATES.                                     
      *                                                                         
           IF WS-ACTION-TYPE-4074 = '1PLWD' OR '2PLWD' OR '3PLWD'       
                                                                        
              MOVE WS-ACCOUNT-NO-COMP3      TO IZ-ACCOUNT-NO            
                                                                        
              EVALUATE WS-ACTION-TYPE-4074                              
              WHEN '1PLWD'                                              
                 MOVE '1PLMT'               TO IZ-FW-ACTION-TYPE-CD     
              WHEN '2PLWD'                                              
                 MOVE '2PLMT'               TO IZ-FW-ACTION-TYPE-CD     
              WHEN '3PLWD'                                              
                 MOVE '3PLMT'               TO IZ-FW-ACTION-TYPE-CD     
              END-EVALUATE                                              
              MOVE IZ-FW-ACTION-TYPE-CD     TO WS-ACTION-TYPE-CD        
                                                                        
              MOVE WS-SEQ-NO-4074           TO IZ-FW-COLL-SEQ-NO        
              PERFORM 7300-SELECT-FINWO-COLLECT                         
                                            THRU 7300-EXIT              
              MOVE IZ-WITHDRAW-DT           TO WS-OLD-ACTION-DT         
           ELSE                                                         
                                                                        
              MOVE WS-ACCOUNT-NO-COMP3      TO KD-ACCOUNT-NO            
              MOVE WS-ACTION-TYPE-4074      TO KD-FW-ACTION-TYPE-CD     
                                               WS-ACTION-TYPE-CD        
              MOVE WS-SEQ-NO-4074           TO KD-FW-SEQ-NO             
              PERFORM 7350-SELECT-FINWO-ACTION                          
                                            THRU 7350-EXIT              
              MOVE KD-FW-ACTION-DT          TO WS-OLD-ACTION-DT         
           END-IF.                                                      
                                                                        
           IF WS-ACTION-DT-4074 NOT = WS-OLD-ACTION-DT                  
                                                                        
              MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO     
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE 'AT'                     TO WS-FW-ATTRIB-TYPE-CD     
              MOVE WS-ACTION-TYPE-4074      TO WS-FW-ATTR-VALUE-CD      
              PERFORM 7400-SELECT-ACTION-DESC                           
                                            THRU 7400-EXIT              
                                                                        
              MOVE 'ACTION TYPE'            TO MI-COLUMN-DESC           
              MOVE WS-FW-ATTR-VALUE-DESC    TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF WS-FW-ATTR-VALUE-DESC                      
                                            TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE '*UPDATED*'              TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE +9                       TO MI-CHG-COLUMN-VALUE-LEN  
                                                                        
              PERFORM 6530-LOAD-MNT-TRANS-HIST                          
                                            THRU 6530-EXIT              
              ADD +1                        TO WS-TRAN-APPL-NO          
                                                                        
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              IF WS-ACTION-TYPE-4074 = '1PLWD' OR '2PLWD' OR '3PLWD'    
                 MOVE 'WITHDRAW DATE'       TO MI-COLUMN-DESC           
              ELSE                                                      
                 MOVE 'ACTION DATE'         TO MI-COLUMN-DESC           
              END-IF                                                    
              MOVE WS-OLD-ACTION-DT(1:4)    TO WS-DISP-YYYY             
              MOVE WS-OLD-ACTION-DT(6:2)    TO WS-DISP-MM               
              MOVE WS-OLD-ACTION-DT(9:2)    TO WS-DISP-DD               
              MOVE WS-DATE-DISPLAY          TO MI-PRV-COLUMN-VALUE-TEXT 
                                                                        
              MOVE WS-ACTION-DT-4074(1:4)   TO WS-DISP-YYYY             
              MOVE WS-ACTION-DT-4074(6:2)   TO WS-DISP-MM               
              MOVE WS-ACTION-DT-4074(9:2)   TO WS-DISP-DD               
              MOVE WS-DATE-DISPLAY          TO MI-CHG-COLUMN-VALUE-TEXT 
                                                                        
              MOVE +10                      TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD +1                        TO WS-TRAN-APPL-NO          
                                                                        
              IF WS-ACTION-TYPE-4074 = '1PLWD' OR '2PLWD' OR '3PLWD'    
                 MOVE WS-ACCOUNT-NO-COMP3   TO IZ-ACCOUNT-NO            
                 MOVE WS-ACTION-TYPE-CD     TO IZ-FW-ACTION-TYPE-CD     
                 MOVE WS-SEQ-NO-4074        TO IZ-FW-COLL-SEQ-NO        
                 MOVE WS-ACTION-DT-4074     TO IZ-WITHDRAW-DT           
                 PERFORM 8225-UPDATE-FINWO-COLLECT-DT                   
                                            THRU 8225-EXIT              
              ELSE                                                      
                 MOVE WS-ACCOUNT-NO-COMP3   TO KD-ACCOUNT-NO            
                 MOVE WS-ACTION-TYPE-CD     TO KD-FW-ACTION-TYPE-CD     
                 MOVE WS-SEQ-NO-4074        TO KD-FW-SEQ-NO             
                 MOVE WS-ACTION-DT-4074     TO KD-FW-ACTION-DT          
                 PERFORM 8220-UPDATE-FINWO-ACTION-DT                    
                                            THRU 8220-EXIT              
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       5400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 7000-GET-CURRENT-TIMESTAMP.                               *             
      ****************************************************************          
                                                                        
       7000-GET-CURRENT-TIMESTAMP.                                      
CBSI       MOVE '7000'                 TO ACTIVE-PARAGRAPH              
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-TIMESTAMP,
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP,                  
MFA-TR*             :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CBSI       MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
CBSI       IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
CBSI          NEXT SENTENCE                                             
           ELSE                                                         
CBSI          MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
CBSI          MOVE 'SET'               TO ABEND-FUNCTION                
CBSI          MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
CBSI          MOVE PARM-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1             
CBSI          PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
CBSI          PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *7100-SELECT-COLLHIST-SEQ-TS                                   *          
      ****************************************************************          
      *                                                                         
       7100-SELECT-COLLHIST-SEQ-TS.                                     
      *                                                                         
           MOVE '7100'                 TO ACTIVE-PARAGRAPH              
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) REPLACE(REPLACE(CONVERT(CHAR(26), 
           COLL_HIST_SEQ_TS, 121), ' ', '-'), ':', '.') 
           COLL_HIST_SEQ_TS                                     
              INTO                                                      
                   :HC-COLL-HIST-SEQ-TS                                 
              FROM                                                      
                   CSS_COLLECT_HIST WITH(READUNCOMMITTED)                       
              WHERE                                                     
                   ACCOUNT_NO        = :HC-ACCOUNT-NO                   
              ORDER BY COLL_HIST_SEQ_TS DESC                            
                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*            COLL_HIST_SEQ_TS                                             
MFA-TR*       INTO                                                              
MFA-TR*            :HC-COLL-HIST-SEQ-TS                                         
MFA-TR*       FROM                                                              
MFA-TR*            CSS_COLLECT_HIST                                             
MFA-TR*       WHERE                                                             
MFA-TR*            ACCOUNT_NO        = :HC-ACCOUNT-NO                           
MFA-TR*       ORDER BY COLL_HIST_SEQ_TS DESC                                    
MFA-TR*       FETCH FIRST 1 ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_COLLECT_HIST'    TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE HC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  7200-SELECT-MAX-TRAN-ID                                     *          
      ****************************************************************          
      *                                                                         
       7200-SELECT-MAX-TRAN-ID.                                         
      *                                                                         
           MOVE '7200'                 TO ACTIVE-PARAGRAPH              
                                                                        
           EXEC SQL                                                     
              SELECT                                                    
                  MAX(TRANS_ID)                                         
              INTO                                                      
                  :LH-TRANS-ID :WS-NULL-IND2                             
              FROM                                                      
                  CSS_COLL_HIST_DET                                     
              WHERE                                                     
                  ACCOUNT_NO        = :LH-ACCOUNT-NO                    
              AND COLL_HIST_SEQ_TS  = CIS.CHAR2TIMESTAMP(
                                                   :LH-COLL-HIST-SEQ-TS
              )              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*           MAX(TRANS_ID)                                                 
MFA-TR*       INTO                                                              
MFA-TR*           :LH-TRANS-ID:WS-NULL-IND2                                     
MFA-TR*       FROM                                                              
MFA-TR*           CSS_COLL_HIST_DET                                             
MFA-TR*       WHERE                                                             
MFA-TR*           ACCOUNT_NO        = :LH-ACCOUNT-NO                            
MFA-TR*       AND COLL_HIST_SEQ_TS  = :LH-COLL-HIST-SEQ-TS                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-NULL-IND2 < 0 THEN                                  
                 MOVE 0                  TO LH-TRANS-ID                 
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7200'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_COLL_HIST_DET'   TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE LH-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  7300-SELECT-FINWO-COLLECT.                                  *          
      ****************************************************************          
      *                                                                         
       7300-SELECT-FINWO-COLLECT.                                       
      *                                                                         
           MOVE '7300'                 TO ACTIVE-PARAGRAPH              
                                                                        
           EXEC SQL                                                     
               SELECT                                                   
                   WITHDRAW_AM                                          
                  ,WITHDRAW_DT                                          
                  ,WITHDRAW_REASON_CD                                   
               INTO                                                     
                   :IZ-WITHDRAW-AM                                      
                  ,:IZ-WITHDRAW-DT :WS-NULL-IND1                         
                  ,:IZ-WITHDRAW-REASON-CD                               
               FROM                                                     
                   CSS_FIN_WO_COLLECT                                   
               WHERE                                                    
                   ACCOUNT_NO         = :IZ-ACCOUNT-NO                  
               AND FW_ACTION_TYPE_CD  = :IZ-FW-ACTION-TYPE-CD           
               AND FW_COLL_SEQ_NO     = :IZ-FW-COLL-SEQ-NO              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              IF WS-NULL-IND1 < 0                                       
                 MOVE SPACES             TO IZ-WITHDRAW-DT              
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7300'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_FIN_WO_COLLECT'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'ACTION_TYPE_CD'      TO TABLE-ELEMENT-2             
              MOVE 'COLL_SEQ_NO'         TO TABLE-ELEMENT-3             
              MOVE IZ-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE IZ-FW-ACTION-TYPE-CD  TO HOSTVAR-ELEMENT-2           
              MOVE IZ-FW-COLL-SEQ-NO     TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  7350-SELECT-FINWO-ACTION.                                   *          
      ****************************************************************          
      *                                                                         
       7350-SELECT-FINWO-ACTION.                                        
      *                                                                         
           MOVE '7350'                 TO ACTIVE-PARAGRAPH              
                                                                        
           EXEC SQL                                                     
               SELECT                                                   
                   FW_ACTION_DT                                         
               INTO                                                     
                   :KD-FW-ACTION-DT                                     
               FROM                                                     
                   CSS_FIN_WO_ACTION                                    
               WHERE                                                    
                   ACCOUNT_NO         = :KD-ACCOUNT-NO                  
               AND FW_ACTION_TYPE_CD  = :KD-FW-ACTION-TYPE-CD           
               AND FW_SEQ_NO          = :KD-FW-SEQ-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7350'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_FIN_WO_ACTION'   TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'FW_ACTION_TYPE_CD'   TO TABLE-ELEMENT-2             
              MOVE 'FW_SEQ_NO'           TO TABLE-ELEMENT-3             
              MOVE KD-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE KD-FW-ACTION-TYPE-CD  TO HOSTVAR-ELEMENT-2           
              MOVE KD-FW-SEQ-NO          TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  7400-SELECT-ACTION-DESC.                                    *          
      ****************************************************************          
      *                                                                         
       7400-SELECT-ACTION-DESC.                                         
      *                                                                         
           MOVE '7400'                 TO ACTIVE-PARAGRAPH              
                                                                        
           EXEC SQL                                                     
               SELECT                                                   
                   FW_ATTR_VALUE_DESC                                   
               INTO                                                     
                   :WS-FW-ATTR-VALUE-DESC                               
               FROM                                                     
                   CSS_FW_ATTRIB_DESC                                   
               WHERE                                                    
                   FW_ATTRIB_TYPE_CD   = :WS-FW-ATTRIB-TYPE-CD          
               AND FW_ATTR_VALUE_CD    = :WS-FW-ATTR-VALUE-CD           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7400'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_FW_ATTRIB_DESC'  TO TABLE-1                     
              MOVE 'FW_ATTRIB_TYPE_CD'   TO TABLE-ELEMENT-1             
              MOVE 'FW_ATTR_VALUE_CD'    TO TABLE-ELEMENT-2             
              MOVE WS-FW-ATTRIB-TYPE-CD  TO HOSTVAR-ELEMENT-1           
              MOVE WS-FW-ATTR-VALUE-CD   TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7500-CALL-CSR04074.                                            *        
      ******************************************************************        
      *                                                                         
       7500-CALL-CSR04074.                                              
      *                                                                         
      *    EXEC SQL                                                     
      *         CALL CSR04074                                           
      *         (                                                       
      *             :PARM-ACCOUNT-NO                                    
      *            ,:PARM-ACTION-TYPE-CD                                
      *            ,:PARM-COLL-SEQ-NO                                   
      *            ,:WS-ORIG-ACTION-DT                                  
      *            ,:PARM-WITHDRAW-DT                                   
      *            ,:PARM-COMPANY-NO                                    
      *         )                                                       
      *    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE FORECAST_DT_CUR
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN FORECAST_DT_CUR
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR FORECAST_DT_CUR INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
      *                                                                         
           IF SQLCODE = +466 THEN                                       
      *        EXEC SQL                                                 
      *            ASSOCIATE LOCATORS (:LOC-RESULTSET)                  
      *            WITH PROCEDURE CSR04074                              
      *        END-EXEC                                                 
                                                                        
      *        EXEC SQL                                                 
      *            ALLOCATE FORECAST_DT_CUR CURSOR                      
      *            FOR RESULT SET :LOC-RESULTSET                        
      *        END-EXEC                                                 
                                                                        
               MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE    
               PERFORM 7550-FETCH-FORECAST-DT-CUR                       
                                            THRU 7550-EXIT              
               UNTIL WS-ACTIVE-RETURN-4074 EQUAL NOT-FOUND              
                                                                        
               EXEC SQL                                                 
                  CLOSE FORECAST_DT_CUR                                 
               END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                 
F30169     ELSE                                                         
F30169         MOVE -1                        TO WS-ACTIVE-RETURN-CODE  
F30169         MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
F30169         MOVE '7500'                    TO ACTIVE-PARAGRAPH       
F30169         MOVE 'CALL'                    TO ABEND-FUNCTION         
F30169         MOVE SQLCODE                   TO WS-DISP-SQLCODE        
F30169         STRING 'SQLCODE= '     DELIMITED BY SIZE                 
F30169                WS-DISP-SQLCODE DELIMITED BY SIZE INTO            
F30169                TABLE-1                                           
F30169         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
F30169         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7550-FETCH-FORECAST-DT-CUR                                     *        
      ******************************************************************        
      *                                                                         
       7550-FETCH-FORECAST-DT-CUR.                                      
      *                                                                         
           EXEC SQL                                                     
                FETCH                                                   
                    FORECAST_DT_CUR                                     
                INTO                                                    
                    :WS-RETURN-CD-4074                                  
                   ,:WS-ACTION-TYPE-4074                                
                   ,:WS-SEQ-NO-4074                                     
                   ,:WS-ACTION-DT-4074                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            WS-ACTIVE-RETURN-4074.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
F30169           EVALUATE WS-RETURN-CD-4074                             
F30169              WHEN 0                                              
                      PERFORM 5400-PROCESS-FORECAST-DATES THRU 5400-EXIT
F30169              WHEN 100                                            
F30169                CONTINUE                                          
F30169              WHEN OTHER                                          
F30169                  MOVE WS-RETURN-CD-4074 TO WS-ACTIVE-RETURN-CODE 
                        MOVE PROGRAM-NAME      TO ABEND-PROGRAM         
                        MOVE '7550'            TO ACTIVE-PARAGRAPH      
                        MOVE 'CSR04074-RESULT' TO ABEND-FUNCTION        
                        MOVE SPACES            TO ABEND-SQL-PREDICATES  
                                                      ABEND-TABLES      
                        MOVE 'FORECAST_DT_CUR' TO TABLE-1               
                        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT   
                        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT   
F30169           END-EVALUATE                                           
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7550'                TO ACTIVE-PARAGRAPH            
              MOVE 'FETCH'               TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'FORECAST_DT_CUR'     TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7550-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7600-SELECT-CUSTOMER-NO                                        *        
      ******************************************************************        
      *                                                                         
       7600-SELECT-CUSTOMER-NO.                                         
      *                                                                         
           EXEC SQL                                                     
                SELECT                                                  
                    CUSTOMER_NO                                         
                INTO                                                    
                    :AT-CUSTOMER-NO                                     
                FROM                                                    
                   CSS_ACCOUNT                                          
                WHERE                                                   
                   ACCOUNT_NO = :AT-ACCOUNT-NO                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7600'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       7600-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ****************************************************************          
      *  8200-UPDATE-FINWO-COLLECT.                                  *          
      ****************************************************************          
      *                                                                         
       8200-UPDATE-FINWO-COLLECT.                                       
      *                                                                         
           MOVE '8200'                 TO ACTIVE-PARAGRAPH              
                                                                        
           EXEC SQL                                                     
               UPDATE                                                   
                   CSS_FIN_WO_COLLECT                                   
               SET WITHDRAW_AM        = :IZ-WITHDRAW-AM                 
                  ,WITHDRAW_DT        = IIF(TRY_CONVERT(DATE, 
                                                        :IZ-WITHDRAW-DT
              ) IS NULL OR (PATINDEX('%.%', :IZ-WITHDRAW-DT
              ) <> 0) OR (LEN(:IZ-WITHDRAW-DT) <> 10), CIS.CHAR2DATE(
                                                        :IZ-WITHDRAW-DT
              ), CONVERT(DATE, :IZ-WITHDRAW-DT) )                 
                  ,WITHDRAW_REASON_CD = :IZ-WITHDRAW-REASON-CD          
               WHERE                                                    
                   ACCOUNT_NO         = :IZ-ACCOUNT-NO                  
               AND FW_ACTION_TYPE_CD  = :IZ-FW-ACTION-TYPE-CD           
               AND FW_COLL_SEQ_NO     = :IZ-FW-COLL-SEQ-NO              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE                                                           
MFA-TR*            CSS_FIN_WO_COLLECT                                           
MFA-TR*        SET WITHDRAW_AM        = :IZ-WITHDRAW-AM                         
MFA-TR*           ,WITHDRAW_DT        = :IZ-WITHDRAW-DT                         
MFA-TR*           ,WITHDRAW_REASON_CD = :IZ-WITHDRAW-REASON-CD                  
MFA-TR*        WHERE                                                            
MFA-TR*            ACCOUNT_NO         = :IZ-ACCOUNT-NO                          
MFA-TR*        AND FW_ACTION_TYPE_CD  = :IZ-FW-ACTION-TYPE-CD                   
MFA-TR*        AND FW_COLL_SEQ_NO     = :IZ-FW-COLL-SEQ-NO                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8200'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_FIN_WO_COLLECT'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'ACTION_TYPE_CD'      TO TABLE-ELEMENT-2             
              MOVE 'COLL_SEQ_NO'         TO TABLE-ELEMENT-3             
              MOVE 'WITHDRAW_DT'         TO TABLE-ELEMENT-4             
              MOVE IZ-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE IZ-FW-ACTION-TYPE-CD  TO HOSTVAR-ELEMENT-2           
              MOVE IZ-FW-COLL-SEQ-NO     TO HOSTVAR-ELEMENT-3           
              MOVE IZ-WITHDRAW-DT        TO HOSTVAR-ELEMENT-4           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  8220-UPDATE-FINWO-ACTION-DT                                 *          
      ****************************************************************          
      *                                                                         
       8220-UPDATE-FINWO-ACTION-DT.                                     
      *                                                                         
           MOVE '8225'                 TO ACTIVE-PARAGRAPH              
                                                                        
           EXEC SQL                                                     
               UPDATE                                                   
                   CSS_FIN_WO_ACTION                                    
               SET FW_ACTION_DT       = IIF(TRY_CONVERT(DATE, 
                                                       :KD-FW-ACTION-DT
              ) IS NULL OR (PATINDEX('%.%', :KD-FW-ACTION-DT
              ) <> 0) OR (LEN(:KD-FW-ACTION-DT) <> 10), CIS.CHAR2DATE(
                                                       :KD-FW-ACTION-DT
              ), CONVERT(DATE, :KD-FW-ACTION-DT) )                
               WHERE                                                    
                   ACCOUNT_NO         = :KD-ACCOUNT-NO                  
               AND FW_ACTION_TYPE_CD  = :KD-FW-ACTION-TYPE-CD           
               AND FW_SEQ_NO          = :KD-FW-SEQ-NO                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE                                                           
MFA-TR*            CSS_FIN_WO_ACTION                                            
MFA-TR*        SET FW_ACTION_DT       = :KD-FW-ACTION-DT                        
MFA-TR*        WHERE                                                            
MFA-TR*            ACCOUNT_NO         = :KD-ACCOUNT-NO                          
MFA-TR*        AND FW_ACTION_TYPE_CD  = :KD-FW-ACTION-TYPE-CD                   
MFA-TR*        AND FW_SEQ_NO          = :KD-FW-SEQ-NO                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8220'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_FIN_WO_ACTION'   TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'FW_ACTION_TYPE_CD'   TO TABLE-ELEMENT-2             
              MOVE 'FW_SEQ_NO'           TO TABLE-ELEMENT-3             
              MOVE 'FW_ACTION_DT'        TO TABLE-ELEMENT-4             
              MOVE KD-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE KD-FW-ACTION-TYPE-CD  TO HOSTVAR-ELEMENT-2           
              MOVE KD-FW-SEQ-NO          TO HOSTVAR-ELEMENT-3           
              MOVE KD-FW-ACTION-DT       TO HOSTVAR-ELEMENT-4           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       8220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
      ****************************************************************          
      *  8225-UPDATE-FINWO-COLLECT-DT                                *          
      ****************************************************************          
      *                                                                         
       8225-UPDATE-FINWO-COLLECT-DT.                                    
      *                                                                         
           MOVE '8225'                 TO ACTIVE-PARAGRAPH              
                                                                        
           EXEC SQL                                                     
               UPDATE                                                   
                   CSS_FIN_WO_COLLECT                                   
               SET WITHDRAW_DT        = IIF(TRY_CONVERT(DATE, 
                                                        :IZ-WITHDRAW-DT
              ) IS NULL OR (PATINDEX('%.%', :IZ-WITHDRAW-DT
              ) <> 0) OR (LEN(:IZ-WITHDRAW-DT) <> 10), CIS.CHAR2DATE(
                                                        :IZ-WITHDRAW-DT
              ), CONVERT(DATE, :IZ-WITHDRAW-DT) )                 
               WHERE                                                    
                   ACCOUNT_NO         = :IZ-ACCOUNT-NO                  
               AND FW_ACTION_TYPE_CD  = :IZ-FW-ACTION-TYPE-CD           
               AND FW_COLL_SEQ_NO     = :IZ-FW-COLL-SEQ-NO              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE                                                           
MFA-TR*            CSS_FIN_WO_COLLECT                                           
MFA-TR*        SET WITHDRAW_DT        = :IZ-WITHDRAW-DT                         
MFA-TR*        WHERE                                                            
MFA-TR*            ACCOUNT_NO         = :IZ-ACCOUNT-NO                          
MFA-TR*        AND FW_ACTION_TYPE_CD  = :IZ-FW-ACTION-TYPE-CD                   
MFA-TR*        AND FW_COLL_SEQ_NO     = :IZ-FW-COLL-SEQ-NO                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8200'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_FIN_WO_COLLECT'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'ACTION_TYPE_CD'      TO TABLE-ELEMENT-2             
              MOVE 'COLL_SEQ_NO'         TO TABLE-ELEMENT-3             
              MOVE 'WITHDRAW_DT'         TO TABLE-ELEMENT-4             
              MOVE IZ-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE IZ-FW-ACTION-TYPE-CD  TO HOSTVAR-ELEMENT-2           
              MOVE IZ-FW-COLL-SEQ-NO     TO HOSTVAR-ELEMENT-3           
              MOVE IZ-WITHDRAW-DT        TO HOSTVAR-ELEMENT-4           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       8225-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  8300-UPDATE-COLL-ACCT-INFO.                                 *          
      ****************************************************************          
      *                                                                         
       8300-UPDATE-COLL-ACCT-INFO.                                      
      *                                                                         
           MOVE '8300'                 TO ACTIVE-PARAGRAPH              
                                                                        
           EXEC SQL                                                     
               UPDATE                                                   
                   CSS_COLL_ACCT_INFO                                   
               SET COLL_COMMENT_TX    = :IF-COLL-COMMENT-TX             
                  ,LAST_UPDATE_USERID = :IF-LAST-UPDATE-USERID          
               WHERE                                                    
                   ACCOUNT_NO         = :IF-ACCOUNT-NO                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8300'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_COLL_ACCT_INFO'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE IF-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  8400-UPDATE-COLL-HIST-DET.                                  *          
      ****************************************************************          
      *                                                                         
       8400-INSERT-COLL-HIST-DET.                                       
      *                                                                         
           MOVE '8400'                 TO ACTIVE-PARAGRAPH              
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_COLL_HIST_DET                            
               (                                                        
                  ACCOUNT_NO                                            
                 ,COLL_HIST_SEQ_TS                                      
                 ,TRANS_ID                                              
                 ,PTP_DT                                                
                 ,PTP_AMT                                               
                 ,COLL_RESULT_CD                                        
                 ,COLL_ACTION_CD                                        
                 ,RECORD_CREATION_DT                                    
                 ,LAST_UPDATE_DT                                        
                 ,LAST_UPDATE_USERID                                    
                 ,COLL_AGENT_ID                                         
                 ,COMMENTS_TX                                           
                 ,PTP_ARREARS_AM                                        
               )                                                        
               VALUES                                                   
               (                                                        
                  :LH-ACCOUNT-NO                                        
                 ,CIS.CHAR2TIMESTAMP(:LH-COLL-HIST-SEQ-TS)                      
                 ,:LH-TRANS-ID                                          
                 ,IIF(TRY_CONVERT(DATE, :LH-PTP-DT
              ) IS NULL OR (PATINDEX('%.%', :LH-PTP-DT) <> 0) OR (LEN(
                                                             :LH-PTP-DT
              ) <> 10), CIS.CHAR2DATE(:LH-PTP-DT), CONVERT(DATE, 
                                                             :LH-PTP-DT
              ) )                                            
                 ,:LH-PTP-AMT                                           
                 ,:LH-COLL-RESULT-CD                                    
                 ,:LH-COLL-ACTION-CD                                    
                 ,IIF(TRY_CONVERT(DATE, :LH-RECORD-CREATION-DT
              ) IS NULL OR (PATINDEX('%.%', :LH-RECORD-CREATION-DT
              ) <> 0) OR (LEN(:LH-RECORD-CREATION-DT
              ) <> 10), CIS.CHAR2DATE(:LH-RECORD-CREATION-DT
              ), CONVERT(DATE, :LH-RECORD-CREATION-DT) )                       
                 ,IIF(TRY_CONVERT(DATE, :LH-LAST-UPDATE-DT
              ) IS NULL OR (PATINDEX('%.%', :LH-LAST-UPDATE-DT
              ) <> 0) OR (LEN(:LH-LAST-UPDATE-DT
              ) <> 10), CIS.CHAR2DATE(:LH-LAST-UPDATE-DT
              ), CONVERT(DATE, :LH-LAST-UPDATE-DT) )                           
                 ,:LH-LAST-UPDATE-USERID                                
                 ,:LH-COLL-AGENT-ID                                     
                 ,:LH-COMMENTS-TX                                       
                 ,:LH-PTP-ARREARS-AM                                    
               )                                                        
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_COLL_HIST_DET                                    
MFA-TR*        (                                                                
MFA-TR*           ACCOUNT_NO                                                    
MFA-TR*          ,COLL_HIST_SEQ_TS                                              
MFA-TR*          ,TRANS_ID                                                      
MFA-TR*          ,PTP_DT                                                        
MFA-TR*          ,PTP_AMT                                                       
MFA-TR*          ,COLL_RESULT_CD                                                
MFA-TR*          ,COLL_ACTION_CD                                                
MFA-TR*          ,RECORD_CREATION_DT                                            
MFA-TR*          ,LAST_UPDATE_DT                                                
MFA-TR*          ,LAST_UPDATE_USERID                                            
MFA-TR*          ,COLL_AGENT_ID                                                 
MFA-TR*          ,COMMENTS_TX                                                   
MFA-TR*          ,PTP_ARREARS_AM                                                
MFA-TR*        )                                                                
MFA-TR*        VALUES                                                           
MFA-TR*        (                                                                
MFA-TR*           :LH-ACCOUNT-NO                                                
MFA-TR*          ,:LH-COLL-HIST-SEQ-TS                                          
MFA-TR*          ,:LH-TRANS-ID                                                  
MFA-TR*          ,:LH-PTP-DT                                                    
MFA-TR*          ,:LH-PTP-AMT                                                   
MFA-TR*          ,:LH-COLL-RESULT-CD                                            
MFA-TR*          ,:LH-COLL-ACTION-CD                                            
MFA-TR*          ,:LH-RECORD-CREATION-DT                                        
MFA-TR*          ,:LH-LAST-UPDATE-DT                                            
MFA-TR*          ,:LH-LAST-UPDATE-USERID                                        
MFA-TR*          ,:LH-COLL-AGENT-ID                                             
MFA-TR*          ,:LH-COMMENTS-TX                                               
MFA-TR*          ,:LH-PTP-ARREARS-AM                                            
MFA-TR*        )                                                                
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8400'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_COLL_HIST_DET'   TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'COLL_HIST_SEQ_TS'    TO TABLE-ELEMENT-2             
              MOVE 'TRANS_ID'            TO TABLE-ELEMENT-3             
              MOVE LH-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE LH-COLL-HIST-SEQ-TS   TO HOSTVAR-ELEMENT-2           
              MOVE LH-TRANS-ID           TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  8410-INSERT-COLL-ACCT-INFO                                  *          
      ****************************************************************          
      *                                                                         
       8410-INSERT-COLL-ACCT-INFO.                                      
      *                                                                         
           MOVE '8410'                 TO ACTIVE-PARAGRAPH              
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_COLL_ACCT_INFO                           
               (                                                        
                  ACCOUNT_NO                                            
                 ,CUSTOMER_NO                                           
               )                                                        
               VALUES                                                   
               (                                                        
                  :IF-ACCOUNT-NO                                        
                 ,:IF-CUSTOMER-NO                                       
               )                                                        
                                                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8410'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_COLL_ACCT_INFO'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2             
              MOVE IF-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE IF-CUSTOMER-NO        TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       8410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *  8420-INSERT-COLLECT-HIST                                    *          
      ****************************************************************          
      *                                                                         
       8420-INSERT-COLLECT-HIST.                                        
      *                                                                         
           MOVE '8420'                 TO ACTIVE-PARAGRAPH              
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_COLLECT_HIST                             
               (                                                        
                  ACCOUNT_NO                                            
                 ,COLL_HIST_SEQ_TS                                      
               )                                                        
               VALUES                                                   
               (                                                        
                  :HC-ACCOUNT-NO                                        
                 ,CIS.CHAR2TIMESTAMP(:HC-COLL-HIST-SEQ-TS)                      
               )                                                        
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_COLLECT_HIST                                     
MFA-TR*        (                                                                
MFA-TR*           ACCOUNT_NO                                                    
MFA-TR*          ,COLL_HIST_SEQ_TS                                              
MFA-TR*        )                                                                
MFA-TR*        VALUES                                                           
MFA-TR*        (                                                                
MFA-TR*           :HC-ACCOUNT-NO                                                
MFA-TR*          ,:HC-COLL-HIST-SEQ-TS                                          
MFA-TR*        )                                                                
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8420'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_COLLECT_HIST'    TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'COLL_HIST_SEQ_TS'    TO TABLE-ELEMENT-2             
              MOVE HC-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1                
              MOVE HC-COLL-HIST-SEQ-TS   TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       8420-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
                                                                        
      ******************************************************************        
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
REARCH*    COPY CPD00302.                                                       
           EXEC SQL                                                             
REARCH        INCLUDE CPD00321                                                  
           END-EXEC.                                                            
