       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR02304.                                     
COB303 DATE-WRITTEN.                                                    
COB303            JANUARY 3, 1996.                                      
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETREIVES ACCOUNT-GUARANTOR RELATIONSHIP RECORDS *        
      *  FROM THE CSS_GUARANTOR TABLE                                  *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  01/03/96    RNK      CREATED.                                 *        
      *  07/10/96    JRX      PCR194 - GUARANTOR ESTABLISHED DATE      *        
      *                       RETRIEVE THE ESTABLISHED DATE FROM       *        
      *                       CSS_GUARANTOR TABLE AND PASS IT TO PANEL *        
      *                       245.                                     *        
TP5801*  10/29/96    JEP      MOVE ACCT-TYPE-DESC FROM CSS_ACCOUNT TO  *        
      *                       RS-GUAR-ACCT-TYPE TO DISPLAY PROPER VALUE*        
      *                                                                *        
TP8432*  01/16/97    MAD      MODIFICATIONS TO RETURN A 9 PLACE NUMERIC*        
      *                        FOR RS-WS-ITEM-ID.                      *        
TP8452*  01/27/97    JEP      TPR 8452 - CWS10014 AND CPD00308 WERE    *        
TP8452*                       ADDED TO HANDLE MAXIMUM DEPOSIT ESTIMATES*        
TP8452*                       IN ADDITION TO VARIABLES AND SUPPORTING  *        
TP8452*                       CODE.                                    *        
TP8452*  02/06/97     KB      REMNAMED COPYBOOK CWS10014 TO CWS00308   *        
TP9461*  02/26/97     PP      CHANGED LENGTH OF RS-STREET-SUFFIX FROM  *        
TP9461*                       2 TO 4                                   *        
T10290*  04/10/97    MAD      ADDED CSS_CUST_PREM_HIST DCLGEN TO       *        
T10290*                       SUPPORT CPD00308 CHANGES.                *        
T11792*  06/24/97    MAD      ADDED CSS_BILLING_HDR DCLGEN TO          *        
T11792*                       SUPPORT CPD00308 CHANGES.                *        
T13991*  12/08/97    BAB      INITIALIZE CB-PHONE.                     *        
T16079*  05/04/98    SHF      CORRECTED ERRORS IN LOADING THE MC05     *        
      *                       ERROR LOG.                               *        
T17856*  09/24/98    SHF      MOVED CWS00308 INCLUDE TO END OF WS.     *        
CBSI  *  12/18/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *              MADRAS   ABEND PARAMETERS                         *        
T19779*  06/17/99    SHF      ADDED CUSTOMER NUMBER TO THE RESULT SET  *        
      *                       FOR POWERBUILDER.                        *        
T19468*  07/27/99    MDJ      ADDED ORDER BY TO GUARANTOR CURSOR       *        
      *                       INORDER FOR ACTIVES TO DISPLAY FIRST.    *        
T22668*  08/23/00    SFH      CPD00308 NEEDS TO KNOW IF ACCOUNT        *        
      *                       IS SCEG OR SEB.                          *        
T23513*  01/19/01   AS        CHANGES MADE TO DISTINGUISH DATABASES SEB*        
T23513*                       AND NON SEB TO INCORPORATE PSNC IN NON   *        
T23513*                       SEB                                      *        
T23501*  02/13/01    SFH      ADDED COMPANY_NO TO THE WHERE CLAUSE IN  *        
      *                       PARA 6500 TO SUPPORT MULTI-COMPANY.      *        
T23179*  05/08/01    SS82048  CHANGES FOR PSNC TO COMPUTE MAXIMUM      *        
T23179*                       DEPOSIT AMOUNT FOR SEASONAL /            *        
T23179*                       NON-SEASONAL RATES.                      *        
C26446*  06/14/02    LF19392  MOVE INITIALIZE ON WORK PHONE            *        
REARCH*  07/10/03    MN90523  RPC CONVERTED TO COBOL SP                *        
REARC2*  09/30/03    BASKAR 1.REMOVE ROWICMS CALL AND USE STATIC INSERT*        
REARC2*                     2.DELETE COMMENTED CODES FOR CLEAN UP      *        
REARC2*                       PROCESSING AS PER BRUCE BIERNASKI        *        
C33201*  09/14/05    SS82048  INCLUDE DCLGEN FOR CSS_REG_PROFILE       *        
      *                       AND CSS_LOCAL_OFFICE                     *        
      *                       FOR MAX DEPOSIT CALCULATION CHANGES.     *        
ACT278*  10/08/16    TP7R341  REMOVE UNWANTED COLUMNS FROM CONTRACT    *        
ACT278*                       INFO USER TABLE                          *        
A05091*  11/07/16    RB19957  ADDED TBATMISC WHICH IS NOW NEEDED       *        
A05091*                       IN CPD00308 FOR SEB SEASONAL FLAG.       *        
      * ****************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02304'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR02304 STARTS HERE'.                  
                                                                        
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *---< CSS_GUARANTOR >                                                     
           EXEC SQL                                                             
              INCLUDE TBGTNTR                                                   
           END-EXEC.                                                            
                                                                        
      *---< CSS_ACCOUNT >                                                       
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      *---< CSS_NAME >                                                          
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
                                                                        
      *---< CSS_ADDR_FORMATTED >                                                
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_ADDR_FREEFORM >                                                 
           EXEC SQL                                                             
              INCLUDE TBADRFRE                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_ZIP_CODE >                                                      
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
                                                                        
      *---< CSS_CUST_PHONE  >                                                   
           EXEC SQL                                                             
              INCLUDE TBCSTPHN                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_CUST_STATS  >                                                   
           EXEC SQL                                                             
              INCLUDE TBCSTSTS                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_CONTRACT  >                                                     
           EXEC SQL                                                             
              INCLUDE TBCNTRCT                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_CONTRACT_INFO >                                                 
           EXEC SQL                                                             
              INCLUDE TBCNTINF                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
                                                                        
T10290     EXEC SQL                                                             
T10290        INCLUDE TBCSTPRM                                                  
T10290     END-EXEC.                                                            
                                                                        
T11792     EXEC SQL                                                             
T11792        INCLUDE TBBLLHDR                                                  
T11792     END-EXEC.                                                            
                                                                        
T22668     EXEC SQL                                                             
T22668        INCLUDE TBDELQ                                                    
T22668     END-EXEC.                                                            
                                                                        
T23179     EXEC SQL                                                             
T23179        INCLUDE TBUTLENV                                                  
T23179     END-EXEC.                                                            
      *                                                                         
T23179     EXEC SQL                                                             
T23179        INCLUDE TBRTCRTR                                                  
T23179     END-EXEC.                                                            
      *                                                                         
C33201************************************************************              
C33201**   CSS_REG_PROFILE (LR)                                                 
C33201************************************************************              
C33201     EXEC SQL                                                             
C33201        INCLUDE TBREGPRF                                                  
C33201     END-EXEC.                                                            
C33201*                                                                         
C33201************************************************************              
C33201**   CSS_LOCAL_OFFICE (B1)                                                
C33201************************************************************              
C33201     EXEC SQL                                                             
C33201        INCLUDE TBLOCOFC                                                  
C33201     END-EXEC.                                                            
C33201*                                                                         
A05091************************************************************              
A05091**   CSS_ACCT_MISC_INFO TA                                                
A05091************************************************************              
A05091     EXEC SQL                                                             
A05091        INCLUDE TBATMISC                                                  
A05091     END-EXEC.                                                            
A05091*                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
REARCH*    COPY SYGWCOB.                                                        
REARCH*    COPY SYDBCOB.                                                        
           COPY CCA00001.                                                       
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CWSX0010                                                 
REARCH     END-EXEC.                                                            
REARCH*    COPY CWS00010.                                                       
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
           COPY CWS00056.                                                       
      *                                                                         
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
COB305     05 PARM-ACCOUNT-NO-NUM        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.        
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
TP5801 01  WS-ACCOUNT-TYPE-CODE        PIC X(01) VALUE SPACE.           
                                                                        
       01  WS-SUB                      PIC S9(8) COMP VALUE ZERO.       
       01  WS-MISC.                                                     
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR02304'.      
REARCH     05  WS-SQLSTATE             PIC X(05) VALUE '     '.         
           05  WS-LENGTH                    PIC S9(4).                  
           05  WS-MAX-SZ                    PIC S9(4).                  
           05  WS-ADD-SUB-CNT          PIC 99 VALUE 1.                  
           05  WS-MONTH                PIC X(02) VALUE SPACES.          
           05  WS-DAY                  PIC X(02) VALUE SPACES.          
           05  WS-YEAR                 PIC X(04) VALUE SPACES.          
                                                                        
       01  NULL-INDICATOR-FIELDS.                                       
           05  WS-TRIGGER-DATE-NI        PIC S9(4) COMP VALUE 0.        
           05  WS-ESTBLSH-DATE-NI        PIC S9(4) COMP VALUE 0.        
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-ACTIVE-CODE          PIC X(01) VALUE 'A'.             
REARCH*                                                                         
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
REARCH     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
REARCH     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
REARCH     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
REARCH         49  S-HOST-VARIABLES-V    PIC X(255).                    
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
REARCH         49  S-SQL-STATEMENT-V     PIC X(255).                    
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
REARCH         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
REARCH*                                                                         
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  ROWICMS                 PIC X(07) VALUE 'ROWICMS'.       
REARCH     05  GTT-NAME                PIC X(26)                        
REARCH                                  VALUE 'SESSION.CSR02304_R1'.    
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN          PIC S9(04) COMP.                 
REARCH         49 GTT-ROW-CHAR         PIC X(1024).                     
REARCH     05  GTT-SQLCODE             PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-GRNT-ACCT-TYPE       PIC X(01) VALUE SPACE.           
           05  RS-AMT-GUARANTEE        PIC S9(9)V9(2) USAGE COMP-3      
                                           VALUE 0.                     
           05  RS-GUAR-ESTBLSH-DT      PIC X(08) VALUE SPACE.           
           05  RS-CODE-GUAR-STATUS     PIC X(01) VALUE SPACE.           
           05  RS-TRIGGER-DATE         PIC X(08) VALUE SPACE.           
           05  RS-STATUS-REASON        PIC X(20) VALUE SPACE.           
           05  RS-CODE-SERV-TYPE       PIC X(01) VALUE SPACE.           
           05  RS-CNT-ITEM-ID          PIC S9(9) COMP VALUE 0.          
           05  RS-AMT-ORIG-ENTERED     PIC S9(11)V9(2) USAGE COMP-3     
                                           VALUE 0.                     
ACT278     05  RS-CNT-NAME-DESC        PIC X(10) VALUE SPACE.           
           05  RS-SEND-NOTICE-FLAG     PIC X(01) VALUE SPACE.           
           05  RS-SN-ADDR-FLAG         PIC X(01) VALUE SPACE.           
           05  RS-GUAR-ACCT-NO         PIC X(13) VALUE SPACE.           
           05  RS-CREDIT-STATUS-CD     PIC X(01) VALUE SPACE.           
           05  RS-ADDRESS-ID           PIC X(13) VALUE SPACE.           
           05  RS-GUAR-ACCT-TYPE       PIC X(01) VALUE SPACE.           
           05  RS-UPDATE-TS            PIC X(26) VALUE SPACE.           
           05  RS-NAME-USAGE           PIC X(01) VALUE SPACE.           
           05  RS-FULL-NAME            PIC X(70) VALUE SPACE.           
           05  RS-TITLE                PIC X(09) VALUE SPACE.           
           05  RS-FIRST-NAME           PIC X(15) VALUE SPACE.           
           05  RS-MIDDLE-NAME          PIC X(15) VALUE SPACE.           
           05  RS-LAST-NAME            PIC X(40) VALUE SPACE.           
           05  RS-TITLE-SUFFIX1        PIC X(03) VALUE SPACE.           
           05  RS-TITLE-SUFFIX2        PIC X(03) VALUE SPACE.           
           05  RS-ADDR-USAGE           PIC X(01) VALUE SPACE.           
T36933*    05  RS-ADDR-STREET          PIC X(35) VALUE SPACE.                   
T36933*    05  RS-HOUSE-NO             PIC X(05) VALUE SPACE.                   
T36933     05  RS-ADDR-STREET          PIC X(55) VALUE SPACE.           
T36933     05  RS-HOUSE-NO             PIC X(15) VALUE SPACE.           
           05  RS-ADDR-PREFIX1         PIC X(03) VALUE SPACE.           
T36933*    05  RS-ADDR-CITY-STATE      PIC X(20) VALUE SPACE.                   
T36933     05  RS-ADDR-CITY-STATE      PIC X(30) VALUE SPACE.           
           05  RS-ADDR-PREFIX2         PIC X(02) VALUE SPACE.           
T36933*    05  RS-STREET-NAME          PIC X(16) VALUE SPACE.                   
T36933     05  RS-STREET-NAME          PIC X(30) VALUE SPACE.           
           05  RS-STREET-SUFFIX        PIC X(04) VALUE SPACE.           
           05  RS-ADDR-SUFFIX          PIC X(02) VALUE SPACE.           
           05  RS-ADDR-ZIP-CODE        PIC X(09) VALUE SPACE.           
           05  RS-STREET-LOCATION1     PIC X(04) VALUE SPACE.           
T36933*    05  RS-STREET-LOCATION2     PIC X(04) VALUE SPACE.                   
T36933     05  RS-STREET-LOCATION2     PIC X(11) VALUE SPACE.           
           05  RS-ADDR-COUNTRY         PIC X(35) VALUE SPACE.           
           05  RS-TOWN                 PIC X(26) VALUE SPACE.           
           05  RS-STATE                PIC X(02) VALUE SPACE.           
           05  RS-ZIP-CODE             PIC X(05) VALUE SPACE.           
           05  RS-ZIP-CODE-PLUS        PIC X(04) VALUE SPACE.           
           05  RS-ADDR-OVERFLOW        PIC X(35) VALUE SPACE.           
           05  RS-ADDR-OVERFLOW-FORM   PIC X(35) VALUE SPACE.           
           05  RS-CARRIER-ROUTE        PIC X(05) VALUE SPACE.           
           05  RS-HOME-PHONE           PIC X(10) VALUE SPACE.           
           05  RS-WORK-PHONE           PIC X(10) VALUE SPACE.           
           05  RS-PHONE-EXT            PIC X(06) VALUE SPACE.           
           05  RS-DRIVER-LICENSE       PIC X(19) VALUE SPACE.           
           05  RS-CODE-STATE-ID        PIC X(02) VALUE SPACE.           
           05  RS-SSN                  PIC X(09) VALUE SPACE.           
T36933*    05  RS-SN-STREET            PIC X(35) VALUE SPACE.                   
T36933*    05  RS-SN-CITY-STATE        PIC X(20) VALUE SPACE.                   
T36933     05  RS-SN-STREET            PIC X(55) VALUE SPACE.           
T36933     05  RS-SN-CITY-STATE        PIC X(30) VALUE SPACE.           
           05  RS-SN-ZIP-CODE          PIC X(09) VALUE SPACE.           
           05  RS-SN-COUNTRY           PIC X(35) VALUE SPACE.           
           05  RS-SN-OVERFLOW          PIC X(35) VALUE SPACE.           
           05  RS-WQ-ITEM-ID           PIC S9(10)V COMP-3               
                                       VALUE ZERO.                      
TP8452     05  RS-NUMBER-OF-BILLS      PIC S9(04)V    USAGE COMP-3      
TP8452                                 VALUE 0.                         
TP8452     05  RS-MIN-DEPOSIT-AMT      PIC S9(09)V99  USAGE COMP-3      
TP8452                                 VALUE 0.                         
TP8452     05  RS-MAX-DEPOSIT-AMT      PIC S9(09)V99  USAGE COMP-3      
TP8452                                 VALUE 0.                         
T19779     05  RS-CUSTOMER-NO          PIC X(10)      VALUE SPACES.     
TP8452     05  RS-USAGE-HISTORY-FLAG   PIC X(01)      VALUE SPACES.     
REARCH*                                                                         
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
REARCH     05  S-GRNT-ACCT-TYPE        PIC X(01) VALUE SPACE.           
REARCH     05  S-AMT-GUARANTEE         PIC S9(9)V9(2) USAGE COMP-3      
REARCH                                     VALUE 0.                     
REARCH     05  S-CODE-GUAR-STATUS      PIC X(01) VALUE SPACE.           
REARCH     05  S-TRIGGER-DATE          PIC X(08) VALUE SPACE.           
REARCH     05  S-STATUS-REASON         PIC X(20) VALUE SPACE.           
REARCH     05  S-CODE-SERV-TYPE        PIC X(01) VALUE SPACE.           
REARCH     05  S-CNT-ITEM-ID           PIC S9(9) COMP VALUE 0.          
REARCH     05  S-AMT-ORIG-ENTERED      PIC S9(11)V9(2) USAGE COMP-3     
REARCH                                     VALUE 0.                     
REARCH     05  S-CNT-NAME-ABBR         PIC X(10) VALUE SPACE.           
REARCH     05  S-SEND-NOTICE-FLAG      PIC X(01) VALUE SPACE.           
REARCH     05  S-SN-ADDR-FLAG          PIC X(01) VALUE SPACE.           
REARCH     05  S-GUAR-ACCT-NO          PIC X(13) VALUE SPACE.           
REARCH     05  S-CREDIT-STATUS-CD      PIC X(01) VALUE SPACE.           
REARCH     05  S-ADDRESS-ID            PIC X(13) VALUE SPACE.           
REARCH     05  S-GUAR-ACCT-TYPE        PIC X(01) VALUE SPACE.           
REARCH     05  S-UPDATE-TS             PIC X(26) VALUE SPACE.           
REARCH     05  S-NAME-USAGE            PIC X(01) VALUE SPACE.           
REARCH     05  S-FULL-NAME             PIC X(70) VALUE SPACE.           
REARCH     05  S-TITLE                 PIC X(09) VALUE SPACE.           
REARCH     05  S-FIRST-NAME            PIC X(15) VALUE SPACE.           
REARCH     05  S-MIDDLE-NAME           PIC X(15) VALUE SPACE.           
REARCH     05  S-LAST-NAME             PIC X(40) VALUE SPACE.           
REARCH     05  S-TITLE-SUFFIX1         PIC X(03) VALUE SPACE.           
REARCH     05  S-TITLE-SUFFIX2         PIC X(03) VALUE SPACE.           
REARCH     05  S-ADDR-USAGE            PIC X(01) VALUE SPACE.           
T36933*    05  S-ADDR-STREET           PIC X(35) VALUE SPACE.                   
T36933     05  S-ADDR-STREET           PIC X(55) VALUE SPACE.           
T36933*    05  S-HOUSE-NO              PIC X(05) VALUE SPACE.                   
T36933     05  S-HOUSE-NO              PIC X(15) VALUE SPACE.           
REARCH     05  S-ADDR-PREFIX1          PIC X(03) VALUE SPACE.           
T36933*    05  S-ADDR-CITY-STATE       PIC X(20) VALUE SPACE.                   
T36933     05  S-ADDR-CITY-STATE       PIC X(30) VALUE SPACE.           
REARCH     05  S-ADDR-PREFIX2          PIC X(02) VALUE SPACE.           
T36933*    05  S-STREET-NAME           PIC X(16) VALUE SPACE.                   
T36933     05  S-STREET-NAME           PIC X(30) VALUE SPACE.           
REARCH     05  S-STREET-SUFFIX         PIC X(04) VALUE SPACE.           
REARCH     05  S-ADDR-SUFFIX           PIC X(02) VALUE SPACE.           
REARCH     05  S-ADDR-ZIP-CODE         PIC X(09) VALUE SPACE.           
REARCH     05  S-STREET-LOCATION1      PIC X(04) VALUE SPACE.           
T36933*    05  S-STREET-LOCATION2      PIC X(04) VALUE SPACE.                   
T36933     05  S-STREET-LOCATION2      PIC X(11) VALUE SPACE.           
REARCH     05  S-ADDR-COUNTRY          PIC X(35) VALUE SPACE.           
REARCH     05  S-TOWN                  PIC X(26) VALUE SPACE.           
REARCH     05  S-STATE                 PIC X(02) VALUE SPACE.           
REARCH     05  S-ZIP-CODE              PIC X(05) VALUE SPACE.           
REARCH     05  S-ZIP-CODE-PLUS         PIC X(04) VALUE SPACE.           
REARCH     05  S-ADDR-OVERFLOW         PIC X(35) VALUE SPACE.           
REARCH     05  S-ADDR-OVERFLOW-FORM    PIC X(35) VALUE SPACE.           
REARCH     05  S-CARRIER-ROUTE         PIC X(05) VALUE SPACE.           
REARCH     05  S-HOME-PHONE            PIC X(10) VALUE SPACE.           
REARCH     05  S-WORK-PHONE            PIC X(10) VALUE SPACE.           
REARCH     05  S-PHONE-EXT             PIC X(06) VALUE SPACE.           
REARCH     05  S-DRIVER-LICENSE        PIC X(19) VALUE SPACE.           
REARCH     05  S-CODE-STATE-ID         PIC X(02) VALUE SPACE.           
REARCH     05  S-SSN                   PIC X(09) VALUE SPACE.           
T36933*    05  S-SN-STREET             PIC X(35) VALUE SPACE.                   
T36933*    05  S-SN-CITY-STATE         PIC X(20) VALUE SPACE.                   
T36933     05  S-SN-STREET             PIC X(55) VALUE SPACE.           
T36933     05  S-SN-CITY-STATE         PIC X(30) VALUE SPACE.           
REARCH     05  S-SN-ZIP-CODE           PIC X(09) VALUE SPACE.           
REARCH     05  S-SN-COUNTRY            PIC X(35) VALUE SPACE.           
REARCH     05  S-SN-OVERFLOW           PIC X(35) VALUE SPACE.           
REARCH     05  S-WQ-ITEM-ID            PIC S9(10)V COMP-3               
REARCH                                 VALUE ZERO.                      
REARCH     05  S-GUAR-ESTBLSH-DT       PIC X(08) VALUE SPACE.           
REARCH     05  S-MAX-DEPOSIT-AMT       PIC S9(09)V99  USAGE COMP-3      
REARCH                                 VALUE 0.                         
REARCH     05  S-CUSTOMER-NO           PIC X(10)      VALUE SPACES.     
REARCH*                                                                         
TP8452 01  RS-REDEFINITIONS.                                            
TP8452     05  WS-ACCOUNT-PARM          PIC X(13).                      
TP8452     05  WS-ACCOUNT-DEC REDEFINES WS-ACCOUNT-PARM                 
TP8452                                  PIC 9(13).                      
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.       
      *                                                                         
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
T23513     05  WS-DATABASE             PIC 9(01) VALUE ZERO.            
T23513         88  CSR-DATABASE                  VALUE 1.               
T23513         88  SEB-DATABASE                  VALUE 2.               
                                                                        
       01  CN-CONSTANTS.                                                
           05  CN-DELIMITER                 PIC X VALUE ';'.            
                                                                        
TP8452     EXEC SQL                                                             
TP8452         INCLUDE CWS00308                                                 
TP8452     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
           EXEC SQL DECLARE GUARANTOR-CURSOR CURSOR FOR                 
              SELECT ADDRESS_ID, AMOUNT_GUARANTEED,                     
                     CNT_ITEM_ID, GUAR_NOTICE_FLAG, GUAR_STATUS_CD,     
                     GUAR_STATUS_REASON, GUAR_TRIGGER_DATE,             
                     GUARNTR_ACCT_NO, SERVICE_TYPE_CD, REPLACE(REPLACE(
           CONVERT(CHAR(26), LAST_UPDATE_TS, 121), ' ', '-'), ':', 
           '.') LAST_UPDATE_TS,  
                     ITEM_ID, GUAR_ESTBLSH_DT                           
                FROM CSS_GUARANTOR                                      
               WHERE ACCOUNT_NO = :GU-ACCOUNT-NO                        
T19468         ORDER BY GUAR_STATUS_CD                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE GUARANTOR-CURSOR CURSOR FOR                         
MFA-TR*       SELECT ADDRESS_ID, AMOUNT_GUARANTEED,                             
MFA-TR*              CNT_ITEM_ID, GUAR_NOTICE_FLAG, GUAR_STATUS_CD,             
MFA-TR*              GUAR_STATUS_REASON, GUAR_TRIGGER_DATE,                     
MFA-TR*              GUARNTR_ACCT_NO, SERVICE_TYPE_CD, LAST_UPDATE_TS,          
MFA-TR*              ITEM_ID, GUAR_ESTBLSH_DT                                   
MFA-TR*         FROM CSS_GUARANTOR                                              
MFA-TR*        WHERE ACCOUNT_NO = :GU-ACCOUNT-NO                                
MFA-TR*        ORDER BY GUAR_STATUS_CD                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
                                                                        
           EXEC SQL DECLARE CONTRACT-CURSOR CURSOR FOR                  
              SELECT CT.CNT_ITEM_ID, CT.AMT_ORIG_ENTERED,               
ACT278               K6.CNT_NAME_DESC                                   
                FROM CSS_CONTRACT CT, CSS_CONTRACT_INFO K6              
               WHERE CT.ACCOUNT_NO = :CT-ACCOUNT-NO AND                 
                     K6.CNT_NAME_CD = CT.CNT_NAME_CD AND                
                     CT.CNT_ITEM_ID NOT IN                              
                     (SELECT CNT_ITEM_ID FROM CSS_GUARANTOR WHERE       
                      ACCOUNT_NO = :CT-ACCOUNT-NO)                      
           END-EXEC.                                                    
                                                                        
HPCCDM*EJECT                                                                    
REARCH*                                                                         
REARCH LINKAGE SECTION.                                                 
REARCH 01  PARM-ACCOUNT-NO               PIC X(13).                     
REARCH*                                                                         
REARCH PROCEDURE DIVISION USING PARM-ACCOUNT-NO.                        
REARCH*                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
REARCH*                                                                         
REARCH     PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH                                                                  
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARCH             RETURN_CODE                                          
REARCH            ,GRNT_ACCT_TYPE                                       
REARCH            ,AMT_GUARANTEE                                        
REARCH            ,GUAR_STATUS                                          
REARCH            ,TRIGGER_DATE                                         
REARCH            ,RTRIM(STATUS_REASON)   AS STATUS_REASON              
REARCH            ,SERV_TYPE                                            
REARCH            ,CONTRACT_ID                                          
REARCH            ,CONTRACT_AMT                                         
REARCH            ,CNT_NAME_ABBR                                        
REARCH            ,SEND_NOTICE_FLAG                                     
REARCH            ,SN_ADDR_FLAG                                         
REARCH            ,GUAR_ACCT                                            
REARCH            ,CREDIT_STATUS_CD                                     
REARCH            ,ADDRESS_ID                                           
REARCH            ,GUAR_ACCT_TYPE                                       
REARCH            ,UPDATE_TS                                            
REARCH            ,NAME_USAGE                                           
REARCH            ,RTRIM(FULL_NAME)       AS FULL_NAME                  
REARCH            ,RTRIM(TITLE)           AS TITLE                      
REARCH            ,RTRIM(FIRST_NAME)      AS FIRST_NAME                 
REARCH            ,RTRIM(MIDDLE_NAME)     AS MIDDLE_NAME                
REARCH            ,RTRIM(LAST_NAME)       AS LAST_NAME                  
REARCH            ,TITLE_SUFFIX1                                        
REARCH            ,TITLE_SUFFIX2                                        
REARCH            ,ADDR_USAGE                                           
REARCH            ,RTRIM(FR_ADDR_STREET)  AS FR_ADDR_STREET             
REARCH            ,FO_HOUSE_NO                                          
REARCH            ,FO_ADDR_PREFIX1                                      
REARCH            ,RTRIM(FR_CITY_STATE)   AS FR_CITY_STATE              
REARCH            ,FO_ADDR_PREFIX2                                      
REARCH            ,RTRIM(FO_STREET_NAME)  AS FO_STREET_NAME             
REARCH            ,FO_STREET_SUFFIX                                     
REARCH            ,FO_ADDR_SUFFIX                                       
REARCH            ,FR_ADDR_ZIP                                          
REARCH            ,FO_STREET1                                           
REARCH            ,FO_STREET2                                           
REARCH            ,RTRIM(FR_COUNTRY)      AS FR_COUNTRY                 
REARCH            ,RTRIM(FO_TOWN)         AS FO_TOWN                    
REARCH            ,FO_STATE                                             
REARCH            ,FO_ZIP_CODE                                          
REARCH            ,FO_ZIP_PLUS                                          
REARCH            ,RTRIM(FR_OVERFLOW)     AS FR_OVERFLOW                
REARCH            ,RTRIM(FO_OVERFLOW)     AS FO_OVERFLOW                
REARCH            ,FO_CARRIER_ROUTE                                     
REARCH            ,HOME_PHONE                                           
REARCH            ,WORK_PHONE                                           
REARCH            ,PHONE_EXT                                            
REARCH            ,LICENSE                                              
REARCH            ,STATE_ID                                             
REARCH            ,SSN                                                  
REARCH            ,RTRIM(SN_STREET)       AS SN_STREET                  
REARCH            ,RTRIM(SN_CITY_STATE)   AS SN_CITY_STATE              
REARCH            ,SN_ZIP_CODE                                          
REARCH            ,RTRIM(SN_COUNTRY)      AS  SN_COUNTRY                
REARCH            ,RTRIM(SN_OVERFLOW)     AS  SN_OVERFLOW               
REARCH            ,WQ_ITEM_ID                                           
REARCH            ,GUAR_ESTBLSH_DT                                      
REARCH            ,MAX_DEPOSIT_AMT                                      
REARCH            ,GUAR_CUST_NO                                         
REARCH         FROM                                                     
REARCH             #CSR02304_R1                                  
REARCH                                                                  
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,GRNT_ACCT_TYPE                                               
MFA-TR*           ,AMT_GUARANTEE                                                
MFA-TR*           ,GUAR_STATUS                                                  
MFA-TR*           ,TRIGGER_DATE                                                 
MFA-TR*           ,RTRIM(STATUS_REASON)   AS STATUS_REASON                      
MFA-TR*           ,SERV_TYPE                                                    
MFA-TR*           ,CONTRACT_ID                                                  
MFA-TR*           ,CONTRACT_AMT                                                 
MFA-TR*           ,CNT_NAME_ABBR                                                
MFA-TR*           ,SEND_NOTICE_FLAG                                             
MFA-TR*           ,SN_ADDR_FLAG                                                 
MFA-TR*           ,GUAR_ACCT                                                    
MFA-TR*           ,CREDIT_STATUS_CD                                             
MFA-TR*           ,ADDRESS_ID                                                   
MFA-TR*           ,GUAR_ACCT_TYPE                                               
MFA-TR*           ,UPDATE_TS                                                    
MFA-TR*           ,NAME_USAGE                                                   
MFA-TR*           ,RTRIM(FULL_NAME)       AS FULL_NAME                          
MFA-TR*           ,RTRIM(TITLE)           AS TITLE                              
MFA-TR*           ,RTRIM(FIRST_NAME)      AS FIRST_NAME                         
MFA-TR*           ,RTRIM(MIDDLE_NAME)     AS MIDDLE_NAME                        
MFA-TR*           ,RTRIM(LAST_NAME)       AS LAST_NAME                          
MFA-TR*           ,TITLE_SUFFIX1                                                
MFA-TR*           ,TITLE_SUFFIX2                                                
MFA-TR*           ,ADDR_USAGE                                                   
MFA-TR*           ,RTRIM(FR_ADDR_STREET)  AS FR_ADDR_STREET                     
MFA-TR*           ,FO_HOUSE_NO                                                  
MFA-TR*           ,FO_ADDR_PREFIX1                                              
MFA-TR*           ,RTRIM(FR_CITY_STATE)   AS FR_CITY_STATE                      
MFA-TR*           ,FO_ADDR_PREFIX2                                              
MFA-TR*           ,RTRIM(FO_STREET_NAME)  AS FO_STREET_NAME                     
MFA-TR*           ,FO_STREET_SUFFIX                                             
MFA-TR*           ,FO_ADDR_SUFFIX                                               
MFA-TR*           ,FR_ADDR_ZIP                                                  
MFA-TR*           ,FO_STREET1                                                   
MFA-TR*           ,FO_STREET2                                                   
MFA-TR*           ,RTRIM(FR_COUNTRY)      AS FR_COUNTRY                         
MFA-TR*           ,RTRIM(FO_TOWN)         AS FO_TOWN                            
MFA-TR*           ,FO_STATE                                                     
MFA-TR*           ,FO_ZIP_CODE                                                  
MFA-TR*           ,FO_ZIP_PLUS                                                  
MFA-TR*           ,RTRIM(FR_OVERFLOW)     AS FR_OVERFLOW                        
MFA-TR*           ,RTRIM(FO_OVERFLOW)     AS FO_OVERFLOW                        
MFA-TR*           ,FO_CARRIER_ROUTE                                             
MFA-TR*           ,HOME_PHONE                                                   
MFA-TR*           ,WORK_PHONE                                                   
MFA-TR*           ,PHONE_EXT                                                    
MFA-TR*           ,LICENSE                                                      
MFA-TR*           ,STATE_ID                                                     
MFA-TR*           ,SSN                                                          
MFA-TR*           ,RTRIM(SN_STREET)       AS SN_STREET                          
MFA-TR*           ,RTRIM(SN_CITY_STATE)   AS SN_CITY_STATE                      
MFA-TR*           ,SN_ZIP_CODE                                                  
MFA-TR*           ,RTRIM(SN_COUNTRY)      AS  SN_COUNTRY                        
MFA-TR*           ,RTRIM(SN_OVERFLOW)     AS  SN_OVERFLOW                       
MFA-TR*           ,WQ_ITEM_ID                                                   
MFA-TR*           ,GUAR_ESTBLSH_DT                                              
MFA-TR*           ,MAX_DEPOSIT_AMT                                              
MFA-TR*           ,GUAR_CUST_NO                                                 
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR02304_R1                                          
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
REARCH*                                                                         
REARCH***************************************************************           
REARCH*  0100A-DECLARE-GTT.                                         *           
REARCH***************************************************************           
REARCH*                                                                         
REARCH 0100A-DECLARE-GTT.                                               
REARCH*                                                                         
REARCH     MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR02304_R1'            
REARCH                                   TO S-SQL-STATEMENT-V.          
REARCH     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02304_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02304_R1
              (                                                        
REARCH               RETURN_CODE            INT                     
REARCH              ,GRNT_ACCT_TYPE CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,AMT_GUARANTEE          DECIMAL(11,2)               
REARCH              ,GUAR_STATUS CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,TRIGGER_DATE CHAR(08)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,STATUS_REASON CHAR(20)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,SERV_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH              ,CONTRACT_ID            INT                     
REARCH              ,CONTRACT_AMT           DECIMAL(13,2)               
REARCH              ,CNT_NAME_ABBR CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,SEND_NOTICE_FLAG CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,SN_ADDR_FLAG CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,GUAR_ACCT CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH              ,CREDIT_STATUS_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,ADDRESS_ID CHAR(13)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,GUAR_ACCT_TYPE CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,UPDATE_TS CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH              ,NAME_USAGE CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,FULL_NAME CHAR(70)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH              ,TITLE CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2            
REARCH              ,FIRST_NAME CHAR(15)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,MIDDLE_NAME CHAR(15)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,LAST_NAME CHAR(40)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH              ,TITLE_SUFFIX1 CHAR(03)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,TITLE_SUFFIX2 CHAR(03)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,ADDR_USAGE CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
T36933              ,FR_ADDR_STREET CHAR(55)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
T36933              ,FO_HOUSE_NO CHAR(15)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
T36933*             ,FR_ADDR_STREET         CHAR(35)                            
T36933*             ,FO_HOUSE_NO            CHAR(05)                            
REARCH              ,FO_ADDR_PREFIX1 CHAR(03)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
T36933*             ,FR_CITY_STATE          CHAR(20)                            
T36933              ,FR_CITY_STATE CHAR(30)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,FO_ADDR_PREFIX2 CHAR(02)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
T36933*             ,FO_STREET_NAME         CHAR(16)                            
T36933              ,FO_STREET_NAME CHAR(30)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,FO_STREET_SUFFIX CHAR(04)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,FO_ADDR_SUFFIX CHAR(02)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,FR_ADDR_ZIP CHAR(09)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,FO_STREET1 CHAR(04)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
T36933*             ,FO_STREET2             CHAR(04)                            
T36933              ,FO_STREET2 CHAR(11)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,FR_COUNTRY CHAR(35)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,FO_TOWN CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH              ,FO_STATE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH              ,FO_ZIP_CODE CHAR(05)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,FO_ZIP_PLUS CHAR(04)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,FR_OVERFLOW CHAR(35)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,FO_OVERFLOW CHAR(35)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,FO_CARRIER_ROUTE CHAR(05)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,HOME_PHONE CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,WORK_PHONE CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,PHONE_EXT CHAR(06)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH              ,LICENSE CHAR(19)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH              ,STATE_ID CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH              ,SSN CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2              
REARCH              ,SN_STREET CHAR(35)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH              ,SN_CITY_STATE CHAR(20)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,SN_ZIP_CODE CHAR(09)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,SN_COUNTRY CHAR(35)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,SN_OVERFLOW CHAR(35)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,WQ_ITEM_ID             DECIMAL(10,0)               
REARCH              ,GUAR_ESTBLSH_DT CHAR(08)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,MAX_DEPOSIT_AMT        DECIMAL(11,2)               
REARCH              ,GUAR_CUST_NO CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH         )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH     MOVE SQLSTATE                 TO WS-SQLSTATE.                
REARCH     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
REARCH*                                                                         
REARCH     IF WS-SQLSTATE = '42710'                                     
REARCH        PERFORM 8000A-DELETE-GTT-ROWS                             
REARCH                                   THRU 8000A-EXIT                
REARCH     ELSE                                                         
REARCH         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
REARCH             NEXT SENTENCE                                        
REARCH         ELSE                                                     
REARCH            MOVE PROGRAM-NAME      TO ABEND-PROGRAM               
REARCH            MOVE '0100A'           TO ACTIVE-PARAGRAPH            
REARCH            MOVE 'DECLARE GTT'     TO ABEND-FUNCTION              
REARCH            MOVE SPACES            TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH            MOVE 'CSR02304_R1'     TO TABLE-1                     
REARCH            MOVE SPACES            TO TABLE-ELEMENT-1             
REARCH            MOVE SPACES            TO HOSTVAR-ELEMENT-1           
REARCH            PERFORM 9900-SQL-ERROR-ROUTINE                        
REARCH                                   THRU  9900-EXIT                
REARCH         END-IF                                                   
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH 0100A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO           TO PARM-ACCOUNT-NO-NUM.       
TP8452     MOVE PARM-ACCOUNT-NO           TO WS-ACCOUNT-PARM.           
TP8452     MOVE WS-ACCOUNT-DEC            TO WS-ACCOUNT-NO.             
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
           PERFORM 2200-BUILD-RESULT             THRU 2200-EXIT.        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH*                                                                         
REARCH***************************************************************           
REARCH*  2000A-MOVE-RESULT.                                         *           
REARCH***************************************************************           
REARCH*                                                                         
REARCH 2000A-MOVE-RESULT.                                               
REARCH                                                                  
REARCH     MOVE RS-RETURN-CODE            TO S-RETURN-CODE.             
REARCH     MOVE RS-GRNT-ACCT-TYPE         TO S-GRNT-ACCT-TYPE.          
REARCH     MOVE RS-AMT-GUARANTEE          TO S-AMT-GUARANTEE.           
REARCH     MOVE RS-CODE-GUAR-STATUS       TO S-CODE-GUAR-STATUS.        
REARCH     MOVE RS-TRIGGER-DATE           TO S-TRIGGER-DATE.            
REARCH     MOVE RS-STATUS-REASON          TO S-STATUS-REASON.           
REARCH     MOVE RS-CODE-SERV-TYPE         TO S-CODE-SERV-TYPE.          
REARCH     MOVE RS-CNT-ITEM-ID            TO S-CNT-ITEM-ID.             
REARCH     MOVE RS-AMT-ORIG-ENTERED       TO S-AMT-ORIG-ENTERED.        
ACT278     MOVE RS-CNT-NAME-DESC          TO S-CNT-NAME-ABBR.           
REARCH     MOVE RS-SEND-NOTICE-FLAG       TO S-SEND-NOTICE-FLAG.        
REARCH     MOVE RS-SN-ADDR-FLAG           TO S-SN-ADDR-FLAG.            
REARCH     MOVE RS-GUAR-ACCT-NO           TO S-GUAR-ACCT-NO.            
REARCH     MOVE RS-CREDIT-STATUS-CD       TO S-CREDIT-STATUS-CD.        
REARCH     MOVE RS-ADDRESS-ID             TO S-ADDRESS-ID.              
REARCH     MOVE RS-GUAR-ACCT-TYPE         TO S-GUAR-ACCT-TYPE.          
REARCH     MOVE RS-UPDATE-TS              TO S-UPDATE-TS.               
REARCH     MOVE RS-NAME-USAGE             TO S-NAME-USAGE.              
REARCH     MOVE RS-FULL-NAME              TO S-FULL-NAME.               
REARCH     MOVE RS-TITLE                  TO S-TITLE.                   
REARCH     MOVE RS-FIRST-NAME             TO S-FIRST-NAME.              
REARCH     MOVE RS-MIDDLE-NAME            TO S-MIDDLE-NAME.             
REARCH     MOVE RS-LAST-NAME              TO S-LAST-NAME.               
REARCH     MOVE RS-TITLE-SUFFIX1          TO S-TITLE-SUFFIX1.           
REARCH     MOVE RS-TITLE-SUFFIX2          TO S-TITLE-SUFFIX2.           
REARCH     MOVE RS-ADDR-USAGE             TO S-ADDR-USAGE.              
REARCH     MOVE RS-ADDR-STREET            TO S-ADDR-STREET.             
REARCH     MOVE RS-HOUSE-NO               TO S-HOUSE-NO.                
REARCH     MOVE RS-ADDR-PREFIX1           TO S-ADDR-PREFIX1.            
REARCH     MOVE RS-ADDR-CITY-STATE        TO S-ADDR-CITY-STATE.         
REARCH     MOVE RS-ADDR-PREFIX2           TO S-ADDR-PREFIX2.            
REARCH     MOVE RS-STREET-NAME            TO S-STREET-NAME.             
REARCH     MOVE RS-STREET-SUFFIX          TO S-STREET-SUFFIX.           
REARCH     MOVE RS-ADDR-SUFFIX            TO S-ADDR-SUFFIX.             
REARCH     MOVE RS-ADDR-ZIP-CODE          TO S-ADDR-ZIP-CODE.           
REARCH     MOVE RS-STREET-LOCATION1       TO S-STREET-LOCATION1.        
REARCH     MOVE RS-STREET-LOCATION2       TO S-STREET-LOCATION2.        
REARCH     MOVE RS-ADDR-COUNTRY           TO S-ADDR-COUNTRY.            
REARCH     MOVE RS-TOWN                   TO S-TOWN.                    
REARCH     MOVE RS-STATE                  TO S-STATE.                   
REARCH     MOVE RS-ZIP-CODE               TO S-ZIP-CODE.                
REARCH     MOVE RS-ZIP-CODE-PLUS          TO S-ZIP-CODE-PLUS.           
REARCH     MOVE RS-ADDR-OVERFLOW          TO S-ADDR-OVERFLOW.           
REARCH     MOVE RS-ADDR-OVERFLOW-FORM     TO S-ADDR-OVERFLOW-FORM.      
REARCH     MOVE RS-CARRIER-ROUTE          TO S-CARRIER-ROUTE.           
REARCH     MOVE RS-HOME-PHONE             TO S-HOME-PHONE.              
REARCH     MOVE RS-WORK-PHONE             TO S-WORK-PHONE.              
REARCH     MOVE RS-PHONE-EXT              TO S-PHONE-EXT.               
REARCH     MOVE RS-DRIVER-LICENSE         TO S-DRIVER-LICENSE.          
REARCH     MOVE RS-CODE-STATE-ID          TO S-CODE-STATE-ID.           
REARCH     MOVE RS-SSN                    TO S-SSN.                     
REARCH     MOVE RS-SN-STREET              TO S-SN-STREET.               
REARCH     MOVE RS-SN-CITY-STATE          TO S-SN-CITY-STATE.           
REARCH     MOVE RS-SN-ZIP-CODE            TO S-SN-ZIP-CODE.             
REARCH     MOVE RS-SN-COUNTRY             TO S-SN-COUNTRY.              
REARCH     MOVE RS-SN-OVERFLOW            TO S-SN-OVERFLOW.             
REARCH     MOVE RS-WQ-ITEM-ID             TO S-WQ-ITEM-ID.              
REARCH     MOVE RS-GUAR-ESTBLSH-DT        TO S-GUAR-ESTBLSH-DT.         
REARCH     MOVE RS-MAX-DEPOSIT-AMT        TO S-MAX-DEPOSIT-AMT.         
REARCH     MOVE RS-CUSTOMER-NO            TO S-CUSTOMER-NO.             
REARCH                                                                  
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
TP8452******************************************************************        
TP8452* INCLUDE COPYBOOK FOR DETERMINING MAX-DEPOSIT ESTIMATES         *        
TP8452******************************************************************        
TP8452*                                                                         
TP8452*                                                                         
TP8452     EXEC SQL                                                             
TP8452        INCLUDE CPD00308                                                  
TP8452     END-EXEC.                                                            
TP8452*                                                                         
      *                                                                         
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      * SOME OF THE CODE IS COMMENTED OUT TO REFLECT THE CHANGE IN THE *        
      * DESIGN. THE COMMENTED CODE ALLOWS FOR PROCESSING OF CONTRACT   *        
      * RELATED RECORDS FOR THE GUARANTEE ACCOUNT. ONCE THE ISSUES ARE *        
      * FINALIZED (IN RELEASE 2) THIS CODE CAN BE USED.                *        
      ******************************************************************        
       2200-BUILD-RESULT.                                               
                                                                        
T23501     MOVE SPACES TO AT-COMPANY-NO.                                
                                                                        
           MOVE PARM-ACCOUNT-NO-NUM TO AT-ACCOUNT-NO                    
                                       GU-ACCOUNT-NO.                   
           PERFORM 7650-PROCESS-GUARANTEE       THRU 7650-EXIT.         
                                                                        
                                                                        
           PERFORM 7005-OPEN-GUARANTOR-CURSOR   THRU 7005-EXIT.         
           PERFORM 7010-FETCH-GUARANTOR-CURSOR  THRU 7010-EXIT.         
                                                                        
           PERFORM 2210-PROCESS-GUARANTOR-CURSOR THRU 2210-EXIT         
           UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                     
                                                                        
           PERFORM 7020-CLOSE-GUARANTOR-CURSOR  THRU 7020-EXIT.         
                                                                        
T23501     IF AT-COMPANY-NO = SPACES                                    
T23501        PERFORM 7000-SELECT-COMPANY-NO THRU 7000-EXIT             
T23501     END-IF.                                                      
                                                                        
T23513     MOVE 'DATABASE'              TO C8-DELINQ-CD.                
T23513     PERFORM 6500-GET-DATABASE    THRU 6500-EXIT.                 
TP8452     PERFORM 5650-GET-MAX-DEPOSIT THRU 5650-GET-MAX-DEPOSIT-EXIT. 
TP8452     MOVE WS-MAX-DEPOSIT-AMT       TO RS-MAX-DEPOSIT-AMT.         
                                                                        
                                                                        
      **** COMMENTED OUT UNTIL RELEASE 2.                                       
      **** PERFORM 2600-PROCESS-CONTRACT        THRU 2600-EXIT.                 
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE 100                          TO RS-RETURN-CODE       
REARCH        PERFORM 2000A-MOVE-RESULT         THRU 2000A-EXIT         
              PERFORM 8100-SEND-RESULT          THRU 8100-EXIT          
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *2210-PROCESS-GUARANTOR-CURSOR.                                           
      *   CALLS 2300-PROCESS-GUARANTOR                                          
      *   CALLED BY 2200-BUILD-RESULT                                           
      ******************************************************************        
       2210-PROCESS-GUARANTOR-CURSOR.                                   
           PERFORM 2300-PROCESS-GUARANTOR       THRU 2300-EXIT.         
           PERFORM 7010-FETCH-GUARANTOR-CURSOR  THRU 7010-EXIT.         
       2210-EXIT.                                                       
            EXIT.                                                       
                                                                        
                                                                        
      ****************************************************************          
      * 2300-PROCESS-GUARANTOR                                       *          
      *                                                              *          
      *      GET NAME, ADDRESS, STATS, AND CONTRACT DETAILS FOR THE  *          
      *      GUARANTOR RECORD FETCHED BY THE CURSOR.                 *          
      *                                                              *          
      ****************************************************************          
                                                                        
       2300-PROCESS-GUARANTOR.                                          
                                                                        
           IF GU-ADDRESS-ID > 0                                         
             MOVE GU-ADDRESS-ID  TO  DZ-ADDRESS-ID                      
             PERFORM 7450-SELECT-ADDR-FREE THRU 7450-EXIT               
             MOVE DZ-ADDR-STREET          TO  RS-SN-STREET              
             MOVE DZ-ADDR-CITY-STATE      TO  RS-SN-CITY-STATE          
             MOVE DZ-ADDR-ZIP-CODE        TO  RS-SN-ZIP-CODE            
             MOVE DZ-ADDR-COUNTRY         TO  RS-SN-COUNTRY             
             MOVE DZ-ADDRESS-OVERFLOW     TO  RS-SN-OVERFLOW            
             MOVE 'Y'                     TO  RS-SN-ADDR-FLAG           
             MOVE SPACES                  TO  DZ-ADDR-STREET            
             MOVE SPACES                  TO  DZ-ADDR-CITY-STATE        
             MOVE SPACES                  TO  DZ-ADDR-ZIP-CODE          
             MOVE SPACES                  TO  DZ-ADDR-COUNTRY           
             MOVE SPACES                  TO  DZ-ADDRESS-OVERFLOW       
           ELSE                                                         
             MOVE 'N'                     TO  RS-SN-ADDR-FLAG           
             MOVE SPACES                  TO  RS-SN-STREET              
             MOVE SPACES                  TO  RS-SN-CITY-STATE          
             MOVE SPACES                  TO  RS-SN-ZIP-CODE            
             MOVE SPACES                  TO  RS-SN-COUNTRY             
             MOVE SPACES                  TO  RS-SN-OVERFLOW            
           END-IF.                                                      
                                                                        
           PERFORM 2400-GUARANTOR-DETAIL       THRU 2400-EXIT.          
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 2400-GUARANTOR-DETAIL                                        *          
      *                                                              *          
      *   1. SELECT ADDRESS, NAME, AND ID DETAILS FOR THE GUARANTOR  *          
      *   2. SEND THE RESULTS.                                       *          
      ****************************************************************          
                                                                        
       2400-GUARANTOR-DETAIL.                                           
                                                                        
           PERFORM 7200-SELECT-ACCT           THRU 7200-EXIT.           
           MOVE AT-CODES-DATA-PRESENT  TO WS-CODES-DATA-PRESENT.        
T19779     MOVE AT-CUSTOMER-NO         TO RS-CUSTOMER-NO.               
           PERFORM 2410-SELECT-ID             THRU 2410-EXIT.           
                                                                        
           IF AT-ADDRESS-ID = 0                                         
              MOVE HT-ADDRESS-ID         TO DY-ADDRESS-ID               
              MOVE 'A'                   TO RS-ADDR-USAGE               
              PERFORM 7400-SELECT-ADDR-FORM   THRU 7400-EXIT            
              MOVE SPACE TO A4-TOWN                                     
                            A4-STATE                                    
              PERFORM 7410-SELECT-CITY        THRU 7410-EXIT            
           ELSE                                                         
              IF AT-ADDRESS-FORMAT = 'A'                                
                 MOVE AT-ADDRESS-ID          TO DY-ADDRESS-ID           
                 MOVE AT-ADDRESS-FORMAT      TO RS-ADDR-USAGE           
                 PERFORM 7400-SELECT-ADDR-FORM   THRU 7400-EXIT         
                 MOVE SPACE TO A4-TOWN                                  
                               A4-STATE                                 
                 PERFORM 7410-SELECT-CITY        THRU 7410-EXIT         
              ELSE                                                      
                 IF AT-ADDRESS-FORMAT = 'B'                             
                    MOVE AT-ADDRESS-ID          TO DZ-ADDRESS-ID        
                    MOVE AT-ADDRESS-FORMAT      TO RS-ADDR-USAGE        
                    PERFORM 7450-SELECT-ADDR-FREE   THRU 7450-EXIT      
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF GU-CNT-ITEM-ID NOT= 0                                     
              PERFORM 7600-SELECT-CONT-DETAIL       THRU 7600-EXIT      
           END-IF.                                                      
                                                                        
           PERFORM 2700-SEND-RESULT           THRU 2700-EXIT.           
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 2410-SELECT-ID                                               *          
      *                                                              *          
      *  SELECT IDENTIFICATION DETAILS FOR THE GUARANTOR             *          
      ****************************************************************          
                                                                        
       2410-SELECT-ID.                                                  
                                                                        
           PERFORM 7510-SELECT-HOME-PHONE      THRU 7510-EXIT.          
           MOVE CB-PHONE-NO                    TO RS-HOME-PHONE.        
C26446     INITIALIZE CB-PHONE-NO.                                      
           PERFORM 7520-SELECT-WORK-PHONE      THRU 7520-EXIT.          
T13991*    INITIALIZE CB-PHONE-NO.                                              
           MOVE CB-PHONE-NO                    TO RS-WORK-PHONE.        
           MOVE CB-EXTENSION-NO                TO RS-PHONE-EXT.         
           PERFORM 7530-SELECT-STATS           THRU 7530-EXIT.          
           MOVE CE-CODE-STATE-ID               TO RS-CODE-STATE-ID.     
           MOVE CE-DRIVERS-LICENSE-NO          TO RS-DRIVER-LICENSE.    
           MOVE CE-SSN                         TO RS-SSN.               
                                                                        
       2410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2600-PROCESS-CONTRACT                                         *         
      *                                                               *         
      *      RETREIVE DETAILS FOR CONTRACT ID'S THAT ARE NOT IN THE   *         
      *      CSS_GUARANTOR TABLE. THIS IS TO ALLOW THE USER TO CREATE *         
      *      NEW GUARANTOR RECORDS FOR EXISTING CONTRACTS             *         
      *****************************************************************         
                                                                        
       2600-PROCESS-CONTRACT.                                           
                                                                        
           PERFORM 2610-INITIALIZE-RS               THRU 2610-EXIT.     
                                                                        
           PERFORM 7100-OPEN-CONTRACT-CURSOR        THRU 7100-EXIT.     
           PERFORM 7110-FETCH-CONTRACT-CURSOR       THRU 7110-EXIT.     
           PERFORM                                                      
              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
              MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE             
REARCH        PERFORM 2000A-MOVE-RESULT             THRU 2000A-EXIT     
              PERFORM 8100-SEND-RESULT              THRU 8100-EXIT      
              PERFORM 7110-FETCH-CONTRACT-CURSOR    THRU 7110-EXIT      
           END-PERFORM.                                                 
                                                                        
           PERFORM 7120-CLOSE-CONTRACT-CURSOR       THRU 7120-EXIT.     
                                                                        
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2610-INITIALIZE-RS                                            *         
      *                                                               *         
      *      INITIALIZE FIELD VALUES IN RESULT SET TO SPACES WHEN     *         
      *      ONLY CONTRACT DETAILS ARE SENT BACK                      *         
      *****************************************************************         
                                                                        
       2610-INITIALIZE-RS.                                              
                                                                        
           MOVE 0                        TO RS-AMT-GUARANTEE.           
           MOVE SPACE                    TO RS-CODE-GUAR-STATUS.        
           IF WS-ESTBLSH-DATE-NI < 0                                    
              MOVE SPACES                TO RS-GUAR-ESTBLSH-DT          
           ELSE                                                         
              UNSTRING GU-GUAR-ESTBLSH-DT DELIMITED BY '-'              
                  INTO WS-YEAR                                          
                       WS-MONTH                                         
                       WS-DAY                                           
              STRING WS-MONTH DELIMITED BY SIZE                         
                     WS-DAY DELIMITED BY SIZE                           
                     WS-YEAR DELIMITED BY SIZE                          
                INTO RS-GUAR-ESTBLSH-DT                                 
           END-IF.                                                      
                                                                        
           IF WS-TRIGGER-DATE-NI < 0                                    
              MOVE SPACES                TO RS-TRIGGER-DATE             
           ELSE                                                         
              UNSTRING GU-GUAR-TRIGGER-DATE DELIMITED BY '-'            
                  INTO WS-YEAR                                          
                       WS-MONTH                                         
                       WS-DAY                                           
              STRING WS-MONTH DELIMITED BY SIZE                         
                     WS-DAY DELIMITED BY SIZE                           
                     WS-YEAR DELIMITED BY SIZE                          
                INTO RS-TRIGGER-DATE                                    
           END-IF.                                                      
           MOVE SPACES                   TO RS-STATUS-REASON.           
           MOVE SPACES                   TO RS-CODE-SERV-TYPE.          
           MOVE SPACES                   TO RS-SEND-NOTICE-FLAG.        
           MOVE SPACES                   TO RS-GUAR-ACCT-NO.            
           MOVE SPACES                   TO RS-GUAR-ACCT-TYPE.          
           MOVE SPACES                   TO RS-FULL-NAME.               
           MOVE SPACES                   TO RS-TITLE.                   
           MOVE SPACES                   TO RS-FIRST-NAME.              
           MOVE SPACES                   TO RS-MIDDLE-NAME.             
           MOVE SPACES                   TO RS-LAST-NAME.               
           MOVE SPACES                   TO RS-TITLE-SUFFIX1.           
           MOVE SPACES                   TO RS-TITLE-SUFFIX2.           
           MOVE SPACES                   TO RS-ADDR-STREET.             
           MOVE SPACES                   TO RS-ADDR-CITY-STATE.         
           MOVE SPACES                   TO RS-ADDR-COUNTRY.            
           MOVE SPACES                   TO RS-ADDR-ZIP-CODE.           
           MOVE SPACES                   TO RS-ADDR-OVERFLOW.           
           MOVE SPACES                   TO RS-ADDR-PREFIX1.            
           MOVE SPACES                   TO RS-ADDR-PREFIX2.            
           MOVE SPACES                   TO RS-STREET-NAME.             
           MOVE SPACES                   TO RS-STREET-SUFFIX.           
           MOVE SPACES                   TO RS-ADDR-SUFFIX.             
           MOVE SPACES                   TO RS-STREET-LOCATION1.        
           MOVE SPACES                   TO RS-STREET-LOCATION2.        
           MOVE SPACES                   TO RS-HOUSE-NO.                
           MOVE SPACES                   TO RS-CARRIER-ROUTE.           
           MOVE SPACES                   TO RS-ZIP-CODE.                
           MOVE SPACES                   TO RS-ZIP-CODE-PLUS.           
           MOVE SPACES                   TO RS-ADDR-OVERFLOW-FORM.      
                                                                        
       2610-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2700-SEND-RESULT                                              *         
      *                                                               *         
      *     GATHER VALUES INTO RS-... VARIABLES AND SEND THE RESULT   *         
      *****************************************************************         
                                                                        
       2700-SEND-RESULT.                                                
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE.             
           MOVE GU-AMOUNT-GUARANTEED     TO RS-AMT-GUARANTEE.           
           MOVE GU-GUAR-STATUS-CD        TO RS-CODE-GUAR-STATUS.        
           IF WS-ESTBLSH-DATE-NI < 0                                    
               MOVE SPACES               TO RS-GUAR-ESTBLSH-DT          
           ELSE                                                         
               UNSTRING GU-GUAR-ESTBLSH-DT DELIMITED BY '-'             
                   INTO WS-YEAR                                         
                        WS-MONTH                                        
                        WS-DAY                                          
               STRING WS-MONTH DELIMITED BY SIZE                        
                      WS-DAY DELIMITED BY SIZE                          
                      WS-YEAR DELIMITED BY SIZE                         
                 INTO RS-GUAR-ESTBLSH-DT                                
           END-IF.                                                      
           MOVE GU-ADDRESS-ID            TO RS-ADDRESS-ID.              
           IF WS-TRIGGER-DATE-NI < 0                                    
              MOVE SPACES                TO RS-TRIGGER-DATE             
           ELSE                                                         
              UNSTRING GU-GUAR-TRIGGER-DATE DELIMITED BY '-'            
                  INTO WS-YEAR                                          
                       WS-MONTH                                         
                       WS-DAY                                           
              STRING WS-MONTH DELIMITED BY SIZE                         
                     WS-DAY DELIMITED BY SIZE                           
                     WS-YEAR DELIMITED BY SIZE                          
                INTO RS-TRIGGER-DATE                                    
           END-IF.                                                      
           MOVE GU-GUAR-STATUS-REASON    TO RS-STATUS-REASON.           
           MOVE GU-SERVICE-TYPE-CD       TO RS-CODE-SERV-TYPE.          
           MOVE GU-CNT-ITEM-ID           TO RS-CNT-ITEM-ID.             
           MOVE GU-GUAR-NOTICE-FLAG      TO RS-SEND-NOTICE-FLAG.        
           MOVE GU-GUARNTR-ACCT-NO       TO RS-GUAR-ACCT-NO.            
           MOVE GU-LAST-UPDATE-TS        TO RS-UPDATE-TS.               
           MOVE GU-ITEM-ID               TO RS-WQ-ITEM-ID.              
           MOVE AT-CREDIT-STATUS-CODE    TO RS-CREDIT-STATUS-CD.        
TP5801     MOVE WS-ACCOUNT-TYPE-CODE     TO RS-GUAR-ACCT-TYPE.          
TP5801*    IF WS-CODE-UTL = 'A'                                                 
TP5801*       MOVE 'U'                   TO RS-GUAR-ACCT-TYPE                   
TP5801*    ELSE                                                                 
TP5801*       MOVE 'C'                   TO RS-GUAR-ACCT-TYPE                   
TP5801*    END-IF.                                                              
           MOVE DQ-NAME-FORMAT           TO RS-NAME-USAGE.              
           MOVE DQ-FULL-NAME             TO RS-FULL-NAME.               
           MOVE DQ-TITLE-PREFIX          TO RS-TITLE.                   
           MOVE DQ-FIRST-NAME            TO RS-FIRST-NAME.              
           MOVE DQ-MIDDLE-NAME           TO RS-MIDDLE-NAME.             
           MOVE DQ-LAST-NAME             TO RS-LAST-NAME.               
           MOVE DQ-TITLE-SUFFIX-1        TO RS-TITLE-SUFFIX1.           
           MOVE DQ-TITLE-SUFFIX-2        TO RS-TITLE-SUFFIX2.           
           MOVE DZ-ADDR-STREET           TO RS-ADDR-STREET.             
           MOVE DZ-ADDR-CITY-STATE       TO RS-ADDR-CITY-STATE.         
           MOVE DZ-ADDR-COUNTRY          TO RS-ADDR-COUNTRY.            
           MOVE DZ-ADDR-ZIP-CODE         TO RS-ADDR-ZIP-CODE.           
           MOVE DZ-ADDRESS-OVERFLOW      TO RS-ADDR-OVERFLOW.           
           MOVE DY-ADDR-PREFIX-1         TO RS-ADDR-PREFIX1.            
           MOVE DY-ADDR-PREFIX-2         TO RS-ADDR-PREFIX2.            
           MOVE DY-STREET-NAME           TO RS-STREET-NAME.             
           MOVE DY-STREET-SUFFIX         TO RS-STREET-SUFFIX.           
           MOVE DY-ADDR-SUFFIX           TO RS-ADDR-SUFFIX.             
           MOVE DY-STREET-LOCATION-1     TO RS-STREET-LOCATION1.        
           MOVE DY-STREET-LOCATION-2     TO RS-STREET-LOCATION2.        
           MOVE DY-HOUSE-NO              TO RS-HOUSE-NO.                
           MOVE DY-CARRIER-ROUTE         TO RS-CARRIER-ROUTE.           
           MOVE DY-ZIP-CODE              TO RS-ZIP-CODE.                
           MOVE DY-ZIP-CODE-PLUS-FOUR    TO RS-ZIP-CODE-PLUS.           
           MOVE DY-ADDRESS-OVERFLOW      TO RS-ADDR-OVERFLOW-FORM.      
           MOVE A4-TOWN                  TO RS-TOWN.                    
           MOVE A4-STATE                 TO RS-STATE.                   
                                                                        
                                                                        
REARCH     PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT.                   
           PERFORM 8100-SEND-RESULT  THRU 8100-EXIT.                    
                                                                        
       2700-EXIT.                                                       
           EXIT.                                                        
                                                                        
T22668*****************************************************************         
T23513* 6500-GET-DATABASE                                             *         
T22668*     SELECTS BILLING ENTITY (SEB OR SCEG) FROM CSS_DELINQUENCY *         
T22668*****************************************************************         
T23513 6500-GET-DATABASE.                                               
T22668                                                                  
T22668     EXEC SQL                                                     
T22668        SELECT DELINQ_VALUE                                       
T22668          INTO :C8-DELINQ-VALUE                                   
T22668          FROM CSS_DELINQUENCY                                    
T23513         WHERE DELINQ_CD = :C8-DELINQ-CD                          
T23501           AND COMPANY_NO = :AT-COMPANY-NO                        
T22668     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T22668                                                                  
T22668     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
T22668                                                                  
T22668     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T23513        MOVE C8-DELINQ-VALUE TO WS-DATABASE                       
T22668     ELSE                                                         
T22668        MOVE '6500'                     TO ACTIVE-PARAGRAPH       
T22668        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
T22668        MOVE 'SELECT'                   TO ABEND-FUNCTION         
T22668        MOVE 'CSS_DELINQUENCY'          TO TABLE-1                
T22668        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
T22668        MOVE GU-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
T22668        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T22668        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T22668     END-IF.                                                      
T22668                                                                  
T22668 6500-EXIT.                                                       
T22668     EXIT.                                                        
T23501                                                                  
T23501****************************************                                  
T23501*  SELECTS COMPANY_NO FROM CSS_ACCOUNT *                                  
T23501****************************************                                  
T23501 7000-SELECT-COMPANY-NO.                                          
T23501     EXEC SQL                                                     
T23501        SELECT COMPANY_NO                                         
T23501          INTO :AT-COMPANY-NO                                     
T23501          FROM CSS_ACCOUNT                                        
T23501         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
T23501     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T23501                                                                  
T23501     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T23501     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T23501        NEXT SENTENCE                                             
T23501     ELSE                                                         
T23501        MOVE PROGRAM-NAME       TO ABEND-PROGRAM                  
T23501        MOVE '7000'             TO ACTIVE-PARAGRAPH               
T23501        MOVE 'SELECT'           TO ABEND-FUNCTION                 
T23501        MOVE 'CSS_ACCOUNT'      TO TABLE-1                        
T23501        MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1                
T23501        MOVE AT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1              
T23501        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T23501        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T23501     END-IF.                                                      
T23501                                                                  
T23501 7000-EXIT.                                                       
T23501     EXIT.                                                        
T23501                                                                  
      ****************************************************************          
      * 7005-OPEN-GUARANTOR-CURSOR                                   *          
      *                                                              *          
      *      OPEN THE GUARANTOR-CURSOR WHICH WILL SELECT ALL THE     *          
      *      GUARANTOR RECORDS FOR THE GUARANTEE ACCOUNT NUMBER      *          
      ****************************************************************          
                                                                        
       7005-OPEN-GUARANTOR-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
              OPEN GUARANTOR-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME       TO ABEND-PROGRAM                  
CBSI          MOVE '7005'             TO ACTIVE-PARAGRAPH               
CBSI          MOVE 'OPEN'             TO ABEND-FUNCTION                 
              MOVE 'CSS_GUARANTOR'    TO TABLE-1                        
CBSI          MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1                
CBSI          MOVE GU-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1              
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7010-FETCH-GUARANTOR-CURSOR                                  *          
      *                                                              *          
      *      FETCH RECORDS FROM GUARANTOR-CURSOR                     *          
      *                                                              *          
      ****************************************************************          
                                                                        
       7010-FETCH-GUARANTOR-CURSOR.                                     
                                                                        
           EXEC SQL                                                     
              FETCH GUARANTOR-CURSOR                                    
               INTO :GU-ADDRESS-ID, :GU-AMOUNT-GUARANTEED,              
                    :GU-CNT-ITEM-ID, :GU-GUAR-NOTICE-FLAG,              
                    :GU-GUAR-STATUS-CD, :GU-GUAR-STATUS-REASON,         
                    :GU-GUAR-TRIGGER-DATE :WS-TRIGGER-DATE-NI,           
                    :GU-GUARNTR-ACCT-NO, :GU-SERVICE-TYPE-CD,           
                    :GU-LAST-UPDATE-TS,:GU-ITEM-ID,                     
                    :GU-GUAR-ESTBLSH-DT :WS-ESTBLSH-DATE-NI              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME       TO ABEND-PROGRAM                  
              MOVE '7010'             TO ACTIVE-PARAGRAPH               
CBSI          MOVE 'FETCH'            TO ABEND-FUNCTION                 
              MOVE 'CSS_GUARANTOR'    TO TABLE-1                        
              MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1                
              MOVE GU-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1              
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7020-CLOSE-GUARANTOR-CURSOR                                  *          
      *                                                              *          
      ****************************************************************          
                                                                        
       7020-CLOSE-GUARANTOR-CURSOR.                                     
                                                                        
           EXEC SQL                                                     
              CLOSE GUARANTOR-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME       TO ABEND-PROGRAM                  
              MOVE '7020'             TO ACTIVE-PARAGRAPH               
CBSI          MOVE 'CLOSE'            TO ABEND-FUNCTION                 
              MOVE 'CSS_GUARANTOR'    TO TABLE-1                        
              MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1                
              MOVE GU-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1              
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      * 7100-OPEN-CONTRACT-CURSOR                                    *          
      *                                                              *          
      *      OPEN THE CONTRACT CURSOR WHICH WILL SELECT CONTRACT ID  *          
      *      AND CONTRACT ABBREVIATED DESCRIPTION FOR CONTRACT ITEM  *          
      *      THAT DO NOT EXIST IN THE GUARANTOR TABLE FOR A ACCT NO  *          
      ****************************************************************          
                                                                        
       7100-OPEN-CONTRACT-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
              OPEN CONTRACT-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7100'               TO ACTIVE-PARAGRAPH             
CBSI          MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE 'CSS_CONTRACT'       TO TABLE-1                      
              MOVE 'CSS_CONTRACT_INFO'  TO TABLE-2                      
T16079        MOVE 'CSS_GUARANTOR'      TO TABLE-3                      
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE CT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7110-FETCH-CONTRACT-CURSOR                                   *          
      *                                                              *          
      *      FETCH RECORDS FROM CONTRACT-CURSOR                      *          
      *                                                              *          
      ****************************************************************          
                                                                        
       7110-FETCH-CONTRACT-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
              FETCH CONTRACT-CURSOR                                     
               INTO :RS-CNT-ITEM-ID, :RS-AMT-ORIG-ENTERED,              
                    :RS-CNT-NAME-DESC                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7110'               TO ACTIVE-PARAGRAPH             
CBSI          MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'CSS_CONTRACT'       TO TABLE-1                      
              MOVE 'CSS_CONTRACT_INFO'  TO TABLE-2                      
T16079        MOVE 'CSS_GUARANTOR'      TO TABLE-3                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE CT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7120-CLOSE-CONTRACT-CURSOR                                   *          
      *                                                              *          
      ****************************************************************          
                                                                        
       7120-CLOSE-CONTRACT-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
              CLOSE CONTRACT-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7120'               TO ACTIVE-PARAGRAPH             
CBSI          MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE 'CSS_CONTRACT'       TO TABLE-1                      
              MOVE 'CSS_CONTRACT_INFO'  TO TABLE-2                      
T16079        MOVE 'CSS_GUARANTOR'      TO TABLE-3                      
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE CT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7200-SELECT-ACCT                                             *          
      *                                                              *          
      *      SELECT ADDRESS-ID, FORMAT AND CUSTOMMER NO FROM         *          
      *      CSS_ACCOUNT TABLE                                       *          
      ****************************************************************          
                                                                        
       7200-SELECT-ACCT.                                                
                                                                        
           EXEC SQL                                                     
              SELECT AT.ADDRESS_ID,                                     
                     AT.ADDRESS_FORMAT,                                 
                     AT.CODES_DATA_PRESENT,                             
                     AT.CUSTOMER_NO,                                    
                     AT.CREDIT_STATUS_CODE,                             
TP5801               AT.ACCOUNT_TYPE_CODE,                              
T23501               AT.COMPANY_NO,                                     
                     HT.ADDRESS_ID,                                     
                     DQ.NAME_FORMAT,                                    
                     DQ.LAST_NAME,                                      
                     DQ.FIRST_NAME,                                     
                     DQ.MIDDLE_NAME,                                    
                     DQ.TITLE_PREFIX,                                   
                     DQ.TITLE_SUFFIX_1,                                 
                     DQ.TITLE_SUFFIX_2,                                 
                     DQ.FULL_NAME                                       
                INTO :AT-ADDRESS-ID,                                    
                     :AT-ADDRESS-FORMAT,                                
                     :AT-CODES-DATA-PRESENT,                            
                     :AT-CUSTOMER-NO,                                   
                     :AT-CREDIT-STATUS-CODE,                            
TP5801               :WS-ACCOUNT-TYPE-CODE,                             
T23501               :AT-COMPANY-NO,                                    
                     :HT-ADDRESS-ID,                                    
                     :DQ-NAME-FORMAT,                                   
                     :DQ-LAST-NAME,                                     
                     :DQ-FIRST-NAME,                                    
                     :DQ-MIDDLE-NAME,                                   
                     :DQ-TITLE-PREFIX,                                  
                     :DQ-TITLE-SUFFIX-1,                                
                     :DQ-TITLE-SUFFIX-2,                                
                     :DQ-FULL-NAME                                      
                FROM CSS_ACCOUNT AT,                                    
                     CSS_NAME_ACCT_XREF HT,                             
                     CSS_NAME DQ                                        
               WHERE AT.ACCOUNT_NO = :GU-GUARNTR-ACCT-NO AND            
                     HT.ACCOUNT_NO = AT.ACCOUNT_NO AND                  
                     HT.NAME_ID = DQ.NAME_ID AND                        
                     HT.CUSTOMER_ROLE_CD = ' ' AND                      
                     DQ.NAME_TYPE = 'CN'                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7200'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCOUNT'        TO TABLE-1                      
              MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-2                      
T16079        MOVE 'CSS_NAME'           TO TABLE-3                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE GU-GUARNTR-ACCT-NO   TO HOSTVAR-ELEMENT-1            
              MOVE 'NAME_TYPE '         TO TABLE-ELEMENT-2              
              MOVE 'CN'                 TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7300-SELECT-NAME                                             *          
      *                                                              *          
      *      SELECT CUSTOMER'S NAME FROM CSS_NAME TABLE              *          
      ****************************************************************          
                                                                        
       7300-SELECT-NAME.                                                
                                                                        
           EXEC SQL                                                     
               SELECT DQ.NAME_FORMAT,                                   
                      DQ.LAST_NAME,                                     
                      DQ.FIRST_NAME,                                    
                      DQ.MIDDLE_NAME,                                   
                      DQ.TITLE_PREFIX,                                  
                      DQ.TITLE_SUFFIX_1,                                
                      DQ.TITLE_SUFFIX_2,                                
                      DQ.FULL_NAME                                      
                INTO :DQ-NAME-FORMAT,                                   
                     :DQ-LAST-NAME,                                     
                     :DQ-FIRST-NAME,                                    
                     :DQ-MIDDLE-NAME,                                   
                     :DQ-TITLE-PREFIX,                                  
                     :DQ-TITLE-SUFFIX-1,                                
                     :DQ-TITLE-SUFFIX-2,                                
                     :DQ-FULL-NAME                                      
                 FROM CSS_NAME           DQ,                            
                      CSS_NAME_ACCT_XREF HT                             
                WHERE HT.ACCOUNT_NO           = :GU-GUARNTR-ACCT-NO     
                  AND HT.NAME_ID              = DQ.NAME_ID              
                  AND DQ.NAME_TYPE            = 'CN'                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7300'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-1                      
              MOVE 'CSS_NAME'           TO TABLE-2                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
T16079        MOVE GU-GUARNTR-ACCT-NO   TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7400-SELECT-ADDR-FORM                                        *          
      *                                                              *          
      *      SELECT FROMATTED ADDRESS FOR THE ACCOUNT                *          
      ****************************************************************          
                                                                        
       7400-SELECT-ADDR-FORM.                                           
                                                                        
           EXEC SQL                                                     
               SELECT HOUSE_NO,                                         
                      ADDR_PREFIX_1,                                    
                      ADDR_PREFIX_2,                                    
                      STREET_NAME,                                      
                      ADDRESS_OVERFLOW,                                 
                      ADDR_USAGE_CD,                                    
                      CARRIER_ROUTE,                                    
                      STREET_SUFFIX,                                    
                      STREET_LOCATION_1,                                
                      STREET_LOCATION_2,                                
                      ZIP_CODE,                                         
                      ZIP_CODE_PLUS_FOUR,                               
                      ZIP_CODE_TOKEN                                    
               INTO   :DY-HOUSE-NO,                                     
                      :DY-ADDR-PREFIX-1,                                
                      :DY-ADDR-PREFIX-2,                                
                      :DY-STREET-NAME,                                  
                      :DY-ADDRESS-OVERFLOW,                             
                      :DY-ADDR-USAGE-CD,                                
                      :DY-CARRIER-ROUTE,                                
                      :DY-STREET-SUFFIX,                                
                      :DY-STREET-LOCATION-1,                            
                      :DY-STREET-LOCATION-2,                            
                      :DY-ZIP-CODE,                                     
                      :DY-ZIP-CODE-PLUS-FOUR,                           
                      :DY-ZIP-CODE-TOKEN                                
                 FROM CSS_ADDR_FORMATTED                                
                WHERE ADDRESS_ID = :DY-ADDRESS-ID                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7400'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE DY-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7410-SELECT-CITY                                               *        
      *                                                                *        
      *     GET CITY BASED ON ZIP CODE & TOKEN.                        *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7410-SELECT-CITY.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOWN, STATE                                       
                 INTO :A4-TOWN, :A4-STATE                               
                 FROM CSS_ZIP_CODE                                      
                WHERE ZIP_CODE       = :DY-ZIP-CODE                     
                  AND ZIP_CODE_TOKEN = :DY-ZIP-CODE-TOKEN               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                 OR   NOT-FOUND                         
              MOVE 0 TO WS-ACTIVE-RETURN-CODE                           
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7410'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE 'CSS_ZIP_CODE'         TO TABLE-1                    
              MOVE 'ZIP_CODE'             TO TABLE-ELEMENT-1            
              MOVE 'ZIP_CODE_TOKEN'       TO TABLE-ELEMENT-2            
CBSI          MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-3            
              MOVE DY-ZIP-CODE            TO HOSTVAR-ELEMENT-1          
              MOVE DY-ZIP-CODE-TOKEN      TO HOSTVAR-ELEMENT-2          
CBSI          MOVE PARM-ACCOUNT-NO        TO HOSTVAR-ELEMENT-3          
              PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT       
              PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT       
           END-IF.                                                      
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7450-SELECT-ADDR-FREE                                        *          
      *                                                              *          
      *      SELECT FREE FORM ADDRESS FOR THE ACCOUNT                *          
      ****************************************************************          
                                                                        
       7450-SELECT-ADDR-FREE.                                           
                                                                        
           EXEC SQL                                                     
               SELECT ADDR_STREET, ADDR_CITY_STATE, ADDR_ZIP_CODE,      
                      ADDR_COUNTRY, ADDRESS_OVERFLOW                    
               INTO   :DZ-ADDR-STREET, :DZ-ADDR-CITY-STATE,             
                      :DZ-ADDR-ZIP-CODE, :DZ-ADDR-COUNTRY,              
                      :DZ-ADDRESS-OVERFLOW                              
                 FROM CSS_ADDR_FREEFORM                                 
                WHERE ADDRESS_ID = :DZ-ADDRESS-ID                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7450'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE DZ-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7450-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ****************************************************************          
      * 7510-SELECT-HOME-PHONE                                       *          
      *                                                              *          
      *  SELECT HOME PHONE DETAILS  FOR THE GUARANTOR                *          
      ****************************************************************          
                                                                        
       7510-SELECT-HOME-PHONE.                                          
                                                                        
           EXEC SQL                                                     
               SELECT PHONE_NO                                          
               INTO   :CB-PHONE-NO                                      
                 FROM CSS_CUST_PHONE                                    
                WHERE CUSTOMER_NO = :AT-CUSTOMER-NO AND                 
                      CUSTOMER_TYPE = 'C'           AND                 
                      PHONE_TYPE = 'H1'                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE 0 TO WS-ACTIVE-RETURN-CODE                           
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7510'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_PHONE'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-2              
              MOVE 'PHONE_TYPE'         TO TABLE-ELEMENT-3              
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-4              
              MOVE AT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'C'                  TO HOSTVAR-ELEMENT-2            
              MOVE 'H1'                 TO HOSTVAR-ELEMENT-3            
CBSI          MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ****************************************************************          
      * 7520-SELECT-WORK-PHONE                                       *          
      *                                                              *          
      *  SELECT WORK PHONE DETAILS  FOR THE GUARANTOR                *          
      ****************************************************************          
                                                                        
       7520-SELECT-WORK-PHONE.                                          
                                                                        
           EXEC SQL                                                     
               SELECT PHONE_NO, EXTENSION_NO                            
               INTO   :CB-PHONE-NO, :CB-EXTENSION-NO                    
                 FROM CSS_CUST_PHONE                                    
                WHERE CUSTOMER_NO = :AT-CUSTOMER-NO AND                 
                      CUSTOMER_TYPE = 'C'           AND                 
                      PHONE_TYPE = 'W1'                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE 0 TO WS-ACTIVE-RETURN-CODE                           
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7520'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_PHONE'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-2              
              MOVE 'PHONE_TYPE'         TO TABLE-ELEMENT-3              
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-4              
              MOVE AT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'C'                  TO HOSTVAR-ELEMENT-2            
              MOVE 'W1'                 TO HOSTVAR-ELEMENT-3            
CBSI          MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7520-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ****************************************************************          
      * 7530-SELECT-STATS                                            *          
      *                                                              *          
      *  SELECT DEMOGRAPHIC STATISTICS FOR THE GUARANTOR*                       
      ****************************************************************          
                                                                        
       7530-SELECT-STATS.                                               
                                                                        
           EXEC SQL                                                     
               SELECT CODE_STATE_ID, DRIVERS_LICENSE_NO,                
                      SSN                                               
               INTO   :CE-CODE-STATE-ID, :CE-DRIVERS-LICENSE-NO,        
                      :CE-SSN                                           
                 FROM CSS_CUST_STATS                                    
                WHERE CUSTOMER_NO = :AT-CUSTOMER-NO AND                 
                      CUSTOMER_TYPE = 'C'                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              MOVE 0 TO WS-ACTIVE-RETURN-CODE                           
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7530'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_STATS'     TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE 'CUSTOMER_TYPE'      TO TABLE-ELEMENT-2              
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-3              
              MOVE AT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE 'C'                  TO HOSTVAR-ELEMENT-2            
CBSI          MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7530-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ****************************************************************          
      * 7600-SELECT-CONT-DETAIL                                      *          
      *                                                              *          
      *  SELECT CONTRACT DETAILS FOR GUARANTOR RECORD                *          
      ****************************************************************          
                                                                        
       7600-SELECT-CONT-DETAIL.                                         
                                                                        
           EXEC SQL                                                     
               SELECT CT.AMT_ORIG_ENTERED,                              
ACT278                K6.CNT_NAME_DESC                                  
               INTO   :RS-AMT-ORIG-ENTERED,                             
ACT278                :RS-CNT-NAME-DESC                                 
                 FROM CSS_CONTRACT CT,                                  
                      CSS_CONTRACT_INFO K6                              
                WHERE CT.ACCOUNT_NO = :PARM-ACCOUNT-NO-NUM AND          
                      CT.CNT_ITEM_ID = :GU-CNT-ITEM-ID AND              
                      K6.CNT_NAME_CD = CT.CNT_NAME_CD                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7600'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CONTRACT'       TO TABLE-1                      
              MOVE 'CSS_CONTRACT_INFO'  TO TABLE-2                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
T16079        MOVE PARM-ACCOUNT-NO-NUM  TO HOSTVAR-ELEMENT-1            
T16079        MOVE 'CNT_ITEM_ID'        TO TABLE-ELEMENT-2              
T16079        MOVE GU-CNT-ITEM-ID       TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ****************************************************************          
      * 7650-PROCESS-GUARANTEE                                       *          
      *                                                              *          
      *      GET GUARANTEE ACCOUNT TYPE FROM CSS_ACCOUNT TABLE       *          
      *                                                              *          
      ****************************************************************          
                                                                        
       7650-PROCESS-GUARANTEE.                                          
                                                                        
           EXEC SQL                                                     
              SELECT AT.CODES_DATA_PRESENT,                             
TP8644               AT.BILL_CYCLE                                      
                INTO :AT-CODES-DATA-PRESENT,                            
TP8644               :AT-BILL-CYCLE                                     
                FROM CSS_ACCOUNT AT                                     
               WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7650'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE 'CSS_ACCOUNT'          TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE AT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           MOVE AT-CODES-DATA-PRESENT  TO WS-CODES-DATA-PRESENT.        
           MOVE WS-CODE-UTL            TO RS-GRNT-ACCT-TYPE.            
                                                                        
       7650-EXIT.                                                       
           EXIT.                                                        
REARCH*                                                                         
REARCH***************************************************************           
REARCH* 8000A-DELETE-GTT-ROWS.                                      *           
REARCH***************************************************************           
REARCH 8000A-DELETE-GTT-ROWS.                                           
REARCH*                                                                         
REARCH     MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.          
REARCH*                                                                         
REARCH      EXEC SQL                                                    
REARCH          DELETE FROM #CSR02304_R1                         
REARCH      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR02304_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH      MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.      
REARCH*                                                                         
REARCH      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
REARCH          NEXT SENTENCE                                           
REARCH      ELSE                                                        
REARCH         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
REARCH         MOVE '8000A'              TO ACTIVE-PARAGRAPH            
REARCH         MOVE 'DELETE'             TO ABEND-FUNCTION              
REARCH         MOVE SPACES               TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH         MOVE 'CSR02304_R1'        TO TABLE-1                     
REARCH         MOVE SPACES               TO TABLE-ELEMENT-1             
REARCH         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
REARCH         PERFORM 9900-SQL-ERROR-ROUTINE                           
REARCH                                   THRU 9900-EXIT                 
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH 8000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
REARC2******************************************************************        
REARC2* 8100-SEND-RESULT                                               *        
REARC2******************************************************************        
REARC2 8100-SEND-RESULT.                                                
REARC2                                                                  
REARC2     MOVE 'INSERT INTO CSR02304_R1'                               
REARC2                                   TO S-SQL-STATEMENT-V.          
REARC2                                                                  
REARC2     EXEC SQL                                                     
REARC2                                                                  
REARC2         INSERT INTO #CSR02304_R1                          
REARC2             (                                                    
REARC2               RETURN_CODE                                        
REARC2              ,GRNT_ACCT_TYPE                                     
REARC2              ,AMT_GUARANTEE                                      
REARC2              ,GUAR_STATUS                                        
REARC2              ,TRIGGER_DATE                                       
REARC2              ,STATUS_REASON                                      
REARC2              ,SERV_TYPE                                          
REARC2              ,CONTRACT_ID                                        
REARC2              ,CONTRACT_AMT                                       
REARC2              ,CNT_NAME_ABBR                                      
REARC2              ,SEND_NOTICE_FLAG                                   
REARC2              ,SN_ADDR_FLAG                                       
REARC2              ,GUAR_ACCT                                          
REARC2              ,CREDIT_STATUS_CD                                   
REARC2              ,ADDRESS_ID                                         
REARC2              ,GUAR_ACCT_TYPE                                     
REARC2              ,UPDATE_TS                                          
REARC2              ,NAME_USAGE                                         
REARC2              ,FULL_NAME                                          
REARC2              ,TITLE                                              
REARC2              ,FIRST_NAME                                         
REARC2              ,MIDDLE_NAME                                        
REARC2              ,LAST_NAME                                          
REARC2              ,TITLE_SUFFIX1                                      
REARC2              ,TITLE_SUFFIX2                                      
REARC2              ,ADDR_USAGE                                         
REARC2              ,FR_ADDR_STREET                                     
REARC2              ,FO_HOUSE_NO                                        
REARC2              ,FO_ADDR_PREFIX1                                    
REARC2              ,FR_CITY_STATE                                      
REARC2              ,FO_ADDR_PREFIX2                                    
REARC2              ,FO_STREET_NAME                                     
REARC2              ,FO_STREET_SUFFIX                                   
REARC2              ,FO_ADDR_SUFFIX                                     
REARC2              ,FR_ADDR_ZIP                                        
REARC2              ,FO_STREET1                                         
REARC2              ,FO_STREET2                                         
REARC2              ,FR_COUNTRY                                         
REARC2              ,FO_TOWN                                            
REARC2              ,FO_STATE                                           
REARC2              ,FO_ZIP_CODE                                        
REARC2              ,FO_ZIP_PLUS                                        
REARC2              ,FR_OVERFLOW                                        
REARC2              ,FO_OVERFLOW                                        
REARC2              ,FO_CARRIER_ROUTE                                   
REARC2              ,HOME_PHONE                                         
REARC2              ,WORK_PHONE                                         
REARC2              ,PHONE_EXT                                          
REARC2              ,LICENSE                                            
REARC2              ,STATE_ID                                           
REARC2              ,SSN                                                
REARC2              ,SN_STREET                                          
REARC2              ,SN_CITY_STATE                                      
REARC2              ,SN_ZIP_CODE                                        
REARC2              ,SN_COUNTRY                                         
REARC2              ,SN_OVERFLOW                                        
REARC2              ,WQ_ITEM_ID                                         
REARC2              ,GUAR_ESTBLSH_DT                                    
REARC2              ,MAX_DEPOSIT_AMT                                    
REARC2              ,GUAR_CUST_NO                                       
REARC2             )                                                    
REARC2         VALUES                                                   
REARC2             (                                                    
REARC2               :S-RETURN-CODE                                     
REARC2              ,:S-GRNT-ACCT-TYPE                                  
REARC2              ,:S-AMT-GUARANTEE                                   
REARC2              ,:S-CODE-GUAR-STATUS                                
REARC2              ,:S-TRIGGER-DATE                                    
REARC2              ,:S-STATUS-REASON                                   
REARC2              ,:S-CODE-SERV-TYPE                                  
REARC2              ,:S-CNT-ITEM-ID                                     
REARC2              ,:S-AMT-ORIG-ENTERED                                
REARC2              ,:S-CNT-NAME-ABBR                                   
REARC2              ,:S-SEND-NOTICE-FLAG                                
REARC2              ,:S-SN-ADDR-FLAG                                    
REARC2              ,:S-GUAR-ACCT-NO                                    
REARC2              ,:S-CREDIT-STATUS-CD                                
REARC2              ,:S-ADDRESS-ID                                      
REARC2              ,:S-GUAR-ACCT-TYPE                                  
REARC2              ,:S-UPDATE-TS                                       
REARC2              ,:S-NAME-USAGE                                      
REARC2              ,:S-FULL-NAME                                       
REARC2              ,:S-TITLE                                           
REARC2              ,:S-FIRST-NAME                                      
REARC2              ,:S-MIDDLE-NAME                                     
REARC2              ,:S-LAST-NAME                                       
REARC2              ,:S-TITLE-SUFFIX1                                   
REARC2              ,:S-TITLE-SUFFIX2                                   
REARC2              ,:S-ADDR-USAGE                                      
REARC2              ,:S-ADDR-STREET                                     
REARC2              ,:S-HOUSE-NO                                        
REARC2              ,:S-ADDR-PREFIX1                                    
REARC2              ,:S-ADDR-CITY-STATE                                 
REARC2              ,:S-ADDR-PREFIX2                                    
REARC2              ,:S-STREET-NAME                                     
REARC2              ,:S-STREET-SUFFIX                                   
REARC2              ,:S-ADDR-SUFFIX                                     
REARC2              ,:S-ADDR-ZIP-CODE                                   
REARC2              ,:S-STREET-LOCATION1                                
REARC2              ,:S-STREET-LOCATION2                                
REARC2              ,:S-ADDR-COUNTRY                                    
REARC2              ,:S-TOWN                                            
REARC2              ,:S-STATE                                           
REARC2              ,:S-ZIP-CODE                                        
REARC2              ,:S-ZIP-CODE-PLUS                                   
REARC2              ,:S-ADDR-OVERFLOW                                   
REARC2              ,:S-ADDR-OVERFLOW-FORM                              
REARC2              ,:S-CARRIER-ROUTE                                   
REARC2              ,:S-HOME-PHONE                                      
REARC2              ,:S-WORK-PHONE                                      
REARC2              ,:S-PHONE-EXT                                       
REARC2              ,:S-DRIVER-LICENSE                                  
REARC2              ,:S-CODE-STATE-ID                                   
REARC2              ,:S-SSN                                             
REARC2              ,:S-SN-STREET                                       
REARC2              ,:S-SN-CITY-STATE                                   
REARC2              ,:S-SN-ZIP-CODE                                     
REARC2              ,:S-SN-COUNTRY                                      
REARC2              ,:S-SN-OVERFLOW                                     
REARC2              ,:S-WQ-ITEM-ID                                      
REARC2              ,:S-GUAR-ESTBLSH-DT                                 
REARC2              ,:S-MAX-DEPOSIT-AMT                                 
REARC2              ,:S-CUSTOMER-NO                                     
REARC2             )                                                    
REARC2                                                                  
REARC2     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        INSERT INTO SESSION.CSR02304_R1                                  
MFA-TR*            (                                                            
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,GRNT_ACCT_TYPE                                             
MFA-TR*             ,AMT_GUARANTEE                                              
MFA-TR*             ,GUAR_STATUS                                                
MFA-TR*             ,TRIGGER_DATE                                               
MFA-TR*             ,STATUS_REASON                                              
MFA-TR*             ,SERV_TYPE                                                  
MFA-TR*             ,CONTRACT_ID                                                
MFA-TR*             ,CONTRACT_AMT                                               
MFA-TR*             ,CNT_NAME_ABBR                                              
MFA-TR*             ,SEND_NOTICE_FLAG                                           
MFA-TR*             ,SN_ADDR_FLAG                                               
MFA-TR*             ,GUAR_ACCT                                                  
MFA-TR*             ,CREDIT_STATUS_CD                                           
MFA-TR*             ,ADDRESS_ID                                                 
MFA-TR*             ,GUAR_ACCT_TYPE                                             
MFA-TR*             ,UPDATE_TS                                                  
MFA-TR*             ,NAME_USAGE                                                 
MFA-TR*             ,FULL_NAME                                                  
MFA-TR*             ,TITLE                                                      
MFA-TR*             ,FIRST_NAME                                                 
MFA-TR*             ,MIDDLE_NAME                                                
MFA-TR*             ,LAST_NAME                                                  
MFA-TR*             ,TITLE_SUFFIX1                                              
MFA-TR*             ,TITLE_SUFFIX2                                              
MFA-TR*             ,ADDR_USAGE                                                 
MFA-TR*             ,FR_ADDR_STREET                                             
MFA-TR*             ,FO_HOUSE_NO                                                
MFA-TR*             ,FO_ADDR_PREFIX1                                            
MFA-TR*             ,FR_CITY_STATE                                              
MFA-TR*             ,FO_ADDR_PREFIX2                                            
MFA-TR*             ,FO_STREET_NAME                                             
MFA-TR*             ,FO_STREET_SUFFIX                                           
MFA-TR*             ,FO_ADDR_SUFFIX                                             
MFA-TR*             ,FR_ADDR_ZIP                                                
MFA-TR*             ,FO_STREET1                                                 
MFA-TR*             ,FO_STREET2                                                 
MFA-TR*             ,FR_COUNTRY                                                 
MFA-TR*             ,FO_TOWN                                                    
MFA-TR*             ,FO_STATE                                                   
MFA-TR*             ,FO_ZIP_CODE                                                
MFA-TR*             ,FO_ZIP_PLUS                                                
MFA-TR*             ,FR_OVERFLOW                                                
MFA-TR*             ,FO_OVERFLOW                                                
MFA-TR*             ,FO_CARRIER_ROUTE                                           
MFA-TR*             ,HOME_PHONE                                                 
MFA-TR*             ,WORK_PHONE                                                 
MFA-TR*             ,PHONE_EXT                                                  
MFA-TR*             ,LICENSE                                                    
MFA-TR*             ,STATE_ID                                                   
MFA-TR*             ,SSN                                                        
MFA-TR*             ,SN_STREET                                                  
MFA-TR*             ,SN_CITY_STATE                                              
MFA-TR*             ,SN_ZIP_CODE                                                
MFA-TR*             ,SN_COUNTRY                                                 
MFA-TR*             ,SN_OVERFLOW                                                
MFA-TR*             ,WQ_ITEM_ID                                                 
MFA-TR*             ,GUAR_ESTBLSH_DT                                            
MFA-TR*             ,MAX_DEPOSIT_AMT                                            
MFA-TR*             ,GUAR_CUST_NO                                               
MFA-TR*            )                                                            
MFA-TR*        VALUES                                                           
MFA-TR*            (                                                            
MFA-TR*              :S-RETURN-CODE                                             
MFA-TR*             ,:S-GRNT-ACCT-TYPE                                          
MFA-TR*             ,:S-AMT-GUARANTEE                                           
MFA-TR*             ,:S-CODE-GUAR-STATUS                                        
MFA-TR*             ,:S-TRIGGER-DATE                                            
MFA-TR*             ,:S-STATUS-REASON                                           
MFA-TR*             ,:S-CODE-SERV-TYPE                                          
MFA-TR*             ,:S-CNT-ITEM-ID                                             
MFA-TR*             ,:S-AMT-ORIG-ENTERED                                        
MFA-TR*             ,:S-CNT-NAME-ABBR                                           
MFA-TR*             ,:S-SEND-NOTICE-FLAG                                        
MFA-TR*             ,:S-SN-ADDR-FLAG                                            
MFA-TR*             ,:S-GUAR-ACCT-NO                                            
MFA-TR*             ,:S-CREDIT-STATUS-CD                                        
MFA-TR*             ,:S-ADDRESS-ID                                              
MFA-TR*             ,:S-GUAR-ACCT-TYPE                                          
MFA-TR*             ,:S-UPDATE-TS                                               
MFA-TR*             ,:S-NAME-USAGE                                              
MFA-TR*             ,:S-FULL-NAME                                               
MFA-TR*             ,:S-TITLE                                                   
MFA-TR*             ,:S-FIRST-NAME                                              
MFA-TR*             ,:S-MIDDLE-NAME                                             
MFA-TR*             ,:S-LAST-NAME                                               
MFA-TR*             ,:S-TITLE-SUFFIX1                                           
MFA-TR*             ,:S-TITLE-SUFFIX2                                           
MFA-TR*             ,:S-ADDR-USAGE                                              
MFA-TR*             ,:S-ADDR-STREET                                             
MFA-TR*             ,:S-HOUSE-NO                                                
MFA-TR*             ,:S-ADDR-PREFIX1                                            
MFA-TR*             ,:S-ADDR-CITY-STATE                                         
MFA-TR*             ,:S-ADDR-PREFIX2                                            
MFA-TR*             ,:S-STREET-NAME                                             
MFA-TR*             ,:S-STREET-SUFFIX                                           
MFA-TR*             ,:S-ADDR-SUFFIX                                             
MFA-TR*             ,:S-ADDR-ZIP-CODE                                           
MFA-TR*             ,:S-STREET-LOCATION1                                        
MFA-TR*             ,:S-STREET-LOCATION2                                        
MFA-TR*             ,:S-ADDR-COUNTRY                                            
MFA-TR*             ,:S-TOWN                                                    
MFA-TR*             ,:S-STATE                                                   
MFA-TR*             ,:S-ZIP-CODE                                                
MFA-TR*             ,:S-ZIP-CODE-PLUS                                           
MFA-TR*             ,:S-ADDR-OVERFLOW                                           
MFA-TR*             ,:S-ADDR-OVERFLOW-FORM                                      
MFA-TR*             ,:S-CARRIER-ROUTE                                           
MFA-TR*             ,:S-HOME-PHONE                                              
MFA-TR*             ,:S-WORK-PHONE                                              
MFA-TR*             ,:S-PHONE-EXT                                               
MFA-TR*             ,:S-DRIVER-LICENSE                                          
MFA-TR*             ,:S-CODE-STATE-ID                                           
MFA-TR*             ,:S-SSN                                                     
MFA-TR*             ,:S-SN-STREET                                               
MFA-TR*             ,:S-SN-CITY-STATE                                           
MFA-TR*             ,:S-SN-ZIP-CODE                                             
MFA-TR*             ,:S-SN-COUNTRY                                              
MFA-TR*             ,:S-SN-OVERFLOW                                             
MFA-TR*             ,:S-WQ-ITEM-ID                                              
MFA-TR*             ,:S-GUAR-ESTBLSH-DT                                         
MFA-TR*             ,:S-MAX-DEPOSIT-AMT                                         
MFA-TR*             ,:S-CUSTOMER-NO                                             
MFA-TR*            )                                                            
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARC2                                                                  
REARC2     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE        
REARC2                                                                  
REARC2     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
REARC2        CONTINUE                                                  
REARC2     ELSE                                                         
REARC2        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
REARC2        MOVE SQLCODE              TO ABEND-SQLCODE                
REARC2        MOVE SQLSTATE             TO ABEND-SQLSTATE               
REARC2        MOVE '8100'               TO ACTIVE-PARAGRAPH             
REARC2        MOVE 'INSERT'             TO ABEND-FUNCTION               
REARC2        MOVE 'CSR02304_R1'        TO TABLE-1                      
REARC2        MOVE 'CONTRACT_ID'        TO TABLE-ELEMENT-1              
REARC2        MOVE 'UPDATE_TS'          TO TABLE-ELEMENT-2              
REARC2        MOVE S-CNT-ITEM-ID        TO HOSTVAR-ELEMENT-1            
REARC2        MOVE S-UPDATE-TS          TO HOSTVAR-ELEMENT-2            
REARC2        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
REARC2     END-IF                                                       
REARC2                                                                  
REARC2     ADD 1 TO CTR-ROWS                                            
REARC2     INITIALIZE GTT-RETURN-FIELDS                                 
REARC2     .                                                            
REARC2 8100-EXIT.                                                       
REARC2     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
REARCH         INCLUDE CPDSP300                                                 
           END-EXEC.                                                            
                                                                        
TP8644******************************************************************        
TP8644* ABEND COPYBOOK                                                          
TP8644******************************************************************        
TP8644     EXEC SQL                                                             
TP8644        INCLUDE CPD0023C                                                  
TP8644     END-EXEC.                                                            
TP8644                                                                  
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
REARCH     EXEC SQL                                                             
REARC2         INCLUDE CPD00320                                                 
REARCH     END-EXEC.                                                            
