       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02301.                                         
COB303 DATE-WRITTEN.  JANUARY  05, 1996                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S301                                           *        
      *  PROGRAM:       S301                                           *        
      *  CALLING SP:    PA_S301                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES A ROW FROM CSS_CHRG_OFF TABLE BASED ON *        
      *  THE RECEIVABLE TYPE AND ITEM ID ENTERED BY USER               *        
T13785*  THE COLLECTION AGENCY AMOUNT WILL ALSO BE RETREIVED.          *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  12/25/95    RTO      PROCEDURE ORIGINALLY CODED.              *        
      *                                                                *        
T12154*  07/18/97    MAD      CHANGED PARM FOR ITEM-ID TO PIC X(9)     *        
      *                         DUE TO CONTRACT WRITE-OFF PROCESSING.  *        
      *                                                                *        
T12501*  08/11/97    MAD      REMOVED THE CODE WHICH WAS SENDING BACK  *        
      *                         THE COLLECTION AGENCY NAME TO THE PANEL*        
      *                         - EDIT STYLE WILL DECODE THE COLLECTION*        
      *                         AGENCY NUMBER.                         *        
T13785*  11/24/97    BAB      THE COLLECTION AGENCY WILL BE RETURNED   *        
      *                       TO THE PANEL.                            *        
T11831*  01/06/98    EMS      CHANGED THE RPC TO RETRIEVE THE ACCOUNT  *        
      *                       INFORMATION VERSES THE INFORMATION AT    *        
      *                       THE RECEIVABLE LEVEL.                    *        
T15371*  03/13/98    KP       CHANGED THE RPC TO RETRIEVE THE CREDIT   *        
      *                       BUREAU LISTED DATE AND AMOUNT FROM       *        
      *                       CSS_CHRG_OFF TABLE FOR THE ACCOUNT       *        
T16630*  06/01/98    EMS      REPLACED A SELECT THAT GRABBED THE       *        
      *                       WITHDRAW DATE AND REASON WITH A CURSOR.  *        
CBSI  *  08/01/99   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *             MADRAS    ABEND PARAMETERS                         *        
REARCH*  05/27/05   CVNS      RPC TO COBOL SP CONVERSION               *        
REARCH*             CHENNAI                                            *        
REARCH*                                                                *        
REARCH*  08/16/05   CVNS      STRIP ADDED FOR RETRUN FIELDS.           *        
REARCH*             CHENNAI                                            *        
C30169*  02/18/08   MN90523   WRITE OFF RECOVERY CHANGES.              *        
C30169*                                                                *        
ACT110**  05/06/2011 BG17895   DELETE INCLUDE TBCLAGNY                          
ACT110**  APPL3082                            CSS_COLLECT_AGENCY                
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02301'.
MSQ017     COPY MFASQLM.
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02301 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
REARCH*    COPY SYGWCOB.                                                        
REARCH*    COPY SYDBCOB.                                                        
           COPY CCA00001.                                                       
REARCH*    COPY CWS00010.                                                       
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CWSX0010                                                 
REARCH     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  WS-MISC.                                                     
REARCH*    05  PROGRAM-NAME             PIC X(08) VALUE 'S301    '.             
REARCH     05  PROGRAM-NAME             PIC X(08) VALUE 'CSR02301'.     
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
                                                                        
           05  WS-ACCOUNT-NO            PIC X(13).                      
           05  WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO                
                                        PIC 9(13).                      
COB305     05 WS-ACCOUNT-NO-COMP3        PIC S9(13) COMP-3 VALUE 0.             
                                                                        
           05  WS-NULL-IND1             PIC S9(04) COMP VALUE +0.       
           05  WS-NULL-IND2             PIC S9(04) COMP VALUE +0.       
           05  WS-NULL-IND3             PIC S9(04) COMP VALUE +0.       
           05  WS-EXISTS                PIC X(01)  VALUE SPACES.        
           05  WS-SQLSTATE              PIC X(05)  VALUE SPACES.        
T11831     05  WS-CR-BUR-RPT-DT-NULL    PIC S9(04) COMP VALUE +0.       
T16630     05  WS-MM-DD-YYYY.                                           
               10 WS-MONTH              PIC X(02)  VALUE SPACES.        
               10 FILLER                PIC X(01)  VALUE '/'.           
               10 WS-DAY                PIC X(02)  VALUE SPACES.        
               10 FILLER                PIC X(01)  VALUE '/'.           
               10 WS-YEAR               PIC X(04)  VALUE SPACES.        
      *                                                                         
       01  WS-LITERAL.                                                  
           05  WS-A                     PIC X(01) VALUE 'A'.            
           05  WS-B                     PIC X(01) VALUE 'B'.            
           05  WS-C                     PIC X(01) VALUE 'C'.            
           05  WS-G                     PIC X(01) VALUE 'G'.            
           05  WS-I                     PIC X(01) VALUE 'I'.            
           05  WS-M                     PIC X(01) VALUE 'M'.            
           05  WS-R                     PIC X(01) VALUE 'R'.            
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH      05  GTT-NAME                PIC X(26)                       
REARCH                                     VALUE 'SESSION.CSR02301_R1'. 
REARCH      05  GTT-ROW.                                                
REARCH          49 GTT-ROW-LEN          PIC S9(04) COMP.                
REARCH          49 GTT-ROW-CHAR         PIC X(1024).                    
REARCH      05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
REARCH 01  CSRERLOG-P.                                                  
REARCH      10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
REARCH      10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
REARCH      10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
REARCH      10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
REARCH      10  S-HOST-VARIABLES.                                       
REARCH          49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
REARCH          49  S-HOST-VARIABLES-V  PIC X(255).                     
REARCH      10  S-SQL-STATEMENT.                                        
REARCH          49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
REARCH          49  S-SQL-STATEMENT-V   PIC X(255).                     
REARCH      10  S-SQL-DESCRIPTION.                                      
REARCH          49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
REARCH          49  S-SQL-DESCRIPTION-V PIC X(255).                     
REARCH*                                                                         
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(09) COMP VALUE +0.       
           05  RS-RECORD-ID             PIC X(01)      VALUE SPACES.    
COB305     05 RS-AMT-TRANS        PIC S9(09)V99 USAGE COMP-3 VALUE 0.    
COB305     05 RS-WO-ORIG-AMT        PIC S9(09)V99 USAGE COMP-3 VALUE 0.    
           05  RS-WRITEOFF-DT           PIC X(10)      VALUE SPACES.    
           05  RS-COLL-STATUS-CD        PIC X(01)      VALUE SPACES.    
           05  RS-CALL-QUEUE-ID         PIC X(05)      VALUE SPACES.    
           05  RS-CB-LIST-DT            PIC X(10)      VALUE SPACES.    
           05  RS-CB-LIST-AMT           PIC S9(09)V99  COMP-3 VALUE 0.  
           05  RS-COLL-EXEMPTION-CD     PIC X(20)      VALUE SPACES.    
           05  RS-PERM-COMMENT-TEXT     PIC X(254)     VALUE SPACES.    
           05  RS-ARRANGEMNT-EXIST      PIC X(01)      VALUE 'N'.       
           05  RS-RECV-COMMENT-TEXT     PIC X(254)     VALUE SPACES.    
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE            PIC S9(09) COMP VALUE +0.       
           05  S-RECORD-ID              PIC X(01)      VALUE SPACES.    
COB305     05 S-AMT-TRANS        PIC S9(09)V99 USAGE COMP-3 VALUE 0.    
COB305     05 S-WO-ORIG-AMT        PIC S9(09)V99 USAGE COMP-3 VALUE 0.    
           05  S-WRITEOFF-DT            PIC X(10)      VALUE SPACES.    
           05  S-COLL-STATUS-CD         PIC X(01)      VALUE SPACES.    
           05  S-CALL-QUEUE-ID          PIC X(05)      VALUE SPACES.    
           05  S-CB-LIST-DT             PIC X(10)      VALUE SPACES.    
COB305     05 S-CB-LIST-AMT        PIC S9(09)V99 USAGE COMP-3 VALUE 0.    
           05  S-COLL-EXEMPTION-CD      PIC X(20)      VALUE SPACES.    
           05  S-PERM-COMMENT-TEXT      PIC X(254)     VALUE SPACES.    
           05  S-ARRANGEMNT-EXIST       PIC X(01)      VALUE 'N'.       
           05  S-RECV-COMMENT-TEXT      PIC X(254)     VALUE SPACES.    
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
             INCLUDE TBCHGOFF                                                   
           END-EXEC.                                                            
                                                                        
                                                                        
           EXEC SQL                                                             
             INCLUDE TBCOLHST                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
             INCLUDE TBFWACTN                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
             INCLUDE TBACCINF                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
             INCLUDE TBWOARGM                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
             INCLUDE TBCOLDET                                                   
           END-EXEC.                                                            
                                                                        
T13785     EXEC SQL                                                             
T13785        INCLUDE TBFINLWO                                                  
T13785     END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      * CURSOR DECLARATIONS                                                     
      ***************************************************************           
      *                                                                         
           EXEC SQL                                                     
              DECLARE RECV_CMNT_CUR CURSOR FOR                          
              SELECT                                                    
                   LH.COMMENTS_TX                                       
              FROM                                                      
                   CSS_COLL_HIST_DET LH                                 
              WHERE                                                     
                  LH.ACCOUNT_NO     = :LH-ACCOUNT-NO                    
              AND LH.LAST_UPDATE_USERID <> 'GENESYS'                    
              AND LH.COLL_RESULT_CD     =  'RE'                         
              ORDER BY                                                  
                  LH.RECORD_CREATION_DT DESC                            
                 ,LH.TRANS_ID DESC                                      
           END-EXEC.                                                    
      *                                                                         
HPCCDM*EJECT                                                                    
REARCH LINKAGE SECTION.                                                 
REARCH 01  PARM-ACCOUNT-NO          PIC  X(13).                         
REARCH PROCEDURE DIVISION USING PARM-ACCOUNT-NO.                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
       0000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     2. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     3. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR CONTINUE END-EXEC.                
           EXEC SQL WHENEVER NOT FOUND CONTINUE END-EXEC.               
                                                                        
           PERFORM 0100A-DECLARE-GTT       THRU 0100A-EXIT.             
                                                                        
REARCH     EXEC SQL                                                     
REARCH          DECLARE C1 CURSOR  FOR                       
REARCH             SELECT                                               
REARCH               RETURN_CODE                                        
                    ,RECORD_ID                                          
                    ,AMT_TRANS                                          
                    ,WO_ORIGINAL_AMT                                    
                    ,WRITEOFF_DT                                        
                    ,COLL_STATUS_CD                                     
                    ,COLL_QUEUE_ID                                      
                    ,CB_LIST_DT                                         
                    ,CB_LIST_AMT                                        
                    ,COLL_EXEMPT_CD                                     
                    ,LTRIM(RTRIM(PERM_COMMENT))   AS PERM_COMMENT              
                    ,ARNGMNT_EXIST                                      
                    ,LTRIM(RTRIM(RECV_COMMENT))   AS RECV_COMMENT              
REARCH             FROM                                                 
REARCH                 #CSR02301_R1                              
REARCH         END-EXEC.                                                

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN FOR                               
MFA-TR*            SELECT                                                       
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,RECORD_ID                                                  
MFA-TR*             ,AMT_TRANS                                                  
MFA-TR*             ,WO_ORIGINAL_AMT                                            
MFA-TR*             ,WRITEOFF_DT                                                
MFA-TR*             ,COLL_STATUS_CD                                             
MFA-TR*             ,COLL_QUEUE_ID                                              
MFA-TR*             ,CB_LIST_DT                                                 
MFA-TR*             ,CB_LIST_AMT                                                
MFA-TR*             ,COLL_EXEMPT_CD                                             
MFA-TR*             ,STRIP(PERM_COMMENT)   AS PERM_COMMENT                      
MFA-TR*             ,ARNGMNT_EXIST                                              
MFA-TR*             ,STRIP(RECV_COMMENT)   AS RECV_COMMENT                      
MFA-TR*            FROM                                                         
MFA-TR*                SESSION.CSR02301_R1                                      
MFA-TR*        END-EXEC.                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100A-DECLARE-GTT.                                                      
      *    DECLARE GTT FOR RESULT SET                                           
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT.                                               
      *                                                                         
            MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR02301_R1'           
                                          TO S-SQL-STATEMENT-V.         
            EXEC SQL
              CALL CIS.DROP_TEMP_TABLE('#CSR02301_R1')
            END-EXEC
            EXEC SQL
              CREATE TABLE #CSR02301_R1
               (                                                       
                    RETURN_CODE        INT                          
                   ,RECORD_ID CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
                   ,AMT_TRANS          DECIMAL(11,2)                    
                   ,WO_ORIGINAL_AMT    DECIMAL(11,2)                    
                   ,WRITEOFF_DT CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,COLL_STATUS_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,COLL_QUEUE_ID CHAR(05)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,CB_LIST_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,CB_LIST_AMT        DECIMAL(11,2)                    
                   ,COLL_EXEMPT_CD CHAR(20)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,PERM_COMMENT CHAR(254)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,ARNGMNT_EXIST CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                   ,RECV_COMMENT CHAR(254)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
                )
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLSTATE                 TO WS-SQLSTATE.               
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
            IF WS-SQLSTATE = '42710'                                    
               PERFORM 8000A-DELETE-GTT-ROWS                            
            ELSE                                                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE '0100A'            TO ACTIVE-PARAGRAPH            
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                 MOVE 'CSR02301_R1'      TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9900-SQL-ERROR-ROUTINE                         
                                         THRU  9900-EXIT                
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000'                      TO ACTIVE-PARAGRAPH.        
           MOVE PARM-ACCOUNT-NO             TO WS-ACCOUNT-NO.           
           MOVE WS-ACCOUNT-NO-NUM           TO WS-ACCOUNT-NO-COMP3.     
           MOVE WS-ACCOUNT-NO-COMP3         TO CO-ACCOUNT-NO            
                                               IF-ACCOUNT-NO            
                                               HC-ACCOUNT-NO            
                                               WG-ACCOUNT-NO            
                                               LH-ACCOUNT-NO            
                                               FW-ACCOUNT-NO            
                                               KD-ACCOUNT-NO.           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      *     1. DESCRIBE RESULT SET                                     *        
      *     2. UPDATE DB2 DATA                                         *        
      *     3. BUILD RESULT SET                                        *        
      *     4. SEND RESULT SET                                         *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                   TO ACTIVE-PARAGRAPH.           
           PERFORM 2200-PROCESS-CHRG-OFF THRU 2200-EXIT.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000A-MOVE-RESULT                                              *        
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
      *                                                                         
            MOVE RS-RETURN-CODE         TO S-RETURN-CODE.               
            MOVE RS-RECORD-ID           TO S-RECORD-ID.                 
            MOVE RS-AMT-TRANS           TO S-AMT-TRANS.                 
            MOVE RS-WO-ORIG-AMT         TO S-WO-ORIG-AMT.               
            MOVE RS-WRITEOFF-DT         TO S-WRITEOFF-DT.               
            MOVE RS-COLL-STATUS-CD      TO S-COLL-STATUS-CD.            
            MOVE RS-CALL-QUEUE-ID       TO S-CALL-QUEUE-ID.             
            MOVE RS-CB-LIST-DT          TO S-CB-LIST-DT.                
            MOVE RS-CB-LIST-AMT         TO S-CB-LIST-AMT.               
            MOVE RS-COLL-EXEMPTION-CD   TO S-COLL-EXEMPTION-CD.         
            MOVE RS-PERM-COMMENT-TEXT   TO S-PERM-COMMENT-TEXT.         
            MOVE RS-ARRANGEMNT-EXIST    TO S-ARRANGEMNT-EXIST.          
            MOVE RS-RECV-COMMENT-TEXT   TO S-RECV-COMMENT-TEXT.         
      *                                                                         
       2000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
      *****************************************************************         
      *  2200-PROCESS-CHRG-OFF                                        *         
      *                                                               *         
      *    RETRIEVE THE CHRG_OFF ROW USING PARM PASSED                *         
      *                                                               *         
      *****************************************************************         
      *                                                                         
       2200-PROCESS-CHRG-OFF.                                           
      *                                                                         
           MOVE 'A'                         TO RS-RECORD-ID.            
                                                                        
           PERFORM 7000-SELECT-WRITEOFF-DT  THRU 7000-EXIT.             
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE KD-FW-ACTION-DT          TO  RS-WRITEOFF-DT          
           END-IF.                                                      
      *                                                                         
           PERFORM 7050-SELECT-COLLECT-STATUS THRU 7050-EXIT.           
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE FW-COLLECT-STATUS-CD     TO  RS-COLL-STATUS-CD       
           END-IF.                                                      
      *                                                                         
           PERFORM 7100-SELECT-AMT-TRANS    THRU 7100-EXIT.             
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE CO-AMT-TRANS             TO  RS-AMT-TRANS            
           END-IF.                                                      
                                                                        
           PERFORM 7150-SELECT-ORIG-AMT     THRU 7150-EXIT.             
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE CO-WO-ORIGINAL-AM        TO  RS-WO-ORIG-AMT          
           END-IF.                                                      
                                                                        
           PERFORM 7200-SELECT-COLLQ-ID     THRU 7200-EXIT.             
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE HC-CALL-QUEUE-ID         TO  RS-CALL-QUEUE-ID        
           END-IF.                                                      
                                                                        
           PERFORM 7250-SELECT-CRBUR-DETAILS THRU 7250-EXIT.            
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE KD-FW-ACTION-DT          TO  RS-CB-LIST-DT           
              MOVE KD-FW-ACTION-AM          TO  RS-CB-LIST-AMT          
           END-IF.                                                      
                                                                        
           PERFORM 7300-SELECT-PERM-COMMENTS THRU 7300-EXIT.            
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE IF-COLL-EXEMPTION-CD     TO  RS-COLL-EXEMPTION-CD    
              MOVE IF-COLL-COMMENT-TX-TEXT  TO  RS-PERM-COMMENT-TEXT    
           END-IF.                                                      
                                                                        
           PERFORM 7350-SELECT-ARRANGEMENTS THRU 7350-EXIT.             
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE WS-EXISTS                TO  RS-ARRANGEMNT-EXIST     
           END-IF.                                                      
                                                                        
           PERFORM 2000A-MOVE-RESULT        THRU 2000A-EXIT.            
           PERFORM 8100-SEND-RESULT         THRU 8100-EXIT.             
                                                                        
           INITIALIZE RS-AMT-TRANS                                      
                      RS-WO-ORIG-AMT                                    
                      RS-WRITEOFF-DT                                    
                      RS-COLL-STATUS-CD                                 
                      RS-CALL-QUEUE-ID                                  
                      RS-CB-LIST-DT                                     
                      RS-CB-LIST-AMT                                    
                      RS-COLL-EXEMPTION-CD                              
                      RS-PERM-COMMENT-TEXT                              
                      RS-ARRANGEMNT-EXIST                               
                      RS-RECV-COMMENT-TEXT.                             
                                                                        
           MOVE 'C'                         TO RS-RECORD-ID.            
                                                                        
           PERFORM 7400-OPEN-RECV-CMNT-CURSOR         THRU 7400-EXIT.   
           PERFORM 7450-FETCH-RECV-CMNT-CURSOR        THRU 7450-EXIT.   
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                                                                        
                MOVE LH-COMMENTS-TX-TEXT        TO RS-RECV-COMMENT-TEXT 
                                                                        
                PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT         
                PERFORM 8100-SEND-RESULT        THRU 8100-EXIT          
                MOVE SPACES                     TO RS-RECV-COMMENT-TEXT 
                                                   LH-COMMENTS-TX-TEXT  
                PERFORM 7450-FETCH-RECV-CMNT-CURSOR   THRU 7450-EXIT    
                                                                        
           END-PERFORM.                                                 
                                                                        
           PERFORM 7475-CLOSE-RECV-CMNT-CURSOR   THRU 7475-EXIT.        
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7000-SELECT-WRITEOFF-DT                                     **        
      **  SELECT WRITE OFF DATE FOR THE ACCOUNT                       **        
      ******************************************************************        
      *                                                                         
       7000-SELECT-WRITEOFF-DT.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) FW_ACTION_DT                                        
              INTO                                                      
                  :KD-FW-ACTION-DT                                      
              FROM                                                      
                  CSS_FIN_WO_ACTION                                     
              WHERE                                                     
                  ACCOUNT_NO = :KD-ACCOUNT-NO                           
              AND FW_ACTION_TYPE_CD = 'WO'                              
              ORDER BY FW_SEQ_NO DESC                                   
                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*           FW_ACTION_DT                                                  
MFA-TR*       INTO                                                              
MFA-TR*           :KD-FW-ACTION-DT                                              
MFA-TR*       FROM                                                              
MFA-TR*           CSS_FIN_WO_ACTION                                             
MFA-TR*       WHERE                                                             
MFA-TR*           ACCOUNT_NO = :KD-ACCOUNT-NO                                   
MFA-TR*       AND FW_ACTION_TYPE_CD = 'WO'                                      
MFA-TR*       ORDER BY FW_SEQ_NO DESC                                           
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
                                          NOT-FOUND                     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_FIN_WO_ACTION'   TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE KD-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7050-SELECT-COLLECT-STATUS                                  **        
      **  SELECT COLLECT STATUS FOR THE ACCOUNT                       **        
      ******************************************************************        
      *                                                                         
       7050-SELECT-COLLECT-STATUS.                                      
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                  COLLECT_STATUS_CD                                     
              INTO                                                      
                  :FW-COLLECT-STATUS-CD                                 
              FROM                                                      
                  CSS_FINAL_WO                                          
              WHERE                                                     
                  ACCOUNT_NO = :FW-ACCOUNT-NO                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
                                          NOT-FOUND                     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7050'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_FINAL_WO'        TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE FW-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7100-SELECT-AMT-TRANS                                       **        
      **  SELECT SUM AMT-TRANS FOR THE ACCOUNT                        **        
      ******************************************************************        
      *                                                                         
       7100-SELECT-AMT-TRANS.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                  SUM(AMT_TRANS)                                        
              INTO                                                      
                  :CO-AMT-TRANS                                         
              FROM                                                      
                  CSS_CHRG_OFF                                          
              WHERE                                                     
                  ACCOUNT_NO = :CO-ACCOUNT-NO                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
                                          NOT-FOUND                     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_CHRG_OFF'        TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE CO-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7150-SELECT-ORIG-AMT                                        **        
      **  SELECT SUM WO-ORIG-AM FOR THE ACCOUNT                       **        
      ******************************************************************        
      *                                                                         
       7150-SELECT-ORIG-AMT.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                  SUM(WO_ORIGINAL_AM)                                   
              INTO                                                      
                  :CO-WO-ORIGINAL-AM                                    
              FROM                                                      
                  CSS_CHRG_OFF                                          
              WHERE                                                     
                  ACCOUNT_NO = :CO-ACCOUNT-NO                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
                                          NOT-FOUND                     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7150'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_CHRG_OFF'        TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE CO-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7200-SELECT-COLLQ-ID                                        **        
      **  SELECT COLL QUEUE ID FOR THE ACCOUNT                        **        
      ******************************************************************        
      *                                                                         
       7200-SELECT-COLLQ-ID.                                            
      *                                                                         
           EXEC SQL                                                     
              SELECT TOP(1) CALL_QUEUE_ID                                       
              INTO                                                      
                  :HC-CALL-QUEUE-ID                                     
              FROM                                                      
                  CSS_COLLECT_HIST                                      
              WHERE                                                     
                  ACCOUNT_NO = :HC-ACCOUNT-NO                           
              AND FUTURE_WORK_DT > IIF(TRY_CONVERT(DATE, '1900-01-01'
              ) IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )                     
                                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*           CALL_QUEUE_ID                                                 
MFA-TR*       INTO                                                              
MFA-TR*           :HC-CALL-QUEUE-ID                                             
MFA-TR*       FROM                                                              
MFA-TR*           CSS_COLLECT_HIST                                              
MFA-TR*       WHERE                                                             
MFA-TR*           ACCOUNT_NO = :HC-ACCOUNT-NO                                   
MFA-TR*       AND FUTURE_WORK_DT > '1900-01-01'                                 
MFA-TR*       FETCH FIRST 1 ROW ONLY                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
                                          NOT-FOUND                     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7200'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_COLLECT_HIST'    TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE HC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7250-SELECT-CRBUR-DETAILS                                   **        
      **  SELECT CREDIT BEUREA LISTED DATE AND LISTED AMOUNT          **        
      ******************************************************************        
      *                                                                         
       7250-SELECT-CRBUR-DETAILS.                                       
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                  FW_ACTION_DT                                          
                 ,FW_ACTION_AM                                          
              INTO                                                      
                  :KD-FW-ACTION-DT                                      
                 ,:KD-FW-ACTION-AM                                      
              FROM                                                      
                  CSS_FIN_WO_ACTION WITH(READUNCOMMITTED)                       
              WHERE                                                     
                  ACCOUNT_NO        = :KD-ACCOUNT-NO                    
              AND FW_ACTION_TYPE_CD = 'CREDB'                           
              AND FW_ACTION_AM      > 0                                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*           FW_ACTION_DT                                                  
MFA-TR*          ,FW_ACTION_AM                                                  
MFA-TR*       INTO                                                              
MFA-TR*           :KD-FW-ACTION-DT                                              
MFA-TR*          ,:KD-FW-ACTION-AM                                              
MFA-TR*       FROM                                                              
MFA-TR*           CSS_FIN_WO_ACTION                                             
MFA-TR*       WHERE                                                             
MFA-TR*           ACCOUNT_NO        = :KD-ACCOUNT-NO                            
MFA-TR*       AND FW_ACTION_TYPE_CD = 'CREDB'                                   
MFA-TR*       AND FW_ACTION_AM      > 0                                         
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
                                          NOT-FOUND                     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7250'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_FIN_WO_ACTION'   TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE KD-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7300-SELECT-PERM-COMMENT                                    **        
      **  SELECT PERMANENT COMMENTS FOR THE ACCOUNT                   **        
      ******************************************************************        
      *                                                                         
       7300-SELECT-PERM-COMMENTS.                                       
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                  COLL_EXEMPTION_CD                                     
                 ,COLL_COMMENT_TX                                       
              INTO                                                      
                  :IF-COLL-EXEMPTION-CD :WS-NULL-IND1                   
                 ,:IF-COLL-COMMENT-TX :WS-NULL-IND2                     
             FROM                                                       
                  CSS_COLL_ACCT_INFO                                    
             WHERE ACCOUNT_NO = :IF-ACCOUNT-NO                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
                                          NOT-FOUND                     
              IF WS-NULL-IND1 < 0                                       
                 MOVE SPACES             TO IF-COLL-EXEMPTION-CD        
              END-IF                                                    
              IF WS-NULL-IND2 < 0                                       
                 MOVE SPACES             TO IF-COLL-COMMENT-TX-TEXT     
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7300'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_COLL_ACCT_INFO'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE IF-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  7350-SELECT-ARRANGEMENTS                                    **        
      **  CHECK WHETHER ARRANGMENTS EXSIT FOR THE ACCOUNT             **        
      ******************************************************************        
      *                                                                         
       7350-SELECT-ARRANGEMENTS.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                  'Y'                                                   
              INTO                                                      
                  :WS-EXISTS                                            
             FROM                                                       
                  CSS_WO_ARRANGEMENT                                    
             WHERE ACCOUNT_NO = :WG-ACCOUNT-NO                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
                                          NOT-FOUND                     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7350'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_WO_ARRANGEMENT'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE WG-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05580100
      ***************************************************************** 05585000
      * 7400-OPEN-RECV-CMNT-CURSOR                                      05585200
      ***************************************************************** 05585400
      *                                                                 05586000
       7400-OPEN-RECV-CMNT-CURSOR.                                      
      *                                                                 05591000
           EXEC SQL                                                     
               OPEN RECV_CMNT_CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE       TO WS-ACTIVE-RETURN-CODE.                 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE             
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7400'                 TO ACTIVE-PARAGRAPH           
              MOVE 'OPEN'                 TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_COLL_HIST_DET'    TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE LH-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05595000
      ***************************************************************** 05597000
      *                                                                 05598000
      * 7450-FETCH-RECV-CMNT-CURSOR                                     05599000
      *                                                                 05599100
      ***************************************************************** 05599200
      *                                                                 05599300
       7450-FETCH-RECV-CMNT-CURSOR.                                     
      *                                                                 05599500
           EXEC SQL                                                     
               FETCH                                                    
                    RECV_CMNT_CUR                                       
               INTO                                                     
                    :LH-COMMENTS-TX :WS-NULL-IND3                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 IF WS-NULL-IND3 = -1                                   
                    MOVE SPACES           TO LH-COMMENTS-TX             
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE             
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7450'                 TO ACTIVE-PARAGRAPH           
              MOVE 'FETCH'                TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_COLL_HIST_DET'    TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE LH-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 05850500
       7450-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05850500
      ***************************************************************** 05603600
      * 7475-CLOSE-RECV-CMNT-CURSOR                                   * 05603800
      *                                                               * 05603900
      ***************************************************************** 05604000
      *                                                                 05604100
       7475-CLOSE-RECV-CMNT-CURSOR.                                     
      *                                                                 05604300
           EXEC SQL                                                     
               CLOSE RECV_CMNT_CUR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE             
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7475'                 TO ACTIVE-PARAGRAPH           
              MOVE 'CLOSE'                TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_COLL_HIST_DET'    TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE LH-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 05850800
       7475-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *8000A-DELETE-GTT-ROWS.                                                   
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                         
            MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.         
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR02301_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR02301_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO  ABEND-PROGRAM             
               MOVE '8000A'               TO  ACTIVE-PARAGRAPH          
               MOVE 'DELETE'              TO  ABEND-FUNCTION            
               MOVE SQLCODE               TO  ABEND-SQLCODE             
               MOVE SPACES                TO  ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
               MOVE 'CSR02301_R1'         TO  TABLE-1                   
               MOVE SPACES                TO  TABLE-ELEMENT-1           
               MOVE SPACES                TO  HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT                           
                                          THRU 9000-EXIT                
               PERFORM 9900-SQL-ERROR-ROUTINE                           
                                          THRU 9900-EXIT                
            END-IF.                                                     
      *                                                                         
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *  8100-SEND-RESULT                                              *        
      *                                                                *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
            EXEC SQL                                                    
                 INSERT INTO #CSR02301_R1                        
                 (                                                      
                      RETURN_CODE                                       
                     ,RECORD_ID                                         
                     ,AMT_TRANS                                         
                     ,WO_ORIGINAL_AMT                                   
                     ,WRITEOFF_DT                                       
                     ,COLL_STATUS_CD                                    
                     ,COLL_QUEUE_ID                                     
                     ,CB_LIST_DT                                        
                     ,CB_LIST_AMT                                       
                     ,COLL_EXEMPT_CD                                    
                     ,PERM_COMMENT                                      
                     ,ARNGMNT_EXIST                                     
                     ,RECV_COMMENT                                      
                 )                                                      
                 VALUES                                                 
                 (                                                      
                      :S-RETURN-CODE                                    
                     ,:S-RECORD-ID                                      
                     ,:S-AMT-TRANS                                      
                     ,:S-WO-ORIG-AMT                                    
                     ,:S-WRITEOFF-DT                                    
                     ,:S-COLL-STATUS-CD                                 
                     ,:S-CALL-QUEUE-ID                                  
                     ,:S-CB-LIST-DT                                     
                     ,:S-CB-LIST-AMT                                    
                     ,:S-COLL-EXEMPTION-CD                              
                     ,:S-PERM-COMMENT-TEXT                              
                     ,:S-ARRANGEMNT-EXIST                               
                     ,:S-RECV-COMMENT-TEXT                              
                 )                                                      
             END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          INSERT INTO SESSION.CSR02301_R1                                
MFA-TR*          (                                                              
MFA-TR*               RETURN_CODE                                               
MFA-TR*              ,RECORD_ID                                                 
MFA-TR*              ,AMT_TRANS                                                 
MFA-TR*              ,WO_ORIGINAL_AMT                                           
MFA-TR*              ,WRITEOFF_DT                                               
MFA-TR*              ,COLL_STATUS_CD                                            
MFA-TR*              ,COLL_QUEUE_ID                                             
MFA-TR*              ,CB_LIST_DT                                                
MFA-TR*              ,CB_LIST_AMT                                               
MFA-TR*              ,COLL_EXEMPT_CD                                            
MFA-TR*              ,PERM_COMMENT                                              
MFA-TR*              ,ARNGMNT_EXIST                                             
MFA-TR*              ,RECV_COMMENT                                              
MFA-TR*          )                                                              
MFA-TR*          VALUES                                                         
MFA-TR*          (                                                              
MFA-TR*               :S-RETURN-CODE                                            
MFA-TR*              ,:S-RECORD-ID                                              
MFA-TR*              ,:S-AMT-TRANS                                              
MFA-TR*              ,:S-WO-ORIG-AMT                                            
MFA-TR*              ,:S-WRITEOFF-DT                                            
MFA-TR*              ,:S-COLL-STATUS-CD                                         
MFA-TR*              ,:S-CALL-QUEUE-ID                                          
MFA-TR*              ,:S-CB-LIST-DT                                             
MFA-TR*              ,:S-CB-LIST-AMT                                            
MFA-TR*              ,:S-COLL-EXEMPTION-CD                                      
MFA-TR*              ,:S-PERM-COMMENT-TEXT                                      
MFA-TR*              ,:S-ARRANGEMNT-EXIST                                       
MFA-TR*              ,:S-RECV-COMMENT-TEXT                                      
MFA-TR*          )                                                              
MFA-TR*      END-EXEC.                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                     
      *                                                                         
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                ADD +1                    TO  CTR-ROWS                  
             ELSE                                                       
                MOVE PROGRAM-NAME         TO  ABEND-PROGRAM             
                MOVE '8100'               TO  ACTIVE-PARAGRAPH          
                MOVE 'INSERT'             TO  ABEND-FUNCTION            
                MOVE SQLCODE              TO  ABEND-SQLCODE             
                MOVE SPACES               TO  ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                MOVE 'CSR02301_R1'        TO  TABLE-1                   
                MOVE SPACES               TO  TABLE-ELEMENT-1           
                MOVE SPACES               TO  HOSTVAR-ELEMENT-1         
                PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
             END-IF.                                                    
      *                                                                         
        8100-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      *                                                                         
      ******************************************************************        
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *        
      ******************************************************************        
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPD00320                                                  
REARCH     END-EXEC.                                                            
                                                                        
