       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02300.                                         
COB303 DATE-WRITTEN.  26 JULY 2005.                                     
       DATE-COMPILED.                                                   
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S300                                           *        
      *  PROGRAM:       S300                                           *        
      *  CALLING SP:    PA_S300                                        *        
      *  PANEL:         378                                            *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *        
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *        
      *                                                                *        
      *  THIS PROGRAM IS USED TO POST VOUCHER PAYMENTS ACCEPTED USING  *        
      *  PANEL 378. PANEL 378 DOES NOT ALLOW DIRECTED PAYMENTS, HOWEVER*        
      *  THIS PROGRAM CAN PERFORM DIRECTED PAYMENTS SHOULD THE NEED    *        
      *  ARISE IN FUTURE.                                              *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  12/13/95  BB         PROGRAM ORIGINALLY WRITTEN               *        
      *  03/13/96  BB         CHANGES FOR FIELD CASH DONE              *        
      *  03/28/96  LMB        TPR 2585 - ADDED TBNSFHST, TBCRPROF      *        
      *  06/18/96  TCB        ADDED CODE TO POPULATE TRAN_ID IN THE    *        
      *                       CSS_CSH_DRWR_JNRL TABLE WITH THE PROGRAM *        
      *                       NAME.  TPR 4443.                         *        
      *  07/25/96  JEP        REMOVED CPD00068, CWS00068, AND          *        
      *                       REFERENCES TO TBCRCOLL AND TBDELQ        *        
      *                       TPR 4894                                 *        
      *  09/04/96  SG         TPR 5279 - ADDED THE TRANSACTION COMMENT *        
      *                       AND COMMENT LENGTH FIELDS AS PARAMETERS  *        
      *                       AND MOVE THEM INTO THE CORRESPONDING     *        
      *                       AR FIELDS FOR JOURNALING.                *        
      *                                                                *        
      *  09/23/96  PD         PCR305 ADDED CJF00105 FOR CPD10 CHANGES. *        
PCR072*  09/30/96  PD         COMMENTED CODE FOR CIAC FOR PCR072.      *        
      *  10/17-96  MRB        PCR #360 - ADDED COPY LIBRARY CPD00068   *        
      *                       LOGIC TO THIS PROGRAM TO DETERMINE IF    *        
      *                       THE DNP SHOULD BE CANCELLED ON PANEL     *        
      *                       #378 AS WELL AS THE RETRIEVAL OF THE     *        
      *                       PREMISE AND CUSTOMER NUMBER FOR CANCEL   *        
      *                       DNP FUNCTION.                            *        
TP9728**  03/19/97 PD         ADD DCLGEN TBWOARGM FOR CPD73 CHANGES.   *        
      *                                                                *        
      **  03/31/97 MJG        ADDED TWO DCLGENS FOR CPD00068 CHANGES.  *        
      **  06/02/97 PD         REMOVE CASHIERING OUT OF THIS PANEL.     *        
      **  06/04/97 PD         MOVE CALL OF CPD68 AFTER CALL TO CPD10.  *        
      *                                                                *        
T11987*   07/08/97 CHANDRA    EXIT THE PROGRAM IF THE AR_LOCKOUT IS    *        
      *                       'Y'                                      *        
NONUTL*    7/11/97 CHANDRA    ADDED CPD00312, CWS10016, TBHLDAY        *        
T12460*   08/01/97 EMS        ADDED CSS_DNP DCLGEN FOR CPD68 CHANGES   *        
PCR307*    09/03/98  AMG      IF THE PAYMENT IS NOT ENOUGH TO CANCEL   *        
PCR307*                       THE DNP, THEN INSERT A ROW INTO          *        
PCR307*                       CSS_SO_DNP_CANCEL WITH A FLAG OF 'U'     *        
T17071*    11/19/98  MDJ      ADDED INCLUDE TBCSTALT FOR CUST_ALERT IN *        
      *                       CPD00068.                                *        
CBSI  *   12/15/98 CBSI       ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *            MADRAS     ABEND PARAMETERS                         *        
T19540*  06/11/99    PR       GETTING RCC AMT FROM CPD00316.RCC AMT    *        
T19540*                       ALWAYS OVERRIDES THE DNP AMT INOREDR TO  *        
T19540*                       CANCEL DNPFB AND ACTIVATE RECONNECT.     *        
T19557*  31/03/00    CBSI     COPYBOOK CDP00068 CHANGED TO SUB PROGRAM *        
T19557*              MADRAS   SCSCO068.                                *        
      *  04/30/01  CHANELLE K MCR310 PSNC.  REFER TO '01' FOR GL.      *        
T24367*  06/26/01    SFH      ADDED LOGIC TO SEND CANCELNOT FLAG TO    *        
      *                       PANEL PANEL 378.                         *        
T23235*  07/13/01    SFH      ADDED DCLGEN FOR CSS_UTIL_ENVRNMT.       *        
T24555*  08/07/01    SFH      REPLACED WS-GL-SUB WITH WS-VALID-CO-SUB  *        
      *                       AS AN INDEX TO WS-VALID-CO-NO. THIS WILL *        
      *                       PREVENT A SUBSCRIPT OUT OF BOUNDS ERROR. *        
T24436*  10/12/01  COVANSYS   COPYBOOK CPD00061 CHANGED TO SUB        **        
T24436*            CHENNAI    PROGRAM  SCSCO061.                      **        
C26130*   06/28/02    SRIDEVI  INCLUDED TBMNHIST & TBMNHDT INORDER TO *         
C26130*                        WRITE INTO MNT TRANSACTION HISTORY     *         
C26130*                        TABLES AT THE TIME OF AUTOMATIC EPP SETUP        
C28788*   07/07/03    MDJ      GET IVR-EXEMPT-CD FOR CPD00068.        *         
REARCH*   07/26/05    CVNS     RPC TO COBOL SP CONVERSION             *         
REARCH*               CHENNAI                                         *         
T33431** 03/16/06   SK88120        COG PROJECT CHANGES -                        
T33431**                           A- ADD NEW COPYBOOKS                         
T33431**                           B- CHANGE IN CPD00073                        
T34984*  30/10/06  CVNS       CHANGE CALL TO MCSCB068 FROM STATIC TO   *        
T34984*            CHENNAI    DYNAMIC                                  *        
T37302*  06/16/08  MR97640    DELETE DCLGEN TBCIAC                     *        
A00956*  03/26/09  CVNS       REPLACE CPD00006 WITH CPD0006A.          *        
A00956*            CHENNAI                                             *        
A36248*  05/15/09  LG41184    CALL NEW SUBPROGRAM MCSCB371 TO UPDATE   *        
A36248*                       DNP BALANCE REAL TIME FOR CSR.           *        
A37302*  07/06/09  LG41184    DCLGEN TBRVCACT REMOVED.                 *        
A03578*  08/16/11  BASKAR V   MOVE CORRECT TRAN ID DURING JOURNALING.  *        
      *                                                                *        
A05154* 16 FEB 2015 RF10596   REMOVE UNUSED CODE                       *        
A04860*  04/05/16  MS7M727   REPLACE CSS_WQ_ITEMS_MF TABLE WITH        *01790100
A04860*            ACT105    CSS_WQ_ITEMS TABLE                        *01790200
      *                                                                *        
P00849* 05/12/16   RC41079    MODIFIED CODE TO CALL MCS03413 TO HANDLE *        
P00849*                       OFF DNP AND NOTICE ORDERS INSTEAD OF     *        
P00849*                       SENDING FLAGS BACK TO MOD TO BE HANDLED  *        
P00849*                       THERE. UPDATED DNP PROCESS.              *        
ACT285* 11/10/16   AA97148    REPLACE CPD03413 WITH NEW COPYBOOK       *        
ACT285*                       CPD03414. REF:APPL00005460               *        
P00948* 01/01/17   VENKAT.P   SEND DNP CANCEL NOTIFICATION E-MAIL FOR  *        
P00948*                       CUSTOMERS WITH E-MAIL ADDRESS.           *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02300'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02300 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
                                                                        
           EXEC SQL                                                     02450012
              INCLUDE TBBGTPLN                                          02460012
           END-EXEC.                                                    02470012
                                                                        
           EXEC SQL                                                     02450012
              INCLUDE TBCNTDET                                          02460012
           END-EXEC.                                                    02470012
                                                                        
           EXEC SQL                                                     02450012
              INCLUDE TBBGTHST                                          02460012
           END-EXEC.                                                    02470012
                                                                        
           EXEC SQL                                                     02450012
              INCLUDE TBDEPHND                                          02460012
           END-EXEC.                                                    02470012
                                                                        
           EXEC SQL                                                     02570016
              INCLUDE TBCUST                                            02580016
           END-EXEC.                                                    02590016
                                                                        
           EXEC SQL                                                     02610016
              INCLUDE TBPREM                                            02620016
           END-EXEC.                                                    02630016
                                                                        
                                                                        
           EXEC SQL                                                     00010000
              INCLUDE TBCNTRCT                                          00020000
           END-EXEC.                                                    00030000
                                                                        
           EXEC SQL                                                     00010000
              INCLUDE TBARHIST                                          00020000
           END-EXEC.                                                    00030000
                                                                        
           EXEC SQL                                                     00010000
              INCLUDE TBARHDT                                           00020000
           END-EXEC.                                                    00030000
                                                                        
           EXEC SQL                                                     00010000
              INCLUDE TBCDCNTL                                          00020000
           END-EXEC.                                                    00030000
                                                                        
           EXEC SQL                                                     00010000
              INCLUDE TBCDJRNL                                          00020000
           END-EXEC.                                                    00030000
                                                                        
           EXEC SQL                                                     00010000
              INCLUDE TBBJCNTL                                          00020000
           END-EXEC.                                                    00030000
                                                                        
           EXEC SQL                                                     00010000
              INCLUDE TBBTJRNL                                          00020000
           END-EXEC.                                                    00030000
                                                                        
           EXEC SQL                                                     00010000
              INCLUDE TBMSJRNL                                          00020000
           END-EXEC.                                                    00030000
                                                                        
           EXEC SQL                                                     00010000
              INCLUDE TBPRJSHR                                          00020000
           END-EXEC.                                                    00030000
                                                                        
           EXEC SQL                                                     00010000
              INCLUDE TBDFARCV                                          00020000
           END-EXEC.                                                    00030000
                                                                        
           EXEC SQL                                                     00010000
              INCLUDE TBARPMT                                           00020000
           END-EXEC.                                                    00030000
                                                                        
           EXEC SQL                                                     00010000
              INCLUDE TBGLATNO                                          00020000
           END-EXEC.                                                    00030000
                                                                        
                                                                        
           EXEC SQL                                                     00010000
              INCLUDE TBDEPHST                                          00020000
           END-EXEC.                                                    00030000
                                                                        
           EXEC SQL                                                             
              INCLUDE TBRECNCT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCHGOFF                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBARLOCK                                                  
           END-EXEC.                                                            
                                                                        
TP2585     EXEC SQL                                                             
PCR307        INCLUDE TBSODNPC                                                  
PCR307     END-EXEC.                                                            
                                                                        
TP9728******************************************************************07009200
TP9728*    CSS_WO_ARRANGEMENT                                           07009300
TP9728******************************************************************07009400
TP9728                                                                  
TP9728     EXEC SQL                                                     07009600
TP9728         INCLUDE TBWOARGM                                         07009700
TP9728     END-EXEC.                                                    07009800
                                                                        
TP2585     EXEC SQL                                                             
TP2585        INCLUDE TBCRPROF                                                  
TP2585     END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
A00956        INCLUDE CWS0013B                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     PCS00710
              INCLUDE CWS00017                                          PCS00710
           END-EXEC.                                                    PCS00710
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00061                                                  
           END-EXEC.                                                            
                                                                        
T24436     EXEC SQL                                                             
T24436        INCLUDE CWS0061L                                                  
T24436     END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     02930012
              INCLUDE CWS00073                                          02940012
           END-EXEC.                                                    02950012
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBLIEAP                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBARCNTL                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBDFAACT                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
NONUTL******************************************************************        
NONUTL*    CSS_HOLIDAY                                                          
NONUTL******************************************************************        
NONUTL     EXEC SQL                                                             
NONUTL         INCLUDE TBHLDAY                                                  
NONUTL     END-EXEC.                                                            
                                                                        
      *--------< CSS_CUST_PLAN  >                                               
                                                                        
PCR072     EXEC SQL                                                             
PCR072        INCLUDE TBCCCHRG                                                  
PCR072     END-EXEC.                                                            
PCR072                                                                  
PCR072     EXEC SQL                                                             
PCR072        INCLUDE TBRCNCHR                                                  
PCR072     END-EXEC.                                                            
PCR360                                                                  
PCR360*--------< INCLUDE CSS_DELINQUENCY >                                      
PCR360     EXEC SQL                                                             
PCR360        INCLUDE TBDELQ                                                    
PCR360     END-EXEC.                                                            
PCR360                                                                  
PCR360*--------< INCLUDE CSS_LOCAL_OFFICE >                                     
PCR360     EXEC SQL                                                             
PCR360        INCLUDE TBLOCOFC                                                  
PCR360     END-EXEC.                                                            
C26130*--------<INCLUDE CSS_MNT_TRANS_HIST >                                    
C26130     EXEC SQL                                                             
C26130        INCLUDE TBMNHIST                                                  
C26130     END-EXEC.                                                            
C26130                                                                  
C26130*--------<INCLUDE CSS_MT_TRN_HST_DET >                                    
C26130     EXEC SQL                                                             
C26130        INCLUDE TBMNHDT                                                   
C26130     END-EXEC.                                                            
T33431     EXEC SQL                                                             
T33431       INCLUDE TBJBPARM                                                   
T33431     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *--------<COMMON SYSTEM AREA >                                            
           COPY CWS00004.                                               00610013
           COPY CWS00007.                                               PCS00660
T19557*--------< LINKAGE SECTION VARIABLES FOR SCSCO068 >                       
T19557     COPY CWS0068L.                                               01680000
T11466     EXEC SQL                                                     PCS00670
T11466        INCLUDE CWS00008                                          PCS00670
T11466     END-EXEC.                                                    PCS00670
                                                                        
      *--------< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >               
           COPY CWS00027.                                                       
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                          
           COPY CWS00303.                                                       
           COPY CWS00100.                                               PCS00750
           COPY CJF00101.                                               PCS00760
           COPY CJF00102.                                               PCS00760
PCR305     COPY CJF00105.                                               PCS00760
           COPY CWS00056.                                                       
T33431     COPY CWSCA225.                                                       
ACT105     COPY CWS00077.                                                       
                                                                        
NONUTL******************************************************************        
NONUTL*    HOLIDAY CHECK                                                        
NONUTL******************************************************************        
NONUTL     EXEC SQL                                                             
NONUTL         INCLUDE CWS10016                                                 
NONUTL     END-EXEC.                                                            
                                                                        
ACT285*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
ACT285*    WS VARIABLE FOR COPY BOOK CPD03414                         *         
ACT285*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
ACT285                                                                  
ACT285     EXEC SQL                                                             
ACT285      INCLUDE CWS03414                                                    
ACT285     END-EXEC.                                                            
ACT285                                                                  
      ******************************************************************        
      * WORKING STORAGE FOR JOURNALING                                 *        
      ******************************************************************        
       01  AR-TRANSACTION-STORAGE.                                      
           05  CURRENT-TIMESTAMP       PIC X(26).                       
           05  CURRENT-DATE            PIC X(10).                       
      *                                                                         
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME             PIC X(08) VALUE 'CSR02300'.     
REARCH     05  WS-PROGRAM-NAME          PIC X(08) VALUE 'CSR02300'.     
ACT105     05  WS-WQ-CALL-PGM           PIC X(08)  VALUE 'MCSCB077'.    
ACT105     05  MCSCB077                 PIC X(08)  VALUE 'MCSCB077'.    
ACT105     05  SCSCB077                 PIC X(08)  VALUE 'SCSCB077'.    
ACT105     05  WS-CPD0010S-CALL-TYPE    PIC X(01)  VALUE 'O'.           
ACT105         88 WS-CPD0010S-ONLINE-CALL          VALUE 'O'.           
ACT105         88 WS-CPD0010S-BATCH-CALL           VALUE 'B'.           
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  WS-SAVE-ROW-COUNT PIC S9(04) COMP VALUE +0.              
           05  WS-DATE-ORIG-PYMT-IND    PIC S9(04) COMP VALUE +0.       
           05  WS-CHRG-OFF-ACCT         PIC  X(01) VALUE 'N'.           
           05  WS-SUB                   PIC S9(04) COMP VALUE +0.       
           05  WS-GO-GL-ACCT-NO-ED      PIC -(3)9.9999.                 
           05  WS-FIRST-PAYMENT         PIC  X(01) VALUE 'Y'.           
               88  FIRST-PAYMENT                   VALUE 'Y'.           
           05  WS-DIR-PAY-TABLE.                                        
               10  WS-DIR-PAY-TAB OCCURS 20 TIMES.                      
                   15  WS-DIR-PAY-REC-TYPE   PIC S9(04) COMP.           
                   15  WS-DIR-PAY-ITEM-ID    PIC S9(09) COMP.           
COB305             15 WS-DIR-PAY-AMT        PIC S9(09)V99 COMP-3 
COB305               VALUE 0.      
                   15  WS-DIR-PAY-AHEAD-TYPE PIC  X(01).                
                   15  WS-DIR-PAY-CHRG-OFF   PIC  X(01).                
                                                                        
           05  WS-ACCOUNT-NO            PIC X(13).                      
           05  WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO                
                                        PIC 9(13).                      
COB305     05 WS-ACCOUNT-NO-COMP3        PIC S9(13) COMP-3 VALUE 0.             
                                                                        
           05  WS-AMOUNT-CHECK          PIC  X(11).                     
           05  WS-AMOUNT-CHECK-NUM REDEFINES WS-AMOUNT-CHECK            
                                        PIC  9(09)V99.                  
           05  WS-AMOUNT-CHECK-COMP3    PIC S9(09)V99 COMP-3 VALUE +0.  
                                                                        
           05  WS-AMOUNT-MORDER         PIC  X(11).                     
           05  WS-AMOUNT-MORDER-NUM REDEFINES WS-AMOUNT-MORDER          
                                        PIC  9(09)V99.                  
           05  WS-AMOUNT-MORDER-COMP3   PIC S9(09)V99 COMP-3 VALUE +0.  
                                                                        
           05  WS-AMOUNT-LIHEAP         PIC  X(11).                     
           05  WS-AMOUNT-LIHEAP-NUM REDEFINES WS-AMOUNT-LIHEAP          
                                        PIC  9(09)V99.                  
           05  WS-AMOUNT-LIHEAP-COMP3   PIC S9(09)V99 COMP-3 VALUE +0.  
                                                                        
           05  WS-AMOUNT-CASH           PIC  X(11).                     
           05  WS-AMOUNT-CASH-NUM REDEFINES WS-AMOUNT-CASH              
                                        PIC  9(09)V99.                  
           05  WS-AMOUNT-CASH-COMP3     PIC S9(09)V99 COMP-3 VALUE +0.  
                                                                        
           05  WS-AMT-CHRG-CARD         PIC  X(11).                     
           05  WS-AMT-CHRG-CARD-NUM REDEFINES WS-AMT-CHRG-CARD          
                                        PIC  9(09)V99.                  
           05  WS-AMT-CHRG-CARD-COMP3   PIC S9(09)V99 COMP-3 VALUE +0.  
                                                                        
           05  WS-BILLED-AMT            PIC S9(11)V99 COMP-3 VALUE +0.  
                                                                        
           05  WS-DIR-PAYMENT-BREAKDOWN.                                
               10  WS-REV-TYPE          PIC  X(04).                     
               10  WS-REV-TYPE-NUM REDEFINES WS-REV-TYPE                
                                        PIC S9(04).                     
               10  WS-ITEM-ID           PIC  X(09).                     
               10  WS-ITEM-ID-NUM REDEFINES WS-ITEM-ID                  
                                        PIC S9(09).                     
               10  WS-AMT-DIR-PYMT      PIC  X(11).                     
               10  WS-AMT-DIR-PYMT-NUM REDEFINES WS-AMT-DIR-PYMT        
                                        PIC S9(09)V99.                  
               10  WS-PAY-AHEAD-TYPE    PIC  X(01).                     
               10  WS-PAY-CHRG-OFF      PIC  X(01).                     
                                                                        
           05  WS-CURRENT1-DATE          PIC  X(26) VALUE SPACES.       
           05  WS-CURRENT-DATE          PIC  X(10) VALUE SPACES.        
           05  WS-CURRENT-TIMESTAMP     PIC  X(26) VALUE SPACES.        
           05  WS-COMMENT-LEN           PIC 9(04) VALUE 0.              
           05  WS-COMMENT-LEN-NUM       PIC S9(04) COMP VALUE 0.        
T5279      05  WS-TRAN-COMMENT-LEN-NUM  PIC S9(04) COMP VALUE 0.        
           05  WS-COMMENT-TEXT          PIC X(25) VALUE SPACES.         
           05  WS-GL-ACCT-NO            PIC X(07) VALUE SPACES.         
           05  WS-GL-ACCT-NO-NUM        REDEFINES WS-GL-ACCT-NO         
                                        PIC 9(07).                      
           05  WS-GL-ACCT-DEBIT         PIC S9(03)V9(04) COMP-3 VALUE 0.
T19557     05  WS-EIBRESP               PIC S9(8)                       
T19557                                  COMP SYNC VALUE ZERO.           
P00849     05  WS-DNP-RET-CODE          PIC S9(4) VALUE 0 COMP.         
P00849     05  WS-UPDATE-ACTION-FL      PIC X(01) VALUE SPACES.         
P00849     05  WS-FACILITY-CODE         PIC X(01) VALUE SPACES.         
ACT285     05  WS-PYMT-AMOUNT           PIC S9(09)V99 COMP-3 VALUE +0.  
                                                                        
       01  WS-LITERAL.                                                  
           05  WS-A                     PIC X(01) VALUE 'A'.            
           05  WS-C                     PIC X(01) VALUE 'C'.            
           05  WS-D                     PIC X(01) VALUE 'D'.            
           05  WS-S                     PIC X(01) VALUE 'S'.            
PCR307     05  WS-U                     PIC X(01) VALUE 'U'.            
           05  WS-RCV-TYPE              PIC S9(04) COMP.                
           05  WS-NO                    PIC  X(01) VALUE 'N'.           
           05  WS-YES                   PIC  X(01) VALUE 'Y'.           
           05  WS-NO-ERROR              PIC  X(05) VALUE 'NOERR'.       
           05 WS-UPDATE-TYPE          PIC X(01) VALUE SPACES.           
      *                                                                         
                                                                        
REARCH 01  GW-LIB-MISC-FIELDS.                                          
REARCH     05  MCSCO061                PIC X(08) VALUE 'MCSCO061'.      
REARCH     05  MCSCB068                PIC X(08) VALUE 'MCSCB068'.      
T33431     05  MCSCB225                PIC X(8) VALUE  'MCSCB225'.      
A36248     05  MCSCB371                PIC X(08) VALUE 'MCSCB371'.      
ACT285     05  MCS03414                PIC X(8)  VALUE 'MCS03414'.      
T33431     05  WS-COG-TRAN-TYPE-CD-73   PIC X(1) VALUE  'P'.            
      *                                                                         
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                   PIC S9(9) COMP.                 
           05  PARM-UPDATE-TYPE         PIC  X(01).                     
           05  PARM-ACCOUNT-NO          PIC  X(13).                     
           05  PARM-ACCOUNT-NO-NUM REDEFINES PARM-ACCOUNT-NO            
                                        PIC 9(13).                      
           05  PARM-FACILITY-CODE       PIC  X(01).                     
           05  PARM-PAYMENT-TYPE        PIC  X(01).                     
           05  PARM-AMT-CHECK           PIC  X(11).                     
           05  PARM-AMT-MONEY-ORDER     PIC  X(11).                     
           05  PARM-AMT-LIHEAP          PIC  X(11).                     
           05  PARM-CHRG-CARD-TYPE      PIC  X(01).                     
           05  PARM-AMT-CHRG-CARD       PIC  X(11).                     
           05  PARM-AMT-CASH            PIC  X(11).                     
           05  PARM-NO-ROWS             PIC S9(04) COMP.                
           05  PARM-DIR-PAY-1           PIC  X(26).                     
           05  PARM-DIR-PAY-2           PIC  X(26).                     
           05  PARM-DIR-PAY-3           PIC  X(26).                     
           05  PARM-DIR-PAY-4           PIC  X(26).                     
           05  PARM-DIR-PAY-5           PIC  X(26).                     
           05  PARM-DIR-PAY-6           PIC  X(26).                     
           05  PARM-DIR-PAY-7           PIC  X(26).                     
           05  PARM-DIR-PAY-8           PIC  X(26).                     
           05  PARM-DIR-PAY-9           PIC  X(26).                     
           05  PARM-DIR-PAY-10          PIC  X(26).                     
           05  PARM-DIR-PAY-11          PIC  X(26).                     
           05  PARM-DIR-PAY-12          PIC  X(26).                     
           05  PARM-DIR-PAY-13          PIC  X(26).                     
           05  PARM-DIR-PAY-14          PIC  X(26).                     
           05  PARM-DIR-PAY-15          PIC  X(26).                     
           05  PARM-DIR-PAY-16          PIC  X(26).                     
           05  PARM-DIR-PAY-17          PIC  X(26).                     
           05  PARM-DIR-PAY-18          PIC  X(26).                     
           05  PARM-DIR-PAY-19          PIC  X(26).                     
           05  PARM-DIR-PAY-20          PIC  X(26).                     
           05  PARM-USER-ID             PIC  X(07).                     
           05  PARM-LOCAL-OFFICE        PIC  X(03).                     
           05  PARM-INITIATED-BY        PIC  X(07) VALUE SPACES .       
           05  PARM-CODE-AGENCY-ID      PIC  X(05) VALUE SPACES .       
           05  PARM-PYMT-FACILITY-CD    PIC  X(1)  VALUE SPACES.        
           05  PARM-COMMENT-LEN         PIC  X(04).                     
           05  PARM-COMMENT-TEXT        PIC  X(25).                     
T5279      05  PARM-TRAN-COMMENT        PIC  X(210).                    
T5279      05  PARM-TRAN-COMMENT-LEN    PIC  X(04).                     
           05  PARM-GL-ACCT-NO          PIC  X(07).                     
           05  PARM-PANEL-NO            PIC  X(08).                     
                                                                        
REARCH 01  TDS-RETURN-FIELDS.                                           
REARCH     05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
REARCH     05  RS-ERROR-MESSAGE         PIC  X(05) VALUE 'NOERR'.       
REARCH     05  RS-CANCELDNP-FLAG        PIC X(01) VALUE SPACES.         
REARCH     05  RS-PREMISE-NO            PIC X(10) VALUE SPACES.         
REARCH     05  RS-CUSTOMER-NO           PIC X(10) VALUE SPACES.         
REARCH     05  RS-RECONNECT-IND         PIC X(01) VALUE SPACES.         
REARCH     05  RS-CANCELNOT-FLAG        PIC X(01) VALUE SPACES.         
REARCH*                                                                         
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE            PIC S9(9) COMP VALUE 0.         
REARCH     05  S-ERROR-MESSAGE          PIC  X(05) VALUE 'NOERR'.       
REARCH     05  S-CANCELDNP-FLAG         PIC X(01) VALUE SPACES.         
REARCH     05  S-PREMISE-NO             PIC X(10) VALUE SPACES.         
REARCH     05  S-CUSTOMER-NO            PIC X(10) VALUE SPACES.         
REARCH     05  S-RECONNECT-IND          PIC X(01) VALUE SPACES.         
REARCH     05  S-CANCELNOT-FLAG         PIC X(01) VALUE SPACES.         
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
PCR360     05  WS-PREMISE-NO-NUM       PIC 9(10) VALUE ZEROES.          
PCR360     05  WS-CUSTOMER-NO-NUM      PIC 9(10) VALUE ZEROES.          
PCR360     05  WS-NULL-IND1            PIC S9(04) COMP VALUE +0.        
PCR360     05  WS-NULL-IND2            PIC S9(04) COMP VALUE +0.        
PCR360     05  WS-NULL-IND3            PIC S9(04) COMP VALUE +0.        
PCR360     05  WS-NULL-IND4            PIC S9(04) COMP VALUE +0.        
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
      *                                                                         
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-UPDATE-TYPE         PIC  X(01)               .          
CVT000 01  LINK-ACCOUNT-NO          PIC  X(13)               .          
CVT000 01  LINK-FACILITY-CODE       PIC  X(01)               .          
CVT000 01  LINK-PAYMENT-TYPE        PIC  X(01)               .          
CVT000 01  LINK-AMT-CHECK           PIC  X(11)               .          
CVT000 01  LINK-AMT-MONEY-ORDER     PIC  X(11)               .          
CVT000 01  LINK-AMT-LIHEAP          PIC  X(11)               .          
CVT000 01  LINK-CHRG-CARD-TYPE      PIC  X(01)               .          
CVT000 01  LINK-AMT-CHRG-CARD       PIC  X(11)               .          
CVT000 01  LINK-AMT-CASH            PIC  X(11)               .          
CVT000 01  LINK-NO-ROWS             PIC S9(04) COMP          .          
CVT000 01  LINK-DIR-PAY-1           PIC  X(26)               .          
CVT000 01  LINK-DIR-PAY-2           PIC  X(26)               .          
CVT000 01  LINK-DIR-PAY-3           PIC  X(26)               .          
CVT000 01  LINK-DIR-PAY-4           PIC  X(26)               .          
CVT000 01  LINK-DIR-PAY-5           PIC  X(26)               .          
CVT000 01  LINK-DIR-PAY-6           PIC  X(26)               .          
CVT000 01  LINK-DIR-PAY-7           PIC  X(26)               .          
CVT000 01  LINK-DIR-PAY-8           PIC  X(26)               .          
CVT000 01  LINK-DIR-PAY-9           PIC  X(26)               .          
CVT000 01  LINK-DIR-PAY-10          PIC  X(26)               .          
CVT000 01  LINK-DIR-PAY-11          PIC  X(26)               .          
CVT000 01  LINK-DIR-PAY-12          PIC  X(26)               .          
CVT000 01  LINK-DIR-PAY-13          PIC  X(26)               .          
CVT000 01  LINK-DIR-PAY-14          PIC  X(26)               .          
CVT000 01  LINK-DIR-PAY-15          PIC  X(26)               .          
CVT000 01  LINK-DIR-PAY-16          PIC  X(26)               .          
CVT000 01  LINK-DIR-PAY-17          PIC  X(26)               .          
CVT000 01  LINK-DIR-PAY-18          PIC  X(26)               .          
CVT000 01  LINK-DIR-PAY-19          PIC  X(26)               .          
CVT000 01  LINK-DIR-PAY-20          PIC  X(26)               .          
CVT000 01  LINK-USER-ID             PIC  X(07)               .          
CVT000 01  LINK-LOCAL-OFFICE        PIC  X(03)               .          
CVT000 01  LINK-INITIATED-BY        PIC  X(07)               .          
CVT000 01  LINK-CODE-AGENCY-ID      PIC  X(05)               .          
CVT000 01  LINK-PYMT-FACILITY-CD    PIC  X(1)                .          
CVT000 01  LINK-COMMENT-LEN         PIC  X(04)               .          
CVT000 01  LINK-COMMENT-TEXT        PIC  X(25)               .          
CVT000 01  LINK-TRAN-COMMENT        PIC  X(210)              .          
CVT000 01  LINK-TRAN-COMMENT-LEN    PIC  X(04)               .          
CVT000 01  LINK-GL-ACCT-NO          PIC  X(07)               .          
CVT000 01  LINK-PANEL-NO            PIC  X(08)               .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000           LINK-UPDATE-TYPE                                       
CVT000         , LINK-ACCOUNT-NO                                        
CVT000         , LINK-FACILITY-CODE                                     
CVT000         , LINK-PAYMENT-TYPE                                      
CVT000         , LINK-AMT-CHECK                                         
CVT000         , LINK-AMT-MONEY-ORDER                                   
CVT000         , LINK-AMT-LIHEAP                                        
CVT000         , LINK-CHRG-CARD-TYPE                                    
CVT000         , LINK-AMT-CHRG-CARD                                     
CVT000         , LINK-AMT-CASH                                          
CVT000         , LINK-NO-ROWS                                           
CVT000         , LINK-DIR-PAY-1                                         
CVT000         , LINK-DIR-PAY-2                                         
CVT000         , LINK-DIR-PAY-3                                         
CVT000         , LINK-DIR-PAY-4                                         
CVT000         , LINK-DIR-PAY-5                                         
CVT000         , LINK-DIR-PAY-6                                         
CVT000         , LINK-DIR-PAY-7                                         
CVT000         , LINK-DIR-PAY-8                                         
CVT000         , LINK-DIR-PAY-9                                         
CVT000         , LINK-DIR-PAY-10                                        
CVT000         , LINK-DIR-PAY-11                                        
CVT000         , LINK-DIR-PAY-12                                        
CVT000         , LINK-DIR-PAY-13                                        
CVT000         , LINK-DIR-PAY-14                                        
CVT000         , LINK-DIR-PAY-15                                        
CVT000         , LINK-DIR-PAY-16                                        
CVT000         , LINK-DIR-PAY-17                                        
CVT000         , LINK-DIR-PAY-18                                        
CVT000         , LINK-DIR-PAY-19                                        
CVT000         , LINK-DIR-PAY-20                                        
CVT000         , LINK-USER-ID                                           
CVT000         , LINK-LOCAL-OFFICE                                      
CVT000         , LINK-INITIATED-BY                                      
CVT000         , LINK-CODE-AGENCY-ID                                    
CVT000         , LINK-PYMT-FACILITY-CD                                  
CVT000         , LINK-COMMENT-LEN                                       
CVT000         , LINK-COMMENT-TEXT                                      
CVT000         , LINK-TRAN-COMMENT                                      
CVT000         , LINK-TRAN-COMMENT-LEN                                  
CVT000         , LINK-GL-ACCT-NO                                        
CVT000         , LINK-PANEL-NO                                          
CVT000         .                                                        

SCA006        SET WS-GL-SUB TO 1.
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
CVT000     EXEC SQL                                                     
CVT000       DECLARE C1 CURSOR  FOR                          
CVT000       SELECT                                                     
CVT000        :S-RETURN-CODE               AS    RETURN_CODE            
CVT000       ,LTRIM(RTRIM(:S-ERROR-MESSAGE))      AS    ERROR_MESSAGE          
CVT000       ,LTRIM(RTRIM(:S-CANCELDNP-FLAG))     AS    CANCELDNP_FLAG         
CVT000       ,LTRIM(RTRIM(:S-PREMISE-NO))         AS    PREMISE_NO             
CVT000       ,LTRIM(RTRIM(:S-CUSTOMER-NO))        AS    CUSTOMER_NO            
CVT000       ,LTRIM(RTRIM(:S-RECONNECT-IND))      AS    RECONNECT_IND          
CVT000       ,LTRIM(RTRIM(:S-CANCELNOT-FLAG))     AS    CANCELNOT_FLAG         
CVT000          FROM CIS.SYSDUMMY1                                   
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :S-RETURN-CODE               AS    RETURN_CODE                    
MFA-TR*      ,STRIP(:S-ERROR-MESSAGE)      AS    ERROR_MESSAGE                  
MFA-TR*      ,STRIP(:S-CANCELDNP-FLAG)     AS    CANCELDNP_FLAG                 
MFA-TR*      ,STRIP(:S-PREMISE-NO)         AS    PREMISE_NO                     
MFA-TR*      ,STRIP(:S-CUSTOMER-NO)        AS    CUSTOMER_NO                    
MFA-TR*      ,STRIP(:S-RECONNECT-IND)      AS    RECONNECT_IND                  
MFA-TR*      ,STRIP(:S-CANCELNOT-FLAG)     AS    CANCELNOT_FLAG                 
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
CVT000     MOVE LINK-UPDATE-TYPE          TO PARM-UPDATE-TYPE         . 
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
CVT000     MOVE LINK-FACILITY-CODE        TO PARM-FACILITY-CODE       . 
CVT000     MOVE LINK-PAYMENT-TYPE         TO PARM-PAYMENT-TYPE        . 
CVT000     MOVE LINK-AMT-CHECK            TO PARM-AMT-CHECK           . 
CVT000     MOVE LINK-AMT-MONEY-ORDER      TO PARM-AMT-MONEY-ORDER     . 
CVT000     MOVE LINK-AMT-LIHEAP           TO PARM-AMT-LIHEAP          . 
CVT000     MOVE LINK-CHRG-CARD-TYPE       TO PARM-CHRG-CARD-TYPE      . 
CVT000     MOVE LINK-AMT-CHRG-CARD        TO PARM-AMT-CHRG-CARD       . 
CVT000     MOVE LINK-AMT-CASH             TO PARM-AMT-CASH            . 
CVT000     MOVE LINK-NO-ROWS              TO PARM-NO-ROWS             . 
CVT000     MOVE LINK-DIR-PAY-1            TO PARM-DIR-PAY-1           . 
CVT000     MOVE LINK-DIR-PAY-2            TO PARM-DIR-PAY-2           . 
CVT000     MOVE LINK-DIR-PAY-3            TO PARM-DIR-PAY-3           . 
CVT000     MOVE LINK-DIR-PAY-4            TO PARM-DIR-PAY-4           . 
CVT000     MOVE LINK-DIR-PAY-5            TO PARM-DIR-PAY-5           . 
CVT000     MOVE LINK-DIR-PAY-6            TO PARM-DIR-PAY-6           . 
CVT000     MOVE LINK-DIR-PAY-7            TO PARM-DIR-PAY-7           . 
CVT000     MOVE LINK-DIR-PAY-8            TO PARM-DIR-PAY-8           . 
CVT000     MOVE LINK-DIR-PAY-9            TO PARM-DIR-PAY-9           . 
CVT000     MOVE LINK-DIR-PAY-10           TO PARM-DIR-PAY-10          . 
CVT000     MOVE LINK-DIR-PAY-11           TO PARM-DIR-PAY-11          . 
CVT000     MOVE LINK-DIR-PAY-12           TO PARM-DIR-PAY-12          . 
CVT000     MOVE LINK-DIR-PAY-13           TO PARM-DIR-PAY-13          . 
CVT000     MOVE LINK-DIR-PAY-14           TO PARM-DIR-PAY-14          . 
CVT000     MOVE LINK-DIR-PAY-15           TO PARM-DIR-PAY-15          . 
CVT000     MOVE LINK-DIR-PAY-16           TO PARM-DIR-PAY-16          . 
CVT000     MOVE LINK-DIR-PAY-17           TO PARM-DIR-PAY-17          . 
CVT000     MOVE LINK-DIR-PAY-18           TO PARM-DIR-PAY-18          . 
CVT000     MOVE LINK-DIR-PAY-19           TO PARM-DIR-PAY-19          . 
CVT000     MOVE LINK-DIR-PAY-20           TO PARM-DIR-PAY-20          . 
CVT000     MOVE LINK-USER-ID              TO PARM-USER-ID             . 
CVT000     MOVE LINK-LOCAL-OFFICE         TO PARM-LOCAL-OFFICE        . 
CVT000     MOVE LINK-INITIATED-BY         TO PARM-INITIATED-BY        . 
CVT000     MOVE LINK-CODE-AGENCY-ID       TO PARM-CODE-AGENCY-ID      . 
CVT000     MOVE LINK-PYMT-FACILITY-CD     TO PARM-PYMT-FACILITY-CD    . 
CVT000     MOVE LINK-COMMENT-LEN          TO PARM-COMMENT-LEN         . 
CVT000     MOVE LINK-COMMENT-TEXT         TO PARM-COMMENT-TEXT        . 
CVT000     MOVE LINK-TRAN-COMMENT         TO PARM-TRAN-COMMENT        . 
CVT000     MOVE LINK-TRAN-COMMENT-LEN     TO PARM-TRAN-COMMENT-LEN    . 
CVT000     MOVE LINK-GL-ACCT-NO           TO PARM-GL-ACCT-NO          . 
CVT000     MOVE LINK-PANEL-NO             TO PARM-PANEL-NO            . 
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
      *                                                                         
P00849     MOVE 'PANEL378'              TO PARM-PANEL-NO                
           MOVE PARM-ACCOUNT-NO         TO LI-ACCOUNT-NO .              
           MOVE WS-AMOUNT-LIHEAP-COMP3  TO LI-VOUCHER-AMT .             
           MOVE PARM-INITIATED-BY       TO LI-INITIATED-BY .            
           MOVE PARM-CODE-AGENCY-ID     TO LI-CODE-AGENCY-ID .          
           MOVE PARM-PYMT-FACILITY-CD   TO LI-PYMT-FACILITY-CD .        
           MOVE PARM-COMMENT-LEN        TO WS-COMMENT-LEN.              
           MOVE PARM-COMMENT-TEXT       TO WS-COMMENT-TEXT.             
           MOVE WS-COMMENT-LEN          TO WS-COMMENT-LEN-NUM.          
                                                                        
T5279      MOVE PARM-TRAN-COMMENT-LEN   TO WS-COMMENT-LEN.              
T5279      MOVE WS-COMMENT-LEN          TO WS-TRAN-COMMENT-LEN-NUM.     
T5279      MOVE PARM-TRAN-COMMENT       TO WS-PAR-AR-TRAN-COMMENT-TEXT. 
T5279      MOVE WS-TRAN-COMMENT-LEN-NUM TO WS-PAR-AR-TRAN-COMMENT-LEN.  
                                                                        
           MOVE PARM-PAYMENT-TYPE       TO WS-HOLD-CURRENCY-TYPE.       
                                                                        
           MOVE WS-COMMENT-TEXT         TO LI-COMMENT-TEXT.             
           MOVE WS-COMMENT-LEN-NUM      TO LI-COMMENT-LEN.              
           MOVE PARM-UPDATE-TYPE        TO WS-UPDATE-TYPE .             
           MOVE PARM-GL-ACCT-NO         TO WS-GL-ACCT-NO .              
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     CALLS 2200-PROCESS                                         *        
      *     CALLED FROM 0000-MAINLINE                                 *         
      *                                                                *        
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *        
      *      AND SENDS THEM BACK                                       *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
                                                                        
      ***********                                                               
      * DO NOT PROCEED IF SYSTEM IS LOCKED                                      
      ***********                                                               
           PERFORM 7999-SELECT-AL THRU 7999-SELECT-AL-EXIT              
           IF AL-AR-LOCKOUT-IND = 'Y'                                   
              MOVE 5000 TO RS-RETURN-CODE                               
REARCH        PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
              PERFORM 8100-SEND-RESULT  THRU 8100-EXIT                  
T11987        PERFORM 9999-END-PROGRAM  THRU 9999-EXIT                  
T11987     END-IF.                                                      
                                                                        
           PERFORM 2200-PROCESS THRU 2200-EXIT.                         
A36248*                                                                         
A36248*                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
REARCH*                                                                         
REARCH*****************************************************************         
REARCH* 2000A-MOVE-RESULT.                                            *         
REARCH*****************************************************************         
REARCH*                                                                         
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE  RS-RETURN-CODE         TO S-RETURN-CODE.               
REARCH     MOVE  RS-ERROR-MESSAGE       TO S-ERROR-MESSAGE.             
REARCH     MOVE  RS-CANCELDNP-FLAG      TO S-CANCELDNP-FLAG.            
REARCH     MOVE  RS-PREMISE-NO          TO S-PREMISE-NO.                
REARCH     MOVE  RS-CUSTOMER-NO         TO S-CUSTOMER-NO.               
REARCH     MOVE  RS-RECONNECT-IND       TO S-RECONNECT-IND.             
REARCH     MOVE  RS-CANCELNOT-FLAG      TO S-CANCELNOT-FLAG.            
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-PROCESS-BEGIN                                             *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
                                                                        
       2200-PROCESS.                                                    
           MOVE '2200'              TO ACTIVE-PARAGRAPH.                
                                                                        
           MOVE PARM-ACCOUNT-NO     TO WS-ACCOUNT-NO.                   
           MOVE WS-ACCOUNT-NO-NUM   TO WS-ACCOUNT-NO-COMP3.             
           MOVE WS-ACCOUNT-NO-COMP3 TO AT-ACCOUNT-NO.                   
           PERFORM 7000-SELECT-AT-PR-CU THRU 7000-EXIT.                 
                                                                        
           MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT.         
                                                                        
           IF CU-CODE-CUST-STATUS EQUAL WS-S                            
              MOVE WS-Y TO WS-CHRG-OFF-ACCT                             
PCR360     END-IF.                                                      
                                                                        
      *******                                                           10740016
      * SET RECONNECT FLAG                                                      
      *******                                                           10740016
           MOVE AT-ACCOUNT-NO TO DL-ACCOUNT-NO.                         
           PERFORM 7170-SELECT-RECONNECT THRU 7170-EXIT.                
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE WS-Y       TO WS-PAR-RECONNECT-EXIST                 
PCR360     END-IF.                                                      
                                                                        
      *******                                                           10740016
      * MOVE NUMERIC FIELD AMONG WORKING STORAGE FIELDS BECAUSE THEY            
      * WERE PASSED AS CHARACTER, NOT NUMERIC.                                  
      *******                                                           10740016
           MOVE PARM-AMT-CHECK        TO WS-AMOUNT-CHECK.               
           MOVE WS-AMOUNT-CHECK-NUM   TO WS-AMOUNT-CHECK-COMP3.         
           MOVE WS-AMOUNT-CHECK-COMP3 TO WS-AMT-CHECK.                  
                                                                        
           MOVE PARM-AMT-MONEY-ORDER   TO WS-AMOUNT-MORDER.             
           MOVE WS-AMOUNT-MORDER-NUM   TO WS-AMOUNT-MORDER-COMP3.       
           MOVE WS-AMOUNT-MORDER-COMP3 TO WS-AMT-MONEY-ORDER.           
                                                                        
           MOVE PARM-AMT-LIHEAP        TO WS-AMOUNT-LIHEAP.             
           MOVE WS-AMOUNT-LIHEAP-NUM   TO WS-AMOUNT-LIHEAP-COMP3.       
           MOVE WS-AMOUNT-LIHEAP-COMP3 TO WS-AMT-LIHEAP.                
                                                                        
           MOVE PARM-AMT-CASH        TO WS-AMOUNT-CASH.                 
           MOVE WS-AMOUNT-CASH-NUM   TO WS-AMOUNT-CASH-COMP3.           
           MOVE WS-AMOUNT-CASH-COMP3 TO WS-AMT-CASH.                    
                                                                        
           MOVE PARM-AMT-CHRG-CARD     TO WS-AMT-CHRG-CARD.             
           MOVE WS-AMT-CHRG-CARD-NUM   TO WS-AMT-CHRG-CARD-COMP3.       
           MOVE WS-AMT-CHRG-CARD-COMP3 TO WS-AMT-CREDIT-CARD.           
                                                                        
           ADD WS-AMOUNT-CHECK-COMP3                                    
               WS-AMOUNT-MORDER-COMP3                                   
               WS-AMOUNT-LIHEAP-COMP3                                   
               WS-AMOUNT-CASH-COMP3                                     
               WS-AMT-CHRG-CARD-COMP3 GIVING WS-PAYMENT-AMOUNT          
                                             WS-PAYMENT-AMOUNT-TOTAL.   
                                                                        
T19540     MOVE AT-ACCOUNT-NO TO DL-ACCOUNT-NO.                         
T19540     PERFORM 7170-SELECT-RECONNECT THRU 7170-EXIT.                
T19540     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T19540        MOVE WS-Y       TO WS-PAR-RECONNECT-EXIST                 
T19540        IF WS-PAYMENT-AMOUNT >= DL-AMT-TOT-RECONNECT -            
T19540                                DL-RECNCT-COLLECT-AMT             
T19540           MOVE 'Y'                 TO RS-RECONNECT-IND           
T19540        ELSE                                                      
T19540           MOVE 'N'                 TO RS-RECONNECT-IND           
T19540        END-IF                                                    
T19540     ELSE                                                         
T19540        MOVE 'N'                    TO RS-RECONNECT-IND           
T19540     END-IF.                                                      
T19540                                                                  
                                                                        
      *******                                                           10740016
      * GET G/L ACCOUNT NUMBER                                                  
      *******                                                           10760016
           PERFORM 2205-LOAD-GL-NUMBERS THRU 2205-EXIT.                 
                                                                        
      ******************                                                PCS05720
      * DEBIT CORRECT G/L ACCT NUMBER                                           
      ******************                                                PCS05720
PCR360     COMPUTE WS-GL-ACCT-DEBIT = WS-GL-ACCT-NO-NUM / 10000.        
PCR360     MOVE WS-GL-ACCT-DEBIT        TO GO-GL-ACCT-NO.               
PCR360     PERFORM 7460-SELECT-GL-NAME  THRU 7460-EXIT.                 
PCR360     MOVE GO-GL-ACCT-NO           TO WS-PAR-GEN-LEDG-DB.          
                                                                        
      ******************                                                PCS05720
      * LOAD DIRECTED PAYMENT OR PAYMENT PRIORITY TABLE                         
      * HOWEVER, IF RECONNECT ROW EXISTS, PAYMENT PRIORITY TABLE                
      * WILL BE USED TO APPLY PAYMENT EVEN WHEN DIRECTED IS SPECIFIED           
      ******************                                                PCS05720
           MOVE PARM-UPDATE-TYPE TO WS-PAR-UPDATE-TYPE.                 
           IF PARM-UPDATE-TYPE EQUAL WS-D                               
              IF WS-PAR-RECONNECT-EXIST EQUAL WS-Y                      
                 MOVE WS-NO  TO WS-IS-THIS-DIRECTED-PYMT                
                 PERFORM 2210-LOAD-PYMT-PRIORITY THRU 2210-EXIT         
              ELSE                                                      
                 MOVE WS-YES TO WS-IS-THIS-DIRECTED-PYMT                
                 PERFORM 2220-LOAD-DIR-PYMT-TABLE THRU 2220-EXIT        
PCR360        END-IF                                                    
           ELSE                                                         
              MOVE WS-NO  TO WS-IS-THIS-DIRECTED-PYMT                   
PCR360        PERFORM 2210-LOAD-PYMT-PRIORITY THRU 2210-EXIT            
PCR360     END-IF.                                                      
T11472* MOVED THE CPD00068 CALL AFTER PAYMENT IS MADE.                          
                                                                        
           MOVE WS-NO-ERROR        TO RS-ERROR-MESSAGE                  
                                      WS-PAR-MESSAGE-NO.                
           PERFORM 5000-UPDATE     THRU 5000-EXIT.                      
                                                                        
           MOVE WS-PAR-MESSAGE-NO  TO RS-ERROR-MESSAGE.                 
                                                                        
           PERFORM 2255-CREATE-VOUCHER-ENTRY THRU 2255-EXIT.            
                                                                        
T11472* THE FOLLOWING CODE HAS BEEN MOVED FROM BEFORE 5000 TO AFTER 5000        
                                                                        
P00849*************                                                             
P00849*    DNP/RECONNECT PROCESS UPDATED FOR MOD.                               
P00849*************                                                             
ACT285     PERFORM 2950-PROCESS-DNP-RECONNECT THRU 2950-EXIT            
ACT285     MOVE WS-CNCL-DNP-ACTN-FL TO RS-CANCELDNP-FLAG                
ACT285     MOVE 'N'                 TO RS-CANCELNOT-FLAG                
PCR360     MOVE AT-PREMISE-NO      TO WS-PREMISE-NO-NUM.                
PCR360     MOVE WS-PREMISE-NO-NUM  TO RS-PREMISE-NO.                    
PCR360     MOVE AT-CUSTOMER-NO     TO WS-CUSTOMER-NO-NUM.               
PCR360     MOVE WS-CUSTOMER-NO-NUM TO RS-CUSTOMER-NO.                   
PCR360*                                                                         
REARCH     PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT.                   
           PERFORM 8100-SEND-RESULT  THRU 8100-EXIT.                    
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
                                                                        
      ******************************************************************        
      * 2255-CREATE-VOUCHER-ENTRY                                     *         
      *                                                                *        
      *     CALLED FROM 2200-BUILD_RESULT                              *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
                                                                        
       2255-CREATE-VOUCHER-ENTRY.                                       
           MOVE '2255'               TO ACTIVE-PARAGRAPH.               
                                                                        
           MOVE AR-TRANS-HIST-SEQ-NO TO LI-VOUCHER-PAY-DT.              
           MOVE WS-AMOUNT-LIHEAP-COMP3  TO LI-VOUCHER-AMT .             
           PERFORM 8130-INSERT-LI-ROW THRU 8130-EXIT.                   
       2255-EXIT.                                                       
           EXIT.                                                        
      **************************************************                        
      * LOAD ALL G/L NUMBER, INCLUDEING CHARGED OFF.   *                        
      **************************************************                        
       2205-LOAD-GL-NUMBERS.                                            
T24436     PERFORM 9350-LINK-SCSCO061     THRU 9350-EXIT.               
                                                                        
T24555     PERFORM VARYING WS-VALID-CO-SUB FROM 1 BY 1                  
T24555        UNTIL WS-VALID-CO-SUB > 5 OR                              
MCR310        WS-VALID-CO-NO (WS-VALID-CO-SUB) = '01' OR                
T24555        WS-VALID-CO-NO (WS-VALID-CO-SUB) = WS-GL-99               
MCR310        IF WS-VALID-CO-NO (WS-VALID-CO-SUB) = '01'                
PCR360           MOVE WS-Y TO WS-COMPANY-IN-TABLE                       
PCR360        END-IF                                                    
           END-PERFORM.                                                 
PCR360*                                                                         
       2205-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ********************************************************                  
      * LOAD THE PAYMENT PRIORITY TABLE                      *                  
      * USE PARM-UPDATE-TYPE TO DECIDE WHICH SET TO LOAD:    *                  
      * B FOR BILLED, A FOR ARREARS, AND U FOR UNDIRECTED.   *                  
      * SCHEDULE 1 IS FOR BILLED AND UNDIRECTED DUE TO THE   *                  
      * ORDER PAYMENT IS POSTED.  SCHEDULE 2 IS FOR ARREARS  *                  
      * WHICH PAYS OFF ALL 90 DAY FIRST, THEN 60 DAYS, ETC.  *                  
      ********************************************************                  
       2210-LOAD-PYMT-PRIORITY.                                         
           IF PARM-UPDATE-TYPE EQUAL WS-A                               
              MOVE 2 TO C9-PMT-PRTY-SCHEDULE                            
           ELSE                                                         
PCR360        MOVE 1 TO C9-PMT-PRTY-SCHEDULE                            
PCR360     END-IF.                                                      
                                                                        
           PERFORM 6722B-OPEN-AR-PMT-PRTY  THRU 6722B-EXIT.             
           PERFORM 6722C-FETCH-AR-PMT-PRTY THRU 6722C-EXIT.             
           PERFORM 6722D-LOAD-AR-PMT-PRTY  THRU 6722D-EXIT              
PCR360        VARYING WS-PAR-SUB FROM 1 BY 1                            
PCR360        UNTIL WS-PAR-SUB GREATER THAN 52 OR                       
PCR360        WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.                    
PCR360                                                                  
           PERFORM 6722E-CLOSE-AR-PMT-PRTY THRU 6722E-EXIT.             
PCR360*                                                                         
       2210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2220-LOAD-DIR-PYMT-TABLE.                                        
           IF PARM-DIR-PAY-1 EQUAL SPACES                               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PARM-DIR-PAY-1      TO WS-DIR-PAYMENT-BREAKDOWN      
              MOVE WS-REV-TYPE-NUM     TO WS-DIR-PAY-REC-TYPE (1)       
              MOVE WS-ITEM-ID-NUM      TO WS-DIR-PAY-ITEM-ID (1)        
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-DIR-PAY-AMT (1)            
              MOVE WS-PAY-AHEAD-TYPE   TO WS-DIR-PAY-AHEAD-TYPE (1)     
PCR360        MOVE WS-PAY-CHRG-OFF     TO WS-DIR-PAY-CHRG-OFF (1)       
PCR360     END-IF.                                                      
                                                                        
           IF PARM-DIR-PAY-2 EQUAL SPACES                               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PARM-DIR-PAY-2      TO WS-DIR-PAYMENT-BREAKDOWN      
              MOVE WS-REV-TYPE-NUM     TO WS-DIR-PAY-REC-TYPE (2)       
              MOVE WS-ITEM-ID-NUM      TO WS-DIR-PAY-ITEM-ID (2)        
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-DIR-PAY-AMT (2)            
              MOVE WS-PAY-AHEAD-TYPE   TO WS-DIR-PAY-AHEAD-TYPE (2)     
PCR360        MOVE WS-PAY-CHRG-OFF     TO WS-DIR-PAY-CHRG-OFF (2)       
PCR360     END-IF.                                                      
                                                                        
           IF PARM-DIR-PAY-3 EQUAL SPACES                               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PARM-DIR-PAY-3      TO WS-DIR-PAYMENT-BREAKDOWN      
              MOVE WS-REV-TYPE-NUM     TO WS-DIR-PAY-REC-TYPE (3)       
              MOVE WS-ITEM-ID-NUM      TO WS-DIR-PAY-ITEM-ID (3)        
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-DIR-PAY-AMT (3)            
              MOVE WS-PAY-AHEAD-TYPE   TO WS-DIR-PAY-AHEAD-TYPE (3)     
PCR360        MOVE WS-PAY-CHRG-OFF     TO WS-DIR-PAY-CHRG-OFF (3)       
PCR360     END-IF.                                                      
                                                                        
           IF PARM-DIR-PAY-4 EQUAL SPACES                               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PARM-DIR-PAY-4      TO WS-DIR-PAYMENT-BREAKDOWN      
              MOVE WS-REV-TYPE-NUM     TO WS-DIR-PAY-REC-TYPE (4)       
              MOVE WS-ITEM-ID-NUM      TO WS-DIR-PAY-ITEM-ID (4)        
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-DIR-PAY-AMT (4)            
              MOVE WS-PAY-AHEAD-TYPE   TO WS-DIR-PAY-AHEAD-TYPE (4)     
PCR360        MOVE WS-PAY-CHRG-OFF     TO WS-DIR-PAY-CHRG-OFF (4)       
PCR360     END-IF.                                                      
                                                                        
           IF PARM-DIR-PAY-5 EQUAL SPACES                               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PARM-DIR-PAY-5      TO WS-DIR-PAYMENT-BREAKDOWN      
              MOVE WS-REV-TYPE-NUM     TO WS-DIR-PAY-REC-TYPE (5)       
              MOVE WS-ITEM-ID-NUM      TO WS-DIR-PAY-ITEM-ID (5)        
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-DIR-PAY-AMT (5)            
              MOVE WS-PAY-AHEAD-TYPE   TO WS-DIR-PAY-AHEAD-TYPE (5)     
PCR360        MOVE WS-PAY-CHRG-OFF     TO WS-DIR-PAY-CHRG-OFF (5)       
PCR360     END-IF.                                                      
                                                                        
           IF PARM-DIR-PAY-6 EQUAL SPACES                               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PARM-DIR-PAY-6      TO WS-DIR-PAYMENT-BREAKDOWN      
              MOVE WS-REV-TYPE-NUM     TO WS-DIR-PAY-REC-TYPE (6)       
              MOVE WS-ITEM-ID-NUM      TO WS-DIR-PAY-ITEM-ID (6)        
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-DIR-PAY-AMT (6)            
              MOVE WS-PAY-AHEAD-TYPE   TO WS-DIR-PAY-AHEAD-TYPE (6)     
PCR360        MOVE WS-PAY-CHRG-OFF     TO WS-DIR-PAY-CHRG-OFF (6)       
PCR360     END-IF.                                                      
                                                                        
           IF PARM-DIR-PAY-7 EQUAL SPACES                               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PARM-DIR-PAY-7      TO WS-DIR-PAYMENT-BREAKDOWN      
              MOVE WS-REV-TYPE-NUM     TO WS-DIR-PAY-REC-TYPE (7)       
              MOVE WS-ITEM-ID-NUM      TO WS-DIR-PAY-ITEM-ID (7)        
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-DIR-PAY-AMT (7)            
              MOVE WS-PAY-AHEAD-TYPE   TO WS-DIR-PAY-AHEAD-TYPE (7)     
PCR360        MOVE WS-PAY-CHRG-OFF     TO WS-DIR-PAY-CHRG-OFF (7)       
PCR360     END-IF.                                                      
                                                                        
           IF PARM-DIR-PAY-8 EQUAL SPACES                               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PARM-DIR-PAY-8      TO WS-DIR-PAYMENT-BREAKDOWN      
              MOVE WS-REV-TYPE-NUM     TO WS-DIR-PAY-REC-TYPE (8)       
              MOVE WS-ITEM-ID-NUM      TO WS-DIR-PAY-ITEM-ID (8)        
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-DIR-PAY-AMT (8)            
              MOVE WS-PAY-AHEAD-TYPE   TO WS-DIR-PAY-AHEAD-TYPE (8)     
PCR360        MOVE WS-PAY-CHRG-OFF     TO WS-DIR-PAY-CHRG-OFF (8)       
PCR360     END-IF.                                                      
                                                                        
           IF PARM-DIR-PAY-9 EQUAL SPACES                               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PARM-DIR-PAY-9      TO WS-DIR-PAYMENT-BREAKDOWN      
              MOVE WS-REV-TYPE-NUM     TO WS-DIR-PAY-REC-TYPE (9)       
              MOVE WS-ITEM-ID-NUM      TO WS-DIR-PAY-ITEM-ID (9)        
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-DIR-PAY-AMT (9)            
              MOVE WS-PAY-AHEAD-TYPE   TO WS-DIR-PAY-AHEAD-TYPE (9)     
PCR360        MOVE WS-PAY-CHRG-OFF     TO WS-DIR-PAY-CHRG-OFF (9)       
PCR360     END-IF.                                                      
                                                                        
           IF PARM-DIR-PAY-10 EQUAL SPACES                              
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PARM-DIR-PAY-10     TO WS-DIR-PAYMENT-BREAKDOWN      
              MOVE WS-REV-TYPE-NUM     TO WS-DIR-PAY-REC-TYPE (10)      
              MOVE WS-ITEM-ID-NUM      TO WS-DIR-PAY-ITEM-ID (10)       
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-DIR-PAY-AMT (10)           
              MOVE WS-PAY-AHEAD-TYPE   TO WS-DIR-PAY-AHEAD-TYPE (10)    
PCR360        MOVE WS-PAY-CHRG-OFF     TO WS-DIR-PAY-CHRG-OFF (10)      
PCR360     END-IF.                                                      
                                                                        
           IF PARM-DIR-PAY-11 EQUAL SPACES                              
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PARM-DIR-PAY-11     TO WS-DIR-PAYMENT-BREAKDOWN      
              MOVE WS-REV-TYPE-NUM     TO WS-DIR-PAY-REC-TYPE (11)      
              MOVE WS-ITEM-ID-NUM      TO WS-DIR-PAY-ITEM-ID (11)       
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-DIR-PAY-AMT (11)           
              MOVE WS-PAY-AHEAD-TYPE   TO WS-DIR-PAY-AHEAD-TYPE (11)    
PCR360        MOVE WS-PAY-CHRG-OFF     TO WS-DIR-PAY-CHRG-OFF (11)      
PCR360     END-IF.                                                      
                                                                        
           IF PARM-DIR-PAY-12 EQUAL SPACES                              
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PARM-DIR-PAY-12     TO WS-DIR-PAYMENT-BREAKDOWN      
              MOVE WS-REV-TYPE-NUM     TO WS-DIR-PAY-REC-TYPE (12)      
              MOVE WS-ITEM-ID-NUM      TO WS-DIR-PAY-ITEM-ID (12)       
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-DIR-PAY-AMT (12)           
              MOVE WS-PAY-AHEAD-TYPE   TO WS-DIR-PAY-AHEAD-TYPE (12)    
PCR360        MOVE WS-PAY-CHRG-OFF     TO WS-DIR-PAY-CHRG-OFF (12)      
PCR360     END-IF.                                                      
                                                                        
           IF PARM-DIR-PAY-13 EQUAL SPACES                              
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PARM-DIR-PAY-13     TO WS-DIR-PAYMENT-BREAKDOWN      
              MOVE WS-REV-TYPE-NUM     TO WS-DIR-PAY-REC-TYPE (13)      
              MOVE WS-ITEM-ID-NUM      TO WS-DIR-PAY-ITEM-ID (13)       
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-DIR-PAY-AMT (13)           
              MOVE WS-PAY-AHEAD-TYPE   TO WS-DIR-PAY-AHEAD-TYPE (13)    
PCR360        MOVE WS-PAY-CHRG-OFF     TO WS-DIR-PAY-CHRG-OFF (13)      
PCR360     END-IF.                                                      
                                                                        
           IF PARM-DIR-PAY-14 EQUAL SPACES                              
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PARM-DIR-PAY-14     TO WS-DIR-PAYMENT-BREAKDOWN      
              MOVE WS-REV-TYPE-NUM     TO WS-DIR-PAY-REC-TYPE (14)      
              MOVE WS-ITEM-ID-NUM      TO WS-DIR-PAY-ITEM-ID (14)       
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-DIR-PAY-AMT (14)           
              MOVE WS-PAY-AHEAD-TYPE   TO WS-DIR-PAY-AHEAD-TYPE (14)    
PCR360        MOVE WS-PAY-CHRG-OFF     TO WS-DIR-PAY-CHRG-OFF (14)      
PCR360     END-IF.                                                      
                                                                        
           IF PARM-DIR-PAY-15 EQUAL SPACES                              
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PARM-DIR-PAY-15     TO WS-DIR-PAYMENT-BREAKDOWN      
              MOVE WS-REV-TYPE-NUM     TO WS-DIR-PAY-REC-TYPE (15)      
              MOVE WS-ITEM-ID-NUM      TO WS-DIR-PAY-ITEM-ID (15)       
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-DIR-PAY-AMT (15)           
              MOVE WS-PAY-AHEAD-TYPE   TO WS-DIR-PAY-AHEAD-TYPE (15)    
PCR360        MOVE WS-PAY-CHRG-OFF     TO WS-DIR-PAY-CHRG-OFF (15)      
PCR360     END-IF.                                                      
                                                                        
           IF PARM-DIR-PAY-16 EQUAL SPACES                              
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PARM-DIR-PAY-16     TO WS-DIR-PAYMENT-BREAKDOWN      
              MOVE WS-REV-TYPE-NUM     TO WS-DIR-PAY-REC-TYPE (16)      
              MOVE WS-ITEM-ID-NUM      TO WS-DIR-PAY-ITEM-ID (16)       
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-DIR-PAY-AMT (16)           
              MOVE WS-PAY-AHEAD-TYPE   TO WS-DIR-PAY-AHEAD-TYPE (16)    
PCR360        MOVE WS-PAY-CHRG-OFF     TO WS-DIR-PAY-CHRG-OFF (16)      
PCR360     END-IF.                                                      
                                                                        
           IF PARM-DIR-PAY-17 EQUAL SPACES                              
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PARM-DIR-PAY-17     TO WS-DIR-PAYMENT-BREAKDOWN      
              MOVE WS-REV-TYPE-NUM     TO WS-DIR-PAY-REC-TYPE (17)      
              MOVE WS-ITEM-ID-NUM      TO WS-DIR-PAY-ITEM-ID (17)       
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-DIR-PAY-AMT (17)           
              MOVE WS-PAY-AHEAD-TYPE   TO WS-DIR-PAY-AHEAD-TYPE (17)    
PCR360        MOVE WS-PAY-CHRG-OFF     TO WS-DIR-PAY-CHRG-OFF (17)      
PCR360     END-IF.                                                      
                                                                        
           IF PARM-DIR-PAY-18 EQUAL SPACES                              
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PARM-DIR-PAY-18     TO WS-DIR-PAYMENT-BREAKDOWN      
              MOVE WS-REV-TYPE-NUM     TO WS-DIR-PAY-REC-TYPE (18)      
              MOVE WS-ITEM-ID-NUM      TO WS-DIR-PAY-ITEM-ID (18)       
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-DIR-PAY-AMT (18)           
              MOVE WS-PAY-AHEAD-TYPE   TO WS-DIR-PAY-AHEAD-TYPE (18)    
PCR360        MOVE WS-PAY-CHRG-OFF     TO WS-DIR-PAY-CHRG-OFF (18)      
PCR360     END-IF.                                                      
                                                                        
           IF PARM-DIR-PAY-19 EQUAL SPACES                              
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PARM-DIR-PAY-19     TO WS-DIR-PAYMENT-BREAKDOWN      
              MOVE WS-REV-TYPE-NUM     TO WS-DIR-PAY-REC-TYPE (19)      
              MOVE WS-ITEM-ID-NUM      TO WS-DIR-PAY-ITEM-ID (19)       
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-DIR-PAY-AMT (19)           
              MOVE WS-PAY-AHEAD-TYPE   TO WS-DIR-PAY-AHEAD-TYPE (19)    
PCR360        MOVE WS-PAY-CHRG-OFF     TO WS-DIR-PAY-CHRG-OFF (19)      
PCR360     END-IF.                                                      
                                                                        
           IF PARM-DIR-PAY-20 EQUAL SPACES                              
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PARM-DIR-PAY-20     TO WS-DIR-PAYMENT-BREAKDOWN      
              MOVE WS-REV-TYPE-NUM     TO WS-DIR-PAY-REC-TYPE (20)      
              MOVE WS-ITEM-ID-NUM      TO WS-DIR-PAY-ITEM-ID (20)       
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-DIR-PAY-AMT (20)           
              MOVE WS-PAY-AHEAD-TYPE   TO WS-DIR-PAY-AHEAD-TYPE (20)    
PCR360        MOVE WS-PAY-CHRG-OFF     TO WS-DIR-PAY-CHRG-OFF (20)      
PCR360     END-IF.                                                      
PCR360*                                                                         
       2220-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00849*--------------------------------------------------------------*  00182300
ACT285* CALLS SUB PROGRAMS MCS03414 TO HANDLE DNP/RECONNECT REAL TIME*  00182400
P00849*--------------------------------------------------------------*  00182500
P00849 2950-PROCESS-DNP-RECONNECT.                                      
P00849                                                                  
ACT285* Populate WS variable to call CPD03414                                   
P00849     MOVE AT-ACCOUNT-NO               TO WS-ACCOUNT-NO-NUM        
ACT285     MOVE 'P'                         TO WS-UPDATE-ACTION-FL      
P00849     MOVE 'X'                         TO WS-FACILITY-CODE         
P00849     MOVE 0                           TO WS-DNP-RET-CODE          
ACT285     MOVE 'O'                         TO WS-CALL-TYPE             
ACT285     MOVE 'Y'                         TO WS-CPD68-REQUIRED        
P00948     MOVE PROGRAM-NAME                TO WS-PROGRAM-NAME          
P00948     MOVE 'N'                         TO WS-CNCL-DNP-EMAIL-REQ-FL 
ACT285     MOVE SPACES                      TO WS-APPL-PROGRAM-ID       
P00849                                         ABEND-FILE               
P00849                                                                  
ACT285     PERFORM 9800-CALL-MCS03414                                   
P00849        THRU 9800-EXIT                                            
P00849                                                                  
ACT285     IF WS-DNP-RET-CODE > 0                                       
P00849        MOVE WS-DNP-RET-CODE          TO RS-RETURN-CODE           
P00849     END-IF                                                       
P00849     .                                                            
P00849 2950-EXIT.                                                       
P00849     EXIT.                                                        
P00849*                                                                 00184000
PCR360******************************************************************        
PCR360* 3300-CALCULATION (CPD00068 CALL)                               *        
PCR360******************************************************************        
PCR360                                                                  
                                                                        
       5000-UPDATE.                                                     
           MOVE '5000'        TO ACTIVE-PARAGRAPH.                      
                                                                        
           MOVE AT-COMPANY-NO TO WS-100-COMPANY-NO.                     
      *******************************************************           04991280
      * THESE FIELDS WERE POPULATED BY CALLING CPD00020     *           04991389
      * (PARAGRAPH 5970) TO ACCESS APPLICATION TABLE 50.    *           04991499
      *******************************************************           04991580
           MOVE 9             TO WS-TRAN-OPER-LEVEL.                    
           MOVE 1             TO WS-TRAN-OCAP-FIELD.                    
           MOVE 1             TO WS-TRAN-OCAP-VALUE.                    
           MOVE WS-C          TO WS-TRAN-JRNL-TYPE.                     
           MOVE WS-N          TO WS-TRAN-HOLD-EXEMPT-FLAG.              
                                                                        
      *******************************************************           04992280
      * THESE FIELDS WERE POPULATED BY CALLING CPD00021     *           04992389
      * (PARAGRAPH 5980) TO VERIFY USER-ID.                 *           04992489
      *******************************************************           04992580
           MOVE PARM-USER-ID       TO WS-JRNL-OL-TEMP-ID.               
           MOVE WS-JRNL-CK-OPER-ID TO WS-JRNL-OPERATION-RQST.           
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT.             
           MOVE WS-JRNL-OL-OPR-LOC TO WS-TERM-LOC.                      
                                                                        
      *******************************************************           04993180
NEWNEW* THESE FIELDS WERE POPULATED BY CALLING CPD00022     *           04993289
      * (PARAGRAPH 5990) TO ACCESS CASH DRAWER CONTROL.     *           04993389
      *******************************************************           04993480
      ********************************************                              
      ****** THESE ARE THE CHANGES REQUIRED FOR FIELD CASH SYSTEM *             
      ********************************************************                  
           MOVE '01'                   TO   WS-JRNL-OL-COMPANY          
                                            WS-PAR-COMPANY-NO .         
           MOVE '998'                  TO   WS-JRNL-OL-LOC-OFF          
                                            WS-PAR-LOCAL-OFFICE.        
           MOVE '998'                  TO   WS-JRNL-OL-REPORT-NO        
                                            WS-PAR-REPORT-NO .          
           MOVE WS-CURRENT-DATE        TO   WS-JRNL-OL-REPORT-DT        
                                            WS-PAR-REPORT-DATE.         
           MOVE 9999                   TO   WS-JRNL-OL-CASH-DRWR        
                                            WS-PAR-CASH-DRAWER .        
      ****************                                                          
      *******    END CHANGES                                                    
      ****************                                                          
           MOVE WS-TERM-LOC                TO WS-JRNL-OL-TERM-LOC       
                                              WS-JRNL-OL-CASH-LOC       
                                              WS-JRNL-OL-OPR-LOC.       
           MOVE WS-JRNL-VALIDATE-OPER TO WS-JRNL-OPERATION-RQST.        
           MOVE WS-C                  TO WS-JRNL-SOURCE-CODE.           
           IF CASH-TRANSACTION                                          
              MOVE WS-JRNL-CASH-UPDATE     TO WS-JRNL-OL-AUTH-TYPE      
           ELSE                                                         
PCR360        MOVE WS-JRNL-NON-CASH-UPDATE TO WS-JRNL-OL-AUTH-TYPE      
PCR360     END-IF.                                                      
           PERFORM 6400-ONLINE-JRNL-ROUTINE  THRU 6400-EXIT.            
                                                                        
           MOVE WS-A            TO WS-100-JRNL-SORT-ID.                 
           MOVE AT-ACCOUNT-NO   TO WS-100-ACCT-NO.                      
           MOVE AT-CUSTOMER-NO  TO WS-100-CUSTOMER-NO.                  
           MOVE AT-PREMISE-NO   TO WS-100-PREMISE-NO.                   
A03578     MOVE '2300'          TO WS-PAR-EIBTRNID.                     
           ADD 1                TO WS-100-JRNL-TRAN-APPL-NO.            
           MOVE WS-CURRENT-DATE TO WS-100-DATE-LAST-ACTION              
                                   AT-DATE-LAST-ACTION.                 
           MOVE WS-C            TO WS-100-CODE-ENTRY-SOURCE.            
           MOVE AT-LOCAL-OFFICE TO WS-100-LOCAL-OFFICE-CD.              
      ******   CHANGED FOR FIELD CASH                                           
                                                                        
           MOVE WS-TERM-LOC             TO WS-PAR-ACCESS-LOC.           
           MOVE PARM-USER-ID            TO WS-PAR-OPERATOR-ID.          
           MOVE PF-RESP-AREA-ID         TO WS-PAR-RESP-AREA.            
           MOVE 'PANEL378'              TO WS-PAR-APPL-PROG-ID.         
           MOVE PARM-FACILITY-CODE      TO WS-PAR-PYMT-FACILITY-CD.     
                                                                        
      *************************************************************             
      * MODIFICATION MADE TO MOVE P TO WS-PAR-CODE-TRAN-TYPE      *             
      * RATHER THAN DEFAULT TO 'P' IN CWS00017.  IT IS NECESSARY  *             
      * TO POPULATE WS-PAR-CODE-TRAN-TYPE OUTSIDE COPYBOOK        *             
      * BECAUSE OTHER PROGRAMS ARE CALLING CPD00010 EVEN THOUGH   *             
      * THEY ARE NOT PAYAMENT POSTING PROGRAM.   CIF - 05/25/95   *             
      *************************************************************             
IF0595     MOVE WS-PAR-P                TO WS-PAR-CODE-TRAN-TYPE.       
                                                                        
           IF DIRECTED-PYMT                                             
              PERFORM 5010-PAYMENT-LOOP THRU 5010-EXIT                  
                 VARYING WS-SUB FROM 1 BY 1                             
                     UNTIL WS-SUB GREATER THAN PARM-NO-ROWS             
           ELSE                                                         
              PERFORM 6700-APPLY-PAYMENT THRU 6700-EXIT                 
              PERFORM 5001-CHECK-PAYMENT-RETURN THRU 5001-EXIT          
              MOVE WS-JRNL-CNTRL-ONLY TO WS-JRNL-OPERATION-RQST         
              PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT           
              IF WS-JRNL-RTRN-CODE EQUAL SPACES                         
                 NEXT SENTENCE                                          
              ELSE                                                      
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE '5000'               TO ACTIVE-PARAGRAPH         
                  MOVE 'USERABEN'           TO ABEND-FUNCTION           
                  MOVE WS-YES               TO WS-USER-FORCE-ABEND      
                  MOVE SPACES               TO DSNTIAR-MESSAGE-1        
PCR360            PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT         
PCR360         END-IF                                                   
PCR360     END-IF.                                                      
PCR360*                                                                         
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5001-CHECK-PAYMENT-RETURN.                                       
           IF PYMT-WAS-SUCCESSFUL                                       
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '5001'                  TO ACTIVE-PARAGRAPH          
              MOVE 'USERABEN'              TO ABEND-FUNCTION            
              MOVE WS-YES                  TO WS-USER-FORCE-ABEND       
              MOVE 'PAYMENT ABEND'         TO DSNTIAR-MESSAGE-1         
PCR360        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
PCR360     END-IF.                                                      
       5001-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5010-PAYMENT-LOOP.                                               
           MOVE '5010' TO ACTIVE-PARAGRAPH.                             
                                                                        
           MOVE WS-DIR-PAY-AMT (WS-SUB)        TO WS-PAYMENT-AMOUNT.    
           MOVE WS-DIR-PAY-REC-TYPE (WS-SUB)   TO WS-PAR-TYPE.          
           MOVE WS-DIR-PAY-ITEM-ID (WS-SUB)    TO WS-PAR-TYPE-NO.       
           MOVE WS-DIR-PAY-AHEAD-TYPE (WS-SUB) TO WS-PAR-PAY-AHEAD.     
           MOVE WS-DIR-PAY-CHRG-OFF (WS-SUB)   TO WS-PAR-PAY-CHRG-OFF.  
           PERFORM 6700-APPLY-PAYMENT THRU 6700-EXIT.                   
                                                                        
           IF FIRST-PAYMENT                                             
              MOVE WS-NO                   TO WS-FIRST-PAYMENT          
              PERFORM 5001-CHECK-PAYMENT-RETURN THRU 5001-EXIT          
           ELSE                                                         
              IF PYMT-WAS-SUCCESSFUL                                    
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE PROGRAM-NAME            TO ABEND-PROGRAM          
                 MOVE '5010'                  TO ACTIVE-PARAGRAPH       
                 MOVE 'USERABEN'              TO ABEND-FUNCTION         
                 MOVE WS-YES                  TO WS-USER-FORCE-ABEND    
                 MOVE 'PAYMENT ABEND'         TO DSNTIAR-MESSAGE-1      
PCR360           PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT          
PCR360        END-IF                                                    
PCR360     END-IF.                                                      
                                                                        
           MOVE WS-JRNL-CNTRL-ONLY TO WS-JRNL-OPERATION-RQST.           
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT.             
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '5010'                  TO ACTIVE-PARAGRAPH          
              MOVE 'USERABEN'              TO ABEND-FUNCTION            
              MOVE WS-YES                  TO WS-USER-FORCE-ABEND       
              MOVE SPACES                  TO DSNTIAR-MESSAGE-1         
PCR360        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
PCR360     END-IF.                                                      
       5010-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
T11466     EXEC SQL                                                     PCS09350
T11466       INCLUDE CPD00003                                           PCS09350
T11466     END-EXEC.                                                    PCS09350
                                                                        
           EXEC SQL                                                             
A00956       INCLUDE CPD0006A                                           PCS09360
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00008                                                  
           END-EXEC.                                                            
                                                                        
       COPY CPD00010.                                                   PCS09350
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD0010S                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00073                                                  
           END-EXEC.                                                            
                                                                        
       7000-SELECT-AT-PR-CU.                                            
           EXEC SQL                                                     
              SELECT AT.CUSTOMER_NO,                                    
                     AT.CODE_ACCT_STAT,                                 
                     AT.TOTAL_AR_BALANCE,                               
                     AT.DATE_LAST_ACTION,                               
                     AT.LOCAL_OFFICE,                                   
                     AT.PREMISE_NO,                                     
                     AT.CODES_DATA_PRESENT,                             
                     AT.COMPANY_NO,                                     
                     AT.AR_XFER_IND,                                    
                     AT.ACCT_XFER_TO,                                   
                     AT.BANKRUPTCY_IND,                                 
                     AT.CREDIT_GROUP,                                   
PCR360               AT.DATE_BILL_DAY_00,                               
PCR360               AT.DATE_BILL_DAY_30,                               
PCR360               AT.DATE_BILL_DAY_60,                               
PCR360               AT.DATE_BILL_DAY_90,                               
PCR360               AT.NOTICE_EXEMPT_CD,                               
PCR360               AT.CODE_DISC_OK,                                   
C28788               AT.IVR_EXEMPT_CD,                                  
                     PR.CODE_PREMISE_STAT,                              
                     PR.REV_DISTRICT_CD,                                
                     CU.CODE_EMPL_ACCT,                                 
                     CU.CODE_CUST_STATUS,                               
                     CAST(SYSDATETIMEOFFSET() AS DATE)                          
             INTO    :AT-CUSTOMER-NO,                                   
                     :AT-CODE-ACCT-STAT,                                
                     :AT-TOTAL-AR-BALANCE,                              
                     :AT-DATE-LAST-ACTION,                              
                     :AT-LOCAL-OFFICE,                                  
                     :AT-PREMISE-NO,                                    
                     :AT-CODES-DATA-PRESENT,                            
                     :AT-COMPANY-NO,                                    
                     :AT-AR-XFER-IND,                                   
                     :AT-ACCT-XFER-TO,                                  
                     :AT-BANKRUPTCY-IND,                                
                     :AT-CREDIT-GROUP,                                  
PCR360               :AT-DATE-BILL-DAY-00 :WS-NULL-IND1,                 
PCR360               :AT-DATE-BILL-DAY-30 :WS-NULL-IND2,                 
PCR360               :AT-DATE-BILL-DAY-60 :WS-NULL-IND3,                 
PCR360               :AT-DATE-BILL-DAY-90 :WS-NULL-IND4,                 
PCR360               :AT-NOTICE-EXEMPT-CD,                              
PCR360               :AT-CODE-DISC-OK,                                  
C28788               :AT-IVR-EXEMPT-CD,                                 
                     :PR-CODE-PREMISE-STAT,                             
                     :PR-REV-DISTRICT-CD,                               
                     :CU-CODE-EMPL-ACCT,                                
                     :CU-CODE-CUST-STATUS,                              
                     :WS-CURRENT-DATE                                   
            FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED), CSS_PREMISE PR
                           WITH(READUNCOMMITTED), CSS_CUSTOMER CU
                           WITH(READUNCOMMITTED)        
            WHERE AT.ACCOUNT_NO  = :AT-ACCOUNT-NO AND                   
                  AT.PREMISE_NO  = PR.PREMISE_NO  AND                   
                  AT.CUSTOMER_NO = CU.CUSTOMER_NO                       
A36248                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     12270014
MFA-TR*       SELECT AT.CUSTOMER_NO,                                    PCS15140
MFA-TR*              AT.CODE_ACCT_STAT,                                 PCS15150
MFA-TR*              AT.TOTAL_AR_BALANCE,                               PCS15160
MFA-TR*              AT.DATE_LAST_ACTION,                               PCS15170
MFA-TR*              AT.LOCAL_OFFICE,                                   12330016
MFA-TR*              AT.PREMISE_NO,                                     PCS15180
MFA-TR*              AT.CODES_DATA_PRESENT,                             PCS15180
MFA-TR*              AT.COMPANY_NO,                                     12350016
MFA-TR*              AT.AR_XFER_IND,                                            
MFA-TR*              AT.ACCT_XFER_TO,                                           
MFA-TR*              AT.BANKRUPTCY_IND,                                 12360016
MFA-TR*              AT.CREDIT_GROUP,                                           
MFA-TR*              AT.DATE_BILL_DAY_00,                                       
MFA-TR*              AT.DATE_BILL_DAY_30,                                       
MFA-TR*              AT.DATE_BILL_DAY_60,                                       
MFA-TR*              AT.DATE_BILL_DAY_90,                                       
MFA-TR*              AT.NOTICE_EXEMPT_CD,                                       
MFA-TR*              AT.CODE_DISC_OK,                                           
MFA-TR*              AT.IVR_EXEMPT_CD,                                          
MFA-TR*              PR.CODE_PREMISE_STAT,                              PCS15210
MFA-TR*              PR.REV_DISTRICT_CD,                                        
MFA-TR*              CU.CODE_EMPL_ACCT,                                 PCS15220
MFA-TR*              CU.CODE_CUST_STATUS,                               PCS15220
MFA-TR*              CURRENT DATE                                               
MFA-TR*      INTO    :AT-CUSTOMER-NO,                                   PCS15230
MFA-TR*              :AT-CODE-ACCT-STAT,                                PCS15150
MFA-TR*              :AT-TOTAL-AR-BALANCE,                              PCS15160
MFA-TR*              :AT-DATE-LAST-ACTION,                              PCS15170
MFA-TR*              :AT-LOCAL-OFFICE,                                  12330016
MFA-TR*              :AT-PREMISE-NO,                                    PCS15180
MFA-TR*              :AT-CODES-DATA-PRESENT,                            PCS15180
MFA-TR*              :AT-COMPANY-NO,                                    12350016
MFA-TR*              :AT-AR-XFER-IND,                                           
MFA-TR*              :AT-ACCT-XFER-TO,                                          
MFA-TR*              :AT-BANKRUPTCY-IND,                                12360016
MFA-TR*              :AT-CREDIT-GROUP,                                          
MFA-TR*              :AT-DATE-BILL-DAY-00:WS-NULL-IND1,                         
MFA-TR*              :AT-DATE-BILL-DAY-30:WS-NULL-IND2,                         
MFA-TR*              :AT-DATE-BILL-DAY-60:WS-NULL-IND3,                         
MFA-TR*              :AT-DATE-BILL-DAY-90:WS-NULL-IND4,                         
MFA-TR*              :AT-NOTICE-EXEMPT-CD,                                      
MFA-TR*              :AT-CODE-DISC-OK,                                          
MFA-TR*              :AT-IVR-EXEMPT-CD,                                         
MFA-TR*              :PR-CODE-PREMISE-STAT,                             PCS15210
MFA-TR*              :PR-REV-DISTRICT-CD,                                       
MFA-TR*              :CU-CODE-EMPL-ACCT,                                PCS15220
MFA-TR*              :CU-CODE-CUST-STATUS,                              PCS15220
MFA-TR*              :WS-CURRENT-DATE                                           
MFA-TR*     FROM CSS_ACCOUNT AT, CSS_PREMISE PR, CSS_CUSTOMER CU        PCS15240
MFA-TR*     WHERE AT.ACCOUNT_NO  = :AT-ACCOUNT-NO AND                   PCS15240
MFA-TR*           AT.PREMISE_NO  = PR.PREMISE_NO  AND                   PCS15240
MFA-TR*           AT.CUSTOMER_NO = CU.CUSTOMER_NO                       PCS15240
MFA-TR*     WITH UR                                                             
MFA-TR*    END-EXEC.                                                    12490016

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
PCR360        IF WS-NULL-IND1 EQUAL -1                                  
PCR360           MOVE SPACES            TO AT-DATE-BILL-DAY-00          
PCR360        END-IF                                                    
PCR360        IF WS-NULL-IND2 EQUAL -1                                  
PCR360           MOVE SPACES            TO AT-DATE-BILL-DAY-30          
PCR360        END-IF                                                    
PCR360        IF WS-NULL-IND3 EQUAL -1                                  
PCR360           MOVE SPACES            TO AT-DATE-BILL-DAY-60          
PCR360        END-IF                                                    
PCR360        IF WS-NULL-IND4 EQUAL -1                                  
PCR360           MOVE SPACES            TO AT-DATE-BILL-DAY-90          
PCR360        END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
CBSI          MOVE 'CSS_PREMISE'         TO TABLE-2                     
CBSI          MOVE 'CSS_CUSTOMER'        TO TABLE-3                     
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
PCR360        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
PCR360     END-IF.                                                      
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7170-SELECT-RECONNECT.                                           
           EXEC SQL                                                     
               SELECT AMT_TOT_RECONNECT,                                
T19540                RECNCT_COLLECT_AMT                                
                 INTO :DL-AMT-TOT-RECONNECT,                            
T19540                :DL-RECNCT-COLLECT-AMT                            
              FROM CSS_RECONNECT WITH(READUNCOMMITTED)                          
              WHERE ACCOUNT_NO = :DL-ACCOUNT-NO                         
T19540          AND  AMT_TOT_RECONNECT  > 0                             
A36248                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     02499031
MFA-TR*        SELECT AMT_TOT_RECONNECT,                                        
MFA-TR*               RECNCT_COLLECT_AMT                                        
MFA-TR*          INTO :DL-AMT-TOT-RECONNECT,                                    
MFA-TR*               :DL-RECNCT-COLLECT-AMT                                    
MFA-TR*       FROM CSS_RECONNECT                                        02504032
MFA-TR*       WHERE ACCOUNT_NO = :DL-ACCOUNT-NO                         02504531
MFA-TR*         AND  AMT_TOT_RECONNECT  > 0                                     
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    02504731

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7170'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_RECONNECT'       TO TABLE-1                     
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE DL-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
PCR360        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
PCR360     END-IF.                                                      
       7170-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                     14890000
              INCLUDE CPD00075                                          14900000
           END-EXEC.                                                    14910000
                                                                        
      *                                                                         
       7460-SELECT-GL-NAME.                                             
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OBTAIN THE GL-NAME  FROM THE      **        
      **  CSS_GL_ACCT_NO TABLE WITH GL-NO AS THE KEY.                 **        
      ******************************************************************        
      *                                                                         
           MOVE '7460'               TO ACTIVE-PARAGRAPH.               
           EXEC SQL                                                     
               SELECT GL_ACCT_NAME                                      
                INTO :GO-GL-ACCT-NAME                                   
                FROM CSS_GL_ACCT_NO WITH(READUNCOMMITTED)                       
                WHERE                                                   
                   GL_ACCT_NO    = :GO-GL-ACCT-NO                       
A36248                                                           
           END-EXEC .                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT GL_ACCT_NAME                                              
MFA-TR*         INTO :GO-GL-ACCT-NAME                                           
MFA-TR*         FROM CSS_GL_ACCT_NO                                             
MFA-TR*         WHERE                                                           
MFA-TR*            GL_ACCT_NO    = :GO-GL-ACCT-NO                               
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC .                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                                         OR NOT-FOUND                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_GL_ACCT_NO'           TO TABLE-1                
              MOVE 'GL_ACCT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
CBSI          MOVE GO-GL-ACCT-NO              TO WS-GO-GL-ACCT-NO-ED    
CBSI          MOVE WS-GO-GL-ACCT-NO-ED        TO HOSTVAR-ELEMENT-1      
              MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2      
PCR360        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7460-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO INSERT A ROW IN THE               **        
      **  CSS_LIEAP   TABLE                                           **        
      ******************************************************************        
      *                                                                         
       8130-INSERT-LI-ROW.                                              
           MOVE '8130'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_LIEAP                                      
             (                                                          
              ACCOUNT_NO,                                               
              VOUCHER_PAY_DT,                                           
              VOUCHER_AMT,                                              
              INITIATED_BY,                                             
              CODE_AGENCY_ID ,                                          
              PYMT_FACILITY_CD ,                                        
              COMMENT                                                   
             )                                                          
             VALUES                                                     
                  (:LI-ACCOUNT-NO,                                      
                   CIS.CHAR2TIMESTAMP(:LI-VOUCHER-PAY-DT) ,                     
                   :LI-VOUCHER-AMT,                                     
                   :LI-INITIATED-BY,                                    
                   :LI-CODE-AGENCY-ID ,                                 
                   :LI-PYMT-FACILITY-CD ,                               
                   :LI-COMMENT  )                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_LIEAP                                              
MFA-TR*      (                                                                  
MFA-TR*       ACCOUNT_NO,                                                       
MFA-TR*       VOUCHER_PAY_DT,                                                   
MFA-TR*       VOUCHER_AMT,                                                      
MFA-TR*       INITIATED_BY,                                                     
MFA-TR*       CODE_AGENCY_ID ,                                                  
MFA-TR*       PYMT_FACILITY_CD ,                                                
MFA-TR*       COMMENT                                                           
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*           (:LI-ACCOUNT-NO,                                              
MFA-TR*            :LI-VOUCHER-PAY-DT ,                                         
MFA-TR*            :LI-VOUCHER-AMT,                                             
MFA-TR*            :LI-INITIATED-BY,                                            
MFA-TR*            :LI-CODE-AGENCY-ID ,                                         
MFA-TR*            :LI-PYMT-FACILITY-CD ,                                       
MFA-TR*            :LI-COMMENT  )                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          RS-RETURN-CODE.               
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'INSERT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_LIEAP'                TO TABLE-1                
              MOVE 'ACCOUNT_NO    '           TO TABLE-ELEMENT-1        
CBSI          MOVE 'VOUCHER_PAY_DT'           TO TABLE-ELEMENT-2        
CBSI          MOVE 'INITIATED_BY'             TO TABLE-ELEMENT-3        
CBSI          MOVE 'CODE_AGENCY_ID'           TO TABLE-ELEMENT-4        
              MOVE LI-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE LI-VOUCHER-PAY-DT          TO HOSTVAR-ELEMENT-2      
CBSI          MOVE LI-INITIATED-BY            TO HOSTVAR-ELEMENT-3      
CBSI          MOVE LI-CODE-AGENCY-ID          TO HOSTVAR-ELEMENT-4      
PCR360        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
PCR360     END-IF.                                                      
       8130-EXIT.                                                       
           EXIT.                                                        
A36248*                                                                         
PCR360                                                                  
PCR307 8610-INSERT-SO-DNP-CANCEL.                                       
PCR307                                                                  
PCR307     MOVE WS-U                         TO XK-SO-UPDT-ACTION-FL.   
PCR307     MOVE WS-ACCOUNT-NO                TO XK-ACCOUNT-NO.          
PCR307                                                                  
PCR307     EXEC SQL                                                     
PCR307        INSERT INTO CSS_SO_DNP_CANCEL                             
PCR307          ( ACCOUNT_NO,                                           
PCR307            SO_UPDT_ACTION_FL )                                   
PCR307        VALUES ( :XK-ACCOUNT-NO,                                  
PCR307                 :XK-SO-UPDT-ACTION-FL )                          
PCR307     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PCR307                                                                  
PCR307     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
PCR307                     RS-RETURN-CODE.                              
PCR307     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
PCR307        WS-ACTIVE-RETURN-CODE EQUAL -803                          
PCR307        MOVE ZERO TO WS-ACTIVE-RETURN-CODE                        
PCR307                     RS-RETURN-CODE                               
PCR307     ELSE                                                         
PCR307        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
PCR307        MOVE '8610'                    TO ACTIVE-PARAGRAPH        
PCR307        MOVE 'INSERT'                  TO ABEND-FUNCTION          
PCR307        MOVE SPACES                    TO ABEND-SQL-PREDICATES    
PCR307                                          ABEND-TABLES            
PCR307        MOVE 'CSS_SO_DNP_CANCEL'       TO TABLE-1                 
PCR307        MOVE XK-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
PCR307        MOVE XK-SO-UPDT-ACTION-FL      TO HOSTVAR-ELEMENT-2       
CBSI          MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
CBSI          MOVE 'SO_UPDT_ACTION_FL'       TO TABLE-ELEMENT-2         
PCR307        PERFORM 9700-PROCESS-ABEND           THRU 9700-EXIT       
PCR307     END-IF.                                                      
PCR307 8610-EXIT.                                                       
PCR307     EXIT.                                                        
A36248*                                                                         
A36248******************************************************************        
A36248*8999-ISSUE-COMMIT.                                                       
A36248******************************************************************        
A36248 8999-ISSUE-COMMIT.                                               
A36248     EXEC SQL                                                             
A36248        INCLUDE CPD00047                                                  
A36248     END-EXEC.                                                            
                                                    
A36248 8999-EXIT.                                                       
A36248     EXIT.                                                        
A36248*                                                                         
T24436******************************************************************        
T24436* LOADING GL NUMBERS                                                      
T24436******************************************************************        
T24436* 9350-LINK-SCSCO061.                                            *        
T24436*    CALLS THE SUBPROGRAM SCSCO061*                                       
T24436******************************************************************        
T24436*                                                                         
T24436 9350-LINK-SCSCO061.                                              
T24436*                                                                         
T24436     MOVE SPACES                    TO ABEND-FUNCTION.            
T24436     PERFORM 9400-CALL-CPD00061     THRU 9400-EXIT.               
T24436     MOVE RS-RETURN-CODE            TO WS-ACTIVE-RETURN-CODE,     
T24436                                       SQLCODE.                   
T24436     IF ABEND-FUNCTION  > SPACES                                  
T24436        PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
T24436     END-IF.                                                      
T24436                                                                  
T24436 9350-EXIT.                                                       
T24436     EXIT.                                                        
T24436*                                                                         
T24436******************************************************************        
T24436* 9400-CALL-CPD00061                                             *        
T24436*     CALLS THE COPYBOOK CPD00061                                *        
T24436******************************************************************        
T24436*                                                                         
T24436 9400-CALL-CPD00061.                                              
T24436                                                                  
REARCH     CALL MCSCO061  USING  WS-GL-ACCT-NAME                        
REARCH                           WS-GL-ACCT-MAJOR-FIELDS                
REARCH                           WS-VALID-COMPANY-NOS                   
REARCH                           WS-GL-NAME-INFO                        
REARCH                           WS-GL-ACCT-NO-TABLE                    
REARCH                           ABEND-FILE                             
REARCH                           RS-RETURN-CODE.                        
REARCH     MOVE RS-RETURN-CODE            TO WS-ACTIVE-RETURN-CODE,     
REARCH                                       S-RETURN-CODE.             
REARCH     IF ABEND-FUNCTION  > SPACES                                  
REARCH        IF ABEND-FUNCTION EQUAL 'BADDATA'                         
REARCH           MOVE -1                  TO RS-RETURN-CODE,            
REARCH                                       WS-ACTIVE-RETURN-CODE      
REARCH        END-IF                                                    
REARCH        PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
REARCH        PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT             
REARCH     END-IF.                                                      
T24436                                                                  
T24436 9400-EXIT.                                                       
T24436     EXIT.                                                        
T24436                                                                  
PCR360******************************************************************        
PCR360* 9700-PROCESS-ABEND - COMMON ERROR HANDLER FOR BATCH/ON-LINE    *        
PCR360******************************************************************        
PCR360     EXEC SQL                                                             
PCR360        INCLUDE CPD0023C                                                  
PCR360     END-EXEC.                                                            
PCR360                                                                  
P00849*---------------------------------------------------------------* 00329700
P00849* CANCEL DNP OR DNPFB                                           * 00329800
P00849*---------------------------------------------------------------* 00329900
ACT285 9800-CALL-MCS03414.                                              
P00849                                                                  
ACT285     CALL MCS03414 USING   WS-ACCOUNT-NO-NUM                      
P00849                          ,WS-UPDATE-ACTION-FL                    
P00849                          ,WS-FACILITY-CODE                       
P00849                          ,WS-DNP-RET-CODE                        
ACT285                          ,WS-PYMT-AMOUNT                         
ACT285                          ,WS-PAYMENT-AMOUNT-TOTAL                
ACT285                          ,WS-CALL-TYPE                           
ACT285                          ,WS-CPD68-REQUIRED                      
ACT285                          ,WS-PROGRAM-NAME                        
ACT285                          ,WS-CPD68-ACTN-FL                       
ACT285                          ,WS-CNCL-DNP-ACTN-FL                    
P00948                          ,WS-CNCL-DNP-EMAIL-REQ-FL               
ACT285                          ,WS-SO-UPDT-ACTN-FL                     
ACT285                          ,WS-CRED-ARNG-ACTN-FL                   
ACT285                          ,ws-APPL-PROGRAM-ID                     
P00849                          ,ABEND-FILE                             
P00849     .                                                            
P00849 9800-EXIT.                                                       
P00849     EXIT.                                                        
P00849*                                                                 00331000
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
NONUTL     EXEC SQL                                                             
NONUTL        INCLUDE CPD00312                                                  
NONUTL     END-EXEC.                                                            
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000       ADD 1 TO CTR-ROWS.                                         
CVT000 8100-EXIT.                                                       
CVT000        EXIT.                                                     
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00321                                         00000200
CVT000     END-EXEC.                                                    00000300
