       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02293.                                         
COB303 DATE-WRITTEN.  DECEMBER 19, 1994                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
      *                                                                *00110000
      *  TRANID:        S293                                           *00120000
      *  PROGRAM:       S293                                           *00130000
      *  CALLING SP:    PA_S293                                        *00140000
      *                                                                *00150000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *  THIS PROCEDURE SELECTS ACCOUNTS RECEIVABLE INFORMATION FROM   *00190000
      *  THE CSS_AR_CNTL, CSS_ACCOUNT AND CSS_AR_TRANS_HIST TABLES     *00200000
      *  BASED ON THE ACCOUNT_NO, AND FUNCTION.                        *00210000
      *                                                                *00220000
      ******************************************************************00230000
      *                                                                *00240000
      *                     PROGRAM MODIFICATION LOG                   *00250000
      *                                                                *00260000
      *    DATE    INITIALS   COMMENTS                                 *00270000
      *  --------  --------   ---------------------------------------  *00280000
      *  12/19/94    MLR      PROCEDURE ORIGINALLY CODED.              *00290000
      *  04/01/95    ECC      PROCEDURE CODED PER MODIFIED DESIGN      *00300000
      *  08/29/95    WMG      MODIFIED TO ADD THE CURRENT DATE AS      *00310000
      *                       THE FINAL RETURN VALUE.                  *00320000
      *  04/12/96    RTO      PCR047 SECURED RATES                     *00330000
      *                                                                *00340000
      *  04/19/96    MR       MODIFIED TO ADD 7750-SEL-CNT-NAME-CD     *00350000
      *                       FOR THOSE CASES WHERE CNT-NAME-CD IS     *00360000
      *                       MISSING IN THE PARAMETER LIST.           *00370000
      *                       TPR# 3790 FIX                            *00380000
      *                                                                *00390000
PCR072*  09/30/96    PD       COMMENTED CODE FOR CIAC FOR PCR072.      *00400000
      *                                                                *00410000
PCR212*  10/09/96    SG       ADDED SECOND GL NUMBER.                  *00420000
      *                                                                *00430000
P025  *  10/18/96    JBW      MODIFY TO RETRIEVE THE COURTESY          *00440000
P025  *                       ADJUSTMENT GL NUMBER.  ALSO REMOVED CHECK*00450000
P025  *                       FOR VERIFYING RECEIVABLE TYPE. PCR025.   *00460000
      *                                                                *00470000
TP8668*  01/27/97    SG       CHANGED TO RETURN ONLY ONE RESULT ROW FOR*00480000
      *                       EACH EACH TRANSACTION.                   *00490000
      *                                                                *00500000
TP9953*  04/16/97    PP       CORRECTED FOR RETURN CODE -310 IN PARA   *00510000
      *                       7950. POPULATING CP-ACCOUNT-NO. TPR9953  *00520000
T12630*  08/10/97    PP       TPR12630 - FOR CREDITING EXISTING RECEIV-*00530000
T12630*                       -ABLES, THE CONTRACTS WILL SHOW 0,30,60 &*00540000
T12630*                       90 DAY RECEIVABLES.                      *00550000
T12630*  08/14/97    PP       TPR12630 - RETURNING AMT-TRAN-BALANCE    *00560000
T12630*                       FOR CONTRACTS.                           *00570000
PCR586*  11/03/97    PD       BRING IN ALL PREV TRANS.                 *00571006
T14840*  02/26/98    PD/KHB   CHANGES TO HANDLE REBATE ONLY CONTRACTS  *00572002
T15312*  03/17/98    PD       SHOW NEGATIVES FOR CREDITS TO RECEIVABLE.*00572102
T15312*                       SHOW AMT-POSTED NOT AMT-ORIGINAL-ENTERED.*00572202
T16114*  04/27/98    PD       HANDLE THE PANEL NOT TO ABEND WITH A     *00572102
T16114*                       RETURN CODE OF 100 WHEN CSS_CONNECT_CHRG.*00572202
T16114*                       IS NOT FOUND AND RCC IS TO  BE CREDITED. *00572202
T17253*  07/31/98    SV       ADD ACCTING PERIOD TO PANEL 310.         *00572202
T17653*  09/06/98    SJM      ADDED CHECK TO ENSURE THIS IS A VALID    *00572202
T17653*                       BUSINESS DAY PRIOR TO GETTING REVENUE    *00572202
T17653*                       MONTH. IF IT IS NOT, THEN THE NEXT       *00572202
T17653*                       BUSINESS DAY IS DETERMINED.              *00572202
CBSI  *  12/15/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *              MADRAS   ABEND PARAMETERS                         *        
T17842*  01/06/98     SV      HANDLE MULTIPLE RCC'S                    *        
T21170*  02/23/00    CBSI     SEND AN ERROR MESSAGE TO PANEL WHEN      *        
T21170*              MADRAS   SPECIFIC RECEIVABLE IS SELECTED FOR AN   *        
T21170*                       ACCOUNT HAVING RECONNECT AGREEMENT       *        
      *  04/09/01    CHANELLE MCR310. CSS_GL_ACCT_NO CHANGES.          *        
T23235*  06/21/01    SS82048  MCR-57 CHANGES TO INCLUDE NEW COLUMN     *        
      *                       RCNCT_ACCT_TYPE_CD IN WHERE CLAUSE OF    *        
      *                       SELECT ON CSS_RECONNECT_CHRG             *        
T25607*  09/11/01    SK88120  IF THE ACCOUNT IS NOT HAVING A ROW IN    *        
      *                       CSS_UTIL_ENVRNMT ,WS_ACCT_TYPE_CD IS *            
      *                       NOT BEING POPULATED . MADE CHANGES TO    *        
      *                       RETRIEVE ACCT_TYPE_CODE FROM CSS_ACCOUNT *        
      *                       FOR THOSE TYPE OF ACCOUNTS.              *        
C25674*  02/06/02    LAT      TO SET THE CORRECT GL NO FOR LPC WHEN THE*        
C25674*                       ACCT DOESN'T HAVE ANY ROWS IN UTIL ENVRNT*        
C26509*  06/20/02    LAT      TO FETCH CORRECT GL NO WHEN CREDIT CHARGE*        
C26509*                       IS APPLIED TO RCC.                       *        
C24880*  02/10/03    SRIDEVI  PASS GL ACCT NO TO THE RESULT SET IN CASE*        
C24880*                       OF CONNECTION CHARGE DFA                 *        
T29696*  12/20/03    VIDHU    DEFAULT TO THE CORRECT GL # FOR RCC      *        
T29696*                       PSNC ACCOUNTS.                           *        
T29697*  12/20/03    VIDHU    DEFAULT TO THE CORRECT GL # FOR LPC      *        
T29697*                       PSNC ACCOUNTS.                           *        
T30124*  12/31/03    VIDHU    DISTINGUISH WHETHER SEB OR CSR DATABASE  *        
T30124*                       AND DEFAULT ONLY TO THE GAS GL # FOR SEB *        
T30124*                       ACCOUNTS                                 *        
T30135*  05/03/05    CB18344  ADDED 2 NEW MISCELLANEOUS CREDITS -      *        
T30135*                       INTEREST SUBDIVISION LIGHT AND INTEREST  *        
T30135*                       FRANCHISE FEE.                           *        
REARCH*  10/20/05    CVNS     RPC TO COBOL SP CONVERSION               *        
REARCH*              CHENNAI                                           *        
T35434*  10/30/07    MK92804  REPLACED CSS_MODEL_SQL WITH SET STMTS    *        
T35434*                       AND ADDED FOR FETCH ONLY WITH UR FOR     *        
T35434*                       CURSOR SELECTS AND WITH UR FOR SINGLETON *        
T35434*                       SELECTS.                                 *        
T36657*  02/12/08    RC41079  REMOVE DISTINCT FROM 7120-SELECT-BILL-   *        
T35434*                       WINDOW TO IMPROVE PERFORMANCE.           *        
A37061*  03/27/09    SJ97149  1.REPLACE CODE_REV_CLASS MID DIGIT CHECK *        
A37061*                         WITH CSS_ACCOUNT.ACCOUNT_TYPE_CODE FOR *        
A37061*                         GETTING TYPE OF THE ACCOUNT.           *        
A37061*                       2.ADDED "ROWSET POSITIONING FOR GLOBAL"  *        
A37061*                         TEMPERARY TABLES.                      *        
P00774*  08/08/15    WR19680  REMOVED RECONNECT CHECK AGREEMENT FOR    *        
P00774*                       MISC. CREDIT.                            *        
ACT319*  10/28/16    VIJAY    INITIALIZE WS-GL-SUB TO SUPPORT MFES     *        
ACT319*  A05460                                                        *        
      ******************************************************************00580000
      *                                                                *00590000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00600000
      *                                                                *00610000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00620000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00630000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00640000
      *  3000 - 4999  NOT USED                                         *00650000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00660000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00670000
      *  7000 - 7999  INPUT MODULES                                    *00680000
      *  8000 - 8999  OUTPUT MODULES                                   *00690000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00700000
      *                                                                *00710000
      ******************************************************************00720000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02293'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02293 STARTS HERE'.                  
                                                                        
      ******************************************************************00810000
      *    DB2 INCLUDES                                                *00820000
      ******************************************************************00830000
                                                                        
           EXEC SQL                                                     00850000
              INCLUDE SQLCA                                             00860000
           END-EXEC.                                                    00870000
                                                                        
           EXEC SQL                                                     00890000
              INCLUDE TBACCT                                            00900000
           END-EXEC.                                                    00910000
                                                                        
           EXEC SQL                                                     00930000
              INCLUDE TBARCNTL                                          00940000
           END-EXEC.                                                    00950000
                                                                        
           EXEC SQL                                                     00970000
              INCLUDE TBARHIST                                          00980000
           END-EXEC.                                                    00990000
                                                                        
           EXEC SQL                                                     01010000
              INCLUDE TBARHDT                                           01020000
           END-EXEC.                                                    01030000
                                                                        
           EXEC SQL                                                     01050000
              INCLUDE TBARLOCK                                          01060000
           END-EXEC.                                                    01070000
                                                                        
           EXEC SQL                                                     01090000
              INCLUDE TBARTYPE                                          01100000
           END-EXEC.                                                    01110000
                                                                        
           EXEC SQL                                                     01130000
              INCLUDE TBCNTINF                                          01140000
           END-EXEC.                                                    01150000
                                                                        
           EXEC SQL                                                     01170000
              INCLUDE TBCNTRCT                                          01180000
           END-EXEC.                                                    01190000
                                                                        
           EXEC SQL                                                     01210000
              INCLUDE TBGLATNO                                          01220000
           END-EXEC.                                                    01230000
                                                                        
           EXEC SQL                                                     01290000
              INCLUDE TBRTDESC                                          01300000
           END-EXEC.                                                    01310000
                                                                        
           EXEC SQL                                                     01330000
              INCLUDE TBUTLENV                                          01340000
           END-EXEC.                                                    01350000
                                                                        
PCR212     EXEC SQL                                                     01370000
PCR212        INCLUDE TBCSTPLN                                          01380000
PCR212     END-EXEC.                                                    01390000
PCR212                                                                  
PCR212     EXEC SQL                                                     01410000
PCR212        INCLUDE TBRCNCHR                                          01420000
PCR212     END-EXEC.                                                    01430000
PCR212                                                                  
PCR212     EXEC SQL                                                     01450000
PCR212        INCLUDE TBCCCHRG                                          01460000
PCR212     END-EXEC.                                                    01470000
PCR212                                                                  
T17253     EXEC SQL                                                             
T17253        INCLUDE TBBILWDW                                                  
T17253     END-EXEC.                                                    01490000
                                                                        
T17653     EXEC SQL                                                             
T17653        INCLUDE TBHLDAY                                                   
T17653     END-EXEC.                                                    01490000
T21170                                                                  
T21170     EXEC SQL                                                             
T21170        INCLUDE TBRECNCT                                                  
T21170     END-EXEC.                                                            
C24880                                                                  
C24880     EXEC SQL                                                             
C24880        INCLUDE TBDFAACT                                                  
C24880     END-EXEC.                                                            
C24880                                                                  
C24880     EXEC SQL                                                             
C24880        INCLUDE TBCHGTYP                                                  
C24880     END-EXEC.                                                            
C24880                                                                  
T30124     EXEC SQL                                                             
T30124        INCLUDE TBDELQ                                                    
T30124     END-EXEC.                                                            
                                                                        
      ******************************************************************01500000
      *    COBOL WORKING STORAGE COPY BOOKS                            *01510000
      ******************************************************************01520000
                                                                        
           COPY CCA00001.                                               01560000
                                                                        
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CWSX0010                                                  
REARCH     END-EXEC.                                                            
                                                                        
           COPY CWS00027.                                               01580000
           COPY CWS00061.                                               01590000
           COPY CWS00303.                                               01600000
T17653     EXEC SQL                                                     01600000
T17653         INCLUDE CWS00315                                         01600000
T17653     END-EXEC.                                                    01600000
                                                                        
      ******************************************************************01620000
      *    WORK AREAS                                                  *01630000
      ******************************************************************01640000
                                                                        
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME             PIC X(08) VALUE 'CSR02293'.     
           05  WS-ACCOUNT-NO            PIC 9(13) VALUE ZERO.           
           05  WS-ACCOUNT-NO-NUM        PIC S9(13) COMP-3 VALUE ZERO.   
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  WS-RECORD-FOUND-FLAG     PIC X(01) VALUE 'N'.            
               88 RECORD-FOUND                    VALUE 'Y'.            
           05  WS-AR1                   PIC S9(03)V9(04) COMP-3 VALUE 0.
           05  WS-AR2                   PIC S9(03)V9(04) COMP-3 VALUE 0.
           05  WS-AR3                   PIC S9(03)V9(04) COMP-3 VALUE 0.
           05  WS-NULL-INDICATOR        PIC S9(04) COMP.                
           05  WS-MAX-ITEM-ID           PIC S9(09) COMP.                
           05  WS-NULL-DATE-BILL-DAY-00 PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-DATE-BILL-DAY-30 PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-DATE-BILL-DAY-60 PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-DATE-BILL-DAY-90 PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-DATE-TRANS       PIC S9(04) COMP VALUE ZERO.     
T17653     05  WS-NULL-REVENUE-MONTH    PIC S9(04) COMP VALUE ZERO.     
           05  WS-CURRENT-DATE          PIC X(10)  VALUE SPACES.        
           05  WS-CURRENT-DATE-DB2      PIC X(10)  VALUE SPACES.        
T21170     05  WS-RECONNECT-EXISTS      PIC X(01)  VALUE 'N'.           
PCR212     05  WS-UTE-EXISTS            PIC X.                          
PCR212         88  HAVE-UTE             VALUE 'Y'.                      
PCR212         88  HAVE-NOT-UTE         VALUE 'N'.                      
PCR212     05  WS-UTG-EXISTS            PIC X.                          
PCR212         88  HAVE-UTG             VALUE 'Y'.                      
PCR212         88  HAVE-NOT-UTG         VALUE 'N'.                      
TP8668     05  WS-FORMATTED-DATE.                                       
TP8668         10  FORMATTED-MONTH      PIC X(2).                       
TP8668         10  FILLER               PIC X(1) VALUE '/'.             
TP8668         10  FORMATTED-DAY        PIC X(2).                       
TP8668         10  FILLER               PIC X(1) VALUE '/'.             
TP8668         10  FORMATTED-YEAR       PIC X(4).                       
TP8668     05  ZERO-GL-ACCT-NO2         PIC X(1).                       
TP8668         88  NOT-ZERO-NO2         VALUE 'N'.                      
TP8668         88  ZERO-NO2             VALUE 'Y'.                      
T17653     05  WS-BUSINESS-DAY          PIC X(10).                      
T17253     05  WS-SUB                   PIC 9(01) VALUE 1.              
T17253     05  WS-REVENUE-MONTH.                                        
T17253         10  WS-REVENUE-MONTH-NUM  PIC 9(6).                      
T17653     05  WS-REVENUE-EXISTS        PIC X(1) VALUE 'N'.             
T17842     05  WS-RCC-ROWS              PIC S9(4) COMP VALUE +0.        
T23235     05  WS-ACCT-TYPE-CD          PIC X(01) VALUE SPACES.         
T23235     05  WS-CLASS                 PIC X(01) VALUE SPACES.         
C25674     05  WS-AR-EXISTS             PIC X(01) VALUE 'N'.            
T30124     05  WS-DATABASE              PIC 9(01) VALUE ZERO.           
                                                                        
       01  DIST-RECV-TABLE.                                             
           05  DIST-RECV-TYPE-RECORD   OCCURS 63 TIMES                  
                                       INDEXED BY DIST-RECV-TYPE-CNT.   
               10  DIST-RECV-PYMT-PRI-LVL-X.                            
                   15  DIST-RECV-PYMT-PRI-LVL PIC 9(04).                
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  CURSOR-ROWS             PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
           05  W-LT-ONE                PIC S9(01) VALUE +1.             
           05  W-LT-MINUS-ONE          PIC S9(01) VALUE -1.             
           05  PREV-PYMT-PRI-LVL       PIC 9(04) COMP VALUE ZERO.       
           05  CREDIT-LPC              PIC X(03) VALUE 'LPC'.           
           05  CREDIT-LPN              PIC X(03) VALUE 'LPN'.           
           05  CREDIT-CNT              PIC X(03) VALUE 'CNT'.           
           05  CREDIT-RCC              PIC X(03) VALUE 'RCC'.           
PCR072*    05  CREDIT-CIAC             PIC X(03) VALUE 'CIA'.           02430000
PCR072     05  CREDIT-CIA              PIC X(03) VALUE 'CIA'.           
           05  CREDIT-PJS              PIC X(03) VALUE 'PJS'.           
           05  CREDIT-NSC              PIC X(03) VALUE 'NSC'.           
P025       05  CREDIT-CCA              PIC X(03) VALUE 'CCA'.           
PCRPCR     05  CREDIT-MIS              PIC X(03) VALUE 'MIS'.           
T30135     05  CREDIT-ISL              PIC X(03) VALUE 'ISL'.           
T30135     05  CREDIT-IFF              PIC X(03) VALUE 'IFF'.           
T14840     05  CREDIT-REB              PIC X(03) VALUE 'REB'.           
C24880     05  CREDIT-CEC              PIC X(03) VALUE 'CEC'.           
           05  WS-GL-ACCT-NO-CNVRT     PIC 9(03).9999.                  
C25674     05  WS-UTE                  PIC 9(02) VALUE  40.             
C25674     05  WS-UTG                  PIC 9(02) VALUE  45.             
T30135     05  WS-GL-EXP-TAXINT        PIC X(10) VALUE 'EXP-TAXINT'.    
T30135     05  WS-GL-EXP-SUBINT        PIC X(10) VALUE 'EXP-SUBINT'.    
                                                                        
       01  FILLER  PIC X(32) VALUE 'THESE ARE THE PARMS ENTERED.'.      
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  TDS-RETURN-FIELDS.                                           
                                                                        
           05  RS-RETURN-CODE           PIC S9(09) COMP VALUE 0.        
           05  RS-ITEM-ID               PIC S9(09) COMP VALUE 0.        
           05  RS-PYMT-PRIORITY-LVL     PIC  9(04) COMP VALUE 0.        
                                                                        
           05  RS-DATE-BILL-DAY-00      PIC X(10) VALUE SPACES.         
           05  RS-DATE-BILL-DAY-30      PIC X(10) VALUE SPACES.         
           05  RS-DATE-BILL-DAY-60      PIC X(10) VALUE SPACES.         
           05  RS-DATE-BILL-DAY-90      PIC X(10) VALUE SPACES.         
           05  RS-AMT-AR-DAY-00         PIC S9(09)V99 VALUE 0 COMP-3.   
           05  RS-AMT-AR-DAY-30         PIC S9(09)V99 VALUE 0 COMP-3.   
           05  RS-AMT-AR-DAY-60         PIC S9(09)V99 VALUE 0 COMP-3.   
           05  RS-AMT-AR-DAY-90         PIC S9(09)V99 VALUE 0 COMP-3.   
                                                                        
           05  RS-DATE-TRANS1           PIC X(10) VALUE SPACES.         
           05  RS-DATE-TRANS2           PIC X(10) VALUE SPACES.         
           05  RS-DATE-TRANS3           PIC X(10) VALUE SPACES.         
           05  RS-DATE-TRANS4           PIC X(10) VALUE SPACES.         
           05  RS-AMT-TRANS1            PIC S9(09)V99 VALUE 0 COMP-3.   
           05  RS-AMT-TRANS2            PIC S9(09)V99 VALUE 0 COMP-3.   
           05  RS-AMT-TRANS3            PIC S9(09)V99 VALUE 0 COMP-3.   
           05  RS-AMT-TRANS4            PIC S9(09)V99 VALUE 0 COMP-3.   
                                                                        
           05  RS-DIST-RECV-TYPES       PIC X(255) VALUE SPACES.        
                                                                        
           05  RS-GL-ACCT-NO            PIC S9(03)V9999 VALUE 0 COMP-3. 
           05  RS-COURTESY-GL-ACCT-NO   PIC S9(03)V9999 VALUE 0 COMP-3. 
                                                                        
           05  RS-AT-LAST-UPDATE-TS     PIC X(26) VALUE SPACES.         
           05  RS-AC-LAST-UPDATE-TS     PIC X(26) VALUE SPACES.         
           05  RS-AR-LOCKOUT-IND        PIC X(01) VALUE SPACES.         
           05  RS-CURRENT-DATE          PIC X(10) VALUE SPACES.         
           05  RS-SECURED-RATE-FL       PIC X(01) VALUE SPACES.         
           05  RS-CNT-NAME-CD           PIC 9(04) COMP  VALUE 0.        
           05  RS-CNT-NAME-DESC         PIC X(30) VALUE SPACES.         
PCR212     05  RS-GL-ACCT-NO2           PIC S9(03)V9999 VALUE 0 COMP-3. 
T12630     05  RS-AMT-TRAN-BALANCE      PIC S9(09)V99 VALUE 0 COMP-3.   
T17253     05  RS-REVENUE-MONTH-1       PIC X(6)  VALUE SPACES.         
T17253     05  RS-REVENUE-MONTH-2       PIC X(6)  VALUE SPACES.         
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
                                                                        
REARCH     05  S-RETURN-CODE           PIC S9(09) COMP VALUE 0.         
REARCH     05  S-ITEM-ID               PIC S9(09) COMP VALUE 0.         
REARCH     05  S-PYMT-PRIORTY-LVL      PIC S9(04) COMP VALUE 0.         
                                                                        
REARCH     05  S-DATE-BILL-DAY-00      PIC X(10) VALUE SPACES.          
REARCH     05  S-DATE-BILL-DAY-30      PIC X(10) VALUE SPACES.          
REARCH     05  S-DATE-BILL-DAY-60      PIC X(10) VALUE SPACES.          
REARCH     05  S-DATE-BILL-DAY-90      PIC X(10) VALUE SPACES.          
REARCH     05  S-AMT-AR-DAY-00         PIC S9(09)V99 VALUE 0 COMP-3.    
REARCH     05  S-AMT-AR-DAY-30         PIC S9(09)V99 VALUE 0 COMP-3.    
REARCH     05  S-AMT-AR-DAY-60         PIC S9(09)V99 VALUE 0 COMP-3.    
REARCH     05  S-AMT-AR-DAY-90         PIC S9(09)V99 VALUE 0 COMP-3.    
                                                                        
REARCH     05  S-DATE-TRANS1           PIC X(10) VALUE SPACES.          
REARCH     05  S-DATE-TRANS2           PIC X(10) VALUE SPACES.          
REARCH     05  S-DATE-TRANS3           PIC X(10) VALUE SPACES.          
REARCH     05  S-DATE-TRANS4           PIC X(10) VALUE SPACES.          
REARCH     05  S-AMT-TRANS1            PIC S9(09)V99 VALUE 0 COMP-3.    
REARCH     05  S-AMT-TRANS2            PIC S9(09)V99 VALUE 0 COMP-3.    
REARCH     05  S-AMT-TRANS3            PIC S9(09)V99 VALUE 0 COMP-3.    
REARCH     05  S-AMT-TRANS4            PIC S9(09)V99 VALUE 0 COMP-3.    
                                                                        
REARCH     05  S-DIST-RECV-TYPES       PIC X(255) VALUE SPACES.         
                                                                        
REARCH     05  S-GL-ACCT-NO            PIC S9(03)V9999 VALUE 0 COMP-3.  
REARCH     05  S-COURTESY-GL-ACCT-NO   PIC S9(03)V9999 VALUE 0 COMP-3.  
                                                                        
REARCH     05  S-AT-LAST-UPDATE-TS     PIC X(26) VALUE SPACES.          
REARCH     05  S-AC-LAST-UPDATE-TS     PIC X(26) VALUE SPACES.          
REARCH     05  S-AR-LOCKOUT-IND        PIC X(01) VALUE SPACES.          
REARCH     05  S-CURRENT-DATE          PIC X(10) VALUE SPACES.          
REARCH     05  S-SECURED-RATE-FL       PIC X(01) VALUE SPACES.          
REARCH     05  S-CNT-NAME-CD           PIC S9(04) COMP  VALUE 0.        
REARCH     05  S-CNT-NAME-DESC         PIC X(30) VALUE SPACES.          
REARCH     05  S-GL-ACCT-NO2           PIC S9(03)V9999 VALUE 0 COMP-3.  
REARCH     05  S-AMT-TRAN-BALANCE      PIC S9(09)V99 VALUE 0 COMP-3.    
REARCH     05  S-REVENUE-MONTH-1       PIC X(6)  VALUE SPACES.          
REARCH     05  S-REVENUE-MONTH-2       PIC X(6)  VALUE SPACES.          
                                                                        
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
REARCH     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
REARCH     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
REARCH     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
REARCH         49  S-HOST-VARIABLES-V    PIC X(255).                    
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
REARCH         49  S-SQL-STATEMENT-V     PIC X(255).                    
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
REARCH         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
REARCH     10  WS-ABEND-SQLERRMC.                                       
REARCH         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
REARCH         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
REARCH     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
      ******************************************************************03640000
      *    CURSOR DECLARATIONS                                         *03650000
      ******************************************************************03660000
      *** 'B'- BILLED, 'C' - CORRECTION, 'P' - PAYMENT, 'A' - ADJUSTMENT03670000
TP8668     EXEC SQL DECLARE AR-CURSOR CURSOR FOR                        
TP8668        SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           AR.TRANS_HIST_SEQ_NO, 121), ' ', '-'), ':', '.') 
           TRANS_HIST_SEQ_NO,                              
TP8668               AMT_POSTED,                                        
TP8668               GL_ACCT_CREDIT,                                    
TP8668               GL_ACCT_DEBIT                                      
TP8668          FROM CSS_AR_TRANS_HIST  AR WITH(READUNCOMMITTED),               
TP8668               CSS_AR_TRN_HST_DET AU WITH(READUNCOMMITTED)                
TP8668         WHERE AR.ACCOUNT_NO        =  :AR-ACCOUNT-NO             
TP8668           AND AR.ACCOUNT_NO        =  AU.ACCOUNT_NO              
TP8668           AND AR.TRANS_HIST_SEQ_NO =  AU.TRANS_HIST_SEQ_NO       
PCR586*          AND AR.CODE_TRAN_TYPE   IN ('I','B','C','P','A')       03710003
TP8668           AND ((AU.GL_ACCT_CREDIT  =  :RS-GL-ACCT-NO             
TP8668            OR  AU.GL_ACCT_CREDIT   =  :RS-GL-ACCT-NO2)           
TP8668            OR (AU.GL_ACCT_DEBIT    =  :RS-GL-ACCT-NO             
TP8668            OR  AU.GL_ACCT_DEBIT    =  :RS-GL-ACCT-NO2))          
TP8668          ORDER BY TRANS_HIST_SEQ_NO DESC                      
T35434          FOR READ ONLY                                   
TP8668     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE AR-CURSOR CURSOR FOR                        03680000
MFA-TR*       SELECT AR.TRANS_HIST_SEQ_NO,                              03690000
MFA-TR*              AMT_POSTED,                                        03650003
MFA-TR*              GL_ACCT_CREDIT,                                    03650103
MFA-TR*              GL_ACCT_DEBIT                                      03651003
MFA-TR*         FROM CSS_AR_TRANS_HIST  AR,                             03710000
MFA-TR*              CSS_AR_TRN_HST_DET AU                              03720000
MFA-TR*        WHERE AR.ACCOUNT_NO        =  :AR-ACCOUNT-NO             03730000
MFA-TR*          AND AR.ACCOUNT_NO        =  AU.ACCOUNT_NO              03740000
MFA-TR*          AND AR.TRANS_HIST_SEQ_NO =  AU.TRANS_HIST_SEQ_NO       03750000
MFA-TR*          AND AR.CODE_TRAN_TYPE   IN ('I','B','C','P','A')       03710003
MFA-TR*          AND ((AU.GL_ACCT_CREDIT  =  :RS-GL-ACCT-NO             03770000
MFA-TR*           OR  AU.GL_ACCT_CREDIT   =  :RS-GL-ACCT-NO2)           03780000
MFA-TR*           OR (AU.GL_ACCT_DEBIT    =  :RS-GL-ACCT-NO             03790000
MFA-TR*           OR  AU.GL_ACCT_DEBIT    =  :RS-GL-ACCT-NO2))          03800000
MFA-TR*         ORDER BY AR.TRANS_HIST_SEQ_NO DESC                      03820000
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                    03830000
                                                                        
           EXEC SQL DECLARE AC-CURSOR CURSOR FOR                        
              SELECT PYMT_PRIORITY_LVL,                                 
                     ITEM_ID,                                           
                     AMT_AR_DAY_00,                                     
                     AMT_AR_DAY_30,                                     
                     AMT_AR_DAY_60,                                     
                     AMT_AR_DAY_90,                                     
                     REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,                        
TP5247               AMT_TRAN_BALANCE                                   
                FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :AC-ACCOUNT-NO                        
            ORDER BY PYMT_PRIORITY_LVL                                  
T35434      FOR READ ONLY                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE AC-CURSOR CURSOR FOR                        03850000
MFA-TR*       SELECT PYMT_PRIORITY_LVL,                                 03860000
MFA-TR*              ITEM_ID,                                           03870000
MFA-TR*              AMT_AR_DAY_00,                                     03880000
MFA-TR*              AMT_AR_DAY_30,                                     03890000
MFA-TR*              AMT_AR_DAY_60,                                     03900000
MFA-TR*              AMT_AR_DAY_90,                                     03910000
MFA-TR*              LAST_UPDATE_TS,                                    03920000
MFA-TR*              AMT_TRAN_BALANCE                                   03930000
MFA-TR*         FROM CSS_AR_CNTL                                        03940000
MFA-TR*        WHERE ACCOUNT_NO = :AC-ACCOUNT-NO                        03950000
MFA-TR*     ORDER BY PYMT_PRIORITY_LVL                                  03960000
MFA-TR*     FOR FETCH ONLY WITH UR                                              
MFA-TR*    END-EXEC.                                                    03970000
                                                                        
           EXEC SQL DECLARE SEL-UTL-CUR CURSOR FOR                      
              SELECT 'Y'                                                
                FROM CSS_UTIL_ENVRNMT UT
                           WITH(READUNCOMMITTED),CSS_RATE_PLAN_DESC RD
                           WITH(READUNCOMMITTED)          
               WHERE UT.ACCOUNT_NO = :UT-ACCOUNT-NO                     
                 AND UT.CODE_UTIL_TYPE = RD.CODE_UTIL_TYPE              
                 AND UT.RATE_PLAN_NO = RD.RATE_PLAN_NO                  
                 AND RD.SECURED_RATE_FL = 'Y'                           
T35434           FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE SEL-UTL-CUR CURSOR FOR                      03990000
MFA-TR*       SELECT 'Y'                                                04000000
MFA-TR*         FROM CSS_UTIL_ENVRNMT UT,CSS_RATE_PLAN_DESC RD          04010000
MFA-TR*        WHERE UT.ACCOUNT_NO = :UT-ACCOUNT-NO                     04020000
MFA-TR*          AND UT.CODE_UTIL_TYPE = RD.CODE_UTIL_TYPE              04030000
MFA-TR*          AND UT.RATE_PLAN_NO = RD.RATE_PLAN_NO                  04040000
MFA-TR*          AND RD.SECURED_RATE_FL = 'Y'                           04050000
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                    04060000
                                                                        
PCR212     EXEC SQL DECLARE UTIL-CURSOR CURSOR FOR                      
PCR212         SELECT CODE_UTIL_TYPE,                                   
PCR212                IC_NO                                             
PCR212           FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                    
PCR212          WHERE ACCOUNT_NO = :UT-ACCOUNT-NO                       
T35434          FOR READ ONLY                                   
PCR212     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE UTIL-CURSOR CURSOR FOR                      04080000
MFA-TR*        SELECT CODE_UTIL_TYPE,                                   04090000
MFA-TR*               IC_NO                                             04100000
MFA-TR*          FROM CSS_UTIL_ENVRNMT                                  04110000
MFA-TR*         WHERE ACCOUNT_NO = :UT-ACCOUNT-NO                       04120000
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                    04130000
PCR212                                                                  
PCR212     EXEC SQL DECLARE UNMTRD-CURSOR CURSOR FOR                    
PCR212        SELECT CODE_SERVICE_TYPE                                  
PCR212          FROM CSS_CUST_PLAN WITH(READUNCOMMITTED)                        
PCR212         WHERE ACCOUNT_NO = :CP-ACCOUNT-NO
            OPTION(FAST 1)
            FOR READ ONLY
                               
PCR212     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ021
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE UNMTRD-CURSOR CURSOR FOR                    04150000
MFA-TR*       SELECT CODE_SERVICE_TYPE                                  04160000
MFA-TR*         FROM CSS_CUST_PLAN                                      04170000
MFA-TR*        WHERE ACCOUNT_NO = :CP-ACCOUNT-NO                        04180000
MFA-TR*     OPTIMIZE FOR 1 ROW FOR FETCH ONLY WITH UR                   04190000
MFA-TR*    END-EXEC.                                                    04200000
                                                                        
T17253     EXEC SQL DECLARE BILWDW-CURSOR CURSOR FOR                    
T17253        SELECT DISTINCT(REVENUE_MONTH)                            
T17253          FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                      
T17653         WHERE DATE_EXTRACT = IIF(TRY_CONVERT(DATE, 
                                                       :WS-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-BUSINESS-DAY) <> 10), CIS.CHAR2DATE(
                                                       :WS-BUSINESS-DAY
              ), CONVERT(DATE, :WS-BUSINESS-DAY) )                    
T17253        ORDER BY REVENUE_MONTH DESC                               
T35434         FOR READ ONLY                                    
T17253     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL DECLARE BILWDW-CURSOR CURSOR FOR                            
MFA-TR*       SELECT DISTINCT(REVENUE_MONTH)                                    
MFA-TR*         FROM CSS_BILL_WINDOW                                            
MFA-TR*        WHERE DATE_EXTRACT = :WS-BUSINESS-DAY                            
MFA-TR*       ORDER BY REVENUE_MONTH DESC                                       
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
      *                                                                         
HPCCDM* EJECT                                                           04220000
REARCH LINKAGE SECTION.                                                 
REARCH 01  PARM-ACCOUNT-NO         PIC 9(13).                           
REARCH 01  PARM-ITEM-ID            PIC S9(09) COMP VALUE 0.             
REARCH 01  PARM-RECV-TYPE          PIC X(03).                           
REARCH 01  PARM-CNT-NAME-CD        PIC S9(04) COMP VALUE 0.             
REARCH  PROCEDURE DIVISION USING                                        
REARCH                          PARM-ACCOUNT-NO                         
REARCH                          PARM-ITEM-ID                            
REARCH                          PARM-RECV-TYPE                          
REARCH                          PARM-CNT-NAME-CD.                       
                                                                        
      ******************************************************************04250000
      **     CONTROLS THE MAIN PATH OF THE PROGRAM                      04260000
      ** 0000-MAINLINE                                                  04270000
      ******************************************************************04280000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************04410000
      * 0100-INITIALIZE                                                *04420000
      *                                                                *04430000
      *     1. RESET DB2 ERROR HANDLERS                                *04440000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *04450000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *04460000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*04470000
      *                                                                *04480000
      ******************************************************************04490000
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
REARCH     EXEC SQL                                                     
A37061         DECLARE C1 CURSOR                             
A37061                           WITH ROWSET POSITIONING FOR            
REARCH           SELECT                                                 
REARCH             :S-RETURN-CODE              AS RETURN_CODE           
REARCH            ,:S-ITEM-ID                  AS ITEM_ID               
REARCH            ,:S-PYMT-PRIORTY-LVL         AS PYMT_PRIORITY_LVL     
REARCH            ,LTRIM(RTRIM(:S-DATE-BILL-DAY-00))  AS 
           DATE_BILL_DAY_00      
REARCH            ,LTRIM(RTRIM(:S-DATE-BILL-DAY-30))  AS 
           DATE_BILL_DAY_30      
REARCH            ,LTRIM(RTRIM(:S-DATE-BILL-DAY-60))  AS 
           DATE_BILL_DAY_60      
REARCH            ,LTRIM(RTRIM(:S-DATE-BILL-DAY-90))  AS 
           DATE_BILL_DAY_90      
REARCH            ,:S-AMT-AR-DAY-00            AS AMT_AR_DAY_00         
REARCH            ,:S-AMT-AR-DAY-30            AS AMT_AR_DAY_30         
REARCH            ,:S-AMT-AR-DAY-60            AS AMT_AR_DAY_60         
REARCH            ,:S-AMT-AR-DAY-90            AS AMT_AR_DAY_90         
REARCH            ,LTRIM(RTRIM(:S-DATE-TRANS1))       AS DATE_TRANS1           
REARCH            ,LTRIM(RTRIM(:S-DATE-TRANS2))       AS DATE_TRANS2           
REARCH            ,LTRIM(RTRIM(:S-DATE-TRANS3))       AS DATE_TRANS3           
REARCH            ,LTRIM(RTRIM(:S-DATE-TRANS4))       AS DATE_TRANS4           
REARCH            ,:S-AMT-TRANS1               AS AMT_ORIG_ENTERED1     
REARCH            ,:S-AMT-TRANS2               AS AMT_ORIG_ENTERED2     
REARCH            ,:S-AMT-TRANS3               AS AMT_ORIG_ENTERED3     
REARCH            ,:S-AMT-TRANS4               AS AMT_ORIG_ENTERED4     
REARCH            ,LTRIM(RTRIM(:S-DIST-RECV-TYPES))   AS DIST_RECV_TYPES       
REARCH            ,:S-GL-ACCT-NO               AS GL_ACCT_NO            
REARCH            ,:S-COURTESY-GL-ACCT-NO      AS COURTSY_GL_ACCT_NO    
REARCH            ,LTRIM(RTRIM(:S-AT-LAST-UPDATE-TS)) AS 
           AT_LAST_UPDATE_TS     
REARCH            ,LTRIM(RTRIM(:S-AC-LAST-UPDATE-TS)) AS 
           AC_LAST_UPDATE_TS     
REARCH            ,LTRIM(RTRIM(:S-AR-LOCKOUT-IND))    AS AR_LOCKOUT_IND        
REARCH            ,LTRIM(RTRIM(:S-CURRENT-DATE))      AS [CURRENT_DATE]         
REARCH            ,LTRIM(RTRIM(:S-SECURED-RATE-FL))   AS SECURED_RATE_FL       
REARCH            ,:S-CNT-NAME-CD              AS CNT_NAME_CD           
REARCH            ,LTRIM(RTRIM(:S-CNT-NAME-DESC))     AS CNT_NAME_DESC         
REARCH            ,:S-GL-ACCT-NO2              AS GL_ACCT_NO2           
REARCH            ,:S-AMT-TRAN-BALANCE         AS AMT_TRAN_BALANCE      
REARCH            ,LTRIM(RTRIM(:S-REVENUE-MONTH-1))   AS REVENUE_MONTH_1       
REARCH            ,LTRIM(RTRIM(:S-REVENUE-MONTH-2))   AS REVENUE_MONTH_2       
REARCH            ,0                                                    
REARCH            ,0                                                    
REARCH            ,0                                                    
REARCH            ,0                                                    
REARCH            ,0                                                    
REARCH            ,0                                                    
REARCH         FROM                                                     
REARCH             CIS.SYSDUMMY1                                     
REARCH        END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ026
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*          SELECT                                                         
MFA-TR*            :S-RETURN-CODE              AS RETURN_CODE           02630000
MFA-TR*           ,:S-ITEM-ID                  AS ITEM_ID                       
MFA-TR*           ,:S-PYMT-PRIORTY-LVL         AS PYMT_PRIORITY_LVL             
MFA-TR*           ,STRIP(:S-DATE-BILL-DAY-00)  AS DATE_BILL_DAY_00      02670000
MFA-TR*           ,STRIP(:S-DATE-BILL-DAY-30)  AS DATE_BILL_DAY_30      02680000
MFA-TR*           ,STRIP(:S-DATE-BILL-DAY-60)  AS DATE_BILL_DAY_60      02690000
MFA-TR*           ,STRIP(:S-DATE-BILL-DAY-90)  AS DATE_BILL_DAY_90      02700000
MFA-TR*           ,:S-AMT-AR-DAY-00            AS AMT_AR_DAY_00         02710000
MFA-TR*           ,:S-AMT-AR-DAY-30            AS AMT_AR_DAY_30         02720000
MFA-TR*           ,:S-AMT-AR-DAY-60            AS AMT_AR_DAY_60         02730000
MFA-TR*           ,:S-AMT-AR-DAY-90            AS AMT_AR_DAY_90         02740000
MFA-TR*           ,STRIP(:S-DATE-TRANS1)       AS DATE_TRANS1           02760000
MFA-TR*           ,STRIP(:S-DATE-TRANS2)       AS DATE_TRANS2           02770000
MFA-TR*           ,STRIP(:S-DATE-TRANS3)       AS DATE_TRANS3           02780000
MFA-TR*           ,STRIP(:S-DATE-TRANS4)       AS DATE_TRANS4           02790000
MFA-TR*           ,:S-AMT-TRANS1               AS AMT_ORIG_ENTERED1     02800000
MFA-TR*           ,:S-AMT-TRANS2               AS AMT_ORIG_ENTERED2     02810000
MFA-TR*           ,:S-AMT-TRANS3               AS AMT_ORIG_ENTERED3     02820000
MFA-TR*           ,:S-AMT-TRANS4               AS AMT_ORIG_ENTERED4     02830000
MFA-TR*           ,STRIP(:S-DIST-RECV-TYPES)   AS DIST_RECV_TYPES       02850000
MFA-TR*           ,:S-GL-ACCT-NO               AS GL_ACCT_NO            02870000
MFA-TR*           ,:S-COURTESY-GL-ACCT-NO      AS COURTSY_GL_ACCT_NO    02880000
MFA-TR*           ,STRIP(:S-AT-LAST-UPDATE-TS) AS AT_LAST_UPDATE_TS     02900000
MFA-TR*           ,STRIP(:S-AC-LAST-UPDATE-TS) AS AC_LAST_UPDATE_TS     02910000
MFA-TR*           ,STRIP(:S-AR-LOCKOUT-IND)    AS AR_LOCKOUT_IND        02920000
MFA-TR*           ,STRIP(:S-CURRENT-DATE)      AS CURRENT_DATE          02930000
MFA-TR*           ,STRIP(:S-SECURED-RATE-FL)   AS SECURED_RATE_FL       02940000
MFA-TR*           ,:S-CNT-NAME-CD              AS CNT_NAME_CD           02950000
MFA-TR*           ,STRIP(:S-CNT-NAME-DESC)     AS CNT_NAME_DESC         02960000
MFA-TR*           ,:S-GL-ACCT-NO2              AS GL_ACCT_NO2           02970000
MFA-TR*           ,:S-AMT-TRAN-BALANCE         AS AMT_TRAN_BALANCE      02980000
MFA-TR*           ,STRIP(:S-REVENUE-MONTH-1)   AS REVENUE_MONTH_1               
MFA-TR*           ,STRIP(:S-REVENUE-MONTH-2)   AS REVENUE_MONTH_2               
MFA-TR*           ,0                                                            
MFA-TR*           ,0                                                            
MFA-TR*           ,0                                                            
MFA-TR*           ,0                                                            
MFA-TR*           ,0                                                            
MFA-TR*           ,0                                                            
MFA-TR*        FROM                                                             
MFA-TR*            SYSIBM.SYSDUMMY1                                             
MFA-TR*       END-EXEC.                                                         
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************04780000
      * 1000-PROCESS-INPUT                                             *04790000
      *                                                                *04800000
      *     1. RECEIVE PARMS.                                          *04810000
      *                                                                *04820000
      ******************************************************************04830000
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000' TO ACTIVE-PARAGRAPH.                             
           MOVE '1000' TO ACTIVE-PARAGRAPH.                             
ACT319     SET WS-GL-SUB TO 1.                                          
P025       IF PARM-RECV-TYPE = 'CCA' OR 'MIS'                           
T14840                               OR 'REB'                           
T30135                               OR 'ISL'                           
T30135                               OR 'IFF'                           
              NEXT SENTENCE                                             
           ELSE                                                         
              PERFORM 7300-SELECT-AR-TYPE    THRU 7300-EXIT             
P025       END-IF.                                                      
                                                                        
           MOVE PARM-ACCOUNT-NO           TO WS-ACCOUNT-NO.             
           MOVE WS-ACCOUNT-NO             TO WS-ACCOUNT-NO-NUM.         
           MOVE WS-ACCOUNT-NO-NUM         TO AC-ACCOUNT-NO              
                                             AR-ACCOUNT-NO              
TP9953                                       CP-ACCOUNT-NO              
                                             AT-ACCOUNT-NO              
T21170                                       DL-ACCOUNT-NO              
                                             UT-ACCOUNT-NO              
C24880                                       DA-ACCOUNT-NO.             
                                                                        
      ******************************************************************05010000
      *  THE FOLLOWING LOGIC DETERMINES THE NEXT AVAILABLE ITEM-ID NBR *05020000
      *  FOR THE GIVEN ACCOUNT NUMBER AND RECEIVABLE                   *05030000
      *                                                                *05040000
      *  NOTE: THIS IS NOT NEEDED FOR PANEL310 - MISC CREDIT B/C MONEY *05050000
      *        CAN ONLY BE CREDITED TO AN EXISTING RECEIVABLE          *05060000
      ******************************************************************05070000
      *                                                                 05080000
ECC   *    IF PARM-ITEM-ID LESS THAN ZERO                               05090000
      *       MOVE L5-PYMT-PRIORITY-LVL TO AC-PYMT-PRIORITY-LVL         05100000
      *       PERFORM 7600-SELECT-MAX-ITEM-ID THRU 7600-EXIT            05110000
      *       IF WS-NULL-INDICATOR EQUAL W-LT-MINUS-ONE OR              05120000
      *          WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  05130000
      *             MOVE W-LT-ONE TO RS-ITEM-ID                         05140000
      *       ELSE                                                      05150000
      *             ADD  W-LT-ONE TO WS-MAX-ITEM-ID GIVING RS-ITEM-ID   05160000
      *       END-IF                                                    05170000
      *       MOVE RS-ITEM-ID TO PARM-ITEM-ID                           05180000
      *    ELSE                                                         05190000
      *       MOVE PARM-ITEM-ID TO RS-ITEM-ID.                          05200000
ECC        IF PARM-ITEM-ID LESS THAN ZERO                               
              MOVE ZERO         TO PARM-ITEM-ID                         
                                   RS-ITEM-ID                           
           ELSE                                                         
              MOVE PARM-ITEM-ID TO RS-ITEM-ID
           END-IF.                          
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05850000
      * 2000-PROCESS-OUTPUT.                                           *05860000
      *                                                                *05870000
      *     1. DESCRIBE RESULT SET                                     *05880000
      *     2. UPDATE DB2 DATA                                         *05890000
      *     3. BUILD RESULT SET                                        *05900000
      *     4. SEND RESULT SET                                         *05910000
      *                                                                *05920000
      ******************************************************************05930000
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2200-BUILD-RESULT    THRU 2200-EXIT.                 
T17253     PERFORM 2300-OPEN-BILWDW     THRU 2300-EXIT.                 
T17253     PERFORM 2301-FETCH-BILWDW    THRU 2301-EXIT                  
T17253             UNTIL SQLCODE = NOT-FOUND OR                         
T17253             WS-SUB > 2.                                          
T17253     PERFORM 2302-CLOSE-BILWDW    THRU 2302-EXIT.                 
TP8668     IF ZERO-NO2                                                  
TP8668         IF HAVE-UTE                                              
TP8668             MOVE ZERO           TO RS-GL-ACCT-NO2                
TP8668         END-IF                                                   
TP8668         IF HAVE-UTG                                              
TP8668             MOVE RS-GL-ACCT-NO2 TO RS-GL-ACCT-NO                 
TP8668             MOVE ZERO           TO RS-GL-ACCT-NO2                
TP8668         END-IF                                                   
TP8668     END-IF.                                                      
REARCH     PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT.                
REARCH     ADD +1                       TO   CTR-ROWS.                  
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
REARCH******************************************************************        
REARCH*2000A-MOVE-RESULT.                                              *        
REARCH******************************************************************        
REARCH 2000A-MOVE-RESULT.                                               
REARCH        MOVE   RS-RETURN-CODE           TO S-RETURN-CODE.         
REARCH        MOVE   RS-ITEM-ID               TO S-ITEM-ID.             
REARCH        MOVE   RS-PYMT-PRIORITY-LVL     TO S-PYMT-PRIORTY-LVL.    
REARCH        MOVE   RS-DATE-BILL-DAY-00      TO S-DATE-BILL-DAY-00.    
REARCH        MOVE   RS-DATE-BILL-DAY-30      TO S-DATE-BILL-DAY-30.    
REARCH        MOVE   RS-DATE-BILL-DAY-60      TO S-DATE-BILL-DAY-60.    
REARCH        MOVE   RS-DATE-BILL-DAY-90      TO S-DATE-BILL-DAY-90.    
REARCH        MOVE   RS-AMT-AR-DAY-00         TO S-AMT-AR-DAY-00.       
REARCH        MOVE   RS-AMT-AR-DAY-30         TO S-AMT-AR-DAY-30.       
REARCH        MOVE   RS-AMT-AR-DAY-60         TO S-AMT-AR-DAY-60.       
REARCH        MOVE   RS-AMT-AR-DAY-90         TO S-AMT-AR-DAY-90.       
REARCH        MOVE   RS-DATE-TRANS1           TO S-DATE-TRANS1.         
REARCH        MOVE   RS-DATE-TRANS2           TO S-DATE-TRANS2.         
REARCH        MOVE   RS-DATE-TRANS3           TO S-DATE-TRANS3.         
REARCH        MOVE   RS-DATE-TRANS4           TO S-DATE-TRANS4.         
REARCH        MOVE   RS-AMT-TRANS1            TO S-AMT-TRANS1.          
REARCH        MOVE   RS-AMT-TRANS2            TO S-AMT-TRANS2.          
REARCH        MOVE   RS-AMT-TRANS3            TO S-AMT-TRANS3.          
REARCH        MOVE   RS-AMT-TRANS4            TO S-AMT-TRANS4.          
REARCH        MOVE   RS-DIST-RECV-TYPES       TO S-DIST-RECV-TYPES.     
REARCH        MOVE   RS-GL-ACCT-NO            TO S-GL-ACCT-NO.          
REARCH        MOVE   RS-COURTESY-GL-ACCT-NO   TO S-COURTESY-GL-ACCT-NO. 
REARCH        MOVE   RS-AT-LAST-UPDATE-TS     TO S-AT-LAST-UPDATE-TS.   
REARCH        MOVE   RS-AC-LAST-UPDATE-TS     TO S-AC-LAST-UPDATE-TS.   
REARCH        MOVE   RS-AR-LOCKOUT-IND        TO S-AR-LOCKOUT-IND.      
REARCH        MOVE   RS-CURRENT-DATE          TO S-CURRENT-DATE.        
REARCH        MOVE   RS-SECURED-RATE-FL       TO S-SECURED-RATE-FL.     
REARCH        MOVE   RS-CNT-NAME-CD           TO S-CNT-NAME-CD.         
REARCH        MOVE   RS-CNT-NAME-DESC         TO S-CNT-NAME-DESC.       
REARCH        MOVE   RS-GL-ACCT-NO2           TO S-GL-ACCT-NO2.         
REARCH        MOVE   RS-AMT-TRAN-BALANCE      TO S-AMT-TRAN-BALANCE.    
REARCH        MOVE   RS-REVENUE-MONTH-1       TO S-REVENUE-MONTH-1.     
REARCH        MOVE   RS-REVENUE-MONTH-2       TO S-REVENUE-MONTH-2.     
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
       2200-BUILD-RESULT.                                               
      ******************************************************************13590000
      *                                                                *13600000
      ******************************************************************13610000
      * GET-ACCT-INFO.                                                  13620000
                                                                        
           MOVE '2200' TO ACTIVE-PARAGRAPH.                             
                                                                        
                                                                        
           PERFORM 7400-SELECT-AR-LOCKOUT THRU 7400-EXIT.               
           MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE AL-AR-LOCKOUT-IND       TO RS-AR-LOCKOUT-IND         
           ELSE                                                         
              MOVE SPACES                  TO RS-AR-LOCKOUT-IND         
           END-IF.                                                      
      * IF AR-LOCKOUT IN EFFECT GET OUT                                 13760000
           IF RS-AR-LOCKOUT-IND = 'Y'                                   
              GO TO 2200-EXIT
           END-IF.                                          
                                                                        
           MOVE WS-N                TO RS-SECURED-RATE-FL.              
           PERFORM 7800-OPEN-SEL-UTL-CUR  THRU 7800-EXIT.               
           PERFORM 7810-FETCH-SEL-UTL-CUR THRU 7810-EXIT.               
           PERFORM 7820-CLOSE-SEL-UTL-CUR THRU 7820-EXIT.               
                                                                        
           PERFORM 2250-GET-CURRENT-DATE THRU 2250-EXIT.                
T17653     PERFORM 2400-CHECK-BUSINESS-DAY THRU 2400-EXIT               
           PERFORM 7000-SELECT-ACCOUNT   THRU 7000-EXIT.                
           MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE.                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE 'Y' TO WS-RECORD-FOUND-FLAG                          
              IF WS-NULL-DATE-BILL-DAY-00 = W-LT-MINUS-ONE              
                 MOVE SPACES                    TO RS-DATE-BILL-DAY-00  
              ELSE                                                      
                 MOVE AT-DATE-BILL-DAY-00       TO RS-DATE-BILL-DAY-00  
              END-IF                                                    
              IF WS-NULL-DATE-BILL-DAY-30 = W-LT-MINUS-ONE              
                 MOVE SPACES                    TO RS-DATE-BILL-DAY-30  
              ELSE                                                      
                 MOVE AT-DATE-BILL-DAY-30       TO RS-DATE-BILL-DAY-30  
              END-IF                                                    
              IF WS-NULL-DATE-BILL-DAY-60 = W-LT-MINUS-ONE              
                 MOVE SPACES                    TO RS-DATE-BILL-DAY-60  
              ELSE                                                      
                 MOVE AT-DATE-BILL-DAY-60       TO RS-DATE-BILL-DAY-60  
              END-IF                                                    
              IF WS-NULL-DATE-BILL-DAY-90 = W-LT-MINUS-ONE              
                 MOVE SPACES                    TO RS-DATE-BILL-DAY-90  
              ELSE                                                      
                 MOVE AT-DATE-BILL-DAY-90       TO RS-DATE-BILL-DAY-90  
              END-IF                                                    
              MOVE AT-LAST-UPDATE-TS            TO RS-AT-LAST-UPDATE-TS 
           ELSE                                                         
              MOVE SPACES                       TO RS-DATE-BILL-DAY-00  
              MOVE SPACES                       TO RS-DATE-BILL-DAY-30  
              MOVE SPACES                       TO RS-DATE-BILL-DAY-60  
              MOVE SPACES                       TO RS-DATE-BILL-DAY-90  
              MOVE SPACES                       TO RS-AT-LAST-UPDATE-TS 
           END-IF.                                                      
                                                                        
      * DETERMINE THE DATABASE                                                  
                                                                        
T30124     MOVE 'DATABASE'                     TO C8-DELINQ-CD.         
T30124     MOVE ZERO                           TO WS-DATABASE.          
T30124     PERFORM 7450-GET-DATABASE           THRU 7450-EXIT.          
                                                                        
      * GET-GL-NUMBERS.                                                 14200000
                                                                        
           MOVE WS-VALID-CO-NO (WS-GL-SUB)     TO GO-COMPANY-NO.        
                                                                        
C24880     IF PARM-ITEM-ID > 45000000                                   
C24880        MOVE CREDIT-CEC                  TO PARM-RECV-TYPE        
C24880     END-IF                                                       
C24880                                                                  
           EVALUATE PARM-RECV-TYPE                                      
PCR072*        WHEN CREDIT-CIAC                                         14250000
               WHEN CREDIT-CIA                                          
                    MOVE WS-GL-REV-CIA-KEY     TO GO-GL-ACCT-NAME       
               WHEN CREDIT-CNT                                          
                    IF PARM-CNT-NAME-CD GREATER THAN ZERO               
                       MOVE PARM-CNT-NAME-CD   TO K6-CNT-NAME-CD        
                       PERFORM 7700-SELECT-CONTRACT-INFO THRU 7700-EXIT 
                       MOVE SPACES             TO GO-GL-ACCT-NAME       
                       MOVE K6-GL-ACCT-NO      TO RS-GL-ACCT-NO         
                       MOVE ZEROES             TO RS-CNT-NAME-CD        
                       MOVE SPACES             TO RS-CNT-NAME-DESC      
                    ELSE                                                
   PD *                MOVE WS-GL-REV-CNT-KEY  TO GO-GL-ACCT-NAME       14370000
   MR * IN CASE THERE IS NO CNT_NAME_CD, IT SHOULD PICK UP              14380000
   MR * FROM CSS_CONTRACT AND DISPLAY.                                  14390000
                       PERFORM 7750-SEL-CNT-NAME-CD     THRU 7750-EXIT  
                       MOVE K6-CNT-NAME-CD     TO RS-CNT-NAME-CD        
                       MOVE K6-CNT-NAME-DESC   TO RS-CNT-NAME-DESC      
                       MOVE K6-GL-ACCT-NO      TO RS-GL-ACCT-NO         
                    END-IF                                              
               WHEN CREDIT-LPC                                          
PCR212              MOVE SPACES                TO GO-GL-ACCT-NAME       
               WHEN CREDIT-LPN                                          
PCR072*             MOVE WS-GL-EREV-LPN-KEY    TO GO-GL-ACCT-NAME       14480000
PCR072              MOVE WS-GL-REV-LPN-KEY     TO GO-GL-ACCT-NAME       
               WHEN CREDIT-PJS                                          
   PD *             MOVE WS-GL-REV-PJS-KEY     TO GO-GL-ACCT-NAME       14510000
                    MOVE WS-GL-LIA-PJS-KEY     TO GO-GL-ACCT-NAME       
               WHEN CREDIT-NSC                                          
PCR072*             MOVE WS-GL-EREV-NSC-KEY    TO GO-GL-ACCT-NAME       14540000
PCR072              MOVE WS-GL-REV-NSC-KEY     TO GO-GL-ACCT-NAME       
               WHEN CREDIT-RCC                                          
PCR212              MOVE SPACES                TO GO-GL-ACCT-NAME       
P025           WHEN CREDIT-CCA                                          
P025                MOVE WS-GL-EXP-CSYADJ-KEY  TO GO-GL-ACCT-NAME       
PCRPCR         WHEN CREDIT-MIS                                          
PCRPCR              MOVE ZERO                  TO RS-GL-ACCT-NO         
PCRPCR              MOVE ZERO                  TO RS-ITEM-ID            
PCRPCR              MOVE ZERO                  TO RS-PYMT-PRIORITY-LVL  
PCRPCR              MOVE ZERO                  TO RS-AMT-AR-DAY-00      
PCRPCR              MOVE ZERO                  TO RS-AMT-AR-DAY-30      
PCRPCR              MOVE ZERO                  TO RS-AMT-AR-DAY-60      
PCRPCR              MOVE ZERO                  TO RS-AMT-AR-DAY-90      
PCRPCR              MOVE ZERO                  TO RS-COURTESY-GL-ACCT-NO
PCRPCR              MOVE ZERO                  TO RS-GL-ACCT-NO2        
PCRPCR              MOVE ZERO                  TO RS-AMT-TRAN-BALANCE   
                                                                        
T14840         WHEN CREDIT-REB                                          
T14840              MOVE PARM-CNT-NAME-CD      TO K6-CNT-NAME-CD        
T14840              PERFORM 7700-SELECT-CONTRACT-INFO THRU 7700-EXIT    
T14840              MOVE  K6-REBATE-GL-ACCT-NO TO K6-GL-ACCT-NO         
T14840              MOVE K6-GL-ACCT-NO         TO RS-GL-ACCT-NO         
T14840              MOVE ZERO                  TO RS-ITEM-ID            
T14840              MOVE ZERO                  TO RS-PYMT-PRIORITY-LVL  
T14840              MOVE ZERO                  TO RS-AMT-AR-DAY-00      
T14840              MOVE ZERO                  TO RS-AMT-AR-DAY-30      
T14840              MOVE ZERO                  TO RS-AMT-AR-DAY-60      
T14840              MOVE ZERO                  TO RS-AMT-AR-DAY-90      
T14840              MOVE ZERO                  TO RS-COURTESY-GL-ACCT-NO
T14840              MOVE ZERO                  TO RS-GL-ACCT-NO2        
T14840              MOVE ZERO                  TO RS-AMT-TRAN-BALANCE   
                                                                        
C24880         WHEN CREDIT-CEC                                          
C24880              MOVE PARM-ITEM-ID          TO DA-DFA-ITEM-ID        
C24880              MOVE AT-COMPANY-NO         TO Z8-COMPANY-NO         
C24880              PERFORM 7770-SELECT-CODE-DFA-DESC THRU 7770-EXIT    
C24880              MOVE DA-CODE-DFA-DESC      TO Z8-CODE-DFA-DESC      
C24880              PERFORM 7775-SELECT-CONN-CHG-GL   THRU 7775-EXIT    
C24880              MOVE Z8-GL-ACCT-NO         TO RS-GL-ACCT-NO         
C24880              MOVE PARM-ITEM-ID          TO RS-ITEM-ID            
C24880              MOVE 90                    TO RS-PYMT-PRIORITY-LVL  
C24880              MOVE ZERO                  TO RS-AMT-AR-DAY-00      
C24880              MOVE ZERO                  TO RS-AMT-AR-DAY-30      
C24880              MOVE ZERO                  TO RS-AMT-AR-DAY-60      
C24880              MOVE ZERO                  TO RS-AMT-AR-DAY-90      
C24880              MOVE ZERO                  TO RS-COURTESY-GL-ACCT-NO
C24880              MOVE ZERO                  TO RS-GL-ACCT-NO2        
C24880              MOVE ZERO                  TO RS-AMT-TRAN-BALANCE   
                                                                        
T30135         WHEN CREDIT-IFF                                          
T30135              MOVE WS-GL-EXP-TAXINT      TO GO-GL-ACCT-NAME       
T30135                                                                  
T30135         WHEN CREDIT-ISL                                          
T30135              MOVE WS-GL-EXP-SUBINT      TO GO-GL-ACCT-NAME       
                                                                        
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME      TO ABEND-PROGRAM             
                    MOVE '2200'               TO ACTIVE-PARAGRAPH       
                    MOVE 'PARM CONDITIONAL'   TO ABEND-FUNCTION         
                    MOVE 'N\A'                TO TABLE-1                
                    MOVE 'PARM RECV-TYPE ERROR' TO TABLE-ELEMENT-1      
                    MOVE PARM-RECV-TYPE       TO HOSTVAR-ELEMENT-1      
                    PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
                    PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.      
                                                                        
           IF GO-GL-ACCT-NAME GREATER THAN SPACES                       
             PERFORM 7500-SELECT-GL-ACCOUNT THRU 7500-EXIT              
             MOVE 'Y' TO WS-RECORD-FOUND-FLAG                           
             MOVE GO-GL-ACCT-NO           TO RS-GL-ACCT-NO              
           END-IF.                                                      
                                                                        
PCR212     IF PARM-RECV-TYPE = CREDIT-LPC                               
PCR212         MOVE AT-ACCOUNT-NO TO UT-ACCOUNT-NO                      
TP9953         MOVE AT-ACCOUNT-NO TO CP-ACCOUNT-NO                      
PCR212         SET HAVE-NOT-UTE   TO TRUE                               
PCR212         SET HAVE-NOT-UTG   TO TRUE                               
PCR212         PERFORM 7920-OPEN-UTIL-CURSOR             THRU 7920-EXIT 
PCR212         PERFORM 7930-FETCH-UTIL-CURSOR            THRU 7930-EXIT 
PCR212         PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND          
PCR212         OR (HAVE-UTE AND HAVE-UTG)                               
PCR212             IF UT-CODE-UTIL-TYPE = 'E'                           
PCR212                 SET HAVE-UTE TO TRUE                             
PCR212             END-IF                                               
PCR212             IF UT-CODE-UTIL-TYPE = 'G'                           
PCR212                 SET HAVE-UTG TO TRUE                             
PCR212             END-IF                                               
PCR212             IF UT-CODE-UTIL-TYPE = 'U'                           
PCR212                 PERFORM 7950-OPEN-UNMTRD-CURSOR   THRU 7950-EXIT 
PCR212                 PERFORM 7960-FETCH-UNMTRD-CURSOR  THRU 7960-EXIT 
PCR212                 PERFORM 7970-CLOSE-UNMTRD-CURSOR  THRU 7970-EXIT 
PCR212                 IF CP-CODE-SERVICE-TYPE = 'E'                    
PCR212                     SET HAVE-UTE TO TRUE                         
PCR212                 END-IF                                           
PCR212                 IF CP-CODE-SERVICE-TYPE = 'G'                    
PCR212                     SET HAVE-UTE TO TRUE                         
PCR212                 END-IF                                           
PCR212             END-IF                                               
PCR212             PERFORM 7930-FETCH-UTIL-CURSOR THRU 7930-EXIT        
PCR212         END-PERFORM                                              
PCR212         PERFORM 7940-CLOSE-UTIL-CURSOR     THRU 7940-EXIT        
C25674*                                                                         
C25674         IF HAVE-NOT-UTE                                          
C25674            MOVE AT-ACCOUNT-NO       TO AC-ACCOUNT-NO             
C25674            MOVE WS-UTE              TO AC-PYMT-PRIORITY-LVL      
C25674            PERFORM 7990-GET-AR-CNTL        THRU 7990-EXIT        
C25674            IF WS-ACTIVE-RETURN-CODE = 0                          
C25674               SET HAVE-UTE          TO TRUE                      
C25674            END-IF                                                
C25674         END-IF                                                   
C25674         IF HAVE-NOT-UTG                                          
C25674            MOVE AT-ACCOUNT-NO       TO AC-ACCOUNT-NO             
C25674            MOVE WS-UTG              TO AC-PYMT-PRIORITY-LVL      
C25674            PERFORM 7990-GET-AR-CNTL        THRU 7990-EXIT        
C25674            IF WS-ACTIVE-RETURN-CODE = 0                          
C25674               SET HAVE-UTG          TO TRUE                      
C25674            END-IF                                                
C25674         END-IF                                                   
TP8668                                                                  
TP8668         MOVE WS-GL-EREV-LPC-KEY     TO GO-GL-ACCT-NAME           
TP8668         PERFORM 7500-SELECT-GL-ACCOUNT THRU 7500-EXIT            
TP8668         MOVE GO-GL-ACCT-NO          TO RS-GL-ACCT-NO             
TP8668                                                                  
TP8668         MOVE WS-GL-GREV-LPC-KEY     TO GO-GL-ACCT-NAME           
TP8668         PERFORM 7500-SELECT-GL-ACCOUNT THRU 7500-EXIT            
TP8668         MOVE GO-GL-ACCT-NO          TO RS-GL-ACCT-NO2            
TP8668                                                                  
T30124*        INCLUDED VALIDATION FOR SEB DATABASE                             
T29697         IF AT-COMPANY-NO = '26' OR WS-DATABASE = 2               
T29697            SET HAVE-NOT-UTE  TO TRUE                             
T29697            SET HAVE-UTG      TO TRUE                             
T29697         END-IF                                                   
T29697*                                                                         
TP8668         IF HAVE-UTE AND HAVE-UTG                                 
TP8668             SET NOT-ZERO-NO2 TO TRUE                             
TP8668         ELSE                                                     
TP8668             IF HAVE-UTE                                          
TP8668                 SET ZERO-NO2 TO TRUE                             
TP8668             END-IF                                               
TP8668             IF HAVE-UTG                                          
TP8668                 SET ZERO-NO2 TO TRUE                             
TP8668             END-IF                                               
TP8668         END-IF                                                   
PCR212     END-IF.                                                      
PCR212                                                                  
PCR212     IF PARM-RECV-TYPE = CREDIT-RCC                               
PCR212           MOVE WS-ACCOUNT-NO-NUM              TO CC-ACCOUNT-NO   
PCR212           MOVE 60                       TO CC-PYMT-PRIORITY-LVL  
PCR212           MOVE PARM-ITEM-ID                  TO CC-CCC-ITEM-ID   
PCR212*          MOVE WS-VALID-CO-NO (WS-GL-SUB)    TO U7-COMPANY-NO    15290000
PCR212           MOVE AT-COMPANY-NO                 TO U7-COMPANY-NO    
T16114           IF CC-CCC-ITEM-ID > 0                                  
A37061              PERFORM 7920-GET-ACCOUNT-TYPE-CD THRU               
A37061                      7920-GET-ACCOUNT-TYPE-CD-EXIT               
A37061              IF AT-ACCOUNT-TYPE-CODE = 'R' OR 'C' OR 'I'         
A37061                 MOVE AT-ACCOUNT-TYPE-CODE TO WS-ACCT-TYPE-CD     
A37061              ELSE                                                
A37061                 MOVE 'I'                  TO WS-ACCT-TYPE-CD     
A37061              END-IF                                              
T23235                                                                  
PCR212              PERFORM 7910-SELECT-RCC            THRU 7910-EXIT   
T16114           ELSE                                                   
T16114              MOVE AT-ACCOUNT-NO TO UT-ACCOUNT-NO                 
T16114              MOVE AT-ACCOUNT-NO TO CP-ACCOUNT-NO                 
T16114              PERFORM 7920-OPEN-UTIL-CURSOR   THRU 7920-EXIT      
T16114              PERFORM 7930-FETCH-UTIL-CURSOR  THRU 7930-EXIT      
T16114              PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND     
T16114                   OR (U7-RCNCT-ELEC-SVC-FL = 'Y' AND             
T16114                       U7-RCNCT-GAS-SVC-FL  = 'Y')                
T16114                 IF UT-CODE-UTIL-TYPE = 'E'                       
T16114                  MOVE 'Y' TO U7-RCNCT-ELEC-SVC-FL                
T16114                 END-IF                                           
T16114                 IF UT-CODE-UTIL-TYPE = 'G'                       
T16114                  MOVE 'Y' TO U7-RCNCT-GAS-SVC-FL                 
T16114                 END-IF                                           
T16114                 IF UT-CODE-UTIL-TYPE = 'U'                       
T16114                  PERFORM 7950-OPEN-UNMTRD-CURSOR   THRU 7950-EXIT
T16114                  PERFORM 7960-FETCH-UNMTRD-CURSOR  THRU 7960-EXIT
T16114                  PERFORM 7970-CLOSE-UNMTRD-CURSOR  THRU 7970-EXIT
T16114                  IF CP-CODE-SERVICE-TYPE = 'E'                   
T16114                      MOVE 'Y' TO U7-RCNCT-ELEC-SVC-FL            
T16114                  END-IF                                          
T16114                  IF CP-CODE-SERVICE-TYPE = 'G'                   
T16114                      MOVE 'Y' TO U7-RCNCT-GAS-SVC-FL             
T16114                  END-IF                                          
T16114                 END-IF                                           
T16114                 PERFORM 7930-FETCH-UTIL-CURSOR THRU 7930-EXIT    
T16114             END-PERFORM                                          
T16114             PERFORM 7940-CLOSE-UTIL-CURSOR THRU 7940-EXIT        
T16114           END-IF                                                 
TP8668                                                                  
TP8668           MOVE WS-GL-EREV-CCC-KEY        TO GO-GL-ACCT-NAME      
TP8668           PERFORM 7500-SELECT-GL-ACCOUNT THRU 7500-EXIT          
TP8668           MOVE GO-GL-ACCT-NO             TO RS-GL-ACCT-NO        
TP8668                                                                  
TP8668           MOVE WS-GL-GREV-CCC-KEY        TO GO-GL-ACCT-NAME      
TP8668           PERFORM 7500-SELECT-GL-ACCOUNT THRU 7500-EXIT          
TP8668           MOVE GO-GL-ACCT-NO             TO RS-GL-ACCT-NO2       
TP8668                                                                  
T30124*          INCLUDED VALIDATION FOR SEB DATABASE                           
T29696           IF AT-COMPANY-NO = '26' OR WS-DATABASE = 2             
T29696               MOVE 'N' TO U7-RCNCT-ELEC-SVC-FL                   
T29696               MOVE 'Y' TO U7-RCNCT-GAS-SVC-FL                    
T29696           END-IF                                                 
T29696*                                                                         
TP8668           IF U7-RCNCT-ELEC-SVC-FL = 'Y'                          
TP8668           AND U7-RCNCT-GAS-SVC-FL = 'Y'                          
TP8668               SET NOT-ZERO-NO2 TO TRUE                           
C26509               SET HAVE-UTE     TO TRUE                           
C26509               SET HAVE-UTG     TO TRUE                           
TP8668           ELSE                                                   
TP8668               IF U7-RCNCT-ELEC-SVC-FL = 'Y'                      
TP8668                   SET ZERO-NO2 TO TRUE                           
C26509                   SET HAVE-UTE     TO TRUE                       
TP8668               END-IF                                             
TP8668               IF U7-RCNCT-GAS-SVC-FL = 'Y'                       
TP8668                   SET ZERO-NO2 TO TRUE                           
C26509                   SET HAVE-UTG     TO TRUE                       
TP8668               END-IF                                             
TP8668           END-IF                                                 
PCR212     END-IF.                                                      
                                                                        
      * GET-AR-LATEST-TRANS.                                            15530000
                                                                        
           PERFORM 7210-OPEN-AR-CURSOR           THRU 7210-EXIT.        
           PERFORM 7250-FETCH-AR-CURSOR          THRU 7250-EXIT         
              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
                 OR CURSOR-ROWS > 3.                                    
           PERFORM 7290-CLOSE-AR-CURSOR          THRU 7290-EXIT.        
                                                                        
      * GET-AR-CNTL-INFO.                                               15610000
                                                                        
           MOVE L5-PYMT-PRIORITY-LVL TO RS-PYMT-PRIORITY-LVL.           
           SET DIST-RECV-TYPE-CNT    TO W-LT-ONE.                       
                                                                        
           PERFORM 7110-OPEN-AC-CURSOR      THRU 7110-EXIT.             
           PERFORM 5000-GET-AR-CNTL-INFO THRU 5000-EXIT                 
              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                  
           PERFORM 7190-CLOSE-AC-CURSOR     THRU 7190-EXIT.             
                                                                        
           MOVE DIST-RECV-TABLE      TO RS-DIST-RECV-TYPES.             
                                                                        
                                                                        
           IF RECORD-FOUND                                              
              MOVE SUCCESSFUL-CALL         TO RS-RETURN-CODE            
           ELSE                                                         
              MOVE NOT-FOUND               TO RS-RETURN-CODE            
           END-IF.                                                      
                                                                        
T17842     IF PARM-ITEM-ID = 0 AND PARM-RECV-TYPE = CREDIT-RCC          
              EXEC SQL                                                  
                SELECT COUNT(*)                                         
                INTO   :WS-RCC-ROWS                                     
                FROM   CSS_AR_CNTL WITH(READUNCOMMITTED)                        
                WHERE ACCOUNT_NO = :AC-ACCOUNT-NO                       
                AND   PYMT_PRIORITY_LVL = 60                            
                AND   ITEM_ID > 0                                       
T35434                                                           
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*       EXEC SQL                                                          
MFA-TR*         SELECT COUNT(*)                                                 
MFA-TR*         INTO   :WS-RCC-ROWS                                             
MFA-TR*         FROM   CSS_AR_CNTL                                              
MFA-TR*         WHERE ACCOUNT_NO = :AC-ACCOUNT-NO                               
MFA-TR*         AND   PYMT_PRIORITY_LVL = 60                                    
MFA-TR*         AND   ITEM_ID > 0                                               
MFA-TR*         WITH UR                                                         
MFA-TR*       END-EXEC                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              IF SQLCODE = SUCCESSFUL-CALL                              
                CONTINUE                                                
              ELSE                                                      
                IF SQLCODE = NOT-FOUND                                  
                   GO TO 2200-EXIT                                      
                ELSE                                                    
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '2200'               TO ACTIVE-PARAGRAPH        
                   MOVE 'SELECT'             TO ABEND-FUNCTION          
                   MOVE 'CSS_AR_CNTL'        TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
                   MOVE AC-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
                END-IF                                                  
              END-IF                                                    
              EXEC SQL                                                  
                 SELECT AMT_AR_DAY_00                                   
                       ,AMT_AR_DAY_30                                   
                       ,AMT_AR_DAY_60                                   
                       ,AMT_AR_DAY_90                                   
                       ,AMT_TRAN_BALANCE                                
                       ,REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                       ,ITEM_ID                                         
                 INTO  :AC-AMT-AR-DAY-00,                               
                       :AC-AMT-AR-DAY-30,                               
                       :AC-AMT-AR-DAY-60,                               
                       :AC-AMT-AR-DAY-90,                               
                       :AC-AMT-TRAN-BALANCE,                            
                       :AC-LAST-UPDATE-TS,                              
                       :AC-ITEM-ID                                      
                 FROM   CSS_AR_CNTL WITH(READUNCOMMITTED)                       
                 WHERE  ACCOUNT_NO  = :AC-ACCOUNT-NO                    
                 AND    PYMT_PRIORITY_LVL = 60                          
                 AND    ITEM_ID > 0                                     
T35434                                                           
              END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*       EXEC SQL                                                          
MFA-TR*          SELECT AMT_AR_DAY_00                                           
MFA-TR*                ,AMT_AR_DAY_30                                           
MFA-TR*                ,AMT_AR_DAY_60                                           
MFA-TR*                ,AMT_AR_DAY_90                                           
MFA-TR*                ,AMT_TRAN_BALANCE                                        
MFA-TR*                ,LAST_UPDATE_TS                                          
MFA-TR*                ,ITEM_ID                                                 
MFA-TR*          INTO  :AC-AMT-AR-DAY-00,                                       
MFA-TR*                :AC-AMT-AR-DAY-30,                                       
MFA-TR*                :AC-AMT-AR-DAY-60,                                       
MFA-TR*                :AC-AMT-AR-DAY-90,                                       
MFA-TR*                :AC-AMT-TRAN-BALANCE,                                    
MFA-TR*                :AC-LAST-UPDATE-TS,                                      
MFA-TR*                :AC-ITEM-ID                                              
MFA-TR*          FROM   CSS_AR_CNTL                                             
MFA-TR*          WHERE  ACCOUNT_NO  = :AC-ACCOUNT-NO                            
MFA-TR*          AND    PYMT_PRIORITY_LVL = 60                                  
MFA-TR*          AND    ITEM_ID > 0                                             
MFA-TR*          WITH UR                                                        
MFA-TR*       END-EXEC                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              IF SQLCODE = SUCCESSFUL-CALL                              
                 MOVE AC-ITEM-ID        TO RS-ITEM-ID                   
                 MOVE AC-AMT-AR-DAY-00  TO RS-AMT-AR-DAY-00             
                 MOVE AC-AMT-AR-DAY-30  TO RS-AMT-AR-DAY-30             
                 MOVE AC-AMT-AR-DAY-60  TO RS-AMT-AR-DAY-60             
                 MOVE AC-AMT-AR-DAY-90  TO RS-AMT-AR-DAY-90             
                 MOVE AC-LAST-UPDATE-TS TO RS-AC-LAST-UPDATE-TS         
                 MOVE AC-AMT-TRAN-BALANCE TO RS-AMT-TRAN-BALANCE        
              ELSE                                                      
                 IF SQLCODE = NOT-FOUND                                 
                   CONTINUE                                             
                 ELSE                                                   
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '2200'               TO ACTIVE-PARAGRAPH        
                   MOVE 'SELECT'             TO ABEND-FUNCTION          
                   MOVE 'CSS_AR_CNTL'        TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
                   MOVE 'PYMT_PRIORITY_LVL'  TO TABLE-ELEMENT-2         
                   MOVE 'ITEM_ID'            TO TABLE-ELEMENT-3         
                   MOVE AC-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
                   MOVE AC-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-2       
                   MOVE AC-ITEM-ID           TO HOSTVAR-ELEMENT-3       
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
                  END-IF                                                
              END-IF                                                    
T17842     END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************15840000
      *2250-GET-CURRENT-DATE.                                           15850000
      ******************************************************************15860000
       2250-GET-CURRENT-DATE.                                           
                                                                        
           EXEC SQL                                                     
T35434        SELECT
              CIS.CHAR2$DATE(CAST(SYSDATETIMEOFFSET() AS DATE), 'USA')
            INTO
              :WS-CURRENT-DATE            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     15890000
MFA-TR*       SET :WS-CURRENT-DATE = CHAR(CURRENT DATE, USA)            15900000
MFA-TR*    END-EXEC.                                                    15930000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           MOVE SQLCODE                      TO RS-RETURN-CODE.         
                                                                        
T35434     IF SQLCODE = SUCCESSFUL-CALL                                 
              MOVE WS-CURRENT-DATE           TO RS-CURRENT-DATE         
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '2250'                    TO ACTIVE-PARAGRAPH        
T35434        MOVE 'SET'                     TO ABEND-FUNCTION          
CBSI          MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
CBSI          MOVE PARM-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       2250-EXIT.                                                       
           EXIT.                                                        
                                                                        
T17253 2300-OPEN-BILWDW.                                                
                                                                        
           EXEC SQL                                                     
              OPEN BILWDW-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '2300'               TO ACTIVE-PARAGRAPH             
CBSI          MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE 'CSS_BILL_WINDOW'    TO TABLE-1                      
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'DATE_EXTRACT'       TO TABLE-ELEMENT-2              
CBSI          MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1            
CBSI          MOVE WS-BUSINESS-DAY      TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2301-FETCH-BILWDW.                                               
                                                                        
           EXEC SQL                                                     
              FETCH BILWDW-CURSOR                                       
               INTO :BN-REVENUE-MONTH                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-SUB = 1                                             
                 MOVE BN-REVENUE-MONTH     TO WS-REVENUE-MONTH-NUM      
                 MOVE WS-REVENUE-MONTH-NUM TO RS-REVENUE-MONTH-1        
              ELSE                                                      
                 MOVE BN-REVENUE-MONTH     TO WS-REVENUE-MONTH-NUM      
                 MOVE WS-REVENUE-MONTH-NUM TO RS-REVENUE-MONTH-2        
              END-IF                                                    
              ADD     1                TO WS-SUB                        
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE '2301'                TO ACTIVE-PARAGRAPH         
CBSI             MOVE 'FETCH'               TO ABEND-FUNCTION           
                 MOVE 'CSS_BILL_WINDOW'     TO TABLE-1                  
CBSI             MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1          
CBSI             MOVE 'DATE_EXTRACT'        TO TABLE-ELEMENT-2          
CBSI             MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
CBSI             MOVE WS-BUSINESS-DAY       TO HOSTVAR-ELEMENT-2        
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2301-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************15840000
      *2302-CLOSE-BILWDW                                                15850000
      ******************************************************************15860000
       2302-CLOSE-BILWDW.                                               
                                                                        
           EXEC SQL                                                     
              CLOSE BILWDW-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '2302'                TO ACTIVE-PARAGRAPH            
CBSI          MOVE 'CLOSE'               TO ABEND-FUNCTION              
              MOVE 'CSS_BILL_WINDOW'     TO TABLE-1                     
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
CBSI          MOVE 'DATE_EXTRACT'        TO TABLE-ELEMENT-2             
CBSI          MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
CBSI          MOVE WS-BUSINESS-DAY       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
T17253 2302-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************16150000
T17653*2400-CHECK-BUSINESS-DAY                                          15850000
T17653******************************************************************15860000
T17653 2400-CHECK-BUSINESS-DAY.                                         
T17653                                                                  
T17653     EXEC SQL                                                     
T35434       SELECT
              CAST(CAST(SYSDATETIMEOFFSET() AS DATE) AS CHAR(10))
            INTO
              :WS-CURRENT-DATE-DB2              
T17653     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     15890000
MFA-TR*      SET :WS-CURRENT-DATE-DB2 = CHAR(CURRENT DATE)              15900000
MFA-TR*    END-EXEC.                                                    15930000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T17653                                                                  
T17653     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
T17653     MOVE SQLCODE                      TO RS-RETURN-CODE.         
T17653                                                                  
T17653     IF SQLCODE = SUCCESSFUL-CALL                                 
T17653        MOVE WS-CURRENT-DATE-DB2 TO WS-NEW-BUSINESS-DAY           
T17653     ELSE                                                         
T17653        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
T17653        MOVE '2400'                    TO ACTIVE-PARAGRAPH        
T35434        MOVE 'SET'                     TO ABEND-FUNCTION          
CBSI          MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
CBSI          MOVE PARM-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1       
T17653        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
T17653        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
T17653     END-IF.                                                      
T17653     PERFORM  7120-SELECT-BILL-WINDOW THRU 7120-EXIT.             
T17653     MOVE 'N'  TO   WS-REVENUE-EXISTS.                            
T17653     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
T17653        PERFORM 6500-GET-NEXT-BUSINESS-DAY                        
T17653                      THRU 6500-NEXT-BUSINESS-DAY-EXIT            
T17653                UNTIL NEXT-BUSINESS-DAY-FOUND                     
T17653     END-IF.                                                      
T17653     MOVE WS-NEW-BUSINESS-DAY TO WS-BUSINESS-DAY.                 
T17653                                                                  
T17653 2400-EXIT.                                                       
T17653      EXIT.                                                       
      *                                                                 16150000
      ******************************************************************16150000
      *5000-GET-AR-CNTL-INFO.                                           16160000
      ******************************************************************16170000
       5000-GET-AR-CNTL-INFO.                                           
                                                                        
           PERFORM 7150-FETCH-AC-CURSOR THRU 7150-EXIT.                 
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              NEXT SENTENCE                                             
           ELSE                                                         
              IF AC-PYMT-PRIORITY-LVL EQUAL RS-PYMT-PRIORITY-LVL AND    
                 AC-ITEM-ID EQUAL PARM-ITEM-ID                          
TP5247            IF AC-PYMT-PRIORITY-LVL >= 50                         
T12630               MOVE AC-AMT-TRAN-BALANCE TO RS-AMT-TRAN-BALANCE    
TP5247            ELSE                                                  
T12630               MOVE ZEROES              TO RS-AMT-TRAN-BALANCE    
TP5247            END-IF                                                
                  MOVE AC-AMT-AR-DAY-00  TO RS-AMT-AR-DAY-00            
                  MOVE AC-AMT-AR-DAY-30  TO RS-AMT-AR-DAY-30            
                  MOVE AC-AMT-AR-DAY-60  TO RS-AMT-AR-DAY-60            
                  MOVE AC-AMT-AR-DAY-90  TO RS-AMT-AR-DAY-90            
                  MOVE AC-LAST-UPDATE-TS TO RS-AC-LAST-UPDATE-TS        
              ELSE                                                      
                 IF AC-PYMT-PRIORITY-LVL NOT EQUAL PREV-PYMT-PRI-LVL    
                    MOVE AC-PYMT-PRIORITY-LVL                           
                      TO DIST-RECV-PYMT-PRI-LVL (DIST-RECV-TYPE-CNT)    
                    SET DIST-RECV-TYPE-CNT UP BY W-LT-ONE               
                    MOVE AC-PYMT-PRIORITY-LVL TO PREV-PYMT-PRI-LVL
                 END-IF
              END-IF
           END-IF.     
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
T17653     EXEC SQL                                                     23760000
              INCLUDE CPD0315B                                          23770000
T17653     END-EXEC.                                                    23780000
                                                                        
      ****************************************************************  16460000
      * 7000-SELECT-ACCOUNT                                          *  16470000
      ****************************************************************  16480000
                                                                        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT CIS.CHAR2$DATE(DATE_BILL_DAY_00, 'USA'),                   
                     CIS.CHAR2$DATE(DATE_BILL_DAY_30, 'USA'),                   
                     CIS.CHAR2$DATE(DATE_BILL_DAY_60, 'USA'),                   
                     CIS.CHAR2$DATE(DATE_BILL_DAY_90, 'USA'),                   
                     COMPANY_NO,                                        
                     REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
              INTO  :AT-DATE-BILL-DAY-00 :WS-NULL-DATE-BILL-DAY-00,      
                    :AT-DATE-BILL-DAY-30 :WS-NULL-DATE-BILL-DAY-30,      
                    :AT-DATE-BILL-DAY-60 :WS-NULL-DATE-BILL-DAY-60,      
                    :AT-DATE-BILL-DAY-90 :WS-NULL-DATE-BILL-DAY-90,      
                    :AT-COMPANY-NO,                                     
                    :AT-LAST-UPDATE-TS                                  
              FROM   CSS_ACCOUNT WITH(READUNCOMMITTED)                          
              WHERE  ACCOUNT_NO   = :AT-ACCOUNT-NO                      
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     16520000
MFA-TR*       SELECT CHAR(DATE_BILL_DAY_00, USA),                       16530000
MFA-TR*              CHAR(DATE_BILL_DAY_30, USA),                       16540000
MFA-TR*              CHAR(DATE_BILL_DAY_60, USA),                       16550000
MFA-TR*              CHAR(DATE_BILL_DAY_90, USA),                       16560000
MFA-TR*              COMPANY_NO,                                        16570000
MFA-TR*              LAST_UPDATE_TS                                     16580000
MFA-TR*       INTO  :AT-DATE-BILL-DAY-00:WS-NULL-DATE-BILL-DAY-00,      16590000
MFA-TR*             :AT-DATE-BILL-DAY-30:WS-NULL-DATE-BILL-DAY-30,      16600000
MFA-TR*             :AT-DATE-BILL-DAY-60:WS-NULL-DATE-BILL-DAY-60,      16610000
MFA-TR*             :AT-DATE-BILL-DAY-90:WS-NULL-DATE-BILL-DAY-90,      16620000
MFA-TR*             :AT-COMPANY-NO,                                     16630000
MFA-TR*             :AT-LAST-UPDATE-TS                                  16640000
MFA-TR*       FROM   CSS_ACCOUNT                                        16650000
MFA-TR*       WHERE  ACCOUNT_NO   = :AT-ACCOUNT-NO                      16660000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    16670000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7000'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCOUNT'        TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
T21170 7100-SELECT-RECONNECT.                                           
T21170*                                                                         
T21170     EXEC SQL                                                     
T21170         SELECT  'Y'                                              
T21170           INTO  :WS-RECONNECT-EXISTS                             
T21170           FROM  CSS_RECONNECT WITH(READUNCOMMITTED)                      
T21170          WHERE  ACCOUNT_NO        = :DL-ACCOUNT-NO               
T21170            AND  AMT_TOT_RECONNECT > 0                            
T35434                                                           
T21170     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  'Y'                                                      
MFA-TR*          INTO  :WS-RECONNECT-EXISTS                                     
MFA-TR*          FROM  CSS_RECONNECT                                            
MFA-TR*         WHERE  ACCOUNT_NO        = :DL-ACCOUNT-NO                       
MFA-TR*           AND  AMT_TOT_RECONNECT > 0                                    
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    16690000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21170                                                                  
T21170     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
T21170     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
T21170         NEXT SENTENCE                                            
T21170     ELSE                                                         
T21170         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
T21170         MOVE '7100'               TO ACTIVE-PARAGRAPH            
T21170         MOVE 'SELECT'             TO ABEND-FUNCTION              
T21170         MOVE 'CSS_RECONNECT'      TO TABLE-1                     
T21170         MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
T21170         MOVE DL-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
T21170         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
T21170         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
T21170     END-IF.                                                      
T21170                                                                  
T21170 7100-EXIT.                                                       
T21170     EXIT.                                                        
                                                                        
      ******************************************************************16880000
      * 7110-OPEN-AC-CURSOR                                            *16890000
      ******************************************************************16900000
       7110-OPEN-AC-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
              OPEN AC-CURSOR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME     TO ABEND-PROGRAM                    
              MOVE '7110'           TO ACTIVE-PARAGRAPH                 
CBSI          MOVE 'OPEN'           TO ABEND-FUNCTION                   
              MOVE 'CSS_AR_CNTL'    TO TABLE-1                          
CBSI          MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1                  
CBSI          MOVE AC-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1                
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
T17653******************************************************************16880000
T17653* 7120-SELECT-BILL-WINDOW                                        *16890000
T17653******************************************************************16900000
T17653 7120-SELECT-BILL-WINDOW.                                         
T17653                                                                  
T17653     EXEC SQL                                                     
T17653      SELECT TOP(1) 'Y'                                                  
T17653        INTO :WS-REVENUE-EXISTS                                   
T17653        FROM CSS_BILL_WINDOW                                      
T17653      WHERE DATE_EXTRACT = CAST(SYSDATETIMEOFFSET() AS DATE)              
T35434                                              
T17653     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     16930000
MFA-TR*     SELECT 'Y'                                                  16940000
MFA-TR*       INTO :WS-REVENUE-EXISTS                                   16940000
MFA-TR*       FROM CSS_BILL_WINDOW                                      16940000
MFA-TR*     WHERE DATE_EXTRACT = CURRENT DATE                                   
MFA-TR*     FETCH FIRST ROW ONLY                                                
MFA-TR*    END-EXEC.                                                    16950000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T17653                                                                  
T17653     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T17653                                                                  
T17653     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
T17653        NEXT SENTENCE                                             
T17653     ELSE                                                         
T17653        MOVE PROGRAM-NAME       TO ABEND-PROGRAM                  
T17653        MOVE '7120'             TO ACTIVE-PARAGRAPH               
T17653        MOVE 'SELECT        '   TO ABEND-FUNCTION                 
T17653        MOVE 'CSS_BILL_WINDOW'  TO TABLE-1                        
CBSI          MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1                
CBSI          MOVE PARM-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1              
T17653        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T17653        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T17653     END-IF.                                                      
T17653                                                                  
T17653 7120-EXIT.                                                       
T17653     EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************17140000
      * 7150-FETCH-AC-CURSOR                                           *17150000
      ******************************************************************17160000
                                                                        
       7150-FETCH-AC-CURSOR.                                            
                                                                        
           ADD W-LT-ONE TO CURSOR-ROWS.                                 
                                                                        
           EXEC SQL                                                     
              FETCH AC-CURSOR                                           
               INTO :AC-PYMT-PRIORITY-LVL,                              
                    :AC-ITEM-ID,                                        
                    :AC-AMT-AR-DAY-00,                                  
                    :AC-AMT-AR-DAY-30,                                  
                    :AC-AMT-AR-DAY-60,                                  
                    :AC-AMT-AR-DAY-90,                                  
                    :AC-LAST-UPDATE-TS,                                 
TP5247              :AC-AMT-TRAN-BALANCE                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE 'Y' TO WS-RECORD-FOUND-FLAG                       
              ELSE                                                      
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE '7150'               TO ACTIVE-PARAGRAPH          
CBSI             MOVE 'FETCH'              TO ABEND-FUNCTION            
                 MOVE 'CSS_AR_CNTL'        TO TABLE-1                   
                 MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1           
                 MOVE AC-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1         
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
              END-IF
           END-IF.         
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************17590000
      * 7190-CLOSE-AC-CURSOR                                           *17600000
      ******************************************************************17610000
       7190-CLOSE-AC-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
              CLOSE AC-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME      TO ABEND-PROGRAM                   
              MOVE '7190'            TO ACTIVE-PARAGRAPH                
CBSI          MOVE 'CLOSE'           TO ABEND-FUNCTION                  
              MOVE 'CSS_AR_CNTL'     TO TABLE-1                         
CBSI          MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1                 
CBSI          MOVE AC-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1               
CBSI          PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
CBSI          PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7190-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************17830000
      * 7210-OPEN-AR-CURSOR                                            *17840000
      ******************************************************************17850000
       7210-OPEN-AR-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
              OPEN AR-CURSOR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7210'               TO ACTIVE-PARAGRAPH             
CBSI          MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE 'CSS_AR_TRANS_HIST'  TO TABLE-1                      
CBSI          MOVE 'CSS_AR_TRN_HST_DET' TO TABLE-2                      
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'GL_ACCT_CREDIT'     TO TABLE-ELEMENT-2              
CBSI          MOVE 'GL_ACCT_DEBIT'      TO TABLE-ELEMENT-3              
CBSI          MOVE AR-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE RS-GL-ACCT-NO        TO WS-GL-ACCT-NO-CNVRT          
CBSI          MOVE WS-GL-ACCT-NO-CNVRT  TO HOSTVAR-ELEMENT-2            
CBSI          MOVE RS-GL-ACCT-NO2       TO WS-GL-ACCT-NO-CNVRT          
CBSI          MOVE WS-GL-ACCT-NO-CNVRT  TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************18090000
      * 7250-FETCH-AR-CURSOR                                           *18100000
      ******************************************************************18110000
                                                                        
       7250-FETCH-AR-CURSOR.                                            
                                                                        
           ADD W-LT-ONE TO CURSOR-ROWS.                                 
                                                                        
TP8668     EXEC SQL                                                     
TP8668        FETCH AR-CURSOR                                           
TP8668         INTO :AR-TRANS-HIST-SEQ-NO,                              
TP8668              :AU-AMT-POSTED,                                     
T15312              :AU-GL-ACCT-CREDIT,                                 
T15312              :AU-GL-ACCT-DEBIT                                   
TP8668     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              IF CURSOR-ROWS = W-LT-ONE                                 
                 MOVE SPACES                TO RS-DATE-TRANS1           
                 MOVE ZEROES                TO RS-AMT-TRANS1            
                 MOVE SPACES                TO RS-DATE-TRANS2           
                 MOVE ZEROES                TO RS-AMT-TRANS2            
                 MOVE SPACES                TO RS-DATE-TRANS3           
                 MOVE ZEROES                TO RS-AMT-TRANS3            
                 MOVE SPACES                TO RS-DATE-TRANS4           
                 MOVE ZEROES                TO RS-AMT-TRANS4            
              ELSE IF CURSOR-ROWS = 2                                   
                 MOVE SPACES                TO RS-DATE-TRANS2           
                 MOVE ZEROES                TO RS-AMT-TRANS2            
                 MOVE SPACES                TO RS-DATE-TRANS3           
                 MOVE ZEROES                TO RS-AMT-TRANS3            
                 MOVE SPACES                TO RS-DATE-TRANS4           
                 MOVE ZEROES                TO RS-AMT-TRANS4            
              ELSE IF CURSOR-ROWS = 3                                   
                 MOVE SPACES                TO RS-DATE-TRANS3           
                 MOVE ZEROES                TO RS-AMT-TRANS3            
                 MOVE SPACES                TO RS-DATE-TRANS4           
                 MOVE ZEROES                TO RS-AMT-TRANS4            
              ELSE IF CURSOR-ROWS = 4                                   
                 MOVE SPACES                TO RS-DATE-TRANS4           
                 MOVE ZEROES                TO RS-AMT-TRANS4            
              END-IF
                   END-IF
                   END-IF
              END-IF                                                    
           ELSE IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
TP8668        MOVE AR-TRANS-HIST-SEQ-NO (6:2) TO FORMATTED-MONTH        
TP8668        MOVE AR-TRANS-HIST-SEQ-NO (9:2) TO FORMATTED-DAY          
TP8668        MOVE AR-TRANS-HIST-SEQ-NO (1:4) TO FORMATTED-YEAR         
TP8668        MOVE WS-FORMATTED-DATE TO AR-DATE-TRANS                   
TP8668        MOVE 'Y' TO WS-RECORD-FOUND-FLAG                          
TP8668        IF CURSOR-ROWS = W-LT-ONE                                 
TP8668           MOVE AR-DATE-TRANS TO RS-DATE-TRANS1                   
T15312           MOVE AU-AMT-POSTED       TO RS-AMT-TRANS1              
T15312           IF RS-GL-ACCT-NO = AU-GL-ACCT-DEBIT                    
T15312            OR RS-GL-ACCT-NO2 = AU-GL-ACCT-DEBIT                  
T15312               COMPUTE RS-AMT-TRANS1 = RS-AMT-TRANS1 * -1         
T15312               END-COMPUTE                                        
T15312           END-IF                                                 
TP8668        ELSE IF CURSOR-ROWS = 2                                   
TP8668           MOVE AR-DATE-TRANS TO RS-DATE-TRANS2                   
T15312           MOVE AU-AMT-POSTED       TO RS-AMT-TRANS2              
T15312           IF RS-GL-ACCT-NO = AU-GL-ACCT-DEBIT                    
T15312            OR RS-GL-ACCT-NO2 = AU-GL-ACCT-DEBIT                  
T15312               COMPUTE RS-AMT-TRANS2 = RS-AMT-TRANS2 * -1         
T15312               END-COMPUTE                                        
T15312           END-IF                                                 
TP8668        ELSE IF CURSOR-ROWS = 3                                   
TP8668           MOVE AR-DATE-TRANS TO RS-DATE-TRANS3                   
T15312           MOVE AU-AMT-POSTED       TO RS-AMT-TRANS3              
T15312           IF RS-GL-ACCT-NO = AU-GL-ACCT-DEBIT                    
T15312            OR RS-GL-ACCT-NO2 = AU-GL-ACCT-DEBIT                  
T15312               COMPUTE RS-AMT-TRANS3 = RS-AMT-TRANS3 * -1         
T15312               END-COMPUTE                                        
T15312           END-IF                                                 
TP8668        ELSE IF CURSOR-ROWS = 4                                   
TP8668           MOVE AR-DATE-TRANS TO RS-DATE-TRANS4                   
T15312           MOVE AU-AMT-POSTED       TO RS-AMT-TRANS4              
T15312           IF RS-GL-ACCT-NO = AU-GL-ACCT-DEBIT                    
T15312            OR RS-GL-ACCT-NO2 = AU-GL-ACCT-DEBIT                  
T15312               COMPUTE RS-AMT-TRANS4 = RS-AMT-TRANS4 * -1         
T15312               END-COMPUTE                                        
T15312           END-IF                                                 
TP8668        END-IF
                   END-IF
                   END-IF
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7250'               TO ACTIVE-PARAGRAPH             
CBSI          MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'CSS_AR_TRANS_HIST'  TO TABLE-1                      
              MOVE 'CSS_AR_TRN_HST_DET' TO TABLE-2                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'GL_ACCT_CREDIT'     TO TABLE-ELEMENT-2              
CBSI          MOVE 'GL_ACCT_DEBIT'      TO TABLE-ELEMENT-3              
              MOVE AR-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE RS-GL-ACCT-NO        TO WS-GL-ACCT-NO-CNVRT          
CBSI          MOVE WS-GL-ACCT-NO-CNVRT  TO HOSTVAR-ELEMENT-2            
CBSI          MOVE RS-GL-ACCT-NO2       TO WS-GL-ACCT-NO-CNVRT          
              MOVE WS-GL-ACCT-NO-CNVRT  TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************18940000
      * 7290-CLOSE-AR-CURSOR                                           *18950000
      ******************************************************************18960000
       7290-CLOSE-AR-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
              CLOSE AR-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7290'               TO ACTIVE-PARAGRAPH             
CBSI          MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE 'CSS_AR_TRANS_HIST'  TO TABLE-1                      
CBSI          MOVE 'CSS_AR_TRN_HST_DET' TO TABLE-2                      
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'GL_ACCT_CREDIT'     TO TABLE-ELEMENT-2              
CBSI          MOVE 'GL_ACCT_DEBIT'      TO TABLE-ELEMENT-3              
CBSI          MOVE AR-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE RS-GL-ACCT-NO        TO WS-GL-ACCT-NO-CNVRT          
CBSI          MOVE WS-GL-ACCT-NO-CNVRT  TO HOSTVAR-ELEMENT-2            
CBSI          MOVE RS-GL-ACCT-NO2       TO WS-GL-ACCT-NO-CNVRT          
CBSI          MOVE WS-GL-ACCT-NO-CNVRT  TO HOSTVAR-ELEMENT-3            
CBSI          PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
CBSI          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7290-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ****************************************************************  19180000
      * 7300-SELECT-AR-TYPE                                             19190000
      ****************************************************************  19200000
                                                                        
       7300-SELECT-AR-TYPE.                                             
                                                                        
           EXEC SQL                                                     
              SELECT PYMT_PRIORITY_LVL                                  
              INTO  :L5-PYMT-PRIORITY-LVL                               
              FROM   CSS_AR_TYPE WITH(READUNCOMMITTED)                          
              WHERE  AR_TYPE_SHORT_DESC = :PARM-RECV-TYPE               
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     19240000
MFA-TR*       SELECT PYMT_PRIORITY_LVL                                  19250000
MFA-TR*       INTO  :L5-PYMT-PRIORITY-LVL                               19260000
MFA-TR*       FROM   CSS_AR_TYPE                                        19270000
MFA-TR*       WHERE  AR_TYPE_SHORT_DESC = :PARM-RECV-TYPE               19280000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    19290000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7300'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_AR_TYPE'        TO TABLE-1                      
CBSI          MOVE 'AR_TYPE_SHORT_DESC' TO TABLE-ELEMENT-1              
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE PARM-RECV-TYPE       TO HOSTVAR-ELEMENT-1            
CBSI          MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ****************************************************************  19500000
      * 7400-SELECT-AR-LOCKOUT                                       *  19510000
      ****************************************************************  19520000
       7400-SELECT-AR-LOCKOUT.                                          
                                                                        
           EXEC SQL                                                     
              SELECT AR_LOCKOUT_IND                                     
              INTO  :AL-AR-LOCKOUT-IND                                  
              FROM   CSS_AR_LOCKOUT WITH(READUNCOMMITTED)                       
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     19550000
MFA-TR*       SELECT AR_LOCKOUT_IND                                     19560000
MFA-TR*       INTO  :AL-AR-LOCKOUT-IND                                  19570000
MFA-TR*       FROM   CSS_AR_LOCKOUT                                     19580000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    19590000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7400'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_AR_LOCKOUT'     TO TABLE-1                      
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
T30124*****************************************************************         
T30124* 7450-GET-DATABASE                                             *         
T30124*     DISTINGUISHES WHETHER SEB OR CSR DATABASE                 *         
T30124*****************************************************************         
T30124 7450-GET-DATABASE.                                               
T30124*                                                                         
T30124     EXEC SQL                                                     
T30124        SELECT DELINQ_VALUE                                       
T30124          INTO :C8-DELINQ-VALUE                                   
T30124          FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
T30124         WHERE DELINQ_CD  = :C8-DELINQ-CD                         
T30124           AND COMPANY_NO = :AT-COMPANY-NO                        
T35434                                                           
T30124     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                                 
MFA-TR*          AND COMPANY_NO = :AT-COMPANY-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T30124*                                                                         
T30124     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
T30124*                                                                 19780000
T30124     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T30124        MOVE C8-DELINQ-VALUE      TO WS-DATABASE                  
T30124     ELSE                                                         
T30124        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
T30124        MOVE '7450'               TO ACTIVE-PARAGRAPH             
T30124        MOVE 'SELECT'             TO ABEND-FUNCTION               
T30124        MOVE 'CSS_DELINQUENCY'    TO TABLE-1                      
T30124        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
T30124        MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1            
T30124        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
T30124        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
T30124     END-IF.                                                      
T30124*                                                                         
T30124 7450-EXIT.                                                       
T30124     EXIT.                                                        
                                                                        
       7500-SELECT-GL-ACCOUNT.                                          
      ****************************************************************  19800000
      * 7500-SELECT-GL-ACCOUNT                                      *   19810000
      ****************************************************************  19820000
                                                                        
           EXEC SQL                                                     
              SELECT GL_ACCT_NO                                         
              INTO  :GO-GL-ACCT-NO                                      
              FROM   CSS_GL_ACCT_NO WITH(READUNCOMMITTED)                       
MCR310*       WHERE  COMPANY_NO   = :GO-COMPANY-NO                      19880000
MCR310        WHERE  COMPANY_NO   = '01'                                
              AND    GL_ACCT_NAME = :GO-GL-ACCT-NAME                    
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     19840000
MFA-TR*       SELECT GL_ACCT_NO                                         19850000
MFA-TR*       INTO  :GO-GL-ACCT-NO                                      19860000
MFA-TR*       FROM   CSS_GL_ACCT_NO                                     19870000
MFA-TR*       WHERE  COMPANY_NO   = :GO-COMPANY-NO                      19880000
MFA-TR*       WHERE  COMPANY_NO   = '01'                                19880000
MFA-TR*       AND    GL_ACCT_NAME = :GO-GL-ACCT-NAME                    19890000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    19900000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7500'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_GL_ACCT_NO'     TO TABLE-1                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 'GL_ACCT_NAME'       TO TABLE-ELEMENT-2              
              MOVE '01'                 TO HOSTVAR-ELEMENT-1            
              MOVE GO-GL-ACCT-NAME      TO HOSTVAR-ELEMENT-2            
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-3              
CBSI          MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************20130000
      *  7600-SELECT-MAX-ITEM-ID                                       *20140000
      *                                                                *20150000
      *  THE FOLLOWING LOGIC DETERMINES THE NEXT AVAILABLE ITEM-ID NBR *20160000
      *  FOR THE GIVEN ACCOUNT NUMBER AND RECEIVABLE                   *20170000
      *                                                                *20180000
      *  NOTE: THIS IS NOT NEEDED FOR PANEL310 - MISC CREDIT B/C MONEY *20190000
      *        CAN ONLY BE CREDITED TO AN EXISTING RECEIVABLE          *20200000
      ******************************************************************20210000
       7600-SELECT-MAX-ITEM-ID.                                         
                                                                        
           EXEC SQL                                                     
               SELECT MAX(ITEM_ID)                                      
               INTO :WS-MAX-ITEM-ID :WS-NULL-INDICATOR                   
               FROM   CSS_AR_CNTL WITH(READUNCOMMITTED)                         
               WHERE  ACCOUNT_NO        = :AC-ACCOUNT-NO                
               AND    PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL         
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     20240000
MFA-TR*        SELECT MAX(ITEM_ID)                                      20250000
MFA-TR*        INTO :WS-MAX-ITEM-ID:WS-NULL-INDICATOR                   20260000
MFA-TR*        FROM   CSS_AR_CNTL                                       20270000
MFA-TR*        WHERE  ACCOUNT_NO        = :AC-ACCOUNT-NO                20280000
MFA-TR*        AND    PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL         20290000
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    20300000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7600'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_AR_CNTL'        TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'PYMT_PRIORITY_LVL'  TO TABLE-ELEMENT-2              
              MOVE AC-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE AC-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  20520000
      * 7700-SELECT-CONTRACT-INFO                                       20530000
      ****************************************************************  20540000
       7700-SELECT-CONTRACT-INFO.                                       
                                                                        
           EXEC SQL                                                     
              SELECT GL_ACCT_NO,                                        
                     REBATE_GL_ACCT_NO                                  
              INTO  :K6-GL-ACCT-NO,                                     
                    :K6-REBATE-GL-ACCT-NO                               
              FROM   CSS_CONTRACT_INFO WITH(READUNCOMMITTED)                    
              WHERE  CNT_NAME_CD = :K6-CNT-NAME-CD                      
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     20570000
MFA-TR*       SELECT GL_ACCT_NO,                                        20580000
MFA-TR*              REBATE_GL_ACCT_NO                                  20590000
MFA-TR*       INTO  :K6-GL-ACCT-NO,                                     20600000
MFA-TR*             :K6-REBATE-GL-ACCT-NO                               20610000
MFA-TR*       FROM   CSS_CONTRACT_INFO                                  20620000
MFA-TR*       WHERE  CNT_NAME_CD = :K6-CNT-NAME-CD                      20630000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    20640000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7700'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_CONTRACT_INFO' TO TABLE-1                       
              MOVE 'CNT_NAME_CD'       TO TABLE-ELEMENT-1               
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE K6-CNT-NAME-CD      TO HOSTVAR-ELEMENT-1             
CBSI          MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
C24880****************************************************************  20520000
C24880* 7770-SELECT-CODE-DFA-DESC                                       20530000
C24880****************************************************************  20540000
C24880 7770-SELECT-CODE-DFA-DESC.                                       
C24880                                                                  
C24880     EXEC SQL                                                     
C24880        SELECT DA.CODE_DFA_DESC                                   
C24880          INTO :DA-CODE-DFA-DESC                                  
C24880          FROM CSS_DFA_ACCT    DA WITH(READUNCOMMITTED)                   
C24880         WHERE DA.ACCOUNT_NO        = :DA-ACCOUNT-NO              
C24880           AND DA.DFA_ITEM_ID       = :DA-DFA-ITEM-ID             
C24880           AND DA.PYMT_PRIORITY_LVL = 90                          
T35434                                                           
C24880     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DA.CODE_DFA_DESC                                           
MFA-TR*         INTO :DA-CODE-DFA-DESC                                          
MFA-TR*         FROM CSS_DFA_ACCT    DA                                         
MFA-TR*        WHERE DA.ACCOUNT_NO        = :DA-ACCOUNT-NO                      
MFA-TR*          AND DA.DFA_ITEM_ID       = :DA-DFA-ITEM-ID                     
MFA-TR*          AND DA.PYMT_PRIORITY_LVL = 90                                  
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C24880                                                                  
C24880     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
C24880                                                                  
C24880     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C24880        NEXT SENTENCE                                             
C24880     ELSE                                                         
C24880        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
C24880        MOVE '7770'              TO ACTIVE-PARAGRAPH              
C24880        MOVE 'SELECT'            TO ABEND-FUNCTION                
C24880        MOVE 'CSS_DFA_ACCT'      TO TABLE-1                       
C24880        MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
C24880        MOVE 'DFA_ITEM_ID'       TO TABLE-ELEMENT-2               
C24880        MOVE DA-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
C24880        MOVE DA-DFA-ITEM-ID      TO HOSTVAR-ELEMENT-2             
C24880        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C24880        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C24880     END-IF.                                                      
C24880                                                                  
C24880 7770-EXIT.                                                       
C24880     EXIT.                                                        
C24880                                                                  
C24880****************************************************************  20520000
C24880* 7775-SELECT-CONN-CHG-GL                                         20530000
C24880****************************************************************  20540000
C24880 7775-SELECT-CONN-CHG-GL.                                         
C24880                                                                  
C24880     EXEC SQL                                                     
C24880        SELECT GL_ACCT_NO                                         
C24880          INTO :Z8-GL-ACCT-NO                                     
C24880          FROM CSS_CHARGE_TYPE WITH(READUNCOMMITTED)                      
C24880         WHERE COMPANY_NO          = :Z8-COMPANY-NO               
C24880           AND CODE_DFA_DESC       = :Z8-CODE-DFA-DESC            
C24880           AND CHARGE_STATUS_CD    = 'A'                          
C24880           AND CHARGE_SEQUENCE_NO IN                              
C24880               (SELECT MAX(CHARGE_SEQUENCE_NO)                    
C24880                  FROM CSS_CHARGE_TYPE WITH(READUNCOMMITTED)              
C24880                 WHERE COMPANY_NO       = :Z8-COMPANY-NO          
C24880                   AND CODE_DFA_DESC    = :Z8-CODE-DFA-DESC       
C24880                   AND CHARGE_STATUS_CD = 'A')                    
T35434                                                           
C24880     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT GL_ACCT_NO                                                 
MFA-TR*         INTO :Z8-GL-ACCT-NO                                             
MFA-TR*         FROM CSS_CHARGE_TYPE                                            
MFA-TR*        WHERE COMPANY_NO          = :Z8-COMPANY-NO                       
MFA-TR*          AND CODE_DFA_DESC       = :Z8-CODE-DFA-DESC                    
MFA-TR*          AND CHARGE_STATUS_CD    = 'A'                                  
MFA-TR*          AND CHARGE_SEQUENCE_NO IN                                      
MFA-TR*              (SELECT MAX(CHARGE_SEQUENCE_NO)                            
MFA-TR*                 FROM CSS_CHARGE_TYPE                                    
MFA-TR*                WHERE COMPANY_NO       = :Z8-COMPANY-NO                  
MFA-TR*                  AND CODE_DFA_DESC    = :Z8-CODE-DFA-DESC               
MFA-TR*                  AND CHARGE_STATUS_CD = 'A')                            
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C24880                                                                  
C24880     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C24880                                                                  
C24880     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C24880        NEXT SENTENCE                                             
C24880     ELSE                                                         
C24880        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
C24880        MOVE '7775'              TO ACTIVE-PARAGRAPH              
C24880        MOVE 'SELECT'            TO ABEND-FUNCTION                
C24880        MOVE 'CSS_CHARGE_TYPE'   TO TABLE-1                       
C24880        MOVE 'CODE_DFA_DESC'     TO TABLE-ELEMENT-1               
C24880        MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-2               
C24880        MOVE Z8-CODE-DFA-DESC    TO HOSTVAR-ELEMENT-1             
C24880        MOVE PARM-ACCOUNT-NO     TO HOSTVAR-ELEMENT-2             
C24880        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C24880        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C24880     END-IF.                                                      
C24880                                                                  
C24880 7775-EXIT.                                                       
C24880     EXIT.                                                        
C24880                                                                  
      ****************************************************************  20840000
      * 7750-SEL-CNT-NAME-CD                                            20850000
      ****************************************************************  20860000
       7750-SEL-CNT-NAME-CD.                                            
                                                                        
           EXEC SQL                                                     
              SELECT K6.GL_ACCT_NO,                                     
                     K6.REBATE_GL_ACCT_NO,                              
                     K6.CNT_NAME_CD,                                    
                     K6.CNT_NAME_DESC                                   
              INTO  :K6-GL-ACCT-NO,                                     
                    :K6-REBATE-GL-ACCT-NO,                              
                    :K6-CNT-NAME-CD,                                    
                    :K6-CNT-NAME-DESC                                   
              FROM   CSS_CONTRACT_INFO K6 WITH(READUNCOMMITTED),                
                     CSS_CONTRACT      CT WITH(READUNCOMMITTED)                 
              WHERE  CT.ACCOUNT_NO        = :AC-ACCOUNT-NO              
               AND   CT.PYMT_PRIORITY_LVL =  100                        
               AND   CT.CNT_ITEM_ID       = :PARM-ITEM-ID               
               AND   K6.CNT_NAME_CD       =  CT.CNT_NAME_CD             
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     20890000
MFA-TR*       SELECT K6.GL_ACCT_NO,                                     20900000
MFA-TR*              K6.REBATE_GL_ACCT_NO,                              20910000
MFA-TR*              K6.CNT_NAME_CD,                                    20920000
MFA-TR*              K6.CNT_NAME_DESC                                   20930000
MFA-TR*       INTO  :K6-GL-ACCT-NO,                                     20940000
MFA-TR*             :K6-REBATE-GL-ACCT-NO,                              20950000
MFA-TR*             :K6-CNT-NAME-CD,                                    20960000
MFA-TR*             :K6-CNT-NAME-DESC                                   20970000
MFA-TR*       FROM   CSS_CONTRACT_INFO K6,                              20980000
MFA-TR*              CSS_CONTRACT      CT                               20990000
MFA-TR*       WHERE  CT.ACCOUNT_NO        = :AC-ACCOUNT-NO              21000000
MFA-TR*        AND   CT.PYMT_PRIORITY_LVL =  100                        21010000
MFA-TR*        AND   CT.CNT_ITEM_ID       = :PARM-ITEM-ID               21020000
MFA-TR*        AND   K6.CNT_NAME_CD       =  CT.CNT_NAME_CD             21030000
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    21040000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7750'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_CONTRACT_INFO' TO TABLE-1                       
              MOVE 'CSS_CONTRACT'      TO TABLE-2                       
CBSI          MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
CBSI          MOVE 'CNT_ITEM_ID'       TO TABLE-ELEMENT-2               
              MOVE PARM-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1             
CBSI          MOVE PARM-ITEM-ID        TO HOSTVAR-ELEMENT-2             
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7750-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************  21240000
      * 7800-OPEN-SEL-UTL-CUR.                                       *  21250000
      ****************************************************************  21260000
       7800-OPEN-SEL-UTL-CUR.                                           
           EXEC SQL                                                     
              OPEN SEL-UTL-CUR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7800'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_UTIL_ENVRNMT'        TO TABLE-1                 
CBSI          MOVE 'CSS_RATE_PLAN_DESC'      TO TABLE-2                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE UT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
       7800-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************  21480000
      * 7810-FETCH-SEL-UTL-CUR.                                      *  21490000
      ****************************************************************  21500000
       7810-FETCH-SEL-UTL-CUR.                                          
           EXEC SQL                                                     
              FETCH SEL-UTL-CUR                                         
              INTO :RS-SECURED-RATE-FL                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7810'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'CSS_UTIL_ENVRNMT'        TO TABLE-1                 
CBSI          MOVE 'CSS_RATE_PLAN_DESC'      TO TABLE-2                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE UT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
       7810-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************  21730000
      * 7820-CLOSE-SEL-UTL-CUR.                                      *  21740000
      ****************************************************************  21750000
       7820-CLOSE-SEL-UTL-CUR.                                          
           EXEC SQL                                                     
              CLOSE SEL-UTL-CUR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7820'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_UTIL_ENVRNMT'        TO TABLE-1                 
CBSI          MOVE 'CSS_RATE_PLAN_DESC'      TO TABLE-2                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE UT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
       7820-EXIT.                                                       
           EXIT.                                                        
                                                                        
PCR212 7910-SELECT-RCC.                                                 
PCR212                                                                  
PCR212     EXEC SQL                                                     
PCR212        SELECT U7.RCNCT_ELEC_SVC_FL,                              
PCR212               U7.RCNCT_GAS_SVC_FL                                
PCR212          INTO :U7-RCNCT-ELEC-SVC-FL,                             
PCR212               :U7-RCNCT-GAS-SVC-FL                               
PCR212          FROM CSS_CONNECT_CHRG   CC WITH(READUNCOMMITTED),               
PCR212               CSS_RECONNECT_CHRG U7 WITH(READUNCOMMITTED)                
PCR212         WHERE CC.ACCOUNT_NO        = :CC-ACCOUNT-NO              
PCR212           AND CC.PYMT_PRIORITY_LVL = :CC-PYMT-PRIORITY-LVL       
PCR212           AND CC.CCC_ITEM_ID       = :CC-CCC-ITEM-ID             
PCR212           AND U7.COMPANY_NO        = :U7-COMPANY-NO              
PCR212           AND CC.RCNCT_TYPE_NO     = U7.RCNCT_TYPE_NO            
T23235           AND U7.RCNCT_ACCT_TYPE_CD = :WS-ACCT-TYPE-CD           
T35434                                                           
PCR212     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     22000000
MFA-TR*       SELECT U7.RCNCT_ELEC_SVC_FL,                              22010000
MFA-TR*              U7.RCNCT_GAS_SVC_FL                                22020000
MFA-TR*         INTO :U7-RCNCT-ELEC-SVC-FL,                             22030000
MFA-TR*              :U7-RCNCT-GAS-SVC-FL                               22040000
MFA-TR*         FROM CSS_CONNECT_CHRG   CC,                             22050000
MFA-TR*              CSS_RECONNECT_CHRG U7                              22060000
MFA-TR*        WHERE CC.ACCOUNT_NO        = :CC-ACCOUNT-NO              22070000
MFA-TR*          AND CC.PYMT_PRIORITY_LVL = :CC-PYMT-PRIORITY-LVL       22080000
MFA-TR*          AND CC.CCC_ITEM_ID       = :CC-CCC-ITEM-ID             22090000
MFA-TR*          AND U7.COMPANY_NO        = :U7-COMPANY-NO              22100000
MFA-TR*          AND CC.RCNCT_TYPE_NO     = U7.RCNCT_TYPE_NO            22110000
MFA-TR*          AND U7.RCNCT_ACCT_TYPE_CD = :WS-ACCT-TYPE-CD                   
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    22120000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PCR212                                                                  
PCR212     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
PCR212                                                                  
PCR212     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
PCR212         NEXT SENTENCE                                            
PCR212     ELSE                                                         
PCR212         MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE         
PCR212         MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
PCR212         MOVE '7910'                    TO ACTIVE-PARAGRAPH       
PCR212         MOVE 'SELECT'                  TO ABEND-FUNCTION         
PCR212         MOVE 'CSS_CONNECT_CHRG'        TO TABLE-1                
PCR212         MOVE 'CSS_RECONNECT_CHRG'      TO TABLE-2                
PCR212         MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
PCR212         MOVE 'PYMT_PRIORITY_LVL'       TO TABLE-ELEMENT-2        
PCR212         MOVE 'CCC_ITEM_ID'             TO TABLE-ELEMENT-3        
CBSI           MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-4        
PCR212         MOVE CC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
PCR212         MOVE CC-PYMT-PRIORITY-LVL      TO HOSTVAR-ELEMENT-2      
PCR212         MOVE CC-CCC-ITEM-ID            TO HOSTVAR-ELEMENT-3      
CBSI           MOVE U7-COMPANY-NO             TO HOSTVAR-ELEMENT-4      
PCR212         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
PCR212         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
PCR212     END-IF.                                                      
PCR212                                                                  
PCR212 7910-EXIT.                                                       
PCR212     EXIT.                                                        
PCR212                                                                  
T25607 7920-GET-ACCOUNT-TYPE-CD.                                        
T25607                                                                  
T25607     EXEC SQL                                                     
T25607        SELECT AT.ACCOUNT_TYPE_CODE                               
T25607          INTO :AT-ACCOUNT-TYPE-CODE                              
T25607          FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
T25607         WHERE AT.ACCOUNT_NO        = :CC-ACCOUNT-NO              
T25607                                                           
T25607     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     22000000
MFA-TR*       SELECT AT.ACCOUNT_TYPE_CODE                               22010000
MFA-TR*         INTO :AT-ACCOUNT-TYPE-CODE                              22030000
MFA-TR*         FROM CSS_ACCOUNT AT                                     22050000
MFA-TR*        WHERE AT.ACCOUNT_NO        = :CC-ACCOUNT-NO              22070000
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    22120000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T25607                                                                  
T25607     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T25607                                                                  
T25607     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T25607         NEXT SENTENCE                                            
T25607     ELSE                                                         
T25607         MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE         
T25607         MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
T25607         MOVE '7920'                    TO ACTIVE-PARAGRAPH       
T25607         MOVE 'SELECT'                  TO ABEND-FUNCTION         
T25607         MOVE 'CSS_ACCOUNT     '        TO TABLE-1                
T25607         MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
T25607         MOVE CC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
T25607         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
T25607         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
T25607     END-IF.                                                      
T25607                                                                  
T25607 7920-GET-ACCOUNT-TYPE-CD-EXIT.                                   
T25607     EXIT.                                                        
T25607                                                                  
PCR212 7920-OPEN-UTIL-CURSOR.                                           
PCR212                                                                  
PCR212     EXEC SQL                                                     
PCR212        OPEN UTIL-CURSOR                                          
PCR212     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PCR212                                                                  
PCR212     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
PCR212                                                                  
PCR212     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
PCR212         NEXT SENTENCE                                            
PCR212     ELSE                                                         
PCR212         MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
PCR212         MOVE '7920'                    TO ACTIVE-PARAGRAPH       
PCR212         MOVE 'OPEN'                    TO ABEND-FUNCTION         
CBSI           MOVE 'CSS_UTIL_ENVRNMT'        TO TABLE-1                
CBSI           MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
CBSI           MOVE UT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
PCR212         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
PCR212         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
PCR212     END-IF.                                                      
PCR212                                                                  
PCR212 7920-EXIT.                                                       
PCR212     EXIT.                                                        
PCR212                                                                  
PCR212 7930-FETCH-UTIL-CURSOR.                                          
PCR212                                                                  
PCR212     EXEC SQL                                                     
PCR212        FETCH UTIL-CURSOR                                         
PCR212         INTO :UT-CODE-UTIL-TYPE,                                 
PCR212              :UT-IC-NO                                           
PCR212     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PCR212                                                                  
PCR212     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
PCR212                                                                  
PCR212     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
PCR212         NEXT SENTENCE                                            
PCR212     ELSE                                                         
PCR212         MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
PCR212         MOVE '7930'                    TO ACTIVE-PARAGRAPH       
PCR212         MOVE 'FETCH'                   TO ABEND-FUNCTION         
CBSI           MOVE 'CSS_UTIL_ENVRNMT'        TO TABLE-1                
CBSI           MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
CBSI           MOVE UT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
PCR212         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
PCR212         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
PCR212     END-IF.                                                      
PCR212                                                                  
PCR212 7930-EXIT.                                                       
PCR212     EXIT.                                                        
PCR212                                                                  
PCR212 7940-CLOSE-UTIL-CURSOR.                                          
PCR212                                                                  
PCR212     EXEC SQL                                                     
PCR212        CLOSE UTIL-CURSOR                                         
PCR212     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PCR212                                                                  
PCR212     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
PCR212                                                                  
PCR212     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
PCR212         NEXT SENTENCE                                            
PCR212     ELSE                                                         
PCR212         MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
PCR212         MOVE '7940'                    TO ACTIVE-PARAGRAPH       
PCR212         MOVE 'CLOSE'                   TO ABEND-FUNCTION         
CBSI           MOVE 'CSS_UTIL_ENVRNMT'        TO TABLE-1                
CBSI           MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
CBSI           MOVE UT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
PCR212         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
PCR212         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
PCR212     END-IF.                                                      
PCR212                                                                  
PCR212 7940-EXIT.                                                       
PCR212     EXIT.                                                        
PCR212                                                                  
PCR212 7950-OPEN-UNMTRD-CURSOR.                                         
PCR212                                                                  
PCR212     EXEC SQL                                                     
PCR212        OPEN UNMTRD-CURSOR                                        
PCR212     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PCR212                                                                  
PCR212     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
PCR212                                                                  
PCR212     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
PCR212         NEXT SENTENCE                                            
PCR212     ELSE                                                         
PCR212         MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
PCR212         MOVE '7950'                    TO ACTIVE-PARAGRAPH       
PCR212         MOVE 'OPEN'                    TO ABEND-FUNCTION         
CBSI           MOVE 'CSS_CUST_PLAN'           TO TABLE-1                
CBSI           MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
CBSI           MOVE CP-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
PCR212         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
PCR212         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
PCR212     END-IF.                                                      
PCR212                                                                  
PCR212 7950-EXIT.                                                       
PCR212     EXIT.                                                        
PCR212                                                                  
PCR212 7960-FETCH-UNMTRD-CURSOR.                                        
PCR212                                                                  
PCR212     EXEC SQL                                                     
PCR212        FETCH UNMTRD-CURSOR                                       
PCR212         INTO :CP-CODE-SERVICE-TYPE                               
PCR212     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PCR212                                                                  
PCR212     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
PCR212                                                                  
PCR212     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
PCR212         NEXT SENTENCE                                            
PCR212     ELSE                                                         
PCR212         MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
PCR212         MOVE '7960'                    TO ACTIVE-PARAGRAPH       
PCR212         MOVE 'FETCH'                   TO ABEND-FUNCTION         
CBSI           MOVE 'CSS_CUST_PLAN'           TO TABLE-1                
CBSI           MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
CBSI           MOVE CP-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
PCR212         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
PCR212         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
PCR212     END-IF.                                                      
PCR212                                                                  
PCR212 7960-EXIT.                                                       
PCR212     EXIT.                                                        
PCR212                                                                  
PCR212 7970-CLOSE-UNMTRD-CURSOR.                                        
PCR212                                                                  
PCR212     EXEC SQL                                                     
PCR212        CLOSE UNMTRD-CURSOR                                       
PCR212     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PCR212                                                                  
PCR212     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
PCR212                                                                  
PCR212     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
PCR212         NEXT SENTENCE                                            
PCR212     ELSE                                                         
PCR212         MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
PCR212         MOVE '7970'                    TO ACTIVE-PARAGRAPH       
PCR212         MOVE 'CLOSE'                   TO ABEND-FUNCTION         
CBSI           MOVE 'CSS_CUST_PLAN'           TO TABLE-1                
CBSI           MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
CBSI           MOVE CP-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
PCR212         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
PCR212         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
PCR212     END-IF.                                                      
PCR212                                                                  
PCR212 7970-EXIT.                                                       
PCR212     EXIT.                                                        
PCR212                                                                  
C25674******************************************************************23730000
C25674*7990-GET-AR-CNTL                                                         
C25674*   CHECK IF UTE/UTG ROWS ARE PRESENT IN AR-CNTL TABLE                    
C25674******************************************************************23730000
C25674 7990-GET-AR-CNTL.                                                
C25674     MOVE '7990'                  TO ACTIVE-PARAGRAPH.            
C25674*                                                                 23730000
C25674     EXEC SQL                                                     
C25674        SELECT 'Y'                                                
C25674          INTO :WS-AR-EXISTS                                      
C25674          FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                          
C25674         WHERE ACCOUNT_NO = :AC-ACCOUNT-NO                        
C25674           AND ITEM_ID    = 0                                     
C25674           AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL          
T35434                                                           
C25674     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     23730000
MFA-TR*       SELECT 'Y'                                                23730000
MFA-TR*         INTO :WS-AR-EXISTS                                      23730000
MFA-TR*         FROM CSS_AR_CNTL                                        23730000
MFA-TR*        WHERE ACCOUNT_NO = :AC-ACCOUNT-NO                        23730000
MFA-TR*          AND ITEM_ID    = 0                                     23730000
MFA-TR*          AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL          23730000
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    23730000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C25674*                                                                         
C25674     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
C25674     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
C25674                                 OR NOT-FOUND                     
C25674         NEXT SENTENCE                                            
C25674     ELSE                                                         
C25674        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
C25674        MOVE 'SELECT'             TO ABEND-FUNCTION               
C25674        MOVE 'CSS_AR_CNTL'        TO TABLE-1                      
C25674        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
C25674        MOVE 'PYMT_PRIORITY_LVL'  TO TABLE-ELEMENT-2              
C25674        MOVE AC-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
C25674        MOVE AC-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-2            
C25674        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C25674        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C25674     END-IF.                                                      
C25674*                                                                         
C25674 7990-EXIT.                                                       
C25674     EXIT.                                                        
C25674*                                                                 23730000
      ******************************************************************23730000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     23740000
      ******************************************************************23750000
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************23810000
      *       END PROGRAM COPYLIB                                      *23820000
      ******************************************************************23830000
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPD00321                                                  
REARCH     END-EXEC.                                                            
                                                                        
