       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.     CSR02283.                                        
COB303 DATE-WRITTEN.  DECEMBER 14, 1994                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
      *                                                                *00110000
      *  TRANID:        S283                                           *00120000
      *  PROGRAM:       S283                                           *00130000
      *  CALLING SP:    PA_S283                                        *00140000
      *                                                                *00150000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *  THIS PROCEDURE SELECTS TRANSACTION HISTORY INFORMATION FROM   *00190000
      *  THE CSS_AR_TRN_HST_DET TABLE FOR A SPECIFIED ACCOUNT NUMBER.  *00200000
      ******************************************************************00210000
      *                                                                *00220000
      *                     PROGRAM MODIFICATION LOG                   *00230000
      *                                                                *00240000
      *    DATE    INITIALS   COMMENTS                                 *00250000
      *  --------  --------   ---------------------------------------  *00260000
      *  12/14/94    MRB      PROCEDURE ORIGINALLY CODED.              *00270000
      *    0495      CIF      TPR5068                                  *00280000
      *                       ADD FUNCTIONALITY TO CREATE NSC          *00290000
      *  06/15/95    WMG      1. ADD CWS00061 THAT LOADS THE           *00300000
      *                       MNEUMONICS FOR THE GL NAMES.             *00310000
      *                       2. REPLACED ALL REFERENCED VARIABLES IN  *00320000
      *                       WORKING STORAGE WITH VARIABLES FROM THE  *00330000
      *                       COPYBOOK.                                *00340000
      *                       3. ADDED GL ACCT NUMBER AS A RETURN VALUE*00350000
      *  07/20/95             MODIFIED TO FIX TPR #5764:               *00360000
      *                       1. PARAGRAPH 7300 MODIFIED TO SET THE    *00370000
      *                       GL-ACCT-NO TO 0 WHEN THE MNEUMONIC IS NOT*00380000
      *                       FOUND IN COPYBOOK CWS00061.              *00390000
      *  04/09/96    RTO      PCR047 ADDED SECURED RATE FLAG PROCESSING*00400000
TP5208*  09/03/96    SG       TPR 5208 CHANGED GL-NO TO CHAR TO CORRECT*00410000
TP5208*                       PROBLEM WITH DEC TO CHAR CONVERSION ON   *00420000
TP5208*                       POWERBUILDER.                            *00430000
TP8668*  01/26/97    SG       CHANGED TO RETURN ONLY ONE RESULT ROW FOR*00440000
TP8688*                       EACH EACH TRANSACTION.                   *00450000
TP9263*  02/13/97    PP       READING CSS_DELINQUENCY TABLE FOR        *00460000
TP9263*                       RETRIEVING DELINQ_VALUE FOR DELINQ_CD =  *00470000
TP9263*                       'AMT_CHECKCHARGE'.                       *00480000
CBSI  *  12/07/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *00481002
CBSI  *             MADRAS    ABEND PARAMETERS                         *00482001
T21112*  11/30/99   CBSI      MODIFIED RESULT SET TO SEND LAST-UPDAT-TS*00482102
T21112*             CHENNAI   TO PANEL 309                             *00483002
T22449*  08/02/00   KSB       PANEL TO NOT GIVE -181 IN PARA 7181 FOR  *00482102
T22449*                       PENDING OR BRAND NEW ACCOUNTS            *00483002
T23501*  02/13/01   SFH       ADDED COMPANY_NO TO THE WHERE CLAUSE IN  *        
      *                       PARA 7400 TO SUPPORT MULTI-COMPANY.      *        
      *  04/09/01   CHANELLE  MCR310. CSS_GL_ACCT_NO CHANGES.          *        
C23235*  07/10/01   LEF       ADDED ACCT TYPE CODE TO RESULT SET.      *        
C25452*  10/15/01   SS19371   ADDED CODE TO LOOK  FOR ACCOUNT_TYPE_CODE*        
C25452*                       IN CSS_ACOUNT IF A ROW DOES NOT EXIST    *        
C25452*                       IN CSS_UTIL_ENVRNMNT (AS IS THE CASE FOR *        
C25452*                       PENDING ACCOUNTS)                        *00510000
C26509*  10/10/02   LAT       TO PASS CORRECT VALUE TO THE RESULT SET  *00510000
C26509*                       RS-GAS-ACCOUNT-ONLY                      *00510000
REARCH*  10/20/05   CVNS      RPC TO COBOL SP CONVERSION               *        
REARCH*             CHENNAI                                            *        
A37061*  03/27/09   SJ97149   1.REPLACE CODE_REV_CLASS MID DIGIT CHECK *        
A37061*                         WITH CSS_ACCOUNT.ACCOUNT_TYPE_CODE FOR *        
A37061*                         GETTING TYPE OF THE ACCOUNT.           *        
A37061*                       2.ADDED "ROWSET POSITIONING" FOR GLOBAL  *        
A37061*                         TEMPERARY TABLES.                      *        
A37061*                       3.ADDED "WITH UR" TO SQL STATEMENTS.     *        
P00581*  12/16/11   VV94890   - SCANA ENERGY FEE INCREASE CHGS         *        
P00581*                       FIXED RATE ACCTS WITH AGR EFFECTIVE DATE *        
P00581*                       <= JOB-PARM DT WOULD USE THE OLD VALUE,  *        
P00581*                       REST OF THEM WOULD USE THE NEW CHARGES.  *        
ACT025*  03/13/12   VENKAT P  FIXED ISSUE WHILE POSTING CHARGES OTHER  *        
ACT025*                       NSC OR RCC (APPL00003967)                *        
ACT193*  06/14/16   SS7F226   CHANGED THE WS-Y VARIABLE TO HARD CODE TO*        
ACT193*              A05460   AVOID DUPLICATE DECLARATION IN COPYBOOK  *        
ACT193*                       AND REMOVED THE UNUSED COPYBOOKS.        *        
      ******************************************************************00490000
      ******************************************************************00500000
      *                                                                *00510000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00520000
      *                                                                *00530000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00540000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00550000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00560000
      *  3000 - 4999  NOT USED                                         *00570000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00580000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00590000
      *  7000 - 7999  INPUT MODULES                                    *00600000
      *  8000 - 8999  OUTPUT MODULES                                   *00610000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00620000
      *                                                                *00630000
      ******************************************************************00640000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02283'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                 PIC X(40) VALUE                     
REARCH     'WORKING STORAGE FOR CSR02283 STARTS HERE'.                  
                                                                        
      ******************************************************************00730000
      *    DB2 INCLUDES                                                *00740000
      ******************************************************************00750000
                                                                        
           EXEC SQL                                                     00770000
              INCLUDE SQLCA                                             00780000
           END-EXEC.                                                    00790000
                                                                        
           EXEC SQL                                                     00810000
              INCLUDE TBARHIST                                          00820000
           END-EXEC.                                                    00830000
                                                                        
           EXEC SQL                                                     00850000
              INCLUDE TBARLOCK                                          00860000
           END-EXEC.                                                    00870000
                                                                        
           EXEC SQL                                                     00890000
              INCLUDE TBARHDT                                           00900000
           END-EXEC.                                                    00910000
                                                                        
           EXEC SQL                                                     00930000
              INCLUDE TBUTLENV                                          00940000
           END-EXEC.                                                    00950000
                                                                        
           EXEC SQL                                                     00970000
              INCLUDE TBGLATNO                                          00980000
           END-EXEC.                                                    00990000
                                                                        
           EXEC SQL                                                     01010000
              INCLUDE TBACCT                                            01020000
           END-EXEC.                                                    01030000
                                                                        
           EXEC SQL                                                     01050000
              INCLUDE TBMODEL                                           01060000
           END-EXEC.                                                    01070000
                                                                        
           EXEC SQL                                                     01090000
              INCLUDE TBRTDESC                                          01100000
           END-EXEC.                                                    01110000
                                                                        
TP9263*----<CSS_DELINQUENCY>--------------*                             01130000
TP9263                                                                  
TP9263     EXEC SQL                                                     01150000
TP9263        INCLUDE TBDELQ                                            01160000
TP9263     END-EXEC.                                                    01170000
P00581******************************************************************        
P00581*   CSS_JOB_PARM       - G6                                      *        
P00581******************************************************************        
P00581     EXEC SQL                                                             
P00581        INCLUDE TBJBPARM                                                  
P00581     END-EXEC.                                                            
P00581******************************************************************        
P00581* COBOL DECLARATION FOR TABLE CSS_REG_PROFILE LR            *             
P00581******************************************************************        
P00581     EXEC SQL                                                             
P00581        INCLUDE TBREGPRF                                                  
P00581     END-EXEC.                                                            
                                                                        
      ******************************************************************01190000
      *    COBOL WORKING STORAGE COPY BOOKS                            *01200000
      ******************************************************************01210000
                                                                        
REARCH*                                                                         
REARCH     EXEC SQL                                                             
REARCH          INCLUDE CWSX0010                                                
REARCH     END-EXEC.                                                            
REARCH*                                                                         
           COPY CWS00027.                                               01270000
           COPY CWS00056.                                               01280000
           COPY CWS00303.                                               01290000
                                                                        
WMG695     EXEC SQL                                                     01310000
WMG695        INCLUDE CWS00061                                          01320000
WMG695     END-EXEC.                                                    01330000
      *                                                                 01340000
      ******************************************************************01350000
      *    WORK AREAS                                                  *01360000
      ******************************************************************01370000
                                                                        
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME           PIC X(08) VALUE 'CSR02283'.       
REARCH     05  WS-SQLSTATE            PIC X(05) VALUE SPACES.           
           05  WS-ACCOUNT-NO          PIC 9(13) VALUE ZERO.             
           05  WS-ACCOUNT-NO-NUM      PIC S9(13) COMP-3 VALUE ZERO.     
           05  ALL-DONE-SW            PIC X(01) VALUE 'N'.              
               88 NOT-ALL-DONE                  VALUE 'N'.              
               88 ALL-DONE                      VALUE 'Y'.              
           05  SEND-DONE-SW           PIC X(01) VALUE 'Y'.              
               88 SEND-DONE-ERROR               VALUE 'N'.              
               88 SEND-DONE-OK                  VALUE 'Y'.              
           05  WS-ROWS                PIC S9(9) COMP VALUE 0.           
           05  WS-ROWS-N              PIC S9(9) COMP VALUE 0.           
           05  WS-C                   PIC  X(01) VALUE 'C'.             
           05  WS-D                   PIC  X(01) VALUE 'D'.             
           05  WS-G                   PIC  X(01) VALUE 'G'.             
T26509     05  WS-E                   PIC  X(01) VALUE 'E'.             
           05  WS-U                   PIC  X(01) VALUE 'U'.             
           05  WS-LPC                 PIC  X(03) VALUE 'LPC'.           
           05  WS-LPN                 PIC  X(03) VALUE 'LPN'.           
           05  WS-RCC                 PIC  X(03) VALUE 'RCC'.           
           05  WS-NSC                 PIC  X(03) VALUE 'NSC'.           
P00581     05  WS-CHECKCHARGE         PIC X(20) VALUE 'AMT-CHECKCHARGE'.
P00581     05  WS-OLD-DELINQ-CD       PIC  X(20) VALUE SPACES.          
P00581     05  WS-NEW-DELINQ-CD       PIC  X(20) VALUE SPACES.          
P00581     05  WS-FEE-INCR-DATE       PIC  X(10) VALUE SPACES.          
P00581     05  WS-CURRENT-DATE        PIC  X(10) VALUE SPACES.          
P00581     05  WS-FP                  PIC  X(02) VALUE 'FP'.            
P00581     05  WS-SEB-REGULATED-FL    PIC  X(01) VALUE SPACE.           
P00581     05  WS-DATABASE            PIC  9(01) VALUE 0.               
P00581         88 CSR-DATABASE                   VALUE 1.               
P00581         88 SEB-DATABASE                   VALUE 2.               
WMG695*    05  WS-AR-RCC              PIC  X(10) VALUE 'AR-CCC    '.    01600000
WMG695*    05  WS-AR-LPC              PIC  X(10) VALUE 'AR-LPC    '.    01610000
WMG695*    05  WS-AR-LPN              PIC  X(10) VALUE 'AR-LPN    '.    01620000
WMG695*    05  WS-AR-NSC              PIC  X(10) VALUE 'AR-NSC    '.    01630000
           05  WS-GL-LPC              PIC S9(03)V9(04) COMP-3 VALUE +0. 
           05  WS-GL-LPN              PIC S9(03)V9(04) COMP-3 VALUE +0. 
           05  WS-GL-RCC              PIC S9(03)V9(04) COMP-3 VALUE +0. 
           05  WS-GL-NSC              PIC S9(03)V9(04) COMP-3 VALUE +0. 
TP5208     05  WS-GL-NUMERIC          PIC 9(3).9(4).                    
TP5208     05  WS-GL-CHAR             REDEFINES WS-GL-NUMERIC           
TP5208                                PIC X(8).                         
T26509     05  WS-ELEC-EXISTS         PIC X(1).                         
           05  WS-TIMESTAMP.                                            
               10  WS-TS-DATE.                                          
                   15  WS-TS-YEAR     PIC  X(04).                       
                   15  FILLER         PIC  X(01).                       
                   15  WS-TS-MONTH    PIC  X(02).                       
                   15  FILLER         PIC  X(01).                       
                   15  WS-TS-DAY      PIC  X(02).                       
               10  FILLER             PIC  X(16).                       
           05  WS-FORMATTED-DATE.                                       
               10  FORMATTED-MONTH    PIC  X(02).                       
               10  FILLER             PIC  X(01) VALUE '/'.             
               10  FORMATTED-DAY      PIC  X(02).                       
               10  FILLER             PIC  X(01) VALUE '/'.             
               10  FORMATTED-YEAR     PIC  X(04).                       
P00581 01  WS-CSR04533-OUTPUT.                                          
P00581     05  WS-4533-RETURN-CODE     PIC S9(09) COMP VALUE +0.        
COB305     05 WS-4533-EFF-REV-MTH        PIC S9(06)V USAGE COMP-3 
COB305       VALUE 0.        
P00581     05  WS-4533-CALC-TYPE-CD    PIC X(02) VALUE SPACES.          
P00581     05  WS-4533-OPT-AGR-EFF-DT  PIC X(10) VALUE SPACES.          
      *                                                                 01850000
P00581*01  LOC1                  USAGE IS SQL TYPE IS                   
P00581*                          RESULT-SET-LOCATOR VARYING.            
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  GTT-NAME                PIC X(26) VALUE                  
REARCH                                       'SESSION.CSR02283_R1'.     
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN          PIC S9(04) COMP.                 
REARCH         49 GTT-ROW-CHAR         PIC X(1024).                     
REARCH     05  GTT-SQLCODE             PIC S9(9) COMP.                  
REARCH*                                                                         
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
                                                                        
       01  PARM-FIELDS.                                                 
REARCH     05  PARM-ACCOUNT-NO-TEMP    PIC X(13) VALUE SPACES.          
REARCH     05  PARM-ACCOUNT-NO-RED     REDEFINES PARM-ACCOUNT-NO-TEMP   
REARCH                                 PIC 9(13).                       
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
           05  RS-CHG-DATE              PIC  X(10) VALUE SPACES.        
           05  RS-CHG-AMT               PIC S9(09)V99 COMP-3 VALUE +0.  
           05  RS-CHG-TYPE              PIC  X(03) VALUE SPACES.        
           05  RS-DEBIT-CREDIT-IND      PIC  X(01) VALUE SPACES.        
           05  RS-GAS-ACCOUNT-ONLY      PIC  X(01) VALUE SPACES.        
           05  RS-GL-ACCT-NO            PIC  X(08) VALUE SPACES.        
           05  RS-AR-IND                PIC  X(01) VALUE SPACE.         
           05  RS-SECURED-RATE-FL       PIC  X(01) VALUE SPACE.         
TP9263     05  RS-DELINQ-VALUE PIC S9(4)V9(5) USAGE COMP-3 VALUE +0.    
T21112     05  RS-LAST-UPDATE-TS        PIC  X(26) VALUE SPACES.        
C23235     05  RS-ACCT-TYPE-CD          PIC  X(01) VALUE SPACES.        
REARCH*                                                                 02320000
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE            PIC S9(9) COMP VALUE 0.         
REARCH     05  S-CHG-DATE               PIC  X(10) VALUE SPACES.        
REARCH     05  S-CHG-AMT                PIC S9(09)V99 COMP-3 VALUE +0.  
REARCH     05  S-CHG-TYPE               PIC  X(03) VALUE SPACES.        
REARCH     05  S-DEBIT-CREDIT-IND       PIC  X(01) VALUE SPACES.        
REARCH     05  S-GAS-ACCOUNT-ONLY       PIC  X(01) VALUE SPACES.        
REARCH     05  S-GL-ACCT-NO             PIC  X(08) VALUE SPACES.        
REARCH     05  S-AR-IND                 PIC  X(01) VALUE SPACE.         
REARCH     05  S-SECURED-RATE-FL        PIC  X(01) VALUE SPACE.         
REARCH     05  S-DELINQ-VALUE  PIC S9(4)V9(5) USAGE COMP-3 VALUE +0.    
REARCH     05  S-LAST-UPDATE-TS         PIC  X(26) VALUE SPACES.        
REARCH     05  S-ACCT-TYPE-CD           PIC  X(01) VALUE SPACES.        
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
REARCH     10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
REARCH     10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
REARCH     10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
REARCH         49  S-HOST-VARIABLES-V  PIC X(255).                      
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-STATEMENT-V   PIC X(255).                      
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-DESCRIPTION-V PIC X(255).                      
REARCH*                                                                         
HPCCDM*EJECT                                                            02540000
      ***********************************************************       02550000
T26509*** SELECT-UTIL CURSOR: CHECK IF THERE IS ANY ELECTRIC ROWS       02560000
T26509*** IN CSS_UTIL_ENVRMT                                            02570000
      ***********************************************************       02580000
                                                                        
           EXEC SQL DECLARE SEL-UTL-CUR CURSOR FOR                      
              SELECT 'Y'                                                
              FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                       
              WHERE ACCOUNT_NO = :UT-ACCOUNT-NO                         
T26509          AND CODE_UTIL_TYPE = :WS-E                              
A37061          FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE SEL-UTL-CUR CURSOR FOR                      02600000
MFA-TR*       SELECT 'Y'                                                02610000
MFA-TR*       FROM CSS_UTIL_ENVRNMT                                     02620000
MFA-TR*       WHERE ACCOUNT_NO = :UT-ACCOUNT-NO                         02630000
MFA-TR*         AND CODE_UTIL_TYPE = :WS-E                              02640000
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                    02650000
                                                                        
      ***********************************************************       02670000
      *** SEL-RATE-CUR CURSOR: FETCH ALL ROWS IN                        02680000
      *** CSS_UTIL_ENVRMT UT,CSS_RATE_PLAN_DESC                         02690000
      ***********************************************************       02700000
                                                                        
           EXEC SQL DECLARE SEL-RATE-CUR CURSOR FOR                     
              SELECT 'Y'                                                
              FROM CSS_UTIL_ENVRNMT UT
                           WITH(READUNCOMMITTED),CSS_RATE_PLAN_DESC RD
                           WITH(READUNCOMMITTED)            
              WHERE UT.ACCOUNT_NO = :UT-ACCOUNT-NO                      
                AND UT.CODE_UTIL_TYPE = RD.CODE_UTIL_TYPE               
                AND UT.RATE_PLAN_NO = RD.RATE_PLAN_NO                   
ACT193          AND RD.SECURED_RATE_FL = 'Y'                            
A37061          FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE SEL-RATE-CUR CURSOR FOR                     02720000
MFA-TR*       SELECT 'Y'                                                02730000
MFA-TR*       FROM CSS_UTIL_ENVRNMT UT,CSS_RATE_PLAN_DESC RD            02740000
MFA-TR*       WHERE UT.ACCOUNT_NO = :UT-ACCOUNT-NO                      02750000
MFA-TR*         AND UT.CODE_UTIL_TYPE = RD.CODE_UTIL_TYPE               02760000
MFA-TR*         AND UT.RATE_PLAN_NO = RD.RATE_PLAN_NO                   02770000
MFA-TR*         AND RD.SECURED_RATE_FL = 'Y'                            02780000
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                    02790000
                                                                        
      ***********************************************************       02810000
      *** TRN-HST-DET CURSOR: FETCH ALL ROWS IN                         02820000
      *** CSS_AR_TRN_HST_DET                                            02830000
      ***********************************************************       02840000
TP8668     EXEC SQL DECLARE TRN-HST-DET CURSOR FOR                      
TP8668        SELECT REPLACE(REPLACE(CONVERT(CHAR(26), TRANS_HIST_SEQ_NO
           , 121), ' ', '-'), ':', '.') TRANS_HIST_SEQ_NO,                     
TP8668               SUM(AMT_POSTED)                                    
TP8668        FROM CSS_AR_TRN_HST_DET WITH(READUNCOMMITTED)                     
TP8668        WHERE ACCOUNT_NO = :AU-ACCOUNT-NO                         
TP8668        GROUP BY TRANS_HIST_SEQ_NO                                
TP8668        ORDER BY TRANS_HIST_SEQ_NO DESC                           
A37061        FOR READ ONLY                                     
TP8668     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE TRN-HST-DET CURSOR FOR                      02850000
MFA-TR*       SELECT TRANS_HIST_SEQ_NO,                                 02860000
MFA-TR*              SUM(AMT_POSTED)                                    02870000
MFA-TR*       FROM CSS_AR_TRN_HST_DET                                   02880000
MFA-TR*       WHERE ACCOUNT_NO = :AU-ACCOUNT-NO                         02890000
MFA-TR*       GROUP BY TRANS_HIST_SEQ_NO                                02900000
MFA-TR*       ORDER BY TRANS_HIST_SEQ_NO DESC                           02910000
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                    02920000
                                                                        
TP8668     EXEC SQL DECLARE TRN-HST-GL CURSOR FOR                       
TP8668        SELECT GL_ACCT_CREDIT,                                    
TP8668               GL_ACCT_DEBIT                                      
TP8668        FROM CSS_AR_TRN_HST_DET WITH(READUNCOMMITTED)                     
TP8668        WHERE ACCOUNT_NO        = :AU-ACCOUNT-NO                  
TP8668          AND TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :AU-TRANS-HIST-SEQ-NO
              )           
A37061          FOR READ ONLY                                   
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL DECLARE TRN-HST-GL CURSOR FOR                       02940000
MFA-TR*       SELECT GL_ACCT_CREDIT,                                    02950000
MFA-TR*              GL_ACCT_DEBIT                                      02960000
MFA-TR*       FROM CSS_AR_TRN_HST_DET                                   02970000
MFA-TR*       WHERE ACCOUNT_NO        = :AU-ACCOUNT-NO                  02980000
MFA-TR*         AND TRANS_HIST_SEQ_NO = :AU-TRANS-HIST-SEQ-NO           02990000
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                    03000000
MSQ001        EXEC SQL
MSQ001          DECLARE CHRG_AMT CURSOR
MSQ001          FOR CALL CSR04533                                       
P00581         ( :AT-ACCOUNT-NO
                  )
MSQ001        END-EXEC.
                                                    
                                                                        
REARCH LINKAGE SECTION.                                                 
REARCH*                                                                         
REARCH 01  PARM-ACCOUNT-NO            PIC X(13) VALUE SPACES.           
REARCH 01  PARM-CHARGE-TYPE           PIC X(03) VALUE SPACES.           
REARCH*                                                                         
REARCH PROCEDURE DIVISION USING PARM-ACCOUNT-NO                         
REARCH                          PARM-CHARGE-TYPE.                       
      *                                                                 03060000
      *                                                                 03070000
      ******************************************************************03080000
      *      CONTROLS THE MAIN PATH OF THE PROGRAM *                    03090000
      *  0000-MAINLINE *                                                03100000
      ******************************************************************03110000
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03200000
      * 0100-INITIALIZE                                                *03210000
      *                                                                *03220000
      *     1. RESET DB2 ERROR HANDLERS                                *03230000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *03240000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *03250000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*03260000
      *                                                                *03270000
      ******************************************************************03280000
       0100-INITIALIZE.                                                 
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
REARCH     PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
REARCH*                                                                         
REARCH     EXEC SQL                                                     
A37061          DECLARE C1 CURSOR                            
A37061                            WITH ROWSET POSITIONING FOR           
REARCH          SELECT                                                  
REARCH               RETURN_CODE                                        
REARCH              ,LTRIM(RTRIM(CHG_DATE))           AS CHG_DATE              
REARCH              ,CHG_AMT                                            
REARCH              ,LTRIM(RTRIM(CHG_TYPE))           AS CHG_TYPE              
REARCH              ,LTRIM(RTRIM(DEBIT_CREDIT_IND))   AS 
           DEBIT_CREDIT_IND      
REARCH              ,LTRIM(RTRIM(GAS_ACCOUNT_ONLY))   AS 
           GAS_ACCOUNT_ONLY      
REARCH              ,LTRIM(RTRIM(GL_ACCT_NO))         AS GL_ACCT_NO            
REARCH              ,LTRIM(RTRIM(AR_LOCKOUT_IND))     AS AR_LOCKOUT_IND        
REARCH              ,LTRIM(RTRIM(SECURED_RATE_FL))    AS SECURED_RATE_FL       
REARCH              ,DELINQ_VALUE                                       
REARCH              ,LTRIM(RTRIM(LAST_UPDATE_TS))     AS LAST_UPDATE_TS        
REARCH              ,LTRIM(RTRIM(ACCT_TYPE_CD))       AS ACCT_TYPE_CD          
REARCH          FROM                                                    
REARCH               #CSR02283_R1                                
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN                                   
MFA-TR*                           WITH ROWSET POSITIONING FOR                   
MFA-TR*         SELECT                                                          
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,STRIP(CHG_DATE)           AS CHG_DATE                      
MFA-TR*             ,CHG_AMT                                                    
MFA-TR*             ,STRIP(CHG_TYPE)           AS CHG_TYPE                      
MFA-TR*             ,STRIP(DEBIT_CREDIT_IND)   AS DEBIT_CREDIT_IND              
MFA-TR*             ,STRIP(GAS_ACCOUNT_ONLY)   AS GAS_ACCOUNT_ONLY              
MFA-TR*             ,STRIP(GL_ACCT_NO)         AS GL_ACCT_NO                    
MFA-TR*             ,STRIP(AR_LOCKOUT_IND)     AS AR_LOCKOUT_IND                
MFA-TR*             ,STRIP(SECURED_RATE_FL)    AS SECURED_RATE_FL               
MFA-TR*             ,DELINQ_VALUE                                               
MFA-TR*             ,STRIP(LAST_UPDATE_TS)     AS LAST_UPDATE_TS                
MFA-TR*             ,STRIP(ACCT_TYPE_CD)       AS ACCT_TYPE_CD                  
MFA-TR*         FROM                                                            
MFA-TR*              SESSION.CSR02283_R1                                        
MFA-TR*    END-EXEC.                                                            
REARCH*                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************        
REARCH*0100A-DECLARE-GTT                                               *        
REARCH******************************************************************        
REARCH 0100A-DECLARE-GTT.                                               
REARCH*                                                                         
REARCH     MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR02283_R1'            
REARCH                                    TO S-SQL-STATEMENT-V.         
REARCH     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02283_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02283_R1
              (                                                       
REARCH               RETURN_CODE        INT                         
REARCH              ,CHG_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH              ,CHG_AMT            DECIMAL(11,2)                   
REARCH              ,CHG_TYPE CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH              ,DEBIT_CREDIT_IND CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH              ,GAS_ACCOUNT_ONLY CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH              ,GL_ACCT_NO CHAR(08)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH              ,AR_LOCKOUT_IND CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH              ,SECURED_RATE_FL CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH              ,DELINQ_VALUE       DECIMAL(9,5)                    
REARCH              ,LAST_UPDATE_TS CHAR(26)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH              ,ACCT_TYPE_CD CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH          )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH     MOVE SQLSTATE                 TO WS-SQLSTATE.                
REARCH     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
REARCH*                                                                         
REARCH     IF WS-SQLSTATE = '42710'                                     
REARCH         PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT            
REARCH     ELSE                                                         
REARCH         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
REARCH                NEXT SENTENCE                                     
REARCH         ELSE                                                     
REARCH            MOVE PROGRAM-NAME       TO ABEND-PROGRAM              
REARCH            MOVE SQLCODE            TO ABEND-SQLCODE              
REARCH            MOVE SQLSTATE           TO ABEND-SQLSTATE             
REARCH            MOVE '0100A'            TO ACTIVE-PARAGRAPH           
REARCH            MOVE 'DECLARE GTT'      TO ABEND-FUNCTION             
REARCH            MOVE SPACES             TO ABEND-SQL-PREDICATES       
REARCH                                       ABEND-TABLES               
REARCH            MOVE 'CSR02283_R1'      TO TABLE-1                    
REARCH            MOVE SPACES             TO TABLE-ELEMENT-1            
REARCH            MOVE SPACES             TO HOSTVAR-ELEMENT-1          
REARCH            PERFORM 9900-SQL-ERROR-ROUTINE                        
REARCH                                    THRU  9900-EXIT               
REARCH         END-IF                                                   
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH 0100A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
      ******************************************************************03530000
      * 1000-PROCESS-INPUT                                             *03540000
      *                                                                *03550000
      *     1. RECEIVE PARMS.                                          *03560000
      *                                                                *03570000
      ******************************************************************03580000
       1000-PROCESS-INPUT.                                              
REARCH     MOVE PARM-ACCOUNT-NO           TO PARM-ACCOUNT-NO-TEMP       
           MOVE PARM-ACCOUNT-NO-RED       TO WS-ACCOUNT-NO.             
           MOVE WS-ACCOUNT-NO             TO WS-ACCOUNT-NO-NUM.         
           MOVE WS-ACCOUNT-NO-NUM         TO UT-ACCOUNT-NO              
                                             AR-ACCOUNT-NO              
                                             AU-ACCOUNT-NO.             
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************04010000
      * 2000-PROCESS-OUTPUT.                                           *04020000
      *                                                                *04030000
      *     1. DESCRIBE RESULT SET                                     *04040000
      *     2. UPDATE DB2 DATA                                         *04050000
      *     3. BUILD RESULT SET                                        *04060000
      *     4. SEND RESULT SET                                         *04070000
      *                                                                *04080000
      ******************************************************************04090000
       2000-PROCESS-OUTPUT.                                             
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 2200-BUILD-RESULT    THRU 2200-EXIT.                 
                                                                        
           IF WS-ROWS = 0                                               
              MOVE 100                  TO RS-RETURN-CODE               
              MOVE SPACES               TO RS-CHG-DATE                  
              MOVE ZEROS                TO RS-CHG-AMT                   
              MOVE SPACES               TO RS-DEBIT-CREDIT-IND          
              MOVE SPACES               TO RS-GAS-ACCOUNT-ONLY          
REARCH        PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
              PERFORM 8100-SEND-RESULT  THRU 8100-EXIT                  
           END-IF.                                                      
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************        
REARCH*2000A-MOVE-RESULT                                               *        
REARCH******************************************************************        
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE  RS-RETURN-CODE      TO S-RETURN-CODE.                  
REARCH     MOVE  RS-CHG-DATE         TO S-CHG-DATE.                     
REARCH     MOVE  RS-CHG-AMT          TO S-CHG-AMT.                      
REARCH     MOVE  RS-CHG-TYPE         TO S-CHG-TYPE.                     
REARCH     MOVE  RS-DEBIT-CREDIT-IND TO S-DEBIT-CREDIT-IND.             
REARCH     MOVE  RS-GAS-ACCOUNT-ONLY TO S-GAS-ACCOUNT-ONLY.             
REARCH     MOVE  RS-GL-ACCT-NO       TO S-GL-ACCT-NO.                   
REARCH     MOVE  RS-AR-IND           TO S-AR-IND.                       
REARCH     MOVE  RS-SECURED-RATE-FL  TO S-SECURED-RATE-FL.              
REARCH     MOVE  RS-DELINQ-VALUE     TO S-DELINQ-VALUE.                 
REARCH     MOVE  RS-LAST-UPDATE-TS   TO S-LAST-UPDATE-TS.               
REARCH     MOVE  RS-ACCT-TYPE-CD     TO S-ACCT-TYPE-CD.                 
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
      ******************************************************************06610000
      * 2200-BUILD-RESULT                                              *06620000
      ******************************************************************06630000
       2200-BUILD-RESULT.                                               
                                                                        
T23501     MOVE WS-ACCOUNT-NO-NUM      TO AT-ACCOUNT-NO.                
T23501     PERFORM 7200-SELECT-ACCOUNT THRU 7200-EXIT.                  
A37061     MOVE AT-ACCOUNT-TYPE-CODE   TO   RS-ACCT-TYPE-CD.            
      *                                                                         
P00581*****************************************************************         
P00581* DETERMINE IF ACCOUNT IS SCEG/PSNC OR SEB.                               
P00581*****************************************************************         
P00581     MOVE 'DATABASE'             TO C8-DELINQ-CD.                 
P00581     PERFORM 7400-SELECT-DELINQ-VALUE THRU 7400-EXIT.             
P00581     MOVE C8-DELINQ-VALUE        TO WS-DATABASE.                  
P00581*                                                                         
ACT025     IF SEB-DATABASE AND (PARM-CHARGE-TYPE = 'NSC' OR 'RCC')      
P00581        PERFORM 5200-GET-CHRG-AMT-DEL-CD  THRU 5200-EXIT          
P00581     ELSE                                                         
P00581        MOVE WS-CHECKCHARGE      TO C8-DELINQ-CD                  
P00581     END-IF.                                                      
      *                                                                         
TP9263     PERFORM 7400-SELECT-DELINQ-VALUE THRU 7400-EXIT.             
TP9263     MOVE C8-DELINQ-VALUE   TO RS-DELINQ-VALUE.                   
                                                                        
           PERFORM 7999-SELECT-AL THRU 7999-SELECT-AL-EXIT.             
           MOVE AL-AR-LOCKOUT-IND TO RS-AR-IND.                         
RTO496     MOVE WS-N TO RS-GAS-ACCOUNT-ONLY.                            
RTO496*    MOVE WS-G TO UT-CODE-UTIL-TYPE.                              06710000
RO0496     MOVE WS-N TO RS-SECURED-RATE-FL.                             
                                                                        
           MOVE AT-CODES-DATA-PRESENT  TO WS-CODES-DATA-PRESENT.        
           IF WS-CODE-UTL = 'A'                                         
              PERFORM 7000-OPEN-SEL-UTL-CUR THRU 7000-EXIT              
              PERFORM 7100-FETCH-SEL-UTL-CUR THRU 7100-EXIT             
              PERFORM 7120-CLOSE-SEL-UTL-CUR THRU 7120-EXIT             
           END-IF.                                                      
                                                                        
           PERFORM 7050-OPEN-SEL-RATE-CUR THRU 7050-EXIT.               
           PERFORM 7115-FETCH-SEL-RATE-CUR THRU 7115-EXIT.              
           PERFORM 7125-CLOSE-SEL-RATE-CUR THRU 7125-EXIT.              
                                                                        
           MOVE AT-COMPANY-NO          TO GO-COMPANY-NO.                
                                                                        
           IF PARM-CHARGE-TYPE = WS-LPC                                 
              MOVE WS-GL-AR-LPC-KEY TO GO-GL-ACCT-NAME                  
              PERFORM 7300-SELECT-GL-ACCT THRU 7300-EXIT                
              MOVE GO-GL-ACCT-NO    TO WS-GL-LPC                        
           ELSE                                                         
           IF PARM-CHARGE-TYPE = WS-LPN                                 
              MOVE WS-GL-AR-LPN-KEY TO GO-GL-ACCT-NAME                  
              PERFORM 7300-SELECT-GL-ACCT THRU 7300-EXIT                
              MOVE GO-GL-ACCT-NO    TO WS-GL-LPN                        
           ELSE                                                         
           IF PARM-CHARGE-TYPE = WS-RCC                                 
              MOVE WS-GL-AR-CCC-KEY TO GO-GL-ACCT-NAME                  
              PERFORM 7300-SELECT-GL-ACCT THRU 7300-EXIT                
              MOVE GO-GL-ACCT-NO    TO WS-GL-RCC                        
           ELSE                                                         
              MOVE WS-GL-AR-NSC-KEY TO GO-GL-ACCT-NAME                  
              PERFORM 7300-SELECT-GL-ACCT THRU 7300-EXIT                
              MOVE GO-GL-ACCT-NO    TO WS-GL-NSC                        
           END-IF
           END-IF
           END-IF.                                                      
TP5208     MOVE GO-GL-ACCT-NO       TO WS-GL-NUMERIC.                   
TP5208     MOVE WS-GL-CHAR          TO RS-GL-ACCT-NO.                   
                                                                        
T21112     PERFORM 2600-GET-LAST-UPDATE-TS                              
T21112                                    THRU 2600-EXIT.               
                                                                        
           PERFORM 7150-OPEN-TRN-HST-DET  THRU 7150-EXIT.               
           PERFORM 7160-FETCH-TRN-HST-DET THRU 7160-EXIT.               
                                                                        
T22449     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
T22449        CONTINUE                                                  
           ELSE                                                         
              PERFORM 2250-FILTER-CRITERIA THRU 2250-EXIT               
                  UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND               
                  OR WS-ROWS = 4                                        
T22449     END-IF.                                                      
                                                                        
           PERFORM 7170-CLOSE-TRN-HST-DET THRU 7170-EXIT.               
                                                                        
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE.                
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07230000
      * 2250-FILTER-CRITERIA                                           *07240000
      ******************************************************************07250000
       2250-FILTER-CRITERIA.                                            
TP8668     PERFORM 7181-OPEN-TRN-HST-GL   THRU 7181-EXIT                
TP8668     PERFORM 7182-FETCH-TRN-HST-GL  THRU 7182-EXIT                
TP8668     PERFORM 7183-CLOSE-TRN-HST-GL  THRU 7183-EXIT                
                                                                        
           MOVE AU-TRANS-HIST-SEQ-NO TO WS-TIMESTAMP.                   
           MOVE WS-TS-YEAR           TO FORMATTED-YEAR.                 
           MOVE WS-TS-MONTH          TO FORMATTED-MONTH.                
           MOVE WS-TS-DAY            TO FORMATTED-DAY.                  
           MOVE WS-FORMATTED-DATE    TO RS-CHG-DATE.                    
           MOVE AU-AMT-POSTED        TO RS-CHG-AMT.                     
TP5208     MOVE GO-GL-ACCT-NO        TO WS-GL-NUMERIC.                  
TP5208     MOVE WS-GL-CHAR           TO RS-GL-ACCT-NO.                  
                                                                        
           IF AU-GL-ACCT-CREDIT = WS-GL-LPC                             
              MOVE WS-C              TO RS-DEBIT-CREDIT-IND             
              MOVE WS-LPC            TO RS-CHG-TYPE                     
              ADD 1                  TO WS-ROWS                         
REARCH        PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
           ELSE                                                         
           IF AU-GL-ACCT-CREDIT = WS-GL-LPN                             
              MOVE WS-C              TO RS-DEBIT-CREDIT-IND             
              MOVE WS-LPN            TO RS-CHG-TYPE                     
              ADD 1                  TO WS-ROWS-N                       
REARCH        PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
           ELSE                                                         
           IF AU-GL-ACCT-CREDIT = WS-GL-RCC                             
              MOVE WS-C              TO RS-DEBIT-CREDIT-IND             
              MOVE WS-RCC            TO RS-CHG-TYPE                     
              ADD 1                  TO WS-ROWS                         
REARCH        PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
           ELSE                                                         
           IF AU-GL-ACCT-CREDIT = WS-GL-NSC                             
              MOVE WS-C              TO RS-DEBIT-CREDIT-IND             
              MOVE WS-NSC            TO RS-CHG-TYPE                     
              ADD 1                  TO WS-ROWS                         
REARCH        PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
           ELSE                                                         
           IF AU-GL-ACCT-DEBIT  = WS-GL-LPC                             
              MOVE WS-D              TO RS-DEBIT-CREDIT-IND             
              MOVE WS-LPC            TO RS-CHG-TYPE                     
              ADD 1                  TO WS-ROWS                         
REARCH        PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
           ELSE                                                         
           IF AU-GL-ACCT-DEBIT  = WS-GL-LPN                             
              MOVE WS-D              TO RS-DEBIT-CREDIT-IND             
              MOVE WS-LPN            TO RS-CHG-TYPE                     
              ADD 1                  TO WS-ROWS-N                       
REARCH        PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
           ELSE                                                         
           IF AU-GL-ACCT-DEBIT  = WS-GL-RCC                             
              MOVE WS-D              TO RS-DEBIT-CREDIT-IND             
              MOVE WS-RCC            TO RS-CHG-TYPE                     
              ADD 1                  TO WS-ROWS                         
REARCH        PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
           ELSE                                                         
           IF AU-GL-ACCT-DEBIT  = WS-GL-NSC                             
              MOVE WS-D              TO RS-DEBIT-CREDIT-IND             
              MOVE WS-NSC            TO RS-CHG-TYPE                     
              ADD 1                  TO WS-ROWS                         
REARCH        PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF.                  
                                                                        
           PERFORM 7160-FETCH-TRN-HST-DET THRU 7160-EXIT.               
       2250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  07920000
T21112*GETS THE LAST-UPDATE-TS FROM CSS_ACCOUNT                      *  07910201
T21112****************************************************************  07910301
T21112 2600-GET-LAST-UPDATE-TS.                                         
T21112*                                                                 07910501
T21112     PERFORM 7500-SELECT-UPDATE-TS        THRU 7500-EXIT.         
T21112     MOVE AT-LAST-UPDATE-TS               TO RS-LAST-UPDATE-TS.   
T21112*                                                                 07910801
T21112 2600-EXIT.                                                       
T21112     EXIT.                                                        
T21112*                                                                 07912001
P00581**************************************************************            
P00581* GET THE DELINQ CODE FOR GETTING THE NSC/RCC CHARGE AMOUNT. *            
P00581**************************************************************            
P00581 5200-GET-CHRG-AMT-DEL-CD.                                        
P00581*                                                                         
P00581     INITIALIZE WS-CSR04533-OUTPUT.                               
P00581*                                                                         
P00581*    EXEC SQL CALL CSR04533                                       
P00581*        (:AT-ACCOUNT-NO)                                         
P00581*    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE CHRG_AMT
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN CHRG_AMT
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR CHRG_AMT INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
P00581*                                                                         
P00581     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
P00581*                                                                         
P00581     IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
P00581        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00581        MOVE '5200'                TO ACTIVE-PARAGRAPH            
P00581        MOVE 'CALL'                TO ABEND-FUNCTION              
P00581        MOVE 'CSR04533'            TO TABLE-1                     
P00581        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
P00581        MOVE 'SQLCODE '            TO TABLE-ELEMENT-2             
P00581        MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
P00581        MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-2           
P00581        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00581        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00581     END-IF.                                                      
P00581*                                                                         
P00581*    EXEC SQL ASSOCIATE LOCATORS(:LOC1) WITH PROCEDURE            
P00581*        CSR04533                                                 
P00581*    END-EXEC.                                                    
P00581*                                                                         
P00581*    EXEC SQL                                                     
P00581*        ALLOCATE CHRG_AMT CURSOR FOR RESULT SET :LOC1            
P00581*    END-EXEC.                                                    
P00581*                                                                         
P00581     EXEC SQL                                                     
P00581         FETCH CHRG_AMT                                           
P00581         INTO         :WS-4533-RETURN-CODE                        
P00581                     ,:WS-4533-EFF-REV-MTH                        
P00581                     ,:WS-4533-CALC-TYPE-CD                       
P00581                     ,:WS-4533-OPT-AGR-EFF-DT                     
P00581     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00581*                                                                         
P00581     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
P00581     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00581         WHEN SUCCESSFUL-CALL                                     
P00581             IF WS-4533-RETURN-CODE = 0 OR NOT-FOUND              
P00581                PERFORM 5300-PROCESS-FETCH-VALUES THRU 5300-EXIT  
P00581             ELSE                                                 
P00581                MOVE WS-4533-RETURN-CODE TO WS-ACTIVE-RETURN-CODE 
P00581                MOVE PROGRAM-NAME        TO ABEND-PROGRAM         
P00581                MOVE '5200'              TO ACTIVE-PARAGRAPH      
P00581                MOVE 'FETCH'             TO ABEND-FUNCTION        
P00581                MOVE 'CSR04533'          TO TABLE-1               
P00581                MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1       
P00581                MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1     
P00581                PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT     
P00581                PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT     
P00581             END-IF                                               
P00581         WHEN OTHER                                               
P00581             MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
P00581             MOVE '5200'                 TO ACTIVE-PARAGRAPH      
P00581             MOVE 'FETCH'                TO ABEND-FUNCTION        
P00581             MOVE 'CSR04533'             TO TABLE-1               
P00581             MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1       
P00581             MOVE 'SQLCODE '             TO TABLE-ELEMENT-2       
P00581             MOVE AT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1     
P00581             MOVE WS-ACTIVE-RETURN-CODE  TO HOSTVAR-ELEMENT-2     
P00581             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
P00581             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
P00581     END-EVALUATE.                                                
P00581*                                                                         
P00581     EXEC SQL                                                     
P00581        CLOSE CHRG_AMT                                            
P00581     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00581*                                                                         
P00581     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
P00581     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00581        CONTINUE                                                  
P00581     ELSE                                                         
P00581        MOVE '5200'                TO ACTIVE-PARAGRAPH            
P00581        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00581        MOVE 'CLOSE'               TO ABEND-FUNCTION              
P00581        MOVE 'CSR04533'            TO TABLE-1                     
P00581        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
P00581        MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
P00581        MOVE 'SQLCODE '            TO TABLE-ELEMENT-2             
P00581        MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-2           
P00581        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
P00581        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
P00581     END-IF.                                                      
P00581*                                                                         
P00581 5200-EXIT.                                                       
P00581     EXIT.                                                        
P00581*                                                                         
P00581****************************************************************  07920000
P00581* 5300-PROCESS-FETCH-VALUES.                                   *  07930000
P00581****************************************************************  07940000
P00581 5300-PROCESS-FETCH-VALUES.                                       
P00581*                                                                         
P00581     PERFORM 7280-CHECK-SEB-REG      THRU 7280-EXIT.              
P00581*                                                                         
P00581     IF WS-SEB-REGULATED-FL = 'N'                                 
P00581        EVALUATE PARM-CHARGE-TYPE                                 
P00581           WHEN 'NSC'                                             
P00581             MOVE 'DEREG-NSC'        TO G6-PROGRAM-NAME           
P00581           WHEN 'RCC'                                             
P00581             MOVE 'DEREG-RCC'        TO G6-PROGRAM-NAME           
P00581        END-EVALUATE                                              
P00581     ELSE                                                         
P00581        IF LR-REG-GROUP-CD = '100'                                
P00581           EVALUATE PARM-CHARGE-TYPE                              
P00581              WHEN 'NSC'                                          
P00581                MOVE 'REG1-NSC'      TO G6-PROGRAM-NAME           
P00581              WHEN 'RCC'                                          
P00581                MOVE 'REG1-RCC'      TO G6-PROGRAM-NAME           
P00581           END-EVALUATE                                           
P00581        ELSE                                                      
P00581           IF LR-REG-GROUP-CD = '200'                             
P00581              EVALUATE PARM-CHARGE-TYPE                           
P00581                  WHEN 'NSC'                                      
P00581                    MOVE 'REG2-NSC'  TO G6-PROGRAM-NAME           
P00581                  WHEN 'RCC'                                      
P00581                    MOVE 'REG2-RCC'  TO G6-PROGRAM-NAME           
P00581              END-EVALUATE                                        
P00581           END-IF                                                 
P00581        END-IF                                                    
P00581     END-IF.                                                      
P00581*                                                                         
P00581     PERFORM 7260-GET-JOB-PARM-VALUES  THRU 7260-EXIT.            
P00581*                                                                         
P00581     IF WS-4533-CALC-TYPE-CD   NOT = WS-FP                        
P00581        PERFORM 7020-GET-CUR-DATE  THRU 7020-EXIT                 
P00581        MOVE WS-CURRENT-DATE       TO WS-4533-OPT-AGR-EFF-DT      
P00581     END-IF.                                                      
P00581*                                                                         
P00581     IF WS-4533-OPT-AGR-EFF-DT < WS-FEE-INCR-DATE                 
P00581        MOVE WS-OLD-DELINQ-CD      TO C8-DELINQ-CD                
P00581     ELSE                                                         
P00581        MOVE WS-NEW-DELINQ-CD      TO C8-DELINQ-CD                
P00581     END-IF.                                                      
P00581*                                                                         
P00581 5300-EXIT.                                                       
P00581     EXIT.                                                        
P00581*                                                                         
      ****************************************************************  07920000
      * 7000-OPEN-SEL-UTL-CUR.                                       *  07930000
      ****************************************************************  07940000
       7000-OPEN-SEL-UTL-CUR.                                           
           EXEC SQL                                                     
              OPEN SEL-UTL-CUR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_UTIL_ENVRNMT'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE UT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
       7000-EXIT.                                                       
           EXIT.                                                        
P00581*                                                                 11670000
P00581******************************************************************27520000
P00581* 7020-GET-CUR-DATE                                              *27530000
P00581******************************************************************27560000
      *                                                                 27590000
P00581 7020-GET-CUR-DATE.                                               
      *                                                                 27590000
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                       
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     27600000
MFA-TR*       SET :WS-CURRENT-DATE = CURRENT DATE                       27610000
MFA-TR*    END-EXEC                                                     27720000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 27730000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7020'                TO ACTIVE-PARAGRAPH            
              MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                 27870000
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                 27870000
      ****************************************************************  08170000
      * 7050-OPEN-SEL-RATE-CUR.                                      *  08180000
      ****************************************************************  08190000
       7050-OPEN-SEL-RATE-CUR.                                          
           EXEC SQL                                                     
              OPEN SEL-RATE-CUR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7050'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_UTIL_ENVRNMT'        TO TABLE-1                 
CBSI          MOVE 'CSS_RATE_PLAN_DESC'      TO TABLE-2                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE UT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  08420000
      * 7100-FETCH-SEL-UTL-CUR.                                      *  08430000
      ****************************************************************  08440000
       7100-FETCH-SEL-UTL-CUR.                                          
           EXEC SQL                                                     
              FETCH SEL-UTL-CUR                                         
T26509        INTO :WS-ELEC-EXISTS                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'CSS_UTIL_ENVRNMT'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE UT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
T26509     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T26509        MOVE 'N'                       TO RS-GAS-ACCOUNT-ONLY     
T26509     ELSE                                                         
T26509        MOVE 'Y'                       TO RS-GAS-ACCOUNT-ONLY     
T26509     END-IF.                                                      
T26509*                                                                 08640000
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08670000
      ****************************************************************  08680000
      * 7115-FETCH-SEL-RATE-CUR.                                     *  08690000
      ****************************************************************  08700000
       7115-FETCH-SEL-RATE-CUR.                                         
           EXEC SQL                                                     
              FETCH SEL-RATE-CUR                                        
              INTO :RS-SECURED-RATE-FL                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7115'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'CSS_UTIL_ENVRNMT'        TO TABLE-1                 
CBSI          MOVE 'CSS_RATE_PLAN_DESC'      TO TABLE-2                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE UT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
       7115-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08930000
                                                                        
      ****************************************************************  08950000
      * 7120-CLOSE-SEL-UTL-CUR.                                      *  08960000
      ****************************************************************  08970000
       7120-CLOSE-SEL-UTL-CUR.                                          
           EXEC SQL                                                     
              CLOSE SEL-UTL-CUR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7120'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_UTIL_ENVRNMT'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE UT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09190000
      ****************************************************************  09200000
      * 7125-CLOSE-SEL-RATE-CUR.                                     *  09210000
      ****************************************************************  09220000
       7125-CLOSE-SEL-RATE-CUR.                                         
           EXEC SQL                                                     
              CLOSE SEL-RATE-CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7125'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_UTIL_ENVRNMT'        TO TABLE-1                 
CBSI          MOVE 'CSS_RATE_PLAN_DESC'      TO TABLE-2                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE UT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
       7125-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09440000
      *                                                                 09450000
      ******************************************************************09460000
      * 7150-OPEN-TRN-HST-DET.                                         *09470000
      ******************************************************************09480000
       7150-OPEN-TRN-HST-DET.                                           
           EXEC SQL                                                     
              OPEN TRN-HST-DET                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7150'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_AR_TRN_HST_DET'      TO TABLE-1                 
CBSI          MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AU-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09680000
      ******************************************************************09690000
      * 7160-FETCH-TRN-HST-DET.                                        *09700000
      ******************************************************************09710000
       7160-FETCH-TRN-HST-DET.                                          
           EXEC SQL                                                     
              FETCH TRN-HST-DET                                         
              INTO  :AU-TRANS-HIST-SEQ-NO,                              
                    :AU-AMT-POSTED                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7160'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'CSS_AR_TRN_HST_DET'      TO TABLE-1                 
CBSI          MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AU-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
       7160-EXIT.                                                       
           EXIT.                                                        
      *                                                                 09930000
      *                                                                 09940000
      ******************************************************************09950000
      * 7170-CLOSE-TRN-HST-DET.                                        *09960000
      ******************************************************************09970000
       7170-CLOSE-TRN-HST-DET.                                          
           EXEC SQL                                                     
              CLOSE TRN-HST-DET                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7170'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE 'CSS_AR_TRN_HST_DET'      TO TABLE-1                 
CBSI          MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AU-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
       7170-EXIT.                                                       
           EXIT.                                                        
TP8668*                                                                 10170000
TP8668*                                                                 10180000
TP8668******************************************************************10190000
TP8668* 7181-OPEN-TRN-HST-GL.                                          *10200000
TP8668******************************************************************10210000
TP8668 7181-OPEN-TRN-HST-GL.                                            
TP8668     EXEC SQL                                                     
TP8668        OPEN TRN-HST-GL                                           
TP8668     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

TP8668                                                                  
TP8668     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
TP8668     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
TP8668        NEXT SENTENCE                                             
TP8668     ELSE                                                         
TP8668        MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
TP8668        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
TP8668        MOVE '7181'                    TO ACTIVE-PARAGRAPH        
TP8668        MOVE 'OPEN'                    TO ABEND-FUNCTION          
TP8668        MOVE 'CSS_AR_TRN_HST_DET'      TO TABLE-1                 
CBSI          MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
TP8668        MOVE AU-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
TP8668        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
TP8668        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
TP8668 7181-EXIT.                                                       
TP8668     EXIT.                                                        
TP8668*                                                                 10410000
TP8668*                                                                 10420000
TP8668******************************************************************10430000
TP8668* 7182-FETCH-TRN-HST-GL.                                         *10440000
TP8668******************************************************************10450000
TP8668 7182-FETCH-TRN-HST-GL.                                           
TP8668     EXEC SQL                                                     
TP8668        FETCH TRN-HST-GL                                          
TP8668        INTO  :AU-GL-ACCT-CREDIT,                                 
TP8668              :AU-GL-ACCT-DEBIT                                   
TP8668     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

TP8668                                                                  
TP8668     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
TP8668     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
TP8668        NEXT SENTENCE                                             
TP8668     ELSE                                                         
TP8668        MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
TP8668        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
TP8668        MOVE '7182'                    TO ACTIVE-PARAGRAPH        
TP8668        MOVE 'FETCH'                   TO ABEND-FUNCTION          
TP8668        MOVE 'CSS_AR_TRN_HST_DET'      TO TABLE-1                 
CBSI          MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
TP8668        MOVE AU-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
TP8668        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
TP8668        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
TP8668 7182-EXIT.                                                       
TP8668     EXIT.                                                        
TP8668*                                                                 10670000
TP8668*                                                                 10680000
TP8668******************************************************************10690000
TP8668* 7183-CLOSE-TRN-HST-GL.                                         *10700000
TP8668******************************************************************10710000
TP8668 7183-CLOSE-TRN-HST-GL.                                           
TP8668     EXEC SQL                                                     
TP8668        CLOSE TRN-HST-GL                                          
TP8668     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

TP8668                                                                  
TP8668     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
TP8668     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
TP8668        NEXT SENTENCE                                             
TP8668     ELSE                                                         
TP8668        MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
TP8668        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
TP8668        MOVE '7183'                    TO ACTIVE-PARAGRAPH        
TP8668        MOVE 'CLOSE'                   TO ABEND-FUNCTION          
TP8668        MOVE 'CSS_AR_TRN_HST_DET'      TO TABLE-1                 
CBSI          MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
TP8668        MOVE AU-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
TP8668        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
TP8668        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
TP8668 7183-EXIT.                                                       
TP8668     EXIT.                                                        
      *                                                                 10910000
      ******************************************************************10930000
      * 7200-SELECT-ACCOUNT.                                           *10940000
      ******************************************************************10950000
       7200-SELECT-ACCOUNT.                                             
           EXEC SQL                                                     
               SELECT CUSTOMER_NO,        PREMISE_NO,                   
                      LOCAL_OFFICE,       CODE_COMPANY_ACCT,            
                      CODE_ACCT_STAT,     DATE_LAST_ACTION,             
                      CODES_DATA_PRESENT, TOTAL_AR_BALANCE,             
A37061                COMPANY_NO,         REPLACE(REPLACE(CONVERT(
           CHAR(26), LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') 
           LAST_UPDATE_TS,               
A37061                ACCOUNT_TYPE_CODE                                 
               INTO   :AT-CUSTOMER-NO,        :AT-PREMISE-NO,           
                      :AT-LOCAL-OFFICE,       :AT-CODE-COMPANY-ACCT,    
                      :AT-CODE-ACCT-STAT,     :AT-DATE-LAST-ACTION,     
                      :AT-CODES-DATA-PRESENT, :AT-TOTAL-AR-BALANCE,     
A37061                :AT-COMPANY-NO,         :AT-LAST-UPDATE-TS,       
A37061                :AT-ACCOUNT-TYPE-CODE                             
               FROM   CSS_ACCOUNT WITH(READUNCOMMITTED)                         
               WHERE  ACCOUNT_NO  = :AT-ACCOUNT-NO                      
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     10970000
MFA-TR*        SELECT CUSTOMER_NO,        PREMISE_NO,                   10980000
MFA-TR*               LOCAL_OFFICE,       CODE_COMPANY_ACCT,            10990000
MFA-TR*               CODE_ACCT_STAT,     DATE_LAST_ACTION,             11000000
MFA-TR*               CODES_DATA_PRESENT, TOTAL_AR_BALANCE,             11010000
MFA-TR*               COMPANY_NO,         LAST_UPDATE_TS,               11020000
MFA-TR*               ACCOUNT_TYPE_CODE                                         
MFA-TR*        INTO   :AT-CUSTOMER-NO,        :AT-PREMISE-NO,           11030000
MFA-TR*               :AT-LOCAL-OFFICE,       :AT-CODE-COMPANY-ACCT,    11040000
MFA-TR*               :AT-CODE-ACCT-STAT,     :AT-DATE-LAST-ACTION,     11050000
MFA-TR*               :AT-CODES-DATA-PRESENT, :AT-TOTAL-AR-BALANCE,     11060000
MFA-TR*               :AT-COMPANY-NO,         :AT-LAST-UPDATE-TS,       11070000
MFA-TR*               :AT-ACCOUNT-TYPE-CODE                                     
MFA-TR*        FROM   CSS_ACCOUNT                                       11080000
MFA-TR*        WHERE  ACCOUNT_NO  = :AT-ACCOUNT-NO                      11090000
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    11100000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7200'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_ACCOUNT'             TO TABLE-1                 
CBSI          MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11260000
P00581******************************************************************        
P00581*  7260-GET-JOB-PARM-VALUES.                                     *        
P00581******************************************************************        
P00581 7260-GET-JOB-PARM-VALUES.                                        
P00581*                                                                         
P00581     EXEC SQL                                                     
P00581         SELECT CIS.SUBSTR3(G6.PARM_DATA,1,10)                         
P00581               ,CIS.SUBSTR3(G6.PARM_DATA,12,20)                        
P00581               ,CIS.SUBSTR3(G6.PARM_DATA,32,20)                        
P00581           INTO :WS-FEE-INCR-DATE                                 
P00581               ,:WS-NEW-DELINQ-CD                                 
P00581               ,:WS-OLD-DELINQ-CD                                 
P00581           FROM CSS_JOB_PARM G6 WITH(READUNCOMMITTED)                     
P00581          WHERE G6.PROGRAM_NAME = :G6-PROGRAM-NAME                
P00581            AND G6.COMPANY_NO   = '01'                            
P00581            AND G6.CMND_CODE    = 'PARM'                          
P00581            AND G6.SEQ_NO       = 1                               
P00581            AND G6.STATUS       = 'A'                             
P00581                                                           
P00581                                                      
P00581     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUBSTR(G6.PARM_DATA,1,10)                                 
MFA-TR*              ,SUBSTR(G6.PARM_DATA,12,20)                                
MFA-TR*              ,SUBSTR(G6.PARM_DATA,32,20)                                
MFA-TR*          INTO :WS-FEE-INCR-DATE                                         
MFA-TR*              ,:WS-NEW-DELINQ-CD                                         
MFA-TR*              ,:WS-OLD-DELINQ-CD                                         
MFA-TR*          FROM CSS_JOB_PARM G6                                           
MFA-TR*         WHERE G6.PROGRAM_NAME = :G6-PROGRAM-NAME                        
MFA-TR*           AND G6.COMPANY_NO   = '01'                                    
MFA-TR*           AND G6.CMND_CODE    = 'PARM'                                  
MFA-TR*           AND G6.SEQ_NO       = 1                                       
MFA-TR*           AND G6.STATUS       = 'A'                                     
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7260                                                      
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00581*                                                                         
P00581     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
P00581*                                                                         
P00581     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00581        CONTINUE                                                  
P00581     ELSE                                                         
P00581        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
P00581        MOVE SPACES                TO ABEND-TABLES                
P00581        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00581        MOVE '7260'                TO ACTIVE-PARAGRAPH            
P00581        MOVE 'SELECT'              TO ABEND-FUNCTION              
P00581        MOVE 'CSS_JOB_PARM'        TO TABLE-1                     
P00581        MOVE 'PROGRAM_NAME'        TO TABLE-ELEMENT-1             
P00581        MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2             
P00581        MOVE 'CMND_CODE'           TO TABLE-ELEMENT-3             
P00581        MOVE 'SEQ_NO'              TO TABLE-ELEMENT-4             
P00581        MOVE G6-PROGRAM-NAME       TO HOSTVAR-ELEMENT-1           
P00581        MOVE '01'                  TO HOSTVAR-ELEMENT-2           
P00581        MOVE 'PARM'                TO HOSTVAR-ELEMENT-3           
P00581        MOVE '1'                   TO HOSTVAR-ELEMENT-4           
P00581        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
P00581        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
P00581     END-IF.                                                      
P00581*                                                                         
P00581 7260-EXIT.                                                       
P00581     EXIT.                                                        
P00581*                                                                         
P00581***************************************************************           
P00581* DETERMINE IF ACCOUNT IS SEB REGULATED PROVIDER              *           
P00581***************************************************************           
P00581 7280-CHECK-SEB-REG.                                              
P00581*                                                                         
P00581     MOVE '7280'                 TO ACTIVE-PARAGRAPH.             
P00581*                                                                         
P00581     EXEC SQL                                                     
P00581        SELECT REG_GROUP_CD                                       
P00581        INTO   :LR-REG-GROUP-CD                                   
P00581        FROM   CSS_REG_PROFILE WITH(READUNCOMMITTED)                      
P00581        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                        
P00581                                                           
P00581                                                      
P00581     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT REG_GROUP_CD                                               
MFA-TR*       INTO   :LR-REG-GROUP-CD                                           
MFA-TR*       FROM   CSS_REG_PROFILE                                            
MFA-TR*       WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7280                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00581*                                                                         
P00581     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P00581     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00581        MOVE 'Y' TO WS-SEB-REGULATED-FL                           
P00581     ELSE                                                         
P00581        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
P00581           MOVE 'N' TO WS-SEB-REGULATED-FL                        
P00581        ELSE                                                      
P00581           MOVE PROGRAM-NAME        TO ABEND-PROGRAM              
P00581           MOVE 'SELECT'            TO ABEND-FUNCTION             
P00581           MOVE 'CSS_REG_PROFILE'   TO TABLE-1                    
P00581           MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1            
P00581           MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-3          
P00581           PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
P00581           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
P00581        END-IF                                                    
P00581     END-IF.                                                      
P00581                                                                  
P00581 7280-EXIT.                                                       
P00581     EXIT.                                                        
P00581*                                                                         
      ******************************************************************11270000
      * 7300-SELECT-GL-ACCT.                                           *11280000
      ******************************************************************11290000
       7300-SELECT-GL-ACCT.                                             
           EXEC SQL                                                     
               SELECT GL_ACCT_NO                                        
               INTO :GO-GL-ACCT-NO                                      
               FROM CSS_GL_ACCT_NO WITH(READUNCOMMITTED)                        
MCR310*        WHERE  COMPANY_NO        = :GO-COMPANY-NO                11350000
MCR310         WHERE  COMPANY_NO        = '01'                          
               AND    GL_ACCT_NAME      = :GO-GL-ACCT-NAME              
A37061                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     11310000
MFA-TR*        SELECT GL_ACCT_NO                                        11320000
MFA-TR*        INTO :GO-GL-ACCT-NO                                      11330000
MFA-TR*        FROM CSS_GL_ACCT_NO                                      11340000
MFA-TR*        WHERE  COMPANY_NO        = :GO-COMPANY-NO                11350000
MFA-TR*        WHERE  COMPANY_NO        = '01'                          11350000
MFA-TR*        AND    GL_ACCT_NAME      = :GO-GL-ACCT-NAME              11360000
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    11370000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7300'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_GL_ACCT_NO'      TO TABLE-1                     
CBSI          MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1             
CBSI          MOVE 'GL_ACCT_NAME'        TO TABLE-ELEMENT-2             
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-3             
              MOVE '01'                  TO HOSTVAR-ELEMENT-1           
              MOVE GO-GL-ACCT-NAME       TO HOSTVAR-ELEMENT-2           
CBSI          MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11550000
TP9263******************************************************************11560002
TP9263* 7400-SELECT-DELINQ-VALUE.                                      *11570002
TP9263******************************************************************11580002
TP9263 7400-SELECT-DELINQ-VALUE.                                        
TP9263     EXEC SQL                                                     
TP9263         SELECT DELINQ_VALUE                                      
TP9263         INTO :C8-DELINQ-VALUE                                    
TP9263         FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                       
P00581         WHERE  DELINQ_CD = :C8-DELINQ-CD                         
T23501           AND COMPANY_NO = :AT-COMPANY-NO                        
A37061                                                           
TP9263     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     11600002
MFA-TR*        SELECT DELINQ_VALUE                                      11610002
MFA-TR*        INTO :C8-DELINQ-VALUE                                    11620002
MFA-TR*        FROM CSS_DELINQUENCY                                     11630002
MFA-TR*        WHERE  DELINQ_CD = :C8-DELINQ-CD                         11640002
MFA-TR*          AND COMPANY_NO = :AT-COMPANY-NO                                
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                    11650002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

TP9263                                                                  
TP9263     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
TP9263                                                                  
TP9263     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
TP9263        NEXT SENTENCE                                             
TP9263     ELSE                                                         
TP9263        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
TP9263        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
TP9263        MOVE '7400'                TO ACTIVE-PARAGRAPH            
TP9263        MOVE 'SELECT'              TO ABEND-FUNCTION              
TP9263        MOVE 'CSS_DELINQUENCY'     TO TABLE-1                     
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
CBSI          MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
TP9263        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
TP9263        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
TP9263                                                                  
TP9263 7400-EXIT.                                                       
TP9263     EXIT.                                                        
      *                                                                 11830000
      ******************************************************************11840000
T21112* GETS LAST_UPDATE_TS FROM CSS_ACCOUNT FOR THE PARM-ACCOUNT-NO   *11830301
T21112******************************************************************11830401
T21112 7500-SELECT-UPDATE-TS.                                           
T21112*                                                                 11830601
T21112     EXEC SQL                                                     
T21112         SELECT REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
T21112           INTO :AT-LAST-UPDATE-TS                                
T21112           FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
T21112           WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                      
A37061                                                           
T21112     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     11830701
MFA-TR*        SELECT LAST_UPDATE_TS                                    11830801
MFA-TR*          INTO :AT-LAST-UPDATE-TS                                11830901
MFA-TR*          FROM CSS_ACCOUNT                                       11831001
MFA-TR*          WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                      11831101
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                    11831201

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21112*                                                                 11831301
T21112     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
T21112     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
T21112         CONTINUE                                                 
T21112     ELSE                                                         
T21112         IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
T21112             MOVE 200              TO   WS-ACTIVE-RETURN-CODE     
T21112                                        RS-RETURN-CODE            
T21112         ELSE                                                     
T21112             MOVE WS-ACTIVE-RETURN-CODE                           
T21112                                   TO   RS-RETURN-CODE            
T21112         END-IF                                                   
T21112         MOVE PROGRAM-NAME         TO   ABEND-PROGRAM             
T21112         MOVE '7500'               TO   ACTIVE-PARAGRAPH          
T21112         MOVE 'SELECT'             TO   ABEND-FUNCTION            
T21112         MOVE SPACES               TO   ABEND-SQL-PREDICATES      
T21112                                        ABEND-TABLES              
T21112         MOVE 'CSS_ACCOUNT'        TO   TABLE-1                   
T21112         MOVE 'ACCOUNT_NO'         TO   TABLE-ELEMENT-1           
T21112         MOVE AT-ACCOUNT-NO        TO   HOSTVAR-ELEMENT-1         
T21112         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
T21112         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
T21112     END-IF.                                                      
T21112*                                                                 11833603
T21112 7500-EXIT.                                                       
T21112     EXIT.                                                        
T21112*                                                                 11834001
      ******************************************************************11840000
      * 7999                                      *                     11850000
      ******************************************************************11860000
           EXEC SQL                                                     11870000
              INCLUDE CPD00075                                          11880000
           END-EXEC.                                                    11890000
                                                                        
REARCH******************************************************************        
REARCH*8000A-DELETE-GTT-ROWS                                           *        
REARCH******************************************************************        
REARCH 8000A-DELETE-GTT-ROWS.                                           
REARCH*                                                                         
REARCH     MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.          
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH          DELETE FROM #CSR02283_R1                         
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM SESSION.CSR02283_R1                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
REARCH*                                                                         
REARCH     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
REARCH         NEXT SENTENCE                                            
REARCH     ELSE                                                         
REARCH        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
REARCH        MOVE SQLCODE               TO ABEND-SQLCODE               
REARCH        MOVE '8000A'               TO ACTIVE-PARAGRAPH            
REARCH        MOVE 'DELETE'              TO ABEND-FUNCTION              
REARCH        MOVE SPACES                TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH        MOVE 'CSR02283_R1'         TO TABLE-1                     
REARCH        MOVE SPACES                TO TABLE-ELEMENT-1             
REARCH        MOVE SPACES                TO HOSTVAR-ELEMENT-1           
REARCH        PERFORM 9000-SEND-ERROR-RESULT                            
REARCH                                   THRU 9000-EXIT                 
REARCH        PERFORM 9900-SQL-ERROR-ROUTINE                            
REARCH                                   THRU 9900-EXIT                 
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH 8000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
REARCH******************************************************************        
REARCH*8100-SEND-RESULT                                                *        
REARCH******************************************************************        
REARCH 8100-SEND-RESULT.                                                
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH          INSERT INTO #CSR02283_R1                         
REARCH          (                                                       
REARCH               RETURN_CODE                                        
REARCH              ,CHG_DATE                                           
REARCH              ,CHG_AMT                                            
REARCH              ,CHG_TYPE                                           
REARCH              ,DEBIT_CREDIT_IND                                   
REARCH              ,GAS_ACCOUNT_ONLY                                   
REARCH              ,GL_ACCT_NO                                         
REARCH              ,AR_LOCKOUT_IND                                     
REARCH              ,SECURED_RATE_FL                                    
REARCH              ,DELINQ_VALUE                                       
REARCH              ,LAST_UPDATE_TS                                     
REARCH              ,ACCT_TYPE_CD                                       
REARCH          )                                                       
REARCH          VALUES                                                  
REARCH          (                                                       
REARCH               :S-RETURN-CODE                                     
REARCH              ,:S-CHG-DATE                                        
REARCH              ,:S-CHG-AMT                                         
REARCH              ,:S-CHG-TYPE                                        
REARCH              ,:S-DEBIT-CREDIT-IND                                
REARCH              ,:S-GAS-ACCOUNT-ONLY                                
REARCH              ,:S-GL-ACCT-NO                                      
REARCH              ,:S-AR-IND                                          
REARCH              ,:S-SECURED-RATE-FL                                 
REARCH              ,:S-DELINQ-VALUE                                    
REARCH              ,:S-LAST-UPDATE-TS                                  
REARCH              ,:S-ACCT-TYPE-CD                                    
REARCH          )                                                       
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR02283_R1                                 
MFA-TR*         (                                                       01670000
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,CHG_DATE                                                   
MFA-TR*             ,CHG_AMT                                                    
MFA-TR*             ,CHG_TYPE                                                   
MFA-TR*             ,DEBIT_CREDIT_IND                                           
MFA-TR*             ,GAS_ACCOUNT_ONLY                                           
MFA-TR*             ,GL_ACCT_NO                                                 
MFA-TR*             ,AR_LOCKOUT_IND                                             
MFA-TR*             ,SECURED_RATE_FL                                            
MFA-TR*             ,DELINQ_VALUE                                               
MFA-TR*             ,LAST_UPDATE_TS                                             
MFA-TR*             ,ACCT_TYPE_CD                                               
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                       01670000
MFA-TR*              :S-RETURN-CODE                                             
MFA-TR*             ,:S-CHG-DATE                                                
MFA-TR*             ,:S-CHG-AMT                                                 
MFA-TR*             ,:S-CHG-TYPE                                                
MFA-TR*             ,:S-DEBIT-CREDIT-IND                                        
MFA-TR*             ,:S-GAS-ACCOUNT-ONLY                                        
MFA-TR*             ,:S-GL-ACCT-NO                                              
MFA-TR*             ,:S-AR-IND                                                  
MFA-TR*             ,:S-SECURED-RATE-FL                                         
MFA-TR*             ,:S-DELINQ-VALUE                                            
MFA-TR*             ,:S-LAST-UPDATE-TS                                          
MFA-TR*             ,:S-ACCT-TYPE-CD                                            
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH                                                                  
REARCH*                                                                         
REARCH     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
REARCH*                                                                         
REARCH     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
REARCH          ADD +1                    TO CTR-ROWS                   
REARCH     ELSE                                                         
REARCH          MOVE PROGRAM-NAME         TO ABEND-PROGRAM              
REARCH          MOVE SQLCODE              TO ABEND-SQLCODE              
REARCH          MOVE '8100'               TO ACTIVE-PARAGRAPH           
REARCH          MOVE 'INSERT'             TO ABEND-FUNCTION             
REARCH          MOVE SPACES               TO ABEND-SQL-PREDICATES       
REARCH                                       ABEND-TABLES               
REARCH          MOVE 'CSR02283_R1'        TO TABLE-1                    
REARCH          MOVE SPACES               TO TABLE-ELEMENT-1            
REARCH          MOVE SPACES               TO HOSTVAR-ELEMENT-1          
REARCH          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH 8100-EXIT.                                                       
REARCH     EXIT.                                                        
REARCH*                                                                         
      ******************************************************************11910000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     11920000
      ******************************************************************11930000
REARCH     EXEC SQL                                                             
REARCH          INCLUDE CPDSP300                                                
REARCH     END-EXEC.                                                            
      ******************************************************************11980000
      *       END PROGRAM COPYLIB                                      *11990000
      ******************************************************************12000000
REARCH     EXEC SQL                                                     16360000
REARCH          INCLUDE CPD00320                                        16360000
REARCH     END-EXEC.                                                    16360000
