000100 IDENTIFICATION DIVISION.                                         
000200 PROGRAM-ID.       CSR02278.                                      
COB303 DATE-WRITTEN.     SEPTEMBER 19, 2005.                            
000400 DATE-COMPILED.                                                   
000500                                                                  
000600******************************************************************00060000
000700*                SOUTH CAROLINA ELECTRIC & GAS                   *00070000
000800*                                                                *00080000
000900*  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00090000
001000*                                                                *00100000
001100*  TRANID:        S278                                           *00110000
001200*  PROGRAM:       S278                                           *00120000
001300*  CALLING SP:    PA_S278                                        *00130000
001400*                                                                *00140000
001500******************************************************************00150000
001600*                 P R O G R A M  S U M M A R Y                   *00160000
001700*                                                                *00170000
001800*  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *00180000
001900*  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *00190000
002000*  THIS PROGRAM RETRIEVES ROWS FROM CSS_MSTSUB_ACCT USING        *00200000
002100*  ACCOUNT_NO AS THE PRDICATE TO FIND OUT ALL THE SUBACCOUNTS    *00210000
002200*  FOR A PARTICULAR MASTER ACCOUNT, AND BUSINESS NAME     FROM   *00220000
002300*  CSS_ACCT_BILL_NMES , AND BILL TYPE AND BILL CYCLE FROM        *00230000
002400*  CSS_ACCOUNT WITH ACCOUNT_NO AS THE PREDICATE.                 *00240000
002500*                                                                *00250000
002600******************************************************************00260000
002700*                                                                *00270000
002800*                     PROGRAM MODIFICATION LOG                   *00280000
002900*                                                                *00290000
003000*    DATE    INITIALS   COMMENTS                                 *00300000
003100*  --------  --------   ---------------------------------------  *00310000
003200*  09/05/95    PD       CREATED.                                 *00320000
003300*                                                                *00330000
003300*  04/11/96    CJF      TPR 3802                                 *00340000
003300*                       MOVED UPDATE OF MST-SUB-IND TO S279      *00350000
003300*                       RETURN CODE 0F 300 WHEN AN ELIGIBLE      *00360000
003300*                       ACCOUNT IS NOT ALREADY A MASTER. PANEL   *00370000
003300*                       WILL THEN PROMPT USER BEFORE UPDATING.   *00380000
003300*                                                                *00390000
003300*   04/11/96   CJF      MAKE FINAL BILL AND INACTIVE ACCOUNTS    *00400000
003300*                       NOT ELIGIBLE TO BE MASTER                *00410000
      *                                                                *00420000
      *   05/29/96   ALI      INITIALIZED RS-ACCOUNT-NAME IN PARA 2220 *00430000
003300*                       TO AVOID THE DUPLICATION OF NAME.        *00440000
003300*                                                                *00450000
      *   06/21/96   ALI      MODIFIED TO SELECT THE CORRECT VALUES OF *00460000
003300*                       AT-AR-XFER-IND & AT-BILL-HIST-XFER-IND   *00470000
003300*                       AND POPULATE THE VALUE OF BILL-TYPE      *00480000
      *                       CORRECTLY (TPR#4646)                     *00490000
T11441*   06/04/97   AS       MODIFIED LOGIC TO SEND BACK BUSINESS NAME*00491000
T12273*   07/24/97   AS       CHANGED VALUE FOR WS-CNT-NAME-CD TO      *00492000
T12273*                       512 FROM 44. THIS IS THE NEW VALUE FOR   *00493000
T12273*                       CONSOLIDATED BILLING CHARGE CONTRACTS.   *00494000
T12273*                       ALSO CHANGED LOGIC TO SELECT ONLY ACTIVE *00495000
T12273*                       OR PENDING CONTRACTS.                    *00496000
PCR638*   05/13/98   AMG      CHANGED ALL REFERENCES TO SUB-TOTAL-CODE *00497000
PCR638*                       TO DEAL WITH A PIC X(18) INSTEAD OF ANY  *00498000
PCR638*                       NUMERIC FIELDS.                          *00499000
T16714*   06/08/98   VIJI     TO REMOVE HARDCODED VALUES FOR PAYMENT   *00499100
      *                       TERMS AND USE CSS_DELINQUENCY TABLE      *00499200
T16844*   06/17/98   KB       TO CHECK  FOR CODE-PRNT-BLL-MST ALONG    *00499100
      *                       WITH MAST-SUB-IND                        *00499200
T17106*   07/16/98   VIJI     TO SET THE ELIGIBLE FLAG PROPERLY        *        
      *                                                                *        
CBSI  *  12/16/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *             MADRAS    ABEND PARAMETERS                         *        
T18731*  12/18/98    SV       PASS SUB ACCT STATUS TO PANEL 128        *        
T17547*  10/26/99   RDF       PUT IN DELINQUENCY TABLE FOR NUMBER OF   *        
T17547*                       DAYS FOR SUB TO NO LONGER DISPLAY        *        
C22455*  10/09/00   SS        CHANGED VALUE FROM 20 TO 23 TO           *        
      *                       ACCOMODATE 22 DISTINCT BILLING CYLCES    *        
      *                       PLUS CYCLE OF '00' FOR PENDING.          *        
T23501*  02/13/01   SFH       ADDED COMPANY_NO TO THE WHERE CLAUSE IN  *        
      *                       PARA 2231 TO SUPPORT MULTI-COMPANY.      *        
REARCH*  09/19/05   CVNS      RPC TO COBOL SP CONVERSION               *        
REARCH*             CHENNAI                                            *        
ADDR  *  09/01/07   MH94819   ADDR FORMATTED CHANGES                   *        
T35434*  11/23/07   SP94986   REPLACED CSS_MODEL_SQL WITH SET STMTS    *        
T35434*                       AND ADDED FOR FETCH ONLY WITH UR FOR     *        
T35434*                       CURSOR SELECTS AND WITH UR FOR SINGLETON *        
T35434*                       SELECTS.                                 *        
C37808*  10/13/08   RC41079   CHANGE TO HANDLE NOT FOUND CONDITION IN  *        
C37808*                       PARA 2230-FIND-PAYMENT-TERMS IN FINDING  *        
C37808*                       DISTINCT BILL CYCLE.                     *        
003400******************************************************************00500000
003500******************************************************************00510000
003600*                                                                *00520000
003700*                ---- BASIC SEQUENCE STRUCTURE ----              *00530000
003800*                                                                *00540000
003900*  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00550000
004000*  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00560000
004100*  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00570000
004200*  3000 - 4999  NOT USED                                         *00580000
004300*  5000 - 5999  COMMON PROGRAM MODULES                           *00590000
004400*  6000 - 6999  COMMON SYSTEM MODULES                            *00600000
004500*  7000 - 7999  INPUT MODULES                                    *00610000
004600*  8000 - 8999  OUTPUT MODULES                                   *00620000
004700*  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00630000
004800*                                                                *00640000
004900******************************************************************00650000
005000                                                                  
005100 ENVIRONMENT DIVISION.                                            
005200 DATA DIVISION.                                                   
005300 WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02278'.
MSQ017     COPY MFASQLM.
005400                                                                  
005500 01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02278 STARTS HERE'.                  
005700                                                                  
005800******************************************************************00740000
005900*    DB2 INCLUDES                                                *00750000
006000******************************************************************00760000
006100                                                                  
006200     EXEC SQL                                                     00780000
006300        INCLUDE SQLCA                                             00790000
006400     END-EXEC.                                                    00800000
006500                                                                  
006600*-------< INCLUDE CSS_ACCOUNT >                                   00820000
006700     EXEC SQL                                                     00830000
006800        INCLUDE TBACCT                                            00840000
006900     END-EXEC.                                                    00850000
007000                                                                  
007100*-------< INCLUDE CSS_CONTRACT>                                   00870000
007200     EXEC SQL                                                     00880000
007300        INCLUDE TBCNTRCT                                          00890000
007400     END-EXEC.                                                    00900000
007500                                                                  
007600*-------< INCLUDE CSS_MSTSUB_ACCT >                               00920000
007700     EXEC SQL                                                     00930000
007800        INCLUDE TBMSTSUB                                          00940000
007900     END-EXEC.                                                    00950000
008000                                                                  
008100*-------< INCLUDE CSS_ACCT_BILL_NMES>                             00970000
008200     EXEC SQL                                                     00980000
008300        INCLUDE TBATBLNM                                          00990000
008400     END-EXEC.                                                    01000000
008500                                                                  
008600*-------< INCLUDE CSS_NAME>                                       01020000
008700     EXEC SQL                                                     01030000
008800        INCLUDE TBNAME                                            01040000
008900     END-EXEC.                                                    01050000
009000                                                                  
T16714     EXEC SQL                                                     01101000
T16714        INCLUDE TBDELQ                                            01102000
T16714     END-EXEC.                                                    01103000
T16714                                                                  
009500******************************************************************01110000
009600*    COBOL WORKING STORAGE COPY BOOKS                            *01120000
009700******************************************************************01130000
009800                                                                  
009900*--------< CONTAINS THE COBOL EQUATES NEEDED FOR USING THE >      01150000
010000*--------< SYBASE OPEN SERVER FOR CICS FACILITIES.         >      01160000
REARCH*    COPY SYGWCOB.                                                01170000
010200*--------< ADDED TO SUPPORT CICS RPCS >                           01180000
REARCH*    COPY SYDBCOB.                                                01190000
010400*--------<COMMON SYSTEM AREA >                                    01200000
010500     COPY CCA00001.                                               01210000
010600*--------< ERROR HANDLING >                                       01220000
REARCH*    COPY CWS00010.                                               01230000
010800*--------< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >       01240000
010900     COPY CWS00027.                                               01250000
011000*--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                  01260000
011100     COPY CWS00303.                                               01270000
REARCH*                                                                         
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CWSX0010                                                 
REARCH     END-EXEC.                                                            
011300******************************************************************01290000
011400*    WORK AREAS                                                  *01300000
011500******************************************************************01310000
REARCH*                                                                 01320000
REARCH 01  GW-LIB-MISC-FIELDS.                                          
REARCH     05  PROGRAM-NAME            PIC X(08) VALUE 'CSR02278'.      
REARCH     05  WS-SQLSTATE             PIC X(05) VALUE SPACES.          
REARCH*    05  GWL-PROC                POINTER.                         01350000
REARCH*    05  GWL-INIT-HANDLE         POINTER.                         01360000
REARCH*    05  GWL-RC                  PIC S9(9) COMP.                  01370000
REARCH*    05  GWL-STATUS-NR           PIC S9(9) COMP.                  01380000
REARCH*    05  GWL-STATUS-DONE         PIC S9(9) COMP.                  01390000
REARCH*    05  GWL-STATUS-COUNT        PIC S9(9) COMP.                  01400000
REARCH*    05  GWL-STATUS-COMM         PIC S9(9) COMP.                  01410000
REARCH*    05  GWL-STATUS-RETURN-CODE  PIC S9(9) COMP.                  01420000
REARCH*    05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  01430000
012800                                                                  
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  GTT-NAME                PIC X(26)                        
REARCH                                     VALUE 'SESSION.CSR02278_R1'. 
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN          PIC S9(04) COMP.                 
REARCH         49 GTT-ROW-CHAR         PIC X(1024).                     
REARCH     05  GTT-SQLCODE             PIC S9(9) COMP.                  
REARCH*                                                                         
012900 01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
013000                                                                  
REARCH*01  PARM-FIELDS.                                                 01470000
REARCH*    05  PARM-L                  PIC S9(9) COMP.                  01480000
REARCH*    05  PARM-ID1                PIC S9(9) COMP VALUE 1.          01490000
REARCH*    05  PARM-ACCOUNT-NO         PIC X(13) VALUE SPACES.          01500000
013500                                                                  
013600 01  SNA-FIELDS.                                                  
013700     05  SNA-SUBC                PIC S9(9) COMP.                  
013800     05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
013900                                                                  
014000 01  COUNTER-FIELDS.                                              
014100     05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
014200     05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
014300     05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
014400                                                                  
014500 01  WORK-FIELDS.                                                 
014600     05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
014700     05  WRKLEN1                 PIC S9(9) COMP.                  
014800     05  WRKLEN2                 PIC S9(9) COMP.                  
014900     05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
015000                                                                  
015100 01  WS-FLAG-VALUES.                                              
015200     05  WS-YES                    PIC X(01) VALUE 'Y'.           
015300     05  WS-NO                     PIC X(01) VALUE 'N'.           
015400     05  WS-ACTIVE-CODE            PIC X(01) VALUE 'A'.           
015500     05  WS-CA-ACTIVE-RETURN-CODE  PIC S9(9) COMP.                
015600                                                                  
015700 01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
015800                                                                  
015900 01  TDS-RETURN-FIELDS.                                           
016000     05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
016100     05  RS-SUB-ACCT-NO          PIC X(13) VALUE SPACES.          
016200*    05  RS-ACCOUNT-NAME         PIC X(50) VALUE SPACES.          01780000
ADDR       05  RS-ACCOUNT-NAME         PIC X(76) VALUE SPACES.          
016300     05  RS-BILL-TYPE            PIC X(01) VALUE SPACES.          
016400     05  RS-BILL-CYCLE           PIC X(02) VALUE SPACES.          
016500     05  RS-BILL-STATUS          PIC X(01) VALUE SPACES.          
016600*    05  RS-SUB-TOTAL-CODE       PIC X(04) VALUE SPACES.          01820000
PCR638     05  RS-SUB-TOTAL-CODE       PIC X(18) VALUE SPACES.          
016700     05  RS-CODE-BILL-FREQ       PIC X(03) VALUE SPACES.          
016800     05  RS-NO-BILL-COPIES       PIC X(04) VALUE SPACES.          
016900     05  RS-BILL-CYCLE-MST       PIC X(02) VALUE SPACES.          
017000     05  RS-MST-OVRRD-BLL-IND    PIC X(01) VALUE SPACES.          
017100     05  RS-CODE-PRNT-BLL-MST    PIC X(01) VALUE SPACES.          
017200     05  RS-AMT-MO-PYMT          PIC S9(09)V9(02) USAGE           
017210                                 COMP-3 VALUE 0.                  
017300     05  RS-PAYMENT-TERMS        PIC X(4)  VALUE SPACES.          
T18731     05  RS-SUB-ACCT-STATUS      PIC X(01) VALUE SPACES.          
REARCH                                                                  
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
REARCH     05  S-SUB-ACCT-NO          PIC X(13) VALUE SPACES.           
REARCH*    05  S-ACCOUNT-NAME         PIC X(50) VALUE SPACES.           01780000
ADDR       05  S-ACCOUNT-NAME         PIC X(76) VALUE SPACES.           
REARCH     05  S-BILL-TYPE            PIC X(01) VALUE SPACES.           
REARCH     05  S-BILL-CYCLE           PIC X(02) VALUE SPACES.           
REARCH     05  S-BILL-STATUS          PIC X(01) VALUE SPACES.           
REARCH     05  S-SUB-TOTAL-CODE       PIC X(18) VALUE SPACES.           
REARCH     05  S-CODE-BILL-FREQ       PIC X(03) VALUE SPACES.           
REARCH     05  S-NO-BILL-COPIES       PIC X(04) VALUE SPACES.           
REARCH     05  S-BILL-CYCLE-MST       PIC X(02) VALUE SPACES.           
REARCH     05  S-MST-OVRRD-BLL-IND    PIC X(01) VALUE SPACES.           
REARCH     05  S-CODE-PRNT-BLL-MST    PIC X(01) VALUE SPACES.           
REARCH     05  S-AMT-MO-PYMT          PIC S9(09)V9(02) USAGE            
REARCH                                 COMP-3 VALUE 0.                  
REARCH     05  S-PAYMENT-TERMS        PIC X(4)  VALUE SPACES.           
REARCH     05  S-SUB-ACCT-STATUS      PIC X(01) VALUE SPACES.           
REARCH*                                                                         
REARCH*01  CNS-COLUMN-NAMES.                                            01920000
REARCH*    05  CNS-RETURN-CODE        PIC X(11) VALUE 'RETURN_CODE'.    01930000
REARCH*    05  CNS-SUB-ACCT-NO        PIC X(11)                         01940000
REARCH*                               VALUE 'SUB_ACCT_NO'.              01950000
REARCH*    05  CNS-ACCOUNT-NAME       PIC X(12)                         01960000
REARCH*                               VALUE 'ACCOUNT_NAME'.             01970000
REARCH*    05  CNS-BILL-TYPE          PIC X(09)                         01980000
REARCH*                               VALUE 'BILL_TYPE'.                01990000
REARCH*    05  CNS-BILL-CYCLE         PIC X(10)                         02000000
REARCH*                               VALUE 'BILL_CYCLE'.               02010000
REARCH*    05  CNS-BILL-STATUS        PIC X(11)                         02020000
REARCH*                               VALUE 'BILL_STATUS'.              02030000
REARCH*    05  CNS-SUB-TOTAL-CODE     PIC X(14)                         02040000
REARCH*                               VALUE 'SUB_TOTAL_CODE'.           02050000
REARCH*    05  CNS-CODE-BILL-FREQ     PIC X(14)                         02060000
REARCH*                               VALUE 'CODE_BILL_FREQ'.           02070000
REARCH*    05  CNS-NO-BILL-COPIES     PIC X(14)                         02080000
REARCH*                               VALUE 'NO_BILL_COPIES'.           02090000
REARCH*    05  CNS-BILL-CYCLE-MST     PIC X(14)                         02100000
REARCH*                               VALUE 'BILL_CYCLE_MST'.           02110000
REARCH*    05  CNS-MST-OVRRD-BLL-IND  PIC X(17)                         02120000
REARCH*                               VALUE 'MST_OVRRD_BLL_IND'.        02130000
REARCH*    05  CNS-CODE-PRNT-BLL-MST  PIC X(17)                         02140000
REARCH*                               VALUE 'CODE_PRNT_BLL_MST'.        02150000
REARCH*    05  CNS-AMT-MO-PYMT        PIC X(11)                         02160000
REARCH*                               VALUE 'AMT_MO_PYMT'.              02170000
REARCH*    05  CNS-PAYMENT-TERMS      PIC X(13)                         02180000
REARCH*                               VALUE 'PAYMENT_TERMS'.            02190000
REARCH*    05  CNS-SUB-ACCT-STATUS    PIC X(15)                                 
REARCH*                               VALUE 'SUB_ACCT_STATUS'.                  
020300                                                                  
020400 01  GENERAL-WORKING-STORAGE.                                     
020500     05  WS-ACCOUNT-NUM          PIC X(13).                       
020600     05  WS-ACCOUNT-DEC REDEFINES WS-ACCOUNT-NUM                  
020700                                 PIC 9(13).                       
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.        
COB305     05 WS-CUSTOMER-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.        
020900                                                                  
021000     05  WS-SUB-ACCT-NUM         PIC X(13).                       
021100     05  WS-SUB-ACCT-DEC REDEFINES WS-SUB-ACCT-NUM                
021200                                 PIC 9(13).                       
COB305     05 WS-SUB-ACCT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.        
021400                                                                  
021500*    05  WS-SUB-TOTAL-CODE-NUM   PIC X(04).                       02330000
021600*    05  WS-SUB-TOTAL-CODE-DEC   REDEFINES                        02340000
021700*                                WS-SUB-TOTAL-CODE-NUM            02350000
021800*                                PIC 9(04).                       02360000
021900*    05  WS-SUB-TOTAL-CODE       PIC S9(04) USAGE COMP-3.         02370000
PCR638     05  WS-SUB-TOTAL-CODE       PIC X(18).                       
022000                                                                  
022100     05  WS-PAYMENT-TERMS-INT    PIC 9(04).                       
022200     05  WS-PAYMENT-TERMS        PIC S9(4)  COMP VALUE 0.         
022300                                                                  
022400     05  WS-AT-BILL-CYCLE-NI     PIC S9(4)  COMP VALUE 0.         
022500     05  WS-AT-XFER-IND-NI       PIC S9(4)  COMP VALUE 0.         
022600     05  WS-AT-BILL-HIST-XFER-IND-NI                              
022700                                 PIC S9(4)  COMP VALUE 0.         
022800     05  WS-AMT-MO-PYMT-NI                                        
022900                                 PIC S9(4)  COMP VALUE 0.         
023000                                                                  
023100     05  WS-RECORD-FOUND         PIC X(01) VALUE SPACES.          
023200     05  WS-FETCH-RETURN-CODE    PIC S9(09) COMP VALUE 0.         
023300     05  WS-AMT-MO-PYMT          PIC S9(09)V9(2) USAGE COMP-3     
023400                                 VALUE 0.                         
023500     05  WS-AMT-MO-PYMT-INT      PIC 9(11) VALUE 0.               
023510     05  WS-UTILITY-ACCT         PIC X(1)  VALUE SPACES.          
023520     05  WS-ELIGIBLE-FLAG        PIC X(1)  VALUE SPACES.          
023530     05  WS-DISTINCT-BILL-CYCLE  PIC S9(4) COMP VALUE 0.          
023540     05  WS-1                    PIC S9(4) COMP VALUE 1.          
023550     05  WS-5                    PIC S9(4) COMP VALUE 5.          
023560     05  WS-6                    PIC S9(4) COMP VALUE 6.          
023570     05  WS-10                   PIC S9(4) COMP VALUE 10.         
023580     05  WS-11                   PIC S9(4) COMP VALUE 11.         
023590     05  WS-15                   PIC S9(4) COMP VALUE 15.         
023591     05  WS-16                   PIC S9(4) COMP VALUE 16.         
T12273*    05  WS-CNT-NAME-CD          PIC S9(4) COMP VALUE 44.         02640000
T12273     05  WS-CNT-NAME-CD          PIC S9(4) COMP VALUE 512.        
T16714     05  WS-DELINQ-VALUE         PIC S9(4) COMP.                  
023600                                                                  
023700 01  SWITCHES.                                                    
023800     05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
023900         88 NOT-ALL-DONE                   VALUE 'N'.             
024000         88 ALL-DONE                       VALUE 'Y'.             
024100     05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
024200         88 SEND-DONE-ERROR                VALUE 'N'.             
024300         88 SEND-DONE-OK                   VALUE 'Y'.             
      *                                                                         
T17547 01  TPR17547-WORK-FIELDS.                                        
T17547     05 WS-NULL-IND              PIC S9(4) COMP   VALUE ZEROS.    
T17547     05 WS-WORK-DATE26           PIC X(26)        VALUE SPACES.   
T17547     05 WS-WORK-DATE             PIC X(10)        VALUE SPACES.   
T17547     05 WS-PLUS60-DATE           PIC X(10)        VALUE SPACES.   
T17547     05 WS-CURRENT-DATE          PIC X(10)        VALUE SPACES.   
T17547     05 WS-DEL-DAYS              PIC S9(3) COMP-3 VALUE ZEROS.    
T17547*    05 WS-DEL-DAYS              PIC S9(9) COMP   VALUE ZEROS.            
      *                                                                         
REARCH*                                                                         
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
REARCH     10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
REARCH     10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
REARCH     10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
REARCH         49  S-HOST-VARIABLES-V  PIC X(255).                      
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-STATEMENT-V   PIC X(255).                      
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-DESCRIPTION-V PIC X(255).                      
REARCH*                                                                         
024500******************************************************************02750000
024600*    CURSOR DECLARATIONS                                         *02760000
024700******************************************************************02770000
024800                                                                  
024900*--- < CURSOR FOR CSS_CUST_ALERT >                                02790000
025000                                                                  
025100     EXEC SQL DECLARE SUB-ACCT-CURSOR CURSOR FOR                  
025200         SELECT     SUB_ACCT_NO,                                  
025300                    CODE_SUB_TOTAL,                               
025400                    SUB_ACCT_BLLD_OK                              
025500         FROM       CSS_MSTSUB_ACCT WITH(READUNCOMMITTED)                 
025600         WHERE      MST_ACCT_NO       =:WS-ACCOUNT-NO             
025610         ORDER BY SUB_ACCT_NO                                     
T35434         FOR READ ONLY                                    
025700     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE SUB-ACCT-CURSOR CURSOR FOR                  02810000
MFA-TR*        SELECT     SUB_ACCT_NO,                                  02820000
MFA-TR*                   CODE_SUB_TOTAL,                               02830000
MFA-TR*                   SUB_ACCT_BLLD_OK                              02840000
MFA-TR*        FROM       CSS_MSTSUB_ACCT                               02850000
MFA-TR*        WHERE      MST_ACCT_NO       =:WS-ACCOUNT-NO             02860000
MFA-TR*        ORDER BY SUB_ACCT_NO                                     02870000
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                    02880000
025800                                                                  
025900                                                                  
REARCH LINKAGE SECTION.                                                 
REARCH*                                                                         
REARCH 01  PARM-ACCOUNT-NO       PIC X(13).                             
REARCH*                                                                         
REARCH PROCEDURE DIVISION USING PARM-ACCOUNT-NO.                        
026000                                                                  
026300                                                                  
026400******************************************************************02950000
026500* 0000-MAINLINE                                                  *02960000
026600*     CALLS 0100-INITIALIZE                                      *02970000
026700*           1000-PROCESS-INPUT                                   *02980000
026800*           2000-PROCESS-OUTPUT                                  *02990000
026900*           9999-END-PROGRAM                                     *03000000
027000*                                                                *03010000
027100*     CONTROLS THE MAIN PATH OF THE PROGRAM                      *03020000
027200******************************************************************03030000
027300                                                                  
027400 0000-MAINLINE.                                                   
027500                                                                  
027600     PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
027700     PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
027800     PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
027900     PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
028000                                                                  
028100 0000-EXIT.                                                       
028200     EXIT.                                                        
028300                                                                  
028400******************************************************************03150000
028500* 0100-INITIALIZE                                                *03160000
028600*     CALLS 9000-SEND-ERROR-RESULT                               *03170000
028700*           9900-SQL-ERROR-ROUTINE                               *03180000
028800*                                                                *03190000
028900*     CALLED FROM 0000-MAINLINE                                  *03200000
029000*                                                                *03210000
029100*     1. RESET DB2 ERROR HANDLERS                                *03220000
029200*     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *03230000
029300*     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *03240000
029400*     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*03250000
029500*                                                                *03260000
029600******************************************************************03270000
029700                                                                  
029800 0100-INITIALIZE.                                                 
029900                                                                  
030000     MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
030100                                                                  
030200     EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
030300     EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
030400     EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
030500                                                                  
REARCH*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.     03370000
REARCH*                                                                 03380000
REARCH*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,     03390000
REARCH*                          SNA-CONNECTION-NAME, SNA-SUBC.         03400000
REARCH*                                                                 03410000
REARCH*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                      03420000
REARCH*                                                                 03430000
REARCH*    IF GWL-RC NOT = TDS-PARM-PRESENT                             03440000
REARCH*       MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     03450000
REARCH*       MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION      03460000
REARCH*       MOVE 'CICS TRANSACTION'   TO TABLE-1                      03470000
REARCH*       MOVE GWL-RC               TO WS-ACTIVE-RETURN-CODE        03480000
REARCH*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            03490000
REARCH*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            03500000
REARCH*    END-IF.                                                      03510000
REARCH*                                                                         
REARCH     PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT  RETURN_CODE                                      
REARCH                ,SUB_ACCT_NO                                      
REARCH                ,LTRIM(RTRIM(ACCOUNT_NAME))   AS ACCOUNT_NAME            
REARCH                ,BILL_TYPE                                        
REARCH                ,BILL_CYCLE                                       
REARCH                ,BILL_STATUS                                      
REARCH                ,LTRIM(RTRIM(SUB_TOTAL_CODE)) AS SUB_TOTAL_CODE          
REARCH                ,CODE_BILL_FREQ                                   
REARCH                ,NO_BILL_COPIES                                   
REARCH                ,BILL_CYCLE_MST                                   
REARCH                ,MST_OVRRD_BLL_IND                                
REARCH                ,CODE_PRNT_BLL_MST                                
REARCH                ,AMT_MO_PYMT                                      
REARCH                ,PAYMENT_TERMS                                    
REARCH                ,SUB_ACCT_STATUS                                  
REARCH         FROM                                                     
REARCH             #CSR02278_R1                                  
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT  RETURN_CODE                                              
MFA-TR*               ,SUB_ACCT_NO                                              
MFA-TR*               ,STRIP(ACCOUNT_NAME)   AS ACCOUNT_NAME                    
MFA-TR*               ,BILL_TYPE                                                
MFA-TR*               ,BILL_CYCLE                                               
MFA-TR*               ,BILL_STATUS                                              
MFA-TR*               ,STRIP(SUB_TOTAL_CODE) AS SUB_TOTAL_CODE                  
MFA-TR*               ,CODE_BILL_FREQ                                           
MFA-TR*               ,NO_BILL_COPIES                                           
MFA-TR*               ,BILL_CYCLE_MST                                           
MFA-TR*               ,MST_OVRRD_BLL_IND                                        
MFA-TR*               ,CODE_PRNT_BLL_MST                                        
MFA-TR*               ,AMT_MO_PYMT                                              
MFA-TR*               ,PAYMENT_TERMS                                            
MFA-TR*               ,SUB_ACCT_STATUS                                          
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR02278_R1                                          
MFA-TR*    END-EXEC.                                                            
032100                                                                  
032200 0100-EXIT.                                                       
032300     EXIT.                                                        
REARCH*                                                                         
REARCH******************************************************************        
REARCH* 0100A-DECLARE-GTT                                              *        
REARCH******************************************************************        
REARCH*                                                                         
REARCH 0100A-DECLARE-GTT.                                               
REARCH                                                                  
REARCH     MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR02278_R1'            
REARCH                                   TO S-SQL-STATEMENT-V.          
REARCH     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02278_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02278_R1
              (                                                       
REARCH               RETURN_CODE               INT                  
REARCH              ,SUB_ACCT_NO CHAR(13)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                 
REARCH              ,ACCOUNT_NAME CHAR(76)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                 
REARCH              ,BILL_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH              ,BILL_CYCLE CHAR(02)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                 
REARCH              ,BILL_STATUS CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                 
REARCH              ,SUB_TOTAL_CODE CHAR(18)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                 
REARCH              ,CODE_BILL_FREQ CHAR(03)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                 
REARCH              ,NO_BILL_COPIES CHAR(04)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                 
REARCH              ,BILL_CYCLE_MST CHAR(02)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                 
REARCH              ,MST_OVRRD_BLL_IND CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                 
REARCH              ,CODE_PRNT_BLL_MST CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                 
REARCH              ,AMT_MO_PYMT               DECIMAL(11,2)            
REARCH              ,PAYMENT_TERMS CHAR(04)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                 
REARCH              ,SUB_ACCT_STATUS CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                 
REARCH          )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH     MOVE SQLSTATE                 TO WS-SQLSTATE.                
REARCH     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
REARCH     IF WS-SQLSTATE = '42710'                                     
REARCH        PERFORM 8000A-DELETE-GTT-ROWS                             
REARCH                                        THRU 8000A-EXIT           
REARCH     ELSE                                                         
REARCH       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
REARCH          NEXT SENTENCE                                           
REARCH       ELSE                                                       
REARCH          MOVE PROGRAM-NAME       TO ABEND-PROGRAM                
REARCH          MOVE SQLCODE            TO ABEND-SQLCODE                
REARCH          MOVE SQLSTATE           TO ABEND-SQLSTATE               
REARCH          MOVE '0100A'            TO ACTIVE-PARAGRAPH             
REARCH          MOVE 'DECLARE GTT'      TO ABEND-FUNCTION               
REARCH          MOVE SPACES             TO ABEND-SQL-PREDICATES         
REARCH                                     ABEND-TABLES                 
REARCH          MOVE 'CSR02278_R1'      TO TABLE-1                      
REARCH          MOVE SPACES             TO TABLE-ELEMENT-1              
REARCH          MOVE SPACES             TO HOSTVAR-ELEMENT-1            
REARCH          PERFORM 9900-SQL-ERROR-ROUTINE                          
REARCH                                  THRU  9900-EXIT                 
REARCH       END-IF                                                     
REARCH     END-IF.                                                      
REARCH 0100A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
032500******************************************************************03560000
032600* 1000-PROCESS-INPUT                                             *03570000
032700*     CALLS 1100-RECEIVE-PARMS                                   *03580000
032800*                                                                *03590000
032900*     CALLED FROM 0000-MAINLINE                                  *03600000
033000*                                                                *03610000
033100*     1. RECEIVE PARMS.                                          *03620000
033200******************************************************************03630000
033300                                                                  
033400 1000-PROCESS-INPUT.                                              
033500                                                                  
REARCH*    PERFORM 1100-RECEIVE-PARMS THRU 1100-EXIT.                   03670000
033700                                                                  
033800     MOVE PARM-ACCOUNT-NO       TO WS-ACCOUNT-NUM.                
033900     MOVE WS-ACCOUNT-DEC        TO MU-MST-ACCT-NO.                
034000     MOVE WS-ACCOUNT-DEC        TO WS-ACCOUNT-NO.                 
034100                                                                  
034200 1000-EXIT.                                                       
034300     EXIT.                                                        
034400                                                                  
034500******************************************************************03760000
034600* 1100-RECEIVE-PARMS                                             *03770000
034700*     CALLS TDRCVPRM                                             *03780000
034800*                                                                *03790000
034900*     CALLED FROM 1000-PROCESS-INPUT                             *03800000
035000*                                                                *03810000
035100*     GET THE PASSED PARMS FROM THE CLIENT                       *03820000
035200******************************************************************03830000
035300                                                                  
REARCH*1100-RECEIVE-PARMS.                                              03850000
REARCH*                                                                 03860000
REARCH*-------------< GET ACCOUNT-NO >                                  03870000
REARCH*    MOVE 1                                TO PARM-ID1.           03880000
REARCH*    MOVE LENGTH OF PARM-ACCOUNT-NO        TO MAX-LENGTH-PARM.    03890000
REARCH*                                                                 03900000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              03910000
REARCH*                          GWL-RC,                                03920000
RAERCH*                          PARM-ID1,                              03930000
REARCH*                          PARM-ACCOUNT-NO,                       03940000
REARCH*                          TDSCHAR,                               03950000
REARCH*                          MAX-LENGTH-PARM,                       03960000
REARCH*                          PARM-L.                                03970000
REARCH*                                                                 03980000
REARCH*                                                                 03990000
REARCH*1100-EXIT.                                                       04000000
REARCH*   EXIT.                                                         04010000
037100                                                                  
037200******************************************************************04030000
037300* 2000-PROCESS-OUTPUT.                                           *04040000
037400*     CALLS 2100-DESCRIBE-RESULT                                 *04050000
037500*           2200-BUILD-RESULT                                    *04060000
037600*                                                                *04070000
037700*      CALLED FROM 0000-MAINLINE                                 *04080000
037800*                                                                *04090000
037900*      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *04100000
038000*      AND SENDS THEN BACK                                       *04110000
038100******************************************************************04120000
038200                                                                  
038300 2000-PROCESS-OUTPUT.                                             
038400                                                                  
REARCH*    PERFORM 2100-DESCRIBE-RESULT          THRU 2100-EXIT.        04160000
038510     PERFORM 7410-SELECT-ACCOUNT-ELIGIBLE  THRU 7410-EXIT.        
038520*    IF (AT-MST-SUB-ACCT-IND = 'M'                                        
T16844*        OR  AT-CODE-PRNT-BLL-MST   = 'A' )                               
038520*        AND (AT-CODE-ACCT-STAT = 'A'                             04180000
038521*       OR  AT-CODE-ACCT-STAT = 'J')                              04190000
T17106     IF AT-MST-SUB-ACCT-IND = 'M' AND                             
T17106        AT-CODE-ACCT-STAT = 'A' AND                               
              AT-BANKRUPTCY-IND NOT = 'B'                               
038530        MOVE 'Y' TO WS-ELIGIBLE-FLAG                              
038540     ELSE                                                         
038550        PERFORM 7420-SELECT-UTILITY-TABLE  THRU 7420-EXIT         
038560        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
038570           IF AT-CODE-ACCT-STAT = 'S' OR                          
038580              AT-BANKRUPTCY-IND = 'B' OR                          
                    AT-CODE-ACCT-STAT = 'B'                             
038581              MOVE 'N' TO WS-ELIGIBLE-FLAG                        
038592           ELSE                                                   
039310              MOVE 300 TO   RS-RETURN-CODE                        
REARCH              PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT         
039320              PERFORM 8100-SEND-RESULT    THRU 8100-EXIT          
038595           END-IF                                                 
038596        ELSE                                                      
038597           MOVE 'N' TO WS-ELIGIBLE-FLAG                           
038598        END-IF                                                    
038599     END-IF.                                                      
038600     IF WS-ELIGIBLE-FLAG = 'Y'                                    
038610       PERFORM 7300-SELECT-MSTSUB-ACCT       THRU 7300-EXIT       
      *                                                                         
038700       IF WS-RECORD-FOUND = 'Y'                                   
038800          PERFORM 2200-BUILD-RESULT          THRU 2200-EXIT       
038900       ELSE                                                       
039000          MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE            
039010          PERFORM 2240-FIND-MASTER-INFO      THRU 2240-EXIT       
REARCH          PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT      
039100          PERFORM 8100-SEND-RESULT           THRU 8100-EXIT       
039200       END-IF                                                     
039300     ELSE                                                         
             IF RS-RETURN-CODE NOT = 300                                
039310          MOVE 200 TO   RS-RETURN-CODE                            
REARCH          PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT      
039320          PERFORM 8100-SEND-RESULT           THRU 8100-EXIT       
             END-IF                                                     
039330     END-IF.                                                      
      *                                                                         
039500 2000-EXIT.                                                       
039600     EXIT.                                                        
REARCH*                                                                         
REARCH*****************************************************************         
REARCH* 2000A-MOVE-RESULT.                                            *         
REARCH*****************************************************************         
REARCH*                                                                         
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH      MOVE RS-RETURN-CODE             TO S-RETURN-CODE.           
REARCH      MOVE RS-SUB-ACCT-NO             TO S-SUB-ACCT-NO.           
REARCH      MOVE RS-ACCOUNT-NAME            TO S-ACCOUNT-NAME.          
REARCH      MOVE RS-BILL-TYPE               TO S-BILL-TYPE.             
REARCH      MOVE RS-BILL-CYCLE              TO S-BILL-CYCLE.            
REARCH      MOVE RS-BILL-STATUS             TO S-BILL-STATUS.           
REARCH      MOVE RS-SUB-TOTAL-CODE          TO S-SUB-TOTAL-CODE.        
REARCH      MOVE RS-CODE-BILL-FREQ          TO S-CODE-BILL-FREQ.        
REARCH      MOVE RS-NO-BILL-COPIES          TO S-NO-BILL-COPIES.        
REARCH      MOVE RS-BILL-CYCLE-MST          TO S-BILL-CYCLE-MST.        
REARCH      MOVE RS-MST-OVRRD-BLL-IND       TO S-MST-OVRRD-BLL-IND.     
REARCH      MOVE RS-CODE-PRNT-BLL-MST       TO S-CODE-PRNT-BLL-MST.     
REARCH      MOVE RS-AMT-MO-PYMT             TO S-AMT-MO-PYMT.           
REARCH      MOVE RS-PAYMENT-TERMS           TO S-PAYMENT-TERMS.         
REARCH      MOVE RS-SUB-ACCT-STATUS         TO S-SUB-ACCT-STATUS.       
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
039700                                                                  
039800******************************************************************04560000
039900* 2100-DESCRIBE-RESULT                                           *04570000
040000*     CALLS 2110-DESC-RET-CODE                                   *04580000
040100*           2120-DESC-SUB-ACCT-NO                                *04590000
040200*           2130-DESC-ACCOUNT-NAME                               *04600000
040300*           2135-DESC-BILL-TYPE                                  *04610000
040400*           2140-DESC-BILL-CYCLE                                 *04620000
040500*           2145-DESC-BILL-STATUS                                *04630000
040600*           2150-DESC-SUB-TOTAL-CODE                             *04640000
040700*           2155-DESC-CODE-BILL-FREQ                             *04650000
040800*           2160-DESC-NO-BILL-COPIES                             *04660000
040900*           2165-DESC-BILL-CYCLE-MST                             *04670000
041000*           2170-DESC-MST-OVRRD-BLL-IND                          *04680000
041100*           2175-DESC-CODE-PRNT-BLL-MST                          *04690000
041200*           2180-DESC-AMT-MO-PYMT                                *04700000
041300*           2185-DESC-PAYMENT-TERMS                              *04710000
041400*                                                                *04720000
041500*     CALLED FROM 2000-PROCESS-OUTPUT                            *04730000
041600*                                                                *04740000
041700*     DESCRIBE EACH RESULT FIELD TO THE CLIENT                   *04750000
041800******************************************************************04760000
041900                                                                  
REARCH*2100-DESCRIBE-RESULT.                                            04780000
REARCH*                                                                 04790000
REARCH*    PERFORM 2110-DESC-RET-CODE              THRU 2110-EXIT.      04800000
REARCH*    PERFORM 2120-DESC-SUB-ACCT-NO           THRU 2120-EXIT.      04810000
REARCH*    PERFORM 2130-DESC-ACCOUNT-NAME          THRU 2130-EXIT.      04820000
REARCH*    PERFORM 2135-DESC-BILL-TYPE             THRU 2135-EXIT.      04830000
REARCH*    PERFORM 2140-DESC-BILL-CYCLE            THRU 2140-EXIT.      04840000
REARCH*    PERFORM 2145-DESC-BILL-STATUS           THRU 2145-EXIT.      04850000
REARCH*    PERFORM 2150-DESC-SUB-TOTAL-CODE        THRU 2150-EXIT.      04860000
REARCH*    PERFORM 2155-DESC-CODE-BILL-FREQ        THRU 2155-EXIT.      04870000
REARCH*    PERFORM 2160-DESC-NO-BILL-COPIES        THRU 2160-EXIT.      04880000
REARCH*    PERFORM 2165-DESC-BILL-CYCLE-MST        THRU 2165-EXIT.      04890000
REARCH*    PERFORM 2170-DESC-MST-OVRRD-BLL-IND     THRU 2170-EXIT.      04900000
REARCH*    PERFORM 2175-DESC-CODE-PRNT-BLL-MST     THRU 2175-EXIT.      04910000
REARCH*    PERFORM 2180-DESC-AMT-MO-PYMT           THRU 2180-EXIT.      04920000
REARCH*    PERFORM 2185-DESC-PAYMENT-TERMS         THRU 2185-EXIT.      04930000
REARCH*    PERFORM 2190-DESC-SUB-ACCT-STATUS       THRU 2190-EXIT.      04930000
REARCH*                                                                 04940000
REARCH*2100-EXIT.                                                       04950000
REARCH*    EXIT.                                                        04960000
043900                                                                  
044000******************************************************************04980000
044100* 2110-DESC-RET-CODE                                             *04990000
044200*     CALLS       9100-CHECK-ERROR                               *05000000
044300*                                                                *05010000
044400*     CALLED FROM 2100-DESCRIBE-RESULT                           *05020000
044500*                                                                *05030000
044600*     DESCRIBE EACH RESULT FIELD TO THE CLIENT                   *05040000
044700******************************************************************05050000
REARCH*                                                                 05060000
REARCH*2110-DESC-RET-CODE.                                              05070000
REARCH*                                                                 05080000
REARCH*    MOVE '2110'                       TO ACTIVE-PARAGRAPH.       05090000
REARCH*    MOVE 1                            TO CTR-COLUMN.             05100000
REARCH*    MOVE TDSINT4                      TO DB-HOST-TYPE.           05110000
REARCH*    MOVE TDSINT4                      TO DB-CLIENT-TYPE.         05120000
REARCH*    MOVE LENGTH OF RS-RETURN-CODE     TO WRKLEN1.                05130000
REARCH*    MOVE LENGTH OF CNS-RETURN-CODE    TO WRKLEN2.                05140000
REARCH*                                                                 05150000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05160000
REARCH*                          GWL-RC,                                05170000
REARCH*                          CTR-COLUMN,                            05180000
REARCH*                          DB-HOST-TYPE,                          05190000
REARCH*                          WRKLEN1,                               05200000
REARCH*                          RS-RETURN-CODE,                        05210000
REARCH*                          DB-NULL-INDICATOR,                     05220000
REARCH*                          TDS-FALSE,                             05230000
REARCH*                          DB-CLIENT-TYPE,                        05240000
REARCH*                          WRKLEN1,                               05250000
REARCH*                          CNS-RETURN-CODE,                       05260000
REARCH*                          WRKLEN2.                               05270000
REARCH*                                                                 05280000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     05290000
REARCH*                                                                 05300000
REARCH*2110-EXIT.                                                       05310000
REARCH*    EXIT.                                                        05320000
REARCH*                                                                 05330000
REARCH******************************************************************05340000
REARCH* 2120-DESC-SUB-ACCT-NO                                          *05350000
REARCH*     CALLS       TDESCRIB                                       *05360000
REARCH*                 9100-CHECK-ERROR                               *05370000
REARCH*                                                                *05380000
REARCH*     CALLED FROM 2100-DESCRIBE-RESULT                           *05390000
REARCH*                                                                *05400000
REARCH*     DESCRIBE SUB-ACCT-NO    RESULT FIELD TO THE CLIENT         *05410000
REARCH******************************************************************05420000
REARCH*                                                                 05430000
REARCH*2120-DESC-SUB-ACCT-NO.                                           05440000
REARCH*                                                                 05450000
REARCH*    MOVE '2120'                           TO ACTIVE-PARAGRAPH.   05460000
REARCH*    ADD  1                                TO CTR-COLUMN.         05470000
REARCH*    MOVE TDSCHAR                          TO DB-HOST-TYPE.       05480000
REARCH*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.     05490000
REARCH*    MOVE LENGTH OF RS-SUB-ACCT-NO         TO WRKLEN1.            05500000
REARCH*    MOVE LENGTH OF CNS-SUB-ACCT-NO        TO WRKLEN2.            05510000
REARCH*                                                                 05520000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05530000
REARCH*                          GWL-RC,                                05540000
REARCH*                          CTR-COLUMN,                            05550000
REARCH*                          DB-HOST-TYPE,                          05560000
REARCH*                          WRKLEN1,                               05570000
REARCH*                          RS-SUB-ACCT-NO,                        05580000
REARCH*                          DB-NULL-INDICATOR,                     05590000
REARCH*                          TDS-FALSE,                             05600000
REARCH*                          DB-CLIENT-TYPE,                        05610000
REARCH*                          WRKLEN1,                               05620000
REARCH*                          CNS-SUB-ACCT-NO,                       05630000
REARCH*                          WRKLEN2.                               05640000
REARCH*                                                                 05650000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     05660000
REARCH*                                                                 05670000
REARCH*2120-EXIT.                                                       05680000
REARCH*    EXIT.                                                        05690000
REARCH*                                                                 05700000
REARCH******************************************************************05710000
REARCH* 2130-DESC-ACCOUNT-NAME                                         *05720000
REARCH*     CALLS       TDESCRIB                                       *05730000
REARCH*                 9100-CHECK-ERROR                               *05740000
REARCH*                                                                *05750000
REARCH*     CALLED FROM 2100-DESCRIBE-RESULT                           *05760000
REARCH*                                                                *05770000
REARCH*     DESCRIBE ACCOUNT-NAME      RESULT FIELD TO THE CLIENT      *05780000
REARCH******************************************************************05790000
REARCH*                                                                 05800000
REARCH*2130-DESC-ACCOUNT-NAME.                                          05810000
REARCH*                                                                 05820000
REARCH*    MOVE '2130'                          TO ACTIVE-PARAGRAPH.    05830000
REARCH*    ADD 1                                TO CTR-COLUMN.          05840000
REARCH*    MOVE TDSCHAR                         TO DB-HOST-TYPE.        05850000
REARCH*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.      05860000
REARCH*    MOVE LENGTH OF RS-ACCOUNT-NAME            TO WRKLEN1.        05870000
REARCH*    MOVE LENGTH OF CNS-ACCOUNT-NAME           TO WRKLEN2.        05880000
REARCH*                                                                 05890000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05900000
REARCH*                          GWL-RC,                                05910000
REARCH*                          CTR-COLUMN,                            05920000
REARCH*                          DB-HOST-TYPE,                          05930000
REARCH*                          WRKLEN1,                               05940000
REARCH*                          RS-ACCOUNT-NAME,                       05950000
REARCH*                          DB-NULL-INDICATOR,                     05960000
REARCH*                          TDS-FALSE,                             05970000
REARCH*                          DB-CLIENT-TYPE,                        05980000
REARCH*                          WRKLEN1,                               05990000
REARCH*                          CNS-ACCOUNT-NAME,                      06000000
REARCH*                          WRKLEN2.                               06010000
REARCH*                                                                 06020000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     06030000
REARCH*                                                                 06040000
REARCH*2130-EXIT.                                                       06050000
REARCH*    EXIT.                                                        06060000
REARCH*                                                                 06070000
REARCH******************************************************************06080000
REARCH* 2135-DESC-BILL-TYPE                                            *06090000
REARCH*     CALLS       TDESCRIB                                       *06100000
REARCH*                 9100-CHECK-ERROR                               *06110000
REARCH*                                                                *06120000
REARCH*     CALLED FROM 2100-DESCRIBE-RESULT                           *06130000
REARCH*                                                                *06140000
REARCH*     DESCRIBE BILL-TYPE         RESULT FIELD TO THE CLIENT      *06150000
REARCH******************************************************************06160000
REARCH*                                                                 06170000
REARCH*2135-DESC-BILL-TYPE.                                             06180000
REARCH*                                                                 06190000
REARCH*    MOVE '2135'                          TO ACTIVE-PARAGRAPH.    06200000
REARCH*    ADD 1                                TO CTR-COLUMN.          06210000
REARCH*    MOVE TDSCHAR                         TO DB-HOST-TYPE.        06220000
REARCH*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.      06230000
REARCH*    MOVE LENGTH OF RS-BILL-TYPE          TO WRKLEN1.             06240000
REARCH*    MOVE LENGTH OF CNS-BILL-TYPE         TO WRKLEN2.             06250000
REARCH*                                                                 06260000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              06270000
REARCH*                          GWL-RC,                                06280000
REARCH*                          CTR-COLUMN,                            06290000
REARCH*                          DB-HOST-TYPE,                          06300000
REARCH*                          WRKLEN1,                               06310000
REARCH*                          RS-BILL-TYPE,                          06320000
REARCH*                          DB-NULL-INDICATOR,                     06330000
REARCH*                          TDS-FALSE,                             06340000
REARCH*                          DB-CLIENT-TYPE,                        06350000
REARCH*                          WRKLEN1,                               06360000
REARCH*                          CNS-BILL-TYPE,                         06370000
REARCH*                          WRKLEN2.                               06380000
REARCH*                                                                 06390000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     06400000
REARCH*                                                                 06410000
REARCH*2135-EXIT.                                                       06420000
REARCH*    EXIT.                                                        06430000
REARCH*                                                                 06440000
REARCH******************************************************************06450000
REARCH* 2140-DESC-BILL-CYCLE                                           *06460000
REARCH*     CALLS       TDESCRIB                                       *06470000
REARCH*                 9100-CHECK-ERROR                               *06480000
REARCH*                                                                *06490000
REARCH*     CALLED FROM 2100-DESCRIBE-RESULT                           *06500000
REARCH*                                                                *06510000
REARCH*     DESCRIBE BILL-CYCLE         RESULT FIELD TO THE CLIENT     *06520000
REARCH******************************************************************06530000
REARCH*                                                                 06540000
REARCH*2140-DESC-BILL-CYCLE.                                            06550000
REARCH*                                                                 06560000
REARCH*    MOVE '2140'                           TO ACTIVE-PARAGRAPH.   06570000
REARCH*    ADD 1                                 TO CTR-COLUMN.         06580000
REARCH*    MOVE TDSCHAR                          TO DB-HOST-TYPE.       06590000
REARCH*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.     06600000
REARCH*    MOVE LENGTH OF RS-BILL-CYCLE          TO WRKLEN1.            06610000
REARCH*    MOVE LENGTH OF CNS-BILL-CYCLE         TO WRKLEN2.            06620000
REARCH*                                                                 06630000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              06640000
REARCH*                          GWL-RC,                                06650000
REARCH*                          CTR-COLUMN,                            06660000
REARCH*                          DB-HOST-TYPE,                          06670000
REARCH*                          WRKLEN1,                               06680000
REARCH*                          RS-BILL-CYCLE,                         06690000
REARCH*                          DB-NULL-INDICATOR,                     06700000
REARCH*                          TDS-FALSE,                             06710000
REARCH*                          DB-CLIENT-TYPE,                        06720000
REARCH*                          WRKLEN1,                               06730000
REARCH*                          CNS-BILL-CYCLE,                        06740000
REARCH*                          WRKLEN2.                               06750000
REARCH*                                                                 06760000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     06770000
REARCH*                                                                 06780000
REARCH*2140-EXIT.                                                       06790000
REARCH*    EXIT.                                                        06800000
REARCH*                                                                 06810000
REARCH******************************************************************06820000
REARCH* 2145-DESC-BILL-STATUS.                                         *06830000
REARCH*     CALLS       TDESCRIB                                       *06840000
REARCH*                 9100-CHECK-ERROR                               *06850000
REARCH*                                                                *06860000
REARCH*     CALLED FROM 2100-DESCRIBE-RESULT                           *06870000
REARCH*                                                                *06880000
REARCH*     DESCRIBE SUB-TOTAL-CODE     RESULT FIELD TO THE CLIENT     *06890000
REARCH******************************************************************06900000
REARCH*                                                                 06910000
REARCH*                                                                 06920000
REARCH*2145-DESC-BILL-STATUS.                                           06930000
REARCH*                                                                 06940000
REARCH*    MOVE '2145'                           TO ACTIVE-PARAGRAPH.   06950000
REARCH*    ADD 1                                 TO CTR-COLUMN.         06960000
REARCH*    MOVE TDSCHAR                          TO DB-HOST-TYPE.       06970000
REARCH*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.     06980000
REARCH*    MOVE LENGTH OF RS-BILL-STATUS         TO WRKLEN1.            06990000
REARCH*    MOVE LENGTH OF CNS-BILL-STATUS        TO WRKLEN2.            07000000
REARCH*                                                                 07010000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              07020000
REARCH*                          GWL-RC,                                07030000
REARCH*                          CTR-COLUMN,                            07040000
REARCH*                          DB-HOST-TYPE,                          07050000
REARCH*                          WRKLEN1,                               07060000
REARCH*                          RS-BILL-STATUS,                        07070000
REARCH*                          DB-NULL-INDICATOR,                     07080000
REARCH*                          TDS-FALSE,                             07090000
REARCH*                          DB-CLIENT-TYPE,                        07100000
REARCH*                          WRKLEN1,                               07110000
REARCH*                          CNS-BILL-STATUS,                       07120000
REARCH*                          WRKLEN2.                               07130000
REARCH*                                                                 07140000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     07150000
REARCH*                                                                 07160000
REARCH*2145-EXIT.                                                       07170000
REARCH*    EXIT.                                                        07180000
REARCH*                                                                 07190000
REARCH*                                                                 07200000
REARCH******************************************************************07210000
REARCH* 2150-DESC-SUB-TOTAL-CODE.                                      *07220000
REARCH*     CALLS       TDESCRIB                                       *07230000
REARCH*                 9100-CHECK-ERROR                               *07240000
REARCH*                                                                *07250000
REARCH*     CALLED FROM 2100-DESCRIBE-RESULT                           *07260000
REARCH*                                                                *07270000
REARCH*     DESCRIBE SUB-TOTAL-CODE     RESULT FIELD TO THE CLIENT     *07280000
REARCH******************************************************************07290000
REARCH*                                                                 07300000
REARCH*                                                                 07310000
REARCH*2150-DESC-SUB-TOTAL-CODE.                                        07320000
REARCH*                                                                 07330000
REARCH*    MOVE '2150'                           TO ACTIVE-PARAGRAPH.   07340000
REARCH*    ADD 1                                 TO CTR-COLUMN.         07350000
REARCH*    MOVE TDSCHAR                          TO DB-HOST-TYPE.       07360000
REARCH*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.     07370000
REARCH*    MOVE LENGTH OF RS-SUB-TOTAL-CODE      TO WRKLEN1.            07380000
REARCH*    MOVE LENGTH OF CNS-SUB-TOTAL-CODE     TO WRKLEN2.            07390000
REARCH*                                                                 07400000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              07410000
REARCH*                          GWL-RC,                                07420000
REARCH*                          CTR-COLUMN,                            07430000
REARCH*                          DB-HOST-TYPE,                          07440000
REARCH*                          WRKLEN1,                               07450000
REARCH*                          RS-SUB-TOTAL-CODE,                     07460000
REARCH*                          DB-NULL-INDICATOR,                     07470000
REARCH*                          TDS-FALSE,                             07480000
REARCH*                          DB-CLIENT-TYPE,                        07490000
REARCH*                          WRKLEN1,                               07500000
REARCH*                          CNS-SUB-TOTAL-CODE,                    07510000
REARCH*                          WRKLEN2.                               07520000
REARCH*                                                                 07530000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     07540000
REARCH*                                                                 07550000
REARCH*2150-EXIT.                                                       07560000
REARCH*    EXIT.                                                        07570000
REARCH*                                                                 07580000
REARCH*                                                                 07590000
REARCH******************************************************************07600000
REARCH* 2155-DESC-CODE-BILL-FREQ                                       *07610000
REARCH*     CALLS       TDESCRIB                                       *07620000
REARCH*                 9100-CHECK-ERROR                               *07630000
REARCH*                                                                *07640000
REARCH*     CALLED FROM 2100-DESCRIBE-RESULT                           *07650000
REARCH*                                                                *07660000
REARCH*     DESCRIBE CODE-BILL-FREQ     RESULT FIELD TO THE CLIENT     *07670000
REARCH******************************************************************07680000
REARCH*                                                                 07690000
REARCH*                                                                 07700000
REARCH*2155-DESC-CODE-BILL-FREQ.                                        07710000
REARCH*                                                                 07720000
REARCH*    MOVE '2155'                           TO ACTIVE-PARAGRAPH.   07730000
REARCH*    ADD 1                                 TO CTR-COLUMN.         07740000
REARCH*    MOVE TDSCHAR                          TO DB-HOST-TYPE.       07750000
REARCH*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.     07760000
REARCH*    MOVE LENGTH OF RS-CODE-BILL-FREQ      TO WRKLEN1.            07770000
REARCH*    MOVE LENGTH OF CNS-CODE-BILL-FREQ     TO WRKLEN2.            07780000
REARCH*                                                                 07790000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              07800000
REARCH*                          GWL-RC,                                07810000
REARCH*                          CTR-COLUMN,                            07820000
REARCH*                          DB-HOST-TYPE,                          07830000
REARCH*                          WRKLEN1,                               07840000
REARCH*                          RS-CODE-BILL-FREQ,                     07850000
REARCH*                          DB-NULL-INDICATOR,                     07860000
REARCH*                          TDS-FALSE,                             07870000
REARCH*                          DB-CLIENT-TYPE,                        07880000
REARCH*                          WRKLEN1,                               07890000
REARCH*                          CNS-CODE-BILL-FREQ,                    07900000
REARCH*                          WRKLEN2.                               07910000
REARCH*                                                                 07920000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     07930000
REARCH*                                                                 07940000
REARCH*2155-EXIT.                                                       07950000
REARCH*    EXIT.                                                        07960000
REARCH*                                                                 07970000
REARCH*                                                                 07980000
REARCH******************************************************************07990000
REARCH* 2160-DESC-NO-BILL-COPIES                                       *08000000
REARCH*     CALLS       TDESCRIB                                       *08010000
REARCH*                 9100-CHECK-ERROR                               *08020000
REARCH*                                                                *08030000
REARCH*     CALLED FROM 2100-DESCRIBE-RESULT                           *08040000
REARCH*                                                                *08050000
REARCH*     DESCRIBE NO-BILL-COPIES     RESULT FIELD TO THE CLIENT     *08060000
REARCH******************************************************************08070000
REARCH*                                                                 08080000
REARCH*                                                                 08090000
REARCH*2160-DESC-NO-BILL-COPIES.                                        08100000
REARCH*                                                                 08110000
REARCH*    MOVE '2160'                           TO ACTIVE-PARAGRAPH.   08120000
REARCH*    ADD 1                                 TO CTR-COLUMN.         08130000
REARCH*    MOVE TDSCHAR                          TO DB-HOST-TYPE.       08140000
REARCH*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.     08150000
REARCH*    MOVE LENGTH OF RS-NO-BILL-COPIES      TO WRKLEN1.            08160000
REARCH*    MOVE LENGTH OF CNS-NO-BILL-COPIES     TO WRKLEN2.            08170000
REARCH*                                                                 08180000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              08190000
REARCH*                          GWL-RC,                                08200000
REARCH*                          CTR-COLUMN,                            08210000
REARCH*                          DB-HOST-TYPE,                          08220000
REARCH*                          WRKLEN1,                               08230000
REARCH*                          RS-NO-BILL-COPIES,                     08240000
REARCH*                          DB-NULL-INDICATOR,                     08250000
REARCH*                          TDS-FALSE,                             08260000
REARCH*                          DB-CLIENT-TYPE,                        08270000
REARCH*                          WRKLEN1,                               08280000
REARCH*                          CNS-NO-BILL-COPIES,                    08290000
REARCH*                          WRKLEN2.                               08300000
REARCH*                                                                 08310000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     08320000
REARCH*                                                                 08330000
REARCH*2160-EXIT.                                                       08340000
REARCH*    EXIT.                                                        08350000
REARCH*                                                                 08360000
REARCH******************************************************************08370000
REARCH* 2165-DESC-BILL-CYCLE-MST                                       *08380000
REARCH*     CALLS       TDESCRIB                                       *08390000
REARCH*                 9100-CHECK-ERROR                               *08400000
REARCH*                                                                *08410000
REARCH*     CALLED FROM 2100-DESCRIBE-RESULT                           *08420000
REARCH*                                                                *08430000
REARCH*     DESCRIBE BILL-CYCLE(MASTER) RESULT FIELD TO THE CLIENT     *08440000
REARCH******************************************************************08450000
REARCH*                                                                 08460000
REARCH*                                                                 08470000
REARCH*2165-DESC-BILL-CYCLE-MST.                                        08480000
REARCH*                                                                 08490000
REARCH*    MOVE '2165'                           TO ACTIVE-PARAGRAPH.   08500000
REARCH*    ADD 1                                 TO CTR-COLUMN.         08510000
REARCH*    MOVE TDSCHAR                          TO DB-HOST-TYPE.       08520000
REARCH*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.     08530000
REARCH*    MOVE LENGTH OF RS-BILL-CYCLE-MST      TO WRKLEN1.            08540000
REARCH*    MOVE LENGTH OF CNS-BILL-CYCLE-MST     TO WRKLEN2.            08550000
REARCH*                                                                 08560000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              08570000
REARCH*                          GWL-RC,                                08580000
REARCH*                          CTR-COLUMN,                            08590000
REARCH*                          DB-HOST-TYPE,                          08600000
REARCH*                          WRKLEN1,                               08610000
REARCH*                          RS-BILL-CYCLE-MST,                     08620000
REARCH*                          DB-NULL-INDICATOR,                     08630000
REARCH*                          TDS-FALSE,                             08640000
REARCH*                          DB-CLIENT-TYPE,                        08650000
REARCH*                          WRKLEN1,                               08660000
REARCH*                          CNS-BILL-CYCLE-MST,                    08670000
REARCH*                          WRKLEN2.                               08680000
REARCH*                                                                 08690000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     08700000
REARCH*                                                                 08710000
REARCH*2165-EXIT.                                                       08720000
REARCH*    EXIT.                                                        08730000
REARCH*                                                                 08740000
REARCH******************************************************************08750000
REARCH* 2170-DESC-OVRRD-BLL-MST                                        *08760000
REARCH*     CALLS       TDESCRIB                                       *08770000
REARCH*                 9100-CHECK-ERROR                               *08780000
REARCH*                                                                *08790000
REARCH*     CALLED FROM 2100-DESCRIBE-RESULT                           *08800000
REARCH*                                                                *08810000
REARCH*     DESCRIBE MST-OVRRD-BLL-IND  RESULT FIELD TO THE CLIENT     *08820000
REARCH******************************************************************08830000
REARCH*                                                                 08840000
REARCH*                                                                 08850000
REARCH*2170-DESC-MST-OVRRD-BLL-IND.                                     08860000
REARCH*                                                                 08870000
REARCH*    MOVE '2170'                           TO ACTIVE-PARAGRAPH.   08880000
REARCH*    ADD 1                                 TO CTR-COLUMN.         08890000
REARCH*    MOVE TDSCHAR                          TO DB-HOST-TYPE.       08900000
REARCH*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.     08910000
REARCH*    MOVE LENGTH OF RS-MST-OVRRD-BLL-IND   TO WRKLEN1.            08920000
REARCH*    MOVE LENGTH OF CNS-MST-OVRRD-BLL-IND  TO WRKLEN2.            08930000
REARCH*                                                                 08940000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              08950000
REARCH*                          GWL-RC,                                08960000
REARCH*                          CTR-COLUMN,                            08970000
REARCH*                          DB-HOST-TYPE,                          08980000
REARCH*                          WRKLEN1,                               08990000
REARCH*                          RS-MST-OVRRD-BLL-IND,                  09000000
REARCH*                          DB-NULL-INDICATOR,                     09010000
REARCH*                          TDS-FALSE,                             09020000
REARCH*                          DB-CLIENT-TYPE,                        09030000
REARCH*                          WRKLEN1,                               09040000
REARCH*                          CNS-MST-OVRRD-BLL-IND,                 09050000
REARCH*                          WRKLEN2.                               09060000
REARCH*                                                                 09070000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     09080000
REARCH*                                                                 09090000
REARCH*2170-EXIT.                                                       09100000
REARCH*    EXIT.                                                        09110000
REARCH*                                                                 09120000
REARCH******************************************************************09130000
REARCH* 2175-DESC-CODE-PRNT-BLL-MST                                    *09140000
REARCH*     CALLS       TDESCRIB                                       *09150000
REARCH*                 9100-CHECK-ERROR                               *09160000
REARCH*                                                                *09170000
REARCH*     CALLED FROM 2100-DESCRIBE-RESULT                           *09180000
REARCH*                                                                *09190000
REARCH*     DESCRIBE CODE-PRNT-BLL-MST  RESULT FIELD TO THE CLIENT     *09200000
REARCH******************************************************************09210000
REARCH*                                                                 09220000
REARCH*                                                                 09230000
REARCH*2175-DESC-CODE-PRNT-BLL-MST.                                     09240000
REARCH*                                                                 09250000
REARCH*    MOVE '2175'                           TO ACTIVE-PARAGRAPH.   09260000
REARCH*    ADD 1                                 TO CTR-COLUMN.         09270000
REARCH*    MOVE TDSCHAR                          TO DB-HOST-TYPE.       09280000
REARCH*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.     09290000
REARCH*    MOVE LENGTH OF RS-CODE-PRNT-BLL-MST   TO WRKLEN1.            09300000
REARCH*    MOVE LENGTH OF CNS-CODE-PRNT-BLL-MST  TO WRKLEN2.            09310000
REARCH*                                                                 09320000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              09330000
REARCH*                          GWL-RC,                                09340000
REARCH*                          CTR-COLUMN,                            09350000
REARCH*                          DB-HOST-TYPE,                          09360000
REARCH*                          WRKLEN1,                               09370000
REARCH*                          RS-CODE-PRNT-BLL-MST,                  09380000
REARCH*                          DB-NULL-INDICATOR,                     09390000
REARCH*                          TDS-FALSE,                             09400000
REARCH*                          DB-CLIENT-TYPE,                        09410000
REARCH*                          WRKLEN1,                               09420000
REARCH*                          CNS-CODE-PRNT-BLL-MST,                 09430000
REARCH*                          WRKLEN2.                               09440000
REARCH*                                                                 09450000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     09460000
REARCH*                                                                 09470000
REARCH*2175-EXIT.                                                       09480000
REARCH*    EXIT.                                                        09490000
REARCH*                                                                 09500000
REARCH******************************************************************09510000
REARCH* 2180-DESC-AMT-MO-PYMT                                          *09520000
REARCH*     CALLS       TDESCRIB                                       *09530000
REARCH*                 9100-CHECK-ERROR                               *09540000
REARCH*                                                                *09550000
REARCH*     CALLED FROM 2100-DESCRIBE-RESULT                           *09560000
REARCH*                                                                *09570000
REARCH*     DESCRIBE AMT-MO-PYMT        RESULT FIELD TO THE CLIENT     *09580000
REARCH******************************************************************09590000
REARCH*                                                                 09600000
REARCH*                                                                 09610000
REARCH*2180-DESC-AMT-MO-PYMT.                                           09620000
REARCH*                                                                 09630000
REARCH*    MOVE '2180'                           TO ACTIVE-PARAGRAPH.   09640000
REARCH*    ADD  1                                TO CTR-COLUMN.         09650000
REARCH*    MOVE TDSDECIMAL                       TO DB-HOST-TYPE.       09660000
REARCH*    MOVE TDSFLT8                          TO DB-CLIENT-TYPE.     09670000
REARCH*    MOVE LENGTH OF RS-AMT-MO-PYMT    TO WRKLEN1.                 09680000
REARCH*    MOVE LENGTH OF CNS-AMT-MO-PYMT   TO WRKLEN2.                 09690000
REARCH*                                                                 09700000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              09710000
REARCH*                          GWL-RC,                                09720000
REARCH*                          CTR-COLUMN,                            09730000
REARCH*                          DB-HOST-TYPE,                          09740000
REARCH*                          WRKLEN1,                               09750000
REARCH*                          RS-AMT-MO-PYMT,                        09760000
REARCH*                          DB-NULL-INDICATOR,                     09770000
REARCH*                          TDS-FALSE,                             09780000
REARCH*                          DB-CLIENT-TYPE,                        09790000
REARCH*                          WRKLEN1,                               09800000
REARCH*                          CNS-AMT-MO-PYMT,                       09810000
REARCH*                          WRKLEN2.                               09820000
REARCH*                                                                 09830000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     09840000
REARCH*                                                                 09850000
REARCH*    MOVE +2 TO WRKLEN2.                                          09860000
REARCH*    CALL 'TDSETBCD' USING GWL-PROC,                              09870000
REARCH*                          GWL-RC,                                09880000
REARCH*                          TDS-OBJECT-COL,                        09890000
REARCH*                          CTR-COLUMN,                            09900000
REARCH*                          WRKLEN1,                               09910000
REARCH*                          WRKLEN2.                               09920000
REARCH*                                                                 09930000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     09940000
REARCH*                                                                 09950000
REARCH*2180-EXIT.                                                       09960000
REARCH*    EXIT.                                                        09970000
REARCH*                                                                 09980000
REARCH******************************************************************09990000
REARCH* 2185-DESC-PAYMENT-TERMS                                        *10000000
REARCH*     CALLS       TDESCRIB                                       *10010000
REARCH*                 9100-CHECK-ERROR                               *10020000
REARCH*                                                                *10030000
REARCH*     CALLED FROM 2100-DESCRIBE-RESULT                           *10040000
REARCH*                                                                *10050000
REARCH*     DESCRIBE PAYMENT-TERMS      RESULT FIELD TO THE CLIENT     *10060000
REARCH******************************************************************10070000
REARCH*                                                                 10080000
REARCH*                                                                 10090000
REARCH*2185-DESC-PAYMENT-TERMS.                                         10100000
REARCH*                                                                 10110000
REARCH*    MOVE '2185'                           TO ACTIVE-PARAGRAPH.   10120000
REARCH*    ADD 1                                 TO CTR-COLUMN.         10130000
REARCH*    MOVE TDSCHAR                          TO DB-HOST-TYPE.       10140000
REARCH*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.     10150000
REARCH*    MOVE LENGTH OF RS-PAYMENT-TERMS       TO WRKLEN1.            10160000
REARCH*    MOVE LENGTH OF CNS-PAYMENT-TERMS      TO WRKLEN2.            10170000
REARCH*                                                                 10180000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              10190000
REARCH*                          GWL-RC,                                10200000
REARCH*                          CTR-COLUMN,                            10210000
REARCH*                          DB-HOST-TYPE,                          10220000
REARCH*                          WRKLEN1,                               10230000
REARCH*                          RS-PAYMENT-TERMS,                      10240000
REARCH*                          DB-NULL-INDICATOR,                     10250000
REARCH*                          TDS-FALSE,                             10260000
REARCH*                          DB-CLIENT-TYPE,                        10270000
REARCH*                          WRKLEN1,                               10280000
REARCH*                          CNS-PAYMENT-TERMS,                     10290000
REARCH*                          WRKLEN2.                               10300000
REARCH*                                                                 10310000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     10320000
REARCH*                                                                 10330000
REARCH*2185-EXIT.                                                       10340000
REARCH*    EXIT.                                                        10350000
REARCH*                                                                 10360000
REARCH******************************************************************09990000
REARCH* 2190-DESC-SUB-ACCT-STATUS                                      *10000000
REARCH*     CALLS       TDESCRIB                                       *10010000
REARCH*                 9100-CHECK-ERROR                               *10020000
REARCH*                                                                *10030000
REARCH*     CALLED FROM 2100-DESCRIBE-RESULT                           *10040000
REARCH*                                                                *10050000
REARCH*     DESCRIBE SUB-ACCT-STATUS    RESULT FIELD TO THE CLIENT     *10060000
REARCH******************************************************************10070000
REARCH*                                                                 10080000
REARCH*                                                                 10090000
REARCH*2190-DESC-SUB-ACCT-STATUS.                                       10100000
REARCH*                                                                 10110000
REARCH*    MOVE '2190'                           TO ACTIVE-PARAGRAPH.   10120000
REARCH*    ADD 1                                 TO CTR-COLUMN.         10130000
REARCH*    MOVE TDSCHAR                          TO DB-HOST-TYPE.       10140000
REARCH*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.     10150000
REARCH*    MOVE LENGTH OF RS-SUB-ACCT-STATUS     TO WRKLEN1.            10160000
REARCH*    MOVE LENGTH OF CNS-SUB-ACCT-STATUS    TO WRKLEN2.            10170000
REARCH*                                                                 10180000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              10190000
REARCH*                          GWL-RC,                                10200000
REARCH*                          CTR-COLUMN,                            10210000
REARCH*                          DB-HOST-TYPE,                          10220000
REARCH*                          WRKLEN1,                               10230000
REARCH*                          RS-SUB-ACCT-STATUS,                    10240000
REARCH*                          DB-NULL-INDICATOR,                     10250000
REARCH*                          TDS-FALSE,                             10260000
REARCH*                          DB-CLIENT-TYPE,                        10270000
REARCH*                          WRKLEN1,                               10280000
REARCH*                          CNS-SUB-ACCT-STATUS,                   10290000
REARCH*                          WRKLEN2.                               10300000
REARCH*                                                                 10310000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     10320000
REARCH*                                                                 10330000
REARCH*2190-EXIT.                                                       10340000
REARCH*    EXIT.                                                        10350000
097100                                                                  
097200******************************************************************10380000
097300* 2200-BUILD-RESULT                                              *10390000
097400*     CALLS       2210-PROCESS-FETCH                             *10400000
097500*                 7100-OPEN-CUST-ALERT-CURSOR                    *10410000
097600*                 7200-CLOSE-CUST-ALERT-CURSOR                   *10420000
097700*                                                                *10430000
097800*     CALLED FROM 2000-PROCESS-OUTPUT                            *10440000
097900*                                                                *10450000
098000*     BUILD THE RESULT SET DESCRIBED ABOVE. OPENS THE CURSOR     *10460000
098100*     THEN FETCHES IT AND SENDS THEM TO CLIENT. AT THE END CLOSES*10470000
098200*     THE CURSOR.                                                *10480000
098300******************************************************************10490000
098400                                                                  
098500 2200-BUILD-RESULT.                                               
098600                                                                  
098610     PERFORM 2240-FIND-MASTER-INFO          THRU 2240-EXIT.       
098700     PERFORM 7100-OPEN-SUB-ACCT-CURSOR      THRU 7100-EXIT.       
098800                                                                  
098900     PERFORM 2210-PROCESS-FETCH             THRU 2210-EXIT        
099000             UNTIL WS-FETCH-RETURN-CODE = NOT-FOUND.              
099100                                                                  
099200     PERFORM 7200-CLOSE-SUB-ACCT-CURSOR     THRU 7200-EXIT.       
099300                                                                  
099400 2200-EXIT.                                                       
099500     EXIT.                                                        
099600                                                                  
099700******************************************************************10640000
099800* 2210-PROCESS-FETCH                                             *10650000
099900*     CALLS       7000-FETCH-RATE-COMP-DEF                       *10660000
100000*                 8100-SEND-RESULT                               *10670000
100100*                                                                *10680000
100200*     CALLED FROM 2200-BUILD-RESULT                              *10690000
100300*                                                                *10700000
100400*     READ EACH RETURNED ROW OF   CSS-CUST-ALERT,    FORMAT IT   *10710000
100500*     AND SEND IT BACK                                           *10720000
100600******************************************************************10730000
100700                                                                  
100800 2210-PROCESS-FETCH.                                              
100900                                                                  
101000     PERFORM 7000-FETCH-SUB-ACCT-CURSOR     THRU 7000-EXIT.       
101100     MOVE WS-ACTIVE-RETURN-CODE TO WS-FETCH-RETURN-CODE.          
101200                                                                  
101300     IF WS-FETCH-RETURN-CODE = SUCCESSFUL-CALL                    
101400        PERFORM 2220-PROCESS-FORMAT         THRU 2220-EXIT        
101500     END-IF.                                                      
101600                                                                  
101700 2210-EXIT.                                                       
101800     EXIT.                                                        
101900                                                                  
102000******************************************************************10870000
102100* 2220-PROCESS-FORMAT                                            *10880000
102200*     CALLS       8100-SEND-RESULT                               *10890000
102300*                 7400-SELECT-ACCOUNT-SUB                        *10900000
102400*                 7500-SELECT-NAME                               *10910000
102500*                                                                *10920000
102600*     CALLED FROM 2200-BUILD-RESULT                              *10930000
102700*                                                                *10940000
102800*     SENDS THE FIELDS TO THE CLIENT                             *10950000
102900******************************************************************10960000
103000                                                                  
103100 2220-PROCESS-FORMAT.                                             
103200                                                                  
103300*    MOVE MU-CODE-SUB-TOTAL     TO WS-SUB-TOTAL-CODE-DEC.         11000000
103400*    MOVE WS-SUB-TOTAL-CODE-DEC TO RS-SUB-TOTAL-CODE.             11010000
PCR638     MOVE MU-CODE-SUB-TOTAL     TO WS-SUB-TOTAL-CODE.             
PCR638     MOVE WS-SUB-TOTAL-CODE     TO RS-SUB-TOTAL-CODE.             
103500                                                                  
103600     MOVE MU-SUB-ACCT-NO        TO WS-SUB-ACCT-DEC.               
103700     MOVE WS-SUB-ACCT-DEC       TO RS-SUB-ACCT-NO.                
103800                                                                  
           MOVE SPACES                TO RS-ACCOUNT-NAME.               
103900     MOVE MU-SUB-ACCT-BLLD-OK   TO RS-BILL-STATUS.                
104000                                                                  
104100     PERFORM 7400-SELECT-ACCOUNT-SUB THRU 7400-EXIT.              
      *                                                                         
T17547     IF (WS-NULL-IND = -1)                                        
T17547        NEXT SENTENCE                                             
T17547     ELSE                                                         
T17547        MOVE WS-WORK-DATE26 (1:10) TO WS-WORK-DATE                
T17547        MOVE 'DAY-FINAL-BILLED-SUB' TO C8-DELINQ-CD               
T17547        PERFORM 2231-CSS-DELINQUENCY THRU 2231-EXIT               
T17547        MOVE C8-DELINQ-VALUE TO WS-DEL-DAYS                       
T17547        PERFORM 2235-FINAL-DATE-PLUS-DEL THRU 2235-EXIT           
T17547        PERFORM 2236-GET-CURRENT-DATE THRU 2236-EXIT              
T17547        IF WS-PLUS60-DATE < WS-CURRENT-DATE                       
T17547           GO TO 2220-EXIT                                        
T17547        END-IF                                                    
T17547     END-IF.                                                      
      *                                                                         
T18345     MOVE AT-CODE-ACCT-STAT     TO RS-SUB-ACCT-STATUS.            
109517     IF AT-AR-XFER-IND = 'Y' AND AT-BILL-HIST-XFER-IND = 'Y'      
109518        MOVE 'A'                TO RS-BILL-TYPE                   
109519     END-IF.                                                      
109520     IF AT-AR-XFER-IND = SPACE AND AT-BILL-HIST-XFER-IND = 'Y'    
109521        MOVE 'B'                TO RS-BILL-TYPE                   
109522     END-IF.                                                      
104200                                                                  
104300     MOVE AT-BILL-CYCLE         TO RS-BILL-CYCLE.                 
106900     PERFORM 7500-SELECT-NAME   THRU 7500-EXIT.                   
106910     IF WS-ACTIVE-RETURN-CODE = 0                                 
107000                                                                  
107010        IF DQ-NAME-FORMAT = 'I'                                   
107100           STRING DQ-TITLE-PREFIX   DELIMITED BY SPACES           
107200             ' '               DELIMITED BY SIZE                  
107300             DQ-FIRST-NAME     DELIMITED BY SPACES                
107400             ' '               DELIMITED BY SIZE                  
107500             DQ-MIDDLE-NAME    DELIMITED BY SPACES                
107600             ' '               DELIMITED BY SIZE                  
107700             DQ-LAST-NAME      DELIMITED BY SPACES                
107800             ' '               DELIMITED BY SIZE                  
107900             DQ-TITLE-SUFFIX-1 DELIMITED BY SPACES                
108000             ' '               DELIMITED BY SIZE                  
108100             DQ-TITLE-SUFFIX-2 DELIMITED BY SPACES                
108200             INTO                                                 
108300             RS-ACCOUNT-NAME                                      
108310        ELSE                                                      
108320             MOVE DQ-FULL-NAME  TO RS-ACCOUNT-NAME                
108330        END-IF                                                    
108340     ELSE                                                         
108350                                                                  
108351        PERFORM 7510-SELECT-CUST-NAME THRU 7510-EXIT              
108352        IF DQ-NAME-FORMAT = 'I'                                   
108353           STRING DQ-TITLE-PREFIX   DELIMITED BY SPACES           
108354             ' '               DELIMITED BY SIZE                  
108355             DQ-FIRST-NAME     DELIMITED BY SPACES                
108356             ' '               DELIMITED BY SIZE                  
108357             DQ-MIDDLE-NAME    DELIMITED BY SPACES                
108358             ' '               DELIMITED BY SIZE                  
108359             DQ-LAST-NAME      DELIMITED BY SPACES                
108360             ' '               DELIMITED BY SIZE                  
108361             DQ-TITLE-SUFFIX-1 DELIMITED BY SPACES                
108362             ' '               DELIMITED BY SIZE                  
108363             DQ-TITLE-SUFFIX-2 DELIMITED BY SPACES                
108364             INTO                                                 
108365             RS-ACCOUNT-NAME                                      
T11441        ELSE                                                      
T11441             MOVE DQ-FULL-NAME  TO RS-ACCOUNT-NAME                
108400        END-IF                                                    
108700     END-IF.                                                      
108710                                                                  
108800     MOVE WS-FETCH-RETURN-CODE TO RS-RETURN-CODE.                 
108900                                                                  
REARCH     PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT.               
109000     PERFORM 8100-SEND-RESULT      THRU 8100-EXIT.                
109100                                                                  
109200 2220-EXIT.                                                       
109300     EXIT.                                                        
109310******************************************************************11660000
109320* 2230-FIND-PAYMENT-TERMS                                        *11670000
109330*     CALLS       7550-SEL-DISTINCT-BILL-CYCLE                   *11680000
109350*                                                                *11690000
109360*     CALLED FROM 2200-BUILD-RESULT                              *11700000
109370*                                                                *11710000
109380*     CALCULATES THE PAYMENT TERMS                               *11720000
109391******************************************************************11730000
109392                                                                  
109393 2230-FIND-PAYMENT-TERMS.                                         
109394                                                                  
109420     PERFORM 7550-SEL-DISTINCT-BILL-CYCLE   THRU 7550-EXIT.       
109430     MOVE SPACES TO RS-PAYMENT-TERMS.                             
C37808     IF WS-DISTINCT-BILL-CYCLE > 0                                
C37808       EVALUATE TRUE                                              
C37808          WHEN (WS-DISTINCT-BILL-CYCLE >= 1 AND                   
C37808               WS-DISTINCT-BILL-CYCLE <= 5)                       
C37808              MOVE 'DAY-CB15CYCLES'   TO C8-DELINQ-CD             
C37808          WHEN (WS-DISTINCT-BILL-CYCLE >= 6 AND                   
C37808               WS-DISTINCT-BILL-CYCLE <= 10)                      
C37808              MOVE 'DAY-CB610CYCLES'  TO C8-DELINQ-CD             
C37808          WHEN (WS-DISTINCT-BILL-CYCLE >= 11 AND                  
C37808               WS-DISTINCT-BILL-CYCLE <= 15)                      
C37808              MOVE 'DAY-CB1115CYCLES' TO C8-DELINQ-CD             
C37808          WHEN (WS-DISTINCT-BILL-CYCLE >= 16 AND                  
C37808               WS-DISTINCT-BILL-CYCLE <= 23)                      
C37808              MOVE 'DAY-CB1620CYCLES' TO C8-DELINQ-CD             
C37808       END-EVALUATE                                               
T16714       PERFORM 2231-CSS-DELINQUENCY THRU 2231-EXIT                
T16714       MOVE C8-DELINQ-VALUE       TO WS-DELINQ-VALUE              
T16714       MOVE WS-DELINQ-VALUE       TO RS-PAYMENT-TERMS             
C37808     END-IF.                                                      
                                                                        
109501 2230-EXIT.                                                       
109502      EXIT.                                                       
      *                                                                         
T16714 2231-CSS-DELINQUENCY.                                            
                                                                        
            MOVE '2231'      TO ACTIVE-PARAGRAPH.                       
            EXEC SQL                                                    
                 SELECT DELINQ_VALUE                                    
                   INTO :C8-DELINQ-VALUE                                
                   FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                   
                  WHERE DELINQ_CD = :C8-DELINQ-CD                       
T23501              AND COMPANY_NO = :AT-COMPANY-NO                     
T35434                                                           
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                    11963100
MFA-TR*          SELECT DELINQ_VALUE                                    11963200
MFA-TR*            INTO :C8-DELINQ-VALUE                                11963300
MFA-TR*            FROM CSS_DELINQUENCY                                 11963400
MFA-TR*           WHERE DELINQ_CD = :C8-DELINQ-CD                       11964000
MFA-TR*             AND COMPANY_NO = :AT-COMPANY-NO                             
MFA-TR*            WITH UR                                                      
MFA-TR*     END-EXEC.                                                   11964100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE 'CSS_DELINQUENCY'          TO TABLE-1               
               MOVE 'DELINQ_CD'                TO TABLE-ELEMENT-1       
               MOVE C8-DELINQ-CD               TO HOSTVAR-ELEMENT-1     
CBSI           MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2       
CBSI           MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
T16714 2231-EXIT.                                                       
109502      EXIT.                                                       
      *                                                                         
T17547 2235-FINAL-DATE-PLUS-DEL.                                        
T17547     MOVE '2235' TO ACTIVE-PARAGRAPH.                             
T17547     EXEC SQL                                                     
T35434       SELECT
              DATEADD( DAY, :WS-DEL-DAYS, IIF(TRY_CONVERT(DATE, 
                                                          :WS-WORK-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-WORK-DATE
              ) <> 0) OR (LEN(:WS-WORK-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-WORK-DATE
              ), CONVERT(DATE, :WS-WORK-DATE) ) )
            INTO
              :WS-PLUS60-DATE   
T17547     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-PLUS60-DATE =                                              
MFA-TR*                       DATE(:WS-WORK-DATE) + :WS-DEL-DAYS DAYS           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
T17547     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
T17547     IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
T17547        CONTINUE                                                  
T17547     ELSE                                                         
T17547        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
T35434        MOVE 'SET'                      TO ABEND-FUNCTION         
T17547        MOVE 'WS-WORK-DATE'             TO TABLE-ELEMENT-1        
T17547        MOVE WS-WORK-DATE               TO HOSTVAR-ELEMENT-1      
T17547        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
T17547        MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
T17547        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T17547        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T17547     END-IF.                                                      
      *                                                                         
T17547 2235-EXIT.                                                       
T17547     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * GET THE CURRENT DATE                                           *        
      ******************************************************************        
      *                                                                         
T17547 2236-GET-CURRENT-DATE.                                           
T17547     EXEC SQL                                                     
T35434          SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
T17547     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T17547                                                                  
T17547     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
T17547     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T17547        NEXT SENTENCE                                             
T17547     ELSE                                                         
T17547        MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
T17547        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
T17547        MOVE '2236'                    TO ACTIVE-PARAGRAPH        
T35434        MOVE 'SET'                     TO ABEND-FUNCTION          
T17547        MOVE 'WS-WORK-DATE'            TO TABLE-ELEMENT-1         
T17547        MOVE WS-WORK-DATE              TO HOSTVAR-ELEMENT-1       
T17547        MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-2         
T17547        MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-2       
T17547        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T17547        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T17547     END-IF.                                                      
      *                                                                         
T17547 2236-EXIT.                                                       
T17547     EXIT.                                                        
      *                                                                         
109503******************************************************************11970000
109504* 2240-FIND-MASTER-INFO                                          *11980000
109505*     CALLS       7550-SEL-DISTINCT-BILL-CYCLE                   *11990000
109506*                                                                *12000000
109507*     CALLED FROM 2200-BUILD-RESULT                              *12010000
109508*                                                                *12020000
109509*     FIND ALL MATER ACCOUNT RELATED INFO                        *12030000
109510******************************************************************12040000
109511                                                                  
109512 2240-FIND-MASTER-INFO.                                           
109513                                                                  
109514     PERFORM 2230-FIND-PAYMENT-TERMS THRU 2230-EXIT.              
109515                                                                  
109516     PERFORM 7450-SELECT-ACCOUNT-MST THRU 7450-EXIT.              
                                                                        
109523     MOVE AT-CODE-BILL-FREQ          TO RS-CODE-BILL-FREQ.        
109524     MOVE AT-NO-BILL-COPIES          TO RS-NO-BILL-COPIES.        
109525     MOVE AT-BILL-CYCLE              TO RS-BILL-CYCLE-MST.        
109526     MOVE AT-MST-OVRRD-BLL-IND       TO RS-MST-OVRRD-BLL-IND.     
109527     MOVE AT-CODE-PRNT-BLL-MST       TO RS-CODE-PRNT-BLL-MST.     
109528                                                                  
109529     PERFORM 7460-SELECT-CONTRACT    THRU 7460-EXIT.              
109530     IF WS-AMT-MO-PYMT-NI < ZERO OR                               
109531        WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
109532        MOVE 0                          TO RS-AMT-MO-PYMT         
109533     ELSE                                                         
109534        MOVE CT-AMT-MO-PYMT             TO RS-AMT-MO-PYMT         
109535     END-IF.                                                      
109536                                                                  
109537 2240-EXIT.                                                       
109538     EXIT.                                                        
109540******************************************************************12280000
109600* 7000-FETCH-SUB-ACCT-CURSOR.                                    *12290000
109700*     CALLS       9000-SEND-ERROR-RESULT                         *12300000
109800*                 9900-SQL-ERROR-ROUTINE                         *12310000
109900*                                                                *12320000
110000*     CALLED FROM 2200-BUILD-RESULT                              *12330000
110100*                                                                *12340000
110200*     FETCHES A ROW FROM THE TABLE CSS_MSTSUB-ACCT   WHERE       *12350000
110300*     THE (FULL) KEY IS EQUAL TO THE PASSED PARAMETERS           *12360000
110400******************************************************************12370000
110500                                                                  
110600 7000-FETCH-SUB-ACCT-CURSOR.                                      
110700                                                                  
110800     MOVE '7000'               TO ACTIVE-PARAGRAPH.               
110900                                                                  
111000     EXEC SQL                                                     
111100        FETCH  SUB-ACCT-CURSOR                                    
111200        INTO  :MU-SUB-ACCT-NO,                                    
111300              :MU-CODE-SUB-TOTAL,                                 
111400              :MU-SUB-ACCT-BLLD-OK                                
111500     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

111600                                                                  
111700     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
111800                                                                  
111900     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
112000     OR                            NOT-FOUND                      
112100        NEXT SENTENCE                                             
112200     ELSE                                                         
112300        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'FETCH'                    TO ABEND-FUNCTION         
112500        MOVE 'CSS_MSTSUB_ACCT'          TO TABLE-1                
CBSI          MOVE 'MST_ACCT_NO'              TO TABLE-ELEMENT-1        
112700        MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
112800        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
112900        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
113000     END-IF.                                                      
113100                                                                  
113200 7000-EXIT.                                                       
113300     EXIT.                                                        
113400                                                                  
113500******************************************************************12680000
113600* 7100-OPEN-SUB-ACCT-CURSOR                                      *12690000
113700*     CALLS       9000-SEND-ERROR-RESULT                         *12700000
113800*                 9900-SQL-ERROR-ROUTINE                         *12710000
113900*                                                                *12720000
114000*     CALLED FROM 2200-BUILD-RESULT                              *12730000
114100*                                                                *12740000
114200*     OPENS THE CURSOR                                           *12750000
114300******************************************************************12760000
114400                                                                  
114500 7100-OPEN-SUB-ACCT-CURSOR.                                       
114600                                                                  
114700     MOVE '7100'                     TO ACTIVE-PARAGRAPH.         
114800                                                                  
114900     EXEC SQL                                                     
115000        OPEN SUB-ACCT-CURSOR                                      
115100     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

115200                                                                  
115300     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
115400                                                                  
115500     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
115600        NEXT SENTENCE                                             
115700     ELSE                                                         
115800        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'OPEN'                     TO ABEND-FUNCTION         
CBSI          MOVE 'CSS_MSTSUB_ACCT'          TO TABLE-1                
CBSI          MOVE 'MST_ACCT_NO'              TO TABLE-ELEMENT-1        
116200        MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
116300        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
116400        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
116500     END-IF.                                                      
116600                                                                  
116700 7100-EXIT.                                                       
116800     EXIT.                                                        
116900                                                                  
117000******************************************************************13030000
117100* 7200-CLOSE-SUB-ACCT-CURSOR                                     *13040000
117200*     CALLS       9000-SEND-ERROR-RESULT                         *13050000
117300*                 9900-SQL-ERROR-ROUTINE                         *13060000
117400*                                                                *13070000
117500*     CALLED FROM 2200-BUILD-RESULT                              *13080000
117600*                                                                *13090000
117700*     CLOSES THE CURSOR                                          *13100000
117800******************************************************************13110000
117900                                                                  
118000 7200-CLOSE-SUB-ACCT-CURSOR.                                      
118100                                                                  
118200     MOVE '7200'                     TO ACTIVE-PARAGRAPH.         
118300                                                                  
118400     EXEC SQL                                                     
118500        CLOSE SUB-ACCT-CURSOR                                     
118600     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

118700                                                                  
118800     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
118900                                                                  
119000     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
119100        NEXT SENTENCE                                             
119200     ELSE                                                         
119300        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'CLOSE'                    TO ABEND-FUNCTION         
119500        MOVE 'CSS_MSTSUB_ACCT'          TO TABLE-1                
119600        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
119700        MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
119800        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
119900        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
120000     END-IF.                                                      
120100                                                                  
120200                                                                  
120300 7200-EXIT.                                                       
120400     EXIT.                                                        
120500******************************************************************13380000
120600* 7300-SELECT-MSTSUB-ACCT                                        *13390000
120700*     CALLS       9000-SEND-ERROR-RESULT                         *13400000
120800*                 9900-SQL-ERROR-ROUTINE                         *13410000
120900*                                                                *13420000
121000*     CALLED FROM 2000-PROCESS-OUTPUT                            *13430000
121100*                                                                *13440000
121200*     SELECTS CSS_MSTSUB_ACCT TO CHECK WHETHER THE MASTER ACCOUNT*13450000
121300*     IS THERE OR NOT                                            *13460000
121400******************************************************************13470000
121500                                                                  
121600 7300-SELECT-MSTSUB-ACCT.                                         
121700                                                                  
121800     MOVE '7300'                     TO ACTIVE-PARAGRAPH.         
121900     MOVE WS-N                       TO WS-RECORD-FOUND.          
122000                                                                  
122100     EXEC SQL                                                     
122200        SELECT DISTINCT 'Y'                                       
122300        INTO  :WS-RECORD-FOUND                                    
122400        FROM CSS_MSTSUB_ACCT WITH(READUNCOMMITTED)                        
122500        WHERE MST_ACCT_NO = :WS-ACCOUNT-NO                        
T35434                                                           
122600     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     13540000
MFA-TR*       SELECT DISTINCT 'Y'                                       13550000
MFA-TR*       INTO  :WS-RECORD-FOUND                                    13560000
MFA-TR*       FROM CSS_MSTSUB_ACCT                                      13570000
MFA-TR*       WHERE MST_ACCT_NO = :WS-ACCOUNT-NO                        13580000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    13590000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

122700                                                                  
122800     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
122900                                                                  
123000     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
123100        NOT-FOUND                                                 
123200        NEXT SENTENCE                                             
123300     ELSE                                                         
123400        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'SELECT'                   TO ABEND-FUNCTION         
123600        MOVE 'CSS_MSTSUB_ACCT'          TO TABLE-1                
CBSI          MOVE 'MST_ACCT_NO'              TO TABLE-ELEMENT-1        
123800        MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
123900        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
124000        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
124100     END-IF.                                                      
124200                                                                  
124300                                                                  
124400 7300-EXIT.                                                       
124500     EXIT.                                                        
124600******************************************************************13790000
124700* 7400-SELECT-ACCOUNT-SUB                                        *13800000
124800*     CALLS       9000-SEND-ERROR-RESULT                         *13810000
124900*                 9900-SQL-ERROR-ROUTINE                         *13820000
125000*                                                                *13830000
125100*     CALLED FROM 2000-PROCESS-OUTPUT                            *13840000
125200*                                                                *13850000
125300*     SELECTS CSS_ACCOUNT TO DETERMINE BILL_TYPE AND BILL_CYCLE  *13860000
125400******************************************************************13870000
125500                                                                  
125600 7400-SELECT-ACCOUNT-SUB.                                         
125700                                                                  
125800     MOVE '7400'                     TO ACTIVE-PARAGRAPH.         
125900                                                                  
126000     EXEC SQL                                                     
126100       SELECT BILL_CYCLE,                                         
126200              AR_XFER_IND,                                        
126300              BILL_HIST_XFER_IND,                                 
126310              CUSTOMER_NO,                                        
T18731              CODE_ACCT_STAT,                                     
T17547              REPLACE(REPLACE(CONVERT(CHAR(26), ACCT_FINALED_DT
           , 121), ' ', '-'), ':', '.') ACCT_FINALED_DT                        
126400       INTO  :AT-BILL-CYCLE :WS-AT-BILL-CYCLE-NI,                  
126500             :AT-AR-XFER-IND :WS-AT-XFER-IND-NI,                   
126600             :AT-BILL-HIST-XFER-IND :WS-AT-BILL-HIST-XFER-IND-NI,  
126610             :WS-CUSTOMER-NO,                                     
T18731             :AT-CODE-ACCT-STAT,                                  
T17547             :WS-WORK-DATE26 :WS-NULL-IND                          
126700       FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                             
126800       WHERE ACCOUNT_NO  = :MU-SUB-ACCT-NO                        
T35434                                                          
126900     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     13930000
MFA-TR*      SELECT BILL_CYCLE,                                         13940000
MFA-TR*             AR_XFER_IND,                                        13950000
MFA-TR*             BILL_HIST_XFER_IND,                                 13960000
MFA-TR*             CUSTOMER_NO,                                        13970000
MFA-TR*             CODE_ACCT_STAT,                                             
MFA-TR*             ACCT_FINALED_DT                                             
MFA-TR*      INTO  :AT-BILL-CYCLE:WS-AT-BILL-CYCLE-NI,                  13980000
MFA-TR*            :AT-AR-XFER-IND:WS-AT-XFER-IND-NI,                   13990000
MFA-TR*            :AT-BILL-HIST-XFER-IND:WS-AT-BILL-HIST-XFER-IND-NI,  14000000
MFA-TR*            :WS-CUSTOMER-NO,                                     14010000
MFA-TR*            :AT-CODE-ACCT-STAT,                                          
MFA-TR*            :WS-WORK-DATE26:WS-NULL-IND                                  
MFA-TR*      FROM CSS_ACCOUNT                                           14020000
MFA-TR*      WHERE ACCOUNT_NO  = :MU-SUB-ACCT-NO                        14030000
MFA-TR*      WITH  UR                                                           
MFA-TR*    END-EXEC.                                                    14040000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

127000                                                                  
127100     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
127200                                                                  
127300     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
127400        NOT-FOUND                                                 
127500        NEXT SENTENCE                                             
127600     ELSE                                                         
127700        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'SELECT'                   TO ABEND-FUNCTION         
127900        MOVE 'CSS_ACCOUNT    '          TO TABLE-1                
128000        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
128100        MOVE MU-SUB-ACCT-NO             TO HOSTVAR-ELEMENT-1      
128200        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
128300        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
128400     END-IF.                                                      
      *                                                                         
128700 7400-EXIT.                                                       
128800     EXIT.                                                        
128900                                                                  
128910******************************************************************14250000
128920* 7410-SELECT-ACCOUNT-ELIGIBLE                                   *14260000
128930*     CALLS       9000-SEND-ERROR-RESULT                         *14270000
128940*                 9900-SQL-ERROR-ROUTINE                         *14280000
128950*                                                                *14290000
128960*     CALLED FROM 2000-PROCESS-OUTPUT                            *14300000
128970*                                                                *14310000
128980*     SELECTS CSS_ACCOUNT TO DETERMINE MASTER ACCOUNT IND  AND   *14320000
128981*     WHETHER IT IS ACTIVE OR NOT.                               *14330000
128990******************************************************************14340000
128991                                                                  
128992 7410-SELECT-ACCOUNT-ELIGIBLE.                                    
128993                                                                  
128994     MOVE '7410'                     TO ACTIVE-PARAGRAPH.         
128995                                                                  
128996     EXEC SQL                                                     
128997       SELECT BANKRUPTCY_IND,                                     
128998              CODE_ACCT_STAT,                                     
                    CODE_PRNT_BLL_MST,                                  
128999              MST_SUB_ACCT_IND,                                   
T23501              COMPANY_NO                                          
129000       INTO  :AT-BANKRUPTCY-IND,                                  
129001             :AT-CODE-ACCT-STAT,                                  
129001             :AT-CODE-PRNT-BLL-MST,                               
129002             :AT-MST-SUB-ACCT-IND,                                
T23501             :AT-COMPANY-NO                                       
129003       FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                             
129004       WHERE ACCOUNT_NO  = :WS-ACCOUNT-NO                         
T35434                                                          
129005     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14400000
MFA-TR*      SELECT BANKRUPTCY_IND,                                     14410000
MFA-TR*             CODE_ACCT_STAT,                                     14420000
MFA-TR*             CODE_PRNT_BLL_MST,                                          
MFA-TR*             MST_SUB_ACCT_IND,                                   14430000
MFA-TR*             COMPANY_NO                                                  
MFA-TR*      INTO  :AT-BANKRUPTCY-IND,                                  14440000
MFA-TR*            :AT-CODE-ACCT-STAT,                                  14450000
MFA-TR*            :AT-CODE-PRNT-BLL-MST,                               14450000
MFA-TR*            :AT-MST-SUB-ACCT-IND,                                14460000
MFA-TR*            :AT-COMPANY-NO                                               
MFA-TR*      FROM CSS_ACCOUNT                                           14470000
MFA-TR*      WHERE ACCOUNT_NO  = :WS-ACCOUNT-NO                         14480000
MFA-TR*      WITH  UR                                                           
MFA-TR*    END-EXEC.                                                    14490000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

129006                                                                  
129007     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
129008                                                                  
129009     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
129010        NOT-FOUND                                                 
129011        NEXT SENTENCE                                             
129012     ELSE                                                         
129013        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'SELECT'                   TO ABEND-FUNCTION         
129015        MOVE 'CSS_ACCOUNT    '          TO TABLE-1                
129016        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
129017        MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
129018        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
129019        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
129020     END-IF.                                                      
129021                                                                  
129022                                                                  
129023 7410-EXIT.                                                       
129024     EXIT.                                                        
129025                                                                  
129026******************************************************************14700000
129027* 7420-SELECT-UTILITY-TABLE                                      *14710000
129028*     CALLS       9000-SEND-ERROR-RESULT                         *14720000
129029*                 9900-SQL-ERROR-ROUTINE                         *14730000
129030*                                                                *14740000
129031*     CALLED FROM 2000-PROCESS-OUTPUT                            *14750000
129032*                                                                *14760000
129033*     SELECTS CSS_UTIL_ENVRNMT TO DETERMINE WHETHER THE SELECTED *14770000
129034*     ACCOUNT IS A NON UTILITY ACCOUNT OR NOT                    *14780000
129035******************************************************************14790000
129036                                                                  
129037 7420-SELECT-UTILITY-TABLE.                                       
129038                                                                  
129039     MOVE '7420'                     TO ACTIVE-PARAGRAPH.         
129040                                                                  
129041     EXEC SQL                                                     
129042       SELECT DISTINCT 'Y'                                        
129045       INTO  :WS-UTILITY-ACCT                                     
129048       FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                        
129049       WHERE ACCOUNT_NO  = :WS-ACCOUNT-NO                         
T35434                                                          
129050     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14850000
MFA-TR*      SELECT DISTINCT 'Y'                                        14860000
MFA-TR*      INTO  :WS-UTILITY-ACCT                                     14870000
MFA-TR*      FROM CSS_UTIL_ENVRNMT                                      14880000
MFA-TR*      WHERE ACCOUNT_NO  = :WS-ACCOUNT-NO                         14890000
MFA-TR*      WITH  UR                                                           
MFA-TR*    END-EXEC.                                                    14900000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

129051                                                                  
129052     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
129053                                                                  
129054     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
129055        NOT-FOUND                                                 
129056        NEXT SENTENCE                                             
129057     ELSE                                                         
129058        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE 'CSS_UTIL_ENVRNMT'         TO TABLE-1                
129061        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
129062        MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
129063        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
129064        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
129065     END-IF.                                                      
129066                                                                  
129067                                                                  
129068 7420-EXIT.                                                       
129069     EXIT.                                                        
129070                                                                  
129080******************************************************************15110000
129100* 7450-SELECT-ACCOUNT-MST                                        *15120000
129200*     CALLS       9000-SEND-ERROR-RESULT                         *15130000
129300*                 9900-SQL-ERROR-ROUTINE                         *15140000
129400*                                                                *15150000
129500*     CALLED FROM 2000-PROCESS-OUTPUT                            *15160000
129600*                                                                *15170000
129700*     SELECTS CSS_ACCOUNT TO DETERMINE BILLING FREQUENCY,        *15180000
129800*     BILL COPIES,BILLING CYCLE,MST ACCT OVERRIDE PARAMETER,     *15190000
129900*     BILL PRINT OPTION                                          *15200000
130000*                                                                *15210000
130100******************************************************************15220000
130200                                                                  
130300 7450-SELECT-ACCOUNT-MST.                                         
130400                                                                  
130500     MOVE '7450'                     TO ACTIVE-PARAGRAPH.         
130600                                                                  
130700     EXEC SQL                                                     
130800       SELECT CODE_BILL_FREQ,                                     
130900              NO_BILL_COPIES,                                     
131000              BILL_CYCLE,                                         
131100              MST_OVRRD_BLL_IND,                                  
131200              CODE_PRNT_BLL_MST                                   
131500       INTO  :AT-CODE-BILL-FREQ,                                  
131600             :AT-NO-BILL-COPIES,                                  
131700             :AT-BILL-CYCLE,                                      
131800             :AT-MST-OVRRD-BLL-IND,                               
131900             :AT-CODE-PRNT-BLL-MST                                
132200       FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                             
132300       WHERE ACCOUNT_NO  = :WS-ACCOUNT-NO                         
T35434                                                           
132400     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15280000
MFA-TR*      SELECT CODE_BILL_FREQ,                                     15290000
MFA-TR*             NO_BILL_COPIES,                                     15300000
MFA-TR*             BILL_CYCLE,                                         15310000
MFA-TR*             MST_OVRRD_BLL_IND,                                  15320000
MFA-TR*             CODE_PRNT_BLL_MST                                   15330000
MFA-TR*      INTO  :AT-CODE-BILL-FREQ,                                  15340000
MFA-TR*            :AT-NO-BILL-COPIES,                                  15350000
MFA-TR*            :AT-BILL-CYCLE,                                      15360000
MFA-TR*            :AT-MST-OVRRD-BLL-IND,                               15370000
MFA-TR*            :AT-CODE-PRNT-BLL-MST                                15380000
MFA-TR*      FROM CSS_ACCOUNT                                           15390000
MFA-TR*      WHERE ACCOUNT_NO  = :WS-ACCOUNT-NO                         15400000
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                    15410000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

132500                                                                  
132600     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
132700                                                                  
132800     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
132900        NOT-FOUND                                                 
133000        NEXT SENTENCE                                             
133100     ELSE                                                         
133200        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'SELECT'                   TO ABEND-FUNCTION         
133400        MOVE 'CSS_ACCOUNT    '          TO TABLE-1                
133500        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
133600        MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
133700        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
133800        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
133900     END-IF.                                                      
134000                                                                  
134100                                                                  
134200 7450-EXIT.                                                       
134300     EXIT.                                                        
134400                                                                  
134500******************************************************************15620000
134600* 7460-SELECT-CONTRACT                                           *15630000
134700*     CALLS       9000-SEND-ERROR-RESULT                         *15640000
134800*                 9900-SQL-ERROR-ROUTINE                         *15650000
134900*                                                                *15660000
135000*     CALLED FROM 2000-PROCESS-OUTPUT                            *15670000
135100*                                                                *15680000
135200*     SELECTS CSS_CONTRACT TO DETERMINE BILL OPTION CHARGE       *15690000
135300*                                                                *15700000
135400*                                                                *15710000
135500******************************************************************15720000
135600                                                                  
135700 7460-SELECT-CONTRACT.                                            
135800                                                                  
135900     MOVE '7460'                     TO ACTIVE-PARAGRAPH.         
136000                                                                  
136100     EXEC SQL                                                     
136200       SELECT SUM(AMT_MO_PYMT)                                    
136300       INTO  :CT-AMT-MO-PYMT :WS-AMT-MO-PYMT-NI                    
136400       FROM CSS_CONTRACT WITH(READUNCOMMITTED)                            
136500       WHERE ACCOUNT_NO         = :WS-ACCOUNT-NO                  
136510       AND   CNT_NAME_CD        = :WS-CNT-NAME-CD                 
T12273       AND   CNT_STATUS_CD IN ('A','B')                           
T35434                                                           
136600     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15780000
MFA-TR*      SELECT SUM(AMT_MO_PYMT)                                    15790000
MFA-TR*      INTO  :CT-AMT-MO-PYMT:WS-AMT-MO-PYMT-NI                    15800000
MFA-TR*      FROM CSS_CONTRACT                                          15810000
MFA-TR*      WHERE ACCOUNT_NO         = :WS-ACCOUNT-NO                  15820000
MFA-TR*      AND   CNT_NAME_CD        = :WS-CNT-NAME-CD                 15830000
MFA-TR*      AND   CNT_STATUS_CD IN ('A','B')                           15831000
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                    15840000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

136700                                                                  
136800     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
136900                                                                  
137000     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
137100        NOT-FOUND                                                 
137200        NEXT SENTENCE                                             
137300     ELSE                                                         
137400        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'SELECT'                   TO ABEND-FUNCTION         
CBSI          MOVE 'CSS_CONTRACT   '          TO TABLE-1                
137700        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
137800        MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE 'CNT_NAME_CD'              TO TABLE-ELEMENT-2        
CBSI          MOVE WS-CNT-NAME-CD             TO HOSTVAR-ELEMENT-2      
137900        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
138000        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
138100     END-IF.                                                      
138200                                                                  
138300                                                                  
138400 7460-EXIT.                                                       
138500     EXIT.                                                        
138600                                                                  
138700******************************************************************16050000
138800* 7500-SELECT-NAME                                               *16060000
138900*     CALLS       9000-SEND-ERROR-RESULT                         *16070000
139000*                 9900-SQL-ERROR-ROUTINE                         *16080000
139100*                                                                *16090000
139200*     CALLED FROM 2000-PROCESS-OUTPUT                            *16100000
139300*                                                                *16110000
139400*     SELECTS CSS_ACCT_BILL_NMES AND CSS_NAME TO FIND OUT NAME   *16120000
139500******************************************************************16130000
139600                                                                  
139700 7500-SELECT-NAME.                                                
139800                                                                  
139900     MOVE '7500'                     TO ACTIVE-PARAGRAPH.         
140000                                                                  
140100     EXEC SQL                                                     
140200       SELECT X.FIRST_NAME,X.LAST_NAME,X.MIDDLE_NAME,             
140300              X.TITLE_PREFIX,X.TITLE_SUFFIX_1,                    
140400              X.TITLE_SUFFIX_2,X.FULL_NAME,X.NAME_FORMAT          
140500       INTO                                                       
140600             :DQ-FIRST-NAME,                                      
140700             :DQ-LAST-NAME,                                       
140800             :DQ-MIDDLE-NAME,                                     
140900             :DQ-TITLE-PREFIX,                                    
141000             :DQ-TITLE-SUFFIX-1,                                  
141100             :DQ-TITLE-SUFFIX-2,                                  
141110             :DQ-FULL-NAME,                                       
141120             :DQ-NAME-FORMAT                                      
141200       FROM CSS_NAME X WITH(READUNCOMMITTED),CSS_ACCT_BILL_NMES Y
                           WITH(READUNCOMMITTED)                       
141300       WHERE                                                      
141400         Y.ACCOUNT_NO = :MU-SUB-ACCT-NO  AND                      
141500         X.NAME_ID    = Y.NAME_ID       AND                       
141600         Y.NAME_TYPE  = 'DB'                                      
T35434                                                           
141700     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     16190000
MFA-TR*      SELECT X.FIRST_NAME,X.LAST_NAME,X.MIDDLE_NAME,             16200000
MFA-TR*             X.TITLE_PREFIX,X.TITLE_SUFFIX_1,                    16210000
MFA-TR*             X.TITLE_SUFFIX_2,X.FULL_NAME,X.NAME_FORMAT          16220000
MFA-TR*      INTO                                                       16230000
MFA-TR*            :DQ-FIRST-NAME,                                      16240000
MFA-TR*            :DQ-LAST-NAME,                                       16250000
MFA-TR*            :DQ-MIDDLE-NAME,                                     16260000
MFA-TR*            :DQ-TITLE-PREFIX,                                    16270000
MFA-TR*            :DQ-TITLE-SUFFIX-1,                                  16280000
MFA-TR*            :DQ-TITLE-SUFFIX-2,                                  16290000
MFA-TR*            :DQ-FULL-NAME,                                       16300000
MFA-TR*            :DQ-NAME-FORMAT                                      16310000
MFA-TR*      FROM CSS_NAME X,CSS_ACCT_BILL_NMES Y                       16320000
MFA-TR*      WHERE                                                      16330000
MFA-TR*        Y.ACCOUNT_NO = :MU-SUB-ACCT-NO  AND                      16340000
MFA-TR*        X.NAME_ID    = Y.NAME_ID       AND                       16350000
MFA-TR*        Y.NAME_TYPE  = 'DB'                                      16360000
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                    16370000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

141800                                                                  
141900                                                                  
142000     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
142100                                                                  
142200     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
142300        NOT-FOUND                                                 
142400        NEXT SENTENCE                                             
142500     ELSE                                                         
142600        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'SELECT'                   TO ABEND-FUNCTION         
142800        MOVE 'CSS_ACCT_BILL_NMES'       TO TABLE-1                
CBSI          MOVE 'CSS_NAME'                 TO TABLE-2                
142900        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
143000        MOVE MU-SUB-ACCT-NO             TO HOSTVAR-ELEMENT-1      
143100        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
143200        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
143300     END-IF.                                                      
143400                                                                  
143500                                                                  
143600 7500-EXIT.                                                       
143700     EXIT.                                                        
143701******************************************************************16580000
143702* 7510-SELECT-CUST-NAME                                          *16590000
143703*     CALLS       9000-SEND-ERROR-RESULT                         *16600000
143704*                 9900-SQL-ERROR-ROUTINE                         *16610000
143705*                                                                *16620000
143706*     CALLED FROM 2000-PROCESS-OUTPUT                            *16630000
143707*                                                                *16640000
143708*     SELECTS CSS_CUSTOMER       AND CSS_NAME TO FIND OUT NAME   *16650000
143709******************************************************************16660000
143710                                                                  
143711 7510-SELECT-CUST-NAME.                                           
143712                                                                  
143713     MOVE '7510'                     TO ACTIVE-PARAGRAPH.         
143714                                                                  
143715     EXEC SQL                                                     
143716       SELECT X.FIRST_NAME,X.LAST_NAME,X.MIDDLE_NAME,             
143717              X.TITLE_PREFIX,X.TITLE_SUFFIX_1,                    
143718              X.TITLE_SUFFIX_2,X.FULL_NAME,X.NAME_FORMAT          
143719       INTO                                                       
143720             :DQ-FIRST-NAME,                                      
143721             :DQ-LAST-NAME,                                       
143722             :DQ-MIDDLE-NAME,                                     
143723             :DQ-TITLE-PREFIX,                                    
143724             :DQ-TITLE-SUFFIX-1,                                  
143725             :DQ-TITLE-SUFFIX-2,                                  
143726             :DQ-FULL-NAME,                                       
143727             :DQ-NAME-FORMAT                                      
143728       FROM CSS_NAME X WITH(READUNCOMMITTED), CSS_CUSTOMER Y
                           WITH(READUNCOMMITTED)                            
143729       WHERE                                                      
143730         Y.CUSTOMER_NO = :WS-CUSTOMER-NO  AND                     
143731         X.NAME_ID    = Y.NAME_ID                                 
T35434                                                           
143733     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     16720000
MFA-TR*      SELECT X.FIRST_NAME,X.LAST_NAME,X.MIDDLE_NAME,             16730000
MFA-TR*             X.TITLE_PREFIX,X.TITLE_SUFFIX_1,                    16740000
MFA-TR*             X.TITLE_SUFFIX_2,X.FULL_NAME,X.NAME_FORMAT          16750000
MFA-TR*      INTO                                                       16760000
MFA-TR*            :DQ-FIRST-NAME,                                      16770000
MFA-TR*            :DQ-LAST-NAME,                                       16780000
MFA-TR*            :DQ-MIDDLE-NAME,                                     16790000
MFA-TR*            :DQ-TITLE-PREFIX,                                    16800000
MFA-TR*            :DQ-TITLE-SUFFIX-1,                                  16810000
MFA-TR*            :DQ-TITLE-SUFFIX-2,                                  16820000
MFA-TR*            :DQ-FULL-NAME,                                       16830000
MFA-TR*            :DQ-NAME-FORMAT                                      16840000
MFA-TR*      FROM CSS_NAME X, CSS_CUSTOMER Y                            16850000
MFA-TR*      WHERE                                                      16860000
MFA-TR*        Y.CUSTOMER_NO = :WS-CUSTOMER-NO  AND                     16870000
MFA-TR*        X.NAME_ID    = Y.NAME_ID                                 16880000
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                    16890000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

143734                                                                  
143735                                                                  
143736     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
143737                                                                  
143738     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
143739        NOT-FOUND                                                 
143740        NEXT SENTENCE                                             
143741     ELSE                                                         
143742        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'SELECT'                   TO ABEND-FUNCTION         
143744        MOVE 'CSS_CUSTOMER      '       TO TABLE-1                
CBSI          MOVE 'CSS_NAME'                 TO TABLE-2                
143745        MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-1        
143746        MOVE WS-CUSTOMER-NO             TO HOSTVAR-ELEMENT-1      
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
CBSI          MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
143747        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
143748        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
143749     END-IF.                                                      
143750                                                                  
143751                                                                  
143752 7510-EXIT.                                                       
143753     EXIT.                                                        
143754******************************************************************17100000
143755* 7550-SEL-DISTINT-BILL-CYCLE                                    *17110000
143756*     CALLS       9000-SEND-ERROR-RESULT                         *17120000
143757*                 9900-SQL-ERROR-ROUTINE                         *17130000
143758*                                                                *17140000
143759*     CALLED FROM 2000-PROCESS-OUTPUT                            *17150000
143760*                                                                *17160000
143761*     SELECTS CSS_ACCTOUNT TO FIND OUT DISTINCT BILL CYCLE OF    *17170000
143762*     THE SUB ACCOUNTS                                           *17180000
143763******************************************************************17190000
143764                                                                  
143765 7550-SEL-DISTINCT-BILL-CYCLE.                                    
143766                                                                  
143767     MOVE '7550'                     TO ACTIVE-PARAGRAPH.         
143768                                                                  
143769     EXEC SQL                                                     
143770                                                                  
143771       SELECT COUNT(DISTINCT BILL_CYCLE)                          
143772       INTO                                                       
143773       :WS-DISTINCT-BILL-CYCLE                                    
143774       FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                             
143775       WHERE ACCOUNT_NO IN                                        
143776          (SELECT SUB_ACCT_NO FROM CSS_MSTSUB_ACCT
                           WITH(READUNCOMMITTED)                
143777            WHERE MST_ACCT_NO = :WS-ACCOUNT-NO)                   
T35434                                                           
143779     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     17250000
MFA-TR*                                                                 17260000
MFA-TR*      SELECT COUNT(DISTINCT BILL_CYCLE)                          17270000
MFA-TR*      INTO                                                       17280000
MFA-TR*      :WS-DISTINCT-BILL-CYCLE                                    17290000
MFA-TR*      FROM CSS_ACCOUNT                                           17300000
MFA-TR*      WHERE ACCOUNT_NO IN                                        17310000
MFA-TR*         (SELECT SUB_ACCT_NO FROM CSS_MSTSUB_ACCT                17320000
MFA-TR*           WHERE MST_ACCT_NO = :WS-ACCOUNT-NO)                   17330000
MFA-TR*      WITH UR                                                    17340000
MFA-TR*    END-EXEC.                                                    17350000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

143780                                                                  
143781     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
143782                                                                  
143783     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
143784        NOT-FOUND                                                 
143785        NEXT SENTENCE                                             
143786     ELSE                                                         
143787        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'SELECT'                   TO ABEND-FUNCTION         
143789        MOVE 'CSS_ACCOUNT       '       TO TABLE-1                
CBSI          MOVE 'CSS_MSTSUB_ACCT   '       TO TABLE-2                
CBSI          MOVE 'MST_ACCT_NO'              TO TABLE-ELEMENT-1        
143791        MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
143792        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
143793        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
143794     END-IF.                                                      
143795                                                                  
143796                                                                  
143797 7550-EXIT.                                                       
143798     EXIT.                                                        
REARCH*                                                                         
REARCH******************************************************************        
REARCH* 8000A-DELETE-GTT-ROWS                                          *        
REARCH******************************************************************        
REARCH*                                                                         
REARCH  8000A-DELETE-GTT-ROWS.                                          
REARCH*                                                                         
REARCH     MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.          
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH         DELETE FROM #CSR02278_R1                          
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR02278_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
REARCH*                                                                         
REARCH     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
REARCH        NEXT SENTENCE                                             
REARCH     ELSE                                                         
REARCH        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
REARCH        MOVE '8000A'               TO ACTIVE-PARAGRAPH            
REARCH        MOVE SQLCODE               TO ABEND-SQLCODE               
REARCH        MOVE 'DELETE'              TO ABEND-FUNCTION              
REARCH        MOVE SPACES                TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH        MOVE 'CSR02278_R1'         TO TABLE-1                     
REARCH        MOVE SPACES                TO TABLE-ELEMENT-1             
REARCH        MOVE SPACES                TO HOSTVAR-ELEMENT-1           
REARCH        PERFORM 9000-SEND-ERROR-RESULT                            
RAERCH                                   THRU 9000-EXIT                 
REARCH        PERFORM 9900-SQL-ERROR-ROUTINE                            
REARCH                                   THRU 9900-EXIT                 
REARCH     END-IF.                                                      
REARCH  8000A-EXIT.                                                     
REARCH     EXIT.                                                        
REARCH                                                                  
REARCH******************************************************************        
REARCH* 8100-SEND-RESULT                                               *        
REARCH******************************************************************        
REARCH 8100-SEND-RESULT.                                                
REARCH                                                                  
REARCH     EXEC SQL                                                     
REARCH          INSERT INTO #CSR02278_R1                         
REARCH          (                                                       
REARCH              RETURN_CODE                                         
REARCH             ,SUB_ACCT_NO                                         
REARCH             ,ACCOUNT_NAME                                        
REARCH             ,BILL_TYPE                                           
REARCH             ,BILL_CYCLE                                          
REARCH             ,BILL_STATUS                                         
REARCH             ,SUB_TOTAL_CODE                                      
REARCH             ,CODE_BILL_FREQ                                      
REARCH             ,NO_BILL_COPIES                                      
REARCH             ,BILL_CYCLE_MST                                      
REARCH             ,MST_OVRRD_BLL_IND                                   
REARCH             ,CODE_PRNT_BLL_MST                                   
REARCH             ,AMT_MO_PYMT                                         
REARCH             ,PAYMENT_TERMS                                       
REARCH             ,SUB_ACCT_STATUS                                     
REARCH          )                                                       
REARCH          VALUES                                                  
REARCH          (                                                       
REARCH              :S-RETURN-CODE                                      
REARCH             ,:S-SUB-ACCT-NO                                      
REARCH             ,:S-ACCOUNT-NAME                                     
REARCH             ,:S-BILL-TYPE                                        
REARCH             ,:S-BILL-CYCLE                                       
REARCH             ,:S-BILL-STATUS                                      
REARCH             ,:S-SUB-TOTAL-CODE                                   
REARCH             ,:S-CODE-BILL-FREQ                                   
REARCH             ,:S-NO-BILL-COPIES                                   
REARCH             ,:S-BILL-CYCLE-MST                                   
REARCH             ,:S-MST-OVRRD-BLL-IND                                
REARCH             ,:S-CODE-PRNT-BLL-MST                                
REARCH             ,:S-AMT-MO-PYMT                                      
REARCH             ,:S-PAYMENT-TERMS                                    
REARCH             ,:S-SUB-ACCT-STATUS                                  
REARCH          )                                                       
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR02278_R1                                 
MFA-TR*         (                                                               
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,SUB_ACCT_NO                                                 
MFA-TR*            ,ACCOUNT_NAME                                                
MFA-TR*            ,BILL_TYPE                                                   
MFA-TR*            ,BILL_CYCLE                                                  
MFA-TR*            ,BILL_STATUS                                                 
MFA-TR*            ,SUB_TOTAL_CODE                                              
MFA-TR*            ,CODE_BILL_FREQ                                              
MFA-TR*            ,NO_BILL_COPIES                                              
MFA-TR*            ,BILL_CYCLE_MST                                              
MFA-TR*            ,MST_OVRRD_BLL_IND                                           
MFA-TR*            ,CODE_PRNT_BLL_MST                                           
MFA-TR*            ,AMT_MO_PYMT                                                 
MFA-TR*            ,PAYMENT_TERMS                                               
MFA-TR*            ,SUB_ACCT_STATUS                                             
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*             :S-RETURN-CODE                                              
MFA-TR*            ,:S-SUB-ACCT-NO                                              
MFA-TR*            ,:S-ACCOUNT-NAME                                             
MFA-TR*            ,:S-BILL-TYPE                                                
MFA-TR*            ,:S-BILL-CYCLE                                               
MFA-TR*            ,:S-BILL-STATUS                                              
MFA-TR*            ,:S-SUB-TOTAL-CODE                                           
MFA-TR*            ,:S-CODE-BILL-FREQ                                           
MFA-TR*            ,:S-NO-BILL-COPIES                                           
MFA-TR*            ,:S-BILL-CYCLE-MST                                           
MFA-TR*            ,:S-MST-OVRRD-BLL-IND                                        
MFA-TR*            ,:S-CODE-PRNT-BLL-MST                                        
MFA-TR*            ,:S-AMT-MO-PYMT                                              
MFA-TR*            ,:S-PAYMENT-TERMS                                            
MFA-TR*            ,:S-SUB-ACCT-STATUS                                          
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
REARCH*                                                                         
REARCH     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
REARCH        ADD +1                    TO CTR-ROWS                     
REARCH     ELSE                                                         
REARCH        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
REARCH        MOVE '8100'               TO ACTIVE-PARAGRAPH             
REARCH        MOVE SQLCODE              TO ABEND-SQLCODE                
REARCH        MOVE 'INSERT'             TO ABEND-FUNCTION               
REARCH        MOVE SPACES               TO ABEND-SQL-PREDICATES         
REARCH                                     ABEND-TABLES                 
REARCH        MOVE 'CSR02278_R1'        TO TABLE-1                      
REARCH        MOVE SPACES               TO TABLE-ELEMENT-1              
REARCH        MOVE SPACES               TO HOSTVAR-ELEMENT-1            
REARCH        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH 8100-EXIT.                                                       
REARCH     EXIT.                                                        
REARCH*                                                                         
143840******************************************************************17550000
143900* 9900- JOURNALING / ERROR HANDLING INCLUDE *                     17560000
144000******************************************************************17570000
REARCH*    EXEC SQL                                                     17580000
REARCH*       INCLUDE CPD00300                                          17590000
REARCH*    END-EXEC.                                                    17600000
REARCH*                                                                         
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
144400                                                                  
144500******************************************************************17620000
144600*       END PROGRAM COPYLIB                                      *17630000
144700******************************************************************17640000
REARCH*    COPY CPD00302.                                               17650000
REARCH*                                                                         
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CPD00320                                                 
REARCH     END-EXEC.                                                            
144900                                                                  
