       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02272.                                         
COB303 DATE-WRITTEN. DECEMBER 7, 1994.                                   
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S272 CONVERTED TO DB2 SP CSR02272 ON 09/27/2005        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
      *                                                                *00110000
      *  TRANID:        S272                                           *00120071
      *  PROGRAM:       S272                                           *00130071
      *  CALLING SP:    PA_272                                         *00140070
      *                                                                *00150000
      *                                                                *00160000
      *                                                                *00170000
      ******************************************************************00180000
      *                 P R O G R A M  S U M M A R Y                   *00190000
      *                                                                *00200000
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *00210001
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *00220001
      *                                                                *00230001
      *  THIS PROGRAM RETRIEVES A SINGLE INSTANCE OF THE CUSTOMER'S    *00240001
      *  BILLING DETAIL HISTORY IN ORDER TO DISPLAY PEAK READING     *  00250070
      *  OCCURRENCES DURING A BILLING PERIOD.  THERE ARE TWO TYPES OF  *00260070
      *  PEAKS RETURNED. THE FIRST IS THE PEAK OF MEASURED DEMANDS AT  *00261070
      *  THE ICP.  THE SECOND IS THE PEAK OF ADJUSTED DEMANDS AT THE   *00262070
      *  SAME ICP.                                                     *00263070
      *                                                                *00264070
      ******************************************************************00270000
      *                                                                *00280000
      *                     PROGRAM MODIFICATION LOG                   *00290000
      *                                                                *00300000
      *    DATE    INITIALS   COMMENTS                                 *00310000
      *  --------  --------   ---------------------------------------  *00320000
      *  12/07/94    JHR      CREATED.                                 *00330070
      *  07/14/95    WMG      MODIFIED TO FIX TPR #5894.               *00340001
      *                       1. RS-RETURN-CODE WS-VARIABLE CHANGED    *00340001
      *                          TO A "COMP" TYPE FIELD TO FACILITATE  *00340001
      *                          ERROR MESSAGING IN THE DESKTOP        *00340001
      *                          ENVIRONMENT.                          *00340001
      *                                                                *00340001
T10864*  05/13/97    PD       DO NOT ROUND PF AND IF PF <> 85 THEN     *00340001
      *                       ESTIMATE FLAG IS 'Y' ELSE 'N'.           *00340001
T15521*  03/24/98    RGB      HANDLED FOR NOT FOUND CONDITION TO AVOID *00340001
T15521*              CBSI     WRITING INTO MC05 ERROR FILE .           *00340001
      *                                                                *00340001
T21643*  06/15/00    SREENI   CHANGES MADE WHILE RE-DESIGNING THE PANEL*00340001
      *                       TO DISPLAY MV90 PEAKS.                   *00340001
CIG   *  02/17/03    GANESH   CHANGES MADE TO INCLUDE CODE_UTIL_TYPE IN*00340001
CIG   *                       CSS_INTERVAL_READ TABLE.                 *00340001
REARCH*  09/27/05    CVNS     RPC TO COBOL SP CONVERSION               *00340001
REARCH*              CHENNAI                                           *00340001
PRJ899*  10/27/15    VV7M728  ADD BILL MONTH (REVENUE MONTH) COLUMN    *00340001
      *                       IN THE RESULT SET                        *00340001
      ******************************************************************00350000
      ******************************************************************00360000
      *                                                                *00370000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00380000
      *                                                                *00390000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00400000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00410000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00420000
      *  3000 - 4999  NOT USED                                         *00430000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00440000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00450000
      *  7000 - 7999  INPUT MODULES                                    *00460000
      *  8000 - 8999  OUTPUT MODULES                                   *00470000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00480000
      *                                                                *00490000
      ******************************************************************00500000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02272'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                               PIC X(40) VALUE       
REARCH     'WORKING STORAGE FOR CSR02272 STARTS HERE'.                  
                                                                        
                                                                        
      ******************************************************************00600000
      *    DB2 INCLUDES                                                *00610000
      ******************************************************************00620000
                                                                        
           EXEC SQL                                                     00640001
              INCLUDE SQLCA                                             00650001
           END-EXEC.                                                    00660001
                                                                        
           EXEC SQL                                                     00720001
              INCLUDE TBMODEL                                           00730001
           END-EXEC.                                                    00740001
                                                                        
           EXEC SQL                                                     00751011
              INCLUDE TBPKHIST                                          00752071
           END-EXEC.                                                    00753011
                                                                        
T21643     EXEC SQL                                                     00751011
T21643        INCLUDE TBINTVRD                                          00752071
T21643     END-EXEC.                                                    00753011
                                                                        
PRJ899     EXEC SQL                                                     00751011
PRJ899        INCLUDE TBBLLDET                                          00752071
PRJ899     END-EXEC.                                                    00753011
                                                                        
      ******************************************************************00770000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00780000
      ******************************************************************00790000
                                                                        
CVT999*    COPY SYGWCOB.                                                00810001
CVT999*    COPY SYDBCOB.                                                00820001
           COPY CCA00001.                                               00830001
CVT999*    COPY CWS00010.                                               00840001
           COPY CWS00027.                                               00850001
           COPY CWS00303.                                               00860001
                                                                        
      ******************************************************************00880000
      *    WORK AREAS                                                  *00890000
      ******************************************************************00900000
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
CVT999*    05  GWL-PROC                POINTER.                         00930001
CVT999*    05  GWL-INIT-HANDLE         POINTER.                         00940000
CVT999*    05  GWL-RC                  PIC S9(9) COMP.                  00950000
CVT999*    05  GWL-STATUS-NR           PIC S9(9) COMP.                  00960000
CVT999*    05  GWL-STATUS-DONE         PIC S9(9) COMP.                  00970000
CVT999*    05  GWL-STATUS-COUNT        PIC S9(9) COMP.                  00980000
CVT999*    05  GWL-STATUS-COMM         PIC S9(9) COMP.                  00990000
CVT999*    05  GWL-STATUS-RETURN-CODE  PIC S9(9) COMP.                  01000000
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9)  COMP.                 
CVT999*    05  PARM-ID1                PIC S9(9)  COMP VALUE 1.         01070008
           05  PARM-ACCOUNT-NO         PIC X(13)  VALUE SPACES.         
           05  PARM-ACCOUNT-NO-RED     REDEFINES  PARM-ACCOUNT-NO       
                                       PIC 9(13).                       
           05  PARM-IC-NO              PIC X(04)  VALUE SPACES.         
           05  PARM-IC-NO-RED          REDEFINES  PARM-IC-NO            
                                       PIC 9(04).                       
                                                                        
       01  WS-PARM-FIELDS.                                              
           05  WS-ACCOUNT-NO-NUM       PIC S9(13)V USAGE COMP-3         
                                       VALUE ZERO.                      
           05  WS-IC-NO-NUM            PIC S9(04)  USAGE COMP           
                                       VALUE ZERO.                      
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
CVT999*    05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          01140000
                                                                        
       01  COUNTER-FIELDS.                                              
CVT999*    05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          01170000
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
CVT999*    05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  01220000
CVT999*    05  WRKLEN1                 PIC S9(9) COMP.                  01230000
CVT999*    05  WRKLEN2                 PIC S9(9) COMP.                  01240000
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
                                                                        
       01  WS-PEAK-FIELDS.                                              
           05  WS-PEAK-DATE            PIC X(10)     VALUE SPACES.      
           05  WS-PEAK-TIME            PIC X(08)     VALUE SPACES.      
T21643     05  WS-PEAK-TYPE            PIC X(01)     VALUE SPACES.      
T21643     05  WS-METER-NO             PIC X(09)     VALUE SPACES.      
T21643     05  WS-PEAK-KW-UNITS        PIC S9(07)V   USAGE COMP-3       
                                                     VALUE ZERO.        
T21643     05  WS-PEAK-KVA-UNITS       PIC S9(07)V99 USAGE COMP-3       
                                                     VALUE ZERO.        
T21643     05  WS-PEAK-KVAR-UNITS      PIC S9(07)V99 USAGE COMP-3       
T21643                                               VALUE ZERO.        
           05  WS-PEAK-POWER-FCTR      PIC S9(9)V99  USAGE COMP-3       
                                                     VALUE ZERO.        
T21643     05  WS-START-DATE           PIC X(10)     VALUE SPACES.      
T21643     05  WS-START-TIME           PIC X(08)     VALUE SPACES.      
                                                                        
       01  WS-MISC-VALUES.                                              
REARCH     05  PROGRAM-NAME            PIC X(08)   VALUE 'CSR02272'.    
           05  WS-YES                  PIC X(01)   VALUE 'Y'.           
           05  WS-NO                   PIC X(01)   VALUE 'N'.           
           05  WS-ACTIVE-CODE          PIC X(01)   VALUE 'A'.           
           05  WS-ELECTRIC-TYPE        PIC X(01)   VALUE 'E'.           
T21643     05  WS-DEFAULT-PWR-FCTR     PIC S9(01)V99 USAGE COMP-3       
T21643                                             VALUE +0.85.         
T21643     05  WS-START-DATE-NULL      PIC S9(4)   COMP.                
T21643     05  WS-START-TIME-NULL      PIC S9(4)   COMP.                
T21643     05  WS-REV-MTH-ORIG-BILL    PIC 9(06)   .                    
                                                                        
       01  FILLER  PIC X(32)  VALUE 'THIS IS THE ROW RETURN AREA.    '. 
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE         PIC S9(09)    COMP VALUE ZERO.    
           05  RS-PEAK-DATE           PIC X(10)     VALUE SPACES.       
           05  RS-PEAK-TIME           PIC X(08)     VALUE SPACES.       
T21643     05  RS-PEAK-TYPE           PIC X(01)     VALUE SPACES.       
T21643     05  RS-METER-NO            PIC X(09)     VALUE SPACES.       
T21643     05  RS-PEAK-KW-UNITS       PIC S9(07)V   USAGE COMP-3        
                                                    VALUE ZERO.         
T21643     05  RS-PEAK-KVA-UNITS      PIC S9(07)V99 USAGE COMP-3        
                                                    VALUE ZERO.         
T21643     05  RS-PEAK-KVAR-UNITS     PIC S9(07)V99 USAGE COMP-3        
                                                    VALUE ZERO.         
T21643     05  RS-PEAK-POWER-FCTR     PIC S9(09)V99 USAGE COMP-3        
                                                    VALUE ZERO.         
T21643     05  RS-START-DATE          PIC X(10)     VALUE SPACES.       
T21643     05  RS-START-TIME          PIC X(08)     VALUE SPACES.       
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE          PIC S9(09)    COMP VALUE ZERO.    
REARCH     05  S-PEAK-DATE            PIC X(10)     VALUE SPACES.       
REARCH     05  S-PEAK-TIME            PIC X(08)     VALUE SPACES.       
REARCH     05  S-PEAK-TYPE            PIC X(01)     VALUE SPACES.       
REARCH     05  S-METER-NO             PIC X(09)     VALUE SPACES.       
REARCH     05  S-PEAK-KW-UNITS        PIC S9(07)V   USAGE COMP-3        
REARCH                                              VALUE ZERO.         
REARCH     05  S-PEAK-KVA-UNITS       PIC S9(07)V99 USAGE COMP-3        
REARCH                                              VALUE ZERO.         
REARCH     05  S-PEAK-KVAR-UNITS      PIC S9(07)V99 USAGE COMP-3        
REARCH                                              VALUE ZERO.         
REARCH     05  S-PEAK-POWER-FCTR      PIC S9(09)V99 USAGE COMP-3        
REARCH                                              VALUE ZERO.         
REARCH     05  S-START-DATE           PIC X(10)     VALUE SPACES.       
REARCH     05  S-START-TIME           PIC X(08)     VALUE SPACES.       
PRJ899     05  S-REVENUE-MONTH        PIC S9(06)V   USAGE COMP-3        
REARCH                                              VALUE ZERO.         
PRJ899     05  S-REV-MTH-ORIG-BILL    PIC S9(06)V   USAGE COMP-3        
REARCH                                              VALUE ZERO.         
REARCH*                                                                 01412739
                                                                        
CVT999*01  CNS-COLUMN-NAMES.                                            01420001
CVT999*    05  CNS-RETURN-CODE         PIC X(11) VALUE                  01430001
CVT999*                                        'RETURN_CODE'.           01440001
CVT999*    05  CNS-PEAK-DATE           PIC X(09) VALUE                  01450071
CVT999*                                        'PEAK_DATE'.             01460071
CVT999*    05  CNS-PEAK-TIME           PIC X(09) VALUE                  01470071
CVT999*                                        'PEAK_TIME'.             01480071
CVT999*    05  CNS-PEAK-TYPE           PIC X(09) VALUE                  01470071
CVT999*                                        'PEAK_TYPE'.             01480071
CVT999*    05  CNS-METER-NO            PIC X(08) VALUE                  01470071
CVT999*                                        'METER_NO'.              01480071
CVT999*    05  CNS-PEAK-KW             PIC X(07) VALUE                  01490071
CVT999*                                        'PEAK_KW'.               01500070
CVT999*    05  CNS-PEAK-KVA            PIC X(08) VALUE                  01501071
CVT999*                                        'PEAK_KVA'.              01502070
CVT999*    05  CNS-PEAK-KVAR           PIC X(09) VALUE                  01501071
CVT999*                                        'PEAK_KVAR'.             01502070
CVT999*    05  CNS-PEAK-POWER-FCTR     PIC X(15) VALUE                  01505071
CVT999*                                        'PEAK_POWER_FCTR'.       01506070
CVT999*    05  CNS-START-DATE          PIC X(10) VALUE                  01501071
CVT999*                                        'START_DATE'.            01502070
CVT999*    05  CNS-START-TIME          PIC X(10) VALUE                  01501071
CVT999*                                        'START_TIME'.            01502070
CVT999*                                                                 01517071
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
T21643******************************************************************01014000
T21643*  CURSOR DECLARATION FOR GETTING THE MV90 PEAKS.                *01016000
T21643******************************************************************01020000
T21643     EXEC SQL                                                     
T21643       DECLARE GET_PEAKS CURSOR FOR                               
T21643        SELECT PH.BILL_NO                                         
T21643              ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           PH.BILL_ITEM_TIMESTMP, 121), ' ', '-'), ':', '.') 
           BILL_ITEM_TIMESTMP                              
T21643              ,PH.MTR_REF_NO                                      
T21643              ,REPLACE(CONVERT(CHAR(8), PH.PEAK_TIME, 108), ':', 
           '.') PEAK_TIME                                       
T21643              ,PH.PEAK_DATE                                       
T21643              ,PH.PEAK_KW_UNITS                                   
T21643              ,PH.PEAK_KVA_UNITS                                  
T21643              ,PH.PEAK_KVAR_UNITS                                 
T21643              ,PH.METER_NO                                        
T21643              ,PH.PEAK_TYPE                                       
PRJ899              ,BG.REVENUE_MONTH                                   
PRJ899              ,BG.REV_MTH_ORIG_BILL                               
T21643          FROM CSS_PEAK_HISTORY PH                                
P0899               ,CSS_BILLING_DET BG                                 
T21643         WHERE PH.CODE_UTIL_TYPE  = :PH-CODE-UTIL-TYPE            
T21643           AND PH.ACCOUNT_NO      = :PH-ACCOUNT-NO                
T21643           AND PH.IC_NO           = :PH-IC-NO                     
T21643           AND PH.CODE_UTIL_TYPE  = BG.CODE_UTIL_TYPE             
TR2643           AND PH.IC_NO           = BG.IC_NO                      
TR2643           AND PH.BILL_NO         = BG.BILL_NO                    
TR2643           AND PH.ACCOUNT_NO      = BG.ACCOUNT_NO                 
T21643           AND PH.IC_NO           = BG.IC_NO                      
T21643           AND PH.BILL_ITEM_TIMESTMP = BG.BILL_ITEM_TIMESTMP      
T21643      ORDER BY PH.PEAK_DATE DESC, PEAK_TIME DESC               
T21643     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     01021000
MFA-TR*      DECLARE GET_PEAKS CURSOR FOR                               01022000
MFA-TR*       SELECT PH.BILL_NO                                                 
MFA-TR*             ,PH.BILL_ITEM_TIMESTMP                                      
MFA-TR*             ,PH.MTR_REF_NO                                              
MFA-TR*             ,PH.PEAK_TIME                                               
MFA-TR*             ,PH.PEAK_DATE                                               
MFA-TR*             ,PH.PEAK_KW_UNITS                                           
MFA-TR*             ,PH.PEAK_KVA_UNITS                                          
MFA-TR*             ,PH.PEAK_KVAR_UNITS                                         
MFA-TR*             ,PH.METER_NO                                                
MFA-TR*             ,PH.PEAK_TYPE                                               
MFA-TR*             ,BG.REVENUE_MONTH                                           
MFA-TR*             ,BG.REV_MTH_ORIG_BILL                                       
MFA-TR*         FROM CSS_PEAK_HISTORY PH                                        
MFA-TR*             ,CSS_BILLING_DET BG                                         
MFA-TR*        WHERE PH.CODE_UTIL_TYPE  = :PH-CODE-UTIL-TYPE                    
MFA-TR*          AND PH.ACCOUNT_NO      = :PH-ACCOUNT-NO                        
MFA-TR*          AND PH.IC_NO           = :PH-IC-NO                             
MFA-TR*          AND PH.CODE_UTIL_TYPE  = BG.CODE_UTIL_TYPE                     
MFA-TR*          AND PH.IC_NO           = BG.IC_NO                              
MFA-TR*          AND PH.BILL_NO         = BG.BILL_NO                            
MFA-TR*          AND PH.ACCOUNT_NO      = BG.ACCOUNT_NO                         
MFA-TR*          AND PH.IC_NO           = BG.IC_NO                              
MFA-TR*          AND PH.BILL_ITEM_TIMESTMP = BG.BILL_ITEM_TIMESTMP              
MFA-TR*     ORDER BY PH.PEAK_DATE DESC, PH.PEAK_TIME DESC                       
MFA-TR*    END-EXEC.                                                            
HPCCDM*EJECT                                                            01612000
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
REARCH*    10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        00001701
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         DECLARE C1 CURSOR  FOR                        
CVT000         SELECT                                                   
REARCH         RETURN_CODE                                              
REARCH        ,LTRIM(RTRIM(PEAK_DATE))   AS PEAK_DATE                          
REARCH        ,LTRIM(RTRIM(PEAK_TIME))   AS PEAK_TIME                          
REARCH        ,LTRIM(RTRIM(PEAK_TYPE))   AS PEAK_TYPE                          
REARCH        ,LTRIM(RTRIM(METER_NO))    AS METER_NO                           
REARCH        ,PEAK_KW_UNITS      AS PEAK_KW                            
REARCH        ,PEAK_KVA_UNITS     AS PEAK_KVA                           
REARCH        ,PEAK_KVAR_UNITS    AS PEAK_KVAR                          
REARCH        ,PEAK_POWER_FCTR                                          
REARCH        ,LTRIM(RTRIM(START_DATE))  AS START_DATE                         
REARCH        ,LTRIM(RTRIM(START_TIME))  AS START_TIME                         
PRJ899        ,REVENUE_MONTH                                            
CVT000         FROM #CSR02272_R1                                 
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00000100
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        00000300
MFA-TR*        SELECT                                                   00000400
MFA-TR*        RETURN_CODE                                                      
MFA-TR*       ,STRIP(PEAK_DATE)   AS PEAK_DATE                                  
MFA-TR*       ,STRIP(PEAK_TIME)   AS PEAK_TIME                                  
MFA-TR*       ,STRIP(PEAK_TYPE)   AS PEAK_TYPE                                  
MFA-TR*       ,STRIP(METER_NO)    AS METER_NO                                   
MFA-TR*       ,PEAK_KW_UNITS      AS PEAK_KW                                    
MFA-TR*       ,PEAK_KVA_UNITS     AS PEAK_KVA                                   
MFA-TR*       ,PEAK_KVAR_UNITS    AS PEAK_KVAR                                  
MFA-TR*       ,PEAK_POWER_FCTR                                                  
MFA-TR*       ,STRIP(START_DATE)  AS START_DATE                                 
MFA-TR*       ,STRIP(START_TIME)  AS START_TIME                                 
MFA-TR*       ,REVENUE_MONTH                                                    
MFA-TR*        FROM SESSION.CSR02272_R1                                 00000500
MFA-TR*    END-EXEC.                                                    00000700
CVT000                                                                  
                                                                        
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-ACCOUNT-NO          PIC X(13)                .          
CVT000 01  LINK-IC-NO               PIC X(04)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-ACCOUNT-NO                                         
CVT000          LINK-IC-NO                                              
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                              01620000
                                                                        
      ******************************************************************01640000
      * 0000-MAINLINE                                                  *01650000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *01660000
      ******************************************************************01670000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE         THRU 0100-EXIT.              
           PERFORM 1000-PROCESS-INPUT      THRU 1000-EXIT.              
           PERFORM 2000-PROCESS-OUTPUT     THRU 2000-EXIT.              
T21643     IF  CTR-ROWS < 1                                             
T21643         INITIALIZE GTT-RETURN-FIELDS                             
T21643         MOVE +100                         TO RS-RETURN-CODE      
REARCH         PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT              
T21643         PERFORM 8100-SEND-RESULT    THRU 8100-EXIT               
T21643     END-IF.                                                      
T21643*                                                                         
           PERFORM 9999-END-PROGRAM        THRU 9999-EXIT.              
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************01790000
      * 0100-INITIALIZE                                                *01800000
      *                                                                *01810000
      *     1. RESET DB2 ERROR HANDLERS                                *01820000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *01830000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *01840000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*01850000
      *                                                                *01860000
      ******************************************************************01870000
       0100-INITIALIZE.                                                 
                                                                        
CVT999*    EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              01910000
CVT999*    EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              01920000
CVT999*    EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              01930000
CVT999*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.     01940000
                                                                        
CVT999*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,     01960000
CVT999*                          SNA-CONNECTION-NAME, SNA-SUBC.         01970000
                                                                        
CVT999*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                      01990000
                                                                        
CVT999*    IF GWL-RC NOT = TDS-PARM-PRESENT                             02010000
CVT999*       MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        02020021
CVT999*       MOVE '0100'                       TO ACTIVE-PARAGRAPH     02030021
CVT999*       MOVE 'TDRESULT- NO RPC PARM SENT' TO ABEND-FUNCTION       02040021
CVT999*       MOVE 'CICS TRANSACTION'           TO TABLE-1              02050021
CVT999*       MOVE GWL-RC                       TO WS-ACTIVE-RETURN-CODE02060021
CVT999*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            02070001
CVT999*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            02080001
CVT999*    END-IF.                                                      02090000
                                                                        
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
CVT000     MOVE LINK-IC-NO                TO PARM-IC-NO               . 
CVT000     PERFORM 0100A-DECLARE-GTT                                    
CVT000       THRU 0100A-EXIT.                                           
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
CVT000 0100A-DECLARE-GTT.                                               
CVT000     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02272_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02272_R1
              (                                                          
CVT000         RETURN_CODE              INT                         
CVT000        ,PEAK_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2              
CVT000        ,PEAK_TIME CHAR(08)  COLLATE LATIN1_GENERAL_100_BIN2              
CVT000        ,PEAK_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2              
CVT000        ,METER_NO CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2               
CVT000        ,PEAK_KW_UNITS            DECIMAL(07,0)                   
CVT000        ,PEAK_KVA_UNITS           DECIMAL(09,2)                   
CVT000        ,PEAK_KVAR_UNITS          DECIMAL(09,2)                   
CVT000        ,PEAK_POWER_FCTR          DECIMAL(11,2)                   
CVT000        ,START_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2             
CVT000        ,START_TIME CHAR(08)  COLLATE LATIN1_GENERAL_100_BIN2             
PRJ899        ,REVENUE_MONTH            DECIMAL(06,0)                   
CVT000       )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
REARCH            MOVE 'CSR02272_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
CVT000 0100A-EXIT.                                                      
CVT000         EXIT.                                                    
                                                                        
                                                                        
      ******************************************************************02140000
      * 1000-PROCESS-INPUT                                             *02150000
      *                                                                *02160000
      *     1. PROCESS INPUT PARMS.                                    *02170013
      *                                                                *02180000
      ******************************************************************02190000
       1000-PROCESS-INPUT.                                              
                                                                        
REARCH*    PERFORM 1100-RECEIVE-PARMS     THRU 1100-EXIT.               02230001
                                                                        
           MOVE PARM-ACCOUNT-NO-RED       TO WS-ACCOUNT-NO-NUM.         
           MOVE PARM-IC-NO-RED            TO WS-IC-NO-NUM.              
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02281006
      * 1100-RECEIVE-PARMS.                                            *02282006
      *                                                                *02283006
      *     1. RECEIVE PARMS.                                          *02284006
      *                                                                *02285006
      ******************************************************************02286006
REARCH*1100-RECEIVE-PARMS.                                              02300001
                                                                        
CVT999*    MOVE 1                           TO PARM-ID1.                02419374
CVT999*    MOVE LENGTH OF PARM-ACCOUNT-NO   TO MAX-LENGTH-PARM.         02419406
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                              02419606
CVT999*                          GWL-RC,                                02419706
CVT999*                          PARM-ID1,                              02419806
CVT999*                          PARM-ACCOUNT-NO,                       02419906
CVT999*                          TDSCHAR,                               02420006
CVT999*                          MAX-LENGTH-PARM,                       02420106
CVT999*                          PARM-L.                                02420206
                                                                        
CVT999*    ADD 1                            TO PARM-ID1.                02420408
CVT999*    MOVE LENGTH OF PARM-IC-NO        TO MAX-LENGTH-PARM.         02420508
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                              02420708
CVT999*                          GWL-RC,                                02420808
CVT999*                          PARM-ID1,                              02420908
CVT999*                          PARM-IC-NO,                            02421008
CVT999*                          TDSCHAR,                               02421108
CVT999*                          MAX-LENGTH-PARM,                       02421208
CVT999*                          PARM-L.                                02421308
                                                                        
REARCH*1100-EXIT.                                                       02424001
REARCH*    EXIT.                                                        02430001
                                                                        
      ******************************************************************02450001
      * 2000-PROCESS-OUTPUT.                                           *02460001
      *      1. DESCRIBE THE RESULT SET ROW SENT BACK.                 *02470073
      *      2. BUILD THE RESULT.                                      *02471073
      *      3. FORMAT AND SEND BACK THE FIRST PEAK ROW INFORMATION.   *02472073
      *      4. FORMAT AND SENT BACK THE SECOND PEAK ROW INFORMATION.  *02473073
      ******************************************************************02480001
       2000-PROCESS-OUTPUT.                                             
                                                                        
REARCH*    PERFORM 2100-DESCRIBE-RESULT    THRU 2100-EXIT.              02510073
                                                                        
           PERFORM 2200-BUILD-RESULT       THRU 2200-EXIT.              
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
REARCH******************************************************************02580001
REARCH*2000A-MOVE-RESULT.                                              *        
REARCH******************************************************************        
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE RS-RETURN-CODE           TO S-RETURN-CODE.              
REARCH     MOVE RS-PEAK-DATE             TO S-PEAK-DATE.                
REARCH     MOVE RS-PEAK-TIME             TO S-PEAK-TIME.                
REARCH     MOVE RS-PEAK-TYPE             TO S-PEAK-TYPE.                
REARCH     MOVE RS-METER-NO              TO S-METER-NO.                 
REARCH     MOVE RS-PEAK-KW-UNITS         TO S-PEAK-KW-UNITS.            
REARCH     MOVE RS-PEAK-KVA-UNITS        TO S-PEAK-KVA-UNITS.           
REARCH     MOVE RS-PEAK-KVAR-UNITS       TO S-PEAK-KVAR-UNITS.          
REARCH     MOVE RS-PEAK-POWER-FCTR       TO S-PEAK-POWER-FCTR.          
REARCH     MOVE RS-START-DATE            TO S-START-DATE.               
REARCH     MOVE RS-START-TIME            TO S-START-TIME.               
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
      ******************************************************************02590001
      * 2100-DESCRIBE-RESULT                                           *02600001
      ******************************************************************02610001
REARCH*2100-DESCRIBE-RESULT.                                            02630001
                                                                        
REARCH*    MOVE '2100'                        TO ACTIVE-PARAGRAPH.      02640021
                                                                        
CVT999*    MOVE 1                             TO CTR-COLUMN.            02660021
CVT999*    MOVE TDSINT4                       TO DB-HOST-TYPE.          02670021
CVT999*    MOVE TDSINT4                       TO DB-CLIENT-TYPE.        02680021
CVT999*    MOVE LENGTH OF RS-RETURN-CODE      TO WRKLEN1.               02690001
CVT999*    MOVE LENGTH OF CNS-RETURN-CODE     TO WRKLEN2.               02700001
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              02720001
CVT999*                          GWL-RC,                                02730001
CVT999*                          CTR-COLUMN,                            02740001
CVT999*                          DB-HOST-TYPE,                          02750001
CVT999*                          WRKLEN1,                               02760001
CVT999*                          RS-RETURN-CODE,                        02770001
CVT999*                          DB-NULL-INDICATOR,                     02780001
CVT999*                          TDS-FALSE,                             02790001
CVT999*                          DB-CLIENT-TYPE,                        02800001
CVT999*                          WRKLEN1,                               02810001
CVT999*                          CNS-RETURN-CODE,                       02820001
CVT999*                          WRKLEN2.                               02830001
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02850001
                                                                        
                                                                        
CVT999*    ADD  1                             TO CTR-COLUMN.            02872021
CVT999*    MOVE TDSCHAR                       TO DB-HOST-TYPE.          02880021
CVT999*    MOVE TDSCHAR                       TO DB-CLIENT-TYPE.        02890021
CVT999*    MOVE LENGTH OF RS-PEAK-DATE        TO WRKLEN1.               02900074
CVT999*    MOVE LENGTH OF CNS-PEAK-DATE       TO WRKLEN2.               02910074
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              02930001
CVT999*                          GWL-RC,                                02940001
CVT999*                          CTR-COLUMN,                            02950001
CVT999*                          DB-HOST-TYPE,                          02960001
CVT999*                          WRKLEN1,                               02970001
CVT999*                          RS-PEAK-DATE,                          02980074
CVT999*                          DB-NULL-INDICATOR,                     02990001
CVT999*                          TDS-FALSE,                             03000001
CVT999*                          DB-CLIENT-TYPE,                        03010001
CVT999*                          WRKLEN1,                               03020001
CVT999*                          CNS-PEAK-DATE,                         03030074
CVT999*                          WRKLEN2.                               03040001
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     03060001
                                                                        
                                                                        
CVT999*    ADD 1                               TO CTR-COLUMN.           03090040
CVT999*    MOVE TDSCHAR                        TO DB-HOST-TYPE.         03100040
CVT999*    MOVE TDSCHAR                        TO DB-CLIENT-TYPE.       03110040
CVT999*    MOVE LENGTH OF RS-PEAK-TIME         TO WRKLEN1.              03120074
CVT999*    MOVE LENGTH OF CNS-PEAK-TIME        TO WRKLEN2.              03130074
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              03150001
CVT999*                          GWL-RC,                                03160001
CVT999*                          CTR-COLUMN,                            03170001
CVT999*                          DB-HOST-TYPE,                          03180001
CVT999*                          WRKLEN1,                               03190001
CVT999*                          RS-PEAK-TIME,                          03200074
CVT999*                          DB-NULL-INDICATOR,                     03210001
CVT999*                          TDS-FALSE,                             03220001
CVT999*                          DB-CLIENT-TYPE,                        03230001
CVT999*                          WRKLEN1,                               03240001
CVT999*                          CNS-PEAK-TIME,                         03250074
CVT999*                          WRKLEN2.                               03260040
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     03280001
                                                                        
CVT999*    ADD 1                               TO CTR-COLUMN.           03090040
CVT999*    MOVE TDSCHAR                        TO DB-HOST-TYPE.         03100040
CVT999*    MOVE TDSCHAR                        TO DB-CLIENT-TYPE.       03110040
CVT999*    MOVE LENGTH OF RS-PEAK-TYPE         TO WRKLEN1.              03120074
CVT999*    MOVE LENGTH OF CNS-PEAK-TYPE        TO WRKLEN2.              03130074
T21643                                                                  
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              03150001
CVT999*                          GWL-RC,                                03160001
CVT999*                          CTR-COLUMN,                            03170001
CVT999*                          DB-HOST-TYPE,                          03180001
CVT999*                          WRKLEN1,                               03190001
CVT999*                          RS-PEAK-TYPE,                          03200074
CVT999*                          DB-NULL-INDICATOR,                     03210001
CVT999*                          TDS-FALSE,                             03220001
CVT999*                          DB-CLIENT-TYPE,                        03230001
CVT999*                          WRKLEN1,                               03240001
CVT999*                          CNS-PEAK-TYPE,                         03250074
CVT999*                          WRKLEN2.                               03260040
T21643                                                                  
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     03280001
T21643                                                                  
CVT999*    ADD 1                               TO CTR-COLUMN.           03090040
CVT999*    MOVE TDSCHAR                        TO DB-HOST-TYPE.         03100040
CVT999*    MOVE TDSCHAR                        TO DB-CLIENT-TYPE.       03110040
CVT999*    MOVE LENGTH OF RS-METER-NO          TO WRKLEN1.              03120074
CVT999*    MOVE LENGTH OF CNS-METER-NO         TO WRKLEN2.              03130074
T21643                                                                  
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              03150001
CVT999*                          GWL-RC,                                03160001
CVT999*                          CTR-COLUMN,                            03170001
CVT999*                          DB-HOST-TYPE,                          03180001
CVT999*                          WRKLEN1,                               03190001
CVT999*                          RS-METER-NO,                           03200074
CVT999*                          DB-NULL-INDICATOR,                     03210001
CVT999*                          TDS-FALSE,                             03220001
CVT999*                          DB-CLIENT-TYPE,                        03230001
CVT999*                          WRKLEN1,                               03240001
CVT999*                          CNS-METER-NO,                          03250074
CVT999*                          WRKLEN2.                               03260040
T21643                                                                  
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     03280001
                                                                        
CVT999*    ADD 1                               TO CTR-COLUMN.           03310021
CVT999*    MOVE TDSDECIMAL                     TO DB-HOST-TYPE.         03320040
CVT999*    MOVE TDSFLT8                        TO DB-CLIENT-TYPE.       03330040
CVT999*    MOVE LENGTH OF RS-PEAK-KW-UNITS     TO WRKLEN1.              03340074
CVT999*    MOVE LENGTH OF CNS-PEAK-KW          TO WRKLEN2.              03350074
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              03370001
CVT999*                          GWL-RC,                                03380001
CVT999*                          CTR-COLUMN,                            03390001
CVT999*                          DB-HOST-TYPE,                          03400001
CVT999*                          WRKLEN1,                               03410001
CVT999*                          RS-PEAK-KW-UNITS,                      03420074
CVT999*                          DB-NULL-INDICATOR,                     03430001
CVT999*                          TDS-FALSE,                             03440001
CVT999*                          DB-CLIENT-TYPE,                        03450001
CVT999*                          WRKLEN1,                               03460001
CVT999*                          CNS-PEAK-KW,                           03470074
CVT999*                          WRKLEN2.                               03480001
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     03482063
                                                                        
CVT999*    MOVE ZERO TO WRKLEN2.                                        03490163
CVT999*    CALL 'TDSETBCD' USING GWL-PROC,                              03490263
CVT999*                          GWL-RC,                                03490363
CVT999*                          TDS-OBJECT-COL,                        03490463
CVT999*                          CTR-COLUMN,                            03490563
CVT999*                          WRKLEN1,                               03490663
CVT999*                          WRKLEN2.                               03490763
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     03500001
                                                                        
                                                                        
CVT999*    ADD  1                             TO CTR-COLUMN.            03502040
CVT999*    MOVE TDSDECIMAL                    TO DB-HOST-TYPE.          03503074
CVT999*    MOVE TDSFLT8                       TO DB-CLIENT-TYPE.        03504074
CVT999*    MOVE LENGTH OF RS-PEAK-KVA-UNITS   TO WRKLEN1.               03505074
CVT999*    MOVE LENGTH OF CNS-PEAK-KVA        TO WRKLEN2.               03506074
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              03508040
CVT999*                          GWL-RC,                                03509040
CVT999*                          CTR-COLUMN,                            03509140
CVT999*                          DB-HOST-TYPE,                          03509240
CVT999*                          WRKLEN1,                               03509340
CVT999*                          RS-PEAK-KVA-UNITS,                     03509474
CVT999*                          DB-NULL-INDICATOR,                     03509540
CVT999*                          TDS-FALSE,                             03509640
CVT999*                          DB-CLIENT-TYPE,                        03509740
CVT999*                          WRKLEN1,                               03509840
CVT999*                          CNS-PEAK-KVA,                          03509974
CVT999*                          WRKLEN2.                               03510040
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     03512440
                                                                        
CVT999*    ADD 1                               TO CTR-COLUMN.           03090040
CVT999*    MOVE TDSDECIMAL                     TO DB-HOST-TYPE.         03100040
CVT999*    MOVE TDSFLT8                        TO DB-CLIENT-TYPE.       03110040
CVT999*    MOVE LENGTH OF RS-PEAK-KVAR-UNITS   TO WRKLEN1.              03120074
CVT999*    MOVE LENGTH OF CNS-PEAK-KVAR        TO WRKLEN2.              03130074
T21643                                                                  
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              03150001
CVT999*                          GWL-RC,                                03160001
CVT999*                          CTR-COLUMN,                            03170001
CVT999*                          DB-HOST-TYPE,                          03180001
CVT999*                          WRKLEN1,                               03190001
CVT999*                          RS-PEAK-KVAR-UNITS,                    03200074
CVT999*                          DB-NULL-INDICATOR,                     03210001
CVT999*                          TDS-FALSE,                             03220001
CVT999*                          DB-CLIENT-TYPE,                        03230001
CVT999*                          WRKLEN1,                               03240001
CVT999*                          CNS-PEAK-KVAR,                         03250074
CVT999*                          WRKLEN2.                               03260040
T21643                                                                  
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     03280001
T21643                                                                  
CVT999*    MOVE +2 TO WRKLEN2.                                          03512674
CVT999*    CALL 'TDSETBCD' USING GWL-PROC,                              03512763
CVT999*                          GWL-RC,                                03512863
CVT999*                          TDS-OBJECT-COL,                        03512963
CVT999*                          CTR-COLUMN,                            03513063
CVT999*                          WRKLEN1,                               03513163
CVT999*                          WRKLEN2.                               03513263
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     03513463
                                                                        
                                                                        
CVT999*    ADD 1                               TO CTR-COLUMN.           03513840
CVT999*    MOVE TDSDECIMAL                     TO DB-HOST-TYPE.         03513940
CVT999*    MOVE TDSFLT8                        TO DB-CLIENT-TYPE.       03514040
CVT999*    MOVE LENGTH OF RS-PEAK-POWER-FCTR   TO WRKLEN1.              03514174
CVT999*    MOVE LENGTH OF CNS-PEAK-POWER-FCTR  TO WRKLEN2.              03514274
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              03514440
CVT999*                          GWL-RC,                                03514540
CVT999*                          CTR-COLUMN,                            03514640
CVT999*                          DB-HOST-TYPE,                          03514740
CVT999*                          WRKLEN1,                               03514840
CVT999*                          RS-PEAK-POWER-FCTR,                    03514974
CVT999*                          DB-NULL-INDICATOR,                     03515040
CVT999*                          TDS-FALSE,                             03515140
CVT999*                          DB-CLIENT-TYPE,                        03515240
CVT999*                          WRKLEN1,                               03515340
CVT999*                          CNS-PEAK-POWER-FCTR,                   03515474
CVT999*                          WRKLEN2.                               03515540
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     03515740
                                                                        
CVT999*    MOVE +2   TO WRKLEN2.                                        03515974
CVT999*    CALL 'TDSETBCD' USING GWL-PROC,                              03516063
CVT999*                          GWL-RC,                                03516163
CVT999*                          TDS-OBJECT-COL,                        03516263
CVT999*                          CTR-COLUMN,                            03516363
CVT999*                          WRKLEN1,                               03516463
CVT999*                          WRKLEN2.                               03516563
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     03516763
                                                                        
                                                                        
CVT999*    ADD  1                             TO CTR-COLUMN.            02872021
CVT999*    MOVE TDSCHAR                       TO DB-HOST-TYPE.          02880021
CVT999*    MOVE TDSCHAR                       TO DB-CLIENT-TYPE.        02890021
CVT999*    MOVE LENGTH OF RS-START-DATE       TO WRKLEN1.               02900074
CVT999*    MOVE LENGTH OF CNS-START-DATE      TO WRKLEN2.               02910074
T21643                                                                  
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              02930001
CVT999*                          GWL-RC,                                02940001
CVT999*                          CTR-COLUMN,                            02950001
CVT999*                          DB-HOST-TYPE,                          02960001
CVT999*                          WRKLEN1,                               02970001
CVT999*                          RS-START-DATE,                         02980074
CVT999*                          DB-NULL-INDICATOR,                     02990001
CVT999*                          TDS-FALSE,                             03000001
CVT999*                          DB-CLIENT-TYPE,                        03010001
CVT999*                          WRKLEN1,                               03516463
CVT999*                          CNS-START-DATE,                        03030074
CVT999*                          WRKLEN2.                               03516563
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     03516763
                                                                        
                                                                        
CVT999*    ADD 1                               TO CTR-COLUMN.           03538140
CVT999*    MOVE TDSCHAR                        TO DB-HOST-TYPE.         03538240
CVT999*    MOVE TDSCHAR                        TO DB-CLIENT-TYPE.       03538340
CVT999*    MOVE LENGTH OF RS-START-TIME        TO WRKLEN1.              03120074
CVT999*    MOVE LENGTH OF CNS-START-TIME       TO WRKLEN2.              03130074
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              03538740
CVT999*                          GWL-RC,                                03538840
CVT999*                          CTR-COLUMN,                            03538940
CVT999*                          DB-HOST-TYPE,                          03539040
CVT999*                          WRKLEN1,                               03539140
CVT999*                          RS-START-TIME,                         03200074
CVT999*                          DB-NULL-INDICATOR,                     03539340
CVT999*                          TDS-FALSE,                             03539440
CVT999*                          DB-CLIENT-TYPE,                        03539540
CVT999*                          WRKLEN1,                               03539640
CVT999*                          CNS-START-TIME,                        03250074
CVT999*                          WRKLEN2.                               03539840
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     03540040
                                                                        
                                                                        
REARCH*2100-EXIT.                                                       03565101
REARCH*    EXIT.                                                        03565201
                                                                        
      ******************************************************************03566001
      * 2200-BUILD-RESULT.                                             *03570008
T21643*      1. READ MV90 PEAK HISTORY INFORMATION                     *03571070
      *      2. DETERMINE POWER FACTORS.                               *03572070
      ******************************************************************03580001
       2200-BUILD-RESULT.                                               
                                                                        
T21643     MOVE '2200'                           TO ACTIVE-PARAGRAPH    
T21643*                                                                 02261273
T21643     MOVE 'E'                              TO PH-CODE-UTIL-TYPE.  
T21643     MOVE WS-ACCOUNT-NO-NUM                TO PH-ACCOUNT-NO.      
T21643     MOVE WS-IC-NO-NUM                     TO PH-IC-NO.           
T21643*                                                                 02261273
T21643     PERFORM 7000-OPEN-GET-PEAKS           THRU  7000-EXIT.       
T21643     PERFORM 7010-FETCH-GET-PEAKS          THRU  7010-EXIT        
T21643     PERFORM 2210-PROCESS-MV90-PEAKS       THRU 2210-EXIT         
T21643             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.             
T21643     PERFORM 7020-CLOSE-GET-PEAKS          THRU 7020-EXIT.        
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
T21643*****************************************************************         
T21643* THIS PARA MOVES ALL THE DETAILS FETCHED FROM THE CURSOR TO THE*         
T21643* RESPECTIVE RESULT SET VARIABLES                               *         
T21643*****************************************************************         
T21643 2210-PROCESS-MV90-PEAKS.                                         
                                                                        
T21643     MOVE '2210'                       TO ACTIVE-PARAGRAPH        
T21643     MOVE PH-METER-NO                  TO IV-METER-NO.            
T21643     MOVE PH-BILL-ITEM-TIMESTMP        TO IV-BILL-ITEM-TIMESTMP.  
CIG        MOVE PH-CODE-UTIL-TYPE            TO IV-CODE-UTIL-TYPE.      
                                                                        
PRJ899     MOVE BG-REV-MTH-ORIG-BILL         TO WS-REV-MTH-ORIG-BILL    
PRJ899     IF   WS-REV-MTH-ORIG-BILL > 0                                
PRJ899          MOVE BG-REV-MTH-ORIG-BILL    TO S-REVENUE-MONTH         
PRJ899     ELSE                                                         
PRJ899          MOVE BG-REVENUE-MONTH        TO S-REVENUE-MONTH         
PRJ899     END-IF.                                                      
                                                                        
T21643     PERFORM 7050-GET-START-DT-TM THRU 7050-EXIT.                 
T21643     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
T21643         IF  WS-START-DATE-NULL < 0                               
T21643             MOVE SPACES               TO WS-START-DATE           
T21643         END-IF                                                   
T21643         IF  WS-START-TIME-NULL < 0                               
T21643             MOVE SPACES               TO WS-START-TIME           
T21643         END-IF                                                   
T21643         MOVE WS-START-DATE            TO RS-START-DATE           
T21643         MOVE WS-START-TIME            TO RS-START-TIME           
           ELSE                                                         
T21643         MOVE SPACES                   TO RS-START-DATE           
T21643                                          RS-START-TIME           
           END-IF.                                                      
T21643     MOVE PH-PEAK-DATE                 TO RS-PEAK-DATE.           
T21643     MOVE PH-PEAK-TIME                 TO RS-PEAK-TIME.           
T21643     MOVE PH-METER-NO                  TO RS-METER-NO.            
T21643     MOVE PH-PEAK-TYPE                 TO RS-PEAK-TYPE.           
T21643     MOVE PH-PEAK-KW-UNITS             TO RS-PEAK-KW-UNITS        
T21643                                          WS-PEAK-KW-UNITS.       
T21643     MOVE PH-PEAK-KVA-UNITS            TO RS-PEAK-KVA-UNITS       
T21643                                          WS-PEAK-KVA-UNITS.      
T21643     MOVE PH-PEAK-KVAR-UNITS           TO RS-PEAK-KVAR-UNITS      
T21643                                          WS-PEAK-KVAR-UNITS.     
T21643     PERFORM 2220-DETERMINE-POWER-FACTOR  THRU 2220-EXIT.         
T21643     MOVE WS-PEAK-POWER-FCTR           TO RS-PEAK-POWER-FCTR.     
REARCH     PERFORM 2000A-MOVE-RESULT             THRU 2000A-EXIT.       
T21643     PERFORM 8100-SEND-RESULT              THRU 8100-EXIT.        
T21643     PERFORM 7010-FETCH-GET-PEAKS          THRU 7010-EXIT.        
T21643*                                                                         
T21643 2210-EXIT.                                                       
T21643     EXIT.                                                        
T21643*                                                                         
      ******************************************************************04100113
T21643* 2220-DETERMINE-POWER-FACTOR.                                   *04100270
      *     1. DETERMINE THE POWER FACTOR FOR EACH TYPE OF PEAK READ.  *04100370
      *        THE POWER FACTOR FORMULA IS:                            *04100470
      *            POWER FACTOR = ((KW/KVA) X 100 PERCENT).            *04100573
      *        IF EITHER KW OR KVA EQUALS ZERO, THE POWER FACTOR       *04100670
      *        DEFAULTS TO 85 PERCENT.                                 *04100770
      ******************************************************************04100813
T21643 2220-DETERMINE-POWER-FACTOR.                                     
                                                                        
T21643     IF ((WS-PEAK-KW-UNITS = 0) OR (WS-PEAK-KVA-UNITS = 0))       
             MOVE WS-DEFAULT-PWR-FCTR  TO WS-PEAK-POWER-FCTR            
           ELSE                                                         
T10864       COMPUTE WS-PEAK-POWER-FCTR =                               
T21643                     (WS-PEAK-KW-UNITS / WS-PEAK-KVA-UNITS)       
           END-IF.                                                      
                                                                        
T21643 2220-EXIT.                                                       
           EXIT.                                                        
                                                                        
T21643******************************************************************04400001
T21643*  OPENS THE CURSOR DECLARED FOR GETTING MV90 PEAKS              *04420001
T21643******************************************************************04450001
T21643 7000-OPEN-GET-PEAKS.                                             
T21643                                                                  
T21643     EXEC SQL                                                     
T21643         OPEN GET_PEAKS                                           
T21643     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21643*                                                                 04490001
T21643     MOVE SQLCODE                          TO                     
T21643                                            WS-ACTIVE-RETURN-CODE 
T21643                                            RS-RETURN-CODE.       
T21643*                                                                 04510001
T21643     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
T21643         NEXT SENTENCE                                            
T21643     ELSE                                                         
T21643         MOVE PROGRAM-NAME                 TO ABEND-PROGRAM       
T21643         MOVE '7000'                       TO ACTIVE-PARAGRAPH    
T21643         MOVE 'OPEN'                       TO ABEND-FUNCTION      
T21643         MOVE 'CSS_PEAK_HISTORY'           TO TABLE-1             
T21643         MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1     
T21643         MOVE 'CODE_UTIL_TYPE'             TO TABLE-ELEMENT-2     
T21643         MOVE 'IC_NO'                      TO TABLE-ELEMENT-3     
T21643         MOVE PH-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1   
T21643         MOVE PH-CODE-UTIL-TYPE            TO HOSTVAR-ELEMENT-2   
T21643         MOVE PH-IC-NO                     TO HOSTVAR-ELEMENT-3   
T21643*                                                                         
T21643         PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT         
T21643         PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT         
T21643     END-IF.                                                      
T21643                                                                  
T21643 7000-EXIT.                                                       
T21643     EXIT.                                                        
T21643*                                                                 04681001
T21643******************************************************************04710001
T21643*  FETCHES THE CURSOR DECLARED FOR GETTING THE PEAKS FROM CX     *04730001
T21643******************************************************************04770001
T21643 7010-FETCH-GET-PEAKS.                                            
T21643                                                                  
T21643     EXEC SQL                                                     
T21643         FETCH GET_PEAKS                                          
T21643         INTO   :PH-BILL-NO                                       
T21643               ,:PH-BILL-ITEM-TIMESTMP                            
T21643               ,:PH-MTR-REF-NO                                    
T21643               ,:PH-PEAK-TIME                                     
T21643               ,:PH-PEAK-DATE                                     
T21643               ,:PH-PEAK-KW-UNITS                                 
T21643               ,:PH-PEAK-KVA-UNITS                                
T21643               ,:PH-PEAK-KVAR-UNITS                               
T21643               ,:PH-METER-NO                                      
T21643               ,:PH-PEAK-TYPE                                     
PRJ899               ,:BG-REVENUE-MONTH                                 
PRJ899               ,:BG-REV-MTH-ORIG-BILL                             
T21643     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21643*                                                                 04990001
T21643     MOVE SQLCODE                          TO                     
T21643                                            WS-ACTIVE-RETURN-CODE 
T21643                                            RS-RETURN-CODE.       
T21643*                                                                 05010001
T21643     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
T21643         NEXT SENTENCE                                            
T21643     ELSE                                                         
T21643         MOVE PROGRAM-NAME                 TO ABEND-PROGRAM       
T21643         MOVE '7010'                       TO ACTIVE-PARAGRAPH    
T21643         MOVE 'FETCH'                      TO ABEND-FUNCTION      
T21643         MOVE 'CSS_PEAK_HISTORY'           TO TABLE-1             
T21643         MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1     
T21643         MOVE 'CODE_UTIL_TYPE'             TO TABLE-ELEMENT-2     
T21643         MOVE 'IC_NO'                      TO TABLE-ELEMENT-3     
T21643         MOVE PH-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1   
T21643         MOVE PH-CODE-UTIL-TYPE            TO HOSTVAR-ELEMENT-2   
T21643         MOVE PH-IC-NO                     TO HOSTVAR-ELEMENT-3   
T21643         PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT         
T21643         PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT
           END-IF.        
T21643                                                                  
T21643 7010-EXIT.                                                       
T21643     EXIT.                                                        
T21643*                                                                 05170001
T21643******************************************************************05190001
T21643*  CLOSES THE CURSOR DECLARED FOR GETTING THE PEAKS              *05210001
T21643******************************************************************05250001
T21643 7020-CLOSE-GET-PEAKS.                                            
T21643                                                                  
T21643     EXEC SQL                                                     
T21643         CLOSE GET_PEAKS                                          
T21643     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21643*                                                                 05290001
T21643     MOVE SQLCODE                          TO                     
T21643                                            WS-ACTIVE-RETURN-CODE 
T21643                                            RS-RETURN-CODE.       
T21643*                                                                 05310001
T21643     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
T21643         NEXT SENTENCE                                            
T21643     ELSE                                                         
T21643         MOVE PROGRAM-NAME                 TO ABEND-PROGRAM       
T21643         MOVE '7020'                       TO ACTIVE-PARAGRAPH    
T21643         MOVE 'CLOSE'                      TO ABEND-FUNCTION      
T21643         MOVE 'CSS_PEAK_HISTORY'           TO TABLE-1             
T21643         MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1     
T21643         MOVE 'CODE_UTIL_TYPE'             TO TABLE-ELEMENT-2     
T21643         MOVE 'IC_NO'                      TO TABLE-ELEMENT-3     
T21643         MOVE PH-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1   
T21643         MOVE PH-CODE-UTIL-TYPE            TO HOSTVAR-ELEMENT-2   
T21643         MOVE PH-IC-NO                     TO HOSTVAR-ELEMENT-3   
T21643         PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT         
T21643         PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT
           END-IF.        
T21643 7020-EXIT.                                                       
T21643     EXIT.                                                        
T21643*                                                                         
      ******************************************************************04090808
T21643*  SELECT TO GET START DATE & TIME                               *04091070
      ******************************************************************04091708
T21643 7050-GET-START-DT-TM.                                            
                                                                        
           EXEC SQL                                                     
T21643       SELECT MIN(DATE_READ)                                      
T21643             ,REPLACE(CONVERT(CHAR(8), MIN(TIME_READ), 108), ':', 
           '.')                                      
T21643         INTO :WS-START-DATE :WS-START-DATE-NULL                   
T21643             ,:WS-START-TIME :WS-START-TIME-NULL                   
T21643         FROM CSS_INTERVAL_READ                                   
T21643        WHERE METER_NO           = :IV-METER-NO                   
T21643          AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :IV-BILL-ITEM-TIMESTMP
              )         
CIG             AND CODE_UTIL_TYPE     = :IV-CODE-UTIL-TYPE             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     04092008
MFA-TR*      SELECT MIN(DATE_READ)                                              
MFA-TR*            ,MIN(TIME_READ)                                              
MFA-TR*        INTO :WS-START-DATE:WS-START-DATE-NULL                           
MFA-TR*            ,:WS-START-TIME:WS-START-TIME-NULL                           
MFA-TR*        FROM CSS_INTERVAL_READ                                   04093770
MFA-TR*       WHERE METER_NO           = :IV-METER-NO                   04093873
MFA-TR*         AND BILL_ITEM_TIMESTMP = :IV-BILL-ITEM-TIMESTMP         04094073
MFA-TR*         AND CODE_UTIL_TYPE     = :IV-CODE-UTIL-TYPE                     
MFA-TR*    END-EXEC.                                                    04096408

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
T21643     MOVE SQLCODE                          TO                     
T21643                                            WS-ACTIVE-RETURN-CODE 
T21643                                            RS-RETURN-CODE.       
                                                                        
T15521     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
T21643        MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
T21643        MOVE '7050'                  TO ACTIVE-PARAGRAPH          
T21643        MOVE 'SELECT'                TO ABEND-FUNCTION            
T21643        MOVE 'CSS_INTERVAL_READ'     TO TABLE-1                   
T21643        MOVE 'METER_NO'              TO TABLE-ELEMENT-1           
T21643        MOVE IV-METER-NO             TO HOSTVAR-ELEMENT-1         
T21643        MOVE 'BILL_ITEM_TIMESTMP'    TO TABLE-ELEMENT-2           
T21643        MOVE IV-BILL-ITEM-TIMESTMP   TO HOSTVAR-ELEMENT-2         
CIG           MOVE 'CODE_UTIL_TYPE'        TO TABLE-ELEMENT-3           
CIG           MOVE IV-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-3         
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
T21643 7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04136001
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     04140001
      ******************************************************************04150001
           EXEC SQL                                                     04160001
              INCLUDE CPDSP300                                          04170001
           END-EXEC.                                                    04180001
                                                                        
      ******************************************************************04200001
      *       END PROGRAM COPYLIB                                      *04210001
      ******************************************************************04220001
CVT999*    COPY CPD00302.                                               04230001
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000     EXEC SQL                                                     
CVT000       INSERT INTO #CSR02272_R1                            
CVT000       (                                                          
CVT000        RETURN_CODE                                               
CVT000       ,PEAK_DATE                                                 
CVT000       ,PEAK_TIME                                                 
CVT000       ,PEAK_TYPE                                                 
CVT000       ,METER_NO                                                  
CVT000       ,PEAK_KW_UNITS                                             
CVT000       ,PEAK_KVA_UNITS                                            
CVT000       ,PEAK_KVAR_UNITS                                           
CVT000       ,PEAK_POWER_FCTR                                           
CVT000       ,START_DATE                                                
CVT000       ,START_TIME                                                
PRJ899       ,REVENUE_MONTH                                             
CVT000       )                                                          
CVT000       VALUES                                                     
CVT000       (                                                          
REARCH        :S-RETURN-CODE                                            
REARCH       ,:S-PEAK-DATE                                              
REARCH       ,:S-PEAK-TIME                                              
REARCH       ,:S-PEAK-TYPE                                              
REARCH       ,:S-METER-NO                                               
REARCH       ,:S-PEAK-KW-UNITS                                          
REARCH       ,:S-PEAK-KVA-UNITS                                         
REARCH       ,:S-PEAK-KVAR-UNITS                                        
REARCH       ,:S-PEAK-POWER-FCTR                                        
REARCH       ,:S-START-DATE                                             
REARCH       ,:S-START-TIME                                             
PRJ899       ,:S-REVENUE-MONTH                                          
CVT000       )                                                          
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR02272_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,PEAK_DATE                                                         
MFA-TR*      ,PEAK_TIME                                                         
MFA-TR*      ,PEAK_TYPE                                                         
MFA-TR*      ,METER_NO                                                          
MFA-TR*      ,PEAK_KW_UNITS                                                     
MFA-TR*      ,PEAK_KVA_UNITS                                                    
MFA-TR*      ,PEAK_KVAR_UNITS                                                   
MFA-TR*      ,PEAK_POWER_FCTR                                                   
MFA-TR*      ,START_DATE                                                        
MFA-TR*      ,START_TIME                                                        
MFA-TR*      ,REVENUE_MONTH                                                     
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE                                                    
MFA-TR*      ,:S-PEAK-DATE                                                      
MFA-TR*      ,:S-PEAK-TIME                                                      
MFA-TR*      ,:S-PEAK-TYPE                                                      
MFA-TR*      ,:S-METER-NO                                                       
MFA-TR*      ,:S-PEAK-KW-UNITS                                                  
MFA-TR*      ,:S-PEAK-KVA-UNITS                                                 
MFA-TR*      ,:S-PEAK-KVAR-UNITS                                                
MFA-TR*      ,:S-PEAK-POWER-FCTR                                                
MFA-TR*      ,:S-START-DATE                                                     
MFA-TR*      ,:S-START-TIME                                                     
MFA-TR*      ,:S-REVENUE-MONTH                                                  
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
CVT000                                                                  
CVT000     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
CVT000        NEXT SENTENCE                                             
CVT000     ELSE                                                         
CVT000        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
REARCH        MOVE '8100'               TO ACTIVE-PARAGRAPH             
CVT000        MOVE 'INSERT'             TO ABEND-FUNCTION               
REARCH        MOVE 'CSR02272_R1'        TO TABLE-1                      
CVT000        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
CVT000     END-IF.                                                      
CVT000                                                                  
CVT000     ADD 1 TO CTR-ROWS.                                           
CVT000*    INITIALIZE GTT-RETURN-FIELDS.                                00001900
CVT000*                                                                 00002000
CVT000 8100-EXIT.                                                       
CVT000      EXIT.                                                       
CVT000******************************************************************00000100
CVT000* 8000A-DELETE-GTT-ROWS.                                         *00000200
CVT000******************************************************************00000300
CVT000 8000A-DELETE-GTT-ROWS.                                           
CVT000*                                                                 00000500
CVT000     MOVE                                                         
CVT000     'DELETE ROWS'                                                
CVT000         TO S-SQL-STATEMENT-V.                                    
CVT000*                                                                 00000900
CVT000      EXEC SQL                                                    
CVT000          DELETE FROM #CSR02272_R1                         
CVT000      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    00001000
MFA-TR*         DELETE FROM SESSION.CSR02272_R1                         00001100
MFA-TR*     END-EXEC.                                                   00001200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000*                                                                 00001300
CVT000      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
CVT000*                                                                 00001500
CVT000      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
CVT000          NEXT SENTENCE                                           
CVT000      ELSE                                                        
CVT000         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
CVT000         MOVE '8000A'              TO ACTIVE-PARAGRAPH            
CVT000         MOVE 'DELETE'             TO ABEND-FUNCTION              
CVT000         MOVE SPACES               TO ABEND-SQL-PREDICATES        
CVT000                                      ABEND-TABLES                
CVT000         MOVE 'CSR02272_R1'        TO TABLE-1                     
CVT000         MOVE SPACES               TO TABLE-ELEMENT-1             
CVT000         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
CVT000         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
CVT000     END-IF.                                                      
CVT000*                                                                 00003100
CVT000 8000A-EXIT.                                                      
CVT000     EXIT.                                                        
CVT000*                                                                 00003400
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00320                                         00000200
CVT000     END-EXEC.                                                    00000300
