       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02270.                                         
COB303 DATE-WRITTEN.  NOVEMBER 28, 1994                                 
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S270 CONVERTED TO DB2 SP CSR02270 ON 08/29/2005        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
      *                                                                *00110000
      *  TRANID:        S270                                           *00120000
      *  PROGRAM:       S270                                           *00130000
      *  CALLING SP:    PA_CREDHISTGET                                 *00140000
      *                                                                *00150000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *  THIS PROGRAM DOES THE FOLLOWING:                              *00190000
      *  1. RETRIEVES DATA FROM CSS_CREDIT_HIST AND CSS_DEP_REQUIREMNT.*00200000
      *                                                                *00210000
      ******************************************************************00220000
      *                                                                *00230000
      *                     PROGRAM MODIFICATION LOG                   *00240000
      *                                                                *00250000
      *    DATE    INITIALS   COMMENTS                                 *00260000
      *  --------  --------   ---------------------------------------  *00270000
      *  11/23/94    RTO      PROCEDURE ORIGINALLY CODED.              *00280000
      *                                                                *00290000
TP8514*  01/13/97    CHANDIRA RPC#269 IS MERGED WITH RPC#270.          *00291002
TP8514*                       PERFORMANCE TPR.8514                     *00292002
T15677*  03/30/98    FB       CHANGED TO HANDLE A NOT-FOUND CONDITION  *00292100
T15677*                       IN 7100-.  CLEANED UP ABEND DISPLAYS.    *00292200
CBSI  *  11/26/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *             MADRAS    ABEND PARAMETERS                         *        
T19245*  11/20/00    SFH      ADDED RS-ADDRESS-FL TO DETERMINE IF      *        
      *                       CUSTOMER HAS AN ACTIVE ACCOUNT.  IF      *        
      *                       CUSTOMER DOES HAVE AN ACTIVE ACCOUNT,    *        
      *                       THEN RESPONSE WINDOW (PANEL 159) WILL    *00293000
      *                       NOT POP-UP WHEN A CUSTOMER IS SCORED ON  *        
      *                       PANEL 59 (CREDIT BUREAU CHECK).          *        
      *                       ALSO ADDED RS-ADV-CREDIT-LTR-FL TO       *        
      *                       DISPLAY ON PANEL 59 TO SHOW THE STATUS OF*        
      *                       THE ADVERSE CREDIT LETTER.               *        
T23175*  03/26/01   SR82046   CHANGED TO RETRIEVE TRAN TIME FROM       *        
T23175*                       CSS_CREDIT_HIST TABLE AS A PART OF PSNC  *        
T23175*                       MERGER CHANGES                           *        
T23883*  06/03/02   LF19392   CHANGE COMMENTS TO 210 CHARACTERS        *        
C26943*  07/19/02   LF19392   SEB REGULATED CHANGES                    *        
C29586*  2004/10/29 DP19151   EQUIFAX CHANGES FOR PANEL 059.           *        
C29586*                       1. ADDED COLUMNS TO THE MAIN CURSOR.     *        
C29586*                       2. CHANGED THE CURSORS JOIN STATEMENT.   *        
C29586*                       3. ADDED CHECKS IN THE FETCH FOR NULLS.  *        
C29586*                       4. FIXED THE COLUMN NAMES IN THE RESULTS *        
C29586*                          SET, '_' INSTEAD OF '-'.              *        
C32212*  06/02/05   MJ13662   RETRIEVE CR-CHK-COMPANY-NO FROM          *        
C32212*                       CSS_CREDIT_HIST                          *        
C32212*                       AND SEND TO PANEL 59.                    *00293000
C32212*                       FOR SEB REGULATED, SEND 01R.             *        
REARCH*  09/01/05   CVNS      RPC TO COBOL DB2 SP CONVERSION.          *        
REARCH*             CHENNAI                                            *        
C32789*  10/05/05   MJ13662   DO NOT RETRIEVE ROWS W/ CR-RQST-REASON-CD*        
C32789*                       = 'B' (ACCOUNT REVIEW TYPE SCORES).      *        
C34788*  06/29/07   RICK      ADDED DRIVER LICENSE STATE TO THE OUTPUT *        
C34788*             BLACK     FILE AND INCREASED LICENSE NO TO 19 CHARS*        
C36013*  01/17/08   VV94890   1.ADDED NEW FIELDS TO THE RESULT SET FOR *        
C36013*                       NEW PANEL - CREDIT BUREAU                *        
C36013*                                   ADMINISTRATIVE PANEL         *        
C36013*                       2.INCREASED THE COMPANY LENGTH TO 6      *        
C36013*                         IN THE RESULT FIELD                    *        
C36013*                       3.CHANGED TO EFFECTIVE-DT & EXPIRATION-DT*00292100
C36013*                         INSTEAD OF MAX (EFFECTIVE-DT) IN 7500-.*        
C36013*                       4.ADDED NEW FIELD ACTION-MSG-TX FROM     *00292100
C36013*                         CSS_DEP_REQUIREMNT TABLE TO RESULT SET *        
C36013*                       5.ADDED DRIVER LICENSE AND DL STATE FROM *00292100
C36013*                         CSS_CREDIT_HIST CK TABLE TO RESULT SET *        
A01881*  11/18/09   RC41079   ADDED NEW FIELD RESP_SCRIPT_TXT TO RESULT*        
A01881*                       SET TO BE APPENDED TO THE RESPONSE_TXT   *        
A01881*                       BOX ON PANEL 59.  CHANGE TO RETRIEVE     *        
A01881*                       ACTION-MSG-TX AND RESP-SCRIPT-TXT FOR    *        
A01881*                       THOSE ACCOUNTS WITH WS-APPL-STATUS-CD =  *        
A01881*                       'C'.                                     *        
P00453*  09/09/10   MJ13662   ADDED NEW FIELD SPECIAL_OFFER_CD TO      *        
P00453*                       RESULT SET WHEN APPL-STATUS-CD = CONTINUE.        
P00453*                       IF SPECIAL-OFFER-CD = 'P' AND APPL-STATUS*        
P00453*                       CD = 'C' A) MOVE SPACES TO CRED-CD-DESC  *        
P00453*                       AND APPL-RESPONSE-TXT.                   *        
P00453*                       B) ONLY VERBIAGE FROM CSS_DEP_REQUIREMNT *        
P00453*                       WILL BE SENT IN RESULT SET.              *        
A03119*  02/15/12   MJ13662   IF CR-BUREAU-CD = 'P' (POSID) GET POSID  *        
A03119*                       RESULT AND RESPONSE CODES FROM           *        
A03119*                       CSS_CRED_BUR_MATRX FOR DISPLAY ON        *        
A03119*                       PANEL 59.  WEB/CRM CURRENTLY DO NOT      *        
A03119*                       REQUEST POSID INFORMATION.               *        
A03119*                       ALSO GET ACTION-MSG-TXT AND RESP-SCRIPT- *        
A03119*                       TXT FROM CSS_DEP_REQUIREMNT.             *        
A03119*                       FOR THIS FIRST PHASE, CREDIT CHECK REASON*        
A03119*                       WILL REMAIN AS 'D' (UTILITY) UNTIL ALL THE        
A03119*                       CHANGES CAN BE MADE W/ MODERNIZATION.    *        
P00704* 06/03/13    MJ13662   POSID MESSAGE SENT FROM EQUIFAX WILL     *        
P00704*                       RESIDE IN VENDOR-COMMENTS FIELD. APPEND  *        
P00704*                       VENDOR-COMMENTS IN FRONT OF COMMENTS SO  *        
P00704*                       IT WILL DISPLAY ON PANEL 59/53.          *        
P00704*                       CHANGED LENGTH OF VENDOR-COMMENTS TO 210.*        
P00704*                       REMOVED REFERENCE TO UNUSED COPYBOOK     *        
P00704*                       CWS00056.                                *        
P00773* 09/16/13    MJ13662   IF CREDIT CHECK REASON = 'R' (ACCOUNT    *        
P00773*                       REVIEW), SEND RESULT AND RESPONSE VERBIAGE        
P00773*                       FROM CSS_DEP_REQUIREMNT REGARDLESS OF    *        
P00773*                       APPLICATION STATUS.                      *        
A05198* 11/11/15    MJ13662   ON CALL TO CSS_DEP_REQUIREMNT, INCLUDE   *        
A05198*                       SCORE-MODEL-CD.                          *        
A05198*                       B = BEACON SCORE, A = AEP SCORE          *        
A05198*                       CHECK SCORE-MODEL-CD AND EITHER SEND     *        
A05198*                       BEACON SCORE OR AEP SCORE.               *        
      ******************************************************************00300000
      ******************************************************************00310000
      *                                                                *00320000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00330000
      *                                                                *00340000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00350000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00360000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00370000
      *  3000 - 4999  NOT USED                                         *00380000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00390000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00400000
      *  7000 - 7999  INPUT MODULES                                    *00410000
      *  8000 - 8999  OUTPUT MODULES                                   *00420000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00430000
      *                                                                *00440000
      ******************************************************************00450000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02270'.
MSQ017     COPY MFASQLM.
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02270 STARTS HERE'.                  
                                                                        
      ******************************************************************00540000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00550000
      ******************************************************************00560000
P00453***************************************************************** 00090004
P00453* CCA00001   C O M M O N   S Y S T E M   A R E A                *         
P00453***************************************************************** 00289904
           COPY CCA00001.                                               00600000
P00453******************************************************************CWS00010
P00453* CWS00027    E R R O R    W O R K    A R E A                    *CWS00020
P00453******************************************************************        
           COPY CWS00027.                                               00620000
P00453*****************************************************************         
P00453*  THIS COPYBOOK IS USED FOR DB2 AND CICS ERROR PROCESSING.     *         
P00453*****************************************************************         
           COPY CWS00303.                                               00640000
                                                                        
      ******************************************************************00660000
      *    WORK AREAS                                                  *00670000
      ******************************************************************00680000
                                                                        
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME             PIC X(08) VALUE 'CSR02270'.     
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  WS-ROW-COUNT             PIC 9(5)  VALUE 0.              
C36013     05  FIRST-ROW-SSN-SW         PIC X(01) VALUE 'Y'.            
C36013     05  WS-CUST-EST-SSN-MASK-FL  PIC X(01) VALUE 'Y'.            
C36013     05  WS-NULL-CUST-EST-DT      PIC S9(04)  COMP VALUE ZERO.    
C36013     05  WS-NULL-CR-HIST-TRAN-DT  PIC S9(04)  COMP VALUE ZERO.    
C36013     05  WS-NULL-CR-HIST-TRAN-TM  PIC S9(04)  COMP VALUE ZERO.    
C36013     05  WS-MASK-SSN-CUST-DAYS    PIC 9(09)   VALUE ZERO.         
C36013     05  WS-MASK-SSN-SCORE-HOURS  PIC 9(09)   VALUE ZERO.         
C36013     05  WS-CURRENT-HOUR          PIC 9(08)   VALUE ZERO.         
C36013     05  WS-CURRENT-DATE          PIC 9(08)   VALUE ZERO.         
C36013     05  WS-DATE.                                                 
C36013         10  WS-DATE-YYYY         PIC X(04).                      
C36013         10  WS-DATE-MM           PIC X(02).                      
C36013         10  WS-DATE-DD           PIC X(02).                      
C36013     05  WS-DATE-REDEFINE         REDEFINES WS-DATE               
C36013                                  PIC 9(08).                      
C36013     05  WS-DAYS                  PIC 9(09)   VALUE ZEROES.       
C36013     05  WS-HOURS                 PIC S9(09)  VALUE ZEROES.       
C36013     05  WS-DATABASE              PIC 9(01)   VALUE ZERO.         
C36013         88  CSR-DATABASE                     VALUE 1.            
C36013         88  SEB-DATABASE                     VALUE 2.            
C36013     05  WS-APPL-STATUS-CD        PIC X(01)   VALUE SPACE.        
P00704     05  WS-VENDOR-PLUS-COMMENTS  PIC X(210)  VALUE SPACES.       
                                                                        
       01  WS-LITERAL.                                                  
           05  WS-A                     PIC X(01) VALUE 'A'.            
           05  WS-B                     PIC X(01) VALUE 'B'.            
           05  WS-C                     PIC X(01) VALUE 'C'.            
           05  WS-G                     PIC X(01) VALUE 'G'.            
           05  WS-I                     PIC X(01) VALUE 'I'.            
           05  WS-M                     PIC X(01) VALUE 'M'.            
           05  WS-R                     PIC X(01) VALUE 'R'.            
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE       PIC S9(9) COMP.                 
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                   PIC S9(09) COMP.                
           05  PARM-CUSTOMER-NO         PIC  X(10).                     
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
           05  WS-NULL-INDICATOR1      PIC S9(4) COMP.                  
C29586     05  WS-NULL-INDICATOR2      PIC S9(4) COMP VALUE 0.          
C29586     05  WS-NULL-INDICATOR3      PIC S9(4) COMP VALUE 0.          
C29586     05  WS-NULL-INDICATOR4      PIC S9(4) COMP VALUE 0.          
C29586     05  WS-NULL-INDICATOR5      PIC S9(4) COMP VALUE 0.          
C29586     05  WS-NULL-INDICATOR6      PIC S9(4) COMP VALUE 0.          
C29586     05  WS-NULL-INDICATOR7      PIC S9(4) COMP VALUE 0.          
                                                                        
       01  WS-MISC.                                                     
           05  WS-CUSTOMER-NO          PIC S9(10).                      
COB305     05 WS-CUSTOMER-NO-NUM        PIC S9(10)V COMP-3 VALUE 0.             
           05  WS-ACCOUNT-NO           PIC S9(13) COMP.                 
           05  WS-ACCOUNT-CHAR         PIC X(13).                       
C36013     05  WS-BEACON-SCORE         PIC X(05).                       
C36013     05  WS-BEACON-SCORE-RED     REDEFINES WS-BEACON-SCORE        
C36013                                 PIC 9(05).                       
C36013     05  WS-BEACON-SCORE-NUM     PIC S9(9) USAGE COMP.            
C36013     05  WS-CURR-DATE            PIC X(10) VALUE SPACES.          
C36013*                                                                         
C29586**   THIS REFORMATS THE DATE FROM CCYY-MM-DD TO MM/DD/CCYY                
C29586     05  WS-LAST-UPDT-DT2.                                        
C29586       10  WS-LAST-UPDT-MM2       PIC X(02) VALUE SPACE.          
C29586       10  WS-LAST-UPDT-D12       PIC X(01) VALUE '/'.            
C29586       10  WS-LAST-UPDT-DY2       PIC X(02) VALUE SPACE.          
C29586       10  WS-LAST-UPDT-D12       PIC X(01) VALUE '/'.            
C29586       10  WS-LAST-UPDT-YR2       PIC X(04) VALUE SPACE.          
C29586     05  WS-LAST-UPDATE-TS.                                       
C29586       10  WS-LAST-UPDT-DT.                                       
C29586         15  WS-LAST-UPDT-YR       PIC X(04) VALUE SPACE.         
C29586         15  WS-LAST-UPDT-D1       PIC X(01) VALUE SPACE.         
C29586         15  WS-LAST-UPDT-MM       PIC X(02) VALUE SPACE.         
C29586         15  WS-LAST-UPDT-D2       PIC X(01) VALUE SPACE.         
C29586         15  WS-LAST-UPDT-DY       PIC X(02) VALUE SPACE.         
C29586       10  WS-LAST-UPDT-REST     PIC X(15) VALUE SPACE.           
C29586**   THIS REFORMATS THE DATE FROM CCYY-MM-DD TO MM/DD/CCYY                
C29586     05  WS-ADV-CRED-DT2.                                         
C29586       10  WS-ADV-CRED-MM2       PIC X(02) VALUE SPACE.           
C29586       10  WS-ADV-CRED-D12       PIC X(01) VALUE '/'.             
C29586       10  WS-ADV-CRED-DY2       PIC X(02) VALUE SPACE.           
C29586       10  WS-ADV-CRED-D12       PIC X(01) VALUE '/'.             
C29586       10  WS-ADV-CRED-YR2       PIC X(04) VALUE SPACE.           
C29586     05  WS-ADV-CRED-DT.                                          
C29586       10  WS-ADV-CRED-YR       PIC X(04) VALUE SPACE.            
C29586       10  WS-ADV-CRED-D1       PIC X(01) VALUE SPACE.            
C29586       10  WS-ADV-CRED-MM       PIC X(02) VALUE SPACE.            
C29586       10  WS-ADV-CRED-D2       PIC X(01) VALUE SPACE.            
C29586       10  WS-ADV-CRED-DY       PIC X(02) VALUE SPACE.            
C29586**   THIS REFORMATS THE DATE FROM CCYY-MM-DD TO MM/DD/CCYY                
C29586     05  WS-LTR-MAIL-DT2.                                         
C29586       10  WS-LTR-MAIL-MM2       PIC X(02) VALUE SPACE.           
C29586       10  WS-LTR-MAIL-D12       PIC X(01) VALUE '/'.             
C29586       10  WS-LTR-MAIL-DY2       PIC X(02) VALUE SPACE.           
C29586       10  WS-LTR-MAIL-D12       PIC X(01) VALUE '/'.             
C29586       10  WS-LTR-MAIL-YR2       PIC X(04) VALUE SPACE.           
C29586     05  WS-LTR-MAIL-DT.                                          
C29586       10  WS-LTR-MAIL-YR       PIC X(04) VALUE SPACE.            
C29586       10  WS-LTR-MAIL-D1       PIC X(01) VALUE SPACE.            
C29586       10  WS-LTR-MAIL-MM       PIC X(02) VALUE SPACE.            
C29586       10  WS-LTR-MAIL-D2       PIC X(01) VALUE SPACE.            
C29586       10  WS-LTR-MAIL-DY       PIC X(02) VALUE SPACE.            
C32212     05  WS-COMPANY.                                              
C32212       10  WS-COMP              PIC X(02) VALUE SPACE.            
C36013       10  WS-REG-GROUP-CD      PIC X(03) VALUE SPACE.            
C36013       10  WS-SENIOR-FL         PIC X(01) VALUE SPACE.            
C36013     05  WS-APPL-RESPONSE-TXT.                                    
C36013         49 WS-APPL-RESPONSE-TXT-LEN                              
C36013                                PIC S9(4) USAGE COMP.             
C36013         49 WS-APPL-RESPONSE-TXT-TEXT                             
C36013                                PIC X(600) VALUE SPACE.           
C36013*                                                                 01260000
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(09) COMP VALUE +0.       
           05  RS-CR-HIST-TRAN-DT       PIC X(10).                      
C23175     05  RS-CR-HIST-TRAN-TM       PIC X(08).                      
           05  RS-BEACON-SCORE          PIC X(5).                       
           05  RS-CR-BUREAU-CD          PIC X(1).                       
           05  RS-CR-ACTION-FL          PIC X(1).                       
P00704     05  RS-CR-COMMENTS           PIC X(210) VALUE SPACE.         
           05  RS-CR-RQST-REASON-CD     PIC X(1).                       
           05  RS-USER-ID-CR-INIT-BY    PIC X(7).                       
P00704     05  RS-VENDOR-COMMENTS       PIC X(210) VALUE SPACE.         
TP8514     05  RS-SSN                   PIC X(9)  VALUE SPACE.          
C36013     05  RS-SSN-MASK-FLAG         PIC X(1)  VALUE SPACES.         
T19245     05  RS-ACCOUNT-FL           PIC X(01) VALUE SPACE.           
T19245     05  RS-ADV-CREDIT-LTR-FL    PIC X(01) VALUE SPACE.           
C26943     05  RS-REG-GROUP-CD         PIC X(03) VALUE SPACE.           
C29586     05  RS-ITPA-EXISTS-CD        PIC X(01) VALUE SPACE.          
C29586     05  RS-ITPA-RSLT-CURR-CD     PIC X(01) VALUE SPACE.          
C29586     05  RS-LAST-UPDATE-USERID    PIC X(07) VALUE SPACE.          
C29586     05  RS-LAST-UPDATE-TS        PIC X(10) VALUE SPACE.          
C29586     05  RS-LETTER-NOTIFY-CD      PIC X(01) VALUE SPACE.          
C29586     05  RS-LETTER-MAILED-DT      PIC X(10) VALUE SPACE.          
C29586     05  RS-ADV-CREDIT-LTR-DT     PIC X(10) VALUE SPACE.          
C32212     05  RS-COMPANY-NO            PIC X(06) VALUE SPACE.          
C36013     05  RS-CR-SCORE-UPDATE-FL    PIC X(01) VALUE SPACE.          
C36013     05  RS-CRED-CD-DESC          PIC X(100) VALUE SPACE.         
C36013     05  RS-APPL-RESPONSE-TXT     PIC X(600) VALUE SPACE.         
C36013     05  RS-APPL-STATUS-CD        PIC X(01)  VALUE SPACE.         
C36013     05  RS-SENIOR-FL             PIC X(01)  VALUE SPACE.         
C36013     05  RS-SAFESCAN-TXT          PIC X(100) VALUE SPACE.         
C36013     05  RS-MATCH-TXT             PIC X(100) VALUE SPACE.         
C36013     05  RS-HIT-TXT               PIC X(100) VALUE SPACE.         
C36013     05  RS-REJECT-TXT            PIC X(100) VALUE SPACE.         
C36013     05  RS-ERROR-TXT             PIC X(100) VALUE SPACE.         
C36013     05  RS-ACTION-MSG-TX         PIC X(25)  VALUE SPACE.         
C36013     05  RS-LICENSE-NO            PIC X(19)  VALUE SPACE.         
C36013     05  RS-LICENSE-ST            PIC X(02)  VALUE SPACE.         
A01881     05  RS-RESP-SCRIPT-TXT       PIC X(250) VALUE SPACE.         
P00453     05  RS-SPECIAL-OFFER-CD      PIC X(01)  VALUE SPACE.         
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE           PIC S9(09) COMP VALUE +0.        
REARCH     05  S-CR-HIST-TRAN-DT       PIC X(10).                       
REARCH     05  S-CR-HIST-TRAN-TM       PIC X(08).                       
REARCH     05  S-BEACON-SCORE          PIC X(5).                        
REARCH     05  S-CR-BUREAU-CD          PIC X(1).                        
REARCH     05  S-CR-ACTION-FL          PIC X(1).                        
REARCH     05  S-CR-COMMENTS           PIC X(210).                      
REARCH     05  S-CR-RQST-REASON-CD     PIC X(1).                        
REARCH     05  S-USER-ID-CR-INIT-BY    PIC X(7).                        
P00704     05  S-VENDOR-COMMENTS       PIC X(210).                      
REARCH     05  S-SSN                   PIC X(9)  VALUE SPACE.           
C36013     05  S-SSN-MASK-FLAG         PIC X(1)  VALUE SPACES.          
REARCH     05  S-ACCOUNT-FL           PIC X(01) VALUE SPACE.            
REARCH     05  S-ADV-CREDIT-LTR-FL    PIC X(01) VALUE SPACE.            
REARCH     05  S-REG-GROUP-CD         PIC X(03) VALUE SPACE.            
REARCH     05  S-ITPA-EXISTS-CD        PIC X(01) VALUE SPACE.           
REARCH     05  S-ITPA-RSLT-CURR-CD     PIC X(01) VALUE SPACE.           
REARCH     05  S-LAST-UPDATE-USERID    PIC X(07) VALUE SPACE.           
REARCH     05  S-LAST-UPDATE-TS        PIC X(10) VALUE SPACE.           
REARCH     05  S-LETTER-NOTIFY-CD      PIC X(01) VALUE SPACE.           
REARCH     05  S-LETTER-MAILED-DT      PIC X(10) VALUE SPACE.           
REARCH     05  S-ADV-CREDIT-LTR-DT     PIC X(10) VALUE SPACE.           
REARCH     05  S-COMPANY-NO            PIC X(06) VALUE SPACE.           
C36013     05  S-CR-SCORE-UPDATE-FL    PIC X(01) VALUE SPACE.           
C36013     05  S-CRED-CD-DESC          PIC X(100) VALUE SPACE.          
C36013     05  S-APPL-RESPONSE-TXT     PIC X(600) VALUE SPACE.          
C36013     05  S-APPL-STATUS-CD        PIC X(01)  VALUE SPACE.          
C36013     05  S-SENIOR-FL             PIC X(01)  VALUE SPACE.          
C36013     05  S-SAFESCAN-TXT          PIC X(100) VALUE SPACE.          
C36013     05  S-MATCH-TXT             PIC X(100) VALUE SPACE.          
C36013     05  S-HIT-TXT               PIC X(100) VALUE SPACE.          
C36013     05  S-REJECT-TXT            PIC X(100) VALUE SPACE.          
C36013     05  S-ERROR-TXT             PIC X(100) VALUE SPACE.          
C36013     05  S-ACTION-MSG-TX         PIC X(25)  VALUE SPACE.          
C36013     05  S-LICENSE-NO            PIC X(19)  VALUE SPACE.          
C36013     05  S-LICENSE-ST            PIC X(02)  VALUE SPACE.          
A01881     05  S-RESP-SCRIPT-TXT       PIC X(250) VALUE SPACE.          
P00453     05  S-SPECIAL-OFFER-CD      PIC X(01)  VALUE SPACE.          
REARCH                                                                  
           EXEC SQL                                                     01650000
              INCLUDE SQLCA                                             01660000
           END-EXEC.                                                    01670000
                                                                        
P00453******************************************************************        
P00453* COBOL DECLARATION FOR TABLE CSS_CREDIT_HIST  CK           *             
P00453******************************************************************        
           EXEC SQL                                                     01730000
              INCLUDE TBCRHIST                                          01740000
           END-EXEC.                                                    01750000
                                                                        
P00453******************************************************************        
P00453* COBOL DECLARATION FOR TABLE CSS_ACCOUNT  AT               *             
P00453******************************************************************        
           EXEC SQL                                                     01770000
              INCLUDE TBACCT                                            01780000
           END-EXEC.                                                    01790000
                                                                        
P00453******************************************************************        
P00453* COBOL DECLARATION FOR TABLE CSS_CUST_STATS  CE            *             
P00453******************************************************************        
TP8514     EXEC SQL                                                     01810000
TP8514        INCLUDE TBCSTSTS                                          01820000
TP8514     END-EXEC.                                                    01830000
                                                                        
P00453******************************************************************        
P00453* COBOL DECLARATION FOR TABLE CSS_CUSTOMER  CU              *             
P00453******************************************************************        
TP8514     EXEC SQL                                                     01850000
TP8514        INCLUDE TBCUST                                            01860000
TP8514     END-EXEC.                                                    01870000
                                                                        
P00453******************************************************************        
P00453* COBOL DECLARATION FOR TABLE CSS_CRED_ITPA_HIST  LF        *             
P00453******************************************************************        
C29586     EXEC SQL                                                     01870200
C29586        INCLUDE TBCRITPA                                          01870300
C29586     END-EXEC.                                                    01870400
                                                                        
P00453******************************************************************        
P00453* COBOL DECLARATION FOR TABLE CSS_CRED_BUR_MATRX  DG        *             
P00453******************************************************************        
C36013     EXEC SQL                                                     01870200
C36013        INCLUDE TBCRBUMX                                          01870300
C36013     END-EXEC.                                                    01870400
C36013                                                                  
P00453******************************************************************        
P00453* COBOL DECLARATION FOR TABLE CSS_CRED_CODE_DESC  KL        *             
P00453******************************************************************        
C36013     EXEC SQL                                                     01870200
C36013        INCLUDE TBCREDCD                                          01870300
C36013     END-EXEC.                                                    01870400
C36013                                                                  
P00453******************************************************************        
P00453* COBOL DECLARATION FOR TABLE CSS_APPL_RESPONSE  KE         *             
P00453******************************************************************        
C36013     EXEC SQL                                                     01870200
C36013        INCLUDE TBAPSRES                                          01870300
C36013     END-EXEC.                                                    01870400
C36013                                                                  
P00453******************************************************************        
P00453* COBOL DECLARATION FOR TABLE CSS_DELINQUENCY  C8           *             
P00453******************************************************************        
C36013     EXEC SQL                                                     02320800
C36013        INCLUDE TBDELQ                                            02320900
C36013     END-EXEC.                                                    02321000
P00453******************************************************************        
P00453* COBOL DECLARATION FOR TABLE CSS_CRED_BUR_TXT  KG          *             
P00453******************************************************************        
C36013     EXEC SQL                                                     02320800
C36013        INCLUDE TBCBUTXT                                          02320900
C36013     END-EXEC.                                                    02321000
C36013*                                                                 01870500
P00453******************************************************************        
P00453* COBOL DECLARATION FOR TABLE CSS_DEP_REQUIREMNT D6         *             
P00453******************************************************************        
C36013     EXEC SQL                                                     02320800
C36013        INCLUDE TBDEPRQ                                           02320900
C36013     END-EXEC.                                                    02321000
C36013*                                                                 02321000
      ***********************************************************       01870700
      *** CREDIT-HIST CURSOR: FETCH ALL ROWS IN THE    ***              01870800
      *** CSS_CREDIT_HIST TABLE FOR THE SPECIFIED CUSTOMER    ***       01870900
      ***********************************************************       01871000
C29586*  IT IS NOT MENTIONED BELOW, BUT I ADDED A AND B ALIASES FOR     01871000
C29586*    ALL THE COLUMNS IN THE CURSOR.                               01871000
                                                                        
           EXEC SQL                                                     
             DECLARE CREDIT-HIST CURSOR FOR                             
             SELECT CIS.CHAR2$DATE(A.CR_HIST_TRAN_DT,'USA'),                  
                    A.BEACON_SCORE,                                     
                    A.CR_BUREAU_CD,                                     
                    A.CR_ACTION_FL,                                     
                    A.CR_COMMENTS,                                      
                    A.CR_RQST_REASON_CD,                                
                    A.USER_ID_CR_INIT_BY,                               
                    A.VENDOR_COMMENTS,                                  
T19245              A.ADV_CREDIT_LTR,                                   
C23175              REPLACE(CONVERT(CHAR(8), A.CR_HIST_TRAN_TM, 108), 
           ':', '.') CR_HIST_TRAN_TM,                                  
C26943              A.REG_GROUP_CD,                                     
C29586              A.ITPA_EXISTS_CD,                                   
C32212              A.CR_CHK_COMPANY_NO,                                
C29586              B.ITPA_RSLT_CURR_CD,                                
C29586              B.LAST_UPDATE_USERID,                               
C29586              REPLACE(REPLACE(CONVERT(CHAR(26), B.LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,                        
C29586              B.LETTER_NOTIFY_CD,                                 
C29586              B.LETTER_MAILED_DT,                                 
T19245              A.ADV_CREDIT_LTR_DT,                                
C36013              A.APPL_STATUS_CD,                                   
C36013              A.CB_SAFESCAN_CD,                                   
C36013              A.CB_MATCH_CD,                                      
C36013              A.CB_HIT_CD,                                        
C36013              A.CB_BEACON_REJ_CD,                                 
C36013              A.CB_FORMAT_ERR_CD,                                 
C36013              A.CB_PROCESS_ERR_CD,                                
C36013              A.CB_VALIDITY_ERR_CD,                               
C36013              A.CR_SCORE_UPDATE_FL,                               
C36013              A.SSN,                                              
C36013              A.CR_SCORE_TYPE_CD,                                 
C36013              A.CR_SCORE_CD,                                      
C36013              A.SENIOR_FL,                                        
C36013              A.DRIVERS_LICENSE_NO,                               
P00453              A.DRIVERS_LIC_ST_CD,                                
A05198              A.SPECIAL_OFFER_CD,                                 
A05198              A.SCORE_MODEL_CD,                                   
A05198              A.ADDL_CRED_SCORE                                   
C29586       FROM CSS_CREDIT_HIST A
                           WITH(READUNCOMMITTED) LEFT OUTER JOIN               
C29586            CSS_CRED_ITPA_HIST B WITH(READUNCOMMITTED) ON                 
C29586            B.CUSTOMER_NO = A.CUSTOMER_NO                         
C29586        AND B.CR_HIST_TRAN_DT = A.CR_HIST_TRAN_DT                 
C29586        AND B.CR_HIST_TRAN_TM = A.CR_HIST_TRAN_TM                 
             WHERE A.CUSTOMER_NO = :CK-CUSTOMER-NO AND                  
C32789             A.CR_RQST_REASON_CD <> :WS-B                         
T23175       ORDER BY A.CR_HIST_TRAN_DT DESC,                           
T23175                CR_HIST_TRAN_TM DESC                            
P00453       FOR READ ONLY                                      
P00453                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     01873000
MFA-TR*      DECLARE CREDIT-HIST CURSOR FOR                             01874000
MFA-TR*      SELECT CHAR(DATE(A.CR_HIST_TRAN_DT),USA),                  01875000
MFA-TR*             A.BEACON_SCORE,                                     01876000
MFA-TR*             A.CR_BUREAU_CD,                                     01877000
MFA-TR*             A.CR_ACTION_FL,                                     01878000
MFA-TR*             A.CR_COMMENTS,                                      01879000
MFA-TR*             A.CR_RQST_REASON_CD,                                01880000
MFA-TR*             A.USER_ID_CR_INIT_BY,                               01890000
MFA-TR*             A.VENDOR_COMMENTS,                                  01900000
MFA-TR*             A.ADV_CREDIT_LTR,                                           
MFA-TR*             A.CR_HIST_TRAN_TM,                                  01900000
MFA-TR*             A.REG_GROUP_CD,                                     01900000
MFA-TR*             A.ITPA_EXISTS_CD,                                   01900000
MFA-TR*             A.CR_CHK_COMPANY_NO,                                        
MFA-TR*             B.ITPA_RSLT_CURR_CD,                                        
MFA-TR*             B.LAST_UPDATE_USERID,                                       
MFA-TR*             B.LAST_UPDATE_TS,                                           
MFA-TR*             B.LETTER_NOTIFY_CD,                                         
MFA-TR*             B.LETTER_MAILED_DT,                                         
MFA-TR*             A.ADV_CREDIT_LTR_DT,                                        
MFA-TR*             A.APPL_STATUS_CD,                                           
MFA-TR*             A.CB_SAFESCAN_CD,                                           
MFA-TR*             A.CB_MATCH_CD,                                              
MFA-TR*             A.CB_HIT_CD,                                                
MFA-TR*             A.CB_BEACON_REJ_CD,                                         
MFA-TR*             A.CB_FORMAT_ERR_CD,                                         
MFA-TR*             A.CB_PROCESS_ERR_CD,                                        
MFA-TR*             A.CB_VALIDITY_ERR_CD,                                       
MFA-TR*             A.CR_SCORE_UPDATE_FL,                                       
MFA-TR*             A.SSN,                                                      
MFA-TR*             A.CR_SCORE_TYPE_CD,                                         
MFA-TR*             A.CR_SCORE_CD,                                              
MFA-TR*             A.SENIOR_FL,                                                
MFA-TR*             A.DRIVERS_LICENSE_NO,                                       
MFA-TR*             A.DRIVERS_LIC_ST_CD,                                        
MFA-TR*             A.SPECIAL_OFFER_CD,                                         
MFA-TR*             A.SCORE_MODEL_CD,                                           
MFA-TR*             A.ADDL_CRED_SCORE                                           
MFA-TR*      FROM CSS_CREDIT_HIST A LEFT OUTER JOIN                     01910000
MFA-TR*           CSS_CRED_ITPA_HIST B ON                               01910000
MFA-TR*           B.CUSTOMER_NO = A.CUSTOMER_NO                                 
MFA-TR*       AND B.CR_HIST_TRAN_DT = A.CR_HIST_TRAN_DT                         
MFA-TR*       AND B.CR_HIST_TRAN_TM = A.CR_HIST_TRAN_TM                         
MFA-TR*      WHERE A.CUSTOMER_NO = :CK-CUSTOMER-NO AND                  01920000
MFA-TR*            A.CR_RQST_REASON_CD <> :WS-B                                 
MFA-TR*      ORDER BY A.CR_HIST_TRAN_DT DESC,                                   
MFA-TR*               A.CR_HIST_TRAN_TM DESC                                    
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                    01930000
HPCCDM*EJECT                                                            01940000
P00453***************************************************************** 00010000
P00453*  CWSX0010            WS ABEND WORK AREA                       * 00020000
P00453***************************************************************** 00080000
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         DECLARE C1 CURSOR  FOR                        
CVT000         SELECT                                                   
REARCH            RETURN_CODE                                           
REARCH           ,LTRIM(RTRIM(CR_HIST_TRAN_DT))     AS CR_HIST_TRAN_DT         
REARCH           ,LTRIM(RTRIM(CR_HIST_TRAN_TM))     AS CR_HIST_TRAN_TM         
REARCH           ,LTRIM(RTRIM(BEACON_SCORE))        AS BEACON_SCORE            
REARCH           ,LTRIM(RTRIM(CR_BUREAU_CD))        AS CR_BUREAU_CD            
REARCH           ,LTRIM(RTRIM(CR_ACTION_FL))        AS CR_ACTION_FL            
REARCH           ,LTRIM(RTRIM(CR_COMMENTS))         AS CR_COMMENTS             
REARCH           ,LTRIM(RTRIM(CR_RQST_REASON_CD))   AS CR_RQST_REASON_CD       
REARCH           ,LTRIM(RTRIM(USER_ID_CR_INIT_BY))  AS 
           USER_ID_CR_INIT_BY      
REARCH           ,LTRIM(RTRIM(VENDOR_COMMENTS))     AS VENDOR_COMMENTS         
REARCH           ,LTRIM(RTRIM(SSN))                 AS SSN                     
C36013           ,LTRIM(RTRIM(SSN_MASK_FLAG))       AS SSN_MASK_FLAG           
REARCH           ,LTRIM(RTRIM(ACCOUNT_FL))          AS ACCOUNT_FL              
REARCH           ,LTRIM(RTRIM(ADV_CREDIT_LTR_FL))   AS ADV_CREDIT_LTR_FL       
REARCH           ,LTRIM(RTRIM(REG_GROUP_CD))        AS REG_GROUP_CD            
REARCH           ,LTRIM(RTRIM(ITPA_EXISTS_CD))      AS ITPA_EXISTS_CD          
REARCH           ,LTRIM(RTRIM(ITPA_RSLT_CURR_CD))   AS ITPA_RSLT_CURR_CD       
REARCH           ,LTRIM(RTRIM(LAST_UPDATE_USERID))  AS 
           LAST_UPDATE_USERID      
REARCH           ,LTRIM(RTRIM(LAST_UPDATE_TS))      AS LAST_UPDATE_TS          
REARCH           ,LTRIM(RTRIM(LETTER_NOTIFY_CD))    AS LETTER_NOTIFY_CD        
REARCH           ,LTRIM(RTRIM(LETTER_MAILED_DT))    AS LETTER_MAILED_DT        
REARCH           ,LTRIM(RTRIM(ADV_CREDIT_LTR_DT))   AS ADV_CREDIT_LTR_DT       
REARCH           ,LTRIM(RTRIM(COMPANY_NO))          AS COMPANY_NO              
C36013           ,LTRIM(RTRIM(CR_SCORE_UPDATE_FL))  AS 
           CR_SCORE_UPDATE_FL      
C36013           ,LTRIM(RTRIM(CRED_CD_DESC))        AS CRED_CD_DESC            
C36013           ,LTRIM(RTRIM(APPL_RESPONSE_TXT))   AS APPL_RESPONSE_TXT       
C36013           ,LTRIM(RTRIM(APPL_STATUS_CD))      AS APPL_STATUS_CD          
C36013           ,LTRIM(RTRIM(SENIOR_FL))           AS SENIOR_FL               
C36013           ,LTRIM(RTRIM(SAFESCAN_TXT))        AS SAFESCAN_TXT            
C36013           ,LTRIM(RTRIM(MATCH_TXT))           AS MATCH_TXT               
C36013           ,LTRIM(RTRIM(HIT_TXT))             AS HIT_TXT                 
C36013           ,LTRIM(RTRIM(REJECT_TXT))          AS REJECT_TXT              
C36013           ,LTRIM(RTRIM(ERROR_TXT))           AS ERROR_TXT               
C36013           ,LTRIM(RTRIM(ACTION_MSG_TX))       AS ACTION_MSG_TX           
C36013           ,LTRIM(RTRIM(LICENSE_NO))          AS LICENSE_NO              
C36013           ,LTRIM(RTRIM(LICENSE_ST))          AS LICENSE_ST              
A01881           ,LTRIM(RTRIM(RESP_SCRIPT_TXT))     AS RESP_SCRIPT_TXT         
P00453           ,LTRIM(RTRIM(SPECIAL_OFFER_CD))    AS SPECIAL_OFFER_CD        
CVT000         FROM #CSR02270_R1                                 
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00000100
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        00000300
MFA-TR*        SELECT                                                   00000400
MFA-TR*           RETURN_CODE                                                   
MFA-TR*          ,STRIP(CR_HIST_TRAN_DT)     AS CR_HIST_TRAN_DT                 
MFA-TR*          ,STRIP(CR_HIST_TRAN_TM)     AS CR_HIST_TRAN_TM                 
MFA-TR*          ,STRIP(BEACON_SCORE)        AS BEACON_SCORE                    
MFA-TR*          ,STRIP(CR_BUREAU_CD)        AS CR_BUREAU_CD                    
MFA-TR*          ,STRIP(CR_ACTION_FL)        AS CR_ACTION_FL                    
MFA-TR*          ,STRIP(CR_COMMENTS)         AS CR_COMMENTS                     
MFA-TR*          ,STRIP(CR_RQST_REASON_CD)   AS CR_RQST_REASON_CD               
MFA-TR*          ,STRIP(USER_ID_CR_INIT_BY)  AS USER_ID_CR_INIT_BY              
MFA-TR*          ,STRIP(VENDOR_COMMENTS)     AS VENDOR_COMMENTS                 
MFA-TR*          ,STRIP(SSN)                 AS SSN                             
MFA-TR*          ,STRIP(SSN_MASK_FLAG)       AS SSN_MASK_FLAG                   
MFA-TR*          ,STRIP(ACCOUNT_FL)          AS ACCOUNT_FL                      
MFA-TR*          ,STRIP(ADV_CREDIT_LTR_FL)   AS ADV_CREDIT_LTR_FL               
MFA-TR*          ,STRIP(REG_GROUP_CD)        AS REG_GROUP_CD                    
MFA-TR*          ,STRIP(ITPA_EXISTS_CD)      AS ITPA_EXISTS_CD                  
MFA-TR*          ,STRIP(ITPA_RSLT_CURR_CD)   AS ITPA_RSLT_CURR_CD               
MFA-TR*          ,STRIP(LAST_UPDATE_USERID)  AS LAST_UPDATE_USERID              
MFA-TR*          ,STRIP(LAST_UPDATE_TS)      AS LAST_UPDATE_TS                  
MFA-TR*          ,STRIP(LETTER_NOTIFY_CD)    AS LETTER_NOTIFY_CD                
MFA-TR*          ,STRIP(LETTER_MAILED_DT)    AS LETTER_MAILED_DT                
MFA-TR*          ,STRIP(ADV_CREDIT_LTR_DT)   AS ADV_CREDIT_LTR_DT               
MFA-TR*          ,STRIP(COMPANY_NO)          AS COMPANY_NO                      
MFA-TR*          ,STRIP(CR_SCORE_UPDATE_FL)  AS CR_SCORE_UPDATE_FL              
MFA-TR*          ,STRIP(CRED_CD_DESC)        AS CRED_CD_DESC                    
MFA-TR*          ,STRIP(APPL_RESPONSE_TXT)   AS APPL_RESPONSE_TXT               
MFA-TR*          ,STRIP(APPL_STATUS_CD)      AS APPL_STATUS_CD                  
MFA-TR*          ,STRIP(SENIOR_FL)           AS SENIOR_FL                       
MFA-TR*          ,STRIP(SAFESCAN_TXT)        AS SAFESCAN_TXT                    
MFA-TR*          ,STRIP(MATCH_TXT)           AS MATCH_TXT                       
MFA-TR*          ,STRIP(HIT_TXT)             AS HIT_TXT                         
MFA-TR*          ,STRIP(REJECT_TXT)          AS REJECT_TXT                      
MFA-TR*          ,STRIP(ERROR_TXT)           AS ERROR_TXT                       
MFA-TR*          ,STRIP(ACTION_MSG_TX)       AS ACTION_MSG_TX                   
MFA-TR*          ,STRIP(LICENSE_NO)          AS LICENSE_NO                      
MFA-TR*          ,STRIP(LICENSE_ST)          AS LICENSE_ST                      
MFA-TR*          ,STRIP(RESP_SCRIPT_TXT)     AS RESP_SCRIPT_TXT                 
MFA-TR*          ,STRIP(SPECIAL_OFFER_CD)    AS SPECIAL_OFFER_CD                
MFA-TR*        FROM SESSION.CSR02270_R1                                 00000500
MFA-TR*    END-EXEC.                                                    00000700
CVT000                                                                  
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-CUSTOMER-NO         PIC  X(10)               .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-CUSTOMER-NO                                        
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
      ******************************************************************01970000
      * 0000-MAINLINE                                                  *01980000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *01990000
      ******************************************************************02000000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02110000
      * 0100-INITIALIZE                                                *02120000
      *                                                                *02130000
      *     1. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *02140000
      *     2. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *02150000
      *     3. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*02160000
      *                                                                *02170000
      ******************************************************************02180000
                                                                        
       0100-INITIALIZE.                                                 
           MOVE '0100' TO ACTIVE-PARAGRAPH.                             
CVT000     MOVE LINK-CUSTOMER-NO          TO PARM-CUSTOMER-NO         . 
C36013*                                                                 03871100
C36013     INITIALIZE                        C8-DELINQ-VALUE.           
C36013     MOVE 'MASK-SSN-CUST-DAYS'      TO C8-DELINQ-CD.              
C36013     PERFORM 7450-GET-DELINQUENCY-VALUE THRU 7450-EXIT.           
C36013     MOVE C8-DELINQ-VALUE           TO WS-MASK-SSN-CUST-DAYS.     
C36013*                                                                 03871100
C36013     INITIALIZE                        C8-DELINQ-VALUE.           
C36013     MOVE 'MASK-SSN-SCORE-HOURS'    TO C8-DELINQ-CD.              
C36013     PERFORM 7450-GET-DELINQUENCY-VALUE THRU 7450-EXIT.           
C36013     MOVE C8-DELINQ-VALUE           TO WS-MASK-SSN-SCORE-HOURS.   
C36013*                                                                 03871100
C36013     INITIALIZE                        C8-DELINQ-VALUE.           
C36013     MOVE 'DATABASE'                TO C8-DELINQ-CD.              
C36013     PERFORM 7450-GET-DELINQUENCY-VALUE THRU 7450-EXIT.           
C36013     MOVE C8-DELINQ-VALUE           TO WS-DATABASE.               
C36013*                                                                 03871100
CVT000     PERFORM 0100A-DECLARE-GTT                                    
CVT000       THRU 0100A-EXIT.                                           
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
CVT000 0100A-DECLARE-GTT.                                               
CVT000     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02270_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02270_R1
              (                                                          
CVT000         RETURN_CODE              INT                         
CVT000        ,CR_HIST_TRAN_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
CVT000        ,CR_HIST_TRAN_TM CHAR(08)  COLLATE LATIN1_GENERAL_100_BIN2        
CVT000        ,BEACON_SCORE CHAR(5)  COLLATE LATIN1_GENERAL_100_BIN2            
CVT000        ,CR_BUREAU_CD CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2            
CVT000        ,CR_ACTION_FL CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2            
CVT000        ,CR_COMMENTS CHAR(210)  COLLATE LATIN1_GENERAL_100_BIN2           
CVT000        ,CR_RQST_REASON_CD CHAR(1)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                         
CVT000        ,USER_ID_CR_INIT_BY CHAR(7)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                         
P00704        ,VENDOR_COMMENTS CHAR(210)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                       
CVT000        ,SSN CHAR(9)  COLLATE LATIN1_GENERAL_100_BIN2                     
C36013        ,SSN_MASK_FLAG CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2           
CVT000        ,ACCOUNT_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2             
CVT000        ,ADV_CREDIT_LTR_FL CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,REG_GROUP_CD CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2           
CVT000        ,ITPA_EXISTS_CD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
CVT000        ,ITPA_RSLT_CURR_CD CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,LAST_UPDATE_USERID CHAR(07)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,LAST_UPDATE_TS CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
CVT000        ,LETTER_NOTIFY_CD CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,LETTER_MAILED_DT CHAR(10)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,ADV_CREDIT_LTR_DT CHAR(10)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,COMPANY_NO CHAR(06)  COLLATE LATIN1_GENERAL_100_BIN2             
C36013        ,CR_SCORE_UPDATE_FL CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
C36013        ,CRED_CD_DESC CHAR(100)  COLLATE LATIN1_GENERAL_100_BIN2          
C36013        ,APPL_RESPONSE_TXT VARCHAR(600)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                    
C36013        ,APPL_STATUS_CD VARCHAR(1)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                      
C36013        ,SENIOR_FL CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2               
C36013        ,SAFESCAN_TXT CHAR(100)  COLLATE LATIN1_GENERAL_100_BIN2          
C36013        ,MATCH_TXT CHAR(100)  COLLATE LATIN1_GENERAL_100_BIN2             
C36013        ,HIT_TXT CHAR(100)  COLLATE LATIN1_GENERAL_100_BIN2               
C36013        ,REJECT_TXT CHAR(100)  COLLATE LATIN1_GENERAL_100_BIN2            
C36013        ,ERROR_TXT CHAR(100)  COLLATE LATIN1_GENERAL_100_BIN2             
C36013        ,ACTION_MSG_TX CHAR(25)  COLLATE LATIN1_GENERAL_100_BIN2          
C36013        ,LICENSE_NO CHAR(19)  COLLATE LATIN1_GENERAL_100_BIN2             
C36013        ,LICENSE_ST CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2             
A01881        ,RESP_SCRIPT_TXT CHAR(250)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                       
P00453        ,SPECIAL_OFFER_CD CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2        
CVT000       )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR02270_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
CVT000 0100A-EXIT.                                                      
CVT000         EXIT.                                                    
                                                                        
      ******************************************************************02430000
      * 1000-PROCESS-INPUT.                                            *02440000
      *                                                                *02450000
      *     1. RECEIVE PARMS.                                          *02460000
      *                                                                *02470000
      ******************************************************************02480000
                                                                        
       1000-PROCESS-INPUT.                                              
TP8514     MOVE PARM-CUSTOMER-NO   TO WS-CUSTOMER-NO.                   
TP8514     MOVE WS-CUSTOMER-NO     TO WS-CUSTOMER-NO-NUM.               
TP8514     MOVE WS-CUSTOMER-NO-NUM TO CK-CUSTOMER-NO.                   
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02790000
      * 2000-PROCESS-OUTPUT.                                           *02800000
      *                                                                *02810000
      *     1. DESCRIBE RESULT SET                                     *02820000
      *     2. UPDATE DB2 DATA                                         *02830000
      *     3. BUILD RESULT SET                                        *02840000
      *     4. SEND RESULT SET                                         *02850000
      *                                                                *02860000
      ******************************************************************02870000
                                                                        
       2000-PROCESS-OUTPUT.                                             
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 2200-PROCESS-FETCH   THRU 2200-EXIT.                 
           MOVE 1      TO RS-RETURN-CODE.                               
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************16245000
REARCH*2000A-MOVE-RESULT.                                                       
REARCH******************************************************************16245000
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE RS-RETURN-CODE        TO S-RETURN-CODE.                 
REARCH     MOVE RS-CR-HIST-TRAN-DT    TO S-CR-HIST-TRAN-DT.             
REARCH     MOVE RS-CR-HIST-TRAN-TM    TO S-CR-HIST-TRAN-TM.             
REARCH     MOVE RS-BEACON-SCORE       TO S-BEACON-SCORE.                
REARCH     MOVE RS-CR-BUREAU-CD       TO S-CR-BUREAU-CD.                
REARCH     MOVE RS-CR-ACTION-FL       TO S-CR-ACTION-FL.                
P00704     IF RS-VENDOR-COMMENTS > SPACES                               
P00704        STRING RS-VENDOR-COMMENTS  DELIMITED BY '  '              
P00704               ' '                 DELIMITED BY SIZE              
P00704               RS-CR-COMMENTS      DELIMITED BY '  '              
P00704        INTO WS-VENDOR-PLUS-COMMENTS                              
P00704        MOVE WS-VENDOR-PLUS-COMMENTS TO S-CR-COMMENTS             
P00704        MOVE SPACES             TO WS-VENDOR-PLUS-COMMENTS        
P00704     ELSE                                                         
P00704        MOVE RS-CR-COMMENTS     TO S-CR-COMMENTS                  
P00704     END-IF.                                                      
REARCH     MOVE RS-CR-RQST-REASON-CD  TO S-CR-RQST-REASON-CD.           
REARCH     MOVE RS-USER-ID-CR-INIT-BY TO S-USER-ID-CR-INIT-BY.          
REARCH     MOVE RS-VENDOR-COMMENTS    TO S-VENDOR-COMMENTS.             
REARCH     MOVE RS-SSN                TO S-SSN.                         
C36013     MOVE RS-SSN-MASK-FLAG      TO S-SSN-MASK-FLAG.               
REARCH     MOVE RS-ACCOUNT-FL         TO S-ACCOUNT-FL.                  
REARCH     MOVE RS-ADV-CREDIT-LTR-FL  TO S-ADV-CREDIT-LTR-FL.           
REARCH     MOVE RS-REG-GROUP-CD       TO S-REG-GROUP-CD.                
REARCH     MOVE RS-ITPA-EXISTS-CD     TO S-ITPA-EXISTS-CD.              
REARCH     MOVE RS-ITPA-RSLT-CURR-CD  TO S-ITPA-RSLT-CURR-CD.           
REARCH     MOVE RS-LAST-UPDATE-USERID TO S-LAST-UPDATE-USERID.          
REARCH     MOVE RS-LAST-UPDATE-TS     TO S-LAST-UPDATE-TS.              
REARCH     MOVE RS-LETTER-NOTIFY-CD   TO S-LETTER-NOTIFY-CD.            
REARCH     MOVE RS-LETTER-MAILED-DT   TO S-LETTER-MAILED-DT.            
REARCH     MOVE RS-ADV-CREDIT-LTR-DT  TO S-ADV-CREDIT-LTR-DT.           
REARCH     MOVE RS-COMPANY-NO         TO S-COMPANY-NO.                  
C36013     MOVE RS-CR-SCORE-UPDATE-FL TO S-CR-SCORE-UPDATE-FL.          
C36013     MOVE RS-CRED-CD-DESC       TO S-CRED-CD-DESC.                
C36013     MOVE RS-APPL-RESPONSE-TXT  TO S-APPL-RESPONSE-TXT.           
C36013     MOVE RS-APPL-STATUS-CD     TO S-APPL-STATUS-CD.              
C36013     MOVE RS-SENIOR-FL          TO S-SENIOR-FL.                   
C36013     MOVE RS-SAFESCAN-TXT       TO S-SAFESCAN-TXT.                
C36013     MOVE RS-MATCH-TXT          TO S-MATCH-TXT.                   
C36013     MOVE RS-HIT-TXT            TO S-HIT-TXT.                     
C36013     MOVE RS-REJECT-TXT         TO S-REJECT-TXT.                  
C36013     MOVE RS-ERROR-TXT          TO S-ERROR-TXT.                   
C36013     MOVE RS-ACTION-MSG-TX      TO S-ACTION-MSG-TX.               
C36013     MOVE RS-LICENSE-NO         TO S-LICENSE-NO.                  
C36013     MOVE RS-LICENSE-ST         TO S-LICENSE-ST.                  
A01881     MOVE RS-RESP-SCRIPT-TXT    TO S-RESP-SCRIPT-TXT.             
P00453     MOVE RS-SPECIAL-OFFER-CD   TO S-SPECIAL-OFFER-CD.            
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
                                                                        
       2200-PROCESS-FETCH.                                              
                                                                        
           MOVE PARM-CUSTOMER-NO      TO WS-CUSTOMER-NO.                
           MOVE WS-CUSTOMER-NO        TO WS-CUSTOMER-NO-NUM.            
           MOVE WS-CUSTOMER-NO-NUM    TO CK-CUSTOMER-NO.                
TP8514     PERFORM 7100-SELECT-INFO                THRU 7100-EXIT.      
T19245     PERFORM 7400-SELECT-ACTIVE-ACCOUNT      THRU 7400-EXIT.      
TP8514     PERFORM 2210-PROCESS-FORMAT             THRU 2210-EXIT.      
C36013     PERFORM 7530-SELECT-CUSTOMER-DATE       THRU 7530-EXIT.      
C36013     PERFORM 2240-SET-CUST-EST-SSN-MASK      THRU 2240-EXIT.      
P00704     MOVE SPACES                   TO CK-VENDOR-COMMENTS-TEXT.    
           PERFORM 7300-OPEN-CREDIT-HIST-CURSOR THRU 7300-EXIT.         
           PERFORM 7310-FETCH-CREDIT-HIST THRU 7310-EXIT                
              UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.              
           PERFORM 7320-CLOSE-CREDIT-HIST-CURSOR THRU 7320-EXIT.        
                                                                        
       2200-EXIT.                                                       
            EXIT.                                                       
                                                                        
       2210-PROCESS-FORMAT.                                             
                                                                        
           MOVE SPACES                   TO RS-CR-HIST-TRAN-DT          
C23175                                      RS-CR-HIST-TRAN-TM          
                                            RS-BEACON-SCORE             
                                            RS-CR-BUREAU-CD             
                                            RS-CR-ACTION-FL             
                                            RS-CR-COMMENTS              
                                            RS-CR-RQST-REASON-CD        
                                            RS-USER-ID-CR-INIT-BY       
                                            RS-VENDOR-COMMENTS          
C36013                                      RS-LICENSE-NO               
C36013                                      RS-LICENSE-ST.              
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02500000
C36013******************************************************************        
C36013* GET THE DIFFERENCE BETWEEN CUSTOMER ESTABLISHED DATE AND       *        
C36013* CURRENT DATE                                                   *        
C36013******************************************************************        
C36013 2240-SET-CUST-EST-SSN-MASK.                                      
C36013                                                                  
C36013     MOVE '2240' TO ACTIVE-PARAGRAPH.                             
C36013                                                                  
C36013     MOVE FUNCTION CURRENT-DATE(1:8) TO WS-CURRENT-DATE.          
C36013     MOVE CU-CUSTOMER-EST-DATE(1:4) TO WS-DATE-YYYY.              
C36013     MOVE CU-CUSTOMER-EST-DATE(6:2) TO WS-DATE-MM.                
C36013     MOVE CU-CUSTOMER-EST-DATE(9:2) TO WS-DATE-DD.                
C36013     COMPUTE WS-DAYS =                                            
C36013         FUNCTION INTEGER-OF-DATE (WS-CURRENT-DATE) -             
C36013         FUNCTION INTEGER-OF-DATE (WS-DATE-REDEFINE).             
C36013                                                                  
C36013      IF WS-DAYS > WS-MASK-SSN-CUST-DAYS                          
C36013          MOVE 'Y' TO WS-CUST-EST-SSN-MASK-FL                     
C36013                      RS-SSN-MASK-FLAG                            
C36013      ELSE                                                        
C36013          MOVE 'N' TO WS-CUST-EST-SSN-MASK-FL                     
C36013                      RS-SSN-MASK-FLAG                            
C36013      END-IF.                                                     
C36013                                                                  
C36013  2240-EXIT.                                                      
C36013      EXIT.                                                       
C36013                                                                  
C36013******************************************************************        
C36013* SELECT THE TRANS DATE AND TRANS TIME FROM THE                  *        
C36013* CSS_CRED_HIST AND GET THE DIFFERENCE                           *        
C36013******************************************************************        
C36013 2250-SET-SSN-MASK-FLAG.                                          
C36013                                                                  
C36013      MOVE FUNCTION CURRENT-DATE(9:2) TO WS-CURRENT-HOUR          
C36013      MOVE CK-CR-HIST-TRAN-DT(7:4) TO WS-DATE-YYYY                
C36013      MOVE CK-CR-HIST-TRAN-DT(1:2) TO WS-DATE-MM                  
C36013      MOVE CK-CR-HIST-TRAN-DT(4:2) TO WS-DATE-DD                  
C36013      MOVE CK-CR-HIST-TRAN-TM(1:2) TO WS-HOURS                    
C36013           COMPUTE WS-DAYS =                                      
C36013               FUNCTION INTEGER-OF-DATE (WS-CURRENT-DATE) -       
C36013               FUNCTION INTEGER-OF-DATE (WS-DATE-REDEFINE)        
C36013           COMPUTE WS-HOURS = WS-CURRENT-HOUR - WS-HOURS          
C36013           IF WS-DAYS > 0                                         
C36013              COMPUTE WS-HOURS = (WS-DAYS * 24) + WS-HOURS        
C36013           END-IF                                                 
C36013           IF WS-HOURS < WS-MASK-SSN-SCORE-HOURS                  
C36013              MOVE 'N' TO RS-SSN-MASK-FLAG                        
C36013           ELSE                                                   
C36013              MOVE 'Y' TO RS-SSN-MASK-FLAG                        
C36013           END-IF.                                                
C36013                                                                  
C36013  2250-EXIT.                                                      
C36013      EXIT.                                                       
                                                                        
TP8514 7100-SELECT-INFO.                                                
TP8514                                                                  
TP8514     MOVE '7100'          TO ACTIVE-PARAGRAPH.                    
TP8514     EXEC SQL                                                     
TP8514         SELECT     SSN                                           
C36013         INTO      :CE-SSN                                        
TP8514         FROM       CSS_CUST_STATS WITH(READUNCOMMITTED)                  
TP8514         WHERE      CUSTOMER_NO       =:WS-CUSTOMER-NO-NUM        
TP8514         AND        CUSTOMER_TYPE     = 'C'                       
P00453                                                           
P00453                                                      
TP8514     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     05966000
MFA-TR*        SELECT     SSN                                           05967000
MFA-TR*        INTO      :CE-SSN                                        05970000
MFA-TR*        FROM       CSS_CUST_STATS                                06000000
MFA-TR*        WHERE      CUSTOMER_NO       =:WS-CUSTOMER-NO-NUM        06010000
MFA-TR*        AND        CUSTOMER_TYPE     = 'C'                       06020000
MFA-TR*    WITH UR                                                              
MFA-TR*    QUERYNO 7100                                                         
MFA-TR*    END-EXEC.                                                    06030000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

TP8514                                                                  
TP8514     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
TP8514                                                                  
T15677     EVALUATE WS-ACTIVE-RETURN-CODE                               
T15677         WHEN SUCCESSFUL-CALL                                     
T15677             CONTINUE                                             
T15677         WHEN NOT-FOUND                                           
T15677             MOVE SPACES TO CE-SSN                                
T15677         WHEN OTHER                                               
TP8514            MOVE PROGRAM-NAME           TO ABEND-PROGRAM          
TP8514            MOVE 'SELECT'               TO ABEND-FUNCTION         
TP8514            MOVE 'CSS_CUST_STATS'       TO TABLE-1                
TP8514            MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-1        
TP8514            MOVE WS-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1      
TP8514                                                                  
TP8514            PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
TP8514            PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
TP8514     END-EVALUATE.                                                
TP8514*                                                                 06190000
TP8514 7100-EXIT.                                                       
TP8514     EXIT.                                                        
C36013*                                                                         
C36013******************************************************************        
C36013*  7120-GET-CURRENT-DATE                                         *        
C36013*                                                                *        
C36013*     GET THE CURRENT DATE.                                      *        
C36013*                                                                *        
C36013******************************************************************        
C36013*                                                                         
C36013 7120-GET-CURRENT-DATE.                                           
C36013                                                                  
C36013     MOVE '7120'          TO ACTIVE-PARAGRAPH.                    
C36013     MOVE SPACES          TO WS-CURR-DATE.                        
C36013*                                                                         
C36013     EXEC SQL                                                     
C36013        SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURR-DATE                          
C36013     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURR-DATE = CURRENT DATE                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36013*                                                                         
C36013     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
C36013     IF WS-ACTIVE-RETURN-CODE   = SUCCESSFUL-CALL                 
C36013        NEXT SENTENCE                                             
C36013     ELSE                                                         
C36013        MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
C36013        MOVE 'SET'                   TO ABEND-FUNCTION            
C36013        MOVE SPACES                  TO TABLE-1                   
TP8514        MOVE 'CUSTOMER_NO'           TO TABLE-ELEMENT-1           
TP8514        MOVE WS-CUSTOMER-NO          TO HOSTVAR-ELEMENT-1         
C36013        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C36013        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C36013     END-IF.                                                      
C36013*                                                                         
C36013 7120-EXIT.                                                       
C36013     EXIT.                                                        
C36013*                                                                 06301100
       7300-OPEN-CREDIT-HIST-CURSOR.                                    
T15677     MOVE '7300'              TO ACTIVE-PARAGRAPH.                
           EXEC SQL                                                     
                OPEN CREDIT-HIST                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE.                              
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'OPEN'              TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_CREDIT_HIST' TO TABLE-1                         
T15677        MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-1            
T15677        MOVE WS-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1          
CBSI          PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT
           END-IF.          
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7310-FETCH-CREDIT-HIST.                                          
T15677     MOVE '7310'              TO ACTIVE-PARAGRAPH.                
           EXEC SQL                                                     
                FETCH CREDIT-HIST                                       
           INTO :CK-CR-HIST-TRAN-DT,                                    
                :CK-BEACON-SCORE,                                       
                :CK-CR-BUREAU-CD,                                       
                :CK-CR-ACTION-FL,                                       
                :CK-CR-COMMENTS,                                        
                :CK-CR-RQST-REASON-CD,                                  
                :CK-USER-ID-CR-INIT-BY,                                 
                :CK-VENDOR-COMMENTS,                                    
T19245          :CK-ADV-CREDIT-LTR,                                     
C23175          :CK-CR-HIST-TRAN-TM,                                    
C26943          :CK-REG-GROUP-CD,                                       
C29586          :CK-ITPA-EXISTS-CD,                                     
C32212          :CK-CR-CHK-COMPANY-NO,                                  
C29586          :LF-ITPA-RSLT-CURR-CD :WS-NULL-INDICATOR2,               
C29586          :LF-LAST-UPDATE-USERID :WS-NULL-INDICATOR3,              
C29586          :LF-LAST-UPDATE-TS :WS-NULL-INDICATOR4,                  
C29586          :LF-LETTER-NOTIFY-CD :WS-NULL-INDICATOR5,                
C29586          :LF-LETTER-MAILED-DT :WS-NULL-INDICATOR6,                
C29586          :CK-ADV-CREDIT-LTR-DT :WS-NULL-INDICATOR7,               
C36013          :CK-APPL-STATUS-CD,                                     
C36013          :CK-CB-SAFESCAN-CD,                                     
C36013          :CK-CB-MATCH-CD,                                        
C36013          :CK-CB-HIT-CD,                                          
C36013          :CK-CB-BEACON-REJ-CD,                                   
C36013          :CK-CB-FORMAT-ERR-CD,                                   
C36013          :CK-CB-PROCESS-ERR-CD,                                  
C36013          :CK-CB-VALIDITY-ERR-CD,                                 
C36013          :CK-CR-SCORE-UPDATE-FL,                                 
C36013          :CK-SSN,                                                
C36013          :CK-CR-SCORE-TYPE-CD,                                   
C36013          :CK-CR-SCORE-CD,                                        
C36013          :CK-SENIOR-FL,                                          
C36013          :CK-DRIVERS-LICENSE-NO,                                 
P00453          :CK-DRIVERS-LIC-ST-CD,                                  
A05198          :CK-SPECIAL-OFFER-CD,                                   
A05198          :CK-SCORE-MODEL-CD,                                     
A05198          :CK-ADDL-CRED-SCORE                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
C36013                     RS-RETURN-CODE.                              
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               MOVE CK-CR-HIST-TRAN-DT       TO RS-CR-HIST-TRAN-DT      
C23175         MOVE CK-CR-HIST-TRAN-TM       TO RS-CR-HIST-TRAN-TM      
A05198         IF CK-SCORE-MODEL-CD = 'B' OR ' '                        
                  MOVE CK-BEACON-SCORE       TO RS-BEACON-SCORE         
A36013                                          WS-BEACON-SCORE         
A05198         ELSE                                                     
A05198            MOVE CK-ADDL-CRED-SCORE    TO RS-BEACON-SCORE         
A05198                                          WS-BEACON-SCORE         
A05198         END-IF                                                   
               MOVE CK-CR-BUREAU-CD          TO RS-CR-BUREAU-CD         
               MOVE CK-CR-ACTION-FL          TO RS-CR-ACTION-FL         
               MOVE CK-CR-COMMENTS-TEXT      TO RS-CR-COMMENTS          
               MOVE SPACES                   TO CK-CR-COMMENTS-TEXT     
A03119***** IF POSID, DIFFERENT TABLE VALUES ARE SELECTED FOR DISPLAY.          
A03119         IF CK-CR-BUREAU-CD      = 'P'                            
A03119            MOVE CK-CR-BUREAU-CD       TO DG-CR-RQST-REASON-CD    
A03119                                          KE-CR-RQST-REASON-CD    
A03119                                          D6-CR-RQST-REASON-CD    
A03119         ELSE                                                     
C36013            MOVE CK-CR-RQST-REASON-CD  TO DG-CR-RQST-REASON-CD    
C36013                                          KE-CR-RQST-REASON-CD    
C36013                                          D6-CR-RQST-REASON-CD    
A03119         END-IF                                                   
A03119         MOVE CK-CR-RQST-REASON-CD     TO RS-CR-RQST-REASON-CD    
               MOVE CK-USER-ID-CR-INIT-BY    TO RS-USER-ID-CR-INIT-BY   
P00704         MOVE SPACES                   TO RS-VENDOR-COMMENTS      
               MOVE CK-VENDOR-COMMENTS-TEXT  TO RS-VENDOR-COMMENTS      
               MOVE SPACES                   TO CK-VENDOR-COMMENTS-TEXT 
T19245         MOVE CK-ADV-CREDIT-LTR        TO RS-ADV-CREDIT-LTR-FL    
C36013         MOVE CK-DRIVERS-LICENSE-NO    TO RS-LICENSE-NO           
C36013         MOVE CK-DRIVERS-LIC-ST-CD     TO RS-LICENSE-ST           
C36013         MOVE CK-APPL-STATUS-CD        TO RS-APPL-STATUS-CD       
C36013                                          WS-APPL-STATUS-CD       
C36013         MOVE CK-CR-SCORE-UPDATE-FL    TO RS-CR-SCORE-UPDATE-FL   
C36013*                                                                         
C32212         IF CK-CR-CHK-COMPANY-NO > SPACES                         
C32212            MOVE CK-CR-CHK-COMPANY-NO  TO WS-COMP                 
C36013                                          DG-COMPANY-NO           
C36013                                          D6-COMPANY-NO           
C36013                                          KE-COMPANY-NO           
C36013                                          KL-COMPANY-NO           
C36013                                          C8-COMPANY-NO           
C32212            IF CK-REG-GROUP-CD > SPACES                           
C36013               MOVE CK-REG-GROUP-CD    TO WS-REG-GROUP-CD         
C36013                                          DG-REG-GROUP-CD         
C36013                                          D6-REG-GROUP-CD         
C32212            ELSE                                                  
C36013               MOVE SPACES             TO WS-REG-GROUP-CD         
C36013                                          DG-REG-GROUP-CD         
C36013                                          D6-REG-GROUP-CD         
C32212            END-IF                                                
C36013            IF CK-SENIOR-FL > SPACES                              
C36013               MOVE CK-SENIOR-FL       TO WS-SENIOR-FL            
C36013                                          DG-SENIOR-FL            
C36013                                          D6-SENIOR-FL            
C36013            ELSE                                                  
C36013               MOVE SPACES             TO WS-SENIOR-FL            
C36013                                          DG-SENIOR-FL            
C36013                                          D6-SENIOR-FL            
C36013            END-IF                                                
C32212         ELSE                                                     
C32212            MOVE SPACES                TO WS-COMP                 
C36013                                          WS-REG-GROUP-CD         
C36013                                          DG-REG-GROUP-CD         
C36013                                          D6-REG-GROUP-CD         
C36013                                          WS-SENIOR-FL            
C36013                                          DG-SENIOR-FL            
C36013                                          D6-SENIOR-FL            
C36013                                          DG-COMPANY-NO           
C36013                                          D6-COMPANY-NO           
C36013                                          KE-COMPANY-NO           
C36013                                          KL-COMPANY-NO           
C36013                                          C8-COMPANY-NO           
C32212         END-IF                                                   
C36013*                                                                         
C32212         MOVE WS-COMPANY               TO RS-COMPANY-NO           
C36013         MOVE WS-SENIOR-FL             TO RS-SENIOR-FL            
C26943         MOVE WS-REG-GROUP-CD          TO RS-REG-GROUP-CD         
C36013*                                                                         
C29586         IF WS-NULL-INDICATOR7 EQUAL -1                           
C29586            MOVE SPACES                TO RS-ADV-CREDIT-LTR-DT    
C29586            MOVE 0                     TO WS-NULL-INDICATOR7      
C29586         ELSE                                                     
C29586**   THIS REFORMATS THE DATE FROM CCYY-MM-DD TO MM/DD/CCYY                
C29586            MOVE CK-ADV-CREDIT-LTR-DT  TO WS-ADV-CRED-DT          
C29586            MOVE WS-ADV-CRED-YR        TO WS-ADV-CRED-YR2         
C29586            MOVE WS-ADV-CRED-MM        TO WS-ADV-CRED-MM2         
C29586            MOVE WS-ADV-CRED-DY        TO WS-ADV-CRED-DY2         
C29586            MOVE WS-ADV-CRED-DT2       TO RS-ADV-CREDIT-LTR-DT    
C29586         END-IF                                                   
C29586         MOVE CK-ITPA-EXISTS-CD        TO RS-ITPA-EXISTS-CD       
C29586**   FIELDS FROM CSS_CRED_ITPA_HIST                                       
C29586         IF WS-NULL-INDICATOR2 EQUAL -1                           
C29586            MOVE SPACES                TO RS-ITPA-RSLT-CURR-CD    
C29586            MOVE 0                     TO WS-NULL-INDICATOR2      
C29586         ELSE                                                     
C29586            MOVE LF-ITPA-RSLT-CURR-CD  TO RS-ITPA-RSLT-CURR-CD    
C29586         END-IF                                                   
C29586         IF WS-NULL-INDICATOR3 EQUAL -1                           
C29586            MOVE SPACES                TO RS-LAST-UPDATE-USERID   
C29586            MOVE 0                     TO WS-NULL-INDICATOR3      
C29586         ELSE                                                     
C29586            MOVE LF-LAST-UPDATE-USERID TO RS-LAST-UPDATE-USERID   
C29586         END-IF                                                   
C29586         IF WS-NULL-INDICATOR4 EQUAL -1                           
C29586            MOVE SPACES                TO RS-LAST-UPDATE-TS       
C29586            MOVE 0                     TO WS-NULL-INDICATOR4      
C29586         ELSE                                                     
C29586**   THIS REFORMATS THE DATE FROM CCYY-MM-DD TO MM/DD/CCYY                
C29586            MOVE LF-LAST-UPDATE-TS    TO WS-LAST-UPDATE-TS        
C29586            MOVE WS-LAST-UPDT-YR      TO WS-LAST-UPDT-YR2         
C29586            MOVE WS-LAST-UPDT-MM      TO WS-LAST-UPDT-MM2         
C29586            MOVE WS-LAST-UPDT-DY      TO WS-LAST-UPDT-DY2         
C29586            MOVE WS-LAST-UPDT-DT2     TO RS-LAST-UPDATE-TS        
C29586         END-IF                                                   
C29586         IF WS-NULL-INDICATOR5 EQUAL -1                           
C29586            MOVE SPACES                TO RS-LETTER-NOTIFY-CD     
C29586            MOVE 0                     TO WS-NULL-INDICATOR5      
C29586         ELSE                                                     
C29586            MOVE LF-LETTER-NOTIFY-CD   TO RS-LETTER-NOTIFY-CD     
C29586         END-IF                                                   
C29586         IF WS-NULL-INDICATOR6 EQUAL -1                           
C29586            MOVE SPACES                TO RS-LETTER-MAILED-DT     
C29586            MOVE 0                     TO WS-NULL-INDICATOR6      
C29586         ELSE                                                     
C29586**   THIS REFORMATS THE DATE FROM CCYY-MM-DD TO MM/DD/CCYY                
C29586            MOVE LF-LETTER-MAILED-DT  TO WS-LTR-MAIL-DT           
C29586            MOVE WS-LTR-MAIL-YR       TO WS-LTR-MAIL-YR2          
C29586            MOVE WS-LTR-MAIL-MM       TO WS-LTR-MAIL-MM2          
C29586            MOVE WS-LTR-MAIL-DY       TO WS-LTR-MAIL-DY2          
C29586            MOVE WS-LTR-MAIL-DT2      TO RS-LETTER-MAILED-DT      
C29586         END-IF                                                   
C36013*                                                                         
C36013         IF CK-SSN = SPACES                                       
C36013            IF FIRST-ROW-SSN-SW = 'Y'                             
C36013               PERFORM 7100-SELECT-INFO  THRU 7100-EXIT           
C36013               MOVE CE-SSN               TO RS-SSN                
C36013               MOVE 'N'                  TO FIRST-ROW-SSN-SW      
C36013               IF WS-CUST-EST-SSN-MASK-FL = 'Y' THEN              
C36013                  PERFORM 2250-SET-SSN-MASK-FLAG  THRU 2250-EXIT  
C36013               END-IF                                             
C36013            ELSE                                                  
C36013               MOVE SPACES               TO RS-SSN                
C36013            END-IF                                                
C36013         ELSE                                                     
C36013            MOVE CK-SSN                  TO RS-SSN                
C36013               IF WS-CUST-EST-SSN-MASK-FL = 'Y' THEN              
C36013                  PERFORM 2250-SET-SSN-MASK-FLAG  THRU 2250-EXIT  
C36013               END-IF                                             
C36013         END-IF                                                   
C36013*                                                                         
C36013         MOVE CK-CR-SCORE-TYPE-CD  TO DG-CR-SCORE-TYPE-CD         
C36013*                                                                 03871100
C36013         MOVE CK-CR-SCORE-CD       TO DG-CR-SCORE-CD              
C36013*                                                                 03871100
C36013         MOVE SPACES               TO DG-APPL-RESULT-CD           
C36013                                      DG-APPL-RESPONSE-CD         
C36013**   THIS GETS THE TEXT MESSAGES                                          
C36013         IF CK-CB-SAFESCAN-CD > SPACE                             
C36013            MOVE 'S'                  TO KG-CR-SCORE-TYPE-CD      
C36013            MOVE CK-CB-SAFESCAN-CD    TO KG-CR-SCORE-CD           
C36013            PERFORM 7480-SELECT-TXT-MESSAGES   THRU 7480-EXIT     
C36013            MOVE KG-CRED-BUR-TXT      TO RS-SAFESCAN-TXT          
C36013         ELSE                                                     
C36013            MOVE SPACES               TO RS-SAFESCAN-TXT          
C36013         END-IF                                                   
C36013                                                                  
C36013         IF CK-CB-MATCH-CD > SPACE                                
C36013            MOVE 'M'                  TO KG-CR-SCORE-TYPE-CD      
C36013            MOVE CK-CB-MATCH-CD       TO KG-CR-SCORE-CD           
C36013            PERFORM 7480-SELECT-TXT-MESSAGES   THRU 7480-EXIT     
C36013            MOVE KG-CRED-BUR-TXT      TO RS-MATCH-TXT             
C36013         ELSE                                                     
C36013            MOVE SPACES               TO RS-MATCH-TXT             
C36013         END-IF                                                   
C36013                                                                  
C36013         IF CK-CB-HIT-CD > SPACE                                  
C36013            MOVE 'H'                  TO KG-CR-SCORE-TYPE-CD      
C36013            MOVE CK-CB-HIT-CD         TO KG-CR-SCORE-CD           
C36013            PERFORM 7480-SELECT-TXT-MESSAGES   THRU 7480-EXIT     
C36013            MOVE KG-CRED-BUR-TXT      TO RS-HIT-TXT               
C36013         ELSE                                                     
C36013            MOVE SPACES               TO RS-HIT-TXT               
C36013         END-IF                                                   
C36013                                                                  
C36013         IF CK-CB-BEACON-REJ-CD > SPACE                           
C36013            MOVE 'R'                    TO KG-CR-SCORE-TYPE-CD    
C36013            MOVE CK-CB-BEACON-REJ-CD    TO KG-CR-SCORE-CD         
C36013            PERFORM 7480-SELECT-TXT-MESSAGES   THRU 7480-EXIT     
C36013            MOVE KG-CRED-BUR-TXT        TO RS-REJECT-TXT          
C36013         ELSE                                                     
C36013            MOVE SPACES                 TO RS-REJECT-TXT          
C36013         END-IF                                                   
C36013                                                                  
C36013         IF CK-CB-FORMAT-ERR-CD > SPACE                           
C36013            MOVE 'FE'                   TO KG-CR-SCORE-TYPE-CD    
C36013            MOVE CK-CB-FORMAT-ERR-CD    TO KG-CR-SCORE-CD         
C36013            PERFORM 7480-SELECT-TXT-MESSAGES   THRU 7480-EXIT     
C36013            MOVE KG-CRED-BUR-TXT        TO RS-ERROR-TXT           
C36013         ELSE                                                     
C36013            IF CK-CB-PROCESS-ERR-CD > SPACE                       
C36013               MOVE 'PE'                 TO KG-CR-SCORE-TYPE-CD   
C36013               MOVE CK-CB-PROCESS-ERR-CD TO KG-CR-SCORE-CD        
C36013               PERFORM 7480-SELECT-TXT-MESSAGES THRU 7480-EXIT    
C36013               MOVE KG-CRED-BUR-TXT      TO RS-ERROR-TXT          
C36013            ELSE                                                  
C36013               IF CK-CB-VALIDITY-ERR-CD > SPACE                   
C36013                  MOVE 'VE'              TO KG-CR-SCORE-TYPE-CD   
C36013                  MOVE CK-CB-VALIDITY-ERR-CD                      
C36013                                         TO KG-CR-SCORE-CD        
C36013                  PERFORM 7480-SELECT-TXT-MESSAGES                
C36013                                               THRU 7480-EXIT     
C36013                  MOVE KG-CRED-BUR-TXT   TO RS-ERROR-TXT          
C36013               ELSE                                               
C36013                  MOVE SPACES            TO RS-ERROR-TXT          
C36013               END-IF                                             
C36013            END-IF                                                
C36013         END-IF                                                   
C36013*                                                                         
C36013         PERFORM 7120-GET-CURRENT-DATE    THRU 7120-EXIT          
P00453         IF (CK-SPECIAL-OFFER-CD    = 'P' AND                     
P00453             CK-APPL-STATUS-CD      = 'C')                        
P00453             MOVE SPACES                 TO RS-CRED-CD-DESC       
P00453             MOVE SPACES                 TO RS-APPL-RESPONSE-TXT  
P00453         ELSE                                                     
C36013            PERFORM 7500-DG-RESULT-RESPONSE  THRU 7500-EXIT       
C36013            MOVE SPACES                  TO KL-CRED-CD            
C36013                                            KE-APPL-RESPONSE-CD   
C36013            MOVE DG-APPL-RESULT-CD       TO KL-CRED-CD            
C36013            IF KL-CRED-CD  > SPACES                               
C36013               PERFORM 7510-KL-RESULT-DESC THRU 7510-EXIT         
C36013               MOVE KL-CRED-CD-DESC      TO RS-CRED-CD-DESC       
C36013            ELSE                                                  
C36013               MOVE SPACES               TO RS-CRED-CD-DESC       
C36013            END-IF                                                
C36013            MOVE DG-APPL-RESPONSE-CD     TO KE-APPL-RESPONSE-CD   
C36013            IF KE-APPL-RESPONSE-CD > SPACES                       
C36013               PERFORM 7520-KE-RESPONSE-DESC THRU 7520-EXIT       
C36013               MOVE KE-APPL-RESPONSE-TXT TO WS-APPL-RESPONSE-TXT  
C36013               MOVE WS-APPL-RESPONSE-TXT-TEXT                     
C36013                                         TO RS-APPL-RESPONSE-TXT  
C36013            ELSE                                                  
C36013               MOVE SPACES               TO RS-APPL-RESPONSE-TXT  
C36013            END-IF                                                
P00453         END-IF                                                   
P00773         IF WS-APPL-STATUS-CD  = 'C' OR CK-CR-RQST-REASON-CD = 'R'
C36013            INSPECT WS-BEACON-SCORE REPLACING ALL SPACES BY '0'   
C36013            MOVE WS-BEACON-SCORE-RED  TO WS-BEACON-SCORE-NUM      
A05198            IF CK-SCORE-MODEL-CD = 'B' OR ' '                     
A05198               MOVE 'B'               TO D6-SCORE-MODEL-CD        
A05198            ELSE                                                  
A05198               MOVE 'A'               TO D6-SCORE-MODEL-CD        
A05198            END-IF                                                
C36013            PERFORM 7550-D6-ACTION-MSG-TX                         
C36013                                      THRU 7550-EXIT              
C36013            MOVE D6-ACTION-MSG-TX       TO RS-ACTION-MSG-TX       
A01881            MOVE D6-RESP-SCRIPT-TXT     TO RS-RESP-SCRIPT-TXT     
P00453            MOVE CK-SPECIAL-OFFER-CD    TO RS-SPECIAL-OFFER-CD    
C36013         ELSE                                                     
C36013            MOVE SPACES                 TO RS-ACTION-MSG-TX       
A01881            MOVE SPACES                 TO RS-RESP-SCRIPT-TXT     
P00453            MOVE SPACES                 TO RS-SPECIAL-OFFER-CD    
C36013         END-IF                                                   
C36013*                                                                         
               ADD 1 TO WS-ROW-COUNT                                    
REARCH         PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                
               PERFORM 8100-SEND-RESULT  THRU 8100-EXIT                 
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
TP8514        IF ( WS-ROW-COUNT = 0 )                                   
REARCH            PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT             
TP8514            PERFORM 8100-SEND-RESULT THRU 8100-EXIT               
REARCH            MOVE NOT-FOUND     TO WS-ACTIVE-RETURN-CODE           
TP8514        END-IF                                                    
              GO TO 7310-EXIT                                           
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'FETCH'             TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_CREDIT_HIST'   TO TABLE-1                       
T15677        MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-1            
T15677        MOVE WS-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1          
CBSI          PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT
           END-IF
           END-IF.          
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7320-CLOSE-CREDIT-HIST-CURSOR.                                   
T15677     MOVE '7320'              TO ACTIVE-PARAGRAPH.                
           EXEC SQL                                                     
                CLOSE CREDIT-HIST                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'CLOSE'             TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_CREDIT-HIST '  TO TABLE-1                       
T15677        MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-1            
T15677        MOVE WS-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1          
CBSI          PERFORM 9000-SEND-ERROR-RESULT  THRU  9000-EXIT           
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT
           END-IF.          
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
T19245******************************************************************        
T19245* IF AN ACTIVE ACCT IS FOUND, THEN DO NOT DISPLAY RESPONSE       *        
T19245* WINDOW (PANEL 159) FROM PANEL 59.                              *        
T19245******************************************************************        
T19245 7400-SELECT-ACTIVE-ACCOUNT.                                      
T19245                                                                  
T19245     MOVE '7400'          TO ACTIVE-PARAGRAPH.                    
T19245                                                                  
T19245     EXEC SQL                                                     
T19245         SELECT AT.ACCOUNT_NO                                     
T19245           INTO :AT-ACCOUNT-NO                                    
T19245           FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
T19245          WHERE AT.CUSTOMER_NO = :WS-CUSTOMER-NO-NUM              
T19245            AND AT.CODE_ACCT_STAT = 'A'                           
P00453                                                           
P00453                                                      
T19245     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     06270000
MFA-TR*        SELECT AT.ACCOUNT_NO                                     06280000
MFA-TR*          INTO :AT-ACCOUNT-NO                                    06292000
MFA-TR*          FROM CSS_ACCOUNT AT                                    06295000
MFA-TR*         WHERE AT.CUSTOMER_NO = :WS-CUSTOMER-NO-NUM              06296000
MFA-TR*           AND AT.CODE_ACCT_STAT = 'A'                           06297000
MFA-TR*    WITH UR                                                              
MFA-TR*    QUERYNO 7400                                                         
MFA-TR*    END-EXEC.                                                    06298000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T19245                                                                  
T19245     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T19245     MOVE 'N' TO RS-ACCOUNT-FL.                                   
T19245                                                                  
T19245     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR -811           
T19245        MOVE 'Y' TO RS-ACCOUNT-FL                                 
T19245     ELSE                                                         
T19245        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
T19245           CONTINUE                                               
T19245        ELSE                                                      
T19245           MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
T19245           MOVE 'SELECT'              TO ABEND-FUNCTION           
T19245           MOVE 'CSS_ACCOUNT'         TO TABLE-1                  
T19245           MOVE 'CSS_CUSTOMER'        TO TABLE-2                  
T19245           MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1          
T19245           MOVE WS-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1        
T19245           PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
T19245           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
T19245        END-IF                                                    
T19245     END-IF.                                                      
T19245                                                                  
T19245 7400-EXIT.                                                       
T19245     EXIT.                                                        
T19245*                                                                         
C36013******************************************************************        
C36013* GET DELINQUENCY VALUE FOR THE GIVEN DELINQUENCY CODE           *        
C36013******************************************************************        
C36013 7450-GET-DELINQUENCY-VALUE.                                      
C36013*                                                                         
C36013     EXEC SQL                                                     
C36013        SELECT TOP(1) DELINQ_VALUE                                       
C36013          INTO :C8-DELINQ-VALUE                                   
C36013          FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
C36013         WHERE DELINQ_CD = :C8-DELINQ-CD                          
C36013                                     
P00453                                                      
C36013     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD = :C8-DELINQ-CD                                  
MFA-TR*        FETCH FIRST 1 ROW ONLY WITH UR                                   
MFA-TR*        QUERYNO 7450                                                     
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36013*                                                                         
C36013     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
C36013                                                                  
C36013     EVALUATE WS-ACTIVE-RETURN-CODE                               
C36013         WHEN SUCCESSFUL-CALL                                     
C36013             CONTINUE                                             
C36013         WHEN NOT-FOUND                                           
C36013             MOVE ZEROES                TO C8-DELINQ-VALUE        
C36013         WHEN OTHER                                               
C36013            MOVE PROGRAM-NAME           TO ABEND-PROGRAM          
C36013            MOVE '7450'                 TO ACTIVE-PARAGRAPH       
C36013            MOVE 'SELECT'               TO ABEND-FUNCTION         
C36013            MOVE 'CSS_DELINQUENCY'      TO TABLE-1                
C36013            MOVE 'DELINQ_CD'            TO TABLE-ELEMENT-1        
C36013            MOVE C8-DELINQ-CD           TO HOSTVAR-ELEMENT-1      
C36013                                                                  
C36013            PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
C36013            PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
C36013     END-EVALUATE.                                                
C36013                                                                  
C36013 7450-EXIT.                                                       
C36013     EXIT.                                                        
C36013*                                                                         
C36013******************************************************************        
C36013* GET THE MESSAGES SAFESCAN,MATCH,HIT, REJECT AND ERROR FROM     *        
C36013* CSS_CRED_BUR_TXT.                                              *        
C36013******************************************************************        
C36013 7480-SELECT-TXT-MESSAGES.                                        
C36013*                                                                 06240000
C36013     MOVE '7480'          TO ACTIVE-PARAGRAPH.                    
C36013     INITIALIZE              KG-CRED-BUR-TXT                      
C36013*                                                                 06260000
C36013     EXEC SQL                                                     
C36013         SELECT    CRED_BUR_TXT                                   
C36013         INTO      :KG-CRED-BUR-TXT                               
C36013         FROM      CSS_CRED_BUR_TXT WITH(READUNCOMMITTED)                 
C36013         WHERE     CR_SCORE_TYPE_CD  = :KG-CR-SCORE-TYPE-CD       
C36013         AND       CR_SCORE_CD       = :KG-CR-SCORE-CD            
P00453                                                           
P00453                                                      
C36013     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     05966000
MFA-TR*        SELECT    CRED_BUR_TXT                                   05967000
MFA-TR*        INTO      :KG-CRED-BUR-TXT                               05970000
MFA-TR*        FROM      CSS_CRED_BUR_TXT                               06000000
MFA-TR*        WHERE     CR_SCORE_TYPE_CD  = :KG-CR-SCORE-TYPE-CD       06000000
MFA-TR*        AND       CR_SCORE_CD       = :KG-CR-SCORE-CD            06000000
MFA-TR*    WITH UR                                                              
MFA-TR*    QUERYNO 7480                                                         
MFA-TR*    END-EXEC.                                                    06030000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36013*                                                                 06295000
C36013     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C36013        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND   
C36013           CONTINUE                                               
C36013        ELSE                                                      
C36013           MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
C36013           MOVE 'FETCH'                TO ABEND-FUNCTION          
C36013           MOVE SPACES                 TO ABEND-TABLES            
C36013                                          ABEND-SQL-PREDICATES    
C36013           MOVE 'CSS_CRED_BUR_TXT'     TO TABLE-1                 
C36013           MOVE 'CR_SCORE_TYPE_CD'     TO TABLE-ELEMENT-1         
C36013           MOVE KG-CR-SCORE-TYPE-CD   TO HOSTVAR-ELEMENT-1        
C36013           MOVE 'CR_SCORE_CD'          TO TABLE-ELEMENT-2         
C36013           MOVE KG-CR-SCORE-CD    TO HOSTVAR-ELEMENT-2            
C36013           PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
C36013           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
C36013        END-IF.                                                   
C36013*                                                                 06300800
C36013 7480-EXIT.                                                       
C36013     EXIT.                                                        
C36013*                                                                         
C36013*****************************************************************         
C36013* 7500-DG-RESULT-RESPONSE.                                      *         
C36013* GET THE CODE FOR "RESULT" AND "RESPONSE TO CUSTOMER"  FIELDS  *         
C36013* FROM CSS_CRED_BUR_MATRX DG                                    *         
C36013*****************************************************************         
C36013*                                                                         
C36013 7500-DG-RESULT-RESPONSE.                                         
C36013*                                                                 06240000
C36013     MOVE '7500'          TO ACTIVE-PARAGRAPH.                    
C36013     MOVE SPACES          TO DG-APPL-RESULT-CD.                   
C36013     MOVE SPACES          TO DG-APPL-RESPONSE-CD.                 
C36013*                                                                 06260000
C36013     EXEC SQL                                                     
C36013         SELECT TOP(1) DG.APPL_RESULT_CD,
              DG.APPL_RESPONSE_CD                               
C36013           INTO :DG-APPL-RESULT-CD,                               
C36013                :DG-APPL-RESPONSE-CD                              
C36013           FROM CSS_CRED_BUR_MATRX DG WITH(READUNCOMMITTED)               
C36013          WHERE DG.COMPANY_NO        = :DG-COMPANY-NO             
C36013          AND   DG.CR_RQST_REASON_CD = :DG-CR-RQST-REASON-CD      
C36013          AND   DG.REG_GROUP_CD      = :DG-REG-GROUP-CD           
C36013          AND   DG.SENIOR_FL         = :DG-SENIOR-FL              
C36013          AND   DG.CR_SCORE_TYPE_CD  = :DG-CR-SCORE-TYPE-CD       
C36013          AND   DG.CR_SCORE_CD       = :DG-CR-SCORE-CD            
C36013          AND   DG.EFFECTIVE_DT IN ( SELECT DG1.EFFECTIVE_DT      
C36013                FROM CSS_CRED_BUR_MATRX DG1 WITH(READUNCOMMITTED)         
C36013              WHERE DG1.COMPANY_NO        = :DG-COMPANY-NO        
C36013               AND  DG1.CR_RQST_REASON_CD = :DG-CR-RQST-REASON-CD 
C36013               AND  DG1.REG_GROUP_CD      = :DG-REG-GROUP-CD      
C36013               AND  DG1.SENIOR_FL         = :DG-SENIOR-FL         
C36013               AND  DG1.CR_SCORE_TYPE_CD  = :DG-CR-SCORE-TYPE-CD  
C36013               AND  DG1.CR_SCORE_CD       = :DG-CR-SCORE-CD       
C36013               AND  DG1.EFFECTIVE_DT      <= 
              IIF(TRY_CONVERT(DATE, :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )        
C36013               AND  DG1.EXPIRATION_DT     >= 
              IIF(TRY_CONVERT(DATE, :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) ) )      
C36013                                     
P00453                                                      
C36013     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     06270000
MFA-TR*        SELECT DG.APPL_RESULT_CD,                                06280000
MFA-TR*               DG.APPL_RESPONSE_CD                               06280000
MFA-TR*          INTO :DG-APPL-RESULT-CD,                               06280000
MFA-TR*               :DG-APPL-RESPONSE-CD                              06280000
MFA-TR*          FROM CSS_CRED_BUR_MATRX DG                             06295000
MFA-TR*         WHERE DG.COMPANY_NO        = :DG-COMPANY-NO             06296000
MFA-TR*         AND   DG.CR_RQST_REASON_CD = :DG-CR-RQST-REASON-CD      06296000
MFA-TR*         AND   DG.REG_GROUP_CD      = :DG-REG-GROUP-CD           06296000
MFA-TR*         AND   DG.SENIOR_FL         = :DG-SENIOR-FL              06296000
MFA-TR*         AND   DG.CR_SCORE_TYPE_CD  = :DG-CR-SCORE-TYPE-CD       06296000
MFA-TR*         AND   DG.CR_SCORE_CD       = :DG-CR-SCORE-CD            06296000
MFA-TR*         AND   DG.EFFECTIVE_DT IN ( SELECT DG1.EFFECTIVE_DT      06296000
MFA-TR*               FROM CSS_CRED_BUR_MATRX DG1                       06296000
MFA-TR*             WHERE DG1.COMPANY_NO        = :DG-COMPANY-NO                
MFA-TR*              AND  DG1.CR_RQST_REASON_CD = :DG-CR-RQST-REASON-CD         
MFA-TR*              AND  DG1.REG_GROUP_CD      = :DG-REG-GROUP-CD              
MFA-TR*              AND  DG1.SENIOR_FL         = :DG-SENIOR-FL                 
MFA-TR*              AND  DG1.CR_SCORE_TYPE_CD  = :DG-CR-SCORE-TYPE-CD          
MFA-TR*              AND  DG1.CR_SCORE_CD       = :DG-CR-SCORE-CD               
MFA-TR*              AND  DG1.EFFECTIVE_DT      <= :WS-CURR-DATE                
MFA-TR*              AND  DG1.EXPIRATION_DT     >= :WS-CURR-DATE )              
MFA-TR*        FETCH FIRST 1 ROW ONLY WITH UR                                   
MFA-TR*        QUERYNO 7500                                                     
MFA-TR*    END-EXEC                                                     06298000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36013*                                                                         
C36013     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C36013*                                                                 06060000
C36013     EVALUATE WS-ACTIVE-RETURN-CODE                               
C36013         WHEN SUCCESSFUL-CALL                                     
C36013             CONTINUE                                             
C36013         WHEN NOT-FOUND                                           
C36013             MOVE SPACES TO DG-APPL-RESULT-CD                     
C36013             MOVE SPACES TO DG-APPL-RESPONSE-CD                   
C36013         WHEN OTHER                                               
C36013            MOVE PROGRAM-NAME           TO ABEND-PROGRAM          
C36013            MOVE 'SELECT'               TO ABEND-FUNCTION         
C36013            MOVE 'CSS_CRED_BUR_MATRX'   TO TABLE-1                
C36013            MOVE 'CSS_CREDIT_HIST'      TO TABLE-2                
C36013            MOVE WS-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1      
C36013                                                                  
C36013            PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
C36013            PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
C36013     END-EVALUATE.                                                
C36013*                                                                 06190000
C36013 7500-EXIT.                                                       
C36013     EXIT.                                                        
C36013*                                                                         
C36013*****************************************************************         
C36013* 7510-KL-RESULT-DESC.                                          *         
C36013* GET THE CRED CODE DESC FOR "RESULT" FROM CSS_CRED_CODE_DESC KL*         
C36013* TABLE                                                         *         
C36013*****************************************************************         
C36013*                                                                         
C36013 7510-KL-RESULT-DESC.                                             
C36013*                                                                 06240000
C36013     MOVE '7510'          TO ACTIVE-PARAGRAPH.                    
C36013     MOVE SPACES          TO KL-CRED-CD-DESC.                     
C36013*                                                                 06260000
C36013     EXEC SQL                                                     
C36013        SELECT KL.CRED_CD_DESC                                    
C36013          INTO :KL-CRED-CD-DESC                                   
C36013          FROM CSS_CRED_CODE_DESC KL WITH(READUNCOMMITTED)                
C36013         WHERE KL.COMPANY_NO = :KL-COMPANY-NO                     
C36013         AND   KL.COLUMN_NA  = 'APPL_RESULT_CD'                   
C36013         AND   KL.CRED_CD    = :KL-CRED-CD                        
C36013                                                           
P00453                                                      
C36013     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT KL.CRED_CD_DESC                                            
MFA-TR*         INTO :KL-CRED-CD-DESC                                           
MFA-TR*         FROM CSS_CRED_CODE_DESC KL                                      
MFA-TR*        WHERE KL.COMPANY_NO = :KL-COMPANY-NO                             
MFA-TR*        AND   KL.COLUMN_NA  = 'APPL_RESULT_CD'                           
MFA-TR*        AND   KL.CRED_CD    = :KL-CRED-CD                                
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7510                                                     
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36013*                                                                         
C36013     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C36013*                                                                 06060000
C36013     EVALUATE WS-ACTIVE-RETURN-CODE                               
C36013         WHEN SUCCESSFUL-CALL                                     
C36013             CONTINUE                                             
C36013         WHEN NOT-FOUND                                           
C36013             MOVE SPACES TO KL-CRED-CD-DESC                       
C36013         WHEN OTHER                                               
C36013            MOVE PROGRAM-NAME           TO ABEND-PROGRAM          
C36013            MOVE 'SELECT'               TO ABEND-FUNCTION         
C36013            MOVE 'CSS_CRED_CODE_DESC'   TO TABLE-1                
C36013            MOVE 'CRED_CD'              TO TABLE-ELEMENT-1        
C36013            MOVE KL-CRED-CD             TO HOSTVAR-ELEMENT-1      
C36013                                                                  
C36013            PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
C36013            PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
C36013     END-EVALUATE.                                                
C36013*                                                                 06190000
C36013 7510-EXIT.                                                       
C36013     EXIT.                                                        
C36013*                                                                         
C36013*****************************************************************         
C36013* 7520-KE-RESPONSE-DESC                                         *         
C36013* GET THE DESC FOR "RESPONSE TO CUSTOMER" FROM CSS_APPL_RESPONSE*         
C36013* KE TABLE                                                      *         
C36013*****************************************************************         
C36013*                                                                         
C36013 7520-KE-RESPONSE-DESC.                                           
C36013*                                                                 06240000
C36013     MOVE '7520'          TO ACTIVE-PARAGRAPH.                    
C36013     MOVE SPACES          TO KE-APPL-RESPONSE-TXT.                
C36013*                                                                 06260000
C36013     EXEC SQL                                                     
C36013        SELECT KE.APPL_RESPONSE_TXT                               
C36013          INTO :KE-APPL-RESPONSE-TXT                              
C36013          FROM CSS_APPL_RESPONSE KE WITH(READUNCOMMITTED)                 
C36013         WHERE KE.COMPANY_NO        = :KE-COMPANY-NO              
C36013         AND   KE.CR_RQST_REASON_CD = :KE-CR-RQST-REASON-CD       
C36013         AND   KE.APPL_RESPONSE_CD  = :KE-APPL-RESPONSE-CD        
C36013                                                           
P00453                                                      
C36013     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT KE.APPL_RESPONSE_TXT                                       
MFA-TR*         INTO :KE-APPL-RESPONSE-TXT                                      
MFA-TR*         FROM CSS_APPL_RESPONSE KE                                       
MFA-TR*        WHERE KE.COMPANY_NO        = :KE-COMPANY-NO                      
MFA-TR*        AND   KE.CR_RQST_REASON_CD = :KE-CR-RQST-REASON-CD               
MFA-TR*        AND   KE.APPL_RESPONSE_CD  = :KE-APPL-RESPONSE-CD                
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7520                                                     
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36013*                                                                         
C36013     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C36013*                                                                 06060000
C36013     EVALUATE WS-ACTIVE-RETURN-CODE                               
C36013         WHEN SUCCESSFUL-CALL                                     
C36013             CONTINUE                                             
C36013         WHEN NOT-FOUND                                           
C36013             MOVE SPACES TO KE-APPL-RESPONSE-TXT                  
C36013         WHEN OTHER                                               
C36013            MOVE PROGRAM-NAME           TO ABEND-PROGRAM          
C36013            MOVE 'SELECT'               TO ABEND-FUNCTION         
C36013            MOVE 'CSS_APPL_RESPONSE'    TO TABLE-1                
C36013            MOVE 'APPL_RESPONSE_CD'     TO TABLE-ELEMENT-1        
C36013            MOVE KE-APPL-RESPONSE-CD    TO HOSTVAR-ELEMENT-1      
C36013                                                                  
C36013            PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
C36013            PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
C36013     END-EVALUATE.                                                
C36013*                                                                 06190000
C36013 7520-EXIT.                                                       
C36013     EXIT.                                                        
C36013*                                                                         
C36013******************************************************************        
C36013*   7530-SELECT-CUSTOMER-DATE.                                   *        
C36013*                                                                *        
C36013*   1.  GETS CUSTOMER ESTABLISHED DATE                           *        
C36013*                                                                *        
C36013******************************************************************        
C36013 7530-SELECT-CUSTOMER-DATE.                                       
C36013                                                                  
C36013     MOVE '7530' TO ACTIVE-PARAGRAPH.                             
C36013                                                                  
C36013     EXEC SQL                                                     
C36013        SELECT CU.CUSTOMER_EST_DATE                               
C36013        INTO  :CU-CUSTOMER-EST-DATE :WS-NULL-CUST-EST-DT           
C36013        FROM   CSS_CUSTOMER CU WITH(READUNCOMMITTED)                      
C36013        WHERE  CU.CUSTOMER_NO = :WS-CUSTOMER-NO-NUM               
C36013                                                           
P00453                                                      
C36013     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CU.CUSTOMER_EST_DATE                                       
MFA-TR*       INTO  :CU-CUSTOMER-EST-DATE:WS-NULL-CUST-EST-DT                   
MFA-TR*       FROM   CSS_CUSTOMER CU                                            
MFA-TR*       WHERE  CU.CUSTOMER_NO = :WS-CUSTOMER-NO-NUM                       
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7530                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36013                                                                  
C36013     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C36013                                                                  
C36013     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C36013        IF WS-NULL-CUST-EST-DT = -1                               
C36013           MOVE 'N' TO RS-SSN-MASK-FLAG                           
C36013        END-IF                                                    
C36013     ELSE                                                         
C36013        MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
C36013        MOVE 'SELECT'        TO ABEND-FUNCTION                    
C36013        MOVE 'CSS_CUSTOMER'  TO TABLE-1                           
C36013        MOVE 'CUSTOMER_NO'   TO TABLE-ELEMENT-1                   
C36013        MOVE CU-CUSTOMER-NO  TO HOSTVAR-ELEMENT-1                 
C36013        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C36013        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C36013     END-IF.                                                      
C36013                                                                  
C36013 7530-EXIT.                                                       
C36013*                                                                         
C36013*****************************************************************         
C36013*  7550-D6-ACTION-MSG-TX                                        *         
C36013*  GET THE ACTION MESSAGE TEXT FROM CSS_DEP_REQUIREMNT D6 TABLE.*         
C36013*****************************************************************         
C36013*                                                                         
C36013 7550-D6-ACTION-MSG-TX.                                           
C36013*                                                                 06240000
C36013     MOVE '7550'          TO ACTIVE-PARAGRAPH.                    
C36013     MOVE SPACES          TO D6-ACTION-MSG-TX                     
A01881                             D6-RESP-SCRIPT-TXT.                  
C36013*                                                                 06260000
C36013     EXEC SQL                                                     
C36013         SELECT TOP(1) ACTION_MSG_TX,
              RESP_SCRIPT_TXT                                   
C36013           INTO :D6-ACTION-MSG-TX                                 
A01881               ,:D6-RESP-SCRIPT-TXT                               
C36013           FROM CSS_DEP_REQUIREMNT WITH(READUNCOMMITTED)                  
C36013          WHERE COMPANY_NO          =  :D6-COMPANY-NO             
C36013          AND   CR_RQST_REASON_CD   =  :D6-CR-RQST-REASON-CD      
C36013          AND   REG_GROUP_CD        =  :D6-REG-GROUP-CD           
C36013          AND   SENIOR_FL           =  :D6-SENIOR-FL              
C36013          AND   MIN_SCORE_NO        <= :WS-BEACON-SCORE-NUM       
C36013          AND   MAX_SCORE_NO        >= :WS-BEACON-SCORE-NUM       
C36013          AND   EFFECTIVE_DT        <= IIF(TRY_CONVERT(DATE, 
                                                          :WS-CURR-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-DATE
              ) <> 0) OR (LEN(:WS-CURR-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-CURR-DATE
              ), CONVERT(DATE, :WS-CURR-DATE) )              
A05198          AND   SCORE_MODEL_CD      =  :D6-SCORE-MODEL-CD         
C36013          ORDER BY EFFECTIVE_DT DESC                              
C36013                                     
P00453                                                      
C36013     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     06270000
MFA-TR*        SELECT ACTION_MSG_TX                                     06280000
MFA-TR*              ,RESP_SCRIPT_TXT                                   06280000
MFA-TR*          INTO :D6-ACTION-MSG-TX                                 06280000
MFA-TR*              ,:D6-RESP-SCRIPT-TXT                               06280000
MFA-TR*          FROM CSS_DEP_REQUIREMNT                                06295000
MFA-TR*         WHERE COMPANY_NO          =  :D6-COMPANY-NO             06296000
MFA-TR*         AND   CR_RQST_REASON_CD   =  :D6-CR-RQST-REASON-CD      06296000
MFA-TR*         AND   REG_GROUP_CD        =  :D6-REG-GROUP-CD           06296000
MFA-TR*         AND   SENIOR_FL           =  :D6-SENIOR-FL              06296000
MFA-TR*         AND   MIN_SCORE_NO        <= :WS-BEACON-SCORE-NUM       06296000
MFA-TR*         AND   MAX_SCORE_NO        >= :WS-BEACON-SCORE-NUM       06296000
MFA-TR*         AND   EFFECTIVE_DT        <= :WS-CURR-DATE              06296000
MFA-TR*         AND   SCORE_MODEL_CD      =  :D6-SCORE-MODEL-CD                 
MFA-TR*         ORDER BY EFFECTIVE_DT DESC                                      
MFA-TR*        FETCH FIRST 1 ROW ONLY WITH UR                                   
MFA-TR*        QUERYNO 7550                                                     
MFA-TR*    END-EXEC                                                     06298000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36013*                                                                         
C36013     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C36013*                                                                 06060000
C36013     EVALUATE WS-ACTIVE-RETURN-CODE                               
C36013         WHEN SUCCESSFUL-CALL                                     
C36013             CONTINUE                                             
C36013         WHEN NOT-FOUND                                           
C36013             MOVE SPACES TO D6-ACTION-MSG-TX                      
A01881                            D6-RESP-SCRIPT-TXT                    
C36013         WHEN OTHER                                               
C36013            MOVE PROGRAM-NAME           TO ABEND-PROGRAM          
C36013            MOVE 'SELECT'               TO ABEND-FUNCTION         
C36013            MOVE 'CSS_DEP_REQUIREMNT'   TO TABLE-1                
C36013            MOVE WS-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1      
C36013                                                                  
C36013            PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
C36013            PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
C36013     END-EVALUATE.                                                
C36013*                                                                 06190000
C36013 7550-EXIT.                                                       
C36013     EXIT.                                                        
C36013*                                                                         
      ******************************************************************06990000
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *07000000
      ******************************************************************07010000
           EXEC SQL                                                     07020000
              INCLUDE CPDSP300                                          07030000
           END-EXEC.                                                    07040000
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000     EXEC SQL                                                     
CVT000       INSERT INTO #CSR02270_R1                            
CVT000       (                                                          
CVT000        RETURN_CODE                                               
CVT000       ,CR_HIST_TRAN_DT                                           
CVT000       ,CR_HIST_TRAN_TM                                           
CVT000       ,BEACON_SCORE                                              
CVT000       ,CR_BUREAU_CD                                              
CVT000       ,CR_ACTION_FL                                              
CVT000       ,CR_COMMENTS                                               
CVT000       ,CR_RQST_REASON_CD                                         
CVT000       ,USER_ID_CR_INIT_BY                                        
CVT000       ,VENDOR_COMMENTS                                           
CVT000       ,SSN                                                       
CVT000       ,SSN_MASK_FLAG                                             
CVT000       ,ACCOUNT_FL                                                
CVT000       ,ADV_CREDIT_LTR_FL                                         
CVT000       ,REG_GROUP_CD                                              
CVT000       ,ITPA_EXISTS_CD                                            
CVT000       ,ITPA_RSLT_CURR_CD                                         
CVT000       ,LAST_UPDATE_USERID                                        
CVT000       ,LAST_UPDATE_TS                                            
CVT000       ,LETTER_NOTIFY_CD                                          
CVT000       ,LETTER_MAILED_DT                                          
CVT000       ,ADV_CREDIT_LTR_DT                                         
CVT000       ,COMPANY_NO                                                
C36013       ,CR_SCORE_UPDATE_FL                                        
C36013       ,CRED_CD_DESC                                              
C36013       ,APPL_RESPONSE_TXT                                         
C36013       ,APPL_STATUS_CD                                            
C36013       ,SENIOR_FL                                                 
C36013       ,SAFESCAN_TXT                                              
C36013       ,MATCH_TXT                                                 
C36013       ,HIT_TXT                                                   
C36013       ,REJECT_TXT                                                
C36013       ,ERROR_TXT                                                 
C36013       ,ACTION_MSG_TX                                             
C36013       ,LICENSE_NO                                                
C36013       ,LICENSE_ST                                                
A01881       ,RESP_SCRIPT_TXT                                           
P00453       ,SPECIAL_OFFER_CD                                          
CVT000       )                                                          
CVT000       VALUES                                                     
CVT000       (                                                          
REARCH        :S-RETURN-CODE                                            
REARCH       ,:S-CR-HIST-TRAN-DT                                        
REARCH       ,:S-CR-HIST-TRAN-TM                                        
REARCH       ,:S-BEACON-SCORE                                           
REARCH       ,:S-CR-BUREAU-CD                                           
REARCH       ,:S-CR-ACTION-FL                                           
REARCH       ,:S-CR-COMMENTS                                            
REARCH       ,:S-CR-RQST-REASON-CD                                      
REARCH       ,:S-USER-ID-CR-INIT-BY                                     
REARCH       ,:S-VENDOR-COMMENTS                                        
REARCH       ,:S-SSN                                                    
REARCH       ,:S-SSN-MASK-FLAG                                          
REARCH       ,:S-ACCOUNT-FL                                             
REARCH       ,:S-ADV-CREDIT-LTR-FL                                      
REARCH       ,:S-REG-GROUP-CD                                           
REARCH       ,:S-ITPA-EXISTS-CD                                         
REARCH       ,:S-ITPA-RSLT-CURR-CD                                      
REARCH       ,:S-LAST-UPDATE-USERID                                     
REARCH       ,:S-LAST-UPDATE-TS                                         
REARCH       ,:S-LETTER-NOTIFY-CD                                       
REARCH       ,:S-LETTER-MAILED-DT                                       
REARCH       ,:S-ADV-CREDIT-LTR-DT                                      
REARCH       ,:S-COMPANY-NO                                             
C36013       ,:S-CR-SCORE-UPDATE-FL                                     
C36013       ,:S-CRED-CD-DESC                                           
C36013       ,:S-APPL-RESPONSE-TXT                                      
C36013       ,:S-APPL-STATUS-CD                                         
C36013       ,:S-SENIOR-FL                                              
C36013       ,:S-SAFESCAN-TXT                                           
C36013       ,:S-MATCH-TXT                                              
C36013       ,:S-HIT-TXT                                                
C36013       ,:S-REJECT-TXT                                             
C36013       ,:S-ERROR-TXT                                              
C36013       ,:S-ACTION-MSG-TX                                          
C36013       ,:S-LICENSE-NO                                             
C36013       ,:S-LICENSE-ST                                             
A01881       ,:S-RESP-SCRIPT-TXT                                        
P00453       ,:S-SPECIAL-OFFER-CD                                       
CVT000       )                                                          
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR02270_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,CR_HIST_TRAN_DT                                                   
MFA-TR*      ,CR_HIST_TRAN_TM                                                   
MFA-TR*      ,BEACON_SCORE                                                      
MFA-TR*      ,CR_BUREAU_CD                                                      
MFA-TR*      ,CR_ACTION_FL                                                      
MFA-TR*      ,CR_COMMENTS                                                       
MFA-TR*      ,CR_RQST_REASON_CD                                                 
MFA-TR*      ,USER_ID_CR_INIT_BY                                                
MFA-TR*      ,VENDOR_COMMENTS                                                   
MFA-TR*      ,SSN                                                               
MFA-TR*      ,SSN_MASK_FLAG                                                     
MFA-TR*      ,ACCOUNT_FL                                                        
MFA-TR*      ,ADV_CREDIT_LTR_FL                                                 
MFA-TR*      ,REG_GROUP_CD                                                      
MFA-TR*      ,ITPA_EXISTS_CD                                                    
MFA-TR*      ,ITPA_RSLT_CURR_CD                                                 
MFA-TR*      ,LAST_UPDATE_USERID                                                
MFA-TR*      ,LAST_UPDATE_TS                                                    
MFA-TR*      ,LETTER_NOTIFY_CD                                                  
MFA-TR*      ,LETTER_MAILED_DT                                                  
MFA-TR*      ,ADV_CREDIT_LTR_DT                                                 
MFA-TR*      ,COMPANY_NO                                                        
MFA-TR*      ,CR_SCORE_UPDATE_FL                                                
MFA-TR*      ,CRED_CD_DESC                                              01390000
MFA-TR*      ,APPL_RESPONSE_TXT                                         01390000
MFA-TR*      ,APPL_STATUS_CD                                            01390000
MFA-TR*      ,SENIOR_FL                                                 01390000
MFA-TR*      ,SAFESCAN_TXT                                              01390000
MFA-TR*      ,MATCH_TXT                                                 01390000
MFA-TR*      ,HIT_TXT                                                   01390000
MFA-TR*      ,REJECT_TXT                                                01390000
MFA-TR*      ,ERROR_TXT                                                 01390000
MFA-TR*      ,ACTION_MSG_TX                                             01390000
MFA-TR*      ,LICENSE_NO                                                        
MFA-TR*      ,LICENSE_ST                                                        
MFA-TR*      ,RESP_SCRIPT_TXT                                           01390000
MFA-TR*      ,SPECIAL_OFFER_CD                                                  
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE                                                    
MFA-TR*      ,:S-CR-HIST-TRAN-DT                                                
MFA-TR*      ,:S-CR-HIST-TRAN-TM                                                
MFA-TR*      ,:S-BEACON-SCORE                                                   
MFA-TR*      ,:S-CR-BUREAU-CD                                                   
MFA-TR*      ,:S-CR-ACTION-FL                                                   
MFA-TR*      ,:S-CR-COMMENTS                                                    
MFA-TR*      ,:S-CR-RQST-REASON-CD                                              
MFA-TR*      ,:S-USER-ID-CR-INIT-BY                                             
MFA-TR*      ,:S-VENDOR-COMMENTS                                                
MFA-TR*      ,:S-SSN                                                            
MFA-TR*      ,:S-SSN-MASK-FLAG                                                  
MFA-TR*      ,:S-ACCOUNT-FL                                                     
MFA-TR*      ,:S-ADV-CREDIT-LTR-FL                                              
MFA-TR*      ,:S-REG-GROUP-CD                                                   
MFA-TR*      ,:S-ITPA-EXISTS-CD                                                 
MFA-TR*      ,:S-ITPA-RSLT-CURR-CD                                              
MFA-TR*      ,:S-LAST-UPDATE-USERID                                             
MFA-TR*      ,:S-LAST-UPDATE-TS                                                 
MFA-TR*      ,:S-LETTER-NOTIFY-CD                                               
MFA-TR*      ,:S-LETTER-MAILED-DT                                               
MFA-TR*      ,:S-ADV-CREDIT-LTR-DT                                              
MFA-TR*      ,:S-COMPANY-NO                                                     
MFA-TR*      ,:S-CR-SCORE-UPDATE-FL                                             
MFA-TR*      ,:S-CRED-CD-DESC                                           01390000
MFA-TR*      ,:S-APPL-RESPONSE-TXT                                      01390000
MFA-TR*      ,:S-APPL-STATUS-CD                                         01390000
MFA-TR*      ,:S-SENIOR-FL                                              01390000
MFA-TR*      ,:S-SAFESCAN-TXT                                           01390000
MFA-TR*      ,:S-MATCH-TXT                                              01390000
MFA-TR*      ,:S-HIT-TXT                                                01390000
MFA-TR*      ,:S-REJECT-TXT                                             01390000
MFA-TR*      ,:S-ERROR-TXT                                              01390000
MFA-TR*      ,:S-ACTION-MSG-TX                                          01390000
MFA-TR*      ,:S-LICENSE-NO                                                     
MFA-TR*      ,:S-LICENSE-ST                                                     
MFA-TR*      ,:S-RESP-SCRIPT-TXT                                        01390000
MFA-TR*      ,:S-SPECIAL-OFFER-CD                                               
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
CVT000                                                                  
CVT000     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
CVT000        NEXT SENTENCE                                             
CVT000     ELSE                                                         
CVT000        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
CVT000        MOVE '8100'               TO ACTIVE-PARAGRAPH             
CVT000        MOVE 'INSERT'             TO ABEND-FUNCTION               
CVT000        MOVE 'CSR02270_R1'        TO TABLE-1                      
CVT000        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
CVT000     END-IF.                                                      
CVT000                                                                  
CVT000     ADD 1 TO CTR-ROWS.                                           
CVT000*                                                                 00002000
CVT000 8100-EXIT.                                                       
CVT000      EXIT.                                                       
CVT000******************************************************************00000100
CVT000* 8000A-DELETE-GTT-ROWS.                                         *00000200
CVT000******************************************************************00000300
CVT000 8000A-DELETE-GTT-ROWS.                                           
CVT000*                                                                 00000500
CVT000     MOVE                                                         
CVT000     'DELETE ROWS'                                                
CVT000         TO S-SQL-STATEMENT-V.                                    
CVT000*                                                                 00000900
CVT000      EXEC SQL                                                    
CVT000          DELETE FROM #CSR02270_R1                         
CVT000      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    00001000
MFA-TR*         DELETE FROM SESSION.CSR02270_R1                         00001100
MFA-TR*     END-EXEC.                                                   00001200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000*                                                                 00001300
CVT000      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
CVT000*                                                                 00001500
CVT000      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
CVT000          NEXT SENTENCE                                           
CVT000      ELSE                                                        
CVT000         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
CVT000         MOVE '8000A'              TO ACTIVE-PARAGRAPH            
CVT000         MOVE 'DELETE'             TO ABEND-FUNCTION              
CVT000         MOVE SPACES               TO ABEND-SQL-PREDICATES        
CVT000                                      ABEND-TABLES                
CVT000         MOVE 'CSR02270_R1'        TO TABLE-1                     
CVT000         MOVE SPACES               TO TABLE-ELEMENT-1             
CVT000         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
CVT000         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
CVT000     END-IF.                                                      
CVT000*                                                                 00003100
CVT000 8000A-EXIT.                                                      
CVT000     EXIT.                                                        
CVT000*                                                                 00003400
P00453******************************************************************        
P00453*  THIS COPYBOOK NEEDS TO BE USED BY PROGRAM WHERE WE ARE        *        
P00453*  RETURNING MULTIPLE ROWS.                                      *        
P00453******************************************************************        
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00320                                         00000200
CVT000     END-EXEC.                                                    00000300
