       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02263.                                         
COB303 DATE-WRITTEN.                                                    
COB303            DECEMBER 08, 1994.                                    
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
      *                                                                *00110000
      *  TRANID:        S263                                           *00120000
      *  PROGRAM:       S263                                           *00130000
      *  CALLING SP:    PD_INTERRUPTINTDETAILUPD                       *00140000
      *                                                                *00150000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *00190000
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *00200000
      *                                                                *00210000
      *  THIS PROGRAM INSERTS, OR UPDATES THE                          *00220000
      *  CSS_INTERRUPT TABLE BASED ON THE ACTION IN THE FIELD          *00230000
      *  PARM-ACTION.                                                  *00240000
      *                                                                *00250000
      ******************************************************************00260000
      *                                                                *00270000
      *                     PROGRAM MODIFICATION LOG                   *00280000
      *                                                                *00290000
      *    DATE    INITIALS   COMMENTS                                 *00300000
      *  --------  --------   ---------------------------------------  *00310000
      *  12/08/94    RAH      CREATED.                                 *00320000
CBSI  *  11/23/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE    *00330000
CBSI  *              MADRAS   ABEND PARAMETERS.                        *00340000
REARCH*  08/19/05    CVNS     RPC TO DB2 SP CONVERSION                 *00350000
REARCH*              CHENNAI                                           *00360000
P00496*  03/24/11    MS93554  DATA TYPE CHANGE ON POWER_COST COLUMN    *00370001
P00496*  07/14/11    SB93596  ADDING EXCEPTION_CD AS NEW INPUT TO      *00371001
P00496*                       AND USING IT IN INSERT/UPDATE            *00372001
P00496*                       FOR THE NEW COLUMN EXCEPTION_CD.         *00373001
P00496*  08/08/11    SB93596  MODFYING THE PROCEDURE TO UPDATE THE     *00374019
P00496*                       NON COMPLIANCE FIELD.                    *00375019
P00496*                       NON COMPLIANCE FIELD.                    *00375019
P00496*  08/09/11    MS93554  "DATE,TIME NOTIFIED" MADE IT AS OPTIONAL *00375019
      *                       IN PANLE 150 WHILE INSERT IN TO TABLE    *        
      ******************************************************************00380000
      ******************************************************************00390000
      *                                                                *00400000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00410000
      *                                                                *00420000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00430000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00440000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00450000
      *  3000 - 4999  NOT USED                                         *00460000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00470000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00480000
      *  7000 - 7999  INPUT MODULES                                    *00490000
      *  8000 - 8999  OUTPUT MODULES                                   *00500000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00510000
      *                                                                *00520000
      ******************************************************************00530000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02263'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02263 STARTS HERE'.                  
                                                                        
                                                                        
      ******************************************************************00630000
      *    DB2 INCLUDES                                                *00640000
      ******************************************************************00650000
                                                                        
           EXEC SQL                                                     00670000
              INCLUDE SQLCA                                             00680000
           END-EXEC.                                                    00690000
                                                                        
           EXEC SQL                                                     00710000
              INCLUDE TBINTRPT                                          00720000
           END-EXEC.                                                    00730000
                                                                        
           EXEC SQL                                                     00750000
              INCLUDE TBINTACT                                          00760000
           END-EXEC.                                                    00770000
                                                                        
      ******************************************************************00840000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00850000
      ******************************************************************00860000
                                                                        
           EXEC SQL                                                     00880000
              INCLUDE CWS00013                                          00890000
           END-EXEC.                                                    00900000
                                                                        
      ******************************************************************00920000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00930000
      ******************************************************************00940000
                                                                        
           COPY CCA00001.                                               00980000
           COPY CWS00027.                                               01000000
           COPY CWS00303.                                               01010000
REARCH     EXEC SQL                                                     01030000
REARCH          INCLUDE CWSX0010                                        01040000
REARCH     END-EXEC.                                                    01050000
                                                                        
      ******************************************************************01070000
      *    WORK AREAS                                                  *01080000
      ******************************************************************01090000
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
REARCH     05  PARM-ACCOUNT-NO-TMP     PIC X(13)  VALUE SPACES.         
REARCH     05  PARM-ACCOUNT-NO-NUM REDEFINES PARM-ACCOUNT-NO-TMP        
REARCH                                 PIC 9(13).                       
REARCH     05  PARM-TIME-BEFORE-TMP    PIC X(6)   VALUE SPACES.         
REARCH     05  PARM-TIME-BEFORE-RED REDEFINES PARM-TIME-BEFORE-TMP      
                                       PIC S9(4)V99.                    
REARCH     05  PARM-TIME-AFTER-TMP     PIC X(6)   VALUE SPACES.         
REARCH     05  PARM-TIME-AFTER-RED REDEFINES PARM-TIME-AFTER-TMP        
                                       PIC S9(4)V99.                    
                                                                        
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH      05  GTT-NAME                PIC X(26)                       
REARCH                                       VALUE                      
REARCH                                       'SESSION.CSR02263_R1'.     
REARCH      05  GTT-ROW.                                                
REARCH          49 GTT-ROW-LEN          PIC S9(04) COMP.                
REARCH          49 GTT-ROW-CHAR         PIC X(1024).                    
REARCH      05  GTT-SQLCODE             PIC S9(9) COMP.                 
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME            PIC X(08) VALUE 'CSR02263'.      
REARCH     05  WS-SQLSTATE             PIC X(05) VALUE SPACES.          
           05  WS-PARM-ACTION-IND      PIC X(1)  VALUE SPACE.           
           05  WS-ACCOUNT-NO-NUM       PIC S9(13) VALUE ZERO COMP-3.    
           05  WS-IC-NO                PIC S9(04) COMP VALUE ZERO.      
           05  WS-CODE-UTIL-TYPE       PIC X      VALUE SPACES.         
           05  WS-OLD-DATE             PIC X(10)  VALUE SPACES.         
           05  WS-OLD-TIME             PIC X(08)  VALUE SPACES.         
           05  WS-TIME-OFF             PIC X(08)  VALUE SPACES.         
           05  WS-TIME-ON              PIC X(08)  VALUE SPACES.         
           05  WS-FLAG                 PIC X(03)  VALUE SPACES.         
P00496     05  WS-NULL-NOTIFY-DATE     PIC S9(04) COMP VALUE +0.        
P00496     05  WS-NULL-NOTIFY-TIME     PIC S9(04) COMP VALUE +0.        
P00496     05  WS-YES-NULL             PIC S9(04) VALUE -1.             
           05  WS-INTERRUPT-TIME-ON.                                    
               07  WS-INT-TIME-ON-HH   PIC XX     VALUE SPACES.         
               07  WS-INT-TIME-ON-H1   PIC X      VALUE SPACES.         
               07  WS-INT-TIME-ON-MM   PIC XX     VALUE SPACES.         
               07  WS-INT-TIME-ON-H2   PIC X      VALUE SPACES.         
               07  WS-INT-TIME-ON-SS   PIC XX     VALUE SPACES.         
           05  WS-INTERRUPT-TIME-OFF.                                   
               07  WS-INT-TIME-OFF-HH  PIC XX     VALUE SPACES.         
               07  WS-INT-TIME-OFF-H1  PIC X      VALUE SPACES.         
               07  WS-INT-TIME-OFF-MM  PIC XX     VALUE SPACES.         
               07  WS-INT-TIME-OFF-H2  PIC X      VALUE SPACES.         
               07  WS-INT-TIME-OFF-SS  PIC XX     VALUE SPACES.         
           05  WS-NOTIFY-TIME.                                          
               07  WS-NOT-TIME-HH      PIC XX     VALUE SPACES.         
               07  WS-NOT-TIME-H1      PIC X      VALUE SPACES.         
               07  WS-NOT-TIME-MM      PIC XX     VALUE SPACES.         
               07  WS-NOT-TIME-H2      PIC X      VALUE SPACES.         
               07  WS-NOT-TIME-SS      PIC XX     VALUE SPACES.         
           05  WS-INTERRUPT-LOAD-TYP   PIC S9(4)  VALUE ZERO COMP.      
           05  WS-TIME-BEFORE          PIC S9(4)V99 COMP-3              
                                       VALUE ZERO.                      
           05  WS-TIME-AFTER           PIC S9(4)V99 COMP-3              
                                       VALUE ZERO.                      
           05  WS-INTERRUPT-DATE       PIC X(10)  VALUE SPACE.          
           05  WS-ZERO-TIME1           PIC X(8)   VALUE                 
               '00.00.00'.                                              
           05  WS-ZERO-TIME2           PIC X(8)   VALUE                 
               '00:00:00'.                                              
           05  WS-NOTIFY-NAME          PIC X(50)  VALUE SPACE.          
           05  WS-RESP-CUSTOMER        PIC X(254) VALUE SPACE.          
           05  WS-INTERRUPT-REASON     PIC X(254) VALUE SPACE.          
COB305     05 WS-POWER-COST        PIC S9(3)V9(6) USAGE COMP-3 VALUE 0.     
P00496     05  WS-INTERRUPT-TYPE       PIC X(02)  VALUE SPACES.         
P00496     05  WS-NON-COMPLIANCE-IND   PIC X(01)  VALUE SPACES.         
P00496     05  WS-NON-COMPLIANCE-CU    PIC X(01)  VALUE SPACES.         
           05  WS-REMARKS              PIC X(254) VALUE SPACE.          
           05  WS-TOTAL-YTD-HOURS      PIC S9(6)V99 COMP-3              
                                       VALUE ZERO.                      
CBSI       05  WS-TOTAL-YTD-HOURS-ED   PIC -Z(5)9.99.                   
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-ACTIVE-CODE          PIC X(01) VALUE 'A'.             
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-DUP-FLAG             PIC X(3)  VALUE SPACES.          
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
REARCH     05  S-DUP-FLAG             PIC X(3)  VALUE SPACES.           
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
REARCH 01  CSRERLOG-P.                                                  
REARCH      10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
REARCH      10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
REARCH      10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
REARCH      10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
REARCH      10  S-HOST-VARIABLES.                                       
REARCH          49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
REARCH          49  S-HOST-VARIABLES-V  PIC X(255).                     
REARCH      10  S-SQL-STATEMENT.                                        
REARCH          49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
REARCH          49  S-SQL-STATEMENT-V   PIC X(255).                     
REARCH      10  S-SQL-DESCRIPTION.                                      
REARCH          49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
REARCH          49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
       LINKAGE SECTION.                                                 
REARCH 01  PARM-ACTION-IND         PIC X(01).                           
REARCH 01  PARM-ACCOUNT-NO         PIC X(13).                           
REARCH 01  PARM-INTERRUPT-TIME-ON  PIC X(05).                           
REARCH 01  PARM-INTERRUPT-TIME-OFF PIC X(05).                           
REARCH 01  PARM-INTERRUPT-LOAD-TYP PIC S9(9) COMP.                      
REARCH 01  PARM-INTERRUPT-DATE     PIC X(10).                           
REARCH 01  PARM-NOTIFY-NAME        PIC X(50).                           
REARCH 01  PARM-NOTIFY-POSITION    PIC X(30).                           
REARCH 01  PARM-RESP-CUSTOMER      PIC X(254).                          
REARCH 01  PARM-INTERRUPT-REASON   PIC X(254).                          
COB305 01 PARM-POWER-COST        PIC S9(3)V9(6) USAGE COMP-3 VALUE 0.         
REARCH 01  PARM-REMARKS            PIC X(254).                          
REARCH 01  PARM-NOTIFY-DATE        PIC X(10).                           
REARCH 01  PARM-NOTIFY-TIME        PIC X(05).                           
REARCH 01  PARM-TIME-BEFORE        PIC X(06).                           
REARCH 01  PARM-TIME-AFTER         PIC X(06).                           
REARCH 01  PARM-IC-NO              PIC S9(9) COMP.                      
REARCH 01  PARM-CODE-UTIL-TYPE     PIC X(01).                           
REARCH 01  PARM-OLD-DATE           PIC X(10).                           
REARCH 01  PARM-OLD-TIME           PIC X(08).                           
REARCH 01  PARM-USER-ID-NOTIFY-BY  PIC X(07).                           
P00496 01  PARM-INTERRUPT-TYPE     PIC X(02).                           
P00496 01  PARM-NON-COMPLIANCE     PIC X(01).                           
                                                                        
REARCH PROCEDURE DIVISION USING                                         
REARCH                    PARM-ACTION-IND                               
REARCH                    PARM-ACCOUNT-NO                               
REARCH                    PARM-INTERRUPT-TIME-ON                        
REARCH                    PARM-INTERRUPT-TIME-OFF                       
REARCH                    PARM-INTERRUPT-LOAD-TYP                       
REARCH                    PARM-INTERRUPT-DATE                           
REARCH                    PARM-NOTIFY-NAME                              
REARCH                    PARM-NOTIFY-POSITION                          
REARCH                    PARM-RESP-CUSTOMER                            
REARCH                    PARM-INTERRUPT-REASON                         
REARCH                    PARM-POWER-COST                               
REARCH                    PARM-REMARKS                                  
REARCH                    PARM-NOTIFY-DATE                              
REARCH                    PARM-NOTIFY-TIME                              
REARCH                    PARM-TIME-BEFORE                              
REARCH                    PARM-TIME-AFTER                               
REARCH                    PARM-IC-NO                                    
REARCH                    PARM-CODE-UTIL-TYPE                           
REARCH                    PARM-OLD-DATE                                 
REARCH                    PARM-OLD-TIME                                 
REARCH                    PARM-USER-ID-NOTIFY-BY                        
P00496                    PARM-INTERRUPT-TYPE                           
P00496                    PARM-NON-COMPLIANCE.                          
      ******************************************************************03160000
      * 0000-MAINLINE                                                  *03170000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *03180000
      ******************************************************************03190000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03310000
      * 0100-INITIALIZE                                                *03320000
      *                                                                *03330000
      *     1. RESET DB2 ERROR HANDLERS                                *03340000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *03350000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *03360000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*03370000
      *                                                                *03380000
      ******************************************************************03390000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
REARCH     EXEC SQL                                                     
REARCH          DECLARE C1 CURSOR  FOR                       
REARCH          SELECT                                                  
REARCH               :S-RETURN-CODE      AS RETURN_CODE                 
REARCH              ,:S-DUP-FLAG         AS DUP_FLAG                    
REARCH          FROM                                                    
REARCH              CIS.SYSDUMMY1                                    
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                     03630000
MFA-TR*         DECLARE C1 CURSOR WITH RETURN FOR                       03640000
MFA-TR*         SELECT                                                  03650000
MFA-TR*              :S-RETURN-CODE      AS RETURN_CODE                 03660000
MFA-TR*             ,:S-DUP-FLAG         AS DUP_FLAG                    03670000
MFA-TR*         FROM                                                    03680000
MFA-TR*             SYSIBM.SYSDUMMY1                                    03691000
MFA-TR*    END-EXEC.                                                    03700000
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04080000
      * 1000-PROCESS-INPUT                                             *04090000
      *                                                                *04100000
      *     1. RECEIVE PARMS.                                          *04110000
      *                                                                *04120000
      ******************************************************************04130000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
REARCH     MOVE PARM-ACCOUNT-NO           TO PARM-ACCOUNT-NO-TMP.       
REARCH     MOVE PARM-TIME-BEFORE          TO PARM-TIME-BEFORE-TMP.      
REARCH     MOVE PARM-TIME-AFTER           TO PARM-TIME-AFTER-TMP.       
           MOVE PARM-ACCOUNT-NO-NUM       TO WS-ACCOUNT-NO-NUM.         
                                                                        
           MOVE PARM-INTERRUPT-TIME-OFF   TO WS-INTERRUPT-TIME-OFF.     
           MOVE ':' TO WS-INT-TIME-OFF-H2.                              
           MOVE '00' TO WS-INT-TIME-OFF-SS.                             
                                                                        
P00496     IF PARM-NOTIFY-DATE  = SPACES                                
P00496        MOVE WS-YES-NULL  TO WS-NULL-NOTIFY-DATE                  
P00496     END-IF.                                                      
P00496                                                                  
P00496     IF PARM-NOTIFY-TIME  = SPACES OR '00:00'                     
P00496        MOVE WS-YES-NULL  TO WS-NULL-NOTIFY-TIME                  
P00496     ELSE                                                         
P00496        MOVE PARM-NOTIFY-TIME   TO WS-NOTIFY-TIME                 
P00496        MOVE ':' TO WS-NOT-TIME-H2                                
P00496        MOVE '00' TO WS-NOT-TIME-SS                               
P00496     END-IF.                                                      
                                                                        
           IF PARM-INTERRUPT-TIME-ON = SPACES                           
               MOVE '00:00:00' TO WS-INTERRUPT-TIME-ON                  
           ELSE                                                         
               MOVE PARM-INTERRUPT-TIME-ON                              
                    TO WS-INTERRUPT-TIME-ON                             
               MOVE ':' TO WS-INT-TIME-ON-H2                            
               MOVE '00' TO WS-INT-TIME-ON-SS                           
           END-IF.                                                      
                                                                        
           MOVE PARM-INTERRUPT-LOAD-TYP                                 
                TO WS-INTERRUPT-LOAD-TYP.                               
           INSPECT PARM-TIME-BEFORE REPLACING ALL ' ' BY '0'.           
           IF PARM-TIME-BEFORE < ZERO                                   
               MOVE ZEROS TO WS-TIME-BEFORE                             
           ELSE                                                         
               MOVE PARM-TIME-BEFORE-RED TO WS-TIME-BEFORE              
           END-IF.                                                      
           INSPECT PARM-TIME-AFTER REPLACING ALL ' ' BY '0'.            
           IF PARM-TIME-AFTER < ZERO                                    
               MOVE ZEROS TO WS-TIME-AFTER                              
           ELSE                                                         
               MOVE PARM-TIME-AFTER-RED TO WS-TIME-AFTER                
           END-IF.                                                      
           MOVE PARM-IC-NO       TO WS-IC-NO.                           
           MOVE PARM-CODE-UTIL-TYPE TO WS-CODE-UTIL-TYPE.               
           MOVE PARM-OLD-DATE       TO WS-OLD-DATE.                     
           MOVE PARM-OLD-TIME       TO WS-OLD-TIME.                     
P00496     MOVE PARM-INTERRUPT-TYPE TO WS-INTERRUPT-TYPE.               
P00496     MOVE PARM-NON-COMPLIANCE TO WS-NON-COMPLIANCE-IND.           
                                                                        
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************07040000
      * 2000-PROCESS-OUTPUT.                                           *07050000
      ******************************************************************07060000
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 5000-UPDATE           THRU 5000-EXIT.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************07150000
REARCH* 2000A-MOVE-RESULT                                              *07160000
REARCH******************************************************************07170000
REARCH 2000A-MOVE-RESULT.                                               
REARCH       MOVE   RS-RETURN-CODE TO S-RETURN-CODE.                    
REARCH       MOVE   RS-DUP-FLAG    TO S-DUP-FLAG.                       
REARCH 2000A-EXIT.                                                      
REARCH       EXIT.                                                      
      ******************************************************************07760000
      * 5000-UPDATE                                                    *07770000
      ******************************************************************07780000
       5000-UPDATE.                                                     
                                                                        
           IF PARM-ACTION-IND = 'I'                                     
              MOVE SPACES TO WS-FLAG                                    
              PERFORM 7110-SELECT-DATE THRU 7110-EXIT                   
              MOVE 0 TO WS-ACTIVE-RETURN-CODE, SQLCODE                  
              MOVE WS-ACCOUNT-NO-NUM      TO IR-ACCOUNT-NO              
              MOVE WS-IC-NO               TO IR-IC-NO                   
              MOVE WS-CODE-UTIL-TYPE      TO IR-CODE-UTIL-TYPE          
              MOVE WS-INTERRUPT-TIME-ON   TO                            
                       IR-INTERRUPT-TIME-ON                             
              MOVE WS-INTERRUPT-TIME-OFF  TO                            
                   IR-INTERRUPT-TIME-OFF                                
P00496        IF WS-NULL-NOTIFY-TIME = WS-YES-NULL                      
P00496           CONTINUE                                               
P00496        ELSE                                                      
P00496           MOVE WS-NOTIFY-TIME      TO IR-NOTIFY-TIME             
P00496        END-IF                                                    
              MOVE WS-INTERRUPT-LOAD-TYP                                
                   TO IR-INTERRUPT-LOAD-TYP                             
              MOVE PARM-INTERRUPT-DATE    TO IR-INTERRUPT-DATE          
P00496        IF PARM-NOTIFY-NAME EQUAL LOW-VALUES OR HIGH-VALUES       
P00496           MOVE SPACES                TO IR-NOTIFY-NAME           
P00496        ELSE                                                      
P00496           MOVE PARM-NOTIFY-NAME      TO IR-NOTIFY-NAME           
P00496        END-IF                                                    
              MOVE PARM-NOTIFY-POSITION   TO IR-NOTIFY-POSITION         
P00496        IF PARM-RESP-CUSTOMER EQUAL LOW-VALUES OR HIGH-VALUES     
P00496           MOVE SPACES                TO IR-RESP-CUSTOMER         
P00496        ELSE                                                      
P00496           MOVE PARM-RESP-CUSTOMER    TO IR-RESP-CUSTOMER         
P00496        END-IF                                                    
P00496*       MOVE PARM-RESP-CUSTOMER     TO IR-RESP-CUSTOMER           07990000
P00496        IF PARM-INTERRUPT-REASON EQUAL LOW-VALUES OR HIGH-VALUES  
P00496           MOVE SPACES                TO IR-INTERRUPT-REASON      
P00496        ELSE                                                      
P00496           MOVE PARM-INTERRUPT-REASON TO IR-INTERRUPT-REASON      
P00496        END-IF                                                    
P00496*       MOVE PARM-INTERRUPT-REASON  TO                            08000000
P00496*            IR-INTERRUPT-REASON                                  08010000
              MOVE PARM-POWER-COST        TO IR-POWER-COST              
              MOVE PARM-REMARKS           TO IR-REMARKS-TEXT            
              MOVE LENGTH OF IR-REMARKS-TEXT TO IR-REMARKS-LEN          
              MOVE PARM-USER-ID-NOTIFY-BY TO                            
                   IR-USER-ID-NOTIFY-BY                                 
                                                                        
P00496        MOVE PARM-INTERRUPT-TYPE      TO IR-EXCEPTION-CD          
P00496        IF PARM-INTERRUPT-TYPE = 'GO'                             
P00496           MOVE PARM-NON-COMPLIANCE   TO IR-NON-COMPLIANCE-IND    
P00496        ELSE                                                      
P00496           MOVE 'N'  TO IR-NON-COMPLIANCE-IND                     
P00496        END-IF                                                    
                                                                        
              PERFORM 7120-INSERT-INTERRUPT THRU 7120-EXIT              
              PERFORM 7100-SELECT-INTERRUPT-ACCT                        
                      THRU 7100-EXIT                                    
              COMPUTE IP-TOTAL-YTD-HOURS =                              
                  (IP-TOTAL-YTD-HOURS + WS-TIME-AFTER)                  
              PERFORM 7150-UPDATE-INTERRUPT-ACCT THRU                   
                  7150-EXIT                                             
           ELSE                                                         
              IF PARM-ACTION-IND = 'U'                                  
                 MOVE SPACES TO WS-FLAG                                 
                 PERFORM 7115-SELECT-DATE THRU 7115-EXIT                
                 MOVE 0 TO WS-ACTIVE-RETURN-CODE, SQLCODE               
                 PERFORM 7000-SELECT-INTERRUPT THRU 7000-EXIT           
                 MOVE WS-IC-NO               TO IR-IC-NO                
                 MOVE WS-CODE-UTIL-TYPE      TO                         
                      IR-CODE-UTIL-TYPE                                 
                 MOVE WS-INTERRUPT-TIME-ON   TO                         
                      IR-INTERRUPT-TIME-ON                              
                 MOVE WS-INTERRUPT-TIME-OFF  TO                         
                      IR-INTERRUPT-TIME-OFF                             
                 MOVE WS-INTERRUPT-LOAD-TYP                             
                       TO IR-INTERRUPT-LOAD-TYP                         
P00496           IF WS-NULL-NOTIFY-TIME = WS-YES-NULL                   
P00496              CONTINUE                                            
P00496           ELSE                                                   
P00496              MOVE WS-NOTIFY-TIME      TO IR-NOTIFY-TIME          
P00496           END-IF                                                 
P00496           IF PARM-NOTIFY-DATE  > SPACES                          
P00496              MOVE PARM-NOTIFY-DATE TO IR-NOTIFY-DATE             
P00496              INITIALIZE   WS-NULL-NOTIFY-DATE                    
P00496           END-IF                                                 
                 MOVE PARM-INTERRUPT-DATE    TO                         
                      IR-INTERRUPT-DATE                                 
                 MOVE PARM-NOTIFY-NAME       TO IR-NOTIFY-NAME          
                 MOVE PARM-NOTIFY-POSITION   TO                         
                      IR-NOTIFY-POSITION                                
                 MOVE PARM-RESP-CUSTOMER     TO IR-RESP-CUSTOMER        
                 MOVE PARM-INTERRUPT-REASON  TO                         
                      IR-INTERRUPT-REASON                               
                 MOVE PARM-POWER-COST        TO IR-POWER-COST           
                 MOVE PARM-REMARKS           TO IR-REMARKS-TEXT         
                 MOVE LENGTH OF IR-REMARKS-TEXT TO                      
                      IR-REMARKS-LEN                                    
                 MOVE PARM-USER-ID-NOTIFY-BY TO                         
                      IR-USER-ID-NOTIFY-BY                              
                 IF PARM-INTERRUPT-TYPE  = 'GO'                         
P00496              MOVE PARM-NON-COMPLIANCE   TO IR-NON-COMPLIANCE-IND 
                 ELSE                                                   
P00496              PERFORM 7125-SELECT-NON-COMPLIANCE-CU THRU 7125-EXIT
P00496              MOVE WS-NON-COMPLIANCE-CU  TO IR-NON-COMPLIANCE-IND 
P00496           END-IF                                                 
                 PERFORM 7140-UPDATE-INTERRUPT THRU 7140-EXIT           
                 PERFORM 7100-SELECT-INTERRUPT-ACCT                     
                         THRU 7100-EXIT                                 
                 COMPUTE WS-TOTAL-YTD-HOURS =                           
                     (IP-TOTAL-YTD-HOURS - WS-TIME-BEFORE)              
                 COMPUTE WS-TOTAL-YTD-HOURS =                           
                     WS-TOTAL-YTD-HOURS + WS-TIME-AFTER                 
                 MOVE WS-TOTAL-YTD-HOURS TO IP-TOTAL-YTD-HOURS          
                 PERFORM 7150-UPDATE-INTERRUPT-ACCT THRU                
                     7150-EXIT                                          
              ELSE                                                      
                  MOVE PROGRAM-NAME    TO ABEND-PROGRAM                 
                  MOVE '5000'          TO ACTIVE-PARAGRAPH              
                  MOVE 'BAD PARM-ACTION'    TO ABEND-FUNCTION           
                  MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                  
                  MOVE 'PARM-ACTION-IND'    TO TABLE-ELEMENT-1          
                  MOVE PARM-ACTION-IND      TO HOSTVAR-ELEMENT-1        
                  PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE.                
           MOVE '5000'          TO ACTIVE-PARAGRAPH.                    
REARCH     PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT.                   
REARCH     ADD +1                        TO CTR-ROWS.                   
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08750000
      * 7000-SELECT-INTERRUPT                                          *08760000
      ******************************************************************08770000
                                                                        
       7000-SELECT-INTERRUPT.                                           
                                                                        
           EXEC SQL                                                     
              SELECT ACCOUNT_NO        ,                                
                     CODE_UTIL_TYPE    ,                                
                     IC_NO             ,                                
                     REPLACE(CONVERT(CHAR(8), INTERRUPT_TIME_ON, 108), 
           ':', '.') INTERRUPT_TIME_ON ,                                
                     REPLACE(CONVERT(CHAR(8), INTERRUPT_TIME_OFF, 108), 
           ':', '.') INTERRUPT_TIME_OFF,                                
                     INTERRUPT_LOAD_TYP,                                
                     INTERRUPT_DATE   ,                                 
                     NOTIFY_NAME      ,                                 
                     NOTIFY_POSITION  ,                                 
                     NON_COMPLIANCE_IND,                                
                     RESP_CUSTOMER    ,                                 
                     INTERRUPT_REASON ,                                 
                     POWER_COST       ,                                 
                     USER_ID_NOTIFY_BY,                                 
                     REMARKS          ,                                 
                     NOTIFY_DATE      ,                                 
P00496               REPLACE(CONVERT(CHAR(8), COALESCE(NOTIFY_TIME,
              CIS.CHAR2TIME('00:00:00')), 108), ':', '.')                     
              INTO   :IR-ACCOUNT-NO,                                    
                     :IR-CODE-UTIL-TYPE,                                
                     :IR-IC-NO,                                         
                     :IR-INTERRUPT-TIME-ON,                             
                     :IR-INTERRUPT-TIME-OFF,                            
                     :IR-INTERRUPT-LOAD-TYP,                            
                     :IR-INTERRUPT-DATE,                                
                     :IR-NOTIFY-NAME,                                   
                     :IR-NOTIFY-POSITION,                               
                     :IR-NON-COMPLIANCE-IND,                            
                     :IR-RESP-CUSTOMER,                                 
                     :IR-INTERRUPT-REASON,                              
                     :IR-POWER-COST,                                    
                     :IR-USER-ID-NOTIFY-BY,                             
                     :IR-REMARKS,                                       
P00496               :IR-NOTIFY-DATE :WS-NULL-NOTIFY-DATE,               
                     :IR-NOTIFY-TIME                                    
               FROM CSS_INTERRUPT WITH(READUNCOMMITTED)                         
               WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-NUM AND                
                     CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE AND            
                     IC_NO = :WS-IC-NO AND                              
                     INTERRUPT_DATE = IIF(TRY_CONVERT(DATE, :WS-OLD-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-OLD-DATE
              ) <> 0) OR (LEN(:WS-OLD-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-OLD-DATE
              ), CONVERT(DATE, :WS-OLD-DATE) )              
                 AND INTERRUPT_TIME_OFF = CIS.CHAR2TIME (:WS-OLD-TIME)          
P00496           AND EXCEPTION_CD   = :WS-INTERRUPT-TYPE                
P00496                                                           
P00496                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     08810000
MFA-TR*       SELECT ACCOUNT_NO        ,                                08820000
MFA-TR*              CODE_UTIL_TYPE    ,                                08830000
MFA-TR*              IC_NO             ,                                08840000
MFA-TR*              INTERRUPT_TIME_ON ,                                08850000
MFA-TR*              INTERRUPT_TIME_OFF,                                08860000
MFA-TR*              INTERRUPT_LOAD_TYP,                                08870000
MFA-TR*              INTERRUPT_DATE   ,                                 08880000
MFA-TR*              NOTIFY_NAME      ,                                 08890000
MFA-TR*              NOTIFY_POSITION  ,                                 08900000
MFA-TR*              NON_COMPLIANCE_IND,                                08910000
MFA-TR*              RESP_CUSTOMER    ,                                 08920000
MFA-TR*              INTERRUPT_REASON ,                                 08930000
MFA-TR*              POWER_COST       ,                                 08940000
MFA-TR*              USER_ID_NOTIFY_BY,                                 08950000
MFA-TR*              REMARKS          ,                                 08960000
MFA-TR*              NOTIFY_DATE      ,                                 08970000
MFA-TR*              IFNULL(NOTIFY_TIME,'00:00:00')                     08980006
MFA-TR*       INTO   :IR-ACCOUNT-NO,                                    08990000
MFA-TR*              :IR-CODE-UTIL-TYPE,                                09000000
MFA-TR*              :IR-IC-NO,                                         09010000
MFA-TR*              :IR-INTERRUPT-TIME-ON,                             09020000
MFA-TR*              :IR-INTERRUPT-TIME-OFF,                            09030000
MFA-TR*              :IR-INTERRUPT-LOAD-TYP,                            09040000
MFA-TR*              :IR-INTERRUPT-DATE,                                09050000
MFA-TR*              :IR-NOTIFY-NAME,                                   09060000
MFA-TR*              :IR-NOTIFY-POSITION,                               09070000
MFA-TR*              :IR-NON-COMPLIANCE-IND,                            09080000
MFA-TR*              :IR-RESP-CUSTOMER,                                 09090000
MFA-TR*              :IR-INTERRUPT-REASON,                              09100000
MFA-TR*              :IR-POWER-COST,                                    09110000
MFA-TR*              :IR-USER-ID-NOTIFY-BY,                             09120000
MFA-TR*              :IR-REMARKS,                                       09130000
MFA-TR*              :IR-NOTIFY-DATE:WS-NULL-NOTIFY-DATE,               09140000
MFA-TR*              :IR-NOTIFY-TIME                                    09150006
MFA-TR*        FROM CSS_INTERRUPT                                       09160000
MFA-TR*        WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-NUM AND                09170000
MFA-TR*              CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE AND            09180000
MFA-TR*              IC_NO = :WS-IC-NO AND                              09190000
MFA-TR*              INTERRUPT_DATE = DATE  (:WS-OLD-DATE)              09200000
MFA-TR*          AND INTERRUPT_TIME_OFF = TIME (:WS-OLD-TIME)           09210000
MFA-TR*          AND EXCEPTION_CD   = :WS-INTERRUPT-TYPE                09211002
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                    09220000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00496        IF WS-NULL-NOTIFY-DATE = WS-YES-NULL                      
P00496           MOVE SPACES      TO IR-NOTIFY-DATE                     
P00496        END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7000'          TO ACTIVE-PARAGRAPH                  
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_INTERRUPT'      TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'IC_NO'              TO TABLE-ELEMENT-2              
CBSI          MOVE 'INTERRUPT_DATE'     TO TABLE-ELEMENT-3              
CBSI          MOVE 'INTERRUPT_TIME_OFF' TO TABLE-ELEMENT-4              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              MOVE WS-IC-NO             TO HOSTVAR-ELEMENT-2            
CBSI          MOVE WS-OLD-DATE          TO HOSTVAR-ELEMENT-3            
CBSI          MOVE WS-OLD-TIME          TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************09470000
      * 7100-SELECT-INTERRUPT-ACCT.                                    *09480000
      ******************************************************************09490000
                                                                        
       7100-SELECT-INTERRUPT-ACCT.                                      
                                                                        
           EXEC SQL                                                     
              SELECT ACCOUNT_NO,                                        
                     CODE_UTIL_TYPE,                                    
                     IC_NO,                                             
                     TOTAL_YTD_HOURS                                    
              INTO   :IP-ACCOUNT-NO,                                    
                     :IP-CODE-UTIL-TYPE,                                
                     :IP-IC-NO,                                         
                     :IP-TOTAL-YTD-HOURS                                
               FROM CSS_INTERRUPT_ACCT WITH(READUNCOMMITTED)                    
               WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-NUM                    
                 AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                
                 AND IC_NO = :WS-IC-NO                                  
P00496                                                           
P00496                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     09530000
MFA-TR*       SELECT ACCOUNT_NO,                                        09540000
MFA-TR*              CODE_UTIL_TYPE,                                    09550000
MFA-TR*              IC_NO,                                             09560000
MFA-TR*              TOTAL_YTD_HOURS                                    09570000
MFA-TR*       INTO   :IP-ACCOUNT-NO,                                    09580000
MFA-TR*              :IP-CODE-UTIL-TYPE,                                09590000
MFA-TR*              :IP-IC-NO,                                         09600000
MFA-TR*              :IP-TOTAL-YTD-HOURS                                09610000
MFA-TR*        FROM CSS_INTERRUPT_ACCT                                  09620000
MFA-TR*        WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-NUM                    09630000
MFA-TR*          AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE                09640000
MFA-TR*          AND IC_NO = :WS-IC-NO                                  09650000
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                    09660000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7100'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_INTERRUPT_ACCT' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
CBSI          MOVE 'IC_NO'              TO TABLE-ELEMENT-3              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
CBSI          MOVE WS-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
CBSI          MOVE WS-IC-NO             TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************09890000
      * 7110-SELECT-DATE                                               *09900000
      ******************************************************************09910000
       7110-SELECT-DATE.                                                
                                                                        
           MOVE WS-INTERRUPT-TIME-ON TO WS-TIME-ON.                     
           MOVE WS-INTERRUPT-TIME-OFF TO WS-TIME-OFF.                   
           EXEC SQL                                                     
              SELECT 'YES'                                              
              INTO   :WS-FLAG                                           
               FROM CSS_INTERRUPT WITH(READUNCOMMITTED)                         
               WHERE ACCOUNT_NO         = :WS-ACCOUNT-NO-NUM            
               AND CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE              
               AND IC_NO              = :WS-IC-NO                       
               AND INTERRUPT_DATE = IIF(TRY_CONVERT(DATE, 
                                                   :PARM-INTERRUPT-DATE
              ) IS NULL OR (PATINDEX('%.%', :PARM-INTERRUPT-DATE
              ) <> 0) OR (LEN(:PARM-INTERRUPT-DATE
              ) <> 10), CIS.CHAR2DATE(:PARM-INTERRUPT-DATE
              ), CONVERT(DATE, :PARM-INTERRUPT-DATE) )          
               AND                                                      
               ( ( CIS.CHAR2TIME (:WS-TIME-OFF) > INTERRUPT_TIME_OFF            
                AND CIS.CHAR2TIME (:WS-TIME-OFF) < INTERRUPT_TIME_ON            
                AND INTERRUPT_TIME_ON <> CIS.CHAR2TIME(:WS-ZERO-TIME1))         
               OR ( CIS.CHAR2TIME (:WS-TIME-OFF) < INTERRUPT_TIME_OFF           
                 AND CIS.CHAR2TIME (:WS-TIME-ON) > INTERRUPT_TIME_OFF           
                 AND CIS.CHAR2TIME (:WS-TIME-ON) <>                             
                     CIS.CHAR2TIME(:WS-ZERO-TIME2)))                            
P00496                                                           
P00496                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ053
MFA-TR*    EXEC SQL                                                     09960000
MFA-TR*       SELECT 'YES'                                              09970000
MFA-TR*       INTO   :WS-FLAG                                           09980000
MFA-TR*        FROM CSS_INTERRUPT                                       09990000
MFA-TR*        WHERE ACCOUNT_NO         = :WS-ACCOUNT-NO-NUM            10000000
MFA-TR*        AND CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE              10010000
MFA-TR*        AND IC_NO              = :WS-IC-NO                       10020000
MFA-TR*        AND INTERRUPT_DATE = DATE(:PARM-INTERRUPT-DATE)          10030000
MFA-TR*        AND                                                      10040000
MFA-TR*        ( ( TIME (:WS-TIME-OFF) > INTERRUPT_TIME_OFF             10050000
MFA-TR*         AND TIME (:WS-TIME-OFF) < INTERRUPT_TIME_ON             10060000
MFA-TR*         AND INTERRUPT_TIME_ON = TIME(:WS-ZERO-TIME1))          10070000
MFA-TR*        OR ( TIME (:WS-TIME-OFF) < INTERRUPT_TIME_OFF            10080000
MFA-TR*          AND TIME (:WS-TIME-ON) > INTERRUPT_TIME_OFF            10090000
MFA-TR*          AND TIME (:WS-TIME-ON) =                              10100000
MFA-TR*              TIME(:WS-ZERO-TIME2)))                             10110000
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7110                                                       
MFA-TR*    END-EXEC.                                                    10120000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              OR WS-ACTIVE-RETURN-CODE = +100 OR                        
              WS-ACTIVE-RETURN-CODE = -811                              
              IF WS-FLAG = 'YES'                                        
                  MOVE 'ERR' TO RS-DUP-FLAG                             
REARCH            PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT             
REARCH            ADD +1                    TO CTR-ROWS                 
                  PERFORM 9999-END-PROGRAM                              
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CBSI          MOVE '7110'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_INTERRUPT'      TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'IC_NO'              TO TABLE-ELEMENT-2              
CBSI          MOVE 'INTERRUPT_DATE'     TO TABLE-ELEMENT-3              
CBSI          MOVE 'INTERRUPT_TIME_OFF' TO TABLE-ELEMENT-4              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              MOVE WS-IC-NO             TO HOSTVAR-ELEMENT-2            
CBSI          MOVE PARM-INTERRUPT-DATE  TO HOSTVAR-ELEMENT-3            
CBSI          MOVE WS-TIME-OFF          TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************10460000
      * 7115-SELECT-DATE                                               *10470000
      ******************************************************************10480000
       7115-SELECT-DATE.                                                
                                                                        
           MOVE WS-INTERRUPT-TIME-ON TO WS-TIME-ON.                     
           MOVE WS-INTERRUPT-TIME-OFF TO WS-TIME-OFF.                   
           EXEC SQL                                                     
              SELECT 'YES'                                              
              INTO   :WS-FLAG                                           
               FROM CSS_INTERRUPT WITH(READUNCOMMITTED)                         
               WHERE ACCOUNT_NO         = :WS-ACCOUNT-NO-NUM            
               AND CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE              
               AND IC_NO              = :WS-IC-NO                       
               AND INTERRUPT_DATE = IIF(TRY_CONVERT(DATE, 
                                                   :PARM-INTERRUPT-DATE
              ) IS NULL OR (PATINDEX('%.%', :PARM-INTERRUPT-DATE
              ) <> 0) OR (LEN(:PARM-INTERRUPT-DATE
              ) <> 10), CIS.CHAR2DATE(:PARM-INTERRUPT-DATE
              ), CONVERT(DATE, :PARM-INTERRUPT-DATE) )          
               AND (INTERRUPT_DATE <> IIF(TRY_CONVERT(DATE, :WS-OLD-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-OLD-DATE
              ) <> 0) OR (LEN(:WS-OLD-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-OLD-DATE
              ), CONVERT(DATE, :WS-OLD-DATE) )                
                 OR INTERRUPT_TIME_OFF <> CIS.CHAR2TIME(:WS-OLD-TIME))          
               AND                                                      
                 ( ( CIS.CHAR2TIME (:WS-TIME-OFF) > INTERRUPT_TIME_OFF          
                 AND CIS.CHAR2TIME (:WS-TIME-OFF) < INTERRUPT_TIME_ON           
                 AND INTERRUPT_TIME_ON <> CIS.CHAR2TIME(:WS-ZERO-TIME1))        
                 OR ( CIS.CHAR2TIME (:WS-TIME-OFF) < INTERRUPT_TIME_OFF         
                  AND CIS.CHAR2TIME (:WS-TIME-ON) > INTERRUPT_TIME_OFF          
                  AND CIS.CHAR2TIME(:WS-TIME-ON) <>                             
                  CIS.CHAR2TIME(:WS-ZERO-TIME2) ) )                             
P00496                                                           
P00496                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ053
MFA-TR*    EXEC SQL                                                     10530000
MFA-TR*       SELECT 'YES'                                              10540000
MFA-TR*       INTO   :WS-FLAG                                           10550000
MFA-TR*        FROM CSS_INTERRUPT                                       10560000
MFA-TR*        WHERE ACCOUNT_NO         = :WS-ACCOUNT-NO-NUM            10570000
MFA-TR*        AND CODE_UTIL_TYPE     = :WS-CODE-UTIL-TYPE              10580000
MFA-TR*        AND IC_NO              = :WS-IC-NO                       10590000
MFA-TR*        AND INTERRUPT_DATE = DATE(:PARM-INTERRUPT-DATE)          10600000
MFA-TR*        AND (INTERRUPT_DATE = DATE(:WS-OLD-DATE)                10610000
MFA-TR*          OR INTERRUPT_TIME_OFF = TIME(:WS-OLD-TIME))           10620000
MFA-TR*        AND                                                      10630000
MFA-TR*          ( ( TIME (:WS-TIME-OFF) > INTERRUPT_TIME_OFF           10640000
MFA-TR*          AND TIME (:WS-TIME-OFF) < INTERRUPT_TIME_ON            10650000
MFA-TR*          AND INTERRUPT_TIME_ON = TIME(:WS-ZERO-TIME1))         10660000
MFA-TR*          OR ( TIME (:WS-TIME-OFF) < INTERRUPT_TIME_OFF          10670000
MFA-TR*           AND TIME (:WS-TIME-ON) > INTERRUPT_TIME_OFF           10680000
MFA-TR*           AND TIME(:WS-TIME-ON) =                              10690000
MFA-TR*           TIME(:WS-ZERO-TIME2) ) )                              10700000
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7115                                                      
MFA-TR*    END-EXEC.                                                    10710000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
              WS-ACTIVE-RETURN-CODE = +100 OR                           
              WS-ACTIVE-RETURN-CODE = -811                              
              IF WS-FLAG = 'YES'                                        
                  MOVE 'ERR' TO RS-DUP-FLAG                             
REARCH            PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT             
REARCH            ADD +1                    TO CTR-ROWS                 
                  PERFORM 9999-END-PROGRAM                              
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CBSI          MOVE '7115'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_INTERRUPT'      TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'IC_NO'              TO TABLE-ELEMENT-2              
CBSI          MOVE 'INTERRUPT_DATE'     TO TABLE-ELEMENT-3              
CBSI          MOVE 'INTERRUPT_TIME_OFF' TO TABLE-ELEMENT-4              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              MOVE WS-IC-NO             TO HOSTVAR-ELEMENT-2            
CBSI          MOVE PARM-INTERRUPT-DATE  TO HOSTVAR-ELEMENT-3            
CBSI          MOVE WS-TIME-OFF          TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7115-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************11060000
      * 7120-INSERT-INTERRUPT                                          *11070000
      ******************************************************************11080000
       7120-INSERT-INTERRUPT.                                           
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_INTERRUPT                                 
                     (    ACCOUNT_NO        ,                           
                          CODE_UTIL_TYPE    ,                           
                          IC_NO             ,                           
                          INTERRUPT_TIME_ON ,                           
                          INTERRUPT_TIME_OFF,                           
                          INTERRUPT_LOAD_TYP,                           
                          INTERRUPT_DATE    ,                           
                          NOTIFY_NAME       ,                           
                          NOTIFY_POSITION   ,                           
                          RESP_CUSTOMER     ,                           
                          INTERRUPT_REASON  ,                           
                          POWER_COST        ,                           
                          USER_ID_NOTIFY_BY ,                           
                          REMARKS           ,                           
                          NOTIFY_DATE       ,                           
                          NOTIFY_TIME       ,                           
P00496                    EXCEPTION_CD      ,                           
P00496                    NON_COMPLIANCE_IND )                          
              VALUES (:IR-ACCOUNT-NO,                                   
                      :IR-CODE-UTIL-TYPE,                               
                      :IR-IC-NO,                                        
                      CIS.CHAR2TIME(:IR-INTERRUPT-TIME-ON),                     
                      CIS.CHAR2TIME(:IR-INTERRUPT-TIME-OFF),                    
                      :IR-INTERRUPT-LOAD-TYP,                           
                      IIF(TRY_CONVERT(DATE, :IR-INTERRUPT-DATE
              ) IS NULL OR (PATINDEX('%.%', :IR-INTERRUPT-DATE
              ) <> 0) OR (LEN(:IR-INTERRUPT-DATE
              ) <> 10), CIS.CHAR2DATE(:IR-INTERRUPT-DATE
              ), CONVERT(DATE, :IR-INTERRUPT-DATE) ),                          
                      :IR-NOTIFY-NAME,                                  
                      :IR-NOTIFY-POSITION,                              
                      :IR-RESP-CUSTOMER,                                
                      :IR-INTERRUPT-REASON,                             
                      :IR-POWER-COST,                                   
                      :IR-USER-ID-NOTIFY-BY,                            
                      :IR-REMARKS,                                      
P00496                IIF(TRY_CONVERT(DATE, :IR-NOTIFY-DATE 
                                            :WS-NULL-NOTIFY-DATE
              ) IS NULL OR (PATINDEX('%.%', :IR-NOTIFY-DATE 
                                                   :WS-NULL-NOTIFY-DATE
              ) <> 0) OR (LEN(:IR-NOTIFY-DATE :WS-NULL-NOTIFY-DATE
              ) <> 10), CIS.CHAR2DATE(:IR-NOTIFY-DATE 
                                                   :WS-NULL-NOTIFY-DATE
              ), CONVERT(DATE, :IR-NOTIFY-DATE :WS-NULL-NOTIFY-DATE) ),        
P00496                CIS.CHAR2TIME(:IR-NOTIFY-TIME :WS-NULL-NOTIFY-TIME
              ),              
P00496                :IR-EXCEPTION-CD,                                 
P00496                :IR-NON-COMPLIANCE-IND)                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     11110000
MFA-TR*       INSERT INTO CSS_INTERRUPT                                 11120000
MFA-TR*              (    ACCOUNT_NO        ,                           11130000
MFA-TR*                   CODE_UTIL_TYPE    ,                           11140000
MFA-TR*                   IC_NO             ,                           11150000
MFA-TR*                   INTERRUPT_TIME_ON ,                           11160000
MFA-TR*                   INTERRUPT_TIME_OFF,                           11170000
MFA-TR*                   INTERRUPT_LOAD_TYP,                           11180000
MFA-TR*                   INTERRUPT_DATE    ,                           11190000
MFA-TR*                   NOTIFY_NAME       ,                           11200000
MFA-TR*                   NOTIFY_POSITION   ,                           11210000
MFA-TR*                   RESP_CUSTOMER     ,                           11220000
MFA-TR*                   INTERRUPT_REASON  ,                           11230000
MFA-TR*                   POWER_COST        ,                           11240000
MFA-TR*                   USER_ID_NOTIFY_BY ,                           11250000
MFA-TR*                   REMARKS           ,                           11260000
MFA-TR*                   NOTIFY_DATE       ,                           11270000
MFA-TR*                   NOTIFY_TIME       ,                           11280000
MFA-TR*                   EXCEPTION_CD      ,                           11281008
MFA-TR*                   NON_COMPLIANCE_IND )                          11282008
MFA-TR*       VALUES (:IR-ACCOUNT-NO,                                   11290000
MFA-TR*               :IR-CODE-UTIL-TYPE,                               11300000
MFA-TR*               :IR-IC-NO,                                        11310000
MFA-TR*               :IR-INTERRUPT-TIME-ON,                            11320000
MFA-TR*               :IR-INTERRUPT-TIME-OFF,                           11330000
MFA-TR*               :IR-INTERRUPT-LOAD-TYP,                           11340000
MFA-TR*               :IR-INTERRUPT-DATE,                               11350000
MFA-TR*               :IR-NOTIFY-NAME,                                  11360000
MFA-TR*               :IR-NOTIFY-POSITION,                              11370000
MFA-TR*               :IR-RESP-CUSTOMER,                                11380000
MFA-TR*               :IR-INTERRUPT-REASON,                             11390000
MFA-TR*               :IR-POWER-COST,                                   11400000
MFA-TR*               :IR-USER-ID-NOTIFY-BY,                            11410000
MFA-TR*               :IR-REMARKS,                                      11420000
MFA-TR*               :IR-NOTIFY-DATE:WS-NULL-NOTIFY-DATE,              11430000
MFA-TR*               :IR-NOTIFY-TIME:WS-NULL-NOTIFY-TIME,              11440000
MFA-TR*               :IR-EXCEPTION-CD,                                 11441008
MFA-TR*               :IR-NON-COMPLIANCE-IND)                           11442008
MFA-TR*    END-EXEC.                                                    11450000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7120'          TO ACTIVE-PARAGRAPH                  
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_INTERRUPT'      TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'IC_NO'              TO TABLE-ELEMENT-2              
CBSI          MOVE 'INTERRUPT_DATE'     TO TABLE-ELEMENT-3              
CBSI          MOVE 'INTERRUPT_TIME_OFF' TO TABLE-ELEMENT-4              
              MOVE IR-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE IR-IC-NO             TO HOSTVAR-ELEMENT-2            
CBSI          MOVE IR-INTERRUPT-DATE    TO HOSTVAR-ELEMENT-3            
CBSI          MOVE IR-INTERRUPT-TIME-OFF                                
CBSI                                    TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00496******************************************************************11711012
P00496* 7125-SELECT-NON-COMPLIANCE-CU.                                 *11712012
P00496******************************************************************11713012
P00496                                                                  
P00496 7125-SELECT-NON-COMPLIANCE-CU.                                   
P00496                                                                  
P00496     EXEC SQL                                                     
P00496        SELECT NON_COMPLIANCE_IND                                 
P00496          INTO :WS-NON-COMPLIANCE-CU                              
P00496          FROM CSS_INTERRUPT WITH(READUNCOMMITTED)                        
P00496         WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-NUM AND                
P00496               CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE AND            
P00496               IC_NO = :WS-IC-NO AND                              
P00496               INTERRUPT_DATE = IIF(TRY_CONVERT(DATE, :WS-OLD-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-OLD-DATE
              ) <> 0) OR (LEN(:WS-OLD-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-OLD-DATE
              ), CONVERT(DATE, :WS-OLD-DATE) )              
P00496           AND INTERRUPT_TIME_OFF = CIS.CHAR2TIME (:WS-OLD-TIME)          
P00496           AND EXCEPTION_CD   = :WS-INTERRUPT-TYPE                
P00496                                                           
P00496                                                      
P00496     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     11717012
MFA-TR*       SELECT NON_COMPLIANCE_IND                                 11718012
MFA-TR*         INTO :WS-NON-COMPLIANCE-CU                              11720613
MFA-TR*         FROM CSS_INTERRUPT                                      11722313
MFA-TR*        WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-NUM AND                11722412
MFA-TR*              CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE AND            11722512
MFA-TR*              IC_NO = :WS-IC-NO AND                              11722612
MFA-TR*              INTERRUPT_DATE = DATE  (:WS-OLD-DATE)              11722712
MFA-TR*          AND INTERRUPT_TIME_OFF = TIME (:WS-OLD-TIME)           11722812
MFA-TR*          AND EXCEPTION_CD   = :WS-INTERRUPT-TYPE                11722912
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7125                                                       
MFA-TR*    END-EXEC.                                                    11723012

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00496                                                                  
P00496     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00496                                                                  
P00496     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00496        NEXT SENTENCE                                             
P00496     ELSE                                                         
P00496        MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
P00496        MOVE '7125'          TO ACTIVE-PARAGRAPH                  
P00496        MOVE 'SELECT'             TO ABEND-FUNCTION               
P00496        MOVE 'CSS_INTERRUPT'      TO TABLE-1                      
P00496        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
P00496        MOVE 'IC_NO'              TO TABLE-ELEMENT-2              
P00496        MOVE 'INTERRUPT_DATE'     TO TABLE-ELEMENT-3              
P00496        MOVE 'INTERRUPT_TIME_OFF' TO TABLE-ELEMENT-4              
P00496        MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
P00496        MOVE WS-IC-NO             TO HOSTVAR-ELEMENT-2            
P00496        MOVE WS-OLD-DATE          TO HOSTVAR-ELEMENT-3            
P00496        MOVE WS-OLD-TIME          TO HOSTVAR-ELEMENT-4            
P00496        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00496        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00496     END-IF.                                                      
P00496                                                                  
P00496 7125-EXIT.                                                       
P00496     EXIT.                                                        
      ******************************************************************11726000
      * 7140-UPDATE-INTERRUPT                                          *11730000
      ******************************************************************11740000
       7140-UPDATE-INTERRUPT.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_INTERRUPT                                      
                SET INTERRUPT_TIME_ON  = CIS.CHAR2TIME(
                                                  :IR-INTERRUPT-TIME-ON
              ),         
                    INTERRUPT_TIME_OFF = CIS.CHAR2TIME(
                                                 :IR-INTERRUPT-TIME-OFF
              ),        
                    INTERRUPT_LOAD_TYP = :IR-INTERRUPT-LOAD-TYP,        
                    INTERRUPT_DATE     = IIF(TRY_CONVERT(DATE, 
                                                     :IR-INTERRUPT-DATE
              ) IS NULL OR (PATINDEX('%.%', :IR-INTERRUPT-DATE
              ) <> 0) OR (LEN(:IR-INTERRUPT-DATE
              ) <> 10), CIS.CHAR2DATE(:IR-INTERRUPT-DATE
              ), CONVERT(DATE, :IR-INTERRUPT-DATE) ),            
                    NOTIFY_NAME        = :IR-NOTIFY-NAME,               
                    NOTIFY_POSITION    = :IR-NOTIFY-POSITION,           
                    RESP_CUSTOMER      = :IR-RESP-CUSTOMER,             
                    INTERRUPT_REASON   = :IR-INTERRUPT-REASON,          
                    POWER_COST         = :IR-POWER-COST,                
                    USER_ID_NOTIFY_BY  = :IR-USER-ID-NOTIFY-BY,         
                    REMARKS            = :IR-REMARKS,                   
                    NOTIFY_DATE        = IIF(TRY_CONVERT(DATE, 
                                                       :IR-NOTIFY-DATE 
                                                   :WS-NULL-NOTIFY-DATE
              ) IS NULL OR (PATINDEX('%.%', :IR-NOTIFY-DATE 
                                                   :WS-NULL-NOTIFY-DATE
              ) <> 0) OR (LEN(:IR-NOTIFY-DATE :WS-NULL-NOTIFY-DATE
              ) <> 10), CIS.CHAR2DATE(:IR-NOTIFY-DATE 
                                                   :WS-NULL-NOTIFY-DATE
              ), CONVERT(DATE, :IR-NOTIFY-DATE :WS-NULL-NOTIFY-DATE) ),        
P00496              NOTIFY_TIME        = CIS.CHAR2TIME(:IR-NOTIFY-TIME 
                                                   :WS-NULL-NOTIFY-TIME
              ),          
P00496              NON_COMPLIANCE_IND = :IR-NON-COMPLIANCE-IND         
              WHERE ACCOUNT_NO     = :WS-ACCOUNT-NO-NUM AND             
                    CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE AND             
                    IC_NO          = :WS-IC-NO AND                      
                    INTERRUPT_DATE = IIF(TRY_CONVERT(DATE, :WS-OLD-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-OLD-DATE
              ) <> 0) OR (LEN(:WS-OLD-DATE) <> 10), CIS.CHAR2DATE(
                                                           :WS-OLD-DATE
              ), CONVERT(DATE, :WS-OLD-DATE) ) AND            
                    INTERRUPT_TIME_OFF = CIS.CHAR2TIME (
                                                      :WS-OLD-TIME) AND        
P00496              EXCEPTION_CD   = :WS-INTERRUPT-TYPE                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     11770000
MFA-TR*       UPDATE CSS_INTERRUPT                                      11780000
MFA-TR*         SET INTERRUPT_TIME_ON  = :IR-INTERRUPT-TIME-ON,         11790000
MFA-TR*             INTERRUPT_TIME_OFF = :IR-INTERRUPT-TIME-OFF,        11800000
MFA-TR*             INTERRUPT_LOAD_TYP = :IR-INTERRUPT-LOAD-TYP,        11810000
MFA-TR*             INTERRUPT_DATE     = :IR-INTERRUPT-DATE,            11820000
MFA-TR*             NOTIFY_NAME        = :IR-NOTIFY-NAME,               11830000
MFA-TR*             NOTIFY_POSITION    = :IR-NOTIFY-POSITION,           11840000
MFA-TR*             RESP_CUSTOMER      = :IR-RESP-CUSTOMER,             11850000
MFA-TR*             INTERRUPT_REASON   = :IR-INTERRUPT-REASON,          11860000
MFA-TR*             POWER_COST         = :IR-POWER-COST,                11870000
MFA-TR*             USER_ID_NOTIFY_BY  = :IR-USER-ID-NOTIFY-BY,         11880000
MFA-TR*             REMARKS            = :IR-REMARKS,                   11890000
MFA-TR*             NOTIFY_DATE        = :IR-NOTIFY-DATE                        
MFA-TR*                                  :WS-NULL-NOTIFY-DATE,                  
MFA-TR*             NOTIFY_TIME        = :IR-NOTIFY-TIME                11910008
MFA-TR*                                  :WS-NULL-NOTIFY-TIME,                  
MFA-TR*             NON_COMPLIANCE_IND = :IR-NON-COMPLIANCE-IND         11911008
MFA-TR*       WHERE ACCOUNT_NO     = :WS-ACCOUNT-NO-NUM AND             11920000
MFA-TR*             CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE AND             11930000
MFA-TR*             IC_NO          = :WS-IC-NO AND                      11940000
MFA-TR*             INTERRUPT_DATE = DATE (:WS-OLD-DATE) AND            11950000
MFA-TR*             INTERRUPT_TIME_OFF = TIME (:WS-OLD-TIME) AND        11960000
MFA-TR*             EXCEPTION_CD   = :WS-INTERRUPT-TYPE                 11961002
MFA-TR*    END-EXEC.                                                    11970000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7140'          TO ACTIVE-PARAGRAPH                  
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_INTERRUPT'      TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'IC_NO'              TO TABLE-ELEMENT-2              
              MOVE 'INTERRUPT_DATE'     TO TABLE-ELEMENT-3              
              MOVE 'INTERRUPT_TIME_OFF' TO TABLE-ELEMENT-4              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              MOVE WS-IC-NO             TO HOSTVAR-ELEMENT-2            
CBSI          MOVE WS-OLD-DATE          TO HOSTVAR-ELEMENT-3            
CBSI          MOVE WS-OLD-TIME          TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7140-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************12230000
      * 7150-UPDATE-INTERRUPT-ACCT                                     *12240000
      ******************************************************************12250000
       7150-UPDATE-INTERRUPT-ACCT.                                      
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_INTERRUPT_ACCT                                 
                SET TOTAL_YTD_HOURS    = :IP-TOTAL-YTD-HOURS            
              WHERE ACCOUNT_NO   = :WS-ACCOUNT-NO-NUM AND               
                    CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE AND             
                    IC_NO = :WS-IC-NO                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7150'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_INTERRUPT_ACCT' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
CBSI          MOVE 'IC_NO'              TO TABLE-ELEMENT-3              
CBSI          MOVE 'TOTAL_YTD_HOURS'    TO TABLE-ELEMENT-4              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
CBSI          MOVE WS-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
CBSI          MOVE WS-IC-NO             TO HOSTVAR-ELEMENT-3            
CBSI          MOVE IP-TOTAL-YTD-HOURS   TO WS-TOTAL-YTD-HOURS-ED        
CBSI          MOVE WS-TOTAL-YTD-HOURS-ED                                
CBSI                                    TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************13290000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *13300000
      ******************************************************************13310000
REARCH     EXEC SQL                                                     13350000
REARCH         INCLUDE CPDSP300                                         13360000
REARCH     END-EXEC.                                                    13370000
                                                                        
      ******************************************************************13390000
      *       END PROGRAM COPYLIB                                      *13400000
      ******************************************************************13410000
REARCH     EXEC SQL                                                     13430000
REARCH          INCLUDE CPD00321                                        13440000
REARCH     END-EXEC.                                                    13450000
                                                                        
