       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02257.                                         
COB303 DATE-WRITTEN.                                                    
COB303            JANUARY 19, 1995.                                     
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S257 CONVERTED TO DB2 SP CSR02257 ON 06/15/2006        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
      *                                                                *00110000
      *  TRANID:        S257                                           *00120000
      *  PROGRAM:       S257                                           *00130000
      *  CALLING SP:    PA_S257                                        *00140000
      *                                                                *00150000
      *                                                                *00160000
      *                                                                *00170000
      ******************************************************************00180000
      *                 P R O G R A M  S U M M A R Y                   *00190000
      *                                                                *00200000
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *00210000
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *00220000
      *                                                                *00230000
      *  THIS PROGRAM DETERMINES IF A PROSPECTIVE CUSTOMER EITHER      *00240000
      *     1) ALREADY EXISTS AS A CUSTOMER.                           *00250000
      *     2) IS LINKED TO AN ACCOUNT.                                *00260000
      *     3) IS LINKED TO AN ACCOUNT THAT IS WRITE-OFF,              *00261000
      *        BANKRUPT, OR JUDGMENT.                                  *00262000
      *                                                                *00263100
      ******************************************************************00270000
      *                                                                *00280000
      *                     PROGRAM MODIFICATION LOG                   *00290000
      *                                                                *00300000
      *    DATE    INITIALS   COMMENTS                                 *00310000
      *  --------  --------   ---------------------------------------  *00320000
      *  01/19/95    JHR      ORIGINALLY CREATED.                      *00330000
      *  08/04/95    TCB      CHANGED CHECK-BAD AND CHECK-NORM TO USE  *00331000
      *                       TO USE 'CUSTOMER_TYPE IN ('R','S')       *00332000
      *                       INSTEAD OF CHECKING INDIVIDUALLY.        *00333000
T16222*  05/01/98    FB       REWORKED 7100- ROUTINE TO PROCESS KEY    *00334000
T16222*                       FIELDS INDIVIDUALLY.                     *00335000
T16858*  06/17/98    FB       PROGRAM WAS HANDLING WS-RETURN-CODE      *00334000
T16858*                       INCORRECTLY.  MOVED THE SQLCODE INTO IT  *00335000
T16858*                       ONLY WHEN THERE IS A DATABASE ERROR.     *00335000
CBSI  *  11/27/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *             MADRAS    ABEND PARAMETERS                         *        
      *                                                                *00340000
      ******************************************************************00350000
      ******************************************************************00360000
      *                                                                *00370000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00380000
      *                                                                *00390000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00400000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00410000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00420000
      *  3000 - 4999  NOT USED                                         *00430000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00440000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00450000
      *  7000 - 7999  INPUT MODULES                                    *00460000
      *  8000 - 8999  OUTPUT MODULES                                   *00470000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00480000
      *                                                                *00490000
      ******************************************************************00500000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02257'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                               PIC X(40) VALUE       
           'WORKING STORAGE FOR RPC S257 STARTS HERE'.                  
                                                                        
                                                                        
      ******************************************************************00600000
      *    DB2 INCLUDES                                                *00610000
      ******************************************************************00620000
                                                                        
           EXEC SQL                                                     00640000
              INCLUDE SQLCA                                             00650000
           END-EXEC.                                                    00660000
                                                                        
           EXEC SQL                                                     00720000
              INCLUDE TBMODEL                                           00730000
           END-EXEC.                                                    00740000
                                                                        
           EXEC SQL                                                     00751000
              INCLUDE TBCSTSTS                                          00752000
           END-EXEC.                                                    00753000
                                                                        
           EXEC SQL                                                     00755000
              INCLUDE TBACCT                                            00756000
           END-EXEC.                                                    00757000
                                                                        
                                                                        
      ******************************************************************00770000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00780000
      ******************************************************************00790000
                                                                        
CVT999*    COPY SYGWCOB.                                                00810000
CVT999*    COPY SYDBCOB.                                                00820000
           COPY CCA00001.                                               00830000
CVT999*    COPY CWS00010.                                               00840000
           COPY CWS00027.                                               00850000
           COPY CWS00303.                                               00860000
                                                                        
      ******************************************************************00880000
      *    WORK AREAS                                                  *00890000
      ******************************************************************00900000
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
CVT999*    05  GWL-PROC                POINTER.                         00930000
CVT999*    05  GWL-INIT-HANDLE         POINTER.                         00940000
CVT999*    05  GWL-RC                  PIC S9(9) COMP.                  00950000
CVT999*    05  GWL-STATUS-NR           PIC S9(9) COMP.                  00960000
CVT999*    05  GWL-STATUS-DONE         PIC S9(9) COMP.                  00970000
CVT999*    05  GWL-STATUS-COUNT        PIC S9(9) COMP.                  00980000
CVT999*    05  GWL-STATUS-COMM         PIC S9(9) COMP.                  00990000
CVT999*    05  GWL-STATUS-RETURN-CODE  PIC S9(9) COMP.                  01000000
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9) COMP.                  
CVT999*    05  PARM-ID1                PIC S9(9) COMP VALUE 1.          01070000
           05  PARM-ACTION-CODE        PIC X(01) VALUE SPACES.          
           05  PARM-CUSTOMER-NO        PIC X(10) VALUE SPACES.          
           05  PARM-CUSTOMER-NO-RED    REDEFINES PARM-CUSTOMER-NO       
                                       PIC 9(10).                       
           05  PARM-CUSTOMER-NO-NUM    PIC S9(10)V USAGE COMP-3         
                                                 VALUE ZERO.            
           05  PARM-SSN                PIC X(09) VALUE SPACES.          
           05  PARM-LICENSE-NO         PIC X(19) VALUE SPACES.          
           05  PARM-CODE-STATE-ID      PIC X(02) VALUE SPACES.          
           05  PARM-OTHER-ID           PIC X(16) VALUE SPACES.          
           05  PARM-OTHER-ID-TYPE      PIC X(12) VALUE SPACES.          
           05  PARM-BYPASS-FLAG        PIC X(01) VALUE SPACES.          
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
CVT999*    05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          01140000
                                                                        
       01  COUNTER-FIELDS.                                              
CVT999*    05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          01170000
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
CVT999*    05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  01220000
CVT999*    05  WRKLEN1                 PIC S9(9) COMP.                  01230000
CVT999*    05  WRKLEN2                 PIC S9(9) COMP.                  01240000
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-MISC-VALUES.                                              
           05  PROGRAM-NAME            PIC X(08)  VALUE 'S257    '.     
           05  NOT-FOUND-CALL          PIC S9(03) VALUE +100.           
           05  MULTIPLE-ROWS-CALL      PIC S9(03) VALUE -811.           
           05  WS-YES                  PIC X(01)  VALUE 'Y'.            
           05  WS-NO                   PIC X(01)  VALUE 'N'.            
           05  WS-ACTIVE-CODE          PIC X(01)  VALUE 'A'.            
           05  WS-CUSTOMER-TYPE        PIC X(01)  VALUE 'C'.            
           05  WS-WRITE-OFF-STATUS     PIC X(01)  VALUE 'S'.            
           05  WS-BANKRUPT-IND         PIC X(01)  VALUE 'B'.            
           05  WS-JUDGMENT-IND         PIC X(01)  VALUE 'J'.            
                                                                        
       01  FILLER  PIC X(32)  VALUE 'THIS IS THE ROW RETURN AREA.    '. 
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE         PIC S9(09) COMP  VALUE ZERO.      
           05  RS-SSN-MATCH-IND       PIC X(01)      VALUE SPACES.      
           05  RS-DRVR-LIC-MATCH-IND  PIC X(01)      VALUE SPACES.      
           05  RS-OTHER-ID-MATCH-IND  PIC X(01)      VALUE SPACES.      
           05  RS-BAD-ACCOUNT         PIC X(01)      VALUE SPACES.      
           05  RS-NORM-ACCOUNT        PIC X(01)      VALUE SPACES.      
                                                                        
CVT999*01  CNS-COLUMN-NAMES.                                            01420000
CVT999*    05  CNS-RETURN-CODE         PIC X(11) VALUE                  01430000
CVT999*                                        'RETURN_CODE'.           01440000
CVT999*    05  CNS-SSN-MATCH-IND       PIC X(09) VALUE                  01450000
CVT999*                                        'SSN_MATCH'.             01451000
CVT999*    05  CNS-DRVR-LIC-MATCH-IND  PIC X(14) VALUE                  01460000
CVT999*                                        'DRVR_LIC_MATCH'.        01461000
CVT999*    05  CNS-OTHR-ID-MATCH-IND   PIC X(13) VALUE                  01470000
CVT999*                                        'OTHR_ID_MATCH'.         01471000
CVT999*    05  CNS-BAD-ACCOUNT         PIC X(11) VALUE                  01480000
CVT999*                                        'BAD_ACCOUNT'.           01481000
CVT999*    05  CNS-NORM-ACCOUNT        PIC X(12) VALUE                  01490000
CVT999*                                        'NORM_ACCOUNT'.          01491000
CVT999*                                                                 01519600
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
HPCCDM*EJECT                                                            01612000
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
CVT000     10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-ACTION-CODE         PIC X(01)                .          
CVT000 01  LINK-CUSTOMER-NO         PIC X(10)                .          
CVT000 01  LINK-SSN                 PIC X(09)                .          
CVT000 01  LINK-LICENSE-NO          PIC X(19)                .          
CVT000 01  LINK-CODE-STATE-ID       PIC X(02)                .          
CVT000 01  LINK-OTHER-ID            PIC X(16)                .          
CVT000 01  LINK-OTHER-ID-TYPE       PIC X(12)                .          
CVT000 01  LINK-BYPASS-FLAG         PIC X(01)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-ACTION-CODE                                        
CVT000         ,LINK-CUSTOMER-NO                                        
CVT000         ,LINK-SSN                                                
CVT000         ,LINK-LICENSE-NO                                         
CVT000         ,LINK-CODE-STATE-ID                                      
CVT000         ,LINK-OTHER-ID                                           
CVT000         ,LINK-OTHER-ID-TYPE                                      
CVT000         ,LINK-BYPASS-FLAG                                        
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                              01620000
                                                                        
      ******************************************************************01640000
      * 0000-MAINLINE                                                  *01650000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *01660000
      ******************************************************************01670000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************01790000
      * 0100-INITIALIZE                                                *01800000
      *                                                                *01810000
      *     1. RESET DB2 ERROR HANDLERS                                *01820000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *01830000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *01840000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*01850000
      *                                                                *01860000
      ******************************************************************01870000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
CVT999*    EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              01910000
CVT999*    EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              01920000
CVT999*    EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              01930000
CVT999*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.     01940000
                                                                        
CVT999*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,     01960000
CVT999*                          SNA-CONNECTION-NAME, SNA-SUBC.         01970000
                                                                        
CVT999*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                      01990000
                                                                        
CVT999*    IF GWL-RC NOT = TDS-PARM-PRESENT                             02010000
CVT999*       MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        02020000
CVT999*       MOVE '0100'                       TO ACTIVE-PARAGRAPH     02030000
CVT999*       MOVE 'TDRESULT- NO RPC PARM SENT' TO ABEND-FUNCTION       02040000
CVT999*       MOVE 'CICS TRANSACTION'           TO TABLE-1              02050000
CVT999*       MOVE GWL-RC                       TO WS-ACTIVE-RETURN-CODE02060000
CVT999*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            02070000
CVT999*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            02080000
CVT999*    END-IF.                                                      02090000
                                                                        
CVT000     EXEC SQL                                                     
CVT000       DECLARE C1 CURSOR  FOR                          
CVT000       SELECT                                                     
CVT000        :RS-RETURN-CODE              AS    RETURN_CODE            
CVT000       ,:RS-SSN-MATCH-IND            AS    SSN_MATCH_IND          
CVT000       ,:RS-DRVR-LIC-MATCH-IND       AS    DRVR_LIC_MATCH_IND     
CVT000       ,:RS-OTHER-ID-MATCH-IND       AS    OTHER_ID_MATCH_IND     
CVT000       ,:RS-BAD-ACCOUNT              AS    BAD_ACCOUNT            
CVT000       ,:RS-NORM-ACCOUNT             AS    NORM_ACCOUNT           
CVT000          FROM CIS.SYSDUMMY1                                   
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :RS-RETURN-CODE              AS    RETURN_CODE                    
MFA-TR*      ,:RS-SSN-MATCH-IND            AS    SSN_MATCH_IND                  
MFA-TR*      ,:RS-DRVR-LIC-MATCH-IND       AS    DRVR_LIC_MATCH_IND             
MFA-TR*      ,:RS-OTHER-ID-MATCH-IND       AS    OTHER_ID_MATCH_IND             
MFA-TR*      ,:RS-BAD-ACCOUNT              AS    BAD_ACCOUNT                    
MFA-TR*      ,:RS-NORM-ACCOUNT             AS    NORM_ACCOUNT                   
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
CVT000     MOVE LINK-ACTION-CODE          TO PARM-ACTION-CODE         . 
CVT000     MOVE LINK-CUSTOMER-NO          TO PARM-CUSTOMER-NO         . 
CVT000     MOVE LINK-SSN                  TO PARM-SSN                 . 
CVT000     MOVE LINK-LICENSE-NO           TO PARM-LICENSE-NO          . 
CVT000     MOVE LINK-CODE-STATE-ID        TO PARM-CODE-STATE-ID       . 
CVT000     MOVE LINK-OTHER-ID             TO PARM-OTHER-ID            . 
CVT000     MOVE LINK-OTHER-ID-TYPE        TO PARM-OTHER-ID-TYPE       . 
CVT000     MOVE LINK-BYPASS-FLAG          TO PARM-BYPASS-FLAG         . 
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02140000
      * 1000-PROCESS-INPUT                                             *02150000
      *     1. PROCESS INPUT PARMS.                                    *02170000
      *                                                                *02180000
      ******************************************************************02190000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1100-RECEIVE-PARMS     THRU 1100-EXIT.               
           MOVE PARM-CUSTOMER-NO-RED      TO PARM-CUSTOMER-NO-NUM.      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02281000
      * 1100-RECEIVE-PARMS.                                            *02282000
      *     1. RECEIVE PARMS.                                          *02284000
      *                                                                *02285000
      ******************************************************************02286000
                                                                        
       1100-RECEIVE-PARMS.                                              
                                                                        
CVT999*    MOVE 1                           TO PARM-ID1.                02302000
CVT999*    MOVE LENGTH OF PARM-ACTION-CODE  TO MAX-LENGTH-PARM.         02303000
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                              02305000
CVT999*                          GWL-RC,                                02306000
CVT999*                          PARM-ID1,                              02307000
CVT999*                          PARM-ACTION-CODE,                      02308000
CVT999*                          TDSCHAR,                               02309000
CVT999*                          MAX-LENGTH-PARM,                       02309100
CVT999*                          PARM-L.                                02309200
                                                                        
CVT999*    ADD 1                            TO PARM-ID1.                02310000
CVT999*    MOVE LENGTH OF PARM-CUSTOMER-NO  TO MAX-LENGTH-PARM.         02320000
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                              02340000
CVT999*                          GWL-RC,                                02350000
CVT999*                          PARM-ID1,                              02360000
CVT999*                          PARM-CUSTOMER-NO,                      02370000
CVT999*                          TDSCHAR,                               02380000
CVT999*                          MAX-LENGTH-PARM,                       02390000
CVT999*                          PARM-L.                                02400000
                                                                        
CVT999*    ADD 1                            TO PARM-ID1.                02410100
CVT999*    MOVE LENGTH OF PARM-SSN          TO MAX-LENGTH-PARM.         02410200
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                              02410400
CVT999*                          GWL-RC,                                02410500
CVT999*                          PARM-ID1,                              02410600
CVT999*                          PARM-SSN,                              02410700
CVT999*                          TDSCHAR,                               02410800
CVT999*                          MAX-LENGTH-PARM,                       02410900
CVT999*                          PARM-L.                                02411000
                                                                        
CVT999*    ADD 1                            TO PARM-ID1.                02411200
CVT999*    MOVE LENGTH OF PARM-LICENSE-NO   TO MAX-LENGTH-PARM.         02412000
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                              02414000
CVT999*                          GWL-RC,                                02415000
CVT999*                          PARM-ID1,                              02416000
CVT999*                          PARM-LICENSE-NO,                       02417000
CVT999*                          TDSCHAR,                               02418000
CVT999*                          MAX-LENGTH-PARM,                       02419000
CVT999*                          PARM-L.                                02419100
                                                                        
CVT999*    ADD 1                             TO PARM-ID1.               02419300
CVT999*    MOVE LENGTH OF PARM-CODE-STATE-ID TO MAX-LENGTH-PARM.        02419400
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                              02419600
CVT999*                          GWL-RC,                                02419700
CVT999*                          PARM-ID1,                              02419800
CVT999*                          PARM-CODE-STATE-ID,                    02419900
CVT999*                          TDSCHAR,                               02420000
CVT999*                          MAX-LENGTH-PARM,                       02420100
CVT999*                          PARM-L.                                02420200
                                                                        
                                                                        
CVT999*    ADD 1                             TO PARM-ID1.               02420500
CVT999*    MOVE LENGTH OF PARM-OTHER-ID      TO MAX-LENGTH-PARM.        02420600
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                              02420800
CVT999*                          GWL-RC,                                02420900
CVT999*                          PARM-ID1,                              02421000
CVT999*                          PARM-OTHER-ID,                         02421100
CVT999*                          TDSCHAR,                               02421200
CVT999*                          MAX-LENGTH-PARM,                       02421300
CVT999*                          PARM-L.                                02421400
                                                                        
CVT999*    ADD 1                             TO PARM-ID1.               02422600
CVT999*    MOVE LENGTH OF PARM-OTHER-ID-TYPE TO MAX-LENGTH-PARM.        02422700
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                              02422900
CVT999*                          GWL-RC,                                02423000
CVT999*                          PARM-ID1,                              02423100
CVT999*                          PARM-OTHER-ID-TYPE,                    02423200
CVT999*                          TDSCHAR,                               02423300
CVT999*                          MAX-LENGTH-PARM,                       02423400
CVT999*                          PARM-L.                                02423500
                                                                        
CVT999*    ADD 1                             TO PARM-ID1.               02423700
CVT999*    MOVE LENGTH OF PARM-BYPASS-FLAG   TO MAX-LENGTH-PARM.        02423800
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                              02424000
CVT999*                          GWL-RC,                                02424100
CVT999*                          PARM-ID1,                              02424200
CVT999*                          PARM-BYPASS-FLAG,                      02424300
CVT999*                          TDSCHAR,                               02424400
CVT999*                          MAX-LENGTH-PARM,                       02424500
CVT999*                          PARM-L.                                02424600
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02450000
      * 2000-PROCESS-OUTPUT.                                           *02460000
      *                                                                *02470000
      ******************************************************************02480000
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2100-DESCRIBE-RESULT  THRU 2100-EXIT.                
           PERFORM 2200-BUILD-RESULT     THRU 2200-EXIT.                
           PERFORM 8100-SEND-RESULT      THRU 8100-EXIT.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02590000
      * 2100-DESCRIBE-RESULT.                                          *02600000
      *                                                                *02601000
      ******************************************************************02610000
                                                                        
       2100-DESCRIBE-RESULT.                                            
                                                                        
           MOVE '2100'                        TO ACTIVE-PARAGRAPH.      
                                                                        
CVT999*    MOVE 1                             TO CTR-COLUMN.            02660000
CVT999*    MOVE TDSINT4                       TO DB-HOST-TYPE.          02670000
CVT999*    MOVE TDSINT4                       TO DB-CLIENT-TYPE.        02680000
CVT999*    MOVE LENGTH OF RS-RETURN-CODE      TO WRKLEN1.               02690000
CVT999*    MOVE LENGTH OF CNS-RETURN-CODE     TO WRKLEN2.               02700000
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              02720000
CVT999*                          GWL-RC,                                02730000
CVT999*                          CTR-COLUMN,                            02740000
CVT999*                          DB-HOST-TYPE,                          02750000
CVT999*                          WRKLEN1,                               02760000
CVT999*                          RS-RETURN-CODE,                        02770000
CVT999*                          DB-NULL-INDICATOR,                     02780000
CVT999*                          TDS-FALSE,                             02790000
CVT999*                          DB-CLIENT-TYPE,                        02800000
CVT999*                          WRKLEN1,                               02810000
CVT999*                          CNS-RETURN-CODE,                       02820000
CVT999*                          WRKLEN2.                               02830000
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02850000
                                                                        
                                                                        
CVT999*    ADD  1                             TO CTR-COLUMN.            02871000
CVT999*    MOVE TDSCHAR                       TO DB-HOST-TYPE.          02871100
CVT999*    MOVE TDSCHAR                       TO DB-CLIENT-TYPE.        02871200
CVT999*    MOVE LENGTH OF RS-SSN-MATCH-IND    TO WRKLEN1.               02871300
CVT999*    MOVE LENGTH OF CNS-SSN-MATCH-IND   TO WRKLEN2.               02871400
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              02871600
CVT999*                          GWL-RC,                                02871700
CVT999*                          CTR-COLUMN,                            02871800
CVT999*                          DB-HOST-TYPE,                          02871900
CVT999*                          WRKLEN1,                               02872000
CVT999*                          RS-SSN-MATCH-IND,                      02872100
CVT999*                          DB-NULL-INDICATOR,                     02872200
CVT999*                          TDS-FALSE,                             02872300
CVT999*                          DB-CLIENT-TYPE,                        02872400
CVT999*                          WRKLEN1,                               02872500
CVT999*                          CNS-SSN-MATCH-IND,                     02872600
CVT999*                          WRKLEN2.                               02872700
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     02872900
                                                                        
                                                                        
CVT999*    ADD  1                                TO CTR-COLUMN.         02874000
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.       02880000
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.     02890000
CVT999*    MOVE LENGTH OF RS-DRVR-LIC-MATCH-IND  TO WRKLEN1.            02900000
CVT999*    MOVE LENGTH OF CNS-DRVR-LIC-MATCH-IND TO WRKLEN2.            02910000
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              02930000
CVT999*                          GWL-RC,                                02940000
CVT999*                          CTR-COLUMN,                            02950000
CVT999*                          DB-HOST-TYPE,                          02960000
CVT999*                          WRKLEN1,                               02970000
CVT999*                          RS-DRVR-LIC-MATCH-IND,                 02980000
CVT999*                          DB-NULL-INDICATOR,                     02990000
CVT999*                          TDS-FALSE,                             03000000
CVT999*                          DB-CLIENT-TYPE,                        03010000
CVT999*                          WRKLEN1,                               03020000
CVT999*                          CNS-DRVR-LIC-MATCH-IND,                03030000
CVT999*                          WRKLEN2.                               03040000
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     03060000
                                                                        
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.          03090000
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.        03100000
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.      03110000
CVT999*    MOVE LENGTH OF RS-OTHER-ID-MATCH-IND TO WRKLEN1.             03120000
CVT999*    MOVE LENGTH OF CNS-OTHR-ID-MATCH-IND TO WRKLEN2.             03130000
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              03150000
CVT999*                          GWL-RC,                                03160000
CVT999*                          CTR-COLUMN,                            03170000
CVT999*                          DB-HOST-TYPE,                          03180000
CVT999*                          WRKLEN1,                               03190000
CVT999*                          RS-OTHER-ID-MATCH-IND,                 03200000
CVT999*                          DB-NULL-INDICATOR,                     03210000
CVT999*                          TDS-FALSE,                             03220000
CVT999*                          DB-CLIENT-TYPE,                        03230000
CVT999*                          WRKLEN1,                               03240000
CVT999*                          CNS-OTHR-ID-MATCH-IND,                 03250000
CVT999*                          WRKLEN2.                               03260000
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     03280000
                                                                        
                                                                        
CVT999*    ADD 1                               TO CTR-COLUMN.           03310000
CVT999*    MOVE TDSCHAR                        TO DB-HOST-TYPE.         03320000
CVT999*    MOVE TDSCHAR                        TO DB-CLIENT-TYPE.       03330000
CVT999*    MOVE LENGTH OF RS-BAD-ACCOUNT       TO WRKLEN1.              03340000
CVT999*    MOVE LENGTH OF CNS-BAD-ACCOUNT      TO WRKLEN2.              03350000
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              03370000
CVT999*                          GWL-RC,                                03380000
CVT999*                          CTR-COLUMN,                            03390000
CVT999*                          DB-HOST-TYPE,                          03400000
CVT999*                          WRKLEN1,                               03410000
CVT999*                          RS-BAD-ACCOUNT,                        03420000
CVT999*                          DB-NULL-INDICATOR,                     03430000
CVT999*                          TDS-FALSE,                             03440000
CVT999*                          DB-CLIENT-TYPE,                        03450000
CVT999*                          WRKLEN1,                               03460000
CVT999*                          CNS-BAD-ACCOUNT,                       03470000
CVT999*                          WRKLEN2.                               03480000
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     03482000
                                                                        
                                                                        
CVT999*    ADD  1                             TO CTR-COLUMN.            03502000
CVT999*    MOVE TDSCHAR                       TO DB-HOST-TYPE.          03503000
CVT999*    MOVE TDSCHAR                       TO DB-CLIENT-TYPE.        03504000
CVT999*    MOVE LENGTH OF RS-NORM-ACCOUNT     TO WRKLEN1.               03505000
CVT999*    MOVE LENGTH OF CNS-NORM-ACCOUNT    TO WRKLEN2.               03506000
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              03508000
CVT999*                          GWL-RC,                                03509000
CVT999*                          CTR-COLUMN,                            03509100
CVT999*                          DB-HOST-TYPE,                          03509200
CVT999*                          WRKLEN1,                               03509300
CVT999*                          RS-NORM-ACCOUNT,                       03509400
CVT999*                          DB-NULL-INDICATOR,                     03509500
CVT999*                          TDS-FALSE,                             03509600
CVT999*                          DB-CLIENT-TYPE,                        03509700
CVT999*                          WRKLEN1,                               03509800
CVT999*                          CNS-NORM-ACCOUNT,                      03509900
CVT999*                          WRKLEN2.                               03510000
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     03510200
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03596800
      * 2200-BUILD-RESULT.                                             *03596900
      *      1. IF THE UPDATE TYPE IS A DELETE, DETERMINE IF THE       *03597000
      *         CUSTOMER IS LINKED TO AN ACCOUNT THAT IS WRITTEN-OFF,  *03597100
      *         BANKRUPT, OR JUDGMENT.                                 *03597200
      *      2. IF THE UPDATE TYPE IS AN INSERT, DETERMINE IF THE      *03597600
      *         CUSTOMER ALREADY EXISTS OR IF THEY ARE LINKED TO AN    *03597700
      *         ACCOUNT.                                               *03597900
      *      3. IF THE UPDATE TYPE IS AN UPDATE, DETERMINE IF THE      *03598100
      *         CUSTOMER HAS CHANGED ID INFORMATION AND ALREADY EXISTS *03598200
      *         AS A DIFFERENT CUSTOMER.                               *03598300
      *                                                                *03598400
      ******************************************************************03598500
       2200-BUILD-RESULT.                                               
                                                                        
T16222     EVALUATE PARM-ACTION-CODE                                    
T16222         WHEN 'D'                                                 
                   PERFORM 5100-CHECK-BAD-ACCOUNTS THRU 5100-EXIT       
                   IF (RS-BAD-ACCOUNT = WS-YES)                         
                       NEXT SENTENCE                                    
                   ELSE                                                 
                       PERFORM 5200-CHECK-NORM-ACCOUNTS THRU 5200-EXIT  
                   END-IF                                               
T16222         WHEN 'I'                                                 
                   PERFORM 5000-PROCESS-INSERT-CHECK THRU 5000-EXIT     
T16222         WHEN OTHER                                               
                   MOVE WS-CUSTOMER-TYPE TO CE-CUSTOMER-TYPE            
T16222             IF PARM-BYPASS-FLAG = 'F'                            
                       PERFORM 7100-CHECK-CUSTOMER THRU 7100-EXIT       
T16222             END-IF                                               
           END-EVALUATE.                                                
                                                                        
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04090800
      * 5000-PROCESS-INSERT-CHECK.                                     *04090900
      *     1. DETERMINE IF THE CUSTOMER ALREADY EXISTS.  IF HE        *04091000
      *        DOESN'T EXIST, CHECK IF HE IS LINKED (AS A SPOUSE OR    *04091100
      *        OR ROOMMATE) TO AN ACCOUNT.                             *04091400
      ******************************************************************04091700
       5000-PROCESS-INSERT-CHECK.                                       
                                                                        
           MOVE WS-CUSTOMER-TYPE             TO CE-CUSTOMER-TYPE.       
T16222     IF PARM-BYPASS-FLAG = 'F'                                    
               PERFORM 7100-CHECK-CUSTOMER         THRU 7100-EXIT
           END-IF.      
                                                                        
           IF ((RS-SSN-MATCH-IND = WS-YES) OR                           
             (RS-DRVR-LIC-MATCH-IND = WS-YES) OR                        
             (RS-OTHER-ID-MATCH-IND = WS-YES))                          
              NEXT SENTENCE                                             
           ELSE                                                         
              PERFORM 5100-CHECK-BAD-ACCOUNTS           THRU 5100-EXIT  
              IF (RS-BAD-ACCOUNT = WS-YES)                              
                 NEXT SENTENCE                                          
              ELSE                                                      
                 PERFORM 5200-CHECK-NORM-ACCOUNTS    THRU 5200-EXIT     
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04107000
      * 5100-CHECK-BAD-ACCOUNTS.                                       *04107100
      *     1. BASED ON THE IDENTIFICATION PARAMATERS SENT, CHECK FOR  *04107200
      *        CUSTOMER LINKS TO BAD ACCOUNTS (WRITE-OFF, JUDGMENT,    *04107300
      *        BANKRUPT).                                              *04107400
      ******************************************************************04107600
       5100-CHECK-BAD-ACCOUNTS.                                         
                                                                        
           IF PARM-SSN > SPACES                                         
              MOVE PARM-SSN TO CE-SSN                                   
              PERFORM 7600-BAD-ACCT-ON-SSN THRU 7600-EXIT
           END-IF.              
                                                                        
           IF PARM-LICENSE-NO > SPACES                                  
              MOVE PARM-LICENSE-NO TO CE-DRIVERS-LICENSE-NO             
              MOVE PARM-CODE-STATE-ID TO CE-CODE-STATE-ID               
              PERFORM 7800-BAD-ACCT-ON-DRVR THRU 7800-EXIT
           END-IF.             
                                                                        
           IF PARM-OTHER-ID > SPACES                                    
              MOVE PARM-OTHER-ID TO CE-OTHER-ID                         
              MOVE PARM-OTHER-ID-TYPE TO CE-OTHER-ID-TYPE               
              PERFORM 8000-BAD-ACCT-ON-OTHR THRU 8000-EXIT
           END-IF.             
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04118200
      * 5200-CHECK-NORM-ACCOUNTS.                                      *04118300
      *     1. BASED ON THE IDENTIFICATION PARAMATERS SENT, CHECK FOR  *04118400
      *        CUSTOMER LINKS TO ANY ACCOUNTS.                         *04118500
      ******************************************************************04118700
       5200-CHECK-NORM-ACCOUNTS.                                        
                                                                        
           IF PARM-SSN > SPACES                                         
              MOVE PARM-SSN TO CE-SSN                                   
              PERFORM 7700-NORM-ACCT-ON-SSN THRU 7700-EXIT
           END-IF.             
                                                                        
           IF PARM-LICENSE-NO > SPACES                                  
              MOVE PARM-LICENSE-NO TO CE-DRIVERS-LICENSE-NO             
              MOVE PARM-CODE-STATE-ID TO CE-CODE-STATE-ID               
              PERFORM 7900-NORM-ACCT-ON-DRVR THRU 7900-EXIT
           END-IF.            
                                                                        
           IF PARM-OTHER-ID > SPACES                                    
              MOVE PARM-OTHER-ID TO CE-OTHER-ID                         
              MOVE PARM-OTHER-ID-TYPE TO CE-OTHER-ID-TYPE               
              PERFORM 8300-NORM-ACCT-ON-OTHR THRU 8300-EXIT
           END-IF.            
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04124300
      * 7100-CHECK-CUSTOMER.                                           *04124400
      *     1. CHECK FOR CUSTOMER MATCHES BASED ON ID PARAMETERS.      *04124500
      *                                                                *04124600
      ******************************************************************04124700
       7100-CHECK-CUSTOMER.                                             
                                                                        
           IF PARM-SSN > SPACES                                         
              MOVE PARM-SSN TO CE-SSN                                   
              PERFORM 7200-CHECK-SSN-MATCH THRU 7200-EXIT
           END-IF.              
                                                                        
           IF PARM-LICENSE-NO > SPACES                                  
              MOVE PARM-LICENSE-NO TO CE-DRIVERS-LICENSE-NO             
              MOVE PARM-CODE-STATE-ID TO CE-CODE-STATE-ID               
              PERFORM 7300-CHECK-LICENSE-NO THRU 7300-EXIT
           END-IF.             
                                                                        
           IF PARM-OTHER-ID > SPACES                                    
              MOVE PARM-OTHER-ID TO CE-OTHER-ID                         
              MOVE PARM-OTHER-ID-TYPE TO CE-OTHER-ID-TYPE               
              PERFORM 7400-CHECK-OTHER-ID THRU 7400-EXIT
           END-IF.               
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04131400
      * 7200-CHECK-SSN-MATCH.                                          *04131500
      *     1. USE THE SOCIAL SECURITY NUMBER TO SEE IF CUSTOMER       *04131600
      *        INFORMATION EXISTS.                                     *04131700
      ******************************************************************04131900
       7200-CHECK-SSN-MATCH.                                            
                                                                        
           EXEC SQL                                                     
             SELECT CUSTOMER_NO                                         
               INTO :CE-CUSTOMER-NO                                     
               FROM CSS_CUST_STATS                                      
              WHERE SSN           = :CE-SSN                             
                AND CUSTOMER_TYPE = :CE-CUSTOMER-TYPE                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN NOT-FOUND-CALL                                      
                   MOVE WS-NO TO RS-SSN-MATCH-IND                       
               WHEN SUCCESSFUL-CALL                                     
                   IF CE-CUSTOMER-NO = PARM-CUSTOMER-NO-NUM             
                       MOVE WS-NO TO RS-SSN-MATCH-IND                   
                   ELSE                                                 
                       MOVE WS-YES TO RS-SSN-MATCH-IND                  
                   END-IF                                               
               WHEN MULTIPLE-ROWS-CALL                                  
                   MOVE WS-YES TO RS-SSN-MATCH-IND                      
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7200'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE 'CSS_CUST_STATS'   TO TABLE-1                   
                   MOVE 'SSN'              TO TABLE-ELEMENT-1           
CBSI               MOVE 'CUSTOMER_TYPE'    TO TABLE-ELEMENT-2           
CBSI               MOVE 'CUSTOMER_NO'      TO TABLE-ELEMENT-3           
                   MOVE CE-SSN             TO HOSTVAR-ELEMENT-1         
                   MOVE CE-CUSTOMER-TYPE   TO HOSTVAR-ELEMENT-2         
CBSI               MOVE PARM-CUSTOMER-NO   TO HOSTVAR-ELEMENT-3         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04144900
      * 7300-CHECK-LICENSE-NO.                                         *04145000
      *     1. BASED ON LICENSE NO AND STATE ID PASSED, CHECK IF       *04145100
      *        CUSTOMER INFORMATION ALREADY EXISTS.                    *04145200
      ******************************************************************04145400
       7300-CHECK-LICENSE-NO.                                           
                                                                        
           EXEC SQL                                                     
             SELECT CUSTOMER_NO                                         
               INTO :CE-CUSTOMER-NO                                     
               FROM CSS_CUST_STATS                                      
              WHERE DRIVERS_LICENSE_NO    = :CE-DRIVERS-LICENSE-NO      
                AND CODE_STATE_ID         = :CE-CODE-STATE-ID           
                AND CUSTOMER_TYPE         = :CE-CUSTOMER-TYPE           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN NOT-FOUND-CALL                                      
                   MOVE WS-NO  TO RS-DRVR-LIC-MATCH-IND                 
               WHEN SUCCESSFUL-CALL                                     
                   IF CE-CUSTOMER-NO = PARM-CUSTOMER-NO-NUM             
                       MOVE WS-NO  TO RS-DRVR-LIC-MATCH-IND             
                   ELSE                                                 
                       MOVE WS-YES TO RS-DRVR-LIC-MATCH-IND             
                   END-IF                                               
               WHEN MULTIPLE-ROWS-CALL                                  
                   MOVE WS-YES TO RS-DRVR-LIC-MATCH-IND                 
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7300'                TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_CUST_STATS'      TO TABLE-1                
CBSI               MOVE 'DRIVERS_LICENSE_NO'  TO TABLE-ELEMENT-1        
                   MOVE CE-DRIVERS-LICENSE-NO TO HOSTVAR-ELEMENT-1      
                   MOVE 'CODE_STATE_ID'       TO TABLE-ELEMENT-2        
                   MOVE CE-CODE-STATE-ID      TO HOSTVAR-ELEMENT-2      
                   MOVE 'CUSTOMER_TYPE'       TO TABLE-ELEMENT-3        
                   MOVE CE-CUSTOMER-TYPE      TO HOSTVAR-ELEMENT-3      
CBSI               MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-3        
CBSI               MOVE PARM-CUSTOMER-NO      TO HOSTVAR-ELEMENT-3      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04151400
      * 7400-CHECK-OTHER-ID.                                           *04151500
      *     1. BASED ON OTHER ID INFORMATION, CHECK IF CUSTOMER        *04151600
      *        INFORMATION ALREADY EXISTS.                             *04151700
      ******************************************************************04151900
       7400-CHECK-OTHER-ID.                                             
                                                                        
           EXEC SQL                                                     
             SELECT CUSTOMER_NO                                         
               INTO :CE-CUSTOMER-NO                                     
               FROM CSS_CUST_STATS                                      
              WHERE OTHER_ID      = :CE-OTHER-ID                        
                AND OTHER_ID_TYPE = :CE-OTHER-ID-TYPE                   
                AND CUSTOMER_TYPE = :CE-CUSTOMER-TYPE                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN NOT-FOUND-CALL                                      
                   MOVE WS-NO TO RS-OTHER-ID-MATCH-IND                  
               WHEN SUCCESSFUL-CALL                                     
                   IF CE-CUSTOMER-NO = PARM-CUSTOMER-NO-NUM             
                       MOVE WS-NO TO RS-OTHER-ID-MATCH-IND              
                   ELSE                                                 
                       MOVE WS-YES TO RS-OTHER-ID-MATCH-IND             
                   END-IF                                               
               WHEN MULTIPLE-ROWS-CALL                                  
                   MOVE WS-YES TO RS-OTHER-ID-MATCH-IND                 
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE '7400'                TO ACTIVE-PARAGRAPH       
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE 'CSS_CUST_STATS'      TO TABLE-1                
                   MOVE 'OTHER_ID'            TO TABLE-ELEMENT-1        
                   MOVE CE-OTHER-ID           TO HOSTVAR-ELEMENT-1      
                   MOVE 'OTHER_ID_TYPE'       TO TABLE-ELEMENT-2        
                   MOVE CE-OTHER-ID-TYPE      TO HOSTVAR-ELEMENT-2      
                   MOVE 'CUSTOMER_TYPE'       TO TABLE-ELEMENT-3        
                   MOVE CE-CUSTOMER-TYPE      TO HOSTVAR-ELEMENT-3      
CBSI               MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-4        
CBSI               MOVE PARM-CUSTOMER-NO      TO HOSTVAR-ELEMENT-4      
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04161300
      * 7600-BAD-ACCT-ON-SSN.                                          *04161400
      *    1. CHECK FOR BANKRUPT, WRITE-OFF, JUDGMENT (BWJ) ACCOUNT    *04161700
      *       ASSOCIATION BASED ON SOCIAL SECURITY NUMBER AND          *04161800
      *       CUSTOMER TYPE.                                           *04161900
      ******************************************************************04162100
       7600-BAD-ACCT-ON-SSN.                                            
                                                                        
           EXEC SQL                                                     
             SELECT 'Y'                                                 
               INTO :RS-BAD-ACCOUNT                                     
               FROM CSS_ACCOUNT A,                                      
                    CSS_CUST_STATS B                                    
              WHERE A.CUSTOMER_NO    = B.CUSTOMER_NO                    
                AND B.SSN            = :CE-SSN                          
                AND B.CUSTOMER_TYPE  IN ('R','S')                       
                AND (  A.CODE_ACCT_STAT = :WS-WRITE-OFF-STATUS          
                    OR A.BANKRUPTCY_IND = :WS-BANKRUPT-IND              
                    OR A.BANKRUPTCY_IND = :WS-JUDGMENT-IND)             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE    = NOT-FOUND-CALL                 
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL               
               OR WS-ACTIVE-RETURN-CODE = MULTIPLE-ROWS-CALL            
                 MOVE WS-YES             TO RS-BAD-ACCOUNT              
                 MOVE WS-YES             TO RS-SSN-MATCH-IND            
              ELSE                                                      
                 MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE           
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE '7600'             TO ACTIVE-PARAGRAPH            
                 MOVE 'SELECT'           TO ABEND-FUNCTION              
                 MOVE 'CSS_ACCOUNT'      TO TABLE-1                     
CBSI             MOVE 'CSS_CUST_STATS'   TO TABLE-2                     
CBSI             MOVE 'SSN'              TO TABLE-ELEMENT-1             
CBSI             MOVE 'CODE_ACCT_STAT'   TO TABLE-ELEMENT-2             
CBSI             MOVE 'BANKRUPTCY_IND'   TO TABLE-ELEMENT-3             
CBSI             MOVE 'CUSTOMER_NO'      TO TABLE-ELEMENT-4             
CBSI             MOVE CE-SSN             TO HOSTVAR-ELEMENT-1           
CBSI             MOVE WS-WRITE-OFF-STATUS TO HOSTVAR-ELEMENT-2          
CBSI             MOVE WS-BANKRUPT-IND    TO HOSTVAR-ELEMENT-3           
CBSI             MOVE PARM-CUSTOMER-NO   TO HOSTVAR-ELEMENT-4           
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04167200
      * 7700-NORM-ACCT-ON-SSN.                                         *04167300
      *    1. CHECK FOR ACCOUNT ASSOCIATION BASED ON SOCIAL SECURTIY   *04167400
      *       NUMBER.                                                  *04167500
      ******************************************************************04167800
       7700-NORM-ACCT-ON-SSN.                                           
                                                                        
           EXEC SQL                                                     
             SELECT 'Y'                                                 
               INTO :RS-NORM-ACCOUNT                                    
               FROM CSS_ACCOUNT A,                                      
                    CSS_CUST_STATS B                                    
              WHERE A.CUSTOMER_NO    = B.CUSTOMER_NO                    
                AND B.SSN            = :CE-SSN                          
                AND B.CUSTOMER_TYPE  IN ('R','S')                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE    = NOT-FOUND-CALL                 
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL               
               OR WS-ACTIVE-RETURN-CODE = MULTIPLE-ROWS-CALL            
                 MOVE WS-YES             TO RS-NORM-ACCOUNT             
                 MOVE WS-YES             TO RS-SSN-MATCH-IND            
              ELSE                                                      
                 MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE           
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE '7700'             TO ACTIVE-PARAGRAPH            
                 MOVE 'SELECT'           TO ABEND-FUNCTION              
                 MOVE 'CSS_ACCOUNT'      TO TABLE-1                     
CBSI             MOVE 'CSS_CUST_STATS'   TO TABLE-2                     
                 MOVE 'CUSTOMER_NO'      TO TABLE-ELEMENT-1             
CBSI             MOVE 'SSN'              TO TABLE-ELEMENT-2             
CBSI             MOVE PARM-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
CBSI             MOVE CE-SSN             TO HOSTVAR-ELEMENT-2           
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04171900
      * 7800-BAD-ACCT-ON-DRVR.                                         *04172000
      *    1. CHECK FOR BANKRUPT, WRITE-OFF, JUDGMENT ACCOUNT          *04172100
      *       ASSOCIATION BASED ON DRIVER LICENSE INFORMATION.         *04172200
      ******************************************************************04172400
       7800-BAD-ACCT-ON-DRVR.                                           
                                                                        
           EXEC SQL                                                     
             SELECT 'Y'                                                 
               INTO :RS-BAD-ACCOUNT                                     
               FROM CSS_ACCOUNT A,                                      
                    CSS_CUST_STATS B                                    
              WHERE A.CUSTOMER_NO         = B.CUSTOMER_NO               
                AND B.DRIVERS_LICENSE_NO  = :CE-DRIVERS-LICENSE-NO      
                AND B.CODE_STATE_ID       = :CE-CODE-STATE-ID           
                AND B.CUSTOMER_TYPE       IN ('R','S')                  
                AND (  A.CODE_ACCT_STAT   = :WS-WRITE-OFF-STATUS        
                    OR A.BANKRUPTCY_IND   = :WS-BANKRUPT-IND            
                    OR A.BANKRUPTCY_IND   = :WS-JUDGMENT-IND)           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE    = NOT-FOUND-CALL                 
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL               
               OR WS-ACTIVE-RETURN-CODE = MULTIPLE-ROWS-CALL            
                 MOVE WS-YES             TO RS-BAD-ACCOUNT              
                 MOVE WS-YES             TO RS-DRVR-LIC-MATCH-IND       
              ELSE                                                      
                 MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE           
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE '7800'             TO ACTIVE-PARAGRAPH            
                 MOVE 'SELECT'           TO ABEND-FUNCTION              
                 MOVE 'CSS_ACCOUNT'      TO TABLE-1                     
CBSI             MOVE 'CSS_CUST_STATS'   TO TABLE-2                     
CBSI             MOVE 'DRIVERS_LICENSE_NO' TO TABLE-ELEMENT-1           
CBSI             MOVE 'CODE_ACCT_STAT'   TO TABLE-ELEMENT-2             
CBSI             MOVE 'BANKRUPTCY_IND'   TO TABLE-ELEMENT-3             
CBSI             MOVE 'CODE_STATE_ID'    TO TABLE-ELEMENT-4             
CBSI             MOVE CE-DRIVERS-LICENSE-NO TO HOSTVAR-ELEMENT-1        
CBSI             MOVE WS-WRITE-OFF-STATUS TO HOSTVAR-ELEMENT-2          
CBSI             MOVE WS-BANKRUPT-IND    TO HOSTVAR-ELEMENT-3           
CBSI             MOVE CE-CODE-STATE-ID   TO HOSTVAR-ELEMENT-4           
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04176600
      * 7900-NORM-ACCT-ON-DRVR.                                        *04176700
      *    1. CHECK FOR ACCOUNT ASSOCIATION BASED ON DRIVERS LICENSE   *04176800
      *       INFORMATION.                                             *04176900
      ******************************************************************04177000
       7900-NORM-ACCT-ON-DRVR.                                          
                                                                        
           EXEC SQL                                                     
             SELECT 'Y'                                                 
               INTO :RS-NORM-ACCOUNT                                    
               FROM CSS_ACCOUNT A,                                      
                    CSS_CUST_STATS B                                    
              WHERE A.CUSTOMER_NO        = B.CUSTOMER_NO                
                AND B.DRIVERS_LICENSE_NO = :CE-DRIVERS-LICENSE-NO       
                AND B.CODE_STATE_ID      = :CE-CODE-STATE-ID            
                AND B.CUSTOMER_TYPE      IN ('R','S')                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE    = NOT-FOUND-CALL                 
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL               
               OR WS-ACTIVE-RETURN-CODE = MULTIPLE-ROWS-CALL            
                 MOVE WS-YES             TO RS-NORM-ACCOUNT             
                 MOVE WS-YES             TO RS-DRVR-LIC-MATCH-IND       
              ELSE                                                      
                 MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE           
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE '7900'             TO ACTIVE-PARAGRAPH            
                 MOVE 'SELECT'           TO ABEND-FUNCTION              
                 MOVE 'CSS_ACCOUNT'      TO TABLE-1                     
CBSI             MOVE 'CSS_CUST_STATS'   TO TABLE-2                     
                 MOVE 'CUSTOMER_NO'      TO TABLE-ELEMENT-1             
CBSI             MOVE 'DRIVERS_LICENSE_NO' TO TABLE-ELEMENT-2           
CBSI             MOVE 'CODE_STATE_ID'    TO TABLE-ELEMENT-3             
CBSI             MOVE PARM-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
CBSI             MOVE CE-DRIVERS-LICENSE-NO TO HOSTVAR-ELEMENT-2        
CBSI             MOVE CE-CODE-STATE-ID   TO HOSTVAR-ELEMENT-3           
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04180900
      * 8000-BAD-ACCT-ON-OTHR.                                         *04181000
      *    1. CHECK FOR BANKRUPT, WRITE-OFF, OR JUDGMENT ACCOUNT       *04181100
      *       ASSOCIATION BASED ON OTHER ID INFORMATION.               *04181200
      ******************************************************************04181300
       8000-BAD-ACCT-ON-OTHR.                                           
                                                                        
           EXEC SQL                                                     
             SELECT 'Y'                                                 
               INTO :RS-BAD-ACCOUNT                                     
               FROM CSS_ACCOUNT A,                                      
                    CSS_CUST_STATS B                                    
              WHERE A.CUSTOMER_NO    = B.CUSTOMER_NO                    
                AND B.OTHER_ID       = :CE-OTHER-ID                     
                AND B.OTHER_ID_TYPE  = :CE-OTHER-ID-TYPE                
                AND B.CUSTOMER_TYPE  IN ('R','S')                       
                AND (  A.CODE_ACCT_STAT = :WS-WRITE-OFF-STATUS          
                    OR A.BANKRUPTCY_IND = :WS-BANKRUPT-IND              
                    OR A.BANKRUPTCY_IND = :WS-JUDGMENT-IND)             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE    = NOT-FOUND-CALL                 
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL               
               OR WS-ACTIVE-RETURN-CODE = MULTIPLE-ROWS-CALL            
                 MOVE WS-YES             TO RS-BAD-ACCOUNT              
                 MOVE WS-YES             TO RS-OTHER-ID-MATCH-IND       
              ELSE                                                      
                 MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE           
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE '8000'             TO ACTIVE-PARAGRAPH            
                 MOVE 'SELECT'           TO ABEND-FUNCTION              
                 MOVE 'CSS_ACCOUNT'      TO TABLE-1                     
CBSI             MOVE 'CSS_CUST_STATS'   TO TABLE-2                     
CBSI             MOVE 'OTHER_ID'         TO TABLE-ELEMENT-1             
CBSI             MOVE 'OTHER_ID_TYPE'    TO TABLE-ELEMENT-2             
CBSI             MOVE 'CODE_ACCT_STAT'   TO TABLE-ELEMENT-3             
CBSI             MOVE 'BANKRUPTCY_IND'   TO TABLE-ELEMENT-4             
CBSI             MOVE CE-OTHER-ID        TO HOSTVAR-ELEMENT-1           
CBSI             MOVE CE-OTHER-ID-TYPE   TO HOSTVAR-ELEMENT-2           
CBSI             MOVE WS-WRITE-OFF-STATUS TO HOSTVAR-ELEMENT-3          
CBSI             MOVE WS-BANKRUPT-IND    TO HOSTVAR-ELEMENT-4           
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04185500
      * 8300-NORM-ACCT-ON-OTHR.                                        *04185600
      *    1. CHECK FOR ACCOUNT ASSOCIATION BASED ON OTHER ID          *04185700
      *       INFORMATION.                                             *04185800
      ******************************************************************04185900
       8300-NORM-ACCT-ON-OTHR.                                          
                                                                        
           EXEC SQL                                                     
             SELECT 'Y'                                                 
               INTO :RS-NORM-ACCOUNT                                    
               FROM CSS_ACCOUNT A,                                      
                    CSS_CUST_STATS B                                    
              WHERE A.CUSTOMER_NO    = B.CUSTOMER_NO                    
                AND B.OTHER_ID       = :CE-OTHER-ID                     
                AND B.OTHER_ID_TYPE  = :CE-OTHER-ID-TYPE                
                AND B.CUSTOMER_TYPE  IN ('R','S')                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE    = NOT-FOUND-CALL                 
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE  = SUCCESSFUL-CALL               
               OR WS-ACTIVE-RETURN-CODE = MULTIPLE-ROWS-CALL            
                 MOVE WS-YES             TO RS-NORM-ACCOUNT             
                 MOVE WS-YES             TO RS-OTHER-ID-MATCH-IND       
              ELSE                                                      
                 MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE           
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE '8300'             TO ACTIVE-PARAGRAPH            
                 MOVE 'SELECT'           TO ABEND-FUNCTION              
                 MOVE 'CSS_ACCOUNT'      TO TABLE-1                     
CBSI             MOVE 'CSS_CUST_STATS'   TO TABLE-2                     
CBSI             MOVE 'OTHER_ID'         TO TABLE-ELEMENT-1             
CBSI             MOVE 'OTHER_ID_TYPE'    TO TABLE-ELEMENT-2             
CBSI             MOVE 'CUSTOMER_NO'      TO TABLE-ELEMENT-3             
CBSI             MOVE CE-OTHER-ID        TO HOSTVAR-ELEMENT-1           
CBSI             MOVE CE-OTHER-ID-TYPE   TO HOSTVAR-ELEMENT-2           
CBSI             MOVE PARM-CUSTOMER-NO   TO HOSTVAR-ELEMENT-3           
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04189800
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     04189900
      ******************************************************************04190000
           EXEC SQL                                                     04190100
              INCLUDE CPDSP300                                          04190200
           END-EXEC.                                                    04190300
                                                                        
      ******************************************************************04200000
      *       END PROGRAM COPYLIB                                      *04210000
      ******************************************************************04220000
CVT999*    COPY CPD00302.                                               04230000
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000       ADD 1 TO CTR-ROWS.                                         
CVT000 8100-EXIT.                                                       
CVT000        EXIT.                                                     
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00321                                         00000200
CVT000     END-EXEC.                                                    00000300
