       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02251.                                         
COB303 DATE-WRITTEN.  NOVEMBER 28, 1994                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
      *                                                                *00110000
      *  TRANID:        S251                                           *00120063
      *  PROGRAM:       S251                                           *00130063
      *  CALLING SP:    PA_S251                                        *00140075
      *                                                                *00150000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *  THIS PROGRAM DOES THE FOLLOWING:                              *00190021
      *  1. RETIEVES POINT ID AND METER SUPPLYING.                     *00200089
      *                                                                *00209321
      ******************************************************************00210000
      *                                                                *00220000
      *                     PROGRAM MODIFICATION LOG                   *00230000
      *                                                                *00240000
      *    DATE    INITIALS   COMMENTS                                 *00250000
      *  --------  --------   ---------------------------------------  *00260000
      *  11/23/94    RTO      PROCEDURE ORIGINALLY CODED.              *00270063
      *                                                                *00280000
T4755 *  11/06/96    CSG      CHANGE DEFINITION OF POINT-ID WORKING    *        
      *                       STORAGE FIELDS FOR DCRS 1343 AND 1591.   *        
14202 *  01/06/98    AMG      CHANGED LOGIC SO THAT EXTRANEOUS         *        
      *                       MC05 RECORDS ARE NOT RECORDED.           *        
CBSI  *  11/19/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *             MADRAS    ABEND PARAMETERS                         *        
C24056*  01/23/03   FMB       TRANSLATE GIS_POINT_ID INTO TAG NUMBER   *        
C24056*                       FOR OMS REDESIGN.                        *        
T31339*  08/10/04   DD        ADDING DISTINCT TO POINT_ID CURSOR       *        
REARCH*  08/04/05   CVNS      RPC TO COBOL SP CONVERSION               *        
REARCH*             CHENNAI                                            *        
C33743*  05/09/08   SC41135   POINT ID PROJECT - REPLACING SNE_POINT   *        
C33743*                       WITH CSS_PIM_POINT TABLE                          
A04527*  06/07/13   MR7E794   REMOVED UNUSED COPYBOOK CWS00056.        *        
A05460*  01/27/15   MS7M727  REMOVED COMMENTED CODES AND REFERRED TABLE*        
      ******************************************************************00300000
      *                                                                *00310000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00320000
      *                                                                *00330000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00340000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00350000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00360000
      *  3000 - 4999  NOT USED                                         *00370000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00380000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00390000
      *  7000 - 7999  INPUT MODULES                                    *00400000
      *  8000 - 8999  OUTPUT MODULES                                   *00410000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00420000
      *                                                                *00430000
      ******************************************************************00440000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02251'.
MSQ017     COPY MFASQLM.
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02251 STARTS HERE'.                  
                                                                        
      ******************************************************************00610000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00620000
      ******************************************************************00630000
                                                                        
           COPY CCA00001.                                               00670000
REARCH     EXEC SQL                                                             
REARCH          INCLUDE CWSX0010                                                
REARCH     END-EXEC.                                                            
           COPY CWS00027.                                               00690013
           COPY CWS00303.                                               00700013
                                                                        
      ******************************************************************00770000
      *    WORK AREAS                                                  *00780000
      ******************************************************************00790000
                                                                        
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME             PIC X(08) VALUE 'CSR02251'.     
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  WS-ACCOUNT-NO            PIC 9(13).                      
COB305     05 WS-ACCOUNT-NO-NUM        PIC S9(13) COMP-3 VALUE 0.              
           05  WS-ROW-COUNT             PIC 9(5)  VALUE 0.              
REARCH     05  WS-SQLSTATE              PIC X(05) VALUE SPACES.         
                                                                        
       01  WS-LITERAL.                                                  
           05  WS-A                     PIC X(01) VALUE 'A'.            
           05  WS-B                     PIC X(01) VALUE 'B'.            
           05  WS-C                     PIC X(01) VALUE 'C'.            
           05  WS-G                     PIC X(01) VALUE 'G'.            
           05  WS-I                     PIC X(01) VALUE 'I'.            
           05  WS-M                     PIC X(01) VALUE 'M'.            
           05  WS-R                     PIC X(01) VALUE 'R'.            
                                                                        
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
                                                                        
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(09) COMP VALUE +0.       
T4755      05  RS-POINT-ID              PIC  X(10) VALUE SPACES.        
           05  RS-METER-SUPPLYING       PIC  X(15).                     
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE            PIC S9(09) COMP VALUE +0.       
REARCH     05  S-POINT-ID               PIC  X(10) VALUE SPACES.        
REARCH     05  S-METER-SUPPLYING        PIC  X(15).                     
REARCH                                                                  
REARCH 01  CSRERLOG-P.                                                  
REARCH       10  S-SP-NAME               PIC X(18)      VALUE SPACES.   
REARCH       10  S-SQLCODE               PIC S9(9) COMP VALUE 0.        
REARCH       10  S-SQLSTATE              PIC X(5)       VALUE ' '.      
REARCH       10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.   
REARCH       10  S-HOST-VARIABLES.                                      
REARCH           49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.          
REARCH           49  S-HOST-VARIABLES-V  PIC X(255).                    
REARCH       10  S-SQL-STATEMENT.                                       
REARCH           49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.          
REARCH           49  S-SQL-STATEMENT-V   PIC X(255).                    
REARCH       10  S-SQL-DESCRIPTION.                                     
REARCH           49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.          
REARCH           49  S-SQL-DESCRIPTION-V PIC X(255).                    
           EXEC SQL                                                     01229612
              INCLUDE SQLCA                                             01229712
           END-EXEC.                                                    01229812
                                                                        
           EXEC SQL                                                     01232412
              INCLUDE TBMODEL                                           01232565
           END-EXEC.                                                    01232612
                                                                        
           EXEC SQL                                                     01232865
              INCLUDE TBMTRENV                                          01232965
           END-EXEC.                                                    01233065
                                                                        
                                                                        
C33743     EXEC SQL                                                             
C33743       INCLUDE TBPIMPNT                                                   
C33743     END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
             DECLARE POINT-ID CURSOR FOR                                
C23743        SELECT DISTINCT TAG_NM, METER_SUPPLYING, AREA_ID          
T31339          FROM CSS_MTRD_ENVRNMT MN,                               
C33743               CSS_PIM_POINT PP                                   
               WHERE ACCOUNT_NO = :MN-ACCOUNT-NO                        
                 AND CODE_UTIL_TYPE = 'E'                               
C33743           AND MN.GIS_POINT_ID = PP.POINT_ID                      
C33743      ORDER BY AREA_ID, TAG_NM                                    
           END-EXEC.                                                    
                                                                        
REARCH LINKAGE SECTION.                                                 
REARCH 01  PARM-ACCOUNT-NO          PIC  X(13).                         
REARCH PROCEDURE DIVISION USING     PARM-ACCOUNT-NO.                    
                                                                        
      ******************************************************************01270000
      * 0000-MAINLINE                                                  *01280000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *01290000
      ******************************************************************01300000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************01410000
      * 0100-INITIALIZE                                                *01420000
      *                                                                *01430000
      *     1. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *01440000
      *     2. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *01450000
      *     3. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*01460000
      *                                                                *01470000
      ******************************************************************01480000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR CONTINUE END-EXEC.                
           EXEC SQL WHENEVER NOT FOUND CONTINUE END-EXEC.               
REARCH     PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
REARCH                                                                  
REARCH     EXEC SQL                                                     
REARCH           DECLARE C1 CURSOR  FOR                      
REARCH           SELECT                                                 
REARCH                 RETURN_CODE,                                     
REARCH                 LTRIM(RTRIM(POINT_ID))        AS  POINT_ID,             
REARCH                 LTRIM(RTRIM(METER_SUPPLYING)) AS  METER_SUPPLYING       
REARCH           FROM                                                   
REARCH              #CSR02251_R1                                 
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*          DECLARE C1 CURSOR WITH RETURN FOR                              
MFA-TR*          SELECT                                                         
MFA-TR*                RETURN_CODE,                                             
MFA-TR*                STRIP(POINT_ID)        AS  POINT_ID,                     
MFA-TR*                STRIP(METER_SUPPLYING) AS  METER_SUPPLYING               
MFA-TR*          FROM                                                           
MFA-TR*             SESSION.CSR02251_R1                                         
MFA-TR*    END-EXEC.                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
REARCH******************************************************************        
REARCH*0100A-DECLARE-GTT.                                              *        
REARCH******************************************************************        
REARCH 0100A-DECLARE-GTT.                                               
REARCH     MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR02251_R1'            
REARCH                                           TO S-SQL-STATEMENT-V.  
REARCH     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02251_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02251_R1
              (                                                   
REARCH               RETURN_CODE      INT,                          
REARCH               POINT_ID CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2,        
REARCH               METER_SUPPLYING CHAR(15)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH              )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH     MOVE SQLSTATE              TO WS-SQLSTATE.                   
REARCH     MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
REARCH     IF WS-SQLSTATE = '42710'                                     
REARCH         PERFORM 8000A-DELETE-GTT-ROWS                            
REARCH                                THRU 8000A-EXIT                   
REARCH     ELSE                                                         
REARCH        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
REARCH           NEXT SENTENCE                                          
REARCH        ELSE                                                      
REARCH           MOVE PROGRAM-NAME     TO ABEND-PROGRAM                 
REARCH           MOVE SQLCODE          TO ABEND-SQLCODE                 
REARCH           MOVE SQLSTATE         TO ABEND-SQLSTATE                
REARCH           MOVE '0100A'          TO ACTIVE-PARAGRAPH              
REARCH           MOVE 'DECLARE GTT'    TO ABEND-FUNCTION                
REARCH           MOVE SPACES           TO                               
REARCH                                      ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH           MOVE 'CSR02251_R1'    TO TABLE-1                       
REARCH           MOVE SPACES           TO TABLE-ELEMENT-1               
REARCH           MOVE SPACES           TO HOSTVAR-ELEMENT-1             
REARCH           PERFORM 9900-SQL-ERROR-ROUTINE                         
REARCH                                 THRU  9900-EXIT                  
REARCH        END-IF                                                    
REARCH     END-IF.                                                      
REARCH 0100A-EXIT.                                                      
REARCH     EXIT.                                                        
                                                                        
      ******************************************************************01921202
      * 2000-PROCESS-OUTPUT.                                           *01921302
      *                                                                *01921402
      *     1. DESCRIBE RESULT SET                                     *01921502
      *     2. UPDATE DB2 DATA                                         *01921602
      *     3. BUILD RESULT SET                                        *01921702
      *     4. SEND RESULT SET                                         *01921802
      *                                                                *01921902
      ******************************************************************01922002
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 2200-PROCESS-FETCH THRU 2200-EXIT.                   
           MOVE 1      TO RS-RETURN-CODE.                               
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
REARCH******************************************************************        
REARCH*2000A-MOVE-RESULT.                                              *        
REARCH******************************************************************        
REARCH 2000A-MOVE-RESULT.                                               
REARCH            MOVE  RS-RETURN-CODE       TO   S-RETURN-CODE.        
REARCH            MOVE  RS-POINT-ID          TO   S-POINT-ID.           
REARCH            MOVE  RS-METER-SUPPLYING   TO   S-METER-SUPPLYING.    
REARCH 2000A-EXIT.                                                      
REARCH      EXIT.                                                       
                                                                        
      ******************************************************************01924000
      * 2100-DESCRIBE-RESULT                                           *01930000
      *                                                                *01940000
      *     DESCRIBE EACH COLUMN IN THE RESULT SET.                    *01950000
      *                                                                *01960000
      ******************************************************************01970000
                                                                        
                                                                        
       2200-PROCESS-FETCH.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO   TO WS-ACCOUNT-NO.                     
           MOVE WS-ACCOUNT-NO     TO WS-ACCOUNT-NO-NUM.                 
           MOVE WS-ACCOUNT-NO-NUM TO MN-ACCOUNT-NO.                     
           PERFORM 7200-OPEN-POINT-ID-CURSOR  THRU 7200-EXIT.           
           PERFORM 7210-FETCH-POINT-ID-CURSOR THRU 7210-EXIT            
              UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.              
           PERFORM 7220-CLOSE-POINT-ID-CURSOR THRU 7220-EXIT.           
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-OPEN-POINT-ID-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
                OPEN POINT-ID                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7200'              TO ACTIVE-PARAGRAPH              
              MOVE 'OPEN'              TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
CBSI          MOVE 'CSS_MTRD_ENVRNMT'  TO TABLE-1                       
C33743        MOVE 'CSS_PIM_POINT'     TO TABLE-2                       
CBSI          MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
CBSI          MOVE MN-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
CBSI          PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT
           END-IF.          
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7210-FETCH-POINT-ID-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
                FETCH POINT-ID                                          
C33743           INTO :PP-TAG-NM,                                       
                      :MN-METER-SUPPLYING,                              
C33743                :PP-AREA-ID                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C24056     EVALUATE WS-ACTIVE-RETURN-CODE                               
C24056         WHEN SUCCESSFUL-CALL                                     
C33743             MOVE PP-AREA-ID          TO RS-POINT-ID(1:3)         
C33743             MOVE PP-TAG-NM              TO RS-POINT-ID(4:7)      
                   MOVE MN-METER-SUPPLYING  TO RS-METER-SUPPLYING       
                   ADD 1                       TO WS-ROW-COUNT          
REARCH             PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT          
                   PERFORM 8100-SEND-RESULT    THRU 8100-EXIT           
C24056         WHEN NOT-FOUND                                           
14202              IF WS-ROW-COUNT < 1                                  
14202                 MOVE SPACES               TO RS-POINT-ID          
14202                 MOVE SPACES               TO RS-METER-SUPPLYING   
REARCH                PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT         
14202                 PERFORM 8100-SEND-RESULT  THRU 8100-EXIT          
REARCH                MOVE NOT-FOUND            TO WS-ACTIVE-RETURN-CODE
14202              END-IF                                               
C24056         WHEN OTHER                                               
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7210'             TO ACTIVE-PARAGRAPH          
                   MOVE 'FETCH'            TO ABEND-FUNCTION            
                   MOVE SPACES             TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                   MOVE 'CSS_MTRD_ENVRNMT' TO TABLE-1                   
C33743             MOVE 'CSS_PIM_POINT'    TO TABLE-2                   
CBSI               MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1           
                   MOVE PARM-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1         
CBSI               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
C24056     END-EVALUATE.                                                
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7220-CLOSE-POINT-ID-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
                CLOSE POINT-ID                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7220'              TO ACTIVE-PARAGRAPH              
              MOVE 'CLOSE'             TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_MTRD_ENVRNMT'  TO TABLE-1                       
C33743        MOVE 'CIS_PIM_POINT'     TO TABLE-1                       
CBSI          MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE PARM-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1             
CBSI          PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT
           END-IF.          
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
REARCH******************************************************************        
REARCH*8000A-DELETE-GTT-ROWS.                                          *        
REARCH******************************************************************        
REARCH 8000A-DELETE-GTT-ROWS.                                           
REARCH     MOVE 'DELETE ROWS' TO S-SQL-STATEMENT-V.                     
REARCH     EXEC SQL                                                     
REARCH          DELETE FROM #CSR02251_R1                         
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM SESSION.CSR02251_R1                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH     MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
REARCH     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
REARCH          NEXT SENTENCE                                           
REARCH     ELSE                                                         
REARCH          MOVE PROGRAM-NAME     TO ABEND-PROGRAM                  
REARCH          MOVE SQLCODE           TO ABEND-SQLCODE                 
REARCH          MOVE '8000A'           TO ACTIVE-PARAGRAPH              
REARCH          MOVE 'DELETE'          TO ABEND-FUNCTION                
REARCH          MOVE SPACES            TO ABEND-SQL-PREDICATES          
REARCH                                          ABEND-TABLES            
REARCH          MOVE 'CSR02251_R1'     TO TABLE-1                       
REARCH          MOVE SPACES            TO TABLE-ELEMENT-1               
REARCH          MOVE SPACES            TO HOSTVAR-ELEMENT-1             
REARCH          PERFORM 9000-SEND-ERROR-RESULT                          
REARCH                                 THRU 9000-EXIT                   
REARCH          PERFORM 9900-SQL-ERROR-ROUTINE                          
REARCH                                 THRU 9900-EXIT                   
REARCH     END-IF.                                                      
REARCH 8000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH******************************************************************        
REARCH*8100-SEND-RESULT.                                               *        
REARCH******************************************************************        
REARCH 8100-SEND-RESULT.                                                
REARCH     EXEC SQL                                                     
REARCH          INSERT INTO #CSR02251_R1                         
REARCH          (                                                       
REARCH               RETURN_CODE,                                       
REARCH               POINT_ID,                                          
REARCH               METER_SUPPLYING                                    
REARCH          )                                                       
REARCH          VALUES                                                  
REARCH          (                                                       
REARCH               :S-RETURN-CODE,                                    
REARCH               :S-POINT-ID,                                       
REARCH               :S-METER-SUPPLYING                                 
REARCH           )                                                      
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR02251_R1                                 
MFA-TR*         (                                                               
MFA-TR*              RETURN_CODE,                                               
MFA-TR*              POINT_ID,                                                  
MFA-TR*              METER_SUPPLYING                                            
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*              :S-RETURN-CODE,                                    02354417
MFA-TR*              :S-POINT-ID,                                               
MFA-TR*              :S-METER-SUPPLYING                                         
MFA-TR*          )                                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
REARCH                                                                  
REARCH     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
REARCH        ADD +1                    TO CTR-ROWS                     
REARCH     ELSE                                                         
REARCH        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
REARCH        MOVE SQLCODE              TO ABEND-SQLCODE                
REARCH        MOVE '8100'               TO ACTIVE-PARAGRAPH             
REARCH        MOVE 'INSERT'             TO ABEND-FUNCTION               
REARCH        MOVE SPACES               TO ABEND-SQL-PREDICATES         
REARCH                                     ABEND-TABLES                 
REARCH        MOVE 'CSR02251_R1'        TO TABLE-1                      
REARCH        MOVE SPACES               TO TABLE-ELEMENT-1              
REARCH        MOVE SPACES               TO HOSTVAR-ELEMENT-1            
REARCH        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
REARCH     END-IF.                                                      
REARCH 8100-EXIT.                                                       
REARCH     EXIT.                                                        
      ******************************************************************02354500
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *02354600
      ******************************************************************02354700
REARCH      EXEC SQL                                                            
REARCH         INCLUDE CPDSP300                                                 
REARCH      END-EXEC.                                                           
      ******************************************************************02355200
      *       END PROGRAM COPYLIB                                      *02356000
      ******************************************************************02360000
REARCH      EXEC SQL                                                            
REARCH         INCLUDE CPD00320                                                 
REARCH      END-EXEC.                                                           
