       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02249.                                         
COB303 DATE-WRITTEN.      NOVEMBER 17, 1994.                            
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
      *                                                                *00110000
      *  TRANID:        S249                                           *00120000
      *  PROGRAM:       S249                                           *00130000
      *  CALLING SP:    PA_S249                                        *00140000
      *                                                                *00150000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *  THIS PROGRAM UPDATES THE CSS_BANK_EFT, CSS_PNDNG_BNK_DRFT,    *00190000
      *  AND THE CSS_ACCOUNT TABLES WITH BANK DRAFT INFORMATION.       *00200000
      ******************************************************************00210000
      *                                                                *00220000
      *                     PROGRAM MODIFICATION LOG                   *00230000
      *                                                                *00240000
      *    DATE    INITIALS   COMMENTS                                 *00250000
      *  --------  --------   ---------------------------------------  *00260000
      *  11/17/94    MRB      CREATED.                                 *00270000
      *  07/26/95    WMG      MODIFIED TO ADD TRANSACTION JOURNALING   *00280000
      *                       TABLE ID'S.                              *00290000
      *  11/29/95    MR       MODIFIED TO UPDATE AT-CODES-PRESENT FOR  *00300000
      *                       FOR BANK-EFT                             *00310000
      *  06/04/96    TCB      MOVE SPACES TO ANY DATE THAT IS NULL SO  *00320000
      *                       WHEN IT IS COMPARED TO THE MARMS FOR     *00330000
      *                       AR TRANS HIST IT WILL NOT ASSUME A       *00340000
      *                       CHANGE WAS MADE WHEN THE PARMS ARE       *00350000
      *                       SPACES.  TPR 4440.                       *00360000
      *  06/25/96    JBS      BANK-EFT CODES-DATA-PRESENT ENABLED FOR  *00370000
      *                       PRENOTE AS WELL AS CONFIRMED. TPR4717    *00380000
      *  07/10/96    SONALI   TPR#4864 --                              *00390000
      *                       THE DRAFT DATE IS NOT AN ENTERED FIELD   *00400000
      *                       SO IT NEED NOT                           *00410000
      *                       APPEAR IN THE TRANSACTION HISTORY LIST   *00420000
      *  07/15/96    SONALI   TPR#4915 --                              *00430000
      *                       FOR A 'SUSPENDED' BANK DRAFT THERE SHOULD*00440000
      *                       BE NO RECORDS IN CSS_PNDNG_BNK_DRFT TABLE*00450000
      *  07/17/96    SONALI   TPR#4941 --                              *00460000
      *                       FOR 'INCOMPLETE' BANK DRAFTS, SNAPSHOT   *00470000
      *                       BUTTON IN PANEL012 SHOULD BE ACTIVATED   *00480000
      *  07/22/96    SONALI   TPR#4991 --                              *00490000
      *                       TRN HIST WRITES  'DID NOT EX' INSTEAD OF *00500000
      *                       'DID NOT EXIST'                          *00510000
      *  07/25/96    SONALI   TPR#4986 --                              *00520000
      *                       ACCT NO. WRITTEN TWICE IN PANEL156 WHEN  *00530000
      *                       BANK DRAFT CREATED & SET TO PRE-NOTE     *00540000
      *  01/25/97    RPG      TPR#8718 --                              *00550000
      *                       REMOVED THE ADDITION OF CUSTOMER NUMBER  *00560000
      *                       TO THE TRAN-HIST.                        *00570000
      *  01/26/97    RPG      TPR#8791 ADDED A TEST IN UPDATE TO SEE IF*00580000
      *                       THE DID NOT EXIST ON THE TABLE, BUT HAD A*00590000
      *                       STATUS CODE OF SUSPEND.                   00600000
      *  02/08/97    SG       TPR#9176 FIX JOURNALLING ERRORS.         *00610000
      *  02/27/97    RPG      TPR#8718 - FIXED IT SO THE CUSTOMER AND  *00611000
      *                       PREMISE NUMBER ARE ZERO.                  00612000
TP9490*  03/11/97    KOG      SET THE CORRECT PRENOTE DATE WHEN UPDATING00613000
TP9700*  03/31/97    AS       MODIFIED THE LIST OF COLUMNS BEING       *00614000
TP9700*                       WRITTEN TO TRANSACTION HISTORY.          *00615000
TP9675*  03/31/97    AS       MODIFIED LOGIC TO IGNORE BANK INFO       *00616000
TP9675*                       FOR A BANK ID OF ZERO. THIS VALUE OF 0   *00617000
TP9675*                       IS REQUIRED FOR RI PURPOSES AND INDICATES*00618000
TP9675*                       THAT BANK INFO HAS NOT BEEN ENTERED.     *00619000
T11366*  05/28/97    AS       ADDED LOGIC TO INSERT MNT TRANS HIST ROW *00619100
T11366*                       WHEN A PENDING BANK DRAFT IS DELETED.    *00619200
T11443*  06/09/97    AS       ADDED LOGIC TO DELETE ROW FROM           *00619300
T11443*                       CSS_PNDNG_BNK_DRFT WHEN STATUS IS CHANGED*00619400
T11443*                       TO CONFIRMED.                            *00619500
T18330*  10/29/98    CADODD   TPR18330 --                              *        
T18330*                       FOR A 'SUSPENDED' BANK DRAFT THERE SHOULD*        
T18330*                       BE NO RECORDS IN CSS_PNDNG_BNK_DRFT TABLE*        
T18330*                       SO WILL DELETE ANY EXISTING ROWS IN TABLE*        
CBSI  *  11/19/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *             MADRAS    ABEND PARAMETERS                         *        
23549 *  02/05/01   DPS       EPAY BUSINESS REVISIONS                           
23549 *                       DELETED ALL COMMENTED SECTIONS                    
23549 *                       ADDED UPDATE TYPES - 'S' FOR SIGNUP,              
23549 *                       Q FOR STOP PAYMENT BOTH TO BE CALLED              
23549 *                       FROM WEB                                          
24525 *  7/13/01   DPS        PREVENT UPDATE FAIL WITH 100 FOR                  
24525 *                       DELETION OF PRE-NOTE.                             
25964 *  8/02/02   DPS        EDRAFT REVISIONS                                  
27981 *  11/21/02  DPS        CHECK FOR SPACE COMING IN PARMS FROM              
27981 *                       WEB FOR CANCELLING EPAY                           
C29529*  04/08/04  JS83520    E-CUSTOMER SELF SERVICE PROJECT CHANGES  *        
C31085*  10/08/04  JAYANTHI   ALLOW REMITTANCE FOLKS TO CHANGE BETWEEN *        
C31085*                       EPAY, DRAFT AND EDRAFT FROM THE DROPDOWN *        
C31085*                       IN PANEL194.                             *        
C29533*  02/03/05  SS19371    E-CUSTOMER-CUSTOMER INFO THREAD                   
C29533*                       DELETE ROWS IN CSS_ACCT_ATTRIBUTE (IF ANY)        
C29533*                       WHEN ACCT IS ET UP ON EPAY OR EDRAFT              
REARCH*  06/02/05  CVNS       RPC TO COBOL SP CONVERSION               *        
REARCH*            CHENNAI                                             *        
C36298*  10/25/07  CB18344    ACTIVITY 5 - MADE CHANGE TO ALLOW ACCOUNT*        
C36298*                       NAME FIELD TO BE UPDATED ON PANEL194.    *        
C36298*  10/26/07  CB18344    ACTIVITY 1 - ADD TRANS HIST ROW TO BOTH  *        
C36298*                       CUST AND ACCOUNT TRANS HIST WHEN ADDING  *        
C36298*                       A BANK.                                  *        
C36298*  10/30/07  CB18344    ACTIVITY 7 - MADE CHANGE TO ALLOW ACCOUNT*        
C36298*                       NUMBER FIELD TO BE UPDATED ON PANEL194.  *        
C36437*  02/14/008  CB18344   MADE CHANGES TO RETURN APPLIED FLAG               
C36437*                       TO PANEL FOR REALTIME EPAYS.                      
C34097*  02/14/008  CB18344   PERFORMANCE TUNING CHANGES.                       
PRJ547*  03/18/2009 CB18344   MADE CHANGES TO STOP PROBLEMS WHEN                
PRJ547*                       TRANSFERRING BANK INFORMATION VIA                 
PRJ547*                       PANEL038.                                         
A01679*  10/01/2009 DB41297   DO NOT SET PENDING ACCOUNTS TO           *        
A01679*                       PAPERLESS.                               *        
A36298*  12/16/2009 CB18344   MADE CHANGES TO INCLUDE BANK NICKNAME    *        
A36298*                       WHEN ENROLLING AND ADDING A NEW BANK.    *        
A02661*  08/18/2010 CB18344   MADE CHANGES TO CORRECT MNT TRANS HIST   *        
A02661*                       APPL PROGRAM ID WHEN CANCELLING EDRAFT   *        
A02661*                       VIA THE WEB.                             *        
A03139*  12/09/2011 CB18344   MADE CHANGES TO ADD MORE DESCRIPTIONS IN *        
A03139*                       TRANS HIST WHEN PREVENTING AN EPAYMENT.  *        
      *                                                                *        
      ******************************************************************00620000
      ******************************************************************00630000
      *                                                                *00640000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00650000
      *                                                                *00660000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00670000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00680000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00690000
      *  3000 - 4999  NOT USED                                         *00700000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00710000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00720000
      *  7000 - 7999  INPUT MODULES                                    *00730000
      *  8000 - 8999  OUTPUT MODULES                                   *00740000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00750000
      *                                                                *00760000
      ******************************************************************00770000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02249'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02249 STARTS HERE'.                  
                                                                        
      ******************************************************************00860000
      *    DB2 INCLUDES                                                *00870000
      ******************************************************************00880000
                                                                        
           EXEC SQL                                                     00900000
              INCLUDE SQLCA                                             00910000
           END-EXEC.                                                    00920000
                                                                        
           EXEC SQL                                                     00940000
              INCLUDE TBBNKEFT                                          00950000
           END-EXEC.                                                    00960000
                                                                        
           EXEC SQL                                                     00980000
              INCLUDE TBPDBKDF                                          00990000
           END-EXEC.                                                    01000000
                                                                        
           EXEC SQL                                                     01020000
              INCLUDE TBACCT                                            01030000
           END-EXEC.                                                    01040000
                                                                        
C36298*   CSS_ACCT_ATTRIBUTE                                                    
C36298                                                                  
C36298     EXEC SQL                                                     01020000
C36298        INCLUDE TBACTATT                                          01030000
C36298     END-EXEC.                                                    01040000
C36298                                                                  
C36298*   CSS_BANK                                                              
C36298                                                                  
C36298     EXEC SQL                                                     01020000
C36298        INCLUDE TBBANK                                            01030000
C36298     END-EXEC.                                                    01040000
C36298                                                                  
C36437*   CSS_PAYMENT_TRANS                                                     
C36437                                                                  
C36437     EXEC SQL                                                     01020000
C36437        INCLUDE TBPMTRAN                                          01030000
C36437     END-EXEC.                                                    01040000
C36437                                                                  
                                                                        
      * ADDED FOR JOURNALING                                            01060000
           EXEC SQL                                                     01070000
              INCLUDE TBMNHIST                                          01080000
           END-EXEC.                                                    01090000
                                                                        
           EXEC SQL                                                     01110000
              INCLUDE TBMNHDT                                           01120000
           END-EXEC.                                                    01130000
                                                                        
           EXEC SQL                                                     01150000
              INCLUDE TBCSTBNK                                          01160000
           END-EXEC.                                                    01170000
                                                                        
C29529     EXEC SQL                                                     01150000
C29529        INCLUDE TBDELQ                                            01160000
C29529     END-EXEC.                                                    01170000
                                                                        
      ******************************************************************01190000
      *    COBOL WORKING STORAGE COPY BOOKS                            *01200000
      ******************************************************************01210000
                                                                        
      ******************************************************************01230000
      *    COPYBOOKS                                                   *01240000
      ******************************************************************01250000
                                                                        
           COPY CCA00001.                                               01290000
           COPY CWS00027.                                               01310000
           COPY CWS00303.                                               01320000
      *********************************                                 01330000
      * COPYBOOK ADDED - MR  11/29/95 *                                 01340000
      *********************************                                 01350000
           COPY CWS00056.                                               01360000
                                                                        
           EXEC SQL                                                     01380000
              INCLUDE CWS00013                                          01390000
           END-EXEC.                                                    01400000
                                                                        
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CWSX0010                                                 
REARCH     END-EXEC.                                                            
      ******************************************************************01420000
      *    WORK AREAS                                                  *01430000
      ******************************************************************01440000
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
REARCH     05  PARM-COMMENT-LEN-NUM     PIC S9(04) COMP VALUE 0.        
C29529     05  PARM-NICKNAME-LEN-NUM    PIC S9(04) COMP VALUE 0.        
REARCH     05  PARM-ACCOUNT-NO-TEMP     PIC X(13).                      
REARCH     05  PARM-ACCOUNT-NO-RED      REDEFINES PARM-ACCOUNT-NO-TEMP  
REARCH                                  PIC 9(13).                      
REARCH     05  PARM-COMMENT-LEN-TEMP    PIC X(04) VALUE SPACES.         
REARCH     05  PARM-COMMENT-LEN-RED     REDEFINES PARM-COMMENT-LEN-TEMP 
REARCH                                  PIC 9(04).                      
REARCH     05  PARM-NICKNAME-LEN-TEMP   PIC X(04) VALUE SPACES.         
REARCH     05  PARM-NICKNAME-LEN-RED    REDEFINES                       
REARCH                            PARM-NICKNAME-LEN-TEMP PIC 9(04).     
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
C36437     05  S-APPLIED-FL            PIC X(01) VALUE SPACES.          
                                                                        
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-BANK-ACCOUNT-NAME.                                    
               07  WS-BANK-ACCT-1-30   PIC X(30) VALUE SPACES.          
               07  FILLER              PIC X(20) VALUE SPACES.          
REARCH     05  PROGRAM-NAME            PIC X(08) VALUE 'CSR02249'.      
REARCH     05  WS-SQLSTATE             PIC X(05) VALUE SPACES.          
           05  WS-ACCOUNT-NO-NUM       PIC S9(13) COMP-3 VALUE ZERO.    
           05  WS-CUSTOMER-NO-NUMERIC  PIC 9(10) VALUE ZERO.            
           05  WS-CUSTOMER-NO          PIC X(10) VALUE SPACES.          
           05  WS-BANK-ID-NUM          PIC S9(06) COMP-3 VALUE ZERO.    
           05  WS-BANK-ID              PIC X(06).                       
           05  WS-BANK-ID-NUMERIC      REDEFINES WS-BANK-ID             
                                       PIC 9(06).                       
C29529     05  WS-CUST-BANK-SEQ-NO     PIC X(09).                       
C29529     05  WS-CUST-BANK-SEQ-NUM    REDEFINES WS-CUST-BANK-SEQ-NO    
T29520                                 PIC 9(09).                       
           05  WS-DRAFT-AMT-NUMERIC    PIC 9(9).9(2).                   
           05  WS-DRAFT-AMT            REDEFINES WS-DRAFT-AMT-NUMERIC   
                                       PIC X(12).                       
A03139     05  WS-DRAFT-AMT-DISPLAY    PIC $$$,$$9.99.                  
           05  WS-TRAN-CD-NUMERIC      PIC 9(04).                       
           05  WS-TRAN-CD              REDEFINES WS-TRAN-CD-NUMERIC     
                                       PIC X(04).                       
           05  WS-NULL-STATUS-DATE     PIC S9(04) COMP.                 
           05  WS-NULL-RESUME-DATE     PIC S9(04) COMP.                 
           05  WS-NULL-EST-DATE        PIC S9(04) COMP.                 
           05  WS-NULL-DRFT-DATE       PIC S9(04) COMP.                 
           05  WS-NULL-ACTION-DATE     PIC S9(04) COMP.                 
           05  WS-NULL-PRENOTE-DATE    PIC S9(04) COMP VALUE -1.        
           05  WS-NULL-CUST-SEQ-NO     PIC S9(04) COMP VALUE -1.        
           05  WS-TRAN-APPL-NO         PIC S9(04) COMP VALUE 0.         
C29529     05  WS-NULL-LAST-DRFT-DT    PIC S9(04) COMP.                 
C29529     05  WS-CST-BNK-EXISTS-FLAG  PIC X(01) VALUE 'N'.             
C29529         88 WS-CST-BNK-EXISTS              VALUE 'Y'.             
C29529         88 WS-CST-BNK-NOT-EXISTS          VALUE 'N'.             
C29529     05  WS-NICKNAME-EXISTS-FLAG PIC X(01) VALUE 'N'.             
C29529         88 WS-NICKNAME-EXISTS             VALUE 'Y'.             
C29529         88 WS-NICKNAME-NOT-EXISTS         VALUE 'N'.             
           05  WS-BANK-EXISTS-FLAG     PIC X(01) VALUE 'N'.             
               88 WS-BANK-EXISTS                 VALUE 'Y'.             
           05  WS-PEND-EXISTS-FLAG     PIC X(01) VALUE 'N'.             
               88 WS-PEND-EXISTS                 VALUE 'Y'.             
           05  WS-ACCOUNT-EXISTS-FLAG  PIC X(01) VALUE 'N'.             
               88  WS-ACCT-EXISTS                VALUE 'Y'.             
23549      05  WS-EPAY-UPDATE     PIC X(01) VALUE 'Q'.                  
23549      05  WS-EPAY-MAINTAIN   PIC X(01) VALUE 'S'.                  
23549      05  WS-CODE-SOURCE-DRAFT  PIC X(01) VALUE 'S'.               
23549      05  WS-CODE-SOURCE-EPAY   PIC X(01) VALUE 'E'.               
25964      05  WS-CODE-SOURCE-EDRAFT PIC X(01) VALUE 'I'.               
25964      05  WS-INIT-REMIT         PIC X(02) VALUE '01'.              
25964      05  WS-INIT-WEB           PIC X(02) VALUE '02'.              
C29529     05  WS-OLD-STATUS-CODE    PIC X(01).                         
C29529     05  WS-OLD-INIT-TYP-CD    PIC X(02).                         
C29529     05  WS-PRENOTE-ACCT       PIC 9(01) VALUE 0.                 
C29529         88 PRENOTE-YES                  VALUE 1.                 
C29529         88 PRENOTE-NO                   VALUE 2.                 
C29529     05  WS-ADD-UPDATE-FL      PIC X(01) VALUE 'A'.               
C29529         88 ADD-BANK                     VALUE 'A'.               
C29529         88 UPDATE-BANK                  VALUE 'U'.               
C36298     05  WS-UPD-BANK-ACCT-INFO PIC X(01) VALUE 'N'.               
C36298     05  WS-UPD-BANK-ACCT-NO   PIC X(01) VALUE 'N'.               
C36298     05  WS-NNAME-LEN          PIC 9(04) VALUE 0.                 
C36298     05  WS-TRANS-COMMENTS.                                       
C36298         10 WS-TRANS-MSG       PIC X(35) VALUE                    
C36298         'PRIMARY BANK ACCT NUMBER CHANGED - '.                   
C36298         10 WS-TRANS-NNAME     PIC X(50) VALUE SPACES.            
C36298     05  WS-DELETED-PRENOTE    PIC X(01) VALUE 'N'.               
C36298     05  WS-HOLD-BANK-ID-NUM   PIC S9(06) COMP-3 VALUE ZERO.      
C36298     05  WS-HOLD-BANK-ID       PIC X(06).                         
C36298     05  WS-HOLD-BANK-ID-NUMERIC REDEFINES WS-HOLD-BANK-ID        
C36298                                 PIC 9(06).                       
C36298     05  WS-NEW-BANK-NAME      PIC X(50) VALUE SPACES.            
C36298     05  WS-OLD-BANK-NAME      PIC X(50) VALUE SPACES.            
C36298     05  WS-OLD-BANK-ROUTING   PIC X(09) VALUE SPACES.            
C36298     05  WS-NEW-BANK-ROUTING   PIC X(09) VALUE SPACES.            
REARCH*                                                                         
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
REARCH     10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
REARCH     10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
REARCH     10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
REARCH         49  S-HOST-VARIABLES-V  PIC X(255).                      
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-STATEMENT-V   PIC X(255).                      
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-DESCRIPTION-V PIC X(255).                      
REARCH*                                                                         
REARCH LINKAGE SECTION.                                                 
REARCH*                                                                         
REARCH 01  PARM-UPDATE-TYPE         PIC X(01).                          
REARCH 01  PARM-ACCOUNT-NO          PIC X(13).                          
REARCH 01  PARM-STATUS-CODE         PIC X(01).                          
REARCH 01  PARM-STATUS-CHANGE-DT    PIC X(10).                          
REARCH 01  PARM-RESUME-DRAFT-DT     PIC X(10).                          
REARCH 01  PARM-REQSTED-DRAFT-DAY   PIC X(02).                          
REARCH 01  PARM-DRAFT-CYCLE         PIC X(02).                          
REARCH 01  PARM-ESTABLISHED-DATE    PIC X(10).                          
REARCH 01  PARM-REMARKS             PIC X(26).                          
REARCH 01  PARM-BANK-ACCOUNT-NAME   PIC X(50).                          
REARCH 01  PARM-BANK-ACCT-NO        PIC X(19).                          
REARCH 01  PARM-ACCT-TYPE-CD        PIC X(01).                          
REARCH 01  PARM-DATE-TO-CHG-DRAFT   PIC X(10).                          
REARCH 01  PARM-BANK-ID             PIC X(06).                          
REARCH 01  PARM-USER-ID             PIC X(07).                          
REARCH 01  PARM-RESP-AREA-ID        PIC X(03).                          
REARCH 01  PARM-COMMENT-TEXT        PIC X(210).                         
REARCH 01  PARM-COMMENT-LEN         PIC X(04).                          
REARCH 01  PARM-LAST-DRAFT-CYCLE    PIC X(02).                          
REARCH 01  PARM-PRENOTE-DATE        PIC X(10).                          
REARCH 01  PARM-INIT-TYPE-CD        PIC X(02).                          
REARCH 01  PARM-NICKNAME-LEN        PIC X(04).                          
REARCH 01  PARM-NICKNAME-TEXT       PIC X(50).                          
REARCH 01  PARM-CUST-BNK-SEQ-NO     PIC X(09).                          
REARCH 01  PARM-PYMT-TRN-TIMESTMP   PIC X(26).                          
REARCH 01  PARM-EPAY-DRFT-FL        PIC X(01).                          
REARCH*                                                                         
HPCCDM*EJECT                                                            02460000
REARCH*                                                                         
REARCH PROCEDURE DIVISION USING PARM-UPDATE-TYPE                        
REARCH                          PARM-ACCOUNT-NO                         
REARCH                          PARM-STATUS-CODE                        
REARCH                          PARM-STATUS-CHANGE-DT                   
REARCH                          PARM-RESUME-DRAFT-DT                    
REARCH                          PARM-REQSTED-DRAFT-DAY                  
REARCH                          PARM-DRAFT-CYCLE                        
REARCH                          PARM-ESTABLISHED-DATE                   
REARCH                          PARM-REMARKS                            
REARCH                          PARM-BANK-ACCOUNT-NAME                  
REARCH                          PARM-BANK-ACCT-NO                       
REARCH                          PARM-ACCT-TYPE-CD                       
REARCH                          PARM-DATE-TO-CHG-DRAFT                  
REARCH                          PARM-BANK-ID                            
REARCH                          PARM-USER-ID                            
REARCH                          PARM-RESP-AREA-ID                       
REARCH                          PARM-COMMENT-TEXT                       
REARCH                          PARM-COMMENT-LEN                        
REARCH                          PARM-LAST-DRAFT-CYCLE                   
REARCH                          PARM-PRENOTE-DATE                       
REARCH                          PARM-INIT-TYPE-CD                       
REARCH                          PARM-NICKNAME-LEN                       
REARCH                          PARM-NICKNAME-TEXT                      
REARCH                          PARM-CUST-BNK-SEQ-NO                    
REARCH                          PARM-PYMT-TRN-TIMESTMP                  
REARCH                          PARM-EPAY-DRFT-FL.                      
                                                                        
      ******************************************************************02490000
      * 0000-MAINLINE                                                  *02500000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *02510000
      ******************************************************************02520000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02640000
      * 0100-INITIALIZE                                                *02650000
      *                                                                *02660000
      *     1. RESET DB2 ERROR HANDLERS                                *02670000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *02680000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *02690000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*02700000
      *                                                                *02710000
      ******************************************************************02720000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
C34097                                                                  
C34097     EXEC SQL                                                     
C34097         DECLARE C1 CURSOR  FOR                        
C34097          SELECT :S-RETURN-CODE AS RETURN_CODE                    
C34097                ,:S-APPLIED-FL  AS APPLIED_FL                     
C34097            FROM CIS.SYSDUMMY1                                 
C34097     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*         SELECT :S-RETURN-CODE AS RETURN_CODE                            
MFA-TR*               ,:S-APPLIED-FL  AS APPLIED_FL                             
MFA-TR*           FROM SYSIBM.SYSDUMMY1                                         
MFA-TR*    END-EXEC.                                                    02850000
C34097                                                                  
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03000000
      * 1000-PROCESS-INPUT                                             *03010000
      *                                                                *03020000
      *     1. RECEIVE PARMS.                                          *03030000
      *                                                                *03040000
      ******************************************************************03050000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
C34097     INITIALIZE GTT-RETURN-FIELDS.                                
C34097     ADD +1 TO CTR-ROWS.                                          
REARCH     MOVE PARM-ACCOUNT-NO           TO PARM-ACCOUNT-NO-TEMP.      
           MOVE PARM-ACCOUNT-NO-RED       TO WS-ACCOUNT-NO-NUM.         
           MOVE WS-ACCOUNT-NO-NUM         TO AT-ACCOUNT-NO              
                                             BE-ACCOUNT-NO              
                                             PB-ACCOUNT-NO.             
                                                                        
REARCH     MOVE PARM-COMMENT-LEN         TO PARM-COMMENT-LEN-TEMP.      
REARCH     MOVE PARM-NICKNAME-LEN        TO PARM-NICKNAME-LEN-TEMP.     
           MOVE PARM-COMMENT-LEN-RED     TO PARM-COMMENT-LEN-NUM.       
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 03200000
      ************************************************************      05490000
      *   2000-PROCESS-OUTPUT                                    *      05500000
      *                                                          *      05510000
      *   1. DESCRIBE RESULT SET                                 *      05520000
      *   2. RETRIEVE DB2 DATA                                   *      05530000
      *   3. BUILD RESULT SET                                    *      05540000
      *   4. SEND RESULT SET                                     *      05550000
      *                                                          *      05560000
      ************************************************************      05570000
      *                                                                 03200000
       2000-PROCESS-OUTPUT.                                             
                                                                        
            PERFORM 2200-FIND-BANK-EFT      THRU 2200-EXIT.             
            IF RS-RETURN-CODE NOT EQUAL +200                            
               PERFORM 5000-UPDATE          THRU 5000-EXIT              
            END-IF                                                      
            MOVE '2000'                     TO ACTIVE-PARAGRAPH         
REARCH      PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT.            
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05690000
REARCH******************************************************************02640000
REARCH* 2000A-MOVE-RESULT                                              *02650000
REARCH******************************************************************02640000
      *                                                                 05690000
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE  RS-RETURN-CODE       TO S-RETURN-CODE.                 
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH      EXIT.                                                       
     *                                                                  
      ******************************************************************06040000
      *   2200-FIND-BANK-EFT                                           *06050000
      *                                                                *06060000
      *   1.   GET ORIGINAL VALUE OF BANK DRAFT FIELDS FOR JOURNALING. *06070000
      *                                                                *06080000
      ******************************************************************06090000
     *                                                                  
       2200-FIND-BANK-EFT.                                              
                                                                        
           MOVE 'N'                        TO WS-ACCOUNT-EXISTS-FLAG.   
           PERFORM 7000-SELECT-ACCOUNT     THRU 7000-EXIT.              
           MOVE AT-CUSTOMER-NO             TO WS-CUSTOMER-NO-NUMERIC.   
           MOVE WS-CUSTOMER-NO-NUMERIC     TO WS-CUSTOMER-NO.           
                                                                        
C36437     MOVE 'PRENOTE' TO C8-DELINQ-CD.                              
C36437     PERFORM 7800-SELECT-DELINQUENCY THRU 7800-EXIT.              
C36437     MOVE C8-DELINQ-VALUE TO WS-PRENOTE-ACCT.                     
C36437     MOVE 'N' TO JT-APPLIED-FL.                                   
                                                                        
C29529     IF PARM-UPDATE-TYPE = 'A' OR 'Z'                             
C29529        MOVE AT-CUSTOMER-NO           TO JF-CUSTOMER-NO           
C29529        MOVE PARM-BANK-ID             TO WS-BANK-ID               
C36298                                         WS-HOLD-BANK-ID          
C29529        MOVE WS-BANK-ID-NUMERIC       TO WS-BANK-ID-NUM           
C36298                                         WS-HOLD-BANK-ID-NUM      
C29529        MOVE WS-BANK-ID-NUM           TO JF-BANK-ID               
C29529        MOVE PARM-BANK-ACCT-NO        TO JF-BANK-ACCT-NO          
C29529        MOVE PARM-BANK-ACCOUNT-NAME   TO JF-BANK-ACCOUNT-NAME     
C29529        MOVE PARM-NICKNAME-TEXT      TO JF-BANK-ACCT-NICKNAME-TEXT
C29529        MOVE PARM-NICKNAME-LEN-RED    TO PARM-NICKNAME-LEN-NUM    
C29529        MOVE PARM-NICKNAME-LEN-NUM    TO JF-BANK-ACCT-NICKNAME-LEN
C29529        MOVE PARM-ACCT-TYPE-CD        TO JF-BANK-ACCT-TYPE-CD     
C29529        MOVE 'A'                      TO JF-BANK-ACCT-STAT-CD     
C29529        MOVE PARM-USER-ID             TO JF-LAST-UPDATE-USERID    
C29529        PERFORM 7500-SELECT-CUST-BANK THRU 7500-EXIT              
C29529        IF WS-CST-BNK-NOT-EXISTS                                  
C29529           PERFORM 7700-CHK-FOR-UNIQUE-NM   THRU 7700-EXIT        
C29529           IF WS-NICKNAME-EXISTS                                  
C29529              MOVE +200                TO RS-RETURN-CODE          
C29529           ELSE                                                   
C29529              PERFORM 7300-GET-MAX-SEQ-NUM THRU 7300-EXIT         
C29529              ADD +1                   TO JF-CUST-BANK-SEQ-NO     
C29529              IF PRENOTE-YES                                      
C29529                 MOVE 'P'              TO JF-BANK-ACCT-STAT-CD    
C29529              ELSE                                                
C29529                 MOVE 'A'              TO JF-BANK-ACCT-STAT-CD    
C29529              END-IF                                              
C29529              PERFORM 8020-INSERT-CUST-BANK THRU 8020-EXIT        
C29529              MOVE 'A'                 TO WS-ADD-UPDATE-FL        
C29529           END-IF                                                 
C29529        ELSE                                                      
C29529           PERFORM 8120-UPDATE-CUST-BANK THRU 8120-EXIT           
C29529           MOVE 'U'                    TO WS-ADD-UPDATE-FL        
C29529        END-IF                                                    
C29529        IF PRENOTE-YES                                            
C29529           PERFORM 7100-SELECT-BANK   THRU 7100-EXIT              
C29529           EVALUATE TRUE                                          
C29529             WHEN BE-INIT-TYPE-CD = WS-INIT-REMIT                 
C29529               MOVE WS-CODE-SOURCE-DRAFT  TO PB-CODE-SOURCE-ID    
C29529             WHEN BE-INIT-TYPE-CD = WS-INIT-WEB                   
C29529               MOVE WS-CODE-SOURCE-EDRAFT TO PB-CODE-SOURCE-ID    
C29529           END-EVALUATE                                           
C29529           MOVE AT-ACCOUNT-NO         TO PB-ACCOUNT-NO            
C29529           MOVE ZEROS                 TO PB-DRAFT-AMT             
C29529           MOVE -1                    TO WS-NULL-DRFT-DATE        
C29529           MOVE '28'                  TO PB-TRANSACTION-CD        
C29529           MOVE JF-CUST-BANK-SEQ-NO   TO PB-CUST-BANK-SEQ-NO      
C29529           PERFORM 8010-INSERT-PEND   THRU 8010-EXIT              
C29529        END-IF                                                    
C29529     ELSE                                                         
           IF PARM-UPDATE-TYPE = 'U' OR 'S' OR 'D' OR 'Q'               
              PERFORM 7100-SELECT-BANK     THRU 7100-EXIT               
              MOVE BE-STATUS-CODE          TO WS-OLD-STATUS-CODE        
              MOVE BE-INIT-TYPE-CD         TO WS-OLD-INIT-TYP-CD        
              MOVE BE-BANK-ID              TO WS-BANK-ID-NUMERIC        
              MOVE WS-BANK-ID-NUMERIC      TO WS-BANK-ID-NUM            
              MOVE WS-BANK-ID-NUM          TO WS-BANK-ID                
C31085        IF WS-BANK-ID-NUM EQUAL ZEROES                            
T9675            MOVE 'N' TO WS-BANK-EXISTS-FLAG                        
C33210        END-IF                                                    
JJJJJJ        IF PARM-PYMT-TRN-TIMESTMP NOT EQUAL SPACES AND LOW-VALUES 
JJJJJJ           MOVE PARM-PYMT-TRN-TIMESTMP  TO PB-PYMT-TRANS-TS       
JJJJJJ           PERFORM 7200-SELECT-PEND     THRU 7200-EXIT            
JJJJJJ        END-IF                                                    
C29529        IF PARM-UPDATE-TYPE = 'D' OR 'Q'                          
C29529           MOVE PB-DRAFT-AMT            TO WS-DRAFT-AMT-NUMERIC   
C29529           MOVE PB-TRANSACTION-CD       TO WS-TRAN-CD-NUMERIC     
C29529        END-IF                                                    
C36437        MOVE JT-APPLIED-FL TO S-APPLIED-FL                        
           END-IF
           END-IF                                                       
           .                                                            
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 06420000
      ******************************************************************06430000
      * 2900-ALTER-AT-CODES.                                           *06440000
      *    -- THIS MODULE RETRIEVES THE CODES DATA PRESENT COLUMN FROM *06450000
      *       THE AT TABLE, MOVES AN "A" INTO THE WS-CODE-BANK-EFT     *06460000
      *       UPDATES THE CSS_ACCOUNT TABLE WITH THIS FIELD.           *06470000
      ******************************************************************06480000
      *                                                                 06420000
       2900-ALTER-AT-CODES.                                             
      *                                                                 06500000
C34097     MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT.         
      *                                                                 06520000
           IF BE-STATUS-CODE = 'A' OR 'B' OR 'E'                        
             MOVE 'A'                           TO WS-CODE-BANK-EFT     
           ELSE                                                         
             MOVE SPACES                        TO WS-CODE-BANK-EFT     
           END-IF.                                                      
                                                                        
      *                                                                 06590000
           MOVE WS-CODES-DATA-PRESENT         TO AT-CODES-DATA-PRESENT. 
      *                                                                 06610000
           PERFORM 8130-UPDATE-AT-CODE        THRU 8130-EXIT.           
      *                                                                 06640000
       2900-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07020000
      ******************************************************************07370000
      *   5000-UPDATE                                                  *07380000
      *                                                                *07390000
      *   1.   DETERMINES IF UPDATES OR INSERTS ARE NEEDED.            *07400000
23549 *   SPLITTING OUT PANEL VS WEB UPDATES                           *07410000
      ******************************************************************07420000
      *                                                                 07020000
       5000-UPDATE.                                                     
                                                                        
           PERFORM 5100-MOVE-TRAN-HEAD      THRU 5100-EXIT.             
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO        TO MI-TRANS-HIST-SEQ-NO.    
                                                                        
T9700      MOVE +1                          TO WS-TRAN-APPL-NO          
                                                                        
           IF PARM-UPDATE-TYPE = 'U' OR 'S'                             
              PERFORM 5300-MOVE-TRAN-DET    THRU 5300-EXIT              
           END-IF.                                                      
                                                                        
C29529     IF PARM-UPDATE-TYPE = 'A' OR 'Z'                             
C29529        PERFORM 5350-MOVE-TRAN-DET    THRU 5350-EXIT              
C29529     END-IF                                                       
                                                                        
           IF WS-ACCT-EXISTS                                            
               PERFORM 8100-UPDATE-ACCOUNT   THRU 8100-EXIT             
           END-IF.                                                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               CONTINUE                                                 
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE           
           END-IF.                                                      
                                                                        
           IF PARM-UPDATE-TYPE = 'U' OR 'S'                             
              MOVE AT-CUSTOMER-NO           TO BE-CUSTOMER-NO           
C29529                                         JF-CUSTOMER-NO           
C29529        IF PARM-CUST-BNK-SEQ-NO EQUAL SPACES OR ZEROES            
                 MOVE PARM-BANK-ID          TO WS-BANK-ID               
                 MOVE WS-BANK-ID-NUMERIC    TO WS-BANK-ID-NUM           
                 MOVE WS-BANK-ID-NUM        TO BE-BANK-ID               
                 MOVE PARM-BANK-ACCT-NO     TO BE-BANK-ACCT-NO          
C29529                                         JF-BANK-ACCT-NO          
                 MOVE PARM-BANK-ACCOUNT-NAME TO BE-BANK-ACCOUNT-NAME    
C29529           MOVE PARM-NICKNAME-LEN-RED TO PARM-NICKNAME-LEN-NUM    
C29529           MOVE PARM-NICKNAME-LEN-NUM TO JF-BANK-ACCT-NICKNAME-LEN
C29529           MOVE PARM-NICKNAME-TEXT   TO JF-BANK-ACCT-NICKNAME-TEXT
                 MOVE PARM-ACCT-TYPE-CD    TO BE-ACCT-TYPE-CD           
C29529        END-IF                                                    
              MOVE PARM-ESTABLISHED-DATE    TO BE-ESTABLISHED-DATE      
              IF PARM-ESTABLISHED-DATE > ' '                            
                 MOVE 0                     TO WS-NULL-EST-DATE         
              ELSE                                                      
                 MOVE -1                    TO WS-NULL-EST-DATE         
              END-IF                                                    
              MOVE PARM-STATUS-CHANGE-DT    TO BE-STATUS-CHANGE-DT      
              IF PARM-STATUS-CHANGE-DT > ' '                            
                 MOVE 0                     TO WS-NULL-STATUS-DATE      
              ELSE                                                      
                 MOVE -1                    TO WS-NULL-STATUS-DATE      
              END-IF                                                    
              IF PARM-RESUME-DRAFT-DT NOT EQUAL SPACES                  
                 AND NOT EQUAL '9999-12-31'                             
                 MOVE ZEROES                TO WS-NULL-RESUME-DATE      
                 MOVE PARM-RESUME-DRAFT-DT  TO BE-RESUME-DRAFT-DT       
              ELSE                                                      
                 MOVE -1                    TO WS-NULL-RESUME-DATE      
C29529           MOVE SPACES                TO BE-RESUME-DRAFT-DT       
              END-IF                                                    
              MOVE PARM-REQSTED-DRAFT-DAY   TO BE-REQSTED-DRAFT-DAY     
              MOVE PARM-DRAFT-CYCLE         TO BE-DRAFT-CYCLE           
              MOVE PARM-STATUS-CODE         TO BE-STATUS-CODE           
              MOVE PARM-PRENOTE-DATE        TO BE-PRENOTE-DATE          
PRJ547        MOVE PARM-BANK-ID             TO BE-BANK-ID               
PRJ547        MOVE PARM-ACCT-TYPE-CD        TO BE-ACCT-TYPE-CD          
              IF PARM-PRENOTE-DATE >  ' '                               
                 MOVE 0                     TO WS-NULL-PRENOTE-DATE     
TP9490        ELSE                                                      
TP9490           MOVE -1                    TO WS-NULL-PRENOTE-DATE     
              END-IF                                                    
              MOVE PARM-REMARKS             TO BE-REMARKS               
              MOVE PARM-LAST-DRAFT-CYCLE    TO BE-LAST-DRAFT-CYCLE      
25964         IF PARM-INIT-TYPE-CD NOT = SPACE                          
25964          MOVE PARM-INIT-TYPE-CD TO BE-INIT-TYPE-CD                
25964         END-IF                                                    
C29529        IF PARM-CUST-BNK-SEQ-NO > SPACES OR ZEROES                
C29529           MOVE AT-CUSTOMER-NO            TO JF-CUSTOMER-NO       
C29529           MOVE PARM-CUST-BNK-SEQ-NO      TO WS-CUST-BANK-SEQ-NO  
C29529           MOVE WS-CUST-BANK-SEQ-NUM      TO JF-CUST-BANK-SEQ-NO  
C29529           PERFORM 7600-GET-BANK-DETAILS  THRU 7600-EXIT          
PRJ547           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
PRJ547              MOVE +100                TO RS-RETURN-CODE          
PRJ547              EXEC SQL                                            
PRJ547                  ROLLBACK                                        
PRJ547              END-EXEC                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ547              GO TO 5000-EXIT                                     
PRJ547           END-IF                                                 
C36298           PERFORM 5200-CHECK-BANK-ACCT-INFO THRU 5200-EXIT       
C29529           IF WS-CUST-BANK-SEQ-NUM NOT = BE-CUST-BANK-SEQ-NO      
C29529              MOVE WS-TRAN-APPL-NO    TO MI-TRAN-APPL-NO          
C29529              MOVE SPACES             TO MI-TABLE-ID              
C29529              IF WS-BANK-EXISTS                                   
C29529                 MOVE BE-CUST-BANK-SEQ-NO TO                      
C29529                                      MI-PRV-COLUMN-VALUE-TEXT    
C29529                 MOVE +9              TO MI-PRV-COLUMN-VALUE-LEN  
C29529              ELSE                                                
C29529                 MOVE '*NEW*'         TO MI-PRV-COLUMN-VALUE-TEXT 
C29529                 MOVE +5              TO MI-PRV-COLUMN-VALUE-LEN  
C29529              END-IF                                              
C29529              MOVE PARM-CUST-BNK-SEQ-NO  TO                       
C29529                                       MI-CHG-COLUMN-VALUE-TEXT   
C29529              MOVE +9                 TO MI-CHG-COLUMN-VALUE-LEN  
C29529              MOVE 'PRIMARY BANK'     TO MI-COLUMN-DESC           
C29529              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT     
C29529              ADD 1                   TO WS-TRAN-APPL-NO          
C29529           END-IF                                                 
C36298           IF WS-UPD-BANK-ACCT-INFO = 'N'                         
C29529              MOVE JF-BANK-ACCOUNT-NAME TO BE-BANK-ACCOUNT-NAME   
C29529              MOVE JF-BANK-ACCT-NO      TO BE-BANK-ACCT-NO        
C29529              MOVE JF-BANK-ACCT-TYPE-CD TO BE-ACCT-TYPE-CD        
C29529              MOVE JF-BANK-ID           TO BE-BANK-ID             
C36298           END-IF                                                 
C29529        ELSE                                                      
C29529         MOVE PARM-NICKNAME-TEXT     TO JF-BANK-ACCT-NICKNAME-TEXT
C29529         MOVE PARM-NICKNAME-LEN-RED   TO PARM-NICKNAME-LEN-NUM    
C29529         MOVE PARM-NICKNAME-LEN-NUM   TO JF-BANK-ACCT-NICKNAME-LEN
C29529         PERFORM 7500-SELECT-CUST-BANK THRU 7500-EXIT             
C29529         MOVE PARM-BANK-ACCOUNT-NAME   TO JF-BANK-ACCOUNT-NAME    
C29529         MOVE PARM-ACCT-TYPE-CD        TO JF-BANK-ACCT-TYPE-CD    
C29529         MOVE PARM-BANK-ID             TO WS-BANK-ID              
C29529         MOVE WS-BANK-ID-NUMERIC       TO WS-BANK-ID-NUM          
C29529         MOVE WS-BANK-ID-NUM           TO JF-BANK-ID              
C29529         MOVE PARM-USER-ID             TO JF-LAST-UPDATE-USERID   
C29529         IF WS-CST-BNK-NOT-EXISTS                                 
NEWNEW          IF PARM-UPDATE-TYPE EQUAL 'U' AND WS-BANK-EXISTS        
NEWNEW             AND PARM-USER-ID NOT EQUAL 'WEBTRN1'                 
NEWNEW              MOVE PARM-BANK-ACCOUNT-NAME TO JF-BANK-ACCOUNT-NAME 
NEWNEW              MOVE BE-CUST-BANK-SEQ-NO    TO JF-CUST-BANK-SEQ-NO  
NEWNEW              PERFORM 8120-UPDATE-CUST-BANK THRU 8120-EXIT        
NEWNEW          ELSE                                                    
C29529           PERFORM 7700-CHK-FOR-UNIQUE-NM   THRU 7700-EXIT        
C29529           IF WS-NICKNAME-EXISTS                                  
C29529              MOVE +200                TO RS-RETURN-CODE          
REARCH              EXEC SQL                                            
REARCH                  ROLLBACK                                        
REARCH              END-EXEC                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29529              GO TO 5000-EXIT                                     
C29529           ELSE                                                   
C29529              PERFORM 7300-GET-MAX-SEQ-NUM THRU 7300-EXIT         
C29529              ADD +1                   TO JF-CUST-BANK-SEQ-NO     
C29529              IF PRENOTE-YES                                      
C29529                 MOVE 'P'              TO JF-BANK-ACCT-STAT-CD    
                       IF BE-STATUS-CODE = 'A'                          
                          MOVE 'B'           TO BE-STATUS-CODE          
                                                   PARM-STATUS-CODE     
                       END-IF                                           
                       IF BE-STATUS-CODE = 'M'                          
                          MOVE 'N'           TO BE-STATUS-CODE          
                                                   PARM-STATUS-CODE     
                       END-IF                                           
C29529              ELSE                                                
C29529                 MOVE 'A'              TO JF-BANK-ACCT-STAT-CD    
C29529              END-IF                                              
C29529              PERFORM 8020-INSERT-CUST-BANK THRU 8020-EXIT        
C29529           END-IF                                                 
NEWNEW          END-IF                                                  
C29529         ELSE                                                     
C29529           PERFORM 8120-UPDATE-CUST-BANK THRU 8120-EXIT           
C29529         END-IF                                                   
C29529        END-IF                                                    
C29529        IF JF-CUST-BANK-SEQ-NO NOT EQUAL BE-CUST-BANK-SEQ-NO      
C29529           AND WS-BANK-EXISTS AND PARM-UPDATE-TYPE = 'U'          
C29529           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO          
C29529           MOVE SPACES                TO MI-TABLE-ID              
C29529           MOVE BE-CUST-BANK-SEQ-NO   TO MI-PRV-COLUMN-VALUE-TEXT 
C29529           MOVE +9                    TO MI-PRV-COLUMN-VALUE-LEN  
C29529           MOVE JF-CUST-BANK-SEQ-NO   TO MI-CHG-COLUMN-VALUE-TEXT 
C29529           MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
C29529           MOVE 'PRIMARY BANK'        TO MI-COLUMN-DESC           
C29529           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
C29529           ADD 1                      TO WS-TRAN-APPL-NO          
C29529        END-IF                                                    
C29529        MOVE JF-CUST-BANK-SEQ-NO       TO BE-CUST-BANK-SEQ-NO     
              IF WS-BANK-EXISTS                                         
C29529            IF WS-OLD-STATUS-CODE = 'D' AND BE-STATUS-CODE = 'A'  
C29529               MOVE -1                TO WS-NULL-STATUS-DATE      
C29529               MOVE SPACES            TO BE-STATUS-CHANGE-DT      
C29529               MOVE -1                TO WS-NULL-LAST-DRFT-DT     
C29529               MOVE SPACES            TO BE-LAST-DRAFT-DATE       
C29529               MOVE BE-CUST-BANK-SEQ-NO TO JF-CUST-BANK-SEQ-NO    
C29529               PERFORM 8140-ACTIVATE-PMY-BANK   THRU 8140-EXIT    
C29529            END-IF                                                
C29529            IF WS-OLD-STATUS-CODE = 'O' AND BE-STATUS-CODE = 'M'  
C29529               PERFORM 8140-ACTIVATE-PMY-BANK   THRU 8140-EXIT    
C29529            END-IF                                                
                  PERFORM 8110-UPDATE-BANK  THRU 8110-EXIT              
                                                                        
              ELSE                                                      
C29529               IF BE-STATUS-CODE = 'A'                            
C29529                  MOVE -1                TO WS-NULL-STATUS-DATE   
C29529                  MOVE SPACES            TO BE-STATUS-CHANGE-DT   
C29529               END-IF                                             
C29529               PERFORM 8000-INSERT-BANK THRU 8000-EXIT            
C29529        END-IF                                                    
C29529        IF (BE-STATUS-CODE = 'A' AND BE-INIT-TYPE-CD = '02'       
C29529           AND WS-OLD-STATUS-CODE NOT EQUAL 'A') OR               
C29529           (BE-STATUS-CODE = 'M' AND BE-INIT-TYPE-CD = '02'       
C29529           AND WS-OLD-STATUS-CODE NOT EQUAL 'M')                  
C29529           MOVE ZEROES                     TO AT-NO-BILL-COPIES   
C29529           PERFORM 8190-UPDATE-BILL-COPIES THRU 8190-EXIT         
C29533           PERFORM 8230-DELETE-ATTRIBUTES THRU 8230-EXIT          
C29529        END-IF                                                    
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
      ******************                                                08120000
      * AFTER INSERTING BANK EFT, CSS_ACCOUNT IS UPDATED                08130000
      * WITH WS-CODE-BANK-EFT = 'A' - MR                                08140000
      * 23549 - EPAY DO NOT ACTIVATE THIS CODE                                  
      ******************                                                08150000
                  PERFORM 2900-ALTER-AT-CODES THRU 2900-EXIT            
              ELSE                                                      
                  MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE          
              END-IF                                                    
           END-IF.                                                      
                                                                        
           MOVE ZEROS                       TO PB-DRAFT-AMT.            
           IF PARM-DATE-TO-CHG-DRAFT > SPACES                           
              MOVE PARM-DATE-TO-CHG-DRAFT   TO PB-DRAFT-DATE            
              MOVE 0                        TO WS-NULL-DRFT-DATE        
           ELSE                                                         
              MOVE -1                       TO WS-NULL-DRFT-DATE        
           END-IF.                                                      
           MOVE '28'                        TO PB-TRANSACTION-CD.       
                                                                        
           IF PARM-UPDATE-TYPE = 'U'                                    
              IF WS-PEND-EXISTS                                         
                 IF PARM-STATUS-CODE = 'B'                              
25964                 EVALUATE TRUE                                     
25964                  WHEN BE-INIT-TYPE-CD = WS-INIT-REMIT             
25964                   MOVE WS-CODE-SOURCE-DRAFT TO PB-CODE-SOURCE-ID  
25964                  WHEN BE-INIT-TYPE-CD = WS-INIT-WEB               
25964                   MOVE WS-CODE-SOURCE-EDRAFT TO PB-CODE-SOURCE-ID 
25964                 END-EVALUATE                                      
                    PERFORM 8180-UPDATE-PEND THRU 8180-EXIT             
                 ELSE                                                   
TP4915              IF PARM-STATUS-CODE = 'C'                           
T11366                 PERFORM 5400-MOVE-TRAN-DET THRU 5400-EXIT        
C29529                 PERFORM 8220-DELETE-PNDNG-DRFT THRU 8220-EXIT    
TP4915              ELSE                                                
C29529              IF PARM-STATUS-CODE = 'D'                           
C29529                 PERFORM 8220-DELETE-PNDNG-DRFT THRU 8220-EXIT    
C29529              ELSE                                                
T11443                IF PARM-STATUS-CODE = 'A' OR 'M'                  
C29529                   MOVE PARM-PYMT-TRN-TIMESTMP TO PB-PYMT-TRANS-TS
23549                    PERFORM 8200-DELETE-PEND THRU 8200-EXIT        
23549                     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL   
C36298                    AND WS-DELETED-PRENOTE = 'Y'                  
T11366                        PERFORM 5400-MOVE-TRAN-DET THRU 5400-EXIT 
24525                     ELSE                                          
24525                       MOVE ZEROS TO WS-ACTIVE-RETURN-CODE         
23549                     END-IF                                        
TP4915              ELSE                                                
                       IF PARM-DATE-TO-CHG-DRAFT > SPACES               
                          PERFORM 8170-UPDATE-PEND THRU 8170-EXIT       
                       END-IF                                           
TP4915              END-IF                                              
                 END-IF
                    END-IF
                 END-IF                                                 
              ELSE                                                      
T16043           IF PARM-STATUS-CODE IS EQUAL TO 'B'                    
25964                 EVALUATE TRUE                                     
25964                  WHEN BE-INIT-TYPE-CD = WS-INIT-REMIT             
25964                   MOVE WS-CODE-SOURCE-DRAFT TO PB-CODE-SOURCE-ID  
25964                  WHEN BE-INIT-TYPE-CD = WS-INIT-WEB               
25964                   MOVE WS-CODE-SOURCE-EDRAFT TO PB-CODE-SOURCE-ID 
25964                 END-EVALUATE                                      
                    PERFORM 8010-INSERT-PEND   THRU 8010-EXIT           
TP8791           END-IF                                                 
              END-IF                                                    
C31085***     ACCOUNT TYPE CAN BE CHANGED TO EPAY, DRAFT OR EDRAFT BY           
C31085***     REMITTANCE. 1 - DRAFT, 2 - EPAY, 3 - EDRAFT                       
C31085           EVALUATE PARM-EPAY-DRFT-FL                             
C31085              WHEN '1'                                            
C29529                 MOVE 'A'                       TO BE-STATUS-CODE 
C31085                 MOVE '01'                      TO BE-INIT-TYPE-CD
C31085                 IF WS-OLD-STATUS-CODE = 'M'                      
C29529                    PERFORM 8150-UPDATE-BANK-EFT THRU 8150-EXIT   
C29529                    PERFORM 8220-DELETE-PNDNG-DRFT THRU 8220-EXIT 
C29529                    PERFORM 5600-CHNG-STAT-CD-MNT THRU 5600-EXIT  
C31085                 ELSE                                             
C31085                    PERFORM 8160-UPDATE-ACCT-TYPE THRU 8160-EXIT  
C31085                 END-IF                                           
C31085              WHEN '2'                                            
C31085***           IF STATUS IS INCOMPLETE, IT SHOULD REMAIN INCOMPLETE        
C31085                 IF BE-STATUS-CODE NOT = 'E'                      
C31085                    MOVE 'M'                    TO BE-STATUS-CODE 
C31085                 END-IF                                           
C31085                 MOVE '02'                      TO BE-INIT-TYPE-CD
C31085                 PERFORM 8160-UPDATE-ACCT-TYPE  THRU 8160-EXIT    
C31085              WHEN '3'                                            
C31085***           IF STATUS IS INCOMPLETE, IT SHOULD REMAIN INCOMPLETE        
C31085                 IF BE-STATUS-CODE NOT = 'E'                      
C31085                    MOVE 'A'                    TO BE-STATUS-CODE 
C31085                 END-IF                                           
C31085                 MOVE '02'                      TO BE-INIT-TYPE-CD
C31085                 IF WS-OLD-STATUS-CODE = 'M'                      
C29529                    PERFORM 8150-UPDATE-BANK-EFT THRU 8150-EXIT   
C29529                    PERFORM 8220-DELETE-PNDNG-DRFT THRU 8220-EXIT 
C29529                    PERFORM 5600-CHNG-STAT-CD-MNT THRU 5600-EXIT  
C31085                 ELSE                                             
C31085                    PERFORM 8160-UPDATE-ACCT-TYPE THRU 8160-EXIT  
C31085                 END-IF                                           
C31085           END-EVALUATE                                           
C36298           IF WS-UPD-BANK-ACCT-INFO = 'Y'                         
C36298              IF PARM-STATUS-CODE = 'A'                           
C36298                 PERFORM 5500-CHNG-ACCT-TYP-MNT THRU 5500-EXIT    
C36298              ELSE                                                
C36298                 NEXT SENTENCE                                    
C36298              END-IF                                              
C36298           ELSE                                                   
C29529              PERFORM 5500-CHNG-ACCT-TYP-MNT THRU 5500-EXIT       
C36298           END-IF                                                 
C29529           PERFORM 2900-ALTER-AT-CODES          THRU 2900-EXIT    
C29529     END-IF                                                       
C29529     IF PARM-UPDATE-TYPE = 'S' AND PARM-STATUS-CODE = 'D'         
C29529           PERFORM 8220-DELETE-PNDNG-DRFT THRU 8220-EXIT          
C29529     END-IF                                                       
23549      IF PARM-STATUS-CODE IS EQUAL TO 'N'                          
23549        IF  WS-PEND-EXISTS                                         
C29529         MOVE PARM-PYMT-TRN-TIMESTMP TO PB-PYMT-TRANS-TS          
23549          PERFORM 8200-DELETE-PEND THRU 8200-EXIT                  
23549           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
C36298          AND WS-DELETED-PRENOTE = 'Y'                            
23549               PERFORM 5400-MOVE-TRAN-DET THRU 5400-EXIT           
23549           END-IF                                                  
23549        END-IF                                                     
23549        MOVE WS-CODE-SOURCE-EPAY TO PB-CODE-SOURCE-ID              
23549        PERFORM 8010-INSERT-PEND   THRU 8010-EXIT                  
           END-IF.                                                      
23549**DELETE PRENOTES FOR EPAYS WHEN CHANGED TO CANCEL.                        
23549      IF PARM-STATUS-CODE = 'O'                                    
23549        IF  WS-PEND-EXISTS                                         
23549         IF PB-TRANSACTION-CD = 28                                 
C29529         MOVE PARM-PYMT-TRN-TIMESTMP TO PB-PYMT-TRANS-TS          
23549          PERFORM 8200-DELETE-PEND THRU 8200-EXIT                  
23549          PERFORM 5400-MOVE-TRAN-DET THRU 5400-EXIT                
23549         END-IF                                                    
23549        END-IF                                                     
23549      END-IF.                                                      
23549**                                                                         
23549      IF PARM-UPDATE-TYPE = 'D' OR 'Q'                             
              IF WS-PEND-EXISTS                                         
T11366           PERFORM 5400-MOVE-TRAN-DET THRU 5400-EXIT              
                 PERFORM 8210-DELETE-PEND   THRU 8210-EXIT              
              END-IF                                                    
23549      END-IF.                                                      
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE.          
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 08590000
      ******************************************************************08600000
      * 5100-MOVE-TRAN-HEAD                                            *08610000
      ******************************************************************08620000
      *                                                                 08590000
       5100-MOVE-TRAN-HEAD.                                             
                                                                        
C36298     EXEC SQL                                                     
C36298        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :MH-TRANS-HIST-SEQ-NO             
C36298     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     08660000
MFA-TR*       SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP             08670000
MFA-TR*    END-EXEC.                                                    08710000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES         TO ABEND-TABLES                       
              MOVE SPACES         TO ABEND-SQL-PREDICATES               
CBSI          MOVE '5100'         TO ACTIVE-PARAGRAPH                   
              MOVE 'CSR02249'     TO ABEND-PROGRAM                      
C36298        MOVE 'SET'          TO ABEND-FUNCTION                     
CBSI          MOVE 'ACCOUNT_NO'   TO TABLE-ELEMENT-1                    
              MOVE AT-ACCOUNT-NO  TO HOSTVAR-ELEMENT-1                  
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
C36298     EXEC SQL                                                     
C36298        SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-DATE-TRANS                         
C36298     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     08870000
MFA-TR*       SET :MH-DATE-TRANS = CURRENT DATE                         08880000
MFA-TR*    END-EXEC.                                                    08920000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES         TO ABEND-TABLES                       
              MOVE SPACES         TO ABEND-SQL-PREDICATES               
CBSI          MOVE '5100'         TO ACTIVE-PARAGRAPH                   
              MOVE 'CSR02249'     TO ABEND-PROGRAM                      
C36298        MOVE 'SET'          TO ABEND-FUNCTION                     
CBSI          MOVE 'ACCOUNT_NO'   TO TABLE-ELEMENT-1                    
              MOVE AT-ACCOUNT-NO  TO HOSTVAR-ELEMENT-1                  
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
            END-IF.                                                     
                                                                        
            MOVE 'F'                  TO MH-CODE-TRAN-TYPE.             
            MOVE PARM-RESP-AREA-ID    TO MH-RESP-AREA-ID.               
            MOVE AT-ACCOUNT-NO        TO MH-ACCOUNT-NO.                 
A36298*     IF PARM-UPDATE-TYPE = 'A' OR 'Z'                                    
A36298*        MOVE AT-CUSTOMER-NO    TO MH-CUSTOMER-NO                         
A36298*     ELSE                                                                
A36298*        MOVE ZEROES TO MH-CUSTOMER-NO                                    
A36298*     END-IF.                                                             
A36298      EVALUATE PARM-UPDATE-TYPE                                   
A36298          WHEN 'A'                                                
A36298          WHEN 'Z'                                                
A36298               MOVE AT-CUSTOMER-NO TO MH-CUSTOMER-NO              
A36298          WHEN 'U'                                                
A36298          WHEN 'S'                                                
A36298               IF NOT WS-BANK-EXISTS                              
A36298                  MOVE AT-CUSTOMER-NO TO MH-CUSTOMER-NO           
A36298               ELSE                                               
A36298                  MOVE ZEROES TO MH-CUSTOMER-NO                   
A36298               END-IF                                             
A36298          WHEN OTHER                                              
A36298               MOVE ZEROES TO MH-CUSTOMER-NO                      
A36298      END-EVALUATE.                                               
T8718       MOVE ZEROES               TO MH-PREMISE-NO.                 
            MOVE PARM-USER-ID         TO MH-USER-ID.                    
23549       EVALUATE TRUE                                               
23549          WHEN PARM-UPDATE-TYPE = WS-EPAY-UPDATE                   
A03139           IF WS-PEND-EXISTS                                      
A03139              MOVE 'DELETPMT' TO MH-APPL-PROGRAM-ID               
A03139           ELSE                                                   
23549               MOVE 'PANELWEBE'        TO MH-APPL-PROGRAM-ID       
A03139           END-IF                                                 
23549          WHEN PARM-UPDATE-TYPE = WS-EPAY-MAINTAIN                 
A02661           IF PARM-STATUS-CODE = 'D'                              
A02661              MOVE 'PANEL194E' TO MH-APPL-PROGRAM-ID              
A02661           ELSE                                                   
A02661              MOVE 'PANELWEB ' TO MH-APPL-PROGRAM-ID              
A02661           END-IF                                                 
A02661*          MOVE 'PANELWEB '         TO MH-APPL-PROGRAM-ID                 
23549          WHEN PARM-UPDATE-TYPE = 'U' OR 'D'                       
23549            MOVE 'PANEL194 '         TO MH-APPL-PROGRAM-ID         
23549       END-EVALUATE.                                               
23549       IF PARM-UPDATE-TYPE = 'U'                                   
23549          AND PARM-STATUS-CODE >= 'M'                              
23549          MOVE 'PANELWEB '         TO MH-APPL-PROGRAM-ID           
23549       END-IF.                                                     
23549       IF  PARM-UPDATE-TYPE = 'D'                                  
23549       AND PARM-STATUS-CODE >= 'M'                                 
C36437          IF JT-APPLIED-FL = 'Y'                                  
C36437             MOVE 'DELETEPMT' TO MH-APPL-PROGRAM-ID               
C36437          ELSE                                                    
23549              MOVE 'PANELWEBE'         TO MH-APPL-PROGRAM-ID       
C36437          END-IF                                                  
23549       END-IF.                                                     
C29529      IF PARM-UPDATE-TYPE = 'A'                                   
C29529         IF ADD-BANK                                              
C29529            MOVE 'PANEL194A'      TO MH-APPL-PROGRAM-ID           
C29529         ELSE                                                     
C29529            IF UPDATE-BANK                                        
C29529               MOVE 'PANEL194C'   TO MH-APPL-PROGRAM-ID           
C29529            END-IF                                                
C29529         END-IF                                                   
C29529      END-IF.                                                     
C29529      IF PARM-UPDATE-TYPE = 'Z'                                   
C29529         MOVE 'PANEL194B'         TO MH-APPL-PROGRAM-ID           
C29529      END-IF.                                                     
25964       IF PARM-INIT-TYPE-CD = '02'                                 
25964          AND PARM-STATUS-CODE < 'M'                               
27981          AND PARM-STATUS-CODE NOT = SPACES                        
25964          MOVE 'PANEL194E'         TO MH-APPL-PROGRAM-ID           
25964       END-IF.                                                     
            MOVE PARM-COMMENT-LEN-NUM TO MH-TRAN-COMMENT-LEN.           
            MOVE PARM-COMMENT-TEXT    TO MH-TRAN-COMMENT-TEXT.          
       5100-EXIT.                                                       
           EXIT.                                                        
C36298*                                                                 14180000
C36298******************************************************************14190000
C36298* 5200-CHECK-BANK-ACCT-INFO                                      *14200000
C36298******************************************************************14210000
C36298*                                                                 14180000
C36298 5200-CHECK-BANK-ACCT-INFO.                                       
C36298                                                                  
C36298     IF  PARM-BANK-ACCOUNT-NAME NOT = BE-BANK-ACCOUNT-NAME        
C36298     AND PARM-BANK-ACCOUNT-NAME NOT = SPACES                      
C36298         PERFORM 5700-NEW-BANK-ACCT-NAME THRU 5700-EXIT           
C36298     END-IF.                                                      
C36298                                                                  
C36298     IF  PARM-BANK-ACCT-NO NOT = BE-BANK-ACCT-NO                  
C36298     AND PARM-BANK-ACCT-NO NOT = SPACES                           
C36298         PERFORM 5710-NEW-BANK-ACCT-NO THRU 5710-EXIT             
C36298     ELSE                                                         
C36298         MOVE JF-BANK-ACCT-NO TO PARM-BANK-ACCT-NO                
C36298     END-IF.                                                      
C36298                                                                  
C36298     MOVE JF-BANK-ACCT-NICKNAME-LEN TO WS-NNAME-LEN.              
C36298     IF  PARM-NICKNAME-TEXT(1:WS-NNAME-LEN) NOT =                 
C36298                      JF-BANK-ACCT-NICKNAME-TEXT(1:WS-NNAME-LEN)  
C36298     AND PARM-NICKNAME-TEXT NOT = SPACES                          
C36298         PERFORM 5720-NEW-BANK-NICKNAME THRU 5720-EXIT            
C36298     END-IF.                                                      
C36298                                                                  
C36298     IF  PARM-ACCT-TYPE-CD NOT = JF-BANK-ACCT-TYPE-CD             
C36298     AND PARM-ACCT-TYPE-CD NOT = SPACES                           
C36298         PERFORM 5740-NEW-BANK-ACCT-TYPE THRU 5740-EXIT           
C36298     END-IF.                                                      
C36298                                                                  
PRJ547     IF RS-RETURN-CODE = +200                                     
PRJ547        NEXT SENTENCE                                             
PRJ547     ELSE                                                         
C36298        MOVE PARM-BANK-ID TO WS-HOLD-BANK-ID                      
C36298        MOVE WS-HOLD-BANK-ID-NUMERIC TO WS-HOLD-BANK-ID-NUM       
C36298        IF  WS-HOLD-BANK-ID-NUM NOT = JF-BANK-ID                  
C36298        AND WS-HOLD-BANK-ID-NUM NOT = ZEROS                       
C36298            PERFORM 5750-NEW-BANK-ID THRU 5750-EXIT               
C36298        END-IF                                                    
PRJ547     END-IF.                                                      
C36298                                                                  
C36298 5200-EXIT.                                                       
C36298     EXIT.                                                        
     *                                                                  
      ******************************************************************09540000
      * 5300-MOVE-TRAN-DET                                             *09550000
      * T9700- COMMENTED OUT COLUMNS SHOULD NOT BE WRITTEN TO TRAN HIST*09551000
      * 23549 -DELETED THE MASS QUANTITY OF COMMENTED LINES.                    
      ******************************************************************09560000
     *                                                                  
       5300-MOVE-TRAN-DET.                                              
T9176                                                                   
A36298*    IF PARM-UPDATE-TYPE = 'U'                                            
A36298*       NEXT SENTENCE                                                     
A36298*    ELSE                                                                 
A36298     IF NOT WS-BANK-EXISTS                                        
T9176         IF  PARM-BANK-ACCOUNT-NAME NOT = BE-BANK-ACCOUNT-NAME     
T9176         AND PARM-BANK-ACCOUNT-NAME NOT = SPACES                   
T9176             MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO       
T9176             MOVE SPACES                  TO MI-TABLE-ID           
T9176             IF WS-BANK-EXISTS                                     
T9176                MOVE BE-BANK-ACCOUNT-NAME TO WS-BANK-ACCOUNT-NAME  
T9176                MOVE WS-BANK-ACCT-1-30 TO MI-PRV-COLUMN-VALUE-TEXT 
T9176                MOVE +30               TO MI-PRV-COLUMN-VALUE-LEN  
T9176             ELSE                                                  
T9176                MOVE '*NEW*'           TO MI-PRV-COLUMN-VALUE-TEXT 
T9176                MOVE +5                TO MI-PRV-COLUMN-VALUE-LEN  
T9176             END-IF                                                
T9176             MOVE PARM-BANK-ACCOUNT-NAME   TO WS-BANK-ACCOUNT-NAME 
T9176             MOVE WS-BANK-ACCT-1-30    TO MI-CHG-COLUMN-VALUE-TEXT 
T9176             MOVE +30                  TO MI-CHG-COLUMN-VALUE-LEN  
T9176             MOVE 'PRIMARY BANK'       TO MI-COLUMN-DESC           
T9176             PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT       
T9173             ADD 1                         TO WS-TRAN-APPL-NO      
T9176         END-IF                                                    
T9176                                                                   
A36298        IF PARM-NICKNAME-TEXT NOT = SPACES                        
A36298           MOVE WS-TRAN-APPL-NO    TO MI-TRAN-APPL-NO             
A36298           MOVE SPACES             TO MI-TABLE-ID                 
A36298           MOVE '*NEW*'            TO MI-PRV-COLUMN-VALUE-TEXT    
A36298           MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN     
A36298           MOVE PARM-NICKNAME-TEXT TO MI-CHG-COLUMN-VALUE-TEXT    
A36298           MOVE +50                TO MI-CHG-COLUMN-VALUE-LEN     
A36298           MOVE 'BANK NICKNAME'    TO MI-COLUMN-DESC              
A36298           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
A36298           ADD 1                   TO WS-TRAN-APPL-NO             
A36298        END-IF                                                    
A36298        IF PARM-UPDATE-TYPE = 'U' OR 'S'                          
A36298           MOVE ZEROES TO MH-CUSTOMER-NO                          
A36298        END-IF                                                    
A36298     END-IF.                                                      
T9176                                                                   
T9176                                                                   
T9176      IF PARM-ESTABLISHED-DATE NOT = BE-ESTABLISHED-DATE           
T9176      AND PARM-ESTABLISHED-DATE NOT = SPACES                       
T9176         MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
T9176         MOVE SPACES                   TO MI-TABLE-ID              
T9176         IF WS-BANK-EXISTS                                         
T9176            MOVE BE-ESTABLISHED-DATE   TO MI-PRV-COLUMN-VALUE-TEXT 
T9176            MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN  
T9176         ELSE                                                      
T9176            MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
T9176            MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
T9176         END-IF                                                    
T9176         MOVE PARM-ESTABLISHED-DATE    TO MI-CHG-COLUMN-VALUE-TEXT 
T9176         MOVE +10                      TO MI-CHG-COLUMN-VALUE-LEN  
T9176         MOVE 'ESTABLISHED DATE'       TO MI-COLUMN-DESC           
T9176         PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
T9176         ADD 1                         TO WS-TRAN-APPL-NO          
T9176      END-IF.                                                      
23549** FIXED PROBLEM OF PRE-NOTE DATE CHANGING NOT BEING WRITTEN               
23549**                                                                         
23549      IF PARM-PRENOTE-DATE NOT = BE-PRENOTE-DATE                   
23549      AND PARM-PRENOTE-DATE NOT = SPACES                           
C36298     AND BE-PRENOTE-DATE NOT = SPACES                             
23549         MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
23549         MOVE SPACES                   TO MI-TABLE-ID              
23549         IF WS-BANK-EXISTS                                         
23549            MOVE BE-PRENOTE-DATE       TO MI-PRV-COLUMN-VALUE-TEXT 
23549            MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN  
23549         ELSE                                                      
23549            MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
23549            MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
23549         END-IF                                                    
23549         MOVE PARM-PRENOTE-DATE        TO MI-CHG-COLUMN-VALUE-TEXT 
23549         MOVE +10                      TO MI-CHG-COLUMN-VALUE-LEN  
23549         MOVE 'PRE-NOTE DATE   '        TO MI-COLUMN-DESC          
23549         PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
23549         ADD 1                         TO WS-TRAN-APPL-NO          
23549      END-IF.                                                      
T9176                                                                   
T9176      IF PARM-RESUME-DRAFT-DT NOT = BE-RESUME-DRAFT-DT             
T9176      AND PARM-RESUME-DRAFT-DT NOT = SPACES                        
T9176         MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
T9176         MOVE SPACES                   TO MI-TABLE-ID              
T9176         IF WS-BANK-EXISTS                                         
T9176            MOVE BE-RESUME-DRAFT-DT    TO MI-PRV-COLUMN-VALUE-TEXT 
T9176            MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN  
T9176         ELSE                                                      
T9176            MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
T9176            MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
T9176         END-IF                                                    
T9176         MOVE PARM-RESUME-DRAFT-DT     TO MI-CHG-COLUMN-VALUE-TEXT 
T9176         MOVE +10                      TO MI-CHG-COLUMN-VALUE-LEN  
T9176         MOVE 'RESUME DRAFT DATE'      TO MI-COLUMN-DESC           
T9176         PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
T9176         ADD 1                         TO WS-TRAN-APPL-NO          
T9176      END-IF.                                                      
T9176                                                                   
T9176      IF PARM-REQSTED-DRAFT-DAY NOT = BE-REQSTED-DRAFT-DAY         
T9176      AND PARM-REQSTED-DRAFT-DAY NOT = SPACES                      
T9176         MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
T9176         MOVE SPACES                   TO MI-TABLE-ID              
T9176         IF WS-BANK-EXISTS                                         
T9176            MOVE BE-REQSTED-DRAFT-DAY  TO MI-PRV-COLUMN-VALUE-TEXT 
T9176            MOVE +2                    TO MI-PRV-COLUMN-VALUE-LEN  
T9176         ELSE                                                      
T9176            MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
T9176            MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
T9176         END-IF                                                    
T9176         MOVE PARM-REQSTED-DRAFT-DAY   TO MI-CHG-COLUMN-VALUE-TEXT 
T9176         MOVE +2                       TO MI-CHG-COLUMN-VALUE-LEN  
T9176         MOVE 'REQUESTED DRAFT DAY'    TO MI-COLUMN-DESC           
T9176         PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
T9176         ADD 1                         TO WS-TRAN-APPL-NO          
T9176      END-IF.                                                      
T9176                                                                   
T9176      IF PARM-DRAFT-CYCLE NOT = BE-DRAFT-CYCLE                     
T9176      AND PARM-DRAFT-CYCLE NOT = SPACES                            
C36298     AND BE-DRAFT-CYCLE NOT = SPACES                              
T9176         MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
T9176         MOVE SPACES                   TO MI-TABLE-ID              
T9176         IF WS-BANK-EXISTS                                         
T9176            MOVE BE-DRAFT-CYCLE        TO MI-PRV-COLUMN-VALUE-TEXT 
T9176            MOVE +2                   TO MI-PRV-COLUMN-VALUE-LEN   
T9176         ELSE                                                      
T9176            MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
T9176            MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
T9176         END-IF                                                    
T9176         MOVE PARM-DRAFT-CYCLE        TO MI-CHG-COLUMN-VALUE-TEXT  
T9176         MOVE +2                      TO MI-CHG-COLUMN-VALUE-LEN   
T9176         MOVE 'DRAFT CYCLE'           TO MI-COLUMN-DESC            
T9176         PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
T9176         ADD 1                        TO WS-TRAN-APPL-NO           
T9176      END-IF.                                                      
T9176                                                                   
T9176      IF PARM-STATUS-CODE NOT = BE-STATUS-CODE                     
T9176      AND PARM-STATUS-CODE NOT = SPACES                            
T9176         MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
T9176         MOVE '46'                     TO MI-TABLE-ID              
T9176         IF WS-BANK-EXISTS                                         
T9176            MOVE BE-STATUS-CODE        TO MI-PRV-COLUMN-VALUE-TEXT 
T9176            MOVE +1                    TO MI-PRV-COLUMN-VALUE-LEN  
T9176         ELSE                                                      
T9176            MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
T9176            MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
T9176         END-IF                                                    
T9176         MOVE PARM-STATUS-CODE         TO MI-CHG-COLUMN-VALUE-TEXT 
T9176         MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN  
T9176         MOVE 'STATUS CODE'            TO MI-COLUMN-DESC           
T9176         PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
T9176         ADD 1                         TO WS-TRAN-APPL-NO          
A36298        MOVE PARM-STATUS-CODE         TO WS-OLD-STATUS-CODE       
T9176      END-IF.                                                      
T9176                                                                   
T9176                                                                   
T9176      IF PARM-REMARKS NOT = BE-REMARKS                             
T9176      AND PARM-REMARKS NOT = SPACES                                
T9176         MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
T9176         MOVE SPACES                   TO MI-TABLE-ID              
T9176         IF WS-BANK-EXISTS                                         
T9176            MOVE BE-REMARKS            TO MI-PRV-COLUMN-VALUE-TEXT 
T9176            MOVE +26                   TO MI-PRV-COLUMN-VALUE-LEN  
T9176         ELSE                                                      
T9176            MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
T9176            MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
T9176         END-IF                                                    
T9176         MOVE PARM-REMARKS             TO MI-CHG-COLUMN-VALUE-TEXT 
T9176         MOVE +26                      TO MI-CHG-COLUMN-VALUE-LEN  
T9176         MOVE 'REMARKS'                TO MI-COLUMN-DESC           
T9176         PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
T9176         ADD 1                         TO WS-TRAN-APPL-NO          
T9176      END-IF.                                                      
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 12660000
C29529******************************************************************12661000
C29529* 5350-MOVE-TRAN-DET                                             *12662000
C29529******************************************************************12664000
      *                                                                 12660000
C29529 5350-MOVE-TRAN-DET.                                              
C29529                                                                  
C29529     MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO          
C29529     MOVE SPACES                      TO MI-TABLE-ID              
C29529     IF ADD-BANK                                                  
C29529        MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
C29529        MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
C29529     ELSE                                                         
C29529        MOVE '*UPDATE*'               TO MI-PRV-COLUMN-VALUE-TEXT 
C29529        MOVE +8                       TO MI-PRV-COLUMN-VALUE-LEN  
C29529     END-IF                                                       
C29529     MOVE PARM-BANK-ACCOUNT-NAME      TO WS-BANK-ACCOUNT-NAME     
C29529     MOVE WS-BANK-ACCT-1-30           TO MI-CHG-COLUMN-VALUE-TEXT 
C29529     MOVE +30                         TO MI-CHG-COLUMN-VALUE-LEN  
C29529     MOVE 'BANK ACCT NAME'            TO MI-COLUMN-DESC           
C29529     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT              
C29529     ADD 1                            TO WS-TRAN-APPL-NO          
C36298     MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO          
C36298     MOVE SPACES                      TO MI-TABLE-ID              
C36298     MOVE '*NEW*'                     TO MI-PRV-COLUMN-VALUE-TEXT 
C36298     MOVE +5                          TO MI-PRV-COLUMN-VALUE-LEN  
C36298     MOVE PARM-NICKNAME-LEN           TO MI-CHG-COLUMN-VALUE-LEN  
C36298     MOVE PARM-NICKNAME-TEXT          TO MI-CHG-COLUMN-VALUE-TEXT 
C36298     MOVE 'BANK NICKNAME'             TO MI-COLUMN-DESC           
C36298     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT              
C36298     ADD 1                            TO WS-TRAN-APPL-NO          
C29529     .                                                            
C29529 5350-EXIT.                                                       
C29529     EXIT.                                                        
      *                                                                 11930000
T11366******************************************************************12661000
T11366* 5400-MOVE-TRAN-DET                                             *12662000
T11366******************************************************************12664000
T11366*                                                                 12665000
T11366 5400-MOVE-TRAN-DET.                                              
T11366                                                                  
T11366     MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO.             
T11366     MOVE SPACES                  TO MI-TABLE-ID.                 
T11366     MOVE 'NO'                    TO MI-PRV-COLUMN-VALUE-TEXT.    
T11366     MOVE +2                      TO MI-PRV-COLUMN-VALUE-LEN.     
T11366     MOVE 'YES'                   TO MI-CHG-COLUMN-VALUE-TEXT.    
T11366     MOVE +3                      TO MI-CHG-COLUMN-VALUE-LEN.     
C36437                                                                  
23549      IF PARM-UPDATE-TYPE = WS-EPAY-UPDATE                         
23549      OR BE-STATUS-CODE >= 'M'                                     
23549         MOVE 'PREVENT EPAY'          TO MI-COLUMN-DESC            
A03139        PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
A03139        ADD 1                        TO WS-TRAN-APPL-NO           
A03139        PERFORM 5410-MOVE-PREVENT-EPAY-DETAILS THRU 5410-EXIT     
23549      ELSE                                                         
23549         MOVE 'PREVENT DRAFT'         TO MI-COLUMN-DESC            
A03139        PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
A03139        ADD 1                        TO WS-TRAN-APPL-NO           
23549      END-IF.                                                      
C36437                                                                  
A03139*    PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             12669800
A03139*    ADD 1                        TO WS-TRAN-APPL-NO.             12669900
T11366                                                                  
T11366 5400-EXIT.                                                       
T11366     EXIT.                                                        
      *                                                                 12671100
A03139*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
A03139*   5410-MOVE-PREVENT-EPAY-DETAILS.                             * 02740000
A03139*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*         
A03139 5410-MOVE-PREVENT-EPAY-DETAILS.                                  
A03139*                                                                 12665000
A03139     MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO.             
A03139     MOVE SPACES                  TO MI-TABLE-ID.                 
A03139     MOVE 'BANK SEQ NO'           TO MI-COLUMN-DESC.              
A03139     MOVE BE-CUST-BANK-SEQ-NO     TO MI-PRV-COLUMN-VALUE-TEXT     
A03139     MOVE +9                      TO MI-PRV-COLUMN-VALUE-LEN      
A03139     MOVE '*DELETED*'             TO MI-CHG-COLUMN-VALUE-TEXT.    
A03139     MOVE +9                      TO MI-CHG-COLUMN-VALUE-LEN.     
A03139                                                                  
A03139     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
A03139     ADD 1                        TO WS-TRAN-APPL-NO.             
A03139                                                                  
A03139     MOVE WS-DRAFT-AMT-NUMERIC    TO WS-DRAFT-AMT-DISPLAY.        
A03139     MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO.             
A03139     MOVE SPACES                  TO MI-TABLE-ID.                 
A03139     MOVE 'DRAFT AMOUNT'          TO MI-COLUMN-DESC.              
A03139     MOVE WS-DRAFT-AMT-DISPLAY    TO MI-PRV-COLUMN-VALUE-TEXT     
A03139     MOVE +10                     TO MI-PRV-COLUMN-VALUE-LEN      
A03139     MOVE '*DELETED*'             TO MI-CHG-COLUMN-VALUE-TEXT.    
A03139     MOVE +9                      TO MI-CHG-COLUMN-VALUE-LEN.     
A03139                                                                  
A03139     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
A03139     ADD 1                        TO WS-TRAN-APPL-NO.             
A03139                                                                  
A03139     MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO.             
A03139     MOVE SPACES                  TO MI-TABLE-ID.                 
A03139     MOVE 'DRAFT DATE'            TO MI-COLUMN-DESC.              
A03139     MOVE PB-DRAFT-DATE           TO MI-PRV-COLUMN-VALUE-TEXT     
A03139     MOVE +10                     TO MI-PRV-COLUMN-VALUE-LEN      
A03139     MOVE '*DELETED*'             TO MI-CHG-COLUMN-VALUE-TEXT.    
A03139     MOVE +9                      TO MI-CHG-COLUMN-VALUE-LEN.     
A03139                                                                  
A03139     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
A03139     ADD 1                        TO WS-TRAN-APPL-NO.             
A03139                                                                  
A03139 5410-EXIT.                                                       
A03139     EXIT.                                                        
      *                                                                 12670000
C29529******************************************************************12661000
C29529* 5500-CHNG-ACCT-TYP-MNT                                         *12662000
C29529******************************************************************12664000
C29529*                                                                 12665000
C29529 5500-CHNG-ACCT-TYP-MNT.                                          
C29529*                                                                 12667000
C36298     IF WS-OLD-INIT-TYP-CD NOT = BE-INIT-TYPE-CD                  
C29529        MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
C29529        MOVE SPACES                  TO MI-TABLE-ID               
C31085        MOVE WS-OLD-INIT-TYP-CD      TO MI-PRV-COLUMN-VALUE-TEXT  
C29529        MOVE +2                      TO MI-PRV-COLUMN-VALUE-LEN   
C31085        MOVE BE-INIT-TYPE-CD         TO MI-CHG-COLUMN-VALUE-TEXT  
C29529        MOVE +2                      TO MI-CHG-COLUMN-VALUE-LEN   
C29529        MOVE 'INIT TYPE CD'          TO MI-COLUMN-DESC            
C29529        PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
C29529        ADD 1                         TO WS-TRAN-APPL-NO          
C36298     END-IF.                                                      
C29529*                                                                 12667000
C36298     IF WS-OLD-STATUS-CODE NOT = BE-STATUS-CODE                   
C29529        MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
C29529        MOVE SPACES                  TO MI-TABLE-ID               
C31085        MOVE WS-OLD-STATUS-CODE      TO MI-PRV-COLUMN-VALUE-TEXT  
C29529        MOVE +1                      TO MI-PRV-COLUMN-VALUE-LEN   
C31085        MOVE BE-STATUS-CODE          TO MI-CHG-COLUMN-VALUE-TEXT  
C29529        MOVE +1                      TO MI-CHG-COLUMN-VALUE-LEN   
C29529        MOVE 'STATUS CD'             TO MI-COLUMN-DESC            
C29529        PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
C29529        ADD 1                         TO WS-TRAN-APPL-NO          
C36298     END-IF.                                                      
C36298                                                                  
C29529 5500-EXIT.                                                       
C29529     EXIT.                                                        
C29529*                                                                 12670000
C31085******************************************************************12661000
C31085* 5600-CHNG-EPAY-TO-DRFT                                         *12662000
C31085******************************************************************12664000
C31085*                                                                 12665000
C31085 5600-CHNG-STAT-CD-MNT.                                           
C31085*                                                                 12667000
C31085     MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO.             
C31085     MOVE SPACES                  TO MI-TABLE-ID.                 
C31085        MOVE BE-STATUS-CHANGE-DT  TO MI-PRV-COLUMN-VALUE-TEXT     
C31085        MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN      
C31085        MOVE BE-STATUS-CHANGE-DT  TO MI-CHG-COLUMN-VALUE-TEXT     
C31085        MOVE 'NULL'               TO MI-CHG-COLUMN-VALUE-TEXT     
C31085        MOVE +4                   TO MI-CHG-COLUMN-VALUE-LEN      
C31085     MOVE 'STATUS CHANGE DT'      TO MI-COLUMN-DESC               
C31085     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT              
C31085     ADD 1                        TO WS-TRAN-APPL-NO              
C31085     .                                                            
C31085 5600-EXIT.                                                       
C31085     EXIT.                                                        
C36298*                                                                         
C36298******************************************************************12661000
C36298* 5700-NEW-BANK-ACCT-NAME                                        *12662000
C36298******************************************************************12664000
C36298*                                                                 12665000
C36298 5700-NEW-BANK-ACCT-NAME.                                         
C36298*                                                                 12667000
C36298     MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
C36298     MOVE SPACES                   TO MI-TABLE-ID.                
C36298     MOVE BE-BANK-ACCOUNT-NAME     TO WS-BANK-ACCOUNT-NAME.       
C36298     MOVE WS-BANK-ACCT-1-30        TO MI-PRV-COLUMN-VALUE-TEXT.   
C36298     MOVE +30                      TO MI-PRV-COLUMN-VALUE-LEN.    
C36298     MOVE PARM-BANK-ACCOUNT-NAME   TO WS-BANK-ACCOUNT-NAME.       
C36298     MOVE WS-BANK-ACCT-1-30        TO MI-CHG-COLUMN-VALUE-TEXT.   
C36298     MOVE +30                      TO MI-CHG-COLUMN-VALUE-LEN.    
C36298     MOVE 'BANK ACCT NAME'         TO MI-COLUMN-DESC.             
C36298     IF MI-TRAN-APPL-NO EQUAL 1                                   
C36298        MOVE +25 TO MH-TRAN-COMMENT-LEN                           
C36298        MOVE 'PRIMARY BANK INFO CHANGED' TO MH-TRAN-COMMENT-TEXT  
C36298     END-IF.                                                      
C36298     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
C36298     ADD 1                         TO WS-TRAN-APPL-NO.            
C36298     MOVE PARM-BANK-ACCOUNT-NAME TO BE-BANK-ACCOUNT-NAME          
C36298                                    JF-BANK-ACCOUNT-NAME.         
C36298     MOVE 'Y' TO WS-UPD-BANK-ACCT-INFO.                           
C36298                                                                  
C36298 5700-EXIT.                                                       
C36298     EXIT.                                                        
C36298*                                                                         
C36298******************************************************************12661000
C36298* 5710-NEW-BANK-ACCT-NO                                          *12662000
C36298******************************************************************12664000
C36298*                                                                 12665000
C36298 5710-NEW-BANK-ACCT-NO.                                           
C36298*                                                                 12667000
C36298     MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO.               
C36298     MOVE SPACES                TO MI-TABLE-ID.                   
C36298     MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN.       
C36298     MOVE SPACES                TO MI-PRV-COLUMN-VALUE-TEXT.      
C36298     MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN.       
C36298     MOVE SPACES                TO MI-CHG-COLUMN-VALUE-TEXT.      
C36298     MOVE PARM-NICKNAME-TEXT    TO WS-TRANS-NNAME.                
C36298     MOVE 'BANK ACCT NO'        TO MI-COLUMN-DESC.                
C36298     IF MI-TRAN-APPL-NO EQUAL 1                                   
C36298        MOVE +85 TO MH-TRAN-COMMENT-LEN                           
C36298        MOVE WS-TRANS-COMMENTS TO MH-TRAN-COMMENT-TEXT            
C36298     END-IF.                                                      
C36298     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
C36298     ADD 1 TO WS-TRAN-APPL-NO.                                    
C36298     MOVE 'Y' TO WS-UPD-BANK-ACCT-INFO                            
C36298                 WS-UPD-BANK-ACCT-NO.                             
C36298     MOVE PARM-BANK-ACCT-NO     TO BE-BANK-ACCT-NO                
C36298                                   JF-BANK-ACCT-NO.               
C36298                                                                  
C36298 5710-EXIT.                                                       
C36298     EXIT.                                                        
C36298*                                                                         
C36298******************************************************************12661000
C36298* 5720-NEW-BANK-NICKNAME                                         *12662000
C36298******************************************************************12664000
C36298*                                                                 12665000
C36298 5720-NEW-BANK-NICKNAME.                                          
C36298*                                                                 12667000
C36298     MOVE WS-TRAN-APPL-NO    TO MI-TRAN-APPL-NO.                  
C36298     MOVE SPACES             TO MI-TABLE-ID.                      
C36298     MOVE JF-BANK-ACCT-NICKNAME-TEXT                              
C36298                          TO MI-PRV-COLUMN-VALUE-TEXT.            
C36298     MOVE JF-BANK-ACCT-NICKNAME-LEN                               
C36298                          TO MI-PRV-COLUMN-VALUE-LEN.             
C36298     MOVE PARM-NICKNAME-LEN                                       
C36298                          TO MI-CHG-COLUMN-VALUE-LEN.             
C36298     MOVE PARM-NICKNAME-TEXT                                      
C36298                          TO MI-CHG-COLUMN-VALUE-TEXT.            
C36298     MOVE 'BANK NICKNAME' TO MI-COLUMN-DESC.                      
C36298     IF MI-TRAN-APPL-NO EQUAL 1                                   
C36298        MOVE +25 TO MH-TRAN-COMMENT-LEN                           
C36298        MOVE 'PRIMARY BANK INFO CHANGED' TO MH-TRAN-COMMENT-TEXT  
C36298     END-IF.                                                      
C36298     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
C36298     ADD 1                   TO WS-TRAN-APPL-NO.                  
C36298     MOVE 'Y' TO WS-UPD-BANK-ACCT-INFO.                           
C36298     MOVE PARM-NICKNAME-LEN TO JF-BANK-ACCT-NICKNAME-LEN.         
C36298     MOVE PARM-NICKNAME-TEXT TO JF-BANK-ACCT-NICKNAME-TEXT.       
C36298                                                                  
C36298 5720-EXIT.                                                       
C36298     EXIT.                                                        
C36298*                                                                         
C36298******************************************************************12661000
C36298* 5740-NEW-BANK-ACCT-TYPE                                        *12662000
C36298******************************************************************12664000
C36298*                                                                 12665000
C36298 5740-NEW-BANK-ACCT-TYPE.                                         
C36298*                                                                 12667000
C36298     MOVE WS-TRAN-APPL-NO    TO MI-TRAN-APPL-NO.                  
C36298     MOVE SPACES             TO MI-TABLE-ID.                      
C36298     MOVE +1                 TO MI-PRV-COLUMN-VALUE-LEN.          
C36298     MOVE JF-BANK-ACCT-TYPE-CD                                    
C36298                          TO MI-PRV-COLUMN-VALUE-TEXT.            
C36298     MOVE +1                 TO MI-CHG-COLUMN-VALUE-LEN.          
C36298     MOVE PARM-ACCT-TYPE-CD                                       
C36298                          TO MI-CHG-COLUMN-VALUE-TEXT.            
C36298     MOVE 'BANK ACCT TYPE'   TO MI-COLUMN-DESC.                   
C36298     IF MI-TRAN-APPL-NO EQUAL 1                                   
C36298        MOVE +25 TO MH-TRAN-COMMENT-LEN                           
C36298        MOVE 'PRIMARY BANK INFO CHANGED' TO MH-TRAN-COMMENT-TEXT  
C36298     END-IF.                                                      
C36298     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
C36298     ADD 1                   TO WS-TRAN-APPL-NO.                  
C36298     MOVE 'Y' TO WS-UPD-BANK-ACCT-INFO.                           
C36298     MOVE PARM-ACCT-TYPE-CD TO JF-BANK-ACCT-TYPE-CD               
C36298                               BE-ACCT-TYPE-CD.                   
C36298                                                                  
C36298 5740-EXIT.                                                       
C36298     EXIT.                                                        
C36298*                                                                         
C36298******************************************************************12661000
C36298* 5750-NEW-BANK-ID                                               *12662000
C36298******************************************************************12664000
C36298*                                                                 12665000
C36298 5750-NEW-BANK-ID.                                                
C36298*                                                                 12667000
C36298     PERFORM 7400-GET-BANK-NAME THRU 7400-EXIT.                   
C36298     MOVE D1-BANK-NAME TO WS-NEW-BANK-NAME.                       
C36298     MOVE D1-ROUTING-NUMBER TO WS-NEW-BANK-ROUTING.               
C36298                                                                  
C36298     MOVE JF-BANK-ID TO WS-HOLD-BANK-ID-NUM.                      
C36298     PERFORM 7400-GET-BANK-NAME THRU 7400-EXIT.                   
C36298     MOVE D1-BANK-NAME TO WS-OLD-BANK-NAME.                       
C36298     MOVE D1-ROUTING-NUMBER TO WS-OLD-BANK-ROUTING.               
C36298                                                                  
C36298     MOVE WS-TRAN-APPL-NO     TO MI-TRAN-APPL-NO.                 
C36298     MOVE SPACES              TO MI-TABLE-ID.                     
C36298     MOVE +9                  TO MI-PRV-COLUMN-VALUE-LEN.         
C36298     MOVE WS-OLD-BANK-ROUTING TO MI-PRV-COLUMN-VALUE-TEXT.        
C36298     MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN.         
C36298     MOVE WS-NEW-BANK-ROUTING TO MI-CHG-COLUMN-VALUE-TEXT.        
C36298     MOVE 'ROUTING NUMBER'    TO MI-COLUMN-DESC.                  
C36298     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
C36298     ADD 1                    TO WS-TRAN-APPL-NO.                 
C36298                                                                  
C36298     MOVE WS-TRAN-APPL-NO     TO MI-TRAN-APPL-NO.                 
C36298     MOVE SPACES              TO MI-TABLE-ID.                     
C36298     MOVE +50                 TO MI-PRV-COLUMN-VALUE-LEN.         
C36298     MOVE WS-OLD-BANK-NAME    TO MI-PRV-COLUMN-VALUE-TEXT.        
C36298     MOVE +50                 TO MI-CHG-COLUMN-VALUE-LEN.         
C36298     MOVE WS-NEW-BANK-NAME    TO MI-CHG-COLUMN-VALUE-TEXT.        
C36298     MOVE 'BANK NAME     '    TO MI-COLUMN-DESC.                  
C36298     IF MI-TRAN-APPL-NO EQUAL 1                                   
C36298        MOVE +25 TO MH-TRAN-COMMENT-LEN                           
C36298        MOVE 'PRIMARY BANK INFO CHANGED' TO MH-TRAN-COMMENT-TEXT  
C36298     END-IF.                                                      
C36298     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
C36298     ADD 1                   TO WS-TRAN-APPL-NO.                  
C36298     MOVE 'Y' TO WS-UPD-BANK-ACCT-INFO.                           
C36298     MOVE PARM-BANK-ID TO WS-HOLD-BANK-ID.                        
C36298     MOVE WS-HOLD-BANK-ID-NUMERIC TO WS-HOLD-BANK-ID-NUM.         
C36298     MOVE WS-HOLD-BANK-ID-NUM TO JF-BANK-ID                       
C36298                                 BE-BANK-ID.                      
C36298                                                                  
C36298 5750-EXIT.                                                       
C36298     EXIT.                                                        
C36298*                                                                 15470000
      ******************************************************************12672000
      * JOURNALING INCLUDE                                             *12680000
      * 6530-LOAD-MNT-TRANS-HIST                                       *        
      * 6540-INSERT-MNT-TRANS-HIST                                     *        
      * 6550-INSERT-MT-TRN-HST-DET                                     *        
      ******************************************************************12690000
      *                                                                         
           EXEC SQL                                                     12700000
              INCLUDE CPD00067                                          12710000
           END-EXEC.                                                    12720000
      *                                                                 12730000
      ******************************************************************12740000
      * 7000-SELECT-ACCOUNT                                            *12750000
      ******************************************************************12760000
      *                                                                 12770000
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
               SELECT 'YES',                                            
                      ACCOUNT_NO,                                       
                      CUSTOMER_NO,                                      
                      PREMISE_NO,                                       
                      DATE_LAST_ACTION,                                 
C34097                CODES_DATA_PRESENT                                
               INTO   :WS-ACCOUNT-EXISTS-FLAG,                          
                      :AT-ACCOUNT-NO,                                   
                      :AT-CUSTOMER-NO,                                  
                      :AT-PREMISE-NO,                                   
                      :AT-DATE-LAST-ACTION :WS-NULL-ACTION-DATE,         
C34097                :AT-CODES-DATA-PRESENT                            
               FROM   CSS_ACCOUNT WITH(READUNCOMMITTED)                         
               WHERE  ACCOUNT_NO  = :AT-ACCOUNT-NO                      
C34097                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     12800000
MFA-TR*        SELECT 'YES',                                            12810000
MFA-TR*               ACCOUNT_NO,                                       12820000
MFA-TR*               CUSTOMER_NO,                                      12830000
MFA-TR*               PREMISE_NO,                                       12840000
MFA-TR*               DATE_LAST_ACTION,                                 12850000
MFA-TR*               CODES_DATA_PRESENT                                        
MFA-TR*        INTO   :WS-ACCOUNT-EXISTS-FLAG,                          12860000
MFA-TR*               :AT-ACCOUNT-NO,                                   12870000
MFA-TR*               :AT-CUSTOMER-NO,                                  12880000
MFA-TR*               :AT-PREMISE-NO,                                   12890000
MFA-TR*               :AT-DATE-LAST-ACTION:WS-NULL-ACTION-DATE,         12900000
MFA-TR*               :AT-CODES-DATA-PRESENT                                    
MFA-TR*        FROM   CSS_ACCOUNT                                       12910000
MFA-TR*        WHERE  ACCOUNT_NO  = :AT-ACCOUNT-NO                      12920000
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    12930000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7000'          TO ACTIVE-PARAGRAPH                  
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCOUNT'        TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
C33210     EXIT.                                                        
      *                                                                         
      ******************************************************************13130000
      * 7100-SELECT-BANK                                               *13140000
      ******************************************************************13150000
      *                                                                 13160000
       7100-SELECT-BANK.                                                
                                                                        
           EXEC SQL                                                     
               SELECT 'Y',                                              
                      ACCOUNT_NO,                                       
                      CUSTOMER_NO,                                      
                      BANK_ACCT_NO,                                     
                      BANK_ID,                                          
                      BANK_ACCOUNT_NAME,                                
                      ACCT_TYPE_CD,                                     
                      ESTABLISHED_DATE,                                 
                      STATUS_CHANGE_DT,                                 
                      RESUME_DRAFT_DT,                                  
                      REQSTED_DRAFT_DAY,                                
                      DRAFT_CYCLE,                                      
                      LAST_DRAFT_CYCLE,                                 
C29529                LAST_DRAFT_DATE,                                  
                      STATUS_CODE,                                      
TP9490                PRENOTE_DATE,                                     
                      REMARKS,                                          
25964                 INIT_TYPE_CD,                                     
T29529                CUST_BANK_SEQ_NO                                  
               INTO   :WS-BANK-EXISTS-FLAG,                             
                      :BE-ACCOUNT-NO,                                   
                      :BE-CUSTOMER-NO,                                  
                      :BE-BANK-ACCT-NO,                                 
                      :BE-BANK-ID,                                      
                      :BE-BANK-ACCOUNT-NAME,                            
                      :BE-ACCT-TYPE-CD,                                 
                      :BE-ESTABLISHED-DATE :WS-NULL-EST-DATE,            
                      :BE-STATUS-CHANGE-DT :WS-NULL-STATUS-DATE,         
                      :BE-RESUME-DRAFT-DT :WS-NULL-RESUME-DATE,          
                      :BE-REQSTED-DRAFT-DAY,                            
                      :BE-DRAFT-CYCLE,                                  
                      :BE-LAST-DRAFT-CYCLE,                             
C29529                :BE-LAST-DRAFT-DATE :WS-NULL-LAST-DRFT-DT,         
                      :BE-STATUS-CODE,                                  
TP9490                :BE-PRENOTE-DATE :WS-NULL-PRENOTE-DATE,            
                      :BE-REMARKS,                                      
25964                 :BE-INIT-TYPE-CD,                                 
T29529                :BE-CUST-BANK-SEQ-NO                              
               FROM   CSS_BANK_EFT WITH(READUNCOMMITTED)                        
               WHERE  ACCOUNT_NO   = :BE-ACCOUNT-NO                     
C34097                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     13190000
MFA-TR*        SELECT 'Y',                                              13200000
MFA-TR*               ACCOUNT_NO,                                       13210000
MFA-TR*               CUSTOMER_NO,                                      13220000
MFA-TR*               BANK_ACCT_NO,                                     13230000
MFA-TR*               BANK_ID,                                          13240000
MFA-TR*               BANK_ACCOUNT_NAME,                                13250000
MFA-TR*               ACCT_TYPE_CD,                                     13260000
MFA-TR*               ESTABLISHED_DATE,                                 13270000
MFA-TR*               STATUS_CHANGE_DT,                                 13280000
MFA-TR*               RESUME_DRAFT_DT,                                  13290000
MFA-TR*               REQSTED_DRAFT_DAY,                                13300000
MFA-TR*               DRAFT_CYCLE,                                      13310000
MFA-TR*               LAST_DRAFT_CYCLE,                                 13320000
MFA-TR*               LAST_DRAFT_DATE,                                  13320000
MFA-TR*               STATUS_CODE,                                      13330000
MFA-TR*               PRENOTE_DATE,                                     13331000
MFA-TR*               REMARKS,                                          13340000
MFA-TR*               INIT_TYPE_CD,                                             
MFA-TR*               CUST_BANK_SEQ_NO                                          
MFA-TR*        INTO   :WS-BANK-EXISTS-FLAG,                             13350000
MFA-TR*               :BE-ACCOUNT-NO,                                   13360000
MFA-TR*               :BE-CUSTOMER-NO,                                  13370000
MFA-TR*               :BE-BANK-ACCT-NO,                                 13380000
MFA-TR*               :BE-BANK-ID,                                      13390000
MFA-TR*               :BE-BANK-ACCOUNT-NAME,                            13400000
MFA-TR*               :BE-ACCT-TYPE-CD,                                 13410000
MFA-TR*               :BE-ESTABLISHED-DATE:WS-NULL-EST-DATE,            13420000
MFA-TR*               :BE-STATUS-CHANGE-DT:WS-NULL-STATUS-DATE,         13430000
MFA-TR*               :BE-RESUME-DRAFT-DT:WS-NULL-RESUME-DATE,          13440000
MFA-TR*               :BE-REQSTED-DRAFT-DAY,                            13450000
MFA-TR*               :BE-DRAFT-CYCLE,                                  13460000
MFA-TR*               :BE-LAST-DRAFT-CYCLE,                             13470000
MFA-TR*               :BE-LAST-DRAFT-DATE:WS-NULL-LAST-DRFT-DT,         13470000
MFA-TR*               :BE-STATUS-CODE,                                  13480000
MFA-TR*               :BE-PRENOTE-DATE:WS-NULL-PRENOTE-DATE,            13481000
MFA-TR*               :BE-REMARKS,                                      13490000
MFA-TR*               :BE-INIT-TYPE-CD,                                         
MFA-TR*               :BE-CUST-BANK-SEQ-NO                                      
MFA-TR*        FROM   CSS_BANK_EFT                                      13500000
MFA-TR*        WHERE  ACCOUNT_NO   = :BE-ACCOUNT-NO                     13510000
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                    13520000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-NULL-EST-DATE EQUAL -1                              
                 MOVE SPACES               TO BE-ESTABLISHED-DATE       
              END-IF                                                    
              IF WS-NULL-STATUS-DATE EQUAL -1                           
                 MOVE SPACES               TO BE-STATUS-CHANGE-DT       
              END-IF                                                    
              IF WS-NULL-RESUME-DATE EQUAL -1                           
                 MOVE SPACES               TO BE-RESUME-DRAFT-DT        
              END-IF                                                    
TP9490        IF WS-NULL-PRENOTE-DATE EQUAL -1                          
TP9490           MOVE SPACES               TO BE-PRENOTE-DATE           
TP9490        END-IF                                                    
C29529        IF WS-NULL-LAST-DRFT-DT EQUAL -1                          
C29529           MOVE SPACES               TO BE-LAST-DRAFT-DATE        
C29529        END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'N' TO WS-BANK-EXISTS-FLAG                        
                 MOVE SPACES TO BE-ESTABLISHED-DATE                     
                 MOVE SPACES TO BE-STATUS-CHANGE-DT                     
                 MOVE SPACES TO BE-RESUME-DRAFT-DT                      
                 MOVE 0      TO BE-BANK-ID                              
              ELSE                                                      
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE '7100'               TO ACTIVE-PARAGRAPH          
                 MOVE 'SELECT'             TO ABEND-FUNCTION            
                 MOVE 'CSS_BANK_EFT'       TO TABLE-1                   
                 MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1           
                 MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1         
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 13710000
      ******************************************************************13720000
      * 7200-SELECT-PEND                                               *13730000
      ******************************************************************13740000
      *                                                                 13750000
       7200-SELECT-PEND.                                                
                                                                        
           EXEC SQL                                                     
               SELECT 'Y',                                              
                      DRAFT_AMT,                                        
                      ACCOUNT_NO,                                       
                      DRAFT_DATE,                                       
                      TRANSACTION_CD,                                   
23549                 CODE_SOURCE_ID                                    
               INTO   :WS-PEND-EXISTS-FLAG,                             
                      :PB-DRAFT-AMT,                                    
                      :PB-ACCOUNT-NO,                                   
                      :PB-DRAFT-DATE :WS-NULL-DRFT-DATE,                 
                      :PB-TRANSACTION-CD,                               
23549                 :PB-CODE-SOURCE-ID                                
               FROM   CSS_PNDNG_BNK_DRFT WITH(READUNCOMMITTED)                  
               WHERE  ACCOUNT_NO  = :PB-ACCOUNT-NO                      
C29529           AND  PYMT_TRANS_TS = CIS.CHAR2TIMESTAMP(
                                                      :PB-PYMT-TRANS-TS
              )                 
C34097                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     13780000
MFA-TR*        SELECT 'Y',                                              13790000
MFA-TR*               DRAFT_AMT,                                        13800000
MFA-TR*               ACCOUNT_NO,                                       13810000
MFA-TR*               DRAFT_DATE,                                       13820000
MFA-TR*               TRANSACTION_CD,                                   13830000
MFA-TR*               CODE_SOURCE_ID                                            
MFA-TR*        INTO   :WS-PEND-EXISTS-FLAG,                             13840000
MFA-TR*               :PB-DRAFT-AMT,                                    13850000
MFA-TR*               :PB-ACCOUNT-NO,                                   13860000
MFA-TR*               :PB-DRAFT-DATE:WS-NULL-DRFT-DATE,                 13870000
MFA-TR*               :PB-TRANSACTION-CD,                               13880000
MFA-TR*               :PB-CODE-SOURCE-ID                                        
MFA-TR*        FROM   CSS_PNDNG_BNK_DRFT                                13890000
MFA-TR*        WHERE  ACCOUNT_NO  = :PB-ACCOUNT-NO                      13900000
MFA-TR*          AND  PYMT_TRANS_TS = :PB-PYMT-TRANS-TS                         
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    13910000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C36437        IF BE-STATUS-CODE >= 'M'                                  
C36437           PERFORM 7250-GET-APPLIED-FL THRU 7250-EXIT             
C36437        ELSE                                                      
C36437           MOVE 'N' TO JT-APPLIED-FL                              
C36437        END-IF                                                    
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'N'    TO WS-PEND-EXISTS-FLAG                     
C36437                          JT-APPLIED-FL                           
                 MOVE ZERO   TO PB-DRAFT-AMT                            
                                PB-TRANSACTION-CD                       
                 MOVE SPACES TO PB-DRAFT-DATE                           
              ELSE                                                      
                 MOVE PROGRAM-NAME    TO ABEND-PROGRAM                  
                 MOVE '7200'          TO ACTIVE-PARAGRAPH               
                 MOVE 'SELECT'             TO ABEND-FUNCTION            
                 MOVE 'CSS_PNDNG_BNK_DRFT' TO TABLE-1                   
                 MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1           
                 MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1         
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
C36437*                                                                         
C36437****************************************************************  10970000
C36437* SELECT THE APPLIED FLAG                                      *  10980000
C36437****************************************************************  10990000
C36437*                                                                         
C36437 7250-GET-APPLIED-FL.                                             
C36437     EXEC SQL                                                     
C36437        SELECT APPLIED_FL                                         
C36437          INTO :JT-APPLIED-FL                                     
C36437          FROM CSS_PAYMENT_TRANS WITH(READUNCOMMITTED)                    
C36437         WHERE ACCOUNT_NO   = :PB-ACCOUNT-NO                      
C36437           AND PAYMENT_AMT  = :PB-DRAFT-AMT                       
C36437           AND PYMT_RCVD_TS = CIS.CHAR2TIMESTAMP(:PB-PYMT-TRANS-TS
              )                   
C36437                                                           
C36437     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     11030000
MFA-TR*       SELECT APPLIED_FL                                         11040000
MFA-TR*         INTO :JT-APPLIED-FL                                     11090000
MFA-TR*         FROM CSS_PAYMENT_TRANS                                  11140000
MFA-TR*        WHERE ACCOUNT_NO   = :PB-ACCOUNT-NO                      11150000
MFA-TR*          AND PAYMENT_AMT  = :PB-DRAFT-AMT                               
MFA-TR*          AND PYMT_RCVD_TS = :PB-PYMT-TRANS-TS                   13490002
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    11160000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36437                                                                  
C36437     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C36437                                                                  
C36437     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C36437        NEXT SENTENCE                                             
C36437     ELSE                                                         
C36437        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
C36437           MOVE 'N' TO JT-APPLIED-FL                              
C36437        ELSE                                                      
C36437           MOVE PROGRAM-NAME      TO ABEND-PROGRAM                
C36437           MOVE '7250'            TO ACTIVE-PARAGRAPH             
C36437           MOVE 'SELECT'          TO ABEND-FUNCTION               
C36437           MOVE 'CSS_PAYMENT_TRANS' TO TABLE-1                    
C36437           MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1              
C36437           MOVE PB-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1            
C36434           PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
C36437           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
C36437        END-IF                                                    
C36437     END-IF.                                                      
C36437                                                                  
C36437 7250-EXIT.                                                       
C36437     EXIT.                                                        
      *                                                                 14180000
C29529******************************************************************13720000
C29529* 7300-GET-MAX-SEQ-NUM                                           *13730000
C29529******************************************************************13740000
C29529*                                                                 13750000
C29529 7300-GET-MAX-SEQ-NUM.                                            
C29529                                                                  
C29529     EXEC SQL                                                     
C29529         SELECT MAX(CUST_BANK_SEQ_NO)                             
C29529           INTO :JF-CUST-BANK-SEQ-NO :WS-NULL-CUST-SEQ-NO          
C29529           FROM CSS_CUSTOMER_BANK WITH(READUNCOMMITTED)                   
C29529          WHERE CUSTOMER_NO = :JF-CUSTOMER-NO                     
A01679                                                           
C29529     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     13780000
MFA-TR*        SELECT MAX(CUST_BANK_SEQ_NO)                                     
MFA-TR*          INTO :JF-CUST-BANK-SEQ-NO:WS-NULL-CUST-SEQ-NO                  
MFA-TR*          FROM CSS_CUSTOMER_BANK                                         
MFA-TR*         WHERE CUSTOMER_NO = :JF-CUSTOMER-NO                             
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    15310000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29529                                                                  
C29529     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
C29529                                                                  
C29529     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C29529        IF WS-NULL-CUST-SEQ-NO < 0                                
C29529           MOVE ZERO              TO JF-CUST-BANK-SEQ-NO          
C29529        END-IF                                                    
C29529     ELSE                                                         
C29529        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
C29529        MOVE '7300'               TO ACTIVE-PARAGRAPH             
C29529        MOVE 'SELECT'             TO ABEND-FUNCTION               
C29529        MOVE 'CSS_CUSTOMER_BANK'  TO TABLE-1                      
C29529        MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
C29529        MOVE JF-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
C29529        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C29529        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C29529     END-IF.                                                      
C29529                                                                  
C29529 7300-EXIT.                                                       
C29529     EXIT.                                                        
C29529*                                                                 14900000
C36298******************************************************************14920000
C36298* 7400-GET-BANK-NAME                                             *14930000
C36298******************************************************************14940000
C36298*                                                                 14950000
C36298 7400-GET-BANK-NAME.                                              
C36298                                                                  
C36298     EXEC SQL                                                     
C36298         SELECT BANK_NAME                                         
C36298               ,ROUTING_NUMBER                                    
C36298           INTO :D1-BANK-NAME                                     
C36298               ,:D1-ROUTING-NUMBER                                
C36298           FROM CSS_BANK WITH(READUNCOMMITTED)                            
C36298          WHERE BANK_ID = :WS-HOLD-BANK-ID-NUM                    
C34097                                                           
C36298     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14980000
MFA-TR*        SELECT BANK_NAME                                                 
MFA-TR*              ,ROUTING_NUMBER                                            
MFA-TR*          INTO :D1-BANK-NAME                                             
MFA-TR*              ,:D1-ROUTING-NUMBER                                        
MFA-TR*          FROM CSS_BANK                                                  
MFA-TR*         WHERE BANK_ID = :WS-HOLD-BANK-ID-NUM                            
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    15310000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36298                                                                  
C36298     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C36298                                                                  
C36298     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C36298        CONTINUE                                                  
C36298     ELSE                                                         
C36298        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
C36298        MOVE '7400'               TO ACTIVE-PARAGRAPH             
C36298        MOVE 'SELECT'             TO ABEND-FUNCTION               
C36298        MOVE 'CSS_BANK'           TO TABLE-1                      
C36298        MOVE 'BANK_ID'            TO TABLE-ELEMENT-1              
C36298        MOVE WS-BANK-ID-NUM       TO HOSTVAR-ELEMENT-1            
C36298        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C36298        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C36298     END-IF.                                                      
C36298                                                                  
C36298 7400-EXIT.                                                       
C36298     EXIT.                                                        
C36298*                                                                 15470000
C29529******************************************************************14920000
C29529* 7500-SELECT-CUST-BANK                                          *14930000
C29529******************************************************************14940000
C29529*                                                                 14950000
C29529 7500-SELECT-CUST-BANK.                                           
C29529                                                                  
C29529     EXEC SQL                                                     
C29529         SELECT CUST_BANK_SEQ_NO                                  
C29529               ,BANK_ACCOUNT_NAME                                 
C29529           INTO :JF-CUST-BANK-SEQ-NO :WS-NULL-CUST-SEQ-NO          
C29529               ,:JF-BANK-ACCOUNT-NAME                             
C29529           FROM CSS_CUSTOMER_BANK WITH(READUNCOMMITTED)                   
C29529          WHERE CUSTOMER_NO        = :JF-CUSTOMER-NO              
C29529            AND BANK_ACCT_NO       = :JF-BANK-ACCT-NO             
C29529            AND BANK_ACCT_NICKNAME = :JF-BANK-ACCT-NICKNAME       
C29529            AND BANK_ACCT_STAT_CD <> 'D'                          
C34097                                                           
C29529     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14980000
MFA-TR*        SELECT CUST_BANK_SEQ_NO                                          
MFA-TR*              ,BANK_ACCOUNT_NAME                                         
MFA-TR*          INTO :JF-CUST-BANK-SEQ-NO:WS-NULL-CUST-SEQ-NO                  
MFA-TR*              ,:JF-BANK-ACCOUNT-NAME                                     
MFA-TR*          FROM CSS_CUSTOMER_BANK                                         
MFA-TR*         WHERE CUSTOMER_NO        = :JF-CUSTOMER-NO                      
MFA-TR*           AND BANK_ACCT_NO       = :JF-BANK-ACCT-NO                     
MFA-TR*           AND BANK_ACCT_NICKNAME = :JF-BANK-ACCT-NICKNAME               
MFA-TR*           AND BANK_ACCT_STAT_CD <> 'D'                                  
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    15310000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29529                                                                  
C29529     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C29529                                                                  
C29529     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
C29529        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
C29529           MOVE 'Y'               TO WS-CST-BNK-EXISTS-FLAG       
C29529           MOVE JF-CUST-BANK-SEQ-NO    TO PB-CUST-BANK-SEQ-NO     
C29529        END-IF                                                    
C29529     ELSE                                                         
C29529        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
C29529        MOVE '7500'               TO ACTIVE-PARAGRAPH             
C29529        MOVE 'SELECT'             TO ABEND-FUNCTION               
C29529        MOVE 'CSS_CUSTOMER_BANK'  TO TABLE-1                      
C29529        MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
C29529        MOVE JF-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
C29529        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C29529        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C29529     END-IF.                                                      
C29529                                                                  
C29529 7500-EXIT.                                                       
C29529     EXIT.                                                        
C29529*                                                                 15470000
C29529******************************************************************14920000
C29529* 7600-GET-BANK-DETAILS                                          *14930000
C29529******************************************************************14940000
C29529*                                                                 14950000
C29529 7600-GET-BANK-DETAILS.                                           
C29529                                                                  
C29529     EXEC SQL                                                     
C29529         SELECT BANK_ACCOUNT_NAME                                 
C29529               ,BANK_ACCT_NO                                      
C29529               ,BANK_ACCT_STAT_CD                                 
C29529               ,BANK_ACCT_TYPE_CD                                 
C29529               ,BANK_ID                                           
C36298               ,BANK_ACCT_NICKNAME                                
C29529           INTO :JF-BANK-ACCOUNT-NAME                             
C29529               ,:JF-BANK-ACCT-NO                                  
C29529               ,:JF-BANK-ACCT-STAT-CD                             
C29529               ,:JF-BANK-ACCT-TYPE-CD                             
C29529               ,:JF-BANK-ID                                       
C36298               ,:JF-BANK-ACCT-NICKNAME                            
C29529           FROM CSS_CUSTOMER_BANK WITH(READUNCOMMITTED)                   
C29529          WHERE CUSTOMER_NO        = :JF-CUSTOMER-NO              
C29529            AND CUST_BANK_SEQ_NO   = :JF-CUST-BANK-SEQ-NO         
C34097                                                           
C29529     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14980000
MFA-TR*        SELECT BANK_ACCOUNT_NAME                                         
MFA-TR*              ,BANK_ACCT_NO                                              
MFA-TR*              ,BANK_ACCT_STAT_CD                                         
MFA-TR*              ,BANK_ACCT_TYPE_CD                                         
MFA-TR*              ,BANK_ID                                                   
MFA-TR*              ,BANK_ACCT_NICKNAME                                        
MFA-TR*          INTO :JF-BANK-ACCOUNT-NAME                                     
MFA-TR*              ,:JF-BANK-ACCT-NO                                          
MFA-TR*              ,:JF-BANK-ACCT-STAT-CD                                     
MFA-TR*              ,:JF-BANK-ACCT-TYPE-CD                                     
MFA-TR*              ,:JF-BANK-ID                                               
MFA-TR*              ,:JF-BANK-ACCT-NICKNAME                                    
MFA-TR*          FROM CSS_CUSTOMER_BANK                                         
MFA-TR*         WHERE CUSTOMER_NO        = :JF-CUSTOMER-NO                      
MFA-TR*           AND CUST_BANK_SEQ_NO   = :JF-CUST-BANK-SEQ-NO                 
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    15310000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29529                                                                  
C29529     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C29529                                                                  
C29529     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C29529        CONTINUE                                                  
C29529     ELSE                                                         
C29529        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
C29529        MOVE '7600'               TO ACTIVE-PARAGRAPH             
C29529        MOVE 'SELECT'             TO ABEND-FUNCTION               
C29529        MOVE 'CSS_CUSTOMER_BANK'  TO TABLE-1                      
C29529        MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
C29529        MOVE JF-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
C29529        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C29529        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C29529     END-IF.                                                      
C29529                                                                  
C29529 7600-EXIT.                                                       
C29529     EXIT.                                                        
C29529*                                                                 15470000
C29529******************************************************************14920000
C29529* 7700-CHK-FOR-UNIQUE-NM                                         *14930000
C29529******************************************************************14940000
C29529*                                                                 14950000
C29529 7700-CHK-FOR-UNIQUE-NM.                                          
C29529                                                                  
C29529     EXEC SQL                                                     
C29529         SELECT CUST_BANK_SEQ_NO                                  
C29529               ,BANK_ACCOUNT_NAME                                 
C29529           INTO :JF-CUST-BANK-SEQ-NO :WS-NULL-CUST-SEQ-NO          
C29529               ,:JF-BANK-ACCOUNT-NAME                             
C29529           FROM CSS_CUSTOMER_BANK WITH(READUNCOMMITTED)                   
C29529          WHERE CUSTOMER_NO         = :JF-CUSTOMER-NO             
C29529            AND BANK_ACCT_NICKNAME  = :JF-BANK-ACCT-NICKNAME      
C29529            AND BANK_ACCT_NO       <> :JF-BANK-ACCT-NO            
C29529            AND BANK_ACCT_STAT_CD  <> 'D'                         
C34097                                                           
C29529     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14980000
MFA-TR*        SELECT CUST_BANK_SEQ_NO                                          
MFA-TR*              ,BANK_ACCOUNT_NAME                                         
MFA-TR*          INTO :JF-CUST-BANK-SEQ-NO:WS-NULL-CUST-SEQ-NO                  
MFA-TR*              ,:JF-BANK-ACCOUNT-NAME                                     
MFA-TR*          FROM CSS_CUSTOMER_BANK                                         
MFA-TR*         WHERE CUSTOMER_NO         = :JF-CUSTOMER-NO                     
MFA-TR*           AND BANK_ACCT_NICKNAME  = :JF-BANK-ACCT-NICKNAME              
MFA-TR*           AND BANK_ACCT_NO       <> :JF-BANK-ACCT-NO                    
MFA-TR*           AND BANK_ACCT_STAT_CD  <> 'D'                                 
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    15310000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29529                                                                  
C29529     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C29529                                                                  
C29529     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
C29529        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
C29529           MOVE 'Y'               TO WS-NICKNAME-EXISTS-FLAG      
C29529        END-IF                                                    
C29529     ELSE                                                         
C29529        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
C29529        MOVE '7700'               TO ACTIVE-PARAGRAPH             
C29529        MOVE 'SELECT'             TO ABEND-FUNCTION               
C29529        MOVE 'CSS_CUSTOMER_BANK'  TO TABLE-1                      
C29529        MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
C29529        MOVE JF-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
C29529        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C29529        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C29529     END-IF.                                                      
C29529                                                                  
C29529 7700-EXIT.                                                       
C29529     EXIT.                                                        
C29529*                                                                 15470000
C29529******************************************************************        
C29529**  7800-SELECT-DELINQUENCY.                                    **        
C29529**       GET DATABASE FROM CSS_DELINQUENCY                      **        
C29529******************************************************************        
C29529*                                                                         
C29529 7800-SELECT-DELINQUENCY.                                         
C29529                                                                  
C29529     EXEC SQL                                                     
C29529        SELECT DELINQ_VALUE                                       
C29529          INTO :C8-DELINQ-VALUE                                   
C29529          FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
C29529         WHERE DELINQ_CD  = :C8-DELINQ-CD                         
C29529           AND COMPANY_NO = '01'                                  
C34097                                                           
C29529     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DELINQ_VALUE                                               
MFA-TR*         INTO :C8-DELINQ-VALUE                                           
MFA-TR*         FROM CSS_DELINQUENCY                                            
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                                 
MFA-TR*          AND COMPANY_NO = '01'                                          
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29529                                                                  
C29529     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
C29529                                                                  
C29529     IF WS-ACTIVE-RETURN-CODE =   SUCCESSFUL-CALL                 
C29529        MOVE C8-DELINQ-VALUE            TO WS-PRENOTE-ACCT        
C29529     ELSE                                                         
C29529        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
C29529           SET PRENOTE-NO               TO TRUE                   
C29529        ELSE                                                      
C29529           MOVE '7800'                  TO ACTIVE-PARAGRAPH       
C29529           MOVE PROGRAM-NAME            TO ABEND-PROGRAM          
C29529           MOVE 'SELECT'                TO ABEND-FUNCTION         
C29529           MOVE 'CSS_DELINQUENCY'       TO TABLE-1                
C29529           MOVE 'PRENOTE'               TO TABLE-ELEMENT-1        
C29529           MOVE C8-DELINQ-CD            TO HOSTVAR-ELEMENT-1      
C29529           PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
C29529           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
C29529        END-IF                                                    
C29529     END-IF.                                                      
C29529                                                                  
C29529 7800-EXIT.                                                       
C29529     EXIT.                                                        
      *                                                                 14910000
      ******************************************************************14920000
      * 8000-INSERT-BANK                                               *14930000
      ******************************************************************14940000
      *                                                                 14950000
       8000-INSERT-BANK.                                                
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_BANK_EFT                                 
                      ( ACCOUNT_NO,                                     
                        CUSTOMER_NO,                                    
                        BANK_ACCT_NO,                                   
                        BANK_ID,                                        
                        BANK_ACCOUNT_NAME,                              
                        ACCT_TYPE_CD,                                   
                        ESTABLISHED_DATE,                               
                        STATUS_CHANGE_DT,                               
                        RESUME_DRAFT_DT,                                
                        REQSTED_DRAFT_DAY,                              
                        DRAFT_CYCLE,                                    
                        LAST_DRAFT_CYCLE,                               
                        STATUS_CODE,                                    
                        PRENOTE_DATE,                                   
                        REMARKS,                                        
25964                   INIT_TYPE_CD,                                   
C29529                  CUST_BANK_SEQ_NO)                               
               VALUES                                                   
                      (:BE-ACCOUNT-NO,                                  
                       :BE-CUSTOMER-NO,                                 
                       :BE-BANK-ACCT-NO,                                
                       :BE-BANK-ID,                                     
                       :BE-BANK-ACCOUNT-NAME,                           
                       :BE-ACCT-TYPE-CD,                                
                       IIF(TRY_CONVERT(DATE, :BE-ESTABLISHED-DATE 
                                             :WS-NULL-EST-DATE
              ) IS NULL OR (PATINDEX('%.%', :BE-ESTABLISHED-DATE 
                                                      :WS-NULL-EST-DATE
              ) <> 0) OR (LEN(:BE-ESTABLISHED-DATE :WS-NULL-EST-DATE
              ) <> 10), CIS.CHAR2DATE(:BE-ESTABLISHED-DATE 
                                                      :WS-NULL-EST-DATE
              ), CONVERT(DATE, :BE-ESTABLISHED-DATE :WS-NULL-EST-DATE
              ) ),           
                       IIF(TRY_CONVERT(DATE, :BE-STATUS-CHANGE-DT 
                                             :WS-NULL-STATUS-DATE
              ) IS NULL OR (PATINDEX('%.%', :BE-STATUS-CHANGE-DT 
                                                   :WS-NULL-STATUS-DATE
              ) <> 0) OR (LEN(:BE-STATUS-CHANGE-DT :WS-NULL-STATUS-DATE
              ) <> 10), CIS.CHAR2DATE(:BE-STATUS-CHANGE-DT 
                                                   :WS-NULL-STATUS-DATE
              ), CONVERT(DATE, :BE-STATUS-CHANGE-DT 
                                                   :WS-NULL-STATUS-DATE
              ) ),        
                       IIF(TRY_CONVERT(DATE, :BE-RESUME-DRAFT-DT 
                                             :WS-NULL-RESUME-DATE
              ) IS NULL OR (PATINDEX('%.%', :BE-RESUME-DRAFT-DT 
                                                   :WS-NULL-RESUME-DATE
              ) <> 0) OR (LEN(:BE-RESUME-DRAFT-DT :WS-NULL-RESUME-DATE
              ) <> 10), CIS.CHAR2DATE(:BE-RESUME-DRAFT-DT 
                                                   :WS-NULL-RESUME-DATE
              ), CONVERT(DATE, :BE-RESUME-DRAFT-DT :WS-NULL-RESUME-DATE
              ) ),         
                       :BE-REQSTED-DRAFT-DAY,                           
                       :BE-DRAFT-CYCLE,                                 
                       :BE-LAST-DRAFT-CYCLE,                            
                       :BE-STATUS-CODE,                                 
                       IIF(TRY_CONVERT(DATE, :BE-PRENOTE-DATE 
                                             :WS-NULL-PRENOTE-DATE
              ) IS NULL OR (PATINDEX('%.%', :BE-PRENOTE-DATE 
                                                  :WS-NULL-PRENOTE-DATE
              ) <> 0) OR (LEN(:BE-PRENOTE-DATE :WS-NULL-PRENOTE-DATE
              ) <> 10), CIS.CHAR2DATE(:BE-PRENOTE-DATE 
                                                  :WS-NULL-PRENOTE-DATE
              ), CONVERT(DATE, :BE-PRENOTE-DATE :WS-NULL-PRENOTE-DATE
              ) ),           
                       :BE-REMARKS,                                     
                       :BE-INIT-TYPE-CD,                                
C29529                 :BE-CUST-BANK-SEQ-NO)                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     14980000
MFA-TR*        INSERT INTO CSS_BANK_EFT                                 14990000
MFA-TR*               ( ACCOUNT_NO,                                     15000000
MFA-TR*                 CUSTOMER_NO,                                    15010000
MFA-TR*                 BANK_ACCT_NO,                                   15020000
MFA-TR*                 BANK_ID,                                        15030000
MFA-TR*                 BANK_ACCOUNT_NAME,                              15040000
MFA-TR*                 ACCT_TYPE_CD,                                   15050000
MFA-TR*                 ESTABLISHED_DATE,                               15060000
MFA-TR*                 STATUS_CHANGE_DT,                               15070000
MFA-TR*                 RESUME_DRAFT_DT,                                15080000
MFA-TR*                 REQSTED_DRAFT_DAY,                              15090000
MFA-TR*                 DRAFT_CYCLE,                                    15100000
MFA-TR*                 LAST_DRAFT_CYCLE,                               15110000
MFA-TR*                 STATUS_CODE,                                    15120000
MFA-TR*                 PRENOTE_DATE,                                   15130000
MFA-TR*                 REMARKS,                                        15140000
MFA-TR*                 INIT_TYPE_CD,                                           
MFA-TR*                 CUST_BANK_SEQ_NO)                                       
MFA-TR*        VALUES                                                   15150000
MFA-TR*               (:BE-ACCOUNT-NO,                                  15160000
MFA-TR*                :BE-CUSTOMER-NO,                                 15170000
MFA-TR*                :BE-BANK-ACCT-NO,                                15180000
MFA-TR*                :BE-BANK-ID,                                     15190000
MFA-TR*                :BE-BANK-ACCOUNT-NAME,                           15200000
MFA-TR*                :BE-ACCT-TYPE-CD,                                15210000
MFA-TR*                :BE-ESTABLISHED-DATE:WS-NULL-EST-DATE,           15220000
MFA-TR*                :BE-STATUS-CHANGE-DT:WS-NULL-STATUS-DATE,        15230000
MFA-TR*                :BE-RESUME-DRAFT-DT:WS-NULL-RESUME-DATE,         15240000
MFA-TR*                :BE-REQSTED-DRAFT-DAY,                           15250000
MFA-TR*                :BE-DRAFT-CYCLE,                                 15260000
MFA-TR*                :BE-LAST-DRAFT-CYCLE,                            15270000
MFA-TR*                :BE-STATUS-CODE,                                 15280000
MFA-TR*                :BE-PRENOTE-DATE:WS-NULL-PRENOTE-DATE,           15290000
MFA-TR*                :BE-REMARKS,                                     15300000
MFA-TR*                :BE-INIT-TYPE-CD,                                        
MFA-TR*                :BE-CUST-BANK-SEQ-NO)                                    
MFA-TR*    END-EXEC.                                                    15310000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8000'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_BANK_EFT'       TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'ESTABLISHED_DATE'   TO TABLE-ELEMENT-2              
CBSI          MOVE 'STATUS_CHANGE_DT'   TO TABLE-ELEMENT-3              
CBSI          MOVE 'RESUME_DRAFT_DT'    TO TABLE-ELEMENT-4              
              MOVE BE-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE BE-ESTABLISHED-DATE  TO HOSTVAR-ELEMENT-2            
CBSI          MOVE BE-STATUS-CHANGE-DT  TO HOSTVAR-ELEMENT-3            
CBSI          MOVE BE-RESUME-DRAFT-DT   TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 14480000
      ******************************************************************16130000
      * 8010-INSERT-PEND                                               *16140000
      ******************************************************************16150000
      *                                                                 16160000
       8010-INSERT-PEND.                                                
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_PNDNG_BNK_DRFT                           
                      ( DRAFT_AMT,                                      
                        ACCOUNT_NO,                                     
                        DRAFT_DATE,                                     
                        TRANSACTION_CD,                                 
29529                   CUST_BANK_SEQ_NO,                               
23549                   CODE_SOURCE_ID)                                 
               VALUES                                                   
                      (:PB-DRAFT-AMT,                                   
                       :PB-ACCOUNT-NO,                                  
                       CAST(SYSDATETIMEOFFSET() AS DATE),                       
                       :PB-TRANSACTION-CD,                              
29529                  :PB-CUST-BANK-SEQ-NO,                            
23549                  :PB-CODE-SOURCE-ID)                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     16190000
MFA-TR*        INSERT INTO CSS_PNDNG_BNK_DRFT                           16200000
MFA-TR*               ( DRAFT_AMT,                                      16210000
MFA-TR*                 ACCOUNT_NO,                                     16220000
MFA-TR*                 DRAFT_DATE,                                     16230000
MFA-TR*                 TRANSACTION_CD,                                 16240000
MFA-TR*                 CUST_BANK_SEQ_NO,                                       
MFA-TR*                 CODE_SOURCE_ID)                                         
MFA-TR*        VALUES                                                   16250000
MFA-TR*               (:PB-DRAFT-AMT,                                   16260000
MFA-TR*                :PB-ACCOUNT-NO,                                  16270000
MFA-TR*                CURRENT DATE,                                    16280000
MFA-TR*                :PB-TRANSACTION-CD,                              16290000
MFA-TR*                :PB-CUST-BANK-SEQ-NO,                                    
MFA-TR*                :PB-CODE-SOURCE-ID)                                      
MFA-TR*    END-EXEC.                                                    16300000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8010'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_PNDNG_BNK_DRFT' TO TABLE-1                      
C29529        MOVE PB-DRAFT-AMT         TO WS-DRAFT-AMT-NUMERIC         
C29529        MOVE PB-TRANSACTION-CD    TO WS-TRAN-CD-NUMERIC           
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'DRAFT_AMT'          TO TABLE-ELEMENT-2              
CBSI          MOVE 'TRANSACTION_CD'     TO TABLE-ELEMENT-3              
              MOVE PB-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE WS-DRAFT-AMT-NUMERIC TO HOSTVAR-ELEMENT-2            
CBSI          MOVE PB-TRANSACTION-CD    TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8010-EXIT.                                                       
           EXIT.                                                        
C29529*                                                                 14180000
C29529******************************************************************13720000
C29529* 8020-INSERT-CUST-BANK                                          *13730000
C29529******************************************************************13740000
C29529*                                                                 13750000
C29529 8020-INSERT-CUST-BANK.                                           
C29529                                                                  
C29529     EXEC SQL                                                     
C29529         INSERT INTO CSS_CUSTOMER_BANK                            
C29529                (BANK_ACCOUNT_NAME                                
C29529                ,BANK_ACCT_NO                                     
C29529                ,BANK_ACCT_STAT_CD                                
C29529                ,BANK_ACCT_TYPE_CD                                
C29529                ,BANK_ID                                          
C29529                ,CUST_BANK_SEQ_NO                                 
C29529                ,CUSTOMER_NO                                      
C29529                ,LAST_UPDATE_TS                                   
C29529                ,LAST_UPDATE_USERID                               
C29529                ,BANK_ACCT_NICKNAME)                              
C29529         VALUES                                                   
C29529                (:JF-BANK-ACCOUNT-NAME                            
C29529                ,:JF-BANK-ACCT-NO                                 
C29529                ,:JF-BANK-ACCT-STAT-CD                            
C29529                ,:JF-BANK-ACCT-TYPE-CD                            
C29529                ,:JF-BANK-ID                                      
C29529                ,:JF-CUST-BANK-SEQ-NO                             
C29529                ,:JF-CUSTOMER-NO                                  
C29529                , CIS.CURRENT$TIMESTAMP()                               
C29529                ,:JF-LAST-UPDATE-USERID                           
C29529                ,:JF-BANK-ACCT-NICKNAME)                          
C29529     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     13780000
MFA-TR*        INSERT INTO CSS_CUSTOMER_BANK                            14990000
MFA-TR*               (BANK_ACCOUNT_NAME                                15000000
MFA-TR*               ,BANK_ACCT_NO                                     14150000
MFA-TR*               ,BANK_ACCT_STAT_CD                                14150000
MFA-TR*               ,BANK_ACCT_TYPE_CD                                14150000
MFA-TR*               ,BANK_ID                                          14150000
MFA-TR*               ,CUST_BANK_SEQ_NO                                 14150000
MFA-TR*               ,CUSTOMER_NO                                      14150000
MFA-TR*               ,LAST_UPDATE_TS                                   14150000
MFA-TR*               ,LAST_UPDATE_USERID                               14150000
MFA-TR*               ,BANK_ACCT_NICKNAME)                              14150000
MFA-TR*        VALUES                                                   15150000
MFA-TR*               (:JF-BANK-ACCOUNT-NAME                            15160000
MFA-TR*               ,:JF-BANK-ACCT-NO                                 14150000
MFA-TR*               ,:JF-BANK-ACCT-STAT-CD                            14150000
MFA-TR*               ,:JF-BANK-ACCT-TYPE-CD                            14150000
MFA-TR*               ,:JF-BANK-ID                                      14150000
MFA-TR*               ,:JF-CUST-BANK-SEQ-NO                             14150000
MFA-TR*               ,:JF-CUSTOMER-NO                                  14150000
MFA-TR*               , CURRENT TIMESTAMP                               14150000
MFA-TR*               ,:JF-LAST-UPDATE-USERID                           14150000
MFA-TR*               ,:JF-BANK-ACCT-NICKNAME)                          14150000
MFA-TR*    END-EXEC.                                                    15310000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29529                                                                  
C29529     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
C29529                                                                  
C29529     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C29529        NEXT SENTENCE                                             
C29529     ELSE                                                         
C29529        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
C29529        MOVE '8020'               TO ACTIVE-PARAGRAPH             
C29529        MOVE 'INSERT'             TO ABEND-FUNCTION               
C29529        MOVE 'CSS_CUSTOMER_BANK'  TO TABLE-1                      
C29529        MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
C29529        MOVE JF-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
C29529        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C29529        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C29529     END-IF.                                                      
C29529                                                                  
C29529 8020-EXIT.                                                       
C29529     EXIT.                                                        
      *                                                                 14180000
      ******************************************************************14190000
      * 8100-UPDATE-ACCOUNT                                            *14200000
      ******************************************************************14210000
      *                                                                 14220000
       8100-UPDATE-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
               SET DATE_LAST_ACTION   = CAST(SYSDATETIMEOFFSET() 
           AS DATE)                    
               WHERE  ACCOUNT_NO      = :AT-ACCOUNT-NO                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     14250000
MFA-TR*        UPDATE CSS_ACCOUNT                                       14260000
MFA-TR*        SET DATE_LAST_ACTION   = CURRENT DATE                    14270000
MFA-TR*        WHERE  ACCOUNT_NO      = :AT-ACCOUNT-NO                  14280000
MFA-TR*    END-EXEC.                                                    14290000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCOUNT'        TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07340000
      ******************************************************************14490000
      * 8110-UPDATE-BANK                                               *14500000
      ******************************************************************14510000
      *                                                                 14520000
       8110-UPDATE-BANK.                                                
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_BANK_EFT                                      
               SET BANK_ACCT_NO       = :BE-BANK-ACCT-NO,               
                   BANK_ID            = :BE-BANK-ID,                    
                   BANK_ACCOUNT_NAME  = :BE-BANK-ACCOUNT-NAME,          
                   ACCT_TYPE_CD       = :BE-ACCT-TYPE-CD,               
                   ESTABLISHED_DATE   =                                 
                      IIF(TRY_CONVERT(DATE, :BE-ESTABLISHED-DATE 
                                            :WS-NULL-EST-DATE
              ) IS NULL OR (PATINDEX('%.%', :BE-ESTABLISHED-DATE 
                                                      :WS-NULL-EST-DATE
              ) <> 0) OR (LEN(:BE-ESTABLISHED-DATE :WS-NULL-EST-DATE
              ) <> 10), CIS.CHAR2DATE(:BE-ESTABLISHED-DATE 
                                                      :WS-NULL-EST-DATE
              ), CONVERT(DATE, :BE-ESTABLISHED-DATE :WS-NULL-EST-DATE
              ) ),            
                   STATUS_CHANGE_DT   =                                 
                      IIF(TRY_CONVERT(DATE, :BE-STATUS-CHANGE-DT 
                                            :WS-NULL-STATUS-DATE
              ) IS NULL OR (PATINDEX('%.%', :BE-STATUS-CHANGE-DT 
                                                   :WS-NULL-STATUS-DATE
              ) <> 0) OR (LEN(:BE-STATUS-CHANGE-DT :WS-NULL-STATUS-DATE
              ) <> 10), CIS.CHAR2DATE(:BE-STATUS-CHANGE-DT 
                                                   :WS-NULL-STATUS-DATE
              ), CONVERT(DATE, :BE-STATUS-CHANGE-DT 
                                                   :WS-NULL-STATUS-DATE
              ) ),         
C29529             LAST_DRAFT_DATE    =                                 
C29529                IIF(TRY_CONVERT(DATE, :BE-LAST-DRAFT-DATE 
                                            :WS-NULL-LAST-DRFT-DT
              ) IS NULL OR (PATINDEX('%.%', :BE-LAST-DRAFT-DATE 
                                                  :WS-NULL-LAST-DRFT-DT
              ) <> 0) OR (LEN(:BE-LAST-DRAFT-DATE :WS-NULL-LAST-DRFT-DT
              ) <> 10), CIS.CHAR2DATE(:BE-LAST-DRAFT-DATE 
                                                  :WS-NULL-LAST-DRFT-DT
              ), CONVERT(DATE, :BE-LAST-DRAFT-DATE 
                                                  :WS-NULL-LAST-DRFT-DT
              ) ),         
                   RESUME_DRAFT_DT    =                                 
                      IIF(TRY_CONVERT(DATE, :BE-RESUME-DRAFT-DT 
                                            :WS-NULL-RESUME-DATE
              ) IS NULL OR (PATINDEX('%.%', :BE-RESUME-DRAFT-DT 
                                                   :WS-NULL-RESUME-DATE
              ) <> 0) OR (LEN(:BE-RESUME-DRAFT-DT :WS-NULL-RESUME-DATE
              ) <> 10), CIS.CHAR2DATE(:BE-RESUME-DRAFT-DT 
                                                   :WS-NULL-RESUME-DATE
              ), CONVERT(DATE, :BE-RESUME-DRAFT-DT :WS-NULL-RESUME-DATE
              ) ),          
TP9490             PRENOTE_DATE   =                                     
TP9490                IIF(TRY_CONVERT(DATE, :BE-PRENOTE-DATE 
                                            :WS-NULL-PRENOTE-DATE
              ) IS NULL OR (PATINDEX('%.%', :BE-PRENOTE-DATE 
                                                  :WS-NULL-PRENOTE-DATE
              ) <> 0) OR (LEN(:BE-PRENOTE-DATE :WS-NULL-PRENOTE-DATE
              ) <> 10), CIS.CHAR2DATE(:BE-PRENOTE-DATE 
                                                  :WS-NULL-PRENOTE-DATE
              ), CONVERT(DATE, :BE-PRENOTE-DATE :WS-NULL-PRENOTE-DATE
              ) ),            
                   REQSTED_DRAFT_DAY  = :BE-REQSTED-DRAFT-DAY,          
                   DRAFT_CYCLE        = :BE-DRAFT-CYCLE,                
                   STATUS_CODE        = :BE-STATUS-CODE,                
                   REMARKS            = :BE-REMARKS,                    
25964              INIT_TYPE_CD       = :BE-INIT-TYPE-CD,               
C29529             CUST_BANK_SEQ_NO   = :BE-CUST-BANK-SEQ-NO            
               WHERE  ACCOUNT_NO      = :BE-ACCOUNT-NO                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     14550000
MFA-TR*        UPDATE CSS_BANK_EFT                                      14560000
MFA-TR*        SET BANK_ACCT_NO       = :BE-BANK-ACCT-NO,               14570000
MFA-TR*            BANK_ID            = :BE-BANK-ID,                    14580000
MFA-TR*            BANK_ACCOUNT_NAME  = :BE-BANK-ACCOUNT-NAME,          14590000
MFA-TR*            ACCT_TYPE_CD       = :BE-ACCT-TYPE-CD,               14600000
MFA-TR*            ESTABLISHED_DATE   =                                 14610000
MFA-TR*               :BE-ESTABLISHED-DATE:WS-NULL-EST-DATE,            14620000
MFA-TR*            STATUS_CHANGE_DT   =                                 14630000
MFA-TR*               :BE-STATUS-CHANGE-DT:WS-NULL-STATUS-DATE,         14640000
MFA-TR*            LAST_DRAFT_DATE    =                                 14630000
MFA-TR*               :BE-LAST-DRAFT-DATE:WS-NULL-LAST-DRFT-DT,         14640000
MFA-TR*            RESUME_DRAFT_DT    =                                 14650000
MFA-TR*               :BE-RESUME-DRAFT-DT:WS-NULL-RESUME-DATE,          14660000
MFA-TR*            PRENOTE_DATE   =                                     14661000
MFA-TR*               :BE-PRENOTE-DATE:WS-NULL-PRENOTE-DATE,            14662000
MFA-TR*            REQSTED_DRAFT_DAY  = :BE-REQSTED-DRAFT-DAY,          14670000
MFA-TR*            DRAFT_CYCLE        = :BE-DRAFT-CYCLE,                14680000
MFA-TR*            STATUS_CODE        = :BE-STATUS-CODE,                14690000
MFA-TR*            REMARKS            = :BE-REMARKS,                    14700000
MFA-TR*            INIT_TYPE_CD       = :BE-INIT-TYPE-CD,                       
MFA-TR*            CUST_BANK_SEQ_NO   = :BE-CUST-BANK-SEQ-NO                    
MFA-TR*        WHERE  ACCOUNT_NO      = :BE-ACCOUNT-NO                  14710000
MFA-TR*    END-EXEC.                                                    14720000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8110'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_BANK_EFT'       TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'ESTABLISHED_DATE'   TO TABLE-ELEMENT-2              
CBSI          MOVE 'STATUS_CHANGE_DT'   TO TABLE-ELEMENT-3              
CBSI          MOVE 'RESUME_DRAFT_DT'    TO TABLE-ELEMENT-4              
CBSI          MOVE BE-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE BE-ESTABLISHED-DATE  TO HOSTVAR-ELEMENT-2            
CBSI          MOVE BE-STATUS-CHANGE-DT  TO HOSTVAR-ELEMENT-3            
CBSI          MOVE BE-RESUME-DRAFT-DT   TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
C36298     IF WS-UPD-BANK-ACCT-INFO = 'Y'                               
C36298        PERFORM 8120-UPDATE-CUST-BANK THRU 8120-EXIT              
C36298     END-IF.                                                      
                                                                        
       8110-EXIT.                                                       
           EXIT.                                                        
C29529*                                                                 14480000
C33210******************************************************************14490000
C29529* 8120-UPDATE-CUST-BANK                                          *14500000
C29529******************************************************************14510000
C29529*                                                                 14520000
C29529 8120-UPDATE-CUST-BANK.                                           
C29529                                                                  
C29529     EXEC SQL                                                     
C29529         UPDATE CSS_CUSTOMER_BANK                                 
C29529         SET BANK_ACCOUNT_NAME  = :JF-BANK-ACCOUNT-NAME,          
C29529             BANK_ACCT_NO       = :JF-BANK-ACCT-NO,               
C29529             BANK_ACCT_TYPE_CD  = :JF-BANK-ACCT-TYPE-CD,          
C29529             BANK_ID            = :JF-BANK-ID,                    
C29529             LAST_UPDATE_TS     =  CIS.CURRENT$TIMESTAMP(),             
C29529             LAST_UPDATE_USERID = :JF-LAST-UPDATE-USERID,         
C29529             BANK_ACCT_NICKNAME = :JF-BANK-ACCT-NICKNAME          
C29529         WHERE CUSTOMER_NO      = :JF-CUSTOMER-NO                 
C29529           AND CUST_BANK_SEQ_NO = :JF-CUST-BANK-SEQ-NO            
C29529     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     14550000
MFA-TR*        UPDATE CSS_CUSTOMER_BANK                                 14560000
MFA-TR*        SET BANK_ACCOUNT_NAME  = :JF-BANK-ACCOUNT-NAME,          14570000
MFA-TR*            BANK_ACCT_NO       = :JF-BANK-ACCT-NO,               14580000
MFA-TR*            BANK_ACCT_TYPE_CD  = :JF-BANK-ACCT-TYPE-CD,          14590000
MFA-TR*            BANK_ID            = :JF-BANK-ID,                    14600000
MFA-TR*            LAST_UPDATE_TS     =  CURRENT TIMESTAMP,             14610000
MFA-TR*            LAST_UPDATE_USERID = :JF-LAST-UPDATE-USERID,         14620000
MFA-TR*            BANK_ACCT_NICKNAME = :JF-BANK-ACCT-NICKNAME          14630000
MFA-TR*        WHERE CUSTOMER_NO      = :JF-CUSTOMER-NO                 14710000
MFA-TR*          AND CUST_BANK_SEQ_NO = :JF-CUST-BANK-SEQ-NO            14710000
MFA-TR*    END-EXEC.                                                    14720000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29529                                                                  
C29529     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE        
C29529                                                                  
C29529     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
C29529        NEXT SENTENCE                                             
C29529     ELSE                                                         
C29529        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
C29529        MOVE '8120'               TO ACTIVE-PARAGRAPH             
C29529        MOVE 'UPDATE'             TO ABEND-FUNCTION               
C29529        MOVE 'CSS_CUSTOMER_BANK'  TO TABLE-1                      
C29529        MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
C29529        MOVE 'CUST_BANK_SEQ_NO'   TO TABLE-ELEMENT-2              
C29529        MOVE JF-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
C29529        MOVE JF-CUST-BANK-SEQ-NO  TO HOSTVAR-ELEMENT-2            
C29529        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C29529        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C29529     END-IF.                                                      
C29529                                                                  
C29529 8120-EXIT.                                                       
C29529     EXIT.                                                        
      *                                                                 07030000
      ******************************************************************07040000
      * 8130-UPDATE-AT-CODE.                                           *07050000
      *    -- THIS MODULE UPDATES THE CODES DATA PRESENT CODE FOR      *07060000
      *       THIS ACCOUNT TO THE CSS_ACCOUNT TABLE.                   *07070000
      ******************************************************************07080000
      *                                                                         
       8130-UPDATE-AT-CODE.                                             
      *                                                                 07100000
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT       
                WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-NUM                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07160000
           MOVE SQLCODE                  TO RS-RETURN-CODE.             
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 07190000
           IF (SQLCODE NOT EQUAL TO SUCCESSFUL-CALL)                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8130'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
CBSI          MOVE 'CODES_DATA_PRESENT'  TO TABLE-ELEMENT-2             
CBSI          MOVE WS-ACCOUNT-NO-NUM     TO HOSTVAR-ELEMENT-1           
CBSI          MOVE AT-CODES-DATA-PRESENT TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 07300000
       8130-EXIT.                                                       
           EXIT.                                                        
      *                                                                 07310000
C29529******************************************************************14490000
C29529* 8140-ACTIVATE-PMY-BANK                                        * 14500000
C29529******************************************************************14510000
C29529*                                                                 14520000
C29529 8140-ACTIVATE-PMY-BANK.                                          
C29529                                                                  
C29529     EXEC SQL                                                     
C29529         UPDATE CSS_CUSTOMER_BANK                                 
C29529         SET BANK_ACCT_STAT_CD  = 'A',                            
C29529             LAST_UPDATE_TS     =  CIS.CURRENT$TIMESTAMP(),             
C29529             LAST_UPDATE_USERID = :JF-LAST-UPDATE-USERID          
C29529         WHERE CUSTOMER_NO      = :JF-CUSTOMER-NO                 
C29529           AND CUST_BANK_SEQ_NO = :JF-CUST-BANK-SEQ-NO            
C29529           AND BANK_ACCT_STAT_CD = 'D'                            
C29529     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     14550000
MFA-TR*        UPDATE CSS_CUSTOMER_BANK                                 14560000
MFA-TR*        SET BANK_ACCT_STAT_CD  = 'A',                            14570000
MFA-TR*            LAST_UPDATE_TS     =  CURRENT TIMESTAMP,             14610000
MFA-TR*            LAST_UPDATE_USERID = :JF-LAST-UPDATE-USERID          14620000
MFA-TR*        WHERE CUSTOMER_NO      = :JF-CUSTOMER-NO                 14710000
MFA-TR*          AND CUST_BANK_SEQ_NO = :JF-CUST-BANK-SEQ-NO            14710000
MFA-TR*          AND BANK_ACCT_STAT_CD = 'D'                            14710000
MFA-TR*    END-EXEC.                                                    14720000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29529                                                                  
C29529     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE        
C29529                                                                  
C29529     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
C29529        NEXT SENTENCE                                             
C29529     ELSE                                                         
C29529        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
C29529        MOVE '8140'               TO ACTIVE-PARAGRAPH             
C29529        MOVE 'UPDATE'             TO ABEND-FUNCTION               
C29529        MOVE 'CSS_CUSTOMER_BANK'  TO TABLE-1                      
C29529        MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
C29529        MOVE 'CUST_BANK_SEQ_NO'   TO TABLE-ELEMENT-2              
C29529        MOVE JF-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
C29529        MOVE JF-CUST-BANK-SEQ-NO  TO HOSTVAR-ELEMENT-2            
C29529        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C29529        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C29529     END-IF.                                                      
C29529                                                                  
C29529 8140-EXIT.                                                       
C29529     EXIT.                                                        
C29529*                                                                 14880000
C29529******************************************************************14490000
C29529* 8150-UPDATE-BANK-EFT                                           *14500000
C29529******************************************************************14510000
C29529*                                                                 14520000
C29529 8150-UPDATE-BANK-EFT.                                            
C29529                                                                  
C29529     EXEC SQL                                                     
C29529        UPDATE CSS_BANK_EFT                                       
C29529           SET STATUS_CODE      = :BE-STATUS-CODE                 
C29529              ,INIT_TYPE_CD     = :BE-INIT-TYPE-CD                
C29529              ,STATUS_CHANGE_DT = NULL                            
C29529              ,LAST_DRAFT_DATE  = NULL                            
C29529         WHERE ACCOUNT_NO = :BE-ACCOUNT-NO                        
C29529     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29529                                                                  
C29529     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE        
C29529                                                                  
C29529     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C29529        NEXT SENTENCE                                             
C29529     ELSE                                                         
C29529        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
C29529        MOVE '8150'                     TO ACTIVE-PARAGRAPH       
C29529        MOVE 'UPDATE'                   TO ABEND-FUNCTION         
C29529        MOVE 'CSS_BANK_EFT'             TO TABLE-1                
C29529        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
C29529        MOVE BE-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
C29529        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C29529        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C29529     END-IF.                                                      
C29529                                                                  
C29529 8150-EXIT.                                                       
C29529     EXIT.                                                        
      *                                                                         
C31085******************************************************************14490000
C31085* 8160-UPDATE-ACCT-TYPE                                          *14500000
C31085******************************************************************14510000
C31085*                                                                 14520000
C31085 8160-UPDATE-ACCT-TYPE.                                           
C31085                                                                  
C31085     EXEC SQL                                                     
C31085        UPDATE CSS_BANK_EFT                                       
C31085           SET STATUS_CODE  = :BE-STATUS-CODE                     
C31085              ,INIT_TYPE_CD = :BE-INIT-TYPE-CD                    
C31085         WHERE ACCOUNT_NO = :BE-ACCOUNT-NO                        
C31085     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C31085                                                                  
C31085     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE        
C31085                                                                  
C31085     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C31085        NEXT SENTENCE                                             
C31085     ELSE                                                         
C31085        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
C31085        MOVE '8160'                     TO ACTIVE-PARAGRAPH       
C31085        MOVE 'UPDATE'                   TO ABEND-FUNCTION         
C31085        MOVE 'CSS_BANK_EFT'             TO TABLE-1                
C31085        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
C31085        MOVE BE-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
C31085        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C31085        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C31085     END-IF.                                                      
C31085                                                                  
C31085 8160-EXIT.                                                       
C31085     EXIT.                                                        
      ******************************************************************15510000
      * 8170-UPDATE-PEND                                               *15520000
      ******************************************************************15530000
      *                                                                 15540000
       8170-UPDATE-PEND.                                                
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_PNDNG_BNK_DRFT                                
               SET DRAFT_DATE = IIF(TRY_CONVERT(DATE, :PB-DRAFT-DATE 
                                                      :WS-NULL-DRFT-DATE
              ) IS NULL OR (PATINDEX('%.%', :PB-DRAFT-DATE 
                                                     :WS-NULL-DRFT-DATE
              ) <> 0) OR (LEN(:PB-DRAFT-DATE :WS-NULL-DRFT-DATE
              ) <> 10), CIS.CHAR2DATE(:PB-DRAFT-DATE :WS-NULL-DRFT-DATE
              ), CONVERT(DATE, :PB-DRAFT-DATE :WS-NULL-DRFT-DATE) )        
               WHERE  ACCOUNT_NO = :PB-ACCOUNT-NO                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     15570000
MFA-TR*        UPDATE CSS_PNDNG_BNK_DRFT                                15580000
MFA-TR*        SET DRAFT_DATE = :PB-DRAFT-DATE:WS-NULL-DRFT-DATE        15590000
MFA-TR*        WHERE  ACCOUNT_NO = :PB-ACCOUNT-NO                       15600000
MFA-TR*    END-EXEC.                                                    15610000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE ZEROES            TO WS-ACTIVE-RETURN-CODE        
              ELSE                                                      
                 MOVE PROGRAM-NAME      TO ABEND-PROGRAM                
                 MOVE '8170'            TO ACTIVE-PARAGRAPH             
                 MOVE 'UPDATE'          TO ABEND-FUNCTION               
                 MOVE 'CSS_PNDNG_BNK_DRFT' TO TABLE-1                   
                 MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1              
CBSI             MOVE 'DRAFT_DATE'      TO TABLE-ELEMENT-2              
                 MOVE PB-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1            
CBSI             MOVE PB-DRAFT-DATE     TO HOSTVAR-ELEMENT-2            
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
       8170-EXIT.                                                       
           EXIT.                                                        
      *                                                                 15800000
      ******************************************************************15810000
      * 8180-UPDATE-PEND                                               *15820000
      ******************************************************************15830000
      *                                                                 15840000
       8180-UPDATE-PEND.                                                
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_PNDNG_BNK_DRFT                                
               SET    DRAFT_AMT          = :PB-DRAFT-AMT,               
                      DRAFT_DATE         = CAST(SYSDATETIMEOFFSET() 
           AS DATE),                
                      TRANSACTION_CD     = :PB-TRANSACTION-CD,          
23549                 CODE_SOURCE_ID     = :PB-CODE-SOURCE-ID           
               WHERE  ACCOUNT_NO         = :PB-ACCOUNT-NO               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     15870000
MFA-TR*        UPDATE CSS_PNDNG_BNK_DRFT                                15880000
MFA-TR*        SET    DRAFT_AMT          = :PB-DRAFT-AMT,               15890000
MFA-TR*               DRAFT_DATE         = CURRENT DATE,                15900000
MFA-TR*               TRANSACTION_CD     = :PB-TRANSACTION-CD,          15910000
MFA-TR*               CODE_SOURCE_ID     = :PB-CODE-SOURCE-ID                   
MFA-TR*        WHERE  ACCOUNT_NO         = :PB-ACCOUNT-NO               15920000
MFA-TR*    END-EXEC.                                                    15930000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8180'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_PNDNG_BNK_DRFT' TO TABLE-1                      
C29529        MOVE PB-DRAFT-AMT         TO WS-DRAFT-AMT-NUMERIC         
C29529        MOVE PB-TRANSACTION-CD    TO WS-TRAN-CD-NUMERIC           
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE PB-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8180-EXIT.                                                       
           EXIT.                                                        
C29529*                                                                 14180000
C29529******************************************************************14190000
C29529* 8190-UPDATE-BILL-COPIES                                        *14200000
C29529******************************************************************14210000
C29529*                                                                 14220000
C29529 8190-UPDATE-BILL-COPIES.                                         
C29529                                                                  
C29529     EXEC SQL                                                     
C29529         UPDATE CSS_ACCOUNT                                       
C29529         SET NO_BILL_COPIES     = :AT-NO-BILL-COPIES              
C29529         WHERE  ACCOUNT_NO      = :AT-ACCOUNT-NO                  
A01679          AND CODE_ACCT_STAT NOT IN ('P')                         
C29529     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29529                                                                  
C29529     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C29529                                                                  
C29529     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
C29529        NEXT SENTENCE                                             
C29529     ELSE                                                         
C29529        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
C29529        MOVE '8190'               TO ACTIVE-PARAGRAPH             
C29529        MOVE 'UPDATE'             TO ABEND-FUNCTION               
C29529        MOVE 'CSS_ACCOUNT'        TO TABLE-1                      
C29529        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
C29529        MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
C29529        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C29529        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C29529     END-IF.                                                      
C29529                                                                  
C29529 8190-EXIT.                                                       
C29529     EXIT.                                                        
      *                                                                 16490000
      ******************************************************************16500000
      * 8200-DELETE-PEND                                               *16510000
T16043* DELETE PENDING DRAFT -PRENOTE                                   23230000
      ******************************************************************16520000
      *                                                                 16530000
       8200-DELETE-PEND.                                                
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_PNDNG_BNK_DRFT                           
               WHERE ACCOUNT_NO = :PB-ACCOUNT-NO                        
T16043         AND TRANSACTION_CD = 28                                  
C29529         AND PYMT_TRANS_TS  = CIS.CHAR2TIMESTAMP(:PB-PYMT-TRANS-TS
              )                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     16560000
MFA-TR*        DELETE FROM CSS_PNDNG_BNK_DRFT                           16570000
MFA-TR*        WHERE ACCOUNT_NO = :PB-ACCOUNT-NO                        16580000
MFA-TR*        AND TRANSACTION_CD = 28                                  23310000
MFA-TR*        AND PYMT_TRANS_TS  = :PB-PYMT-TRANS-TS                           
MFA-TR*    END-EXEC.                                                    16590000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C36298        MOVE 'Y' TO WS-DELETED-PRENOTE                            
           ELSE                                                         
C29529        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
C29529           MOVE ZEROES            TO WS-ACTIVE-RETURN-CODE        
C29529        ELSE                                                      
                 MOVE PROGRAM-NAME      TO ABEND-PROGRAM                
                 MOVE '8200'            TO ACTIVE-PARAGRAPH             
                 MOVE 'DELETE'          TO ABEND-FUNCTION               
                 MOVE 'CSS_PNDNG_BNK_DRFT' TO TABLE-1                   
                 MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1              
                 MOVE PB-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1            
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              END-IF                                                    
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T16043******************************************************************23510000
T16043* 8210-DELETE-PEND                                               *23520000
T16043* DELETE PENDING DRAFT - CHECKING OR SAVING                     * 23530000
      ******************************************************************23540000
T16043*                                                                 23550000
T16043 8210-DELETE-PEND.                                                
T16043                                                                  
T16043     EXEC SQL                                                     
T16043         DELETE FROM CSS_PNDNG_BNK_DRFT                           
T16043         WHERE ACCOUNT_NO = :PB-ACCOUNT-NO                        
C29529         AND PYMT_TRANS_TS  = CIS.CHAR2TIMESTAMP(:PB-PYMT-TRANS-TS
              )                   
T16043         AND TRANSACTION_CD IN (27, 37)                           
T16043     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     23580000
MFA-TR*        DELETE FROM CSS_PNDNG_BNK_DRFT                           23590000
MFA-TR*        WHERE ACCOUNT_NO = :PB-ACCOUNT-NO                        23600000
MFA-TR*        AND PYMT_TRANS_TS  = :PB-PYMT-TRANS-TS                           
MFA-TR*        AND TRANSACTION_CD IN (27, 37)                           23610000
MFA-TR*    END-EXEC.                                                    23620000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T16043                                                                  
T16043     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T16043                                                                  
T16043     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
T16043        NEXT SENTENCE                                             
T16043     ELSE                                                         
T16043        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
T16043        MOVE '8210'               TO ACTIVE-PARAGRAPH             
T16043        MOVE 'DELETE'             TO ABEND-FUNCTION               
T16043        MOVE 'CSS_PNDNG_BNK_DRFT' TO TABLE-1                      
T16043        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
T16043        MOVE PB-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
T16043        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T16043        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T16043     END-IF.                                                      
                                                                        
T16043 8210-EXIT.                                                       
T16043     EXIT.                                                        
      *                                                                         
C29529******************************************************************23510000
C29529* 8220-DELETE-PNDNG-DRFT                                         *23520000
C29529* DELETE PENDING EDRAFT OR BANKDRAFT                            * 23530000
C29529******************************************************************23540000
C29529*                                                                 23550000
C29529 8220-DELETE-PNDNG-DRFT.                                          
C29529                                                                  
C29529     EXEC SQL                                                     
C29529         DELETE FROM CSS_PNDNG_BNK_DRFT                           
C29529         WHERE ACCOUNT_NO = :PB-ACCOUNT-NO                        
C29529         AND CODE_SOURCE_ID IN ('I','S')                          
C29529     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29529                                                                  
C29529     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C29529                                                                  
C29529     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C29529        NEXT SENTENCE                                             
C29529     ELSE                                                         
C29529        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
C29529           MOVE ZEROES            TO WS-ACTIVE-RETURN-CODE        
C29529        ELSE                                                      
C29529           MOVE PROGRAM-NAME      TO ABEND-PROGRAM                
C29529           MOVE '8220'            TO ACTIVE-PARAGRAPH             
C29529           MOVE 'DELETE'          TO ABEND-FUNCTION               
C29529           MOVE 'CSS_PNDNG_BNK_DRFT' TO TABLE-1                   
C29529           MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1              
C29529           MOVE PB-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1            
C29529           PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
C29529           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
C29529        END-IF                                                    
C29529     END-IF.                                                      
C29529                                                                  
C29529 8220-EXIT.                                                       
C29529     EXIT.                                                        
      *                                                                 14480000
C29533*****************************************************************         
C29533* 8230-DELETE-ATTRIBUTES.                                       *         
C29533*  DELETE SPECIFIED ACCT ATTRIBUTE ROWS WHEN ACCOUNT IS SET UP  *         
C29533*    ON E-PAY OR E-DRAFT (RESETS ACCT TO ATTRIBUTE DEFAULTS)    *         
C29533*****************************************************************         
      *                                                                 14480000
C29533 8230-DELETE-ATTRIBUTES.                                          
                                                                        
C29533     EXEC SQL                                                     
C29533         DELETE FROM CSS_ACCT_ATTRIBUTE                           
C29533         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
C29533         AND ATTRIBUTE_DESC IN ('EMAIL_BILLNOTIFY',               
C29533                               'EMAIL_PAPERONLY')                 
C29533     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C29533     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
C29533     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C29533        NEXT SENTENCE                                             
C29533     ELSE                                                         
C29533        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
C29533           MOVE ZEROES            TO WS-ACTIVE-RETURN-CODE        
C29533        ELSE                                                      
C29533           MOVE PROGRAM-NAME      TO ABEND-PROGRAM                
C29533           MOVE '8230'            TO ACTIVE-PARAGRAPH             
C29533           MOVE 'DELETE'          TO ABEND-FUNCTION               
C29533           MOVE 'CSS_ACCT_ATTRIBUTE' TO TABLE-1                   
C29533           MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1              
C29533           MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1            
C29533           PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
C29533           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
C29533        END-IF                                                    
C29533     END-IF.                                                      
                                                                        
C29533 8230-EXIT.                                                       
C29533     EXIT.                                                        
      *                                                                         
C34097******************************************************************02640000
C34097* 8900-SEND-DONE                                                 *02650000
C34097******************************************************************02640000
C34097*                                                                         
C34097 8900-SEND-DONE.                                                  
C34097                                                                  
C34097     EXEC SQL                                                     
C34097         OPEN C1                                                  
C34097     END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
C34097                                                                  
C34097 8900-EXIT.                                                       
C34097     EXIT.                                                        
C34097*                                                                         
C34097******************************************************************02640000
C34097* 9000-SEND-ERROR RESULT                                         *02650000
C34097******************************************************************02640000
C34097*                                                                         
C34097 9000-SEND-ERROR-RESULT.                                          
C34097*                                                                         
C34097     MOVE 'N'                   TO SEND-DONE-SW.                  
C34097     MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE                  
C34097                                   ABEND-SQLCODE.                 
C34097     MOVE SQLERRMC              TO ABEND-SQLERRMC.                
C34097*                                                                         
C34097     EXEC SQL                                                     
C34097         ROLLBACK                                                 
C34097     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C34097*                                                                         
C34097     IF SQLCODE = 0                                               
C34097        CONTINUE                                                  
C34097     ELSE                                                         
C34097        MOVE 'ROLLBACK'         TO ABEND-FUNCTION                 
C34097     END-IF.                                                      
C34097*                                                                         
C34097 9000-EXIT.                                                       
C34097     EXIT.                                                        
      *                                                                         
      ******************************************************************16790000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     16800000
      * 9900-SQL-ERROR-ROUTINE                                                  
      * 9975-ABEND-CONTROL-TRANSFER                                             
      ******************************************************************16810000
      *                                                                         
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
C34097*                                                                         
C34097******************************************************************        
C34097*   9999-END-PROGRAM                                             *        
C34097******************************************************************        
C34097*                                                                         
C34097 9999-END-PROGRAM.                                                
C34097                                                                  
C34097     IF CTR-ROWS < 1                                              
C34097******************************************************************        
C34097*         PROGRAMMER LOGIC ERROR - SHOULD ALWAYS SEND A ROW!     *        
C34097******************************************************************        
C34097        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
C34097        MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
C34097        MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
C34097        MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
C34097        MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
C34097        MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
C34097        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C34097        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C34097     ELSE                                                         
C34097        PERFORM 8900-SEND-DONE THRU 8900-EXIT                     
C34097     END-IF.                                                      
C34097                                                                  
C34097     
MSQ016        GOBACK.                                                    
C34097                                                                  
C34097 9999-EXIT.                                                       
C34097     EXIT.                                                        
C34097                                                                  
C34097******************************************************************16860000
C34097*       END PROGRAM COPYLIB                                      *16870000
C34097******************************************************************16880000
