       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02241.                                         
COB303 DATE-WRITTEN.                                                    
COB303            NOVEMBER 08,1994.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S241                                           *        
      *  PROGRAM:       S241                                           *        
      *  CALLING SP:    PA_CUSTMAINTGET                               *         
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *        
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES DATA FROM CSS_ACCOUNT FOR              *        
      *  MAINTENANCE PURPOSE.                                          *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  11/08/94    RC       RPC ORIGINALLY CREATED.                  *        
CBSI  *  11/19/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *              MADRAS   ABEND PARAMETERS.                        *        
T21110*  12/08/99    CBSI     SELECT LAST-UPDATE-TS FROM CSS_ACCOUNT   *        
T21110*              MADRAS   AND ADD IT TO THE RESULT SET             *        
T21370*  01/04/2000  CBSI     WHEN AR-XFER-IND ON AT IS SPACES MOVE    *        
T21370*              MADRAS   SPACES TO RS-AR-XFER-IND INSTEAD OF 'X'  *        
REARCH*  11/02/05    CVNS     RPC TO COBOL SP CONVERSION               *        
REARCH*              CHENNAI                                           *        
A02964*  17/02/11    SP95538  RETRIEVE ACCOUNT STATUS AND CODES DATA.  *        
I01168*  11/06/11    MS93554  RETRIEVE ACCOUNT CREATE DATE AND         *        
      *                       ACCOUNT FINALED DATE.                    *        
P01137*  06/14/16    VK7L032  ADDED THE COLUMNS BILL_CYCLE,            *        
      *                       REV_MTH_LST_NRML IN THE RESULT SET.      *        
P01137*  09/16/16    MS7M727  ADDED THE COLUMNS CREDIT_GROUP IN        *        
      *                       THE RESULT_SET                           *        
P01137*  09/21/16    MS7M727  ADDED THE COLUMNS PREMISE_NO,CUSTOMER_NO *        
      *                       LOCAL_OFFICE,REV_DISTRICT_CODE IN        *        
      *                       RESULT SET                               *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02241'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02241 STARTS HERE'.                  
                                                                        
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
P01137******************************************************************        
P01137*    CSS_PREMISE PR                                                       
P01137******************************************************************        
P01137     EXEC SQL                                                             
P01137        INCLUDE TBPREM                                                    
P01137     END-EXEC.                                                            
P01137                                                                  
P01137                                                                  
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
REARCH*    COPY SYGWCOB.                                                        
REARCH*    COPY SYDBCOB.                                                        
REARCH*    COPY CWS00010.                                                       
           COPY CWS00027.                                                       
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CWSX0010                                                 
REARCH     END-EXEC.                                                            
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
REARCH*01  GW-LIB-MISC-FIELDS.                                                  
REARCH*    05  GWL-PROC                POINTER.                                 
REARCH*    05  GWL-INIT-HANDLE         POINTER.                                 
REARCH*    05  GWL-RC                  PIC S9(9) COMP.                          
REARCH*    05  GWL-STATUS-NR           PIC S9(9) COMP.                          
REARCH*    05  GWL-STATUS-DONE         PIC S9(9) COMP.                          
REARCH*    05  GWL-STATUS-COUNT        PIC S9(9) COMP.                          
REARCH*    05  GWL-STATUS-COMM         PIC S9(9) COMP.                          
REARCH*    05  GWL-STATUS-RETURN-CODE  PIC S9(9) COMP.                          
REARCH*    05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                          
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  GTT-NAME                PIC X(26)                        
REARCH                                      VALUE 'SESSION.CSR02241_R1'.
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN          PIC S9(04) COMP.                 
REARCH         49 GTT-ROW-CHAR         PIC X(1024).                     
REARCH     05  GTT-SQLCODE             PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
REARCH*01  PARM-FIELDS.                                                         
REARCH*    05  PARM-L                  PIC S9(9) COMP.                          
REARCH*    05  PARM-ID1                PIC S9(9) COMP VALUE 1.                  
REARCH*    05  PARM-ACCOUNT-NO         PIC X(13)  VALUE SPACES.                 
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME            PIC X(8)  VALUE 'CSR02241'.      
           05  WS-ACCOUNT-NO-CHR       PIC X(13) VALUE SPACES.          
           05  WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO-CHR            
                                       PIC 9(13).                       
           05  WS-ACCOUNT-NO           PIC S9(13) COMP-3 VALUE 0.       
           05  WS-AR-XFER-IND          PIC X(1)   VALUE SPACES.         
           05  WS-ACCT-XFER-TO-CHR     PIC X(13)  VALUE SPACES.         
           05  WS-ACCT-XFER-TO-NUM REDEFINES WS-ACCT-XFER-TO-CHR        
                                       PIC 9(13).                       
           05  WS-ACCT-XFER-TO         PIC S9(13) COMP-3 VALUE 0.       
           05  WS-ACCT-XFER-FROM-CHR   PIC X(13)  VALUE SPACES.         
           05  WS-ACCT-XFER-FROM-NUM REDEFINES WS-ACCT-XFER-FROM-CHR    
                                       PIC 9(13).                       
           05  WS-ACCT-XFER-FROM-LST   PIC S9(13) COMP-3 VALUE 0.       
           05  WS-TOTAL-AR-BALANCE     PIC S9(13)V99 COMP-3 VALUE 0.    
A02964     05  WS-CODE-ACCT-STAT       PIC X(01)  VALUE SPACES.         
           05  WS-DATE-BILL-DAY-00     PIC X(10)  VALUE SPACES.         
           05  WS-DATE-BILL-DAY-30     PIC X(10)  VALUE SPACES.         
           05  WS-DATE-BILL-DAY-60     PIC X(10)  VALUE SPACES.         
           05  WS-DATE-BILL-DAY-90     PIC X(10)  VALUE SPACES.         
           05  WS-NULL-IND             PIC S9(04) COMP VALUE 0.         
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-ACTIVE-CODE          PIC X(01) VALUE 'A'.             
                                                                        
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9)  COMP VALUE 0.         
           05  RS-AR-XFER-IND          PIC X(1)   VALUE SPACES.         
           05  RS-ACCT-XFER-TO         PIC X(13)  VALUE SPACES.         
           05  RS-ACCT-XFER-FROM-LST   PIC X(13)  VALUE SPACES.         
           05  RS-TOTAL-AR-BALANCE     PIC S9(13)V99 COMP-3 VALUE 0.    
A02964     05  RS-CODE-ACCT-STAT       PIC X(01)  VALUE SPACES.         
           05  RS-DATE-BILL-DAY-00     PIC X(08)  VALUE SPACES.         
           05  RS-DATE-BILL-DAY-30     PIC X(08)  VALUE SPACES.         
           05  RS-DATE-BILL-DAY-60     PIC X(08)  VALUE SPACES.         
           05  RS-DATE-BILL-DAY-90     PIC X(08)  VALUE SPACES.         
T21110     05  RS-AT-LAST-UPDATE-TS    PIC X(26)  VALUE SPACES.         
A02964     05  RS-CODES-DATA-PRESENT   PIC X(32)  VALUE SPACES.         
I01168     05  RS-ACCT-CREATE-DT       PIC X(26)  VALUE SPACES.         
I01168     05  RS-ACCT-FINALED-DT      PIC X(26)  VALUE SPACES.         
P01137     05  RS-BILL-CYCLE           PIC X(02)  VALUE SPACES.         
COB305     05 RS-REV-MTH-LST-NRML        PIC S9(6)V USAGE COMP-3 
COB305       VALUE 0.         
P01137     05  RS-CREDIT-GROUP         PIC X(01)  VALUE SPACES.         
P01137     05  RS-PREMISE-NO           PIC S9(10)V USAGE COMP-3         
P01137                                                 VALUE 0.         
P01137     05  RS-CUSTOMER-NO          PIC S9(10)V USAGE COMP-3         
P01137                                                 VALUE 0.         
P01137     05  RS-LOCAL-OFFICE         PIC X(3)   VALUE SPACES.         
P01137     05  RS-REV-DISTRICT-CD      PIC X(3)   VALUE SPACES.         
REARCH*                                                                         
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH                                                                  
REARCH     05  S-RETURN-CODE           PIC S9(9)       COMP             
REARCH                                                 VALUE 0.         
REARCH     05  S-AR-XFER-IND          PIC X(1)   VALUE SPACES.          
REARCH     05  S-ACCT-XFER-TO         PIC X(13)  VALUE SPACES.          
REARCH     05  S-ACCT-XFER-FROM-LST   PIC X(13)  VALUE SPACES.          
REARCH     05  S-TOTAL-AR-BALANCE     PIC S9(13)V99 COMP-3 VALUE 0.     
A02964     05  S-CODE-ACCT-STAT       PIC X(01)  VALUE SPACES.          
REARCH     05  S-DATE-BILL-DAY-00     PIC X(08)  VALUE SPACES.          
REARCH     05  S-DATE-BILL-DAY-30     PIC X(08)  VALUE SPACES.          
REARCH     05  S-DATE-BILL-DAY-60     PIC X(08)  VALUE SPACES.          
REARCH     05  S-DATE-BILL-DAY-90     PIC X(08)  VALUE SPACES.          
REARCH     05  S-AT-LAST-UPDATE-TS    PIC X(26)  VALUE SPACES.          
A02964     05  S-CODES-DATA-PRESENT   PIC X(32)  VALUE SPACES.          
I01168     05  S-ACCT-CREATE-DT       PIC X(26)  VALUE SPACES.          
I01168     05  S-ACCT-FINALED-DT      PIC X(26)  VALUE SPACES.          
P01137     05  S-BILL-CYCLE           PIC X(02)  VALUE SPACES.          
COB305     05 S-REV-MTH-LST-NRML        PIC S9(6)V USAGE COMP-3 VALUE 0.        
P01137     05  S-CREDIT-GROUP         PIC X(01)  VALUE SPACES.          
P01137     05  S-PREMISE-NO           PIC S9(10)V USAGE COMP-3          
P01137                                                VALUE 0.          
P01137     05  S-CUSTOMER-NO          PIC S9(10)V USAGE COMP-3          
P01137                                                VALUE 0.          
P01137     05  S-LOCAL-OFFICE         PIC X(3)   VALUE SPACES.          
P01137     05  S-REV-DISTRICT-CD      PIC X(3)   VALUE SPACES.          
REARCH*                                                                         
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
REARCH     10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
REARCH     10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
REARCH     10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
REARCH         49  S-HOST-VARIABLES-V  PIC X(255).                      
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-STATEMENT-V   PIC X(255).                      
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-DESCRIPTION-V PIC X(255).                      
                                                                        
                                                                        
REARCH*01  CNS-COLUMN-NAMES.                                                    
REARCH*    05  CNS-RETURN-CODE         PIC X(11) VALUE                          
REARCH*                                        'RETURN_CODE'.                   
REARCH*    05  CNS-AR-XFER-IND         PIC X(11) VALUE                          
REARCH*                                        'AR_XFER_IND'.                   
REARCH*    05  CNS-ACCT-XFER-TO        PIC X(12) VALUE                          
REARCH*                                        'ACCT_XFER_TO'.                  
REARCH*    05  CNS-ACCT-XFER-FROM-LST  PIC X(18) VALUE                          
REARCH*                                        'ACCT_XFER_FROM_LST'.            
REARCH*    05  CNS-TOTAL-AR-BALANCE    PIC X(16) VALUE                          
REARCH*                                        'TOTAL_AR_BALANCE'.              
REARCH*    05  CNS-DATE-LAST-ACTION    PIC X(16) VALUE                          
REARCH*                                        'DATE_LAST_ACTION'.              
REARCH*    05  CNS-DATE-BILL-DAY-00    PIC X(16) VALUE                          
REARCH*                                        'DATE_BILL_DAY_00'.              
REARCH*    05  CNS-DATE-BILL-DAY-30    PIC X(16) VALUE                          
REARCH*                                        'DATE_BILL_DAY_30'.              
REARCH*    05  CNS-DATE-BILL-DAY-60    PIC X(16) VALUE                          
REARCH*                                        'DATE_BILL_DAY_60'.              
REARCH*    05  CNS-DATE-BILL-DAY-90    PIC X(16) VALUE                          
REARCH*                                        'DATE_BILL_DAY_90'.              
REARCH*    05  CNS-AT-LAST-UPDATE-TS   PIC X(17) VALUE                          
REARCH*                                        'AT_LAST_UPDATE_TS'.             
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
REARCH LINKAGE SECTION.                                                 
REARCH 01  PARM-ACCOUNT-NO             PIC X(13)  VALUE SPACES.         
                                                                        
REARCH*EJECT                                                                    
REARCH PROCEDURE DIVISION USING PARM-ACCOUNT-NO.                        
                                                                        
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
REARCH*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.             
REARCH*                                                                         
REARCH*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,             
REARCH*                          SNA-CONNECTION-NAME, SNA-SUBC.                 
REARCH*                                                                         
REARCH*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                              
REARCH*                                                                         
REARCH*    IF GWL-RC NOT = TDS-PARM-PRESENT                                     
REARCH*       MOVE PROGRAM-NAME    TO ABEND-PROGRAM                             
REARCH*       MOVE '0100'          TO ACTIVE-PARAGRAPH                          
REARCH*       MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION              
REARCH*       MOVE 'CICS TRANSACTION'   TO TABLE-1                              
REARCH*       MOVE GWL-RC               TO WS-ACTIVE-RETURN-CODE                
REARCH*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
REARCH*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
REARCH*    END-IF.                                                              
REARCH     INITIALIZE TDS-RETURN-FIELDS.                                
REARCH     EXEC SQL                                                     
REARCH        DECLARE C1 CURSOR  FOR                         
REARCH        SELECT                                                    
REARCH             :S-RETURN-CODE                 AS RETURN_CODE        
REARCH            ,LTRIM(RTRIM(:S-AR-XFER-IND))          AS AR_XFER_IND        
REARCH            ,LTRIM(RTRIM(:S-ACCT-XFER-TO))         AS ACCT_XFER_TO       
REARCH            ,LTRIM(RTRIM(:S-ACCT-XFER-FROM-LST))   AS 
           ACCT_XFER_FROM_LST 
REARCH            ,:S-TOTAL-AR-BALANCE            AS TOTAL_AR_BALANCE   
A02964            ,:S-CODE-ACCT-STAT              AS CODE_ACCT_STAT     
REARCH            ,:S-DATE-BILL-DAY-00            AS DATE_BILL_DAY_00   
REARCH            ,:S-DATE-BILL-DAY-30            AS DATE_BILL_DAY_30   
REARCH            ,:S-DATE-BILL-DAY-60            AS DATE_BILL_DAY_60   
REARCH            ,:S-DATE-BILL-DAY-90            AS DATE_BILL_DAY_90   
REARCH            ,:S-AT-LAST-UPDATE-TS           AS AT_LAST_UPDATE_TS  
A02964            ,:S-CODES-DATA-PRESENT          AS 
           [CPDES-DATA-PRESENT] 
I01168            ,:S-ACCT-CREATE-DT              AS ACCT_CREATE_DT     
I01168            ,:S-ACCT-FINALED-DT             AS ACCT_FINALED_DT    
I01168            ,:S-BILL-CYCLE                  AS BILL_CYCLE         
I01168            ,:S-REV-MTH-LST-NRML            AS REV_MTH_LST_NRML   
P01137            ,:S-CREDIT-GROUP                AS CREDIT_GROUP       
P01137            ,:S-PREMISE-NO                  AS PREMISE_NO         
P01137            ,:S-CUSTOMER-NO                 AS CUSTOMER_NO        
P01137            ,:S-LOCAL-OFFICE                AS LOCAL_OFFICE       
P01137            ,:S-REV-DISTRICT-CD             AS REV_DISTRICT_CD    
REARCH        FROM                                                      
REARCH            CIS.SYSDUMMY1                                      
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ026
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*       SELECT                                                            
MFA-TR*            :S-RETURN-CODE                 AS RETURN_CODE                
MFA-TR*           ,STRIP(:S-AR-XFER-IND)          AS AR_XFER_IND                
MFA-TR*           ,STRIP(:S-ACCT-XFER-TO)         AS ACCT_XFER_TO               
MFA-TR*           ,STRIP(:S-ACCT-XFER-FROM-LST)   AS ACCT_XFER_FROM_LST         
MFA-TR*           ,:S-TOTAL-AR-BALANCE            AS TOTAL_AR_BALANCE           
MFA-TR*           ,:S-CODE-ACCT-STAT              AS CODE_ACCT_STAT             
MFA-TR*           ,:S-DATE-BILL-DAY-00            AS DATE_BILL_DAY_00           
MFA-TR*           ,:S-DATE-BILL-DAY-30            AS DATE_BILL_DAY_30           
MFA-TR*           ,:S-DATE-BILL-DAY-60            AS DATE_BILL_DAY_60           
MFA-TR*           ,:S-DATE-BILL-DAY-90            AS DATE_BILL_DAY_90           
MFA-TR*           ,:S-AT-LAST-UPDATE-TS           AS AT_LAST_UPDATE_TS          
MFA-TR*           ,:S-CODES-DATA-PRESENT          AS CPDES-DATA-PRESENT         
MFA-TR*           ,:S-ACCT-CREATE-DT              AS ACCT_CREATE_DT             
MFA-TR*           ,:S-ACCT-FINALED-DT             AS ACCT_FINALED_DT            
MFA-TR*           ,:S-BILL-CYCLE                  AS BILL_CYCLE                 
MFA-TR*           ,:S-REV-MTH-LST-NRML            AS REV_MTH_LST_NRML           
MFA-TR*           ,:S-CREDIT-GROUP                AS CREDIT_GROUP               
MFA-TR*           ,:S-PREMISE-NO                  AS PREMISE_NO                 
MFA-TR*           ,:S-CUSTOMER-NO                 AS CUSTOMER_NO                
MFA-TR*           ,:S-LOCAL-OFFICE                AS LOCAL_OFFICE               
MFA-TR*           ,:S-REV-DISTRICT-CD             AS REV_DISTRICT_CD            
MFA-TR*       FROM                                                              
MFA-TR*           SYSIBM.SYSDUMMY1                                              
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
REARCH*    PERFORM 1100-RECEIVE-PARMS     THRU 1100-EXIT.                       
           MOVE PARM-ACCOUNT-NO           TO WS-ACCOUNT-NO-CHR.         
           MOVE WS-ACCOUNT-NO-NUM         TO WS-ACCOUNT-NO.             
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH*1100-RECEIVE-PARMS.                                                      
REARCH*    MOVE 1                          TO PARM-ID1.                         
REARCH*    MOVE LENGTH OF PARM-ACCOUNT-NO  TO MAX-LENGTH-PARM.                  
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-ACCOUNT-NO,                               
REARCH*                          TDSCHAR,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                         
REARCH*1100-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                   TO ACTIVE-PARAGRAPH.           
REARCH*    PERFORM 2100-DESCRIBE-RESULT  THRU 2100-EXIT.                        
           PERFORM 2200-BUILD-RESULT     THRU 2200-EXIT.                
REARCH     PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT.               
REARCH     ADD +1                        TO   CTR-ROWS.                 
REARCH*    PERFORM 8100-SEND-RESULT      THRU 8100-EXIT.                        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH*                                                                         
REARCH******************************************************************        
REARCH*2000A-MOVE-RESULT.                                              *        
REARCH******************************************************************        
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE RS-RETURN-CODE         TO S-RETURN-CODE.                
REARCH     MOVE RS-AR-XFER-IND         TO S-AR-XFER-IND.                
REARCH     MOVE RS-ACCT-XFER-TO        TO S-ACCT-XFER-TO.               
REARCH     MOVE RS-ACCT-XFER-FROM-LST  TO S-ACCT-XFER-FROM-LST.         
REARCH     MOVE RS-TOTAL-AR-BALANCE    TO S-TOTAL-AR-BALANCE.           
A02964     MOVE RS-CODE-ACCT-STAT      TO S-CODE-ACCT-STAT.             
REARCH     MOVE RS-DATE-BILL-DAY-00    TO S-DATE-BILL-DAY-00.           
REARCH     MOVE RS-DATE-BILL-DAY-30    TO S-DATE-BILL-DAY-30.           
REARCH     MOVE RS-DATE-BILL-DAY-60    TO S-DATE-BILL-DAY-60.           
REARCH     MOVE RS-DATE-BILL-DAY-90    TO S-DATE-BILL-DAY-90.           
REARCH     MOVE RS-AT-LAST-UPDATE-TS   TO S-AT-LAST-UPDATE-TS.          
A02964     MOVE RS-CODES-DATA-PRESENT  TO S-CODES-DATA-PRESENT.         
I01168     MOVE RS-ACCT-CREATE-DT      TO S-ACCT-CREATE-DT.             
I01168     MOVE RS-ACCT-FINALED-DT     TO S-ACCT-FINALED-DT.            
P01137     MOVE RS-BILL-CYCLE          TO S-BILL-CYCLE.                 
P01137     MOVE RS-REV-MTH-LST-NRML    TO S-REV-MTH-LST-NRML.           
P01137     MOVE RS-CREDIT-GROUP        TO S-CREDIT-GROUP.               
P01137     MOVE RS-PREMISE-NO          TO S-PREMISE-NO.                 
P01137     MOVE RS-CUSTOMER-NO         TO S-CUSTOMER-NO.                
P01137     MOVE RS-LOCAL-OFFICE        TO S-LOCAL-OFFICE.               
P01137     MOVE RS-REV-DISTRICT-CD     TO S-REV-DISTRICT-CD.            
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
      ******************************************************************        
      * 2100-DESCRIBE-RESULT                                           *        
      ******************************************************************        
                                                                        
REARCH*2100-DESCRIBE-RESULT.                                                    
REARCH*    MOVE '2100'                        TO ACTIVE-PARAGRAPH.              
REARCH*                                                                         
REARCH*    MOVE 1                             TO CTR-COLUMN.                    
REARCH*    MOVE TDSINT4                       TO DB-HOST-TYPE.                  
REARCH*    MOVE TDSINT4                       TO DB-CLIENT-TYPE.                
REARCH*    MOVE LENGTH OF RS-RETURN-CODE      TO WRKLEN1.                       
REARCH*    MOVE LENGTH OF CNS-RETURN-CODE     TO WRKLEN2.                       
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-RETURN-CODE,                                
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-RETURN-CODE,                               
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD 1        TO CTR-COLUMN.                                          
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
REARCH*    MOVE LENGTH OF RS-AR-XFER-IND   TO WRKLEN1.                          
REARCH*    MOVE LENGTH OF CNS-AR-XFER-IND  TO WRKLEN2.                          
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-AR-XFER-IND,                                
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-AR-XFER-IND,                               
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*                                                                         
REARCH*    ADD 1                           TO CTR-COLUMN.                       
REARCH*    MOVE TDSCHAR                    TO DB-HOST-TYPE.                     
REARCH*    MOVE TDSCHAR                    TO DB-CLIENT-TYPE.                   
REARCH*    MOVE LENGTH OF RS-ACCT-XFER-TO  TO WRKLEN1.                          
REARCH*    MOVE LENGTH OF CNS-ACCT-XFER-TO TO WRKLEN2.                          
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-ACCT-XFER-TO,                               
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-ACCT-XFER-TO,                              
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD 1                                 TO CTR-COLUMN.                 
REARCH*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
REARCH*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
REARCH*    MOVE LENGTH OF RS-ACCT-XFER-FROM-LST  TO WRKLEN1.                    
REARCH*    MOVE LENGTH OF CNS-ACCT-XFER-FROM-LST TO WRKLEN2.                    
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-ACCT-XFER-FROM-LST,                         
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-ACCT-XFER-FROM-LST,                        
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD 1                               TO CTR-COLUMN.                   
REARCH*    MOVE TDS-PACKED-DECIMAL             TO DB-HOST-TYPE.                 
REARCH*    MOVE TDSMONEY                       TO  DB-CLIENT-TYPE.              
REARCH*    MOVE LENGTH OF RS-TOTAL-AR-BALANCE  TO WRKLEN1.                      
REARCH*    MOVE LENGTH OF CNS-TOTAL-AR-BALANCE TO WRKLEN2.                      
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-TOTAL-AR-BALANCE,                           
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-TOTAL-AR-BALANCE,                          
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    MOVE +2 TO WRKLEN2.                                                  
REARCH*    CALL 'TDSETBCD' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          TDS-OBJECT-COL,                                
REARCH*                          CTR-COLUMN,                                    
REARCH*                          WRKLEN1,                                       
REARCH*                          WRKLEN2.                                       
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD 1                               TO CTR-COLUMN.                   
REARCH*    MOVE TDSCHAR                        TO DB-HOST-TYPE.                 
REARCH*    MOVE TDSCHAR                        TO DB-CLIENT-TYPE.               
REARCH*    MOVE LENGTH OF RS-DATE-LAST-ACTION  TO WRKLEN1.                      
REARCH*    MOVE LENGTH OF CNS-DATE-LAST-ACTION TO WRKLEN2.                      
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-DATE-LAST-ACTION,                           
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-DATE-LAST-ACTION,                          
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD 1                               TO CTR-COLUMN.                   
REARCH*    MOVE TDSCHAR                        TO DB-HOST-TYPE.                 
REARCH*    MOVE TDSCHAR                        TO DB-CLIENT-TYPE.               
REARCH*    MOVE LENGTH OF RS-DATE-BILL-DAY-00  TO WRKLEN1.                      
REARCH*    MOVE LENGTH OF CNS-DATE-BILL-DAY-00 TO WRKLEN2.                      
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-DATE-BILL-DAY-00,                           
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-DATE-BILL-DAY-00,                          
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD 1                               TO CTR-COLUMN.                   
REARCH*    MOVE TDSCHAR                        TO DB-HOST-TYPE.                 
REARCH*    MOVE TDSCHAR                        TO DB-CLIENT-TYPE.               
REARCH*    MOVE LENGTH OF RS-DATE-BILL-DAY-30  TO WRKLEN1.                      
REARCH*    MOVE LENGTH OF CNS-DATE-BILL-DAY-30 TO WRKLEN2.                      
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-DATE-BILL-DAY-30,                           
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-DATE-BILL-DAY-30,                          
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD 1                               TO CTR-COLUMN.                   
REARCH*    MOVE TDSCHAR                        TO DB-HOST-TYPE.                 
REARCH*    MOVE TDSCHAR                        TO DB-CLIENT-TYPE.               
REARCH*    MOVE LENGTH OF RS-DATE-BILL-DAY-60  TO WRKLEN1.                      
REARCH*    MOVE LENGTH OF CNS-DATE-BILL-DAY-60 TO WRKLEN2.                      
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-DATE-BILL-DAY-60,                           
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-DATE-BILL-DAY-60,                          
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD 1                               TO CTR-COLUMN.                   
REARCH*    MOVE TDSCHAR                        TO DB-HOST-TYPE.                 
REARCH*    MOVE TDSCHAR                        TO DB-CLIENT-TYPE.               
REARCH*    MOVE LENGTH OF RS-DATE-BILL-DAY-90  TO WRKLEN1.                      
REARCH*    MOVE LENGTH OF CNS-DATE-BILL-DAY-90 TO WRKLEN2.                      
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-DATE-BILL-DAY-90,                           
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-DATE-BILL-DAY-90,                          
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1       TO CTR-COLUMN.                                          
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
REARCH*    MOVE LENGTH OF RS-AT-LAST-UPDATE-TS TO WRKLEN1.                      
REARCH*    MOVE LENGTH OF CNS-AT-LAST-UPDATE-TS                                 
REARCH*                                        TO WRKLEN2.                      
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-AT-LAST-UPDATE-TS,                          
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-AT-LAST-UPDATE-TS,                         
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*2100-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      ******************************************************************        
       2200-BUILD-RESULT.                                               
                                                                        
           PERFORM 7000-SELECT-ACCOUNT-DETAILS   THRU 7000-EXIT.        
           MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE.          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P01137                                                                  
P01137        MOVE AT-PREMISE-NO            TO PR-PREMISE-NO            
P01137        PERFORM 7100-SELECT-PREMISE-DETAILS                       
P01137                                           THRU 7100-EXIT         
P01137        MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
T21370*       IF WS-AR-XFER-IND EQUAL SPACES                                    
T21370*          MOVE 'X'                   TO RS-AR-XFER-IND                   
T21370*       ELSE                                                              
                 MOVE WS-AR-XFER-IND        TO RS-AR-XFER-IND           
T21370*       END-IF                                                            
P01137                                                                  
A02964        MOVE AT-CODES-DATA-PRESENT    TO RS-CODES-DATA-PRESENT    
T21110        MOVE AT-LAST-UPDATE-TS        TO RS-AT-LAST-UPDATE-TS     
              MOVE WS-ACCT-XFER-TO          TO WS-ACCT-XFER-TO-NUM      
              MOVE WS-ACCT-XFER-TO-CHR      TO RS-ACCT-XFER-TO          
              MOVE WS-ACCT-XFER-FROM-LST    TO WS-ACCT-XFER-FROM-NUM    
              MOVE WS-ACCT-XFER-FROM-CHR    TO RS-ACCT-XFER-FROM-LST    
              MOVE WS-TOTAL-AR-BALANCE      TO RS-TOTAL-AR-BALANCE      
      *---------------------------------------------------------------*         
      * CHANGE FORMAT OF DATE FIELDS FROM CCYY-MM-DD TO MMDDCCYY      *         
      *---------------------------------------------------------------*         
A02964        MOVE WS-CODE-ACCT-STAT        TO RS-CODE-ACCT-STAT        
I01168        MOVE AT-ACCT-CREATE-DT        TO RS-ACCT-CREATE-DT        
I01168        MOVE AT-ACCT-FINALED-DT       TO RS-ACCT-FINALED-DT       
P01137        MOVE AT-BILL-CYCLE            TO RS-BILL-CYCLE            
P01137        MOVE AT-REV-MTH-LST-NRML      TO RS-REV-MTH-LST-NRML      
P01137        MOVE AT-CREDIT-GROUP          TO RS-CREDIT-GROUP          
P01137        MOVE AT-PREMISE-NO            TO RS-PREMISE-NO            
P01137        MOVE AT-CUSTOMER-NO           TO RS-CUSTOMER-NO           
P01137        MOVE PR-LOCAL-OFFICE          TO RS-LOCAL-OFFICE          
P01137        MOVE PR-REV-DISTRICT-CD       TO RS-REV-DISTRICT-CD       
                                                                        
              MOVE WS-DATE-BILL-DAY-00(6:2) TO RS-DATE-BILL-DAY-00(1:2) 
              MOVE WS-DATE-BILL-DAY-00(9:2) TO RS-DATE-BILL-DAY-00(3:2) 
              MOVE WS-DATE-BILL-DAY-00(1:4) TO RS-DATE-BILL-DAY-00(5:4) 
                                                                        
              MOVE WS-DATE-BILL-DAY-30(6:2) TO RS-DATE-BILL-DAY-30(1:2) 
              MOVE WS-DATE-BILL-DAY-30(9:2) TO RS-DATE-BILL-DAY-30(3:2) 
              MOVE WS-DATE-BILL-DAY-30(1:4) TO RS-DATE-BILL-DAY-30(5:4) 
                                                                        
              MOVE WS-DATE-BILL-DAY-60(6:2) TO RS-DATE-BILL-DAY-60(1:2) 
              MOVE WS-DATE-BILL-DAY-60(9:2) TO RS-DATE-BILL-DAY-60(3:2) 
              MOVE WS-DATE-BILL-DAY-60(1:4) TO RS-DATE-BILL-DAY-60(5:4) 
                                                                        
              MOVE WS-DATE-BILL-DAY-90(6:2) TO RS-DATE-BILL-DAY-90(1:2) 
              MOVE WS-DATE-BILL-DAY-90(9:2) TO RS-DATE-BILL-DAY-90(3:2) 
              MOVE WS-DATE-BILL-DAY-90(1:4) TO RS-DATE-BILL-DAY-90(5:4) 
           ELSE                                                         
              MOVE SPACES                   TO RS-ACCT-XFER-TO          
              MOVE SPACES                   TO RS-ACCT-XFER-FROM-LST    
              MOVE ZEROS                    TO RS-TOTAL-AR-BALANCE      
              MOVE SPACES                   TO RS-DATE-BILL-DAY-00      
              MOVE SPACES                   TO RS-DATE-BILL-DAY-30      
              MOVE SPACES                   TO RS-DATE-BILL-DAY-60      
              MOVE SPACES                   TO RS-DATE-BILL-DAY-90      
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7000-SELECT-ACCOUNT-DETAILS.                                   *        
      ******************************************************************        
       7000-SELECT-ACCOUNT-DETAILS.                                     
                                                                        
           EXEC SQL                                                     
              SELECT AR_XFER_IND,                                       
                     ACCT_XFER_TO,                                      
                     ACCT_XFER_FROM_LST,                                
                     TOTAL_AR_BALANCE,                                  
A02964               CODE_ACCT_STAT,                                    
                     DATE_BILL_DAY_00,                                  
                     DATE_BILL_DAY_30,                                  
                     DATE_BILL_DAY_60,                                  
                     DATE_BILL_DAY_90,                                  
T21110               REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,                        
A02964               CODES_DATA_PRESENT,                                
A01168               REPLACE(REPLACE(CONVERT(CHAR(26), ACCT_CREATE_DT
           , 121), ' ', '-'), ':', '.') ACCT_CREATE_DT,                        
A01168               REPLACE(REPLACE(CONVERT(CHAR(26), ACCT_FINALED_DT
           , 121), ' ', '-'), ':', '.') ACCT_FINALED_DT,                       
P01137               BILL_CYCLE,                                        
P01137               REV_MTH_LST_NRML,                                  
P01137               CREDIT_GROUP,                                      
P01137               PREMISE_NO,                                        
P01137               CUSTOMER_NO                                        
              INTO   :WS-AR-XFER-IND,                                   
                     :WS-ACCT-XFER-TO,                                  
                     :WS-ACCT-XFER-FROM-LST,                            
                     :WS-TOTAL-AR-BALANCE,                              
A02964               :WS-CODE-ACCT-STAT,                                
                     :WS-DATE-BILL-DAY-00 :WS-NULL-IND,                  
                     :WS-DATE-BILL-DAY-30 :WS-NULL-IND,                  
                     :WS-DATE-BILL-DAY-60 :WS-NULL-IND,                  
                     :WS-DATE-BILL-DAY-90 :WS-NULL-IND,                  
T21110               :AT-LAST-UPDATE-TS,                                
A02964               :AT-CODES-DATA-PRESENT,                            
A01168               :AT-ACCT-CREATE-DT :WS-NULL-IND,                    
A01168               :AT-ACCT-FINALED-DT :WS-NULL-IND,                   
P01137               :AT-BILL-CYCLE,                                    
P01137               :AT-REV-MTH-LST-NRML,                              
P01137               :AT-CREDIT-GROUP,                                  
P01137               :AT-PREMISE-NO,                                    
P01137               :AT-CUSTOMER-NO                                    
              FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                            
              WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                         
A02964                                                           
A02964                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AR_XFER_IND,                                               
MFA-TR*              ACCT_XFER_TO,                                              
MFA-TR*              ACCT_XFER_FROM_LST,                                        
MFA-TR*              TOTAL_AR_BALANCE,                                          
MFA-TR*              CODE_ACCT_STAT,                                            
MFA-TR*              DATE_BILL_DAY_00,                                          
MFA-TR*              DATE_BILL_DAY_30,                                          
MFA-TR*              DATE_BILL_DAY_60,                                          
MFA-TR*              DATE_BILL_DAY_90,                                          
MFA-TR*              LAST_UPDATE_TS,                                            
MFA-TR*              CODES_DATA_PRESENT,                                        
MFA-TR*              ACCT_CREATE_DT,                                            
MFA-TR*              ACCT_FINALED_DT,                                           
MFA-TR*              BILL_CYCLE,                                                
MFA-TR*              REV_MTH_LST_NRML,                                          
MFA-TR*              CREDIT_GROUP,                                              
MFA-TR*              PREMISE_NO,                                                
MFA-TR*              CUSTOMER_NO                                                
MFA-TR*       INTO   :WS-AR-XFER-IND,                                           
MFA-TR*              :WS-ACCT-XFER-TO,                                          
MFA-TR*              :WS-ACCT-XFER-FROM-LST,                                    
MFA-TR*              :WS-TOTAL-AR-BALANCE,                                      
MFA-TR*              :WS-CODE-ACCT-STAT,                                        
MFA-TR*              :WS-DATE-BILL-DAY-00:WS-NULL-IND,                          
MFA-TR*              :WS-DATE-BILL-DAY-30:WS-NULL-IND,                          
MFA-TR*              :WS-DATE-BILL-DAY-60:WS-NULL-IND,                          
MFA-TR*              :WS-DATE-BILL-DAY-90:WS-NULL-IND,                          
MFA-TR*              :AT-LAST-UPDATE-TS,                                        
MFA-TR*              :AT-CODES-DATA-PRESENT,                                    
MFA-TR*              :AT-ACCT-CREATE-DT:WS-NULL-IND,                            
MFA-TR*              :AT-ACCT-FINALED-DT:WS-NULL-IND,                           
MFA-TR*              :AT-BILL-CYCLE,                                            
MFA-TR*              :AT-REV-MTH-LST-NRML,                                      
MFA-TR*              :AT-CREDIT-GROUP,                                          
MFA-TR*              :AT-PREMISE-NO,                                            
MFA-TR*              :AT-CUSTOMER-NO                                            
MFA-TR*       FROM CSS_ACCOUNT                                                  
MFA-TR*       WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                                 
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7000'                     TO ACTIVE-PARAGRAPH       
CBSI          MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P01137******************************************************************        
P01137* 7100-SELECT-PREMISE-DETAILS                                             
P01137******************************************************************        
P01137*                                                                         
P01137 7100-SELECT-PREMISE-DETAILS.                                     
P01137*                                                                         
P01137     EXEC SQL                                                     
P01137        SELECT LOCAL_OFFICE,                                      
P01137               REV_DISTRICT_CD                                    
P01137          INTO :PR-LOCAL-OFFICE,                                  
P01137               :PR-REV-DISTRICT-CD                                
P01137          FROM CSS_PREMISE WITH(READUNCOMMITTED)                          
P01137         WHERE PREMISE_NO = :PR-PREMISE-NO                        
P01137                                                           
P01137                                                      
P01137     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LOCAL_OFFICE,                                              
MFA-TR*              REV_DISTRICT_CD                                            
MFA-TR*         INTO :PR-LOCAL-OFFICE,                                          
MFA-TR*              :PR-REV-DISTRICT-CD                                        
MFA-TR*         FROM CSS_PREMISE                                                
MFA-TR*        WHERE PREMISE_NO = :PR-PREMISE-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P01137                                                                  
P01137     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
P01137                                                                  
P01137     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P01137        NEXT SENTENCE                                             
P01137     ELSE                                                         
P01137        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P01137        MOVE '7100'                     TO ACTIVE-PARAGRAPH       
P01137        MOVE 'SELECT'                   TO ABEND-FUNCTION         
P01137        MOVE 'CSS_PREMISE'              TO TABLE-1                
P01137        MOVE 'PR-PREMISE-NO'            TO TABLE-ELEMENT-1        
P01137        MOVE PR-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
P01137        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P01137        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P01137     END-IF.                                                      
P01137*                                                                         
P01137 7100-EXIT.                                                       
P01137     EXIT.                                                        
P01137*                                                                         
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
REARCH*    EXEC SQL                                                             
REARCH*       INCLUDE CPD00300                                                  
REARCH*    END-EXEC.                                                            
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
REARCH*    COPY CPD00302.                                                       
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPD00321                                                  
REARCH     END-EXEC.                                                            
                                                                        
