       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02240.                                         
COB303 DATE-WRITTEN.                                                    
COB303            NOVEMBER 8, 1994.                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
      *                                                                *00110000
      *  TRANID:        S240                                           *00120000
      *  PROGRAM:       S240                                           *00130000
      *  CALLING SP:    PA_S240                                        *00140000
      *                                                                *00150000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *00190000
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *00200000
      *                                                                *00210000
      *  THIS PROGRAM RETRIEVES FORECAST DATA FOR FINALLED ACCOUNTS.   *00220000
      *                                                                *00240000
      ******************************************************************00250000
      *                                                                *00260000
      *                     PROGRAM MODIFICATION LOG                   *00270000
      *                                                                *00280000
      *    DATE    INITIALS   COMMENTS                                 *00290000
      *  --------  --------   ---------------------------------------  *00300000
      *  10/31/94    AS       CREATED.                                 *00310000
      *    0395      CIF      MODIFICATION MADE PER DATABASE CHANGE:   *00310000
      *                       1. CODE-DISCON-HIST AND CODE-SPCL-DSC-   *00320000
      *                          MOVED FROM AT TO CZ.                  *00320000
      *                       2. CHANGE CONTRACT_TYPE_CD TO CODE-      *00320000
      *                          CONTRACT_TYPE                         *00320000
      *                                                                *00320000
      *  10/25/96     KOG    MODS FOR PCR395-TO PROCESS DNP, GUARANTEED*00320000
      *                      AND NORMAL ACCOUNTS AND SEND BACK THE     *00320000
      *                      CORRECT NOTICE CODE.                      *00320000
      *                                                                *00320000
TP8256*  12/18/96    JEP      PCR395 FAILED TO RETURN WRITE_OFF_DT     *        
TP8256*                       FROM CSS_FINAL_WO AND ASSUMED THAT       *        
TP8256*                       FIRST_CR_LTR_DT WAS THE CORRECT DATE.    *        
      *                                                                *00320000
TP8309*  01/13/97    PD       ADD LPC ASSES DATE AND AMOUNT TO BE      *        
TP8309*                       RETRIEVED.                               *        
      *                                                                *00320000
TP9130*  02/10/97    MXH      ADDED LOGIC TO CHECK IF SECOND_CR_LTR_DT *        
TP9130*                       IS NULL. IF IT IS THE ROW IS NOT SENT.   *        
      *                                                                *00320000
TP9207*  02/13/97    MXH      MOVED AN END-IF STATEMENT THAT WAS THE   *        
TP9207*                       CAUSE FOR 'COLLECTION AGENCY' TO APPEAR  *        
TP9207*                       TWICE                                    *00320000
      *                                                                *00320000
T9751 *  04/01/97    EMM      CALCULATED THE WRITE OFF BALANCE FOR     *        
      *                       ACCOUNTS WITH WRITE OFF STATUS.          *        
      *                       ADDED TBCHGOFF DCLGEN.                   *        
T11146*  05/14/97    EMM      COMPLETING THE 'FINAL BILL' ROW          *        
      *                       REGARDLESS OF THE AMOUNT.                *        
      *  06/12/97    EMM      RESTRUCTURED PROGRAM.                    *        
T11585*  06/17/97    EMM      EDIT IND SHOULD EQUAL 'N' FOR SECOND     *        
      *                       WRITE OFF LETTER.                        *        
PCR408*  07/01/97    EMM      ADD GUARANTOR TRANSER DATE AND           *        
      *                       GUARANTOR TRANSFER INDICATOR.            *        
NONUTL*  07/09/97    MJG      IF A NON UTILITY ACCT SEE IF THE ACCT IS *        
      *                       ALREADY SET UP TO BE FINALLED TODAY.     *        
12834L*  08/19/97    MJG      RETURN RS-BILLED BALANCE ALL THE TIME.   *        
T12831*  09/29/97    BAB      RETURN CRDT_BUR_EXPT_FL                  *        
T13623*  11/10/97    EMS      CHANGED SELECT TO RETURN CRDT-BUR-EXPT-FL*        
T13685*  11/10/97    EMS      ADDED CPD00068 FOR WRITE OFF BALANCE     *        
      *                       ONLY RETURN ROWS WHERE A DATE EXISTS.    *        
T15719*  04/06/98    EMS      CHANGED WS-AMT-PAST-DUE TO WS-WO-BALANCE *        
T16853*  06/23/98    EMS      CHANGED TBARHDT TO DCLGEN.               *        
CBSI  *  11/18/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *              MADRAS   ABEND PARAMETERS                         *        
T17071*  01/20/98    MDJ      ADDED INCLUDE TBCSTALT FOR CUST_ALERT    *        
      *                       DUE TO CPD00068 CHANGES.                 *        
T18640*  12/21/98    SHF      EDIT-IND WAS INCORRECTLY SET TO Y FOR    *        
      *                       SECOND CREDIT LETTER.                    *        
T19854*  04/29/99    ZB17046  MADE CHANGE TO KEEP PANEL 273 FROM       *        
T19854*                       ABENDING WITH -811 WHEN MORE THAN ONE    *        
T19854*                       ROW IS FOUND IN CSS_OFF_CYCL_ACCT TABLE. *        
T19557* 02/17/00     CBSI    COPYBOOK CDP00068 CHANGED TO SUB PROGRAM  *        
T19557*              MADRAS  SCSCO068.                                 *        
T22359*  06/21/00    MDJ      MADE CHANGES TO KEEP IDENTITY OF PROGRAM *        
      *                       CALLING SCSCO068 OR SCSCB068.  THERE IS  *        
      *                       SPECIFIC LOGIC IN CPD00068 FOR CERTAIN   *        
      *                       PROGRAMS WHICH WAS NOT BEING EXECUTED    *        
      *                       PROPERLY BECAUSE THE PROGRAM NAME WAS    *        
      *                       ALWAYS SCSCO068 OR SCSCB068.             *        
T21886*  10/16/00    VIJAY    MADE CHANGES TO GET NEXT 2ND BUSINESS    *        
      *                       DATE FROM TODAY.                         *        
      *                       IT IS REQUIRED TO CHECK SELECTED         *        
      *                       COLLECTION AGENCY DATE > OR = TO         *        
      *                       TODAY + 2 (BUSINESS DAYS) WHEN THERE IS  *        
      *                       A CHANGE IN COLLECTION AGENCY DATE.      *        
      *                       THIS IS USED IN UE_UPDATE EVENT.         *        
      *                       REMOVED THE LOGIC OF SECOND-CR-LTR-DT.   *        
C28788*  07/07/03    MDJ      GET IVR-EXEMPT-CD FOR CPD00068.          *        
REARCH*  05/25/05    CVNS     RPC TO COBOL SP CONVERSION               *        
REARCH*              CHENNAI                                           *        
T34488*  08/04/06    CVNS     SET THE SWITCH 'CALC-PAST-DUE-SW'.       *        
T34488*              CHENNAI                                           *        
T35434*  10/30/07    MK92804  REPLACED CSS_MODEL_SQL WITH SET STMTS    *        
T35434*                       AND ADDED 'WITH UR' FOR SINGLETON SELECTS*        
C30169*  21/12/07    SJ94244  WRTOFF RECOVERY CHANGES                  *        
C30169*                                                                *        
C30169*  24/10/08    CVNS     DELETE THE CODE THAT HAVE REFERENCES     *        
C30169*              CHENNAI  TO CSS_CHRG_OFF FIELD WHICH ARE          *        
C30169*                       DELETED FROM THE DB2.                    *        
A00406*  06/08/10    SV85244  ADDED BLOCK FETCH.                       *        
A00406*                                                                *        
P00599*  08/28/12    NS75440  ADDED KD-PROCESSED-FL TO FINAL_WO_ACTN   *        
P00599*                       CURSOR AND MADE NECESSARY CHANGES TO     *        
P00599*                       THE FETCH STATEMENT.                     *        
      ******************************************************************00330000
      ******************************************************************00340000
      *                                                                *00350000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00360000
      *                                                                *00370000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00380000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00390000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00400000
      *  3000 - 4999  NOT USED                                         *00410000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00420000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00430000
      *  7000 - 7999  INPUT MODULES                                    *00440000
      *  8000 - 8999  OUTPUT MODULES                                   *00450000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00460000
      *                                                                *00470000
      ******************************************************************00480000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02240'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02240 STARTS HERE'.                  
                                                                        
                                                                        
      ******************************************************************00580000
      *    DB2 INCLUDES                                                *00590000
      ******************************************************************00600000
                                                                        
T21886     EXEC SQL                                                     00630000
T21886          INCLUDE CWS00315                                        00640000
T21886     END-EXEC.                                                    00650000
                                                                        
           EXEC SQL                                                     00620000
              INCLUDE SQLCA                                             00630000
           END-EXEC.                                                    00640000
                                                                        
           EXEC SQL                                                     00660000
              INCLUDE TBFINLWO                                          00670000
           END-EXEC.                                                    00680000
                                                                        
           EXEC SQL                                                     00660000
              INCLUDE TBACCT                                            00670000
           END-EXEC.                                                    00680000
      *                                                                         
C28788     EXEC SQL                                                             
C28788        INCLUDE TBUTLENV                                                  
C28788     END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                     00660000
              INCLUDE TBOFFCYL                                          00670000
           END-EXEC.                                                    00680000
                                                                        
           EXEC SQL                                                     00660000
              INCLUDE TBPREM                                            00670000
           END-EXEC.                                                    00680000
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                          00670000
           END-EXEC.                                                    00680000
                                                                        
           EXEC SQL                                                     00700000
              INCLUDE TBCNTRCT                                          00670000
           END-EXEC.                                                    00680000
                                                                        
           EXEC SQL                                                     00660000
              INCLUDE TBCNTYPE                                          00670000
           END-EXEC.                                                    00680000
                                                                        
           EXEC SQL                                                     00660000
              INCLUDE TBCRPROF                                          00670000
           END-EXEC.                                                    00680000
                                                                        
           EXEC SQL                                                     00700000
              INCLUDE TBGTNTR                                           00710000
           END-EXEC.                                                    00720000
                                                                        
T21886     EXEC SQL                                                     00700000
T21886        INCLUDE TBHLDAY                                           00710000
T21886     END-EXEC.                                                    00720000
                                                                        
C30169     EXEC SQL                                                             
C30169        INCLUDE TBFWPATH                                                  
C30169     END-EXEC.                                                            
      ******************************************************************00750000
      *    COBOL WORKING STORAGE COPY COOKS                            *00760000
      ******************************************************************00770000
                                                                        
REARCH*    COPY SYGWCOB.                                                00790000
REARCH*    COPY SYDBCOB.                                                00800000
           COPY CCA00001.                                               00810000
REARCH*    COPY CWS00010.                                               00820000
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CWSX0010                                                  
REARCH     END-EXEC.                                                            
           COPY CWS00027.                                               00830000
           COPY CWS00303.                                               00840000
T13685     COPY CWS00056.                                               00840000
T19557     COPY CWS0068L.                                               01680000
      *                                                                         
T13685     EXEC SQL                                                             
               INCLUDE CWS00068                                                 
           END-EXEC.                                                            
                                                                        
      *                                                                         
      ******************************************************************00860000
      *    WORK AREAS                                                  *00870000
      ******************************************************************00880000
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
REARCH     05  PARM-ACCOUNT-NO-TEMP    PIC X(13)  VALUE SPACES.         
REARCH     05  PARM-ACCOUNT-NO-RED     REDEFINES PARM-ACCOUNT-NO-TEMP   
                                       PIC 9(13).                       
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME            PIC X(8)  VALUE 'CSR02240'.      
REARCH     05  WS-SQLSTATE             PIC X(05) VALUE '     '.         
REARCH     05  MCSCB068                PIC X(8)  VALUE 'MCSCB068'.      
           05  WS-ACCOUNT-NO           PIC 9(13) VALUE ZERO.            
           05  WS-ACCOUNT-NO-NUM                                        
                          PIC S9(13) COMP-3 VALUE ZERO.                 
           05  WS-INVEST-NULL-IND        PIC S9(4) COMP VALUE 0.        
           05  WS-INVEST-NULL-IND2       PIC S9(4) COMP VALUE 0.        
           05  WS-DATE-NULL-IND1         PIC S9(4) COMP VALUE 0.        
           05  WS-DATE-NULL-IND2         PIC S9(4) COMP VALUE 0.        
           05  WS-DATE-NULL-IND3         PIC S9(4) COMP VALUE 0.        
           05  WS-DATE-NULL-IND4         PIC S9(4) COMP VALUE 0.        
           05  WS-DATE-NULL-IND5         PIC S9(4) COMP VALUE 0.        
           05  WS-DATE-NULL-IND6         PIC S9(4) COMP VALUE 0.        
           05  WS-DATE-NULL-IND7         PIC S9(4) COMP VALUE 0.        
           05  WS-DATE-NULL-IND8         PIC S9(4) COMP VALUE 0.        
           05  WS-DATE-NULL-IND9         PIC S9(4) COMP VALUE 0.        
           05  WS-DATE-NULL-IND10        PIC S9(4) COMP VALUE 0.        
C30169     05  WS-DATE-NULL-IND11        PIC S9(4) COMP VALUE 0.        
C30169     05  WS-IZ-ACTION-TYPE-CD-NULL PIC S9(4) COMP VALUE 0.        
C30169     05  WS-IZ-WITHDRAW-DT-NULL    PIC S9(4) COMP VALUE 0.        
C30169     05  WS-IZ-WITHDRAW-AM-NULL    PIC S9(4) COMP VALUE 0.        
C30169     05  WS-IZ-COLL-AGNCY-CD-NULL  PIC S9(4) COMP VALUE 0.        
C30169     05  WS-IZ-COLL-AGY-SUB-CD-NULL PIC S9(4) COMP VALUE 0.       
C30169     05  WS-IZ-WD-RSN-CD-NULL       PIC S9(4) COMP VALUE 0.       
           05  WS-DATE-BILL-DAY-00-NULL  PIC S9(4) COMP VALUE 0.        
           05  WS-DATE-BILL-DAY-30-NULL  PIC S9(4) COMP VALUE 0.        
           05  WS-DATE-BILL-DAY-60-NULL  PIC S9(4) COMP VALUE 0.        
           05  WS-DATE-BILL-DAY-90-NULL  PIC S9(4) COMP VALUE 0.        
           05  WS-FINL-DT-NULL-IND       PIC S9(4) COMP VALUE 0.        
PCR408     05  WS-GUAR-XFER-DT-IND       PIC S9(4) COMP VALUE 0.        
TP8309     05  WS-LPC-NULL-IND         PIC S9(4) COMP VALUE 0.          
           05  WS-ITEM-ID              PIC S9(4) COMP VALUE 0.          
           05  WS-ITEM-ID-INT          PIC S9(9) COMP-3 VALUE 0.        
PCR395     05  WS-811                  PIC S9(9) VALUE -811 COMP.       
PCR395     05  WS-DT-NULL-IND          PIC S9(4) COMP VALUE 0.          
TP8256     05  WS-WO-DT-NULL-IND       PIC S9(4) COMP VALUE 0.          
C30169     05  WS-WD-DATE-NULL         PIC S9(4) COMP VALUE 0.          
C30169     05  WS-WO-COMPLETED         PIC X(01) VALUE 'N'.             
C30169     05  WS-CURRENT-DATE         PIC X(10) VALUE SPACES.          
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-ACTIVE-CODE          PIC X(01) VALUE 'A'.             
                                                                        
       01  WS-FINAL-WO-COLL-TABLE.                                      
           05  WS-WITHDRAW-DT        PIC X(10) VALUE SPACES.            
           05  WS-WITHDRAW-AM        PIC S9(9)V9(2) COMP-3 VALUE +0.    
           05  WS-CODE-COLLEC-AGNCY  PIC X(3) VALUE SPACES.             
                                                                        
C30169 01  WS-FINAL-WO-TABLE.                                           
C30169     05 WS-FIN-WO-ACTION-DT   PIC X(10) VALUE SPACES.             
C30169     05 WS-FIN-WO-ACTION-AM   PIC S9(9)V9(2) COMP-3 VALUE +0.     
C30169     05 WS-ACTION-TYPE-CD     PIC X(5) VALUE SPACES.              
C30169     05 WS-ACTION-COMMENT.                                        
C30169        49 WS-ACTION-COMMENT-LEN PIC S9(04) COMP SYNC VALUE +0.   
C30169        49 WS-ACTION-COMMENT-TEXT PIC X(254) VALUE SPACES.        
C30169     05 WS-FIN-WO-MANUAL-IND  PIC X(1) VALUE SPACE.               
C30169     05 WS-FW-SEQ-NO          PIC S9(4) COMP VALUE 0.             
P00599     05 WS-FW-PROCESSED-FL    PIC X(1) VALUE SPACES.              
C30169     05 WS-IZ-ACTION-TYPE-CD  PIC X(05) VALUE SPACES.             
C30169     05 WS-IZ-WITHDRAW-DT     PIC X(10) VALUE SPACES.             
C30169     05 WS-IZ-WITHDRAW-AM     PIC S9(9)V9(2) COMP-3 VALUE +0.     
C30169     05 WS-IZ-COLLEC-AGNCY-CD PIC X(3) VALUE SPACES.              
C30169     05 WS-IZ-COLL-AGY-SUB-CD PIC X(3) VALUE SPACES.              
C30169     05 WS-IZ-WITHDRAW-REASON-CD PIC X(1) VALUE SPACES.           
                                                                        
C30169 01  WS-EXEMPT-FL.                                                
C30169     05 WS-CRED-EXEMPT-FL     PIC X(5) VALUE SPACES.              
C30169     05 WS-CA-EXEMPT-FL       PIC X(5) VALUE SPACES.              
                                                                        
C30169 01  WS-END-OF-CURSOR            PIC X(1) VALUE 'N'.              
C30169     88 NO-MORE-ROWS                      VALUE 'Y'.              
C30169     88 MORE-ROWS                         VALUE 'N'.              
                                                                        
C30169 01  CHECK-ROW                   PIC X(1) VALUE 'N'.              
C30169     88 WITH-DRAW-ROW                     VALUE 'Y'.              
C30169     88 NOT-WITH-DRAW-ROW                 VALUE 'N'.              
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  TDS-RETURN-FIELDS.                                           
           05 RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
           05 RS-DATE                 PIC X(8) VALUE SPACE.             
C30169     05 RS-ACTION               PIC X(05) VALUE SPACE.            
COB305     05 RS-BALANCE        PIC S999999999V99 COMP-3 VALUE 0.         
           05 RS-ITEM-ID              PIC S9(4) COMP VALUE 0.           
COB305     05 RS-FINAL-BALANCE        PIC S999999999V99 COMP-3 VALUE 0.         
           05 RS-INVEST-IND           PIC X(1) VALUE SPACE.             
           05 RS-DNP-IND              PIC X(1) VALUE SPACE.             
           05 RS-ITEM-DESC            PIC X(25) VALUE SPACE.            
           05 RS-ACTIV-ACCT-IND       PIC X(1) VALUE SPACE.             
           05 RS-SPCL-BILL-IND        PIC X(1) VALUE SPACE.             
           05 RS-INVEST-COMMENT.                                        
               49 RS-INVEST-COMMENT-LEN PIC S9(04) COMP SYNC VALUE +0.  
               49 RS-INVEST-COMMENT-TEXT PIC X(254) VALUE SPACES.       
PCR395     05 RS-FLAG-IND             PIC X(1) VALUE SPACE.             
COB305     05 RS-BILLED-BALANCE        PIC S9(9)V99 COMP-3 VALUE 0.             
PCR395     05 RS-EDIT-IND             PIC X(1) VALUE 'N'.               
PCR395     05 RS-COMPLETED            PIC X(1) VALUE 'N'.               
PCR408     05 RS-GUARANTEED-IND       PIC X(1) VALUE SPACE.             
NONUTL     05 RS-OFF-CYCLE            PIC X(1) VALUE SPACE.             
T12831     05 RS-CRED-EXMPT-FL        PIC X(5) VALUE SPACES.            
T21886     05 RS-BUS-DT               PIC X(10) VALUE SPACE.            
C30169     05 RS-CA-EXEMPT-FL         PIC X(5) VALUE SPACES.            
C30169     05 RS-MANUAL-IND           PIC X(1) VALUE 'N'.               
C30169     05 RS-FW-SEQ-NO            PIC S9(4) COMP VALUE 0.           
C30169     05 RS-CODE-COLLEC-AGNCY    PIC X(5) VALUE SPACE.             
C30169     05 RS-COLL-AGY-SUB-CD      PIC X(3) VALUE SPACE.             
C30169     05 RS-CODE-ACCT-STAT       PIC X(1) VALUE SPACE.             
C30169     05 RS-PATH-TYPE-CD         PIC X(2) VALUE SPACES.            
C30169     05 RS-PATH-TYPE-DESC       PIC X(75) VALUE SPACES.           
C30169     05 RS-ORIG-DATE            PIC X(8) VALUE SPACE.             
C30169     05 RS-COLLECT-STATUS-CD    PIC X(1) VALUE SPACE.             
C30169*                                                                         
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05 S-RETURN-CODE           PIC S9(9) COMP VALUE 0.           
REARCH     05 S-DATE                  PIC X(8) VALUE SPACE.             
C30169     05 S-ACTION                PIC X(05) VALUE SPACE.            
COB305     05 S-BALANCE        PIC S999999999V99 COMP-3 VALUE 0.         
REARCH     05 S-ITEM-ID               PIC S9(4) COMP VALUE 0.           
COB305     05 S-FINAL-BALANCE        PIC S999999999V99 COMP-3 VALUE 0.         
REARCH     05 S-INVEST-IND            PIC X(1) VALUE SPACE.             
REARCH     05 S-DNP-IND               PIC X(1) VALUE SPACE.             
REARCH     05 S-ITEM-DESC             PIC X(25) VALUE SPACE.            
REARCH     05 S-ACTIV-ACCT-IND        PIC X(1) VALUE SPACE.             
REARCH     05 S-SPCL-BILL-IND         PIC X(1) VALUE SPACE.             
REARCH     05 S-INVEST-COMMENT-TEXT   PIC X(254) VALUE SPACES.          
REARCH     05 S-FLAG-IND              PIC X(1) VALUE SPACE.             
COB305     05 S-BILLED-BALANCE        PIC S9(9)V99 COMP-3 VALUE 0.              
REARCH     05 S-EDIT-IND              PIC X(1) VALUE 'N'.               
REARCH     05 S-COMPLETED             PIC X(1) VALUE 'N'.               
REARCH     05 S-GUARANTEED-IND        PIC X(1) VALUE SPACE.             
REARCH     05 S-OFF-CYCLE             PIC X(1) VALUE SPACE.             
REARCH     05 S-CRED-EXMPT-FL         PIC X(5) VALUE SPACE.             
REARCH     05 S-BUS-DT                PIC X(10) VALUE SPACE.            
C30169     05 S-CA-EXEMPT-FL          PIC X(5) VALUE SPACE.             
C30169     05 S-MANUAL-IND            PIC X(1) VALUE 'N'.               
C30169     05 S-FW-SEQ-NO             PIC S9(4) COMP VALUE 0.           
C30169     05 S-CODE-COLLEC-AGNCY     PIC X(5) VALUE SPACE.             
C30169     05 S-COLL-AGY-SUB-CD       PIC X(3) VALUE SPACE.             
C30169     05 S-CODE-ACCT-STAT        PIC X(1) VALUE SPACE.             
C30169     05 S-PATH-TYPE-CD          PIC X(2) VALUE SPACES.            
C30169     05 S-PATH-TYPE-DESC        PIC X(75) VALUE SPACES.           
C30169     05 S-ORIG-DATE             PIC X(8) VALUE SPACE.             
C30169     05 S-COLLECT-STATUS-CD     PIC X(1) VALUE SPACE.             
REARCH*                                                                         
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH      05  GTT-NAME                PIC X(26)                       
REARCH                                  VALUE 'SESSION.CSR02240_R1'.    
REARCH      05  GTT-ROW.                                                
REARCH          49 GTT-ROW-LEN          PIC S9(04) COMP.                
REARCH          49 GTT-ROW-CHAR         PIC X(1024).                    
REARCH      05  GTT-SQLCODE             PIC S9(9) COMP.                 
REARCH*                                                                         
REARCH 01  CSRERLOG-P.                                                  
REARCH      10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
REARCH      10  S-SQLCODE               PIC S9(9)      COMP VALUE 0.    
REARCH      10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
REARCH      10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
REARCH      10  S-HOST-VARIABLES.                                       
REARCH          49  S-HOST-VARIABLES-L  PIC S9(4)      USAGE COMP.      
REARCH          49  S-HOST-VARIABLES-V  PIC X(255).                     
REARCH      10  S-SQL-STATEMENT.                                        
REARCH          49  S-SQL-STATEMENT-L   PIC S9(4)      USAGE COMP.      
REARCH          49  S-SQL-STATEMENT-V   PIC X(255).                     
REARCH      10  S-SQL-DESCRIPTION.                                      
REARCH          49  S-SQL-DESCRIPTION-L PIC S9(4)      USAGE COMP.      
REARCH          49  S-SQL-DESCRIPTION-V PIC X(255).                     
REARCH*                                                                         
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
C30169*CURSOR TO FETCH THE FINAL WO ACTION ROWS                                 
C30169*                                                                         
C30169     EXEC SQL                                                     
C30169        DECLARE FINAL_WO_ACTN CURSOR FOR                          
C30169           SELECT                                                 
C30169               KD.FW_ACTION_DT                                    
C30169              ,KD.FW_ACTION_AM                                    
C30169              ,KD.FW_ACTION_TYPE_CD                               
C30169              ,KD.FW_ACTION_COMMENTS                              
C30169              ,KD.FW_MANUAL_FL                                    
C30169              ,KD.FW_SEQ_NO                                       
P00599              ,KD.FW_PROCESSED_FL                                 
C30169              ,IZ.FW_ACTION_TYPE_CD                               
C30169              ,IZ.WITHDRAW_DT                                     
C30169              ,IZ.WITHDRAW_AM                                     
C30169              ,IZ.CODE_COLLEC_AGNCY                               
C30169              ,IZ.COLL_AGY_SUB_CD                                 
C30169              ,IZ.WITHDRAW_REASON_CD                              
C30169           FROM                                                   
C30169              CSS_FIN_WO_ACTION KD                                
C30169           LEFT OUTER JOIN                                        
C30169              CSS_FIN_WO_COLLECT IZ                               
C30169           ON                                                     
C30169               KD.ACCOUNT_NO        = IZ.ACCOUNT_NO               
C30169           AND KD.FW_ACTION_TYPE_CD = IZ.FW_ACTION_TYPE_CD        
C30169           AND KD.FW_SEQ_NO         = IZ.FW_COLL_SEQ_NO           
C30169           WHERE                                                  
C30169               KD.ACCOUNT_NO  = :WS-ACCOUNT-NO-NUM                
C30169           ORDER BY KD.FW_SEQ_NO, KD.FW_ACTION_DT                 
C30169                                                                  
C30169     END-EXEC.                                                    
C30169                                                                  
                                                                        
T21957                                                                  
HPCCDM*EJECT                                                            01830000
REARCH*                                                                         
REARCH LINKAGE SECTION.                                                 
REARCH 01  PARM-ACCOUNT-NO         PIC X(13).                           
REARCH*                                                                         
REARCH PROCEDURE DIVISION USING PARM-ACCOUNT-NO.                        
                                                                        
      ******************************************************************01860000
      * 0000-MAINLINE                                                  *01870000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *01880000
      ******************************************************************01890000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02010000
      * 0100-INITIALIZE                                                *02020000
      *                                                                *02030000
      *     1. RESET DB2 ERROR HANDLERS                                *02040000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *02050000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *02060000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*02070000
      *                                                                *02080000
      ******************************************************************02090000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
REARCH     PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH        DECLARE C1 CURSOR                              
A00406                          WITH ROWSET POSITIONING FOR             
REARCH        SELECT                                                    
REARCH              RETURN_CODE                                         
REARCH             ,DATE                                                
REARCH             ,LTRIM(RTRIM(ACTION))               AS ACTION               
REARCH             ,BALANCE                                             
REARCH             ,ITEM_ID                                             
REARCH             ,FINAL_BALANCE                                       
REARCH             ,INVEST_IND                                          
REARCH             ,DNP_IND                                             
REARCH             ,LTRIM(RTRIM(ITEM_DESC))            AS ITEM_DESC            
REARCH             ,ACTIV_ACCT_IND                                      
REARCH             ,SPCL_BILL_IND                                       
REARCH             ,LTRIM(RTRIM(INVEST_CMNT_TEXT))     AS 
           INVEST_CMNT_TEXT     
REARCH             ,FLAG_IND                                            
REARCH             ,BILLED_BALANCE                                      
REARCH             ,EDIT_IND                                            
REARCH             ,COMPLETED                                           
REARCH             ,GUARANTEED_IND                                      
REARCH             ,OFF_CYCLE                                           
REARCH             ,CRED_EXMPT_FL                                       
REARCH             ,BUS_DT                                              
C30169             ,CA_EXEMPT_FL                                        
C30169             ,MANUAL_IND                                          
C30169             ,FW_SEQ_NO                                           
C30169             ,CODE_COLLEC_AGNCY                                   
C30169             ,COLL_AGY_SUB_CD                                     
C30169             ,CODE_ACCT_STAT                                      
C30169             ,COLL_PATH_TYPE_CD                                   
C30169             ,LTRIM(RTRIM(COLL_PATH_TYP_DESC))    AS 
           COLL_PATH_TYP_DESC  
C30169             ,LTRIM(RTRIM(ORIG_DATE))             AS ORIG_DATE           
C30169             ,COLLECT_STATUS_CD                                   
REARCH         FROM                                                     
REARCH             #CSR02240_R1                                  
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN                                     
MFA-TR*                         WITH ROWSET POSITIONING FOR                     
MFA-TR*       SELECT                                                            
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,DATE                                                        
MFA-TR*            ,STRIP(ACTION)               AS ACTION                       
MFA-TR*            ,BALANCE                                                     
MFA-TR*            ,ITEM_ID                                                     
MFA-TR*            ,FINAL_BALANCE                                               
MFA-TR*            ,INVEST_IND                                                  
MFA-TR*            ,DNP_IND                                                     
MFA-TR*            ,STRIP(ITEM_DESC)            AS ITEM_DESC                    
MFA-TR*            ,ACTIV_ACCT_IND                                              
MFA-TR*            ,SPCL_BILL_IND                                               
MFA-TR*            ,STRIP(INVEST_CMNT_TEXT)     AS INVEST_CMNT_TEXT             
MFA-TR*            ,FLAG_IND                                                    
MFA-TR*            ,BILLED_BALANCE                                              
MFA-TR*            ,EDIT_IND                                                    
MFA-TR*            ,COMPLETED                                                   
MFA-TR*            ,GUARANTEED_IND                                              
MFA-TR*            ,OFF_CYCLE                                                   
MFA-TR*            ,CRED_EXMPT_FL                                               
MFA-TR*            ,BUS_DT                                                      
MFA-TR*            ,CA_EXEMPT_FL                                                
MFA-TR*            ,MANUAL_IND                                                  
MFA-TR*            ,FW_SEQ_NO                                                   
MFA-TR*            ,CODE_COLLEC_AGNCY                                           
MFA-TR*            ,COLL_AGY_SUB_CD                                             
MFA-TR*            ,CODE_ACCT_STAT                                              
MFA-TR*            ,COLL_PATH_TYPE_CD                                           
MFA-TR*            ,STRIP(COLL_PATH_TYP_DESC)    AS COLL_PATH_TYP_DESC          
MFA-TR*            ,STRIP(ORIG_DATE)             AS ORIG_DATE                   
MFA-TR*            ,COLLECT_STATUS_CD                                   01370001
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR02240_R1                                          
MFA-TR*    END-EXEC.                                                            
REARCH                                                                  
       0100-EXIT.                                                       
           EXIT.                                                        
REARCH*                                                                 02320000
REARCH******************************************************************        
REARCH*0100A-DECLARE-GTT.                                                       
REARCH******************************************************************        
REARCH 0100A-DECLARE-GTT.                                               
REARCH*                                                                         
REARCH      MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR02240_R1'           
REARCH                                    TO S-SQL-STATEMENT-V.         
REARCH      EXEC SQL
              CALL CIS.DROP_TEMP_TABLE('#CSR02240_R1')
            END-EXEC
            EXEC SQL
              CREATE TABLE #CSR02240_R1
               (                                                        
REARCH                RETURN_CODE         INT                       
REARCH               ,DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2            
REARCH               ,ACTION CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH               ,BALANCE             DECIMAL(11,2)                 
REARCH               ,ITEM_ID             SMALLINT                      
REARCH               ,FINAL_BALANCE       DECIMAL(11,2)                 
REARCH               ,INVEST_IND CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
REARCH               ,DNP_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH               ,ITEM_DESC CHAR(25)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
REARCH               ,ACTIV_ACCT_IND CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
REARCH               ,SPCL_BILL_IND CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
REARCH               ,INVEST_CMNT_TEXT CHAR(254)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
REARCH               ,FLAG_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH               ,BILLED_BALANCE      DECIMAL(11,2)                 
REARCH               ,EDIT_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH               ,COMPLETED CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
REARCH               ,GUARANTEED_IND CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
REARCH               ,OFF_CYCLE CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
REARCH               ,CRED_EXMPT_FL CHAR(05)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
REARCH               ,BUS_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2          
C30169               ,CA_EXEMPT_FL CHAR(05)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
C30169               ,MANUAL_IND CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
C30169               ,FW_SEQ_NO           SMALLINT                      
C30169               ,CODE_COLLEC_AGNCY CHAR(05)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
C30169               ,COLL_AGY_SUB_CD CHAR(03)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
C30169               ,CODE_ACCT_STAT CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
C30169               ,COLL_PATH_TYPE_CD CHAR(02)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
C30169               ,COLL_PATH_TYP_DESC CHAR(75)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
REARCH               ,ORIG_DATE CHAR(10)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
C30169               ,COLLECT_STATUS_CD CHAR(01)  COLLATE 
                                    LATIN1_GENERAL_100_BIN2                    
C30169         )
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30169      MOVE SQLSTATE                 TO WS-SQLSTATE.               
C30169      MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
C30169                                                                  
C30169      IF WS-SQLSTATE = '42710'                                    
C30169         PERFORM 8000A-DELETE-GTT-ROWS                            
C30169                                    THRU 8000A-EXIT               
C30169      ELSE                                                        
C30169         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
C30169           NEXT SENTENCE                                          
C30169        ELSE                                                      
C30169           MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
C30169           MOVE SQLCODE            TO ABEND-SQLCODE               
C30169           MOVE SQLSTATE           TO ABEND-SQLSTATE              
C30169           MOVE '0100A'            TO ACTIVE-PARAGRAPH            
C30169           MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
C30169           MOVE SPACES             TO ABEND-SQL-PREDICATES        
C30169                                      ABEND-TABLES                
C30169           MOVE 'CSR02240_R1'      TO TABLE-1                     
C30169           MOVE SPACES             TO TABLE-ELEMENT-1             
C30169           MOVE SPACES             TO HOSTVAR-ELEMENT-1           
C30169           PERFORM 9900-SQL-ERROR-ROUTINE                         
C30169                                   THRU  9900-EXIT                
C30169        END-IF                                                    
C30169     END-IF.                                                      
C30169*                                                                         
C30169 0100A-EXIT.                                                      
C30169      EXIT.                                                       
C30169*                                                                         
      ******************************************************************02360000
      * 1000-PROCESS-INPUT                                             *02370000
      *                                                                *02380000
      *     1. RECEIVE PARMS.                                          *02390000
      *                                                                *02400000
      ******************************************************************02410000
      *                                                                 02420000
       1000-PROCESS-INPUT.                                              
                                                                        
REARCH     MOVE PARM-ACCOUNT-NO           TO PARM-ACCOUNT-NO-TEMP.      
           MOVE PARM-ACCOUNT-NO-RED       TO WS-ACCOUNT-NO.             
           MOVE WS-ACCOUNT-NO             TO WS-ACCOUNT-NO-NUM.         
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02660000
      ******************************************************************02670000
      * 2000-PROCESS-OUTPUT.                                           *02680000
      *                                                                *02690000
      ******************************************************************02700000
      *                                                                 02660000
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 2200-BUILD-RESULT     THRU 2200-EXIT.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02660000
REARCH******************************************************************        
REARCH*2000A-MOVE-RESULT.                                                       
REARCH******************************************************************        
REARCH 2000A-MOVE-RESULT.                                               
REARCH                                                                  
REARCH     MOVE RS-RETURN-CODE           TO S-RETURN-CODE.              
REARCH     MOVE RS-DATE                  TO S-DATE.                     
REARCH     MOVE RS-ACTION                TO S-ACTION.                   
REARCH     MOVE RS-BALANCE               TO S-BALANCE.                  
REARCH     MOVE RS-ITEM-ID               TO S-ITEM-ID.                  
REARCH     MOVE RS-FINAL-BALANCE         TO S-FINAL-BALANCE.            
REARCH     MOVE RS-INVEST-IND            TO S-INVEST-IND.               
REARCH     MOVE RS-DNP-IND               TO S-DNP-IND.                  
REARCH     MOVE RS-ITEM-DESC             TO S-ITEM-DESC.                
REARCH     MOVE RS-ACTIV-ACCT-IND        TO S-ACTIV-ACCT-IND.           
REARCH     MOVE RS-SPCL-BILL-IND         TO S-SPCL-BILL-IND.            
REARCH     MOVE RS-INVEST-COMMENT-TEXT   TO S-INVEST-COMMENT-TEXT.      
REARCH     MOVE RS-FLAG-IND              TO S-FLAG-IND.                 
REARCH     MOVE RS-BILLED-BALANCE        TO S-BILLED-BALANCE.           
REARCH     MOVE RS-EDIT-IND              TO S-EDIT-IND.                 
REARCH     MOVE RS-COMPLETED             TO S-COMPLETED.                
REARCH     MOVE RS-GUARANTEED-IND        TO S-GUARANTEED-IND.           
REARCH     MOVE RS-OFF-CYCLE             TO S-OFF-CYCLE.                
REARCH     MOVE RS-CRED-EXMPT-FL         TO S-CRED-EXMPT-FL.            
REARCH     MOVE RS-BUS-DT                TO S-BUS-DT.                   
C30169     MOVE RS-CA-EXEMPT-FL          TO S-CA-EXEMPT-FL.             
C30169     MOVE RS-MANUAL-IND            TO S-MANUAL-IND.               
C30169     MOVE RS-FW-SEQ-NO             TO S-FW-SEQ-NO.                
C30169     MOVE RS-CODE-COLLEC-AGNCY     TO S-CODE-COLLEC-AGNCY.        
C30169     MOVE RS-COLL-AGY-SUB-CD       TO S-COLL-AGY-SUB-CD.          
C30169     MOVE RS-CODE-ACCT-STAT        TO S-CODE-ACCT-STAT.           
C30169     MOVE RS-PATH-TYPE-CD          TO S-PATH-TYPE-CD.             
C30169     MOVE RS-PATH-TYPE-DESC        TO S-PATH-TYPE-DESC.           
REARCH     MOVE RS-DATE                  TO S-ORIG-DATE.                
REARCH     MOVE RS-COLLECT-STATUS-CD     TO S-COLLECT-STATUS-CD.        
C30169*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
      ******************************************************************04220000
      * 2200-BUILD-RESULT                                              *04230000
      ******************************************************************04240000
      *                                                                 04260000
       2200-BUILD-RESULT.                                               
      *                                                                 04260000
T30169     PERFORM 7050-SELECT-CURRENT-DATE          THRU 7050-EXIT.    
           PERFORM 7400-SELECT-ACCOUNT-DATA          THRU 7400-EXIT.    
                                                                        
           MOVE AT-CODES-DATA-PRESENT        TO WS-CODES-DATA-PRESENT.  
                                                                        
NONUTL     PERFORM 7900-CHECK-OFF-CYCLE              THRU 7900-EXIT.    
T19854     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR -811           
NONUTL        MOVE 'Y'                       TO RS-OFF-CYCLE            
NONUTL     END-IF.                                                      
      *                                                                         
T9751      IF AT-CODE-ACCT-STAT = 'S'                                   
T34488         MOVE 'Y'                 TO CALC-PAST-DUE-SW             
T22359         MOVE PROGRAM-NAME        TO WS-CPD00068-CALLING-PGM      
T19557         MOVE SPACES              TO ABEND-FUNCTION               
T19557         PERFORM 9500-CALL-CPD00068                               
T19557                                  THRU 9500-EXIT                  
T19557         MOVE RS-RETURN-CODE      TO WS-ACTIVE-RETURN-CODE,       
T19557                                     SQLCODE                      
T19557         IF ABEND-FUNCTION  > SPACES                              
T19557            PERFORM 9700-PROCESS-ABEND                            
T19557                                  THRU 9700-EXIT                  
T19557         END-IF                                                   
      *                                                                         
T15719         MOVE WS-WO-BALANCE       TO RS-BILLED-BALANCE            
      *                                                                         
C30169         PERFORM 7330-SELECT-CREDIT-EXEMPT-FLAG THRU 7330-EXIT    
           ELSE                                                         
               MOVE AT-TOTAL-AR-BALANCE TO RS-BILLED-BALANCE            
           END-IF.                                                      
                                                                        
      ******************************************************************        
      * DETERMINE WHETHER DNP                                          *        
      ******************************************************************        
PCR395     IF AT-CODE-STATUS-REASON = 'C'                               
             MOVE 'Y' TO RS-DNP-IND                                     
           ELSE                                                         
             MOVE 'N' TO RS-DNP-IND                                     
           END-IF.                                                      
                                                                        
      ******************************************************************        
      * DETERMINE WHETHER ACTIVE ACCOUNT                               *        
      ******************************************************************        
           IF AT-CODE-ACCT-STAT = 'A'                                   
              MOVE 'Y' TO RS-ACTIV-ACCT-IND                             
           ELSE                                                         
              MOVE 'N' TO RS-ACTIV-ACCT-IND                             
           END-IF.                                                      
                                                                        
     ******************************************************************         
      * DETERMINE WHETHER SPECIAL BILLING ADDRESS                     *         
     ******************************************************************         
           IF AT-ADDRESS-ID =  0                                        
              MOVE 'N' TO RS-SPCL-BILL-IND                              
           ELSE                                                         
                                                                        
      *---- CHECK FOR SAME ADDRESS ID IN CSS_PREMISE TABLE--------*             
                                                                        
             PERFORM 7700-SELECT-PREMISE-ADDR  THRU 7700-EXIT           
             IF PR-ADDRESS-ID = AT-ADDRESS-ID                           
                MOVE 'N' TO RS-SPCL-BILL-IND                            
             ELSE                                                       
                MOVE 'Y' TO RS-SPCL-BILL-IND                            
             END-IF                                                     
           END-IF.                                                      
                                                                        
      ******************************************************************        
      * GET FINAL WRITE OFF DATA                                       *        
      ******************************************************************        
                                                                        
           PERFORM 7100-SELECT-FINAL-WO          THRU 7100-EXIT.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              IF RS-ACTIV-ACCT-IND = 'N'                                
                 MOVE 300                TO RS-RETURN-CODE              
              ELSE                                                      
                 MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE           
              END-IF                                                    
              MOVE SPACE                 TO RS-DATE                     
              MOVE SPACE                 TO RS-ACTION                   
              MOVE 0                     TO RS-BALANCE                  
              MOVE 0                     TO RS-ITEM-ID                  
              MOVE 0                     TO RS-FINAL-BALANCE            
              MOVE SPACE                 TO RS-INVEST-IND               
              MOVE 0                     TO RS-INVEST-COMMENT-LEN       
              MOVE SPACE                 TO RS-DNP-IND                  
              MOVE SPACE                 TO RS-FLAG-IND                 
      *       MOVE 0                     TO RS-BILLED-BALANCE                   
REARCH        PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT               
              PERFORM 8100-SEND-RESULT    THRU 8100-EXIT                
              PERFORM 9999-END-PROGRAM    THRU 9999-EXIT                
           END-IF.                                                      
                                                                        
           PERFORM 2300-PROCESS-ROWS             THRU 2300-EXIT.        
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04490000
      ******************************************************************        
      * 2300-PROCESS-ROWS:                                             *        
      *                                                                *        
      * THIS MODULE SENDS BACK THE APPROPRIATE ROWS ACCORDING TO       *        
      *  1. FINALED FOR REASON OF DNP, NO GUARANTOR ON ACCOUNT.        *        
      *  2. GUARANTOR ON ACCOUNT.                                      *        
      *  3. FINALED FOR REASON OTHER THAN DNP, NO GUARANTOR ON         *        
      *     ACCOUNT                                                    *        
      *                                                                         
      ******************************************************************        
      *                                                                         
       2300-PROCESS-ROWS.                                               
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE    TO  RS-RETURN-CODE.            
      *                                                                         
           MOVE FW-ITEM-ID               TO  RS-ITEM-ID                 
                                             WS-ITEM-ID-INT.            
      *                                                                         
           MOVE FW-FINAL-BILL-AM         TO  RS-FINAL-BALANCE.          
      *                                                                         
PCR395     MOVE 'U'                      TO  RS-ITEM-DESC.              
      *                                                                         
PCR408     IF FW-GUARANTEED-IND = 'Y'                                   
                MOVE 'Y'                 TO RS-GUARANTEED-IND           
           ELSE                                                         
                MOVE 'N'                 TO RS-GUARANTEED-IND           
           END-IF.                                                      
      *                                                                         
           IF RS-DNP-IND = 'Y' AND FW-GUARANTEED-IND EQUAL SPACE        
C30169         MOVE 'D'                  TO RS-FLAG-IND                 
C30169*        PERFORM 2310-PROCESS-DNP-FINALS           THRU 2310-EXIT         
           END-IF.                                                      
      *                                                                         
           IF FW-GUARANTEED-IND = 'Y'                                   
C30169         MOVE  'G'                 TO RS-FLAG-IND                 
C30169*        PERFORM 2320-PROCESS-GUARANTEED-FINALS    THRU 2320-EXIT         
           END-IF.                                                      
      *                                                                         
PCR395     IF RS-DNP-IND = WS-NO AND FW-GUARANTEED-IND EQUAL SPACE      
C30169         MOVE  'N'                 TO RS-FLAG-IND                 
C30169*        PERFORM 2330-PROCESS-NORMAL-FINALS        THRU 2330-EXIT         
           END-IF.                                                      
C30169     MOVE FW-FW-PATH-TYPE-CD       TO RS-PATH-TYPE-CD.            
C30169     MOVE FW-COLLECT-STATUS-CD     TO RS-COLLECT-STATUS-CD.       
C30169     PERFORM 2500-GET-2ND-BUSINESS-DAY THRU 2500-EXIT.            
C30169     PERFORM 2600-PROCESS-OUTPUT-ROWS  THRU 2600-EXIT.            
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                         
      *  2400-FINAL-BILL-INFO.                                                  
      *                                                                         
      ******************************************************************        
      *                                                                         
       2400-FINAL-BILL-INFO.                                            
                                                                        
           IF WS-DT-NULL-IND < 0 THEN                                   
T30169        IF AT-DATE-BILL-DAY-00 = SPACES THEN                      
T30169           MOVE SPACES                   TO RS-DATE               
T30169        ELSE                                                      
T30169           MOVE AT-DATE-BILL-DAY-00(6:2) TO RS-DATE(1:2)          
T30169           MOVE AT-DATE-BILL-DAY-00(9:2) TO RS-DATE(3:2)          
T30169           MOVE AT-DATE-BILL-DAY-00(1:4) TO RS-DATE(5:4)          
T30169        END-IF                                                    
           ELSE                                                         
               MOVE AT-ACCT-FINALED-DT(6:2) TO RS-DATE(1:2)             
               MOVE AT-ACCT-FINALED-DT(9:2) TO RS-DATE(3:2)             
               MOVE AT-ACCT-FINALED-DT(1:4) TO RS-DATE(5:4)             
           END-IF.                                                      
                                                                        
           MOVE 'N'                         TO  RS-EDIT-IND.            
                                                                        
C30169     MOVE 'FB'                        TO  RS-ACTION.              
           MOVE FW-FINAL-BILL-AM            TO  RS-BALANCE.             
           MOVE +1                          TO  RS-FW-SEQ-NO.           
                                                                        
           MOVE 'Y'                         TO RS-COMPLETED.            
                                                                        
           PERFORM 2000A-MOVE-RESULT               THRU 2000A-EXIT.     
           PERFORM 8100-SEND-RESULT                THRU 8100-EXIT.      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *******************************************************                   
T21886*   2500-GET-2ND-BUSINESS-DAY .                                           
      *******************************************************                   
      *                                                                         
T21886 2500-GET-2ND-BUSINESS-DAY .                                      
                                                                        
T30169     MOVE WS-CURRENT-DATE             TO WS-NEW-BUSINESS-DAY.     
                                                                        
T21886**   GET 1ST BUSINESS DAY FROM TODAY ****                                 
                                                                        
T21886     PERFORM 6500-GET-NEXT-BUSINESS-DAY THRU                      
T21886        6500-NEXT-BUSINESS-DAY-EXIT UNTIL NEXT-BUSINESS-DAY-FOUND.
                                                                        
T21886**   GET 2ND BUSINESS DAY  ****                                           
                                                                        
T21886     MOVE 'N' TO WS-NEXT-BUSINESS-DAY.                            
T21886     PERFORM 6500-GET-NEXT-BUSINESS-DAY THRU                      
T21886        6500-NEXT-BUSINESS-DAY-EXIT UNTIL NEXT-BUSINESS-DAY-FOUND.
                                                                        
T21886     IF  WS-NEW-BUSINESS-DAY > SPACES                             
T21886         MOVE WS-NEW-BUSINESS-DAY  TO RS-BUS-DT                   
T21886***      PERFORM 8100-SEND-RESULT  THRU 8100-EXIT                         
T21886     END-IF.                                                      
                                                                        
T21886 2500-EXIT.                                                       
T21886     EXIT.                                                        
      *                                                                         
      ******************************************************************        
      ** COPY BOOK TO GET THE NEXT BUSINESS DAY                     ****        
      ******************************************************************        
T21886     EXEC SQL                                                             
T21886         INCLUDE CPD0315B                                                 
T21886     END-EXEC.                                                            
                                                                        
C30169*****************************************************************         
C30169*2600-PROCESS-OUTPUT-ROWS.                                      *         
C30169*****************************************************************         
C30169 2600-PROCESS-OUTPUT-ROWS.                                        
C30169                                                                  
C30169     PERFORM 7140-SEL-PATH-TYPE-DESC         THRU 7140-EXIT.      
C30169     PERFORM 7160-SELECT-ACCOUNT-STATUS      THRU 7160-EXIT.      
C30169     PERFORM 7335-SELECT-CA-EXEMPT-FLAG      THRU 7335-EXIT.      
C30169     PERFORM 2400-FINAL-BILL-INFO            THRU 2400-EXIT.      
C30169                                                                  
C30169     MOVE 'N'                                TO WS-END-OF-CURSOR. 
C30169     PERFORM 7200-OPEN-FINAL-WO-CURSOR       THRU 7200-EXIT.      
C30169     PERFORM 7210-FETCH-FIN-WO-ACTN-CURSOR   THRU 7210-EXIT.      
C30169                                                                  
C30169     PERFORM UNTIL NO-MORE-ROWS                                   
C30169        PERFORM 7225-PROCESS-RESULT-ROW       THRU 7225-EXIT      
C30169        PERFORM 7210-FETCH-FIN-WO-ACTN-CURSOR THRU 7210-EXIT      
           END-PERFORM.                                                 
C30169                                                                  
C30169                                                                  
C30169 2600-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                         
C30169******************************************************************        
C30169*2670-SET-EDIT-IND-FLAG                                          *        
C30169******************************************************************        
C30169*                                                                         
C30169 2670-SET-EDIT-IND-FLAG.                                          
C30169*                                                                         
C30169     IF WS-ACTION-TYPE-CD = 'GAXF'  OR                            
C30169        WS-ACTION-TYPE-CD = '90303' OR                            
C30169        WS-ACTION-TYPE-CD = 'WO'    OR                            
C30169        WS-ACTION-TYPE-CD = '1PLMT' OR                            
C30169        WS-ACTION-TYPE-CD = '2PLMT' OR                            
C30169        WS-ACTION-TYPE-CD = '3PLMT' OR                            
C30169        WS-ACTION-TYPE-CD = 'ATY'   OR                            
C30169        WS-ACTION-TYPE-CD = 'SAL'   OR                            
C30169        WS-ACTION-TYPE-CD = 'AXFR4' OR                            
C30169        WS-ACTION-TYPE-CD = 'CREDB'                               
C30169*                                                                         
C30169        IF WS-FIN-WO-ACTION-DT > SPACES                           
C30169*                                                                         
C30169            IF WS-FIN-WO-ACTION-AM > 0                            
C30169               MOVE 'Y'               TO RS-COMPLETED             
C30169               MOVE 'N'               TO RS-EDIT-IND              
C30169               IF WS-ACTION-TYPE-CD = 'WO'                        
C30169                  MOVE 'Y'            TO WS-WO-COMPLETED          
C30169               END-IF                                             
C30169            ELSE                                                  
C30169               MOVE 'N'               TO RS-COMPLETED             
C30169               IF WS-WO-COMPLETED = 'N' AND (                     
C30169                  WS-ACTION-TYPE-CD = '1PLMT' OR                  
C30169                  WS-ACTION-TYPE-CD = '2PLMT' OR                  
C30169                  WS-ACTION-TYPE-CD = '3PLMT' OR                  
C30169                  WS-ACTION-TYPE-CD = 'ATY'   OR                  
C30169                  WS-ACTION-TYPE-CD = 'SAL'   OR                  
C30169                  WS-ACTION-TYPE-CD = 'AXFR4' OR                  
C30169                  WS-ACTION-TYPE-CD = 'CREDB' )                   
C30169                  MOVE 'N'            TO RS-EDIT-IND              
C30169               ELSE                                               
C30169                  MOVE 'Y'            TO RS-EDIT-IND              
C30169            END-IF                                                
C30169*                                                                         
C30169            IF WS-ACTION-TYPE-CD = '90303' AND                    
C30169               FW-GUARANTEED-IND = 'Y'                            
C30169               MOVE 'N'               TO RS-EDIT-IND              
C30169            END-IF                                                
C30169        END-IF                                                    
C30169     END-IF
           END-IF.                                                      
C30169*                                                                         
P00599     IF WS-ACTION-TYPE-CD = '90307' OR '90205'                    
P00599        IF WS-FW-PROCESSED-FL = 'Y' AND WS-FIN-WO-ACTION-AM > 0   
P00599           MOVE 'Y'                   TO RS-COMPLETED             
P00599        END-IF                                                    
P00599     ELSE                                                         
P00599        IF WS-FIN-WO-ACTION-AM > 0                                
P00599           MOVE 'Y'                   TO RS-COMPLETED             
P00599        END-IF                                                    
P00599     END-IF.                                                      
C30169*                                                                         
C30169 2670-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                         
      ******************************************************************        
T21886* 7050-SELECT-CURRENT-DATE .                                     *05330000
T21886******************************************************************05330000
                                                                        
T21886 7050-SELECT-CURRENT-DATE .                                       
                                                                        
            EXEC SQL                                                    
T30169        SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                       
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*     EXEC SQL                                                            
MFA-TR*       SET :WS-CURRENT-DATE = CURRENT DATE                               
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
T21886      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
T21886         NEXT SENTENCE                                            
T21886      ELSE                                                        
T21886         MOVE PROGRAM-NAME    TO ABEND-PROGRAM                    
T21886         MOVE '7050'          TO ACTIVE-PARAGRAPH                 
T35434         MOVE 'SET'                TO ABEND-FUNCTION              
T21886         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
T21886         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
T21886      END-IF.                                                     
                                                                        
T21886 7050-EXIT.                                                       
T21886        EXIT.                                                     
C30169******************************************************************        
C30169*7100-SELECT-FINAL-WO                                            *05330000
C30169******************************************************************05330000
C30169 7100-SELECT-FINAL-WO.                                            
C30169                                                                  
C30169     EXEC SQL                                                     
C30169        SELECT                                                    
C30169             A.FINAL_BILL_AM                                      
C30169            ,A.FINAL_BILL_DT                                      
C30169            ,A.ITEM_ID                                            
C30169            ,A.GUARANTEED_IND                                     
C30169            ,A.FW_PATH_TYPE_CD                                    
C30169            ,A.COLLECT_STATUS_CD                                  
C30169        INTO                                                      
C30169             :FW-FINAL-BILL-AM                                    
C30169            ,:FW-FINAL-BILL-DT :WS-DATE-NULL-IND11                 
C30169            ,:FW-ITEM-ID                                          
C30169            ,:FW-GUARANTEED-IND                                   
C30169            ,:FW-FW-PATH-TYPE-CD                                  
C30169            ,:FW-COLLECT-STATUS-CD                                
C30169        FROM                                                      
C30169            CSS_FINAL_WO A WITH(READUNCOMMITTED)                          
C30169        WHERE                                                     
C30169            ACCOUNT_NO = :WS-ACCOUNT-NO-NUM                       
C30169        AND ITEM_ID    = 0                                        
C30169                                                           
C30169                                                                  
C30169     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*            A.FINAL_BILL_AM                                              
MFA-TR*           ,A.FINAL_BILL_DT                                              
MFA-TR*           ,A.ITEM_ID                                                    
MFA-TR*           ,A.GUARANTEED_IND                                             
MFA-TR*           ,A.FW_PATH_TYPE_CD                                            
MFA-TR*           ,A.COLLECT_STATUS_CD                                          
MFA-TR*       INTO                                                              
MFA-TR*            :FW-FINAL-BILL-AM                                            
MFA-TR*           ,:FW-FINAL-BILL-DT:WS-DATE-NULL-IND11                         
MFA-TR*           ,:FW-ITEM-ID                                                  
MFA-TR*           ,:FW-GUARANTEED-IND                                           
MFA-TR*           ,:FW-FW-PATH-TYPE-CD                                          
MFA-TR*           ,:FW-COLLECT-STATUS-CD                                        
MFA-TR*       FROM                                                              
MFA-TR*           CSS_FINAL_WO A                                                
MFA-TR*       WHERE                                                             
MFA-TR*           ACCOUNT_NO = :WS-ACCOUNT-NO-NUM                               
MFA-TR*       AND ITEM_ID    = 0                                                
MFA-TR*       WITH UR                                                           
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30169                                                                  
C30169     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
C30169                                                                  
C30169     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
C30169        IF WS-DATE-NULL-IND11 < 0                                 
C30169           MOVE SPACES                TO FW-FINAL-BILL-DT         
C30169           MOVE ZERO                  TO WS-DATE-NULL-IND11       
C30169        END-IF                                                    
C30169     ELSE                                                         
C30169        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
C30169        MOVE '7100'                   TO ACTIVE-PARAGRAPH         
C30169        MOVE 'SELECT'                 TO ABEND-FUNCTION           
C30169        MOVE 'CSS_FINAL_WO'           TO TABLE-1                  
C30169        MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
C30169        MOVE WS-ACCOUNT-NO-NUM        TO HOSTVAR-ELEMENT-1        
C30169        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C30169        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C30169     END-IF.                                                      
C30169                                                                  
C30169 7100-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                         
C30169******************************************************************        
C30169*7140-SEL-PATH-TYPE-DESC                                         *        
C30169******************************************************************        
C30169*                                                                         
C30169 7140-SEL-PATH-TYPE-DESC.                                         
C30169*                                                                         
C30169     EXEC SQL                                                     
C30169        SELECT                                                    
C30169             FW_PATH_TYPE_DESC                                    
C30169        INTO                                                      
C30169             :KR-FW-PATH-TYPE-DESC                                
C30169        FROM                                                      
C30169             CSS_FW_FCST_PATH                                     
C30169        WHERE                                                     
                   FW_PATH_TYPE_CD = :FW-FW-PATH-TYPE-CD                
C30169     END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30169*                                                                         
C30169     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE        
C30169*                                                                         
C30169     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C30169        MOVE KR-FW-PATH-TYPE-DESC TO RS-PATH-TYPE-DESC            
C30169     ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
              NEXT SENTENCE                                             
           ELSE                                                         
C30169        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
C30169        MOVE '7140'              TO ACTIVE-PARAGRAPH              
C30169        MOVE 'SELECT'            TO ABEND-FUNCTION                
C30169        MOVE 'CSS_FW_FCST_PATH'  TO TABLE-1                       
C30169        MOVE 'FW_PATH_TYPE_DESC' TO TABLE-ELEMENT-1               
C30169        MOVE FW-FW-PATH-TYPE-CD  TO HOSTVAR-ELEMENT-1             
C30169        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C30169        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C30169     END-IF
           END-IF.                                                      
C30169                                                                  
C30169 7140-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                         
C30169*****************************************************************         
C30169*7160-SELECT-ACCOUNT-STATUS.                                    *         
C30169*****************************************************************         
C30169*                                                                         
C30169 7160-SELECT-ACCOUNT-STATUS.                                      
C30169*                                                                         
C30169     EXEC SQL                                                     
C30169        SELECT                                                    
C30169            CODE_ACCT_STAT                                        
C30169        INTO                                                      
C30169            :AT-CODE-ACCT-STAT                                    
C30169        FROM                                                      
C30169            CSS_ACCOUNT                                           
C30169        WHERE                                                     
C30169            ACCOUNT_NO = :WS-ACCOUNT-NO-NUM                       
C30169     END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30169*                                                                         
C30169     MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
C30169*                                                                         
C30169     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C30169        MOVE AT-CODE-ACCT-STAT  TO RS-CODE-ACCT-STAT              
C30169     ELSE                                                         
C30169        MOVE PROGRAM-NAME       TO ABEND-PROGRAM                  
C30169        MOVE '7160'             TO ACTIVE-PARAGRAPH               
C30169        MOVE 'SELECT'           TO ABEND-FUNCTION                 
C30169        MOVE 'CSS_ACOUNT'       TO TABLE-1                        
C30169        MOVE 'CODE_ACCT_STAT'   TO TABLE-ELEMENT-1                
C30169        MOVE WS-ACCOUNT-NO-NUM  TO HOSTVAR-ELEMENT-1              
C30169        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C30169        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C30169     END-IF.                                                      
C30169                                                                  
C30169 7160-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                         
C30169*****************************************************************         
C30169*7200-OPEN-FINAL-WO-CURSOR                                      *         
C30169*****************************************************************         
C30169*                                                                         
C30169 7200-OPEN-FINAL-WO-CURSOR.                                       
C30169*                                                                         
C30169     EXEC SQL                                                     
C30169        OPEN FINAL_WO_ACTN                                        
C30169     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30169                                                                  
C30169     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
C30169*                                                                         
C30169     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C30169           NEXT SENTENCE                                          
C30169     ELSE                                                         
C30169         MOVE SPACES              TO ABEND-TABLES                 
C30169         MOVE SPACES              TO ABEND-SQL-PREDICATES         
C30169         MOVE '7200'              TO ACTIVE-PARAGRAPH             
C30169         MOVE PROGRAM-NAME        TO ABEND-PROGRAM                
C30169         MOVE 'OPEN'              TO ABEND-FUNCTION               
C30169         MOVE 'CSS_FIN_WO_ACTION' TO TABLE-1                      
C30169         MOVE 'FW_ACTION_DT'      TO TABLE-ELEMENT-1              
C30169         MOVE  WS-ACCOUNT-NO-NUM  TO HOSTVAR-ELEMENT-1            
C30169         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
C30169         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
C30169     END-IF.                                                      
C30169                                                                  
C30169                                                                  
C30169 7200-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                         
C30169*****************************************************************         
C30169*7210-FETCH-FIN-WO-ACTN-CURSOR                                  *         
C30169*****************************************************************         
C30169*                                                                         
C30169 7210-FETCH-FIN-WO-ACTN-CURSOR.                                   
C30169*                                                                         
C30169     MOVE SPACES                     TO WS-ACTION-COMMENT-TEXT.   
C30169*                                                                         
C30169     EXEC SQL                                                     
C30169        FETCH                                                     
C30169             FINAL_WO_ACTN                                        
C30169        INTO                                                      
C30169             :WS-FIN-WO-ACTION-DT                                 
C30169            ,:WS-FIN-WO-ACTION-AM                                 
C30169            ,:WS-ACTION-TYPE-CD                                   
C30169            ,:WS-ACTION-COMMENT                                   
C30169            ,:WS-FIN-WO-MANUAL-IND                                
C30169            ,:WS-FW-SEQ-NO                                        
P00599            ,:WS-FW-PROCESSED-FL                                  
C30169            ,:WS-IZ-ACTION-TYPE-CD :WS-IZ-ACTION-TYPE-CD-NULL      
C30169            ,:WS-IZ-WITHDRAW-DT :WS-IZ-WITHDRAW-DT-NULL            
C30169            ,:WS-IZ-WITHDRAW-AM :WS-IZ-WITHDRAW-AM-NULL            
C30169            ,:WS-IZ-COLLEC-AGNCY-CD :WS-IZ-COLL-AGNCY-CD-NULL      
C30169            ,:WS-IZ-COLL-AGY-SUB-CD :WS-IZ-COLL-AGY-SUB-CD-NULL    
C30169            ,:WS-IZ-WITHDRAW-REASON-CD :WS-IZ-WD-RSN-CD-NULL       
C30169     END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30169*                                                                         
C30169     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE     
C30169*                                                                         
C30169     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C30169        IF WS-IZ-ACTION-TYPE-CD-NULL < 0 THEN                     
C30169           MOVE ZERO                 TO WS-IZ-ACTION-TYPE-CD-NULL 
C30169           MOVE SPACE                TO WS-IZ-ACTION-TYPE-CD      
C30169        END-IF                                                    
C30169        IF WS-IZ-WITHDRAW-DT-NULL < 0 THEN                        
C30169           MOVE ZERO                 TO WS-IZ-WITHDRAW-DT-NULL    
C30169           MOVE SPACE                TO WS-IZ-WITHDRAW-DT         
C30169        END-IF                                                    
C30169        IF WS-IZ-WITHDRAW-AM-NULL < 0 THEN                        
C30169           MOVE ZERO                 TO WS-IZ-WITHDRAW-AM-NULL    
C30169           MOVE ZERO                 TO WS-IZ-WITHDRAW-AM         
C30169        END-IF                                                    
C30169        IF WS-IZ-COLL-AGNCY-CD-NULL < 0 THEN                      
C30169           MOVE ZERO                 TO WS-IZ-COLL-AGNCY-CD-NULL  
C30169           MOVE SPACE                TO WS-IZ-COLLEC-AGNCY-CD     
C30169        END-IF                                                    
C30169        IF WS-IZ-COLL-AGY-SUB-CD-NULL < 0 THEN                    
C30169           MOVE ZERO                 TO WS-IZ-COLL-AGY-SUB-CD-NULL
C30169           MOVE SPACE                TO WS-IZ-COLL-AGY-SUB-CD     
C30169        END-IF                                                    
C30169        IF WS-IZ-WD-RSN-CD-NULL       < 0 THEN                    
C30169           MOVE ZERO                 TO WS-IZ-WD-RSN-CD-NULL      
C30169           MOVE SPACE                TO WS-IZ-WITHDRAW-REASON-CD  
C30169        END-IF                                                    
C30169     ELSE                                                         
C30169        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
C30169            SET NO-MORE-ROWS         TO TRUE                      
C30169            PERFORM 7350-CLOSE-FINAL-WO-ACTN-CSR THRU 7350-EXIT   
C30169        ELSE                                                      
C30169           MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
C30169           MOVE '7210'               TO ACTIVE-PARAGRAPH          
C30169           MOVE 'FETCH'              TO ABEND-FUNCTION            
C30169           MOVE 'CSS_FINAL_WO_ACTN'  TO TABLE-1                   
C30169           MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1           
C30169           MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1         
C30169           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
C30169           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
C30169        END-IF                                                    
C30169     END-IF.                                                      
C30169                                                                  
C30169 7210-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                         
C30169*****************************************************************         
C30169*7225-PROCESS-RESULT-ROW.                                       *         
C30169*****************************************************************         
C30169*                                                                         
C30169 7225-PROCESS-RESULT-ROW.                                         
C30169*                                                                         
C30169     MOVE 'N'                         TO RS-EDIT-IND.             
C30169     MOVE 'N'                         TO RS-COMPLETED.            
C30169                                                                  
C30169     MOVE WS-CRED-EXEMPT-FL           TO RS-CRED-EXMPT-FL         
C30169     MOVE WS-CA-EXEMPT-FL             TO RS-CA-EXEMPT-FL          
C30169     MOVE WS-FIN-WO-MANUAL-IND        TO RS-MANUAL-IND            
C30169     MOVE WS-FW-SEQ-NO                TO RS-FW-SEQ-NO             
C30169     MOVE WS-IZ-COLLEC-AGNCY-CD       TO RS-CODE-COLLEC-AGNCY     
C30169     MOVE WS-IZ-COLL-AGY-SUB-CD       TO RS-COLL-AGY-SUB-CD       
C30169     MOVE WS-ACTION-COMMENT           TO RS-INVEST-COMMENT        
C30169                                                                  
C30169     IF WS-ACTION-COMMENT-TEXT = SPACES                           
C30169        MOVE 'N' TO RS-INVEST-IND                                 
C30169     ELSE                                                         
C30169        MOVE 'Y' TO RS-INVEST-IND                                 
C30169     END-IF                                                       
C30169                                                                  
C30169     PERFORM 2670-SET-EDIT-IND-FLAG   THRU 2670-EXIT              
C30169                                                                  
C30169     MOVE WS-FIN-WO-ACTION-DT(6:2)    TO RS-DATE(1:2)             
C30169     MOVE WS-FIN-WO-ACTION-DT(9:2)    TO RS-DATE(3:2)             
C30169     MOVE WS-FIN-WO-ACTION-DT(1:4)    TO RS-DATE(5:4)             
C30169     MOVE WS-FIN-WO-ACTION-AM         TO RS-BALANCE               
C30169     MOVE WS-ACTION-TYPE-CD           TO RS-ACTION                
C30169                                                                  
C30169     IF WS-ACTION-TYPE-CD = WS-IZ-ACTION-TYPE-CD AND              
C30169        WS-IZ-WITHDRAW-DT NOT = SPACES                            
C30169                                                                  
C30169        PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT             
C30169        PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
C30169                                                                  
C30169        MOVE 'N'                         TO RS-EDIT-IND           
C30169        MOVE 'N'                         TO RS-COMPLETED          
C30169        MOVE WS-IZ-WITHDRAW-DT           TO WS-FIN-WO-ACTION-DT   
C30169        MOVE WS-IZ-WITHDRAW-AM           TO WS-FIN-WO-ACTION-AM   
C30169        PERFORM 2670-SET-EDIT-IND-FLAG   THRU 2670-EXIT           
C30169                                                                  
C30169        IF WS-IZ-WITHDRAW-DT < WS-CURRENT-DATE AND                
C30169           RS-BALANCE        > 0               AND                
C30169           WS-IZ-WITHDRAW-AM = 0               AND                
C30169           WS-IZ-WITHDRAW-REASON-CD > SPACES                      
C30169           MOVE 'N'                   TO RS-EDIT-IND              
C30169           MOVE 'Y'                   TO RS-COMPLETED             
C30169        END-IF                                                    
C30169                                                                  
C30169        MOVE WS-IZ-WITHDRAW-AM        TO RS-BALANCE               
C30169        MOVE WS-IZ-WITHDRAW-DT(6:2)   TO RS-DATE(1:2)             
C30169        MOVE WS-IZ-WITHDRAW-DT(9:2)   TO RS-DATE(3:2)             
C30169        MOVE WS-IZ-WITHDRAW-DT(1:4)   TO RS-DATE(5:4)             
C30169                                                                  
C30169        EVALUATE WS-ACTION-TYPE-CD                                
C30169           WHEN '1PLMT'                                           
C30169               MOVE '1PLWD'           TO RS-ACTION                
C30169           WHEN '2PLMT'                                           
C30169               MOVE '2PLWD'           TO RS-ACTION                
C30169           WHEN '3PLMT'                                           
C30169               MOVE '3PLWD'           TO RS-ACTION                
C30169           WHEN 'ATY'                                             
C30169               MOVE 'ATYWD'           TO RS-ACTION                
C30169        END-EVALUATE                                              
C30169                                                                  
C30169     END-IF.                                                      
C30169                                                                  
C30169     PERFORM 2000A-MOVE-RESULT        THRU 2000A-EXIT.            
C30169     PERFORM 8100-SEND-RESULT         THRU 8100-EXIT.             
C30169                                                                  
C30169 7225-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                         
C30169******************************************************************        
C30169*7330-SELECT-CREDIT-EXEMPT-FLAG                                  *        
C30169******************************************************************        
C30169*                                                                         
C30169 7330-SELECT-CREDIT-EXEMPT-FLAG.                                  
C30169*                                                                         
C30169     EXEC SQL                                                     
C30169                                                                  
C30169        SELECT                                                    
C30169            ATTRIBUTE_VALUE_CD                                    
C30169        INTO                                                      
C30169            :WS-CRED-EXEMPT-FL                                    
C30169        FROM                                                      
C30169            CSS_ACCT_ATTRIBUTE                                    
C30169        WHERE                                                     
C30169            ATTRIBUTE_DESC = 'CBEXEMPT'                           
C30169        AND ACCOUNT_NO = :WS-ACCOUNT-NO-NUM                       
C30169                                                                  
C30169     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30169                                                                  
C30169     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
C30169*                                                                         
C30169     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C30169         MOVE WS-CRED-EXEMPT-FL     TO RS-CRED-EXMPT-FL           
C30169     ELSE                                                         
C30169        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
C30169           NEXT SENTENCE                                          
C30169        END-IF                                                    
C30169        MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
C30169        MOVE '7330'          TO ACTIVE-PARAGRAPH                  
C30169        MOVE 'SELECT'             TO ABEND-FUNCTION               
C30169        MOVE 'CSS_ACCT_ATTRIBUTE' TO TABLE-1                      
C30169        MOVE 'ATTRIBUTE_VALUE_TX' TO TABLE-ELEMENT-1              
C30169        MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
C30169        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C30169        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C30169     END-IF.                                                      
C30169 7330-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                         
C30169******************************************************************        
C30169*7335-SELECT-CA-EXEMPT-FLAG.                                     *        
C30169******************************************************************        
C30169*                                                                         
C30169 7335-SELECT-CA-EXEMPT-FLAG.                                      
C30169*                                                                         
C30169     EXEC SQL                                                     
C30169                                                                  
C30169        SELECT                                                    
C30169            ATTRIBUTE_VALUE_CD                                    
C30169        INTO                                                      
C30169            :WS-CA-EXEMPT-FL                                      
C30169        FROM                                                      
C30169            CSS_ACCT_ATTRIBUTE                                    
C30169        WHERE                                                     
C30169            ATTRIBUTE_DESC = 'CAEXEMPT'                           
C30169        AND ACCOUNT_NO = :WS-ACCOUNT-NO-NUM                       
C30169                                                                  
C30169     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30169*                                                                         
C30169     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
C30169*                                                                         
C30169     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C30169         MOVE WS-CA-EXEMPT-FL         TO RS-CA-EXEMPT-FL          
C30169     ELSE                                                         
C30169        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
C30169           NEXT SENTENCE                                          
C30169        END-IF                                                    
C30169        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
C30169        MOVE '7335'                   TO ACTIVE-PARAGRAPH         
C30169        MOVE 'SELECT'                 TO ABEND-FUNCTION           
C30169        MOVE 'CSS_ACCT_ATTRIBUTE'     TO TABLE-1                  
C30169        MOVE 'ATTRIBUTE_VALUE_TX'     TO TABLE-ELEMENT-1          
C30169        MOVE WS-ACCOUNT-NO-NUM        TO HOSTVAR-ELEMENT-1        
C30169        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C30169        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C30169     END-IF.                                                      
C30169                                                                  
C30169 7335-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                         
C30169*****************************************************************         
C30169*7350-CLOSE-FINAL-WO-ACTN-CSR.                                   *        
C30169*****************************************************************         
C30169*                                                                         
C30169 7350-CLOSE-FINAL-WO-ACTN-CSR.                                    
C30169*                                                                         
C30169                                                                  
C30169     EXEC SQL                                                     
C30169         CLOSE FINAL_WO_ACTN                                      
C30169     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30169                                                                  
C30169     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
C30169*                                                                         
C30169     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C30169           NEXT SENTENCE                                          
C30169     ELSE                                                         
C30169         MOVE SPACES              TO ABEND-TABLES                 
C30169         MOVE SPACES              TO ABEND-SQL-PREDICATES         
C30169         MOVE '7350'              TO ACTIVE-PARAGRAPH             
C30169         MOVE PROGRAM-NAME        TO ABEND-PROGRAM                
C30169         MOVE 'CLOSE'             TO ABEND-FUNCTION               
C30169         MOVE 'CSS_FIN_WO_ACTION' TO TABLE-1                      
C30169         MOVE 'FW_ACTION_DT'      TO TABLE-ELEMENT-1              
C30169         MOVE  WS-ACCOUNT-NO-NUM  TO HOSTVAR-ELEMENT-1            
C30169         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
C30169         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
C30169     END-IF.                                                      
C30169                                                                  
C30169 7350-EXIT.                                                       
C30169     EXIT.                                                        
C30169                                                                  
      ******************************************************************        
      * 7400-SELECT-ACCOUNT-DATA.                                      *        
      ******************************************************************        
                                                                        
       7400-SELECT-ACCOUNT-DATA.                                        
               EXEC SQL                                                 
                  SELECT ACCOUNT_NO,                                    
                         CODE_ACCT_STAT,                                
PCR395                   CODE_STATUS_REASON,                            
PCR395                   REPLACE(REPLACE(CONVERT(CHAR(26), 
           ACCT_FINALED_DT, 121), ' ', '-'), ':', '.') ACCT_FINALED_DT,        
                         ADDRESS_ID,                                    
                         PREMISE_NO,                                    
PCR395                   TOTAL_AR_BALANCE,                              
                         NOTICE_EXEMPT_CD,                              
                         CODE_DISC_OK,                                  
                         DATE_BILL_DAY_00,                              
                         DATE_BILL_DAY_30,                              
                         DATE_BILL_DAY_60,                              
                         DATE_BILL_DAY_90,                              
                         CODES_DATA_PRESENT,                            
                         COMPANY_NO,                                    
                         LOCAL_OFFICE,                                  
                         BANKRUPTCY_IND,                                
                         CREDIT_GROUP,                                  
C28788                   IVR_EXEMPT_CD                                  
                  INTO  :AT-ACCOUNT-NO,                                 
                        :AT-CODE-ACCT-STAT,                             
PCR395                  :AT-CODE-STATUS-REASON,                         
PCR395                  :AT-ACCT-FINALED-DT :WS-DT-NULL-IND,             
                        :AT-ADDRESS-ID,                                 
                        :AT-PREMISE-NO,                                 
PCR395                  :AT-TOTAL-AR-BALANCE,                           
                        :AT-NOTICE-EXEMPT-CD,                           
                        :AT-CODE-DISC-OK,                               
                        :AT-DATE-BILL-DAY-00 :WS-DATE-BILL-DAY-00-NULL, 
                        :AT-DATE-BILL-DAY-30 :WS-DATE-BILL-DAY-30-NULL, 
                        :AT-DATE-BILL-DAY-60 :WS-DATE-BILL-DAY-60-NULL, 
                        :AT-DATE-BILL-DAY-90 :WS-DATE-BILL-DAY-90-NULL, 
                        :AT-CODES-DATA-PRESENT,                         
                        :AT-COMPANY-NO,                                 
                        :AT-LOCAL-OFFICE,                               
                        :AT-BANKRUPTCY-IND,                             
                        :AT-CREDIT-GROUP,                               
C28788                  :AT-IVR-EXEMPT-CD                               
                  FROM   CSS_ACCOUNT WITH(READUNCOMMITTED)                      
                  WHERE  ACCOUNT_NO = :WS-ACCOUNT-NO-NUM                
T35434                                                           
               END-EXEC.                                                

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*        EXEC SQL                                                         
MFA-TR*           SELECT ACCOUNT_NO,                                            
MFA-TR*                  CODE_ACCT_STAT,                                        
MFA-TR*                  CODE_STATUS_REASON,                                    
MFA-TR*                  ACCT_FINALED_DT,                                       
MFA-TR*                  ADDRESS_ID,                                            
MFA-TR*                  PREMISE_NO,                                            
MFA-TR*                  TOTAL_AR_BALANCE,                                      
MFA-TR*                  NOTICE_EXEMPT_CD,                                      
MFA-TR*                  CODE_DISC_OK,                                          
MFA-TR*                  DATE_BILL_DAY_00,                                      
MFA-TR*                  DATE_BILL_DAY_30,                                      
MFA-TR*                  DATE_BILL_DAY_60,                                      
MFA-TR*                  DATE_BILL_DAY_90,                                      
MFA-TR*                  CODES_DATA_PRESENT,                                    
MFA-TR*                  COMPANY_NO,                                            
MFA-TR*                  LOCAL_OFFICE,                                          
MFA-TR*                  BANKRUPTCY_IND,                                        
MFA-TR*                  CREDIT_GROUP,                                          
MFA-TR*                  IVR_EXEMPT_CD                                          
MFA-TR*           INTO  :AT-ACCOUNT-NO,                                         
MFA-TR*                 :AT-CODE-ACCT-STAT,                                     
MFA-TR*                 :AT-CODE-STATUS-REASON,                                 
MFA-TR*                 :AT-ACCT-FINALED-DT:WS-DT-NULL-IND,                     
MFA-TR*                 :AT-ADDRESS-ID,                                         
MFA-TR*                 :AT-PREMISE-NO,                                         
MFA-TR*                 :AT-TOTAL-AR-BALANCE,                                   
MFA-TR*                 :AT-NOTICE-EXEMPT-CD,                                   
MFA-TR*                 :AT-CODE-DISC-OK,                                       
MFA-TR*                 :AT-DATE-BILL-DAY-00 :WS-DATE-BILL-DAY-00-NULL,         
MFA-TR*                 :AT-DATE-BILL-DAY-30 :WS-DATE-BILL-DAY-30-NULL,         
MFA-TR*                 :AT-DATE-BILL-DAY-60 :WS-DATE-BILL-DAY-60-NULL,         
MFA-TR*                 :AT-DATE-BILL-DAY-90 :WS-DATE-BILL-DAY-90-NULL,         
MFA-TR*                 :AT-CODES-DATA-PRESENT,                                 
MFA-TR*                 :AT-COMPANY-NO,                                         
MFA-TR*                 :AT-LOCAL-OFFICE,                                       
MFA-TR*                 :AT-BANKRUPTCY-IND,                                     
MFA-TR*                 :AT-CREDIT-GROUP,                                       
MFA-TR*                 :AT-IVR-EXEMPT-CD                                       
MFA-TR*           FROM   CSS_ACCOUNT                                            
MFA-TR*           WHERE  ACCOUNT_NO = :WS-ACCOUNT-NO-NUM                        
MFA-TR*           WITH UR                                                       
MFA-TR*        END-EXEC.                                                        

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-DATE-BILL-DAY-00-NULL < 0                           
                  MOVE SPACES   TO AT-DATE-BILL-DAY-00                  
              END-IF                                                    
              IF WS-DATE-BILL-DAY-30-NULL < 0                           
                  MOVE SPACES   TO AT-DATE-BILL-DAY-30                  
              END-IF                                                    
              IF WS-DATE-BILL-DAY-60-NULL < 0                           
                  MOVE SPACES   TO AT-DATE-BILL-DAY-60                  
              END-IF                                                    
              IF WS-DATE-BILL-DAY-90-NULL < 0                           
                  MOVE SPACES   TO AT-DATE-BILL-DAY-90                  
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7400'                TO ACTIVE-PARAGRAPH            
CBSI          MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE WS-ACCOUNT-NO-NUM     TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7700-SELECT-PREMISE-ADDR                                      *         
      ******************************************************************        
                                                                        
       7700-SELECT-PREMISE-ADDR.                                        
               EXEC SQL                                                 
                  SELECT ADDRESS_ID                                     
                  INTO  :PR-ADDRESS-ID                                  
                  FROM   CSS_PREMISE WITH(READUNCOMMITTED)                      
                  WHERE  PREMISE_NO = :AT-PREMISE-NO                    
T35434                                                           
               END-EXEC.                                                

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*        EXEC SQL                                                         
MFA-TR*           SELECT ADDRESS_ID                                             
MFA-TR*           INTO  :PR-ADDRESS-ID                                          
MFA-TR*           FROM   CSS_PREMISE                                            
MFA-TR*           WHERE  PREMISE_NO = :AT-PREMISE-NO                            
MFA-TR*           WITH UR                                                       
MFA-TR*        END-EXEC.                                                        

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7700'               TO ACTIVE-PARAGRAPH             
CBSI          MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_PREMISE'        TO TABLE-1                      
              MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE AT-PREMISE-NO        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7900-CHECK-OFF-CYCLE.                                          *        
      ******************************************************************        
                                                                        
       7900-CHECK-OFF-CYCLE.                                            
               EXEC SQL                                                 
                  SELECT ACCOUNT_NO                                     
                  INTO  :OC-ACCOUNT-NO                                  
                  FROM   CSS_OFF_CYCL_ACCT WITH(READUNCOMMITTED)                
                  WHERE  ACCOUNT_NO = :WS-ACCOUNT-NO-NUM                
T35434                                                           
               END-EXEC.                                                

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*        EXEC SQL                                                         
MFA-TR*           SELECT ACCOUNT_NO                                             
MFA-TR*           INTO  :OC-ACCOUNT-NO                                          
MFA-TR*           FROM   CSS_OFF_CYCL_ACCT                                      
MFA-TR*           WHERE  ACCOUNT_NO = :WS-ACCOUNT-NO-NUM                        
MFA-TR*           WITH UR                                                       
MFA-TR*        END-EXEC.                                                        

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
T19854                                OR -811                           
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7900'                TO ACTIVE-PARAGRAPH            
CBSI          MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE 'CSS_OFF_CYCL_ACCT'   TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE WS-ACCOUNT-NO-NUM     TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7900-EXIT.                                                       
           EXIT.                                                        
REARCH*                                                                         
REARCH******************************************************************        
REARCH*  8000A-DELETE-GTT-ROWS                                         *        
REARCH******************************************************************        
REARCH*                                                                         
REARCH 8000A-DELETE-GTT-ROWS.                                           
REARCH*                                                                         
REARCH      MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.         
REARCH*                                                                         
REARCH      EXEC SQL                                                    
REARCH          DELETE FROM #CSR02240_R1                         
REARCH      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR02240_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH      MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
REARCH*                                                                         
REARCH      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
REARCH         NEXT SENTENCE                                            
REARCH      ELSE                                                        
REARCH         MOVE PROGRAM-NAME          TO  ABEND-PROGRAM             
REARCH         MOVE '8000A'               TO  ACTIVE-PARAGRAPH          
REARCH         MOVE 'DELETE'              TO  ABEND-FUNCTION            
REARCH         MOVE SQLCODE               TO  ABEND-SQLCODE             
REARCH         MOVE SPACES                TO  ABEND-SQL-PREDICATES      
REARCH                                        ABEND-TABLES              
REARCH         MOVE 'CSR02240_R1'         TO  TABLE-1                   
REARCH         MOVE SPACES                TO  TABLE-ELEMENT-1           
REARCH         MOVE SPACES                TO  HOSTVAR-ELEMENT-1         
REARCH         PERFORM 9000-SEND-ERROR-RESULT                           
REARCH                                    THRU 9000-EXIT                
REARCH         PERFORM 9900-SQL-ERROR-ROUTINE                           
REARCH                                    THRU 9900-EXIT                
REARCH      END-IF.                                                     
REARCH*                                                                         
REARCH 8000A-EXIT.                                                      
REARCH      EXIT.                                                       
REARCH*                                                                         
REARCH******************************************************************        
REARCH*  8100-SEND-RESULT                                              *        
REARCH******************************************************************        
REARCH 8100-SEND-RESULT.                                                
REARCH                                                                  
REARCH     EXEC SQL                                                     
REARCH          INSERT INTO #CSR02240_R1                         
REARCH          (                                                       
REARCH                RETURN_CODE                                       
REARCH               ,DATE                                              
REARCH               ,ACTION                                            
REARCH               ,BALANCE                                           
REARCH               ,ITEM_ID                                           
REARCH               ,FINAL_BALANCE                                     
REARCH               ,INVEST_IND                                        
REARCH               ,DNP_IND                                           
REARCH               ,ITEM_DESC                                         
REARCH               ,ACTIV_ACCT_IND                                    
REARCH               ,SPCL_BILL_IND                                     
REARCH               ,INVEST_CMNT_TEXT                                  
REARCH               ,FLAG_IND                                          
REARCH               ,BILLED_BALANCE                                    
REARCH               ,EDIT_IND                                          
REARCH               ,COMPLETED                                         
REARCH               ,GUARANTEED_IND                                    
REARCH               ,OFF_CYCLE                                         
REARCH               ,CRED_EXMPT_FL                                     
REARCH               ,BUS_DT                                            
C30169               ,CA_EXEMPT_FL                                      
C30169               ,MANUAL_IND                                        
C30169               ,FW_SEQ_NO                                         
C30169               ,CODE_COLLEC_AGNCY                                 
C30169               ,CODE_ACCT_STAT                                    
C30169               ,COLL_PATH_TYPE_CD                                 
C30169               ,COLL_PATH_TYP_DESC                                
C30169               ,ORIG_DATE                                         
C30169               ,COLLECT_STATUS_CD                                 
REARCH          )                                                       
REARCH          VALUES                                                  
REARCH          (                                                       
REARCH                :S-RETURN-CODE                                    
REARCH               ,:S-DATE                                           
REARCH               ,:S-ACTION                                         
REARCH               ,:S-BALANCE                                        
REARCH               ,:S-ITEM-ID                                        
REARCH               ,:S-FINAL-BALANCE                                  
REARCH               ,:S-INVEST-IND                                     
REARCH               ,:S-DNP-IND                                        
REARCH               ,:S-ITEM-DESC                                      
REARCH               ,:S-ACTIV-ACCT-IND                                 
REARCH               ,:S-SPCL-BILL-IND                                  
REARCH               ,:S-INVEST-COMMENT-TEXT                            
REARCH               ,:S-FLAG-IND                                       
REARCH               ,:S-BILLED-BALANCE                                 
REARCH               ,:S-EDIT-IND                                       
REARCH               ,:S-COMPLETED                                      
REARCH               ,:S-GUARANTEED-IND                                 
REARCH               ,:S-OFF-CYCLE                                      
REARCH               ,:S-CRED-EXMPT-FL                                  
REARCH               ,:S-BUS-DT                                         
C30169               ,:S-CA-EXEMPT-FL                                   
C30169               ,:S-MANUAL-IND                                     
C30169               ,:S-FW-SEQ-NO                                      
C30169               ,:S-CODE-COLLEC-AGNCY                              
C30169               ,:S-CODE-ACCT-STAT                                 
C30169               ,:S-PATH-TYPE-CD                                   
C30169               ,:S-PATH-TYPE-DESC                                 
C30169               ,:S-ORIG-DATE                                      
C30169               ,:S-COLLECT-STATUS-CD                              
REARCH           )                                                      
REARCH      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR02240_R1                                 
MFA-TR*         (                                                               
MFA-TR*               RETURN_CODE                                               
MFA-TR*              ,DATE                                                      
MFA-TR*              ,ACTION                                                    
MFA-TR*              ,BALANCE                                                   
MFA-TR*              ,ITEM_ID                                                   
MFA-TR*              ,FINAL_BALANCE                                             
MFA-TR*              ,INVEST_IND                                                
MFA-TR*              ,DNP_IND                                                   
MFA-TR*              ,ITEM_DESC                                                 
MFA-TR*              ,ACTIV_ACCT_IND                                            
MFA-TR*              ,SPCL_BILL_IND                                             
MFA-TR*              ,INVEST_CMNT_TEXT                                          
MFA-TR*              ,FLAG_IND                                                  
MFA-TR*              ,BILLED_BALANCE                                            
MFA-TR*              ,EDIT_IND                                                  
MFA-TR*              ,COMPLETED                                                 
MFA-TR*              ,GUARANTEED_IND                                            
MFA-TR*              ,OFF_CYCLE                                                 
MFA-TR*              ,CRED_EXMPT_FL                                             
MFA-TR*              ,BUS_DT                                                    
MFA-TR*              ,CA_EXEMPT_FL                                              
MFA-TR*              ,MANUAL_IND                                                
MFA-TR*              ,FW_SEQ_NO                                                 
MFA-TR*              ,CODE_COLLEC_AGNCY                                         
MFA-TR*              ,CODE_ACCT_STAT                                            
MFA-TR*              ,COLL_PATH_TYPE_CD                                         
MFA-TR*              ,COLL_PATH_TYP_DESC                                        
MFA-TR*              ,ORIG_DATE                                                 
MFA-TR*              ,COLLECT_STATUS_CD                                         
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*               :S-RETURN-CODE                                            
MFA-TR*              ,:S-DATE                                                   
MFA-TR*              ,:S-ACTION                                                 
MFA-TR*              ,:S-BALANCE                                                
MFA-TR*              ,:S-ITEM-ID                                                
MFA-TR*              ,:S-FINAL-BALANCE                                          
MFA-TR*              ,:S-INVEST-IND                                             
MFA-TR*              ,:S-DNP-IND                                                
MFA-TR*              ,:S-ITEM-DESC                                              
MFA-TR*              ,:S-ACTIV-ACCT-IND                                         
MFA-TR*              ,:S-SPCL-BILL-IND                                          
MFA-TR*              ,:S-INVEST-COMMENT-TEXT                                    
MFA-TR*              ,:S-FLAG-IND                                               
MFA-TR*              ,:S-BILLED-BALANCE                                         
MFA-TR*              ,:S-EDIT-IND                                               
MFA-TR*              ,:S-COMPLETED                                              
MFA-TR*              ,:S-GUARANTEED-IND                                         
MFA-TR*              ,:S-OFF-CYCLE                                              
MFA-TR*              ,:S-CRED-EXMPT-FL                                          
MFA-TR*              ,:S-BUS-DT                                                 
MFA-TR*              ,:S-CA-EXEMPT-FL                                           
MFA-TR*              ,:S-MANUAL-IND                                             
MFA-TR*              ,:S-FW-SEQ-NO                                              
MFA-TR*              ,:S-CODE-COLLEC-AGNCY                                      
MFA-TR*              ,:S-CODE-ACCT-STAT                                         
MFA-TR*              ,:S-PATH-TYPE-CD                                           
MFA-TR*              ,:S-PATH-TYPE-DESC                                         
MFA-TR*              ,:S-ORIG-DATE                                              
MFA-TR*              ,:S-COLLECT-STATUS-CD                                      
MFA-TR*          )                                                              
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30169*                                                                         
REARCH*                                                                         
REARCH      MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.      
REARCH*                                                                         
REARCH      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
REARCH          ADD +1                   TO  CTR-ROWS                   
REARCH      ELSE                                                        
REARCH         MOVE PROGRAM-NAME         TO  ABEND-PROGRAM              
REARCH         MOVE SQLCODE              TO  ABEND-SQLCODE              
REARCH         MOVE '8100'               TO  ACTIVE-PARAGRAPH           
REARCH         MOVE 'INSERT'             TO  ABEND-FUNCTION             
REARCH         MOVE SQLCODE              TO  ABEND-SQLCODE              
REARCH         MOVE SPACES               TO  ABEND-SQL-PREDICATES       
REARCH                                       ABEND-TABLES               
REARCH         MOVE 'CSR02240_R1'        TO  TABLE-1                    
REARCH         MOVE SPACES               TO  TABLE-ELEMENT-1            
REARCH         MOVE SPACES               TO  HOSTVAR-ELEMENT-1          
REARCH         PERFORM 9900-SQL-ERROR-ROUTINE                           
REARCH                                   THRU 9900-EXIT                 
REARCH      END-IF.                                                     
REARCH*                                                                         
REARCH  8100-EXIT.                                                      
REARCH      EXIT.                                                       
REARCH*                                                                         
T19557                                                                  
T19557******************************************************************        
T19557*  9500-CALL-CPD00068 :                                          *        
T19557*                       CALLS THE SCSCSO068                      *        
T19557******************************************************************        
T19557 9500-CALL-CPD00068.                                              
REARCH*                                                                         
REARCH     CALL MCSCB068  USING  CWS00068-FIELDS                        
REARCH                           WS-CODES-DATA-PRESENT                  
REARCH                           DCLCSS-ACCOUNT                         
REARCH                           ABEND-FILE                             
REARCH                           RS-RETURN-CODE.                        
REARCH     MOVE RS-RETURN-CODE            TO WS-ACTIVE-RETURN-CODE,     
REARCH                                       S-RETURN-CODE.             
REARCH     IF ABEND-FUNCTION  > SPACES                                  
REARCH        IF ABEND-FUNCTION EQUAL 'BADDATA'                         
REARCH           MOVE -1                  TO S-RETURN-CODE,             
REARCH                                       WS-ACTIVE-RETURN-CODE      
REARCH        END-IF                                                    
REARCH        PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT             
REARCH        PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
REARCH     END-IF.                                                      
REARCH*                                                                         
T19557 9500-EXIT.                                                       
T19557     EXIT.                                                        
      *                                                                         
T13685****************************************************************          
      * 9700-PROCESS-ABEND - COMBINED ON-LINE/BATCH ERROR HANDLING.  *          
      ****************************************************************          
              EXEC SQL                                                          
                 INCLUDE CPD0023C                                               
              END-EXEC.                                                         
      *                                                                         
      ******************************************************************05630000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     05640000
      ******************************************************************05650000
           EXEC SQL                                                     05660000
REARCH        INCLUDE CPDSP300                                          05670000
           END-EXEC.                                                    05680000
                                                                        
      ******************************************************************05700000
      *       END PROGRAM COPYLIB                                      *05710000
      ******************************************************************05720000
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPD00320                                                  
REARCH     END-EXEC.                                                            
                                                                        
