       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02233.                                         
COB303 DATE-WRITTEN.  NOVEMBER 3, 1994                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
      *                                                                *00110000
      *  TRANID:        S233                                           *00120000
      *  PROGRAM:       S233                                           *00130000
      *  CALLING SP:    PA_S233                                        *00140000
      *                                                                *00150000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *  THIS PROCEDURE SELECTS BANK DRAFT INFORMATION FROM THE        *00190000
      *  CSS_BANK_EFT TABLE FOR A SPECIFIED ACCOUNT NUMBER.            *00200000
      ******************************************************************00210000
      *                                                                *00220000
      *                     PROGRAM MODIFICATION LOG                   *00230000
      *                                                                *00240000
      *    DATE    INITIALS   COMMENTS                                 *00250000
      *  --------  --------   ---------------------------------------  *00260000
      *  11/03/94    MRB      PROCEDURE ORIGINALLY CODED.              *00270000
      *  06/07/95    TCB ADDED NULL INDICATOR TO PARAGRAPH 7500        *00271000
      *  03/24/97    MKN CHANGED LOGIC TO OBTAIN LAST-DRAFT-DATE       *00272000
      *                  FROM BANK-EFT INSTEAD OF BILL-WINDOW          *00280000
T9700 *  03/31/97    AS  MODIFIED LOGIC TO NOT SELECT BANK DETAIL INFO *00281000
T9700 *                  FROM CSS_BANK FOR A BANK ID OF ZERO.          *00282000
T13293*  10/08/97    GC  NO LONGER NEED TO CALL 7010 IF A MASTER.      *00283002
CBSI  *  08/28/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *              MADRAS   ABEND PARAMETERS                         *        
T19279*  03/03/99    PR  CHANGED DRAFT_CYCLE LIMIT FROM 21 TO 20                
T19279*                                                                         
T20563*  04/06/00   DPS REVISED TO PULL AR BALANCE AMT WHETHER A                
T20563*                 PENDING DRAFT OR NOT.                                   
T20954*  11/16/00   DPS REVISION TO IMPROVE DAY OF MONTH IN DROP DOWN  *        
T20954*                 LIST FOR EARLIEST DRAFT DAY PER CYCLE.                  
T20954*                 PARAGRAPH 7500- REVISED.                                
23549**  03/01/01   DPS EPAY REVISIONS                                          
23549**                                                                         
25954**  05/23/02   DPS ALLOWING DRAFT CYCLE TO POPULATE FOR EPAY               
C23691*  06/05/02   SFH FIXED INVALID DRAFT DATE PROBLEM.                       
C25964*  07/25/02   DPS REVISIONS FOR EDRAFT                                    
C28084*  12/13/02   DPS ADD CYCLE 21 BACK TO DRAFT CYCLES                       
C28084*             ALSO CORRECT PROBLEM WITH DRAFT CYCLE SUGGESTED             
C28084*             BY RPC NOT MATCHING ANY DROP DOWN ENTRY ON PANEL            
      *                                                                         
C29529*  04/09/04   WLR CHANGED SELECT FOR PENDING BANK DRAFT TABLE             
      *             TO A FETCH TO GET ALL PENDING BANK DRAFTS.  ALSO            
      *             ADDED CODE TO GET BANK NICKNAME FOR EPAY PROJECT.           
C32750*  05/18/05   VB81095     MADE CHANGES TO CURSOR TO DISPLAY               
C32750*                         PENDING PAYMENTS FROM CSS_PAYMENT_TRANS         
REARCH*  06/14/05   CVNS        RPC TO COBOL SP CONVERSION                      
REARCH*             CHENNAI                                                     
C34097*  10/23/06   CB18344     PERFORMANCE TUNING CHANGES                      
C36437*  12/13/07   CB18344     RETRIEVE REAL-TIME EPAY BANK                    
C36437*                         TRANSACTIONS FOR REMITTANCE                     
C37782*  10/08/08   CB18344     INITIALIZED JF-BANK-ACCT-NICKNAME               
C37782*                         TO STOP ADDITIONAL CHARACTERS FROM              
C37782*                         BEING ADDED TO END OF BANK NICKNAME             
PRJ547*  03/24/09   CB18344     MADE CHANGES TO STOP S0C7 FOR INVALID           
PRJ547*                         ACCOUNT NUMBER.                                 
PRJ526*  09/22/09   CB18344     MADE CHANGES TO ADD TWO FIELDS TO               
PRJ526*                         RESULT SET FOR RECURRING CC PROJECT.            
A36577*  05/27/10   SV85244     ADDED BLK FETCH PHRASSE                         
A03505*  06/23/11   CB18344     ADDED CREDIT GROUP TO RESULT SET                
PRJ613*  11/14/13   LG41184     TO GET THE LATEST SCHEDULED PAYMENT.            
      ******************************************************************00290000
      ******************************************************************00300000
      *                                                                *00310000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00320000
      *                                                                *00330000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00340000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00350000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00360000
      *  3000 - 4999  NOT USED                                         *00370000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00380000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00390000
      *  7000 - 7999  INPUT MODULES                                    *00400000
      *  8000 - 8999  OUTPUT MODULES                                   *00410000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00420000
      *                                                                *00430000
      ******************************************************************00440000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02233'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02233 STARTS HERE'.                  
                                                                        
      ******************************************************************00530000
      *    DB2 INCLUDES                                                *00540000
      ******************************************************************00550000
                                                                        
           EXEC SQL                                                     00570000
              INCLUDE SQLCA                                             00580000
           END-EXEC.                                                    00590000
                                                                        
           EXEC SQL                                                     00610000
              INCLUDE TBBNKEFT                                          00620000
           END-EXEC.                                                    00630000
                                                                        
           EXEC SQL                                                     00650000
              INCLUDE TBBANK                                            00660000
           END-EXEC.                                                    00670000
                                                                        
           EXEC SQL                                                     00730000
              INCLUDE TBACCT                                            00740000
           END-EXEC.                                                    00750000
                                                                        
           EXEC SQL                                                     00761000
              INCLUDE TBCUST                                            00762000
           END-EXEC.                                                    00763000
C34097                                                                  
C34097*****                                                             03084000
C34097*  COPYBOOK FOR CSS_BILL_WINDOW                                   03084000
C34097*****                                                             03084000
C34097     EXEC SQL                                                     00761000
C34097        INCLUDE TBBILWDW                                          00762000
C34097     END-EXEC.                                                    00763000
                                                                        
           EXEC SQL                                                     00770000
              INCLUDE TBPDBKDF                                          00780000
           END-EXEC.                                                    00790000
                                                                        
           EXEC SQL                                                     00810000
              INCLUDE TBNAME                                            00820000
           END-EXEC.                                                    00830000
                                                                        
C29529     EXEC SQL                                                     00850000
C29529        INCLUDE TBCSTBNK                                          00860000
C29529     END-EXEC.                                                    00870000
                                                                        
C32750* CSS_PAYMENT_TRANS - JT                                                  
C32750     EXEC SQL                                                             
C32750        INCLUDE TBPMTRAN                                                  
C32750     END-EXEC.                                                            
                                                                        
PRJ526* CSS_ACCT_ATTRIBUTE - YP                                                 
PRJ526     EXEC SQL                                                             
PRJ526        INCLUDE TBACTATT                                                  
PRJ526     END-EXEC.                                                            
PRJ526                                                                  
PRJ526* CSS_PNDNG_CARD_PMT - PC                                                 
PRJ526     EXEC SQL                                                             
PRJ526        INCLUDE TBPNDCRD                                                  
PRJ526     END-EXEC.                                                            
                                                                        
      ******************************************************************00890000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00900000
      ******************************************************************00910000
                                                                        
           COPY CCA00001.                                               00950000
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CWSX0010                                                 
REARCH     END-EXEC.                                                            
           COPY CWS00027.                                               00970000
           COPY CWS00303.                                               00980000
                                                                        
      ******************************************************************01000000
      *    WORK AREAS                                                  *01010000
      ******************************************************************01020000
                                                                        
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME             PIC X(08) VALUE 'CSR02233'.     
REARCH     05  WS-SQLSTATE              PIC X(05)  VALUE  SPACES.       
           05  WS-ACCOUNT-NO            PIC 9(13) VALUE ZERO.           
           05  WS-ACCOUNT-NO-NUM        PIC S9(13) COMP-3 VALUE ZERO.   
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  WS-PEND-EXISTS-FLAG      PIC X(01) VALUE 'N'.            
               88 PEND-EXISTS                     VALUE 'Y'.            
C29529     05  WS-END-OF-BANKDFT-CSR    PIC X(01) VALUE 'N'.            
C29529         88 END-OF-BANKDFT-CSR              VALUE 'Y'.            
PRJ547     05  WS-CUSTOMER-NO-NUM       PIC S9(10) COMP-3 VALUE 0.      
PRJ547     05  WS-TOTAL-AR-BALANCE      PIC S9(11)V9(2) COMP-3 VALUE 0. 
PRJ547     05  WS-CUSTOMER-FL           PIC X(01) VALUE 'N'.            
PRJ547         88 CUSTOMER-EXISTS                 VALUE 'Y'.            
           05  WS-ACTIVE-BANKS-FL       PIC X(01) VALUE 'N'.            
               88 BANK-EXISTS                     VALUE 'Y'.            
           05  WS-BANK-ID-NUM           PIC 9(06).                      
           05  WS-BANK-ID               PIC X(06).                      
           05  WS-CUSTOMER-SEQ-NO       PIC S9(9) USAGE COMP.           
           05  WS-CUST-BANK-SEQ-NO      PIC 9(09).                      
           05  WS-SPLIT-DAY             PIC X(02) VALUE SPACES.         
           05  WS-SPLIT-DAY-NUM         PIC 9(02) VALUE ZERO.           
           05  WS-SPLIT-DAY-NUMERIC     PIC S9(04) COMP VALUE ZERO.     
           05  WS-LOOKUP-CYCLE          PIC X(02) VALUE SPACES.         
           05  WS-CYCLE-NUMERIC         PIC 9(02) VALUE ZERO.           
           05  WS-NULL-STATUS-CHANGE-DT PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-RESUME-DRAFT-DT  PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-LAST-DRAFT-DATE  PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-ESTABLISHED-DATE PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-PRENOTE-DATE     PIC S9(04) COMP VALUE ZERO.     
           05  WS-NULL-SPLIT-DAY-NUM    PIC S9(04) COMP VALUE ZERO.     
           05  WS-DISABLE-FLAG          PIC X(01)  VALUE 'N'.           
C29529     05  WS-BANK-DRFT-FOUND       PIC X(01)  VALUE 'N'.           
                                                                        
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  GTT-NAME                 PIC X(26)                       
REARCH                                      VALUE 'SESSION.CSR02233_R1'.
REARCH     05  GTT-ROW.                                                 
REARCH          49 GTT-ROW-LEN          PIC S9(04) COMP.                
REARCH          49 GTT-ROW-CHAR         PIC X(1024).                    
REARCH     05  GTT-SQLCODE              PIC S9(9) COMP.                 
                                                                        
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
                                                                        
REARCH 01  PARM-FIELDS.                                                 
REARCH     05  PARM-ACCOUNT-NO-TEMP       PIC X(13) VALUE SPACES.       
REARCH     05  PARM-ACCOUNT-NO-RED        REDEFINES PARM-ACCOUNT-NO-TEMP
REARCH                                    PIC 9(13).                    
REARCH     05  PARM-ACCT-NO-TO-TEMP       PIC X(13) VALUE SPACES.       
REARCH     05  PARM-ACCT-NO-TO-RED        REDEFINES PARM-ACCT-NO-TO-TEMP
REARCH                                    PIC 9(13).                    
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
           05  RS-STATUS-CODE           PIC X(01) VALUE SPACES.         
           05  RS-STATUS-CHANGE-DT      PIC X(10) VALUE SPACES.         
           05  RS-RESUME-DRAFT-DT       PIC X(10) VALUE SPACES.         
           05  RS-REQSTED-DRAFT-DAY     PIC X(02) VALUE SPACES.         
           05  RS-DRAFT-CYCLE           PIC X(02) VALUE SPACES.         
           05  RS-EARLIEST-DRAFT-DAY    PIC X(02) VALUE SPACES.         
           05  RS-BILL-CYCLE            PIC X(02) VALUE SPACES.         
           05  RS-DATE-EXTRACT          PIC X(10) VALUE SPACES.         
           05  RS-LAST-DRAFT-CYCLE      PIC X(02) VALUE SPACES.         
           05  RS-ESTABLISHED-DATE      PIC X(10) VALUE SPACES.         
           05  RS-PRENOTE-DATE          PIC X(10) VALUE SPACES.         
           05  RS-REMARKS               PIC X(26) VALUE SPACES.         
           05  RS-BANK-ACCOUNT-NAME     PIC X(50) VALUE SPACES.         
           05  RS-BANK-ACCT-NO          PIC X(19) VALUE SPACES.         
           05  RS-ACCT-TYPE-CD          PIC X(01) VALUE SPACES.         
           05  RS-NAME-BANK             PIC X(50) VALUE SPACES.         
           05  RS-BANK-CITY             PIC X(15) VALUE SPACES.         
           05  RS-BANK-STATE            PIC X(02) VALUE SPACES.         
           05  RS-ROUTING-NUMBER        PIC X(09) VALUE SPACES.         
           05  RS-PENDING-BANK-DRAFT    PIC X(01) VALUE SPACES.         
           05  RS-BANK-ID               PIC X(06) VALUE SPACES.         
COB305     05 RS-DRAFT-AMT        PIC S9(09)V99 USAGE COMP-3 VALUE 0.     
COB305     05 RS-BALANCE-AMT        PIC S9(11)V99 USAGE COMP-3 VALUE 0.     
016800     05  RS-DRAFT-DATE            PIC X(10) VALUE SPACES.         
C25964     05  RS-INIT-TYPE-CD          PIC X(2)  VALUE SPACES.         
C29529     05  RS-PRIMARY-BANK-NN       PIC X(50) VALUE SPACES.         
C29529     05  RS-DRAFT-BANK-NN         PIC X(50) VALUE SPACES.         
C29529     05  RS-CODE-SOURCE-ID        PIC X(01) VALUE SPACES.         
C29529     05  RS-PYMT-TRAN-TIMESTMP    PIC X(26) VALUE SPACES.         
C29529     05  RS-MULTIPLE-BANKS        PIC X(01) VALUE SPACES.         
C29529     05  RS-MULTIPLE-PND-PYMTS    PIC X(01) VALUE SPACES.         
C29529     05  RS-CUST-BNK-SEQ-NO       PIC X(09) VALUE SPACES.         
C29529     05  RS-DRFT-BNK-SEQ-NO       PIC X(09) VALUE SPACES.         
PRJ526     05  RS-AUTOCARD-STATUS-CD    PIC X(01) VALUE SPACES.         
PRJ526     05  RS-AUTOCARD-PYMT-DATE    PIC X(10) VALUE SPACES.         
A03505     05  RS-CREDIT-GROUP          PIC X(01) VALUE SPACES.         
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE            PIC S9(9) COMP VALUE 0.         
REARCH     05  S-STATUS-CODE            PIC X(01) VALUE SPACES.         
REARCH     05  S-STATUS-CHANGE-DT       PIC X(10) VALUE SPACES.         
REARCH     05  S-RESUME-DRAFT-DT        PIC X(10) VALUE SPACES.         
REARCH     05  S-REQSTED-DRAFT-DAY      PIC X(02) VALUE SPACES.         
REARCH     05  S-DRAFT-CYCLE            PIC X(02) VALUE SPACES.         
REARCH     05  S-EARLIEST-DRAFT-DAY     PIC X(02) VALUE SPACES.         
REARCH     05  S-BILL-CYCLE             PIC X(02) VALUE SPACES.         
REARCH     05  S-DATE-EXTRACT           PIC X(10) VALUE SPACES.         
REARCH     05  S-LAST-DRAFT-CYCLE       PIC X(02) VALUE SPACES.         
REARCH     05  S-ESTABLISHED-DATE       PIC X(10) VALUE SPACES.         
REARCH     05  S-PRENOTE-DATE           PIC X(10) VALUE SPACES.         
REARCH     05  S-REMARKS                PIC X(26) VALUE SPACES.         
REARCH     05  S-BANK-ACCOUNT-NAME      PIC X(50) VALUE SPACES.         
REARCH     05  S-BANK-ACCT-NO           PIC X(19) VALUE SPACES.         
REARCH     05  S-ACCT-TYPE-CD           PIC X(01) VALUE SPACES.         
REARCH     05  S-NAME-BANK              PIC X(50) VALUE SPACES.         
REARCH     05  S-BANK-CITY              PIC X(15) VALUE SPACES.         
REARCH     05  S-BANK-STATE             PIC X(02) VALUE SPACES.         
REARCH     05  S-ROUTING-NUMBER         PIC X(09) VALUE SPACES.         
REARCH     05  S-PENDING-BANK-DRAFT     PIC X(01) VALUE SPACES.         
REARCH     05  S-BANK-ID                PIC X(06) VALUE SPACES.         
COB305     05 S-DRAFT-AMT        PIC S9(09)V99 USAGE COMP-3 VALUE 0.     
COB305     05 S-BALANCE-AMT        PIC S9(11)V99 USAGE COMP-3 VALUE 0.     
REARCH     05  S-DRAFT-DATE             PIC X(10) VALUE SPACES.         
REARCH     05  S-INIT-TYPE-CD           PIC X(2)  VALUE SPACES.         
REARCH     05  S-PRIMARY-BANK-NN        PIC X(50) VALUE SPACES.         
REARCH     05  S-DRAFT-BANK-NN          PIC X(50) VALUE SPACES.         
REARCH     05  S-CODE-SOURCE-ID         PIC X(01) VALUE SPACES.         
REARCH     05  S-PYMT-TRAN-TIMESTMP     PIC X(26) VALUE SPACES.         
REARCH     05  S-MULTIPLE-BANKS         PIC X(01) VALUE SPACES.         
REARCH     05  S-MULTIPLE-PND-PYMTS     PIC X(01) VALUE SPACES.         
REARCH     05  S-CUST-BNK-SEQ-NO        PIC X(09) VALUE SPACES.         
REARCH     05  S-DRFT-BNK-SEQ-NO        PIC X(09) VALUE SPACES.         
PRJ526     05  S-AUTOCARD-STATUS-CD     PIC X(01) VALUE SPACES.         
PRJ526     05  S-AUTOCARD-PYMT-DATE     PIC X(10) VALUE SPACES.         
A03505     05  S-CREDIT-GROUP           PIC X(01) VALUE SPACES.         
                                                                        
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME                PIC X(18)      VALUE SPACES.    
REARCH     10  S-SQLCODE                PIC S9(9) COMP VALUE 0.         
REARCH     10  S-SQLSTATE               PIC X(5)       VALUE ' '.       
REARCH     10  S-TABLE-NAME             PIC X(18)      VALUE SPACES.    
REARCH     10  S-HOST-VARIABLES.                                        
REARCH          49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
REARCH          49  S-HOST-VARIABLES-V  PIC X(255).                     
REARCH     10  S-SQL-STATEMENT.                                         
REARCH          49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
REARCH          49  S-SQL-STATEMENT-V   PIC X(255).                     
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH          49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
REARCH          49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
C29529***************************************************************** 04970000
C29529*    CURSOR DECLARATION                                           04980000
C29529***************************************************************** 04990000
C29529     EXEC SQL DECLARE BANKDFT_CURSOR CURSOR FOR                   
C29529        SELECT 'YES',                                             
C29529               DRAFT_AMT,                                         
C29529               CIS.CHAR2$DATE(DRAFT_DATE,'USA'),                          
C29529               CODE_SOURCE_ID,                                    
C29529               CUST_BANK_SEQ_NO,                                  
C29529               REPLACE(REPLACE(CONVERT(CHAR(26), PYMT_TRANS_TS
           , 121), ' ', '-'), ':', '.') PYMT_TRANS_TS                          
C29529          FROM CSS_PNDNG_BNK_DRFT WITH(READUNCOMMITTED)                   
C29529         WHERE ACCOUNT_NO  = :PB-ACCOUNT-NO                       
C29529           AND TRANSACTION_CD IN (27, 37)                         
C29529           AND PYMT_POSTED_FL= 'N'                                
C32750         UNION                                                    
C32750        SELECT 'YES',                                             
C32750               DRAFT_AMT,                                         
C32750               CIS.CHAR2$DATE(DRAFT_DATE,'USA'),                          
C32750               CODE_SOURCE_ID,                                    
C32750               CUST_BANK_SEQ_NO,                                  
C32750               REPLACE(REPLACE(CONVERT(CHAR(26), PYMT_TRANS_TS
           , 121), ' ', '-'), ':', '.') PYMT_TRANS_TS                          
C32750          FROM CSS_PAYMENT_TRANS A WITH(READUNCOMMITTED)                  
C32750              ,CSS_PNDNG_BNK_DRFT B WITH(READUNCOMMITTED)                 
C32750         WHERE B.ACCOUNT_NO     = :PB-ACCOUNT-NO                  
C32750           AND B.PYMT_POSTED_FL = 'Y'                             
C32750           AND A.PYMT_RCVD_TS   = B.PYMT_TRANS_TS                 
C32750           AND A.ACCOUNT_NO     = B.ACCOUNT_NO                    
C32750           AND A.CASH_LOCAL_OFFICE IN ('025','022')               
C32750           AND A.APPLIED_FL IN ( ' ','N')                         
C32750         ORDER BY 3,6                                             
C29529        FOR READ ONLY                                            
C36437                                                           
C29529     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE BANKDFT_CURSOR CURSOR FOR                   05000000
MFA-TR*       SELECT 'YES',                                             13440000
MFA-TR*              DRAFT_AMT,                                         13450002
MFA-TR*              CHAR(DRAFT_DATE,USA),                              13460002
MFA-TR*              CODE_SOURCE_ID,                                            
MFA-TR*              CUST_BANK_SEQ_NO,                                          
MFA-TR*              PYMT_TRANS_TS                                              
MFA-TR*         FROM CSS_PNDNG_BNK_DRFT                                 11450000
MFA-TR*        WHERE ACCOUNT_NO  = :PB-ACCOUNT-NO                       13510002
MFA-TR*          AND TRANSACTION_CD IN (27, 37)                                 
MFA-TR*          AND PYMT_POSTED_FL= 'N'                                        
MFA-TR*        UNION                                                            
MFA-TR*       SELECT 'YES',                                                     
MFA-TR*              DRAFT_AMT,                                                 
MFA-TR*              CHAR(DRAFT_DATE,USA),                                      
MFA-TR*              CODE_SOURCE_ID,                                            
MFA-TR*              CUST_BANK_SEQ_NO,                                          
MFA-TR*              PYMT_TRANS_TS                                              
MFA-TR*         FROM CSS_PAYMENT_TRANS A                                        
MFA-TR*             ,CSS_PNDNG_BNK_DRFT B                                       
MFA-TR*        WHERE B.ACCOUNT_NO     = :PB-ACCOUNT-NO                          
MFA-TR*          AND B.PYMT_POSTED_FL = 'Y'                                     
MFA-TR*          AND A.PYMT_RCVD_TS   = B.PYMT_TRANS_TS                         
MFA-TR*          AND A.ACCOUNT_NO     = B.ACCOUNT_NO                            
MFA-TR*          AND A.CASH_LOCAL_OFFICE IN ('025','022')                       
MFA-TR*          AND A.APPLIED_FL IN ( ' ','N')                                 
MFA-TR*        ORDER BY 3,6                                                     
MFA-TR*       FOR FETCH ONLY                                            07470000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    11470000
C36437*                                                                         
C36437     EXEC SQL DECLARE REALTIME_CURSOR CURSOR FOR                  
C36437        SELECT 'YES',                                             
C36437               DRAFT_AMT,                                         
C36437               CIS.CHAR2$DATE(DRAFT_DATE,'USA'),                          
C36437               CODE_SOURCE_ID,                                    
C36437               CUST_BANK_SEQ_NO,                                  
C36437               REPLACE(REPLACE(CONVERT(CHAR(26), PYMT_TRANS_TS
           , 121), ' ', '-'), ':', '.') PYMT_TRANS_TS                          
C36437          FROM CSS_PNDNG_BNK_DRFT WITH(READUNCOMMITTED)                   
C36437         WHERE ACCOUNT_NO  = :PB-ACCOUNT-NO                       
C36437           AND TRANSACTION_CD IN (27, 37)                         
C36437         UNION                                                    
C36437        SELECT 'YES',                                             
C36437               DRAFT_AMT,                                         
C36437               CIS.CHAR2$DATE(DRAFT_DATE,'USA'),                          
C36437               CODE_SOURCE_ID,                                    
C36437               CUST_BANK_SEQ_NO,                                  
C36437               REPLACE(REPLACE(CONVERT(CHAR(26), PYMT_TRANS_TS
           , 121), ' ', '-'), ':', '.') PYMT_TRANS_TS                          
C36437          FROM CSS_PAYMENT_TRANS A WITH(READUNCOMMITTED)                  
C36437              ,CSS_PNDNG_BNK_DRFT B WITH(READUNCOMMITTED)                 
C36437         WHERE B.ACCOUNT_NO     = :PB-ACCOUNT-NO                  
C36437           AND B.PYMT_POSTED_FL = 'Y'                             
C36437           AND A.PYMT_RCVD_TS   = B.PYMT_TRANS_TS                 
C36437           AND A.ACCOUNT_NO     = B.ACCOUNT_NO                    
C36437           AND A.CASH_LOCAL_OFFICE IN ('025','022')               
C36437         ORDER BY 3,6                                             
C36437        FOR READ ONLY                                            
C36437                                                           
C36437     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE REALTIME_CURSOR CURSOR FOR                  05000000
MFA-TR*       SELECT 'YES',                                             13440000
MFA-TR*              DRAFT_AMT,                                         13450002
MFA-TR*              CHAR(DRAFT_DATE,USA),                              13460002
MFA-TR*              CODE_SOURCE_ID,                                            
MFA-TR*              CUST_BANK_SEQ_NO,                                          
MFA-TR*              PYMT_TRANS_TS                                              
MFA-TR*         FROM CSS_PNDNG_BNK_DRFT                                 11450000
MFA-TR*        WHERE ACCOUNT_NO  = :PB-ACCOUNT-NO                       13510002
MFA-TR*          AND TRANSACTION_CD IN (27, 37)                                 
MFA-TR*        UNION                                                            
MFA-TR*       SELECT 'YES',                                                     
MFA-TR*              DRAFT_AMT,                                                 
MFA-TR*              CHAR(DRAFT_DATE,USA),                                      
MFA-TR*              CODE_SOURCE_ID,                                            
MFA-TR*              CUST_BANK_SEQ_NO,                                          
MFA-TR*              PYMT_TRANS_TS                                              
MFA-TR*         FROM CSS_PAYMENT_TRANS A                                        
MFA-TR*             ,CSS_PNDNG_BNK_DRFT B                                       
MFA-TR*        WHERE B.ACCOUNT_NO     = :PB-ACCOUNT-NO                          
MFA-TR*          AND B.PYMT_POSTED_FL = 'Y'                                     
MFA-TR*          AND A.PYMT_RCVD_TS   = B.PYMT_TRANS_TS                         
MFA-TR*          AND A.ACCOUNT_NO     = B.ACCOUNT_NO                            
MFA-TR*          AND A.CASH_LOCAL_OFFICE IN ('025','022')                       
MFA-TR*        ORDER BY 3,6                                                     
MFA-TR*       FOR FETCH ONLY                                            07470000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    11470000
                                                                        
      *                                                                         
HPCCDM* EJECT                                                           02350000
                                                                        
REARCH LINKAGE SECTION.                                                 
REARCH 01  PARM-ACCOUNT-NO             PIC X(13).                       
REARCH 01  PARM-ACCT-NO-TO             PIC X(13).                       
C36437 01  PARM-REALTIME-EPAY          PIC X(01).                       
REARCH                                                                  
REARCH PROCEDURE DIVISION USING   PARM-ACCOUNT-NO                       
REARCH                            PARM-ACCT-NO-TO                       
C36437                            PARM-REALTIME-EPAY.                   
                                                                        
      ******************************************************************02380000
      **     CONTROLS THE MAIN PATH OF THE PROGRAM                      02390000
      ** 0000-MAINLINE                                                  02400000
      ******************************************************************02410000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02530000
      * 0100-INITIALIZE                                                *02540000
      *                                                                *02550000
      *     1. RESET DB2 ERROR HANDLERS                                *02560000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *02570000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *02580000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*02590000
      *                                                                *02600000
      ******************************************************************02610000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
REARCH     PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
REARCH                                                                  
REARCH     EXEC SQL                                                     
REARCH          DECLARE C1 CURSOR                            
A36577                            WITH ROWSET POSITIONING FOR           
REARCH          SELECT                                                  
REARCH                RETURN_CODE                                       
REARCH               ,STATUS_CODE                                       
REARCH               ,STATUS_CHANGE_DT                                  
REARCH               ,LTRIM(RTRIM(RESUME_DRAFT_DT))    AS 
           RESUME_DRAFT_DT      
REARCH               ,LTRIM(RTRIM(REQSTED_DRAFT_DAY))  AS 
           REQSTED_DRAFT_DAY    
REARCH               ,DRAFT_CYCLE                                       
REARCH               ,EARLIEST_DRAFT_DAY                                
REARCH               ,BILL_CYCLE                                        
REARCH               ,DATE_EXTRACT                                      
REARCH               ,LAST_DRAFT_CYCLE                                  
REARCH               ,ESTABLISHED_DATE                                  
REARCH               ,LTRIM(RTRIM(PRENOTE_DATE))       AS PRENOTE_DATE         
REARCH               ,LTRIM(RTRIM(REMARKS))            AS REMARKS              
REARCH               ,LTRIM(RTRIM(BANK_ACCOUNT_NAME))  AS 
           BANK_ACCOUNT_NAME    
REARCH               ,LTRIM(RTRIM(BANK_ACCT_NO))       AS BANK_ACCT_NO         
REARCH               ,ACCT_TYPE_CD                                      
REARCH               ,LTRIM(RTRIM(NAME_BANK))          AS NAME_BANK            
REARCH               ,LTRIM(RTRIM(BANK_CITY))          AS BANK_CITY            
REARCH               ,BANK_STATE                                        
REARCH               ,ROUTING_NUMBER                                    
REARCH               ,PENDING_BANK_DRAFT                                
REARCH               ,BANK_ID                                           
REARCH               ,DRAFT_AMT                                         
REARCH               ,BALANCE_AMT                                       
REARCH               ,DRAFT_DATE                                        
REARCH               ,INIT_TYPE_CD                                      
REARCH               ,LTRIM(RTRIM(BANK_PRIM_NICKNAME)) AS 
           BANK_PRIM_NICKNAME   
REARCH               ,LTRIM(RTRIM(BANK_ACCT_NICKNAME)) AS 
           BANK_ACCT_NICKNAME   
REARCH               ,CODE_SOURCE_ID                                    
REARCH               ,PYMT_TRAN_TIMESTMP                                
REARCH               ,MULTIPLE_BANKS                                    
REARCH               ,MULTIPLE_PND_PYMTS                                
REARCH               ,PMY_CUST_SEQ_NO                                   
REARCH               ,DRFT_BANK_SEQ_NO                                  
PRJ526               ,AUTOCARD_STATUS_CD                                
PRJ526               ,AUTOCARD_PYMT_DATE                                
A03505               ,CREDIT_GROUP                                      
REARCH          FROM                                                    
REARCH              #CSR02233_R1                                 
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN                                   
MFA-TR*                           WITH ROWSET POSITIONING FOR                   
MFA-TR*         SELECT                                                          
MFA-TR*               RETURN_CODE                                               
MFA-TR*              ,STATUS_CODE                                               
MFA-TR*              ,STATUS_CHANGE_DT                                          
MFA-TR*              ,STRIP(RESUME_DRAFT_DT)    AS RESUME_DRAFT_DT              
MFA-TR*              ,STRIP(REQSTED_DRAFT_DAY)  AS REQSTED_DRAFT_DAY            
MFA-TR*              ,DRAFT_CYCLE                                               
MFA-TR*              ,EARLIEST_DRAFT_DAY                                        
MFA-TR*              ,BILL_CYCLE                                                
MFA-TR*              ,DATE_EXTRACT                                              
MFA-TR*              ,LAST_DRAFT_CYCLE                                          
MFA-TR*              ,ESTABLISHED_DATE                                          
MFA-TR*              ,STRIP(PRENOTE_DATE)       AS PRENOTE_DATE                 
MFA-TR*              ,STRIP(REMARKS)            AS REMARKS                      
MFA-TR*              ,STRIP(BANK_ACCOUNT_NAME)  AS BANK_ACCOUNT_NAME            
MFA-TR*              ,STRIP(BANK_ACCT_NO)       AS BANK_ACCT_NO                 
MFA-TR*              ,ACCT_TYPE_CD                                              
MFA-TR*              ,STRIP(NAME_BANK)          AS NAME_BANK                    
MFA-TR*              ,STRIP(BANK_CITY)          AS BANK_CITY                    
MFA-TR*              ,BANK_STATE                                                
MFA-TR*              ,ROUTING_NUMBER                                            
MFA-TR*              ,PENDING_BANK_DRAFT                                        
MFA-TR*              ,BANK_ID                                                   
MFA-TR*              ,DRAFT_AMT                                                 
MFA-TR*              ,BALANCE_AMT                                               
MFA-TR*              ,DRAFT_DATE                                                
MFA-TR*              ,INIT_TYPE_CD                                              
MFA-TR*              ,STRIP(BANK_PRIM_NICKNAME) AS BANK_PRIM_NICKNAME           
MFA-TR*              ,STRIP(BANK_ACCT_NICKNAME) AS BANK_ACCT_NICKNAME           
MFA-TR*              ,CODE_SOURCE_ID                                            
MFA-TR*              ,PYMT_TRAN_TIMESTMP                                        
MFA-TR*              ,MULTIPLE_BANKS                                            
MFA-TR*              ,MULTIPLE_PND_PYMTS                                        
MFA-TR*              ,PMY_CUST_SEQ_NO                                           
MFA-TR*              ,DRFT_BANK_SEQ_NO                                          
MFA-TR*              ,AUTOCARD_STATUS_CD                                        
MFA-TR*              ,AUTOCARD_PYMT_DATE                                        
MFA-TR*              ,CREDIT_GROUP                                              
MFA-TR*         FROM                                                            
MFA-TR*             SESSION.CSR02233_R1                                         
MFA-TR*    END-EXEC.                                                            
REARCH                                                                  
REARCH 0100-EXIT.                                                       
REARCH     EXIT.                                                        
                                                                        
REARCH******************************************************************02530000
REARCH* 0100A-DECLARE-GTT.                                             *02540000
REARCH******************************************************************02890000
REARCH 0100A-DECLARE-GTT.                                               
REARCH     MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR02233_R1'            
REARCH                                 TO S-SQL-STATEMENT-V.            
REARCH*                                                                         
REARCH     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02233_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02233_R1
              (                                                       
REARCH             RETURN_CODE              INT                     
REARCH            ,STATUS_CODE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH            ,STATUS_CHANGE_DT CHAR(10)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
REARCH            ,RESUME_DRAFT_DT CHAR(10)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
REARCH            ,REQSTED_DRAFT_DAY CHAR(02)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
REARCH            ,DRAFT_CYCLE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH            ,EARLIEST_DRAFT_DAY CHAR(02)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
REARCH            ,BILL_CYCLE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH            ,DATE_EXTRACT CHAR(10)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
REARCH            ,LAST_DRAFT_CYCLE CHAR(02)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
REARCH            ,ESTABLISHED_DATE CHAR(10)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
REARCH            ,PRENOTE_DATE CHAR(10)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
REARCH            ,REMARKS CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2            
REARCH            ,BANK_ACCOUNT_NAME CHAR(50)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
REARCH            ,BANK_ACCT_NO CHAR(19)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
REARCH            ,ACCT_TYPE_CD CHAR(01)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
REARCH            ,NAME_BANK CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH            ,BANK_CITY CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH            ,BANK_STATE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH            ,ROUTING_NUMBER CHAR(09)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
REARCH            ,PENDING_BANK_DRAFT CHAR(01)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
REARCH            ,BANK_ID CHAR(06)  COLLATE LATIN1_GENERAL_100_BIN2            
REARCH            ,DRAFT_AMT                DECIMAL(11,2)               
REARCH            ,BALANCE_AMT              DECIMAL(13,2)               
REARCH            ,DRAFT_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH            ,INIT_TYPE_CD CHAR(2)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH            ,BANK_PRIM_NICKNAME CHAR(50)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
REARCH            ,BANK_ACCT_NICKNAME CHAR(50)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
REARCH            ,CODE_SOURCE_ID CHAR(01)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
REARCH            ,PYMT_TRAN_TIMESTMP CHAR(26)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
REARCH            ,MULTIPLE_BANKS CHAR(01)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
REARCH            ,MULTIPLE_PND_PYMTS CHAR(01)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
REARCH            ,PMY_CUST_SEQ_NO CHAR(09)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
REARCH            ,DRFT_BANK_SEQ_NO CHAR(09)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
PRJ526            ,AUTOCARD_STATUS_CD CHAR(01)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
PRJ526            ,AUTOCARD_PYMT_DATE CHAR(10)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
A03505            ,CREDIT_GROUP CHAR(01)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                    
REARCH         )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH     MOVE SQLSTATE                     TO WS-SQLSTATE.            
REARCH     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
REARCH     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
REARCH        NEXT SENTENCE                                             
REARCH     ELSE                                                         
REARCH        MOVE PROGRAM-NAME       TO ABEND-PROGRAM                  
REARCH        MOVE SQLCODE            TO ABEND-SQLCODE                  
REARCH        MOVE SQLSTATE           TO ABEND-SQLSTATE                 
REARCH        MOVE '0100A'            TO ACTIVE-PARAGRAPH               
REARCH        MOVE 'DECLARE GTT'      TO ABEND-FUNCTION                 
REARCH        MOVE SPACES             TO ABEND-SQL-PREDICATES           
REARCH                                   ABEND-TABLES                   
REARCH        MOVE 'CSR02233_R1'      TO TABLE-1                        
REARCH        MOVE SPACES             TO TABLE-ELEMENT-1                
REARCH        MOVE SPACES             TO HOSTVAR-ELEMENT-1              
REARCH        PERFORM 9900-SQL-ERROR-ROUTINE                            
REARCH                                       THRU  9900-EXIT            
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH   0100A-EXIT.                                                    
REARCH        EXIT.                                                     
REARCH*                                                                         
      ******************************************************************02890000
      *                                                                *        
      * 1000-PROCESS-INPUT                                             *02900000
      *                                                                *02910000
      *     1. RECEIVE PARMS.                                          *02920000
      *                                                                *02930000
      ******************************************************************02940000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
REARCH     MOVE PARM-ACCOUNT-NO           TO PARM-ACCOUNT-NO-TEMP.      
           MOVE PARM-ACCOUNT-NO-RED       TO WS-ACCOUNT-NO.             
           MOVE WS-ACCOUNT-NO             TO WS-ACCOUNT-NO-NUM.         
           MOVE WS-ACCOUNT-NO-NUM         TO AT-ACCOUNT-NO              
                                             BE-ACCOUNT-NO              
                                             PB-ACCOUNT-NO.             
                                                                        
                                                                        
           IF PARM-ACCT-NO-TO > SPACES                                  
REARCH        MOVE PARM-ACCT-NO-TO        TO PARM-ACCT-NO-TO-TEMP       
              MOVE PARM-ACCT-NO-TO-RED    TO WS-ACCOUNT-NO              
              MOVE WS-ACCOUNT-NO          TO WS-ACCOUNT-NO-NUM          
              MOVE WS-ACCOUNT-NO-NUM      TO AT-ACCOUNT-NO              
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03490000
      * 2000-PROCESS-OUTPUT.                                           *03500000
      *                                                                *03510000
      *     1. DESCRIBE RESULT SET                                     *03520000
      *     2. UPDATE DB2 DATA                                         *03530000
      *     3. BUILD RESULT SET                                        *03540000
      *     4. SEND RESULT SET                                         *03550000
      *                                                                *03560000
      ******************************************************************03570000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 2200-BUILD-RESULT    THRU 2200-EXIT.                 
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
REARCH*                                                                         
REARCH******************************************************************03570000
REARCH* 2000A-MOVE-RESULT.                                             *03500000
REARCH******************************************************************03570000
REARCH 2000A-MOVE-RESULT.                                               
REARCH     MOVE   RS-RETURN-CODE        TO S-RETURN-CODE.               
REARCH     MOVE   RS-STATUS-CODE        TO S-STATUS-CODE.               
REARCH     MOVE   RS-STATUS-CHANGE-DT   TO S-STATUS-CHANGE-DT.          
REARCH     MOVE   RS-RESUME-DRAFT-DT    TO S-RESUME-DRAFT-DT.           
REARCH     MOVE   RS-REQSTED-DRAFT-DAY  TO S-REQSTED-DRAFT-DAY.         
REARCH     MOVE   RS-DRAFT-CYCLE        TO S-DRAFT-CYCLE.               
REARCH     MOVE   RS-EARLIEST-DRAFT-DAY TO S-EARLIEST-DRAFT-DAY.        
REARCH     MOVE   RS-BILL-CYCLE         TO S-BILL-CYCLE.                
REARCH     MOVE   RS-DATE-EXTRACT       TO S-DATE-EXTRACT.              
REARCH     MOVE   RS-LAST-DRAFT-CYCLE   TO S-LAST-DRAFT-CYCLE.          
REARCH     MOVE   RS-ESTABLISHED-DATE   TO S-ESTABLISHED-DATE.          
REARCH     MOVE   RS-PRENOTE-DATE       TO S-PRENOTE-DATE.              
REARCH     MOVE   RS-REMARKS            TO S-REMARKS.                   
REARCH     MOVE   RS-BANK-ACCOUNT-NAME  TO S-BANK-ACCOUNT-NAME.         
REARCH     MOVE   RS-BANK-ACCT-NO       TO S-BANK-ACCT-NO.              
REARCH     MOVE   RS-ACCT-TYPE-CD       TO S-ACCT-TYPE-CD.              
REARCH     MOVE   RS-NAME-BANK          TO S-NAME-BANK.                 
REARCH     MOVE   RS-BANK-CITY          TO S-BANK-CITY.                 
REARCH     MOVE   RS-BANK-STATE         TO S-BANK-STATE.                
REARCH     MOVE   RS-ROUTING-NUMBER     TO S-ROUTING-NUMBER.            
REARCH     MOVE   RS-PENDING-BANK-DRAFT TO S-PENDING-BANK-DRAFT.        
REARCH     MOVE   RS-BANK-ID            TO S-BANK-ID.                   
REARCH     MOVE   RS-DRAFT-AMT          TO S-DRAFT-AMT.                 
REARCH     MOVE   RS-BALANCE-AMT        TO S-BALANCE-AMT.               
REARCH     MOVE   RS-DRAFT-DATE         TO S-DRAFT-DATE.                
REARCH     MOVE   RS-INIT-TYPE-CD       TO S-INIT-TYPE-CD.              
REARCH     MOVE   RS-PRIMARY-BANK-NN    TO S-PRIMARY-BANK-NN.           
REARCH     MOVE   RS-DRAFT-BANK-NN      TO S-DRAFT-BANK-NN.             
REARCH     MOVE   RS-CODE-SOURCE-ID     TO S-CODE-SOURCE-ID.            
REARCH     MOVE   RS-PYMT-TRAN-TIMESTMP TO S-PYMT-TRAN-TIMESTMP.        
REARCH     MOVE   RS-MULTIPLE-BANKS     TO S-MULTIPLE-BANKS.            
REARCH     MOVE   RS-MULTIPLE-PND-PYMTS TO S-MULTIPLE-PND-PYMTS.        
REARCH     MOVE   RS-CUST-BNK-SEQ-NO    TO S-CUST-BNK-SEQ-NO.           
REARCH     MOVE   RS-DRFT-BNK-SEQ-NO    TO S-DRFT-BNK-SEQ-NO.           
PRJ526     MOVE   RS-AUTOCARD-STATUS-CD TO S-AUTOCARD-STATUS-CD.        
PRJ526     MOVE   RS-AUTOCARD-PYMT-DATE TO S-AUTOCARD-PYMT-DATE.        
A03505     MOVE   RS-CREDIT-GROUP       TO S-CREDIT-GROUP.              
REARCH 2000A-EXIT.                                                      
REARCH      EXIT.                                                       
                                                                        
      ******************************************************************08450000
      * 2200-BUILD-RESULT                                              *08460000
      ******************************************************************08470000
                                                                        
       2200-BUILD-RESULT.                                               
                                                                        
           PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT.                  
                                                                        
           IF AT-MST-SUB-ACCT-IND = 'S'                                 
              PERFORM 7020-SELECT-SUB-OF-AR-MST THRU 7020-EXIT          
           END-IF.                                                      
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE         TO RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE AT-BILL-CYCLE              TO RS-BILL-CYCLE          
A03505        MOVE AT-CREDIT-GROUP            TO RS-CREDIT-GROUP        
                                                                        
C29529        MOVE 'N'                        TO WS-BANK-DRFT-FOUND     
              PERFORM 7100-SELECT-BANK-DRAFT  THRU 7100-EXIT            
                                                                        
                                                                        
PRJ526        IF WS-BANK-DRFT-FOUND    = 'Y'                            
C29529           MOVE BE-CUST-BANK-SEQ-NO        TO WS-CUSTOMER-SEQ-NO  
C29529           PERFORM 7150-SELECT-BANK-NN     THRU 7150-EXIT         
C29529           MOVE JF-BANK-ACCT-NICKNAME-TEXT TO RS-PRIMARY-BANK-NN  
                                                                        
                 MOVE BE-STATUS-CODE          TO RS-STATUS-CODE         
                 IF WS-NULL-STATUS-CHANGE-DT = -1                       
                    MOVE SPACES               TO RS-STATUS-CHANGE-DT    
                 ELSE                                                   
                    MOVE BE-STATUS-CHANGE-DT  TO RS-STATUS-CHANGE-DT    
                 END-IF                                                 
                 IF WS-NULL-RESUME-DRAFT-DT = -1                        
                    MOVE SPACES               TO RS-RESUME-DRAFT-DT     
                 ELSE                                                   
                    MOVE BE-RESUME-DRAFT-DT   TO RS-RESUME-DRAFT-DT     
                 END-IF                                                 
                 MOVE BE-REQSTED-DRAFT-DAY    TO RS-REQSTED-DRAFT-DAY   
                 MOVE BE-DRAFT-CYCLE          TO RS-DRAFT-CYCLE         
                 IF PARM-ACCT-NO-TO > SPACES                            
                    MOVE SPACES               TO RS-LAST-DRAFT-CYCLE    
                 ELSE                                                   
                    MOVE BE-LAST-DRAFT-CYCLE  TO RS-LAST-DRAFT-CYCLE    
                 END-IF                                                 
                 IF WS-NULL-ESTABLISHED-DATE = -1                       
                    MOVE SPACES               TO RS-ESTABLISHED-DATE    
                 ELSE                                                   
                    MOVE BE-ESTABLISHED-DATE  TO RS-ESTABLISHED-DATE    
                 END-IF                                                 
                 IF WS-NULL-PRENOTE-DATE = -1                           
                    MOVE SPACES               TO RS-PRENOTE-DATE        
                 ELSE                                                   
                    MOVE BE-PRENOTE-DATE      TO RS-PRENOTE-DATE        
                 END-IF                                                 
                 MOVE BE-REMARKS              TO RS-REMARKS             
                 MOVE BE-BANK-ACCOUNT-NAME    TO RS-BANK-ACCOUNT-NAME   
                 MOVE BE-BANK-ACCT-NO         TO RS-BANK-ACCT-NO        
                 MOVE BE-ACCT-TYPE-CD         TO RS-ACCT-TYPE-CD        
C25964           MOVE BE-INIT-TYPE-CD         TO RS-INIT-TYPE-CD        
                 MOVE BE-BANK-ID              TO WS-BANK-ID-NUM         
                 MOVE WS-BANK-ID-NUM          TO WS-BANK-ID             
                 MOVE WS-BANK-ID              TO RS-BANK-ID             
C29529           MOVE BE-CUST-BANK-SEQ-NO     TO WS-CUST-BANK-SEQ-NO    
C29529           MOVE WS-CUST-BANK-SEQ-NO     TO RS-CUST-BNK-SEQ-NO     
                                                                        
T9700            IF BE-BANK-ID > 0                                      
                    PERFORM 7200-SELECT-BANK THRU 7200-EXIT             
T9700            ELSE                                                   
T9700               MOVE NOT-FOUND TO WS-ACTIVE-RETURN-CODE             
T9700            END-IF                                                 
                                                                        
                 MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE         
                                                                        
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    MOVE D1-BANK-NAME         TO RS-NAME-BANK           
                    MOVE D1-BANK-CITY         TO RS-BANK-CITY           
                    MOVE D1-BANK-STATE        TO RS-BANK-STATE          
                    MOVE D1-ROUTING-NUMBER    TO RS-ROUTING-NUMBER      
                 ELSE                                                   
                    MOVE SPACES               TO RS-NAME-BANK           
                    MOVE SPACES               TO RS-BANK-CITY           
                    MOVE SPACES               TO RS-BANK-STATE          
                    MOVE SPACES               TO RS-ROUTING-NUMBER      
                 END-IF                                                 
              ELSE                                                      
23549            MOVE 'I'                     TO RS-STATUS-CODE         
                 MOVE SPACES                  TO RS-STATUS-CHANGE-DT    
                 MOVE SPACES                  TO RS-RESUME-DRAFT-DT     
                 MOVE SPACES                  TO RS-REQSTED-DRAFT-DAY   
                 MOVE SPACES                  TO RS-DRAFT-CYCLE         
                 MOVE SPACES                  TO RS-LAST-DRAFT-CYCLE    
                 MOVE SPACES                  TO RS-ESTABLISHED-DATE    
                 MOVE SPACES                  TO RS-PRENOTE-DATE        
                 MOVE SPACES                  TO RS-REMARKS             
                 PERFORM 7700-SELECT-NAME THRU 7700-EXIT                
                                                                        
                 MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE         
                                                                        
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    MOVE DQ-FULL-NAME         TO RS-BANK-ACCOUNT-NAME   
                 ELSE                                                   
                    MOVE SPACES               TO RS-BANK-ACCOUNT-NAME   
                 END-IF                                                 
                 MOVE SPACES                  TO RS-BANK-ACCT-NO        
                 MOVE SPACES                  TO RS-ACCT-TYPE-CD        
                 MOVE SPACES                  TO RS-NAME-BANK           
                 MOVE SPACES                  TO RS-BANK-CITY           
                 MOVE SPACES                  TO RS-BANK-STATE          
                 MOVE SPACES                  TO RS-ROUTING-NUMBER      
25964            MOVE '01'                    TO RS-INIT-TYPE-CD        
              END-IF                                                    
                                                                        
TP9566        IF WS-NULL-LAST-DRAFT-DATE = -1                           
TP9566           MOVE SPACES               TO RS-DATE-EXTRACT           
TP9566        ELSE                                                      
TP9566           MOVE BE-LAST-DRAFT-DATE   TO RS-DATE-EXTRACT           
TP9566        END-IF                                                    
                                                                        
              IF RS-DRAFT-CYCLE > SPACES                                
                 MOVE RS-DRAFT-CYCLE          TO WS-LOOKUP-CYCLE        
              ELSE                                                      
                 IF AT-BILL-CYCLE > SPACES                              
                    MOVE AT-BILL-CYCLE        TO WS-CYCLE-NUMERIC       
                    COMPUTE WS-CYCLE-NUMERIC = WS-CYCLE-NUMERIC + 5     
C28084              IF WS-CYCLE-NUMERIC > 21                            
C28084               COMPUTE WS-CYCLE-NUMERIC = WS-CYCLE-NUMERIC - 21   
                    END-IF                                              
                    MOVE WS-CYCLE-NUMERIC     TO WS-LOOKUP-CYCLE        
                                                 RS-DRAFT-CYCLE         
C28084* THIS SECTION ADDED TO FORCE A NUMBER FOUND IN THE PANEL'S DRAFT         
C28084*   CYCLE DROP DOWN (NO MAGIC IN THE # 7, JUST WORKS)                     
C28084              IF WS-CYCLE-NUMERIC >= 19                           
C28084                AND WS-CYCLE-NUMERIC <= 21                        
C28084                COMPUTE WS-CYCLE-NUMERIC = WS-CYCLE-NUMERIC - 7   
C28084                MOVE WS-CYCLE-NUMERIC TO RS-DRAFT-CYCLE           
C28084              END-IF                                              
                 END-IF                                                 
              END-IF                                                    
                                                                        
              IF WS-LOOKUP-CYCLE > SPACES                               
                 PERFORM 7500-SELECT-BILL-DAY THRU 7500-EXIT            
                                                                        
                 MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE         
                                                                        
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    IF WS-NULL-SPLIT-DAY-NUM = -1                       
                       MOVE SPACES            TO RS-EARLIEST-DRAFT-DAY  
                    ELSE                                                
                       MOVE WS-SPLIT-DAY-NUMERIC TO WS-SPLIT-DAY-NUM    
                       MOVE WS-SPLIT-DAY-NUM     TO WS-SPLIT-DAY        
                       MOVE WS-SPLIT-DAY    TO RS-EARLIEST-DRAFT-DAY    
                    END-IF                                              
                 ELSE                                                   
                    MOVE SPACES               TO RS-EARLIEST-DRAFT-DAY  
                 END-IF                                                 
              ELSE                                                      
                 MOVE SPACES                  TO RS-EARLIEST-DRAFT-DAY  
              END-IF                                                    
           ELSE                                                         
              MOVE SPACES                     TO RS-BILL-CYCLE          
           END-IF.                                                      
                                                                        
           IF WS-DISABLE-FLAG = 'Y'                                     
              MOVE 9999      TO WS-ACTIVE-RETURN-CODE                   
              MOVE 9999      TO RS-RETURN-CODE                          
           END-IF.                                                      
                                                                        
C29529     MOVE 'N'                          TO WS-ACTIVE-BANKS-FL      
C29529     MOVE AT-CUSTOMER-NO               TO JF-CUSTOMER-NO          
C29529     PERFORM 7800-SELECT-ACTIVE-BANKS  THRU 7800-EXIT             
C29529     IF BANK-EXISTS                                               
C29529        MOVE 'Y'                       TO RS-MULTIPLE-BANKS       
C29529     ELSE                                                         
C29529        MOVE 'N'                       TO RS-MULTIPLE-BANKS       
C29529     END-IF                                                       
                                                                        
C36437     IF PARM-REALTIME-EPAY = 'N'                                  
C36437        PERFORM 7900-SELECT-PNDNG-PYMTS   THRU 7900-EXIT          
C36437     ELSE                                                         
C36437        PERFORM 7910-SELECT-PNDNG-REALS   THRU 7910-EXIT          
C36437     END-IF                                                       
C36437     IF WS-ACTIVE-RETURN-CODE = -811                              
C36437        MOVE 'Y'                       TO RS-MULTIPLE-PND-PYMTS   
C36437     ELSE                                                         
C36437        MOVE 'N'                       TO RS-MULTIPLE-PND-PYMTS   
C36437     END-IF                                                       
                                                                        
C29529     MOVE 'NO ' TO WS-PEND-EXISTS-FLAG.                           
C29529     MOVE 'N'                          TO WS-END-OF-BANKDFT-CSR   
                                                                        
C36437     IF PARM-REALTIME-EPAY = 'N'                                  
C29529        PERFORM 7300-OPEN-BANKDFT-CURSOR  THRU 7300-EXIT          
C29529        PERFORM 7310-FETCH-BANKDFT-CURSOR THRU 7310-EXIT          
C29529        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
C29529           PERFORM UNTIL END-OF-BANKDFT-CSR                       
C29529              MOVE PB-CUST-BANK-SEQ-NO TO RS-DRFT-BNK-SEQ-NO      
C29529              MOVE PB-CUST-BANK-SEQ-NO TO WS-CUSTOMER-SEQ-NO      
C37782              MOVE SPACES TO JF-BANK-ACCT-NICKNAME                
C29529              PERFORM 7150-SELECT-BANK-NN THRU 7150-EXIT          
C29529              MOVE JF-BANK-ACCT-NICKNAME-TEXT TO RS-DRAFT-BANK-NN 
C29529              PERFORM 2300-GET-PEND-BANK-INFO THRU 2300-EXIT      
REARCH              PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT     
C29529              PERFORM 8100-SEND-RESULT     THRU 8100-EXIT         
C29529              PERFORM 7310-FETCH-BANKDFT-CURSOR THRU 7310-EXIT    
C29529              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL          
C29529                 MOVE 'Y'               TO RS-MULTIPLE-PND-PYMTS  
C32750              ELSE                                                
C32750                 MOVE 'N'               TO RS-MULTIPLE-PND-PYMTS  
C29529              END-IF                                              
C29529           END-PERFORM                                            
C29529        ELSE                                                      
C29529           MOVE 'N'                     TO RS-PENDING-BANK-DRAFT  
C32750           MOVE 'N'                     TO RS-MULTIPLE-PND-PYMTS  
T20563           MOVE ZERO                    TO RS-BALANCE-AMT         
T20563           MOVE AT-TOTAL-AR-BALANCE     TO RS-BALANCE-AMT         
BAS              MOVE ZERO                    TO RS-DRAFT-AMT           
BAS              MOVE SPACES                  TO RS-DRAFT-DATE          
REARCH           PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT           
C29529           PERFORM 8100-SEND-RESULT     THRU 8100-EXIT            
             END-IF                                                     
C29529       PERFORM 7320-CLOSE-BANKDFT-CURSOR THRU 7320-EXIT           
C36437     ELSE                                                         
C36437       PERFORM 7400-OPEN-REALTIME-CURSOR THRU 7400-EXIT           
C36437       PERFORM 7410-FETCH-REALTIME-CURSOR THRU 7410-EXIT          
C36437       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
C36437           PERFORM UNTIL END-OF-BANKDFT-CSR                       
C36437              MOVE PB-CUST-BANK-SEQ-NO TO RS-DRFT-BNK-SEQ-NO      
C36437              MOVE PB-CUST-BANK-SEQ-NO TO WS-CUSTOMER-SEQ-NO      
C37782              MOVE SPACES TO JF-BANK-ACCT-NICKNAME                
C36437              PERFORM 7150-SELECT-BANK-NN THRU 7150-EXIT          
C36437              PERFORM 2300-GET-PEND-BANK-INFO THRU 2300-EXIT      
C36437              PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT     
C36437              PERFORM 8100-SEND-RESULT     THRU 8100-EXIT         
C36437              PERFORM 7410-FETCH-REALTIME-CURSOR THRU 7410-EXIT   
C36437              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL          
C36437                 MOVE 'Y' TO RS-MULTIPLE-PND-PYMTS                
C36437              ELSE                                                
C36437                 MOVE 'N' TO RS-MULTIPLE-PND-PYMTS                
C36437              END-IF                                              
C36437           END-PERFORM                                            
C36437       ELSE                                                       
C36437           MOVE 'N' TO RS-PENDING-BANK-DRAFT                      
C36437           MOVE 'N' TO RS-MULTIPLE-PND-PYMTS                      
C36437           MOVE ZERO TO RS-BALANCE-AMT                            
C36437           MOVE AT-TOTAL-AR-BALANCE TO RS-BALANCE-AMT             
C36437           MOVE ZERO TO RS-DRAFT-AMT                              
C36437           MOVE SPACES TO RS-DRAFT-DATE                           
C36437           PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT              
C36437           PERFORM 8100-SEND-RESULT THRU 8100-EXIT                
C36437       END-IF                                                     
C36437       PERFORM 7420-CLOSE-REALTIME-CURSOR THRU 7420-EXIT          
C36437     END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
C29529******************************************************************08450000
C29529* 2300-GET-PEND-BANK-INFO                                        *08460000
C29529******************************************************************08470000
                                                                        
C29529 2300-GET-PEND-BANK-INFO.                                         
                                                                        
      *                                                                 09420000
C29529        IF PEND-EXISTS                                            
C29529           MOVE 'Y'                     TO RS-PENDING-BANK-DRAFT  
BAS              MOVE AT-TOTAL-AR-BALANCE     TO RS-BALANCE-AMT         
BAS              MOVE PB-DRAFT-AMT            TO RS-DRAFT-AMT           
BAS              MOVE PB-DRAFT-DATE           TO RS-DRAFT-DATE          
C29529           MOVE PB-CODE-SOURCE-ID       TO RS-CODE-SOURCE-ID      
C29529           MOVE PB-PYMT-TRANS-TS        TO RS-PYMT-TRAN-TIMESTMP  
C29529       ELSE                                                       
C29529           MOVE 'N'                     TO RS-PENDING-BANK-DRAFT  
T20563           MOVE ZERO                    TO RS-BALANCE-AMT         
T20563           MOVE AT-TOTAL-AR-BALANCE     TO RS-BALANCE-AMT         
BAS              MOVE ZERO                    TO RS-DRAFT-AMT           
BAS              MOVE SPACES                  TO RS-DRAFT-DATE          
C29529           MOVE SPACES                  TO RS-PYMT-TRAN-TIMESTMP  
C29529           MOVE ZERO                    TO RS-DRAFT-AMT           
C29529        END-IF.                                                   
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  10070000
      * 7000-SELECT-ACCOUNT                                          *  10080000
      ****************************************************************  10090000
                                                                        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT BILL_CYCLE,                                        
                     MST_SUB_ACCT_IND,                                  
BAS                  TOTAL_AR_BALANCE,                                  
C29529               CUSTOMER_NO,                                       
C34097               AR_XFER_IND,                                       
A03505               CREDIT_GROUP                                       
              INTO  :AT-BILL-CYCLE,                                     
                    :AT-MST-SUB-ACCT-IND,                               
BAS                 :AT-TOTAL-AR-BALANCE,                               
C29529              :AT-CUSTOMER-NO,                                    
C34097              :AT-AR-XFER-IND,                                    
A03505              :AT-CREDIT-GROUP                                    
              FROM   CSS_ACCOUNT WITH(READUNCOMMITTED)                          
              WHERE  ACCOUNT_NO   = :AT-ACCOUNT-NO                      
C34097                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     10130000
MFA-TR*       SELECT BILL_CYCLE,                                        10150000
MFA-TR*              MST_SUB_ACCT_IND,                                  11480000
MFA-TR*              TOTAL_AR_BALANCE,                                  11490000
MFA-TR*              CUSTOMER_NO,                                               
MFA-TR*              AR_XFER_IND,                                               
MFA-TR*              CREDIT_GROUP                                               
MFA-TR*       INTO  :AT-BILL-CYCLE,                                     10170000
MFA-TR*             :AT-MST-SUB-ACCT-IND,                               11510000
MFA-TR*             :AT-TOTAL-AR-BALANCE,                               11520000
MFA-TR*             :AT-CUSTOMER-NO,                                            
MFA-TR*             :AT-AR-XFER-IND,                                            
MFA-TR*             :AT-CREDIT-GROUP                                            
MFA-TR*       FROM   CSS_ACCOUNT                                        10180000
MFA-TR*       WHERE  ACCOUNT_NO   = :AT-ACCOUNT-NO                      10190000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    10200000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
PRJ547     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
PRJ547        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
PRJ547           MOVE +100 TO RS-RETURN-CODE                            
PRJ547           MOVE SPACES TO RS-BILL-CYCLE                           
PRJ547           MOVE WS-CUSTOMER-NO-NUM TO AT-CUSTOMER-NO              
PRJ547           MOVE WS-TOTAL-AR-BALANCE TO AT-TOTAL-AR-BALANCE        
PRJ547           MOVE 'N' TO RS-PENDING-BANK-DRAFT                      
PRJ547           MOVE 'N' TO RS-MULTIPLE-PND-PYMTS                      
PRJ547           MOVE ZERO TO RS-BALANCE-AMT                            
PRJ547           MOVE AT-TOTAL-AR-BALANCE TO RS-BALANCE-AMT             
PRJ547           MOVE ZERO TO RS-DRAFT-AMT                              
PRJ547           MOVE SPACES TO RS-DRAFT-DATE                           
PRJ547        END-IF                                                    
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7000'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCOUNT'        TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  10401600
      * 7020-SELECT-SUB-OF-AR-MST                                    *  10401700
      ****************************************************************  10401800
                                                                        
       7020-SELECT-SUB-OF-AR-MST.                                       
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) 'Y'                                                
              INTO  :WS-DISABLE-FLAG                                    
              FROM   CSS_ACCOUNT WITH(READUNCOMMITTED)                          
              WHERE  ACCOUNT_NO       = :AT-ACCOUNT-NO                  
               AND   MST_SUB_ACCT_IND = 'S'                             
               AND   AR_XFER_IND      = 'Y'                             
C34097                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     10402200
MFA-TR*       SELECT 'Y'                                                10402300
MFA-TR*       INTO  :WS-DISABLE-FLAG                                    10402400
MFA-TR*       FROM   CSS_ACCOUNT                                        10402500
MFA-TR*       WHERE  ACCOUNT_NO       = :AT-ACCOUNT-NO                  10402600
MFA-TR*        AND   MST_SUB_ACCT_IND = 'S'                             10402700
MFA-TR*        AND   AR_XFER_IND      = 'Y'                             10402800
MFA-TR*      FETCH FIRST ROW ONLY WITH UR                               10402800
MFA-TR*    END-EXEC.                                                    10402900

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7020'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCOUNT'        TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  10405000
      * 7100-SELECT-BANK-DRAFT                                       *  10410000
      ****************************************************************  10420000
                                                                        
       7100-SELECT-BANK-DRAFT.                                          
                                                                        
           EXEC SQL                                                     
C29529        SELECT CUSTOMER_NO,                                       
                     BANK_ACCT_NO,                                      
                     BANK_ID,                                           
                     BANK_ACCOUNT_NAME,                                 
                     ACCT_TYPE_CD,                                      
                     ESTABLISHED_DATE,                                  
                     STATUS_CHANGE_DT,                                  
                     RESUME_DRAFT_DT,                                   
                     REQSTED_DRAFT_DAY,                                 
                     DRAFT_CYCLE,                                       
TP9566               LAST_DRAFT_DATE,                                   
                     LAST_DRAFT_CYCLE,                                  
                     STATUS_CODE,                                       
                     PRENOTE_DATE,                                      
                     REMARKS,                                           
C25964               INIT_TYPE_CD,                                      
C29529               CUST_BANK_SEQ_NO                                   
C29529        INTO  :BE-CUSTOMER-NO,                                    
C29529              :BE-BANK-ACCT-NO,                                   
                    :BE-BANK-ID,                                        
                    :BE-BANK-ACCOUNT-NAME,                              
                    :BE-ACCT-TYPE-CD,                                   
                    :BE-ESTABLISHED-DATE :WS-NULL-ESTABLISHED-DATE,      
                    :BE-STATUS-CHANGE-DT :WS-NULL-STATUS-CHANGE-DT,      
                    :BE-RESUME-DRAFT-DT :WS-NULL-RESUME-DRAFT-DT,        
                    :BE-REQSTED-DRAFT-DAY,                              
                    :BE-DRAFT-CYCLE,                                    
TP9566              :BE-LAST-DRAFT-DATE :WS-NULL-LAST-DRAFT-DATE,        
                    :BE-LAST-DRAFT-CYCLE,                               
                    :BE-STATUS-CODE,                                    
                    :BE-PRENOTE-DATE :WS-NULL-PRENOTE-DATE,              
                    :BE-REMARKS,                                        
C25964              :BE-INIT-TYPE-CD,                                   
C29529              :BE-CUST-BANK-SEQ-NO                                
              FROM   CSS_BANK_EFT WITH(READUNCOMMITTED)                         
              WHERE  ACCOUNT_NO   = :BE-ACCOUNT-NO                      
C34097                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     10460000
MFA-TR*       SELECT CUSTOMER_NO,                                       10480000
MFA-TR*              BANK_ACCT_NO,                                      10480000
MFA-TR*              BANK_ID,                                           10490000
MFA-TR*              BANK_ACCOUNT_NAME,                                 10500000
MFA-TR*              ACCT_TYPE_CD,                                      10510000
MFA-TR*              ESTABLISHED_DATE,                                  10520000
MFA-TR*              STATUS_CHANGE_DT,                                  10530000
MFA-TR*              RESUME_DRAFT_DT,                                   10540000
MFA-TR*              REQSTED_DRAFT_DAY,                                 10550000
MFA-TR*              DRAFT_CYCLE,                                       10560000
MFA-TR*              LAST_DRAFT_DATE,                                   10570000
MFA-TR*              LAST_DRAFT_CYCLE,                                  10571000
MFA-TR*              STATUS_CODE,                                       10580000
MFA-TR*              PRENOTE_DATE,                                      10590000
MFA-TR*              REMARKS,                                           10600000
MFA-TR*              INIT_TYPE_CD,                                              
MFA-TR*              CUST_BANK_SEQ_NO                                           
MFA-TR*       INTO  :BE-CUSTOMER-NO,                                    10620000
MFA-TR*             :BE-BANK-ACCT-NO,                                   10620000
MFA-TR*             :BE-BANK-ID,                                        10630000
MFA-TR*             :BE-BANK-ACCOUNT-NAME,                              10640000
MFA-TR*             :BE-ACCT-TYPE-CD,                                   10650000
MFA-TR*             :BE-ESTABLISHED-DATE:WS-NULL-ESTABLISHED-DATE,      10660000
MFA-TR*             :BE-STATUS-CHANGE-DT:WS-NULL-STATUS-CHANGE-DT,      10670000
MFA-TR*             :BE-RESUME-DRAFT-DT:WS-NULL-RESUME-DRAFT-DT,        10680000
MFA-TR*             :BE-REQSTED-DRAFT-DAY,                              10690000
MFA-TR*             :BE-DRAFT-CYCLE,                                    10700000
MFA-TR*             :BE-LAST-DRAFT-DATE:WS-NULL-LAST-DRAFT-DATE,        10701000
MFA-TR*             :BE-LAST-DRAFT-CYCLE,                               10710000
MFA-TR*             :BE-STATUS-CODE,                                    10720000
MFA-TR*             :BE-PRENOTE-DATE:WS-NULL-PRENOTE-DATE,              10730000
MFA-TR*             :BE-REMARKS,                                        10740000
MFA-TR*             :BE-INIT-TYPE-CD,                                           
MFA-TR*             :BE-CUST-BANK-SEQ-NO                                        
MFA-TR*       FROM   CSS_BANK_EFT                                       10750000
MFA-TR*       WHERE  ACCOUNT_NO   = :BE-ACCOUNT-NO                      10760000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    10770000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
C29529     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C29529        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
C29529           MOVE 'Y'                         TO WS-BANK-DRFT-FOUND 
C29529        END-IF                                                    
PRJ526        PERFORM 7920-CHECK-AUTOCARD-STATUS THRU 7920-EXIT         
           ELSE                                                         
              MOVE PROGRAM-NAME                   TO ABEND-PROGRAM      
              MOVE '7100'                         TO ACTIVE-PARAGRAPH   
              MOVE 'SELECT'                       TO ABEND-FUNCTION     
              MOVE 'CSS_BANK_EFT'                 TO TABLE-1            
              MOVE 'ACCOUNT_NO'                   TO TABLE-ELEMENT-1    
              MOVE BE-ACCOUNT-NO                  TO HOSTVAR-ELEMENT-1  
              PERFORM 9000-SEND-ERROR-RESULT      THRU 9000-EXIT        
              PERFORM 9900-SQL-ERROR-ROUTINE      THRU 9900-EXIT        
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
C29529****************************************************************  10970000
C29529* SELECT THE BANK NICKNAME                                     *  10980000
C29529****************************************************************  10990000
C29529 7150-SELECT-BANK-NN.                                             
C29529     EXEC SQL                                                     
C29529        SELECT BANK_ACCT_NICKNAME                                 
C29529          INTO :JF-BANK-ACCT-NICKNAME                             
C29529          FROM CSS_CUSTOMER_BANK WITH(READUNCOMMITTED)                    
C29529         WHERE CUSTOMER_NO      = :BE-CUSTOMER-NO                 
C29529          AND  CUST_BANK_SEQ_NO = :WS-CUSTOMER-SEQ-NO             
C34097                                                           
C29529     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     11030000
MFA-TR*       SELECT BANK_ACCT_NICKNAME                                 11040000
MFA-TR*         INTO :JF-BANK-ACCT-NICKNAME                             11090000
MFA-TR*         FROM CSS_CUSTOMER_BANK                                  11140000
MFA-TR*        WHERE CUSTOMER_NO      = :BE-CUSTOMER-NO                 11150000
MFA-TR*         AND  CUST_BANK_SEQ_NO = :WS-CUSTOMER-SEQ-NO                     
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    11160000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29529                                                                  
C29529     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
C29529                                                                  
C29529     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C29529        NEXT SENTENCE                                             
C29529     ELSE                                                         
C29529        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
C29529           MOVE SPACES            TO JF-BANK-ACCT-NICKNAME-TEXT   
C29529        ELSE                                                      
C29529           MOVE PROGRAM-NAME      TO ABEND-PROGRAM                
C29529           MOVE '7150'            TO ACTIVE-PARAGRAPH             
C29529           MOVE 'SELECT'          TO ABEND-FUNCTION               
C29529           MOVE 'CSS_CUSTOMER_BANK' TO TABLE-1                    
CBSI             MOVE 'CUSTOMER_NO'     TO TABLE-ELEMENT-2              
C29529           MOVE BE-CUSTOMER-NO    TO HOSTVAR-ELEMENT-1            
C29529           PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
C29529           PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
C29529        END-IF                                                    
C29529     END-IF.                                                      
C29529                                                                  
C29529 7150-EXIT.                                                       
C29529     EXIT.                                                        
      ****************************************************************  10970000
      * 7200-SELECT-BANK                                             *  10980000
      ****************************************************************  10990000
                                                                        
       7200-SELECT-BANK.                                                
                                                                        
           EXEC SQL                                                     
              SELECT BANK_ID,                                           
                     BANK_NAME,                                         
                     BANK_CITY,                                         
                     BANK_STATE,                                        
                     ROUTING_NUMBER                                     
              INTO  :D1-BANK-ID,                                        
                    :D1-BANK-NAME,                                      
                    :D1-BANK-CITY,                                      
                    :D1-BANK-STATE,                                     
                    :D1-ROUTING-NUMBER                                  
              FROM   CSS_BANK WITH(READUNCOMMITTED)                             
              WHERE  BANK_ID      = :BE-BANK-ID                         
C34097                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     11030000
MFA-TR*       SELECT BANK_ID,                                           11040000
MFA-TR*              BANK_NAME,                                         11050000
MFA-TR*              BANK_CITY,                                         11060000
MFA-TR*              BANK_STATE,                                        11070000
MFA-TR*              ROUTING_NUMBER                                     11080000
MFA-TR*       INTO  :D1-BANK-ID,                                        11090000
MFA-TR*             :D1-BANK-NAME,                                      11100000
MFA-TR*             :D1-BANK-CITY,                                      11110000
MFA-TR*             :D1-BANK-STATE,                                     11120000
MFA-TR*             :D1-ROUTING-NUMBER                                  11130000
MFA-TR*       FROM   CSS_BANK                                           11140000
MFA-TR*       WHERE  BANK_ID      = :BE-BANK-ID                         11150000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    11160000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7200'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_BANK'           TO TABLE-1                      
              MOVE 'BANK_ID'            TO TABLE-ELEMENT-1              
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE BE-BANK-ID           TO HOSTVAR-ELEMENT-1            
CBSI          MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
C29529****************************************************************          
C29529*   CHANGING PENDING BANK DRAFT SELECT TO A FETCH                         
C29529****************************************************************          
C29529 7300-OPEN-BANKDFT-CURSOR.                                        
C29529                                                                  
C29529     EXEC SQL                                                     
C29529        OPEN BANKDFT_CURSOR                                       
C29529     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29529                                                                  
C29529     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C29529     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C29529        NEXT SENTENCE                                             
C29529     ELSE                                                         
C29529        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
C29529        MOVE '7300'               TO ACTIVE-PARAGRAPH             
C29529        MOVE 'OPEN'               TO ABEND-FUNCTION               
C29529        MOVE 'CSS_PNDNG_BNK_DRFT' TO TABLE-1                      
C29529        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
C29529        MOVE PB-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
C29529        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C29529        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C29529     END-IF.                                                      
C29529                                                                  
C29529 7300-EXIT.                                                       
C29529     EXIT.                                                        
                                                                        
C29529 7310-FETCH-BANKDFT-CURSOR.                                       
                                                                        
C29529     EXEC SQL                                                     
C29529       FETCH BANKDFT_CURSOR                                       
C29529       INTO  :WS-PEND-EXISTS-FLAG,                                
C29529             :PB-DRAFT-AMT,                                       
C29529             :PB-DRAFT-DATE,                                      
C29529             :PB-CODE-SOURCE-ID,                                  
C29529             :PB-CUST-BANK-SEQ-NO,                                
C29529             :PB-PYMT-TRANS-TS                                    
C29529     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C29529     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
C29529     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C29529         CONTINUE                                                 
           ELSE                                                         
C29529         IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
C29529            MOVE 'Y'                  TO WS-END-OF-BANKDFT-CSR    
C29529         ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE '7310'               TO ACTIVE-PARAGRAPH         
C29529            MOVE 'FETCH'              TO ABEND-FUNCTION           
                  MOVE 'CSS_PNDNG_BNK_DRFT' TO TABLE-1                  
                  MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1          
                  MOVE PB-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1        
                  PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
               END-IF                                                   
           END-IF.                                                      
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************33760000
      * 7320-CLOSE-BANKDFT-CURSOR                                      *33770000
      ******************************************************************33780000
       7320-CLOSE-BANKDFT-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
              CLOSE BANKDFT_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C29529     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7320'               TO ACTIVE-PARAGRAPH             
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE 'CSS_PNDNG_BNK_DRFT' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE PB-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
C36437****************************************************************          
C36437*   OPEN REALTIME_CURSOR TO SELECT ALL PENDING                            
C36437*   PAYMENTS - INCLUDING REALTIME.                                        
C36437****************************************************************          
C36437 7400-OPEN-REALTIME-CURSOR.                                       
C36437                                                                  
C36437     EXEC SQL                                                     
C36437        OPEN REALTIME_CURSOR                                      
C36437     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36437                                                                  
C36437     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C36437     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C36437        NEXT SENTENCE                                             
C36437     ELSE                                                         
C36437        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
C36437        MOVE '7400'               TO ACTIVE-PARAGRAPH             
C36437        MOVE 'OPEN'               TO ABEND-FUNCTION               
C36437        MOVE 'CSS_PNDNG_BNK_DRFT' TO TABLE-1                      
C36437        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
C36437        MOVE PB-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
C36437        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C36437        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C36437     END-IF.                                                      
C36437                                                                  
C36437 7400-EXIT.                                                       
C36437     EXIT.                                                        
C36437                                                                  
C36437****************************************************************          
C36437*   FETCH REALTIME_CURSOR                                                 
C36437****************************************************************          
C36437 7410-FETCH-REALTIME-CURSOR.                                      
C36437                                                                  
C36437     EXEC SQL                                                     
C36437       FETCH REALTIME_CURSOR                                      
C36437       INTO  :WS-PEND-EXISTS-FLAG,                                
C36437             :PB-DRAFT-AMT,                                       
C36437             :PB-DRAFT-DATE,                                      
C36437             :PB-CODE-SOURCE-ID,                                  
C36437             :PB-CUST-BANK-SEQ-NO,                                
C36437             :PB-PYMT-TRANS-TS                                    
C36437     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36437                                                                  
C36437     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C36437     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C36437         CONTINUE                                                 
C36437     ELSE                                                         
C36437         IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
C36437            MOVE 'Y' TO WS-END-OF-BANKDFT-CSR                     
C36437         ELSE                                                     
C36437            MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
C36437            MOVE '7410'               TO ACTIVE-PARAGRAPH         
C36437            MOVE 'FETCH'              TO ABEND-FUNCTION           
C36437            MOVE 'CSS_PNDNG_BNK_DRFT' TO TABLE-1                  
C36437            MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1          
C36437            MOVE PB-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1        
C36437            PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
C36437            PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
C36437         END-IF                                                   
C36437     END-IF.                                                      
C36437 7410-EXIT.                                                       
C36437     EXIT.                                                        
C36437                                                                  
C36437******************************************************************33760000
C36437* 7420-CLOSE-REALTIME-CURSOR                                     *33770000
C36437******************************************************************33780000
C36437 7420-CLOSE-REALTIME-CURSOR.                                      
C36437                                                                  
C36437     EXEC SQL                                                     
C36437        CLOSE REALTIME_CURSOR                                     
C36437     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36437                                                                  
C36437     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C36437     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C36437        NEXT SENTENCE                                             
C36437     ELSE                                                         
C36437        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
C36437        MOVE '7420'               TO ACTIVE-PARAGRAPH             
C36437        MOVE 'CLOSE'              TO ABEND-FUNCTION               
C36437        MOVE 'CSS_PNDNG_BNK_DRFT' TO TABLE-1                      
C36437        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
C36437        MOVE PB-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
C36437        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C36437        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C36437     END-IF.                                                      
C36437                                                                  
C36437 7420-EXIT.                                                       
C36437     EXIT.                                                        
                                                                        
      ******************************************************************12000000
      * 7500-SELECT-BILL-DAY                                          * 12010000
      ******************************************************************12020000
                                                                        
       7500-SELECT-BILL-DAY.                                            
                                                                        
           EXEC SQL                                                     
              SELECT MIN(DAY(DATE_EXTRACT))                             
              INTO :WS-SPLIT-DAY-NUMERIC :WS-NULL-SPLIT-DAY-NUM          
              FROM   CSS_BILL_WINDOW WITH(READUNCOMMITTED)                      
C23691        WHERE  BILL_CYCLE     = :WS-LOOKUP-CYCLE                  
T20954        AND    DATE_EXTRACT  >= CAST(SYSDATETIMEOFFSET() AS DATE)         
C34097                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     12060000
MFA-TR*       SELECT MIN(DAY(DATE_EXTRACT))                             12070000
MFA-TR*       INTO :WS-SPLIT-DAY-NUMERIC:WS-NULL-SPLIT-DAY-NUM          12080000
MFA-TR*       FROM   CSS_BILL_WINDOW                                    12090000
MFA-TR*       WHERE  BILL_CYCLE     = :WS-LOOKUP-CYCLE                  12110000
MFA-TR*       AND    DATE_EXTRACT  >= CURRENT DATE                              
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    12120000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME    TO ABEND-PROGRAM                    
               MOVE '7500'          TO ACTIVE-PARAGRAPH                 
CBSI           MOVE 'SELECT'          TO ABEND-FUNCTION                 
               MOVE 'CSS_BILL_WINDOW' TO TABLE-1                        
               MOVE 'BILL_CYCLE'      TO TABLE-ELEMENT-1                
CBSI           MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-2                
CBSI           MOVE WS-LOOKUP-CYCLE   TO HOSTVAR-ELEMENT-1              
CBSI           MOVE PARM-ACCOUNT-NO   TO HOSTVAR-ELEMENT-2              
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  12310000
      * 7700-SELECT-NAME                                             *  12320000
      ****************************************************************  12330000
                                                                        
       7700-SELECT-NAME.                                                
                                                                        
           EXEC SQL                                                     
              SELECT C.FULL_NAME                                        
              INTO  :DQ-FULL-NAME                                       
              FROM   CSS_ACCOUNT A WITH(READUNCOMMITTED),                       
                     CSS_CUSTOMER B WITH(READUNCOMMITTED),                      
                     CSS_NAME C WITH(READUNCOMMITTED)                           
              WHERE  A.ACCOUNT_NO    = :AT-ACCOUNT-NO                   
                AND  A.CUSTOMER_NO   = B.CUSTOMER_NO                    
                AND  B.NAME_ID       = C.NAME_ID                        
C34097                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     12370000
MFA-TR*       SELECT C.FULL_NAME                                        12390000
MFA-TR*       INTO  :DQ-FULL-NAME                                       12410000
MFA-TR*       FROM   CSS_ACCOUNT A,                                     12420000
MFA-TR*              CSS_CUSTOMER B,                                    12421000
MFA-TR*              CSS_NAME C                                         12422000
MFA-TR*       WHERE  A.ACCOUNT_NO    = :AT-ACCOUNT-NO                   12430000
MFA-TR*         AND  A.CUSTOMER_NO   = B.CUSTOMER_NO                    12431000
MFA-TR*         AND  B.NAME_ID       = C.NAME_ID                        12432000
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                    12440000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
              MOVE '7700'                  TO ACTIVE-PARAGRAPH          
              MOVE 'SELECT'                TO ABEND-FUNCTION            
              MOVE 'CSS_NAME'              TO TABLE-1                   
CBSI          MOVE 'CSS_ACCOUNT'           TO TABLE-2                   
CBSI          MOVE 'CSS_CUSTOMER'          TO TABLE-3                   
              MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
              MOVE AT-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1         
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
C29529****************************************************************  12310000
C29529* 7800-SELECT-ACTIVE-BANKS                                     *  12320000
C29529****************************************************************  12330000
C29529                                                                  
C29529 7800-SELECT-ACTIVE-BANKS.                                        
C29529                                                                  
C29529     EXEC SQL                                                     
C29529        SELECT TOP(1) 'Y'                                                
C29529          INTO :WS-ACTIVE-BANKS-FL                                
C29529          FROM CSS_CUSTOMER_BANK WITH(READUNCOMMITTED)                    
C29529         WHERE CUSTOMER_NO       =:JF-CUSTOMER-NO                 
C29529          AND BANK_ACCT_STAT_CD  IN ('A', 'P')                    
C34097                                       
C29529     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     12370000
MFA-TR*       SELECT 'Y'                                                12390000
MFA-TR*         INTO :WS-ACTIVE-BANKS-FL                                12410000
MFA-TR*         FROM CSS_CUSTOMER_BANK                                  12420000
MFA-TR*        WHERE CUSTOMER_NO       =:JF-CUSTOMER-NO                 12430000
MFA-TR*         AND BANK_ACCT_STAT_CD  IN ('A', 'P')                    12431000
MFA-TR*       FETCH FIRST ROW ONLY WITH UR                                      
MFA-TR*    END-EXEC.                                                    12440000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29529                                                                  
C29529     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
C29529                                                                  
C29529     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C29529        OR -811                                                   
C29529        CONTINUE                                                  
C29529     ELSE                                                         
C29529        MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
C29529        MOVE '7800'                  TO ACTIVE-PARAGRAPH          
C29529        MOVE 'SELECT'                TO ABEND-FUNCTION            
C29529        MOVE 'CSS_CUSTOMER_BANK'     TO TABLE-1                   
C29529        MOVE 'CUSTOMER_NO'           TO TABLE-ELEMENT-1           
C29529        MOVE JF-CUSTOMER-NO          TO HOSTVAR-ELEMENT-1         
C29529        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C29529        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C29529     END-IF.                                                      
C29529                                                                  
C29529 7800-EXIT.                                                       
C29529     EXIT.                                                        
                                                                        
C29529****************************************************************  12310000
C29529* 7900-SELECT-PNDNG-PYMTS                                      *  12320000
C29529****************************************************************  12330000
C36437                                                                  
C36437 7900-SELECT-PNDNG-PYMTS.                                         
C36437                                                                  
C36437     EXEC SQL                                                     
C36437        SELECT TRANSACTION_CD                                     
C36437          INTO :PB-TRANSACTION-CD                                 
C36437          FROM CSS_PNDNG_BNK_DRFT WITH(READUNCOMMITTED)                   
C36437         WHERE  ACCOUNT_NO      = :PB-ACCOUNT-NO                  
C36437           AND  TRANSACTION_CD IN (27, 37)                        
C36437           AND  PYMT_POSTED_FL  = 'N'                             
C36437                                                           
C36437     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     12370000
MFA-TR*       SELECT TRANSACTION_CD                                     12390000
MFA-TR*         INTO :PB-TRANSACTION-CD                                 12390000
MFA-TR*         FROM CSS_PNDNG_BNK_DRFT                                 12420000
MFA-TR*        WHERE  ACCOUNT_NO      = :PB-ACCOUNT-NO                  12430000
MFA-TR*          AND  TRANSACTION_CD IN (27, 37)                        12431000
MFA-TR*          AND  PYMT_POSTED_FL  = 'N'                                     
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    12440000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36437                                                                  
C36437     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
C36437                                                                  
C36437     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C36437        OR -811                                                   
C36437        CONTINUE                                                  
C36437     ELSE                                                         
C36437        MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
C36437        MOVE '7900'                  TO ACTIVE-PARAGRAPH          
C36437        MOVE 'SELECT'                TO ABEND-FUNCTION            
C36437        MOVE 'CSS_PNDNG_BNK_DRFT'    TO TABLE-1                   
C36437        MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
C36437        MOVE PB-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1         
C36437        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C36437        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C36437     END-IF.                                                      
C36437                                                                  
C36437 7900-EXIT.                                                       
C36437     EXIT.                                                        
                                                                        
C36437****************************************************************  12310000
C36437* 7910-SELECT-PNDNG-REALS                                      *  12320000
C36437****************************************************************  12330000
C36437                                                                  
C36437 7910-SELECT-PNDNG-REALS.                                         
C36437                                                                  
C36437     EXEC SQL                                                     
C36437        SELECT TRANSACTION_CD                                     
C36437          INTO :PB-TRANSACTION-CD                                 
C36437          FROM CSS_PNDNG_BNK_DRFT WITH(READUNCOMMITTED)                   
C36437         WHERE  ACCOUNT_NO      = :PB-ACCOUNT-NO                  
C36437           AND  TRANSACTION_CD IN (27, 37)                        
C36437                                                           
C36437     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     12370000
MFA-TR*       SELECT TRANSACTION_CD                                     12390000
MFA-TR*         INTO :PB-TRANSACTION-CD                                 12390000
MFA-TR*         FROM CSS_PNDNG_BNK_DRFT                                 12420000
MFA-TR*        WHERE  ACCOUNT_NO      = :PB-ACCOUNT-NO                  12430000
MFA-TR*          AND  TRANSACTION_CD IN (27, 37)                        12431000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    12440000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C36437                                                                  
C36437     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
C36437                                                                  
C36437     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C36437        OR -811                                                   
C36437        CONTINUE                                                  
C36437     ELSE                                                         
C36437        MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
C36437        MOVE '7910'                  TO ACTIVE-PARAGRAPH          
C36437        MOVE 'SELECT'                TO ABEND-FUNCTION            
C36437        MOVE 'CSS_PNDNG_BNK_DRFT'    TO TABLE-1                   
C36437        MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1           
C36437        MOVE PB-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1         
C36437        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C36437        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C36437     END-IF.                                                      
C36437                                                                  
C36437 7910-EXIT.                                                       
C36437     EXIT.                                                        
                                                                        
PRJ526****************************************************************  12310000
PRJ526* 7920-CHECK-AUTOCARD-STATUS                                   *  12320000
PRJ526****************************************************************  12330000
PRJ526                                                                  
PRJ526 7920-CHECK-AUTOCARD-STATUS.                                      
PRJ526                                                                  
PRJ526     EXEC SQL                                                     
PRJ526        SELECT STATUS_CD                                          
PRJ526          INTO :YP-STATUS-CD                                      
PRJ526          FROM CSS_ACCT_ATTRIBUTE WITH(READUNCOMMITTED)                   
PRJ526         WHERE ACCOUNT_NO      = :AT-ACCOUNT-NO                   
PRJ526           AND ATTRIBUTE_DESC     = 'AUTO_CARD_PAY'               
PRJ526           AND ATTRIBUTE_VALUE_CD = 'AUTOC'                       
PRJ526                                                           
PRJ526     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     12370000
MFA-TR*       SELECT STATUS_CD                                          12390000
MFA-TR*         INTO :YP-STATUS-CD                                      12390000
MFA-TR*         FROM CSS_ACCT_ATTRIBUTE                                 12420000
MFA-TR*        WHERE ACCOUNT_NO      = :AT-ACCOUNT-NO                   12430000
MFA-TR*          AND ATTRIBUTE_DESC     = 'AUTO_CARD_PAY'               07840000
MFA-TR*          AND ATTRIBUTE_VALUE_CD = 'AUTOC'                       12431000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    12440000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ526                                                                  
PRJ526     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
PRJ526                                                                  
PRJ526     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
PRJ526        MOVE YP-STATUS-CD TO RS-AUTOCARD-STATUS-CD                
PRJ526        IF YP-STATUS-CD = 'A'                                     
PRJ526           PERFORM 7930-CHECK-AUTOCARD-PNDNG THRU 7930-EXIT       
PRJ526        END-IF                                                    
PRJ526     ELSE                                                         
PRJ526        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
PRJ526           MOVE SPACES TO RS-AUTOCARD-STATUS-CD                   
PRJ526        ELSE                                                      
PRJ526           MOVE PROGRAM-NAME            TO ABEND-PROGRAM          
PRJ526           MOVE '7920'                  TO ACTIVE-PARAGRAPH       
PRJ526           MOVE 'SELECT'                TO ABEND-FUNCTION         
PRJ526           MOVE 'CSS_ACCT_ATTRIBUTE'    TO TABLE-1                
PRJ526           MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1        
PRJ526           MOVE AT-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1      
PRJ526           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
PRJ526           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
PRJ526        END-IF                                                    
PRJ526     END-IF.                                                      
PRJ526                                                                  
PRJ526 7920-EXIT.                                                       
PRJ526     EXIT.                                                        
PRJ526                                                                  
PRJ526****************************************************************  12310000
PRJ526* 7930-CHECK-AUTOCARD-PNDNG                                    *  12320000
PRJ526****************************************************************  12330000
PRJ526                                                                  
PRJ526 7930-CHECK-AUTOCARD-PNDNG.                                       
PRJ526                                                                  
PRJ526     EXEC SQL                                                     
PRJ526        SELECT TOP(1) PAYMENT_DATE                                       
PRJ526          INTO :PC-PAYMENT-DATE                                   
PRJ526          FROM CSS_PNDNG_CARD_PMT WITH(READUNCOMMITTED)                   
PRJ526         WHERE ACCOUNT_NO      = :AT-ACCOUNT-NO                   
PRJ526           AND STATUS_CODE IN ('A', 'E')                          
PRJ613      ORDER BY PAYMENT_DATE DESC                                  
PRJ526                                       
PRJ526     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     12370000
MFA-TR*       SELECT PAYMENT_DATE                                       12390000
MFA-TR*         INTO :PC-PAYMENT-DATE                                   12390000
MFA-TR*         FROM CSS_PNDNG_CARD_PMT                                 12420000
MFA-TR*        WHERE ACCOUNT_NO      = :AT-ACCOUNT-NO                   12430000
MFA-TR*          AND STATUS_CODE IN ('A', 'E')                          12431000
MFA-TR*     ORDER BY PAYMENT_DATE DESC                                          
MFA-TR*     FETCH FIRST ROW ONLY WITH UR                                10402800
MFA-TR*    END-EXEC.                                                    12440000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PRJ526                                                                  
PRJ526     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
PRJ526                                                                  
PRJ526     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
PRJ526        MOVE PC-PAYMENT-DATE TO RS-AUTOCARD-PYMT-DATE             
PRJ526     ELSE                                                         
PRJ526        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
PRJ526           MOVE SPACES TO RS-AUTOCARD-PYMT-DATE                   
PRJ526        ELSE                                                      
PRJ526           MOVE PROGRAM-NAME            TO ABEND-PROGRAM          
PRJ526           MOVE '7930'                  TO ACTIVE-PARAGRAPH       
PRJ526           MOVE 'SELECT'                TO ABEND-FUNCTION         
PRJ526           MOVE 'CSS_PNDNG_CARD_PMT'    TO TABLE-1                
PRJ526           MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1        
PRJ526           MOVE AT-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1      
PRJ526           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
PRJ526           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
PRJ526        END-IF                                                    
PRJ526     END-IF.                                                      
PRJ526                                                                  
PRJ526 7930-EXIT.                                                       
PRJ526     EXIT.                                                        
PRJ526                                                                  
REARCH****************************************************************  12310000
REARCH* 8100-SEND-RESULT.                                            *  12320000
REARCH****************************************************************  12330000
REARCH 8100-SEND-RESULT.                                                
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH          INSERT INTO #CSR02233_R1                         
REARCH          (                                                       
REARCH                RETURN_CODE                                       
REARCH               ,STATUS_CODE                                       
REARCH               ,STATUS_CHANGE_DT                                  
REARCH               ,RESUME_DRAFT_DT                                   
REARCH               ,REQSTED_DRAFT_DAY                                 
REARCH               ,DRAFT_CYCLE                                       
REARCH               ,EARLIEST_DRAFT_DAY                                
REARCH               ,BILL_CYCLE                                        
REARCH               ,DATE_EXTRACT                                      
REARCH               ,LAST_DRAFT_CYCLE                                  
REARCH               ,ESTABLISHED_DATE                                  
REARCH               ,PRENOTE_DATE                                      
REARCH               ,REMARKS                                           
REARCH               ,BANK_ACCOUNT_NAME                                 
REARCH               ,BANK_ACCT_NO                                      
REARCH               ,ACCT_TYPE_CD                                      
REARCH               ,NAME_BANK                                         
REARCH               ,BANK_CITY                                         
REARCH               ,BANK_STATE                                        
REARCH               ,ROUTING_NUMBER                                    
REARCH               ,PENDING_BANK_DRAFT                                
REARCH               ,BANK_ID                                           
REARCH               ,DRAFT_AMT                                         
REARCH               ,BALANCE_AMT                                       
REARCH               ,DRAFT_DATE                                        
REARCH               ,INIT_TYPE_CD                                      
REARCH               ,BANK_PRIM_NICKNAME                                
REARCH               ,BANK_ACCT_NICKNAME                                
REARCH               ,CODE_SOURCE_ID                                    
REARCH               ,PYMT_TRAN_TIMESTMP                                
REARCH               ,MULTIPLE_BANKS                                    
REARCH               ,MULTIPLE_PND_PYMTS                                
REARCH               ,PMY_CUST_SEQ_NO                                   
REARCH               ,DRFT_BANK_SEQ_NO                                  
PRJ526               ,AUTOCARD_STATUS_CD                                
PRJ526               ,AUTOCARD_PYMT_DATE                                
A03505               ,CREDIT_GROUP                                      
REARCH          )                                                       
REARCH          VALUES                                                  
REARCH          (                                                       
REARCH                :S-RETURN-CODE                                    
REARCH               ,:S-STATUS-CODE                                    
REARCH               ,:S-STATUS-CHANGE-DT                               
REARCH               ,:S-RESUME-DRAFT-DT                                
REARCH               ,:S-REQSTED-DRAFT-DAY                              
REARCH               ,:S-DRAFT-CYCLE                                    
REARCH               ,:S-EARLIEST-DRAFT-DAY                             
REARCH               ,:S-BILL-CYCLE                                     
REARCH               ,:S-DATE-EXTRACT                                   
REARCH               ,:S-LAST-DRAFT-CYCLE                               
REARCH               ,:S-ESTABLISHED-DATE                               
REARCH               ,:S-PRENOTE-DATE                                   
REARCH               ,:S-REMARKS                                        
REARCH               ,:S-BANK-ACCOUNT-NAME                              
REARCH               ,:S-BANK-ACCT-NO                                   
REARCH               ,:S-ACCT-TYPE-CD                                   
REARCH               ,:S-NAME-BANK                                      
REARCH               ,:S-BANK-CITY                                      
REARCH               ,:S-BANK-STATE                                     
REARCH               ,:S-ROUTING-NUMBER                                 
REARCH               ,:S-PENDING-BANK-DRAFT                             
REARCH               ,:S-BANK-ID                                        
REARCH               ,:S-DRAFT-AMT                                      
REARCH               ,:S-BALANCE-AMT                                    
REARCH               ,:S-DRAFT-DATE                                     
REARCH               ,:S-INIT-TYPE-CD                                   
REARCH               ,:S-PRIMARY-BANK-NN                                
REARCH               ,:S-DRAFT-BANK-NN                                  
REARCH               ,:S-CODE-SOURCE-ID                                 
REARCH               ,:S-PYMT-TRAN-TIMESTMP                             
REARCH               ,:S-MULTIPLE-BANKS                                 
REARCH               ,:S-MULTIPLE-PND-PYMTS                             
REARCH               ,:S-CUST-BNK-SEQ-NO                                
REARCH               ,:S-DRFT-BNK-SEQ-NO                                
PRJ526               ,:S-AUTOCARD-STATUS-CD                             
PRJ526               ,:S-AUTOCARD-PYMT-DATE                             
A03505               ,:S-CREDIT-GROUP                                   
REARCH          )                                                       
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR02233_R1                                 
MFA-TR*         (                                                               
MFA-TR*               RETURN_CODE                                       01670000
MFA-TR*              ,STATUS_CODE                                       01680000
MFA-TR*              ,STATUS_CHANGE_DT                                  01690000
MFA-TR*              ,RESUME_DRAFT_DT                                   01700000
MFA-TR*              ,REQSTED_DRAFT_DAY                                 01710000
MFA-TR*              ,DRAFT_CYCLE                                       01720000
MFA-TR*              ,EARLIEST_DRAFT_DAY                                01730000
MFA-TR*              ,BILL_CYCLE                                        01740000
MFA-TR*              ,DATE_EXTRACT                                      01750000
MFA-TR*              ,LAST_DRAFT_CYCLE                                  01760000
MFA-TR*              ,ESTABLISHED_DATE                                  01770000
MFA-TR*              ,PRENOTE_DATE                                      01780000
MFA-TR*              ,REMARKS                                           01790000
MFA-TR*              ,BANK_ACCOUNT_NAME                                 01800000
MFA-TR*              ,BANK_ACCT_NO                                      01810000
MFA-TR*              ,ACCT_TYPE_CD                                      01820000
MFA-TR*              ,NAME_BANK                                         01830000
MFA-TR*              ,BANK_CITY                                         01840000
MFA-TR*              ,BANK_STATE                                        01850000
MFA-TR*              ,ROUTING_NUMBER                                    01860000
MFA-TR*              ,PENDING_BANK_DRAFT                                01870000
MFA-TR*              ,BANK_ID                                           01880000
MFA-TR*              ,DRAFT_AMT                                         02000001
MFA-TR*              ,BALANCE_AMT                                       02010001
MFA-TR*              ,DRAFT_DATE                                        02020003
MFA-TR*              ,INIT_TYPE_CD                                      01890000
MFA-TR*              ,BANK_PRIM_NICKNAME                                        
MFA-TR*              ,BANK_ACCT_NICKNAME                                        
MFA-TR*              ,CODE_SOURCE_ID                                            
MFA-TR*              ,PYMT_TRAN_TIMESTMP                                        
MFA-TR*              ,MULTIPLE_BANKS                                            
MFA-TR*              ,MULTIPLE_PND_PYMTS                                        
MFA-TR*              ,PMY_CUST_SEQ_NO                                           
MFA-TR*              ,DRFT_BANK_SEQ_NO                                          
MFA-TR*              ,AUTOCARD_STATUS_CD                                        
MFA-TR*              ,AUTOCARD_PYMT_DATE                                        
MFA-TR*              ,CREDIT_GROUP                                              
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*               :S-RETURN-CODE                                    01670000
MFA-TR*              ,:S-STATUS-CODE                                    01680000
MFA-TR*              ,:S-STATUS-CHANGE-DT                               01690000
MFA-TR*              ,:S-RESUME-DRAFT-DT                                01700000
MFA-TR*              ,:S-REQSTED-DRAFT-DAY                              01710000
MFA-TR*              ,:S-DRAFT-CYCLE                                    01720000
MFA-TR*              ,:S-EARLIEST-DRAFT-DAY                             01730000
MFA-TR*              ,:S-BILL-CYCLE                                     01740000
MFA-TR*              ,:S-DATE-EXTRACT                                   01750000
MFA-TR*              ,:S-LAST-DRAFT-CYCLE                               01760000
MFA-TR*              ,:S-ESTABLISHED-DATE                               01770000
MFA-TR*              ,:S-PRENOTE-DATE                                   01780000
MFA-TR*              ,:S-REMARKS                                        01790000
MFA-TR*              ,:S-BANK-ACCOUNT-NAME                              01800000
MFA-TR*              ,:S-BANK-ACCT-NO                                   01810000
MFA-TR*              ,:S-ACCT-TYPE-CD                                   01820000
MFA-TR*              ,:S-NAME-BANK                                      01830000
MFA-TR*              ,:S-BANK-CITY                                      01840000
MFA-TR*              ,:S-BANK-STATE                                     01850000
MFA-TR*              ,:S-ROUTING-NUMBER                                 01860000
MFA-TR*              ,:S-PENDING-BANK-DRAFT                             01870000
MFA-TR*              ,:S-BANK-ID                                        01880000
MFA-TR*              ,:S-DRAFT-AMT                                      02000001
MFA-TR*              ,:S-BALANCE-AMT                                    02010001
MFA-TR*              ,:S-DRAFT-DATE                                     02020003
MFA-TR*              ,:S-INIT-TYPE-CD                                   01890000
MFA-TR*              ,:S-PRIMARY-BANK-NN                                        
MFA-TR*              ,:S-DRAFT-BANK-NN                                          
MFA-TR*              ,:S-CODE-SOURCE-ID                                         
MFA-TR*              ,:S-PYMT-TRAN-TIMESTMP                                     
MFA-TR*              ,:S-MULTIPLE-BANKS                                         
MFA-TR*              ,:S-MULTIPLE-PND-PYMTS                                     
MFA-TR*              ,:S-CUST-BNK-SEQ-NO                                        
MFA-TR*              ,:S-DRFT-BNK-SEQ-NO                                        
MFA-TR*              ,:S-AUTOCARD-STATUS-CD                                     
MFA-TR*              ,:S-AUTOCARD-PYMT-DATE                                     
MFA-TR*              ,:S-CREDIT-GROUP                                           
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
REARCH*                                                                         
REARCH     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
REARCH          ADD +1                    TO CTR-ROWS                   
REARCH     ELSE                                                         
REARCH          MOVE PROGRAM-NAME         TO ABEND-PROGRAM              
REARCH          MOVE SQLCODE              TO ABEND-SQLCODE              
REARCH          MOVE '8100'               TO ACTIVE-PARAGRAPH           
REARCH          MOVE 'INSERT'             TO ABEND-FUNCTION             
REARCH          MOVE SPACES               TO ABEND-SQL-PREDICATES       
REARCH                                       ABEND-TABLES               
REARCH          MOVE 'CSR02233_R1'        TO TABLE-1                    
REARCH          MOVE SPACES               TO TABLE-ELEMENT-1            
REARCH          MOVE SPACES               TO HOSTVAR-ELEMENT-1          
REARCH          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
REARCH     END-IF.                                                      
REARCH                                                                  
REARCH 8100-EXIT.                                                       
REARCH     EXIT.                                                        
                                                                        
      ******************************************************************12640000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     12650000
      ******************************************************************12660000
                                                                        
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
                                                                        
      ******************************************************************12710000
      *       END PROGRAM COPYLIB                                      *12720000
      ******************************************************************12730000
REARCH                                                                  
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CPD00320                                                 
REARCH     END-EXEC.                                                            
