       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02231.                                         
COB303 DATE-WRITTEN.                                                    
COB303            OCTOBER 31, 1994.                                     
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S231 CONVERTED TO DB2 SP CSR02231 ON 11/16/2005        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
      *                                                                *00110000
      *  TRANID:        S231                                           *00120000
      *  PROGRAM:       S231                                           *00130000
      *  CALLING SP:    PA_S231                                        *00140000
      *                                                                *00150000
      *                                                                *00160000
      *                                                                *00170000
      ******************************************************************00180000
      *                 P R O G R A M  S U M M A R Y                   *00190000
      *                                                                *00200000
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *00210000
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *00220000
      *                                                                *00230000
      *  THIS PROGRAM RETRIEVES A SINGLE INSTANCE OF THE CUSTOMER'S    *00240000
      *  BILLING DETAIL HISTORY IN ORDER TO CALCULATE AND DISPLAY      *00250000
      *  HIS/HER WEATHER NORMALIZATION ADJUSTMENT FACTOR (WNA) FOR     *00260000
      *  A GIVEN BILL.                                                 *00261000
      *                                                                *00262000
      ******************************************************************00270000
      *                                                                *00280000
      *                     PROGRAM MODIFICATION LOG                   *00290000
      *                                                                *00300000
      *    DATE    INITIALS   COMMENTS                                 *00310000
      *  --------  --------   ---------------------------------------  *00320000
      *  10/31/94    JHR      CREATED.                                 *00330000
      *  08/01/95    TCB      CHANGED 7000-DETERMINE-READ-DATES TO     *00331000
      *                       CONFORM TO CODE REVIEW OBSERVATION.      *00332000
      *  08/18/95    TCB      MADE NUMEROUS MODIFICATIONS SO THE       *00333000
      *                       CORRECT DATA WOULD BE RETURNED TO THE    *00334000
      *                       CALLING PANEL.                           *00335000
      *                                                                *00340000
      *  01/03/96    PD       SUMMER BASE IS TAKEN FROM BG AND ATH     *00341000
      *                       IS CONVERTED INTO THERMS BY MULTIPLYING  *00342000
      *                       BTU-FACTOR OBTAINED FROM BG TABLE.       *00343000
      *                                                                *00344000
TP9916*  04/17/97    RAH      ADD TIMESTAMPS TO SELECTS TO INSURE THAT *00345000
      *                       WE ONLY GET ONE ROW RETURNED.  MULTIPLE  *00346000
      *                       ROWS WERE BEING RETURNED IN THE CASE OF  *00347000
      *                       CANCEL/REBILLS.  ALSO, CURRENT READ DATE *00348000
      *                       SHOULD BE USED TO COMPUTE NDD/ADD INSTEAD*00349000
      *                       OF CURRENT - 1.                          *00349100
      *                                                                *00349200
T12756*  08/14/97    RAH      USABE PULLED FROM BZ IS ALREADY CONVERTED*00349300
      *                       TO THERMS SO WE DO NOT NEED TO RECONVERT *00349400
      *                       IT.                                      *00349500
      *                                                                *00349600
T13470*  10/27/97    RAH      WE ARE GETTING INCONSISTENT VALUES FOR   *00349700
      *                       BASE USE IN PRORATE SITUATIONS.          *00349800
      *                                                                *00350000
T?????*  12/23/97    RAH      INCREASE THE SIZE OF THE WSL FIELD, IT IS*00350100
      *                       BEING TRUNCATED ON SOME LARGE ACCOUNTS.  *00350200
T14614*  02/04/98    RAH      ADD CODE FOR GAS AIR CONDITIONING RATE,  *00350300
      *                       32B.                                     *00350400
T15257*  03/12/98    RAH      ADD NULL INDICATOR FOR LAST BASE USE     *00350500
      *                       UPDATE DATE.                             *00350600
T17675*  09/17/98    RAQ      Change wna to use prev date -1 through   *00350700
T17675*                       current date -1                          *00350800
T18257*  11/02/98    CBSI     Changes made not to calculate WNA factor *00350700
T18257*                       for rates 31A, 31B & 32A.                *00350800
T18679*  12/10/98    RGB      CODE CHANGED TO DISPLAY BILLED WNA       *00350700
T18679*                       PROPERLY WHEN OUTSIDE WNA LIMIT          *00350800
CBSI  *  12/21/98    KP       MC05 ABEND LOG CORRECTIONS               *00350700
T24597*  08/03/01    KS88119  CODE CHANGED TO TAKE CARE OF MULTI-      *00350700
T24597*                       COMPANY CHANGE                           *00351000
PCRWNA*  04/10/02    VIJAY    CODE CHANGED TO CALCULATE WNA PROPERLY.  *00350700
T26736*  10/16/02    LAT      WHEN THE CALCULATED WNA FACTOR IS > THE  *        
T26736*                       BILLED WNA FACTOR, USE BILLED WNA FACTOR *        
T26736*                       TO CALCULATE THE WNA AMOUNT.             *        
T27237*  02/06/03    GANESH   CHANGES MADE TO SUPPORT THE WNA          *        
T27237*                       CALCULATIONS FOR THE INDUSTRIAL GAS      *        
T27237*                       CUSTOMERS.                               *        
T32676*  07/27/05    GOKUL    TO ADD EFFECTIVE_DT AS A KEY TO          *        
T32676*                       CSS_BTU_WNA_RANGE.                       *        
C32676*  08/29/05    VIJAY    CHANGES MADE TO CALCULATE WNA WITH NEW   *        
C32676*                       RATES AND FORMULAS FOR GAS RATE WEF 200511        
REARCH*  09/10/05    CVNS     RPC TO COBOL SP CONVERSION               *        
REARCH*              CHENNAI                                           *        
T37151*  04/30/08    VIJAY    DISPLAY THE PANEL WHEN NOT YET BILLED ROW*        
T37151*              ACT -3   IS SELECTD INSTEAD OF 'DATA NOT FOUND    *        
T37151*                       ERROR OR INSUFFICIENT DATA'              *        
T37151*  06/11/08    SRIDHAR  FIX PARA 7000 TO GET MAX READ DATE AND   *        
T37151*              ACT -1,2 SUM OF NO OF DAYS                        *        
A37767*  12/04/08    SV95326  WNA NOT MATCHING WITH BILLED WNA         *        
A37767*              ACT -1                                            *        
A37532*  12/04/08    SV95326  COMPONENT CSR02231 FAILED WITH A S0C7 ON *        
A37532*              ACT -1   OCT 22, 2008.                            *        
A37767*  01/20/09    SV95326  WNA DETAILS PANEL ISSUE (-811).          *        
A37767*              ACT-2                                             *        
A00659*  03/25/09    SV95326  ADD BELOW FIELDS AS A INPUT PARAMETER    *        
A00659*              ACT-2    FROM PANEL091 AND GET CORRECT VALUE OF   *        
A00659*                       WNA FACTOR VALUE,PREVIOUS READ DATE,NDD, *        
A00659*                       ADD,BTH AND WSL VALUE IN PANEL215.       *        
A00659*                               1)BILL_ITEM_TIMESTMP             *        
A00659*                               2)DATE_READ                      *        
A00659*                               3)NO_DAYS                        *        
A00659*                               4)COMPANY_NO                     *        
A00659*                               5)BILL_UNITS                     *        
A00659*                               6)INDUST_GAS_CUST                *        
A00659*                       PREVIOUSLY THESE VALUES GOT BY USING SQL *        
A00659*                       QUERIES IN THIS PROCEDURE.NOW REMOVED THE*        
A00659*                       RELATED SQL QUERIES FROM THIS PROCEDURE. *        
A00659*                       SO IT IMPROVED THE PERFORMANCE OF THE    *        
A00659*                       PROCEDURE ALSO.                          *        
A00659*                       DELETED THE CODE USED FOR WNA CALCULATION*        
A00659*                       BEFORE 2005-11-01.                       *        
A00659*  08/20/09    SV95326  ADD USAGE TYPE AS A INPUT PARAMETER.     *        
A00659*              ACT-4                                             *        
A00659*  09/14/09    SV95326  TO DISPLAY BTU_FACTOR VALUE IN PANEL215 &*        
A00659*              ACT-3    WNA_FACTOR CALCULATION FOR FUTURE BILL   *        
A00659*                       HOOK IF ITS HAVING CONSUMPTION.          *        
A00659*                       CONSUMPTION.                             *        
A02034*  12/09/09    SP94986  1.FIXED DISPLAY ISSUES RELATED TO FUTURE *        
A02034*              ACT-006    BILL HOOK WITH VALID CONSUMPTION.      *        
A02034*                       2.ADDED "ROWSET POSITIONING" FOR         *        
A02034*                         PERFORMANCE TUNING.                    *        
A02034*  04/28/10    VIJAY    FIXED BTU calculation same as bill calc           
A02034*              ACT056   (ADDED 7350-GET-CURR-MINUS-ONE-DAY before         
A02034*                        calculating BTU fctor)                           
A00225*  01/04/10    MJ13662  FIXED WNA FACTOR CALCULATION FOR CIG     *        
A00225*  APPL 00003082        ACCOUNTS.                                *        
ACT219*  11/04/15    VIJAY    USE INPUT READ DATE INSTEAD OF FORMATTED *        
ACT219*  A05136               DATE.                                    *        
      ******************************************************************00360000
      *                                                                *00370000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00380000
      *                                                                *00390000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00400000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00410000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00420000
      *  3000 - 4999  NOT USED                                         *00430000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00440000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00450000
      *  7000 - 7999  INPUT MODULES                                    *00460000
      *  8000 - 8999  OUTPUT MODULES                                   *00470000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00480000
      *                                                                *00490000
      ******************************************************************00500000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02231'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02231 STARTS HERE'.                  
                                                                        
                                                                        
      ******************************************************************00600000
      *    DB2 INCLUDES                                                *00610000
      ******************************************************************00620000
                                                                        
           EXEC SQL                                                     00640000
              INCLUDE SQLCA                                             00650000
           END-EXEC.                                                    00660000
                                                                        
A02034**** CSS_BILLING_DET - BG **********************************      01601000
           EXEC SQL                                                     00713200
              INCLUDE TBBLLDET                                          00713300
           END-EXEC.                                                    00713400
                                                                        
A02034**** CSS_UTIL_ENVRNMT- UT **********************************      01601000
           EXEC SQL                                                     00750100
              INCLUDE TBUTLENV                                          00750200
           END-EXEC.                                                    00750300
                                                                        
A02034**** CSS_TEMPERATURE - E8 **********************************      01601000
           EXEC SQL                                                     00755000
              INCLUDE TBTEMPIN                                          00756000
           END-EXEC.                                                    00757000
                                                                        
A02034**** CSS_BTU_WNA_RANGE - BR  ******************************       01601000
T18257     EXEC SQL                                                     01601000
T18257       INCLUDE TBBTUWNA                                           01601100
T18257     END-EXEC.                                                    01601200
A02034**** CSS_VOL_DAILY    -  ND **********************************    01601000
CIG        EXEC SQL                                                     01601000
CIG          INCLUDE TBVOLDLY                                           01601100
CIG        END-EXEC.                                                    01601200
                                                                        
A02034**** CSS_COMPANY      -  C7 **********************************    01601000
A00659     EXEC SQL                                                     01601000
A00659       INCLUDE TBCOMPNY                                           01601100
A00659     END-EXEC.                                                    01601200
                                                                        
A02034****   CSS_BTU_FACTOR   -  TF **********************************  01601000
A00659     EXEC SQL                                                     01601000
A00659       INCLUDE TBBTUFCT                                           01601100
A00659     END-EXEC.                                                    01601200
                                                                        
A02034**** CSS_BILL_WINDOW - BN **********************************      01601000
A02034     EXEC SQL                                                     01601000
A02034       INCLUDE TBBILWDW                                           01601100
A02034     END-EXEC.                                                    01601200
A02034*                                                                 01601000
A02034**** CSS_JOB_PARM    - G6 **********************************      01601000
A02034     EXEC SQL                                                     01601000
A02034       INCLUDE TBJBPARM                                           01601100
A02034     END-EXEC.                                                    01601200
A02034*                                                                 01601000
      ******************************************************************00770000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00780000
      ******************************************************************00790000
                                                                        
           COPY CCA00001.                                               00830000
           COPY CWS00027.                                               00850000
           COPY CWS00303.                                               00860000
A02034****  CWS00038  JOB PARM ROUTINE                                          
A02034 COPY CWS00038.                                                           
A02034****  IO AREA FOR GETTING THE REVENUE MONTH FROM CSS_JOB_PARM             
A02034 COPY FIOJC01.                                                            
                                                                        
      ******************************************************************00880000
      *    WORK AREAS                                                  *00890000
      ******************************************************************00900000
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9)  COMP.                 
           05  PARM-RATE-PLAN-NO       PIC X(03)  VALUE SPACES.         
           05  PARM-ACCOUNT-NO         PIC X(13)  VALUE SPACES.         
           05  PARM-ACCOUNT-NO-RED     REDEFINES  PARM-ACCOUNT-NO       
                                       PIC 9(13).                       
           05  PARM-IC-NO              PIC X(04)  VALUE SPACES.         
           05  PARM-IC-NO-RED          REDEFINES  PARM-IC-NO            
                                       PIC 9(04).                       
           05  PARM-BILL-NO            PIC X(09)  VALUE SPACES.         
           05  PARM-BILL-NO-RED        REDEFINES  PARM-BILL-NO          
                                       PIC 9(09).                       
A00659     05  PARM-BILL-ITEM-TIMESTMP PIC X(26) VALUE SPACES.          
A00659     05  PARM-DATE-READ          PIC X(10) VALUE SPACES.          
A00659     05  PARM-NO-DAYS            PIC S9(04) USAGE COMP VALUE 0.   
A00659     05  PARM-COMPANY-NO         PIC X(02) VALUE SPACES.          
A00659     05  PARM-BILL-UNITS         PIC S9(09)V USAGE COMP VALUE 0.  
A00659     05  PARM-CIG-CUSTOMER       PIC X(01) VALUE SPACES.          
A00659     05  PARM-USAGE-TYPE         PIC X(01) VALUE SPACES.          
                                                                        
       01  WS-PARM-FIELDS.                                              
           05  WS-RATE-PLAN-NO         PIC X(03)   VALUE SPACES.        
           05  WS-ACCOUNT-NO           PIC 9(13)   VALUE ZERO.          
           05  WS-ACCOUNT-NO-NUM       PIC S9(13)V USAGE COMP-3         
                                       VALUE ZERO.                      
           05  WS-IC-NO                PIC 9(04)   VALUE ZERO.          
           05  WS-IC-NO-NUM            PIC S9(04)  USAGE COMP           
                                       VALUE ZERO.                      
           05  WS-BILL-NO-NUM          PIC S9(09)  USAGE COMP           
                                       VALUE ZERO.                      
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
T15257     05  WS-NULL-IND1            PIC S9(4) COMP.                  
PCRWNA     05  WS-NULL-IND-1           PIC S9(4) COMP.                  
PCRWNA     05  WS-NULL-IND-2           PIC S9(4) COMP.                  
                                                                        
       01  WS-MISC-VALUES.                                              
REARCH     05  PROGRAM-NAME            PIC X(08) VALUE 'CSR02231'.      
A02034     05  WS-PGRMNAME             PIC X(08) VALUE SPACES.          
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-ACTIVE-CODE          PIC X(01) VALUE 'A'.             
           05  WS-COST-OF-GAS-TYPE     PIC X(05) VALUE SPACES.          
           05  WS-COST-OF-GAS-RATE     PIC X(04) VALUE SPACES.          
           05  WS-BASE-TYPE            PIC X(10) VALUE SPACES.          
           05  WS-WNA-DOLLAR-AMOUNT    PIC S9(07)V99 USAGE COMP-3       
                                                     VALUE ZERO.        
CIG        05  WS-CIGVOL-START-DATE    PIC X(10).                       
CIG        05  WS-CIGVOL-END-DATE      PIC X(10).                       
CIG        05  WS-NO-OF-VOLDAYS        PIC S9(9) COMP.                  
CIG        05  WS-NULL-IND-3           PIC S9(4) COMP.                  
CIG        05  WS-NULL-IND-4           PIC S9(4) COMP.                  
A37767     05  WS-REVENUE-MONTH        PIC 9(06) VALUE ZERO.            
                                                                        
       01  WS-WNA-CALC-FIELDS.                                          
           05  WS-SUMMER-BASE-USE      PIC S9(09)V9999 USAGE COMP-3     
                                                       VALUE ZERO.      
           05  WS-PREVIOUS-BASE-USE    PIC S9(09)V9999 USAGE COMP-3     
                                                       VALUE ZERO.      
T13470     05  WS-ADJUSTED-BASE-USE    PIC S9(09)      USAGE COMP-3     
                                                       VALUE ZERO.      
           05  WS-ATH-BTH              PIC S9(09)V     USAGE COMP-3     
                                                       VALUE ZERO.      
           05  WS-ATH                  PIC S9(09)V     USAGE COMP-3     
                                                       VALUE ZERO.      
           05  WS-WORK-DEGREE          PIC S9(05)V99   USAGE COMP-3     
                                                       VALUE ZERO.      
           05  WS-NDD-ADD              PIC S9(05)V99   USAGE COMP-3     
                                                       VALUE ZERO.      
T?????     05  WS-WORK-WSL             PIC S9(10)      USAGE COMP-3     
                                                       VALUE ZERO.      
           05  WS-RATE-WORK1           PIC S9(5)V9(5)  USAGE COMP-3     
                                                       VALUE ZERO.      
           05  WS-RATE-WORK2           PIC S9(5)V9(5)  USAGE COMP-3     
                                                       VALUE ZERO.      
           05  WS-RATE-WORK            PIC S9(5)V9(5)  USAGE COMP-3     
                                                       VALUE ZERO.      
T?????     05  WS-WSL-INTERMED         PIC S9(5)V9(05) USAGE COMP-3     
                                                       VALUE ZERO.      
T?????     05  WS-WSL-FINAL            PIC S9(5)V9(05) USAGE COMP-3     
                                                       VALUE ZERO.      
T?????     05  WS-WSL-ROUNDED-FINAL    PIC S9(05)      USAGE COMP-3     
                                                       VALUE ZERO.      
T18257     05  WS-WNA-FACTOR           PIC S9V9(05)    USAGE COMP-3     
                                                       VALUE ZERO.      
T18257     05  WS-BILLED-WNA           PIC S9V9(05)    USAGE COMP-3     
                                                       VALUE ZERO.      
A00659     05  WS-BTU-FACTOR           PIC S9(5)V9(3) USAGE COMP-3      
A00659                                                VALUE ZERO.       
A00659     05  WS-SUM-MMBTU-TOTAL      PIC S9(15)V USAGE COMP-3 VALUE 0.
A00659     05  WS-SUM-MCF-TOTAL        PIC S9(15)V USAGE COMP-3 VALUE 0.
A00659     05  WS-305                  PIC S9(9)  VALUE -305 COMP.      
A02034     05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WS-READ-DATE-TYPES.                                          
C32676     05  WS-EFFECTIVE-DT-BR      PIC X(10)  VALUE SPACES.         
           05  WS-PREV-READ-DATE       PIC X(10)  VALUE SPACES.         
           05  WS-PRORATED-DATE        PIC X(10)  VALUE SPACES.         
           05  WS-EFFECTIVE-DATE       PIC X(10)  VALUE SPACES.         
A00659     05  WS-CURR-READ-DATE       PIC X(10)  VALUE SPACES.         
A02034     05  WS-CURR-READ-DATE-MINUS1 PIC X(10)  VALUE SPACES.        
                                                                        
       01  WS-RATES.                                                    
           05  WS-RATE-LIMIT           PIC S999     USAGE COMP-3        
                                                    VALUE ZERO.         
           05  WS-RATE-R1              PIC SV9(05)  USAGE COMP-3        
                                                    VALUE ZERO.         
           05  WS-RATE-R2              PIC SV9(05)  USAGE COMP-3        
                                                    VALUE ZERO.         
           05  WS-RES-RATE-LIM         PIC S999     USAGE COMP-3        
                                                    VALUE +25.          
           05  WS-COMM-RATE-LIM        PIC S999     USAGE COMP-3        
                                                    VALUE +130.         
           05  WS-RES-RATE-PLAN1       PIC X(03)    VALUE '032'.        
           05  WS-RES-GAS-AIR          PIC X(03)    VALUE '32B'.        
           05  WS-RES-1-RATE           PIC SV99999  USAGE COMP-3        
                                                    VALUE ZERO.         
           05  WS-RES-2-RATE           PIC SV99999  USAGE COMP-3        
                                                    VALUE ZERO.         
           05  WS-GAS-AIR-1-RT         PIC SV99999  USAGE COMP-3        
                                                    VALUE ZERO.         
           05  WS-COMM-1-RATE          PIC SV99999  USAGE COMP-3        
                                                    VALUE ZERO.         
           05  WS-COMM-2-RATE          PIC SV99999  USAGE COMP-3        
                                                    VALUE ZERO.         
                                                                        
       01  WS-TEMP-DEGREE-DAYS.                                         
           05  WS-CURR-ADD             PIC S9(05)V99 USAGE COMP-3       
                                                     VALUE ZERO.        
           05  WS-CURR-NDD             PIC S9(05)V99 USAGE COMP-3       
                                                     VALUE ZERO.        
           05  WS-PREV-ADD             PIC S9(05)V99 USAGE COMP-3       
                                                     VALUE ZERO.        
           05  WS-PREV-NDD             PIC S9(05)V99 USAGE COMP-3       
                                                     VALUE ZERO.        
           05  WS-RS-ADD               PIC S9(05)V99 USAGE COMP-3       
                                                     VALUE ZERO.        
           05  WS-RS-NDD               PIC S9(05)V99 USAGE COMP-3       
                                                     VALUE ZERO.        
           05  WS-ACT-ACCUM-DEGDAY     PIC S9(05)V99 USAGE COMP-3       
                                                     VALUE ZERO.        
           05  WS-NORM-ACCUM-DEGDAY    PIC S9(05)V99 USAGE COMP-3       
                                                     VALUE ZERO.        
       01  FILLER  PIC X(32)  VALUE 'THIS IS THE ROW RETURN AREA.    '. 
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE          PIC S9(09) COMP VALUE ZERO.       
REARCH     05  S-RATE-PLAN-NO         PIC X(03)      VALUE SPACES.      
REARCH     05  S-SHORT-OVER-UNDER     PIC X(05)      VALUE SPACES.      
REARCH     05  S-RATE-LIMIT           PIC S999       USAGE COMP-3       
REARCH                                               VALUE ZERO.        
REARCH     05  S-SHORT-RATE-TYPE      PIC X(04)      VALUE SPACES.      
REARCH     05  S-LONG-SHORT-RATE1     PIC SV9(05)    USAGE COMP-3       
REARCH                                               VALUE ZERO.        
REARCH     05  S-LONG-RATE2           PIC SV9(05)    USAGE COMP-3       
REARCH                                               VALUE ZERO.        
REARCH     05  S-NDD                  PIC S9(05)V99  USAGE COMP-3       
REARCH                                               VALUE ZERO.        
REARCH     05  S-ADD                  PIC S9(05)V99  USAGE COMP-3       
REARCH                                               VALUE ZERO.        
REARCH     05  S-BTH                  PIC S9(9)V9999 USAGE COMP-3       
REARCH                                               VALUE ZERO.        
REARCH     05  S-ATH                  PIC S9(09)V    USAGE COMP-3       
REARCH                                               VALUE ZERO.        
REARCH     05  S-WSL-ROUNDED          PIC S9(05)     USAGE COMP-3       
REARCH                                               VALUE ZERO.        
REARCH     05  S-WNA                  PIC S9V9(5)    USAGE COMP-3       
REARCH                                               VALUE ZERO.        
REARCH     05  S-PREVIOUS-READ        PIC X(10)      VALUE SPACES.      
REARCH     05  S-CURRENT-READ         PIC X(10)      VALUE SPACES.      
REARCH     05  S-EFFECTIVE-DATE       PIC X(10)      VALUE SPACES.      
REARCH     05  S-PREVIOUS-BTH         PIC S9(9)V9999 USAGE COMP-3       
REARCH                                               VALUE ZERO.        
REARCH     05  S-WSL-NOT-ROUNDED      PIC S9(5)V9(5) USAGE COMP-3       
REARCH                                               VALUE ZERO.        
REARCH     05  S-AMOUNT               PIC S9(7)V99   USAGE COMP-3       
REARCH                                               VALUE ZERO.        
REARCH     05  S-SUMMER-BASE-TYPE     PIC X(10)      VALUE SPACES.      
REARCH     05  S-WSL-INTERMED         PIC S9(5)V9(5) USAGE COMP-3       
REARCH                                               VALUE ZERO.        
REARCH     05  S-WNA-ATH-MINUS-BTH    PIC S9(9)V     USAGE COMP-3       
REARCH                                               VALUE ZERO.        
REARCH     05  S-BILLED-WNA           PIC SV9(5)     USAGE COMP-3       
REARCH                                               VALUE ZERO.        
A00659     05  S-BTU-FACTOR           PIC S9(5)V9(3) USAGE COMP-3       
A00659                                               VALUE ZERO.        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  WS-PRORATED-BASE-SW     PIC X(01) VALUE 'N'.             
                                                                        
HPCCDM*EJECT                                                            01612000
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-RATE-PLAN-NO        PIC X(03)                .          
CVT000 01  LINK-ACCOUNT-NO          PIC X(13)                .          
CVT000 01  LINK-IC-NO               PIC X(04)                .          
CVT000 01  LINK-BILL-NO             PIC X(09)                .          
A00659 01  LINK-BILL-ITEM-TIMESTMP  PIC X(26)                .          
A00659 01  LINK-DATE-READ           PIC X(10)                .          
A00659 01  LINK-NO-DAYS             PIC S9(04) USAGE COMP    .          
A00659 01  LINK-COMPANY-NO          PIC X(02)                .          
A00659 01  LINK-BILL-UNITS          PIC S9(09)V USAGE COMP   .          
A00659 01  LINK-INDUST-GAS-CUST     PIC X(01)                .          
A00659 01  LINK-USAGE-TYPE          PIC X(01)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-RATE-PLAN-NO                                       
CVT000         ,LINK-ACCOUNT-NO                                         
CVT000         ,LINK-IC-NO                                              
CVT000         ,LINK-BILL-NO                                            
A00659         ,LINK-BILL-ITEM-TIMESTMP                                 
A00659         ,LINK-DATE-READ                                          
A00659         ,LINK-NO-DAYS                                            
A00659         ,LINK-COMPANY-NO                                         
A00659         ,LINK-BILL-UNITS                                         
A00659         ,LINK-INDUST-GAS-CUST                                    
A00659         ,LINK-USAGE-TYPE                                         
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
                                                                        
      ******************************************************************01640000
      * 0000-MAINLINE                                                  *01650000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *01660000
      ******************************************************************01670000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************01790000
      * 0100-INITIALIZE                                                *01800000
      *                                                                *01810000
      *     1. RESET DB2 ERROR HANDLERS                                *01820000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *01830000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *01840000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*01850000
      *                                                                *01860000
      ******************************************************************01870000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
CVT000     EXEC SQL                                                     
A02034       DECLARE C1 CURSOR                               
A02034                         WITH ROWSET POSITIONING FOR              
CVT000       SELECT                                                     
REARCH        :S-RETURN-CODE              AS    RETURN_CODE             
REARCH       ,LTRIM(RTRIM(:S-RATE-PLAN-NO))      AS    RATE_PLAN_NO            
REARCH       ,LTRIM(RTRIM(:S-SHORT-OVER-UNDER))  AS    SHORT_OVER_UNDER        
REARCH       ,:S-RATE-LIMIT               AS    RATE_LIMIT              
REARCH       ,LTRIM(RTRIM(:S-SHORT-RATE-TYPE))   AS    SHORT_RATE_TYPE         
REARCH       ,:S-LONG-SHORT-RATE1         AS    LONG_SHORT_RATE1        
REARCH       ,:S-LONG-RATE2               AS    LONG_RATE2              
REARCH       ,:S-NDD                      AS    NDD                     
REARCH       ,:S-ADD                      AS    [ADD]                     
REARCH       ,:S-BTH                      AS    BTH                     
REARCH       ,:S-ATH                      AS    ATH                     
REARCH       ,:S-WSL-ROUNDED              AS    WSL_ROUNDED             
REARCH       ,:S-WNA                      AS    WNA                     
REARCH       ,LTRIM(RTRIM(:S-PREVIOUS-READ))     AS    PREVIOUS_READ           
REARCH       ,LTRIM(RTRIM(:S-CURRENT-READ))      AS    CURRENT_READ            
REARCH       ,LTRIM(RTRIM(:S-EFFECTIVE-DATE))    AS    EFFECTIVE_DATE          
REARCH       ,:S-PREVIOUS-BTH             AS    PREVIOUS_BTH            
REARCH       ,:S-WSL-NOT-ROUNDED          AS    WSL_NOT_ROUNDED         
REARCH       ,:S-AMOUNT                   AS    AMOUNT                  
REARCH       ,LTRIM(RTRIM(:S-SUMMER-BASE-TYPE))  AS    SUMMER_BASE_TYPE        
REARCH       ,:S-WSL-INTERMED             AS    WSL_INTERMED            
REARCH       ,:S-WNA-ATH-MINUS-BTH        AS    WNA_ATH_MINUS_BTH       
REARCH       ,:S-BILLED-WNA               AS    BILLED_WNA              
A00659       ,:S-BTU-FACTOR               AS    BTU_FACTOR              
CVT000          FROM CIS.SYSDUMMY1                                   
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ026
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN                                      
MFA-TR*                        WITH ROWSET POSITIONING FOR                      
MFA-TR*      SELECT                                                             
MFA-TR*       :S-RETURN-CODE              AS    RETURN_CODE                     
MFA-TR*      ,STRIP(:S-RATE-PLAN-NO)      AS    RATE_PLAN_NO                    
MFA-TR*      ,STRIP(:S-SHORT-OVER-UNDER)  AS    SHORT_OVER_UNDER                
MFA-TR*      ,:S-RATE-LIMIT               AS    RATE_LIMIT                      
MFA-TR*      ,STRIP(:S-SHORT-RATE-TYPE)   AS    SHORT_RATE_TYPE                 
MFA-TR*      ,:S-LONG-SHORT-RATE1         AS    LONG_SHORT_RATE1                
MFA-TR*      ,:S-LONG-RATE2               AS    LONG_RATE2                      
MFA-TR*      ,:S-NDD                      AS    NDD                             
MFA-TR*      ,:S-ADD                      AS    ADD                             
MFA-TR*      ,:S-BTH                      AS    BTH                             
MFA-TR*      ,:S-ATH                      AS    ATH                             
MFA-TR*      ,:S-WSL-ROUNDED              AS    WSL_ROUNDED                     
MFA-TR*      ,:S-WNA                      AS    WNA                             
MFA-TR*      ,STRIP(:S-PREVIOUS-READ)     AS    PREVIOUS_READ                   
MFA-TR*      ,STRIP(:S-CURRENT-READ)      AS    CURRENT_READ                    
MFA-TR*      ,STRIP(:S-EFFECTIVE-DATE)    AS    EFFECTIVE_DATE                  
MFA-TR*      ,:S-PREVIOUS-BTH             AS    PREVIOUS_BTH                    
MFA-TR*      ,:S-WSL-NOT-ROUNDED          AS    WSL_NOT_ROUNDED                 
MFA-TR*      ,:S-AMOUNT                   AS    AMOUNT                          
MFA-TR*      ,STRIP(:S-SUMMER-BASE-TYPE)  AS    SUMMER_BASE_TYPE                
MFA-TR*      ,:S-WSL-INTERMED             AS    WSL_INTERMED                    
MFA-TR*      ,:S-WNA-ATH-MINUS-BTH        AS    WNA_ATH_MINUS_BTH               
MFA-TR*      ,:S-BILLED-WNA               AS    BILLED_WNA                      
MFA-TR*      ,:S-BTU-FACTOR               AS    BTU_FACTOR                      
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
CVT000     MOVE LINK-RATE-PLAN-NO         TO PARM-RATE-PLAN-NO        . 
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
CVT000     MOVE LINK-IC-NO                TO PARM-IC-NO               . 
CVT000     MOVE LINK-BILL-NO              TO PARM-BILL-NO             . 
A00659     MOVE LINK-BILL-ITEM-TIMESTMP   TO PARM-BILL-ITEM-TIMESTMP  . 
A00659     MOVE LINK-DATE-READ            TO PARM-DATE-READ           . 
A00659     MOVE LINK-NO-DAYS              TO PARM-NO-DAYS             . 
A00659     MOVE LINK-COMPANY-NO           TO PARM-COMPANY-NO          . 
A00659     MOVE LINK-BILL-UNITS           TO PARM-BILL-UNITS          . 
A00659     MOVE LINK-INDUST-GAS-CUST      TO PARM-CIG-CUSTOMER        . 
A00659     MOVE LINK-USAGE-TYPE           TO PARM-USAGE-TYPE          . 
A02034     INITIALIZE                        GTT-RETURN-FIELDS          
A37532                                       DCLCSS-BTU-WNA-RANGE.      
A02034*                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02140000
      * 1000-PROCESS-INPUT                                             *02150000
      *                                                                *02160000
      *     1. PROCESS INPUT PARMS.                                    *02170000
      *                                                                *02180000
      ******************************************************************02190000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-RATE-PLAN-NO         TO WS-RATE-PLAN-NO.           
           MOVE PARM-ACCOUNT-NO-RED       TO WS-ACCOUNT-NO.             
           MOVE PARM-IC-NO-RED            TO WS-IC-NO.                  
A00659     MOVE PARM-BILL-NO-RED          TO WS-BILL-NO-NUM.            
           MOVE WS-ACCOUNT-NO             TO WS-ACCOUNT-NO-NUM.         
           MOVE WS-IC-NO                  TO WS-IC-NO-NUM.              
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************02450000
      * 2000-PROCESS-OUTPUT.                                           *02460000
      *                                                                *02470000
      ******************************************************************02480000
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2200-BUILD-RESULT     THRU 2200-EXIT.                
           PERFORM 8100-SEND-RESULT      THRU 8100-EXIT.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03569000
      * 2200-BUILD-RESULT.                                             *03570000
      *      1. DETERMINE READ DATES.                                  *03571000
      *      2. DETERMINE ACTUAL THERMS CONSUMED.                      *03572000
      *      3. DETERMINE CURRENT AND PREVIOUS BASE USES.              *03572100
      *      4. DETERMINE ACTUAL AND NORMAL DEGREE DAYS.               *03573000
      *      5. DETERMINE GAS RATES.                                   *03574000
      ******************************************************************03580000
       2200-BUILD-RESULT.                                               
A02034*                                                                         
A02034     PERFORM 8002-GET-PREV-READ-DATE THRU 8002-EXIT.              
A02034*                                                                         
A02034     MOVE WS-ACCOUNT-NO-NUM       TO BG-ACCOUNT-NO                
A02034                                     UT-ACCOUNT-NO.               
A02034     MOVE WS-IC-NO-NUM            TO BG-IC-NO                     
A02034                                     UT-IC-NO.                    
A02034     MOVE WS-BILL-NO-NUM          TO BG-BILL-NO.                  
A02034     MOVE PARM-BILL-ITEM-TIMESTMP TO BG-BILL-ITEM-TIMESTMP.       
A02034*                                                                         
A02034     PERFORM 7125-DETERMINE-SUMMER-BASE   THRU 7125-EXIT.         
A02034     MOVE BG-GAS-BASE-USE          TO WS-SUMMER-BASE-USE.         
A02034     MOVE PARM-BILL-UNITS          TO WS-ATH.                     
A02034     IF PARM-CIG-CUSTOMER = 'Y'                                   
A00225        COMPUTE WS-SUMMER-BASE-USE = WS-SUMMER-BASE-USE * 10      
A02034        COMPUTE PARM-BILL-UNITS    = PARM-BILL-UNITS * 10         
A02034        MOVE PARM-BILL-UNITS       TO WS-ATH                      
A02034     END-IF                                                       
A02034*                                                                         
           PERFORM 7150-DETERMINE-BASE-USE      THRU 7150-EXIT.         
           MOVE UT-GAS-BASE-LAST-UPDT    TO WS-EFFECTIVE-DATE.          
A00659     IF PARM-CIG-CUSTOMER = 'Y'                                   
CIG           COMPUTE UT-GAS-PREV-BASE-USE = UT-GAS-PREV-BASE-USE       
CIG                                                  * 10               
CIG        END-IF                                                       
           MOVE UT-GAS-PREV-BASE-USE     TO WS-PREVIOUS-BASE-USE.       
A02034*                                                                 04112600
A00659     PERFORM 7900-SEL-MIN-MAX-PRORATE-DAYS THRU 7900-EXIT.        
A00659     IF PARM-NO-DAYS < C7-MIN-PRORATION-DAYS                      
              MOVE WS-PRORATED-DATE      TO WS-PREV-READ-DATE           
           END-IF.                                                      
                                                                        
A00659     IF PARM-NO-DAYS < C7-MIN-PRORATION-DAYS                      
A00659        OR PARM-NO-DAYS > C7-MAX-PRORATION-DAYS                   
                 COMPUTE WS-ADJUSTED-BASE-USE ROUNDED =                 
A00659              (WS-SUMMER-BASE-USE * PARM-NO-DAYS) / 30            
                 MOVE WS-ADJUSTED-BASE-USE  TO WS-SUMMER-BASE-USE       
                 MOVE WS-YES                TO WS-PRORATED-BASE-SW      
           END-IF.                                                      
                                                                        
A02034** POPULATE EFFECTIVE DATE TO SELECT WNA-GAS-RATE                 03627000
A02034     EVALUATE TRUE                                                
A02034         WHEN BG-REV-MTH-ORIG-BILL > 0                            
A02034              MOVE BG-REV-MTH-ORIG-BILL TO WS-REVENUE-MONTH       
A02034         WHEN BG-REVENUE-MONTH > 0                                
A02034              MOVE BG-REVENUE-MONTH     TO WS-REVENUE-MONTH       
A02034         WHEN OTHER                                               
A02034              MOVE 'COMMON'          TO WS-PGRMNAME               
A02034              MOVE SPACES            TO WS-INPUT-AREA             
A02034              MOVE SPACES            TO WS-INPUT-DATA-BREAKDOWN   
A02034              PERFORM 6251-GET-FJC01-DATE THRU 6251-EXIT          
A02034              MOVE WS-INPUT-DATE     TO BN-DATE-EXTRACT           
A02034              PERFORM 7000-GET-REVENUE-MON-BW THRU 7000-EXIT      
A02034              MOVE BN-REVENUE-MONTH  TO WS-REVENUE-MONTH          
A02034     END-EVALUATE.                                                
A02034     MOVE WS-REVENUE-MONTH(1:4)    TO WS-EFFECTIVE-DT-BR(1:4).    
A02034     MOVE '-'                      TO WS-EFFECTIVE-DT-BR(5:1).    
A02034     MOVE WS-REVENUE-MONTH(5:2)    TO WS-EFFECTIVE-DT-BR(6:2).    
A02034     MOVE '-'                      TO WS-EFFECTIVE-DT-BR(8:1).    
A02034     MOVE '01'                     TO WS-EFFECTIVE-DT-BR(9:2).    
A02034*                                                                 03612000
A02034** IF USAGE TYPE = "T" THEN DESCRIPTION IS USAGE DESC - CCF       03612000
A02034** THEN CALCULATE BTU FACTOR & THERMS                             03612000
A02034     IF PARM-USAGE-TYPE = 'T'                                     
A02034        PERFORM 2500-COMPUTE-BTU-FACTOR THRU 2500-EXIT            
A02034        COMPUTE WS-ATH ROUNDED = WS-ATH * WS-BTU-FACTOR           
A02034     ELSE                                                         
A02034        MOVE BG-BTU-FACTOR         TO WS-BTU-FACTOR               
A02034     END-IF.                                                      
A02034*                                                                 03612000
           PERFORM 7200-DETERMINE-ADD-NDD       THRU 7200-EXIT.         
                                                                        
           IF WS-PRORATED-BASE-SW EQUAL WS-YES                          
              MOVE '  Prorated'               TO WS-BASE-TYPE           
           ELSE                                                         
              IF WS-ATH > WS-SUMMER-BASE-USE                            
                 MOVE 'Calculated'            TO WS-BASE-TYPE           
              ELSE                                                      
                 MOVE '   Maximum'            TO WS-BASE-TYPE           
                 MOVE WS-ATH                  TO WS-SUMMER-BASE-USE     
              END-IF                                                    
           END-IF.                                                      
                                                                        
      **** ATH - BTH                                                    03630000
           COMPUTE WS-ATH-BTH = WS-ATH - WS-SUMMER-BASE-USE.            
                                                                        
      **** NDD - ADD                                                    03630000
           COMPUTE WS-WORK-DEGREE = WS-RS-NDD - WS-RS-ADD.              
                                                                        
      ****  (ATH - BTH ) / ADD                                          03630000
           IF WS-RS-ADD = ZERO                                          
              MOVE ZERO                    TO WS-WSL-INTERMED           
           ELSE                                                         
              COMPUTE WS-WSL-INTERMED  = WS-ATH-BTH / WS-RS-ADD         
           END-IF.                                                      
                                                                        
           IF WS-WSL-INTERMED < ZERO                                    
              MOVE ZERO                    TO WS-WSL-INTERMED           
           END-IF.                                                      
                                                                        
      **** WSL = (WS-WSL-INTERMED) * (NDD - ADD)                        03630000
           COMPUTE WS-WSL-FINAL = WS-WSL-INTERMED * WS-WORK-DEGREE.     
                                                                        
           COMPUTE WS-WSL-ROUNDED-FINAL ROUNDED = WS-WSL-FINAL.         
                                                                        
A00659**** CALCUATE WNA WITH NEW FORMULA AND RATES                              
A00659     PERFORM 7800-CALC-WNA-WITH-NEWRATE   THRU 7800-EXIT.         
                                                                        
A00659     MOVE BG-WNA-FACTOR          TO WS-BILLED-WNA.                
A00659     COMPUTE WS-WNA-DOLLAR-AMOUNT ROUNDED = WS-ATH-BTH *          
A00659                                        WS-BILLED-WNA.            
A00659     PERFORM 2300-OUTPUT-MOVE             THRU 2300-EXIT.         
                                                                        
       2200-EXIT.                                                       
            EXIT.                                                       
                                                                        
c32676                                                                  
C32676***********************************************************       03644300
C32676*    MOVE RESULTS TO DISPLAY IN PANEL.                            03644300
C32676***********************************************************       03644300
A02034*                                                                 03740000
A02034 2300-OUTPUT-MOVE.                                                
A02034     MOVE WS-ACTIVE-RETURN-CODE    TO S-RETURN-CODE.              
A02034     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A02034        IF PARM-CIG-CUSTOMER = 'Y'                                
A02034           COMPUTE WS-SUMMER-BASE-USE = WS-SUMMER-BASE-USE / 10   
A02034           COMPUTE WS-ATH ROUNDED = WS-ATH / 10                   
A02034           COMPUTE WS-WNA-DOLLAR-AMOUNT =                         
A02034                     WS-WNA-DOLLAR-AMOUNT / 10                    
A00225           COMPUTE WS-WNA-FACTOR = WS-WNA-FACTOR * 10             
A02034        END-IF                                                    
A02034        MOVE WS-RATE-PLAN-NO          TO S-RATE-PLAN-NO           
A02034        MOVE WS-COST-OF-GAS-TYPE      TO S-SHORT-OVER-UNDER       
A02034        MOVE WS-RATE-LIMIT            TO S-RATE-LIMIT             
A02034        MOVE WS-COST-OF-GAS-RATE      TO S-SHORT-RATE-TYPE        
A02034        IF BR-WNA-GAS-RATE > 0                                    
A02034           MOVE BR-WNA-GAS-RATE       TO S-LONG-SHORT-RATE1       
A02034        ELSE                                                      
A02034           MOVE WS-RATE-R1            TO S-LONG-SHORT-RATE1       
A02034        END-IF                                                    
A02034        MOVE WS-RATE-R2               TO S-LONG-RATE2             
A02034        MOVE WS-RS-NDD                TO S-NDD                    
A02034        MOVE WS-RS-ADD                TO S-ADD                    
A02034        MOVE WS-SUMMER-BASE-USE       TO S-BTH                    
A02034        MOVE WS-ATH                   TO S-ATH                    
A02034        MOVE WS-WSL-ROUNDED-FINAL     TO S-WSL-ROUNDED            
A02034        MOVE WS-WNA-FACTOR            TO S-WNA                    
A02034        MOVE WS-PREV-READ-DATE        TO S-PREVIOUS-READ          
A02034        MOVE PARM-DATE-READ           TO S-CURRENT-READ           
A02034        MOVE WS-EFFECTIVE-DATE        TO S-EFFECTIVE-DATE         
A02034        MOVE WS-PREVIOUS-BASE-USE     TO S-PREVIOUS-BTH           
A02034        MOVE WS-WSL-FINAL             TO S-WSL-NOT-ROUNDED        
A02034        MOVE WS-WNA-DOLLAR-AMOUNT     TO S-AMOUNT                 
A02034        MOVE WS-BASE-TYPE             TO S-SUMMER-BASE-TYPE       
A02034        MOVE WS-WSL-INTERMED          TO S-WSL-INTERMED           
A02034        MOVE WS-ATH-BTH               TO S-WNA-ATH-MINUS-BTH      
A02034        MOVE WS-BILLED-WNA            TO S-BILLED-WNA             
A02034        MOVE WS-BTU-FACTOR            TO S-BTU-FACTOR             
A02034     ELSE                                                         
A02034        MOVE SPACES                TO S-RATE-PLAN-NO              
A02034        MOVE SPACES                TO S-SHORT-OVER-UNDER          
A02034        MOVE ZERO                  TO S-RATE-LIMIT                
A02034        MOVE SPACES                TO S-SHORT-RATE-TYPE           
A02034        MOVE ZERO                  TO S-LONG-SHORT-RATE1          
A02034        MOVE ZERO                  TO S-LONG-RATE2                
A02034        MOVE ZERO                  TO S-NDD                       
A02034        MOVE ZERO                  TO S-ADD                       
A02034        MOVE ZERO                  TO S-BTH                       
A02034        MOVE ZERO                  TO S-ATH                       
A02034        MOVE ZERO                  TO S-WSL-ROUNDED               
A02034        MOVE ZERO                  TO S-WNA                       
A02034        MOVE SPACES                TO S-PREVIOUS-READ             
A02034        MOVE SPACES                TO S-CURRENT-READ              
A02034        MOVE SPACES                TO S-EFFECTIVE-DATE            
A02034        MOVE ZERO                  TO S-PREVIOUS-BTH              
A02034        MOVE ZERO                  TO S-WSL-NOT-ROUNDED           
A02034        MOVE ZERO                  TO S-AMOUNT                    
A02034        MOVE SPACES                TO S-SUMMER-BASE-TYPE          
A02034        MOVE ZERO                  TO S-WSL-INTERMED              
A02034        MOVE ZERO                  TO S-WNA-ATH-MINUS-BTH         
A02034        MOVE ZERO                  TO S-BILLED-WNA                
A02034        MOVE ZERO                  TO S-BTU-FACTOR                
A02034     END-IF.                                                      
A02034*                                                                 03740000
C32676 2300-EXIT.                                                       
C32676     EXIT.                                                        
A00659******************************************************************04107000
A00659* 2500-COMPUTE-BTU-FACTOR.                                       *04107100
A00659******************************************************************04107300
A00659 2500-COMPUTE-BTU-FACTOR.                                         
A00659*                                                                         
A02034     PERFORM 7350-GET-CURR-MINUS-ONE-DAY THRU 7350-EXIT.          
A00569     PERFORM 7400-CALCULATE-BTU-FACTOR  THRU 7400-EXIT.           
A00659     IF WS-ACTIVE-RETURN-CODE EQUAL TO SUCCESSFUL-CALL            
A00659        COMPUTE WS-BTU-FACTOR  ROUNDED =                          
A00659                WS-SUM-MMBTU-TOTAL / WS-SUM-MCF-TOTAL             
A00659     ELSE                                                         
A00659        MOVE ZERO          TO WS-BTU-FACTOR                       
A00659     END-IF.                                                      
A00659*                                                                         
A00659 2500-EXIT.                                                       
A00659     EXIT.                                                        
A00659*                                                                         
A02034*****************************************************************         
A02034* 6251-GET-FJC01-DATE.                                          *         
A02034*****************************************************************         
A02034*                                                                         
A02034     EXEC SQL                                                             
A02034          INCLUDE CPDCA037                                                
A02034     END-EXEC.                                                            
A02034*                                                                         
A02034************************************************************              
A02034* SELECT REVENUE MONTH FROM CSS_BILL_WINDOW                *              
A02034************************************************************              
A02034*                                                                         
A02034 7000-GET-REVENUE-MON-BW.                                         
A02034*                                                                         
A02034     EXEC SQL                                                     
A02034          SELECT MIN(BN.REVENUE_MONTH)                            
A02034            INTO :BN-REVENUE-MONTH                                
A02034          FROM   CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                 
A02034          WHERE BN.DATE_EXTRACT   >= IIF(TRY_CONVERT(DATE, 
                                                       :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) )             
A02034                                                           
A02034     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT MIN(BN.REVENUE_MONTH)                                    
MFA-TR*           INTO :BN-REVENUE-MONTH                                        
MFA-TR*         FROM   CSS_BILL_WINDOW BN                                       
MFA-TR*         WHERE BN.DATE_EXTRACT   >= :BN-DATE-EXTRACT                     
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02034*                                                                         
A02034     IF SQLCODE = SUCCESSFUL-CALL                                 
A02034        NEXT SENTENCE                                             
A02034     ELSE                                                         
A02034        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
A02034        MOVE '7000'               TO ACTIVE-PARAGRAPH             
A02034        MOVE 'SELECT'             TO ABEND-FUNCTION               
A02034        MOVE 'CSS_BILL_WINDOW'    TO TABLE-1                      
A02034        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
A02034        MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
A02034        MOVE 'BILL_NO'            TO TABLE-ELEMENT-2              
A02034        MOVE WS-BILL-NO-NUM       TO HOSTVAR-ELEMENT-2            
A02034        MOVE 'DATE_EXTRACT'       TO TABLE-ELEMENT-3              
A02034        MOVE BN-DATE-EXTRACT      TO HOSTVAR-ELEMENT-3            
A02034        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
A02034        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
A02034     END-IF.                                                      
A02034*                                                                         
A02034 7000-EXIT.                                                       
A02034     EXIT.                                                        
      ******************************************************************04107000
      * 7125-DETERMINE-SUMMER-BASE.                                    *04107100
      *     1. DETERMINE SUMMER BASE USE (BTH).                 *       04107200
      ******************************************************************04107300
       7125-DETERMINE-SUMMER-BASE.                                      
                                                                        
           EXEC SQL                                                     
             SELECT GAS_BASE_USE,                                       
                    BTU_FACTOR,                                         
A37767              REVENUE_MONTH,                                      
A37767              REV_MTH_ORIG_BILL,                                  
A00659              WNA_FACTOR                                          
               INTO :BG-GAS-BASE-USE,                                   
                    :BG-BTU-FACTOR,                                     
A37767              :BG-REVENUE-MONTH,                                  
A37767              :BG-REV-MTH-ORIG-BILL,                              
A00659              :BG-WNA-FACTOR                                      
               FROM CSS_BILLING_DET WITH(READUNCOMMITTED)                       
A02034        WHERE BILL_NO            = :BG-BILL-NO                    
A00659          AND CODE_UTIL_TYPE     = 'G'                            
A02034          AND IC_NO              = :BG-IC-NO                      
A02034          AND ACCOUNT_NO         = :BG-ACCOUNT-NO                 
A02034          AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )         
T37151                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     04107600
MFA-TR*      SELECT GAS_BASE_USE,                                       04107700
MFA-TR*             BTU_FACTOR,                                         04107800
MFA-TR*             REVENUE_MONTH,                                              
MFA-TR*             REV_MTH_ORIG_BILL,                                          
MFA-TR*             WNA_FACTOR                                                  
MFA-TR*        INTO :BG-GAS-BASE-USE,                                   04107900
MFA-TR*             :BG-BTU-FACTOR,                                     04108000
MFA-TR*             :BG-REVENUE-MONTH,                                          
MFA-TR*             :BG-REV-MTH-ORIG-BILL,                                      
MFA-TR*             :BG-WNA-FACTOR                                              
MFA-TR*        FROM CSS_BILLING_DET                                     04108100
MFA-TR*       WHERE BILL_NO            = :BG-BILL-NO                    04108200
MFA-TR*         AND CODE_UTIL_TYPE     = 'G'                            04108300
MFA-TR*         AND IC_NO              = :BG-IC-NO                      04108400
MFA-TR*         AND ACCOUNT_NO         = :BG-ACCOUNT-NO                 04108500
MFA-TR*         AND BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP                 
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    04109300

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7125'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_BILLING_DET'    TO TABLE-1                      
A00659        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
A00659        MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
A00659        MOVE 'BILL_NO'            TO TABLE-ELEMENT-2              
A00659        MOVE WS-BILL-NO-NUM       TO HOSTVAR-ELEMENT-2            
A00659        MOVE 'IC_NO'              TO TABLE-ELEMENT-3              
A00659        MOVE WS-IC-NO-NUM         TO HOSTVAR-ELEMENT-3            
A00659        MOVE 'BILL_ITEM_TIMESTMP' TO TABLE-ELEMENT-4              
A00659        MOVE PARM-BILL-ITEM-TIMESTMP  TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
                                                                        
       7125-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04112000
      * 7150-DETERMINE-BASE-USE.                                       *04112100
      *     1. DETERMINE CURRENT AND PREVIOUS BASE USE, AND LAST       *04112200
      *        UPDATED DATE FROM CSS_UTIL_ENVRNMT TABLE.               *04112300
      ******************************************************************04112400
       7150-DETERMINE-BASE-USE.                                         
                                                                        
           EXEC SQL                                                     
A02034       SELECT  UT.GAS_BASE_LAST_UPDT                              
A02034              ,UT.GAS_PREV_BASE_USE                               
T15257         INTO :UT-GAS-BASE-LAST-UPDT :WS-NULL-IND1                 
A02034             ,:UT-GAS-PREV-BASE-USE                               
A02034         FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                   
A02034        WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                  
A00659          AND UT.CODE_UTIL_TYPE = 'G'                             
A02034          AND UT.IC_NO          = :UT-IC-NO                       
T37151                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     04112700
MFA-TR*      SELECT  UT.GAS_BASE_LAST_UPDT                              04112800
MFA-TR*             ,UT.GAS_PREV_BASE_USE                               04112900
MFA-TR*        INTO :UT-GAS-BASE-LAST-UPDT:WS-NULL-IND1                 04113101
MFA-TR*            ,:UT-GAS-PREV-BASE-USE                               04113200
MFA-TR*        FROM CSS_UTIL_ENVRNMT UT                                 04113400
MFA-TR*       WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                  04113500
MFA-TR*         AND UT.CODE_UTIL_TYPE = 'G'                             04113600
MFA-TR*         AND UT.IC_NO          = :UT-IC-NO                       04113700
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    04113800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7150'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_UTIL_ENVRNMT'   TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
A00659        MOVE 'IC_NO'              TO TABLE-ELEMENT-2              
A00659        MOVE WS-IC-NO-NUM         TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04116200
      * 7200-DETERMINE-ADD-NDD.                                        *04116300
      *     1. USING THE CURRENT AND PREVIOUS READ DATES, COMPUTE      *04116400
      *        THE ACTUAL DEGREE DAYS (ADD) AND THE NORMAL DEGREE      *04116500
      *        DAYS (NDD) FOR THE WNA CALCULATION.                     *04116600
      ******************************************************************04116700
       7200-DETERMINE-ADD-NDD.                                          
                                                                        
PCRWNA     MOVE ZEROS  TO WS-NULL-IND-1 WS-NULL-IND-2.                  
PCRWNA     PERFORM 7300-DETERMINE-ADD-NDD  THRU 7300-EXIT.              
PCRWNA     IF WS-NULL-IND-1 < 0                                         
PCRWNA        MOVE ZEROS TO WS-RS-ADD                                   
PCRWNA     END-IF.                                                      
PCRWNA     IF WS-NULL-IND-2 < 0                                         
PCRWNA        MOVE ZEROS TO WS-RS-NDD                                   
PCRWNA     END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04118600
      * 7300-DETERMINE-ADD-NDD.                                        *04118700
      *     1. READ CSS_TEMPERATURE TABLE TO GET ACTUAL ACCUMULATED    *04118800
      *        DEGREE DAYS AND NORMAL ACCUMULATED DEGREE DAYS BASED    *04118900
      *        UPON READ DATE MINUS ONE DAY.                           *04119000
      ******************************************************************04119100
       7300-DETERMINE-ADD-NDD.                                          
PCRWNA                                                                  
PCRWNA     EXEC SQL                                                     
PCRWNA        SELECT SUM(ACT_HEAT_DEGREE),                              
PCRWNA               SUM(NORM_HEAT_DEGREE)                              
PCRWNA          INTO :WS-RS-ADD :WS-NULL-IND-1,                         
PCRWNA               :WS-RS-NDD :WS-NULL-IND-2                          
PCRWNA          FROM CSS_TEMPERATURE WITH(READUNCOMMITTED)                      
A00659         WHERE COMPANY_NO = :PARM-COMPANY-NO                      
A00659           AND TEMP_DT <= DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                        :PARM-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :PARM-DATE-READ
              ) <> 0) OR (LEN(:PARM-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                        :PARM-DATE-READ
              ), CONVERT(DATE, :PARM-DATE-READ) ) )     
PCRWNA           AND TEMP_DT >= IIF(TRY_CONVERT(DATE, :WS-PREV-READ-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PREV-READ-DATE
              ) <> 0) OR (LEN(:WS-PREV-READ-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-PREV-READ-DATE
              ), CONVERT(DATE, :WS-PREV-READ-DATE) )                      
T37151                                                           
PCRWNA     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     04119400
MFA-TR*       SELECT SUM(ACT_HEAT_DEGREE),                              04119500
MFA-TR*              SUM(NORM_HEAT_DEGREE)                              04119500
MFA-TR*         INTO :WS-RS-ADD :WS-NULL-IND-1,                         04119700
MFA-TR*              :WS-RS-NDD :WS-NULL-IND-2                          04119800
MFA-TR*         FROM CSS_TEMPERATURE                                    04119900
MFA-TR*        WHERE COMPANY_NO = :PARM-COMPANY-NO                      04120000
MFA-TR*          AND TEMP_DT <= DATE(DATE(:PARM-DATE-READ) - 1 DAY)     04120000
MFA-TR*          AND TEMP_DT >= :WS-PREV-READ-DATE                      04120000
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    04120100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7300'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_TEMPERATURE'     TO TABLE-1                     
A00659        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
A00659        MOVE WS-ACCOUNT-NO-NUM     TO HOSTVAR-ELEMENT-1           
A00659        MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2             
A00659        MOVE PARM-COMPANY-NO       TO HOSTVAR-ELEMENT-2           
A00659        MOVE 'CURR_READ_DT'        TO TABLE-ELEMENT-3             
A00659        MOVE PARM-DATE-READ        TO HOSTVAR-ELEMENT-3           
A00659        MOVE 'PREV_READ_DT'        TO TABLE-ELEMENT-4             
A00659        MOVE WS-PREV-READ-DATE     TO HOSTVAR-ELEMENT-4           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
A02034******************************************************************04139000
A02034* 7350-GET-CURR-MINUS-ONE-DAY                                     40500000
A02034******************************************************************40490000
A02034                                                                  
A02034 7350-GET-CURR-MINUS-ONE-DAY.                                     
A02034                                                                  
A02034     EXEC SQL                                                     
A02034       SELECT
              DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, :PARM-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :PARM-DATE-READ
              ) <> 0) OR (LEN(:PARM-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                        :PARM-DATE-READ
              ), CONVERT(DATE, :PARM-DATE-READ) ) )
            INTO
              :WS-CURR-READ-DATE-MINUS1                      
A02034     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-CURR-READ-DATE-MINUS1 =                                    
MFA-TR*              DATE(:PARM-DATE-READ) - 1 DAY                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02034                                                                  
A02034     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A02034        NEXT SENTENCE                                             
A02034     ELSE                                                         
A02034        MOVE SPACES              TO ABEND-TABLES                  
A02034        MOVE SPACES              TO ABEND-SQL-PREDICATES          
A02034        MOVE '7350'              TO ACTIVE-PARAGRAPH              
A02034        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
A02034        MOVE 'SET'               TO ABEND-FUNCTION                
A02034        MOVE 'CURR_READ_DATE'    TO TABLE-ELEMENT-1               
A02034        MOVE WS-CURR-READ-DATE   TO HOSTVAR-ELEMENT-1             
A02034        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
A02034        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
A02034     END-IF.                                                      
A02034 7350-EXIT.                                                       
A02034     EXIT.                                                        
                                                                        
A00659******************************************************************04139000
A00659* 7400-CALCULATE-BTU-FACTOR.                                     *40500000
A00659******************************************************************40490000
A00659 7400-CALCULATE-BTU-FACTOR.                                       
A00659*                                                                 11132400
A00659     EXEC SQL                                                     
A00659         SELECT SUM (MMBTU_TOTAL),                                
A00659                SUM (MCF_TOTAL)                                   
A00659           INTO :WS-SUM-MMBTU-TOTAL,                              
A00659                :WS-SUM-MCF-TOTAL                                 
A00659           FROM CSS_BTU_FACTOR WITH(READUNCOMMITTED)                      
A00659          WHERE BTU_DT BETWEEN IIF(TRY_CONVERT(DATE, 
                                                     :WS-PREV-READ-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-PREV-READ-DATE
              ) <> 0) OR (LEN(:WS-PREV-READ-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-PREV-READ-DATE
              ), CONVERT(DATE, :WS-PREV-READ-DATE) )                 
A02034                           AND IIF(TRY_CONVERT(DATE, 
                                              :WS-CURR-READ-DATE-MINUS1
              ) IS NULL OR (PATINDEX('%.%', :WS-CURR-READ-DATE-MINUS1
              ) <> 0) OR (LEN(:WS-CURR-READ-DATE-MINUS1
              ) <> 10), CIS.CHAR2DATE(:WS-CURR-READ-DATE-MINUS1
              ), CONVERT(DATE, :WS-CURR-READ-DATE-MINUS1) )          
A00659                           AND COMPANY_NO = :PARM-COMPANY-NO      
A02034                                                           
A00659     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM (MMBTU_TOTAL),                                        
MFA-TR*               SUM (MCF_TOTAL)                                           
MFA-TR*          INTO :WS-SUM-MMBTU-TOTAL,                                      
MFA-TR*               :WS-SUM-MCF-TOTAL                                         
MFA-TR*          FROM CSS_BTU_FACTOR                                            
MFA-TR*         WHERE BTU_DT BETWEEN :WS-PREV-READ-DATE                         
MFA-TR*                          AND :WS-CURR-READ-DATE-MINUS1                  
MFA-TR*                          AND COMPANY_NO = :PARM-COMPANY-NO              
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00659                                                                  
A00659     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A00659                                                OR WS-305         
A00659        NEXT SENTENCE                                             
A00659     ELSE                                                         
A00659        MOVE SPACES              TO ABEND-TABLES                  
A00659        MOVE SPACES              TO ABEND-SQL-PREDICATES          
A00659        MOVE '7400'              TO ACTIVE-PARAGRAPH              
A00659        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
A00659        MOVE 'SELECT'            TO ABEND-FUNCTION                
A00659        MOVE 'CSS_BTU_WNA_RANGE' TO TABLE-1                       
A00659        MOVE 'PREV_READ_DATE'    TO TABLE-ELEMENT-1               
A00659        MOVE WS-PREV-READ-DATE   TO HOSTVAR-ELEMENT-1             
A00659        MOVE 'CURR_READ_DATE'    TO TABLE-ELEMENT-2               
A00659        MOVE WS-CURR-READ-DATE   TO HOSTVAR-ELEMENT-2             
A00659        MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-3               
A00659        MOVE PARM-COMPANY-NO     TO HOSTVAR-ELEMENT-3             
A00659        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
A00659        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
A00659     END-IF.                                                      
A00659*                                                                 11136400
A00659 7400-EXIT.                                                       
A00659     EXIT.                                                        
A00659*                                                                 11136400
A02034*****************************************************************         
A02034*  7600-START-FCSJC01                                           *         
A02034*****************************************************************         
A02034*                                                                         
A02034     EXEC SQL                                                             
A02034          INCLUDE CPDCA038                                                
A02034     END-EXEC.                                                            
A02034*                                                                         
      ******************************************************************04139000
ST    * THE FOLLOWING MODULE IS TO GET WNA-LOWER-FACTOR & UPPER-FACTOR *40500000
      * FROM CSS_BTU_WNA_RANGE TABLE                                   *        
      ******************************************************************40490000
       7710-SELECT-BTU-WNA-RANGE.                                       
      *                                                                 11132400
           EXEC SQL                                                     
               SELECT  WNA_LOWER_LIMIT                                  
                      ,WNA_UPPER_LIMIT                                  
C32676                ,WNA_GAS_RATE                                     
                 INTO :BR-WNA-LOWER-LIMIT                               
                     ,:BR-WNA-UPPER-LIMIT                               
C32676               ,:BR-WNA-GAS-RATE                                  
                 FROM  CSS_BTU_WNA_RANGE BR WITH(READUNCOMMITTED)               
                WHERE BR.CODE_UTIL_TYPE  = 'G'                          
                  AND BR.RATE_PLAN_NO    = :BR-RATE-PLAN-NO             
T32676            AND BR.EFFECTIVE_DT    =                              
T32676                  (SELECT MAX(B1.EFFECTIVE_DT)                    
T32676                  FROM CSS_BTU_WNA_RANGE B1 WITH(READUNCOMMITTED)         
T32676                 WHERE B1.CODE_UTIL_TYPE  = BR.CODE_UTIL_TYPE     
T32676                   AND B1.RATE_PLAN_NO    = BR.RATE_PLAN_NO       
C32676                   AND B1.EFFECTIVE_DT <= IIF(TRY_CONVERT(DATE, 
                                                    :WS-EFFECTIVE-DT-BR
              ) IS NULL OR (PATINDEX('%.%', :WS-EFFECTIVE-DT-BR
              ) <> 0) OR (LEN(:WS-EFFECTIVE-DT-BR
              ) <> 10), CIS.CHAR2DATE(:WS-EFFECTIVE-DT-BR
              ), CONVERT(DATE, :WS-EFFECTIVE-DT-BR) ))    
T37151                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     11132600
MFA-TR*        SELECT  WNA_LOWER_LIMIT                                          
MFA-TR*               ,WNA_UPPER_LIMIT                                          
MFA-TR*               ,WNA_GAS_RATE                                             
MFA-TR*          INTO :BR-WNA-LOWER-LIMIT                               11133100
MFA-TR*              ,:BR-WNA-UPPER-LIMIT                               11133200
MFA-TR*              ,:BR-WNA-GAS-RATE                                  11133200
MFA-TR*          FROM  CSS_BTU_WNA_RANGE BR                                     
MFA-TR*         WHERE BR.CODE_UTIL_TYPE  = 'G'                                  
MFA-TR*           AND BR.RATE_PLAN_NO    = :BR-RATE-PLAN-NO                     
MFA-TR*           AND BR.EFFECTIVE_DT    =                                      
MFA-TR*                 (SELECT MAX(B1.EFFECTIVE_DT)                            
MFA-TR*                 FROM CSS_BTU_WNA_RANGE B1                               
MFA-TR*                WHERE B1.CODE_UTIL_TYPE  = BR.CODE_UTIL_TYPE             
MFA-TR*                  AND B1.RATE_PLAN_NO    = BR.RATE_PLAN_NO               
MFA-TR*                  AND B1.EFFECTIVE_DT <= :WS-EFFECTIVE-DT-BR)            
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    11133300

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 11130500
           IF SQLCODE = SUCCESSFUL-CALL                                 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES              TO ABEND-TABLES                  
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
              MOVE '7710'              TO ACTIVE-PARAGRAPH              
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_BTU_WNA_RANGE' TO TABLE-1                       
A00659        MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
A00659        MOVE WS-ACCOUNT-NO-NUM   TO HOSTVAR-ELEMENT-1             
A00659        MOVE 'EFFECTIVE_DT'      TO TABLE-ELEMENT-2               
A00659        MOVE WS-EFFECTIVE-DT-BR  TO HOSTVAR-ELEMENT-2             
A00659        MOVE 'RATE_PLAN_NO'      TO TABLE-ELEMENT-3               
A00659        MOVE BR-RATE-PLAN-NO     TO HOSTVAR-ELEMENT-3             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                 11136400
       7710-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11136400
      ************************************************************      16840004
C32676 7800-CALC-WNA-WITH-NEWRATE.                                      
C32676     MOVE WS-RATE-PLAN-NO        TO BR-RATE-PLAN-NO.              
C32676     PERFORM 7710-SELECT-BTU-WNA-RANGE THRU 7710-EXIT.            
C32676     IF  SQLCODE EQUAL SUCCESSFUL-CALL                            
C32676         IF  BR-WNA-LOWER-LIMIT = 0 AND BR-WNA-UPPER-LIMIT = 0    
C32676             MOVE ZEROS          TO WS-WNA-FACTOR                 
C32676         ELSE                                                     
C32676           IF WS-ATH-BTH = ZERO                                   
C32676             MOVE ZERO        TO WS-WNA-FACTOR                    
C32676           ELSE                                                   
C32676              COMPUTE WS-WNA-FACTOR ROUNDED =                     
C32676                            (WS-WSL-ROUNDED-FINAL *               
C32676                                BR-WNA-GAS-RATE) / WS-ATH-BTH     
C32676                 ON SIZE ERROR                                    
C32676                     MOVE ZERO TO WS-WNA-FACTOR                   
C32676           END-IF                                                 
C32676         END-IF                                                   
C32676     END-IF.                                                      
C32676 7800-EXIT.                                                       
C32676      EXIT.                                                       
      *                                                                         
A00659******************************************************************40490000
A00659* 7900-SEL-MIN-MAX-PRORATE-DAYS.                                 *11132500
A00659******************************************************************11132400
A00659 7900-SEL-MIN-MAX-PRORATE-DAYS.                                   
A00659                                                                  
A00659     EXEC SQL                                                     
A00659         SELECT  MIN_PRORATION_DAYS                               
A00659                ,MAX_PRORATION_DAYS                               
A00659           INTO :C7-MIN-PRORATION-DAYS                            
A00659               ,:C7-MAX-PRORATION-DAYS                            
A00659           FROM CSS_COMPANY WITH(READUNCOMMITTED)                         
A00659          WHERE COMPANY_NO = :PARM-COMPANY-NO                     
A00659                                                           
A00659     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     11132600
MFA-TR*        SELECT  MIN_PRORATION_DAYS                                       
MFA-TR*               ,MAX_PRORATION_DAYS                                       
MFA-TR*          INTO :C7-MIN-PRORATION-DAYS                            11133100
MFA-TR*              ,:C7-MAX-PRORATION-DAYS                            11133200
MFA-TR*          FROM CSS_COMPANY                                               
MFA-TR*         WHERE COMPANY_NO = :PARM-COMPANY-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    11133300

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00659*                                                                 11130500
A00659     IF SQLCODE = SUCCESSFUL-CALL                                 
A00659        NEXT SENTENCE                                             
A00659     ELSE                                                         
A00659        MOVE SPACES              TO ABEND-TABLES                  
A00659        MOVE SPACES              TO ABEND-SQL-PREDICATES          
A00659        MOVE '7900'              TO ACTIVE-PARAGRAPH              
A00659        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
A00659        MOVE 'SELECT'            TO ABEND-FUNCTION                
A00659        MOVE 'CSS_COMPANY'       TO TABLE-1                       
A00659        MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-1               
A00659        MOVE PARM-COMPANY-NO     TO HOSTVAR-ELEMENT-1             
A00659        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
A00659        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
A00659     END-IF.                                                      
A00659*                                                                 11136400
A00659 7900-EXIT.                                                       
A00659     EXIT.                                                        
A00659*                                                                 11136400
      ******************************************************************04090800
      * 8002-GET-PREV-READ-DATE.                                     *  04090900
      ******************************************************************04091700
       8002-GET-PREV-READ-DATE.                                         
                                                                        
T37151       EXEC SQL                                                   
T37151          SELECT
              DATEADD( DAY, -:PARM-NO-DAYS, IIF(TRY_CONVERT(DATE, 
                                                        :PARM-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :PARM-DATE-READ
              ) <> 0) OR (LEN(:PARM-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                        :PARM-DATE-READ
              ), CONVERT(DATE, :PARM-DATE-READ) ) ),
              DATEADD( DAY, -30, IIF(TRY_CONVERT(DATE, :PARM-DATE-READ
              ) IS NULL OR (PATINDEX('%.%', :PARM-DATE-READ
              ) <> 0) OR (LEN(:PARM-DATE-READ) <> 10), CIS.CHAR2DATE(
                                                        :PARM-DATE-READ
              ), CONVERT(DATE, :PARM-DATE-READ) ) )
            INTO
              :WS-PREV-READ-DATE,
              :WS-PRORATED-DATE           
T37151       END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*      EXEC SQL                                                           
MFA-TR*         SET :WS-PREV-READ-DATE =                                        
MFA-TR*                       DATE(:PARM-DATE-READ) - :PARM-NO-DAYS DAYS        
MFA-TR*            ,:WS-PRORATED-DATE =                                         
MFA-TR*                       DATE(:PARM-DATE-READ) - 30 DAYS                   
MFA-TR*      END-EXEC.                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T37151       MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                      
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8002'               TO ACTIVE-PARAGRAPH             
A00659        MOVE 'SET'                TO ABEND-FUNCTION               
              MOVE 'CSS_CNSMPTN_HIST'   TO TABLE-1                      
A00659        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
A00659        MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
A00659        MOVE 'BILL_NO'            TO TABLE-ELEMENT-2              
A00659        MOVE WS-BILL-NO-NUM       TO HOSTVAR-ELEMENT-2            
A00659        MOVE 'CURR_READ_DATE'     TO TABLE-ELEMENT-3              
A00659        MOVE PARM-DATE-READ       TO HOSTVAR-ELEMENT-3            
A00659        MOVE 'IC_NO'              TO TABLE-ELEMENT-4              
A00659        MOVE WS-IC-NO-NUM         TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8002-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04139000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *04140000
A02034* 9900-SQL-ERROR-ROUTINE.                                        *        
A02034******************************************************************        
A02034*                                                                *        
           EXEC SQL                                                     04160000
              INCLUDE CPDSP300                                          04170000
           END-EXEC.                                                    04180000
                                                                        
      ******************************************************************04200000
      *       END PROGRAM COPYLIB                                      *04210000
      ******************************************************************04220000
CVT000 8100-SEND-RESULT.                                                
CVT000       ADD 1 TO CTR-ROWS.                                         
CVT000 8100-EXIT.                                                       
CVT000        EXIT.                                                     
A02034*                                                                *        
A02034******************************************************************        
A02034*   PROCESS ABENDS -   9700-PROCESS-ABEND.                       *        
A02034******************************************************************        
A02034*                                                                *        
A02034 COPY CPD0023C.                                                           
A02034*                                                                *        
A02034******************************************************************        
A02034*   PROCESS ABENDS -   9900-SQL-ERROR-ROUTINE.                   *        
A02034******************************************************************        
A02034*                                                                *        
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00321                                         00000200
CVT000     END-EXEC.                                                    00000300
