       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02230.                                         
COB303 DATE-WRITTEN.  NOVEMBER 21,1994.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S230                                           *        
      *  PROGRAM:       S230                                           *        
      *  CALLING SP:    PA_S230                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM UPDATES DATES IN TABLE CSS_FINAL_WO.             *        
      *  IT ALSO SETS AN UPDATE FLAG TO NOT NULL SO THAT CA101 DOES    *        
      *  NOT REFORECAST DATES IN THOSE RECORDS.                        *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  11/21/94    AS       PROCEDURE ORIGINALLY CODED.              *        
      *  06/04/95    AS       TRANSACTION COMMENT LENGTH AND TEXT      *        
      *                       PARAMTERS ADDED.                         *        
      *  06/09/95    TCB      TPR 5577 - TABLE CHANGE FIX.             *        
      *  06/16/95    TCB      ADD NULL INDICATORS TO PARA 8000 & 8200. *        
      *  06/27/95    TCB      REFORMATTED DATES GOING TO TRANSACTION   *        
      *                       HISTORY DETAIL FROM YYYY-MM-DD TO        *        
      *                       MM/DD/YYYY.                              *        
      *  10/31/96    KOG      MODIFIED TO DO CORRECT UPDATE ON WRITE   *        
      *                       OFF DATE, 1ST WRITE OFF, 2ND WRITE OFF,  *        
      *                       COLL AGENCY DATE, AND CREDIT BUREAU DATE.*        
T11585*  06/11/97    EMM      CHANGED PARA 5000-, 8000-, 8100 TO       *        
      *                       UPDATE FINAL WO CORRECTLY.               *        
PCR408*  07/01/97    EMM      CHANGED UPDATE TO PROCESS GUARANTOR XFER *        
      *                       AND FINAL BILL 40 DAY NOTICE.            *        
T12778*  09/30/97    BAB      MODIFIED TO NO LONGER INSERT DETAIL ROWS *        
      *                       WHEN THE FIRST CREDIT LETTER, SECOND     *        
      *                       CREDIT LETTER, COLLECTION, AND CREDIT    *        
      *                       BUREAU REPORT DATES CHANGE.              *        
T17316*  08/07/98    SHF      TPR 12778 COMMENTED OUT LOGIC THAT WOULD *        
      *                       DISPLAY CERTAIN DATE CHANGES ON TRANS    *        
      *                       HIST.  ADDED THIS LOGIC BACK AND ADDED   *        
      *                       FLAG SO THE DATES FROM TPR 12778 WOULD   *        
      *                       NOT DISPLAY WHEN THE WO DATE IS CHANGED. *        
CBSI  *  11/16/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *             MADRAS    ABEND PARAMETERS                         *        
T21429*  05/17/00   SS82048   UPDATE SERVICE END DATE ON               *        
      *                       CSS_CUST_PREM_HIST WHEN NON-UTILITY ACCT *        
      *                       IS FINALED.                              *        
T21886*  10/17/00   VIJAY     UPDATE FIRST_CR_LTR_AM WITH ZEROS WHEN   *        
      *                       COLLECTION AGENCY DATE CHANGES.          *        
T23511*  01/18/01   BB18179   VERIFY DATE FIELDS HAVE DATES BEFORE     *        
      *                       UPDATING DATABASE.  OTHERWISE, SET NULL  *        
      *                       INDICATORS.                              *        
REARCH*  05/18/05   CVNS      RPC TO COBOL SP CONVERSION               *        
REARCH*             CHENNAI                                            *        
T35434*  10/31/07   MK92804   REPLACED CSS_MODEL_SQL WITH SET STMTS    *        
T35434*                       AND ADDED FOR FETCH ONLY WITH UR FOR     *        
T35434*                       CURSOR SELECTS AND WITH UR FOR SINGLETON *        
T35434*                       SELECTS.                                 *        
C30169*  12/21/07   COVANSYS  WRITEOFF RECOVERY CHANGES                *        
C30169*                                                                *        
P00599*  08/27/12   NS75440   CHANGE TO POPLATE FW_BUS_PROCESS_CD ='CA'*        
P00599*                       IN CSS_FIN_WO_ACTION.                    *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02230'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02230 STARTS HERE'.                  
                                                                        
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
REARCH*COPY SYGWCOB.                                                            
REARCH*COPY SYDBCOB.                                                            
       COPY CCA00001.                                                           
REARCH*COPY CWS00010.                                                           
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CWSX0010                                                  
REARCH     END-EXEC.                                                            
REARCH*                                                                         
       COPY CWS00027.                                                           
       COPY CWS00303.                                                           
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  SYBASE-DATATYPE.                                             
           05  DATATYPE                 PIC S9(9) COMP.                 
           05  ACTUAL-DATA-LENGTH       PIC S9(9) COMP.                 
           05  MAX-DATA-LENGTH          PIC S9(9) COMP.                 
           05  PARM-STATUS              PIC S9(9) COMP.                 
           05  PARM-NAME                PIC X(30).                      
           05  PARM-NAME-LENGTH         PIC S9(9) COMP.                 
           05  USER-DATATYPE            PIC S9(9) COMP.                 
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME             PIC X(08) VALUE 'CSR02230'.     
PCR408     05  WS-TIME-STAMP            PIC X(26).                      
           05  WS-FORMATTED-TIME-STMP.                                  
               10 WS-CURRENT-DATE       PIC X(10).                      
               10 FILLER                PIC X(01).                      
               10 WS-CURRENT-TIME       PIC X(15).                      
           05  WS-ACCOUNT-NO            PIC 9(13)  VALUE ZERO.          
           05  WS-ACCOUNT-NO-NUM        PIC S9(13) COMP-3 VALUE ZERO.   
           05  WS-ITEM-ID               PIC S9(9)  COMP.                
           05  WS-FW-ATTR-VALUE-DESC    PIC X(75) VALUE SPACE.          
           05  WS-FW-ATTRIB-TYPE-CD     PIC X(02) VALUE SPACE.          
           05  WS-FW-ATTR-VALUE-CD      PIC X(05) VALUE SPACE.          
           05  WS-ITEM-ID-NUM           PIC S9(9)  COMP.                
           05  WS-TRAN-APPL-NO          PIC S9(04) COMP VALUE +0.       
           05  WS-DATE-NULL-IND1        PIC S9(4) COMP VALUE 0.         
           05  WS-DATE-NULL-IND2        PIC S9(4) COMP VALUE 0.         
           05  WS-DATE-NULL-IND3        PIC S9(4) COMP VALUE 0.         
           05  WS-DATE-NULL-IND4        PIC S9(4) COMP VALUE 0.         
           05  WS-DATE-NULL-IND5        PIC S9(4) COMP VALUE 0.         
T30169     05  WS-TRAN-APPL-NO-NULL     PIC S9(4) COMP VALUE 0.         
T30169     05  WS-WITHDRAW-DT-NULL      PIC S9(4) COMP VALUE 0.         
T30169     05  WS-IZ-WITHDRAW-DT        PIC X(10) VALUE SPACES.         
T30169     05  WS-KD-ACTION-DT          PIC X(10) VALUE SPACES.         
PCR408     05  WS-GUAR-XFER-DT-IND      PIC S9(4) COMP VALUE 0.         
PCR408     05  WS-FOURTH-FINAL-DT-IND   PIC S9(4) COMP VALUE 0.         
T30169     05  WS-AMT-DISPLAY           PIC -ZZZ,ZZZ,ZZ9.99.            
T30169     05  WS-NUM-DISPLAY           PIC -ZZZ,ZZZ,ZZ9.               
           05  WS-DATE-BREAKDOWN.                                       
               10  WS-DATE-YYYY         PIC X(4).                       
               10  FILLER               PIC X(1).                       
               10  WS-DATE-MM           PIC X(2).                       
               10  FILLER               PIC X(1).                       
               10  WS-DATE-DD           PIC X(2).                       
           05  WS-DATE-NEW-FORMAT.                                      
               10  WS-DATE-NEW-MM       PIC X(2).                       
               10  FILLER               PIC X(1) VALUE '/'.             
               10  WS-DATE-NEW-DD       PIC X(2).                       
               10  FILLER               PIC X(1) VALUE '/'.             
               10  WS-DATE-NEW-YYYY     PIC X(4).                       
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
                                                                        
T17316     05  WS-DATE-CHANGES          PIC X.                          
T17316         88  DISPLAY-DATE-CHANGES           VALUE 'Y'.            
T17316         88  DO-NOT-DISPLAY-DATE-CHANGES    VALUE 'N'.            
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-A                        PIC X(01)   VALUE 'A'.       
           05  WS-B                        PIC X(01)   VALUE 'B'.       
           05  WS-C                        PIC X(01)   VALUE 'C'.       
           05  WS-F                        PIC X(01)   VALUE 'F'.       
           05  WS-J                        PIC X(01)   VALUE 'J'.       
           05  WS-K                        PIC X(01)   VALUE 'K'.       
           05  WS-R                        PIC X(01)   VALUE 'R'.       
           05  WS-T                        PIC X(01)   VALUE 'T'.       
           05  WS-W                        PIC X(01)   VALUE 'W'.       
           05  WS-Z                        PIC X(01)   VALUE 'Z'.       
                                                                        
REARCH*01  GW-LIB-MISC-FIELDS.                                                  
REARCH*    05  GWL-PROC                 POINTER.                                
REARCH*    05  GWL-INIT-HANDLE          POINTER.                                
REARCH*    05  GWL-RC                   PIC S9(9) COMP.                         
REARCH*    05  GWL-STATUS-NR            PIC S9(9) COMP.                         
REARCH*    05  GWL-STATUS-DONE          PIC S9(9) COMP.                         
REARCH*    05  GWL-STATUS-COUNT         PIC S9(9) COMP.                         
REARCH*    05  GWL-STATUS-COMM          PIC S9(9) COMP.                         
REARCH*    05  GWL-STATUS-RETURN-CODE   PIC S9(9) COMP.                         
REARCH*    05  GWL-STATUS-SUBCODE       PIC S9(9) COMP.                         
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
                                                                        
       01  PARM-FIELDS.                                                 
REARCH*    05  PARM-L                     PIC S9(9) COMP.                       
REARCH*    05  PARM-ID1                   PIC S9(9) COMP VALUE 1.               
REARCH*    05  PARM-ACCOUNT-NO            PIC X(13)  VALUE SPACE.               
REARCH     05  PARM-ACCOUNT-NO-TEMP       PIC X(13)  VALUE SPACE.       
REARCH     05  PARM-ACCOUNT-NO-RED        REDEFINES PARM-ACCOUNT-NO-TEMP
                                          PIC 9(13).                    
REARCH*    05  PARM-ITEM-ID               PIC X(5)  VALUE SPACE.                
REARCH     05  PARM-ITEM-ID-TEMP          PIC X(5)  VALUE SPACE.        
REARCH     05  PARM-ITEM-ID-RED           REDEFINES PARM-ITEM-ID-TEMP   
                                          PIC 9(5).                     
PCR408*    05  PARM-GUARANTOR-XFER-DT     PIC X(10) VALUE SPACE.                
PCR408*    05  PARM-FOURTH-FINAL-DT       PIC X(10) VALUE SPACE.                
PCR395*    05  PARM-WRITE-OFF-DT          PIC X(10) VALUE SPACE.                
REARCH*    05  PARM-FIRST-WO-DT           PIC X(10) VALUE SPACE.                
REARCH*    05  PARM-SECOND-WO-DT          PIC X(10) VALUE SPACE.                
REARCH*    05  PARM-COLL-AGENCY-DT        PIC X(10) VALUE SPACE.                
REARCH*    05  PARM-CRED-BUREAU-DT        PIC X(10) VALUE SPACE.                
REARCH*    05  PARM-USER-ID               PIC X(07).                            
REARCH*    05  PARM-RESP-AREA-ID          PIC X(03).                            
           05  PARM-TRANS-COMMENT.                                      
REARCH         49  PARM-TRANS-COMMENT-LEN  PIC S9(4) COMP.              
REARCH         49  PARM-TRANS-COMMENT-TEXT PIC X(210).                  
REARCH*    05  PARM-NON-UTIL-ACTION       PIC X(01).                            
REARCH*    05  PARM-CUSTOMER-NO           PIC X(10).                            
REARCH     05  PARM-CUSTOMER-NO-TEMP      PIC X(10).                    
REARCH     05  PARM-CUSTOMER-NO-RED     REDEFINES PARM-CUSTOMER-NO-TEMP 
                                          PIC 9(10).                    
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
           05  RS-TRANS-SEQ-NO          PIC X(26) VALUE SPACES.         
           05  RS-TRANS-APPL-NO         PIC S9(4) COMP VALUE 0.         
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE            PIC S9(9) COMP VALUE 0.         
           05  S-TRANS-SEQ-NO           PIC X(26) VALUE SPACES.         
           05  S-TRANS-APPL-NO          PIC S9(4) COMP VALUE 0.         
REARCH*                                                                         
REARCH*01  CN-COLUMN-NAMES.                                                     
REARCH*    05  CN-RETURN-CODE           PIC X(11) VALUE                         
REARCH*                                        'RETURN_CODE'.                   
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS10016                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBFINLWO                                                  
           END-EXEC.                                                            
                                                                        
C30169     EXEC SQL                                                             
C30169        INCLUDE TBFWACTN                                                  
C30169     END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
PCR408     EXEC SQL                                                             
              INCLUDE TBOFFCYL                                                  
           END-EXEC.                                                            
                                                                        
PCR408     EXEC SQL                                                             
              INCLUDE TBGTNTR                                                   
           END-EXEC.                                                            
                                                                        
NONUTL     EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
NONUTL     EXEC SQL                                                             
              INCLUDE TBDFAACT                                                  
           END-EXEC.                                                            
                                                                        
NONUTL     EXEC SQL                                                             
              INCLUDE TBDEPHND                                                  
           END-EXEC.                                                            
                                                                        
NONUTL     EXEC SQL                                                             
              INCLUDE TBCNTRCT                                                  
           END-EXEC.                                                            
                                                                        
NONUTL     EXEC SQL                                                             
              INCLUDE TBARCNTL                                                  
           END-EXEC.                                                            
                                                                        
NONUTL     EXEC SQL                                                             
              INCLUDE TBPRJSHR                                                  
           END-EXEC.                                                            
                                                                        
NONUTL     EXEC SQL                                                             
              INCLUDE TBMSTSUB                                                  
           END-EXEC.                                                            
                                                                        
T30169     EXEC SQL                                                             
             INCLUDE TBFWCLAG                                                   
           END-EXEC.                                                            
                                                                        
T30169     EXEC SQL                                                             
             INCLUDE TBREGPRF                                                   
           END-EXEC.                                                            
                                                                        
T30169     EXEC SQL                                                             
             INCLUDE TBCLAGNY                                                   
           END-EXEC.                                                            
                                                                        
T21429     EXEC SQL                                                             
T21429        INCLUDE TBCSTPRM                                                  
T21429     END-EXEC.                                                            
                                                                        
      *                                                                         
           EXEC SQL                                                     
             DECLARE GUARANTOR_CRSR CURSOR FOR                          
               SELECT                                                   
                  GU.GUARNTR_ACCT_NO                                    
               FROM                                                     
                  CSS_GUARANTOR GU WITH(READUNCOMMITTED)                        
               WHERE                                                    
                    GU.ACCOUNT_NO      = :GU-ACCOUNT-NO                 
               AND  GU.GUAR_STATUS_CD  = 'A'                            
T35434         FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE GUARANTOR_CRSR CURSOR FOR                                  
MFA-TR*        SELECT                                                           
MFA-TR*           GU.GUARNTR_ACCT_NO                                            
MFA-TR*        FROM                                                             
MFA-TR*           CSS_GUARANTOR GU                                              
MFA-TR*        WHERE                                                            
MFA-TR*             GU.ACCOUNT_NO      = :GU-ACCOUNT-NO                         
MFA-TR*        AND  GU.GUAR_STATUS_CD  = 'A'                                    
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                                    
REARCH*                                                                         
REARCH LINKAGE SECTION.                                                 
REARCH 01  PARM-FW-UPDATE-TYPE        PIC X(01).                        
REARCH 01  PARM-ACCOUNT-NO            PIC X(13).                        
REARCH 01  PARM-ITEM-ID               PIC X(05).                        
C30169 01  PARM-FIN-WO-ACTION-DT      PIC X(10).                        
C30169 01  PARM-FW-ACTION-TYPE-CD     PIC X(05).                        
C30169 01  PARM-FW-SEQ-NO             PIC S9(4) COMP.                   
C30169 01  PARM-CODE-COLLEC-AGNCY     PIC X(03).                        
C30169 01  PARM-COLL-AGY-SUB-CD       PIC X(03).                        
REARCH*01  PARM-GUARANTOR-XFER-DT     PIC X(10).                                
REARCH*01  PARM-FOURTH-FINAL-DT       PIC X(10).                                
REARCH*01  PARM-WRITE-OFF-DT          PIC X(10).                                
REARCH*01  PARM-FIRST-WO-DT           PIC X(10).                                
REARCH*01  PARM-SECOND-WO-DT          PIC X(10).                                
REARCH*01  PARM-COLL-AGENCY-DT        PIC X(10).                                
REARCH*01  PARM-CRED-BUREAU-DT        PIC X(10).                                
REARCH 01  PARM-USER-ID               PIC X(07).                        
REARCH 01  PARM-RESP-AREA-ID          PIC X(03).                        
REARCH 01  PARM-TRANS-CMNT-TEXT       PIC X(210).                       
REARCH 01  PARM-TRANS-CMNT-LEN        PIC S9(4) COMP SYNC.              
REARCH 01  PARM-NON-UTIL-ACTION       PIC X(01).                        
REARCH 01  PARM-CUSTOMER-NO           PIC X(10).                        
REARCH 01  PARM-COMPANY-NO            PIC X(02).                        
REARCH 01  PARM-TRANS-SEQ-NO          PIC X(26).                        
REARCH 01  PARM-TRANS-APPL-NO         PIC S9(4) COMP SYNC.              
REARCH*                                                                         
REARCH PROCEDURE DIVISION USING PARM-FW-UPDATE-TYPE                     
REARCH                          PARM-ACCOUNT-NO                         
REARCH                          PARM-ITEM-ID                            
C30169                          PARM-FIN-WO-ACTION-DT                   
C30169                          PARM-FW-ACTION-TYPE-CD                  
C30169                          PARM-FW-SEQ-NO                          
C30169                          PARM-CODE-COLLEC-AGNCY                  
C30169                          PARM-COLL-AGY-SUB-CD                    
REARCH                          PARM-USER-ID                            
REARCH                          PARM-RESP-AREA-ID                       
REARCH                          PARM-TRANS-CMNT-TEXT                    
REARCH                          PARM-TRANS-CMNT-LEN                     
REARCH                          PARM-NON-UTIL-ACTION                    
REARCH                          PARM-CUSTOMER-NO                        
T30169                          PARM-COMPANY-NO                         
T30169                          PARM-TRANS-SEQ-NO                       
T30169                          PARM-TRANS-APPL-NO.                     
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARCH            :S-RETURN-CODE       AS RETURN_CODE                   
REARCH           ,:S-TRANS-SEQ-NO      AS TRANS_SEQ_NO                  
REARCH           ,:S-TRANS-APPL-NO     AS TRANS_APPL_NO                 
REARCH         FROM                                                     
REARCH            CIS.SYSDUMMY1                                      
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*           :S-RETURN-CODE       AS RETURN_CODE                           
MFA-TR*          ,:S-TRANS-SEQ-NO      AS TRANS_SEQ_NO                          
MFA-TR*          ,:S-TRANS-APPL-NO     AS TRANS_APPL_NO                         
MFA-TR*        FROM                                                             
MFA-TR*           SYSIBM.SYSDUMMY1                                              
MFA-TR*    END-EXEC.                                                            
REARCH*                                                                         
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
REARCH     MOVE PARM-ACCOUNT-NO           TO PARM-ACCOUNT-NO-TEMP.      
REARCH     MOVE PARM-ITEM-ID              TO PARM-ITEM-ID-TEMP.         
REARCH     MOVE PARM-CUSTOMER-NO          TO PARM-CUSTOMER-NO-TEMP.     
REARCH     MOVE PARM-TRANS-CMNT-LEN       TO PARM-TRANS-COMMENT-LEN.    
REARCH     MOVE PARM-TRANS-CMNT-TEXT      TO PARM-TRANS-COMMENT-TEXT.   
           MOVE PARM-ACCOUNT-NO-RED       TO WS-ACCOUNT-NO.             
           MOVE WS-ACCOUNT-NO             TO WS-ACCOUNT-NO-NUM.         
           MOVE PARM-ITEM-ID-RED          TO WS-ITEM-ID.                
           MOVE WS-ITEM-ID                TO WS-ITEM-ID-NUM.            
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      *     1. DESCRIBE RESULT SET                                     *        
      *     2. UPDATE DB2 DATA                                         *        
      *     3. BUILD RESULT SET                                        *        
      *     4. SEND RESULT SET                                         *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           IF PARM-NON-UTIL-ACTION > SPACES                             
              PERFORM 2500-NON-UTIL-PROCESS     THRU 2500-EXIT          
              IF RS-RETURN-CODE = 0                                     
                 PERFORM 5100-MOVE-TRAN-HEAD    THRU 5100-EXIT          
                 PERFORM 5210-MOVE-TRAN-DET     THRU 5210-EXIT          
              END-IF                                                    
REARCH        PERFORM 2000A-MOVE-RESULT         THRU 2000A-EXIT         
REARCH        ADD +1                            TO   CTR-ROWS           
           ELSE                                                         
              PERFORM 5000-UPDATE                THRU 5000-EXIT         
REARCH        PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT        
REARCH        ADD +1                             TO   CTR-ROWS          
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************        
REARCH* 2000A-MOVE-RESULT                                              *        
REARCH******************************************************************        
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE RS-RETURN-CODE          TO S-RETURN-CODE.               
REARCH     MOVE RS-TRANS-SEQ-NO         TO S-TRANS-SEQ-NO.              
REARCH     MOVE RS-TRANS-APPL-NO        TO S-TRANS-APPL-NO.             
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
                                                                        
      ***************************************************************           
      * 2500-NON-UTIL-PROCESS                                       *           
      * THIS PARAGRAPH WILL DO ONE OF TWO THINGS                    *           
      * 1) INSERT A NON-UTILITY ACCOUNT TO THE OFF_CYCLE TABLE IF   *           
      *    THE ACCOUNT PASSES ALL OF THE APPROPRIATE EDITS.  THESE  *           
      *    EDITS WILL BE LOCATED IN A NEW CPD THAT IS USED BY THIS  *           
      *    PROGRAM AND PCSCA107.                                    *           
      * 2) IF THE ACCOUNT ALREADY EXISTS ON THE OFF_CYCLE_ACCT TABLE*           
      *    AND THE ACTION-FLAG IS SET TO 'D' THIS PROGRAM WILL      *           
      *    THE ROW FROM THE OFF_CYCLE TABLE.                        *           
      ***************************************************************           
                                                                        
       2500-NON-UTIL-PROCESS.                                           
                                                                        
      *                                                                         
                                                                        
           MOVE 'B'                  TO OC-CODE-BILL-OFF-CYCL.          
           MOVE PARM-ACCOUNT-NO-RED  TO OC-ACCOUNT-NO                   
T21429                                  CH-ACCOUNT-NO.                  
           MOVE PARM-CUSTOMER-NO-RED TO OC-CUSTOMER-NO.                 
                                                                        
           IF PARM-NON-UTIL-ACTION = 'D'                                
              PERFORM 8300-DELETE-ENTRY-OFF-CYCLE THRU 8300-EXIT        
T21429        PERFORM 8510-UPDATE-PREM-HIST THRU 8510-EXIT              
           ELSE                                                         
              MOVE PARM-ACCOUNT-NO-RED    TO AT-ACCOUNT-NO              
              MOVE 'PANEL273'             TO WS-NON-UTIL-PROG           
      ****************************************************************          
      * THIS IS A CALL TO CPD00312 TO DO THE NON-UTIL EDITS.         *          
      ****************************************************************          
              PERFORM 5500-CHECK-NON-UTIL                               
                 THRU 5500-CHECK-NON-UTIL-EXIT                          
              IF NO-NON-UTIL-ERR                                        
                 PERFORM 8400-INSERT-ENTRY-OFF-CYCLE THRU 8400-EXIT     
T21429           PERFORM 7100-GET-TIMESTAMP          THRU 7100-EXIT     
T21429           MOVE WS-TIME-STAMP            TO WS-FORMATTED-TIME-STMP
T21429           MOVE WS-CURRENT-DATE          TO CH-DATE-UTIL-SVC-END  
T21429           PERFORM 8500-UPDATE-PREM-HIST THRU 8500-EXIT           
              ELSE                                                      
                 MOVE WS-NON-UTIL-ERROR TO RS-RETURN-CODE               
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
C30169***************************************************************           
      * 2600-VERIFY-ACTION                                          *           
      ***************************************************************           
C30169*                                                                         
C30169 2600-VERIFY-ACTION.                                              
C30169*                                                                         
                                                                        
           EVALUATE PARM-FW-ACTION-TYPE-CD                              
           WHEN 'GAXF'                                                  
               IF PARM-FIN-WO-ACTION-DT = WS-CURRENT-DATE OR            
                  PARM-FW-UPDATE-TYPE   = 'D'                           
                  PERFORM 5110-DELETE-OFF-CYCLE                         
                                            THRU 5110-EXIT              
               END-IF                                                   
           END-EVALUATE.                                                
                                                                        
C30169*                                                                         
C30169 2600-EXIT.                                                       
C30169     EXIT.                                                        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00312                                                  
           END-EXEC.                                                            
                                                                        
      ***************************************************************           
      * MAIN UPDATE PARAGRAPH.                                      *           
      ***************************************************************           
                                                                        
       5000-UPDATE.                                                     
                                                                        
           MOVE WS-ACCOUNT-NO-NUM           TO KD-ACCOUNT-NO            
                                               IZ-ACCOUNT-NO            
                                               LR-ACCOUNT-NO.           
                                                                        
           MOVE PARM-FW-SEQ-NO              TO KD-FW-SEQ-NO             
                                               IZ-FW-COLL-SEQ-NO.       
                                                                        
           EVALUATE PARM-FW-ACTION-TYPE-CD                              
           WHEN '1PLWD'                                                 
              MOVE '1PLMT'                  TO KD-FW-ACTION-TYPE-CD     
                                               IZ-FW-ACTION-TYPE-CD     
           WHEN '2PLWD'                                                 
              MOVE '2PLMT'                  TO KD-FW-ACTION-TYPE-CD     
                                               IZ-FW-ACTION-TYPE-CD     
           WHEN '3PLWD'                                                 
              MOVE '3PLMT'                  TO KD-FW-ACTION-TYPE-CD     
                                               IZ-FW-ACTION-TYPE-CD     
           WHEN OTHER                                                   
              MOVE PARM-FW-ACTION-TYPE-CD   TO KD-FW-ACTION-TYPE-CD     
                                               IZ-FW-ACTION-TYPE-CD     
           END-EVALUATE.                                                
                                                                        
           IF PARM-FW-UPDATE-TYPE = 'D' OR 'U'                          
              PERFORM 7300-SELECT-ACTION-DATES THRU 7300-EXIT           
           END-IF.                                                      
                                                                        
T30169********* UPDATE JOURNALS ************************************            
                                                                        
           PERFORM 5100-MOVE-TRAN-HEAD      THRU 5100-EXIT.             
           PERFORM 5200-MOVE-TRAN-DET       THRU 5200-EXIT.             
                                                                        
                                                                        
T30169********* UPDATE / INSERT / DELETE ACTIONS *******************            
                                                                        
           EVALUATE PARM-FW-UPDATE-TYPE                                 
           WHEN 'U'                                                     
              IF PARM-FW-ACTION-TYPE-CD(2:4) = 'PLWD'                   
                 MOVE PARM-FIN-WO-ACTION-DT TO IZ-WITHDRAW-DT           
                 PERFORM 8610-UPDATE-FIN-WO-COLLECT                     
                                            THRU 8610-EXIT              
              ELSE                                                      
                 PERFORM 2600-VERIFY-ACTION THRU 2600-EXIT              
                 MOVE PARM-FIN-WO-ACTION-DT TO KD-FW-ACTION-DT          
                 PERFORM 8600-UPDATE-FIN-WO-ACTION                      
                                            THRU 8600-EXIT              
                END-IF                                                  
           WHEN 'I'                                                     
              IF PARM-FW-ACTION-TYPE-CD(2:4) = 'PLWD'                   
                 MOVE PARM-FIN-WO-ACTION-DT TO IZ-WITHDRAW-DT           
                 PERFORM 8610-UPDATE-FIN-WO-COLLECT                     
                                            THRU 8610-EXIT              
              ELSE                                                      
                 MOVE PARM-FIN-WO-ACTION-DT TO KD-FW-ACTION-DT          
                 IF PARM-FW-ACTION-TYPE-CD = 'CREDB'                    
P00599              MOVE 'CB'               TO KD-FW-BUS-PROCESS-CD     
P00599           ELSE                                                   
P00599              MOVE 'CA'               TO KD-FW-BUS-PROCESS-CD     
P00599           END-IF                                                 
                 PERFORM 8620-INSERT-FIN-WO-ACTION                      
                                            THRU 8620-EXIT              
                                                                        
                 IF PARM-FW-ACTION-TYPE-CD = '1PLMT' OR                 
                    PARM-FW-ACTION-TYPE-CD = '2PLMT' OR                 
                    PARM-FW-ACTION-TYPE-CD = '3PLMT' OR                 
                    PARM-FW-ACTION-TYPE-CD = 'ATY'   OR                 
                    PARM-FW-ACTION-TYPE-CD = 'SAL'                      
                                                                        
                    MOVE PARM-CUSTOMER-NO-RED                           
                                            TO IZ-CUSTOMER-NO           
                    MOVE PARM-COMPANY-NO                                
                                            TO IZ-COMPANY-NO            
                    MOVE PARM-CODE-COLLEC-AGNCY                         
                                            TO IZ-CODE-COLLEC-AGNCY     
                    MOVE PARM-COLL-AGY-SUB-CD                           
                                            TO IZ-COLL-AGY-SUB-CD       
                                                                        
                    PERFORM 7400-SELECT-REG-GROUP                       
                                            THRU 7400-EXIT              
                                                                        
                    MOVE LR-REG-GROUP-CD    TO IZ-REG-GROUP-CD          
                                                                        
                    PERFORM 8630-INSERT-FIN-WO-COLLECT                  
                                            THRU 8630-EXIT              
                 END-IF                                                 
              END-IF                                                    
           WHEN 'D'                                                     
              PERFORM 2600-VERIFY-ACTION    THRU 2600-EXIT              
              PERFORM 8640-DELETE-ACTION    THRU 8640-EXIT              
C30169     END-EVALUATE.                                                
C30169*                                                                         
C30169 5000-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                         
      ***************************************************************           
      * MOVE FIELDS TO THE MAINTENANCE TRANSACTION HEADER AND       *           
      * CALL COMMON PARAGRAPH FOR WRITING A ROW.                    *           
      ***************************************************************           
                                                                        
       5100-MOVE-TRAN-HEAD.                                             
           EXEC SQL                                                     
T35434        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :MH-TRANS-HIST-SEQ-NO             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T30169         MOVE MH-TRANS-HIST-SEQ-NO  TO RS-TRANS-SEQ-NO            
           ELSE                                                         
               MOVE SPACES      TO ABEND-TABLES                         
               MOVE SPACES      TO ABEND-SQL-PREDICATES                 
CBSI           MOVE '5100'      TO ACTIVE-PARAGRAPH                     
REARCH         MOVE PROGRAM-NAME TO ABEND-PROGRAM                       
T35434         MOVE 'SET'        TO ABEND-FUNCTION                      
CBSI           MOVE 'ACCOUNT_NO'    TO TABLE-ELEMENT-1                  
CBSI           MOVE PARM-ACCOUNT-NO TO HOSTVAR-ELEMENT-1                
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
T35434         SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-DATE-TRANS                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :MH-DATE-TRANS = CURRENT DATE                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SPACES      TO ABEND-TABLES                         
               MOVE SPACES      TO ABEND-SQL-PREDICATES                 
CBSI           MOVE '5100'      TO ACTIVE-PARAGRAPH                     
REARCH         MOVE PROGRAM-NAME TO ABEND-PROGRAM                       
T35434         MOVE 'SET'        TO ABEND-FUNCTION                      
CBSI           MOVE 'ACCOUNT_NO'    TO TABLE-ELEMENT-1                  
CBSI           MOVE PARM-ACCOUNT-NO TO HOSTVAR-ELEMENT-1                
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           MOVE 'F'               TO MH-CODE-TRAN-TYPE.                 
           MOVE PARM-RESP-AREA-ID TO MH-RESP-AREA-ID.                   
           MOVE WS-ACCOUNT-NO-NUM TO MH-ACCOUNT-NO.                     
           MOVE 0                 TO MH-CUSTOMER-NO.                    
           MOVE 0                 TO MH-PREMISE-NO.                     
           MOVE PARM-USER-ID      TO MH-USER-ID.                        
           MOVE 'PANEL273'              TO MH-APPL-PROGRAM-ID.          
           MOVE PARM-TRANS-COMMENT      TO MH-TRAN-COMMENT.             
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * DELETE THE GUARANTOR/GUARANTEED ACCOUNT ENTRIES FROM THE    *           
      * OFF CYCLE.                                                  *           
      ***************************************************************           
                                                                        
PCR408 5110-DELETE-OFF-CYCLE.                                           
      *                                                                         
           MOVE WS-ACCOUNT-NO           TO OC-ACCOUNT-NO.               
           MOVE 'E'                     TO OC-CODE-BILL-OFF-CYCL.       
      *                                                                         
           PERFORM 8300-DELETE-ENTRY-OFF-CYCLE         THRU 8300-EXIT.  
      *                                                                         
           MOVE WS-ACCOUNT-NO           TO GU-ACCOUNT-NO.               
      *                                                                         
           PERFORM 7200-OPEN-GUARANTOR-CRSR            THRU 7200-EXIT.  
      *                                                                         
           PERFORM 7210-FETCH-GUARANTOR-CRSR           THRU 7210-EXIT.  
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
      *                                                                         
               MOVE GU-GUARNTR-ACCT-NO  TO OC-ACCOUNT-NO                
               MOVE 'G'                 TO OC-CODE-BILL-OFF-CYCL        
      *                                                                         
               PERFORM 8300-DELETE-ENTRY-OFF-CYCLE     THRU 8300-EXIT   
      *                                                                         
               PERFORM 7210-FETCH-GUARANTOR-CRSR       THRU 7210-EXIT   
                                                                        
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7220-CLOSE-GUARANTOR-CRSR           THRU 7220-EXIT.  
      *                                                                         
       5110-EXIT.                                                       
           EXIT.                                                        
C30169*                                                                         
C30169*************************************************************             
C30169* CHECK WHETHER ANY OF THE COLUMN VALUES HAVE CHANGED.IF    *             
C30169* SO THEN WRITE A RECORD IN THE TRANSACTION DETAIL.         *             
C30169*************************************************************             
C30169 5200-MOVE-TRAN-DET.                                              
C30169*                                                                         
           MOVE '5200'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
      *                                                                         
           IF PARM-TRANS-SEQ-NO NOT = SPACES                            
              MOVE PARM-TRANS-SEQ-NO        TO MH-TRANS-HIST-SEQ-NO     
                                               RS-TRANS-SEQ-NO          
              MOVE PARM-TRANS-SEQ-NO(1:10)  TO MH-DATE-TRANS            
              MOVE PARM-TRANS-APPL-NO       TO WS-TRAN-APPL-NO          
           ELSE                                                         
              MOVE +1                       TO WS-TRAN-APPL-NO          
           END-IF                                                       
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO        TO MI-TRANS-HIST-SEQ-NO     
                                                                        
           EVALUATE PARM-FW-UPDATE-TYPE                                 
           WHEN 'U'                                                     
C30169**************************************************************            
C30169*                   UPDATE                                  **            
C30169**************************************************************            
C30169************   INSERT ACTION TYPE  ******************                     
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE 'AT'                     TO WS-FW-ATTRIB-TYPE-CD     
              MOVE PARM-FW-ACTION-TYPE-CD   TO WS-FW-ATTR-VALUE-CD      
                                                                        
              PERFORM 7250-SELECT-ACTION-DESC                           
                                            THRU 7250-EXIT              
              MOVE 'ACTION TYPE'            TO MI-COLUMN-DESC           
              MOVE WS-FW-ATTR-VALUE-DESC    TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF WS-FW-ATTR-VALUE-DESC                      
                                            TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE '*UPDATED*'              TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE +9                       TO MI-CHG-COLUMN-VALUE-LEN  
                                                                        
              PERFORM 6530-LOAD-MNT-TRANS-HIST                          
                                            THRU 6530-EXIT              
              ADD +1                        TO WS-TRAN-APPL-NO          
                                                                        
C30169        IF PARM-FW-ACTION-TYPE-CD(2:4) = 'PLWD'                   
C30169************   INSERT WITHDRAW DT ******************                      
C30169           IF PARM-FIN-WO-ACTION-DT NOT = WS-IZ-WITHDRAW-DT       
                    MOVE WS-TRAN-APPL-NO    TO MI-TRAN-APPL-NO          
                    MOVE 'WITHDRAW DATE'    TO MI-COLUMN-DESC           
                    MOVE +10                TO MI-PRV-COLUMN-VALUE-LEN  
                                               MI-CHG-COLUMN-VALUE-LEN  
                    MOVE PARM-FIN-WO-ACTION-DT                          
                                            TO WS-DATE-BREAKDOWN        
                    PERFORM 5300-DATE-REFORMAT                          
                                            THRU 5300-EXIT              
                    MOVE WS-DATE-NEW-FORMAT TO MI-CHG-COLUMN-VALUE-TEXT 
                                                                        
                    MOVE WS-IZ-WITHDRAW-DT  TO WS-DATE-BREAKDOWN        
                                                                        
                    PERFORM 5300-DATE-REFORMAT                          
                                            THRU 5300-EXIT              
                    MOVE WS-DATE-NEW-FORMAT TO MI-PRV-COLUMN-VALUE-TEXT 
                                                                        
                                                                        
                    PERFORM 6530-LOAD-MNT-TRANS-HIST                    
                                            THRU 6530-EXIT              
                    ADD +1                  TO WS-TRAN-APPL-NO          
                 END-IF                                                 
C30169        ELSE                                                      
C30169************   INSERT ACTION DATE  ******************                     
C30169           IF PARM-FIN-WO-ACTION-DT NOT = WS-KD-ACTION-DT         
                    MOVE WS-TRAN-APPL-NO    TO MI-TRAN-APPL-NO          
                    MOVE 'ACTION DATE'      TO MI-COLUMN-DESC           
                    MOVE +10                TO MI-PRV-COLUMN-VALUE-LEN  
                                            MI-CHG-COLUMN-VALUE-LEN     
                    MOVE PARM-FIN-WO-ACTION-DT                          
                                            TO WS-DATE-BREAKDOWN        
                    PERFORM 5300-DATE-REFORMAT                          
                                            THRU 5300-EXIT              
                    MOVE WS-DATE-NEW-FORMAT TO MI-CHG-COLUMN-VALUE-TEXT 
                                                                        
                    MOVE WS-KD-ACTION-DT    TO WS-DATE-BREAKDOWN        
                                                                        
                    PERFORM 5300-DATE-REFORMAT                          
                                            THRU 5300-EXIT              
                    MOVE WS-DATE-NEW-FORMAT TO MI-PRV-COLUMN-VALUE-TEXT 
                                                                        
                                                                        
                    PERFORM 6530-LOAD-MNT-TRANS-HIST                    
                                            THRU 6530-EXIT              
                    ADD +1                  TO WS-TRAN-APPL-NO          
                 END-IF                                                 
              END-IF                                                    
           WHEN 'I'                                                     
C30169**************************************************************            
C30169*                   INSERT                                  **            
C30169**************************************************************            
C30169************   INSERT ACTION TYPE  ******************                     
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE 'AT'                     TO WS-FW-ATTRIB-TYPE-CD     
              MOVE PARM-FW-ACTION-TYPE-CD                               
                                            TO WS-FW-ATTR-VALUE-CD      
              PERFORM 7250-SELECT-ACTION-DESC                           
                                            THRU 7250-EXIT              
              MOVE 'ACTION TYPE'            TO MI-COLUMN-DESC           
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +5                       TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE WS-FW-ATTR-VALUE-DESC    TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF WS-FW-ATTR-VALUE-DESC                      
                                            TO MI-CHG-COLUMN-VALUE-LEN  
              PERFORM 6530-LOAD-MNT-TRANS-HIST                          
                                            THRU 6530-EXIT              
              ADD +1                        TO WS-TRAN-APPL-NO          
                                                                        
C30169        IF PARM-CODE-COLLEC-AGNCY > SPACES AND                    
C30169           PARM-FW-ACTION-TYPE-CD(2:4) NOT= 'PLWD'                
C30169************  AGENCY NAME      *********************                      
C30169           MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO         
                 MOVE 'COLLECTION AGENCY'   TO MI-COLUMN-DESC           
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE PARM-CODE-COLLEC-AGNCY TO Q7-CODE-COLLEC-AGNCY    
                 PERFORM 7420-SELECT-AGNCY-NAME                         
                                            THRU 7420-EXIT              
                 MOVE Q7-COLLEC-AGNCY-NAME  TO MI-CHG-COLUMN-VALUE-TEXT 
                 MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                
                                            TO MI-CHG-COLUMN-VALUE-LEN  
                 PERFORM 6530-LOAD-MNT-TRANS-HIST                       
                                            THRU 6530-EXIT              
                 ADD +1                     TO WS-TRAN-APPL-NO          
C30169        END-IF                                                    
C30169        IF PARM-FW-ACTION-TYPE-CD(2:4) = 'PLWD'                   
C30169************   INSERT WITHDRAW DT ******************                      
C30169           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO          
                 MOVE 'WITHDRAW DATE'       TO MI-COLUMN-DESC           
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE PARM-FIN-WO-ACTION-DT TO WS-DATE-BREAKDOWN        
                                                                        
                 PERFORM 5300-DATE-REFORMAT                             
                                            THRU 5300-EXIT              
                 MOVE WS-DATE-NEW-FORMAT    TO MI-CHG-COLUMN-VALUE-TEXT 
                 PERFORM 6530-LOAD-MNT-TRANS-HIST                       
                                            THRU 6530-EXIT              
                 ADD +1                     TO WS-TRAN-APPL-NO          
C30169        ELSE                                                      
C30169************   INSERT ACTION DATE  ******************                     
C30169           MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO          
                 MOVE 'ACTION DATE'         TO MI-COLUMN-DESC           
                 MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT 
                 MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE PARM-FIN-WO-ACTION-DT TO WS-DATE-BREAKDOWN        
                                                                        
                 PERFORM 5300-DATE-REFORMAT THRU 5300-EXIT              
                                                                        
                 MOVE WS-DATE-NEW-FORMAT    TO MI-CHG-COLUMN-VALUE-TEXT 
                                                                        
                 PERFORM 6530-LOAD-MNT-TRANS-HIST                       
                                            THRU 6530-EXIT              
                 ADD +1                     TO WS-TRAN-APPL-NO          
              END-IF                                                    
           WHEN 'D'                                                     
C30169**************************************************************            
C30169*                   DELETE                                  **            
C30169**************************************************************            
C30169************   INSERT ACTION TYPE  ******************                     
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE 'AT'                     TO WS-FW-ATTRIB-TYPE-CD     
              MOVE PARM-FW-ACTION-TYPE-CD                               
                                            TO WS-FW-ATTR-VALUE-CD      
              PERFORM 7250-SELECT-ACTION-DESC                           
                                            THRU 7250-EXIT              
              MOVE 'ACTION TYPE'            TO MI-COLUMN-DESC           
              MOVE WS-FW-ATTR-VALUE-DESC    TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE LENGTH OF WS-FW-ATTR-VALUE-DESC                      
                                            TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE '*DELETED*'              TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE +9                       TO MI-CHG-COLUMN-VALUE-LEN  
              PERFORM 6530-LOAD-MNT-TRANS-HIST                          
                                            THRU 6530-EXIT              
              ADD +1                        TO WS-TRAN-APPL-NO          
C30169                                                                  
C30169************   INSERT ACTION DATE  ******************                     
C30169        MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE 'ACTION DATE'            TO MI-COLUMN-DESC           
              MOVE PARM-FIN-WO-ACTION-DT    TO WS-DATE-BREAKDOWN        
              PERFORM 5300-DATE-REFORMAT    THRU 5300-EXIT              
              MOVE WS-DATE-NEW-FORMAT       TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE +10                      TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE '*DELETED*'              TO MI-CHG-COLUMN-VALUE-TEXT 
              MOVE +9                       TO MI-CHG-COLUMN-VALUE-LEN  
              PERFORM 6530-LOAD-MNT-TRANS-HIST                          
                                            THRU 6530-EXIT              
              ADD +1                        TO WS-TRAN-APPL-NO          
C30169                                                                  
C30169************   INSERT WITHDRAW DT ******************                      
C30169        IF WS-IZ-WITHDRAW-DT NOT = SPACES                         
                 MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO          
                 MOVE 'WITHDRAW DATE'       TO MI-COLUMN-DESC           
                 MOVE WS-IZ-WITHDRAW-DT     TO WS-DATE-BREAKDOWN        
                 PERFORM 5300-DATE-REFORMAT                             
                                            THRU 5300-EXIT              
                 MOVE WS-DATE-NEW-FORMAT    TO MI-PRV-COLUMN-VALUE-TEXT 
                 MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN  
                 MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT 
                 MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN  
                 PERFORM 6530-LOAD-MNT-TRANS-HIST                       
                                            THRU 6530-EXIT              
                 ADD +1                     TO WS-TRAN-APPL-NO          
C30169        END-IF                                                    
C30169     END-EVALUATE.                                                
C30169                                                                  
C30169     MOVE WS-TRAN-APPL-NO             TO RS-TRANS-APPL-NO.        
C30169*                                                                         
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *************************************************************             
      * 5210-MOVE-TRAN-DET.                                       *             
      *************************************************************             
                                                                        
       5210-MOVE-TRAN-DET.                                              
      *                                                                         
           MOVE '5210' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.           
      *                                                                         
           MOVE MI-TRANS-HIST-SEQ-NO TO WS-FORMATTED-TIME-STMP          
                                                                        
           MOVE 1                    TO  WS-TRAN-APPL-NO.               
                                                                        
           IF PARM-NON-UTIL-ACTION = 'I'                                
              MOVE WS-TRAN-APPL-NO   TO MI-TRAN-APPL-NO                 
      *                                                                         
              MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN      
                                           MI-CHG-COLUMN-VALUE-LEN      
      *                                                                         
              MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT     
              MOVE SPACES               TO WS-DATE-BREAKDOWN            
              MOVE WS-CURRENT-DATE      TO WS-DATE-BREAKDOWN            
                                                                        
              PERFORM 5300-DATE-REFORMAT             THRU 5300-EXIT     
                                                                        
              MOVE WS-DATE-NEW-FORMAT   TO MI-CHG-COLUMN-VALUE-TEXT     
                                                                        
              MOVE 'FINAL BILL DATE'    TO MI-COLUMN-DESC               
      *                                                                         
              PERFORM 6530-LOAD-MNT-TRANS-HIST       THRU 6530-EXIT     
              ADD 1                     TO WS-TRAN-APPL-NO              
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO              
      *                                                                         
              MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN      
                                           MI-CHG-COLUMN-VALUE-LEN      
      *                                                                         
              MOVE SPACES               TO WS-DATE-BREAKDOWN            
              MOVE WS-CURRENT-DATE      TO WS-DATE-BREAKDOWN            
                                                                        
              PERFORM 5300-DATE-REFORMAT             THRU 5300-EXIT     
                                                                        
              MOVE WS-DATE-NEW-FORMAT   TO MI-PRV-COLUMN-VALUE-TEXT     
              MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT     
              MOVE 'FINAL BILL DATE'    TO MI-COLUMN-DESC               
      *                                                                         
              PERFORM 6530-LOAD-MNT-TRANS-HIST       THRU 6530-EXIT     
              ADD 1                     TO WS-TRAN-APPL-NO              
           END-IF.                                                      
                                                                        
       5210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5300-DATE-REFORMAT.                                              
                                                                        
           MOVE SPACES       TO WS-DATE-NEW-MM.                         
           MOVE SPACES       TO WS-DATE-NEW-DD.                         
           MOVE SPACES       TO WS-DATE-NEW-YYYY.                       
           MOVE WS-DATE-MM   TO WS-DATE-NEW-MM.                         
           MOVE WS-DATE-DD   TO WS-DATE-NEW-DD.                         
           MOVE WS-DATE-YYYY TO WS-DATE-NEW-YYYY.                       
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                                    
      ***************************************************************           
      * 7100-GET-TIMESTAMP                                          *           
      ***************************************************************           
      *                                                                         
       7100-GET-TIMESTAMP.                                              
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-TIME-STAMP              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-TIME-STAMP      = CURRENT TIMESTAMP                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL           
               MOVE SPACES              TO ABEND-TABLES                 
               MOVE SPACES              TO ABEND-SQL-PREDICATES         
CBSI           MOVE '7100'              TO ACTIVE-PARAGRAPH             
REARCH         MOVE PROGRAM-NAME        TO ABEND-PROGRAM                
               MOVE 'SET'               TO ABEND-FUNCTION               
CBSI           MOVE 'ACCOUNT_NO'    TO TABLE-ELEMENT-1                  
CBSI           MOVE PARM-ACCOUNT-NO TO HOSTVAR-ELEMENT-1                
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **      OPEN GUARANTOR_CRSR                                   **          
      ****************************************************************          
      *                                                                         
PCR408 7200-OPEN-GUARANTOR-CRSR.                                        
      *                                                                         
           EXEC SQL                                                     
               OPEN GUARANTOR_CRSR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
           ELSE                                                         
               MOVE SPACES            TO ABEND-TABLES                   
               MOVE SPACES            TO ABEND-SQL-PREDICATES           
CBSI           MOVE '7200'            TO ACTIVE-PARAGRAPH               
REARCH         MOVE PROGRAM-NAME      TO ABEND-PROGRAM                  
               MOVE 'OPEN'            TO ABEND-FUNCTION                 
CBSI           MOVE 'CSS_GUARANTOR'   TO TABLE-1                        
CBSI           MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1                
CBSI           MOVE  GU-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1              
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **      FETCH GUARANTOR_CRSR                                  **          
      ****************************************************************          
      *                                                                         
PCR408 7210-FETCH-GUARANTOR-CRSR.                                       
      *                                                                         
           EXEC SQL                                                     
             FETCH GUARANTOR_CRSR                                       
               INTO                                                     
                 :GU-GUARNTR-ACCT-NO                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
                 NEXT SENTENCE                                          
           ELSE                                                         
               MOVE SPACES            TO ABEND-TABLES                   
               MOVE SPACES            TO ABEND-SQL-PREDICATES           
CBSI           MOVE '7210'            TO ACTIVE-PARAGRAPH               
REARCH         MOVE PROGRAM-NAME      TO ABEND-PROGRAM                  
               MOVE 'FETCH'           TO ABEND-FUNCTION                 
CBSI           MOVE 'CSS_GUARANTOR'   TO TABLE-1                        
CBSI           MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1                
CBSI           MOVE GU-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1              
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      **      CLOSE GUARANTOR_CRSR                                  **          
      ****************************************************************          
      *                                                                         
PCR408 7220-CLOSE-GUARANTOR-CRSR.                                       
      *                                                                         
           EXEC SQL                                                     
               CLOSE GUARANTOR_CRSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
           ELSE                                                         
               MOVE SPACES            TO ABEND-TABLES                   
               MOVE SPACES            TO ABEND-SQL-PREDICATES           
CBSI           MOVE '7220'            TO ACTIVE-PARAGRAPH               
REARCH         MOVE PROGRAM-NAME      TO ABEND-PROGRAM                  
               MOVE 'CLOSE'           TO ABEND-FUNCTION                 
CBSI           MOVE 'CSS_GUARANTOR'   TO TABLE-1                        
CBSI           MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1                
CBSI           MOVE GU-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1              
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       7220-EXIT.                                                       
           EXIT.                                                        
C30169*                                                                         
C30169****************************************************************          
C30169*  7250-SELECT-ACTION-DESC.                                    *          
C30169****************************************************************          
C30169*                                                                         
C30169 7250-SELECT-ACTION-DESC.                                         
C30169*                                                                         
           MOVE '7250'                      TO ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
               SELECT                                                   
                   FW_ATTR_VALUE_DESC                                   
               INTO                                                     
                   :WS-FW-ATTR-VALUE-DESC                               
               FROM                                                     
                   CSS_FW_ATTRIB_DESC                                   
               WHERE                                                    
                   FW_ATTRIB_TYPE_CD   = :WS-FW-ATTRIB-TYPE-CD          
               AND FW_ATTR_VALUE_CD    = :WS-FW-ATTR-VALUE-CD           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_FW_ATTRIB_DESC'     TO TABLE-1                  
              MOVE 'FW_ATTRIB_TYPE_CD'      TO TABLE-ELEMENT-1          
              MOVE 'FW_ATTR_VALUE_CD'       TO TABLE-ELEMENT-2          
              MOVE WS-FW-ATTRIB-TYPE-CD     TO HOSTVAR-ELEMENT-1        
              MOVE WS-FW-ATTR-VALUE-CD      TO HOSTVAR-ELEMENT-2        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
C30169 7250-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                         
C30169****************************************************************          
C30169*  7300-SELECT-ACTION-DATES.                                   *          
C30169****************************************************************          
C30169*                                                                         
C30169 7300-SELECT-ACTION-DATES.                                        
C30169*                                                                         
           MOVE '7300'                 TO ACTIVE-PARAGRAPH              
                                                                        
           EXEC SQL                                                     
               SELECT                                                   
                   KD.FW_ACTION_DT                                      
                  ,IZ.WITHDRAW_DT                                       
               INTO                                                     
                   :KD-FW-ACTION-DT                                     
                  ,:IZ-WITHDRAW-DT :WS-WITHDRAW-DT-NULL                  
               FROM                                                     
                   CSS_FIN_WO_ACTION  KD                                
               LEFT OUTER JOIN                                          
                   CSS_FIN_WO_COLLECT IZ                                
               ON                                                       
                   KD.ACCOUNT_NO        = IZ.ACCOUNT_NO                 
               AND KD.FW_ACTION_TYPE_CD = IZ.FW_ACTION_TYPE_CD          
               AND KD.FW_SEQ_NO         = IZ.FW_COLL_SEQ_NO             
               WHERE                                                    
                   KD.ACCOUNT_NO        = :KD-ACCOUNT-NO                
               AND KD.FW_ACTION_TYPE_CD = :KD-FW-ACTION-TYPE-CD         
               AND KD.FW_SEQ_NO         = :KD-FW-SEQ-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE IZ-WITHDRAW-DT        TO WS-IZ-WITHDRAW-DT           
              MOVE KD-FW-ACTION-DT       TO WS-KD-ACTION-DT             
              IF WS-WITHDRAW-DT-NULL < 0                                
                 MOVE SPACES             TO WS-IZ-WITHDRAW-DT           
                 MOVE ZERO               TO WS-WITHDRAW-DT-NULL         
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_FIN_WO_ACTION'   TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'ACTION_TYPE_CD'      TO TABLE-ELEMENT-2             
              MOVE 'COLL_SEQ_NO'         TO TABLE-ELEMENT-3             
              MOVE KD-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE KD-FW-ACTION-TYPE-CD  TO HOSTVAR-ELEMENT-2           
              MOVE KD-FW-SEQ-NO          TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
C30169*                                                                         
C30169 7300-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                         
C30169****************************************************************          
C30169*  7400-SELECT-REG-GROUP.                                      *          
C30169****************************************************************          
C30169*                                                                         
C30169 7400-SELECT-REG-GROUP.                                           
C30169*                                                                         
           MOVE '7400'                      TO ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
               SELECT                                                   
                   REG_GROUP_CD                                         
               INTO                                                     
                   :LR-REG-GROUP-CD                                     
               FROM                                                     
                   CSS_REG_PROFILE                                      
               WHERE                                                    
                   ACCOUNT_NO = :LR-ACCOUNT-NO                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE SPACES                TO LR-REG-GROUP-CD          
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_REG_PROFILE'        TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE LR-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C30169     END-IF.                                                      
C30169*                                                                         
C30169 7400-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                         
C30169****************************************************************          
C30169*  7420-SELECT-AGNCY-NAME.                                     *          
C30169****************************************************************          
C30169*                                                                         
C30169 7420-SELECT-AGNCY-NAME.                                          
C30169*                                                                         
           MOVE '7420'                      TO ACTIVE-PARAGRAPH         
                                                                        
           EXEC SQL                                                     
                SELECT TOP(1) COLLEC_AGNCY_NAME                                 
                INTO                                                    
                     :Q7-COLLEC-AGNCY-NAME                              
                FROM                                                    
                     CSS_COLLECT_AGENCY WITH(READUNCOMMITTED)                   
                WHERE                                                   
                     CODE_COLLEC_AGNCY = :Q7-CODE-COLLEC-AGNCY          
                                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT                                                          
MFA-TR*              COLLEC_AGNCY_NAME                                          
MFA-TR*         INTO                                                            
MFA-TR*              :Q7-COLLEC-AGNCY-NAME                                      
MFA-TR*         FROM                                                            
MFA-TR*              CSS_COLLECT_AGENCY                                         
MFA-TR*         WHERE                                                           
MFA-TR*              CODE_COLLEC_AGNCY = :Q7-CODE-COLLEC-AGNCY                  
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'SELECT'                 TO ABEND-FUNCTION           
              MOVE 'CSS_COLLECT_AGENCY'     TO TABLE-1                  
              MOVE 'CODE_COLLEC_AGNCY'      TO TABLE-ELEMENT-1          
              MOVE Q7-CODE-COLLEC-AGNCY     TO HOSTVAR-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C30169     END-IF.                                                      
C30169*                                                                         
C30169 7420-EXIT.                                                       
C30169     EXIT.                                                        
      *                                                                         
      ***************************************************************           
      * DELETE ENTRY FROM OFF CYCLE TABLE                           *           
      ***************************************************************           
      *                                                                         
PCR408 8300-DELETE-ENTRY-OFF-CYCLE.                                     
      *                                                                         
           MOVE '8300' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
             DELETE FROM CSS_OFF_CYCL_ACCT                              
              WHERE ACCOUNT_NO          = :OC-ACCOUNT-NO                
                AND CODE_BILL_OFF_CYCL  = :OC-CODE-BILL-OFF-CYCL        
                AND ITEM_ID             = 0                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE.                              
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
           ELSE                                                         
               MOVE SPACES                TO ABEND-TABLES               
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
REARCH         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'DELETE'              TO ABEND-FUNCTION             
               MOVE 'CSS_OFF_CYCL_ACCT'   TO TABLE-1                    
CBSI           MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
CBSI           MOVE 'CODE_BILL_OFF_CYCL'  TO TABLE-ELEMENT-2            
               MOVE OC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               MOVE OC-CODE-BILL-OFF-CYCL TO HOSTVAR-ELEMENT-2          
      *                                                                         
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 8400 INSERT ENTRY INTO OFF CYCLE TABLE                      *           
      ***************************************************************           
      *                                                                         
NONUTL 8400-INSERT-ENTRY-OFF-CYCLE.                                     
      *                                                                         
           MOVE '8400' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
             INSERT INTO CSS_OFF_CYCL_ACCT                              
                    (ACCOUNT_NO,                                        
                     CODE_BILL_OFF_CYCL,                                
                     CUSTOMER_NO,                                       
                     LAST_UPDATE_TS,                                    
                     ITEM_ID,                                           
                     CREDIT_LETTER_IND)                                 
             VALUES  (:OC-ACCOUNT-NO,                                   
                      :OC-CODE-BILL-OFF-CYCL,                           
                      :OC-CUSTOMER-NO,                                  
                      CIS.CURRENT$TIMESTAMP(),                                
                      0,                                                
                      ' ')                                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_OFF_CYCL_ACCT                                      
MFA-TR*             (ACCOUNT_NO,                                                
MFA-TR*              CODE_BILL_OFF_CYCL,                                        
MFA-TR*              CUSTOMER_NO,                                               
MFA-TR*              LAST_UPDATE_TS,                                            
MFA-TR*              ITEM_ID,                                                   
MFA-TR*              CREDIT_LETTER_IND)                                         
MFA-TR*      VALUES  (:OC-ACCOUNT-NO,                                           
MFA-TR*               :OC-CODE-BILL-OFF-CYCL,                                   
MFA-TR*               :OC-CUSTOMER-NO,                                          
MFA-TR*               CURRENT TIMESTAMP,                                        
MFA-TR*               0,                                                        
MFA-TR*               ' ')                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE.                              
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
           ELSE                                                         
               MOVE SPACES                TO ABEND-TABLES               
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
REARCH         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'INSERT'              TO ABEND-FUNCTION             
               MOVE 'CSS_OFF_CYCL_ACCT'   TO TABLE-1                    
CBSI           MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
CBSI           MOVE 'CODE_BILL_OFF_CYCL'  TO TABLE-ELEMENT-2            
CBSI           MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-3            
               MOVE OC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               MOVE OC-CODE-BILL-OFF-CYCL TO HOSTVAR-ELEMENT-2          
               MOVE OC-CUSTOMER-NO        TO HOSTVAR-ELEMENT-3          
      *                                                                         
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
HPCCDM*    EJECT                                                                
                                                                        
T21429*                                                                         
T21429******************************************************************        
T21429* UPDATES DATE-UTIL-SVC-END FOR NON-UTIL-ACCTS                   *        
T21429******************************************************************        
T21429 8500-UPDATE-PREM-HIST.                                           
T21429*                                                                         
T21429     MOVE '8500' TO ACTIVE-PARAGRAPH.                             
T21429*                                                                         
T21429     EXEC SQL                                                     
T21429        UPDATE CSS_CUST_PREM_HIST                                 
T21429           SET DATE_UTIL_SVC_END = IIF(TRY_CONVERT(DATE, 
                                                  :CH-DATE-UTIL-SVC-END
              ) IS NULL OR (PATINDEX('%.%', :CH-DATE-UTIL-SVC-END
              ) <> 0) OR (LEN(:CH-DATE-UTIL-SVC-END
              ) <> 10), CIS.CHAR2DATE(:CH-DATE-UTIL-SVC-END
              ), CONVERT(DATE, :CH-DATE-UTIL-SVC-END) )          
T21429         WHERE ACCOUNT_NO        = :CH-ACCOUNT-NO                 
T21429     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CUST_PREM_HIST                                         
MFA-TR*          SET DATE_UTIL_SVC_END = :CH-DATE-UTIL-SVC-END                  
MFA-TR*        WHERE ACCOUNT_NO        = :CH-ACCOUNT-NO                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21429*                                                                         
T21429     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T21429     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
T21429         NEXT SENTENCE                                            
T21429     ELSE                                                         
T21429         MOVE SPACES            TO ABEND-TABLES                   
T21429         MOVE SPACES            TO ABEND-SQL-PREDICATES           
REARCH         MOVE PROGRAM-NAME      TO ABEND-PROGRAM                  
T21429         MOVE 'UPDATE'          TO ABEND-FUNCTION                 
T21429         MOVE 'CSS_CUST_PREM_HIST'                                
T21429                                TO TABLE-1                        
T21429         MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1                
T21429         MOVE 'DATE_UTIL_SVC_END'                                 
T21429                                TO TABLE-ELEMENT-2                
T21429         MOVE WS-ACCOUNT-NO-NUM TO HOSTVAR-ELEMENT-1              
T21429         MOVE CH-DATE-UTIL-SVC-END                                
T21429                                TO HOSTVAR-ELEMENT-2              
T21429         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
T21429         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
T21429     END-IF.                                                      
T21429*                                                                         
T21429 8500-EXIT.                                                       
T21429     EXIT.                                                        
T21429*                                                                         
T21429******************************************************************        
T21429* UPDATES DATE-UTIL-SVC-END TO NULL WHEN A NON-UTIL ACCT FINAL   *        
T21429* BILL ACTION IS CANCELED                                        *        
T21429******************************************************************        
T21429 8510-UPDATE-PREM-HIST.                                           
T21429*                                                                         
T21429     MOVE '8510' TO ACTIVE-PARAGRAPH.                             
T21429*                                                                         
T21429     EXEC SQL                                                     
T21429        UPDATE CSS_CUST_PREM_HIST                                 
T21429           SET DATE_UTIL_SVC_END = NULL                           
T21429         WHERE ACCOUNT_NO        = :CH-ACCOUNT-NO                 
T21429     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21429*                                                                         
T21429     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T21429     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
T21429         NEXT SENTENCE                                            
T21429     ELSE                                                         
T21429         MOVE SPACES            TO ABEND-TABLES                   
T21429         MOVE SPACES            TO ABEND-SQL-PREDICATES           
REARCH         MOVE PROGRAM-NAME      TO ABEND-PROGRAM                  
T21429         MOVE 'UPDATE'          TO ABEND-FUNCTION                 
T21429         MOVE 'CSS_CUST_PREM_HIST'                                
T21429                                TO TABLE-1                        
T21429         MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1                
T21429         MOVE WS-ACCOUNT-NO-NUM TO HOSTVAR-ELEMENT-1              
T21429         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
T21429         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
T21429     END-IF.                                                      
T21429*                                                                         
T21429 8510-EXIT.                                                       
T21429     EXIT.                                                        
T21429*                                                                         
C30169***************************************************************           
C30169* UPDATE UTILITY RECORD IN CSS_FIN_WO_ACTION                  *           
C30169***************************************************************           
C30169 8600-UPDATE-FIN-WO-ACTION.                                       
C30169*                                                                         
           MOVE '8600'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              UPDATE                                                    
                  CSS_FIN_WO_ACTION                                     
              SET                                                       
                  FW_ACTION_DT      = IIF(TRY_CONVERT(DATE, 
                                                       :KD-FW-ACTION-DT
              ) IS NULL OR (PATINDEX('%.%', :KD-FW-ACTION-DT
              ) <> 0) OR (LEN(:KD-FW-ACTION-DT) <> 10), CIS.CHAR2DATE(
                                                       :KD-FW-ACTION-DT
              ), CONVERT(DATE, :KD-FW-ACTION-DT) )                  
              WHERE                                                     
                  ACCOUNT_NO        = :KD-ACCOUNT-NO                    
              AND FW_ACTION_TYPE_CD = :KD-FW-ACTION-TYPE-CD             
              AND FW_SEQ_NO         = :KD-FW-SEQ-NO                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE                                                            
MFA-TR*           CSS_FIN_WO_ACTION                                             
MFA-TR*       SET                                                               
MFA-TR*           FW_ACTION_DT      = :KD-FW-ACTION-DT                          
MFA-TR*       WHERE                                                             
MFA-TR*           ACCOUNT_NO        = :KD-ACCOUNT-NO                            
MFA-TR*       AND FW_ACTION_TYPE_CD = :KD-FW-ACTION-TYPE-CD                     
MFA-TR*       AND FW_SEQ_NO         = :KD-FW-SEQ-NO                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               RS-RETURN-CODE.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES                   TO ABEND-TABLES             
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE 'CSS_FIN_WO_ACTION'      TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'FW_ACTION_DT'           TO TABLE-ELEMENT-2          
              MOVE 'FW_SEQ_NO'              TO TABLE-ELEMENT-2          
              MOVE KD-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE KD-FW-ACTION-TYPE-CD     TO HOSTVAR-ELEMENT-2        
              MOVE KD-FW-SEQ-NO             TO HOSTVAR-ELEMENT-3        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
C30169 8600-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                         
C30169***************************************************************           
C30169* UPDATE UTILITY RECORD IN CSS_FIN_WO_COLLECT                 *           
C30169***************************************************************           
C30169 8610-UPDATE-FIN-WO-COLLECT.                                      
C30169*                                                                         
           MOVE '8610'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              UPDATE                                                    
                  CSS_FIN_WO_COLLECT                                    
              SET                                                       
                  WITHDRAW_DT       = IIF(TRY_CONVERT(DATE, 
                                                        :IZ-WITHDRAW-DT
              ) IS NULL OR (PATINDEX('%.%', :IZ-WITHDRAW-DT
              ) <> 0) OR (LEN(:IZ-WITHDRAW-DT) <> 10), CIS.CHAR2DATE(
                                                        :IZ-WITHDRAW-DT
              ), CONVERT(DATE, :IZ-WITHDRAW-DT) )                   
              WHERE                                                     
                  ACCOUNT_NO        = :IZ-ACCOUNT-NO                    
              AND FW_ACTION_TYPE_CD = :IZ-FW-ACTION-TYPE-CD             
              AND FW_COLL_SEQ_NO    = :IZ-FW-COLL-SEQ-NO                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE                                                            
MFA-TR*           CSS_FIN_WO_COLLECT                                            
MFA-TR*       SET                                                               
MFA-TR*           WITHDRAW_DT       = :IZ-WITHDRAW-DT                           
MFA-TR*       WHERE                                                             
MFA-TR*           ACCOUNT_NO        = :IZ-ACCOUNT-NO                            
MFA-TR*       AND FW_ACTION_TYPE_CD = :IZ-FW-ACTION-TYPE-CD                     
MFA-TR*       AND FW_COLL_SEQ_NO    = :IZ-FW-COLL-SEQ-NO                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               RS-RETURN-CODE.          
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES                   TO ABEND-TABLES             
              MOVE SPACES                   TO ABEND-SQL-PREDICATES     
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE 'UPDATE'                 TO ABEND-FUNCTION           
              MOVE 'CSS_FIN_WO_COLLECT'     TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE 'FW_ACTION_TYPE_CD'      TO TABLE-ELEMENT-2          
              MOVE 'FW_COLL_SEQ_NO'         TO TABLE-ELEMENT-2          
              MOVE IZ-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE IZ-FW-ACTION-TYPE-CD     TO HOSTVAR-ELEMENT-2        
              MOVE IZ-FW-COLL-SEQ-NO        TO HOSTVAR-ELEMENT-3        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
C30169 8610-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                         
C30169****************************************************************          
C30169* 8620-INSERT-FIN-WO-ACTION                                    *          
C30169* INSERT ACTION INTO CSS_FIN_WO_ACTION                         *          
C30169****************************************************************          
C30169*                                                                         
C30169 8620-INSERT-FIN-WO-ACTION.                                       
C30169*                                                                         
           MOVE '8620'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_FIN_WO_ACTION                             
              (                                                         
                   ACCOUNT_NO                                           
                  ,FW_SEQ_NO                                            
                  ,FW_ACTION_TYPE_CD                                    
                  ,FW_ACTION_DT                                         
                  ,FW_ACTION_AM                                         
                  ,FW_MANUAL_FL                                         
                  ,FW_ACTION_COMMENTS                                   
P00599            ,FW_BUS_PROCESS_CD                                    
              )                                                         
              VALUES                                                    
              (                                                         
                   :KD-ACCOUNT-NO                                       
                  ,:KD-FW-SEQ-NO                                        
                  ,:KD-FW-ACTION-TYPE-CD                                
                  ,IIF(TRY_CONVERT(DATE, :KD-FW-ACTION-DT
              ) IS NULL OR (PATINDEX('%.%', :KD-FW-ACTION-DT
              ) <> 0) OR (LEN(:KD-FW-ACTION-DT) <> 10), CIS.CHAR2DATE(
                                                       :KD-FW-ACTION-DT
              ), CONVERT(DATE, :KD-FW-ACTION-DT) )                             
                  ,0.0                                                  
                  ,'Y'                                                  
                  ,:KD-FW-ACTION-COMMENTS                               
P00599            ,:KD-FW-BUS-PROCESS-CD                                
              )                                                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_FIN_WO_ACTION                                     
MFA-TR*       (                                                                 
MFA-TR*            ACCOUNT_NO                                                   
MFA-TR*           ,FW_SEQ_NO                                                    
MFA-TR*           ,FW_ACTION_TYPE_CD                                            
MFA-TR*           ,FW_ACTION_DT                                                 
MFA-TR*           ,FW_ACTION_AM                                                 
MFA-TR*           ,FW_MANUAL_FL                                                 
MFA-TR*           ,FW_ACTION_COMMENTS                                           
MFA-TR*           ,FW_BUS_PROCESS_CD                                            
MFA-TR*       )                                                                 
MFA-TR*       VALUES                                                            
MFA-TR*       (                                                                 
MFA-TR*            :KD-ACCOUNT-NO                                               
MFA-TR*           ,:KD-FW-SEQ-NO                                                
MFA-TR*           ,:KD-FW-ACTION-TYPE-CD                                        
MFA-TR*           ,:KD-FW-ACTION-DT                                             
MFA-TR*           ,0.0                                                          
MFA-TR*           ,'Y'                                                          
MFA-TR*           ,:KD-FW-ACTION-COMMENTS                                       
MFA-TR*           ,:KD-FW-BUS-PROCESS-CD                                        
MFA-TR*       )                                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               RS-RETURN-CODE.          
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
           ELSE                                                         
               MOVE SPACES                  TO ABEND-TABLES             
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE 'INSERT'                TO ABEND-FUNCTION           
               MOVE 'CSS_FIN_WO_ACTION'     TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'FW_SEQ_NO'             TO TABLE-ELEMENT-2          
               MOVE 'FW_ACTION_TYPE_CD'     TO TABLE-ELEMENT-3          
               MOVE 'FW_ACTION_DT'          TO TABLE-ELEMENT-4          
               MOVE KD-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE KD-FW-SEQ-NO            TO HOSTVAR-ELEMENT-2        
               MOVE KD-FW-ACTION-TYPE-CD    TO HOSTVAR-ELEMENT-3        
               MOVE KD-FW-ACTION-DT         TO HOSTVAR-ELEMENT-4        
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
C30169 8620-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                         
C30169****************************************************************          
C30169* 8630-INSERT-FIN-WO-COLLECT                                   *          
C30169* INSERT ACTION INTO CSS_FIN_WO_COLLECT                        *          
C30169****************************************************************          
C30169*                                                                         
C30169 8630-INSERT-FIN-WO-COLLECT.                                      
C30169*                                                                         
           MOVE '8630'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_FIN_WO_COLLECT                            
              (                                                         
                   ACCOUNT_NO                                           
                  ,FW_ACTION_TYPE_CD                                    
                  ,FW_COLL_SEQ_NO                                       
                  ,CUSTOMER_NO                                          
                  ,CODE_COLLEC_AGNCY                                    
                  ,COLL_AGY_SUB_CD                                      
                  ,COMPANY_NO                                           
                  ,REG_GROUP_CD                                         
                  ,WITHDRAW_AM                                          
                  ,WITHDRAW_DT                                          
                  ,WITHDRAW_REASON_CD                                   
              )                                                         
              VALUES                                                    
              (                                                         
                   :IZ-ACCOUNT-NO                                       
                  ,:IZ-FW-ACTION-TYPE-CD                                
                  ,:IZ-FW-COLL-SEQ-NO                                   
                  ,:IZ-CUSTOMER-NO                                      
                  ,:IZ-CODE-COLLEC-AGNCY                                
                  ,:IZ-COLL-AGY-SUB-CD                                  
                  ,:IZ-COMPANY-NO                                       
                  ,:IZ-REG-GROUP-CD                                     
                  ,0.0                                                  
                  ,NULL                                                 
                  ,' '                                                  
              )                                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               RS-RETURN-CODE.          
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
           ELSE                                                         
               MOVE SPACES                  TO ABEND-TABLES             
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE 'INSERT'                TO ABEND-FUNCTION           
               MOVE 'CSS_FIN_WO_ACTION'     TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'FW_ACTION_TYPE_CD'     TO TABLE-ELEMENT-2          
               MOVE 'FW_COLL_SEQ_NO'        TO TABLE-ELEMENT-3          
               MOVE 'WITHDRAW_DT'           TO TABLE-ELEMENT-4          
               MOVE IZ-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE IZ-FW-ACTION-TYPE-CD    TO HOSTVAR-ELEMENT-2        
               MOVE IZ-FW-COLL-SEQ-NO       TO HOSTVAR-ELEMENT-3        
               MOVE IZ-WITHDRAW-DT          TO HOSTVAR-ELEMENT-4        
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
C30169 8630-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                         
C30169****************************************************************          
C30169* 8640-DELETE-ACTION                                           *          
C30169* DELETE ACTION FROM CSS_FIN_WO_ACTION                         *          
C30169* ALSO DELET FROM CSS_FIN_WO_COLLECT                           *          
C30169****************************************************************          
C30169*                                                                         
       8640-DELETE-ACTION.                                              
      *                                                                         
           MOVE '8640'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           EXEC SQL                                                     
              DELETE FROM                                               
                  CSS_FIN_WO_ACTION                                     
              WHERE                                                     
                  ACCOUNT_NO        = :KD-ACCOUNT-NO                    
              AND FW_ACTION_TYPE_CD = :KD-FW-ACTION-TYPE-CD             
              AND FW_SEQ_NO         = :KD-FW-SEQ-NO                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               RS-RETURN-CODE.          
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
           ELSE                                                         
               MOVE SPACES                  TO ABEND-TABLES             
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE 'DELETE'                TO ABEND-FUNCTION           
               MOVE 'CSS_FIN_WO_ACTION'     TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'FW_ACTION_TYPE-CD'     TO TABLE-ELEMENT-2          
               MOVE 'FW_SEQ_NO'             TO TABLE-ELEMENT-3          
               MOVE KD-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE KD-FW-ACTION-TYPE-CD    TO HOSTVAR-ELEMENT-2        
               MOVE KD-FW-SEQ-NO            TO HOSTVAR-ELEMENT-3        
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
C30169     END-IF.                                                      
C30169                                                                  
C30169 8640-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                         
                                                                        
      ****************************************************************          
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                    *          
      ****************************************************************          
              EXEC SQL                                                          
                 INCLUDE CPD0023C                                               
              END-EXEC.                                                         
                                                                        
              EXEC SQL                                                          
REARCH           INCLUDE CPDSP300                                               
              END-EXEC.                                                         
                                                                        
      ****************************************************************          
      *       END PROGRAM COPYLIB *                                             
      ****************************************************************          
REARCH        EXEC SQL                                                          
REARCH          INCLUDE CPD00321                                                
REARCH        END-EXEC.                                                         
REARCH*                                                                         
