       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02227.                                         
COB303 DATE-WRITTEN.  OCTOBER 20, 1994.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
      *                                                                *00110000
      *  TRANID:        S227                                           *00120001
      *  PROGRAM:       S227                                           *00130001
      *  CALLING SP:    PA_CORRAGINGUPD                                *00140002
      *                                                                *00150000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *  THIS PROCEDURE UPDATES SPECEFIC ROW(S) OF CSS_AR_CNTL         *00190002
      *  TABLE FOR AN ACCOUNT AND RECEIVABLE TYPE.                     *00200002
      ******************************************************************00210000
      *                                                                *00220000
      *                     PROGRAM MODIFICATION LOG                   *00230000
      *                                                                *00240000
      *    DATE    INITIALS   COMMENTS                                 *00250000
      *  --------  --------   ---------------------------------------  *00260000
      *  10/20/94    RC       PROCEDURE ORIGINALLY CODED.              *00270002
      *    0395      CIF      MODIFICATION MADE FOR JOURNALLING        *00250000
      *    0396      CIF      MODIFICATION MADE FOR FCS/CIS INTERFACE. *00250000
      *  07/15/97    PP       PCR404: CHANGES. ADDING FORCED COMMENT.  *00270002
      *  08/01/97    PP       CHANGE IN ITEM-ID SIZE.                  *00270002
      *  11/26/97    MKN      TPR 13605 ALLOW DPP AGING                         
CBSI  *  11/16/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL ABEND  *        
CBSI  *              INDIA    PARAMETERS                               *        
T21071*  11/03/99    CBSI     UPDATE CSS_ACCOUNT WITH LAST UPDATE TS   *        
T21071*              INDIA                                             *        
T21205*  12/06/99    CBSI     CALL SUB ROUTINE SCSCA182 AND CHECK IF   *        
T21205*              MADRAS   THE PARM-AT-LAST-UPDATE-TS AND THE ONE   *        
T21205*                       OBTAINED FROM THE SUB ROUTINE ARE SAME,  *        
T21205*                       IF THEY ARE SAME UPDATES AR_CNTL ELSE    *        
T21205*                       SENDS ERROR MSG TO THE PANEL             *        
      *  04/09/01    CHANELLE MCR310.  CSS_GL_ACCT_NO CHANGES.         *        
      *                                                                *00310000
REARCH*  10/20/05    CVNS     RPC TO COBOL SP CONVERSION               *        
REARCH*              CHENNAI                                           *        
234310*  01/16/06    SK88120  INCREASED PARM-RECV-DESC FROM 20 TO 25.  *        
234310*                       (FIX FOR MI # 234310 AND 234900)                  
247359*  03/02/06    SK88120  CHANGED PYMT-PRIOROTY-LEVEL FIELD LENGTH *        
247359*                       (FIX FOR MI # 247359)                             
C36956*  11/13/08    RC41079  CHANGED EPP TO BBP.                      *        
A00956*  03/26/09    CVNS      REPLACE CPD00006 WITH CPD0006A.         *        
A00956*              CHENNAI                                           *        
P00453*  05/24/11    SP95538   PRE-PAY-PLAN CHANGES.                   *        
      ******************************************************************00320000
      ******************************************************************00330000
      *                                                                *00340000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00350000
      *                                                                *00360000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00370000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00380000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00390000
      *  3000 - 4999  NOT USED                                         *00400000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00410000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00420000
      *  7000 - 7999  INPUT MODULES                                    *00430000
      *  8000 - 8999  OUTPUT MODULES                                   *00440000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00450000
      *                                                                *00460000
      ******************************************************************00470000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02227'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02227 STARTS HERE'.                  
                                                                        
      ******************************************************************00560000
      *    DB2 INCLUDES                                                *00570000
      ******************************************************************00580000
                                                                        
           EXEC SQL                                                     00600000
              INCLUDE SQLCA                                             00610000
           END-EXEC.                                                    00620000
                                                                        
                                                                        
           EXEC SQL                                                     00680000
              INCLUDE TBBTJRNL                                          00730000
           END-EXEC.                                                    00740000
                                                                        
           EXEC SQL                                                     00760000
              INCLUDE TBCDJRNL                                          00770000
           END-EXEC.                                                    00780000
                                                                        
           EXEC SQL                                                     00800000
              INCLUDE TBMSJRNL                                          00810000
           END-EXEC.                                                    00820000
                                                                        
           EXEC SQL                                                     00840000
              INCLUDE TBACCT                                            00850000
           END-EXEC.                                                    00860000
                                                                        
           EXEC SQL                                                     00840000
              INCLUDE TBARLOCK                                          00850000
           END-EXEC.                                                    00860000
                                                                        
           EXEC SQL                                                     00840000
              INCLUDE TBARHIST                                          00850000
           END-EXEC.                                                    00860000
                                                                        
           EXEC SQL                                                     00840000
              INCLUDE TBARHDT                                           00850000
           END-EXEC.                                                    00860000
                                                                        
           EXEC SQL                                                     00840000
              INCLUDE TBARCNTL                                          00850000
           END-EXEC.                                                    00860000
                                                                        
           EXEC SQL                                                     00840000
              INCLUDE TBCUST                                            00850000
           END-EXEC.                                                    00860000
                                                                        
           EXEC SQL                                                     00880000
              INCLUDE TBBJCNTL                                          00890000
           END-EXEC.                                                    00900000
                                                                        
           EXEC SQL                                                     00920000
              INCLUDE TBCDCNTL                                          00930000
           END-EXEC.                                                    00940000
                                                                        
           EXEC SQL                                                     00960000
              INCLUDE TBMODEL                                           00970000
           END-EXEC.                                                    00980000
                                                                        
           EXEC SQL                                                     01000000
              INCLUDE TBRSAREA                                          01010000
           END-EXEC.                                                    01020000
                                                                        
           EXEC SQL                                                     01040000
              INCLUDE TBPREM                                            01050000
           END-EXEC.                                                    01060000
                                                                        
           EXEC SQL                                                             
              INCLUDE TBGLATNO                                          01150054
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCNTRCT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************01080000
      *    COBOL WORKING STORAGE COPY BOOKS                            *01090000
      ******************************************************************01100000
                                                                        
REARCH*COPY SYGWCOB.                                                    01120000
REARCH*COPY SYDBCOB.                                                    01130000
REARCH*COPY CWS00010.                                                   01150000
       COPY CWS00303.                                                   01170000
       COPY CJF00113.                                                           
                                                                        
           EXEC SQL                                                     01200000
A00956        INCLUDE CWS0013B                                          01210000
           END-EXEC.                                                    01220000
                                                                        
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CWSX0010                                                 
REARCH     END-EXEC.                                                            
REARCH*                                                                         
      ******************************************************************01240000
      *    WORK AREAS                                                  *01250000
      ******************************************************************01260000
                                                                        
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME             PIC X(08) VALUE 'CSR02227'.     
REARCH     05  EIBTRNID                 PIC X(04) VALUE 'S227'.         
           05  WS-DATE-ORIG-PYMT-IND    PIC S9(04) COMP VALUE +0.       
           05  WS-ACCOUNT-NO-C.                                         
               10  WS-CUSTOMER-NO       PIC X(10) VALUE SPACES.         
               10  FILLER               PIC X(03) VALUE SPACES.         
           05  WS-ACCOUNT-NO REDEFINES WS-ACCOUNT-NO-C.                 
               10  WS-ACCOUNT-NO-NUM    PIC 9(13).                      
           05  WS-CUST-NO-NUM           REDEFINES WS-ACCOUNT-NO.        
               10  WS-CUSTOMER-NO-NUM   PIC 9(10).                      
               10  WS-ACCOUNT-SEQ-NUM   PIC 9(03).                      
           05  WS-RM01-RECORD-FIELD-DESC.                               
               10  WS-RM01-RECEIVABLE-TYPE  PIC X(03).                  
               10  FILLER                   PIC X(26) VALUE             
                    ' RECEIVABLES AGING CHANGED'.                       
           05  WS-PYMT-PRIORITY-LVL-C   PIC X(03).                      
           05  WS-PYMT-PRIORITY-LVL-N  REDEFINES WS-PYMT-PRIORITY-LVL-C 
                                        PIC 9(03).                      
      ***  05  WS-PYMT-PRIORITY-LVL     PIC S9(02) COMP VALUE +0.       01361002
247359     05  WS-PYMT-PRIORITY-LVL     PIC S9(4) USAGE COMP.           
                                                                        
           05  WS-ITEM-ID-C             PIC X(09).                      
           05  WS-ITEM-ID-N REDEFINES WS-ITEM-ID-C PIC 9(09).           
COB305     05 WS-ITEM-ID        PIC S9(09) COMP-3 VALUE 0.              
                                                                        
           05  WS-AMT-00-DAY-C          PIC X(11).                      
           05  WS-AMT-00-DAY-N REDEFINES WS-AMT-00-DAY-C                
                                        PIC 9(09)V99.                   
COB305     05 WS-AMT-00-DAY        PIC S9(09)V99 COMP-3 VALUE 0.           
                                                                        
           05  WS-AMT-30-DAY-C          PIC X(11).                      
           05  WS-AMT-30-DAY-N REDEFINES WS-AMT-30-DAY-C                
                                        PIC 9(09)V99.                   
COB305     05 WS-AMT-30-DAY        PIC S9(09)V99 COMP-3 VALUE 0.           
           05  WS-AMT-60-DAY-C          PIC X(11).                      
           05  WS-AMT-60-DAY-N REDEFINES WS-AMT-60-DAY-C                
                                        PIC 9(09)V99.                   
COB305     05 WS-AMT-60-DAY        PIC S9(09)V99 COMP-3 VALUE 0.           
           05  WS-AMT-90-DAY-C          PIC X(11).                      
           05  WS-AMT-90-DAY-N REDEFINES WS-AMT-90-DAY-C                
                                        PIC 9(09)V99.                   
COB305     05 WS-AMT-90-DAY        PIC S9(09)V99 COMP-3 VALUE 0.           
PCR404     05  WS-AMT-00-SUMM-OLD-C     PIC X(13).                      
PCR404     05  WS-AMT-00-SUMM-OLD-N     PIC $(9)9.99.                   
PCR404     05  WS-AMT-30-SUMM-OLD-C     PIC X(13).                      
PCR404     05  WS-AMT-30-SUMM-OLD-N     PIC $(9)9.99.                   
PCR404     05  WS-AMT-60-SUMM-OLD-C     PIC X(13).                      
PCR404     05  WS-AMT-60-SUMM-OLD-N     PIC $(9)9.99.                   
PCR404     05  WS-AMT-90-SUMM-OLD-C     PIC X(13).                      
PCR404     05  WS-AMT-90-SUMM-OLD-N     PIC $(9)9.99.                   
           05  WS-SUMM-CNTRL-OLD.                                       
               10  WS-AMT-00-SUMM-OLD   PIC S9(09)V99 COMP-3 VALUE 0.   
               10  WS-AMT-30-SUMM-OLD   PIC S9(09)V99 COMP-3 VALUE 0.   
               10  WS-AMT-60-SUMM-OLD   PIC S9(09)V99 COMP-3 VALUE 0.   
               10  WS-AMT-90-SUMM-OLD   PIC S9(09)V99 COMP-3 VALUE 0.   
           05  WS-SUMM-CNTRL-NEW.                                       
               10  WS-AMT-00-SUMM-NEW   PIC S9(09)V99 COMP-3 VALUE 0.   
               10  WS-AMT-30-SUMM-NEW   PIC S9(09)V99 COMP-3 VALUE 0.   
               10  WS-AMT-60-SUMM-NEW   PIC S9(09)V99 COMP-3 VALUE 0.   
               10  WS-AMT-90-SUMM-NEW   PIC S9(09)V99 COMP-3 VALUE 0.   
           05 WS-SUMM-CNTRL-CMP.                                        
               10  WS-AMT-00-SUMM-CMP   PIC S9(09)V99 COMP-3 VALUE 0.   
               10  WS-AMT-30-SUMM-CMP   PIC S9(09)V99 COMP-3 VALUE 0.   
               10  WS-AMT-60-SUMM-CMP   PIC S9(09)V99 COMP-3 VALUE 0.   
               10  WS-AMT-90-SUMM-CMP   PIC S9(09)V99 COMP-3 VALUE 0.   
PCR404     05  WS-AMT-00-DET-OLD-C      PIC X(13).                      
PCR404     05  WS-AMT-00-DET-OLD-N      PIC $(9)9.99.                   
PCR404     05  WS-AMT-30-DET-OLD-C      PIC X(13).                      
PCR404     05  WS-AMT-30-DET-OLD-N      PIC $(9)9.99.                   
PCR404     05  WS-AMT-60-DET-OLD-C      PIC X(13).                      
PCR404     05  WS-AMT-60-DET-OLD-N      PIC $(9)9.99.                   
PCR404     05  WS-AMT-90-DET-OLD-C      PIC X(13).                      
PCR404     05  WS-AMT-90-DET-OLD-N      PIC $(9)9.99.                   
           05  WS-AR-DET-OLD.                                           
               10  WS-AMT-00-DET-OLD    PIC S9(09)V99 COMP-3 VALUE 0.   
               10  WS-AMT-30-DET-OLD    PIC S9(09)V99 COMP-3 VALUE 0.   
               10  WS-AMT-60-DET-OLD    PIC S9(09)V99 COMP-3 VALUE 0.   
               10  WS-AMT-90-DET-OLD    PIC S9(09)V99 COMP-3 VALUE 0.   
           05  WS-AR-DET-NEW.                                           
               10  WS-AMT-00-DET-NEW    PIC S9(09)V99 COMP-3 VALUE 0.   
               10  WS-AMT-30-DET-NEW    PIC S9(09)V99 COMP-3 VALUE 0.   
               10  WS-AMT-60-DET-NEW    PIC S9(09)V99 COMP-3 VALUE 0.   
               10  WS-AMT-90-DET-NEW    PIC S9(09)V99 COMP-3 VALUE 0.   
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  WS-RM-TRAN-APPL-NO    PIC S9(04) COMP VALUE +0.          
           05  WS-GEN-LED-UTE        PIC X(10) VALUE 'AR-UTE    '.      
           05  WS-GEN-LED-UTG        PIC X(10) VALUE 'AR-UTG    '.      
           05  WS-GEN-LED-EPP        PIC X(10) VALUE 'AR-BUD    '.      
           05  WS-GEN-LED-RCC        PIC X(10) VALUE 'AR-CCC    '.      
           05  WS-GEN-LED-CIA        PIC X(10) VALUE 'AR-CIA    '.      
           05  WS-GEN-LED-CNT        PIC X(10) VALUE 'AR-CNT    '.      
           05  WS-GEN-LED-DEP        PIC X(10) VALUE 'AR-DEP    '.      
           05  WS-GEN-LED-DFA        PIC X(10) VALUE 'AR-DFA    '.      
           05  WS-GEN-LED-LPC        PIC X(10) VALUE 'AR-LPC    '.      
           05  WS-GEN-LED-LPN        PIC X(10) VALUE 'AR-LPN    '.      
           05  WS-GEN-LED-NSA        PIC X(10) VALUE 'AR-NSA    '.      
           05  WS-GEN-LED-NSN        PIC X(10) VALUE 'AR-NSN    '.      
           05  WS-GEN-LED-NSC        PIC X(10) VALUE 'AR-NSC    '.      
           05  WS-GEN-LED-PJS        PIC X(10) VALUE 'AR-PJS    '.      
IF0396*    05  WS-CASH-DRAWER.                                                  
IF0396*        10  FILLER            PIC X(05) VALUE 'CASH '.                   
IF0396*        10  WS-CASH-DRAWER-ID PIC X(01).                                 
           05  WS-COMMENT-LEN        PIC S9(4) COMP-3 VALUE +0.         
           05  WS-CURRENT-DATE       PIC  X(10) VALUE SPACES.           
           05  WS-CURRENT-TIMESTAMP  PIC  X(26) VALUE SPACES.           
T21205     05  WS-LAST-UPDATE-TS       PIC X(26).                       
REARCH*    05  SCSCA182                PIC X(08) VALUE 'SCSCA182'.              
REARCH     05  MCSCA182                PIC X(08) VALUE 'MCSCA182'.      
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-A                        PIC X(01)   VALUE 'A'.       
           05  WS-B                        PIC X(01)   VALUE 'B'.       
           05  WS-C                        PIC X(01)   VALUE 'C'.       
           05  WS-F                        PIC X(01)   VALUE 'F'.       
           05  WS-J                        PIC X(01)   VALUE 'J'.       
           05  WS-K                        PIC X(01)   VALUE 'K'.       
           05  WS-M                        PIC X(01)   VALUE 'M'.       
           05  WS-N                        PIC X(01)   VALUE 'N'.       
           05  WS-R                        PIC X(01)   VALUE 'R'.       
           05  WS-T                        PIC X(01)   VALUE 'T'.       
           05  WS-W                        PIC X(01)   VALUE 'W'.       
           05  WS-Y                        PIC X(01)   VALUE 'Y'.       
           05  WS-Z                        PIC X(01)   VALUE 'Z'.       
IF0396     05  WS-01                       PIC X(02)   VALUE '01'.      
IF0396     05  WS-998                      PIC X(03)   VALUE '998'.     
IF0396     05  WS-9999                     PIC S9(04) COMP VALUE +9999. 
T21205     05  WS-100                      PIC S9(03)  VALUE 100.       
                                                                        
REARCH*01  GW-LIB-MISC-FIELDS.                                          01530000
REARCH*    05  GWL-PROC                 POINTER.                        01540000
REARCH*    05  GWL-INIT-HANDLE          POINTER.                        01550000
REARCH*    05  GWL-RC                   PIC S9(9) COMP.                 01560000
REARCH*    05  GWL-STATUS-NR            PIC S9(9) COMP.                 01570000
REARCH*    05  GWL-STATUS-DONE          PIC S9(9) COMP.                 01580000
REARCH*    05  GWL-STATUS-COUNT         PIC S9(9) COMP.                 01590000
REARCH*    05  GWL-STATUS-COMM          PIC S9(9) COMP.                 01600000
REARCH*    05  GWL-STATUS-RETURN-CODE   PIC S9(9) COMP.                 01610000
REARCH*    05  GWL-STATUS-SUBCODE       PIC S9(9) COMP.                 01620000
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
                                                                        
       01  PARM-FIELDS.                                                 
REARCH*    05  PARM-L                     PIC S9(9) COMP.               01660000
REARCH*    05  PARM-ID1                   PIC S9(9) COMP VALUE 1.       01670000
REARCH*    05  PARM-ACCOUNT-NO            PIC X(13).                    01680002
REARCH*    05  PARM-PYMT-PRIORITY-LVL     PIC X(03).                    01690002
REARCH*    05  PARM-ITEM-ID               PIC X(09).                    01700002
REARCH*    05  PARM-RECV-TYPE             PIC X(03).                    01701003
REARCH*    05  PARM-RECV-DESC             PIC X(20).                    01702004
REARCH*    05  PARM-AR-00-DAY             PIC X(11).                    01710002
REARCH*    05  PARM-AR-30-DAY             PIC X(11).                    01720002
REARCH*    05  PARM-AR-60-DAY             PIC X(11).                    01730002
REARCH*    05  PARM-AR-90-DAY             PIC X(11).                    01740002
REARCH*    05  PARM-USER-ID               PIC X(07).                            
REARCH*    05  PARM-RESP-AREA-ID          PIC X(03).                            
REARCH*    05  PARM-COMMENT-LEN           PIC X(4).                             
REARCH*    05  PARM-COMMENT-LEN-NUM REDEFINES PARM-COMMENT-LEN                  
REARCH     05  PARM-COMMENT-LEN-TMP       PIC X(4).                     
REARCH     05  PARM-COMMENT-LEN-NUM REDEFINES PARM-COMMENT-LEN-TMP      
REARCH                                    PIC S9(4).                    
REARCH*    05  PARM-COMMENT-TEXT          PIC X(210).                           
T21205*    05  PARM-AT-LAST-UPDATE-TS     PIC X(26).                            
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
           05  RS-AR-LOCKOUT-IND        PIC X(01) VALUE SPACE.          
           05  RS-ACCT-XFER-TO          PIC X(13) VALUE SPACE.          
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE            PIC S9(9) COMP VALUE 0.         
REARCH     05  S-AR-LOCKOUT-IND         PIC X(01) VALUE SPACE.          
REARCH     05  S-ACCT-XFER-TO           PIC X(13) VALUE SPACE.          
                                                                        
REARCH*01  CN-COLUMN-NAMES.                                             02070000
REARCH*    05  CN-RETURN-CODE           PIC X(11) VALUE                 02080000
REARCH*                                        'RETURN_CODE'.           02090000
REARCH*    05  CN-AR-LOCKOUT-IND        PIC X(14) VALUE                 02100000
REARCH*                                       'AR_LOCKOUT_IND'.         02100000
REARCH*    05  CN-ACCT-XFER-TO          PIC X(15) VALUE                 02100000
REARCH*                                       'AT_ACCT_XFER_TO'.        02100000
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
REARCH     10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
REARCH     10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
REARCH     10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
REARCH         49  S-HOST-VARIABLES-V  PIC X(255).                      
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-STATEMENT-V   PIC X(255).                      
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-DESCRIPTION-V PIC X(255).                      
                                                                        
T21205 COPY CWS00182.                                                           
HPCCDM*EJECT                                                            02110000
                                                                        
T21205 LINKAGE SECTION.                                                 
REARCH*01  DFHCOMMAREA                   PIC X(4000).                           
REARCH 01  PARM-ACCOUNT-NO               PIC X(13).                     
REARCH 01  PARM-PYMT-PRIORITY-LVL        PIC X(03).                     
REARCH 01  PARM-ITEM-ID                  PIC X(09).                     
REARCH 01  PARM-RECV-TYPE                PIC X(03).                     
REARCH 01  PARM-RECV-DESC                PIC X(25).                     
REARCH 01  PARM-AR-00-DAY                PIC X(11).                     
REARCH 01  PARM-AR-30-DAY                PIC X(11).                     
REARCH 01  PARM-AR-60-DAY                PIC X(11).                     
REARCH 01  PARM-AR-90-DAY                PIC X(11).                     
REARCH 01  PARM-USER-ID                  PIC X(07).                     
REARCH 01  PARM-RESP-AREA-ID             PIC X(03).                     
REARCH 01  PARM-COMMENT-TEXT             PIC X(210).                    
REARCH 01  PARM-COMMENT-LEN              PIC X(4).                      
REARCH 01  PARM-AT-LAST-UPDATE-TS        PIC X(26).                     
                                                                        
REARCH PROCEDURE DIVISION USING  PARM-ACCOUNT-NO                        
REARCH                           PARM-PYMT-PRIORITY-LVL                 
REARCH                           PARM-ITEM-ID                           
REARCH                           PARM-RECV-TYPE                         
REARCH                           PARM-RECV-DESC                         
REARCH                           PARM-AR-00-DAY                         
REARCH                           PARM-AR-30-DAY                         
REARCH                           PARM-AR-60-DAY                         
REARCH                           PARM-AR-90-DAY                         
REARCH                           PARM-USER-ID                           
REARCH                           PARM-RESP-AREA-ID                      
REARCH                           PARM-COMMENT-TEXT                      
REARCH                           PARM-COMMENT-LEN                       
REARCH                           PARM-AT-LAST-UPDATE-TS.                
                                                                        
      ******************************************************************02140000
      * 0000-MAINLINE                                                  *02150000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *02160000
      ******************************************************************02170000
                                                                        
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02290000
      * 0100-INITIALIZE                                                *02300000
      *                                                                *02310000
      *     1. RESET DB2 ERROR HANDLERS                                *02320000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *02330000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *02340000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*02350000
      *                                                                *02360000
      ******************************************************************02370000
                                                                        
       0100-INITIALIZE.                                                 
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
REARCH*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.     02450000
REARCH*                                                                 02460000
REARCH*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,     02470000
REARCH*                          SNA-CONNECTION-NAME, SNA-SUBC.         02480000
REARCH*                                                                 02490000
REARCH*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                      02500000
REARCH*                                                                 02510000
REARCH*    IF GWL-RC NOT = TDS-PARM-PRESENT                             02520000
REARCH*       MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     02530000
REARCH*       MOVE '0100'          TO ACTIVE-PARAGRAPH                  02540000
REARCH*       MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION      02550000
REARCH*       MOVE 'CICS TRANSACTION'   TO TABLE-1                      02560000
REARCH*       MOVE GWL-RC               TO WS-ACTIVE-RETURN-CODE        02570000
REARCH*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            02580000
REARCH*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            02590000
REARCH*    END-IF.                                                      02600000
REARCH*                                                                 02850000
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARCH            :S-RETURN-CODE      AS RETURN_CODE                    
REARCH           ,:S-AR-LOCKOUT-IND   AS AR_LOCKOUT_IND                 
REARCH           ,:S-ACCT-XFER-TO     AS AT_ACCT_XFER_TO                
REARCH         FROM                                                     
REARCH             CIS.SYSDUMMY1                                     
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*           :S-RETURN-CODE      AS RETURN_CODE                            
MFA-TR*          ,:S-AR-LOCKOUT-IND   AS AR_LOCKOUT_IND                         
MFA-TR*          ,:S-ACCT-XFER-TO     AS AT_ACCT_XFER_TO                        
MFA-TR*        FROM                                                             
MFA-TR*            SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC.                                                            
REARCH*                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02650000
      * 1000-PROCESS-INPUT                                             *02660000
      *     1. RECEIVE PARMS.                                          *02680000
      ******************************************************************02700000
                                                                        
       1000-PROCESS-INPUT.                                              
REARCH*    PERFORM 1100-RECEIVE-PARMS     THRU 1100-EXIT.               02740000
T21205     INITIALIZE SCSCA182-LINK-RECORD.                             
T21205     MOVE PARM-ACCOUNT-NO           TO SCSCA182-ACCOUNT-NO.       
REARCH     MOVE PARM-COMMENT-LEN          TO PARM-COMMENT-LEN-TMP.      
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02790000
      * 1100-RECEIVE-PARMS                                             *02800000
      *     RECEIVE EACH PARAMETER FROM THE REMOTE PROCEDURE           *02820000
      ******************************************************************02840000
                                                                        
REARCH*1100-RECEIVE-PARMS.                                              02860000
REARCH*    MOVE 1                            TO PARM-ID1.               02880000
REARCH*    MOVE LENGTH OF PARM-ACCOUNT-NO TO MAX-LENGTH-PARM,           02890002
REARCH*                                                                 02900000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              02910000
REARCH*                          GWL-RC,                                02920000
REARCH*                          PARM-ID1,                              02930000
REARCH*                          PARM-ACCOUNT-NO,                       02940002
REARCH*                          TDSCHAR,                               02950000
REARCH*                          MAX-LENGTH-PARM,                       02960000
REARCH*                          PARM-L.                                02970000
REARCH*                                                                 02980000
REARCH*    ADD 1                             TO PARM-ID1.               02990000
REARCH*    MOVE LENGTH OF PARM-PYMT-PRIORITY-LVL                        03000002
REARCH*                                      TO MAX-LENGTH-PARM,        03001002
REARCH*                                                                 03010000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              03020000
REARCH*                          GWL-RC,                                03030000
REARCH*                          PARM-ID1,                              03040000
REARCH*                          PARM-PYMT-PRIORITY-LVL,                03050002
REARCH*                          TDSCHAR,                               03060000
REARCH*                          MAX-LENGTH-PARM,                       03070000
REARCH*                          PARM-L.                                03080000
REARCH*                                                                 03090000
REARCH*    ADD 1                             TO PARM-ID1.               03100000
REARCH*    MOVE LENGTH OF PARM-ITEM-ID TO MAX-LENGTH-PARM,              03110002
REARCH*                                                                 03120000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              03130000
REARCH*                          GWL-RC,                                03140000
REARCH*                          PARM-ID1,                              03150000
REARCH*                          PARM-ITEM-ID,                          03160002
REARCH*                          TDSCHAR,                               03170000
REARCH*                          MAX-LENGTH-PARM,                       03180000
REARCH*                          PARM-L.                                03190000
REARCH*                                                                 03200000
REARCH*    ADD 1                             TO PARM-ID1.               03201003
REARCH*    MOVE LENGTH OF PARM-RECV-TYPE TO MAX-LENGTH-PARM,            03202003
REARCH*                                                                 03230000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              03240000
REARCH*                          GWL-RC,                                03250000
REARCH*                          PARM-ID1,                              03260000
REARCH*                          PARM-RECV-TYPE,                        03207003
REARCH*                          TDSCHAR,                               03280000
REARCH*                          MAX-LENGTH-PARM,                       03290000
REARCH*                          PARM-L.                                03300000
REARCH*                                                                 03310000
REARCH*    ADD 1                             TO PARM-ID1.               03209304
REARCH*    MOVE LENGTH OF PARM-RECV-DESC TO MAX-LENGTH-PARM,            03209404
REARCH*                                                                 03209504
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              03209604
REARCH*                          GWL-RC,                                03209704
REARCH*                          PARM-ID1,                              03209804
REARCH*                          PARM-RECV-DESC,                        03209904
REARCH*                          TDSCHAR,                               03210004
REARCH*                          MAX-LENGTH-PARM,                       03210104
REARCH*                          PARM-L.                                03210204
REARCH*                                                                 03210304
REARCH*    ADD 1                          TO PARM-ID1.                  03211000
REARCH*    MOVE LENGTH OF PARM-AR-00-DAY TO MAX-LENGTH-PARM,            03220002
REARCH*                                                                 03340000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              03350000
REARCH*                          GWL-RC,                                03360000
REARCH*                          PARM-ID1,                              03370000
REARCH*                          PARM-AR-00-DAY,                        03270002
REARCH*                          TDSCHAR,                               03390000
REARCH*                          MAX-LENGTH-PARM,                       03400000
REARCH*                          PARM-L.                                03410000
REARCH*                                                                 03420000
REARCH*    ADD 1                           TO PARM-ID1.                 03320000
REARCH*    MOVE LENGTH OF PARM-AR-30-DAY TO MAX-LENGTH-PARM,            03330002
REARCH*                                                                 03450000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              03460000
REARCH*                          GWL-RC,                                03470000
REARCH*                          PARM-ID1,                              03480000
REARCH*                          PARM-AR-30-DAY,                        03380002
REARCH*                          TDSCHAR,                               03500000
REARCH*                          MAX-LENGTH-PARM,                       03510000
REARCH*                          PARM-L.                                03520000
REARCH*                                                                 03530000
REARCH*    ADD 1                               TO PARM-ID1.             03430000
REARCH*    MOVE LENGTH OF PARM-AR-60-DAY TO MAX-LENGTH-PARM,            03440002
REARCH*                                                                 03560000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              03570000
REARCH*                          GWL-RC,                                03580000
REARCH*                          PARM-ID1,                              03590000
REARCH*                          PARM-AR-60-DAY                         03490002
REARCH*                          TDSCHAR,                               03610000
REARCH*                          MAX-LENGTH-PARM,                       03620000
REARCH*                          PARM-L.                                03630000
REARCH*                                                                 03640000
REARCH*    ADD 1                             TO PARM-ID1.               03540000
REARCH*    MOVE LENGTH OF PARM-AR-90-DAY TO MAX-LENGTH-PARM,            03550002
REARCH*                                                                 03670000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              03680000
REARCH*                          GWL-RC,                                03690000
REARCH*                          PARM-ID1,                              03700000
REARCH*                          PARM-AR-90-DAY,                        03600002
REARCH*                          TDSCHAR,                               03720000
REARCH*                          MAX-LENGTH-PARM,                       03730000
REARCH*                          PARM-L.                                03740000
REARCH*                                                                 03750000
REARCH*    ADD 1                             TO PARM-ID1.                       
REARCH*    MOVE LENGTH OF PARM-USER-ID TO MAX-LENGTH-PARM,                      
REARCH*                                                                 03780000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-USER-ID,                                  
REARCH*                          TDSCHAR,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                 03780000
REARCH*    ADD 1                             TO PARM-ID1.                       
REARCH*    MOVE LENGTH OF PARM-RESP-AREA-ID TO MAX-LENGTH-PARM,                 
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-RESP-AREA-ID,                             
REARCH*                          TDSCHAR,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                         
REARCH*    ADD 1                             TO PARM-ID1.                       
REARCH*    MOVE LENGTH OF PARM-COMMENT-LEN  TO MAX-LENGTH-PARM,                 
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-COMMENT-LEN,                              
REARCH*                          TDSCHAR,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                         
REARCH*    ADD 1                             TO PARM-ID1.                       
REARCH*    MOVE LENGTH OF PARM-COMMENT-TEXT TO MAX-LENGTH-PARM,                 
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-COMMENT-TEXT,                             
REARCH*                          TDSCHAR,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
T21205*    ADD 1                                 TO PARM-ID1.           10460300
T21205*    MOVE LENGTH OF PARM-AT-LAST-UPDATE-TS TO MAX-LENGTH-PARM.    10460400
T21205*    CALL 'TDRCVPRM' USING GWL-PROC,                              10460500
T21205*                          GWL-RC,                                10460600
T21205*                          PARM-ID1,                              10460700
T21205*                          PARM-AT-LAST-UPDATE-TS,                10460800
T21205*                          TDSCHAR,                               10460900
T21205*                          MAX-LENGTH-PARM,                       10461000
T21205*                          PARM-L.                                10461100
T21205*                                                                         
REARCH*1100-EXIT.                                                       05080000
REARCH*    EXIT.                                                        05090000
                                                                        
      ******************************************************************05110000
      * 2000-PROCESS-OUTPUT.                                           *05120000
      *                                                                *05130000
      *     1. DESCRIBE RESULT SET                                     *05140000
      *     2. UPDATE DB2 DATA                                         *05150000
      *     3. BUILD RESULT SET                                        *05160000
      *     4. SEND RESULT SET                                         *05170000
      *                                                                *05180000
      ******************************************************************05190000
                                                                        
       2000-PROCESS-OUTPUT.                                             
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           MOVE PARM-COMMENT-LEN-NUM TO WS-COMMENT-LEN.                 
REARCH*    PERFORM 2100-DESCRIBE-RESULT THRU 2100-EXIT.                 05230000
           PERFORM 7999-SELECT-AL THRU 7999-SELECT-AL-EXIT              
           IF AL-AR-LOCKOUT-IND = 'Y'                                   
              MOVE 5000 TO RS-RETURN-CODE                               
              MOVE AL-AR-LOCKOUT-IND        TO RS-AR-LOCKOUT-IND        
REARCH        PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT             
REARCH        ADD +1                        TO   CTR-ROWS               
REARCH*       PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              05310000
              PERFORM 9999-END-PROGRAM      THRU 9999-EXIT              
T21205     END-IF.                                                      
T21205*                                                                         
T21205     PERFORM 9200-LINK-SCSCA182          THRU 9200-EXIT.          
T21205     IF  SCSCA182-RETURN-CODE NOT EQUAL ZERO                      
REARCH*        MOVE ABEND-FILE-LK              TO ABEND-FILE                    
T21205         MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
T21205         MOVE SCSCA182-RETURN-CODE       TO WS-ACTIVE-RETURN-CODE 
T21205                                            SQLCODE               
T21205         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
T21205         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           ELSE                                                         
T21205         MOVE SCSCA182-LAST-UPDATE-TS    TO WS-LAST-UPDATE-TS     
T21205         IF  PARM-AT-LAST-UPDATE-TS = WS-LAST-UPDATE-TS           
T21205             NEXT SENTENCE                                        
T21205         ELSE                                                     
T21205             MOVE 5272                   TO RS-RETURN-CODE        
REARCH             PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT          
REARCH             ADD +1                      TO   CTR-ROWS            
REARCH*            PERFORM 8100-SEND-RESULT    THRU 8100-EXIT           10606000
T21205             GO TO 2000-EXIT                                      
T21205         END-IF                                                   
T21205     END-IF.                                                      
      *                                                                 10601000
           PERFORM 5000-UPDATE          THRU 5000-EXIT.                 
                                                                        
REARCH     PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT.                
REARCH     ADD +1                       TO   CTR-ROWS.                  
REARCH*    PERFORM 8100-SEND-RESULT     THRU 8100-EXIT.                 05260000
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH*****************************************************************         
REARCH* 2000A-MOVE-RESULT.                                            *         
REARCH*****************************************************************         
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE  RS-RETURN-CODE           TO S-RETURN-CODE.             
REARCH     MOVE  RS-AR-LOCKOUT-IND        TO S-AR-LOCKOUT-IND.          
REARCH     MOVE  RS-ACCT-XFER-TO          TO S-ACCT-XFER-TO.            
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
      ******************************************************************05310000
      * 2100-DESCRIBE-RESULT                                           *05320000
      *                                                                *05330000
      *     DESCRIBE EACH COLUMN IN THE RESULT SET.                    *05340000
      *                                                                *05350000
      ******************************************************************05360000
                                                                        
REARCH*2100-DESCRIBE-RESULT.                                            05380000
REARCH*    MOVE '2100' TO ACTIVE-PARAGRAPH.                             05390000
REARCH*                                                                 05400000
REARCH*    MOVE 1       TO CTR-COLUMN.                                  05410000
REARCH*    MOVE TDSINT4 TO DB-HOST-TYPE.                                05420000
REARCH*    MOVE TDSINT4 TO DB-CLIENT-TYPE.                              05430000
REARCH*    MOVE LENGTH OF RS-RETURN-CODE TO WRKLEN1.                    05440000
REARCH*    MOVE LENGTH OF CN-RETURN-CODE TO WRKLEN2.                    05450000
REARCH*                                                                 05460000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05470000
REARCH*                          GWL-RC,                                05480000
REARCH*                          CTR-COLUMN,                            05490000
REARCH*                          DB-HOST-TYPE,                          05500000
REARCH*                          WRKLEN1,                               05510000
REARCH*                          RS-RETURN-CODE,                        05520000
REARCH*                          DB-NULL-INDICATOR,                     05530000
REARCH*                          TDS-FALSE,                             05540000
REARCH*                          DB-CLIENT-TYPE,                        05550000
REARCH*                          WRKLEN1,                               05560000
REARCH*                          CN-RETURN-CODE,                        05570000
REARCH*                          WRKLEN2.                               05580000
REARCH*                                                                 05590000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     05600000
REARCH*                                                                 05400000
REARCH*    ADD 1       TO CTR-COLUMN.                                   05410000
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                05420000
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              05430000
REARCH*    MOVE LENGTH OF RS-AR-LOCKOUT-IND TO WRKLEN1.                 05440000
REARCH*    MOVE LENGTH OF CN-AR-LOCKOUT-IND TO WRKLEN2.                 05450000
REARCH*                                                                 05460000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05470000
REARCH*                          GWL-RC,                                05480000
REARCH*                          CTR-COLUMN,                            05490000
REARCH*                          DB-HOST-TYPE,                          05500000
REARCH*                          WRKLEN1,                               05510000
REARCH*                          RS-AR-LOCKOUT-IND,                     05520000
REARCH*                          DB-NULL-INDICATOR,                     05530000
REARCH*                          TDS-FALSE,                             05540000
REARCH*                          DB-CLIENT-TYPE,                        05550000
REARCH*                          WRKLEN1,                               05560000
REARCH*                          CN-AR-LOCKOUT-IND,                     05570000
REARCH*                          WRKLEN2.                               05580000
REARCH*                                                                 05590000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     05600000
REARCH*                                                                 05590000
REARCH*    ADD 1       TO CTR-COLUMN.                                   05410000
REARCH*    MOVE TDSCHAR TO DB-HOST-TYPE.                                05420000
REARCH*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              05430000
REARCH*    MOVE LENGTH OF RS-ACCT-XFER-TO TO WRKLEN1.                   05440000
REARCH*    MOVE LENGTH OF CN-ACCT-XFER-TO TO WRKLEN2.                   05450000
REARCH*                                                                 05460000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05470000
REARCH*                          GWL-RC,                                05480000
REARCH*                          CTR-COLUMN,                            05490000
REARCH*                          DB-HOST-TYPE,                          05500000
REARCH*                          WRKLEN1,                               05510000
REARCH*                          RS-ACCT-XFER-TO,                       05520000
REARCH*                          DB-NULL-INDICATOR,                     05530000
REARCH*                          TDS-FALSE,                             05540000
REARCH*                          DB-CLIENT-TYPE,                        05550000
REARCH*                          WRKLEN1,                               05560000
REARCH*                          CN-ACCT-XFER-TO,                       05570000
REARCH*                          WRKLEN2.                               05580000
REARCH*                                                                 05590000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     05600000
REARCH*                                                                 05590000
REARCH*2100-EXIT.                                                       05620000
REARCH*    EXIT.                                                        05630000
                                                                        
      ***************************************************************           
      * MAIN UPDATE PARAGRAPH.                                      *           
      ***************************************************************           
                                                                        
       5000-UPDATE.                                                     
           MOVE '5000' TO ACTIVE-PARAGRAPH.                             
           MOVE PARM-ACCOUNT-NO        TO WS-ACCOUNT-NO-C.              
           MOVE PARM-PYMT-PRIORITY-LVL TO WS-PYMT-PRIORITY-LVL-C.       
           MOVE PARM-ITEM-ID           TO WS-ITEM-ID-C.                 
           MOVE PARM-AR-00-DAY         TO WS-AMT-00-DAY-C.              
           MOVE PARM-AR-30-DAY         TO WS-AMT-30-DAY-C.              
           MOVE PARM-AR-60-DAY         TO WS-AMT-60-DAY-C.              
           MOVE PARM-AR-90-DAY         TO WS-AMT-90-DAY-C.              
           MOVE WS-PYMT-PRIORITY-LVL-N TO WS-PYMT-PRIORITY-LVL          
                                          AC-PYMT-PRIORITY-LVL.         
           MOVE WS-AMT-00-DAY-N        TO WS-AMT-00-DAY.                
           MOVE WS-AMT-30-DAY-N        TO WS-AMT-30-DAY.                
           MOVE WS-AMT-60-DAY-N        TO WS-AMT-60-DAY.                
           MOVE WS-AMT-90-DAY-N        TO WS-AMT-90-DAY.                
           MOVE WS-ACCOUNT-NO-NUM      TO AT-ACCOUNT-NO.                
           PERFORM 7999-SELECT-TRANSFER-IND                             
              THRU 7999-SELECT-TRANSFER-IND-EXIT.                       
           IF AT-ACCT-XFER-TO > ZERO                                    
              MOVE 5000 TO RS-RETURN-CODE                               
              MOVE AT-ACCT-XFER-TO          TO RS-ACCT-XFER-TO          
REARCH        PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT             
REARCH        ADD +1                        TO   CTR-ROWS               
REARCH*       PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              05310000
              PERFORM 9999-END-PROGRAM      THRU 9999-EXIT              
           END-IF.                                                      
                                                                        
           MOVE WS-AMT-00-DAY          TO WS-AMT-00-SUMM-NEW            
           MOVE WS-AMT-30-DAY          TO WS-AMT-30-SUMM-NEW            
           MOVE WS-AMT-60-DAY          TO WS-AMT-60-SUMM-NEW            
           MOVE WS-AMT-90-DAY          TO WS-AMT-90-SUMM-NEW            
                                                                        
           PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT.                  
           PERFORM 7100-SELECT-PREMISE THRU 7100-EXIT.                  
           PERFORM 7200-SELECT-CUSTOMER THRU 7200-EXIT.                 
           PERFORM 6000-SETUP-JOURNAL THRU 6000-EXIT.                   
                                                                        
           MOVE ZEROES TO WS-ITEM-ID.                                   
           PERFORM 7300-SELECT-AR-AGE-SUMM THRU 7300-EXIT.              
           PERFORM 5350-MOVE-GEN-LED THRU 5350-EXIT.                    
           IF PARM-RECV-TYPE = 'BBP' OR 'CNT' OR 'DFA' OR 'DEP'         
P00453                         OR 'RCC' OR 'CIA' OR 'DPP' OR 'PRP'      
              MOVE WS-ITEM-ID-N TO WS-ITEM-ID                           
              PERFORM 7400-SELECT-AR-AGE-INFO THRU 7400-EXIT            
              PERFORM 5100-MOVE-PARM-TO-NEW THRU 5100-EXIT              
              PERFORM 5400-JRNL-DET THRU 5400-EXIT                      
              PERFORM 5300-COMPUTE-CNTRL THRU 5300-EXIT                 
              PERFORM 8700-UPDATE-AR-CNTRL-DET THRU 8700-EXIT
           END-IF.          
                                                                        
           IF PARM-RECV-TYPE = 'BBP' OR 'CNT' OR 'DFA' OR 'DEP'         
P00453                         OR 'RCC' OR 'CIA' OR 'DPP' OR 'PRP'      
              PERFORM 5200-MOVE-COMP-TO-NEW THRU 5200-EXIT              
           ELSE                                                         
              PERFORM 5100-MOVE-PARM-TO-NEW THRU 5100-EXIT              
              MOVE ZEROES TO WS-ITEM-ID                                 
              PERFORM 5500-JRNL-CNTRL THRU 5500-EXIT
           END-IF.                   
                                                                        
           MOVE ZEROES TO WS-ITEM-ID.                                   
           PERFORM 8600-UPDATE-AR-CNTRL-SUMM THRU 8600-EXIT.            
           PERFORM 8800-UPDATE-ACCOUNT THRU 8800-EXIT.                  
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * MOVE PARAMETER VALUES TO NEW DETAIL FIELDS.                 *           
      ***************************************************************           
                                                                        
       5100-MOVE-PARM-TO-NEW.                                           
           MOVE '5100'        TO ACTIVE-PARAGRAPH.                      
           MOVE WS-AMT-00-DAY TO WS-AMT-00-DET-NEW                      
           MOVE WS-AMT-30-DAY TO WS-AMT-30-DET-NEW                      
           MOVE WS-AMT-60-DAY TO WS-AMT-60-DET-NEW                      
           MOVE WS-AMT-90-DAY TO WS-AMT-90-DET-NEW.                     
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * MOVE SUMMARY COMPUTED VALUES TO NEW SUMMARY FIELDS FOR      *           
      * CONTROL ROW.                                                *           
      ***************************************************************           
                                                                        
       5200-MOVE-COMP-TO-NEW.                                           
           MOVE '5200'             TO ACTIVE-PARAGRAPH.                 
           MOVE WS-AMT-00-SUMM-CMP TO WS-AMT-00-SUMM-NEW                
           MOVE WS-AMT-30-SUMM-CMP TO WS-AMT-30-SUMM-NEW                
           MOVE WS-AMT-60-SUMM-CMP TO WS-AMT-60-SUMM-NEW                
           MOVE WS-AMT-90-SUMM-CMP TO WS-AMT-90-SUMM-NEW.               
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * COMPUTE NEW SUMMARY VALUES FOR CONTROL ROW IN CASE DETAIL   *           
      * ROW WAS MODIFIED.                                           *           
      ***************************************************************           
                                                                        
       5300-COMPUTE-CNTRL.                                              
           MOVE '5300' TO ACTIVE-PARAGRAPH.                             
           COMPUTE WS-AMT-00-SUMM-CMP =                                 
               (WS-AMT-00-SUMM-OLD - WS-AMT-00-DET-OLD                  
                   + WS-AMT-00-DET-NEW)                                 
                                                                        
           COMPUTE WS-AMT-30-SUMM-CMP =                                 
               (WS-AMT-30-SUMM-OLD - WS-AMT-30-DET-OLD                  
                   + WS-AMT-30-DET-NEW)                                 
                                                                        
           COMPUTE WS-AMT-60-SUMM-CMP =                                 
               (WS-AMT-60-SUMM-OLD - WS-AMT-60-DET-OLD                  
                   + WS-AMT-60-DET-NEW)                                 
                                                                        
           COMPUTE WS-AMT-90-SUMM-CMP =                                 
               (WS-AMT-90-SUMM-OLD - WS-AMT-90-DET-OLD                  
                   + WS-AMT-90-DET-NEW).                                
       5300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5350-MOVE-GEN-LED.                                               
           MOVE '5350' TO ACTIVE-PARAGRAPH.                             
           MOVE AT-COMPANY-NO TO GO-COMPANY-NO.                         
           IF PARM-RECV-TYPE = 'UTE'                                    
              MOVE WS-GEN-LED-UTE TO GO-GL-ACCT-NAME                    
           ELSE                                                         
           IF PARM-RECV-TYPE = 'UTG'                                    
              MOVE WS-GEN-LED-UTG TO GO-GL-ACCT-NAME                    
           ELSE                                                         
           IF PARM-RECV-TYPE = 'NSC'                                    
              MOVE WS-GEN-LED-NSC TO GO-GL-ACCT-NAME                    
           ELSE                                                         
           IF PARM-RECV-TYPE = 'NSA'                                    
              MOVE WS-GEN-LED-NSA TO GO-GL-ACCT-NAME                    
           ELSE                                                         
           IF PARM-RECV-TYPE = 'NSN'                                    
              MOVE WS-GEN-LED-NSN TO GO-GL-ACCT-NAME                    
           ELSE                                                         
           IF PARM-RECV-TYPE = 'LPC'                                    
              MOVE WS-GEN-LED-LPC TO GO-GL-ACCT-NAME                    
           ELSE                                                         
           IF PARM-RECV-TYPE = 'LPN'                                    
              MOVE WS-GEN-LED-LPN TO GO-GL-ACCT-NAME                    
           ELSE                                                         
P00453     IF PARM-RECV-TYPE = 'BBP' OR 'PRP'                           
              MOVE WS-GEN-LED-EPP TO GO-GL-ACCT-NAME                    
           ELSE                                                         
           IF PARM-RECV-TYPE = 'CNT'                                    
              MOVE WS-GEN-LED-CNT TO GO-GL-ACCT-NAME                    
           ELSE                                                         
T13605     IF PARM-RECV-TYPE = 'DFA' OR PARM-RECV-TYPE = 'DPP'          
              MOVE WS-GEN-LED-DFA TO GO-GL-ACCT-NAME                    
           ELSE                                                         
           IF PARM-RECV-TYPE = 'DEP'                                    
              MOVE WS-GEN-LED-DEP TO GO-GL-ACCT-NAME                    
           ELSE                                                         
           IF PARM-RECV-TYPE = 'RCC'                                    
              MOVE WS-GEN-LED-RCC TO GO-GL-ACCT-NAME                    
           ELSE                                                         
           IF PARM-RECV-TYPE = 'CIA'                                    
              MOVE WS-GEN-LED-CIA TO GO-GL-ACCT-NAME                    
           ELSE                                                         
              MOVE WS-GEN-LED-PJS TO GO-GL-ACCT-NAME
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF
           END-IF.                   
                                                                        
           PERFORM 7500-SELECT-GL-NAME THRU 7500-EXIT.                  
           MOVE GO-GL-ACCT-NO TO AU-GL-ACCT-CREDIT                      
                                 AU-GL-ACCT-DEBIT.                      
       5350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * JOURNAL THE DETAIL ROW AND INSERT A ROW IN AR TRANS HIST    *           
      ***************************************************************           
                                                                        
       5400-JRNL-DET.                                                   
           MOVE '5400'              TO ACTIVE-PARAGRAPH.                
           MOVE AT-TOTAL-AR-BALANCE TO AR-AMT-BILLED-UNPAID             
                                       WS-113-ACCT-AR-BAL-IS            
                                       WS-113-ACCT-AR-BAL-WAS.          
           MOVE WS-F                TO AU-CODE-AR-AGE.                  
           MOVE WS-CURRENT-DATE     TO AR-DATE-TRANS.                   
           MOVE WS-ITEM-ID          TO AU-ITEM-ID.                      
           MOVE WS-A                TO WS-100-JRNL-SORT-ID.             
           MOVE AT-ACCOUNT-NO       TO WS-100-ACCT-NO.                  
           MOVE AT-CUSTOMER-NO      TO WS-100-CUSTOMER-NO.              
           MOVE EIBTRNID            TO WS-100-CODE-TERMINAL-TRAN.       
           ADD 1                    TO WS-RM-TRAN-APPL-NO.              
           MOVE WS-RM-TRAN-APPL-NO  TO WS-100-JRNL-TRAN-APPL-NO         
                                       AU-TRAN-APPL-NO.                 
           MOVE AT-DATE-LAST-ACTION TO WS-100-DATE-LAST-ACTION.         
           MOVE WS-CURRENT-DATE     TO AT-DATE-LAST-ACTION.             
           MOVE WS-C                TO WS-100-CODE-ENTRY-SOURCE.        
           MOVE WS-A                TO AR-CODE-TRAN-TYPE.               
           MOVE ZEROES              TO AR-AMT-ORIG-ENTERED              
                                       AU-AMT-POSTED.                   
           MOVE 113                 TO WS-113-JRNL-FORMAT-NO.           
IF0396*    MOVE WS-CASH-DRAWER-ID   TO WS-113-CASH-DRAWER-USED          13280002
IFTEST     MOVE SPACES              TO WS-113-CASH-DRAWER-USED          
           MOVE PARM-RECV-TYPE      TO WS-RM01-RECEIVABLE-TYPE.         
           MOVE WS-RM01-RECORD-FIELD-DESC TO                            
                                       WS-113-RECORD-FIELD-DESC.        
           MOVE WS-AMT-00-DET-OLD   TO WS-113-AR-DAY-00-WAS.            
           MOVE WS-AMT-30-DET-OLD   TO WS-113-AR-DAY-30-WAS.            
           MOVE WS-AMT-60-DET-OLD   TO WS-113-AR-DAY-60-WAS.            
           MOVE WS-AMT-90-DET-OLD   TO WS-113-AR-DAY-90-WAS.            
           ADD  WS-AMT-00-DET-OLD                                       
                WS-AMT-30-DET-OLD                                       
                WS-AMT-60-DET-OLD                                       
                WS-AMT-90-DET-OLD                                       
                GIVING WS-113-TOTAL-AGED-WAS.                           
           MOVE WS-113-TOTAL-AGED-WAS TO WS-113-TOTAL-AGED-IS.          
           MOVE WS-AMT-00-DET-NEW     TO WS-113-AR-DAY-00-IS.           
           MOVE WS-AMT-30-DET-NEW     TO WS-113-AR-DAY-30-IS.           
           MOVE WS-AMT-60-DET-NEW     TO WS-113-AR-DAY-60-IS.           
           MOVE WS-AMT-90-DET-NEW     TO WS-113-AR-DAY-90-IS.           
IF0395     MOVE PR-REV-DISTRICT-CD    TO WS-113-CODE-REVENUE-DISTRICT.  
           MOVE CU-CODE-EMPL-ACCT     TO WS-113-CODE-EMPL-ACCT.         
           MOVE AT-CODE-COMPANY-ACCT  TO WS-113-CODE-COMPANY-ACCT.      
           MOVE AT-CODE-ACCT-STAT     TO WS-113-CODE-ACCOUNT-STATUS.    
           MOVE PR-CODE-PREMISE-STAT  TO WS-113-CODE-PREMISE-STATUS.    
                                                                        
           IF CU-CODE-EMPL-ACCT EQUAL WS-B                              
              MOVE WS-W               TO WS-100-CODE-TRAN-ERRORS (01)   
           ELSE                                                         
              MOVE WS-R               TO WS-100-CODE-TRAN-ERRORS (01)
           END-IF.  
           MOVE CJF00113              TO WS-100-USER-DEFINED-AREA.      
           MOVE WS-JRNL-ONLY          TO WS-JRNL-OPERATION-RQST.        
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT.             
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
              NEXT SENTENCE                                             
           ELSE                                                         
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
                                                                        
           MOVE AT-ACCOUNT-NO            TO AR-ACCOUNT-NO               
                                            AU-ACCOUNT-NO.              
           MOVE WS-CURRENT-TIMESTAMP     TO AR-TRANS-HIST-SEQ-NO        
                                            AU-TRANS-HIST-SEQ-NO.       
           MOVE SPACES                   TO AR-DATE-ORIG-PYMT.          
           MOVE -1                       TO WS-DATE-ORIG-PYMT-IND.      
           MOVE AT-COMPANY-NO            TO AR-COMPANY-NO.              
           MOVE 'PANEL283'               TO AR-APPL-PROGRAM-ID.         
           MOVE PARM-RESP-AREA-ID        TO AR-RESP-AREA-ID.            
           MOVE WS-COMMENT-LEN           TO AR-TRAN-COMMENT-LEN.        
PCR404     MOVE WS-AMT-00-DET-OLD        TO WS-AMT-00-DET-OLD-N.        
PCR404     MOVE WS-AMT-00-DET-OLD-N      TO WS-AMT-00-DET-OLD-C.        
PCR404     MOVE WS-AMT-30-DET-OLD        TO WS-AMT-30-DET-OLD-N.        
PCR404     MOVE WS-AMT-30-DET-OLD-N      TO WS-AMT-30-DET-OLD-C.        
PCR404     MOVE WS-AMT-60-DET-OLD        TO WS-AMT-60-DET-OLD-N.        
PCR404     MOVE WS-AMT-60-DET-OLD-N      TO WS-AMT-60-DET-OLD-C.        
PCR404     MOVE WS-AMT-90-DET-OLD        TO WS-AMT-90-DET-OLD-N.        
PCR404     MOVE WS-AMT-90-DET-OLD-N      TO WS-AMT-90-DET-OLD-C.        
PCR404     STRING 'ORIG AGE: 0 DAY-', WS-AMT-00-DET-OLD-C,              
PCR404              ',30 DAY-', WS-AMT-30-DET-OLD-C,                    
PCR404              ',60 DAY-', WS-AMT-60-DET-OLD-C,                    
PCR404              ',90 DAY-', WS-AMT-90-DET-OLD-C, '.',               
PCR404              PARM-COMMENT-TEXT                                   
PCR404              DELIMITED BY SIZE INTO AR-TRAN-COMMENT-TEXT.        
PCR404     ADD  +93                      TO AR-TRAN-COMMENT-LEN.        
IF0396*    MOVE ZEROES                   TO AR-TRACE-NO                         
IF0396*                                     AR-PYMT-SEQ-NO                      
IF0396*                                     AR-LOCATION-ID.                     
           MOVE PARM-USER-ID             TO AR-USER-ID.                 
           MOVE SPACES                   TO AR-PYMT-FACILITY-CD         
IF0396*                                     AR-BATCH-NO.                        
IF0396     MOVE WS-01                    TO AR-CASH-COMPANY-NO.         
IF0396     MOVE WS-998                   TO AR-CASH-LOCAL-OFFICE.       
IF0396     MOVE WS-998                   TO AR-CASH-REPORT-NO.          
IF0396     MOVE WS-CURRENT-DATE          TO AR-DATE-CASH-REPORT.        
IF0396     MOVE WS-9999                  TO AR-CASH-DRAWER-ID.          
IF0396     MOVE SPACES                   TO AR-PYMT-REFUNDED-IND.       
           MOVE WS-Y                     TO AR-RECORD-ONLY-FL.          
           IF PARM-RECV-TYPE = 'CNT'                                    
              PERFORM 7700-SELECT-CONTRACT-TYPE THRU 7700-EXIT          
           ELSE                                                         
              MOVE SPACES TO AU-CODE-CONTRACT-TYPE
           END-IF.                     
                                                                        
      ****************************                                              
      * INITIALIZE THE FOLLOWING COLUMN BECAUSE THERE ARE NO                    
      * REAL MONEY INVOLVED                                                     
      ****************************                                              
           MOVE SPACES TO AU-CURRENCY-TYPE.                             
           MOVE ZEROES TO AU-CURRENCY-AMT.                              
                                                                        
           PERFORM 6500-ONLINE-LOAD-AR-TRAN-HIST THRU 6500-EXIT.        
       5400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * JOURNAL THE SUMMARY CONTROL ROW (IF DETAIL ROW HAS NOT     *            
      * BEEN JOURNALED ALREADY.)                                   *            
      **************************************************************            
                                                                        
       5500-JRNL-CNTRL.                                                 
           MOVE '5500'              TO ACTIVE-PARAGRAPH.                
           MOVE AT-TOTAL-AR-BALANCE TO AR-AMT-BILLED-UNPAID             
                                       WS-113-ACCT-AR-BAL-IS            
                                       WS-113-ACCT-AR-BAL-WAS.          
           MOVE WS-F                TO AU-CODE-AR-AGE.                  
           MOVE WS-CURRENT-DATE     TO AR-DATE-TRANS.                   
           MOVE WS-A                TO WS-100-JRNL-SORT-ID.             
           MOVE AT-ACCOUNT-NO       TO WS-100-ACCT-NO.                  
           MOVE AT-CUSTOMER-NO      TO WS-100-CUSTOMER-NO.              
           MOVE EIBTRNID            TO WS-100-CODE-TERMINAL-TRAN.       
           ADD 1                    TO WS-RM-TRAN-APPL-NO.              
           MOVE WS-RM-TRAN-APPL-NO  TO WS-100-JRNL-TRAN-APPL-NO         
                                       AU-TRAN-APPL-NO.                 
           MOVE AT-DATE-LAST-ACTION TO WS-100-DATE-LAST-ACTION          
           MOVE WS-CURRENT-DATE     TO AT-DATE-LAST-ACTION.             
           MOVE WS-ITEM-ID          TO AU-ITEM-ID.                      
           MOVE WS-C                TO WS-100-CODE-ENTRY-SOURCE.        
           MOVE WS-A                TO AR-CODE-TRAN-TYPE.               
           MOVE ZEROES              TO AR-AMT-ORIG-ENTERED              
                                       AU-AMT-POSTED.                   
           MOVE 113                 TO WS-113-JRNL-FORMAT-NO.           
IF0396*    MOVE WS-CASH-DRAWER-ID   TO WS-113-CASH-DRAWER-USED.         13871203
IFTEST     MOVE SPACES              TO WS-113-CASH-DRAWER-USED.         
           MOVE PARM-RECV-TYPE      TO WS-RM01-RECEIVABLE-TYPE.         
           MOVE WS-RM01-RECORD-FIELD-DESC TO                            
                WS-113-RECORD-FIELD-DESC.                               
           MOVE WS-AMT-00-SUMM-OLD  TO WS-113-AR-DAY-00-WAS.            
           MOVE WS-AMT-30-SUMM-OLD  TO WS-113-AR-DAY-30-WAS.            
           MOVE WS-AMT-60-SUMM-OLD  TO WS-113-AR-DAY-60-WAS.            
           MOVE WS-AMT-90-SUMM-OLD  TO WS-113-AR-DAY-90-WAS.            
           ADD  WS-AMT-00-SUMM-OLD                                      
                WS-AMT-30-SUMM-OLD                                      
                WS-AMT-60-SUMM-OLD                                      
                WS-AMT-90-SUMM-OLD                                      
                GIVING WS-113-TOTAL-AGED-WAS.                           
                                                                        
           MOVE WS-113-TOTAL-AGED-WAS TO WS-113-TOTAL-AGED-IS.          
           MOVE WS-AMT-00-SUMM-NEW    TO WS-113-AR-DAY-00-IS.           
           MOVE WS-AMT-30-SUMM-NEW    TO WS-113-AR-DAY-30-IS.           
           MOVE WS-AMT-60-SUMM-NEW    TO WS-113-AR-DAY-60-IS.           
           MOVE WS-AMT-90-SUMM-NEW    TO WS-113-AR-DAY-90-IS.           
           MOVE PR-REV-DISTRICT-CD    TO WS-113-CODE-REVENUE-DISTRICT.  
           MOVE CU-CODE-EMPL-ACCT     TO WS-113-CODE-EMPL-ACCT.         
           MOVE AT-CODE-COMPANY-ACCT  TO WS-113-CODE-COMPANY-ACCT.      
           MOVE AT-CODE-ACCT-STAT     TO WS-113-CODE-ACCOUNT-STATUS.    
           MOVE PR-CODE-PREMISE-STAT  TO WS-113-CODE-PREMISE-STATUS.    
                                                                        
           IF CU-CODE-EMPL-ACCT EQUAL WS-B                              
               MOVE WS-W TO WS-100-CODE-TRAN-ERRORS (01)                
           ELSE                                                         
               MOVE WS-R TO WS-100-CODE-TRAN-ERRORS (01)
           END-IF.               
                                                                        
           MOVE CJF00113     TO WS-100-USER-DEFINED-AREA.               
           MOVE WS-JRNL-ONLY TO WS-JRNL-OPERATION-RQST.                 
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT.             
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
               NEXT SENTENCE                                            
           ELSE                                                         
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
           MOVE AT-ACCOUNT-NO            TO AR-ACCOUNT-NO               
                                            AU-ACCOUNT-NO.              
           MOVE WS-CURRENT-TIMESTAMP     TO AR-TRANS-HIST-SEQ-NO        
                                            AU-TRANS-HIST-SEQ-NO.       
           MOVE SPACES                   TO AR-DATE-ORIG-PYMT.          
           MOVE -1                       TO WS-DATE-ORIG-PYMT-IND.      
           MOVE AT-COMPANY-NO            TO AR-COMPANY-NO.              
           MOVE 'PANEL283'               TO AR-APPL-PROGRAM-ID.         
           MOVE PARM-RESP-AREA-ID        TO AR-RESP-AREA-ID.            
           MOVE WS-COMMENT-LEN           TO AR-TRAN-COMMENT-LEN.        
PCR404     MOVE WS-AMT-00-SUMM-OLD       TO WS-AMT-00-SUMM-OLD-N.       
PCR404     MOVE WS-AMT-00-SUMM-OLD-N     TO WS-AMT-00-SUMM-OLD-C.       
PCR404     MOVE WS-AMT-30-SUMM-OLD       TO WS-AMT-30-SUMM-OLD-N.       
PCR404     MOVE WS-AMT-30-SUMM-OLD-N     TO WS-AMT-30-SUMM-OLD-C.       
PCR404     MOVE WS-AMT-60-SUMM-OLD       TO WS-AMT-60-SUMM-OLD-N.       
PCR404     MOVE WS-AMT-60-SUMM-OLD-N     TO WS-AMT-60-SUMM-OLD-C.       
PCR404     MOVE WS-AMT-90-SUMM-OLD       TO WS-AMT-90-SUMM-OLD-N.       
PCR404     MOVE WS-AMT-90-SUMM-OLD-N     TO WS-AMT-90-SUMM-OLD-C.       
PCR404     STRING 'ORIG AGE: 0 DAY-', WS-AMT-00-SUMM-OLD-C,             
PCR404              ',30 DAY-', WS-AMT-30-SUMM-OLD-C,                   
PCR404              ',60 DAY-', WS-AMT-60-SUMM-OLD-C,                   
PCR404              ',90 DAY-', WS-AMT-90-SUMM-OLD-C, '.',              
PCR404              PARM-COMMENT-TEXT                                   
PCR404              DELIMITED BY SIZE INTO AR-TRAN-COMMENT-TEXT.        
PCR404     ADD  +93                      TO AR-TRAN-COMMENT-LEN.        
IF0396*    MOVE ZEROES                   TO AR-TRACE-NO                         
IF0396*                                     AR-PYMT-SEQ-NO                      
IF0396*                                     AR-LOCATION-ID.                     
           MOVE PARM-USER-ID             TO AR-USER-ID.                 
           MOVE SPACES                   TO AR-PYMT-FACILITY-CD         
IF0396*                                     AR-BATCH-NO.                        
IF0396     MOVE WS-01                      TO AR-CASH-COMPANY-NO.       
IF0396     MOVE WS-998                     TO AR-CASH-LOCAL-OFFICE.     
IF0396     MOVE WS-998                     TO AR-CASH-REPORT-NO.        
IF0396     MOVE WS-CURRENT-DATE            TO AR-DATE-CASH-REPORT.      
IF0396     MOVE WS-9999                    TO AR-CASH-DRAWER-ID.        
IF0396     MOVE SPACES                   TO AR-PYMT-REFUNDED-IND.       
           MOVE WS-Y                     TO AR-RECORD-ONLY-FL.          
           IF PARM-RECV-TYPE = 'CNT'                                    
              PERFORM 7700-SELECT-CONTRACT-TYPE THRU 7700-EXIT          
           ELSE                                                         
              MOVE SPACES TO AU-CODE-CONTRACT-TYPE
           END-IF.                     
                                                                        
      ****************************                                              
      * INITIALIZE THE FOLLOWING COLUMN BECAUSE THERE ARE NO                    
      * REAL MONEY INVOLVED                                                     
      ****************************                                              
           MOVE SPACES TO AU-CURRENCY-TYPE.                             
           MOVE ZEROES TO AU-CURRENCY-AMT.                              
                                                                        
           PERFORM 6500-ONLINE-LOAD-AR-TRAN-HIST THRU 6500-EXIT.        
       5500-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                     10100000
A00956        INCLUDE CPD0006A                                          10110000
           END-EXEC.                                                    10120000
                                                                        
           EXEC SQL                                                     14080002
              INCLUDE CPD00008                                          14090002
           END-EXEC.                                                    14100002
HPCCDM*EJECT                                                            14110002
                                                                        
      ****************************************************************  14112003
      * 6000-SETUP-JOURNAL                                           *  14113003
      * INITIALIZE FIELDS THAT SRE REQUIRED FOR THE MISCALLANEOUS    *  14117003
      * JOURNAL HEADER.                                              *  14118003
      ****************************************************************  14119003
                                                                        
       6000-SETUP-JOURNAL.                                              
           MOVE '6000' TO ACTIVE-PARAGRAPH.                             
                                                                        
           MOVE AT-COMPANY-NO TO WS-100-COMPANY-NO.                     
      *******************************************************           04991280
      * THESE FILEDS WERE POPULATED BY CALLING CPD00020     *           04991389
      * (PARAGRAPH 5970) TO ACCESS APPLICATION TABLE 50.    *           04991499
      *******************************************************           04991580
           MOVE 9             TO WS-TRAN-OPER-LEVEL.                    
           MOVE 1             TO WS-TRAN-OCAP-FIELD.                    
           MOVE 1             TO WS-TRAN-OCAP-VALUE.                    
           MOVE WS-M          TO WS-TRAN-JRNL-TYPE.                     
           MOVE WS-N          TO WS-TRAN-HOLD-EXEMPT-FLAG.              
                                                                        
      *******************************************************           04992280
      * THESE FILEDS WERE POPULATED BY CALLING CPD00021     *           04992389
      * (PARAGRAPH 5980) TO VERIFY USER-ID.                 *           04992489
      *******************************************************           04992580
           MOVE PARM-USER-ID       TO WS-JRNL-OL-TEMP-ID.               
           MOVE WS-JRNL-CK-OPER-ID TO WS-JRNL-OPERATION-RQST.           
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT.             
           MOVE WS-JRNL-OL-OPR-LOC TO WS-TERM-LOC.                      
                                                                        
      *******************************************************           04993180
      * THESE FILEDS WERE POPULATED BY CALLING CPD00022     *           04993289
      * (PARAGRAPH 5990) TO ACCESS CASH DRAWER CONTROL.     *           04993389
      *******************************************************           04993480
IF0396*    IF WS-JRNL-OL-CASH-DRWR-CHECK EQUAL SPACES                   04993689
IF0396*       MOVE WS-A                    TO WS-CASH-DRAWER-ID         04993789
IF0396*    ELSE                                                         04993889
IF0396*       MOVE WS-JRNL-OL-CASH-DRWR-ID TO WS-CASH-DRAWER-ID.        04993989
IF0396*    MOVE WS-CASH-DRAWER             TO WS-JRNL-OL-CASH-DRWR.     04994089
                                                                        
IF0396     MOVE WS-01                      TO WS-JRNL-OL-COMPANY.       
IF0396     MOVE WS-998                     TO WS-JRNL-OL-LOC-OFF.       
IF0396     MOVE WS-998                     TO WS-JRNL-OL-REPORT-NO.     
IF0396     MOVE WS-CURRENT-DATE            TO WS-JRNL-OL-REPORT-DT.     
IF0396     MOVE WS-9999                    TO WS-JRNL-OL-CASH-DRWR.     
           MOVE WS-TERM-LOC                TO WS-JRNL-OL-TERM-LOC       
                                              WS-JRNL-OL-CASH-LOC       
                                              WS-JRNL-OL-OPR-LOC.       
           MOVE WS-JRNL-VALIDATE-OPER TO WS-JRNL-OPERATION-RQST.        
           MOVE WS-C                  TO WS-JRNL-SOURCE-CODE.           
           IF CASH-TRANSACTION                                          
              MOVE WS-JRNL-CASH-UPDATE     TO WS-JRNL-OL-AUTH-TYPE      
           ELSE                                                         
              MOVE WS-JRNL-NON-CASH-UPDATE TO WS-JRNL-OL-AUTH-TYPE
           END-IF.     
           PERFORM 6400-ONLINE-JRNL-ROUTINE  THRU 6400-EXIT.            
                                                                        
           MOVE 'A'                  TO WS-100-JRNL-SORT-ID.            
           MOVE AT-ACCOUNT-NO        TO WS-100-ACCT-NO.                 
           MOVE AT-CUSTOMER-NO       TO WS-100-CUSTOMER-NO.             
           MOVE AT-PREMISE-NO        TO WS-100-PREMISE-NO.              
           MOVE EIBTRNID             TO WS-100-CODE-TERMINAL-TRAN.      
           ADD 1                     TO WS-100-JRNL-TRAN-APPL-NO.       
                                                                        
           MOVE AT-LOCAL-OFFICE      TO WS-100-LOCAL-OFFICE-CD.         
           MOVE WS-CURRENT-DATE      TO WS-100-DATE-LAST-ACTION         
                                        AT-DATE-LAST-ACTION.            
           MOVE WS-C                 TO WS-100-CODE-ENTRY-SOURCE.       
       6000-EXIT.                                                       
             EXIT.                                                      
                                                                        
      ***************************************************************           
      * FETCH DETAILS FROM THE ACCOUNT TABLE                        *           
      ***************************************************************           
                                                                        
       7000-SELECT-ACCOUNT.                                             
           MOVE '7000' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
           SELECT  CODE_COMPANY_ACCT,     DATE_LAST_ACTION,             
                   COMPANY_NO,            PREMISE_NO,                   
                   CODE_ACCT_STAT,        LOCAL_OFFICE,                 
                   TOTAL_AR_BALANCE,      CUSTOMER_NO,                  
                   CAST(SYSDATETIMEOFFSET() AS DATE),          REPLACE(
           REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP(), 121), 
           ' ', '-'), ':', '.')             
           INTO    :AT-CODE-COMPANY-ACCT, :AT-DATE-LAST-ACTION,         
                   :AT-COMPANY-NO,        :AT-PREMISE-NO,               
                   :AT-CODE-ACCT-STAT,    :AT-LOCAL-OFFICE,             
                   :AT-TOTAL-AR-BALANCE,  :AT-CUSTOMER-NO,              
                   :WS-CURRENT-DATE,      :WS-CURRENT-TIMESTAMP         
           FROM    CSS_ACCOUNT                                          
           WHERE   ACCOUNT_NO  = :AT-ACCOUNT-NO                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     10700000
MFA-TR*    SELECT  CODE_COMPANY_ACCT,     DATE_LAST_ACTION,             14490002
MFA-TR*            COMPANY_NO,            PREMISE_NO,                           
MFA-TR*            CODE_ACCT_STAT,        LOCAL_OFFICE,                         
MFA-TR*            TOTAL_AR_BALANCE,      CUSTOMER_NO,                  14500002
MFA-TR*            CURRENT DATE,          CURRENT TIMESTAMP             14120203
MFA-TR*    INTO    :AT-CODE-COMPANY-ACCT, :AT-DATE-LAST-ACTION,         14510002
MFA-TR*            :AT-COMPANY-NO,        :AT-PREMISE-NO,                       
MFA-TR*            :AT-CODE-ACCT-STAT,    :AT-LOCAL-OFFICE,                     
MFA-TR*            :AT-TOTAL-AR-BALANCE,  :AT-CUSTOMER-NO,              14520002
MFA-TR*            :WS-CURRENT-DATE,      :WS-CURRENT-TIMESTAMP                 
MFA-TR*    FROM    CSS_ACCOUNT                                          14530002
MFA-TR*    WHERE   ACCOUNT_NO  = :AT-ACCOUNT-NO                         14540002
MFA-TR*    END-EXEC.                                                    10340000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
                                          NOT-FOUND                     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE SPACES                TO ABEND-TABLES                
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
REARCH        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * FETCH DETAILS FROM THE PREMISE TABLE                        *           
      ***************************************************************           
                                                                        
       7100-SELECT-PREMISE.                                             
           MOVE '7100' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
           SELECT  CODE_PREMISE_STAT,                                   
                   REV_DISTRICT_CD                                      
           INTO    :PR-CODE-PREMISE-STAT,                               
                   :PR-REV-DISTRICT-CD                                  
           FROM    CSS_PREMISE                                          
           WHERE   PREMISE_NO = :AT-PREMISE-NO                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
                                          NOT-FOUND                     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE SPACES                TO ABEND-TABLES                
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
REARCH        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_PREMISE'         TO TABLE-1                     
CBSI          MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
CBSI          MOVE AT-PREMISE-NO         TO HOSTVAR-ELEMENT-1           
CBSI          MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * FETCH DETAILS FROM THE CUSTOMER TABLE                       *           
      ***************************************************************           
                                                                        
       7200-SELECT-CUSTOMER.                                            
           MOVE '7200' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
           SELECT CODE_EMPL_ACCT, CODE_CUST_STATUS                      
           INTO   :CU-CODE-EMPL-ACCT, :CU-CODE-CUST-STATUS              
           FROM   CSS_CUSTOMER                                          
           WHERE  CUSTOMER_NO = :AT-CUSTOMER-NO                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
                                          NOT-FOUND                     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE SPACES                TO ABEND-TABLES                
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
REARCH        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_CUSTOMER'        TO TABLE-1                     
CBSI          MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
              MOVE AT-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1           
CBSI          MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * FETCH CONTROL RECORD FROM THE AR CONTROL TABLE.             *           
      ***************************************************************           
                                                                        
       7300-SELECT-AR-AGE-SUMM.                                         
           MOVE '7300' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
           SELECT AMT_AR_DAY_00, AMT_AR_DAY_30,                         
                  AMT_AR_DAY_60, AMT_AR_DAY_90,                         
                  AMT_UNUSED_CR                                         
           INTO   :WS-AMT-00-SUMM-OLD, :WS-AMT-30-SUMM-OLD,             
                  :WS-AMT-60-SUMM-OLD, :WS-AMT-90-SUMM-OLD,             
                  :AC-AMT-UNUSED-CR                                     
           FROM   CSS_AR_CNTL                                           
           WHERE  ACCOUNT_NO        = :AT-ACCOUNT-NO AND                
                  PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL AND         
                  ITEM_ID           = :WS-ITEM-ID                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
                                          NOT-FOUND                     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE SPACES                TO ABEND-TABLES                
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
REARCH        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
CBSI          MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
CBSI          MOVE 'ITEM_ID'             TO TABLE-ELEMENT-3             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE AC-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-2           
              MOVE WS-ITEM-ID            TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * FETCH DETAIL RECORD FROM THE AR CONTROL TABLE.              *           
      ***************************************************************           
                                                                        
       7400-SELECT-AR-AGE-INFO.                                         
           MOVE '7400' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
           SELECT AMT_AR_DAY_00, AMT_AR_DAY_30,                         
                  AMT_AR_DAY_60, AMT_AR_DAY_90,                         
                  AMT_UNUSED_CR                                         
           INTO   :WS-AMT-00-DET-OLD, :WS-AMT-30-DET-OLD,               
                  :WS-AMT-60-DET-OLD, :WS-AMT-90-DET-OLD,               
                  :AC-AMT-UNUSED-CR                                     
           FROM   CSS_AR_CNTL                                           
           WHERE  ACCOUNT_NO        = :AT-ACCOUNT-NO AND                
                  PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL AND         
                  ITEM_ID           = :WS-ITEM-ID                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE SPACES                TO ABEND-TABLES                
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
REARCH        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
CBSI          MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
CBSI          MOVE 'ITEM_ID'             TO TABLE-ELEMENT-3             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE AC-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-2           
              MOVE WS-ITEM-ID            TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7500-SELECT-GL-NAME.                                             
           MOVE '7500' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL                                                     
               SELECT GL_ACCT_NO                                        
               INTO :GO-GL-ACCT-NO                                      
               FROM CSS_GL_ACCT_NO                                      
MCR310*        WHERE  COMPANY_NO        = :GO-COMPANY-NO                        
MCR310         WHERE  COMPANY_NO        = '01'                          
               AND    GL_ACCT_NAME      = :GO-GL-ACCT-NAME              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE SPACES                TO ABEND-TABLES                
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
REARCH        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'SELECT'              TO ABEND-FUNCTION              
CBSI          MOVE 'CSS_GL_ACCT_NO'      TO TABLE-1                     
CBSI          MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-1             
CBSI          MOVE 'GL_ACCT_NAME'        TO TABLE-ELEMENT-2             
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-3             
              MOVE '01'                  TO HOSTVAR-ELEMENT-1           
              MOVE GO-GL-ACCT-NAME       TO HOSTVAR-ELEMENT-2           
CBSI          MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7700-SELECT-CONTRACT-TYPE.                                       
             MOVE '7700' TO ACTIVE-PARAGRAPH.                           
                                                                        
             EXEC SQL                                                   
                SELECT CODE_CONTRACT_TYPE                               
                INTO   :AU-CODE-CONTRACT-TYPE                           
                FROM   CSS_CONTRACT                                     
                WHERE  ACCOUNT_NO        = :AT-ACCOUNT-NO AND           
                       CNT_ITEM_ID       = :WS-ITEM-ID AND              
                       PYMT_PRIORITY_LVL = :WS-PYMT-PRIORITY-LVL        
             END-EXEC.                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
             MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                     
             IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND
                NEXT SENTENCE                                           
             ELSE                                                       
                MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE            
                MOVE SPACES                TO ABEND-TABLES              
                MOVE SPACES                TO ABEND-SQL-PREDICATES      
REARCH          MOVE PROGRAM-NAME          TO ABEND-PROGRAM             
                MOVE 'SELECT'              TO ABEND-FUNCTION            
                MOVE 'CSS_CONTRACT'        TO TABLE-1                   
CBSI            MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1           
CBSI            MOVE 'CNT_ITEM_ID'         TO TABLE-ELEMENT-2           
CBSI            MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-3           
                MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1         
                MOVE WS-ITEM-ID            TO HOSTVAR-ELEMENT-2         
CBSI            MOVE WS-PYMT-PRIORITY-LVL-C TO HOSTVAR-ELEMENT-3        
                PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT           
                PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
             END-IF.          
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  16263003
      * 7999-SELECT-AL AR LOCKOUT ROUTINE AND TRASFER ROUTINE        *  16265003
      ****************************************************************  16267003
              EXEC SQL                                                  16269003
                 INCLUDE CPD00075                                       16270003
              END-EXEC.                                                 16280003
                                                                        
              EXEC SQL                                                  16269003
                 INCLUDE CPD00307                                       16270003
              END-EXEC.                                                 16280003
                                                                        
      ***************************************************************           
      * UPDATE CONTROL RECORD IN THE AR CONTROL TABLE.              *           
      ***************************************************************           
                                                                        
       8600-UPDATE-AR-CNTRL-SUMM.                                       
           MOVE '8600' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
           UPDATE  CSS_AR_CNTL                                          
           SET     AMT_AR_DAY_00 = :WS-AMT-00-SUMM-NEW,                 
                   AMT_AR_DAY_30 = :WS-AMT-30-SUMM-NEW,                 
                   AMT_AR_DAY_60 = :WS-AMT-60-SUMM-NEW,                 
                   AMT_AR_DAY_90 = :WS-AMT-90-SUMM-NEW                  
           WHERE   ACCOUNT_NO        = :AT-ACCOUNT-NO AND               
                   PYMT_PRIORITY_LVL = :WS-PYMT-PRIORITY-LVL AND        
                   ITEM_ID           = :WS-ITEM-ID                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
                                          NOT-FOUND                     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE SPACES                TO ABEND-TABLES                
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
REARCH        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
CBSI          MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
CBSI          MOVE 'ITEM_ID'             TO TABLE-ELEMENT-3             
CBSI          MOVE 'AMT_AR_DAY_00'       TO TABLE-ELEMENT-4             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
CBSI          MOVE WS-PYMT-PRIORITY-LVL-C TO HOSTVAR-ELEMENT-2          
              MOVE WS-ITEM-ID            TO HOSTVAR-ELEMENT-3           
CBSI          MOVE WS-AMT-00-SUMM-NEW    TO HOSTVAR-ELEMENT-4-N         
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * UPDATE DETAIL RECORD IN THE AR CONTROL TABLE.               *           
      ***************************************************************           
                                                                        
       8700-UPDATE-AR-CNTRL-DET.                                        
           MOVE '8700' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
           UPDATE  CSS_AR_CNTL                                          
           SET     AMT_AR_DAY_00 = :WS-AMT-00-DET-NEW,                  
                   AMT_AR_DAY_30 = :WS-AMT-30-DET-NEW,                  
                   AMT_AR_DAY_60 = :WS-AMT-60-DET-NEW,                  
                   AMT_AR_DAY_90 = :WS-AMT-90-DET-NEW                   
           WHERE   ACCOUNT_NO        = :AT-ACCOUNT-NO AND               
                   PYMT_PRIORITY_LVL = :WS-PYMT-PRIORITY-LVL AND        
                   ITEM_ID           = :WS-ITEM-ID                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
                                          NOT-FOUND                     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE SPACES                TO ABEND-TABLES                
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
REARCH        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
CBSI          MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
CBSI          MOVE 'ITEM_ID'             TO TABLE-ELEMENT-3             
CBSI          MOVE 'AMT_AR_DAY_00'       TO TABLE-ELEMENT-4             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
CBSI          MOVE WS-PYMT-PRIORITY-LVL-C TO HOSTVAR-ELEMENT-2          
              MOVE WS-ITEM-ID            TO HOSTVAR-ELEMENT-3           
CBSI          MOVE WS-AMT-00-DET-NEW     TO HOSTVAR-ELEMENT-4-N         
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
       8700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * UPDATE LAST ACTION DATE ON ACCOUNT TABLE.                   *           
      ***************************************************************           
                                                                        
       8800-UPDATE-ACCOUNT.                                             
           MOVE '8800' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
           UPDATE  CSS_ACCOUNT                                          
           SET     DATE_LAST_ACTION = IIF(TRY_CONVERT(DATE, 
                                                   :AT-DATE-LAST-ACTION
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-LAST-ACTION
              ) <> 0) OR (LEN(:AT-DATE-LAST-ACTION
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-LAST-ACTION
              ), CONVERT(DATE, :AT-DATE-LAST-ACTION) ),             
T21071             LAST_UPDATE_TS   =  CIS.CURRENT$TIMESTAMP()                
           WHERE   ACCOUNT_NO  = :AT-ACCOUNT-NO                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     16032003
MFA-TR*    UPDATE  CSS_ACCOUNT                                          16040002
MFA-TR*    SET     DATE_LAST_ACTION = :AT-DATE-LAST-ACTION,             16050002
MFA-TR*            LAST_UPDATE_TS   =  CURRENT TIMESTAMP                        
MFA-TR*    WHERE   ACCOUNT_NO  = :AT-ACCOUNT-NO                         16060002
MFA-TR*    END-EXEC.                                                    16070002

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
                                          NOT-FOUND                     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE SPACES                TO ABEND-TABLES                
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
REARCH        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
CBSI          MOVE 'DATE_LAST_ACTION'    TO TABLE-ELEMENT-2             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
CBSI          MOVE AT-DATE-LAST-ACTION   TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
       8800-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                        16260002
                                                                        
T21205*                                                                         
T21205*****************************************************************         
T21205*  CALLS THE SUBPROGRAM SCSCA182                                          
T21205*****************************************************************         
T21205*                                                                         
T21205 9200-LINK-SCSCA182.                                              
T21205*                                                                         
T21205     MOVE '9200'                        TO ACTIVE-PARAGRAPH.      
T21205                                                                  
REARCH     CALL MCSCA182  USING  SCSCA182-ACCOUNT-NO                    
REARCH                          ,SCSCA182-RETURN-CODE                   
REARCH                          ,SCSCA182-LAST-UPDATE-TS                
REARCH                          ,ABEND-FILE.                            
REARCH*    EXEC CICS                                                    23990000
REARCH*        HANDLE ABEND CANCEL                                      24000000
REARCH*    END-EXEC.                                                    24010000
REARCH*                                                                 24020000
REARCH*    EXEC CICS LINK                                                       
REARCH*              PROGRAM ('SCSCA182')                                       
REARCH*              COMMAREA (SCSCA182-LINK-RECORD)                            
REARCH*              LENGTH (LENGTH OF SCSCA182-LINK-RECORD)                    
REARCH*    END-EXEC.                                                            
REARCH*                                                                 24080000
REARCH*    EXEC CICS                                                    24090000
REARCH*        HANDLE ABEND LABEL(9250-CALL-ABEND)                      24100000
REARCH*    END-EXEC.                                                    24110000
REARCH*                                                                 24120000
T21205 9200-EXIT.                                                       
T21205     EXIT.                                                        
T21205*                                                                         
T21205******************************************************************        
T21205*  PERFORMS THE ABEND  WHEN THE CICS STATMENT FAILS                       
T21205******************************************************************        
T21205*                                                                         
REARCH*9250-CALL-ABEND.                                                         
T21205*                                                                         
REARCH*    MOVE '9200'                        TO ACTIVE-PARAGRAPH.      23970000
REARCH*    MOVE PROGRAM-NAME                  TO ABEND-PROGRAM.         23970000
REARCH*    MOVE 'LINKFAIL'                    TO ABEND-FUNCTION.        23970000
REARCH*    MOVE WS-100                        TO WS-ACTIVE-RETURN-CODE  23970000
REARCH*                                          SQLCODE.               23970000
REARCH*    PERFORM 9700-PROCESS-ABEND         THRU 9700-EXIT.                   
REARCH*                                                                         
REARCH*9250-EXIT.                                                               
REARCH*    EXIT.                                                                
T21205*                                                                         
      ****************************************************************  16263003
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     16265003
      ****************************************************************  16267003
              EXEC SQL                                                  16269003
REARCH*          INCLUDE CPD00300                                       16270003
REARCH           INCLUDE CPDSP300                                       16270003
              END-EXEC.                                                 16280003
                                                                        
T21205        EXEC SQL                                                          
T21205           INCLUDE CPD0023C                                               
T21205        END-EXEC.                                                         
T21205                                                                  
      ****************************************************************  16310003
      *       END PROGRAM COPYLIB                                       16330003
      ****************************************************************  16360003
REARCH*COPY CPD00302.                                                   16361003
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPD00321                                                  
REARCH     END-EXEC.                                                            
                                                                        
