       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02216.                                         
COB303 DATE-WRITTEN.                                                    
COB303            AUGUST 17, 1994.                                      
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00070099
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080099
      *                                                                *00090099
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100099
      *                                                                *00110099
      *  TRANID:        S216                                           *00120099
      *  PROGRAM:       S216                                           *00130099
      *  CALLING SP:    PA_S216                                        *00140099
      *                                                                *00150099
      ******************************************************************00160099
      *                 P R O G R A M  S U M M A R Y                   *00170099
      *                                                                *00180099
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *00190099
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *00200099
      *                                                                *00210099
      *  THIS PROGRAM UPDATES THE CSS_CUST_MISC_INFO TABLE.            *00220010
      *                                                                *00230099
      ******************************************************************00240099
      *                                                                *00250099
      *                     PROGRAM MODIFICATION LOG                   *00260099
      *                                                                *00270099
      *    DATE    INITIALS   COMMENTS                                 *00280099
      *  --------  --------   ---------------------------------------  *00290099
      *  08/17/94    MLR      CREATED.                                 *00300099
      *  08/23/95    TCB      CHANGED TRANSACTION HISTORY TO CONFORM   *        
      *                       TO COOKBOOK. ADDED UPDATE TO MI-TABLE-ID.*        
CBSI  *  11/05/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *             MADRAS    ABEND PARAMETERS                         *        
C29399*  02/06/04   RR        ADD RISK RATING(LOSS RESERVE CD) AND     *        
C29399*                       DATE CHANGED (LOSS RESRVE EFF DT) TO UPD *        
REARCH*  08/01/05   CVNS      RPC TO COBOL SP CONVERSION               *        
REARCH*             CHENNAI                                            *        
      *                                                                *00310099
T35434*  07/11/07    PA97450  REPLACED CSS_MODEL_SQL WITH SET STMTS    *        
T35434*                       ADDED FOR FETCH ONLY WITH UR FOR CURSOR  *        
T35434*                       SELECTS AND WITH UR FOR SINGELTON SELECTS*        
C34758*  11/16/07   FMB       CORRECT TRANSACTION HISTORY.             *        
P00198*  10/18/09   SC41135   ADDED IVR NDO EXEMPT FLAG                *        
      ******************************************************************00320099
      ******************************************************************00330099
      *                                                                *00340099
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00350099
      *                                                                *00360099
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00370099
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00380099
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00390099
      *  3000 - 4999  NOT USED                                         *00400099
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00410099
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00420099
      *  7000 - 7999  INPUT MODULES                                    *00430099
      *  8000 - 8999  OUTPUT MODULES                                   *00440099
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00450099
      *                                                                *00460099
      ******************************************************************00470099
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02216'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02216 STARTS HERE'.                  
                                                                        
                                                                        
      ******************************************************************00570099
      *    DB2 INCLUDES                                                *00580099
      ******************************************************************00590099
                                                                        
           EXEC SQL                                                     00610099
              INCLUDE SQLCA                                             00620099
           END-EXEC.                                                    00630099
                                                                        
           EXEC SQL                                                     00660099
              INCLUDE TBCSTMSC                                          00670012
           END-EXEC.                                                    00680099
                                                                        
      * ADDED TABLES FOR JOURNALING                                     00700099
                                                                        
           EXEC SQL                                                     00750099
              INCLUDE TBRSAREA                                          01040002
           END-EXEC.                                                    00770099
                                                                        
           EXEC SQL                                                     00790099
              INCLUDE TBMNHIST                                          01102015
           END-EXEC.                                                    00810099
                                                                        
           EXEC SQL                                                     00830099
              INCLUDE TBMNHDT                                           01106015
           END-EXEC.                                                    00850099
                                                                        
C29399     EXEC SQL                                                     00790099
C29399        INCLUDE TBLOSRES                                          01102015
C29399     END-EXEC.                                                    00810099
                                                                        
      ******************************************************************01120099
      *    COBOL WORKING STORAGE COPY BOOKS                            *01130099
      ******************************************************************01140099
                                                                        
           COPY CCA00001.                                               01190099
REARCH     EXEC SQL                                                             
REARCH       INCLUDE CWSX0010                                                   
REARCH     END-EXEC.                                                            
           COPY CWS00027.                                               01210099
           COPY CWS00303.                                               01220099
                                                                        
           EXEC SQL                                                     01250099
              INCLUDE CWS00013                                          01260099
           END-EXEC.                                                    01270099
                                                                        
      ******************************************************************01290099
      *    WORK AREAS                                                  *01300099
      ******************************************************************01310099
                                                                        
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  GTT-NAME                PIC X(26) VALUE                  
REARCH                                       'SESSION.CSR02216_R1'.     
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN          PIC S9(04) COMP.                 
REARCH         49 GTT-ROW-CHAR         PIC X(1024).                     
REARCH     05  GTT-SQLCODE             PIC S9(9) COMP.                  
REARCH                                                                  
REARCH 01  PARM-FIELDS.                                                 
REARCH     05  PARM-CUSTOMER-NO-TEMP   PIC X(10)  VALUE SPACES.         
REARCH     05  PARM-CUSTOMER-NO-RED    REDEFINES PARM-CUSTOMER-NO-TEMP  
REARCH                                 PIC 9(10).                       
REARCH     05  PARM-TRANS-COMMENT.                                      
REARCH         49  PARM-TRANS-COMMENT-LEN     PIC  S9(4) COMP.          
REARCH         49  PARM-TRANS-COMMENT-TEXT    PIC  X(210).              
C29399*    05  PARM-RISK-RATING        PIC S9(4) COMP VALUE 0.                  
C29399*    05  PARM-DATE-CHANGED       PIC X(10) VALUE SPACES.                  
C29399*    05  PARM-COMPANY-NO         PIC X(02) VALUE SPACES.                  
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME            PIC X(08) VALUE 'CSR02216'.      
REARCH     05  WS-SQLSTATE             PIC X(05) VALUE SPACES.          
           05  WS-CUSTOMER-NO          PIC 9(10) VALUE ZERO.            
           05  WS-CUSTOMER-NO-NUM      PIC S9(10) COMP-3 VALUE ZERO.    
           05  WS-CUST-EXISTS-FLAG     PIC X(03) VALUE 'NO '.           
               88  CUST-EXISTS                   VALUE 'YES'.           
           05  WS-NULL-DATE-ALL        PIC S9(04) COMP VALUE -1.        
C29399     05  WS-NULL-DATE-IND        PIC S9(04) COMP VALUE -1.        
           05  WS-TRAN-APPL-NO         PIC S9(04) COMP VALUE +0.        
C29399     05  WS-LOSS-RSRVE-CD-TEXT   PIC X(15) VALUE SPACES.          
C29399     05  WS-PARM-RISK-RTG-TEXT   PIC X(15) VALUE SPACES.          
C29399     05  WS-COMPANY-NO           PIC X(02) VALUE SPACES.          
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-ACTIVE-CODE          PIC X(01) VALUE 'A'.             
                                                                        
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
REARCH                                                                  
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
REARCH     10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
REARCH     10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
REARCH     10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
REARCH         49  S-HOST-VARIABLES-V  PIC X(255).                      
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-STATEMENT-V   PIC X(255).                      
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-DESCRIPTION-V PIC X(255).                      
REARCH                                                                  
REARCH                                                                  
REARCH LINKAGE SECTION.                                                 
REARCH                                                                  
REARCH 01  PARM-CUSTOMER-NO        PIC X(10).                           
REARCH 01  PARM-KEY-CUST           PIC X(02).                           
REARCH 01  PARM-SPECIAL-CUST       PIC X(02).                           
REARCH 01  PARM-INFLUENT-CUST      PIC X(02).                           
REARCH 01  PARM-USER-ID            PIC X(07).                           
REARCH 01  PARM-RESP-AREA-ID       PIC X(03).                           
REARCH 01  PARM-TRANS-CMNT-TEXT    PIC X(210).                          
REARCH 01  PARM-TRANS-CMNT-LEN     PIC S9(4) COMP.                      
REARCH 01  PARM-RISK-RATING        PIC S9(4) COMP.                      
REARCH 01  PARM-DATE-CHANGED       PIC X(10).                           
REARCH 01  PARM-COMPANY-NO         PIC X(02).                           
P00198 01  PARM-IVR-NDO-EXEMPT     PIC X(01).                           
                                                                        
REARCH PROCEDURE DIVISION USING PARM-CUSTOMER-NO                        
REARCH                          PARM-KEY-CUST                           
REARCH                          PARM-SPECIAL-CUST                       
REARCH                          PARM-INFLUENT-CUST                      
REARCH                          PARM-USER-ID                            
REARCH                          PARM-RESP-AREA-ID                       
REARCH                          PARM-TRANS-CMNT-TEXT                    
REARCH                          PARM-TRANS-CMNT-LEN                     
REARCH                          PARM-RISK-RATING                        
REARCH                          PARM-DATE-CHANGED                       
REARCH                          PARM-COMPANY-NO                         
P00198                          PARM-IVR-NDO-EXEMPT.                    
REARCH                                                                  
      ******************************************************************02050099
      * 0000-MAINLINE                                                  *02060099
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *02070099
      ******************************************************************02080099
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02200099
      * 0100-INITIALIZE                                                *02210099
      *                                                                *02220099
      *     1. RESET DB2 ERROR HANDLERS                                *02230099
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *02240099
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *02250099
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*02260099
      *                                                                *02270099
      ******************************************************************02280099
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
REARCH     EXEC SQL                                                     
REARCH          DECLARE C1 CURSOR  FOR                       
REARCH          SELECT                                                  
REARCH               :S-RETURN-CODE         AS RETURN_CODE              
REARCH          FROM                                                    
REARCH               CIS.SYSDUMMY1                                   
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*              :S-RETURN-CODE         AS RETURN_CODE                      
MFA-TR*         FROM                                                            
MFA-TR*              SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02550099
      * 1000-PROCESS-INPUT                                             *02560099
      *                                                                *02570099
      *     1. RECEIVE PARMS.                                          *02580099
      *                                                                *02590099
      ******************************************************************02600099
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
REARCH     MOVE PARM-CUSTOMER-NO          TO PARM-CUSTOMER-NO-TEMP      
           MOVE PARM-CUSTOMER-NO-RED      TO WS-CUSTOMER-NO.            
           MOVE WS-CUSTOMER-NO            TO WS-CUSTOMER-NO-NUM.        
REARCH     MOVE PARM-TRANS-CMNT-LEN       TO PARM-TRANS-COMMENT-LEN.    
REARCH     MOVE PARM-TRANS-CMNT-TEXT      TO PARM-TRANS-COMMENT-TEXT.   
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03220099
      * 2000-PROCESS-OUTPUT.                                           *03230099
      ******************************************************************03240099
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 5000-UPDATE           THRU 5000-EXIT.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH***************************************************************** 05040000
REARCH*2000A-MOVE-RESULT                                              * 05040000
REARCH***************************************************************** 05040000
REARCH 2000A-MOVE-RESULT.                                               
REARCH                                                                  
REARCH     MOVE RS-RETURN-CODE         TO S-RETURN-CODE.                
REARCH                                                                  
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH                                                                  
                                                                        
      ******************************************************************03640099
      * 5000-UPDATE                                                    *03650099
      ******************************************************************03660099
       5000-UPDATE.                                                     
                                                                        
           PERFORM 5010-SELECT-CUST       THRU 5010-EXIT.               
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE 'NO '                     TO WS-CUST-EXISTS-FLAG     
           ELSE                                                         
              MOVE 'YES'                     TO WS-CUST-EXISTS-FLAG     
           END-IF.                                                      
                                                                        
C29399     MOVE PARM-COMPANY-NO          TO WS-COMPANY-NO.              
C29399     PERFORM 5120-GET-TEXT       THRU 5120-EXIT.                  
           PERFORM 5100-MOVE-TRAN-HEAD THRU 5100-EXIT.                  
           PERFORM 5200-MOVE-TRAN-DET  THRU 5200-EXIT.                  
                                                                        
           MOVE PARM-KEY-CUST             TO LQ-KEY-CUSTOMER.           
           MOVE PARM-INFLUENT-CUST        TO LQ-INFLUENTIAL-CUST.       
           MOVE PARM-SPECIAL-CUST         TO LQ-SPECIAL-CUST.           
           MOVE SPACES                    TO LQ-CONSULTING-PROJECT      
                                             LQ-CONSLT-PRJ-END-DT       
                                             LQ-INTR-CO-IND.            
C29399     MOVE PARM-RISK-RATING          TO LQ-LOSS-RESERVE-CD.        
P00198     MOVE PARM-IVR-NDO-EXEMPT       TO LQ-IVR-NDO-EXEMPT.         
                                                                        
C29399     IF PARM-DATE-CHANGED > SPACES THEN                           
C29399        MOVE PARM-DATE-CHANGED      TO LQ-LOSS-RESRVE-EFF-DT      
C29399        MOVE 0                      TO WS-NULL-DATE-IND           
C29399     ELSE                                                         
C29399        MOVE SPACES                 TO LQ-LOSS-RESRVE-EFF-DT      
C29399        MOVE -1                     TO WS-NULL-DATE-IND           
C29399     END-IF.                                                      
                                                                        
           IF CUST-EXISTS                                               
              PERFORM 5140-UPDATE-CUST-STATS THRU 5140-EXIT             
           ELSE                                                         
              PERFORM 5150-INSERT-CUST-STATS THRU 5150-EXIT             
           END-IF.                                                      
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE.               
           MOVE '5000'          TO ACTIVE-PARAGRAPH.                    
REARCH     PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT.                
REARCH     ADD +1                       TO CTR-ROWS.                    
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04290099
      * 5010-SELECT-CUST                                               *04300099
      ******************************************************************04310099
       5010-SELECT-CUST.                                                
                                                                        
           EXEC SQL                                                     
              SELECT 'YES',                                             
                     INFLUENTIAL_CUST,                                  
                     KEY_CUSTOMER,                                      
                     SPECIAL_CUST,                                      
C29399               LOSS_RESERVE_CD,                                   
C29399               LOSS_RESRVE_EFF_DT,                                
P00198               IVR_NDO_EXEMPT                                     
               INTO :WS-CUST-EXISTS-FLAG,                               
                    :LQ-INFLUENTIAL-CUST,                               
                    :LQ-KEY-CUSTOMER,                                   
                    :LQ-SPECIAL-CUST,                                   
C29399              :LQ-LOSS-RESERVE-CD,                                
C29399              :LQ-LOSS-RESRVE-EFF-DT :WS-NULL-DATE-IND,            
P00198              :LQ-IVR-NDO-EXEMPT                                  
               FROM CSS_CUST_MISC_INFO WITH(READUNCOMMITTED)                    
               WHERE CUSTOMER_NO = :WS-CUSTOMER-NO-NUM                  
T35434                                                           
P00198                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     04340099
MFA-TR*       SELECT 'YES',                                             04350099
MFA-TR*              INFLUENTIAL_CUST,                                  04360099
MFA-TR*              KEY_CUSTOMER,                                      04370099
MFA-TR*              SPECIAL_CUST,                                      04380099
MFA-TR*              LOSS_RESERVE_CD,                                           
MFA-TR*              LOSS_RESRVE_EFF_DT,                                        
MFA-TR*              IVR_NDO_EXEMPT                                             
MFA-TR*        INTO :WS-CUST-EXISTS-FLAG,                               04390099
MFA-TR*             :LQ-INFLUENTIAL-CUST,                               04400010
MFA-TR*             :LQ-KEY-CUSTOMER,                                   04410010
MFA-TR*             :LQ-SPECIAL-CUST,                                   04420010
MFA-TR*             :LQ-LOSS-RESERVE-CD,                                        
MFA-TR*             :LQ-LOSS-RESRVE-EFF-DT:WS-NULL-DATE-IND,                    
MFA-TR*             :LQ-IVR-NDO-EXEMPT                                          
MFA-TR*        FROM CSS_CUST_MISC_INFO                                  04430010
MFA-TR*        WHERE CUSTOMER_NO = :WS-CUSTOMER-NO-NUM                  04440099
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 5010                                                     
MFA-TR*    END-EXEC.                                                    04450099

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
C34758     EVALUATE WS-ACTIVE-RETURN-CODE                               
C34758         WHEN SUCCESSFUL-CALL                                     
C34758             IF WS-NULL-DATE-IND < 0                              
C34758                 MOVE SPACES TO LQ-LOSS-RESRVE-EFF-DT             
C34758             END-IF                                               
C34758         WHEN NOT-FOUND                                           
C34758             MOVE SPACES TO LQ-INFLUENTIAL-CUST                   
C34758                            LQ-KEY-CUSTOMER                       
C34758                            LQ-SPECIAL-CUST                       
C34758                            LQ-LOSS-RESRVE-EFF-DT                 
P00198                            LQ-IVR-NDO-EXEMPT                     
C34758         WHEN OTHER                                               
                   MOVE PROGRAM-NAME TO ABEND-PROGRAM                   
                   MOVE '5010'     TO ACTIVE-PARAGRAPH                  
                   MOVE 'SELECT'        TO ABEND-FUNCTION               
                   MOVE 'CSS_CUST_MISC_INFO' TO TABLE-1                 
                   MOVE 'CUSTOMER_NO'   TO TABLE-ELEMENT-1              
                   MOVE WS-CUSTOMER-NO-NUM TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
C34758     END-EVALUATE.                                                
                                                                        
       5010-EXIT.                                                       
           EXIT.                                                        
                                                                        
C29399******************************************************************04660099
C29399* 5120-SELECT-TEXT                                               *04670099
C29399******************************************************************04680099
C29399 5120-GET-TEXT.                                                   
C29399                                                                  
C29399     EXEC SQL                                                     
C29399        SELECT LOSS_RESERVE_TX                                    
C29399          INTO :WS-PARM-RISK-RTG-TEXT                             
C29399          FROM CSS_LOSS_RESERVE WITH(READUNCOMMITTED)                     
C29399         WHERE LOSS_RESERVE_CD = :PARM-RISK-RATING                
C29399           AND COMPANY_NO      = :WS-COMPANY-NO                   
T35434                                                           
P00198                                                      
C29399     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LOSS_RESERVE_TX                                            
MFA-TR*         INTO :WS-PARM-RISK-RTG-TEXT                                     
MFA-TR*         FROM CSS_LOSS_RESERVE                                           
MFA-TR*        WHERE LOSS_RESERVE_CD = :PARM-RISK-RATING                        
MFA-TR*          AND COMPANY_NO      = :WS-COMPANY-NO                           
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 5120                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29399                                                                  
C29399     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C29399     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C29399        NEXT SENTENCE                                             
C29399     ELSE                                                         
C29399        MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
C29399        MOVE '5120'          TO ACTIVE-PARAGRAPH                  
C29399        MOVE 'SELECT'        TO ABEND-FUNCTION                    
C29399        MOVE 'CSS_LOSS_RESERVE'   TO TABLE-1                      
C29399        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C29399        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C29399     END-IF.                                                      
C29399                                                                  
C29399     EXEC SQL                                                     
C29399        SELECT LOSS_RESERVE_TX                                    
C29399          INTO :WS-LOSS-RSRVE-CD-TEXT                             
C29399          FROM CSS_LOSS_RESERVE WITH(READUNCOMMITTED)                     
C29399         WHERE LOSS_RESERVE_CD = :LQ-LOSS-RESERVE-CD              
C29399           AND COMPANY_NO      = :WS-COMPANY-NO                   
T35434                                                           
P00198                                                      
C29399     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LOSS_RESERVE_TX                                            
MFA-TR*         INTO :WS-LOSS-RSRVE-CD-TEXT                                     
MFA-TR*         FROM CSS_LOSS_RESERVE                                           
MFA-TR*        WHERE LOSS_RESERVE_CD = :LQ-LOSS-RESERVE-CD                      
MFA-TR*          AND COMPANY_NO      = :WS-COMPANY-NO                           
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 5121                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29399                                                                  
C29399     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C29399     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C29399        NEXT SENTENCE                                             
C29399     ELSE                                                         
C29399        MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
C29399        MOVE '5120'          TO ACTIVE-PARAGRAPH                  
C29399        MOVE 'SELECT'        TO ABEND-FUNCTION                    
C29399        MOVE 'CSS_LOSS_RESERVE'   TO TABLE-1                      
C29399        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C29399        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C29399     END-IF.                                                      
C29399                                                                  
C29399 5120-EXIT.                                                       
C29399     EXIT.                                                        
C29399                                                                  
      ******************************************************************04660099
      * 5140-UPDATE-CUST-STATS                                         *04670099
      ******************************************************************04680099
       5140-UPDATE-CUST-STATS.                                          
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CUST_MISC_INFO                                 
                 SET INFLUENTIAL_CUST  = :LQ-INFLUENTIAL-CUST,          
                     KEY_CUSTOMER      = :LQ-KEY-CUSTOMER    ,          
                     SPECIAL_CUST      = :LQ-SPECIAL-CUST    ,          
C29399               LOSS_RESERVE_CD   = :LQ-LOSS-RESERVE-CD ,          
C29399               LOSS_RESRVE_EFF_DT =                               
C29399                      IIF(TRY_CONVERT(DATE, 
                                                :LQ-LOSS-RESRVE-EFF-DT 
                                                  :WS-NULL-DATE-IND
              ) IS NULL OR (PATINDEX('%.%', :LQ-LOSS-RESRVE-EFF-DT 
                                                      :WS-NULL-DATE-IND
              ) <> 0) OR (LEN(:LQ-LOSS-RESRVE-EFF-DT :WS-NULL-DATE-IND
              ) <> 10), CIS.CHAR2DATE(:LQ-LOSS-RESRVE-EFF-DT 
                                                      :WS-NULL-DATE-IND
              ), CONVERT(DATE, :LQ-LOSS-RESRVE-EFF-DT :WS-NULL-DATE-IND
              ) ),    
P00198               IVR_NDO_EXEMPT    = :LQ-IVR-NDO-EXEMPT             
               WHERE CUSTOMER_NO = :WS-CUSTOMER-NO-NUM                  
P00198                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     04710099
MFA-TR*       UPDATE CSS_CUST_MISC_INFO                                 04720010
MFA-TR*          SET INFLUENTIAL_CUST  = :LQ-INFLUENTIAL-CUST,          04730010
MFA-TR*              KEY_CUSTOMER      = :LQ-KEY-CUSTOMER    ,          04740010
MFA-TR*              SPECIAL_CUST      = :LQ-SPECIAL-CUST    ,          04750010
MFA-TR*              LOSS_RESERVE_CD   = :LQ-LOSS-RESERVE-CD ,                  
MFA-TR*              LOSS_RESRVE_EFF_DT =                                       
MFA-TR*                     :LQ-LOSS-RESRVE-EFF-DT:WS-NULL-DATE-IND,            
MFA-TR*              IVR_NDO_EXEMPT    = :LQ-IVR-NDO-EXEMPT                     
MFA-TR*        WHERE CUSTOMER_NO = :WS-CUSTOMER-NO-NUM                  04760099
MFA-TR*        QUERYNO 5140                                                     
MFA-TR*    END-EXEC.                                                    04770099

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '5140'          TO ACTIVE-PARAGRAPH                  
              MOVE 'UPDATE'        TO ABEND-FUNCTION                    
              MOVE 'CSS_CUST_MISC_INFO' TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
CBSI          MOVE 'INFLUENTIAL_CUST'   TO TABLE-ELEMENT-2              
CBSI          MOVE 'KEY_CUSTOMER'       TO TABLE-ELEMENT-3              
CBSI          MOVE 'SPECIAL_CUST'       TO TABLE-ELEMENT-4              
              MOVE WS-CUSTOMER-NO-NUM   TO HOSTVAR-ELEMENT-1            
CBSI          MOVE LQ-INFLUENTIAL-CUST  TO HOSTVAR-ELEMENT-2            
CBSI          MOVE LQ-KEY-CUSTOMER      TO HOSTVAR-ELEMENT-3            
CBSI          MOVE LQ-SPECIAL-CUST      TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       5140-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04980099
      * 5150-INSERT-CUST-STATS                                         *04990099
      ******************************************************************05000099
       5150-INSERT-CUST-STATS.                                          
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CUST_MISC_INFO                            
                     ( CUSTOMER_NO,                                     
                       INFLUENTIAL_CUST,                                
                       KEY_CUSTOMER,                                    
                       SPECIAL_CUST,                                    
                       CONSULTING_PROJECT,                              
                       CONSLT_PRJ_END_DT,                               
                       INTR_CO_IND,                                     
C29399                 LOSS_RESERVE_CD,                                 
C29399                 LOSS_RESRVE_EFF_DT,                              
P00198                 IVR_NDO_EXEMPT)                                  
              VALUES (:WS-CUSTOMER-NO-NUM,                              
                      :LQ-INFLUENTIAL-CUST,                             
                      :LQ-KEY-CUSTOMER,                                 
                      :LQ-SPECIAL-CUST,                                 
                      :LQ-CONSULTING-PROJECT,                           
                      IIF(TRY_CONVERT(DATE, :LQ-CONSLT-PRJ-END-DT 
                                            :WS-NULL-DATE-ALL
              ) IS NULL OR (PATINDEX('%.%', :LQ-CONSLT-PRJ-END-DT 
                                                      :WS-NULL-DATE-ALL
              ) <> 0) OR (LEN(:LQ-CONSLT-PRJ-END-DT :WS-NULL-DATE-ALL
              ) <> 10), CIS.CHAR2DATE(:LQ-CONSLT-PRJ-END-DT 
                                                      :WS-NULL-DATE-ALL
              ), CONVERT(DATE, :LQ-CONSLT-PRJ-END-DT :WS-NULL-DATE-ALL
              ) ),           
                      :LQ-INTR-CO-IND,                                  
C29399                :LQ-LOSS-RESERVE-CD,                              
C29399                IIF(TRY_CONVERT(DATE, :LQ-LOSS-RESRVE-EFF-DT 
                                            :WS-NULL-DATE-IND
              ) IS NULL OR (PATINDEX('%.%', :LQ-LOSS-RESRVE-EFF-DT 
                                                      :WS-NULL-DATE-IND
              ) <> 0) OR (LEN(:LQ-LOSS-RESRVE-EFF-DT :WS-NULL-DATE-IND
              ) <> 10), CIS.CHAR2DATE(:LQ-LOSS-RESRVE-EFF-DT 
                                                      :WS-NULL-DATE-IND
              ), CONVERT(DATE, :LQ-LOSS-RESRVE-EFF-DT :WS-NULL-DATE-IND
              ) ),          
P00198                :LQ-IVR-NDO-EXEMPT)                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     05030099
MFA-TR*       INSERT INTO CSS_CUST_MISC_INFO                            05040010
MFA-TR*              ( CUSTOMER_NO,                                     05050099
MFA-TR*                INFLUENTIAL_CUST,                                05310099
MFA-TR*                KEY_CUSTOMER,                                    05320099
MFA-TR*                SPECIAL_CUST,                                    05330099
MFA-TR*                CONSULTING_PROJECT,                              05340099
MFA-TR*                CONSLT_PRJ_END_DT,                               05350099
MFA-TR*                INTR_CO_IND,                                     05440099
MFA-TR*                LOSS_RESERVE_CD,                                         
MFA-TR*                LOSS_RESRVE_EFF_DT,                                      
MFA-TR*                IVR_NDO_EXEMPT)                                          
MFA-TR*       VALUES (:WS-CUSTOMER-NO-NUM,                              05450010
MFA-TR*               :LQ-INFLUENTIAL-CUST,                             05710010
MFA-TR*               :LQ-KEY-CUSTOMER,                                 05720010
MFA-TR*               :LQ-SPECIAL-CUST,                                 05730010
MFA-TR*               :LQ-CONSULTING-PROJECT,                           05740010
MFA-TR*               :LQ-CONSLT-PRJ-END-DT:WS-NULL-DATE-ALL,           05750010
MFA-TR*               :LQ-INTR-CO-IND,                                  05840010
MFA-TR*               :LQ-LOSS-RESERVE-CD,                                      
MFA-TR*               :LQ-LOSS-RESRVE-EFF-DT:WS-NULL-DATE-IND,                  
MFA-TR*               :LQ-IVR-NDO-EXEMPT)                                       
MFA-TR*    END-EXEC.                                                    05850099

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '5150'          TO ACTIVE-PARAGRAPH                  
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_MISC_INFO' TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
CBSI          MOVE 'INFLUENTIAL_CUST'   TO TABLE-ELEMENT-2              
CBSI          MOVE 'KEY_CUSTOMER'       TO TABLE-ELEMENT-3              
CBSI          MOVE 'SPECIAL_CUST'       TO TABLE-ELEMENT-4              
              MOVE WS-CUSTOMER-NO-NUM   TO HOSTVAR-ELEMENT-1            
CBSI          MOVE LQ-INFLUENTIAL-CUST  TO HOSTVAR-ELEMENT-2            
CBSI          MOVE LQ-KEY-CUSTOMER      TO HOSTVAR-ELEMENT-3            
CBSI          MOVE LQ-SPECIAL-CUST      TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       5150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************   06031015
      * MOVE FIELDS TO THE MAINTENANCE TRANSACTION HEADER AND       *   06032015
      * CALL COMMON PARAGRAPH FOR WRITING A ROW.                    *   06033015
      ***************************************************************   06034015
       5100-MOVE-TRAN-HEAD.                                             
           EXEC SQL                                                     
T35434        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :MH-TRANS-HIST-SEQ-NO            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     06036015
MFA-TR*       SET :MH-TRANS-HIST-SEQ-NO  = CURRENT TIMESTAMP                    
MFA-TR*    END-EXEC.                                                    06039215

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SPACES  TO ABEND-TABLES                             
               MOVE SPACES  TO ABEND-SQL-PREDICATES                     
               MOVE PROGRAM-NAME TO ABEND-PROGRAM                       
CBSI           MOVE '5100'               TO ACTIVE-PARAGRAPH            
T35434         MOVE 'SET'  TO ABEND-FUNCTION                            
CBSI           MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1             
CBSI           MOVE WS-CUSTOMER-NO-NUM   TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
           EXEC SQL                                                     
T35434        SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-DATE-TRANS                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     06180099
MFA-TR*       SET :MH-DATE-TRANS= CURRENT DATE                                  
MFA-TR*    END-EXEC.                                                    06220099

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SPACES  TO ABEND-TABLES                             
               MOVE SPACES  TO ABEND-SQL-PREDICATES                     
               MOVE PROGRAM-NAME TO ABEND-PROGRAM                       
CBSI           MOVE '5100'               TO ACTIVE-PARAGRAPH            
T35434         MOVE 'SET'             TO ABEND-FUNCTION                 
CBSI           MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1             
CBSI           MOVE WS-CUSTOMER-NO-NUM   TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
           MOVE 'F'               TO MH-CODE-TRAN-TYPE.                 
           MOVE PARM-RESP-AREA-ID TO MH-RESP-AREA-ID.                   
           MOVE ZEROS              TO MH-ACCOUNT-NO.                    
           MOVE WS-CUSTOMER-NO-NUM TO MH-CUSTOMER-NO.                   
           MOVE ZEROES             TO MH-PREMISE-NO.                    
           MOVE PARM-USER-ID       TO MH-USER-ID.                       
           MOVE 'PANEL249'         TO MH-APPL-PROGRAM-ID.               
           MOVE PARM-TRANS-COMMENT TO MH-TRAN-COMMENT.                  
                                                                        
         5100-EXIT.                                                     
             EXIT.                                                      
                                                                        
      ***************************************************************   06044017
      * MOVE FIELDS TO THE MAINTENANCE TRANSACTION DETAIL AND       *   06044117
      * CALL COMMON PARAGRAPH FOR WRITING A ROW.                    *   06044217
      ***************************************************************   06044317
         5200-MOVE-TRAN-DET.                                            
             MOVE '5200' TO ACTIVE-PARAGRAPH.                           
             MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.         
             MOVE 1 TO WS-TRAN-APPL-NO MI-TRAN-APPL-NO.                 
             IF PARM-KEY-CUST    NOT = LQ-KEY-CUSTOMER                  
                 MOVE +15 TO MI-PRV-COLUMN-VALUE-LEN                    
                             MI-CHG-COLUMN-VALUE-LEN                    
C34758           IF PARM-KEY-CUST > ' '                                 
C34758               MOVE PARM-KEY-CUST TO MI-CHG-COLUMN-VALUE-TEXT     
C34758           ELSE                                                   
C34758               MOVE '*DELETED*'   TO MI-CHG-COLUMN-VALUE-TEXT     
C34758           END-IF                                                 
C34758           IF LQ-KEY-CUSTOMER > ' '                               
C34758               MOVE LQ-KEY-CUSTOMER TO MI-PRV-COLUMN-VALUE-TEXT   
C34758           ELSE                                                   
C34758               MOVE '*NEW*'         TO MI-PRV-COLUMN-VALUE-TEXT   
C34758           END-IF                                                 
                 MOVE 'KEY CUSTOMER   ' TO MI-COLUMN-DESC               
                 MOVE 'D3'              TO MI-TABLE-ID                  
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1 TO WS-TRAN-APPL-NO                               
             END-IF.                                                    
                                                                        
             MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                    
             IF PARM-SPECIAL-CUST NOT = LQ-SPECIAL-CUST                 
                 MOVE +15 TO MI-PRV-COLUMN-VALUE-LEN                    
                             MI-CHG-COLUMN-VALUE-LEN                    
C34758           IF PARM-SPECIAL-CUST > ' '                             
C34758               MOVE PARM-SPECIAL-CUST TO MI-CHG-COLUMN-VALUE-TEXT 
C34758           ELSE                                                   
C34758               MOVE '*DELETED*'   TO MI-CHG-COLUMN-VALUE-TEXT     
C34758           END-IF                                                 
C34758           IF LQ-SPECIAL-CUST > ' '                               
C34758               MOVE LQ-SPECIAL-CUST TO MI-PRV-COLUMN-VALUE-TEXT   
C34758           ELSE                                                   
C34758               MOVE '*NEW*'         TO MI-PRV-COLUMN-VALUE-TEXT   
C34758           END-IF                                                 
                 MOVE 'SPECIAL CUST   ' TO MI-COLUMN-DESC               
                 MOVE 'D2'              TO MI-TABLE-ID                  
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1 TO WS-TRAN-APPL-NO                               
             END-IF.                                                    
                                                                        
             MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                    
             IF PARM-INFLUENT-CUST    NOT = LQ-INFLUENTIAL-CUST         
                 MOVE +15 TO MI-PRV-COLUMN-VALUE-LEN                    
                             MI-CHG-COLUMN-VALUE-LEN                    
C34758           IF PARM-INFLUENT-CUST > ' '                            
C34758               MOVE PARM-INFLUENT-CUST TO MI-CHG-COLUMN-VALUE-TEXT
C34758           ELSE                                                   
C34758               MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT
C34758           END-IF                                                 
C34758           IF LQ-INFLUENTIAL-CUST > ' '                           
C34758              MOVE LQ-INFLUENTIAL-CUST TO MI-PRV-COLUMN-VALUE-TEXT
C34758           ELSE                                                   
C34758              MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT
C34758           END-IF                                                 
                 MOVE 'INFLUENT CUST' TO MI-COLUMN-DESC                 
                 MOVE 'D4'            TO MI-TABLE-ID                    
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1 TO WS-TRAN-APPL-NO                               
             END-IF.                                                    
                                                                        
C29399       MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                    
C29399       IF PARM-RISK-RATING      NOT = LQ-LOSS-RESERVE-CD          
C29399           MOVE +15 TO MI-PRV-COLUMN-VALUE-LEN                    
C29399                       MI-CHG-COLUMN-VALUE-LEN                    
C34758           IF PARM-RISK-RATING > 0                                
C34758               MOVE WS-PARM-RISK-RTG-TEXT TO                      
C34758                    MI-CHG-COLUMN-VALUE-TEXT                      
C34758           ELSE                                                   
C34758               MOVE '*DELETED*'        TO MI-CHG-COLUMN-VALUE-TEXT
C34758           END-IF                                                 
C34758           IF LQ-LOSS-RESERVE-CD > 0                              
C34758               MOVE WS-LOSS-RSRVE-CD-TEXT TO                      
C34758                    MI-PRV-COLUMN-VALUE-TEXT                      
C34758           ELSE                                                   
C34758               MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT           
C34758           END-IF                                                 
C29399           MOVE 'RISK RATING' TO MI-COLUMN-DESC                   
C29399           MOVE '  '            TO MI-TABLE-ID                    
C29399           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
C29399           ADD 1 TO WS-TRAN-APPL-NO                               
C29399       END-IF.                                                    
                                                                        
C29399       MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                    
C29399       IF PARM-DATE-CHANGED     NOT = LQ-LOSS-RESRVE-EFF-DT       
C29399           MOVE +10 TO MI-PRV-COLUMN-VALUE-LEN                    
C29399                       MI-CHG-COLUMN-VALUE-LEN                    
C34758           IF PARM-DATE-CHANGED > ' '                             
C34758               MOVE PARM-DATE-CHANGED TO MI-CHG-COLUMN-VALUE-TEXT 
C34758           ELSE                                                   
C34758               MOVE '*DELETED*'       TO MI-CHG-COLUMN-VALUE-TEXT 
C34758           END-IF                                                 
C34758           IF LQ-LOSS-RESRVE-EFF-DT > ' '                         
C34758               MOVE LQ-LOSS-RESRVE-EFF-DT TO                      
C34758                    MI-PRV-COLUMN-VALUE-TEXT                      
C34758           ELSE                                                   
C34758               MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT           
C34758           END-IF                                                 
C29399           MOVE 'DATE CHANGED' TO MI-COLUMN-DESC                  
C29399           MOVE '  '            TO MI-TABLE-ID                    
C29399           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
C29399           ADD 1 TO WS-TRAN-APPL-NO                               
C29399       END-IF.                                                    
                                                                        
P00198       MOVE WS-TRAN-APPL-NO TO MI-TRAN-APPL-NO                    
P00198       IF PARM-IVR-NDO-EXEMPT   NOT = LQ-IVR-NDO-EXEMPT           
P00198           MOVE +9  TO MI-PRV-COLUMN-VALUE-LEN                    
P00198                       MI-CHG-COLUMN-VALUE-LEN                    
P00198           IF PARM-IVR-NDO-EXEMPT > ' '                           
P00198              MOVE PARM-IVR-NDO-EXEMPT TO MI-CHG-COLUMN-VALUE-TEXT
P00198           ELSE                                                   
P00198               MOVE '*DELETED*'       TO MI-CHG-COLUMN-VALUE-TEXT 
P00198           END-IF                                                 
P00198           IF LQ-IVR-NDO-EXEMPT > ' '                             
P00198               MOVE LQ-IVR-NDO-EXEMPT   TO                        
P00198                    MI-PRV-COLUMN-VALUE-TEXT                      
P00198           ELSE                                                   
P00198               MOVE '*NEW*' TO MI-PRV-COLUMN-VALUE-TEXT           
P00198           END-IF                                                 
P00198           MOVE 'IVR NDO EXEMPT' TO MI-COLUMN-DESC                
P00198           MOVE '  '            TO MI-TABLE-ID                    
P00198           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
P00198           ADD 1 TO WS-TRAN-APPL-NO                               
P00198       END-IF.                                                    
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06850099
      * INCLUDE PROGRAM TO ADD TRANSACTION HISTORY.                    *06048515
      ******************************************************************06870099
           EXEC SQL                                                     06880007
              INCLUDE CPD00067                                          06048815
           END-EXEC.                                                    06900007
                                                                        
      ******************************************************************06930099
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     06940099
      ******************************************************************06950099
REARCH     EXEC SQL                                                             
REARCH          INCLUDE CPDSP300                                                
REARCH     END-EXEC.                                                            
      ******************************************************************07000099
      *       END PROGRAM COPYLIB                                      *07010099
      ******************************************************************07020099
REARCH     EXEC SQL                                                     16360000
REARCH          INCLUDE CPD00321                                        16360000
REARCH     END-EXEC.                                                    16360000
