       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR02205.                                     
COB303 DATE-WRITTEN.  JUNE 20, 2005                                     
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
      *                                                                *00110000
      *  TRANID:        S205                                           *00120000
      *  PROGRAM:       S205                                           *00130000
      *  CALLING SP:    PA_S205                                        *00140000
      *                                                                *00150000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *  THIS PROCEDURE GENERATES ADDRESS-ID AND UPDATES TABLES        *00190000
      *  CUST_ADDR_XREF AND ADDR_FREEFORM FOR A GIVEN CUSTOMER         *00200000
      ******************************************************************00210000
      *                                                                *00220000
      *                     PROGRAM MODIFICATION LOG                   *00230000
      *                                                                *00240000
      *    DATE    INITIALS   COMMENTS                                 *00250000
      *  --------  --------   ---------------------------------------  *00260000
      *  07/25/94    MAK      PROCEDURE ORIGINALLY CODED.              *00270000
      *  08/17/94    MAK      MODIFIED RPC FOR MISCALLANEOUS JOURNALS  *00280000
      *  09/13/94    MRB      ADD CSS_RESP_AREA, AND CSS_PREMISE TABLE *00290000
      *                       INCLUDES FOR JOURNALING.                 *00300000
      *  05/11/94    SK       MODIFIED TO INCLUDE ADDRESS-ID GENERATION*00310000
      *                       CUST-ADDR-XREF AND ADDR-FREEFORM TABLE   *00320000
      *                       UPDATES                                  *00330000
      *  08/21/95    TCB      CHANGED THE COLUMN DESCRIPTIONS FOR      *00331000
      *                       TRANSACTION HISTORY TO FIT THE X(15)     *00332000
      *                       MI-COLUMN-DESC FIELD.                    *00333000
*T4158*  09/05/96    AG       TPR 4158    GET NEW ADDRESS-ID FROM      *00334000
      *                       COPYBOOK CPD00090.                       *00335000
CBSI  *  11/09/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *00335100
CBSI  *             MADRAS    ABEND PARAMETERS                         *00336000
REARCH*  06/20/05   CVNS      RPC TO COBOL SP CONVERSION.              *00337000
REARCH*             CHENNAI                                            *00338000
T35434*  10/07/07    PA97450  REPLACED CSS_MODEL_SQL WITH SET STMTS    *00338100
T35434*                       AND ADDED FOR FETCH ONLY WITH UR FOR     *00338200
T35434*                       CURSOR SELECTS AND WITH UR FOR SINGELTON *00338300
T35434*                       SELECTS.                                 *00338400
T36932*  06/29/08   SV85244   INCREASE LENGTH OF CITY_STATE            *00338500
T36932*                       AND ADDR_STREET FIELDS                   *00338600
A37666*  04/28/10   FMB       COMMENT OUT ADDRESS DELETE.              *00338700
A03360*  05/06/11   FMB       HANDLE ZERO MAIL ADDRESS ID.             *00338800
A03263*  11/13/11   FMB       DELETE PRIOR TO INSERT OF                 00338900
A03263*                       CSS_CUST_ADDR_XREF TO PREVENT CRM -803    00339000
P00704*  09/04/13   FMB       HANDLE FORMATTED CORRENSPONDENCE         *00339100
P00704*                       ADDRESSES.                               *00339200
      ******************************************************************00340000
      ******************************************************************00350000
      *                                                                *00360000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00370000
      *                                                                *00380000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00390000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00400000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00410000
      *  3000 - 4999  NOT USED                                         *00420000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00430000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00440000
      *  7000 - 7999  INPUT MODULES                                    *00450000
      *  8000 - 8999  OUTPUT MODULES                                   *00460000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00470000
      *                                                                *00480000
      ******************************************************************00490000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02205'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02205 STARTS HERE'.                  
                                                                        
      ******************************************************************00580000
      *    DB2 INCLUDES                                                *00590000
      ******************************************************************00600000
                                                                        
           EXEC SQL                                                     00620000
              INCLUDE SQLCA                                             00630000
           END-EXEC.                                                    00640000
                                                                        
           EXEC SQL                                                     00660000
              INCLUDE TBADDRID                                          00670000
           END-EXEC.                                                    00680000
                                                                        
           EXEC SQL                                                     00691000
              INCLUDE TBUSRPRF                                          00692000
           END-EXEC.                                                    00693000
                                                                        
           EXEC SQL                                                     00700000
              INCLUDE TBCSADRX                                          00710000
           END-EXEC.                                                    00720000
                                                                        
           EXEC SQL                                                     00740000
              INCLUDE TBADRFRE                                          00750000
           END-EXEC.                                                    00760000
                                                                        
P00704     EXEC SQL                                                     00771003
P00704        INCLUDE TBADRFMT                                          00772003
P00704     END-EXEC.                                                    00773003
                                                                        
P00704     EXEC SQL                                                     00775004
P00704        INCLUDE TBZIPCD                                           00776004
P00704     END-EXEC.                                                    00777004
                                                                        
           EXEC SQL                                                     00780000
              INCLUDE TBBSCSTS                                          00790000
           END-EXEC.                                                    00800000
                                                                        
           EXEC SQL                                                     00820000
              INCLUDE TBMNHIST                                          00830000
           END-EXEC.                                                    00840000
                                                                        
           EXEC SQL                                                     00860000
              INCLUDE TBMNHDT                                           00870000
           END-EXEC.                                                    00880000
                                                                        
      ******************************************************************00940000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00950000
      ******************************************************************00960000
                                                                        
           COPY CCA00001.                                               01000000
           COPY CWS00027.                                               01020000
REARCH     EXEC SQL                                                     01021000
REARCH        INCLUDE CWSX0010                                          01022000
REARCH     END-EXEC.                                                    01023000
           COPY CWS00303.                                               01030000
                                                                        
           EXEC SQL                                                     01050000
              INCLUDE CWS00013                                          01060000
           END-EXEC.                                                    01070000
                                                                        
*T4158     EXEC SQL                                                     01081000
*T4158        INCLUDE CWS00071                                          01082000
*T4158     END-EXEC.                                                    01083000
                                                                        
*T4158     EXEC SQL                                                     01085000
*T4158        INCLUDE CWS0090A                                          01086000
*T4158     END-EXEC.                                                    01087000
                                                                        
      ******************************************************************01090000
      *    WORK AREAS                                                  *01100000
      ******************************************************************01110000
                                                                        
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME             PIC X(08) VALUE 'CSR02205'.     
           05  WS-CUSTOMER-NO           PIC X(10) VALUE SPACES.         
           05  WS-CUSTOMER-NO-NUM       PIC 9(10).                      
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  WS-MAIL-EXISTS-FLAG      PIC X(01) VALUE 'N'.            
               88 MAIL-EXISTS                     VALUE 'Y'.            
           05  WS-PREV-EXISTS-FLAG      PIC X(01) VALUE 'N'.            
               88 PREV-EXISTS                     VALUE 'Y'.            
           05  WS-HOME-EXISTS-FLAG      PIC X(01) VALUE 'N'.            
               88 HOME-EXISTS                     VALUE 'Y'.            
           05  WS-BUS-EXISTS-FLAG       PIC X(01) VALUE 'N'.            
               88 BUS-EXISTS                      VALUE 'Y'.            
           05  WS-BLANK-PARM-MAIL       PIC X(01) VALUE 'N'.            
           05  WS-BLANK-PARM-PREV       PIC X(01) VALUE 'N'.            
           05  WS-BLANK-PARM-HOME       PIC X(01) VALUE 'N'.            
           05  WS-ACTION-FLAG           PIC X(01) VALUE SPACES.         
P00704     05  WS-ADDRESS-FORMAT        PIC X(01) VALUE SPACES.         
           05  WS-TRAN-APPL-NO          PIC 9(04).                      
           05  PARM-TRAN-COMMENT.                                       
               49  PARM-TRAN-COMMENT-LEN                                
                                   PIC S9(04) COMP SYNC VALUE +0.       
               49  PARM-TRAN-COMMENT-TEXT PIC X(210) VALUE SPACES.      
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
           05  RS-MAIL-ADDRESS-ID       PIC X(13) VALUE SPACES.         
           05  RS-PREV-ADDRESS-ID       PIC X(13) VALUE SPACES.         
           05  RS-HOME-ADDRESS-ID       PIC X(13) VALUE SPACES.         
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE            PIC S9(9) COMP VALUE 0.         
REARCH     05  S-MAIL-ADDRESS-ID        PIC X(13) VALUE SPACES.         
REARCH     05  S-PREV-ADDRESS-ID        PIC X(13) VALUE SPACES.         
REARCH     05  S-HOME-ADDRESS-ID        PIC X(13) VALUE SPACES.         
                                                                        
REARCH LINKAGE SECTION.                                                 
REARCH 01  PARM-MAIL-UPD-FLAG         PIC X(01).                        
REARCH 01  PARM-PREV-UPD-FLAG         PIC X(01).                        
REARCH 01  PARM-HOME-UPD-FLAG         PIC X(01).                        
REARCH 01  PARM-CUSTOMER-NO           PIC X(10).                        
REARCH 01  PARM-MAIL-ADDRESS-ID       PIC X(13).                        
T36932 01  PARM-MAIL-STREET           PIC X(55).                        
T36932 01  PARM-MAIL-CITY-STATE       PIC X(30).                        
REARCH 01  PARM-MAIL-ZIP-CODE         PIC X(09).                        
REARCH 01  PARM-MAIL-ADDRESS-OVERFLOW PIC X(35).                        
REARCH 01  PARM-PREV-ADDRESS-ID       PIC X(13).                        
T36932 01  PARM-PREV-STREET           PIC X(55).                        
T36932 01  PARM-PREV-CITY-STATE       PIC X(30).                        
REARCH 01  PARM-PREV-ZIP-CODE         PIC X(09).                        
REARCH 01  PARM-PREV-ADDRESS-OVERFLOW PIC X(35).                        
REARCH 01  PARM-HOME-ADDRESS-ID       PIC X(13).                        
REARCH 01  PARM-HOME-OFFICE-NAME      PIC X(50).                        
T36932 01  PARM-HOME-STREET           PIC X(55).                        
T36932 01  PARM-HOME-CITY-STATE       PIC X(30).                        
REARCH 01  PARM-HOME-ZIP-CODE         PIC X(09).                        
REARCH 01  PARM-HOME-ADDRESS-OVERFLOW PIC X(35).                        
REARCH 01  PARM-USER-ID               PIC X(09).                        
REARCH 01  PARM-RESP-AREA-ID          PIC X(03).                        
REARCH 01  PARM-TRAN-CMNT-LEN         PIC S9(04) COMP.                  
REARCH 01  PARM-TRAN-CMNT-TXT         PIC X(210).                       
                                                                        
REARCH PROCEDURE DIVISION USING PARM-MAIL-UPD-FLAG                      
REARCH                          PARM-PREV-UPD-FLAG                      
REARCH                          PARM-HOME-UPD-FLAG                      
REARCH                          PARM-CUSTOMER-NO                        
REARCH                          PARM-MAIL-ADDRESS-ID                    
REARCH                          PARM-MAIL-STREET                        
REARCH                          PARM-MAIL-CITY-STATE                    
REARCH                          PARM-MAIL-ZIP-CODE                      
REARCH                          PARM-MAIL-ADDRESS-OVERFLOW              
REARCH                          PARM-PREV-ADDRESS-ID                    
REARCH                          PARM-PREV-STREET                        
REARCH                          PARM-PREV-CITY-STATE                    
REARCH                          PARM-PREV-ZIP-CODE                      
REARCH                          PARM-PREV-ADDRESS-OVERFLOW              
REARCH                          PARM-HOME-ADDRESS-ID                    
REARCH                          PARM-HOME-OFFICE-NAME                   
REARCH                          PARM-HOME-STREET                        
REARCH                          PARM-HOME-CITY-STATE                    
REARCH                          PARM-HOME-ZIP-CODE                      
REARCH                          PARM-HOME-ADDRESS-OVERFLOW              
REARCH                          PARM-USER-ID                            
REARCH                          PARM-RESP-AREA-ID                       
REARCH                          PARM-TRAN-CMNT-LEN                      
REARCH                          PARM-TRAN-CMNT-TXT.                     
                                                                        
      ******************************************************************02000000
      * 0000-MAINLINE                                                  *02010000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *02020000
      ******************************************************************02030000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02150000
      * 0100-INITIALIZE                                                *02160000
      *                                                                *02170000
      *     1. RESET DB2 ERROR HANDLERS                                *02180000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *02190000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *02200000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*02210000
      *                                                                *02220000
      ******************************************************************02230000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARCH             :S-RETURN-CODE      AS  RETURN_CODE                  
REARCH            ,:S-MAIL-ADDRESS-ID  AS  MAIL_ADDRESS_ID              
REARCH            ,:S-PREV-ADDRESS-ID  AS  PREV_ADDRESS_ID              
REARCH            ,:S-HOME-ADDRESS-ID  AS  HOME_ADDRESS_ID              
REARCH         FROM                                                     
REARCH             CIS.SYSDUMMY1                                     
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                     02471000
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        02472000
MFA-TR*        SELECT                                                   02473000
MFA-TR*            :S-RETURN-CODE      AS  RETURN_CODE                  02474000
MFA-TR*           ,:S-MAIL-ADDRESS-ID  AS  MAIL_ADDRESS_ID              02474100
MFA-TR*           ,:S-PREV-ADDRESS-ID  AS  PREV_ADDRESS_ID              02474200
MFA-TR*           ,:S-HOME-ADDRESS-ID  AS  HOME_ADDRESS_ID              02474300
MFA-TR*        FROM                                                     02475000
MFA-TR*            SYSIBM.SYSDUMMY1                                     02476000
MFA-TR*    END-EXEC.                                                    02477000
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02510000
      * 1000-PROCESS-INPUT                                             *02520000
      *                                                                *02530000
      *     1. RECEIVE PARMS.                                          *02540000
      *                                                                *02550000
      ******************************************************************02560000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
REARCH     MOVE PARM-TRAN-CMNT-LEN        TO PARM-TRAN-COMMENT-LEN.     
REARCH     MOVE PARM-TRAN-CMNT-TXT        TO PARM-TRAN-COMMENT-TEXT.    
A03360     IF PARM-MAIL-ADDRESS-ID NOT NUMERIC                          
A03360         MOVE ZEROES TO PARM-MAIL-ADDRESS-ID
           END-IF.                     
A03360     IF PARM-PREV-ADDRESS-ID NOT NUMERIC                          
A03360         MOVE ZEROES TO PARM-PREV-ADDRESS-ID
           END-IF.                     
A03360     IF PARM-HOME-ADDRESS-ID NOT NUMERIC                          
A03360         MOVE ZEROES TO PARM-HOME-ADDRESS-ID
           END-IF.                     
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05190000
      * 2000-PROCESS-OUTPUT.                                           *05200000
      *                                                                *05210000
      *     1. DESCRIBE RESULT SET                                     *05220000
      *     2. UPDATE DB2 DATA                                         *05230000
      *     3. BUILD RESULT SET                                        *05240000
      *     4. SEND RESULT SET                                         *05250000
      *                                                                *05260000
      ******************************************************************05270000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 5000-UPDATE          THRU 5000-EXIT.                 
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
REARCH     PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT                 
REARCH     ADD +1                       TO   CTR-ROWS.                  
REARCH*    PERFORM 8100-SEND-RESULT     THRU 8100-EXIT.                 05340000
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************05381000
REARCH*2000A-MOVE-RESULT.                                               05382000
REARCH******************************************************************05383000
REARCH 2000A-MOVE-RESULT.                                               
REARCH                                                                  
REARCH     MOVE RS-RETURN-CODE         TO S-RETURN-CODE.                
REARCH     MOVE RS-MAIL-ADDRESS-ID     TO S-MAIL-ADDRESS-ID.            
REARCH     MOVE RS-PREV-ADDRESS-ID     TO S-PREV-ADDRESS-ID.            
REARCH     MOVE RS-HOME-ADDRESS-ID     TO S-HOME-ADDRESS-ID.            
REARCH                                                                  
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
      ******************************************************************05730000
      * 5000-UPDATE                                                    *05740000
      *                                                                *05750000
      *  1. DETERMINE ADDRESS TYPES THAT WERE UPDATED                  *05760000
      *  2. JOURNAL CHANGES                                            *05770000
      *  3. UPDATE MODIFIED ROWS                                       *05780000
      ******************************************************************05790000
                                                                        
       5000-UPDATE.                                                     
                                                                        
           MOVE PARM-CUSTOMER-NO TO WS-CUSTOMER-NO                      
                                    WS-CUSTOMER-NO-NUM.                 
                                                                        
           MOVE WS-CUSTOMER-NO-NUM TO DM-CUSTOMER-NO                    
                                      BS-CUSTOMER-NO.                   
                                                                        
           PERFORM 7300-GET-TIMESTAMP THRU 7300-EXIT.                   
                                                                        
           MOVE 'F'                    TO MH-CODE-TRAN-TYPE.            
           MOVE 'PANEL030'             TO MH-APPL-PROGRAM-ID.           
           MOVE PARM-USER-ID           TO MH-USER-ID.                   
           MOVE PARM-RESP-AREA-ID      TO MH-RESP-AREA-ID.              
           IF PARM-TRAN-COMMENT-TEXT = SPACES                           
              MOVE ZERO                TO MH-TRAN-COMMENT-LEN           
           ELSE                                                         
              MOVE PARM-TRAN-COMMENT-LEN  TO MH-TRAN-COMMENT-LEN        
           END-IF.                                                      
           MOVE PARM-TRAN-COMMENT-TEXT TO MH-TRAN-COMMENT-TEXT.         
           MOVE ZERO                   TO MH-ACCOUNT-NO.                
           MOVE WS-CUSTOMER-NO-NUM     TO MH-CUSTOMER-NO.               
           MOVE ZERO                   TO MH-PREMISE-NO.                
           MOVE MH-TRANS-HIST-SEQ-NO   TO MI-TRANS-HIST-SEQ-NO.         
           MOVE 1 TO WS-TRAN-APPL-NO.                                   
                                                                        
           IF PARM-MAIL-UPD-FLAG = 'Y'                                  
P00704        PERFORM 7400-GET-ADDR-FORMAT THRU 7400-EXIT               
              MOVE PARM-MAIL-ADDRESS-ID       TO DZ-ADDRESS-ID          
                                                 DY-ADDRESS-ID          
              PERFORM 6200-JOURNAL-MAIL       THRU 6200-EXIT            
              MOVE PARM-MAIL-STREET           TO DZ-ADDR-STREET         
              MOVE PARM-MAIL-CITY-STATE       TO DZ-ADDR-CITY-STATE     
              MOVE PARM-MAIL-ZIP-CODE         TO DZ-ADDR-ZIP-CODE       
              MOVE SPACES                     TO DZ-ADDR-COUNTRY        
              MOVE PARM-MAIL-ADDRESS-OVERFLOW TO DZ-ADDRESS-OVERFLOW    
              MOVE 'M'            TO DM-ADDRESS-TYPE                    
                                                                        
              PERFORM 5100-UPDATE-TABLES THRU 5100-EXIT                 
              IF WS-ACTION-FLAG = 'I' OR 'U'                            
                 MOVE DZ-ADDRESS-ID           TO RS-MAIL-ADDRESS-ID     
              ELSE                                                      
                 MOVE SPACES                  TO RS-MAIL-ADDRESS-ID     
              END-IF                                                    
           ELSE                                                         
              MOVE PARM-MAIL-ADDRESS-ID       TO RS-MAIL-ADDRESS-ID     
           END-IF.                                                      
                                                                        
           IF PARM-PREV-UPD-FLAG = 'Y'                                  
              MOVE PARM-PREV-ADDRESS-ID       TO DZ-ADDRESS-ID          
              PERFORM 6000-JOURNAL-PREV       THRU 6000-EXIT            
              MOVE PARM-PREV-STREET           TO DZ-ADDR-STREET         
              MOVE PARM-PREV-CITY-STATE       TO DZ-ADDR-CITY-STATE     
              MOVE PARM-PREV-ZIP-CODE         TO DZ-ADDR-ZIP-CODE       
              MOVE SPACES                     TO DZ-ADDR-COUNTRY        
              MOVE PARM-PREV-ADDRESS-OVERFLOW TO DZ-ADDRESS-OVERFLOW    
              MOVE 'P'            TO DM-ADDRESS-TYPE                    
                                                                        
              PERFORM 5100-UPDATE-TABLES THRU 5100-EXIT                 
              IF WS-ACTION-FLAG = 'I' OR 'U'                            
                 MOVE DZ-ADDRESS-ID           TO RS-PREV-ADDRESS-ID     
              ELSE                                                      
                 MOVE SPACES                  TO RS-PREV-ADDRESS-ID     
              END-IF                                                    
           ELSE                                                         
              MOVE PARM-PREV-ADDRESS-ID       TO RS-PREV-ADDRESS-ID     
           END-IF.                                                      
                                                                        
           IF PARM-HOME-UPD-FLAG = 'Y'                                  
              MOVE 'H'                        TO DM-ADDRESS-TYPE        
              MOVE PARM-HOME-ADDRESS-ID       TO DZ-ADDRESS-ID          
              PERFORM 6100-JOURNAL-HOME       THRU 6100-EXIT            
              MOVE PARM-HOME-STREET           TO DZ-ADDR-STREET         
              MOVE PARM-HOME-CITY-STATE       TO DZ-ADDR-CITY-STATE     
              MOVE PARM-HOME-ZIP-CODE         TO DZ-ADDR-ZIP-CODE       
              MOVE SPACES                     TO DZ-ADDR-COUNTRY        
              MOVE PARM-HOME-ADDRESS-OVERFLOW TO DZ-ADDRESS-OVERFLOW    
              MOVE PARM-HOME-OFFICE-NAME TO BS-HOME-OFFICE-NAME         
                                                                        
              PERFORM 5100-UPDATE-TABLES THRU 5100-EXIT                 
              IF WS-ACTION-FLAG = 'I' OR 'U'                            
                 MOVE DZ-ADDRESS-ID           TO RS-HOME-ADDRESS-ID     
              ELSE                                                      
                 MOVE SPACES                  TO RS-HOME-ADDRESS-ID     
              END-IF                                                    
                                                                        
              IF BUS-EXISTS                                             
                 PERFORM 8850-UPDATE-BUS-STATS THRU 8850-EXIT           
              ELSE                                                      
                 IF PARM-HOME-OFFICE-NAME > ' '                         
                    MOVE SPACES TO BS-BUSINESS-TYPE-CD                  
                                   BS-TAX-ID                            
                                   BS-ALIAS                             
                                   BS-INTRA-CO-IND                      
                                   BS-SUBSIDIARY-IND                    
                                   BS-TRADE-ALLY-IND                    
                                   BS-CONTRACTOR-TYPE                   
                    MOVE PARM-HOME-OFFICE-NAME TO BS-HOME-OFFICE-NAME   
                    PERFORM 8800-INSERT-BUS-STATS THRU 8800-EXIT        
                 END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              MOVE PARM-HOME-ADDRESS-ID       TO RS-HOME-ADDRESS-ID     
           END-IF.                                                      
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************   06600000
      * 5100-UPDATE-TABLES                                          *   06610000
      ***************************************************************   06620000
                                                                        
       5100-UPDATE-TABLES.                                              
                                                                        
           IF WS-ACTION-FLAG = 'I'                                      
*T4158        MOVE 'PANEL030'                    TO WS-90-PANEL-NO      
*T4158        MOVE PARM-USER-ID                  TO WS-90-USERID        
*T4158        MOVE ZEROES                        TO WS-90-ACCOUNT-NO    
*T4158        MOVE PARM-CUSTOMER-NO              TO WS-90-CUSTOMER-NO   
*T4158        MOVE ZEROES                        TO WS-90-PREMISE-NO    
                                                                        
*T4158        PERFORM 6202-GET-NEW-ADDRESS-ID    THRU 6202-EXIT         
*T4158        MOVE WS-90-NEW-ADDRESS-ID          TO I8-ADDRESS-ID       
              MOVE WS-CUSTOMER-NO-NUM TO DM-CUSTOMER-NO                 
              MOVE I8-ADDRESS-ID      TO DM-ADDRESS-ID                  
                                         DZ-ADDRESS-ID                  
              MOVE 'B'                TO DM-ADDRESS-FORMAT              
              PERFORM 8500-INSERT-ADDR-FREE THRU 8500-EXIT              
A03263        PERFORM 8400-DELETE-ADDR-XREF THRU 8400-EXIT              
              PERFORM 8300-INSERT-ADDR-XREF THRU 8300-EXIT              
           ELSE                                                         
              IF WS-ACTION-FLAG = 'U'                                   
                 PERFORM 8600-UPDATE-ADDR-FREE THRU 8600-EXIT           
              ELSE                                                      
                 IF WS-ACTION-FLAG = 'D'                                
                    MOVE WS-CUSTOMER-NO-NUM TO DM-CUSTOMER-NO           
                    PERFORM 8400-DELETE-ADDR-XREF THRU 8400-EXIT        
A37666*             PERFORM 8700-DELETE-ADDR-FREE THRU 8700-EXIT        06830000
                 END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 06910000
      * 6000-JOURNAL-PREV                                             * 06920000
      *                                                               * 06930000
      *  1. DETERMINE IF THE ADDRESS RECORD TO BE INSERTED, UPDATED   * 06940000
      *     OR DELETED.                                               * 06950000
      *  2. JOURNAL EACH FIELD THAT HAS CHANGED.                      * 06960000
      *                                                               * 06970000
      ***************************************************************** 06980000
                                                                        
       6000-JOURNAL-PREV.                                               
                                                                        
A03360     IF PARM-PREV-ADDRESS-ID = SPACES OR ZEROES                   
              MOVE 'N' TO WS-PREV-EXISTS-FLAG                           
              MOVE SPACES TO DZ-ADDR-STREET, DZ-ADDR-CITY-STATE,        
                             DZ-ADDR-ZIP-CODE, DZ-ADDR-COUNTRY,         
                             DZ-ADDRESS-OVERFLOW                        
           ELSE                                                         
              PERFORM 7100-SELECT-ADDR-FREE THRU 7100-EXIT              
              MOVE 'Y' TO WS-PREV-EXISTS-FLAG                           
           END-IF.                                                      
                                                                        
           IF PARM-PREV-STREET           > ' ' OR                       
              PARM-PREV-CITY-STATE       > ' ' OR                       
              PARM-PREV-ZIP-CODE         > ' ' OR                       
              PARM-PREV-ADDRESS-OVERFLOW > ' '                          
              MOVE 'N' TO WS-BLANK-PARM-PREV                            
           ELSE                                                         
              MOVE 'Y' TO WS-BLANK-PARM-PREV                            
           END-IF.                                                      
                                                                        
           IF WS-BLANK-PARM-PREV = 'Y'                                  
              IF PREV-EXISTS                                            
                 MOVE 'D' TO WS-ACTION-FLAG                             
                 PERFORM 6030-JOURNAL-PREV-DELETE THRU 6030-EXIT        
              ELSE                                                      
                 MOVE ' ' TO WS-ACTION-FLAG                             
              END-IF                                                    
           ELSE                                                         
              IF PREV-EXISTS                                            
                 MOVE 'U' TO WS-ACTION-FLAG                             
                 PERFORM 6020-JOURNAL-PREV-UPDATE THRU 6020-EXIT        
              ELSE                                                      
                 MOVE 'I' TO WS-ACTION-FLAG                             
                 PERFORM 6010-JOURNAL-PREV-INSERT THRU 6010-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
                                                                        
       6000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 07420000
      * 6010-JOURNAL-PREV-INSERT                                      * 07430000
      *                                                               * 07440000
      *     TO CREATE JOURNAL ENTRIES WHEN RECORD IS INSERTED IN      * 07450000
      *     ADDR-FREEFORM TABLE FOR PREVIOUS ADDRESS FOR A CUSTOMER   * 07460000
      ***************************************************************** 07470000
                                                                        
       6010-JOURNAL-PREV-INSERT.                                        
                                                                        
           MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
           MOVE 'PRV ADR STREET'         TO MI-COLUMN-DESC.             
           MOVE 5                        TO MI-PRV-COLUMN-VALUE-LEN.    
T36932     MOVE 55                       TO MI-CHG-COLUMN-VALUE-LEN.    
           MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT.   
           MOVE PARM-PREV-STREET         TO MI-CHG-COLUMN-VALUE-TEXT.   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
           MOVE 'PRV ADR CITY ST'        TO MI-COLUMN-DESC.             
           MOVE 5                        TO MI-PRV-COLUMN-VALUE-LEN.    
T36932     MOVE 30                       TO MI-CHG-COLUMN-VALUE-LEN.    
           MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT.   
           MOVE PARM-PREV-CITY-STATE     TO MI-CHG-COLUMN-VALUE-TEXT.   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           IF PARM-PREV-ZIP-CODE = SPACES                               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE 'PRV ADR ZIPCODE'     TO MI-COLUMN-DESC              
              MOVE 5                     TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE 9                     TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE PARM-PREV-ZIP-CODE    TO MI-CHG-COLUMN-VALUE-TEXT    
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF PARM-PREV-ADDRESS-OVERFLOW = SPACES                       
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE 'PRV ADR OVRFLOW'        TO MI-COLUMN-DESC           
              MOVE 5                        TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE 35                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE PARM-PREV-ADDRESS-OVERFLOW                           
                                         TO MI-CHG-COLUMN-VALUE-TEXT    
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
       6010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 07910000
      * 6020-JOURNAL-PREV-UPDATE                                      * 07920000
      *                                                               * 07930000
      *     TO CREATE JOURNAL ENTRIES WHEN RECORD IS UPDATED IN       * 07940000
      *     ADDR-FREEFORM TABLE FOR PREVIOUS ADDRESS FOR A CUSTOMER   * 07950000
      ***************************************************************** 07960000
                                                                        
       6020-JOURNAL-PREV-UPDATE.                                        
                                                                        
           IF PARM-PREV-STREET = DZ-ADDR-STREET                         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO              
              MOVE 'PRV ADR STREET'     TO MI-COLUMN-DESC               
T36932        MOVE 55                   TO MI-PRV-COLUMN-VALUE-LEN      
T36932                                     MI-CHG-COLUMN-VALUE-LEN      
              MOVE DZ-ADDR-STREET       TO MI-PRV-COLUMN-VALUE-TEXT     
              MOVE PARM-PREV-STREET     TO MI-CHG-COLUMN-VALUE-TEXT     
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF PARM-PREV-CITY-STATE = DZ-ADDR-CITY-STATE                 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE 'PRV ADR CITY ST'      TO MI-COLUMN-DESC             
T36932        MOVE 30                     TO MI-PRV-COLUMN-VALUE-LEN    
T36932                                       MI-CHG-COLUMN-VALUE-LEN    
              MOVE DZ-ADDR-CITY-STATE     TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE PARM-PREV-CITY-STATE   TO MI-CHG-COLUMN-VALUE-TEXT   
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF PARM-PREV-ZIP-CODE = DZ-ADDR-ZIP-CODE                     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO              
              MOVE 'PRV ADR ZIPCODE'    TO MI-COLUMN-DESC               
              MOVE 9                    TO MI-PRV-COLUMN-VALUE-LEN      
                                           MI-CHG-COLUMN-VALUE-LEN      
              MOVE DZ-ADDR-ZIP-CODE     TO MI-PRV-COLUMN-VALUE-TEXT     
              MOVE PARM-PREV-ZIP-CODE   TO MI-CHG-COLUMN-VALUE-TEXT     
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF PARM-PREV-ADDRESS-OVERFLOW = DZ-ADDRESS-OVERFLOW          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'PRV ADR OVRFLOW'       TO MI-COLUMN-DESC            
              MOVE 35                   TO MI-PRV-COLUMN-VALUE-LEN      
                                           MI-CHG-COLUMN-VALUE-LEN      
              MOVE DZ-ADDRESS-OVERFLOW  TO MI-PRV-COLUMN-VALUE-TEXT     
              MOVE PARM-PREV-ADDRESS-OVERFLOW                           
                                        TO MI-CHG-COLUMN-VALUE-TEXT     
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
       6020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 08560000
      * 6030-JOURNAL-PREV-DELETE                                      * 08570000
      *                                                               * 08580000
      *     TO CREATE JOURNAL ENTRIES WHEN RECORD IS DELETED FROM     * 08590000
      *     ADDR-FREEFORM TABLE FOR PREVIOUS ADDRESS FOR A CUSTOMER   * 08600000
      ***************************************************************** 08610000
                                                                        
       6030-JOURNAL-PREV-DELETE.                                        
                                                                        
           MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
           MOVE 'PRV ADR STREET'         TO MI-COLUMN-DESC.             
T36932     MOVE 55                       TO MI-PRV-COLUMN-VALUE-LEN.    
           MOVE 9                        TO MI-CHG-COLUMN-VALUE-LEN.    
           MOVE DZ-ADDR-STREET           TO MI-PRV-COLUMN-VALUE-TEXT.   
           MOVE '*DELETED*'              TO MI-CHG-COLUMN-VALUE-TEXT.   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
           MOVE 'PRV ADR CITY ST'        TO MI-COLUMN-DESC.             
T36932     MOVE 30                       TO MI-PRV-COLUMN-VALUE-LEN.    
           MOVE 9                        TO MI-CHG-COLUMN-VALUE-LEN.    
           MOVE DZ-ADDR-CITY-STATE       TO MI-PRV-COLUMN-VALUE-TEXT.   
           MOVE '*DELETED*'              TO MI-CHG-COLUMN-VALUE-TEXT.   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           IF DZ-ADDR-ZIP-CODE = SPACES                                 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE 'PRV ADR ZIPCODE'     TO MI-COLUMN-DESC              
              MOVE 9                     TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE 9                     TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE DZ-ADDR-ZIP-CODE      TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT    
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DZ-ADDRESS-OVERFLOW = SPACES                              
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'PRV ADR OVRFLOW'       TO MI-COLUMN-DESC            
              MOVE 35                      TO MI-PRV-COLUMN-VALUE-LEN   
              MOVE 9                       TO MI-CHG-COLUMN-VALUE-LEN   
              MOVE DZ-ADDRESS-OVERFLOW     TO MI-PRV-COLUMN-VALUE-TEXT  
              MOVE '*DELETED*'             TO MI-CHG-COLUMN-VALUE-TEXT  
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
       6030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 08770000
      * 6100-JOURNAL-HOME                                             * 08780000
      *                                                               * 08790000
      *  1. DETERMINE IF THE ADDRESS RECORD TO BE INSERTED, UPDATED   * 08800000
      *     OR DELETED FOR HOME OFFICE DETAILS.                       * 08810000
      *  2. JOURNAL EACH FIELD THAT HAS CHANGED.                      * 08820000
      *                                                               * 08830000
      ***************************************************************** 08840000
                                                                        
       6100-JOURNAL-HOME.                                               
                                                                        
A03360     IF PARM-HOME-ADDRESS-ID = SPACES OR ZEROES                   
              MOVE 'N' TO WS-HOME-EXISTS-FLAG                           
              MOVE SPACES TO DZ-ADDR-STREET, DZ-ADDR-CITY-STATE,        
                             DZ-ADDR-ZIP-CODE, DZ-ADDR-COUNTRY,         
                             DZ-ADDRESS-OVERFLOW                        
           ELSE                                                         
              PERFORM 7100-SELECT-ADDR-FREE THRU 7100-EXIT              
              MOVE 'Y' TO WS-HOME-EXISTS-FLAG                           
           END-IF.                                                      
                                                                        
           PERFORM 7200-SELECT-BUS-STATS THRU 7200-EXIT.                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE 'Y' TO WS-BUS-EXISTS-FLAG                            
           ELSE                                                         
              MOVE 'N' TO WS-BUS-EXISTS-FLAG                            
              MOVE SPACES TO BS-HOME-OFFICE-NAME                        
           END-IF.                                                      
                                                                        
           IF PARM-HOME-STREET           > ' ' OR                       
              PARM-HOME-CITY-STATE       > ' ' OR                       
              PARM-HOME-ZIP-CODE         > ' ' OR                       
              PARM-HOME-ADDRESS-OVERFLOW > ' '                          
              MOVE 'N' TO WS-BLANK-PARM-HOME                            
           ELSE                                                         
              MOVE 'Y' TO WS-BLANK-PARM-HOME                            
           END-IF.                                                      
                                                                        
           IF WS-BLANK-PARM-HOME = 'Y'                                  
              IF HOME-EXISTS                                            
                 MOVE 'D' TO WS-ACTION-FLAG                             
                 PERFORM 6130-JOURNAL-HOME-DELETE THRU 6130-EXIT        
              ELSE                                                      
                 MOVE ' ' TO WS-ACTION-FLAG                             
              END-IF                                                    
           ELSE                                                         
              IF HOME-EXISTS                                            
                 MOVE 'U' TO WS-ACTION-FLAG                             
                 PERFORM 6120-JOURNAL-HOME-UPDATE THRU 6120-EXIT        
              ELSE                                                      
                 MOVE 'I' TO WS-ACTION-FLAG                             
                 PERFORM 6110-JOURNAL-HOME-INSERT THRU 6110-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF PARM-HOME-OFFICE-NAME = BS-HOME-OFFICE-NAME               
              NEXT SENTENCE                                             
           ELSE                                                         
              PERFORM 6140-JOURNAL-HOME-OFFICE THRU 6140-EXIT           
           END-IF.                                                      
                                                                        
       6100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 09420000
      * 6110-JOURNAL-HOME-INSERT                                      * 09430000
      *                                                               * 09440000
      *     TO CREATE JOURNAL ENTRIES WHEN RECORD IS INSERTED IN      * 09450000
      *     ADDR-FREEFORM TABLE FOR HOME OFF ADDRESS FOR A CUSTOMER   * 09460000
      ***************************************************************** 09470000
                                                                        
       6110-JOURNAL-HOME-INSERT.                                        
                                                                        
           MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
           MOVE 'HME ADR STREET'         TO MI-COLUMN-DESC.             
           MOVE 5                        TO MI-PRV-COLUMN-VALUE-LEN.    
T36932     MOVE 55                       TO MI-CHG-COLUMN-VALUE-LEN.    
           MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT.   
           MOVE PARM-HOME-STREET         TO MI-CHG-COLUMN-VALUE-TEXT.   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
           MOVE 'HME ADR CITY ST'        TO MI-COLUMN-DESC.             
           MOVE 5                        TO MI-PRV-COLUMN-VALUE-LEN.    
T36932     MOVE 30                       TO MI-CHG-COLUMN-VALUE-LEN.    
           MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT.   
           MOVE PARM-HOME-CITY-STATE     TO MI-CHG-COLUMN-VALUE-TEXT.   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           IF PARM-HOME-ZIP-CODE = SPACES                               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE 'HME ADR ZIPCODE'     TO MI-COLUMN-DESC              
              MOVE 5                     TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE 9                     TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE PARM-HOME-ZIP-CODE    TO MI-CHG-COLUMN-VALUE-TEXT    
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF PARM-HOME-ADDRESS-OVERFLOW = SPACES                       
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE 'HME ADR OVRFLOW'        TO MI-COLUMN-DESC           
              MOVE 5                        TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE 35                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE PARM-HOME-ADDRESS-OVERFLOW                           
                                         TO MI-CHG-COLUMN-VALUE-TEXT    
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
       6110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 09910000
      * 6120-JOURNAL-HOME-UPDATE                                      * 09920000
      *                                                               * 09930000
      *     TO CREATE JOURNAL ENTRIES WHEN RECORD IS UPDATED IN       * 09940000
      *     ADDR-FREEFORM TABLE FOR HOME OFF.ADDRESS FOR A CUSTOMER   * 09950000
      ***************************************************************** 09960000
                                                                        
       6120-JOURNAL-HOME-UPDATE.                                        
                                                                        
           IF PARM-HOME-STREET = DZ-ADDR-STREET                         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO              
              MOVE 'HME ADR STREET'     TO MI-COLUMN-DESC               
T36932        MOVE 55                   TO MI-PRV-COLUMN-VALUE-LEN      
T36932                                     MI-CHG-COLUMN-VALUE-LEN      
              MOVE DZ-ADDR-STREET       TO MI-PRV-COLUMN-VALUE-TEXT     
              MOVE PARM-HOME-STREET     TO MI-CHG-COLUMN-VALUE-TEXT     
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF PARM-HOME-CITY-STATE = DZ-ADDR-CITY-STATE                 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE 'HME ADR CITY ST'      TO MI-COLUMN-DESC             
T36932        MOVE 30                     TO MI-PRV-COLUMN-VALUE-LEN    
T36932                                       MI-CHG-COLUMN-VALUE-LEN    
              MOVE DZ-ADDR-CITY-STATE     TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE PARM-HOME-CITY-STATE   TO MI-CHG-COLUMN-VALUE-TEXT   
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF PARM-HOME-ZIP-CODE = DZ-ADDR-ZIP-CODE                     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO              
              MOVE 'HME ADR ZIPCODE'    TO MI-COLUMN-DESC               
              MOVE 9                    TO MI-PRV-COLUMN-VALUE-LEN      
                                           MI-CHG-COLUMN-VALUE-LEN      
              MOVE DZ-ADDR-ZIP-CODE     TO MI-PRV-COLUMN-VALUE-TEXT     
              MOVE PARM-HOME-ZIP-CODE   TO MI-CHG-COLUMN-VALUE-TEXT     
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF PARM-HOME-ADDRESS-OVERFLOW = DZ-ADDRESS-OVERFLOW          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'HME ADR OVRFLOW'    TO MI-COLUMN-DESC               
              MOVE 35                   TO MI-PRV-COLUMN-VALUE-LEN      
                                           MI-CHG-COLUMN-VALUE-LEN      
              MOVE DZ-ADDRESS-OVERFLOW  TO MI-PRV-COLUMN-VALUE-TEXT     
              MOVE PARM-HOME-ADDRESS-OVERFLOW                           
                                        TO MI-CHG-COLUMN-VALUE-TEXT     
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
       6120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 10560000
      * 6130-JOURNAL-HOME-DELETE                                      * 10570000
      *                                                               * 10580000
      *     TO CREATE JOURNAL ENTRIES WHEN RECORD IS DELETED FROM     * 10590000
      *     ADDR-FREEFORM TABLE FOR PREVIOUS ADDRESS FOR A CUSTOMER   * 10600000
      ***************************************************************** 10610000
                                                                        
       6130-JOURNAL-HOME-DELETE.                                        
                                                                        
           MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
           MOVE 'HME ADR STREET'         TO MI-COLUMN-DESC.             
T36932     MOVE 55                       TO MI-PRV-COLUMN-VALUE-LEN.    
           MOVE 9                        TO MI-CHG-COLUMN-VALUE-LEN.    
           MOVE DZ-ADDR-STREET           TO MI-PRV-COLUMN-VALUE-TEXT.   
           MOVE '*DELETED*'              TO MI-CHG-COLUMN-VALUE-TEXT.   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
           MOVE 'HME ADR CITY ST'        TO MI-COLUMN-DESC.             
T36932     MOVE 30                       TO MI-PRV-COLUMN-VALUE-LEN.    
           MOVE 9                        TO MI-CHG-COLUMN-VALUE-LEN.    
           MOVE DZ-ADDR-CITY-STATE       TO MI-PRV-COLUMN-VALUE-TEXT.   
           MOVE '*DELETED*'              TO MI-CHG-COLUMN-VALUE-TEXT.   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           IF DZ-ADDR-ZIP-CODE = SPACES                                 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE 'HME ADR ZIPCODE'     TO MI-COLUMN-DESC              
              MOVE 9                     TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE 9                     TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE DZ-ADDR-ZIP-CODE      TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT    
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DZ-ADDRESS-OVERFLOW = SPACES                              
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'HME ADR OVRFLOW'       TO MI-COLUMN-DESC            
              MOVE 35                      TO MI-PRV-COLUMN-VALUE-LEN   
              MOVE 9                       TO MI-CHG-COLUMN-VALUE-LEN   
              MOVE DZ-ADDRESS-OVERFLOW     TO MI-PRV-COLUMN-VALUE-TEXT  
              MOVE '*DELETED*'             TO MI-CHG-COLUMN-VALUE-TEXT  
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
       6130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  10770000
      * 6140-JOURNAL-HOME-OFFICE                                     *  10780000
      *                                                              *  10790000
      *      CREATE JOURNAL ENTRIES FOR CHANGES MADE TO HOME-OFFICE- *  10800000
      *      NAME IN CSS-BUS-CUST-STATS TABLE                        *  10810000
      ****************************************************************  10820000
                                                                        
       6140-JOURNAL-HOME-OFFICE.                                        
                                                                        
           MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO                 
           MOVE 'HME ADR NAME'       TO MI-COLUMN-DESC                  
           IF BS-HOME-OFFICE-NAME = SPACES                              
              MOVE 5                     TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE 50                    TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE PARM-HOME-OFFICE-NAME TO MI-CHG-COLUMN-VALUE-TEXT    
           ELSE                                                         
              IF PARM-HOME-OFFICE-NAME = SPACES                         
                 MOVE 50                  TO MI-PRV-COLUMN-VALUE-LEN    
                 MOVE 9                   TO MI-CHG-COLUMN-VALUE-LEN    
                 MOVE BS-HOME-OFFICE-NAME TO MI-PRV-COLUMN-VALUE-TEXT   
                 MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT   
              ELSE                                                      
                 MOVE 50                  TO MI-PRV-COLUMN-VALUE-LEN    
                                          MI-CHG-COLUMN-VALUE-LEN       
                 MOVE BS-HOME-OFFICE-NAME TO MI-PRV-COLUMN-VALUE-TEXT   
                 MOVE PARM-HOME-OFFICE-NAME                             
                                      TO MI-CHG-COLUMN-VALUE-TEXT       
              END-IF                                                    
           END-IF.                                                      
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
       6140-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 11130000
      * 6200-JOURNAL-MAIL                                             * 11140000
      *                                                               * 11150000
      *  1. DETERMINE IF THE ADDRESS RECORD TO BE INSERTED, UPDATED   * 11160000
      *     OR DELETED.                                               * 11170000
      *  2. JOURNAL EACH FIELD THAT HAS CHANGED.                      * 11180000
      *                                                               * 11190000
      ***************************************************************** 11200000
                                                                        
       6200-JOURNAL-MAIL.                                               
                                                                        
           IF PARM-MAIL-STREET           > ' ' OR                       
              PARM-MAIL-CITY-STATE       > ' ' OR                       
              PARM-MAIL-ZIP-CODE         > ' ' OR                       
              PARM-MAIL-ADDRESS-OVERFLOW > ' '                          
              MOVE 'N' TO WS-BLANK-PARM-MAIL                            
           ELSE                                                         
              MOVE 'Y' TO WS-BLANK-PARM-MAIL                            
           END-IF.                                                      
                                                                        
P00704* EXISTING FORMATTED ADDRESS                                      11231003
P00704     IF WS-ADDRESS-FORMAT = 'A'                                   
P00704         EVALUATE WS-BLANK-PARM-MAIL                              
P00704             WHEN 'Y'                                             
P00704                 CONTINUE                                         
P00704             WHEN 'N'                                             
P00704                 PERFORM 6215-DELETE-TRANSHIST THRU 6215-EXIT     
P00704                 MOVE ZEROES TO PARM-MAIL-ADDRESS-ID              
P00704         END-EVALUATE
           END-IF.                                            
                                                                        
A03360     IF PARM-MAIL-ADDRESS-ID = SPACES OR ZEROES                   
              MOVE 'N' TO WS-MAIL-EXISTS-FLAG                           
              MOVE SPACES TO DZ-ADDR-STREET, DZ-ADDR-CITY-STATE,        
                             DZ-ADDR-ZIP-CODE, DZ-ADDR-COUNTRY,         
                             DZ-ADDRESS-OVERFLOW                        
           ELSE                                                         
P00704        EVALUATE WS-ADDRESS-FORMAT                                
P00704            WHEN 'B'                                              
                      PERFORM 7100-SELECT-ADDR-FREE THRU 7100-EXIT      
P00704            WHEN 'A'                                              
P00704                PERFORM 7150-SELECT-ADDR-FMT THRU 7150-EXIT       
P00704        END-EVALUATE                                              
              MOVE 'Y' TO WS-MAIL-EXISTS-FLAG                           
           END-IF.                                                      
                                                                        
           IF WS-BLANK-PARM-MAIL = 'Y'                                  
              IF MAIL-EXISTS                                            
                 MOVE 'D' TO WS-ACTION-FLAG                             
                 PERFORM 6230-JOURNAL-MAIL-DELETE THRU 6230-EXIT        
              ELSE                                                      
                 MOVE ' ' TO WS-ACTION-FLAG                             
              END-IF                                                    
           ELSE                                                         
              IF MAIL-EXISTS                                            
                 MOVE 'U' TO WS-ACTION-FLAG                             
                 PERFORM 6220-JOURNAL-MAIL-UPDATE THRU 6220-EXIT        
              ELSE                                                      
                 MOVE 'I' TO WS-ACTION-FLAG                             
                 PERFORM 6240-JOURNAL-MAIL-INSERT THRU 6240-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
                                                                        
       6200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       6215-DELETE-TRANSHIST.                                           
                                                                        
           MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
           MOVE 'FMT ADDRESS ID'         TO MI-COLUMN-DESC.             
           MOVE 13                       TO MI-PRV-COLUMN-VALUE-LEN.    
           MOVE 9                        TO MI-CHG-COLUMN-VALUE-LEN.    
           MOVE PARM-MAIL-ADDRESS-ID     TO MI-PRV-COLUMN-VALUE-TEXT.   
           MOVE '*DELETED*'              TO MI-CHG-COLUMN-VALUE-TEXT.   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
       6215-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 11640000
      * 6240-JOURNAL-MAIL-INSERT                                      * 11650000
      *                                                               * 11660000
      *     TO CREATE JOURNAL ENTRIES WHEN RECORD IS INSERTED IN      * 11670000
      *     ADDR-FREEFORM TABLE FOR MAILING ADDRESS FOR A CUSTOMER    * 11680000
      ***************************************************************** 11690000
                                                                        
       6240-JOURNAL-MAIL-INSERT.                                        
                                                                        
           MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
           MOVE 'COR ADR STREET'         TO MI-COLUMN-DESC.             
           MOVE 5                        TO MI-PRV-COLUMN-VALUE-LEN.    
T36932     MOVE 55                       TO MI-CHG-COLUMN-VALUE-LEN.    
           MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT.   
           MOVE PARM-MAIL-STREET         TO MI-CHG-COLUMN-VALUE-TEXT.   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
           MOVE 'COR ADR CITY ST'        TO MI-COLUMN-DESC.             
           MOVE 5                        TO MI-PRV-COLUMN-VALUE-LEN.    
T36932     MOVE 30                       TO MI-CHG-COLUMN-VALUE-LEN.    
           MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT.   
           MOVE PARM-MAIL-CITY-STATE     TO MI-CHG-COLUMN-VALUE-TEXT.   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           IF PARM-MAIL-ZIP-CODE = SPACES                               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE 'COR ADR ZIPCODE'     TO MI-COLUMN-DESC              
              MOVE 5                     TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE 9                     TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE PARM-MAIL-ZIP-CODE    TO MI-CHG-COLUMN-VALUE-TEXT    
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF PARM-MAIL-ADDRESS-OVERFLOW = SPACES                       
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO          
              MOVE 'COR ADR OVRFLOW'        TO MI-COLUMN-DESC           
              MOVE 5                        TO MI-PRV-COLUMN-VALUE-LEN  
              MOVE 35                       TO MI-CHG-COLUMN-VALUE-LEN  
              MOVE '*NEW*'                  TO MI-PRV-COLUMN-VALUE-TEXT 
              MOVE PARM-MAIL-ADDRESS-OVERFLOW                           
                                         TO MI-CHG-COLUMN-VALUE-TEXT    
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
       6240-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 12130000
      * 6220-JOURNAL-MAIL-UPDATE                                      * 12140000
      *                                                               * 12150000
      *     TO CREATE JOURNAL ENTRIES WHEN RECORD IS UPDATED IN       * 12160000
      *     ADDR-FREEFORM TABLE FOR MAILING ADDRESS FOR A CUSTOMER    * 12170000
      ***************************************************************** 12180000
                                                                        
       6220-JOURNAL-MAIL-UPDATE.                                        
                                                                        
           IF PARM-MAIL-STREET = DZ-ADDR-STREET                         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO              
              MOVE 'COR ADR STREET'     TO MI-COLUMN-DESC               
T36932        MOVE 55                   TO MI-PRV-COLUMN-VALUE-LEN      
T36932                                     MI-CHG-COLUMN-VALUE-LEN      
              MOVE DZ-ADDR-STREET       TO MI-PRV-COLUMN-VALUE-TEXT     
              MOVE PARM-MAIL-STREET     TO MI-CHG-COLUMN-VALUE-TEXT     
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF PARM-MAIL-CITY-STATE = DZ-ADDR-CITY-STATE                 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
              MOVE 'COR ADR CITY ST'      TO MI-COLUMN-DESC             
T36932        MOVE 30                     TO MI-PRV-COLUMN-VALUE-LEN    
T36932                                       MI-CHG-COLUMN-VALUE-LEN    
              MOVE DZ-ADDR-CITY-STATE     TO MI-PRV-COLUMN-VALUE-TEXT   
              MOVE PARM-MAIL-CITY-STATE   TO MI-CHG-COLUMN-VALUE-TEXT   
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF PARM-MAIL-ZIP-CODE = DZ-ADDR-ZIP-CODE                     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO              
              MOVE 'COR ADR ZIPCODE'    TO MI-COLUMN-DESC               
              MOVE 9                    TO MI-PRV-COLUMN-VALUE-LEN      
                                           MI-CHG-COLUMN-VALUE-LEN      
              MOVE DZ-ADDR-ZIP-CODE     TO MI-PRV-COLUMN-VALUE-TEXT     
              MOVE PARM-MAIL-ZIP-CODE   TO MI-CHG-COLUMN-VALUE-TEXT     
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF PARM-MAIL-ADDRESS-OVERFLOW = DZ-ADDRESS-OVERFLOW          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'COR ADR OVRFLOW'       TO MI-COLUMN-DESC            
              MOVE 35                   TO MI-PRV-COLUMN-VALUE-LEN      
                                           MI-CHG-COLUMN-VALUE-LEN      
              MOVE DZ-ADDRESS-OVERFLOW  TO MI-PRV-COLUMN-VALUE-TEXT     
              MOVE PARM-MAIL-ADDRESS-OVERFLOW                           
                                        TO MI-CHG-COLUMN-VALUE-TEXT     
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
       6220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 12780000
      * 6230-JOURNAL-MAIL-DELETE                                      * 12790000
      *                                                               * 12800000
      *     TO CREATE JOURNAL ENTRIES WHEN RECORD IS DELETED FROM     * 12810000
      *     ADDR-FREEFORM TABLE FOR MAILING ADDRESS FOR A CUSTOMER    * 12820000
      ***************************************************************** 12830000
                                                                        
       6230-JOURNAL-MAIL-DELETE.                                        
                                                                        
           MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
           MOVE 'COR ADR STREET'         TO MI-COLUMN-DESC.             
T36932     MOVE 55                       TO MI-PRV-COLUMN-VALUE-LEN.    
           MOVE 9                        TO MI-CHG-COLUMN-VALUE-LEN.    
           MOVE DZ-ADDR-STREET           TO MI-PRV-COLUMN-VALUE-TEXT.   
           MOVE '*DELETED*'              TO MI-CHG-COLUMN-VALUE-TEXT.   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           MOVE WS-TRAN-APPL-NO          TO MI-TRAN-APPL-NO.            
           MOVE 'COR ADR CITY ST'        TO MI-COLUMN-DESC.             
T36932     MOVE 30                       TO MI-PRV-COLUMN-VALUE-LEN.    
           MOVE 9                        TO MI-CHG-COLUMN-VALUE-LEN.    
           MOVE DZ-ADDR-CITY-STATE       TO MI-PRV-COLUMN-VALUE-TEXT.   
           MOVE '*DELETED*'              TO MI-CHG-COLUMN-VALUE-TEXT.   
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1 TO WS-TRAN-APPL-NO.                                    
                                                                        
           IF DZ-ADDR-ZIP-CODE = SPACES                                 
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO       TO MI-TRAN-APPL-NO             
              MOVE 'COR ADR ZIPCODE'     TO MI-COLUMN-DESC              
              MOVE 9                     TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE 9                     TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE DZ-ADDR-ZIP-CODE      TO MI-PRV-COLUMN-VALUE-TEXT    
              MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT    
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
           IF DZ-ADDRESS-OVERFLOW = SPACES                              
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'COR ADR OVRFLOW'       TO MI-COLUMN-DESC            
              MOVE 35                      TO MI-PRV-COLUMN-VALUE-LEN   
              MOVE 9                       TO MI-CHG-COLUMN-VALUE-LEN   
              MOVE DZ-ADDRESS-OVERFLOW     TO MI-PRV-COLUMN-VALUE-TEXT  
              MOVE '*DELETED*'             TO MI-CHG-COLUMN-VALUE-TEXT  
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
       6230-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                     12990000
              INCLUDE CPD00067                                          13000000
           END-EXEC.                                                    13010000
                                                                        
*T4158     EXEC SQL                                                     13021000
*T4158        INCLUDE CPD00071                                          13022000
*T4158     END-EXEC.                                                    13023000
                                                                        
*T4158     EXEC SQL                                                     13025000
*T4158        INCLUDE CPD00090                                          13026000
*T4158     END-EXEC.                                                    13027000
                                                                        
      ****************************************************************  13310000
      * 7100-SELECT-ADDR-FREE                                        *  13320000
      ****************************************************************  13330000
                                                                        
       7100-SELECT-ADDR-FREE.                                           
                                                                        
           EXEC SQL                                                     
              SELECT ADDR_STREET,                                       
                     ADDR_CITY_STATE,                                   
                     ADDR_ZIP_CODE,                                     
                     ADDR_COUNTRY,                                      
                     ADDRESS_OVERFLOW                                   
              INTO  :DZ-ADDR-STREET,                                    
                    :DZ-ADDR-CITY-STATE,                                
                    :DZ-ADDR-ZIP-CODE,                                  
                    :DZ-ADDR-COUNTRY,                                   
                    :DZ-ADDRESS-OVERFLOW                                
              FROM   CSS_ADDR_FREEFORM WITH(READUNCOMMITTED)                    
              WHERE  ADDRESS_ID = :DZ-ADDRESS-ID                        
T35434                                                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     13370000
MFA-TR*       SELECT ADDR_STREET,                                       13380000
MFA-TR*              ADDR_CITY_STATE,                                   13390000
MFA-TR*              ADDR_ZIP_CODE,                                     13400000
MFA-TR*              ADDR_COUNTRY,                                      13410000
MFA-TR*              ADDRESS_OVERFLOW                                   13420000
MFA-TR*       INTO  :DZ-ADDR-STREET,                                    13430000
MFA-TR*             :DZ-ADDR-CITY-STATE,                                13440000
MFA-TR*             :DZ-ADDR-ZIP-CODE,                                  13450000
MFA-TR*             :DZ-ADDR-COUNTRY,                                   13460000
MFA-TR*             :DZ-ADDRESS-OVERFLOW                                13470000
MFA-TR*       FROM   CSS_ADDR_FREEFORM                                  13480000
MFA-TR*       WHERE  ADDRESS_ID = :DZ-ADDRESS-ID                        13490000
MFA-TR*       WITH UR                                                   13491000
MFA-TR*       QUERYNO 7100                                              13492000
MFA-TR*    END-EXEC.                                                    13500000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7100'          TO ACTIVE-PARAGRAPH                  
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-1                      
              MOVE 'ADDRESS-ID'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-2              
              MOVE DZ-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE PARM-CUSTOMER-NO     TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00704 7150-SELECT-ADDR-FMT.                                            
P00704                                                                  
P00704     EXEC SQL                                                     
P00704        SELECT                                                    
P00704               RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(RTRIM(
           ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + ' ' + 
           LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(STREET_SUFFIX
           ) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX)))))))),             
P00704               RTRIM(LTRIM(RTRIM(TOWN) + ', ' + LTRIM(RTRIM(STATE)
           ))),                       
P00704               DY.ZIP_CODE,                                       
P00704               ' ',                                               
P00704               RTRIM(LTRIM(RTRIM(STREET_LOCATION_1) + ' ' + LTRIM(
           RTRIM(STREET_LOCATION_2))))            
P00704        INTO  :DZ-ADDR-STREET,                                    
P00704              :DZ-ADDR-CITY-STATE,                                
P00704              :DZ-ADDR-ZIP-CODE,                                  
P00704              :DZ-ADDR-COUNTRY,                                   
P00704              :DZ-ADDRESS-OVERFLOW                                
P00704        FROM   CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),               
P00704               CSS_ZIP_CODE A4 WITH(READUNCOMMITTED)                      
P00704        WHERE  ADDRESS_ID = :DY-ADDRESS-ID                        
P00704          AND  DY.ZIP_CODE = A4.ZIP_CODE                          
P00704          AND  DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN              
P00704                                                           
P00704                                                      
P00704     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                     13693003
MFA-TR*       SELECT                                                    13694003
MFA-TR*              RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||              13694103
MFA-TR*                    LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||         13694203
MFA-TR*                    LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||         13694303
MFA-TR*                    LTRIM(RTRIM(STREET_NAME) || ' ' ||           13694403
MFA-TR*                    LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||         13694503
MFA-TR*                    LTRIM(RTRIM(ADDR_SUFFIX)))))))),             13694603
MFA-TR*              RTRIM(LTRIM(RTRIM(TOWN) || ', ' ||                 13694703
MFA-TR*                    LTRIM(RTRIM(STATE)))),                       13694803
MFA-TR*              DY.ZIP_CODE,                                       13696003
MFA-TR*              ' ',                                               13697003
MFA-TR*              RTRIM(LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||     13697103
MFA-TR*                    LTRIM(RTRIM(STREET_LOCATION_2))))            13697203
MFA-TR*       INTO  :DZ-ADDR-STREET,                                    13699003
MFA-TR*             :DZ-ADDR-CITY-STATE,                                13699103
MFA-TR*             :DZ-ADDR-ZIP-CODE,                                  13699203
MFA-TR*             :DZ-ADDR-COUNTRY,                                   13699303
MFA-TR*             :DZ-ADDRESS-OVERFLOW                                13699403
MFA-TR*       FROM   CSS_ADDR_FORMATTED DY,                             13699503
MFA-TR*              CSS_ZIP_CODE A4                                    13699603
MFA-TR*       WHERE  ADDRESS_ID = :DY-ADDRESS-ID                        13699703
MFA-TR*         AND  DY.ZIP_CODE = A4.ZIP_CODE                          13699803
MFA-TR*         AND  DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN              13699903
MFA-TR*       WITH UR                                                   13700003
MFA-TR*       QUERYNO 7150                                              13700103
MFA-TR*    END-EXEC.                                                    13700203

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00704                                                                  
P00704     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00704                                                                  
P00704     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00704        CONTINUE                                                  
P00704     ELSE                                                         
P00704        MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
P00704        MOVE '7150'          TO ACTIVE-PARAGRAPH                  
P00704        MOVE 'SELECT'             TO ABEND-FUNCTION               
P00704        MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                      
P00704        MOVE 'ADDRESS-ID'         TO TABLE-ELEMENT-1              
P00704        MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-2              
P00704        MOVE DY-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
P00704        MOVE PARM-CUSTOMER-NO     TO HOSTVAR-ELEMENT-2            
P00704        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00704        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00704     END-IF.                                                      
P00704                                                                  
P00704 7150-EXIT.                                                       
P00704     EXIT.                                                        
                                                                        
      ****************************************************************  13703003
      * 7200-SELECT-BUS-STATS                                        *  13710000
      ****************************************************************  13720000
                                                                        
       7200-SELECT-BUS-STATS.                                           
                                                                        
           EXEC SQL                                                     
              SELECT CUSTOMER_NO,                                       
                     HOME_OFFICE_NAME                                   
              INTO  :BS-CUSTOMER-NO,                                    
                    :BS-HOME-OFFICE-NAME                                
              FROM   CSS_BUS_CUST_STATS WITH(READUNCOMMITTED)                   
              WHERE  CUSTOMER_NO = :BS-CUSTOMER-NO                      
T35434                                                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     13760000
MFA-TR*       SELECT CUSTOMER_NO,                                       13770000
MFA-TR*              HOME_OFFICE_NAME                                   13780000
MFA-TR*       INTO  :BS-CUSTOMER-NO,                                    13790000
MFA-TR*             :BS-HOME-OFFICE-NAME                                13800000
MFA-TR*       FROM   CSS_BUS_CUST_STATS                                 13810000
MFA-TR*       WHERE  CUSTOMER_NO = :BS-CUSTOMER-NO                      13820000
MFA-TR*       WITH UR                                                   13821000
MFA-TR*       QUERYNO 7200                                              13822000
MFA-TR*    END-EXEC.                                                    13830000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7200'          TO ACTIVE-PARAGRAPH                  
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_BUS_CUST_STATS' TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE BS-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 14030000
      * 7300-GET-TIMESTAMP                                            * 14040000
      ***************************************************************** 14050000
                                                                        
       7300-GET-TIMESTAMP.                                              
                                                                        
           EXEC SQL                                                     
T35434        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-TRANS-HIST-SEQ-NO,
              :MH-DATE-TRANS                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     14090000
MFA-TR*       SET  :MH-TRANS-HIST-SEQ-NO  = CURRENT TIMESTAMP,          14091000
MFA-TR*            :MH-DATE-TRANS  = CURRENT DATE                       14092000
MFA-TR*    END-EXEC.                                                    14150000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7300'          TO ACTIVE-PARAGRAPH                  
T35434        MOVE 'SET'           TO ABEND-FUNCTION                    
              MOVE SPACES          TO ABEND-FUNCTION                    
                                      ABEND-SQL-PREDICATES              
CBSI          MOVE 'CUSTOMER_NO'   TO TABLE-ELEMENT-1                   
CBSI          MOVE PARM-CUSTOMER-NO TO HOSTVAR-ELEMENT-1                
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00704 7400-GET-ADDR-FORMAT.                                            
P00704                                                                  
P00704     EXEC SQL                                                     
P00704        SELECT ADDRESS_FORMAT                                     
P00704        INTO  :WS-ADDRESS-FORMAT                                  
P00704        FROM   CSS_CUST_ADDR_XREF WITH(READUNCOMMITTED)                   
P00704        WHERE  CUSTOMER_NO = :DM-CUSTOMER-NO                      
P00704          AND  ADDRESS_TYPE = 'M'                                 
P00704                                                           
P00704                                                      
P00704     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     14370001
MFA-TR*       SELECT ADDRESS_FORMAT                                     14380001
MFA-TR*       INTO  :WS-ADDRESS-FORMAT                                  14400003
MFA-TR*       FROM   CSS_CUST_ADDR_XREF                                 14411001
MFA-TR*       WHERE  CUSTOMER_NO = :DM-CUSTOMER-NO                      14412001
MFA-TR*         AND  ADDRESS_TYPE = 'M'                                 14412101
MFA-TR*       WITH UR                                                   14413001
MFA-TR*       QUERYNO 7400                                              14414001
MFA-TR*    END-EXEC.                                                    14415001

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00704                                                                  
P00704     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00704     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00704         WHEN SUCCESSFUL-CALL                                     
P00704             CONTINUE                                             
P00704         WHEN NOT-FOUND                                           
P00704             MOVE SPACES TO WS-ADDRESS-FORMAT                     
P00704             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
P00704         WHEN OTHER                                               
P00704             MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
P00704             MOVE PROGRAM-NAME TO ABEND-PROGRAM                   
P00704             MOVE '7400'     TO ACTIVE-PARAGRAPH                  
P00704             MOVE 'SELECT'   TO ABEND-FUNCTION                    
P00704             MOVE SPACES     TO ABEND-FUNCTION                    
P00704                                     ABEND-SQL-PREDICATES         
P00704             MOVE 'CUSTOMER_NO' TO TABLE-ELEMENT-1                
P00704             MOVE DM-CUSTOMER-NO TO HOSTVAR-ELEMENT-1             
P00704             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
P00704             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
P00704     END-EVALUATE.                                                
P00704                                                                  
P00704 7400-EXIT.                                                       
P00704     EXIT.                                                        
                                                                        
      ***************************************************************** 14620000
      * 8300-INSERT-ADDR-XREF                                         * 14630000
      ***************************************************************** 14640000
                                                                        
       8300-INSERT-ADDR-XREF.                                           
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CUST_ADDR_XREF                            
                    (CUSTOMER_NO,                                       
                     ADDRESS_TYPE,                                      
                     ADDRESS_ID,                                        
                     ADDRESS_FORMAT)                                    
              VALUES                                                    
                   (:DM-CUSTOMER-NO,                                    
                    :DM-ADDRESS-TYPE,                                   
                    :DM-ADDRESS-ID,                                     
                    :DM-ADDRESS-FORMAT)                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '8300'          TO ACTIVE-PARAGRAPH                  
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_ADDR_XREF' TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE 'ADDRESS_TYPE'       TO TABLE-ELEMENT-2              
CBSI          MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-3              
CBSI          MOVE 'ADDRESS_FORMAT'     TO TABLE-ELEMENT-4              
              MOVE DM-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE DM-ADDRESS-TYPE      TO HOSTVAR-ELEMENT-2            
CBSI          MOVE DM-ADDRESS-ID        TO HOSTVAR-ELEMENT-3            
CBSI          MOVE DM-ADDRESS-FORMAT    TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 15010000
      * 8400-DELETE-ADDR-XREF                                         * 15020000
      ***************************************************************** 15030000
                                                                        
       8400-DELETE-ADDR-XREF.                                           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_CUST_ADDR_XREF                            
              WHERE CUSTOMER_NO  = :DM-CUSTOMER-NO AND                  
                    ADDRESS_TYPE = :DM-ADDRESS-TYPE                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     15070000
MFA-TR*       DELETE FROM CSS_CUST_ADDR_XREF                            15080000
MFA-TR*       WHERE CUSTOMER_NO  = :DM-CUSTOMER-NO AND                  15090000
MFA-TR*             ADDRESS_TYPE = :DM-ADDRESS-TYPE                     15100000
MFA-TR*       QUERYNO 8400                                              15101000
MFA-TR*    END-EXEC.                                                    15110000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
A03263     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '8400'          TO ACTIVE-PARAGRAPH                  
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_ADDR_XREF' TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE 'ADDRESS_TYPE'       TO TABLE-ELEMENT-2              
              MOVE DM-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE DM-ADDRESS-TYPE      TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 15330000
      * 8500-INSERT-ADDR-FREE                                         * 15340000
      ***************************************************************** 15350000
                                                                        
       8500-INSERT-ADDR-FREE.                                           
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ADDR_FREEFORM                             
                    (ADDRESS_ID,                                        
                     ADDR_STREET,                                       
                     ADDR_CITY_STATE,                                   
                     ADDR_ZIP_CODE,                                     
                     ADDR_COUNTRY,                                      
                     ADDRESS_OVERFLOW)                                  
              VALUES                                                    
                   (:DZ-ADDRESS-ID,                                     
                    :DZ-ADDR-STREET,                                    
                    :DZ-ADDR-CITY-STATE,                                
                    :DZ-ADDR-ZIP-CODE,                                  
                    :DZ-ADDR-COUNTRY,                                   
                    :DZ-ADDRESS-OVERFLOW)                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '8500'          TO ACTIVE-PARAGRAPH                  
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'ADDR_CITY_STATE'    TO TABLE-ELEMENT-2              
CBSI          MOVE 'ADDR_ZIP_CODE'      TO TABLE-ELEMENT-3              
              MOVE DZ-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE DZ-ADDR-CITY-STATE   TO HOSTVAR-ELEMENT-2            
CBSI          MOVE DZ-ADDR-ZIP-CODE     TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 15740000
      * 8600-UPDATE-ADDR-FREE                                         * 15750000
      ***************************************************************** 15760000
                                                                        
       8600-UPDATE-ADDR-FREE.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ADDR_FREEFORM                                  
              SET    ADDR_STREET        = :DZ-ADDR-STREET,              
                     ADDR_CITY_STATE    = :DZ-ADDR-CITY-STATE,          
                     ADDR_ZIP_CODE      = :DZ-ADDR-ZIP-CODE,            
                     ADDRESS_OVERFLOW   = :DZ-ADDRESS-OVERFLOW          
              WHERE  ADDRESS_ID = :DZ-ADDRESS-ID                        
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     15800000
MFA-TR*       UPDATE CSS_ADDR_FREEFORM                                  15810000
MFA-TR*       SET    ADDR_STREET        = :DZ-ADDR-STREET,              15820000
MFA-TR*              ADDR_CITY_STATE    = :DZ-ADDR-CITY-STATE,          15830000
MFA-TR*              ADDR_ZIP_CODE      = :DZ-ADDR-ZIP-CODE,            15840000
MFA-TR*              ADDRESS_OVERFLOW   = :DZ-ADDRESS-OVERFLOW          15850000
MFA-TR*       WHERE  ADDRESS_ID = :DZ-ADDRESS-ID                        15860000
MFA-TR*       QUERYNO 8600                                              15861000
MFA-TR*    END-EXEC.                                                    15870000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '8600'          TO ACTIVE-PARAGRAPH                  
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'ADDR_CITY_STATE'    TO TABLE-ELEMENT-2              
CBSI          MOVE 'ADDR_ZIP_CODE'      TO TABLE-ELEMENT-3              
              MOVE DZ-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE DZ-ADDR-CITY-STATE   TO HOSTVAR-ELEMENT-2            
CBSI          MOVE DZ-ADDR-ZIP-CODE     TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 16070000
      * 8700-DELETE-ADDR-FREE                                         * 16080000
      ***************************************************************** 16090000
                                                                        
       8700-DELETE-ADDR-FREE.                                           
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_ADDR_FREEFORM                             
              WHERE ADDRESS_ID = :DZ-ADDRESS-ID                         
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     16130000
MFA-TR*       DELETE FROM CSS_ADDR_FREEFORM                             16140000
MFA-TR*       WHERE ADDRESS_ID = :DZ-ADDRESS-ID                         16150000
MFA-TR*       QUERYNO 8700                                              16151000
MFA-TR*    END-EXEC.                                                    16160000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '8700'          TO ACTIVE-PARAGRAPH                  
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-2              
              MOVE DZ-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE PARM-CUSTOMER-NO     TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 16360000
      * 8800-INSERT-BUS-STATS                                         * 16370000
      ***************************************************************** 16380000
                                                                        
       8800-INSERT-BUS-STATS.                                           
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_BUS_CUST_STATS                            
                    (CUSTOMER_NO,                                       
                     BUSINESS_TYPE_CD,                                  
                     TAX_ID,                                            
                     ALIAS,                                             
                     INTRA_CO_IND,                                      
                     SUBSIDIARY_IND,                                    
                     TRADE_ALLY_IND,                                    
                     CONTRACTOR_TYPE,                                   
                     DUNN_BRAD_ID_NO,                                   
                     HOME_OFFICE_NAME)                                  
              VALUES                                                    
                   (:BS-CUSTOMER-NO,                                    
                    :BS-BUSINESS-TYPE-CD,                               
                    :BS-TAX-ID,                                         
                    :BS-ALIAS,                                          
                    :BS-INTRA-CO-IND,                                   
                    :BS-SUBSIDIARY-IND,                                 
                    :BS-TRADE-ALLY-IND,                                 
                    :BS-CONTRACTOR-TYPE,                                
                    :BS-DUNN-BRAD-ID-NO,                                
                    :BS-HOME-OFFICE-NAME)                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '8800'          TO ACTIVE-PARAGRAPH                  
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_BUS_CUST_STATS' TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
CBSI          MOVE 'BUSINESS_TYPE_CD'   TO TABLE-ELEMENT-2              
CBSI          MOVE 'TAX_ID'             TO TABLE-ELEMENT-3              
CBSI          MOVE 'ALIAS'              TO TABLE-ELEMENT-4              
              MOVE BS-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
CBSI          MOVE BS-BUSINESS-TYPE-CD  TO HOSTVAR-ELEMENT-2            
CBSI          MOVE BS-TAX-ID            TO HOSTVAR-ELEMENT-3            
CBSI          MOVE BS-ALIAS             TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************16850000
      * 8850-UPDATE-BUS-STATS                                         * 16860000
      ******************************************************************16870000
                                                                        
       8850-UPDATE-BUS-STATS.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_BUS_CUST_STATS                                 
              SET    HOME_OFFICE_NAME = :BS-HOME-OFFICE-NAME            
              WHERE  CUSTOMER_NO = :BS-CUSTOMER-NO                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     16910000
MFA-TR*       UPDATE CSS_BUS_CUST_STATS                                 16920000
MFA-TR*       SET    HOME_OFFICE_NAME = :BS-HOME-OFFICE-NAME            16930000
MFA-TR*       WHERE  CUSTOMER_NO = :BS-CUSTOMER-NO                      16940000
MFA-TR*       QUERYNO 8850                                              16941000
MFA-TR*    END-EXEC.                                                    16950000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '8850'          TO ACTIVE-PARAGRAPH                  
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_BUS_CUST_STATS' TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
CBSI          MOVE 'HOME_OFFICE_NAME'   TO TABLE-ELEMENT-2              
              MOVE BS-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
CBSI          MOVE BS-HOME-OFFICE-NAME  TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8850-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************17160000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     17170000
      ******************************************************************17180000
                                                                        
REARCH     EXEC SQL                                                     17221000
REARCH        INCLUDE CPDSP300                                          17222000
REARCH     END-EXEC.                                                    17223000
                                                                        
      ******************************************************************17230000
      *       END PROGRAM COPYLIB                                      *17240000
      ******************************************************************17250000
                                                                        
REARCH     EXEC SQL                                                     17300000
REARCH          INCLUDE CPD00331                                        17310000
REARCH     END-EXEC.                                                    17320000
