       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR02204.                                     
COB303 DATE-WRITTEN.  JUNE 17, 2005.                                    
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
      *                                                                *00110000
      *  TRANID:        S204                                           *00120000
      *  PROGRAM:       S204                                           *00130000
      *  CALLING SP:    PA_S204                                        *00140000
      *                                                                *00150000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *  THIS PROCEDURE RETRIEVES ALL ROWS IN THE CSS_ADDR_FREEFORM    *00190000
      *  TABLE FOR A SPECIFIC CUSTOMER USING THE CROSS-REFERENCE       *00200000
      *  TABLE CSS_CUST_ADDR_XREF                                      *00201000
      ******************************************************************00210000
      *                                                                *00220000
      *                     PROGRAM MODIFICATION LOG                   *00230000
      *                                                                *00240000
      *    DATE    INITIALS   COMMENTS                                 *00250000
      *  --------  --------   ---------------------------------------  *00260000
      *  07/20/94    MAK      PROCEDURE ORIGINALLY CODED.              *00270000
      *  05/10/95    SK       MODIFIED TO TAKE CARE OF DESIGN CHANGES  *00271000
      *                       - CHANGE CONTACT ADDRESS TO MAILING ADDR *00272005
      *                       - GET DETAILS FROM ADDR_FREEFORM TABLE   *00273000
      *                       - USE CUST_ADDR_XREF TABLE FOR ADDR-ID   *00274000
CBSI  *  11/09/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *00274100
CBSI  *             MADRAS    ABEND PARAMETERS                         *00275000
      *  06/17/05   CVNS      RPC TO COBOL SP CONVERSION.              *00274100
      *             CHENNAI                                            *00275000
T36932*  06/29/08   SV85244   INCREASE LENGTH OF ADDR_STREET           *00274100
T36932*                       AND ADDR_CITY_STATE.                     *00275000
P00704*  08/21/13   FMB       DISPLAY FORMATTED MAILING ADDRESS.       *00274100
      *                                                                *00280000
      ******************************************************************00290000
      ******************************************************************00300000
      *                                                                *00310000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00320000
      *                                                                *00330000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00340000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00350000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00360000
      *  3000 - 4999  NOT USED                                         *00370000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00380000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00390000
      *  7000 - 7999  INPUT MODULES                                    *00400000
      *  8000 - 8999  OUTPUT MODULES                                   *00410000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00420000
      *                                                                *00430000
      ******************************************************************00440000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02204'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR02204 STARTS HERE'.                  
                                                                        
      ******************************************************************00530000
      *    DB2 INCLUDES                                                *00540000
      ******************************************************************00550000
                                                                        
           EXEC SQL                                                     00570000
              INCLUDE SQLCA                                             00580000
           END-EXEC.                                                    00590000
                                                                        
           EXEC SQL                                                     00601000
              INCLUDE TBCSADRX                                          00602000
           END-EXEC.                                                    00603000
                                                                        
P00704     EXEC SQL                                                     00601000
P00704        INCLUDE TBADRFMT                                          00602000
P00704     END-EXEC.                                                    00603000
                                                                        
P00704     EXEC SQL                                                     00601000
P00704        INCLUDE TBZIPCD                                           00602000
P00704     END-EXEC.                                                    00603000
                                                                        
           EXEC SQL                                                     00610000
              INCLUDE TBADRFRE                                          00620000
           END-EXEC.                                                    00630000
                                                                        
           EXEC SQL                                                     00650000
              INCLUDE TBBSCSTS                                          00660000
           END-EXEC.                                                    00670000
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE TBMODEL                                           00700000
           END-EXEC.                                                    00710000
                                                                        
      ******************************************************************00730000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00740000
      ******************************************************************00750000
                                                                        
           COPY CCA00001.                                               00790000
           COPY CWS00027.                                               00810000
           COPY CWS00303.                                               00820000
                                                                        
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
      ******************************************************************00840000
      *    WORK AREAS                                                  *00850000
      ******************************************************************00860000
                                                                        
       01  GTT-MISC-FIELDS.                                             
            05  GTT-NAME                PIC X(26)                       
                                        VALUE 'SESSION.CSR02204_R1'.    
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
       01  WS-MISC.                                                     
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR02204'.      
           05  WS-CUSTOMER-NO          PIC X(10) VALUE SPACES.          
           05  WS-CUSTOMER-NO-NUM      PIC 9(10).                       
P00704     05  WS-ADDRESS-LINE-1       PIC X(80) VALUE SPACES.          
P00704     05  WS-ADDRESS-LINE-2       PIC X(80) VALUE SPACES.          
P00704     05  WS-ZIP-CODE             PIC X(09) VALUE SPACES.          
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
           05  RS-MAIL-ADDRESS-ID       PIC X(13) VALUE SPACES.         
T36932*    05  RS-MAIL-STREET           PIC X(35) VALUE SPACES.         01282005
T36932*    05  RS-MAIL-CITY-STATE       PIC X(20) VALUE SPACES.         01283005
T36932     05  RS-MAIL-STREET           PIC X(55) VALUE SPACES.         
T36932     05  RS-MAIL-CITY-STATE       PIC X(30) VALUE SPACES.         
           05  RS-MAIL-ZIP-CODE         PIC X(09) VALUE SPACES.         
           05  RS-MAIL-ADDRESS-OVERFLOW PIC X(35) VALUE SPACES.         
           05  RS-PREV-ADDRESS-ID       PIC X(13) VALUE SPACES.         
T36932*    05  RS-PREV-STREET           PIC X(35) VALUE SPACES.         01340000
T36932*    05  RS-PREV-CITY-STATE       PIC X(20) VALUE SPACES.         01350000
T36932     05  RS-PREV-STREET           PIC X(55) VALUE SPACES.         
T36932     05  RS-PREV-CITY-STATE       PIC X(30) VALUE SPACES.         
           05  RS-PREV-ZIP-CODE         PIC X(09) VALUE SPACES.         
           05  RS-PREV-ADDRESS-OVERFLOW PIC X(35) VALUE SPACES.         
           05  RS-HOME-ADDRESS-ID       PIC X(13) VALUE SPACES.         
           05  RS-HOME-OFFICE-NAME      PIC X(50) VALUE SPACES.         
T36932*    05  RS-HOME-STREET           PIC X(35) VALUE SPACES.         01400000
T36932*    05  RS-HOME-CITY-STATE       PIC X(20) VALUE SPACES.         01410000
T36932     05  RS-HOME-STREET           PIC X(55) VALUE SPACES.         
T36932     05  RS-HOME-CITY-STATE       PIC X(30) VALUE SPACES.         
           05  RS-HOME-ZIP-CODE         PIC X(09) VALUE SPACES.         
           05  RS-HOME-ADDRESS-OVERFLOW PIC X(35) VALUE SPACES.         
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
           05  S-MAIL-ADDRESS-ID       PIC X(13) VALUE SPACES.          
T36932*    05  S-MAIL-STREET           PIC X(35) VALUE SPACES.          01282005
T36932*    05  S-MAIL-CITY-STATE       PIC X(20) VALUE SPACES.          01283005
T36932     05  S-MAIL-STREET           PIC X(55) VALUE SPACES.          
T36932     05  S-MAIL-CITY-STATE       PIC X(30) VALUE SPACES.          
           05  S-MAIL-ZIP-CODE         PIC X(09) VALUE SPACES.          
           05  S-MAIL-ADDRESS-OVERFLOW PIC X(35) VALUE SPACES.          
           05  S-PREV-ADDRESS-ID       PIC X(13) VALUE SPACES.          
T36932*    05  S-PREV-STREET           PIC X(35) VALUE SPACES.          01340000
T36932*    05  S-PREV-CITY-STATE       PIC X(20) VALUE SPACES.          01350000
T36932     05  S-PREV-STREET           PIC X(55) VALUE SPACES.          
T36932     05  S-PREV-CITY-STATE       PIC X(30) VALUE SPACES.          
           05  S-PREV-ZIP-CODE         PIC X(09) VALUE SPACES.          
           05  S-PREV-ADDRESS-OVERFLOW PIC X(35) VALUE SPACES.          
           05  S-HOME-ADDRESS-ID       PIC X(13) VALUE SPACES.          
           05  S-HOME-OFFICE-NAME      PIC X(50) VALUE SPACES.          
T36932*    05  S-HOME-STREET           PIC X(35) VALUE SPACES.          01400000
T36932*    05  S-HOME-CITY-STATE       PIC X(20) VALUE SPACES.          01410000
T36932     05  S-HOME-STREET           PIC X(55) VALUE SPACES.          
T36932     05  S-HOME-CITY-STATE       PIC X(30) VALUE SPACES.          
           05  S-HOME-ZIP-CODE         PIC X(09) VALUE SPACES.          
           05  S-HOME-ADDRESS-OVERFLOW PIC X(35) VALUE SPACES.          
       01  CSRERLOG-P.                                                  
            10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
            10  S-SQLCODE               PIC S9(9)      COMP VALUE 0.    
            10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
            10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
            10  S-HOST-VARIABLES.                                       
                49  S-HOST-VARIABLES-L  PIC S9(4)      USAGE COMP.      
                49  S-HOST-VARIABLES-V  PIC X(255).                     
            10  S-SQL-STATEMENT.                                        
                49  S-SQL-STATEMENT-L   PIC S9(4)      USAGE COMP.      
                49  S-SQL-STATEMENT-V   PIC X(255).                     
            10  S-SQL-DESCRIPTION.                                      
                49  S-SQL-DESCRIPTION-L PIC S9(4)      USAGE COMP.      
                49  S-SQL-DESCRIPTION-V PIC X(255).                     
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-CUSTOMER-NO        PIC X(10).                           
       PROCEDURE DIVISION USING PARM-CUSTOMER-NO.                       
                                                                        
      ******************************************************************01930000
      * 0000-MAINLINE                                                  *01940000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *01950000
      ******************************************************************01960000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT                                                   
                   :S-RETURN-CODE                  AS RETURN_CODE       
                  ,LTRIM(RTRIM(:S-MAIL-ADDRESS-ID))       AS 
           MAIL_ADDRESS_ID   
                  ,LTRIM(RTRIM(:S-MAIL-STREET))           AS MAIL_STREET       
                  ,LTRIM(RTRIM(:S-MAIL-CITY-STATE))       AS 
           MAIL_CITY_STATE   
                  ,LTRIM(RTRIM(:S-MAIL-ZIP-CODE))         AS 
           MAIL_ZIP_CODE     
                  ,LTRIM(RTRIM(:S-MAIL-ADDRESS-OVERFLOW)) AS 
           MAIL_ADDR_OVERFLOW
                  ,LTRIM(RTRIM(:S-PREV-ADDRESS-ID))       AS 
           PREV_ADDRESS_ID   
                  ,LTRIM(RTRIM(:S-PREV-STREET))           AS PREV_STREET       
                  ,LTRIM(RTRIM(:S-PREV-CITY-STATE))       AS 
           PREV_CITY_STATE   
                  ,LTRIM(RTRIM(:S-PREV-ZIP-CODE))         AS 
           PREV_ZIP_CODE     
                  ,LTRIM(RTRIM(:S-PREV-ADDRESS-OVERFLOW)) AS 
           PREV_ADDR_OVERFLOW
                  ,LTRIM(RTRIM(:S-HOME-ADDRESS-ID))       AS 
           HOME_ADDRESS_ID   
                  ,LTRIM(RTRIM(:S-HOME-OFFICE-NAME))      AS 
           HOME_OFFICE_NAME  
                  ,LTRIM(RTRIM(:S-HOME-STREET))           AS HOME_STREET       
                  ,LTRIM(RTRIM(:S-HOME-CITY-STATE))       AS 
           HOME_CITY_STATE   
                  ,LTRIM(RTRIM(:S-HOME-ZIP-CODE))         AS 
           HOME_ZIP_CODE     
                  ,LTRIM(RTRIM(:S-HOME-ADDRESS-OVERFLOW)) AS 
           HOME_ADDR_OVERFLOW
               FROM                                                     
                   CIS.SYSDUMMY1                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*            :S-RETURN-CODE                  AS RETURN_CODE               
MFA-TR*           ,STRIP(:S-MAIL-ADDRESS-ID)       AS MAIL_ADDRESS_ID           
MFA-TR*           ,STRIP(:S-MAIL-STREET)           AS MAIL_STREET               
MFA-TR*           ,STRIP(:S-MAIL-CITY-STATE)       AS MAIL_CITY_STATE           
MFA-TR*           ,STRIP(:S-MAIL-ZIP-CODE)         AS MAIL_ZIP_CODE             
MFA-TR*           ,STRIP(:S-MAIL-ADDRESS-OVERFLOW) AS MAIL_ADDR_OVERFLOW        
MFA-TR*           ,STRIP(:S-PREV-ADDRESS-ID)       AS PREV_ADDRESS_ID           
MFA-TR*           ,STRIP(:S-PREV-STREET)           AS PREV_STREET               
MFA-TR*           ,STRIP(:S-PREV-CITY-STATE)       AS PREV_CITY_STATE           
MFA-TR*           ,STRIP(:S-PREV-ZIP-CODE)         AS PREV_ZIP_CODE             
MFA-TR*           ,STRIP(:S-PREV-ADDRESS-OVERFLOW) AS PREV_ADDR_OVERFLOW        
MFA-TR*           ,STRIP(:S-HOME-ADDRESS-ID)       AS HOME_ADDRESS_ID           
MFA-TR*           ,STRIP(:S-HOME-OFFICE-NAME)      AS HOME_OFFICE_NAME          
MFA-TR*           ,STRIP(:S-HOME-STREET)           AS HOME_STREET               
MFA-TR*           ,STRIP(:S-HOME-CITY-STATE)       AS HOME_CITY_STATE           
MFA-TR*           ,STRIP(:S-HOME-ZIP-CODE)         AS HOME_ZIP_CODE             
MFA-TR*           ,STRIP(:S-HOME-ADDRESS-OVERFLOW) AS HOME_ADDR_OVERFLOW        
MFA-TR*        FROM                                                             
MFA-TR*            SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC.                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02800000
      * 2000-PROCESS-OUTPUT.                                           *02810000
      *                                                                *02820000
      *     1. DESCRIBE RESULT SET                                     *02830000
      *     2. RETRIVE DB2 DATA                                        *02840000
      *     3. BUILD RESULT SET                                        *02850000
      *     4. SEND RESULT SET                                         *02860000
      *                                                                *02870000
      ******************************************************************02880000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2200-BUILD-RESULT    THRU 2200-EXIT.                 
           MOVE '2000'  TO ACTIVE-PARAGRAPH.                            
           PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT                 
           ADD +1                       TO CTR-ROWS.                    
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *2000A-MOVE-RESULT.                                                       
      ******************************************************************        
       2000A-MOVE-RESULT.                                               
      *                                                                         
           MOVE RS-RETURN-CODE           TO S-RETURN-CODE.              
           MOVE RS-MAIL-ADDRESS-ID       TO S-MAIL-ADDRESS-ID.          
           MOVE RS-MAIL-STREET           TO S-MAIL-STREET.              
           MOVE RS-MAIL-CITY-STATE       TO S-MAIL-CITY-STATE.          
           MOVE RS-MAIL-ZIP-CODE         TO S-MAIL-ZIP-CODE.            
           MOVE RS-MAIL-ADDRESS-OVERFLOW TO S-MAIL-ADDRESS-OVERFLOW.    
           MOVE RS-PREV-ADDRESS-ID       TO S-PREV-ADDRESS-ID.          
           MOVE RS-PREV-STREET           TO S-PREV-STREET.              
           MOVE RS-PREV-CITY-STATE       TO S-PREV-CITY-STATE.          
           MOVE RS-PREV-ZIP-CODE         TO S-PREV-ZIP-CODE.            
           MOVE RS-PREV-ADDRESS-OVERFLOW TO S-PREV-ADDRESS-OVERFLOW.    
           MOVE RS-HOME-ADDRESS-ID       TO S-HOME-ADDRESS-ID.          
           MOVE RS-HOME-OFFICE-NAME      TO S-HOME-OFFICE-NAME.         
           MOVE RS-HOME-STREET           TO S-HOME-STREET.              
           MOVE RS-HOME-CITY-STATE       TO S-HOME-CITY-STATE.          
           MOVE RS-HOME-ZIP-CODE         TO S-HOME-ZIP-CODE.            
           MOVE RS-HOME-ADDRESS-OVERFLOW TO S-HOME-ADDRESS-OVERFLOW.    
      *                                                                         
       2000A-EXIT.                                                      
           EXIT.                                                        
      ******************************************************************06710000
      * 2200-BUILD-RESULT                                              *06720000
      *                                                                *06730000
      *  1. SELECT ADDRESS DATA FROM CSS_CUST_ADDRESSES                *06740000
      *  2. BUILD RESULT SET                                           *06750000
      *                                                                *06760000
      ******************************************************************06770000
                                                                        
       2200-BUILD-RESULT.                                               
                                                                        
           MOVE PARM-CUSTOMER-NO TO WS-CUSTOMER-NO                      
                                    WS-CUSTOMER-NO-NUM.                 
           MOVE WS-CUSTOMER-NO-NUM TO DM-CUSTOMER-NO                    
                                      BS-CUSTOMER-NO.                   
                                                                        
           MOVE NOT-FOUND             TO RS-RETURN-CODE.                
                                                                        
           MOVE 'M'              TO DM-ADDRESS-TYPE.                    
                                                                        
           PERFORM 7000-SELECT-CUST-ADDR-X THRU 7000-EXIT.              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM 2210-MAILING-ADDRESS THRU 2210-EXIT
           END-IF.              
                                                                        
           MOVE 'P'              TO DM-ADDRESS-TYPE.                    
                                                                        
           PERFORM 7000-SELECT-CUST-ADDR-X THRU 7000-EXIT.              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE DM-ADDRESS-ID         TO DZ-ADDRESS-ID               
              PERFORM 7100-SELECT-ADDR-FREE THRU 7100-EXIT              
           END-IF.                                                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE DZ-ADDRESS-ID         TO RS-PREV-ADDRESS-ID          
              MOVE DZ-ADDR-STREET        TO RS-PREV-STREET              
              MOVE DZ-ADDR-CITY-STATE    TO RS-PREV-CITY-STATE          
              MOVE DZ-ADDR-ZIP-CODE      TO RS-PREV-ZIP-CODE            
              MOVE DZ-ADDRESS-OVERFLOW   TO RS-PREV-ADDRESS-OVERFLOW    
           ELSE                                                         
              MOVE SPACES                TO RS-PREV-ADDRESS-ID          
              MOVE SPACES                TO RS-PREV-STREET              
              MOVE SPACES                TO RS-PREV-CITY-STATE          
              MOVE SPACES                TO RS-PREV-ZIP-CODE            
              MOVE SPACES                TO RS-PREV-ADDRESS-OVERFLOW    
           END-IF.                                                      
                                                                        
           MOVE 'H'              TO DM-ADDRESS-TYPE.                    
                                                                        
           PERFORM 7000-SELECT-CUST-ADDR-X THRU 7000-EXIT.              
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE DM-ADDRESS-ID         TO DZ-ADDRESS-ID               
              PERFORM 7100-SELECT-ADDR-FREE THRU 7100-EXIT              
           END-IF.                                                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE DZ-ADDRESS-ID         TO RS-HOME-ADDRESS-ID          
              MOVE DZ-ADDR-STREET        TO RS-HOME-STREET              
              MOVE DZ-ADDR-CITY-STATE    TO RS-HOME-CITY-STATE          
              MOVE DZ-ADDR-ZIP-CODE      TO RS-HOME-ZIP-CODE            
              MOVE DZ-ADDRESS-OVERFLOW   TO RS-HOME-ADDRESS-OVERFLOW    
           ELSE                                                         
              MOVE SPACES                TO RS-HOME-ADDRESS-ID          
              MOVE SPACES                TO RS-HOME-STREET              
              MOVE SPACES                TO RS-HOME-CITY-STATE          
              MOVE SPACES                TO RS-HOME-ZIP-CODE            
              MOVE SPACES                TO RS-HOME-ADDRESS-OVERFLOW    
           END-IF.                                                      
                                                                        
           PERFORM 7200-SELECT-BUS-STATS THRU 7200-EXIT.                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE BS-HOME-OFFICE-NAME   TO RS-HOME-OFFICE-NAME         
           ELSE                                                         
              MOVE SPACES             TO RS-HOME-OFFICE-NAME            
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2210-MAILING-ADDRESS.                                            
                                                                        
           MOVE SPACES TO RS-MAIL-ADDRESS-ID                            
                          RS-MAIL-STREET                                
                          RS-MAIL-CITY-STATE                            
                          RS-MAIL-ZIP-CODE                              
                          RS-MAIL-ADDRESS-OVERFLOW.                     
                                                                        
P00704     EVALUATE DM-ADDRESS-FORMAT                                   
P00704         WHEN 'A'                                                 
P00704             MOVE DM-ADDRESS-ID TO DY-ADDRESS-ID                  
P00704             PERFORM 7150-SELECT-ADDR-FMT THRU 7150-EXIT          
P00704             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL           
P00704                MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE      
P00704                MOVE DY-ADDRESS-ID TO RS-MAIL-ADDRESS-ID          
P00704                MOVE WS-ADDRESS-LINE-1 TO RS-MAIL-STREET          
P00704                MOVE WS-ADDRESS-LINE-2 TO RS-MAIL-CITY-STATE      
P00704                MOVE WS-ZIP-CODE TO RS-MAIL-ZIP-CODE              
P00704                MOVE DY-ADDRESS-OVERFLOW TO                       
P00704                     RS-MAIL-ADDRESS-OVERFLOW                     
P00704             END-IF                                               
P00704         WHEN 'B'                                                 
P00704             MOVE DM-ADDRESS-ID TO DZ-ADDRESS-ID                  
P00704             PERFORM 7100-SELECT-ADDR-FREE THRU 7100-EXIT         
P00704             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL           
P00704                MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE      
P00704                MOVE DZ-ADDRESS-ID TO RS-MAIL-ADDRESS-ID          
P00704                MOVE DZ-ADDR-STREET TO RS-MAIL-STREET             
P00704                MOVE DZ-ADDR-CITY-STATE TO RS-MAIL-CITY-STATE     
P00704                MOVE DZ-ADDR-ZIP-CODE TO RS-MAIL-ZIP-CODE         
P00704                MOVE DZ-ADDRESS-OVERFLOW TO                       
P00704                     RS-MAIL-ADDRESS-OVERFLOW                     
P00704             END-IF                                               
P00704     END-EVALUATE.                                                
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07560000
      * 7000-SELECT-CUST-ADDR-X                                       * 07570002
      *      TO GET THE ADDRESS-ID FOR THE CUSTOMER FOR A GIVEN       * 07571002
      *      ADDRESS TYPE                                             * 07572002
      ******************************************************************07580000
                                                                        
       7000-SELECT-CUST-ADDR-X.                                         
                                                                        
           EXEC SQL                                                     
              SELECT TOP(1) CUSTOMER_NO,
              ADDRESS_TYPE,
              ADDRESS_ID,
              ADDRESS_FORMAT                                     
              INTO  :DM-CUSTOMER-NO,                                    
                    :DM-ADDRESS-TYPE,                                   
                    :DM-ADDRESS-ID,                                     
                    :DM-ADDRESS-FORMAT                                  
              FROM   CSS_CUST_ADDR_XREF WITH(READUNCOMMITTED)                   
              WHERE  CUSTOMER_NO  = :DM-CUSTOMER-NO  AND                
                     ADDRESS_TYPE = :DM-ADDRESS-TYPE                    
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07620000
MFA-TR*       SELECT CUSTOMER_NO,                                       07630000
MFA-TR*              ADDRESS_TYPE,                                      07640000
MFA-TR*              ADDRESS_ID,                                        07650001
MFA-TR*              ADDRESS_FORMAT                                     07660001
MFA-TR*       INTO  :DM-CUSTOMER-NO,                                    07700001
MFA-TR*             :DM-ADDRESS-TYPE,                                   07710001
MFA-TR*             :DM-ADDRESS-ID,                                     07720001
MFA-TR*             :DM-ADDRESS-FORMAT                                  07730001
MFA-TR*       FROM   CSS_CUST_ADDR_XREF                                 07770001
MFA-TR*       WHERE  CUSTOMER_NO  = :DM-CUSTOMER-NO  AND                07780001
MFA-TR*              ADDRESS_TYPE = :DM-ADDRESS-TYPE                    07790001
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                    07800000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7000'          TO ACTIVE-PARAGRAPH                  
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CUST_ADDR_XREF' TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE 'ADDRESS_TYPE'       TO TABLE-ELEMENT-2              
              MOVE DM-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE DM-ADDRESS-TYPE      TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************08011001
      * 7100-SELECT-ADDR-FREE                                         * 08012002
      ******************************************************************08013001
                                                                        
       7100-SELECT-ADDR-FREE.                                           
                                                                        
           EXEC SQL                                                     
              SELECT ADDRESS_ID,                                        
                     ADDR_STREET,                                       
                     ADDR_CITY_STATE,                                   
                     ADDR_ZIP_CODE,                                     
                     ADDRESS_OVERFLOW                                   
              INTO  :DZ-ADDRESS-ID,                                     
                    :DZ-ADDR-STREET,                                    
                    :DZ-ADDR-CITY-STATE,                                
                    :DZ-ADDR-ZIP-CODE,                                  
                    :DZ-ADDRESS-OVERFLOW                                
              FROM   CSS_ADDR_FREEFORM WITH(READUNCOMMITTED)                    
              WHERE  ADDRESS_ID   = :DZ-ADDRESS-ID                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08017001
MFA-TR*       SELECT ADDRESS_ID,                                        08018001
MFA-TR*              ADDR_STREET,                                       08019101
MFA-TR*              ADDR_CITY_STATE,                                   08019201
MFA-TR*              ADDR_ZIP_CODE,                                     08019301
MFA-TR*              ADDRESS_OVERFLOW                                   08019501
MFA-TR*       INTO  :DZ-ADDRESS-ID,                                     08019601
MFA-TR*             :DZ-ADDR-STREET,                                    08019801
MFA-TR*             :DZ-ADDR-CITY-STATE,                                08019901
MFA-TR*             :DZ-ADDR-ZIP-CODE,                                  08020001
MFA-TR*             :DZ-ADDRESS-OVERFLOW                                08020201
MFA-TR*       FROM   CSS_ADDR_FREEFORM                                  08020301
MFA-TR*       WHERE  ADDRESS_ID   = :DZ-ADDRESS-ID                      08020401
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                    08020601

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7100'          TO ACTIVE-PARAGRAPH                  
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-2              
              MOVE DZ-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE PARM-CUSTOMER-NO     TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00704 7150-SELECT-ADDR-FMT.                                            
P00704                                                                  
P00704     EXEC SQL                                                     
P00704        SELECT ADDRESS_ID,                                        
P00704               RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(RTRIM(
           ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + ' ' + 
           LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(STREET_SUFFIX
           ) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(STREET_LOCATION_2))))
           )))))),     
P00704               RTRIM(LTRIM(RTRIM(TOWN) + ', ' + LTRIM(RTRIM(STATE)
           ))),                       
P00704               DY.ZIP_CODE + DY.ZIP_CODE_PLUS_FOUR,                       
P00704               ADDRESS_OVERFLOW                                   
P00704        INTO  :DY-ADDRESS-ID,                                     
P00704              :WS-ADDRESS-LINE-1,                                 
P00704              :WS-ADDRESS-LINE-2,                                 
P00704              :WS-ZIP-CODE,                                       
P00704              :DY-ADDRESS-OVERFLOW                                
P00704        FROM   CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),               
P00704               CSS_ZIP_CODE A4 WITH(READUNCOMMITTED)                      
P00704        WHERE  ADDRESS_ID = :DY-ADDRESS-ID                        
P00704          AND DY.ZIP_CODE = A4.ZIP_CODE                           
P00704          AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN               
P00704                                                           
P00704                                                      
P00704     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                     08017001
MFA-TR*       SELECT ADDRESS_ID,                                        08018001
MFA-TR*              RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||                      
MFA-TR*                    LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                 
MFA-TR*                    LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                 
MFA-TR*                    LTRIM(RTRIM(STREET_NAME) || ' ' ||                   
MFA-TR*                    LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                 
MFA-TR*                    LTRIM(RTRIM(ADDR_SUFFIX) || ' ' ||                   
MFA-TR*                    LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||             
MFA-TR*                    LTRIM(RTRIM(STREET_LOCATION_2)))))))))),             
MFA-TR*              RTRIM(LTRIM(RTRIM(TOWN) || ', ' ||                         
MFA-TR*                    LTRIM(RTRIM(STATE)))),                               
MFA-TR*              DY.ZIP_CODE ||                                     08019301
MFA-TR*              DY.ZIP_CODE_PLUS_FOUR,                             08019301
MFA-TR*              ADDRESS_OVERFLOW                                   08019501
MFA-TR*       INTO  :DY-ADDRESS-ID,                                     08019601
MFA-TR*             :WS-ADDRESS-LINE-1,                                 08019801
MFA-TR*             :WS-ADDRESS-LINE-2,                                 08019901
MFA-TR*             :WS-ZIP-CODE,                                       08020001
MFA-TR*             :DY-ADDRESS-OVERFLOW                                08020201
MFA-TR*       FROM   CSS_ADDR_FORMATTED DY,                             08020301
MFA-TR*              CSS_ZIP_CODE A4                                    08020301
MFA-TR*       WHERE  ADDRESS_ID = :DY-ADDRESS-ID                        08020401
MFA-TR*         AND DY.ZIP_CODE = A4.ZIP_CODE                                   
MFA-TR*         AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN                       
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7150                                                      
MFA-TR*    END-EXEC.                                                    08020601

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00704                                                                  
P00704     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00704                                                                  
P00704     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
P00704        NEXT SENTENCE                                             
P00704     ELSE                                                         
P00704        MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
P00704        MOVE '7150'          TO ACTIVE-PARAGRAPH                  
P00704        MOVE 'SELECT'             TO ABEND-FUNCTION               
P00704        MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                      
P00704        MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
P00704        MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-2              
P00704        MOVE DY-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
P00704        MOVE PARM-CUSTOMER-NO     TO HOSTVAR-ELEMENT-2            
P00704        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00704        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00704     END-IF.                                                      
P00704                                                                  
P00704 7150-EXIT.                                                       
P00704     EXIT.                                                        
                                                                        
      ******************************************************************08023000
      * 7200-SELECT-BUS-STATS                                         * 08030001
      ******************************************************************08040000
                                                                        
       7200-SELECT-BUS-STATS.                                           
                                                                        
           EXEC SQL                                                     
              SELECT CUSTOMER_NO,                                       
                     HOME_OFFICE_NAME                                   
              INTO  :BS-CUSTOMER-NO,                                    
                    :BS-HOME-OFFICE-NAME                                
              FROM   CSS_BUS_CUST_STATS WITH(READUNCOMMITTED)                   
              WHERE  CUSTOMER_NO  = :BS-CUSTOMER-NO                     
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08080003
MFA-TR*       SELECT CUSTOMER_NO,                                       08090003
MFA-TR*              HOME_OFFICE_NAME                                   08100003
MFA-TR*       INTO  :BS-CUSTOMER-NO,                                    08110003
MFA-TR*             :BS-HOME-OFFICE-NAME                                08120003
MFA-TR*       FROM   CSS_BUS_CUST_STATS                                 08130003
MFA-TR*       WHERE  CUSTOMER_NO  = :BS-CUSTOMER-NO                     08140003
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                    08150003

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7200'          TO ACTIVE-PARAGRAPH                  
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_BUS_CUST_STATS' TO TABLE-1                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE BS-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************08360000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *08370000
      ******************************************************************08380000
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************08440000
      *       END PROGRAM COPYLIB                                      *08450000
      ******************************************************************08460000
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
