       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02197.                                         
COB303 DATE-WRITTEN.     JANUARY 9, 1995.                               
       DATE-COMPILED.                                                   
      **************************************************************            
      *                 P R O G R A M  S U M M A R Y            *               
      *                                                         *               
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM      *               
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                *               
      *  THIS PROGRAM RETRIEVES THE DATA DISPLAYED IN  WINDOW OF*               
      *  PANEL262 WHICH INVOLVES TABLES CV, DW, DT, LP, DB, CB, *               
      *  HT, PF.                                                *               
      ***********************************************************               
      *                                                         *               
      *                     PROGRAM MODIFICATION LOG            *               
      *                                                         *               
      *    DATE    INITIALS   COMMENTS                          *               
      *  --------  --------   --------------------------------- *               
      *  11/30/95    PP       CODED THIS RPC.                   *               
PCR   *  10/07/97    GC       PCR - MEMO BILLING MODS - PANEL262*               
PCR   *                       NOW HAS 1 FIELD FOR NAME, NOT 3.  *               
PCR   *                       SO IF FULL-NAME IS EMPTY, PUT 1ST,*               
PCR   *                       MID, AND LAST NAME INTO IT.       *               
T14065*  12/16/97    GC       TPR - IF NO ROWS ARE FOUND, DON'T *               
T14065*                       WRITE AN ABEND RECORD TO MC05.    *               
T13230*  02/23/98    PRA      ADD NICKNAME TO PANEL & FULL NAME.*               
CBSI  *  09/23/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL *               
CBSI  *             MADRAS    THE ABEND PARAMETERS              *               
REARCH*  07/19/05    CVNS     RPC TO COBOL SP CONVERSION        *               
REARCH*              CHENNAI                                    *               
C34788*  10/25/07    MSR      DO NOT APPEND NICKNAME TO FULL    *               
C34788*                       NAME.                             *               
C34788*  05/13/08    SRIDHAR  INCREASE NAME AND ADDRESS LENGTH  *               
A04527*  06/07/13    MR7E794  REMOVED UNUSED COPYBOOK CWS00056. *               
      ***********************************************************               
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02197'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START           PIC X(40) VALUE                           
                'WORKING STORAGE FOR CSR02197 STARTS HERE'.             
                                                                        
           EXEC SQL                                                             
             INCLUDE SQLCA                                                      
           END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE TBCNTACT                                                
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE TBCNTCAT                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE TBCNTCCS                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE TBCNTCPR                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
               INCLUDE TBCNTPHN                                                 
           END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE TBCSTPHN                                                
           END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE TBADRFRE                                                
           END-EXEC.                                                            
P00740     EXEC SQL                                                             
P00740          INCLUDE TBADRFMT                                                
P00740     END-EXEC.                                                            
P00740     EXEC SQL                                                             
P00740          INCLUDE TBZIPCD                                                 
P00740     END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE TBNMACTX                                                
           END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE TBNAME                                                  
           END-EXEC.                                                            
                                                                        
T36932     EXEC SQL                                                             
T36932          INCLUDE CWS0011A                                                
T36932     END-EXEC.                                                            
           COPY CCA00001.                                                       
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                            
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
                                                                        
       01  WS-MISC.                                                     
           05 WS-CONTACT-ENTITY-IND PIC X(01) VALUE SPACES.             
           05 PROGRAM-NAME         PIC X(8)  VALUE 'CSR02197'.          
           05 WS-SQLSTATE          PIC X(5).                            
P00740     05 WS-ADDR-STREET       PIC X(80).                           
P00740     05 WS-ADDR-CITY-STATE   PIC X(80).                           
P00740     05 WS-ADDR-ZIP-CODE     PIC X(10).                           
P00740     05 WS-ADDRESS-OVERFLOW  PIC X(80).                           
P00740     05 WS-NULL-1            PIC S9(4) COMP VALUE 0.              
P00740     05 WS-NULL-2            PIC S9(4) COMP VALUE 0.              
P00740     05 WS-NULL-3            PIC S9(4) COMP VALUE 0.              
P00740     05 WS-NULL-4            PIC S9(4) COMP VALUE 0.              
P00740     05 WS-NULL-5            PIC S9(4) COMP VALUE 0.              
                                                                        
       01  SWITCHES.                                                    
           05 ALL-DONE-SW       PIC X(01) VALUE 'N'.                    
               88 NOT-ALL-DONE            VALUE 'N'.                    
               88 ALL-DONE                VALUE 'Y'.                    
           05 SEND-DONE-SW      PIC X(01) VALUE 'Y'.                    
               88 SEND-DONE-ERROR         VALUE 'N'.                    
               88 SEND-DONE-OK            VALUE 'Y'.                    
                                                                        
       01  SNA-FIELDS.                                                  
           05 SNA-SUBC          PIC S9(9) COMP.                         
           05 SNA-CONNECTION-NAME PIC X(8) VALUE SPACES.                
                                                                        
       01  COUNTER-FIELDS.                                              
           05 CTR-COLUMN        PIC S9(9) COMP VALUE 1.                 
           05 CTR-ROWS          PIC S9(9) COMP VALUE 0.                 
           05 WS-ROW-COUNT      PIC S9(9) COMP VALUE 0.                 
                                                                        
       01  WORK-FIELDS.                                                 
           05 MAX-LENGTH-PARM   PIC S9(9) COMP.                         
           05 WRKLEN1           PIC S9(9) COMP.                         
           05 WRKLEN2           PIC S9(9) COMP.                         
           05 WRK-DONE-STATUS   PIC S9(9) COMP.                         
                                                                        
       01  FILLER PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA'.        
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05 RS-RETURN-CODE        PIC S9(9)  COMP VALUE 0.            
           05 RS-NAME-ID            PIC S9(13)V COMP-3 VALUE 0.         
           05 RS-ADDR-COUNTRY       PIC X(35)  VALUE SPACES.            
           05 RS-CONTACT-ID         PIC S9(10)V COMP-3 VALUE 0.         
           05 RS-NAME-TYPE          PIC X(02)  VALUE SPACES.            
           05 RS-ADDRESS-ID         PIC S9(13)V COMP-3 VALUE 0.         
           05 RS-CONTACT-ENTITY     PIC X(01)  VALUE SPACES.            
           05 RS-CONTACT-TYPE       PIC X(02)  VALUE SPACES.            
           05 RS-FIRST-NAME         PIC X(15)  VALUE SPACES.            
           05 RS-MIDDLE-NAME        PIC X(15)  VALUE SPACES.            
T36932     05 RS-LAST-NAME          PIC X(40)  VALUE SPACES.            
           05 RS-CONTACT-POSITION   PIC X(30)  VALUE SPACES.            
           05 RS-CONTACT-ORDER      PIC S9(4)  COMP VALUE 0.            
T36932     05 RS-ADDR-STREET        PIC X(55)  VALUE SPACES.            
T36932     05 RS-ADDR-CITY-STATE    PIC X(30)  VALUE SPACES.            
           05 RS-ADDR-ZIP-CODE      PIC X(09)  VALUE SPACES.            
           05 RS-ADDRESS-OVERFLOW   PIC X(35)  VALUE SPACES.            
           05 RS-PHONE-TYPE         PIC X(02)  VALUE SPACES.            
           05 RS-PHONE-NO           PIC X(10)  VALUE SPACES.            
           05 RS-EXTENSION-NO       PIC X(06)  VALUE SPACES.            
           05 RS-REPEAT-COUNT       PIC S9(04) COMP VALUE 0.            
T36932     05 RS-FULL-NAME          PIC X(76)  VALUE SPACES.            
T36932     05 RS-NICKNAME           PIC X(50)  VALUE SPACES.            
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05 S-RETURN-CODE        PIC S9(9)  COMP VALUE 0.             
           05 S-NAME-ID            PIC S9(13)V COMP-3 VALUE 0.          
           05 S-ADDR-COUNTRY       PIC X(35)  VALUE SPACES.             
           05 S-CONTACT-ID         PIC S9(10)V COMP-3 VALUE 0.          
           05 S-NAME-TYPE          PIC X(02)  VALUE SPACES.             
           05 S-ADDRESS-ID         PIC S9(13)V COMP-3 VALUE 0.          
           05 S-CONTACT-ENTITY     PIC X(01)  VALUE SPACES.             
           05 S-CONTACT-TYPE       PIC X(02)  VALUE SPACES.             
           05 S-FIRST-NAME         PIC X(15)  VALUE SPACES.             
           05 S-MIDDLE-NAME        PIC X(15)  VALUE SPACES.             
T36932     05 S-LAST-NAME          PIC X(40)  VALUE SPACES.             
           05 S-CONTACT-POSITION   PIC X(30)  VALUE SPACES.             
           05 S-CONTACT-ORDER      PIC S9(4)  COMP VALUE 0.             
           05 S-ADDR-STREET        PIC X(55)  VALUE SPACES.             
T36932     05 S-ADDR-CITY-STATE    PIC X(30)  VALUE SPACES.             
T36932     05 S-ADDR-ZIP-CODE      PIC X(09)  VALUE SPACES.             
           05 S-ADDRESS-OVERFLOW   PIC X(35)  VALUE SPACES.             
           05 S-PHONE-TYPE         PIC X(02)  VALUE SPACES.             
           05 S-PHONE-NO           PIC X(10)  VALUE SPACES.             
           05 S-EXTENSION-NO       PIC X(06)  VALUE SPACES.             
           05 S-REPEAT-COUNT       PIC S9(04) COMP VALUE 0.             
T36932     05 S-FULL-NAME          PIC X(76)  VALUE SPACES.             
T36932     05 S-NICKNAME           PIC X(50)  VALUE SPACES.             
                                                                        
           EXEC SQL                                                     
           DECLARE DW-CURSOR CURSOR FOR                                 
             SELECT DW.CONTACT_ID,                                      
                    CV.ADDRESS_ID,                                      
                    CV.CONTACT_ORDER,                                   
                    CV.CONTACT_POSITION,                                
                    CV.CONTACT_TYPE,                                    
                    CV.NAME_ID,                                         
P00740              CV.ADDRESS_FORMAT,                                  
                    DZ.ADDR_STREET,                                     
                    DZ.ADDR_CITY_STATE,                                 
                    DZ.ADDR_ZIP_CODE,                                   
                    DZ.ADDR_COUNTRY,                                    
                    DZ.ADDRESS_OVERFLOW,                                
                    DQ.FIRST_NAME,                                      
                    DQ.MIDDLE_NAME,                                     
                    DQ.LAST_NAME,                                       
                    DQ.NAME_TYPE,                                       
                    DQ.FULL_NAME,                                       
T13230              DQ.NICKNAME                                         
             FROM   CSS_CONTACT_ACCT DW, CSS_NAME DQ,                   
                    CSS_CONTACT CV                                      
P00740              LEFT OUTER JOIN CSS_ADDR_FREEFORM DZ                
P00740                ON CV.ADDRESS_ID = DZ.ADDRESS_ID                  
             WHERE  DW.ACCOUNT_NO = :DW-ACCOUNT-NO                      
             AND    DW.CONTACT_ID = CV.CONTACT_ID                       
             AND    CV.NAME_ID    = DQ.NAME_ID                          
P00740                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*    DECLARE DW-CURSOR CURSOR FOR                                         
MFA-TR*      SELECT DW.CONTACT_ID,                                              
MFA-TR*             CV.ADDRESS_ID,                                              
MFA-TR*             CV.CONTACT_ORDER,                                           
MFA-TR*             CV.CONTACT_POSITION,                                        
MFA-TR*             CV.CONTACT_TYPE,                                            
MFA-TR*             CV.NAME_ID,                                                 
MFA-TR*             CV.ADDRESS_FORMAT,                                          
MFA-TR*             DZ.ADDR_STREET,                                             
MFA-TR*             DZ.ADDR_CITY_STATE,                                         
MFA-TR*             DZ.ADDR_ZIP_CODE,                                           
MFA-TR*             DZ.ADDR_COUNTRY,                                            
MFA-TR*             DZ.ADDRESS_OVERFLOW,                                        
MFA-TR*             DQ.FIRST_NAME,                                              
MFA-TR*             DQ.MIDDLE_NAME,                                             
MFA-TR*             DQ.LAST_NAME,                                               
MFA-TR*             DQ.NAME_TYPE,                                               
MFA-TR*             DQ.FULL_NAME,                                               
MFA-TR*             DQ.NICKNAME                                                 
MFA-TR*      FROM   CSS_CONTACT_ACCT DW, CSS_NAME DQ,                           
MFA-TR*             CSS_CONTACT CV                                              
MFA-TR*             LEFT OUTER JOIN CSS_ADDR_FREEFORM DZ                        
MFA-TR*               ON CV.ADDRESS_ID = DZ.ADDRESS_ID                          
MFA-TR*      WHERE  DW.ACCOUNT_NO = :DW-ACCOUNT-NO                              
MFA-TR*      AND    DW.CONTACT_ID = CV.CONTACT_ID                               
MFA-TR*      AND    CV.NAME_ID    = DQ.NAME_ID                                  
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
           DECLARE DT-CURSOR CURSOR FOR                                 
             SELECT DT.CONTACT_ID,                                      
                    CV.ADDRESS_ID,                                      
                    CV.CONTACT_ORDER,                                   
                    CV.CONTACT_POSITION,                                
                    CV.CONTACT_TYPE,                                    
                    CV.NAME_ID,                                         
P00740              CV.ADDRESS_FORMAT,                                  
                    DZ.ADDR_STREET,                                     
                    DZ.ADDR_CITY_STATE,                                 
                    DZ.ADDR_ZIP_CODE,                                   
                    DZ.ADDR_COUNTRY,                                    
                    DZ.ADDRESS_OVERFLOW,                                
                    DQ.FIRST_NAME,                                      
                    DQ.MIDDLE_NAME,                                     
                    DQ.LAST_NAME,                                       
                    DQ.NAME_TYPE,                                       
                    DQ.FULL_NAME,                                       
T13230              DQ.NICKNAME                                         
             FROM   CSS_CONTACT_CUST DT, CSS_NAME DQ,                   
                    CSS_CONTACT CV                                      
P00740              LEFT OUTER JOIN CSS_ADDR_FREEFORM DZ                
P00740                ON CV.ADDRESS_ID = DZ.ADDRESS_ID                  
             WHERE  DT.CUSTOMER_NO = :DT-CUSTOMER-NO                    
             AND    DT.CONTACT_ID = CV.CONTACT_ID                       
             AND    CV.NAME_ID    = DQ.NAME_ID                          
P00740                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*    DECLARE DT-CURSOR CURSOR FOR                                         
MFA-TR*      SELECT DT.CONTACT_ID,                                              
MFA-TR*             CV.ADDRESS_ID,                                              
MFA-TR*             CV.CONTACT_ORDER,                                           
MFA-TR*             CV.CONTACT_POSITION,                                        
MFA-TR*             CV.CONTACT_TYPE,                                            
MFA-TR*             CV.NAME_ID,                                                 
MFA-TR*             CV.ADDRESS_FORMAT,                                          
MFA-TR*             DZ.ADDR_STREET,                                             
MFA-TR*             DZ.ADDR_CITY_STATE,                                         
MFA-TR*             DZ.ADDR_ZIP_CODE,                                           
MFA-TR*             DZ.ADDR_COUNTRY,                                            
MFA-TR*             DZ.ADDRESS_OVERFLOW,                                        
MFA-TR*             DQ.FIRST_NAME,                                              
MFA-TR*             DQ.MIDDLE_NAME,                                             
MFA-TR*             DQ.LAST_NAME,                                               
MFA-TR*             DQ.NAME_TYPE,                                               
MFA-TR*             DQ.FULL_NAME,                                               
MFA-TR*             DQ.NICKNAME                                                 
MFA-TR*      FROM   CSS_CONTACT_CUST DT, CSS_NAME DQ,                           
MFA-TR*             CSS_CONTACT CV                                              
MFA-TR*             LEFT OUTER JOIN CSS_ADDR_FREEFORM DZ                        
MFA-TR*               ON CV.ADDRESS_ID = DZ.ADDRESS_ID                          
MFA-TR*      WHERE  DT.CUSTOMER_NO = :DT-CUSTOMER-NO                            
MFA-TR*      AND    DT.CONTACT_ID = CV.CONTACT_ID                               
MFA-TR*      AND    CV.NAME_ID    = DQ.NAME_ID                                  
MFA-TR*      QUERYNO 7200                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
           DECLARE DX-CURSOR CURSOR FOR                                 
             SELECT DX.CONTACT_ID,                                      
                    CV.ADDRESS_ID,                                      
                    CV.CONTACT_ORDER,                                   
                    CV.CONTACT_POSITION,                                
                    CV.CONTACT_TYPE,                                    
                    CV.NAME_ID,                                         
P00740              CV.ADDRESS_FORMAT,                                  
                    DZ.ADDR_STREET,                                     
                    DZ.ADDR_CITY_STATE,                                 
                    DZ.ADDR_ZIP_CODE,                                   
                    DZ.ADDR_COUNTRY,                                    
                    DZ.ADDRESS_OVERFLOW,                                
                    DQ.FIRST_NAME,                                      
                    DQ.MIDDLE_NAME,                                     
                    DQ.LAST_NAME,                                       
                    DQ.NAME_TYPE,                                       
                    DQ.FULL_NAME,                                       
T13230              DQ.NICKNAME                                         
             FROM   CSS_CONTACT_PREM DX, CSS_NAME DQ,                   
                    CSS_CONTACT CV                                      
P00740              LEFT OUTER JOIN CSS_ADDR_FREEFORM DZ                
P00740                ON CV.ADDRESS_ID = DZ.ADDRESS_ID                  
             WHERE  DX.PREMISE_NO = :DX-PREMISE-NO                      
             AND    DX.CONTACT_ID = CV.CONTACT_ID                       
             AND    CV.NAME_ID    = DQ.NAME_ID                          
P00740                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*    DECLARE DX-CURSOR CURSOR FOR                                         
MFA-TR*      SELECT DX.CONTACT_ID,                                              
MFA-TR*             CV.ADDRESS_ID,                                              
MFA-TR*             CV.CONTACT_ORDER,                                           
MFA-TR*             CV.CONTACT_POSITION,                                        
MFA-TR*             CV.CONTACT_TYPE,                                            
MFA-TR*             CV.NAME_ID,                                                 
MFA-TR*             CV.ADDRESS_FORMAT,                                          
MFA-TR*             DZ.ADDR_STREET,                                             
MFA-TR*             DZ.ADDR_CITY_STATE,                                         
MFA-TR*             DZ.ADDR_ZIP_CODE,                                           
MFA-TR*             DZ.ADDR_COUNTRY,                                            
MFA-TR*             DZ.ADDRESS_OVERFLOW,                                        
MFA-TR*             DQ.FIRST_NAME,                                              
MFA-TR*             DQ.MIDDLE_NAME,                                             
MFA-TR*             DQ.LAST_NAME,                                               
MFA-TR*             DQ.NAME_TYPE,                                               
MFA-TR*             DQ.FULL_NAME,                                               
MFA-TR*             DQ.NICKNAME                                                 
MFA-TR*      FROM   CSS_CONTACT_PREM DX, CSS_NAME DQ,                           
MFA-TR*             CSS_CONTACT CV                                              
MFA-TR*             LEFT OUTER JOIN CSS_ADDR_FREEFORM DZ                        
MFA-TR*               ON CV.ADDRESS_ID = DZ.ADDRESS_ID                          
MFA-TR*      WHERE  DX.PREMISE_NO = :DX-PREMISE-NO                              
MFA-TR*      AND    DX.CONTACT_ID = CV.CONTACT_ID                               
MFA-TR*      AND    CV.NAME_ID    = DQ.NAME_ID                                  
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
       01  CSRERLOG-P.                                                  
        10  S-SP-NAME                 PIC X(18) VALUE SPACES.           
        10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.           
        10  S-SQLSTATE                PIC X(5)  VALUE ' '.              
        10  S-TABLE-NAME              PIC X(18) VALUE SPACES.           
        10  S-HOST-VARIABLES.                                           
             49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.            
             49  S-HOST-VARIABLES-V    PIC X(255).                      
         10  S-SQL-STATEMENT.                                           
             49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.            
             49  S-SQL-STATEMENT-V     PIC X(255).                      
         10  S-SQL-DESCRIPTION.                                         
             49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.            
             49  S-SQL-DESCRIPTION-V   PIC X(255).                      
                                                                        
           EXEC SQL                                                     
           DECLARE LP-CURSOR CURSOR FOR                                 
             SELECT PHONE_TYPE,                                         
             PHONE_NO,                                                  
             EXTENSION_NO                                               
             FROM CSS_CONTACT_PHONE                                     
             WHERE CONTACT_ID = :LP-CONTACT-ID                          
P00740                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*    DECLARE LP-CURSOR CURSOR FOR                                         
MFA-TR*      SELECT PHONE_TYPE,                                                 
MFA-TR*      PHONE_NO,                                                          
MFA-TR*      EXTENSION_NO                                                       
MFA-TR*      FROM CSS_CONTACT_PHONE                                             
MFA-TR*      WHERE CONTACT_ID = :LP-CONTACT-ID                                  
MFA-TR*      QUERYNO 7400                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
       LINKAGE SECTION.                                                 
       01 PARM-ACCOUNT-NO   PIC X(13).                                  
       01 PARM-CUSTOMER-NO  PIC X(10).                                  
       01 PARM-PREMISE-NO   PIC X(10).                                  
                                                                        
       PROCEDURE DIVISION USING PARM-ACCOUNT-NO                         
                                PARM-CUSTOMER-NO                        
                                PARM-PREMISE-NO.                        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           PERFORM 0110-INIT-CV-RS THRU 0110-EXIT.                      
           PERFORM 0120-INIT-LP-RS THRU 0120-EXIT.                      
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           PERFORM 0100A-DECLARE-GTT THRU 0100A-EXIT.                   
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT                                                   
                      RETURN_CODE                                       
                     ,CONTACT_ENTITY_IND                                
                     ,NAME_ID                                           
                     ,CONTACT_TYPE                                      
                     ,CONTACT_ORDER                                     
                     ,LTRIM(RTRIM(CONTACT_POSITION))  AS 
           CONTACT_POSITION      
                     ,LTRIM(RTRIM(ADDR_STREET)) AS ADDR_STREET                 
                     ,LTRIM(RTRIM(ADDR_CITY_STATE))   AS ADDR_CITY_STATE       
                     ,LTRIM(RTRIM(ADDR_ZIP_CODE))     AS ADDR_ZIP_CODE         
                     ,LTRIM(RTRIM(ADDR_COUNTRY))      AS ADDR_COUNTRY          
                     ,LTRIM(RTRIM(ADDRESS_OVERFLOW))  AS 
           ADDRESS_OVERFLOW      
                     ,PHONE_TYPE                                        
                     ,LTRIM(RTRIM(PHONE_NO))          AS PHONE_NO              
                     ,LTRIM(RTRIM(EXTENSION_NO))      AS EXTENSION_NO          
                     ,REPEAT_COUNT                                      
                     ,CONTACT_ID                                        
                     ,LTRIM(RTRIM(FIRST_NAME))        AS FIRST_NAME            
                     ,LTRIM(RTRIM(MIDDLE_NAME))       AS MIDDLE_NAME           
                     ,LTRIM(RTRIM(LAST_NAME))         AS LAST_NAME             
                     ,LTRIM(RTRIM(NAME_TYPE))         AS NAME_TYPE             
                     ,ADDRESS_ID                                        
                     ,LTRIM(RTRIM(FULL_NAME))         AS FULL_NAME             
                     ,LTRIM(RTRIM(NICKNAME))          AS NICKNAME              
C34788               ,'N'                      AS SSN                   
C34788               ,'N'                      AS FORMATTED             
               FROM                                                     
                    #CSR02197_R1                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*               RETURN_CODE                                               
MFA-TR*              ,CONTACT_ENTITY_IND                                        
MFA-TR*              ,NAME_ID                                                   
MFA-TR*              ,CONTACT_TYPE                                              
MFA-TR*              ,CONTACT_ORDER                                             
MFA-TR*              ,STRIP(CONTACT_POSITION)  AS CONTACT_POSITION              
MFA-TR*              ,STRIP(ADDR_STREET) AS ADDR_STREET                         
MFA-TR*              ,STRIP(ADDR_CITY_STATE)   AS ADDR_CITY_STATE               
MFA-TR*              ,STRIP(ADDR_ZIP_CODE)     AS ADDR_ZIP_CODE                 
MFA-TR*              ,STRIP(ADDR_COUNTRY)      AS ADDR_COUNTRY                  
MFA-TR*              ,STRIP(ADDRESS_OVERFLOW)  AS ADDRESS_OVERFLOW              
MFA-TR*              ,PHONE_TYPE                                                
MFA-TR*              ,STRIP(PHONE_NO)          AS PHONE_NO                      
MFA-TR*              ,STRIP(EXTENSION_NO)      AS EXTENSION_NO                  
MFA-TR*              ,REPEAT_COUNT                                              
MFA-TR*              ,CONTACT_ID                                                
MFA-TR*              ,STRIP(FIRST_NAME)        AS FIRST_NAME                    
MFA-TR*              ,STRIP(MIDDLE_NAME)       AS MIDDLE_NAME                   
MFA-TR*              ,STRIP(LAST_NAME)         AS LAST_NAME                     
MFA-TR*              ,STRIP(NAME_TYPE)         AS NAME_TYPE                     
MFA-TR*              ,ADDRESS_ID                                                
MFA-TR*              ,STRIP(FULL_NAME)         AS FULL_NAME                     
MFA-TR*              ,STRIP(NICKNAME)          AS NICKNAME                      
MFA-TR*              ,'N'                      AS SSN                           
MFA-TR*              ,'N'                      AS FORMATTED                     
MFA-TR*        FROM                                                             
MFA-TR*             SESSION.CSR02197_R1                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100A-DECLARE-GTT.                                               
                                                                        
           MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR02197_R1'            
                                          TO S-SQL-STATEMENT-V.         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02197_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02197_R1
              (                                                       
                      RETURN_CODE              INT                  
                     ,NAME_ID                  DECIMAL(13,0)            
                     ,ADDR_COUNTRY CHAR(35)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                 
                     ,CONTACT_ID               DECIMAL(10,0)            
                     ,NAME_TYPE CHAR(02)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                 
                     ,ADDRESS_ID               DECIMAL(13,0)            
                     ,CONTACT_ENTITY_IND CHAR(01)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                 
                     ,CONTACT_TYPE CHAR(02)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                 
                     ,FIRST_NAME CHAR(15)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                 
                     ,MIDDLE_NAME CHAR(15)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                 
T36932               ,LAST_NAME CHAR(40)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                 
                     ,CONTACT_POSITION CHAR(30)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                 
                     ,CONTACT_ORDER            SMALLINT                 
T36932               ,ADDR_STREET CHAR(55)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                 
T36932               ,ADDR_CITY_STATE CHAR(30)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                 
                     ,ADDR_ZIP_CODE CHAR(09)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                 
                     ,ADDRESS_OVERFLOW CHAR(35)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                 
                     ,PHONE_TYPE CHAR(02)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                 
                     ,PHONE_NO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
                     ,EXTENSION_NO CHAR(06)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                 
                     ,REPEAT_COUNT             SMALLINT                 
T36932               ,FULL_NAME CHAR(76)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                 
T36932               ,NICKNAME CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2        
C34788               ,SSN CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2             
C34788               ,FORMATTED CHAR(01)  COLLATE 
                                   LATIN1_GENERAL_100_BIN2                 
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
           IF WS-SQLSTATE = '42710'                                     
                   PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT        
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  NEXT SENTENCE                                         
               ELSE                                                     
                  MOVE PROGRAM-NAME           TO ABEND-PROGRAM          
                  MOVE SQLCODE                TO ABEND-SQLCODE          
                  MOVE SQLSTATE               TO ABEND-SQLSTATE         
                  MOVE '0100A'                TO ACTIVE-PARAGRAPH       
                  MOVE 'DECLARE GTT'          TO ABEND-FUNCTION         
                  MOVE SPACES                 TO ABEND-SQL-PREDICATES   
                                             ABEND-TABLES               
                  MOVE 'CSR03501_R1'          TO TABLE-1                
                  MOVE SPACES                 TO TABLE-ELEMENT-1        
                  MOVE SPACES                 TO HOSTVAR-ELEMENT-1      
                  PERFORM 9900-SQL-ERROR-ROUTINE      THRU  9900-EXIT   
               END-IF                                                   
           END-IF.                                                      
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
                                                                        
       0110-INIT-CV-RS.                                                 
                                                                        
           MOVE ZEROES TO RS-RETURN-CODE.                               
           MOVE ZEROES TO RS-CONTACT-ID.                                
           MOVE SPACES TO RS-CONTACT-POSITION.                          
           MOVE ZEROES TO RS-CONTACT-ORDER.                             
           MOVE ZEROES TO RS-NAME-ID.                                   
           MOVE ZEROES TO RS-ADDRESS-ID.                                
           MOVE SPACES TO RS-CONTACT-TYPE.                              
           MOVE SPACES TO RS-ADDR-STREET.                               
           MOVE SPACES TO RS-ADDR-CITY-STATE.                           
           MOVE SPACES TO RS-ADDR-ZIP-CODE.                             
           MOVE SPACES TO RS-ADDR-COUNTRY.                              
           MOVE SPACES TO RS-ADDRESS-OVERFLOW.                          
           MOVE SPACES TO RS-FIRST-NAME.                                
           MOVE SPACES TO RS-MIDDLE-NAME.                               
           MOVE SPACES TO RS-LAST-NAME.                                 
           MOVE SPACES TO RS-NAME-TYPE.                                 
           MOVE SPACES TO RS-FULL-NAME.                                 
           MOVE SPACES TO RS-NICKNAME.                                  
                                                                        
       0110-EXIT.                                                       
            EXIT.                                                       
                                                                        
       0120-INIT-LP-RS.                                                 
                                                                        
           MOVE SPACES TO RS-PHONE-TYPE.                                
           MOVE SPACES TO RS-PHONE-NO.                                  
           MOVE SPACES TO RS-EXTENSION-NO.                              
                                                                        
       0120-EXIT.                                                       
            EXIT.                                                       
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO     TO DW-ACCOUNT-NO.                   
           MOVE PARM-CUSTOMER-NO    TO DT-CUSTOMER-NO.                  
           MOVE PARM-PREMISE-NO     TO DX-PREMISE-NO.                   
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'        TO ACTIVE-PARAGRAPH.                      
           PERFORM 2200-BUILD-RESULT    THRU 2200-EXIT.                 
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000A-MOVE-RESULT.                                               
                                                                        
            MOVE RS-RETURN-CODE        TO  S-RETURN-CODE.               
            MOVE RS-NAME-ID            TO  S-NAME-ID.                   
            MOVE RS-ADDR-COUNTRY       TO  S-ADDR-COUNTRY.              
            MOVE RS-CONTACT-ID         TO  S-CONTACT-ID.                
            MOVE RS-NAME-TYPE          TO  S-NAME-TYPE.                 
            MOVE RS-ADDRESS-ID         TO  S-ADDRESS-ID.                
            MOVE RS-CONTACT-ENTITY     TO  S-CONTACT-ENTITY.            
            MOVE RS-CONTACT-TYPE       TO  S-CONTACT-TYPE.              
            MOVE RS-FIRST-NAME         TO  S-FIRST-NAME.                
            MOVE RS-MIDDLE-NAME        TO  S-MIDDLE-NAME.               
            MOVE RS-LAST-NAME          TO  S-LAST-NAME.                 
            MOVE RS-CONTACT-POSITION   TO  S-CONTACT-POSITION.          
            MOVE RS-CONTACT-ORDER      TO  S-CONTACT-ORDER.             
            MOVE RS-ADDR-STREET        TO  S-ADDR-STREET.               
            MOVE RS-ADDR-CITY-STATE    TO  S-ADDR-CITY-STATE.           
            MOVE RS-ADDR-ZIP-CODE      TO  S-ADDR-ZIP-CODE.             
            MOVE RS-ADDRESS-OVERFLOW   TO  S-ADDRESS-OVERFLOW.          
            MOVE RS-PHONE-TYPE         TO  S-PHONE-TYPE.                
            MOVE RS-PHONE-NO           TO  S-PHONE-NO.                  
            MOVE RS-EXTENSION-NO       TO  S-EXTENSION-NO.              
            MOVE RS-REPEAT-COUNT       TO  S-REPEAT-COUNT.              
            MOVE RS-FULL-NAME          TO  S-FULL-NAME.                 
            MOVE RS-NICKNAME           TO  S-NICKNAME.                  
                                                                        
       2000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
       2200-BUILD-RESULT.                                               
                                                                        
           MOVE '2200'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           MOVE PARM-ACCOUNT-NO     TO DW-ACCOUNT-NO.                   
                                                                        
           PERFORM 7100-OPEN-DW-CURSOR  THRU  7100-EXIT.                
           PERFORM 7110-FETCH-DW-CURSOR THRU  7110-EXIT.                
                                                                        
           PERFORM 2205-PROCESS-DW-CURSOR   THRU 2205-EXIT              
                 UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                
                                                                        
           PERFORM 7120-CLOSE-DW-CURSOR THRU 7120-EXIT.                 
                                                                        
           MOVE ZEROES TO WS-NULL-1                                     
                          WS-NULL-2                                     
                          WS-NULL-3                                     
                          WS-NULL-4                                     
                          WS-NULL-5.                                    
                                                                        
           MOVE PARM-CUSTOMER-NO    TO DT-CUSTOMER-NO.                  
                                                                        
           PERFORM 7200-OPEN-DT-CURSOR  THRU  7200-EXIT.                
           PERFORM 7210-FETCH-DT-CURSOR THRU  7210-EXIT.                
                                                                        
           PERFORM 2305-PROCESS-DT-CURSOR   THRU 2305-EXIT              
                 UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                
                                                                        
           PERFORM 7220-CLOSE-DT-CURSOR THRU 7220-EXIT.                 
                                                                        
           MOVE ZEROES TO WS-NULL-1                                     
                          WS-NULL-2                                     
                          WS-NULL-3                                     
                          WS-NULL-4                                     
                          WS-NULL-5.                                    
                                                                        
           MOVE PARM-PREMISE-NO     TO DX-PREMISE-NO.                   
                                                                        
           PERFORM 7300-OPEN-DX-CURSOR  THRU  7300-EXIT.                
           PERFORM 7310-FETCH-DX-CURSOR THRU  7310-EXIT.                
                                                                        
           PERFORM 2405-PROCESS-DX-CURSOR   THRU 2405-EXIT              
                 UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                
                                                                        
T14065*    IF NO ROWS WERE FOUND, THIS IS A NORMAL BUSINESS SITUATION.          
T14065*    SEND BACK A ROW WITH RETURN CODE OF 100 SO NO MC05 RECORD            
T14065*    IS WRITTEN TO CPD00302.                                              
T14065     IF CTR-ROWS = 0                                              
T14065        MOVE 100 TO RS-RETURN-CODE                                
T14065        PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
T14065        PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
T14065     END-IF.                                                      
           PERFORM 7320-CLOSE-DX-CURSOR THRU 7320-EXIT.                 
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2205-PROCESS-DW-CURSOR.                                          
                                                                        
           MOVE '2205'              TO ACTIVE-PARAGRAPH.                
                                                                        
           MOVE 'A'                   TO WS-CONTACT-ENTITY-IND.         
                                                                        
           PERFORM 0110-INIT-CV-RS THRU 0110-EXIT.                      
                                                                        
           MOVE DW-CONTACT-ID       TO LP-CONTACT-ID                    
                                       RS-CONTACT-ID                    
                                                                        
           PERFORM  2410-MOVE-CV-DATA THRU  2410-EXIT                   
                                                                        
           PERFORM  7400-OPEN-LP-CURSOR THRU  7400-EXIT                 
           PERFORM  7410-FETCH-LP-CURSOR THRU 7410-EXIT                 
                                                                        
           PERFORM 2505-PROCESS-LP-CURSOR THRU 2505-EXIT                
                 UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                
                                                                        
           PERFORM  7420-CLOSE-LP-CURSOR THRU 7420-EXIT                 
                                                                        
           IF RS-REPEAT-COUNT = 0                                       
             MOVE SPACES            TO RS-PHONE-TYPE                    
             MOVE SPACES            TO RS-PHONE-NO                      
             MOVE SPACES            TO RS-EXTENSION-NO                  
             MOVE 1                 TO RS-REPEAT-COUNT                  
             PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                  
             PERFORM 8100-SEND-RESULT THRU 8100-EXIT                    
           END-IF                                                       
                                                                        
           MOVE ZEROES TO RS-REPEAT-COUNT                               
                                                                        
           MOVE SPACES TO CV-CONTACT-POSITION-TEXT                      
                                                                        
           PERFORM  7110-FETCH-DW-CURSOR THRU 7110-EXIT.                
                                                                        
       2205-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2305-PROCESS-DT-CURSOR.                                          
                                                                        
           MOVE '2305'              TO ACTIVE-PARAGRAPH.                
                                                                        
           MOVE 'C'                   TO WS-CONTACT-ENTITY-IND.         
                                                                        
           PERFORM 0110-INIT-CV-RS THRU 0110-EXIT.                      
                                                                        
           MOVE DT-CONTACT-ID       TO LP-CONTACT-ID                    
                                       RS-CONTACT-ID                    
                                                                        
           PERFORM  2410-MOVE-CV-DATA THRU  2410-EXIT                   
                                                                        
           PERFORM  7400-OPEN-LP-CURSOR THRU  7400-EXIT                 
           PERFORM  7410-FETCH-LP-CURSOR THRU 7410-EXIT                 
                                                                        
           PERFORM 2505-PROCESS-LP-CURSOR THRU 2505-EXIT                
                 UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                
                                                                        
           PERFORM  7420-CLOSE-LP-CURSOR THRU 7420-EXIT                 
                                                                        
           IF RS-REPEAT-COUNT = 0                                       
             MOVE SPACES            TO RS-PHONE-TYPE                    
             MOVE SPACES            TO RS-PHONE-NO                      
             MOVE SPACES            TO RS-EXTENSION-NO                  
             MOVE 1                 TO RS-REPEAT-COUNT                  
             PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                  
             PERFORM 8100-SEND-RESULT THRU 8100-EXIT                    
           END-IF                                                       
                                                                        
           MOVE ZEROES TO RS-REPEAT-COUNT.                              
                                                                        
           PERFORM  7210-FETCH-DT-CURSOR THRU 7210-EXIT.                
                                                                        
       2305-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2405-PROCESS-DX-CURSOR.                                          
                                                                        
           MOVE '2405'              TO ACTIVE-PARAGRAPH.                
                                                                        
           MOVE 'P'                   TO WS-CONTACT-ENTITY-IND.         
                                                                        
           PERFORM 0110-INIT-CV-RS THRU 0110-EXIT.                      
                                                                        
           MOVE DX-CONTACT-ID       TO LP-CONTACT-ID                    
                                       RS-CONTACT-ID                    
                                                                        
           PERFORM  2410-MOVE-CV-DATA THRU  2410-EXIT                   
                                                                        
           PERFORM  7400-OPEN-LP-CURSOR THRU  7400-EXIT                 
           PERFORM  7410-FETCH-LP-CURSOR THRU 7410-EXIT                 
                                                                        
           PERFORM 2505-PROCESS-LP-CURSOR THRU 2505-EXIT                
                 UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                
                                                                        
           PERFORM  7420-CLOSE-LP-CURSOR THRU 7420-EXIT                 
                                                                        
           IF RS-REPEAT-COUNT = 0                                       
             MOVE SPACES            TO RS-PHONE-TYPE                    
             MOVE SPACES            TO RS-PHONE-NO                      
             MOVE SPACES            TO RS-EXTENSION-NO                  
             MOVE 1                 TO RS-REPEAT-COUNT                  
             PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                  
             PERFORM 8100-SEND-RESULT THRU 8100-EXIT                    
           END-IF                                                       
                                                                        
           MOVE ZEROES TO RS-REPEAT-COUNT.                              
                                                                        
           PERFORM  7310-FETCH-DX-CURSOR THRU 7310-EXIT.                
                                                                        
       2405-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2410-MOVE-CV-DATA.                                               
                                                                        
           MOVE '2410' TO ACTIVE-PARAGRAPH.                             
           INITIALIZE WS-EMB-INPUT                                      
                      WS-EMB-TBL-LENG                                   
                      WS-EMB-LENG                                       
                      WS-EMB-LAST-CHAR                                  
                      WS-CMP-TABLE.                                     
           MOVE SPACES TO RS-CONTACT-POSITION.                          
           MOVE SPACES TO RS-FULL-NAME.                                 
                                                                        
           MOVE CV-CONTACT-ORDER    TO RS-CONTACT-ORDER                 
           MOVE CV-CONTACT-POSITION-TEXT TO RS-CONTACT-POSITION         
           MOVE SPACES              TO CV-CONTACT-POSITION-TEXT         
           MOVE CV-CONTACT-TYPE     TO RS-CONTACT-TYPE                  
           MOVE CV-NAME-ID          TO RS-NAME-ID                       
           MOVE CV-ADDRESS-ID       TO RS-ADDRESS-ID                    
           MOVE WS-CONTACT-ENTITY-IND TO RS-CONTACT-ENTITY              
P00740     EVALUATE CV-ADDRESS-FORMAT                                   
P00740         WHEN 'A'                                                 
P00740             MOVE CV-ADDRESS-ID TO DY-ADDRESS-ID                  
P00740             PERFORM 7000-FORMATTED-ADDRESS THRU 7000-EXIT        
P00740             MOVE WS-ADDR-STREET  TO RS-ADDR-STREET               
P00740             MOVE WS-ADDR-CITY-STATE TO RS-ADDR-CITY-STATE        
P00740             MOVE WS-ADDR-ZIP-CODE TO RS-ADDR-ZIP-CODE            
P00740             MOVE SPACES TO RS-ADDR-COUNTRY                       
P00740             MOVE WS-ADDRESS-OVERFLOW TO RS-ADDRESS-OVERFLOW      
P00740         WHEN 'B'                                                 
P00740             MOVE DZ-ADDR-STREET  TO RS-ADDR-STREET               
P00740             MOVE DZ-ADDR-CITY-STATE TO RS-ADDR-CITY-STATE        
P00740             MOVE DZ-ADDR-ZIP-CODE TO RS-ADDR-ZIP-CODE            
P00740             MOVE DZ-ADDR-COUNTRY TO RS-ADDR-COUNTRY              
P00740             MOVE DZ-ADDRESS-OVERFLOW TO RS-ADDRESS-OVERFLOW      
P00740         WHEN OTHER                                               
P00740             MOVE SPACES TO RS-ADDR-STREET                        
P00740                            RS-ADDR-CITY-STATE                    
P00740                            RS-ADDR-ZIP-CODE                      
P00740                            RS-ADDR-COUNTRY                       
P00740                            RS-ADDRESS-OVERFLOW                   
P00740     END-EVALUATE                                                 
           MOVE DQ-FIRST-NAME       TO RS-FIRST-NAME                    
           MOVE DQ-MIDDLE-NAME      TO RS-MIDDLE-NAME                   
           MOVE DQ-LAST-NAME        TO RS-LAST-NAME                     
           MOVE DQ-NAME-TYPE        TO RS-NAME-TYPE                     
T13230     MOVE DQ-NICKNAME         TO RS-NICKNAME                      
PCR        STRING DQ-FULL-NAME                                          
T36932*           DELIMITED BY ' '                                              
PCR               ' ' DELIMITED BY SIZE                                 
PCR            INTO RS-FULL-NAME.                                       
PCR        IF RS-FULL-NAME = ' '                                        
T13230        IF RS-NICKNAME = ' '                                      
T13230           IF RS-FIRST-NAME = ' ' AND RS-MIDDLE-NAME = ' '        
T13230              MOVE DQ-LAST-NAME TO RS-FULL-NAME                   
T13230           ELSE                                                   
PCR              STRING                                                 
PCR                  DQ-LAST-NAME                                       
T36932*              DELIMITED BY ' '                                           
PCR                  ',' DELIMITED BY SIZE                              
PCR                  ' ' DELIMITED BY SIZE                              
PCR                  DQ-FIRST-NAME DELIMITED BY ' '                     
PCR                  ' ' DELIMITED BY SIZE                              
PCR                  DQ-MIDDLE-NAME DELIMITED BY ' '                    
PCR                  INTO RS-FULL-NAME                                  
T13230           END-IF                                                 
T13230        ELSE                                                      
T13230           STRING                                                 
T13230               DQ-LAST-NAME                                       
T36932*              DELIMITED BY ' '                                           
T13230               ',' DELIMITED BY SIZE                              
T13230               ' ' DELIMITED BY SIZE                              
T13230               DQ-FIRST-NAME DELIMITED BY ' '                     
T13230               ' ' DELIMITED BY SIZE                              
T13230               DQ-MIDDLE-NAME DELIMITED BY ' '                    
T13230               ' ' DELIMITED BY SIZE                              
C34788*              '(' DELIMITED BY SIZE                                      
C34788*              DQ-NICKNAME DELIMITED BY ' '                               
C34788*              ')' DELIMITED BY SIZE                                      
T13230               INTO RS-FULL-NAME                                  
T13230        END-IF                                                    
PCR        ELSE                                                         
PCR           MOVE DQ-FULL-NAME TO RS-FULL-NAME                         
PCR        END-IF.                                                      
T36932     MOVE LENGTH OF RS-FULL-NAME TO WS-EMB-LENG.                  
T36932     MOVE RS-FULL-NAME TO WS-EMB-INPUT.                           
T36932     PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT.          
T36932     MOVE WS-CMP-TABLE TO RS-FULL-NAME.                           
       2410-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2505-PROCESS-LP-CURSOR.                                          
                                                                        
           MOVE '2505' TO ACTIVE-PARAGRAPH.                             
                                                                        
           MOVE LP-PHONE-TYPE      TO RS-PHONE-TYPE                     
           MOVE LP-PHONE-NO        TO RS-PHONE-NO                       
           MOVE LP-EXTENSION-NO    TO RS-EXTENSION-NO                   
           ADD 1 TO RS-REPEAT-COUNT.                                    
                                                                        
           PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT.                   
           PERFORM 8100-SEND-RESULT  THRU 8100-EXIT.                    
                                                                        
           PERFORM 7410-FETCH-LP-CURSOR THRU 7410-EXIT.                 
                                                                        
       2505-EXIT.                                                       
           EXIT.                                                        
                                                                        
T36932     EXEC SQL                                                             
T36932        INCLUDE CPD00004                                                  
T36932     END-EXEC.                                                            
                                                                        
       7000-FORMATTED-ADDRESS.                                          
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) RTRIM(LTRIM(RTRIM(HOUSE_NO) + ' ' + LTRIM(
           RTRIM(ADDR_PREFIX_1) + ' ' + LTRIM(RTRIM(ADDR_PREFIX_2) + 
           ' ' + LTRIM(RTRIM(STREET_NAME) + ' ' + LTRIM(RTRIM(
           STREET_SUFFIX) + ' ' + LTRIM(RTRIM(ADDR_SUFFIX)))))))),
              RTRIM(LTRIM(RTRIM(STREET_LOCATION_1) + ' ' + LTRIM(RTRIM(
           STREET_LOCATION_2)))),
              RTRIM(LTRIM(RTRIM(TOWN) + ' ' + LTRIM(RTRIM(STATE)))),
              DY.ZIP_CODE + '-' + ZIP_CODE_PLUS_FOUR          
                 INTO :WS-ADDR-STREET,                                  
                      :WS-ADDRESS-OVERFLOW,                             
                      :WS-ADDR-CITY-STATE,                              
                      :WS-ADDR-ZIP-CODE                                 
                 FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
                      CSS_ZIP_CODE A4 WITH(READUNCOMMITTED)                     
                WHERE ADDRESS_ID = :DY-ADDRESS-ID                       
                  AND DY.ZIP_CODE = A4.ZIP_CODE                         
                  AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN             
                                                 
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RTRIM(LTRIM(RTRIM(HOUSE_NO) || ' ' ||                     
MFA-TR*               LTRIM(RTRIM(ADDR_PREFIX_1) || ' ' ||                      
MFA-TR*               LTRIM(RTRIM(ADDR_PREFIX_2) || ' ' ||                      
MFA-TR*               LTRIM(RTRIM(STREET_NAME) || ' ' ||                        
MFA-TR*               LTRIM(RTRIM(STREET_SUFFIX) || ' ' ||                      
MFA-TR*               LTRIM(RTRIM(ADDR_SUFFIX)))))))),                          
MFA-TR*               RTRIM(LTRIM(RTRIM(STREET_LOCATION_1) || ' ' ||            
MFA-TR*               LTRIM(RTRIM(STREET_LOCATION_2)))),                        
MFA-TR*               RTRIM(LTRIM(RTRIM(TOWN) || ' ' ||                         
MFA-TR*                     LTRIM(RTRIM(STATE)))),                              
MFA-TR*               DY.ZIP_CODE || '-' || ZIP_CODE_PLUS_FOUR                  
MFA-TR*          INTO :WS-ADDR-STREET,                                          
MFA-TR*               :WS-ADDRESS-OVERFLOW,                                     
MFA-TR*               :WS-ADDR-CITY-STATE,                                      
MFA-TR*               :WS-ADDR-ZIP-CODE                                         
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_ZIP_CODE A4                                           
MFA-TR*         WHERE ADDRESS_ID = :DY-ADDRESS-ID                               
MFA-TR*           AND DY.ZIP_CODE = A4.ZIP_CODE                                 
MFA-TR*           AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN                     
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   CONTINUE                                             
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO WS-ADDR-STREET                        
                                  WS-ADDRESS-OVERFLOW                   
                                  WS-ADDR-CITY-STATE                    
                                  WS-ADDR-ZIP-CODE                      
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
                   MOVE 'OPEN'          TO ABEND-FUNCTION               
                   MOVE SPACES          TO ABEND-SQL-PREDICATES         
                                                ABEND-TABLES            
                   MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                 
                   MOVE 'ADDRESS_ID '   TO TABLE-ELEMENT-1              
                   MOVE DY-ADDRESS-ID   TO HOSTVAR-ELEMENT-1            
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-OPEN-DW-CURSOR.                                             
                                                                        
           MOVE '7100'    TO ACTIVE-PARAGRAPH.                          
                                                                        
           EXEC SQL                                                     
                OPEN DW-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_CONTACT_ACCT'   TO TABLE-1                      
              MOVE 'CSS_CONTACT'        TO TABLE-2                      
              MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-3                      
              MOVE 'CSS_NAME'           TO TABLE-4                      
              MOVE 'ACCOUNT_NO '        TO TABLE-ELEMENT-1              
              MOVE DW-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7110-FETCH-DW-CURSOR.                                            
                                                                        
           MOVE '7110'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           MOVE SPACES TO CV-CONTACT-POSITION-TEXT.                     
                                                                        
           EXEC SQL                                                     
             FETCH DW-CURSOR                                            
             INTO :DW-CONTACT-ID,                                       
                  :CV-ADDRESS-ID,                                       
                  :CV-CONTACT-ORDER,                                    
                  :CV-CONTACT-POSITION,                                 
                  :CV-CONTACT-TYPE,                                     
                  :CV-NAME-ID,                                          
P00740            :CV-ADDRESS-FORMAT,                                   
P00740            :DZ-ADDR-STREET :WS-NULL-1,                            
P00740            :DZ-ADDR-CITY-STATE :WS-NULL-2,                        
P00740            :DZ-ADDR-ZIP-CODE :WS-NULL-3,                          
P00740            :DZ-ADDR-COUNTRY :WS-NULL-4,                           
P00740            :DZ-ADDRESS-OVERFLOW :WS-NULL-5,                       
                  :DQ-FIRST-NAME,                                       
                  :DQ-MIDDLE-NAME,                                      
                  :DQ-LAST-NAME,                                        
                  :DQ-NAME-TYPE,                                        
                  :DQ-FULL-NAME,                                        
T13230            :DQ-NICKNAME                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE     TO WS-ACTIVE-RETURN-CODE.                   
                                                                        
P00740     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00740         WHEN SUCCESSFUL-CALL                                     
P00740             IF WS-NULL-1 < 0                                     
P00740                 MOVE SPACES TO DZ-ADDR-STREET                    
P00740             END-IF                                               
P00740             IF WS-NULL-2 < 0                                     
P00740                 MOVE SPACES TO DZ-ADDR-CITY-STATE                
P00740             END-IF                                               
P00740             IF WS-NULL-3 < 0                                     
P00740                 MOVE SPACES TO DZ-ADDR-ZIP-CODE                  
P00740             END-IF                                               
P00740             IF WS-NULL-4 < 0                                     
P00740                 MOVE SPACES TO DZ-ADDR-COUNTRY                   
P00740             END-IF                                               
P00740             IF WS-NULL-5 < 0                                     
P00740                 MOVE SPACES TO DZ-ADDRESS-OVERFLOW               
P00740             END-IF                                               
P00740         WHEN NOT-FOUND                                           
P00740             CONTINUE                                             
P00740         WHEN OTHER                                               
                   MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
                   MOVE 'FETCH'         TO ABEND-FUNCTION               
                   MOVE SPACES          TO ABEND-SQL-PREDICATES         
                                                ABEND-TABLES            
                   MOVE 'CSS_CONTACT_ACCT' TO TABLE-1                   
                   MOVE 'CSS_CONTACT'   TO TABLE-2                      
                   MOVE 'CSS_ADDR_FREEFORM' TO TABLE-3                  
                   MOVE 'CSS_NAME'      TO TABLE-4                      
                   MOVE 'ACCOUNT_NO  '  TO TABLE-ELEMENT-1              
                   MOVE DW-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1            
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7120-CLOSE-DW-CURSOR.                                            
                                                                        
           MOVE '7120'   TO ACTIVE-PARAGRAPH.                           
                                                                        
           EXEC SQL                                                     
                 CLOSE DW-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                    NEXT SENTENCE                                       
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_CONTACT_ACCT'   TO TABLE-1                      
              MOVE 'CSS_CONTACT'        TO TABLE-2                      
              MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-3                      
              MOVE 'CSS_NAME'           TO TABLE-4                      
              MOVE 'ACCOUNT_NO  '       TO TABLE-ELEMENT-1              
              MOVE DW-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-OPEN-DT-CURSOR.                                             
                                                                        
           MOVE '7200'    TO ACTIVE-PARAGRAPH.                          
                                                                        
           EXEC SQL                                                     
                OPEN DT-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_CONTACT_CUST'   TO TABLE-1                      
              MOVE 'CSS_CONTACT'        TO TABLE-2                      
              MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-3                      
              MOVE 'CSS_NAME'           TO TABLE-4                      
              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1              
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE DT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7210-FETCH-DT-CURSOR.                                            
                                                                        
           MOVE '7210'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL                                                     
             FETCH DT-CURSOR                                            
             INTO :DT-CONTACT-ID,                                       
                  :CV-ADDRESS-ID,                                       
                  :CV-CONTACT-ORDER,                                    
                  :CV-CONTACT-POSITION,                                 
                  :CV-CONTACT-TYPE,                                     
                  :CV-NAME-ID,                                          
P00740            :CV-ADDRESS-FORMAT,                                   
P00740            :DZ-ADDR-STREET :WS-NULL-1,                            
P00740            :DZ-ADDR-CITY-STATE :WS-NULL-2,                        
P00740            :DZ-ADDR-ZIP-CODE :WS-NULL-3,                          
P00740            :DZ-ADDR-COUNTRY :WS-NULL-4,                           
P00740            :DZ-ADDRESS-OVERFLOW :WS-NULL-5,                       
                  :DQ-FIRST-NAME,                                       
                  :DQ-MIDDLE-NAME,                                      
                  :DQ-LAST-NAME,                                        
                  :DQ-NAME-TYPE,                                        
                  :DQ-FULL-NAME,                                        
                  :DQ-NICKNAME                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE     TO WS-ACTIVE-RETURN-CODE.                   
                                                                        
P00740     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00740         WHEN SUCCESSFUL-CALL                                     
P00740             IF WS-NULL-1 < 0                                     
P00740                 MOVE SPACES TO DZ-ADDR-STREET                    
P00740             END-IF                                               
P00740             IF WS-NULL-2 < 0                                     
P00740                 MOVE SPACES TO DZ-ADDR-CITY-STATE                
P00740             END-IF                                               
P00740             IF WS-NULL-3 < 0                                     
P00740                 MOVE SPACES TO DZ-ADDR-ZIP-CODE                  
P00740             END-IF                                               
P00740             IF WS-NULL-4 < 0                                     
P00740                 MOVE SPACES TO DZ-ADDR-COUNTRY                   
P00740             END-IF                                               
P00740             IF WS-NULL-5 < 0                                     
P00740                 MOVE SPACES TO DZ-ADDRESS-OVERFLOW               
P00740             END-IF                                               
P00740         WHEN NOT-FOUND                                           
P00740             CONTINUE                                             
P00740         WHEN OTHER                                               
                   MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
                   MOVE 'FETCH'         TO ABEND-FUNCTION               
                   MOVE SPACES          TO ABEND-SQL-PREDICATES         
                                                ABEND-TABLES            
                   MOVE 'CSS_CONTACT_CUST' TO TABLE-1                   
                   MOVE 'CSS_CONTACT'   TO TABLE-2                      
                   MOVE 'CSS_ADDR_FREEFORM' TO TABLE-3                  
                   MOVE 'CSS_NAME'      TO TABLE-4                      
                   MOVE 'CUSTOMER_NO '  TO TABLE-ELEMENT-1              
                   MOVE 'ACCOUNT_NO'    TO TABLE-ELEMENT-2              
                   MOVE DT-CUSTOMER-NO  TO HOSTVAR-ELEMENT-1            
                   MOVE PARM-ACCOUNT-NO TO HOSTVAR-ELEMENT-2            
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7220-CLOSE-DT-CURSOR.                                            
                                                                        
           MOVE '7220'   TO ACTIVE-PARAGRAPH.                           
                                                                        
           EXEC SQL                                                     
                 CLOSE DT-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                    NEXT SENTENCE                                       
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_CONTACT_CUST'   TO TABLE-1                      
              MOVE 'CSS_CONTACT'        TO TABLE-2                      
              MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-3                      
              MOVE 'CSS_NAME'           TO TABLE-4                      
              MOVE 'CUSTOMER_NO  '      TO TABLE-ELEMENT-1              
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE DT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1            
              MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-OPEN-DX-CURSOR.                                             
                                                                        
           MOVE '7300'    TO ACTIVE-PARAGRAPH.                          
                                                                        
           EXEC SQL                                                     
                OPEN DX-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE           TO WS-ACTIVE-RETURN-CODE.             
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_CONTACT_PREM'   TO TABLE-1                      
              MOVE 'CSS_CONTACT'        TO TABLE-2                      
              MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-3                      
              MOVE 'CSS_NAME'           TO TABLE-4                      
              MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1              
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE DX-PREMISE-NO        TO HOSTVAR-ELEMENT-1            
              MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7310-FETCH-DX-CURSOR.                                            
                                                                        
           MOVE '7310'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL                                                     
             FETCH DX-CURSOR                                            
             INTO :DX-CONTACT-ID,                                       
                  :CV-ADDRESS-ID,                                       
                  :CV-CONTACT-ORDER,                                    
                  :CV-CONTACT-POSITION,                                 
                  :CV-CONTACT-TYPE,                                     
                  :CV-NAME-ID,                                          
P00740            :CV-ADDRESS-FORMAT,                                   
P00740            :DZ-ADDR-STREET :WS-NULL-1,                            
P00740            :DZ-ADDR-CITY-STATE :WS-NULL-2,                        
P00740            :DZ-ADDR-ZIP-CODE :WS-NULL-3,                          
P00740            :DZ-ADDR-COUNTRY :WS-NULL-4,                           
P00740            :DZ-ADDRESS-OVERFLOW :WS-NULL-5,                       
                  :DQ-FIRST-NAME,                                       
                  :DQ-MIDDLE-NAME,                                      
                  :DQ-LAST-NAME,                                        
                  :DQ-NAME-TYPE,                                        
                  :DQ-FULL-NAME,                                        
                  :DQ-NICKNAME                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE     TO WS-ACTIVE-RETURN-CODE.                   
                                                                        
P00740     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00740         WHEN SUCCESSFUL-CALL                                     
P00740             IF WS-NULL-1 < 0                                     
P00740                 MOVE SPACES TO DZ-ADDR-STREET                    
P00740             END-IF                                               
P00740             IF WS-NULL-2 < 0                                     
P00740                 MOVE SPACES TO DZ-ADDR-CITY-STATE                
P00740             END-IF                                               
P00740             IF WS-NULL-3 < 0                                     
P00740                 MOVE SPACES TO DZ-ADDR-ZIP-CODE                  
P00740             END-IF                                               
P00740             IF WS-NULL-4 < 0                                     
P00740                 MOVE SPACES TO DZ-ADDR-COUNTRY                   
P00740             END-IF                                               
P00740             IF WS-NULL-5 < 0                                     
P00740                 MOVE SPACES TO DZ-ADDRESS-OVERFLOW               
P00740             END-IF                                               
P00740         WHEN NOT-FOUND                                           
P00740             CONTINUE                                             
P00740         WHEN OTHER                                               
                   MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
                   MOVE 'FETCH'         TO ABEND-FUNCTION               
                   MOVE SPACES          TO ABEND-SQL-PREDICATES         
                                                ABEND-TABLES            
                   MOVE 'CSS_CONTACT_PREM' TO TABLE-1                   
                   MOVE 'CSS_CONTACT'   TO TABLE-2                      
                   MOVE 'CSS_ADDR_FREEFORM' TO TABLE-3                  
                   MOVE 'CSS_NAME'      TO TABLE-4                      
                   MOVE 'PREMISE_NO'    TO TABLE-ELEMENT-1              
                   MOVE 'ACCOUNT_NO'    TO TABLE-ELEMENT-2              
                   MOVE DX-PREMISE-NO   TO HOSTVAR-ELEMENT-1            
                   MOVE PARM-ACCOUNT-NO TO HOSTVAR-ELEMENT-2            
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7320-CLOSE-DX-CURSOR.                                            
                                                                        
           MOVE '7320'   TO ACTIVE-PARAGRAPH.                           
                                                                        
           EXEC SQL                                                     
                 CLOSE DX-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                    NEXT SENTENCE                                       
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_CONTACT_PREM'   TO TABLE-1                      
              MOVE 'CSS_CONTACT'        TO TABLE-2                      
              MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-3                      
              MOVE 'CSS_NAME'           TO TABLE-4                      
              MOVE 'PREMISE_NO  '       TO TABLE-ELEMENT-1              
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE DX-PREMISE-NO        TO HOSTVAR-ELEMENT-1            
              MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7400-OPEN-LP-CURSOR.                                             
                                                                        
           MOVE '7400'    TO ACTIVE-PARAGRAPH.                          
                                                                        
           EXEC SQL                                                     
                OPEN LP-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE            TO WS-ACTIVE-RETURN-CODE.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
             NEXT SENTENCE                                              
           ELSE                                                         
             MOVE PROGRAM-NAME               TO ABEND-PROGRAM           
             MOVE 'OPEN'                     TO ABEND-FUNCTION          
             MOVE SPACES                     TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
             MOVE 'CSS_CONTACT_PHONE'        TO TABLE-1                 
             MOVE 'CONTACT_ID  '             TO TABLE-ELEMENT-1         
             MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2         
             MOVE LP-CONTACT-ID              TO HOSTVAR-ELEMENT-1       
             MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-2       
             PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT             
             PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.            
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7410-FETCH-LP-CURSOR.                                            
                                                                        
           MOVE '7410'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL                                                     
             FETCH LP-CURSOR                                            
             INTO :LP-PHONE-TYPE,                                       
                  :LP-PHONE-NO,                                         
                  :LP-EXTENSION-NO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE     TO WS-ACTIVE-RETURN-CODE.                   
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                                         OR NOT-FOUND                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_CONTACT_PHONE'  TO TABLE-1                      
              MOVE 'CONTACT_ID  '       TO TABLE-ELEMENT-1              
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE LP-CONTACT-ID        TO HOSTVAR-ELEMENT-1            
              MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7420-CLOSE-LP-CURSOR.                                            
                                                                        
           MOVE '7420'   TO ACTIVE-PARAGRAPH.                           
                                                                        
           EXEC SQL                                                     
                 CLOSE LP-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                    NEXT SENTENCE                                       
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_CONTACT_PHONE'  TO TABLE-1                      
              MOVE 'CONTACT_ID  '       TO TABLE-ELEMENT-1              
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE LP-CONTACT-ID        TO HOSTVAR-ELEMENT-1            
              MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       7420-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8100-SEND-RESULT.                                                
                                                                        
            EXEC SQL                                                    
                 INSERT INTO #CSR02197_R1                        
                 (                                                      
                        RETURN_CODE                                     
                       ,CONTACT_ENTITY_IND                              
                       ,NAME_ID                                         
                       ,CONTACT_TYPE                                    
                       ,CONTACT_ORDER                                   
                       ,CONTACT_POSITION                                
                       ,ADDR_STREET                                     
                       ,ADDR_CITY_STATE                                 
                       ,ADDR_ZIP_CODE                                   
                       ,ADDR_COUNTRY                                    
                       ,ADDRESS_OVERFLOW                                
                       ,PHONE_TYPE                                      
                       ,PHONE_NO                                        
                       ,EXTENSION_NO                                    
                       ,REPEAT_COUNT                                    
                       ,CONTACT_ID                                      
                       ,FIRST_NAME                                      
                       ,MIDDLE_NAME                                     
                       ,LAST_NAME                                       
                       ,NAME_TYPE                                       
                       ,ADDRESS_ID                                      
                       ,FULL_NAME                                       
                       ,NICKNAME                                        
C34788                 ,SSN                                             
C34788                 ,FORMATTED                                       
                 )                                                      
                 VALUES                                                 
                 (                                                      
                         :S-RETURN-CODE                                 
                        ,:S-CONTACT-ENTITY                              
                        ,:S-NAME-ID                                     
                        ,:S-CONTACT-TYPE                                
                        ,:S-CONTACT-ORDER                               
                        ,:S-CONTACT-POSITION                            
                        ,:S-ADDR-STREET                                 
                        ,:S-ADDR-CITY-STATE                             
                        ,:S-ADDR-ZIP-CODE                               
                        ,:S-ADDR-COUNTRY                                
                        ,:S-ADDRESS-OVERFLOW                            
                        ,:S-PHONE-TYPE                                  
                        ,:S-PHONE-NO                                    
                        ,:S-EXTENSION-NO                                
                        ,:S-REPEAT-COUNT                                
                        ,:S-CONTACT-ID                                  
                        ,:S-FIRST-NAME                                  
                        ,:S-MIDDLE-NAME                                 
                        ,:S-LAST-NAME                                   
                        ,:S-NAME-TYPE                                   
                        ,:S-ADDRESS-ID                                  
                        ,:S-FULL-NAME                                   
                        ,:S-NICKNAME                                    
C34788                  ,'N'                                            
C34788                  ,'N'                                            
                  )                                                     
              END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          INSERT INTO SESSION.CSR02197_R1                                
MFA-TR*          (                                                              
MFA-TR*                 RETURN_CODE                                             
MFA-TR*                ,CONTACT_ENTITY_IND                                      
MFA-TR*                ,NAME_ID                                                 
MFA-TR*                ,CONTACT_TYPE                                            
MFA-TR*                ,CONTACT_ORDER                                           
MFA-TR*                ,CONTACT_POSITION                                        
MFA-TR*                ,ADDR_STREET                                             
MFA-TR*                ,ADDR_CITY_STATE                                         
MFA-TR*                ,ADDR_ZIP_CODE                                           
MFA-TR*                ,ADDR_COUNTRY                                            
MFA-TR*                ,ADDRESS_OVERFLOW                                        
MFA-TR*                ,PHONE_TYPE                                              
MFA-TR*                ,PHONE_NO                                                
MFA-TR*                ,EXTENSION_NO                                            
MFA-TR*                ,REPEAT_COUNT                                            
MFA-TR*                ,CONTACT_ID                                              
MFA-TR*                ,FIRST_NAME                                              
MFA-TR*                ,MIDDLE_NAME                                             
MFA-TR*                ,LAST_NAME                                               
MFA-TR*                ,NAME_TYPE                                               
MFA-TR*                ,ADDRESS_ID                                              
MFA-TR*                ,FULL_NAME                                               
MFA-TR*                ,NICKNAME                                                
MFA-TR*                ,SSN                                                     
MFA-TR*                ,FORMATTED                                               
MFA-TR*          )                                                              
MFA-TR*          VALUES                                                         
MFA-TR*          (                                                              
MFA-TR*                  :S-RETURN-CODE                                         
MFA-TR*                 ,:S-CONTACT-ENTITY                                      
MFA-TR*                 ,:S-NAME-ID                                             
MFA-TR*                 ,:S-CONTACT-TYPE                                        
MFA-TR*                 ,:S-CONTACT-ORDER                                       
MFA-TR*                 ,:S-CONTACT-POSITION                                    
MFA-TR*                 ,:S-ADDR-STREET                                         
MFA-TR*                 ,:S-ADDR-CITY-STATE                                     
MFA-TR*                 ,:S-ADDR-ZIP-CODE                                       
MFA-TR*                 ,:S-ADDR-COUNTRY                                        
MFA-TR*                 ,:S-ADDRESS-OVERFLOW                                    
MFA-TR*                 ,:S-PHONE-TYPE                                          
MFA-TR*                 ,:S-PHONE-NO                                            
MFA-TR*                 ,:S-EXTENSION-NO                                        
MFA-TR*                 ,:S-REPEAT-COUNT                                        
MFA-TR*                 ,:S-CONTACT-ID                                          
MFA-TR*                 ,:S-FIRST-NAME                                          
MFA-TR*                 ,:S-MIDDLE-NAME                                         
MFA-TR*                 ,:S-LAST-NAME                                           
MFA-TR*                 ,:S-NAME-TYPE                                           
MFA-TR*                 ,:S-ADDRESS-ID                                          
MFA-TR*                 ,:S-FULL-NAME                                           
MFA-TR*                 ,:S-NICKNAME                                            
MFA-TR*                 ,'N'                                                    
MFA-TR*                 ,'N'                                                    
MFA-TR*           )                                                             
MFA-TR*       END-EXEC.                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.    
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 ADD +1                    TO CTR-ROWS                  
              ELSE                                                      
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE '8100'               TO ACTIVE-PARAGRAPH          
                 MOVE 'INSERT'             TO ABEND-FUNCTION            
                 MOVE SPACES               TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                 MOVE 'CSR02197_R1'        TO TABLE-1                   
                 MOVE SPACES               TO TABLE-ELEMENT-1           
                 MOVE SPACES               TO HOSTVAR-ELEMENT-1         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
            END-IF.                                                     
                                                                        
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
            MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.         
                                                                        
            EXEC SQL                                                    
                  DELETE FROM #CSR02197_R1                       
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*           DELETE FROM SESSION.CSR02197_R1                               
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '8000A'               TO ACTIVE-PARAGRAPH           
               MOVE 'DELETE'              TO ABEND-FUNCTION             
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSR02197_R1'         TO TABLE-1                    
               MOVE SPACES                TO TABLE-ELEMENT-1            
               MOVE SPACES                TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
        8000A-EXIT.                                                     
             EXIT.                                                      
                                                                        
           EXEC SQL                                                             
                INCLUDE CPDSP300                                                
           END-EXEC.                                                            
           EXEC SQL                                                             
                INCLUDE CPD00320                                                
           END-EXEC.                                                            
                                                                        
