       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02195.                                         
COB303 DATE-WRITTEN.                                                    
COB303            NOVEMBER 21, 1995.                                    
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S195 CONVERTED TO DB2 SP CSR02195 ON 11/23/2005        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S195                                           *        
      *  PROGRAM:       S195                                           *        
      *  CALLING SP:    PA_S195                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *        
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES VOUCHER PAYMENTS FOR A PARTICULAR ACCT *        
      *  NO  FROM CSS_LIEAP TABLE AND ALSO FILTER THE LIST FOR A       *        
      *  PARTICULAR AGENCY                                             *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  11/21/95    BB       CREATED.                                 *        
TP5445*  03/17/97    PD       RETURN CODE ACCT STATUS.                 *        
T11562*  06/17/97    MKN      ADDED REIMBURSE DATE TO RETURN VALUES    *        
T13056*  09/11/97    PD       PUT RECONNECT PROCESSING.                *        
T13156*  09/23/97    PD       DISPLAY '00/00/0000' INSTEAD OF //       *        
T13156*                       WHEN NO DATA FOUND.                      *        
      *                                                                *        
CBSI  *  09/21/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *             MADRAS    ABEND PARAMETERS                         *        
T30955*  09/23/2005 CB18344   ADDED CHECK NUMBER FIELD TO PREVIOUS     *        
T30955*                       TRANSACTION DATAWINDOW                   *        
REARCH*  11/24/05   CVNS      RPC TO COBOL SP CONVERSION               *        
REARCH*             CHENNAI                                            *        
T33513*  01/05/006  CB18344   ADDED GAS_AVAILABLE_IND TO RETURN SET    *        
T33513*                       FOR WINTER ASSISTANCE.                   *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02195'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02195 STARTS HERE'.                  
                                                                        
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBLIEAP                                                   
           END-EXEC.                                                            
                                                                        
T13056     EXEC SQL                                                             
T13056        INCLUDE TBRECNCT                                                  
T13056     END-EXEC.                                                            
                                                                        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
T33513******  CSS_PREMISE  *******                                              
T33513     EXEC SQL                                                             
T33513        INCLUDE TBPREM                                                    
T33513     END-EXEC.                                                            
                                                                        
T12340     EXEC SQL                                                             
T12340        INCLUDE TBARCNTL                                                  
T12340     END-EXEC.                                                            
                                                                        
T12340     EXEC SQL                                                             
T12340        INCLUDE TBCHGOFF                                                  
T12340     END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
CVT999*    COPY SYGWCOB.                                                        
CVT999*    COPY SYDBCOB.                                                        
           COPY CCA00001.                                                       
CVT999*    COPY CWS00010.                                                       
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
REARCH*01  GW-LIB-MISC-FIELDS.                                                  
CVT999*    05  GWL-PROC                POINTER.                                 
CVT999*    05  GWL-INIT-HANDLE         POINTER.                                 
CVT999*    05  GWL-RC                  PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-NR           PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-DONE         PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-COUNT        PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-COMM         PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-RETURN-CODE  PIC S9(9) COMP.                          
REARCH*    05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                          
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9) COMP.                  
CVT999*    05  PARM-ID1                PIC S9(9) COMP VALUE 1.                  
           05  PARM-ACCOUNT-NO         PIC X(13)  VALUE SPACES.         
           05  PARM-ACCOUNT-NO-RED     REDEFINES PARM-ACCOUNT-NO        
                                       PIC 9(13).                       
           05  PARM-CODE-AGENCY-ID     PIC X(05) VALUE SPACES .         
           05  PARM-LIEAP-AGENCY       PIC X(05) VALUE SPACES .         
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
CVT999*    05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.                  
                                                                        
       01  COUNTER-FIELDS.                                              
CVT999*    05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.                  
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
CVT999*    05  MAX-LENGTH-PARM         PIC S9(9) COMP.                          
CVT999*    05  WRKLEN1                 PIC S9(9) COMP.                          
CVT999*    05  WRKLEN2                 PIC S9(9) COMP.                          
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME            PIC X(08) VALUE 'CSR02195'.      
           05  WS-ACCOUNT-NO           PIC 9(13) VALUE ZERO.            
           05  WS-ACCOUNT-NO-NUM       PIC S9(13) COMP-3 VALUE ZERO.    
           05  WS-ACCT-XFER-TO         PIC 9(13) VALUE ZERO.            
           05  WS-CODE-AGENCY-ID       PIC X(05)  VALUE SPACES.         
           05  WS-LIEAP-AGENCY         PIC X(05)  VALUE SPACES.         
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-ACTIVE-CODE          PIC X(01) VALUE 'A'.             
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05  WS-EPP-OFFER-DATE-NI    PIC S9(04) COMP VALUE 0.         
T11562     05  WS-LI-REIMBURSE-DT-NULL-IND PIC S9(04) COMP VALUE 0.     
T11562     05  WS-NULL-IND-1               PIC S9(04) COMP VALUE 0.     
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-VOUCHER-PAY-DT       PIC X(26) VALUE SPACES.          
           05  RS-VOUCHER-AMT          PIC S9(9)V99 COMP-3 VALUE 0.     
           05  RS-INITIATED-BY         PIC X(07) VALUE SPACES .         
           05  RS-CODE-AGENCY-ID       PIC X(05) VALUE SPACES .         
           05  RS-PYMT-FACILITY-CD     PIC X(1) VALUE SPACES.           
           05  RS-COMMENT              PIC X(25) VALUE SPACES .         
           05  RS-CODE-ACCT-STAT       PIC X(1) VALUE SPACES.           
T11562     05  RS-REIMBURSE-DT         PIC X(10) VALUE SPACES.          
           05  RS-TOT-0-3-6-9          PIC S9(9)V99 COMP-3 VALUE 0.     
T13056     05  RS-ACCT-XFER-TO         PIC X(13) VALUE SPACES.          
T13056     05  RS-AMT-TOT-RECONNECT    PIC S9(11)V99 COMP-3 VALUE +0.   
T13056     05  RS-AMT-RCNCT-COLL       PIC S9(11)V99 COMP-3 VALUE +0.   
T13056     05  RS-RECONNECT-IND        PIC X(01) VALUE SPACES.          
T30955     05  RS-CHECK-NO             PIC X(09) VALUE SPACES.          
T33513     05  RS-GAS-AVAILABLE-IND    PIC X(01) VALUE SPACES.          
REARCH                                                                  
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
REARCH     05  S-VOUCHER-PAY-DT        PIC X(26) VALUE SPACES.          
REARCH     05  S-VOUCHER-AMT           PIC S9(9)V99 COMP-3 VALUE 0.     
REARCH     05  S-INITIATED-BY          PIC X(07) VALUE SPACES .         
REARCH     05  S-CODE-AGENCY-ID        PIC X(05) VALUE SPACES .         
REARCH     05  S-PYMT-FACILITY-CD      PIC X(1) VALUE SPACES.           
REARCH     05  S-COMMENT               PIC X(25) VALUE SPACES .         
REARCH     05  S-CODE-ACCT-STAT        PIC X(1) VALUE SPACES.           
REARCH     05  S-REIMBURSE-DT          PIC X(10) VALUE SPACES.          
REARCH     05  S-TOT-0-3-6-9           PIC S9(9)V99 COMP-3 VALUE 0.     
REARCH     05  S-ACCT-XFER-TO          PIC X(13) VALUE SPACES.          
REARCH     05  S-AMT-TOT-RECONNECT     PIC S9(11)V99 COMP-3 VALUE +0.   
REARCH     05  S-AMT-RCNCT-COLL        PIC S9(11)V99 COMP-3 VALUE +0.   
REARCH     05  S-RECONNECT-IND         PIC X(01) VALUE SPACES.          
REARCH     05  S-CHECK-NO              PIC X(09) VALUE SPACES.          
T33513     05  S-GAS-AVAILABLE-IND     PIC X(01) VALUE SPACES.          
REARCH*                                                                         
CVT999*01  CNS-COLUMN-NAMES.                                                    
CVT999*    05  CNS-RETURN-CODE         PIC X(11) VALUE                          
CVT999*                                        'RETURN_CODE'.                   
CVT999*    05  CNS-VOUCHER-PAY-DT      PIC X(14) VALUE                          
CVT999*                                   'VOUCHER_PAY_DT'.                     
CVT999*    05  CNS-VOUCHER-AMT         PIC X(11) VALUE                          
CVT999*                                   'VOUCHER_AMT'.                        
CVT999*    05  CNS-INITIATED-BY        PIC X(12) VALUE                          
CVT999*                                   'INITIATED_BY'.                       
CVT999*    05  CNS-CODE-AGENCY-ID      PIC X(14) VALUE                          
CVT999*                                   'CODE_AGENCY_ID' .                    
CVT999*    05  CNS-PYMT-FACILITY-CD    PIC X(16) VALUE                          
CVT999*                                   'PYMT_FACILITY_CD' .                  
CVT999*    05  CNS-COMMENT             PIC X(07) VALUE 'COMMENT' .              
CVT999*    05  CNS-CODE-ACCT-STAT      PIC X(14) VALUE                          
CVT999*                                   'CODE_ACCT_STAT'.                     
CVT999*    05  CNS-REIMBURSE-DT        PIC X(12) VALUE                          
CVT999*                                   'REIMBURSE_DT'.                       
CVT999*    05  CNS-TOT-0-3-6-9         PIC X(11) VALUE                          
CVT999*                                   'TOT_0_3_6_9'.                        
CVT999*    05  CN-ACCT-XFER-TO          PIC X(12) VALUE                         
CVT999*                                       'ACCT_XFER_TO'.                   
CVT999*    05  CN-AMT-RECONNECT         PIC  X(13) VALUE                        
CVT999*                                       'AMT_RECONNECT'.                  
CVT999*    05  CN-AMT-RCNCT-COLL        PIC  X(14) VALUE                        
CVT999*                                       'AMT_RCNCT_COLL'.                 
CVT999*    05  CN-RECONNECT-IND         PIC  X(13) VALUE                        
CVT999*                                       'RECONNECT_IND'.                  
CVT999*    05  CN-CHECK-NO              PIC  X(08) VALUE                        
CVT999*                                       'CHECK_NO'.                       
CVT999*                                                                         
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
           EXEC SQL                                                     
              DECLARE LI-CURSOR CURSOR FOR                              
              SELECT        REPLACE(REPLACE(CONVERT(CHAR(26), 
           VOUCHER_PAY_DT, 121), ' ', '-'), ':', '.') VOUCHER_PAY_DT ,         
                            VOUCHER_AMT    ,                            
T30955                      CHECK_NO       ,                            
                            INITIATED_BY   ,                            
                            PYMT_FACILITY_CD,                           
T11562                      REIMBURSE_DT,                               
                            COMMENT                                     
              FROM CSS_LIEAP                                            
              WHERE ACCOUNT_NO        = :LI-ACCOUNT-NO AND              
                    CODE_AGENCY_ID    = :LI-CODE-AGENCY-ID              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE LI-CURSOR CURSOR FOR                                      
MFA-TR*       SELECT        VOUCHER_PAY_DT ,                                    
MFA-TR*                     VOUCHER_AMT    ,                                    
MFA-TR*                     CHECK_NO       ,                                    
MFA-TR*                     INITIATED_BY   ,                                    
MFA-TR*                     PYMT_FACILITY_CD,                                   
MFA-TR*                     REIMBURSE_DT,                                       
MFA-TR*                     COMMENT                                             
MFA-TR*       FROM CSS_LIEAP                                                    
MFA-TR*       WHERE ACCOUNT_NO        = :LI-ACCOUNT-NO AND                      
MFA-TR*             CODE_AGENCY_ID    = :LI-CODE-AGENCY-ID                      
MFA-TR*    END-EXEC.                                                            
                                                                        
                                                                        
           EXEC SQL DECLARE LI1-CURSOR CURSOR FOR                       
              SELECT        REPLACE(REPLACE(CONVERT(CHAR(26), 
           VOUCHER_PAY_DT, 121), ' ', '-'), ':', '.') VOUCHER_PAY_DT ,         
                            VOUCHER_AMT    ,                            
T30955                      CHECK_NO       ,                            
                            INITIATED_BY   ,                            
                            CODE_AGENCY_ID ,                            
                            PYMT_FACILITY_CD,                           
T11562                      REIMBURSE_DT,                               
                            COMMENT                                     
              FROM CSS_LIEAP                                            
              WHERE ACCOUNT_NO        = :LI-ACCOUNT-NO AND              
                    CODE_AGENCY_ID    <> :LI-CODE-AGENCY-ID             
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE LI1-CURSOR CURSOR FOR                               
MFA-TR*       SELECT        VOUCHER_PAY_DT ,                                    
MFA-TR*                     VOUCHER_AMT    ,                                    
MFA-TR*                     CHECK_NO       ,                                    
MFA-TR*                     INITIATED_BY   ,                                    
MFA-TR*                     CODE_AGENCY_ID ,                                    
MFA-TR*                     PYMT_FACILITY_CD,                                   
MFA-TR*                     REIMBURSE_DT,                                       
MFA-TR*                     COMMENT                                             
MFA-TR*       FROM CSS_LIEAP                                                    
MFA-TR*       WHERE ACCOUNT_NO        = :LI-ACCOUNT-NO AND                      
MFA-TR*             CODE_AGENCY_ID    <> :LI-CODE-AGENCY-ID                     
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            
HPCCDM*EJECT                                                                    
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
REARCH*    10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        00001701
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         DECLARE C1 CURSOR  FOR                        
CVT000         SELECT                                                   
REARCH             RETURN_CODE                                          
REARCH            ,LTRIM(RTRIM(VOUCHER_PAY_DT))    AS VOUCHER_PAY_DT           
REARCH            ,VOUCHER_AMT                                          
REARCH            ,LTRIM(RTRIM(INITIATED_BY))      AS INITIATED_BY             
REARCH            ,LTRIM(RTRIM(CODE_AGENCY_ID))    AS CODE_AGENCY_ID           
REARCH            ,LTRIM(RTRIM(PYMT_FACILITY_CD))  AS PYMT_FACILITY_CD         
REARCH            ,LTRIM(RTRIM(COMMENT))           AS COMMENT                  
REARCH            ,LTRIM(RTRIM(CODE_ACCT_STAT))    AS CODE_ACCT_STAT           
REARCH            ,LTRIM(RTRIM(REIMBURSE_DT))      AS REIMBURSE_DT             
REARCH            ,TOT_0_3_6_9                                          
REARCH            ,LTRIM(RTRIM(ACCT_XFER_TO))      AS ACCT_XFER_TO             
REARCH            ,AMT_RECONNECT                                        
REARCH            ,AMT_RCNCT_COLL                                       
REARCH            ,LTRIM(RTRIM(RECONNECT_IND))     AS RECONNECT_IND            
REARCH            ,LTRIM(RTRIM(CHECK_NO))          AS CHECK_NO                 
T33513            ,LTRIM(RTRIM(GAS_AVAILABLE_IND)) AS GAS_AVAILABLE_IND        
CVT000         FROM #CSR02195_R1                                 
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00000100
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        00000300
MFA-TR*        SELECT                                                   00000400
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,STRIP(VOUCHER_PAY_DT)    AS VOUCHER_PAY_DT                   
MFA-TR*           ,VOUCHER_AMT                                                  
MFA-TR*           ,STRIP(INITIATED_BY)      AS INITIATED_BY                     
MFA-TR*           ,STRIP(CODE_AGENCY_ID)    AS CODE_AGENCY_ID                   
MFA-TR*           ,STRIP(PYMT_FACILITY_CD)  AS PYMT_FACILITY_CD                 
MFA-TR*           ,STRIP(COMMENT)           AS COMMENT                          
MFA-TR*           ,STRIP(CODE_ACCT_STAT)    AS CODE_ACCT_STAT                   
MFA-TR*           ,STRIP(REIMBURSE_DT)      AS REIMBURSE_DT                     
MFA-TR*           ,TOT_0_3_6_9                                                  
MFA-TR*           ,STRIP(ACCT_XFER_TO)      AS ACCT_XFER_TO                     
MFA-TR*           ,AMT_RECONNECT                                                
MFA-TR*           ,AMT_RCNCT_COLL                                               
MFA-TR*           ,STRIP(RECONNECT_IND)     AS RECONNECT_IND                    
MFA-TR*           ,STRIP(CHECK_NO)          AS CHECK_NO                         
MFA-TR*           ,STRIP(GAS_AVAILABLE_IND) AS GAS_AVAILABLE_IND                
MFA-TR*        FROM SESSION.CSR02195_R1                                 00000500
MFA-TR*    END-EXEC.                                                    00000700
CVT000                                                                  
                                                                        
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-ACCOUNT-NO          PIC X(13)                .          
CVT000 01  LINK-CODE-AGENCY-ID      PIC X(05)                .          
CVT000 01  LINK-LIEAP-AGENCY        PIC X(05)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000           LINK-ACCOUNT-NO                                        
CVT000         , LINK-CODE-AGENCY-ID                                    
CVT000         , LINK-LIEAP-AGENCY                                      
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                                      
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
CVT999*    EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.                      
CVT999*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.             
                                                                        
CVT999*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,             
CVT999*                          SNA-CONNECTION-NAME, SNA-SUBC.                 
                                                                        
CVT999*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                              
                                                                        
CVT999*    IF GWL-RC NOT = TDS-PARM-PRESENT                                     
CVT999*       MOVE PROGRAM-NAME    TO ABEND-PROGRAM                             
CVT999*       MOVE '0100'          TO ACTIVE-PARAGRAPH                          
CVT999*       MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION              
CVT999*       MOVE 'CICS TRANSACTION'   TO TABLE-1                              
CVT999*       MOVE GWL-RC               TO WS-ACTIVE-RETURN-CODE                
CVT999*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
CVT999*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
CVT999*    END-IF.                                                              
                                                                        
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
CVT000     MOVE LINK-CODE-AGENCY-ID       TO PARM-CODE-AGENCY-ID      . 
CVT000     MOVE LINK-LIEAP-AGENCY         TO PARM-LIEAP-AGENCY        . 
CVT000     PERFORM 0100A-DECLARE-GTT                                    
CVT000       THRU 0100A-EXIT.                                           
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
CVT000 0100A-DECLARE-GTT.                                               
CVT000     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02195_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02195_R1
              (                                                          
CVT000         RETURN_CODE              INT                         
CVT000        ,VOUCHER_PAY_DT CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2         
CVT000        ,VOUCHER_AMT              DECIMAL(11,2)                   
CVT000        ,INITIATED_BY CHAR(07)  COLLATE LATIN1_GENERAL_100_BIN2           
CVT000        ,CODE_AGENCY_ID CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2         
CVT000        ,PYMT_FACILITY_CD CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2        
CVT000        ,COMMENT CHAR(25)  COLLATE LATIN1_GENERAL_100_BIN2                
CVT000        ,CODE_ACCT_STAT CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2          
CVT000        ,REIMBURSE_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2           
CVT000        ,TOT_0_3_6_9              DECIMAL(11,2)                   
CVT000        ,ACCT_XFER_TO CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2           
CVT000        ,AMT_RECONNECT            DECIMAL(13,2)                   
CVT000        ,AMT_RCNCT_COLL           DECIMAL(13,2)                   
CVT000        ,RECONNECT_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
CVT000        ,CHECK_NO CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2               
T33513        ,GAS_AVAILABLE_IND CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000       )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR02195_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
CVT000 0100A-EXIT.                                                      
CVT000         EXIT.                                                    
                                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
REARCH*    PERFORM 1100-RECEIVE-PARMS     THRU 1100-EXIT.                       
           MOVE PARM-ACCOUNT-NO-RED       TO WS-ACCOUNT-NO.             
           MOVE WS-ACCOUNT-NO             TO WS-ACCOUNT-NO-NUM.         
           MOVE WS-ACCOUNT-NO-NUM         TO LI-ACCOUNT-NO              
                                             AT-ACCOUNT-NO              
T12340                                       AC-ACCOUNT-NO              
T12340                                       CO-ACCOUNT-NO .            
           PERFORM 7900-SELECT-ACCOUNT    THRU 7900-EXIT.               
TP5445     MOVE AT-CODE-ACCT-STAT         TO RS-CODE-ACCT-STAT.         
T13056     IF AT-ACCT-XFER-TO > 0                                       
T13056        MOVE AT-ACCT-XFER-TO           TO WS-ACCT-XFER-TO         
T13056        MOVE WS-ACCT-XFER-TO           TO RS-ACCT-XFER-TO         
T13056     ELSE                                                         
T13056        MOVE SPACES                    TO RS-ACCT-XFER-TO         
T13056     END-IF.                                                      
T33513     IF PR-GAS-AVAILABLE-IND = 'A'                                
T33513        MOVE 'Y' TO RS-GAS-AVAILABLE-IND                          
T33513     ELSE                                                         
T33513        MOVE 'N' TO RS-GAS-AVAILABLE-IND                          
T33513     END-IF.                                                      
T13056*******                                                                   
T13056* IF A ROW EXIST IN CSS_RECONNECT TABLE, THE AGREED UPON                  
T13056* RECONNECT AMOUNT WILL BE USED AS DIRECTED AMOUNT.                       
T13056*******                                                                   
T13056     MOVE AT-ACCOUNT-NO             TO DL-ACCOUNT-NO.             
T13056     PERFORM 7100-SELECT-RECONNECT THRU 7100-EXIT.                
T13056     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T13056        MOVE DL-AMT-TOT-RECONNECT   TO RS-AMT-TOT-RECONNECT       
T13056        MOVE DL-RECNCT-COLLECT-AMT  TO RS-AMT-RCNCT-COLL          
T13056        MOVE 'Y'                    TO RS-RECONNECT-IND           
T13056     ELSE                                                         
T13056        MOVE ZEROES                 TO RS-AMT-TOT-RECONNECT       
T13056        MOVE ZEROES                 TO RS-AMT-RCNCT-COLL          
T13056        MOVE 'N'                    TO RS-RECONNECT-IND           
T13056     END-IF.                                                      
                                                                        
T12340     IF AT-CODE-ACCT-STAT = 'S'                                   
T12340          PERFORM 7960-TOTAL-CHRGOFF   THRU 7960-EXIT             
T12340     ELSE                                                         
T12340          PERFORM 7950-TOTAL-0-3-6-9    THRU 7950-EXIT            
T12340     END-IF.                                                      
T12340     IF WS-NULL-IND-1 < 0                                         
T12340        MOVE 0 TO RS-TOT-0-3-6-9                                  
T12340     END-IF.                                                      
T12340                                                                  
T12340                                                                  
T12340                                                                  
           IF PARM-CODE-AGENCY-ID = '00000' THEN                        
                MOVE PARM-LIEAP-AGENCY         TO LI-CODE-AGENCY-ID     
           ELSE                                                         
                MOVE PARM-CODE-AGENCY-ID       TO LI-CODE-AGENCY-ID     
           END-IF .                                                     
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH*1100-RECEIVE-PARMS.                                                      
CVT999*    MOVE 1                          TO PARM-ID1.                         
CVT999*    MOVE LENGTH OF PARM-ACCOUNT-NO TO MAX-LENGTH-PARM.                   
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-ACCOUNT-NO,                               
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
CVT999*    ADD 1                          TO PARM-ID1.                          
CVT999*    MOVE LENGTH OF PARM-CODE-AGENCY-ID TO MAX-LENGTH-PARM.               
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-CODE-AGENCY-ID,                           
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
CVT999*    ADD 1                          TO PARM-ID1.                          
CVT999*    MOVE LENGTH OF PARM-LIEAP-AGENCY TO MAX-LENGTH-PARM.                 
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-LIEAP-AGENCY,                             
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
REARCH*1100-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
                                                                        
REARCH*    PERFORM 2100-DESCRIBE-RESULT  THRU 2100-EXIT.                        
           PERFORM 2200-BUILD-RESULT     THRU 2200-EXIT.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
REARCH*                                                                         
REARCH*****************************************************************         
REARCH* 2000A-MOVE-RESULT.                                            *         
REARCH*****************************************************************         
REARCH*                                                                         
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH      MOVE RS-RETURN-CODE            TO S-RETURN-CODE.            
REARCH      MOVE RS-VOUCHER-PAY-DT         TO S-VOUCHER-PAY-DT.         
REARCH      MOVE RS-VOUCHER-AMT            TO S-VOUCHER-AMT.            
REARCH      MOVE RS-INITIATED-BY           TO S-INITIATED-BY.           
REARCH      MOVE RS-CODE-AGENCY-ID         TO S-CODE-AGENCY-ID.         
REARCH      MOVE RS-PYMT-FACILITY-CD       TO S-PYMT-FACILITY-CD.       
REARCH      MOVE RS-COMMENT                TO S-COMMENT.                
REARCH      MOVE RS-CODE-ACCT-STAT         TO S-CODE-ACCT-STAT.         
REARCH      MOVE RS-REIMBURSE-DT           TO S-REIMBURSE-DT.           
REARCH      MOVE RS-TOT-0-3-6-9            TO S-TOT-0-3-6-9.            
REARCH      MOVE RS-ACCT-XFER-TO           TO S-ACCT-XFER-TO.           
REARCH      MOVE RS-AMT-TOT-RECONNECT      TO S-AMT-TOT-RECONNECT.      
REARCH      MOVE RS-AMT-RCNCT-COLL         TO S-AMT-RCNCT-COLL.         
REARCH      MOVE RS-RECONNECT-IND          TO S-RECONNECT-IND.          
REARCH      MOVE RS-CHECK-NO               TO S-CHECK-NO.               
T33513      MOVE RS-GAS-AVAILABLE-IND      TO S-GAS-AVAILABLE-IND.      
REARCH                                                                  
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-DESCRIBE-RESULT                                           *        
      ******************************************************************        
                                                                        
REARCH*2100-DESCRIBE-RESULT.                                                    
REARCH*    MOVE '2000' TO ACTIVE-PARAGRAPH.                                     
                                                                        
CVT999*    MOVE 1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSINT4 TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSINT4 TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-RETURN-CODE      TO WRKLEN1.                       
CVT999*    MOVE LENGTH OF CNS-RETURN-CODE     TO WRKLEN2.                       
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RETURN-CODE,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-RETURN-CODE,                               
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-VOUCHER-PAY-DT   TO WRKLEN1.                       
CVT999*    MOVE LENGTH OF CNS-VOUCHER-PAY-DT  TO WRKLEN2.                       
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-VOUCHER-PAY-DT,                             
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-VOUCHER-PAY-DT,                            
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1        TO CTR-COLUMN.                                          
CVT999*    MOVE TDSDECIMAL         TO DB-HOST-TYPE.                             
CVT999*    MOVE TDSFLT8            TO DB-CLIENT-TYPE.                           
CVT999*    MOVE LENGTH OF RS-VOUCHER-AMT  TO WRKLEN1.                           
CVT999*    MOVE LENGTH OF CNS-VOUCHER-AMT TO WRKLEN2.                           
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-VOUCHER-AMT,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-VOUCHER-AMT,                               
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    MOVE +2 TO WRKLEN2.                                                  
CVT999*    CALL 'TDSETBCD' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          TDS-OBJECT-COL,                                
CVT999*                          CTR-COLUMN,                                    
CVT999*                          WRKLEN1,                                       
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR              TO DB-HOST-TYPE.                           
CVT999*    MOVE TDSCHAR              TO DB-CLIENT-TYPE.                         
CVT999*    MOVE LENGTH OF RS-INITIATED-BY  TO WRKLEN1.                          
CVT999*    MOVE LENGTH OF CNS-INITIATED-BY TO WRKLEN2.                          
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-INITIATED-BY,                               
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-INITIATED-BY,                              
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
                                                                        
CVT999*    ADD  1                  TO CTR-COLUMN.                               
CVT999*    MOVE TDSCHAR            TO DB-HOST-TYPE.                             
CVT999*    MOVE TDSCHAR            TO DB-CLIENT-TYPE.                           
CVT999*    MOVE LENGTH OF RS-CODE-AGENCY-ID   TO WRKLEN1.                       
CVT999*    MOVE LENGTH OF CNS-CODE-AGENCY-ID  TO WRKLEN2.                       
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-CODE-AGENCY-ID ,                            
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-CODE-AGENCY-ID,                            
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
                                                                        
                                                                        
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-PYMT-FACILITY-CD   TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-PYMT-FACILITY-CD  TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-PYMT-FACILITY-CD ,                          
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-PYMT-FACILITY-CD ,                         
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-COMMENT   TO WRKLEN1.                              
CVT999*    MOVE LENGTH OF CNS-COMMENT  TO WRKLEN2.                              
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-COMMENT ,                                   
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-COMMENT ,                                  
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-CODE-ACCT-STAT     TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-CODE-ACCT-STAT    TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-CODE-ACCT-STAT,                             
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-CODE-ACCT-STAT,                            
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-REIMBURSE-DT       TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-REIMBURSE-DT      TO WRKLEN2.                     
T11562                                                                  
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-REIMBURSE-DT,                               
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-REIMBURSE-DT,                              
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    ADD 1        TO CTR-COLUMN.                                          
CVT999*    MOVE TDSDECIMAL         TO DB-HOST-TYPE.                             
CVT999*    MOVE TDSFLT8            TO DB-CLIENT-TYPE.                           
CVT999*    MOVE LENGTH OF RS-TOT-0-3-6-9  TO WRKLEN1.                           
CVT999*    MOVE LENGTH OF CNS-TOT-0-3-6-9 TO WRKLEN2.                           
T12340                                                                  
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-TOT-0-3-6-9,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-TOT-0-3-6-9,                               
CVT999*                          WRKLEN2.                                       
T12340                                                                  
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
T12340                                                                  
CVT999*    MOVE +2 TO WRKLEN2.                                                  
CVT999*    CALL 'TDSETBCD' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          TDS-OBJECT-COL,                                
CVT999*                          CTR-COLUMN,                                    
CVT999*                          WRKLEN1,                                       
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
T12340                                                                  
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR    TO DB-HOST-TYPE.                                     
CVT999*    MOVE TDSCHAR    TO DB-CLIENT-TYPE.                                   
CVT999*    MOVE LENGTH OF RS-ACCT-XFER-TO TO WRKLEN1.                           
CVT999*    MOVE LENGTH OF CN-ACCT-XFER-TO TO WRKLEN2.                           
T13056                                                                  
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-ACCT-XFER-TO                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-ACCT-XFER-TO,                               
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
T13056                                                                  
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSDECIMAL TO DB-HOST-TYPE.                                     
CVT999*    MOVE TDSFLT8    TO DB-CLIENT-TYPE.                                   
CVT999*    MOVE LENGTH OF RS-AMT-TOT-RECONNECT TO WRKLEN1.                      
CVT999*    MOVE LENGTH OF CN-AMT-RECONNECT TO WRKLEN2.                          
T13056                                                                  
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-AMT-TOT-RECONNECT,                          
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-AMT-RECONNECT,                              
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
T13056                                                                  
CVT999*    MOVE +2 TO WRKLEN2.                                                  
CVT999*    CALL 'TDSETBCD' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          TDS-OBJECT-COL,                                
CVT999*                          CTR-COLUMN,                                    
CVT999*                          WRKLEN1,                                       
CVT999*                          WRKLEN2.                                       
T13056                                                                  
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSDECIMAL TO DB-HOST-TYPE.                                     
CVT999*    MOVE TDSFLT8    TO DB-CLIENT-TYPE.                                   
CVT999*    MOVE LENGTH OF RS-AMT-RCNCT-COLL TO WRKLEN1.                         
CVT999*    MOVE LENGTH OF CN-AMT-RCNCT-COLL TO WRKLEN2.                         
T13056                                                                  
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-AMT-RCNCT-COLL,                             
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-AMT-RCNCT-COLL,                             
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
T13056                                                                  
CVT999*    MOVE +2 TO WRKLEN2.                                                  
CVT999*    CALL 'TDSETBCD' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          TDS-OBJECT-COL,                                
CVT999*                          CTR-COLUMN,                                    
CVT999*                          WRKLEN1,                                       
CVT999*                          WRKLEN2.                                       
T13056                                                                  
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR    TO DB-HOST-TYPE.                                     
CVT999*    MOVE TDSCHAR    TO DB-CLIENT-TYPE.                                   
CVT999*    MOVE LENGTH OF RS-RECONNECT-IND  TO WRKLEN1.                         
CVT999*    MOVE LENGTH OF CN-RECONNECT-IND  TO WRKLEN2.                         
T13056                                                                  
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RECONNECT-IND,                              
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-RECONNECT-IND,                              
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
T13056                                                                  
CVT999*    ADD  1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR    TO DB-HOST-TYPE.                                     
CVT999*    MOVE TDSCHAR    TO DB-CLIENT-TYPE.                                   
CVT999*    MOVE LENGTH OF RS-CHECK-NO  TO WRKLEN1.                              
CVT999*    MOVE LENGTH OF CN-CHECK-NO  TO WRKLEN2.                              
T30955                                                                  
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-CHECK-NO,                                   
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-CHECK-NO,                                   
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
T30955                                                                  
REARCH*2100-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      ******************************************************************        
       2200-BUILD-RESULT.                                               
                                                                        
           PERFORM 7700-OPEN-LI-CURSOR           THRU 7700-EXIT .       
                                                                        
           PERFORM 7000-FETCH-EPP    THRU 7000-EXIT.                    
                                                                        
T12340*    IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                                 
T12340*       MOVE PROGRAM-NAME      TO ABEND-PROGRAM                           
T12340*       MOVE '2200'            TO ACTIVE-PARAGRAPH                        
T12340*       MOVE 'FETCH'           TO ABEND-FUNCTION                          
T12340*       MOVE 'CSS_LIEAP'       TO TABLE-1                                 
T12340*       MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1                         
T12340*       MOVE WS-ACCOUNT-NO-NUM TO HOSTVAR-ELEMENT-1                       
T12340*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
T12340*    END-IF.                                                              
                                                                        
           PERFORM 2300-PROCESS-FETCH            THRU 2300-EXIT         
           UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND .                    
                                                                        
           PERFORM 7800-CLOSE-LI-CURSOR          THRU 7800-EXIT .       
T12340     IF CTR-ROWS = 0                                              
T13156        MOVE '0000-00-00'               TO RS-VOUCHER-PAY-DT      
T12340        MOVE 0                          TO RS-VOUCHER-AMT         
T12340        MOVE SPACES                     TO RS-INITIATED-BY        
T12340        MOVE SPACES                     TO RS-CODE-AGENCY-ID      
T12340        MOVE SPACES                     TO RS-PYMT-FACILITY-CD    
T12340        MOVE SPACES                     TO RS-COMMENT             
T11562        MOVE SPACES                     TO RS-REIMBURSE-DT        
T12340        MOVE NOT-FOUND                  TO RS-RETURN-CODE         
REARCH        PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT           
T12340        PERFORM 8100-SEND-RESULT        THRU 8100-EXIT            
T12340     END-IF.                                                      
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2300-PROCESS-FETCH                                             *        
      ******************************************************************        
       2300-PROCESS-FETCH.                                              
                                                                        
           MOVE '2300'                TO ACTIVE-PARAGRAPH.              
                                                                        
           MOVE 0                     TO RS-RETURN-CODE.                
           MOVE LI-VOUCHER-PAY-DT     TO RS-VOUCHER-PAY-DT.             
           MOVE LI-VOUCHER-AMT        TO RS-VOUCHER-AMT.                
           MOVE LI-INITIATED-BY       TO RS-INITIATED-BY.               
T11562     IF WS-LI-REIMBURSE-DT-NULL-IND < 0                           
T11562         MOVE SPACES                TO RS-REIMBURSE-DT            
T11562     ELSE                                                         
T11562         MOVE LI-REIMBURSE-DT       TO RS-REIMBURSE-DT
           END-IF.           
           IF PARM-CODE-AGENCY-ID = '00000'                             
               MOVE LI-CODE-AGENCY-ID     TO RS-CODE-AGENCY-ID          
           ELSE                                                         
               MOVE PARM-CODE-AGENCY-ID     TO RS-CODE-AGENCY-ID        
           END-IF .                                                     
           MOVE LI-PYMT-FACILITY-CD   TO RS-PYMT-FACILITY-CD.           
           MOVE LI-COMMENT-TEXT       TO RS-COMMENT.                    
           MOVE SPACES                TO LI-COMMENT-TEXT.               
REARCH     PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT.             
           PERFORM 8100-SEND-RESULT        THRU 8100-EXIT.              
                                                                        
           PERFORM 7000-FETCH-EPP    THRU 7000-EXIT.                    
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-FETCH-EPP                                             *            
      ******************************************************************        
       7000-FETCH-EPP.                                                  
           IF PARM-CODE-AGENCY-ID = '00000'                             
                                                                        
              EXEC SQL                                                  
                  FETCH LI1-CURSOR                                      
                    INTO :LI-VOUCHER-PAY-DT,                            
                         :LI-VOUCHER-AMT,                               
T30955                   :LI-CHECK-NO,                                  
                         :LI-INITIATED-BY,                              
                         :LI-CODE-AGENCY-ID,                            
                         :LI-PYMT-FACILITY-CD,                          
T11562                   :LI-REIMBURSE-DT :WS-LI-REIMBURSE-DT-NULL-IND, 
                         :LI-COMMENT                                    
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                     
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
T30955*                               OR NOT-FOUND                              
T30955           MOVE LI-CHECK-NO TO RS-CHECK-NO                        
T30955        ELSE                                                      
T30955           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
                    NEXT SENTENCE                                       
                 ELSE                                                   
                    MOVE PROGRAM-NAME    TO ABEND-PROGRAM               
                    MOVE '7000'          TO ACTIVE-PARAGRAPH            
CBSI                MOVE 'FETCH'               TO ABEND-FUNCTION        
                    MOVE 'CSS_LIEAP'          TO TABLE-1                
                    MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1        
                    MOVE 'CODE_AGENCY_ID'     TO TABLE-ELEMENT-2        
CBSI                MOVE LI-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1      
CBSI                MOVE LI-CODE-AGENCY-ID    TO HOSTVAR-ELEMENT-2      
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
                 END-IF                                                 
T30955        END-IF                                                    
           ELSE                                                         
              EXEC SQL                                                  
                 FETCH LI-CURSOR                                        
                 INTO :LI-VOUCHER-PAY-DT     ,                          
                      :LI-VOUCHER-AMT        ,                          
T30955                :LI-CHECK-NO          ,                           
                      :LI-INITIATED-BY      ,                           
                      :LI-PYMT-FACILITY-CD ,                            
T11562                :LI-REIMBURSE-DT :WS-LI-REIMBURSE-DT-NULL-IND,    
                      :LI-COMMENT                                       
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                     
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
T30955*                               OR NOT-FOUND                              
T30955           MOVE LI-CHECK-NO TO RS-CHECK-NO                        
T30955        ELSE                                                      
T30955           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
                    NEXT SENTENCE                                       
                 ELSE                                                   
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE '7000'               TO ACTIVE-PARAGRAPH       
CBSI                MOVE 'FETCH'              TO ABEND-FUNCTION         
                    MOVE 'CSS_LIEAP'          TO TABLE-1                
                    MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1        
                    MOVE 'CODE_AGENCY_ID'     TO TABLE-ELEMENT-2        
CBSI                MOVE LI-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1      
CBSI                MOVE LI-CODE-AGENCY-ID    TO HOSTVAR-ELEMENT-2      
                    PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT      
                    PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT      
                 END-IF                                                 
T30955        END-IF                                                    
           END-IF.                                                      
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
T13056******************************************************************        
T13056* 7100-SELECT-RECONNECT                                          *        
T13056******************************************************************        
T13056 7100-SELECT-RECONNECT.                                           
T13056     EXEC SQL                                                     
T13056         SELECT                                                   
T13056            ACCOUNT_NO,         USER_ID,                          
T13056            RECNCT_NRML_HR_IND, DATETIME_SETUP,                   
T13056            AGREEMENT_COMMENTS, AMT_TOT_RECONNECT,                
T13056            RECNCT_COLLECT_AMT                                    
T13056          INTO                                                    
T13056            :DL-ACCOUNT-NO,         :DL-USER-ID,                  
T13056            :DL-RECNCT-NRML-HR-IND, :DL-DATETIME-SETUP,           
T13056            :DL-AGREEMENT-COMMENTS, :DL-AMT-TOT-RECONNECT,        
T13056            :DL-RECNCT-COLLECT-AMT                                
T13056        FROM CSS_RECONNECT                                        
T13056        WHERE ACCOUNT_NO        = :DL-ACCOUNT-NO                  
T13056     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T13056                                                                  
T13056     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T13056     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T13056                                 OR NOT-FOUND                     
T13056        NEXT SENTENCE                                             
T13056     ELSE                                                         
T13056        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
T13056        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
T13056        MOVE '7100'                TO ACTIVE-PARAGRAPH            
T13056        MOVE 'SELECT'              TO ABEND-FUNCTION              
T13056        MOVE SPACES                TO ABEND-SQL-PREDICATES        
T13056                                      ABEND-TABLES                
T13056        MOVE 'CSS_RECONNECT'       TO TABLE-1                     
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
T13056        MOVE DL-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T13056        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T13056        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T13056     END-IF.                                                      
T13056 7100-EXIT.                                                       
T13056     EXIT.                                                        
      ******************************************************************        
      * 7700-OPEN-LI-CURSOR                                            *        
      ******************************************************************        
       7700-OPEN-LI-CURSOR.                                             
                                                                        
           IF PARM-CODE-AGENCY-ID = '00000'                             
              EXEC SQL                                                  
                OPEN LI1-CURSOR                                         
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                     
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE PROGRAM-NAME    TO ABEND-PROGRAM                  
                 MOVE '7700'          TO ACTIVE-PARAGRAPH               
CBSI             MOVE 'OPEN'          TO ABEND-FUNCTION                 
                 MOVE 'CSS_LIEAP'          TO TABLE-1                   
                 MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1           
CBSI             MOVE 'CODE_AGENCY_ID'     TO TABLE-ELEMENT-2           
                 MOVE LI-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1         
CBSI             MOVE LI-CODE-AGENCY-ID    TO HOSTVAR-ELEMENT-2         
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           ELSE                                                         
              EXEC SQL                                                  
                 OPEN LI-CURSOR                                         
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                     
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE '7700'               TO ACTIVE-PARAGRAPH          
CBSI             MOVE 'OPEN'               TO ABEND-FUNCTION            
                 MOVE 'CSS_LIEAP'          TO TABLE-1                   
                 MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1           
CBSI             MOVE 'CODE_AGENCY_ID'     TO TABLE-ELEMENT-2           
CBSI             MOVE LI-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1         
CBSI             MOVE LI-CODE-AGENCY-ID    TO HOSTVAR-ELEMENT-2         
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7800-CLOSE-LI-CURSOR                                           *        
      ******************************************************************        
       7800-CLOSE-LI-CURSOR.                                            
                                                                        
           MOVE '7800'          TO ACTIVE-PARAGRAPH                     
                                                                        
           IF PARM-CODE-AGENCY-ID = '00000'                             
              EXEC SQL                                                  
                 CLOSE LI1-CURSOR                                       
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                     
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
CBSI             MOVE 'CLOSE'              TO ABEND-FUNCTION            
                 MOVE 'CSS_LIEAP'          TO TABLE-1                   
                 MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1           
CBSI             MOVE 'CODE_AGENCY_ID'     TO TABLE-ELEMENT-2           
                 MOVE LI-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1         
CBSI             MOVE LI-CODE-AGENCY-ID    TO HOSTVAR-ELEMENT-2         
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           ELSE                                                         
              EXEC SQL                                                  
                 CLOSE LI-CURSOR                                        
              END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
              MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                     
                                                                        
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
CBSI             MOVE 'CLOSE'              TO ABEND-FUNCTION            
                 MOVE 'CSS_LIEAP'          TO TABLE-1                   
                 MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1           
CBSI             MOVE 'CODE_AGENCY_ID'     TO TABLE-ELEMENT-2           
                 MOVE LI-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1         
CBSI             MOVE LI-CODE-AGENCY-ID    TO HOSTVAR-ELEMENT-2         
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF .                                                     
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7900-SELECT-ACCOUNT                                            *        
      ******************************************************************        
                                                                        
TP5445 7900-SELECT-ACCOUNT.                                             
TP5445                                                                  
TP5445     EXEC SQL                                                     
TP5445        SELECT CODE_ACCT_STAT,                                    
T13056               ACCT_XFER_TO,                                      
T33513               PR.GAS_AVAILABLE_IND                               
TP5445        INTO  :AT-CODE-ACCT-STAT,                                 
T13056              :AT-ACCT-XFER-TO,                                   
T33513              :PR-GAS-AVAILABLE-IND                               
TP5445        FROM   CSS_ACCOUNT  AT                                    
T33513              ,CSS_PREMISE  PR                                    
TP5445        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                        
T33513          AND  AT.PREMISE_NO = PR.PREMISE_NO                      
TP5445     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

TP5445                                                                  
TP5445     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
TP5445                                                                  
TP5445     IF WS-ACTIVE-RETURN-CODE =  SUCCESSFUL-CALL OR NOT-FOUND     
TP5445        NEXT SENTENCE                                             
TP5445     ELSE                                                         
TP5445        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
TP5445        MOVE '7900'              TO ACTIVE-PARAGRAPH              
TP5445        MOVE 'SELECT'            TO ABEND-FUNCTION                
TP5445        MOVE 'CSS_ACCOUNT'       TO TABLE-1                       
TP5445        MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
TP5445        MOVE WS-ACCOUNT-NO-NUM   TO HOSTVAR-ELEMENT-1             
TP5445        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
TP5445        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
TP5445     END-IF.                                                      
TP5445                                                                  
TP5445 7900-EXIT.                                                       
TP5445     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7950-TOTAL-0-3-6-9                                            *         
      ******************************************************************        
                                                                        
T12340 7950-TOTAL-0-3-6-9.                                              
T12340                                                                  
T12340     EXEC SQL                                                     
T12340        SELECT SUM(AMT_AR_DAY_00) +                               
T12340               SUM(AMT_AR_DAY_30) +                               
T12340               SUM(AMT_AR_DAY_60) +                               
T12340               SUM(AMT_AR_DAY_90)                                 
T12340        INTO  :RS-TOT-0-3-6-9 :WS-NULL-IND-1                       
T12340        FROM   CSS_AR_CNTL                                        
T12340        WHERE  ACCOUNT_NO = :AC-ACCOUNT-NO                        
T12340          AND  ITEM_ID    = 0                                     
T12340     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T12340                                                                  
T12340     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
T12340                                                                  
T12340     IF WS-ACTIVE-RETURN-CODE =  SUCCESSFUL-CALL OR NOT-FOUND     
T12340        NEXT SENTENCE                                             
T12340     ELSE                                                         
T12340        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
T12340        MOVE '7950'              TO ACTIVE-PARAGRAPH              
T12340        MOVE 'SELECT'            TO ABEND-FUNCTION                
T12340        MOVE 'CSS_ACCOUNT'       TO TABLE-1                       
T12340        MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
T12340        MOVE WS-ACCOUNT-NO-NUM   TO HOSTVAR-ELEMENT-1             
T12340        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T12340        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T12340     END-IF.                                                      
T12340                                                                  
T12340 7950-EXIT.                                                       
T12340     EXIT.                                                        
                                                                        
T12340 7960-TOTAL-CHRGOFF.                                              
T12340                                                                  
T12340     EXEC SQL                                                     
T12340        SELECT SUM(AMT_TRANS)                                     
T12340        INTO  :RS-TOT-0-3-6-9 :WS-NULL-IND-1                       
T12340        FROM   CSS_CHRG_OFF                                       
T12340        WHERE  ACCOUNT_NO = :CO-ACCOUNT-NO                        
T12340     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T12340                                                                  
T12340     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
T12340                                                                  
T12340     IF WS-ACTIVE-RETURN-CODE =  SUCCESSFUL-CALL OR NOT-FOUND     
T12340        NEXT SENTENCE                                             
T12340     ELSE                                                         
T12340        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
T12340        MOVE '7960'              TO ACTIVE-PARAGRAPH              
T12340        MOVE 'SELECT'            TO ABEND-FUNCTION                
T12340        MOVE 'CSS_ACCOUNT'       TO TABLE-1                       
T12340        MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
T12340        MOVE WS-ACCOUNT-NO-NUM   TO HOSTVAR-ELEMENT-1             
T12340        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T12340        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T12340     END-IF.                                                      
T12340                                                                  
T12340 7960-EXIT.                                                       
T12340     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
CVT999*    COPY CPD00302.                                                       
                                                                        
CVT000******************************************************************00000100
CVT000* 8000A-DELETE-GTT-ROWS.                                         *00000200
CVT000******************************************************************00000300
CVT000 8000A-DELETE-GTT-ROWS.                                           
CVT000*                                                                 00000500
CVT000     MOVE                                                         
CVT000     'DELETE ROWS'                                                
CVT000         TO S-SQL-STATEMENT-V.                                    
CVT000*                                                                 00000900
CVT000      EXEC SQL                                                    
CVT000          DELETE FROM #CSR02195_R1                         
CVT000      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    00001000
MFA-TR*         DELETE FROM SESSION.CSR02195_R1                         00001100
MFA-TR*     END-EXEC.                                                   00001200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000*                                                                 00001300
CVT000      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
CVT000*                                                                 00001500
CVT000      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
CVT000          NEXT SENTENCE                                           
CVT000      ELSE                                                        
CVT000         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
CVT000         MOVE '8000A'              TO ACTIVE-PARAGRAPH            
CVT000         MOVE 'DELETE'             TO ABEND-FUNCTION              
CVT000         MOVE SPACES               TO ABEND-SQL-PREDICATES        
CVT000                                      ABEND-TABLES                
CVT000         MOVE 'CSR02195_R1'        TO TABLE-1                     
CVT000         MOVE SPACES               TO TABLE-ELEMENT-1             
CVT000         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
CVT000         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
CVT000     END-IF.                                                      
CVT000*                                                                 00003100
CVT000 8000A-EXIT.                                                      
CVT000     EXIT.                                                        
CVT000*                                                                 00003400
CVT000 8100-SEND-RESULT.                                                
CVT000     EXEC SQL                                                     
CVT000       INSERT INTO #CSR02195_R1                            
CVT000       (                                                          
CVT000        RETURN_CODE                                               
CVT000       ,VOUCHER_PAY_DT                                            
CVT000       ,VOUCHER_AMT                                               
CVT000       ,INITIATED_BY                                              
CVT000       ,CODE_AGENCY_ID                                            
CVT000       ,PYMT_FACILITY_CD                                          
CVT000       ,COMMENT                                                   
CVT000       ,CODE_ACCT_STAT                                            
CVT000       ,REIMBURSE_DT                                              
CVT000       ,TOT_0_3_6_9                                               
CVT000       ,ACCT_XFER_TO                                              
CVT000       ,AMT_RECONNECT                                             
CVT000       ,AMT_RCNCT_COLL                                            
CVT000       ,RECONNECT_IND                                             
CVT000       ,CHECK_NO                                                  
T33513       ,GAS_AVAILABLE_IND                                         
CVT000       )                                                          
CVT000       VALUES                                                     
CVT000       (                                                          
CVT000        :S-RETURN-CODE                                            
CVT000       ,:S-VOUCHER-PAY-DT                                         
CVT000       ,:S-VOUCHER-AMT                                            
CVT000       ,:S-INITIATED-BY                                           
CVT000       ,:S-CODE-AGENCY-ID                                         
CVT000       ,:S-PYMT-FACILITY-CD                                       
CVT000       ,:S-COMMENT                                                
CVT000       ,:S-CODE-ACCT-STAT                                         
CVT000       ,:S-REIMBURSE-DT                                           
CVT000       ,:S-TOT-0-3-6-9                                            
CVT000       ,:S-ACCT-XFER-TO                                           
CVT000       ,:S-AMT-TOT-RECONNECT                                      
CVT000       ,:S-AMT-RCNCT-COLL                                         
CVT000       ,:S-RECONNECT-IND                                          
CVT000       ,:S-CHECK-NO                                               
T33513       ,:S-GAS-AVAILABLE-IND                                      
CVT000       )                                                          
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR02195_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,VOUCHER_PAY_DT                                                    
MFA-TR*      ,VOUCHER_AMT                                                       
MFA-TR*      ,INITIATED_BY                                                      
MFA-TR*      ,CODE_AGENCY_ID                                                    
MFA-TR*      ,PYMT_FACILITY_CD                                                  
MFA-TR*      ,COMMENT                                                           
MFA-TR*      ,CODE_ACCT_STAT                                                    
MFA-TR*      ,REIMBURSE_DT                                                      
MFA-TR*      ,TOT_0_3_6_9                                                       
MFA-TR*      ,ACCT_XFER_TO                                                      
MFA-TR*      ,AMT_RECONNECT                                                     
MFA-TR*      ,AMT_RCNCT_COLL                                                    
MFA-TR*      ,RECONNECT_IND                                                     
MFA-TR*      ,CHECK_NO                                                          
MFA-TR*      ,GAS_AVAILABLE_IND                                                 
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE                                                    
MFA-TR*      ,:S-VOUCHER-PAY-DT                                                 
MFA-TR*      ,:S-VOUCHER-AMT                                                    
MFA-TR*      ,:S-INITIATED-BY                                                   
MFA-TR*      ,:S-CODE-AGENCY-ID                                                 
MFA-TR*      ,:S-PYMT-FACILITY-CD                                               
MFA-TR*      ,:S-COMMENT                                                        
MFA-TR*      ,:S-CODE-ACCT-STAT                                                 
MFA-TR*      ,:S-REIMBURSE-DT                                                   
MFA-TR*      ,:S-TOT-0-3-6-9                                                    
MFA-TR*      ,:S-ACCT-XFER-TO                                                   
MFA-TR*      ,:S-AMT-TOT-RECONNECT                                              
MFA-TR*      ,:S-AMT-RCNCT-COLL                                                 
MFA-TR*      ,:S-RECONNECT-IND                                                  
MFA-TR*      ,:S-CHECK-NO                                                       
MFA-TR*      ,:S-GAS-AVAILABLE-IND                                              
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
CVT000                                                                  
CVT000     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
CVT000        NEXT SENTENCE                                             
CVT000     ELSE                                                         
CVT000        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CVT000        MOVE SQLCODE              TO ABEND-SQLCODE                
CVT000        MOVE SQLSTATE             TO ABEND-SQLSTATE               
CVT000        MOVE '8100'               TO ACTIVE-PARAGRAPH             
CVT000        MOVE 'INSERT'             TO ABEND-FUNCTION               
CVT000        MOVE 'CSR02195_R1'        TO TABLE-1                      
CVT000        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
CVT000     END-IF.                                                      
CVT000                                                                  
CVT000     ADD 1 TO CTR-ROWS.                                           
CVT000*    INITIALIZE GTT-RETURN-FIELDS.                                00001900
CVT000*                                                                 00002000
CVT000 8100-EXIT.                                                       
CVT000      EXIT.                                                       
REARCH*                                                                         
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00320                                         00000200
CVT000     END-EXEC.                                                    00000300
