       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR02194.                                          
COB303 DATE-WRITTEN.     NOVEMBER 10, 1995.                             
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      ***              SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S194                                           *        
      *  PROGRAM:       S194                                           *        
      *  CALLING SP:    PA_S194                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *        
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *        
      *  THIS PROGRAM RETRIEVES THE DATA FROM CSS_BANKRUPTCY BASED ON  *        
      *  THE ACCOUNT_NO AND FILED_CASE_NO PASSED TO THE RPC.           *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  11/10/95      SR     INITIALLY CODED.                         *        
TP5205*  08/26/95      SG     ADDED NULL INDICATOR TO SELECT STATEMENTS*        
TP5205*                       FOR CSS_BANKRUPTCY                       *        
TP5788*  10/22/96      JP     REFORMAT RECEIVED_DATE AND DATE_FILED    *        
TP5928*  10/23/96      JP     CHANGED LOGIC TO SEARCH FOR FILE-CASE-NO *        
TP5928*                       BEFORE DEFAULTING TO ACCOUNT-NO SEARCH   *        
CBSI  *  10/26/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *              MADRAS   ABEND PARAMETERS.                        *        
REARCH*  05/19/05    CVNS     RPC TO COBOL SP CONVERSION               *        
REARCH*              CHENNAI                                           *        
REARCH*  07/20/05    CVNS     ADDED STRIP FOR FILED-CASE-NO,           *        
REARCH*              CHENNAI  BNKRPT-CASE-NO AND BKTCY-CHAPTER         *        
A04527*  06/07/13    MR7E794  REMOVED UNUSED COPYBOOK CWS00056.        *        
P00936*  04/21/16    VK7L032  COMBINED ALL THE LOGIC FROM CSR02192.    *        
A05460*  09/22/16    MR7E794  REMOVED THE MAIN USER TABLE AS PART      *        
      *              ACT282   OF TABLE CHANGE AND GETTING THE SAME     *        
      *                       VALUE FROM CODE VALUE TABLE.             *        
ACT383*  12/12/16    VIJAY    REMOVED UNUSED DCLGEN TBATTYPE           *        
      *  A05460                                                        *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02194'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02194 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBBNKRPT                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
P00936     EXEC SQL                                                             
P00936         INCLUDE TBNAME                                                   
P00936     END-EXEC.                                                            
P00936                                                                  
P00936     EXEC SQL                                                             
P00936        INCLUDE TBZIPCD                                                   
P00936     END-EXEC.                                                            
P00936                                                                  
P00936     EXEC SQL                                                             
P00936         INCLUDE TBADRFMT                                                 
P00936     END-EXEC.                                                            
P00936                                                                  
P00936     EXEC SQL                                                             
P00936         INCLUDE TBADRFRE                                                 
P00936     END-EXEC.                                                            
P00936                                                                  
P00936     EXEC SQL                                                             
P00936         INCLUDE TBNMACTX                                                 
P00936     END-EXEC.                                                            
P00936                                                                  
P00936     EXEC SQL                                                             
P00936         INCLUDE TBARCNTL                                                 
P00936     END-EXEC.                                                            
P00936     EXEC SQL                                                             
P00936        INCLUDE TBCHGOFF                                                  
P00936     END-EXEC.                                                            
ACT282* SW - CSS_SO_CODE_DESC                                                   
ACT282     EXEC SQL                                                             
ACT282       INCLUDE TBSOCODE                                                   
ACT282     END-EXEC.                                                            
                                                                        
      ******************************************************************        
                                                                        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *--------< CONTAINS THE COBOL EQUATES NEEDED FOR USING THE >              
      *--------< SYBASE OPEN SERVER FOR CICS FACILITIES.         >              
REARCH*    COPY SYGWCOB.                                                        
                                                                        
      *--------< ADDED TO SUPPORT CICS RPCS >                                   
REARCH*    COPY SYDBCOB.                                                        
                                                                        
      *--------<COMMON SYSTEM AREA >                                            
           COPY CCA00001.                                                       
                                                                        
      *--------< ERROR HANDLING >                                               
REARCH*    COPY CWS00010.                                                       
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CWSX0010                                                  
REARCH     END-EXEC.                                                            
                                                                        
      *--------< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >               
           COPY CWS00027.                                                       
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                          
           COPY CWS00303.                                                       
P00936*--------< REDUCE EMBEDDED SPACES >                                       
P00936     COPY CWS00011.                                                       
                                                                        
                                                                        
       01  WS-MISC.                                                     
P00936    05 WS-GTT-NAME             PIC X(19) VALUE SPACES.            
REARCH     05 WS-SQLSTATE                      PIC X(05) VALUE SPACES.  
           05 WS-CASE-NO-FOUND-FLAG            PIC X(01) VALUE 'N'.     
              88 CASE-NO-FOUND    VALUE 'Y'.                            
           05 WS-NULL-INDICATORS.                                       
              10 WS-AT-DT-START-NULL-IND       PIC S9(4) COMP.          
              10 WS-AT-REMOVE-DT-NULL-IND      PIC S9(4) COMP.          
              10 WS-AT-LAST-BILL-DT-NULL-IND   PIC S9(4) COMP.          
TP5205        10 WS-BQ-FILE-DATE-NULL-IND      PIC S9(4) COMP.          
TP5205        10 WS-BQ-RECV-DATE-NULL-IND      PIC S9(4) COMP.          
           05 WS-ACCOUNT-NO            PIC X(13).                       
           05 WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO                 
                                       PIC 9(13).                       
           05 WS-SELECT-RETURN-CODE    PIC S9(9) COMP.                  
P00936     05 WS-PREMISE-NUM           PIC 9(10).                       
P00936     05 WS-PREMISE-NO     REDEFINES WS-PREMISE-NUM                
                                       PIC X(10).                       
REARCH     05 PROGRAM-NAME             PIC X(08) VALUE 'CSR02194'.      
P00936     05  WS-ADDRESS.                                              
P00936*        10  WS-ADDRESS-X        OCCURS 50 TIMES                          
P00936         10  WS-ADDRESS-X        OCCURS 81 TIMES                  
P00936                                 INDEXED BY WS-ADD-SUB.           
P00936             15  FILLER          PIC X.                           
P00936     05  WS-ADD-SUB-CNT          PIC 99 VALUE 1.                  
P00936     05  WS-LENGTH               PIC S9(4).                       
P00936     05  WS-MAX-SZ               PIC S9(4).                       
P00936     05  WS-FULL-BALANCE-A       PIC S9(11)V99 VALUE 0 COMP-3.    
P00936     05  WS-FULL-BALANCE-B       PIC S9(11)V99 VALUE 0 COMP-3.    
P00936     05  WS-NULL-1               PIC S9(4) COMP VALUE +0.         
P00936     05  WS-NULL-4               PIC S9(4) COMP VALUE +0.         
P00936     05  WS-NULL-5               PIC S9(4) COMP VALUE +0.         
P00936     05  WS-NULL-6               PIC S9(4) COMP VALUE +0.         
P00936 01  WS-SUB                      PIC S9(8) COMP VALUE ZERO.       
      *                                                                 00052000
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
      *                                                                 00052000
HPCCDM*    EJECT                                                        00096000
REARCH*                                                                         
REARCH*01  GW-LIB-MISC-FIELDS.                                                  
REARCH*    05  GWL-PROC                POINTER.                                 
REARCH*    05  GWL-INIT-HANDLE         POINTER.                                 
REARCH*    05  GWL-RC                  PIC S9(9) COMP.                          
REARCH*    05  GWL-STATUS-NR           PIC S9(9) COMP.                          
REARCH*    05  GWL-STATUS-DONE         PIC S9(9) COMP.                          
REARCH*    05  GWL-STATUS-COUNT        PIC S9(9) COMP.                          
REARCH*    05  GWL-STATUS-COMM         PIC S9(9) COMP.                          
REARCH*    05  GWL-STATUS-RETURN-CODE  PIC S9(9) COMP.                          
REARCH*    05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                          
      *                                                                         
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH      05  GTT-NAME                PIC X(26)                       
REARCH                                  VALUE 'SESSION.CSR02194_R1'.    
REARCH      05  GTT-ROW.                                                
REARCH          49 GTT-ROW-LEN          PIC S9(04) COMP.                
REARCH          49 GTT-ROW-CHAR         PIC X(1024).                    
REARCH      05  GTT-SQLCODE             PIC S9(09) COMP.                
REARCH*                                                                         
P00936 01  GTT-MISC-FIELDS-2.                                           
P00936     05  GTT-NAME-2                PIC X(26) VALUE                
P00936                                       'SESSION.CSR02194_R2'.     
P00936     05  GTT-ROW-2.                                               
P00936         49 GTT-ROW-LEN-2          PIC S9(04) COMP.               
P00936         49 GTT-ROW-CHAR-2         PIC X(1024).                   
P00936     05  GTT-SQLCODE-2             PIC S9(9) COMP.                
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
REARCH*01  PARM-FIELDS.                                                         
REARCH*    05  PARM-L                  PIC S9(9) COMP.                          
REARCH*    05  PARM-ID1                PIC S9(9) COMP VALUE 1.                  
REARCH*    05  PARM-ACCOUNT-NO         PIC X(13).                               
REARCH*    05  PARM-FILED-CASE-NO      PIC X(10).                               
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
P00936     05  CTR-ROWS-2              PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
P00936     05  WS-FROM.                                                 
P00936         10  WS-FROM-X           OCCURS 51 TIMES PIC X.           
                                                                        
TP5788 01  WS-DATE-FORMATTED.                                           
TP5788     05 WS-MONTH-FORMAT      PIC X(2)       VALUE SPACES.         
TP5788     05 WS-SLASH-1           PIC X(1)       VALUE SPACE.          
TP5788     05 WS-DAY-FORMAT        PIC X(2)       VALUE SPACES.         
TP5788     05 WS-SLASH-2           PIC X(1)       VALUE SPACE.          
TP5788     05 WS-YEAR-FORMAT       PIC X(4)       VALUE SPACES.         
                                                                        
TP5788 01  WS-DATE-UNFORMATTED.                                         
TP5788     05 WS-MONTH             PIC X(2)       VALUE SPACES.         
TP5788     05 WS-DAY               PIC X(2)       VALUE SPACES.         
TP5788     05 WS-YEAR              PIC X(4)       VALUE SPACES.         
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05 RS-RETURN-CODE       PIC S9(9) COMP VALUE 0.              
           05 RS-FILED-CASE-NO     PIC X(15)      VALUE SPACES.         
           05 RS-BNKRPT-CASE-NO    PIC X(10)      VALUE SPACES.         
           05 RS-BKTCY-CHAPTER     PIC X(02)      VALUE SPACES.         
           05 RS-DATE-BKTCY-FILED  PIC X(08)      VALUE SPACES.         
           05 RS-INIT-BY           PIC X(07)      VALUE SPACES.         
           05 RS-RECEIVED-DATE     PIC X(08)      VALUE SPACES.         
REARCH                                                                  
REARCH 01  GTT-RETURN-FIELDS.                                           
P00936     05 GTT-RETURN-FIELDS-1.                                      
P00936        10 S-RETURN-CODE       PIC S9(9) COMP VALUE 0.            
P00936        10 S-FILED-CASE-NO     PIC X(15)      VALUE SPACES.       
P00936        10 S-BNKRPT-CASE-NO    PIC X(10)      VALUE SPACES.       
P00936        10 S-BKTCY-CHAPTER     PIC X(02)      VALUE SPACES.       
P00936        10 S-DATE-BKTCY-FILED  PIC X(08)      VALUE SPACES.       
P00936        10 S-INIT-BY           PIC X(07)      VALUE SPACES.       
P00936        10 S-RECEIVED-DATE     PIC X(08)      VALUE SPACES.       
P00936     05 GTT-RETURN-FIELDS-2.                                      
P00936        10 S2-RETURN-CODE      PIC S9(9) COMP VALUE 0.            
P00936        10 S2-NAME             PIC X(77)   VALUE SPACES.          
P00936        10 S2-ACCT-TYPE-DESC   PIC X(25)   VALUE SPACES.          
P00936        10 S2-ACCOUNT-NO       PIC X(13)   VALUE SPACES.          
P00936        10 S2-CUSTOMER-NO      PIC X(10)   VALUE SPACES.          
P00936        10 S2-ADDRESS          PIC X(81)   VALUE SPACES.          
P00936        10 S2-BNKRPT-IND       PIC X(01)   VALUE SPACES.          
P00936        10 S2-PREMISE-NO       PIC X(10)   VALUE SPACES.          
P00936        10 S2-ACCT-TYPE        PIC X(01)   VALUE SPACES.          
P00936        10 S2-CODE-ACCT-STAT   PIC X(01)   VALUE SPACES.          
P00936        10 S2-ACCOUNT-BALANCE  PIC S9(11)V99 VALUE 0 COMP-3.      
P00936        10 S2-CREATE-DT        PIC X(10)   VALUE SPACES.          
P00936*                                                                         
P00936*                                                                         
P00936 01  TDS-RETURN-FIELDS-2.                                         
P00936     05 RS2-RETURN-CODE       PIC S9(9) COMP VALUE 0.             
P00936*    05 RS-NAME              PIC X(50)      VALUE SPACES.                 
P00936     05 RS2-NAME              PIC X(77)      VALUE SPACES.        
P00936     05 RS2-ACCT-TYPE-DESC    PIC X(25)      VALUE SPACES.        
P00936     05 RS2-ACCOUNT-NO        PIC X(13)      VALUE SPACES.        
P00936     05 RS2-CUSTOMER-NO       PIC X(10)      VALUE SPACES.        
P00936*    05 RS-ADDRESS           PIC X(50)      VALUE SPACES.                 
P00936     05 RS2-ADDRESS           PIC X(81)      VALUE SPACES.        
P00936     05 RS2-BNKRPT-IND        PIC X(01)      VALUE SPACES.        
P00936     05 RS2-PREMISE-NO        PIC X(10)      VALUE SPACES.        
P00936     05 RS2-ACCT-TYPE         PIC X(01)      VALUE SPACES.        
P00936     05 RS2-CODE-ACCT-STAT    PIC X(01)      VALUE SPACES.        
P00936     05 RS2-ACCOUNT-BALANCE   PIC S9(11)V99 VALUE 0 COMP-3.       
P00936     05 RS2-CREATE-DT         PIC X(10)      VALUE SPACES.        
P00936*                                                                         
P00936*                                                                         
REARCH*01  CNS-COLUMN-NAMES.                                                    
REARCH*    05 CNS-RETURN-CODE       PIC X(11) VALUE 'RETURN_CODE'.              
REARCH*    05 CNS-FILED-CASE-NO     PIC X(13) VALUE 'FILED_CASE_NO'.            
REARCH*    05 CNS-BNKRPT-CASE-NO    PIC X(14) VALUE 'BNKRPT_CASE_NO'.           
REARCH*    05 CNS-BKTCY-CHAPTER     PIC X(13) VALUE 'BKTCY_CHAPTER'.            
REARCH*    05 CNS-DATE-BKTCY-FILED  PIC X(16) VALUE 'DATE_BKTCY_FILED'.         
REARCH*    05 CNS-INIT-BY           PIC X(07) VALUE 'INIT_BY'.                  
REARCH*    05 CNS-RECEIVED-DATE     PIC X(13) VALUE 'RECEIVED_DATE'.            
P00936*                                                                         
P00936*                                                                         
P00936 01  CN-CONSTANTS.                                                
P00936     05  CN-DELIMITER                 PIC X VALUE ';'.            
P00936     05  CN-ASTERISK                  PIC X VALUE '*'.            
REARCH*                                                                         
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
REARCH     10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
REARCH     10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
REARCH     10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
REARCH         49  S-HOST-VARIABLES-V  PIC X(255).                      
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-STATEMENT-V   PIC X(255).                      
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-DESCRIPTION-V PIC X(255).                      
REARCH                                                                  
P00936******************************************************************01014000
P00936*                                                                *01015000
P00936*  CURSOR DECLARATION FOR THE CSS_ACCOUNT TABLE.                 *01016000
P00936*                                                                *01019000
P00936******************************************************************01020000
P00936     EXEC SQL                                                     
P00936       DECLARE AT_CRSR CURSOR FOR                                 
P00936       SELECT ACCOUNT_NO,                                         
P00936              BANKRUPTCY_IND,                                     
P00936              CUSTOMER_NO,                                        
P00936              PREMISE_NO,                                         
P00936              ADDRESS_FORMAT,                                     
P00936              ACCOUNT_TYPE_CODE,                                  
P00936              CODE_ACCT_STAT                                      
P00936         FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                           
P00936        WHERE BNKRPT_CASE_NO = :AT-BNKRPT-CASE-NO                 
P00936        FOR READ ONLY                                     
P00936     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     01021000
MFA-TR*      DECLARE AT_CRSR CURSOR FOR                                 01022000
MFA-TR*      SELECT ACCOUNT_NO,                                                 
MFA-TR*             BANKRUPTCY_IND,                                             
MFA-TR*             CUSTOMER_NO,                                                
MFA-TR*             PREMISE_NO,                                                 
MFA-TR*             ADDRESS_FORMAT,                                             
MFA-TR*             ACCOUNT_TYPE_CODE,                                          
MFA-TR*             CODE_ACCT_STAT                                              
MFA-TR*        FROM CSS_ACCOUNT                                                 
MFA-TR*       WHERE BNKRPT_CASE_NO = :AT-BNKRPT-CASE-NO                         
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
P00936*                                                                         
HPCCDM*    EJECT                                                        02620001
      *                                                                         
REARCH LINKAGE SECTION.                                                 
REARCH*                                                                         
REARCH 01 PARM-ACCOUNT-NO           PIC X(13).                          
REARCH 01 PARM-FILED-CASE-NO        PIC X(15).                          
      *                                                                         
REARCH PROCEDURE DIVISION USING  PARM-ACCOUNT-NO                        
REARCH                           PARM-FILED-CASE-NO.                    
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
REARCH*    PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                          
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
REARCH*                                                                         
REARCH*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.             
REARCH*                                                                         
REARCH*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,             
REARCH*                          SNA-CONNECTION-NAME, SNA-SUBC.                 
REARCH*                                                                         
REARCH*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                              
REARCH*                                                                         
REARCH*    IF GWL-RC NOT = TDS-PARM-PRESENT                                     
REARCH*       MOVE PROGRAM-NAME         TO ABEND-PROGRAM                        
REARCH*       MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION              
REARCH*       MOVE 'CICS TRANSACTION'   TO TABLE-1                              
REARCH*       MOVE GWL-RC               TO WS-ACTIVE-RETURN-CODE                
REARCH*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
REARCH*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
REARCH*    END-IF.                                                              
REARCH*                                                                         
P00936     PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
REARCH     EXEC SQL                                                     
REARCH          DECLARE C1 CURSOR  FOR                       
REARCH          SELECT                                                  
REARCH               :S-RETURN-CODE               AS RETURN_CODE        
REARCH              ,LTRIM(RTRIM(:S-FILED-CASE-NO))      AS 
           FILED_CASE_NO      
REARCH              ,LTRIM(RTRIM(:S-BNKRPT-CASE-NO))     AS 
           BNKRPT_CASE_NO     
REARCH              ,LTRIM(RTRIM(:S-BKTCY-CHAPTER))      AS 
           S_BKTCY_CHAPTER    
REARCH              ,:S-DATE-BKTCY-FILED          AS DATE_BKTCY_FILED   
REARCH              ,:S-INIT-BY                   AS INIT_BY            
REARCH              ,:S-RECEIVED-DATE             AS RECEIVED_DATE      
REARCH          FROM                                                    
P00936               #CSR02194_R1                                
P00936     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*              :S-RETURN-CODE               AS RETURN_CODE                
MFA-TR*             ,STRIP(:S-FILED-CASE-NO)      AS FILED_CASE_NO              
MFA-TR*             ,STRIP(:S-BNKRPT-CASE-NO)     AS BNKRPT_CASE_NO             
MFA-TR*             ,STRIP(:S-BKTCY-CHAPTER)      AS S_BKTCY_CHAPTER            
MFA-TR*             ,:S-DATE-BKTCY-FILED          AS DATE_BKTCY_FILED           
MFA-TR*             ,:S-INIT-BY                   AS INIT_BY                    
MFA-TR*             ,:S-RECEIVED-DATE             AS RECEIVED_DATE              
MFA-TR*         FROM                                                            
MFA-TR*              SESSION.CSR02194_R1                                        
MFA-TR*    END-EXEC.                                                            
P00936     PERFORM 0100B-DECLARE-GTT     THRU 0100B-EXIT.               
P00936*                                                                         
P00936     EXEC SQL                                                     
P00936          DECLARE C2 CURSOR  FOR                       
P00936          SELECT                                                  
P00936               RETURN_CODE                                        
P00936              ,LTRIM(RTRIM(NAME))                 AS NAME                
P00936              ,LTRIM(RTRIM(ACCT_TYPE_DESC))       AS 
           ACCT_TYPE_DESC      
P00936              ,ACCOUNT_NO                                         
P00936              ,CUSTOMER_NO                                        
P00936              ,LTRIM(RTRIM(ADDRESS))              AS ADDRESS             
P00936              ,BNKRPT_IND                                         
P00936              ,PREMISE_NO                                         
P00936              ,ACCT_TYPE                                          
P00936              ,CODE_ACCT_STAT                                     
P00936              ,ACCOUNT_BALANCE                                    
P00936              ,ACCT_CREATE_DT                                     
P00936          FROM                                                    
P00936               #CSR02194_R2                                
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C2 CURSOR WITH RETURN FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,STRIP(NAME)                 AS NAME                        
MFA-TR*             ,STRIP(ACCT_TYPE_DESC)       AS ACCT_TYPE_DESC              
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,CUSTOMER_NO                                                
MFA-TR*             ,STRIP(ADDRESS)              AS ADDRESS                     
MFA-TR*             ,BNKRPT_IND                                                 
MFA-TR*             ,PREMISE_NO                                                 
MFA-TR*             ,ACCT_TYPE                                                  
MFA-TR*             ,CODE_ACCT_STAT                                             
MFA-TR*             ,ACCOUNT_BALANCE                                            
MFA-TR*             ,ACCT_CREATE_DT                                             
MFA-TR*         FROM                                                            
MFA-TR*              SESSION.CSR02194_R2                                        
MFA-TR*    END-EXEC.                                                            
REARCH*                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00936******************************************************************        
P00936* 0100A-DECLARE-GTT                                              *        
P00936******************************************************************        
P00936 0100A-DECLARE-GTT.                                               
P00936*                                                                         
P00936     MOVE 'SESSION.CSR02194_R1'     TO WS-GTT-NAME.               
P00936                                                                  
P00936     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02194_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02194_R1
              (                                                       
P00936               RETURN_CODE         INT                        
P00936              ,FILED_CASE_NO CHAR(15)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
P00936              ,BNKRPT_CASE_NO CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
P00936              ,S_BKTCY_CHAPTER CHAR(02)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
P00936              ,DATE_BKTCY_FILED CHAR(08)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
P00936              ,INIT_BY CHAR(07)  COLLATE LATIN1_GENERAL_100_BIN2          
P00936              ,RECEIVED_DATE CHAR(08)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
P00936          )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00936*                                                                         
P00936     MOVE SQLSTATE                 TO WS-SQLSTATE.                
P00936     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
P00936*                                                                         
P00936     IF WS-SQLSTATE = '42710'                                     
P00936         PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT            
P00936     ELSE                                                         
P00936         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
P00936                NEXT SENTENCE                                     
P00936         ELSE                                                     
P00936            MOVE PROGRAM-NAME       TO ABEND-PROGRAM              
P00936            MOVE SQLCODE            TO ABEND-SQLCODE              
P00936            MOVE SQLSTATE           TO ABEND-SQLSTATE             
P00936            MOVE '0100A'            TO ACTIVE-PARAGRAPH           
P00936            MOVE 'DECLARE GTT'      TO ABEND-FUNCTION             
P00936            MOVE SPACES             TO ABEND-SQL-PREDICATES       
P00936                                       ABEND-TABLES               
P00936            MOVE 'CSR02194_R1'      TO TABLE-1                    
P00936            MOVE SPACES             TO TABLE-ELEMENT-1            
P00936            MOVE SPACES             TO HOSTVAR-ELEMENT-1          
P00936            PERFORM 9900-SQL-ERROR-ROUTINE                        
P00936                                    THRU  9900-EXIT               
P00936         END-IF                                                   
P00936     END-IF.                                                      
P00936*                                                                         
P00936 0100A-EXIT.                                                      
P00936     EXIT.                                                        
P00936******************************************************************        
P00936* 0100B-DECLARE-GTT                                              *        
P00936******************************************************************        
P00936 0100B-DECLARE-GTT.                                               
P00936*                                                                         
P00936     MOVE 'SESSION.CSR02194_R2'     TO WS-GTT-NAME.               
P00936                                                                  
P00936     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02194_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02194_R2
              (                                                       
P00936               RETURN_CODE         INT                        
P00936              ,NAME CHAR(77)  COLLATE LATIN1_GENERAL_100_BIN2             
P00936              ,ACCT_TYPE_DESC CHAR(25)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
P00936              ,ACCOUNT_NO CHAR(13)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
P00936              ,CUSTOMER_NO CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
P00936              ,ADDRESS CHAR(81)  COLLATE LATIN1_GENERAL_100_BIN2          
P00936              ,BNKRPT_IND CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
P00936              ,PREMISE_NO CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
P00936              ,ACCT_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
P00936              ,CODE_ACCT_STAT CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
P00936              ,ACCOUNT_BALANCE     DECIMAL(11,2)                  
P00936              ,ACCT_CREATE_DT CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
P00936          )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00936*                                                                         
P00936     MOVE SQLSTATE                 TO WS-SQLSTATE.                
P00936     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
P00936*                                                                         
P00936     IF WS-SQLSTATE = '42710'                                     
P00936         PERFORM 8000B-DELETE-GTT-ROWS THRU 8000B-EXIT            
P00936     ELSE                                                         
P00936         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
P00936                NEXT SENTENCE                                     
P00936         ELSE                                                     
P00936            MOVE PROGRAM-NAME       TO ABEND-PROGRAM              
P00936            MOVE SQLCODE            TO ABEND-SQLCODE              
P00936            MOVE SQLSTATE           TO ABEND-SQLSTATE             
P00936            MOVE '0100B'            TO ACTIVE-PARAGRAPH           
P00936            MOVE 'DECLARE GTT'      TO ABEND-FUNCTION             
P00936            MOVE SPACES             TO ABEND-SQL-PREDICATES       
P00936                                       ABEND-TABLES               
P00936            MOVE 'CSR02194_R2'      TO TABLE-1                    
P00936            MOVE SPACES             TO TABLE-ELEMENT-1            
P00936            MOVE SPACES             TO HOSTVAR-ELEMENT-1          
P00936            PERFORM 9900-SQL-ERROR-ROUTINE                        
P00936                                    THRU  9900-EXIT               
P00936         END-IF                                                   
P00936     END-IF.                                                      
P00936*                                                                         
P00936 0100B-EXIT.                                                      
P00936     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     CALLS 1100-RECEIVE-PARMS                                   *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
                                                                        
REARCH*1000-PROCESS-INPUT.                                                      
      *                                                                         
REARCH*    PERFORM 1100-RECEIVE-PARMS THRU 1100-EXIT.                           
REARCH*1000-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 1100-RECEIVE-PARMS                                             *        
      *     CALLS TDRCVPRM                                             *        
      *                                                                *        
      *     CALLED FROM 1000-PROCESS-INPUT                             *        
      *                                                                *        
      *     GET THE PASSED PARMS FROM THE CLIENT                       *        
      ******************************************************************        
                                                                        
REARCH*1100-RECEIVE-PARMS.                                                      
REARCH*                                                                         
REARCH*    MOVE 1                               TO PARM-ID1.                    
REARCH*    MOVE LENGTH OF PARM-ACCOUNT-NO       TO MAX-LENGTH-PARM.             
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-ACCOUNT-NO,                               
REARCH*                          TDSCHAR,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                         
REARCH*    ADD  1                               TO PARM-ID1.                    
REARCH*    MOVE LENGTH OF PARM-FILED-CASE-NO    TO MAX-LENGTH-PARM.             
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-FILED-CASE-NO,                            
REARCH*                          TDSCHAR,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                         
REARCH*1100-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     CALLS 2100-DESCRIBE-RESULT                                 *        
      *           2200-BUILD-RESULT-AT                                 *        
      *     CALLED FROM 0000-MAINLINE                                 *         
      *                                                                *        
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *        
      *      AND SENDS THEM BACK                                       *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                           TO ACTIVE-PARAGRAPH.   
REARCH*    PERFORM 2100-DESCRIBE-RESULT          THRU 2100-EXIT.                
           PERFORM 2200-BUILD-RESULT-DATA        THRU 2200-EXIT.        
P00936     PERFORM 2300-BUILD-RESULT-DATA        THRU 2300-EXIT.        
       2000-EXIT.                                                       
           EXIT.                                                        
REARCH*                                                                         
REARCH******************************************************************        
REARCH*2000A-MOVE-RESULT                                               *        
REARCH******************************************************************        
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH      MOVE RS-RETURN-CODE           TO S-RETURN-CODE.             
REARCH      MOVE RS-FILED-CASE-NO         TO S-FILED-CASE-NO.           
REARCH      MOVE RS-BNKRPT-CASE-NO        TO S-BNKRPT-CASE-NO.          
REARCH      MOVE RS-BKTCY-CHAPTER         TO S-BKTCY-CHAPTER.           
REARCH      MOVE RS-DATE-BKTCY-FILED      TO S-DATE-BKTCY-FILED.        
REARCH      MOVE RS-INIT-BY               TO S-INIT-BY.                 
REARCH      MOVE RS-RECEIVED-DATE         TO S-RECEIVED-DATE.           
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
P00936     EXIT.                                                        
                                                                        
P00936******************************************************************        
P00936*2000B-MOVE-RESULT                                               *        
P00936******************************************************************        
P00936 2000B-MOVE-RESULT.                                               
P00936*                                                                         
P00936     MOVE RS2-RETURN-CODE    TO S2-RETURN-CODE.                   
P00936     MOVE RS2-NAME           TO S2-NAME.                          
P00936     MOVE RS2-ACCT-TYPE-DESC TO S2-ACCT-TYPE-DESC.                
P00936     MOVE RS2-ACCOUNT-NO     TO S2-ACCOUNT-NO.                    
P00936     MOVE RS2-CUSTOMER-NO    TO S2-CUSTOMER-NO.                   
P00936     MOVE RS2-ADDRESS        TO S2-ADDRESS.                       
P00936     MOVE RS2-BNKRPT-IND     TO S2-BNKRPT-IND.                    
P00936     MOVE RS2-PREMISE-NO     TO S2-PREMISE-NO.                    
P00936     MOVE RS2-ACCT-TYPE      TO S2-ACCT-TYPE.                     
P00936     MOVE RS2-CODE-ACCT-STAT TO S2-CODE-ACCT-STAT.                
P00936     MOVE RS2-ACCOUNT-BALANCE TO S2-ACCOUNT-BALANCE.              
P00936     MOVE RS2-CREATE-DT       TO S2-CREATE-DT.                    
P00936*                                                                         
P00936 2000B-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-DESCRIBE-RESULT                                          *         
      *                                                               *         
      *     CALLS 2110-DESC-RET-CODE                                  *         
      *           2140-DESC-AT-DATA                                   *         
      *     CALLED FROM 2000-PROCESS-OUTPUT                           *         
      *                                                               *         
      *      DESCRIBE EACH RESULT FIELD TO THE CLIENT                 *         
      ******************************************************************        
                                                                        
REARCH*2100-DESCRIBE-RESULT.                                                    
                                                                        
REARCH*    MOVE '2110'                             TO ACTIVE-PARAGRAPH.         
REARCH*    PERFORM 2110-DESC-RET-CODE              THRU 2110-EXIT.              
REARCH*    PERFORM 2140-DESC-DATA                  THRU 2140-EXIT.              
REARCH*2100-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 2110-DESC-RET-CODE                                             *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE RET-CODE    FIELD TO THE CLIENT                   *        
      ******************************************************************        
                                                                        
REARCH*2110-DESC-RET-CODE.                                                      
REARCH*                                                                         
REARCH*    MOVE '2110'                       TO ACTIVE-PARAGRAPH.               
REARCH*    MOVE 1                            TO CTR-COLUMN.                     
REARCH*    MOVE TDSINT4                      TO DB-HOST-TYPE.                   
REARCH*    MOVE TDSINT4                      TO DB-CLIENT-TYPE.                 
REARCH*    MOVE LENGTH OF RS-RETURN-CODE     TO WRKLEN1.                        
REARCH*    MOVE LENGTH OF CNS-RETURN-CODE    TO WRKLEN2.                        
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-RETURN-CODE,                                
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-RETURN-CODE,                               
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*2110-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 2140-DESC-DATA                                                 *        
      *                                                                *        
      *     CALLS TDESCRIB                                             *        
      *           9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2100-DESCRIBE-RESULT                           *        
      *                                                                *        
      *     DESCRIBE BILLING HEADER RESULT FIELDS TO THE CLIENT        *        
      *                                                                *        
      ******************************************************************        
REARCH*                                                                         
REARCH*2140-DESC-DATA.                                                          
REARCH*                                                                         
REARCH*    MOVE '2140'                          TO ACTIVE-PARAGRAPH.            
REARCH*    ADD 1                                TO CTR-COLUMN.                  
REARCH*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
REARCH*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
REARCH*    MOVE LENGTH OF RS-FILED-CASE-NO      TO WRKLEN1.                     
REARCH*    MOVE LENGTH OF CNS-FILED-CASE-NO     TO WRKLEN2.                     
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-FILED-CASE-NO,                              
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-FILED-CASE-NO,                             
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD 1                                TO CTR-COLUMN.                  
REARCH*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
REARCH*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
REARCH*    MOVE LENGTH OF RS-BNKRPT-CASE-NO     TO WRKLEN1.                     
REARCH*    MOVE LENGTH OF CNS-BNKRPT-CASE-NO    TO WRKLEN2.                     
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-BNKRPT-CASE-NO,                             
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-BNKRPT-CASE-NO,                            
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD 1                                TO CTR-COLUMN.                  
REARCH*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
REARCH*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
REARCH*    MOVE LENGTH OF RS-BKTCY-CHAPTER      TO WRKLEN1.                     
REARCH*    MOVE LENGTH OF CNS-BKTCY-CHAPTER     TO WRKLEN2.                     
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-BKTCY-CHAPTER,                              
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-BKTCY-CHAPTER,                             
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD 1                                TO CTR-COLUMN.                  
REARCH*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
REARCH*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
REARCH*    MOVE LENGTH OF RS-DATE-BKTCY-FILED   TO WRKLEN1.                     
REARCH*    MOVE LENGTH OF CNS-DATE-BKTCY-FILED  TO WRKLEN2.                     
REARCH*                                                                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-DATE-BKTCY-FILED,                           
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-DATE-BKTCY-FILED,                          
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                            TO CTR-COLUMN.                     
REARCH*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
REARCH*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
REARCH*    MOVE LENGTH OF RS-INIT-BY         TO WRKLEN1.                        
REARCH*    MOVE LENGTH OF CNS-INIT-BY        TO WRKLEN2.                        
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-INIT-BY,                                    
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-INIT-BY,                                   
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                            TO CTR-COLUMN.                     
REARCH*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
REARCH*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
REARCH*    MOVE LENGTH OF RS-RECEIVED-DATE   TO WRKLEN1.                        
REARCH*    MOVE LENGTH OF CNS-RECEIVED-DATE  TO WRKLEN2.                        
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-RECEIVED-DATE,                              
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CNS-RECEIVED-DATE,                             
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*2140-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      *    2200-BUILD-RESULT-DATA                                      *        
      *                                                                *        
      *    CALLED FROM 2000-PROCESS-OUTPUT                             *        
      *                                                                *        
      *    OPENS AND CLOSES THE AT CURSOR                              *        
      ******************************************************************        
       2200-BUILD-RESULT-DATA.                                          
           MOVE '2200'       TO ACTIVE-PARAGRAPH.                       
                                                                        
           MOVE 'N' TO WS-CASE-NO-FOUND-FLAG.                           
                                                                        
TP5928     IF PARM-FILED-CASE-NO > SPACES                               
TP5928        PERFORM 2220-GET-CASE-FROM-BQ THRU 2220-EXIT              
TP5928     ELSE                                                         
TP5928        PERFORM 2210-GET-CASE-FROM-AT THRU 2210-EXIT              
TP5928     END-IF.                                                      
                                                                        
           IF CASE-NO-FOUND                                             
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 100 TO RS-RETURN-CODE                                
REARCH        PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT             
REARCH        ADD  +1                       TO CTR-ROWS                 
P00936        PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
              GO TO 2200-EXIT                                           
           END-IF.                                                      
                                                                        
           MOVE BQ-BNKRPT-CASE-NO     TO RS-BNKRPT-CASE-NO.             
           MOVE BQ-FILED-CASE-NO      TO RS-FILED-CASE-NO.              
           MOVE BQ-BANKRUPTCY-CHAPTER TO RS-BKTCY-CHAPTER.              
                                                                        
TP5788     MOVE BQ-DATE-BNKRPT-FILED  TO WS-DATE-FORMATTED.             
TP5788     MOVE WS-MONTH-FORMAT       TO WS-MONTH.                      
TP5788     MOVE WS-DAY-FORMAT         TO WS-DAY.                        
TP5788     MOVE WS-YEAR-FORMAT        TO WS-YEAR.                       
TP5788     MOVE WS-DATE-UNFORMATTED   TO RS-DATE-BKTCY-FILED.           
                                                                        
           MOVE BQ-USER-ID-INIT-BY    TO RS-INIT-BY.                    
                                                                        
TP5788     MOVE BQ-RECEIVED-DATE      TO WS-DATE-FORMATTED.             
TP5788     MOVE WS-MONTH-FORMAT       TO WS-MONTH.                      
TP5788     MOVE WS-DAY-FORMAT         TO WS-DAY.                        
TP5788     MOVE WS-YEAR-FORMAT        TO WS-YEAR.                       
TP5788     MOVE WS-DATE-UNFORMATTED   TO RS-RECEIVED-DATE.              
                                                                        
REARCH     PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT.                  
REARCH     ADD  +1                    TO CTR-ROWS.                      
P00936     PERFORM 8100-SEND-RESULT      THRU 8100-EXIT.                
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2210-GET-CASE-FROM-AT.                                           
           MOVE PARM-ACCOUNT-NO       TO WS-ACCOUNT-NO.                 
           MOVE WS-ACCOUNT-NO-NUM     TO AT-ACCOUNT-NO.                 
           PERFORM 7600-SELECT-AT-ROW   THRU 7600-EXIT.                 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              GO TO 2210-EXIT                                           
           END-IF.                                                      
                                                                        
           MOVE 'Y' TO WS-CASE-NO-FOUND-FLAG.                           
           MOVE AT-BNKRPT-CASE-NO TO BQ-BNKRPT-CASE-NO.                 
           PERFORM 7700-SELECT-BQ-ROW   THRU 7700-EXIT.                 
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2220-GET-CASE-FROM-BQ.                                           
           MOVE PARM-FILED-CASE-NO    TO BQ-FILED-CASE-NO.              
           PERFORM 7800-SELECT-BQ-ROW THRU 7800-EXIT.                   
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE 'Y' TO WS-CASE-NO-FOUND-FLAG                         
           END-IF.                                                      
       2220-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00936 2300-BUILD-RESULT-DATA.                                          
P00936     MOVE '2300'       TO ACTIVE-PARAGRAPH.                       
P00936                                                                  
P00936     MOVE BQ-BNKRPT-CASE-NO TO AT-BNKRPT-CASE-NO.                 
P00936                                                                  
P00936     PERFORM 7200-OPEN-AT-CRSR  THRU  7200-EXIT.                  
P00936     PERFORM 7210-FETCH-AT-CRSR  THRU  7210-EXIT.                 
P00936     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
P00936        MOVE WS-ACTIVE-RETURN-CODE TO RS2-RETURN-CODE             
P00936        MOVE PARM-ACCOUNT-NO       TO HT-ACCOUNT-NO               
P00936                                      AT-ACCOUNT-NO               
P00936                                      AC-ACCOUNT-NO               
P00936                                      CO-ACCOUNT-NO               
P00936        PERFORM 7830-GET-ACCT-DTLS       THRU 7830-EXIT           
P00936        MOVE AT-ACCT-CREATE-DT(1:10) TO RS2-CREATE-DT             
P00936        IF AT-CODE-ACCT-STAT EQUAL 'S'                            
P00936           PERFORM 2650-GET-WO-BALANCE THRU 2650-EXIT             
P00936        ELSE                                                      
P00936           PERFORM 2630-GET-ACCOUNT-BALANCE THRU 2630-EXIT        
P00936        END-IF                                                    
P00936        PERFORM 2000B-MOVE-RESULT    THRU 2000B-EXIT              
P00936        PERFORM 8200-SEND-RESULT     THRU 8200-EXIT               
P00936     ELSE                                                         
P00936        PERFORM 2310-PROCESS-AT-CRSR THRU 2310-EXIT               
P00936        UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
P00936     END-IF.                                                      
P00936     PERFORM 7220-CLOSE-AT-CRSR   THRU 7220-EXIT.                 
P00936                                                                  
P00936 2300-EXIT.                                                       
P00936     EXIT.                                                        
P00936                                                                  
P00936 2310-PROCESS-AT-CRSR.                                            
P00936     MOVE '2310'               TO ACTIVE-PARAGRAPH.               
P00936                                                                  
P00936     MOVE AT-ACCOUNT-NO        TO HT-ACCOUNT-NO                   
P00936                                  AC-ACCOUNT-NO                   
P00936                                  CO-ACCOUNT-NO                   
P00936                                  RS2-ACCOUNT-NO.                 
P00936     MOVE AT-PREMISE-NO        TO WS-PREMISE-NO.                  
P00936     MOVE AT-CUSTOMER-NO       TO HT-CUSTOMER-NO                  
P00936                                  RS2-CUSTOMER-NO.                
P00936     MOVE AT-BANKRUPTCY-IND    TO RS2-BNKRPT-IND.                 
ACT282     MOVE AT-ACCOUNT-TYPE-CODE TO SW-CODE-VALUE                   
P00936                                  RS2-ACCT-TYPE.                  
P00936     MOVE AT-CODE-ACCT-STAT    TO RS2-CODE-ACCT-STAT.             
P00936                                                                  
P00936     PERFORM 7610-SELECT-N9-ROW THRU 7610-EXIT.                   
P00936     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT282        MOVE SW-CODE-LONG-DESC        TO RS2-ACCT-TYPE-DESC       
P00936     ELSE                                                         
P00936        MOVE 'ACCOUNT TYPE NOT FOUND' TO RS2-ACCT-TYPE-DESC       
P00936     END-IF.                                                      
P00936                                                                  
P00936     PERFORM 2320-GET-NAME THRU 2320-EXIT.                        
P00936     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00936        MOVE HT-ADDRESS-ID          TO DY-ADDRESS-ID              
P00936        PERFORM 7400-SELECT-ADDR-FORM   THRU 7400-EXIT            
P00936        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
P00936           PERFORM 7410-SELECT-CITY        THRU 7410-EXIT         
P00936           PERFORM 2600-BUILD-ADDR-FORM    THRU 2600-EXIT         
P00936        ELSE                                                      
P00936           MOVE SPACES TO RS2-ADDRESS                             
P00936        END-IF                                                    
P00936     ELSE                                                         
P00936        MOVE SPACES TO RS2-ADDRESS                                
P00936     END-IF.                                                      
P00936                                                                  
P00936     PERFORM 7830-GET-ACCT-DTLS       THRU 7830-EXIT.             
P00936     MOVE AT-ACCT-CREATE-DT(1:10) TO RS2-CREATE-DT.               
P00936     IF AT-CODE-ACCT-STAT EQUAL 'S'                               
P00936        PERFORM 2650-GET-WO-BALANCE THRU 2650-EXIT                
P00936     ELSE                                                         
P00936        PERFORM 2630-GET-ACCOUNT-BALANCE THRU 2630-EXIT           
P00936     END-IF.                                                      
P00936     PERFORM 2000B-MOVE-RESULT     THRU 2000B-EXIT.               
P00936     PERFORM 8200-SEND-RESULT      THRU 8200-EXIT.                
P00936     PERFORM 7210-FETCH-AT-CRSR  THRU  7210-EXIT.                 
P00936 2310-EXIT.                                                       
P00936      EXIT.                                                       
P00936                                                                  
P00936 2320-GET-NAME.                                                   
P00936     PERFORM 7300-SELECT-DQ-ROW THRU 7300-EXIT.                   
P00936                                                                  
P00936     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00936     IF DQ-NAME-FORMAT = 'I'                                      
P00936        MOVE DQ-LAST-NAME TO WS-FROM                              
P00936         PERFORM 2510-PROCESS-FROM-STRING                         
P00936         MOVE WS-FROM TO DQ-LAST-NAME                             
P00936                                                                  
P00936         MOVE DQ-FIRST-NAME TO WS-FROM                            
P00936         PERFORM 2510-PROCESS-FROM-STRING                         
P00936         MOVE WS-FROM TO DQ-FIRST-NAME                            
P00936                                                                  
P00936         IF DQ-MIDDLE-NAME NOT = SPACE                            
P00936             MOVE DQ-MIDDLE-NAME TO WS-FROM                       
P00936             PERFORM 2510-PROCESS-FROM-STRING                     
P00936             MOVE WS-FROM TO DQ-MIDDLE-NAME                       
P00936         END-IF                                                   
P00936                                                                  
P00936         MOVE DQ-TITLE-SUFFIX-1 TO WS-FROM                        
P00936         PERFORM 2510-PROCESS-FROM-STRING                         
P00936         MOVE WS-FROM TO DQ-TITLE-SUFFIX-1                        
P00936                                                                  
P00936         IF DQ-MIDDLE-NAME = SPACE                                
P00936             STRING DQ-LAST-NAME DELIMITED CN-DELIMITER           
P00936                    ', ' DELIMITED SIZE                           
P00936                    DQ-FIRST-NAME DELIMITED CN-DELIMITER          
P00936                    ' ' DELIMITED SIZE                            
P00936                    DQ-TITLE-SUFFIX-1 DELIMITED CN-DELIMITER      
P00936               INTO RS2-NAME                                      
P00936             END-STRING                                           
P00936         ELSE                                                     
P00936             STRING DQ-LAST-NAME DELIMITED CN-DELIMITER           
P00936                    ', ' DELIMITED SIZE                           
P00936                    DQ-FIRST-NAME DELIMITED CN-DELIMITER          
P00936                    ' ' DELIMITED SIZE                            
P00936                    DQ-MIDDLE-NAME DELIMITED CN-DELIMITER         
P00936                    ' ' DELIMITED SIZE                            
P00936                    DQ-TITLE-SUFFIX-1 DELIMITED CN-DELIMITER      
P00936               INTO RS2-NAME                                      
P00936             END-STRING                                           
P00936         END-IF                                                   
P00936     ELSE                                                         
P00936         MOVE DQ-FULL-NAME     TO RS2-NAME                        
P00936     END-IF                                                       
P00936     ELSE                                                         
P00936        MOVE 'NAME NOT FOUND' TO RS2-NAME                         
P00936     END-IF.                                                      
P00936     MOVE RS2-NAME                      TO WS-EMB-INPUT.          
P00936     MOVE 77                           TO WS-EMB-LENG.            
P00936     MOVE SPACES                       TO WS-CMP-TABLE.           
P00936     PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT.          
P00936     MOVE WS-CMP-TABLE                 TO RS2-NAME.               
P00936 2320-EXIT.                                                       
P00936      EXIT.                                                       
P00936                                                                  
P00936************************************************************              
P00936* 2510-PROCESS-FROM-STRING                                 *              
P00936*                                                          *              
P00936* DETERMINE LENGTH OF FIELD. PLACE DELIMITER AFTER THE LAST*              
P00936* NON-SPACE CHARACTER TO BE USED LATER IN STRING STATEMENT.*              
P00936*                                                          *              
P00936************************************************************              
P00936                                                                  
P00936 2510-PROCESS-FROM-STRING.                                        
P00936                                                                  
P00936     PERFORM                                                      
P00936          VARYING WS-SUB FROM 51 BY -1                            
P00936          UNTIL WS-SUB < 1                                        
P00936          OR WS-FROM-X (WS-SUB) NOT = SPACE                       
P00936     END-PERFORM.                                                 
P00936     ADD 1             TO WS-SUB.                                 
P00936     MOVE CN-DELIMITER TO WS-FROM-X (WS-SUB).                     
P00936                                                                  
P00936 2510-EXIT.                                                       
P00936     EXIT.                                                        
HPCCDM*    EJECT                                                                
P00936*****************************************************************         
P00936* 2600-BUILD-ADDR-FORM                                          *         
P00936*                                                               *         
P00936*      CONCATENATE ALL ADDRESS DETAILS INTO A SINGLE            *         
P00936*      STRING TO BE SENT AS RESULT SET                          *         
P00936*****************************************************************         
P00936                                                                  
P00936 2600-BUILD-ADDR-FORM.                                            
P00936                                                                  
P00936     MOVE SPACE TO WS-ADDRESS.                                    
P00936     SET WS-ADD-SUB TO 1.                                         
P00936     MOVE +1     TO WS-ADD-SUB-CNT.                               
P00936                                                                  
P00936     IF DY-ADDR-USAGE-CD = 'I'                                    
P00936         MOVE DY-STREET-NAME           TO WS-FROM                 
P00936         MOVE LENGTH OF DY-STREET-NAME TO WS-MAX-SZ               
P00936         PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT      
P00936                                                                  
P00936         MOVE '&' TO WS-FROM                                      
P00936         MOVE 1   TO WS-MAX-SZ                                    
P00936         PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT      
P00936                                                                  
P00936         MOVE DY-ADDRESS-OVERFLOW           TO WS-FROM            
P00936         MOVE LENGTH OF DY-ADDRESS-OVERFLOW TO WS-MAX-SZ          
P00936         PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT      
P00936     ELSE                                                         
P00936         MOVE SPACE TO WS-ADDRESS                                 
P00936         SET WS-ADD-SUB TO 1                                      
P00936                                                                  
P00936         IF DY-HOUSE-NO NOT = SPACE                               
P00936             MOVE DY-HOUSE-NO           TO WS-FROM                
P00936             MOVE LENGTH OF DY-HOUSE-NO TO WS-MAX-SZ              
P00936             PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT  
P00936         END-IF                                                   
P00936                                                                  
P00936         IF DY-ADDR-PREFIX-1 NOT = SPACE                          
P00936             MOVE DY-ADDR-PREFIX-1           TO WS-FROM           
P00936             MOVE LENGTH OF DY-ADDR-PREFIX-1 TO WS-MAX-SZ         
P00936             PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT  
P00936         END-IF                                                   
P00936                                                                  
P00936         IF DY-ADDR-PREFIX-2 NOT = SPACE                          
P00936             MOVE DY-ADDR-PREFIX-2           TO WS-FROM           
P00936             MOVE LENGTH OF DY-ADDR-PREFIX-2 TO WS-MAX-SZ         
P00936             PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT  
P00936         END-IF                                                   
P00936                                                                  
P00936         IF DY-STREET-NAME NOT = SPACE                            
P00936             MOVE DY-STREET-NAME           TO WS-FROM             
P00936             MOVE LENGTH OF DY-STREET-NAME TO WS-MAX-SZ           
P00936             PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT  
P00936         END-IF                                                   
P00936                                                                  
P00936         IF DY-STREET-SUFFIX NOT = SPACE                          
P00936             MOVE DY-STREET-SUFFIX           TO WS-FROM           
P00936             MOVE LENGTH OF DY-STREET-SUFFIX TO WS-MAX-SZ         
P00936             PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT  
P00936         END-IF                                                   
P00936                                                                  
P00936         IF DY-STREET-LOCATION-1 NOT = SPACE                      
P00936             MOVE DY-STREET-LOCATION-1           TO WS-FROM       
P00936             MOVE LENGTH OF DY-STREET-LOCATION-1 TO WS-MAX-SZ     
P00936             PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT  
P00936         END-IF                                                   
P00936                                                                  
P00936         IF DY-STREET-LOCATION-2 NOT = SPACE                      
P00936             MOVE DY-STREET-LOCATION-2           TO WS-FROM       
P00936             MOVE LENGTH OF DY-STREET-LOCATION-2 TO WS-MAX-SZ     
P00936             PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT  
P00936         END-IF                                                   
P00936                                                                  
P00936         IF A4-TOWN  NOT = SPACE                                  
P00936             MOVE A4-TOWN                        TO WS-FROM       
P00936             MOVE LENGTH OF A4-TOWN              TO WS-MAX-SZ     
P00936             PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT  
P00936             MOVE ','                            TO WS-FROM       
P00936             MOVE 1                              TO WS-MAX-SZ     
P00936             PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT  
P00936         END-IF                                                   
P00936                                                                  
P00936         IF A4-STATE NOT = SPACE                                  
P00936             MOVE A4-STATE                       TO WS-FROM       
P00936             MOVE LENGTH OF A4-STATE             TO WS-MAX-SZ     
P00936             PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT  
P00936         END-IF                                                   
P00936                                                                  
P00936         IF DY-ZIP-CODE NOT = SPACE                               
P00936             MOVE DY-ZIP-CODE                    TO WS-FROM       
P00936             MOVE LENGTH OF DY-ZIP-CODE          TO WS-MAX-SZ     
P00936             PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT  
P00936         END-IF                                                   
P00936     END-IF.                                                      
P00936                                                                  
P00936*    MOVE WS-ADDRESS           TO RS-ADDRESS.                             
P00936                                                                  
P00936     MOVE WS-ADDRESS           TO WS-EMB-INPUT.                   
P00936     MOVE 81                   TO WS-EMB-LENG.                    
P00936     MOVE SPACES               TO WS-CMP-TABLE.                   
P00936     PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT.          
P00936     MOVE WS-CMP-TABLE         TO RS2-ADDRESS.                    
P00936 2600-EXIT.                                                       
P00936     EXIT.                                                        
P00936                                                                  
P00936*****************************************************************         
P00936* 2610-BUILD-ADDR-FREE                                          *         
P00936*                                                               *         
P00936*      CONCATENATE ALL ADDRESS DETAILS INTO A SINGLE            *         
P00936*      STRING TO BE SENT AS RESULT SET                          *         
P00936*****************************************************************         
P00936                                                                  
P00936 2610-BUILD-ADDR-FREE.                                            
P00936                                                                  
P00936     MOVE SPACE TO WS-ADDRESS.                                    
P00936     SET WS-ADD-SUB TO 1.                                         
P00936                                                                  
P00936     IF DZ-ADDR-STREET NOT = SPACE                                
P00936        MOVE DZ-ADDR-STREET           TO WS-FROM                  
P00936        MOVE LENGTH OF DZ-ADDR-STREET TO WS-MAX-SZ                
P00936        PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT       
P00936     END-IF.                                                      
P00936                                                                  
P00936     IF DZ-ADDR-CITY-STATE NOT = SPACE                            
P00936        MOVE DZ-ADDR-CITY-STATE           TO WS-FROM              
P00936        MOVE LENGTH OF DZ-ADDR-CITY-STATE TO WS-MAX-SZ            
P00936        PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT       
P00936     END-IF.                                                      
P00936                                                                  
P00936     IF DZ-ADDR-ZIP-CODE NOT = SPACE                              
P00936        MOVE DZ-ADDR-ZIP-CODE             TO WS-FROM              
P00936        MOVE LENGTH OF DZ-ADDR-ZIP-CODE   TO WS-MAX-SZ            
P00936        PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT       
P00936     END-IF.                                                      
P00936                                                                  
P00936     IF DZ-ADDR-COUNTRY    NOT = SPACE                            
P00936        MOVE DZ-ADDR-COUNTRY              TO WS-FROM              
P00936        MOVE LENGTH OF DZ-ADDR-COUNTRY    TO WS-MAX-SZ            
P00936        PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT       
P00936     END-IF.                                                      
P00936                                                                  
P00936     IF DZ-ADDRESS-OVERFLOW NOT = SPACE                           
P00936        MOVE DZ-ADDRESS-OVERFLOW           TO WS-FROM             
P00936        MOVE LENGTH OF DZ-ADDRESS-OVERFLOW TO WS-MAX-SZ           
P00936        PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT       
P00936     END-IF.                                                      
P00936                                                                  
P00936     MOVE WS-ADDRESS           TO RS2-ADDRESS.                    
P00936                                                                  
P00936 2610-EXIT.                                                       
P00936     EXIT.                                                        
P00936                                                                  
P00936                                                                  
P00936******************************************************************        
P00936* 2620-ACCUMULATE-ADDRESS                                        *        
P00936*                                                                *        
P00936*     DETERMINE LENGTH OF FIELD. MOVE THAT MANY CHARACTERS ON TO *        
P00936*     THE FORMATTED ADDRESS FIELD.                               *        
P00936*                                                                *        
P00936******************************************************************        
P00936                                                                  
P00936 2620-ACCUMULATE-ADDRESS.                                         
P00936                                                                  
P00936     PERFORM                                                      
P00936         VARYING WS-LENGTH FROM WS-MAX-SZ BY -1                   
P00936           UNTIL WS-LENGTH < 1                                    
P00936              OR WS-FROM-X (WS-LENGTH) NOT = SPACE                
P00936     END-PERFORM.                                                 
P00936                                                                  
P00936     PERFORM                                                      
P00936         VARYING WS-SUB FROM 1 BY 1                               
P00936*          UNTIL WS-SUB > WS-LENGTH OR WS-ADD-SUB-CNT = 50                
P00936           UNTIL WS-SUB > WS-LENGTH OR WS-ADD-SUB-CNT = 81        
P00936             MOVE WS-FROM-X (WS-SUB)                              
P00936                  TO WS-ADDRESS-X (WS-ADD-SUB)                    
P00936             SET WS-ADD-SUB UP BY 1                               
P00936             ADD +1    TO WS-ADD-SUB-CNT                          
P00936     END-PERFORM.                                                 
P00936                                                                  
P00936     SET WS-ADD-SUB UP BY 1.                                      
P00936     ADD +1    TO WS-ADD-SUB-CNT.                                 
P00936                                                                  
P00936 2620-EXIT.                                                       
P00936     EXIT.                                                        
P00936*                                                                         
P00936 2630-GET-ACCOUNT-BALANCE.                                        
P00936*                                                                         
P00936     PERFORM 7810-GET-FULL-BALANCE-A  THRU 7810-EXIT.             
P00936     PERFORM 7820-GET-FULL-BALANCE-B  THRU 7820-EXIT.             
P00936     COMPUTE RS2-ACCOUNT-BALANCE = WS-FULL-BALANCE-A +            
P00936                                   WS-FULL-BALANCE-B.             
P00936*                                                                         
P00936 2630-EXIT.                                                       
P00936     EXIT.                                                        
P00936*                                                                         
P00936 2650-GET-WO-BALANCE.                                             
P00936*                                                                         
P00936     PERFORM 7850-WO-FULL-BALANCE THRU 7850-EXIT.                 
P00936     COMPUTE RS2-ACCOUNT-BALANCE = CO-AMT-TRANS +                 
P00936                                   AT-TOTAL-AR-BALANCE.           
P00936*                                                                         
P00936 2650-EXIT.                                                       
P00936     EXIT.                                                        
P00936*                                                                         
P00936*                                                                         
P00936 7200-OPEN-AT-CRSR.                                               
P00936     MOVE '7200'                          TO ACTIVE-PARAGRAPH.    
P00936******************************************************************04400001
P00936*  OPEN THE CURSOR DECLARED FOR CSS_ACCOUNT TABLE                *04420001
P00936******************************************************************04450001
P00936     EXEC SQL                                                     
P00936         OPEN AT_CRSR                                             
P00936     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00936*                                                                 04490001
P00936     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00936*                                                                 04510001
P00936     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00936           NEXT SENTENCE                                          
P00936       ELSE                                                       
P00936         MOVE 'CSR02194'              TO ABEND-PROGRAM            
P00936         MOVE '7200'                  TO ACTIVE-PARAGRAPH         
P00936         MOVE 'OPEN'                  TO ABEND-FUNCTION           
P00936         MOVE 'CSS_ACCOUNT'           TO TABLE-1                  
P00936         MOVE 'BNKRPT_CASE_NO'        TO TABLE-ELEMENT-1          
P00936         MOVE AT-BNKRPT-CASE-NO       TO HOSTVAR-ELEMENT-1        
P00936         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
P00936         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
P00936 7200-EXIT.                                                       
P00936     EXIT.                                                        
P00936*                                                                 04681001
P00936******************************************************************04710001
P00936*  FETCH THE CURSOR DECLARED FOR CSS_CUST_PLAN    TABLE.         *04730001
P00936******************************************************************04770001
P00936 7210-FETCH-AT-CRSR.                                              
P00936     MOVE '7210'   TO ACTIVE-PARAGRAPH.                           
P00936                                                                  
P00936     EXEC SQL                                                     
P00936         FETCH AT_CRSR                                            
P00936         INTO :AT-ACCOUNT-NO,                                     
P00936              :AT-BANKRUPTCY-IND,                                 
P00936              :AT-CUSTOMER-NO,                                    
P00936              :AT-PREMISE-NO,                                     
P00936              :AT-ADDRESS-FORMAT,                                 
P00936              :AT-ACCOUNT-TYPE-CODE,                              
P00936              :AT-CODE-ACCT-STAT                                  
P00936     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00936*                                                                 04990001
P00936     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00936*                                                                 05010001
P00936     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
P00936                                    NOT-FOUND                     
P00936           NEXT SENTENCE                                          
P00936       ELSE                                                       
P00936         MOVE 'CSR02194'              TO ABEND-PROGRAM            
P00936         MOVE '7210'                  TO ACTIVE-PARAGRAPH         
P00936         MOVE 'FETCH'                 TO ABEND-FUNCTION           
P00936         MOVE 'CSS_ACCOUNT'           TO TABLE-1                  
P00936         MOVE 'BNKRPT_CASE_NO'        TO TABLE-ELEMENT-1          
P00936         MOVE AT-BNKRPT-CASE-NO       TO HOSTVAR-ELEMENT-1        
P00936         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
P00936         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
P00936 7210-EXIT.                                                       
P00936     EXIT.                                                        
P00936*                                                                 05170001
P00936 7220-CLOSE-AT-CRSR.                                              
P00936     MOVE '7220'                          TO ACTIVE-PARAGRAPH.    
P00936******************************************************************05190001
P00936*                                                                *05200001
P00936*  CLOSE THE CURSOR DECLARED FOR CSS_CUST_PLAN TABLE.            *05210001
P00936******************************************************************05250001
P00936     EXEC SQL                                                     
P00936         CLOSE AT_CRSR                                            
P00936     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00936*                                                                 05290001
P00936     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00936*                                                                 05310001
P00936     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00936           NEXT SENTENCE                                          
P00936       ELSE                                                       
P00936         MOVE 'CSR02194'              TO ABEND-PROGRAM            
P00936         MOVE '7220'                  TO ACTIVE-PARAGRAPH         
P00936         MOVE 'CLOSE'                 TO ABEND-FUNCTION           
P00936         MOVE 'CSS_ACCOUNT'           TO TABLE-1                  
P00936         MOVE 'BNKRPT_CASE_NO'        TO TABLE-ELEMENT-1          
P00936         MOVE AT-BNKRPT-CASE-NO       TO HOSTVAR-ELEMENT-1        
P00936         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
P00936         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
P00936 7220-EXIT.                                                       
P00936     EXIT.                                                        
P00936*                                                                 05471001
HPCCDM*EJECT                                                                    
P00936******************************************************************        
P00936*   7300-SELECT-DQ-ROW.                                          *        
P00936*                                                                *        
P00936*   THIS PARAGRAPH IS USED TO OBTAIN THE SELECTED ROW FROM THE   *        
P00936*   CSS_NAME TABLE                                            *           
P00936******************************************************************        
P00936 7300-SELECT-DQ-ROW.                                              
P00936     MOVE '7300'                          TO ACTIVE-PARAGRAPH.    
P00936                                                                  
P00936     EXEC SQL                                                     
P00936       SELECT  DQ.FULL_NAME,                                      
P00936               DQ.NAME_FORMAT,                                    
P00936               DQ.LAST_NAME,                                      
P00936               DQ.FIRST_NAME,                                     
P00936               DQ.MIDDLE_NAME,                                    
P00936               DQ.TITLE_PREFIX,                                   
P00936               DQ.TITLE_SUFFIX_1,                                 
P00936               DQ.TITLE_SUFFIX_2,                                 
P00936               HT.ADDRESS_ID                                      
P00936         INTO  :DQ-FULL-NAME,                                     
P00936               :DQ-NAME-FORMAT,                                   
P00936               :DQ-LAST-NAME,                                     
P00936               :DQ-FIRST-NAME,                                    
P00936               :DQ-MIDDLE-NAME,                                   
P00936               :DQ-TITLE-PREFIX,                                  
P00936               :DQ-TITLE-SUFFIX-1,                                
P00936               :DQ-TITLE-SUFFIX-2,                                
P00936               :HT-ADDRESS-ID                                     
P00936         FROM  CSS_NAME DQ WITH(READUNCOMMITTED),                         
P00936               CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)                
P00936        WHERE  HT.ACCOUNT_NO       = :HT-ACCOUNT-NO               
P00936          AND  HT.NAME_ID          = DQ.NAME_ID                   
P00936          AND  HT.CUSTOMER_ROLE_CD = ' '                          
P00936          AND  DQ.NAME_TYPE        = 'CN'                         
P00936                                                           
P00936     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  DQ.FULL_NAME,                                              
MFA-TR*              DQ.NAME_FORMAT,                                            
MFA-TR*              DQ.LAST_NAME,                                              
MFA-TR*              DQ.FIRST_NAME,                                             
MFA-TR*              DQ.MIDDLE_NAME,                                            
MFA-TR*              DQ.TITLE_PREFIX,                                           
MFA-TR*              DQ.TITLE_SUFFIX_1,                                         
MFA-TR*              DQ.TITLE_SUFFIX_2,                                         
MFA-TR*              HT.ADDRESS_ID                                              
MFA-TR*        INTO  :DQ-FULL-NAME,                                             
MFA-TR*              :DQ-NAME-FORMAT,                                           
MFA-TR*              :DQ-LAST-NAME,                                             
MFA-TR*              :DQ-FIRST-NAME,                                            
MFA-TR*              :DQ-MIDDLE-NAME,                                           
MFA-TR*              :DQ-TITLE-PREFIX,                                          
MFA-TR*              :DQ-TITLE-SUFFIX-1,                                        
MFA-TR*              :DQ-TITLE-SUFFIX-2,                                        
MFA-TR*              :HT-ADDRESS-ID                                             
MFA-TR*        FROM  CSS_NAME DQ,                                               
MFA-TR*              CSS_NAME_ACCT_XREF HT                                      
MFA-TR*       WHERE  HT.ACCOUNT_NO       = :HT-ACCOUNT-NO                       
MFA-TR*         AND  HT.NAME_ID          = DQ.NAME_ID                           
MFA-TR*         AND  HT.CUSTOMER_ROLE_CD = ' '                                  
MFA-TR*         AND  DQ.NAME_TYPE        = 'CN'                                 
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00936*                                                                         
P00936     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P00936*                                                                         
P00936     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00936                                 OR NOT-FOUND                     
P00936         NEXT SENTENCE                                            
P00936     ELSE                                                         
P00936        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
P00936        MOVE 'SELECT'             TO ABEND-FUNCTION               
P00936        MOVE 'CSS_NAME'           TO TABLE-1                      
P00936        MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-2                      
P00936        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
P00936        MOVE HT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
P00936        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00936        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00936     END-IF.                                                      
P00936 7300-EXIT.                                                       
P00936     EXIT.                                                        
HPCCDM*EJECT                                                                    
P00936                                                                  
P00936****************************************************************          
P00936* 7400-SELECT-ADDR-FORM                                        *          
P00936*                                                              *          
P00936*      SELECT FROMATTED ADDRESS FOR THE ACCOUNT                *          
P00936****************************************************************          
P00936                                                                  
P00936 7400-SELECT-ADDR-FORM.                                           
P00936                                                                  
P00936     EXEC SQL                                                     
P00936         SELECT HOUSE_NO,                                         
P00936                ADDR_PREFIX_1,                                    
P00936                ADDR_PREFIX_2,                                    
P00936                STREET_NAME,                                      
P00936                ADDRESS_OVERFLOW,                                 
P00936                ADDR_USAGE_CD,                                    
P00936                STREET_SUFFIX,                                    
P00936                STREET_LOCATION_1,                                
P00936                STREET_LOCATION_2,                                
P00936                ZIP_CODE,                                         
P00936                ZIP_CODE_TOKEN                                    
P00936         INTO   :DY-HOUSE-NO,                                     
P00936                :DY-ADDR-PREFIX-1,                                
P00936                :DY-ADDR-PREFIX-2,                                
P00936                :DY-STREET-NAME,                                  
P00936                :DY-ADDRESS-OVERFLOW,                             
P00936                :DY-ADDR-USAGE-CD,                                
P00936                :DY-STREET-SUFFIX,                                
P00936                :DY-STREET-LOCATION-1,                            
P00936                :DY-STREET-LOCATION-2,                            
P00936                :DY-ZIP-CODE,                                     
P00936                :DY-ZIP-CODE-TOKEN                                
P00936           FROM CSS_ADDR_FORMATTED WITH(READUNCOMMITTED)                  
P00936          WHERE ADDRESS_ID = :DY-ADDRESS-ID                       
P00936                                                           
P00936     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT HOUSE_NO,                                                 
MFA-TR*               ADDR_PREFIX_1,                                            
MFA-TR*               ADDR_PREFIX_2,                                            
MFA-TR*               STREET_NAME,                                              
MFA-TR*               ADDRESS_OVERFLOW,                                         
MFA-TR*               ADDR_USAGE_CD,                                            
MFA-TR*               STREET_SUFFIX,                                            
MFA-TR*               STREET_LOCATION_1,                                        
MFA-TR*               STREET_LOCATION_2,                                        
MFA-TR*               ZIP_CODE,                                                 
MFA-TR*               ZIP_CODE_TOKEN                                            
MFA-TR*        INTO   :DY-HOUSE-NO,                                             
MFA-TR*               :DY-ADDR-PREFIX-1,                                        
MFA-TR*               :DY-ADDR-PREFIX-2,                                        
MFA-TR*               :DY-STREET-NAME,                                          
MFA-TR*               :DY-ADDRESS-OVERFLOW,                                     
MFA-TR*               :DY-ADDR-USAGE-CD,                                        
MFA-TR*               :DY-STREET-SUFFIX,                                        
MFA-TR*               :DY-STREET-LOCATION-1,                                    
MFA-TR*               :DY-STREET-LOCATION-2,                                    
MFA-TR*               :DY-ZIP-CODE,                                             
MFA-TR*               :DY-ZIP-CODE-TOKEN                                        
MFA-TR*          FROM CSS_ADDR_FORMATTED                                        
MFA-TR*         WHERE ADDRESS_ID = :DY-ADDRESS-ID                               
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00936                                                                  
P00936     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00936                                                                  
P00936     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00936                                   OR NOT-FOUND                   
P00936        NEXT SENTENCE                                             
P00936     ELSE                                                         
P00936        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
P00936        MOVE '7400'               TO ACTIVE-PARAGRAPH             
P00936        MOVE 'SELECT'             TO ABEND-FUNCTION               
P00936        MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                      
P00936        MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
P00936        MOVE DY-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
P00936        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00936        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00936     END-IF.                                                      
P00936                                                                  
P00936 7400-EXIT.                                                       
P00936     EXIT.                                                        
P00936                                                                  
P00936****************************************************************          
P00936* 7450-SELECT-ADDR-FREE                                        *          
P00936*                                                              *          
P00936*      SELECT FREE FORM ADDRESS FOR THE ACCOUNT                *          
P00936****************************************************************          
P00936                                                                  
P00936 7450-SELECT-ADDR-FREE.                                           
P00936                                                                  
P00936     EXEC SQL                                                     
P00936         SELECT ADDR_STREET, ADDR_CITY_STATE, ADDR_ZIP_CODE,      
P00936                ADDR_COUNTRY, ADDRESS_OVERFLOW                    
P00936         INTO   :DZ-ADDR-STREET, :DZ-ADDR-CITY-STATE,             
P00936                :DZ-ADDR-ZIP-CODE, :DZ-ADDR-COUNTRY,              
P00936                :DZ-ADDRESS-OVERFLOW                              
P00936           FROM CSS_ADDR_FREEFORM WITH(READUNCOMMITTED)                   
P00936          WHERE ADDRESS_ID = :DZ-ADDRESS-ID                       
P00936                                                           
P00936     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ADDR_STREET, ADDR_CITY_STATE, ADDR_ZIP_CODE,              
MFA-TR*               ADDR_COUNTRY, ADDRESS_OVERFLOW                            
MFA-TR*        INTO   :DZ-ADDR-STREET, :DZ-ADDR-CITY-STATE,                     
MFA-TR*               :DZ-ADDR-ZIP-CODE, :DZ-ADDR-COUNTRY,                      
MFA-TR*               :DZ-ADDRESS-OVERFLOW                                      
MFA-TR*          FROM CSS_ADDR_FREEFORM                                         
MFA-TR*         WHERE ADDRESS_ID = :DZ-ADDRESS-ID                               
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00936                                                                  
P00936     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00936                                                                  
P00936     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00936                                   OR NOT-FOUND                   
P00936        NEXT SENTENCE                                             
P00936     ELSE                                                         
P00936        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
P00936        MOVE '7450'               TO ACTIVE-PARAGRAPH             
P00936        MOVE 'SELECT'             TO ABEND-FUNCTION               
P00936        MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-1                      
P00936        MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
P00936        MOVE DZ-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
P00936        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00936        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00936     END-IF.                                                      
P00936                                                                  
P00936 7450-EXIT.                                                       
P00936     EXIT.                                                        
P00936                                                                  
P00936******************************************************************        
P00936* 7410-SELECT-CITY                                               *        
P00936*                                                                *        
P00936*     GET CITY BASED ON ZIP CODE & TOKEN.                        *        
P00936*                                                                *        
P00936******************************************************************        
P00936                                                                  
P00936 7410-SELECT-CITY.                                                
P00936                                                                  
P00936     EXEC SQL                                                     
P00936         SELECT TOWN,                                             
P00936                STATE                                             
P00936           INTO :A4-TOWN                                          
P00936               ,:A4-STATE                                         
P00936           FROM CSS_ZIP_CODE WITH(READUNCOMMITTED)                        
P00936          WHERE ZIP_CODE       = :DY-ZIP-CODE                     
P00936            AND ZIP_CODE_TOKEN = :DY-ZIP-CODE-TOKEN               
P00936                                                           
P00936     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT TOWN,                                                     
MFA-TR*               STATE                                                     
MFA-TR*          INTO :A4-TOWN                                                  
MFA-TR*              ,:A4-STATE                                                 
MFA-TR*          FROM CSS_ZIP_CODE                                              
MFA-TR*         WHERE ZIP_CODE       = :DY-ZIP-CODE                             
MFA-TR*           AND ZIP_CODE_TOKEN = :DY-ZIP-CODE-TOKEN                       
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00936                                                                  
P00936     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00936                                                                  
P00936     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00936         NEXT SENTENCE                                            
P00936     ELSE                                                         
P00936         IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
P00936             MOVE SPACE TO A4-TOWN                                
P00936         ELSE                                                     
P00936             MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
P00936             MOVE '7410'                 TO ACTIVE-PARAGRAPH      
P00936             MOVE 'SELECT'               TO ABEND-FUNCTION        
P00936             MOVE 'CSS_ZIP_CODE'         TO TABLE-1               
P00936             MOVE 'ZIP_CODE'             TO TABLE-ELEMENT-1       
P00936             MOVE 'ZIP_CODE_TOKEN'       TO TABLE-ELEMENT-2       
P00936             MOVE DY-ZIP-CODE            TO HOSTVAR-ELEMENT-1     
P00936             MOVE DY-ZIP-CODE-TOKEN      TO HOSTVAR-ELEMENT-2     
P00936             PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
P00936             PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
P00936         END-IF                                                   
P00936     END-IF.                                                      
P00936                                                                  
P00936 7410-EXIT.                                                       
P00936     EXIT.                                                        
P00936                                                                  
P00936******************************************************************        
P00936*   7610-SELECT-N9-ROW.                                          *        
P00936*                                                                *        
P00936*   THIS PARAGRAPH IS USED TO OBTAIN THE SELECTED ROW FROM THE   *        
ACT282*   CSS_SO_CODE_DESC TABLE *                                              
P00936******************************************************************        
P00936 7610-SELECT-N9-ROW.                                              
P00936     MOVE '7600'                          TO ACTIVE-PARAGRAPH.    
P00936                                                                  
P00936     EXEC SQL                                                     
ACT282        SELECT TOP(1) CODE_LONG_DESC                                    
ACT282          INTO :SW-CODE-LONG-DESC                                 
ACT282          FROM CSS_SO_CODE_DESC SW WITH(READUNCOMMITTED)                  
ACT282         WHERE TABLE_NA   = 'CSS_ACCOUNT'                         
ACT282           AND COLUMN_NA  = 'ACCOUNT_TYPE_CODE'                   
ACT282           AND PROGRAM_ID = 'ALL'                                 
ACT282           AND COMPANY_NO = '01'                                  
ACT282           AND CODE_VALUE = :SW-CODE-VALUE                        
ACT282                                           
P00936                                                           
P00936     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  CODE_LONG_DESC                                            
MFA-TR*         INTO :SW-CODE-LONG-DESC                                         
MFA-TR*         FROM CSS_SO_CODE_DESC SW                                        
MFA-TR*        WHERE TABLE_NA   = 'CSS_ACCOUNT'                                 
MFA-TR*          AND COLUMN_NA  = 'ACCOUNT_TYPE_CODE'                           
MFA-TR*          AND PROGRAM_ID = 'ALL'                                         
MFA-TR*          AND COMPANY_NO = '01'                                          
MFA-TR*          AND CODE_VALUE = :SW-CODE-VALUE                                
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00936*                                                                         
P00936     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P00936*                                                                         
P00936     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00936                                 OR NOT-FOUND                     
P00936         NEXT SENTENCE                                            
P00936     ELSE                                                         
P00936        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
P00936        MOVE 'SELECT'             TO ABEND-FUNCTION               
ACT282        MOVE 'CSS_SO_CODE_DESC'    TO TABLE-1                     
ACT282        MOVE 'TABLE_NA'            TO TABLE-ELEMENT-1             
ACT282        MOVE 'COLUMN_NA'           TO TABLE-ELEMENT-2             
ACT282        MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-3             
ACT282        MOVE 'CODE_VALUE'          TO TABLE-ELEMENT-4             
ACT282        MOVE 'CSS_ACCOUNT'         TO HOSTVAR-ELEMENT-1           
ACT282        MOVE 'ACCOUNT_TYPE_CODE'   TO HOSTVAR-ELEMENT-2           
ACT282        MOVE '01'                  TO HOSTVAR-ELEMENT-3           
ACT282        MOVE SW-CODE-VALUE         TO HOSTVAR-ELEMENT-4           
P00936        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00936        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00936     END-IF.                                                      
P00936 7610-EXIT.                                                       
P00936     EXIT.                                                        
HPCCDM*EJECT                                                                    
      ******************************************************************        
      *   7600-SELECT-AT-ROW.                                          *        
      *                                                                *        
      *   THIS PARAGRAPH IS USED TO OBTAIN THE SELECTED ROW FROM THE   *        
      *   CSS_ACCOUNT TABLE                                            *        
      ******************************************************************        
       7600-SELECT-AT-ROW.                                              
           MOVE '7600'         TO ACTIVE-PARAGRAPH.                     
                                                                        
           EXEC SQL                                                     
             SELECT  BNKRPT_CASE_NO                                     
               INTO  :AT-BNKRPT-CASE-NO                                 
               FROM  CSS_ACCOUNT                                        
              WHERE  ACCOUNT_NO     = :AT-ACCOUNT-NO                    
              AND  (BANKRUPTCY_IND   = 'B'                              
              OR   BANKRUPTCY_IND   = 'J')                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                       OR NOT-FOUND                     
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
CBSI          MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCOUNT      '   TO TABLE-1                     
              MOVE 'ACCOUNT_NO  '        TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
CBSI          PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7600-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
                                                                        
      ******************************************************************        
      *   7700-SELECT-BQ-ROW.                                          *        
      *                                                                *        
      *   THIS PARAGRAPH IS USED TO OBTAIN THE SELECTED ROW FROM THE   *        
      *   CSS_BANKRUPTCY TABLE                                         *        
      ******************************************************************        
       7700-SELECT-BQ-ROW.                                              
           MOVE '7700'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
             SELECT  FILED_CASE_NO,                                     
                     BANKRUPTCY_CHAPTER,                                
                     CIS.CHAR2$DATE(DATE_BNKRPT_FILED, 'USA'),                  
                     USER_ID_INIT_BY,                                   
                     CIS.CHAR2$DATE(RECEIVED_DATE, 'USA')                       
               INTO  :BQ-FILED-CASE-NO,                                 
                     :BQ-BANKRUPTCY-CHAPTER,                            
TP5205               :BQ-DATE-BNKRPT-FILED :WS-BQ-FILE-DATE-NULL-IND,    
                     :BQ-USER-ID-INIT-BY,                               
TP5205               :BQ-RECEIVED-DATE :WS-BQ-RECV-DATE-NULL-IND         
               FROM  CSS_BANKRUPTCY                                     
              WHERE  BNKRPT_CASE_NO = :BQ-BNKRPT-CASE-NO                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  FILED_CASE_NO,                                             
MFA-TR*              BANKRUPTCY_CHAPTER,                                        
MFA-TR*              CHAR(DATE_BNKRPT_FILED, USA),                              
MFA-TR*              USER_ID_INIT_BY,                                           
MFA-TR*              CHAR(RECEIVED_DATE, USA)                                   
MFA-TR*        INTO  :BQ-FILED-CASE-NO,                                         
MFA-TR*              :BQ-BANKRUPTCY-CHAPTER,                                    
MFA-TR*              :BQ-DATE-BNKRPT-FILED:WS-BQ-FILE-DATE-NULL-IND,            
MFA-TR*              :BQ-USER-ID-INIT-BY,                                       
MFA-TR*              :BQ-RECEIVED-DATE:WS-BQ-RECV-DATE-NULL-IND                 
MFA-TR*        FROM  CSS_BANKRUPTCY                                             
MFA-TR*       WHERE  BNKRPT_CASE_NO = :BQ-BNKRPT-CASE-NO                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
CBSI          MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_BANKRUPTCY'      TO TABLE-1                     
CBSI          MOVE 'BNKRPT_CASE_NO'      TO TABLE-ELEMENT-1             
              MOVE BQ-BNKRPT-CASE-NO     TO HOSTVAR-ELEMENT-1           
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
CBSI          MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *   7800-SELECT-BQ-ROW.                                          *        
      *                                                                *        
      *   THIS PARAGRAPH IS USED TO OBTAIN THE SELECTED ROW FROM THE   *        
      *   CSS_BANKRUPTCY TABLE BY FILED-CASE-NO.                       *        
      ******************************************************************        
       7800-SELECT-BQ-ROW.                                              
           MOVE '7800'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
             SELECT  BNKRPT_CASE_NO,                                    
                     BANKRUPTCY_CHAPTER,                                
                     CIS.CHAR2$DATE(DATE_BNKRPT_FILED, 'USA'),                  
                     USER_ID_INIT_BY,                                   
                     CIS.CHAR2$DATE(RECEIVED_DATE, 'USA')                       
               INTO  :BQ-BNKRPT-CASE-NO,                                
                     :BQ-BANKRUPTCY-CHAPTER,                            
TP5205               :BQ-DATE-BNKRPT-FILED :WS-BQ-FILE-DATE-NULL-IND,    
                     :BQ-USER-ID-INIT-BY,                               
TP5205               :BQ-RECEIVED-DATE :WS-BQ-RECV-DATE-NULL-IND         
               FROM  CSS_BANKRUPTCY                                     
              WHERE  FILED_CASE_NO = :BQ-FILED-CASE-NO                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  BNKRPT_CASE_NO,                                            
MFA-TR*              BANKRUPTCY_CHAPTER,                                        
MFA-TR*              CHAR(DATE_BNKRPT_FILED, USA),                              
MFA-TR*              USER_ID_INIT_BY,                                           
MFA-TR*              CHAR(RECEIVED_DATE, USA)                                   
MFA-TR*        INTO  :BQ-BNKRPT-CASE-NO,                                        
MFA-TR*              :BQ-BANKRUPTCY-CHAPTER,                                    
MFA-TR*              :BQ-DATE-BNKRPT-FILED:WS-BQ-FILE-DATE-NULL-IND,            
MFA-TR*              :BQ-USER-ID-INIT-BY,                                       
MFA-TR*              :BQ-RECEIVED-DATE:WS-BQ-RECV-DATE-NULL-IND                 
MFA-TR*        FROM  CSS_BANKRUPTCY                                             
MFA-TR*       WHERE  FILED_CASE_NO = :BQ-FILED-CASE-NO                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                       OR NOT-FOUND                     
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
CBSI          MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_BANKRUPTCY'      TO TABLE-1                     
              MOVE 'FILED_CASE_NO'       TO TABLE-ELEMENT-1             
              MOVE BQ-FILED-CASE-NO      TO HOSTVAR-ELEMENT-1           
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
CBSI          MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
                                                                        
P00936 7810-GET-FULL-BALANCE-A.                                         
P00936                                                                  
P00936     EXEC SQL                                                     
P00936         SELECT SUM (AMT_AR_DAY_00                                
P00936                   + AMT_AR_DAY_30                                
P00936                   + AMT_AR_DAY_60                                
P00936                   + AMT_AR_DAY_90                                
P00936                   + AMT_UNUSED_CR                                
P00936                   + AMT_TRAN_BALANCE                             
P00936                   + TOT_SUMM_UNBILLED)                           
P00936           INTO :WS-FULL-BALANCE-A :WS-NULL-4                      
P00936           FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                         
P00936          WHERE ACCOUNT_NO = :AC-ACCOUNT-NO                       
P00936            AND PYMT_PRIORITY_LVL < 50                            
P00936                                                           
P00936                                                      
P00936     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM (AMT_AR_DAY_00                                        
MFA-TR*                  + AMT_AR_DAY_30                                        
MFA-TR*                  + AMT_AR_DAY_60                                        
MFA-TR*                  + AMT_AR_DAY_90                                        
MFA-TR*                  + AMT_UNUSED_CR                                        
MFA-TR*                  + AMT_TRAN_BALANCE                                     
MFA-TR*                  + TOT_SUMM_UNBILLED)                                   
MFA-TR*          INTO :WS-FULL-BALANCE-A:WS-NULL-4                              
MFA-TR*          FROM CSS_AR_CNTL                                               
MFA-TR*         WHERE ACCOUNT_NO = :AC-ACCOUNT-NO                               
MFA-TR*           AND PYMT_PRIORITY_LVL < 50                                    
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7810                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00936                                                                  
P00936     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00936                                                                  
P00936     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00936         WHEN SUCCESSFUL-CALL                                     
P00936             IF WS-NULL-4 < 0                                     
P00936                MOVE ZEROS TO WS-FULL-BALANCE-A                   
P00936             END-IF                                               
P00936         WHEN NOT-FOUND                                           
P00936             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
P00936                            WS-FULL-BALANCE-A                     
P00936         WHEN OTHER                                               
P00936             MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
P00936             MOVE '7810'               TO ACTIVE-PARAGRAPH        
P00936             MOVE 'SELECT'             TO ABEND-FUNCTION          
P00936             MOVE 'CSS_AR_CNTL'        TO TABLE-1                 
P00936             MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
P00936             MOVE AC-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
P00936             PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
P00936             PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
P00936     END-EVALUATE.                                                
P00936                                                                  
P00936 7810-EXIT.                                                       
P00936     EXIT.                                                        
P00936                                                                  
P00936 7820-GET-FULL-BALANCE-B.                                         
P00936                                                                  
P00936     EXEC SQL                                                     
P00936         SELECT SUM (AMT_TRAN_BALANCE)                            
P00936           INTO :WS-FULL-BALANCE-B :WS-NULL-5                      
P00936           FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                         
P00936          WHERE ACCOUNT_NO = :AC-ACCOUNT-NO                       
P00936            AND PYMT_PRIORITY_LVL > 49                            
P00936            AND ITEM_ID > 0                                       
P00936                                                           
P00936                                                      
P00936     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM (AMT_TRAN_BALANCE)                                    
MFA-TR*          INTO :WS-FULL-BALANCE-B:WS-NULL-5                              
MFA-TR*          FROM CSS_AR_CNTL                                               
MFA-TR*         WHERE ACCOUNT_NO = :AC-ACCOUNT-NO                               
MFA-TR*           AND PYMT_PRIORITY_LVL > 49                                    
MFA-TR*           AND ITEM_ID > 0                                               
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7820                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00936                                                                  
P00936     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00936                                                                  
P00936     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00936         WHEN SUCCESSFUL-CALL                                     
P00936             IF WS-NULL-5 < 0                                     
P00936                MOVE ZEROS TO WS-FULL-BALANCE-B                   
P00936             END-IF                                               
P00936         WHEN NOT-FOUND                                           
P00936             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
P00936                            WS-FULL-BALANCE-B                     
P00936         WHEN OTHER                                               
P00936             MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
P00936             MOVE '7820'               TO ACTIVE-PARAGRAPH        
P00936             MOVE 'SELECT'             TO ABEND-FUNCTION          
P00936             MOVE 'CSS_AR_CNTL'        TO TABLE-1                 
P00936             MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
P00936             MOVE AC-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
P00936             PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
P00936             PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
P00936     END-EVALUATE.                                                
P00936                                                                  
P00936 7820-EXIT.                                                       
P00936     EXIT.                                                        
P00936******************************************************************        
P00936*   7830-GET-ACCT-DTLS.                                          *        
P00936******************************************************************        
P00936 7830-GET-ACCT-DTLS.                                              
P00936     MOVE '7830'                          TO ACTIVE-PARAGRAPH.    
P00936                                                                  
P00936     EXEC SQL                                                     
P00936       SELECT  REPLACE(REPLACE(CONVERT(CHAR(26), ACCT_CREATE_DT
           , 121), ' ', '-'), ':', '.') ACCT_CREATE_DT                         
P00936              ,CODE_ACCT_STAT                                     
P00936              ,TOTAL_AR_BALANCE                                   
P00936         INTO  :AT-ACCT-CREATE-DT :WS-NULL-1                       
P00936              ,:AT-CODE-ACCT-STAT                                 
P00936              ,:AT-TOTAL-AR-BALANCE                               
P00936         FROM  CSS_ACCOUNT WITH(READUNCOMMITTED)                          
P00936        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                        
P00936                                                           
P00936     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  ACCT_CREATE_DT                                             
MFA-TR*             ,CODE_ACCT_STAT                                             
MFA-TR*             ,TOTAL_AR_BALANCE                                           
MFA-TR*        INTO  :AT-ACCT-CREATE-DT:WS-NULL-1                               
MFA-TR*             ,:AT-CODE-ACCT-STAT                                         
MFA-TR*             ,:AT-TOTAL-AR-BALANCE                                       
MFA-TR*        FROM  CSS_ACCOUNT                                                
MFA-TR*       WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00936*                                                                         
P00936     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P00936*                                                                         
P00936     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00936        IF WS-NULL-1 < 0                                          
P00936           MOVE SPACES TO AT-ACCT-CREATE-DT                       
P00936        END-IF                                                    
P00936     ELSE                                                         
P00936        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
P00936        MOVE 'SELECT'             TO ABEND-FUNCTION               
P00936        MOVE 'CSS_ACCOUNT'        TO TABLE-1                      
P00936        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
P00936        MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
P00936        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00936        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00936     END-IF.                                                      
P00936 7830-EXIT.                                                       
P00936     EXIT.                                                        
HPCCDM*EJECT                                                                    
P00936                                                                  
P00936 7850-WO-FULL-BALANCE.                                            
P00936                                                                  
P00936     EXEC SQL                                                     
P00936         SELECT SUM (AMT_TRANS)                                   
P00936           INTO :CO-AMT-TRANS :WS-NULL-6                           
P00936           FROM CSS_CHRG_OFF WITH(READUNCOMMITTED)                        
P00936          WHERE ACCOUNT_NO = :CO-ACCOUNT-NO                       
P00936                                                           
P00936                                                      
P00936     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUM (AMT_TRANS)                                           
MFA-TR*          INTO :CO-AMT-TRANS:WS-NULL-6                                   
MFA-TR*          FROM CSS_CHRG_OFF                                              
MFA-TR*         WHERE ACCOUNT_NO = :CO-ACCOUNT-NO                               
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 7850                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00936                                                                  
P00936     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
P00936                                                                  
P00936     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00936         WHEN SUCCESSFUL-CALL                                     
P00936             IF WS-NULL-6 < 0                                     
P00936                MOVE ZEROS TO CO-AMT-TRANS                        
P00936             END-IF                                               
P00936         WHEN NOT-FOUND                                           
P00936             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
P00936                            CO-AMT-TRANS                          
P00936         WHEN OTHER                                               
P00936             MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
P00936             MOVE '7850'               TO ACTIVE-PARAGRAPH        
P00936             MOVE 'SELECT'             TO ABEND-FUNCTION          
P00936             MOVE 'CSS_CHRG_OFF'       TO TABLE-1                 
P00936             MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
P00936             MOVE CO-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
P00936             PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
P00936             PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
P00936     END-EVALUATE.                                                
P00936                                                                  
P00936 7850-EXIT.                                                       
P00936     EXIT.                                                        
P00936******************************************************************        
P00936*8000A-DELETE-GTT-ROWS                                           *        
P00936******************************************************************        
P00936 8000A-DELETE-GTT-ROWS.                                           
P00936*                                                                         
P00936     MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.          
P00936*                                                                         
P00936     EXEC SQL                                                     
P00936          DELETE FROM #CSR02194_R1                         
P00936     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM SESSION.CSR02194_R1                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00936*                                                                         
P00936     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
P00936*                                                                         
P00936     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00936         NEXT SENTENCE                                            
P00936     ELSE                                                         
P00936        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00936        MOVE SQLCODE               TO ABEND-SQLCODE               
P00936        MOVE '8000A'               TO ACTIVE-PARAGRAPH            
P00936        MOVE 'DELETE'              TO ABEND-FUNCTION              
P00936        MOVE SPACES                TO ABEND-SQL-PREDICATES        
P00936                                      ABEND-TABLES                
P00936        MOVE 'CSR02194_R1'         TO TABLE-1                     
P00936        MOVE SPACES                TO TABLE-ELEMENT-1             
P00936        MOVE SPACES                TO HOSTVAR-ELEMENT-1           
P00936        PERFORM 9000-SEND-ERROR-RESULT                            
P00936                                   THRU 9000-EXIT                 
P00936        PERFORM 9900-SQL-ERROR-ROUTINE                            
P00936                                   THRU 9900-EXIT                 
P00936     END-IF.                                                      
P00936 8000A-EXIT.                                                      
P00936     EXIT.                                                        
P00936                                                                  
P00936******************************************************************        
P00936*8000B-DELETE-GTT-ROWS                                           *        
P00936******************************************************************        
P00936 8000B-DELETE-GTT-ROWS.                                           
P00936*                                                                         
P00936     MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.          
P00936*                                                                         
P00936     EXEC SQL                                                     
P00936          DELETE FROM #CSR02194_R2                         
P00936     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM SESSION.CSR02194_R2                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00936*                                                                         
P00936     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
P00936*                                                                         
P00936     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00936         NEXT SENTENCE                                            
P00936     ELSE                                                         
P00936        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00936        MOVE SQLCODE               TO ABEND-SQLCODE               
P00936        MOVE '8000B'               TO ACTIVE-PARAGRAPH            
P00936        MOVE 'DELETE'              TO ABEND-FUNCTION              
P00936        MOVE SPACES                TO ABEND-SQL-PREDICATES        
P00936                                      ABEND-TABLES                
P00936        MOVE 'CSR02194_R2'         TO TABLE-1                     
P00936        MOVE SPACES                TO TABLE-ELEMENT-1             
P00936        MOVE SPACES                TO HOSTVAR-ELEMENT-1           
P00936        PERFORM 9000-SEND-ERROR-RESULT                            
P00936                                   THRU 9000-EXIT                 
P00936        PERFORM 9900-SQL-ERROR-ROUTINE                            
P00936                                   THRU 9900-EXIT                 
P00936     END-IF.                                                      
P00936 8000B-EXIT.                                                      
P00936     EXIT.                                                        
P00936******************************************************************        
P00936*8100-SEND-RESULT                                                *        
P00936******************************************************************        
P00936 8100-SEND-RESULT.                                                
P00936*                                                                         
P00936     EXEC SQL                                                     
P00936          INSERT INTO #CSR02194_R1                         
P00936          (                                                       
P00936               RETURN_CODE                                        
P00936              ,FILED_CASE_NO                                      
P00936              ,BNKRPT_CASE_NO                                     
P00936              ,S_BKTCY_CHAPTER                                    
P00936              ,DATE_BKTCY_FILED                                   
P00936              ,INIT_BY                                            
P00936              ,RECEIVED_DATE                                      
P00936          )                                                       
P00936          VALUES                                                  
P00936          (                                                       
P00936               :S-RETURN-CODE                                     
P00936              ,:S-FILED-CASE-NO                                   
P00936              ,:S-BNKRPT-CASE-NO                                  
P00936              ,:S-BKTCY-CHAPTER                                   
P00936              ,:S-DATE-BKTCY-FILED                                
P00936              ,:S-INIT-BY                                         
P00936              ,:S-RECEIVED-DATE                                   
P00936          )                                                       
P00936     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR02194_R1                                 
MFA-TR*         (                                                       01670000
MFA-TR*              RETURN_CODE                                        01670000
MFA-TR*             ,FILED_CASE_NO                                              
MFA-TR*             ,BNKRPT_CASE_NO                                             
MFA-TR*             ,S_BKTCY_CHAPTER                                            
MFA-TR*             ,DATE_BKTCY_FILED                                           
MFA-TR*             ,INIT_BY                                                    
MFA-TR*             ,RECEIVED_DATE                                              
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                       01670000
MFA-TR*              :S-RETURN-CODE                                     01670000
MFA-TR*             ,:S-FILED-CASE-NO                                           
MFA-TR*             ,:S-BNKRPT-CASE-NO                                          
MFA-TR*             ,:S-BKTCY-CHAPTER                                           
MFA-TR*             ,:S-DATE-BKTCY-FILED                                        
MFA-TR*             ,:S-INIT-BY                                                 
MFA-TR*             ,:S-RECEIVED-DATE                                           
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00936                                                                  
P00936*                                                                         
P00936     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00936*                                                                         
P00936     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00936          ADD +1                    TO CTR-ROWS                   
P00936     ELSE                                                         
P00936          MOVE PROGRAM-NAME         TO ABEND-PROGRAM              
P00936          MOVE SQLCODE              TO ABEND-SQLCODE              
P00936          MOVE '8100'               TO ACTIVE-PARAGRAPH           
P00936          MOVE 'INSERT'             TO ABEND-FUNCTION             
P00936          MOVE SPACES               TO ABEND-SQL-PREDICATES       
P00936                                       ABEND-TABLES               
P00936          MOVE 'CSR02194_R1'        TO TABLE-1                    
P00936          MOVE SPACES               TO TABLE-ELEMENT-1            
P00936          MOVE SPACES               TO HOSTVAR-ELEMENT-1          
P00936          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
P00936     END-IF.                                                      
P00936*                                                                         
P00936 8100-EXIT.                                                       
P00936     EXIT.                                                        
P00936*                                                                         
P00936******************************************************************        
P00936*8200-SEND-RESULT                                                *        
P00936******************************************************************        
P00936 8200-SEND-RESULT.                                                
P00936*                                                                         
P00936     EXEC SQL                                                     
P00936          INSERT INTO #CSR02194_R2                         
P00936          (                                                       
P00936               RETURN_CODE                                        
P00936              ,NAME                                               
P00936              ,ACCT_TYPE_DESC                                     
P00936              ,ACCOUNT_NO                                         
P00936              ,CUSTOMER_NO                                        
P00936              ,ADDRESS                                            
P00936              ,BNKRPT_IND                                         
P00936              ,PREMISE_NO                                         
P00936              ,ACCT_TYPE                                          
P00936              ,CODE_ACCT_STAT                                     
P00936              ,ACCOUNT_BALANCE                                    
P00936              ,ACCT_CREATE_DT                                     
P00936          )                                                       
P00936          VALUES                                                  
P00936          (                                                       
P00936               :S2-RETURN-CODE                                    
P00936              ,:S2-NAME                                           
P00936              ,:S2-ACCT-TYPE-DESC                                 
P00936              ,:S2-ACCOUNT-NO                                     
P00936              ,:S2-CUSTOMER-NO                                    
P00936              ,:S2-ADDRESS                                        
P00936              ,:S2-BNKRPT-IND                                     
P00936              ,:S2-PREMISE-NO                                     
P00936              ,:S2-ACCT-TYPE                                      
P00936              ,:S2-CODE-ACCT-STAT                                 
P00936              ,:S2-ACCOUNT-BALANCE                                
P00936              ,:S2-CREATE-DT                                      
P00936          )                                                       
P00936     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR02194_R2                                 
MFA-TR*         (                                                       01670000
MFA-TR*              RETURN_CODE                                        01670000
MFA-TR*             ,NAME                                                       
MFA-TR*             ,ACCT_TYPE_DESC                                             
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,CUSTOMER_NO                                                
MFA-TR*             ,ADDRESS                                                    
MFA-TR*             ,BNKRPT_IND                                                 
MFA-TR*             ,PREMISE_NO                                                 
MFA-TR*             ,ACCT_TYPE                                                  
MFA-TR*             ,CODE_ACCT_STAT                                             
MFA-TR*             ,ACCOUNT_BALANCE                                            
MFA-TR*             ,ACCT_CREATE_DT                                             
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                       01670000
MFA-TR*              :S2-RETURN-CODE                                    01670000
MFA-TR*             ,:S2-NAME                                                   
MFA-TR*             ,:S2-ACCT-TYPE-DESC                                         
MFA-TR*             ,:S2-ACCOUNT-NO                                             
MFA-TR*             ,:S2-CUSTOMER-NO                                            
MFA-TR*             ,:S2-ADDRESS                                                
MFA-TR*             ,:S2-BNKRPT-IND                                             
MFA-TR*             ,:S2-PREMISE-NO                                             
MFA-TR*             ,:S2-ACCT-TYPE                                              
MFA-TR*             ,:S2-CODE-ACCT-STAT                                         
MFA-TR*             ,:S2-ACCOUNT-BALANCE                                        
MFA-TR*             ,:S2-CREATE-DT                                              
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00936                                                                  
P00936*                                                                         
P00936     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00936*                                                                         
P00936     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00936          ADD +1                    TO CTR-ROWS-2                 
P00936     ELSE                                                         
P00936          MOVE PROGRAM-NAME         TO ABEND-PROGRAM              
P00936          MOVE SQLCODE              TO ABEND-SQLCODE              
P00936          MOVE '8200'               TO ACTIVE-PARAGRAPH           
P00936          MOVE 'INSERT'             TO ABEND-FUNCTION             
P00936          MOVE SPACES               TO ABEND-SQL-PREDICATES       
P00936                                       ABEND-TABLES               
P00936          MOVE 'CSR02194_R2'        TO TABLE-1                    
P00936          MOVE SPACES               TO TABLE-ELEMENT-1            
P00936          MOVE SPACES               TO HOSTVAR-ELEMENT-1          
P00936          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
P00936     END-IF.                                                      
P00936*                                                                         
P00936 8200-EXIT.                                                       
P00936     EXIT.                                                        
P00936*                                                                         
P00936******************************************************************        
P00936*   8900-SEND-DONE                                               *        
P00936******************************************************************        
P00936 8900-SEND-DONE.                                                  
P00936*                                                                         
P00936     EXEC SQL                                                     
P00936         OPEN C1                                                  
P00936     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
P00936     EXEC SQL                                                     
P00936         OPEN C2                                                  
P00936     END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
P00936*                                                                         
P00936 8900-EXIT.                                                       
P00936     EXIT.                                                        
P00936******************************************************************        
P00936* 9000-SEND-ERROR-RESULT                                         *        
P00936******************************************************************        
P00936 9000-SEND-ERROR-RESULT.                                          
P00936*                                                                         
P00936     MOVE 'N'                   TO SEND-DONE-SW.                  
P00936     INITIALIZE GTT-RETURN-FIELDS.                                
P00936     MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE                  
P00936                                   ABEND-SQLCODE.                 
P00936     MOVE SQLERRMC              TO ABEND-SQLERRMC.                
P00936*                                                                         
P00936     EXEC SQL                                                     
P00936         ROLLBACK                                                 
P00936     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00936*                                                                         
P00936     IF SQLCODE = 0                                               
P00936        CONTINUE                                                  
P00936     ELSE                                                         
P00936        MOVE 'ROLLBACK'         TO ABEND-FUNCTION                 
P00936     END-IF.                                                      
P00936*                                                                         
P00936     PERFORM 0100A-DECLARE-GTT  THRU 0100A-EXIT.                  
P00936     PERFORM 0100B-DECLARE-GTT  THRU 0100B-EXIT.                  
P00936     PERFORM 8100-SEND-RESULT   THRU 8100-EXIT.                   
P00936     PERFORM 8200-SEND-RESULT   THRU 8200-EXIT.                   
P00936*                                                                         
P00936 9000-EXIT.                                                       
P00936     EXIT.                                                        
P00936*                                                                         
P00936******************************************************************        
P00936*   9999-END-PROGRAM                                             *        
P00936******************************************************************        
P00936*                                                                         
P00936 9999-END-PROGRAM.                                                
P00936                                                                  
P00936     IF CTR-ROWS < 1                                              
P00936******************************************************************        
P00936*         PROGRAMMER LOGIC ERROR - SHOULD ALWAYS SEND A ROW!     *        
P00936******************************************************************        
P00936        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
P00936        MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
P00936        MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
P00936        MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
P00936        MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
P00936        MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
P00936        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00936        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
MAN010* Opening result sets twice, duplicates returned result sets
MAN010*    ELSE                                                                 
MAN010*       PERFORM 8900-SEND-DONE    THRU 8900-EXIT                          
P00936     END-IF.                                                      
P00936     IF CTR-ROWS-2 < 1                                            
P00936******************************************************************        
P00936*         PROGRAMMER LOGIC ERROR - SHOULD ALWAYS SEND A ROW!     *        
P00936******************************************************************        
P00936        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
P00936        MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
P00936        MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
P00936        MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
P00936        MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
P00936        MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
P00936        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00936        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
MAN010* Opening result sets twice, duplicates returned result sets
MAN010*    ELSE                                                                 
MAN010*       PERFORM 8900-SEND-DONE    THRU 8900-EXIT                          
P00936     END-IF.                                                      
P00936                                                                  
MAN010     PERFORM 8900-SEND-DONE    THRU 8900-EXIT.
P00936     
MSQ016        GOBACK.                                                    
P00936                                                                  
P00936 9999-EXIT.                                                       
P00936     EXIT.                                                        
P00936******************************************************************        
P00936* 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
REARCH*    EXEC SQL                                                             
REARCH*       INCLUDE CPD00300                                                  
REARCH*    END-EXEC.                                                            
REARCH     EXEC SQL                                                             
REARCH          INCLUDE CPDSP300                                                
REARCH     END-EXEC.                                                            
P00936******************************************************************        
P00936* 6010- REDUCE EMBEDDED SPACES                                            
P00936******************************************************************        
P00936     COPY CPD00004.                                                       
P00936*                                                                         
