       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR02192.                                          
COB303 DATE-WRITTEN.     NOVEMBER 10, 1995.                             
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      ***              SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S192                                           *        
      *  PROGRAM:       S192                                           *        
      *  CALLING SP:    PA_S192                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *        
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *        
      *  THIS PROGRAM RETRIEVES THE DATA FOR ACCOUNTS                  *        
      *  ON PANEL 135.                                                 *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  11/10/95      SR     INITIALLY CODED.                         *        
CBSI  *  09/24/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *              MADRAS   ABEND PARAMETERS AND CODING INCLUDED     *        
CBSI  *                       TO PERFORM 7220-CLOSE AT_CRSR.           *        
REARCH*  05/19/05    CVNS     RPC TO COBOL SP CONVERSION               *        
REARCH*              CHENNAI                                           *        
C37510*  09/12/08  COVANSYS   NAME AND ADDRESS FORMATTED CHANGES       *        
C37510*            CHENNAI                                             *        
A00755*  11/13/00  DB41297    FIX PROD ABEND WHEN                      *        
A00755*            AT-BNKRPT-CASE-NO NOT FOUND.                        *        
A05460*  09/29/16  MR7E794    REMOVED THE MAIN USER TABLE AS PART      *        
      *            ACT282     OF TABLE CHANGE AND GETTING THE SAME     *        
      *                       VALUE FROM CODE VALUE TABLE.             *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02192'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02192 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBNAME                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
ACT282         INCLUDE TBSOCODE                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBBNKRPT                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBADRFMT                                                 
           END-EXEC.                                                            
                                                                        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBADRFRE                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBNMACTX                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
                                                                        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *--------<COMMON SYSTEM AREA >                                            
           COPY CCA00001.                                                       
                                                                        
      *--------< ERROR HANDLING >                                               
REARCH     EXEC SQL                                                             
REARCH          INCLUDE CWSX0010                                                
REARCH     END-EXEC.                                                            
                                                                        
                                                                        
      *--------< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >               
           COPY CWS00027.                                                       
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                          
           COPY CWS00303.                                                       
                                                                        
C37510*--------< REDUCE EMBEDDED SPACES >                                       
C37510     COPY CWS00011.                                                       
                                                                        
       01  WS-MISC.                                                     
REARCH     05 WS-SQLSTATE                      PIC X(05) VALUE SPACES.  
           05 WS-NULL-INDICATORS.                                       
              10 WS-AT-DT-START-NULL-IND       PIC S9(4) COMP.          
              10 WS-AT-REMOVE-DT-NULL-IND      PIC S9(4) COMP.          
              10 WS-AT-LAST-BILL-DT-NULL-IND   PIC S9(4) COMP.          
           05 WS-ACCOUNT-NO            PIC X(13).                       
           05 WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO                 
                                       PIC 9(13).                       
           05 WS-PREMISE-NUM           PIC 9(10).                       
           05 WS-PREMISE-NO     REDEFINES WS-PREMISE-NUM                
                                       PIC X(10).                       
           05 WS-SELECT-RETURN-CODE    PIC S9(9) COMP.                  
REARCH     05 PROGRAM-NAME             PIC X(08) VALUE 'CSR02192'.      
           05  WS-ADDRESS.                                              
C37510*        10  WS-ADDRESS-X        OCCURS 50 TIMES                          
C37510         10  WS-ADDRESS-X        OCCURS 81 TIMES                  
                                       INDEXED BY WS-ADD-SUB.           
                   15  FILLER          PIC X.                           
           05  WS-ADD-SUB-CNT          PIC 99 VALUE 1.                  
           05  WS-LENGTH               PIC S9(4).                       
           05  WS-MAX-SZ               PIC S9(4).                       
       01  WS-SUB                      PIC S9(8) COMP VALUE ZERO.       
      *                                                                 00052000
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
REARCH*                                                                 00052000
HPCCDM*    EJECT                                                        00096000
REARCH                                                                  
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  GTT-NAME                PIC X(26) VALUE                  
REARCH                                       'SESSION.CSR02192_R1'.     
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN          PIC S9(04) COMP.                 
REARCH         49 GTT-ROW-CHAR         PIC X(1024).                     
REARCH     05  GTT-SQLCODE             PIC S9(9) COMP.                  
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
           05  WS-FROM.                                                 
               10  WS-FROM-X           OCCURS 51 TIMES PIC X.           
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
REARCH*                                                                         
       01  TDS-RETURN-FIELDS.                                           
           05 RS-RETURN-CODE       PIC S9(9) COMP VALUE 0.              
C37510*    05 RS-NAME              PIC X(50)      VALUE SPACES.                 
C37510     05 RS-NAME              PIC X(77)      VALUE SPACES.         
           05 RS-ACCT-TYPE-DESC    PIC X(25)      VALUE SPACES.         
           05 RS-ACCOUNT-NO        PIC X(13)      VALUE SPACES.         
           05 RS-CUSTOMER-NO       PIC X(10)      VALUE SPACES.         
C37510*    05 RS-ADDRESS           PIC X(50)      VALUE SPACES.                 
C37510     05 RS-ADDRESS           PIC X(81)      VALUE SPACES.         
           05 RS-BNKRPT-IND        PIC X(01)      VALUE SPACES.         
           05 RS-PREMISE-NO        PIC X(10)      VALUE SPACES.         
           05 RS-ACCT-TYPE         PIC X(01)      VALUE SPACES.         
REARCH*                                                                         
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05 S-RETURN-CODE         PIC S9(9) COMP VALUE 0.             
C37510     05 S-NAME                PIC X(77)      VALUE SPACES.        
REARCH     05 S-ACCT-TYPE-DESC      PIC X(25)      VALUE SPACES.        
REARCH     05 S-ACCOUNT-NO          PIC X(13)      VALUE SPACES.        
REARCH     05 S-CUSTOMER-NO         PIC X(10)      VALUE SPACES.        
C37510     05 S-ADDRESS             PIC X(81)      VALUE SPACES.        
REARCH     05 S-BNKRPT-IND          PIC X(01)      VALUE SPACES.        
REARCH     05 S-PREMISE-NO          PIC X(10)      VALUE SPACES.        
REARCH     05 S-ACCT-TYPE           PIC X(01)      VALUE SPACES.        
      *                                                                         
       01  CN-CONSTANTS.                                                
           05  CN-DELIMITER                 PIC X VALUE ';'.            
           05  CN-ASTERISK                  PIC X VALUE '*'.            
REARCH*                                                                         
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
REARCH     10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
REARCH     10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
REARCH     10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
REARCH         49  S-HOST-VARIABLES-V  PIC X(255).                      
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-STATEMENT-V   PIC X(255).                      
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-DESCRIPTION-V PIC X(255).                      
REARCH*                                                                         
HPCCDM*    EJECT                                                                
      ******************************************************************01014000
      *                                                                *01015000
      *  CURSOR DECLARATION FOR THE CSS_ACCOUNT TABLE.                 *01016000
      *                                                                *01019000
      ******************************************************************01020000
           EXEC SQL                                                     
             DECLARE AT_CRSR CURSOR FOR                                 
             SELECT ACCOUNT_NO,                                         
                    BANKRUPTCY_IND,                                     
                    CUSTOMER_NO,                                        
                    PREMISE_NO,                                         
                    ADDRESS_FORMAT,                                     
                    ACCOUNT_TYPE_CODE                                   
               FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                           
              WHERE BNKRPT_CASE_NO = :AT-BNKRPT-CASE-NO                 
A00755        FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     01021000
MFA-TR*      DECLARE AT_CRSR CURSOR FOR                                 01022000
MFA-TR*      SELECT ACCOUNT_NO,                                                 
MFA-TR*             BANKRUPTCY_IND,                                             
MFA-TR*             CUSTOMER_NO,                                                
MFA-TR*             PREMISE_NO,                                                 
MFA-TR*             ADDRESS_FORMAT,                                             
MFA-TR*             ACCOUNT_TYPE_CODE                                           
MFA-TR*        FROM CSS_ACCOUNT                                                 
MFA-TR*       WHERE BNKRPT_CASE_NO = :AT-BNKRPT-CASE-NO                         
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
      *                                                                         
HPCCDM*    EJECT                                                        02620001
      *                                                                         
REARCH LINKAGE SECTION.                                                 
REARCH*                                                                         
REARCH 01  PARM-BNKRPT-CASE-NO     PIC X(10).                           
REARCH*                                                                         
REARCH PROCEDURE DIVISION USING PARM-BNKRPT-CASE-NO.                    
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
REARCH     PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH          DECLARE C1 CURSOR  FOR                       
REARCH          SELECT                                                  
REARCH               RETURN_CODE                                        
REARCH              ,LTRIM(RTRIM(NAME))             AS NAME                    
REARCH              ,LTRIM(RTRIM(ACCT_TYPE_DESC))   AS ACCT_TYPE_DESC          
REARCH              ,ACCOUNT_NO                                         
REARCH              ,CUSTOMER_NO                                        
REARCH              ,LTRIM(RTRIM(ADDRESS))          AS ADDRESS                 
REARCH              ,BNKRPT_IND                                         
REARCH              ,PREMISE_NO                                         
REARCH              ,ACCT_TYPE                                          
REARCH          FROM                                                    
REARCH               #CSR02192_R1                                
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,STRIP(NAME)             AS NAME                            
MFA-TR*             ,STRIP(ACCT_TYPE_DESC)   AS ACCT_TYPE_DESC                  
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,CUSTOMER_NO                                                
MFA-TR*             ,STRIP(ADDRESS)          AS ADDRESS                         
MFA-TR*             ,BNKRPT_IND                                                 
MFA-TR*             ,PREMISE_NO                                                 
MFA-TR*             ,ACCT_TYPE                                                  
MFA-TR*         FROM                                                            
MFA-TR*              SESSION.CSR02192_R1                                        
MFA-TR*    END-EXEC.                                                            
REARCH*                                                                         
REARCH 0100-EXIT.                                                       
REARCH     EXIT.                                                        
REARCH*                                                                         
REARCH******************************************************************        
REARCH* 0100A-DECLARE-GTT                                              *        
REARCH******************************************************************        
REARCH 0100A-DECLARE-GTT.                                               
REARCH*                                                                         
REARCH     MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR02192_R1'            
REARCH                                    TO S-SQL-STATEMENT-V.         
REARCH     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02192_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02192_R1
              (                                                       
REARCH               RETURN_CODE         INT                        
C37510              ,NAME CHAR(77)  COLLATE LATIN1_GENERAL_100_BIN2             
REARCH              ,ACCT_TYPE_DESC CHAR(25)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH              ,ACCOUNT_NO CHAR(13)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH              ,CUSTOMER_NO CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
C37510              ,ADDRESS CHAR(81)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH              ,BNKRPT_IND CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH              ,PREMISE_NO CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH              ,ACCT_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH          )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH     MOVE SQLSTATE                 TO WS-SQLSTATE.                
REARCH     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
REARCH*                                                                         
REARCH     IF WS-SQLSTATE = '42710'                                     
REARCH         PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT            
REARCH     ELSE                                                         
REARCH         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
REARCH                NEXT SENTENCE                                     
REARCH         ELSE                                                     
REARCH            MOVE PROGRAM-NAME       TO ABEND-PROGRAM              
REARCH            MOVE SQLCODE            TO ABEND-SQLCODE              
REARCH            MOVE SQLSTATE           TO ABEND-SQLSTATE             
REARCH            MOVE '0100A'            TO ACTIVE-PARAGRAPH           
REARCH            MOVE 'DECLARE GTT'      TO ABEND-FUNCTION             
REARCH            MOVE SPACES             TO ABEND-SQL-PREDICATES       
REARCH                                       ABEND-TABLES               
REARCH            MOVE 'CSR02192_R1'      TO TABLE-1                    
REARCH            MOVE SPACES             TO TABLE-ELEMENT-1            
REARCH            MOVE SPACES             TO HOSTVAR-ELEMENT-1          
REARCH            PERFORM 9900-SQL-ERROR-ROUTINE                        
REARCH                                    THRU  9900-EXIT               
REARCH         END-IF                                                   
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH 0100A-EXIT.                                                      
REARCH     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     CALLS 2100-DESCRIBE-RESULT                                 *        
      *           2200-BUILD-RESULT-AT                                 *        
      *     CALLED FROM 0000-MAINLINE                                 *         
      *                                                                *        
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *        
      *      AND SENDS THEM BACK                                       *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                           TO ACTIVE-PARAGRAPH.   
           PERFORM 2200-BUILD-RESULT-DATA        THRU 2200-EXIT.        
       2000-EXIT.                                                       
           EXIT.                                                        
REARCH*                                                                         
REARCH******************************************************************        
REARCH*2000A-MOVE-RESULT                                               *        
REARCH******************************************************************        
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE RS-RETURN-CODE    TO S-RETURN-CODE.                     
REARCH     MOVE RS-NAME           TO S-NAME.                            
REARCH     MOVE RS-ACCT-TYPE-DESC TO S-ACCT-TYPE-DESC.                  
REARCH     MOVE RS-ACCOUNT-NO     TO S-ACCOUNT-NO.                      
REARCH     MOVE RS-CUSTOMER-NO    TO S-CUSTOMER-NO.                     
REARCH     MOVE RS-ADDRESS        TO S-ADDRESS.                         
REARCH     MOVE RS-BNKRPT-IND     TO S-BNKRPT-IND.                      
REARCH     MOVE RS-PREMISE-NO     TO S-PREMISE-NO.                      
REARCH     MOVE RS-ACCT-TYPE      TO S-ACCT-TYPE.                       
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2200-BUILD-RESULT-DATA                                      *        
      *                                                                *        
      *    CALLED FROM 2000-PROCESS-OUTPUT                             *        
      *                                                                *        
      *    OPENS AND CLOSES THE AT CURSOR                              *        
      ******************************************************************        
       2200-BUILD-RESULT-DATA.                                          
           MOVE '2200'       TO ACTIVE-PARAGRAPH.                       
                                                                        
           MOVE PARM-BNKRPT-CASE-NO TO AT-BNKRPT-CASE-NO.               
                                                                        
           PERFORM 7200-OPEN-AT-CRSR  THRU  7200-EXIT.                  
           PERFORM 7210-FETCH-AT-CRSR  THRU  7210-EXIT.                 
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
REARCH        PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT              
              PERFORM 8100-SEND-RESULT     THRU 8100-EXIT               
A00755     ELSE                                                         
A00755        PERFORM 2210-PROCESS-AT-CRSR THRU 2210-EXIT               
A00755        UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
A00755     END-IF.                                                      
CBSI       PERFORM 7220-CLOSE-AT-CRSR   THRU 7220-EXIT.                 
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2210-PROCESS-AT-CRSR.                                            
           MOVE '2210'               TO ACTIVE-PARAGRAPH.               
                                                                        
           MOVE AT-ACCOUNT-NO        TO HT-ACCOUNT-NO                   
                                        RS-ACCOUNT-NO.                  
           MOVE AT-PREMISE-NO        TO WS-PREMISE-NO.                  
           MOVE AT-CUSTOMER-NO       TO HT-CUSTOMER-NO                  
                                        RS-CUSTOMER-NO.                 
           MOVE AT-BANKRUPTCY-IND    TO RS-BNKRPT-IND.                  
ACT282     MOVE AT-ACCOUNT-TYPE-CODE TO SW-CODE-VALUE                   
                                        RS-ACCT-TYPE.                   
                                                                        
           PERFORM 7600-SELECT-N9-ROW THRU 7600-EXIT.                   
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT282        MOVE SW-CODE-LONG-DESC TO RS-ACCT-TYPE-DESC               
           ELSE                                                         
              MOVE 'ACCOUNT TYPE NOT FOUND' TO RS-ACCT-TYPE-DESC        
           END-IF.                                                      
                                                                        
           PERFORM 2220-GET-NAME THRU 2220-EXIT.                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE HT-ADDRESS-ID          TO DY-ADDRESS-ID              
              PERFORM 7400-SELECT-ADDR-FORM   THRU 7400-EXIT            
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 PERFORM 7410-SELECT-CITY        THRU 7410-EXIT         
                 PERFORM 2600-BUILD-ADDR-FORM    THRU 2600-EXIT         
              ELSE                                                      
                 MOVE SPACES TO RS-ADDRESS                              
              END-IF                                                    
           ELSE                                                         
              MOVE SPACES TO RS-ADDRESS                                 
           END-IF.                                                      
                                                                        
REARCH     PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT.               
           PERFORM 8100-SEND-RESULT      THRU 8100-EXIT.                
           PERFORM 7210-FETCH-AT-CRSR  THRU  7210-EXIT.                 
       2210-EXIT.                                                       
            EXIT.                                                       
     *                                                                  
       2220-GET-NAME.                                                   
           PERFORM 7300-SELECT-DQ-ROW THRU 7300-EXIT.                   
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
           IF DQ-NAME-FORMAT = 'I'                                      
              MOVE DQ-LAST-NAME TO WS-FROM                              
               PERFORM 2510-PROCESS-FROM-STRING                         
               MOVE WS-FROM TO DQ-LAST-NAME                             
                                                                        
               MOVE DQ-FIRST-NAME TO WS-FROM                            
               PERFORM 2510-PROCESS-FROM-STRING                         
               MOVE WS-FROM TO DQ-FIRST-NAME                            
                                                                        
               IF DQ-MIDDLE-NAME NOT = SPACE                            
                   MOVE DQ-MIDDLE-NAME TO WS-FROM                       
                   PERFORM 2510-PROCESS-FROM-STRING                     
                   MOVE WS-FROM TO DQ-MIDDLE-NAME                       
               END-IF                                                   
                                                                        
               MOVE DQ-TITLE-SUFFIX-1 TO WS-FROM                        
               PERFORM 2510-PROCESS-FROM-STRING                         
               MOVE WS-FROM TO DQ-TITLE-SUFFIX-1                        
                                                                        
               IF DQ-MIDDLE-NAME = SPACE                                
                   STRING DQ-LAST-NAME DELIMITED CN-DELIMITER           
                          ', ' DELIMITED SIZE                           
                          DQ-FIRST-NAME DELIMITED CN-DELIMITER          
                          ' ' DELIMITED SIZE                            
                          DQ-TITLE-SUFFIX-1 DELIMITED CN-DELIMITER      
                     INTO RS-NAME                                       
                   END-STRING                                           
               ELSE                                                     
                   STRING DQ-LAST-NAME DELIMITED CN-DELIMITER           
                          ', ' DELIMITED SIZE                           
                          DQ-FIRST-NAME DELIMITED CN-DELIMITER          
                          ' ' DELIMITED SIZE                            
                          DQ-MIDDLE-NAME DELIMITED CN-DELIMITER         
                          ' ' DELIMITED SIZE                            
                          DQ-TITLE-SUFFIX-1 DELIMITED CN-DELIMITER      
                     INTO RS-NAME                                       
                   END-STRING                                           
               END-IF                                                   
           ELSE                                                         
               MOVE DQ-FULL-NAME     TO RS-NAME                         
           END-IF                                                       
           ELSE                                                         
              MOVE 'NAME NOT FOUND' TO RS-NAME                          
           END-IF.                                                      
C37510     MOVE RS-NAME                      TO WS-EMB-INPUT.           
C37510     MOVE 77                           TO WS-EMB-LENG.            
C37510     MOVE SPACES                       TO WS-CMP-TABLE.           
C37510     PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT.          
C37510     MOVE WS-CMP-TABLE                 TO RS-NAME.                
       2220-EXIT.                                                       
            EXIT.                                                       
     *                                                                  
      ************************************************************              
      * 2510-PROCESS-FROM-STRING                                 *              
      *                                                          *              
      * DETERMINE LENGTH OF FIELD. PLACE DELIMITER AFTER THE LAST*              
      * NON-SPACE CHARACTER TO BE USED LATER IN STRING STATEMENT.*              
      *                                                          *              
      ************************************************************              
                                                                        
       2510-PROCESS-FROM-STRING.                                        
                                                                        
           PERFORM                                                      
                VARYING WS-SUB FROM 51 BY -1                            
                UNTIL WS-SUB < 1                                        
                OR WS-FROM-X (WS-SUB) NOT = SPACE                       
           END-PERFORM.                                                 
           ADD 1             TO WS-SUB.                                 
           MOVE CN-DELIMITER TO WS-FROM-X (WS-SUB).                     
                                                                        
       2510-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
      *****************************************************************         
      * 2600-BUILD-ADDR-FORM                                          *         
      *                                                               *         
      *      CONCATENATE ALL ADDRESS DETAILS INTO A SINGLE            *         
      *      STRING TO BE SENT AS RESULT SET                          *         
      *****************************************************************         
                                                                        
       2600-BUILD-ADDR-FORM.                                            
                                                                        
           MOVE SPACE TO WS-ADDRESS.                                    
           SET WS-ADD-SUB TO 1.                                         
           MOVE +1     TO WS-ADD-SUB-CNT.                               
                                                                        
           IF DY-ADDR-USAGE-CD = 'I'                                    
               MOVE DY-STREET-NAME           TO WS-FROM                 
               MOVE LENGTH OF DY-STREET-NAME TO WS-MAX-SZ               
               PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT      
                                                                        
               MOVE '&' TO WS-FROM                                      
               MOVE 1   TO WS-MAX-SZ                                    
               PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT      
                                                                        
               MOVE DY-ADDRESS-OVERFLOW           TO WS-FROM            
               MOVE LENGTH OF DY-ADDRESS-OVERFLOW TO WS-MAX-SZ          
               PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT      
           ELSE                                                         
               MOVE SPACE TO WS-ADDRESS                                 
               SET WS-ADD-SUB TO 1                                      
                                                                        
               IF DY-HOUSE-NO NOT = SPACE                               
                   MOVE DY-HOUSE-NO           TO WS-FROM                
                   MOVE LENGTH OF DY-HOUSE-NO TO WS-MAX-SZ              
                   PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT  
               END-IF                                                   
                                                                        
               IF DY-ADDR-PREFIX-1 NOT = SPACE                          
                   MOVE DY-ADDR-PREFIX-1           TO WS-FROM           
                   MOVE LENGTH OF DY-ADDR-PREFIX-1 TO WS-MAX-SZ         
                   PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT  
               END-IF                                                   
                                                                        
               IF DY-ADDR-PREFIX-2 NOT = SPACE                          
                   MOVE DY-ADDR-PREFIX-2           TO WS-FROM           
                   MOVE LENGTH OF DY-ADDR-PREFIX-2 TO WS-MAX-SZ         
                   PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT  
               END-IF                                                   
                                                                        
               IF DY-STREET-NAME NOT = SPACE                            
                   MOVE DY-STREET-NAME           TO WS-FROM             
                   MOVE LENGTH OF DY-STREET-NAME TO WS-MAX-SZ           
                   PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT  
               END-IF                                                   
                                                                        
               IF DY-STREET-SUFFIX NOT = SPACE                          
                   MOVE DY-STREET-SUFFIX           TO WS-FROM           
                   MOVE LENGTH OF DY-STREET-SUFFIX TO WS-MAX-SZ         
                   PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT  
               END-IF                                                   
                                                                        
               IF DY-STREET-LOCATION-1 NOT = SPACE                      
                   MOVE DY-STREET-LOCATION-1           TO WS-FROM       
                   MOVE LENGTH OF DY-STREET-LOCATION-1 TO WS-MAX-SZ     
                   PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT  
               END-IF                                                   
                                                                        
               IF DY-STREET-LOCATION-2 NOT = SPACE                      
                   MOVE DY-STREET-LOCATION-2           TO WS-FROM       
                   MOVE LENGTH OF DY-STREET-LOCATION-2 TO WS-MAX-SZ     
                   PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT  
               END-IF                                                   
                                                                        
               IF A4-TOWN  NOT = SPACE                                  
                   MOVE A4-TOWN                        TO WS-FROM       
                   MOVE LENGTH OF A4-TOWN              TO WS-MAX-SZ     
                   PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT  
               END-IF                                                   
           END-IF.                                                      
                                                                        
C37510*    MOVE WS-ADDRESS           TO RS-ADDRESS.                             
                                                                        
C37510     MOVE WS-ADDRESS           TO WS-EMB-INPUT.                   
C37510     MOVE 81                   TO WS-EMB-LENG.                    
C37510     MOVE SPACES               TO WS-CMP-TABLE.                   
C37510     PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT.          
C37510     MOVE WS-CMP-TABLE         TO RS-ADDRESS.                     
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2610-BUILD-ADDR-FREE                                          *         
      *                                                               *         
      *      CONCATENATE ALL ADDRESS DETAILS INTO A SINGLE            *         
      *      STRING TO BE SENT AS RESULT SET                          *         
      *****************************************************************         
                                                                        
       2610-BUILD-ADDR-FREE.                                            
                                                                        
           MOVE SPACE TO WS-ADDRESS.                                    
           SET WS-ADD-SUB TO 1.                                         
                                                                        
           IF DZ-ADDR-STREET NOT = SPACE                                
              MOVE DZ-ADDR-STREET           TO WS-FROM                  
              MOVE LENGTH OF DZ-ADDR-STREET TO WS-MAX-SZ                
              PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT       
           END-IF.                                                      
                                                                        
           IF DZ-ADDR-CITY-STATE NOT = SPACE                            
              MOVE DZ-ADDR-CITY-STATE           TO WS-FROM              
              MOVE LENGTH OF DZ-ADDR-CITY-STATE TO WS-MAX-SZ            
              PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT       
           END-IF.                                                      
                                                                        
           IF DZ-ADDR-ZIP-CODE NOT = SPACE                              
              MOVE DZ-ADDR-ZIP-CODE             TO WS-FROM              
              MOVE LENGTH OF DZ-ADDR-ZIP-CODE   TO WS-MAX-SZ            
              PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT       
           END-IF.                                                      
                                                                        
           IF DZ-ADDR-COUNTRY    NOT = SPACE                            
              MOVE DZ-ADDR-COUNTRY              TO WS-FROM              
              MOVE LENGTH OF DZ-ADDR-COUNTRY    TO WS-MAX-SZ            
              PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT       
           END-IF.                                                      
                                                                        
           IF DZ-ADDRESS-OVERFLOW NOT = SPACE                           
              MOVE DZ-ADDRESS-OVERFLOW           TO WS-FROM             
              MOVE LENGTH OF DZ-ADDRESS-OVERFLOW TO WS-MAX-SZ           
              PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT       
           END-IF.                                                      
                                                                        
           MOVE WS-ADDRESS           TO RS-ADDRESS.                     
                                                                        
       2610-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 2620-ACCUMULATE-ADDRESS                                        *        
      *                                                                *        
      *     DETERMINE LENGTH OF FIELD. MOVE THAT MANY CHARACTERS ON TO *        
      *     THE FORMATTED ADDRESS FIELD.                               *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2620-ACCUMULATE-ADDRESS.                                         
                                                                        
           PERFORM                                                      
               VARYING WS-LENGTH FROM WS-MAX-SZ BY -1                   
                 UNTIL WS-LENGTH < 1                                    
                    OR WS-FROM-X (WS-LENGTH) NOT = SPACE                
           END-PERFORM.                                                 
                                                                        
           PERFORM                                                      
               VARYING WS-SUB FROM 1 BY 1                               
C37510*          UNTIL WS-SUB > WS-LENGTH OR WS-ADD-SUB-CNT = 50                
C37510           UNTIL WS-SUB > WS-LENGTH OR WS-ADD-SUB-CNT = 81        
                   MOVE WS-FROM-X (WS-SUB)                              
                        TO WS-ADDRESS-X (WS-ADD-SUB)                    
                   SET WS-ADD-SUB UP BY 1                               
                   ADD +1    TO WS-ADD-SUB-CNT                          
           END-PERFORM.                                                 
                                                                        
           SET WS-ADD-SUB UP BY 1.                                      
           ADD +1    TO WS-ADD-SUB-CNT.                                 
                                                                        
       2620-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-OPEN-AT-CRSR.                                               
           MOVE '7200'                          TO ACTIVE-PARAGRAPH.    
      ******************************************************************04400001
      *  OPEN THE CURSOR DECLARED FOR CSS_ACCOUNT TABLE                *04420001
      ******************************************************************04450001
           EXEC SQL                                                     
               OPEN AT_CRSR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 04490001
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 04510001
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
             ELSE                                                       
REARCH         MOVE 'CSR02192'              TO ABEND-PROGRAM            
               MOVE '7200'                  TO ACTIVE-PARAGRAPH         
               MOVE 'OPEN'                  TO ABEND-FUNCTION           
               MOVE 'CSS_ACCOUNT'           TO TABLE-1                  
CBSI           MOVE 'BNKRPT_CASE_NO'        TO TABLE-ELEMENT-1          
               MOVE AT-BNKRPT-CASE-NO       TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04681001
      ******************************************************************04710001
      *  FETCH THE CURSOR DECLARED FOR CSS_CUST_PLAN    TABLE.         *04730001
      ******************************************************************04770001
       7210-FETCH-AT-CRSR.                                              
           MOVE '7210'   TO ACTIVE-PARAGRAPH.                           
                                                                        
           EXEC SQL                                                     
               FETCH AT_CRSR                                            
               INTO :AT-ACCOUNT-NO,                                     
                    :AT-BANKRUPTCY-IND,                                 
                    :AT-CUSTOMER-NO,                                    
                    :AT-PREMISE-NO,                                     
                    :AT-ADDRESS-FORMAT,                                 
                    :AT-ACCOUNT-TYPE-CODE                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 04990001
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 05010001
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
                                          NOT-FOUND                     
                 NEXT SENTENCE                                          
             ELSE                                                       
REARCH         MOVE 'CSR02192'              TO ABEND-PROGRAM            
               MOVE '7210'                  TO ACTIVE-PARAGRAPH         
               MOVE 'FETCH'                 TO ABEND-FUNCTION           
               MOVE 'CSS_ACCOUNT'           TO TABLE-1                  
CBSI           MOVE 'BNKRPT_CASE_NO'        TO TABLE-ELEMENT-1          
               MOVE AT-BNKRPT-CASE-NO       TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
       7210-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05170001
       7220-CLOSE-AT-CRSR.                                              
           MOVE '7220'                          TO ACTIVE-PARAGRAPH.    
      ******************************************************************05190001
      *                                                                *05200001
      *  CLOSE THE CURSOR DECLARED FOR CSS_CUST_PLAN TABLE.            *05210001
      ******************************************************************05250001
           EXEC SQL                                                     
               CLOSE AT_CRSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 05290001
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 05310001
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
             ELSE                                                       
REARCH         MOVE 'CSR02192'              TO ABEND-PROGRAM            
               MOVE '7220'                  TO ACTIVE-PARAGRAPH         
               MOVE 'CLOSE'                 TO ABEND-FUNCTION           
               MOVE 'CSS_ACCOUNT'           TO TABLE-1                  
CBSI           MOVE 'BNKRPT_CASE_NO'        TO TABLE-ELEMENT-1          
               MOVE AT-BNKRPT-CASE-NO       TO HOSTVAR-ELEMENT-1        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
       7220-EXIT.                                                       
           EXIT.                                                        
      *                                                                 05471001
HPCCDM*EJECT                                                                    
      ******************************************************************        
      *   7300-SELECT-DQ-ROW.                                          *        
      *                                                                *        
      *   THIS PARAGRAPH IS USED TO OBTAIN THE SELECTED ROW FROM THE   *        
      *   CSS_NAME TABLE                                            *           
      ******************************************************************        
       7300-SELECT-DQ-ROW.                                              
           MOVE '7300'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
             SELECT  DQ.FULL_NAME,                                      
                     DQ.NAME_FORMAT,                                    
                     DQ.LAST_NAME,                                      
                     DQ.FIRST_NAME,                                     
                     DQ.MIDDLE_NAME,                                    
                     DQ.TITLE_PREFIX,                                   
                     DQ.TITLE_SUFFIX_1,                                 
                     DQ.TITLE_SUFFIX_2,                                 
                     HT.ADDRESS_ID                                      
               INTO  :DQ-FULL-NAME,                                     
                     :DQ-NAME-FORMAT,                                   
                     :DQ-LAST-NAME,                                     
                     :DQ-FIRST-NAME,                                    
                     :DQ-MIDDLE-NAME,                                   
                     :DQ-TITLE-PREFIX,                                  
                     :DQ-TITLE-SUFFIX-1,                                
                     :DQ-TITLE-SUFFIX-2,                                
                     :HT-ADDRESS-ID                                     
               FROM  CSS_NAME DQ WITH(READUNCOMMITTED),                         
                     CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)                
              WHERE  HT.ACCOUNT_NO       = :HT-ACCOUNT-NO               
                AND  HT.NAME_ID          = DQ.NAME_ID                   
                AND  HT.CUSTOMER_ROLE_CD = ' '                          
                AND  DQ.NAME_TYPE        = 'CN'                         
A00755                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  DQ.FULL_NAME,                                              
MFA-TR*              DQ.NAME_FORMAT,                                            
MFA-TR*              DQ.LAST_NAME,                                              
MFA-TR*              DQ.FIRST_NAME,                                             
MFA-TR*              DQ.MIDDLE_NAME,                                            
MFA-TR*              DQ.TITLE_PREFIX,                                           
MFA-TR*              DQ.TITLE_SUFFIX_1,                                         
MFA-TR*              DQ.TITLE_SUFFIX_2,                                         
MFA-TR*              HT.ADDRESS_ID                                              
MFA-TR*        INTO  :DQ-FULL-NAME,                                             
MFA-TR*              :DQ-NAME-FORMAT,                                           
MFA-TR*              :DQ-LAST-NAME,                                             
MFA-TR*              :DQ-FIRST-NAME,                                            
MFA-TR*              :DQ-MIDDLE-NAME,                                           
MFA-TR*              :DQ-TITLE-PREFIX,                                          
MFA-TR*              :DQ-TITLE-SUFFIX-1,                                        
MFA-TR*              :DQ-TITLE-SUFFIX-2,                                        
MFA-TR*              :HT-ADDRESS-ID                                             
MFA-TR*        FROM  CSS_NAME DQ,                                               
MFA-TR*              CSS_NAME_ACCT_XREF HT                                      
MFA-TR*       WHERE  HT.ACCOUNT_NO       = :HT-ACCOUNT-NO                       
MFA-TR*         AND  HT.NAME_ID          = DQ.NAME_ID                           
MFA-TR*         AND  HT.CUSTOMER_ROLE_CD = ' '                                  
MFA-TR*         AND  DQ.NAME_TYPE        = 'CN'                                 
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                       OR NOT-FOUND                     
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CBSI          MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_NAME'           TO TABLE-1                      
CBSI          MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-2                      
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE HT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7300-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
                                                                        
      ****************************************************************          
      * 7400-SELECT-ADDR-FORM                                        *          
      *                                                              *          
      *      SELECT FROMATTED ADDRESS FOR THE ACCOUNT                *          
      ****************************************************************          
                                                                        
       7400-SELECT-ADDR-FORM.                                           
                                                                        
           EXEC SQL                                                     
               SELECT HOUSE_NO,                                         
                      ADDR_PREFIX_1,                                    
                      ADDR_PREFIX_2,                                    
                      STREET_NAME,                                      
                      ADDRESS_OVERFLOW,                                 
                      ADDR_USAGE_CD,                                    
                      STREET_SUFFIX,                                    
                      STREET_LOCATION_1,                                
                      STREET_LOCATION_2,                                
                      ZIP_CODE,                                         
                      ZIP_CODE_TOKEN                                    
               INTO   :DY-HOUSE-NO,                                     
                      :DY-ADDR-PREFIX-1,                                
                      :DY-ADDR-PREFIX-2,                                
                      :DY-STREET-NAME,                                  
                      :DY-ADDRESS-OVERFLOW,                             
                      :DY-ADDR-USAGE-CD,                                
                      :DY-STREET-SUFFIX,                                
                      :DY-STREET-LOCATION-1,                            
                      :DY-STREET-LOCATION-2,                            
                      :DY-ZIP-CODE,                                     
                      :DY-ZIP-CODE-TOKEN                                
                 FROM CSS_ADDR_FORMATTED WITH(READUNCOMMITTED)                  
                WHERE ADDRESS_ID = :DY-ADDRESS-ID                       
A00755                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT HOUSE_NO,                                                 
MFA-TR*               ADDR_PREFIX_1,                                            
MFA-TR*               ADDR_PREFIX_2,                                            
MFA-TR*               STREET_NAME,                                              
MFA-TR*               ADDRESS_OVERFLOW,                                         
MFA-TR*               ADDR_USAGE_CD,                                            
MFA-TR*               STREET_SUFFIX,                                            
MFA-TR*               STREET_LOCATION_1,                                        
MFA-TR*               STREET_LOCATION_2,                                        
MFA-TR*               ZIP_CODE,                                                 
MFA-TR*               ZIP_CODE_TOKEN                                            
MFA-TR*        INTO   :DY-HOUSE-NO,                                             
MFA-TR*               :DY-ADDR-PREFIX-1,                                        
MFA-TR*               :DY-ADDR-PREFIX-2,                                        
MFA-TR*               :DY-STREET-NAME,                                          
MFA-TR*               :DY-ADDRESS-OVERFLOW,                                     
MFA-TR*               :DY-ADDR-USAGE-CD,                                        
MFA-TR*               :DY-STREET-SUFFIX,                                        
MFA-TR*               :DY-STREET-LOCATION-1,                                    
MFA-TR*               :DY-STREET-LOCATION-2,                                    
MFA-TR*               :DY-ZIP-CODE,                                             
MFA-TR*               :DY-ZIP-CODE-TOKEN                                        
MFA-TR*          FROM CSS_ADDR_FORMATTED                                        
MFA-TR*         WHERE ADDRESS_ID = :DY-ADDRESS-ID                               
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                         OR NOT-FOUND                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7400'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ADDR_FORMATTED' TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
              MOVE DY-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7450-SELECT-ADDR-FREE                                        *          
      *                                                              *          
      *      SELECT FREE FORM ADDRESS FOR THE ACCOUNT                *          
      ****************************************************************          
                                                                        
       7450-SELECT-ADDR-FREE.                                           
                                                                        
           EXEC SQL                                                     
               SELECT ADDR_STREET, ADDR_CITY_STATE, ADDR_ZIP_CODE,      
                      ADDR_COUNTRY, ADDRESS_OVERFLOW                    
               INTO   :DZ-ADDR-STREET, :DZ-ADDR-CITY-STATE,             
                      :DZ-ADDR-ZIP-CODE, :DZ-ADDR-COUNTRY,              
                      :DZ-ADDRESS-OVERFLOW                              
                 FROM CSS_ADDR_FREEFORM WITH(READUNCOMMITTED)                   
                WHERE ADDRESS_ID = :DZ-ADDRESS-ID                       
A00755                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ADDR_STREET, ADDR_CITY_STATE, ADDR_ZIP_CODE,              
MFA-TR*               ADDR_COUNTRY, ADDRESS_OVERFLOW                            
MFA-TR*        INTO   :DZ-ADDR-STREET, :DZ-ADDR-CITY-STATE,                     
MFA-TR*               :DZ-ADDR-ZIP-CODE, :DZ-ADDR-COUNTRY,                      
MFA-TR*               :DZ-ADDRESS-OVERFLOW                                      
MFA-TR*          FROM CSS_ADDR_FREEFORM                                         
MFA-TR*         WHERE ADDRESS_ID = :DZ-ADDRESS-ID                               
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                         OR NOT-FOUND                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7450'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ADDR_FREEFORM'  TO TABLE-1                      
              MOVE 'ADDRESS_ID'         TO TABLE-ELEMENT-1              
              MOVE DZ-ADDRESS-ID        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7450-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7410-SELECT-CITY                                               *        
      *                                                                *        
      *     GET CITY BASED ON ZIP CODE & TOKEN.                        *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7410-SELECT-CITY.                                                
                                                                        
           EXEC SQL                                                     
               SELECT TOWN                                              
                 INTO :A4-TOWN                                          
                 FROM CSS_ZIP_CODE WITH(READUNCOMMITTED)                        
                WHERE ZIP_CODE       = :DY-ZIP-CODE                     
                  AND ZIP_CODE_TOKEN = :DY-ZIP-CODE-TOKEN               
A00755                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT TOWN                                                      
MFA-TR*          INTO :A4-TOWN                                                  
MFA-TR*          FROM CSS_ZIP_CODE                                              
MFA-TR*         WHERE ZIP_CODE       = :DY-ZIP-CODE                             
MFA-TR*           AND ZIP_CODE_TOKEN = :DY-ZIP-CODE-TOKEN                       
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                   MOVE SPACE TO A4-TOWN                                
               ELSE                                                     
                   MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
                   MOVE '7410'                 TO ACTIVE-PARAGRAPH      
                   MOVE 'SELECT'               TO ABEND-FUNCTION        
                   MOVE 'CSS_ZIP_CODE'         TO TABLE-1               
                   MOVE 'ZIP_CODE'             TO TABLE-ELEMENT-1       
                   MOVE 'ZIP_CODE_TOKEN'       TO TABLE-ELEMENT-2       
                   MOVE DY-ZIP-CODE            TO HOSTVAR-ELEMENT-1     
                   MOVE DY-ZIP-CODE-TOKEN      TO HOSTVAR-ELEMENT-2     
                   PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
                   PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
               END-IF                                                   
           END-IF.                                                      
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7600-SELECT-N9-ROW.                                          *        
      *                                                                *        
      *   THIS PARAGRAPH IS USED TO OBTAIN THE SELECTED ROW FROM THE   *        
ACT282*   CSS_SO_CODE_DESC TABLE *                                              
      ******************************************************************        
       7600-SELECT-N9-ROW.                                              
           MOVE '7600'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
ACT282       SELECT  CODE_LONG_DESC                                     
ACT282         INTO  :SW-CODE-LONG-DESC                                 
ACT282         FROM  CSS_SO_CODE_DESC WITH(READUNCOMMITTED)                     
ACT282        WHERE  CODE_VALUE = :SW-CODE-VALUE                        
ACT282          AND  TABLE_NA   = 'CSS_ACCOUNT'                         
ACT282          AND  COLUMN_NA  = 'ACCOUNT_TYPE_CODE'                   
ACT282          AND  PROGRAM_ID = 'ALL'                                 
ACT282          AND  COMPANY_NO = '01'                                  
A00755                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  CODE_LONG_DESC                                             
MFA-TR*        INTO  :SW-CODE-LONG-DESC                                         
MFA-TR*        FROM  CSS_SO_CODE_DESC                                           
MFA-TR*       WHERE  CODE_VALUE = :SW-CODE-VALUE                                
MFA-TR*         AND  TABLE_NA   = 'CSS_ACCOUNT'                                 
MFA-TR*         AND  COLUMN_NA  = 'ACCOUNT_TYPE_CODE'                           
MFA-TR*         AND  PROGRAM_ID = 'ALL'                                         
MFA-TR*         AND  COMPANY_NO = '01'                                          
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                       OR NOT-FOUND                     
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CBSI          MOVE 'SELECT'             TO ABEND-FUNCTION               
ACT282             MOVE 'CSS_SO_CODE_DESC'     TO TABLE-2               
ACT282             MOVE 'CODE_VALUE'           TO TABLE-ELEMENT-1       
ACT282             MOVE 'TABLE_NA'             TO TABLE-ELEMENT-2       
ACT282             MOVE 'COLUMN_NA'            TO TABLE-ELEMENT-3       
ACT282             MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-4       
ACT282             MOVE SW-CODE-VALUE          TO HOSTVAR-ELEMENT-1     
ACT282             MOVE 'CSS_ACCOUNT'          TO HOSTVAR-ELEMENT-2     
ACT282             MOVE 'ACCOUNT_TYPE_CODE'    TO HOSTVAR-ELEMENT-3     
ACT282             MOVE '01'                   TO HOSTVAR-ELEMENT-4     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7600-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
REARCH******************************************************************        
REARCH*8000A-DELETE-GTT-ROWS                                           *        
REARCH******************************************************************        
REARCH 8000A-DELETE-GTT-ROWS.                                           
REARCH*                                                                         
REARCH     MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.          
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH          DELETE FROM #CSR02192_R1                         
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM SESSION.CSR02192_R1                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
REARCH*                                                                         
REARCH     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
REARCH         NEXT SENTENCE                                            
REARCH     ELSE                                                         
REARCH        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
REARCH        MOVE SQLCODE               TO ABEND-SQLCODE               
REARCH        MOVE '8000A'               TO ACTIVE-PARAGRAPH            
REARCH        MOVE 'DELETE'              TO ABEND-FUNCTION              
REARCH        MOVE SPACES                TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH        MOVE 'CSR02192_R1'         TO TABLE-1                     
REARCH        MOVE SPACES                TO TABLE-ELEMENT-1             
REARCH        MOVE SPACES                TO HOSTVAR-ELEMENT-1           
REARCH        PERFORM 9000-SEND-ERROR-RESULT                            
REARCH                                   THRU 9000-EXIT                 
REARCH        PERFORM 9900-SQL-ERROR-ROUTINE                            
REARCH                                   THRU 9900-EXIT                 
REARCH     END-IF.                                                      
REARCH 8000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH******************************************************************        
REARCH*8100-SEND-RESULT                                                *        
REARCH******************************************************************        
REARCH 8100-SEND-RESULT.                                                
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH          INSERT INTO #CSR02192_R1                         
REARCH          (                                                       
REARCH               RETURN_CODE                                        
REARCH              ,NAME                                               
REARCH              ,ACCT_TYPE_DESC                                     
REARCH              ,ACCOUNT_NO                                         
REARCH              ,CUSTOMER_NO                                        
REARCH              ,ADDRESS                                            
REARCH              ,BNKRPT_IND                                         
REARCH              ,PREMISE_NO                                         
REARCH              ,ACCT_TYPE                                          
REARCH          )                                                       
REARCH          VALUES                                                  
REARCH          (                                                       
REARCH               :S-RETURN-CODE                                     
REARCH              ,:S-NAME                                            
REARCH              ,:S-ACCT-TYPE-DESC                                  
REARCH              ,:S-ACCOUNT-NO                                      
REARCH              ,:S-CUSTOMER-NO                                     
REARCH              ,:S-ADDRESS                                         
REARCH              ,:S-BNKRPT-IND                                      
REARCH              ,:S-PREMISE-NO                                      
REARCH              ,:S-ACCT-TYPE                                       
REARCH          )                                                       
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR02192_R1                                 
MFA-TR*         (                                                       01670000
MFA-TR*              RETURN_CODE                                        01670000
MFA-TR*             ,NAME                                                       
MFA-TR*             ,ACCT_TYPE_DESC                                             
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,CUSTOMER_NO                                                
MFA-TR*             ,ADDRESS                                                    
MFA-TR*             ,BNKRPT_IND                                                 
MFA-TR*             ,PREMISE_NO                                                 
MFA-TR*             ,ACCT_TYPE                                                  
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                       01670000
MFA-TR*              :S-RETURN-CODE                                     01670000
MFA-TR*             ,:S-NAME                                                    
MFA-TR*             ,:S-ACCT-TYPE-DESC                                          
MFA-TR*             ,:S-ACCOUNT-NO                                              
MFA-TR*             ,:S-CUSTOMER-NO                                             
MFA-TR*             ,:S-ADDRESS                                                 
MFA-TR*             ,:S-BNKRPT-IND                                              
MFA-TR*             ,:S-PREMISE-NO                                              
MFA-TR*             ,:S-ACCT-TYPE                                               
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH                                                                  
REARCH*                                                                         
REARCH     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
REARCH*                                                                         
REARCH     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
REARCH          ADD +1                    TO CTR-ROWS                   
REARCH     ELSE                                                         
REARCH          MOVE PROGRAM-NAME         TO ABEND-PROGRAM              
REARCH          MOVE SQLCODE              TO ABEND-SQLCODE              
REARCH          MOVE '8100'               TO ACTIVE-PARAGRAPH           
REARCH          MOVE 'INSERT'             TO ABEND-FUNCTION             
REARCH          MOVE SPACES               TO ABEND-SQL-PREDICATES       
REARCH                                       ABEND-TABLES               
REARCH          MOVE 'CSR02192_R1'        TO TABLE-1                    
REARCH          MOVE SPACES               TO TABLE-ELEMENT-1            
REARCH          MOVE SPACES               TO HOSTVAR-ELEMENT-1          
REARCH          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH 8100-EXIT.                                                       
REARCH     EXIT.                                                        
REARCH*                                                                         
                                                                        
C37510******************************************************************        
C37510* 6010- REDUCE EMBEDDED SPACES                                            
C37510******************************************************************        
C37510     COPY CPD00004.                                                       
      *                                                                         
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
REARCH     EXEC SQL                                                             
REARCH          INCLUDE CPDSP300                                                
REARCH     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
REARCH     EXEC SQL                                                             
REARCH          INCLUDE CPD00320                                                
REARCH     END-EXEC.                                                            
