       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR02189.                                     
COB303 DATE-WRITTEN.                                                    
COB303            DECEMBER 21, 1995.                                    
       DATE-COMPILED.                                                   
                                                                        
      *****************************************************************         
      *                SOUTH CAROLINA ELECTRIC & GAS *                          
      *                                                               *         
      *****************************************************************         
      *                 P R O G R A M  S U M M A R Y                            
      *                                                                         
      *  THIS PROGRAM INSERTS OR UPDATES THE                                    
      *  NSF CHECK HISTORY FOR A BATCH FOR A BANK AND ALSO UPDATES              
      *  AR CNTL TABLE AND DOES AR JOURNALING                                   
      *                                                                         
      *****************************************************************         
      *                     PROGRAM MODIFICATION LOG                            
      *                                                                         
      *    DATE    INITIALS   COMMENTS                                          
      *  --------  --------   ---------------------------------------           
      *  12/21/95    SS       CREATED.                                          
      *  03/13/96    SS       FCS/GL CHANGES                                    
      *  07/17/96    SONALI   TPR#4557                                          
      *                       SEND-NOTICE FIELD SHOULD BE DEFAULTED             
      *                       TO 'Y'                                            
      *  07/29/96    SONALI   TPR#5022                                          
      *                       WHEN CREATING NSC AND NSA, AR TRANS HIST          
      *                       ROW HAD THE WRONG AMT IN THE HEADER.              
      *                       IT DID NOT INCLUDE THE NSC CHARGE.                
      *  10/10/96    MRB      PCR #136 - ADD CODE TO CHECK THE NOTICE           
      *                       EXEMPT CODE FOR ACCOUNTS THAT ARE EXEMPT          
      *                       FROM NOTICE (EXCEPT CURRENT MONTH NORMAL          
      *                       ('A') AND UPDATE THE SEND NOTICE FLAG ON          
      *                       CSS_NSF_HIST TABLE PRIOR TO THE SEND              
      *                       NOTICE FLAG CHECK (SEE PCR #263).  IF THE         
      *                       NOTICE FLAG IS 'N' AND THE NOTICE IS NOT          
      *                       YET SENT, THEN AN 'E' SHOULD BE MF 5776-          
      *                       THE EXCEPTIONAL DISCONNECT HISTORY FIELD          
      *                       AND THE CSS_CRED_PROFILE TABLE SHOULD BE          
      *                       UPDATED.                                          
      *                       PCR #263 - ADDED MERGE LOGIC FOR                  
      *                       FORECASTED CREDIT ACTION AS WELL AS THE           
      *                       NEW CREDIT COLLECTION ROW TYPE 'N'                
      *                       (RETURNED CHECK NOTICE).                          
      *                       PCR #361 - ADDED LOGIC FOR THE INCLUSION          
      *                       OF THE NEW CPD00068 COPYLIB.                      
      *                       ALSO ADDED BUSINESS DATE LOGIC TO THIS            
      *                       PROGRAM.                                          
      *  12/11/96    PD       TP8018 - GETTING THE JOURNALS RIGHT.              
      *  02/03/97    RPG      TP8927 - IN THE JRNL UPDATE, MOVED      *         
      *                       SPACES TO CURRENCY TYPE ON A RET. CHK.  *         
      *  02/05/97    RPG      TP8741                                  *         
      *                       CHANGED MODULE 7900 TO NOT ABEND WHEN   *         
      *                       RECORD NOT FOUND                        *         
TP9474*  02/24/97    KOG      TP9474-INITIALIZE CJF00101.             *         
TP5033*  03/04/97    CSS      ADD MULTIPLE CHECK PROCESSING ACCORDING *         
      *                       PCR412/TPR5033 DESIGN                   *         
      *  03/21/97    EMM      PCR412/TPR5033 DESIGN                             
      *                                                                         
TP9685*  03/17/97    CHANDRA  STATUS CODE 'D' IS MOVED TO             *         
TP9685*                       BE-STATUS-CODE INSTEAD OF 'B'           *         
TP9685*                       D => CANCELLED  // B => PRO-NOTE        *         
TP9573*  03/17/97    CHANDRA  IF 'NH-NSF-CHARGE-AMT' > 0, THEN        *         
TP9573*                       SET WS-CODE-NSF-CHK-CHG TO UPDATE       *         
TP9573*                       CODES-DATA-PRESENT COLUMN OF THE        *         
TP9573*                       ACCOUNT TABLE                           *         
      *  03/31/97    MJG      ADDED TWO MORE DCLEGENS BECAUSE OF      *         
      *                       CHANGES MADE TO CPD00068                *         
T10101*  04/04/97    EMM      CHANGED 7900- WHEN SUCCESSFUL CALL      *         
      *                       SHOULD NOT MOVE ZEROES TO AR-AMT-ORIG-  *         
      *                       ENTERED.                                *         
T10339*  04/14/97    EMM      EVALUATED NH-NSF-TYPE-CD, IF 'C' MOVED  *         
      *                       PANEL181A, ELSE MOVE PANEL181B.         *         
T10351*  04/16/97    EMM      CHANGED OVERAGE SHORTAGE TO A 101       *         
      *                       JOURNAL. INCORPORATED CWS00061.         *         
T10527*  04/22/97    EMM      MERGE WITH EXCEPTIONAL IN 5340- MOVING  *         
      *                       WS-DATE-NOTICE-MAIL-F.                  *         
T10595*  04/25/97    EMM      MOVED 0 TO WS-101-DETAIL-END-AR-BAL     *         
      *                       RETURNED CHECK SHOULD NOT CONTAIN VALUES*         
      *                       IN THE DETAIL RECEIVABLE BALANCE.       *         
T11621*  06/11/97    EMM      MOVE 9999999999 TO CUSTOMER NO WHEN     *         
      *                       WRITING CASH OVERAGE/SHORTAGE JOURNAL.  *         
T11757*  06/25/97    EMM      CHANGED PARA 5320-UPDATE-CRED-ACTION    *         
      *                       TO CHECK FOR A NON-UTILITY ACCOUNT BY   *         
      *                       CHECKING  WS-CODE-BUDGET = ' ' AND      *         
      *                       WS-CODE-UTL = ' ' AND AT-CODE-ACCT-STAT *         
      *                       = 'A'.                                  *         
T12285* 07/30/97     EMS      IF AN ACTIVE MEDICAL CERTIFICATE EXISTS *         
      *                       A 90205 NOTICE IS FORECAST.             *         
T12460* 08/01/97     EMS      ADDED CSS_DNP DCLGEN FOR CPD68          *         
      *                       PROCESSING.                             *         
T12880* 08/21/97     EMS      ACCOUNT WITH ACTIVE MEDICAL CERTIFICATE *         
      *                       RECEIVES 90206 NOTICE                   *         
T13031* 09/11/97     EMS      POPULATED WS-JRNL-CASH-VALUES CORRECTLY *         
      *                       TO BALANCE THE GENERAL LEDGER CORRECTLY.*         
T13899* 11/25/97     EMS      UPDATE THE TRANSACTION HISTORY WITH     *         
      *                       THE DATE OF THE ORIG PAYMENT IN         *         
      *                       AR-DATE-ORIG-PYMT.                      *         
T13933* 11/26/97     EMS      CHANGED HOW NON-UTILITY ACCOUNTS ARE    *         
      *                       IDENTIFIED.                             *         
T13945* 12/03/97     EMS      IF ACCOUNT IS ON BANK DRAFT WITH NO     *         
      *                       OTHER RETURNED CHECKS/DRAFTS, THE       *         
      *                       MESSAGE NUMBER SHOULD EQUAL 90208.      *         
PCR613* 03/24/98     EMS      ADDED NH-BANK-ID TO WS-101-BANK-ID.     *         
      * 05/06/98              CHANGED TO JOURNAL FIELD CASH FIELDS.   *         
PCR628* 04/30/98     PD       DELETED CODE FOR JOURNALLING OVERAGE/   *         
PCR628*                       SHORTAGE.                               *         
CBSI  *  09/22/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE   *         
CBSI  *              MADRAS   ABEND PARAMETERS                        *         
T18281* 12/22/1998   YU (CDI) 'N' WAS NOT MOVED TO CODE-NOTICE-TYPE   *         
T18281*                       BEFORE POPULATING THE 'N' ROW           *         
T18796* 01/05/1999   YU (CDI) CHANGE IN MERGE FORECAST LOGIC          *         
T19074* 02/04/1999   MDJ      IF ROW F CODE-SPECIAL-TYPE = A, C, OR S *         
T19074*                       ALLOW THE MERGE.                        *         
T19117* 02/15/99     MDJ      BEFORE MERGING RETURNED CHECK WITH      *         
      *                       AMOUNT NOTICE C OR F, CHECK TO MAKE SURE*         
      *                       C OR  F NOTICE AMOUNT > 0.              *         
T19504* 03/23/99     VB       INSERT A ROW IN CSS_NSF_HIST TABLE WHEN *         
T19504*                       THE ACCOUNT HAS TRANSFERED.             *         
T19970* 05/12/99     MDJ      INITIALIZE WS-BANK-DRAFT-REMOVED SO THAT*         
      *                       WS-CODE-BANK-EFT IS NOT INCORRECTLY SET *         
      *                       TO SPACE WHEN EFT IS NOT CANCELLED.     *         
T19968* 05/18/99     MDJ      IN MERGE LOGIC, TO DETERMINE IF CODE-   *         
      *                       NOTICE-TYPE-C OR F EXISTS ON CSS_CRED_COLL        
      *                       WS-DATE-NOTICE-MAIL WILL BE CHECKED     *         
      *                       INSTEAD OF WS-AMOUNT-NOTICE   BECAUSE   *         
      *                       THIS COULD BE 0 AND THE ROW STILL EXIST.*         
T20067* 05/25/99     MDJ      CHANGE MADE TO INITIALIZE CL-ITEM-ID    *         
      *                       BEFORE UPDATING 'D' OR 'G' ROW ON       *         
      *                       CSS_CRED_COLL.                          *         
T20655* 09/20/99     MDJ      ALLOW MERGE WHEN CODE-SPECIAL-TYPE ON   *         
      *                       EXCEPTIONAL CREDIT ACTION ROW  = 'B'.   *         
      *                       WHEN A ROW 'N' EXISTS, ON UPDATE, DATE  *         
      *                       DUE N, DATE MAIL N AND DATE BILL DAY N  *         
      *                       SHOULD BE UPDATED W/ CURRENT VALUES.    *         
      *                       WHEN ROW 'N' IS INSERTED, LOW VALUES    *         
      *                       SHOULD BE MOVED TO DATE-CREDIT-ACTION.  *         
T21109* 02/02/00     CBSI     CALL SUBROUTINE SCSCA182 TO ADD         *         
T21109*              MADRAS   DATE/TIMESTAMP CHECK FUNCTIONALITY      *         
T19557* 03/28/00     CBSI     COPYBOOK CDP00068 CHANGED TO SUB PROGRAM*         
T19557*              MADRAS   SCSCO068.                               *         
T22332* 06/15/00     ZB17046  ADDED CHANGE TO UPDATE THE DATE-BILL    *         
T22332*                       SO THAT CPD00068 WOULD CORRECTLY MERGE  *         
T22332*                       RETURN CHECK AND SECOND NOTICE.         *         
T22359* 06/23/00     ZB17046  MADE CHANGES TO KEEP IDENTITY OF PROGRAM*         
T22359*                       CALLING SCSCO068 OR SCSCB068.  THERE IS *         
T22359*                       SPECIFIC LOGIC IN CPD00068 FOR CERTAIN  *         
T22359*                       PROGRAMS WHICH WAS NOT BEING EXECUTED   *         
T22359*                       PROPERLY BECAUSE THE PROGRAM NAME WAS   *         
T22359*                       ALWAYS SCSCO068 OR SCSCB068.            *         
T21963* 07/10/00     ZB17046  CHANGES FOR UTILITY/NON-UTILITY PROJECT.*         
T22450* 07/11/00     CBSI     DATE/TIME STAMP CHECK LOGIC HAD BEEN    *         
T22450*              MADRAS   REMOVED OUT COMMANDED T21109            *         
T23501** 03/01/01    SS82048  DELINQUENCY TABLE CHANGES TO SUPPORT    *         
      **                      MULTI-COMPANY AND PSNC CONVERSION       *         
T23637** 03/26/01    SK88120  CHANGES FOR PSNC CONVERSION             *         
      ** 05/01/01    CK88151  MCR310 PSNC.  CSS_GL_ACCT_NO CHANGES.   *         
T22767** 05/28/01    SA83503  ENTER A ROW FOR NON CIS RETURN CHECK    *         
T23637** 06/12/01    SK88120  CHANGES FOR PSNC CONVERSION             *         
T22767** 07/01/01    SA83503  ADDITION TO NON-CIS-RTN-CHK A ROW IS    *         
T22767**                      INSERTED FOR BANK-TRANSFER              *         
T24952** 09/10/01    SK88120  DELETING PREV V-ROWS (IF EXISTING)      *         
T24982** 09/10/01    SK88120  WIPE OUT DUE DATE ONLY FOR SCEG ACCOUNTS*         
      ** 09/13/01    SK88120  DONT MOVE SPACES TO CREDIT ACTION DATE  *         
      **                      FOR PSNC ACCOUNTS                       *         
T22767** 10/05/01    BASKAR   FIX THE PROBLEM IN BANK TRANSFER AMOUNT *         
T22767** 10/12/01    BASKAR   FIX THE JOURNAL PROBLEM. MOVED NONCIS   *         
T22767**                      GL ACCT TO JOURNAL.                     *         
C25923** 02/20/02    BASKAR   1.ADD CASH REPORT FOR CASH LOCAL OFFICE,*         
C25923**                      2.DO ONE BANK TRANSFER PER RETURN CHECK *         
C25923**                      3.MOVE CURRENCY TYPE                    *         
T25923** 02/25/02    SS19371  ADDING FIELDS TO BE STORED FOR TREASURY *         
T25923**                      BALANCING; ADD BACK OVERAGE/SHORTAGE    *         
T25923**                      JOURNALING AND INSERT INTO OVERSHORT    *         
T25923**                      HEADER AND DETAIL TABLES                *         
C26954** 07/22/02    SFH      CHANGES MADE FOR SEB REGULATED PROVIDER *         
      **                      ACCOUNTS TO FORECAST 90205 NOTICE (NO   *         
      **                      DISCONNECT VERBIAGE).                   *         
T26396** 08/09/02   VD88125   ACCT SHOULD BECOME CASH ONLY WHEN 3     *         
T26396**                      RETURN CHECKS ON ACCT WITH IN 12 MONTHS *         
C26396** 09/30/02   MDJ       TO PRODUCE 90209 CORRECTLY, CHECK       *         
C26396**                      WS-CODE-BANK-EFT = 'A' AND BE-STATUS-CODE         
C26396**                      = 'D'.                                  *         
C25816** 10/17/02   MDJ       SCEG/PSNC ACCT WILL BECOME CASH ONLY    *         
C25816**                      AFTER 2 RET CHKS INSTEAD OF THE CURRENT *         
C25816**                      3.  RETURNED DRAFTS WILL REMAIN AT 3.   *         
C25816**                      SEB ACCOUNTS WILL BECOME CASH ONLY AND  *         
C25816**                      BE REMOVED FROM DRAFTS AFTER 3.         *         
C25816** 11/20/02   SS19371   REMOVING COMPANY CHECK BEFORE RETRIEVING*         
C25816**                      AMT-CHECKCHARGE FROM CSS_DELINQUENCY    *         
C28788** 07/03/03   MDJ       GET IVR-EXEMPT-CD FOR CPD00068.         *         
REARCH** 07/16/03   AD88124   RPC CONVERTED TO COBOL SP.              *         
C28788** 08/06/03   AD88124   1) IN 5340- THE LOGIC FOR PSNC TO MERGE *         
      **                         RETURN CHECK AMOUNT IS COMMENTED.    *         
      **                      2) FOR PSNC ACCOUNTS, ALLOW INSERTION OF*         
      **                        'H' ROWS IN 5362-INSRT-H-SUM-ROW.     *         
PRDFIX** 10/22/03   BASKAR    FIX THE PROD PROBLEM                    *         
T29852** 10/27/03   VIJAY     FIX RETURN CHECK REPORT ISSUE.          *         
C31110** 08/04/04   SS19371   FIX NON-CIS FIRST CHECK ISSUE.          *         
C31110**                      ALSO FIXED INDENTIONS TO FOLLOW IF LOGIC*         
C31110**                      MORE EASILY                             *         
C26296** 01/20/05   SS82048   1.ADD SEND-NOTICE-CD AS A PARAMETER     *         
C26296**                      2.CALL CSR03515 TO CHARGE A AUTO DEPOSIT*         
T32545*  09/10/05   JC91900   ADDED LOGIC TO CALCULATE IVR CALL DATE  *         
T32545*                       UPON POSTING OF RETURN CHECK.        .  *         
C30881*  10/12/05   BASKAR V  INCREASE NSF-REASON-CD LENGTH           *         
T32545*  11/17/05   BASKAR V   ADDED LOGIC TO DETERMINE THE TYPE OF   *         
T32545*                        ACCOUNT, RESID VS. COMM.               *         
C30881*  12/07/05   BASKAR V  DON'T ABEND IF NO ROW FOUND IN          *         
C30881*                       CSS_UTIL_ENVRNMT TABLE FOR AN ACCOUNT   *         
C35824*  06/07/07   AP40911   UPDATE CASH ONLY COMMENTS WHEN CASH ONLY*         
      *                       FLAG IS UPDATE.                         *         
C35824*  01/18/08   AP40911   MISTAKENLY UNCOMMENTED SOME CODE SO     *         
      *                       COMMENTED THEM.                         *         
A00956*  03/26/09   VP94820   REPLACE CPD00006 WITH CPD0006A AND      * 01503330
A00956*                       CWS00013 WITH CWS0013B.                 * 01503330
A37061*  04/07/09   SJ97149  1.REPLACE CODE_REV_CLASS MID DIGIT CHECK *         
A37061*                        WITH CSS_ACCOUNT.ACCOUNT_TYPE_CODE FOR *         
A37061*                        GETTING TYPE OF THE ACCOUNT.           *         
A37061*                      2.ADDED "ROWSET POSITIONING FOR GLOBAL"  *         
A37061*                        TEMPERARY TABLES.                      *         
A01376*  10/28/09   MJ13662  WHEN RET CHECK MERGES W/ OTHER           *         
A01376*                      CREDIT ACTION, ALSO MOVE SPACES TO DATE- *         
A01376*                      CREDIT ACTION (IVR DATE) ON THE NOTICE   *         
A01376*                      ROWS (N,V,W).                            *         
P00471*  04/11/11   MELISSA JOHNSON IF CODE-SPECIAL-TYPE = 'W'        *         
P00471*             (RESCHEDULED DNP)                                 *         
P00471*             AND MERGE HAPPENS W/ EXCEPTIONAL CREDIT ACTION    *         
P00471*             UPDATE CODE-SPECIAL-TYPE TO 'T' (RES W/ RET CHK). *         
P00471*             IF DATE-NOTICE-MAIL-F (EX 2ND NOTICE) IS <=       *         
P00471*             CURRENT DATE, AND DATE-CREDIT-ACTION-G (EX DNP) > *         
P00471*             CURRENT DATE, DELTE G/X-UTIL DNP AND NON UTIL WQ  *         
P00471*             ROWS FROM CSS_CRED_COLL.  IF DATE-CREDIT-ACTION   *         
P00471*             F/U (IVR) IS > CURRENT-DATE, UPDATE DATE TO SPACES*         
P0471D*  07/18/11   MELISSA JOHNSON - FOR ALL COMPANIES, IF EXISTING  *         
P0471D*             CREDIT ACTION TYPE = U (DROPPED DPP) AND MERGE    *         
P0471D*             HAPPENS, UPDATE CODE-SPECIAL-TYPE TO 'V' (DROPPED *         
P0471D*             DPP W/ RET CHECK). IF EXISTING CREDIT ACTION TYPE *         
P0471D*             = J (NORMAL DPP) AND MERGE HAPPENS, UPDATE        *         
P0471D*             CODE-SPECIAL-TYPE TO 'K' (NORM DPP W/ RET CK).    *         
P0471A*  08/15/11   MELISSA JOHNSON - IF EX DNP TYPE = STA, SPECIAL,  *         
P0471A*             RESCHEDULED OR RES W RET CK, IF EX 2ND NOTICE MAIL*         
P0471A*             IS IN THE FUTURE, MERGE RET CHECK USING EXISTING  *         
P0471A*             RULES.                                            *         
P0471B*  09/06/11   MELISSA JOHNSON - FOR ALL EX CREDIT ACTION BESIDES*         
P0471B*             RES (W) AND RES W RET CHK (T) IF DATE-NOTICE-MAIL-F         
P0471B*             IS IN THE PAST OR DATE-NOTICE-MAIL-F > CURRENT DATE         
P0471B*             + 4 DAYS, NO MERGE, ONLY STAND-ALONE RET CHECK.   *         
P00581*  12/16/11   VENKAT VUDDANDAPU - INCREASED RETURN CHECK FEE FOR*         
P00581*                    DEREGULATED CUSTOMERS ONLY.                *         
P00599*  07/12/12   GV7A828 RETURNED CHECK PROCESSING IS CHANGED FOR  *         
P00599*                     WRITE-OFF AND FINAL-BILLED ACCOUNTS       *         
P00677*  07/24/12   VENKAT VUDDANDAPU - BASED ON THE 2012 REGULATED   *         
P00677*             PROVIDER TERM, THE RETURN CHECK FEE WILL INCREASE *         
P00677*             AS OF 9/1 FOR ALL FIXED & VARIABLE RATE CUSTOMERS *         
P00677*             REGARDLESS OF THEIR CONTRACT/RATE START DATE.     *         
P00599*  08/22/12   NS75440  INITIALIZED CL-DATE-CREDIT-ACTION TO STOP*         
P00599*                      POPULATING IVR DATE.                     *         
P0059A*  09/28/12   AS7C117  CREATE WQ WHEN A RETURN CHECK IS POSTED  *         
P0059A*                      FOR A FINAL BILL OR WRITE OFF ACCOUNT.   *         
P0599B*  01/24/13   AA97148  USE UPPER ACTION DATE INSTEAD BANK POST DT         
P00726*  05/31/13   AA97148  ADDED CANCEL CREDIT ARRANGEMENTS PROCESS.*         
ACT005*  01/13/14   bd09555  add additional select to retrieve        *         
ACT005*  A04880              codes_data_present                       *         
A04880*  04/25/14   MJ13662  INITIALIZE MH-DATE-TRANS AND CHANGED     *         
      *                      LOGIC SO FLAG WOULD BE SET CORRECTLY IN  *         
      *                      PARAGRAPH 6200-                          *         
      *                      DEFECT 3727                              *         
ACT239*  08/14/14   RB19957  ADDED NEW PARM FIELD FOR CSR03515 CHANGE.*         
P0726A*  11/11/14   VV94890  ADDED CRED ARNG HIST ROW WHEN ACTIVE ARNG*         
P0726A*                      WAS CANCELLED DUE TO RETURN CHECK.       *         
A05058*  01/23/15   RB19957  1) Cash only indicator is applied when   *         
A05058*      APPL00005058    there are 2 returned items within 12     *         
A05058*      ACT001          months for all 3 companies.              *         
A05058*                      2) Clean up WS fields and other variables*         
A05058*                      not used or not needed.                  *         
A05323*  07/06/15   MJ13662  ALL RETURNED CHECKS WILL BEHAVE AS IF FOR*         
A05323*                      AN EXEMPT CUSTOMER - NOTICE 90205, NO    *         
A05323*                      FORECASTED IVR DATE, NO DNP AND NO MERGE.*         
A05323*                      REMOVED ALL CODE NOT BEING EXECUTED.     *         
ACT063* 02/19/16    MC95456  REPLACE CSS_WQ_ITEMS_MF WITH             *         
ACT063* APPL5460             CSS_WQ_ITEMS BY CALLING MCSCB077         *         
P00935* 05/26/2016  LG41184  UPDATE COMMENTS FOR ALL RETURNED PAYMENTS*         
      *****************************************************************         
      *****************************************************************         
      *                                                                         
      *                ---- BASIC SEQUENCE STRUCTURE ----                       
      *                                                                         
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION                      
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                             
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                            
      *  3000 - 4999  NOT USED                                                  
      *  5000 - 5999  COMMON PROGRAM MODULES                                    
      *  6000 - 6999  COMMON SYSTEM MODULES                                     
      *  7000 - 7999  INPUT MODULES                                             
      *  8000 - 8999  OUTPUT MODULES                                            
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES                      
      *                                                                         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02189'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02189 STARTS HERE'.                  
                                                                        
      *****************************************************************         
      *    DB2 INCLUDES                                                         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
A01376******************************************************************        
A01376* COBOL DECLARATION FOR TABLE CSS_ACCOUNT AT                *             
A01376******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
A01376******************************************************************        
A01376* COBOL DECLARATION FOR TABLE CSS_AR_LOCKOUT AL              *            
A01376******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBARLOCK                                                  
           END-EXEC.                                                            
                                                                        
A01376******************************************************************        
A01376* COBOL DECLARATION FOR TABLE CSS_CUSTOMER CU               *             
A01376******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
                                                                        
A01376******************************************************************        
A01376* COBOL DECLARATION FOR TABLE CSS_PREMISE PR                *             
A01376******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
A01376******************************************************************        
A01376* COBOL DECLARATION FOR TABLE CSS_AR_CNTL AC                 *            
A01376******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBARCNTL                                                  
           END-EXEC.                                                            
                                                                        
A01376******************************************************************        
A01376* COBOL DECLARATION FOR TABLE CSS_RETURN_CHK RC             *             
A01376******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRETCHK                                                  
           END-EXEC.                                                            
                                                                        
A01376******************************************************************        
A01376* COBOL DECLARATION FOR TABLE CSS_GL_ACCT_NO GO             *             
A01376******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBGLATNO                                                  
           END-EXEC.                                                            
                                                                        
A01376******************************************************************        
A01376* COBOL DECLARATION FOR TABLE CSS_BANK D1                   *             
A01376******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBANK                                                    
           END-EXEC.                                                            
                                                                        
A01376******************************************************************        
A01376* COBOL DECLARATION FOR TABLE CSS_MT_TRN_HST_DET MI          *            
A01376******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
A01376******************************************************************        
A01376* COBOL DECLARATION FOR TABLE CSS_MNT_TRANS_HIST MH          *            
A01376******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
P00581******************************************************************        
P00581*   CSS_JOB_PARM       - G6                                      *        
P00581******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
                                                                        
A01376******************************************************************        
A01376* COBOL DECLARATION FOR TABLE CSS_BATCH_JRNL BJ              *            
A01376******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBTJRNL                                                  
           END-EXEC.                                                            
                                                                        
A01376******************************************************************        
A01376* COBOL DECLARATION FOR TABLE CSS_DELINQUENCY C8            *             
A01376******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
                                                                        
A01376******************************************************************        
A01376* COBOL DECLARATION FOR TABLE CSS_BANK_EFT BE               *             
A01376******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBNKEFT                                                  
           END-EXEC.                                                            
                                                                        
A01376******************************************************************        
A01376* COBOL DECLARATION FOR TABLE CSS_BCH_JRNL_CNTL BC           *            
A01376******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBJCNTL                                                  
           END-EXEC.                                                            
                                                                        
A01376******************************************************************        
A01376* COBOL DECLARATION FOR TABLE CSS_USER_PROFILE PF           *             
A01376******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
A01376******************************************************************        
A01376* COBOL DECLARATION FOR TABLE CSS_CSH_DRWR_CNTL CS          *             
A01376******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCDCNTL                                                  
           END-EXEC.                                                            
                                                                        
P00726******************************************************************        
P00726* COBOL DECLARATION FOR TABLE CSS_CRED_ARNGMENT - X1             *        
P00726******************************************************************        
P00726                                                                  
P00726     EXEC SQL                                                             
P00726        INCLUDE TBCRARNG                                                  
P00726     END-EXEC.                                                            
P0726A*                                                                         
P0726A******************************************************************06330000
P0726A* CSS_CRED_ARNG_HIST - WY                                        *06340000
P0726A******************************************************************06350000
P0726A*                                                                         
P0726A     EXEC SQL                                                             
P0726A        INCLUDE TBCRARHS                                                  
P0726A     END-EXEC.                                                            
P0726A*                                                                         
A01376******************************************************************        
A01376* COBOL DECLARATION FOR TABLE CSS_NSF_HIST NH               *             
A01376******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBNSFHST                                                  
           END-EXEC.                                                            
                                                                        
A01376******************************************************************        
A01376* COBOL DECLARATION FOR TABLE CSS_CRED_COLL CL               *            
A01376******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCRCOLL                                                  
           END-EXEC.                                                            
                                                                        
A01376******************************************************************        
A01376* COBOL DECLARATION FOR TABLE CSS_CREDIT_PROFILE CZ         *             
A01376******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCRPROF                                                  
           END-EXEC.                                                            
                                                                        
A01376******************************************************************        
A01376* COBOL DECLARATION FOR TABLE CSS_CSH_DRWR_JRNL CJ          *             
A01376******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCDJRNL                                                  
           END-EXEC.                                                            
                                                                        
A01376******************************************************************        
A01376* COBOL DECLARATION FOR TABLE CSS_MISC_JRNL MJ               *            
A01376******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMSJRNL                                                  
           END-EXEC.                                                            
                                                                        
A01376******************************************************************        
A01376* COBOL DECLARATION FOR TABLE CSS_AR_TRANS_HIST AR          *             
A01376******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBARHIST                                                  
           END-EXEC.                                                            
                                                                        
A01376******************************************************************        
A01376* COBOL DECLARATION FOR TABLE CSS_AR_TRN_HST_DET AU          *            
A01376******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBARHDT                                                   
           END-EXEC.                                                            
PCR263                                                                  
A01376******************************************************************        
A01376* COBOL DECLARATION FOR TABLE CSS_CUST_ALERT CA              *            
A01376******************************************************************        
PCR263     EXEC SQL                                                             
PCR263        INCLUDE TBCSTALT                                                  
PCR263     END-EXEC.                                                            
PCR361                                                                  
A01376******************************************************************        
A01376* COBOL DECLARATION FOR TABLE CSS_HOLIDAY J8                *             
A01376******************************************************************        
PCR361     EXEC SQL                                                             
PCR263        INCLUDE TBHLDAY                                                   
           END-EXEC.                                                            
                                                                        
A01376******************************************************************        
A01376* COBOL DECLARATION FOR TABLE CSS_BANK_TRANSFER YB          *             
A01376******************************************************************        
T22767     EXEC SQL                                                             
T22767        INCLUDE TBBNKXFR                                                  
T22767     END-EXEC.                                                            
                                                                        
                                                                        
A01376******************************************************************        
A01376* COBOL DECLARATION FOR TABLE CSS_CSH_REPORT_HDR YR         *             
A01376******************************************************************        
C25923     EXEC SQL                                                             
C25923        INCLUDE TBCSRPHD                                                  
C25923     END-EXEC.                                                            
                                                                        
A01376******************************************************************        
A01376* COBOL DECLARATION FOR TABLE CSS_CASHIER_OFFICE Y2         *             
A01376******************************************************************        
C25923     EXEC SQL                                                             
C25923        INCLUDE TBCSHOFF                                                  
C25923     END-EXEC.                                                            
                                                                        
A01376******************************************************************        
A01376* COBOL DECLARATION FOR TABLE CSS_OVERSHORT_HDR OH          *             
A01376******************************************************************        
T25923     EXEC SQL                                                             
T25923        INCLUDE TBOVSHHD                                                  
T25923     END-EXEC.                                                            
                                                                        
A01376******************************************************************        
A01376* COBOL DECLARATION FOR TABLE CSS_OVERSHORT_TYPE OT         *             
A01376******************************************************************        
T25923     EXEC SQL                                                             
T25923        INCLUDE TBOVSHTY                                                  
T25923     END-EXEC.                                                            
                                                                        
A01376******************************************************************        
A01376* COBOL DECLARATION FOR TABLE CSS_REG_PROFILE LR            *             
A01376******************************************************************        
C26954     EXEC SQL                                                             
C26954        INCLUDE TBREGPRF                                                  
C26954     END-EXEC.                                                            
C26954                                                                  
P00599******************************************************************        
P00599* COBOL DECLARATION FOR TABLE CSS_FIN_WO_ACTION KD               *        
P00599******************************************************************        
P00599     EXEC SQL                                                             
P00599        INCLUDE TBFWACTN                                                  
P00599     END-EXEC.                                                            
      *****************************************************************         
      *    COBOL WORKING STORAGE COPY BOOKS                                     
      *****************************************************************         
                                                                        
       COPY CCA00001.                                                           
REARCH      EXEC SQL                                                            
REARCH          INCLUDE CWSX0010                                                
REARCH      END-EXEC.                                                           
A01376******************************************************************CWS00010
A01376* CWS00027    E R R O R    W O R K    A R E A                    *CWS00020
A01376******************************************************************        
       COPY CWS00027.                                                           
A01376******************************************************************        
A01376*      WORKING STORAGE LAYOUT FOR CODES_DATA_PRESENT ON TABLE    *00022000
A01376******************************************************************        
       COPY CWS00056.                                                           
A01376******************************************************************        
A01376*      COPYBOOK INITIALLY ADDED TO SUPPORT DB2                   *        
A01376*                     AND SQL ERROR CHECKING.                    *        
A01376******************************************************************        
       COPY CWS00303.                                                           
A01376******************************************************************        
A01376**       WORKING STORAGE VARIABLES FOR GENERAL LEDGER          ** 00030000
A01376******************************************************************        
T10351 COPY CWS00061.                                                           
A01376******************************************************************        
A01376**     THIS COPY STATEMENT IS THE WS AREA FOR THE USER DEFINED  **        
A01376**     PORTION OF THE MISCELLANEOUS JOURNALS USED FOR           **        
A01376**     ACCOUNTS RECEIVABLE MAINTENANCE                          **        
A01376******************************************************************        
       COPY CJF00113.                                                           
A01376******************************************************************        
A01376**     THIS COPY STATEMENT IS THE WS AREA FOR THE USER DEFINED  **        
A01376**     PORTION OF THE BATCH AND CASH JOURNAL DETAIL             **        
A01376**     USED FOR ACCOUNTS RECEIVABLE POSTING                     **        
A01376******************************************************************        
       COPY CJF00101.                                                           
A01376*****************************************************************         
A01376* CWS00013       C O M M O N    J O U R N A L    A R E A        *         
A01376*****************************************************************         
           EXEC SQL                                                             
A00956        INCLUDE CWS0013B                                                  
           END-EXEC.                                                            
PCR263                                                                  
A01376******************************************************************        
A01376*WORKING STORAGE FOR CPD00068                                             
A01376******************************************************************        
PCR263     EXEC SQL                                                             
PCR263        INCLUDE CWS00068                                                  
PCR263     END-EXEC.                                                            
P00599******************************************************************        
P00599* WORKING STORAGE FOR CPD00348                                   *00022000
P00599******************************************************************        
P00599     EXEC SQL                                                             
P00599        INCLUDE CWS00348                                                  
P00599     END-EXEC.                                                            
                                                                        
P00726******************************************************************        
P00726* WORKING STORAGE FOR CPDKR360                                   *00022000
P00726******************************************************************        
P00726                                                                  
P00726     EXEC SQL                                                             
P00726        INCLUDE CWSKR360                                                  
P00726     END-EXEC.                                                            
P00726                                                                  
ACT063*                                                                         
ACT063******************************************************************        
ACT063/***** FOR WQ INSERT - WORKING STORAGE COPYBOOK FOR MCSCB077              
ACT063******************************************************************        
ACT063     EXEC SQL                                                             
ACT063          INCLUDE CWS00077                                                
ACT063     END-EXEC.                                                            
ACT063                                                                  
      ****************************************                                  
      * CURSOR FOR RETRIEVING OVERSHORT TYPE *                                  
      ****************************************                                  
           EXEC SQL                                                     
              DECLARE OVSH-TYPE CURSOR FOR                              
               SELECT OVERSHORT_TYPE_CD                                 
                 FROM CSS_OVERSHORT_TYPE WITH(READUNCOMMITTED)                  
                WHERE GL_ACCT_NO = :OT-GL-ACCT-NO                       
C35824          FOR READ ONLY                                   
A01376                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE OVSH-TYPE CURSOR FOR                                      
MFA-TR*        SELECT OVERSHORT_TYPE_CD                                         
MFA-TR*          FROM CSS_OVERSHORT_TYPE                                        
MFA-TR*         WHERE GL_ACCT_NO = :OT-GL-ACCT-NO                               
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*         QUERYNO 5780                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    WORK AREAS                                                           
      *****************************************************************         
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME             PIC X(08) VALUE 'CSR02189'.     
ACT063     05  MCSCB077                 PIC X(08) VALUE 'MCSCB077'.     
ACT063     05  WS-MCSCB077-OUTPUT.                                      
ACT063         10 WS-MCSCB077-RET-CODE  PIC S9(09) COMP VALUE 0.        
REARCH     05  WS-SQLSTATE              PIC X(05) VALUE '     '.        
           05  WS-ACCOUNT-NO-NUM        PIC S9(13) COMP-3 VALUE 0.      
T10351     05  WS-HOLD-ACCT-NO          PIC 9(13) VALUE 0.              
T11621     05  WS-HOLD-CUST-NO          PIC 9(10) VALUE 0.              
           05  WS-BANK-ID-NUM           PIC S9(6) COMP-3 VALUE 0.       
           05  WS-DATE-NI               PIC S9(4) COMP VALUE 0.         
           05  WS-NSF-PPL               PIC S9(4) COMP VALUE 0.         
           05  WS-GEN-LED-NO-NSF        PIC 9(03)V9(04).                
T10351     05  WS-GEN-LED-NO-CA-CLR     PIC 9(03)V9(04).                
T10351     05  WS-GEN-LED-NO-OV-SH      PIC 9(03)V9(04).                
COB305     05 WS-ERROR-GL-OFFSET        PIC S9(3)V9(4) USAGE COMP-3 
COB305       VALUE 0.    
           05  WS-NSA-PPL               PIC S9(4) COMP VALUE +020.      
           05  WS-NSN-PPL               PIC S9(4) COMP VALUE +029.      
           05  WS-NSC-PPL               PIC S9(4) COMP VALUE +019.      
           05  WS-GEN-LED-NO-BANK       PIC 9(03)V9(04).                
           05  WS-GEN-LED-NO-CREDIT     PIC 9(03)V9(04).                
           05  WS-TOTAL-RET-AMT         PIC S9(07)V99 COMP-3 VALUE 0.   
           05  WS-BATCH-DIFF-AMT        PIC S9(07)V99 COMP-3 VALUE 0.   
           05  WS-CHECK-AMOUNT          PIC S9(07)V99 COMP-3 VALUE 0.   
           05  WS-NON-UTIL-AMT          PIC S9(07)V99 COMP-3 VALUE 0.   
           05  WS-UTIL-AMT              PIC S9(07)V99 COMP-3 VALUE 0.   
           05  WS-UNUSED-CR-DOLLARS     PIC S9(07)V99 COMP-3 VALUE 0.   
           05  WS-BATCH-AMT             PIC S9(07)V99 COMP-3 VALUE 0.   
           05  WS-ENTERED-AMT           PIC S9(07)V99 COMP-3 VALUE 0.   
           05  WS-FROM-DATE             PIC X(10) VALUE SPACES.         
           05  WS-TO-DATE               PIC X(10) VALUE SPACES.         
T5033      05  WS-DATE-1-YEAR-AGO       PIC X(10) VALUE SPACES.         
T5033      05  WS-DATE-HOLD             PIC X(10) VALUE SPACES.         
P00471     05  WS-DATE-HOLD-USA         PIC X(10) VALUE SPACES.         
           05  WS-AR-AGE                PIC X(01) VALUE SPACES.         
           05  WS-DRAWN-BY-NM.                                          
               10 WS-DRAWN-BY-NM-LEN    PIC S9(4) USAGE COMP.           
               10 WS-DRAWN-BY-NM-TEXT   PIC X(50).                      
           05  WS-DATE-ORIG-PYMT-IND    PIC S9(4) USAGE COMP.           
T13899     05  WS-DATE-ORIG-PYMT        PIC X(10) VALUE SPACES.         
           05  WS-MEM-NO                PIC S9(4) COMP VALUE 0.         
           05  WS-NSF-COUNT             PIC S9(4) COMP VALUE 0.         
A05058     05  WS-NSF-COUNT-C           PIC S9(4) COMP VALUE 0.         
A05058     05  WS-NSF-COUNT-F           PIC S9(4) COMP VALUE 0.         
TP5033     05  WS-N-ROW-COUNT           PIC S9(4) COMP VALUE 0.         
PCR263     05  WS-DT-BILL-NI            PIC S9(4) COMP VALUE +0.        
PCR263     05  WS-DATE-CRED-NI          PIC S9(4) COMP VALUE +0.        
PCR263     05  WS-DATE-DUE-NI           PIC S9(4) COMP VALUE +0.        
PCR263     05  WS-DATE-MAIL-NI          PIC S9(4) COMP VALUE +0.        
PCR263     05  WS-NI-D                  PIC S9(4) COMP VALUE +0.        
PCR361     05  WS-NULL-INDICATOR-1      PIC S9(4) COMP VALUE +0.        
PCR361     05  WS-NULL-INDICATOR-2      PIC S9(4) COMP VALUE +0.        
PCR361     05  WS-NULL-INDICATOR-3      PIC S9(4) COMP VALUE +0.        
PCR361     05  WS-NULL-INDICATOR-4      PIC S9(4) COMP VALUE +0.        
P00599     05  WS-NULL-INDICATOR-5      PIC S9(4) COMP VALUE +0.        
TP5033     05  WS-ESTABLISHED-DATE-NULL PIC S9(4) COMP VALUE +0.        
P00471     05  WS-DATE-CRED-ACTION-NULL PIC S9(4) COMP VALUE +0.        
COB305     05 NSUM-CL-AMT-NOTICE        PIC S9(9)V9(2) USAGE COMP-3 
COB305       VALUE 0.    
COB305     05 VSUM-CL-AMT-NOTICE        PIC S9(9)V9(2) USAGE COMP-3 
COB305       VALUE 0.    
COB305     05 WSUM-CL-AMT-NOTICE        PIC S9(9)V9(2) USAGE COMP-3 
COB305       VALUE 0.    
T21963     05  SUM-DATE-NOTICE-MAIL     PIC X(10) VALUE SPACES.         
COB305     05 SUM-CODE-MESSAGE-TYPE        PIC S9(5)V USAGE COMP-3 
COB305       VALUE 0.        
COB305     05 H-AMT-NOTICE        PIC S9(9)V9(2) USAGE COMP-3 VALUE 0.    
TP5033     05  WS-BANK-DRAFT-REMOVED    PIC X(01) VALUE 'N'.            
           05  WS-ERROR-IND             PIC X(01) VALUE 'N'.            
T32545     05  WS-IVR-DAY-SECOND        PIC S9(04) COMP.                
                                                                        
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  EXISTS-SW                PIC X(01) VALUE 'N'.            
               88 EXISTS-YES                      VALUE 'Y'.            
               88 EXISTS-NO                       VALUE 'N'.            
P00726     05  WS-CANCEL-ARNG-SW        PIC X(01) VALUE 'N'.            
P00726         88 CANCEL-CRED-ARNG                VALUE 'Y'.            
           05  WS-SEND-NOTICE-CD        PIC X(01) VALUE 'Y'.            
           05  H-EXISTENCE-SW                 PIC X(01) VALUE 'N'.      
PCR263         88  H-NOTICE-DOES-EXIST            VALUE 'Y'.            
PCR263         88  H-NOTICE-DOES-NOT-EXIST        VALUE 'N'.            
           05  H-TIME-SW                 PIC X(01) VALUE 'N'.           
PCR263         88  H-NOTICE-IS-IN-PAST            VALUE 'Y'.            
PCR263         88  H-NOTICE-IS-IN-FUTURE          VALUE 'N'.            
           05  90205-SW                  PIC X(01) VALUE 'N'.           
PCR263         88  90205-DOES-EXIST               VALUE 'Y'.            
T12285     05  WS-ACTIVE-MEDICAL-CERT   PIC X(01) VALUE 'N'.            
PCR263     05  WS-DATE-PLUS-1           PIC X(10) VALUE SPACES.         
PCR263     05  WS-DATE-PLUS-4           PIC X(10) VALUE SPACES.         
TP5033     05  WS-DATE-PLUS-5           PIC X(10) VALUE SPACES.         
PCR263     05  WS-DAY                   PIC S9(04) COMP VALUE 0.        
PCR263     05  WS-NEXT-DATE-COUNT       PIC S9(04) COMP.                
PCR263     05  WS-DATE-FOUND            PIC X(01) VALUE 'N'.            
PCR263     05  WS-HOLIDAY-EXISTS        PIC X(01) VALUE 'N'.            
PCR263         88  HOLIDAY-EXISTS                 VALUE 'Y'.            
T19557     05 WS-EIBRESP                PIC S9(8)                       
T19557                                  COMP SYNC VALUE ZERO.           
T22767     05  WS-AMT-CASH-DEBIT        PIC 9(09)V99   VALUE 0.         
T22767     05  WS-ERR-MSG               PIC X(50) VALUE SPACES.         
T22767     05  WS-TRAN-TIME             PIC X(08) VALUE SPACES.         
T22767     05  WS-XFR-TS                PIC X(26) VALUE SPACES.         
T22767     05  WS-CHECK                 PIC X(01) VALUE SPACES.         
COB305     05 WS-101-BANK-ID        PIC S9(6)V COMP-3 VALUE 0.         
T25923     05  WS-OV-SH-TRAN-ID         PIC X(04) VALUE SPACES.         
T25923         88  OVERAGE-TRAN-ID                 VALUE 'O412'.        
T25923         88  SHORTAGE-TRAN-ID                VALUE 'S412'.        
T25923     05  WS-ERROR-ENTRY           PIC X(01) VALUE 'Y'.            
C26954     05  WS-SEB-REGULATED-FL      PIC X(01) VALUE SPACE.          
C26954     05  WS-SEB-GROUP-MOVE        PIC X(01) VALUE SPACE.          
C26954     05  WS-SEB-REG-90205-FL      PIC X(01) VALUE 'N'.            
C26954     05  WS-GROUP-1-SENIOR        PIC X(01) VALUE 'N'.            
C26954     05  WS-DATE-BILLED-NI        PIC S9(4) COMP VALUE +0.        
C26954     05  WS-DATE-TRANS-NI         PIC S9(4) COMP VALUE +0.        
C25816     05  WS-DATABASE              PIC 9(01)  VALUE 0.             
C25816         88 CSR-DATABASE                     VALUE 1.             
C25816         88 SEB-DATABASE                     VALUE 2.             
C26296     05  WS-CSR03515-INPUT-PARM.                                  
C26296         10  WS-CSR03515-ACCOUNT-NO      PIC X(13) VALUE SPACES.  
C26296         10  WS-CSR03515-CALLING-PGM     PIC X(09) VALUE SPACES.  
C26296         10  WS-CSR03515-AUTO-DEP-TYPE   PIC X(01) VALUE SPACES.  
C26296         10  WS-CSR03515-DL-AUTO-DEP-AMT PIC S9(09)V99            
C26296                                         USAGE COMP-3 VALUE 0.    
C26296         10  WS-CSR03515-USER-ID         PIC X(07) VALUE SPACES.  
C26296         10  WS-CSR03515-ERROR-SW        PIC X(01) VALUE SPACES.  
ACT239         10  WS-CSR03515-BATCH-DATE      PIC X(10) VALUE SPACES.  
C26296*                                                                         
C26296     05  WS-CSR03515-OUTPUT-FIELDS.                               
C26296         10  WS-CSR03515-RETURN-CODE      PIC S9(09) COMP VALUE 0.
C26296         10  WS-CSR03515-AUTO-DEP-AMT     PIC S9(09)V99 COMP-3    
C26296                                                         VALUE 0. 
C26296         10  WS-CSR03515-DEP-SUCCESS       PIC X(01) VALUE SPACES.
C26296         10  WS-CSR03515-DEP-CERT-NO      PIC S9(09) COMP VALUE 0.
C26296         10  WS-CSR03515-MAX-DEP-ZERO-WQ   PIC X(01) VALUE SPACES.
C26296         10  WS-CSR03515-AMT-SECURED       PIC S9(09)V99 COMP-3   
C26296                                                         VALUE 0. 
C26296         10  WS-CSR03515-ABEND-PROGRAM     PIC X(20) VALUE SPACES.
C26296         10  WS-CSR03515-ACTIVE-PARAGRAPH  PIC X(20) VALUE SPACES.
C26296         10  WS-CSR03515-ABEND-FUNCTION    PIC X(20) VALUE SPACES.
C26296         10  WS-CSR03515-TABLE-1           PIC X(20) VALUE SPACES.
C26296         10  WS-CSR03515-TABLE-ELEMENT-1   PIC X(20) VALUE SPACES.
C26296         10  WS-CSR03515-HOSTVAR-ELEMENT-1 PIC X(20) VALUE SPACES.
C26296         10  WS-CSR03515-TABLE-ELEMENT-2   PIC X(20) VALUE SPACES.
C26296         10  WS-CSR03515-HOSTVAR-ELEMENT-2 PIC X(20) VALUE SPACES.
C26296         10  WS-CSR03515-TABLE-ELEMENT-3   PIC X(20) VALUE SPACES.
C26296         10  WS-CSR03515-HOSTVAR-ELEMENT-3 PIC X(20) VALUE SPACES.
C26296         10  WS-CSR03515-TABLE-ELEMENT-4   PIC X(20) VALUE SPACES.
C26296         10  WS-CSR03515-HOSTVAR-ELEMENT-4 PIC X(20) VALUE SPACES.
C26296     05  WS-AUTODEP-CALL-SUCCESS           PIC X(01) VALUE SPACES.
C26296     05  WS-AUTO-DEP-CERT-NO              PIC S9(09) COMP VALUE 0.
P00471     05  WS-DELETE-COMMENT.                                       
P00471         10  FILLER                       PIC X(34)               
P00471             VALUE 'EXCEPTIONAL CREDIT ACTION DELETED.'.          
P00471         10  FILLER                       PIC X(41)               
P00471             VALUE ' RETURNED CHECK CREDIT ACTION FORECASTED.'.   
P00471     05  WS-COMP-2-CHAR-CONV              PIC ZZZZZZZZ9.99.       
P00471     05  WS-TRAN-APPL-NO                  PIC S9(04)              
P00471                                          COMP VALUE ZERO.        
P00581 01  WS-CSR04533-OUTPUT.                                          
P00581     05  WS-4533-RETURN-CODE       PIC S9(09) COMP VALUE +0.      
COB305     05 WS-4533-EFF-REV-MTH        PIC S9(06)V USAGE COMP-3 
COB305       VALUE 0.      
P00581     05  WS-4533-CALC-TYPE-CD      PIC X(02) VALUE SPACES.        
P00581     05  WS-4533-OPT-AGR-EFF-DT    PIC X(10) VALUE SPACES.        
C26296*                                                                         
C26296 01 WS-WORKQ-VARS.                                                
C26296     05 WS-WQ-COMMENTS.                                           
C26296        49 WS-WQ-COMMENTS-LEN      PIC S9(04) USAGE COMP VALUE 0. 
C26296        49 WS-WQ-COMMENTS-TEXT     PIC X(250) VALUE SPACES.       
C26296*                                                                         
C26296     05 WS-DUP-WQ-CNT             PIC S9(03) USAGE COMP-3 VALUE 0.
C26296     05 WS-DUP-WQ-CNT-IND          PIC S9(04) COMP VALUE ZERO.    
C26296     05 WS-WQ-COMMENT              PIC X(47)  VALUE SPACES.       
C26296     05 WS-CURRENT-TIMESTAMP       PIC X(26)  VALUE SPACES.       
C26296     05 WS-WQ-MF-EXISTS            PIC X(01)  VALUE SPACES.       
C26296        88  WQ-MF-EXISTS                      VALUE 'Y'.          
C26296     05 WS-WQ-COMMENTS-DETAIL.                                    
C26296        10 WS-WQ-CMNTS-1           PIC X(31)                      
C26296           VALUE 'MAX DEPOSIT CALCULATION = $0.00'.               
C26296        10 FILLER                  PIC X(02) VALUE '; '.          
C26296        10 WS-WQ-CMNTS-2           PIC X(34)                      
C26296           VALUE 'RETURNED CHECK AUTO DEPOSIT AMT = '.            
C26296        10 WS-WQ-AUTO-DEP-AMT      PIC $$$,$$$,$$$.99             
C26296                                   VALUE SPACES.                  
C26296        10 FILLER                  PIC X(02) VALUE '; '.          
C26296        10 WS-WQ-CMNTS-3           PIC X(19)                      
C26296           VALUE 'TOTAL SECURITIES = '.                           
C26296        10 WS-WQ-AMT-SECURED       PIC $$$,$$$,$$$.99             
C26296                                   VALUE SPACES.                  
C26296        10 FILLER                  PIC X(02) VALUE '; '.          
P0059A     05 WS-RETURNED-CHECK-FINAL    PIC X(37)  VALUE               
P0059A        'RETURNED CHECK - FINAL BILLED ACCOUNT'.                  
P0059A     05 WS-RETURNED-CHECK-WO       PIC X(36)  VALUE               
P0059A        'RETURNED CHECK - WRITTEN OFF ACCOUNT'.                   
C26296                                                                  
C26296*                                                                         
C26296***************************************************************   ****    
C26296*    DB2 COMMUNICATION REQUIREMENT *                                      
C26296***************************************************************   ****    
C26296*01  LOC1                  USAGE IS SQL TYPE IS                   
C26296*                          RESULT-SET-LOCATOR VARYING.            
P00581*01  LOC2                  USAGE IS SQL TYPE IS                   
P00581*                          RESULT-SET-LOCATOR VARYING.            
C26296 01  ERROR-MESSAGE.                                               
C26296     02  ERROR-LEN           PIC S9(4)  COMP VALUE +1320.         
C26296     02  ERROR-TEXT          PIC X(132) OCCURS 10 TIMES           
C26296                           INDEXED BY ERROR-INDEX.                
C26296 77   ERROR-TEXT-LEN       PIC S9(9)  COMP VALUE +132.            
C26296 77  TRACE-MESSAGE-AREA    PIC X(256).                            
C26296 77  OPENFN                PIC X(12).                             
C26296 77  SSID                  PIC X(4).                              
C26296 77  PLANNAME              PIC X(8).                              
C26296 77  RETCODE               PIC S9(5).                             
C26296 77  REASCODE              PIC S9(5).                             
C26296 77  CLOSFN                PIC X(12).                             
C26296 77  TERMOP                PIC X(4).                              
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-001                   PIC X(03)  VALUE '001'.         
           05  WS-002                   PIC X(03)  VALUE '002'.         
           05  WS-19                    PIC S9(04) VALUE +19.           
           05  WS-20                    PIC S9(04) VALUE +20.           
           05  WS-29                    PIC S9(04) VALUE +29.           
           05  WS-A                     PIC X(01)  VALUE 'A'.           
           05  WS-C                     PIC X(01)  VALUE 'C'.           
           05  WS-1                     PIC X(01)  VALUE '1'.           
           05  WS-P                     PIC X(01)  VALUE 'P'.           
T23637     05  WS-PSNC                  PIC X(02)  VALUE '26'.          
T24982     05  WS-SCEG                  PIC X(02)  VALUE '01'.          
           05  WS-CHECKCHARGE           PIC X(20)  VALUE                
                                        'AMT-CHECKCHARGE'.              
P00581     05  WS-FEE-INCR-DATE         PIC X(10) VALUE SPACES.         
P00581     05  WS-OLD-DELINQ-CD         PIC X(20) VALUE SPACES.         
P00581     05  WS-NEW-DELINQ-CD         PIC X(20) VALUE SPACES.         
P00581     05  WS-FP                    PIC X(02) VALUE 'FP'.           
REARCH     05  MCSCB068                 PIC X(8)   VALUE 'MCSCB068'.    
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
                                                                        
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
       01  PARM-FIELDS.                                                 
           05  PARM-BANK-ID-TEMP       PIC X(06) VALUE SPACES.          
           05  PARM-BANK-ID-RED        REDEFINES PARM-BANK-ID-TEMP      
                                       PIC 9(06).                       
REARCH     05  PARM-BATCH-AMT-TEMP     PIC X(09) VALUE SPACES.          
REARCH     05  PARM-BATCH-AMT-RED      REDEFINES PARM-BATCH-AMT-TEMP    
REARCH                                 PIC 9(07)V99.                    
T25923     05  PARM-ENTERED-AMT-TEMP   PIC X(09) VALUE SPACES.          
T25923     05  PARM-ENTERED-AMT-RED    REDEFINES PARM-ENTERED-AMT-TEMP  
T25923                                 PIC 9(07)V99.                    
           05  PARM-RETCHK-DATA                                         
               OCCURS 75 TIMES.                                         
               10  PARM-ACCOUNT-NO         PIC X(13) VALUE SPACES.      
               10  PARM-ACCOUNT-NO-RED     REDEFINES PARM-ACCOUNT-NO    
                                           PIC 9(13).                   
               10  PARM-NON-UTIL-AMT       PIC X(09) VALUE SPACES.      
               10  PARM-NON-UTIL-RED       REDEFINES PARM-NON-UTIL-AMT  
                                           PIC 9(07)V99.                
               10  PARM-UTIL-AMT           PIC X(09) VALUE SPACES.      
               10  PARM-UTIL-RED           REDEFINES PARM-UTIL-AMT      
                                           PIC 9(07)V99.                
               10  PARM-NSF-TIMESTAMP      PIC X(26) VALUE SPACES.      
               10  PARM-TRN-HST-SEQ-NO     PIC X(26) VALUE SPACES.      
               10  PARM-DRAWN-BY-NM-LEN    PIC X(04) VALUE SPACES.      
               10  PARM-DRAWN-BY-NM-TEXT   PIC X(50) VALUE SPACES.      
               10  PARM-WAIVE-CHARGE       PIC X(01) VALUE SPACES.      
               10  PARM-AR-AGE             PIC X(01) VALUE SPACES.      
               10  PARM-CURRENCY-TYPE      PIC X(01) VALUE SPACES.      
C30881         10  PARM-NSF-REASON-CD      PIC X(03) VALUE SPACES.      
               10  PARM-WAIVE-REASON-CD    PIC X(01) VALUE SPACES.      
               10  PARM-NSC-REMOVE-FL      PIC X(01) VALUE SPACES.      
               10  PARM-ACCT-XFER-IND      PIC X(01) VALUE SPACES.      
T25923         10  PARM-DATE-ORIG-PYMT     PIC X(10) VALUE SPACES.      
T25923         10  PARM-ORIG-PYMT-OFFICE   PIC X(03) VALUE SPACES.      
T25923         10  PARM-PARTIAL-PYMT-FL    PIC X(01) VALUE SPACES.      
T25923         10  PARM-BANK-POST-DT       PIC X(10) VALUE SPACES.      
T22767         10  PARM-GL-ACCOUNT         PIC X(7)  VALUE SPACES.      
T22767         10  PARM-GL-ACCOUNT-RED     REDEFINES  PARM-GL-ACCOUNT   
T22767                                     PIC 9(3)V9(4).               
T22767         10  PARM-RTN-CHK-AMT        PIC X(09) VALUE SPACES.      
T22767         10  PARM-RTN-CHK-AMT-RED    REDEFINES PARM-RTN-CHK-AMT   
T22767                                     PIC 9(07)V99.                
T22767         10  PARM-PAYMENT-TYPE       PIC X(15) VALUE SPACES.      
C26296         10  PARM-SEND-NOTICE-CD     PIC X(01) VALUE SPACES.      
T22767     05  PARM-COMMENT-DATA                                        
T22767         OCCURS 75 TIMES.                                         
T22767         10  PARM-NCIS-COMMENTS-LEN  PIC X(04) VALUE SPACES.      
T22767         10  PARM-NCIS-COMMENTS-TEXT PIC X(210) VALUE SPACES.     
                                                                        
       01  AR-TRANSACTION-STORAGE.                                      
           05  CURRENT-TIMESTAMP.                                       
               10  CURRENT-DATE        PIC X(10).                       
               10  FILLER              PIC X(01) VALUE '-'.             
               10  CURRENT-TIME        PIC X(15).                       
                                                                        
       01  CASH-DRAWER-JOURNALING.                                      
           05  WS-CASH-DRAWER.                                          
               10  WS-CD-COMPANY-NO    PIC X(02).                       
               10  WS-CD-LOCAL-OFFICE  PIC X(03).                       
               10  WS-CD-REPORT-NO     PIC X(03).                       
               10  WS-CD-REPORT-DATE   PIC X(10).                       
               10  WS-CASH-DRAWER-ID   PIC S9(04) COMP.                 
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME               PIC X(18) VALUE SPACES.          
REARCH     10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
REARCH     10  S-SQLSTATE              PIC X(5)  VALUE ' '.             
REARCH     10  S-TABLE-NAME            PIC X(18) VALUE SPACES.          
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
REARCH         49  S-HOST-VARIABLES-V  PIC X(255).                      
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-STATEMENT-V   PIC X(255).                      
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-DESCRIPTION-V PIC X(255).                      
                                                                        
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  GTT-NAME                PIC X(26) VALUE                  
REARCH                                     'SESSION.CSR02189_R1'.       
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN          PIC S9(04) COMP.                 
REARCH         49 GTT-ROW-CHAR         PIC X(1024).                     
REARCH     05  GTT-SQLCODE             PIC S9(9) COMP.                  
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE            PIC S9(9) COMP VALUE 0.         
REARCH     05  S-ROW-NO                 PIC S9(4) COMP VALUE 0.         
REARCH     05  S-AR-LOCKOUT-IND         PIC X(01) VALUE SPACES.         
REARCH     05  S-ACCT-XFER-TO           PIC X(13) VALUE SPACES.
MSQ001        EXEC SQL
MSQ001          DECLARE CHRG_AMT CURSOR
MSQ001          FOR CALL CSR04533                                       
P00581         ( :AT-ACCOUNT-NO
                  )
MSQ001        END-EXEC.
MSQ001        EXEC SQL
MSQ001          DECLARE AUTO_DEP CURSOR
MSQ001          FOR CALL CSR03515                                       
C26296         ( :WS-CSR03515-ACCOUNT-NO
                  , :WS-CSR03515-CALLING-PGM
                  , :WS-CSR03515-AUTO-DEP-TYPE
                  , :WS-CSR03515-DL-AUTO-DEP-AMT
                  , :WS-CSR03515-USER-ID
                  , :WS-CSR03515-ERROR-SW
                  , :WS-CSR03515-BATCH-DATE
                  )
MSQ001        END-EXEC.
         
                                                                        
                                                                        
REARCH LINKAGE SECTION.                                                 
REARCH 01  PARM-BANK-ID              PIC X(06).                         
REARCH 01  PARM-ENTERED-DT           PIC X(10).                         
REARCH 01  PARM-BATCH-AMT            PIC X(09).                         
REARCH 01  PARM-RESP-AREA-ID         PIC X(03).                         
REARCH 01  PARM-USER-ID              PIC X(07).                         
REARCH 01  PARM-ENTERED-AMT          PIC X(09).                         
REARCH 01  PARM-ERROR-TYPE-IND       PIC X(01).                         
REARCH 01  PARM-THIRD-PARTY          PIC X(03).                         
C30881 01  PARM-RETCHK-DATA1-L       PIC X(202).                        
C30881 01  PARM-RETCHK-DATA2-L       PIC X(202).                        
C30881 01  PARM-RETCHK-DATA3-L       PIC X(202).                        
C30881 01  PARM-RETCHK-DATA4-L       PIC X(202).                        
C30881 01  PARM-RETCHK-DATA5-L       PIC X(202).                        
C30881 01  PARM-RETCHK-DATA6-L       PIC X(202).                        
C30881 01  PARM-RETCHK-DATA7-L       PIC X(202).                        
C30881 01  PARM-RETCHK-DATA8-L       PIC X(202).                        
C30881 01  PARM-RETCHK-DATA9-L       PIC X(202).                        
C30881 01  PARM-RETCHK-DATA10-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA11-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA12-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA13-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA14-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA15-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA16-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA17-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA18-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA19-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA20-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA21-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA22-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA23-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA24-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA25-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA26-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA27-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA28-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA29-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA30-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA31-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA32-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA33-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA34-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA35-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA36-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA37-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA38-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA39-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA40-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA41-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA42-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA43-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA44-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA45-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA46-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA47-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA48-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA49-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA50-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA51-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA52-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA53-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA54-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA55-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA56-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA57-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA58-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA59-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA60-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA61-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA62-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA63-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA64-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA65-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA66-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA67-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA68-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA69-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA70-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA71-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA72-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA73-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA74-L      PIC X(202).                        
C30881 01  PARM-RETCHK-DATA75-L      PIC X(202).                        
REARCH 01  PARM-COMMENT-DATA1-L      PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA2-L      PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA3-L      PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA4-L      PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA5-L      PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA6-L      PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA7-L      PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA8-L      PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA9-L      PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA10-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA11-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA12-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA13-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA14-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA15-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA16-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA17-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA18-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA19-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA20-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA21-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA22-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA23-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA24-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA25-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA26-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA27-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA28-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA29-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA30-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA31-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA32-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA33-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA34-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA35-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA36-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA37-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA38-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA39-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA40-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA41-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA42-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA43-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA44-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA45-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA46-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA47-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA48-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA49-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA50-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA51-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA52-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA53-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA54-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA55-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA56-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA57-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA58-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA59-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA60-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA61-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA62-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA63-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA64-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA65-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA66-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA67-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA68-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA69-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA70-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA71-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA72-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA73-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA74-L     PIC X(214).                        
REARCH 01  PARM-COMMENT-DATA75-L     PIC X(214).                        
                                                                        
HPCCDM*EJECT                                                                    
REARCH PROCEDURE DIVISION USING  PARM-BANK-ID                           
REARCH                          ,PARM-ENTERED-DT                        
REARCH                          ,PARM-BATCH-AMT                         
REARCH                          ,PARM-RESP-AREA-ID                      
REARCH                          ,PARM-USER-ID                           
REARCH                          ,PARM-ENTERED-AMT                       
REARCH                          ,PARM-ERROR-TYPE-IND                    
REARCH                          ,PARM-THIRD-PARTY                       
REARCH                          ,PARM-RETCHK-DATA1-L                    
REARCH                          ,PARM-RETCHK-DATA2-L                    
REARCH                          ,PARM-RETCHK-DATA3-L                    
REARCH                          ,PARM-RETCHK-DATA4-L                    
REARCH                          ,PARM-RETCHK-DATA5-L                    
REARCH                          ,PARM-RETCHK-DATA6-L                    
REARCH                          ,PARM-RETCHK-DATA7-L                    
REARCH                          ,PARM-RETCHK-DATA8-L                    
REARCH                          ,PARM-RETCHK-DATA9-L                    
REARCH                          ,PARM-RETCHK-DATA10-L                   
REARCH                          ,PARM-RETCHK-DATA11-L                   
REARCH                          ,PARM-RETCHK-DATA12-L                   
REARCH                          ,PARM-RETCHK-DATA13-L                   
REARCH                          ,PARM-RETCHK-DATA14-L                   
REARCH                          ,PARM-RETCHK-DATA15-L                   
REARCH                          ,PARM-RETCHK-DATA16-L                   
REARCH                          ,PARM-RETCHK-DATA17-L                   
REARCH                          ,PARM-RETCHK-DATA18-L                   
REARCH                          ,PARM-RETCHK-DATA19-L                   
REARCH                          ,PARM-RETCHK-DATA20-L                   
REARCH                          ,PARM-RETCHK-DATA21-L                   
REARCH                          ,PARM-RETCHK-DATA22-L                   
REARCH                          ,PARM-RETCHK-DATA23-L                   
REARCH                          ,PARM-RETCHK-DATA24-L                   
REARCH                          ,PARM-RETCHK-DATA25-L                   
REARCH                          ,PARM-RETCHK-DATA26-L                   
REARCH                          ,PARM-RETCHK-DATA27-L                   
REARCH                          ,PARM-RETCHK-DATA28-L                   
REARCH                          ,PARM-RETCHK-DATA29-L                   
REARCH                          ,PARM-RETCHK-DATA30-L                   
REARCH                          ,PARM-RETCHK-DATA31-L                   
REARCH                          ,PARM-RETCHK-DATA32-L                   
REARCH                          ,PARM-RETCHK-DATA33-L                   
REARCH                          ,PARM-RETCHK-DATA34-L                   
REARCH                          ,PARM-RETCHK-DATA35-L                   
REARCH                          ,PARM-RETCHK-DATA36-L                   
REARCH                          ,PARM-RETCHK-DATA37-L                   
REARCH                          ,PARM-RETCHK-DATA38-L                   
REARCH                          ,PARM-RETCHK-DATA39-L                   
REARCH                          ,PARM-RETCHK-DATA40-L                   
REARCH                          ,PARM-RETCHK-DATA41-L                   
REARCH                          ,PARM-RETCHK-DATA42-L                   
REARCH                          ,PARM-RETCHK-DATA43-L                   
REARCH                          ,PARM-RETCHK-DATA44-L                   
REARCH                          ,PARM-RETCHK-DATA45-L                   
REARCH                          ,PARM-RETCHK-DATA46-L                   
REARCH                          ,PARM-RETCHK-DATA47-L                   
REARCH                          ,PARM-RETCHK-DATA48-L                   
REARCH                          ,PARM-RETCHK-DATA49-L                   
REARCH                          ,PARM-RETCHK-DATA50-L                   
REARCH                          ,PARM-RETCHK-DATA51-L                   
REARCH                          ,PARM-RETCHK-DATA52-L                   
REARCH                          ,PARM-RETCHK-DATA53-L                   
REARCH                          ,PARM-RETCHK-DATA54-L                   
REARCH                          ,PARM-RETCHK-DATA55-L                   
REARCH                          ,PARM-RETCHK-DATA56-L                   
REARCH                          ,PARM-RETCHK-DATA57-L                   
REARCH                          ,PARM-RETCHK-DATA58-L                   
REARCH                          ,PARM-RETCHK-DATA59-L                   
REARCH                          ,PARM-RETCHK-DATA60-L                   
REARCH                          ,PARM-RETCHK-DATA61-L                   
REARCH                          ,PARM-RETCHK-DATA62-L                   
REARCH                          ,PARM-RETCHK-DATA63-L                   
REARCH                          ,PARM-RETCHK-DATA64-L                   
REARCH                          ,PARM-RETCHK-DATA65-L                   
REARCH                          ,PARM-RETCHK-DATA66-L                   
REARCH                          ,PARM-RETCHK-DATA67-L                   
REARCH                          ,PARM-RETCHK-DATA68-L                   
REARCH                          ,PARM-RETCHK-DATA69-L                   
REARCH                          ,PARM-RETCHK-DATA70-L                   
REARCH                          ,PARM-RETCHK-DATA71-L                   
REARCH                          ,PARM-RETCHK-DATA72-L                   
REARCH                          ,PARM-RETCHK-DATA73-L                   
REARCH                          ,PARM-RETCHK-DATA74-L                   
REARCH                          ,PARM-RETCHK-DATA75-L                   
REARCH                          ,PARM-COMMENT-DATA1-L                   
REARCH                          ,PARM-COMMENT-DATA2-L                   
REARCH                          ,PARM-COMMENT-DATA3-L                   
REARCH                          ,PARM-COMMENT-DATA4-L                   
REARCH                          ,PARM-COMMENT-DATA5-L                   
REARCH                          ,PARM-COMMENT-DATA6-L                   
REARCH                          ,PARM-COMMENT-DATA7-L                   
REARCH                          ,PARM-COMMENT-DATA8-L                   
REARCH                          ,PARM-COMMENT-DATA9-L                   
REARCH                          ,PARM-COMMENT-DATA10-L                  
REARCH                          ,PARM-COMMENT-DATA11-L                  
REARCH                          ,PARM-COMMENT-DATA12-L                  
REARCH                          ,PARM-COMMENT-DATA13-L                  
REARCH                          ,PARM-COMMENT-DATA14-L                  
REARCH                          ,PARM-COMMENT-DATA15-L                  
REARCH                          ,PARM-COMMENT-DATA16-L                  
REARCH                          ,PARM-COMMENT-DATA17-L                  
REARCH                          ,PARM-COMMENT-DATA18-L                  
REARCH                          ,PARM-COMMENT-DATA19-L                  
REARCH                          ,PARM-COMMENT-DATA20-L                  
REARCH                          ,PARM-COMMENT-DATA21-L                  
REARCH                          ,PARM-COMMENT-DATA22-L                  
REARCH                          ,PARM-COMMENT-DATA23-L                  
REARCH                          ,PARM-COMMENT-DATA24-L                  
REARCH                          ,PARM-COMMENT-DATA25-L                  
REARCH                          ,PARM-COMMENT-DATA26-L                  
REARCH                          ,PARM-COMMENT-DATA27-L                  
REARCH                          ,PARM-COMMENT-DATA28-L                  
REARCH                          ,PARM-COMMENT-DATA29-L                  
REARCH                          ,PARM-COMMENT-DATA30-L                  
REARCH                          ,PARM-COMMENT-DATA31-L                  
REARCH                          ,PARM-COMMENT-DATA32-L                  
REARCH                          ,PARM-COMMENT-DATA33-L                  
REARCH                          ,PARM-COMMENT-DATA34-L                  
REARCH                          ,PARM-COMMENT-DATA35-L                  
REARCH                          ,PARM-COMMENT-DATA36-L                  
REARCH                          ,PARM-COMMENT-DATA37-L                  
REARCH                          ,PARM-COMMENT-DATA38-L                  
REARCH                          ,PARM-COMMENT-DATA39-L                  
REARCH                          ,PARM-COMMENT-DATA40-L                  
REARCH                          ,PARM-COMMENT-DATA41-L                  
REARCH                          ,PARM-COMMENT-DATA42-L                  
REARCH                          ,PARM-COMMENT-DATA43-L                  
REARCH                          ,PARM-COMMENT-DATA44-L                  
REARCH                          ,PARM-COMMENT-DATA45-L                  
REARCH                          ,PARM-COMMENT-DATA46-L                  
REARCH                          ,PARM-COMMENT-DATA47-L                  
REARCH                          ,PARM-COMMENT-DATA48-L                  
REARCH                          ,PARM-COMMENT-DATA49-L                  
REARCH                          ,PARM-COMMENT-DATA50-L                  
REARCH                          ,PARM-COMMENT-DATA51-L                  
REARCH                          ,PARM-COMMENT-DATA52-L                  
REARCH                          ,PARM-COMMENT-DATA53-L                  
REARCH                          ,PARM-COMMENT-DATA54-L                  
REARCH                          ,PARM-COMMENT-DATA55-L                  
REARCH                          ,PARM-COMMENT-DATA56-L                  
REARCH                          ,PARM-COMMENT-DATA57-L                  
REARCH                          ,PARM-COMMENT-DATA58-L                  
REARCH                          ,PARM-COMMENT-DATA59-L                  
REARCH                          ,PARM-COMMENT-DATA60-L                  
REARCH                          ,PARM-COMMENT-DATA61-L                  
REARCH                          ,PARM-COMMENT-DATA62-L                  
REARCH                          ,PARM-COMMENT-DATA63-L                  
REARCH                          ,PARM-COMMENT-DATA64-L                  
REARCH                          ,PARM-COMMENT-DATA65-L                  
REARCH                          ,PARM-COMMENT-DATA66-L                  
REARCH                          ,PARM-COMMENT-DATA67-L                  
REARCH                          ,PARM-COMMENT-DATA68-L                  
REARCH                          ,PARM-COMMENT-DATA69-L                  
REARCH                          ,PARM-COMMENT-DATA70-L                  
REARCH                          ,PARM-COMMENT-DATA71-L                  
REARCH                          ,PARM-COMMENT-DATA72-L                  
REARCH                          ,PARM-COMMENT-DATA73-L                  
REARCH                          ,PARM-COMMENT-DATA74-L                  
REARCH                          ,PARM-COMMENT-DATA75-L.                 
                                                                        
      *****************************************************************         
      * 0000-MAINLINE                                                           
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                               
      *****************************************************************         
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 0100-INITIALIZE                                                         
      *                                                                         
      *     1. RESET DB2 ERROR HANDLERS                                         
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                           
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)            
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)         
      *                                                                         
      *****************************************************************         
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
REARCH     EXEC SQL                                                     
A37061         DECLARE C1 CURSOR                             
A37061                           WITH ROWSET POSITIONING FOR            
REARCH         SELECT                                                   
REARCH            :S-RETURN-CODE        AS RETURN_CODE                  
REARCH           ,:S-ROW-NO             AS ROW_NO                       
REARCH           ,:S-AR-LOCKOUT-IND     AS AR_LOCKOUT_IND               
REARCH           ,:S-ACCT-XFER-TO       AS ACCT_XFER_TO                 
REARCH         FROM                                                     
REARCH             CIS.SYSDUMMY1 WITH(READUNCOMMITTED)                          
C35824             FOR READ ONLY                                
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                           
MFA-TR*           :S-RETURN-CODE        AS RETURN_CODE                          
MFA-TR*          ,:S-ROW-NO             AS ROW_NO                               
MFA-TR*          ,:S-AR-LOCKOUT-IND     AS AR_LOCKOUT_IND                       
MFA-TR*          ,:S-ACCT-XFER-TO       AS ACCT_XFER_TO                         
MFA-TR*        FROM                                                             
MFA-TR*            SYSIBM.SYSDUMMY1                                             
MFA-TR*            FOR FETCH ONLY WITH UR                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 1000-PROCESS-INPUT                                                      
      *     1. RECEIVE PARMS.                                                   
      *****************************************************************         
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1150-RECV-MULT-PARMS   THRU 1150-EXIT.               
           PERFORM 1200-RECV-COMM-PARMS   THRU 1200-EXIT.               
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ****************************************************************          
      * PARAGRAPH TO RECEIVE MULTIPLE ROWS OF RETURN CHECK ENTRY     *          
      ****************************************************************          
       1150-RECV-MULT-PARMS.                                            
                                                                        
REARCH     MOVE PARM-RETCHK-DATA1-L       TO PARM-RETCHK-DATA(1).       
REARCH     MOVE PARM-RETCHK-DATA2-L       TO PARM-RETCHK-DATA(2).       
REARCH     MOVE PARM-RETCHK-DATA3-L       TO PARM-RETCHK-DATA(3).       
REARCH     MOVE PARM-RETCHK-DATA4-L       TO PARM-RETCHK-DATA(4).       
REARCH     MOVE PARM-RETCHK-DATA5-L       TO PARM-RETCHK-DATA(5).       
REARCH     MOVE PARM-RETCHK-DATA6-L       TO PARM-RETCHK-DATA(6).       
REARCH     MOVE PARM-RETCHK-DATA7-L       TO PARM-RETCHK-DATA(7).       
REARCH     MOVE PARM-RETCHK-DATA8-L       TO PARM-RETCHK-DATA(8).       
REARCH     MOVE PARM-RETCHK-DATA9-L       TO PARM-RETCHK-DATA(9).       
REARCH     MOVE PARM-RETCHK-DATA10-L      TO PARM-RETCHK-DATA(10).      
REARCH     MOVE PARM-RETCHK-DATA11-L      TO PARM-RETCHK-DATA(11).      
REARCH     MOVE PARM-RETCHK-DATA12-L      TO PARM-RETCHK-DATA(12).      
REARCH     MOVE PARM-RETCHK-DATA13-L      TO PARM-RETCHK-DATA(13).      
REARCH     MOVE PARM-RETCHK-DATA14-L      TO PARM-RETCHK-DATA(14).      
REARCH     MOVE PARM-RETCHK-DATA15-L      TO PARM-RETCHK-DATA(15).      
REARCH     MOVE PARM-RETCHK-DATA16-L      TO PARM-RETCHK-DATA(16).      
REARCH     MOVE PARM-RETCHK-DATA17-L      TO PARM-RETCHK-DATA(17).      
REARCH     MOVE PARM-RETCHK-DATA18-L      TO PARM-RETCHK-DATA(18).      
REARCH     MOVE PARM-RETCHK-DATA19-L      TO PARM-RETCHK-DATA(19).      
REARCH     MOVE PARM-RETCHK-DATA20-L      TO PARM-RETCHK-DATA(20).      
REARCH     MOVE PARM-RETCHK-DATA21-L      TO PARM-RETCHK-DATA(21).      
REARCH     MOVE PARM-RETCHK-DATA22-L      TO PARM-RETCHK-DATA(22).      
REARCH     MOVE PARM-RETCHK-DATA23-L      TO PARM-RETCHK-DATA(23).      
REARCH     MOVE PARM-RETCHK-DATA24-L      TO PARM-RETCHK-DATA(24).      
REARCH     MOVE PARM-RETCHK-DATA25-L      TO PARM-RETCHK-DATA(25).      
REARCH     MOVE PARM-RETCHK-DATA26-L      TO PARM-RETCHK-DATA(26).      
REARCH     MOVE PARM-RETCHK-DATA27-L      TO PARM-RETCHK-DATA(27).      
REARCH     MOVE PARM-RETCHK-DATA28-L      TO PARM-RETCHK-DATA(28).      
REARCH     MOVE PARM-RETCHK-DATA29-L      TO PARM-RETCHK-DATA(29).      
REARCH     MOVE PARM-RETCHK-DATA30-L      TO PARM-RETCHK-DATA(30).      
PRDFIX     MOVE PARM-RETCHK-DATA31-L      TO PARM-RETCHK-DATA(31).      
REARCH     MOVE PARM-RETCHK-DATA32-L      TO PARM-RETCHK-DATA(32).      
REARCH     MOVE PARM-RETCHK-DATA33-L      TO PARM-RETCHK-DATA(33).      
REARCH     MOVE PARM-RETCHK-DATA34-L      TO PARM-RETCHK-DATA(34).      
REARCH     MOVE PARM-RETCHK-DATA35-L      TO PARM-RETCHK-DATA(35).      
REARCH     MOVE PARM-RETCHK-DATA36-L      TO PARM-RETCHK-DATA(36).      
REARCH     MOVE PARM-RETCHK-DATA37-L      TO PARM-RETCHK-DATA(37).      
REARCH     MOVE PARM-RETCHK-DATA38-L      TO PARM-RETCHK-DATA(38).      
REARCH     MOVE PARM-RETCHK-DATA39-L      TO PARM-RETCHK-DATA(39).      
REARCH     MOVE PARM-RETCHK-DATA40-L      TO PARM-RETCHK-DATA(40).      
REARCH     MOVE PARM-RETCHK-DATA41-L      TO PARM-RETCHK-DATA(41).      
REARCH     MOVE PARM-RETCHK-DATA42-L      TO PARM-RETCHK-DATA(42).      
REARCH     MOVE PARM-RETCHK-DATA43-L      TO PARM-RETCHK-DATA(43).      
REARCH     MOVE PARM-RETCHK-DATA44-L      TO PARM-RETCHK-DATA(44).      
REARCH     MOVE PARM-RETCHK-DATA45-L      TO PARM-RETCHK-DATA(45).      
REARCH     MOVE PARM-RETCHK-DATA46-L      TO PARM-RETCHK-DATA(46).      
REARCH     MOVE PARM-RETCHK-DATA47-L      TO PARM-RETCHK-DATA(47).      
REARCH     MOVE PARM-RETCHK-DATA48-L      TO PARM-RETCHK-DATA(48).      
REARCH     MOVE PARM-RETCHK-DATA49-L      TO PARM-RETCHK-DATA(49).      
REARCH     MOVE PARM-RETCHK-DATA50-L      TO PARM-RETCHK-DATA(50).      
REARCH     MOVE PARM-RETCHK-DATA51-L      TO PARM-RETCHK-DATA(51).      
REARCH     MOVE PARM-RETCHK-DATA52-L      TO PARM-RETCHK-DATA(52).      
REARCH     MOVE PARM-RETCHK-DATA53-L      TO PARM-RETCHK-DATA(53).      
REARCH     MOVE PARM-RETCHK-DATA54-L      TO PARM-RETCHK-DATA(54).      
REARCH     MOVE PARM-RETCHK-DATA55-L      TO PARM-RETCHK-DATA(55).      
REARCH     MOVE PARM-RETCHK-DATA56-L      TO PARM-RETCHK-DATA(56).      
REARCH     MOVE PARM-RETCHK-DATA57-L      TO PARM-RETCHK-DATA(57).      
REARCH     MOVE PARM-RETCHK-DATA58-L      TO PARM-RETCHK-DATA(58).      
REARCH     MOVE PARM-RETCHK-DATA59-L      TO PARM-RETCHK-DATA(59).      
REARCH     MOVE PARM-RETCHK-DATA60-L      TO PARM-RETCHK-DATA(60).      
REARCH     MOVE PARM-RETCHK-DATA61-L      TO PARM-RETCHK-DATA(61).      
REARCH     MOVE PARM-RETCHK-DATA62-L      TO PARM-RETCHK-DATA(62).      
REARCH     MOVE PARM-RETCHK-DATA63-L      TO PARM-RETCHK-DATA(63).      
REARCH     MOVE PARM-RETCHK-DATA64-L      TO PARM-RETCHK-DATA(64).      
REARCH     MOVE PARM-RETCHK-DATA65-L      TO PARM-RETCHK-DATA(65).      
REARCH     MOVE PARM-RETCHK-DATA66-L      TO PARM-RETCHK-DATA(66).      
REARCH     MOVE PARM-RETCHK-DATA67-L      TO PARM-RETCHK-DATA(67).      
REARCH     MOVE PARM-RETCHK-DATA68-L      TO PARM-RETCHK-DATA(68).      
REARCH     MOVE PARM-RETCHK-DATA69-L      TO PARM-RETCHK-DATA(69).      
REARCH     MOVE PARM-RETCHK-DATA70-L      TO PARM-RETCHK-DATA(70).      
REARCH     MOVE PARM-RETCHK-DATA71-L      TO PARM-RETCHK-DATA(71).      
REARCH     MOVE PARM-RETCHK-DATA72-L      TO PARM-RETCHK-DATA(72).      
REARCH     MOVE PARM-RETCHK-DATA73-L      TO PARM-RETCHK-DATA(73).      
REARCH     MOVE PARM-RETCHK-DATA74-L      TO PARM-RETCHK-DATA(74).      
REARCH     MOVE PARM-RETCHK-DATA75-L      TO PARM-RETCHK-DATA(75).      
                                                                        
       1150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * PARAGRAPH RECEIVE MULTIPLE COMMENT ROWS OF RETURN CHECK ENTRY*          
      ****************************************************************          
       1200-RECV-COMM-PARMS.                                            
                                                                        
REARCH     MOVE PARM-COMMENT-DATA1-L      TO PARM-COMMENT-DATA(1).      
REARCH     MOVE PARM-COMMENT-DATA2-L      TO PARM-COMMENT-DATA(2).      
REARCH     MOVE PARM-COMMENT-DATA3-L      TO PARM-COMMENT-DATA(3).      
REARCH     MOVE PARM-COMMENT-DATA4-L      TO PARM-COMMENT-DATA(4).      
REARCH     MOVE PARM-COMMENT-DATA5-L      TO PARM-COMMENT-DATA(5).      
REARCH     MOVE PARM-COMMENT-DATA6-L      TO PARM-COMMENT-DATA(6).      
REARCH     MOVE PARM-COMMENT-DATA7-L      TO PARM-COMMENT-DATA(7).      
REARCH     MOVE PARM-COMMENT-DATA8-L      TO PARM-COMMENT-DATA(8).      
REARCH     MOVE PARM-COMMENT-DATA9-L      TO PARM-COMMENT-DATA(9).      
REARCH     MOVE PARM-COMMENT-DATA10-L     TO PARM-COMMENT-DATA(10).     
REARCH     MOVE PARM-COMMENT-DATA11-L     TO PARM-COMMENT-DATA(11).     
REARCH     MOVE PARM-COMMENT-DATA12-L     TO PARM-COMMENT-DATA(12).     
REARCH     MOVE PARM-COMMENT-DATA13-L     TO PARM-COMMENT-DATA(13).     
REARCH     MOVE PARM-COMMENT-DATA14-L     TO PARM-COMMENT-DATA(14).     
REARCH     MOVE PARM-COMMENT-DATA15-L     TO PARM-COMMENT-DATA(15).     
REARCH     MOVE PARM-COMMENT-DATA16-L     TO PARM-COMMENT-DATA(16).     
REARCH     MOVE PARM-COMMENT-DATA17-L     TO PARM-COMMENT-DATA(17).     
REARCH     MOVE PARM-COMMENT-DATA18-L     TO PARM-COMMENT-DATA(18).     
REARCH     MOVE PARM-COMMENT-DATA19-L     TO PARM-COMMENT-DATA(19).     
REARCH     MOVE PARM-COMMENT-DATA20-L     TO PARM-COMMENT-DATA(20).     
REARCH     MOVE PARM-COMMENT-DATA21-L     TO PARM-COMMENT-DATA(21).     
REARCH     MOVE PARM-COMMENT-DATA22-L     TO PARM-COMMENT-DATA(22).     
REARCH     MOVE PARM-COMMENT-DATA23-L     TO PARM-COMMENT-DATA(23).     
REARCH     MOVE PARM-COMMENT-DATA24-L     TO PARM-COMMENT-DATA(24).     
REARCH     MOVE PARM-COMMENT-DATA25-L     TO PARM-COMMENT-DATA(25).     
REARCH     MOVE PARM-COMMENT-DATA26-L     TO PARM-COMMENT-DATA(26).     
REARCH     MOVE PARM-COMMENT-DATA27-L     TO PARM-COMMENT-DATA(27).     
REARCH     MOVE PARM-COMMENT-DATA28-L     TO PARM-COMMENT-DATA(28).     
REARCH     MOVE PARM-COMMENT-DATA29-L     TO PARM-COMMENT-DATA(29).     
REARCH     MOVE PARM-COMMENT-DATA30-L     TO PARM-COMMENT-DATA(30).     
REARCH     MOVE PARM-COMMENT-DATA31-L     TO PARM-COMMENT-DATA(31).     
REARCH     MOVE PARM-COMMENT-DATA32-L     TO PARM-COMMENT-DATA(32).     
REARCH     MOVE PARM-COMMENT-DATA33-L     TO PARM-COMMENT-DATA(33).     
REARCH     MOVE PARM-COMMENT-DATA34-L     TO PARM-COMMENT-DATA(34).     
REARCH     MOVE PARM-COMMENT-DATA35-L     TO PARM-COMMENT-DATA(35).     
REARCH     MOVE PARM-COMMENT-DATA36-L     TO PARM-COMMENT-DATA(36).     
REARCH     MOVE PARM-COMMENT-DATA37-L     TO PARM-COMMENT-DATA(37).     
REARCH     MOVE PARM-COMMENT-DATA38-L     TO PARM-COMMENT-DATA(38).     
REARCH     MOVE PARM-COMMENT-DATA39-L     TO PARM-COMMENT-DATA(39).     
REARCH     MOVE PARM-COMMENT-DATA40-L     TO PARM-COMMENT-DATA(40).     
REARCH     MOVE PARM-COMMENT-DATA41-L     TO PARM-COMMENT-DATA(41).     
REARCH     MOVE PARM-COMMENT-DATA42-L     TO PARM-COMMENT-DATA(42).     
REARCH     MOVE PARM-COMMENT-DATA43-L     TO PARM-COMMENT-DATA(43).     
REARCH     MOVE PARM-COMMENT-DATA44-L     TO PARM-COMMENT-DATA(44).     
REARCH     MOVE PARM-COMMENT-DATA45-L     TO PARM-COMMENT-DATA(45).     
REARCH     MOVE PARM-COMMENT-DATA46-L     TO PARM-COMMENT-DATA(46).     
REARCH     MOVE PARM-COMMENT-DATA47-L     TO PARM-COMMENT-DATA(47).     
REARCH     MOVE PARM-COMMENT-DATA48-L     TO PARM-COMMENT-DATA(48).     
REARCH     MOVE PARM-COMMENT-DATA49-L     TO PARM-COMMENT-DATA(49).     
REARCH     MOVE PARM-COMMENT-DATA50-L     TO PARM-COMMENT-DATA(50).     
REARCH     MOVE PARM-COMMENT-DATA51-L     TO PARM-COMMENT-DATA(51).     
REARCH     MOVE PARM-COMMENT-DATA52-L     TO PARM-COMMENT-DATA(52).     
REARCH     MOVE PARM-COMMENT-DATA53-L     TO PARM-COMMENT-DATA(53).     
REARCH     MOVE PARM-COMMENT-DATA54-L     TO PARM-COMMENT-DATA(54).     
REARCH     MOVE PARM-COMMENT-DATA55-L     TO PARM-COMMENT-DATA(55).     
REARCH     MOVE PARM-COMMENT-DATA56-L     TO PARM-COMMENT-DATA(56).     
REARCH     MOVE PARM-COMMENT-DATA57-L     TO PARM-COMMENT-DATA(57).     
REARCH     MOVE PARM-COMMENT-DATA58-L     TO PARM-COMMENT-DATA(58).     
REARCH     MOVE PARM-COMMENT-DATA59-L     TO PARM-COMMENT-DATA(59).     
REARCH     MOVE PARM-COMMENT-DATA60-L     TO PARM-COMMENT-DATA(60).     
REARCH     MOVE PARM-COMMENT-DATA61-L     TO PARM-COMMENT-DATA(61).     
REARCH     MOVE PARM-COMMENT-DATA62-L     TO PARM-COMMENT-DATA(62).     
REARCH     MOVE PARM-COMMENT-DATA63-L     TO PARM-COMMENT-DATA(63).     
REARCH     MOVE PARM-COMMENT-DATA64-L     TO PARM-COMMENT-DATA(64).     
REARCH     MOVE PARM-COMMENT-DATA65-L     TO PARM-COMMENT-DATA(65).     
REARCH     MOVE PARM-COMMENT-DATA66-L     TO PARM-COMMENT-DATA(66).     
REARCH     MOVE PARM-COMMENT-DATA67-L     TO PARM-COMMENT-DATA(67).     
REARCH     MOVE PARM-COMMENT-DATA68-L     TO PARM-COMMENT-DATA(68).     
REARCH     MOVE PARM-COMMENT-DATA69-L     TO PARM-COMMENT-DATA(69).     
REARCH     MOVE PARM-COMMENT-DATA70-L     TO PARM-COMMENT-DATA(70).     
REARCH     MOVE PARM-COMMENT-DATA71-L     TO PARM-COMMENT-DATA(71).     
REARCH     MOVE PARM-COMMENT-DATA72-L     TO PARM-COMMENT-DATA(72).     
REARCH     MOVE PARM-COMMENT-DATA73-L     TO PARM-COMMENT-DATA(73).     
REARCH     MOVE PARM-COMMENT-DATA74-L     TO PARM-COMMENT-DATA(74).     
REARCH     MOVE PARM-COMMENT-DATA75-L     TO PARM-COMMENT-DATA(75).     
REARCH                                                                  
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2000-PROCESS-OUTPUT.                                                    
      *                                                                         
      *     1. DESCRIBE RESULT SET                                              
      *     2. UPDATE DB2 DATA                                                  
      *     3. BUILD RESULT SET                                                 
      *     4. SEND RESULT SET                                                  
      *                                                                         
      *****************************************************************         
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 7999-SELECT-AL             THRU 7999-SELECT-AL-EXIT. 
           IF AL-AR-LOCKOUT-IND = 'Y'                                   
A05058        MOVE 5000 TO S-RETURN-CODE                                
A05058        MOVE AL-AR-LOCKOUT-IND      TO S-AR-LOCKOUT-IND           
A05058        ADD  +1  TO CTR-ROWS                                      
              PERFORM 9999-END-PROGRAM        THRU 9999-EXIT            
           END-IF.                                                      
                                                                        
           MOVE PARM-ENTERED-DT           TO NH-NSF-ORIG-DT             
                                             RC-ENTERED-DT.             
REARCH     MOVE PARM-BANK-ID              TO PARM-BANK-ID-TEMP.         
           MOVE PARM-BANK-ID-RED          TO WS-BANK-ID-NUM.            
           MOVE WS-BANK-ID-NUM            TO NH-BANK-ID                 
                                             RC-BANK-ID.                
REARCH     MOVE PARM-BATCH-AMT            TO PARM-BATCH-AMT-TEMP        
           MOVE PARM-BATCH-AMT-RED        TO WS-BATCH-AMT.              
      *                                                                         
           PERFORM 5000-UPDATE                THRU 5000-EXIT            
                   VARYING WS-MEM-NO FROM 1 BY 1                        
                   UNTIL WS-MEM-NO GREATER THAN 75.                     
      *                                                                         
T25923     COMPUTE WS-BATCH-DIFF-AMT = WS-BATCH-AMT                     
T25923                               - WS-ENTERED-AMT.                  
      *                                                                         
T25923     IF WS-BATCH-DIFF-AMT NOT EQUAL ZERO                          
T25923        OR PARM-THIRD-PARTY NOT EQUAL '000'                       
      *                                                                         
T25923        MOVE WS-GL-CLR-CASH-KEY    TO GO-GL-ACCT-NAME             
T25923        PERFORM 7600-GET-GL-NO          THRU 7600-EXIT            
T25923        MOVE GO-GL-ACCT-NO         TO WS-GEN-LED-NO-CA-CLR        
      *                                                                         
              MOVE WS-GL-CSH-OV-SH-KEY   TO GO-GL-ACCT-NAME             
T25923*                                                                         
T25923        PERFORM 7600-GET-GL-NO                    THRU 7600-EXIT  
T25923* DETERMINE THE GL FOR THE OFFSET OR OV/SH                                
T25923* IF PARM-THIRD-PARTY = 000 THEN IT IS AN EITHER AN ERROR                 
T25923* OR INTERCOMPANY FIX. OTHERWISE IT IS AN OFFSET                          
T25923        IF PARM-THIRD-PARTY = '000'                               
T25923           IF PARM-ERROR-TYPE-IND = 'E'                           
T25923              MOVE '001' TO Y2-CASH-LOCAL-OFFICE                  
T25923              PERFORM 7210-SELECT-ERROR-GL-OFFSET THRU 7210-EXIT  
T25923              MOVE WS-ERROR-GL-OFFSET TO WS-GEN-LED-NO-OV-SH      
T25923           ELSE                                                   
T25923              IF PARM-ERROR-TYPE-IND = 'I'                        
T25923                 MOVE '001' TO Y2-CASH-LOCAL-OFFICE               
T25923                 MOVE 'IC-OV-SH'      TO GO-GL-ACCT-NAME          
T25923                 PERFORM 7600-GET-GL-NO           THRU 7600-EXIT  
T25923                 MOVE GO-GL-ACCT-NO   TO WS-GEN-LED-NO-OV-SH      
T25923              ELSE                                                
T25923                 MOVE GO-GL-ACCT-NO   TO WS-GEN-LED-NO-OV-SH      
T25923              END-IF                                              
T25923           END-IF                                                 
T25923        ELSE                                                      
T25923           MOVE PARM-THIRD-PARTY TO Y2-CASH-LOCAL-OFFICE          
T25923           PERFORM 7220-SELECT-DEP-CASH-GL-OFFSET THRU 7220-EXIT  
T25923           MOVE WS-ERROR-GL-OFFSET TO WS-GEN-LED-NO-OV-SH         
T25923        END-IF                                                    
      *                                                                         
T25923        IF WS-BATCH-DIFF-AMT < 0 OR                               
T25923           PARM-THIRD-PARTY NOT EQUAL '000'                       
      *                                                                         
T25923            MULTIPLY -1 BY WS-BATCH-DIFF-AMT                      
      *                                                                         
T25923            SET  OVERAGE-TRAN-ID      TO TRUE                     
T25923            MOVE WS-GEN-LED-NO-OV-SH  TO AU-GL-ACCT-CREDIT        
T25923            MOVE WS-GEN-LED-NO-CA-CLR TO AU-GL-ACCT-DEBIT         
T25923            IF PARM-THIRD-PARTY = '000'                           
T25923               MOVE WS-ENTERED-AMT    TO                          
T25923                              WS-JRNL-CASH-DEBIT-AMT              
T25923                              WS-JRNL-GEN-LEG-CREDIT-AMT          
T25923            ELSE                                                  
T25923               MOVE WS-ENTERED-AMT    TO                          
T25923                                 WS-JRNL-CASH-CREDIT-AMT          
T25923                                 WS-JRNL-GEN-LEG-DEBIT-AMT        
T25923            END-IF                                                
T25923        ELSE                                                      
T25923            SET  SHORTAGE-TRAN-ID     TO TRUE                     
T25923            MOVE WS-GEN-LED-NO-OV-SH  TO AU-GL-ACCT-DEBIT         
T25923            MOVE WS-GEN-LED-NO-CA-CLR TO AU-GL-ACCT-CREDIT        
T25923            MOVE WS-ENTERED-AMT       TO                          
T25923                                  WS-JRNL-CASH-CREDIT-AMT         
T25923                                  WS-JRNL-GEN-LEG-DEBIT-AMT       
T25923        END-IF                                                    
T25923*                                                                         
T25923        MOVE AT-ACCOUNT-NO           TO WS-HOLD-ACCT-NO           
T25923        MOVE 9999999999999           TO AT-ACCOUNT-NO             
T25923*                                                                         
T25923        MOVE AT-CUSTOMER-NO          TO WS-HOLD-CUST-NO           
T25923        MOVE 9999999999              TO AT-CUSTOMER-NO            
T25923*                                                                         
T25923        PERFORM 5750-OVERAGE-SHORTAGE-101       THRU 5750-EXIT    
T25923*                                                                         
T25923        MOVE 'N' TO WS-ERROR-ENTRY                                
T25923        PERFORM 5775-INS-OVERSHORT-TABLE        THRU 5775-EXIT    
T25923*                                                                         
T25923        MOVE WS-HOLD-ACCT-NO         TO AT-ACCOUNT-NO             
T25923        MOVE WS-HOLD-CUST-NO         TO AT-CUSTOMER-NO            
T25923     END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * MAIN UPDATE PARAGRAPH TO PROCESS EACH RETURN CHECK.         *           
      ***************************************************************           
       5000-UPDATE.                                                     
      *                                                                         
A05058     MOVE WS-MEM-NO              TO S-ROW-NO.                     
           MOVE 0                      TO AU-TRAN-APPL-NO.              
           IF PARM-ACCOUNT-NO (WS-MEM-NO) EQUAL SPACES                  
              MOVE +76                 TO WS-MEM-NO                     
A05058        ADD  +1  TO CTR-ROWS                                      
              GO TO 5000-EXIT                                           
           END-IF.                                                      
      *                                                                         
           MOVE '5000'                 TO ACTIVE-PARAGRAPH.             
T22767     MOVE 0                      TO WS-ACCOUNT-NO-NUM             
T22767                                    NH-NON-CIS-GL-ACCT            
T22767                                    NH-COMMENTS-LEN               
T22767     MOVE SPACE                  TO NH-PAYMENT-TYPE-TX            
T22767                                    NH-COMMENTS-TEXT              
P00599                                    CL-DATE-CREDIT-ACTION.        
      *                                                                         
           PERFORM 5600-GET-TIMESTAMP                THRU 5600-EXIT.    
           MOVE NH-TRANS-HIST-SEQ-NO   TO CURRENT-TIMESTAMP.            
P00935     PERFORM 7350-SELECT-RESP-AREA             THRU 7350-EXIT.    
      *                                                                         
P00581*****************************************************************         
P00581* DETERMINE IF ACCOUNT IS SCEG/PSNC OR SEB.                               
P00581*****************************************************************         
P00581     MOVE '01'               TO C8-COMPANY-NO.                    
C25816     MOVE 'DATABASE'         TO C8-DELINQ-CD.                     
C25816     PERFORM 7300-GET-DEL-VALUE  THRU 7300-EXIT.                  
C25816     MOVE C8-DELINQ-VALUE    TO WS-DATABASE.                      
C25816                                                                  
           PERFORM 5100-POPULATE-FIELDS              THRU 5100-EXIT.    
                                                                        
           MOVE WS-ACCOUNT-NO-NUM      TO AT-ACCOUNT-NO.                
T22767     IF PARM-AR-AGE (WS-MEM-NO) NOT EQUAL 'N'                     
              PERFORM 7999-SELECT-TRANSFER-IND                          
                 THRU 7999-SELECT-TRANSFER-IND-EXIT                     
      *                                                                         
              IF AT-ACCT-XFER-TO > ZERO                                 
A05058          MOVE 5000 TO S-RETURN-CODE                              
A05058          MOVE AT-ACCT-XFER-TO     TO S-ACCT-XFER-TO              
A05058          ADD  +1  TO CTR-ROWS                                    
                PERFORM 9999-END-PROGRAM              THRU 9999-EXIT    
              END-IF                                                    
                                                                        
      *---< SELECT DATA FROM ACCOUNT, PREMISE, CUSTOMER TABLES >---*            
              PERFORM 7000-SELECT-ACCOUNT             THRU 7000-EXIT    
      *                                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
A05058           MOVE 100                 TO WS-ACTIVE-RETURN-CODE      
                 MOVE +76                 TO WS-MEM-NO                  
                 MOVE 'Y'                 TO WS-ERROR-IND               
A05058           ADD  +1  TO CTR-ROWS                                   
                 PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT    
                 GO TO 5000-EXIT                                        
              END-IF                                                    
                                                                        
      *---< CHECK IF POSTING IS TO BE DONE ON TRANSFERRED >---*                 
      *---< TO ACCOUNT.                                   >---*                 
              IF (PARM-ACCT-XFER-IND (WS-MEM-NO) EQUAL 'Y'              
                 AND AT-ACCT-XFER-TO GREATER THAN 0)                    
                 MOVE AT-ACCT-XFER-TO     TO AT-ACCOUNT-NO              
                                             NH-ACCOUNT-NO              
                                             BE-ACCOUNT-NO              
                                             RC-ACCOUNT-NO              
                                             CZ-ACCOUNT-NO              
                                             CL-ACCOUNT-NO              
                                             WS-ACCOUNT-NO-NUM          
      *                                                                         
                 PERFORM 7000-SELECT-ACCOUNT           THRU 7000-EXIT   
                 IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND               
A05058              MOVE 100                 TO WS-ACTIVE-RETURN-CODE   
                    MOVE +76                 TO WS-MEM-NO               
                    MOVE 'Y'                 TO WS-ERROR-IND            
A05058              ADD  +1  TO CTR-ROWS                                
                    PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT   
                    GO TO 5000-EXIT                                     
                 END-IF                                                 
              END-IF                                                    
                                                                        
              MOVE AT-CODES-DATA-PRESENT  TO WS-CODES-DATA-PRESENT      
              MOVE AT-PREMISE-NO          TO PR-PREMISE-NO              
              MOVE AT-CUSTOMER-NO         TO CU-CUSTOMER-NO             
              PERFORM 7100-SELECT-PREMISE              THRU 7100-EXIT   
              PERFORM 7200-SELECT-CUSTOMER             THRU 7200-EXIT   
                                                                        
              MOVE AT-COMPANY-NO          TO GO-COMPANY-NO              
T22767     END-IF.                                                      
                                                                        
           MOVE WS-BANK-ID-NUM         TO D1-BANK-ID                    
                                                                        
T22767     IF PARM-AR-AGE (WS-MEM-NO) EQUAL 'N'                         
              PERFORM 7075-SELECT-COMPANY            THRU 7075-EXIT     
T22767     END-IF.                                                      
           PERFORM 7610-SELECT-BANK-GL               THRU 7610-EXIT     
           MOVE D1-CASH-GL-ACCT-NO     TO WS-GEN-LED-NO-BANK            
                                                                        
           IF PARM-NSC-REMOVE-FL ( WS-MEM-NO ) = 'Y'                    
      *---< UPDATE ROW IN CSS_NSF_HIST >---*                                    
              PERFORM 8170-UPDATE-CSS-NSF-HIST THRU 8170-EXIT           
           ELSE                                                         
      *---< INSERT ROW IN CSS_NSF_HIST >---*                                    
              PERFORM 8150-INSERT-CSS-NSF-HIST THRU 8150-EXIT           
           END-IF                                                       
                                                                        
T22767     IF PARM-AR-AGE ( WS-MEM-NO ) NOT = 'N'                       
      *---< UPDATE TRANSACTION HISTORY HEADER >---*                             
T10101        PERFORM 7900-SELECT-AR-HEADER    THRU 7900-EXIT           
      *                                                                         
              IF AR-AMT-ORIG-ENTERED EQUAL WS-TOTAL-RET-AMT             
      *                                                                         
                 PERFORM 8800-UPDATE-AR-HEADER THRU 8800-EXIT           
      *                                                                         
              END-IF                                                    
T22767     END-IF.                                                      
      *                                                                         
           MOVE AT-ACCOUNT-NO             TO AR-ACCOUNT-NO.             
                                                                        
TP5022     COMPUTE WS-TOTAL-RET-AMT      =(WS-TOTAL-RET-AMT +           
TP5022                                     NH-NSF-CHARGE-AMT).          
                                                                        
      *---< CREATE AR AND JOURNAL FOR NSA >---*                                 
           MOVE WS-GEN-LED-NO-BANK        TO WS-GEN-LED-NO-CREDIT.      
      *                                                                         
T22767     IF PARM-AR-AGE (WS-MEM-NO) EQUAL 'N'                         
T22767        MOVE 'CLR-CASH'             TO GO-GL-ACCT-NAME            
T22767        PERFORM 7600-GET-GL-NO THRU 7600-EXIT                     
T22767        MOVE GO-GL-ACCT-NO          TO WS-GEN-LED-NO-CREDIT       
T22767        MOVE NH-NON-CIS-GL-ACCT     TO WS-GEN-LED-NO-NSF          
T22767        PERFORM 5310-UPDATE-NSA-NSN THRU 5310-EXIT                
T22767     END-IF.                                                      
                                                                        
T22767     IF PARM-AR-AGE (WS-MEM-NO) NOT EQUAL 'N'                     
              IF WS-UTIL-AMT GREATER THAN 0                             
                 MOVE WS-GL-AR-NSA-KEY       TO GO-GL-ACCT-NAME         
                 PERFORM 7600-GET-GL-NO THRU 7600-EXIT                  
                 MOVE GO-GL-ACCT-NO          TO WS-GEN-LED-NO-NSF       
                 MOVE WS-NSA-PPL             TO WS-NSF-PPL              
                 MOVE WS-UTIL-AMT            TO WS-CHECK-AMOUNT         
                 PERFORM 5310-UPDATE-NSA-NSN THRU 5310-EXIT             
T22767        END-IF                                                    
                                                                        
      *---< CREATE AR AND JOURNAL FOR NSN >---*                                 
              IF WS-NON-UTIL-AMT GREATER THAN 0                         
                 MOVE WS-GL-AR-NSN-KEY       TO GO-GL-ACCT-NAME         
                 PERFORM 7600-GET-GL-NO THRU 7600-EXIT                  
                 MOVE GO-GL-ACCT-NO          TO WS-GEN-LED-NO-NSF       
                 MOVE WS-NSN-PPL             TO WS-NSF-PPL              
                 MOVE WS-NON-UTIL-AMT        TO WS-CHECK-AMOUNT         
                 PERFORM 5310-UPDATE-NSA-NSN THRU 5310-EXIT             
              END-IF                                                    
                                                                        
      *---< CREATE AR AND JOURNAL FOR NSC >---*                                 
              IF NH-NSF-CHARGE-AMT GREATER THAN 0                       
TP9573           MOVE WS-A                   TO WS-CODE-NSF-CHK-CHG     
                 MOVE WS-GL-AR-NSC-KEY       TO GO-GL-ACCT-NAME         
                 PERFORM 7600-GET-GL-NO      THRU 7600-EXIT             
                 MOVE GO-GL-ACCT-NO          TO WS-GEN-LED-NO-NSF       
                 MOVE WS-GL-REV-NSC-KEY      TO GO-GL-ACCT-NAME         
                 PERFORM 7600-GET-GL-NO      THRU 7600-EXIT             
                 MOVE GO-GL-ACCT-NO          TO WS-GEN-LED-NO-CREDIT    
                 MOVE WS-NSC-PPL             TO WS-NSF-PPL              
                 MOVE NH-NSF-CHARGE-AMT      TO WS-CHECK-AMOUNT         
                 PERFORM 5310-UPDATE-NSA-NSN THRU 5310-EXIT             
              END-IF                                                    
                                                                        
      *---< UPDATE CREDIT ACTION FORECAST DETAILS >---*                         
C26954        PERFORM 6000-SET-SEB-REG-90205-FL THRU 6000-EXIT          
P00599        IF (AT-CODE-ACCT-STAT = 'S' OR (AT-CODE-ACCT-STAT = 'B'   
P00599        AND AT-ACCT-FINALED-DT NOT EQUAL TO SPACES))              
P0059A           MOVE SPACES         TO WS-CSR03515-MAX-DEP-ZERO-WQ     
P00599           PERFORM 5250-LOAD-FIN-WO-ACTION                        
P00599                                          THRU 5250-EXIT          
P00599           PERFORM 8750-INSERT-FIN-WO-ACTION                      
P00599                                          THRU 8750-EXIT          
P0059A           IF CSR-DATABASE                                        
P0059A              PERFORM 5830-CREATE-WQ      THRU 5830-EXIT          
P0059A           END-IF                                                 
P00599        ELSE                                                      
P00599           PERFORM 5320-UPDATE-CRED-ACTION                        
P00599                                          THRU 5320-EXIT          
P00599        END-IF                                                    
T22767     END-IF.                                                      
                                                                        
           PERFORM 8400-DELETE-RETURN-CHECK THRU 8400-EXIT.             
      *                                                                         
T22767     PERFORM 8549-GET-CURRENT-TIMESTAMP       THRU 8549-EXIT.     
T22767     MOVE WS-CD-COMPANY-NO        TO YB-CASH-COMPANY-NO.          
T22767     MOVE WS-CD-LOCAL-OFFICE      TO YB-CASH-LOCAL-OFFICE.        
T22767     MOVE WS-CD-REPORT-DATE       TO YB-DATE-CASH-REPORT.         
T22767     MOVE WS-CASH-DRAWER-ID       TO YB-CASH-DRAWER-ID.           
T22767     MOVE WS-BANK-ID-NUM          TO YB-BANK-ID.                  
T22767     MOVE NH-NSF-TYPE-CD          TO YB-CURRENCY-TYPE.            
T22767     MOVE PARM-USER-ID            TO YB-USER-ID.                  
T22767     MOVE 'C'                     TO YB-CODE-DR-CR.               
T22767     MOVE WS-XFR-TS               TO YB-TRANSFER-TS.              
                                                                        
T22767     IF PARM-AR-AGE ( WS-MEM-NO )  = 'N'                          
T22767        MOVE PARM-RTN-CHK-AMT-RED (WS-MEM-NO)                     
T22767                                       TO WS-AMT-CASH-DEBIT       
T22767     ELSE                                                         
T22767        MOVE NH-RETURN-CHECK-AMT       TO WS-AMT-CASH-DEBIT       
T22767     END-IF                                                       
                                                                        
C25923     MOVE WS-AMT-CASH-DEBIT             TO YB-TRANSFER-AMT        
      *                                                                         
      *    DO NOT PERFORM BANK XFER IF IT IS A THIRD PARTY OR A                 
      *    ERROR OR INTERCOMPANY FIX                                            
T25923     IF PARM-THIRD-PARTY = '000'                                  
T25923        IF PARM-ERROR-TYPE-IND NOT EQUAL 'I'                      
T25923           IF PARM-ERROR-TYPE-IND NOT EQUAL 'E'                   
C25923             PERFORM 8880-CREATE-BANK-TRANSFER  THRU 8880-EXIT    
                 END-IF                                                 
T25923        END-IF                                                    
T25923     END-IF.                                                      
      *    IF THIS IS AN ERROR-OV-SH OR AN INTERCOMPANY-OV-SH                   
      *    ENTRY OR CORRECTION, INSERT ENTRY INTO CSS_OVERSHORT_TABLE           
T25923     IF PARM-PAYMENT-TYPE (WS-MEM-NO) EQUAL 'INTERCOMPANY' OR     
T25923        PARM-PAYMENT-TYPE (WS-MEM-NO) EQUAL 'ERROR OV/SH'         
T25923           PERFORM 5775-INS-OVERSHORT-TABLE THRU 5775-EXIT        
T25923     END-IF.                                                      
      *                                                                         
T22767     IF PARM-AR-AGE (WS-MEM-NO) NOT EQUAL 'N'                     
TP5033        IF WS-BANK-DRAFT-REMOVED = 'Y'                            
TP5033           MOVE SPACES                  TO WS-CODE-BANK-EFT       
TP5033        END-IF                                                    
      *                                                                         
TP5033        MOVE 'A'                        TO WS-CODE-NSF-HIST       
      *                                                                         
              MOVE WS-CODES-DATA-PRESENT      TO AT-CODES-DATA-PRESENT  
              PERFORM 8000-UPDATE-CSS-ACCOUNT THRU 8000-EXIT            
T22767     END-IF.                                                      
                                                                        
C26296     IF  PARM-CURRENCY-TYPE (WS-MEM-NO) EQUAL 'C'                 
C26296     AND PARM-AR-AGE (WS-MEM-NO) NOT EQUAL 'N'                    
C26296         PERFORM 5810-PROCESS-AUTO-DEPOSIT THRU 5810-EXIT         
C26296         IF  WS-AUTO-DEP-CERT-NO > 0                              
C26296             MOVE WS-AUTO-DEP-CERT-NO    TO NH-DEPOSIT-CERT-NO    
C26296             PERFORM 8190-UPDATE-NSF-DEP-CERT-NO                  
C26296                THRU 8190-EXIT                                    
C26296         END-IF                                                   
C26296     END-IF                                                       
P00726*    Cancel credit arrangements process                                   
P00726     IF PARM-AR-AGE (WS-MEM-NO) NOT EQUAL 'N'                     
P00726        AND WS-CODE-CRED-ARNG = 'A'                               
P00726        AND CANCEL-CRED-ARNG                                      
P00726        MOVE WS-ACCOUNT-NO-NUM         TO WS-KR360-ACCOUNT-NO     
ACT005* SELECT CODES-DATA-PRESENT BEFORE UPDATING AS AUTO DEPOSIT               
ACT005* COULD HAVE UPDATED THE CODES DATA PRESENT AFTER THE RETRIEVE            
ACT005        PERFORM 7020-SELECT-ACCOUNT  THRU 7020-EXIT               
ACT005        MOVE AT-CODES-DATA-PRESENT     TO                         
ACT005                                          WS-CODES-DATA-PRESENT   
P00726        MOVE 0                         TO WS-KR360-PREMISE-NO     
P00726                                          WS-KR360-CUSTOMER-NO    
P00935        MOVE PF-RESP-AREA-ID           TO WS-KR360-RESP-AREA-ID   
P00726        MOVE PARM-USER-ID              TO WS-KR360-USER-ID        
P0726A        STRING 'ACTIVE CREDIT ARRANGEMENT WAS CANCELLED DUE TO '  
P0726A               'RETURN CHECK'      DELIMITED BY SIZE              
P0726A                                       INTO WS-KR360-COMMENT-TEXT 
P0726A        MOVE +59                       TO WS-KR360-COMMENT-LEN    
P00726        MOVE 'F'                       TO WS-KR360-CODE-TRAN-TYPE 
P00726        PERFORM 5100-CNCL-CRED-ARNG-PROCESS THRU 5100-CPD360-EXIT 
P00726        MOVE 'N'                       TO WS-CANCEL-ARNG-SW       
P00726     END-IF.                                                      
P00726                                                                  
           IF WS-MEM-NO EQUAL 75                                        
A05058        ADD  +1  TO CTR-ROWS                                      
           END-IF.                                                      
T22767     MOVE 0                            TO WS-ACCOUNT-NO-NUM       
T22767                                          NH-NON-CIS-GL-ACCT      
T22767                                          NH-COMMENTS-LEN         
T22767     MOVE SPACE                        TO NH-PAYMENT-TYPE-TX      
T22767                                          NH-COMMENTS-TEXT.       
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * MOVE PARAMETER FIELDS INTO WORKING STORAGE                 *            
      **************************************************************            
       5100-POPULATE-FIELDS.                                            
                                                                        
           MOVE PARM-ACCOUNT-NO-RED (WS-MEM-NO)                         
                                          TO WS-ACCOUNT-NO-NUM.         
           MOVE WS-ACCOUNT-NO-NUM         TO AT-ACCOUNT-NO              
                                             NH-ACCOUNT-NO              
                                             BE-ACCOUNT-NO              
                                             AR-ACCOUNT-NO              
                                             RC-ACCOUNT-NO              
                                             CZ-ACCOUNT-NO              
P00599                                       KD-ACCOUNT-NO              
PCR263                                       CL-ACCOUNT-NO              
PCR263                                       CA-ACCOUNT-NO.             
           MOVE PARM-NON-UTIL-RED (WS-MEM-NO)                           
                                          TO WS-NON-UTIL-AMT.           
C26296     MOVE PARM-SEND-NOTICE-CD (WS-MEM-NO)                         
C26296                                    TO NH-SEND-NOTICE-CD.         
           MOVE WS-NON-UTIL-AMT           TO NH-CHECK-NONUTIL-AMT.      
           MOVE PARM-UTIL-RED (WS-MEM-NO) TO WS-UTIL-AMT.               
           MOVE WS-UTIL-AMT               TO NH-CHECK-UTIL-AMT.         
           COMPUTE WS-TOTAL-RET-AMT   = WS-NON-UTIL-AMT                 
                                         + WS-UTIL-AMT.                 
           MOVE WS-TOTAL-RET-AMT          TO NH-RETURN-CHECK-AMT.       
           MOVE CURRENT-DATE              TO NH-DATE-TRAN.              
           MOVE PARM-AR-AGE (WS-MEM-NO)   TO WS-AR-AGE.                 
T22767     MOVE SPACES                   TO WS-DRAWN-BY-NM              
T22767                                      NH-DRAWN-BY-NM              
           MOVE PARM-DRAWN-BY-NM-LEN (WS-MEM-NO)                        
                                          TO WS-DRAWN-BY-NM-LEN         
           MOVE PARM-DRAWN-BY-NM-TEXT (WS-MEM-NO)                       
                                          TO WS-DRAWN-BY-NM-TEXT        
           MOVE WS-DRAWN-BY-NM            TO NH-DRAWN-BY-NM             
P00935     MOVE PARM-NCIS-COMMENTS-LEN  (WS-MEM-NO)                     
P00935                                    TO NH-COMMENTS-LEN            
P00935     MOVE PARM-NCIS-COMMENTS-TEXT (WS-MEM-NO)                     
P00935                                    TO NH-COMMENTS-TEXT           
T22767     IF PARM-AR-AGE (WS-MEM-NO) NOT EQUAL 'N'                     
              MOVE PARM-WAIVE-CHARGE (WS-MEM-NO)                        
                                          TO NH-NSC-REMOVE-FL           
                                                                        
              IF PARM-WAIVE-CHARGE (WS-MEM-NO) = 'Y' THEN               
                 MOVE 0                   TO NH-NSF-CHARGE-AMT          
              ELSE                                                      
T23501           PERFORM 7010-SELECT-COMPANY THRU 7010-EXIT             
T23501           MOVE AT-COMPANY-NO       TO C8-COMPANY-NO              
P00581           IF SEB-DATABASE                                        
P00581              PERFORM 5200-GET-CHRG-AMT-DEL-CD THRU   5200-EXIT   
P00581           ELSE                                                   
                    MOVE WS-CHECKCHARGE      TO C8-DELINQ-CD            
P00581           END-IF                                                 
                 PERFORM 7300-GET-DEL-VALUE                             
                 MOVE C8-DELINQ-VALUE     TO NH-NSF-CHARGE-AMT          
              END-IF                                                    
T22767     END-IF.                                                      
           MOVE PARM-NSF-REASON-CD (WS-MEM-NO)                          
                                          TO NH-NSF-REASON-CD.          
           MOVE 'C'                       TO NH-NSF-STATUS-CD.          
           MOVE PARM-NSF-TIMESTAMP (WS-MEM-NO)                          
                                          TO NH-NSF-TIMESTMP.           
           MOVE PARM-TRN-HST-SEQ-NO (WS-MEM-NO)                         
                                          TO AR-TRANS-HIST-SEQ-NO.      
           MOVE PARM-CURRENCY-TYPE (WS-MEM-NO)                          
                                          TO NH-NSF-TYPE-CD.            
           MOVE PARM-WAIVE-REASON-CD (WS-MEM-NO)                        
                                          TO NH-WAIVER-REASON-CD.       
           ADD WS-TOTAL-RET-AMT           TO WS-ENTERED-AMT.            
T25923     MOVE PARM-PARTIAL-PYMT-FL (WS-MEM-NO)  TO NH-PARTIAL-PYMT-FL 
T25923     MOVE PARM-PARTIAL-PYMT-FL (WS-MEM-NO)  TO YB-PARTIAL-PYMT-FL 
T25923     MOVE PARM-BANK-POST-DT (WS-MEM-NO)     TO NH-BANK-POST-DT    
T25923     MOVE PARM-BANK-POST-DT (WS-MEM-NO)     TO YB-BANK-POST-DT    
T25923     MOVE PARM-DATE-ORIG-PYMT (WS-MEM-NO)   TO NH-DATE-ORIG-PYMT  
T25923     MOVE PARM-ORIG-PYMT-OFFICE (WS-MEM-NO) TO NH-ORIG-PYMT-OFFICE
T22767     MOVE 0                         TO NH-NON-CIS-ACCT-NO         
T22767     IF PARM-AR-AGE (WS-MEM-NO) EQUAL 'N'                         
T22767        MOVE SPACES                 TO WS-DRAWN-BY-NM-TEXT        
T22767        MOVE WS-DRAWN-BY-NM         TO NH-DRAWN-BY-NM             
T22767        MOVE 0                      TO NH-NSF-CHARGE-AMT          
T22767        MOVE PARM-ACCOUNT-NO-RED (WS-MEM-NO)                      
T22767                                    TO WS-ACCOUNT-NO-NUM          
T22767        MOVE WS-ACCOUNT-NO-NUM      TO NH-NON-CIS-ACCT-NO         
T22767        PERFORM 7150-CHECK-ACCT     THRU 7150-EXIT                
T22767        MOVE 00000000000            TO AT-ACCOUNT-NO              
T22767                                       AT-CUSTOMER-NO             
T22767        MOVE 00000000000            TO AT-TOTAL-AR-BALANCE        
C31110        MOVE '01'                   TO AT-COMPANY-NO              
T22767        MOVE PARM-RTN-CHK-AMT-RED (WS-MEM-NO)                     
T22767                                    TO NH-RETURN-CHECK-AMT        
T22767                                       WS-TOTAL-RET-AMT           
T22767                                       WS-CHECK-AMOUNT            
T25923        ADD  WS-TOTAL-RET-AMT       TO WS-ENTERED-AMT             
T22767        MOVE PARM-PAYMENT-TYPE (WS-MEM-NO)                        
T22767                                    TO NH-PAYMENT-TYPE-TX         
T22767        MOVE PARM-GL-ACCOUNT-RED (WS-MEM-NO)                      
T22767                                    TO NH-NON-CIS-GL-ACCT         
T22767     END-IF.                                                      
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00726******************************************************************        
P00726* 5100-CNCL-CRED-ARNG-PROCESS                                  ***00022000
P00726******************************************************************        
P00726                                                                  
P00726     EXEC SQL                                                             
P00726        INCLUDE CPDKR360                                                  
P00726     END-EXEC.                                                            
P00726                                                                  
      **************************************************************            
P00581* GET THE DELINQ CODE FOR GETTING THE RETURN CHECK CHARGE AMT*            
      **************************************************************            
P00581 5200-GET-CHRG-AMT-DEL-CD.                                        
P00581*                                                                         
P00581     INITIALIZE WS-CSR04533-OUTPUT.                               
P00581*                                                                         
P00581*    EXEC SQL CALL CSR04533                                       
P00581*        (:AT-ACCOUNT-NO)                                         
P00581*    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE CHRG_AMT
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN CHRG_AMT
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR CHRG_AMT INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
P00581*                                                                         
P00581     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
P00581*                                                                         
P00581     IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
P00581        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00581        MOVE '5200'                TO ACTIVE-PARAGRAPH            
P00581        MOVE 'DB2SP CALL'          TO ABEND-FUNCTION              
P00581        MOVE 'CSR04533'            TO TABLE-1                     
P00581        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
P00581        MOVE 'SQLCODE '            TO TABLE-ELEMENT-2             
P00581        MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
P00581        MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-2           
P00581        PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
P00581     END-IF.                                                      
P00581*                                                                         
P00581*    EXEC SQL ASSOCIATE LOCATORS(:LOC2) WITH PROCEDURE            
P00581*       CSR04533                                                  
P00581*    END-EXEC.                                                    
P00581*                                                                         
P00581*    EXEC SQL                                                     
P00581*       ALLOCATE CHRG_AMT CURSOR FOR RESULT SET :LOC2             
P00581*    END-EXEC.                                                    
P00581*                                                                         
P00581     EXEC SQL                                                     
P00581        FETCH CHRG_AMT                                            
P00581        INTO         :WS-4533-RETURN-CODE                         
P00581                    ,:WS-4533-EFF-REV-MTH                         
P00581                    ,:WS-4533-CALC-TYPE-CD                        
P00581                    ,:WS-4533-OPT-AGR-EFF-DT                      
P00581     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00581*                                                                         
P00581     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
P00581     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00581         WHEN SUCCESSFUL-CALL                                     
P00581             IF WS-4533-RETURN-CODE = 0 OR NOT-FOUND              
P00581                PERFORM 5300-PROCESS-FETCH-VALUES THRU 5300-EXIT  
P00581             ELSE                                                 
P00581                MOVE WS-4533-RETURN-CODE TO WS-ACTIVE-RETURN-CODE 
P00581                MOVE PROGRAM-NAME        TO ABEND-PROGRAM         
P00581                MOVE '5200'              TO ACTIVE-PARAGRAPH      
P00581                MOVE 'FETCH'             TO ABEND-FUNCTION        
P00581                MOVE 'CSR04533'          TO TABLE-1               
P00581                MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1       
P00581                MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1     
P00581                PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT      
P00581             END-IF                                               
P00581         WHEN OTHER                                               
P00581             MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
P00581             MOVE '5200'                 TO ACTIVE-PARAGRAPH      
P00581             MOVE 'FETCH'                TO ABEND-FUNCTION        
P00581             MOVE 'CSR04533'             TO TABLE-1               
P00581             MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1       
P00581             MOVE 'SQLCODE '             TO TABLE-ELEMENT-2       
P00581             MOVE AT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1     
P00581             MOVE WS-ACTIVE-RETURN-CODE  TO HOSTVAR-ELEMENT-2     
P00581             PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT         
P00581     END-EVALUATE.                                                
P00581*                                                                         
P00581     EXEC SQL                                                     
P00581        CLOSE CHRG_AMT                                            
P00581     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00581*                                                                         
P00581     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
P00581     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00581        CONTINUE                                                  
P00581     ELSE                                                         
P00581        MOVE '5200'                TO ACTIVE-PARAGRAPH            
P00581        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00581        MOVE 'CLOSE'               TO ABEND-FUNCTION              
P00581        MOVE 'CSR04533'            TO TABLE-1                     
P00581        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
P00581        MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
P00581        MOVE 'SQLCODE '            TO TABLE-ELEMENT-2             
P00581        MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-2           
P00581        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
P00581     END-IF.                                                      
P00581*                                                                         
P00581 5200-EXIT.                                                       
P00581     EXIT.                                                        
P00581*                                                                         
P00599**************************************************************            
P00599* LOAD THE FIELDS OF CSS_FIN_WO_ACTION TABLE                 *            
P00599**************************************************************            
P00599 5250-LOAD-FIN-WO-ACTION.                                         
P00599*                                                                         
P00599     MOVE CURRENT-DATE           TO WS-DATE-HOLD.                 
P00599     PERFORM 5400-GET-NEXT-BUSINESS-DAY THRU 5400-EXIT            
P00599        VARYING WS-NEXT-DATE-COUNT FROM 1 BY 1 UNTIL              
P00599        WS-NEXT-DATE-COUNT GREATER THAN 1.                        
P00599     MOVE WS-DATE-HOLD           TO KD-FW-ACTION-DT.              
P0599B     MOVE KD-FW-ACTION-DT        TO WS-FW-ACTION-DT.              
P0599B     PERFORM 6600-PROCESS-CALC-NEW-SEQ-NO                         
P0599B                                 THRU 6600-CPD348-EXIT.           
P0599B     MOVE WS-NEW-SEQ-NO          TO KD-FW-SEQ-NO.                 
P00599     MOVE WS-TOTAL-RET-AMT       TO KD-FW-ACTION-AM.              
P00599     MOVE SPACES                 TO KD-FW-MANUAL-FL.              
P00599     MOVE +26                    TO KD-FW-ACTION-COMMENTS-LEN.    
P00599     MOVE NH-NSF-TIMESTMP        TO                               
P00599                                 KD-FW-ACTION-COMMENTS-TEXT(1:26).
P00599     MOVE SPACES                 TO KD-FW-PROCESSED-FL.           
P00599     IF AT-CODE-ACCT-STAT = 'B'                                   
P00599        MOVE '90205'             TO KD-FW-ACTION-TYPE-CD          
P00599        MOVE 'FN'                TO KD-FW-BUS-PROCESS-CD          
P00599     END-IF.                                                      
P00599     IF AT-CODE-ACCT-STAT = 'S'                                   
P00599        MOVE '90205'             TO KD-FW-ACTION-TYPE-CD          
P00599        MOVE 'WL'                TO KD-FW-BUS-PROCESS-CD          
P00599     END-IF.                                                      
P00599*                                                                         
P00599 5250-EXIT.                                                       
P00599     EXIT.                                                        
P00581****************************************************************  07920000
P00581* 5300-PROCESS-FETCH-VALUES.                                   *  07930000
P00581****************************************************************  07940000
P00581 5300-PROCESS-FETCH-VALUES.                                       
P00581*                                                                         
P00581     PERFORM 6100-CHECK-SEB-REG THRU 6100-EXIT.                   
P00581*                                                                         
P00581     IF WS-SEB-REGULATED-FL = 'N'                                 
P00581        MOVE 'DEREG-NSC'        TO G6-PROGRAM-NAME                
P00581     ELSE                                                         
P00581        IF LR-REG-GROUP-CD = '100'                                
P00581           MOVE 'REG1-NSC'      TO G6-PROGRAM-NAME                
P00581        ELSE                                                      
P00581           MOVE 'REG2-NSC'      TO G6-PROGRAM-NAME                
P00581        END-IF                                                    
P00581     END-IF.                                                      
P00581*                                                                         
P00581     PERFORM 7260-GET-JOB-PARM-VALUES  THRU 7260-EXIT.            
P00581*                                                                         
P00581     IF WS-4533-CALC-TYPE-CD    NOT = WS-FP                       
P00581        MOVE CURRENT-DATE       TO WS-4533-OPT-AGR-EFF-DT         
P00581     END-IF.                                                      
P00581*                                                                         
P00677     IF WS-SEB-REGULATED-FL = 'Y'                                 
P00677        MOVE CURRENT-DATE       TO WS-4533-OPT-AGR-EFF-DT         
P00677     END-IF.                                                      
P00677*                                                                         
P00581     IF WS-4533-OPT-AGR-EFF-DT < WS-FEE-INCR-DATE                 
P00581        MOVE WS-OLD-DELINQ-CD   TO C8-DELINQ-CD                   
P00581     ELSE                                                         
P00581        MOVE WS-NEW-DELINQ-CD   TO C8-DELINQ-CD                   
P00581     END-IF.                                                      
P00581*                                                                         
P00581 5300-EXIT.                                                       
P00581     EXIT.                                                        
P0CC81*                                                                         
      ***************************************************************           
      * 5310-UPDATE-NSA-NSN                                         *           
      ***************************************************************           
       5310-UPDATE-NSA-NSN.                                             
                                                                        
           MOVE WS-A                     TO WS-CODE-NSF-CHK-AMT.        
           MOVE WS-GEN-LED-NO-NSF        TO AU-GL-ACCT-DEBIT.           
           MOVE WS-GEN-LED-NO-CREDIT     TO AU-GL-ACCT-CREDIT.          
           MOVE WS-TOTAL-RET-AMT         TO AR-AMT-ORIG-ENTERED.        
T13899     MOVE WS-DATE-ORIG-PYMT        TO AR-DATE-ORIG-PYMT.          
           MOVE CURRENT-TIMESTAMP        TO AR-TRANS-HIST-SEQ-NO        
                                            AU-TRANS-HIST-SEQ-NO.       
           MOVE CURRENT-DATE             TO AR-DATE-TRANS               
                                            AT-DATE-LAST-ACTION.        
PCR404     MOVE 'S'                      TO AR-CODE-TRAN-TYPE.          
           MOVE AT-COMPANY-NO            TO AR-COMPANY-NO.              
T8927      MOVE SPACES                   TO AU-CURRENCY-TYPE.           
      *                                                                         
A05058     EVALUATE NH-NSF-TYPE-CD                                      
T10339        WHEN 'C'                                                  
PCR404           MOVE 'PANEL181A'               TO AR-APPL-PROGRAM-ID   
A05058        WHEN 'M'                                                  
A05058           MOVE 'PANEL181M'               TO AR-APPL-PROGRAM-ID   
              WHEN OTHER                                                
                 MOVE 'PANEL181B'               TO AR-APPL-PROGRAM-ID   
A05058     END-EVALUATE.                                                
      *                                                                         
P00935     MOVE PF-RESP-AREA-ID          TO AR-RESP-AREA-ID.            
           MOVE PARM-USER-ID             TO AR-USER-ID.                 
           MOVE SPACES                   TO AR-PYMT-FACILITY-CD         
                                            AR-RECORD-ONLY-FL           
                                            AU-CODE-CONTRACT-TYPE.      
           MOVE WS-ACCOUNT-NO-NUM        TO AC-ACCOUNT-NO               
                                            AR-ACCOUNT-NO               
                                            AU-ACCOUNT-NO.              
FCSGL      MOVE '01'                     TO WS-CD-COMPANY-NO.           
PCR613     MOVE '001'                    TO WS-CD-LOCAL-OFFICE.         
FCSGL      MOVE '998'                    TO WS-CD-REPORT-NO.            
FCSGL      MOVE CURRENT-DATE             TO WS-CD-REPORT-DATE.          
PCR613     MOVE 9901                     TO WS-CASH-DRAWER-ID.          
FCSGL      MOVE WS-CD-COMPANY-NO         TO AR-CASH-COMPANY-NO.         
FCSGL      MOVE WS-CD-LOCAL-OFFICE       TO AR-CASH-LOCAL-OFFICE.       
FCSGL      MOVE WS-CD-REPORT-NO          TO AR-CASH-REPORT-NO.          
FCSGL      MOVE WS-CD-REPORT-DATE        TO AR-DATE-CASH-REPORT.        
FCSGL      MOVE WS-CASH-DRAWER-ID        TO AR-CASH-DRAWER-ID.          
           MOVE WS-NSF-PPL               TO AC-PYMT-PRIORITY-LVL.       
           MOVE ZERO                     TO AC-ITEM-ID.                 
T22767     IF PARM-AR-AGE (WS-MEM-NO) EQUAL 'N'                         
T22767        MOVE WS-CHECK-AMOUNT       TO AU-AMT-POSTED               
T22767                                      AU-CURRENCY-AMT             
T22767        MOVE WS-AR-AGE             TO AU-CODE-AR-AGE              
T22767        ADD 1                      TO AU-TRAN-APPL-NO             
T22767        MOVE WS-JRNL-ONLY          TO WS-JRNL-OPERATION-RQST      
T22767        PERFORM 5700-CASH-DRAWER-101 THRU 5700-EXIT               
T22767        GO TO 5310-EXIT                                           
T22767     END-IF.                                                      
           PERFORM 7240-SELECT-SUM-CSS-AR-CNTL THRU 7240-EXIT.          
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              EVALUATE WS-AR-AGE                                        
                 WHEN '0'                                               
                    MOVE WS-CHECK-AMOUNT  TO AC-AMT-AR-DAY-00           
                    MOVE ZERO             TO AC-AMT-AR-DAY-30           
                                             AC-AMT-AR-DAY-60           
                                             AC-AMT-AR-DAY-90           
                 WHEN '3'                                               
                    MOVE WS-CHECK-AMOUNT  TO AC-AMT-AR-DAY-30           
                    MOVE ZERO             TO AC-AMT-AR-DAY-00           
                                             AC-AMT-AR-DAY-60           
                                             AC-AMT-AR-DAY-90           
                 WHEN '6'                                               
                    MOVE WS-CHECK-AMOUNT  TO AC-AMT-AR-DAY-60           
                    MOVE ZERO             TO AC-AMT-AR-DAY-00           
                                             AC-AMT-AR-DAY-30           
                                             AC-AMT-AR-DAY-90           
                 WHEN '9'                                               
                    MOVE WS-CHECK-AMOUNT  TO AC-AMT-AR-DAY-90           
                    MOVE ZERO             TO AC-AMT-AR-DAY-00           
                                             AC-AMT-AR-DAY-30           
                                             AC-AMT-AR-DAY-60           
              END-EVALUATE                                              
      *                                                                         
              MOVE WS-CHECK-AMOUNT       TO AU-AMT-POSTED               
                                            AU-CURRENCY-AMT             
              ADD WS-CHECK-AMOUNT        TO AT-TOTAL-AR-BALANCE         
              MOVE AT-TOTAL-AR-BALANCE   TO AR-AMT-BILLED-UNPAID        
              MOVE ZERO                  TO AC-AMT-UNUSED-CR            
                                            AC-AMT-TRAN-BALANCE         
                                            AC-TOT-SUMM-UNBILLED        
              MOVE WS-AR-AGE             TO AU-CODE-AR-AGE              
              ADD 1                      TO AU-TRAN-APPL-NO             
              MOVE WS-JRNL-ONLY          TO WS-JRNL-OPERATION-RQST      
              PERFORM 5700-CASH-DRAWER-101 THRU 5700-EXIT               
              PERFORM 8500-INSERT-SUMM-CSS-AR-CNTRL THRU 8500-EXIT      
              PERFORM 6500-ONLINE-LOAD-AR-TRAN-HIST THRU 6500-EXIT      
           ELSE                                                         
              IF AC-AMT-UNUSED-CR LESS THAN ZERO                        
                 ADD 1                      TO AU-TRAN-APPL-NO          
                 MOVE WS-P                  TO AU-CODE-AR-AGE           
                 MOVE AC-AMT-UNUSED-CR      TO WS-UNUSED-CR-DOLLARS     
                 MULTIPLY -1 BY WS-UNUSED-CR-DOLLARS                    
                 IF WS-CHECK-AMOUNT GREATER THAN WS-UNUSED-CR-DOLLARS   
                    SUBTRACT WS-UNUSED-CR-DOLLARS FROM WS-CHECK-AMOUNT  
                    ADD WS-UNUSED-CR-DOLLARS TO AT-TOTAL-AR-BALANCE     
                    MOVE AT-TOTAL-AR-BALANCE TO AR-AMT-BILLED-UNPAID    
                    MOVE ZERO                TO AC-AMT-UNUSED-CR        
                    MOVE WS-UNUSED-CR-DOLLARS TO AU-AMT-POSTED          
                                                 AU-CURRENCY-AMT        
                    MOVE WS-JRNL-ONLY        TO WS-JRNL-OPERATION-RQST  
                    PERFORM 5700-CASH-DRAWER-101 THRU 5700-EXIT         
                    PERFORM 6500-ONLINE-LOAD-AR-TRAN-HIST THRU 6500-EXIT
                    MOVE WS-CHECK-AMOUNT     TO AU-AMT-POSTED           
                                                AU-CURRENCY-AMT         
                    ADD WS-CHECK-AMOUNT      TO AT-TOTAL-AR-BALANCE     
                    EVALUATE WS-AR-AGE                                  
                       WHEN '0'                                         
                          ADD  WS-CHECK-AMOUNT  TO AC-AMT-AR-DAY-00     
                       WHEN '3'                                         
                          ADD  WS-CHECK-AMOUNT  TO AC-AMT-AR-DAY-30     
                       WHEN '6'                                         
                          ADD  WS-CHECK-AMOUNT  TO AC-AMT-AR-DAY-60     
                       WHEN '9'                                         
                          ADD  WS-CHECK-AMOUNT  TO AC-AMT-AR-DAY-90     
                    END-EVALUATE                                        
                    ADD 1                    TO AU-TRAN-APPL-NO         
                    MOVE WS-AR-AGE           TO AU-CODE-AR-AGE          
                    MOVE AT-TOTAL-AR-BALANCE TO AR-AMT-BILLED-UNPAID    
                    MOVE WS-JRNL-ONLY        TO WS-JRNL-OPERATION-RQST  
                    PERFORM 5700-CASH-DRAWER-101 THRU 5700-EXIT         
                    PERFORM 8300-UPDATE-SUMM-CSS-AR-CNTRL THRU 8300-EXIT
                    PERFORM 6500-ONLINE-LOAD-AR-TRAN-HIST THRU 6500-EXIT
                 ELSE                                                   
                    MOVE SPACE               TO WS-CODE-NSF-CHK-AMT     
                    MOVE WS-CHECK-AMOUNT     TO AU-AMT-POSTED           
                                                AU-CURRENCY-AMT         
                    SUBTRACT WS-CHECK-AMOUNT FROM WS-UNUSED-CR-DOLLARS  
                    ADD WS-CHECK-AMOUNT      TO AT-TOTAL-AR-BALANCE     
                    MOVE AT-TOTAL-AR-BALANCE TO AR-AMT-BILLED-UNPAID    
                    MULTIPLY -1 BY WS-UNUSED-CR-DOLLARS                 
                    MOVE WS-UNUSED-CR-DOLLARS TO AC-AMT-UNUSED-CR       
                    MOVE WS-JRNL-ONLY         TO WS-JRNL-OPERATION-RQST 
                    PERFORM 5700-CASH-DRAWER-101 THRU 5700-EXIT         
                    PERFORM 8300-UPDATE-SUMM-CSS-AR-CNTRL THRU 8300-EXIT
                    PERFORM 6500-ONLINE-LOAD-AR-TRAN-HIST THRU 6500-EXIT
                 END-IF                                                 
              ELSE                                                      
                 EVALUATE WS-AR-AGE                                     
                    WHEN '0'                                            
                       ADD WS-CHECK-AMOUNT   TO AC-AMT-AR-DAY-00        
                    WHEN '3'                                            
                       ADD WS-CHECK-AMOUNT   TO AC-AMT-AR-DAY-30        
                    WHEN '6'                                            
                       ADD WS-CHECK-AMOUNT   TO AC-AMT-AR-DAY-60        
                    WHEN '9'                                            
                       ADD WS-CHECK-AMOUNT   TO AC-AMT-AR-DAY-90        
                 END-EVALUATE                                           
                 ADD 1                    TO AU-TRAN-APPL-NO            
                 MOVE WS-AR-AGE           TO AU-CODE-AR-AGE             
                 MOVE WS-CHECK-AMOUNT     TO AU-AMT-POSTED              
                                             AU-CURRENCY-AMT            
                 ADD WS-CHECK-AMOUNT      TO AT-TOTAL-AR-BALANCE        
                 MOVE AT-TOTAL-AR-BALANCE TO AR-AMT-BILLED-UNPAID       
                 MOVE WS-JRNL-ONLY        TO WS-JRNL-OPERATION-RQST     
                 PERFORM 5700-CASH-DRAWER-101 THRU 5700-EXIT            
                 PERFORM 8300-UPDATE-SUMM-CSS-AR-CNTRL THRU 8300-EXIT   
                 PERFORM 6500-ONLINE-LOAD-AR-TRAN-HIST THRU 6500-EXIT   
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * UPDATE CREDIT ACTION FORECAST DETAILS                       *           
      ***************************************************************           
       5320-UPDATE-CRED-ACTION.                                         
      *                                                                         
           PERFORM 5322-CALC-CRED-ACT-DATES           THRU 5322-EXIT.   
      *                                                                         
TP5033     PERFORM 7710-COUNT-N-ROWS                  THRU 7710-EXIT.   
      *                                                                         
TP5033     MOVE 'N'                     TO CL-CODE-NOTICE-TYPE.         
TP5033     MOVE ZEROES                  TO CL-ITEM-ID.                  
T21963     PERFORM 7720-SELECT-SUM-ROW-N              THRU 7720-EXIT.   
      *                                                                         
T21963     MOVE 'V'                     TO CL-CODE-NOTICE-TYPE.         
T21963     PERFORM 7721-SELECT-SUM-ROW-V              THRU 7721-EXIT.   
      *                                                                         
T21963     MOVE 'W'                     TO CL-CODE-NOTICE-TYPE.         
T21963     PERFORM 7722-SELECT-SUM-ROW-W              THRU 7722-EXIT.   
      *                                                                         
PCR136     IF AT-NOTICE-EXEMPT-CD > SPACES AND                          
PCR136        AT-NOTICE-EXEMPT-CD NOT EQUAL 'A'                         
PCR136        MOVE 'E'                 TO CZ-DISC-EXCEPTN-HIST (1:1)    
PCR136        PERFORM 8200-UPDATE-CREDIT-PROFILE        THRU 8200-EXIT  
      *                                                                         
PCR136        IF NH-SEND-NOTICE-CD NOT EQUAL TO 'N'                     
PCR136           MOVE 'N'              TO NH-SEND-NOTICE-CD             
PCR136           PERFORM 8180-UPDATE-NSF-SEND-NOTICE    THRU 8180-EXIT  
PCR163        END-IF                                                    
PCR136     END-IF.                                                      
      *                                                                         
           PERFORM 5325-PROCESS-NSF-COUNT               THRU 5325-EXIT. 
      *                                                                         
           PERFORM 7725-SELECT-SEND-NOT-CD              THRU 7725-EXIT. 
      *                                                                         
           IF NH-SEND-NOTICE-CD = 'Y'                                   
A05323        PERFORM 5330-PROCESS-XMPT-NON-UTIL   THRU 5330-EXIT       
           ELSE                                                         
              MOVE SPACE                 TO CL-CODE-SPECIAL-TYPE        
              MOVE ZEROES                TO CL-CODE-MESSAGE-TYPE        
              MOVE LOW-VALUES            TO CL-DATE-NOTICE-MAIL         
                                            CL-DATE-NOTICE-DUE          
                                            CL-DATE-CREDIT-ACTION       
T21963        PERFORM 5363-LOAD-CL-ROWS THRU 5363-EXIT                  
           END-IF.                                                      
      *                                                                         
       5320-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 5322-CALC-CRED-ACT-DATES                                                
      *                                                                         
      * THIS MODULE CALCULATES THE MAIL DATE, DUE DATE, AND DNP DATE            
      * FOR A RETURNED CHECK NOTICE.                                            
      *                                                                         
      *****************************************************************         
      *                                                                         
       5322-CALC-CRED-ACT-DATES.                                        
      *                                                                         
PCR263     MOVE CURRENT-DATE           TO WS-DATE-HOLD.                 
PCR263     PERFORM 5400-GET-NEXT-BUSINESS-DAY THRU 5400-EXIT            
PCR263        VARYING WS-NEXT-DATE-COUNT FROM 1 BY 1 UNTIL              
PCR263        WS-NEXT-DATE-COUNT GREATER THAN 1.                        
PCR263     MOVE WS-DATE-HOLD           TO WS-DATE-PLUS-1.               
                                                                        
PCR263     MOVE CURRENT-DATE           TO WS-DATE-HOLD.                 
PCR263     PERFORM 5400-GET-NEXT-BUSINESS-DAY THRU 5400-EXIT            
PCR263        VARYING WS-NEXT-DATE-COUNT FROM 1 BY 1 UNTIL              
PCR263        WS-NEXT-DATE-COUNT GREATER THAN 4.                        
TP5033     MOVE WS-DATE-HOLD           TO WS-DATE-PLUS-4                
                                                                        
TP5033     PERFORM 5400-GET-NEXT-BUSINESS-DAY THRU 5400-EXIT            
TP5033        VARYING WS-NEXT-DATE-COUNT FROM 1 BY 1 UNTIL              
TP5033        WS-NEXT-DATE-COUNT GREATER THAN 1.                        
TP5033     MOVE WS-DATE-HOLD           TO WS-DATE-PLUS-5.               
      *                                                                         
       5322-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 5325-PROCESS-NSF-COUNT                                                  
      *                                                                         
A05058* THIS MODULE WILL GET THE NUMBER OF COMPLETE RETURN CHECKS,              
A05058* BANK DRAFTS,CREDIT CARD PAYMENTS, AND MONEY ORDERS ON THE               
A05058* ACCOUNT IN THE PAST YEAR.                                               
      *                                                                         
A05058* 2 RETURNED CHECKS/DRAFTS/credit card payments/money orders              
A05058* within 12 months for all three companies.  Only 1 forgiven              
A05058* item is allowed to not be counted, all others will be.                  
      *****************************************************************         
       5325-PROCESS-NSF-COUNT.                                          
      *                                                                         
           MOVE CURRENT-DATE           TO WS-DATE-HOLD                  
                                          WS-TO-DATE.                   
           PERFORM 7700-GET-1-YEAR-AGO                  THRU 7700-EXIT. 
           MOVE WS-DATE-1-YEAR-AGO     TO WS-FROM-DATE.                 
      *                                                                         
           IF WS-CODE-BANK-EFT = 'A'                                    
              MOVE NH-ACCOUNT-NO          TO BE-ACCOUNT-NO              
A05058        PERFORM 7700A-GET-DRAFT-STAT-CODE        THRU 7700A-EXIT  
           END-IF.                                                      
      *                                                                         
A05058     MOVE ZEROES TO WS-NSF-COUNT                                  
A05058                    WS-NSF-COUNT-C                                
A05058                    WS-NSF-COUNT-F.                               
A05058**** COUNTS ALL ITEMS RETURNED  ****                                      
           PERFORM 7705-COUNT-NSF THRU 7705-EXIT.                       
A05058     PERFORM 7706-COUNT-NSF-FORGIVEN THRU 7706-EXIT.              
                                                                        
A05058     IF WS-NSF-COUNT-F > 0                                        
A05058        SUBTRACT 1 FROM WS-NSF-COUNT-F                            
A05058     END-IF.                                                      
A05058     COMPUTE WS-NSF-COUNT = WS-NSF-COUNT-F + WS-NSF-COUNT-C.      
                                                                        
T19970     MOVE 'N' TO WS-BANK-DRAFT-REMOVED.                           
      *                                                                         
A05058     IF (WS-NSF-COUNT >= 2)                                       
A05058        IF WS-CODE-BANK-EFT = 'A'                                 
T26396           AND BE-STATUS-CODE = 'A'                               
TP9685              MOVE 'D'               TO BE-STATUS-CODE            
                    MOVE CURRENT-DATE      TO BE-STATUS-CHANGE-DT       
                    PERFORM 8700-UPDATE-BANK-EFT        THRU 8700-EXIT  
                    MOVE 'Y'               TO WS-BANK-DRAFT-REMOVED     
A05058        END-IF                                                    
A05058        IF (CZ-CASH-ONLY-FL NOT EQUAL 'Y')                        
                 MOVE 'Y'                 TO CZ-CASH-ONLY-FL            
                 MOVE CURRENT-DATE        TO CZ-CSH-ONLY-EFFECT-DT      
C35824           MOVE '1'                 TO CZ-CASH-ONLY-COMMENTS-LEN  
C35824           MOVE SPACES              TO CZ-CASH-ONLY-COMMENTS-TEXT 
                 PERFORM 8350-UPDATE-CASH-ONLY THRU 8350-EXIT           
A05058        END-IF                                                    
           END-IF.                                                      
      *                                                                         
       5325-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 5330-PROCESS-XMPT-NON-UTIL                                              
      *                                                                         
      *****************************************************************         
      *                                                                         
       5330-PROCESS-XMPT-NON-UTIL.                                      
      *                                                                         
           IF WS-CODE-BANK-EFT = 'A'                                    
T26396        AND (BE-STATUS-CODE = 'A' OR 'D')                         
              EVALUATE TRUE                                             
                 WHEN WS-NSF-COUNT >= 3                                 
                    MOVE 90209        TO CL-CODE-MESSAGE-TYPE           
T13945*                                                                         
                 WHEN WS-NSF-COUNT = (0 OR 1 OR 2)                      
                    MOVE 90208        TO CL-CODE-MESSAGE-TYPE           
              END-EVALUATE                                              
           ELSE                                                         
              MOVE 90205              TO CL-CODE-MESSAGE-TYPE           
           END-IF.                                                      
      *                                                                         
TP5033     MOVE WS-DATE-PLUS-1        TO CL-DATE-NOTICE-MAIL.           
TP5033     MOVE LOW-VALUES            TO CL-DATE-NOTICE-DUE             
T20655                                   CL-DATE-CREDIT-ACTION.         
      *                                                                         
TP5033     IF WS-N-ROW-COUNT = 0                                        
T21963        PERFORM 5361-INSRT-N-SUM-ROW THRU 5361-EXIT               
TP5033     ELSE                                                         
TP5033        IF SUM-DATE-NOTICE-MAIL = WS-DATE-PLUS-1                  
T21963           PERFORM 5363-LOAD-CL-ROWS                              
TP5033        ELSE                                                      
TP5033           PERFORM 8451-DELETE-PREV-N-ROWS THRU 8451-EXIT         
T21963           PERFORM 5361-INSRT-N-SUM-ROW THRU 5361-EXIT            
TP5033        END-IF                                                    
TP5033     END-IF.                                                      
      *                                                                         
       5330-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 5361-INSRT-N-SUM-ROW.                                                   
      *                                                                         
      *****************************************************************         
       5361-INSRT-N-SUM-ROW.                                            
      *                                                                         
TP5033     MOVE ZERO                TO CL-ITEM-ID.                      
T24982     IF CL-DATE-CREDIT-ACTION > SPACE                             
T24982        CONTINUE                                                  
T24982     ELSE                                                         
T24982        MOVE SPACES           TO CL-DATE-CREDIT-ACTION            
T24982     END-IF.                                                      
T21963     MOVE SPACES              TO CL-CODE-FRCST-CR-GRP.            
T21963     MOVE AT-DATE-BILL-DAY-00 TO CL-DATE-BILL.                    
T21963     MOVE WS-TOTAL-RET-AMT    TO CL-AMT-NOTICE.                   
TP5033     MOVE 'N'                 TO CL-CODE-NOTICE-TYPE.             
P00599     MOVE 'H'                 TO CL-CODE-SPECIAL-TYPE.            
T21963     PERFORM 8600-INSERT-CSS-CRED-COLL   THRU 8600-EXIT.          
P00599     MOVE SPACES              TO CL-CODE-SPECIAL-TYPE.            
T21963     MOVE WS-NON-UTIL-AMT     TO CL-AMT-NOTICE.                   
T21963     ADD  NH-NSF-CHARGE-AMT   TO CL-AMT-NOTICE.                   
T21963     MOVE 'V'                 TO CL-CODE-NOTICE-TYPE.             
T21963     PERFORM 8600-INSERT-CSS-CRED-COLL   THRU 8600-EXIT.          
T21963     MOVE WS-UTIL-AMT         TO CL-AMT-NOTICE.                   
T21963     MOVE 'W'                 TO CL-CODE-NOTICE-TYPE.             
TP5033     PERFORM 8600-INSERT-CSS-CRED-COLL   THRU 8600-EXIT.          
      *                                                                         
       5361-EXIT.                                                       
           EXIT.                                                        
T21963*****************************************************************         
T21963* 5363-LOAD-CL-ROWS.                                                      
T21963*****************************************************************         
T21963 5363-LOAD-CL-ROWS.                                               
T21963*                                                                         
T21963     MOVE AT-DATE-BILL-DAY-00 TO CL-DATE-BILL.                    
T21963     MOVE SPACES           TO CL-CODE-FRCST-CR-GRP.               
P00599     MOVE 'H'              TO CL-CODE-SPECIAL-TYPE.               
T21963     MOVE WS-TOTAL-RET-AMT TO CL-AMT-NOTICE.                      
T21963     MOVE 'N'              TO CL-CODE-NOTICE-TYPE.                
T21963     MOVE WS-N-ROW-COUNT   TO CL-ITEM-ID.                         
T21963     PERFORM 8600-INSERT-CSS-CRED-COLL THRU 8600-EXIT.            
P00599     MOVE SPACES           TO CL-CODE-SPECIAL-TYPE.               
T21963     COMPUTE CL-AMT-NOTICE = NSUM-CL-AMT-NOTICE +                 
T21963                             WS-TOTAL-RET-AMT.                    
T21963     PERFORM 8660-UPDATE-SUM-ROW        THRU 8660-EXIT.           
T21963     MOVE WS-NON-UTIL-AMT  TO CL-AMT-NOTICE.                      
T21963     ADD NH-NSF-CHARGE-AMT TO CL-AMT-NOTICE.                      
T21963     MOVE 'V'              TO CL-CODE-NOTICE-TYPE.                
T21963     PERFORM 8600-INSERT-CSS-CRED-COLL THRU 8600-EXIT.            
T21963     COMPUTE CL-AMT-NOTICE = VSUM-CL-AMT-NOTICE +                 
T21963                             NH-NSF-CHARGE-AMT +                  
T21963                             WS-NON-UTIL-AMT.                     
T21963     PERFORM 8660-UPDATE-SUM-ROW       THRU 8660-EXIT.            
T21963     MOVE WS-UTIL-AMT      TO CL-AMT-NOTICE.                      
T21963     MOVE 'W'              TO CL-CODE-NOTICE-TYPE.                
T21963     PERFORM 8600-INSERT-CSS-CRED-COLL THRU 8600-EXIT.            
T21963     COMPUTE CL-AMT-NOTICE = WSUM-CL-AMT-NOTICE +                 
T21963                             WS-UTIL-AMT.                         
T21963     PERFORM 8660-UPDATE-SUM-ROW       THRU 8660-EXIT.            
T21963*                                                                         
T21963 5363-EXIT.                                                       
T21963     EXIT.                                                        
PCR263*****************************************************************         
PCR263* 5400-GET-NEXT-BUSINESS-DAY                                              
PCR263*   CHECKS FOR WEEKENDS AND HOLIDAY DATES.                                
PCR263*****************************************************************         
PCR263 5400-GET-NEXT-BUSINESS-DAY.                                      
PCR263*                                                                         
PCR263     MOVE '1800'          TO ACTIVE-PARAGRAPH.                    
PCR263     MOVE 'N'             TO WS-DATE-FOUND.                       
PCR263     PERFORM 7997-GET-NEXT-DAY        THRU 7997-EXIT.             
PCR263     IF WS-DAY EQUAL 6 OR WS-DAY EQUAL ZEROES                     
PCR263        PERFORM 5450-GET-NEXT-DATE    THRU 5450-EXIT              
PCR263           UNTIL WS-DATE-FOUND EQUAL 'Y'                          
PCR263     ELSE                                                         
PCR263        MOVE WS-DATE-HOLD TO J8-HOLIDAY-DT                        
PCR263        PERFORM 7995-SELECT-HOLIDAY   THRU 7995-EXIT              
PCR263        IF HOLIDAY-EXISTS                                         
PCR263           PERFORM 5450-GET-NEXT-DATE THRU 5450-EXIT              
PCR263              UNTIL WS-DATE-FOUND EQUAL 'Y'                       
PCR263        ELSE                                                      
PCR263           MOVE 'Y'       TO WS-DATE-FOUND                        
PCR263        END-IF                                                    
PCR263     END-IF.                                                      
PCR263*                                                                         
PCR263 5400-EXIT.                                                       
PCR263     EXIT.                                                        
PCR263                                                                  
PCR263*****************************************************************         
PCR263* 5450-GET-NEXT-DATE.                                                     
PCR263*   CHECKS DAY NUMBER AND HOLIDAY DATE INFORMATION                        
PCR263*****************************************************************         
PCR263 5450-GET-NEXT-DATE.                                              
PCR263*                                                                         
PCR263     MOVE '1810'          TO ACTIVE-PARAGRAPH.                    
PCR263     PERFORM 7997-GET-NEXT-DAY      THRU 7997-EXIT.               
PCR263     IF WS-DAY EQUAL 6 OR WS-DAY EQUAL ZEROES                     
PCR263        NEXT SENTENCE                                             
PCR263     ELSE                                                         
PCR263        MOVE WS-DATE-HOLD TO J8-HOLIDAY-DT                        
PCR263        PERFORM 7995-SELECT-HOLIDAY THRU 7995-EXIT                
PCR263        IF HOLIDAY-EXISTS                                         
PCR263           NEXT SENTENCE                                          
PCR263        ELSE                                                      
PCR263           MOVE 'Y'       TO WS-DATE-FOUND                        
PCR263        END-IF                                                    
PCR263     END-IF.                                                      
PCR263*                                                                         
PCR263 5450-EXIT.                                                       
PCR263     EXIT.                                                        
PCR263                                                                  
T32545***************************************************************** 07991000
T32545*                                                               * 08002000
T32545* 5500-GET-PREV-BUSINESS-DAY                                    * 08001000
T32545***************************************************************** 08003000
T32545 5500-GET-PREV-BUSINESS-DAY.                                      
T32545*                                                                 08006000
T32545     MOVE WS-N                         TO WS-DATE-FOUND.          
T32545     PERFORM 7998-GET-PREV-DAY           THRU 7998-EXIT.          
T32545     IF WS-DAY EQUAL 6                                            
T32545        OR WS-DAY EQUAL ZEROES                                    
T32545        PERFORM 5550-GET-PREV-DATE             THRU 5550-EXIT     
T32545           UNTIL WS-DATE-FOUND EQUAL WS-Y                         
T32545     ELSE                                                         
T32545        MOVE WS-DATE-HOLD              TO J8-HOLIDAY-DT           
T32545        PERFORM 7995-SELECT-HOLIDAY      THRU 7995-EXIT           
T32545        IF HOLIDAY-EXISTS                                         
T32545           PERFORM 5550-GET-PREV-DATE          THRU 5550-EXIT     
T32545              UNTIL WS-DATE-FOUND EQUAL WS-Y                      
T32545        ELSE                                                      
T32545           MOVE WS-Y          TO WS-DATE-FOUND                    
T32545        END-IF                                                    
T32545     END-IF.                                                      
T32545*                                                                 08010400
T32545 5500-EXIT.                                                       
T32545     EXIT.                                                        
T32545*                                                                 08010700
T32545***************************************************************** 08010800
T32545*                                                               * 08011100
T32545* 5550-GET-PREV-DATE                                            * 08011000
T32545***************************************************************** 08011200
T32545 5550-GET-PREV-DATE.                                              
T32545*                                                                 08011500
T32545     PERFORM 7998-GET-PREV-DAY                 THRU 7998-EXIT.    
T32545     IF WS-DAY EQUAL 6                                            
T32545        OR WS-DAY EQUAL ZEROES                                    
T32545        NEXT SENTENCE                                             
T32545     ELSE                                                         
T32545        MOVE WS-DATE-HOLD              TO J8-HOLIDAY-DT           
T32545        PERFORM 7995-SELECT-HOLIDAY      THRU 7995-EXIT           
T32545        IF HOLIDAY-EXISTS                                         
T32545           NEXT SENTENCE                                          
T32545        ELSE                                                      
T32545           MOVE WS-Y                   TO WS-DATE-FOUND           
T32545        END-IF                                                    
T32545     END-IF.                                                      
T32545*                                                                 08012900
T32545 5550-EXIT.                                                       
T32545     EXIT.                                                        
      ***************************************************************           
      * THIS MODULE GETS CURRENT TIMESTAMP AND DATE FOR CREATING    *           
      * JOURNAL ENTRIES                                             *           
      ***************************************************************           
       5600-GET-TIMESTAMP.                                              
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :NH-TRANS-HIST-SEQ-NO            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :NH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF SQLCODE NOT EQUAL SUCCESSFUL-CALL                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '5600'              TO ACTIVE-PARAGRAPH              
              MOVE 'SET'               TO ABEND-FUNCTION                
CBSI          MOVE 'USER_ID'           TO TABLE-ELEMENT-1               
CBSI          MOVE PARM-USER-ID        TO HOSTVAR-ELEMENT-1             
PCR361        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       5600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 5700-CASH-DRAWER-101.                                       *           
      *    -- THIS MODULE WRITES A FORMAT 101 CASH DRAWER JOURNAL   *           
      ***************************************************************           
       5700-CASH-DRAWER-101.                                            
                                                                        
C25923     MOVE WS-CD-COMPANY-NO         TO YR-CASH-COMPANY-NO,         
C25923                                      Y2-CASH-COMPANY-NO.         
C25923     MOVE WS-CD-LOCAL-OFFICE       TO YR-CASH-LOCAL-OFFICE,       
C25923                                      Y2-CASH-LOCAL-OFFICE.       
C25923     PERFORM 7320-SELECT-CASHIER   THRU 7320-EXIT                 
C25923     MOVE Y2-USER-ID               TO YR-USER-ID.                 
C25923     MOVE WS-CD-REPORT-DATE        TO YR-DATE-CASH-REPORT.        
C25923     MOVE WS-C                     TO YR-STATUS.                  
C25923     MOVE CURRENT-TIMESTAMP        TO YR-CLOSED-TS.               
C25923                                                                  
C25923     PERFORM 7325-SELECT-CASH-REPORT                              
C25923        THRU 7325-EXIT                                            
C25923     IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
C25923        PERFORM 8325-CREATE-CASH-REPORT                           
C25923           THRU 8325-EXIT                                         
C25923     END-IF.                                                      
                                                                        
           PERFORM 5800-SET-100-JRNL-VARS THRU 5800-EXIT.               
TP9474     INITIALIZE                  CJF00101.                        
           MOVE 101                    TO WS-101-JRNL-FORMAT-NO.        
FCSGL      MOVE SPACES                 TO WS-101-CASH-DRAWER-USED.      
                                                                        
           MOVE WS-TOTAL-RET-AMT       TO WS-101-AMOUNT-ENTERED.        
           MOVE WS-AR-AGE              TO WS-101-AR-AGE.                
           MOVE CURRENT-DATE           TO WS-101-DATE-AR-BILLED.        
TP8018     MOVE WS-CHECK-AMOUNT        TO WS-101-AMT-POSTED             
                                          WS-JRNL-RCV-DEBIT-AMT         
T13031                                    WS-JRNL-GEN-LEG-CREDIT-AMT.   
           MOVE AT-TOTAL-AR-BALANCE    TO WS-101-ACCT-END-AR-BAL.       
TP8018     MOVE AU-GL-ACCT-CREDIT      TO WS-101-ACCT-GEN-LED-CR.       
TP8018     MOVE AU-GL-ACCT-DEBIT       TO WS-101-ACCT-GEN-LED-DR.       
           MOVE 0                      TO WS-101-DETAIL-END-BAL.        
T10595     MOVE 0                      TO WS-101-DETAIL-END-AR-BAL      
           MOVE SPACES                 TO WS-101-FUNCTION-CODE.         
           MOVE PR-REV-DISTRICT-CD     TO WS-101-CODE-REVENUE-DISTRICT. 
           MOVE CU-CODE-EMPL-ACCT      TO WS-101-CODE-EMPL-ACCT.        
           MOVE AT-CODE-COMPANY-ACCT   TO WS-101-CODE-COMPANY-ACCT.     
           MOVE AT-CODE-ACCT-STAT      TO WS-101-CODE-ACCOUNT-STATUS.   
           MOVE PR-CODE-PREMISE-STAT   TO WS-101-CODE-PREMISE-STATUS.   
                                                                        
PCR613     MOVE D1-FCS-DEP-BANK-CD     TO WS-101-FCS-DEP-BANK-CD.       
PCR613     MOVE D1-FCS-DEP-BANK-ST-CD  TO WS-101-FCS-DEP-BANK-ST-CD.    
                                                                        
           MOVE CJF00101               TO WS-100-USER-DEFINED-AREA.     
                                                                        
           MOVE WS-JRNL-ONLY           TO WS-JRNL-OPERATION-RQST.       
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT.             
                                                                        
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
              NEXT SENTENCE                                             
           ELSE                                                         
PCR361        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
           MOVE WS-JRNL-CNTRL-ONLY     TO WS-JRNL-OPERATION-RQST.       
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT.             
                                                                        
           IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
              NEXT SENTENCE                                             
           ELSE                                                         
PCR361        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       5700-EXIT.                                                       
           EXIT.                                                        
                                                                        
T25923***************************************************************           
T25923*                                                                         
T25923*  5750-OVERAGE-SHORTAGE-101.                                 *           
T25923*                                                             *           
T25923*    -- THIS MODULE WRITES A FORMAT 101 CASH DRAWER JOURNAL   *           
T25923***************************************************************           
T25923 5750-OVERAGE-SHORTAGE-101.                                       
T25923                                                                  
T25923     PERFORM 5800-SET-100-JRNL-VARS         THRU 5800-EXIT.       
                                                                        
T25923     INITIALIZE                  CJF00101.                        
                                                                        
T25923     MOVE 101                    TO WS-101-JRNL-FORMAT-NO.        
T25923     MOVE SPACES                 TO WS-101-CASH-DRAWER-USED.      
                                                                        
T25923     IF PARM-THIRD-PARTY = '000'                                  
T25923        MOVE WS-BATCH-DIFF-AMT   TO WS-101-AMOUNT-ENTERED         
T25923                                    WS-101-AMT-POSTED             
T25923     ELSE                                                         
T25923        MOVE WS-ENTERED-AMT      TO WS-101-AMOUNT-ENTERED         
T25923                                    WS-101-AMT-POSTED             
T25923     END-IF                                                       
                                                                        
T25923     MOVE AU-GL-ACCT-CREDIT      TO WS-101-ACCT-GEN-LED-CR.       
T25923     MOVE AU-GL-ACCT-DEBIT       TO WS-101-ACCT-GEN-LED-DR.       
                                                                        
T25923     MOVE SPACES                 TO WS-101-FUNCTION-CODE.         
                                                                        
T25923     MOVE PR-REV-DISTRICT-CD     TO WS-101-CODE-REVENUE-DISTRICT. 
                                                                        
T25923     MOVE NH-BANK-ID             TO WS-101-BANK-ID.               
                                                                        
T25923     MOVE CJF00101               TO WS-100-USER-DEFINED-AREA.     
                                                                        
T25923     MOVE WS-JRNL-ONLY           TO WS-JRNL-OPERATION-RQST.       
                                                                        
T25923     PERFORM 6400-ONLINE-JRNL-ROUTINE       THRU 6400-EXIT.       
                                                                        
T25923     IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
T25923        NEXT SENTENCE                                             
T25923     ELSE                                                         
T25923        PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
T25923     END-IF.                                                      
                                                                        
T25923     MOVE WS-JRNL-CNTRL-ONLY     TO WS-JRNL-OPERATION-RQST.       
T25923     PERFORM 6400-ONLINE-JRNL-ROUTINE       THRU 6400-EXIT.       
                                                                        
T25923     IF WS-JRNL-RTRN-CODE EQUAL SPACES                            
T25923        NEXT SENTENCE                                             
T25923     ELSE                                                         
T25923        PERFORM 9700-PROCESS-ABEND          THRU 9700-EXIT        
T25923     END-IF.                                                      
                                                                        
T25923 5750-EXIT.                                                       
T25923     EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5775-INS-OVERSHORT-TABLE                                      *         
      * INSERT RECORD INTO CSS_OVERSHORT_HDR FOR THE OVERAGE OR       *         
      * THAT WAS JUST JOURNALLED.                                     *         
      *****************************************************************         
                                                                        
T25923 5775-INS-OVERSHORT-TABLE.                                        
                                                                        
T25923     MOVE '5775' TO ACTIVE-PARAGRAPH.                             
                                                                        
T25923     MOVE '01'                    TO OH-CASH-COMPANY-NO           
T25923     MOVE '001'                   TO OH-CASH-LOCAL-OFFICE         
T25923     MOVE CURRENT-DATE            TO OH-DATE-CASH-REPORT          
T25923     MOVE 9901                    TO OH-CASH-DRAWER-ID            
T25923     MOVE PARM-USER-ID            TO OH-USER-ID                   
T25923     MOVE 1                       TO OH-TRAN-COMMENT-LEN          
T25923     MOVE ' '                     TO OH-TRAN-COMMENT-TEXT         
T25923     MOVE 0                       TO OH-OFST-OVERSHORT-AMT        
T25923     MOVE ' '                     TO OH-OFST-DR-CR                
                                                                        
T25923     MOVE 'C'                     TO OH-OVERSHORT-DR-CR           
                                                                        
T25923     IF WS-ERROR-ENTRY = 'Y'                                      
T25923        MOVE WS-ACCOUNT-NO-NUM    TO OH-ACCOUNT-NO                
T25923        MOVE PARM-RTN-CHK-AMT-RED (WS-MEM-NO)                     
                                        TO OH-OVERSHORT-AMT             
T25923        MOVE PARM-GL-ACCOUNT-RED (WS-MEM-NO)                      
                                        TO OH-GL-ACCT-NO                
T25923        IF PARM-ERROR-TYPE-IND EQUAL SPACES                       
T25923           MOVE 'D'               TO OH-OVERSHORT-DR-CR           
T25923           MOVE PARM-NCIS-COMMENTS-LEN (WS-MEM-NO)                
                                        TO OH-TRAN-COMMENT-LEN          
T25923           MOVE PARM-NCIS-COMMENTS-TEXT (WS-MEM-NO)               
                                        TO OH-TRAN-COMMENT-TEXT         
T25923           MOVE OH-GL-ACCT-NO     TO OT-GL-ACCT-NO                
T25923           PERFORM 5780-OPEN-OVSH-TYPE-CURSOR  THRU 5780-EXIT     
T25923           PERFORM 5781-FETCH-OVSH-TYPE        THRU 5781-EXIT     
T25923           PERFORM 5782-CLOSE-OVSH-TYPE-CURSOR THRU 5782-EXIT     
T25923        ELSE                                                      
                 MOVE WS-GEN-LED-NO-OV-SH TO OH-GL-ACCT-NO              
T25923           MOVE OH-GL-ACCT-NO       TO OT-GL-ACCT-NO              
T25923           PERFORM 5780-OPEN-OVSH-TYPE-CURSOR  THRU 5780-EXIT     
T25923           PERFORM 5781-FETCH-OVSH-TYPE        THRU 5781-EXIT     
T25923           PERFORM 5782-CLOSE-OVSH-TYPE-CURSOR THRU 5782-EXIT     
T25923        END-IF                                                    
T25923     ELSE                                                         
T25923        MOVE WS-GEN-LED-NO-OV-SH  TO OH-GL-ACCT-NO                
T25923        MOVE 9999999999999        TO OH-ACCOUNT-NO                
T29852        IF PARM-THIRD-PARTY = '000'                               
T29852           MOVE WS-BATCH-DIFF-AMT   TO OH-OVERSHORT-AMT           
T29852        ELSE                                                      
T29852           MOVE WS-ENTERED-AMT      TO OH-OVERSHORT-AMT           
T29852        END-IF                                                    
              MOVE OH-GL-ACCT-NO        TO OT-GL-ACCT-NO                
T25923        PERFORM 5780-OPEN-OVSH-TYPE-CURSOR    THRU 5780-EXIT      
T25923        PERFORM 5781-FETCH-OVSH-TYPE          THRU 5781-EXIT      
T25923        PERFORM 5782-CLOSE-OVSH-TYPE-CURSOR   THRU 5782-EXIT      
                                                                        
T25923                                                                  
T25923        MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                     
T25923        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
T25923           NEXT SENTENCE                                          
T25923        ELSE                                                      
T25923           MOVE '5775'               TO ACTIVE-PARAGRAPH          
T25923           MOVE SPACES               TO ABEND-TABLES              
T25923           MOVE SPACES               TO ABEND-SQL-PREDICATES      
T25923           MOVE 'CSR02189'           TO ABEND-PROGRAM             
T25923           MOVE 'SELECT'             TO ABEND-FUNCTION            
T25923           MOVE 'CSS_OVERSHORT_TYPE' TO TABLE-1                   
T25923           MOVE 'PARM-THIRD-PARTY'   TO TABLE-ELEMENT-1           
T25923           MOVE PARM-THIRD-PARTY     TO HOSTVAR-ELEMENT-1         
T25923           PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT         
T25923        END-IF                                                    
T25923     END-IF.                                                      
                                                                        
T25923     PERFORM 5600-GET-TIMESTAMP                THRU 5600-EXIT.    
                                                                        
T25923     MOVE NH-TRANS-HIST-SEQ-NO    TO OH-TRAN-TS                   
T25923     MOVE NH-TRANS-HIST-SEQ-NO    TO OH-LAST-UPDATE-TS            
                                                                        
T25923     MOVE 'P'                     TO OH-OVERSHORT-SOLTN-FL        
                                                                        
T25923     PERFORM 5776-GET-LAST-OVERSHORT-ID THRU 5776-EXIT.           
                                                                        
T25923     EXEC SQL                                                     
T25923         INSERT INTO CSS_OVERSHORT_HDR                            
T25923                   ( CASH_COMPANY_NO      ,                       
T25923                     CASH_LOCAL_OFFICE    ,                       
T25923                     DATE_CASH_REPORT     ,                       
T25923                     CASH_DRAWER_ID       ,                       
T25923                     OVERSHORT_ID         ,                       
T25923                     USER_ID              ,                       
T25923                     ACCOUNT_NO           ,                       
T25923                     OVERSHORT_AMT        ,                       
T25923                     OVERSHORT_DR_CR      ,                       
T25923                     OFST_OVERSHORT_AMT   ,                       
T25923                     OFST_DR_CR           ,                       
T25923                     GL_ACCT_NO           ,                       
T25923                     TRAN_TS              ,                       
T25923                     LAST_UPDATE_TS       ,                       
T25923                     OVERSHORT_TYPE_CD    ,                       
T25923                     OVERSHORT_SOLTN_FL   ,                       
T25923                     TRAN_COMMENT)                                
T25923            VALUES( :OH-CASH-COMPANY-NO   ,                       
T25923                    :OH-CASH-LOCAL-OFFICE ,                       
T25923                    IIF(TRY_CONVERT(DATE, :OH-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OH-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OH-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OH-DATE-CASH-REPORT
              ), CONVERT(DATE, :OH-DATE-CASH-REPORT) )  ,                      
T25923                    :OH-CASH-DRAWER-ID    ,                       
T25923                    :OH-OVERSHORT-ID      ,                       
T25923                    :OH-USER-ID           ,                       
T25923                    :OH-ACCOUNT-NO        ,                       
T25923                    :OH-OVERSHORT-AMT     ,                       
T25923                    :OH-OVERSHORT-DR-CR   ,                       
T25923                    :OH-OFST-OVERSHORT-AMT,                       
T25923                    :OH-OFST-DR-CR        ,                       
T25923                    :OH-GL-ACCT-NO        ,                       
T25923                    CIS.CHAR2TIMESTAMP(:OH-TRAN-TS)           ,           
T25923                    CIS.CHAR2TIMESTAMP(:OH-LAST-UPDATE-TS)    ,           
T25923                    :OH-OVERSHORT-TYPE-CD ,                       
T25923                    :OH-OVERSHORT-SOLTN-FL,                       
T25923                    :OH-TRAN-COMMENT)                             
T25923     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_OVERSHORT_HDR                                    
MFA-TR*                  ( CASH_COMPANY_NO      ,                               
MFA-TR*                    CASH_LOCAL_OFFICE    ,                               
MFA-TR*                    DATE_CASH_REPORT     ,                               
MFA-TR*                    CASH_DRAWER_ID       ,                               
MFA-TR*                    OVERSHORT_ID         ,                               
MFA-TR*                    USER_ID              ,                               
MFA-TR*                    ACCOUNT_NO           ,                               
MFA-TR*                    OVERSHORT_AMT        ,                               
MFA-TR*                    OVERSHORT_DR_CR      ,                               
MFA-TR*                    OFST_OVERSHORT_AMT   ,                               
MFA-TR*                    OFST_DR_CR           ,                               
MFA-TR*                    GL_ACCT_NO           ,                               
MFA-TR*                    TRAN_TS              ,                               
MFA-TR*                    LAST_UPDATE_TS       ,                               
MFA-TR*                    OVERSHORT_TYPE_CD    ,                               
MFA-TR*                    OVERSHORT_SOLTN_FL   ,                               
MFA-TR*                    TRAN_COMMENT)                                        
MFA-TR*           VALUES( :OH-CASH-COMPANY-NO   ,                               
MFA-TR*                   :OH-CASH-LOCAL-OFFICE ,                               
MFA-TR*                   :OH-DATE-CASH-REPORT  ,                               
MFA-TR*                   :OH-CASH-DRAWER-ID    ,                               
MFA-TR*                   :OH-OVERSHORT-ID      ,                               
MFA-TR*                   :OH-USER-ID           ,                               
MFA-TR*                   :OH-ACCOUNT-NO        ,                               
MFA-TR*                   :OH-OVERSHORT-AMT     ,                               
MFA-TR*                   :OH-OVERSHORT-DR-CR   ,                               
MFA-TR*                   :OH-OFST-OVERSHORT-AMT,                               
MFA-TR*                   :OH-OFST-DR-CR        ,                               
MFA-TR*                   :OH-GL-ACCT-NO        ,                               
MFA-TR*                   :OH-TRAN-TS           ,                               
MFA-TR*                   :OH-LAST-UPDATE-TS    ,                               
MFA-TR*                   :OH-OVERSHORT-TYPE-CD ,                               
MFA-TR*                   :OH-OVERSHORT-SOLTN-FL,                               
MFA-TR*                   :OH-TRAN-COMMENT)                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T25923                                                                  
T25923     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T25923     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T25923        NEXT SENTENCE                                             
T25923     ELSE                                                         
T25923        MOVE '5775'               TO ACTIVE-PARAGRAPH             
T25923        MOVE SPACES               TO ABEND-TABLES                 
T25923        MOVE SPACES               TO ABEND-SQL-PREDICATES         
T25923        MOVE 'CSR02189'           TO ABEND-PROGRAM                
T25923        MOVE 'INSERT'             TO ABEND-FUNCTION               
T25923        MOVE 'CSS_OVERSHORT_HDR'  TO TABLE-1                      
T25923        MOVE 'CASH_COMPANY_NO'    TO TABLE-ELEMENT-1              
T25923        MOVE 'CASH_LOCAL_OFFICE'  TO TABLE-ELEMENT-2              
T25923        MOVE 'DATE_CASH_REPORT'   TO TABLE-ELEMENT-3              
T25923        MOVE 'CASH_DRAWER_ID'     TO TABLE-ELEMENT-4              
T25923        MOVE OH-CASH-COMPANY-NO   TO HOSTVAR-ELEMENT-1            
T25923        MOVE OH-CASH-LOCAL-OFFICE TO HOSTVAR-ELEMENT-2            
T25923        MOVE OH-DATE-CASH-REPORT  TO HOSTVAR-ELEMENT-3            
T25923        MOVE OH-CASH-DRAWER-ID    TO HOSTVAR-ELEMENT-4            
T25923        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
T25923     END-IF.                                                      
T25923 5775-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************          
      * OBTAIN LAST OVERSHORT-ID FOR CASH DRAWER IN TABLE            *          
      * CSS-OVERSHORT. IF NO ENTRIES, START OVERSHORT-ID AT 1        *          
      ****************************************************************          
                                                                        
T25923 5776-GET-LAST-OVERSHORT-ID.                                      
T25923                                                                  
T25923     MOVE '5776' TO ACTIVE-PARAGRAPH.                             
T25923                                                                  
T25923     EXEC SQL                                                     
T25923         SELECT MAX(OVERSHORT_ID)                                 
T25923           INTO :OH-OVERSHORT-ID :WS-NULL-INDICATOR-1             
T25923           FROM CSS_OVERSHORT_HDR WITH(READUNCOMMITTED)                   
T25923          WHERE CASH_COMPANY_NO   = :OH-CASH-COMPANY-NO           
T25923            AND CASH_LOCAL_OFFICE = :OH-CASH-LOCAL-OFFICE         
T25923            AND DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :OH-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OH-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OH-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OH-DATE-CASH-REPORT
              ), CONVERT(DATE, :OH-DATE-CASH-REPORT) )          
T25923            AND CASH_DRAWER_ID    = :OH-CASH-DRAWER-ID            
T35824                                                           
A01376                                                      
T25923     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(OVERSHORT_ID)                                         
MFA-TR*          INTO :OH-OVERSHORT-ID :WS-NULL-INDICATOR-1                     
MFA-TR*          FROM CSS_OVERSHORT_HDR                                         
MFA-TR*         WHERE CASH_COMPANY_NO   = :OH-CASH-COMPANY-NO                   
MFA-TR*           AND CASH_LOCAL_OFFICE = :OH-CASH-LOCAL-OFFICE                 
MFA-TR*           AND DATE_CASH_REPORT  = :OH-DATE-CASH-REPORT                  
MFA-TR*           AND CASH_DRAWER_ID    = :OH-CASH-DRAWER-ID                    
MFA-TR*           WITH UR                                                       
MFA-TR*           QUERYNO 5776                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T25923                                                                  
T25923     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T25923     IF WS-NULL-INDICATOR-1 < 0                                   
T25923        MOVE 1                TO OH-OVERSHORT-ID                  
T25923     ELSE                                                         
T25923        IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
T25923           ADD 1 TO OH-OVERSHORT-ID                               
T25923        ELSE                                                      
T25923           MOVE SPACES               TO ABEND-TABLES              
T25923           MOVE SPACES               TO ABEND-SQL-PREDICATES      
T25923           MOVE 'CSR02189'           TO ABEND-PROGRAM             
T25923           MOVE 'SELECT'             TO ABEND-FUNCTION            
T25923           MOVE 'CSS_OVERSHORT_HDR'  TO TABLE-1                   
T25923           MOVE 'CASH_COMPANY_NO'    TO TABLE-ELEMENT-1           
T25923           MOVE 'CASH_LOCAL_OFFICE'  TO TABLE-ELEMENT-2           
T25923           MOVE 'DATE_CASH_REPORT'   TO TABLE-ELEMENT-3           
T25923           MOVE 'CASH_DRAWER_ID'     TO TABLE-ELEMENT-4           
T25923           MOVE OH-CASH-COMPANY-NO   TO HOSTVAR-ELEMENT-1         
T25923           MOVE OH-CASH-LOCAL-OFFICE TO HOSTVAR-ELEMENT-2         
T25923           MOVE OH-DATE-CASH-REPORT  TO HOSTVAR-ELEMENT-3         
T25923           MOVE OH-CASH-DRAWER-ID    TO HOSTVAR-ELEMENT-4         
T25923           PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT         
T25923        END-IF                                                    
T25923     END-IF.                                                      
T25923 5776-EXIT.                                                       
           EXIT.                                                        
T25923***********************************************                           
T25923* OPENS CURSOR FOR OVSH-TYPE                  *                           
T25923***********************************************                           
T25923 5780-OPEN-OVSH-TYPE-CURSOR.                                      
T25923                                                                  
T25923     EXEC SQL                                                     
T25923         OPEN OVSH-TYPE                                           
T25923     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T25923                                                                  
T25923     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
T25923                                                                  
T25923     IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
T25923        NEXT SENTENCE                                             
T25923     ELSE                                                         
T25923        MOVE '5810'                     TO ACTIVE-PARAGRAPH       
T25923        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
T25923        MOVE 'OPEN'                     TO ABEND-FUNCTION         
T25923        MOVE 'CSS_OVERSHORT_TYPE'       TO TABLE-1                
T25923        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
T25923     END-IF.                                                      
T25923                                                                  
T25923 5780-EXIT.                                                       
T25923     EXIT.                                                        
T25923                                                                  
T25923************************************************************              
T25923*  FETCHING OVERSHORT_TYPE_CD FROM CSS_OVERSHORT_TYPE      *              
T25923************************************************************              
T25923 5781-FETCH-OVSH-TYPE.                                            
T25923     EXEC SQL                                                     
T25923         FETCH OVSH-TYPE                                          
T25923         INTO :OH-OVERSHORT-TYPE-CD                               
T25923     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T25923                                                                  
T25923     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
T25923                                                                  
T25923     IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
T25923        NEXT SENTENCE                                             
T25923     ELSE                                                         
T25923        MOVE '5781'                     TO ACTIVE-PARAGRAPH       
T25923        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
T25923        MOVE 'FETCH'                    TO ABEND-FUNCTION         
T25923        MOVE 'CSS_OVERSHORT_TYPE'       TO TABLE-1                
T25923        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
T25923     END-IF.                                                      
T25923 5781-EXIT.                                                       
T25923     EXIT.                                                        
T25923                                                                  
T25923 5782-CLOSE-OVSH-TYPE-CURSOR.                                     
T25923                                                                  
T25923     EXEC SQL                                                     
T25923         CLOSE OVSH-TYPE                                          
T25923     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T25923                                                                  
T25923     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
T25923                                                                  
T25923     IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
T25923        NEXT SENTENCE                                             
T25923     ELSE                                                         
T25923        MOVE '5782'                     TO ACTIVE-PARAGRAPH       
T25923        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
T25923        MOVE 'CLOSE'                    TO ABEND-FUNCTION         
T25923        MOVE 'CSS_OVERSHORT_TYPE'       TO TABLE-1                
T25923        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
T25923     END-IF.                                                      
T25923 5782-EXIT.                                                       
T25923     EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5800-SET-100-JRNL-VARS                                        *         
      * INITIALIZE FIELDS THAT ARE REQUIRED FOR THE MISCELLANEOUS     *         
      * JOURNAL HEADER.                                               *         
      *****************************************************************         
       5800-SET-100-JRNL-VARS.                                          
                                                                        
           MOVE '5800'                 TO ACTIVE-PARAGRAPH.             
                                                                        
           MOVE AT-COMPANY-NO          TO WS-100-COMPANY-NO.            
      *                                                                         
      ***********************************************************               
      * THESE FIELDS WERE POPULATED BY CALLING CPD00020         *               
      * (PARAGRAPH 5970) TO ACCESS APPLICATION TABLE 50         *               
      ***********************************************************               
      *                                                                         
           MOVE 9                      TO WS-TRAN-OPER-LEVEL.           
           MOVE 1                      TO WS-TRAN-OCAP-FIELD.           
           MOVE 1                      TO WS-TRAN-OCAP-VALUE.           
           MOVE 'C'                    TO WS-TRAN-JRNL-TYPE.            
           MOVE 'N'                    TO WS-TRAN-HOLD-EXEMPT-FLAG.     
                                                                        
      ***********************************************************               
      * THESE FIELDS WERE POPULATED BY CALLING CPD00021         *               
      * (PARAGRAPH 5980) TO VERIFY USER-ID                      *               
      ***********************************************************               
      *                                                                         
           MOVE PARM-USER-ID           TO WS-JRNL-OL-TEMP-ID.           
           MOVE WS-JRNL-CK-OPER-ID     TO WS-JRNL-OPERATION-RQST.       
           PERFORM 6400-ONLINE-JRNL-ROUTINE             THRU 6400-EXIT. 
           MOVE WS-JRNL-OL-OPR-LOC     TO WS-TERM-LOC.                  
                                                                        
FCSGL      MOVE WS-CD-COMPANY-NO     TO WS-JRNL-OL-COMPANY.             
FCSGL      MOVE WS-CD-LOCAL-OFFICE   TO WS-JRNL-OL-LOC-OFF.             
FCSGL      MOVE WS-CD-REPORT-NO      TO WS-JRNL-OL-REPORT-NO.           
FCSGL      MOVE WS-CD-REPORT-DATE    TO WS-JRNL-OL-REPORT-DT.           
FCSGL      MOVE WS-CASH-DRAWER-ID    TO WS-JRNL-OL-CASH-DRWR.           
FCSGL      MOVE SPACES               TO WS-JRNL-CURRENCY-TYPE           
C25923     IF WS-MEM-NO < 76                                            
C25923        MOVE PARM-CURRENCY-TYPE(WS-MEM-NO)                        
C25923                               TO WS-JRNL-CURRENCY-TYPE           
C25923     ELSE                                                         
C25923        MOVE SPACES            TO WS-JRNL-CURRENCY-TYPE           
C25923     END-IF.                                                      
FCSGL      MOVE SPACES               TO WS-JRNL-CODE-PYMT-FACILITY.     
           MOVE WS-TERM-LOC          TO WS-JRNL-OL-TERM-LOC             
                                        WS-JRNL-OL-CASH-LOC             
                                        WS-JRNL-OL-OPR-LOC.             
                                                                        
           MOVE WS-JRNL-VALIDATE-OPER  TO WS-JRNL-OPERATION-RQST.       
           MOVE 'C'                    TO WS-JRNL-SOURCE-CODE.          
           IF CASH-TRANSACTION                                          
              MOVE WS-JRNL-CASH-UPDATE TO WS-JRNL-OL-AUTH-TYPE          
           ELSE                                                         
              MOVE WS-JRNL-NON-CASH-UPDATE TO WS-JRNL-OL-AUTH-TYPE      
           END-IF.                                                      
                                                                        
           PERFORM 6400-ONLINE-JRNL-ROUTINE          THRU 6400-EXIT.    
                                                                        
           MOVE 'A'                    TO WS-100-JRNL-SORT-ID.          
           MOVE AT-COMPANY-NO          TO WS-100-COMPANY-NO.            
           MOVE AT-ACCOUNT-NO          TO WS-100-ACCT-NO.               
           MOVE AT-CUSTOMER-NO         TO WS-100-CUSTOMER-NO.           
           MOVE 0                      TO WS-100-PREMISE-NO.            
T25923     IF OVERAGE-TRAN-ID                                           
T25923        MOVE 'O412'              TO WS-100-CODE-TERMINAL-TRAN     
T25923        MOVE 'C'                 TO WS-JRNL-CURRENCY-TYPE         
T25923     ELSE                                                         
T25923        IF SHORTAGE-TRAN-ID                                       
T25923           MOVE 'S412'           TO WS-100-CODE-TERMINAL-TRAN     
T25923           MOVE 'C'              TO WS-JRNL-CURRENCY-TYPE         
T25923        ELSE                                                      
                 MOVE '189B'           TO WS-100-CODE-TERMINAL-TRAN     
T25923        END-IF                                                    
T25923     END-IF                                                       
           ADD 1                       TO WS-100-JRNL-TRAN-APPL-NO.     
           MOVE AT-DATE-LAST-ACTION    TO WS-100-DATE-LAST-ACTION.      
           MOVE 'C'                    TO WS-100-CODE-ENTRY-SOURCE.     
FCSGL      MOVE WS-CD-COMPANY-NO       TO WS-JRNL-OL-COMPANY.           
FCSGL      MOVE WS-CD-LOCAL-OFFICE     TO WS-JRNL-OL-LOC-OFF.           
FCSGL      MOVE WS-CD-REPORT-NO        TO WS-JRNL-OL-REPORT-NO.         
FCSGL      MOVE WS-CD-REPORT-DATE      TO WS-JRNL-OL-REPORT-DT.         
FCSGL      MOVE WS-CASH-DRAWER-ID      TO WS-JRNL-OL-CASH-DRWR.         
T25923     IF WS-MEM-NO < 76                                            
T22767        IF PARM-AR-AGE (WS-MEM-NO) EQUAL 'N'                      
T22767           IF NH-ACCOUNT-NO = 1210051437424                       
T22767              MOVE WS-002           TO AT-LOCAL-OFFICE            
T22767           ELSE                                                   
T22767              MOVE WS-001           TO AT-LOCAL-OFFICE            
T22767           END-IF                                                 
              END-IF                                                    
T25923     ELSE                                                         
T25923        EXEC SQL                                                  
T25923                SELECT LOCAL_OFFICE                               
T25923                  INTO :AT-LOCAL-OFFICE                           
T25923                  FROM CSS_CASHIER_OFFICE WITH(READUNCOMMITTED)           
T25923                 WHERE CASH_LOCAL_OFFICE = '001'                  
C35824                                                           
A01376                                                      
T25923        END-EXEC

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*       EXEC SQL                                                          
MFA-TR*               SELECT LOCAL_OFFICE                                       
MFA-TR*                 INTO :AT-LOCAL-OFFICE                                   
MFA-TR*                 FROM CSS_CASHIER_OFFICE                                 
MFA-TR*                WHERE CASH_LOCAL_OFFICE = '001'                          
MFA-TR*                WITH UR                                                  
MFA-TR*                QUERYNO 5800                                             
MFA-TR*       END-EXEC                                                          
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                  
T25923     END-IF.                                                      
           MOVE AT-LOCAL-OFFICE        TO WS-100-LOCAL-OFFICE-CD.       
           MOVE SPACES                 TO WS-100-TRANS-ERRORS.          
                                                                        
       5800-EXIT.                                                       
           EXIT.                                                        
                                                                        
C26296*                                                                         
C26296 5810-PROCESS-AUTO-DEPOSIT.                                       
C26296*                                                                         
C26296     INITIALIZE WS-CSR03515-INPUT-PARM.                           
C26296     MOVE PARM-ACCOUNT-NO (WS-MEM-NO)                             
C26296                                TO WS-CSR03515-ACCOUNT-NO         
C26296     MOVE 'PANEL181D'           TO WS-CSR03515-CALLING-PGM        
C26296     MOVE 'C'                   TO WS-CSR03515-AUTO-DEP-TYPE      
C26296     MOVE ZEROES                TO WS-CSR03515-DL-AUTO-DEP-AMT    
C26296     MOVE PARM-USER-ID          TO WS-CSR03515-USER-ID            
C26296     MOVE 'N'                   TO WS-CSR03515-ERROR-SW           
ACT239     MOVE SPACES                TO WS-CSR03515-BATCH-DATE         
C26296     PERFORM 5820-CALL-CSR03515 THRU 5820-EXIT.                   
C26296* WRITE WQ IF THE MAX DEPOSIT IS CALCULATED AS ZEROS                      
C26296* FOR RECEIVABLES MANAGEMENT                                              
C26296     IF  WS-CSR03515-MAX-DEP-ZERO-WQ = 'Y'                        
C26296         PERFORM 5830-CREATE-WQ THRU 5830-EXIT                    
C26296     END-IF.                                                      
C26296                                                                  
C26296 5810-EXIT.                                                       
C26296     EXIT.                                                        
C26296*                                                                         
C26296***************************************************************           
C26296* THIS PARAGRAPH CALLS CSR03515 TO GET THE AUTO DEPOSIT AMT   *           
C26296***************************************************************           
C26296 5820-CALL-CSR03515.                                              
C26296                                                                  
C26296     INITIALIZE WS-CSR03515-OUTPUT-FIELDS                         
C26296                WS-AUTO-DEP-CERT-NO.                              
C26296*    EXEC SQL CALL CSR03515                                       
C26296*        (:WS-CSR03515-ACCOUNT-NO                                 
C26296*        ,:WS-CSR03515-CALLING-PGM                                
C26296*        ,:WS-CSR03515-AUTO-DEP-TYPE                              
C26296*        ,:WS-CSR03515-DL-AUTO-DEP-AMT                            
C26296*        ,:WS-CSR03515-USER-ID                                    
C26296*        ,:WS-CSR03515-ERROR-SW                                   
ACT239*        ,:WS-CSR03515-BATCH-DATE)                                
C26296*    END-EXEC                                                     

MSQ001        EXEC SQL
MSQ001          CLOSE AUTO_DEP
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN AUTO_DEP
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR AUTO_DEP INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
C26296      MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE      
C26296      IF  WS-ACTIVE-RETURN-CODE = +466                            
C26296*         EXEC SQL ASSOCIATE LOCATORS(:LOC1) WITH PROCEDURE       
C26296*            CSR03515                                             
C26296*         END-EXEC                                                
C26296*         EXEC SQL                                                
C26296*           ALLOCATE AUTO_DEP CURSOR FOR RESULT SET :LOC1         
C26296*         END-EXEC                                                
C26296                                                                  
C26296          EXEC SQL                                                
C26296            FETCH AUTO_DEP                                        
C26296             INTO         :WS-CSR03515-RETURN-CODE                
C26296                         ,:WS-CSR03515-AUTO-DEP-AMT               
C26296                         ,:WS-CSR03515-DEP-SUCCESS                
C26296                         ,:WS-CSR03515-DEP-CERT-NO                
C26296                         ,:WS-CSR03515-MAX-DEP-ZERO-WQ            
C26296                         ,:WS-CSR03515-AMT-SECURED                
C26296                         ,:WS-CSR03515-ABEND-PROGRAM              
C26296                         ,:WS-CSR03515-ACTIVE-PARAGRAPH           
C26296                         ,:WS-CSR03515-ABEND-FUNCTION             
C26296                         ,:WS-CSR03515-TABLE-1                    
C26296                         ,:WS-CSR03515-TABLE-ELEMENT-1            
C26296                         ,:WS-CSR03515-HOSTVAR-ELEMENT-1          
C26296                         ,:WS-CSR03515-TABLE-ELEMENT-2            
C26296                         ,:WS-CSR03515-HOSTVAR-ELEMENT-2          
C26296                         ,:WS-CSR03515-TABLE-ELEMENT-3            
C26296                         ,:WS-CSR03515-HOSTVAR-ELEMENT-3          
C26296                         ,:WS-CSR03515-TABLE-ELEMENT-4            
C26296                         ,:WS-CSR03515-HOSTVAR-ELEMENT-4          
C26296          END-EXEC                                                

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26296          MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE  
C26296          IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
C26296              EVALUATE WS-CSR03515-RETURN-CODE                    
C26296                  WHEN 0                                          
C26296                      MOVE 'Y' TO WS-AUTODEP-CALL-SUCCESS         
C26296                      MOVE WS-CSR03515-DEP-CERT-NO                
C26296                        TO WS-AUTO-DEP-CERT-NO                    
C26296                  WHEN OTHER                                      
C26296                      MOVE 'N' TO WS-AUTODEP-CALL-SUCCESS         
C26296                      MOVE WS-CSR03515-RETURN-CODE                
C26296                      TO WS-ACTIVE-RETURN-CODE                    
C26296                      MOVE PROGRAM-NAME                           
C26296                      TO ABEND-PROGRAM                            
C26296                      MOVE WS-CSR03515-ACTIVE-PARAGRAPH           
C26296                      TO ACTIVE-PARAGRAPH                         
C26296                      MOVE WS-CSR03515-ABEND-PROGRAM              
C26296                      TO ABEND-FUNCTION                           
C26296                      MOVE WS-CSR03515-TABLE-1                    
C26296                      TO TABLE-1                                  
C26296                      MOVE WS-CSR03515-TABLE-ELEMENT-1            
C26296                      TO TABLE-ELEMENT-1                          
C26296                      MOVE WS-CSR03515-HOSTVAR-ELEMENT-1          
C26296                      TO HOSTVAR-ELEMENT-1                        
C26296                      MOVE WS-CSR03515-TABLE-ELEMENT-2            
C26296                      TO TABLE-ELEMENT-2                          
C26296                      MOVE WS-CSR03515-HOSTVAR-ELEMENT-2          
C26296                      TO HOSTVAR-ELEMENT-2                        
C26296                      MOVE WS-CSR03515-TABLE-ELEMENT-3            
C26296                      TO TABLE-ELEMENT-3                          
C26296                      MOVE WS-CSR03515-HOSTVAR-ELEMENT-3          
C26296                      TO HOSTVAR-ELEMENT-3                        
C26296                      MOVE WS-CSR03515-TABLE-ELEMENT-4            
C26296                      TO TABLE-ELEMENT-4                          
C26296                      MOVE WS-CSR03515-HOSTVAR-ELEMENT-4          
C26296                      TO HOSTVAR-ELEMENT-4                        
C26296                      PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT   
C26296              END-EVALUATE                                        
C26296          ELSE                                                    
C26296              MOVE 'N' TO WS-AUTODEP-CALL-SUCCESS                 
C26296              MOVE '5820'               TO ACTIVE-PARAGRAPH       
C26296              MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
C26296              MOVE 'FETCH'              TO ABEND-FUNCTION         
C26296              MOVE 'CSR03515'           TO TABLE-1                
C26296              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1        
C26296              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1      
C26296              MOVE 'SQLCODE '           TO TABLE-ELEMENT-1        
C26296              MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-1     
C26296              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
C26296          END-IF                                                  
C26296          EXEC SQL                                                
C26296            CLOSE AUTO_DEP                                        
C26296          END-EXEC                                                

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26296          MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE  
C26296          IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
C26296              CONTINUE                                            
C26296          ELSE                                                    
C26296              MOVE 'N' TO WS-AUTODEP-CALL-SUCCESS                 
C26296              MOVE '5820'               TO ACTIVE-PARAGRAPH       
C26296              MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
C26296              MOVE 'CLOSE'              TO ABEND-FUNCTION         
C26296              MOVE 'CSR03515'           TO TABLE-1                
C26296              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1        
C26296              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1      
C26296              MOVE 'SQLCODE '           TO TABLE-ELEMENT-1        
C26296              MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-1     
C26296              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
C26296          END-IF                                                  
C26296      ELSE                                                        
C26296          MOVE -1                       TO WS-ACTIVE-RETURN-CODE  
C26296          MOVE '5820'                   TO ACTIVE-PARAGRAPH       
C26296          MOVE PROGRAM-NAME             TO ABEND-PROGRAM          
C26296          MOVE 'DB2SP CALL'             TO ABEND-FUNCTION         
C26296          MOVE 'CSR03515'               TO TABLE-1                
C26296          MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1        
C26296          MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1      
C26296          MOVE 'SQLCODE'                TO TABLE-ELEMENT-1        
C26296          MOVE SQLCODE                  TO HOSTVAR-ELEMENT-1      
C26296          PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT            
C26296      END-IF.                                                     
C26296*                                                                         
C26296 5820-EXIT.                                                       
C26296     EXIT.                                                        
C26296*                                                                         
C26296*****************************************************************         
C26296*    5830-CREATE-WORKQ                                          *         
C26296*    THIS PARAGRAPH COLLECTS/FORMATS ALL DATA NEEDED FOR A WQ   *         
C26296*    MESSAGE AFTER FIRST VERIFYING THAT AN IDENTICAL WQ IN AN   *         
C26296*    "ASSIGNED" OR "IN PROGRESS" STATUS DOESN'T ALREADY EXIST.  *         
C26296*    IF AN IDENTICAL WQ DOES NOT ALREADY EXIST, PARAGRAPH 8000  *         
C26296*    IS CALLED TO WRITE THE NEW WQ OUT TO THE CSS_WQ_ITEMS TBL. *         
C26296*****************************************************************         
C26296 5830-CREATE-WQ.                                                  
C26296*                                                                         
C26296     MOVE '5830'                     TO WS-ACTIVE-PARAGRAPH       
ACT063     INITIALIZE CWS00077-FIELDS.                                  
ACT063     MOVE AT-ACCOUNT-NO              TO WS-77-ACCOUNT-NO          
ACT063     MOVE '4'                        TO WS-77-ROUTE-CATEGORY      
ACT063     IF AT-CODE-ACCT-STAT = 'S' OR 'B'                            
ACT063         MOVE 129                        TO WS-77-CATEGORY-ID     
P0059A         IF AT-CODE-ACCT-STAT= 'B'                                
ACT063            MOVE WS-RETURNED-CHECK-FINAL TO WS-WQ-COMMENTS-TEXT   
P0059A            MOVE +37                     TO WS-WQ-COMMENTS-LEN    
P0059A         END-IF                                                   
P0059A         IF AT-CODE-ACCT-STAT= 'S'                                
ACT063            MOVE WS-RETURNED-CHECK-WO    TO WS-WQ-COMMENTS-TEXT   
ACT063            MOVE +36                     TO WS-WQ-COMMENTS-LEN    
P0059A         END-IF                                                   
P0059A     END-IF                                                       
P0059A     IF  WS-CSR03515-MAX-DEP-ZERO-WQ = 'Y'                        
ACT063         MOVE 355                        TO WS-77-CATEGORY-ID     
ACT063         MOVE WS-CSR03515-AUTO-DEP-AMT   TO WS-WQ-AUTO-DEP-AMT    
P0059A         MOVE WS-CSR03515-AMT-SECURED    TO WS-WQ-AMT-SECURED     
P0059A         MOVE WS-WQ-COMMENTS-DETAIL      TO WS-WQ-COMMENTS-TEXT   
P0059A         MOVE LENGTH OF WS-WQ-COMMENTS-DETAIL                     
P0059A                                         TO WS-WQ-COMMENTS-LEN    
P0059A     END-IF                                                       
C26296         PERFORM 7500-SELECT-CURRENT-TS THRU 7500-EXIT            
ACT063         MOVE AT-LOCAL-OFFICE        TO WS-77-LOCAL-OFFICE        
C26296*****                                                                     
ACT063         MOVE ZERO                TO WS-77-CUSTOMER-NO            
ACT063         MOVE ZERO                TO WS-77-PREMISE-NO             
ACT063         MOVE AT-LOCAL-OFFICE     TO WS-77-LOCAL-OFFICE           
C26296*****                                                                     
ACT063         MOVE WS-WQ-COMMENTS-TEXT TO WS-77-COMMENTS-TEXT          
ACT063         MOVE WS-WQ-COMMENTS-LEN  TO WS-77-COMMENTS-LEN           
C26296*****                                                                     
C26296         MOVE WS-N                TO WS-77-PRIORITY               
ACT063         MOVE WS-CURRENT-TIMESTAMP    TO WS-77-DATE-CREATED       
ACT063                                         WS-77-DATE-REQUIRED      
C26296         MOVE 'CREATED BY DB2SP CSR02189'                         
ACT063                                      TO WS-77-FREE-FORM-TXT      
ACT063         MOVE +25                     TO WS-77-FREE-FORM-LEN      
ACT063         MOVE PROGRAM-NAME            TO WS-77-CREATED-BY.        
C26296*                                                                         
C26296         PERFORM 8895-INSERT-WORK-QUEUE THRU 8895-EXIT.           
A05058         MOVE RS-RETURN-CODE TO S-RETURN-CODE.                    
C26296 5830-EXIT.                                                       
C26296     EXIT.                                                        
      ******************************************************************00010000
      **  6400-ONLINE-JRNL-ROUTINE                                   ***00020000
      ******************************************************************00030000
           EXEC SQL                                                             
A00956         INCLUDE CPD0006A                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************00150000
      **  6500-ONLINE-LOAD-AR-TRAN-HIST.                             ***00170000
      ******************************************************************00180000
           EXEC SQL                                                             
               INCLUDE CPD00008                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************00100000
      **  6530-LOAD-MNT-TRANS-HIST.                                  ***00120000
      ******************************************************************00130000
           EXEC SQL                                                             
               INCLUDE CPD00067                                                 
           END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                                    
P00599******************************************************************00150000
P00599**  6600-PROCESS-CALC-NEW-SEQ-NO.                              ***00170000
P00599******************************************************************00180000
P00599     EXEC SQL                                                             
P00599         INCLUDE CPD00348                                                 
P00599     END-EXEC.                                                            
P00599                                                                  
C26954***************************************************************           
C26954* WS-SEB-REG-90205-FL FLAG WILL BE SET TO 'Y' AND NOTICE 90205*           
C26954* WILL BE FORECAST FOR THE FOLLOWING CONDTIONS:               *           
C26954*                                                             *           
C26954* 1) ACCOUNT IS A GROUP 1 SENIOR                              *           
C26954* 2) ACCOUNT HAS HAD GROUP MOVEMENT AND THE NEXT BILL HAS NOT *           
C26954*    GENERATED YET.                                           *           
C26954***************************************************************           
C26954 6000-SET-SEB-REG-90205-FL.                                       
C26954                                                                  
C26954     MOVE 'N' TO WS-SEB-REG-90205-FL.                             
C26954                                                                  
C26954     PERFORM 6100-CHECK-SEB-REG THRU 6100-EXIT.                   
C26954     IF WS-SEB-REGULATED-FL = 'Y'                                 
C26954     AND LR-REG-GROUP-CD = '100'                                  
C26954     AND LR-SENIOR-FL = 'Y'                                       
C26954        MOVE 'Y' TO WS-SEB-REG-90205-FL                           
C26954        MOVE 'Y' TO WS-GROUP-1-SENIOR                             
C26954     END-IF.                                                      
C26954                                                                  
C26954     IF WS-SEB-REGULATED-FL = 'Y' AND WS-SEB-REG-90205-FL = 'N'   
D03727        MOVE ZEROES                 TO WS-DATE-TRANS-NI           
D03727        MOVE LOW-VALUES             TO MH-DATE-TRANS              
C26954        PERFORM 6200-CHECK-GRP-MOVE THRU 6200-EXIT                
C26954        IF WS-SEB-GROUP-MOVE = 'Y'                                
C35824              IF AT-DATE-BILL-DAY-00 < MH-DATE-TRANS              
C26954                 MOVE 'Y' TO WS-SEB-REG-90205-FL                  
C35824              END-IF                                              
C26954        END-IF                                                    
C26954     END-IF.                                                      
C26954                                                                  
C26954 6000-EXIT.                                                       
C26954     EXIT.                                                        
C26954*                                                                         
C26954***************************************************************           
C26954* DETERMINE IF ACCOUNT IS SEB REGULATED PROVIDER              *           
C26954***************************************************************           
C26954 6100-CHECK-SEB-REG.                                              
C26954                                                                  
C26954     MOVE '6100'                 TO ACTIVE-PARAGRAPH.             
C26954                                                                  
C26954     EXEC SQL                                                     
C26954        SELECT REG_GROUP_CD                                       
C26954              ,REPLACE(REPLACE(CONVERT(CHAR(26), GROUP_EFF_TS
           , 121), ' ', '-'), ':', '.') GROUP_EFF_TS                           
C26954              ,SENIOR_FL                                          
C26954        INTO   :LR-REG-GROUP-CD                                   
C26954              ,:LR-GROUP-EFF-TS                                   
C26954              ,:LR-SENIOR-FL                                      
C26954        FROM   CSS_REG_PROFILE WITH(READUNCOMMITTED)                      
C26954        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                        
C35824                                                           
A01376                                                      
C26954     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT REG_GROUP_CD                                               
MFA-TR*             ,GROUP_EFF_TS                                               
MFA-TR*             ,SENIOR_FL                                                  
MFA-TR*       INTO   :LR-REG-GROUP-CD                                           
MFA-TR*             ,:LR-GROUP-EFF-TS                                           
MFA-TR*             ,:LR-SENIOR-FL                                              
MFA-TR*       FROM   CSS_REG_PROFILE                                            
MFA-TR*       WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 6100                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26954                                                                  
C26954     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
C26954     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C26954        MOVE 'Y' TO WS-SEB-REGULATED-FL                           
C26954     ELSE                                                         
C26954        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
C26954           MOVE 'N' TO WS-SEB-REGULATED-FL                        
C26954        ELSE                                                      
C26954           MOVE PROGRAM-NAME        TO ABEND-PROGRAM              
C26954           MOVE 'SELECT'            TO ABEND-FUNCTION             
C26954           MOVE 'CSS_REG_PROFILE'   TO TABLE-1                    
C26954           MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1            
C26954           MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1          
C26954           PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT          
C26954        END-IF                                                    
C26954     END-IF.                                                      
C26954                                                                  
C26954 6100-EXIT.                                                       
C26954     EXIT.                                                        
C26954*                                                                         
C26954***************************************************************           
C26954* DETERMINE IF ACCOUNT IS HAS CHANGED GROUPS                  *           
C26954***************************************************************           
C26954 6200-CHECK-GRP-MOVE.                                             
C26954                                                                  
C26954     MOVE '6200'                 TO ACTIVE-PARAGRAPH.             
C26954                                                                  
C26954     EXEC SQL                                                     
C26954        SELECT MAX(DATE_TRANS)                                    
C26954        INTO   :MH-DATE-TRANS :WS-DATE-TRANS-NI                    
C26954        FROM   CSS_MNT_TRANS_HIST WITH(READUNCOMMITTED)                   
C26954        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                        
C26954          AND  APPL_PROGRAM_ID = 'PANEL051G'                      
C35824                                                           
A01376                                                      
C26954     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(DATE_TRANS)                                            
MFA-TR*       INTO   :MH-DATE-TRANS:WS-DATE-TRANS-NI                            
MFA-TR*       FROM   CSS_MNT_TRANS_HIST                                         
MFA-TR*       WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*         AND  APPL_PROGRAM_ID = 'PANEL051G'                              
MFA-TR*         WITH UR                                                         
MFA-TR*       QUERYNO 6200                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26954                                                                  
C26954     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
D03727     IF WS-DATE-TRANS-NI = 0                                      
C26954        MOVE 'Y' TO WS-SEB-GROUP-MOVE                             
C26954     ELSE                                                         
D03727        IF WS-DATE-TRANS-NI = -1                                  
C26954           MOVE 'N' TO WS-SEB-GROUP-MOVE                          
C26954        ELSE                                                      
C26954           MOVE PROGRAM-NAME        TO ABEND-PROGRAM              
C26954           MOVE 'SELECT'            TO ABEND-FUNCTION             
C26954           MOVE 'CSS_MNT_TRANS_HIST' TO TABLE-1                   
C26954           MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1            
C26954           MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1          
C26954           PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT          
C26954        END-IF                                                    
C26954     END-IF.                                                      
C26954                                                                  
C26954 6200-EXIT.                                                       
C26954     EXIT.                                                        
      *****************************************************************         
      * FETCH DETAILS FROM THE ACCOUNT TABLE                          *         
      *****************************************************************         
       7000-SELECT-ACCOUNT.                                             
                                                                        
           MOVE '7000' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
           SELECT AT.CODE_COMPANY_ACCT,                                 
                  AT.DATE_LAST_ACTION,                                  
                  AT.ACCT_XFER_TO,                                      
T19504            AT.ACCT_XFER_FROM_LST,                                
                  AT.CODE_ACCT_STAT,                                    
                  AT.COMPANY_NO,                                        
                  AT.PREMISE_NO,                                        
                  AT.TOTAL_AR_BALANCE,                                  
                  AT.CUSTOMER_NO,                                       
                  AT.CODES_DATA_PRESENT,                                
                  AT.LOCAL_OFFICE,                                      
                  AT.CREDIT_GROUP,                                      
                  AT.CREDIT_STATUS_CODE,                                
                  AT.BILL_CYCLE,                                        
PCR361            REPLACE(REPLACE(CONVERT(CHAR(26), AT.LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,                        
PCR361            AT.NOTICE_EXEMPT_CD,                                  
PCR361            AT.CODE_DISC_OK,                                      
PCR361            AT.DATE_BILL_DAY_00,                                  
PCR361            AT.DATE_BILL_DAY_30,                                  
PCR361            AT.DATE_BILL_DAY_60,                                  
PCR361            AT.DATE_BILL_DAY_90,                                  
PCR361            AT.BANKRUPTCY_IND,                                    
C28788            AT.IVR_EXEMPT_CD,                                     
P00599            REPLACE(REPLACE(CONVERT(CHAR(26), AT.ACCT_FINALED_DT
           , 121), ' ', '-'), ':', '.') ACCT_FINALED_DT,                       
                  CZ.CASH_ONLY_FL                                       
C26296           ,CZ.AUTO_DEP_AM                                        
A37061           ,AT.ACCOUNT_TYPE_CODE                                  
           INTO   :AT-CODE-COMPANY-ACCT,                                
                  :AT-DATE-LAST-ACTION,                                 
                  :AT-ACCT-XFER-TO,                                     
T19504            :AT-ACCT-XFER-FROM-LST,                               
                  :AT-CODE-ACCT-STAT,                                   
                  :AT-COMPANY-NO,                                       
                  :AT-PREMISE-NO,                                       
                  :AT-TOTAL-AR-BALANCE,                                 
                  :AT-CUSTOMER-NO,                                      
                  :AT-CODES-DATA-PRESENT,                               
                  :AT-LOCAL-OFFICE,                                     
                  :AT-CREDIT-GROUP,                                     
                  :AT-CREDIT-STATUS-CODE,                               
                  :AT-BILL-CYCLE,                                       
PCR361            :AT-LAST-UPDATE-TS,                                   
PCR361            :AT-NOTICE-EXEMPT-CD,                                 
PCR361            :AT-CODE-DISC-OK,                                     
PCR361            :AT-DATE-BILL-DAY-00 :WS-NULL-INDICATOR-1,             
PCR361            :AT-DATE-BILL-DAY-30 :WS-NULL-INDICATOR-2,             
PCR361            :AT-DATE-BILL-DAY-60 :WS-NULL-INDICATOR-3,             
PCR361            :AT-DATE-BILL-DAY-90 :WS-NULL-INDICATOR-4,             
PCR361            :AT-BANKRUPTCY-IND,                                   
C28788            :AT-IVR-EXEMPT-CD,                                    
P00599            :AT-ACCT-FINALED-DT :WS-NULL-INDICATOR-5,             
                  :CZ-CASH-ONLY-FL                                      
C26296           ,:CZ-AUTO-DEP-AM                                       
A37061           ,:AT-ACCOUNT-TYPE-CODE                                 
           FROM   CSS_ACCOUNT AT WITH(READUNCOMMITTED),                         
                  CSS_CREDIT_PROFILE CZ WITH(READUNCOMMITTED)                   
           WHERE  AT.ACCOUNT_NO = :AT-ACCOUNT-NO                        
             AND  AT.ACCOUNT_NO = CZ.ACCOUNT_NO                         
C35824                                                           
A01376                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*    SELECT AT.CODE_COMPANY_ACCT,                                         
MFA-TR*           AT.DATE_LAST_ACTION,                                          
MFA-TR*           AT.ACCT_XFER_TO,                                              
MFA-TR*           AT.ACCT_XFER_FROM_LST,                                        
MFA-TR*           AT.CODE_ACCT_STAT,                                            
MFA-TR*           AT.COMPANY_NO,                                                
MFA-TR*           AT.PREMISE_NO,                                                
MFA-TR*           AT.TOTAL_AR_BALANCE,                                          
MFA-TR*           AT.CUSTOMER_NO,                                               
MFA-TR*           AT.CODES_DATA_PRESENT,                                        
MFA-TR*           AT.LOCAL_OFFICE,                                              
MFA-TR*           AT.CREDIT_GROUP,                                              
MFA-TR*           AT.CREDIT_STATUS_CODE,                                        
MFA-TR*           AT.BILL_CYCLE,                                                
MFA-TR*           AT.LAST_UPDATE_TS,                                            
MFA-TR*           AT.NOTICE_EXEMPT_CD,                                          
MFA-TR*           AT.CODE_DISC_OK,                                              
MFA-TR*           AT.DATE_BILL_DAY_00,                                          
MFA-TR*           AT.DATE_BILL_DAY_30,                                          
MFA-TR*           AT.DATE_BILL_DAY_60,                                          
MFA-TR*           AT.DATE_BILL_DAY_90,                                          
MFA-TR*           AT.BANKRUPTCY_IND,                                            
MFA-TR*           AT.IVR_EXEMPT_CD,                                             
MFA-TR*           AT.ACCT_FINALED_DT,                                           
MFA-TR*           CZ.CASH_ONLY_FL                                               
MFA-TR*          ,CZ.AUTO_DEP_AM                                                
MFA-TR*          ,AT.ACCOUNT_TYPE_CODE                                          
MFA-TR*    INTO   :AT-CODE-COMPANY-ACCT,                                        
MFA-TR*           :AT-DATE-LAST-ACTION,                                         
MFA-TR*           :AT-ACCT-XFER-TO,                                             
MFA-TR*           :AT-ACCT-XFER-FROM-LST,                                       
MFA-TR*           :AT-CODE-ACCT-STAT,                                           
MFA-TR*           :AT-COMPANY-NO,                                               
MFA-TR*           :AT-PREMISE-NO,                                               
MFA-TR*           :AT-TOTAL-AR-BALANCE,                                         
MFA-TR*           :AT-CUSTOMER-NO,                                              
MFA-TR*           :AT-CODES-DATA-PRESENT,                                       
MFA-TR*           :AT-LOCAL-OFFICE,                                             
MFA-TR*           :AT-CREDIT-GROUP,                                             
MFA-TR*           :AT-CREDIT-STATUS-CODE,                                       
MFA-TR*           :AT-BILL-CYCLE,                                               
MFA-TR*           :AT-LAST-UPDATE-TS,                                           
MFA-TR*           :AT-NOTICE-EXEMPT-CD,                                         
MFA-TR*           :AT-CODE-DISC-OK,                                             
MFA-TR*           :AT-DATE-BILL-DAY-00:WS-NULL-INDICATOR-1,                     
MFA-TR*           :AT-DATE-BILL-DAY-30:WS-NULL-INDICATOR-2,                     
MFA-TR*           :AT-DATE-BILL-DAY-60:WS-NULL-INDICATOR-3,                     
MFA-TR*           :AT-DATE-BILL-DAY-90:WS-NULL-INDICATOR-4,                     
MFA-TR*           :AT-BANKRUPTCY-IND,                                           
MFA-TR*           :AT-IVR-EXEMPT-CD,                                            
MFA-TR*           :AT-ACCT-FINALED-DT :WS-NULL-INDICATOR-5,                     
MFA-TR*           :CZ-CASH-ONLY-FL                                              
MFA-TR*          ,:CZ-AUTO-DEP-AM                                               
MFA-TR*          ,:AT-ACCOUNT-TYPE-CODE                                         
MFA-TR*    FROM   CSS_ACCOUNT AT,                                               
MFA-TR*           CSS_CREDIT_PROFILE CZ                                         
MFA-TR*    WHERE  AT.ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*      AND  AT.ACCOUNT_NO = CZ.ACCOUNT_NO                                 
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
PCR361     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
PCR361        IF WS-NULL-INDICATOR-1 < ZERO                             
PCR361           MOVE LOW-VALUES       TO AT-DATE-BILL-DAY-00           
PCR361        END-IF                                                    
PCR361        IF WS-NULL-INDICATOR-2 < ZERO                             
PCR361           MOVE LOW-VALUES       TO AT-DATE-BILL-DAY-30           
PCR361        END-IF                                                    
PCR361        IF WS-NULL-INDICATOR-3 < ZERO                             
PCR361           MOVE LOW-VALUES       TO AT-DATE-BILL-DAY-60           
PCR361        END-IF                                                    
PCR361        IF WS-NULL-INDICATOR-4 < ZERO                             
PCR361           MOVE LOW-VALUES       TO AT-DATE-BILL-DAY-90           
PCR361        END-IF                                                    
P00599        IF WS-NULL-INDICATOR-5 < ZERO                             
P00599           MOVE SPACES           TO AT-ACCT-FINALED-DT            
P00599        END-IF                                                    
           ELSE                                                         
PCR361        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
PCR361           CONTINUE                                               
PCR361        ELSE                                                      
                 MOVE SPACES              TO ABEND-TABLES               
                 MOVE SPACES              TO ABEND-SQL-PREDICATES       
REARCH           MOVE 'CSR02189'          TO ABEND-PROGRAM              
                 MOVE 'SELECT'            TO ABEND-FUNCTION             
                 MOVE 'CSS_ACCOUNT'       TO TABLE-1                    
CBSI             MOVE 'CSS_CREDIT_PROFILE' TO TABLE-2                   
                 MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1            
                 MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1          
PCR361           PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT              
PCR361        END-IF                                                    
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
T23501***************************************************************           
T23501* SELECT COMPANY-NO FROM CSS_ACCOUNT TABLE                    *           
T23501***************************************************************           
T23501 7010-SELECT-COMPANY.                                             
T23501                                                                  
T23501     MOVE '7010'                 TO ACTIVE-PARAGRAPH.             
T23501     EXEC SQL                                                     
T23501        SELECT COMPANY_NO                                         
T23501        INTO   :AT-COMPANY-NO                                     
T23501        FROM   CSS_ACCOUNT WITH(READUNCOMMITTED)                          
T23501        WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                        
C35824                                                           
A01376                                                      
T23501     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COMPANY_NO                                                 
MFA-TR*       INTO   :AT-COMPANY-NO                                             
MFA-TR*       FROM   CSS_ACCOUNT                                                
MFA-TR*       WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*       WITH UR                                                           
MFA-TR*      QUERYNO 7010                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T23501                                                                  
T23501     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
T23501     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T23501        NEXT SENTENCE                                             
T23501     ELSE                                                         
T23501        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
T23501        MOVE 'SELECT'            TO ABEND-FUNCTION                
T23501        MOVE 'CSS_ACCOUNT'       TO TABLE-1                       
T23501        MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
T23501        MOVE 'USER_ID'           TO TABLE-ELEMENT-2               
T23501        MOVE AT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
T23501        MOVE PARM-USER-ID        TO HOSTVAR-ELEMENT-2             
T23501        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
T23501     END-IF.                                                      
T23501                                                                  
T23501 7010-EXIT.                                                       
T23501     EXIT.                                                        
ACT005 7020-SELECT-ACCOUNT.                                             
ACT005     EXEC SQL                                                     
ACT005         SELECT CODES_DATA_PRESENT                                
ACT005         INTO   :AT-CODES-DATA-PRESENT                            
ACT005         FROM   CSS_ACCOUNT WITH(READUNCOMMITTED)                         
ACT005         WHERE  ACCOUNT_NO = :WS-ACCOUNT-NO-NUM                   
ACT005                                                           
ACT005     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODES_DATA_PRESENT                                        
MFA-TR*        INTO   :AT-CODES-DATA-PRESENT                                    
MFA-TR*        FROM   CSS_ACCOUNT                                               
MFA-TR*        WHERE  ACCOUNT_NO = :WS-ACCOUNT-NO-NUM                           
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT005                                                                  
ACT005     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
A05058                     S-RETURN-CODE.                               
ACT005     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
ACT005        NEXT SENTENCE                                             
ACT005     ELSE                                                         
ACT005        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
ACT005        MOVE '7020'                TO ACTIVE-PARAGRAPH            
ACT005        MOVE 'SELECT'              TO ABEND-FUNCTION              
ACT005        MOVE SPACES                TO ABEND-SQL-PREDICATES        
ACT005                                      ABEND-TABLES                
ACT005        MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
ACT005        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
ACT005        MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
ACT005        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
ACT005        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
ACT005 7020-EXIT.                                                       
ACT005     EXIT.                                                        
T22767***************************************************************           
T22767* 7075-SELECT-COMPANY.                                        *           
T22767***************************************************************           
T22767 7075-SELECT-COMPANY.                                             
T22767                                                                  
T22767     MOVE '7075'                 TO ACTIVE-PARAGRAPH.             
T22767     EXEC SQL                                                     
T22767     SELECT COMPANY_NO                                            
T22767     INTO   :D1-COMPANY-NO                                        
T22767     FROM   CSS_BANK WITH(READUNCOMMITTED)                                
T22767     WHERE  BANK_ID = :D1-BANK-ID                                 
C35824                                                           
A01376                                                      
T22767     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*    SELECT COMPANY_NO                                                    
MFA-TR*    INTO   :D1-COMPANY-NO                                                
MFA-TR*    FROM   CSS_BANK                                                      
MFA-TR*    WHERE  BANK_ID = :D1-BANK-ID                                         
MFA-TR*    WITH UR                                                              
MFA-TR*    QUERYNO 7075                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T22767                                                                  
T22767     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T22767                                                                  
T22767     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T22767        MOVE D1-COMPANY-NO        TO AT-COMPANY-NO                
T22767     ELSE                                                         
T22767        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
T22767        MOVE '7075'               TO ACTIVE-PARAGRAPH             
T22767        MOVE 'SELECT'             TO ABEND-FUNCTION               
T22767        MOVE 'CSS_BANK'           TO TABLE-1                      
T22767        MOVE 'BANK_ID'            TO TABLE-ELEMENT-1              
T22767        MOVE 'USER_ID'            TO TABLE-ELEMENT-2              
T22767        MOVE D1-BANK-ID           TO HOSTVAR-ELEMENT-1            
T22767        MOVE PARM-USER-ID         TO HOSTVAR-ELEMENT-2            
T22767        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
T22767     END-IF.                                                      
T22767                                                                  
T22767 7075-EXIT.                                                       
T22767     EXIT.                                                        
T22767                                                                  
      *****************************************************************         
      * FETCH DETAILS FROM THE PREMISE TABLE                          *         
      *****************************************************************         
       7100-SELECT-PREMISE.                                             
                                                                        
           MOVE '7100'                 TO ACTIVE-PARAGRAPH.             
           EXEC SQL                                                     
           SELECT CODE_PREMISE_STAT,                                    
                  REV_DISTRICT_CD,                                      
                  LOCAL_OFFICE                                          
           INTO   :PR-CODE-PREMISE-STAT,                                
                  :PR-REV-DISTRICT-CD,                                  
                  :PR-LOCAL-OFFICE                                      
           FROM   CSS_PREMISE WITH(READUNCOMMITTED)                             
           WHERE  PREMISE_NO = :PR-PREMISE-NO                           
                                                                 
A01376                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*    SELECT CODE_PREMISE_STAT,                                            
MFA-TR*           REV_DISTRICT_CD,                                              
MFA-TR*           LOCAL_OFFICE                                                  
MFA-TR*    INTO   :PR-CODE-PREMISE-STAT,                                        
MFA-TR*           :PR-REV-DISTRICT-CD,                                          
MFA-TR*           :PR-LOCAL-OFFICE                                              
MFA-TR*    FROM   CSS_PREMISE                                                   
MFA-TR*    WHERE  PREMISE_NO = :PR-PREMISE-NO                                   
MFA-TR*    WITH UR                                                              
MFA-TR*    QUERYNO 7100                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES              TO ABEND-TABLES                  
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
CBSI          MOVE 'CSR02189'          TO ABEND-PROGRAM                 
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_PREMISE'       TO TABLE-1                       
              MOVE 'PREMISE_NO'        TO TABLE-ELEMENT-1               
CBSI          MOVE 'USER_ID'           TO TABLE-ELEMENT-2               
              MOVE PR-PREMISE-NO       TO HOSTVAR-ELEMENT-1             
CBSI          MOVE PARM-USER-ID        TO HOSTVAR-ELEMENT-2             
PCR361        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
PCR361     END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
T22767***************************************************************           
T22767* 7150-CHECK-ACCT.                                            *           
T22767*     CHECKS THE EXISTANCE OF ACCOUNT NO IN CSS_ACCOUNT TABLE *           
T22767***************************************************************           
T22767 7150-CHECK-ACCT.                                                 
T22767*                                                                         
T22767     MOVE '7150'                         TO ACTIVE-PARAGRAPH.     
T22767*                                                                         
T22767     EXEC SQL                                                     
T22767        SELECT 'Y'                                                
T22767        INTO   :WS-CHECK                                          
T22767        FROM   CSS_ACCOUNT WITH(READUNCOMMITTED)                          
T22767     WHERE  ACCOUNT_NO = 1210051437424                            
A01376                                                           
A01376                                                      
T22767     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*       INTO   :WS-CHECK                                                  
MFA-TR*       FROM   CSS_ACCOUNT                                                
MFA-TR*    WHERE  ACCOUNT_NO = 1210051437424                                    
MFA-TR*    WITH UR                                                              
MFA-TR*    QUERYNO 7150                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T22767*                                                                         
T22767     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
T22767     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T22767        MOVE 1210051437424               TO NH-ACCOUNT-NO         
T22767     ELSE                                                         
T22767        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
T22767           MOVE 9310104875257            TO NH-ACCOUNT-NO         
T22767        ELSE                                                      
T22767           MOVE SPACES                   TO ABEND-TABLES          
T22767           MOVE SPACES                   TO ABEND-SQL-PREDICATES  
T22767           MOVE PROGRAM-NAME             TO ABEND-PROGRAM         
T22767           MOVE 'SELECT'                 TO ABEND-FUNCTION        
T22767           MOVE 'CSS_ACCOUNT'            TO TABLE-1               
T22767           MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1       
T22767           MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1     
T22767           PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
T22767        END-IF                                                    
T22767     END-IF.                                                      
T22767 7150-EXIT.                                                       
T22767     EXIT.                                                        
T22767*                                                                         
      ***************************************************************           
      * FETCH DETAILS FROM THE CUSTOMER TABLE                       *           
      ***************************************************************           
       7200-SELECT-CUSTOMER.                                            
                                                                        
           MOVE '7200'                 TO ACTIVE-PARAGRAPH.             
           EXEC SQL                                                     
           SELECT CODE_EMPL_ACCT,                                       
                  CODE_CUST_STATUS                                      
           INTO   :CU-CODE-EMPL-ACCT,                                   
                  :CU-CODE-CUST-STATUS                                  
           FROM   CSS_CUSTOMER WITH(READUNCOMMITTED)                            
           WHERE  CUSTOMER_NO = :CU-CUSTOMER-NO                         
                                                                 
A01376                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*    SELECT CODE_EMPL_ACCT,                                               
MFA-TR*           CODE_CUST_STATUS                                              
MFA-TR*    INTO   :CU-CODE-EMPL-ACCT,                                           
MFA-TR*           :CU-CODE-CUST-STATUS                                          
MFA-TR*    FROM   CSS_CUSTOMER                                                  
MFA-TR*    WHERE  CUSTOMER_NO = :CU-CUSTOMER-NO                                 
MFA-TR*    WITH UR                                                              
MFA-TR*    QUERYNO 7200                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES              TO ABEND-TABLES                  
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
CBSI          MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_CUSTOMER'      TO TABLE-1                       
              MOVE 'CUSTOMER_NO'       TO TABLE-ELEMENT-1               
CBSI          MOVE 'USER_ID'           TO TABLE-ELEMENT-2               
              MOVE CU-CUSTOMER-NO      TO HOSTVAR-ELEMENT-1             
CBSI          MOVE PARM-USER-ID        TO HOSTVAR-ELEMENT-2             
PCR361        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
PCR361     END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
T25923***************************************************************           
T25923* 7210-SELECT-ERROR-GL-OFFSET                                 *           
T25923***************************************************************           
T25923 7210-SELECT-ERROR-GL-OFFSET.                                     
T25923                                                                  
T25923     EXEC SQL                                                     
T25923        SELECT ERROR_GL_OFFSET                                    
T25923          INTO :WS-ERROR-GL-OFFSET                                
T25923          FROM CSS_CASHIER_OFFICE WITH(READUNCOMMITTED)                   
T25923         WHERE CASH_LOCAL_OFFICE = :Y2-CASH-LOCAL-OFFICE          
C35824                                                           
A01376                                                      
T25923     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ERROR_GL_OFFSET                                            
MFA-TR*         INTO :WS-ERROR-GL-OFFSET                                        
MFA-TR*         FROM CSS_CASHIER_OFFICE                                         
MFA-TR*        WHERE CASH_LOCAL_OFFICE = :Y2-CASH-LOCAL-OFFICE                  
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7210                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T25923                                                                  
T25923     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
T25923                                                                  
T25923     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T25923        NEXT SENTENCE                                             
T25923     ELSE                                                         
T25923        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
T25923        MOVE '7210'                TO ACTIVE-PARAGRAPH            
T25923        MOVE 'SELECT'              TO ABEND-FUNCTION              
T25923        MOVE 'CSS_CASHIER_OFFICE'  TO TABLE-1                     
T25923        MOVE 'CASH COMPANY NO'     TO TABLE-ELEMENT-1             
T25923        MOVE 'CASH LOCAL OFFICE'   TO TABLE-ELEMENT-2             
T25923        MOVE Y2-CASH-COMPANY-NO    TO HOSTVAR-ELEMENT-1           
T25923        MOVE Y2-CASH-LOCAL-OFFICE  TO HOSTVAR-ELEMENT-2           
T25923        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
T25923     END-IF.                                                      
T25923                                                                  
T25923 7210-EXIT.                                                       
T25923     EXIT.                                                        
                                                                        
T25923***************************************************************           
T25923* 7220-SELECT-DEP-CASH-GL-OFFSET.                             *           
T25923***************************************************************           
T25923 7220-SELECT-DEP-CASH-GL-OFFSET.                                  
T25923                                                                  
T25923     EXEC SQL                                                     
T25923        SELECT DEP_CASH_GL_OFFSET                                 
T25923          INTO :WS-ERROR-GL-OFFSET                                
T25923          FROM CSS_CASHIER_OFFICE WITH(READUNCOMMITTED)                   
T25923         WHERE CASH_LOCAL_OFFICE = :Y2-CASH-LOCAL-OFFICE          
C35824                                                           
A01376                                                      
T25923     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DEP_CASH_GL_OFFSET                                         
MFA-TR*         INTO :WS-ERROR-GL-OFFSET                                        
MFA-TR*         FROM CSS_CASHIER_OFFICE                                         
MFA-TR*        WHERE CASH_LOCAL_OFFICE = :Y2-CASH-LOCAL-OFFICE                  
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7220                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T25923                                                                  
T25923     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
T25923                                                                  
T25923     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T25923        NEXT SENTENCE                                             
T25923     ELSE                                                         
T25923        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
T25923        MOVE '7220'                TO ACTIVE-PARAGRAPH            
T25923        MOVE 'SELECT'              TO ABEND-FUNCTION              
T25923        MOVE 'CSS_CASHIER_OFFICE'  TO TABLE-1                     
T25923        MOVE 'CASH COMPANY NO'     TO TABLE-ELEMENT-1             
T25923        MOVE 'CASH LOCAL OFFICE'   TO TABLE-ELEMENT-2             
T25923        MOVE Y2-CASH-COMPANY-NO    TO HOSTVAR-ELEMENT-1           
T25923        MOVE Y2-CASH-LOCAL-OFFICE  TO HOSTVAR-ELEMENT-2           
T25923        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
T25923     END-IF.                                                      
T25923                                                                  
T25923 7220-EXIT.                                                       
T25923     EXIT.                                                        
                                                                        
      ***************************************************************           
      * 7240-SELECT-SUM-CSS-AR-CNTL                                 *           
      ***************************************************************           
       7240-SELECT-SUM-CSS-AR-CNTL.                                     
                                                                        
           EXEC SQL                                                     
               SELECT AMT_AR_DAY_00,                                    
                      AMT_AR_DAY_30,                                    
                      AMT_AR_DAY_60,                                    
                      AMT_AR_DAY_90,                                    
                      TOT_SUMM_UNBILLED,                                
                      AMT_UNUSED_CR                                     
               INTO   :AC-AMT-AR-DAY-00,                                
                      :AC-AMT-AR-DAY-30,                                
                      :AC-AMT-AR-DAY-60,                                
                      :AC-AMT-AR-DAY-90,                                
                      :AC-TOT-SUMM-UNBILLED,                            
                      :AC-AMT-UNUSED-CR                                 
               FROM   CSS_AR_CNTL WITH(READUNCOMMITTED)                         
               WHERE  ACCOUNT_NO        = :AC-ACCOUNT-NO                
               AND    PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL         
               AND    ITEM_ID           = :AC-ITEM-ID                   
C35824                                                           
A01376                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AMT_AR_DAY_00,                                            
MFA-TR*               AMT_AR_DAY_30,                                            
MFA-TR*               AMT_AR_DAY_60,                                            
MFA-TR*               AMT_AR_DAY_90,                                            
MFA-TR*               TOT_SUMM_UNBILLED,                                        
MFA-TR*               AMT_UNUSED_CR                                             
MFA-TR*        INTO   :AC-AMT-AR-DAY-00,                                        
MFA-TR*               :AC-AMT-AR-DAY-30,                                        
MFA-TR*               :AC-AMT-AR-DAY-60,                                        
MFA-TR*               :AC-AMT-AR-DAY-90,                                        
MFA-TR*               :AC-TOT-SUMM-UNBILLED,                                    
MFA-TR*               :AC-AMT-UNUSED-CR                                         
MFA-TR*        FROM   CSS_AR_CNTL                                               
MFA-TR*        WHERE  ACCOUNT_NO        = :AC-ACCOUNT-NO                        
MFA-TR*        AND    PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL                 
MFA-TR*        AND    ITEM_ID           = :AC-ITEM-ID                           
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7240                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
REARCH        MOVE 'CSR02189'           TO ABEND-PROGRAM                
CBSI          MOVE '7240'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_AR_CNTL'        TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'PYMT_PRIORITY_LVL'  TO TABLE-ELEMENT-2              
              MOVE 'ITEM_ID'            TO TABLE-ELEMENT-3              
              MOVE AC-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE AC-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-2            
              MOVE AC-ITEM-ID           TO HOSTVAR-ELEMENT-3            
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7240-EXIT.                                                       
           EXIT.                                                        
      *                                                                 11260000
P00581******************************************************************        
P00581*  7260-GET-JOB-PARM-VALUES.                                     *        
P00581******************************************************************        
P00581 7260-GET-JOB-PARM-VALUES.                                        
P00581*                                                                         
P00581     EXEC SQL                                                     
P00581         SELECT CIS.SUBSTR3(G6.PARM_DATA,1,10)                         
P00581               ,CIS.SUBSTR3(G6.PARM_DATA,12,20)                        
P00581               ,CIS.SUBSTR3(G6.PARM_DATA,32,20)                        
P00581           INTO :WS-FEE-INCR-DATE                                 
P00581               ,:WS-NEW-DELINQ-CD                                 
P00581               ,:WS-OLD-DELINQ-CD                                 
P00581           FROM CSS_JOB_PARM G6 WITH(READUNCOMMITTED)                     
P00581          WHERE G6.PROGRAM_NAME = :G6-PROGRAM-NAME                
P00581            AND G6.COMPANY_NO   = '01'                            
P00581            AND G6.CMND_CODE    = 'PARM'                          
P00581            AND G6.SEQ_NO       = 1                               
P00581            AND G6.STATUS       = 'A'                             
P00581                                                           
P00581                                                      
P00581     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SUBSTR(G6.PARM_DATA,1,10)                                 
MFA-TR*              ,SUBSTR(G6.PARM_DATA,12,20)                                
MFA-TR*              ,SUBSTR(G6.PARM_DATA,32,20)                                
MFA-TR*          INTO :WS-FEE-INCR-DATE                                         
MFA-TR*              ,:WS-NEW-DELINQ-CD                                         
MFA-TR*              ,:WS-OLD-DELINQ-CD                                         
MFA-TR*          FROM CSS_JOB_PARM G6                                           
MFA-TR*         WHERE G6.PROGRAM_NAME = :G6-PROGRAM-NAME                        
MFA-TR*           AND G6.COMPANY_NO   = '01'                                    
MFA-TR*           AND G6.CMND_CODE    = 'PARM'                                  
MFA-TR*           AND G6.SEQ_NO       = 1                                       
MFA-TR*           AND G6.STATUS       = 'A'                                     
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7260                                                      
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00581*                                                                         
P00581     MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
P00581*                                                                         
P00581     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00581        CONTINUE                                                  
P00581     ELSE                                                         
P00581        MOVE SPACES                TO ABEND-TABLES                
P00581        MOVE SPACES                TO ABEND-SQL-PREDICATES        
P00581        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00581        MOVE '7260'                TO ACTIVE-PARAGRAPH            
P00581        MOVE 'SELECT'              TO ABEND-FUNCTION              
P00581        MOVE 'CSS_JOB_PARM'        TO TABLE-1                     
P00581        MOVE 'PROGRAM_NAME'        TO TABLE-ELEMENT-1             
P00581        MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-2             
P00581        MOVE 'CMND_CODE'           TO TABLE-ELEMENT-3             
P00581        MOVE 'SEQ_NO'              TO TABLE-ELEMENT-4             
P00581        MOVE G6-PROGRAM-NAME       TO HOSTVAR-ELEMENT-1           
P00581        MOVE '01'                  TO HOSTVAR-ELEMENT-2           
P00581        MOVE 'PARM'                TO HOSTVAR-ELEMENT-3           
P00581        MOVE '1'                   TO HOSTVAR-ELEMENT-4           
P00581        PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
P00581     END-IF.                                                      
P00581*                                                                         
P00581 7260-EXIT.                                                       
P00581     EXIT.                                                        
P00581*                                                                         
      ***************************************************************           
      * GET RETURNED CHECK CHARGE FROM CSS_DELINQUENCY.             *           
      * THE MNEMONIC USED IS AMT-CHECKCHARGE.                       *           
      ***************************************************************           
       7300-GET-DEL-VALUE.                                              
                                                                        
           MOVE '7300' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
               SELECT DELINQ_VALUE                                      
               INTO   :C8-DELINQ-VALUE                                  
               FROM   CSS_DELINQUENCY WITH(READUNCOMMITTED)                     
               WHERE  DELINQ_CD   = :C8-DELINQ-CD                       
T23501         AND    COMPANY_NO  = :C8-COMPANY-NO                      
C35824                                                           
A01376                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DELINQ_VALUE                                              
MFA-TR*        INTO   :C8-DELINQ-VALUE                                          
MFA-TR*        FROM   CSS_DELINQUENCY                                           
MFA-TR*        WHERE  DELINQ_CD   = :C8-DELINQ-CD                               
MFA-TR*        AND    COMPANY_NO  = :C8-COMPANY-NO                              
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7300                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES              TO ABEND-TABLES                  
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
REARCH        MOVE 'CSR02189'          TO ABEND-PROGRAM                 
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_DELINQUENCY'   TO TABLE-1                       
              MOVE 'DELINQ_CD'         TO TABLE-ELEMENT-1               
CBSI          MOVE 'USER_ID'           TO TABLE-ELEMENT-2               
T23501        MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-3               
              MOVE C8-DELINQ-CD        TO HOSTVAR-ELEMENT-1             
CBSI          MOVE PARM-USER-ID        TO HOSTVAR-ELEMENT-2             
T23501        MOVE C8-COMPANY-NO       TO HOSTVAR-ELEMENT-3             
PCR361        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
PCR361     END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
C25923******************************************************************        
C25923**  7320-SELECT-CASHIER                                         **        
C25923**                                                              **        
C25923******************************************************************        
C25923 7320-SELECT-CASHIER.                                             
C25923     MOVE '7320'                   TO WS-ACTIVE-PARAGRAPH.        
C25923                                                                  
C25923     EXEC SQL                                                     
C25923       SELECT USER_ID                                             
C25923         INTO :Y2-USER-ID                                         
C25923         FROM CSS_CASHIER_OFFICE WITH(READUNCOMMITTED)                    
C25923        WHERE CASH_COMPANY_NO    = :Y2-CASH-COMPANY-NO            
C25923          AND CASH_LOCAL_OFFICE  = :Y2-CASH-LOCAL-OFFICE          
C35824                                                           
A01376                                                      
C25923     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT USER_ID                                                     
MFA-TR*        INTO :Y2-USER-ID                                                 
MFA-TR*        FROM CSS_CASHIER_OFFICE                                          
MFA-TR*       WHERE CASH_COMPANY_NO    = :Y2-CASH-COMPANY-NO                    
MFA-TR*         AND CASH_LOCAL_OFFICE  = :Y2-CASH-LOCAL-OFFICE                  
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7320                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C25923                                                                  
C25923     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
C25923                                                                  
C25923     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C25923        NEXT SENTENCE                                             
C25923     ELSE                                                         
C25923        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C25923        MOVE '7320'                TO ACTIVE-PARAGRAPH            
C25923        MOVE 'SELECT'              TO ABEND-FUNCTION              
C25923        MOVE 'CSS_CASHIER_OFFICE'  TO TABLE-1                     
C25923        MOVE 'CASH COMPANY NO'     TO TABLE-ELEMENT-1             
C25923        MOVE 'CASH LOCAL OFFICE'   TO TABLE-ELEMENT-2             
C25923        MOVE Y2-CASH-COMPANY-NO    TO HOSTVAR-ELEMENT-1           
C25923        MOVE Y2-CASH-LOCAL-OFFICE  TO HOSTVAR-ELEMENT-2           
C25923        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
C25923     END-IF.                                                      
C25923                                                                  
C25923 7320-EXIT.                                                       
C25923     EXIT.                                                        
                                                                        
C25923******************************************************************        
C25923**  7325-SELECT-CASH-REPORT                                     **        
C25923**                                                              **        
C25923******************************************************************        
C25923 7325-SELECT-CASH-REPORT.                                         
C25923     MOVE '7325'                   TO WS-ACTIVE-PARAGRAPH.        
C25923                                                                  
C25923     EXEC SQL                                                     
C25923       SELECT USER_ID                                             
C25923         INTO :YR-USER-ID                                         
C25923         FROM CSS_CSH_REPORT_HDR WITH(READUNCOMMITTED)                    
C25923        WHERE CASH_COMPANY_NO    = :YR-CASH-COMPANY-NO            
C25923          AND CASH_LOCAL_OFFICE  = :YR-CASH-LOCAL-OFFICE          
C25923          AND DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :YR-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YR-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YR-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YR-DATE-CASH-REPORT
              ), CONVERT(DATE, :YR-DATE-CASH-REPORT) )           
C35824                                                           
A01376                                                      
C25923     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT USER_ID                                                     
MFA-TR*        INTO :YR-USER-ID                                                 
MFA-TR*        FROM CSS_CSH_REPORT_HDR                                          
MFA-TR*       WHERE CASH_COMPANY_NO    = :YR-CASH-COMPANY-NO                    
MFA-TR*         AND CASH_LOCAL_OFFICE  = :YR-CASH-LOCAL-OFFICE                  
MFA-TR*         AND DATE_CASH_REPORT   = :YR-DATE-CASH-REPORT                   
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7325                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C25923                                                                  
C25923     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
C25923                                                                  
C25923     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
C25923        NEXT SENTENCE                                             
C25923     ELSE                                                         
C25923        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C25923        MOVE '7325'                TO ACTIVE-PARAGRAPH            
C25923        MOVE 'SELECT'              TO ABEND-FUNCTION              
C25923        MOVE 'CSS_CSH_REPORT_HDR'  TO TABLE-1                     
C25923        MOVE 'CASH COMPANY NO'     TO TABLE-ELEMENT-1             
C25923        MOVE 'CASH LOCAL OFFICE'   TO TABLE-ELEMENT-2             
C25923        MOVE 'DATE CASH REPORT'    TO TABLE-ELEMENT-3             
C25923        MOVE YR-CASH-COMPANY-NO    TO HOSTVAR-ELEMENT-1           
C25923        MOVE YR-CASH-LOCAL-OFFICE  TO HOSTVAR-ELEMENT-2           
C25923        MOVE YR-DATE-CASH-REPORT   TO HOSTVAR-ELEMENT-3           
C25923        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
C25923     END-IF.                                                      
C25923                                                                  
C25923 7325-EXIT.                                                       
C25923     EXIT.                                                        
P00935*                                                                         
P00935******************************************************************        
P00935* SELECT USER RESP-AREA.                                                  
P00935******************************************************************        
P00935 7350-SELECT-RESP-AREA.                                           
P00935     EXEC SQL                                                     
P00935         SELECT RESP_AREA_ID                                      
P00935           INTO :PF-RESP-AREA-ID                                  
P00935           FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                    
P00935          WHERE USER_ID = :PARM-USER-ID                           
P00935                                                           
P00935                                                      
P00935     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT RESP_AREA_ID                                              
MFA-TR*          INTO :PF-RESP-AREA-ID                                          
MFA-TR*          FROM CSS_USER_PROFILE                                          
MFA-TR*         WHERE USER_ID = :PARM-USER-ID                                   
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7350                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00935                                                                  
P00935     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00935     IF WS-ACTIVE-RETURN-CODE NOT EQUAL SUCCESSFUL-CALL           
P00935        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
P00935        MOVE '7350'              TO ACTIVE-PARAGRAPH              
P00935        MOVE 'SELECT'            TO ABEND-FUNCTION                
P00935        MOVE 'USER_ID'           TO TABLE-ELEMENT-1               
P00935        MOVE PARM-USER-ID        TO HOSTVAR-ELEMENT-1             
P00935        PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
P00935     END-IF.                                                      
P00935 7350-EXIT.                                                       
P00935     EXIT.                                                        
                                                                        
C26296*                                                                         
C26296******************************************************************        
C26296* 7500-SELECT-CURRENT-TS                                         *        
C26296******************************************************************        
C26296 7500-SELECT-CURRENT-TS.                                          
C26296                                                                  
C26296     EXEC SQL                                                     
C26296        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP            
C26296     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET  :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                    
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26296                                                                  
C26296     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C26296     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
C26296         NEXT SENTENCE                                            
C26296     ELSE                                                         
C26296         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
C26296         MOVE '7500'               TO ACTIVE-PARAGRAPH            
C26296         MOVE 'SET'                TO ABEND-FUNCTION              
C26296         MOVE SPACES               TO ABEND-SQL-PREDICATES        
C26296                                       ABEND-TABLES               
C26296         MOVE 'CSS_ACCOUNT'        TO TABLE-1                     
C26296         MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
C26296         MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
C26296         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
C26296         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
C26296     END-IF.                                                      
C26296                                                                  
C26296 7500-EXIT.                                                       
C26296     EXIT.                                                        
C26296                                                                  
P00471******************************************************************        
P00471* 7502-GET-USA-DATE                                              *        
P00471*     CALLS 9000-SEND-ERROR-RESULT                               *        
P00471*           9900-SQL-ERROR-ROUTINE                               *        
P00471*     FORMATS THE DATE                                           *        
P00471******************************************************************        
P00471 7502-GET-USA-DATE.                                               
P00471                                                                  
P00471     EXEC SQL                                                     
P00471          SELECT
              CIS.CHAR2$DATE(IIF(TRY_CONVERT(DATE, :WS-DATE-HOLD
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-HOLD
              ) <> 0) OR (LEN(:WS-DATE-HOLD) <> 10), CIS.CHAR2DATE(
                                                          :WS-DATE-HOLD
              ), CONVERT(DATE, :WS-DATE-HOLD) ),'USA')
            INTO
              :WS-DATE-HOLD-USA   
P00471     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-DATE-HOLD-USA = CHAR(DATE(:WS-DATE-HOLD),USA)           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00471                                                                  
P00471     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00471                                                                  
P00471     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00471         NEXT SENTENCE                                            
P00471     ELSE                                                         
P00471        MOVE '7502'              TO ACTIVE-PARAGRAPH              
P00471        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
P00471        MOVE 'SET'               TO ABEND-FUNCTION                
P00471        MOVE 'WS-DATE-HOLD'      TO TABLE-ELEMENT-1               
P00471        MOVE  WS-DATE-HOLD       TO HOSTVAR-ELEMENT-1             
P00471        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
P00471     END-IF.                                                      
P00471                                                                  
P00471 7502-EXIT.                                                       
P00471     EXIT.                                                        
      ***************************************************************           
      * 7600-GET-GL-NO                                              *           
      ***************************************************************           
       7600-GET-GL-NO.                                                  
                                                                        
           EXEC SQL                                                     
              SELECT GL_ACCT_NO                                         
                INTO :GO-GL-ACCT-NO                                     
                FROM CSS_GL_ACCT_NO WITH(READUNCOMMITTED)                       
MCR310         WHERE COMPANY_NO   = '01'                                
                 AND GL_ACCT_NAME = :GO-GL-ACCT-NAME                    
C35824                                                           
A01376                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT GL_ACCT_NO                                                 
MFA-TR*         INTO :GO-GL-ACCT-NO                                             
MFA-TR*         FROM CSS_GL_ACCT_NO                                             
MFA-TR*        WHERE COMPANY_NO   = '01'                                        
MFA-TR*          AND GL_ACCT_NAME = :GO-GL-ACCT-NAME                            
MFA-TR*          WITH UR                                                        
MFA-TR*         QUERYNO 7600                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7600'          TO ACTIVE-PARAGRAPH                  
              MOVE 'SELECT'             TO ABEND-FUNCTION               
CBSI          MOVE 'CSS_GL_ACCT_NO'     TO TABLE-1                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 'GL_ACCT_NAME'       TO TABLE-ELEMENT-2              
CBSI          MOVE 'USER_ID'            TO TABLE-ELEMENT-3              
              MOVE '01'                 TO HOSTVAR-ELEMENT-1            
              MOVE GO-GL-ACCT-NAME      TO HOSTVAR-ELEMENT-2            
CBSI          MOVE PARM-USER-ID         TO HOSTVAR-ELEMENT-3            
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 7610-SELECT-BANK-GL.                                        *           
      ***************************************************************           
       7610-SELECT-BANK-GL.                                             
                                                                        
           MOVE '7610'                 TO ACTIVE-PARAGRAPH.             
           EXEC SQL                                                     
           SELECT CASH_GL_ACCT_NO,                                      
PCR613            FCS_DEP_BANK_CD,                                      
PCR613            FCS_DEP_BANK_ST_CD                                    
           INTO   :D1-CASH-GL-ACCT-NO,                                  
                  :D1-FCS-DEP-BANK-CD,                                  
                  :D1-FCS-DEP-BANK-ST-CD                                
           FROM   CSS_BANK WITH(READUNCOMMITTED)                                
           WHERE  BANK_ID = :D1-BANK-ID                                 
C35824                                                           
A01376                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*    SELECT CASH_GL_ACCT_NO,                                              
MFA-TR*           FCS_DEP_BANK_CD,                                              
MFA-TR*           FCS_DEP_BANK_ST_CD                                            
MFA-TR*    INTO   :D1-CASH-GL-ACCT-NO,                                          
MFA-TR*           :D1-FCS-DEP-BANK-CD,                                          
MFA-TR*           :D1-FCS-DEP-BANK-ST-CD                                        
MFA-TR*    FROM   CSS_BANK                                                      
MFA-TR*    WHERE  BANK_ID = :D1-BANK-ID                                         
MFA-TR*    WITH UR                                                              
MFA-TR*    QUERYNO 7610                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7610'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_BANK'           TO TABLE-1                      
              MOVE 'BANK_ID'            TO TABLE-ELEMENT-1              
CBSI          MOVE 'USER_ID'            TO TABLE-ELEMENT-2              
              MOVE D1-BANK-ID           TO HOSTVAR-ELEMENT-1            
CBSI          MOVE PARM-USER-ID         TO HOSTVAR-ELEMENT-2            
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7610-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 7700-GET-1-YEAR-AGO                                         *           
      ***************************************************************           
       7700-GET-1-YEAR-AGO.                                             
                                                                        
           MOVE '7700' TO ACTIVE-PARAGRAPH.                             
                                                                        
C35824     EXEC SQL                                                     
C35824        SELECT
              DATEADD( YEAR, -1, IIF(TRY_CONVERT(DATE, :WS-DATE-HOLD
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-HOLD
              ) <> 0) OR (LEN(:WS-DATE-HOLD) <> 10), CIS.CHAR2DATE(
                                                          :WS-DATE-HOLD
              ), CONVERT(DATE, :WS-DATE-HOLD) ) )
            INTO
              :WS-DATE-1-YEAR-AGO     
C35824     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-DATE-1-YEAR-AGO = DATE(:WS-DATE-HOLD)- 1 YEAR             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7700'               TO ACTIVE-PARAGRAPH             
C35824        MOVE 'SET'                TO ABEND-FUNCTION               
C35824        MOVE SPACES               TO ABEND-SQL-PREDICATES         
C35824                                     ABEND-TABLES                 
              MOVE 'USER_ID'            TO TABLE-ELEMENT-1              
CBSI          MOVE  PARM-USER-ID        TO HOSTVAR-ELEMENT-1            
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      * 7700A-GET-DRAFT-STAT-CODE                                   *           
      ***************************************************************           
      *                                                                         
       7700A-GET-DRAFT-STAT-CODE.                                       
                                                                        
           MOVE '7700A' TO ACTIVE-PARAGRAPH.                            
      *                                                                         
           EXEC SQL                                                     
A05058       SELECT                                                     
T26396              STATUS_CODE                                         
A05058         INTO                                                     
T26396              :BE-STATUS-CODE                                     
               FROM CSS_BANK_EFT WITH(READUNCOMMITTED)                          
              WHERE ACCOUNT_NO = :BE-ACCOUNT-NO                         
C35824                                                           
A01376                                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT                                                             
MFA-TR*             STATUS_CODE                                                 
MFA-TR*        INTO                                                             
MFA-TR*             :BE-STATUS-CODE                                             
MFA-TR*        FROM CSS_BANK_EFT                                                
MFA-TR*       WHERE ACCOUNT_NO = :BE-ACCOUNT-NO                                 
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 77001                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7700A'              TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_BANK_EFT'       TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE BE-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7700A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ***************************************************************           
      * 7705-COUNT-NSF                                              *           
      ***************************************************************           
       7705-COUNT-NSF.                                                  
                                                                        
           MOVE '7705' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
              SELECT COUNT(*)                                           
A05058          INTO :WS-NSF-COUNT-C                                    
                FROM CSS_NSF_HIST WITH(READUNCOMMITTED)                         
               WHERE ACCOUNT_NO    = :NH-ACCOUNT-NO                     
T5033            AND NSF_STATUS_CD = 'C'                                
                 AND DATE_TRAN     > IIF(TRY_CONVERT(DATE, :WS-FROM-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-FROM-DATE
              ) <> 0) OR (LEN(:WS-FROM-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-FROM-DATE
              ), CONVERT(DATE, :WS-FROM-DATE) )                
                 AND DATE_TRAN     <= IIF(TRY_CONVERT(DATE, :WS-TO-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-TO-DATE) <> 0) OR (LEN(
                                                            :WS-TO-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-TO-DATE), CONVERT(DATE, 
                                                            :WS-TO-DATE
              ) )                 
C35824                                                           
A01376                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(*)                                                   
MFA-TR*         INTO :WS-NSF-COUNT-C                                            
MFA-TR*         FROM CSS_NSF_HIST                                               
MFA-TR*        WHERE ACCOUNT_NO    = :NH-ACCOUNT-NO                             
MFA-TR*          AND NSF_STATUS_CD = 'C'                                        
MFA-TR*          AND DATE_TRAN     > DATE(:WS-FROM-DATE)                        
MFA-TR*          AND DATE_TRAN     <= DATE(:WS-TO-DATE)                         
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7705                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7705'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_NSF_HIST'       TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'NSF_TYPE_CD'        TO TABLE-ELEMENT-2              
              MOVE NH-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7705-EXIT.                                                       
           EXIT.                                                        
                                                                        
A05058***************************************************************           
A05058* 7706-COUNT-NSF-FORGIVEN                                     *           
A05058***************************************************************           
A05058 7706-COUNT-NSF-FORGIVEN.                                         
A05058                                                                  
A05058     MOVE '7706' TO ACTIVE-PARAGRAPH.                             
A05058     EXEC SQL                                                     
A05058        SELECT COUNT(*)                                           
A05058          INTO :WS-NSF-COUNT-F                                    
A05058          FROM CSS_NSF_HIST WITH(READUNCOMMITTED)                         
A05058         WHERE ACCOUNT_NO    = :NH-ACCOUNT-NO                     
A05058           AND NSF_STATUS_CD = 'F'                                
A05058           AND DATE_TRAN     > IIF(TRY_CONVERT(DATE, :WS-FROM-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-FROM-DATE
              ) <> 0) OR (LEN(:WS-FROM-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-FROM-DATE
              ), CONVERT(DATE, :WS-FROM-DATE) )                
A05058           AND DATE_TRAN     <= IIF(TRY_CONVERT(DATE, :WS-TO-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-TO-DATE) <> 0) OR (LEN(
                                                            :WS-TO-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-TO-DATE), CONVERT(DATE, 
                                                            :WS-TO-DATE
              ) )                 
A05058                                                           
A05058                                                      
A05058     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(*)                                                   
MFA-TR*         INTO :WS-NSF-COUNT-F                                            
MFA-TR*         FROM CSS_NSF_HIST                                               
MFA-TR*        WHERE ACCOUNT_NO    = :NH-ACCOUNT-NO                             
MFA-TR*          AND NSF_STATUS_CD = 'F'                                        
MFA-TR*          AND DATE_TRAN     > DATE(:WS-FROM-DATE)                        
MFA-TR*          AND DATE_TRAN     <= DATE(:WS-TO-DATE)                         
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7706                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05058                                                                  
A05058     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A05058                                                                  
A05058     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A05058        NEXT SENTENCE                                             
A05058     ELSE                                                         
A05058        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
A05058        MOVE '7706'               TO ACTIVE-PARAGRAPH             
A05058        MOVE 'SELECT'             TO ABEND-FUNCTION               
A05058        MOVE 'CSS_NSF_HIST'       TO TABLE-1                      
A05058        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
A05058        MOVE 'NSF_TYPE_CD'        TO TABLE-ELEMENT-2              
A05058        MOVE NH-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
A05058        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
A05058     END-IF.                                                      
A05058                                                                  
A05058 7706-EXIT.                                                       
A05058     EXIT.                                                        
                                                                        
      ***************************************************************           
      * 7710-COUNT-N-ROWS.                                          *           
      ***************************************************************           
       7710-COUNT-N-ROWS.                                               
                                                                        
           MOVE '7710' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
              SELECT COUNT(*)                                           
                INTO :WS-N-ROW-COUNT                                    
                FROM CSS_CRED_COLL WITH(READUNCOMMITTED)                        
               WHERE ACCOUNT_NO       = :CL-ACCOUNT-NO                  
                 AND CODE_NOTICE_TYPE = 'N'                             
C35824                                                           
A01376                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(*)                                                   
MFA-TR*         INTO :WS-N-ROW-COUNT                                            
MFA-TR*         FROM CSS_CRED_COLL                                              
MFA-TR*        WHERE ACCOUNT_NO       = :CL-ACCOUNT-NO                          
MFA-TR*          AND CODE_NOTICE_TYPE = 'N'                                     
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7710                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7710'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CRED_COLL'      TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE CL-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7710-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
T21963* 7720-SELECT-SUM-ROW-N.                                      *           
      ***************************************************************           
T21963 7720-SELECT-SUM-ROW-N.                                           
                                                                        
           MOVE '7720'                 TO ACTIVE-PARAGRAPH.             
           EXEC SQL                                                     
              SELECT DATE_CREDIT_ACTION,                                
                     AMT_NOTICE,                                        
                     DATE_NOTICE_MAIL,                                  
                     CODE_MESSAGE_TYPE                                  
                INTO :CL-DATE-CREDIT-ACTION :WS-DATE-CRED-NI,            
                     :CL-AMT-NOTICE,                                    
                     :CL-DATE-NOTICE-MAIL :WS-DATE-MAIL-NI,              
                     :CL-CODE-MESSAGE-TYPE                              
                FROM CSS_CRED_COLL WITH(READUNCOMMITTED)                        
               WHERE ACCOUNT_NO          = :CL-ACCOUNT-NO               
                 AND ITEM_ID             = :CL-ITEM-ID                  
                 AND CODE_NOTICE_TYPE    = :CL-CODE-NOTICE-TYPE         
C35824                                                           
A01376                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DATE_CREDIT_ACTION,                                        
MFA-TR*              AMT_NOTICE,                                                
MFA-TR*              DATE_NOTICE_MAIL,                                          
MFA-TR*              CODE_MESSAGE_TYPE                                          
MFA-TR*         INTO :CL-DATE-CREDIT-ACTION:WS-DATE-CRED-NI,                    
MFA-TR*              :CL-AMT-NOTICE,                                            
MFA-TR*              :CL-DATE-NOTICE-MAIL:WS-DATE-MAIL-NI,                      
MFA-TR*              :CL-CODE-MESSAGE-TYPE                                      
MFA-TR*         FROM CSS_CRED_COLL                                              
MFA-TR*        WHERE ACCOUNT_NO          = :CL-ACCOUNT-NO                       
MFA-TR*          AND ITEM_ID             = :CL-ITEM-ID                          
MFA-TR*          AND CODE_NOTICE_TYPE    = :CL-CODE-NOTICE-TYPE                 
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7720                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CRED_COLL'      TO TABLE-1                      
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'ITEM_ID'            TO TABLE-ELEMENT-2              
CBSI          MOVE 'CODE_NOTICE_TYPE'   TO TABLE-ELEMENT-3              
CBSI          MOVE CL-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE CL-ITEM-ID           TO HOSTVAR-ELEMENT-2            
CBSI          MOVE CL-CODE-NOTICE-TYPE  TO HOSTVAR-ELEMENT-3            
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
TP5033     IF WS-DATE-CRED-NI  = -1                                     
TP5033        MOVE LOW-VALUES          TO CL-DATE-CREDIT-ACTION         
           END-IF.                                                      
                                                                        
TP5033     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T21963        MOVE CL-AMT-NOTICE        TO NSUM-CL-AMT-NOTICE           
TP5033        MOVE CL-DATE-NOTICE-MAIL  TO SUM-DATE-NOTICE-MAIL         
TP5033        MOVE CL-CODE-MESSAGE-TYPE TO SUM-CODE-MESSAGE-TYPE        
TP5033     ELSE                                                         
TP5033        MOVE SPACES               TO SUM-DATE-NOTICE-MAIL         
T21963        MOVE ZEROES               TO NSUM-CL-AMT-NOTICE           
TP5033                                     SUM-CODE-MESSAGE-TYPE        
TP5033     END-IF.                                                      
                                                                        
       7720-EXIT.                                                       
           EXIT.                                                        
                                                                        
T21963***************************************************************           
T21963* 7721-SELECT-SUM-ROW-V.                                      *           
T21963***************************************************************           
T21963 7721-SELECT-SUM-ROW-V.                                           
T21963                                                                  
T21963     MOVE '7721'                 TO ACTIVE-PARAGRAPH.             
T21963     EXEC SQL                                                     
T21963        SELECT DATE_CREDIT_ACTION,                                
T21963               AMT_NOTICE,                                        
T21963               DATE_NOTICE_MAIL,                                  
T21963               CODE_MESSAGE_TYPE                                  
T21963          INTO :CL-DATE-CREDIT-ACTION :WS-DATE-CRED-NI,            
T21963               :CL-AMT-NOTICE,                                    
T21963               :CL-DATE-NOTICE-MAIL :WS-DATE-MAIL-NI,              
T21963               :CL-CODE-MESSAGE-TYPE                              
T21963          FROM CSS_CRED_COLL WITH(READUNCOMMITTED)                        
T21963         WHERE ACCOUNT_NO          = :CL-ACCOUNT-NO               
T21963           AND ITEM_ID              = :CL-ITEM-ID                 
T21963           AND CODE_NOTICE_TYPE     = :CL-CODE-NOTICE-TYPE        
C35824                                                           
A01376                                                      
T21963     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DATE_CREDIT_ACTION,                                        
MFA-TR*              AMT_NOTICE,                                                
MFA-TR*              DATE_NOTICE_MAIL,                                          
MFA-TR*              CODE_MESSAGE_TYPE                                          
MFA-TR*         INTO :CL-DATE-CREDIT-ACTION:WS-DATE-CRED-NI,                    
MFA-TR*              :CL-AMT-NOTICE,                                            
MFA-TR*              :CL-DATE-NOTICE-MAIL:WS-DATE-MAIL-NI,                      
MFA-TR*              :CL-CODE-MESSAGE-TYPE                                      
MFA-TR*         FROM CSS_CRED_COLL                                              
MFA-TR*        WHERE ACCOUNT_NO          = :CL-ACCOUNT-NO                       
MFA-TR*          AND ITEM_ID              = :CL-ITEM-ID                         
MFA-TR*          AND CODE_NOTICE_TYPE     = :CL-CODE-NOTICE-TYPE                
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7721                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21963                                                                  
T21963     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T21963                                                                  
T21963     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
T21963        NEXT SENTENCE                                             
T21963     ELSE                                                         
T21963        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
T21963        MOVE 'SELECT'             TO ABEND-FUNCTION               
T21963        MOVE 'CSS_CRED_COLL'      TO TABLE-1                      
T21963        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
T21963        MOVE 'ITEM_ID'            TO TABLE-ELEMENT-2              
T21963        MOVE 'CODE_NOTICE_TYPE'   TO TABLE-ELEMENT-3              
T21963        MOVE CL-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
T21963        MOVE CL-ITEM-ID           TO HOSTVAR-ELEMENT-2            
T21963        MOVE CL-CODE-NOTICE-TYPE  TO HOSTVAR-ELEMENT-3            
T21963        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
T21963     END-IF.                                                      
T21963     IF WS-DATE-CRED-NI  = -1                                     
T21963        MOVE LOW-VALUES          TO CL-DATE-CREDIT-ACTION         
T21963     END-IF.                                                      
T21963                                                                  
T21963     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T21963        MOVE CL-AMT-NOTICE        TO VSUM-CL-AMT-NOTICE           
T21963     ELSE                                                         
T21963        MOVE ZEROES               TO VSUM-CL-AMT-NOTICE           
T21963     END-IF.                                                      
T21963                                                                  
T21963 7721-EXIT.                                                       
T21963     EXIT.                                                        
                                                                        
T21963***************************************************************           
T21963* 7722-SELECT-SUM-ROW-W.                                      *           
T21963***************************************************************           
T21963 7722-SELECT-SUM-ROW-W.                                           
T21963                                                                  
T21963     MOVE '7722'                 TO ACTIVE-PARAGRAPH.             
T21963     EXEC SQL                                                     
T21963        SELECT DATE_CREDIT_ACTION,                                
T21963               AMT_NOTICE,                                        
T21963               DATE_NOTICE_MAIL,                                  
T21963               CODE_MESSAGE_TYPE                                  
T21963          INTO :CL-DATE-CREDIT-ACTION :WS-DATE-CRED-NI,            
T21963               :CL-AMT-NOTICE,                                    
T21963               :CL-DATE-NOTICE-MAIL :WS-DATE-MAIL-NI,              
T21963               :CL-CODE-MESSAGE-TYPE                              
T21963          FROM CSS_CRED_COLL WITH(READUNCOMMITTED)                        
T21963         WHERE ACCOUNT_NO          = :CL-ACCOUNT-NO               
T21963           AND ITEM_ID             = :CL-ITEM-ID                  
T21963           AND CODE_NOTICE_TYPE    = :CL-CODE-NOTICE-TYPE         
A01376                                                      
C35824                                                           
T21963     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DATE_CREDIT_ACTION,                                        
MFA-TR*              AMT_NOTICE,                                                
MFA-TR*              DATE_NOTICE_MAIL,                                          
MFA-TR*              CODE_MESSAGE_TYPE                                          
MFA-TR*         INTO :CL-DATE-CREDIT-ACTION:WS-DATE-CRED-NI,                    
MFA-TR*              :CL-AMT-NOTICE,                                            
MFA-TR*              :CL-DATE-NOTICE-MAIL:WS-DATE-MAIL-NI,                      
MFA-TR*              :CL-CODE-MESSAGE-TYPE                                      
MFA-TR*         FROM CSS_CRED_COLL                                              
MFA-TR*        WHERE ACCOUNT_NO          = :CL-ACCOUNT-NO                       
MFA-TR*          AND ITEM_ID             = :CL-ITEM-ID                          
MFA-TR*          AND CODE_NOTICE_TYPE    = :CL-CODE-NOTICE-TYPE                 
MFA-TR*          QUERYNO 7722                                                   
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21963                                                                  
T21963     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T21963                                                                  
T21963     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
T21963        NEXT SENTENCE                                             
T21963     ELSE                                                         
T21963        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
T21963        MOVE 'SELECT'             TO ABEND-FUNCTION               
T21963        MOVE 'CSS_CRED_COLL'      TO TABLE-1                      
T21963        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
T21963        MOVE 'ITEM_ID'            TO TABLE-ELEMENT-2              
T21963        MOVE 'CODE_NOTICE_TYPE'   TO TABLE-ELEMENT-3              
T21963        MOVE CL-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
T21963        MOVE CL-ITEM-ID           TO HOSTVAR-ELEMENT-2            
T21963        MOVE CL-CODE-NOTICE-TYPE  TO HOSTVAR-ELEMENT-3            
T21963        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
T21963     END-IF.                                                      
T21963     IF WS-DATE-CRED-NI  = -1                                     
T21963        MOVE LOW-VALUES          TO CL-DATE-CREDIT-ACTION         
T21963     END-IF.                                                      
T21963                                                                  
T21963     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T21963        MOVE CL-AMT-NOTICE        TO WSUM-CL-AMT-NOTICE           
T21963     ELSE                                                         
T21963        MOVE ZEROES               TO WSUM-CL-AMT-NOTICE           
T21963     END-IF.                                                      
T21963                                                                  
T21963 7722-EXIT.                                                       
T21963     EXIT.                                                        
                                                                        
PCR263***************************************************************           
PCR263* 7725-SELECT-SEND-NOT-CD                                     *           
PCR263***************************************************************           
PCR263 7725-SELECT-SEND-NOT-CD.                                         
PCR263                                                                  
PCR263     EXEC SQL                                                     
PCR263        SELECT SEND_NOTICE_CD                                     
PCR263          INTO :NH-SEND-NOTICE-CD                                 
PCR263          FROM CSS_NSF_HIST WITH(READUNCOMMITTED)                         
PCR263         WHERE ACCOUNT_NO    = :NH-ACCOUNT-NO                     
PRC263           AND NSF_TIMESTMP  = CIS.CHAR2TIMESTAMP(:NH-NSF-TIMESTMP
              )                   
C35824                                                           
A01376                                                      
PCR263     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SEND_NOTICE_CD                                             
MFA-TR*         INTO :NH-SEND-NOTICE-CD                                         
MFA-TR*         FROM CSS_NSF_HIST                                               
MFA-TR*        WHERE ACCOUNT_NO    = :NH-ACCOUNT-NO                             
MFA-TR*          AND NSF_TIMESTMP  = :NH-NSF-TIMESTMP                           
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7725                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PCR263                                                                  
PCR263     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
PCR263                                                                  
PCR263     IF WS-ACTIVE-RETURN-CODE = (SUCCESSFUL-CALL OR NOT-FOUND)    
PCR263        NEXT SENTENCE                                             
PCR263     ELSE                                                         
PCR263        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
PCR263        MOVE '7725'               TO ACTIVE-PARAGRAPH             
PCR263        MOVE 'SELECT'             TO ABEND-FUNCTION               
PCR263        MOVE 'CSS_NSF_HIST'       TO TABLE-1                      
PCR263        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
PCR263        MOVE NH-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
PCR263     END-IF.                                                      
PCR263                                                                  
PCR263 7725-EXIT.                                                       
PCR263     EXIT.                                                        
PCR263                                                                  
C26296*                                                                         
      ***************************************************************           
      * 7900-SELECT-AR-HEADER                                       *           
      ***************************************************************           
       7900-SELECT-AR-HEADER.                                           
                                                                        
           MOVE '7900' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
              SELECT AMT_ORIG_ENTERED,                                  
                     DATE_TRANS                                         
                INTO :AR-AMT-ORIG-ENTERED,                              
T13899               :WS-DATE-ORIG-PYMT :WS-DATE-ORIG-PYMT-IND          
                FROM CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                    
               WHERE ACCOUNT_NO          = :AR-ACCOUNT-NO               
                 AND TRANS_HIST_SEQ_NO   = CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )        
C35824                                                           
A01376                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AMT_ORIG_ENTERED,                                          
MFA-TR*              DATE_TRANS                                                 
MFA-TR*         INTO :AR-AMT-ORIG-ENTERED,                                      
MFA-TR*              :WS-DATE-ORIG-PYMT :WS-DATE-ORIG-PYMT-IND                  
MFA-TR*         FROM CSS_AR_TRANS_HIST                                          
MFA-TR*        WHERE ACCOUNT_NO          = :AR-ACCOUNT-NO                       
MFA-TR*          AND TRANS_HIST_SEQ_NO   = :AR-TRANS-HIST-SEQ-NO                
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7900                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
T8741      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T13899        IF WS-DATE-ORIG-PYMT-IND < 0                              
                  MOVE SPACES     TO WS-DATE-ORIG-PYMT                  
              END-IF                                                    
           ELSE                                                         
T10101        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
T8741             MOVE ZEROES               TO AR-AMT-ORIG-ENTERED      
T13899            MOVE -1                   TO WS-DATE-ORIG-PYMT-IND    
T13899            MOVE SPACES               TO WS-DATE-ORIG-PYMT        
              ELSE                                                      
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE 'SELECT'             TO ABEND-FUNCTION           
                  MOVE 'CSS_AR_TRANS_HIST'  TO TABLE-1                  
                  MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1          
                  MOVE 'TRANS_HIST_SEQ_NO'  TO TABLE-ELEMENT-2          
                  MOVE AR-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1        
                  MOVE AR-TRANS-HIST-SEQ-NO TO HOSTVAR-ELEMENT-2        
PCR361            PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT        
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
PCR263                                                                  
PCR263***************************************************************           
PCR263* 7950-MED-CERT-EXP-DATE.                                     *           
PCR263***************************************************************           
PCR263 7950-MED-CERT-EXP-DATE.                                          
PCR263                                                                  
PCR263     EXEC SQL                                                     
PCR263        SELECT DATE_EXPIRE                                        
PCR263          INTO :CA-DATE-EXPIRE                                    
PCR263          FROM CSS_CUST_ALERT WITH(READUNCOMMITTED)                       
PCR263         WHERE ACCOUNT_NO    = :CA-ACCOUNT-NO                     
PRC263           AND DATE_EXPIRE   >= IIF(TRY_CONVERT(DATE, 
                                                          :CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :CURRENT-DATE
              ) <> 0) OR (LEN(:CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                          :CURRENT-DATE
              ), CONVERT(DATE, :CURRENT-DATE) )                     
C35824                                                           
A01376                                                      
PCR263     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DATE_EXPIRE                                                
MFA-TR*         INTO :CA-DATE-EXPIRE                                            
MFA-TR*         FROM CSS_CUST_ALERT                                             
MFA-TR*        WHERE ACCOUNT_NO    = :CA-ACCOUNT-NO                             
MFA-TR*          AND DATE_EXPIRE   >= :CURRENT-DATE                             
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7950                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PCR263                                                                  
PCR263     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
PCR263                                                                  
PCR263     IF WS-ACTIVE-RETURN-CODE = (SUCCESSFUL-CALL OR NOT-FOUND)    
PCR263        NEXT SENTENCE                                             
PCR263     ELSE                                                         
PCR263        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
PCR263        MOVE '7950'               TO ACTIVE-PARAGRAPH             
PCR263        MOVE 'SELECT'             TO ABEND-FUNCTION               
PCR263        MOVE 'CSS_CUST_ALERT'     TO TABLE-1                      
PCR263        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'DATE_EXPIRE'        TO TABLE-ELEMENT-2              
PCR263        MOVE CA-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE CURRENT-DATE         TO HOSTVAR-ELEMENT-2            
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
PCR263     END-IF.                                                      
PCR263                                                                  
PCR263 7950-EXIT.                                                       
PCR263     EXIT.                                                        
PCR263                                                                  
PCR263***************************************************************           
PCR263* 7995-SELECT-HOLIDAY.                                        *           
PCR263* CALLS 9700-PROCESS-ABEND                                    *           
PCR263* SELECTS CSS_HOLIDAY TABLE TO CHECK FOR HOLIDAY DAYS.        *           
PCR263***************************************************************           
PCR263 7995-SELECT-HOLIDAY.                                             
PCR263*                                                                         
PCR263     MOVE 'N'                     TO WS-HOLIDAY-EXISTS.           
PCR263*                                                                         
PCR263     EXEC SQL                                                     
C35824        SELECT TOP(1) ('Y')                                              
PCR263          INTO :WS-HOLIDAY-EXISTS                                 
PCR263          FROM CSS_HOLIDAY WITH(READUNCOMMITTED)                          
PCR263         WHERE HOLIDAY_DT = IIF(TRY_CONVERT(DATE, :J8-HOLIDAY-DT
              ) IS NULL OR (PATINDEX('%.%', :J8-HOLIDAY-DT
              ) <> 0) OR (LEN(:J8-HOLIDAY-DT) <> 10), CIS.CHAR2DATE(
                                                         :J8-HOLIDAY-DT
              ), CONVERT(DATE, :J8-HOLIDAY-DT) )                        
C35824                                              
C35824                                                           
A01376                                                      
PCR263     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ('Y')                                                      
MFA-TR*         INTO :WS-HOLIDAY-EXISTS                                         
MFA-TR*         FROM CSS_HOLIDAY                                                
MFA-TR*        WHERE HOLIDAY_DT = :J8-HOLIDAY-DT                                
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7995                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PCR263                                                                  
PCR263     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
PCR263                                                                  
PCR263     IF WS-ACTIVE-RETURN-CODE = (SUCCESSFUL-CALL OR NOT-FOUND)    
PCR263        NEXT SENTENCE                                             
PCR263     ELSE                                                         
PCR263        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
PCR263        MOVE '7995'               TO ACTIVE-PARAGRAPH             
PCR263        MOVE 'SELECT'             TO ABEND-FUNCTION               
PCR263        MOVE 'CSS_HOLIDAY'        TO TABLE-1                      
CBSI          MOVE 'HOLIDAY_DT'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'USER_ID'            TO TABLE-ELEMENT-2              
CBSI          MOVE J8-HOLIDAY-DT        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE PARM-USER-ID         TO HOSTVAR-ELEMENT-2            
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
PCR263     END-IF.                                                      
PCR263                                                                  
PCR263 7995-EXIT.                                                       
PCR263     EXIT.                                                        
PCR263                                                                  
PCR263***************************************************************           
PCR263* 7997-GET-NEXT-DAY.                                          *           
PCR263* CALLS 9700-PROCESS-ABEND                                    *           
PCR263* GETS THE DAY NUMBER (0-6) OF THE NEXT DAY (SUNDAY-SATURDAY).*           
PCR263***************************************************************           
PCR263 7997-GET-NEXT-DAY.                                               
PCR263                                                                  
C35824     EXEC SQL                                                     
C35824        SELECT
              DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, :WS-DATE-HOLD
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-HOLD
              ) <> 0) OR (LEN(:WS-DATE-HOLD) <> 10), CIS.CHAR2DATE(
                                                          :WS-DATE-HOLD
              ), CONVERT(DATE, :WS-DATE-HOLD) ) ),
              CIS.DAYS (DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, 
                                                          :WS-DATE-HOLD
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-HOLD
              ) <> 0) OR (LEN(:WS-DATE-HOLD) <> 10), CIS.CHAR2DATE(
                                                          :WS-DATE-HOLD
              ), CONVERT(DATE, :WS-DATE-HOLD) ) ))         
C35824               - (CIS.DAYS(DATEADD( DAY, 1, IIF(TRY_CONVERT(DATE, 
                                                          :WS-DATE-HOLD
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-HOLD
              ) <> 0) OR (LEN(:WS-DATE-HOLD) <> 10), CIS.CHAR2DATE(
                                                          :WS-DATE-HOLD
              ), CONVERT(DATE, :WS-DATE-HOLD) ) ))/7 * 7)
            INTO
              :WS-DATE-HOLD,
              :WS-DAY                                  
C35824     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-DATE-HOLD = DATE(:WS-DATE-HOLD) + 1 DAYS,                 
MFA-TR*           :WS-DAY = DAYS (DATE(:WS-DATE-HOLD) + 1 DAYS)                 
MFA-TR*              - (INTEGER(DAYS(DATE(:WS-DATE-HOLD)                        
MFA-TR*              + 1 DAYS)/7) * 7)                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PCR263     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
PCR263                                                                  
PCR263     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
PCR263        NEXT SENTENCE                                             
PCR263     ELSE                                                         
PCR263        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
PCR263        MOVE '7997'               TO ACTIVE-PARAGRAPH             
C35824        MOVE 'SET'                TO ABEND-FUNCTION               
C35824        MOVE SPACES               TO ABEND-SQL-PREDICATES         
C35824                                     ABEND-TABLES                 
CBSI          MOVE 'USER_ID'            TO TABLE-ELEMENT-1              
CBSI          MOVE PARM-USER-ID         TO HOSTVAR-ELEMENT-1            
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
PCR263     END-IF.                                                      
PCR263                                                                  
PCR263 7997-EXIT.                                                       
PCR263     EXIT.                                                        
PCR263                                                                  
T32545***************************************************************** 29530000
T32545*                                                               * 29570000
T32545* 7998-GET-PREV-DAY                                             * 29540000
T32545***************************************************************** 29620000
T32545 7998-GET-PREV-DAY.                                               
T32545                                                                  
C35824     EXEC SQL                                                     
T32545       SELECT
              DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, :WS-DATE-HOLD
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-HOLD
              ) <> 0) OR (LEN(:WS-DATE-HOLD) <> 10), CIS.CHAR2DATE(
                                                          :WS-DATE-HOLD
              ), CONVERT(DATE, :WS-DATE-HOLD) ) ),
              CIS.DAYS (DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                          :WS-DATE-HOLD
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-HOLD
              ) <> 0) OR (LEN(:WS-DATE-HOLD) <> 10), CIS.CHAR2DATE(
                                                          :WS-DATE-HOLD
              ), CONVERT(DATE, :WS-DATE-HOLD) ) ))          
T32545              - (CIS.DAYS(DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                          :WS-DATE-HOLD
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-HOLD
              ) <> 0) OR (LEN(:WS-DATE-HOLD) <> 10), CIS.CHAR2DATE(
                                                          :WS-DATE-HOLD
              ), CONVERT(DATE, :WS-DATE-HOLD) ) ))/7 * 7)
            INTO
              :WS-DATE-HOLD,
              :WS-DAY                                   
T32545     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                     29650000
MFA-TR*      SET :WS-DATE-HOLD = DATE(:WS-DATE-HOLD) - 1 DAYS,          29660000
MFA-TR*          :WS-DAY = DAYS (DATE(:WS-DATE-HOLD) - 1 DAYS)          29670000
MFA-TR*             - (INTEGER(DAYS(DATE(:WS-DATE-HOLD)                 29680000
MFA-TR*             - 1 DAYS)/7) * 7)                                   29681000
MFA-TR*    END-EXEC.                                                    29720000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T32545     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
T32545                                                                  
T32545     IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
T32545        CONTINUE                                                  
T32545     ELSE                                                         
T32545        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
T32545        MOVE '7997'               TO ACTIVE-PARAGRAPH             
C35824        MOVE 'SET'                TO ABEND-FUNCTION               
C35824        MOVE SPACES               TO ABEND-SQL-PREDICATES         
C35824                                     ABEND-TABLES                 
T32545        MOVE 'USER_ID'            TO TABLE-ELEMENT-1              
T32545        MOVE PARM-USER-ID         TO HOSTVAR-ELEMENT-1            
T32545        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
T32545     END-IF.                                                      
T32545                                                                  
T32545 7998-EXIT.                                                       
T32545     EXIT.                                                        
                                                                        
HPCCDM*EJECT                                                                    
                                                                        
      ****************************************************************          
      * 7999-SELECT-AL AR LOCKOUT AND TRANSFER ROUTINE               *          
      ****************************************************************          
              EXEC SQL                                                          
                 INCLUDE CPD00075                                               
              END-EXEC.                                                         
                                                                        
      ******************************************************************00010000
      *  7999-SELECT-TRANSFER-IND.                                      PCS09260
      ******************************************************************00010000
              EXEC SQL                                                          
                 INCLUDE CPD00307                                               
              END-EXEC.                                                         
                                                                        
      ***************************************************************           
      * 8000-UPDATE-CSS-ACCOUNT                                     *           
      ***************************************************************           
       8000-UPDATE-CSS-ACCOUNT.                                         
                                                                        
           MOVE '8000' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
                 SET DATE_LAST_ACTION   = IIF(TRY_CONVERT(DATE, 
                                                   :AT-DATE-LAST-ACTION
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-LAST-ACTION
              ) <> 0) OR (LEN(:AT-DATE-LAST-ACTION
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-LAST-ACTION
              ), CONVERT(DATE, :AT-DATE-LAST-ACTION) ),         
                     TOTAL_AR_BALANCE   = :AT-TOTAL-AR-BALANCE,         
                     CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT,       
PCR263               LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()             
               WHERE ACCOUNT_NO      = :AT-ACCOUNT-NO                   
                 AND LAST_UPDATE_TS  = CIS.CHAR2TIMESTAMP(
                                                     :AT-LAST-UPDATE-TS
              )               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCOUNT                                                
MFA-TR*          SET DATE_LAST_ACTION   = :AT-DATE-LAST-ACTION,                 
MFA-TR*              TOTAL_AR_BALANCE   = :AT-TOTAL-AR-BALANCE,                 
MFA-TR*              CODES_DATA_PRESENT = :AT-CODES-DATA-PRESENT,               
MFA-TR*              LAST_UPDATE_TS     = CURRENT TIMESTAMP                     
MFA-TR*        WHERE ACCOUNT_NO      = :AT-ACCOUNT-NO                           
MFA-TR*          AND LAST_UPDATE_TS  = :AT-LAST-UPDATE-TS                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
REARCH        MOVE 'CSR02189'           TO ABEND-PROGRAM                
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCOUNT'        TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'LAST_UPDATE_TS'     TO TABLE-ELEMENT-2              
CBSI          MOVE 'DATE_LAST_ACTION'   TO TABLE-ELEMENT-3              
CBSI          MOVE 'TOTAL_AR_BALANCE'   TO TABLE-ELEMENT-4              
              MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE AT-LAST-UPDATE-TS    TO HOSTVAR-ELEMENT-2            
CBSI          MOVE AT-DATE-LAST-ACTION  TO HOSTVAR-ELEMENT-3            
CBSI          MOVE AT-TOTAL-AR-BALANCE  TO HOSTVAR-ELEMENT-4-N          
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * INSERT RECORD IN CSS_NSF_HIST FOR RETURNED CHECKS.          *           
      ***************************************************************           
       8150-INSERT-CSS-NSF-HIST.                                        
                                                                        
           MOVE '8150' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
              INSERT INTO CSS_NSF_HIST                                  
                   ( ACCOUNT_NO         ,                               
                     BANK_ID            ,                               
                     CHECK_NONUTIL_AMT  ,                               
                     CHECK_UTIL_AMT     ,                               
                     DATE_TRAN          ,                               
                     DRAWN_BY_NM        ,                               
                     NSC_REMOVE_FL      ,                               
                     NSF_CHARGE_AMT     ,                               
                     NSF_ORIG_DT        ,                               
                     NSF_REASON_CD      ,                               
                     NSF_STATUS_CD      ,                               
                     NSF_TIMESTMP       ,                               
                     NSF_TYPE_CD        ,                               
                     RETURN_CHECK_AMT   ,                               
                     WAIVER_REASON_CD   ,                               
                     TRANS_HIST_SEQ_NO  ,                               
                     SEND_NOTICE_CD     ,                               
T22767               COMMENTS           ,                               
T22767               NON_CIS_ACCT_NO    ,                               
T22767               NON_CIS_GL_ACCT    ,                               
T22767               PAYMENT_TYPE_TX    ,                               
T25923               PARTIAL_PYMT_FL    ,                               
T25923               BANK_POST_DT       ,                               
T25923               DATE_ORIG_PYMT     ,                               
T25923               ORIG_PYMT_OFFICE)                                  
            VALUES (:NH-ACCOUNT-NO         ,                            
                    :NH-BANK-ID            ,                            
                    :NH-CHECK-NONUTIL-AMT  ,                            
                    :NH-CHECK-UTIL-AMT     ,                            
                    IIF(TRY_CONVERT(DATE, :NH-DATE-TRAN
              ) IS NULL OR (PATINDEX('%.%', :NH-DATE-TRAN
              ) <> 0) OR (LEN(:NH-DATE-TRAN) <> 10), CIS.CHAR2DATE(
                                                          :NH-DATE-TRAN
              ), CONVERT(DATE, :NH-DATE-TRAN) )          ,                     
                    :NH-DRAWN-BY-NM        ,                            
                    :NH-NSC-REMOVE-FL      ,                            
                    :NH-NSF-CHARGE-AMT     ,                            
                    IIF(TRY_CONVERT(DATE, :NH-NSF-ORIG-DT
              ) IS NULL OR (PATINDEX('%.%', :NH-NSF-ORIG-DT
              ) <> 0) OR (LEN(:NH-NSF-ORIG-DT) <> 10), CIS.CHAR2DATE(
                                                        :NH-NSF-ORIG-DT
              ), CONVERT(DATE, :NH-NSF-ORIG-DT) )        ,                     
                    :NH-NSF-REASON-CD      ,                            
                    :NH-NSF-STATUS-CD      ,                            
                    CIS.CHAR2TIMESTAMP(:NH-NSF-TIMESTMP)       ,                
                    :NH-NSF-TYPE-CD        ,                            
                    :NH-RETURN-CHECK-AMT   ,                            
                    :NH-WAIVER-REASON-CD   ,                            
                    CIS.CHAR2TIMESTAMP(:NH-TRANS-HIST-SEQ-NO)  ,                
                    :NH-SEND-NOTICE-CD     ,                            
T22767              :NH-COMMENTS           ,                            
T22767              :NH-NON-CIS-ACCT-NO    ,                            
T22767              :NH-NON-CIS-GL-ACCT    ,                            
T22767              :NH-PAYMENT-TYPE-TX    ,                            
T25923              :NH-PARTIAL-PYMT-FL    ,                            
T25923              IIF(TRY_CONVERT(DATE, :NH-BANK-POST-DT
              ) IS NULL OR (PATINDEX('%.%', :NH-BANK-POST-DT
              ) <> 0) OR (LEN(:NH-BANK-POST-DT) <> 10), CIS.CHAR2DATE(
                                                       :NH-BANK-POST-DT
              ), CONVERT(DATE, :NH-BANK-POST-DT) )       ,                     
T25923              IIF(TRY_CONVERT(DATE, :NH-DATE-ORIG-PYMT
              ) IS NULL OR (PATINDEX('%.%', :NH-DATE-ORIG-PYMT
              ) <> 0) OR (LEN(:NH-DATE-ORIG-PYMT
              ) <> 10), CIS.CHAR2DATE(:NH-DATE-ORIG-PYMT
              ), CONVERT(DATE, :NH-DATE-ORIG-PYMT) )     ,                     
T25923              :NH-ORIG-PYMT-OFFICE)                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_NSF_HIST                                          
MFA-TR*            ( ACCOUNT_NO         ,                                       
MFA-TR*              BANK_ID            ,                                       
MFA-TR*              CHECK_NONUTIL_AMT  ,                                       
MFA-TR*              CHECK_UTIL_AMT     ,                                       
MFA-TR*              DATE_TRAN          ,                                       
MFA-TR*              DRAWN_BY_NM        ,                                       
MFA-TR*              NSC_REMOVE_FL      ,                                       
MFA-TR*              NSF_CHARGE_AMT     ,                                       
MFA-TR*              NSF_ORIG_DT        ,                                       
MFA-TR*              NSF_REASON_CD      ,                                       
MFA-TR*              NSF_STATUS_CD      ,                                       
MFA-TR*              NSF_TIMESTMP       ,                                       
MFA-TR*              NSF_TYPE_CD        ,                                       
MFA-TR*              RETURN_CHECK_AMT   ,                                       
MFA-TR*              WAIVER_REASON_CD   ,                                       
MFA-TR*              TRANS_HIST_SEQ_NO  ,                                       
MFA-TR*              SEND_NOTICE_CD     ,                                       
MFA-TR*              COMMENTS           ,                                       
MFA-TR*              NON_CIS_ACCT_NO    ,                                       
MFA-TR*              NON_CIS_GL_ACCT    ,                                       
MFA-TR*              PAYMENT_TYPE_TX    ,                                       
MFA-TR*              PARTIAL_PYMT_FL    ,                                       
MFA-TR*              BANK_POST_DT       ,                                       
MFA-TR*              DATE_ORIG_PYMT     ,                                       
MFA-TR*              ORIG_PYMT_OFFICE)                                          
MFA-TR*     VALUES (:NH-ACCOUNT-NO         ,                                    
MFA-TR*             :NH-BANK-ID            ,                                    
MFA-TR*             :NH-CHECK-NONUTIL-AMT  ,                                    
MFA-TR*             :NH-CHECK-UTIL-AMT     ,                                    
MFA-TR*             :NH-DATE-TRAN          ,                                    
MFA-TR*             :NH-DRAWN-BY-NM        ,                                    
MFA-TR*             :NH-NSC-REMOVE-FL      ,                                    
MFA-TR*             :NH-NSF-CHARGE-AMT     ,                                    
MFA-TR*             :NH-NSF-ORIG-DT        ,                                    
MFA-TR*             :NH-NSF-REASON-CD      ,                                    
MFA-TR*             :NH-NSF-STATUS-CD      ,                                    
MFA-TR*             :NH-NSF-TIMESTMP       ,                                    
MFA-TR*             :NH-NSF-TYPE-CD        ,                                    
MFA-TR*             :NH-RETURN-CHECK-AMT   ,                                    
MFA-TR*             :NH-WAIVER-REASON-CD   ,                                    
MFA-TR*             :NH-TRANS-HIST-SEQ-NO  ,                                    
MFA-TR*             :NH-SEND-NOTICE-CD     ,                                    
MFA-TR*             :NH-COMMENTS           ,                                    
MFA-TR*             :NH-NON-CIS-ACCT-NO    ,                                    
MFA-TR*             :NH-NON-CIS-GL-ACCT    ,                                    
MFA-TR*             :NH-PAYMENT-TYPE-TX    ,                                    
MFA-TR*             :NH-PARTIAL-PYMT-FL    ,                                    
MFA-TR*             :NH-BANK-POST-DT       ,                                    
MFA-TR*             :NH-DATE-ORIG-PYMT     ,                                    
MFA-TR*             :NH-ORIG-PYMT-OFFICE)                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
REARCH        MOVE 'CSR02189'           TO ABEND-PROGRAM                
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_NSF_HIST'       TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'NSF_TIMESTMP'       TO TABLE-ELEMENT-2              
CBSI          MOVE 'BANK_ID'            TO TABLE-ELEMENT-3              
CBSI          MOVE 'DATE_TRAN'          TO TABLE-ELEMENT-4              
              MOVE NH-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE NH-NSF-TIMESTMP      TO HOSTVAR-ELEMENT-2            
CBSI          MOVE NH-BANK-ID           TO HOSTVAR-ELEMENT-3            
CBSI          MOVE NH-DATE-TRAN         TO HOSTVAR-ELEMENT-4            
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * UPDATE RECORD IN CSS_NSF_HIST FOR RETURNED CHECKS.          *           
      ***************************************************************           
       8170-UPDATE-CSS-NSF-HIST.                                        
                                                                        
           MOVE '8170' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
              UPDATE CSS_NSF_HIST                                       
                 SET BANK_ID            = :NH-BANK-ID,                  
                     CHECK_NONUTIL_AMT  = :NH-CHECK-NONUTIL-AMT,        
                     CHECK_UTIL_AMT     = :NH-CHECK-UTIL-AMT,           
                     DATE_TRAN          = IIF(TRY_CONVERT(DATE, 
                                                          :NH-DATE-TRAN
              ) IS NULL OR (PATINDEX('%.%', :NH-DATE-TRAN
              ) <> 0) OR (LEN(:NH-DATE-TRAN) <> 10), CIS.CHAR2DATE(
                                                          :NH-DATE-TRAN
              ), CONVERT(DATE, :NH-DATE-TRAN) ),                
                     DRAWN_BY_NM        = :NH-DRAWN-BY-NM,              
                     NSC_REMOVE_FL      = :NH-NSC-REMOVE-FL,            
                     NSF_CHARGE_AMT     = :NH-NSF-CHARGE-AMT,           
                     NSF_ORIG_DT        = IIF(TRY_CONVERT(DATE, 
                                                        :NH-NSF-ORIG-DT
              ) IS NULL OR (PATINDEX('%.%', :NH-NSF-ORIG-DT
              ) <> 0) OR (LEN(:NH-NSF-ORIG-DT) <> 10), CIS.CHAR2DATE(
                                                        :NH-NSF-ORIG-DT
              ), CONVERT(DATE, :NH-NSF-ORIG-DT) ),              
                     NSF_REASON_CD      = :NH-NSF-REASON-CD,            
                     NSF_STATUS_CD      = :NH-NSF-STATUS-CD,            
                     NSF_TYPE_CD        = :NH-NSF-TYPE-CD,              
                     RETURN_CHECK_AMT   = :NH-RETURN-CHECK-AMT,         
                     WAIVER_REASON_CD   = :NH-WAIVER-REASON-CD,         
                     TRANS_HIST_SEQ_NO  = CIS.CHAR2TIMESTAMP(
                                                  :NH-TRANS-HIST-SEQ-NO
              ),        
T25923               BANK_POST_DT       = IIF(TRY_CONVERT(DATE, 
                                                       :NH-BANK-POST-DT
              ) IS NULL OR (PATINDEX('%.%', :NH-BANK-POST-DT
              ) <> 0) OR (LEN(:NH-BANK-POST-DT) <> 10), CIS.CHAR2DATE(
                                                       :NH-BANK-POST-DT
              ), CONVERT(DATE, :NH-BANK-POST-DT) ),             
T25923               DATE_ORIG_PYMT     = IIF(TRY_CONVERT(DATE, 
                                                     :NH-DATE-ORIG-PYMT
              ) IS NULL OR (PATINDEX('%.%', :NH-DATE-ORIG-PYMT
              ) <> 0) OR (LEN(:NH-DATE-ORIG-PYMT
              ) <> 10), CIS.CHAR2DATE(:NH-DATE-ORIG-PYMT
              ), CONVERT(DATE, :NH-DATE-ORIG-PYMT) ),           
T25923               ORIG_PYMT_OFFICE   = :NH-ORIG-PYMT-OFFICE,         
T25923               PARTIAL_PYMT_FL    = :NH-PARTIAL-PYMT-FL           
C26296              ,SEND_NOTICE_CD     = :NH-SEND-NOTICE-CD            
               WHERE ACCOUNT_NO         = :NH-ACCOUNT-NO                
                 AND NSF_TIMESTMP       = CIS.CHAR2TIMESTAMP(
                                                       :NH-NSF-TIMESTMP
              )              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_NSF_HIST                                               
MFA-TR*          SET BANK_ID            = :NH-BANK-ID,                          
MFA-TR*              CHECK_NONUTIL_AMT  = :NH-CHECK-NONUTIL-AMT,                
MFA-TR*              CHECK_UTIL_AMT     = :NH-CHECK-UTIL-AMT,                   
MFA-TR*              DATE_TRAN          = :NH-DATE-TRAN,                        
MFA-TR*              DRAWN_BY_NM        = :NH-DRAWN-BY-NM,                      
MFA-TR*              NSC_REMOVE_FL      = :NH-NSC-REMOVE-FL,                    
MFA-TR*              NSF_CHARGE_AMT     = :NH-NSF-CHARGE-AMT,                   
MFA-TR*              NSF_ORIG_DT        = :NH-NSF-ORIG-DT,                      
MFA-TR*              NSF_REASON_CD      = :NH-NSF-REASON-CD,                    
MFA-TR*              NSF_STATUS_CD      = :NH-NSF-STATUS-CD,                    
MFA-TR*              NSF_TYPE_CD        = :NH-NSF-TYPE-CD,                      
MFA-TR*              RETURN_CHECK_AMT   = :NH-RETURN-CHECK-AMT,                 
MFA-TR*              WAIVER_REASON_CD   = :NH-WAIVER-REASON-CD,                 
MFA-TR*              TRANS_HIST_SEQ_NO  = :NH-TRANS-HIST-SEQ-NO,                
MFA-TR*              BANK_POST_DT       = :NH-BANK-POST-DT,                     
MFA-TR*              DATE_ORIG_PYMT     = :NH-DATE-ORIG-PYMT,                   
MFA-TR*              ORIG_PYMT_OFFICE   = :NH-ORIG-PYMT-OFFICE,                 
MFA-TR*              PARTIAL_PYMT_FL    = :NH-PARTIAL-PYMT-FL                   
MFA-TR*             ,SEND_NOTICE_CD     = :NH-SEND-NOTICE-CD                    
MFA-TR*        WHERE ACCOUNT_NO         = :NH-ACCOUNT-NO                        
MFA-TR*          AND NSF_TIMESTMP       = :NH-NSF-TIMESTMP                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
T19504        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND AND              
T19504           AT-ACCT-XFER-FROM-LST > 0                              
T19504           PERFORM 8150-INSERT-CSS-NSF-HIST THRU 8150-EXIT        
T19504        ELSE                                                      
                 MOVE SPACES               TO ABEND-TABLES              
                 MOVE SPACES               TO ABEND-SQL-PREDICATES      
REARCH           MOVE 'CSR02189'           TO ABEND-PROGRAM             
                 MOVE 'UPDATE'             TO ABEND-FUNCTION            
                 MOVE 'CSS_NSF_HIST'       TO TABLE-1                   
                 MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1           
CBSI             MOVE 'DATE_TRAN'          TO TABLE-ELEMENT-2           
CBSI             MOVE 'CHECK_UTIL_AMT'     TO TABLE-ELEMENT-3           
CBSI             MOVE 'RETURN_CHECK_AMT'   TO TABLE-ELEMENT-4           
                 MOVE NH-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1         
CBSI             MOVE NH-DATE-TRAN         TO HOSTVAR-ELEMENT-2         
CBSI             MOVE NH-CHECK-UTIL-AMT    TO HOSTVAR-ELEMENT-3-N       
CBSI             MOVE NH-RETURN-CHECK-AMT  TO HOSTVAR-ELEMENT-4-N       
PCR361           PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT         
T19504        END-IF                                                    
           END-IF.                                                      
                                                                        
       8170-EXIT.                                                       
           EXIT.                                                        
PCR136                                                                  
PCR136***************************************************************           
PCR136* 8180-UPDATE-NSF-SEND-NOTICE.                                *           
PCR136***************************************************************           
PCR136 8180-UPDATE-NSF-SEND-NOTICE.                                     
PCR136                                                                  
PCR136     EXEC SQL                                                     
PCR136        UPDATE CSS_NSF_HIST                                       
PCR136           SET SEND_NOTICE_CD   = :NH-SEND-NOTICE-CD              
PCR136         WHERE ACCOUNT_NO    = :NH-ACCOUNT-NO                     
PRC136           AND NSF_TIMESTMP  = CIS.CHAR2TIMESTAMP(:NH-NSF-TIMESTMP
              )                   
PCR136     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_NSF_HIST                                               
MFA-TR*          SET SEND_NOTICE_CD   = :NH-SEND-NOTICE-CD                      
MFA-TR*        WHERE ACCOUNT_NO    = :NH-ACCOUNT-NO                             
MFA-TR*          AND NSF_TIMESTMP  = :NH-NSF-TIMESTMP                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PCR136                                                                  
PCR136     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
PCR136                                                                  
PCR136     IF WS-ACTIVE-RETURN-CODE = (SUCCESSFUL-CALL OR NOT-FOUND)    
PCR136        NEXT SENTENCE                                             
PCR136     ELSE                                                         
PCR136        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
PCR136        MOVE '8180'               TO ACTIVE-PARAGRAPH             
PCR136        MOVE 'UPDATE'             TO ABEND-FUNCTION               
PCR136        MOVE 'CSS_NSF_HIST'       TO TABLE-1                      
PCR136        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'SEND_NOTICE_CD'     TO TABLE-ELEMENT-2              
PCR136        MOVE NH-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE NH-SEND-NOTICE-CD    TO HOSTVAR-ELEMENT-2            
PCR136        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
PCR136     END-IF.                                                      
PCR136                                                                  
PCR136 8180-EXIT.                                                       
PCR136     EXIT.                                                        
PCR136                                                                  
C26296***************************************************************           
C26296* 8190-UPDATE-NSF-DEP-CERT-NO.                                *           
C26296***************************************************************           
C26296 8190-UPDATE-NSF-DEP-CERT-NO.                                     
C26296                                                                  
C26296     EXEC SQL                                                     
C26296        UPDATE CSS_NSF_HIST                                       
C26296           SET DEPOSIT_CERT_NO = :NH-DEPOSIT-CERT-NO              
C26296         WHERE ACCOUNT_NO      = :NH-ACCOUNT-NO                   
C26296           AND NSF_TIMESTMP    = CIS.CHAR2TIMESTAMP(
                                                       :NH-NSF-TIMESTMP
              )                 
C26296     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_NSF_HIST                                               
MFA-TR*          SET DEPOSIT_CERT_NO = :NH-DEPOSIT-CERT-NO                      
MFA-TR*        WHERE ACCOUNT_NO      = :NH-ACCOUNT-NO                           
MFA-TR*          AND NSF_TIMESTMP    = :NH-NSF-TIMESTMP                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26296                                                                  
C26296     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C26296                                                                  
C26296     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
C26296         NEXT SENTENCE                                            
C26296     ELSE                                                         
C26296         MOVE PROGRAM-NAME        TO ABEND-PROGRAM                
C26296         MOVE '8190'              TO ACTIVE-PARAGRAPH             
C26296         MOVE 'UPDATE'            TO ABEND-FUNCTION               
C26296         MOVE 'CSS_NSF_HIST'      TO TABLE-1                      
C26296         MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1              
C26296         MOVE 'DEP_CERT_NO'       TO TABLE-ELEMENT-2              
C26296         MOVE 'NSF_TIMESTMP'      TO TABLE-ELEMENT-3              
C26296         MOVE NH-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1            
C26296         MOVE NH-DEPOSIT-CERT-NO  TO HOSTVAR-ELEMENT-2            
C26296         MOVE NH-NSF-TIMESTMP     TO HOSTVAR-ELEMENT-2            
C26296         PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT            
C26296     END-IF.                                                      
C26296                                                                  
C26296 8190-EXIT.                                                       
C26296     EXIT.                                                        
C26296                                                                  
PCR136***************************************************************           
PCR136* 8200-UPDATE-CREDIT-PROFILE.                                 *           
PCR136***************************************************************           
PCR136 8200-UPDATE-CREDIT-PROFILE.                                      
PCR136                                                                  
PCR136     EXEC SQL                                                     
PCR136        UPDATE CSS_CREDIT_PROFILE                                 
PCR136           SET DISC_EXCEPTN_HIST = :CZ-DISC-EXCEPTN-HIST,         
PCR136               LAST_UPDATE_TS    = CIS.CURRENT$TIMESTAMP()              
PCR136         WHERE ACCOUNT_NO     = :CZ-ACCOUNT-NO                    
PCR136     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CREDIT_PROFILE                                         
MFA-TR*          SET DISC_EXCEPTN_HIST = :CZ-DISC-EXCEPTN-HIST,                 
MFA-TR*              LAST_UPDATE_TS    = CURRENT TIMESTAMP                      
MFA-TR*        WHERE ACCOUNT_NO     = :CZ-ACCOUNT-NO                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PCR136                                                                  
PCR136     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
PCR136                                                                  
PCR136     IF WS-ACTIVE-RETURN-CODE = (SUCCESSFUL-CALL OR NOT-FOUND)    
PCR136        NEXT SENTENCE                                             
PCR136     ELSE                                                         
PCR136        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
PCR136        MOVE '8200'               TO ACTIVE-PARAGRAPH             
PCR136        MOVE 'UPDATE'             TO ABEND-FUNCTION               
PCR136        MOVE 'CSS_CREDIT_PROFILE' TO TABLE-1                      
PCR136        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'DISC_EXCEPTN_HIST'  TO TABLE-ELEMENT-2              
PCR136        MOVE CZ-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE CZ-DISC-EXCEPTN-HIST TO HOSTVAR-ELEMENT-2            
PCR136        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
PCR136     END-IF.                                                      
PCR136                                                                  
PCR136 8200-EXIT.                                                       
PCR136     EXIT.                                                        
PCR136                                                                  
      ***************************************************************           
      * 8300-UPDATE-SUMM-CSS-AR-CNTRL                               *           
      ***************************************************************           
       8300-UPDATE-SUMM-CSS-AR-CNTRL.                                   
                                                                        
           MOVE '8300' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
                UPDATE CSS_AR_CNTL                                      
                   SET AMT_AR_DAY_00      = :AC-AMT-AR-DAY-00,          
                       AMT_AR_DAY_30      = :AC-AMT-AR-DAY-30,          
                       AMT_AR_DAY_60      = :AC-AMT-AR-DAY-60,          
                       AMT_AR_DAY_90      = :AC-AMT-AR-DAY-90,          
                       AMT_UNUSED_CR      = :AC-AMT-UNUSED-CR,          
                       TOT_SUMM_UNBILLED  = :AC-TOT-SUMM-UNBILLED       
                 WHERE ACCOUNT_NO         = :AC-ACCOUNT-NO              
                   AND PYMT_PRIORITY_LVL  = :AC-PYMT-PRIORITY-LVL       
                   AND ITEM_ID            = :AC-ITEM-ID                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
REARCH        MOVE 'CSR02189'           TO ABEND-PROGRAM                
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_AR_CNTL'        TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'PYMT_PRIORITY_LVL'  TO TABLE-ELEMENT-2              
              MOVE 'ITEM_ID'            TO TABLE-ELEMENT-3              
CBSI          MOVE 'TOT_SUMM_UNBILLED'  TO TABLE-ELEMENT-4              
              MOVE AC-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE AC-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-2            
              MOVE AC-ITEM-ID           TO HOSTVAR-ELEMENT-3            
CBSI          MOVE AC-TOT-SUMM-UNBILLED TO HOSTVAR-ELEMENT-4-N          
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
C25923******************************************************************        
C25923**  8325-CREATE-CASH-REPORT                                     **        
C25923**                                                              **        
C25923******************************************************************        
C25923 8325-CREATE-CASH-REPORT.                                         
C25923     MOVE '8325'                   TO WS-ACTIVE-PARAGRAPH.        
C25923                                                                  
C25923     EXEC SQL                                                     
C25923       INSERT INTO CSS_CSH_REPORT_HDR                             
C25923              ( CASH_COMPANY_NO,                                  
C25923                CASH_LOCAL_OFFICE,                                
C25923                DATE_CASH_REPORT,                                 
C25923                USER_ID,                                          
C25923                STATUS,                                           
C25923                CLOSED_TS)                                        
C25923       VALUES ( :YR-CASH-COMPANY-NO                               
C25923               ,:YR-CASH-LOCAL-OFFICE                             
C25923               ,IIF(TRY_CONVERT(DATE, :YR-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YR-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YR-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YR-DATE-CASH-REPORT
              ), CONVERT(DATE, :YR-DATE-CASH-REPORT) )                         
C25923               ,:YR-USER-ID                                       
C25923               ,:YR-STATUS                                        
C25923               ,CIS.CHAR2TIMESTAMP(:YR-CLOSED-TS))                        
C25923     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_CSH_REPORT_HDR                                     
MFA-TR*             ( CASH_COMPANY_NO,                                          
MFA-TR*               CASH_LOCAL_OFFICE,                                        
MFA-TR*               DATE_CASH_REPORT,                                         
MFA-TR*               USER_ID,                                                  
MFA-TR*               STATUS,                                                   
MFA-TR*               CLOSED_TS)                                                
MFA-TR*      VALUES ( :YR-CASH-COMPANY-NO                                       
MFA-TR*              ,:YR-CASH-LOCAL-OFFICE                                     
MFA-TR*              ,:YR-DATE-CASH-REPORT                                      
MFA-TR*              ,:YR-USER-ID                                               
MFA-TR*              ,:YR-STATUS                                                
MFA-TR*              ,:YR-CLOSED-TS)                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C25923                                                                  
C25923     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
C25923                                                                  
C25923     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C25923        NEXT SENTENCE                                             
C25923     ELSE                                                         
C25923        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C25923        MOVE '8325'                TO ACTIVE-PARAGRAPH            
C25923        MOVE 'INSERT'              TO ABEND-FUNCTION              
C25923        MOVE 'CSS_CSH_REPORT_HDR'  TO TABLE-1                     
C25923        MOVE 'CASH COMPANY NO'     TO TABLE-ELEMENT-1             
C25923        MOVE 'CASH LOCAL OFFICE'   TO TABLE-ELEMENT-2             
C25923        MOVE 'DATE CASH REPORT'    TO TABLE-ELEMENT-3             
C25923        MOVE YR-CASH-COMPANY-NO    TO HOSTVAR-ELEMENT-1           
C25923        MOVE YR-CASH-LOCAL-OFFICE  TO HOSTVAR-ELEMENT-2           
C25923        MOVE YR-DATE-CASH-REPORT   TO HOSTVAR-ELEMENT-3           
C25923        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
C25923     END-IF.                                                      
C25923                                                                  
C25923 8325-EXIT.                                                       
C25923     EXIT.                                                        
                                                                        
      ****************************************************************          
      * SET CASH ONLY FLAG FOR ACCOUNT                               *          
      ****************************************************************          
       8350-UPDATE-CASH-ONLY.                                           
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_CREDIT_PROFILE                                
                  SET CASH_ONLY_FL       = :CZ-CASH-ONLY-FL,            
                      CSH_ONLY_EFFECT_DT = IIF(TRY_CONVERT(DATE, 
                                                 :CZ-CSH-ONLY-EFFECT-DT
              ) IS NULL OR (PATINDEX('%.%', :CZ-CSH-ONLY-EFFECT-DT
              ) <> 0) OR (LEN(:CZ-CSH-ONLY-EFFECT-DT
              ) <> 10), CIS.CHAR2DATE(:CZ-CSH-ONLY-EFFECT-DT
              ), CONVERT(DATE, :CZ-CSH-ONLY-EFFECT-DT) ),      
C35824                CASH_ONLY_COMMENTS = :CZ-CASH-ONLY-COMMENTS,      
PCR263                LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()            
                WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_CREDIT_PROFILE                                        
MFA-TR*           SET CASH_ONLY_FL       = :CZ-CASH-ONLY-FL,                    
MFA-TR*               CSH_ONLY_EFFECT_DT = :CZ-CSH-ONLY-EFFECT-DT,              
MFA-TR*               CASH_ONLY_COMMENTS = :CZ-CASH-ONLY-COMMENTS,              
MFA-TR*               LAST_UPDATE_TS     = CURRENT TIMESTAMP                    
MFA-TR*         WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME    TO ABEND-PROGRAM                    
               MOVE '8350'          TO ACTIVE-PARAGRAPH                 
CBSI           MOVE 'UPDATE'            TO ABEND-FUNCTION               
               MOVE 'CSS_CREDIT_PROFILE'    TO TABLE-1                  
               MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
CBSI           MOVE 'CASH_ONLY_FL'       TO TABLE-ELEMENT-2             
CBSI           MOVE 'CSH_ONLY_EFFECT_DT' TO TABLE-ELEMENT-3             
C35824         MOVE 'CASH_ONLY_COMMENTS' TO TABLE-ELEMENT-4             
               MOVE CZ-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
CBSI           MOVE CZ-CASH-ONLY-FL         TO HOSTVAR-ELEMENT-2        
CBSI           MOVE CZ-CSH-ONLY-EFFECT-DT   TO HOSTVAR-ELEMENT-3        
C35824         MOVE CZ-CASH-ONLY-COMMENTS   TO HOSTVAR-ELEMENT-4        
PCR361         PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       8350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 8400-DELETE-RETURN-CHECK                                     *          
      ****************************************************************          
       8400-DELETE-RETURN-CHECK.                                        
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_RETURN_CHK                               
                WHERE BANK_ID    = :RC-BANK-ID                          
                  AND ENTERED_DT = IIF(TRY_CONVERT(DATE, :RC-ENTERED-DT
              ) IS NULL OR (PATINDEX('%.%', :RC-ENTERED-DT
              ) <> 0) OR (LEN(:RC-ENTERED-DT) <> 10), CIS.CHAR2DATE(
                                                         :RC-ENTERED-DT
              ), CONVERT(DATE, :RC-ENTERED-DT) )                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_RETURN_CHK                                       
MFA-TR*         WHERE BANK_ID    = :RC-BANK-ID                                  
MFA-TR*           AND ENTERED_DT = :RC-ENTERED-DT                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                    OR NOT-FOUND                        
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
REARCH        MOVE 'CSR02189'           TO ABEND-PROGRAM                
CBSI          MOVE '8400'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
CBSI          MOVE 'CSS_RETURN_CHK'     TO TABLE-1                      
              MOVE 'BANK_ID'            TO TABLE-ELEMENT-1              
              MOVE 'ENTERED_DT'         TO TABLE-ELEMENT-2              
CBSI          MOVE 'USER_ID'            TO TABLE-ELEMENT-3              
              MOVE RC-BANK-ID           TO HOSTVAR-ELEMENT-1            
              MOVE RC-ENTERED-DT        TO HOSTVAR-ELEMENT-2            
CBSI          MOVE PARM-USER-ID         TO HOSTVAR-ELEMENT-3            
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
TP5033***************************************************************           
TP5033* 8450-DELETE-CRED-COLL.                                      *           
TP5033***************************************************************           
TP5033 8450-DELETE-CRED-COLL.                                           
TP5033                                                                  
TP5033     EXEC SQL                                                     
TP5033        DELETE FROM CSS_CRED_COLL                                 
TP5033         WHERE ACCOUNT_NO    = :CL-ACCOUNT-NO                     
TP5033           AND CODE_NOTICE_TYPE =:CL-CODE-NOTICE-TYPE            
TP5033           AND ITEM_ID          =  0                              
TP5033     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

TP5033                                                                  
TP5033     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
TP5033                                                                  
TP5033     IF WS-ACTIVE-RETURN-CODE = (SUCCESSFUL-CALL OR NOT-FOUND)    
TP5033        NEXT SENTENCE                                             
TP5033     ELSE                                                         
TP5033        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
TP5033        MOVE '8450'               TO ACTIVE-PARAGRAPH             
TP5033        MOVE 'DELETE'             TO ABEND-FUNCTION               
TP5033        MOVE 'CSS_CRED_COLL'      TO TABLE-1                      
TP5033        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'CODE_NOTICE_TYPE'   TO TABLE-ELEMENT-2              
TP5033        MOVE CL-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE CL-CODE-NOTICE-TYPE  TO HOSTVAR-ELEMENT-2            
TP5033        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
TP5033     END-IF.                                                      
TP5033                                                                  
       8450-EXIT.                                                       
           EXIT.                                                        
                                                                        
TP5033***************************************************************           
TP5033* 8451-DELETE-PREV-N-ROWS.                                    *           
TP5033***************************************************************           
 P5033 8451-DELETE-PREV-N-ROWS.                                         
TP5033                                                                  
TP5033     EXEC SQL                                                     
TP5033        DELETE FROM CSS_CRED_COLL                                 
TP5033         WHERE ACCOUNT_NO    = :CL-ACCOUNT-NO                     
T21963           AND CODE_NOTICE_TYPE IN ('N','V','W')                  
TP5033     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

TP5033                                                                  
TP5033     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
TP5033                                                                  
TP5033     IF WS-ACTIVE-RETURN-CODE = (SUCCESSFUL-CALL OR NOT-FOUND)    
TP5033        NEXT SENTENCE                                             
TP5033     ELSE                                                         
TP5033        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
TP5033        MOVE '8451'               TO ACTIVE-PARAGRAPH             
TP5033        MOVE 'DELETE'             TO ABEND-FUNCTION               
TP5033        MOVE 'CSS_CRED_COLL'      TO TABLE-1                      
TP5033        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
TP5033        MOVE CL-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
TP5033        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
TP5033     END-IF.                                                      
TP5033                                                                  
TP5033 8451-EXIT.                                                       
TP5033     EXIT.                                                        
      ****************************************************************          
      * 8500-INSERT-SUMM-CSS-AR-CNTRL                                *          
      ****************************************************************          
       8500-INSERT-SUMM-CSS-AR-CNTRL.                                   
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_AR_CNTL                                  
                      (ACCOUNT_NO,                                      
                       PYMT_PRIORITY_LVL,                               
                       ITEM_ID,                                         
                       AMT_AR_DAY_00,                                   
                       AMT_AR_DAY_30,                                   
                       AMT_AR_DAY_60,                                   
                       AMT_AR_DAY_90,                                   
                       AMT_UNUSED_CR,                                   
                       AMT_TRAN_BALANCE,                                
                       TOT_SUMM_UNBILLED)                               
               VALUES (:AC-ACCOUNT-NO,                                  
                       :AC-PYMT-PRIORITY-LVL,                           
                       :AC-ITEM-ID,                                     
                       :AC-AMT-AR-DAY-00,                               
                       :AC-AMT-AR-DAY-30,                               
                       :AC-AMT-AR-DAY-60,                               
                       :AC-AMT-AR-DAY-90,                               
                       :AC-AMT-UNUSED-CR,                               
                       :AC-AMT-TRAN-BALANCE,                            
                       :AC-TOT-SUMM-UNBILLED)                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
REARCH        MOVE 'CSR02189'           TO ABEND-PROGRAM                
CBSI          MOVE '8500'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_AR_CNTL'        TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'PYMT_PRIORITY_LVL'  TO TABLE-ELEMENT-2              
              MOVE 'ITEM_ID'            TO TABLE-ELEMENT-3              
CBSI          MOVE 'TOT_SUMM_UNBILLED'  TO TABLE-ELEMENT-4              
              MOVE AC-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE AC-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-2            
              MOVE AC-ITEM-ID           TO HOSTVAR-ELEMENT-3            
CBSI          MOVE AC-TOT-SUMM-UNBILLED TO HOSTVAR-ELEMENT-4-N          
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 8600-INSERT-CSS-CRED-COLL                                    *          
      ****************************************************************          
       8600-INSERT-CSS-CRED-COLL.                                       
                                                                        
           MOVE '8600' TO ACTIVE-PARAGRAPH.                             
PCR263     IF CL-DATE-BILL > SPACES                                     
PCR263        MOVE +0                  TO WS-DT-BILL-NI                 
           ELSE                                                         
PCR263        MOVE -1                  TO WS-DT-BILL-NI                 
           END-IF.                                                      
PCR263     IF CL-DATE-CREDIT-ACTION > SPACES                            
PCR263        MOVE +0                  TO WS-DATE-CRED-NI               
           ELSE                                                         
PCR263        MOVE -1                  TO WS-DATE-CRED-NI               
           END-IF.                                                      
PCR263     IF CL-DATE-NOTICE-DUE > SPACES                               
PCR263        MOVE +0                  TO WS-DATE-DUE-NI                
           ELSE                                                         
PCR263        MOVE -1                  TO WS-DATE-DUE-NI                
           END-IF.                                                      
PCR263     IF CL-DATE-NOTICE-MAIL > SPACES                              
PCR263        MOVE +0                  TO WS-DATE-MAIL-NI               
PCR263     ELSE                                                         
PCR263        MOVE -1                  TO WS-DATE-MAIL-NI               
PCR263     END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_CRED_COLL                                
                      (ACCOUNT_NO,                                      
                       AMT_NOTICE,                                      
                       CODE_FRCST_CR_GRP,                               
                       CODE_MESSAGE_TYPE,                               
                       CODE_NOTICE_TYPE,                                
                       DATE_BILL,                                       
                       DATE_CREDIT_ACTION,                              
                       DATE_NOTICE_DUE,                                 
                       DATE_NOTICE_MAIL,                                
                       ITEM_ID,                                         
PCR263                 CODE_SPECIAL_TYPE,                               
                       LAST_UPDATE_TS)                                  
               VALUES (:CL-ACCOUNT-NO,                                  
                       :CL-AMT-NOTICE,                                  
                       :CL-CODE-FRCST-CR-GRP,                           
                       :CL-CODE-MESSAGE-TYPE,                           
                       :CL-CODE-NOTICE-TYPE,                            
                       IIF(TRY_CONVERT(DATE, :CL-DATE-BILL 
                                             :WS-DT-BILL-NI
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-BILL 
                                                         :WS-DT-BILL-NI
              ) <> 0) OR (LEN(:CL-DATE-BILL :WS-DT-BILL-NI
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-BILL :WS-DT-BILL-NI
              ), CONVERT(DATE, :CL-DATE-BILL :WS-DT-BILL-NI) ),                
PCR263                 IIF(TRY_CONVERT(DATE, :CL-DATE-CREDIT-ACTION 
                                             :WS-DATE-CRED-NI
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-CREDIT-ACTION 
                                                       :WS-DATE-CRED-NI
              ) <> 0) OR (LEN(:CL-DATE-CREDIT-ACTION :WS-DATE-CRED-NI
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-CREDIT-ACTION 
                                                       :WS-DATE-CRED-NI
              ), CONVERT(DATE, :CL-DATE-CREDIT-ACTION :WS-DATE-CRED-NI
              ) ),          
PCR263                 IIF(TRY_CONVERT(DATE, :CL-DATE-NOTICE-DUE 
                                             :WS-DATE-DUE-NI
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-NOTICE-DUE 
                                                        :WS-DATE-DUE-NI
              ) <> 0) OR (LEN(:CL-DATE-NOTICE-DUE :WS-DATE-DUE-NI
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-NOTICE-DUE 
                                                        :WS-DATE-DUE-NI
              ), CONVERT(DATE, :CL-DATE-NOTICE-DUE :WS-DATE-DUE-NI) ),         
PCR263                 IIF(TRY_CONVERT(DATE, :CL-DATE-NOTICE-MAIL 
                                             :WS-DATE-MAIL-NI
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-NOTICE-MAIL 
                                                       :WS-DATE-MAIL-NI
              ) <> 0) OR (LEN(:CL-DATE-NOTICE-MAIL :WS-DATE-MAIL-NI
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-NOTICE-MAIL 
                                                       :WS-DATE-MAIL-NI
              ), CONVERT(DATE, :CL-DATE-NOTICE-MAIL :WS-DATE-MAIL-NI
              ) ),            
                       :CL-ITEM-ID,                                     
PCR263                 :CL-CODE-SPECIAL-TYPE,                           
PCR263                 CIS.CURRENT$TIMESTAMP())                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_CRED_COLL                                        
MFA-TR*               (ACCOUNT_NO,                                              
MFA-TR*                AMT_NOTICE,                                              
MFA-TR*                CODE_FRCST_CR_GRP,                                       
MFA-TR*                CODE_MESSAGE_TYPE,                                       
MFA-TR*                CODE_NOTICE_TYPE,                                        
MFA-TR*                DATE_BILL,                                               
MFA-TR*                DATE_CREDIT_ACTION,                                      
MFA-TR*                DATE_NOTICE_DUE,                                         
MFA-TR*                DATE_NOTICE_MAIL,                                        
MFA-TR*                ITEM_ID,                                                 
MFA-TR*                CODE_SPECIAL_TYPE,                                       
MFA-TR*                LAST_UPDATE_TS)                                          
MFA-TR*        VALUES (:CL-ACCOUNT-NO,                                          
MFA-TR*                :CL-AMT-NOTICE,                                          
MFA-TR*                :CL-CODE-FRCST-CR-GRP,                                   
MFA-TR*                :CL-CODE-MESSAGE-TYPE,                                   
MFA-TR*                :CL-CODE-NOTICE-TYPE,                                    
MFA-TR*                :CL-DATE-BILL:WS-DT-BILL-NI,                             
MFA-TR*                :CL-DATE-CREDIT-ACTION:WS-DATE-CRED-NI,                  
MFA-TR*                :CL-DATE-NOTICE-DUE:WS-DATE-DUE-NI,                      
MFA-TR*                :CL-DATE-NOTICE-MAIL:WS-DATE-MAIL-NI,                    
MFA-TR*                :CL-ITEM-ID,                                             
MFA-TR*                :CL-CODE-SPECIAL-TYPE,                                   
MFA-TR*                CURRENT TIMESTAMP)                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
REARCH        MOVE 'CSR02189'           TO ABEND-PROGRAM                
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_CRED_COLL'      TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'DATE_BILL'          TO TABLE-ELEMENT-2              
CBSI          MOVE 'DATE_CREDIT_ACTION' TO TABLE-ELEMENT-3              
CBSI          MOVE 'DATE_NOTICE_DUE'    TO TABLE-ELEMENT-4              
              MOVE BE-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE CL-DATE-BILL         TO HOSTVAR-ELEMENT-2            
CBSI          MOVE CL-DATE-CREDIT-ACTION TO HOSTVAR-ELEMENT-3           
CBSI          MOVE CL-DATE-NOTICE-DUE   TO HOSTVAR-ELEMENT-4            
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 8660-UPDATE-SUM-ROW.                                         *          
      ****************************************************************          
       8660-UPDATE-SUM-ROW.                                             
                                                                        
           MOVE '8660' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
               UPDATE CSS_CRED_COLL                                     
TP5033            SET AMT_NOTICE         = :CL-AMT-NOTICE,              
TP5033                CODE_MESSAGE_TYPE  = :CL-CODE-MESSAGE-TYPE,       
TP5033                LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()            
                WHERE ACCOUNT_NO         = :CL-ACCOUNT-NO               
                  AND ITEM_ID            = 0                            
                  AND CODE_NOTICE_TYPE   = :CL-CODE-NOTICE-TYPE         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_CRED_COLL                                             
MFA-TR*           SET AMT_NOTICE         = :CL-AMT-NOTICE,                      
MFA-TR*               CODE_MESSAGE_TYPE  = :CL-CODE-MESSAGE-TYPE,               
MFA-TR*               LAST_UPDATE_TS     = CURRENT TIMESTAMP                    
MFA-TR*         WHERE ACCOUNT_NO         = :CL-ACCOUNT-NO                       
MFA-TR*           AND ITEM_ID            = 0                                    
MFA-TR*           AND CODE_NOTICE_TYPE   = :CL-CODE-NOTICE-TYPE                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
REARCH        MOVE 'CSR02189'           TO ABEND-PROGRAM                
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_CRED_COLL'      TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'ITEM_ID'            TO TABLE-ELEMENT-2              
              MOVE 'CODE_NOTICE_TYPE'   TO TABLE-ELEMENT-3              
CBSI          MOVE 'AMT_NOTICE'         TO TABLE-ELEMENT-4              
              MOVE CL-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE CL-ITEM-ID           TO HOSTVAR-ELEMENT-2            
              MOVE CL-CODE-NOTICE-TYPE  TO HOSTVAR-ELEMENT-3            
CBSI          MOVE CL-AMT-NOTICE        TO HOSTVAR-ELEMENT-4-N          
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8660-EXIT.                                                       
           EXIT.                                                        
T32545****************************************************************          
T32545*                                                              *          
T32545* 8662-UPDATE-CRED-COLL                                        *          
T32545****************************************************************          
T32545 8662-UPDATE-CRED-COLL.                                           
T32545*                                                                         
T32545     EXEC SQL                                                     
T32545         UPDATE CSS_CRED_COLL                                     
T32545            SET DATE_CREDIT_ACTION = IIF(TRY_CONVERT(DATE, 
                                                :CL-DATE-CREDIT-ACTION 
                                              :WS-DATE-CRED-ACTION-NULL
              ) IS NULL OR (PATINDEX('%.%', :CL-DATE-CREDIT-ACTION 
                                              :WS-DATE-CRED-ACTION-NULL
              ) <> 0) OR (LEN(:CL-DATE-CREDIT-ACTION 
                                              :WS-DATE-CRED-ACTION-NULL
              ) <> 10), CIS.CHAR2DATE(:CL-DATE-CREDIT-ACTION 
                                              :WS-DATE-CRED-ACTION-NULL
              ), CONVERT(DATE, :CL-DATE-CREDIT-ACTION 
                                              :WS-DATE-CRED-ACTION-NULL
              ) ),   
P00471                LAST_UPDATE_TS     = CIS.CURRENT$TIMESTAMP()            
T32545          WHERE ACCOUNT_NO         = :CL-ACCOUNT-NO               
T32545            AND ITEM_ID            = 0                            
T32545            AND CODE_NOTICE_TYPE   = :CL-CODE-NOTICE-TYPE         
T32545     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_CRED_COLL                                             
MFA-TR*           SET DATE_CREDIT_ACTION = :CL-DATE-CREDIT-ACTION               
MFA-TR*                                    :WS-DATE-CRED-ACTION-NULL,           
MFA-TR*               LAST_UPDATE_TS     = CURRENT TIMESTAMP                    
MFA-TR*         WHERE ACCOUNT_NO         = :CL-ACCOUNT-NO                       
MFA-TR*           AND ITEM_ID            = 0                                    
MFA-TR*           AND CODE_NOTICE_TYPE   = :CL-CODE-NOTICE-TYPE                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T32545                                                                  
T32545     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
T32545                                                                  
T32545     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T32545        NEXT SENTENCE                                             
T32545     ELSE                                                         
T32545        MOVE SPACES               TO ABEND-TABLES                 
T32545        MOVE SPACES               TO ABEND-SQL-PREDICATES         
T32545        MOVE 'CSR02189'           TO ABEND-PROGRAM                
T32545        MOVE 'UPDATE'             TO ABEND-FUNCTION               
T32545        MOVE 'CSS_CRED_COLL'      TO TABLE-1                      
T32545        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
T32545        MOVE 'ITEM_ID'            TO TABLE-ELEMENT-2              
T32545        MOVE 'CODE_NOTICE_TYPE'   TO TABLE-ELEMENT-3              
P00471        MOVE 'DATE_CREDIT_ACTION' TO TABLE-ELEMENT-4              
T32545        MOVE CL-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
T32545        MOVE CL-ITEM-ID           TO HOSTVAR-ELEMENT-2            
T32545        MOVE CL-CODE-NOTICE-TYPE  TO HOSTVAR-ELEMENT-3            
P00471        MOVE CL-DATE-CREDIT-ACTION TO HOSTVAR-ELEMENT-4-N         
T32545        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
T32545     END-IF.                                                      
T32545                                                                  
T32545 8662-EXIT.                                                       
T32545     EXIT.                                                        
                                                                        
      ***************************************************************           
      * 8700-UPDATE-BANK-EFT                                        *           
      ***************************************************************           
       8700-UPDATE-BANK-EFT.                                            
                                                                        
           MOVE '8700' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
              UPDATE CSS_BANK_EFT                                       
                 SET STATUS_CODE        = :BE-STATUS-CODE,              
                     STATUS_CHANGE_DT   = IIF(TRY_CONVERT(DATE, 
                                                   :BE-STATUS-CHANGE-DT
              ) IS NULL OR (PATINDEX('%.%', :BE-STATUS-CHANGE-DT
              ) <> 0) OR (LEN(:BE-STATUS-CHANGE-DT
              ) <> 10), CIS.CHAR2DATE(:BE-STATUS-CHANGE-DT
              ), CONVERT(DATE, :BE-STATUS-CHANGE-DT) )          
               WHERE ACCOUNT_NO         = :BE-ACCOUNT-NO                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_BANK_EFT                                               
MFA-TR*          SET STATUS_CODE        = :BE-STATUS-CODE,                      
MFA-TR*              STATUS_CHANGE_DT   = :BE-STATUS-CHANGE-DT                  
MFA-TR*        WHERE ACCOUNT_NO         = :BE-ACCOUNT-NO                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                    OR NOT-FOUND                        
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
REARCH        MOVE 'CSR02189'           TO ABEND-PROGRAM                
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_BANK_EFT'       TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'STATUS_CODE'        TO TABLE-ELEMENT-2              
CBSI          MOVE 'STATUS_CHANGE_DT'   TO TABLE-ELEMENT-3              
              MOVE BE-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE BE-STATUS-CODE       TO HOSTVAR-ELEMENT-2            
CBSI          MOVE BE-STATUS-CHANGE-DT  TO HOSTVAR-ELEMENT-3            
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8700-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00599***************************************************************           
P00599* 8750-INSERT-FIN-WO-ACTION                                   *           
P00599***************************************************************           
P00599 8750-INSERT-FIN-WO-ACTION.                                       
P00599                                                                  
P00599     MOVE '8750' TO ACTIVE-PARAGRAPH.                             
P00599     EXEC SQL                                                     
P00599        INSERT INTO CSS_FIN_WO_ACTION                             
P00599               (ACCOUNT_NO                                        
P00599               ,FW_SEQ_NO                                         
P00599               ,FW_ACTION_TYPE_CD                                 
P00599               ,FW_ACTION_DT                                      
P00599               ,FW_ACTION_AM                                      
P00599               ,FW_MANUAL_FL                                      
P00599               ,FW_ACTION_COMMENTS                                
P00599               ,FW_BUS_PROCESS_CD                                 
P00599               ,FW_PROCESSED_FL)                                  
P00599        VALUES                                                    
P00599               (:KD-ACCOUNT-NO                                    
P00599               ,:KD-FW-SEQ-NO                                     
P00599               ,:KD-FW-ACTION-TYPE-CD                             
P00599               ,IIF(TRY_CONVERT(DATE, :KD-FW-ACTION-DT
              ) IS NULL OR (PATINDEX('%.%', :KD-FW-ACTION-DT
              ) <> 0) OR (LEN(:KD-FW-ACTION-DT) <> 10), CIS.CHAR2DATE(
                                                       :KD-FW-ACTION-DT
              ), CONVERT(DATE, :KD-FW-ACTION-DT) )                             
P00599               ,:KD-FW-ACTION-AM                                  
P00599               ,:KD-FW-MANUAL-FL                                  
P00599               ,:KD-FW-ACTION-COMMENTS                            
P00599               ,:KD-FW-BUS-PROCESS-CD                             
P00599               ,:KD-FW-PROCESSED-FL)                              
P00599     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_FIN_WO_ACTION                                     
MFA-TR*              (ACCOUNT_NO                                                
MFA-TR*              ,FW_SEQ_NO                                                 
MFA-TR*              ,FW_ACTION_TYPE_CD                                         
MFA-TR*              ,FW_ACTION_DT                                              
MFA-TR*              ,FW_ACTION_AM                                              
MFA-TR*              ,FW_MANUAL_FL                                              
MFA-TR*              ,FW_ACTION_COMMENTS                                        
MFA-TR*              ,FW_BUS_PROCESS_CD                                         
MFA-TR*              ,FW_PROCESSED_FL)                                          
MFA-TR*       VALUES                                                            
MFA-TR*              (:KD-ACCOUNT-NO                                            
MFA-TR*              ,:KD-FW-SEQ-NO                                             
MFA-TR*              ,:KD-FW-ACTION-TYPE-CD                                     
MFA-TR*              ,:KD-FW-ACTION-DT                                          
MFA-TR*              ,:KD-FW-ACTION-AM                                          
MFA-TR*              ,:KD-FW-MANUAL-FL                                          
MFA-TR*              ,:KD-FW-ACTION-COMMENTS                                    
MFA-TR*              ,:KD-FW-BUS-PROCESS-CD                                     
MFA-TR*              ,:KD-FW-PROCESSED-FL)                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00599                                                                  
P00599     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00599     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00599        NEXT SENTENCE                                             
P00599     ELSE                                                         
P00599        MOVE SPACES               TO ABEND-TABLES                 
P00599        MOVE SPACES               TO ABEND-SQL-PREDICATES         
P00599        MOVE 'CSR02189'           TO ABEND-PROGRAM                
P00599        MOVE 'INSERT'             TO ABEND-FUNCTION               
P00599        MOVE 'CSS_FIN_WO_ACTION'  TO TABLE-1                      
P00599        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
P00599        MOVE 'FW_SEQ_NO'          TO TABLE-ELEMENT-2              
P00599        MOVE 'FW_ACTION_TYPE_CD'  TO TABLE-ELEMENT-3              
P00599        MOVE KD-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
P00599        MOVE KD-FW-SEQ-NO         TO HOSTVAR-ELEMENT-2            
P00599        MOVE KD-FW-ACTION-TYPE-CD TO HOSTVAR-ELEMENT-3            
P00599        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
P00599     END-IF.                                                      
P00599                                                                  
P00599 8750-EXIT.                                                       
P00599     EXIT.                                                        
P00599                                                                  
      ***************************************************************           
      * 8800-UPDATE-AR-HEADER                                       *           
      ***************************************************************           
       8800-UPDATE-AR-HEADER.                                           
                                                                        
           MOVE '8800' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
              UPDATE CSS_AR_TRANS_HIST                                  
                 SET PYMT_REFUNDED_IND  = 'Y'                           
               WHERE ACCOUNT_NO         = :AR-ACCOUNT-NO                
                 AND TRANS_HIST_SEQ_NO  = CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_AR_TRANS_HIST                                          
MFA-TR*          SET PYMT_REFUNDED_IND  = 'Y'                                   
MFA-TR*        WHERE ACCOUNT_NO         = :AR-ACCOUNT-NO                        
MFA-TR*          AND TRANS_HIST_SEQ_NO  = :AR-TRANS-HIST-SEQ-NO                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                    OR NOT-FOUND                        
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
REARCH        MOVE 'CSR02189'           TO ABEND-PROGRAM                
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_AR_TRANS_HIST'  TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'TRANS_HIST_SEQ_NO'  TO TABLE-ELEMENT-2              
              MOVE AR-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE AR-TRANS-HIST-SEQ-NO TO HOSTVAR-ELEMENT-2            
PCR361        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       8800-EXIT.                                                       
           EXIT.                                                        
T22767******************************************************************        
T22767**   8549-GET-CURRENT-TIMESTAMP                                  *        
T22767**                                                               *        
T22767******************************************************************        
T22767 8549-GET-CURRENT-TIMESTAMP.                                      
T22767                                                                  
T22767      MOVE '8549'                   TO WS-ACTIVE-PARAGRAPH.       
T22767                                                                  
T22767      EXEC SQL                                                    
T22767         SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              REPLACE(CONVERT(CHAR(8), CIS.CURRENT$TIME(), 108), ':', 
           '.')
            INTO
              :WS-XFR-TS,
              :WS-TRAN-TIME                         
T22767      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SET :WS-XFR-TS = CURRENT TIMESTAMP,                              
MFA-TR*            :WS-TRAN-TIME = CURRENT TIME                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T22767      MOVE SQLCODE   TO WS-ACTIVE-RETURN-CODE.                    
T22767                                                                  
T22767      IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL             
T22767          NEXT SENTENCE                                           
T22767      ELSE                                                        
T22767          MOVE PROGRAM-NAME               TO ABEND-PROGRAM        
T22767          MOVE '8549'                     TO ACTIVE-PARAGRAPH     
C35824        MOVE 'SET'                TO ABEND-FUNCTION               
C35824        MOVE SPACES               TO ABEND-SQL-PREDICATES         
C35824                                     ABEND-TABLES                 
T22767          PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT          
T22767      END-IF.                                                     
T22767                                                                  
T22767  8549-EXIT.                                                      
T22767      EXIT.                                                       
T22767                                                                  
T22767***************************************************************           
T22767* 8850-SELECT-BANK-TRANS-AMT                                  *           
T22767***************************************************************           
T22767 8850-SELECT-BANK-TRANS-AMT.                                      
T22767                                                                  
T22767     MOVE '8850'                   TO WS-ACTIVE-PARAGRAPH.        
T22767     EXEC SQL                                                     
T22767        SELECT  REPLACE(REPLACE(CONVERT(CHAR(26), TRANSFER_TS
           , 121), ' ', '-'), ':', '.') TRANSFER_TS,                           
T22767                TRANSFER_AMT                                      
T22767          INTO  :YB-TRANSFER-TS,                                  
T22767                :YB-TRANSFER-AMT                                  
T22767          FROM  CSS_BANK_TRANSFER WITH(READUNCOMMITTED)                   
T22767         WHERE  CASH_COMPANY_NO   =:YB-CASH-COMPANY-NO            
T22767           AND  CASH_LOCAL_OFFICE =:YB-CASH-LOCAL-OFFICE          
T22767           AND  DATE_CASH_REPORT  =IIF(TRY_CONVERT(DATE, 
                                                   :YB-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YB-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YB-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YB-DATE-CASH-REPORT
              ), CONVERT(DATE, :YB-DATE-CASH-REPORT) )           
T22767           AND  CASH_DRAWER_ID    =:YB-CASH-DRAWER-ID             
T22767           AND  CURRENCY_TYPE     =:YB-CURRENCY-TYPE              
T22767           AND  BANK_ID           =:YB-BANK-ID                    
C35824                                                           
A01376                                                      
T22767     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  TRANSFER_TS,                                              
MFA-TR*               TRANSFER_AMT                                              
MFA-TR*         INTO  :YB-TRANSFER-TS,                                          
MFA-TR*               :YB-TRANSFER-AMT                                          
MFA-TR*         FROM  CSS_BANK_TRANSFER                                         
MFA-TR*        WHERE  CASH_COMPANY_NO   =:YB-CASH-COMPANY-NO                    
MFA-TR*          AND  CASH_LOCAL_OFFICE =:YB-CASH-LOCAL-OFFICE                  
MFA-TR*          AND  DATE_CASH_REPORT  =:YB-DATE-CASH-REPORT                   
MFA-TR*          AND  CASH_DRAWER_ID    =:YB-CASH-DRAWER-ID                     
MFA-TR*          AND  CURRENCY_TYPE     =:YB-CURRENCY-TYPE                      
MFA-TR*          AND  BANK_ID           =:YB-BANK-ID                            
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 8850                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T22767                                                                  
T22767     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
T22767                                                                  
T22767     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T22767        ADD WS-AMT-CASH-DEBIT     TO YB-TRANSFER-AMT              
T22767        PERFORM 8870-UPDATE-BANK-TRANS-AMT                        
T22767                                  THRU 8870-EXIT                  
T22767     ELSE                                                         
T22767        IF WS-ACTIVE-RETURN-CODE  = NOT-FOUND                     
T22767           MOVE PARM-USER-ID        TO YB-USER-ID                 
T22767           MOVE WS-AMT-CASH-DEBIT   TO YB-TRANSFER-AMT            
T22767           MOVE 'C'                 TO YB-CODE-DR-CR              
T22767           PERFORM 8880-CREATE-BANK-TRANSFER                      
T22767                                    THRU 8880-EXIT                
T22767        ELSE                                                      
T22767           MOVE PROGRAM-NAME             TO ABEND-PROGRAM         
T22767           MOVE '8850'                   TO ACTIVE-PARAGRAPH      
T22767           MOVE 'SELECT'                 TO ABEND-FUNCTION        
T22767           MOVE 'CSS_BANK_TRANSFER'      TO TABLE-1               
T22767           MOVE 'CASH_COMPANY_NO'        TO TABLE-ELEMENT-1       
T22767           MOVE 'CASH_LOCAL_OFFICE'      TO TABLE-ELEMENT-2       
T22767           MOVE 'DATE_CASH_REPORT'       TO TABLE-ELEMENT-3       
T22767           MOVE 'CASH_DRAWER_ID'         TO TABLE-ELEMENT-4       
T22767           MOVE YB-CASH-COMPANY-NO       TO HOSTVAR-ELEMENT-1     
T22767           MOVE YB-CASH-LOCAL-OFFICE     TO HOSTVAR-ELEMENT-2     
T22767           MOVE YB-DATE-CASH-REPORT      TO HOSTVAR-ELEMENT-3     
T22767           MOVE YB-CASH-DRAWER-ID        TO HOSTVAR-ELEMENT-4     
T22767           PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
T22767        END-IF                                                    
T22767     END-IF.                                                      
T22767                                                                  
T22767 8850-EXIT.                                                       
T22767     EXIT.                                                        
T22767                                                                  
T22767***************************************************************           
T22767* 8870-UPDATE-BANK-TRANS-AMT                                  *           
T22767***************************************************************           
T22767 8870-UPDATE-BANK-TRANS-AMT.                                      
T22767                                                                  
T22767     MOVE '8870'                   TO WS-ACTIVE-PARAGRAPH.        
T22767     EXEC SQL                                                     
T22767        UPDATE CSS_BANK_TRANSFER                                  
T22767           SET TRANSFER_AMT        =:YB-TRANSFER-AMT              
T22767         WHERE CASH_COMPANY_NO     =:YB-CASH-COMPANY-NO           
T22767           AND CASH_LOCAL_OFFICE   =:YB-CASH-LOCAL-OFFICE         
T22767           AND DATE_CASH_REPORT    =IIF(TRY_CONVERT(DATE, 
                                                   :YB-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YB-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YB-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YB-DATE-CASH-REPORT
              ), CONVERT(DATE, :YB-DATE-CASH-REPORT) )          
T22767           AND CASH_DRAWER_ID      =:YB-CASH-DRAWER-ID            
T22767           AND CURRENCY_TYPE       =:YB-CURRENCY-TYPE             
T22767           AND BANK_ID             =:YB-BANK-ID                   
T22767     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_BANK_TRANSFER                                          
MFA-TR*          SET TRANSFER_AMT        =:YB-TRANSFER-AMT                      
MFA-TR*        WHERE CASH_COMPANY_NO     =:YB-CASH-COMPANY-NO                   
MFA-TR*          AND CASH_LOCAL_OFFICE   =:YB-CASH-LOCAL-OFFICE                 
MFA-TR*          AND DATE_CASH_REPORT    =:YB-DATE-CASH-REPORT                  
MFA-TR*          AND CASH_DRAWER_ID      =:YB-CASH-DRAWER-ID                    
MFA-TR*          AND CURRENCY_TYPE       =:YB-CURRENCY-TYPE                     
MFA-TR*          AND BANK_ID             =:YB-BANK-ID                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T22767                                                                  
T22767     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
T22767                                                                  
T22767     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T22767        NEXT SENTENCE                                             
T22767     ELSE                                                         
T22767        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
T22767        MOVE '8870'                     TO ACTIVE-PARAGRAPH       
T22767        MOVE 'UPDATE'                   TO ABEND-FUNCTION         
T22767        MOVE 'CSS_BANK_TRANSFER'        TO TABLE-1                
T22767        MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1        
T22767        MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2        
T22767        MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-3        
T22767        MOVE 'CASH_DRAWER_ID'           TO TABLE-ELEMENT-4        
T22767        MOVE YB-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1      
T22767        MOVE YB-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2      
T22767        MOVE YB-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-3      
T22767        MOVE YB-CASH-DRAWER-ID          TO HOSTVAR-ELEMENT-4      
T22767        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
T22767     END-IF.                                                      
T22767                                                                  
T22767 8870-EXIT.                                                       
T22767     EXIT.                                                        
T22767                                                                  
T22767***************************************************************           
T22767* 8880-CREATE-BANK-TRANSFER                                   *           
T22767***************************************************************           
T22767 8880-CREATE-BANK-TRANSFER.                                       
T22767                                                                  
T22767     MOVE '8880'                   TO WS-ACTIVE-PARAGRAPH.        
T22767     EXEC SQL                                                     
T22767        INSERT  INTO CSS_BANK_TRANSFER                            
T22767               (CASH_COMPANY_NO,                                  
T22767                CASH_LOCAL_OFFICE,                                
T22767                DATE_CASH_REPORT,                                 
T22767                CASH_DRAWER_ID,                                   
T22767                TRANSFER_TS,                                      
T22767                CURRENCY_TYPE,                                    
T22767                USER_ID,                                          
T22767                BANK_ID,                                          
T22767                TRANSFER_AMT,                                     
T22767                CODE_DR_CR,                                       
T25923                PARTIAL_PYMT_FL,                                  
T25923                BANK_POST_DT)                                     
T22767         VALUES (                                                 
T22767                :YB-CASH-COMPANY-NO,                              
T22767                :YB-CASH-LOCAL-OFFICE,                            
T22767                IIF(TRY_CONVERT(DATE, :YB-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YB-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YB-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YB-DATE-CASH-REPORT
              ), CONVERT(DATE, :YB-DATE-CASH-REPORT) ),                        
T22767                :YB-CASH-DRAWER-ID,                               
C25923                CIS.CURRENT$TIMESTAMP(),                                
T22767                :YB-CURRENCY-TYPE,                                
T22767                :YB-USER-ID,                                      
T22767                :YB-BANK-ID,                                      
T22767                :YB-TRANSFER-AMT,                                 
T22767                :YB-CODE-DR-CR,                                   
T25923                :YB-PARTIAL-PYMT-FL,                              
T25923                IIF(TRY_CONVERT(DATE, :YB-BANK-POST-DT
              ) IS NULL OR (PATINDEX('%.%', :YB-BANK-POST-DT
              ) <> 0) OR (LEN(:YB-BANK-POST-DT) <> 10), CIS.CHAR2DATE(
                                                       :YB-BANK-POST-DT
              ), CONVERT(DATE, :YB-BANK-POST-DT) ))                            
T22767     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT  INTO CSS_BANK_TRANSFER                                    
MFA-TR*              (CASH_COMPANY_NO,                                          
MFA-TR*               CASH_LOCAL_OFFICE,                                        
MFA-TR*               DATE_CASH_REPORT,                                         
MFA-TR*               CASH_DRAWER_ID,                                           
MFA-TR*               TRANSFER_TS,                                              
MFA-TR*               CURRENCY_TYPE,                                            
MFA-TR*               USER_ID,                                                  
MFA-TR*               BANK_ID,                                                  
MFA-TR*               TRANSFER_AMT,                                             
MFA-TR*               CODE_DR_CR,                                               
MFA-TR*               PARTIAL_PYMT_FL,                                          
MFA-TR*               BANK_POST_DT)                                             
MFA-TR*        VALUES (                                                         
MFA-TR*               :YB-CASH-COMPANY-NO,                                      
MFA-TR*               :YB-CASH-LOCAL-OFFICE,                                    
MFA-TR*               :YB-DATE-CASH-REPORT,                                     
MFA-TR*               :YB-CASH-DRAWER-ID,                                       
MFA-TR*               CURRENT TIMESTAMP,                                        
MFA-TR*               :YB-CURRENCY-TYPE,                                        
MFA-TR*               :YB-USER-ID,                                              
MFA-TR*               :YB-BANK-ID,                                              
MFA-TR*               :YB-TRANSFER-AMT,                                         
MFA-TR*               :YB-CODE-DR-CR,                                           
MFA-TR*               :YB-PARTIAL-PYMT-FL,                                      
MFA-TR*               :YB-BANK-POST-DT)                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T22767                                                                  
T22767     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
T22767                                                                  
T22767     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T22767        NEXT SENTENCE                                             
T22767     ELSE                                                         
T22767        MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
T22767        MOVE '8880'                       TO ACTIVE-PARAGRAPH     
T22767        MOVE 'INSERT'                     TO ABEND-FUNCTION       
T22767        MOVE 'CSS_BANK_TRANSFER'          TO TABLE-1              
T22767        MOVE 'CASH_COMPANY_NO'            TO TABLE-ELEMENT-1      
T22767        MOVE 'CASH_LOCAL_OFFICE'          TO TABLE-ELEMENT-2      
T22767        MOVE 'DATE_CASH_REPORT'           TO TABLE-ELEMENT-3      
T22767        MOVE 'USER_ID       '             TO TABLE-ELEMENT-4      
T22767        MOVE YB-CASH-COMPANY-NO           TO HOSTVAR-ELEMENT-1    
T22767        MOVE YB-CASH-LOCAL-OFFICE         TO HOSTVAR-ELEMENT-2    
T22767        MOVE YB-DATE-CASH-REPORT          TO HOSTVAR-ELEMENT-3    
T22767        MOVE YB-USER-ID                   TO HOSTVAR-ELEMENT-4    
T22767        PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
T22767     END-IF.                                                      
T22767                                                                  
T22767 8880-EXIT.                                                       
T22767     EXIT.                                                        
C26296*                                                                         
C26296******************************************************************        
C26296*  8895-INSERT-WORK-QUEUE                                        *15303100
C26296******************************************************************        
ACT063 8895-INSERT-WORK-QUEUE.                                          
                                                                        
ACT063     INITIALIZE   WS-MCSCB077-OUTPUT.                             
ACT063     INITIALIZE   ABEND-FUNCTION.                                 
                                                                        
ACT063     CALL MCSCB077 USING CWS00077-FIELDS,                         
ACT063                         ABEND-FILE,                              
ACT063                         WS-MCSCB077-RET-CODE.                    
                                                                        
ACT063     MOVE WS-MCSCB077-RET-CODE     TO WS-ACTIVE-RETURN-CODE       
ACT063                                                                  
ACT063     IF ABEND-FUNCTION > SPACES OR WS-MCSCB077-RET-CODE NOT = 0   
ACT063        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
ACT063        MOVE '8895'                TO ACTIVE-PARAGRAPH            
ACT063        MOVE 'CALL'                TO ABEND-FUNCTION              
ACT063        MOVE 'MCSCB077'            TO TABLE-1                     
ACT063        MOVE 'CUSTOMER NO'         TO TABLE-ELEMENT-1             
ACT063        MOVE WS-77-CUSTOMER-NO     TO HOSTVAR-ELEMENT-1           
ACT063        MOVE 'ACCOUNT NO'          TO TABLE-ELEMENT-2             
ACT063        MOVE WS-77-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2           
ACT063        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
ACT063     END-IF.                                                      
                                                                        
ACT063 8895-EXIT.                                                       
ACT063      EXIT.                                                       
PCR361****************************************************************          
PCR361* 9700-PROCESS-ABEND - COMBINED ON-LINE/BATCH ERROR HANDLING.  *          
PCR361****************************************************************          
PCR361        EXEC SQL                                                          
PCR361           INCLUDE CPD0023C                                               
PCR361        END-EXEC.                                                         
PCR361                                                                  
      ****************************************************************          
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ****************************************************************          
REARCH        EXEC SQL                                                          
REARCH           INCLUDE CPDSP300                                               
REARCH        END-EXEC.                                                         
      *                                                                         
      ****************************************************************          
      *       END PROGRAM COPYLIB                                               
      ****************************************************************          
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPD00321                                                  
REARCH     END-EXEC.                                                            
