       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR02188.                                     
COB303 DATE-WRITTEN.                                                    
COB303            DECEMBER 26, 1995.                                    
       DATE-COMPILED.                                                   
                                                                        
      *****************************************************************         
      *                SOUTH CAROLINA ELECTRIC & GAS                            
      *                                                                         
      *****************************************************************         
      *                 P R O G R A M  S U M M A R Y                            
      *                                                                         
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM                      
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                                
      *                                                                         
      *  THIS PROGRAM INSERTS OR UPDATES THE                                    
      *  RETURN CHECK HISTORY FOR A BANK AND AN ENTERED DATE                    
      *  BASED ON THE VALUE IN PARM-ACTION-CODE (I , U OR D)                    
      *  PARAMETER.                                                             
      *                                                                         
      *****************************************************************         
      *                     PROGRAM MODIFICATION LOG                            
      *                                                                         
      *    DATE    INITIALS   COMMENTS                                          
      *  --------  --------   ---------------------------------------           
      *  12/18/95    SS       CREATED.                                          
      *                                                                         
TP9050*  02/11/97    KOG      MODIFIED CODE TO ALLOW THE DELETION OF A          
TP9050*                       RETURNED CHECK ROW.                               
      *                                                                         
T9852 *  03/26/97    EMM      MODIFIED CODE TO ALLOW A RETURNED CHECK           
T9852 *                       AGAINST AN ACCOUNT THAT DOES NOT HAVE             
T9852 *                       6 MONTHS WORTH OF PAYMENT HISTORY.                
T9852 *                       THIS ABILITY IS MAINLY FOR CONVERSION             
T9852 *                       REASONS. THE AMOUNT OF THE RETURNED               
T9852 *                       CHECK IS MOVED TO NON-UTILITY.                    
      *                                                                         
T11577* 06/10/97     EMM      FIXED THE LOGIC IN 5000-UPDATE TO MOVE            
      *                       PARM-NSC-REMOVE-FL IN PARAGRAM 5100. ALSO         
      *                       REPLACED THE CURSOR LOGIC TO A SELECT MAX         
      *                       STATEMENT WHEN FINDING THE NEXT ITEM ID.          
      *                                                                         
T16077* 04/24/98     VIJI     MC05 ERROR LOG TO SHOW ACCOUNT NO'S ALSO          
      *                                                                         
T16727* 06/09/98     EMS      REMOVED THE SEND NOTICE PARM.  THE PARM           
      *                       IS NOT NEEDED.                                    
      *                                                                         
CBSI  *  09/23/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *              MADRAS   ABEND PARAMETERS                         *        
      *                                                                         
T21692*  02/25/00    CBSI     SEND ERROR MESSAGE TO THE PANEL IF A     *        
T21692*              MADRAS   RETURN CHECK ENTRY IS ALREADY MADE FOR A *        
T21692*                       PAYMENT                                  *        
T22767*  01/18/01    CBSI     CHANGES DONE FOR HANDLING NON-CIS        *        
T22767*              MADRAS   RETURN CHECKS                            *        
T25923*  02/13/02    SS19371  ADDED FIELDS TO BE SAVED FOR TREASURY    *        
T25923*                       BALANCING                                *        
REARCH*  07/11/03    AD88124  RPC CONVERTED TO COBOL SP.               *        
C26296*  01/14/05    SS82048  CHANGES TO ADD WAIVER NOTICE TO PANEL181 *        
      *                       DONE AS PART OF AUTOMATE DEPOSITS PROJECT*        
C30881*  10/12/05    BASKAR V INCREASE NSF-REASON-CD LENGTH            *        
A04527*  06/07/13    MR7E794  REMOVED UNUSED COPYBOOK CWS00056.        *        
P00935*  05/24/16    LG41184  RENAME PARM AND UPDATE COMMENTS.         *        
      ******************************************************************        
      *****************************************************************         
      *                                                                         
      *                ---- BASIC SEQUENCE STRUCTURE ----                       
      *                                                                         
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION                      
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                             
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                            
      *  3000 - 4999  NOT USED                                                  
      *  5000 - 5999  COMMON PROGRAM MODULES                                    
      *  6000 - 6999  COMMON SYSTEM MODULES                                     
      *  7000 - 7999  INPUT MODULES                                             
      *  8000 - 8999  OUTPUT MODULES                                            
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES                      
      *                                                                         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02188'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02188 STARTS HERE'.                  
                                                                        
      *****************************************************************         
      *    DB2 INCLUDES                                                         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBARLOCK                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBRETCHK                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBARHIST                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
      *****************************************************************         
      *    COBOL WORKING STORAGE COPY BOOKS                                     
      *****************************************************************         
                                                                        
       COPY CCA00001.                                                           
REARCH     EXEC SQL                                                             
REARCH          INCLUDE CWSX0010                                                
REARCH     END-EXEC.                                                            
       COPY CWS00027.                                                           
       COPY CWS00303.                                                           
                                                                        
      *****************************************************************         
      *    WORK AREAS                                                           
      *****************************************************************         
                                                                        
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME             PIC X(08)     VALUE 'CSR02188'. 
REARCH     05  WS-SQLSTATE              PIC X(05)     VALUE '     '.    
T9852      05  WS-TIME-STMP             PIC X(26)     VALUE SPACES.     
           05  WS-ACCOUNT-NO-NUM        PIC S9(13)    COMP-3 VALUE 0.   
           05  WS-NCIS-ACCOUNT-NO-NUM   PIC S9(13)    COMP-3 VALUE 0.   
           05  WS-BANK-ID-NUM           PIC S9(6)     COMP-3 VALUE 0.   
           05  WS-UTIL-AMT-NUM          PIC S9(13)V99 COMP-3 VALUE 0.   
           05  WS-NONUTIL-AMT-NUM       PIC S9(13)V99 COMP-3 VALUE 0.   
           05  WS-RET-AMT-NUM           PIC S9(13)V99 COMP-3 VALUE 0.   
           05  WS-CUSTOMER-NO-NUM       PIC S9(10)    COMP-3 VALUE 0.   
           05  WS-ITEM-NO-NUM           PIC S9(4)     COMP   VALUE 0.   
           05  WS-DATE-NI               PIC S9(4)     COMP   VALUE 0.   
           05  WS-TRNS-HST-SEQ-NO.                                      
               10 WS-TRNS-HST-SEQ-NO-DT PIC X(10) VALUE SPACES.         
               10 WS-TRNS-HST-SEQ-NO-TM PIC X(16) VALUE SPACES.         
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  EXISTS-SW                PIC X(01) VALUE 'N'.            
               88 EXISTS-YES                      VALUE 'Y'.            
               88 EXISTS-NO                       VALUE 'N'.            
                                                                        
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-ACCOUNT-NO-TEMP    PIC X(13) VALUE SPACES.          
           05  PARM-ACCOUNT-NO-RED     REDEFINES PARM-ACCOUNT-NO-TEMP   
                                       PIC 9(13).                       
           05  PARM-BANK-ID-TEMP       PIC X(06) VALUE SPACES.          
           05  PARM-BANK-ID-RED        REDEFINES PARM-BANK-ID-TEMP      
                                       PIC 9(06).                       
           05  PARM-RET-AMT-TEMP       PIC X(15) VALUE SPACES.          
           05  PARM-RET-AMT-RED        REDEFINES PARM-RET-AMT-TEMP      
                                       PIC 9(13)V99.                    
           05  PARM-UTIL-AMT-TEMP      PIC X(15) VALUE SPACES.          
           05  PARM-UTIL-AMT-RED       REDEFINES PARM-UTIL-AMT-TEMP     
                                       PIC 9(13)V99.                    
           05  PARM-NONUTIL-AMT-TEMP   PIC X(15) VALUE SPACES.          
           05  PARM-NONUTIL-AMT-RED    REDEFINES PARM-NONUTIL-AMT-TEMP  
                                       PIC 9(13)V99.                    
REARCH     05  PARM-ITEM-NO-TEMP       PIC X(04) VALUE SPACES.          
REARCH     05  PARM-ITEM-NO-RED        REDEFINES PARM-ITEM-NO-TEMP      
REARCH                                 PIC 9(04).                       
T22767     05  PARM-NCIS-ACCOUNT-NO-TEMP   PIC X(13) VALUE SPACES.      
T22767     05  PARM-NCIS-ACCOUNT-NO-RED REDEFINES                       
T22767           PARM-NCIS-ACCOUNT-NO-TEMP PIC 9(13).                   
T22767     05  PARM-GL-ACCOUNT-TEMP    PIC X(07)  VALUE SPACES.         
T22767     05  PARM-GL-ACCOUNT-RED     REDEFINES                        
T22767           PARM-GL-ACCOUNT-TEMP  PIC 9(03)V9(4) .                 
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME                PIC X(18) VALUE SPACES.         
REARCH     10  S-SQLCODE                PIC S9(9) COMP VALUE 0.         
REARCH     10  S-SQLSTATE               PIC X(5)  VALUE ' '.            
REARCH     10  S-TABLE-NAME             PIC X(18) VALUE SPACES.         
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L   PIC S9(4) USAGE COMP.           
REARCH         49  S-HOST-VARIABLES-V   PIC X(255).                     
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L    PIC S9(4) USAGE COMP.           
REARCH         49  S-SQL-STATEMENT-V    PIC X(255).                     
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L  PIC S9(4) USAGE COMP.           
REARCH         49  S-SQL-DESCRIPTION-V  PIC X(255).                     
                                                                        
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN           PIC S9(04) COMP.                
REARCH         49 GTT-ROW-CHAR          PIC X(1024).                    
REARCH     05  GTT-SQLCODE              PIC S9(9) COMP.                 
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
           05  RS-AR-LOCKOUT-IND        PIC X(01) VALUE SPACES.         
           05  RS-ACCT-XFER-TO          PIC X(13) VALUE SPACES.         
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE            PIC S9(9) COMP VALUE 0.         
REARCH     05  S-AR-LOCKOUT-IND         PIC X(01) VALUE SPACES.         
REARCH     05  S-ACCT-XFER-TO           PIC X(13) VALUE SPACES.         
                                                                        
       LINKAGE SECTION.                                                 
      *                                                                         
REARCH 01  PARM-ACTION-CODE             PIC X(1).                       
REARCH 01  PARM-ACCOUNT-NO              PIC X(13).                      
REARCH 01  PARM-BANK-ID                 PIC X(06).                      
REARCH 01  PARM-RET-AMT                 PIC X(15).                      
REARCH 01  PARM-UTIL-AMT                PIC X(15).                      
REARCH 01  PARM-NONUTIL-AMT             PIC X(15).                      
REARCH 01  PARM-CODE-AR-AGE             PIC X(01).                      
REARCH 01  PARM-DRAWN-BY-NM-LEN         PIC X(04).                      
REARCH 01  PARM-DRAWN-BY-NM-TEXT        PIC X(50).                      
REARCH 01  PARM-ENTERED-DT              PIC X(10).                      
REARCH 01  PARM-ITEM-NO                 PIC X(04).                      
REARCH 01  PARM-CURRENCY-TYPE           PIC X(01).                      
C30881*01  PARM-NSF-REASON-CD           PIC X(01).                              
C30881 01  PARM-NSF-REASON-CD           PIC X(03).                      
REARCH 01  PARM-WAIVE-REASON-CD         PIC X(01).                      
REARCH 01  PARM-TRNS-HST-SEQ-NO         PIC X(26).                      
REARCH 01  PARM-NSF-TIMESTMP            PIC X(26).                      
REARCH 01  PARM-NSC-REMOVE-FL           PIC X(01).                      
REARCH 01  PARM-NCIS-ACCOUNT-NO         PIC X(13).                      
REARCH 01  PARM-PAYMENT-TYPE            PIC X(15).                      
REARCH 01  PARM-GL-ACCOUNT              PIC X(07).                      
P00935 01  PARM-COMMENTS-LEN            PIC X(4).                       
P00935 01  PARM-COMMENTS-TEXT           PIC X(210).                     
REARCH 01  PARM-DATE-ORIG-PAYMT         PIC X(10).                      
REARCH 01  PARM-ORIG-PYMT-OFFICE        PIC X(3).                       
REARCH 01  PARM-PARTIAL-PYMT-FL         PIC X(1).                       
REARCH 01  PARM-BANK-POST-DT            PIC X(10).                      
C26296 01  PARM-WAIVE-NOTICE            PIC X(01).                      
                                                                        
T21692******************************************************************        
T21692*    DECLARE CURSOR TO RETRIEVE RETURN CHECKS                    *        
T21692******************************************************************        
T21692     EXEC SQL DECLARE RETNCHK-CURSOR CURSOR FOR                   
T21692        SELECT 'Y'                                                
T21692          FROM  CSS_RETURN_CHK                                    
T21692         WHERE  ACCOUNT_NO         = :RC-ACCOUNT-NO               
T21692           AND  TRANS_HIST_SEQ_NO  = CIS.CHAR2TIMESTAMP(
                                                  :RC-TRANS-HIST-SEQ-NO
              )        
T22767           AND  NON_CIS_ACCT_NO    = :RC-NON-CIS-ACCT-NO          
T21692         OPTION(FAST 1)                                       
T21692     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ021
MFA-TR* MSQ054
MFA-TR*    EXEC SQL DECLARE RETNCHK-CURSOR CURSOR FOR                           
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         FROM  CSS_RETURN_CHK                                            
MFA-TR*        WHERE  ACCOUNT_NO         = :RC-ACCOUNT-NO                       
MFA-TR*          AND  TRANS_HIST_SEQ_NO  = :RC-TRANS-HIST-SEQ-NO                
MFA-TR*          AND  NON_CIS_ACCT_NO    = :RC-NON-CIS-ACCT-NO                  
MFA-TR*        OPTIMIZE FOR 1 ROW                                               
MFA-TR*    END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                                    
REARCH PROCEDURE DIVISION USING  PARM-ACTION-CODE                       
REARCH                          ,PARM-ACCOUNT-NO                        
REARCH                          ,PARM-BANK-ID                           
REARCH                          ,PARM-RET-AMT                           
REARCH                          ,PARM-UTIL-AMT                          
REARCH                          ,PARM-NONUTIL-AMT                       
REARCH                          ,PARM-CODE-AR-AGE                       
REARCH                          ,PARM-DRAWN-BY-NM-LEN                   
REARCH                          ,PARM-DRAWN-BY-NM-TEXT                  
REARCH                          ,PARM-ENTERED-DT                        
REARCH                          ,PARM-ITEM-NO                           
REARCH                          ,PARM-CURRENCY-TYPE                     
REARCH                          ,PARM-NSF-REASON-CD                     
REARCH                          ,PARM-WAIVE-REASON-CD                   
REARCH                          ,PARM-TRNS-HST-SEQ-NO                   
REARCH                          ,PARM-NSF-TIMESTMP                      
REARCH                          ,PARM-NSC-REMOVE-FL                     
REARCH                          ,PARM-NCIS-ACCOUNT-NO                   
REARCH                          ,PARM-PAYMENT-TYPE                      
REARCH                          ,PARM-GL-ACCOUNT                        
P00935                          ,PARM-COMMENTS-LEN                      
P00935                          ,PARM-COMMENTS-TEXT                     
REARCH                          ,PARM-DATE-ORIG-PAYMT                   
REARCH                          ,PARM-ORIG-PYMT-OFFICE                  
REARCH                          ,PARM-PARTIAL-PYMT-FL                   
REARCH                          ,PARM-BANK-POST-DT,                     
C26296                          ,PARM-WAIVE-NOTICE.                     
                                                                        
      *****************************************************************         
      * 0000-MAINLINE                                                           
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                               
      *****************************************************************         
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 0100-INITIALIZE                                                         
      *                                                                         
      *     1. RESET DB2 ERROR HANDLERS                                         
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                           
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)            
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)         
      *                                                                         
      *****************************************************************         
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARCH            :S-RETURN-CODE           AS RETURN_CODE               
REARCH           ,:S-AR-LOCKOUT-IND        AS AR_LOCKOUT_IND            
REARCH           ,:S-ACCT-XFER-TO          AS ACCT_XFER_TO              
REARCH         FROM                                                     
REARCH             CIS.SYSDUMMY1                                     
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*           :S-RETURN-CODE           AS RETURN_CODE                       
MFA-TR*          ,:S-AR-LOCKOUT-IND        AS AR_LOCKOUT_IND                    
MFA-TR*          ,:S-ACCT-XFER-TO          AS ACCT_XFER_TO                      
MFA-TR*        FROM                                                             
MFA-TR*            SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC.                                                            
REARCH*                                                                         
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      * 2000-PROCESS-OUTPUT.                                                    
      *                                                                         
      *     1. DESCRIBE RESULT SET                                              
      *     2. UPDATE DB2 DATA                                                  
      *     3. BUILD RESULT SET                                                 
      *     4. SEND RESULT SET                                                  
      *                                                                         
      *****************************************************************         
                                                                        
       2000-PROCESS-OUTPUT.                                             
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
TP9050     IF PARM-ACTION-CODE NOT EQUAL 'D'                            
              PERFORM 7999-SELECT-AL THRU 7999-SELECT-AL-EXIT           
              IF AL-AR-LOCKOUT-IND = 'Y'                                
                 MOVE 5000 TO RS-RETURN-CODE                            
                 MOVE AL-AR-LOCKOUT-IND        TO RS-AR-LOCKOUT-IND     
REARCH           PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT          
                 PERFORM 9999-END-PROGRAM      THRU 9999-EXIT           
              END-IF                                                    
                                                                        
REARCH        MOVE PARM-ACCOUNT-NO     TO PARM-ACCOUNT-NO-TEMP          
              MOVE PARM-ACCOUNT-NO-RED TO AT-ACCOUNT-NO                 
T22767        IF PARM-CODE-AR-AGE NOT EQUAL       TO 'N'                
                 PERFORM 7999-SELECT-TRANSFER-IND                       
                    THRU 7999-SELECT-TRANSFER-IND-EXIT                  
                 IF AT-ACCT-XFER-TO > ZERO                              
                    MOVE 5000 TO RS-RETURN-CODE                         
                    MOVE AT-ACCT-XFER-TO          TO RS-ACCT-XFER-TO    
REARCH              PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT       
                    PERFORM 9999-END-PROGRAM      THRU 9999-EXIT        
                 END-IF                                                 
T22767        END-IF                                                    
TP9050     END-IF.                                                      
                                                                        
           PERFORM 5000-UPDATE          THRU 5000-EXIT.                 
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
REARCH*****************************************************************         
REARCH*                                                               *         
REARCH* 2000A-MOVE-RESULT.                                            *         
REARCH*                                                               *         
REARCH*****************************************************************         
REARCH*                                                                         
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE RS-RETURN-CODE          TO S-RETURN-CODE                
REARCH     MOVE RS-AR-LOCKOUT-IND       TO S-AR-LOCKOUT-IND             
REARCH     MOVE RS-ACCT-XFER-TO         TO S-ACCT-XFER-TO.              
REARCH     ADD +1       TO CTR-ROWS.                                    
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
                                                                        
      ***************************************************************           
      * MAIN UPDATE PARAGRAPH.                                      *           
      ***************************************************************           
                                                                        
       5000-UPDATE.                                                     
                                                                        
           MOVE '5000'                    TO ACTIVE-PARAGRAPH.          
      *                                                                         
           MOVE PARM-ENTERED-DT           TO RC-ENTERED-DT.             
REARCH     MOVE PARM-BANK-ID              TO PARM-BANK-ID-TEMP.         
           MOVE PARM-BANK-ID-RED          TO WS-BANK-ID-NUM.            
           MOVE WS-BANK-ID-NUM            TO RC-BANK-ID.                
REARCH     MOVE PARM-ITEM-NO              TO PARM-ITEM-NO-TEMP.         
           MOVE PARM-ITEM-NO-RED          TO WS-ITEM-NO-NUM.            
           MOVE WS-ITEM-NO-NUM            TO RC-ITEM-NO.                
REARCH     MOVE PARM-RET-AMT              TO PARM-RET-AMT-TEMP.         
           MOVE PARM-RET-AMT-RED          TO WS-RET-AMT-NUM.            
T25923     MOVE PARM-BANK-POST-DT         TO RC-BANK-POST-DT.           
T25923     MOVE PARM-DATE-ORIG-PAYMT      TO RC-DATE-ORIG-PAYMT.        
      *                                                                         
T9852      PERFORM 5600-GET-TIMESTAMP                 THRU 5600-EXIT.   
      *                                                                         
           IF PARM-NSC-REMOVE-FL EQUAL 'Y'                              
              MOVE PARM-NSF-TIMESTMP      TO RC-NSF-TIMESTAMP           
           ELSE                                                         
T9852         MOVE WS-TIME-STMP           TO RC-NSF-TIMESTAMP           
           END-IF.                                                      
      *                                                                         
T9852      IF PARM-TRNS-HST-SEQ-NO EQUAL SPACES                         
              MOVE WS-TIME-STMP           TO RC-TRANS-HIST-SEQ-NO       
           ELSE                                                         
              MOVE PARM-TRNS-HST-SEQ-NO   TO RC-TRANS-HIST-SEQ-NO       
           END-IF.                                                      
      *                                                                         
T22767     IF PARM-CODE-AR-AGE = 'N'                                    
T22767        MOVE WS-TIME-STMP              TO RC-TRANS-HIST-SEQ-NO    
REARCH        MOVE PARM-NCIS-ACCOUNT-NO      TO                         
REARCH                                       PARM-NCIS-ACCOUNT-NO-TEMP  
T22767        MOVE PARM-NCIS-ACCOUNT-NO-RED  TO WS-NCIS-ACCOUNT-NO-NUM  
T22767        MOVE WS-NCIS-ACCOUNT-NO-NUM    TO RC-NON-CIS-ACCT-NO      
T22767     ELSE                                                         
T22767        MOVE 0000000000000             TO RC-NON-CIS-ACCT-NO      
T22767     END-IF.                                                      
T21692     MOVE PARM-ACCOUNT-NO-RED       TO WS-ACCOUNT-NO-NUM.         
T21692     MOVE WS-ACCOUNT-NO-NUM         TO RC-ACCOUNT-NO.             
T21692     PERFORM 7050-OPEN-RETNCHK-CURSOR             THRU 7050-EXIT. 
T21692     PERFORM 7100-FETCH-RETNCHK-CURSOR            THRU 7100-EXIT. 
T21692     PERFORM 7150-CLOSE-RETNCHK-CURSOR            THRU 7150-EXIT. 
T21692     IF  EXISTS-YES                                               
T21692         MOVE 3000 TO RS-RETURN-CODE                              
REARCH         PERFORM 2000A-MOVE-RESULT                THRU 2000A-EXIT 
T21692         PERFORM 9999-END-PROGRAM                 THRU 9999-EXIT  
T21692     END-IF.                                                      
T21692*                                                                         
           PERFORM 7300-SELECT-SUMMARY-ROW              THRU 7300-EXIT. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
               PERFORM 5200-MOVE-ITM0-FLDS               THRU 5200-EXIT 
               MOVE WS-RET-AMT-NUM         TO RC-RETURN-CHK-AMT         
               PERFORM 8150-INSERT-RET-CHK               THRU 8150-EXIT 
           ELSE                                                         
              IF RC-RETURN-CHK-AMT NOT EQUAL WS-RET-AMT-NUM             
                 MOVE WS-RET-AMT-NUM      TO RC-RETURN-CHK-AMT          
                 PERFORM 8300-UPDATE-SUMMARY-ROW        THRU 8300-EXIT  
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EVALUATE PARM-ACTION-CODE                                    
                                                                        
             WHEN 'I'                                                   
T11577          PERFORM 7000-GET-MAX-ITEM-ID            THRU 7000-EXIT  
                ADD 1                  TO RC-ITEM-NO                    
                PERFORM 5100-MOVE-PARM-FIELDS           THRU 5100-EXIT  
                PERFORM 8150-INSERT-RET-CHK             THRU 8150-EXIT  
                                                                        
            WHEN 'D'                                                    
                PERFORM 8200-DELETE-RET-CHK             THRU 8200-EXIT  
                                                                        
           END-EVALUATE.                                                
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE.               
           MOVE '5000'                 TO ACTIVE-PARAGRAPH.             
REARCH     PERFORM 2000A-MOVE-RESULT                  THRU 2000A-EXIT.  
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * MOVE PARAMETER FIELDS INTO WORKING STORAGE                 *            
      **************************************************************            
                                                                        
       5100-MOVE-PARM-FIELDS.                                           
                                                                        
P00935     MOVE PARM-COMMENTS-LEN            TO RC-COMMENTS-TX-LEN      
P00935     MOVE PARM-COMMENTS-TEXT           TO RC-COMMENTS-TX-TEXT     
T22767     IF PARM-ACTION-CODE EQUAL 'I' AND PARM-CODE-AR-AGE EQUAL 'N' 
T22767        MOVE SPACES                    TO RC-NSF-REASON-CD        
T22767                                          RC-WAIVER-REASON-CD     
C26296*                                         RC-SEND-NOTICE-CD               
T22767                                          RC-NSC-REMOVE-FL        
C26296        IF  PARM-WAIVE-NOTICE = 'Y'                               
C26296            MOVE 'N'                   TO RC-SEND-NOTICE-CD       
C26296        ELSE                                                      
C26296            MOVE 'Y'                   TO RC-SEND-NOTICE-CD       
C26296        END-IF                                                    
T22767        MOVE PARM-ACCOUNT-NO-RED       TO WS-ACCOUNT-NO-NUM       
T22767        MOVE WS-ACCOUNT-NO-NUM         TO RC-ACCOUNT-NO           
T22767        MOVE PARM-CODE-AR-AGE          TO RC-CODE-AR-AGE          
REARCH        MOVE PARM-NONUTIL-AMT          TO PARM-NONUTIL-AMT-TEMP   
T22767        MOVE PARM-NONUTIL-AMT-RED      TO WS-NONUTIL-AMT-NUM      
T22767        MOVE WS-NONUTIL-AMT-NUM        TO RC-RETURN-CHK-AMT       
T22767        MOVE ZEROES                    TO RC-CHECK-NONUTIL-AMT    
T22767        MOVE ZEROES                    TO RC-CHECK-UTIL-AMT       
T22767        MOVE 'C'                       TO RC-NSF-STATUS-CD        
REARCH        MOVE PARM-NCIS-ACCOUNT-NO      TO                         
REARCH                                       PARM-NCIS-ACCOUNT-NO-TEMP  
T22767        MOVE PARM-NCIS-ACCOUNT-NO-RED  TO WS-NCIS-ACCOUNT-NO-NUM  
T22767        MOVE WS-NCIS-ACCOUNT-NO-NUM    TO RC-NON-CIS-ACCT-NO      
REARCH        MOVE PARM-GL-ACCOUNT           TO PARM-GL-ACCOUNT-TEMP    
T22767        MOVE PARM-GL-ACCOUNT-RED       TO RC-NON-CIS-GL-ACCT      
T22767        MOVE PARM-PAYMENT-TYPE         TO RC-PAYMENT-TYPE-TX      
T22767        MOVE 'C'                       TO RC-NSF-CURRENCY-TYPE    
T25923        MOVE PARM-PARTIAL-PYMT-FL      TO RC-PARTIAL-PYMT-FL      
T25923        MOVE PARM-BANK-POST-DT         TO RC-BANK-POST-DT         
T25923        MOVE PARM-ORIG-PYMT-OFFICE     TO RC-ORIG-PYMT-OFFICE     
T25923        IF PARM-DATE-ORIG-PAYMT = SPACES                          
T25923           PERFORM 7400-GET-NONCIS-ORIG-PYMT-DATE THRU 7400-EXIT  
T25923        END-IF                                                    
T25923        MOVE PARM-DATE-ORIG-PAYMT      TO RC-DATE-ORIG-PAYMT      
T25923        MOVE 'C'                       TO RC-NSF-CURRENCY-TYPE    
T22767     ELSE                                                         
T22767        MOVE SPACES                    TO RC-PAYMENT-TYPE-TX      
C26296*                                         RC-SEND-NOTICE-CD               
              MOVE PARM-ACCOUNT-NO-RED       TO WS-ACCOUNT-NO-NUM       
              MOVE WS-ACCOUNT-NO-NUM         TO RC-ACCOUNT-NO           
REARCH        MOVE PARM-UTIL-AMT             TO PARM-UTIL-AMT-TEMP      
              MOVE PARM-UTIL-AMT-RED         TO WS-UTIL-AMT-NUM         
              MOVE WS-UTIL-AMT-NUM           TO RC-CHECK-UTIL-AMT       
REARCH        MOVE PARM-NONUTIL-AMT          TO PARM-NONUTIL-AMT-TEMP   
              MOVE PARM-NONUTIL-AMT-RED      TO WS-NONUTIL-AMT-NUM      
              MOVE WS-NONUTIL-AMT-NUM        TO RC-CHECK-NONUTIL-AMT    
              COMPUTE RC-RETURN-CHK-AMT    =  RC-CHECK-UTIL-AMT         
                                             +  RC-CHECK-NONUTIL-AMT    
              MOVE PARM-CODE-AR-AGE          TO RC-CODE-AR-AGE          
              MOVE PARM-DRAWN-BY-NM-LEN      TO RC-DRAWN-BY-NM-LEN      
              MOVE PARM-DRAWN-BY-NM-TEXT     TO RC-DRAWN-BY-NM-TEXT     
              MOVE PARM-CURRENCY-TYPE        TO RC-NSF-CURRENCY-TYPE    
              MOVE PARM-NSF-REASON-CD        TO RC-NSF-REASON-CD        
              MOVE PARM-WAIVE-REASON-CD      TO RC-WAIVER-REASON-CD     
T11577        MOVE PARM-NSC-REMOVE-FL        TO RC-NSC-REMOVE-FL        
              MOVE 'C'                       TO RC-NSF-STATUS-CD        
T22767        MOVE 0                         TO RC-NON-CIS-GL-ACCT      
T25923        MOVE PARM-PARTIAL-PYMT-FL      TO RC-PARTIAL-PYMT-FL      
T25923        MOVE PARM-BANK-POST-DT         TO RC-BANK-POST-DT         
T25923        PERFORM 7500-GET-CIS-ORIG-PYMT-INFO THRU 7500-EXIT        
T25923        MOVE PARM-DATE-ORIG-PAYMT      TO RC-DATE-ORIG-PAYMT      
T25923        MOVE PARM-ORIG-PYMT-OFFICE     TO RC-ORIG-PYMT-OFFICE     
C26296        IF  PARM-WAIVE-NOTICE = 'Y'                               
C26296            MOVE 'N'                   TO RC-SEND-NOTICE-CD       
C26296        ELSE                                                      
C26296            MOVE 'Y'                   TO RC-SEND-NOTICE-CD       
C26296        END-IF                                                    
T22767     END-IF.                                                      
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * MOVE ITEM-0 FIELDS INTO WORKING STORAGE                    *            
      **************************************************************            
                                                                        
       5200-MOVE-ITM0-FLDS.                                             
                                                                        
           MOVE 0                         TO RC-ACCOUNT-NO              
                                             RC-CHECK-UTIL-AMT          
                                             RC-CHECK-NONUTIL-AMT       
                                             RC-DRAWN-BY-NM-LEN         
T22767                                       RC-NON-CIS-GL-ACCT         
T22767                                       RC-NON-CIS-ACCT-NO.        
           MOVE SPACES                    TO RC-CODE-AR-AGE             
                                             RC-DRAWN-BY-NM-TEXT        
                                             RC-NSF-CURRENCY-TYPE       
                                             RC-NSF-REASON-CD           
                                             RC-WAIVER-REASON-CD        
                                             RC-SEND-NOTICE-CD          
                                             RC-NSF-STATUS-CD           
                                             RC-NSC-REMOVE-FL           
T25923                                       RC-PARTIAL-PYMT-FL         
T25923                                       RC-ORIG-PYMT-OFFICE        
T22767                                       RC-PAYMENT-TYPE-TX.        
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * THIS MODULE GETS CURRENT TIMESTAMP AND DATE FOR CREATING    *           
      * JOURNAL ENTRIES                                             *           
      ***************************************************************           
       5600-GET-TIMESTAMP.                                              
                                                                        
           EXEC SQL                                                     
               SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-TIME-STMP                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-TIME-STMP = CURRENT TIMESTAMP                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF SQLCODE NOT EQUAL SUCCESSFUL-CALL                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '5600'              TO ACTIVE-PARAGRAPH              
              MOVE 'SET'               TO ABEND-FUNCTION                
CBSI          MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
CBSI          MOVE PARM-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       5600-EXIT.                                                       
           EXIT.                                                        
                                                                        
HPCCDM*EJECT                                                                    
                                                                        
      ***************************************************************           
      * 7000-GET-MAX-ITEM-ID.                                       *           
      *                                                                         
      ***************************************************************           
       7000-GET-MAX-ITEM-ID.                                            
                                                                        
           EXEC SQL                                                     
              SELECT                                                    
                 MAX(ITEM_NO)                                           
              INTO                                                      
                 :RC-ITEM-NO                                            
              FROM                                                      
                 CSS_RETURN_CHK                                         
              WHERE                                                     
                  ENTERED_DT = IIF(TRY_CONVERT(DATE, :RC-ENTERED-DT
              ) IS NULL OR (PATINDEX('%.%', :RC-ENTERED-DT
              ) <> 0) OR (LEN(:RC-ENTERED-DT) <> 10), CIS.CHAR2DATE(
                                                         :RC-ENTERED-DT
              ), CONVERT(DATE, :RC-ENTERED-DT) )                           
              AND BANK_ID    = :RC-BANK-ID                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*          MAX(ITEM_NO)                                                   
MFA-TR*       INTO                                                              
MFA-TR*          :RC-ITEM-NO                                                    
MFA-TR*       FROM                                                              
MFA-TR*          CSS_RETURN_CHK                                                 
MFA-TR*       WHERE                                                             
MFA-TR*           ENTERED_DT = :RC-ENTERED-DT                                   
MFA-TR*       AND BANK_ID    = :RC-BANK-ID                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7000'          TO ACTIVE-PARAGRAPH                  
CBSI          MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_RETURN_CHK'     TO TABLE-1                      
              MOVE 'ENTERED_DT'         TO TABLE-ELEMENT-1              
              MOVE 'BANK_ID'            TO TABLE-ELEMENT-2              
T16077        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-3              
              MOVE RC-ENTERED-DT        TO HOSTVAR-ELEMENT-1            
              MOVE RC-BANK-ID           TO HOSTVAR-ELEMENT-2            
T16077        MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
T21692******************************************************************        
T21692* 7050-OPEN-RETNCHK-CURSOR                                       *        
T21692******************************************************************        
T21692 7050-OPEN-RETNCHK-CURSOR.                                        
T21692*                                                                         
T21692     EXEC SQL                                                     
T21692        OPEN RETNCHK-CURSOR                                       
T21692     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21692                                                                  
T21692     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T21692                                                                  
T21692     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T21692        NEXT SENTENCE                                             
T21692     ELSE                                                         
T21692        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
T21692        MOVE '7050'               TO ACTIVE-PARAGRAPH             
T21692        MOVE 'OPEN'               TO ABEND-FUNCTION               
T21692        MOVE 'CSS_RETURN_CHK'     TO TABLE-1                      
T21692        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
T21692        MOVE 'TRANS_HIST_SEQ_NO'  TO TABLE-ELEMENT-1              
T21692        MOVE RC-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
T21692        MOVE RC-TRANS-HIST-SEQ-NO TO HOSTVAR-ELEMENT-1            
T21692        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T21692        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T21692     END-IF.                                                      
T21692                                                                  
T21692 7050-EXIT.                                                       
T21692     EXIT.                                                        
T21692*                                                                         
T21692******************************************************************        
T21692* 7100-FETCH-RETNCHK-CURSOR                                      *        
T21692******************************************************************        
T21692 7100-FETCH-RETNCHK-CURSOR.                                       
T21692*                                                                         
T21692     EXEC SQL                                                     
T21692        FETCH RETNCHK-CURSOR                                      
T21692         INTO :EXISTS-SW                                          
T21692     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21692                                                                  
T21692     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T21692                                                                  
T21692     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
T21692        NEXT SENTENCE                                             
T21692     ELSE                                                         
T21692        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
T21692        MOVE '7100'               TO ACTIVE-PARAGRAPH             
T21692        MOVE 'FETCH'              TO ABEND-FUNCTION               
T21692        MOVE 'CSS_RETURN_CHK'     TO TABLE-1                      
T21692        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
T21692        MOVE 'TRANS_HIST_SEQ_NO'  TO TABLE-ELEMENT-2              
T21692        MOVE RC-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
T21692        MOVE RC-TRANS-HIST-SEQ-NO TO HOSTVAR-ELEMENT-2            
T21692        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T21692        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T21692     END-IF.                                                      
T21692                                                                  
T21692 7100-EXIT.                                                       
T21692     EXIT.                                                        
T21692*                                                                         
T21692******************************************************************        
T21692* 7150-CLOSE-RETNCHK-CURSOR                                      *        
T21692******************************************************************        
T21692 7150-CLOSE-RETNCHK-CURSOR.                                       
T21692*                                                                         
T21692     EXEC SQL                                                     
T21692        CLOSE RETNCHK-CURSOR                                      
T21692     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21692                                                                  
T21692     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T21692                                                                  
T21692     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T21692        NEXT SENTENCE                                             
T21692     ELSE                                                         
T21692        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
T21692        MOVE '7150'               TO ACTIVE-PARAGRAPH             
T21692        MOVE 'CLOSE'              TO ABEND-FUNCTION               
T21692        MOVE 'CSS_RETURN_CHK'     TO TABLE-1                      
T21692        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
T21692        MOVE 'TRANS_HIST_SEQ_NO'  TO TABLE-ELEMENT-2              
T21692        MOVE RC-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
T21692        MOVE RC-TRANS-HIST-SEQ-NO TO HOSTVAR-ELEMENT-2            
T21692        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T21692        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T21692     END-IF.                                                      
T21692                                                                  
T21692 7150-EXIT.                                                       
T21692     EXIT.                                                        
T21692*                                                                         
      ***************************************************************           
      * SELECT RECORD IN CSS_RETURN_CHK FOR TOTAL RETURNED AMT.     *           
      ***************************************************************           
                                                                        
       7300-SELECT-SUMMARY-ROW.                                         
                                                                        
           MOVE '7300' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
                SELECT RETURN_CHK_AMT                                   
                  INTO :RC-RETURN-CHK-AMT                               
                  FROM CSS_RETURN_CHK                                   
                 WHERE   ENTERED_DT         = IIF(TRY_CONVERT(DATE, 
                                                         :RC-ENTERED-DT
              ) IS NULL OR (PATINDEX('%.%', :RC-ENTERED-DT
              ) <> 0) OR (LEN(:RC-ENTERED-DT) <> 10), CIS.CHAR2DATE(
                                                         :RC-ENTERED-DT
              ), CONVERT(DATE, :RC-ENTERED-DT) )            
                   AND   BANK_ID            = :RC-BANK-ID               
                   AND   ITEM_NO            = 0                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT RETURN_CHK_AMT                                           
MFA-TR*           INTO :RC-RETURN-CHK-AMT                                       
MFA-TR*           FROM CSS_RETURN_CHK                                           
MFA-TR*          WHERE   ENTERED_DT         = :RC-ENTERED-DT                    
MFA-TR*            AND   BANK_ID            = :RC-BANK-ID                       
MFA-TR*            AND   ITEM_NO            = 0                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                                    OR NOT-FOUND                        
              NEXT SENTENCE                                             
           ELSE                                                         
                 MOVE SPACES               TO ABEND-TABLES              
                 MOVE SPACES               TO ABEND-SQL-PREDICATES      
                 MOVE 'CSR02188'           TO ABEND-PROGRAM             
                 MOVE 'SELECT'             TO ABEND-FUNCTION            
                 MOVE 'CSS_RETURN_CHK'     TO TABLE-1                   
                 MOVE 'ENTERED_DT'         TO TABLE-ELEMENT-1           
                 MOVE 'BANK_ID'            TO TABLE-ELEMENT-2           
                 MOVE 'ITEM_NO'            TO TABLE-ELEMENT-3           
T16077           MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-4           
                 MOVE RC-ENTERED-DT        TO HOSTVAR-ELEMENT-1         
                 MOVE RC-BANK-ID           TO HOSTVAR-ELEMENT-2         
                 MOVE 0                    TO HOSTVAR-ELEMENT-3         
T16077           MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-4         
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
HPCCDM*EJECT                                                                    
T25923***************************************************************           
T25923* SELECT MOST RECENT BUSINESS DAY FROM CSH-DRWR-JRNL          *           
T25923***************************************************************           
T25923 7400-GET-NONCIS-ORIG-PYMT-DATE.                                  
T25923        EXEC SQL                                                  
T25923           SELECT MAX(CJ.DATE_CASH_REPORT)                        
T25923             INTO :PARM-DATE-ORIG-PAYMT                           
T25923             FROM CSS_CSH_DRWR_JRNL CJ                            
T25923        END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                 
T25923                                                                  
T25923 7400-EXIT.                                                       
T25923     EXIT.                                                        
T25923***************************************************************           
T25923* SELECT MATCING PAYMENT DATE AND OFFICE FROM AR-TRANS-HIST   *           
T25923***************************************************************           
T25923 7500-GET-CIS-ORIG-PYMT-INFO.                                     
T25923        MOVE PARM-TRNS-HST-SEQ-NO TO WS-TRNS-HST-SEQ-NO           
T25923                                     AR-TRANS-HIST-SEQ-NO         
T25923        EXEC SQL                                                  
T25923           SELECT AR.CASH_LOCAL_OFFICE                            
T25923             INTO :PARM-ORIG-PYMT-OFFICE                          
T25923             FROM CSS_AR_TRANS_HIST AR                            
T25923            WHERE AR.ACCOUNT_NO = :WS-ACCOUNT-NO-NUM              
T25923              AND AR.TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )    
T25923        END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*       EXEC SQL                                                          
MFA-TR*          SELECT AR.CASH_LOCAL_OFFICE                                    
MFA-TR*            INTO :PARM-ORIG-PYMT-OFFICE                                  
MFA-TR*            FROM CSS_AR_TRANS_HIST AR                                    
MFA-TR*           WHERE AR.ACCOUNT_NO = :WS-ACCOUNT-NO-NUM                      
MFA-TR*             AND AR.TRANS_HIST_SEQ_NO = :AR-TRANS-HIST-SEQ-NO            
MFA-TR*       END-EXEC.                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T25923        MOVE WS-TRNS-HST-SEQ-NO-DT TO PARM-DATE-ORIG-PAYMT.       
T25923 7500-EXIT.                                                       
T25923      EXIT.                                                       
                                                                        
      ****************************************************************          
      * 7999-SELECT-AL AR LOCKOUT AND TRANSFER ROUTINE               *          
      ****************************************************************          
              EXEC SQL                                                          
                 INCLUDE CPD00075                                               
              END-EXEC.                                                         
                                                                        
              EXEC SQL                                                          
                 INCLUDE CPD00307                                               
              END-EXEC.                                                         
                                                                        
      ***************************************************************           
      * INSERT RECORD IN CSS_RETURN_CHK FOR RETURNED CHECKS.        *           
      ***************************************************************           
                                                                        
       8150-INSERT-RET-CHK.                                             
           MOVE '8150' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
           INSERT INTO CSS_RETURN_CHK                                   
                  ( ACCOUNT_NO         ,                                
                    BANK_ID            ,                                
                    RETURN_CHK_AMT   ,                                  
                    CHECK_UTIL_AMT     ,                                
                    CHECK_NONUTIL_AMT  ,                                
                    CODE_AR_AGE        ,                                
                    DRAWN_BY_NM        ,                                
                    ENTERED_DT         ,                                
                    ITEM_NO            ,                                
                    NSF_CURRENCY_TYPE  ,                                
                    NSF_REASON_CD      ,                                
                    NSF_TIMESTAMP      ,                                
                    NSC_REMOVE_FL      ,                                
                    TRANS_HIST_SEQ_NO  ,                                
                    SEND_NOTICE_CD     ,                                
                    NSF_STATUS_CD      ,                                
                    WAIVER_REASON_CD   ,                                
T22767              COMMENTS_TX        ,                                
T22767              NON_CIS_ACCT_NO    ,                                
T22767              NON_CIS_GL_ACCT    ,                                
T22767              PAYMENT_TYPE_TX    ,                                
T25923              DATE_ORIG_PAYMT    ,                                
T25923              ORIG_PYMT_OFFICE   ,                                
T25923              PARTIAL_PYMT_FL    ,                                
T25923              BANK_POST_DT       )                                
           VALUES (:RC-ACCOUNT-NO         ,                             
                   :RC-BANK-ID            ,                             
                   :RC-RETURN-CHK-AMT     ,                             
                   :RC-CHECK-UTIL-AMT     ,                             
                   :RC-CHECK-NONUTIL-AMT  ,                             
                   :RC-CODE-AR-AGE        ,                             
                   :RC-DRAWN-BY-NM        ,                             
                   IIF(TRY_CONVERT(DATE, :RC-ENTERED-DT
              ) IS NULL OR (PATINDEX('%.%', :RC-ENTERED-DT
              ) <> 0) OR (LEN(:RC-ENTERED-DT) <> 10), CIS.CHAR2DATE(
                                                         :RC-ENTERED-DT
              ), CONVERT(DATE, :RC-ENTERED-DT) )         ,                     
                   :RC-ITEM-NO            ,                             
                   :RC-NSF-CURRENCY-TYPE  ,                             
                   :RC-NSF-REASON-CD      ,                             
                   CIS.CHAR2TIMESTAMP(:RC-NSF-TIMESTAMP)      ,                 
                   :RC-NSC-REMOVE-FL      ,                             
                   CIS.CHAR2TIMESTAMP(:RC-TRANS-HIST-SEQ-NO)  ,                 
                   :RC-SEND-NOTICE-CD     ,                             
                   :RC-NSF-STATUS-CD      ,                             
                   :RC-WAIVER-REASON-CD   ,                             
T22767             :RC-COMMENTS-TX        ,                             
T22767             :RC-NON-CIS-ACCT-NO    ,                             
T22767             :RC-NON-CIS-GL-ACCT    ,                             
T22767             :RC-PAYMENT-TYPE-TX    ,                             
T25923             IIF(TRY_CONVERT(DATE, :RC-DATE-ORIG-PAYMT
              ) IS NULL OR (PATINDEX('%.%', :RC-DATE-ORIG-PAYMT
              ) <> 0) OR (LEN(:RC-DATE-ORIG-PAYMT
              ) <> 10), CIS.CHAR2DATE(:RC-DATE-ORIG-PAYMT
              ), CONVERT(DATE, :RC-DATE-ORIG-PAYMT) )    ,                     
T25923             :RC-ORIG-PYMT-OFFICE   ,                             
T25923             :RC-PARTIAL-PYMT-FL    ,                             
T25923             IIF(TRY_CONVERT(DATE, :RC-BANK-POST-DT
              ) IS NULL OR (PATINDEX('%.%', :RC-BANK-POST-DT
              ) <> 0) OR (LEN(:RC-BANK-POST-DT) <> 10), CIS.CHAR2DATE(
                                                       :RC-BANK-POST-DT
              ), CONVERT(DATE, :RC-BANK-POST-DT) )       )                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*    INSERT INTO CSS_RETURN_CHK                                           
MFA-TR*           ( ACCOUNT_NO         ,                                        
MFA-TR*             BANK_ID            ,                                        
MFA-TR*             RETURN_CHK_AMT   ,                                          
MFA-TR*             CHECK_UTIL_AMT     ,                                        
MFA-TR*             CHECK_NONUTIL_AMT  ,                                        
MFA-TR*             CODE_AR_AGE        ,                                        
MFA-TR*             DRAWN_BY_NM        ,                                        
MFA-TR*             ENTERED_DT         ,                                        
MFA-TR*             ITEM_NO            ,                                        
MFA-TR*             NSF_CURRENCY_TYPE  ,                                        
MFA-TR*             NSF_REASON_CD      ,                                        
MFA-TR*             NSF_TIMESTAMP      ,                                        
MFA-TR*             NSC_REMOVE_FL      ,                                        
MFA-TR*             TRANS_HIST_SEQ_NO  ,                                        
MFA-TR*             SEND_NOTICE_CD     ,                                        
MFA-TR*             NSF_STATUS_CD      ,                                        
MFA-TR*             WAIVER_REASON_CD   ,                                        
MFA-TR*             COMMENTS_TX        ,                                        
MFA-TR*             NON_CIS_ACCT_NO    ,                                        
MFA-TR*             NON_CIS_GL_ACCT    ,                                        
MFA-TR*             PAYMENT_TYPE_TX    ,                                        
MFA-TR*             DATE_ORIG_PAYMT    ,                                        
MFA-TR*             ORIG_PYMT_OFFICE   ,                                        
MFA-TR*             PARTIAL_PYMT_FL    ,                                        
MFA-TR*             BANK_POST_DT       )                                        
MFA-TR*    VALUES (:RC-ACCOUNT-NO         ,                                     
MFA-TR*            :RC-BANK-ID            ,                                     
MFA-TR*            :RC-RETURN-CHK-AMT     ,                                     
MFA-TR*            :RC-CHECK-UTIL-AMT     ,                                     
MFA-TR*            :RC-CHECK-NONUTIL-AMT  ,                                     
MFA-TR*            :RC-CODE-AR-AGE        ,                                     
MFA-TR*            :RC-DRAWN-BY-NM        ,                                     
MFA-TR*            :RC-ENTERED-DT         ,                                     
MFA-TR*            :RC-ITEM-NO            ,                                     
MFA-TR*            :RC-NSF-CURRENCY-TYPE  ,                                     
MFA-TR*            :RC-NSF-REASON-CD      ,                                     
MFA-TR*            :RC-NSF-TIMESTAMP      ,                                     
MFA-TR*            :RC-NSC-REMOVE-FL      ,                                     
MFA-TR*            :RC-TRANS-HIST-SEQ-NO  ,                                     
MFA-TR*            :RC-SEND-NOTICE-CD     ,                                     
MFA-TR*            :RC-NSF-STATUS-CD      ,                                     
MFA-TR*            :RC-WAIVER-REASON-CD   ,                                     
MFA-TR*            :RC-COMMENTS-TX        ,                                     
MFA-TR*            :RC-NON-CIS-ACCT-NO    ,                                     
MFA-TR*            :RC-NON-CIS-GL-ACCT    ,                                     
MFA-TR*            :RC-PAYMENT-TYPE-TX    ,                                     
MFA-TR*            :RC-DATE-ORIG-PAYMT    ,                                     
MFA-TR*            :RC-ORIG-PYMT-OFFICE   ,                                     
MFA-TR*            :RC-PARTIAL-PYMT-FL    ,                                     
MFA-TR*            :RC-BANK-POST-DT       )                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE 'CSR02188'           TO ABEND-PROGRAM                
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_RETURN_CHK'     TO TABLE-1                      
              MOVE 'ENTERED_DT'         TO TABLE-ELEMENT-1              
              MOVE 'BANK_ID'            TO TABLE-ELEMENT-2              
              MOVE 'ITEM_NO'            TO TABLE-ELEMENT-3              
T16077        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-4              
              MOVE RC-ENTERED-DT        TO HOSTVAR-ELEMENT-1            
              MOVE RC-BANK-ID           TO HOSTVAR-ELEMENT-2            
              MOVE RC-ITEM-NO           TO HOSTVAR-ELEMENT-3            
T16077        MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * DELETE RECORD IN CSS_RETURN_CHK FOR RETURN CHECK ENTRY.     *           
      ***************************************************************           
                                                                        
       8200-DELETE-RET-CHK.                                             
           MOVE '8200' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
                DELETE FROM CSS_RETURN_CHK                              
                WHERE    ENTERED_DT         = IIF(TRY_CONVERT(DATE, 
                                                         :RC-ENTERED-DT
              ) IS NULL OR (PATINDEX('%.%', :RC-ENTERED-DT
              ) <> 0) OR (LEN(:RC-ENTERED-DT) <> 10), CIS.CHAR2DATE(
                                                         :RC-ENTERED-DT
              ), CONVERT(DATE, :RC-ENTERED-DT) )            
                AND      BANK_ID            = :RC-BANK-ID               
                AND      ITEM_NO            = :RC-ITEM-NO               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM CSS_RETURN_CHK                                      
MFA-TR*         WHERE    ENTERED_DT         = :RC-ENTERED-DT                    
MFA-TR*         AND      BANK_ID            = :RC-BANK-ID                       
MFA-TR*         AND      ITEM_NO            = :RC-ITEM-NO                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE 'CSR02188'           TO ABEND-PROGRAM                
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_RETURN_CHK'     TO TABLE-1                      
              MOVE 'ENTERED_DT'         TO TABLE-ELEMENT-1              
              MOVE 'BANK_ID'            TO TABLE-ELEMENT-2              
              MOVE 'ITEM_NO'            TO TABLE-ELEMENT-3              
T16077        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-4              
              MOVE RC-ENTERED-DT        TO HOSTVAR-ELEMENT-1            
              MOVE RC-BANK-ID           TO HOSTVAR-ELEMENT-2            
              MOVE RC-ITEM-NO           TO HOSTVAR-ELEMENT-3            
T16077        MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * UPDATE RECORD IN CSS_RETURN_CHK FOR RETURN AMOUNT.          *           
      ***************************************************************           
                                                                        
       8300-UPDATE-SUMMARY-ROW.                                         
                                                                        
           MOVE '8300' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
                UPDATE CSS_RETURN_CHK                                   
                   SET RETURN_CHK_AMT   = :RC-RETURN-CHK-AMT            
                WHERE  ENTERED_DT         = IIF(TRY_CONVERT(DATE, 
                                                         :RC-ENTERED-DT
              ) IS NULL OR (PATINDEX('%.%', :RC-ENTERED-DT
              ) <> 0) OR (LEN(:RC-ENTERED-DT) <> 10), CIS.CHAR2DATE(
                                                         :RC-ENTERED-DT
              ), CONVERT(DATE, :RC-ENTERED-DT) )              
                AND    BANK_ID            = :RC-BANK-ID                 
                AND    ITEM_NO            = 0                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         UPDATE CSS_RETURN_CHK                                           
MFA-TR*            SET RETURN_CHK_AMT   = :RC-RETURN-CHK-AMT                    
MFA-TR*         WHERE  ENTERED_DT         = :RC-ENTERED-DT                      
MFA-TR*         AND    BANK_ID            = :RC-BANK-ID                         
MFA-TR*         AND    ITEM_NO            = 0                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
              MOVE 'CSR02188'           TO ABEND-PROGRAM                
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_RETURN_CHK'     TO TABLE-1                      
              MOVE 'ENTERED_DT'         TO TABLE-ELEMENT-1              
              MOVE 'BANK_ID'            TO TABLE-ELEMENT-2              
CBSI          MOVE 'RETURN_CHK_AMT'     TO TABLE-ELEMENT-3              
T16077        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-4              
              MOVE RC-ENTERED-DT        TO HOSTVAR-ELEMENT-1            
              MOVE RC-BANK-ID           TO HOSTVAR-ELEMENT-2            
CBSI          MOVE RC-RETURN-CHK-AMT    TO HOSTVAR-ELEMENT-3-N          
T16077        MOVE AT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
HPCCDM*EJECT                                                                    
                                                                        
                                                                        
      ****************************************************************          
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ****************************************************************          
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
                                                                        
      ****************************************************************          
      *       END PROGRAM COPYLIB                                               
      ****************************************************************          
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPD00321                                                  
REARCH     END-EXEC.                                                            
                                                                        
