       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR02187.                                     
COB303 DATE-WRITTEN.                                                    
COB303            DECEMBER 08, 1995.                                    
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES LAST SIX MONTHS' PAYMENTS FOR AN       *        
      *  ACCOUNT FROM TRANSACTION HISTORY.                             *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  12/08/95    SS       CREATED.                                 *        
      *  04/30/96    SONALI   TPR#4043                                 *        
      *                       PREVIOUS DATE CALC WAS WRONG             *        
      *                       BLOCKED 5200- AND WRITTEN SQL TO CALC    *        
      *                       DATE 6 MONTHS BACK                       *        
      *  02/03/97    RPG      TPR# 9035                                *        
      *                       REMOVED THE ADDITION OF TOWN TO THE FULL *        
      *                       ADDRESS - MODULE 2600                    *        
      *  02/05/97    RPG      TPR# 8741                                *        
      *                       IN 2300, HAD RESULT SENT EVEN IN NO PMTS *        
      *                       WHERE FOUND                              *        
      *                                                                *        
      *  03/11/97    CSS      TPR9436 RESTRUCTURED AR TRANS HST DETAIL *        
      *                       CSR TO PREVENT WRITING DUPLICATE PAYMENTS*        
      *                                                                *        
T10077*  04/07/97    EMM      TPR10077 CHANGED THE AR-CURSOR TO        *        
      *                       RETRIEVE APPL_PROGRAM_ID, SO CONVERTED   *        
      *                       PAYMENTS DETAILS ARE NOT RETRIEVED.      *        
      *                                                                *        
T11902*  07/01/97    EMM      TPR11902 MODIFIED THE WHERE CLAUSE OF    *        
      *                       WAIVER-CURSOR - REMOVED BANK ID          *        
T12162*  08/12/97    EMS      TPR12162 WHEN THE ACCOUNT IS INACTIVE    *        
      *                       SENDING 400 BACK TO THE PANEL.           *        
T13003*  09/17/97    EMS      CHANGED THE AR-CURSOR TO RETRIEVE        *        
      *                       USER_ID -- USE TO USE APPL_PROGRAM_ID    *        
      *                       HOWEVER CONVERSION CHANGED THE CODE      *        
      *                       PLACED IN THIS FIELD.                    *        
T15450*  03/19/98    EMS      REMOVED THE CODE THAT IGNORED PAYMENTS   *        
      *                       CONVERTED FROM LEGACY.  CONVERSION IS    *        
      *                       NOW GOING TO ALWAYS DEFAULT THE CURRENCY *        
      *                       TYPE TO EITHER CHECK PAYMENT OR DRAFT    *        
      *                       PAYMENT FOR PAYMENT FROM LEGACY.         *        
T16719*  06/18/98    EMS      RETRIEVE PAYMENTS CONVERTED FROM         *        
      *                       LEGACY -- DEFAULT THESE PAYMENTS         *        
      *                       TO CURRENCY TYPE CHECK AND UTILITY.      *        
CBSI  *  10/23/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE   *         
CBSI  *              MADRAS   ABEND PARAMETERS                        *         
      *  04/09/01    CHANELLE MCR310. CSS_GL_ACCT_NO CHANGES.          *        
T25923*  03/26/02    SS19371  ADDING CASH_LOCAL_OFFICE TO BE RETURNED  *        
REARCH*  07/16/03    AD88124  RPC CONVERTED TO COBOL SP.               *        
C26296*  01/19/05    SS82048  ADD WAIVE_NOTICE TO THE RESULT SET       *        
T35434*  10/07/07    PA97450  REPLACED CSS_MODEL_SQL WITH SET STMTS   *         
T35434*                       AND ADDED FOR FETCH ONLY WITH UR FOR    *         
T35434*                       CURSOR SELECTS AND WITH UR FOR SINGELTON*         
T35434*                       SELECTS.                                *         
A03967*  15/03/11    SK42147  DISPLAY ADDITIONAL PAYMENT HISTORY      *         
A05058*  02/10/15    RB19957  1) CHANGE TO DISPLAY MONEY ORDERS IN    *         
A05058*     APPL00005058         ADDITION TO CHECKS AND DRAFTS.       *         
A05058*                       2) ADDED QUERY NUMBERS.                 *         
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02187'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02187 STARTS HERE'.                  
                                                                        
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBARHIST                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNSFHST                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBARHDT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBRETCHK                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBGLATNO                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CCA00001.                                                       
                                                                        
REARCH     EXEC SQL                                                             
REARCH          INCLUDE CWSX0010                                                
REARCH     END-EXEC.                                                            
                                                                        
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
REARCH     05  PARM-ACCOUNT-NO-TEMP    PIC X(13)  VALUE SPACES.         
REARCH     05  PARM-ACCOUNT-NO-RED     REDEFINES PARM-ACCOUNT-NO-TEMP   
REARCH                                 PIC 9(13).                       
REARCH     05  PARM-BANK-ID-TEMP       PIC X(06) VALUE SPACES.          
REARCH     05  PARM-BANK-ID-RED        REDEFINES PARM-BANK-ID-TEMP      
REARCH                                 PIC 9(06).                       
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-SUB                      PIC S9(8) COMP VALUE 0.          
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME            PIC X(08) VALUE 'CSR02187'.      
REARCH     05  WS-SQLSTATE             PIC X(05) VALUE '     '.         
           05  WS-INSERT-RETURN-CODE   PIC S9(9) VALUE +000 COMP.       
           05  WS-ACCOUNT-NO           PIC 9(13) VALUE ZERO.            
           05  WS-ACCOUNT-NO-NUM       PIC S9(13) COMP-3 VALUE ZERO.    
           05  WS-BANK-ID-NUM          PIC S9(6) COMP-3 VALUE 0.        
           05  WS-PYMT-PRIORITY-LVL    PIC S9(02) COMP VALUE +50.       
           05  WS-GLED-ACCT-NO         PIC S9(3)V9999 COMP-3 VALUE 0.   
           05  WS-GLED-ACCT-NO-X       PIC 999.9999.                    
           05  WS-GLED-ACCT-NAME       PIC X(10) VALUE SPACES.          
           05  WS-SEARCH-ACCT-NAME     PIC X(10) VALUE SPACES.          
           05  WS-TOTAL-AMT-C          PIC S9(9)V99 COMP-3 VALUE 0.     
           05  WS-UTILITY-AMT-C        PIC S9(9)V99 COMP-3 VALUE 0.     
           05  WS-NON-UTILITY-AMT-C    PIC S9(9)V99 COMP-3 VALUE 0.     
           05  WS-TOTAL-AMT-D          PIC S9(9)V99 COMP-3 VALUE 0.     
           05  WS-UTILITY-AMT-D        PIC S9(9)V99 COMP-3 VALUE 0.     
           05  WS-NON-UTILITY-AMT-D    PIC S9(9)V99 COMP-3 VALUE 0.     
           05  WS-CURRENT-DATE.                                         
               10 WS-CURRENT-YYYY      PIC 9(04).                       
               10 WS-DASH-1            PIC X(01) VALUE '-'.             
               10 WS-CURRENT-MM        PIC 9(02).                       
               10 WS-DASH-2            PIC X(01) VALUE '-'.             
               10 WS-CURRENT-DD        PIC 9(02).                       
           05  WS-CURRENT-DATE-C REDEFINES WS-CURRENT-DATE PIC X(10).   
           05  WS-PREV-DATE.                                            
               10 WS-PREV-YYYY         PIC 9(04).                       
               10 WS-DASH-1            PIC X(01) VALUE '-'.             
               10 WS-PREV-MM           PIC 9(02).                       
               10 WS-DASH-2            PIC X(01) VALUE '-'.             
               10 WS-PREV-DD           PIC 9(02).                       
           05  WS-PREV-DATE-C REDEFINES WS-PREV-DATE PIC X(10).         
           05  CURRENT-DATE            PIC X(10).                       
           05  WS-MAX-SZ               PIC S9(4).                       
           05  WS-LENGTH               PIC S9(4).                       
           05  WS-FROM.                                                 
               10 WS-FROM-X            OCCURS 51 TIMES PIC X.           
           05  WS-ADDRESS.                                              
               10 WS-ADDRESS-X         OCCURS 50 TIMES                  
                                       INDEXED BY WS-ADD-SUB.           
                  15 FILLER            PIC X.                           
           05  WS-ADD-SUB-CNT          PIC 99 VALUE 1.                  
           05  WS-ZIP.                                                  
               10 WS-ZIP-CODE          PIC X(5).                        
               10 WS-ZIP-CODE-PLUS-4   PIC X(4).                        
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                  PIC X(01)  VALUE 'Y'.            
           05  WS-NO                   PIC X(01)  VALUE 'N'.            
           05  WS-ACTIVE-CODE          PIC X(01)  VALUE 'A'.            
           05  EXISTS-SW               PIC X(01) VALUE 'N'.             
               88 EXISTS-YES                      VALUE 'Y'.            
               88 EXISTS-NO                       VALUE 'N'.            
T9852      05  WS-PAYMENTS-EXIST       PIC X(01)  VALUE 'N'.            
                                                                        
       01  WS-NUMERIC.                                                  
           05  WS-100                  PIC S9(9) COMP VALUE +100.       
           05  WS-200                  PIC S9(9) COMP VALUE +200.       
           05  WS-300                  PIC S9(9) COMP VALUE +300.       
T12162     05  WS-400                  PIC S9(9) COMP VALUE +400.       
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05  WS-EPP-OFFER-DATE-NI    PIC S9(04) COMP VALUE 0.         
                                                                        
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME               PIC X(18) VALUE SPACES.          
REARCH     10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
REARCH     10  S-SQLSTATE              PIC X(5)  VALUE ' '.             
REARCH     10  S-TABLE-NAME            PIC X(18) VALUE SPACES.          
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
REARCH         49  S-HOST-VARIABLES-V  PIC X(255).                      
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-STATEMENT-V   PIC X(255).                      
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-DESCRIPTION-V PIC X(255).                      
                                                                        
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  GTT-NAME                PIC X(26) VALUE                  
REARCH                                     'SESSION.CSR02187_R1'.       
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN          PIC S9(04) COMP.                 
REARCH         49 GTT-ROW-CHAR         PIC X(1024).                     
REARCH     05  GTT-SQLCODE             PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-TRANS-HST-SEQ-NO     PIC X(26) VALUE SPACES.          
           05  RS-TOTAL-AMT            PIC S9(9)V99 COMP-3 VALUE 0.     
           05  RS-UTILITY-AMT          PIC S9(9)V99 COMP-3 VALUE 0.     
           05  RS-NON-UTILITY-AMT      PIC S9(9)V99 COMP-3 VALUE 0.     
           05  RS-CURRENCY-TYPE        PIC X(1) VALUE SPACES.           
C35671     05  RS-NAME                 PIC X(70) VALUE SPACES.          
           05  RS-ADDRESS              PIC X(50) VALUE SPACES.          
           05  RS-ZIP-CODE             PIC X(9) VALUE SPACES.           
           05  RS-TOWN                 PIC X(26) VALUE SPACES.          
           05  RS-STATE                PIC X(2) VALUE SPACES.           
           05  RS-CUSTOMER-NO          PIC S9(10)V COMP-3 VALUE 0.      
           05  RS-PENDING-WAIVER       PIC X(01) VALUE 'N'.             
           05  RS-RETURN-CHECK-AMT     PIC S9(9)V99 COMP-3 VALUE 0.     
           05  RS-NSF-TIMESTMP         PIC X(26) VALUE SPACES.          
           05  RS-ACCT-XFER-TO         PIC S9(13)V COMP-3 VALUE 0.      
           05  RS-CASH-LOCAL-OFFICE    PIC X(3) VALUE SPACES.           
C26296     05  RS-WAIVE-NOTICE         PIC X(01) VALUE SPACES.          
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
REARCH     05  S-TRANS-HST-SEQ-NO      PIC X(26) VALUE SPACES.          
REARCH     05  S-TOTAL-AMT             PIC S9(9)V99 COMP-3 VALUE 0.     
REARCH     05  S-UTILITY-AMT           PIC S9(9)V99 COMP-3 VALUE 0.     
REARCH     05  S-NON-UTILITY-AMT       PIC S9(9)V99 COMP-3 VALUE 0.     
REARCH     05  S-CURRENCY-TYPE         PIC X(1) VALUE SPACES.           
C35671     05  S-NAME                  PIC X(70) VALUE SPACES.          
REARCH     05  S-ADDRESS               PIC X(50) VALUE SPACES.          
REARCH     05  S-ZIP-CODE              PIC X(9) VALUE SPACES.           
REARCH     05  S-TOWN                  PIC X(26) VALUE SPACES.          
REARCH     05  S-STATE                 PIC X(2) VALUE SPACES.           
REARCH     05  S-CUSTOMER-NO           PIC S9(10)V COMP-3 VALUE 0.      
REARCH     05  S-PENDING-WAIVER        PIC X(01) VALUE 'N'.             
REARCH     05  S-RETURN-CHECK-AMT      PIC S9(9)V99 COMP-3 VALUE 0.     
REARCH     05  S-NSF-TIMESTMP          PIC X(26) VALUE SPACES.          
REARCH     05  S-ACCT-XFER-TO          PIC S9(13)V COMP-3 VALUE 0.      
REARCH     05  S-CASH-LOCAL-OFFICE     PIC X(3) VALUE SPACES.           
C26296     05  S-WAIVE-NOTICE          PIC X(01) VALUE SPACES.          
                                                                        
                                                                        
       01  CN-CONSTANTS.                                                
           05  CN-DELIMITER            PIC X VALUE ';'.                 
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
REARCH LINKAGE SECTION.                                                 
REARCH*                                                                         
REARCH 01  PARM-ACCOUNT-NO             PIC X(13).                       
REARCH 01  PARM-BANK-ID                PIC X(06).                       
REARCH 01  PARM-ENTERED-DT             PIC X(10).                       
                                                                        
      ******************************************************************        
      *    DECLARE CURSOR TO RETRIEVE TRANSACTION HISTORY HEADER       *        
      *    FOR LAST SIX MONTHS' PAYMENTS                               *        
      ******************************************************************        
           EXEC SQL DECLARE AR-CURSOR CURSOR FOR                        
              SELECT CIS.CHAR2$DATE(DATE_TRANS, 'USA'),                         
                     REPLACE(REPLACE(CONVERT(CHAR(26), TRANS_HIST_SEQ_NO
           , 121), ' ', '-'), ':', '.') TRANS_HIST_SEQ_NO,                     
T13003               USER_ID,                                           
T25923               CASH_LOCAL_OFFICE                                  
                FROM CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                    
               WHERE ACCOUNT_NO        = :AR-ACCOUNT-NO                 
                 AND CODE_TRAN_TYPE    = 'P'                            
                 AND PYMT_REFUNDED_IND <> 'Y'                           
                 AND DATE_TRANS        > IIF(TRY_CONVERT(DATE, 
                                                         :AR-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-TRANS
              ) <> 0) OR (LEN(:AR-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :AR-DATE-TRANS
              ), CONVERT(DATE, :AR-DATE-TRANS) )                 
            ORDER BY TRANS_HIST_SEQ_NO DESC                             
T35434      FOR READ ONLY                                       
A05058                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE AR-CURSOR CURSOR FOR                                
MFA-TR*       SELECT CHAR(DATE_TRANS, USA),                                     
MFA-TR*              TRANS_HIST_SEQ_NO,                                         
MFA-TR*              USER_ID,                                                   
MFA-TR*              CASH_LOCAL_OFFICE                                          
MFA-TR*         FROM CSS_AR_TRANS_HIST                                          
MFA-TR*        WHERE ACCOUNT_NO        = :AR-ACCOUNT-NO                         
MFA-TR*          AND CODE_TRAN_TYPE    = 'P'                                    
MFA-TR*          AND PYMT_REFUNDED_IND <> 'Y'                                   
MFA-TR*          AND DATE_TRANS        > :AR-DATE-TRANS                         
MFA-TR*     ORDER BY TRANS_HIST_SEQ_NO DESC                                     
MFA-TR*     FOR FETCH ONLY WITH UR                                              
MFA-TR*     QUERYNO 7000                                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DECLARE CURSOR TO RETRIEVE PAYMENTS FROM TRANSACTION        *        
      *    HISTORY DETAIL FOR CURRENCY TYPE = CHECK OR DRAFT           *        
      ******************************************************************        
           EXEC SQL DECLARE AU-CURSOR CURSOR FOR                        
              SELECT AMT_POSTED,                                        
                     CURRENCY_TYPE,                                     
                     GL_ACCT_CREDIT,                                    
                     GL_ACCT_DEBIT                                      
                FROM CSS_AR_TRN_HST_DET WITH(READUNCOMMITTED)                   
               WHERE ACCOUNT_NO        = :AU-ACCOUNT-NO                 
                 AND TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :AU-TRANS-HIST-SEQ-NO
              )          
A05058           AND CURRENCY_TYPE IN ('C','D','M')                     
T35434           FOR READ ONLY                                  
A05058                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL DECLARE AU-CURSOR CURSOR FOR                                
MFA-TR*       SELECT AMT_POSTED,                                                
MFA-TR*              CURRENCY_TYPE,                                             
MFA-TR*              GL_ACCT_CREDIT,                                            
MFA-TR*              GL_ACCT_DEBIT                                              
MFA-TR*         FROM CSS_AR_TRN_HST_DET                                         
MFA-TR*        WHERE ACCOUNT_NO        = :AU-ACCOUNT-NO                         
MFA-TR*          AND TRANS_HIST_SEQ_NO = :AU-TRANS-HIST-SEQ-NO                  
MFA-TR*          AND CURRENCY_TYPE IN ('C','D','M')                             
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*     QUERYNO 7310                                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    DECLARE CURSOR TO RETRIEVE PAYMENTS FROM TRANSACTION        *        
      *    HISTORY DETAIL FOR CONVERTED PAYMENTS.                      *        
      ******************************************************************        
T16719     EXEC SQL DECLARE AU-CURSOR-CONV CURSOR FOR                   
              SELECT AMT_POSTED,                                        
                     CURRENCY_TYPE,                                     
                     GL_ACCT_CREDIT,                                    
                     GL_ACCT_DEBIT                                      
                FROM CSS_AR_TRN_HST_DET WITH(READUNCOMMITTED)                   
               WHERE ACCOUNT_NO        = :AU-ACCOUNT-NO                 
                 AND TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :AU-TRANS-HIST-SEQ-NO
              )          
T35434           FOR READ ONLY                                  
A05058                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL DECLARE AU-CURSOR-CONV CURSOR FOR                           
MFA-TR*       SELECT AMT_POSTED,                                                
MFA-TR*              CURRENCY_TYPE,                                             
MFA-TR*              GL_ACCT_CREDIT,                                            
MFA-TR*              GL_ACCT_DEBIT                                              
MFA-TR*         FROM CSS_AR_TRN_HST_DET                                         
MFA-TR*        WHERE ACCOUNT_NO        = :AU-ACCOUNT-NO                         
MFA-TR*          AND TRANS_HIST_SEQ_NO = :AU-TRANS-HIST-SEQ-NO                  
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*     QUERYNO 7410                                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    DECLARE CURSOR TO CHECK FOR PENDING WAIVER FOR THE ACCOUNT *         
      *    AND THE BANK                                               *         
      *****************************************************************         
           EXEC SQL DECLARE WAIVER-CURSOR CURSOR FOR                    
               SELECT RETURN_CHECK_AMT,REPLACE(REPLACE(CONVERT(
           CHAR(26), NSF_TIMESTMP, 121), ' ', '-'), ':', '.') 
           NSF_TIMESTMP                     
C26296               ,SEND_NOTICE_CD                                    
               FROM   CSS_NSF_HIST WITH(READUNCOMMITTED)                        
               WHERE  ACCOUNT_NO     = :NH-ACCOUNT-NO                   
               AND    NSF_STATUS_CD  = 'P'                              
T35434         FOR READ ONLY                                    
A05058                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE WAIVER-CURSOR CURSOR FOR                            
MFA-TR*        SELECT RETURN_CHECK_AMT,NSF_TIMESTMP                             
MFA-TR*              ,SEND_NOTICE_CD                                            
MFA-TR*        FROM   CSS_NSF_HIST                                              
MFA-TR*        WHERE  ACCOUNT_NO     = :NH-ACCOUNT-NO                           
MFA-TR*        AND    NSF_STATUS_CD  = 'P'                                      
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*     QUERYNO 7820                                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *    DECLARE CURSOR TO CHECK FOR EXISTING PENDING WAIVER FOR    *         
      *    ACCOUNT USED IN RETURN CHECK HISTORY                       *         
      *****************************************************************         
           EXEC SQL DECLARE RETCHK-CURSOR CURSOR FOR                    
               SELECT 'Y'                                               
               FROM   CSS_RETURN_CHK WITH(READUNCOMMITTED)                      
               WHERE  ENTERED_DT     = IIF(TRY_CONVERT(DATE, 
                                                         :RC-ENTERED-DT
              ) IS NULL OR (PATINDEX('%.%', :RC-ENTERED-DT
              ) <> 0) OR (LEN(:RC-ENTERED-DT) <> 10), CIS.CHAR2DATE(
                                                         :RC-ENTERED-DT
              ), CONVERT(DATE, :RC-ENTERED-DT) )                   
               AND    BANK_ID        = :RC-BANK-ID                      
               AND    ACCOUNT_NO     = :RC-ACCOUNT-NO                   
               AND    NSC_REMOVE_FL  = 'Y'                              
T35434         FOR READ ONLY                                    
A05058                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL DECLARE RETCHK-CURSOR CURSOR FOR                            
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*        FROM   CSS_RETURN_CHK                                            
MFA-TR*        WHERE  ENTERED_DT     = :RC-ENTERED-DT                           
MFA-TR*        AND    BANK_ID        = :RC-BANK-ID                              
MFA-TR*        AND    ACCOUNT_NO     = :RC-ACCOUNT-NO                           
MFA-TR*        AND    NSC_REMOVE_FL  = 'Y'                                      
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*     QUERYNO 7860                                                        
MFA-TR*    END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                                    
REARCH PROCEDURE DIVISION USING  PARM-ACCOUNT-NO                        
REARCH                          ,PARM-BANK-ID                           
REARCH                          ,PARM-ENTERED-DT.                       
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
REARCH*                                                                         
REARCH     PERFORM 0100A-DECLARE-GTT    THRU 0100A-EXIT.                
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH                                                                  
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARCH             *                                                    
REARCH         FROM                                                     
REARCH             #CSR02187_R1                                  
REARCH                                                                  
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*            *                                                            
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR02187_R1                                          
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            
REARCH*                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
REARCH*                                                                         
REARCH******************************************************************        
REARCH* 0100A-DECLARE-GTT                                              *        
REARCH*                                                                *        
REARCH*     DECLARING GLOBAL TEMPORARY TABLE AND CHECKING TO DELETE    *        
REARCH*     GTT ROWS IF IT EXISTS.                                     *        
REARCH*                                                                *        
REARCH******************************************************************        
REARCH*                                                                         
REARCH 0100A-DECLARE-GTT.                                               
REARCH*                                                                         
REARCH     MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR02187_R1'            
REARCH                                   TO S-SQL-STATEMENT-V.          
REARCH     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02187_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02187_R1
              (                                                        
REARCH           RETURN_CODE          INT                           
REARCH          ,TRANS_HST_SEQ_NO CHAR(26)  COLLATE 
                              LATIN1_GENERAL_100_BIN2                          
REARCH          ,TOTAL_AMT            DECIMAL(11,2)                     
REARCH          ,UTILITY_AMT          DECIMAL(11,2)                     
REARCH          ,NON_UTILITY_AMT      DECIMAL(11,2)                     
REARCH          ,CURRENCY_TYPE CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH          ,NAME CHAR(70)  COLLATE LATIN1_GENERAL_100_BIN2                 
REARCH          ,ADDRESS CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2              
REARCH          ,ZIP_CODE CHAR(9)  COLLATE LATIN1_GENERAL_100_BIN2              
REARCH          ,TOWN CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2                 
REARCH          ,STATE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2                
REARCH          ,CUSTOMER_NO          DECIMAL(10,0)                     
REARCH          ,PENDING_WAIVER CHAR(01)  COLLATE 
                              LATIN1_GENERAL_100_BIN2                          
REARCH          ,RETURN_CHECK_AMT     DECIMAL(11,2)                     
REARCH          ,NSF_TIMESTMP CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH          ,ACCT_XFER_TO         DECIMAL(13,0)                     
REARCH          ,CASH_LOCAL_OFFICE CHAR(03)  COLLATE 
                              LATIN1_GENERAL_100_BIN2                          
C26296          ,WAIVE_NOTICE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH         )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH     MOVE SQLSTATE                 TO WS-SQLSTATE.                
REARCH     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
REARCH*                                                                         
REARCH        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
REARCH        OR WS-SQLSTATE = '42710'                                  
REARCH           NEXT SENTENCE                                          
REARCH        ELSE                                                      
REARCH           MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
REARCH           MOVE SQLCODE            TO ABEND-SQLCODE               
REARCH           MOVE SQLSTATE           TO ABEND-SQLSTATE              
REARCH           MOVE '0100A'            TO ACTIVE-PARAGRAPH            
REARCH           MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
REARCH           MOVE SPACES             TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH           MOVE 'CSR02187_R1'      TO TABLE-1                     
REARCH           MOVE SPACES             TO TABLE-ELEMENT-1             
REARCH           MOVE SPACES             TO HOSTVAR-ELEMENT-1           
REARCH           PERFORM 9900-SQL-ERROR-ROUTINE                         
REARCH                                   THRU  9900-EXIT                
REARCH        END-IF.                                                   
REARCH*                                                                         
REARCH 0100A-EXIT.                                                      
REARCH      EXIT.                                                       
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
REARCH     MOVE PARM-ACCOUNT-NO           TO PARM-ACCOUNT-NO-TEMP.      
           MOVE PARM-ACCOUNT-NO-RED       TO WS-ACCOUNT-NO.             
           MOVE WS-ACCOUNT-NO             TO WS-ACCOUNT-NO-NUM.         
REARCH     MOVE PARM-BANK-ID              TO PARM-BANK-ID-TEMP.         
           MOVE PARM-BANK-ID-RED          TO WS-BANK-ID-NUM.            
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 2200-BUILD-RESULT     THRU 2200-EXIT.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
REARCH*****************************************************************         
REARCH*                                                               *         
REARCH* 2000A-MOVE-RESULT.                                            *         
REARCH*                                                               *         
REARCH*****************************************************************         
REARCH*                                                                         
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE RS-RETURN-CODE           TO S-RETURN-CODE               
REARCH     MOVE RS-TRANS-HST-SEQ-NO      TO S-TRANS-HST-SEQ-NO          
REARCH     MOVE RS-TOTAL-AMT             TO S-TOTAL-AMT                 
REARCH     MOVE RS-UTILITY-AMT           TO S-UTILITY-AMT               
REARCH     MOVE RS-NON-UTILITY-AMT       TO S-NON-UTILITY-AMT           
REARCH     MOVE RS-CURRENCY-TYPE         TO S-CURRENCY-TYPE             
REARCH     MOVE RS-NAME                  TO S-NAME                      
REARCH     MOVE RS-ADDRESS               TO S-ADDRESS                   
REARCH     MOVE RS-ZIP-CODE              TO S-ZIP-CODE                  
REARCH     MOVE RS-TOWN                  TO S-TOWN                      
REARCH     MOVE RS-STATE                 TO S-STATE                     
REARCH     MOVE RS-CUSTOMER-NO           TO S-CUSTOMER-NO               
REARCH     MOVE RS-PENDING-WAIVER        TO S-PENDING-WAIVER            
REARCH     MOVE RS-RETURN-CHECK-AMT      TO S-RETURN-CHECK-AMT          
REARCH     MOVE RS-NSF-TIMESTMP          TO S-NSF-TIMESTMP              
REARCH     MOVE RS-ACCT-XFER-TO          TO S-ACCT-XFER-TO              
REARCH     MOVE RS-CASH-LOCAL-OFFICE     TO S-CASH-LOCAL-OFFICE.        
C26296     MOVE RS-WAIVE-NOTICE          TO S-WAIVE-NOTICE.             
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      ******************************************************************        
       2200-BUILD-RESULT.                                               
                                                                        
           MOVE WS-ACCOUNT-NO-NUM       TO AT-ACCOUNT-NO                
                                           AR-ACCOUNT-NO                
                                           AU-ACCOUNT-NO                
                                           HT-ACCOUNT-NO                
                                           NH-ACCOUNT-NO                
                                           RC-ACCOUNT-NO.               
           MOVE WS-BANK-ID-NUM          TO NH-BANK-ID                   
                                           RC-BANK-ID.                  
           MOVE PARM-ENTERED-DT         TO RC-ENTERED-DT.               
           PERFORM 7700-SELECT-ACCOUNT           THRU 7700-EXIT.        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE WS-300                TO RS-RETURN-CODE              
REARCH        PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT        
              PERFORM 8100-SEND-RESULT           THRU 8100-EXIT         
              GO TO 2200-EXIT                                           
           END-IF.                                                      
           MOVE AT-CUSTOMER-NO           TO RS-CUSTOMER-NO.             
           IF AT-ACCT-XFER-TO GREATER THAN 0                            
              MOVE AT-ACCT-XFER-TO       TO RS-ACCT-XFER-TO             
           ELSE                                                         
              MOVE 0                     TO RS-ACCT-XFER-TO             
           END-IF.                                                      
                                                                        
           PERFORM 7720-GET-NAME                 THRU 7720-EXIT.        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE WS-200                TO RS-RETURN-CODE              
REARCH        PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT        
              PERFORM 8100-SEND-RESULT           THRU 8100-EXIT         
              GO TO 2200-EXIT                                           
           END-IF.                                                      
                                                                        
           PERFORM 7730-GET-ADDRESS              THRU 7730-EXIT.        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE WS-200                TO RS-RETURN-CODE              
REARCH        PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT        
              PERFORM 8100-SEND-RESULT           THRU 8100-EXIT         
              GO TO 2200-EXIT                                           
           END-IF.                                                      
                                                                        
           MOVE DY-ZIP-CODE              TO A4-ZIP-CODE.                
           MOVE DY-ZIP-CODE-TOKEN        TO A4-ZIP-CODE-TOKEN.          
           PERFORM 7740-GET-CITY-STATE           THRU 7740-EXIT.        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE WS-200                TO RS-RETURN-CODE              
REARCH        PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT        
              PERFORM 8100-SEND-RESULT           THRU 8100-EXIT         
              GO TO 2200-EXIT                                           
           END-IF.                                                      
                                                                        
           MOVE DY-ZIP-CODE               TO WS-ZIP-CODE.               
           MOVE DY-ZIP-CODE-PLUS-FOUR     TO WS-ZIP-CODE-PLUS-4.        
           MOVE WS-ZIP                    TO RS-ZIP-CODE.               
           MOVE A4-TOWN                   TO RS-TOWN.                   
           MOVE A4-STATE                  TO RS-STATE.                  
                                                                        
           PERFORM 2500-BUILD-NAME               THRU 2500-EXIT.        
           PERFORM 2600-BUILD-ADDR-FORM          THRU 2600-EXIT.        
      *                                                                         
T12162     IF AT-CODE-ACCT-STAT = 'J'                                   
               MOVE WS-400                TO RS-RETURN-CODE             
REARCH         PERFORM 2000A-MOVE-RESULT         THRU 2000A-EXIT        
               PERFORM 8100-SEND-RESULT          THRU 8100-EXIT         
               GO TO 2200-EXIT                                          
           END-IF.                                                      
                                                                        
           PERFORM 5100-GET-TIMESTAMP-AND-DATE   THRU 5100-EXIT.        
           MOVE WS-CURRENT-DATE-C      TO CURRENT-DATE.                 
                                                                        
           PERFORM 7810-OPEN-PENDING-WAIVER      THRU 7810-EXIT.        
           PERFORM 7820-FETCH-PENDING-WAIVER     THRU 7820-EXIT.        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              PERFORM 7850-OPEN-RETCHK-CURSOR    THRU 7850-EXIT         
              PERFORM 7860-FETCH-RETCHK-CURSOR   THRU 7860-EXIT         
              PERFORM 7870-CLOSE-RETCHK-CURSOR   THRU 7870-EXIT         
              IF EXISTS-NO                                              
                 MOVE 'Y'                 TO RS-PENDING-WAIVER          
                 MOVE NH-RETURN-CHECK-AMT TO RS-RETURN-CHECK-AMT        
                 MOVE NH-NSF-TIMESTMP     TO RS-NSF-TIMESTMP            
C26296           IF  NH-SEND-NOTICE-CD = 'N'                            
C26296               MOVE 'Y'             TO RS-WAIVE-NOTICE            
C26296           ELSE                                                   
C26296               MOVE 'N'             TO RS-WAIVE-NOTICE            
C26296           END-IF                                                 
              END-IF                                                    
           END-IF.                                                      
           PERFORM 7830-CLOSE-PENDING-WAIVER     THRU 7830-EXIT.        
                                                                        
T9852      MOVE WS-N                      TO WS-PAYMENTS-EXIST.         
      *                                                                         
           MOVE WS-PREV-DATE-C            TO AR-DATE-TRANS.             
           PERFORM 7100-OPEN-AR-CURSOR           THRU 7100-EXIT.        
TP9436     PERFORM 7000-FETCH-AR-CURSOR          THRU 7000-EXIT.        
      *                                                                         
           PERFORM 2300-PROCESS-HEADER           THRU 2300-EXIT         
              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                  
      *                                                                         
           PERFORM 7200-CLOSE-AR-CURSOR          THRU 7200-EXIT.        
      *                                                                         
T9852      IF WS-PAYMENTS-EXIST = WS-NO                                 
T10077        MOVE 'C'                    TO RS-CURRENCY-TYPE           
REARCH        PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT        
T9852         PERFORM 8100-SEND-RESULT           THRU 8100-EXIT         
T9852      END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2300-PROCESS-HEADER                                            *        
      ******************************************************************        
      *                                                                         
       2300-PROCESS-HEADER.                                             
      *                                                                         
           MOVE AR-TRANS-HIST-SEQ-NO  TO AU-TRANS-HIST-SEQ-NO           
      *                                                                         
T16719     IF AR-USER-ID = 'CONVERS'                                    
               PERFORM 7400-OPEN-AU-CURSOR-CONV       THRU 7400-EXIT    
               PERFORM 7410-FETCH-AU-CURSOR-CONV      THRU 7410-EXIT    
               PERFORM 2350-PROCESS-DETAIL-CONV       THRU 2350-EXIT    
                  UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND           
               PERFORM 7420-CLOSE-AU-CURSOR-CONV      THRU 7420-EXIT    
               MOVE 'C'               TO AU-CURRENCY-TYPE               
           ELSE                                                         
               PERFORM 7300-OPEN-AU-CURSOR            THRU 7300-EXIT    
               PERFORM 7310-FETCH-AU-CURSOR           THRU 7310-EXIT    
               PERFORM 2400-PROCESS-DETAIL            THRU 2400-EXIT    
                  UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND           
               PERFORM 7320-CLOSE-AU-CURSOR           THRU 7320-EXIT    
           END-IF.                                                      
      *                                                                         
T9872      IF WS-TOTAL-AMT-C > 0                                        
               MOVE AR-TRANS-HIST-SEQ-NO TO RS-TRANS-HST-SEQ-NO         
               MOVE AU-CURRENCY-TYPE     TO RS-CURRENCY-TYPE            
               MOVE WS-TOTAL-AMT-C       TO RS-TOTAL-AMT                
               MOVE WS-UTILITY-AMT-C     TO RS-UTILITY-AMT              
               MOVE WS-NON-UTILITY-AMT-C TO RS-NON-UTILITY-AMT          
               MOVE AR-CASH-LOCAL-OFFICE TO RS-CASH-LOCAL-OFFICE        
REARCH         PERFORM 2000A-MOVE-RESULT             THRU 2000A-EXIT    
               PERFORM 8100-SEND-RESULT              THRU 8100-EXIT     
T9852          MOVE WS-YES               TO WS-PAYMENTS-EXIST           
           END-IF                                                       
      *                                                                         
T9872      IF WS-TOTAL-AMT-D > 0                                        
               MOVE AR-TRANS-HIST-SEQ-NO TO RS-TRANS-HST-SEQ-NO         
               MOVE AU-CURRENCY-TYPE     TO RS-CURRENCY-TYPE            
               MOVE WS-TOTAL-AMT-D       TO RS-TOTAL-AMT                
               MOVE WS-UTILITY-AMT-D     TO RS-UTILITY-AMT              
               MOVE WS-NON-UTILITY-AMT-D TO RS-NON-UTILITY-AMT          
               MOVE AR-CASH-LOCAL-OFFICE TO RS-CASH-LOCAL-OFFICE        
REARCH         PERFORM 2000A-MOVE-RESULT             THRU 2000A-EXIT    
               PERFORM 8100-SEND-RESULT              THRU 8100-EXIT     
T9852          MOVE WS-YES               TO WS-PAYMENTS-EXIST           
           END-IF                                                       
      *                                                                         
T9872      INITIALIZE  WS-TOTAL-AMT-C                                   
                       WS-TOTAL-AMT-D                                   
                       WS-UTILITY-AMT-C                                 
                       WS-UTILITY-AMT-D                                 
                       WS-NON-UTILITY-AMT-C                             
                       WS-NON-UTILITY-AMT-D                             
      *                                                                         
           PERFORM 7000-FETCH-AR-CURSOR                 THRU 7000-EXIT. 
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2350-PROCESS-DETAIL-CONV    --PROCESS CONVERTED PAYMENTS       *        
      ******************************************************************        
      *                                                                         
T16719 2350-PROCESS-DETAIL-CONV.                                        
                                                                        
           ADD AU-AMT-POSTED          TO WS-TOTAL-AMT-C                 
      *                                                                         
           MOVE AU-GL-ACCT-CREDIT     TO WS-GLED-ACCT-NO.               
           PERFORM 7600-GET-GL-NAME                   THRU 7600-EXIT.   
           PERFORM 5250-GET-BREAKUP-CONV              THRU 5250-EXIT.   
                                                                        
           PERFORM 7410-FETCH-AU-CURSOR-CONV          THRU 7410-EXIT.   
      *                                                                         
       2350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2400-PROCESS-DETAIL -- NON CONVERTED PAYMENTS                  *        
      ******************************************************************        
      *                                                                         
       2400-PROCESS-DETAIL.                                             
      *                                                                         
           IF AU-CURRENCY-TYPE EQUAL 'C'                                
              ADD AU-AMT-POSTED       TO WS-TOTAL-AMT-C                 
           ELSE                                                         
              ADD AU-AMT-POSTED       TO WS-TOTAL-AMT-D                 
           END-IF.                                                      
      *                                                                         
           MOVE AU-GL-ACCT-CREDIT     TO WS-GLED-ACCT-NO.               
      *                                                                         
           PERFORM 7600-GET-GL-NAME                   THRU 7600-EXIT.   
           PERFORM 5300-GET-BREAKUP                   THRU 5300-EXIT.   
      *                                                                         
           PERFORM 7310-FETCH-AU-CURSOR               THRU 7310-EXIT.   
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2500-BUILD-NAME                                               *         
      *                                                               *         
      *      CONCATENATE FIRST, MIDDLE AND LAST NAME INTO A SINGLE    *         
      *      STRING TO BE SENT AS RESULT SET                          *         
      *****************************************************************         
      *                                                                         
       2500-BUILD-NAME.                                                 
                                                                        
           MOVE SPACES                 TO RS-NAME.                      
           IF DQ-NAME-FORMAT = 'I'                                      
               MOVE DQ-LAST-NAME TO WS-FROM                             
               PERFORM 2510-PROCESS-FROM-STRING                         
               MOVE WS-FROM TO DQ-LAST-NAME                             
                                                                        
               MOVE DQ-FIRST-NAME TO WS-FROM                            
               PERFORM 2510-PROCESS-FROM-STRING                         
               MOVE WS-FROM TO DQ-FIRST-NAME                            
                                                                        
               IF DQ-MIDDLE-NAME NOT = SPACE                            
                   MOVE DQ-MIDDLE-NAME TO WS-FROM                       
                   PERFORM 2510-PROCESS-FROM-STRING                     
                   MOVE WS-FROM TO DQ-MIDDLE-NAME                       
               END-IF                                                   
                                                                        
               MOVE DQ-TITLE-SUFFIX-1 TO WS-FROM                        
               PERFORM 2510-PROCESS-FROM-STRING                         
               MOVE WS-FROM TO DQ-TITLE-SUFFIX-1                        
                                                                        
               IF DQ-MIDDLE-NAME = SPACE                                
                   STRING DQ-LAST-NAME DELIMITED CN-DELIMITER           
                          ', ' DELIMITED SIZE                           
                          DQ-FIRST-NAME DELIMITED CN-DELIMITER          
                          ' ' DELIMITED SIZE                            
                          DQ-TITLE-SUFFIX-1 DELIMITED CN-DELIMITER      
                     INTO RS-NAME                                       
                   END-STRING                                           
               ELSE                                                     
                   STRING DQ-LAST-NAME DELIMITED CN-DELIMITER           
                          ', ' DELIMITED SIZE                           
                          DQ-FIRST-NAME DELIMITED CN-DELIMITER          
                          ' ' DELIMITED SIZE                            
                          DQ-MIDDLE-NAME DELIMITED CN-DELIMITER         
                          ' ' DELIMITED SIZE                            
                          DQ-TITLE-SUFFIX-1 DELIMITED CN-DELIMITER      
                     INTO RS-NAME                                       
                   END-STRING                                           
               END-IF                                                   
           ELSE                                                         
               MOVE DQ-FULL-NAME     TO RS-NAME                         
           END-IF.                                                      
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2510-PROCESS-FROM-STRING                                       *        
      *                                                                *        
      *     DETERMINE LENGTH OF FIELD. PLACE DELIMITER AFTER THE LAST  *        
      *     NON-SPACE CHARACTER TO BE USED LATER IN STRING STATEMENT.  *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2510-PROCESS-FROM-STRING.                                        
                                                                        
           PERFORM                                                      
               VARYING WS-SUB FROM 51 BY -1                             
                 UNTIL WS-SUB < 1                                       
                    OR WS-FROM-X (WS-SUB) NOT = SPACE                   
           END-PERFORM.                                                 
           ADD 1             TO WS-SUB.                                 
           MOVE CN-DELIMITER TO WS-FROM-X (WS-SUB).                     
                                                                        
       2510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2600-BUILD-ADDR-FORM                                          *         
      *                                                               *         
      *      CONCATENATE ALL ADDRESS DETAILS INTO A SINGLE            *         
      *      STRING TO BE SENT AS RESULT SET                          *         
      *****************************************************************         
                                                                        
       2600-BUILD-ADDR-FORM.                                            
                                                                        
           MOVE SPACE TO WS-ADDRESS.                                    
           SET WS-ADD-SUB TO 1.                                         
           MOVE +1     TO WS-ADD-SUB-CNT.                               
                                                                        
           IF DY-ADDR-USAGE-CD = 'I'                                    
               MOVE DY-STREET-NAME           TO WS-FROM                 
               MOVE LENGTH OF DY-STREET-NAME TO WS-MAX-SZ               
               PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT      
                                                                        
               MOVE '&' TO WS-FROM                                      
               MOVE 1   TO WS-MAX-SZ                                    
               PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT      
                                                                        
               MOVE DY-ADDRESS-OVERFLOW           TO WS-FROM            
               MOVE LENGTH OF DY-ADDRESS-OVERFLOW TO WS-MAX-SZ          
               PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT      
           ELSE                                                         
               MOVE SPACE TO WS-ADDRESS                                 
                                                                        
               SET WS-ADD-SUB TO 1                                      
                                                                        
               IF DY-HOUSE-NO NOT = SPACE                               
                   MOVE DY-HOUSE-NO           TO WS-FROM                
                   MOVE LENGTH OF DY-HOUSE-NO TO WS-MAX-SZ              
                   PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT  
               END-IF                                                   
                                                                        
               IF DY-ADDR-PREFIX-1 NOT = SPACE                          
                   MOVE DY-ADDR-PREFIX-1           TO WS-FROM           
                   MOVE LENGTH OF DY-ADDR-PREFIX-1 TO WS-MAX-SZ         
                   PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT  
               END-IF                                                   
                                                                        
               IF DY-ADDR-PREFIX-2 NOT = SPACE                          
                   MOVE DY-ADDR-PREFIX-2           TO WS-FROM           
                   MOVE LENGTH OF DY-ADDR-PREFIX-2 TO WS-MAX-SZ         
                   PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT  
               END-IF                                                   
                                                                        
               IF DY-STREET-NAME NOT = SPACE                            
                   MOVE DY-STREET-NAME           TO WS-FROM             
                   MOVE LENGTH OF DY-STREET-NAME TO WS-MAX-SZ           
                   PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT  
               END-IF                                                   
                                                                        
               IF DY-STREET-SUFFIX NOT = SPACE                          
                   MOVE DY-STREET-SUFFIX           TO WS-FROM           
                   MOVE LENGTH OF DY-STREET-SUFFIX TO WS-MAX-SZ         
                   PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT  
               END-IF                                                   
                                                                        
               IF DY-STREET-LOCATION-1 NOT = SPACE                      
                   MOVE DY-STREET-LOCATION-1           TO WS-FROM       
                   MOVE LENGTH OF DY-STREET-LOCATION-1 TO WS-MAX-SZ     
                   PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT  
               END-IF                                                   
                                                                        
               IF DY-STREET-LOCATION-2 NOT = SPACE                      
                   MOVE DY-STREET-LOCATION-2           TO WS-FROM       
                   MOVE LENGTH OF DY-STREET-LOCATION-2 TO WS-MAX-SZ     
                   PERFORM 2620-ACCUMULATE-ADDRESS      THRU 2620-EXIT  
               END-IF                                                   
                                                                        
           END-IF.                                                      
                                                                        
           MOVE WS-ADDRESS           TO RS-ADDRESS.                     
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2620-ACCUMULATE-ADDRESS                                        *        
      *                                                                *        
      *     DETERMINE LENGTH OF FIELD. MOVE THAT MANY CHARACTERS ON TO *        
      *     THE FORMATTED ADDRESS FIELD.                               *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2620-ACCUMULATE-ADDRESS.                                         
                                                                        
           PERFORM                                                      
               VARYING WS-LENGTH FROM WS-MAX-SZ BY -1                   
                 UNTIL WS-LENGTH < 1                                    
                    OR WS-FROM-X (WS-LENGTH) NOT = SPACE                
           END-PERFORM.                                                 
                                                                        
           PERFORM                                                      
               VARYING WS-SUB FROM 1 BY 1                               
                 UNTIL WS-SUB > WS-LENGTH OR WS-ADD-SUB-CNT = 50        
                   MOVE WS-FROM-X (WS-SUB)                              
                        TO WS-ADDRESS-X (WS-ADD-SUB)                    
                   SET WS-ADD-SUB UP BY 1                               
                   ADD +1    TO WS-ADD-SUB-CNT                          
           END-PERFORM.                                                 
                                                                        
           SET WS-ADD-SUB UP BY 1.                                      
           ADD +1    TO WS-ADD-SUB-CNT.                                 
                                                                        
       2620-EXIT.                                                       
           EXIT.                                                        
                                                                        
HPCCDM*EJECT.                                                                   
                                                                        
      ****************************************************************          
      * 5100-GET-TIMESTAMP-AND-DATE                                  *          
      ****************************************************************          
       5100-GET-TIMESTAMP-AND-DATE.                                     
                                                                        
           EXEC SQL                                                     
T35434         SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              DATEADD( MONTH, -12, CAST(SYSDATETIMEOFFSET() AS DATE) )
            INTO
              :WS-CURRENT-DATE-C,
              :WS-PREV-DATE-C          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-DATE-C = CURRENT DATE ,                          
MFA-TR*            :WS-PREV-DATE-C  = CURRENT DATE - 12 MONTHS                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF (SQLCODE NOT EQUAL TO SUCCESSFUL-CALL)                    
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5100'                TO ACTIVE-PARAGRAPH            
T35434        MOVE 'SET'                 TO ABEND-FUNCTION              
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
CBSI          MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5250-GET-BREAKUP-CONV                                          *        
      ******************************************************************        
T16719 5250-GET-BREAKUP-CONV.                                           
      *                                                                         
           IF WS-GLED-ACCT-NAME EQUAL 'AR-LPC'                          
                                   OR 'AR-UTE'                          
                                   OR 'AR-UTG'                          
                                   OR 'AR-BUD'                          
                                   OR 'AR-CCC'                          
                                   OR 'AR-DFA'                          
                                   OR 'AR-CIA'                          
                                   OR 'AR-DEP'                          
                                   OR 'AR-NSA'                          
                                   OR 'AR-NSC'                          
                                   OR 'AR-ADJ'                          
                                   OR 'AR-ADV'                          
               ADD AU-AMT-POSTED      TO WS-UTILITY-AMT-C               
           ELSE                                                         
               ADD AU-AMT-POSTED      TO WS-NON-UTILITY-AMT-C           
           END-IF.                                                      
      *                                                                         
       5250-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5300-GET-BREAKUP                                               *        
      ******************************************************************        
       5300-GET-BREAKUP.                                                
                                                                        
           IF WS-GLED-ACCT-NAME   EQUAL 'AR-LPC'                        
                                     OR 'AR-UTE'                        
                                     OR 'AR-UTG'                        
                                     OR 'AR-BUD'                        
                                     OR 'AR-CCC'                        
                                     OR 'AR-DFA'                        
                                     OR 'AR-CIA'                        
                                     OR 'AR-DEP'                        
                                     OR 'AR-NSA'                        
                                     OR 'AR-NSC'                        
                                     OR 'AR-ADJ'                        
                                     OR 'AR-ADV'                        
              IF AU-CURRENCY-TYPE EQUAL 'C'                             
                 ADD AU-AMT-POSTED      TO WS-UTILITY-AMT-C             
              ELSE                                                      
                 ADD AU-AMT-POSTED      TO WS-UTILITY-AMT-D
              END-IF             
           ELSE                                                         
              IF AU-CURRENCY-TYPE EQUAL 'C'                             
                 ADD AU-AMT-POSTED      TO WS-NON-UTILITY-AMT-C         
              ELSE                                                      
                 ADD AU-AMT-POSTED      TO WS-NON-UTILITY-AMT-D
              END-IF
           END-IF.        
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
                                                                        
HPCCDM*EJECT.                                                                   
                                                                        
      ******************************************************************        
      * 7000-FETCH-AR-CURSOR                                       *            
      ******************************************************************        
       7000-FETCH-AR-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
              FETCH AR-CURSOR                                           
               INTO :AR-DATE-TRANS,                                     
                    :AR-TRANS-HIST-SEQ-NO,                              
T13003              :AR-USER-ID,                                        
T25923              :AR-CASH-LOCAL-OFFICE                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7000'          TO ACTIVE-PARAGRAPH                  
CBSI          MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'CSS_AR_TRANS_HIST'  TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_TRAN_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'PYMT_REFUNDED_IND'  TO TABLE-ELEMENT-3              
CBSI          MOVE 'DATE_TRANS'         TO TABLE-ELEMENT-4              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              MOVE 'P'                  TO HOSTVAR-ELEMENT-2            
              MOVE 'N'                  TO HOSTVAR-ELEMENT-3            
CBSI          MOVE AR-DATE-TRANS        TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7100-OPEN-AR-CURSOR                                            *        
      ******************************************************************        
       7100-OPEN-AR-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
              OPEN AR-CURSOR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7100'          TO ACTIVE-PARAGRAPH                  
CBSI          MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE 'CSS_AR_TRANS_HIST'  TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_TRAN_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'PYMT_REFUNDED_IND'  TO TABLE-ELEMENT-3              
CBSI          MOVE 'DATE_TRANS'         TO TABLE-ELEMENT-4              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              MOVE 'P'                  TO HOSTVAR-ELEMENT-2            
              MOVE 'N'                  TO HOSTVAR-ELEMENT-3            
CBSI          MOVE AR-DATE-TRANS        TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7200-CLOSE-AR-CURSOR                                           *        
      ******************************************************************        
       7200-CLOSE-AR-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
              CLOSE AR-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7200'          TO ACTIVE-PARAGRAPH                  
CBSI          MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE 'CSS_AR_TANS_HIST'   TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'CODE_TRAN_TYPE'     TO TABLE-ELEMENT-2              
              MOVE 'PYMT_REFUNDED_IND'  TO TABLE-ELEMENT-3              
CBSI          MOVE 'DATE_TRANS'         TO TABLE-ELEMENT-4              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              MOVE 'P'                  TO HOSTVAR-ELEMENT-2            
              MOVE 'N'                  TO HOSTVAR-ELEMENT-3            
CBSI          MOVE AR-DATE-TRANS        TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7300-OPEN-AU-CURSOR                                            *        
      ******************************************************************        
       7300-OPEN-AU-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
              OPEN AU-CURSOR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7300'          TO ACTIVE-PARAGRAPH                  
CBSI          MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE 'CSS_AR_TRANS_HIST'  TO TABLE-1                      
              MOVE 'TRANS_HIST_SEQ_NO'  TO TABLE-ELEMENT-1              
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE AU-TRANS-HIST-SEQ-NO TO HOSTVAR-ELEMENT-1            
CBSI          MOVE AU-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7310-FETCH-AU-CURSOR                                       *            
      ******************************************************************        
       7310-FETCH-AU-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
              FETCH AU-CURSOR                                           
               INTO :AU-AMT-POSTED         ,                            
                    :AU-CURRENCY-TYPE      ,                            
                    :AU-GL-ACCT-CREDIT     ,                            
                    :AU-GL-ACCT-DEBIT                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7310'          TO ACTIVE-PARAGRAPH                  
CBSI          MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'CSS_AR_TRANS_HIST'  TO TABLE-1                      
              MOVE 'TRANS_HIST_SEQ_NO'  TO TABLE-ELEMENT-1              
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE AU-TRANS-HIST-SEQ-NO TO HOSTVAR-ELEMENT-1            
CBSI          MOVE AU-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7320-CLOSE-AU-CURSOR                                           *        
      ******************************************************************        
      *                                                                         
       7320-CLOSE-AU-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
              CLOSE AU-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7320'          TO ACTIVE-PARAGRAPH                  
CBSI          MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE 'CSS_AR_TANS_HIST'   TO TABLE-1                      
              MOVE 'TRANS_HIST_SEQ_NO'  TO TABLE-ELEMENT-1              
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE AU-TRANS-HIST-SEQ-NO TO HOSTVAR-ELEMENT-1            
CBSI          MOVE AU-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7400-OPEN-AU-CURSOR-CONV                                       *        
      ******************************************************************        
       7400-OPEN-AU-CURSOR-CONV.                                        
                                                                        
           EXEC SQL                                                     
              OPEN AU-CURSOR-CONV                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7400'                 TO ACTIVE-PARAGRAPH           
CBSI          MOVE 'OPEN'                 TO ABEND-FUNCTION             
CBSI          MOVE 'CSS_AR_TRN_HST_DET'   TO TABLE-1                    
              MOVE 'TRANS_HIST_SEQ_NO'    TO TABLE-ELEMENT-1            
CBSI          MOVE ' ACCOUNT_NO '         TO TABLE-ELEMENT-2            
              MOVE AU-TRANS-HIST-SEQ-NO   TO HOSTVAR-ELEMENT-1          
CBSI          MOVE AU-ACCOUNT-NO          TO HOSTVAR-ELEMENT-2          
              PERFORM 9000-SEND-ERROR-RESULT          THRU 9000-EXIT    
              PERFORM 9900-SQL-ERROR-ROUTINE          THRU 9900-EXIT    
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7410-FETCH-AU-CURSOR-CONV                                  *            
      ******************************************************************        
       7410-FETCH-AU-CURSOR-CONV.                                       
                                                                        
           EXEC SQL                                                     
              FETCH AU-CURSOR-CONV                                      
               INTO :AU-AMT-POSTED         ,                            
                    :AU-CURRENCY-TYPE      ,                            
                    :AU-GL-ACCT-CREDIT     ,                            
                    :AU-GL-ACCT-DEBIT                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7410'                    TO ACTIVE-PARAGRAPH        
CBSI          MOVE 'FETCH'                   TO ABEND-FUNCTION          
CBSI          MOVE 'CSS_AR_TRN_HST_DET'      TO TABLE-1                 
              MOVE 'TRANS_HIST_SEQ_NO'       TO TABLE-ELEMENT-1         
CBSI          MOVE ' ACCOUNT_NO '            TO TABLE-ELEMENT-2         
              MOVE AU-TRANS-HIST-SEQ-NO      TO HOSTVAR-ELEMENT-1       
CBSI          MOVE AU-ACCOUNT-NO             TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT          THRU 9000-EXIT    
              PERFORM 9900-SQL-ERROR-ROUTINE          THRU 9900-EXIT    
           END-IF.                                                      
                                                                        
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7420-CLOSE-AU-CURSOR-CONV                                      *        
      ******************************************************************        
      *                                                                         
       7420-CLOSE-AU-CURSOR-CONV.                                       
                                                                        
           EXEC SQL                                                     
              CLOSE AU-CURSOR-CONV                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7420'          TO ACTIVE-PARAGRAPH                  
CBSI          MOVE 'CLOSE'                   TO ABEND-FUNCTION          
CBSI          MOVE 'CSS_AR_TRN_HST_DET' TO TABLE-1                      
              MOVE 'TRANS_HIST_SEQ_NO'  TO TABLE-ELEMENT-1              
CBSI          MOVE ' ACCOUNT_NO '       TO TABLE-ELEMENT-2              
              MOVE AU-TRANS-HIST-SEQ-NO TO HOSTVAR-ELEMENT-1            
CBSI          MOVE AU-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7600-GET-GL-NAME                                               *        
      ******************************************************************        
       7600-GET-GL-NAME.                                                
                                                                        
           MOVE AT-COMPANY-NO      TO GO-COMPANY-NO.                    
           MOVE WS-GLED-ACCT-NO    TO GO-GL-ACCT-NO.                    
                                                                        
           EXEC SQL                                                     
              SELECT GL_ACCT_NAME                                       
                INTO :GO-GL-ACCT-NAME                                   
                FROM CSS_GL_ACCT_NO WITH(READUNCOMMITTED)                       
MCR310         WHERE COMPANY_NO = '01'                                  
                 AND GL_ACCT_NO = :GO-GL-ACCT-NO                        
T35434                                                           
A05058                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT GL_ACCT_NAME                                               
MFA-TR*         INTO :GO-GL-ACCT-NAME                                           
MFA-TR*         FROM CSS_GL_ACCT_NO                                             
MFA-TR*        WHERE COMPANY_NO = '01'                                          
MFA-TR*          AND GL_ACCT_NO = :GO-GL-ACCT-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7600                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE GO-GL-ACCT-NAME TO WS-GLED-ACCT-NAME                 
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7600'          TO ACTIVE-PARAGRAPH                  
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_GL_ACCT_NO'     TO TABLE-1                      
              MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1              
              MOVE 'GL_ACCT_NO'         TO TABLE-ELEMENT-2              
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-3              
              MOVE '01'                 TO HOSTVAR-ELEMENT-1            
              MOVE GO-GL-ACCT-NO        TO WS-GLED-ACCT-NO-X            
              MOVE WS-GLED-ACCT-NO-X    TO HOSTVAR-ELEMENT-2            
CBSI          MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7700-SELECT-ACCOUNT                                           *         
      *****************************************************************         
       7700-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT COMPANY_NO, CUSTOMER_NO ,                          
                     PREMISE_NO, ACCT_XFER_TO,                          
T12162               CODE_ACCT_STAT                                     
                INTO :AT-COMPANY-NO, :AT-CUSTOMER-NO,                   
                     :AT-PREMISE-NO, :AT-ACCT-XFER-TO,                  
T12162               :AT-CODE-ACCT-STAT                                 
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
T35434                                                           
A05058                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COMPANY_NO, CUSTOMER_NO ,                                  
MFA-TR*              PREMISE_NO, ACCT_XFER_TO,                                  
MFA-TR*              CODE_ACCT_STAT                                             
MFA-TR*         INTO :AT-COMPANY-NO, :AT-CUSTOMER-NO,                           
MFA-TR*              :AT-PREMISE-NO, :AT-ACCT-XFER-TO,                          
MFA-TR*              :AT-CODE-ACCT-STAT                                         
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7700                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7700'          TO ACTIVE-PARAGRAPH                  
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCOUNT'        TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7720-GET-NAME                                                 *         
      *****************************************************************         
       7720-GET-NAME.                                                   
                                                                        
           EXEC SQL                                                     
              SELECT DQ.FULL_NAME, DQ.FIRST_NAME,                       
                     DQ.MIDDLE_NAME, DQ.LAST_NAME,                      
                     DQ.TITLE_PREFIX, DQ.TITLE_SUFFIX_1,                
                     DQ.TITLE_SUFFIX_2, DQ.NAME_FORMAT                  
                INTO :DQ-FULL-NAME, :DQ-FIRST-NAME,                     
                     :DQ-MIDDLE-NAME, :DQ-LAST-NAME,                    
                     :DQ-TITLE-PREFIX, :DQ-TITLE-SUFFIX-1,              
                     :DQ-TITLE-SUFFIX-2, :DQ-NAME-FORMAT                
                FROM CSS_NAME_ACCT_XREF HT
                           WITH(READUNCOMMITTED), CSS_NAME DQ
                           WITH(READUNCOMMITTED)                 
               WHERE HT.ACCOUNT_NO = :HT-ACCOUNT-NO                     
                 AND HT.NAME_ID    = DQ.NAME_ID                         
                 AND HT.CUSTOMER_ROLE_CD = ' '                          
                 AND DQ.NAME_TYPE  = 'CN'                               
T35434                                                           
A05058                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DQ.FULL_NAME, DQ.FIRST_NAME,                               
MFA-TR*              DQ.MIDDLE_NAME, DQ.LAST_NAME,                              
MFA-TR*              DQ.TITLE_PREFIX, DQ.TITLE_SUFFIX_1,                        
MFA-TR*              DQ.TITLE_SUFFIX_2, DQ.NAME_FORMAT                          
MFA-TR*         INTO :DQ-FULL-NAME, :DQ-FIRST-NAME,                             
MFA-TR*              :DQ-MIDDLE-NAME, :DQ-LAST-NAME,                            
MFA-TR*              :DQ-TITLE-PREFIX, :DQ-TITLE-SUFFIX-1,                      
MFA-TR*              :DQ-TITLE-SUFFIX-2, :DQ-NAME-FORMAT                        
MFA-TR*         FROM CSS_NAME_ACCT_XREF HT, CSS_NAME DQ                         
MFA-TR*        WHERE HT.ACCOUNT_NO = :HT-ACCOUNT-NO                             
MFA-TR*          AND HT.NAME_ID    = DQ.NAME_ID                                 
MFA-TR*          AND HT.CUSTOMER_ROLE_CD = ' '                                  
MFA-TR*          AND DQ.NAME_TYPE  = 'CN'                                       
MFA-TR*          WITH UR                                                        
MFA-TR*     QUERYNO 7720                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7720'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_NAME'           TO TABLE-1                      
              MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-2                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE HT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7720-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7730-GET-ADDRESS                                              *         
      *****************************************************************         
       7730-GET-ADDRESS.                                                
                                                                        
           EXEC SQL                                                     
              SELECT DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,                
                     DY.ADDR_SUFFIX, DY.HOUSE_NO, DY.ADDR_USAGE_CD,     
                     DY.STREET_LOCATION_1, DY.STREET_LOCATION_2,        
                     DY.STREET_NAME, DY.STREET_SUFFIX,                  
                     DY.ADDRESS_OVERFLOW, DY.ZIP_CODE,                  
                     DY.ZIP_CODE_PLUS_FOUR, DY.ZIP_CODE_TOKEN           
                INTO :DY-ADDR-PREFIX-1, :DY-ADDR-PREFIX-2,              
                     :DY-ADDR-SUFFIX, :DY-HOUSE-NO, :DY-ADDR-USAGE-CD,  
                     :DY-STREET-LOCATION-1, :DY-STREET-LOCATION-2,      
                     :DY-STREET-NAME, :DY-STREET-SUFFIX,                
                     :DY-ADDRESS-OVERFLOW, :DY-ZIP-CODE,                
                     :DY-ZIP-CODE-PLUS-FOUR, :DY-ZIP-CODE-TOKEN         
                FROM CSS_PREMISE PR
                           WITH(READUNCOMMITTED), CSS_ADDR_FORMATTED DY
                           WITH(READUNCOMMITTED)              
               WHERE PR.PREMISE_NO    = :AT-PREMISE-NO                  
                 AND PR.ADDRESS_ID    = DY.ADDRESS_ID                   
                 AND DY.ADDR_USAGE_CD = 'F'                             
T35434                                                           
A05058                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,                        
MFA-TR*              DY.ADDR_SUFFIX, DY.HOUSE_NO, DY.ADDR_USAGE_CD,             
MFA-TR*              DY.STREET_LOCATION_1, DY.STREET_LOCATION_2,                
MFA-TR*              DY.STREET_NAME, DY.STREET_SUFFIX,                          
MFA-TR*              DY.ADDRESS_OVERFLOW, DY.ZIP_CODE,                          
MFA-TR*              DY.ZIP_CODE_PLUS_FOUR, DY.ZIP_CODE_TOKEN                   
MFA-TR*         INTO :DY-ADDR-PREFIX-1, :DY-ADDR-PREFIX-2,                      
MFA-TR*              :DY-ADDR-SUFFIX, :DY-HOUSE-NO, :DY-ADDR-USAGE-CD,          
MFA-TR*              :DY-STREET-LOCATION-1, :DY-STREET-LOCATION-2,              
MFA-TR*              :DY-STREET-NAME, :DY-STREET-SUFFIX,                        
MFA-TR*              :DY-ADDRESS-OVERFLOW, :DY-ZIP-CODE,                        
MFA-TR*              :DY-ZIP-CODE-PLUS-FOUR, :DY-ZIP-CODE-TOKEN                 
MFA-TR*         FROM CSS_PREMISE PR, CSS_ADDR_FORMATTED DY                      
MFA-TR*        WHERE PR.PREMISE_NO    = :AT-PREMISE-NO                          
MFA-TR*          AND PR.ADDRESS_ID    = DY.ADDRESS_ID                           
MFA-TR*          AND DY.ADDR_USAGE_CD = 'F'                                     
MFA-TR*          WITH UR                                                        
MFA-TR*     QUERYNO 7730                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7730'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_PREMISE'        TO TABLE-1                      
              MOVE 'CSS_ADDR_FORMATTED' TO TABLE-2                      
              MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE AT-PREMISE-NO        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7730-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7740-GET-CITY-STATE                                           *         
      *****************************************************************         
       7740-GET-CITY-STATE.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TOWN, STATE                                        
                INTO :A4-TOWN, :A4-STATE                                
                FROM CSS_ZIP_CODE WITH(READUNCOMMITTED)                         
               WHERE ZIP_CODE       = :A4-ZIP-CODE                      
                 AND ZIP_CODE_TOKEN = :A4-ZIP-CODE-TOKEN                
T35434                                                           
A05058                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT TOWN, STATE                                                
MFA-TR*         INTO :A4-TOWN, :A4-STATE                                        
MFA-TR*         FROM CSS_ZIP_CODE                                               
MFA-TR*        WHERE ZIP_CODE       = :A4-ZIP-CODE                              
MFA-TR*          AND ZIP_CODE_TOKEN = :A4-ZIP-CODE-TOKEN                        
MFA-TR*          WITH UR                                                        
MFA-TR*     QUERYNO 7740                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7740'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ZIP_CODE'       TO TABLE-1                      
              MOVE 'ZIP_CODE'           TO TABLE-ELEMENT-1              
              MOVE 'ZIP_CODE_TOKEN'     TO TABLE-ELEMENT-2              
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-3              
              MOVE A4-ZIP-CODE          TO HOSTVAR-ELEMENT-1            
              MOVE A4-ZIP-CODE-TOKEN    TO HOSTVAR-ELEMENT-2            
CBSI          MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7740-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7810-OPEN-PENDING-WAIVER                                      *         
      *****************************************************************         
       7810-OPEN-PENDING-WAIVER.                                        
                                                                        
           MOVE '7810' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
               OPEN WAIVER-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CBSI          MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE 'CSS_NSF_HIST'       TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE NH-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7810-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7820-FETCH-PENDING-WAIVER                                     *         
      *****************************************************************         
       7820-FETCH-PENDING-WAIVER.                                       
                                                                        
           MOVE '7820' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
               FETCH WAIVER-CURSOR                                      
               INTO  :NH-RETURN-CHECK-AMT,:NH-NSF-TIMESTMP              
C26296              ,:NH-SEND-NOTICE-CD                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CBSI          MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'CSS_NSF_HIST'       TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE NH-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7820-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7830-CLOSE-PENDING-WAIVER                                     *         
      *****************************************************************         
       7830-CLOSE-PENDING-WAIVER.                                       
                                                                        
           MOVE '7830' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
               CLOSE WAIVER-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CBSI          MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE 'CSS_NSF_HIST'       TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE NH-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7830-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7850-OPEN-RETCHK-CURSOR                                       *         
      *****************************************************************         
       7850-OPEN-RETCHK-CURSOR.                                         
                                                                        
           MOVE '7850' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
               OPEN RETCHK-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CBSI          MOVE 'OPEN'               TO ABEND-FUNCTION               
              MOVE 'CSS_RETURN_CHK'     TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'BANK_ID'            TO TABLE-ELEMENT-2              
CBSI          MOVE 'ENTERED_DT'         TO TABLE-ELEMENT-3              
              MOVE RC-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE RC-BANK-ID           TO HOSTVAR-ELEMENT-2            
CBSI          MOVE RC-ENTERED-DT        TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7850-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7860-FETCH-RETCHK-CURSOR                                      *         
      *****************************************************************         
       7860-FETCH-RETCHK-CURSOR.                                        
                                                                        
           MOVE '7860' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
               FETCH RETCHK-CURSOR                                      
               INTO  :EXISTS-SW                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
                 MOVE 'N'               TO EXISTS-SW                    
              ELSE                                                      
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
CBSI             MOVE 'FETCH'              TO ABEND-FUNCTION            
                 MOVE 'CSS_RETURN_CHK'     TO TABLE-1                   
                 MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1           
                 MOVE 'BANK_ID'            TO TABLE-ELEMENT-2           
CBSI             MOVE 'ENTERED_DT'         TO TABLE-ELEMENT-3           
                 MOVE RC-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1         
                 MOVE RC-BANK-ID           TO HOSTVAR-ELEMENT-2         
CBSI             MOVE RC-ENTERED-DT        TO HOSTVAR-ELEMENT-3         
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7860-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 7870-CLOSE-RETCHK-CURSOR                                      *         
      *****************************************************************         
       7870-CLOSE-RETCHK-CURSOR.                                        
                                                                        
           MOVE '7870' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
               CLOSE RETCHK-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CBSI          MOVE 'CLOSE'              TO ABEND-FUNCTION               
              MOVE 'CSS_RETURN_CHK'     TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'BANK_ID'            TO TABLE-ELEMENT-2              
CBSI          MOVE 'ENTERED_DT'         TO TABLE-ELEMENT-3              
              MOVE RC-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE RC-BANK-ID           TO HOSTVAR-ELEMENT-2            
CBSI          MOVE RC-ENTERED-DT        TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7870-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
     *                                                                  
           EXEC SQL                                                     
REARCH         INSERT INTO #CSR02187_R1                          
REARCH          (RETURN_CODE                                            
REARCH          ,TRANS_HST_SEQ_NO                                       
REARCH          ,TOTAL_AMT                                              
REARCH          ,UTILITY_AMT                                            
REARCH          ,NON_UTILITY_AMT                                        
REARCH          ,CURRENCY_TYPE                                          
REARCH          ,NAME                                                   
REARCH          ,ADDRESS                                                
REARCH          ,ZIP_CODE                                               
REARCH          ,TOWN                                                   
REARCH          ,STATE                                                  
REARCH          ,CUSTOMER_NO                                            
REARCH          ,PENDING_WAIVER                                         
REARCH          ,RETURN_CHECK_AMT                                       
REARCH          ,NSF_TIMESTMP                                           
REARCH          ,ACCT_XFER_TO                                           
REARCH*         ,CASH_LOCAL_OFFICE)                                             
C26296          ,CASH_LOCAL_OFFICE                                      
C26296          ,WAIVE_NOTICE)                                          
REARCH         VALUES                                                   
REARCH          (:S-RETURN-CODE                                         
REARCH          ,:S-TRANS-HST-SEQ-NO                                    
REARCH          ,:S-TOTAL-AMT                                           
REARCH          ,:S-UTILITY-AMT                                         
REARCH          ,:S-NON-UTILITY-AMT                                     
REARCH          ,:S-CURRENCY-TYPE                                       
REARCH          ,:S-NAME                                                
REARCH          ,:S-ADDRESS                                             
REARCH          ,:S-ZIP-CODE                                            
REARCH          ,:S-TOWN                                                
REARCH          ,:S-STATE                                               
REARCH          ,:S-CUSTOMER-NO                                         
REARCH          ,:S-PENDING-WAIVER                                      
REARCH          ,:S-RETURN-CHECK-AMT                                    
REARCH          ,:S-NSF-TIMESTMP                                        
REARCH          ,:S-ACCT-XFER-TO                                        
REARCH          ,:S-CASH-LOCAL-OFFICE                                   
C26296          ,:S-WAIVE-NOTICE                                        
REARCH          )                                                       
REARCH      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO SESSION.CSR02187_R1                                  
MFA-TR*         (RETURN_CODE                                                    
MFA-TR*         ,TRANS_HST_SEQ_NO                                               
MFA-TR*         ,TOTAL_AMT                                                      
MFA-TR*         ,UTILITY_AMT                                                    
MFA-TR*         ,NON_UTILITY_AMT                                                
MFA-TR*         ,CURRENCY_TYPE                                                  
MFA-TR*         ,NAME                                                           
MFA-TR*         ,ADDRESS                                                        
MFA-TR*         ,ZIP_CODE                                                       
MFA-TR*         ,TOWN                                                           
MFA-TR*         ,STATE                                                          
MFA-TR*         ,CUSTOMER_NO                                                    
MFA-TR*         ,PENDING_WAIVER                                                 
MFA-TR*         ,RETURN_CHECK_AMT                                               
MFA-TR*         ,NSF_TIMESTMP                                                   
MFA-TR*         ,ACCT_XFER_TO                                                   
MFA-TR*         ,CASH_LOCAL_OFFICE)                                             
MFA-TR*         ,CASH_LOCAL_OFFICE                                              
MFA-TR*         ,WAIVE_NOTICE)                                                  
MFA-TR*        VALUES                                                           
MFA-TR*         (:S-RETURN-CODE                                                 
MFA-TR*         ,:S-TRANS-HST-SEQ-NO                                            
MFA-TR*         ,:S-TOTAL-AMT                                                   
MFA-TR*         ,:S-UTILITY-AMT                                                 
MFA-TR*         ,:S-NON-UTILITY-AMT                                             
MFA-TR*         ,:S-CURRENCY-TYPE                                               
MFA-TR*         ,:S-NAME                                                        
MFA-TR*         ,:S-ADDRESS                                                     
MFA-TR*         ,:S-ZIP-CODE                                                    
MFA-TR*         ,:S-TOWN                                                        
MFA-TR*         ,:S-STATE                                                       
MFA-TR*         ,:S-CUSTOMER-NO                                                 
MFA-TR*         ,:S-PENDING-WAIVER                                              
MFA-TR*         ,:S-RETURN-CHECK-AMT                                            
MFA-TR*         ,:S-NSF-TIMESTMP                                                
MFA-TR*         ,:S-ACCT-XFER-TO                                                
MFA-TR*         ,:S-CASH-LOCAL-OFFICE                                           
MFA-TR*         ,:S-WAIVE-NOTICE                                                
MFA-TR*         )                                                               
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
REARCH      MOVE SQLCODE TO WS-INSERT-RETURN-CODE.                      
      *                                                                         
REARCH      IF WS-INSERT-RETURN-CODE = SUCCESSFUL-CALL                  
               ADD +1 TO CTR-ROWS                                       
REARCH      ELSE                                                        
REARCH         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
REARCH         MOVE '8100'               TO ACTIVE-PARAGRAPH            
REARCH         MOVE 'INSERT'             TO ABEND-FUNCTION              
REARCH         MOVE SPACES               TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH         MOVE 'CSR02187_R1'        TO TABLE-1                     
REARCH         MOVE SPACES               TO TABLE-ELEMENT-1             
REARCH         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
REARCH         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
REARCH     END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
                                                                        
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPD00320                                                  
REARCH     END-EXEC.                                                            
                                                                        
