       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR02186.                                     
COB303 DATE-WRITTEN.                                                    
COB303            DECEMBER 06, 1995.                                    
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES ALL BANKS AND THE RETURN CHECKS FOR    *        
      *  EACH BANK.                                                    *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  12/06/95    SS       CREATED.                                 *        
      *                                                                *        
T12491*  08/27/97    EMS      ONLY RETRIEVE BANKS WHERE                *        
      *                       FCS_DEP_BANK_CD > SPACES                 *        
T15430*  03/19/98    AMG      INITIALIZED DRAWN-BY-NM IN 7300 BEFORE   *        
      *                       THE FETCH TO BE SURE THAT IT IS CLEANED  *        
      *                       OUT SINCE IT IS A VARCHAR.               *        
T16212*  05/05/98    EMS      RETURN THE FIELD CASH BANK ID AND STATE  *        
      *                       STATE CODE                               *        
CBSI  *  09/23/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *              MADRAS   ABEND PARAMETERS                         *        
T21109*  02/01/00    CBSI     ADDED AT-LAST-UPDT-TS TO THE RESULT SET  *        
T21109*              MADRAS                                            *        
T22450*  07/11/00    CBSI     TIME/DATE STAMP LOGIC HAD BEEN REMOVED   *        
T22450*              MADRAS   OUT                                      *        
T22767*  06/07/01    COVANSYS CURSOR FOR HANDLING NON-CIS-ACCT         *        
T22767*              MADRAS                                            *        
T25270*  09/25/01    BASKAR   FIX THE DRWN_BY_NM INITIALIZE PROBLEM    *        
T25923*  03/19/02    SS19371  ADD FIELDS TO BE INCLUDED IN RETRIEVE    *        
T25923*  03/19/02    SS19371  ADD FIELDS TO BE INCLUDED IN RETRIEVE    *        
REARCH*  07/16/03    AD88124  RPC CONVERTED TO COBOL SP.               *        
C30881*  10/07/05    BASKAR V INCREASE NSF_REASON_CD LENGTH            *        
P00935*  08/04/16    LG41184  BANK CURSOR CHANGED TO GET ONLY THE      *        
P00935*                       REMITTANCE BANKS DATA.                   *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02186'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02186 STARTS HERE'.                  
                                                                        
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBANK                                                    
           END-EXEC.                                                            
                                                                        
P00935*    *** CSS_CSH_OFF_BANK - Y8                                            
           EXEC SQL                                                             
              INCLUDE TBLOFBNK                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBRETCHK                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CCA00001.                                                       
                                                                        
REARCH     EXEC SQL                                                             
REARCH          INCLUDE CWSX0010                                                
REARCH     END-EXEC.                                                            
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
           05  WS-INSERT-RETURN-CODE   PIC S9(9) VALUE +000 COMP.       
                                                                        
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME            PIC X(08) VALUE 'CSR02186'.      
REARCH     05  WS-SQLSTATE             PIC X(05) VALUE '     '.         
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-ACTIVE-CODE          PIC X(01) VALUE 'A'.             
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05  WS-ENTERED-DT-NI        PIC S9(04) COMP VALUE 0.         
                                                                        
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
REARCH     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
REARCH     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
REARCH     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
REARCH         49  S-HOST-VARIABLES-V    PIC X(255).                    
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
REARCH         49  S-SQL-STATEMENT-V     PIC X(255).                    
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
REARCH         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
                                                                        
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  GTT-NAME                  PIC X(26) VALUE                
REARCH                                       'SESSION.CSR02186_R1'.     
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN            PIC S9(04) COMP.               
REARCH         49 GTT-ROW-CHAR           PIC X(1024).                   
REARCH     05  GTT-SQLCODE               PIC S9(9) COMP.                
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-BANK-ID              PIC S9(6)V COMP-3 VALUE 0.       
           05  RS-BANK-NAME            PIC X(50) VALUE SPACES.          
           05  RS-CASH-GL-ACCT-NO      PIC S9(3)V9(4) COMP-3 VALUE 0.   
           05  RS-ENTERED-DT           PIC X(10) VALUE SPACES.          
           05  RS-ACCOUNT-NO           PIC S9(13)V COMP-3 VALUE 0.      
           05  RS-CHECK-AMT            PIC S9(13)V9(2) COMP-3 VALUE 0.  
           05  RS-CHECK-UTIL-AMT       PIC S9(13)V9(2) COMP-3 VALUE 0.  
           05  RS-CHECK-NONUTIL-AMT    PIC S9(13)V9(2) COMP-3 VALUE 0.  
           05  RS-CURRENCY-TYPE        PIC X(1) VALUE SPACES.           
           05  RS-CODE-AR-AGE          PIC X(1) VALUE SPACES.           
           05  RS-DRAWN-BY-NM          PIC X(50) VALUE SPACES.          
           05  RS-ITEM-NO              PIC S9(4) COMP VALUE 0.          
C30881*    05  RS-NSF-REASON-CD        PIC X(1) VALUE SPACES.                   
C30881     05  RS-NSF-REASON-CD        PIC X(3) VALUE SPACES.           
           05  RS-WAIVER-REASON-CD     PIC X(1) VALUE SPACES.           
           05  RS-NSF-CURRENCY-TYPE    PIC X(1) VALUE SPACES.           
           05  RS-NSC-REMOVE-FL        PIC X(1) VALUE SPACES.           
           05  RS-NSF-TIMESTAMP        PIC X(26) VALUE SPACES.          
           05  RS-TRN-HST-SEQ-NO       PIC X(26) VALUE SPACES.          
           05  RS-SEND-NOTICE-CD       PIC X(01) VALUE SPACES.          
           05  RS-COUNTER              PIC S9(9) COMP VALUE 0.          
T16122     05  RS-FCS-DEP-BANK-CD      PIC X(05) VALUE SPACES.          
T16122     05  RS-FCS-DEP-BANK-ST-CD   PIC X(02) VALUE SPACES.          
T16122     05  RS-FCS-BANK-NAME-CD     PIC X(59) VALUE SPACES.          
T22767     05  RS-COMMENTS-TX          PIC X(120) VALUE SPACES.         
T22767     05  RS-NON-CIS-ACCT-NO      PIC S9(13)V COMP-3 VALUE 0.      
T22767     05  RS-PAYMENT-TYPE-TX      PIC X(15) VALUE SPACES.          
T22767     05  RS-NON-CIS-GL-ACCT      PIC S9(3)V9(4) COMP-3 VALUE 0.   
T25923     05  RS-PARTIAL-PYMT-FL      PIC X(01) VALUE SPACES.          
T25923     05  RS-BANK-POST-DT         PIC X(10) VALUE SPACES.          
T25923     05  RS-DATE-ORIG-PAYMT      PIC X(10) VALUE SPACES.          
T25923     05  RS-ORIG-PYMT-OFFICE     PIC X(03) VALUE SPACES.          
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
REARCH     05  S-BANK-ID               PIC S9(6)V COMP-3 VALUE 0.       
REARCH     05  S-BANK-NAME             PIC X(50) VALUE SPACES.          
REARCH     05  S-CASH-GL-ACCT-NO       PIC S9(3)V9(4) COMP-3 VALUE 0.   
REARCH     05  S-ENTERED-DT            PIC X(10) VALUE SPACES.          
REARCH     05  S-ACCOUNT-NO            PIC S9(13)V COMP-3 VALUE 0.      
REARCH     05  S-CHECK-AMT             PIC S9(13)V9(2) COMP-3 VALUE 0.  
REARCH     05  S-CHECK-UTIL-AMT        PIC S9(13)V9(2) COMP-3 VALUE 0.  
REARCH     05  S-CHECK-NONUTIL-AMT     PIC S9(13)V9(2) COMP-3 VALUE 0.  
REARCH     05  S-CURRENCY-TYPE         PIC X(1) VALUE SPACES.           
REARCH     05  S-CODE-AR-AGE           PIC X(1) VALUE SPACES.           
REARCH     05  S-DRAWN-BY-NM           PIC X(50) VALUE SPACES.          
REARCH     05  S-ITEM-NO               PIC S9(4) COMP VALUE 0.          
C30881*    05  S-NSF-REASON-CD         PIC X(1) VALUE SPACES.                   
C30881     05  S-NSF-REASON-CD         PIC X(3) VALUE SPACES.           
REARCH     05  S-WAIVER-REASON-CD      PIC X(1) VALUE SPACES.           
REARCH     05  S-NSF-CURRENCY-TYPE     PIC X(1) VALUE SPACES.           
REARCH     05  S-NSC-REMOVE-FL         PIC X(1) VALUE SPACES.           
REARCH     05  S-NSF-TIMESTAMP         PIC X(26) VALUE SPACES.          
REARCH     05  S-TRN-HST-SEQ-NO        PIC X(26) VALUE SPACES.          
REARCH     05  S-SEND-NOTICE-CD        PIC X(01) VALUE SPACES.          
REARCH     05  S-COUNTER               PIC S9(9) COMP VALUE 0.          
REARCH     05  S-FCS-DEP-BANK-CD       PIC X(05) VALUE SPACES.          
REARCH     05  S-FCS-DEP-BANK-ST-CD    PIC X(02) VALUE SPACES.          
REARCH     05  S-FCS-BANK-NAME-CD      PIC X(59) VALUE SPACES.          
REARCH     05  S-COMMENTS-TX           PIC X(120) VALUE SPACES.         
REARCH     05  S-NON-CIS-ACCT-NO       PIC S9(13)V COMP-3 VALUE 0.      
REARCH     05  S-PAYMENT-TYPE-TX       PIC X(15) VALUE SPACES.          
REARCH     05  S-NON-CIS-GL-ACCT       PIC S9(3)V9(4) COMP-3 VALUE 0.   
REARCH     05  S-PARTIAL-PYMT-FL       PIC X(01) VALUE SPACES.          
REARCH     05  S-BANK-POST-DT          PIC X(10) VALUE SPACES.          
REARCH     05  S-DATE-ORIG-PAYMT       PIC X(10) VALUE SPACES.          
REARCH     05  S-ORIG-PYMT-OFFICE      PIC X(03) VALUE SPACES.          
REARCH     05  S-LAST-UPDT-TS          PIC X(26) VALUE SPACES.          
                                                                        
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
      ******************************************************************        
      *    DECLARE CURSOR TO RETRIEVE BANKS                            *        
      ******************************************************************        
           EXEC SQL DECLARE BANK-CURSOR CURSOR FOR                      
P00935        SELECT D1.BANK_ID,                                        
P00935               D1.BANK_NAME,                                      
P00935               D1.CASH_GL_ACCT_NO,                                
P00935               D1.FCS_DEP_BANK_CD,                                
P00935               D1.FCS_DEP_BANK_ST_CD                              
P00935          FROM CSS_BANK D1,                                       
P00935               CSS_CSH_OFF_BANK Y8                                
P00935         WHERE D1.BANK_ID = Y8.BANK_ID                            
P00935           AND Y8.CASH_LOCAL_OFFICE IN ('009', '011')             
P00935         ORDER BY D1.BANK_ID                                      
           END-EXEC.                                                    
                                                                        
      ******************************************************************        
      *    DECLARE CURSOR TO RETRIEVE RETURN CHECKS FOR A BANK         *        
      ******************************************************************        
           EXEC SQL DECLARE CHECK-CURSOR CURSOR FOR                     
              SELECT CIS.CHAR2$DATE(ENTERED_DT,'USA'),                          
                     ACCOUNT_NO,                                        
                     RETURN_CHK_AMT,                                    
                     CHECK_UTIL_AMT,                                    
                     CHECK_NONUTIL_AMT,                                 
                     NSF_CURRENCY_TYPE,                                 
                     CODE_AR_AGE,                                       
                     DRAWN_BY_NM,                                       
                     ITEM_NO,                                           
                     NSF_REASON_CD,                                     
                     WAIVER_REASON_CD,                                  
                     NSF_CURRENCY_TYPE,                                 
                     NSC_REMOVE_FL,                                     
                     REPLACE(REPLACE(CONVERT(CHAR(26), NSF_TIMESTAMP
           , 121), ' ', '-'), ':', '.') NSF_TIMESTAMP,                         
                     SEND_NOTICE_CD,                                    
                     REPLACE(REPLACE(CONVERT(CHAR(26), TRANS_HIST_SEQ_NO
           , 121), ' ', '-'), ':', '.') TRANS_HIST_SEQ_NO,                     
T22767               COMMENTS_TX,                                       
T22767               NON_CIS_ACCT_NO,                                   
T22767               NON_CIS_GL_ACCT,                                   
T22767               PAYMENT_TYPE_TX,                                   
T25923               PARTIAL_PYMT_FL,                                   
T25923               BANK_POST_DT,                                      
T25923               DATE_ORIG_PAYMT,                                   
T25923               ORIG_PYMT_OFFICE                                   
               FROM CSS_RETURN_CHK                                      
               WHERE BANK_ID        = :RC-BANK-ID                       
P00935         ORDER BY ITEM_NO DESC                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE CHECK-CURSOR CURSOR FOR                             
MFA-TR*       SELECT CHAR(ENTERED_DT,USA),                                      
MFA-TR*              ACCOUNT_NO,                                                
MFA-TR*              RETURN_CHK_AMT,                                            
MFA-TR*              CHECK_UTIL_AMT,                                            
MFA-TR*              CHECK_NONUTIL_AMT,                                         
MFA-TR*              NSF_CURRENCY_TYPE,                                         
MFA-TR*              CODE_AR_AGE,                                               
MFA-TR*              DRAWN_BY_NM,                                               
MFA-TR*              ITEM_NO,                                                   
MFA-TR*              NSF_REASON_CD,                                             
MFA-TR*              WAIVER_REASON_CD,                                          
MFA-TR*              NSF_CURRENCY_TYPE,                                         
MFA-TR*              NSC_REMOVE_FL,                                             
MFA-TR*              NSF_TIMESTAMP,                                             
MFA-TR*              SEND_NOTICE_CD,                                            
MFA-TR*              TRANS_HIST_SEQ_NO,                                         
MFA-TR*              COMMENTS_TX,                                               
MFA-TR*              NON_CIS_ACCT_NO,                                           
MFA-TR*              NON_CIS_GL_ACCT,                                           
MFA-TR*              PAYMENT_TYPE_TX,                                           
MFA-TR*              PARTIAL_PYMT_FL,                                           
MFA-TR*              BANK_POST_DT,                                              
MFA-TR*              DATE_ORIG_PAYMT,                                           
MFA-TR*              ORIG_PYMT_OFFICE                                           
MFA-TR*        FROM CSS_RETURN_CHK                                              
MFA-TR*        WHERE BANK_ID        = :RC-BANK-ID                               
MFA-TR*        ORDER BY ITEM_NO DESC                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                                    
       PROCEDURE DIVISION.                                              
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
REARCH*                                                                         
REARCH     PERFORM 0100A-DECLARE-GTT    THRU 0100A-EXIT.                
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARCH             *                                                    
REARCH         FROM                                                     
REARCH             #CSR02186_R1                                  
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*            *                                                            
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR02186_R1                                          
MFA-TR*    END-EXEC.                                                            
REARCH*                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
REARCH*                                                                         
REARCH******************************************************************        
REARCH* 0100A-DECLARE-GTT                                              *        
REARCH*                                                                *        
REARCH*     DECLARING GLOBAL TEMPORARY TABLE AND CHECKING TO DELETE    *        
REARCH*     GTT ROWS IF IT EXISTS.                                     *        
REARCH*                                                                *        
REARCH******************************************************************        
REARCH*                                                                         
REARCH 0100A-DECLARE-GTT.                                               
REARCH*                                                                         
REARCH     MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR02186_R1'            
REARCH                                   TO S-SQL-STATEMENT-V.          
REARCH     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02186_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02186_R1
              (                                                        
REARCH           RETURN_CODE          INT                           
REARCH          ,BANK_ID              DECIMAL(6,0)                      
REARCH          ,BANK_NAME CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2            
REARCH          ,CASH_GL_ACCT_NO      DECIMAL(7,4)                      
REARCH          ,ENTERED_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2           
REARCH          ,ACCOUNT_NO           DECIMAL(13,0)                     
REARCH          ,CHECK_AMT            DECIMAL(15,2)                     
REARCH          ,CHECK_UTIL_AMT       DECIMAL(15,2)                     
REARCH          ,CHECK_NONUTIL_AMT    DECIMAL(15,2)                     
REARCH          ,CURRENCY_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH          ,CODE_AR_AGE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH          ,DRAWN_BY_NM CHAR(50)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH          ,ITEM_NO              SMALLINT                          
C30881*         ,NSF_REASON_CD        CHAR(01)                                  
C30881          ,NSF_REASON_CD CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH          ,WAIVER_REASON_CD CHAR(01)  COLLATE 
                              LATIN1_GENERAL_100_BIN2                          
REARCH          ,NSF_CURRENCY_TYPE CHAR(01)  COLLATE 
                              LATIN1_GENERAL_100_BIN2                          
REARCH          ,NSC_REMOVE_FL CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH          ,NSF_TIMESTAMP CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH          ,TRN_HST_SEQ_NO CHAR(26)  COLLATE 
                              LATIN1_GENERAL_100_BIN2                          
REARCH          ,SEND_NOTICE_CD CHAR(01)  COLLATE 
                              LATIN1_GENERAL_100_BIN2                          
REARCH          ,COUNTER              INT                           
REARCH          ,FCS_DEP_BANK_CD CHAR(05)  COLLATE 
                              LATIN1_GENERAL_100_BIN2                          
REARCH          ,FCS_DEP_BANK_ST_CD CHAR(02)  COLLATE 
                              LATIN1_GENERAL_100_BIN2                          
REARCH          ,FCS_BANK_NAME_CD CHAR(59)  COLLATE 
                              LATIN1_GENERAL_100_BIN2                          
REARCH          ,COMMENTS_TX CHAR(120)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH          ,NON_CIS_ACCT_NO      DECIMAL(13,0)                     
REARCH          ,PAYMENT_TYPE_TX CHAR(15)  COLLATE 
                              LATIN1_GENERAL_100_BIN2                          
REARCH          ,NON_CIS_GL_ACCT      DECIMAL(7,4)                      
REARCH          ,PARTIAL_PYMT_FL CHAR(01)  COLLATE 
                              LATIN1_GENERAL_100_BIN2                          
REARCH          ,BANK_POST_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH          ,DATE_ORIG_PAYMT CHAR(10)  COLLATE 
                              LATIN1_GENERAL_100_BIN2                          
REARCH          ,ORIG_PYMT_OFFICE CHAR(03)  COLLATE 
                              LATIN1_GENERAL_100_BIN2                          
REARCH          ,AT_LAST_UPDT_TS CHAR(26)  COLLATE 
                              LATIN1_GENERAL_100_BIN2                          
REARCH         )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH     MOVE SQLSTATE                 TO WS-SQLSTATE.                
REARCH     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
REARCH*                                                                         
REARCH        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
REARCH        OR WS-SQLSTATE = '42710'                                  
REARCH           NEXT SENTENCE                                          
REARCH        ELSE                                                      
REARCH           MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
REARCH           MOVE SQLCODE            TO ABEND-SQLCODE               
REARCH           MOVE SQLSTATE           TO ABEND-SQLSTATE              
REARCH           MOVE '0100A'            TO ACTIVE-PARAGRAPH            
REARCH           MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
REARCH           MOVE SPACES             TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH           MOVE 'CSR02186_R1'      TO TABLE-1                     
REARCH           MOVE SPACES             TO TABLE-ELEMENT-1             
REARCH           MOVE SPACES             TO HOSTVAR-ELEMENT-1           
REARCH           PERFORM 9900-SQL-ERROR-ROUTINE                         
REARCH                                   THRU  9900-EXIT                
REARCH        END-IF.                                                   
REARCH*                                                                         
REARCH 0100A-EXIT.                                                      
REARCH      EXIT.                                                       
REARCH*                                                                         
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 2200-BUILD-RESULT     THRU 2200-EXIT.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH*****************************************************************         
REARCH*                                                               *         
REARCH* 2000A-MOVE-RESULT.                                            *         
REARCH*                                                               *         
REARCH*****************************************************************         
REARCH*                                                                         
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE RS-RETURN-CODE           TO S-RETURN-CODE               
REARCH     MOVE RS-BANK-ID               TO S-BANK-ID                   
REARCH     MOVE RS-BANK-NAME             TO S-BANK-NAME                 
REARCH     MOVE RS-CASH-GL-ACCT-NO       TO S-CASH-GL-ACCT-NO           
REARCH     MOVE RS-ENTERED-DT            TO S-ENTERED-DT                
REARCH     MOVE RS-ACCOUNT-NO            TO S-ACCOUNT-NO                
REARCH     MOVE RS-CHECK-AMT             TO S-CHECK-AMT                 
REARCH     MOVE RS-CHECK-UTIL-AMT        TO S-CHECK-UTIL-AMT            
REARCH     MOVE RS-CHECK-NONUTIL-AMT     TO S-CHECK-NONUTIL-AMT         
REARCH     MOVE RS-CURRENCY-TYPE         TO S-CURRENCY-TYPE             
REARCH     MOVE RS-CODE-AR-AGE           TO S-CODE-AR-AGE               
REARCH     MOVE RS-DRAWN-BY-NM           TO S-DRAWN-BY-NM               
REARCH     MOVE RS-ITEM-NO               TO S-ITEM-NO                   
REARCH     MOVE RS-NSF-REASON-CD         TO S-NSF-REASON-CD             
REARCH     MOVE RS-WAIVER-REASON-CD      TO S-WAIVER-REASON-CD          
REARCH     MOVE RS-NSF-CURRENCY-TYPE     TO S-NSF-CURRENCY-TYPE         
REARCH     MOVE RS-NSC-REMOVE-FL         TO S-NSC-REMOVE-FL             
REARCH     MOVE RS-NSF-TIMESTAMP         TO S-NSF-TIMESTAMP             
REARCH     MOVE RS-TRN-HST-SEQ-NO        TO S-TRN-HST-SEQ-NO            
REARCH     MOVE RS-SEND-NOTICE-CD        TO S-SEND-NOTICE-CD            
REARCH     MOVE RS-COUNTER               TO S-COUNTER                   
REARCH     MOVE RS-FCS-DEP-BANK-CD       TO S-FCS-DEP-BANK-CD           
REARCH     MOVE RS-FCS-DEP-BANK-ST-CD    TO S-FCS-DEP-BANK-ST-CD        
REARCH     MOVE RS-FCS-BANK-NAME-CD      TO S-FCS-BANK-NAME-CD          
REARCH     MOVE RS-COMMENTS-TX           TO S-COMMENTS-TX               
REARCH     MOVE RS-NON-CIS-ACCT-NO       TO S-NON-CIS-ACCT-NO           
REARCH     MOVE RS-PAYMENT-TYPE-TX       TO S-PAYMENT-TYPE-TX           
REARCH     MOVE RS-NON-CIS-GL-ACCT       TO S-NON-CIS-GL-ACCT           
REARCH     MOVE RS-PARTIAL-PYMT-FL       TO S-PARTIAL-PYMT-FL           
REARCH     MOVE RS-BANK-POST-DT          TO S-BANK-POST-DT              
REARCH     MOVE RS-DATE-ORIG-PAYMT       TO S-DATE-ORIG-PAYMT           
REARCH     MOVE RS-ORIG-PYMT-OFFICE      TO S-ORIG-PYMT-OFFICE          
REARCH     MOVE SPACES                   TO S-LAST-UPDT-TS.             
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      ******************************************************************        
       2200-BUILD-RESULT.                                               
                                                                        
           PERFORM 7100-OPEN-BANK-CURSOR         THRU 7100-EXIT.        
                                                                        
           PERFORM 2300-PROCESS-FETCH-BANK       THRU 2300-EXIT         
              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                  
           PERFORM 7200-CLOSE-BANK-CURSOR        THRU 7200-EXIT.        
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '2200'          TO ACTIVE-PARAGRAPH                  
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'CSS_BANK'           TO TABLE-1                      
              MOVE NOT-FOUND       TO WS-ACTIVE-RETURN-CODE             
              MOVE NOT-FOUND       TO SQLCODE                           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2300-PROCESS-FETCH-BANK                                        *        
      ******************************************************************        
       2300-PROCESS-FETCH-BANK.                                         
                                                                        
           PERFORM 7000-FETCH-BANK   THRU 7000-EXIT.                    
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE D1-BANK-ID TO RC-BANK-ID                             
              MOVE 0          TO RS-COUNTER                             
           ELSE                                                         
              GO TO 2300-EXIT                                           
           END-IF.                                                      
                                                                        
           PERFORM 7400-OPEN-CHECK-CURSOR THRU 7400-EXIT.               
           PERFORM 2400-PROCESS-RET-CHECK THRU 2400-EXIT                
              UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                  
           PERFORM 7500-CLOSE-CHECK-CURSOR THRU 7500-EXIT.              
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2400-PROCESS-RET-CHECK                                         *        
      ******************************************************************        
       2400-PROCESS-RET-CHECK.                                          
                                                                        
           PERFORM 7300-FETCH-CHECK  THRU 7300-EXIT.                    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              PERFORM 2500-INITIALIZE-FIELDS THRU 2500-EXIT
           END-IF.            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              OR NOT-FOUND                                              
              MOVE 0                     TO RS-RETURN-CODE              
              MOVE D1-BANK-ID            TO RS-BANK-ID                  
              MOVE D1-BANK-NAME          TO RS-BANK-NAME                
              MOVE D1-CASH-GL-ACCT-NO    TO RS-CASH-GL-ACCT-NO          
              MOVE D1-FCS-DEP-BANK-CD    TO RS-FCS-DEP-BANK-CD          
              MOVE D1-FCS-DEP-BANK-ST-CD TO RS-FCS-DEP-BANK-ST-CD       
                                                                        
              MOVE SPACES                TO RS-FCS-BANK-NAME-CD         
                                                                        
              STRING D1-FCS-DEP-BANK-CD    DELIMITED BY ' '             
                     ' '                   DELIMITED BY SIZE            
                     D1-FCS-DEP-BANK-ST-CD DELIMITED BY SIZE            
                     ' '                   DELIMITED BY SIZE            
                     D1-BANK-NAME          DELIMITED BY '  '            
                INTO RS-FCS-BANK-NAME-CD                                
              END-STRING                                                
                                                                        
              MOVE RC-ENTERED-DT         TO RS-ENTERED-DT               
              MOVE RC-ACCOUNT-NO         TO RS-ACCOUNT-NO               
              MOVE RC-RETURN-CHK-AMT     TO RS-CHECK-AMT                
              MOVE RC-CHECK-UTIL-AMT     TO RS-CHECK-UTIL-AMT           
              MOVE RC-CHECK-NONUTIL-AMT  TO RS-CHECK-NONUTIL-AMT        
              MOVE RC-NSF-CURRENCY-TYPE  TO RS-CURRENCY-TYPE            
              MOVE RC-CODE-AR-AGE        TO RS-CODE-AR-AGE              
T25170        MOVE SPACES                TO RS-DRAWN-BY-NM              
              MOVE RC-DRAWN-BY-NM-TEXT   TO RS-DRAWN-BY-NM              
              MOVE RC-ITEM-NO            TO RS-ITEM-NO                  
              MOVE RC-NSF-REASON-CD      TO RS-NSF-REASON-CD            
              MOVE RC-WAIVER-REASON-CD   TO RS-WAIVER-REASON-CD         
              MOVE RC-NSF-CURRENCY-TYPE  TO RS-NSF-CURRENCY-TYPE        
              MOVE RC-NSC-REMOVE-FL      TO RS-NSC-REMOVE-FL            
              MOVE RC-NSF-TIMESTAMP      TO RS-NSF-TIMESTAMP            
              MOVE RC-TRANS-HIST-SEQ-NO  TO RS-TRN-HST-SEQ-NO           
              MOVE RC-SEND-NOTICE-CD     TO RS-SEND-NOTICE-CD           
T22767        MOVE SPACES                TO RS-COMMENTS-TX              
T22767        MOVE RC-COMMENTS-TX-TEXT   TO RS-COMMENTS-TX              
T22767        MOVE RC-NON-CIS-ACCT-NO    TO RS-NON-CIS-ACCT-NO          
T22767        MOVE RC-PAYMENT-TYPE-TX    TO RS-PAYMENT-TYPE-TX          
T22767        MOVE RC-NON-CIS-GL-ACCT    TO RS-NON-CIS-GL-ACCT          
              ADD  1                     TO RS-COUNTER                  
              MOVE '2400'                TO ACTIVE-PARAGRAPH            
T22767        IF RC-CODE-AR-AGE  =  'N'                                 
T22767          MOVE  RC-NON-CIS-ACCT-NO TO RS-ACCOUNT-NO               
T22767        END-IF                                                    
T25923        MOVE RC-PARTIAL-PYMT-FL    TO RS-PARTIAL-PYMT-FL          
T25923        MOVE RC-BANK-POST-DT       TO RS-BANK-POST-DT             
T25923        MOVE RC-DATE-ORIG-PAYMT    TO RS-DATE-ORIG-PAYMT          
T25923        MOVE RC-ORIG-PYMT-OFFICE   TO RS-ORIG-PYMT-OFFICE         
                                                                        
REARCH        PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT           
              PERFORM 8100-SEND-RESULT        THRU 8100-EXIT            
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2500-INITIALIZE-FIELDS                                        *         
      *****************************************************************         
       2500-INITIALIZE-FIELDS.                                          
                                                                        
           MOVE SPACES                    TO RC-ENTERED-DT              
                                             RC-NSF-CURRENCY-TYPE       
                                             RC-CODE-AR-AGE             
                                             RC-DRAWN-BY-NM             
                                             RC-NSF-REASON-CD           
                                             RC-NSF-CURRENCY-TYPE       
                                             RC-NSC-REMOVE-FL           
                                             RC-NSF-TIMESTAMP           
                                             RC-TRANS-HIST-SEQ-NO       
                                             RC-SEND-NOTICE-CD          
T22767                                       RC-COMMENTS-TX             
T22767                                       RC-PAYMENT-TYPE-TX         
                                             RC-WAIVER-REASON-CD.       
           MOVE 0                         TO RC-RETURN-CHK-AMT          
                                             RC-CHECK-UTIL-AMT          
                                             RC-CHECK-NONUTIL-AMT       
                                             RC-ACCOUNT-NO              
T22767                                       RC-NON-CIS-ACCT-NO         
T22767                                       RC-NON-CIS-GL-ACCT         
                                             RC-ITEM-NO.                
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-FETCH-BANK                                                *        
      ******************************************************************        
       7000-FETCH-BANK.                                                 
                                                                        
           EXEC SQL                                                     
              FETCH BANK-CURSOR                                         
               INTO :D1-BANK-ID ,                                       
                    :D1-BANK-NAME ,                                     
                    :D1-CASH-GL-ACCT-NO ,                               
T16212              :D1-FCS-DEP-BANK-CD,                                
T16212              :D1-FCS-DEP-BANK-ST-CD                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7000'          TO ACTIVE-PARAGRAPH                  
CBSI  **      MOVE 'FETCH'         TO ABEND-FUNCTION                            
              MOVE 'CSS_BANK'      TO TABLE-1                           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7100-OPEN-BANK-CURSOR                                          *        
      ******************************************************************        
       7100-OPEN-BANK-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
              OPEN BANK-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7100'          TO ACTIVE-PARAGRAPH                  
CBSI  **      MOVE 'OPEN'          TO ABEND-FUNCTION                            
              MOVE 'CSS_BANK'      TO TABLE-1                           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7200-CLOSE-BANK-CURSOR                                         *        
      ******************************************************************        
       7200-CLOSE-BANK-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
              CLOSE BANK-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7200'          TO ACTIVE-PARAGRAPH                  
CBSI  **      MOVE 'CLOSE'         TO ABEND-FUNCTION                            
              MOVE 'CSS_BANK'      TO TABLE-1                           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7300-FETCH-CHECK                                               *        
      ******************************************************************        
       7300-FETCH-CHECK.                                                
                                                                        
T15430**   INITIALIZE RC-DRAWN-BY-NM                                            
                                                                        
           MOVE SPACES TO RC-COMMENTS-TX                                
T25170                    RC-DRAWN-BY-NM                                
                                                                        
           EXEC SQL                                                     
              FETCH CHECK-CURSOR                                        
               INTO :RC-ENTERED-DT         ,                            
                    :RC-ACCOUNT-NO         ,                            
                    :RC-RETURN-CHK-AMT     ,                            
                    :RC-CHECK-UTIL-AMT     ,                            
                    :RC-CHECK-NONUTIL-AMT  ,                            
                    :RC-NSF-CURRENCY-TYPE  ,                            
                    :RC-CODE-AR-AGE        ,                            
                    :RC-DRAWN-BY-NM        ,                            
                    :RC-ITEM-NO            ,                            
                    :RC-NSF-REASON-CD      ,                            
                    :RC-WAIVER-REASON-CD   ,                            
                    :RC-NSF-CURRENCY-TYPE  ,                            
                    :RC-NSC-REMOVE-FL      ,                            
                    :RC-NSF-TIMESTAMP      ,                            
                    :RC-SEND-NOTICE-CD     ,                            
                    :RC-TRANS-HIST-SEQ-NO  ,                            
T22767              :RC-COMMENTS-TX        ,                            
T22767              :RC-NON-CIS-ACCT-NO    ,                            
T22767              :RC-NON-CIS-GL-ACCT    ,                            
T22767              :RC-PAYMENT-TYPE-TX    ,                            
T25923              :RC-PARTIAL-PYMT-FL    ,                            
T25923              :RC-BANK-POST-DT       ,                            
T25923              :RC-DATE-ORIG-PAYMT     ,                           
T25923              :RC-ORIG-PYMT-OFFICE                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME     TO ABEND-PROGRAM                    
              MOVE '7300'           TO ACTIVE-PARAGRAPH                 
CBSI***       MOVE 'FETCH'          TO ABEND-FUNCTION                           
      *       MOVE 'CSS_RETURN_CHK' TO TABLE-1                                  
CBSI***       MOVE 'BANK_ID'        TO TABLE-ELEMENT-1                          
CBSI***       MOVE RC-BANK-ID       TO HOSTVAR-ELEMENT-1                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7400-OPEN-CHECK-CURSOR                                         *        
      ******************************************************************        
       7400-OPEN-CHECK-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
              OPEN CHECK-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME     TO ABEND-PROGRAM                    
              MOVE '7400'           TO ACTIVE-PARAGRAPH                 
CBSI***       MOVE 'OPEN'           TO ABEND-FUNCTION                           
              MOVE 'CSS_RETURN_CHK' TO TABLE-1                          
CBSI***       MOVE 'BANK_ID'        TO TABLE-ELEMENT-1                          
CBSI***       MOVE RC-BANK-ID       TO HOSTVAR-ELEMENT-1                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7500-CLOSE-CHECK-CURSOR                                        *        
      ******************************************************************        
       7500-CLOSE-CHECK-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
              CLOSE CHECK-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME     TO ABEND-PROGRAM                    
              MOVE '7500'           TO ACTIVE-PARAGRAPH                 
CBSI***       MOVE 'CLOSE'          TO ABEND-FUNCTION                           
      **      MOVE 'CSS_RETURN_CHK' TO TABLE-1                                  
CBSI***       MOVE 'BANK_ID'        TO TABLE-ELEMENT-1                          
CBSI***       MOVE RC-BANK-ID       TO HOSTVAR-ELEMENT-1                        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
     *                                                                  
           EXEC SQL                                                     
REARCH         INSERT INTO #CSR02186_R1                          
REARCH          (RETURN_CODE                                            
REARCH          ,BANK_ID                                                
REARCH          ,BANK_NAME                                              
REARCH          ,CASH_GL_ACCT_NO                                        
REARCH          ,ENTERED_DT                                             
REARCH          ,ACCOUNT_NO                                             
REARCH          ,CHECK_AMT                                              
REARCH          ,CHECK_UTIL_AMT                                         
REARCH          ,CHECK_NONUTIL_AMT                                      
REARCH          ,CURRENCY_TYPE                                          
REARCH          ,CODE_AR_AGE                                            
REARCH          ,DRAWN_BY_NM                                            
REARCH          ,ITEM_NO                                                
REARCH          ,NSF_REASON_CD                                          
REARCH          ,WAIVER_REASON_CD                                       
REARCH          ,NSF_CURRENCY_TYPE                                      
REARCH          ,NSC_REMOVE_FL                                          
REARCH          ,NSF_TIMESTAMP                                          
REARCH          ,TRN_HST_SEQ_NO                                         
REARCH          ,SEND_NOTICE_CD                                         
REARCH          ,COUNTER                                                
REARCH          ,FCS_DEP_BANK_CD                                        
REARCH          ,FCS_DEP_BANK_ST_CD                                     
REARCH          ,FCS_BANK_NAME_CD                                       
REARCH          ,COMMENTS_TX                                            
REARCH          ,NON_CIS_ACCT_NO                                        
REARCH          ,PAYMENT_TYPE_TX                                        
REARCH          ,NON_CIS_GL_ACCT                                        
REARCH          ,PARTIAL_PYMT_FL                                        
REARCH          ,BANK_POST_DT                                           
REARCH          ,DATE_ORIG_PAYMT                                        
REARCH          ,ORIG_PYMT_OFFICE                                       
REARCH          ,AT_LAST_UPDT_TS)                                       
REARCH         VALUES                                                   
REARCH          (:S-RETURN-CODE                                         
REARCH          ,:S-BANK-ID                                             
REARCH          ,:S-BANK-NAME                                           
REARCH          ,:S-CASH-GL-ACCT-NO                                     
REARCH          ,:S-ENTERED-DT                                          
REARCH          ,:S-ACCOUNT-NO                                          
REARCH          ,:S-CHECK-AMT                                           
REARCH          ,:S-CHECK-UTIL-AMT                                      
REARCH          ,:S-CHECK-NONUTIL-AMT                                   
REARCH          ,:S-CURRENCY-TYPE                                       
REARCH          ,:S-CODE-AR-AGE                                         
REARCH          ,:S-DRAWN-BY-NM                                         
REARCH          ,:S-ITEM-NO                                             
REARCH          ,:S-NSF-REASON-CD                                       
REARCH          ,:S-WAIVER-REASON-CD                                    
REARCH          ,:S-NSF-CURRENCY-TYPE                                   
REARCH          ,:S-NSC-REMOVE-FL                                       
REARCH          ,:S-NSF-TIMESTAMP                                       
REARCH          ,:S-TRN-HST-SEQ-NO                                      
REARCH          ,:S-SEND-NOTICE-CD                                      
REARCH          ,:S-COUNTER                                             
REARCH          ,:S-FCS-DEP-BANK-CD                                     
REARCH          ,:S-FCS-DEP-BANK-ST-CD                                  
REARCH          ,:S-FCS-BANK-NAME-CD                                    
REARCH          ,:S-COMMENTS-TX                                         
REARCH          ,:S-NON-CIS-ACCT-NO                                     
REARCH          ,:S-PAYMENT-TYPE-TX                                     
REARCH          ,:S-NON-CIS-GL-ACCT                                     
REARCH          ,:S-PARTIAL-PYMT-FL                                     
REARCH          ,:S-BANK-POST-DT                                        
REARCH          ,:S-DATE-ORIG-PAYMT                                     
REARCH          ,:S-ORIG-PYMT-OFFICE                                    
REARCH          ,:S-LAST-UPDT-TS                                        
REARCH          )                                                       
REARCH      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO SESSION.CSR02186_R1                                  
MFA-TR*         (RETURN_CODE                                                    
MFA-TR*         ,BANK_ID                                                        
MFA-TR*         ,BANK_NAME                                                      
MFA-TR*         ,CASH_GL_ACCT_NO                                                
MFA-TR*         ,ENTERED_DT                                                     
MFA-TR*         ,ACCOUNT_NO                                                     
MFA-TR*         ,CHECK_AMT                                                      
MFA-TR*         ,CHECK_UTIL_AMT                                                 
MFA-TR*         ,CHECK_NONUTIL_AMT                                              
MFA-TR*         ,CURRENCY_TYPE                                                  
MFA-TR*         ,CODE_AR_AGE                                                    
MFA-TR*         ,DRAWN_BY_NM                                                    
MFA-TR*         ,ITEM_NO                                                        
MFA-TR*         ,NSF_REASON_CD                                                  
MFA-TR*         ,WAIVER_REASON_CD                                               
MFA-TR*         ,NSF_CURRENCY_TYPE                                              
MFA-TR*         ,NSC_REMOVE_FL                                                  
MFA-TR*         ,NSF_TIMESTAMP                                                  
MFA-TR*         ,TRN_HST_SEQ_NO                                                 
MFA-TR*         ,SEND_NOTICE_CD                                                 
MFA-TR*         ,COUNTER                                                        
MFA-TR*         ,FCS_DEP_BANK_CD                                                
MFA-TR*         ,FCS_DEP_BANK_ST_CD                                             
MFA-TR*         ,FCS_BANK_NAME_CD                                               
MFA-TR*         ,COMMENTS_TX                                                    
MFA-TR*         ,NON_CIS_ACCT_NO                                                
MFA-TR*         ,PAYMENT_TYPE_TX                                                
MFA-TR*         ,NON_CIS_GL_ACCT                                                
MFA-TR*         ,PARTIAL_PYMT_FL                                                
MFA-TR*         ,BANK_POST_DT                                                   
MFA-TR*         ,DATE_ORIG_PAYMT                                                
MFA-TR*         ,ORIG_PYMT_OFFICE                                               
MFA-TR*         ,AT_LAST_UPDT_TS)                                               
MFA-TR*        VALUES                                                           
MFA-TR*         (:S-RETURN-CODE                                                 
MFA-TR*         ,:S-BANK-ID                                                     
MFA-TR*         ,:S-BANK-NAME                                                   
MFA-TR*         ,:S-CASH-GL-ACCT-NO                                             
MFA-TR*         ,:S-ENTERED-DT                                                  
MFA-TR*         ,:S-ACCOUNT-NO                                                  
MFA-TR*         ,:S-CHECK-AMT                                                   
MFA-TR*         ,:S-CHECK-UTIL-AMT                                              
MFA-TR*         ,:S-CHECK-NONUTIL-AMT                                           
MFA-TR*         ,:S-CURRENCY-TYPE                                               
MFA-TR*         ,:S-CODE-AR-AGE                                                 
MFA-TR*         ,:S-DRAWN-BY-NM                                                 
MFA-TR*         ,:S-ITEM-NO                                                     
MFA-TR*         ,:S-NSF-REASON-CD                                               
MFA-TR*         ,:S-WAIVER-REASON-CD                                            
MFA-TR*         ,:S-NSF-CURRENCY-TYPE                                           
MFA-TR*         ,:S-NSC-REMOVE-FL                                               
MFA-TR*         ,:S-NSF-TIMESTAMP                                               
MFA-TR*         ,:S-TRN-HST-SEQ-NO                                              
MFA-TR*         ,:S-SEND-NOTICE-CD                                              
MFA-TR*         ,:S-COUNTER                                                     
MFA-TR*         ,:S-FCS-DEP-BANK-CD                                             
MFA-TR*         ,:S-FCS-DEP-BANK-ST-CD                                          
MFA-TR*         ,:S-FCS-BANK-NAME-CD                                            
MFA-TR*         ,:S-COMMENTS-TX                                                 
MFA-TR*         ,:S-NON-CIS-ACCT-NO                                             
MFA-TR*         ,:S-PAYMENT-TYPE-TX                                             
MFA-TR*         ,:S-NON-CIS-GL-ACCT                                             
MFA-TR*         ,:S-PARTIAL-PYMT-FL                                             
MFA-TR*         ,:S-BANK-POST-DT                                                
MFA-TR*         ,:S-DATE-ORIG-PAYMT                                             
MFA-TR*         ,:S-ORIG-PYMT-OFFICE                                            
MFA-TR*         ,:S-LAST-UPDT-TS                                                
MFA-TR*         )                                                               
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
REARCH      MOVE SQLCODE TO WS-INSERT-RETURN-CODE.                      
      *                                                                         
REARCH      IF WS-INSERT-RETURN-CODE = SUCCESSFUL-CALL                  
               ADD +1 TO CTR-ROWS                                       
REARCH      ELSE                                                        
REARCH         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
REARCH         MOVE '8100'               TO ACTIVE-PARAGRAPH            
REARCH         MOVE 'INSERT'             TO ABEND-FUNCTION              
REARCH         MOVE SPACES               TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH         MOVE 'CSR02186_R1'        TO TABLE-1                     
REARCH         MOVE SPACES               TO TABLE-ELEMENT-1             
REARCH         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
REARCH         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
REARCH     END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
      *                                                                         
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
      *                                                                         
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPD00320                                                  
REARCH     END-EXEC.                                                            
                                                                        
