       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02183.                                         
COB303 DATE-WRITTEN. DECEMBER 17, 1995                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
      *                                                                *00110000
      *  TRANID:        S183                                           *00120000
      *  PROGRAM:       S183                                           *00130000
      *  CALLING SP:    PA_S183                                        *00140000
      *                                                                *00150000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *  THIS PROGRAM DOES THE FOLLOWING:                              *00190000
      *  1. PERFORMS PAYMENT REVERSAL.                                 *00200000
      *                                                                *00210000
      ******************************************************************00220000
      *                                                                *00230000
      *                     PROGRAM MODIFICATION LOG                   *00240000
      *                                                                *00250000
      *    DATE    INITIALS   COMMENTS                                 *00260000
      *  --------  --------   ---------------------------------------  *00270000
      *  12/17/95    RTO      PROCEDURE ORIGINALLY CODED.              *00280000
      *   3/11/96    RTO      FCS CHANGES.                             *00290000
      *   4/03/96    RTO      FIX FOR DEPOSIT REVERSAL PROBLEM         *00300000
      *   4/04/96    RTO      FIX FOR WRONG SIZE OF CASH DRAWER ID     *00310000
      *                       IT WAS DEFINED AS A TDSINT4 AND SHOULD   *00320000
      *                       BE DECLARED AS AN TDSINT2                *00330000
      *   4/22/96    RTO      FIX FOR TRAN ID NOT SHOWING UP IN        *00340000
      *                       CSS_CSH_DRWR_JRNL.                       *00350000
      *   7/29/96    JEP      FIX TPR 4803. REMOVED REFERENCES TO      *00360000
      *                       CPD00068, CWS00068, TBDELQ, TBCRCOLL.    *00370000
P353  *   9/12/96    JBW      ADD CSR_PC_ID PER PCR353.                *00380000
      *                                                                *00390000
TP6219*  12/04/96    XX279A8  ERROR IN THE PREDICATE CORRECTED.        *00400000
      *                                                                *00410000
TP5640*   1/14/97    RTO      MODIFIED TO ZERO OUT NULL INDICATORS     *00420000
TP5640*                       BEFORE INSERT TO AR HIST IS MADE.        *00430000
TP5424*   1/16/97    RTO      MODIFIED TO INCLUDE TBPRJSHR COPY MEMBER *00440000
TP5424*                       FOR CHANGES MADE TO CPD00116.            *00450000
PCR404*   3/20/97    PD       DISPLAY PAYMENT REVERSED IN PROGRAM ID   *00451000
PCR404*                       FIELD ON TRANSACTION HISTORY FOR THE     *00452000
PCR404*                       ROW WHICH IS REVERSED.                   *00453000
TP8634*   3/20/97    PD       ADD TBCNTDET TI INCLUDE LIST AS CPD116   *00454000
TP8634*                       CHANGED.                                 *00455000
NEWNEW*   6/02/97    PD       TAKE OUT CASHIERING FUNCTION OUT OF      *00456000
NEWNEW*                       VOUCHER REVERSAL.                        *00457000
T11537*   6/17/97    CHANDRA  PUT THE MONEY BACK TO THE CORRESPONDING  *00458000
T11537*                       BUCKETS.                                 *00459000
T11808*   06/25/97 CHANDRA    MOVE THE TRANSACTION ID TO THE TRAN_ID   *00459100
T11808*                       FIELD OF THE CSS_CSH_DRWR_JRNL           *00459200
T17935**  092598     BASKAR   DECLARE TABLE CSS_CONNECT_CHRG.          *00570001
T18337**  103098     CAD      NOT DELETING VOUCHERS IF MULTIPLE BILL   *00570001
T18337**                      ENTRIES HAVE OCCURED SINCE VOUCHER ENTERD*00570001
T18337**  CORRECTED FIELD DEFINITION.                                  *00570001
CBSI  *  11/08/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *             MADRAS    ABEND PARAMETERS AND INCLUDED 9000-SEND  *        
CBSI  *                       -ERROR-PARA.                             *        
T18874**  01/22/99    SV      DECLARE TABLE CSS_LOCAL_OFFICE           *00570001
T19163**  02/16/99    VB      DELETE LIHEAP WHEN REVERSING THE PAYMENT *00570001
T22428*   09/12/00  CBSI      CALL SUB ROUTINE SCSCA182 AND CHECK IF   *        
T22428*             MADRAS    THE PARM-LAST-UPDATE-TS AND THE ONE      *        
T22428*                       OBTAINED FROM THE SUB ROUTINE ARE SAME,  *        
T22428*                       IF THEY ARE SAME,UPDATES AR_CNTL ELSE    *        
T22428*                       SENDS ERROR MSG TO THE PANEL             *        
T24339*   06/22/01  JS83520   SETS RECORD ONLY FLAG IN PARA 2300- FOR  *        
T24339*                       PAYMENT REVERSAL FOR CPD10 CHANGES       *        
C31601**  12/23/04  BASKAR 1. ADD TRANSACTION COMMENT TO JRNL TABLE    *00570001
C31601**                   2. MOVE 210 TO TRAN COMMENT LENGTH IF LENGTH*00570001
C31601**                      IS MORE THAN 210.                        *00570001
REARCH*   06/02/05  CVNS      RPC TO COBOL SP CONVERSION               *        
REARCH*             CHENNAI                                            *        
T33431** 03/16/06   SK88120        COG PROJECT CHANGES -                        
T33431**                           A- ADD NEW COPYBOOKS                         
T33431**                           B- CHANGE IN CPD00116                        
T35434** 01/21/08   MC95456        ADDED WITH UR TO SELECT STATEMENTS  *        
C36929** 02/28/08   VP94820        SCE&G COG CHANGES.                  *        
T37302** 10/23/08   MR97640        REMOVE THE DCLGEN TBRVCACT          *        
A00956*  03/26/09   CVNS      REPLACE CPD00006 WITH CPD0006A.          *        
A00956*             CHENNAI                                            *        
A04527*  09/23/13   MR7E794   REMOVED UNUSED DCLGENS.                  *        
A04880*  07/21/14   AS7C117   REMOVED UNUSED DCLGENS CPD00008,CPD0062C.*        
A04880*             #ACT225                                            *        
A04860*  08/04/16  MS7M727   REPLACE CSS_WQ_ITEMS_MF TABLE WITH        *01790100
A04860*            ACT107    CSS_WQ_ITEMS TABLE                        *01790200
      ******************************************************************00460000
      ******************************************************************00470000
      *                                                                *00480000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00490000
      *                                                                *00500000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00510000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00520000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00530000
      *  3000 - 4999  NOT USED                                         *00540000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00550000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00560000
      *  7000 - 7999  INPUT MODULES                                    *00570000
      *  8000 - 8999  OUTPUT MODULES                                   *00580000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00590000
      *                                                                *00600000
      ******************************************************************00610000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02183'.
MSQ017     COPY MFASQLM.
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02183 STARTS HERE'.                  
                                                                        
      ******************************************************************00700000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00710000
      ******************************************************************00720000
                                                                        
           COPY CWS00056.                                               00810000
           COPY CWS00303.                                               00820000
           COPY CJF00101.                                               00840000
T33431     COPY CWSCA225.                                                       
T33431     COPY CWSCA224.                                                       
ACT107     COPY CWS00077.                                                       
T22428*                                                                 05360000
T22428 COPY CWS00182.                                                           
T22428*                                                                 05360000
                                                                        
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CWSX0010                                                 
REARCH     END-EXEC.                                                            
      ******************************************************************00870000
      *    WORK AREAS                                                  *00880000
      ******************************************************************00890000
                                                                        
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME             PIC X(08) VALUE 'CSR02183'.     
REARCH     05  EIBTRNID                 PIC X(04) VALUE 'S183'.         
ACT107     05  MCSCB077                 PIC X(08) VALUE 'MCSCB077'.     
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  WS-ACCOUNT-NO            PIC 9(13).                      
COB305     05 WS-ACCOUNT-NO-COMP3        PIC S9(13) COMP-3 VALUE 0.             
           05  WS-CURRENT-DATE          PIC X(10).                      
           05  WS-PAYMENT-REVERSED      PIC X(09) VALUE                 
                                        'PANEL118A'.                    
PCR404     05  WS-VOUCHER-REVERSAL      PIC  X(09) VALUE 'PANEL378D'.   
PCR404     05  WS-VOUCHER-REVERSED      PIC  X(09) VALUE 'PANEL378A'.   
                                                                        
           05  WS-DB2-DATE.                                             
               10 WS-DB2-YYYY           PIC X(04).                      
               10 FILLER                PIC X(01) VALUE '-'.            
               10 WS-DB2-MM             PIC X(02).                      
               10 FILLER                PIC X(01) VALUE '-'.            
               10 WS-DB2-DD             PIC X(02).                      
           05  WS-DUMMY-DATE.                                           
               10 WS-DUMMY-MM           PIC X(02).                      
               10 FILLER                PIC X(01).                      
               10 WS-DUMMY-DD           PIC X(02).                      
               10 FILLER                PIC X(01).                      
               10 WS-DUMMY-YYYY         PIC X(04).                      
           05  WS-CURRENT-TIMESTAMP     PIC X(26).                      
           05  WS-AMOUNT-REFUNDED-NUM   PIC 9(09)V99.                   
           05  WS-USER-ID               PIC X(07).                      
           05  WS-PREV-TRANS-HIST-SEQ-NO PIC X(26).                     
           05  WS-TRANS-HIST-SEQ-NO      PIC X(26).                     
T24339     05  WS-ADJ-TRANS-HIST-SEQ-NO  PIC X(26).                     
T24339     05  WS-DATE                   PIC X(10).                     
T24339     05  WS-TIME                   PIC X(08).                     
           05  WS-NULL-IND1              PIC  S9(04) COMP VALUE 0.      
           05  WS-NULL-IND2              PIC  S9(04) COMP VALUE 0.      
           05  WS-NULL-IND3              PIC  S9(04) COMP VALUE 0.      
           05  WS-DATE-ORIG-PYMT-IND    PIC S9(04) COMP VALUE +0.       
           05  WS-TRAN-COMMENT-LEN      PIC S9(09) COMP.                
           05  WS-TRAN-COMMENT-TEXT     PIC  X(210).                    
           05  WS-TOTAL-ORIG-AMT        PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-RECORD-ONLY           PIC  X(01) VALUE SPACES.        
T22428     05  WS-LAST-UPDATE-TS        PIC X(26).                      
REARCH     05  MCSCA182                 PIC X(08)  VALUE 'MCSCA182'.    
T33431     05  MCSCB225                 PIC X(8) VALUE  'MCSCB225'.     
T33431     05  MCSCB224                 PIC X(8) VALUE  'MCSCB224'.     
T33431     05  WS-UTIL-ACCOUNT          PIC X.                          
T33431         88  UTIL-EXISTS          VALUE 'Y'.                      
T33431         88  NO-UTIL-EXISTS       VALUE 'N'.                      
      *                                                                         
T33431     05  WS-VALID-RATE-FL         PIC X.                          
T33431         88  VALID-RATE           VALUE 'Y'.                      
T33431         88  NOT-VALID-RATE       VALUE 'N'.                      
      *                                                                         
                                                                        
       01  WS-LITERAL.                                                  
           05  WS-A                     PIC X(01) VALUE 'A'.            
           05  WS-B                     PIC X(01) VALUE 'B'.            
           05  WS-C                     PIC X(01) VALUE 'C'.            
           05  WS-D                     PIC X(01) VALUE 'D'.            
           05  WS-G                     PIC X(01) VALUE 'G'.            
           05  WS-I                     PIC X(01) VALUE 'I'.            
           05  WS-M                     PIC X(01) VALUE 'M'.            
           05  WS-R                     PIC X(01) VALUE 'R'.            
T18337     05  WS-FOUND-MULT-BILLS      PIC S9(04) COMP VALUE -811.     
                                                                        
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
                                                                        
P353  *    05  PARM-CSR-PC-ID           PIC X(04).                      01660000
T22428*    05  PARM-LAST-UPDATE-TS      PIC X(26).                              
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(09) COMP VALUE +0.       
           05  RS-DNP-FLAG              PIC  X(01) VALUE 'N'.           
           05  RS-AR-LOCKOUT-IND        PIC X(01) VALUE SPACE.          
           05  RS-ACCT-XFER-TO          PIC X(13) VALUE SPACE.          
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE            PIC S9(09) COMP VALUE +0.       
REARCH     05  S-DNP-FLAG               PIC  X(01) VALUE 'N'.           
REARCH     05  S-AR-LOCKOUT-IND         PIC X(01) VALUE SPACE.          
REARCH     05  S-ACCT-XFER-TO           PIC X(13) VALUE SPACE.          
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
REARCH     10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
REARCH     10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
REARCH     10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
REARCH         49  S-HOST-VARIABLES-V  PIC X(255).                      
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-STATEMENT-V   PIC X(255).                      
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-DESCRIPTION-V PIC X(255).                      
           EXEC SQL                                                     01990000
              INCLUDE SQLCA                                             02000000
           END-EXEC.                                                    02010000
                                                                        
NEWNEW     EXEC SQL                                                     02051000
NEWNEW        INCLUDE TBLIEAP                                           02052000
NEWNEW     END-EXEC.                                                    02053000
                                                                        
TP8634     EXEC SQL                                                     02061000
TP8634        INCLUDE TBCNTDET                                          02062000
TP8634     END-EXEC.                                                    02063000
                                                                        
                                                                        
TP8634     EXEC SQL                                                     02069400
TP8634        INCLUDE TBFINLWO                                          02069500
TP8634     END-EXEC.                                                    02069600
                                                                        
T11816     EXEC SQL                                                     02069800
T11816        INCLUDE TBCRCOLL                                          02069900
T11816     END-EXEC.                                                    02070000
                                                                        
           EXEC SQL                                                     02071000
              INCLUDE TBARCNTL                                          02080000
           END-EXEC.                                                    02090000
                                                                        
           EXEC SQL                                                     02110000
              INCLUDE TBDFAACT                                          02120000
           END-EXEC.                                                    02130000
                                                                        
           EXEC SQL                                                     02150000
              INCLUDE TBBGTHST                                          02160000
           END-EXEC.                                                    02170000
                                                                        
           EXEC SQL                                                     02190000
              INCLUDE TBBGTPLN                                          02200000
           END-EXEC.                                                    02210000
                                                                        
           EXEC SQL                                                     02230000
              INCLUDE TBARHIST                                          02240000
           END-EXEC.                                                    02250000
                                                                        
           EXEC SQL                                                     02270000
              INCLUDE TBACCT                                            02280000
           END-EXEC.                                                    02290000
                                                                        
           EXEC SQL                                                     02310000
              INCLUDE TBARLOCK                                          02320000
           END-EXEC.                                                    02330000
                                                                        
           EXEC SQL                                                     02350000
              INCLUDE TBCUST                                            02360000
           END-EXEC.                                                    02370000
                                                                        
           EXEC SQL                                                     02390000
              INCLUDE TBPREM                                            02400000
           END-EXEC.                                                    02410000
                                                                        
           EXEC SQL                                                     02470000
              INCLUDE TBCNTRCT                                          02480000
           END-EXEC.                                                    02490000
                                                                        
           EXEC SQL                                                     02510000
              INCLUDE TBARHDT                                           02520000
           END-EXEC.                                                    02530000
                                                                        
           EXEC SQL                                                     02550000
              INCLUDE TBCDCNTL                                          02560000
           END-EXEC.                                                    02570000
                                                                        
           EXEC SQL                                                     02590000
              INCLUDE TBCDJRNL                                          02600000
           END-EXEC.                                                    02610000
                                                                        
           EXEC SQL                                                     02630000
              INCLUDE TBBJCNTL                                          02640000
           END-EXEC.                                                    02650000
                                                                        
           EXEC SQL                                                     02670000
              INCLUDE TBBTJRNL                                          02680000
           END-EXEC.                                                    02690000
                                                                        
           EXEC SQL                                                     02710000
              INCLUDE TBDEPREQ                                          02720000
           END-EXEC.                                                    02730000
                                                                        
           EXEC SQL                                                     02750000
              INCLUDE TBMSJRNL                                          02760000
           END-EXEC.                                                    02770000
                                                                        
           EXEC SQL                                                     02790000
              INCLUDE TBUSRPRF                                          02800000
           END-EXEC.                                                    02810000
                                                                        
           EXEC SQL                                                     02830000
              INCLUDE TBPRJSHR                                          02840000
           END-EXEC.                                                    02850000
                                                                        
           EXEC SQL                                                     02870000
              INCLUDE TBDFARCV                                          02880000
           END-EXEC.                                                    02890000
                                                                        
           EXEC SQL                                                     02990000
              INCLUDE TBGLATNO                                          03000000
           END-EXEC.                                                    03010000
                                                                        
           EXEC SQL                                                     03110000
              INCLUDE TBDEPHST                                          03120000
           END-EXEC.                                                    03130000
                                                                        
           EXEC SQL                                                     03150000
              INCLUDE TBDEPHND                                          03160000
           END-EXEC.                                                    03170000
                                                                        
           EXEC SQL                                                     03230000
              INCLUDE TBCHGOFF                                          03240000
           END-EXEC.                                                    03250000
                                                                        
           EXEC SQL                                                     03270000
              INCLUDE TBCRPROF                                          03280000
           END-EXEC.                                                    03290000
                                                                        
           EXEC SQL                                                     03310000
A00956        INCLUDE CWS0013B                                          03320000
           END-EXEC.                                                    03330000
                                                                        
           EXEC SQL                                                     03350000
              INCLUDE CWS00017                                          03360000
           END-EXEC.                                                    03370000
                                                                        
           EXEC SQL                                                     03390000
              INCLUDE CWS00061                                          03400000
           END-EXEC.                                                    03410000
                                                                        
           EXEC SQL                                                     03430000
              INCLUDE CWS00073                                          03440000
           END-EXEC.                                                    03450000
                                                                        
           EXEC SQL                                                     03470000
              INCLUDE CWS0116A                                          03480000
           END-EXEC.                                                    03490000
                                                                        
T33431     EXEC SQL                                                             
T33431       INCLUDE TBUTLENV                                                   
T33431     END-EXEC.                                                            
                                                                        
T33431     EXEC SQL                                                             
T33431       INCLUDE TBJBPARM                                                   
T33431     END-EXEC.                                                            
                                                                        
T33431     EXEC SQL                                                             
T33431       INCLUDE TBRTDESC                                                   
T33431     END-EXEC.                                                            
                                                                        
T17935     EXEC SQL                                                     03880001
              INCLUDE TBCCCHRG                                          03890000
T17935     END-EXEC.                                                    03900001
                                                                        
T18874*---< CSS_LOCAL_OFFICE >                                          01531000
           EXEC SQL                                                     01532000
              INCLUDE TBLOCOFC                                          01533000
           END-EXEC.                                                    01534000
C36929**---< CSS_DELINQUENCY >                                                  
C36929     EXEC SQL                                                     01532000
C36929        INCLUDE TBDELQ                                            01533000
C36929     END-EXEC.                                                    01534000
T18889                                                                  
HPCCDM*EJECT                                                            03510000
REARCH*                                                                         
REARCH LINKAGE SECTION.                                                 
REARCH 01  PARM-ACCOUNT-NO          PIC X(13).                          
REARCH 01  PARM-USER-ID             PIC X(07).                          
REARCH 01  PARM-PANEL-NO            PIC X(08).                          
REARCH 01  PARM-TRANS-HIST-SEQ-NO   PIC X(26).                          
REARCH 01  PARM-TRAN-COMMENT-LEN    PIC S9(09) COMP.                    
REARCH 01  PARM-TRAN-COMMENT-TEXT   PIC X(210).                         
REARCH 01  PARM-CASHIER-CODE        PIC X(02).                          
REARCH 01  PARM-CASH-COMPANY-NO     PIC X(02).                          
REARCH 01  PARM-CASH-LOCAL-OFFICE   PIC X(03).                          
REARCH 01  PARM-CASH-REPORT-NO      PIC X(03).                          
REARCH 01  PARM-DATE-CASH-REPORT    PIC X(10).                          
REARCH 01  PARM-CASH-DRAWER-ID      PIC S9(04) COMP.                    
REARCH 01  PARM-CSR-PC-ID           PIC X(04).                          
REARCH 01  PARM-LAST-UPDATE-TS      PIC X(26).                          
REARCH*                                                                         
REARCH PROCEDURE DIVISION USING  PARM-ACCOUNT-NO                        
REARCH                           PARM-USER-ID                           
REARCH                           PARM-PANEL-NO                          
REARCH                           PARM-TRANS-HIST-SEQ-NO                 
REARCH                           PARM-TRAN-COMMENT-LEN                  
REARCH                           PARM-TRAN-COMMENT-TEXT                 
REARCH                           PARM-CASHIER-CODE                      
REARCH                           PARM-CASH-COMPANY-NO                   
REARCH                           PARM-CASH-LOCAL-OFFICE                 
REARCH                           PARM-CASH-REPORT-NO                    
REARCH                           PARM-DATE-CASH-REPORT                  
REARCH                           PARM-CASH-DRAWER-ID                    
REARCH                           PARM-CSR-PC-ID                         
REARCH                           PARM-LAST-UPDATE-TS.                   

SCA006        SET WS-GL-SUB TO 1.
                                                                        
      ******************************************************************03540000
      * 0000-MAINLINE                                                  *03550000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *03560000
      ******************************************************************03570000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03680000
      * 0100-INITIALIZE                                                *03690000
      *                                                                *03700000
      *                                                                *03710000
      *     1. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *03720000
      *     2. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *03730000
      *     3. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*03740000
      *                                                                *03750000
      ******************************************************************03760000
                                                                        
       0100-INITIALIZE.                                                 
           MOVE '0100' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR CONTINUE END-EXEC.                
           EXEC SQL WHENEVER NOT FOUND CONTINUE END-EXEC.               
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARCH            :S-RETURN-CODE      AS RETURN_CODE                    
REARCH           ,:S-DNP-FLAG         AS DNP_FLAG                       
REARCH           ,:S-AR-LOCKOUT-IND   AS AR_LOCKOUT_IND                 
REARCH           ,:S-ACCT-XFER-TO     AS ACCT_XFER_TO                   
REARCH         FROM                                                     
REARCH             CIS.SYSDUMMY1                                     
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*           :S-RETURN-CODE      AS RETURN_CODE                            
MFA-TR*          ,:S-DNP-FLAG         AS DNP_FLAG                               
MFA-TR*          ,:S-AR-LOCKOUT-IND   AS AR_LOCKOUT_IND                         
MFA-TR*          ,:S-ACCT-XFER-TO     AS ACCT_XFER_TO                           
MFA-TR*        FROM                                                             
MFA-TR*            SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC.                                                            
REARCH*                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************04010000
      * 1000-PROCESS-INPUT.                                            *04020000
      *                                                                *04030000
      *     1. RECEIVE PARMS.                                          *04040000
      *                                                                *04050000
      ******************************************************************04060000
                                                                        
       1000-PROCESS-INPUT.                                              
T22428     INITIALIZE SCSCA182-LINK-RECORD.                             
T22428     MOVE PARM-ACCOUNT-NO           TO SCSCA182-ACCOUNT-NO.       
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05510000
      * 2000-PROCESS-OUTPUT.                                           *05520000
      *                                                                *05530000
      *     1. DESCRIBE RESULT SET                                     *05540000
      *     2. UPDATE DB2 DATA                                         *05550000
      *     3. BUILD RESULT SET                                        *05560000
      *     4. SEND RESULT SET                                         *05570000
      *                                                                *05580000
      ******************************************************************05590000
                                                                        
       2000-PROCESS-OUTPUT.                                             
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 2200-PROCESS THRU 2200-EXIT.                         
                                                                        
           IF CTR-ROWS < 1                                              
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
REARCH        PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT                
REARCH        ADD +1                     TO   CTR-ROWS                  
REARCH     END-IF.                                                      
REARCH*                                                                         
       2000-EXIT. EXIT.                                                 
                                                                        
REARCH*****************************************************************         
REARCH* 2000A-MOVE-RESULT.                                            *         
REARCH*****************************************************************         
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE  RS-RETURN-CODE           TO S-RETURN-CODE.             
REARCH     MOVE  RS-DNP-FLAG              TO S-DNP-FLAG.                
REARCH     MOVE  RS-AR-LOCKOUT-IND        TO S-AR-LOCKOUT-IND.          
REARCH     MOVE  RS-ACCT-XFER-TO          TO S-ACCT-XFER-TO.            
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
      ******************************************************************06650000
      * 2200-PROCESS.                                                  *06660000
      ******************************************************************06670000
                                                                        
       2200-PROCESS.                                                    
                                                                        
           PERFORM 7999-SELECT-AL THRU 7999-SELECT-AL-EXIT.             
           IF AL-AR-LOCKOUT-IND = 'Y'                                   
              MOVE 5000 TO RS-RETURN-CODE                               
              MOVE AL-AR-LOCKOUT-IND        TO RS-AR-LOCKOUT-IND        
REARCH        PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT             
REARCH        ADD +1                        TO   CTR-ROWS               
              PERFORM 9999-END-PROGRAM      THRU 9999-EXIT              
           END-IF.                                                      
                                                                        
T22428     IF PARM-PANEL-NO = 'PANEL118'                                
T22428       PERFORM 9200-LINK-SCSCA182       THRU 9200-EXIT            
T22428       IF  SCSCA182-RETURN-CODE         NOT EQUAL ZERO            
T22428           MOVE PROGRAM-NAME            TO ABEND-PROGRAM          
T22428           MOVE SCSCA182-RETURN-CODE    TO WS-ACTIVE-RETURN-CODE  
T22428                                           SQLCODE                
REARCH           PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT           
REARCH           ADD +1                       TO CTR-ROWS               
T22428           PERFORM 9000-SEND-ERROR-RESULT                         
T22428                                        THRU 9000-EXIT            
T22428           PERFORM 9900-SQL-ERROR-ROUTINE                         
T22428                                        THRU 9900-EXIT            
T22428       ELSE                                                       
T22428           MOVE SCSCA182-LAST-UPDATE-TS TO WS-LAST-UPDATE-TS      
T22428           IF  PARM-LAST-UPDATE-TS = WS-LAST-UPDATE-TS            
T22428               CONTINUE                                           
T22428           ELSE                                                   
T22428               MOVE 5272                TO RS-RETURN-CODE         
REARCH               PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT          
REARCH               ADD +1                    TO   CTR-ROWS            
T22428*              PERFORM 8100-SEND-RESULT THRU 8100-EXIT            10606000
T22428               GO TO 2000-EXIT                                    
T22428           END-IF                                                 
T22428       END-IF                                                     
T22428     END-IF.                                                      
           PERFORM 7000-GET-CURRENT-TIMESTAMP THRU 7000-EXIT.           
           MOVE PARM-ACCOUNT-NO     TO WS-ACCOUNT-NO.                   
           MOVE WS-ACCOUNT-NO   TO WS-ACCOUNT-NO-COMP3.                 
NEWNEW     MOVE WS-ACCOUNT-NO   TO LI-ACCOUNT-NO.                       
                                                                        
           MOVE WS-ACCOUNT-NO-COMP3  TO AT-ACCOUNT-NO.                  
T22428*                                                                         
T22428     IF PARM-PANEL-NO = 'PANEL118'                                
T22428        PERFORM 2400-UPDATE-AT-ACCT     THRU 2400-EXIT            
T22428     END-IF.                                                      
T22428*                                                                         
           PERFORM 7999-SELECT-TRANSFER-IND                             
              THRU 7999-SELECT-TRANSFER-IND-EXIT.                       
NEWNEW     MOVE AT-ACCT-XFER-TO          TO RS-ACCT-XFER-TO.            
                                                                        
           PERFORM 2300-CREATE-AR-FOR-REV     THRU 2300-EXIT.           
PCR404     MOVE PARM-USER-ID        TO AR-USER-ID.                      
PCR404     MOVE PARM-PANEL-NO       TO AR-APPL-PROGRAM-ID.              
TP5640     MOVE ZEROS TO WS-NULL-IND1                                   
TP5640                   WS-NULL-IND2                                   
TP5640                   WS-NULL-IND3.                                  
           MOVE 'C' TO AR-CODE-TRAN-TYPE.                               
           MOVE AR-DATE-TRANS           TO AR-DATE-ORIG-PYMT.           
           MOVE WS-CURRENT-DATE         TO AR-DATE-TRANS.               
           MOVE PARM-TRAN-COMMENT-TEXT  TO WS-TRAN-COMMENT-TEXT.        
           MOVE PARM-TRAN-COMMENT-LEN   TO WS-TRAN-COMMENT-LEN.         
           MOVE WS-TRAN-COMMENT-TEXT    TO AR-TRAN-COMMENT-TEXT.        
C31601     MOVE WS-TRAN-COMMENT-TEXT    TO WS-JRNL-TRAN-COMMENT-TEXT.   
C31601     IF WS-TRAN-COMMENT-LEN > 210                                 
C31601        MOVE 210                  TO WS-TRAN-COMMENT-LEN          
C31601     END-IF                                                       
           MOVE WS-TRAN-COMMENT-LEN     TO AR-TRAN-COMMENT-LEN.         
C31601     MOVE WS-TRAN-COMMENT-LEN     TO WS-JRNL-TRAN-COMMENT-LEN.    
           MOVE 'Y'                     TO  WS-REVERSAL-FLAG.           
NEWNEW     IF PARM-PANEL-NO = 'PANEL378'                                
NEWNEW        MOVE '01'                 TO PARM-CASH-COMPANY-NO         
NEWNEW        MOVE 9999                 TO PARM-CASH-DRAWER-ID          
NEWNEW        MOVE '998'                TO PARM-CASH-LOCAL-OFFICE       
NEWNEW        MOVE '998'                TO PARM-CASH-REPORT-NO          
NEWNEW        MOVE WS-CURRENT-DATE      TO PARM-DATE-CASH-REPORT        
NEWNEW        MOVE WS-VOUCHER-REVERSAL  TO AR-APPL-PROGRAM-ID           
T11537*       MOVE 'N'                  TO WS-REVERSAL-FLAG             07036200
NEWNEW     END-IF.                                                      
           MOVE PARM-CASH-COMPANY-NO   TO AR-CASH-COMPANY-NO.           
           MOVE PARM-CASH-LOCAL-OFFICE TO AR-CASH-LOCAL-OFFICE.         
           MOVE PARM-CASH-REPORT-NO    TO AR-CASH-REPORT-NO.            
           MOVE PARM-DATE-CASH-REPORT  TO AR-DATE-CASH-REPORT.          
           MOVE PARM-CASH-DRAWER-ID     TO AR-CASH-DRAWER-ID.           
           PERFORM 7150-INSERT-AR-TRANS-HIST THRU 7150-EXIT.            
           MOVE AR-AMT-ORIG-ENTERED   TO WS-AMOUNT-REFUNDED.            
           MOVE 'F'                   TO WS-PART-CASH-PROCESS-FLG.      
           MOVE 'RVR'                 TO WS-CHECK-CASH-IND.             
           MOVE '183B'                TO WS-116-NON-CASH-TRAN-NO.       
           MOVE PARM-USER-ID          TO WS-USER-ID.                    
           MOVE AR-ACCOUNT-NO         TO AU-ACCOUNT-NO                  
                                         AT-ACCOUNT-NO.                 
           MOVE WS-ACCOUNT-NO-COMP3   TO CZ-ACCOUNT-NO.                 
      * CHECK IF PAYMENT CANCELLED A DNP IF SO SET DNP-FLAG             07220000
           PERFORM 7300-PROCESS-DNP       THRU 7300-EXIT.               
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE 'N' TO RS-DNP-FLAG                                   
           ELSE                                                         
              MOVE 'Y' TO RS-DNP-FLAG                                   
           END-IF.                                                      
                                                                        
           MOVE PARM-CASH-COMPANY-NO    TO  WS-CD-COMPANY-NO.           
           MOVE PARM-CASH-LOCAL-OFFICE  TO  WS-CD-LOCAL-OFFICE.         
           MOVE PARM-CASH-REPORT-NO     TO  WS-CD-REPORT-NO.            
           MOVE PARM-DATE-CASH-REPORT   TO  WS-CD-REPORT-DATE.          
           MOVE PARM-CASH-DRAWER-ID     TO  WS-CASH-DRAWER-ID.          
P353       MOVE PARM-CSR-PC-ID          TO  WS-JRNL-OL-CSR-PC-ID.       
REARCH     MOVE EIBTRNID                TO  WS-CSH-DRWR-TRAN-ID         
                                                                        
           PERFORM 6904-INSERT-AR-DETAILS THRU 6904-EXIT.               
                                                                        
NEWNEW*    IF PARM-PANEL-NO = 'PANEL378'                                07371000
T19163     IF PARM-PANEL-NO = 'PANEL378' OR 'PANEL118'                  
NEWNEW        PERFORM 8110-DELETE-LI-ROW    THRU 8110-EXIT              
NEWNEW     END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07420000
      * 2300-CREATE-AR-FOR-REV                                         *07430000
      ******************************************************************07440000
                                                                        
       2300-CREATE-AR-FOR-REV.                                          
           MOVE PARM-TRANS-HIST-SEQ-NO TO AR-TRANS-HIST-SEQ-NO          
                                          WS-INPUT-TRANS-HIST-SEQ-NO    
                                          WS-PREV-TRANS-HIST-SEQ-NO     
NEWNEW                                    LI-VOUCHER-PAY-DT.            
           MOVE WS-ACCOUNT-NO-COMP3   TO AR-ACCOUNT-NO.                 
           PERFORM 7100-SELECT-AR-TRANS-HIST THRU 7100-EXIT.            
                                                                        
           IF AR-DATE-ORIG-PYMT EQUAL SPACES                            
              MOVE -1 TO WS-NULL-IND1                                   
                         WS-DATE-ORIG-PYMT-IND                          
           END-IF                                                       
           IF AR-DATE-TRANS     EQUAL SPACES                            
              MOVE -1 TO WS-NULL-IND2                                   
           END-IF                                                       
                                                                        
           IF AR-TRANS-HIST-SEQ-NO EQUAL SPACES                         
              MOVE -1 TO WS-NULL-IND3                                   
           END-IF                                                       
                                                                        
           MOVE 'Y'                 TO AR-PYMT-REFUNDED-IND.            
           IF PARM-PANEL-NO = 'PANEL378'                                
              MOVE WS-VOUCHER-REVERSED TO AR-APPL-PROGRAM-ID            
           ELSE                                                         
PCR404        MOVE WS-PAYMENT-REVERSED TO AR-APPL-PROGRAM-ID            
           END-IF.                                                      
           MOVE AR-DATE-TRANS       TO WS-PREV-DATE-TRANS.              
                                                                        
      * CHECK IF BILLINGS OCCURED ATER PAYMENT IF NOT MARK JOURNAL      07690000
      * ENTRIES FOR RECORD ONLY.                                        07700000
           PERFORM 7250-PROCESS-RECORD-ONLY THRU 7250-EXIT.             
      * NOT-FOUND MEANS THERE WAS NO BILLING FOUND SO RECORD ONLY       07720000
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE 'Y' TO WS-RECORD-ONLY                                
           END-IF.                                                      
           MOVE WS-RECORD-ONLY TO AR-RECORD-ONLY-FL.                    
           PERFORM 7200-UPDATE-AR-TRANS-HIST THRU 7200-EXIT.            
T24339*** CPD00010 CHANGES                                                      
T24339     MOVE AR-TRANS-HIST-SEQ-NO(1:10) TO WS-DATE                   
T24339     MOVE AR-TRANS-HIST-SEQ-NO(12:8) TO WS-TIME                   
T24339     PERFORM 7251-GET-ADJ-RECORD        THRU 7251-EXIT.           
T24339     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T24339             OR WS-FOUND-MULT-BILLS                               
T24339        MOVE WS-ADJ-TRANS-HIST-SEQ-NO    TO                       
T24339                                    AR-TRANS-HIST-SEQ-NO          
T24339        MOVE 'PANEL113H'         TO AR-APPL-PROGRAM-ID            
T24339        PERFORM 7200-UPDATE-AR-TRANS-HIST THRU 7200-EXIT          
T24339     END-IF                                                       
T24339*** CPD00010 CHANGES                                                      
           PERFORM 7000-GET-CURRENT-TIMESTAMP THRU 7000-EXIT.           
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
T22428******************************************************************07420000
T22428* 2400-UPDATE-AT-ACCT                                            *07430000
T22428* TO UPDATE LAST_UPDATE_TS IN CSS_ACCOUNT                        *        
T22428******************************************************************07440000
T22428 2400-UPDATE-AT-ACCT.                                             
T22428*                                                                 07470000
T22428     EXEC SQL                                                     
T22428         UPDATE CSS_ACCOUNT                                       
T22428            SET LAST_UPDATE_TS  = CIS.CHAR2TIMESTAMP(
                                                  :WS-CURRENT-TIMESTAMP
              )           
T22428          WHERE ACCOUNT_NO      = :AT-ACCOUNT-NO                  
T22428     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ACCOUNT                                               
MFA-TR*           SET LAST_UPDATE_TS  = :WS-CURRENT-TIMESTAMP                   
MFA-TR*         WHERE ACCOUNT_NO      = :AT-ACCOUNT-NO                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T22428                                                                  
T22428     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T22428     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
T22428         NEXT SENTENCE                                            
T22428     ELSE                                                         
T22428         MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
T22428         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
T22428         MOVE '2400'                TO ACTIVE-PARAGRAPH           
T22428         MOVE 'UPDATE'              TO ABEND-FUNCTION             
T22428         MOVE SPACES                TO ABEND-SQL-PREDICATES       
T22428                                       ABEND-TABLES               
T22428         MOVE 'CSS_ACCOUNT'         TO TABLE-1                    
T22428         MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
T22428         MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
T22428         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
T22428         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
T22428     END-IF.                                                      
T22428 2400-EXIT.                                                       
T22428     EXIT.                                                        
      ******************************************************************07820000
      * 6400 - FINANCIAL JOURNALING ROUTINE                            *07830000
      ******************************************************************07840000
           EXEC SQL                                                     07850000
A00956       INCLUDE CPD0006A                                           07860000
           END-EXEC.                                                    07870000
                                                                        
           EXEC SQL                                                     07890000
              INCLUDE CPD00116                                          07940000
           END-EXEC.                                                    07950000
                                                                        
                                                                        
                                                                        
      ****************************************************************  07990000
      * 7000-GET-CURRENT-TIMESTAMP.                               *     08000000
      ****************************************************************  08010000
                                                                        
       7000-GET-CURRENT-TIMESTAMP.                                      
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     08040000
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP           08050000
MFA-TR*    END-EXEC.                                                    08060000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     08080000
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                     08090000
MFA-TR*    END-EXEC.                                                    08100000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE WS-CURRENT-TIMESTAMP  TO AR-TRANS-HIST-SEQ-NO.          
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************  08160000
      * 7100-SELECT-AR-TRANS-HIST                                 *     08170000
      ****************************************************************  08180000
                                                                        
       7100-SELECT-AR-TRANS-HIST.                                       
           EXEC SQL                                                     
               SELECT DATE_TRANS,                                       
                      CODE_TRAN_TYPE,                                   
                      AMT_ORIG_ENTERED,                                 
                      AMT_BILLED_UNPAID,                                
                      RESP_AREA_ID,                                     
                      APPL_PROGRAM_ID,                                  
                      PYMT_FACILITY_CD,                                 
                      USER_ID,                                          
                      COMPANY_NO,                                       
                      RECORD_ONLY_FL,                                   
                      DATE_ORIG_PYMT,                                   
                      CASH_COMPANY_NO,                                  
                      CASH_LOCAL_OFFICE,                                
                      CASH_REPORT_NO,                                   
                      DATE_CASH_REPORT,                                 
                      CASH_DRAWER_ID,                                   
                      TRAN_COMMENT                                      
                 INTO  :AR-DATE-TRANS :WS-NULL-IND1,                     
                       :AR-CODE-TRAN-TYPE,                              
                       :AR-AMT-ORIG-ENTERED,                            
                       :AR-AMT-BILLED-UNPAID,                           
                       :AR-RESP-AREA-ID,                                
                       :AR-APPL-PROGRAM-ID,                             
                       :AR-PYMT-FACILITY-CD,                            
                       :AR-USER-ID,                                     
                       :AR-COMPANY-NO,                                  
                       :AR-RECORD-ONLY-FL,                              
                       :AR-DATE-ORIG-PYMT :WS-NULL-IND2,                 
                       :AR-CASH-COMPANY-NO,                             
                       :AR-CASH-LOCAL-OFFICE,                           
                       :AR-CASH-REPORT-NO,                              
                       :AR-DATE-CASH-REPORT,                            
                       :AR-CASH-DRAWER-ID,                              
                       :AR-TRAN-COMMENT                                 
              FROM CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                      
              WHERE ACCOUNT_NO = :AR-ACCOUNT-NO AND                     
                    TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )           
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     08210000
MFA-TR*        SELECT DATE_TRANS,                                       08220000
MFA-TR*               CODE_TRAN_TYPE,                                   08230000
MFA-TR*               AMT_ORIG_ENTERED,                                 08240000
MFA-TR*               AMT_BILLED_UNPAID,                                08250000
MFA-TR*               RESP_AREA_ID,                                     08260000
MFA-TR*               APPL_PROGRAM_ID,                                  08270000
MFA-TR*               PYMT_FACILITY_CD,                                 08280000
MFA-TR*               USER_ID,                                          08290000
MFA-TR*               COMPANY_NO,                                       08300000
MFA-TR*               RECORD_ONLY_FL,                                   08310000
MFA-TR*               DATE_ORIG_PYMT,                                   08320000
MFA-TR*               CASH_COMPANY_NO,                                  08330000
MFA-TR*               CASH_LOCAL_OFFICE,                                08340000
MFA-TR*               CASH_REPORT_NO,                                   08350000
MFA-TR*               DATE_CASH_REPORT,                                 08360000
MFA-TR*               CASH_DRAWER_ID,                                   08370000
MFA-TR*               TRAN_COMMENT                                      08380000
MFA-TR*          INTO  :AR-DATE-TRANS:WS-NULL-IND1,                     08390000
MFA-TR*                :AR-CODE-TRAN-TYPE,                              08400000
MFA-TR*                :AR-AMT-ORIG-ENTERED,                            08410000
MFA-TR*                :AR-AMT-BILLED-UNPAID,                           08420000
MFA-TR*                :AR-RESP-AREA-ID,                                08430000
MFA-TR*                :AR-APPL-PROGRAM-ID,                             08440000
MFA-TR*                :AR-PYMT-FACILITY-CD,                            08450000
MFA-TR*                :AR-USER-ID,                                     08460000
MFA-TR*                :AR-COMPANY-NO,                                  08470000
MFA-TR*                :AR-RECORD-ONLY-FL,                              08480000
MFA-TR*                :AR-DATE-ORIG-PYMT:WS-NULL-IND2,                 08490000
MFA-TR*                :AR-CASH-COMPANY-NO,                             08500000
MFA-TR*                :AR-CASH-LOCAL-OFFICE,                           08510000
MFA-TR*                :AR-CASH-REPORT-NO,                              08520000
MFA-TR*                :AR-DATE-CASH-REPORT,                            08530000
MFA-TR*                :AR-CASH-DRAWER-ID,                              08540000
MFA-TR*                :AR-TRAN-COMMENT                                 08550000
MFA-TR*       FROM CSS_AR_TRANS_HIST                                    08560000
MFA-TR*       WHERE ACCOUNT_NO = :AR-ACCOUNT-NO AND                     08570000
MFA-TR*             TRANS_HIST_SEQ_NO = :AR-TRANS-HIST-SEQ-NO           08580000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    08590000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           IF WS-NULL-IND1 < 0                                          
              MOVE SPACES TO AR-DATE-TRANS                              
           END-IF.                                                      
                                                                        
           IF WS-NULL-IND2 < 0                                          
              MOVE SPACES TO AR-DATE-ORIG-PYMT                          
           END-IF.                                                      
                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_AR_TRANS_HIST'   TO TABLE-1                     
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AR-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
       7100-EXIT.                                                       
           EXIT.                                                        
      ****************************************************************  08850000
      * 7150-INSERT-AR-TRANS-HIST                                 *     08860000
      ****************************************************************  08870000
       7150-INSERT-AR-TRANS-HIST.                                       
           EXEC SQL                                                     
               INSERT INTO CSS_AR_TRANS_HIST                            
                   ( ACCOUNT_NO,                                        
                     TRANS_HIST_SEQ_NO,                                 
                     DATE_TRANS,                                        
                     CODE_TRAN_TYPE,                                    
                     AMT_ORIG_ENTERED,                                  
                     AMT_BILLED_UNPAID,                                 
                     RESP_AREA_ID,                                      
                     APPL_PROGRAM_ID,                                   
                     PYMT_FACILITY_CD,                                  
                     USER_ID,                                           
                     COMPANY_NO,                                        
                     RECORD_ONLY_FL,                                    
                     DATE_ORIG_PYMT,                                    
                     PYMT_REFUNDED_IND,                                 
                     CASH_COMPANY_NO,                                   
                     CASH_LOCAL_OFFICE,                                 
                     CASH_REPORT_NO,                                    
                     DATE_CASH_REPORT,                                  
                     CASH_DRAWER_ID,                                    
                     TRAN_COMMENT)                                      
       VALUES                                                           
           ( :AR-ACCOUNT-NO,                                            
             CIS.CHAR2TIMESTAMP(:AR-TRANS-HIST-SEQ-NO :WS-NULL-IND3),           
             IIF(TRY_CONVERT(DATE, :AR-DATE-TRANS :WS-NULL-IND2
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-TRANS 
                                                          :WS-NULL-IND2
              ) <> 0) OR (LEN(:AR-DATE-TRANS :WS-NULL-IND2
              ) <> 10), CIS.CHAR2DATE(:AR-DATE-TRANS :WS-NULL-IND2
              ), CONVERT(DATE, :AR-DATE-TRANS :WS-NULL-IND2) ),                
             :AR-CODE-TRAN-TYPE,                                        
             :AR-AMT-ORIG-ENTERED,                                      
             :AR-AMT-BILLED-UNPAID,                                     
             :AR-RESP-AREA-ID,                                          
             :AR-APPL-PROGRAM-ID,                                       
             :AR-PYMT-FACILITY-CD,                                      
             :AR-USER-ID,                                               
             :AR-COMPANY-NO,                                            
             :AR-RECORD-ONLY-FL,                                        
             IIF(TRY_CONVERT(DATE, :AR-DATE-ORIG-PYMT :WS-NULL-IND1
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-ORIG-PYMT 
                                                          :WS-NULL-IND1
              ) <> 0) OR (LEN(:AR-DATE-ORIG-PYMT :WS-NULL-IND1
              ) <> 10), CIS.CHAR2DATE(:AR-DATE-ORIG-PYMT :WS-NULL-IND1
              ), CONVERT(DATE, :AR-DATE-ORIG-PYMT :WS-NULL-IND1) ),            
             :AR-PYMT-REFUNDED-IND,                                     
             :AR-CASH-COMPANY-NO,                                       
             :AR-CASH-LOCAL-OFFICE,                                     
             :AR-CASH-REPORT-NO,                                        
             IIF(TRY_CONVERT(DATE, :AR-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:AR-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:AR-DATE-CASH-REPORT
              ), CONVERT(DATE, :AR-DATE-CASH-REPORT) ),                        
             :AR-CASH-DRAWER-ID,                                        
             :AR-TRAN-COMMENT)                                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     08890000
MFA-TR*        INSERT INTO CSS_AR_TRANS_HIST                            08900000
MFA-TR*            ( ACCOUNT_NO,                                        08910000
MFA-TR*              TRANS_HIST_SEQ_NO,                                 08920000
MFA-TR*              DATE_TRANS,                                        08930000
MFA-TR*              CODE_TRAN_TYPE,                                    08940000
MFA-TR*              AMT_ORIG_ENTERED,                                  08950000
MFA-TR*              AMT_BILLED_UNPAID,                                 08960000
MFA-TR*              RESP_AREA_ID,                                      08970000
MFA-TR*              APPL_PROGRAM_ID,                                   08980000
MFA-TR*              PYMT_FACILITY_CD,                                  08990000
MFA-TR*              USER_ID,                                           09000000
MFA-TR*              COMPANY_NO,                                        09010000
MFA-TR*              RECORD_ONLY_FL,                                    09020000
MFA-TR*              DATE_ORIG_PYMT,                                    09030000
MFA-TR*              PYMT_REFUNDED_IND,                                 09040000
MFA-TR*              CASH_COMPANY_NO,                                   09050000
MFA-TR*              CASH_LOCAL_OFFICE,                                 09060000
MFA-TR*              CASH_REPORT_NO,                                    09070000
MFA-TR*              DATE_CASH_REPORT,                                  09080000
MFA-TR*              CASH_DRAWER_ID,                                    09090000
MFA-TR*              TRAN_COMMENT)                                      09100000
MFA-TR*VALUES                                                           09110000
MFA-TR*    ( :AR-ACCOUNT-NO,                                            09120000
MFA-TR*      :AR-TRANS-HIST-SEQ-NO:WS-NULL-IND3,                        09130000
MFA-TR*      :AR-DATE-TRANS:WS-NULL-IND2,                               09140000
MFA-TR*      :AR-CODE-TRAN-TYPE,                                        09150000
MFA-TR*      :AR-AMT-ORIG-ENTERED,                                      09160000
MFA-TR*      :AR-AMT-BILLED-UNPAID,                                     09170000
MFA-TR*      :AR-RESP-AREA-ID,                                          09180000
MFA-TR*      :AR-APPL-PROGRAM-ID,                                       09190000
MFA-TR*      :AR-PYMT-FACILITY-CD,                                      09200000
MFA-TR*      :AR-USER-ID,                                               09210000
MFA-TR*      :AR-COMPANY-NO,                                            09220000
MFA-TR*      :AR-RECORD-ONLY-FL,                                        09230000
MFA-TR*      :AR-DATE-ORIG-PYMT:WS-NULL-IND1,                           09240000
MFA-TR*      :AR-PYMT-REFUNDED-IND,                                     09250000
MFA-TR*      :AR-CASH-COMPANY-NO,                                       09260000
MFA-TR*      :AR-CASH-LOCAL-OFFICE,                                     09270000
MFA-TR*      :AR-CASH-REPORT-NO,                                        09280000
MFA-TR*      :AR-DATE-CASH-REPORT,                                      09290000
MFA-TR*      :AR-CASH-DRAWER-ID,                                        09300000
MFA-TR*      :AR-TRAN-COMMENT)                                          09310000
MFA-TR*    END-EXEC.                                                    09320000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7150'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_AR_TRANS_HIST'       TO TABLE-1                 
CBSI          MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
CBSI          MOVE 'AMT_ORIG_ENTERED'        TO TABLE-ELEMENT-2         
CBSI          MOVE 'DATE_TRANS'              TO TABLE-ELEMENT-3         
CBSI          MOVE 'DATE_CASH_REPORT'        TO TABLE-ELEMENT-4         
              MOVE AR-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
CBSI          MOVE AR-AMT-ORIG-ENTERED       TO HOSTVAR-ELEMENT-2-N     
              MOVE AR-DATE-TRANS             TO HOSTVAR-ELEMENT-3       
CBSI          MOVE AR-DATE-CASH-REPORT       TO HOSTVAR-ELEMENT-4       
CBSI          PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  09490000
      * 7200-UPDATE-AR-TRANS-HIST                                 *     09500000
      ****************************************************************  09510000
       7200-UPDATE-AR-TRANS-HIST.                                       
           EXEC SQL                                                     
               UPDATE CSS_AR_TRANS_HIST                                 
                  SET USER_ID           = :AR-USER-ID,                  
                      APPL_PROGRAM_ID   = :AR-APPL-PROGRAM-ID,          
                      PYMT_REFUNDED_IND = :AR-PYMT-REFUNDED-IND,        
                      RECORD_ONLY_FL    = :AR-RECORD-ONLY-FL            
                WHERE ACCOUNT_NO        = :AR-ACCOUNT-NO                
                  AND TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     09530000
MFA-TR*        UPDATE CSS_AR_TRANS_HIST                                 09540000
MFA-TR*           SET USER_ID           = :AR-USER-ID,                  09550000
MFA-TR*               APPL_PROGRAM_ID   = :AR-APPL-PROGRAM-ID,          09560000
MFA-TR*               PYMT_REFUNDED_IND = :AR-PYMT-REFUNDED-IND,        09570000
MFA-TR*               RECORD_ONLY_FL    = :AR-RECORD-ONLY-FL            09580000
MFA-TR*         WHERE ACCOUNT_NO        = :AR-ACCOUNT-NO                09590000
MFA-TR*           AND TRANS_HIST_SEQ_NO = :AR-TRANS-HIST-SEQ-NO         09600000
MFA-TR*    END-EXEC.                                                    09610000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7200'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE 'CSS_AR_TRANS_HIST'       TO TABLE-1                 
CBSI          MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
CBSI          MOVE 'PYMT_REFUNDED_IND'       TO TABLE-ELEMENT-2         
CBSI          MOVE 'USER_ID'                 TO TABLE-ELEMENT-3         
CBSI          MOVE 'APPL_PROGRAM_ID'         TO TABLE-ELEMENT-4         
              MOVE AR-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
CBSI          MOVE AR-PYMT-REFUNDED-IND      TO HOSTVAR-ELEMENT-2       
CBSI          MOVE AR-USER-ID                TO HOSTVAR-ELEMENT-3       
CBSI          MOVE AR-APPL-PROGRAM-ID        TO HOSTVAR-ELEMENT-4       
CBSI          PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************  09780000
      * 7250-PROCESS-RECORD-ONLY.                                   *   09790000
      * THE SELECT DETERMINES IF A BILLING OCCURRED AFTER THE       *   09800000
      * PAYMENT WAS MADE. IF NOT THIS MEANS THE JOURNALING IS FOR   *   09810000
      * RECORDS ONLY. NOTE THIS SELECT MAY BRING BACK MORE THAN ONE  *  09820000
      * ROW IF SO MULTIPLE BILLINGS HAVE OCCURED.                   *   09830000
      ****************************************************************  09840000
       7250-PROCESS-RECORD-ONLY.                                        
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), TRANS_HIST_SEQ_NO
           , 121), ' ', '-'), ':', '.') TRANS_HIST_SEQ_NO                      
              INTO :WS-TRANS-HIST-SEQ-NO                                
                FROM CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                    
              WHERE ACCOUNT_NO = :AR-ACCOUNT-NO                         
              AND TRANS_HIST_SEQ_NO > CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )             
              AND CODE_TRAN_TYPE = 'B'                                  
              AND CIS.SUBSTR3(APPL_PROGRAM_ID,1,5) IN ('PCSCA','SCSCA')      
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     09860000
MFA-TR*       SELECT TRANS_HIST_SEQ_NO                                  09870000
MFA-TR*       INTO :WS-TRANS-HIST-SEQ-NO                                09880000
MFA-TR*         FROM CSS_AR_TRANS_HIST                                  09890000
MFA-TR*       WHERE ACCOUNT_NO = :AR-ACCOUNT-NO                         09900000
MFA-TR*       AND TRANS_HIST_SEQ_NO > :AR-TRANS-HIST-SEQ-NO             09910000
MFA-TR*       AND CODE_TRAN_TYPE = 'B'                                  09920000
MFA-TR*       AND SUBSTR(APPL_PROGRAM_ID,1,5) IN ('PCSCA','SCSCA')      09930000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    09940000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              OR NOT-FOUND OR WS-FOUND-MULT-BILLS                       
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7250'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_AR_TRANS_HIST'       TO TABLE-1                 
CBSI          MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE AR-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
CBSI          PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
T24339****************************************************************  09780000
T24339* 7251-GET-ADJ-RECORD.                                         *  09790000
T24339* THE SELECT GETS THE ADJ RECORD FOR THE PAYMENT TO BE         *  09800000
T24339* REVERSED. WHEN THE PAYMENT ROW IS REVERSED THE RECORD ONLY   *  09810000
T24339* FLAG FOR THE ADJ ROW SHOULD ALSO BE SET                      *  09820000
T24339****************************************************************  09840000
T24339 7251-GET-ADJ-RECORD.                                             
T24339     EXEC SQL                                                     
T24339        SELECT REPLACE(REPLACE(CONVERT(CHAR(26), TRANS_HIST_SEQ_NO
           , 121), ' ', '-'), ':', '.') TRANS_HIST_SEQ_NO                      
T24339        INTO :WS-ADJ-TRANS-HIST-SEQ-NO                            
T24339          FROM CSS_AR_TRANS_HIST WITH(READUNCOMMITTED)                    
T24339        WHERE ACCOUNT_NO = :AR-ACCOUNT-NO                         
T24339        AND TRANS_HIST_SEQ_NO <= CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )            
T24339        AND DATE_TRANS = IIF(TRY_CONVERT(DATE, :AR-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :AR-DATE-TRANS
              ) <> 0) OR (LEN(:AR-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :AR-DATE-TRANS
              ), CONVERT(DATE, :AR-DATE-TRANS) )                           
T24339        AND CODE_TRAN_TYPE = 'A'                                  
T24339        AND APPL_PROGRAM_ID = 'PANEL113H'                         
T24339        AND CAST(TRANS_HIST_SEQ_NO AS DATE) = 
              IIF(TRY_CONVERT(DATE, :WS-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE) <> 0) OR (LEN(
                                                               :WS-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-DATE), CONVERT(DATE, :WS-DATE
              ) )                    
T24339        AND DATEADD(NANOSECOND, -DATEPART(NANOSECOND, CAST(
           TRANS_HIST_SEQ_NO AS TIME)), CAST(TRANS_HIST_SEQ_NO
            AS TIME)) = CIS.CHAR2TIME(:WS-TIME)                    
T35434                                                           
T24339     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     09860000
MFA-TR*       SELECT TRANS_HIST_SEQ_NO                                  09870000
MFA-TR*       INTO :WS-ADJ-TRANS-HIST-SEQ-NO                            09880000
MFA-TR*         FROM CSS_AR_TRANS_HIST                                  09890000
MFA-TR*       WHERE ACCOUNT_NO = :AR-ACCOUNT-NO                         09900000
MFA-TR*       AND TRANS_HIST_SEQ_NO <= :AR-TRANS-HIST-SEQ-NO            09910000
MFA-TR*       AND DATE_TRANS = :AR-DATE-TRANS                                   
MFA-TR*       AND CODE_TRAN_TYPE = 'A'                                  09920000
MFA-TR*       AND APPL_PROGRAM_ID = 'PANEL113H'                                 
MFA-TR*       AND DATE(TRANS_HIST_SEQ_NO) = :WS-DATE                    09930000
MFA-TR*       AND TIME(TRANS_HIST_SEQ_NO) = :WS-TIME                    09930000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    09940000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T24339                                                                  
T24339     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T24339     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T24339        OR NOT-FOUND OR WS-FOUND-MULT-BILLS                       
T24339        NEXT SENTENCE                                             
T24339     ELSE                                                         
T24339        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
T24339        MOVE '7251'                    TO ACTIVE-PARAGRAPH        
T24339        MOVE 'SELECT'                  TO ABEND-FUNCTION          
T24339        MOVE 'CSS_AR_TRANS_HIST'       TO TABLE-1                 
T24339        MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
T24339        MOVE AR-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
T24339        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
T24339        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
T24339 7251-EXIT.                                                       
T24339     EXIT.                                                        
                                                                        
                                                                        
      ****************************************************************  10130000
      * 7300-PROCESS-DNP.                                           *   10140000
      * CHECK IF THE FIRST CHARACTOR IN DISCCONNECT_HIST AND        *   10150000
      * DISC_EXCEPTN_HIST = R IF SO SEND BACK FLAG TO INDICATE A    *   10160000
      * DNP MESSAGE NEEDS TO GO BACK TO THE USER.                   *   10170000
      ****************************************************************  10180000
       7300-PROCESS-DNP.                                                
           EXEC SQL                                                     
              SELECT 'Y'                                                
              INTO :WS-R                                                
                FROM CSS_CREDIT_PROFILE WITH(READUNCOMMITTED)                   
              WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                         
TP6219        AND ( CIS.SUBSTR3(DISCONNECT_HIST,1,1) IN ('R')                
TP6219         OR CIS.SUBSTR3(DISC_EXCEPTN_HIST,1,1) IN ('R'))               
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                     10200000
MFA-TR*       SELECT 'Y'                                                10210000
MFA-TR*       INTO :WS-R                                                10220000
MFA-TR*         FROM CSS_CREDIT_PROFILE                                 10230000
MFA-TR*       WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                         10240000
MFA-TR*       AND ( SUBSTR(DISCONNECT_HIST,1,1) IN ('R')                10250000
MFA-TR*        OR SUBSTR(DISC_EXCEPTN_HIST,1,1) IN ('R'))               10260000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    10270000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              OR NOT-FOUND                                              
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7300'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_CREDIT_PROFILE'      TO TABLE-1                 
CBSI          MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE CZ-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
CBSI          PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8110-DELETE-LI-ROW.                                              
      ******************************************************************10420200
      **  THIS PARAGRAPH IS USED TO INSERT A ROW IN THE               **10420300
      **  CSS_LIEAP   TABLE                                           **10420400
      ******************************************************************10420500
      *                                                                 10420600
CBSI       MOVE '8110'               TO ACTIVE-PARAGRAPH.               
           EXEC SQL                                                     
             DELETE FROM  CSS_LIEAP                                     
             WHERE                                                      
                  ACCOUNT_NO         = :LI-ACCOUNT-NO              
                  AND VOUCHER_PAY_DT = CIS.CHAR2TIMESTAMP(
                                                     :LI-VOUCHER-PAY-DT
              )              
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     10420800
MFA-TR*      DELETE FROM  CSS_LIEAP                                     10420900
MFA-TR*      WHERE                                                      10421000
MFA-TR*           ACCOUNT_NO         = :     LI-ACCOUNT-NO              10421100
MFA-TR*           AND VOUCHER_PAY_DT = : LI-VOUCHER-PAY-DT              10421200
MFA-TR*                                                                 10421300
MFA-TR*    END-EXEC.                                                    10421400

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          RS-RETURN-CODE.               
      *                                                                 10421800
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
T19163        (WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND AND                
T19163         PARM-PANEL-NO = 'PANEL118')                              
T19163        MOVE ZERO  TO WS-ACTIVE-RETURN-CODE                       
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'DELETE'                   TO ABEND-FUNCTION         
              MOVE 'CSS_LIEAP'            TO TABLE-1                    
              MOVE 'ACCOUNT-NO    '           TO TABLE-ELEMENT-1        
CBSI          MOVE 'VOUCHER_PAY_DT'           TO TABLE-ELEMENT-2        
              MOVE LI-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE LI-VOUCHER-PAY-DT          TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       8110-EXIT.                                                       
           EXIT.                                                        
                                                                        
T22428*****************************************************************         
T22428* CALLS THE SUBPROGRAM SCSCA182                                           
T22428*****************************************************************         
T22428*                                                                         
T22428 9200-LINK-SCSCA182.                                              
T22428*                                                                         
T22428     MOVE '9200'                        TO ACTIVE-PARAGRAPH.      
T22428                                                                  
REARCH     CALL MCSCA182  USING  SCSCA182-ACCOUNT-NO                    
REARCH                          ,SCSCA182-RETURN-CODE                   
REARCH                          ,SCSCA182-LAST-UPDATE-TS                
REARCH                          ,ABEND-FILE.                            
T22428 9200-EXIT.                                                       
T22428     EXIT.                                                        
T22428*                                                                         
      ******************************************************************10470000
      *  INCLUDE COPYBOOKS FOR AR LOCKOUT AND AT XREF.                 *10480000
      ******************************************************************10490000
      *                                                                 10500000
           EXEC SQL                                                     10510000
              INCLUDE CPD00075                                          10520000
           END-EXEC.                                                    10530000
      *                                                                 10540000
           EXEC SQL                                                     10550000
              INCLUDE CPD00307                                          10560000
           END-EXEC.                                                    10570000
T22428*                                                                         
T22428     EXEC SQL                                                             
T22428        INCLUDE CPD0023C                                                  
T22428     END-EXEC.                                                            
      *                                                                 10580000
      ******************************************************************10590000
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *10600000
      ******************************************************************10610000
                                                                        
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
                                                                        
      ******************************************************************12710000
      *       END PROGRAM COPYLIB                                      *12720000
      ******************************************************************12730000
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPD00321                                                  
REARCH     END-EXEC.                                                            
                                                                        
