       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02178.                                         
COB303 DATE-WRITTEN. SEPTEMBER 19, 2005.                                 
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S178 CONVERTED TO DB2 SP CSR02178 ON 09/19/2005        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S178                                           *        
      *  PROGRAM:       S178                                           *        
      *  CALLING SP:    PA_S178                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *        
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *        
      *  THIS PROGRAM RETRIEVES THE DATA DISPLAYED IN  WINDOW OF       *        
      *  PANEL324                                                      *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *                                                                *        
T16330*  05/18/98    RAH      PANEL IS ONLY SHOWING 4 YEARS OF HISTORY *        
      *                       INSTEAD OF 5.                            *        
CBSI  *  08/01/99   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *             MADRAS    ABEND PARAMETERS                         *        
REARCH*  09/19/05   CVNS      RPC TO DB2 COBOL CONVERSION.             *        
REARCH*             CHENNAI                                            *        
A04527*  06/07/13    MR7E794  REMOVED UNUSED COPYBOOK CWS00056.        *        
P00724*  10/15/13    JC91900  Add IC and Util type as two columns.     *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02178'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02178 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBANLSUM                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *--------< CONTAINS THE COBOL EQUATES NEEDED FOR USING THE >              
      *--------< SYBASE OPEN SERVER FOR CICS FACILITIES.         >              
CVT999*    COPY SYGWCOB.                                                        
                                                                        
      *--------< ADDED TO SUPPORT CICS RPCS >                                   
CVT999*    COPY SYDBCOB.                                                        
                                                                        
      *--------<COMMON SYSTEM AREA >                                            
           COPY CCA00001.                                                       
                                                                        
      *--------< ERROR HANDLING >                                               
CVT999*    COPY CWS00010.                                                       
                                                                        
      *--------< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >               
           COPY CWS00027.                                                       
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                          
           COPY CWS00303.                                                       
                                                                        
                                                                        
       01  WS-MISC.                                                     
           05 WS-D                     PIC X(01) VALUE 'D'.             
           05 WS-E                     PIC X(01) VALUE 'E'.             
           05 WS-IC-NUM                PIC 9(06) VALUE 0.               
           05 WS-IC-NUM-CHAR     REDEFINES WS-IC-NUM                    
                                       PIC X(06).                       
           05 WS-CURRENT-YEAR          PIC S9(04)V COMP-3 VALUE 0.      
           05 WS-CURRENT-YEAR-NUM      PIC 9(04)  VALUE 0.              
           05 WS-CURR-DATE             PIC X(10)  VALUE SPACES.         
           05 WS-CURRENT-DATE.                                          
              10 WS-CURRENT-CCYY          PIC X(04) VALUE SPACES.       
              10 FILLER                   PIC X(01) VALUE SPACES.       
              10 WS-CURRENT-MM            PIC X(02) VALUE SPACES.       
              10 FILLER                   PIC X(01) VALUE SPACES.       
              10 WS-CURRENT-DD            PIC X(02) VALUE SPACES.       
           05 WS-DUMMY-DATE            PIC X(10) VALUE SPACES.          
           05 WS-NULL-IND              PIC S9(04) COMP.                 
           05 WS-PREV-UTIL-IC-NO       PIC X(08) VALUE SPACES.          
           05 WS-UTIL-IC-NO.                                            
              10 WS-CODE-UTIL-TYPE        PIC X(01) VALUE SPACES.       
              10 FILLER                   PIC X(01) VALUE SPACES.       
              10 WS-IC-NO                 PIC X(06) VALUE SPACES.       
           05 WS-COUNT                 PIC S9(04) COMP VALUE 0.         
REARCH*    05 PROGRAM-NAME             PIC X(8)  VALUE 'S178    '.              
REARCH     05 PROGRAM-NAME             PIC X(8)  VALUE 'CSR02178'.      
                                                                        
       01  SWITCHES.                                                    
           05  WS-MST-SUB-ACCT-IND     PIC X(01) VALUE SPACES.          
               88 MASTER-ACCOUNT                 VALUE 'M'.             
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
HPCCDM*    EJECT                                                        00096000
       01  GW-LIB-MISC-FIELDS.                                          
CVT999*    05  GWL-PROC                POINTER.                                 
CVT999*    05  GWL-INIT-HANDLE         POINTER.                                 
CVT999*    05  GWL-RC                  PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-NR           PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-DONE         PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-COUNT        PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-COMM         PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-RETURN-CODE  PIC S9(9) COMP.                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
      *                                                                         
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9) COMP.                  
CVT999*    05  PARM-ID1                PIC S9(9) COMP VALUE 1.                  
           05  PARM-ACCOUNT-NO         PIC X(13).                       
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
CVT999*    05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.                  
                                                                        
       01  COUNTER-FIELDS.                                              
CVT999*    05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.                  
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
CVT999*    05  MAX-LENGTH-PARM         PIC S9(9) COMP.                          
CVT999*    05  WRKLEN1                 PIC S9(9) COMP.                          
CVT999*    05  WRKLEN2                 PIC S9(9) COMP.                          
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
REARCH 01  TDS-RETURN-FIELDS.                                           
            05 RS-RETURN-CODE         PIC S9(9) COMP VALUE 0.           
            05 RS-UTIL-IC-NO          PIC X(08) VALUE SPACES.           
            05 RS-COUNT               PIC S9(04) COMP VALUE 0.          
            05 RS-SUMMARY-YEAR        PIC S9(04)V COMP-3 VALUE 0.       
            05 RS-TOTAL-USAGE         PIC S9(09)V99 COMP-3 VALUE 0.     
            05 RS-NO-DAYS             PIC S9(04) COMP VALUE 0.          
            05 RS-TOTAL-REVENUE       PIC S9(09)V99 COMP-3 VALUE 0.     
P00724      05 RS-IC-NO               PIC S9(04) COMP VALUE 0.          
P00724      05 RS-UTILITY-TYPE        PIC X(01)  VALUE SPACES.          
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH      05 S-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
REARCH      05 S-UTIL-IC-NO           PIC X(08) VALUE SPACES.           
REARCH      05 S-COUNT                PIC S9(04) COMP VALUE 0.          
REARCH      05 S-SUMMARY-YEAR         PIC S9(04)V COMP-3 VALUE 0.       
REARCH      05 S-TOTAL-USAGE          PIC S9(09)V99 COMP-3 VALUE 0.     
REARCH      05 S-NO-DAYS              PIC S9(04) COMP VALUE 0.          
REARCH      05 S-TOTAL-REVENUE        PIC S9(09)V99 COMP-3 VALUE 0.     
P00724      05 S-IC-NO                PIC S9(04) COMP VALUE 0.          
P00724      05 S-UTILITY-TYPE         PIC X(01)  VALUE SPACES.          
                                                                        
CVT999*01  CNS-COLUMN-NAMES.                                                    
CVT999*     05 CNS-RETURN-CODE        PIC X(11) VALUE 'RETURN_CODE'.            
CVT999*     05 CNS-UTIL-IC-NO         PIC X(10) VALUE 'UTIL_IC_NO'.             
CVT999*     05 CNS-COUNT              PIC X(05) VALUE                           
CVT999*                                         'COUNT'.                        
CVT999*     05 CNS-SUMMARY-YEAR       PIC X(12) VALUE                           
CVT999*                                         'SUMMARY_YEAR'.                 
CVT999*     05 CNS-TOTAL-USAGE        PIC X(11) VALUE                           
CVT999*                                         'TOTAL_USAGE'.                  
CVT999*     05 CNS-NO-DAYS            PIC X(07) VALUE                           
CVT999*                                         'NO_DAYS'.                      
CVT999*     05 CNS-TOTAL-REVENUE      PIC X(13) VALUE                           
CVT999*                                         'TOTAL_REVENUE'.                
CVT999******************************************************************        
CVT999*    CURSOR DECLARATIONS                                         *        
CVT999******************************************************************        
CVT999*                                                                         
CVT999******************************************************************        
CVT999**  THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING A SET OF   **        
CVT999**  ROWS FROM THE CSS_MOVEMENT_HIST TABLE.                      **        
CVT999******************************************************************        
           EXEC SQL                                                     
             DECLARE AS-CURSOR CURSOR FOR                               
             SELECT CODE_UTIL_TYPE,                                     
                    IC_NO,                                              
                    NO_DAYS,                                            
                    SUMMARY_YEAR,                                       
                    TOTAL_REVENUE,                                      
                    TOTAL_USAGE                                         
                   FROM CSS_ANNUAL_SUMMARY                              
                   WHERE  (ACCOUNT_NO       = :AS-ACCOUNT-NO) AND       
T16330                    (SUMMARY_YEAR > :WS-CURRENT-YEAR - 7) AND     
                          (SUMMARY_YEAR < :WS-CURRENT-YEAR)             
                   ORDER BY CODE_UTIL_TYPE ASC,                         
                            IC_NO ASC,                                  
                            SUMMARY_YEAR DESC                           
           END-EXEC.                                                    
HPCCDM*EJECT                                                                    
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
REARCH*    10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        00001701
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         DECLARE C1 CURSOR  FOR                        
CVT000         SELECT                                                   
REARCH             RETURN_CODE                AS RETURN_CODE            
REARCH            ,LTRIM(RTRIM(UTIL_IC_NO))          AS UTIL_IC_NO             
REARCH            ,COUNT                      AS COUNT                  
REARCH            ,SUMMARY_YEAR               AS SUMMARY_YEAR           
REARCH            ,TOTAL_USAGE                AS TOTAL_USAGE            
REARCH            ,NO_DAYS                    AS NO_DAYS                
REARCH            ,TOTAL_REVENUE              AS TOTAL_REVENUE          
P00724            ,IC_NO                      AS IC_NO                  
P00724            ,UTILITY_TYPE               AS UTILITY_TYPE           
CVT000         FROM #CSR02178_R1                                 
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00000100
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        00000300
MFA-TR*        SELECT                                                   00000400
MFA-TR*            RETURN_CODE                AS RETURN_CODE                    
MFA-TR*           ,STRIP(UTIL_IC_NO)          AS UTIL_IC_NO                     
MFA-TR*           ,COUNT                      AS COUNT                          
MFA-TR*           ,SUMMARY_YEAR               AS SUMMARY_YEAR                   
MFA-TR*           ,TOTAL_USAGE                AS TOTAL_USAGE                    
MFA-TR*           ,NO_DAYS                    AS NO_DAYS                        
MFA-TR*           ,TOTAL_REVENUE              AS TOTAL_REVENUE                  
MFA-TR*           ,IC_NO                      AS IC_NO                          
MFA-TR*           ,UTILITY_TYPE               AS UTILITY_TYPE                   
MFA-TR*        FROM SESSION.CSR02178_R1                                 00000500
MFA-TR*    END-EXEC.                                                    00000700
CVT000                                                                  
                                                                        
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-ACCOUNT-NO          PIC X(13)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-ACCOUNT-NO                                         
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                                      
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
CVT999*    EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.                      
                                                                        
CVT999*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.             
                                                                        
CVT999*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,             
CVT999*                          SNA-CONNECTION-NAME, SNA-SUBC.                 
                                                                        
CVT999*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                              
                                                                        
CVT999*    IF GWL-RC NOT = TDS-PARM-PRESENT                                     
CVT999*       MOVE PROGRAM-NAME         TO ABEND-PROGRAM                        
CVT999*       MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION              
CVT999*       MOVE 'CICS TRANSACTION'   TO TABLE-1                              
CVT999*       MOVE GWL-RC               TO WS-ACTIVE-RETURN-CODE                
CVT999*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
CVT999*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
CVT999*    END-IF.                                                              
                                                                        
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
CVT000     PERFORM 0100A-DECLARE-GTT                                    
CVT000       THRU 0100A-EXIT.                                           
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
CVT000 0100A-DECLARE-GTT.                                               
CVT000     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02178_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02178_R1
              (                                                          
CVT000         RETURN_CODE              INT                         
CVT000        ,UTIL_IC_NO CHAR(08)  COLLATE LATIN1_GENERAL_100_BIN2             
CVT000        ,COUNT                    SMALLINT                        
CVT000        ,SUMMARY_YEAR             DECIMAL(04,0)                   
CVT000        ,TOTAL_USAGE              DECIMAL(11,2)                   
CVT000        ,NO_DAYS                  SMALLINT                        
CVT000        ,TOTAL_REVENUE            DECIMAL(11,2)                   
P00724        ,UTILITY_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2           
P00724        ,IC_NO                    SMALLINT                        
CVT000       )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR02178_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
CVT000 0100A-EXIT.                                                      
CVT000         EXIT.                                                    
                                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     CALLS 1100-RECEIVE-PARMS                                   *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
      *                                                                         
REARCH*    PERFORM 1100-RECEIVE-PARMS THRU 1100-EXIT.                           
           MOVE PARM-ACCOUNT-NO         TO AS-ACCOUNT-NO.               
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1100-RECEIVE-PARMS                                             *        
      *     CALLS TDRCVPRM                                             *        
      *                                                                *        
      *     CALLED FROM 1000-PROCESS-INPUT                             *        
      *                                                                *        
      *     GET THE PASSED PARMS FROM THE CLIENT                       *        
      ******************************************************************        
                                                                        
REARCH*1100-RECEIVE-PARMS.                                                      
                                                                        
CVT999*    MOVE 1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-ACCOUNT-NO        TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-ACCOUNT-NO,                               
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
                                                                        
                                                                        
REARCH*1100-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     CALLS 2100-DESCRIBE-RESULT                                 *        
      *           2200-BUILD-RESULT                                    *        
      *     CALLED FROM 0000-MAINLINE                                 *         
      *                                                                *        
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *        
      *      AND SENDS THEM BACK                                       *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                           TO ACTIVE-PARAGRAPH.   
REARCH*    PERFORM 2100-DESCRIBE-RESULT          THRU 2100-EXIT.                
           PERFORM 2200-BUILD-RESULT             THRU 2200-EXIT.        
       2000-EXIT.                                                       
           EXIT.                                                        
REARCH******************************************************************        
REARCH*2000A-MOVE-RESULT.                                                       
REARCH******************************************************************        
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE RS-RETURN-CODE         TO S-RETURN-CODE.                
REARCH     MOVE RS-UTIL-IC-NO          TO S-UTIL-IC-NO.                 
REARCH     MOVE RS-COUNT               TO S-COUNT.                      
REARCH     MOVE RS-SUMMARY-YEAR        TO S-SUMMARY-YEAR.               
REARCH     MOVE RS-TOTAL-USAGE         TO S-TOTAL-USAGE.                
REARCH     MOVE RS-NO-DAYS             TO S-NO-DAYS.                    
REARCH     MOVE RS-TOTAL-REVENUE       TO S-TOTAL-REVENUE.              
P00724     MOVE RS-UTILITY-TYPE        TO S-UTILITY-TYPE.               
P00724     MOVE RS-IC-NO               TO S-IC-NO.                      
                                                                        
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
                                                                        
       2200-BUILD-RESULT.                                               
                                                                        
              MOVE '2200'                TO ACTIVE-PARAGRAPH.           
              MOVE PARM-ACCOUNT-NO       TO AS-ACCOUNT-NO.              
              PERFORM 2205-BUILD-AS    THRU 2205-EXIT.                  
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
                                                                        
      ******************************************************************        
      * 2205-BUILD-AS                                                  *        
      *                                                                *        
      *     CALLED FROM 2200-BUILD-RESULT                              *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
                                                                        
       2205-BUILD-AS.                                                   
                                                                        
           MOVE '2205'               TO ACTIVE-PARAGRAPH.               
                                                                        
           PERFORM 7111-GET-CURRENT-YEAR THRU 7111-EXIT.                
           PERFORM 7100-OPEN-AS-CURSOR  THRU  7100-EXIT.                
      *    MOVE 1                       TO WS-COUNT.                            
           PERFORM 7110-FETCH-AS-ROW    THRU  7110-EXIT.                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE SPACES          TO RS-UTIL-IC-NO                    
               MOVE ZEROES          TO RS-SUMMARY-YEAR                  
               MOVE ZEROES          TO RS-TOTAL-USAGE                   
               MOVE ZEROES          TO RS-NO-DAYS                       
               MOVE ZEROES          TO RS-TOTAL-REVENUE                 
               MOVE ZEROES          TO RS-COUNT                         
REARCH         PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                
               PERFORM 8100-SEND-RESULT THRU 8100-EXIT                  
REARCH         MOVE NOT-FOUND       TO WS-ACTIVE-RETURN-CODE            
           END-IF                                                       
                                                                        
           PERFORM 2210-PROCESS-AS-CURSOR   THRU 2210-EXIT              
           UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                     
                                                                        
           PERFORM 7120-CLOSE-AS-CURSOR THRU 7120-EXIT.                 
       2205-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2210-PROCESS-AS-CURSOR                                         *        
      *                                                                *        
      *     CALLED FROM 2205-BUILD-AS                                  *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
                                                                        
       2210-PROCESS-AS-CURSOR.                                          
                                                                        
           MOVE '2210'               TO ACTIVE-PARAGRAPH.               
                                                                        
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE AS-NO-DAYS            TO RS-NO-DAYS                 
               MOVE AS-SUMMARY-YEAR       TO RS-SUMMARY-YEAR            
               MOVE AS-TOTAL-REVENUE      TO RS-TOTAL-REVENUE           
               MOVE AS-TOTAL-USAGE        TO RS-TOTAL-USAGE             
               MOVE AS-CODE-UTIL-TYPE     TO WS-CODE-UTIL-TYPE          
P00724                                       RS-UTILITY-TYPE            
               MOVE AS-IC-NO              TO WS-IC-NUM                  
P00724                                       RS-IC-NO                   
               MOVE WS-IC-NUM-CHAR        TO WS-IC-NO                   
                                                                        
               IF WS-UTIL-IC-NO EQUAL WS-PREV-UTIL-IC-NO                
                  ADD 1     TO WS-COUNT                                 
               ELSE                                                     
                  MOVE 1    TO WS-COUNT                                 
               END-IF                                                   
               MOVE WS-UTIL-IC-NO        TO RS-UTIL-IC-NO               
                                            WS-PREV-UTIL-IC-NO          
               MOVE WS-COUNT             TO RS-COUNT                    
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE SPACES                TO RS-UTIL-IC-NO              
P00724         MOVE SPACES                TO RS-UTILITY-TYPE            
P00724         MOVE ZEROES                TO RS-IC-NO                   
               MOVE ZEROES                TO RS-NO-DAYS                 
               MOVE ZEROES                TO RS-SUMMARY-YEAR            
               MOVE ZEROES                TO RS-TOTAL-REVENUE           
               MOVE ZEROES                TO RS-TOTAL-USAGE             
               MOVE ZEROES                TO RS-COUNT                   
           END-IF                                                       
                                                                        
                                                                        
           PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                    
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT                      
           PERFORM 7110-FETCH-AS-ROW    THRU  7110-EXIT.                
                                                                        
       2210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*EJECT                                                                    
       7100-OPEN-AS-CURSOR.                                             
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OPEN THE CURSOR USED TO FETCH     **        
      **  ROWS FROM THE CSS_ANNUAL_SUMMARY TABLE.                     **        
      ******************************************************************        
      *                                                                         
           MOVE '7100'               TO ACTIVE-PARAGRAPH.               
           EXEC SQL                                                     
               OPEN AS-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'CSS_ANNUAL_SUMMARY'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE 'SUMMARY_YEAR'             TO TABLE-ELEMENT-2        
              MOVE AS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE WS-CURRENT-YEAR            TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
HPCCDM*EJECT                                                                    
       7110-FETCH-AS-ROW.                                               
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OBTAIN THE NEXT ROW FROM THE      **        
      **  CSS_ANNUAL_SUMMARY TABLE.                                   **        
      ******************************************************************        
      *                                                                         
           MOVE '7110'               TO ACTIVE-PARAGRAPH.               
           EXEC SQL                                                     
               FETCH AS-CURSOR                                          
               INTO :AS-CODE-UTIL-TYPE,                                 
                    :AS-IC-NO,                                          
                    :AS-NO-DAYS,                                        
                    :AS-SUMMARY-YEAR,                                   
                    :AS-TOTAL-REVENUE,                                  
                    :AS-TOTAL-USAGE                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                                         OR NOT-FOUND                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'FETCH'                    TO ABEND-FUNCTION         
              MOVE 'CSS_ANNUAL_SUMMARY'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE 'SUMMARY_YEAR'             TO TABLE-ELEMENT-2        
              MOVE AS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE WS-CURRENT-YEAR            TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
       7110-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
       7120-CLOSE-AS-CURSOR.                                            
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO CLOSE THE CURSOR USED TO FETCH    **        
      **  ROWS FROM THE CSS_ANNUAL_SUMMARY TABLE.                     **        
      ******************************************************************        
      *                                                                         
           MOVE '7120'               TO ACTIVE-PARAGRAPH.               
           EXEC SQL                                                     
               CLOSE AS-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE 'CSS_ANNUAL_SUMMARY'       TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE 'SUMMARY_YEAR'             TO TABLE-ELEMENT-2        
              MOVE AS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
CBSI          MOVE WS-CURRENT-YEAR            TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
       7120-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
                                                                        
      ******************************************************************        
      * 7111-GET-CURRENT-YEAR                                          *        
      *                                                                *        
      *     CALLED FROM 2210-PROCESS-MV-CURSOR                         *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
                                                                        
       7111-GET-CURRENT-YEAR.                                           
                                                                        
           MOVE '7111'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURR-DATE                        
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURR-DATE = CURRENT DATE                                
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               MOVE WS-CURR-DATE         TO WS-CURRENT-DATE             
               MOVE WS-CURRENT-CCYY      TO WS-CURRENT-YEAR-NUM         
               MOVE WS-CURRENT-YEAR-NUM  TO WS-CURRENT-YEAR             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SET'                      TO ABEND-FUNCTION         
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE AS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7111-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                 08730500
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
CVT999*    COPY CPD00302.                                                       
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000     EXEC SQL                                                     
CVT000       INSERT INTO #CSR02178_R1                            
CVT000       (                                                          
CVT000        RETURN_CODE                                               
CVT000       ,UTIL_IC_NO                                                
CVT000       ,COUNT                                                     
CVT000       ,SUMMARY_YEAR                                              
CVT000       ,TOTAL_USAGE                                               
CVT000       ,NO_DAYS                                                   
CVT000       ,TOTAL_REVENUE                                             
P00724       ,IC_NO                                                     
P00724       ,UTILITY_TYPE                                              
CVT000       )                                                          
CVT000       VALUES                                                     
CVT000       (                                                          
REARCH        :S-RETURN-CODE                                            
REARCH       ,:S-UTIL-IC-NO                                             
REARCH       ,:S-COUNT                                                  
REARCH       ,:S-SUMMARY-YEAR                                           
REARCH       ,:S-TOTAL-USAGE                                            
REARCH       ,:S-NO-DAYS                                                
REARCH       ,:S-TOTAL-REVENUE                                          
P00724       ,:S-IC-NO                                                  
P00724       ,:S-UTILITY-TYPE                                           
CVT000       )                                                          
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR02178_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,UTIL_IC_NO                                                        
MFA-TR*      ,COUNT                                                             
MFA-TR*      ,SUMMARY_YEAR                                                      
MFA-TR*      ,TOTAL_USAGE                                                       
MFA-TR*      ,NO_DAYS                                                           
MFA-TR*      ,TOTAL_REVENUE                                                     
MFA-TR*      ,IC_NO                                                             
MFA-TR*      ,UTILITY_TYPE                                                      
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE                                                    
MFA-TR*      ,:S-UTIL-IC-NO                                                     
MFA-TR*      ,:S-COUNT                                                          
MFA-TR*      ,:S-SUMMARY-YEAR                                                   
MFA-TR*      ,:S-TOTAL-USAGE                                                    
MFA-TR*      ,:S-NO-DAYS                                                        
MFA-TR*      ,:S-TOTAL-REVENUE                                                  
MFA-TR*      ,:S-IC-NO                                                          
MFA-TR*      ,:S-UTILITY-TYPE                                                   
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
CVT000                                                                  
CVT000     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
CVT000        NEXT SENTENCE                                             
CVT000     ELSE                                                         
CVT000        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
REARCH        MOVE '8100'               TO ACTIVE-PARAGRAPH             
CVT000        MOVE 'INSERT'             TO ABEND-FUNCTION               
CVT000        MOVE 'CSR02178_R1'        TO TABLE-1                      
CVT000        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
CVT000     END-IF.                                                      
CVT000                                                                  
CVT000     ADD 1 TO CTR-ROWS.                                           
CVT000*    INITIALIZE GTT-RETURN-FIELDS.                                00001900
CVT000*                                                                 00002000
CVT000 8100-EXIT.                                                       
CVT000      EXIT.                                                       
CVT000******************************************************************00000100
CVT000* 8000A-DELETE-GTT-ROWS.                                         *00000200
CVT000******************************************************************00000300
CVT000 8000A-DELETE-GTT-ROWS.                                           
CVT000*                                                                 00000500
CVT000     MOVE                                                         
CVT000     'DELETE ROWS'                                                
CVT000         TO S-SQL-STATEMENT-V.                                    
CVT000*                                                                 00000900
CVT000      EXEC SQL                                                    
CVT000          DELETE FROM #CSR02178_R1                         
CVT000      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    00001000
MFA-TR*         DELETE FROM SESSION.CSR02178_R1                         00001100
MFA-TR*     END-EXEC.                                                   00001200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000*                                                                 00001300
CVT000      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
CVT000*                                                                 00001500
CVT000      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
CVT000          NEXT SENTENCE                                           
CVT000      ELSE                                                        
CVT000         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
CVT000         MOVE '8000A'              TO ACTIVE-PARAGRAPH            
CVT000         MOVE 'DELETE'             TO ABEND-FUNCTION              
CVT000         MOVE SPACES               TO ABEND-SQL-PREDICATES        
CVT000                                      ABEND-TABLES                
CVT000         MOVE 'CSR02178_R1'        TO TABLE-1                     
CVT000         MOVE SPACES               TO TABLE-ELEMENT-1             
CVT000         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
CVT000         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
CVT000     END-IF.                                                      
CVT000*                                                                 00003100
CVT000 8000A-EXIT.                                                      
CVT000     EXIT.                                                        
CVT000*                                                                 00003400
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00320                                         00000200
CVT000     END-EXEC.                                                    00000300
